/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;

public abstract class PushPostingsWriterBase
extends PostingsWriterBase {
    private DocsEnum docsEnum;
    private DocsAndPositionsEnum posEnum;
    private int enumFlags;
    protected FieldInfo fieldInfo;
    protected IndexOptions indexOptions;
    protected boolean writeFreqs;
    protected boolean writePositions;
    protected boolean writePayloads;
    protected boolean writeOffsets;

    protected PushPostingsWriterBase() {
    }

    public abstract BlockTermState newTermState() throws IOException;

    public abstract void startTerm() throws IOException;

    public abstract void finishTerm(BlockTermState var1) throws IOException;

    @Override
    public int setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.indexOptions = fieldInfo.getIndexOptions();
        this.writeFreqs = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        this.writePositions = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        this.writeOffsets = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        this.writePayloads = fieldInfo.hasPayloads();
        this.enumFlags = !this.writeFreqs ? 0 : (!this.writePositions ? 1 : (!this.writeOffsets ? (this.writePayloads ? 2 : 0) : (this.writePayloads ? 3 : 1)));
        return 0;
    }

    @Override
    public final BlockTermState writeTerm(BytesRef term, TermsEnum termsEnum, FixedBitSet docsSeen) throws IOException {
        int docID;
        this.startTerm();
        if (!this.writePositions) {
            this.docsEnum = termsEnum.docs(null, this.docsEnum, this.enumFlags);
        } else {
            this.posEnum = termsEnum.docsAndPositions(null, this.posEnum, this.enumFlags);
            this.docsEnum = this.posEnum;
        }
        assert (this.docsEnum != null);
        int docFreq = 0;
        long totalTermFreq = 0L;
        while ((docID = this.docsEnum.nextDoc()) != Integer.MAX_VALUE) {
            int freq;
            ++docFreq;
            docsSeen.set(docID);
            if (this.writeFreqs) {
                freq = this.docsEnum.freq();
                totalTermFreq += (long)freq;
            } else {
                freq = -1;
            }
            this.startDoc(docID, freq);
            if (this.writePositions) {
                for (int i = 0; i < freq; ++i) {
                    int endOffset;
                    int startOffset;
                    BytesRef payload;
                    int pos = this.posEnum.nextPosition();
                    BytesRef bytesRef = payload = this.writePayloads ? this.posEnum.getPayload() : null;
                    if (this.writeOffsets) {
                        startOffset = this.posEnum.startOffset();
                        endOffset = this.posEnum.endOffset();
                    } else {
                        startOffset = -1;
                        endOffset = -1;
                    }
                    this.addPosition(pos, payload, startOffset, endOffset);
                }
            }
            this.finishDoc();
        }
        if (docFreq == 0) {
            return null;
        }
        BlockTermState state = this.newTermState();
        state.docFreq = docFreq;
        state.totalTermFreq = this.writeFreqs ? totalTermFreq : -1L;
        this.finishTerm(state);
        return state;
    }

    public abstract void startDoc(int var1, int var2) throws IOException;

    public abstract void addPosition(int var1, BytesRef var2, int var3, int var4) throws IOException;

    public abstract void finishDoc() throws IOException;
}

