/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

class FreqProxFields
extends Fields {
    final Map<String, FreqProxTermsWriterPerField> fields = new LinkedHashMap<String, FreqProxTermsWriterPerField>();

    public FreqProxFields(List<FreqProxTermsWriterPerField> fieldList) {
        for (FreqProxTermsWriterPerField field : fieldList) {
            this.fields.put(field.fieldInfo.name, field);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.fields.keySet().iterator();
    }

    @Override
    public Terms terms(String field) throws IOException {
        FreqProxTermsWriterPerField perField = this.fields.get(field);
        return perField == null ? null : new FreqProxTerms(perField);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    private static class FreqProxDocsAndPositionsEnum
    extends DocsAndPositionsEnum {
        final FreqProxTermsWriterPerField terms;
        final FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray;
        final ByteSliceReader reader = new ByteSliceReader();
        final ByteSliceReader posReader = new ByteSliceReader();
        final boolean readOffsets;
        int docID;
        int freq;
        int pos;
        int startOffset;
        int endOffset;
        int posLeft;
        int termID;
        boolean ended;
        boolean hasPayload;
        BytesRefBuilder payload = new BytesRefBuilder();

        public FreqProxDocsAndPositionsEnum(FreqProxTermsWriterPerField terms, FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray) {
            this.terms = terms;
            this.postingsArray = postingsArray;
            this.readOffsets = terms.hasOffsets;
            assert (terms.hasProx);
            assert (terms.hasFreq);
        }

        public void reset(int termID) {
            this.termID = termID;
            this.terms.initReader(this.reader, termID, 0);
            this.terms.initReader(this.posReader, termID, 1);
            this.ended = false;
            this.docID = 0;
            this.posLeft = 0;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() {
            return this.freq;
        }

        @Override
        public int nextDoc() throws IOException {
            while (this.posLeft != 0) {
                this.nextPosition();
            }
            if (this.reader.eof()) {
                if (this.ended) {
                    return Integer.MAX_VALUE;
                }
                this.ended = true;
                this.docID = this.postingsArray.lastDocIDs[this.termID];
                this.freq = this.postingsArray.termFreqs[this.termID];
            } else {
                int code = this.reader.readVInt();
                this.docID += code >>> 1;
                this.freq = (code & 1) != 0 ? 1 : this.reader.readVInt();
                assert (this.docID != this.postingsArray.lastDocIDs[this.termID]);
            }
            this.posLeft = this.freq;
            this.pos = 0;
            this.startOffset = 0;
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posLeft > 0);
            --this.posLeft;
            int code = this.posReader.readVInt();
            this.pos += code >>> 1;
            if ((code & 1) != 0) {
                this.hasPayload = true;
                this.payload.setLength(this.posReader.readVInt());
                this.payload.grow(this.payload.length());
                this.posReader.readBytes(this.payload.bytes(), 0, this.payload.length());
            } else {
                this.hasPayload = false;
            }
            if (this.readOffsets) {
                this.startOffset += this.posReader.readVInt();
                this.endOffset = this.startOffset + this.posReader.readVInt();
            }
            return this.pos;
        }

        @Override
        public int startOffset() {
            if (!this.readOffsets) {
                throw new IllegalStateException("offsets were not indexed");
            }
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            if (!this.readOffsets) {
                throw new IllegalStateException("offsets were not indexed");
            }
            return this.endOffset;
        }

        @Override
        public BytesRef getPayload() {
            if (this.hasPayload) {
                return this.payload.get();
            }
            return null;
        }
    }

    private static class FreqProxDocsEnum
    extends DocsEnum {
        final FreqProxTermsWriterPerField terms;
        final FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray;
        final ByteSliceReader reader = new ByteSliceReader();
        final boolean readTermFreq;
        int docID;
        int freq;
        boolean ended;
        int termID;

        public FreqProxDocsEnum(FreqProxTermsWriterPerField terms, FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray) {
            this.terms = terms;
            this.postingsArray = postingsArray;
            this.readTermFreq = terms.hasFreq;
        }

        public void reset(int termID) {
            this.termID = termID;
            this.terms.initReader(this.reader, termID, 0);
            this.ended = false;
            this.docID = 0;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() {
            if (!this.readTermFreq) {
                throw new IllegalStateException("freq was not indexed");
            }
            return this.freq;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.reader.eof()) {
                if (this.ended) {
                    return Integer.MAX_VALUE;
                }
                this.ended = true;
                this.docID = this.postingsArray.lastDocIDs[this.termID];
                if (this.readTermFreq) {
                    this.freq = this.postingsArray.termFreqs[this.termID];
                }
            } else {
                int code = this.reader.readVInt();
                if (!this.readTermFreq) {
                    this.docID += code;
                } else {
                    this.docID += code >>> 1;
                    this.freq = (code & 1) != 0 ? 1 : this.reader.readVInt();
                }
                assert (this.docID != this.postingsArray.lastDocIDs[this.termID]);
            }
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FreqProxTermsEnum
    extends TermsEnum {
        final FreqProxTermsWriterPerField terms;
        final int[] sortedTermIDs;
        final FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray;
        final BytesRef scratch = new BytesRef();
        final int numTerms;
        int ord;

        public FreqProxTermsEnum(FreqProxTermsWriterPerField terms) {
            this.terms = terms;
            this.numTerms = terms.bytesHash.size();
            this.sortedTermIDs = terms.sortedTermIDs;
            assert (this.sortedTermIDs != null);
            this.postingsArray = (FreqProxTermsWriterPerField.FreqProxPostingsArray)terms.postingsArray;
        }

        public void reset() {
            this.ord = -1;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) {
            int lo = 0;
            int hi = this.numTerms - 1;
            while (hi >= lo) {
                int mid = lo + hi >>> 1;
                int textStart = this.postingsArray.textStarts[this.sortedTermIDs[mid]];
                this.terms.bytePool.setBytesRef(this.scratch, textStart);
                int cmp = this.scratch.compareTo(text);
                if (cmp < 0) {
                    lo = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    hi = mid - 1;
                    continue;
                }
                this.ord = mid;
                return TermsEnum.SeekStatus.FOUND;
            }
            this.ord = lo + 1;
            if (this.ord >= this.numTerms) {
                return TermsEnum.SeekStatus.END;
            }
            int textStart = this.postingsArray.textStarts[this.sortedTermIDs[this.ord]];
            this.terms.bytePool.setBytesRef(this.scratch, textStart);
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public void seekExact(long ord) {
            this.ord = (int)ord;
            int textStart = this.postingsArray.textStarts[this.sortedTermIDs[this.ord]];
            this.terms.bytePool.setBytesRef(this.scratch, textStart);
        }

        @Override
        public BytesRef next() {
            ++this.ord;
            if (this.ord >= this.numTerms) {
                return null;
            }
            int textStart = this.postingsArray.textStarts[this.sortedTermIDs[this.ord]];
            this.terms.bytePool.setBytesRef(this.scratch, textStart);
            return this.scratch;
        }

        @Override
        public BytesRef term() {
            return this.scratch;
        }

        @Override
        public long ord() {
            return this.ord;
        }

        @Override
        public int docFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) {
            FreqProxDocsEnum docsEnum;
            if (liveDocs != null) {
                throw new IllegalArgumentException("liveDocs must be null");
            }
            if (!this.terms.hasFreq && (flags & 1) != 0) {
                throw new IllegalArgumentException("did not index freq");
            }
            if (reuse instanceof FreqProxDocsEnum) {
                docsEnum = (FreqProxDocsEnum)reuse;
                if (docsEnum.postingsArray != this.postingsArray) {
                    docsEnum = new FreqProxDocsEnum(this.terms, this.postingsArray);
                }
            } else {
                docsEnum = new FreqProxDocsEnum(this.terms, this.postingsArray);
            }
            docsEnum.reset(this.sortedTermIDs[this.ord]);
            return docsEnum;
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) {
            FreqProxDocsAndPositionsEnum posEnum;
            if (liveDocs != null) {
                throw new IllegalArgumentException("liveDocs must be null");
            }
            if (!this.terms.hasProx) {
                throw new IllegalArgumentException("did not index positions");
            }
            if (!this.terms.hasOffsets && (flags & 1) != 0) {
                throw new IllegalArgumentException("did not index offsets");
            }
            if (reuse instanceof FreqProxDocsAndPositionsEnum) {
                posEnum = (FreqProxDocsAndPositionsEnum)reuse;
                if (posEnum.postingsArray != this.postingsArray) {
                    posEnum = new FreqProxDocsAndPositionsEnum(this.terms, this.postingsArray);
                }
            } else {
                posEnum = new FreqProxDocsAndPositionsEnum(this.terms, this.postingsArray);
            }
            posEnum.reset(this.sortedTermIDs[this.ord]);
            return posEnum;
        }

        @Override
        public TermState termState() throws IOException {
            return new TermState(){

                @Override
                public void copyFrom(TermState other) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class FreqProxTerms
    extends Terms {
        final FreqProxTermsWriterPerField terms;

        public FreqProxTerms(FreqProxTermsWriterPerField terms) {
            this.terms = terms;
        }

        @Override
        public TermsEnum iterator(TermsEnum reuse) {
            FreqProxTermsEnum termsEnum = reuse instanceof FreqProxTermsEnum && ((FreqProxTermsEnum)reuse).terms == this.terms ? (FreqProxTermsEnum)reuse : new FreqProxTermsEnum(this.terms);
            termsEnum.reset();
            return termsEnum;
        }

        @Override
        public long size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumTotalTermFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumDocFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDocCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasFreqs() {
            return this.terms.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        @Override
        public boolean hasOffsets() {
            return this.terms.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        @Override
        public boolean hasPositions() {
            return this.terms.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        @Override
        public boolean hasPayloads() {
            return this.terms.sawPayloads;
        }
    }
}

