/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;

final class BooleanScorer
extends BulkScorer {
    static final int SHIFT = 11;
    static final int SIZE = 2048;
    static final int MASK = 2047;
    static final int SET_SIZE = 32;
    static final int SET_MASK = 31;
    final Bucket[] buckets = new Bucket[2048];
    final long[] matching = new long[32];
    final float[] coordFactors;
    final BulkScorer[] optionalScorers;
    final FakeScorer fakeScorer = new FakeScorer();
    boolean hasMatches;
    int max = 0;
    final OrCollector orCollector = new OrCollector();

    BooleanScorer(BooleanQuery.BooleanWeight weight, boolean disableCoord, int maxCoord, Collection<BulkScorer> optionalScorers) {
        int i;
        for (i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Bucket();
        }
        this.optionalScorers = optionalScorers.toArray(new BulkScorer[0]);
        this.coordFactors = new float[optionalScorers.size() + 1];
        for (i = 0; i < this.coordFactors.length; ++i) {
            this.coordFactors[i] = disableCoord ? 1.0f : weight.coord(i, maxCoord);
        }
    }

    private void scoreDocument(LeafCollector collector, int base, int i) throws IOException {
        int doc;
        Bucket bucket = this.buckets[i];
        this.fakeScorer.freq = bucket.freq;
        this.fakeScorer.score = (float)bucket.score * this.coordFactors[bucket.freq];
        this.fakeScorer.doc = doc = base | i;
        collector.collect(doc);
        bucket.freq = 0;
        bucket.score = 0.0;
    }

    private void scoreMatches(LeafCollector collector, int base) throws IOException {
        long[] matching = this.matching;
        for (int idx = 0; idx < matching.length; ++idx) {
            int ntz;
            for (long bits = matching[idx]; bits != 0L; bits ^= 1L << ntz) {
                ntz = Long.numberOfTrailingZeros(bits);
                int doc = idx << 6 | ntz;
                this.scoreDocument(collector, base, doc);
            }
        }
    }

    private boolean collectMatches() throws IOException {
        boolean more = false;
        for (BulkScorer scorer : this.optionalScorers) {
            more |= scorer.score(this.orCollector, this.max);
        }
        return more;
    }

    private boolean scoreWindow(LeafCollector collector, int base, int max) throws IOException {
        this.max = Math.min(base + 2048, max);
        this.hasMatches = false;
        boolean more = this.collectMatches();
        if (this.hasMatches) {
            this.scoreMatches(collector, base);
            Arrays.fill(this.matching, 0L);
        }
        return more;
    }

    @Override
    public boolean score(LeafCollector collector, int max) throws IOException {
        this.fakeScorer.doc = -1;
        collector.setScorer(this.fakeScorer);
        for (int docBase = this.max & 0xFFFFF800; docBase < max; docBase += 2048) {
            if (this.scoreWindow(collector, docBase, max)) continue;
            return false;
        }
        return true;
    }

    final class OrCollector
    implements LeafCollector {
        Scorer scorer;

        OrCollector() {
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        @Override
        public void collect(int doc) throws IOException {
            int idx;
            BooleanScorer.this.hasMatches = true;
            int i = doc & 0x7FF;
            int n = idx = i >>> 6;
            BooleanScorer.this.matching[n] = BooleanScorer.this.matching[n] | 1L << i;
            Bucket bucket = BooleanScorer.this.buckets[i];
            ++bucket.freq;
            bucket.score += (double)this.scorer.score();
        }
    }

    static class Bucket {
        double score;
        int freq;

        Bucket() {
        }
    }
}

