/** searchndl.cpp
 * }ٌ
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-09-01.shtm
 * @gpAPI		}كT[`API https://iss.ndl.go.jp/information/api/
*/

//  ======================================================
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <regex>
#include <string>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <richedit.h>
#include <curl/curl.h>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/format.hpp>
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::property_tree;

#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"gsearchndl"			// AvP[V
#define APPNAMEJP	"}ٌ"	// AvP[Vi{j
#define APPVERSION	"1.3.6"					// o[W
#define APPYEAR		"2020-2026"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-09-01.shtm"	// QlTCg
#define REFERENCE_NDL	"https://iss.ndl.go.jp/information/api/"	// }APIɂ

// }API
#define URL_NDLAPI	"https://ndlsearch.ndl.go.jp/api/opensearch?";

// char*obt@TCY
#define SIZE_BUFF		5120

// ݂̃C^[tFCX
static HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[p
string ErrorMessage;

// L[i[p
string Query;

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"searchndl.csv"

// UserAgent
string UserAgent;

// Џi[pNX
#define SIZE_BOOKS		500		// i[
class _Books {
public:
	bool flag = false;
	char title[SIZE_BUFF + 1] = {};			// Ж
	char author[SIZE_BUFF + 1] = {};		// 
	char publisher[SIZE_BUFF + 1] = {};		// oŎ
	char pubdate[SIZE_BUFF + 1] = {};		// oœ
	char link[SIZE_BUFF + 1] = {};			// NURL
	char isbn[SIZE_BUFF + 1] = {};			// ISBNԍ
	char ndc9[SIZE_BUFF + 1] = {};			// NDCԍ
};
unique_ptr<_Books> Books[SIZE_BOOKS] = {};

// \[gp\
struct _stBooks {
	char *title;		// Ж
	char *author;		// 
	char *publisher;	// oŎ
	char *pubdate;		// oœ
	char *isbn;			// ISBNԍ
	char *ndc9;			// NDCԍ
	char *link;			// NURL
};
vector<_stBooks> Vbooks;

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂DAPI̕ύXE~ɂĐɋ@\ȂȂꍇ܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCAPI𗘗pĂ܂D
@MinGW(g++), Boost C++Cu, cURL, OpenSSL
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// TuEvO =====================================================
typedef void (WINAPI *RtlGetVersion_FUNC)(OSVERSIONINFOEXW*);

/**
 * Windowso[W擾
 * @param	OSVERSIONINFOEX* os o[Wi[
 * @return	bool TRUE/FALSEȂ
 */
BOOL GetVersion2(OSVERSIONINFOEX* os) {
	HMODULE hMod;
	RtlGetVersion_FUNC func;
#ifdef UNICODE
	OSVERSIONINFOEXW* osw = os;
#else
	OSVERSIONINFOEXW o;
	OSVERSIONINFOEXW* osw = &o;
#endif

	hMod = LoadLibrary(TEXT("ntdll.dll"));
	if (hMod) {
		func = (RtlGetVersion_FUNC)GetProcAddress(hMod, "RtlGetVersion");
		if (func == 0) {
			FreeLibrary(hMod);
			return FALSE;
		}
		ZeroMemory(osw, sizeof(*osw));
		osw->dwOSVersionInfoSize = sizeof(*osw);
		func(osw);
#ifndef UNICODE
		os->dwBuildNumber = osw->dwBuildNumber;
		os->dwMajorVersion = osw->dwMajorVersion;
		os->dwMinorVersion = osw->dwMinorVersion;
		os->dwPlatformId = osw->dwPlatformId;
		os->dwOSVersionInfoSize = sizeof(*os);
//		DWORD sz = sizeof(os->szCSDVersion);
		WCHAR* src = osw->szCSDVersion;
		unsigned char* dtc = (unsigned char*)os->szCSDVersion;
		while (*src) {
			*dtc++ = (unsigned char)*src++;
		}
		*dtc = '\0';
#endif

	} else {
		return FALSE;
	}
	FreeLibrary(hMod);

return TRUE;
}

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbg
 * @param	string str 
 * @return	Ȃ
*/
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, SIZE_BUFF);
	PTSTR pText = (PTSTR)GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

/**
 * Nbv{[h當擾
 * @param	Ȃ
 * @return	^NULL擾s
*/
char* getClipboardData(void) {
	static char buff[SIZE_BUFF + 1];

	OpenClipboard(NULL);
	HGLOBAL hText = GetClipboardData(CF_TEXT);

	if (hText == NULL) {
		return NULL;
	} else {
		PTSTR pText = (PTSTR)GlobalLock(hText);
		lstrcpy(buff, pText);
		GlobalUnlock(hText);
	}
	CloseClipboard();

	return buff;
}

// GUI =================================================================
/**
 * eLXg{bNXɕ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
*/
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[SIZE_BUFF + 1];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * eLXg{bNX當擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return string 擾
*/
string getStrEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));
	return (string)buff;
}

/**
 * eLXgER[hϊFSJISwstringiWindows APIgpj
 * @param  string src SJISeLXg
 * @return string ϊeLXg
*/
std::wstring __sjis_wstring(std::string src) {
	auto const dest_size = ::MultiByteToWideChar(CP_ACP, 0U, src.data(), -1, nullptr, 0U);
	std::vector<wchar_t> dest(dest_size, L'\0');

	if (::MultiByteToWideChar(CP_ACP, 0U, src.data(), -1, dest.data(), dest.size()) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<wchar_t>::length(dest.data()));
	dest.shrink_to_fit();

	return std::wstring(dest.begin(), dest.end());
}

/**
 * eLXgER[hϊFwstringSJISiWindows APIgpj
 * @param  wstring src eLXg
 * @return string ϊeLXgiSJISj
*/
std::string __wstring_sjis(std::wstring src) {
	auto const dest_size = ::WideCharToMultiByte(CP_ACP, 0U, src.data(), -1, nullptr, 0, nullptr, nullptr);
	std::vector<char> dest(dest_size, '\0');
	if (::WideCharToMultiByte(CP_ACP, 0U, src.data(), -1, dest.data(), dest.size(), nullptr, nullptr) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<char>::length(dest.data()));
	dest.shrink_to_fit();

	return std::string(dest.begin(), dest.end());
}

/**
 * eLXgER[hϊFUTF-8wstringiWindows APIgpj
 * @param  string src UTF-8eLXg
 * @return string ϊeLXg
*/
std::wstring __utf8_wstring(std::string src) {
	auto const dest_size = ::MultiByteToWideChar(CP_UTF8, 0U, src.data(), -1, nullptr, 0U);
	std::vector<wchar_t> dest(dest_size, L'\0');
	if (::MultiByteToWideChar(CP_UTF8, 0U, src.data(), -1, dest.data(), dest.size()) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<wchar_t>::length(dest.data()));
	dest.shrink_to_fit();

	return std::wstring(dest.begin(), dest.end());
}

/**
 * eLXgER[hϊFwstringUTF-8iWindows APIgpj
 * @param  wstring src eLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string __wstring_utf8(std::wstring src) {
	auto const dest_size = ::WideCharToMultiByte(CP_UTF8, 0U, src.data(), -1, nullptr, 0, nullptr, nullptr);
	std::vector<char> dest(dest_size, '\0');

	if (::WideCharToMultiByte(CP_UTF8, 0U, src.data(), -1, dest.data(), dest.size(), nullptr, nullptr) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<char>::length(dest.data()));
	dest.shrink_to_fit();

	return std::string(dest.begin(), dest.end());
}

/**
 * eLXgER[hϊFSJISUTF-8iWindows APIgpj
 * @param  wstring src SJISeLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string sjis_utf8(std::string src) {
	wstring const wide = __sjis_wstring(src);
	return __wstring_utf8(wide);
}

/**
 * eLXgER[hϊFUTF-8SJISiWindows APIgpj
 * @param  wstring src UTF-8eLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string utf8_sjis(std::string src) {
	wstring const wide = __utf8_wstring(src);
	return __wstring_sjis(wide);
}
/**
 * _CAOeEBhE̒ɔzu
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
*/
void CenterWindow(HWND hDlg) {
	int  x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

// IvVǍ^ۑ ====================================================
/**
 * AppDatãpX擾
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * p[^̏
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	hParent_X = 0;
	hParent_Y = 0;
	Query     = "";
}

/**
 * IvV̓ǂݍ
 * @param	Ȃ
 * @return	Ȃ
 */
void loadParameter(void) {
	ptree pt;

	// lݒ
	initParameter();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "query") {
					Query = utf8_sjis((string)it.second.data());
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			hParent_X = 0;
			hParent_Y = 0;
			Query = "";
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		hParent_X = 0;
		hParent_Y = 0;
		Query = "";
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * IvV̕ۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParameter(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", sjis_utf8(Query));
	child1.add("<xmlattr>.type", "query");
	ptree& child2 = pt.add("parameter.param", (string)to_string(hParent_X));
	child2.add("<xmlattr>.type", "wx");
	ptree& child3 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child3.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * p[^̍폜
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg	EBhEEnh
 * @paramm	UINT uMsg
 * @param	WPARAM wParam
 * @paramL	PARAM lParam
 * @return	INT_PTR CALLBACK
*/
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	string help;

	switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
    return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// t@Co͏ =======================================================
/**
 * ʂCSVt@Cɕۑ
 * @param	const char *fname ۑt@C
 * @return	Ȃ
*/
void __saveCSV(const char *fname) {
	ofstream outputfile(fname);

	// x
	outputfile << "\"" << "Ж" << "\",";
	outputfile << "\"" << "" << "\",";
	outputfile << "\"" << "oŎ" << "\",";
	outputfile << "\"" << "oœ" << "\",";
	outputfile << "\"" << "ISBN" << "\",";
	outputfile << "\"" << "NDC9" << "\",";
	outputfile << "\"" << "NURL" << "\"" << endl;

	// f[^{
	for (int i = 0; i < SIZE_BOOKS; i++) {
		if (Books[i] != NULL) {
			outputfile << "\"" << Books[i]->title << "\",";
			outputfile << "\"" << Books[i]->author << "\",";
			outputfile << "\"" << Books[i]->publisher << "\",";
			outputfile << "\"" << Books[i]->pubdate << "\",";
			outputfile << "\"" << Books[i]->isbn << "\",";
			outputfile << "\"" << Books[i]->ndc9 << "\",";
			outputfile << "\"" << Books[i]->link << "\"" << endl;
		}
		if (outputfile.bad()) {
			ErrorMessage = "CSVt@C݃G[";
			break;
		}
	}
	outputfile.close();
}

/**
 * ʂCSVt@Cɕۑ
 * @param	Ȃ
 * @return	Ȃ
*/
void saveCSV(void) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("CSVt@C(*.csv;*.txt)\0*.csv;*.txt\0ׂẴt@C(*.txt)\0*.txt\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("csv");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveCSV(fname);
}

// }كT[` ================================================
/**
 * }كT[`API URL擾
 * @param	char* query		^CgiSJISGvj
 *                         ܂ISBNi10܂13GSv܂͑Ovj
 *                         yȗsz
 * @param	char* creater	쐬ҁiSJISGvj
 * @param	char* url		URLi[
 * @param	size_t sz		url̍ő咷
 * @return	Ȃ
*/
void getURL_searchNDL(char *query, char *creater, char *url, size_t sz) {
	const string ndl = URL_NDLAPI;
	static char buff1[SIZE_BUFF + 1], buff2[SIZE_BUFF + 1];

	strncpy(buff1, sjis_utf8((string)query).c_str(), SIZE_BUFF);

	CURL *curl = curl_easy_init();
	strncpy(buff2, curl_easy_escape(curl, (const char *)buff1, strlen(buff1)), SIZE_BUFF);

	// ISBNp^[
	regex re("^[0-9]+$");
	smatch mt;
	string ss;
	ss = (string)buff2;
	if (regex_match(ss, mt, re)) {
		ss = ndl + "isbn=" + (string)buff2;
	// 
	} else {
		ss = ndl + "title=" + (string)buff2;
	}
	strncpy(url, ss.c_str(), SIZE_BUFF);

	curl_easy_cleanup(curl);
}

size_t callBackFunk(char* ptr, size_t size, size_t nmemb, string* stream) {
	int realsize = size * nmemb;
	stream->append(ptr, realsize);
	return realsize;
}

/**
 * ʂzɊi[
 * @param	array $item z
 * @param	int   $i    JE^
 * @return	int ʂ̌
*/
int searchBooks(char *title) {
	// 
	for (int i = 0; i < SIZE_BOOKS; i++) {
		Books[i].reset();
		Books[i] = NULL;
	}

	// cURLɂ錋ʎ擾
	CURL *curl;
	CURLcode res = (CURLcode)0;
	curl = curl_easy_init();
	string chunk;
	char url[SIZE_BUFF];
	getURL_searchNDL(title, (char *)"", (char *)url, SIZE_BUFF);

	// cURLɂ鍑}كT[`API
	if (curl) {
		curl_easy_setopt(curl, CURLOPT_URL, url);
		curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, callBackFunk);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, (string*)&chunk);
		res = curl_easy_perform(curl);
		curl_easy_cleanup(curl);
	}
    if (res != CURLE_OK) {
		ErrorMessage = "}كT[`APĨG[";
		return (-1);
	}

	// XMLǂݍ
	std::stringstream ss;
	ss << chunk;
	ptree pt;
	xml_parser::read_xml(ss, pt);

	// XML
	ptree tree;
	struct tm dt;
	char buff[SIZE_BUFF + 1];
	int cnt = -1;
	for (auto it : pt.get_child("rss.channel")) {
		// itemȊO͓ǂݔ΂
		if (it.first != "item")		continue;
		cnt++;
		Books[cnt] = make_unique<_Books>();

		// Ж
		if (optional<string>title = it.second.get_optional<string>("title")) {
			strncpy(Books[cnt]->title, utf8_sjis((string)(title->c_str())).c_str(), SIZE_BUFF);
		}
		// 
		if (optional<string>volume = it.second.get_optional<string>("dcndl:volume")) {
			strncpy(buff, utf8_sjis((string)(volume->c_str())).c_str(), SIZE_BUFF);
			strcat(Books[cnt]->title, " ");
			strcat(Books[cnt]->title, buff);
			strncat(Books[cnt]->title, (char *)"", SIZE_BUFF);
		}

		// 
		if (optional<string>creator = it.second.get_optional<string>("dc:creator")) {
			strncpy(Books[cnt]->author, utf8_sjis((string)(creator->c_str())).c_str(), SIZE_BUFF);
		}
		if (optional<string>author = it.second.get_optional<string>("author")) {
			if (*Books[cnt]->author == 0) {
				strncpy(Books[cnt]->author, utf8_sjis((string)(author->c_str())).c_str(), SIZE_BUFF);
			}
		}

		// oŎ
		if (optional<string>publisher = it.second.get_optional<string>("dc:publisher")) {
			strncpy(Books[cnt]->publisher, utf8_sjis((string)(publisher->c_str())).c_str(), SIZE_BUFF);
		}

		// oœ
		if (optional<string>pubdate = it.second.get_optional<string>("pubDate")) {
			{
			istringstream ss(pubdate->c_str());
			ss >> get_time(&dt, "%a, %d %b %Y");
			strftime(buff, SIZE_BUFF, "%Y-%m-%d", &dt);
			}
			strcpy(Books[cnt]->pubdate, buff);
		}
		if (optional<string>dcterms = it.second.get_optional<string>("dcterms:issued")) {
			if (*Books[cnt]->pubdate == 0) {
				if (it.second.get_optional<string>("dcterms:issued.<xmlattr>.xsi:type") == (string)"dcterms:W3CDTF") {
					strncpy(Books[cnt]->pubdate, dcterms->c_str(), SIZE_BUFF);
				}
			}
		}

		// NURL
		if (optional<string>link = it.second.get_optional<string>("link")) {
			strncpy(Books[cnt]->link, link->c_str(), SIZE_BUFF);
		}

		// ISBN
		if (optional<string>isbn = it.second.get_optional<string>("dc:identifier")) {
			if (it.second.get_optional<string>("dc:identifier.<xmlattr>.xsi:type") == (string)"dcndl:ISBN") {
				strncpy(Books[cnt]->isbn, isbn->c_str(), SIZE_BUFF);
			}
		}

		// NDC9
		if (optional<string>ndc9 = it.second.get_optional<string>("dc:subject")) {
			if (it.second.get_optional<string>("dc:subject.<xmlattr>.xsi:type") == (string)"dcndl:NDC9") {
				strncpy(Books[cnt]->ndc9, ndc9->c_str(), SIZE_BUFF);
			}
		}
	}
	chunk.clear();

	return cnt;
}

// L\[gpID
enum {
	SORT_TITLE_ASC,
	SORT_TITLE_DEC,
	SORT_AUTHOR_ASC,
	SORT_AUTHOR_DEC,
	SORT_PUBLISHER_ASC,
	SORT_PUBLISHER_DEC,
	SORT_PUBDATE_ASC,
	SORT_PUBDATE_DEC,
	SORT_NDC9_ASC,
	SORT_NDC9_DEC,
	SORT_ISBN_ASC,
	SORT_ISBN_DEC,
	SORT_NONE
};

// L\[gpID
enum {
	SORT_ASC,
	SORT_DEC
};

/**
 * \[gp̔r֐FЖij
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpTitleAsc(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.title, right.title) < 0;
}

/**
 * \[gp̔r֐FЖi~j
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpTitleDec(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.title, right.title) >= 0;
}

/**
 * \[gp̔r֐Fҁij
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpAuthorAsc(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.author, right.author) < 0;
}

/**
 * \[gp̔r֐Fҁi~j
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpAuthorDec(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.author, right.author) >= 0;
}

/**
 * \[gp̔r֐FoŎЁij
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpPublisherAsc(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.publisher, right.publisher) < 0;
}

/**
 * \[gp̔r֐FoŎЁi~j
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpPublisherDec(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.publisher, right.publisher) >= 0;
}

/**
 * \[gp̔r֐Foœij
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpPubDateAsc(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.pubdate, right.pubdate) < 0;
}

/**
 * \[gp̔r֐Foœi~j
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpPubDateDec(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.pubdate, right.pubdate) >= 0;
}

/**
 * \[gp̔r֐FISBNij
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpISBNAsc(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.isbn, right.isbn) < 0;
}

/**
 * \[gp̔r֐FISBNi~j
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpISBNDec(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.isbn, right.isbn) >= 0;
}

/**
 * \[gp̔r֐FNDC9ij
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpNDC9Asc(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.ndc9, right.ndc9) < 0;
}

/**
 * \[gp̔r֐FNDC9i~j
 * @param	const _stBooks& left, right
 * @return	r
*/
bool __cmpNDC9Dec(const _stBooks& left, const _stBooks& right) {
	return strcmp(left.ndc9, right.ndc9) >= 0;
}

/**
 * \[gpϐɑ
 * @param	const _stBooks& left, right
 * @return	r
*/
_stBooks __push_stBooks(unique_ptr<_Books> &ptr) {
	_stBooks s;
	s.title		= ptr->title;
	s.author	= ptr->author;
	s.publisher	= ptr->publisher;
	s.pubdate	= ptr->pubdate;
	s.link		= ptr->link;
	s.isbn		= ptr->isbn;
	s.ndc9		= ptr->ndc9;
	return s;
}

/**
 * Јꗗ̃\[g
 * @param	int c  \[g
 * @return	Ȃ
*/
void sortBooks(int c) {
	struct {
		int id;
		bool (*fn)(const _stBooks& left, const _stBooks& right);
} table[] = {
	{ SORT_TITLE_ASC,		__cmpTitleAsc },
	{ SORT_TITLE_DEC,		__cmpTitleDec },
	{ SORT_AUTHOR_ASC,		__cmpAuthorAsc },
	{ SORT_AUTHOR_DEC,		__cmpAuthorDec },
	{ SORT_PUBLISHER_ASC,	__cmpPublisherAsc },
	{ SORT_PUBLISHER_DEC,	__cmpPublisherDec },
	{ SORT_PUBDATE_ASC,		__cmpPubDateAsc },
	{ SORT_PUBDATE_DEC,		__cmpPubDateDec },
	{ SORT_ISBN_ASC,		__cmpISBNAsc },
	{ SORT_ISBN_DEC,		__cmpISBNDec },
	{ SORT_NDC9_ASC,		__cmpNDC9Asc },
	{ SORT_NDC9_DEC,		__cmpNDC9Dec }
};
	int i;
	bool (*fn)(const _stBooks& left, const _stBooks& right) = NULL;

	// \[gpz̏
	Vbooks.clear();
	Vbooks.shrink_to_fit();

	// Џ\[gpz
	for (i = 0; i < SIZE_BOOKS; i++) {
		if (Books[i] != NULL) {
			Vbooks.push_back(__push_stBooks(Books[i]));
		}
	}

	// \[gp֐̑I
	for (i = 0; i < (int)(sizeof(table) / sizeof(*table)); i++) {
		if (c == table[i].id) {
			fn = table[i].fn;
			break;
		}
	}

	// \[gs
	if (fn != NULL) {
		stable_sort(Vbooks.begin(), Vbooks.end(), fn);
	}
}

// Xgr[̗
enum {
	COL_TITLE,
	COL_AUTHOR,
	COL_PUBLISHER,
	COL_PUBDATE,
	COL_NDC,
	COL_ISBN,
	COL_LINK
};

/**
 * Јꗗ̃t[쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListViewFrame(HWND hWnd) {
	LVCOLUMNA lvcol;
	lvcol.mask = LVCF_TEXT | LVCF_SUBITEM | LVCF_WIDTH | LVCF_FMT;
	lvcol.fmt = LVCFMT_LEFT;

	lvcol.cx = 250;
	lvcol.pszText = (char *)"Ж";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_TITLE, (WPARAM)&lvcol);
	lvcol.cx = 100;
	lvcol.pszText = (char *)"";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_AUTHOR, (WPARAM)&lvcol);
	lvcol.cx = 80;
	lvcol.pszText = (char *)"oŎ";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_PUBLISHER, (WPARAM)&lvcol);
	lvcol.cx = 100;
	lvcol.pszText = (char *)"oœ";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_PUBDATE, (WPARAM)&lvcol);
	lvcol.cx = 50;
	lvcol.pszText = (char *)"NDC";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_NDC, (WPARAM)&lvcol);
	lvcol.cx = 120;
	lvcol.pszText = (char *)"ISBN";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_ISBN, (WPARAM)&lvcol);
	lvcol.cx = 0;
	lvcol.pszText = (char *)"URL";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_LINK, (WPARAM)&lvcol);

	// r\
	DWORD dwStyle = ListView_GetExtendedListViewStyle(hWnd);
	dwStyle = dwStyle | LVS_EX_GRIDLINES | LVS_EX_ONECLICKACTIVATE;
	ListView_SetExtendedListViewStyle(hWnd, dwStyle);
}

/**
 * Јꗗ쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListView(HWND hWnd) {
	LVITEMA item;

	// 
	for (int i = 0; i < SIZE_BOOKS; i++) {
		item.iItem = i;
		SendMessage(hWnd, LVM_DELETEITEM, 0,(WPARAM)&item);
	}

	// f[^s
	for (int i = 0; i < SIZE_BOOKS; i++) {
		if (Books[i] == NULL)	break;
		item.mask = LVIF_TEXT;
		item.iItem = i;
		item.iSubItem = COL_TITLE;
		item.pszText = (LPSTR)Vbooks[i].title;
		SendMessage(hWnd, LVM_INSERTITEMA, 0,(WPARAM)&item);
		item.iSubItem = COL_AUTHOR;
		item.pszText = (LPSTR)Vbooks[i].author;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		item.iSubItem = COL_PUBLISHER;
		item.pszText = (LPSTR)Vbooks[i].publisher;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		item.iSubItem = COL_PUBDATE;
		item.pszText = (LPSTR)Vbooks[i].pubdate;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		item.iSubItem = COL_NDC;
		item.pszText = (LPSTR)Vbooks[i].ndc9;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		item.iSubItem = COL_ISBN;
		item.pszText = (LPSTR)Vbooks[i].isbn;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		item.iSubItem = COL_LINK;
		item.pszText = (LPSTR)Vbooks[i].link;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
	}
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HICON hIcon;
	char *str;
	LVITEM item;
	LV_HITTESTINFO lvinfo;
	NM_LISTVIEW *pNMLV;
	TCHAR buff[SIZE_BUFF + 1];
	static int subsort[100];

	switch(uMsg) {
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
		ErrorMessage = "";
		// IvVǂݍ
		loadParameter();
		setStrEditBox(hDlg, IDC_EDIT_QUERY, Query);
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		makeListViewFrame(GetDlgItem(hDlg, IDC_LISTVIEW_BOOKS));
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
		// s
		case IDM_EXEC:
		case IDC_BUTTON_SEARCH:
			ErrorMessage = "";
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			Query = getStrEditBox(hDlg, IDC_EDIT_QUERY);
			// Ќ
			searchBooks((char *)Query.c_str());
			sortBooks(SORT_NONE);
			// ꗗ\
			makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_BOOKS));
			setStrEditBox(hDlg, IDC_TEXT_ERROR, ErrorMessage);
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveCSV();
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delParameter();
			EndDialog(hParent, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// Zp
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// }APIɂ
		case IDM_NDL:
			ShellExecute(NULL, _T("open"), _T(REFERENCE_NDL), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDM_COPY:
			setClipboardData(getStrEditBox(hParent, IDC_EDIT_QUERY));
			break;
		// \t
		case IDM_PASTE:
			str = getClipboardData();
			if (str != NULL) {
				setStrEditBox(hParent, IDC_EDIT_QUERY, str);
			}
			break;
		// ؂
		case IDM_DELETE:
			setStrEditBox(hParent, IDC_EDIT_QUERY, "");
			break;
		// vOI
		case IDM_QUIT:
			// IvVۑ
			saveParameter();
			EndDialog(hParent, 0);
			return FALSE;
		default:
			return 1;
		}
		break;

	// ʒm
	case WM_NOTIFY:
		switch(((LPNMHDR)lParam)->idFrom) {
		case IDC_LISTVIEW_BOOKS:
			switch (((LPNMLISTVIEW)lParam)->hdr.code) {
			// ꗗ̃xNbN
			case LVN_COLUMNCLICK:
				pNMLV = (NM_LISTVIEW *)lParam;
				if (subsort[pNMLV->iSubItem] == SORT_ASC) {
					subsort[pNMLV->iSubItem] = SORT_DEC;
				} else {
					subsort[pNMLV->iSubItem] = SORT_ASC;
				}
				// Јꗗ̕בւ
				sortBooks(pNMLV->iSubItem * 2 + subsort[pNMLV->iSubItem]);
				// ꗗ\
				makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_BOOKS));
				break;
			// Јꗗ1sI
			case LVN_ITEMCHANGED:
			// Јꗗ1s_uNbN
			// case NM_DBLCLK:
				GetCursorPos((LPPOINT)&lvinfo.pt);
				ScreenToClient(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo.pt);
				ListView_HitTest(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo);
				if ((lvinfo.flags & LVHT_ONITEM) != 0) {
					item.mask = TVIF_HANDLE | TVIF_TEXT;
					item.iItem = lvinfo.iItem;
					item.iSubItem = COL_LINK;
					item.pszText = buff;
					item.cchTextMax = SIZE_BUFF;
					ListView_GetItem(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &item);
					// uEUN
					ShellExecute(hParent, _T("open"), _T(buff), NULL, NULL, SW_RESTORE);
				}
				break;
			default:
				break;
			}
			break;
		default:
			break;
		}
		break;

	// vOI
	case WM_CLOSE:
		// IvVۑ
		saveParameter();
		EndDialog(hParent, 0);
		return FALSE;
	}
	return FALSE;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");

	// UserAgent
	static OSVERSIONINFOEX os;
	GetVersion2(&os);
	UserAgent = (string)"Mozilla/5.0 (" + APPNAME + "/"
		+ APPVERSION + "/" + MAKER
		+ ", Windows NT " + to_string(os.dwMajorVersion) + "."
		+ to_string(os.dwMinorVersion) + ")";

	hInst = hInstance;
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);
	return 0;
}

/*
** o[WAbv =====================================================
 *
 * @version 1.3.6  2026/02/14 gpCuXV, optionalOՓˉ
 * @version 1.3.5  2025/10/18 gpCuXV
 * @version 1.3.4  2025/07/05 gpCuXV
 * @version 1.3.3  2025/03/08 gpCuXV
 * @version 1.3.2  2024/11/16 gpCuXV
 * @version 1.3.1  2024/07/27 gpCuXV
 * @version 1.3.0  2024/03/09 API 1.1łɑΉCgpCuXV
 * @version 1.2.4  2023/10/14 gpCuXV
 * @version 1.2.3  2023/06/10 gpCuXVCISBNłȂsC
 * @version 1.2.2  2023/03/05 gpCuXV
 * @version 1.2.1  2022/07/31 gpCuXV
 * @version 1.2    2022/07/31 EBhEʒuEL[ۑ
 * @version 1.1    2022/07/31 UserAgentǉCgpCuXV
 * @version 1.0    2020/08/29 
*/
