﻿// ConsoleSample04.cpp : このファイルには 'main' 関数が含まれています。プログラム実行の開始と終了がそこで行われます。
//

#include <iostream>
#include <fstream>
#include <string>
using namespace std;

string str_formula = "x**2 + y**2"; // 数式入力のテキストボックスに表示される数式

const int ITERATION = 10; // 試行回数
const int SWARM_SIZE = 10; // 群の大きさ

double X_MAX = 10; // X軸の表示範囲の上限
double X_MIN = -10; // X軸の表示範囲の下限

double Y_MAX = 10; // Y軸の表示範囲の上限
double Y_MIN = -10; // Y軸の表示範囲の下限

double x[ITERATION][SWARM_SIZE]; // xのデータ保存用の配列
double y[ITERATION][SWARM_SIZE]; // yのデータ保存用の配列
double z[ITERATION][SWARM_SIZE]; // zのデータ保存用の配列

double function(double x, double y)
{
	double z = x * x + y * y;
	return z;
}

// 0以上1以下の実数乱数
#define RAND_01 ((double)rand() / RAND_MAX)

// ランダムなデータの生成
void create_graph_data()
{
	for (int i = 0; i < ITERATION; i++) {
		for (int j = 0; j < SWARM_SIZE; j++) {
			x[i][j] = X_MIN + (X_MAX - X_MIN) * RAND_01;
			y[i][j] = Y_MIN + (Y_MAX - Y_MIN) * RAND_01;
			z[i][j] = function(x[i][j], y[i][j]);
		}
	}
}

// 生成されたデータのファイルへの書き込み
void write_data()
{
	ofstream fout;
	fout.open("graph_data.txt");

	fout << str_formula << endl;

	fout << "ITERATION" << " " << ITERATION << endl;
	fout << "SWARM_SIZE" << " " << SWARM_SIZE << endl;

	fout << "X_MAX" << " " << X_MAX << endl;
	fout << "X_MIN" << " " << X_MIN << endl;

	fout << "Y_MAX" << " " << Y_MAX << endl;
	fout << "Y_MIN" << " " << Y_MIN << endl;

	fout << "DATA" << endl;
	for (int i = 0; i < ITERATION; i++) {
		for (int j = 0; j < SWARM_SIZE; j++) {
			fout << x[i][j] << " " << y[i][j] << " " << z[i][j] << endl;
		}
		fout << endl;
	}

	fout.close();
}

int main()
{
	srand ((unsigned)time(NULL));

	create_graph_data();

	write_data();
}

