﻿// ConsoleSample07.cpp : このファイルには 'main' 関数が含まれています。プログラム実行の開始と終了がそこで行われます。
//

#include <iostream>
#include <fstream>
#include <string>
using namespace std;

string str_formula = "x**2 + y**2"; // 数式入力のテキストボックスに表示される数式

const int ITERATION = 100; // 試行回数
const int SWARM_SIZE = 10; // 群の大きさ

double X_MAX = 10; // X軸の表示範囲の上限
double X_MIN = -10; // X軸の表示範囲の下限

double Y_MAX = 10; // Y軸の表示範囲の上限
double Y_MIN = -10; // Y軸の表示範囲の下限

double Z_MAX = 200; // Z軸の表示範囲の上限
double Z_MIN = 0; // Z軸の表示範囲の下限

bool DISP_GRAPH1 = 1; // グラフ1の表示（1:表示する、0:表示しない）
bool DISP_GRAPH2 = 1; // グラフ2の表示（1:表示する、0:表示しない）
bool DISP_GRAPH3 = 1; // グラフ3の表示（1:表示する、0:表示しない）
bool DISP_GRAPH4 = 1; // グラフ4の表示（1:表示する、0:表示しない）

bool DISP_X_AXIS1 = 1; // グラフ1のX軸の表示（1:表示する、0:表示しない）
bool DISP_X_AXIS2 = 1; // グラフ2のX軸の表示（1:表示する、0:表示しない）
bool DISP_X_AXIS3 = 1; // グラフ3のX軸の表示（1:表示する、0:表示しない）
bool DISP_X_AXIS4 = 1; // グラフ4のX軸の表示（1:表示する、0:表示しない）

bool DISP_Y_AXIS1 = 1; // グラフ1のY軸の表示（1:表示する、0:表示しない）
bool DISP_Y_AXIS2 = 0; // グラフ2のY軸の表示（1:表示する、0:表示しない）
bool DISP_Y_AXIS3 = 1; // グラフ3のY軸の表示（1:表示する、0:表示しない）
bool DISP_Y_AXIS4 = 1; // グラフ4のY軸の表示（1:表示する、0:表示しない）

bool DISP_Z_AXIS1 = 1; // グラフ1のZ軸の表示（1:表示する、0:表示しない）
bool DISP_Z_AXIS2 = 1; // グラフ2のZ軸の表示（1:表示する、0:表示しない）
bool DISP_Z_AXIS3 = 0; // グラフ3のZ軸の表示（1:表示する、0:表示しない）
bool DISP_Z_AXIS4 = 1; // グラフ4のZ軸の表示（1:表示する、0:表示しない）

bool DISP_WIRE_FRAME1 = 1; // グラフ1のwire frameの表示（1:表示する、0:表示しない）
bool DISP_WIRE_FRAME2 = 1; // グラフ2のwire frameの表示（1:表示する、0:表示しない）
bool DISP_WIRE_FRAME3 = 1; // グラフ3のwire frameの表示（1:表示する、0:表示しない）
bool DISP_WIRE_FRAME4 = 1; // グラフ4のwire frameの表示（1:表示する、0:表示しない）

bool DISP_GRADATION1 = 1; // グラフ1のgradationの表示（1:表示する、0:表示しない）
bool DISP_GRADATION2 = 1; // グラフ2のgradationの表示（1:表示する、0:表示しない）
bool DISP_GRADATION3 = 1; // グラフ3のgradationの表示（1:表示する、0:表示しない）
bool DISP_GRADATION4 = 1; // グラフ4のgradationの表示（1:表示する、0:表示しない）

int AZIMUTH1 = -60; // グラフ1の視点の方向角
int AZIMUTH2 = -90; // グラフ2の視点の方向角
int AZIMUTH3 = -90; // グラフ3の視点の方向角
int AZIMUTH4 = -60; // グラフ3の視点の方向角

int ZENITH1 = 35; // グラフ1の視点の天頂角
int ZENITH2 = 90; // グラフ2の視点の天頂角
int ZENITH3 = 0; // グラフ3の視点の天頂角
int ZENITH4 = -35; // グラフ3の視点の天頂角

int X0_1 = 90; // グラフ1の画面上の右方向へのオフセット
int X0_2 = 90; // グラフ2の画面上の右方向へのオフセット
int X0_3 = 90; // グラフ3の画面上の右方向へのオフセット
int X0_4 = 90; // グラフ4の画面上の右方向へのオフセット

int Y0_1 = 280; // グラフ1の画面上の下方向へのオフセット
int Y0_2 = 300; // グラフ2の画面上の下方向へのオフセット
int Y0_3 = 250; // グラフ3の画面上の下方向へのオフセット
int Y0_4 = 100; // グラフ4の画面上の下方向へのオフセット

int SIZE1 = 10; // グラフ1の大きさ
int SIZE2 = 10; // グラフ2の大きさ
int SIZE3 = 10; // グラフ3の大きさ
int SIZE4 = 10; // グラフ4の大きさ

int WIRE_FRAME_ROUGHNESS = 2; // ワイヤーフレームの表示の粗さ（値が大きいほど粗く、しかし速く表示される）
int GRADATION_ROUGHNESS = 10; // グラデーションの表示の粗さ（値が大きいほど粗く、しかし速く表示される）

int INTERVAL = 200; // 外部データを表示するときの更新間隔（単位:msec）

int MARKER_SIZE = 5; // 外部データを表示するときのマーカーの大きさ
int MARKER_COLOR = 5; // 外部データを表示するときのマーカーの色[ 0:Red 1:Green 2:Blue 3:DarkRed 4:Olive 5:DarkBlue 6:Orange 7:Lime 8:Cyan 9:Yellow 10:Gold 11:White 12:Black 13:Complementary（補色） 14:Gradation 15:GradationComplementary（グラデーションの補色）]

bool USE_DLL_FUNCTION = 0; // DLLに記述されている関数を使う（テキスト入力ボックスの数式は使わない）
bool LOAD_DLL_FUNCTION_PARAMETERS = 1; // DLLの関数の設定パラメータを自動的に読みこむ

double x[ITERATION][SWARM_SIZE]; // xのデータ保存用の配列
double y[ITERATION][SWARM_SIZE]; // yのデータ保存用の配列
double z[ITERATION][SWARM_SIZE]; // zのデータ保存用の配列

// 0以上1以下の実数乱数
#define RAND_01 ((double)rand() / RAND_MAX)

double function(double x, double y)
{
	double z = x * x + y * y;
	return z;
}

// 山登り法のデータの生成
void create_graph_data()
{
	for (int i = 0; i < ITERATION; i++) {
		for (int j = 0; j < SWARM_SIZE; j++) {
			x[i][j] = X_MIN + (X_MAX - X_MIN) * RAND_01;
			y[i][j] = Y_MIN + (Y_MAX - Y_MIN) * RAND_01;
			z[i][j] = function(x[i][j], y[i][j]);
			
			if (i > 0) {
				if (z[i][j] > z[i-1][j]) {
					x[i][j] = x[i-1][j];
					y[i][j] = y[i-1][j];
					z[i][j] = z[i-1][j];
				}
			}
		}
	}
}

// 生成されたデータのファイルへの書き込み
void write_data()
{
	ofstream fout;
	fout.open("graph_data.txt");

	fout << str_formula << endl;

	fout << "ITERATION" << " " << ITERATION << endl;
	fout << "SWARM_SIZE" << " " << SWARM_SIZE << endl;

	fout << "X_MAX" << " " << X_MAX << endl;
	fout << "X_MIN" << " " << X_MIN << endl;

	fout << "Y_MAX" << " " << Y_MAX << endl;
	fout << "Y_MIN" << " " << Y_MIN << endl;

	fout << "Z_MAX" << " " << Z_MAX << endl;
	fout << "Z_MIN" << " " << Z_MIN << endl;

	fout << "DISP_GRAPH1" << " " << DISP_GRAPH1 << endl;
	fout << "DISP_GRAPH2" << " " << DISP_GRAPH2 << endl;
	fout << "DISP_GRAPH3" << " " << DISP_GRAPH3 << endl;
	fout << "DISP_GRAPH4" << " " << DISP_GRAPH4 << endl;

	fout << "DISP_X_AXIS1" << " " << DISP_X_AXIS1 << endl;
	fout << "DISP_X_AXIS2" << " " << DISP_X_AXIS2 << endl;
	fout << "DISP_X_AXIS3" << " " << DISP_X_AXIS3 << endl;
	fout << "DISP_X_AXIS4" << " " << DISP_X_AXIS4 << endl;

	fout << "DISP_Y_AXIS1" << " " << DISP_Y_AXIS1 << endl;
	fout << "DISP_Y_AXIS2" << " " << DISP_Y_AXIS2 << endl;
	fout << "DISP_Y_AXIS3" << " " << DISP_Y_AXIS3 << endl;
	fout << "DISP_Y_AXIS4" << " " << DISP_Y_AXIS4 << endl;

	fout << "DISP_Z_AXIS1" << " " << DISP_Z_AXIS1 << endl;
	fout << "DISP_Z_AXIS2" << " " << DISP_Z_AXIS2 << endl;
	fout << "DISP_Z_AXIS3" << " " << DISP_Z_AXIS3 << endl;
	fout << "DISP_Z_AXIS4" << " " << DISP_Z_AXIS4 << endl;

	fout << "DISP_WIRE_FRAME1" << " " << DISP_WIRE_FRAME1 << endl;
	fout << "DISP_WIRE_FRAME2" << " " << DISP_WIRE_FRAME2 << endl;
	fout << "DISP_WIRE_FRAME3" << " " << DISP_WIRE_FRAME3 << endl;
	fout << "DISP_WIRE_FRAME4" << " " << DISP_WIRE_FRAME4 << endl;

	fout << "DISP_GRADATION1" << " " << DISP_GRADATION1 << endl;
	fout << "DISP_GRADATION2" << " " << DISP_GRADATION2 << endl;
	fout << "DISP_GRADATION3" << " " << DISP_GRADATION3 << endl;
	fout << "DISP_GRADATION4" << " " << DISP_GRADATION4 << endl;

	fout << "AZIMUTH1" << " " << AZIMUTH1 << endl;
	fout << "AZIMUTH2" << " " << AZIMUTH2 << endl;
	fout << "AZIMUTH3" << " " << AZIMUTH3 << endl;
	fout << "AZIMUTH4" << " " << AZIMUTH4 << endl;

	fout << "ZENITH1" << " " << ZENITH1 << endl;
	fout << "ZENITH2" << " " << ZENITH2 << endl;
	fout << "ZENITH3" << " " << ZENITH3 << endl;
	fout << "ZENITH4" << " " << ZENITH4 << endl;

	fout << "X0_1" << " " << X0_1 << endl;
	fout << "X0_2" << " " << X0_2 << endl;
	fout << "X0_3" << " " << X0_3 << endl;
	fout << "X0_4" << " " << X0_4 << endl;

	fout << "Y0_1" << " " << Y0_1 << endl;
	fout << "Y0_2" << " " << Y0_2 << endl;
	fout << "Y0_3" << " " << Y0_3 << endl;
	fout << "Y0_4" << " " << Y0_4 << endl;

	fout << "SIZE1" << " " << SIZE1 << endl;
	fout << "SIZE2" << " " << SIZE2 << endl;
	fout << "SIZE3" << " " << SIZE3 << endl;
	fout << "SIZE4" << " " << SIZE4 << endl;

	fout << "WIRE_FRAME_ROUGHNESS" << " " << WIRE_FRAME_ROUGHNESS << endl;
	fout << "GRADATION_ROUGHNESS" << " " << GRADATION_ROUGHNESS << endl;

	fout << "INTERVAL" << " " << INTERVAL << endl;

	fout << "MARKER_SIZE" << " " << MARKER_SIZE << endl;
	fout << "MARKER_COLOR" << " " << MARKER_COLOR << endl;

	fout << "USE_DLL_FUNCTION" << " " << USE_DLL_FUNCTION << endl;
	fout <<  "LOAD_DLL_FUNCTION_PARAMETERS" << " " << LOAD_DLL_FUNCTION_PARAMETERS << endl;

	fout << "DATA" << endl;
	for (int i = 0; i < ITERATION; i++) {
		for (int j = 0; j < SWARM_SIZE; j++) {
			fout << x[i][j] << " " << y[i][j] << " " << z[i][j] << endl;
		}
		fout << endl;
	}

	fout.close();
}

int main()
{
	srand ((unsigned)time(NULL));

	create_graph_data();

	write_data();
}

