﻿// ローレンツ・アトラクタ

#include <iostream>
#include <fstream>
#include <iomanip>
#include <cmath>
#include <stdexcept>

using namespace std;

string str_formula = "0"; // 数式入力のテキストボックスに表示される数式

const int ITERATION = 1; // 試行回数
const int SWARM_SIZE = 10000; // 群の大きさ

double X_MAX = 30; // X軸の表示範囲の上限
double X_MIN = -30; // X軸の表示範囲の下限

double Y_MAX = 30; // Y軸の表示範囲の上限
double Y_MIN = -30; // Y軸の表示範囲の下限

double Z_MAX = 60; // Z軸の表示範囲の上限
double Z_MIN = 0; // Z軸の表示範囲の下限

bool DISP_GRAPH1 = 1; // グラフ1の表示（1:表示する、0:表示しない）

bool DISP_X_AXIS1 = 1; // グラフ1のX軸の表示（1:表示する、0:表示しない）
bool DISP_Y_AXIS1 = 1; // グラフ1のY軸の表示（1:表示する、0:表示しない）
bool DISP_Z_AXIS1 = 1; // グラフ1のZ軸の表示（1:表示する、0:表示しない）

bool DISP_WIRE_FRAME1 = 1; // グラフ1のwire frameの表示（1:表示する、0:表示しない）
bool DISP_GRADATION1 = 0; // グラフ1のgradationの表示（1:表示する、0:表示しない）

int AZIMUTH1 = -45; // グラフ1の視点の方向角
int ZENITH1 = 45; // グラフ1の視点の天頂角

int X0_1 = 80; // グラフ1の画面上の右方向へのオフセット
int Y0_1 = 320; // グラフ1の画面上の下方向へのオフセット

int SIZE1 = 20; // グラフ1の大きさ

int WIRE_FRAME_ROUGHNESS = 2; // ワイヤーフレームの表示の粗さ（値が大きいほど粗く、しかし速く表示される）
int GRADATION_ROUGHNESS = 10; // グラデーションの表示の粗さ（値が大きいほど粗く、しかし速く表示される）

int INTERVAL = 250; // 外部データを表示するときの更新間隔（単位:msec）

int MARKER_SIZE = 1; // 外部データを表示するときのマーカーの大きさ
int MARKER_COLOR = 0; // 外部データを表示するときのマーカーの色
// 0:Red 1:Green 2:Blue 3:DarkRed 4:Olive 5:DarkBlue 6:Orange 7:Lime 8:Cyan 9:Yellow 10:Gold
// 11:White 12:Black 13:Complementary（補色） 14:Gradation 15:GradationComplementary（グラデーションの補色）
bool DISP_READ_DATA = 0; // 読み込んだ外部データをコンソール画面に表示する（1:表示する、0:表示しない）

bool USE_DLL_FUNCTION = 0; // DLLに記述されている関数を使う（テキスト入力ボックスの数式は使わない）
bool LOAD_DLL_FUNCTION_PARAMETERS = 1; // DLLの関数の設定パラメータを自動的に読みこむ

// ローレンツ方程式のパラメータ
struct LorenzParams {
	double sigma; // プラント係数
	double rho;   // レイリー数
	double beta;  // 幾何パラメータ
};

// ローレンツ方程式の微分を計算
void lorenz_deriv(double x, double y, double z, const LorenzParams &p,
				double &dx, double &dy, double &dz) {
	dx = p.sigma * (y - x);
	dy = x * (p.rho - z) - y;
	dz = x * y - p.beta * z;
}

int main() {
	// パラメータ設定（典型的なカオス条件）
	LorenzParams params = {10.0, 28.0, 8.0 / 3.0};

	// 初期条件
	double x = 1.0, y = 1.0, z = 1.0;

	// 時間刻みとステップ数
	double dt = 0.01;
	int steps = SWARM_SIZE;

	// 出力ファイル
	ofstream fout("graph_data.txt");
	if (!fout) {
		cerr << "ファイルを開けませんでした。\n";
		return 1;
	}

	fout << str_formula << endl;

	fout << "ITERATION" << " " << ITERATION << endl;
	fout << "SWARM_SIZE" << " " << SWARM_SIZE << endl;

	fout << "X_MAX" << " " << X_MAX << endl;
	fout << "X_MIN" << " " << X_MIN << endl;

	fout << "Y_MAX" << " " << Y_MAX << endl;
	fout << "Y_MIN" << " " << Y_MIN << endl;

	fout << "Z_MAX" << " " << Z_MAX << endl;
	fout << "Z_MIN" << " " << Z_MIN << endl;

	fout << "DISP_GRAPH1" << " " << DISP_GRAPH1 << endl;

	fout << "DISP_X_AXIS1" << " " << DISP_X_AXIS1 << endl;
	fout << "DISP_Y_AXIS1" << " " << DISP_Y_AXIS1 << endl;
	fout << "DISP_Z_AXIS1" << " " << DISP_Z_AXIS1 << endl;

	fout << "DISP_WIRE_FRAME1" << " " << DISP_WIRE_FRAME1 << endl;
	fout << "DISP_GRADATION1" << " " << DISP_GRADATION1 << endl;

	fout << "AZIMUTH1" << " " << AZIMUTH1 << endl;
	fout << "ZENITH1" << " " << ZENITH1 << endl;

	fout << "X0_1" << " " << X0_1 << endl;
	fout << "Y0_1" << " " << Y0_1 << endl;

	fout << "SIZE1" << " " << SIZE1 << endl;

	fout << "WIRE_FRAME_ROUGHNESS" << " " << WIRE_FRAME_ROUGHNESS << endl;
	fout << "GRADATION_ROUGHNESS" << " " << GRADATION_ROUGHNESS << endl;

	fout << "INTERVAL" << " " << INTERVAL << endl;

	fout << "MARKER_SIZE" << " " << MARKER_SIZE << endl;
	fout << "MARKER_COLOR" << " " << MARKER_COLOR << endl;
	fout << "DISP_READ_DATA" << " " << DISP_READ_DATA << endl;

	fout << "USE_DLL_FUNCTION" << " " << USE_DLL_FUNCTION << endl;
	fout <<  "LOAD_DLL_FUNCTION_PARAMETERS" << LOAD_DLL_FUNCTION_PARAMETERS << endl;

	fout << "DATA" << endl;

	fout << fixed << setprecision(6);
//	fout << "t,x,y,z\n"; // CSV ヘッダ

	// 数値積分（オイラー法）
	double t = 0.0;
	for (int i = 0; i < steps; ++i) {
//		fout << t << "," << x << "," << y << "," << z << "\n";
		fout << x << " " << y << " " << z << endl;

		double dx, dy, dz;
		lorenz_deriv(x, y, z, params, dx, dy, dz);

		// オイラー法で更新
		x += dx * dt;
		y += dy * dt;
		z += dz * dt;
		t += dt;
	}

	fout.close();
	cout << "計算完了: graph_data.txt に保存しました。\n";
	return 0;
}


/*
可視化例（Python）
生成された CSV を Python で 3D プロットする例です。
Pythonimport pandas as pd
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

df = pd.read_csv("lorenz.csv")

fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')
ax.plot(df["x"], df["y"], df["z"], lw=0.5)
ax.set_xlabel("X")
ax.set_ylabel("Y")
ax.set_zlabel("Z")
plt.show()


補足

このコードは オイラー法 なので精度は高くありません。
より正確にするには 4次のルンゲ＝クッタ法 (RK4) を使うと良いです。
steps や dt を調整すると、より滑らかなアトラクタが描けます。


もし希望があれば、このコードを 高精度な RK4 法に改良したバージョン も作れますが、作成しますか？
そうすればカオスの軌跡がより正確に再現できます。

*/

