/*
 * Decompiled with CFR 0.152.
 */
package rabbit.dcs;

import java.io.InputStream;
import rabbit.dcs.ConvertObserver;
import rabbit.dcs.ConvertWriter;
import rabbit.dcs.DcsException;
import rabbit.dcs.DcsStatus;

public class Dcs
implements DcsStatus,
AutoCloseable {
    public static final float CVERSION = 3.0f;
    public static float nversion;
    public int sts;
    long _hdcsInfo;
    static final int _LINUX = 0;
    static final int _WINDOWS = 1;
    static final boolean _32BITS = false;
    static int _os_value;

    static {
        _os_value = System.getProperty("os.name").toLowerCase().startsWith("windows") ? 1 : 0;
        String jpath = Dcs.isLinux() ? "dcs" : "jdcsw64";
        try {
            System.loadLibrary(jpath);
            nversion = Dcs.getVersion();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
    }

    public static boolean CONFIRMED_CODE_TYPE(int sts) {
        return sts > 0 && sts <= 63;
    }

    public static boolean isLinux() {
        return _os_value == 0;
    }

    public static boolean isWindows() {
        return _os_value == 1;
    }

    public static int getBits() {
        return 64;
    }

    public Dcs() throws DcsException {
        this._createDcs();
        if (this._hdcsInfo == 0L) {
            throw new DcsException("\u30cd\u30a4\u30c6\u30a3\u30d6 Dcs \u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Dcs dcs = this;
            synchronized (dcs) {
                if (this._hdcsInfo != 0L) {
                    this._releaseDcs();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public native int _createDcs();

    public native void _releaseDcs();

    public static native float getVersion();

    public static boolean isJisKana(int c) {
        return c >= 33 && c <= 95;
    }

    public static boolean isSjisKana(int c) {
        return c >= 161 && c <= 223;
    }

    public static boolean isUnibeKana(int c) {
        return c >= 65377 && c <= 65439;
    }

    public static boolean isJisZenkana(int c) {
        return 9249 <= c && c <= 9331 || 9505 <= c && c <= 9587;
    }

    public static boolean isSjisZenkana(int c) {
        return 33439 <= c && c <= 33521 || 33600 <= c && c <= 33683;
    }

    public static boolean isEucZenkana(int c) {
        return 42145 <= c && c <= 42227 || 42401 <= c && c <= 42483;
    }

    public static boolean isUnibeZenkana(int c) {
        return 12353 <= c && c <= 12435 || 12449 <= c && c <= 12531;
    }

    public static boolean remainsAscii(int dtype) {
        return dtype < 22 || dtype == 20;
    }

    public static int unibeToUtf8Short(byte[] dbuf, int scd) {
        if (scd <= 127) {
            dbuf[0] = (byte)scd;
            return 1;
        }
        if (scd <= 2047) {
            dbuf[0] = (byte)(0xC0 | scd >> 6);
            dbuf[1] = (byte)(0x80 | scd & 0x3F);
            return 2;
        }
        dbuf[0] = (byte)(0xE0 | scd >> 12 & 0xF);
        dbuf[1] = (byte)(0x80 | scd >> 6 & 0x3F);
        dbuf[2] = (byte)(0x80 | scd & 0x3F);
        return 3;
    }

    public static int utf8ToUnibeBytes(byte[] dbuf, int doffset, byte[] sbuf, int[] soffset) {
        int sts;
        if (soffset[0] >= sbuf.length) {
            sts = -22;
        } else {
            int n = soffset[0];
            soffset[0] = n + 1;
            byte c = sbuf[n];
            if ((c & 0x80) == 0) {
                dbuf[0] = 0;
                dbuf[1] = c;
                sts = 0;
            } else if (soffset[0] >= sbuf.length) {
                sts = -22;
            } else {
                int n2 = soffset[0];
                soffset[0] = n2 + 1;
                byte c2 = sbuf[n2];
                if ((c & 0xE0) == 192) {
                    if ((c2 & 0xC0) == 128) {
                        int ch = (c & 0x1F) << 6 | c2 & 0x3F;
                        dbuf[doffset] = (byte)(ch >> 8);
                        dbuf[doffset + 1] = (byte)ch;
                        sts = 0;
                    } else {
                        sts = -23;
                    }
                } else if (soffset[0] >= sbuf.length) {
                    sts = -22;
                } else {
                    int n3 = soffset[0];
                    soffset[0] = n3 + 1;
                    byte c3 = sbuf[n3];
                    if ((c & 0xF0) == 224 && (c2 & 0xC0) == 128 && (c3 & 0xC0) == 128) {
                        int ch = (c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                        dbuf[doffset] = (byte)(ch >> 8);
                        dbuf[doffset + 1] = (byte)ch;
                        sts = 0;
                    } else if (soffset[0] >= sbuf.length) {
                        sts = -22;
                    } else {
                        int n4 = soffset[0];
                        soffset[0] = n4 + 1;
                        byte c4 = sbuf[n4];
                        if ((c & 0xF8) == 240 && (c2 & 0xC0) == 128 && (c3 & 0xC0) == 128 && (c4 & 0xC0) == 128) {
                            long lch = (c & 7) << 18 | (c2 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F;
                            int ch = (int)(((lch -= 65536L) >> 10 | 0xD800L) & Integer.MAX_VALUE);
                            dbuf[doffset] = (byte)(ch >> 8);
                            dbuf[doffset + 1] = (byte)ch;
                            ch = (int)((lch & 0x3FFL | 0xDC00L) & Integer.MAX_VALUE);
                            dbuf[doffset + 2] = (byte)(ch >> 8);
                            dbuf[doffset + 3] = (byte)ch;
                            sts = 0;
                        } else {
                            sts = -23;
                        }
                    }
                }
            }
        }
        return sts;
    }

    public void unibeSurrogateToUtf8(byte[] dbuf, int hcd, int lcd) {
        long _lcd_ = 65536 + ((hcd & 0xFFFF27FF) << 10 | lcd & 0xFFFF23FF);
        dbuf[0] = (byte)(0xF0L | _lcd_ >> 18);
        dbuf[1] = (byte)(0x80L | _lcd_ >> 12 & 0x3FL);
        dbuf[2] = (byte)(0x80L | _lcd_ >> 6 & 0x3FL);
        dbuf[3] = (byte)(0x80L | _lcd_ & 0x3FL);
    }

    public void unibeSurrogateToCd(int[] dcd, int hcd, int lcd) {
        dcd[0] = 65536 + ((hcd & 0xFFFF27FF) << 10 | lcd & 0xFFFF23FF);
    }

    public static int jisKanaToSjis(int c) {
        return c | 0x80;
    }

    public static int jisKanaToUnibe(int c) {
        return 0xFF00 | c + 64 & 0xFF;
    }

    public static int sjisKanaToJis(int c) {
        return c & 0xFFFFFF7F;
    }

    public static int sjisKanaToUnibe(int c) {
        return 0xFF00 | (c | 0x80) - 64;
    }

    public static int unibeKanaToJis(int c) {
        return c - 64 & 0x7F;
    }

    public static int unibeKanaToSjis(int c) {
        return (c - 64 | 0x80) & 0xFF;
    }

    public native int judgesBuffer(int[] var1, int[] var2, byte[] var3, int var4, int var5);

    public native int judgesStream(int[] var1, int[] var2, InputStream var3, int var4);

    public int judgesFile(int[] atype, int[] lnType, String path, int stype) {
        return this.judgesFile(atype, lnType, path.getBytes(), stype);
    }

    public native int judgesFile(int[] var1, int[] var2, byte[] var3, int var4);

    public static native int cmpBom(int var0, int var1);

    public native int convertBuffer(byte[] var1, int var2, int var3, int var4, boolean var5, ConvertObserver var6, ConvertWriter var7, Object var8);

    public native int convertStream(InputStream var1, int var2, int var3, boolean var4, ConvertObserver var5, ConvertWriter var6, Object var7);

    public int convertFile(String path, int stype, int dtype, boolean isForced, ConvertObserver observer, ConvertWriter writer, Object userInfo) {
        return this.convertFile(path.getBytes(), stype, dtype, isForced, observer, writer, userInfo);
    }

    public native int convertFile(byte[] var1, int var2, int var3, boolean var4, ConvertObserver var5, ConvertWriter var6, Object var7);

    public native int getNoCharCount();

    public native long getFirstNoChar();

    public native long getLastNoChar();

    public native int getFirstNoCharIndex();

    public native int getLastNoCharIndex();

    public native int getLtype();

    public native void setLtype(int var1);

    public native boolean isHankanaTo();

    public native void setHankanaTo(boolean var1);

    public native boolean isUtfmacTo();

    public native void setUtfmacTo(boolean var1);

    public native boolean utfmacExists();

    public native boolean isSuppress();

    public native void setSuppress(boolean var1);
}

