/*
 * Decompiled with CFR 0.152.
 */
package rabbit.jdcsview;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class HeaderRenderer
extends JButton
implements TableCellRenderer,
MouseListener,
MouseMotionListener {
    int col = -1;
    int index;
    int cx;
    int px;
    int rx;
    int cy;
    int py;
    int ry;
    int mask;
    boolean isPressed;
    boolean isDragged;
    boolean isActivated;
    boolean isDescended;
    ImageIcon ascendIcon;
    ImageIcon descendIcon;
    JTable table;
    Rectangle rect;

    public HeaderRenderer(JTable table, String text, ImageIcon ascend, ImageIcon descend, int index) {
        super(text);
        this.index = index;
        this.ascendIcon = ascend;
        this.descendIcon = descend;
        this.table = table;
        this.rect = new Rectangle();
    }

    @Override
    protected void fireActionPerformed(ActionEvent evt) {
        if (!this.isActivated) {
            this.setActivated(true);
        } else {
            this.setDescended(!this.isDescended());
        }
        super.fireActionPerformed(evt);
    }

    public void setActivated(boolean isActivated) {
        this.isActivated = isActivated;
        if (isActivated) {
            this.setIcon(this.ascendIcon);
            this.setDescended(false);
        } else {
            this.setIcon(null);
        }
    }

    public boolean isDescended() {
        return this.isDescended;
    }

    public ImageIcon getAscendedIcon() {
        return this.ascendIcon;
    }

    public ImageIcon getDescendedIcon() {
        return this.descendIcon;
    }

    public void setDescended(boolean isDescended) {
        this.setIcon(isDescended ? this.descendIcon : this.ascendIcon);
        this.isDescended = isDescended;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.cx = evt.getX();
        this.cy = evt.getY();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.cx = evt.getX();
        this.cy = evt.getY();
        this.isDragged = true;
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.cx = evt.getX();
        this.cy = evt.getY();
        if (this.rect.contains(this.cx, this.cy)) {
            this.table.getTableHeader().repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (this.rect.contains(this.cx, this.cy) && !this.rect.contains(x, y)) {
            this.table.getTableHeader().repaint();
        }
        this.cx = x;
        this.cy = y;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.cx = evt.getX();
        this.cy = evt.getY();
        if (this.rect.contains(this.cx, this.cy)) {
            this.table.getTableHeader().repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.cx = this.px = evt.getX();
        this.cy = this.py = evt.getY();
        this.mask = evt.getModifiersEx();
        if (this.rect.contains(this.cx, this.cy) && this.mask == 0 && evt.getButton() == 1) {
            ButtonModel model = this.getModel();
            model.setArmed(true);
            model.setPressed(true);
            this.table.getTableHeader().repaint();
            this.isPressed = true;
            this.isDragged = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.cx = this.rx = evt.getX();
        this.cy = this.ry = evt.getY();
        if (this.isPressed) {
            ButtonModel model = this.getModel();
            model.setArmed(false);
            model.setPressed(false);
            this.table.getTableHeader().repaint();
            if (!this.isDragged && this.rect.contains(this.cx, this.cy)) {
                this.doClick();
            }
            this.isPressed = false;
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.col = col;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle rect = this.getBounds();
        rect.x += 4;
        rect.width -= 8;
        this.rect = rect;
        super.paint(g);
    }
}

