/*
 * Decompiled with CFR 0.152.
 */
package rabbit.jdcsview;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;

public class TableRow {
    public static final int TYPE_STRING = 0;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_BYTE_ARRAY = 2;
    public static final int TYPE_BYTE = 3;
    public static final int TYPE_SHORT = 4;
    public static final int TYPE_CHARACTER = 5;
    public static final int TYPE_INTEGER = 6;
    public static final int TYPE_LONG = 7;
    public static final int TYPE_FLOAT = 8;
    public static final int TYPE_DOUBLE = 9;
    public static final int TYPE_BIG_INTEGER = 10;
    public static final int TYPE_BIG_DECIMAL = 11;
    static Color disabledBackground = new Color(224, 224, 224);
    static Color disabledForeground = new Color(80, 80, 80);
    private Column[] _columns;
    private Column[] _def_columns;
    private String _selectPath;
    private String _displayPath;
    private Object _data;

    public TableRow() {
    }

    public TableRow(Object[] columns) {
        this._selectPath = (String)columns[0];
        this._displayPath = (String)columns[1];
        int len = columns.length;
        this._columns = new Column[len];
        this._def_columns = new Column[len];
        int i = 0;
        while (i < len) {
            this._columns[i] = new Column();
            this._def_columns[i] = new Column();
            this._def_columns[i].value = i <= 1 ? "" : columns[i];
            this._columns[i].value = this._def_columns[i].value;
            this._def_columns[i].isEnabled = true;
            this._columns[i].isEnabled = true;
            this._columns[i].images = this._def_columns[i].images = new Image[2];
            ++i;
        }
    }

    public void setData(Object data) {
        this._data = data;
    }

    public Object getData() {
        return this._data;
    }

    public int getColumnCount() {
        return this._columns.length;
    }

    public Object getValueAt(int col) {
        return this._columns[col].value;
    }

    public void setValueAt(int col, Object obj) {
        if (this._columns[col].value.getClass() != obj.getClass()) {
            new Exception("Class unmatch! (" + String.valueOf(this._columns[col].value.getClass()) + ")!=(" + String.valueOf(obj.getClass()) + ")").printStackTrace();
        }
        this._columns[col].value = obj;
    }

    public Object getKeyAt(int col) {
        return this._columns[col].value;
    }

    public boolean isEnabled(int col) {
        return this._columns[col].isEnabled;
    }

    public void setEnabled(boolean isEnabled, int col) {
        this._columns[col].isEnabled = isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        int len = this._columns.length;
        int i = 0;
        while (i < len) {
            this._columns[i].isEnabled = isEnabled;
            ++i;
        }
    }

    public Image getImage(int col) {
        return this._columns[col].images == null ? null : (this._columns[col].value instanceof Boolean ? this._columns[col].images[(Boolean)this._columns[col].value != false ? 1 : 0] : this._columns[col].images[0]);
    }

    public Color getBackground(int col) {
        return this._columns[col].isEnabled ? this._columns[col].background : disabledBackground;
    }

    public void setBackground(int col, Color color) {
        this._columns[col].background = color;
    }

    public Color getForeground(int col) {
        return this._columns[col].isEnabled ? this._columns[col].foreground : disabledForeground;
    }

    public void setForeground(int col, Color color) {
        this._columns[col].foreground = color;
    }

    public Font getFont(int col) {
        return this._columns[col].font;
    }

    public void setFont(int col, Font font) {
        this._columns[col].font = font;
    }

    public void flush(int col) {
        this._def_columns[col].value = this._columns[col].value;
    }

    public String getSelectPath() {
        return this._selectPath;
    }

    public String getDisplayPath() {
        return this._displayPath;
    }

    public void setDisplayPath(String displayPath) {
        this._displayPath = displayPath;
    }

    public boolean isModified(int col) {
        return !this._def_columns[col].value.equals(this._columns[col].value);
    }

    public void setError(int col, boolean isError) {
        this._columns[col].isError = isError;
    }

    public boolean isError(int col) {
        return this._columns[col].isError;
    }

    public void setWarning(int col, boolean isWarning) {
        this._columns[col].isWarning = isWarning;
    }

    public boolean isWarning(int col) {
        return this._columns[col].isWarning;
    }

    class Column {
        Object value;
        Image[] images;
        boolean isEnabled;
        boolean isError;
        boolean isWarning;
        Color background;
        Color foreground;
        Font font;

        Column() {
        }
    }
}

