/*
 * Decompiled with CFR 0.152.
 */
package rabbit.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.html.HTML;

public class HTMLTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_SPACE = 0;
    public static final int TT_TEXT = 1;
    public static final int TT_TAG = 2;
    public static final int TT_COMMENT = 3;
    public int ttype = -1;
    public String sval;
    public HTML.Tag tag;
    public boolean isEndTag;
    public boolean isRegularComment;
    public Hashtable<Object, String> attrs;
    static final int MAX_LENGTH = 0x100000;
    int _textType = -1;
    int _pushBackType = -1;
    Reader _reader;
    boolean _spaceToken = true;
    StringBuffer _sb = new StringBuffer();
    int _size;
    int _pushBackChar;
    int _pushBackToken;
    public UnknownAttribute SUMMARY = new UnknownAttribute("summary");
    Hashtable<String, UnknownAttribute> _hAttr;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("file-path nothing!");
            System.exit(1);
        }
        try {
            BufferedInputStream bis = null;
            BufferedReader br = null;
            bis = new BufferedInputStream(new FileInputStream(args[0]));
            HTMLTokenizer tok = new HTMLTokenizer(bis, true, 0);
            int i = 0;
            while (tok.nextToken() != -1) {
                if (tok.ttype == 2) {
                    ++i;
                    if (tok.tag == null) {
                        System.err.println("tag not found!");
                        continue;
                    }
                    if (tok.tag instanceof HTML.UnknownTag) {
                        System.err.println("unknown tag found! " + String.valueOf(tok.tag));
                        continue;
                    }
                    if (tok.isEndTag || tok.attrs == null) continue;
                    Enumeration<Object> keys = tok.attrs.keys();
                    int j = 1;
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        String val = tok.attrs.get(key);
                        System.out.println(i + ": " + String.valueOf(tok.tag) + ": attr " + j + ": " + String.valueOf(key) + ": " + val);
                        ++j;
                    }
                    continue;
                }
                if (tok.tag == null) continue;
                System.err.println("not tag found! " + String.valueOf(tok.tag));
            }
            if (bis != null) {
                bis.close();
            }
            if (br != null) {
                br.close();
            }
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public HTMLTokenizer(Reader reader) {
        this.createAttributes();
        this._reader = new BufferedReader(reader);
    }

    public HTMLTokenizer(InputStream ins, boolean checkCharset) throws IOException {
        this(ins, checkCharset, 0x100000);
    }

    public HTMLTokenizer(InputStream ins, boolean checkCharset, int size) throws IOException {
        this.createAttributes();
        if (!ins.markSupported()) {
            ins = new BufferedInputStream(ins);
        }
        this._size = size *= 2;
        if (checkCharset) {
            String charset = null;
            ins.mark(Math.max(0x100000, size));
            int majic = ins.read() << 8 | ins.read();
            if (majic == 65279 || majic == 65534) {
                charset = "Unicode";
            } else if (majic == 61371 && ins.read() == 191) {
                charset = "UTF-8";
            } else {
                ins.reset();
                this._reader = new BufferedReader(new InputStreamReader(ins));
                while (this.nextToken() != -1) {
                    if (this.ttype != 2) continue;
                    if (this.tag == HTML.Tag.META) {
                        int i;
                        String key = "charset=";
                        String aval = this.attrs.get(HTML.Attribute.CONTENT);
                        if (aval == null || (i = aval.indexOf(key)) < 0) continue;
                        charset = aval.substring(i + key.length()).trim();
                        String lcharset = charset.toLowerCase();
                        if (lcharset.indexOf("shift") < 0 || lcharset.indexOf("jis") < 0) break;
                        charset = "MS932";
                        break;
                    }
                    if (this.tag == HTML.Tag.BODY) break;
                }
            }
            ins.reset();
            this._reader = charset == null ? new BufferedReader(new InputStreamReader(ins)) : new BufferedReader(new InputStreamReader(ins, charset));
            this.ttype = -1;
            this.sval = null;
            this.tag = null;
            this.attrs = null;
            this.isEndTag = false;
            this.isRegularComment = false;
            this._textType = -1;
            this._pushBackType = -1;
        } else {
            this._reader = new BufferedReader(new InputStreamReader(ins));
        }
    }

    void createAttributes() {
        this._hAttr = new Hashtable<String, UnknownAttribute>();
        Hashtable<String, UnknownAttribute> hAttr = this._hAttr;
        hAttr.put(this.SUMMARY._name, this.SUMMARY);
    }

    public UnknownAttribute getAttribute(String name) {
        return this._hAttr.get(name);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.sval = null;
        this.tag = null;
        if (this.attrs != null) {
            this.attrs.clear();
            this.attrs = null;
        }
        this._reader = null;
        this._sb = null;
    }

    public String toString() {
        String name = HTMLTokenizer.class.getName();
        return name.substring(name.lastIndexOf(46) + 1) + "[ ttype " + (this.ttype == 0 ? "TT_SPACE" : (this.ttype == 1 ? "TT_TEXT" : (this.ttype == 2 ? "TT_TAG" : (this.ttype == 3 ? "TT_COMMENT" : "Unknown")))) + "(" + this.ttype + ") sval (" + this.sval + ") tag (" + String.valueOf(this.tag) + ") isEndTag " + this.isEndTag + ": isRegularComment " + this.isRegularComment + " ]";
    }

    public void spaceToken(boolean flag) {
        this._spaceToken = flag;
    }

    public void pushBack() {
        this._pushBackType = this.ttype;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextToken() throws IOException {
        int c;
        StringBuffer sb;
        Reader reader;
        block43: {
            boolean isRegular;
            int tagEnd;
            block45: {
                block44: {
                    if (this._pushBackType != -1) {
                        int ptok = this._pushBackType;
                        this._pushBackType = -1;
                        return ptok;
                    }
                    reader = this._reader;
                    sb = this._sb;
                    block0: while (true) {
                        if (this._pushBackChar == -1) {
                            c = reader.read();
                        } else {
                            c = this._pushBackChar;
                            this._pushBackChar = -1;
                        }
                        sb.setLength(0);
                        this.sval = null;
                        this.tag = null;
                        this.attrs = null;
                        this.isEndTag = false;
                        this.isRegularComment = false;
                        if (c < 0) {
                            this.ttype = -1;
                            return -1;
                        }
                        if (!Character.isWhitespace(c)) {
                            if (c != 60) break block43;
                            sb.append((char)c);
                            c = reader.read();
                            tagEnd = -1;
                            if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                                sb.append((char)c);
                                break;
                            }
                            if (c == 47) break block44;
                            if (c != 33) break block43;
                            isRegular = false;
                            sb.append((char)c);
                            c = reader.read();
                            if (c != 45) break block45;
                            sb.append((char)c);
                            c = reader.read();
                            if (c == 45) {
                                sb.append((char)c);
                                isRegular = true;
                                c = reader.read();
                            }
                            break block45;
                        }
                        sb.append((char)c);
                        while (true) {
                            if (!Character.isWhitespace(c = reader.read())) {
                                this._pushBackChar = c;
                                if (!this._spaceToken || this._textType == 0) continue block0;
                                this.sval = sb.toString();
                                this._textType = 0;
                                this.ttype = 0;
                                return 0;
                            }
                            sb.append((char)c);
                        }
                        break;
                    }
                    while (true) {
                        c = reader.read();
                        if (tagEnd < 0 && Character.isWhitespace(c)) {
                            tagEnd = sb.length();
                        } else {
                            if (c == 62) {
                                if (tagEnd < 0) {
                                    tagEnd = sb.length();
                                }
                                String name = sb.substring(1, tagEnd).toLowerCase();
                                this.tag = HTML.getTag(name);
                                if (this.tag == null) {
                                    this.tag = new HTML.UnknownTag(name);
                                }
                                this.sval = sb.substring(tagEnd);
                                this.parseAttributes(this.sval, sb);
                                this.ttype = 2;
                                return 2;
                            }
                            if (c != 34 && c != 39) {
                                if (c < 0) {
                                    this._pushBackChar = c;
                                    this.sval = sb.toString().trim();
                                    this._textType = 1;
                                    this.ttype = 1;
                                    return 1;
                                }
                            } else {
                                int lit = c;
                                sb.append((char)c);
                                while ((c = reader.read()) != lit) {
                                    if (c < 0) {
                                        this._pushBackChar = c;
                                        this.sval = sb.toString().trim();
                                        this._textType = 1;
                                        this.ttype = 1;
                                        return 1;
                                    }
                                    sb.append((char)c);
                                }
                            }
                        }
                        sb.append((char)c);
                    }
                }
                sb.append((char)c);
                while (true) {
                    c = reader.read();
                    if (tagEnd < 0 && Character.isWhitespace(c)) {
                        tagEnd = sb.length();
                    } else {
                        if (c == 62) {
                            if (tagEnd < 0) {
                                tagEnd = sb.length();
                            }
                            String name = sb.substring(2, tagEnd).toLowerCase();
                            this.tag = HTML.getTag(name);
                            if (this.tag == null) {
                                this.tag = new HTML.UnknownTag(name);
                            }
                            this.isEndTag = true;
                            this.sval = sb.substring(tagEnd);
                            this.ttype = 2;
                            return 2;
                        }
                        if (c < 0) {
                            this._pushBackChar = c;
                            this.sval = sb.toString().trim();
                            this._textType = 1;
                            this.ttype = 1;
                            return 1;
                        }
                    }
                    sb.append((char)c);
                }
            }
            while (true) {
                if (c == 62) {
                    if (!isRegular) {
                        this.sval = sb.substring(1);
                        this.ttype = 3;
                        return 3;
                    }
                    if (tagEnd < 0) {
                        reader.mark(Math.max(0x100000, this._size));
                        tagEnd = sb.length();
                    }
                } else if (c == 45) {
                    if (isRegular) {
                        sb.append((char)c);
                        c = reader.read();
                        if (c == 45) {
                            sb.append((char)c);
                            c = reader.read();
                            if (c == 62) {
                                this.isRegularComment = true;
                                this.sval = sb.substring(1);
                                this.ttype = 3;
                                return 3;
                            }
                        }
                        if (c < 0) {
                            continue;
                        }
                    }
                } else if (c < 0) {
                    if (tagEnd >= 0) {
                        reader.reset();
                        this.sval = sb.substring(1, tagEnd);
                        this.ttype = 3;
                        return 3;
                    }
                    this._pushBackChar = c;
                    this.sval = sb.toString().trim();
                    this._textType = 1;
                    this.ttype = 1;
                    return 1;
                }
                sb.append((char)c);
                c = reader.read();
            }
        }
        sb.append((char)c);
        while (true) {
            c = reader.read();
            if (this._spaceToken && Character.isWhitespace(c) || c == 60 || c < 0) {
                this._pushBackChar = c;
                this.sval = sb.toString().trim();
                this._textType = 1;
                this.ttype = 1;
                return 1;
            }
            sb.append((char)c);
        }
    }

    void parseAttributes(String value, StringBuffer sb) {
        Hashtable<HTML.Attribute, String> hash = null;
        char[] ach = value.toCharArray();
        int len = ach.length;
        int i = 0;
        while (i < len) {
            char ch = ach[i];
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                int tagBegin = i++;
                while (i < len) {
                    if (ach[i] == '=' || Character.isWhitespace(ach[i])) {
                        int tagEnd = i;
                        String aval = "";
                        if ((i = HTMLTokenizer.skipSpace(ach, i)) < 0 || ach[i] != '=' || (i = HTMLTokenizer.skipSpace(ach, i + 1)) < 0) {
                            i = tagEnd;
                        } else {
                            int ti;
                            if (ach[i] == '\"' || ach[i] == '\'') {
                                ti = i + 1;
                                if ((i = value.indexOf(ach[i], ti)) < 0) {
                                    i = len;
                                }
                            } else {
                                ti = i++;
                                while (i < len) {
                                    if (Character.isWhitespace(ach[i])) break;
                                    ++i;
                                }
                            }
                            aval = new String(ach, ti, i - ti);
                        }
                        String aname = new String(ach, tagBegin, tagEnd - tagBegin).toLowerCase();
                        Object attr = HTML.getAttributeKey(aname);
                        if (attr == null && (attr = this._hAttr.get(aname)) == null) {
                            attr = new UnknownAttribute(aname);
                            this._hAttr.put(aname, (UnknownAttribute)attr);
                        }
                        if (hash == null) {
                            hash = new Hashtable<HTML.Attribute, String>();
                        }
                        hash.put((HTML.Attribute)attr, aval);
                        break;
                    }
                    ++i;
                }
            }
            this.attrs = hash;
            ++i;
        }
    }

    public int findToken(int ttype) throws IOException {
        while (this.nextToken() != -1) {
            if (this.ttype != ttype) continue;
            return ttype;
        }
        return -1;
    }

    public int findTag(HTML.Tag tag) throws IOException {
        return this.findTag(tag, null);
    }

    public int findTag(HTML.Tag tag, HTML.Attribute attr) throws IOException {
        while (this.nextToken() != -1) {
            if (this.ttype != 2 || this.tag != tag || attr != null && (this.attrs == null || this.attrs.get(attr) == null)) continue;
            return this.ttype;
        }
        return -1;
    }

    static int skipSpace(char[] ach, int index) {
        int len = ach.length;
        while (index < len) {
            if (!Character.isWhitespace(ach[index])) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    static int toSpace(char[] ach, int index) {
        int len = ach.length;
        while (index < len) {
            if (Character.isWhitespace(ach[index])) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public class UnknownAttribute {
        private String _name;

        public UnknownAttribute(String id) {
            this._name = id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnknownAttribute) {
                return this._name.equals(obj.toString());
            }
            return this._name.equals(obj);
        }

        public String toString() {
            return this._name;
        }
    }
}

