/*
 * Decompiled with CFR 0.152.
 */
package rabbit.util;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import rabbit.util.ErrorMessage;
import rabbit.util.MessageOperator;
import rabbit.util.MoveWindow;
import rabbit.util.RabbitConstants;
import rabbit.util.RenderingLabel;

public class MessageDialog {
    static JDialog _dlg;
    static WindowListener _listener;
    static WindowListener _windowListener;
    static MessageOperator _operator;
    public static String strInformationTitle;
    public static String strQuestionTitle;
    public static String strErrorTitle;
    public static String strWarningTitle;
    public static String strPlainTitle;
    public static String[] strOk;
    public static String[] strOkCancel;
    public static String[] strYesNoCancel;
    static boolean showing;
    static JFrame frame;
    static Image iconImage;
    static String informationTitle;
    static String questionTitle;
    static String errorTitle;
    static String warningTitle;
    static String plainTitle;
    static String[] okOption;
    static String[] okCancelOption;
    static String[] yesNoCancelOption;

    static {
        _listener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                _dlg = null;
            }
        };
        _windowListener = null;
        strInformationTitle = "\u60c5\u5831";
        strQuestionTitle = "\u8cea\u554f";
        strErrorTitle = "\u30a8\u30e9\u30fc";
        strWarningTitle = "\u8b66\u544a";
        strPlainTitle = "";
        strOk = new String[]{"\u78ba\u8a8d"};
        strOkCancel = new String[]{"\u78ba\u8a8d", "\u53d6\u6d88\u3057"};
        strYesNoCancel = new String[]{"\u306f\u3044", "\u3044\u3044\u3048", "\u53d6\u6d88\u3057"};
        showing = true;
        informationTitle = "\u60c5\u5831";
        questionTitle = "\u8cea\u554f";
        errorTitle = "\u30a8\u30e9\u30fc";
        warningTitle = "\u8b66\u544a";
        plainTitle = "";
        okOption = strOk;
        okCancelOption = strOkCancel;
        yesNoCancelOption = strYesNoCancel;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("MessageDialog");
        MessageDialog.addFrame(frame);
        MessageDialog.setInformationTitle("MessageDialog \u60c5\u5831");
        MessageDialog.setWarningTitle("MessageDialog \u8b66\u544a");
        MessageDialog.setErrorTitle("MessageDialog \u30a8\u30e9\u30fc");
        final JButton bInfo = new JButton("\u60c5\u5831");
        final JButton bWarning = new JButton("\u8b66\u544a");
        JButton bError = new JButton("\u30a8\u30e9\u30fc");
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                final JButton[] bTarget = new JButton[1];
                MessageDialog.setOperator(new MessageOperator(){

                    @Override
                    public void setOkButton(JButton bOk) {
                        bOk.setEnabled(false);
                        bTarget[0] = bOk;
                    }
                });
                JLabel label = new JLabel("\u30c1\u30a7\u30c3\u30af\u3092\u5165\u308c\u3066\u4e0b\u3055\u3044\u3002");
                final JCheckBox cbOk = new JCheckBox();
                cbOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        bTarget[0].setEnabled(cbOk.isSelected());
                    }
                });
                JPanel panel = new JPanel();
                panel.add(cbOk);
                panel.add(label);
                Object obj = evt.getSource();
                if (evt.getSource() == bInfo) {
                    int ans = MessageDialog.select2Message(panel, 1);
                } else {
                    int ans = MessageDialog.select3Message(panel, obj == bWarning ? 2 : 0);
                }
            }
        };
        bInfo.addActionListener(listener);
        bWarning.addActionListener(listener);
        bError.addActionListener(listener);
        JPanel p = new JPanel();
        p.add(bInfo);
        p.add(bWarning);
        p.add(bError);
        frame.getContentPane().add(p);
        frame.pack();
        frame.setVisible(true);
    }

    public static JDialog getDialog() {
        return _dlg;
    }

    public static synchronized void addWindowListener(WindowListener listener) {
        _windowListener = AWTEventMulticaster.add(_windowListener, listener);
    }

    public static synchronized void removeWindowListener(WindowListener listener) {
        _windowListener = AWTEventMulticaster.remove(_windowListener, listener);
    }

    public static void setOperator(MessageOperator operator) {
        _operator = operator;
    }

    public static boolean isShowing() {
        return showing;
    }

    public static void setShowing(boolean flag) {
        showing = flag;
    }

    static Frame getFrame() {
        return frame;
    }

    public static void addFrame(JFrame jframe) {
        frame = jframe;
    }

    public static void removeFrame(JFrame jframe) {
        if (frame == jframe) {
            frame = null;
        }
    }

    public static void setIcon(Image iconImage) {
        MessageDialog.iconImage = iconImage;
    }

    public static void setInformationTitle(String s) {
        informationTitle = s;
    }

    public static void setQuestionTitle(String s) {
        questionTitle = s;
    }

    public static void setErrorTitle(String s) {
        errorTitle = s;
    }

    public static void setWarningTitle(String s) {
        warningTitle = s;
    }

    public static void setPlainTitle(String s) {
        plainTitle = s;
    }

    public static void setOkOption(String[] as) {
        if (as.length >= 1) {
            okOption = as;
        }
    }

    public static String[] getOkCancelOption() {
        return okCancelOption;
    }

    public static void setOkCancelOption(String[] as) {
        if (as.length >= 2) {
            okCancelOption = as;
        }
    }

    public static String[] getYesNoCancelOption() {
        return yesNoCancelOption;
    }

    public static void setYesNoCancelOption(String[] as) {
        if (as.length >= 3) {
            yesNoCancelOption = as;
        }
    }

    static JDialog getDialog(JOptionPane optionPane, JFrame frame, String title) {
        JDialog dialog = optionPane.createDialog(frame, title);
        dialog.setIconImage(iconImage);
        dialog.addWindowListener(_listener);
        WindowListener windowListener = _windowListener;
        if (_windowListener != null) {
            dialog.addWindowListener(windowListener);
        }
        if (frame != null) {
            dialog.setIconImage(frame.getIconImage());
        }
        return dialog;
    }

    public static void informationMessage(Object obj) {
        MessageDialog.informationMessage(obj, null);
    }

    public static void informationMessage(Object obj, Icon icon1) {
        if (showing) {
            obj = MessageDialog.toMessage(obj);
            MessageDialog.setSize(obj);
            JOptionPane opane = new JOptionPane(obj, 1, 0, null, okOption, okOption[0]);
            JDialog dlg = _dlg = MessageDialog.getDialog(opane, frame, informationTitle);
            dlg.pack();
            MoveWindow.toCenter(dlg);
            dlg.setVisible(true);
        }
    }

    public static void errorMessage(ErrorMessage errormessage) {
        if (errormessage.isError()) {
            MessageDialog.errorMessage(errormessage.getErrorMessage());
        }
    }

    public static void errorMessage(Object obj) {
        if (showing) {
            if (obj instanceof Exception) {
                ((Exception)obj).printStackTrace();
            }
            obj = MessageDialog.toMessage(obj);
            MessageDialog.setSize(obj);
            JOptionPane opane = new JOptionPane(obj, 0, 0, null, okOption, okOption[0]);
            JDialog dlg = _dlg = MessageDialog.getDialog(opane, frame, errorTitle);
            dlg.pack();
            MoveWindow.toCenter(dlg);
            dlg.setVisible(true);
        }
    }

    public static void warningMessage(Object obj) {
        if (showing) {
            obj = MessageDialog.toMessage(obj);
            MessageDialog.setSize(obj);
            JOptionPane opane = new JOptionPane(obj, 2, 0, null, okOption, okOption[0]);
            JDialog dlg = _dlg = MessageDialog.getDialog(opane, frame, warningTitle);
            dlg.pack();
            MoveWindow.toCenter(dlg);
            dlg.setVisible(true);
        }
    }

    public static int select2Message(Object obj) {
        return MessageDialog.select2Message(0, obj, 3);
    }

    public static int select2Message(int init, Object obj) {
        return MessageDialog.select2Message(init, obj, 3);
    }

    public static int select2Message(Object obj, int type) {
        return MessageDialog.select2Message(0, obj, type);
    }

    public static int select2Message(int init, Object obj, int type) {
        if (showing) {
            obj = MessageDialog.toMessage(obj);
            MessageDialog.setSize(obj);
            JOptionPane opane = new JOptionPane(obj, type, 2, null, okCancelOption, init >= 0 ? okCancelOption[init] : null);
            JDialog dlg = _dlg = MessageDialog.getDialog(opane, frame, MessageDialog.getOptionTitle(type));
            if (_operator != null) {
                _operator.setOkButton(MessageDialog.getOkButton(dlg.getContentPane()));
            }
            dlg.pack();
            MoveWindow.toCenter(dlg);
            dlg.setVisible(true);
            int ans = 2;
            Object selectedValue = opane.getValue();
            if (selectedValue == null) {
                ans = -1;
            } else {
                int counter = 0;
                int maxCounter = okCancelOption.length;
                while (true) {
                    if (counter >= maxCounter) {
                        ans = -1;
                        break;
                    }
                    if (okCancelOption[counter].equals(selectedValue)) {
                        ans = counter;
                        break;
                    }
                    ++counter;
                }
            }
            return ans;
        }
        return 2;
    }

    static JButton getOkButton(Container c) {
        Component[] comp = c.getComponents();
        int len = comp.length;
        int i = 0;
        while (i < len) {
            JButton button;
            String text;
            if (comp[i] instanceof JButton && ((text = ((JButton)comp[i]).getText()).equals(okCancelOption[0]) || text.equals(yesNoCancelOption[0]))) {
                return (JButton)comp[i];
            }
            if (comp[i] instanceof Container && (button = MessageDialog.getOkButton((Container)comp[i])) != null) {
                return button;
            }
            ++i;
        }
        return null;
    }

    public static int select3Message(Object obj) {
        return MessageDialog.select3Message(0, obj, 3);
    }

    public static int select3Message(Object obj, int type) {
        return MessageDialog.select3Message(0, obj, type);
    }

    public static int select3Message(int init, Object obj) {
        return MessageDialog.select3Message(init, obj, 3);
    }

    public static int select3Message(int init, Object obj, int type) {
        if (showing) {
            obj = MessageDialog.toMessage(obj);
            MessageDialog.setSize(obj);
            JOptionPane opane = new JOptionPane(obj, type, 1, null, yesNoCancelOption, init >= 0 ? yesNoCancelOption[init] : null);
            JDialog dlg = _dlg = MessageDialog.getDialog(opane, frame, MessageDialog.getOptionTitle(type));
            if (_operator != null) {
                _operator.setOkButton(MessageDialog.getOkButton(dlg.getContentPane()));
            }
            dlg.pack();
            MoveWindow.toCenter(dlg);
            dlg.setVisible(true);
            int ans = 2;
            Object selectedValue = opane.getValue();
            if (selectedValue == null) {
                ans = -1;
            } else {
                int counter = 0;
                int maxCounter = yesNoCancelOption.length;
                while (true) {
                    if (counter >= maxCounter) {
                        ans = -1;
                        break;
                    }
                    if (yesNoCancelOption[counter].equals(selectedValue)) {
                        ans = counter;
                        break;
                    }
                    ++counter;
                }
            }
            return ans;
        }
        return 2;
    }

    public static Object toMessage(Object obj) {
        Component comp;
        if (obj instanceof Exception) {
            Exception exception = (Exception)obj;
            String s = exception.toString();
            int i = s.indexOf(58) + 1;
            String s1 = s.substring(i);
            Object s2 = "";
            int j = s1.length();
            int k = 0;
            while (k < j) {
                int l = 0;
                int i1 = k;
                int j1 = 0;
                while (k < j && j1 < 60) {
                    l = s1.charAt(k);
                    if (l >= 256) {
                        ++j1;
                    }
                    ++k;
                    ++j1;
                }
                while (k < j && l != 32 && l < 256) {
                    l = s1.charAt(k++);
                }
                s2 = (String)s2 + "\n" + s1.substring(i1, k);
            }
            JTextArea tarea = new JTextArea(s.substring(0, i) + (String)s2){

                @Override
                public void paint(Graphics g) {
                    RabbitConstants.setRenderingHint((Graphics2D)g, null);
                    super.paint(g);
                }
            };
            tarea.setEditable(false);
            comp = tarea;
        } else {
            comp = obj instanceof Component ? (Component)obj : new RenderingLabel("<HTML>" + obj.toString().replaceAll("\\n", "<BR>"));
        }
        return comp;
    }

    static void setSize(Object obj) {
        if (obj instanceof JComponent) {
            JComponent comp = (JComponent)obj;
            Dimension d = comp.getPreferredSize();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension d1 = toolkit.getScreenSize();
            int i = d1.width * 8 / 10;
            int j = d1.height * 6 / 10;
            if (d.width > i || d.height > j) {
                Dimension d2 = new Dimension(Math.min(d.width, i), Math.min(d.height, j));
                comp.setPreferredSize(d2);
            }
        }
    }

    static String getOptionTitle(int type) {
        return type != 0 ? (type != 2 ? (type != 1 ? (type != -1 ? questionTitle : plainTitle) : informationTitle) : warningTitle) : errorTitle;
    }
}

