/*
 * Decompiled with CFR 0.152.
 */
package rabbit.util;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import rabbit.util.RabbitConstants;

public class MoveWindow {
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int WEST = 2;
    public static final int EAST = 3;
    public static final int NORTHWEST = 4;
    public static final int NORTHEAST = 5;
    public static final int SOUTHWEST = 6;
    public static final int SOUTHEAST = 7;
    public static final int CENTER = 8;

    public static void main(String[] args) {
        try {
            final JFrame frame = new JFrame("MoveWindow");
            final String AL_XY = "XY";
            final String AL_NW = "NW";
            final String AL_NORTH = "NORTH";
            final String AL_NE = "NE";
            final String AL_WEST = "WEST";
            final String AL_CENTER = "CENTER";
            final String AL_EAST = "EAST";
            final String AL_SW = "SW";
            final String AL_SOUTH = "SOUTH";
            String AL_SE = "SE";
            String[] alignments = new String[]{AL_NW, AL_NORTH, AL_NE, AL_WEST, AL_CENTER, AL_EAST, AL_SW, AL_SOUTH, AL_SE};
            final JSpinner spX = new JSpinner();
            final JSpinner spY = new JSpinner();
            final JLabel lX = new JLabel(String.valueOf(0), 4);
            final JLabel lY = new JLabel(String.valueOf(0), 4);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JButton button = (JButton)evt.getSource();
                    String text = button.getText();
                    if (AL_XY.equals(text)) {
                        MoveWindow.moveToXY(frame, (Integer)spX.getValue(), (Integer)spY.getValue());
                    } else {
                        MoveWindow.moveTo(frame, AL_NW.equals(text) ? 4 : (AL_NORTH.equals(text) ? 0 : (AL_NE.equals(text) ? 5 : (AL_WEST.equals(text) ? 2 : (AL_CENTER.equals(text) ? 8 : (AL_EAST.equals(text) ? 3 : (AL_SW.equals(text) ? 6 : (AL_SOUTH.equals(text) ? 1 : 7))))))));
                    }
                }
            };
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent arg0) {
                    Dimension wd = frame.getSize();
                    Dimension sysd = RabbitConstants.getScreenSize(null);
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice dgd = ge.getDefaultScreenDevice();
                    GraphicsConfiguration dgc = dgd.getDefaultConfiguration();
                    Insets ins = Toolkit.getDefaultToolkit().getScreenInsets(dgc);
                    int maxx = sysd.width - ins.right;
                    int maxy = sysd.height - ins.bottom;
                    SpinnerNumberModel modelX = new SpinnerNumberModel(100, 0, maxx, 1);
                    SpinnerNumberModel modelY = new SpinnerNumberModel(100, 0, maxy, 1);
                    lX.setText(String.format("(%d)", maxx));
                    lY.setText(String.format("(%d)", maxy));
                    spX.setModel(modelX);
                    spY.setModel(modelY);
                }
            });
            JButton bXY = new JButton(AL_XY);
            bXY.addActionListener(listener);
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(5, 3));
            panel.add(new JPanel());
            panel.add(lX);
            panel.add(lY);
            panel.add(bXY);
            panel.add(spX);
            panel.add(spY);
            int len = alignments.length;
            int i = 0;
            while (i < len) {
                JButton button = new JButton(alignments[i]);
                button.addActionListener(listener);
                panel.add(button);
                ++i;
            }
            frame.getContentPane().add(panel);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toCenter(Window window) {
        MoveWindow.moveTo(window, 8);
    }

    public static void moveTo(Window window, int type) {
        int y;
        int x;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dgd = ge.getDefaultScreenDevice();
        GraphicsConfiguration dgc = dgd.getDefaultConfiguration();
        Insets ins = toolkit.getScreenInsets(dgc);
        Dimension sysd = toolkit.getScreenSize();
        Dimension wd = window.getSize();
        switch (type) {
            case 0: 
            case 1: 
            case 8: {
                x = (sysd.width - wd.width) / 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                x = ins.left;
                break;
            }
            default: {
                x = sysd.width - wd.width - ins.right;
            }
        }
        switch (type) {
            case 2: 
            case 3: 
            case 8: {
                y = (sysd.height - wd.height) / 2;
                break;
            }
            case 0: 
            case 4: 
            case 5: {
                y = ins.top;
                break;
            }
            default: {
                y = sysd.height - wd.height - ins.bottom;
            }
        }
        window.setLocation(x, y);
    }

    public static void moveToXY(Window window, int x, int y) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dgd = ge.getDefaultScreenDevice();
        GraphicsConfiguration dgc = dgd.getDefaultConfiguration();
        Insets ins = toolkit.getScreenInsets(dgc);
        Dimension sysd = toolkit.getScreenSize();
        Dimension wd = window.getSize();
        x = Math.min(x, sysd.width - wd.width - ins.right);
        y = Math.min(y, sysd.height - wd.height - ins.bottom);
        window.setLocation(Math.max(x, ins.left), Math.max(y, ins.top));
    }

    public static Point adjustInsets(int x, int y, int width, int height) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dgd = ge.getDefaultScreenDevice();
        GraphicsConfiguration dgc = dgd.getDefaultConfiguration();
        Insets ins = toolkit.getScreenInsets(dgc);
        Dimension sysd = toolkit.getScreenSize();
        if (x + width > sysd.width - ins.right) {
            x = sysd.width - ins.right - width;
        }
        if (x < ins.left) {
            x = ins.left;
        }
        if (y + height > sysd.height - ins.bottom) {
            y = sysd.height - ins.bottom - height;
        }
        if (y < ins.top) {
            y = ins.top;
        }
        return new Point(x, y);
    }
}

