/*
 * Decompiled with CFR 0.152.
 */
package rabbit.util;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.text.AttributedCharacterIterator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class RConsole
extends JEditorPane {
    boolean _isInit;
    boolean _isPrintDate;
    int _editable_pos;
    static final Color _inputColor = new Color(16, 112, 16);
    static final Color _normalColor = Color.black;
    static final Color _warningColor = new Color(16, 16, 240);
    static final Color _errorColor = new Color(255, 64, 0);
    StyledEditorKit.ForegroundAction _foregroundActionInput;
    StyledEditorKit.BoldAction _boldAction;
    LinkedBlockingQueue<ConsoleMessage> _queue = new LinkedBlockingQueue();
    ComponentListener _componentListener = new ComponentListener(){

        @Override
        public void componentShown(ComponentEvent evt) {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            if (!RConsole.this._isInit) {
                RConsole.this.removeComponentListener(RConsole.this._componentListener);
                RConsole.this.setScrollBarPosition();
            }
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
        }

        @Override
        public void componentHidden(ComponentEvent evt) {
        }
    };
    boolean _caretUpdate;
    int _committedCharacterCount;

    public static void main(String[] args) {
        JFrame frame = new JFrame("RConsole");
        final JTextField field = new JTextField(50);
        JButton bAppend = new JButton("Append");
        JButton bClear = new JButton("Clear");
        final RConsole console = new RConsole();
        bClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                console.clear();
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                console.append(field.getText() + "\n");
            }
        };
        bAppend.addActionListener(listener);
        field.addActionListener(listener);
        JPanel p1 = new JPanel();
        p1.add(bClear);
        p1.add(bAppend);
        p1.add(field);
        JPanel p0 = new JPanel();
        p0.setLayout(new GridLayout(2, 1));
        p0.add(p1);
        p0.add(new JScrollPane(console));
        frame.getContentPane().add(p0);
        frame.pack();
        frame.setVisible(true);
    }

    public RConsole() {
        this(false);
    }

    public RConsole(boolean isPrintDate) {
        this._isPrintDate = isPrintDate;
        this.setInit();
    }

    public void append(String text) {
        this.setCaretPosition(this.getText().length());
        this.replaceSelection(text);
    }

    @Override
    public void setText(String text) {
        new Exception("RConsole.setText can't be called. There's clear instead.").printStackTrace();
    }

    public void clear() {
        super.setText("");
        this._editable_pos = 0;
    }

    void setInit() {
        this.setDocument(new DefaultStyledDocument(new StyleContext()));
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setForeground(attr, new Color(255, 255, 0));
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                RConsole.this._caretUpdate = true;
                RConsole.this._caretUpdate = false;
            }
        });
        this.addComponentListener(this._componentListener);
        Font font = this.getFont();
        this.setFont(new Font("\uff2d\uff33 \u660e\u671d", font.getStyle(), font.getSize()));
        this.setDocument(new DefaultStyledDocument());
        this.setEditorKit(new StyledEditorKit());
        this._foregroundActionInput = new StyledEditorKit.ForegroundAction("set-foreground-input", _inputColor);
        this._boldAction = new StyledEditorKit.BoldAction();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        ConsoleMessage cm = null;
                        try {
                            cm = RConsole.this._queue.take();
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        DefaultStyledDocument doc = (DefaultStyledDocument)RConsole.this.getDocument();
                        Caret caret = RConsole.this.getCaret();
                        int length = RConsole.this.getDocument().getLength();
                        caret.setDot(length);
                        try {
                            Object message = length > 0 && doc.getText(length - 1, 1).charAt(0) != '\n' ? "\n" + cm.message : cm.message;
                            int len = ((String)message).length();
                            DefaultStyledDocument defaultStyledDocument = doc;
                            synchronized (defaultStyledDocument) {
                                doc.insertString(length, (String)message, null);
                                RConsole.this._editable_pos = length + len;
                                SimpleAttributeSet saset = new SimpleAttributeSet();
                                StyleConstants.ColorConstants.setForeground(saset, cm.fgcolor);
                                doc.setCharacterAttributes(length, len, saset, true);
                                continue;
                            }
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setScrollBarPosition() {
        JScrollPane pane;
        JScrollBar vbar;
        JViewport vport;
        Container vparent;
        Container parent = this.getParent();
        if (parent instanceof JViewport && (vparent = (vport = (JViewport)parent).getParent()) instanceof JScrollPane && (vbar = (pane = (JScrollPane)vparent).getVerticalScrollBar()).isVisible()) {
            this._isInit = true;
            this.removeComponentListener(this._componentListener);
            JScrollBar jScrollBar = vbar;
            synchronized (jScrollBar) {
                vbar.setValue(vbar.getMaximum());
            }
        }
    }

    public boolean isPrintDate() {
        return this._isPrintDate;
    }

    public void setPrintTime(boolean isPrintDate) {
        this._isPrintDate = isPrintDate;
    }

    String cleanMessage(String message) {
        return message.replace("\b+", "");
    }

    public void normalMessage(String message) {
        this.printMessage(message, _normalColor);
    }

    public void warningMessage(String message) {
        this.printMessage(message, _warningColor);
    }

    public void errorMessage(String message) {
        this.printMessage(message, _errorColor);
    }

    void printMessage(String message, Color fgcolor) {
        message = this.cleanMessage(message);
        ConsoleMessage cmessage = new ConsoleMessage(message, fgcolor, this._isPrintDate);
        this._queue.add(cmessage);
    }

    void setInputMode() {
        this._foregroundActionInput.actionPerformed(new ActionEvent(this, 1001, (String)this._foregroundActionInput.getValue("Name")));
        this._boldAction.actionPerformed(new ActionEvent(this, 1001, "true"));
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent evt) {
        AttributedCharacterIterator attr = evt.getText();
        if (attr == null) {
            DefaultStyledDocument doc = (DefaultStyledDocument)this.getDocument();
            int len = doc.getLength();
            SimpleAttributeSet saset = new SimpleAttributeSet();
            StyleConstants.ColorConstants.setForeground(saset, _inputColor);
            doc.setCharacterAttributes(len - this._committedCharacterCount, this._committedCharacterCount, saset, true);
        } else {
            int committedCharacterCount = evt.getCommittedCharacterCount();
            if (committedCharacterCount > 0) {
                this._committedCharacterCount = committedCharacterCount;
                Caret caret = this.getCaret();
                int cp = caret.getDot();
                DefaultStyledDocument doc = (DefaultStyledDocument)this.getDocument();
                int pos = caret.getDot();
                if (pos < this._editable_pos) {
                    caret.setDot(doc.getLength());
                }
            }
        }
        super.processInputMethodEvent(evt);
    }

    @Override
    protected void processKeyEvent(KeyEvent evt) {
        switch (evt.getID()) {
            case 401: {
                if (evt.isAltDown() || evt.isControlDown() || evt.getKeyChar() == '\uffff') break;
                Caret caret = this.getCaret();
                int pos = caret.getDot();
                if (evt.getKeyCode() == 8) {
                    if (pos > this._editable_pos) break;
                    StyledDocument doc = (StyledDocument)this.getDocument();
                    caret.setDot(doc.getLength());
                    evt.consume();
                    break;
                }
                StyledDocument doc = (StyledDocument)this.getDocument();
                if (pos < this._editable_pos) {
                    caret.setDot(doc.getLength());
                }
                this.setInputMode();
                break;
            }
        }
        super.processKeyEvent(evt);
    }

    class ConsoleMessage {
        String message;
        Color fgcolor;

        ConsoleMessage(String message, Color fgcolor, boolean isPrintDate) {
            this.message = (String)(isPrintDate ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()) + " " : "") + message;
            this.fgcolor = fgcolor;
        }
    }
}

