/*
 * Decompiled with CFR 0.152.
 */
package rabbit.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.invoke.CallSite;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class RabbitConstants {
    public static final boolean CLEANUP = true;
    public static final boolean CLEAN_FONTS = true;
    public static final boolean GRAPHICS_DISPOSE = true;
    public static final boolean OBSERVED_DRAW_IMAGE = false;
    public static final int BUTTON_MASK = 28;
    public static String DEFAULT_FONT_NAME = "\u30e1\u30a4\u30ea\u30aa";
    public static int DEFAULT_FONT_STYLE = 1;
    static final KeyListener escListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent evt) {
            Integer key = evt.getKeyCode();
            if (_hDeterrentKeyCode.get(key) != null) {
                return;
            }
            if (key == 27) {
                Component comp = evt.getComponent();
                while (comp != null) {
                    if (comp instanceof Window) {
                        Window window = (Window)comp;
                        window.setVisible(false);
                        break;
                    }
                    comp = comp.getParent();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            Integer key = evt.getKeyCode();
            if (_hDeterrentKeyCode.get(key) != null) {
                RabbitConstants.resetKeyCode(key);
            }
        }
    };
    static Hashtable<Integer, Integer> _hDeterrentKeyCode = new Hashtable();
    public static final int CONTRAST_MAX = 250;
    public static final int CONTRAST_DEFAULT = 170;
    public static final int CONTRAST_MIN = 100;

    public static int getFontStyle() {
        return DEFAULT_FONT_STYLE;
    }

    public static void setFontStyle(int style) {
        DEFAULT_FONT_STYLE = style & 3;
    }

    public static boolean isAfterJDK(String version) {
        String ver = System.getProperty("java.version").substring(0, 3);
        return Double.parseDouble(ver) >= Double.parseDouble(version);
    }

    public static boolean isOldJDK() {
        String ver = System.getProperty("java.version");
        return ver.equals("1.0") || ver.equals("1.1") || ver.equals("1.2");
    }

    public static boolean isSlowable() {
        return RabbitConstants.isLinux();
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static String getDateFormat(long date) {
        return RabbitConstants.getDateFormat(new Date(date));
    }

    public static String getDateFormat(Date date) {
        Object str = DateFormat.getDateTimeInstance().format(date);
        int index = ((String)str).indexOf(32);
        if (index >= 0 && ((String)str).charAt(index + 2) == ':') {
            str = ((String)str).substring(0, ++index) + "0" + ((String)str).substring(index);
        }
        return str;
    }

    public static String getShortDateFormat(long date) {
        return RabbitConstants.getDateFormat(date).substring(2);
    }

    public static String getShortDateFormat(Date date) {
        return RabbitConstants.getDateFormat(date).substring(2);
    }

    public static Dimension getScreenSize(Dimension pSize) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension sysd = toolkit.getScreenSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dgd = ge.getDefaultScreenDevice();
        GraphicsConfiguration dgc = dgd.getDefaultConfiguration();
        Insets ins = toolkit.getScreenInsets(dgc);
        int w = sysd.width - ins.left - ins.right;
        int h = sysd.height - ins.top - ins.bottom;
        if (pSize == null) {
            pSize = new Dimension(w, h);
        } else {
            pSize.width = w;
            pSize.height = h;
        }
        return pSize;
    }

    public static Rectangle getScreenBounds(Rectangle r) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension sysd = toolkit.getScreenSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dgd = ge.getDefaultScreenDevice();
        GraphicsConfiguration dgc = dgd.getDefaultConfiguration();
        Insets ins = toolkit.getScreenInsets(dgc);
        int w = sysd.width - ins.left - ins.right;
        int h = sysd.height - ins.top - ins.bottom;
        if (r == null) {
            r = new Rectangle(ins.left, ins.top, w, h);
        } else {
            r.x = ins.left;
            r.y = ins.top;
            r.width = w;
            r.height = h;
        }
        return r;
    }

    public static Component getChild(Container parent, Class tclass) {
        if (parent.getClass() == tclass) {
            return parent;
        }
        Component tchild = null;
        Component[] child = parent.getComponents();
        int len = child.length;
        int i = 0;
        while (i < len) {
            Component cc;
            if (child[i] instanceof Container && (cc = RabbitConstants.getChild((Container)child[i], tclass)) != null) {
                tchild = cc;
                break;
            }
            ++i;
        }
        return tchild;
    }

    public static void printProperties() {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        Properties prop = System.getProperties();
        Enumeration<Object> keys = prop.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            list.add((CallSite)((Object)(key + "=" + System.getProperty(key))));
        }
        int len = list.size();
        String[] aprop = list.toArray(new String[len]);
        Arrays.sort(aprop, new Comparator<String>(){

            @Override
            public int compare(String prev, String next) {
                return prev.compareTo(next);
            }
        });
        int i = 0;
        while (i < len) {
            System.out.println(aprop[i]);
            ++i;
        }
    }

    public static void deterrentKeyCode(int code) {
        Integer key = code;
        _hDeterrentKeyCode.put(key, key);
    }

    public static void resetKeyCode(int code) {
        _hDeterrentKeyCode.remove(code);
    }

    public static void setEscapeListener(Window window) {
        RabbitConstants.setKeyListener(window, escListener);
    }

    public static KeyListener getEscapeListener() {
        return escListener;
    }

    public static void setKeyListener(Window window, KeyListener listener) {
        if (window instanceof JFrame) {
            RabbitConstants._setKeyListener((JComponent)((JFrame)window).getContentPane(), listener);
        } else if (window instanceof JDialog) {
            RabbitConstants._setKeyListener((JComponent)((JDialog)window).getContentPane(), listener);
        }
    }

    public static void _setKeyListener(JComponent comp, KeyListener listener) {
        comp.removeKeyListener(listener);
        comp.addKeyListener(listener);
        Component[] comps = comp.getComponents();
        int len = comps.length;
        int i = 0;
        while (i < len) {
            if (comps[i] instanceof JComponent) {
                RabbitConstants._setKeyListener((JComponent)comps[i], listener);
            }
            ++i;
        }
    }

    public static void _resetKeyListener(JComponent comp, KeyListener listener) {
        comp.removeKeyListener(listener);
        Component[] comps = comp.getComponents();
        int len = comps.length;
        int i = 0;
        while (i < len) {
            if (comps[i] instanceof JComponent) {
                RabbitConstants._resetKeyListener((JComponent)comps[i], listener);
            }
            ++i;
        }
    }

    public static void setRenderingHint(Graphics2D g2, Integer contrastValue) {
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        if (contrastValue != null && 100 <= contrastValue && contrastValue <= 250) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, contrastValue);
        }
    }
}

