/*
 * Decompiled with CFR 0.152.
 */
package rabbit.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SetLayout {
    public static void setCustomLayout(Component comp) {
        SetLayout.setCustomLevelLayout("", comp);
    }

    protected static void setCustomLevelLayout(String s, Component comp) {
        comp.setFont(SetLayout.newFont(comp.getFont(), -1));
        if (comp instanceof JComponent) {
            Border border = ((JComponent)comp).getBorder();
            if (border != null && border.getClass().equals(TitledBorder.class)) {
                TitledBorder titledborder = (TitledBorder)border;
                titledborder.setTitleFont(SetLayout.newFont(titledborder.getTitleFont(), -1));
            }
            if (comp instanceof JTextField) {
                SetLayout.setMinimize((JTextField)comp);
            }
            if (comp instanceof AbstractButton) {
                SetLayout.setMinimize((AbstractButton)comp);
            } else if (comp instanceof JLabel) {
                SetLayout.setMinimize((JLabel)comp);
            }
        }
        if (comp instanceof Container) {
            int i;
            Component[] acomp;
            Container c = (Container)comp;
            LayoutManager lm = c.getLayout();
            if (lm != null) {
                Class<?> cls = lm.getClass();
                if (cls.equals(FlowLayout.class)) {
                    FlowLayout fl = (FlowLayout)lm;
                    fl.setAlignment(3);
                    fl.setHgap(2);
                    fl.setVgap(2);
                } else if (cls.equals(BorderLayout.class)) {
                    ((BorderLayout)lm).setHgap(2);
                    ((BorderLayout)lm).setVgap(2);
                }
            }
            if ((acomp = c.getComponents()) != null && (i = acomp.length) != 0) {
                int j = 0;
                while (j < i) {
                    SetLayout.setCustomLevelLayout(s + "  ", acomp[j]);
                    ++j;
                }
            }
        }
    }

    public static Font newFont(Font font, int i) {
        Font font1 = new Font(font.getName(), font.getStyle(), font.getSize() + i);
        return font1;
    }

    public static void setMinimize(JTextField field) {
        FontMetrics fm = field.getFontMetrics(field.getFont());
        Dimension d = field.getSize();
        d.height = fm.getHeight() + 2;
        field.setColumns(0);
        field.setMinimumSize(d);
        field.setMaximumSize(d);
        field.setPreferredSize(d);
    }

    public static void setMinimize(AbstractButton abutton) {
        abutton.setMargin(new Insets(0, 0, 0, 0));
        FontMetrics fm = abutton.getFontMetrics(abutton.getFont());
        Dimension d = (Dimension)abutton.getSize().clone();
        if (d.width <= 0 || d.width > 1000) {
            d = (Dimension)abutton.getMaximumSize().clone();
        }
        if (d.width <= 0 || d.width > 1000) {
            return;
        }
        Dimension d1 = new Dimension(d.width, fm.getHeight() + 2);
        abutton.setMinimumSize(d1);
        abutton.setMaximumSize(d1);
        abutton.setPreferredSize(d1);
        abutton.setSize(d1);
    }

    public static void setMinimize(JLabel label) {
        String s = label.getText();
        if (s.length() > 0) {
            FontMetrics fm = label.getFontMetrics(label.getFont());
            Dimension d = new Dimension(fm.stringWidth(s), fm.getHeight());
            label.setMinimumSize(d);
            label.setMaximumSize(d);
            label.setPreferredSize(d);
            label.setSize(d);
        }
    }

    public static void constraint(Container c, Component comp, int x, int y, int width, int height) {
        SetLayout.constraint(c, comp, x, y, width, height, 0.0, 0.0, 0, 10, 0, 0, 0, 0, 0, 0);
    }

    public static void constraint(Container c, Component comp, int x, int y, int width, int height, double weightx, double weighty, int fill, int anchor) {
        SetLayout.constraint(c, comp, x, y, width, height, weightx, weighty, fill, anchor, 0, 0, 0, 0, 0, 0);
    }

    public static void constraint(Container c, Component comp, int x, int y, int width, int height, double weightx, double weighty, int fill, int anchor, int padx, int pady) {
        SetLayout.constraint(c, comp, x, y, width, height, weightx, weighty, fill, anchor, 0, 0, 0, 0, padx, padx);
    }

    public static void constraint(Container c, Component comp, int x, int y, int width, int height, double weightx, double weighty, int fill, int anchor, int top, int left, int bottom, int right) {
        SetLayout.constraint(c, comp, x, y, width, height, weightx, weighty, fill, anchor, top, left, bottom, right, 0, 0);
    }

    public static void constraint(Container c, Component comp, int x, int y, int width, int height, double weightx, double weighty, int fill, int anchor, int top, int left, int bottom, int right, int padx, int pady) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        if (top != 0 || left != 0 || bottom != 0 || right != 0) {
            gbc.insets = new Insets(top, left, bottom, right);
        }
        if (padx != 0 || pady != 0) {
            gbc.ipadx = padx;
            gbc.ipady = pady;
        }
        ((GridBagLayout)c.getLayout()).setConstraints(comp, gbc);
        c.add(comp, gbc);
    }
}

