/*
 * Decompiled with CFR 0.152.
 */
package rabbit.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.basic.BasicLookAndFeel;
import rabbit.util.RabbitLookAndFeel;

public class SetLookAndFeel {
    private static UIManager.LookAndFeelInfo[] lookAndFeelInfo;

    public static void main(String[] args) {
        final JFrame frame = new JFrame("SetLookAndFeel");
        UIManager.LookAndFeelInfo[] alookandfeelinfo = SetLookAndFeel.getInfo();
        String name = SetLookAndFeel.getLookAndFeelName();
        int len = alookandfeelinfo.length;
        String[] astr = new String[len];
        int pos = 0;
        int i = 0;
        while (i < len) {
            astr[i] = alookandfeelinfo[i].getName();
            if (name.equals(astr[i])) {
                pos = i;
            }
            ++i;
        }
        final JComboBox<String> cb = new JComboBox<String>(astr);
        cb.setSelectedIndex(pos);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String name = (String)cb.getSelectedItem();
                try {
                    ClassLoader loader = this.getClass().getClassLoader();
                    SetLookAndFeel.set((Component)frame, name, loader);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    e.printStackTrace();
                }
            }
        });
        JLabel label = new JLabel("Look&Feel \u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044");
        JPanel panel0 = new JPanel();
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        panel1.add(label);
        panel1.add(cb);
        JButton button = new JButton("Button");
        JToggleButton toggleButton = new JToggleButton("ToggleButton");
        JRadioButton radioButton = new JRadioButton("RadioButton");
        JCheckBox checkBox = new JCheckBox("CheckBox");
        JTextField field = new JTextField("TextField");
        JTextArea tarea = new JTextArea("TextArea");
        JScrollPane sp = new JScrollPane(tarea);
        sp.setPreferredSize(new Dimension(100, 80));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("TabbedPane1", new JLabel("TabbedPane1"));
        tabbedPane.add("TabbedPane2", new JLabel("TabbedPane2"));
        tabbedPane.add("TabbedPane3", new JLabel("TabbedPane3"));
        tabbedPane.setPreferredSize(new Dimension(200, 150));
        Container c = frame.getContentPane();
        panel2.add(button);
        panel2.add(toggleButton);
        panel2.add(radioButton);
        panel2.add(checkBox);
        panel3.setLayout(new BoxLayout(panel3, 1));
        panel3.add(field);
        panel3.add(sp);
        panel3.add(tabbedPane);
        panel0.setLayout(new BoxLayout(panel0, 1));
        panel0.add(panel1);
        panel0.add(panel2);
        panel0.add(panel3);
        c.add(panel0);
        frame.pack();
        frame.setVisible(true);
    }

    public static String getLookAndFeelName() {
        return UIManager.getLookAndFeel().getName();
    }

    public static UIManager.LookAndFeelInfo[] getInfo() {
        if (lookAndFeelInfo == null) {
            UIManager.LookAndFeelInfo[] lFInfo = UIManager.getInstalledLookAndFeels();
            LookAndFeel lookandfeel = UIManager.getLookAndFeel();
            String lfName = lookandfeel != null ? lookandfeel.getName() : "";
            ArrayList<UIManager.LookAndFeelInfo> list = new ArrayList<UIManager.LookAndFeelInfo>();
            int idx = -1;
            int len = lFInfo.length;
            int i = 0;
            while (i < len) {
                try {
                    if (lfName.equals(lFInfo[i].getName())) {
                        idx = i;
                    } else {
                        UIManager.setLookAndFeel(lFInfo[i].getClassName());
                    }
                    list.add(lFInfo[i]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                ++i;
            }
            int size = list.size();
            UIManager.LookAndFeelInfo[] tlFInfo = new UIManager.LookAndFeelInfo[size];
            int i2 = 0;
            while (i2 < size) {
                tlFInfo[i2] = (UIManager.LookAndFeelInfo)list.get(i2);
                if (i2 == idx) {
                    try {
                        UIManager.setLookAndFeel(tlFInfo[i2].getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedLookAndFeelException e) {
                        e.printStackTrace();
                    }
                }
                ++i2;
            }
            lookAndFeelInfo = tlFInfo;
        }
        return lookAndFeelInfo;
    }

    public static int getIndexByName(String lfName) {
        UIManager.LookAndFeelInfo[] lFInfo = UIManager.getInstalledLookAndFeels();
        ArrayList list = new ArrayList();
        int idx = -1;
        int len = lFInfo.length;
        int i = 0;
        while (i < len) {
            if (lfName.equals(lFInfo[i].getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void set(Component component, String lfName, ClassLoader loader) throws ClassNotFoundException, IllegalAccessException, InstantiationException, UnsupportedLookAndFeelException {
        SetLookAndFeel.set(component, SetLookAndFeel.getIndexByName(lfName), loader);
    }

    public static void set(Component component, int idx, ClassLoader loader) throws ClassNotFoundException, IllegalAccessException, InstantiationException, UnsupportedLookAndFeelException {
        UIManager.LookAndFeelInfo[] info = SetLookAndFeel.getInfo();
        String lFName = info[idx].getClassName();
        if (!System.getProperty("os.name").startsWith("Windows") || lFName.indexOf("Metal") < 0) {
            UIManager.setLookAndFeel(lFName);
        } else {
            Class<?> lnfClass = loader.loadClass(lFName);
            try {
                LookAndFeel lookAndFeel = (LookAndFeel)lnfClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                try {
                    UIManager.setLookAndFeel(new RabbitLookAndFeel((BasicLookAndFeel)lookAndFeel));
                }
                catch (UnsupportedLookAndFeelException e) {
                    System.err.println(e);
                    UIManager.setLookAndFeel(lookAndFeel);
                }
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
        }
        SwingUtilities.updateComponentTreeUI(component);
    }
}

