/*
 * Decompiled with CFR 0.152.
 */
package rabbit.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import rabbit.util.MessageDialog;
import rabbit.util.MoveWindow;
import rabbit.util.RabbitConstants;
import rabbit.util.SetLayout;

public class SimpleHTMLFrame
extends JFrame {
    private ArrayList lListener = new ArrayList();
    public static final int BUTTON_MASK = 28;
    static String cutMJa = "\u5207\u308a\u53d6\u308a(T)";
    static String copyMJa = "\u30b3\u30d4\u30fc(C)";
    static String pasteMJa = "\u8cbc\u308a\u4ed8\u3051(P)";
    static String selectAllMJa = "\u3059\u3079\u3066\u9078\u629e(A)";
    static String prevPageJa = "\u623b\u3000\u308b";
    static String nextPageJa = "\u9032\u3000\u3080";
    static String closeHelpJa = "\u9589\u3058\u308b";
    static String searchWordJa = "\u691c\u7d22";
    static String searchGoJa = "\u6b21\u3092\u691c\u7d22";
    static String oppositeJa = "\u4e0a\u65b9\u5411";
    static String keyWordNotFoundErrorJa = "\uff1a\u6587\u5b57\u5217\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f";
    static String cutMEn = "Cut";
    static String copyMEn = "Copy";
    static String pasteMEn = "Paste";
    static String selectAllMEn = "Select all";
    static String prevPageEn = "Prev";
    static String nextPageEn = "Next";
    static String closeHelpEn = "Close";
    static String searchWordEn = "Search";
    static String searchGoEn = "Search next";
    static String oppositeEn = "For Above";
    static String keyWordNotFoundErrorEn = ": The character string was not found.";
    static String cutM;
    static String copyM;
    static String pasteM;
    static String selectAllM;
    static String prevPage;
    static String nextPage;
    static String closeHelp;
    static String searchWord;
    static String searchGo;
    static String opposite;
    static String keyWordNotFoundError;
    private JButton bPrev;
    private JButton bNext;
    private boolean isPrev;
    private JRadioButton rbOpposite;
    private JEditorPane editor;
    private Hashtable hSearch;
    private JComboBox cSearch;
    private JButton bSearch;
    private ListIterator hlist;
    private JScrollPane hsp;
    private AdjustmentListener hAdjustmentListener;
    private AdjustmentListener vAdjustmentListener;
    private JPopupMenu popupMenu;
    private JMenuItem miCut;
    private JMenuItem miCopy;
    private JMenuItem miPaste;
    private JMenuItem miSelectAll;

    static {
        SimpleHTMLFrame.setLanguage(System.getProperty("user.language"));
    }

    public static void main(String[] args) {
        try {
            SimpleHTMLFrame frame = new SimpleHTMLFrame("Brief\u3000Browser", new URL("https://www.yahoo.co.jp"));
            frame.setDefaultCloseOperation(2);
            frame.pack();
            Dimension d = RabbitConstants.getScreenSize(null);
            int min = Math.min(d.width, d.height);
            d.width = Math.round(0.99f * (float)min / 3.0f * 4.0f);
            d.height = Math.round(0.95f * (float)min);
            frame.setSize(d);
            MoveWindow.moveTo(frame, 0);
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.errorMessage(e);
            System.exit(1);
        }
    }

    public static void setLanguage(String lang) {
        if ("ja".equals(lang)) {
            cutM = cutMJa;
            copyM = copyMJa;
            pasteM = pasteMJa;
            selectAllM = selectAllMJa;
            prevPage = prevPageJa;
            nextPage = nextPageJa;
            closeHelp = closeHelpJa;
            searchWord = searchWordJa;
            searchGo = searchGoJa;
            opposite = oppositeJa;
            keyWordNotFoundError = keyWordNotFoundErrorJa;
        } else {
            cutM = cutMEn;
            copyM = copyMEn;
            pasteM = pasteMEn;
            selectAllM = selectAllMEn;
            prevPage = prevPageEn;
            nextPage = nextPageEn;
            closeHelp = closeHelpEn;
            searchWord = searchWordEn;
            searchGo = searchGoEn;
            opposite = oppositeEn;
            keyWordNotFoundError = keyWordNotFoundErrorEn;
        }
    }

    public SimpleHTMLFrame() {
        this.createSearch();
        this.setComponents();
    }

    public SimpleHTMLFrame(String title) {
        super(title);
        this.createSearch();
        this.setComponents();
    }

    public SimpleHTMLFrame(String title, URL url) throws IOException {
        this(title);
        this.setURL(url);
    }

    public void setOpposite(boolean isOpposite) {
        this.rbOpposite.setSelected(isOpposite);
    }

    public boolean isOpposite() {
        return this.rbOpposite.isSelected();
    }

    void createSearch() {
        String[] keys = new String[]{"\uff61", "\uff62", "\uff63", "\uff64", "\uff65", "\uff66", "\uff67", "\uff68", "\uff69", "\uff6a", "\uff6b", "\uff6c", "\uff6d", "\uff6e", "\uff6f", "\uff70", "\uff71", "\uff72", "\uff73", "\uff74", "\uff75", "\uff76", "\uff77", "\uff78", "\uff79", "\uff7a", "\uff7b", "\uff7c", "\uff7d", "\uff7e", "\uff7f", "\uff80", "\uff81", "\uff82", "\uff83", "\uff84", "\uff85", "\uff86", "\uff87", "\uff88", "\uff89", "\uff8a", "\uff8b", "\uff8c", "\uff8d", "\uff8e", "\uff8f", "\uff90", "\uff91", "\uff92", "\uff93", "\uff94", "\uff95", "\uff96", "\uff97", "\uff98", "\uff99", "\uff9a", "\uff9b", "\uff9c", "\uff9d", "\uff76\uff9e", "\uff77\uff9e", "\uff78\uff9e", "\uff79\uff9e", "\uff7a\uff9e", "\uff7b\uff9e", "\uff7c\uff9e", "\uff7d\uff9e", "\uff7e\uff9e", "\uff7f\uff9e", "\uff80\uff9e", "\uff81\uff9e", "\uff82\uff9e", "\uff83\uff9e", "\uff84\uff9e", "\uff8a\uff9e", "\uff8b\uff9e", "\uff8c\uff9e", "\uff8d\uff9e", "\uff8e\uff9e", "\uff8a\uff9f", "\uff8b\uff9f", "\uff8c\uff9f", "\uff8d\uff9f", "\uff8e\uff9f", "\uff21", "\uff22", "\uff23", "\uff24", "\uff25", "\uff26", "\uff27", "\uff28", "\uff29", "\uff2a", "\uff2b", "\uff2c", "\uff2d", "\uff2e", "\uff2f", "\uff30", "\uff31", "\uff32", "\uff33", "\uff34", "\uff35", "\uff36", "\uff37", "\uff38", "\uff39", "\uff3a", "\uff41", "\uff42", "\uff43", "\uff44", "\uff45", "\uff46", "\uff47", "\uff48", "\uff49", "\uff4a", "\uff4b", "\uff4c", "\uff4d", "\uff4e", "\uff4f", "\uff50", "\uff51", "\uff52", "\uff53", "\uff54", "\uff55", "\uff56", "\uff57", "\uff58", "\uff59", "\uff5a", "\u3000", "\uff0c", "\uff0e", "\uff01", "\uff1f", "\uff0d", "(", ")"};
        String[] data = new String[]{"\uff61", "\u300c", "\u300d", "\u3001", "\u30fb", "\u30f2", "\u30a1", "\u30a3", "\u30a5", "\u30a7", "\u30a9", "\u30e3", "\u30e5", "\u30e7", "\u30c3", "\u30fc", "\u30a2", "\u30a4", "\u30a6", "\u30a8", "\u30aa", "\u30ab", "\u30ad", "\u30af", "\u30b1", "\u30b3", "\u30b5", "\u30b7", "\u30b9", "\u30bb", "\u30bd", "\u30bf", "\u30c1", "\u30c4", "\u30c6", "\u30c8", "\u30ca", "\u30cb", "\u30cc", "\u30cd", "\u30ce", "\u30cf", "\u30d2", "\u30d5", "\u30d8", "\u30db", "\u30de", "\u30df", "\u30e0", "\u30e1", "\u30e2", "\u30e4", "\u30e6", "\u30e8", "\u30e9", "\u30ea", "\u30eb", "\u30ec", "\u30ed", "\u30ef", "\u30f3", "\u30ac", "\u30ae", "\u30b0", "\u30b2", "\u30b4", "\u30b6", "\u30b8", "\u30ba", "\u30bc", "\u30be", "\u30c0", "\u30c2", "\u30c5", "\u30c7", "\u30c9", "\u30d0", "\u30d3", "\u30d6", "\u30d9", "\u30dc", "\u30d1", "\u30d4", "\u30d7", "\u30da", "\u30dd", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", " ", ",", ".", "!", "?", "-", "\uff08", "\uff09"};
        this.hSearch = new Hashtable();
        int len = keys.length;
        int i = 0;
        while (i < len) {
            this.hSearch.put(keys[i], data[i]);
            ++i;
        }
    }

    void setComponents() {
        JButton bPrev = new JButton(prevPage);
        JButton bNext = new JButton(nextPage);
        JButton bSearch = new JButton(searchGo);
        JButton bClose = new JButton(closeHelp);
        JLabel lSearch = new JLabel(searchWord);
        JRadioButton rbOpposite = new JRadioButton(opposite);
        JComboBox<String> cSearch = new JComboBox<String>();
        ComboBoxEditor helpEditor = cSearch.getEditor();
        JTextField field = (JTextField)helpEditor.getEditorComponent();
        cSearch.setEditable(true);
        cSearch.addItem(" ");
        bSearch.setEnabled(false);
        this.getRootPane().setDefaultButton(bSearch);
        helpEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String text = ((JTextField)evt.getSource()).getText();
                SimpleHTMLFrame.this.searchItem(SimpleHTMLFrame.this.replaceItem(text));
            }
        });
        field.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimpleHTMLFrame.this.showPopup(evt);
            }
        });
        if (RabbitConstants.isMac()) {
            field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getModifiers() == 2) {
                        switch (evt.getKeyCode()) {
                            case 67: {
                                ((JTextField)evt.getComponent()).copy();
                                break;
                            }
                            case 86: {
                                JTextField fld = (JTextField)evt.getComponent();
                                fld.paste();
                                fld.requestFocus();
                            }
                        }
                    }
                }
            });
        }
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                SimpleHTMLFrame.this.checkSearchGo();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                SimpleHTMLFrame.this.checkSearchGo();
            }
        });
        bSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHTMLFrame.this.searchGo();
            }
        });
        bPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent1) {
                SimpleHTMLFrame.this.prevPage();
            }
        });
        bNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent1) {
                SimpleHTMLFrame.this.nextPage();
            }
        });
        bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent1) {
                SimpleHTMLFrame.this.doClose();
            }
        });
        JPanel pNorth = new JPanel();
        JPanel pSearch = new JPanel();
        pSearch.setBorder(BorderFactory.createEtchedBorder());
        Container c = this.getContentPane();
        GridBagLayout gb = new GridBagLayout();
        pNorth.setLayout(gb);
        pSearch.setLayout(gb);
        c.setLayout(gb);
        SetLayout.constraint(pSearch, lSearch, 0, 0, 1, 1, 0.0, 0.0, 0, 17, 0, 4, 0, 2, 0, 0);
        SetLayout.constraint(pSearch, cSearch, 1, 0, 1, 1, 1.0, 0.0, 2, 17, 0, 0, 0, 0, 0, 0);
        SetLayout.constraint(pSearch, bSearch, 2, 0, 1, 1, 0.0, 0.0, 0, 17, 0, 0, 0, 4, 0, 0);
        SetLayout.constraint(pSearch, rbOpposite, 3, 0, 1, 1, 0.0, 0.0, 0, 17, 0, 0, 0, 0, 0, 0);
        SetLayout.constraint(pNorth, bPrev, 0, 0, 1, 1, 0.0, 0.0, 0, 17, 0, 0, 0, 0, 20, 0);
        SetLayout.constraint(pNorth, bNext, 1, 0, 1, 1, 0.0, 0.0, 0, 17, 0, 4, 0, 0, 20, 0);
        SetLayout.constraint(pNorth, pSearch, 2, 0, 1, 1, 1.0, 0.0, 2, 17, 0, 16, 0, 0, 0, 0);
        SetLayout.constraint(pNorth, bClose, 3, 0, 1, 1, 0.0, 0.0, 0, 17, 0, 16, 0, 0, 20, 0);
        SetLayout.constraint(c, pNorth, 0, 0, 1, 1, 1.0, 0.0, 2, 18, 4, 8, 2, 8, 0, 0);
        this.bPrev = bPrev;
        this.bNext = bNext;
        this.cSearch = cSearch;
        this.bSearch = bSearch;
        this.rbOpposite = rbOpposite;
        this.createPopupMenu();
    }

    void createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem miCut = new JMenuItem(cutM, 116);
        JMenuItem miCopy = new JMenuItem(copyM, 99);
        JMenuItem miPaste = new JMenuItem(pasteM, 112);
        JMenuItem miSelectAll = new JMenuItem(selectAllM, 97);
        popup.add(miCut);
        popup.add(miCopy);
        popup.add(miPaste);
        popup.addSeparator();
        popup.add(miSelectAll);
        miCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((JTextComponent)SimpleHTMLFrame.this.popupMenu.getInvoker()).cut();
            }
        });
        miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((JTextComponent)SimpleHTMLFrame.this.popupMenu.getInvoker()).copy();
            }
        });
        miPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent comp = (JTextComponent)SimpleHTMLFrame.this.popupMenu.getInvoker();
                comp.paste();
                comp.requestFocus();
            }
        });
        miSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((JTextComponent)SimpleHTMLFrame.this.popupMenu.getInvoker()).selectAll();
            }
        });
        this.popupMenu = popup;
        this.miSelectAll = miSelectAll;
        this.miCut = miCut;
        this.miCopy = miCopy;
        this.miPaste = miPaste;
        this.miSelectAll = miSelectAll;
    }

    public void showPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            int x = evt.getX();
            int y = evt.getY();
            JTextComponent comp = (JTextComponent)evt.getComponent();
            int sx = comp.getSelectionStart();
            int sy = comp.getSelectionEnd();
            int len = comp.getDocument().getLength();
            if (comp instanceof JTextField) {
                this.miCut.setEnabled(sx < sy);
                this.miCopy.setEnabled(sx < sy);
                this.miPaste.setEnabled(true);
                this.miSelectAll.setEnabled(len > 0);
            } else {
                int pos = comp.viewToModel(new Point(x, y));
                this.miCut.setEnabled(false);
                this.miCopy.setEnabled(sx < sy && sx <= pos && pos <= sy);
                this.miPaste.setEnabled(false);
                this.miSelectAll.setEnabled(true);
            }
            this.popupMenu.pack();
            Dimension d = this.popupMenu.getPreferredSize();
            Dimension sysd = Toolkit.getDefaultToolkit().getScreenSize();
            Point point = comp.getLocationOnScreen();
            int w = x + point.x + d.width - sysd.width;
            if (w > 0) {
                x -= w;
            }
            if ((w = y + point.y + d.height * 2 - sysd.height) > 0) {
                y -= w;
            }
            this.popupMenu.show(comp, x, y);
        }
    }

    @Override
    public void addWindowListener(WindowListener listener) {
        this.lListener.add(listener);
        super.addWindowListener(listener);
    }

    @Override
    public void removeWindowListener(WindowListener listener) {
        this.lListener.remove(listener);
        super.removeWindowListener(listener);
    }

    public EventListener[] getListeners(Class listenerType) {
        if (RabbitConstants.isOldJDK()) {
            EventListener[] listeners;
            if (listenerType == WindowListener.class) {
                int size = this.lListener.size();
                listeners = new EventListener[size];
                int i = 0;
                while (i < size) {
                    listeners[i] = (EventListener)this.lListener.get(i);
                    ++i;
                }
            } else {
                listeners = new EventListener[]{};
            }
            return listeners;
        }
        return super.getListeners(listenerType);
    }

    void doClose() {
        WindowListener[] wls = (WindowListener[])this.getListeners(WindowListener.class);
        int len = wls.length;
        int i = 0;
        while (i < len) {
            wls[i].windowClosing(new WindowEvent(this, 201));
            ++i;
        }
        switch (this.getDefaultCloseOperation()) {
            case 0: {
                break;
            }
            case 1: {
                this.setVisible(false);
                break;
            }
            case 2: {
                this.setVisible(false);
                this.dispose();
                break;
            }
            case 3: {
                System.exit(0);
            }
        }
    }

    public void setURL(URL url) throws IOException {
        JEditorPane jeditorpane = new JEditorPane(){

            @Override
            protected void processMouseEvent(MouseEvent evt) {
                SimpleHTMLFrame.this.showPopup(evt);
                int mask = evt.getModifiers();
                if (mask != 4) {
                    super.processMouseEvent(evt);
                }
            }

            @Override
            public void processKeyEvent(KeyEvent evt) {
                if (evt.getID() == 401) {
                    boolean isShiftDown = evt.isShiftDown();
                    switch (evt.getKeyCode()) {
                        case 33: {
                            SimpleHTMLFrame.this.pageUp();
                            break;
                        }
                        case 34: {
                            SimpleHTMLFrame.this.pageDown();
                            break;
                        }
                        case 38: {
                            SimpleHTMLFrame.this.scrollUp(isShiftDown);
                            break;
                        }
                        case 40: {
                            SimpleHTMLFrame.this.scrollDown(isShiftDown);
                            break;
                        }
                        case 37: {
                            SimpleHTMLFrame.this.scrollLeft(isShiftDown);
                            break;
                        }
                        case 39: {
                            SimpleHTMLFrame.this.scrollRight(isShiftDown);
                            break;
                        }
                        case 67: {
                            if (evt.getModifiers() != 2) break;
                            SimpleHTMLFrame.this.editor.copy();
                        }
                    }
                }
            }
        };
        jeditorpane.setEditorKit(new HTMLEditorKit());
        jeditorpane.setPage(url);
        jeditorpane.setSelectedTextColor(Color.white);
        jeditorpane.setSelectionColor(new Color(0x10C010));
        jeditorpane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentevent) {
                componentevent.getComponent().requestFocus();
            }

            @Override
            public void componentMoved(ComponentEvent componentevent) {
                componentevent.getComponent().requestFocus();
            }
        });
        jeditorpane.setEditable(false);
        jeditorpane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("page") && evt.getNewValue() instanceof URL) {
                    SimpleHTMLFrame.this.pageOpened();
                }
            }
        });
        jeditorpane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkevent) {
                if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane jeditorpane1 = (JEditorPane)hyperlinkevent.getSource();
                    if (hyperlinkevent instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent htmlframehyperlinkevent = (HTMLFrameHyperlinkEvent)hyperlinkevent;
                        HTMLDocument htmldocument = (HTMLDocument)jeditorpane1.getDocument();
                        htmldocument.processHTMLFrameHyperlinkEvent(htmlframehyperlinkevent);
                    } else {
                        try {
                            URL url1 = hyperlinkevent.getURL();
                            SimpleHTMLFrame.this.addHyperlinkURL(url1);
                            jeditorpane1.setPage(url1);
                            jeditorpane1.setCursor(Cursor.getDefaultCursor());
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
            }
        });
        Container c = this.getContentPane();
        JScrollPane sp = new JScrollPane(jeditorpane);
        SetLayout.constraint(c, sp, 0, 1, 1, 1, 1.0, 1.0, 1, 18, 0, 0, 0, 0, 0, 0);
        if (this.hsp != null) {
            c.remove(this.hsp);
        }
        this.hsp = sp;
        this.editor = jeditorpane;
        this.hlist = new LinkedList().listIterator(0);
        this.isPrev = false;
        this.addHyperlinkURL(url);
        this.hAdjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
                JScrollBar jscrollbar2 = (JScrollBar)adjustmentevent.getSource();
                SimpleHTMLFrame.this.setHorizontalValue(jscrollbar2.getValue());
            }
        };
        this.vAdjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
                JScrollBar jscrollbar2 = (JScrollBar)adjustmentevent.getSource();
                SimpleHTMLFrame.this.setVerticalValue(jscrollbar2.getValue());
            }
        };
        this.addAdjustmentListeners();
    }

    void pageOpened() {
        JComboBox cSearch = this.cSearch;
        if (cSearch != null) {
            ComboBoxEditor helpEditor = cSearch.getEditor();
            Component comp = helpEditor.getEditorComponent();
            comp.requestFocus();
        }
    }

    void addHyperlinkURL(URL url) {
        if (this.isPrev) {
            this.hlist.next();
            this.isPrev = false;
        }
        JScrollBar jscrollbar = this.hsp.getHorizontalScrollBar();
        JScrollBar jscrollbar1 = this.hsp.getVerticalScrollBar();
        this.hlist.add(new HelpOperation(url, jscrollbar.getValue(), jscrollbar1.getValue()));
        while (this.hlist.hasNext()) {
            this.hlist.next();
            this.hlist.remove();
        }
        this.isPrev = false;
        this.checkUndoRedo();
    }

    void pageUp() {
        JViewport vp = this.hsp.getViewport();
        FontMetrics fm = this.getFontMetrics(vp.getFont());
        Rectangle r = vp.getViewRect();
        vp.setViewPosition(new Point(r.x, r.y - r.height + 2 * fm.getHeight()));
    }

    void pageDown() {
        JViewport vp = this.hsp.getViewport();
        FontMetrics fm = this.getFontMetrics(vp.getFont());
        Rectangle r = vp.getViewRect();
        vp.setViewPosition(new Point(r.x, r.y + r.height - 2 * fm.getHeight()));
    }

    void scrollUp(boolean isShiftDown) {
        JScrollBar jscrollbar = this.hsp.getVerticalScrollBar();
        jscrollbar.setValue(jscrollbar.getValue() - (isShiftDown ? 150 : 50));
    }

    void scrollDown(boolean isShiftDown) {
        JScrollBar jscrollbar = this.hsp.getVerticalScrollBar();
        jscrollbar.setValue(jscrollbar.getValue() + (isShiftDown ? 150 : 50));
    }

    void scrollLeft(boolean isShiftDown) {
        JScrollBar jscrollbar = this.hsp.getHorizontalScrollBar();
        jscrollbar.setValue(jscrollbar.getValue() - (isShiftDown ? 30 : 10));
    }

    void scrollRight(boolean isShiftDown) {
        JScrollBar jscrollbar = this.hsp.getHorizontalScrollBar();
        jscrollbar.setValue(jscrollbar.getValue() + (isShiftDown ? 30 : 10));
    }

    void addAdjustmentListeners() {
        JScrollBar jscrollbar = this.hsp.getHorizontalScrollBar();
        JScrollBar jscrollbar1 = this.hsp.getVerticalScrollBar();
        jscrollbar.addAdjustmentListener(this.hAdjustmentListener);
        jscrollbar1.addAdjustmentListener(this.vAdjustmentListener);
    }

    void removeAdjustmentListeners() {
        JScrollBar jscrollbar = this.hsp.getHorizontalScrollBar();
        JScrollBar jscrollbar1 = this.hsp.getVerticalScrollBar();
        jscrollbar.removeAdjustmentListener(this.hAdjustmentListener);
        jscrollbar1.removeAdjustmentListener(this.vAdjustmentListener);
    }

    void prevPage() {
        this.removeAdjustmentListeners();
        try {
            if (!this.isPrev) {
                this.hlist.previous();
                this.isPrev = true;
            }
            HelpOperation helpoperation = (HelpOperation)this.hlist.previous();
            this.editor.setPage(helpoperation.url);
            JScrollBar jscrollbar = this.hsp.getHorizontalScrollBar();
            JScrollBar jscrollbar1 = this.hsp.getVerticalScrollBar();
            if (helpoperation.isSetted) {
                jscrollbar.setValue(helpoperation.hvalue);
                jscrollbar1.setValue(helpoperation.vvalue);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.errorMessage(e);
        }
        this.checkUndoRedo();
        this.addAdjustmentListeners();
    }

    void nextPage() {
        this.removeAdjustmentListeners();
        try {
            if (this.isPrev) {
                this.hlist.next();
                this.isPrev = false;
            }
            HelpOperation helpoperation = (HelpOperation)this.hlist.next();
            this.editor.setPage(helpoperation.url);
            JScrollBar jscrollbar = this.hsp.getHorizontalScrollBar();
            JScrollBar jscrollbar1 = this.hsp.getVerticalScrollBar();
            if (helpoperation.isSetted) {
                jscrollbar.setValue(helpoperation.hvalue);
                jscrollbar1.setValue(helpoperation.vvalue);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.errorMessage(e);
        }
        this.checkUndoRedo();
        this.addAdjustmentListeners();
    }

    void checkUndoRedo() {
        if (!this.isPrev) {
            this.hlist.previous();
        }
        this.bPrev.setEnabled(this.hlist.hasPrevious());
        this.hlist.next();
        this.bNext.setEnabled(this.hlist.hasNext());
        this.isPrev = false;
    }

    HelpOperation getHelpOperation() {
        HelpOperation helpoperation;
        if (this.isPrev) {
            helpoperation = (HelpOperation)this.hlist.next();
            this.isPrev = false;
        } else {
            helpoperation = (HelpOperation)this.hlist.previous();
            this.isPrev = true;
        }
        return helpoperation;
    }

    void setHorizontalValue(int i) {
        this.getHelpOperation().setHorizontalValue(i);
    }

    void setVerticalValue(int i) {
        this.getHelpOperation().setVerticalValue(i);
    }

    public MutableComboBoxModel getModel() {
        return (MutableComboBoxModel)this.cSearch.getModel();
    }

    public void setModel(MutableComboBoxModel model) {
        this.cSearch.setModel(model);
    }

    void searchGo() {
        String text = (String)this.cSearch.getModel().getSelectedItem();
        this.searchItem(this.replaceItem(text));
    }

    public String replaceItem(String item) {
        StringBuffer sb = new StringBuffer();
        char[] chars = item.toCharArray();
        int len = item.length();
        int i = 0;
        while (i < len) {
            String key = "";
            boolean flag = false;
            if (i + 1 < len && (chars[i + 1] == '\uff9e' || chars[i + 1] == '\uff9f')) {
                key = new String(chars, i, 2);
                flag = true;
            } else if (chars[i] == '\"') {
                int idx = item.indexOf(34, i + 1);
                if (idx >= 0) {
                    chars[i] = 8220;
                    chars[idx] = 8221;
                } else {
                    chars[i] = 8221;
                }
            } else {
                key = new String(chars, i, 1);
            }
            String data = (String)this.hSearch.get(key);
            if (data != null) {
                sb.append(data);
                if (flag) {
                    ++i;
                }
            } else {
                sb.append(chars[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public void checkSearchGo() {
        JComboBox cSearch = this.cSearch;
        if (cSearch != null) {
            ComboBoxEditor helpEditor = cSearch.getEditor();
            JTextField field = (JTextField)helpEditor.getEditorComponent();
            this.bSearch.setEnabled(this.validItem(field.getText()) != null);
        }
    }

    public boolean searchItem(String item) {
        boolean flag = false;
        if ((item = this.validItem(item)) != null) {
            item = item.toLowerCase();
            Document doc = this.editor.getDocument();
            int len = item.length();
            int doclen = doc.getLength();
            try {
                int idx;
                String str = doc.getText(0, doclen);
                str = str.toLowerCase();
                int pos = this.editor.getCaretPosition();
                if (this.isOpposite()) {
                    idx = str.lastIndexOf(item, pos - len * 2);
                    if (idx < 0) {
                        idx = str.lastIndexOf(item, doclen - len);
                    }
                } else {
                    idx = str.indexOf(item, pos);
                    if (idx < 0) {
                        idx = str.indexOf(item, 0);
                    }
                }
                if (idx < 0) {
                    Toolkit.getDefaultToolkit().beep();
                    MessageDialog.errorMessage(item + keyWordNotFoundError);
                } else {
                    this.addSearchItem(item);
                    ComboBoxEditor helpEditor = this.cSearch.getEditor();
                    JTextField field = (JTextField)helpEditor.getEditorComponent();
                    field.setText(item);
                    this.editor.setCaretPosition(idx);
                    this.editor.moveCaretPosition(idx + len);
                    flag = true;
                }
                this.editor.requestFocus();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public String validItem(String item) {
        int len = (item = item.trim()).length();
        if (len > 0 && item.charAt(0) != ' ') {
            return item;
        }
        return null;
    }

    public void addSearchItem(String item) {
        if (item.length() > 0) {
            MutableComboBoxModel helpModel = (MutableComboBoxModel)this.cSearch.getModel();
            int size = helpModel.getSize();
            if (size == 1 && ((String)helpModel.getElementAt(0)).charAt(0) == ' ') {
                helpModel.removeElementAt(0);
                size = 0;
            }
            int i = 0;
            while (i < size) {
                if (item.equals(helpModel.getElementAt(i))) {
                    return;
                }
                ++i;
            }
            helpModel.addElement(item);
            helpModel.setSelectedItem(item);
        }
    }

    class HelpOperation {
        int hvalue;
        int vvalue;
        URL url;
        boolean isSetted;

        HelpOperation(URL url, int hvalue, int vvalue) {
            this.url = url;
            this.hvalue = hvalue;
            this.vvalue = vvalue;
        }

        void setHorizontalValue(int hvalue) {
            this.hvalue = hvalue;
            this.isSetted = true;
        }

        void setVerticalValue(int vvalue) {
            this.vvalue = vvalue;
            this.isSetted = true;
        }
    }
}

