/*
 * _code_tables.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include"_dcs.h"

#include "_euc2unibecommon_table00.h"
#include "_euc2unibe20932_table00.h"
#include "_euc2unibe20932_table8f.h"
#include "_euc2unibe51932_table00.h"
#include "_euc2unibems_table00.h"
#include "_euc2unibems_table8f.h"
#include "_euc2unibe2004_table00.h"
#include "_euc2unibe2004_table8f.h"
#include "_jis2unibe50221_table.h"
#include "_jis2unibe2022jp2004_table.h"
#include "_jis2unibe2022jp_table.h"
#include "_jis2unibe2022jp3_table.h"
#include "_sjis2unibe_table.h"
#include "_sjis2unibe932_table.h"
#include "_sjis2unibe2004_table.h"
#include "_unibe2euccommon_table.h"
#include "_unibe2euc20932_table.h"
#include "_unibe2euc51932_table.h"
#include "_unibe2eucms_table.h"
#include "_unibe2euc2004_table.h"
#include "_unibe2euc2004_table_srg.h"
#include "_unibe2jis50221_table.h"
#include "_unibe2jis50221_table_bits.h"
#include "_unibe2jis2022jp2004_table.h"
#include "_unibe2jis2022jp2004_table_srg.h"
#include "_unibe2jis2022jp2004_table_bits.h"
#include "_unibe2jis2022jp_table.h"
#include "_unibe2jis2022jp_table_bits.h"
#include "_unibe2jis2022jp3_table.h"
#include "_unibe2jis2022jp3_table_srg.h"
#include "_unibe2jis2022jp3_table_bits.h"
#include "_unibe2sjis_table.h"
#include "_unibe2sjis932_table.h"
#include "_unibe2sjis2004_table.h"
#include "_unibe2sjis2004_table_srg.h"
#include "_unibe_def_table.h"

unsigned short _han_to_zen[] = {
	UTFBE_ZEN_3002,/*。*/ UTFBE_ZEN_300C,/*「*/ UTFBE_ZEN_300D,/*」*/ UTFBE_ZEN_3001,/*、*/ UTFBE_ZEN_30FB,/*・*/ UTFBE_ZEN_30F2,/*ヲ*/
	UTFBE_ZEN_30A1,/*ァ*/ UTFBE_ZEN_30A3,/*ィ*/ UTFBE_ZEN_30A5,/*ゥ*/ UTFBE_ZEN_30A7,/*ェ*/ UTFBE_ZEN_30A9,/*ォ*/
	UTFBE_ZEN_30E3,/*ャ*/ UTFBE_ZEN_30E5,/*ュ*/ UTFBE_ZEN_30E7,/*ョ*/ UTFBE_ZEN_30C3,/*ッ*/ UTFBE_ZEN_30FC,/*ー*/
	UTFBE_ZEN_30A2,/*ア*/ UTFBE_ZEN_30A4,/*イ*/ UTFBE_ZEN_30A6,/*ウ*/ UTFBE_ZEN_30A8,/*エ*/ UTFBE_ZEN_30AA,/*オ*/
	UTFBE_ZEN_30AB,/*カ*/ UTFBE_ZEN_30AD,/*キ*/ UTFBE_ZEN_30AF,/*ク*/ UTFBE_ZEN_30B1,/*ケ*/ UTFBE_ZEN_30B3,/*コ*/
	UTFBE_ZEN_30B5,/*サ*/ UTFBE_ZEN_30B7,/*シ*/ UTFBE_ZEN_30B9,/*ス*/ UTFBE_ZEN_30BB,/*セ*/ UTFBE_ZEN_30BD,/*ソ*/
	UTFBE_ZEN_30BF,/*タ*/ UTFBE_ZEN_30C1,/*チ*/ UTFBE_ZEN_30C4,/*ツ*/ UTFBE_ZEN_30C6,/*テ*/ UTFBE_ZEN_30C8,/*ト*/
	UTFBE_ZEN_30CA,/*ナ*/ UTFBE_ZEN_30CB,/*ニ*/ UTFBE_ZEN_30CC,/*ヌ*/ UTFBE_ZEN_30CD,/*ネ*/ UTFBE_ZEN_30CE,/*ノ*/
	UTFBE_ZEN_30CF,/*ハ*/ UTFBE_ZEN_30D2,/*ヒ*/ UTFBE_ZEN_30D5,/*フ*/ UTFBE_ZEN_30D8,/*ヘ*/ UTFBE_ZEN_30DB,/*ホ*/
	UTFBE_ZEN_30DE,/*マ*/ UTFBE_ZEN_30DF,/*ミ*/ UTFBE_ZEN_30E0,/*ム*/ UTFBE_ZEN_30E1,/*メ*/ UTFBE_ZEN_30E2,/*モ*/
	UTFBE_ZEN_30E4,/*ヤ*/ UTFBE_ZEN_30E6,/*ユ*/ UTFBE_ZEN_30E8,/*ヨ*/
	UTFBE_ZEN_30E9,/*ラ*/ UTFBE_ZEN_30EA,/*リ*/ UTFBE_ZEN_30EB,/*ル*/ UTFBE_ZEN_30EC,/*レ*/ UTFBE_ZEN_30ED,/*ロ*/
	UTFBE_ZEN_30EF,/*ワ*/ UTFBE_ZEN_30F3,/*ン*/ UTFBE_ZEN_309B,/*゛*/ UTFBE_ZEN_309C,/*゜*/
};

const size_t _han_to_zen_size = sizeof(_han_to_zen) / sizeof(_han_to_zen[0]);

unsigned short _han_to_zen_d[] = {
	UTFBE_ZEN_30FA,	/* ヺ */
	0,0,0,0,0,0,0,0,0,0,0,0,UTFBE_ZEN_30F4 /* ヴ */,0,0,
	UTFBE_ZEN_30AC /* ガ */, UTFBE_ZEN_30AE /* ギ */,UTFBE_ZEN_30B0 /* グ */,UTFBE_ZEN_30B2 /* ゲ */,UTFBE_ZEN_30B4 /* ゴ */,
	UTFBE_ZEN_30B6 /* ザ */, UTFBE_ZEN_30B8 /* ジ */,UTFBE_ZEN_30BA /* ズ */,UTFBE_ZEN_30BC /* ゼ */,UTFBE_ZEN_30BE /* ゾ */,
	UTFBE_ZEN_30C0 /* ダ */, UTFBE_ZEN_30C2 /* ヂ */,UTFBE_ZEN_30C5 /* ヅ */,UTFBE_ZEN_30C7 /* デ */,UTFBE_ZEN_30C9 /* ド */,
	0,0,0,0,0,
	UTFBE_ZEN_30D0 /* バ */, UTFBE_ZEN_30D3 /* ビ */,UTFBE_ZEN_30D6 /* ブ */,UTFBE_ZEN_30D9 /* ベ */,UTFBE_ZEN_30DC /* ボ */,
	0,0,0,0,0,0,0,0,0,0,0,0,0,
	UTFBE_ZEN_30F7 /* ヷ */,
};

const size_t _han_to_zen_d_size = sizeof(_han_to_zen_d) / sizeof(_han_to_zen_d[0]);

unsigned short _han_to_zen_h[] = {
	UTFBE_ZEN_30D1,	/* パ  */
	UTFBE_ZEN_30D4,	/* ピ*/
	UTFBE_ZEN_30D7,	/* プ */
	UTFBE_ZEN_30DA,	/* ペ */
	UTFBE_ZEN_30DD,	/* ポ */
};

const size_t _han_to_zen_h_size = sizeof(_han_to_zen_h) / sizeof(_han_to_zen_h[0]);

/**
 * 文字コード判定や文字コード変換等を行なうための Dcs 情報を生成する。
 * @param なし
 * @return 生成された Dcs 情報が返る。メモリー・アロケート・エラーの時は NULL。
 */
Dcs *create_dcs() {
	Dcs *dcs = calloc(sizeof(Dcs), 1);
	if (dcs != NULL) {
		if ((dcs->_block = ll_create()) == NULL) {
			release_dcs(dcs);
			return NULL;
		}
		dcs->_unibe_def_table = (uint16_t *)_unibe_def_table;
		dcs->_unibe_def_table_size = _unibe_def_table_size;
		dcs->_unibe2jis_table_srg[_I_SRG] = (uint16_t *)_unibe2jis2022jp2004_table_srg;
		dcs->_unibe2jis_table_srg_size[_I_SRG] = _unibe2jis2022jp2004_table_srg_size;
		dcs->_unibe2sjis_table_srg[_I_SRG] = _unibe2sjis2004_table_srg;
		dcs->_unibe2sjis_table_srg_size[_I_SRG] = _unibe2sjis2004_table_srg_size;
		dcs->_unibe2euc_table_srg[_I_SRG] = _unibe2euc2004_table_srg;
		dcs->_unibe2euc_table_srg_size[_I_SRG] = _unibe2euc2004_table_srg_size;
		set_jis2022jp_to(dcs);
		set_to_jis2022jp(dcs);
		set_sjis_to(dcs);
		set_to_sjis(dcs);
		set_euccommon_to(dcs);
		set_to_euccommon(dcs);
		dcs->version = DCS_VERSION;
	}
	return dcs;
}

/**
 * 生成された Dcs 情報を解放する。
 * @param 解放する Dcs 情報
 * @return なし。
 */
void release_dcs(Dcs *dcs) {
	if (dcs->_block != NULL) {
		ll_release((ll_list **)&dcs->_block);
	}
	free(dcs);
}
