/*
 * _euc2unibe2004_table8f.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __EUC2UNIBE2004_TABLE8F_H_
#define __EUC2UNIBE2004_TABLE8F_H_

#include <stddef.h>
#include <stdint.h>

const size_t _euc2unibe2004_table8f_offset = 0xa1a0;

const uint32_t _euc2unibe2004_table8f[] = {
	/* 8fa1a0 */ 0,0x20089,0x4e02,0x4e0f,0x4e12,0x4e29,0x4e2b,0x4e2e, 0x4e40,0x4e47,0x4e48,0x200a2,0x4e51,0x3406,0x200a4,0x4e5a, /* 0,'𠂉','丂','丏','丒','丩','丫','丮', '乀','乇','么','𠂢','乑','㐆','𠂤','乚', */
	/* 8fa1b0 */ 0x4e69,0x4e9d,0x342c,0x342e,0x4eb9,0x4ebb,0x201a2,0x4ebc, 0x4ec3,0x4ec8,0x4ed0,0x4eeb,0x4eda,0x4ef1,0x4ef5,0x4f00, /* '乩','亝','㐬','㐮','亹','亻','𠆢','亼', '仃','仈','仐','仫','仚','仱','仵','伀', */
	/* 8fa1c0 */ 0x4f16,0x4f64,0x4f37,0x4f3e,0x4f54,0x4f58,0x20213,0x4f77, 0x4f78,0x4f7a,0x4f7d,0x4f82,0x4f85,0x4f92,0x4f9a,0x4fe6, /* '伖','佤','伷','伾','佔','佘','𠈓','佷', '佸','佺','佽','侂','侅','侒','侚','俦', */
	/* 8fa1d0 */ 0x4fb2,0x4fbe,0x4fc5,0x4fcb,0x4fcf,0x4fd2,0x346a,0x4ff2, 0x5000,0x5010,0x5013,0x501c,0x501e,0x5022,0x3468,0x5042, /* '侲','侾','俅','俋','俏','俒','㑪','俲', '倀','倐','倓','倜','倞','倢','㑨','偂', */
	/* 8fa1e0 */ 0x5046,0x504e,0x5053,0x5057,0x5063,0x5066,0x506a,0x5070, 0x50a3,0x5088,0x5092,0x5093,0x5095,0x5096,0x509c,0x50aa, /* '偆','偎','偓','偗','偣','偦','偪','偰', '傣','傈','傒','傓','傕','傖','傜','傪', */
	/* 8fa1f0 */ 0x2032b,0x50b1,0x50ba,0x50bb,0x50c4,0x50c7,0x50f3,0x20381, 0x50ce,0x20371,0x50d4,0x50d9,0x50e1,0x50e9,0x3492,0, /* '𠌫','傱','傺','傻','僄','僇','僳','𠎁', '僎','𠍱','僔','僙','僡','僩','㒒',0, */
	/* 8fa200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa3a0 */ 0,0x5108,0x203f9,0x5117,0x511b,0x2044a,0x5160,0x20509, 0x5173,0x5183,0x518b,0x34bc,0x5198,0x51a3,0x51ad,0x34c7, /* 0,'儈','𠏹','儗','儛','𠑊','兠','𠔉', '关','冃','冋','㒼','冘','冣','冭','㓇', */
	/* 8fa3b0 */ 0x51bc,0x205d6,0x20628,0x51f3,0x51f4,0x5202,0x5212,0x5216, 0x2074f,0x5255,0x525c,0x526c,0x5277,0x5284,0x5282,0x20807, /* '冼','𠗖','𠘨','凳','凴','刂','划','刖', '𠝏','剕','剜','剬','剷','劄','劂','𠠇', */
	/* 8fa3c0 */ 0x5298,0x2083a,0x52a4,0x52a6,0x52af,0x52ba,0x52bb,0x52ca, 0x351f,0x52d1,0x208b9,0x52f7,0x530a,0x530b,0x5324,0x5335, /* '劘','𠠺','劤','劦','劯','劺','劻','勊', '㔟','勑','𠢹','勷','匊','匋','匤','匵', */
	/* 8fa3d0 */ 0x533e,0x5342,0x2097c,0x2099d,0x5367,0x536c,0x537a,0x53a4, 0x53b4,0x20ad3,0x53b7,0x53c0,0x20b1d,0x355d,0x355e,0x53d5, /* '匾','卂','𠥼','𠦝','卧','卬','卺','厤', '厴','𠫓','厷','叀','𠬝','㕝','㕞','叕', */
	/* 8fa3e0 */ 0x53da,0x3563,0x53f4,0x53f5,0x5455,0x5424,0x5428,0x356e, 0x5443,0x5462,0x5466,0x546c,0x548a,0x548d,0x5495,0x54a0, /* '叚','㕣','叴','叵','呕','吤','吨','㕮', '呃','呢','呦','呬','咊','咍','咕','咠', */
	/* 8fa3f0 */ 0x54a6,0x54ad,0x54ae,0x54b7,0x54ba,0x54bf,0x54c3,0x20d45, 0x54ec,0x54ef,0x54f1,0x54f3,0x5500,0x5501,0x5509,0, /* '咦','咭','咮','咷','咺','咿','哃','𠵅', '哬','哯','哱','哳','唀','唁','唉',0, */
	/* 8fa400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa4a0 */ 0,0x553c,0x5541,0x35a6,0x5547,0x554a,0x35a8,0x5560, 0x5561,0x5564,0x20de1,0x557d,0x5582,0x5588,0x5591,0x35c5, /* 0,'唼','啁','㖦','啇','啊','㖨','啠', '啡','啤','𠷡','啽','喂','喈','喑','㗅', */
	/* 8fa4b0 */ 0x55d2,0x20e95,0x20e6d,0x55bf,0x55c9,0x55cc,0x55d1,0x55dd, 0x35da,0x55e2,0x20e64,0x55e9,0x5628,0x20f5f,0x5607,0x5610, /* '嗒','𠺕','𠹭','喿','嗉','嗌','嗑','嗝', '㗚','嗢','𠹤','嗩','嘨','𠽟','嘇','嘐', */
	/* 8fa4c0 */ 0x5630,0x5637,0x35f4,0x563d,0x563f,0x5640,0x5647,0x565e, 0x5660,0x566d,0x3605,0x5688,0x568c,0x5695,0x569a,0x569d, /* '嘰','嘷','㗴','嘽','嘿','噀','噇','噞', '噠','噭','㘅','嚈','嚌','嚕','嚚','嚝', */
	/* 8fa4d0 */ 0x56a8,0x56ad,0x56b2,0x56c5,0x56cd,0x56df,0x56e8,0x56f6, 0x56f7,0x21201,0x5715,0x5723,0x21255,0x5729,0x2127b,0x5745, /* '嚨','嚭','嚲','囅','囍','囟','囨','囶', '囷','𡈁','圕','圣','𡉕','圩','𡉻','坅', */
	/* 8fa4e0 */ 0x5746,0x574c,0x574d,0x21274,0x5768,0x576f,0x5773,0x5774, 0x5775,0x577b,0x212e4,0x212d7,0x57ac,0x579a,0x579d,0x579e, /* '坆','坌','坍','𡉴','坨','坯','坳','坴', '坵','坻','𡋤','𡋗','垬','垚','垝','垞', */
	/* 8fa4f0 */ 0x57a8,0x57d7,0x212fd,0x57cc,0x21336,0x21344,0x57de,0x57e6, 0x57f0,0x364a,0x57f8,0x57fb,0x57fd,0x5804,0x581e,0, /* '垨','埗','𡋽','埌','𡌶','𡍄','埞','埦', '埰','㙊','埸','埻','埽','堄','堞',0, */
	/* 8fa500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa5a0 */ 0,0x5820,0x5827,0x5832,0x5839,0x213c4,0x5849,0x584c, 0x5867,0x588a,0x588b,0x588d,0x588f,0x5890,0x5894,0x589d, /* 0,'堠','堧','堲','堹','𡏄','塉','塌', '塧','墊','墋','墍','墏','墐','墔','墝', */
	/* 8fa5b0 */ 0x58aa,0x58b1,0x2146d,0x58c3,0x58cd,0x58e2,0x58f3,0x58f4, 0x5905,0x5906,0x590b,0x590d,0x5914,0x5924,0x215d7,0x3691, /* '墪','墱','𡑭','壃','壍','壢','壳','壴', '夅','夆','夋','复','夔','夤','𡗗','㚑', */
	/* 8fa5c0 */ 0x593d,0x3699,0x5946,0x3696,0x26c29,0x595b,0x595f,0x21647, 0x5975,0x5976,0x597c,0x599f,0x59ae,0x59bc,0x59c8,0x59cd, /* '夽','㚙','奆','㚖','𦰩','奛','奟','𡙇', '奵','奶','奼','妟','妮','妼','姈','姍', */
	/* 8fa5d0 */ 0x59de,0x59e3,0x59e4,0x59e7,0x59ee,0x21706,0x21742,0x36cf, 0x5a0c,0x5a0d,0x5a17,0x5a27,0x5a2d,0x5a55,0x5a65,0x5a7a, /* '姞','姣','姤','姧','姮','𡜆','𡝂','㛏', '娌','娍','娗','娧','娭','婕','婥','婺', */
	/* 8fa5e0 */ 0x5a8b,0x5a9c,0x5a9f,0x5aa0,0x5aa2,0x5ab1,0x5ab3,0x5ab5, 0x5aba,0x5abf,0x5ada,0x5adc,0x5ae0,0x5ae5,0x5af0,0x5aee, /* '媋','媜','媟','媠','媢','媱','媳','媵', '媺','媿','嫚','嫜','嫠','嫥','嫰','嫮', */
	/* 8fa5f0 */ 0x5af5,0x5b00,0x5b08,0x5b17,0x5b34,0x5b2d,0x5b4c,0x5b52, 0x5b68,0x5b6f,0x5b7c,0x5b7f,0x5b81,0x5b84,0x219c3,0, /* '嫵','嬀','嬈','嬗','嬴','嬭','孌','孒', '孨','孯','孼','孿','宁','宄','𡧃',0, */
	/* 8fa600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa8a0 */ 0,0x5b96,0x5bac,0x3761,0x5bc0,0x3762,0x5bce,0x5bd6, 0x376c,0x376b,0x5bf1,0x5bfd,0x3775,0x5c03,0x5c29,0x5c30, /* 0,'宖','宬','㝡','寀','㝢','寎','寖', '㝬','㝫','寱','寽','㝵','尃','尩','尰', */
	/* 8fa8b0 */ 0x21c56,0x5c5f,0x5c63,0x5c67,0x5c68,0x5c69,0x5c70,0x21d2d, 0x21d45,0x5c7c,0x21d78,0x21d62,0x5c88,0x5c8a,0x37c1,0x21da1, /* '𡱖','屟','屣','屧','屨','屩','屰','𡴭', '𡵅','屼','𡵸','𡵢','岈','岊','㟁','𡶡', */
	/* 8fa8c0 */ 0x21d9c,0x5ca0,0x5ca2,0x5ca6,0x5ca7,0x21d92,0x5cad,0x5cb5, 0x21db7,0x5cc9,0x21de0,0x21e33,0x5d06,0x5d10,0x5d2b,0x5d1d, /* '𡶜','岠','岢','岦','岧','𡶒','岭','岵', '𡶷','峉','𡷠','𡸳','崆','崐','崫','崝', */
	/* 8fa8d0 */ 0x5d20,0x5d24,0x5d26,0x5d31,0x5d39,0x5d42,0x37e8,0x5d61, 0x5d6a,0x37f4,0x5d70,0x21f1e,0x37fd,0x5d88,0x3800,0x5d92, /* '崠','崤','崦','崱','崹','嵂','㟨','嵡', '嵪','㟴','嵰','𡼞','㟽','嶈','㠀','嶒', */
	/* 8fa8e0 */ 0x5d94,0x5d97,0x5d99,0x5db0,0x5db2,0x5db4,0x21f76,0x5db9, 0x5dd1,0x5dd7,0x5dd8,0x5de0,0x21ffa,0x5de4,0x5de9,0x382f, /* '嶔','嶗','嶙','嶰','嶲','嶴','𡽶','嶹', '巑','巗','巘','巠','𡿺','巤','巩','㠯', */
	/* 8fa8f0 */ 0x5e00,0x3836,0x5e12,0x5e15,0x3840,0x5e1f,0x5e2e,0x5e3e, 0x5e49,0x385c,0x5e56,0x3861,0x5e6b,0x5e6c,0x5e6d,0, /* '帀','㠶','帒','帕','㡀','帟','帮','帾', '幉','㡜','幖','㡡','幫','幬','幭',0, */
	/* 8fa900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fabb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fabc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fabd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fabe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fabf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faca0 */ 0,0x5e6e,0x2217b,0x5ea5,0x5eaa,0x5eac,0x5eb9,0x5ebf, 0x5ec6,0x5ed2,0x5ed9,0x2231e,0x5efd,0x5f08,0x5f0e,0x5f1c, /* 0,'幮','𢅻','庥','庪','庬','庹','庿', '廆','廒','廙','𢌞','廽','弈','弎','弜', */
	/* 8facb0 */ 0x223ad,0x5f1e,0x5f47,0x5f63,0x5f72,0x5f7e,0x5f8f,0x5fa2, 0x5fa4,0x5fb8,0x5fc4,0x38fa,0x5fc7,0x5fcb,0x5fd2,0x5fd3, /* '𢎭','弞','彇','彣','彲','彾','徏','徢', '徤','徸','忄','㣺','忇','忋','忒','忓', */
	/* 8facc0 */ 0x5fd4,0x5fe2,0x5fee,0x5fef,0x5ff3,0x5ffc,0x3917,0x6017, 0x6022,0x6024,0x391a,0x604c,0x607f,0x608a,0x6095,0x60a8, /* '忔','忢','忮','忯','忳','忼','㤗','怗', '怢','怤','㤚','恌','恿','悊','悕','您', */
	/* 8facd0 */ 0x226f3,0x60b0,0x60b1,0x60be,0x60c8,0x60d9,0x60db,0x60ee, 0x60f2,0x60f5,0x6110,0x6112,0x6113,0x6119,0x611e,0x613a, /* '𢛳','悰','悱','悾','惈','惙','惛','惮', '惲','惵','愐','愒','愓','愙','愞','愺', */
	/* 8face0 */ 0x396f,0x6141,0x6146,0x6160,0x617c,0x2285b,0x6192,0x6193, 0x6197,0x6198,0x61a5,0x61a8,0x61ad,0x228ab,0x61d5,0x61dd, /* '㥯','慁','慆','慠','慼','𢡛','憒','憓', '憗','憘','憥','憨','憭','𢢫','懕','懝', */
	/* 8facf0 */ 0x61df,0x61f5,0x2298f,0x6215,0x6223,0x6229,0x6246,0x624c, 0x6251,0x6252,0x6261,0x6264,0x627b,0x626d,0x6273,0, /* '懟','懵','𢦏','戕','戣','戩','扆','扌', '扑','扒','扡','扤','扻','扭','扳',0, */
	/* 8fad00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fada0 */ 0,0x6299,0x62a6,0x62d5,0x22ab8,0x62fd,0x6303,0x630d, 0x6310,0x22b4f,0x22b50,0x6332,0x6335,0x633b,0x633c,0x6341, /* 0,'抙','抦','拕','𢪸','拽','挃','挍', '挐','𢭏','𢭐','挲','挵','挻','挼','捁', */
	/* 8fadb0 */ 0x6344,0x634e,0x22b46,0x6359,0x22c1d,0x22ba6,0x636c,0x6384, 0x6399,0x22c24,0x6394,0x63bd,0x63f7,0x63d4,0x63d5,0x63dc, /* '捄','捎','𢭆','捙','𢰝','𢮦','捬','掄', '掙','𢰤','掔','掽','揷','揔','揕','揜', */
	/* 8fadc0 */ 0x63e0,0x63eb,0x63ec,0x63f2,0x6409,0x641e,0x6425,0x6429, 0x642f,0x645a,0x645b,0x645d,0x6473,0x647d,0x6487,0x6491, /* '揠','揫','揬','揲','搉','搞','搥','搩', '搯','摚','摛','摝','摳','摽','撇','撑', */
	/* 8fadd0 */ 0x649d,0x649f,0x64cb,0x64cc,0x64d5,0x64d7,0x22de1,0x64e4, 0x64e5,0x64ff,0x6504,0x3a6e,0x650f,0x6514,0x6516,0x3a73, /* '撝','撟','擋','擌','擕','擗','𢷡','擤', '擥','擿','攄','㩮','攏','攔','攖','㩳', */
	/* 8fade0 */ 0x651e,0x6532,0x6544,0x6554,0x656b,0x657a,0x6581,0x6584, 0x6585,0x658a,0x65b2,0x65b5,0x65b8,0x65bf,0x65c2,0x65c9, /* '攞','攲','敄','敔','敫','敺','斁','斄', '斅','斊','斲','斵','斸','斿','旂','旉', */
	/* 8fadf0 */ 0x65d4,0x3ad6,0x65f2,0x65f9,0x65fc,0x6604,0x6608,0x6621, 0x662a,0x6645,0x6651,0x664e,0x3aea,0x231c3,0x6657,0, /* '旔','㫖','旲','旹','旼','昄','昈','昡', '昪','晅','晑','晎','㫪','𣇃','晗',0, */
	/* 8fae00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faea0 */ 0,0x665b,0x6663,0x231f5,0x231b6,0x666a,0x666b,0x666c, 0x666d,0x667b,0x6680,0x6690,0x6692,0x6699,0x3b0e,0x66ad, /* 0,'晛','晣','𣇵','𣆶','晪','晫','晬', '晭','晻','暀','暐','暒','暙','㬎','暭', */
	/* 8faeb0 */ 0x66b1,0x66b5,0x3b1a,0x66bf,0x3b1c,0x66ec,0x3ad7,0x6701, 0x6705,0x6712,0x23372,0x6719,0x233d3,0x233d2,0x674c,0x674d, /* '暱','暵','㬚','暿','㬜','曬','㫗','朁', '朅','朒','𣍲','朙','𣏓','𣏒','杌','杍', */
	/* 8faec0 */ 0x6754,0x675d,0x233d0,0x233e4,0x233d5,0x6774,0x6776,0x233da, 0x6792,0x233df,0x8363,0x6810,0x67b0,0x67b2,0x67c3,0x67c8, /* '杔','杝','𣏐','𣏤','𣏕','杴','杶','𣏚', '枒','𣏟','荣','栐','枰','枲','柃','柈', */
	/* 8faed0 */ 0x67d2,0x67d9,0x67db,0x67f0,0x67f7,0x2344a,0x23451,0x2344b, 0x6818,0x681f,0x682d,0x23465,0x6833,0x683b,0x683e,0x6844, /* '柒','柙','柛','柰','柷','𣑊','𣑑','𣑋', '栘','栟','栭','𣑥','栳','栻','栾','桄', */
	/* 8faee0 */ 0x6845,0x6849,0x684c,0x6855,0x6857,0x3b77,0x686b,0x686e, 0x687a,0x687c,0x6882,0x6890,0x6896,0x3b6d,0x6898,0x6899, /* '桅','桉','桌','桕','桗','㭷','桫','桮', '桺','桼','梂','梐','梖','㭭','梘','梙', */
	/* 8faef0 */ 0x689a,0x689c,0x68aa,0x68ab,0x68b4,0x68bb,0x68fb,0x234e4, 0x2355a,0xfa13,0x68c3,0x68c5,0x68cc,0x68cf,0x68d6,0, /* '梚','梜','梪','梫','梴','梻','棻','𣓤', '𣕚','﨓','棃','棅','棌','棏','棖',0, */
	/* 8faf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fafa0 */ 0,0x68d9,0x68e4,0x68e5,0x68ec,0x68f7,0x6903,0x6907, 0x3b87,0x3b88,0x23594,0x693b,0x3b8d,0x6946,0x6969,0x696c, /* 0,'棙','棤','棥','棬','棷','椃','椇', '㮇','㮈','𣖔','椻','㮍','楆','楩','楬', */
	/* 8fafb0 */ 0x6972,0x697a,0x697f,0x6992,0x3ba4,0x6996,0x6998,0x69a6, 0x69b0,0x69b7,0x69ba,0x69bc,0x69c0,0x69d1,0x69d6,0x23639, /* '楲','楺','楿','榒','㮤','榖','榘','榦', '榰','榷','榺','榼','槀','槑','槖','𣘹', */
	/* 8fafc0 */ 0x23647,0x6a30,0x23638,0x2363a,0x69e3,0x69ee,0x69ef,0x69f3, 0x3bcd,0x69f4,0x69fe,0x6a11,0x6a1a,0x6a1d,0x2371c,0x6a32, /* '𣙇','樰','𣘸','𣘺','槣','槮','槯','槳', '㯍','槴','槾','樑','樚','樝','𣜜','樲', */
	/* 8fafd0 */ 0x6a33,0x6a34,0x6a3f,0x6a46,0x6a49,0x6a7a,0x6a4e,0x6a52, 0x6a64,0x2370c,0x6a7e,0x6a83,0x6a8b,0x3bf0,0x6a91,0x6a9f, /* '樳','樴','樿','橆','橉','橺','橎','橒', '橤','𣜌','橾','檃','檋','㯰','檑','檟', */
	/* 8fafe0 */ 0x6aa1,0x23764,0x6aab,0x6abd,0x6ac6,0x6ad4,0x6ad0,0x6adc, 0x6add,0x237ff,0x237e7,0x6aec,0x6af1,0x6af2,0x6af3,0x6afd, /* '檡','𣝤','檫','檽','櫆','櫔','櫐','櫜', '櫝','𣟿','𣟧','櫬','櫱','櫲','櫳','櫽', */
	/* 8faff0 */ 0x23824,0x6b0b,0x6b0f,0x6b10,0x6b11,0x2383d,0x6b17,0x3c26, 0x6b2f,0x6b4a,0x6b58,0x6b6c,0x6b75,0x6b7a,0x6b81,0, /* '𣠤','欋','欏','欐','欑','𣠽','欗','㰦', '欯','歊','歘','歬','歵','歺','殁',0, */
	/* 8fb000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fccb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fccc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fccd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fccf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fceb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fced0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fddb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fddc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fddd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fddf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fded0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fead0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8febb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8febc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8febd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8febe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8febf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fecb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fecc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fecd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fece0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fecf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fedb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fedc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fedd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fede0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fedf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feea0 */ 0,0x6b9b,0x6bae,0x23a98,0x6bbd,0x6bbe,0x6bc7,0x6bc8, 0x6bc9,0x6bda,0x6be6,0x6be7,0x6bee,0x6bf1,0x6c02,0x6c0a, /* 0,'殛','殮','𣪘','殽','殾','毇','毈', '毉','毚','毦','毧','毮','毱','氂','氊', */
	/* 8feeb0 */ 0x6c0e,0x6c35,0x6c36,0x6c3a,0x23c7f,0x6c3f,0x6c4d,0x6c5b, 0x6c6d,0x6c84,0x6c89,0x3cc3,0x6c94,0x6c95,0x6c97,0x6cad, /* '氎','氵','氶','氺','𣱿','氿','汍','汛', '汭','沄','沉','㳃','沔','沕','沗','沭', */
	/* 8feec0 */ 0x6cc2,0x6cd0,0x3cd2,0x6cd6,0x6cda,0x6cdc,0x6ce9,0x6cec, 0x6ced,0x23d00,0x6d00,0x6d0a,0x6d24,0x6d26,0x6d27,0x6c67, /* '泂','泐','㳒','泖','泚','泜','泩','泬', '泭','𣴀','洀','洊','洤','洦','洧','汧', */
	/* 8feed0 */ 0x6d2f,0x6d3c,0x6d5b,0x6d5e,0x6d60,0x6d70,0x6d80,0x6d81, 0x6d8a,0x6d8d,0x6d91,0x6d98,0x23d40,0x6e17,0x23dfa,0x23df9, /* '洯','洼','浛','浞','浠','浰','涀','涁', '涊','涍','涑','涘','𣵀','渗','𣷺','𣷹', */
	/* 8feee0 */ 0x23dd3,0x6dab,0x6dae,0x6db4,0x6dc2,0x6d34,0x6dc8,0x6dce, 0x6dcf,0x6dd0,0x6ddf,0x6de9,0x6df6,0x6e36,0x6e1e,0x6e22, /* '𣷓','涫','涮','涴','淂','洴','淈','淎', '淏','淐','淟','淩','淶','渶','渞','渢', */
	/* 8feef0 */ 0x6e27,0x3d11,0x6e32,0x6e3c,0x6e48,0x6e49,0x6e4b,0x6e4c, 0x6e4f,0x6e51,0x6e53,0x6e54,0x6e57,0x6e63,0x3d1e,0, /* '渧','㴑','渲','渼','湈','湉','湋','湌', '湏','湑','湓','湔','湗','湣','㴞',0, */
	/* 8fef00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fefa0 */ 0,0x6e93,0x6ea7,0x6eb4,0x6ebf,0x6ec3,0x6eca,0x6ed9, 0x6f35,0x6eeb,0x6ef9,0x6efb,0x6f0a,0x6f0c,0x6f18,0x6f25, /* 0,'溓','溧','溴','溿','滃','滊','滙', '漵','滫','滹','滻','漊','漌','漘','漥', */
	/* 8fefb0 */ 0x6f36,0x6f3c,0x23f7e,0x6f52,0x6f57,0x6f5a,0x6f60,0x6f68, 0x6f98,0x6f7d,0x6f90,0x6f96,0x6fbe,0x6f9f,0x6fa5,0x6faf, /* '漶','漼','𣽾','潒','潗','潚','潠','潨', '澘','潽','澐','澖','澾','澟','澥','澯', */
	/* 8fefc0 */ 0x3d64,0x6fb5,0x6fc8,0x6fc9,0x6fda,0x6fde,0x6fe9,0x24096, 0x6ffc,0x7000,0x7007,0x700a,0x7023,0x24103,0x7039,0x703a, /* '㵤','澵','濈','濉','濚','濞','濩','𤂖', '濼','瀀','瀇','瀊','瀣','𤄃','瀹','瀺', */
	/* 8fefd0 */ 0x703c,0x7043,0x7047,0x704b,0x3d9a,0x7054,0x7065,0x7069, 0x706c,0x706e,0x7076,0x707e,0x7081,0x7086,0x7095,0x7097, /* '瀼','灃','灇','灋','㶚','灔','灥','灩', '灬','灮','灶','灾','炁','炆','炕','炗', */
	/* 8fefe0 */ 0x70bb,0x241c6,0x709f,0x70b1,0x241fe,0x70ec,0x70ca,0x70d1, 0x70d3,0x70dc,0x7103,0x7104,0x7106,0x7107,0x7108,0x710c, /* '炻','𤇆','炟','炱','𤇾','烬','烊','烑', '烓','烜','焃','焄','焆','焇','焈','焌', */
	/* 8feff0 */ 0x3dc0,0x712f,0x7131,0x7150,0x714a,0x7153,0x715e,0x3dd4, 0x7196,0x7180,0x719b,0x71a0,0x71a2,0x71ae,0x71af,0, /* '㷀','焯','焱','煐','煊','煓','煞','㷔', '熖','熀','熛','熠','熢','熮','熯',0, */
	/* 8ff000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff0a0 */ 0,0x71b3,0x243bc,0x71cb,0x71d3,0x71d9,0x71dc,0x7207, 0x3e05,0xfa49,0x722b,0x7234,0x7238,0x7239,0x4e2c,0x7242, /* 0,'熳','𤎼','燋','燓','燙','燜','爇', '㸅','爫','爫','爴','爸','爹','丬','牂', */
	/* 8ff0b0 */ 0x7253,0x7257,0x7263,0x24629,0x726e,0x726f,0x7278,0x727f, 0x728e,0x246a5,0x72ad,0x72ae,0x72b0,0x72b1,0x72c1,0x3e60, /* '牓','牗','牣','𤘩','牮','牯','牸','牿', '犎','𤚥','犭','犮','犰','犱','狁','㹠', */
	/* 8ff0c0 */ 0x72cc,0x3e66,0x3e68,0x72f3,0x72fa,0x7307,0x7312,0x7318, 0x7319,0x3e83,0x7339,0x732c,0x7331,0x7333,0x733d,0x7352, /* '狌','㹦','㹨','狳','狺','猇','猒','猘', '猙','㺃','猹','猬','猱','猳','猽','獒', */
	/* 8ff0d0 */ 0x3e94,0x736b,0x736c,0x24896,0x736e,0x736f,0x7371,0x7377, 0x7381,0x7385,0x738a,0x7394,0x7398,0x739c,0x739e,0x73a5, /* '㺔','獫','獬','𤢖','獮','獯','獱','獷', '玁','玅','玊','玔','玘','玜','玞','玥', */
	/* 8ff0e0 */ 0x73a8,0x73b5,0x73b7,0x73b9,0x73bc,0x73bf,0x73c5,0x73cb, 0x73e1,0x73e7,0x73f9,0x7413,0x73fa,0x7401,0x7424,0x7431, /* '玨','玵','玷','玹','玼','玿','珅','珋', '珡','珧','珹','琓','珺','琁','琤','琱', */
	/* 8ff0f0 */ 0x7439,0x7453,0x7440,0x7443,0x744d,0x7452,0x745d,0x7471, 0x7481,0x7485,0x7488,0x24a4d,0x7492,0x7497,0x7499,0, /* '琹','瑓','瑀','瑃','瑍','瑒','瑝','瑱', '璁','璅','璈','𤩍','璒','璗','璙',0, */
	/* 8ff100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff1a0 */ 0,0x74a0,0x74a1,0x74a5,0x74aa,0x74ab,0x74b9,0x74bb, 0x74ba,0x74d6,0x74d8,0x74de,0x74ef,0x74eb,0x24b56,0x74fa, /* 0,'璠','璡','璥','璪','璫','璹','璻', '璺','瓖','瓘','瓞','瓯','瓫','𤭖','瓺', */
	/* 8ff1b0 */ 0x24b6f,0x7520,0x7524,0x752a,0x3f57,0x24c16,0x753d,0x753e, 0x7540,0x7548,0x754e,0x7550,0x7552,0x756c,0x7572,0x7571, /* '𤭯','甠','甤','甪','㽗','𤰖','甽','甾', '畀','畈','畎','畐','畒','畬','畲','畱', */
	/* 8ff1c0 */ 0x757a,0x757d,0x757e,0x7581,0x24d14,0x758c,0x3f75,0x75a2, 0x3f77,0x75b0,0x75b7,0x75bf,0x75c0,0x75c6,0x75cf,0x75d3, /* '畺','畽','畾','疁','𤴔','疌','㽵','疢', '㽷','疰','疷','疿','痀','痆','痏','痓', */
	/* 8ff1d0 */ 0x75dd,0x75df,0x75e0,0x75e7,0x75ec,0x75ee,0x75f1,0x75f9, 0x7603,0x7618,0x7607,0x760f,0x3fae,0x24e0e,0x7613,0x761b, /* '痝','痟','痠','痧','痬','痮','痱','痹', '瘃','瘘','瘇','瘏','㾮','𤸎','瘓','瘛', */
	/* 8ff1e0 */ 0x761c,0x24e37,0x7625,0x7628,0x763c,0x7633,0x24e6a,0x3fc9, 0x7641,0x24e8b,0x7649,0x7655,0x3fd7,0x766e,0x7695,0x769c, /* '瘜','𤸷','瘥','瘨','瘼','瘳','𤹪','㿉', '癁','𤺋','癉','癕','㿗','癮','皕','皜', */
	/* 8ff1f0 */ 0x76a1,0x76a0,0x76a7,0x76a8,0x76af,0x2504a,0x76c9,0x25055, 0x76e8,0x76ec,0x25122,0x7717,0x771a,0x772d,0x7735,0, /* '皡','皠','皧','皨','皯','𥁊','盉','𥁕', '盨','盬','𥄢','眗','眚','眭','眵',0, */
	/* 8ff200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff2a0 */ 0,0x251a9,0x4039,0x251e5,0x251cd,0x7758,0x7760,0x776a, 0x2521e,0x7772,0x777c,0x777d,0x2524c,0x4058,0x779a,0x779f, /* 0,'𥆩','䀹','𥇥','𥇍','睘','睠','睪', '𥈞','睲','睼','睽','𥉌','䁘','瞚','瞟', */
	/* 8ff2b0 */ 0x77a2,0x77a4,0x77a9,0x77de,0x77df,0x77e4,0x77e6,0x77ea, 0x77ec,0x4093,0x77f0,0x77f4,0x77fb,0x2542e,0x7805,0x7806, /* '瞢','瞤','瞩','矞','矟','矤','矦','矪', '矬','䂓','矰','矴','矻','𥐮','砅','砆', */
	/* 8ff2c0 */ 0x7809,0x780d,0x7819,0x7821,0x782c,0x7847,0x7864,0x786a, 0x254d9,0x788a,0x7894,0x78a4,0x789d,0x789e,0x789f,0x78bb, /* '砉','砍','砙','砡','砬','硇','硤','硪', '𥓙','碊','碔','碤','碝','碞','碟','碻', */
	/* 8ff2d0 */ 0x78c8,0x78cc,0x78ce,0x78d5,0x78e0,0x78e1,0x78e6,0x78f9, 0x78fa,0x78fb,0x78fe,0x255a7,0x7910,0x791b,0x7930,0x7925, /* '磈','磌','磎','磕','磠','磡','磦','磹', '磺','磻','磾','𥖧','礐','礛','礰','礥', */
	/* 8ff2e0 */ 0x793b,0x794a,0x7958,0x795b,0x4105,0x7967,0x7972,0x7994, 0x7995,0x7996,0x799b,0x79a1,0x79a9,0x79b4,0x79bb,0x79c2, /* '礻','祊','祘','祛','䄅','祧','祲','禔', '禕','禖','禛','禡','禩','禴','离','秂', */
	/* 8ff2f0 */ 0x79c7,0x79cc,0x79cd,0x79d6,0x4148,0x257a9,0x257b4,0x414f, 0x7a0a,0x7a11,0x7a15,0x7a1b,0x7a1e,0x4163,0x7a2d,0, /* '秇','秌','种','秖','䅈','𥞩','𥞴','䅏', '稊','稑','稕','稛','稞','䅣','稭',0, */
	/* 8ff300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff3a0 */ 0,0x7a38,0x7a47,0x7a4c,0x7a56,0x7a59,0x7a5c,0x7a5f, 0x7a60,0x7a67,0x7a6a,0x7a75,0x7a78,0x7a82,0x7a8a,0x7a90, /* 0,'稸','穇','穌','穖','穙','穜','穟', '穠','穧','穪','穵','穸','窂','窊','窐', */
	/* 8ff3b0 */ 0x7aa3,0x7aac,0x259d4,0x41b4,0x7ab9,0x7abc,0x7abe,0x41bf, 0x7acc,0x7ad1,0x7ae7,0x7ae8,0x7af4,0x25ae4,0x25ae3,0x7b07, /* '窣','窬','𥧔','䆴','窹','窼','窾','䆿', '竌','竑','竧','竨','竴','𥫤','𥫣','笇', */
	/* 8ff3c0 */ 0x25af1,0x7b3d,0x7b27,0x7b2a,0x7b2e,0x7b2f,0x7b31,0x41e6, 0x41f3,0x7b7f,0x7b41,0x41ee,0x7b55,0x7b79,0x7b64,0x7b66, /* '𥫱','笽','笧','笪','笮','笯','笱','䇦', '䇳','筿','筁','䇮','筕','筹','筤','筦', */
	/* 8ff3d0 */ 0x7b69,0x7b73,0x25bb2,0x4207,0x7b90,0x7b91,0x7b9b,0x420e, 0x7baf,0x7bb5,0x7bbc,0x7bc5,0x7bca,0x25c4b,0x25c64,0x7bd4, /* '筩','筳','𥮲','䈇','箐','箑','箛','䈎', '箯','箵','箼','篅','篊','𥱋','𥱤','篔', */
	/* 8ff3e0 */ 0x7bd6,0x7bda,0x7bea,0x7bf0,0x7c03,0x7c0b,0x7c0e,0x7c0f, 0x7c26,0x7c45,0x7c4a,0x7c51,0x7c57,0x7c5e,0x7c61,0x7c69, /* '篖','篚','篪','篰','簃','簋','簎','簏', '簦','籅','籊','籑','籗','籞','籡','籩', */
	/* 8ff3f0 */ 0x7c6e,0x7c6f,0x7c70,0x25e2e,0x25e56,0x25e65,0x7ca6,0x25e62, 0x7cb6,0x7cb7,0x7cbf,0x25ed8,0x7cc4,0x25ec2,0x7cc8,0, /* '籮','籯','籰','𥸮','𥹖','𥹥','粦','𥹢', '粶','粷','粿','𥻘','糄','𥻂','糈',0, */
	/* 8ff400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff4a0 */ 0,0x7ccd,0x25ee8,0x7cd7,0x25f23,0x7ce6,0x7ceb,0x25f5c, 0x7cf5,0x7d03,0x7d09,0x42c6,0x7d12,0x7d1e,0x25fe0,0x25fd4, /* 0,'糍','𥻨','糗','𥼣','糦','糫','𥽜', '糵','紃','紉','䋆','紒','紞','𥿠','𥿔', */
	/* 8ff4b0 */ 0x7d3d,0x7d3e,0x7d40,0x7d47,0x2600c,0x25ffb,0x42d6,0x7d59, 0x7d5a,0x7d6a,0x7d70,0x42dd,0x7d7f,0x26017,0x7d86,0x7d88, /* '紽','紾','絀','絇','𦀌','𥿻','䋖','絙', '絚','絪','絰','䋝','絿','𦀗','綆','綈', */
	/* 8ff4c0 */ 0x7d8c,0x7d97,0x26060,0x7d9d,0x7da7,0x7daa,0x7db6,0x7db7, 0x7dc0,0x7dd7,0x7dd9,0x7de6,0x7df1,0x7df9,0x4302,0x260ed, /* '綌','綗','𦁠','綝','綧','綪','綶','綷', '緀','緗','緙','緦','緱','緹','䌂','𦃭', */
	/* 8ff4d0 */ 0xfa58,0x7e10,0x7e17,0x7e1d,0x7e20,0x7e27,0x7e2c,0x7e45, 0x7e73,0x7e75,0x7e7e,0x7e86,0x7e87,0x432b,0x7e91,0x7e98, /* '縉','縐','縗','縝','縠','縧','縬','繅', '繳','繵','繾','纆','纇','䌫','纑','纘', */
	/* 8ff4e0 */ 0x7e9a,0x4343,0x7f3c,0x7f3b,0x7f3e,0x7f43,0x7f44,0x7f4f, 0x34c1,0x26270,0x7f52,0x26286,0x7f61,0x7f63,0x7f64,0x7f6d, /* '纚','䍃','缼','缻','缾','罃','罄','罏', '㓁','𦉰','罒','𦊆','罡','罣','罤','罭', */
	/* 8ff4f0 */ 0x7f7d,0x7f7e,0x2634c,0x7f90,0x517b,0x23d0e,0x7f96,0x7f9c, 0x7fad,0x26402,0x7fc3,0x7fcf,0x7fe3,0x7fe5,0x7fef,0, /* '罽','罾','𦍌','羐','养','𣴎','羖','羜', '羭','𦐂','翃','翏','翣','翥','翯',0, */
	/* 8ff500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff5a0 */ 0,0x7ff2,0x8002,0x800a,0x8008,0x800e,0x8011,0x8016, 0x8024,0x802c,0x8030,0x8043,0x8066,0x8071,0x8075,0x807b, /* 0,'翲','耂','耊','耈','耎','耑','耖', '耤','耬','耰','聃','聦','聱','聵','聻', */
	/* 8ff5b0 */ 0x8099,0x809c,0x80a4,0x80a7,0x80b8,0x2667e,0x80c5,0x80d5, 0x80d8,0x80e6,0x266b0,0x810d,0x80f5,0x80fb,0x43ee,0x8135, /* '肙','肜','肤','肧','肸','𦙾','胅','胕', '胘','胦','𦚰','脍','胵','胻','䏮','脵', */
	/* 8ff5c0 */ 0x8116,0x811e,0x43f0,0x8124,0x8127,0x812c,0x2671d,0x813d, 0x4408,0x8169,0x4417,0x8181,0x441c,0x8184,0x8185,0x4422, /* '脖','脞','䏰','脤','脧','脬','𦜝','脽', '䐈','腩','䐗','膁','䐜','膄','膅','䐢', */
	/* 8ff5d0 */ 0x8198,0x81b2,0x81c1,0x81c3,0x81d6,0x81db,0x268dd,0x81e4, 0x268ea,0x81ec,0x26951,0x81fd,0x81ff,0x2696f,0x8204,0x269dd, /* '膘','膲','臁','臃','臖','臛','𦣝','臤', '𦣪','臬','𦥑','臽','臿','𦥯','舄','𦧝', */
	/* 8ff5e0 */ 0x8219,0x8221,0x8222,0x26a1e,0x8232,0x8234,0x823c,0x8246, 0x8249,0x8245,0x26a58,0x824b,0x4476,0x824f,0x447a,0x8257, /* '舙','舡','舢','𦨞','舲','舴','舼','艆', '艉','艅','𦩘','艋','䑶','艏','䑺','艗', */
	/* 8ff5f0 */ 0x26a8c,0x825c,0x8263,0x26ab7,0xfa5d,0xfa5e,0x8279,0x4491, 0x827d,0x827f,0x8283,0x828a,0x8293,0x82a7,0x82a8,0, /* '𦪌','艜','艣','𦪷','艹','艹','艹','䒑', '艽','艿','芃','芊','芓','芧','芨',0, */
	/* 8ff600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff6a0 */ 0,0x82b2,0x82b4,0x82ba,0x82bc,0x82e2,0x82e8,0x82f7, 0x8307,0x8308,0x830c,0x8354,0x831b,0x831d,0x8330,0x833c, /* 0,'芲','芴','芺','芼','苢','苨','苷', '茇','茈','茌','荔','茛','茝','茰','茼', */
	/* 8ff6b0 */ 0x8344,0x8357,0x44be,0x837f,0x44d4,0x44b3,0x838d,0x8394, 0x8395,0x839b,0x839d,0x83c9,0x83d0,0x83d4,0x83dd,0x83e5, /* '荄','荗','䒾','荿','䓔','䒳','莍','莔', '莕','莛','莝','菉','菐','菔','菝','菥', */
	/* 8ff6c0 */ 0x83f9,0x840f,0x8411,0x8415,0x26c73,0x8417,0x8439,0x844a, 0x844f,0x8451,0x8452,0x8459,0x845a,0x845c,0x26cdd,0x8465, /* '菹','萏','萑','萕','𦱳','萗','萹','葊', '葏','葑','葒','葙','葚','葜','𦳝','葥', */
	/* 8ff6d0 */ 0x8476,0x8478,0x847c,0x8481,0x450d,0x84dc,0x8497,0x84a6, 0x84be,0x4508,0x84ce,0x84cf,0x84d3,0x26e65,0x84e7,0x84ea, /* '葶','葸','葼','蒁','䔍','蓜','蒗','蒦', '蒾','䔈','蓎','蓏','蓓','𦹥','蓧','蓪', */
	/* 8ff6e0 */ 0x84ef,0x84f0,0x84f1,0x84fa,0x84fd,0x850c,0x851b,0x8524, 0x8525,0x852b,0x8534,0x854f,0x856f,0x4525,0x4543,0x853e, /* '蓯','蓰','蓱','蓺','蓽','蔌','蔛','蔤', '蔥','蔫','蔴','蕏','蕯','䔥','䕃','蔾', */
	/* 8ff6f0 */ 0x8551,0x8553,0x855e,0x8561,0x8562,0x26f94,0x857b,0x857d, 0x857f,0x8581,0x8586,0x8593,0x859d,0x859f,0x26ff8,0, /* '蕑','蕓','蕞','蕡','蕢','𦾔','蕻','蕽', '蕿','薁','薆','薓','薝','薟','𦿸',0, */
	/* 8ff700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff7a0 */ 0,0x26ff6,0x26ff7,0x85b7,0x85bc,0x85c7,0x85ca,0x85d8, 0x85d9,0x85df,0x85e1,0x85e6,0x85f6,0x8600,0x8611,0x861e, /* 0,'𦿶','𦿷','薷','薼','藇','藊','藘', '藙','藟','藡','藦','藶','蘀','蘑','蘞', */
	/* 8ff7b0 */ 0x8621,0x8624,0x8627,0x2710d,0x8639,0x863c,0x27139,0x8640, 0xfa20,0x8653,0x8656,0x866f,0x8677,0x867a,0x8687,0x8689, /* '蘡','蘤','蘧','𧄍','蘹','蘼','𧄹','虀', '蘒','虓','虖','虯','虷','虺','蚇','蚉', */
	/* 8ff7c0 */ 0x868d,0x8691,0x869c,0x869d,0x86a8,0xfa21,0x86b1,0x86b3, 0x86c1,0x86c3,0x86d1,0x86d5,0x86d7,0x86e3,0x86e6,0x45b8, /* '蚍','蚑','蚜','蚝','蚨','﨡','蚱','蚳', '蛁','蛃','蛑','蛕','蛗','蛣','蛦','䖸', */
	/* 8ff7d0 */ 0x8705,0x8707,0x870e,0x8710,0x8713,0x8719,0x871f,0x8721, 0x8723,0x8731,0x873a,0x873e,0x8740,0x8743,0x8751,0x8758, /* '蜅','蜇','蜎','蜐','蜓','蜙','蜟','蜡', '蜣','蜱','蜺','蜾','蝀','蝃','蝑','蝘', */
	/* 8ff7e0 */ 0x8764,0x8765,0x8772,0x877c,0x273db,0x273da,0x87a7,0x8789, 0x878b,0x8793,0x87a0,0x273fe,0x45e5,0x87be,0x27410,0x87c1, /* '蝤','蝥','蝲','蝼','𧏛','𧏚','螧','螉', '螋','螓','螠','𧏾','䗥','螾','𧐐','蟁', */
	/* 8ff7f0 */ 0x87ce,0x87f5,0x87df,0x27449,0x87e3,0x87e5,0x87e6,0x87ea, 0x87eb,0x87ed,0x8801,0x8803,0x880b,0x8813,0x8828,0, /* '蟎','蟵','蟟','𧑉','蟣','蟥','蟦','蟪', '蟫','蟭','蠁','蠃','蠋','蠓','蠨',0, */
	/* 8ff800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff8a0 */ 0,0x882e,0x8832,0x883c,0x460f,0x884a,0x8858,0x885f, 0x8864,0x27615,0x27614,0x8869,0x27631,0x886f,0x88a0,0x88bc, /* 0,'蠮','蠲','蠼','䘏','衊','衘','衟', '衤','𧘕','𧘔','衩','𧘱','衯','袠','袼', */
	/* 8ff8b0 */ 0x88bd,0x88be,0x88c0,0x88d2,0x27693,0x88d1,0x88d3,0x88db, 0x88f0,0x88f1,0x4641,0x8901,0x2770e,0x8937,0x27723,0x8942, /* '袽','袾','裀','裒','𧚓','裑','裓','裛', '裰','裱','䙁','褁','𧜎','褷','𧜣','襂', */
	/* 8ff8c0 */ 0x8945,0x8949,0x27752,0x4665,0x8962,0x8980,0x8989,0x8990, 0x899f,0x89b0,0x89b7,0x89d6,0x89d8,0x89eb,0x46a1,0x89f1, /* '襅','襉','𧝒','䙥','襢','覀','覉','覐', '覟','覰','覷','觖','觘','觫','䚡','觱', */
	/* 8ff8d0 */ 0x89f3,0x89fd,0x89ff,0x46af,0x8a11,0x8a14,0x27985,0x8a21, 0x8a35,0x8a3e,0x8a45,0x8a4d,0x8a58,0x8aae,0x8a90,0x8ab7, /* '觳','觽','觿','䚯','訑','訔','𧦅','訡', '訵','訾','詅','詍','詘','誮','誐','誷', */
	/* 8ff8e0 */ 0x8abe,0x8ad7,0x8afc,0x27a84,0x8b0a,0x8b05,0x8b0d,0x8b1c, 0x8b1f,0x8b2d,0x8b43,0x470c,0x8b51,0x8b5e,0x8b76,0x8b7f, /* '誾','諗','諼','𧪄','謊','謅','謍','謜', '謟','謭','譃','䜌','譑','譞','譶','譿', */
	/* 8ff8f0 */ 0x8b81,0x8b8b,0x8b94,0x8b95,0x8b9c,0x8b9e,0x8c39,0x27bb3, 0x8c3d,0x27bbe,0x27bc7,0x8c45,0x8c47,0x8c4f,0x8c54,0, /* '讁','讋','讔','讕','讜','讞','谹','𧮳', '谽','𧮾','𧯇','豅','豇','豏','豔',0, */
	/* 8ff900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff9a0 */ 0,0x8c57,0x8c69,0x8c6d,0x8c73,0x27cb8,0x8c93,0x8c92, 0x8c99,0x4764,0x8c9b,0x8ca4,0x8cd6,0x8cd5,0x8cd9,0x27da0, /* 0,'豗','豩','豭','豳','𧲸','貓','貒', '貙','䝤','貛','貤','賖','賕','賙','𧶠', */
	/* 8ff9b0 */ 0x8cf0,0x8cf1,0x27e10,0x8d09,0x8d0e,0x8d6c,0x8d84,0x8d95, 0x8da6,0x27fb7,0x8dc6,0x8dc8,0x8dd9,0x8dec,0x8e0c,0x47fd, /* '賰','賱','𧸐','贉','贎','赬','趄','趕', '趦','𧾷','跆','跈','跙','跬','踌','䟽', */
	/* 8ff9c0 */ 0x8dfd,0x8e06,0x2808a,0x8e14,0x8e16,0x8e21,0x8e22,0x8e27, 0x280bb,0x4816,0x8e36,0x8e39,0x8e4b,0x8e54,0x8e62,0x8e6c, /* '跽','踆','𨂊','踔','踖','踡','踢','踧', '𨂻','䠖','踶','踹','蹋','蹔','蹢','蹬', */
	/* 8ff9d0 */ 0x8e6d,0x8e6f,0x8e98,0x8e9e,0x8eae,0x8eb3,0x8eb5,0x8eb6, 0x8ebb,0x28282,0x8ed1,0x8ed4,0x484e,0x8ef9,0x282f3,0x8f00, /* '蹭','蹯','躘','躞','躮','躳','躵','躶', '躻','𨊂','軑','軔','䡎','軹','𨋳','輀', */
	/* 8ff9e0 */ 0x8f08,0x8f17,0x8f2b,0x8f40,0x8f4a,0x8f58,0x2840c,0x8fa4, 0x8fb4,0xfa66,0x8fb6,0x28455,0x8fc1,0x8fc6,0xfa24,0x8fca, /* '輈','輗','輫','轀','轊','轘','𨐌','辤', '辴','辶','辶','𨑕','迁','迆','﨤','迊', */
	/* 8ff9f0 */ 0x8fcd,0x8fd3,0x8fd5,0x8fe0,0x8ff1,0x8ff5,0x8ffb,0x9002, 0x900c,0x9037,0x2856b,0x9043,0x9044,0x905d,0x285c8,0, /* '迍','迓','迕','迠','迱','迵','迻','适', '逌','逷','𨕫','遃','遄','遝','𨗈',0, */
	/* 8ffa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffaa0 */ 0,0x285c9,0x9085,0x908c,0x9090,0x961d,0x90a1,0x48b5, 0x90b0,0x90b6,0x90c3,0x90c8,0x286d7,0x90dc,0x90df,0x286fa, /* 0,'𨗉','邅','邌','邐','阝','邡','䢵', '邰','邶','郃','郈','𨛗','郜','郟','𨛺', */
	/* 8ffab0 */ 0x90f6,0x90f2,0x9100,0x90eb,0x90fe,0x90ff,0x9104,0x9106, 0x9118,0x911c,0x911e,0x9137,0x9139,0x913a,0x9146,0x9147, /* '郶','郲','鄀','郫','郾','郿','鄄','鄆', '鄘','鄜','鄞','鄷','鄹','鄺','酆','酇', */
	/* 8ffac0 */ 0x9157,0x9159,0x9161,0x9164,0x9174,0x9179,0x9185,0x918e, 0x91a8,0x91ae,0x91b3,0x91b6,0x91c3,0x91c4,0x91da,0x28949, /* '酗','酙','酡','酤','酴','酹','醅','醎', '醨','醮','醳','醶','釃','釄','釚','𨥉', */
	/* 8ffad0 */ 0x28946,0x91ec,0x91ee,0x9201,0x920a,0x9216,0x9217,0x2896b, 0x9233,0x9242,0x9247,0x924a,0x924e,0x9251,0x9256,0x9259, /* '𨥆','釬','釮','鈁','鈊','鈖','鈗','𨥫', '鈳','鉂','鉇','鉊','鉎','鉑','鉖','鉙', */
	/* 8ffae0 */ 0x9260,0x9261,0x9265,0x9267,0x9268,0x28987,0x28988,0x927c, 0x927d,0x927f,0x9289,0x928d,0x9297,0x9299,0x929f,0x92a7, /* '鉠','鉡','鉥','鉧','鉨','𨦇','𨦈','鉼', '鉽','鉿','銉','銍','銗','銙','銟','銧', */
	/* 8ffaf0 */ 0x92ab,0x289ba,0x289bb,0x92b2,0x92bf,0x92c0,0x92c6,0x92ce, 0x92d0,0x92d7,0x92d9,0x92e5,0x92e7,0x9311,0x28a1e,0, /* '銫','𨦺','𨦻','銲','銿','鋀','鋆','鋎', '鋐','鋗','鋙','鋥','鋧','錑','𨨞',0, */
	/* 8ffb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffba0 */ 0,0x28a29,0x92f7,0x92f9,0x92fb,0x9302,0x930d,0x9315, 0x931d,0x931e,0x9327,0x9329,0x28a71,0x28a43,0x9347,0x9351, /* 0,'𨨩','鋷','鋹','鋻','錂','錍','錕', '錝','錞','錧','錩','𨩱','𨩃','鍇','鍑', */
	/* 8ffbb0 */ 0x9357,0x935a,0x936b,0x9371,0x9373,0x93a1,0x28a99,0x28acd, 0x9388,0x938b,0x938f,0x939e,0x93f5,0x28ae4,0x28add,0x93f1, /* '鍗','鍚','鍫','鍱','鍳','鎡','𨪙','𨫍', '鎈','鎋','鎏','鎞','鏵','𨫤','𨫝','鏱', */
	/* 8ffbc0 */ 0x93c1,0x93c7,0x93dc,0x93e2,0x93e7,0x9409,0x940f,0x9416, 0x9417,0x93fb,0x9432,0x9434,0x943b,0x9445,0x28bc1,0x28bef, /* '鏁','鏇','鏜','鏢','鏧','鐉','鐏','鐖', '鐗','鏻','鐲','鐴','鐻','鑅','𨯁','𨯯', */
	/* 8ffbd0 */ 0x946d,0x946f,0x9578,0x9579,0x9586,0x958c,0x958d,0x28d10, 0x95ab,0x95b4,0x28d71,0x95c8,0x28dfb,0x28e1f,0x962c,0x9633, /* '鑭','鑯','镸','镹','閆','閌','閍','𨴐', '閫','閴','𨵱','闈','𨷻','𨸟','阬','阳', */
	/* 8ffbe0 */ 0x9634,0x28e36,0x963c,0x9641,0x9661,0x28e89,0x9682,0x28eeb, 0x969a,0x28f32,0x49e7,0x96a9,0x96af,0x96b3,0x96ba,0x96bd, /* '阴','𨸶','阼','陁','陡','𨺉','隂','𨻫', '隚','𨼲','䧧','隩','隯','隳','隺','隽', */
	/* 8ffbf0 */ 0x49fa,0x28ff8,0x96d8,0x96da,0x96dd,0x4a04,0x9714,0x9723, 0x4a29,0x9736,0x9741,0x9747,0x9755,0x9757,0x975b,0, /* '䧺','𨿸','雘','雚','雝','䨄','霔','霣', '䨩','霶','靁','靇','靕','靗','靛',0, */
	/* 8ffc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffca0 */ 0,0x976a,0x292a0,0x292b1,0x9796,0x979a,0x979e,0x97a2, 0x97b1,0x97b2,0x97be,0x97cc,0x97d1,0x97d4,0x97d8,0x97d9, /* 0,'靪','𩊠','𩊱','鞖','鞚','鞞','鞢', '鞱','鞲','鞾','韌','韑','韔','韘','韙', */
	/* 8ffcb0 */ 0x97e1,0x97f1,0x9804,0x980d,0x980e,0x9814,0x9816,0x4abc, 0x29490,0x9823,0x9832,0x9833,0x9825,0x9847,0x9866,0x98ab, /* '韡','韱','頄','頍','頎','頔','頖','䪼', '𩒐','頣','頲','頳','頥','顇','顦','颫', */
	/* 8ffcc0 */ 0x98ad,0x98b0,0x295cf,0x98b7,0x98b8,0x98bb,0x98bc,0x98bf, 0x98c2,0x98c7,0x98cb,0x98e0,0x2967f,0x98e1,0x98e3,0x98e5, /* '颭','颰','𩗏','颷','颸','颻','颼','颿', '飂','飇','飋','飠','𩙿','飡','飣','飥', */
	/* 8ffcd0 */ 0x98ea,0x98f0,0x98f1,0x98f3,0x9908,0x4b3b,0x296f0,0x9916, 0x9917,0x29719,0x991a,0x991b,0x991c,0x29750,0x9931,0x9932, /* '飪','飰','飱','飳','餈','䬻','𩛰','餖', '餗','𩜙','餚','餛','餜','𩝐','餱','餲', */
	/* 8ffce0 */ 0x9933,0x993a,0x993b,0x993c,0x9940,0x9941,0x9946,0x994d, 0x994e,0x995c,0x995f,0x9960,0x99a3,0x99a6,0x99b9,0x99bd, /* '餳','餺','餻','餼','饀','饁','饆','饍', '饎','饜','饟','饠','馣','馦','馹','馽', */
	/* 8ffcf0 */ 0x99bf,0x99c3,0x99c9,0x99d4,0x99d9,0x99de,0x298c6,0x99f0, 0x99f9,0x99fc,0x9a0a,0x9a11,0x9a16,0x9a1a,0x9a20,0, /* '馿','駃','駉','駔','駙','駞','𩣆','駰', '駹','駼','騊','騑','騖','騚','騠',0, */
	/* 8ffd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffda0 */ 0,0x9a31,0x9a36,0x9a44,0x9a4c,0x9a58,0x4bc2,0x9aaf, 0x4bca,0x9ab7,0x4bd2,0x9ab9,0x29a72,0x9ac6,0x9ad0,0x9ad2, /* 0,'騱','騶','驄','驌','驘','䯂','骯', '䯊','骷','䯒','骹','𩩲','髆','髐','髒', */
	/* 8ffdb0 */ 0x9ad5,0x4be8,0x9adc,0x9ae0,0x9ae5,0x9ae9,0x9b03,0x9b0c, 0x9b10,0x9b12,0x9b16,0x9b1c,0x9b2b,0x9b33,0x9b3d,0x4c20, /* '髕','䯨','髜','髠','髥','髩','鬃','鬌', '鬐','鬒','鬖','鬜','鬫','鬳','鬽','䰠', */
	/* 8ffdc0 */ 0x9b4b,0x9b63,0x9b65,0x9b6b,0x9b6c,0x9b73,0x9b76,0x9b77, 0x9ba6,0x9bac,0x9bb1,0x29ddb,0x29e3d,0x9bb2,0x9bb8,0x9bbe, /* '魋','魣','魥','魫','魬','魳','魶','魷', '鮦','鮬','鮱','𩷛','𩸽','鮲','鮸','鮾', */
	/* 8ffdd0 */ 0x9bc7,0x9bf3,0x9bd8,0x9bdd,0x9be7,0x9bea,0x9beb,0x9bef, 0x9bee,0x29e15,0x9bfa,0x29e8a,0x9bf7,0x29e49,0x9c16,0x9c18, /* '鯇','鯳','鯘','鯝','鯧','鯪','鯫','鯯', '鯮','𩸕','鯺','𩺊','鯷','𩹉','鰖','鰘', */
	/* 8ffde0 */ 0x9c19,0x9c1a,0x9c1d,0x9c22,0x9c27,0x9c29,0x9c2a,0x29ec4, 0x9c31,0x9c36,0x9c37,0x9c45,0x9c5c,0x29ee9,0x9c49,0x9c4a, /* '鰙','鰚','鰝','鰢','鰧','鰩','鰪','𩻄', '鰱','鰶','鰷','鱅','鱜','𩻩','鱉','鱊', */
	/* 8ffdf0 */ 0x29edb,0x9c54,0x9c58,0x9c5b,0x9c5d,0x9c5f,0x9c69,0x9c6a, 0x9c6b,0x9c6d,0x9c6e,0x9c70,0x9c72,0x9c75,0x9c7a,0, /* '𩻛','鱔','鱘','鱛','鱝','鱟','鱩','鱪', '鱫','鱭','鱮','鱰','鱲','鱵','鱺',0, */
	/* 8ffe00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffe10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffe20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffe30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffe40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffe50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffe60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffe70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffe80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffe90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ffea0 */ 0,0x9ce6,0x9cf2,0x9d0b,0x9d02,0x29fce,0x9d11,0x9d17, 0x9d18,0x2a02f,0x4cc4,0x2a01a,0x9d32,0x4cd1,0x9d42,0x9d4a, /* 0,'鳦','鳲','鴋','鴂','𩿎','鴑','鴗', '鴘','𪀯','䳄','𪀚','鴲','䳑','鵂','鵊', */
	/* 8ffeb0 */ 0x9d5f,0x9d62,0x2a0f9,0x9d69,0x9d6b,0x2a082,0x9d73,0x9d76, 0x9d77,0x9d7e,0x9d84,0x9d8d,0x9d99,0x9da1,0x9dbf,0x9db5, /* '鵟','鵢','𪃹','鵩','鵫','𪂂','鵳','鵶', '鵷','鵾','鶄','鶍','鶙','鶡','鶿','鶵', */
	/* 8ffec0 */ 0x9db9,0x9dbd,0x9dc3,0x9dc7,0x9dc9,0x9dd6,0x9dda,0x9ddf, 0x9de0,0x9de3,0x9df4,0x4d07,0x9e0a,0x9e02,0x9e0d,0x9e19, /* '鶹','鶽','鷃','鷇','鷉','鷖','鷚','鷟', '鷠','鷣','鷴','䴇','鸊','鸂','鸍','鸙', */
	/* 8ffed0 */ 0x9e1c,0x9e1d,0x9e7b,0x22218,0x9e80,0x9e85,0x9e9b,0x9ea8, 0x2a38c,0x9ebd,0x2a437,0x9edf,0x9ee7,0x9eee,0x9eff,0x9f02, /* '鸜','鸝','鹻','𢈘','麀','麅','麛','麨', '𪎌','麽','𪐷','黟','黧','黮','黿','鼂', */
	/* 8ffee0 */ 0x4d77,0x9f03,0x9f17,0x9f19,0x9f2f,0x9f37,0x9f3a,0x9f3d, 0x9f41,0x9f45,0x9f46,0x9f53,0x9f55,0x9f58,0x2a5f1,0x9f5d, /* '䵷','鼃','鼗','鼙','鼯','鼷','鼺','鼽', '齁','齅','齆','齓','齕','齘','𪗱','齝', */
	/* 8ffef0 */ 0x2a602,0x9f69,0x2a61a,0x9f6d,0x9f70,0x9f75,0x2a6b2, /* '𪘂','齩','𪘚','齭','齰','齵','𪚲', */
};

const size_t _euc2unibe2004_table8f_size = sizeof(_euc2unibe2004_table8f) / sizeof(_euc2unibe2004_table8f[0]);

#endif /* #ifndef __EUC2UNIBE2004_TABLE8F_H_ */
