/*
 * _euc2unibems_table8f.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __EUC2UNIBEMS_TABLE8F_H_
#define __EUC2UNIBEMS_TABLE8F_H_

#include <stddef.h>
#include <stdint.h>

const size_t _euc2unibems_table8f_offset = 0xa2a0;

const uint16_t _euc2unibems_table8f[] = {
	/* 8fa2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x02d8, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'˘', */
	/* 8fa2b0 */ 0x02c7,0x00b8,0x02d9,0x02dd,0x00af,0x02db,0x02da,0x301c, 0x0384,0x0385,0,0,0,0,0,0, /* 'ˇ','¸','˙','˝','¯','˛','˚','〜', '΄','΅',0,0,0,0,0,0, */
	/* 8fa2c0 */ 0,0,0x00a1,0xffe4,0x00bf,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'¡','￤','¿',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8fa2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x00ba,0x00aa,0x00a9,0x00ae,0x2122, /* 0,0,0,0,0,0,0,0, 0,0,0,'º','ª','©','®','™', */
	/* 8fa2f0 */ 0x00a4,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '¤',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8fa300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa6e0 */ 0,0x0386,0x0388,0x0389,0x038a,0x03aa,0,0x038c, 0,0x038e,0x03ab,0,0x038f,0,0,0, /* 0,'Ά','Έ','Ή','Ί','Ϊ',0,'Ό', 0,'Ύ','Ϋ',0,'Ώ',0,0,0, */
	/* 8fa6f0 */ 0,0x03ac,0x03ad,0x03ae,0x03af,0x03ca,0x0390,0x03cc, 0x03c2,0x03cd,0x03cb,0x03b0,0x03ce,0,0,0, /* 0,'ά','έ','ή','ί','ϊ','ΐ','ό', 'ς','ύ','ϋ','ΰ','ώ',0,0,0, */
	/* 8fa700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7c0 */ 0,0,0x0402,0x0403,0x0404,0x0405,0x0406,0x0407, 0x0408,0x0409,0x040a,0x040b,0x040c,0x040e,0x040f,0, /* 0,0,'Ђ','Ѓ','Є','Ѕ','І','Ї', 'Ј','Љ','Њ','Ћ','Ќ','Ў','Џ',0, */
	/* 8fa7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa7f0 */ 0,0,0x0452,0x0453,0x0454,0x0455,0x0456,0x0457, 0x0458,0x0459,0x045a,0x045b,0x045c,0x045e,0x045f,0, /* 0,0,'ђ','ѓ','є','ѕ','і','ї', 'ј','љ','њ','ћ','ќ','ў','џ',0, */
	/* 8fa800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa9a0 */ 0,0x00c6,0x0110,0,0x0126,0,0x0132,0, 0x0141,0x013f,0,0x014a,0x00d8,0x0152,0,0x0166, /* 0,'Æ','Đ',0,'Ħ',0,'Ĳ',0, 'Ł','Ŀ',0,'Ŋ','Ø','Œ',0,'Ŧ', */
	/* 8fa9b0 */ 0x00de,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 'Þ',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8fa9c0 */ 0,0x00e6,0x0111,0x00f0,0x0127,0x0131,0x0133,0x0138, 0x0142,0x0140,0x0149,0x014b,0x00f8,0x0153,0x00df,0x0167, /* 0,'æ','đ','ð','ħ','ı','ĳ','ĸ', 'ł','ŀ','ŉ','ŋ','ø','œ','ß','ŧ', */
	/* 8fa9d0 */ 0x00fe,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 'þ',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8fa9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fa9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faaa0 */ 0,0x00c1,0x00c0,0x00c4,0x00c2,0x0102,0x01cd,0x0100, 0x0104,0x00c5,0x00c3,0x0106,0x0108,0x010c,0x00c7,0x010a, /* 0,'Á','À','Ä','Â','Ă','Ǎ','Ā', 'Ą','Å','Ã','Ć','Ĉ','Č','Ç','Ċ', */
	/* 8faab0 */ 0x010e,0x00c9,0x00c8,0x00cb,0x00ca,0x011a,0x0116,0x0112, 0x0118,0,0x011c,0x011e,0x0122,0x0120,0x0124,0x00cd, /* 'Ď','É','È','Ë','Ê','Ě','Ė','Ē', 'Ę',0,'Ĝ','Ğ','Ģ','Ġ','Ĥ','Í', */
	/* 8faac0 */ 0x00cc,0x00cf,0x00ce,0x01cf,0x0130,0x012a,0x012e,0x0128, 0x0134,0x0136,0x0139,0x013d,0x013b,0x0143,0x0147,0x0145, /* 'Ì','Ï','Î','Ǐ','İ','Ī','Į','Ĩ', 'Ĵ','Ķ','Ĺ','Ľ','Ļ','Ń','Ň','Ņ', */
	/* 8faad0 */ 0x00d1,0x00d3,0x00d2,0x00d6,0x00d4,0x01d1,0x0150,0x014c, 0x00d5,0x0154,0x0158,0x0156,0x015a,0x015c,0x0160,0x015e, /* 'Ñ','Ó','Ò','Ö','Ô','Ǒ','Ő','Ō', 'Õ','Ŕ','Ř','Ŗ','Ś','Ŝ','Š','Ş', */
	/* 8faae0 */ 0x0164,0x0162,0x00da,0x00d9,0x00dc,0x00db,0x016c,0x01d3, 0x0170,0x016a,0x0172,0x016e,0x0168,0x01d7,0x01db,0x01d9, /* 'Ť','Ţ','Ú','Ù','Ü','Û','Ŭ','Ǔ', 'Ű','Ū','Ų','Ů','Ũ','Ǘ','Ǜ','Ǚ', */
	/* 8faaf0 */ 0x01d5,0x0174,0x00dd,0x0178,0x0176,0x0179,0x017d,0x017b, 0,0,0,0,0,0,0,0, /* 'Ǖ','Ŵ','Ý','Ÿ','Ŷ','Ź','Ž','Ż', 0,0,0,0,0,0,0,0, */
	/* 8fab00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fab90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faba0 */ 0,0x00e1,0x00e0,0x00e4,0x00e2,0x0103,0x01ce,0x0101, 0x0105,0x00e5,0x00e3,0x0107,0x0109,0x010d,0x00e7,0x010b, /* 0,'á','à','ä','â','ă','ǎ','ā', 'ą','å','ã','ć','ĉ','č','ç','ċ', */
	/* 8fabb0 */ 0x010f,0x00e9,0x00e8,0x00eb,0x00ea,0x011b,0x0117,0x0113, 0x0119,0x01f5,0x011d,0x011f,0,0x0121,0x0125,0x00ed, /* 'ď','é','è','ë','ê','ě','ė','ē', 'ę','ǵ','ĝ','ğ',0,'ġ','ĥ','í', */
	/* 8fabc0 */ 0x00ec,0x00ef,0x00ee,0x01d0,0,0x012b,0x012f,0x0129, 0x0135,0x0137,0x013a,0x013e,0x013c,0x0144,0x0148,0x0146, /* 'ì','ï','î','ǐ',0,'ī','į','ĩ', 'ĵ','ķ','ĺ','ľ','ļ','ń','ň','ņ', */
	/* 8fabd0 */ 0x00f1,0x00f3,0x00f2,0x00f6,0x00f4,0x01d2,0x0151,0x014d, 0x00f5,0x0155,0x0159,0x0157,0x015b,0x015d,0x0161,0x015f, /* 'ñ','ó','ò','ö','ô','ǒ','ő','ō', 'õ','ŕ','ř','ŗ','ś','ŝ','š','ş', */
	/* 8fabe0 */ 0x0165,0x0163,0x00fa,0x00f9,0x00fc,0x00fb,0x016d,0x01d4, 0x0171,0x016b,0x0173,0x016f,0x0169,0x01d8,0x01dc,0x01da, /* 'ť','ţ','ú','ù','ü','û','ŭ','ǔ', 'ű','ū','ų','ů','ũ','ǘ','ǜ','ǚ', */
	/* 8fabf0 */ 0x01d6,0x0175,0x00fd,0x00ff,0x0177,0x017a,0x017e,0x017c, 0,0,0,0,0,0,0,0, /* 'ǖ','ŵ','ý','ÿ','ŷ','ź','ž','ż', 0,0,0,0,0,0,0,0, */
	/* 8fac00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fac90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8facb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8facc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8facd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8face0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8facf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fad90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fada0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fadb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fadc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fadd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fade0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fadf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fae90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fafa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fafb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fafc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fafd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fafe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8faff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb0a0 */ 0,0x4e02,0x4e04,0x4e05,0x4e0c,0x4e12,0x4e1f,0x4e23, 0x4e24,0x4e28,0x4e2b,0x4e2e,0x4e2f,0x4e30,0x4e35,0x4e40, /* 0,'丂','丄','丅','丌','丒','丟','丣', '两','丨','丫','丮','丯','丰','丵','乀', */
	/* 8fb0b0 */ 0x4e41,0x4e44,0x4e47,0x4e51,0x4e5a,0x4e5c,0x4e63,0x4e68, 0x4e69,0x4e74,0x4e75,0x4e79,0x4e7f,0x4e8d,0x4e96,0x4e97, /* '乁','乄','乇','乑','乚','乜','乣','乨', '乩','乴','乵','乹','乿','亍','亖','亗', */
	/* 8fb0c0 */ 0x4e9d,0x4eaf,0x4eb9,0x4ec3,0x4ed0,0x4eda,0x4edb,0x4ee0, 0x4ee1,0x4ee2,0x4ee8,0x4eef,0x4ef1,0x4ef3,0x4ef5,0x4efd, /* '亝','亯','亹','仃','仐','仚','仛','仠', '仡','仢','仨','仯','仱','仳','仵','份', */
	/* 8fb0d0 */ 0x4efe,0x4eff,0x4f00,0x4f02,0x4f03,0x4f08,0x4f0b,0x4f0c, 0x4f12,0x4f15,0x4f16,0x4f17,0x4f19,0x4f2e,0x4f31,0x4f60, /* '仾','仿','伀','伂','伃','伈','伋','伌', '伒','伕','伖','众','伙','伮','伱','你', */
	/* 8fb0e0 */ 0x4f33,0x4f35,0x4f37,0x4f39,0x4f3b,0x4f3e,0x4f40,0x4f42, 0x4f48,0x4f49,0x4f4b,0x4f4c,0x4f52,0x4f54,0x4f56,0x4f58, /* '伳','伵','伷','伹','伻','伾','佀','佂', '佈','佉','佋','佌','佒','佔','佖','佘', */
	/* 8fb0f0 */ 0x4f5f,0x4f63,0x4f6a,0x4f6c,0x4f6e,0x4f71,0x4f77,0x4f78, 0x4f79,0x4f7a,0x4f7d,0x4f7e,0x4f81,0x4f82,0x4f84,0, /* '佟','佣','佪','佬','佮','佱','佷','佸', '佹','佺','佽','佾','侁','侂','侄',0, */
	/* 8fb100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb1a0 */ 0,0x4f85,0x4f89,0x4f8a,0x4f8c,0x4f8e,0x4f90,0x4f92, 0x4f93,0x4f94,0x4f97,0x4f99,0x4f9a,0x4f9e,0x4f9f,0x4fb2, /* 0,'侅','侉','侊','侌','侎','侐','侒', '侓','侔','侗','侙','侚','侞','侟','侲', */
	/* 8fb1b0 */ 0x4fb7,0x4fb9,0x4fbb,0x4fbc,0x4fbd,0x4fbe,0x4fc0,0x4fc1, 0x4fc5,0x4fc6,0x4fc8,0x4fc9,0x4fcb,0x4fcc,0x4fcd,0x4fcf, /* '侷','侹','侻','侼','侽','侾','俀','俁', '俅','俆','俈','俉','俋','俌','俍','俏', */
	/* 8fb1c0 */ 0x4fd2,0x4fdc,0x4fe0,0x4fe2,0x4ff0,0x4ff2,0x4ffc,0x4ffd, 0x4fff,0x5000,0x5001,0x5004,0x5007,0x500a,0x500c,0x500e, /* '俒','俜','俠','俢','俰','俲','俼','俽', '俿','倀','倁','倄','倇','倊','倌','倎', */
	/* 8fb1d0 */ 0x5010,0x5013,0x5017,0x5018,0x501b,0x501c,0x501d,0x501e, 0x5022,0x5027,0x502e,0x5030,0x5032,0x5033,0x5035,0x5040, /* '倐','倓','倗','倘','倛','倜','倝','倞', '倢','倧','倮','倰','倲','倳','倵','偀', */
	/* 8fb1e0 */ 0x5041,0x5042,0x5045,0x5046,0x504a,0x504c,0x504e,0x5051, 0x5052,0x5053,0x5057,0x5059,0x505f,0x5060,0x5062,0x5063, /* '偁','偂','偅','偆','偊','偌','偎','偑', '偒','偓','偗','偙','偟','偠','偢','偣', */
	/* 8fb1f0 */ 0x5066,0x5067,0x506a,0x506d,0x5070,0x5071,0x503b,0x5081, 0x5083,0x5084,0x5086,0x508a,0x508e,0x508f,0x5090,0, /* '偦','偧','偪','偭','偰','偱','倻','傁', '傃','傄','傆','傊','傎','傏','傐',0, */
	/* 8fb200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb2a0 */ 0,0x5092,0x5093,0x5094,0x5096,0x509b,0x509c,0x509e, 0x509f,0x50a0,0x50a1,0x50a2,0x50aa,0x50af,0x50b0,0x50b9, /* 0,'傒','傓','傔','傖','傛','傜','傞', '傟','傠','傡','傢','傪','傯','傰','傹', */
	/* 8fb2b0 */ 0x50ba,0x50bd,0x50c0,0x50c3,0x50c4,0x50c7,0x50cc,0x50ce, 0x50d0,0x50d3,0x50d4,0x50d8,0x50dc,0x50dd,0x50df,0x50e2, /* '傺','傽','僀','僃','僄','僇','僌','僎', '僐','僓','僔','僘','僜','僝','僟','僢', */
	/* 8fb2c0 */ 0x50e4,0x50e6,0x50e8,0x50e9,0x50ef,0x50f1,0x50f6,0x50fa, 0x50fe,0x5103,0x5106,0x5107,0x5108,0x510b,0x510c,0x510d, /* '僤','僦','僨','僩','僯','僱','僶','僺', '僾','儃','儆','儇','儈','儋','儌','儍', */
	/* 8fb2d0 */ 0x510e,0x50f2,0x5110,0x5117,0x5119,0x511b,0x511c,0x511d, 0x511e,0x5123,0x5127,0x5128,0x512c,0x512d,0x512f,0x5131, /* '儎','僲','儐','儗','儙','儛','儜','儝', '儞','儣','儧','儨','儬','儭','儯','儱', */
	/* 8fb2e0 */ 0x5133,0x5134,0x5135,0x5138,0x5139,0x5142,0x514a,0x514f, 0x5153,0x5155,0x5157,0x5158,0x515f,0x5164,0x5166,0x517e, /* '儳','儴','儵','儸','儹','兂','兊','兏', '兓','兕','兗','兘','兟','兤','兦','兾', */
	/* 8fb2f0 */ 0x5183,0x5184,0x518b,0x518e,0x5198,0x519d,0x51a1,0x51a3, 0x51ad,0x51b8,0x51ba,0x51bc,0x51be,0x51bf,0x51c2,0, /* '冃','冄','冋','冎','冘','冝','冡','冣', '冭','冸','冺','冼','冾','冿','凂',0, */
	/* 8fb300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb3a0 */ 0,0x51c8,0x51cf,0x51d1,0x51d2,0x51d3,0x51d5,0x51d8, 0x51de,0x51e2,0x51e5,0x51ee,0x51f2,0x51f3,0x51f4,0x51f7, /* 0,'凈','减','凑','凒','凓','凕','凘', '凞','凢','凥','凮','凲','凳','凴','凷', */
	/* 8fb3b0 */ 0x5201,0x5202,0x5205,0x5212,0x5213,0x5215,0x5216,0x5218, 0x5222,0x5228,0x5231,0x5232,0x5235,0x523c,0x5245,0x5249, /* '刁','刂','刅','划','刓','刕','刖','刘', '刢','刨','刱','刲','刵','刼','剅','剉', */
	/* 8fb3c0 */ 0x5255,0x5257,0x5258,0x525a,0x525c,0x525f,0x5260,0x5261, 0x5266,0x526e,0x5277,0x5278,0x5279,0x5280,0x5282,0x5285, /* '剕','剗','剘','剚','剜','剟','剠','剡', '剦','剮','剷','剸','剹','劀','劂','劅', */
	/* 8fb3d0 */ 0x528a,0x528c,0x5293,0x5295,0x5296,0x5297,0x5298,0x529a, 0x529c,0x52a4,0x52a5,0x52a6,0x52a7,0x52af,0x52b0,0x52b6, /* '劊','劌','劓','劕','劖','劗','劘','劚', '劜','劤','劥','劦','劧','劯','劰','劶', */
	/* 8fb3e0 */ 0x52b7,0x52b8,0x52ba,0x52bb,0x52bd,0x52c0,0x52c4,0x52c6, 0x52c8,0x52cc,0x52cf,0x52d1,0x52d4,0x52d6,0x52db,0x52dc, /* '劷','劸','劺','劻','劽','勀','勄','勆', '勈','勌','勏','勑','勔','勖','勛','勜', */
	/* 8fb3f0 */ 0x52e1,0x52e5,0x52e8,0x52e9,0x52ea,0x52ec,0x52f0,0x52f1, 0x52f4,0x52f6,0x52f7,0x5300,0x5303,0x530a,0x530b,0, /* '勡','勥','勨','勩','勪','勬','勰','勱', '勴','勶','勷','匀','匃','匊','匋',0, */
	/* 8fb400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb4a0 */ 0,0x530c,0x5311,0x5313,0x5318,0x531b,0x531c,0x531e, 0x531f,0x5325,0x5327,0x5328,0x5329,0x532b,0x532c,0x532d, /* 0,'匌','匑','匓','匘','匛','匜','匞', '匟','匥','匧','匨','匩','匫','匬','匭', */
	/* 8fb4b0 */ 0x5330,0x5332,0x5335,0x533c,0x533d,0x533e,0x5342,0x534c, 0x534b,0x5359,0x535b,0x5361,0x5363,0x5365,0x536c,0x536d, /* '匰','匲','匵','匼','匽','匾','卂','卌', '卋','卙','卛','卡','卣','卥','卬','卭', */
	/* 8fb4c0 */ 0x5372,0x5379,0x537e,0x5383,0x5387,0x5388,0x538e,0x5393, 0x5394,0x5399,0x539d,0x53a1,0x53a4,0x53aa,0x53ab,0x53af, /* '卲','卹','卾','厃','厇','厈','厎','厓', '厔','厙','厝','厡','厤','厪','厫','厯', */
	/* 8fb4d0 */ 0x53b2,0x53b4,0x53b5,0x53b7,0x53b8,0x53ba,0x53bd,0x53c0, 0x53c5,0x53cf,0x53d2,0x53d3,0x53d5,0x53da,0x53dd,0x53de, /* '厲','厴','厵','厷','厸','厺','厽','叀', '叅','叏','叒','叓','叕','叚','叝','叞', */
	/* 8fb4e0 */ 0x53e0,0x53e6,0x53e7,0x53f5,0x5402,0x5413,0x541a,0x5421, 0x5427,0x5428,0x542a,0x542f,0x5431,0x5434,0x5435,0x5443, /* '叠','另','叧','叵','吂','吓','吚','吡', '吧','吨','吪','启','吱','吴','吵','呃', */
	/* 8fb4f0 */ 0x5444,0x5447,0x544d,0x544f,0x545e,0x5462,0x5464,0x5466, 0x5467,0x5469,0x546b,0x546d,0x546e,0x5474,0x547f,0, /* '呄','呇','呍','呏','呞','呢','呤','呦', '呧','呩','呫','呭','呮','呴','呿',0, */
	/* 8fb500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb5a0 */ 0,0x5481,0x5483,0x5485,0x5488,0x5489,0x548d,0x5491, 0x5495,0x5496,0x549c,0x549f,0x54a1,0x54a6,0x54a7,0x54a9, /* 0,'咁','咃','咅','咈','咉','咍','咑', '咕','咖','咜','咟','咡','咦','咧','咩', */
	/* 8fb5b0 */ 0x54aa,0x54ad,0x54ae,0x54b1,0x54b7,0x54b9,0x54ba,0x54bb, 0x54bf,0x54c6,0x54ca,0x54cd,0x54ce,0x54e0,0x54ea,0x54ec, /* '咪','咭','咮','咱','咷','咹','咺','咻', '咿','哆','哊','响','哎','哠','哪','哬', */
	/* 8fb5c0 */ 0x54ef,0x54f6,0x54fc,0x54fe,0x54ff,0x5500,0x5501,0x5505, 0x5508,0x5509,0x550c,0x550d,0x550e,0x5515,0x552a,0x552b, /* '哯','哶','哼','哾','哿','唀','唁','唅', '唈','唉','唌','唍','唎','唕','唪','唫', */
	/* 8fb5d0 */ 0x5532,0x5535,0x5536,0x553b,0x553c,0x553d,0x5541,0x5547, 0x5549,0x554a,0x554d,0x5550,0x5551,0x5558,0x555a,0x555b, /* '唲','唵','唶','唻','唼','唽','啁','啇', '啉','啊','啍','啐','啑','啘','啚','啛', */
	/* 8fb5e0 */ 0x555e,0x5560,0x5561,0x5564,0x5566,0x557f,0x5581,0x5582, 0x5586,0x5588,0x558e,0x558f,0x5591,0x5592,0x5593,0x5594, /* '啞','啠','啡','啤','啦','啿','喁','喂', '喆','喈','喎','喏','喑','喒','喓','喔', */
	/* 8fb5f0 */ 0x5597,0x55a3,0x55a4,0x55ad,0x55b2,0x55bf,0x55c1,0x55c3, 0x55c6,0x55c9,0x55cb,0x55cc,0x55ce,0x55d1,0x55d2,0, /* '喗','喣','喤','喭','喲','喿','嗁','嗃', '嗆','嗉','嗋','嗌','嗎','嗑','嗒',0, */
	/* 8fb600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb6a0 */ 0,0x55d3,0x55d7,0x55d8,0x55db,0x55de,0x55e2,0x55e9, 0x55f6,0x55ff,0x5605,0x5608,0x560a,0x560d,0x560e,0x560f, /* 0,'嗓','嗗','嗘','嗛','嗞','嗢','嗩', '嗶','嗿','嘅','嘈','嘊','嘍','嘎','嘏', */
	/* 8fb6b0 */ 0x5610,0x5611,0x5612,0x5619,0x562c,0x5630,0x5633,0x5635, 0x5637,0x5639,0x563b,0x563c,0x563d,0x563f,0x5640,0x5641, /* '嘐','嘑','嘒','嘙','嘬','嘰','嘳','嘵', '嘷','嘹','嘻','嘼','嘽','嘿','噀','噁', */
	/* 8fb6c0 */ 0x5643,0x5644,0x5646,0x5649,0x564b,0x564d,0x564f,0x5654, 0x565e,0x5660,0x5661,0x5662,0x5663,0x5666,0x5669,0x566d, /* '噃','噄','噆','噉','噋','噍','噏','噔', '噞','噠','噡','噢','噣','噦','噩','噭', */
	/* 8fb6d0 */ 0x566f,0x5671,0x5672,0x5675,0x5684,0x5685,0x5688,0x568b, 0x568c,0x5695,0x5699,0x569a,0x569d,0x569e,0x569f,0x56a6, /* '噯','噱','噲','噵','嚄','嚅','嚈','嚋', '嚌','嚕','嚙','嚚','嚝','嚞','嚟','嚦', */
	/* 8fb6e0 */ 0x56a7,0x56a8,0x56a9,0x56ab,0x56ac,0x56ad,0x56b1,0x56b3, 0x56b7,0x56be,0x56c5,0x56c9,0x56ca,0x56cb,0x56cf,0x56d0, /* '嚧','嚨','嚩','嚫','嚬','嚭','嚱','嚳', '嚷','嚾','囅','囉','囊','囋','囏','囐', */
	/* 8fb6f0 */ 0x56cc,0x56cd,0x56d9,0x56dc,0x56dd,0x56df,0x56e1,0x56e4, 0x56e5,0x56e6,0x56e7,0x56e8,0x56f1,0x56eb,0x56ed,0, /* '囌','囍','囙','囜','囝','囟','囡','囤', '囥','囦','囧','囨','囱','囫','园',0, */
	/* 8fb700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb7a0 */ 0,0x56f6,0x56f7,0x5701,0x5702,0x5707,0x570a,0x570c, 0x5711,0x5715,0x571a,0x571b,0x571d,0x5720,0x5722,0x5723, /* 0,'囶','囷','圁','圂','圇','圊','圌', '圑','圕','圚','圛','圝','圠','圢','圣', */
	/* 8fb7b0 */ 0x5724,0x5725,0x5729,0x572a,0x572c,0x572e,0x572f,0x5733, 0x5734,0x573d,0x573e,0x573f,0x5745,0x5746,0x574c,0x574d, /* '圤','圥','圩','圪','圬','圮','圯','圳', '圴','圽','圾','圿','坅','坆','坌','坍', */
	/* 8fb7c0 */ 0x5752,0x5762,0x5765,0x5767,0x5768,0x576b,0x576d,0x576e, 0x576f,0x5770,0x5771,0x5773,0x5774,0x5775,0x5777,0x5779, /* '坒','坢','坥','坧','坨','坫','坭','坮', '坯','坰','坱','坳','坴','坵','坷','坹', */
	/* 8fb7d0 */ 0x577a,0x577b,0x577c,0x577e,0x5781,0x5783,0x578c,0x5794, 0x5797,0x5799,0x579a,0x579c,0x579d,0x579e,0x579f,0x57a1, /* '坺','坻','坼','坾','垁','垃','垌','垔', '垗','垙','垚','垜','垝','垞','垟','垡', */
	/* 8fb7e0 */ 0x5795,0x57a7,0x57a8,0x57a9,0x57ac,0x57b8,0x57bd,0x57c7, 0x57c8,0x57cc,0x57cf,0x57d5,0x57dd,0x57de,0x57e4,0x57e6, /* '垕','垧','垨','垩','垬','垸','垽','埇', '埈','埌','埏','埕','埝','埞','埤','埦', */
	/* 8fb7f0 */ 0x57e7,0x57e9,0x57ed,0x57f0,0x57f5,0x57f6,0x57f8,0x57fd, 0x57fe,0x57ff,0x5803,0x5804,0x5808,0x5809,0x57e1,0, /* '埧','埩','埭','埰','埵','埶','埸','埽', '埾','埿','堃','堄','堈','堉','埡',0, */
	/* 8fb800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb8a0 */ 0,0x580c,0x580d,0x581b,0x581e,0x581f,0x5820,0x5826, 0x5827,0x582d,0x5832,0x5839,0x583f,0x5849,0x584c,0x584d, /* 0,'堌','堍','堛','堞','堟','堠','堦', '堧','堭','堲','堹','堿','塉','塌','塍', */
	/* 8fb8b0 */ 0x584f,0x5850,0x5855,0x585f,0x5861,0x5864,0x5867,0x5868, 0x5878,0x587c,0x587f,0x5880,0x5881,0x5887,0x5888,0x5889, /* '塏','塐','塕','塟','塡','塤','塧','塨', '塸','塼','塿','墀','墁','墇','墈','墉', */
	/* 8fb8c0 */ 0x588a,0x588c,0x588d,0x588f,0x5890,0x5894,0x5896,0x589d, 0x58a0,0x58a1,0x58a2,0x58a6,0x58a9,0x58b1,0x58b2,0x58c4, /* '墊','墌','墍','墏','墐','墔','墖','墝', '墠','墡','墢','墦','墩','墱','墲','壄', */
	/* 8fb8d0 */ 0x58bc,0x58c2,0x58c8,0x58cd,0x58ce,0x58d0,0x58d2,0x58d4, 0x58d6,0x58da,0x58dd,0x58e1,0x58e2,0x58e9,0x58f3,0x5905, /* '墼','壂','壈','壍','壎','壐','壒','壔', '壖','壚','壝','壡','壢','壩','壳','夅', */
	/* 8fb8e0 */ 0x5906,0x590b,0x590c,0x5912,0x5913,0x5914,0x8641,0x591d, 0x5921,0x5923,0x5924,0x5928,0x592f,0x5930,0x5933,0x5935, /* '夆','夋','夌','夒','夓','夔','虁','夝', '夡','夣','夤','夨','夯','夰','夳','夵', */
	/* 8fb8f0 */ 0x5936,0x593f,0x5943,0x5946,0x5952,0x5953,0x5959,0x595b, 0x595d,0x595e,0x595f,0x5961,0x5963,0x596b,0x596d,0, /* '夶','夿','奃','奆','奒','奓','奙','奛', '奝','奞','奟','奡','奣','奫','奭',0, */
	/* 8fb900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fb9a0 */ 0,0x596f,0x5972,0x5975,0x5976,0x5979,0x597b,0x597c, 0x598b,0x598c,0x598e,0x5992,0x5995,0x5997,0x599f,0x59a4, /* 0,'奯','奲','奵','奶','她','奻','奼', '妋','妌','妎','妒','妕','妗','妟','妤', */
	/* 8fb9b0 */ 0x59a7,0x59ad,0x59ae,0x59af,0x59b0,0x59b3,0x59b7,0x59ba, 0x59bc,0x59c1,0x59c3,0x59c4,0x59c8,0x59ca,0x59cd,0x59d2, /* '妧','妭','妮','妯','妰','妳','妷','妺', '妼','姁','姃','姄','姈','姊','姍','姒', */
	/* 8fb9c0 */ 0x59dd,0x59de,0x59df,0x59e3,0x59e4,0x59e7,0x59ee,0x59ef, 0x59f1,0x59f2,0x59f4,0x59f7,0x5a00,0x5a04,0x5a0c,0x5a0d, /* '姝','姞','姟','姣','姤','姧','姮','姯', '姱','姲','姴','姷','娀','娄','娌','娍', */
	/* 8fb9d0 */ 0x5a0e,0x5a12,0x5a13,0x5a1e,0x5a23,0x5a24,0x5a27,0x5a28, 0x5a2a,0x5a2d,0x5a30,0x5a44,0x5a45,0x5a47,0x5a48,0x5a4c, /* '娎','娒','娓','娞','娣','娤','娧','娨', '娪','娭','娰','婄','婅','婇','婈','婌', */
	/* 8fb9e0 */ 0x5a50,0x5a55,0x5a5e,0x5a63,0x5a65,0x5a67,0x5a6d,0x5a77, 0x5a7a,0x5a7b,0x5a7e,0x5a8b,0x5a90,0x5a93,0x5a96,0x5a99, /* '婐','婕','婞','婣','婥','婧','婭','婷', '婺','婻','婾','媋','媐','媓','媖','媙', */
	/* 8fb9f0 */ 0x5a9c,0x5a9e,0x5a9f,0x5aa0,0x5aa2,0x5aa7,0x5aac,0x5ab1, 0x5ab2,0x5ab3,0x5ab5,0x5ab8,0x5aba,0x5abb,0x5abf,0, /* '媜','媞','媟','媠','媢','媧','媬','媱', '媲','媳','媵','媸','媺','媻','媿',0, */
	/* 8fba00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fba90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbaa0 */ 0,0x5ac4,0x5ac6,0x5ac8,0x5acf,0x5ada,0x5adc,0x5ae0, 0x5ae5,0x5aea,0x5aee,0x5af5,0x5af6,0x5afd,0x5b00,0x5b01, /* 0,'嫄','嫆','嫈','嫏','嫚','嫜','嫠', '嫥','嫪','嫮','嫵','嫶','嫽','嬀','嬁', */
	/* 8fbab0 */ 0x5b08,0x5b17,0x5b34,0x5b19,0x5b1b,0x5b1d,0x5b21,0x5b25, 0x5b2d,0x5b38,0x5b41,0x5b4b,0x5b4c,0x5b52,0x5b56,0x5b5e, /* '嬈','嬗','嬴','嬙','嬛','嬝','嬡','嬥', '嬭','嬸','孁','孋','孌','孒','孖','孞', */
	/* 8fbac0 */ 0x5b68,0x5b6e,0x5b6f,0x5b7c,0x5b7d,0x5b7e,0x5b7f,0x5b81, 0x5b84,0x5b86,0x5b8a,0x5b8e,0x5b90,0x5b91,0x5b93,0x5b94, /* '孨','孮','孯','孼','孽','孾','孿','宁', '宄','宆','宊','宎','宐','宑','宓','宔', */
	/* 8fbad0 */ 0x5b96,0x5ba8,0x5ba9,0x5bac,0x5bad,0x5baf,0x5bb1,0x5bb2, 0x5bb7,0x5bba,0x5bbc,0x5bc0,0x5bc1,0x5bcd,0x5bcf,0x5bd6, /* '宖','宨','宩','宬','宭','宯','宱','宲', '宷','宺','宼','寀','寁','寍','寏','寖', */
	/* 8fbae0 */ 0x5bd7,0x5bd8,0x5bd9,0x5bda,0x5be0,0x5bef,0x5bf1,0x5bf4, 0x5bfd,0x5c0c,0x5c17,0x5c1e,0x5c1f,0x5c23,0x5c26,0x5c29, /* '寗','寘','寙','寚','寠','寯','寱','寴', '寽','尌','尗','尞','尟','尣','尦','尩', */
	/* 8fbaf0 */ 0x5c2b,0x5c2c,0x5c2e,0x5c30,0x5c32,0x5c35,0x5c36,0x5c59, 0x5c5a,0x5c5c,0x5c62,0x5c63,0x5c67,0x5c68,0x5c69,0, /* '尫','尬','尮','尰','尲','尵','尶','屙', '屚','屜','屢','屣','屧','屨','屩',0, */
	/* 8fbb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbba0 */ 0,0x5c6d,0x5c70,0x5c74,0x5c75,0x5c7a,0x5c7b,0x5c7c, 0x5c7d,0x5c87,0x5c88,0x5c8a,0x5c8f,0x5c92,0x5c9d,0x5c9f, /* 0,'屭','屰','屴','屵','屺','屻','屼', '屽','岇','岈','岊','岏','岒','岝','岟', */
	/* 8fbbb0 */ 0x5ca0,0x5ca2,0x5ca3,0x5ca6,0x5caa,0x5cb2,0x5cb4,0x5cb5, 0x5cba,0x5cc9,0x5ccb,0x5cd2,0x5cdd,0x5cd7,0x5cee,0x5cf1, /* '岠','岢','岣','岦','岪','岲','岴','岵', '岺','峉','峋','峒','峝','峗','峮','峱', */
	/* 8fbbc0 */ 0x5cf2,0x5cf4,0x5d01,0x5d06,0x5d0d,0x5d12,0x5d2b,0x5d23, 0x5d24,0x5d26,0x5d27,0x5d31,0x5d34,0x5d39,0x5d3d,0x5d3f, /* '峲','峴','崁','崆','崍','崒','崫','崣', '崤','崦','崧','崱','崴','崹','崽','崿', */
	/* 8fbbd0 */ 0x5d42,0x5d43,0x5d46,0x5d48,0x5d55,0x5d51,0x5d59,0x5d4a, 0x5d5f,0x5d60,0x5d61,0x5d62,0x5d64,0x5d6a,0x5d6d,0x5d70, /* '嵂','嵃','嵆','嵈','嵕','嵑','嵙','嵊', '嵟','嵠','嵡','嵢','嵤','嵪','嵭','嵰', */
	/* 8fbbe0 */ 0x5d79,0x5d7a,0x5d7e,0x5d7f,0x5d81,0x5d83,0x5d88,0x5d8a, 0x5d92,0x5d93,0x5d94,0x5d95,0x5d99,0x5d9b,0x5d9f,0x5da0, /* '嵹','嵺','嵾','嵿','嶁','嶃','嶈','嶊', '嶒','嶓','嶔','嶕','嶙','嶛','嶟','嶠', */
	/* 8fbbf0 */ 0x5da7,0x5dab,0x5db0,0x5db4,0x5db8,0x5db9,0x5dc3,0x5dc7, 0x5dcb,0x5dd0,0x5dce,0x5dd8,0x5dd9,0x5de0,0x5de4,0, /* '嶧','嶫','嶰','嶴','嶸','嶹','巃','巇', '巋','巐','巎','巘','巙','巠','巤',0, */
	/* 8fbc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbca0 */ 0,0x5de9,0x5df8,0x5df9,0x5e00,0x5e07,0x5e0d,0x5e12, 0x5e14,0x5e15,0x5e18,0x5e1f,0x5e20,0x5e2e,0x5e28,0x5e32, /* 0,'巩','巸','巹','帀','帇','帍','帒', '帔','帕','帘','帟','帠','帮','帨','帲', */
	/* 8fbcb0 */ 0x5e35,0x5e3e,0x5e4b,0x5e50,0x5e49,0x5e51,0x5e56,0x5e58, 0x5e5b,0x5e5c,0x5e5e,0x5e68,0x5e6a,0x5e6b,0x5e6c,0x5e6d, /* '帵','帾','幋','幐','幉','幑','幖','幘', '幛','幜','幞','幨','幪','幫','幬','幭', */
	/* 8fbcc0 */ 0x5e6e,0x5e70,0x5e80,0x5e8b,0x5e8e,0x5ea2,0x5ea4,0x5ea5, 0x5ea8,0x5eaa,0x5eac,0x5eb1,0x5eb3,0x5ebd,0x5ebe,0x5ebf, /* '幮','幰','庀','庋','庎','庢','庤','庥', '庨','庪','庬','庱','庳','庽','庾','庿', */
	/* 8fbcd0 */ 0x5ec6,0x5ecc,0x5ecb,0x5ece,0x5ed1,0x5ed2,0x5ed4,0x5ed5, 0x5edc,0x5ede,0x5ee5,0x5eeb,0x5f02,0x5f06,0x5f07,0x5f08, /* '廆','廌','廋','廎','廑','廒','廔','廕', '廜','廞','廥','廫','异','弆','弇','弈', */
	/* 8fbce0 */ 0x5f0e,0x5f19,0x5f1c,0x5f1d,0x5f21,0x5f22,0x5f23,0x5f24, 0x5f28,0x5f2b,0x5f2c,0x5f2e,0x5f30,0x5f34,0x5f36,0x5f3b, /* '弎','弙','弜','弝','弡','弢','弣','弤', '弨','弫','弬','弮','弰','弴','弶','弻', */
	/* 8fbcf0 */ 0x5f3d,0x5f3f,0x5f40,0x5f44,0x5f45,0x5f47,0x5f4d,0x5f50, 0x5f54,0x5f58,0x5f5b,0x5f60,0x5f63,0x5f64,0x5f67,0, /* '弽','弿','彀','彄','彅','彇','彍','彐', '彔','彘','彛','彠','彣','彤','彧',0, */
	/* 8fbd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbda0 */ 0,0x5f6f,0x5f72,0x5f74,0x5f75,0x5f78,0x5f7a,0x5f7d, 0x5f7e,0x5f89,0x5f8d,0x5f8f,0x5f96,0x5f9c,0x5f9d,0x5fa2, /* 0,'彯','彲','彴','彵','彸','彺','彽', '彾','徉','徍','徏','徖','徜','徝','徢', */
	/* 8fbdb0 */ 0x5fa7,0x5fab,0x5fa4,0x5fac,0x5faf,0x5fb0,0x5fb1,0x5fb8, 0x5fc4,0x5fc7,0x5fc8,0x5fc9,0x5fcb,0x5fd0,0x5fd1,0x5fd2, /* '徧','徫','徤','徬','徯','徰','徱','徸', '忄','忇','忈','忉','忋','忐','忑','忒', */
	/* 8fbdc0 */ 0x5fd3,0x5fd4,0x5fde,0x5fe1,0x5fe2,0x5fe8,0x5fe9,0x5fea, 0x5fec,0x5fed,0x5fee,0x5fef,0x5ff2,0x5ff3,0x5ff6,0x5ffa, /* '忓','忔','忞','忡','忢','忨','忩','忪', '忬','忭','忮','忯','忲','忳','忶','忺', */
	/* 8fbdd0 */ 0x5ffc,0x6007,0x600a,0x600d,0x6013,0x6014,0x6017,0x6018, 0x601a,0x601f,0x6024,0x602d,0x6033,0x6035,0x6040,0x6047, /* '忼','怇','怊','怍','怓','怔','怗','怘', '怚','怟','怤','怭','怳','怵','恀','恇', */
	/* 8fbde0 */ 0x6048,0x6049,0x604c,0x6051,0x6054,0x6056,0x6057,0x605d, 0x6061,0x6067,0x6071,0x607e,0x607f,0x6082,0x6086,0x6088, /* '恈','恉','恌','恑','恔','恖','恗','恝', '恡','恧','恱','恾','恿','悂','悆','悈', */
	/* 8fbdf0 */ 0x608a,0x608e,0x6091,0x6093,0x6095,0x6098,0x609d,0x609e, 0x60a2,0x60a4,0x60a5,0x60a8,0x60b0,0x60b1,0x60b7,0, /* '悊','悎','悑','悓','悕','悘','悝','悞', '悢','悤','悥','您','悰','悱','悷',0, */
	/* 8fbe00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbe90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbea0 */ 0,0x60bb,0x60be,0x60c2,0x60c4,0x60c8,0x60c9,0x60ca, 0x60cb,0x60ce,0x60cf,0x60d4,0x60d5,0x60d9,0x60db,0x60dd, /* 0,'悻','悾','惂','惄','惈','惉','惊', '惋','惎','惏','惔','惕','惙','惛','惝', */
	/* 8fbeb0 */ 0x60de,0x60e2,0x60e5,0x60f2,0x60f5,0x60f8,0x60fc,0x60fd, 0x6102,0x6107,0x610a,0x610c,0x6110,0x6111,0x6112,0x6113, /* '惞','惢','惥','惲','惵','惸','惼','惽', '愂','愇','愊','愌','愐','愑','愒','愓', */
	/* 8fbec0 */ 0x6114,0x6116,0x6117,0x6119,0x611c,0x611e,0x6122,0x612a, 0x612b,0x6130,0x6131,0x6135,0x6136,0x6137,0x6139,0x6141, /* '愔','愖','愗','愙','愜','愞','愢','愪', '愫','愰','愱','愵','愶','愷','愹','慁', */
	/* 8fbed0 */ 0x6145,0x6146,0x6149,0x615e,0x6160,0x616c,0x6172,0x6178, 0x617b,0x617c,0x617f,0x6180,0x6181,0x6183,0x6184,0x618b, /* '慅','慆','慉','慞','慠','慬','慲','慸', '慻','慼','慿','憀','憁','憃','憄','憋', */
	/* 8fbee0 */ 0x618d,0x6192,0x6193,0x6197,0x6198,0x619c,0x619d,0x619f, 0x61a0,0x61a5,0x61a8,0x61aa,0x61ad,0x61b8,0x61b9,0x61bc, /* '憍','憒','憓','憗','憘','憜','憝','憟', '憠','憥','憨','憪','憭','憸','憹','憼', */
	/* 8fbef0 */ 0x61c0,0x61c1,0x61c2,0x61ce,0x61cf,0x61d5,0x61dc,0x61dd, 0x61de,0x61df,0x61e1,0x61e2,0x61e7,0x61e9,0x61e5,0, /* '懀','懁','懂','懎','懏','懕','懜','懝', '懞','懟','懡','懢','懧','懩','懥',0, */
	/* 8fbf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fbfa0 */ 0,0x61ec,0x61ed,0x61ef,0x6201,0x6203,0x6204,0x6207, 0x6213,0x6215,0x621c,0x6220,0x6222,0x6223,0x6227,0x6229, /* 0,'懬','懭','懯','戁','戃','戄','戇', '戓','戕','戜','戠','戢','戣','戧','戩', */
	/* 8fbfb0 */ 0x622b,0x6239,0x623d,0x6242,0x6243,0x6244,0x6246,0x624c, 0x6250,0x6251,0x6252,0x6254,0x6256,0x625a,0x625c,0x6264, /* '戫','戹','戽','扂','扃','扄','扆','扌', '扐','扑','扒','扔','扖','扚','扜','扤', */
	/* 8fbfc0 */ 0x626d,0x626f,0x6273,0x627a,0x627d,0x628d,0x628e,0x628f, 0x6290,0x62a6,0x62a8,0x62b3,0x62b6,0x62b7,0x62ba,0x62be, /* '扭','扯','扳','扺','扽','抍','抎','抏', '抐','抦','抨','抳','抶','抷','抺','抾', */
	/* 8fbfd0 */ 0x62bf,0x62c4,0x62ce,0x62d5,0x62d6,0x62da,0x62ea,0x62f2, 0x62f4,0x62fc,0x62fd,0x6303,0x6304,0x630a,0x630b,0x630d, /* '抿','拄','拎','拕','拖','拚','拪','拲', '拴','拼','拽','挃','挄','挊','挋','挍', */
	/* 8fbfe0 */ 0x6310,0x6313,0x6316,0x6318,0x6329,0x632a,0x632d,0x6335, 0x6336,0x6339,0x633c,0x6341,0x6342,0x6343,0x6344,0x6346, /* '挐','挓','挖','挘','挩','挪','挭','挵', '挶','挹','挼','捁','捂','捃','捄','捆', */
	/* 8fbff0 */ 0x634a,0x634b,0x634e,0x6352,0x6353,0x6354,0x6358,0x635b, 0x6365,0x6366,0x636c,0x636d,0x6371,0x6374,0x6375,0, /* '捊','捋','捎','捒','捓','捔','捘','捛', '捥','捦','捬','捭','捱','捴','捵',0, */
	/* 8fc000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc0a0 */ 0,0x6378,0x637c,0x637d,0x637f,0x6382,0x6384,0x6387, 0x638a,0x6390,0x6394,0x6395,0x6399,0x639a,0x639e,0x63a4, /* 0,'捸','捼','捽','捿','掂','掄','掇', '掊','掐','掔','掕','掙','掚','掞','掤', */
	/* 8fc0b0 */ 0x63a6,0x63ad,0x63ae,0x63af,0x63bd,0x63c1,0x63c5,0x63c8, 0x63ce,0x63d1,0x63d3,0x63d4,0x63d5,0x63dc,0x63e0,0x63e5, /* '掦','掭','掮','掯','掽','揁','揅','揈', '揎','揑','揓','揔','揕','揜','揠','揥', */
	/* 8fc0c0 */ 0x63ea,0x63ec,0x63f2,0x63f3,0x63f5,0x63f8,0x63f9,0x6409, 0x640a,0x6410,0x6412,0x6414,0x6418,0x641e,0x6420,0x6422, /* '揪','揬','揲','揳','揵','揸','揹','搉', '搊','搐','搒','搔','搘','搞','搠','搢', */
	/* 8fc0d0 */ 0x6424,0x6425,0x6429,0x642a,0x642f,0x6430,0x6435,0x643d, 0x643f,0x644b,0x644f,0x6451,0x6452,0x6453,0x6454,0x645a, /* '搤','搥','搩','搪','搯','搰','搵','搽', '搿','摋','摏','摑','摒','摓','摔','摚', */
	/* 8fc0e0 */ 0x645b,0x645c,0x645d,0x645f,0x6460,0x6461,0x6463,0x646d, 0x6473,0x6474,0x647b,0x647d,0x6485,0x6487,0x648f,0x6490, /* '摛','摜','摝','摟','摠','摡','摣','摭', '摳','摴','摻','摽','撅','撇','撏','撐', */
	/* 8fc0f0 */ 0x6491,0x6498,0x6499,0x649b,0x649d,0x649f,0x64a1,0x64a3, 0x64a6,0x64a8,0x64ac,0x64b3,0x64bd,0x64be,0x64bf,0, /* '撑','撘','撙','撛','撝','撟','撡','撣', '撦','撨','撬','撳','撽','撾','撿',0, */
	/* 8fc100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc1a0 */ 0,0x64c4,0x64c9,0x64ca,0x64cb,0x64cc,0x64ce,0x64d0, 0x64d1,0x64d5,0x64d7,0x64e4,0x64e5,0x64e9,0x64ea,0x64ed, /* 0,'擄','擉','擊','擋','擌','擎','擐', '擑','擕','擗','擤','擥','擩','擪','擭', */
	/* 8fc1b0 */ 0x64f0,0x64f5,0x64f7,0x64fb,0x64ff,0x6501,0x6504,0x6508, 0x6509,0x650a,0x650f,0x6513,0x6514,0x6516,0x6519,0x651b, /* '擰','擵','擷','擻','擿','攁','攄','攈', '攉','攊','攏','攓','攔','攖','攙','攛', */
	/* 8fc1c0 */ 0x651e,0x651f,0x6522,0x6526,0x6529,0x652e,0x6531,0x653a, 0x653c,0x653d,0x6543,0x6547,0x6549,0x6550,0x6552,0x6554, /* '攞','攟','攢','攦','攩','攮','攱','攺', '攼','攽','敃','敇','敉','敐','敒','敔', */
	/* 8fc1d0 */ 0x655f,0x6560,0x6567,0x656b,0x657a,0x657d,0x6581,0x6585, 0x658a,0x6592,0x6595,0x6598,0x659d,0x65a0,0x65a3,0x65a6, /* '敟','敠','敧','敫','敺','敽','斁','斅', '斊','斒','斕','斘','斝','斠','斣','斦', */
	/* 8fc1e0 */ 0x65ae,0x65b2,0x65b3,0x65b4,0x65bf,0x65c2,0x65c8,0x65c9, 0x65ce,0x65d0,0x65d4,0x65d6,0x65d8,0x65df,0x65f0,0x65f2, /* '斮','斲','斳','斴','斿','旂','旈','旉', '旎','旐','旔','旖','旘','旟','旰','旲', */
	/* 8fc1f0 */ 0x65f4,0x65f5,0x65f9,0x65fe,0x65ff,0x6600,0x6604,0x6608, 0x6609,0x660d,0x6611,0x6612,0x6615,0x6616,0x661d,0, /* '旴','旵','旹','旾','旿','昀','昄','昈', '昉','昍','昑','昒','昕','昖','昝',0, */
	/* 8fc200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc2a0 */ 0,0x661e,0x6621,0x6622,0x6623,0x6624,0x6626,0x6629, 0x662a,0x662b,0x662c,0x662e,0x6630,0x6631,0x6633,0x6639, /* 0,'昞','昡','昢','昣','昤','昦','昩', '昪','昫','昬','昮','昰','昱','昳','昹', */
	/* 8fc2b0 */ 0x6637,0x6640,0x6645,0x6646,0x664a,0x664c,0x6651,0x664e, 0x6657,0x6658,0x6659,0x665b,0x665c,0x6660,0x6661,0x66fb, /* '昷','晀','晅','晆','晊','晌','晑','晎', '晗','晘','晙','晛','晜','晠','晡','曻', */
	/* 8fc2c0 */ 0x666a,0x666b,0x666c,0x667e,0x6673,0x6675,0x667f,0x6677, 0x6678,0x6679,0x667b,0x6680,0x667c,0x668b,0x668c,0x668d, /* '晪','晫','晬','晾','晳','晵','晿','晷', '晸','晹','晻','暀','晼','暋','暌','暍', */
	/* 8fc2d0 */ 0x6690,0x6692,0x6699,0x669a,0x669b,0x669c,0x669f,0x66a0, 0x66a4,0x66ad,0x66b1,0x66b2,0x66b5,0x66bb,0x66bf,0x66c0, /* '暐','暒','暙','暚','暛','暜','暟','暠', '暤','暭','暱','暲','暵','暻','暿','曀', */
	/* 8fc2e0 */ 0x66c2,0x66c3,0x66c8,0x66cc,0x66ce,0x66cf,0x66d4,0x66db, 0x66df,0x66e8,0x66eb,0x66ec,0x66ee,0x66fa,0x6705,0x6707, /* '曂','曃','曈','曌','曎','曏','曔','曛', '曟','曨','曫','曬','曮','曺','朅','朇', */
	/* 8fc2f0 */ 0x670e,0x6713,0x6719,0x671c,0x6720,0x6722,0x6733,0x673e, 0x6745,0x6747,0x6748,0x674c,0x6754,0x6755,0x675d,0, /* '朎','朓','朙','朜','朠','朢','朳','朾', '杅','杇','杈','杌','杔','杕','杝',0, */
	/* 8fc300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc3a0 */ 0,0x6766,0x676c,0x676e,0x6774,0x6776,0x677b,0x6781, 0x6784,0x678e,0x678f,0x6791,0x6793,0x6796,0x6798,0x6799, /* 0,'杦','杬','杮','杴','杶','杻','极', '构','枎','枏','枑','枓','枖','枘','枙', */
	/* 8fc3b0 */ 0x679b,0x67b0,0x67b1,0x67b2,0x67b5,0x67bb,0x67bc,0x67bd, 0x67f9,0x67c0,0x67c2,0x67c3,0x67c5,0x67c8,0x67c9,0x67d2, /* '枛','枰','枱','枲','枵','枻','枼','枽', '柹','柀','柂','柃','柅','柈','柉','柒', */
	/* 8fc3c0 */ 0x67d7,0x67d9,0x67dc,0x67e1,0x67e6,0x67f0,0x67f2,0x67f6, 0x67f7,0x6852,0x6814,0x6819,0x681d,0x681f,0x6828,0x6827, /* '柗','柙','柜','柡','柦','柰','柲','柶', '柷','桒','栔','栙','栝','栟','栨','栧', */
	/* 8fc3d0 */ 0x682c,0x682d,0x682f,0x6830,0x6831,0x6833,0x683b,0x683f, 0x6844,0x6845,0x684a,0x684c,0x6855,0x6857,0x6858,0x685b, /* '栬','栭','栯','栰','栱','栳','栻','栿', '桄','桅','桊','桌','桕','桗','桘','桛', */
	/* 8fc3e0 */ 0x686b,0x686e,0x686f,0x6870,0x6871,0x6872,0x6875,0x6879, 0x687a,0x687b,0x687c,0x6882,0x6884,0x6886,0x6888,0x6896, /* '桫','桮','桯','桰','桱','桲','桵','桹', '桺','桻','桼','梂','梄','梆','梈','梖', */
	/* 8fc3f0 */ 0x6898,0x689a,0x689c,0x68a1,0x68a3,0x68a5,0x68a9,0x68aa, 0x68ae,0x68b2,0x68bb,0x68c5,0x68c8,0x68cc,0x68cf,0, /* '梘','梚','梜','梡','梣','梥','梩','梪', '梮','梲','梻','棅','棈','棌','棏',0, */
	/* 8fc400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc4a0 */ 0,0x68d0,0x68d1,0x68d3,0x68d6,0x68d9,0x68dc,0x68dd, 0x68e5,0x68e8,0x68ea,0x68eb,0x68ec,0x68ed,0x68f0,0x68f1, /* 0,'棐','棑','棓','棖','棙','棜','棝', '棥','棨','棪','棫','棬','棭','棰','棱', */
	/* 8fc4b0 */ 0x68f5,0x68f6,0x68fb,0x68fc,0x68fd,0x6906,0x6909,0x690a, 0x6910,0x6911,0x6913,0x6916,0x6917,0x6931,0x6933,0x6935, /* '棵','棶','棻','棼','棽','椆','椉','椊', '椐','椑','椓','椖','椗','椱','椳','椵', */
	/* 8fc4c0 */ 0x6938,0x693b,0x6942,0x6945,0x6949,0x694e,0x6957,0x695b, 0x6963,0x6964,0x6965,0x6966,0x6968,0x6969,0x696c,0x6970, /* '椸','椻','楂','楅','楉','楎','楗','楛', '楣','楤','楥','楦','楨','楩','楬','楰', */
	/* 8fc4d0 */ 0x6971,0x6972,0x697a,0x697b,0x697f,0x6980,0x698d,0x6992, 0x6996,0x6998,0x69a1,0x69a5,0x69a6,0x69a8,0x69ab,0x69ad, /* '楱','楲','楺','楻','楿','榀','榍','榒', '榖','榘','榡','榥','榦','榨','榫','榭', */
	/* 8fc4e0 */ 0x69af,0x69b7,0x69b8,0x69ba,0x69bc,0x69c5,0x69c8,0x69d1, 0x69d6,0x69d7,0x69e2,0x69e5,0x69ee,0x69ef,0x69f1,0x69f3, /* '榯','榷','榸','榺','榼','槅','槈','槑', '槖','槗','槢','槥','槮','槯','槱','槳', */
	/* 8fc4f0 */ 0x69f5,0x69fe,0x6a00,0x6a01,0x6a03,0x6a0f,0x6a11,0x6a15, 0x6a1a,0x6a1d,0x6a20,0x6a24,0x6a28,0x6a30,0x6a32,0, /* '槵','槾','樀','樁','樃','樏','樑','樕', '樚','樝','樠','樤','樨','樰','樲',0, */
	/* 8fc500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc5a0 */ 0,0x6a34,0x6a37,0x6a3b,0x6a3e,0x6a3f,0x6a45,0x6a46, 0x6a49,0x6a4a,0x6a4e,0x6a50,0x6a51,0x6a52,0x6a55,0x6a56, /* 0,'樴','樷','樻','樾','樿','橅','橆', '橉','橊','橎','橐','橑','橒','橕','橖', */
	/* 8fc5b0 */ 0x6a5b,0x6a64,0x6a67,0x6a6a,0x6a71,0x6a73,0x6a7e,0x6a81, 0x6a83,0x6a86,0x6a87,0x6a89,0x6a8b,0x6a91,0x6a9b,0x6a9d, /* '橛','橤','橧','橪','橱','橳','橾','檁', '檃','檆','檇','檉','檋','檑','檛','檝', */
	/* 8fc5c0 */ 0x6a9e,0x6a9f,0x6aa5,0x6aab,0x6aaf,0x6ab0,0x6ab1,0x6ab4, 0x6abd,0x6abe,0x6abf,0x6ac6,0x6ac9,0x6ac8,0x6acc,0x6ad0, /* '檞','檟','檥','檫','檯','檰','檱','檴', '檽','檾','檿','櫆','櫉','櫈','櫌','櫐', */
	/* 8fc5d0 */ 0x6ad4,0x6ad5,0x6ad6,0x6adc,0x6add,0x6ae4,0x6ae7,0x6aec, 0x6af0,0x6af1,0x6af2,0x6afc,0x6afd,0x6b02,0x6b03,0x6b06, /* '櫔','櫕','櫖','櫜','櫝','櫤','櫧','櫬', '櫰','櫱','櫲','櫼','櫽','欂','欃','欆', */
	/* 8fc5e0 */ 0x6b07,0x6b09,0x6b0f,0x6b10,0x6b11,0x6b17,0x6b1b,0x6b1e, 0x6b24,0x6b28,0x6b2b,0x6b2c,0x6b2f,0x6b35,0x6b36,0x6b3b, /* '欇','欉','欏','欐','欑','欗','欛','欞', '欤','欨','欫','欬','欯','欵','欶','欻', */
	/* 8fc5f0 */ 0x6b3f,0x6b46,0x6b4a,0x6b4d,0x6b52,0x6b56,0x6b58,0x6b5d, 0x6b60,0x6b67,0x6b6b,0x6b6e,0x6b70,0x6b75,0x6b7d,0, /* '欿','歆','歊','歍','歒','歖','歘','歝', '歠','歧','歫','歮','歰','歵','歽',0, */
	/* 8fc600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc6a0 */ 0,0x6b7e,0x6b82,0x6b85,0x6b97,0x6b9b,0x6b9f,0x6ba0, 0x6ba2,0x6ba3,0x6ba8,0x6ba9,0x6bac,0x6bad,0x6bae,0x6bb0, /* 0,'歾','殂','殅','殗','殛','殟','殠', '殢','殣','殨','殩','殬','殭','殮','殰', */
	/* 8fc6b0 */ 0x6bb8,0x6bb9,0x6bbd,0x6bbe,0x6bc3,0x6bc4,0x6bc9,0x6bcc, 0x6bd6,0x6bda,0x6be1,0x6be3,0x6be6,0x6be7,0x6bee,0x6bf1, /* '殸','殹','殽','殾','毃','毄','毉','毌', '毖','毚','毡','毣','毦','毧','毮','毱', */
	/* 8fc6c0 */ 0x6bf7,0x6bf9,0x6bff,0x6c02,0x6c04,0x6c05,0x6c09,0x6c0d, 0x6c0e,0x6c10,0x6c12,0x6c19,0x6c1f,0x6c26,0x6c27,0x6c28, /* '毷','毹','毿','氂','氄','氅','氉','氍', '氎','氐','氒','氙','氟','氦','氧','氨', */
	/* 8fc6d0 */ 0x6c2c,0x6c2e,0x6c33,0x6c35,0x6c36,0x6c3a,0x6c3b,0x6c3f, 0x6c4a,0x6c4b,0x6c4d,0x6c4f,0x6c52,0x6c54,0x6c59,0x6c5b, /* '氬','氮','氳','氵','氶','氺','氻','氿', '汊','汋','汍','汏','汒','汔','汙','汛', */
	/* 8fc6e0 */ 0x6c5c,0x6c6b,0x6c6d,0x6c6f,0x6c74,0x6c76,0x6c78,0x6c79, 0x6c7b,0x6c85,0x6c86,0x6c87,0x6c89,0x6c94,0x6c95,0x6c97, /* '汜','汫','汭','汯','汴','汶','汸','汹', '汻','沅','沆','沇','沉','沔','沕','沗', */
	/* 8fc6f0 */ 0x6c98,0x6c9c,0x6c9f,0x6cb0,0x6cb2,0x6cb4,0x6cc2,0x6cc6, 0x6ccd,0x6ccf,0x6cd0,0x6cd1,0x6cd2,0x6cd4,0x6cd6,0, /* '沘','沜','沟','沰','沲','沴','泂','泆', '泍','泏','泐','泑','泒','泔','泖',0, */
	/* 8fc700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc7a0 */ 0,0x6cda,0x6cdc,0x6ce0,0x6ce7,0x6ce9,0x6ceb,0x6cec, 0x6cee,0x6cf2,0x6cf4,0x6d04,0x6d07,0x6d0a,0x6d0e,0x6d0f, /* 0,'泚','泜','泠','泧','泩','泫','泬', '泮','泲','泴','洄','洇','洊','洎','洏', */
	/* 8fc7b0 */ 0x6d11,0x6d13,0x6d1a,0x6d26,0x6d27,0x6d28,0x6c67,0x6d2e, 0x6d2f,0x6d31,0x6d39,0x6d3c,0x6d3f,0x6d57,0x6d5e,0x6d5f, /* '洑','洓','洚','洦','洧','洨','汧','洮', '洯','洱','洹','洼','洿','浗','浞','浟', */
	/* 8fc7c0 */ 0x6d61,0x6d65,0x6d67,0x6d6f,0x6d70,0x6d7c,0x6d82,0x6d87, 0x6d91,0x6d92,0x6d94,0x6d96,0x6d97,0x6d98,0x6daa,0x6dac, /* '浡','浥','浧','浯','浰','浼','涂','涇', '涑','涒','涔','涖','涗','涘','涪','涬', */
	/* 8fc7d0 */ 0x6db4,0x6db7,0x6db9,0x6dbd,0x6dbf,0x6dc4,0x6dc8,0x6dca, 0x6dce,0x6dcf,0x6dd6,0x6ddb,0x6ddd,0x6ddf,0x6de0,0x6de2, /* '涴','涷','涹','涽','涿','淄','淈','淊', '淎','淏','淖','淛','淝','淟','淠','淢', */
	/* 8fc7e0 */ 0x6de5,0x6de9,0x6def,0x6df0,0x6df4,0x6df6,0x6dfc,0x6e00, 0x6e04,0x6e1e,0x6e22,0x6e27,0x6e32,0x6e36,0x6e39,0x6e3b, /* '淥','淩','淯','淰','淴','淶','淼','渀', '渄','渞','渢','渧','渲','渶','渹','渻', */
	/* 8fc7f0 */ 0x6e3c,0x6e44,0x6e45,0x6e48,0x6e49,0x6e4b,0x6e4f,0x6e51, 0x6e52,0x6e53,0x6e54,0x6e57,0x6e5c,0x6e5d,0x6e5e,0, /* '渼','湄','湅','湈','湉','湋','湏','湑', '湒','湓','湔','湗','湜','湝','湞',0, */
	/* 8fc800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc8a0 */ 0,0x6e62,0x6e63,0x6e68,0x6e73,0x6e7b,0x6e7d,0x6e8d, 0x6e93,0x6e99,0x6ea0,0x6ea7,0x6ead,0x6eae,0x6eb1,0x6eb3, /* 0,'湢','湣','湨','湳','湻','湽','溍', '溓','溙','溠','溧','溭','溮','溱','溳', */
	/* 8fc8b0 */ 0x6ebb,0x6ebf,0x6ec0,0x6ec1,0x6ec3,0x6ec7,0x6ec8,0x6eca, 0x6ecd,0x6ece,0x6ecf,0x6eeb,0x6eed,0x6eee,0x6ef9,0x6efb, /* '溻','溿','滀','滁','滃','滇','滈','滊', '滍','滎','滏','滫','滭','滮','滹','滻', */
	/* 8fc8c0 */ 0x6efd,0x6f04,0x6f08,0x6f0a,0x6f0c,0x6f0d,0x6f16,0x6f18, 0x6f1a,0x6f1b,0x6f26,0x6f29,0x6f2a,0x6f2f,0x6f30,0x6f33, /* '滽','漄','漈','漊','漌','漍','漖','漘', '漚','漛','漦','漩','漪','漯','漰','漳', */
	/* 8fc8d0 */ 0x6f36,0x6f3b,0x6f3c,0x6f2d,0x6f4f,0x6f51,0x6f52,0x6f53, 0x6f57,0x6f59,0x6f5a,0x6f5d,0x6f5e,0x6f61,0x6f62,0x6f68, /* '漶','漻','漼','漭','潏','潑','潒','潓', '潗','潙','潚','潝','潞','潡','潢','潨', */
	/* 8fc8e0 */ 0x6f6c,0x6f7d,0x6f7e,0x6f83,0x6f87,0x6f88,0x6f8b,0x6f8c, 0x6f8d,0x6f90,0x6f92,0x6f93,0x6f94,0x6f96,0x6f9a,0x6f9f, /* '潬','潽','潾','澃','澇','澈','澋','澌', '澍','澐','澒','澓','澔','澖','澚','澟', */
	/* 8fc8f0 */ 0x6fa0,0x6fa5,0x6fa6,0x6fa7,0x6fa8,0x6fae,0x6faf,0x6fb0, 0x6fb5,0x6fb6,0x6fbc,0x6fc5,0x6fc7,0x6fc8,0x6fca,0, /* '澠','澥','澦','澧','澨','澮','澯','澰', '澵','澶','澼','濅','濇','濈','濊',0, */
	/* 8fc900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fc9a0 */ 0,0x6fda,0x6fde,0x6fe8,0x6fe9,0x6ff0,0x6ff5,0x6ff9, 0x6ffc,0x6ffd,0x7000,0x7005,0x7006,0x7007,0x700d,0x7017, /* 0,'濚','濞','濨','濩','濰','濵','濹', '濼','濽','瀀','瀅','瀆','瀇','瀍','瀗', */
	/* 8fc9b0 */ 0x7020,0x7023,0x702f,0x7034,0x7037,0x7039,0x703c,0x7043, 0x7044,0x7048,0x7049,0x704a,0x704b,0x7054,0x7055,0x705d, /* '瀠','瀣','瀯','瀴','瀷','瀹','瀼','灃', '灄','灈','灉','灊','灋','灔','灕','灝', */
	/* 8fc9c0 */ 0x705e,0x704e,0x7064,0x7065,0x706c,0x706e,0x7075,0x7076, 0x707e,0x7081,0x7085,0x7086,0x7094,0x7095,0x7096,0x7097, /* '灞','灎','灤','灥','灬','灮','灵','灶', '灾','炁','炅','炆','炔','炕','炖','炗', */
	/* 8fc9d0 */ 0x7098,0x709b,0x70a4,0x70ab,0x70b0,0x70b1,0x70b4,0x70b7, 0x70ca,0x70d1,0x70d3,0x70d4,0x70d5,0x70d6,0x70d8,0x70dc, /* '炘','炛','炤','炫','炰','炱','炴','炷', '烊','烑','烓','烔','烕','烖','烘','烜', */
	/* 8fc9e0 */ 0x70e4,0x70fa,0x7103,0x7104,0x7105,0x7106,0x7107,0x710b, 0x710c,0x710f,0x711e,0x7120,0x712b,0x712d,0x712f,0x7130, /* '烤','烺','焃','焄','焅','焆','焇','焋', '焌','焏','焞','焠','焫','焭','焯','焰', */
	/* 8fc9f0 */ 0x7131,0x7138,0x7141,0x7145,0x7146,0x7147,0x714a,0x714b, 0x7150,0x7152,0x7157,0x715a,0x715c,0x715e,0x7160,0, /* '焱','焸','煁','煅','煆','煇','煊','煋', '煐','煒','煗','煚','煜','煞','煠',0, */
	/* 8fca00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fca90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcaa0 */ 0,0x7168,0x7179,0x7180,0x7185,0x7187,0x718c,0x7192, 0x719a,0x719b,0x71a0,0x71a2,0x71af,0x71b0,0x71b2,0x71b3, /* 0,'煨','煹','熀','熅','熇','熌','熒', '熚','熛','熠','熢','熯','熰','熲','熳', */
	/* 8fcab0 */ 0x71ba,0x71bf,0x71c0,0x71c1,0x71c4,0x71cb,0x71cc,0x71d3, 0x71d6,0x71d9,0x71da,0x71dc,0x71f8,0x71fe,0x7200,0x7207, /* '熺','熿','燀','燁','燄','燋','燌','燓', '燖','燙','燚','燜','燸','燾','爀','爇', */
	/* 8fcac0 */ 0x7208,0x7209,0x7213,0x7217,0x721a,0x721d,0x721f,0x7224, 0x722b,0x722f,0x7234,0x7238,0x7239,0x7241,0x7242,0x7243, /* '爈','爉','爓','爗','爚','爝','爟','爤', '爫','爯','爴','爸','爹','牁','牂','牃', */
	/* 8fcad0 */ 0x7245,0x724e,0x724f,0x7250,0x7253,0x7255,0x7256,0x725a, 0x725c,0x725e,0x7260,0x7263,0x7268,0x726b,0x726e,0x726f, /* '牅','牎','牏','牐','牓','牕','牖','牚', '牜','牞','牠','牣','牨','牫','牮','牯', */
	/* 8fcae0 */ 0x7271,0x7277,0x7278,0x727b,0x727c,0x727f,0x7284,0x7289, 0x728d,0x728e,0x7293,0x729b,0x72a8,0x72ad,0x72ae,0x72b1, /* '牱','牷','牸','牻','牼','牿','犄','犉', '犍','犎','犓','犛','犨','犭','犮','犱', */
	/* 8fcaf0 */ 0x72b4,0x72be,0x72c1,0x72c7,0x72c9,0x72cc,0x72d5,0x72d6, 0x72d8,0x72df,0x72e5,0x72f3,0x72f4,0x72fa,0x72fb,0, /* '犴','犾','狁','狇','狉','狌','狕','狖', '狘','狟','狥','狳','狴','狺','狻',0, */
	/* 8fcb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcba0 */ 0,0x72fe,0x7302,0x7304,0x7305,0x7307,0x730b,0x730d, 0x7312,0x7313,0x7318,0x7319,0x731e,0x7322,0x7324,0x7327, /* 0,'狾','猂','猄','猅','猇','猋','猍', '猒','猓','猘','猙','猞','猢','猤','猧', */
	/* 8fcbb0 */ 0x7328,0x732c,0x7331,0x7332,0x7335,0x733a,0x733b,0x733d, 0x7343,0x734d,0x7350,0x7352,0x7356,0x7358,0x735d,0x735e, /* '猨','猬','猱','猲','猵','猺','猻','猽', '獃','獍','獐','獒','獖','獘','獝','獞', */
	/* 8fcbc0 */ 0x735f,0x7360,0x7366,0x7367,0x7369,0x736b,0x736c,0x736e, 0x736f,0x7371,0x7377,0x7379,0x737c,0x7380,0x7381,0x7383, /* '獟','獠','獦','獧','獩','獫','獬','獮', '獯','獱','獷','獹','獼','玀','玁','玃', */
	/* 8fcbd0 */ 0x7385,0x7386,0x738e,0x7390,0x7393,0x7395,0x7397,0x7398, 0x739c,0x739e,0x739f,0x73a0,0x73a2,0x73a5,0x73a6,0x73aa, /* '玅','玆','玎','玐','玓','玕','玗','玘', '玜','玞','玟','玠','玢','玥','玦','玪', */
	/* 8fcbe0 */ 0x73ab,0x73ad,0x73b5,0x73b7,0x73b9,0x73bc,0x73bd,0x73bf, 0x73c5,0x73c6,0x73c9,0x73cb,0x73cc,0x73cf,0x73d2,0x73d3, /* '玫','玭','玵','玷','玹','玼','玽','玿', '珅','珆','珉','珋','珌','珏','珒','珓', */
	/* 8fcbf0 */ 0x73d6,0x73d9,0x73dd,0x73e1,0x73e3,0x73e6,0x73e7,0x73e9, 0x73f4,0x73f5,0x73f7,0x73f9,0x73fa,0x73fb,0x73fd,0, /* '珖','珙','珝','珡','珣','珦','珧','珩', '珴','珵','珷','珹','珺','珻','珽',0, */
	/* 8fcc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcca0 */ 0,0x73ff,0x7400,0x7401,0x7404,0x7407,0x740a,0x7411, 0x741a,0x741b,0x7424,0x7426,0x7428,0x7429,0x742a,0x742b, /* 0,'珿','琀','琁','琄','琇','琊','琑', '琚','琛','琤','琦','琨','琩','琪','琫', */
	/* 8fccb0 */ 0x742c,0x742d,0x742e,0x742f,0x7430,0x7431,0x7439,0x7440, 0x7443,0x7444,0x7446,0x7447,0x744b,0x744d,0x7451,0x7452, /* '琬','琭','琮','琯','琰','琱','琹','瑀', '瑃','瑄','瑆','瑇','瑋','瑍','瑑','瑒', */
	/* 8fccc0 */ 0x7457,0x745d,0x7462,0x7466,0x7467,0x7468,0x746b,0x746d, 0x746e,0x7471,0x7472,0x7480,0x7481,0x7485,0x7486,0x7487, /* '瑗','瑝','瑢','瑦','瑧','瑨','瑫','瑭', '瑮','瑱','瑲','璀','璁','璅','璆','璇', */
	/* 8fccd0 */ 0x7489,0x748f,0x7490,0x7491,0x7492,0x7498,0x7499,0x749a, 0x749c,0x749f,0x74a0,0x74a1,0x74a3,0x74a6,0x74a8,0x74a9, /* '璉','璏','璐','璑','璒','璘','璙','璚', '璜','璟','璠','璡','璣','璦','璨','璩', */
	/* 8fcce0 */ 0x74aa,0x74ab,0x74ae,0x74af,0x74b1,0x74b2,0x74b5,0x74b9, 0x74bb,0x74bf,0x74c8,0x74c9,0x74cc,0x74d0,0x74d3,0x74d8, /* '璪','璫','璮','璯','璱','璲','璵','璹', '璻','璿','瓈','瓉','瓌','瓐','瓓','瓘', */
	/* 8fccf0 */ 0x74da,0x74db,0x74de,0x74df,0x74e4,0x74e8,0x74ea,0x74eb, 0x74ef,0x74f4,0x74fa,0x74fb,0x74fc,0x74ff,0x7506,0, /* '瓚','瓛','瓞','瓟','瓤','瓨','瓪','瓫', '瓯','瓴','瓺','瓻','瓼','瓿','甆',0, */
	/* 8fcd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcda0 */ 0,0x7512,0x7516,0x7517,0x7520,0x7521,0x7524,0x7527, 0x7529,0x752a,0x752f,0x7536,0x7539,0x753d,0x753e,0x753f, /* 0,'甒','甖','甗','甠','甡','甤','甧', '甩','甪','甯','甶','甹','甽','甾','甿', */
	/* 8fcdb0 */ 0x7540,0x7543,0x7547,0x7548,0x754e,0x7550,0x7552,0x7557, 0x755e,0x755f,0x7561,0x756f,0x7571,0x7579,0x757a,0x757b, /* '畀','畃','畇','畈','畎','畐','畒','畗', '畞','畟','畡','畯','畱','畹','畺','畻', */
	/* 8fcdc0 */ 0x757c,0x757d,0x757e,0x7581,0x7585,0x7590,0x7592,0x7593, 0x7595,0x7599,0x759c,0x75a2,0x75a4,0x75b4,0x75ba,0x75bf, /* '畼','畽','畾','疁','疅','疐','疒','疓', '疕','疙','疜','疢','疤','疴','疺','疿', */
	/* 8fcdd0 */ 0x75c0,0x75c1,0x75c4,0x75c6,0x75cc,0x75ce,0x75cf,0x75d7, 0x75dc,0x75df,0x75e0,0x75e1,0x75e4,0x75e7,0x75ec,0x75ee, /* '痀','痁','痄','痆','痌','痎','痏','痗', '痜','痟','痠','痡','痤','痧','痬','痮', */
	/* 8fcde0 */ 0x75ef,0x75f1,0x75f9,0x7600,0x7602,0x7603,0x7604,0x7607, 0x7608,0x760a,0x760c,0x760f,0x7612,0x7613,0x7615,0x7616, /* '痯','痱','痹','瘀','瘂','瘃','瘄','瘇', '瘈','瘊','瘌','瘏','瘒','瘓','瘕','瘖', */
	/* 8fcdf0 */ 0x7619,0x761b,0x761c,0x761d,0x761e,0x7623,0x7625,0x7626, 0x7629,0x762d,0x7632,0x7633,0x7635,0x7638,0x7639,0, /* '瘙','瘛','瘜','瘝','瘞','瘣','瘥','瘦', '瘩','瘭','瘲','瘳','瘵','瘸','瘹',0, */
	/* 8fce00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fce90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcea0 */ 0,0x763a,0x763c,0x764a,0x7640,0x7641,0x7643,0x7644, 0x7645,0x7649,0x764b,0x7655,0x7659,0x765f,0x7664,0x7665, /* 0,'瘺','瘼','癊','癀','癁','癃','癄', '癅','癉','癋','癕','癙','癟','癤','癥', */
	/* 8fceb0 */ 0x766d,0x766e,0x766f,0x7671,0x7674,0x7681,0x7685,0x768c, 0x768d,0x7695,0x769b,0x769c,0x769d,0x769f,0x76a0,0x76a2, /* '癭','癮','癯','癱','癴','皁','皅','皌', '皍','皕','皛','皜','皝','皟','皠','皢', */
	/* 8fcec0 */ 0x76a3,0x76a4,0x76a5,0x76a6,0x76a7,0x76a8,0x76aa,0x76ad, 0x76bd,0x76c1,0x76c5,0x76c9,0x76cb,0x76cc,0x76ce,0x76d4, /* '皣','皤','皥','皦','皧','皨','皪','皭', '皽','盁','盅','盉','盋','盌','盎','盔', */
	/* 8fced0 */ 0x76d9,0x76e0,0x76e6,0x76e8,0x76ec,0x76f0,0x76f1,0x76f6, 0x76f9,0x76fc,0x7700,0x7706,0x770a,0x770e,0x7712,0x7714, /* '盙','盠','盦','盨','盬','盰','盱','盶', '盹','盼','眀','眆','眊','眎','眒','眔', */
	/* 8fcee0 */ 0x7715,0x7717,0x7719,0x771a,0x771c,0x7722,0x7728,0x772d, 0x772e,0x772f,0x7734,0x7735,0x7736,0x7739,0x773d,0x773e, /* '眕','眗','眙','眚','眜','眢','眨','眭', '眮','眯','眴','眵','眶','眹','眽','眾', */
	/* 8fcef0 */ 0x7742,0x7745,0x7746,0x774a,0x774d,0x774e,0x774f,0x7752, 0x7756,0x7757,0x775c,0x775e,0x775f,0x7760,0x7762,0, /* '睂','睅','睆','睊','睍','睎','睏','睒', '睖','睗','睜','睞','睟','睠','睢',0, */
	/* 8fcf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fcfa0 */ 0,0x7764,0x7767,0x776a,0x776c,0x7770,0x7772,0x7773, 0x7774,0x777a,0x777d,0x7780,0x7784,0x778c,0x778d,0x7794, /* 0,'睤','睧','睪','睬','睰','睲','睳', '睴','睺','睽','瞀','瞄','瞌','瞍','瞔', */
	/* 8fcfb0 */ 0x7795,0x7796,0x779a,0x779f,0x77a2,0x77a7,0x77aa,0x77ae, 0x77af,0x77b1,0x77b5,0x77be,0x77c3,0x77c9,0x77d1,0x77d2, /* '瞕','瞖','瞚','瞟','瞢','瞧','瞪','瞮', '瞯','瞱','瞵','瞾','矃','矉','矑','矒', */
	/* 8fcfc0 */ 0x77d5,0x77d9,0x77de,0x77df,0x77e0,0x77e4,0x77e6,0x77ea, 0x77ec,0x77f0,0x77f1,0x77f4,0x77f8,0x77fb,0x7805,0x7806, /* '矕','矙','矞','矟','矠','矤','矦','矪', '矬','矰','矱','矴','矸','矻','砅','砆', */
	/* 8fcfd0 */ 0x7809,0x780d,0x780e,0x7811,0x781d,0x7821,0x7822,0x7823, 0x782d,0x782e,0x7830,0x7835,0x7837,0x7843,0x7844,0x7847, /* '砉','砍','砎','砑','砝','砡','砢','砣', '砭','砮','砰','砵','砷','硃','硄','硇', */
	/* 8fcfe0 */ 0x7848,0x784c,0x784e,0x7852,0x785c,0x785e,0x7860,0x7861, 0x7863,0x7864,0x7868,0x786a,0x786e,0x787a,0x787e,0x788a, /* '硈','硌','硎','硒','硜','硞','硠','硡', '硣','硤','硨','硪','确','硺','硾','碊', */
	/* 8fcff0 */ 0x788f,0x7894,0x7898,0x78a1,0x789d,0x789e,0x789f,0x78a4, 0x78a8,0x78ac,0x78ad,0x78b0,0x78b1,0x78b2,0x78b3,0, /* '碏','碔','碘','碡','碝','碞','碟','碤', '碨','碬','碭','碰','碱','碲','碳',0, */
	/* 8fd000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd0a0 */ 0,0x78bb,0x78bd,0x78bf,0x78c7,0x78c8,0x78c9,0x78cc, 0x78ce,0x78d2,0x78d3,0x78d5,0x78d6,0x78e4,0x78db,0x78df, /* 0,'碻','碽','碿','磇','磈','磉','磌', '磎','磒','磓','磕','磖','磤','磛','磟', */
	/* 8fd0b0 */ 0x78e0,0x78e1,0x78e6,0x78ea,0x78f2,0x78f3,0x7900,0x78f6, 0x78f7,0x78fa,0x78fb,0x78ff,0x7906,0x790c,0x7910,0x791a, /* '磠','磡','磦','磪','磲','磳','礀','磶', '磷','磺','磻','磿','礆','礌','礐','礚', */
	/* 8fd0c0 */ 0x791c,0x791e,0x791f,0x7920,0x7925,0x7927,0x7929,0x792d, 0x7931,0x7934,0x7935,0x793b,0x793d,0x793f,0x7944,0x7945, /* '礜','礞','礟','礠','礥','礧','礩','礭', '礱','礴','礵','礻','礽','礿','祄','祅', */
	/* 8fd0d0 */ 0x7946,0x794a,0x794b,0x794f,0x7951,0x7954,0x7958,0x795b, 0x795c,0x7967,0x7969,0x796b,0x7972,0x7979,0x797b,0x797c, /* '祆','祊','祋','祏','祑','祔','祘','祛', '祜','祧','祩','祫','祲','祹','祻','祼', */
	/* 8fd0e0 */ 0x797e,0x798b,0x798c,0x7991,0x7993,0x7994,0x7995,0x7996, 0x7998,0x799b,0x799c,0x79a1,0x79a8,0x79a9,0x79ab,0x79af, /* '祾','禋','禌','禑','禓','禔','禕','禖', '禘','禛','禜','禡','禨','禩','禫','禯', */
	/* 8fd0f0 */ 0x79b1,0x79b4,0x79b8,0x79bb,0x79c2,0x79c4,0x79c7,0x79c8, 0x79ca,0x79cf,0x79d4,0x79d6,0x79da,0x79dd,0x79de,0, /* '禱','禴','禸','离','秂','秄','秇','秈', '秊','秏','秔','秖','秚','秝','秞',0, */
	/* 8fd100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd1a0 */ 0,0x79e0,0x79e2,0x79e5,0x79ea,0x79eb,0x79ed,0x79f1, 0x79f8,0x79fc,0x7a02,0x7a03,0x7a07,0x7a09,0x7a0a,0x7a0c, /* 0,'秠','秢','秥','秪','秫','秭','秱', '秸','秼','稂','稃','稇','稉','稊','稌', */
	/* 8fd1b0 */ 0x7a11,0x7a15,0x7a1b,0x7a1e,0x7a21,0x7a27,0x7a2b,0x7a2d, 0x7a2f,0x7a30,0x7a34,0x7a35,0x7a38,0x7a39,0x7a3a,0x7a44, /* '稑','稕','稛','稞','稡','稧','稫','稭', '稯','稰','稴','稵','稸','稹','稺','穄', */
	/* 8fd1c0 */ 0x7a45,0x7a47,0x7a48,0x7a4c,0x7a55,0x7a56,0x7a59,0x7a5c, 0x7a5d,0x7a5f,0x7a60,0x7a65,0x7a67,0x7a6a,0x7a6d,0x7a75, /* '穅','穇','穈','穌','穕','穖','穙','穜', '穝','穟','穠','穥','穧','穪','穭','穵', */
	/* 8fd1d0 */ 0x7a78,0x7a7e,0x7a80,0x7a82,0x7a85,0x7a86,0x7a8a,0x7a8b, 0x7a90,0x7a91,0x7a94,0x7a9e,0x7aa0,0x7aa3,0x7aac,0x7ab3, /* '穸','穾','窀','窂','窅','窆','窊','窋', '窐','窑','窔','窞','窠','窣','窬','窳', */
	/* 8fd1e0 */ 0x7ab5,0x7ab9,0x7abb,0x7abc,0x7ac6,0x7ac9,0x7acc,0x7ace, 0x7ad1,0x7adb,0x7ae8,0x7ae9,0x7aeb,0x7aec,0x7af1,0x7af4, /* '窵','窹','窻','窼','竆','竉','竌','竎', '竑','竛','竨','竩','竫','竬','竱','竴', */
	/* 8fd1f0 */ 0x7afb,0x7afd,0x7afe,0x7b07,0x7b14,0x7b1f,0x7b23,0x7b27, 0x7b29,0x7b2a,0x7b2b,0x7b2d,0x7b2e,0x7b2f,0x7b30,0, /* '竻','竽','竾','笇','笔','笟','笣','笧', '笩','笪','笫','笭','笮','笯','笰',0, */
	/* 8fd200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd2a0 */ 0,0x7b31,0x7b34,0x7b3d,0x7b3f,0x7b40,0x7b41,0x7b47, 0x7b4e,0x7b55,0x7b60,0x7b64,0x7b66,0x7b69,0x7b6a,0x7b6d, /* 0,'笱','笴','笽','笿','筀','筁','筇', '筎','筕','筠','筤','筦','筩','筪','筭', */
	/* 8fd2b0 */ 0x7b6f,0x7b72,0x7b73,0x7b77,0x7b84,0x7b89,0x7b8e,0x7b90, 0x7b91,0x7b96,0x7b9b,0x7b9e,0x7ba0,0x7ba5,0x7bac,0x7baf, /* '筯','筲','筳','筷','箄','箉','箎','箐', '箑','箖','箛','箞','箠','箥','箬','箯', */
	/* 8fd2c0 */ 0x7bb0,0x7bb2,0x7bb5,0x7bb6,0x7bba,0x7bbb,0x7bbc,0x7bbd, 0x7bc2,0x7bc5,0x7bc8,0x7bca,0x7bd4,0x7bd6,0x7bd7,0x7bd9, /* '箰','箲','箵','箶','箺','箻','箼','箽', '篂','篅','篈','篊','篔','篖','篗','篙', */
	/* 8fd2d0 */ 0x7bda,0x7bdb,0x7be8,0x7bea,0x7bf2,0x7bf4,0x7bf5,0x7bf8, 0x7bf9,0x7bfa,0x7bfc,0x7bfe,0x7c01,0x7c02,0x7c03,0x7c04, /* '篚','篛','篨','篪','篲','篴','篵','篸', '篹','篺','篼','篾','簁','簂','簃','簄', */
	/* 8fd2e0 */ 0x7c06,0x7c09,0x7c0b,0x7c0c,0x7c0e,0x7c0f,0x7c19,0x7c1b, 0x7c20,0x7c25,0x7c26,0x7c28,0x7c2c,0x7c31,0x7c33,0x7c34, /* '簆','簉','簋','簌','簎','簏','簙','簛', '簠','簥','簦','簨','簬','簱','簳','簴', */
	/* 8fd2f0 */ 0x7c36,0x7c39,0x7c3a,0x7c46,0x7c4a,0x7c55,0x7c51,0x7c52, 0x7c53,0x7c59,0x7c5a,0x7c5b,0x7c5c,0x7c5d,0x7c5e,0, /* '簶','簹','簺','籆','籊','籕','籑','籒', '籓','籙','籚','籛','籜','籝','籞',0, */
	/* 8fd300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd3a0 */ 0,0x7c61,0x7c63,0x7c67,0x7c69,0x7c6d,0x7c6e,0x7c70, 0x7c72,0x7c79,0x7c7c,0x7c7d,0x7c86,0x7c87,0x7c8f,0x7c94, /* 0,'籡','籣','籧','籩','籭','籮','籰', '籲','籹','籼','籽','粆','粇','粏','粔', */
	/* 8fd3b0 */ 0x7c9e,0x7ca0,0x7ca6,0x7cb0,0x7cb6,0x7cb7,0x7cba,0x7cbb, 0x7cbc,0x7cbf,0x7cc4,0x7cc7,0x7cc8,0x7cc9,0x7ccd,0x7ccf, /* '粞','粠','粦','粰','粶','粷','粺','粻', '粼','粿','糄','糇','糈','糉','糍','糏', */
	/* 8fd3c0 */ 0x7cd3,0x7cd4,0x7cd5,0x7cd7,0x7cd9,0x7cda,0x7cdd,0x7ce6, 0x7ce9,0x7ceb,0x7cf5,0x7d03,0x7d07,0x7d08,0x7d09,0x7d0f, /* '糓','糔','糕','糗','糙','糚','糝','糦', '糩','糫','糵','紃','紇','紈','紉','紏', */
	/* 8fd3d0 */ 0x7d11,0x7d12,0x7d13,0x7d16,0x7d1d,0x7d1e,0x7d23,0x7d26, 0x7d2a,0x7d2d,0x7d31,0x7d3c,0x7d3d,0x7d3e,0x7d40,0x7d41, /* '紑','紒','紓','紖','紝','紞','紣','紦', '紪','紭','紱','紼','紽','紾','絀','絁', */
	/* 8fd3e0 */ 0x7d47,0x7d48,0x7d4d,0x7d51,0x7d53,0x7d57,0x7d59,0x7d5a, 0x7d5c,0x7d5d,0x7d65,0x7d67,0x7d6a,0x7d70,0x7d78,0x7d7a, /* '絇','絈','絍','絑','絓','絗','絙','絚', '絜','絝','絥','絧','絪','絰','絸','絺', */
	/* 8fd3f0 */ 0x7d7b,0x7d7f,0x7d81,0x7d82,0x7d83,0x7d85,0x7d86,0x7d88, 0x7d8b,0x7d8c,0x7d8d,0x7d91,0x7d96,0x7d97,0x7d9d,0, /* '絻','絿','綁','綂','綃','綅','綆','綈', '綋','綌','綍','綑','綖','綗','綝',0, */
	/* 8fd400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd4a0 */ 0,0x7d9e,0x7da6,0x7da7,0x7daa,0x7db3,0x7db6,0x7db7, 0x7db9,0x7dc2,0x7dc3,0x7dc4,0x7dc5,0x7dc6,0x7dcc,0x7dcd, /* 0,'綞','綦','綧','綪','綳','綶','綷', '綹','緂','緃','緄','緅','緆','緌','緍', */
	/* 8fd4b0 */ 0x7dce,0x7dd7,0x7dd9,0x7e00,0x7de2,0x7de5,0x7de6,0x7dea, 0x7deb,0x7ded,0x7df1,0x7df5,0x7df6,0x7df9,0x7dfa,0x7e08, /* '緎','緗','緙','縀','緢','緥','緦','緪', '緫','緭','緱','緵','緶','緹','緺','縈', */
	/* 8fd4c0 */ 0x7e10,0x7e11,0x7e15,0x7e17,0x7e1c,0x7e1d,0x7e20,0x7e27, 0x7e28,0x7e2c,0x7e2d,0x7e2f,0x7e33,0x7e36,0x7e3f,0x7e44, /* '縐','縑','縕','縗','縜','縝','縠','縧', '縨','縬','縭','縯','縳','縶','縿','繄', */
	/* 8fd4d0 */ 0x7e45,0x7e47,0x7e4e,0x7e50,0x7e52,0x7e58,0x7e5f,0x7e61, 0x7e62,0x7e65,0x7e6b,0x7e6e,0x7e6f,0x7e73,0x7e78,0x7e7e, /* '繅','繇','繎','繐','繒','繘','繟','繡', '繢','繥','繫','繮','繯','繳','繸','繾', */
	/* 8fd4e0 */ 0x7e81,0x7e86,0x7e87,0x7e8a,0x7e8d,0x7e91,0x7e95,0x7e98, 0x7e9a,0x7e9d,0x7e9e,0x7f3c,0x7f3b,0x7f3d,0x7f3e,0x7f3f, /* '纁','纆','纇','纊','纍','纑','纕','纘', '纚','纝','纞','缼','缻','缽','缾','缿', */
	/* 8fd4f0 */ 0x7f43,0x7f44,0x7f47,0x7f4f,0x7f52,0x7f53,0x7f5b,0x7f5c, 0x7f5d,0x7f61,0x7f63,0x7f64,0x7f65,0x7f66,0x7f6d,0, /* '罃','罄','罇','罏','罒','罓','罛','罜', '罝','罡','罣','罤','罥','罦','罭',0, */
	/* 8fd500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd5a0 */ 0,0x7f71,0x7f7d,0x7f7e,0x7f7f,0x7f80,0x7f8b,0x7f8d, 0x7f8f,0x7f90,0x7f91,0x7f96,0x7f97,0x7f9c,0x7fa1,0x7fa2, /* 0,'罱','罽','罾','罿','羀','羋','羍', '羏','羐','羑','羖','羗','羜','羡','羢', */
	/* 8fd5b0 */ 0x7fa6,0x7faa,0x7fad,0x7fb4,0x7fbc,0x7fbf,0x7fc0,0x7fc3, 0x7fc8,0x7fce,0x7fcf,0x7fdb,0x7fdf,0x7fe3,0x7fe5,0x7fe8, /* '羦','羪','羭','羴','羼','羿','翀','翃', '翈','翎','翏','翛','翟','翣','翥','翨', */
	/* 8fd5c0 */ 0x7fec,0x7fee,0x7fef,0x7ff2,0x7ffa,0x7ffd,0x7ffe,0x7fff, 0x8007,0x8008,0x800a,0x800d,0x800e,0x800f,0x8011,0x8013, /* '翬','翮','翯','翲','翺','翽','翾','翿', '耇','耈','耊','耍','耎','耏','耑','耓', */
	/* 8fd5d0 */ 0x8014,0x8016,0x801d,0x801e,0x801f,0x8020,0x8024,0x8026, 0x802c,0x802e,0x8030,0x8034,0x8035,0x8037,0x8039,0x803a, /* '耔','耖','耝','耞','耟','耠','耤','耦', '耬','耮','耰','耴','耵','耷','耹','耺', */
	/* 8fd5e0 */ 0x803c,0x803e,0x8040,0x8044,0x8060,0x8064,0x8066,0x806d, 0x8071,0x8075,0x8081,0x8088,0x808e,0x809c,0x809e,0x80a6, /* '耼','耾','聀','聄','聠','聤','聦','聭', '聱','聵','肁','肈','肎','肜','肞','肦', */
	/* 8fd5f0 */ 0x80a7,0x80ab,0x80b8,0x80b9,0x80c8,0x80cd,0x80cf,0x80d2, 0x80d4,0x80d5,0x80d7,0x80d8,0x80e0,0x80ed,0x80ee,0, /* '肧','肫','肸','肹','胈','胍','胏','胒', '胔','胕','胗','胘','胠','胭','胮',0, */
	/* 8fd600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd6a0 */ 0,0x80f0,0x80f2,0x80f3,0x80f6,0x80f9,0x80fa,0x80fe, 0x8103,0x810b,0x8116,0x8117,0x8118,0x811c,0x811e,0x8120, /* 0,'胰','胲','胳','胶','胹','胺','胾', '脃','脋','脖','脗','脘','脜','脞','脠', */
	/* 8fd6b0 */ 0x8124,0x8127,0x812c,0x8130,0x8135,0x813a,0x813c,0x8145, 0x8147,0x814a,0x814c,0x8152,0x8157,0x8160,0x8161,0x8167, /* '脤','脧','脬','脰','脵','脺','脼','腅', '腇','腊','腌','腒','腗','腠','腡','腧', */
	/* 8fd6c0 */ 0x8168,0x8169,0x816d,0x816f,0x8177,0x8181,0x8190,0x8184, 0x8185,0x8186,0x818b,0x818e,0x8196,0x8198,0x819b,0x819e, /* '腨','腩','腭','腯','腷','膁','膐','膄', '膅','膆','膋','膎','膖','膘','膛','膞', */
	/* 8fd6d0 */ 0x81a2,0x81ae,0x81b2,0x81b4,0x81bb,0x81cb,0x81c3,0x81c5, 0x81ca,0x81ce,0x81cf,0x81d5,0x81d7,0x81db,0x81dd,0x81de, /* '膢','膮','膲','膴','膻','臋','臃','臅', '臊','臎','臏','臕','臗','臛','臝','臞', */
	/* 8fd6e0 */ 0x81e1,0x81e4,0x81eb,0x81ec,0x81f0,0x81f1,0x81f2,0x81f5, 0x81f6,0x81f8,0x81f9,0x81fd,0x81ff,0x8200,0x8203,0x820f, /* '臡','臤','臫','臬','臰','臱','臲','臵', '臶','臸','臹','臽','臿','舀','舃','舏', */
	/* 8fd6f0 */ 0x8213,0x8214,0x8219,0x821a,0x821d,0x8221,0x8222,0x8228, 0x8232,0x8234,0x823a,0x8243,0x8244,0x8245,0x8246,0, /* '舓','舔','舙','舚','舝','舡','舢','舨', '舲','舴','舺','艃','艄','艅','艆',0, */
	/* 8fd700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd7a0 */ 0,0x824b,0x824e,0x824f,0x8251,0x8256,0x825c,0x8260, 0x8263,0x8267,0x826d,0x8274,0x827b,0x827d,0x827f,0x8280, /* 0,'艋','艎','艏','艑','艖','艜','艠', '艣','艧','艭','艴','艻','艽','艿','芀', */
	/* 8fd7b0 */ 0x8281,0x8283,0x8284,0x8287,0x8289,0x828a,0x828e,0x8291, 0x8294,0x8296,0x8298,0x829a,0x829b,0x82a0,0x82a1,0x82a3, /* '芁','芃','芄','芇','芉','芊','芎','芑', '芔','芖','芘','芚','芛','芠','芡','芣', */
	/* 8fd7c0 */ 0x82a4,0x82a7,0x82a8,0x82a9,0x82aa,0x82ae,0x82b0,0x82b2, 0x82b4,0x82b7,0x82ba,0x82bc,0x82be,0x82bf,0x82c6,0x82d0, /* '芤','芧','芨','芩','芪','芮','芰','芲', '芴','芷','芺','芼','芾','芿','苆','苐', */
	/* 8fd7d0 */ 0x82d5,0x82da,0x82e0,0x82e2,0x82e4,0x82e8,0x82ea,0x82ed, 0x82ef,0x82f6,0x82f7,0x82fd,0x82fe,0x8300,0x8301,0x8307, /* '苕','苚','苠','苢','苤','苨','苪','苭', '苯','苶','苷','苽','苾','茀','茁','茇', */
	/* 8fd7e0 */ 0x8308,0x830a,0x830b,0x8354,0x831b,0x831d,0x831e,0x831f, 0x8321,0x8322,0x832c,0x832d,0x832e,0x8330,0x8333,0x8337, /* '茈','茊','茋','荔','茛','茝','茞','茟', '茡','茢','茬','茭','茮','茰','茳','茷', */
	/* 8fd7f0 */ 0x833a,0x833c,0x833d,0x8342,0x8343,0x8344,0x8347,0x834d, 0x834e,0x8351,0x8355,0x8356,0x8357,0x8370,0x8378,0, /* '茺','茼','茽','荂','荃','荄','荇','荍', '荎','荑','荕','荖','荗','荰','荸',0, */
	/* 8fd800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd8a0 */ 0,0x837d,0x837f,0x8380,0x8382,0x8384,0x8386,0x838d, 0x8392,0x8394,0x8395,0x8398,0x8399,0x839b,0x839c,0x839d, /* 0,'荽','荿','莀','莂','莄','莆','莍', '莒','莔','莕','莘','莙','莛','莜','莝', */
	/* 8fd8b0 */ 0x83a6,0x83a7,0x83a9,0x83ac,0x83be,0x83bf,0x83c0,0x83c7, 0x83c9,0x83cf,0x83d0,0x83d1,0x83d4,0x83dd,0x8353,0x83e8, /* '莦','莧','莩','莬','莾','莿','菀','菇', '菉','菏','菐','菑','菔','菝','荓','菨', */
	/* 8fd8c0 */ 0x83ea,0x83f6,0x83f8,0x83f9,0x83fc,0x8401,0x8406,0x840a, 0x840f,0x8411,0x8415,0x8419,0x83ad,0x842f,0x8439,0x8445, /* '菪','菶','菸','菹','菼','萁','萆','萊', '萏','萑','萕','萙','莭','萯','萹','葅', */
	/* 8fd8d0 */ 0x8447,0x8448,0x844a,0x844d,0x844f,0x8451,0x8452,0x8456, 0x8458,0x8459,0x845a,0x845c,0x8460,0x8464,0x8465,0x8467, /* '葇','葈','葊','葍','葏','葑','葒','葖', '葘','葙','葚','葜','葠','葤','葥','葧', */
	/* 8fd8e0 */ 0x846a,0x8470,0x8473,0x8474,0x8476,0x8478,0x847c,0x847d, 0x8481,0x8485,0x8492,0x8493,0x8495,0x849e,0x84a6,0x84a8, /* '葪','葰','葳','葴','葶','葸','葼','葽', '蒁','蒅','蒒','蒓','蒕','蒞','蒦','蒨', */
	/* 8fd8f0 */ 0x84a9,0x84aa,0x84af,0x84b1,0x84b4,0x84ba,0x84bd,0x84be, 0x84c0,0x84c2,0x84c7,0x84c8,0x84cc,0x84cf,0x84d3,0, /* '蒩','蒪','蒯','蒱','蒴','蒺','蒽','蒾', '蓀','蓂','蓇','蓈','蓌','蓏','蓓',0, */
	/* 8fd900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fd9a0 */ 0,0x84dc,0x84e7,0x84ea,0x84ef,0x84f0,0x84f1,0x84f2, 0x84f7,0x8532,0x84fa,0x84fb,0x84fd,0x8502,0x8503,0x8507, /* 0,'蓜','蓧','蓪','蓯','蓰','蓱','蓲', '蓷','蔲','蓺','蓻','蓽','蔂','蔃','蔇', */
	/* 8fd9b0 */ 0x850c,0x850e,0x8510,0x851c,0x851e,0x8522,0x8523,0x8524, 0x8525,0x8527,0x852a,0x852b,0x852f,0x8533,0x8534,0x8536, /* '蔌','蔎','蔐','蔜','蔞','蔢','蔣','蔤', '蔥','蔧','蔪','蔫','蔯','蔳','蔴','蔶', */
	/* 8fd9c0 */ 0x853f,0x8546,0x854f,0x8550,0x8551,0x8552,0x8553,0x8556, 0x8559,0x855c,0x855d,0x855e,0x855f,0x8560,0x8561,0x8562, /* '蔿','蕆','蕏','蕐','蕑','蕒','蕓','蕖', '蕙','蕜','蕝','蕞','蕟','蕠','蕡','蕢', */
	/* 8fd9d0 */ 0x8564,0x856b,0x856f,0x8579,0x857a,0x857b,0x857d,0x857f, 0x8581,0x8585,0x8586,0x8589,0x858b,0x858c,0x858f,0x8593, /* '蕤','蕫','蕯','蕹','蕺','蕻','蕽','蕿', '薁','薅','薆','薉','薋','薌','薏','薓', */
	/* 8fd9e0 */ 0x8598,0x859d,0x859f,0x85a0,0x85a2,0x85a5,0x85a7,0x85b4, 0x85b6,0x85b7,0x85b8,0x85bc,0x85bd,0x85be,0x85bf,0x85c2, /* '薘','薝','薟','薠','薢','薥','薧','薴', '薶','薷','薸','薼','薽','薾','薿','藂', */
	/* 8fd9f0 */ 0x85c7,0x85ca,0x85cb,0x85ce,0x85ad,0x85d8,0x85da,0x85df, 0x85e0,0x85e6,0x85e8,0x85ed,0x85f3,0x85f6,0x85fc,0, /* '藇','藊','藋','藎','薭','藘','藚','藟', '藠','藦','藨','藭','藳','藶','藼',0, */
	/* 8fda00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fda90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdaa0 */ 0,0x85ff,0x8600,0x8604,0x8605,0x860d,0x860e,0x8610, 0x8611,0x8612,0x8618,0x8619,0x861b,0x861e,0x8621,0x8627, /* 0,'藿','蘀','蘄','蘅','蘍','蘎','蘐', '蘑','蘒','蘘','蘙','蘛','蘞','蘡','蘧', */
	/* 8fdab0 */ 0x8629,0x8636,0x8638,0x863a,0x863c,0x863d,0x8640,0x8642, 0x8646,0x8652,0x8653,0x8656,0x8657,0x8658,0x8659,0x865d, /* '蘩','蘶','蘸','蘺','蘼','蘽','虀','虂', '虆','虒','虓','虖','虗','虘','虙','虝', */
	/* 8fdac0 */ 0x8660,0x8661,0x8662,0x8663,0x8664,0x8669,0x866c,0x866f, 0x8675,0x8676,0x8677,0x867a,0x868d,0x8691,0x8696,0x8698, /* '虠','虡','虢','虣','虤','虩','虬','虯', '虵','虶','虷','虺','蚍','蚑','蚖','蚘', */
	/* 8fdad0 */ 0x869a,0x869c,0x86a1,0x86a6,0x86a7,0x86a8,0x86ad,0x86b1, 0x86b3,0x86b4,0x86b5,0x86b7,0x86b8,0x86b9,0x86bf,0x86c0, /* '蚚','蚜','蚡','蚦','蚧','蚨','蚭','蚱', '蚳','蚴','蚵','蚷','蚸','蚹','蚿','蛀', */
	/* 8fdae0 */ 0x86c1,0x86c3,0x86c5,0x86d1,0x86d2,0x86d5,0x86d7,0x86da, 0x86dc,0x86e0,0x86e3,0x86e5,0x86e7,0x8688,0x86fa,0x86fc, /* '蛁','蛃','蛅','蛑','蛒','蛕','蛗','蛚', '蛜','蛠','蛣','蛥','蛧','蚈','蛺','蛼', */
	/* 8fdaf0 */ 0x86fd,0x8704,0x8705,0x8707,0x870b,0x870e,0x870f,0x8710, 0x8713,0x8714,0x8719,0x871e,0x871f,0x8721,0x8723,0, /* '蛽','蜄','蜅','蜇','蜋','蜎','蜏','蜐', '蜓','蜔','蜙','蜞','蜟','蜡','蜣',0, */
	/* 8fdb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdba0 */ 0,0x8728,0x872e,0x872f,0x8731,0x8732,0x8739,0x873a, 0x873c,0x873d,0x873e,0x8740,0x8743,0x8745,0x874d,0x8758, /* 0,'蜨','蜮','蜯','蜱','蜲','蜹','蜺', '蜼','蜽','蜾','蝀','蝃','蝅','蝍','蝘', */
	/* 8fdbb0 */ 0x875d,0x8761,0x8764,0x8765,0x876f,0x8771,0x8772,0x877b, 0x8783,0x8784,0x8785,0x8786,0x8787,0x8788,0x8789,0x878b, /* '蝝','蝡','蝤','蝥','蝯','蝱','蝲','蝻', '螃','螄','螅','螆','螇','螈','螉','螋', */
	/* 8fdbc0 */ 0x878c,0x8790,0x8793,0x8795,0x8797,0x8798,0x8799,0x879e, 0x87a0,0x87a3,0x87a7,0x87ac,0x87ad,0x87ae,0x87b1,0x87b5, /* '螌','螐','螓','螕','螗','螘','螙','螞', '螠','螣','螧','螬','螭','螮','螱','螵', */
	/* 8fdbd0 */ 0x87be,0x87bf,0x87c1,0x87c8,0x87c9,0x87ca,0x87ce,0x87d5, 0x87d6,0x87d9,0x87da,0x87dc,0x87df,0x87e2,0x87e3,0x87e4, /* '螾','螿','蟁','蟈','蟉','蟊','蟎','蟕', '蟖','蟙','蟚','蟜','蟟','蟢','蟣','蟤', */
	/* 8fdbe0 */ 0x87ea,0x87eb,0x87ed,0x87f1,0x87f3,0x87f8,0x87fa,0x87ff, 0x8801,0x8803,0x8806,0x8809,0x880a,0x880b,0x8810,0x8819, /* '蟪','蟫','蟭','蟱','蟳','蟸','蟺','蟿', '蠁','蠃','蠆','蠉','蠊','蠋','蠐','蠙', */
	/* 8fdbf0 */ 0x8812,0x8813,0x8814,0x8818,0x881a,0x881b,0x881c,0x881e, 0x881f,0x8828,0x882d,0x882e,0x8830,0x8832,0x8835,0, /* '蠒','蠓','蠔','蠘','蠚','蠛','蠜','蠞', '蠟','蠨','蠭','蠮','蠰','蠲','蠵',0, */
	/* 8fdc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdca0 */ 0,0x883a,0x883c,0x8841,0x8843,0x8845,0x8848,0x8849, 0x884a,0x884b,0x884e,0x8851,0x8855,0x8856,0x8858,0x885a, /* 0,'蠺','蠼','衁','衃','衅','衈','衉', '衊','衋','衎','衑','衕','衖','衘','衚', */
	/* 8fdcb0 */ 0x885c,0x885f,0x8860,0x8864,0x8869,0x8871,0x8879,0x887b, 0x8880,0x8898,0x889a,0x889b,0x889c,0x889f,0x88a0,0x88a8, /* '衜','衟','衠','衤','衩','衱','衹','衻', '袀','袘','袚','袛','袜','袟','袠','袨', */
	/* 8fdcc0 */ 0x88aa,0x88ba,0x88bd,0x88be,0x88c0,0x88ca,0x88cb,0x88cc, 0x88cd,0x88ce,0x88d1,0x88d2,0x88d3,0x88db,0x88de,0x88e7, /* '袪','袺','袽','袾','裀','裊','裋','裌', '裍','裎','裑','裒','裓','裛','裞','裧', */
	/* 8fdcd0 */ 0x88ef,0x88f0,0x88f1,0x88f5,0x88f7,0x8901,0x8906,0x890d, 0x890e,0x890f,0x8915,0x8916,0x8918,0x8919,0x891a,0x891c, /* '裯','裰','裱','裵','裷','褁','褆','褍', '褎','褏','褕','褖','褘','褙','褚','褜', */
	/* 8fdce0 */ 0x8920,0x8926,0x8927,0x8928,0x8930,0x8931,0x8932,0x8935, 0x8939,0x893a,0x893e,0x8940,0x8942,0x8945,0x8946,0x8949, /* '褠','褦','褧','褨','褰','褱','褲','褵', '褹','褺','褾','襀','襂','襅','襆','襉', */
	/* 8fdcf0 */ 0x894f,0x8952,0x8957,0x895a,0x895b,0x895c,0x8961,0x8962, 0x8963,0x896b,0x896e,0x8970,0x8973,0x8975,0x897a,0, /* '襏','襒','襗','襚','襛','襜','襡','襢', '襣','襫','襮','襰','襳','襵','襺',0, */
	/* 8fdd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdda0 */ 0,0x897b,0x897c,0x897d,0x8989,0x898d,0x8990,0x8994, 0x8995,0x899b,0x899c,0x899f,0x89a0,0x89a5,0x89b0,0x89b4, /* 0,'襻','襼','襽','覉','覍','覐','覔', '覕','覛','覜','覟','覠','覥','覰','覴', */
	/* 8fddb0 */ 0x89b5,0x89b6,0x89b7,0x89bc,0x89d4,0x89d5,0x89d6,0x89d7, 0x89d8,0x89e5,0x89e9,0x89eb,0x89ed,0x89f1,0x89f3,0x89f6, /* '覵','覶','覷','覼','觔','觕','觖','觗', '觘','觥','觩','觫','觭','觱','觳','觶', */
	/* 8fddc0 */ 0x89f9,0x89fd,0x89ff,0x8a04,0x8a05,0x8a07,0x8a0f,0x8a11, 0x8a12,0x8a14,0x8a15,0x8a1e,0x8a20,0x8a22,0x8a24,0x8a26, /* '觹','觽','觿','訄','訅','訇','訏','訑', '訒','訔','訕','訞','訠','訢','訤','訦', */
	/* 8fddd0 */ 0x8a2b,0x8a2c,0x8a2f,0x8a35,0x8a37,0x8a3d,0x8a3e,0x8a40, 0x8a43,0x8a45,0x8a47,0x8a49,0x8a4d,0x8a4e,0x8a53,0x8a56, /* '訫','訬','訯','訵','訷','訽','訾','詀', '詃','詅','詇','詉','詍','詎','詓','詖', */
	/* 8fdde0 */ 0x8a57,0x8a58,0x8a5c,0x8a5d,0x8a61,0x8a65,0x8a67,0x8a75, 0x8a76,0x8a77,0x8a79,0x8a7a,0x8a7b,0x8a7e,0x8a7f,0x8a80, /* '詗','詘','詜','詝','詡','詥','詧','詵', '詶','詷','詹','詺','詻','詾','詿','誀', */
	/* 8fddf0 */ 0x8a83,0x8a86,0x8a8b,0x8a8f,0x8a90,0x8a92,0x8a96,0x8a97, 0x8a99,0x8a9f,0x8aa7,0x8aa9,0x8aae,0x8aaf,0x8ab3,0, /* '誃','誆','誋','誏','誐','誒','誖','誗', '誙','誟','誧','誩','誮','誯','誳',0, */
	/* 8fde00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fde90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdea0 */ 0,0x8ab6,0x8ab7,0x8abb,0x8abe,0x8ac3,0x8ac6,0x8ac8, 0x8ac9,0x8aca,0x8ad1,0x8ad3,0x8ad4,0x8ad5,0x8ad7,0x8add, /* 0,'誶','誷','誻','誾','諃','諆','諈', '諉','諊','諑','諓','諔','諕','諗','諝', */
	/* 8fdeb0 */ 0x8adf,0x8aec,0x8af0,0x8af4,0x8af5,0x8af6,0x8afc,0x8aff, 0x8b05,0x8b06,0x8b0b,0x8b11,0x8b1c,0x8b1e,0x8b1f,0x8b0a, /* '諟','諬','諰','諴','諵','諶','諼','諿', '謅','謆','謋','謑','謜','謞','謟','謊', */
	/* 8fdec0 */ 0x8b2d,0x8b30,0x8b37,0x8b3c,0x8b42,0x8b43,0x8b44,0x8b45, 0x8b46,0x8b48,0x8b52,0x8b53,0x8b54,0x8b59,0x8b4d,0x8b5e, /* '謭','謰','謷','謼','譂','譃','譄','譅', '譆','譈','譒','譓','譔','譙','譍','譞', */
	/* 8fded0 */ 0x8b63,0x8b6d,0x8b76,0x8b78,0x8b79,0x8b7c,0x8b7e,0x8b81, 0x8b84,0x8b85,0x8b8b,0x8b8d,0x8b8f,0x8b94,0x8b95,0x8b9c, /* '譣','譭','譶','譸','譹','譼','譾','讁', '讄','讅','讋','讍','讏','讔','讕','讜', */
	/* 8fdee0 */ 0x8b9e,0x8b9f,0x8c38,0x8c39,0x8c3d,0x8c3e,0x8c45,0x8c47, 0x8c49,0x8c4b,0x8c4f,0x8c51,0x8c53,0x8c54,0x8c57,0x8c58, /* '讞','讟','谸','谹','谽','谾','豅','豇', '豉','豋','豏','豑','豓','豔','豗','豘', */
	/* 8fdef0 */ 0x8c5b,0x8c5d,0x8c59,0x8c63,0x8c64,0x8c66,0x8c68,0x8c69, 0x8c6d,0x8c73,0x8c75,0x8c76,0x8c7b,0x8c7e,0x8c86,0, /* '豛','豝','豙','豣','豤','豦','豨','豩', '豭','豳','豵','豶','豻','豾','貆',0, */
	/* 8fdf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fdfa0 */ 0,0x8c87,0x8c8b,0x8c90,0x8c92,0x8c93,0x8c99,0x8c9b, 0x8c9c,0x8ca4,0x8cb9,0x8cba,0x8cc5,0x8cc6,0x8cc9,0x8ccb, /* 0,'貇','貋','貐','貒','貓','貙','貛', '貜','貤','貹','貺','賅','賆','賉','賋', */
	/* 8fdfb0 */ 0x8ccf,0x8cd6,0x8cd5,0x8cd9,0x8cdd,0x8ce1,0x8ce8,0x8cec, 0x8cef,0x8cf0,0x8cf2,0x8cf5,0x8cf7,0x8cf8,0x8cfe,0x8cff, /* '賏','賖','賕','賙','賝','賡','賨','賬', '賯','賰','賲','賵','賷','賸','賾','賿', */
	/* 8fdfc0 */ 0x8d01,0x8d03,0x8d09,0x8d12,0x8d17,0x8d1b,0x8d65,0x8d69, 0x8d6c,0x8d6e,0x8d7f,0x8d82,0x8d84,0x8d88,0x8d8d,0x8d90, /* '贁','贃','贉','贒','贗','贛','赥','赩', '赬','赮','赿','趂','趄','趈','趍','趐', */
	/* 8fdfd0 */ 0x8d91,0x8d95,0x8d9e,0x8d9f,0x8da0,0x8da6,0x8dab,0x8dac, 0x8daf,0x8db2,0x8db5,0x8db7,0x8db9,0x8dbb,0x8dc0,0x8dc5, /* '趑','趕','趞','趟','趠','趦','趫','趬', '趯','趲','趵','趷','趹','趻','跀','跅', */
	/* 8fdfe0 */ 0x8dc6,0x8dc7,0x8dc8,0x8dca,0x8dce,0x8dd1,0x8dd4,0x8dd5, 0x8dd7,0x8dd9,0x8de4,0x8de5,0x8de7,0x8dec,0x8df0,0x8dbc, /* '跆','跇','跈','跊','跎','跑','跔','跕', '跗','跙','跤','跥','跧','跬','跰','趼', */
	/* 8fdff0 */ 0x8df1,0x8df2,0x8df4,0x8dfd,0x8e01,0x8e04,0x8e05,0x8e06, 0x8e0b,0x8e11,0x8e14,0x8e16,0x8e20,0x8e21,0x8e22,0, /* '跱','跲','跴','跽','踁','踄','踅','踆', '踋','踑','踔','踖','踠','踡','踢',0, */
	/* 8fe000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe0a0 */ 0,0x8e23,0x8e26,0x8e27,0x8e31,0x8e33,0x8e36,0x8e37, 0x8e38,0x8e39,0x8e3d,0x8e40,0x8e41,0x8e4b,0x8e4d,0x8e4e, /* 0,'踣','踦','踧','踱','踳','踶','踷', '踸','踹','踽','蹀','蹁','蹋','蹍','蹎', */
	/* 8fe0b0 */ 0x8e4f,0x8e54,0x8e5b,0x8e5c,0x8e5d,0x8e5e,0x8e61,0x8e62, 0x8e69,0x8e6c,0x8e6d,0x8e6f,0x8e70,0x8e71,0x8e79,0x8e7a, /* '蹏','蹔','蹛','蹜','蹝','蹞','蹡','蹢', '蹩','蹬','蹭','蹯','蹰','蹱','蹹','蹺', */
	/* 8fe0c0 */ 0x8e7b,0x8e82,0x8e83,0x8e89,0x8e90,0x8e92,0x8e95,0x8e9a, 0x8e9b,0x8e9d,0x8e9e,0x8ea2,0x8ea7,0x8ea9,0x8ead,0x8eae, /* '蹻','躂','躃','躉','躐','躒','躕','躚', '躛','躝','躞','躢','躧','躩','躭','躮', */
	/* 8fe0d0 */ 0x8eb3,0x8eb5,0x8eba,0x8ebb,0x8ec0,0x8ec1,0x8ec3,0x8ec4, 0x8ec7,0x8ecf,0x8ed1,0x8ed4,0x8edc,0x8ee8,0x8eee,0x8ef0, /* '躳','躵','躺','躻','軀','軁','軃','軄', '軇','軏','軑','軔','軜','軨','軮','軰', */
	/* 8fe0e0 */ 0x8ef1,0x8ef7,0x8ef9,0x8efa,0x8eed,0x8f00,0x8f02,0x8f07, 0x8f08,0x8f0f,0x8f10,0x8f16,0x8f17,0x8f18,0x8f1e,0x8f20, /* '軱','軷','軹','軺','軭','輀','輂','輇', '輈','輏','輐','輖','輗','輘','輞','輠', */
	/* 8fe0f0 */ 0x8f21,0x8f23,0x8f25,0x8f27,0x8f28,0x8f2c,0x8f2d,0x8f2e, 0x8f34,0x8f35,0x8f36,0x8f37,0x8f3a,0x8f40,0x8f41,0, /* '輡','輣','輥','輧','輨','輬','輭','輮', '輴','輵','輶','輷','輺','轀','轁',0, */
	/* 8fe100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe1a0 */ 0,0x8f43,0x8f47,0x8f4f,0x8f51,0x8f52,0x8f53,0x8f54, 0x8f55,0x8f58,0x8f5d,0x8f5e,0x8f65,0x8f9d,0x8fa0,0x8fa1, /* 0,'轃','轇','轏','轑','轒','轓','轔', '轕','轘','轝','轞','轥','辝','辠','辡', */
	/* 8fe1b0 */ 0x8fa4,0x8fa5,0x8fa6,0x8fb5,0x8fb6,0x8fb8,0x8fbe,0x8fc0, 0x8fc1,0x8fc6,0x8fca,0x8fcb,0x8fcd,0x8fd0,0x8fd2,0x8fd3, /* '辤','辥','辦','辵','辶','辸','达','迀', '迁','迆','迊','迋','迍','运','迒','迓', */
	/* 8fe1c0 */ 0x8fd5,0x8fe0,0x8fe3,0x8fe4,0x8fe8,0x8fee,0x8ff1,0x8ff5, 0x8ff6,0x8ffb,0x8ffe,0x9002,0x9004,0x9008,0x900c,0x9018, /* '迕','迠','迣','迤','迨','迮','迱','迵', '迶','迻','迾','适','逄','逈','逌','逘', */
	/* 8fe1d0 */ 0x901b,0x9028,0x9029,0x902f,0x902a,0x902c,0x902d,0x9033, 0x9034,0x9037,0x903f,0x9043,0x9044,0x904c,0x905b,0x905d, /* '逛','逨','逩','逯','逪','逬','逭','逳', '逴','逷','逿','遃','遄','遌','遛','遝', */
	/* 8fe1e0 */ 0x9062,0x9066,0x9067,0x906c,0x9070,0x9074,0x9079,0x9085, 0x9088,0x908b,0x908c,0x908e,0x9090,0x9095,0x9097,0x9098, /* '遢','遦','遧','遬','遰','遴','遹','邅', '邈','邋','邌','邎','邐','邕','邗','邘', */
	/* 8fe1f0 */ 0x9099,0x909b,0x90a0,0x90a1,0x90a2,0x90a5,0x90b0,0x90b2, 0x90b3,0x90b4,0x90b6,0x90bd,0x90cc,0x90be,0x90c3,0, /* '邙','邛','邠','邡','邢','邥','邰','邲', '邳','邴','邶','邽','郌','邾','郃',0, */
	/* 8fe200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe2a0 */ 0,0x90c4,0x90c5,0x90c7,0x90c8,0x90d5,0x90d7,0x90d8, 0x90d9,0x90dc,0x90dd,0x90df,0x90e5,0x90d2,0x90f6,0x90eb, /* 0,'郄','郅','郇','郈','郕','郗','郘', '郙','郜','郝','郟','郥','郒','郶','郫', */
	/* 8fe2b0 */ 0x90ef,0x90f0,0x90f4,0x90fe,0x90ff,0x9100,0x9104,0x9105, 0x9106,0x9108,0x910d,0x9110,0x9114,0x9116,0x9117,0x9118, /* '郯','郰','郴','郾','郿','鄀','鄄','鄅', '鄆','鄈','鄍','鄐','鄔','鄖','鄗','鄘', */
	/* 8fe2c0 */ 0x911a,0x911c,0x911e,0x9120,0x9125,0x9122,0x9123,0x9127, 0x9129,0x912e,0x912f,0x9131,0x9134,0x9136,0x9137,0x9139, /* '鄚','鄜','鄞','鄠','鄥','鄢','鄣','鄧', '鄩','鄮','鄯','鄱','鄴','鄶','鄷','鄹', */
	/* 8fe2d0 */ 0x913a,0x913c,0x913d,0x9143,0x9147,0x9148,0x914f,0x9153, 0x9157,0x9159,0x915a,0x915b,0x9161,0x9164,0x9167,0x916d, /* '鄺','鄼','鄽','酃','酇','酈','酏','酓', '酗','酙','酚','酛','酡','酤','酧','酭', */
	/* 8fe2e0 */ 0x9174,0x9179,0x917a,0x917b,0x9181,0x9183,0x9185,0x9186, 0x918a,0x918e,0x9191,0x9193,0x9194,0x9195,0x9198,0x919e, /* '酴','酹','酺','酻','醁','醃','醅','醆', '醊','醎','醑','醓','醔','醕','醘','醞', */
	/* 8fe2f0 */ 0x91a1,0x91a6,0x91a8,0x91ac,0x91ad,0x91ae,0x91b0,0x91b1, 0x91b2,0x91b3,0x91b6,0x91bb,0x91bc,0x91bd,0x91bf,0, /* '醡','醦','醨','醬','醭','醮','醰','醱', '醲','醳','醶','醻','醼','醽','醿',0, */
	/* 8fe300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe3a0 */ 0,0x91c2,0x91c3,0x91c5,0x91d3,0x91d4,0x91d7,0x91d9, 0x91da,0x91de,0x91e4,0x91e5,0x91e9,0x91ea,0x91ec,0x91ed, /* 0,'釂','釃','釅','釓','釔','釗','釙', '釚','釞','釤','釥','釩','釪','釬','釭', */
	/* 8fe3b0 */ 0x91ee,0x91ef,0x91f0,0x91f1,0x91f7,0x91f9,0x91fb,0x91fd, 0x9200,0x9201,0x9204,0x9205,0x9206,0x9207,0x9209,0x920a, /* '釮','釯','釰','釱','釷','釹','釻','釽', '鈀','鈁','鈄','鈅','鈆','鈇','鈉','鈊', */
	/* 8fe3c0 */ 0x920c,0x9210,0x9212,0x9213,0x9216,0x9218,0x921c,0x921d, 0x9223,0x9224,0x9225,0x9226,0x9228,0x922e,0x922f,0x9230, /* '鈌','鈐','鈒','鈓','鈖','鈘','鈜','鈝', '鈣','鈤','鈥','鈦','鈨','鈮','鈯','鈰', */
	/* 8fe3d0 */ 0x9233,0x9235,0x9236,0x9238,0x9239,0x923a,0x923c,0x923e, 0x9240,0x9242,0x9243,0x9246,0x9247,0x924a,0x924d,0x924e, /* '鈳','鈵','鈶','鈸','鈹','鈺','鈼','鈾', '鉀','鉂','鉃','鉆','鉇','鉊','鉍','鉎', */
	/* 8fe3e0 */ 0x924f,0x9251,0x9258,0x9259,0x925c,0x925d,0x9260,0x9261, 0x9265,0x9267,0x9268,0x9269,0x926e,0x926f,0x9270,0x9275, /* '鉏','鉑','鉘','鉙','鉜','鉝','鉠','鉡', '鉥','鉧','鉨','鉩','鉮','鉯','鉰','鉵', */
	/* 8fe3f0 */ 0x9276,0x9277,0x9278,0x9279,0x927b,0x927c,0x927d,0x927f, 0x9288,0x9289,0x928a,0x928d,0x928e,0x9292,0x9297,0, /* '鉶','鉷','鉸','鉹','鉻','鉼','鉽','鉿', '銈','銉','銊','銍','銎','銒','銗',0, */
	/* 8fe400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe4a0 */ 0,0x9299,0x929f,0x92a0,0x92a4,0x92a5,0x92a7,0x92a8, 0x92ab,0x92af,0x92b2,0x92b6,0x92b8,0x92ba,0x92bb,0x92bc, /* 0,'銙','銟','銠','銤','銥','銧','銨', '銫','銯','銲','銶','銸','銺','銻','銼', */
	/* 8fe4b0 */ 0x92bd,0x92bf,0x92c0,0x92c1,0x92c2,0x92c3,0x92c5,0x92c6, 0x92c7,0x92c8,0x92cb,0x92cc,0x92cd,0x92ce,0x92d0,0x92d3, /* '銽','銿','鋀','鋁','鋂','鋃','鋅','鋆', '鋇','鋈','鋋','鋌','鋍','鋎','鋐','鋓', */
	/* 8fe4c0 */ 0x92d5,0x92d7,0x92d8,0x92d9,0x92dc,0x92dd,0x92df,0x92e0, 0x92e1,0x92e3,0x92e5,0x92e7,0x92e8,0x92ec,0x92ee,0x92f0, /* '鋕','鋗','鋘','鋙','鋜','鋝','鋟','鋠', '鋡','鋣','鋥','鋧','鋨','鋬','鋮','鋰', */
	/* 8fe4d0 */ 0x92f9,0x92fb,0x92ff,0x9300,0x9302,0x9308,0x930d,0x9311, 0x9314,0x9315,0x931c,0x931d,0x931e,0x931f,0x9321,0x9324, /* '鋹','鋻','鋿','錀','錂','錈','錍','錑', '錔','錕','錜','錝','錞','錟','錡','錤', */
	/* 8fe4e0 */ 0x9325,0x9327,0x9329,0x932a,0x9333,0x9334,0x9336,0x9337, 0x9347,0x9348,0x9349,0x9350,0x9351,0x9352,0x9355,0x9357, /* '錥','錧','錩','錪','錳','錴','錶','錷', '鍇','鍈','鍉','鍐','鍑','鍒','鍕','鍗', */
	/* 8fe4f0 */ 0x9358,0x935a,0x935e,0x9364,0x9365,0x9367,0x9369,0x936a, 0x936d,0x936f,0x9370,0x9371,0x9373,0x9374,0x9376,0, /* '鍘','鍚','鍞','鍤','鍥','鍧','鍩','鍪', '鍭','鍯','鍰','鍱','鍳','鍴','鍶',0, */
	/* 8fe500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe5a0 */ 0,0x937a,0x937d,0x937f,0x9380,0x9381,0x9382,0x9388, 0x938a,0x938b,0x938d,0x938f,0x9392,0x9395,0x9398,0x939b, /* 0,'鍺','鍽','鍿','鎀','鎁','鎂','鎈', '鎊','鎋','鎍','鎏','鎒','鎕','鎘','鎛', */
	/* 8fe5b0 */ 0x939e,0x93a1,0x93a3,0x93a4,0x93a6,0x93a8,0x93ab,0x93b4, 0x93b5,0x93b6,0x93ba,0x93a9,0x93c1,0x93c4,0x93c5,0x93c6, /* '鎞','鎡','鎣','鎤','鎦','鎨','鎫','鎴', '鎵','鎶','鎺','鎩','鏁','鏄','鏅','鏆', */
	/* 8fe5c0 */ 0x93c7,0x93c9,0x93ca,0x93cb,0x93cc,0x93cd,0x93d3,0x93d9, 0x93dc,0x93de,0x93df,0x93e2,0x93e6,0x93e7,0x93f9,0x93f7, /* '鏇','鏉','鏊','鏋','鏌','鏍','鏓','鏙', '鏜','鏞','鏟','鏢','鏦','鏧','鏹','鏷', */
	/* 8fe5d0 */ 0x93f8,0x93fa,0x93fb,0x93fd,0x9401,0x9402,0x9404,0x9408, 0x9409,0x940d,0x940e,0x940f,0x9415,0x9416,0x9417,0x941f, /* '鏸','鏺','鏻','鏽','鐁','鐂','鐄','鐈', '鐉','鐍','鐎','鐏','鐕','鐖','鐗','鐟', */
	/* 8fe5e0 */ 0x942e,0x942f,0x9431,0x9432,0x9433,0x9434,0x943b,0x943f, 0x943d,0x9443,0x9445,0x9448,0x944a,0x944c,0x9455,0x9459, /* '鐮','鐯','鐱','鐲','鐳','鐴','鐻','鐿', '鐽','鑃','鑅','鑈','鑊','鑌','鑕','鑙', */
	/* 8fe5f0 */ 0x945c,0x945f,0x9461,0x9463,0x9468,0x946b,0x946d,0x946e, 0x946f,0x9471,0x9472,0x9484,0x9483,0x9578,0x9579,0, /* '鑜','鑟','鑡','鑣','鑨','鑫','鑭','鑮', '鑯','鑱','鑲','钄','钃','镸','镹',0, */
	/* 8fe600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe6a0 */ 0,0x957e,0x9584,0x9588,0x958c,0x958d,0x958e,0x959d, 0x959e,0x959f,0x95a1,0x95a6,0x95a9,0x95ab,0x95ac,0x95b4, /* 0,'镾','閄','閈','閌','閍','閎','閝', '閞','閟','閡','閦','閩','閫','閬','閴', */
	/* 8fe6b0 */ 0x95b6,0x95ba,0x95bd,0x95bf,0x95c6,0x95c8,0x95c9,0x95cb, 0x95d0,0x95d1,0x95d2,0x95d3,0x95d9,0x95da,0x95dd,0x95de, /* '閶','閺','閽','閿','闆','闈','闉','闋', '闐','闑','闒','闓','闙','闚','闝','闞', */
	/* 8fe6c0 */ 0x95df,0x95e0,0x95e4,0x95e6,0x961d,0x961e,0x9622,0x9624, 0x9625,0x9626,0x962c,0x9631,0x9633,0x9637,0x9638,0x9639, /* '闟','闠','闤','闦','阝','阞','阢','阤', '阥','阦','阬','阱','阳','阷','阸','阹', */
	/* 8fe6d0 */ 0x963a,0x963c,0x963d,0x9641,0x9652,0x9654,0x9656,0x9657, 0x9658,0x9661,0x966e,0x9674,0x967b,0x967c,0x967e,0x967f, /* '阺','阼','阽','陁','陒','陔','陖','陗', '陘','陡','陮','陴','陻','陼','陾','陿', */
	/* 8fe6e0 */ 0x9681,0x9682,0x9683,0x9684,0x9689,0x9691,0x9696,0x969a, 0x969d,0x969f,0x96a4,0x96a5,0x96a6,0x96a9,0x96ae,0x96af, /* '隁','隂','隃','隄','隉','隑','隖','隚', '隝','隟','隤','隥','隦','隩','隮','隯', */
	/* 8fe6f0 */ 0x96b3,0x96ba,0x96ca,0x96d2,0x5db2,0x96d8,0x96da,0x96dd, 0x96de,0x96df,0x96e9,0x96ef,0x96f1,0x96fa,0x9702,0, /* '隳','隺','雊','雒','嶲','雘','雚','雝', '雞','雟','雩','雯','雱','雺','霂',0, */
	/* 8fe700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe7a0 */ 0,0x9703,0x9705,0x9709,0x971a,0x971b,0x971d,0x9721, 0x9722,0x9723,0x9728,0x9731,0x9733,0x9741,0x9743,0x974a, /* 0,'霃','霅','霉','霚','霛','霝','霡', '霢','霣','霨','霱','霳','靁','靃','靊', */
	/* 8fe7b0 */ 0x974e,0x974f,0x9755,0x9757,0x9758,0x975a,0x975b,0x9763, 0x9767,0x976a,0x976e,0x9773,0x9776,0x9777,0x9778,0x977b, /* '靎','靏','靕','靗','靘','靚','靛','靣', '靧','靪','靮','靳','靶','靷','靸','靻', */
	/* 8fe7c0 */ 0x977d,0x977f,0x9780,0x9789,0x9795,0x9796,0x9797,0x9799, 0x979a,0x979e,0x979f,0x97a2,0x97ac,0x97ae,0x97b1,0x97b2, /* '靽','靿','鞀','鞉','鞕','鞖','鞗','鞙', '鞚','鞞','鞟','鞢','鞬','鞮','鞱','鞲', */
	/* 8fe7d0 */ 0x97b5,0x97b6,0x97b8,0x97b9,0x97ba,0x97bc,0x97be,0x97bf, 0x97c1,0x97c4,0x97c5,0x97c7,0x97c9,0x97ca,0x97cc,0x97cd, /* '鞵','鞶','鞸','鞹','鞺','鞼','鞾','鞿', '韁','韄','韅','韇','韉','韊','韌','韍', */
	/* 8fe7e0 */ 0x97ce,0x97d0,0x97d1,0x97d4,0x97d7,0x97d8,0x97d9,0x97dd, 0x97de,0x97e0,0x97db,0x97e1,0x97e4,0x97ef,0x97f1,0x97f4, /* '韎','韐','韑','韔','韗','韘','韙','韝', '韞','韠','韛','韡','韤','韯','韱','韴', */
	/* 8fe7f0 */ 0x97f7,0x97f8,0x97fa,0x9807,0x980a,0x9819,0x980d,0x980e, 0x9814,0x9816,0x981c,0x981e,0x9820,0x9823,0x9826,0, /* '韷','韸','韺','頇','頊','頙','頍','頎', '頔','頖','頜','頞','頠','頣','頦',0, */
	/* 8fe800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe8a0 */ 0,0x982b,0x982e,0x982f,0x9830,0x9832,0x9833,0x9835, 0x9825,0x983e,0x9844,0x9847,0x984a,0x9851,0x9852,0x9853, /* 0,'頫','頮','頯','頰','頲','頳','頵', '頥','頾','顄','顇','顊','顑','顒','顓', */
	/* 8fe8b0 */ 0x9856,0x9857,0x9859,0x985a,0x9862,0x9863,0x9865,0x9866, 0x986a,0x986c,0x98ab,0x98ad,0x98ae,0x98b0,0x98b4,0x98b7, /* '顖','顗','顙','顚','顢','顣','顥','顦', '顪','顬','颫','颭','颮','颰','颴','颷', */
	/* 8fe8c0 */ 0x98b8,0x98ba,0x98bb,0x98bf,0x98c2,0x98c5,0x98c8,0x98cc, 0x98e1,0x98e3,0x98e5,0x98e6,0x98e7,0x98ea,0x98f3,0x98f6, /* '颸','颺','颻','颿','飂','飅','飈','飌', '飡','飣','飥','飦','飧','飪','飳','飶', */
	/* 8fe8d0 */ 0x9902,0x9907,0x9908,0x9911,0x9915,0x9916,0x9917,0x991a, 0x991b,0x991c,0x991f,0x9922,0x9926,0x9927,0x992b,0x9931, /* '餂','餇','餈','餑','餕','餖','餗','餚', '餛','餜','餟','餢','餦','餧','餫','餱', */
	/* 8fe8e0 */ 0x9932,0x9933,0x9934,0x9935,0x9939,0x993a,0x993b,0x993c, 0x9940,0x9941,0x9946,0x9947,0x9948,0x994d,0x994e,0x9954, /* '餲','餳','餴','餵','餹','餺','餻','餼', '饀','饁','饆','饇','饈','饍','饎','饔', */
	/* 8fe8f0 */ 0x9958,0x9959,0x995b,0x995c,0x995e,0x995f,0x9960,0x999b, 0x999d,0x999f,0x99a6,0x99b0,0x99b1,0x99b2,0x99b5,0, /* '饘','饙','饛','饜','饞','饟','饠','馛', '馝','馟','馦','馰','馱','馲','馵',0, */
	/* 8fe900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fe9a0 */ 0,0x99b9,0x99ba,0x99bd,0x99bf,0x99c3,0x99c9,0x99d3, 0x99d4,0x99d9,0x99da,0x99dc,0x99de,0x99e7,0x99ea,0x99eb, /* 0,'馹','馺','馽','馿','駃','駉','駓', '駔','駙','駚','駜','駞','駧','駪','駫', */
	/* 8fe9b0 */ 0x99ec,0x99f0,0x99f4,0x99f5,0x99f9,0x99fd,0x99fe,0x9a02, 0x9a03,0x9a04,0x9a0b,0x9a0c,0x9a10,0x9a11,0x9a16,0x9a1e, /* '駬','駰','駴','駵','駹','駽','駾','騂', '騃','騄','騋','騌','騐','騑','騖','騞', */
	/* 8fe9c0 */ 0x9a20,0x9a22,0x9a23,0x9a24,0x9a27,0x9a2d,0x9a2e,0x9a33, 0x9a35,0x9a36,0x9a38,0x9a47,0x9a41,0x9a44,0x9a4a,0x9a4b, /* '騠','騢','騣','騤','騧','騭','騮','騳', '騵','騶','騸','驇','驁','驄','驊','驋', */
	/* 8fe9d0 */ 0x9a4c,0x9a4e,0x9a51,0x9a54,0x9a56,0x9a5d,0x9aaa,0x9aac, 0x9aae,0x9aaf,0x9ab2,0x9ab4,0x9ab5,0x9ab6,0x9ab9,0x9abb, /* '驌','驎','驑','驔','驖','驝','骪','骬', '骮','骯','骲','骴','骵','骶','骹','骻', */
	/* 8fe9e0 */ 0x9abe,0x9abf,0x9ac1,0x9ac3,0x9ac6,0x9ac8,0x9ace,0x9ad0, 0x9ad2,0x9ad5,0x9ad6,0x9ad7,0x9adb,0x9adc,0x9ae0,0x9ae4, /* '骾','骿','髁','髃','髆','髈','髎','髐', '髒','髕','髖','髗','髛','髜','髠','髤', */
	/* 8fe9f0 */ 0x9ae5,0x9ae7,0x9ae9,0x9aec,0x9af2,0x9af3,0x9af5,0x9af9, 0x9afa,0x9afd,0x9aff,0x9b00,0x9b01,0x9b02,0x9b03,0, /* '髥','髧','髩','髬','髲','髳','髵','髹', '髺','髽','髿','鬀','鬁','鬂','鬃',0, */
	/* 8fea00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fea90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feaa0 */ 0,0x9b04,0x9b05,0x9b08,0x9b09,0x9b0b,0x9b0c,0x9b0d, 0x9b0e,0x9b10,0x9b12,0x9b16,0x9b19,0x9b1b,0x9b1c,0x9b20, /* 0,'鬄','鬅','鬈','鬉','鬋','鬌','鬍', '鬎','鬐','鬒','鬖','鬙','鬛','鬜','鬠', */
	/* 8feab0 */ 0x9b26,0x9b2b,0x9b2d,0x9b33,0x9b34,0x9b35,0x9b37,0x9b39, 0x9b3a,0x9b3d,0x9b48,0x9b4b,0x9b4c,0x9b55,0x9b56,0x9b57, /* '鬦','鬫','鬭','鬳','鬴','鬵','鬷','鬹', '鬺','鬽','魈','魋','魌','魕','魖','魗', */
	/* 8feac0 */ 0x9b5b,0x9b5e,0x9b61,0x9b63,0x9b65,0x9b66,0x9b68,0x9b6a, 0x9b6b,0x9b6c,0x9b6d,0x9b6e,0x9b73,0x9b75,0x9b77,0x9b78, /* '魛','魞','魡','魣','魥','魦','魨','魪', '魫','魬','魭','魮','魳','魵','魷','魸', */
	/* 8fead0 */ 0x9b79,0x9b7f,0x9b80,0x9b84,0x9b85,0x9b86,0x9b87,0x9b89, 0x9b8a,0x9b8b,0x9b8d,0x9b8f,0x9b90,0x9b94,0x9b9a,0x9b9d, /* '魹','魿','鮀','鮄','鮅','鮆','鮇','鮉', '鮊','鮋','鮍','鮏','鮐','鮔','鮚','鮝', */
	/* 8feae0 */ 0x9b9e,0x9ba6,0x9ba7,0x9ba9,0x9bac,0x9bb0,0x9bb1,0x9bb2, 0x9bb7,0x9bb8,0x9bbb,0x9bbc,0x9bbe,0x9bbf,0x9bc1,0x9bc7, /* '鮞','鮦','鮧','鮩','鮬','鮰','鮱','鮲', '鮷','鮸','鮻','鮼','鮾','鮿','鯁','鯇', */
	/* 8feaf0 */ 0x9bc8,0x9bce,0x9bd0,0x9bd7,0x9bd8,0x9bdd,0x9bdf,0x9be5, 0x9be7,0x9bea,0x9beb,0x9bef,0x9bf3,0x9bf7,0x9bf8,0, /* '鯈','鯎','鯐','鯗','鯘','鯝','鯟','鯥', '鯧','鯪','鯫','鯯','鯳','鯷','鯸',0, */
	/* 8feb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feba0 */ 0,0x9bf9,0x9bfa,0x9bfd,0x9bff,0x9c00,0x9c02,0x9c0b, 0x9c0f,0x9c11,0x9c16,0x9c18,0x9c19,0x9c1a,0x9c1c,0x9c1e, /* 0,'鯹','鯺','鯽','鯿','鰀','鰂','鰋', '鰏','鰑','鰖','鰘','鰙','鰚','鰜','鰞', */
	/* 8febb0 */ 0x9c22,0x9c23,0x9c26,0x9c27,0x9c28,0x9c29,0x9c2a,0x9c31, 0x9c35,0x9c36,0x9c37,0x9c3d,0x9c41,0x9c43,0x9c44,0x9c45, /* '鰢','鰣','鰦','鰧','鰨','鰩','鰪','鰱', '鰵','鰶','鰷','鰽','鱁','鱃','鱄','鱅', */
	/* 8febc0 */ 0x9c49,0x9c4a,0x9c4e,0x9c4f,0x9c50,0x9c53,0x9c54,0x9c56, 0x9c58,0x9c5b,0x9c5d,0x9c5e,0x9c5f,0x9c63,0x9c69,0x9c6a, /* '鱉','鱊','鱎','鱏','鱐','鱓','鱔','鱖', '鱘','鱛','鱝','鱞','鱟','鱣','鱩','鱪', */
	/* 8febd0 */ 0x9c5c,0x9c6b,0x9c68,0x9c6e,0x9c70,0x9c72,0x9c75,0x9c77, 0x9c7b,0x9ce6,0x9cf2,0x9cf7,0x9cf9,0x9d0b,0x9d02,0x9d11, /* '鱜','鱫','鱨','鱮','鱰','鱲','鱵','鱷', '鱻','鳦','鳲','鳷','鳹','鴋','鴂','鴑', */
	/* 8febe0 */ 0x9d17,0x9d18,0x9d1c,0x9d1d,0x9d1e,0x9d2f,0x9d30,0x9d32, 0x9d33,0x9d34,0x9d3a,0x9d3c,0x9d45,0x9d3d,0x9d42,0x9d43, /* '鴗','鴘','鴜','鴝','鴞','鴯','鴰','鴲', '鴳','鴴','鴺','鴼','鵅','鴽','鵂','鵃', */
	/* 8febf0 */ 0x9d47,0x9d4a,0x9d53,0x9d54,0x9d5f,0x9d63,0x9d62,0x9d65, 0x9d69,0x9d6a,0x9d6b,0x9d70,0x9d76,0x9d77,0x9d7b,0, /* '鵇','鵊','鵓','鵔','鵟','鵣','鵢','鵥', '鵩','鵪','鵫','鵰','鵶','鵷','鵻',0, */
	/* 8fec00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fec90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feca0 */ 0,0x9d7c,0x9d7e,0x9d83,0x9d84,0x9d86,0x9d8a,0x9d8d, 0x9d8e,0x9d92,0x9d93,0x9d95,0x9d96,0x9d97,0x9d98,0x9da1, /* 0,'鵼','鵾','鶃','鶄','鶆','鶊','鶍', '鶎','鶒','鶓','鶕','鶖','鶗','鶘','鶡', */
	/* 8fecb0 */ 0x9daa,0x9dac,0x9dae,0x9db1,0x9db5,0x9db9,0x9dbc,0x9dbf, 0x9dc3,0x9dc7,0x9dc9,0x9dca,0x9dd4,0x9dd5,0x9dd6,0x9dd7, /* '鶪','鶬','鶮','鶱','鶵','鶹','鶼','鶿', '鷃','鷇','鷉','鷊','鷔','鷕','鷖','鷗', */
	/* 8fecc0 */ 0x9dda,0x9dde,0x9ddf,0x9de0,0x9de5,0x9de7,0x9de9,0x9deb, 0x9dee,0x9df0,0x9df3,0x9df4,0x9dfe,0x9e0a,0x9e02,0x9e07, /* '鷚','鷞','鷟','鷠','鷥','鷧','鷩','鷫', '鷮','鷰','鷳','鷴','鷾','鸊','鸂','鸇', */
	/* 8fecd0 */ 0x9e0e,0x9e10,0x9e11,0x9e12,0x9e15,0x9e16,0x9e19,0x9e1c, 0x9e1d,0x9e7a,0x9e7b,0x9e7c,0x9e80,0x9e82,0x9e83,0x9e84, /* '鸎','鸐','鸑','鸒','鸕','鸖','鸙','鸜', '鸝','鹺','鹻','鹼','麀','麂','麃','麄', */
	/* 8fece0 */ 0x9e85,0x9e87,0x9e8e,0x9e8f,0x9e96,0x9e98,0x9e9b,0x9e9e, 0x9ea4,0x9ea8,0x9eac,0x9eae,0x9eaf,0x9eb0,0x9eb3,0x9eb4, /* '麅','麇','麎','麏','麖','麘','麛','麞', '麤','麨','麬','麮','麯','麰','麳','麴', */
	/* 8fecf0 */ 0x9eb5,0x9ec6,0x9ec8,0x9ecb,0x9ed5,0x9edf,0x9ee4,0x9ee7, 0x9eec,0x9eed,0x9eee,0x9ef0,0x9ef1,0x9ef2,0x9ef5,0, /* '麵','黆','黈','黋','黕','黟','黤','黧', '黬','黭','黮','黰','黱','黲','黵',0, */
	/* 8fed00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fed90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feda0 */ 0,0x9ef8,0x9eff,0x9f02,0x9f03,0x9f09,0x9f0f,0x9f10, 0x9f11,0x9f12,0x9f14,0x9f16,0x9f17,0x9f19,0x9f1a,0x9f1b, /* 0,'黸','黿','鼂','鼃','鼉','鼏','鼐', '鼑','鼒','鼔','鼖','鼗','鼙','鼚','鼛', */
	/* 8fedb0 */ 0x9f1f,0x9f22,0x9f26,0x9f2a,0x9f2b,0x9f2f,0x9f31,0x9f32, 0x9f34,0x9f37,0x9f39,0x9f3a,0x9f3c,0x9f3d,0x9f3f,0x9f41, /* '鼟','鼢','鼦','鼪','鼫','鼯','鼱','鼲', '鼴','鼷','鼹','鼺','鼼','鼽','鼿','齁', */
	/* 8fedc0 */ 0x9f43,0x9f44,0x9f45,0x9f46,0x9f47,0x9f53,0x9f55,0x9f56, 0x9f57,0x9f58,0x9f5a,0x9f5d,0x9f5e,0x9f68,0x9f69,0x9f6d, /* '齃','齄','齅','齆','齇','齓','齕','齖', '齗','齘','齚','齝','齞','齨','齩','齭', */
	/* 8fedd0 */ 0x9f6e,0x9f6f,0x9f70,0x9f71,0x9f73,0x9f75,0x9f7a,0x9f7d, 0x9f8f,0x9f90,0x9f91,0x9f92,0x9f94,0x9f96,0x9f97,0x9f9e, /* '齮','齯','齰','齱','齳','齵','齺','齽', '龏','龐','龑','龒','龔','龖','龗','龞', */
	/* 8fede0 */ 0x9fa1,0x9fa2,0x9fa3,0x9fa5,0,0,0,0, 0,0,0,0,0,0,0,0, /* '龡','龢','龣','龥',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8fedf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fee90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fef90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fefa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fefb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fefc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fefd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8fefe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8feff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff3f0 */ 0,0,0,0x2170,0x2171,0x2172,0x2173,0x2174, 0x2175,0x2176,0x2177,0x2178,0x2179,0,0,0, /* 0,0,0,'ⅰ','ⅱ','ⅲ','ⅳ','ⅴ', 'ⅵ','ⅶ','ⅷ','ⅸ','ⅹ',0,0,0, */
	/* 8ff400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8ff4a0 */ 0,0,0,0,0,0,0,0, 0,0xff07,0xff02,0,0,0,0x70bb,0x4efc, /* 0,0,0,0,0,0,0,0, 0,'＇','＂',0,0,0,'炻','仼', */
	/* 8ff4b0 */ 0x50f4,0x51ec,0x5307,0x5324,0xfa0e,0x548a,0x5759,0xfa0f, 0xfa10,0x589e,0x5bec,0x5cf5,0x5d53,0xfa11,0x5fb7,0x6085, /* '僴','凬','匇','匤','﨎','咊','坙','﨏', '塚','增','寬','峵','嵓','﨑','德','悅', */
	/* 8ff4c0 */ 0x6120,0x654e,0x663b,0x6665,0xfa12,0xf929,0x6801,0xfa13, 0xfa14,0x6a6b,0x6ae2,0x6df8,0x6df2,0x7028,0xfa15,0xfa16, /* '愠','敎','昻','晥','晴','朗','栁','﨓', '﨔','橫','櫢','淸','淲','瀨','凞','猪', */
	/* 8ff4d0 */ 0x7501,0x7682,0x769e,0xfa17,0x7930,0xfa18,0xfa19,0xfa1a, 0xfa1b,0x7ae7,0xfa1c,0xfa1d,0x7da0,0x7dd6,0xfa1e,0x8362, /* '甁','皂','皞','益','礰','礼','神','祥', '福','竧','靖','精','綠','緖','羽','荢', */
	/* 8ff4e0 */ 0xfa1f,0x85b0,0xfa20,0xfa21,0x8807,0xfa22,0x8b7f,0x8cf4, 0x8d76,0xfa23,0xfa24,0xfa25,0x90de,0xfa26,0x9115,0xfa27, /* '﨟','薰','蘒','﨡','蠇','諸','譿','賴', '赶','﨣','﨤','逸','郞','都','鄕','﨧', */
	/* 8ff4f0 */ 0xfa28,0x9592,0xf9dc,0xfa29,0x973b,0x974d,0x9751,0xfa2a, 0xfa2b,0xfa2c,0x999e,0x9ad9,0x9b72,0xfa2d,0x9ed1, /* '﨨','閒','隆','﨩','霻','靍','靑','飯', '飼','館','馞','髙','魲','鶴','黑', */
};

const size_t _euc2unibems_table8f_size = sizeof(_euc2unibems_table8f) / sizeof(_euc2unibems_table8f[0]);

#endif /* #ifndef __EUC2UNIBEMS_TABLE8F_H_ */
