/*
 * _han_zen.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __HAN_ZEN_H_
#define __HAN_ZEN_H_

#define UTFBE_HAN_FF61	0xFF61	/* ｡ */
#define UTFBE_HAN_FF62	0xFF62	/* ｢ */
#define UTFBE_HAN_FF63	0xFF63	/* ｣ */
#define UTFBE_HAN_FF64	0xFF64	/* ､ */
#define UTFBE_HAN_FF65	0xFF65	/* ･ */
#define UTFBE_HAN_FF66	0xFF66	/* ｦ */
#define UTFBE_HAN_FF67	0xFF67	/* ｧ */
#define UTFBE_HAN_FF68	0xFF68	/* ｨ */
#define UTFBE_HAN_FF69	0xFF69	/* ｩ */
#define UTFBE_HAN_FF6A	0xFF6A	/* ｪ */
#define UTFBE_HAN_FF6B	0xFF6B	/* ｫ */
#define UTFBE_HAN_FF6C	0xFF6C	/* ｬ */
#define UTFBE_HAN_FF6D	0xFF6D	/* ｭ */
#define UTFBE_HAN_FF6E	0xFF6E	/* ｮ */
#define UTFBE_HAN_FF6F	0xFF6F	/* ｯ */
#define UTFBE_HAN_FF70	0xFF70	/* ｰ */
#define UTFBE_HAN_FF71	0xFF71	/* ｱ */
#define UTFBE_HAN_FF72	0xFF72	/* ｲ */
#define UTFBE_HAN_FF73	0xFF73	/* ｳ */
#define UTFBE_HAN_FF74	0xFF74	/* ｴ */
#define UTFBE_HAN_FF75	0xFF75	/* ｵ */
#define UTFBE_HAN_FF76	0xFF76	/* ｶ */
#define UTFBE_HAN_FF77	0xFF77	/* ｷ */
#define UTFBE_HAN_FF78	0xFF78	/* ｸ */
#define UTFBE_HAN_FF79	0xFF79	/* ｹ */
#define UTFBE_HAN_FF7A	0xFF7A	/* ｺ */
#define UTFBE_HAN_FF7B	0xFF7B	/* ｻ */
#define UTFBE_HAN_FF7C	0xFF7C	/* ｼ */
#define UTFBE_HAN_FF7D	0xFF7D	/* ｽ */
#define UTFBE_HAN_FF7E	0xFF7E	/* ｾ */
#define UTFBE_HAN_FF7F	0xFF7F	/* ｿ */
#define UTFBE_HAN_FF80	0xFF80	/* ﾀ */
#define UTFBE_HAN_FF81	0xFF81	/* ﾁ */
#define UTFBE_HAN_FF82	0xFF82	/* ﾂ */
#define UTFBE_HAN_FF83	0xFF83	/* ﾃ */
#define UTFBE_HAN_FF84	0xFF84	/* ﾄ */
#define UTFBE_HAN_FF85	0xFF85	/* ﾅ */
#define UTFBE_HAN_FF86	0xFF86	/* ﾆ */
#define UTFBE_HAN_FF87	0xFF87	/* ﾇ */
#define UTFBE_HAN_FF88	0xFF88	/* ﾈ */
#define UTFBE_HAN_FF89	0xFF89	/* ﾉ */
#define UTFBE_HAN_FF8A	0xFF8A	/* ﾊ */
#define UTFBE_HAN_FF8B	0xFF8B	/* ﾋ */
#define UTFBE_HAN_FF8C	0xFF8C	/* ﾌ */
#define UTFBE_HAN_FF8D	0xFF8D	/* ﾍ */
#define UTFBE_HAN_FF8E	0xFF8E	/* ﾎ */
#define UTFBE_HAN_FF8F	0xFF8F	/* ﾏ */
#define UTFBE_HAN_FF90	0xFF90	/* ﾐ */
#define UTFBE_HAN_FF91	0xFF91	/* ﾑ */
#define UTFBE_HAN_FF92	0xFF92	/* ﾒ */
#define UTFBE_HAN_FF93	0xFF93	/* ﾓ */
#define UTFBE_HAN_FF94	0xFF94	/* ﾔ */
#define UTFBE_HAN_FF95	0xFF95	/* ﾕ */
#define UTFBE_HAN_FF96	0xFF96	/* ﾖ */
#define UTFBE_HAN_FF97	0xFF97	/* ﾗ */
#define UTFBE_HAN_FF98	0xFF98	/* ﾘ */
#define UTFBE_HAN_FF99	0xFF99	/* ﾙ */
#define UTFBE_HAN_FF9A	0xFF9A	/* ﾚ */
#define UTFBE_HAN_FF9B	0xFF9B	/* ﾛ */
#define UTFBE_HAN_FF9C	0xFF9C	/* ﾜ */
#define UTFBE_HAN_FF9D	0xFF9D	/* ﾝ */
#define UTFBE_HAN_FF9E	0xFF9E	/* ﾞ */
#define UTFBE_HAN_FF9F	0xFF9F	/* ﾟ */

#define UTFBE_ZEN_3001	0x3001	/* 、 */
#define UTFBE_ZEN_3002	0x3002 	/* 。 */
#define UTFBE_ZEN_300C	0x300C 	/* 「 */
#define UTFBE_ZEN_300D	0x300D 	/* 」 */
#define UTFBE_ZEN_309B	0x309B	/* ゛ */
#define UTFBE_ZEN_309C	0x309C	/* ゜ */
#define UTFBE_ZEN_30A0	0x30A0	/* ゠ */
#define UTFBE_ZEN_30A1	0x30A1	/* ァ */
#define UTFBE_ZEN_30A2	0x30A2	/* ア */
#define UTFBE_ZEN_30A3	0x30A3	/* ィ */
#define UTFBE_ZEN_30A4	0x30A4	/* イ */
#define UTFBE_ZEN_30A5	0x30A5	/* ゥ */
#define UTFBE_ZEN_30A6	0x30A6	/* ウ */
#define UTFBE_ZEN_30A7	0x30A7	/* ェ */
#define UTFBE_ZEN_30A8	0x30A8	/* エ */
#define UTFBE_ZEN_30A9	0x30A9	/* ォ */
#define UTFBE_ZEN_30AA	0x30AA	/* オ */
#define UTFBE_ZEN_30AB	0x30AB	/* カ */
#define UTFBE_ZEN_30AC	0x30AC	/* ガ */
#define UTFBE_ZEN_30AD	0x30AD	/* キ */
#define UTFBE_ZEN_30AE	0x30AE	/* ギ */
#define UTFBE_ZEN_30AF	0x30AF	/* ク */
#define UTFBE_ZEN_30B0	0x30B0	/* グ */
#define UTFBE_ZEN_30B1	0x30B1	/* ケ */
#define UTFBE_ZEN_30B2	0x30B2	/* ゲ */
#define UTFBE_ZEN_30B3	0x30B3	/* コ */
#define UTFBE_ZEN_30B4	0x30B4	/* ゴ */
#define UTFBE_ZEN_30B5	0x30B5	/* サ */
#define UTFBE_ZEN_30B6	0x30B6	/* ザ */
#define UTFBE_ZEN_30B7	0x30B7	/* シ */
#define UTFBE_ZEN_30B8	0x30B8	/* ジ */
#define UTFBE_ZEN_30B9	0x30B9	/* ス */
#define UTFBE_ZEN_30BA	0x30BA	/* ズ */
#define UTFBE_ZEN_30BB	0x30BB	/* セ */
#define UTFBE_ZEN_30BC	0x30BC	/* ゼ */
#define UTFBE_ZEN_30BD	0x30BD	/* ソ */
#define UTFBE_ZEN_30BE	0x30BE	/* ゾ */
#define UTFBE_ZEN_30BF	0x30BF	/* タ */
#define UTFBE_ZEN_30C0	0x30C0	/* ダ */
#define UTFBE_ZEN_30C1	0x30C1	/* チ */
#define UTFBE_ZEN_30C2	0x30C2	/* ヂ */
#define UTFBE_ZEN_30C3	0x30C3	/* ッ */
#define UTFBE_ZEN_30C4	0x30C4	/* ツ */
#define UTFBE_ZEN_30C5	0x30C5	/* ヅ */
#define UTFBE_ZEN_30C6	0x30C6	/* テ */
#define UTFBE_ZEN_30C7	0x30C7	/* デ */
#define UTFBE_ZEN_30C8	0x30C8	/* ト */
#define UTFBE_ZEN_30C9	0x30C9	/* ド */
#define UTFBE_ZEN_30CA	0x30CA	/* ナ */
#define UTFBE_ZEN_30CB	0x30CB	/* ニ */
#define UTFBE_ZEN_30CC	0x30CC	/* ヌ */
#define UTFBE_ZEN_30CD	0x30CD	/* ネ */
#define UTFBE_ZEN_30CE	0x30CE	/* ノ */
#define UTFBE_ZEN_30CF	0x30CF	/* ハ */
#define UTFBE_ZEN_30D0	0x30D0	/* バ */
#define UTFBE_ZEN_30D1	0x30D1	/* パ */
#define UTFBE_ZEN_30D2	0x30D2	/* ヒ */
#define UTFBE_ZEN_30D3	0x30D3	/* ビ */
#define UTFBE_ZEN_30D4	0x30D4	/* ピ */
#define UTFBE_ZEN_30D5	0x30D5	/* フ */
#define UTFBE_ZEN_30D6	0x30D6	/* ブ */
#define UTFBE_ZEN_30D7	0x30D7	/* プ */
#define UTFBE_ZEN_30D8	0x30D8	/* ヘ */
#define UTFBE_ZEN_30D9	0x30D9	/* ベ */
#define UTFBE_ZEN_30DA	0x30DA	/* ペ */
#define UTFBE_ZEN_30DB	0x30DB	/* ホ */
#define UTFBE_ZEN_30DC	0x30DC	/* ボ */
#define UTFBE_ZEN_30DD	0x30DD	/* ポ */
#define UTFBE_ZEN_30DE	0x30DE	/* マ */
#define UTFBE_ZEN_30DF	0x30DF	/* ミ */
#define UTFBE_ZEN_30E0	0x30E0	/* ム */
#define UTFBE_ZEN_30E1	0x30E1	/* メ */
#define UTFBE_ZEN_30E2	0x30E2	/* モ */
#define UTFBE_ZEN_30E3	0x30E3	/* ャ */
#define UTFBE_ZEN_30E4	0x30E4	/* ヤ */
#define UTFBE_ZEN_30E5	0x30E5	/* ュ */
#define UTFBE_ZEN_30E6	0x30E6	/* ユ */
#define UTFBE_ZEN_30E7	0x30E7	/* ョ */
#define UTFBE_ZEN_30E8	0x30E8	/* ヨ */
#define UTFBE_ZEN_30E9	0x30E9	/* ラ */
#define UTFBE_ZEN_30EA	0x30EA	/* リ */
#define UTFBE_ZEN_30EB	0x30EB	/* ル */
#define UTFBE_ZEN_30EC	0x30EC	/* レ */
#define UTFBE_ZEN_30ED	0x30ED	/* ロ */
#define UTFBE_ZEN_30EE	0x30EE	/* ヮ */
#define UTFBE_ZEN_30EF	0x30EF	/* ワ */
#define UTFBE_ZEN_30F0	0x30F0	/* ヰ */
#define UTFBE_ZEN_30F1	0x30F1	/* ヱ */
#define UTFBE_ZEN_30F2	0x30F2	/* ヲ */
#define UTFBE_ZEN_30F3	0x30F3	/* ン */
#define UTFBE_ZEN_30F4	0x30F4	/* ヴ */
#define UTFBE_ZEN_30F5	0x30F5	/* ヵ */
#define UTFBE_ZEN_30F6	0x30F6	/* ヶ */
#define UTFBE_ZEN_30F7	0x30F7	/* ヷ */
#define UTFBE_ZEN_30F8	0x30F8	/* ヸ */
#define UTFBE_ZEN_30F9	0x30F9	/* ヹ */
#define UTFBE_ZEN_30FA	0x30FA	/* ヺ */
#define UTFBE_ZEN_30FB	0x30FB	/* ・ */
#define UTFBE_ZEN_30FC	0x30FC	/* ー */
#define UTFBE_ZEN_30FD	0x30FD	/* ヽ */
#define UTFBE_ZEN_30FE	0x30FE	/* ヾ */
#define UTFBE_ZEN_30FF	0x30FF	/* ヿ */

extern unsigned short _han_to_zen[];
extern const size_t _han_to_zen_size;
#define _han_to_zen_offset		UTFBE_HAN_FF61		/* ｡ */

extern unsigned short _han_to_zen_d[];
extern const size_t _han_to_zen_d_size;
#define _han_to_zen_d_offset		UTFBE_HAN_FF66	/* ｦ */

extern unsigned short _han_to_zen_h[];
extern const size_t _han_to_zen_h_size;
#define _han_to_zen_h_offset		UTFBE_HAN_FF8A	/* ﾊ */

#define _f_han_to_zen(cd) \
	(0<=(cd)-_han_to_zen_offset && (cd)-_han_to_zen_offset<_han_to_zen_size? \
	_han_to_zen[(cd)-_han_to_zen_offset]: (cd))

#define _f_han_to_zen_d(cd) \
	(0<=(cd)-_han_to_zen_d_offset && (cd)-_han_to_zen_d_offset<_han_to_zen_d_size && _han_to_zen_d[(cd)-_han_to_zen_d_offset] != 0? \
	_han_to_zen_d[(cd)-_han_to_zen_d_offset]: (cd))

#define _f_han_to_zen_h(cd) \
	(0<=(cd)-_han_to_zen_h_offset && (cd)-_han_to_zen_h_offset<_han_to_zen_h_size? \
	_han_to_zen_h[(cd)-_han_to_zen_h_offset]: (cd))

#endif /* __HAN_ZEN_H_ */
