/*
 * _sjis2unibe_table.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __SJIS2UNIBE_TABLE_H_
#define __SJIS2UNIBE_TABLE_H_

#include <stddef.h>
#include <stdint.h>

const uint16_t _sjis2unibe_table[] = {
	/* 0000 */ 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, 0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* '','','','','','','','', '','','','','','','','', */
	/* 0010 */ 0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, 0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* '','','','','','','','', '','','','','','','','', */
	/* 0020 */ 0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, 0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* ' ','!','"','#','$','%','&','\'', '(',')','*','+',',','-','.','/', */
	/* 0030 */ 0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, 0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* '0','1','2','3','4','5','6','7', '8','9',':',';','<','=','>','?', */
	/* 0040 */ 0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, 0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O', */
	/* 0050 */ 0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, 0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 'P','Q','R','S','T','U','V','W', 'X','Y','Z','[','\\',']','^','_', */
	/* 0060 */ 0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, 0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* '`','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o', */
	/* 0070 */ 0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, 0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f, /* 'p','q','r','s','t','u','v','w', 'x','y','z','{','|','}','~','', */
	/* 0080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00a0 */ 0,0xff61,0xff62,0xff63,0xff64,0xff65,0xff66,0xff67, 0xff68,0xff69,0xff6a,0xff6b,0xff6c,0xff6d,0xff6e,0xff6f, /* 0,'｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* 00b0 */ 0xff70,0xff71,0xff72,0xff73,0xff74,0xff75,0xff76,0xff77, 0xff78,0xff79,0xff7a,0xff7b,0xff7c,0xff7d,0xff7e,0xff7f, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* 00c0 */ 0xff80,0xff81,0xff82,0xff83,0xff84,0xff85,0xff86,0xff87, 0xff88,0xff89,0xff8a,0xff8b,0xff8c,0xff8d,0xff8e,0xff8f, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* 00d0 */ 0xff90,0xff91,0xff92,0xff93,0xff94,0xff95,0xff96,0xff97, 0xff98,0xff99,0xff9a,0xff9b,0xff9c,0xff9d,0xff9e,0xff9f, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
	/* 00e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 30a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 30b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 30c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 30d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 30e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 30f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 50a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 50b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 50c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 50d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 50e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 50f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 51a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 51b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 51c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 51d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 51e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 51f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 52a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 52b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 52c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 52d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 52e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 52f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 53a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 53b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 53c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 53d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 53e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 53f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 54a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 54b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 54c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 54d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 54e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 54f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 55a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 55b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 55c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 55d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 55e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 55f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 56a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 56b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 56c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 56d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 56e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 56f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 57a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 57b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 57c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 57d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 57e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 57f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 58a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 58b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 58c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 58d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 58e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 58f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 59a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 59b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 59c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 59d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 59e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 59f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 60a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 60b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 60c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 60d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 60e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 60f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 61a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 61b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 61c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 61d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 61e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 61f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 62a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 62b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 62c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 62d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 62e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 62f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 63a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 63b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 63c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 63d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 63e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 63f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 64a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 64b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 64c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 64d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 64e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 64f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 65a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 65b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 65c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 65d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 65e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 65f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 66a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 66b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 66c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 66d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 66e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 66f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 67a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 67b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 67c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 67d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 67e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 67f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 68a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 68b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 68c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 68d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 68e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 68f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 69a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 69b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 69c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 69d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 69e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 69f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 6ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 70a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 70b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 70c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 70d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 70e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 70f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 71a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 71b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 71c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 71d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 71e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 71f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 72a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 72b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 72c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 72d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 72e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 72f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 73a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 73b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 73c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 73d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 73e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 73f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 74a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 74b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 74c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 74d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 74e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 74f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 75a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 75b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 75c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 75d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 75e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 75f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 76a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 76b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 76c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 76d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 76e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 76f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 77a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 77b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 77c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 77d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 77e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 77f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 78a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 78b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 78c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 78d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 78e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 78f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 79a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 79b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 79c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 79d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 79e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 79f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 80a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 80b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 80c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 80d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 80e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 80f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8140 */ 0x3000,0x3001,0x3002,0xff0c,0xff0e,0x30fb,0xff1a,0xff1b, 0xff1f,0xff01,0x309b,0x309c,0x00b4,0xff40,0x00a8,0xff3e, /* '　','、','。','，','．','・','：','；', '？','！','゛','゜','´','｀','¨','＾', */
	/* 8150 */ 0xffe3,0xff3f,0x30fd,0x30fe,0x309d,0x309e,0x3003,0x4edd, 0x3005,0x3006,0x3007,0x30fc,0x2014,0x2010,0xff0f,0xff3c, /* '￣','＿','ヽ','ヾ','ゝ','ゞ','〃','仝', '々','〆','〇','ー','—','‐','／','＼', */
	/* 8160 */ 0x301c,0x2016,0xff5c,0x2026,0x2025,0x2018,0x2019,0x201c, 0x201d,0xff08,0xff09,0x3014,0x3015,0xff3b,0xff3d,0xff5b, /* '〜','‖','｜','…','‥','‘','’','“', '”','（','）','〔','〕','［','］','｛', */
	/* 8170 */ 0xff5d,0x3008,0x3009,0x300a,0x300b,0x300c,0x300d,0x300e, 0x300f,0x3010,0x3011,0xff0b,0x2212,0x00b1,0x00d7,0, /* '｝','〈','〉','《','》','「','」','『', '』','【','】','＋','−','±','×',0, */
	/* 8180 */ 0x00f7,0xff1d,0x2260,0xff1c,0xff1e,0x2266,0x2267,0x221e, 0x2234,0x2642,0x2640,0x00b0,0x2032,0x2033,0x2103,0xffe5, /* '÷','＝','≠','＜','＞','≦','≧','∞', '∴','♂','♀','°','′','″','℃','￥', */
	/* 8190 */ 0xff04,0x00a2,0x00a3,0xff05,0xff03,0xff06,0xff0a,0xff20, 0x00a7,0x2606,0x2605,0x25cb,0x25cf,0x25ce,0x25c7,0x25c6, /* '＄','¢','£','％','＃','＆','＊','＠', '§','☆','★','○','●','◎','◇','◆', */
	/* 81a0 */ 0x25a1,0x25a0,0x25b3,0x25b2,0x25bd,0x25bc,0x203b,0x3012, 0x2192,0x2190,0x2191,0x2193,0x3013,0,0,0, /* '□','■','△','▲','▽','▼','※','〒', '→','←','↑','↓','〓',0,0,0, */
	/* 81b0 */ 0,0,0,0,0,0,0,0, 0x2208,0x220b,0x2286,0x2287,0x2282,0x2283,0x222a,0x2229, /* 0,0,0,0,0,0,0,0, '∈','∋','⊆','⊇','⊂','⊃','∪','∩', */
	/* 81c0 */ 0,0,0,0,0,0,0,0, 0x2227,0x2228,0x00ac,0x21d2,0x21d4,0x2200,0x2203,0, /* 0,0,0,0,0,0,0,0, '∧','∨','¬','⇒','⇔','∀','∃',0, */
	/* 81d0 */ 0,0,0,0,0,0,0,0, 0,0,0x2220,0x22a5,0x2312,0x2202,0x2207,0x2261, /* 0,0,0,0,0,0,0,0, 0,0,'∠','⊥','⌒','∂','∇','≡', */
	/* 81e0 */ 0x2252,0x226a,0x226b,0x221a,0x223d,0x221d,0x2235,0x222b, 0x222c,0,0,0,0,0,0,0, /* '≒','≪','≫','√','∽','∝','∵','∫', '∬',0,0,0,0,0,0,0, */
	/* 81f0 */ 0x212b,0x2030,0x266f,0x266d,0x266a,0x2020,0x2021,0x00b6, 0,0,0,0,0x25ef,0,0,0, /* 'Å','‰','♯','♭','♪','†','‡','¶', 0,0,0,0,'◯',0,0,0, */
	/* 8200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xff10, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'０', */
	/* 8250 */ 0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17,0xff18, 0xff19,0,0,0,0,0,0,0, /* '１','２','３','４','５','６','７','８', '９',0,0,0,0,0,0,0, */
	/* 8260 */ 0xff21,0xff22,0xff23,0xff24,0xff25,0xff26,0xff27,0xff28, 0xff29,0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,0xff2f,0xff30, /* 'Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ','Ｈ', 'Ｉ','Ｊ','Ｋ','Ｌ','Ｍ','Ｎ','Ｏ','Ｐ', */
	/* 8270 */ 0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,0xff37,0xff38, 0xff39,0xff3a,0,0,0,0,0,0, /* 'Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ','Ｘ', 'Ｙ','Ｚ',0,0,0,0,0,0, */
	/* 8280 */ 0,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47, 0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f, /* 0,'ａ','ｂ','ｃ','ｄ','ｅ','ｆ','ｇ', 'ｈ','ｉ','ｊ','ｋ','ｌ','ｍ','ｎ','ｏ', */
	/* 8290 */ 0xff50,0xff51,0xff52,0xff53,0xff54,0xff55,0xff56,0xff57, 0xff58,0xff59,0xff5a,0,0,0,0,0x3041, /* 'ｐ','ｑ','ｒ','ｓ','ｔ','ｕ','ｖ','ｗ', 'ｘ','ｙ','ｚ',0,0,0,0,'ぁ', */
	/* 82a0 */ 0x3042,0x3043,0x3044,0x3045,0x3046,0x3047,0x3048,0x3049, 0x304a,0x304b,0x304c,0x304d,0x304e,0x304f,0x3050,0x3051, /* 'あ','ぃ','い','ぅ','う','ぇ','え','ぉ', 'お','か','が','き','ぎ','く','ぐ','け', */
	/* 82b0 */ 0x3052,0x3053,0x3054,0x3055,0x3056,0x3057,0x3058,0x3059, 0x305a,0x305b,0x305c,0x305d,0x305e,0x305f,0x3060,0x3061, /* 'げ','こ','ご','さ','ざ','し','じ','す', 'ず','せ','ぜ','そ','ぞ','た','だ','ち', */
	/* 82c0 */ 0x3062,0x3063,0x3064,0x3065,0x3066,0x3067,0x3068,0x3069, 0x306a,0x306b,0x306c,0x306d,0x306e,0x306f,0x3070,0x3071, /* 'ぢ','っ','つ','づ','て','で','と','ど', 'な','に','ぬ','ね','の','は','ば','ぱ', */
	/* 82d0 */ 0x3072,0x3073,0x3074,0x3075,0x3076,0x3077,0x3078,0x3079, 0x307a,0x307b,0x307c,0x307d,0x307e,0x307f,0x3080,0x3081, /* 'ひ','び','ぴ','ふ','ぶ','ぷ','へ','べ', 'ぺ','ほ','ぼ','ぽ','ま','み','む','め', */
	/* 82e0 */ 0x3082,0x3083,0x3084,0x3085,0x3086,0x3087,0x3088,0x3089, 0x308a,0x308b,0x308c,0x308d,0x308e,0x308f,0x3090,0x3091, /* 'も','ゃ','や','ゅ','ゆ','ょ','よ','ら', 'り','る','れ','ろ','ゎ','わ','ゐ','ゑ', */
	/* 82f0 */ 0x3092,0x3093,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 'を','ん',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8340 */ 0x30a1,0x30a2,0x30a3,0x30a4,0x30a5,0x30a6,0x30a7,0x30a8, 0x30a9,0x30aa,0x30ab,0x30ac,0x30ad,0x30ae,0x30af,0x30b0, /* 'ァ','ア','ィ','イ','ゥ','ウ','ェ','エ', 'ォ','オ','カ','ガ','キ','ギ','ク','グ', */
	/* 8350 */ 0x30b1,0x30b2,0x30b3,0x30b4,0x30b5,0x30b6,0x30b7,0x30b8, 0x30b9,0x30ba,0x30bb,0x30bc,0x30bd,0x30be,0x30bf,0x30c0, /* 'ケ','ゲ','コ','ゴ','サ','ザ','シ','ジ', 'ス','ズ','セ','ゼ','ソ','ゾ','タ','ダ', */
	/* 8360 */ 0x30c1,0x30c2,0x30c3,0x30c4,0x30c5,0x30c6,0x30c7,0x30c8, 0x30c9,0x30ca,0x30cb,0x30cc,0x30cd,0x30ce,0x30cf,0x30d0, /* 'チ','ヂ','ッ','ツ','ヅ','テ','デ','ト', 'ド','ナ','ニ','ヌ','ネ','ノ','ハ','バ', */
	/* 8370 */ 0x30d1,0x30d2,0x30d3,0x30d4,0x30d5,0x30d6,0x30d7,0x30d8, 0x30d9,0x30da,0x30db,0x30dc,0x30dd,0x30de,0x30df,0, /* 'パ','ヒ','ビ','ピ','フ','ブ','プ','ヘ', 'ベ','ペ','ホ','ボ','ポ','マ','ミ',0, */
	/* 8380 */ 0x30e0,0x30e1,0x30e2,0x30e3,0x30e4,0x30e5,0x30e6,0x30e7, 0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ee,0x30ef, /* 'ム','メ','モ','ャ','ヤ','ュ','ユ','ョ', 'ヨ','ラ','リ','ル','レ','ロ','ヮ','ワ', */
	/* 8390 */ 0x30f0,0x30f1,0x30f2,0x30f3,0x30f4,0x30f5,0x30f6,0, 0,0,0,0,0,0,0,0x0391, /* 'ヰ','ヱ','ヲ','ン','ヴ','ヵ','ヶ',0, 0,0,0,0,0,0,0,'Α', */
	/* 83a0 */ 0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399, 0x039a,0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,0x03a1, /* 'Β','Γ','Δ','Ε','Ζ','Η','Θ','Ι', 'Κ','Λ','Μ','Ν','Ξ','Ο','Π','Ρ', */
	/* 83b0 */ 0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0, 0,0,0,0,0,0,0,0x03b1, /* 'Σ','Τ','Υ','Φ','Χ','Ψ','Ω',0, 0,0,0,0,0,0,0,'α', */
	/* 83c0 */ 0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,0x03b9, 0x03ba,0x03bb,0x03bc,0x03bd,0x03be,0x03bf,0x03c0,0x03c1, /* 'β','γ','δ','ε','ζ','η','θ','ι', 'κ','λ','μ','ν','ξ','ο','π','ρ', */
	/* 83d0 */ 0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0, 0,0,0,0,0,0,0,0, /* 'σ','τ','υ','φ','χ','ψ','ω',0, 0,0,0,0,0,0,0,0, */
	/* 83e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 83f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8440 */ 0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0401,0x0416, 0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e, /* 'А','Б','В','Г','Д','Е','Ё','Ж', 'З','И','Й','К','Л','М','Н','О', */
	/* 8450 */ 0x041f,0x0420,0x0421,0x0422,0x0423,0x0424,0x0425,0x0426, 0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d,0x042e, /* 'П','Р','С','Т','У','Ф','Х','Ц', 'Ч','Ш','Щ','Ъ','Ы','Ь','Э','Ю', */
	/* 8460 */ 0x042f,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 'Я',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8470 */ 0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0451,0x0436, 0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0, /* 'а','б','в','г','д','е','ё','ж', 'з','и','й','к','л','м','н',0, */
	/* 8480 */ 0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,0x0444,0x0445, 0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,0x044d, /* 'о','п','р','с','т','у','ф','х', 'ц','ч','ш','щ','ъ','ы','ь','э', */
	/* 8490 */ 0x044e,0x044f,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x2500, /* 'ю','я',0,0,0,0,0,0, 0,0,0,0,0,0,0,'─', */
	/* 84a0 */ 0x2502,0x250c,0x2510,0x2518,0x2514,0x251c,0x252c,0x2524, 0x2534,0x253c,0x2501,0x2503,0x250f,0x2513,0x251b,0x2517, /* '│','┌','┐','┘','└','├','┬','┤', '┴','┼','━','┃','┏','┓','┛','┗', */
	/* 84b0 */ 0x2523,0x2533,0x252b,0x253b,0x254b,0x2520,0x252f,0x2528, 0x2537,0x253f,0x251d,0x2530,0x2525,0x2538,0x2542,0, /* '┣','┳','┫','┻','╋','┠','┯','┨', '┷','┿','┝','┰','┥','┸','╂',0, */
	/* 84c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 84d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 84e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 84f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 85a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 85b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 85c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 85d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 85e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 85f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 86a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 86b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 86c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 86d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 86e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 86f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 87a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 87b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 87c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 87d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 87e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 87f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x4e9c, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'亜', */
	/* 88a0 */ 0x5516,0x5a03,0x963f,0x54c0,0x611b,0x6328,0x59f6,0x9022, 0x8475,0x831c,0x7a50,0x60aa,0x63e1,0x6e25,0x65ed,0x8466, /* '唖','娃','阿','哀','愛','挨','姶','逢', '葵','茜','穐','悪','握','渥','旭','葦', */
	/* 88b0 */ 0x82a6,0x9bf5,0x6893,0x5727,0x65a1,0x6271,0x5b9b,0x59d0, 0x867b,0x98f4,0x7d62,0x7dbe,0x9b8e,0x6216,0x7c9f,0x88b7, /* '芦','鯵','梓','圧','斡','扱','宛','姐', '虻','飴','絢','綾','鮎','或','粟','袷', */
	/* 88c0 */ 0x5b89,0x5eb5,0x6309,0x6697,0x6848,0x95c7,0x978d,0x674f, 0x4ee5,0x4f0a,0x4f4d,0x4f9d,0x5049,0x56f2,0x5937,0x59d4, /* '安','庵','按','暗','案','闇','鞍','杏', '以','伊','位','依','偉','囲','夷','委', */
	/* 88d0 */ 0x5a01,0x5c09,0x60df,0x610f,0x6170,0x6613,0x6905,0x70ba, 0x754f,0x7570,0x79fb,0x7dad,0x7def,0x80c3,0x840e,0x8863, /* '威','尉','惟','意','慰','易','椅','為', '畏','異','移','維','緯','胃','萎','衣', */
	/* 88e0 */ 0x8b02,0x9055,0x907a,0x533b,0x4e95,0x4ea5,0x57df,0x80b2, 0x90c1,0x78ef,0x4e00,0x58f1,0x6ea2,0x9038,0x7a32,0x8328, /* '謂','違','遺','医','井','亥','域','育', '郁','磯','一','壱','溢','逸','稲','茨', */
	/* 88f0 */ 0x828b,0x9c2f,0x5141,0x5370,0x54bd,0x54e1,0x56e0,0x59fb, 0x5f15,0x98f2,0x6deb,0x80e4,0x852d,0,0,0, /* '芋','鰯','允','印','咽','員','因','姻', '引','飲','淫','胤','蔭',0,0,0, */
	/* 8900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8940 */ 0x9662,0x9670,0x96a0,0x97fb,0x540b,0x53f3,0x5b87,0x70cf, 0x7fbd,0x8fc2,0x96e8,0x536f,0x9d5c,0x7aba,0x4e11,0x7893, /* '院','陰','隠','韻','吋','右','宇','烏', '羽','迂','雨','卯','鵜','窺','丑','碓', */
	/* 8950 */ 0x81fc,0x6e26,0x5618,0x5504,0x6b1d,0x851a,0x9c3b,0x59e5, 0x53a9,0x6d66,0x74dc,0x958f,0x5642,0x4e91,0x904b,0x96f2, /* '臼','渦','嘘','唄','欝','蔚','鰻','姥', '厩','浦','瓜','閏','噂','云','運','雲', */
	/* 8960 */ 0x834f,0x990c,0x53e1,0x55b6,0x5b30,0x5f71,0x6620,0x66f3, 0x6804,0x6c38,0x6cf3,0x6d29,0x745b,0x76c8,0x7a4e,0x9834, /* '荏','餌','叡','営','嬰','影','映','曳', '栄','永','泳','洩','瑛','盈','穎','頴', */
	/* 8970 */ 0x82f1,0x885b,0x8a60,0x92ed,0x6db2,0x75ab,0x76ca,0x99c5, 0x60a6,0x8b01,0x8d8a,0x95b2,0x698e,0x53ad,0x5186,0, /* '英','衛','詠','鋭','液','疫','益','駅', '悦','謁','越','閲','榎','厭','円',0, */
	/* 8980 */ 0x5712,0x5830,0x5944,0x5bb4,0x5ef6,0x6028,0x63a9,0x63f4, 0x6cbf,0x6f14,0x708e,0x7114,0x7159,0x71d5,0x733f,0x7e01, /* '園','堰','奄','宴','延','怨','掩','援', '沿','演','炎','焔','煙','燕','猿','縁', */
	/* 8990 */ 0x8276,0x82d1,0x8597,0x9060,0x925b,0x9d1b,0x5869,0x65bc, 0x6c5a,0x7525,0x51f9,0x592e,0x5965,0x5f80,0x5fdc,0x62bc, /* '艶','苑','薗','遠','鉛','鴛','塩','於', '汚','甥','凹','央','奥','往','応','押', */
	/* 89a0 */ 0x65fa,0x6a2a,0x6b27,0x6bb4,0x738b,0x7fc1,0x8956,0x9d2c, 0x9d0e,0x9ec4,0x5ca1,0x6c96,0x837b,0x5104,0x5c4b,0x61b6, /* '旺','横','欧','殴','王','翁','襖','鴬', '鴎','黄','岡','沖','荻','億','屋','憶', */
	/* 89b0 */ 0x81c6,0x6876,0x7261,0x4e59,0x4ffa,0x5378,0x6069,0x6e29, 0x7a4f,0x97f3,0x4e0b,0x5316,0x4eee,0x4f55,0x4f3d,0x4fa1, /* '臆','桶','牡','乙','俺','卸','恩','温', '穏','音','下','化','仮','何','伽','価', */
	/* 89c0 */ 0x4f73,0x52a0,0x53ef,0x5609,0x590f,0x5ac1,0x5bb6,0x5be1, 0x79d1,0x6687,0x679c,0x67b6,0x6b4c,0x6cb3,0x706b,0x73c2, /* '佳','加','可','嘉','夏','嫁','家','寡', '科','暇','果','架','歌','河','火','珂', */
	/* 89d0 */ 0x798d,0x79be,0x7a3c,0x7b87,0x82b1,0x82db,0x8304,0x8377, 0x83ef,0x83d3,0x8766,0x8ab2,0x5629,0x8ca8,0x8fe6,0x904e, /* '禍','禾','稼','箇','花','苛','茄','荷', '華','菓','蝦','課','嘩','貨','迦','過', */
	/* 89e0 */ 0x971e,0x868a,0x4fc4,0x5ce8,0x6211,0x7259,0x753b,0x81e5, 0x82bd,0x86fe,0x8cc0,0x96c5,0x9913,0x99d5,0x4ecb,0x4f1a, /* '霞','蚊','俄','峨','我','牙','画','臥', '芽','蛾','賀','雅','餓','駕','介','会', */
	/* 89f0 */ 0x89e3,0x56de,0x584a,0x58ca,0x5efb,0x5feb,0x602a,0x6094, 0x6062,0x61d0,0x6212,0x62d0,0x6539,0,0,0, /* '解','回','塊','壊','廻','快','怪','悔', '恢','懐','戒','拐','改',0,0,0, */
	/* 8a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8a40 */ 0x9b41,0x6666,0x68b0,0x6d77,0x7070,0x754c,0x7686,0x7d75, 0x82a5,0x87f9,0x958b,0x968e,0x8c9d,0x51f1,0x52be,0x5916, /* '魁','晦','械','海','灰','界','皆','絵', '芥','蟹','開','階','貝','凱','劾','外', */
	/* 8a50 */ 0x54b3,0x5bb3,0x5d16,0x6168,0x6982,0x6daf,0x788d,0x84cb, 0x8857,0x8a72,0x93a7,0x9ab8,0x6d6c,0x99a8,0x86d9,0x57a3, /* '咳','害','崖','慨','概','涯','碍','蓋', '街','該','鎧','骸','浬','馨','蛙','垣', */
	/* 8a60 */ 0x67ff,0x86ce,0x920e,0x5283,0x5687,0x5404,0x5ed3,0x62e1, 0x64b9,0x683c,0x6838,0x6bbb,0x7372,0x78ba,0x7a6b,0x899a, /* '柿','蛎','鈎','劃','嚇','各','廓','拡', '撹','格','核','殻','獲','確','穫','覚', */
	/* 8a70 */ 0x89d2,0x8d6b,0x8f03,0x90ed,0x95a3,0x9694,0x9769,0x5b66, 0x5cb3,0x697d,0x984d,0x984e,0x639b,0x7b20,0x6a2b,0, /* '角','赫','較','郭','閣','隔','革','学', '岳','楽','額','顎','掛','笠','樫',0, */
	/* 8a80 */ 0x6a7f,0x68b6,0x9c0d,0x6f5f,0x5272,0x559d,0x6070,0x62ec, 0x6d3b,0x6e07,0x6ed1,0x845b,0x8910,0x8f44,0x4e14,0x9c39, /* '橿','梶','鰍','潟','割','喝','恰','括', '活','渇','滑','葛','褐','轄','且','鰹', */
	/* 8a90 */ 0x53f6,0x691b,0x6a3a,0x9784,0x682a,0x515c,0x7ac3,0x84b2, 0x91dc,0x938c,0x565b,0x9d28,0x6822,0x8305,0x8431,0x7ca5, /* '叶','椛','樺','鞄','株','兜','竃','蒲', '釜','鎌','噛','鴨','栢','茅','萱','粥', */
	/* 8aa0 */ 0x5208,0x82c5,0x74e6,0x4e7e,0x4f83,0x51a0,0x5bd2,0x520a, 0x52d8,0x52e7,0x5dfb,0x559a,0x582a,0x59e6,0x5b8c,0x5b98, /* '刈','苅','瓦','乾','侃','冠','寒','刊', '勘','勧','巻','喚','堪','姦','完','官', */
	/* 8ab0 */ 0x5bdb,0x5e72,0x5e79,0x60a3,0x611f,0x6163,0x61be,0x63db, 0x6562,0x67d1,0x6853,0x68fa,0x6b3e,0x6b53,0x6c57,0x6f22, /* '寛','干','幹','患','感','慣','憾','換', '敢','柑','桓','棺','款','歓','汗','漢', */
	/* 8ac0 */ 0x6f97,0x6f45,0x74b0,0x7518,0x76e3,0x770b,0x7aff,0x7ba1, 0x7c21,0x7de9,0x7f36,0x7ff0,0x809d,0x8266,0x839e,0x89b3, /* '澗','潅','環','甘','監','看','竿','管', '簡','緩','缶','翰','肝','艦','莞','観', */
	/* 8ad0 */ 0x8acc,0x8cab,0x9084,0x9451,0x9593,0x9591,0x95a2,0x9665, 0x97d3,0x9928,0x8218,0x4e38,0x542b,0x5cb8,0x5dcc,0x73a9, /* '諌','貫','還','鑑','間','閑','関','陥', '韓','館','舘','丸','含','岸','巌','玩', */
	/* 8ae0 */ 0x764c,0x773c,0x5ca9,0x7feb,0x8d0b,0x96c1,0x9811,0x9854, 0x9858,0x4f01,0x4f0e,0x5371,0x559c,0x5668,0x57fa,0x5947, /* '癌','眼','岩','翫','贋','雁','頑','顔', '願','企','伎','危','喜','器','基','奇', */
	/* 8af0 */ 0x5b09,0x5bc4,0x5c90,0x5e0c,0x5e7e,0x5fcc,0x63ee,0x673a, 0x65d7,0x65e2,0x671f,0x68cb,0x68c4,0,0,0, /* '嬉','寄','岐','希','幾','忌','揮','机', '旗','既','期','棋','棄',0,0,0, */
	/* 8b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8b40 */ 0x6a5f,0x5e30,0x6bc5,0x6c17,0x6c7d,0x757f,0x7948,0x5b63, 0x7a00,0x7d00,0x5fbd,0x898f,0x8a18,0x8cb4,0x8d77,0x8ecc, /* '機','帰','毅','気','汽','畿','祈','季', '稀','紀','徽','規','記','貴','起','軌', */
	/* 8b50 */ 0x8f1d,0x98e2,0x9a0e,0x9b3c,0x4e80,0x507d,0x5100,0x5993, 0x5b9c,0x622f,0x6280,0x64ec,0x6b3a,0x72a0,0x7591,0x7947, /* '輝','飢','騎','鬼','亀','偽','儀','妓', '宜','戯','技','擬','欺','犠','疑','祇', */
	/* 8b60 */ 0x7fa9,0x87fb,0x8abc,0x8b70,0x63ac,0x83ca,0x97a0,0x5409, 0x5403,0x55ab,0x6854,0x6a58,0x8a70,0x7827,0x6775,0x9ecd, /* '義','蟻','誼','議','掬','菊','鞠','吉', '吃','喫','桔','橘','詰','砧','杵','黍', */
	/* 8b70 */ 0x5374,0x5ba2,0x811a,0x8650,0x9006,0x4e18,0x4e45,0x4ec7, 0x4f11,0x53ca,0x5438,0x5bae,0x5f13,0x6025,0x6551,0, /* '却','客','脚','虐','逆','丘','久','仇', '休','及','吸','宮','弓','急','救',0, */
	/* 8b80 */ 0x673d,0x6c42,0x6c72,0x6ce3,0x7078,0x7403,0x7a76,0x7aae, 0x7b08,0x7d1a,0x7cfe,0x7d66,0x65e7,0x725b,0x53bb,0x5c45, /* '朽','求','汲','泣','灸','球','究','窮', '笈','級','糾','給','旧','牛','去','居', */
	/* 8b90 */ 0x5de8,0x62d2,0x62e0,0x6319,0x6e20,0x865a,0x8a31,0x8ddd, 0x92f8,0x6f01,0x79a6,0x9b5a,0x4ea8,0x4eab,0x4eac,0x4f9b, /* '巨','拒','拠','挙','渠','虚','許','距', '鋸','漁','禦','魚','亨','享','京','供', */
	/* 8ba0 */ 0x4fa0,0x50d1,0x5147,0x7af6,0x5171,0x51f6,0x5354,0x5321, 0x537f,0x53eb,0x55ac,0x5883,0x5ce1,0x5f37,0x5f4a,0x602f, /* '侠','僑','兇','競','共','凶','協','匡', '卿','叫','喬','境','峡','強','彊','怯', */
	/* 8bb0 */ 0x6050,0x606d,0x631f,0x6559,0x6a4b,0x6cc1,0x72c2,0x72ed, 0x77ef,0x80f8,0x8105,0x8208,0x854e,0x90f7,0x93e1,0x97ff, /* '恐','恭','挟','教','橋','況','狂','狭', '矯','胸','脅','興','蕎','郷','鏡','響', */
	/* 8bc0 */ 0x9957,0x9a5a,0x4ef0,0x51dd,0x5c2d,0x6681,0x696d,0x5c40, 0x66f2,0x6975,0x7389,0x6850,0x7c81,0x50c5,0x52e4,0x5747, /* '饗','驚','仰','凝','尭','暁','業','局', '曲','極','玉','桐','粁','僅','勤','均', */
	/* 8bd0 */ 0x5dfe,0x9326,0x65a4,0x6b23,0x6b3d,0x7434,0x7981,0x79bd, 0x7b4b,0x7dca,0x82b9,0x83cc,0x887f,0x895f,0x8b39,0x8fd1, /* '巾','錦','斤','欣','欽','琴','禁','禽', '筋','緊','芹','菌','衿','襟','謹','近', */
	/* 8be0 */ 0x91d1,0x541f,0x9280,0x4e5d,0x5036,0x53e5,0x533a,0x72d7, 0x7396,0x77e9,0x82e6,0x8eaf,0x99c6,0x99c8,0x99d2,0x5177, /* '金','吟','銀','九','倶','句','区','狗', '玖','矩','苦','躯','駆','駈','駒','具', */
	/* 8bf0 */ 0x611a,0x865e,0x55b0,0x7a7a,0x5076,0x5bd3,0x9047,0x9685, 0x4e32,0x6adb,0x91e7,0x5c51,0x5c48,0,0,0, /* '愚','虞','喰','空','偶','寓','遇','隅', '串','櫛','釧','屑','屈',0,0,0, */
	/* 8c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c40 */ 0x6398,0x7a9f,0x6c93,0x9774,0x8f61,0x7aaa,0x718a,0x9688, 0x7c82,0x6817,0x7e70,0x6851,0x936c,0x52f2,0x541b,0x85ab, /* '掘','窟','沓','靴','轡','窪','熊','隈', '粂','栗','繰','桑','鍬','勲','君','薫', */
	/* 8c50 */ 0x8a13,0x7fa4,0x8ecd,0x90e1,0x5366,0x8888,0x7941,0x4fc2, 0x50be,0x5211,0x5144,0x5553,0x572d,0x73ea,0x578b,0x5951, /* '訓','群','軍','郡','卦','袈','祁','係', '傾','刑','兄','啓','圭','珪','型','契', */
	/* 8c60 */ 0x5f62,0x5f84,0x6075,0x6176,0x6167,0x61a9,0x63b2,0x643a, 0x656c,0x666f,0x6842,0x6e13,0x7566,0x7a3d,0x7cfb,0x7d4c, /* '形','径','恵','慶','慧','憩','掲','携', '敬','景','桂','渓','畦','稽','系','経', */
	/* 8c70 */ 0x7d99,0x7e4b,0x7f6b,0x830e,0x834a,0x86cd,0x8a08,0x8a63, 0x8b66,0x8efd,0x981a,0x9d8f,0x82b8,0x8fce,0x9be8,0, /* '継','繋','罫','茎','荊','蛍','計','詣', '警','軽','頚','鶏','芸','迎','鯨',0, */
	/* 8c80 */ 0x5287,0x621f,0x6483,0x6fc0,0x9699,0x6841,0x5091,0x6b20, 0x6c7a,0x6f54,0x7a74,0x7d50,0x8840,0x8a23,0x6708,0x4ef6, /* '劇','戟','撃','激','隙','桁','傑','欠', '決','潔','穴','結','血','訣','月','件', */
	/* 8c90 */ 0x5039,0x5026,0x5065,0x517c,0x5238,0x5263,0x55a7,0x570f, 0x5805,0x5acc,0x5efa,0x61b2,0x61f8,0x62f3,0x6372,0x691c, /* '倹','倦','健','兼','券','剣','喧','圏', '堅','嫌','建','憲','懸','拳','捲','検', */
	/* 8ca0 */ 0x6a29,0x727d,0x72ac,0x732e,0x7814,0x786f,0x7d79,0x770c, 0x80a9,0x898b,0x8b19,0x8ce2,0x8ed2,0x9063,0x9375,0x967a, /* '権','牽','犬','献','研','硯','絹','県', '肩','見','謙','賢','軒','遣','鍵','険', */
	/* 8cb0 */ 0x9855,0x9a13,0x9e78,0x5143,0x539f,0x53b3,0x5e7b,0x5f26, 0x6e1b,0x6e90,0x7384,0x73fe,0x7d43,0x8237,0x8a00,0x8afa, /* '顕','験','鹸','元','原','厳','幻','弦', '減','源','玄','現','絃','舷','言','諺', */
	/* 8cc0 */ 0x9650,0x4e4e,0x500b,0x53e4,0x547c,0x56fa,0x59d1,0x5b64, 0x5df1,0x5eab,0x5f27,0x6238,0x6545,0x67af,0x6e56,0x72d0, /* '限','乎','個','古','呼','固','姑','孤', '己','庫','弧','戸','故','枯','湖','狐', */
	/* 8cd0 */ 0x7cca,0x88b4,0x80a1,0x80e1,0x83f0,0x864e,0x8a87,0x8de8, 0x9237,0x96c7,0x9867,0x9f13,0x4e94,0x4e92,0x4f0d,0x5348, /* '糊','袴','股','胡','菰','虎','誇','跨', '鈷','雇','顧','鼓','五','互','伍','午', */
	/* 8ce0 */ 0x5449,0x543e,0x5a2f,0x5f8c,0x5fa1,0x609f,0x68a7,0x6a8e, 0x745a,0x7881,0x8a9e,0x8aa4,0x8b77,0x9190,0x4e5e,0x9bc9, /* '呉','吾','娯','後','御','悟','梧','檎', '瑚','碁','語','誤','護','醐','乞','鯉', */
	/* 8cf0 */ 0x4ea4,0x4f7c,0x4faf,0x5019,0x5016,0x5149,0x516c,0x529f, 0x52b9,0x52fe,0x539a,0x53e3,0x5411,0,0,0, /* '交','佼','侯','候','倖','光','公','功', '効','勾','厚','口','向',0,0,0, */
	/* 8d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d40 */ 0x540e,0x5589,0x5751,0x57a2,0x597d,0x5b54,0x5b5d,0x5b8f, 0x5de5,0x5de7,0x5df7,0x5e78,0x5e83,0x5e9a,0x5eb7,0x5f18, /* '后','喉','坑','垢','好','孔','孝','宏', '工','巧','巷','幸','広','庚','康','弘', */
	/* 8d50 */ 0x6052,0x614c,0x6297,0x62d8,0x63a7,0x653b,0x6602,0x6643, 0x66f4,0x676d,0x6821,0x6897,0x69cb,0x6c5f,0x6d2a,0x6d69, /* '恒','慌','抗','拘','控','攻','昂','晃', '更','杭','校','梗','構','江','洪','浩', */
	/* 8d60 */ 0x6e2f,0x6e9d,0x7532,0x7687,0x786c,0x7a3f,0x7ce0,0x7d05, 0x7d18,0x7d5e,0x7db1,0x8015,0x8003,0x80af,0x80b1,0x8154, /* '港','溝','甲','皇','硬','稿','糠','紅', '紘','絞','綱','耕','考','肯','肱','腔', */
	/* 8d70 */ 0x818f,0x822a,0x8352,0x884c,0x8861,0x8b1b,0x8ca2,0x8cfc, 0x90ca,0x9175,0x9271,0x783f,0x92fc,0x95a4,0x964d,0, /* '膏','航','荒','行','衡','講','貢','購', '郊','酵','鉱','砿','鋼','閤','降',0, */
	/* 8d80 */ 0x9805,0x9999,0x9ad8,0x9d3b,0x525b,0x52ab,0x53f7,0x5408, 0x58d5,0x62f7,0x6fe0,0x8c6a,0x8f5f,0x9eb9,0x514b,0x523b, /* '項','香','高','鴻','剛','劫','号','合', '壕','拷','濠','豪','轟','麹','克','刻', */
	/* 8d90 */ 0x544a,0x56fd,0x7a40,0x9177,0x9d60,0x9ed2,0x7344,0x6f09, 0x8170,0x7511,0x5ffd,0x60da,0x9aa8,0x72db,0x8fbc,0x6b64, /* '告','国','穀','酷','鵠','黒','獄','漉', '腰','甑','忽','惚','骨','狛','込','此', */
	/* 8da0 */ 0x9803,0x4eca,0x56f0,0x5764,0x58be,0x5a5a,0x6068,0x61c7, 0x660f,0x6606,0x6839,0x68b1,0x6df7,0x75d5,0x7d3a,0x826e, /* '頃','今','困','坤','墾','婚','恨','懇', '昏','昆','根','梱','混','痕','紺','艮', */
	/* 8db0 */ 0x9b42,0x4e9b,0x4f50,0x53c9,0x5506,0x5d6f,0x5de6,0x5dee, 0x67fb,0x6c99,0x7473,0x7802,0x8a50,0x9396,0x88df,0x5750, /* '魂','些','佐','叉','唆','嵯','左','差', '査','沙','瑳','砂','詐','鎖','裟','坐', */
	/* 8dc0 */ 0x5ea7,0x632b,0x50b5,0x50ac,0x518d,0x6700,0x54c9,0x585e, 0x59bb,0x5bb0,0x5f69,0x624d,0x63a1,0x683d,0x6b73,0x6e08, /* '座','挫','債','催','再','最','哉','塞', '妻','宰','彩','才','採','栽','歳','済', */
	/* 8dd0 */ 0x707d,0x91c7,0x7280,0x7815,0x7826,0x796d,0x658e,0x7d30, 0x83dc,0x88c1,0x8f09,0x969b,0x5264,0x5728,0x6750,0x7f6a, /* '災','采','犀','砕','砦','祭','斎','細', '菜','裁','載','際','剤','在','材','罪', */
	/* 8de0 */ 0x8ca1,0x51b4,0x5742,0x962a,0x583a,0x698a,0x80b4,0x54b2, 0x5d0e,0x57fc,0x7895,0x9dfa,0x4f5c,0x524a,0x548b,0x643e, /* '財','冴','坂','阪','堺','榊','肴','咲', '崎','埼','碕','鷺','作','削','咋','搾', */
	/* 8df0 */ 0x6628,0x6714,0x67f5,0x7a84,0x7b56,0x7d22,0x932f,0x685c, 0x9bad,0x7b39,0x5319,0x518a,0x5237,0,0,0, /* '昨','朔','柵','窄','策','索','錯','桜', '鮭','笹','匙','冊','刷',0,0,0, */
	/* 8e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8e40 */ 0x5bdf,0x62f6,0x64ae,0x64e6,0x672d,0x6bba,0x85a9,0x96d1, 0x7690,0x9bd6,0x634c,0x9306,0x9bab,0x76bf,0x6652,0x4e09, /* '察','拶','撮','擦','札','殺','薩','雑', '皐','鯖','捌','錆','鮫','皿','晒','三', */
	/* 8e50 */ 0x5098,0x53c2,0x5c71,0x60e8,0x6492,0x6563,0x685f,0x71e6, 0x73ca,0x7523,0x7b97,0x7e82,0x8695,0x8b83,0x8cdb,0x9178, /* '傘','参','山','惨','撒','散','桟','燦', '珊','産','算','纂','蚕','讃','賛','酸', */
	/* 8e60 */ 0x9910,0x65ac,0x66ab,0x6b8b,0x4ed5,0x4ed4,0x4f3a,0x4f7f, 0x523a,0x53f8,0x53f2,0x55e3,0x56db,0x58eb,0x59cb,0x59c9, /* '餐','斬','暫','残','仕','仔','伺','使', '刺','司','史','嗣','四','士','始','姉', */
	/* 8e70 */ 0x59ff,0x5b50,0x5c4d,0x5e02,0x5e2b,0x5fd7,0x601d,0x6307, 0x652f,0x5b5c,0x65af,0x65bd,0x65e8,0x679d,0x6b62,0, /* '姿','子','屍','市','師','志','思','指', '支','孜','斯','施','旨','枝','止',0, */
	/* 8e80 */ 0x6b7b,0x6c0f,0x7345,0x7949,0x79c1,0x7cf8,0x7d19,0x7d2b, 0x80a2,0x8102,0x81f3,0x8996,0x8a5e,0x8a69,0x8a66,0x8a8c, /* '死','氏','獅','祉','私','糸','紙','紫', '肢','脂','至','視','詞','詩','試','誌', */
	/* 8e90 */ 0x8aee,0x8cc7,0x8cdc,0x96cc,0x98fc,0x6b6f,0x4e8b,0x4f3c, 0x4f8d,0x5150,0x5b57,0x5bfa,0x6148,0x6301,0x6642,0x6b21, /* '諮','資','賜','雌','飼','歯','事','似', '侍','児','字','寺','慈','持','時','次', */
	/* 8ea0 */ 0x6ecb,0x6cbb,0x723e,0x74bd,0x75d4,0x78c1,0x793a,0x800c, 0x8033,0x81ea,0x8494,0x8f9e,0x6c50,0x9e7f,0x5f0f,0x8b58, /* '滋','治','爾','璽','痔','磁','示','而', '耳','自','蒔','辞','汐','鹿','式','識', */
	/* 8eb0 */ 0x9d2b,0x7afa,0x8ef8,0x5b8d,0x96eb,0x4e03,0x53f1,0x57f7, 0x5931,0x5ac9,0x5ba4,0x6089,0x6e7f,0x6f06,0x75be,0x8cea, /* '鴫','竺','軸','宍','雫','七','叱','執', '失','嫉','室','悉','湿','漆','疾','質', */
	/* 8ec0 */ 0x5b9f,0x8500,0x7be0,0x5072,0x67f4,0x829d,0x5c61,0x854a, 0x7e1e,0x820e,0x5199,0x5c04,0x6368,0x8d66,0x659c,0x716e, /* '実','蔀','篠','偲','柴','芝','屡','蕊', '縞','舎','写','射','捨','赦','斜','煮', */
	/* 8ed0 */ 0x793e,0x7d17,0x8005,0x8b1d,0x8eca,0x906e,0x86c7,0x90aa, 0x501f,0x52fa,0x5c3a,0x6753,0x707c,0x7235,0x914c,0x91c8, /* '社','紗','者','謝','車','遮','蛇','邪', '借','勺','尺','杓','灼','爵','酌','釈', */
	/* 8ee0 */ 0x932b,0x82e5,0x5bc2,0x5f31,0x60f9,0x4e3b,0x53d6,0x5b88, 0x624b,0x6731,0x6b8a,0x72e9,0x73e0,0x7a2e,0x816b,0x8da3, /* '錫','若','寂','弱','惹','主','取','守', '手','朱','殊','狩','珠','種','腫','趣', */
	/* 8ef0 */ 0x9152,0x9996,0x5112,0x53d7,0x546a,0x5bff,0x6388,0x6a39, 0x7dac,0x9700,0x56da,0x53ce,0x5468,0,0,0, /* '酒','首','儒','受','呪','寿','授','樹', '綬','需','囚','収','周',0,0,0, */
	/* 8f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f40 */ 0x5b97,0x5c31,0x5dde,0x4fee,0x6101,0x62fe,0x6d32,0x79c0, 0x79cb,0x7d42,0x7e4d,0x7fd2,0x81ed,0x821f,0x8490,0x8846, /* '宗','就','州','修','愁','拾','洲','秀', '秋','終','繍','習','臭','舟','蒐','衆', */
	/* 8f50 */ 0x8972,0x8b90,0x8e74,0x8f2f,0x9031,0x914b,0x916c,0x96c6, 0x919c,0x4ec0,0x4f4f,0x5145,0x5341,0x5f93,0x620e,0x67d4, /* '襲','讐','蹴','輯','週','酋','酬','集', '醜','什','住','充','十','従','戎','柔', */
	/* 8f60 */ 0x6c41,0x6e0b,0x7363,0x7e26,0x91cd,0x9283,0x53d4,0x5919, 0x5bbf,0x6dd1,0x795d,0x7e2e,0x7c9b,0x587e,0x719f,0x51fa, /* '汁','渋','獣','縦','重','銃','叔','夙', '宿','淑','祝','縮','粛','塾','熟','出', */
	/* 8f70 */ 0x8853,0x8ff0,0x4fca,0x5cfb,0x6625,0x77ac,0x7ae3,0x821c, 0x99ff,0x51c6,0x5faa,0x65ec,0x696f,0x6b89,0x6df3,0, /* '術','述','俊','峻','春','瞬','竣','舜', '駿','准','循','旬','楯','殉','淳',0, */
	/* 8f80 */ 0x6e96,0x6f64,0x76fe,0x7d14,0x5de1,0x9075,0x9187,0x9806, 0x51e6,0x521d,0x6240,0x6691,0x66d9,0x6e1a,0x5eb6,0x7dd2, /* '準','潤','盾','純','巡','遵','醇','順', '処','初','所','暑','曙','渚','庶','緒', */
	/* 8f90 */ 0x7f72,0x66f8,0x85af,0x85f7,0x8af8,0x52a9,0x53d9,0x5973, 0x5e8f,0x5f90,0x6055,0x92e4,0x9664,0x50b7,0x511f,0x52dd, /* '署','書','薯','藷','諸','助','叙','女', '序','徐','恕','鋤','除','傷','償','勝', */
	/* 8fa0 */ 0x5320,0x5347,0x53ec,0x54e8,0x5546,0x5531,0x5617,0x5968, 0x59be,0x5a3c,0x5bb5,0x5c06,0x5c0f,0x5c11,0x5c1a,0x5e84, /* '匠','升','召','哨','商','唱','嘗','奨', '妾','娼','宵','将','小','少','尚','庄', */
	/* 8fb0 */ 0x5e8a,0x5ee0,0x5f70,0x627f,0x6284,0x62db,0x638c,0x6377, 0x6607,0x660c,0x662d,0x6676,0x677e,0x68a2,0x6a1f,0x6a35, /* '床','廠','彰','承','抄','招','掌','捷', '昇','昌','昭','晶','松','梢','樟','樵', */
	/* 8fc0 */ 0x6cbc,0x6d88,0x6e09,0x6e58,0x713c,0x7126,0x7167,0x75c7, 0x7701,0x785d,0x7901,0x7965,0x79f0,0x7ae0,0x7b11,0x7ca7, /* '沼','消','渉','湘','焼','焦','照','症', '省','硝','礁','祥','称','章','笑','粧', */
	/* 8fd0 */ 0x7d39,0x8096,0x83d6,0x848b,0x8549,0x885d,0x88f3,0x8a1f, 0x8a3c,0x8a54,0x8a73,0x8c61,0x8cde,0x91a4,0x9266,0x937e, /* '紹','肖','菖','蒋','蕉','衝','裳','訟', '証','詔','詳','象','賞','醤','鉦','鍾', */
	/* 8fe0 */ 0x9418,0x969c,0x9798,0x4e0a,0x4e08,0x4e1e,0x4e57,0x5197, 0x5270,0x57ce,0x5834,0x58cc,0x5b22,0x5e38,0x60c5,0x64fe, /* '鐘','障','鞘','上','丈','丞','乗','冗', '剰','城','場','壌','嬢','常','情','擾', */
	/* 8ff0 */ 0x6761,0x6756,0x6d44,0x72b6,0x7573,0x7a63,0x84b8,0x8b72, 0x91b8,0x9320,0x5631,0x57f4,0x98fe,0,0,0, /* '条','杖','浄','状','畳','穣','蒸','譲', '醸','錠','嘱','埴','飾',0,0,0, */
	/* 9000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9040 */ 0x62ed,0x690d,0x6b96,0x71ed,0x7e54,0x8077,0x8272,0x89e6, 0x98df,0x8755,0x8fb1,0x5c3b,0x4f38,0x4fe1,0x4fb5,0x5507, /* '拭','植','殖','燭','織','職','色','触', '食','蝕','辱','尻','伸','信','侵','唇', */
	/* 9050 */ 0x5a20,0x5bdd,0x5be9,0x5fc3,0x614e,0x632f,0x65b0,0x664b, 0x68ee,0x699b,0x6d78,0x6df1,0x7533,0x75b9,0x771f,0x795e, /* '娠','寝','審','心','慎','振','新','晋', '森','榛','浸','深','申','疹','真','神', */
	/* 9060 */ 0x79e6,0x7d33,0x81e3,0x82af,0x85aa,0x89aa,0x8a3a,0x8eab, 0x8f9b,0x9032,0x91dd,0x9707,0x4eba,0x4ec1,0x5203,0x5875, /* '秦','紳','臣','芯','薪','親','診','身', '辛','進','針','震','人','仁','刃','塵', */
	/* 9070 */ 0x58ec,0x5c0b,0x751a,0x5c3d,0x814e,0x8a0a,0x8fc5,0x9663, 0x976d,0x7b25,0x8acf,0x9808,0x9162,0x56f3,0x53a8,0, /* '壬','尋','甚','尽','腎','訊','迅','陣', '靭','笥','諏','須','酢','図','厨',0, */
	/* 9080 */ 0x9017,0x5439,0x5782,0x5e25,0x63a8,0x6c34,0x708a,0x7761, 0x7c8b,0x7fe0,0x8870,0x9042,0x9154,0x9310,0x9318,0x968f, /* '逗','吹','垂','帥','推','水','炊','睡', '粋','翠','衰','遂','酔','錐','錘','随', */
	/* 9090 */ 0x745e,0x9ac4,0x5d07,0x5d69,0x6570,0x67a2,0x8da8,0x96db, 0x636e,0x6749,0x6919,0x83c5,0x9817,0x96c0,0x88fe,0x6f84, /* '瑞','髄','崇','嵩','数','枢','趨','雛', '据','杉','椙','菅','頗','雀','裾','澄', */
	/* 90a0 */ 0x647a,0x5bf8,0x4e16,0x702c,0x755d,0x662f,0x51c4,0x5236, 0x52e2,0x59d3,0x5f81,0x6027,0x6210,0x653f,0x6574,0x661f, /* '摺','寸','世','瀬','畝','是','凄','制', '勢','姓','征','性','成','政','整','星', */
	/* 90b0 */ 0x6674,0x68f2,0x6816,0x6b63,0x6e05,0x7272,0x751f,0x76db, 0x7cbe,0x8056,0x58f0,0x88fd,0x897f,0x8aa0,0x8a93,0x8acb, /* '晴','棲','栖','正','清','牲','生','盛', '精','聖','声','製','西','誠','誓','請', */
	/* 90c0 */ 0x901d,0x9192,0x9752,0x9759,0x6589,0x7a0e,0x8106,0x96bb, 0x5e2d,0x60dc,0x621a,0x65a5,0x6614,0x6790,0x77f3,0x7a4d, /* '逝','醒','青','静','斉','税','脆','隻', '席','惜','戚','斥','昔','析','石','積', */
	/* 90d0 */ 0x7c4d,0x7e3e,0x810a,0x8cac,0x8d64,0x8de1,0x8e5f,0x78a9, 0x5207,0x62d9,0x63a5,0x6442,0x6298,0x8a2d,0x7a83,0x7bc0, /* '籍','績','脊','責','赤','跡','蹟','碩', '切','拙','接','摂','折','設','窃','節', */
	/* 90e0 */ 0x8aac,0x96ea,0x7d76,0x820c,0x8749,0x4ed9,0x5148,0x5343, 0x5360,0x5ba3,0x5c02,0x5c16,0x5ddd,0x6226,0x6247,0x64b0, /* '説','雪','絶','舌','蝉','仙','先','千', '占','宣','専','尖','川','戦','扇','撰', */
	/* 90f0 */ 0x6813,0x6834,0x6cc9,0x6d45,0x6d17,0x67d3,0x6f5c,0x714e, 0x717d,0x65cb,0x7a7f,0x7bad,0x7dda,0,0,0, /* '栓','栴','泉','浅','洗','染','潜','煎', '煽','旋','穿','箭','線',0,0,0, */
	/* 9100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9140 */ 0x7e4a,0x7fa8,0x817a,0x821b,0x8239,0x85a6,0x8a6e,0x8cce, 0x8df5,0x9078,0x9077,0x92ad,0x9291,0x9583,0x9bae,0x524d, /* '繊','羨','腺','舛','船','薦','詮','賎', '践','選','遷','銭','銑','閃','鮮','前', */
	/* 9150 */ 0x5584,0x6f38,0x7136,0x5168,0x7985,0x7e55,0x81b3,0x7cce, 0x564c,0x5851,0x5ca8,0x63aa,0x66fe,0x66fd,0x695a,0x72d9, /* '善','漸','然','全','禅','繕','膳','糎', '噌','塑','岨','措','曾','曽','楚','狙', */
	/* 9160 */ 0x758f,0x758e,0x790e,0x7956,0x79df,0x7c97,0x7d20,0x7d44, 0x8607,0x8a34,0x963b,0x9061,0x9f20,0x50e7,0x5275,0x53cc, /* '疏','疎','礎','祖','租','粗','素','組', '蘇','訴','阻','遡','鼠','僧','創','双', */
	/* 9170 */ 0x53e2,0x5009,0x55aa,0x58ee,0x594f,0x723d,0x5b8b,0x5c64, 0x531d,0x60e3,0x60f3,0x635c,0x6383,0x633f,0x63bb,0, /* '叢','倉','喪','壮','奏','爽','宋','層', '匝','惣','想','捜','掃','挿','掻',0, */
	/* 9180 */ 0x64cd,0x65e9,0x66f9,0x5de3,0x69cd,0x69fd,0x6f15,0x71e5, 0x4e89,0x75e9,0x76f8,0x7a93,0x7cdf,0x7dcf,0x7d9c,0x8061, /* '操','早','曹','巣','槍','槽','漕','燥', '争','痩','相','窓','糟','総','綜','聡', */
	/* 9190 */ 0x8349,0x8358,0x846c,0x84bc,0x85fb,0x88c5,0x8d70,0x9001, 0x906d,0x9397,0x971c,0x9a12,0x50cf,0x5897,0x618e,0x81d3, /* '草','荘','葬','蒼','藻','装','走','送', '遭','鎗','霜','騒','像','増','憎','臓', */
	/* 91a0 */ 0x8535,0x8d08,0x9020,0x4fc3,0x5074,0x5247,0x5373,0x606f, 0x6349,0x675f,0x6e2c,0x8db3,0x901f,0x4fd7,0x5c5e,0x8cca, /* '蔵','贈','造','促','側','則','即','息', '捉','束','測','足','速','俗','属','賊', */
	/* 91b0 */ 0x65cf,0x7d9a,0x5352,0x8896,0x5176,0x63c3,0x5b58,0x5b6b, 0x5c0a,0x640d,0x6751,0x905c,0x4ed6,0x591a,0x592a,0x6c70, /* '族','続','卒','袖','其','揃','存','孫', '尊','損','村','遜','他','多','太','汰', */
	/* 91c0 */ 0x8a51,0x553e,0x5815,0x59a5,0x60f0,0x6253,0x67c1,0x8235, 0x6955,0x9640,0x99c4,0x9a28,0x4f53,0x5806,0x5bfe,0x8010, /* '詑','唾','堕','妥','惰','打','柁','舵', '楕','陀','駄','騨','体','堆','対','耐', */
	/* 91d0 */ 0x5cb1,0x5e2f,0x5f85,0x6020,0x614b,0x6234,0x66ff,0x6cf0, 0x6ede,0x80ce,0x817f,0x82d4,0x888b,0x8cb8,0x9000,0x902e, /* '岱','帯','待','怠','態','戴','替','泰', '滞','胎','腿','苔','袋','貸','退','逮', */
	/* 91e0 */ 0x968a,0x9edb,0x9bdb,0x4ee3,0x53f0,0x5927,0x7b2c,0x918d, 0x984c,0x9df9,0x6edd,0x7027,0x5353,0x5544,0x5b85,0x6258, /* '隊','黛','鯛','代','台','大','第','醍', '題','鷹','滝','瀧','卓','啄','宅','托', */
	/* 91f0 */ 0x629e,0x62d3,0x6ca2,0x6fef,0x7422,0x8a17,0x9438,0x6fc1, 0x8afe,0x8338,0x51e7,0x86f8,0x53ea,0,0,0, /* '択','拓','沢','濯','琢','託','鐸','濁', '諾','茸','凧','蛸','只',0,0,0, */
	/* 9200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9240 */ 0x53e9,0x4f46,0x9054,0x8fb0,0x596a,0x8131,0x5dfd,0x7aea, 0x8fbf,0x68da,0x8c37,0x72f8,0x9c48,0x6a3d,0x8ab0,0x4e39, /* '叩','但','達','辰','奪','脱','巽','竪', '辿','棚','谷','狸','鱈','樽','誰','丹', */
	/* 9250 */ 0x5358,0x5606,0x5766,0x62c5,0x63a2,0x65e6,0x6b4e,0x6de1, 0x6e5b,0x70ad,0x77ed,0x7aef,0x7baa,0x7dbb,0x803d,0x80c6, /* '単','嘆','坦','担','探','旦','歎','淡', '湛','炭','短','端','箪','綻','耽','胆', */
	/* 9260 */ 0x86cb,0x8a95,0x935b,0x56e3,0x58c7,0x5f3e,0x65ad,0x6696, 0x6a80,0x6bb5,0x7537,0x8ac7,0x5024,0x77e5,0x5730,0x5f1b, /* '蛋','誕','鍛','団','壇','弾','断','暖', '檀','段','男','談','値','知','地','弛', */
	/* 9270 */ 0x6065,0x667a,0x6c60,0x75f4,0x7a1a,0x7f6e,0x81f4,0x8718, 0x9045,0x99b3,0x7bc9,0x755c,0x7af9,0x7b51,0x84c4,0, /* '恥','智','池','痴','稚','置','致','蜘', '遅','馳','築','畜','竹','筑','蓄',0, */
	/* 9280 */ 0x9010,0x79e9,0x7a92,0x8336,0x5ae1,0x7740,0x4e2d,0x4ef2, 0x5b99,0x5fe0,0x62bd,0x663c,0x67f1,0x6ce8,0x866b,0x8877, /* '逐','秩','窒','茶','嫡','着','中','仲', '宙','忠','抽','昼','柱','注','虫','衷', */
	/* 9290 */ 0x8a3b,0x914e,0x92f3,0x99d0,0x6a17,0x7026,0x732a,0x82e7, 0x8457,0x8caf,0x4e01,0x5146,0x51cb,0x558b,0x5bf5,0x5e16, /* '註','酎','鋳','駐','樗','瀦','猪','苧', '著','貯','丁','兆','凋','喋','寵','帖', */
	/* 92a0 */ 0x5e33,0x5e81,0x5f14,0x5f35,0x5f6b,0x5fb4,0x61f2,0x6311, 0x66a2,0x671d,0x6f6e,0x7252,0x753a,0x773a,0x8074,0x8139, /* '帳','庁','弔','張','彫','徴','懲','挑', '暢','朝','潮','牒','町','眺','聴','脹', */
	/* 92b0 */ 0x8178,0x8776,0x8abf,0x8adc,0x8d85,0x8df3,0x929a,0x9577, 0x9802,0x9ce5,0x52c5,0x6357,0x76f4,0x6715,0x6c88,0x73cd, /* '腸','蝶','調','諜','超','跳','銚','長', '頂','鳥','勅','捗','直','朕','沈','珍', */
	/* 92c0 */ 0x8cc3,0x93ae,0x9673,0x6d25,0x589c,0x690e,0x69cc,0x8ffd, 0x939a,0x75db,0x901a,0x585a,0x6802,0x63b4,0x69fb,0x4f43, /* '賃','鎮','陳','津','墜','椎','槌','追', '鎚','痛','通','塚','栂','掴','槻','佃', */
	/* 92d0 */ 0x6f2c,0x67d8,0x8fbb,0x8526,0x7db4,0x9354,0x693f,0x6f70, 0x576a,0x58f7,0x5b2c,0x7d2c,0x722a,0x540a,0x91e3,0x9db4, /* '漬','柘','辻','蔦','綴','鍔','椿','潰', '坪','壷','嬬','紬','爪','吊','釣','鶴', */
	/* 92e0 */ 0x4ead,0x4f4e,0x505c,0x5075,0x5243,0x8c9e,0x5448,0x5824, 0x5b9a,0x5e1d,0x5e95,0x5ead,0x5ef7,0x5f1f,0x608c,0x62b5, /* '亭','低','停','偵','剃','貞','呈','堤', '定','帝','底','庭','廷','弟','悌','抵', */
	/* 92f0 */ 0x633a,0x63d0,0x68af,0x6c40,0x7887,0x798e,0x7a0b,0x7de0, 0x8247,0x8a02,0x8ae6,0x8e44,0x9013,0,0,0, /* '挺','提','梯','汀','碇','禎','程','締', '艇','訂','諦','蹄','逓',0,0,0, */
	/* 9300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9340 */ 0x90b8,0x912d,0x91d8,0x9f0e,0x6ce5,0x6458,0x64e2,0x6575, 0x6ef4,0x7684,0x7b1b,0x9069,0x93d1,0x6eba,0x54f2,0x5fb9, /* '邸','鄭','釘','鼎','泥','摘','擢','敵', '滴','的','笛','適','鏑','溺','哲','徹', */
	/* 9350 */ 0x64a4,0x8f4d,0x8fed,0x9244,0x5178,0x586b,0x5929,0x5c55, 0x5e97,0x6dfb,0x7e8f,0x751c,0x8cbc,0x8ee2,0x985b,0x70b9, /* '撤','轍','迭','鉄','典','填','天','展', '店','添','纏','甜','貼','転','顛','点', */
	/* 9360 */ 0x4f1d,0x6bbf,0x6fb1,0x7530,0x96fb,0x514e,0x5410,0x5835, 0x5857,0x59ac,0x5c60,0x5f92,0x6597,0x675c,0x6e21,0x767b, /* '伝','殿','澱','田','電','兎','吐','堵', '塗','妬','屠','徒','斗','杜','渡','登', */
	/* 9370 */ 0x83df,0x8ced,0x9014,0x90fd,0x934d,0x7825,0x783a,0x52aa, 0x5ea6,0x571f,0x5974,0x6012,0x5012,0x515a,0x51ac,0, /* '菟','賭','途','都','鍍','砥','砺','努', '度','土','奴','怒','倒','党','冬',0, */
	/* 9380 */ 0x51cd,0x5200,0x5510,0x5854,0x5858,0x5957,0x5b95,0x5cf6, 0x5d8b,0x60bc,0x6295,0x642d,0x6771,0x6843,0x68bc,0x68df, /* '凍','刀','唐','塔','塘','套','宕','島', '嶋','悼','投','搭','東','桃','梼','棟', */
	/* 9390 */ 0x76d7,0x6dd8,0x6e6f,0x6d9b,0x706f,0x71c8,0x5f53,0x75d8, 0x7977,0x7b49,0x7b54,0x7b52,0x7cd6,0x7d71,0x5230,0x8463, /* '盗','淘','湯','涛','灯','燈','当','痘', '祷','等','答','筒','糖','統','到','董', */
	/* 93a0 */ 0x8569,0x85e4,0x8a0e,0x8b04,0x8c46,0x8e0f,0x9003,0x900f, 0x9419,0x9676,0x982d,0x9a30,0x95d8,0x50cd,0x52d5,0x540c, /* '蕩','藤','討','謄','豆','踏','逃','透', '鐙','陶','頭','騰','闘','働','動','同', */
	/* 93b0 */ 0x5802,0x5c0e,0x61a7,0x649e,0x6d1e,0x77b3,0x7ae5,0x80f4, 0x8404,0x9053,0x9285,0x5ce0,0x9d07,0x533f,0x5f97,0x5fb3, /* '堂','導','憧','撞','洞','瞳','童','胴', '萄','道','銅','峠','鴇','匿','得','徳', */
	/* 93c0 */ 0x6d9c,0x7279,0x7763,0x79bf,0x7be4,0x6bd2,0x72ec,0x8aad, 0x6803,0x6a61,0x51f8,0x7a81,0x6934,0x5c4a,0x9cf6,0x82eb, /* '涜','特','督','禿','篤','毒','独','読', '栃','橡','凸','突','椴','届','鳶','苫', */
	/* 93d0 */ 0x5bc5,0x9149,0x701e,0x5678,0x5c6f,0x60c7,0x6566,0x6c8c, 0x8c5a,0x9041,0x9813,0x5451,0x66c7,0x920d,0x5948,0x90a3, /* '寅','酉','瀞','噸','屯','惇','敦','沌', '豚','遁','頓','呑','曇','鈍','奈','那', */
	/* 93e0 */ 0x5185,0x4e4d,0x51ea,0x8599,0x8b0e,0x7058,0x637a,0x934b, 0x6962,0x99b4,0x7e04,0x7577,0x5357,0x6960,0x8edf,0x96e3, /* '内','乍','凪','薙','謎','灘','捺','鍋', '楢','馴','縄','畷','南','楠','軟','難', */
	/* 93f0 */ 0x6c5d,0x4e8c,0x5c3c,0x5f10,0x8fe9,0x5302,0x8cd1,0x8089, 0x8679,0x5eff,0x65e5,0x4e73,0x5165,0,0,0, /* '汝','二','尼','弐','迩','匂','賑','肉', '虹','廿','日','乳','入',0,0,0, */
	/* 9400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9440 */ 0x5982,0x5c3f,0x97ee,0x4efb,0x598a,0x5fcd,0x8a8d,0x6fe1, 0x79b0,0x7962,0x5be7,0x8471,0x732b,0x71b1,0x5e74,0x5ff5, /* '如','尿','韮','任','妊','忍','認','濡', '禰','祢','寧','葱','猫','熱','年','念', */
	/* 9450 */ 0x637b,0x649a,0x71c3,0x7c98,0x4e43,0x5efc,0x4e4b,0x57dc, 0x56a2,0x60a9,0x6fc3,0x7d0d,0x80fd,0x8133,0x81bf,0x8fb2, /* '捻','撚','燃','粘','乃','廼','之','埜', '嚢','悩','濃','納','能','脳','膿','農', */
	/* 9460 */ 0x8997,0x86a4,0x5df4,0x628a,0x64ad,0x8987,0x6777,0x6ce2, 0x6d3e,0x7436,0x7834,0x5a46,0x7f75,0x82ad,0x99ac,0x4ff3, /* '覗','蚤','巴','把','播','覇','杷','波', '派','琶','破','婆','罵','芭','馬','俳', */
	/* 9470 */ 0x5ec3,0x62dd,0x6392,0x6557,0x676f,0x76c3,0x724c,0x80cc, 0x80ba,0x8f29,0x914d,0x500d,0x57f9,0x5a92,0x6885,0, /* '廃','拝','排','敗','杯','盃','牌','背', '肺','輩','配','倍','培','媒','梅',0, */
	/* 9480 */ 0x6973,0x7164,0x72fd,0x8cb7,0x58f2,0x8ce0,0x966a,0x9019, 0x877f,0x79e4,0x77e7,0x8429,0x4f2f,0x5265,0x535a,0x62cd, /* '楳','煤','狽','買','売','賠','陪','這', '蝿','秤','矧','萩','伯','剥','博','拍', */
	/* 9490 */ 0x67cf,0x6cca,0x767d,0x7b94,0x7c95,0x8236,0x8584,0x8feb, 0x66dd,0x6f20,0x7206,0x7e1b,0x83ab,0x99c1,0x9ea6,0x51fd, /* '柏','泊','白','箔','粕','舶','薄','迫', '曝','漠','爆','縛','莫','駁','麦','函', */
	/* 94a0 */ 0x7bb1,0x7872,0x7bb8,0x8087,0x7b48,0x6ae8,0x5e61,0x808c, 0x7551,0x7560,0x516b,0x9262,0x6e8c,0x767a,0x9197,0x9aea, /* '箱','硲','箸','肇','筈','櫨','幡','肌', '畑','畠','八','鉢','溌','発','醗','髪', */
	/* 94b0 */ 0x4f10,0x7f70,0x629c,0x7b4f,0x95a5,0x9ce9,0x567a,0x5859, 0x86e4,0x96bc,0x4f34,0x5224,0x534a,0x53cd,0x53db,0x5e06, /* '伐','罰','抜','筏','閥','鳩','噺','塙', '蛤','隼','伴','判','半','反','叛','帆', */
	/* 94c0 */ 0x642c,0x6591,0x677f,0x6c3e,0x6c4e,0x7248,0x72af,0x73ed, 0x7554,0x7e41,0x822c,0x85e9,0x8ca9,0x7bc4,0x91c6,0x7169, /* '搬','斑','板','氾','汎','版','犯','班', '畔','繁','般','藩','販','範','釆','煩', */
	/* 94d0 */ 0x9812,0x98ef,0x633d,0x6669,0x756a,0x76e4,0x78d0,0x8543, 0x86ee,0x532a,0x5351,0x5426,0x5983,0x5e87,0x5f7c,0x60b2, /* '頒','飯','挽','晩','番','盤','磐','蕃', '蛮','匪','卑','否','妃','庇','彼','悲', */
	/* 94e0 */ 0x6249,0x6279,0x62ab,0x6590,0x6bd4,0x6ccc,0x75b2,0x76ae, 0x7891,0x79d8,0x7dcb,0x7f77,0x80a5,0x88ab,0x8ab9,0x8cbb, /* '扉','批','披','斐','比','泌','疲','皮', '碑','秘','緋','罷','肥','被','誹','費', */
	/* 94f0 */ 0x907f,0x975e,0x98db,0x6a0b,0x7c38,0x5099,0x5c3e,0x5fae, 0x6787,0x6bd8,0x7435,0x7709,0x7f8e,0,0,0, /* '避','非','飛','樋','簸','備','尾','微', '枇','毘','琵','眉','美',0,0,0, */
	/* 9500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9540 */ 0x9f3b,0x67ca,0x7a17,0x5339,0x758b,0x9aed,0x5f66,0x819d, 0x83f1,0x8098,0x5f3c,0x5fc5,0x7562,0x7b46,0x903c,0x6867, /* '鼻','柊','稗','匹','疋','髭','彦','膝', '菱','肘','弼','必','畢','筆','逼','桧', */
	/* 9550 */ 0x59eb,0x5a9b,0x7d10,0x767e,0x8b2c,0x4ff5,0x5f6a,0x6a19, 0x6c37,0x6f02,0x74e2,0x7968,0x8868,0x8a55,0x8c79,0x5edf, /* '姫','媛','紐','百','謬','俵','彪','標', '氷','漂','瓢','票','表','評','豹','廟', */
	/* 9560 */ 0x63cf,0x75c5,0x79d2,0x82d7,0x9328,0x92f2,0x849c,0x86ed, 0x9c2d,0x54c1,0x5f6c,0x658c,0x6d5c,0x7015,0x8ca7,0x8cd3, /* '描','病','秒','苗','錨','鋲','蒜','蛭', '鰭','品','彬','斌','浜','瀕','貧','賓', */
	/* 9570 */ 0x983b,0x654f,0x74f6,0x4e0d,0x4ed8,0x57e0,0x592b,0x5a66, 0x5bcc,0x51a8,0x5e03,0x5e9c,0x6016,0x6276,0x6577,0, /* '頻','敏','瓶','不','付','埠','夫','婦', '富','冨','布','府','怖','扶','敷',0, */
	/* 9580 */ 0x65a7,0x666e,0x6d6e,0x7236,0x7b26,0x8150,0x819a,0x8299, 0x8b5c,0x8ca0,0x8ce6,0x8d74,0x961c,0x9644,0x4fae,0x64ab, /* '斧','普','浮','父','符','腐','膚','芙', '譜','負','賦','赴','阜','附','侮','撫', */
	/* 9590 */ 0x6b66,0x821e,0x8461,0x856a,0x90e8,0x5c01,0x6953,0x98a8, 0x847a,0x8557,0x4f0f,0x526f,0x5fa9,0x5e45,0x670d,0x798f, /* '武','舞','葡','蕪','部','封','楓','風', '葺','蕗','伏','副','復','幅','服','福', */
	/* 95a0 */ 0x8179,0x8907,0x8986,0x6df5,0x5f17,0x6255,0x6cb8,0x4ecf, 0x7269,0x9b92,0x5206,0x543b,0x5674,0x58b3,0x61a4,0x626e, /* '腹','複','覆','淵','弗','払','沸','仏', '物','鮒','分','吻','噴','墳','憤','扮', */
	/* 95b0 */ 0x711a,0x596e,0x7c89,0x7cde,0x7d1b,0x96f0,0x6587,0x805e, 0x4e19,0x4f75,0x5175,0x5840,0x5e63,0x5e73,0x5f0a,0x67c4, /* '焚','奮','粉','糞','紛','雰','文','聞', '丙','併','兵','塀','幣','平','弊','柄', */
	/* 95c0 */ 0x4e26,0x853d,0x9589,0x965b,0x7c73,0x9801,0x50fb,0x58c1, 0x7656,0x78a7,0x5225,0x77a5,0x8511,0x7b86,0x504f,0x5909, /* '並','蔽','閉','陛','米','頁','僻','壁', '癖','碧','別','瞥','蔑','箆','偏','変', */
	/* 95d0 */ 0x7247,0x7bc7,0x7de8,0x8fba,0x8fd4,0x904d,0x4fbf,0x52c9, 0x5a29,0x5f01,0x97ad,0x4fdd,0x8217,0x92ea,0x5703,0x6355, /* '片','篇','編','辺','返','遍','便','勉', '娩','弁','鞭','保','舗','鋪','圃','捕', */
	/* 95e0 */ 0x6b69,0x752b,0x88dc,0x8f14,0x7a42,0x52df,0x5893,0x6155, 0x620a,0x66ae,0x6bcd,0x7c3f,0x83e9,0x5023,0x4ff8,0x5305, /* '歩','甫','補','輔','穂','募','墓','慕', '戊','暮','母','簿','菩','倣','俸','包', */
	/* 95f0 */ 0x5446,0x5831,0x5949,0x5b9d,0x5cf0,0x5cef,0x5d29,0x5e96, 0x62b1,0x6367,0x653e,0x65b9,0x670b,0,0,0, /* '呆','報','奉','宝','峰','峯','崩','庖', '抱','捧','放','方','朋',0,0,0, */
	/* 9600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9640 */ 0x6cd5,0x6ce1,0x70f9,0x7832,0x7e2b,0x80de,0x82b3,0x840c, 0x84ec,0x8702,0x8912,0x8a2a,0x8c4a,0x90a6,0x92d2,0x98fd, /* '法','泡','烹','砲','縫','胞','芳','萌', '蓬','蜂','褒','訪','豊','邦','鋒','飽', */
	/* 9650 */ 0x9cf3,0x9d6c,0x4e4f,0x4ea1,0x508d,0x5256,0x574a,0x59a8, 0x5e3d,0x5fd8,0x5fd9,0x623f,0x66b4,0x671b,0x67d0,0x68d2, /* '鳳','鵬','乏','亡','傍','剖','坊','妨', '帽','忘','忙','房','暴','望','某','棒', */
	/* 9660 */ 0x5192,0x7d21,0x80aa,0x81a8,0x8b00,0x8c8c,0x8cbf,0x927e, 0x9632,0x5420,0x982c,0x5317,0x50d5,0x535c,0x58a8,0x64b2, /* '冒','紡','肪','膨','謀','貌','貿','鉾', '防','吠','頬','北','僕','卜','墨','撲', */
	/* 9670 */ 0x6734,0x7267,0x7766,0x7a46,0x91e6,0x52c3,0x6ca1,0x6b86, 0x5800,0x5e4c,0x5954,0x672c,0x7ffb,0x51e1,0x76c6,0, /* '朴','牧','睦','穆','釦','勃','没','殆', '堀','幌','奔','本','翻','凡','盆',0, */
	/* 9680 */ 0x6469,0x78e8,0x9b54,0x9ebb,0x57cb,0x59b9,0x6627,0x679a, 0x6bce,0x54e9,0x69d9,0x5e55,0x819c,0x6795,0x9baa,0x67fe, /* '摩','磨','魔','麻','埋','妹','昧','枚', '毎','哩','槙','幕','膜','枕','鮪','柾', */
	/* 9690 */ 0x9c52,0x685d,0x4ea6,0x4fe3,0x53c8,0x62b9,0x672b,0x6cab, 0x8fc4,0x4fad,0x7e6d,0x9ebf,0x4e07,0x6162,0x6e80,0x6f2b, /* '鱒','桝','亦','俣','又','抹','末','沫', '迄','侭','繭','麿','万','慢','満','漫', */
	/* 96a0 */ 0x8513,0x5473,0x672a,0x9b45,0x5df3,0x7b95,0x5cac,0x5bc6, 0x871c,0x6e4a,0x84d1,0x7a14,0x8108,0x5999,0x7c8d,0x6c11, /* '蔓','味','未','魅','巳','箕','岬','密', '蜜','湊','蓑','稔','脈','妙','粍','民', */
	/* 96b0 */ 0x7720,0x52d9,0x5922,0x7121,0x725f,0x77db,0x9727,0x9d61, 0x690b,0x5a7f,0x5a18,0x51a5,0x540d,0x547d,0x660e,0x76df, /* '眠','務','夢','無','牟','矛','霧','鵡', '椋','婿','娘','冥','名','命','明','盟', */
	/* 96c0 */ 0x8ff7,0x9298,0x9cf4,0x59ea,0x725d,0x6ec5,0x514d,0x68c9, 0x7dbf,0x7dec,0x9762,0x9eba,0x6478,0x6a21,0x8302,0x5984, /* '迷','銘','鳴','姪','牝','滅','免','棉', '綿','緬','面','麺','摸','模','茂','妄', */
	/* 96d0 */ 0x5b5f,0x6bdb,0x731b,0x76f2,0x7db2,0x8017,0x8499,0x5132, 0x6728,0x9ed9,0x76ee,0x6762,0x52ff,0x9905,0x5c24,0x623b, /* '孟','毛','猛','盲','網','耗','蒙','儲', '木','黙','目','杢','勿','餅','尤','戻', */
	/* 96e0 */ 0x7c7e,0x8cb0,0x554f,0x60b6,0x7d0b,0x9580,0x5301,0x4e5f, 0x51b6,0x591c,0x723a,0x8036,0x91ce,0x5f25,0x77e2,0x5384, /* '籾','貰','問','悶','紋','門','匁','也', '冶','夜','爺','耶','野','弥','矢','厄', */
	/* 96f0 */ 0x5f79,0x7d04,0x85ac,0x8a33,0x8e8d,0x9756,0x67f3,0x85ae, 0x9453,0x6109,0x6108,0x6cb9,0x7652,0,0,0, /* '役','約','薬','訳','躍','靖','柳','薮', '鑓','愉','愈','油','癒',0,0,0, */
	/* 9700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9740 */ 0x8aed,0x8f38,0x552f,0x4f51,0x512a,0x52c7,0x53cb,0x5ba5, 0x5e7d,0x60a0,0x6182,0x63d6,0x6709,0x67da,0x6e67,0x6d8c, /* '諭','輸','唯','佑','優','勇','友','宥', '幽','悠','憂','揖','有','柚','湧','涌', */
	/* 9750 */ 0x7336,0x7337,0x7531,0x7950,0x88d5,0x8a98,0x904a,0x9091, 0x90f5,0x96c4,0x878d,0x5915,0x4e88,0x4f59,0x4e0e,0x8a89, /* '猶','猷','由','祐','裕','誘','遊','邑', '郵','雄','融','夕','予','余','与','誉', */
	/* 9760 */ 0x8f3f,0x9810,0x50ad,0x5e7c,0x5996,0x5bb9,0x5eb8,0x63da, 0x63fa,0x64c1,0x66dc,0x694a,0x69d8,0x6d0b,0x6eb6,0x7194, /* '輿','預','傭','幼','妖','容','庸','揚', '揺','擁','曜','楊','様','洋','溶','熔', */
	/* 9770 */ 0x7528,0x7aaf,0x7f8a,0x8000,0x8449,0x84c9,0x8981,0x8b21, 0x8e0a,0x9065,0x967d,0x990a,0x617e,0x6291,0x6b32,0, /* '用','窯','羊','耀','葉','蓉','要','謡', '踊','遥','陽','養','慾','抑','欲',0, */
	/* 9780 */ 0x6c83,0x6d74,0x7fcc,0x7ffc,0x6dc0,0x7f85,0x87ba,0x88f8, 0x6765,0x83b1,0x983c,0x96f7,0x6d1b,0x7d61,0x843d,0x916a, /* '沃','浴','翌','翼','淀','羅','螺','裸', '来','莱','頼','雷','洛','絡','落','酪', */
	/* 9790 */ 0x4e71,0x5375,0x5d50,0x6b04,0x6feb,0x85cd,0x862d,0x89a7, 0x5229,0x540f,0x5c65,0x674e,0x68a8,0x7406,0x7483,0x75e2, /* '乱','卵','嵐','欄','濫','藍','蘭','覧', '利','吏','履','李','梨','理','璃','痢', */
	/* 97a0 */ 0x88cf,0x88e1,0x91cc,0x96e2,0x9678,0x5f8b,0x7387,0x7acb, 0x844e,0x63a0,0x7565,0x5289,0x6d41,0x6e9c,0x7409,0x7559, /* '裏','裡','里','離','陸','律','率','立', '葎','掠','略','劉','流','溜','琉','留', */
	/* 97b0 */ 0x786b,0x7c92,0x9686,0x7adc,0x9f8d,0x4fb6,0x616e,0x65c5, 0x865c,0x4e86,0x4eae,0x50da,0x4e21,0x51cc,0x5bee,0x6599, /* '硫','粒','隆','竜','龍','侶','慮','旅', '虜','了','亮','僚','両','凌','寮','料', */
	/* 97c0 */ 0x6881,0x6dbc,0x731f,0x7642,0x77ad,0x7a1c,0x7ce7,0x826f, 0x8ad2,0x907c,0x91cf,0x9675,0x9818,0x529b,0x7dd1,0x502b, /* '梁','涼','猟','療','瞭','稜','糧','良', '諒','遼','量','陵','領','力','緑','倫', */
	/* 97d0 */ 0x5398,0x6797,0x6dcb,0x71d0,0x7433,0x81e8,0x8f2a,0x96a3, 0x9c57,0x9e9f,0x7460,0x5841,0x6d99,0x7d2f,0x985e,0x4ee4, /* '厘','林','淋','燐','琳','臨','輪','隣', '鱗','麟','瑠','塁','涙','累','類','令', */
	/* 97e0 */ 0x4f36,0x4f8b,0x51b7,0x52b1,0x5dba,0x601c,0x73b2,0x793c, 0x82d3,0x9234,0x96b7,0x96f6,0x970a,0x9e97,0x9f62,0x66a6, /* '伶','例','冷','励','嶺','怜','玲','礼', '苓','鈴','隷','零','霊','麗','齢','暦', */
	/* 97f0 */ 0x6b74,0x5217,0x52a3,0x70c8,0x88c2,0x5ec9,0x604b,0x6190, 0x6f23,0x7149,0x7c3e,0x7df4,0x806f,0,0,0, /* '歴','列','劣','烈','裂','廉','恋','憐', '漣','煉','簾','練','聯',0,0,0, */
	/* 9800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9840 */ 0x84ee,0x9023,0x932c,0x5442,0x9b6f,0x6ad3,0x7089,0x8cc2, 0x8def,0x9732,0x52b4,0x5a41,0x5eca,0x5f04,0x6717,0x697c, /* '蓮','連','錬','呂','魯','櫓','炉','賂', '路','露','労','婁','廊','弄','朗','楼', */
	/* 9850 */ 0x6994,0x6d6a,0x6f0f,0x7262,0x72fc,0x7bed,0x8001,0x807e, 0x874b,0x90ce,0x516d,0x9e93,0x7984,0x808b,0x9332,0x8ad6, /* '榔','浪','漏','牢','狼','篭','老','聾', '蝋','郎','六','麓','禄','肋','録','論', */
	/* 9860 */ 0x502d,0x548c,0x8a71,0x6b6a,0x8cc4,0x8107,0x60d1,0x67a0, 0x9df2,0x4e99,0x4e98,0x9c10,0x8a6b,0x85c1,0x8568,0x6900, /* '倭','和','話','歪','賄','脇','惑','枠', '鷲','亙','亘','鰐','詫','藁','蕨','椀', */
	/* 9870 */ 0x6e7e,0x7897,0x8155,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '湾','碗','腕',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x5f0c, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'弌', */
	/* 98a0 */ 0x4e10,0x4e15,0x4e2a,0x4e31,0x4e36,0x4e3c,0x4e3f,0x4e42, 0x4e56,0x4e58,0x4e82,0x4e85,0x8c6b,0x4e8a,0x8212,0x5f0d, /* '丐','丕','个','丱','丶','丼','丿','乂', '乖','乘','亂','亅','豫','亊','舒','弍', */
	/* 98b0 */ 0x4e8e,0x4e9e,0x4e9f,0x4ea0,0x4ea2,0x4eb0,0x4eb3,0x4eb6, 0x4ece,0x4ecd,0x4ec4,0x4ec6,0x4ec2,0x4ed7,0x4ede,0x4eed, /* '于','亞','亟','亠','亢','亰','亳','亶', '从','仍','仄','仆','仂','仗','仞','仭', */
	/* 98c0 */ 0x4edf,0x4ef7,0x4f09,0x4f5a,0x4f30,0x4f5b,0x4f5d,0x4f57, 0x4f47,0x4f76,0x4f88,0x4f8f,0x4f98,0x4f7b,0x4f69,0x4f70, /* '仟','价','伉','佚','估','佛','佝','佗', '佇','佶','侈','侏','侘','佻','佩','佰', */
	/* 98d0 */ 0x4f91,0x4f6f,0x4f86,0x4f96,0x5118,0x4fd4,0x4fdf,0x4fce, 0x4fd8,0x4fdb,0x4fd1,0x4fda,0x4fd0,0x4fe4,0x4fe5,0x501a, /* '侑','佯','來','侖','儘','俔','俟','俎', '俘','俛','俑','俚','俐','俤','俥','倚', */
	/* 98e0 */ 0x5028,0x5014,0x502a,0x5025,0x5005,0x4f1c,0x4ff6,0x5021, 0x5029,0x502c,0x4ffe,0x4fef,0x5011,0x5006,0x5043,0x5047, /* '倨','倔','倪','倥','倅','伜','俶','倡', '倩','倬','俾','俯','們','倆','偃','假', */
	/* 98f0 */ 0x6703,0x5055,0x5050,0x5048,0x505a,0x5056,0x506c,0x5078, 0x5080,0x509a,0x5085,0x50b4,0x50b2,0,0,0, /* '會','偕','偐','偈','做','偖','偬','偸', '傀','傚','傅','傴','傲',0,0,0, */
	/* 9900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9940 */ 0x50c9,0x50ca,0x50b3,0x50c2,0x50d6,0x50de,0x50e5,0x50ed, 0x50e3,0x50ee,0x50f9,0x50f5,0x5109,0x5101,0x5102,0x5116, /* '僉','僊','傳','僂','僖','僞','僥','僭', '僣','僮','價','僵','儉','儁','儂','儖', */
	/* 9950 */ 0x5115,0x5114,0x511a,0x5121,0x513a,0x5137,0x513c,0x513b, 0x513f,0x5140,0x5152,0x514c,0x5154,0x5162,0x7af8,0x5169, /* '儕','儔','儚','儡','儺','儷','儼','儻', '儿','兀','兒','兌','兔','兢','竸','兩', */
	/* 9960 */ 0x516a,0x516e,0x5180,0x5182,0x56d8,0x518c,0x5189,0x518f, 0x5191,0x5193,0x5195,0x5196,0x51a4,0x51a6,0x51a2,0x51a9, /* '兪','兮','冀','冂','囘','册','冉','冏', '冑','冓','冕','冖','冤','冦','冢','冩', */
	/* 9970 */ 0x51aa,0x51ab,0x51b3,0x51b1,0x51b2,0x51b0,0x51b5,0x51bd, 0x51c5,0x51c9,0x51db,0x51e0,0x8655,0x51e9,0x51ed,0, /* '冪','冫','决','冱','冲','冰','况','冽', '凅','凉','凛','几','處','凩','凭',0, */
	/* 9980 */ 0x51f0,0x51f5,0x51fe,0x5204,0x520b,0x5214,0x520e,0x5227, 0x522a,0x522e,0x5233,0x5239,0x524f,0x5244,0x524b,0x524c, /* '凰','凵','凾','刄','刋','刔','刎','刧', '刪','刮','刳','刹','剏','剄','剋','剌', */
	/* 9990 */ 0x525e,0x5254,0x526a,0x5274,0x5269,0x5273,0x527f,0x527d, 0x528d,0x5294,0x5292,0x5271,0x5288,0x5291,0x8fa8,0x8fa7, /* '剞','剔','剪','剴','剩','剳','剿','剽', '劍','劔','劒','剱','劈','劑','辨','辧', */
	/* 99a0 */ 0x52ac,0x52ad,0x52bc,0x52b5,0x52c1,0x52cd,0x52d7,0x52de, 0x52e3,0x52e6,0x98ed,0x52e0,0x52f3,0x52f5,0x52f8,0x52f9, /* '劬','劭','劼','劵','勁','勍','勗','勞', '勣','勦','飭','勠','勳','勵','勸','勹', */
	/* 99b0 */ 0x5306,0x5308,0x7538,0x530d,0x5310,0x530f,0x5315,0x531a, 0x5323,0x532f,0x5331,0x5333,0x5338,0x5340,0x5346,0x5345, /* '匆','匈','甸','匍','匐','匏','匕','匚', '匣','匯','匱','匳','匸','區','卆','卅', */
	/* 99c0 */ 0x4e17,0x5349,0x534d,0x51d6,0x535e,0x5369,0x536e,0x5918, 0x537b,0x5377,0x5382,0x5396,0x53a0,0x53a6,0x53a5,0x53ae, /* '丗','卉','卍','凖','卞','卩','卮','夘', '卻','卷','厂','厖','厠','厦','厥','厮', */
	/* 99d0 */ 0x53b0,0x53b6,0x53c3,0x7c12,0x96d9,0x53df,0x66fc,0x71ee, 0x53ee,0x53e8,0x53ed,0x53fa,0x5401,0x543d,0x5440,0x542c, /* '厰','厶','參','簒','雙','叟','曼','燮', '叮','叨','叭','叺','吁','吽','呀','听', */
	/* 99e0 */ 0x542d,0x543c,0x542e,0x5436,0x5429,0x541d,0x544e,0x548f, 0x5475,0x548e,0x545f,0x5471,0x5477,0x5470,0x5492,0x547b, /* '吭','吼','吮','吶','吩','吝','呎','咏', '呵','咎','呟','呱','呷','呰','咒','呻', */
	/* 99f0 */ 0x5480,0x5476,0x5484,0x5490,0x5486,0x54c7,0x54a2,0x54b8, 0x54a5,0x54ac,0x54c4,0x54c8,0x54a8,0,0,0, /* '咀','呶','咄','咐','咆','哇','咢','咸', '咥','咬','哄','哈','咨',0,0,0, */
	/* 9a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a40 */ 0x54ab,0x54c2,0x54a4,0x54be,0x54bc,0x54d8,0x54e5,0x54e6, 0x550f,0x5514,0x54fd,0x54ee,0x54ed,0x54fa,0x54e2,0x5539, /* '咫','哂','咤','咾','咼','哘','哥','哦', '唏','唔','哽','哮','哭','哺','哢','唹', */
	/* 9a50 */ 0x5540,0x5563,0x554c,0x552e,0x555c,0x5545,0x5556,0x5557, 0x5538,0x5533,0x555d,0x5599,0x5580,0x54af,0x558a,0x559f, /* '啀','啣','啌','售','啜','啅','啖','啗', '唸','唳','啝','喙','喀','咯','喊','喟', */
	/* 9a60 */ 0x557b,0x557e,0x5598,0x559e,0x55ae,0x557c,0x5583,0x55a9, 0x5587,0x55a8,0x55da,0x55c5,0x55df,0x55c4,0x55dc,0x55e4, /* '啻','啾','喘','喞','單','啼','喃','喩', '喇','喨','嗚','嗅','嗟','嗄','嗜','嗤', */
	/* 9a70 */ 0x55d4,0x5614,0x55f7,0x5616,0x55fe,0x55fd,0x561b,0x55f9, 0x564e,0x5650,0x71df,0x5634,0x5636,0x5632,0x5638,0, /* '嗔','嘔','嗷','嘖','嗾','嗽','嘛','嗹', '噎','噐','營','嘴','嘶','嘲','嘸',0, */
	/* 9a80 */ 0x566b,0x5664,0x562f,0x566c,0x566a,0x5686,0x5680,0x568a, 0x56a0,0x5694,0x568f,0x56a5,0x56ae,0x56b6,0x56b4,0x56c2, /* '噫','噤','嘯','噬','噪','嚆','嚀','嚊', '嚠','嚔','嚏','嚥','嚮','嚶','嚴','囂', */
	/* 9a90 */ 0x56bc,0x56c1,0x56c3,0x56c0,0x56c8,0x56ce,0x56d1,0x56d3, 0x56d7,0x56ee,0x56f9,0x5700,0x56ff,0x5704,0x5709,0x5708, /* '嚼','囁','囃','囀','囈','囎','囑','囓', '囗','囮','囹','圀','囿','圄','圉','圈', */
	/* 9aa0 */ 0x570b,0x570d,0x5713,0x5718,0x5716,0x55c7,0x571c,0x5726, 0x5737,0x5738,0x574e,0x573b,0x5740,0x574f,0x5769,0x57c0, /* '國','圍','圓','團','圖','嗇','圜','圦', '圷','圸','坎','圻','址','坏','坩','埀', */
	/* 9ab0 */ 0x5788,0x5761,0x577f,0x5789,0x5793,0x57a0,0x57b3,0x57a4, 0x57aa,0x57b0,0x57c3,0x57c6,0x57d4,0x57d2,0x57d3,0x580a, /* '垈','坡','坿','垉','垓','垠','垳','垤', '垪','垰','埃','埆','埔','埒','埓','堊', */
	/* 9ac0 */ 0x57d6,0x57e3,0x580b,0x5819,0x581d,0x5872,0x5821,0x5862, 0x584b,0x5870,0x6bc0,0x5852,0x583d,0x5879,0x5885,0x58b9, /* '埖','埣','堋','堙','堝','塲','堡','塢', '塋','塰','毀','塒','堽','塹','墅','墹', */
	/* 9ad0 */ 0x589f,0x58ab,0x58ba,0x58de,0x58bb,0x58b8,0x58ae,0x58c5, 0x58d3,0x58d1,0x58d7,0x58d9,0x58d8,0x58e5,0x58dc,0x58e4, /* '墟','墫','墺','壞','墻','墸','墮','壅', '壓','壑','壗','壙','壘','壥','壜','壤', */
	/* 9ae0 */ 0x58df,0x58ef,0x58fa,0x58f9,0x58fb,0x58fc,0x58fd,0x5902, 0x590a,0x5910,0x591b,0x68a6,0x5925,0x592c,0x592d,0x5932, /* '壟','壯','壺','壹','壻','壼','壽','夂', '夊','夐','夛','梦','夥','夬','夭','夲', */
	/* 9af0 */ 0x5938,0x593e,0x7ad2,0x5955,0x5950,0x594e,0x595a,0x5958, 0x5962,0x5960,0x5967,0x596c,0x5969,0,0,0, /* '夸','夾','竒','奕','奐','奎','奚','奘', '奢','奠','奧','奬','奩',0,0,0, */
	/* 9b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9b40 */ 0x5978,0x5981,0x599d,0x4f5e,0x4fab,0x59a3,0x59b2,0x59c6, 0x59e8,0x59dc,0x598d,0x59d9,0x59da,0x5a25,0x5a1f,0x5a11, /* '奸','妁','妝','佞','侫','妣','妲','姆', '姨','姜','妍','姙','姚','娥','娟','娑', */
	/* 9b50 */ 0x5a1c,0x5a09,0x5a1a,0x5a40,0x5a6c,0x5a49,0x5a35,0x5a36, 0x5a62,0x5a6a,0x5a9a,0x5abc,0x5abe,0x5acb,0x5ac2,0x5abd, /* '娜','娉','娚','婀','婬','婉','娵','娶', '婢','婪','媚','媼','媾','嫋','嫂','媽', */
	/* 9b60 */ 0x5ae3,0x5ad7,0x5ae6,0x5ae9,0x5ad6,0x5afa,0x5afb,0x5b0c, 0x5b0b,0x5b16,0x5b32,0x5ad0,0x5b2a,0x5b36,0x5b3e,0x5b43, /* '嫣','嫗','嫦','嫩','嫖','嫺','嫻','嬌', '嬋','嬖','嬲','嫐','嬪','嬶','嬾','孃', */
	/* 9b70 */ 0x5b45,0x5b40,0x5b51,0x5b55,0x5b5a,0x5b5b,0x5b65,0x5b69, 0x5b70,0x5b73,0x5b75,0x5b78,0x6588,0x5b7a,0x5b80,0, /* '孅','孀','孑','孕','孚','孛','孥','孩', '孰','孳','孵','學','斈','孺','宀',0, */
	/* 9b80 */ 0x5b83,0x5ba6,0x5bb8,0x5bc3,0x5bc7,0x5bc9,0x5bd4,0x5bd0, 0x5be4,0x5be6,0x5be2,0x5bde,0x5be5,0x5beb,0x5bf0,0x5bf6, /* '它','宦','宸','寃','寇','寉','寔','寐', '寤','實','寢','寞','寥','寫','寰','寶', */
	/* 9b90 */ 0x5bf3,0x5c05,0x5c07,0x5c08,0x5c0d,0x5c13,0x5c20,0x5c22, 0x5c28,0x5c38,0x5c39,0x5c41,0x5c46,0x5c4e,0x5c53,0x5c50, /* '寳','尅','將','專','對','尓','尠','尢', '尨','尸','尹','屁','屆','屎','屓','屐', */
	/* 9ba0 */ 0x5c4f,0x5b71,0x5c6c,0x5c6e,0x4e62,0x5c76,0x5c79,0x5c8c, 0x5c91,0x5c94,0x599b,0x5cab,0x5cbb,0x5cb6,0x5cbc,0x5cb7, /* '屏','孱','屬','屮','乢','屶','屹','岌', '岑','岔','妛','岫','岻','岶','岼','岷', */
	/* 9bb0 */ 0x5cc5,0x5cbe,0x5cc7,0x5cd9,0x5ce9,0x5cfd,0x5cfa,0x5ced, 0x5d8c,0x5cea,0x5d0b,0x5d15,0x5d17,0x5d5c,0x5d1f,0x5d1b, /* '峅','岾','峇','峙','峩','峽','峺','峭', '嶌','峪','崋','崕','崗','嵜','崟','崛', */
	/* 9bc0 */ 0x5d11,0x5d14,0x5d22,0x5d1a,0x5d19,0x5d18,0x5d4c,0x5d52, 0x5d4e,0x5d4b,0x5d6c,0x5d73,0x5d76,0x5d87,0x5d84,0x5d82, /* '崑','崔','崢','崚','崙','崘','嵌','嵒', '嵎','嵋','嵬','嵳','嵶','嶇','嶄','嶂', */
	/* 9bd0 */ 0x5da2,0x5d9d,0x5dac,0x5dae,0x5dbd,0x5d90,0x5db7,0x5dbc, 0x5dc9,0x5dcd,0x5dd3,0x5dd2,0x5dd6,0x5ddb,0x5deb,0x5df2, /* '嶢','嶝','嶬','嶮','嶽','嶐','嶷','嶼', '巉','巍','巓','巒','巖','巛','巫','已', */
	/* 9be0 */ 0x5df5,0x5e0b,0x5e1a,0x5e19,0x5e11,0x5e1b,0x5e36,0x5e37, 0x5e44,0x5e43,0x5e40,0x5e4e,0x5e57,0x5e54,0x5e5f,0x5e62, /* '巵','帋','帚','帙','帑','帛','帶','帷', '幄','幃','幀','幎','幗','幔','幟','幢', */
	/* 9bf0 */ 0x5e64,0x5e47,0x5e75,0x5e76,0x5e7a,0x9ebc,0x5e7f,0x5ea0, 0x5ec1,0x5ec2,0x5ec8,0x5ed0,0x5ecf,0,0,0, /* '幤','幇','幵','并','幺','麼','广','庠', '廁','廂','廈','廐','廏',0,0,0, */
	/* 9c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c40 */ 0x5ed6,0x5ee3,0x5edd,0x5eda,0x5edb,0x5ee2,0x5ee1,0x5ee8, 0x5ee9,0x5eec,0x5ef1,0x5ef3,0x5ef0,0x5ef4,0x5ef8,0x5efe, /* '廖','廣','廝','廚','廛','廢','廡','廨', '廩','廬','廱','廳','廰','廴','廸','廾', */
	/* 9c50 */ 0x5f03,0x5f09,0x5f5d,0x5f5c,0x5f0b,0x5f11,0x5f16,0x5f29, 0x5f2d,0x5f38,0x5f41,0x5f48,0x5f4c,0x5f4e,0x5f2f,0x5f51, /* '弃','弉','彝','彜','弋','弑','弖','弩', '弭','弸','彁','彈','彌','彎','弯','彑', */
	/* 9c60 */ 0x5f56,0x5f57,0x5f59,0x5f61,0x5f6d,0x5f73,0x5f77,0x5f83, 0x5f82,0x5f7f,0x5f8a,0x5f88,0x5f91,0x5f87,0x5f9e,0x5f99, /* '彖','彗','彙','彡','彭','彳','彷','徃', '徂','彿','徊','很','徑','徇','從','徙', */
	/* 9c70 */ 0x5f98,0x5fa0,0x5fa8,0x5fad,0x5fbc,0x5fd6,0x5ffb,0x5fe4, 0x5ff8,0x5ff1,0x5fdd,0x60b3,0x5fff,0x6021,0x6060,0, /* '徘','徠','徨','徭','徼','忖','忻','忤', '忸','忱','忝','悳','忿','怡','恠',0, */
	/* 9c80 */ 0x6019,0x6010,0x6029,0x600e,0x6031,0x601b,0x6015,0x602b, 0x6026,0x600f,0x603a,0x605a,0x6041,0x606a,0x6077,0x605f, /* '怙','怐','怩','怎','怱','怛','怕','怫', '怦','怏','怺','恚','恁','恪','恷','恟', */
	/* 9c90 */ 0x604a,0x6046,0x604d,0x6063,0x6043,0x6064,0x6042,0x606c, 0x606b,0x6059,0x6081,0x608d,0x60e7,0x6083,0x609a,0x6084, /* '恊','恆','恍','恣','恃','恤','恂','恬', '恫','恙','悁','悍','惧','悃','悚','悄', */
	/* 9ca0 */ 0x609b,0x6096,0x6097,0x6092,0x60a7,0x608b,0x60e1,0x60b8, 0x60e0,0x60d3,0x60b4,0x5ff0,0x60bd,0x60c6,0x60b5,0x60d8, /* '悛','悖','悗','悒','悧','悋','惡','悸', '惠','惓','悴','忰','悽','惆','悵','惘', */
	/* 9cb0 */ 0x614d,0x6115,0x6106,0x60f6,0x60f7,0x6100,0x60f4,0x60fa, 0x6103,0x6121,0x60fb,0x60f1,0x610d,0x610e,0x6147,0x613e, /* '慍','愕','愆','惶','惷','愀','惴','惺', '愃','愡','惻','惱','愍','愎','慇','愾', */
	/* 9cc0 */ 0x6128,0x6127,0x614a,0x613f,0x613c,0x612c,0x6134,0x613d, 0x6142,0x6144,0x6173,0x6177,0x6158,0x6159,0x615a,0x616b, /* '愨','愧','慊','愿','愼','愬','愴','愽', '慂','慄','慳','慷','慘','慙','慚','慫', */
	/* 9cd0 */ 0x6174,0x616f,0x6165,0x6171,0x615f,0x615d,0x6153,0x6175, 0x6199,0x6196,0x6187,0x61ac,0x6194,0x619a,0x618a,0x6191, /* '慴','慯','慥','慱','慟','慝','慓','慵', '憙','憖','憇','憬','憔','憚','憊','憑', */
	/* 9ce0 */ 0x61ab,0x61ae,0x61cc,0x61ca,0x61c9,0x61f7,0x61c8,0x61c3, 0x61c6,0x61ba,0x61cb,0x7f79,0x61cd,0x61e6,0x61e3,0x61f6, /* '憫','憮','懌','懊','應','懷','懈','懃', '懆','憺','懋','罹','懍','懦','懣','懶', */
	/* 9cf0 */ 0x61fa,0x61f4,0x61ff,0x61fd,0x61fc,0x61fe,0x6200,0x6208, 0x6209,0x620d,0x620c,0x6214,0x621b,0,0,0, /* '懺','懴','懿','懽','懼','懾','戀','戈', '戉','戍','戌','戔','戛',0,0,0, */
	/* 9d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9d40 */ 0x621e,0x6221,0x622a,0x622e,0x6230,0x6232,0x6233,0x6241, 0x624e,0x625e,0x6263,0x625b,0x6260,0x6268,0x627c,0x6282, /* '戞','戡','截','戮','戰','戲','戳','扁', '扎','扞','扣','扛','扠','扨','扼','抂', */
	/* 9d50 */ 0x6289,0x627e,0x6292,0x6293,0x6296,0x62d4,0x6283,0x6294, 0x62d7,0x62d1,0x62bb,0x62cf,0x62ff,0x62c6,0x64d4,0x62c8, /* '抉','找','抒','抓','抖','拔','抃','抔', '拗','拑','抻','拏','拿','拆','擔','拈', */
	/* 9d60 */ 0x62dc,0x62cc,0x62ca,0x62c2,0x62c7,0x629b,0x62c9,0x630c, 0x62ee,0x62f1,0x6327,0x6302,0x6308,0x62ef,0x62f5,0x6350, /* '拜','拌','拊','拂','拇','抛','拉','挌', '拮','拱','挧','挂','挈','拯','拵','捐', */
	/* 9d70 */ 0x633e,0x634d,0x641c,0x634f,0x6396,0x638e,0x6380,0x63ab, 0x6376,0x63a3,0x638f,0x6389,0x639f,0x63b5,0x636b,0, /* '挾','捍','搜','捏','掖','掎','掀','掫', '捶','掣','掏','掉','掟','掵','捫',0, */
	/* 9d80 */ 0x6369,0x63be,0x63e9,0x63c0,0x63c6,0x63e3,0x63c9,0x63d2, 0x63f6,0x63c4,0x6416,0x6434,0x6406,0x6413,0x6426,0x6436, /* '捩','掾','揩','揀','揆','揣','揉','插', '揶','揄','搖','搴','搆','搓','搦','搶', */
	/* 9d90 */ 0x651d,0x6417,0x6428,0x640f,0x6467,0x646f,0x6476,0x644e, 0x652a,0x6495,0x6493,0x64a5,0x64a9,0x6488,0x64bc,0x64da, /* '攝','搗','搨','搏','摧','摯','摶','摎', '攪','撕','撓','撥','撩','撈','撼','據', */
	/* 9da0 */ 0x64d2,0x64c5,0x64c7,0x64bb,0x64d8,0x64c2,0x64f1,0x64e7, 0x8209,0x64e0,0x64e1,0x62ac,0x64e3,0x64ef,0x652c,0x64f6, /* '擒','擅','擇','撻','擘','擂','擱','擧', '舉','擠','擡','抬','擣','擯','攬','擶', */
	/* 9db0 */ 0x64f4,0x64f2,0x64fa,0x6500,0x64fd,0x6518,0x651c,0x6505, 0x6524,0x6523,0x652b,0x6534,0x6535,0x6537,0x6536,0x6538, /* '擴','擲','擺','攀','擽','攘','攜','攅', '攤','攣','攫','攴','攵','攷','收','攸', */
	/* 9dc0 */ 0x754b,0x6548,0x6556,0x6555,0x654d,0x6558,0x655e,0x655d, 0x6572,0x6578,0x6582,0x6583,0x8b8a,0x659b,0x659f,0x65ab, /* '畋','效','敖','敕','敍','敘','敞','敝', '敲','數','斂','斃','變','斛','斟','斫', */
	/* 9dd0 */ 0x65b7,0x65c3,0x65c6,0x65c1,0x65c4,0x65cc,0x65d2,0x65db, 0x65d9,0x65e0,0x65e1,0x65f1,0x6772,0x660a,0x6603,0x65fb, /* '斷','旃','旆','旁','旄','旌','旒','旛', '旙','无','旡','旱','杲','昊','昃','旻', */
	/* 9de0 */ 0x6773,0x6635,0x6636,0x6634,0x661c,0x664f,0x6644,0x6649, 0x6641,0x665e,0x665d,0x6664,0x6667,0x6668,0x665f,0x6662, /* '杳','昵','昶','昴','昜','晏','晄','晉', '晁','晞','晝','晤','晧','晨','晟','晢', */
	/* 9df0 */ 0x6670,0x6683,0x6688,0x668e,0x6689,0x6684,0x6698,0x669d, 0x66c1,0x66b9,0x66c9,0x66be,0x66bc,0,0,0, /* '晰','暃','暈','暎','暉','暄','暘','暝', '曁','暹','曉','暾','暼',0,0,0, */
	/* 9e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e40 */ 0x66c4,0x66b8,0x66d6,0x66da,0x66e0,0x663f,0x66e6,0x66e9, 0x66f0,0x66f5,0x66f7,0x670f,0x6716,0x671e,0x6726,0x6727, /* '曄','暸','曖','曚','曠','昿','曦','曩', '曰','曵','曷','朏','朖','朞','朦','朧', */
	/* 9e50 */ 0x9738,0x672e,0x673f,0x6736,0x6741,0x6738,0x6737,0x6746, 0x675e,0x6760,0x6759,0x6763,0x6764,0x6789,0x6770,0x67a9, /* '霸','朮','朿','朶','杁','朸','朷','杆', '杞','杠','杙','杣','杤','枉','杰','枩', */
	/* 9e60 */ 0x677c,0x676a,0x678c,0x678b,0x67a6,0x67a1,0x6785,0x67b7, 0x67ef,0x67b4,0x67ec,0x67b3,0x67e9,0x67b8,0x67e4,0x67de, /* '杼','杪','枌','枋','枦','枡','枅','枷', '柯','枴','柬','枳','柩','枸','柤','柞', */
	/* 9e70 */ 0x67dd,0x67e2,0x67ee,0x67b9,0x67ce,0x67c6,0x67e7,0x6a9c, 0x681e,0x6846,0x6829,0x6840,0x684d,0x6832,0x684e,0, /* '柝','柢','柮','枹','柎','柆','柧','檜', '栞','框','栩','桀','桍','栲','桎',0, */
	/* 9e80 */ 0x68b3,0x682b,0x6859,0x6863,0x6877,0x687f,0x689f,0x688f, 0x68ad,0x6894,0x689d,0x689b,0x6883,0x6aae,0x68b9,0x6874, /* '梳','栫','桙','档','桷','桿','梟','梏', '梭','梔','條','梛','梃','檮','梹','桴', */
	/* 9e90 */ 0x68b5,0x68a0,0x68ba,0x690f,0x688d,0x687e,0x6901,0x68ca, 0x6908,0x68d8,0x6922,0x6926,0x68e1,0x690c,0x68cd,0x68d4, /* '梵','梠','梺','椏','梍','桾','椁','棊', '椈','棘','椢','椦','棡','椌','棍','棔', */
	/* 9ea0 */ 0x68e7,0x68d5,0x6936,0x6912,0x6904,0x68d7,0x68e3,0x6925, 0x68f9,0x68e0,0x68ef,0x6928,0x692a,0x691a,0x6923,0x6921, /* '棧','棕','椶','椒','椄','棗','棣','椥', '棹','棠','棯','椨','椪','椚','椣','椡', */
	/* 9eb0 */ 0x68c6,0x6979,0x6977,0x695c,0x6978,0x696b,0x6954,0x697e, 0x696e,0x6939,0x6974,0x693d,0x6959,0x6930,0x6961,0x695e, /* '棆','楹','楷','楜','楸','楫','楔','楾', '楮','椹','楴','椽','楙','椰','楡','楞', */
	/* 9ec0 */ 0x695d,0x6981,0x696a,0x69b2,0x69ae,0x69d0,0x69bf,0x69c1, 0x69d3,0x69be,0x69ce,0x5be8,0x69ca,0x69dd,0x69bb,0x69c3, /* '楝','榁','楪','榲','榮','槐','榿','槁', '槓','榾','槎','寨','槊','槝','榻','槃', */
	/* 9ed0 */ 0x69a7,0x6a2e,0x6991,0x69a0,0x699c,0x6995,0x69b4,0x69de, 0x69e8,0x6a02,0x6a1b,0x69ff,0x6b0a,0x69f9,0x69f2,0x69e7, /* '榧','樮','榑','榠','榜','榕','榴','槞', '槨','樂','樛','槿','權','槹','槲','槧', */
	/* 9ee0 */ 0x6a05,0x69b1,0x6a1e,0x69ed,0x6a14,0x69eb,0x6a0a,0x6a12, 0x6ac1,0x6a23,0x6a13,0x6a44,0x6a0c,0x6a72,0x6a36,0x6a78, /* '樅','榱','樞','槭','樔','槫','樊','樒', '櫁','樣','樓','橄','樌','橲','樶','橸', */
	/* 9ef0 */ 0x6a47,0x6a62,0x6a59,0x6a66,0x6a48,0x6a38,0x6a22,0x6a90, 0x6a8d,0x6aa0,0x6a84,0x6aa2,0x6aa3,0,0,0, /* '橇','橢','橙','橦','橈','樸','樢','檐', '檍','檠','檄','檢','檣',0,0,0, */
	/* 9f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9f40 */ 0x6a97,0x8617,0x6abb,0x6ac3,0x6ac2,0x6ab8,0x6ab3,0x6aac, 0x6ade,0x6ad1,0x6adf,0x6aaa,0x6ada,0x6aea,0x6afb,0x6b05, /* '檗','蘗','檻','櫃','櫂','檸','檳','檬', '櫞','櫑','櫟','檪','櫚','櫪','櫻','欅', */
	/* 9f50 */ 0x8616,0x6afa,0x6b12,0x6b16,0x9b31,0x6b1f,0x6b38,0x6b37, 0x76dc,0x6b39,0x98ee,0x6b47,0x6b43,0x6b49,0x6b50,0x6b59, /* '蘖','櫺','欒','欖','鬱','欟','欸','欷', '盜','欹','飮','歇','歃','歉','歐','歙', */
	/* 9f60 */ 0x6b54,0x6b5b,0x6b5f,0x6b61,0x6b78,0x6b79,0x6b7f,0x6b80, 0x6b84,0x6b83,0x6b8d,0x6b98,0x6b95,0x6b9e,0x6ba4,0x6baa, /* '歔','歛','歟','歡','歸','歹','歿','殀', '殄','殃','殍','殘','殕','殞','殤','殪', */
	/* 9f70 */ 0x6bab,0x6baf,0x6bb2,0x6bb1,0x6bb3,0x6bb7,0x6bbc,0x6bc6, 0x6bcb,0x6bd3,0x6bdf,0x6bec,0x6beb,0x6bf3,0x6bef,0, /* '殫','殯','殲','殱','殳','殷','殼','毆', '毋','毓','毟','毬','毫','毳','毯',0, */
	/* 9f80 */ 0x9ebe,0x6c08,0x6c13,0x6c14,0x6c1b,0x6c24,0x6c23,0x6c5e, 0x6c55,0x6c62,0x6c6a,0x6c82,0x6c8d,0x6c9a,0x6c81,0x6c9b, /* '麾','氈','氓','气','氛','氤','氣','汞', '汕','汢','汪','沂','沍','沚','沁','沛', */
	/* 9f90 */ 0x6c7e,0x6c68,0x6c73,0x6c92,0x6c90,0x6cc4,0x6cf1,0x6cd3, 0x6cbd,0x6cd7,0x6cc5,0x6cdd,0x6cae,0x6cb1,0x6cbe,0x6cba, /* '汾','汨','汳','沒','沐','泄','泱','泓', '沽','泗','泅','泝','沮','沱','沾','沺', */
	/* 9fa0 */ 0x6cdb,0x6cef,0x6cd9,0x6cea,0x6d1f,0x884d,0x6d36,0x6d2b, 0x6d3d,0x6d38,0x6d19,0x6d35,0x6d33,0x6d12,0x6d0c,0x6d63, /* '泛','泯','泙','泪','洟','衍','洶','洫', '洽','洸','洙','洵','洳','洒','洌','浣', */
	/* 9fb0 */ 0x6d93,0x6d64,0x6d5a,0x6d79,0x6d59,0x6d8e,0x6d95,0x6fe4, 0x6d85,0x6df9,0x6e15,0x6e0a,0x6db5,0x6dc7,0x6de6,0x6db8, /* '涓','浤','浚','浹','浙','涎','涕','濤', '涅','淹','渕','渊','涵','淇','淦','涸', */
	/* 9fc0 */ 0x6dc6,0x6dec,0x6dde,0x6dcc,0x6de8,0x6dd2,0x6dc5,0x6dfa, 0x6dd9,0x6de4,0x6dd5,0x6dea,0x6dee,0x6e2d,0x6e6e,0x6e2e, /* '淆','淬','淞','淌','淨','淒','淅','淺', '淙','淤','淕','淪','淮','渭','湮','渮', */
	/* 9fd0 */ 0x6e19,0x6e72,0x6e5f,0x6e3e,0x6e23,0x6e6b,0x6e2b,0x6e76, 0x6e4d,0x6e1f,0x6e43,0x6e3a,0x6e4e,0x6e24,0x6eff,0x6e1d, /* '渙','湲','湟','渾','渣','湫','渫','湶', '湍','渟','湃','渺','湎','渤','滿','渝', */
	/* 9fe0 */ 0x6e38,0x6e82,0x6eaa,0x6e98,0x6ec9,0x6eb7,0x6ed3,0x6ebd, 0x6eaf,0x6ec4,0x6eb2,0x6ed4,0x6ed5,0x6e8f,0x6ea5,0x6ec2, /* '游','溂','溪','溘','滉','溷','滓','溽', '溯','滄','溲','滔','滕','溏','溥','滂', */
	/* 9ff0 */ 0x6e9f,0x6f41,0x6f11,0x704c,0x6eec,0x6ef8,0x6efe,0x6f3f, 0x6ef2,0x6f31,0x6eef,0x6f32,0x6ecc,0,0,0, /* '溟','潁','漑','灌','滬','滸','滾','漿', '滲','漱','滯','漲','滌',0,0,0, */
	/* a000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ace0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ada0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* add0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ade0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* beb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ceb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ced0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* deb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ded0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* def0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e040 */ 0x6f3e,0x6f13,0x6ef7,0x6f86,0x6f7a,0x6f78,0x6f81,0x6f80, 0x6f6f,0x6f5b,0x6ff3,0x6f6d,0x6f82,0x6f7c,0x6f58,0x6f8e, /* '漾','漓','滷','澆','潺','潸','澁','澀', '潯','潛','濳','潭','澂','潼','潘','澎', */
	/* e050 */ 0x6f91,0x6fc2,0x6f66,0x6fb3,0x6fa3,0x6fa1,0x6fa4,0x6fb9, 0x6fc6,0x6faa,0x6fdf,0x6fd5,0x6fec,0x6fd4,0x6fd8,0x6ff1, /* '澑','濂','潦','澳','澣','澡','澤','澹', '濆','澪','濟','濕','濬','濔','濘','濱', */
	/* e060 */ 0x6fee,0x6fdb,0x7009,0x700b,0x6ffa,0x7011,0x7001,0x700f, 0x6ffe,0x701b,0x701a,0x6f74,0x701d,0x7018,0x701f,0x7030, /* '濮','濛','瀉','瀋','濺','瀑','瀁','瀏', '濾','瀛','瀚','潴','瀝','瀘','瀟','瀰', */
	/* e070 */ 0x703e,0x7032,0x7051,0x7063,0x7099,0x7092,0x70af,0x70f1, 0x70ac,0x70b8,0x70b3,0x70ae,0x70df,0x70cb,0x70dd,0, /* '瀾','瀲','灑','灣','炙','炒','炯','烱', '炬','炸','炳','炮','烟','烋','烝',0, */
	/* e080 */ 0x70d9,0x7109,0x70fd,0x711c,0x7119,0x7165,0x7155,0x7188, 0x7166,0x7162,0x714c,0x7156,0x716c,0x718f,0x71fb,0x7184, /* '烙','焉','烽','焜','焙','煥','煕','熈', '煦','煢','煌','煖','煬','熏','燻','熄', */
	/* e090 */ 0x7195,0x71a8,0x71ac,0x71d7,0x71b9,0x71be,0x71d2,0x71c9, 0x71d4,0x71ce,0x71e0,0x71ec,0x71e7,0x71f5,0x71fc,0x71f9, /* '熕','熨','熬','燗','熹','熾','燒','燉', '燔','燎','燠','燬','燧','燵','燼','燹', */
	/* e0a0 */ 0x71ff,0x720d,0x7210,0x721b,0x7228,0x722d,0x722c,0x7230, 0x7232,0x723b,0x723c,0x723f,0x7240,0x7246,0x724b,0x7258, /* '燿','爍','爐','爛','爨','爭','爬','爰', '爲','爻','爼','爿','牀','牆','牋','牘', */
	/* e0b0 */ 0x7274,0x727e,0x7282,0x7281,0x7287,0x7292,0x7296,0x72a2, 0x72a7,0x72b9,0x72b2,0x72c3,0x72c6,0x72c4,0x72ce,0x72d2, /* '牴','牾','犂','犁','犇','犒','犖','犢', '犧','犹','犲','狃','狆','狄','狎','狒', */
	/* e0c0 */ 0x72e2,0x72e0,0x72e1,0x72f9,0x72f7,0x500f,0x7317,0x730a, 0x731c,0x7316,0x731d,0x7334,0x732f,0x7329,0x7325,0x733e, /* '狢','狠','狡','狹','狷','倏','猗','猊', '猜','猖','猝','猴','猯','猩','猥','猾', */
	/* e0d0 */ 0x734e,0x734f,0x9ed8,0x7357,0x736a,0x7368,0x7370,0x7378, 0x7375,0x737b,0x737a,0x73c8,0x73b3,0x73ce,0x73bb,0x73c0, /* '獎','獏','默','獗','獪','獨','獰','獸', '獵','獻','獺','珈','玳','珎','玻','珀', */
	/* e0e0 */ 0x73e5,0x73ee,0x73de,0x74a2,0x7405,0x746f,0x7425,0x73f8, 0x7432,0x743a,0x7455,0x743f,0x745f,0x7459,0x7441,0x745c, /* '珥','珮','珞','璢','琅','瑯','琥','珸', '琲','琺','瑕','琿','瑟','瑙','瑁','瑜', */
	/* e0f0 */ 0x7469,0x7470,0x7463,0x746a,0x7476,0x747e,0x748b,0x749e, 0x74a7,0x74ca,0x74cf,0x74d4,0x73f1,0,0,0, /* '瑩','瑰','瑣','瑪','瑶','瑾','璋','璞', '璧','瓊','瓏','瓔','珱',0,0,0, */
	/* e100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e140 */ 0x74e0,0x74e3,0x74e7,0x74e9,0x74ee,0x74f2,0x74f0,0x74f1, 0x74f8,0x74f7,0x7504,0x7503,0x7505,0x750c,0x750e,0x750d, /* '瓠','瓣','瓧','瓩','瓮','瓲','瓰','瓱', '瓸','瓷','甄','甃','甅','甌','甎','甍', */
	/* e150 */ 0x7515,0x7513,0x751e,0x7526,0x752c,0x753c,0x7544,0x754d, 0x754a,0x7549,0x755b,0x7546,0x755a,0x7569,0x7564,0x7567, /* '甕','甓','甞','甦','甬','甼','畄','畍', '畊','畉','畛','畆','畚','畩','畤','畧', */
	/* e160 */ 0x756b,0x756d,0x7578,0x7576,0x7586,0x7587,0x7574,0x758a, 0x7589,0x7582,0x7594,0x759a,0x759d,0x75a5,0x75a3,0x75c2, /* '畫','畭','畸','當','疆','疇','畴','疊', '疉','疂','疔','疚','疝','疥','疣','痂', */
	/* e170 */ 0x75b3,0x75c3,0x75b5,0x75bd,0x75b8,0x75bc,0x75b1,0x75cd, 0x75ca,0x75d2,0x75d9,0x75e3,0x75de,0x75fe,0x75ff,0, /* '疳','痃','疵','疽','疸','疼','疱','痍', '痊','痒','痙','痣','痞','痾','痿',0, */
	/* e180 */ 0x75fc,0x7601,0x75f0,0x75fa,0x75f2,0x75f3,0x760b,0x760d, 0x7609,0x761f,0x7627,0x7620,0x7621,0x7622,0x7624,0x7634, /* '痼','瘁','痰','痺','痲','痳','瘋','瘍', '瘉','瘟','瘧','瘠','瘡','瘢','瘤','瘴', */
	/* e190 */ 0x7630,0x763b,0x7647,0x7648,0x7646,0x765c,0x7658,0x7661, 0x7662,0x7668,0x7669,0x766a,0x7667,0x766c,0x7670,0x7672, /* '瘰','瘻','癇','癈','癆','癜','癘','癡', '癢','癨','癩','癪','癧','癬','癰','癲', */
	/* e1a0 */ 0x7676,0x7678,0x767c,0x7680,0x7683,0x7688,0x768b,0x768e, 0x7696,0x7693,0x7699,0x769a,0x76b0,0x76b4,0x76b8,0x76b9, /* '癶','癸','發','皀','皃','皈','皋','皎', '皖','皓','皙','皚','皰','皴','皸','皹', */
	/* e1b0 */ 0x76ba,0x76c2,0x76cd,0x76d6,0x76d2,0x76de,0x76e1,0x76e5, 0x76e7,0x76ea,0x862f,0x76fb,0x7708,0x7707,0x7704,0x7729, /* '皺','盂','盍','盖','盒','盞','盡','盥', '盧','盪','蘯','盻','眈','眇','眄','眩', */
	/* e1c0 */ 0x7724,0x771e,0x7725,0x7726,0x771b,0x7737,0x7738,0x7747, 0x775a,0x7768,0x776b,0x775b,0x7765,0x777f,0x777e,0x7779, /* '眤','眞','眥','眦','眛','眷','眸','睇', '睚','睨','睫','睛','睥','睿','睾','睹', */
	/* e1d0 */ 0x778e,0x778b,0x7791,0x77a0,0x779e,0x77b0,0x77b6,0x77b9, 0x77bf,0x77bc,0x77bd,0x77bb,0x77c7,0x77cd,0x77d7,0x77da, /* '瞎','瞋','瞑','瞠','瞞','瞰','瞶','瞹', '瞿','瞼','瞽','瞻','矇','矍','矗','矚', */
	/* e1e0 */ 0x77dc,0x77e3,0x77ee,0x77fc,0x780c,0x7812,0x7926,0x7820, 0x792a,0x7845,0x788e,0x7874,0x7886,0x787c,0x789a,0x788c, /* '矜','矣','矮','矼','砌','砒','礦','砠', '礪','硅','碎','硴','碆','硼','碚','碌', */
	/* e1f0 */ 0x78a3,0x78b5,0x78aa,0x78af,0x78d1,0x78c6,0x78cb,0x78d4, 0x78be,0x78bc,0x78c5,0x78ca,0x78ec,0,0,0, /* '碣','碵','碪','碯','磑','磆','磋','磔', '碾','碼','磅','磊','磬',0,0,0, */
	/* e200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e240 */ 0x78e7,0x78da,0x78fd,0x78f4,0x7907,0x7912,0x7911,0x7919, 0x792c,0x792b,0x7940,0x7960,0x7957,0x795f,0x795a,0x7955, /* '磧','磚','磽','磴','礇','礒','礑','礙', '礬','礫','祀','祠','祗','祟','祚','祕', */
	/* e250 */ 0x7953,0x797a,0x797f,0x798a,0x799d,0x79a7,0x9f4b,0x79aa, 0x79ae,0x79b3,0x79b9,0x79ba,0x79c9,0x79d5,0x79e7,0x79ec, /* '祓','祺','祿','禊','禝','禧','齋','禪', '禮','禳','禹','禺','秉','秕','秧','秬', */
	/* e260 */ 0x79e1,0x79e3,0x7a08,0x7a0d,0x7a18,0x7a19,0x7a20,0x7a1f, 0x7980,0x7a31,0x7a3b,0x7a3e,0x7a37,0x7a43,0x7a57,0x7a49, /* '秡','秣','稈','稍','稘','稙','稠','稟', '禀','稱','稻','稾','稷','穃','穗','穉', */
	/* e270 */ 0x7a61,0x7a62,0x7a69,0x9f9d,0x7a70,0x7a79,0x7a7d,0x7a88, 0x7a97,0x7a95,0x7a98,0x7a96,0x7aa9,0x7ac8,0x7ab0,0, /* '穡','穢','穩','龝','穰','穹','穽','窈', '窗','窕','窘','窖','窩','竈','窰',0, */
	/* e280 */ 0x7ab6,0x7ac5,0x7ac4,0x7abf,0x9083,0x7ac7,0x7aca,0x7acd, 0x7acf,0x7ad5,0x7ad3,0x7ad9,0x7ada,0x7add,0x7ae1,0x7ae2, /* '窶','竅','竄','窿','邃','竇','竊','竍', '竏','竕','竓','站','竚','竝','竡','竢', */
	/* e290 */ 0x7ae6,0x7aed,0x7af0,0x7b02,0x7b0f,0x7b0a,0x7b06,0x7b33, 0x7b18,0x7b19,0x7b1e,0x7b35,0x7b28,0x7b36,0x7b50,0x7b7a, /* '竦','竭','竰','笂','笏','笊','笆','笳', '笘','笙','笞','笵','笨','笶','筐','筺', */
	/* e2a0 */ 0x7b04,0x7b4d,0x7b0b,0x7b4c,0x7b45,0x7b75,0x7b65,0x7b74, 0x7b67,0x7b70,0x7b71,0x7b6c,0x7b6e,0x7b9d,0x7b98,0x7b9f, /* '笄','筍','笋','筌','筅','筵','筥','筴', '筧','筰','筱','筬','筮','箝','箘','箟', */
	/* e2b0 */ 0x7b8d,0x7b9c,0x7b9a,0x7b8b,0x7b92,0x7b8f,0x7b5d,0x7b99, 0x7bcb,0x7bc1,0x7bcc,0x7bcf,0x7bb4,0x7bc6,0x7bdd,0x7be9, /* '箍','箜','箚','箋','箒','箏','筝','箙', '篋','篁','篌','篏','箴','篆','篝','篩', */
	/* e2c0 */ 0x7c11,0x7c14,0x7be6,0x7be5,0x7c60,0x7c00,0x7c07,0x7c13, 0x7bf3,0x7bf7,0x7c17,0x7c0d,0x7bf6,0x7c23,0x7c27,0x7c2a, /* '簑','簔','篦','篥','籠','簀','簇','簓', '篳','篷','簗','簍','篶','簣','簧','簪', */
	/* e2d0 */ 0x7c1f,0x7c37,0x7c2b,0x7c3d,0x7c4c,0x7c43,0x7c54,0x7c4f, 0x7c40,0x7c50,0x7c58,0x7c5f,0x7c64,0x7c56,0x7c65,0x7c6c, /* '簟','簷','簫','簽','籌','籃','籔','籏', '籀','籐','籘','籟','籤','籖','籥','籬', */
	/* e2e0 */ 0x7c75,0x7c83,0x7c90,0x7ca4,0x7cad,0x7ca2,0x7cab,0x7ca1, 0x7ca8,0x7cb3,0x7cb2,0x7cb1,0x7cae,0x7cb9,0x7cbd,0x7cc0, /* '籵','粃','粐','粤','粭','粢','粫','粡', '粨','粳','粲','粱','粮','粹','粽','糀', */
	/* e2f0 */ 0x7cc5,0x7cc2,0x7cd8,0x7cd2,0x7cdc,0x7ce2,0x9b3b,0x7cef, 0x7cf2,0x7cf4,0x7cf6,0x7cfa,0x7d06,0,0,0, /* '糅','糂','糘','糒','糜','糢','鬻','糯', '糲','糴','糶','糺','紆',0,0,0, */
	/* e300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e340 */ 0x7d02,0x7d1c,0x7d15,0x7d0a,0x7d45,0x7d4b,0x7d2e,0x7d32, 0x7d3f,0x7d35,0x7d46,0x7d73,0x7d56,0x7d4e,0x7d72,0x7d68, /* '紂','紜','紕','紊','絅','絋','紮','紲', '紿','紵','絆','絳','絖','絎','絲','絨', */
	/* e350 */ 0x7d6e,0x7d4f,0x7d63,0x7d93,0x7d89,0x7d5b,0x7d8f,0x7d7d, 0x7d9b,0x7dba,0x7dae,0x7da3,0x7db5,0x7dc7,0x7dbd,0x7dab, /* '絮','絏','絣','經','綉','絛','綏','絽', '綛','綺','綮','綣','綵','緇','綽','綫', */
	/* e360 */ 0x7e3d,0x7da2,0x7daf,0x7ddc,0x7db8,0x7d9f,0x7db0,0x7dd8, 0x7ddd,0x7de4,0x7dde,0x7dfb,0x7df2,0x7de1,0x7e05,0x7e0a, /* '總','綢','綯','緜','綸','綟','綰','緘', '緝','緤','緞','緻','緲','緡','縅','縊', */
	/* e370 */ 0x7e23,0x7e21,0x7e12,0x7e31,0x7e1f,0x7e09,0x7e0b,0x7e22, 0x7e46,0x7e66,0x7e3b,0x7e35,0x7e39,0x7e43,0x7e37,0, /* '縣','縡','縒','縱','縟','縉','縋','縢', '繆','繦','縻','縵','縹','繃','縷',0, */
	/* e380 */ 0x7e32,0x7e3a,0x7e67,0x7e5d,0x7e56,0x7e5e,0x7e59,0x7e5a, 0x7e79,0x7e6a,0x7e69,0x7e7c,0x7e7b,0x7e83,0x7dd5,0x7e7d, /* '縲','縺','繧','繝','繖','繞','繙','繚', '繹','繪','繩','繼','繻','纃','緕','繽', */
	/* e390 */ 0x8fae,0x7e7f,0x7e88,0x7e89,0x7e8c,0x7e92,0x7e90,0x7e93, 0x7e94,0x7e96,0x7e8e,0x7e9b,0x7e9c,0x7f38,0x7f3a,0x7f45, /* '辮','繿','纈','纉','續','纒','纐','纓', '纔','纖','纎','纛','纜','缸','缺','罅', */
	/* e3a0 */ 0x7f4c,0x7f4d,0x7f4e,0x7f50,0x7f51,0x7f55,0x7f54,0x7f58, 0x7f5f,0x7f60,0x7f68,0x7f69,0x7f67,0x7f78,0x7f82,0x7f86, /* '罌','罍','罎','罐','网','罕','罔','罘', '罟','罠','罨','罩','罧','罸','羂','羆', */
	/* e3b0 */ 0x7f83,0x7f88,0x7f87,0x7f8c,0x7f94,0x7f9e,0x7f9d,0x7f9a, 0x7fa3,0x7faf,0x7fb2,0x7fb9,0x7fae,0x7fb6,0x7fb8,0x8b71, /* '羃','羈','羇','羌','羔','羞','羝','羚', '羣','羯','羲','羹','羮','羶','羸','譱', */
	/* e3c0 */ 0x7fc5,0x7fc6,0x7fca,0x7fd5,0x7fd4,0x7fe1,0x7fe6,0x7fe9, 0x7ff3,0x7ff9,0x98dc,0x8006,0x8004,0x800b,0x8012,0x8018, /* '翅','翆','翊','翕','翔','翡','翦','翩', '翳','翹','飜','耆','耄','耋','耒','耘', */
	/* e3d0 */ 0x8019,0x801c,0x8021,0x8028,0x803f,0x803b,0x804a,0x8046, 0x8052,0x8058,0x805a,0x805f,0x8062,0x8068,0x8073,0x8072, /* '耙','耜','耡','耨','耿','耻','聊','聆', '聒','聘','聚','聟','聢','聨','聳','聲', */
	/* e3e0 */ 0x8070,0x8076,0x8079,0x807d,0x807f,0x8084,0x8086,0x8085, 0x809b,0x8093,0x809a,0x80ad,0x5190,0x80ac,0x80db,0x80e5, /* '聰','聶','聹','聽','聿','肄','肆','肅', '肛','肓','肚','肭','冐','肬','胛','胥', */
	/* e3f0 */ 0x80d9,0x80dd,0x80c4,0x80da,0x80d6,0x8109,0x80ef,0x80f1, 0x811b,0x8129,0x8123,0x812f,0x814b,0,0,0, /* '胙','胝','胄','胚','胖','脉','胯','胱', '脛','脩','脣','脯','腋',0,0,0, */
	/* e400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e440 */ 0x968b,0x8146,0x813e,0x8153,0x8151,0x80fc,0x8171,0x816e, 0x8165,0x8166,0x8174,0x8183,0x8188,0x818a,0x8180,0x8182, /* '隋','腆','脾','腓','腑','胼','腱','腮', '腥','腦','腴','膃','膈','膊','膀','膂', */
	/* e450 */ 0x81a0,0x8195,0x81a4,0x81a3,0x815f,0x8193,0x81a9,0x81b0, 0x81b5,0x81be,0x81b8,0x81bd,0x81c0,0x81c2,0x81ba,0x81c9, /* '膠','膕','膤','膣','腟','膓','膩','膰', '膵','膾','膸','膽','臀','臂','膺','臉', */
	/* e460 */ 0x81cd,0x81d1,0x81d9,0x81d8,0x81c8,0x81da,0x81df,0x81e0, 0x81e7,0x81fa,0x81fb,0x81fe,0x8201,0x8202,0x8205,0x8207, /* '臍','臑','臙','臘','臈','臚','臟','臠', '臧','臺','臻','臾','舁','舂','舅','與', */
	/* e470 */ 0x820a,0x820d,0x8210,0x8216,0x8229,0x822b,0x8238,0x8233, 0x8240,0x8259,0x8258,0x825d,0x825a,0x825f,0x8264,0, /* '舊','舍','舐','舖','舩','舫','舸','舳', '艀','艙','艘','艝','艚','艟','艤',0, */
	/* e480 */ 0x8262,0x8268,0x826a,0x826b,0x822e,0x8271,0x8277,0x8278, 0x827e,0x828d,0x8292,0x82ab,0x829f,0x82bb,0x82ac,0x82e1, /* '艢','艨','艪','艫','舮','艱','艷','艸', '艾','芍','芒','芫','芟','芻','芬','苡', */
	/* e490 */ 0x82e3,0x82df,0x82d2,0x82f4,0x82f3,0x82fa,0x8393,0x8303, 0x82fb,0x82f9,0x82de,0x8306,0x82dc,0x8309,0x82d9,0x8335, /* '苣','苟','苒','苴','苳','苺','莓','范', '苻','苹','苞','茆','苜','茉','苙','茵', */
	/* e4a0 */ 0x8334,0x8316,0x8332,0x8331,0x8340,0x8339,0x8350,0x8345, 0x832f,0x832b,0x8317,0x8318,0x8385,0x839a,0x83aa,0x839f, /* '茴','茖','茲','茱','荀','茹','荐','荅', '茯','茫','茗','茘','莅','莚','莪','莟', */
	/* e4b0 */ 0x83a2,0x8396,0x8323,0x838e,0x8387,0x838a,0x837c,0x83b5, 0x8373,0x8375,0x83a0,0x8389,0x83a8,0x83f4,0x8413,0x83eb, /* '莢','莖','茣','莎','莇','莊','荼','莵', '荳','荵','莠','莉','莨','菴','萓','菫', */
	/* e4c0 */ 0x83ce,0x83fd,0x8403,0x83d8,0x840b,0x83c1,0x83f7,0x8407, 0x83e0,0x83f2,0x840d,0x8422,0x8420,0x83bd,0x8438,0x8506, /* '菎','菽','萃','菘','萋','菁','菷','萇', '菠','菲','萍','萢','萠','莽','萸','蔆', */
	/* e4d0 */ 0x83fb,0x846d,0x842a,0x843c,0x855a,0x8484,0x8477,0x846b, 0x84ad,0x846e,0x8482,0x8469,0x8446,0x842c,0x846f,0x8479, /* '菻','葭','萪','萼','蕚','蒄','葷','葫', '蒭','葮','蒂','葩','葆','萬','葯','葹', */
	/* e4e0 */ 0x8435,0x84ca,0x8462,0x84b9,0x84bf,0x849f,0x84d9,0x84cd, 0x84bb,0x84da,0x84d0,0x84c1,0x84c6,0x84d6,0x84a1,0x8521, /* '萵','蓊','葢','蒹','蒿','蒟','蓙','蓍', '蒻','蓚','蓐','蓁','蓆','蓖','蒡','蔡', */
	/* e4f0 */ 0x84ff,0x84f4,0x8517,0x8518,0x852c,0x851f,0x8515,0x8514, 0x84fc,0x8540,0x8563,0x8558,0x8548,0,0,0, /* '蓿','蓴','蔗','蔘','蔬','蔟','蔕','蔔', '蓼','蕀','蕣','蕘','蕈',0,0,0, */
	/* e500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e540 */ 0x8541,0x8602,0x854b,0x8555,0x8580,0x85a4,0x8588,0x8591, 0x858a,0x85a8,0x856d,0x8594,0x859b,0x85ea,0x8587,0x859c, /* '蕁','蘂','蕋','蕕','薀','薤','薈','薑', '薊','薨','蕭','薔','薛','藪','薇','薜', */
	/* e550 */ 0x8577,0x857e,0x8590,0x85c9,0x85ba,0x85cf,0x85b9,0x85d0, 0x85d5,0x85dd,0x85e5,0x85dc,0x85f9,0x860a,0x8613,0x860b, /* '蕷','蕾','薐','藉','薺','藏','薹','藐', '藕','藝','藥','藜','藹','蘊','蘓','蘋', */
	/* e560 */ 0x85fe,0x85fa,0x8606,0x8622,0x861a,0x8630,0x863f,0x864d, 0x4e55,0x8654,0x865f,0x8667,0x8671,0x8693,0x86a3,0x86a9, /* '藾','藺','蘆','蘢','蘚','蘰','蘿','虍', '乕','虔','號','虧','虱','蚓','蚣','蚩', */
	/* e570 */ 0x86aa,0x868b,0x868c,0x86b6,0x86af,0x86c4,0x86c6,0x86b0, 0x86c9,0x8823,0x86ab,0x86d4,0x86de,0x86e9,0x86ec,0, /* '蚪','蚋','蚌','蚶','蚯','蛄','蛆','蚰', '蛉','蠣','蚫','蛔','蛞','蛩','蛬',0, */
	/* e580 */ 0x86df,0x86db,0x86ef,0x8712,0x8706,0x8708,0x8700,0x8703, 0x86fb,0x8711,0x8709,0x870d,0x86f9,0x870a,0x8734,0x873f, /* '蛟','蛛','蛯','蜒','蜆','蜈','蜀','蜃', '蛻','蜑','蜉','蜍','蛹','蜊','蜴','蜿', */
	/* e590 */ 0x8737,0x873b,0x8725,0x8729,0x871a,0x8760,0x875f,0x8778, 0x874c,0x874e,0x8774,0x8757,0x8768,0x876e,0x8759,0x8753, /* '蜷','蜻','蜥','蜩','蜚','蝠','蝟','蝸', '蝌','蝎','蝴','蝗','蝨','蝮','蝙','蝓', */
	/* e5a0 */ 0x8763,0x876a,0x8805,0x87a2,0x879f,0x8782,0x87af,0x87cb, 0x87bd,0x87c0,0x87d0,0x96d6,0x87ab,0x87c4,0x87b3,0x87c7, /* '蝣','蝪','蠅','螢','螟','螂','螯','蟋', '螽','蟀','蟐','雖','螫','蟄','螳','蟇', */
	/* e5b0 */ 0x87c6,0x87bb,0x87ef,0x87f2,0x87e0,0x880f,0x880d,0x87fe, 0x87f6,0x87f7,0x880e,0x87d2,0x8811,0x8816,0x8815,0x8822, /* '蟆','螻','蟯','蟲','蟠','蠏','蠍','蟾', '蟶','蟷','蠎','蟒','蠑','蠖','蠕','蠢', */
	/* e5c0 */ 0x8821,0x8831,0x8836,0x8839,0x8827,0x883b,0x8844,0x8842, 0x8852,0x8859,0x885e,0x8862,0x886b,0x8881,0x887e,0x889e, /* '蠡','蠱','蠶','蠹','蠧','蠻','衄','衂', '衒','衙','衞','衢','衫','袁','衾','袞', */
	/* e5d0 */ 0x8875,0x887d,0x88b5,0x8872,0x8882,0x8897,0x8892,0x88ae, 0x8899,0x88a2,0x888d,0x88a4,0x88b0,0x88bf,0x88b1,0x88c3, /* '衵','衽','袵','衲','袂','袗','袒','袮', '袙','袢','袍','袤','袰','袿','袱','裃', */
	/* e5e0 */ 0x88c4,0x88d4,0x88d8,0x88d9,0x88dd,0x88f9,0x8902,0x88fc, 0x88f4,0x88e8,0x88f2,0x8904,0x890c,0x890a,0x8913,0x8943, /* '裄','裔','裘','裙','裝','裹','褂','裼', '裴','裨','裲','褄','褌','褊','褓','襃', */
	/* e5f0 */ 0x891e,0x8925,0x892a,0x892b,0x8941,0x8944,0x893b,0x8936, 0x8938,0x894c,0x891d,0x8960,0x895e,0,0,0, /* '褞','褥','褪','褫','襁','襄','褻','褶', '褸','襌','褝','襠','襞',0,0,0, */
	/* e600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e640 */ 0x8966,0x8964,0x896d,0x896a,0x896f,0x8974,0x8977,0x897e, 0x8983,0x8988,0x898a,0x8993,0x8998,0x89a1,0x89a9,0x89a6, /* '襦','襤','襭','襪','襯','襴','襷','襾', '覃','覈','覊','覓','覘','覡','覩','覦', */
	/* e650 */ 0x89ac,0x89af,0x89b2,0x89ba,0x89bd,0x89bf,0x89c0,0x89da, 0x89dc,0x89dd,0x89e7,0x89f4,0x89f8,0x8a03,0x8a16,0x8a10, /* '覬','覯','覲','覺','覽','覿','觀','觚', '觜','觝','觧','觴','觸','訃','訖','訐', */
	/* e660 */ 0x8a0c,0x8a1b,0x8a1d,0x8a25,0x8a36,0x8a41,0x8a5b,0x8a52, 0x8a46,0x8a48,0x8a7c,0x8a6d,0x8a6c,0x8a62,0x8a85,0x8a82, /* '訌','訛','訝','訥','訶','詁','詛','詒', '詆','詈','詼','詭','詬','詢','誅','誂', */
	/* e670 */ 0x8a84,0x8aa8,0x8aa1,0x8a91,0x8aa5,0x8aa6,0x8a9a,0x8aa3, 0x8ac4,0x8acd,0x8ac2,0x8ada,0x8aeb,0x8af3,0x8ae7,0, /* '誄','誨','誡','誑','誥','誦','誚','誣', '諄','諍','諂','諚','諫','諳','諧',0, */
	/* e680 */ 0x8ae4,0x8af1,0x8b14,0x8ae0,0x8ae2,0x8af7,0x8ade,0x8adb, 0x8b0c,0x8b07,0x8b1a,0x8ae1,0x8b16,0x8b10,0x8b17,0x8b20, /* '諤','諱','謔','諠','諢','諷','諞','諛', '謌','謇','謚','諡','謖','謐','謗','謠', */
	/* e690 */ 0x8b33,0x97ab,0x8b26,0x8b2b,0x8b3e,0x8b28,0x8b41,0x8b4c, 0x8b4f,0x8b4e,0x8b49,0x8b56,0x8b5b,0x8b5a,0x8b6b,0x8b5f, /* '謳','鞫','謦','謫','謾','謨','譁','譌', '譏','譎','證','譖','譛','譚','譫','譟', */
	/* e6a0 */ 0x8b6c,0x8b6f,0x8b74,0x8b7d,0x8b80,0x8b8c,0x8b8e,0x8b92, 0x8b93,0x8b96,0x8b99,0x8b9a,0x8c3a,0x8c41,0x8c3f,0x8c48, /* '譬','譯','譴','譽','讀','讌','讎','讒', '讓','讖','讙','讚','谺','豁','谿','豈', */
	/* e6b0 */ 0x8c4c,0x8c4e,0x8c50,0x8c55,0x8c62,0x8c6c,0x8c78,0x8c7a, 0x8c82,0x8c89,0x8c85,0x8c8a,0x8c8d,0x8c8e,0x8c94,0x8c7c, /* '豌','豎','豐','豕','豢','豬','豸','豺', '貂','貉','貅','貊','貍','貎','貔','豼', */
	/* e6c0 */ 0x8c98,0x621d,0x8cad,0x8caa,0x8cbd,0x8cb2,0x8cb3,0x8cae, 0x8cb6,0x8cc8,0x8cc1,0x8ce4,0x8ce3,0x8cda,0x8cfd,0x8cfa, /* '貘','戝','貭','貪','貽','貲','貳','貮', '貶','賈','賁','賤','賣','賚','賽','賺', */
	/* e6d0 */ 0x8cfb,0x8d04,0x8d05,0x8d0a,0x8d07,0x8d0f,0x8d0d,0x8d10, 0x9f4e,0x8d13,0x8ccd,0x8d14,0x8d16,0x8d67,0x8d6d,0x8d71, /* '賻','贄','贅','贊','贇','贏','贍','贐', '齎','贓','賍','贔','贖','赧','赭','赱', */
	/* e6e0 */ 0x8d73,0x8d81,0x8d99,0x8dc2,0x8dbe,0x8dba,0x8dcf,0x8dda, 0x8dd6,0x8dcc,0x8ddb,0x8dcb,0x8dea,0x8deb,0x8ddf,0x8de3, /* '赳','趁','趙','跂','趾','趺','跏','跚', '跖','跌','跛','跋','跪','跫','跟','跣', */
	/* e6f0 */ 0x8dfc,0x8e08,0x8e09,0x8dff,0x8e1d,0x8e1e,0x8e10,0x8e1f, 0x8e42,0x8e35,0x8e30,0x8e34,0x8e4a,0,0,0, /* '跼','踈','踉','跿','踝','踞','踐','踟', '蹂','踵','踰','踴','蹊',0,0,0, */
	/* e700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e740 */ 0x8e47,0x8e49,0x8e4c,0x8e50,0x8e48,0x8e59,0x8e64,0x8e60, 0x8e2a,0x8e63,0x8e55,0x8e76,0x8e72,0x8e7c,0x8e81,0x8e87, /* '蹇','蹉','蹌','蹐','蹈','蹙','蹤','蹠', '踪','蹣','蹕','蹶','蹲','蹼','躁','躇', */
	/* e750 */ 0x8e85,0x8e84,0x8e8b,0x8e8a,0x8e93,0x8e91,0x8e94,0x8e99, 0x8eaa,0x8ea1,0x8eac,0x8eb0,0x8ec6,0x8eb1,0x8ebe,0x8ec5, /* '躅','躄','躋','躊','躓','躑','躔','躙', '躪','躡','躬','躰','軆','躱','躾','軅', */
	/* e760 */ 0x8ec8,0x8ecb,0x8edb,0x8ee3,0x8efc,0x8efb,0x8eeb,0x8efe, 0x8f0a,0x8f05,0x8f15,0x8f12,0x8f19,0x8f13,0x8f1c,0x8f1f, /* '軈','軋','軛','軣','軼','軻','軫','軾', '輊','輅','輕','輒','輙','輓','輜','輟', */
	/* e770 */ 0x8f1b,0x8f0c,0x8f26,0x8f33,0x8f3b,0x8f39,0x8f45,0x8f42, 0x8f3e,0x8f4c,0x8f49,0x8f46,0x8f4e,0x8f57,0x8f5c,0, /* '輛','輌','輦','輳','輻','輹','轅','轂', '輾','轌','轉','轆','轎','轗','轜',0, */
	/* e780 */ 0x8f62,0x8f63,0x8f64,0x8f9c,0x8f9f,0x8fa3,0x8fad,0x8faf, 0x8fb7,0x8fda,0x8fe5,0x8fe2,0x8fea,0x8fef,0x9087,0x8ff4, /* '轢','轣','轤','辜','辟','辣','辭','辯', '辷','迚','迥','迢','迪','迯','邇','迴', */
	/* e790 */ 0x9005,0x8ff9,0x8ffa,0x9011,0x9015,0x9021,0x900d,0x901e, 0x9016,0x900b,0x9027,0x9036,0x9035,0x9039,0x8ff8,0x904f, /* '逅','迹','迺','逑','逕','逡','逍','逞', '逖','逋','逧','逶','逵','逹','迸','遏', */
	/* e7a0 */ 0x9050,0x9051,0x9052,0x900e,0x9049,0x903e,0x9056,0x9058, 0x905e,0x9068,0x906f,0x9076,0x96a8,0x9072,0x9082,0x907d, /* '遐','遑','遒','逎','遉','逾','遖','遘', '遞','遨','遯','遶','隨','遲','邂','遽', */
	/* e7b0 */ 0x9081,0x9080,0x908a,0x9089,0x908f,0x90a8,0x90af,0x90b1, 0x90b5,0x90e2,0x90e4,0x6248,0x90db,0x9102,0x9112,0x9119, /* '邁','邀','邊','邉','邏','邨','邯','邱', '邵','郢','郤','扈','郛','鄂','鄒','鄙', */
	/* e7c0 */ 0x9132,0x9130,0x914a,0x9156,0x9158,0x9163,0x9165,0x9169, 0x9173,0x9172,0x918b,0x9189,0x9182,0x91a2,0x91ab,0x91af, /* '鄲','鄰','酊','酖','酘','酣','酥','酩', '酳','酲','醋','醉','醂','醢','醫','醯', */
	/* e7d0 */ 0x91aa,0x91b5,0x91b4,0x91ba,0x91c0,0x91c1,0x91c9,0x91cb, 0x91d0,0x91d6,0x91df,0x91e1,0x91db,0x91fc,0x91f5,0x91f6, /* '醪','醵','醴','醺','釀','釁','釉','釋', '釐','釖','釟','釡','釛','釼','釵','釶', */
	/* e7e0 */ 0x921e,0x91ff,0x9214,0x922c,0x9215,0x9211,0x925e,0x9257, 0x9245,0x9249,0x9264,0x9248,0x9295,0x923f,0x924b,0x9250, /* '鈞','釿','鈔','鈬','鈕','鈑','鉞','鉗', '鉅','鉉','鉤','鉈','銕','鈿','鉋','鉐', */
	/* e7f0 */ 0x929c,0x9296,0x9293,0x929b,0x925a,0x92cf,0x92b9,0x92b7, 0x92e9,0x930f,0x92fa,0x9344,0x932e,0,0,0, /* '銜','銖','銓','銛','鉚','鋏','銹','銷', '鋩','錏','鋺','鍄','錮',0,0,0, */
	/* e800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e840 */ 0x9319,0x9322,0x931a,0x9323,0x933a,0x9335,0x933b,0x935c, 0x9360,0x937c,0x936e,0x9356,0x93b0,0x93ac,0x93ad,0x9394, /* '錙','錢','錚','錣','錺','錵','錻','鍜', '鍠','鍼','鍮','鍖','鎰','鎬','鎭','鎔', */
	/* e850 */ 0x93b9,0x93d6,0x93d7,0x93e8,0x93e5,0x93d8,0x93c3,0x93dd, 0x93d0,0x93c8,0x93e4,0x941a,0x9414,0x9413,0x9403,0x9407, /* '鎹','鏖','鏗','鏨','鏥','鏘','鏃','鏝', '鏐','鏈','鏤','鐚','鐔','鐓','鐃','鐇', */
	/* e860 */ 0x9410,0x9436,0x942b,0x9435,0x9421,0x943a,0x9441,0x9452, 0x9444,0x945b,0x9460,0x9462,0x945e,0x946a,0x9229,0x9470, /* '鐐','鐶','鐫','鐵','鐡','鐺','鑁','鑒', '鑄','鑛','鑠','鑢','鑞','鑪','鈩','鑰', */
	/* e870 */ 0x9475,0x9477,0x947d,0x945a,0x947c,0x947e,0x9481,0x947f, 0x9582,0x9587,0x958a,0x9594,0x9596,0x9598,0x9599,0, /* '鑵','鑷','鑽','鑚','鑼','鑾','钁','鑿', '閂','閇','閊','閔','閖','閘','閙',0, */
	/* e880 */ 0x95a0,0x95a8,0x95a7,0x95ad,0x95bc,0x95bb,0x95b9,0x95be, 0x95ca,0x6ff6,0x95c3,0x95cd,0x95cc,0x95d5,0x95d4,0x95d6, /* '閠','閨','閧','閭','閼','閻','閹','閾', '闊','濶','闃','闍','闌','闕','闔','闖', */
	/* e890 */ 0x95dc,0x95e1,0x95e5,0x95e2,0x9621,0x9628,0x962e,0x962f, 0x9642,0x964c,0x964f,0x964b,0x9677,0x965c,0x965e,0x965d, /* '關','闡','闥','闢','阡','阨','阮','阯', '陂','陌','陏','陋','陷','陜','陞','陝', */
	/* e8a0 */ 0x965f,0x9666,0x9672,0x966c,0x968d,0x9698,0x9695,0x9697, 0x96aa,0x96a7,0x96b1,0x96b2,0x96b0,0x96b4,0x96b6,0x96b8, /* '陟','陦','陲','陬','隍','隘','隕','隗', '險','隧','隱','隲','隰','隴','隶','隸', */
	/* e8b0 */ 0x96b9,0x96ce,0x96cb,0x96c9,0x96cd,0x894d,0x96dc,0x970d, 0x96d5,0x96f9,0x9704,0x9706,0x9708,0x9713,0x970e,0x9711, /* '隹','雎','雋','雉','雍','襍','雜','霍', '雕','雹','霄','霆','霈','霓','霎','霑', */
	/* e8c0 */ 0x970f,0x9716,0x9719,0x9724,0x972a,0x9730,0x9739,0x973d, 0x973e,0x9744,0x9746,0x9748,0x9742,0x9749,0x975c,0x9760, /* '霏','霖','霙','霤','霪','霰','霹','霽', '霾','靄','靆','靈','靂','靉','靜','靠', */
	/* e8d0 */ 0x9764,0x9766,0x9768,0x52d2,0x976b,0x9771,0x9779,0x9785, 0x977c,0x9781,0x977a,0x9786,0x978b,0x978f,0x9790,0x979c, /* '靤','靦','靨','勒','靫','靱','靹','鞅', '靼','鞁','靺','鞆','鞋','鞏','鞐','鞜', */
	/* e8e0 */ 0x97a8,0x97a6,0x97a3,0x97b3,0x97b4,0x97c3,0x97c6,0x97c8, 0x97cb,0x97dc,0x97ed,0x9f4f,0x97f2,0x7adf,0x97f6,0x97f5, /* '鞨','鞦','鞣','鞳','鞴','韃','韆','韈', '韋','韜','韭','齏','韲','竟','韶','韵', */
	/* e8f0 */ 0x980f,0x980c,0x9838,0x9824,0x9821,0x9837,0x983d,0x9846, 0x984f,0x984b,0x986b,0x986f,0x9870,0,0,0, /* '頏','頌','頸','頤','頡','頷','頽','顆', '顏','顋','顫','顯','顰',0,0,0, */
	/* e900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e940 */ 0x9871,0x9874,0x9873,0x98aa,0x98af,0x98b1,0x98b6,0x98c4, 0x98c3,0x98c6,0x98e9,0x98eb,0x9903,0x9909,0x9912,0x9914, /* '顱','顴','顳','颪','颯','颱','颶','飄', '飃','飆','飩','飫','餃','餉','餒','餔', */
	/* e950 */ 0x9918,0x9921,0x991d,0x991e,0x9924,0x9920,0x992c,0x992e, 0x993d,0x993e,0x9942,0x9949,0x9945,0x9950,0x994b,0x9951, /* '餘','餡','餝','餞','餤','餠','餬','餮', '餽','餾','饂','饉','饅','饐','饋','饑', */
	/* e960 */ 0x9952,0x994c,0x9955,0x9997,0x9998,0x99a5,0x99ad,0x99ae, 0x99bc,0x99df,0x99db,0x99dd,0x99d8,0x99d1,0x99ed,0x99ee, /* '饒','饌','饕','馗','馘','馥','馭','馮', '馼','駟','駛','駝','駘','駑','駭','駮', */
	/* e970 */ 0x99f1,0x99f2,0x99fb,0x99f8,0x9a01,0x9a0f,0x9a05,0x99e2, 0x9a19,0x9a2b,0x9a37,0x9a45,0x9a42,0x9a40,0x9a43,0, /* '駱','駲','駻','駸','騁','騏','騅','駢', '騙','騫','騷','驅','驂','驀','驃',0, */
	/* e980 */ 0x9a3e,0x9a55,0x9a4d,0x9a5b,0x9a57,0x9a5f,0x9a62,0x9a65, 0x9a64,0x9a69,0x9a6b,0x9a6a,0x9aad,0x9ab0,0x9abc,0x9ac0, /* '騾','驕','驍','驛','驗','驟','驢','驥', '驤','驩','驫','驪','骭','骰','骼','髀', */
	/* e990 */ 0x9acf,0x9ad1,0x9ad3,0x9ad4,0x9ade,0x9adf,0x9ae2,0x9ae3, 0x9ae6,0x9aef,0x9aeb,0x9aee,0x9af4,0x9af1,0x9af7,0x9afb, /* '髏','髑','髓','體','髞','髟','髢','髣', '髦','髯','髫','髮','髴','髱','髷','髻', */
	/* e9a0 */ 0x9b06,0x9b18,0x9b1a,0x9b1f,0x9b22,0x9b23,0x9b25,0x9b27, 0x9b28,0x9b29,0x9b2a,0x9b2e,0x9b2f,0x9b32,0x9b44,0x9b43, /* '鬆','鬘','鬚','鬟','鬢','鬣','鬥','鬧', '鬨','鬩','鬪','鬮','鬯','鬲','魄','魃', */
	/* e9b0 */ 0x9b4f,0x9b4d,0x9b4e,0x9b51,0x9b58,0x9b74,0x9b93,0x9b83, 0x9b91,0x9b96,0x9b97,0x9b9f,0x9ba0,0x9ba8,0x9bb4,0x9bc0, /* '魏','魍','魎','魑','魘','魴','鮓','鮃', '鮑','鮖','鮗','鮟','鮠','鮨','鮴','鯀', */
	/* e9c0 */ 0x9bca,0x9bb9,0x9bc6,0x9bcf,0x9bd1,0x9bd2,0x9be3,0x9be2, 0x9be4,0x9bd4,0x9be1,0x9c3a,0x9bf2,0x9bf1,0x9bf0,0x9c15, /* '鯊','鮹','鯆','鯏','鯑','鯒','鯣','鯢', '鯤','鯔','鯡','鰺','鯲','鯱','鯰','鰕', */
	/* e9d0 */ 0x9c14,0x9c09,0x9c13,0x9c0c,0x9c06,0x9c08,0x9c12,0x9c0a, 0x9c04,0x9c2e,0x9c1b,0x9c25,0x9c24,0x9c21,0x9c30,0x9c47, /* '鰔','鰉','鰓','鰌','鰆','鰈','鰒','鰊', '鰄','鰮','鰛','鰥','鰤','鰡','鰰','鱇', */
	/* e9e0 */ 0x9c32,0x9c46,0x9c3e,0x9c5a,0x9c60,0x9c67,0x9c76,0x9c78, 0x9ce7,0x9cec,0x9cf0,0x9d09,0x9d08,0x9ceb,0x9d03,0x9d06, /* '鰲','鱆','鰾','鱚','鱠','鱧','鱶','鱸', '鳧','鳬','鳰','鴉','鴈','鳫','鴃','鴆', */
	/* e9f0 */ 0x9d2a,0x9d26,0x9daf,0x9d23,0x9d1f,0x9d44,0x9d15,0x9d12, 0x9d41,0x9d3f,0x9d3e,0x9d46,0x9d48,0,0,0, /* '鴪','鴦','鶯','鴣','鴟','鵄','鴕','鴒', '鵁','鴿','鴾','鵆','鵈',0,0,0, */
	/* ea00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea40 */ 0x9d5d,0x9d5e,0x9d64,0x9d51,0x9d50,0x9d59,0x9d72,0x9d89, 0x9d87,0x9dab,0x9d6f,0x9d7a,0x9d9a,0x9da4,0x9da9,0x9db2, /* '鵝','鵞','鵤','鵑','鵐','鵙','鵲','鶉', '鶇','鶫','鵯','鵺','鶚','鶤','鶩','鶲', */
	/* ea50 */ 0x9dc4,0x9dc1,0x9dbb,0x9db8,0x9dba,0x9dc6,0x9dcf,0x9dc2, 0x9dd9,0x9dd3,0x9df8,0x9de6,0x9ded,0x9def,0x9dfd,0x9e1a, /* '鷄','鷁','鶻','鶸','鶺','鷆','鷏','鷂', '鷙','鷓','鷸','鷦','鷭','鷯','鷽','鸚', */
	/* ea60 */ 0x9e1b,0x9e1e,0x9e75,0x9e79,0x9e7d,0x9e81,0x9e88,0x9e8b, 0x9e8c,0x9e92,0x9e95,0x9e91,0x9e9d,0x9ea5,0x9ea9,0x9eb8, /* '鸛','鸞','鹵','鹹','鹽','麁','麈','麋', '麌','麒','麕','麑','麝','麥','麩','麸', */
	/* ea70 */ 0x9eaa,0x9ead,0x9761,0x9ecc,0x9ece,0x9ecf,0x9ed0,0x9ed4, 0x9edc,0x9ede,0x9edd,0x9ee0,0x9ee5,0x9ee8,0x9eef,0, /* '麪','麭','靡','黌','黎','黏','黐','黔', '黜','點','黝','黠','黥','黨','黯',0, */
	/* ea80 */ 0x9ef4,0x9ef6,0x9ef7,0x9ef9,0x9efb,0x9efc,0x9efd,0x9f07, 0x9f08,0x76b7,0x9f15,0x9f21,0x9f2c,0x9f3e,0x9f4a,0x9f52, /* '黴','黶','黷','黹','黻','黼','黽','鼇', '鼈','皷','鼕','鼡','鼬','鼾','齊','齒', */
	/* ea90 */ 0x9f54,0x9f63,0x9f5f,0x9f60,0x9f61,0x9f66,0x9f67,0x9f6c, 0x9f6a,0x9f77,0x9f72,0x9f76,0x9f95,0x9f9c,0x9fa0,0x582f, /* '齔','齣','齟','齠','齡','齦','齧','齬', '齪','齷','齲','齶','龕','龜','龠','堯', */
	/* eaa0 */ 0x69c7,0x9059,0x7464,0x51dc,0x7199,0,0,0, 0,0,0,0,0,0,0,0, /* '槇','遙','瑤','凜','熙',0,0,0, 0,0,0,0,0,0,0,0, */
};

const size_t _sjis2unibe_table_size = sizeof(_sjis2unibe_table) / sizeof(_sjis2unibe_table[0]);

#endif /* #ifndef __SJIS2UNIBE_TABLE_H_ */
