/*
 * _unibe2euc2004_table.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __UNIBE2EUC2004_TABLE_H_
#define __UNIBE2EUC2004_TABLE_H_

#include <stddef.h>
#include <stdint.h>

const uint32_t _unibe2euc2004_table[] = {
	/* 0000 */ 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, 0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* '','','','','','','','', '','','','','','','','', */
	/* 0010 */ 0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, 0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* '','','','','','','','', '','','','','','','','', */
	/* 0020 */ 0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, 0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* ' ','!','"','#','$','%','&','\'', '(',')','*','+',',','-','.','/', */
	/* 0030 */ 0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, 0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* '0','1','2','3','4','5','6','7', '8','9',':',';','<','=','>','?', */
	/* 0040 */ 0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, 0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O', */
	/* 0050 */ 0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, 0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 'P','Q','R','S','T','U','V','W', 'X','Y','Z','[','\\',']','^','_', */
	/* 0060 */ 0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, 0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* '`','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o', */
	/* 0070 */ 0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, 0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f, /* 'p','q','r','s','t','u','v','w', 'x','y','z','{','|','}','~','', */
	/* 0080 */ 0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087, 0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0x008e,0x008f, /* '','','','','','','','', '','','','','','','','', */
	/* 0090 */ 0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097, 0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f, /* '','','','','','','','', '','','','','','','','', */
	/* 00a0 */ 0xa9a2,0xa9a3,0xa1f1,0xa1f2,0xa9a4,0xa1ef,0xa9a5,0xa1f8, 0xa1af,0xa9a6,0xa9a7,0xa9a8,0xa2cc,0xa9a9,0xa9aa,0xa9ab, /* ' ','¡','¢','£','¤','¥','¦','§', '¨','©','ª','«','¬','­','®','¯', */
	/* 00b0 */ 0xa1eb,0xa1de,0xa9ac,0xa9ad,0xa1ad,0,0xa2f9,0xa9ae, 0xa9af,0xa9b0,0xa9b1,0xa9b2,0xa9b3,0xa9b4,0xa9b5,0xa9b6, /* '°','±','²','³','´',0,'¶','·', '¸','¹','º','»','¼','½','¾','¿', */
	/* 00c0 */ 0xa9b7,0xa9b8,0xa9b9,0xa9ba,0xa9bb,0xa9bc,0xa9bd,0xa9be, 0xa9bf,0xa9c0,0xa9c1,0xa9c2,0xa9c3,0xa9c4,0xa9c5,0xa9c6, /* 'À','Á','Â','Ã','Ä','Å','Æ','Ç', 'È','É','Ê','Ë','Ì','Í','Î','Ï', */
	/* 00d0 */ 0xa9c7,0xa9c8,0xa9c9,0xa9ca,0xa9cb,0xa9cc,0xa9cd,0xa1df, 0xa9ce,0xa9cf,0xa9d0,0xa9d1,0xa9d2,0xa9d3,0xa9d4,0xa9d5, /* 'Ð','Ñ','Ò','Ó','Ô','Õ','Ö','×', 'Ø','Ù','Ú','Û','Ü','Ý','Þ','ß', */
	/* 00e0 */ 0xa9d6,0xa9d7,0xa9d8,0xa9d9,0xa9da,0xa9db,0xa9dc,0xa9dd, 0xa9de,0xa9df,0xa9e0,0xa9e1,0xa9e2,0xa9e3,0xa9e4,0xa9e5, /* 'à','á','â','ã','ä','å','æ','ç', 'è','é','ê','ë','ì','í','î','ï', */
	/* 00f0 */ 0xa9e6,0xa9e7,0xa9e8,0xa9e9,0xa9ea,0xa9eb,0xa9ec,0xa1e0, 0xa9ed,0xa9ee,0xa9ef,0xa9f0,0xa9f1,0xa9f2,0xa9f3,0xa9f4, /* 'ð','ñ','ò','ó','ô','õ','ö','÷', 'ø','ù','ú','û','ü','ý','þ','ÿ', */
	/* 0100 */ 0xa9f5,0xa9fa,0xaaba,0xaac9,0xaaa1,0xaaac,0xaabc,0xaacb, 0xaad9,0xaadf,0,0,0xaabd,0xaacc,0xaac0,0xaacf, /* 'Ā','ā','Ă','ă','Ą','ą','Ć','ć', 'Ĉ','ĉ',0,0,'Č','č','Ď','ď', */
	/* 0110 */ 0,0xaad0,0xa9f8,0xa9fd,0,0,0,0, 0xaabe,0xaacd,0xaabf,0xaace,0xaada,0xaae0,0,0, /* 0,'đ','Ē','ē',0,0,0,0, 'Ę','ę','Ě','ě','Ĝ','ĝ',0,0, */
	/* 0120 */ 0,0,0,0,0xaadb,0xaae1,0,0xaafd, 0,0,0xa9f6,0xa9fb,0,0,0,0, /* 0,0,0,0,'Ĥ','ĥ',0,'ħ', 0,0,'Ī','ī',0,0,0,0, */
	/* 0130 */ 0,0,0,0,0xaadc,0xaae2,0,0, 0,0xaabb,0xaaca,0,0,0xaaa4,0xaaaf,0, /* 0,0,0,0,'Ĵ','ĵ',0,0, 0,'Ĺ','ĺ',0,0,'Ľ','ľ',0, */
	/* 0140 */ 0,0xaaa3,0xaaae,0xaac1,0xaad1,0,0,0xaac2, 0xaad2,0,0,0xaafa,0xa9f9,0xa9fe,0,0, /* 0,'Ł','ł','Ń','ń',0,0,'Ň', 'ň',0,0,'ŋ','Ō','ō',0,0, */
	/* 0150 */ 0xaac3,0xaad3,0xabab,0xabaa,0xaab9,0xaac8,0,0, 0xaac4,0xaad4,0xaaa5,0xaab0,0xaadd,0xaae3,0xaaa7,0xaab3, /* 'Ő','ő','Œ','œ','Ŕ','ŕ',0,0, 'Ř','ř','Ś','ś','Ŝ','ŝ','Ş','ş', */
	/* 0160 */ 0xaaa6,0xaab2,0xaac7,0xaad7,0xaaa8,0xaab4,0,0, 0,0,0xa9f7,0xa9fc,0xaade,0xaae4,0xaac5,0xaad5, /* 'Š','š','Ţ','ţ','Ť','ť',0,0, 0,0,'Ū','ū','Ŭ','ŭ','Ů','ů', */
	/* 0170 */ 0xaac6,0xaad6,0,0,0,0,0,0, 0,0xaaa9,0xaab5,0xaaab,0xaab8,0xaaaa,0xaab7,0, /* 'Ű','ű',0,0,0,0,0,0, 0,'Ź','ź','Ż','ż','Ž','ž',0, */
	/* 0180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0190 */ 0,0,0,0xaba9,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'Ɠ',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 01a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01c0 */ 0,0,0xaba4,0,0,0,0,0, 0,0,0,0,0,0xa8ef,0xa8f0,0, /* 0,0,'ǂ',0,0,0,0,0, 0,0,0,0,0,'Ǎ','ǎ',0, */
	/* 01d0 */ 0xa8f1,0xa8f6,0xa8f7,0,0xa8f8,0,0xa8f9,0, 0xa8fa,0,0xa8fb,0,0xa8fc,0,0,0, /* 'ǐ','Ǒ','ǒ',0,'ǔ',0,'ǖ',0, 'ǘ',0,'ǚ',0,'ǜ',0,0,0, */
	/* 01e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01f0 */ 0,0,0,0,0,0,0,0, 0xa8f4,0xa8f5,0,0,0,0xabc5,0,0, /* 0,0,0,0,0,0,0,0, 'Ǹ','ǹ',0,0,0,'ǽ',0,0, */
	/* 0200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0250 */ 0xabb3,0xabb9,0xabba,0xaba5,0xabb8,0xabbf,0xaaee,0xaba6, 0xabae,0xabb0,0xabc3,0,0xabb1,0,0xabb2,0xaaf5, /* 'ɐ','ɑ','ɒ','ɓ','ɔ','ɕ','ɖ','ɗ', 'ɘ','ə','ɚ',0,'ɜ',0,'ɞ','ɟ', */
	/* 0260 */ 0xaba8,0xaaf9,0,0,0xabb6,0xabbc,0xaba2,0xabc2, 0xabac,0,0,0,0xaaea,0xaaf4,0xaaeb,0xabb4, /* 'ɠ','ɡ',0,0,'ɤ','ɥ','ɦ','ɧ', 'ɨ',0,0,0,'ɬ','ɭ','ɮ','ɯ', */
	/* 0270 */ 0xaafb,0xaae5,0xaaf6,0xaaef,0,0xabaf,0,0, 0,0xaaec,0xabc1,0xaaf3,0,0xaaf0,0xaae7,0, /* 'ɰ','ɱ','ɲ','ɳ',0,'ɵ',0,0, 0,'ɹ','ɺ','ɻ',0,'ɽ','ɾ',0, */
	/* 0280 */ 0,0xaafc,0xaaf1,0xaae8,0xaba7,0,0,0, 0xaaed,0xabad,0xabb5,0xaae6,0xabb7,0xabbb,0xaaf8,0, /* 0,'ʁ','ʂ','ʃ','ʄ',0,0,0, 'ʈ','ʉ','ʊ','ʋ','ʌ','ʍ','ʎ',0, */
	/* 0290 */ 0xaaf2,0xabc0,0xaae9,0,0xaba1,0xaafe,0,0, 0xaba3,0,0,0,0,0xaaf7,0,0, /* 'ʐ','ʑ','ʒ',0,'ʔ','ʕ',0,0, 'ʘ',0,0,0,0,'ʝ',0,0, */
	/* 02a0 */ 0,0xabbe,0xabbd,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'ʡ','ʢ',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 02b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02c0 */ 0,0,0,0,0,0,0,0xaab1, 0xabd3,0,0,0,0xabd4,0,0,0, /* 0,0,0,0,0,0,0,'ˇ', 'ˈ',0,0,0,'ˌ',0,0,0, */
	/* 02d0 */ 0xabd5,0xabd6,0,0,0,0,0,0, 0xaaa2,0xaad8,0,0xaaad,0,0xaab6,0xabf1,0, /* 'ː','ˑ',0,0,0,0,0,0, '˘','˙',0,'˛',0,'˝','˞',0, */
	/* 02e0 */ 0,0,0,0,0,0xabe0,0xabe1,0xabe2, 0xabe3,0xabe4,0,0,0,0,0,0, /* 0,0,0,0,0,'˥','˦','˧', '˨','˩',0,0,0,0,0,0, */
	/* 02f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0300 */ 0xabdc,0xabda,0xabdf,0xabfd,0xabdb,0,0xabd7,0, 0xabed,0,0,0xabd9,0xabde,0,0,0xabdd, /* '̀','́','̂','̃','̄',0,'̆',0, '̈',0,0,'̋','̌',0,0,'̏', */
	/* 0310 */ 0,0,0,0,0,0,0,0, 0xabf8,0xabf9,0xabfe,0,0xabea,0xabf6,0xabf7,0xabeb, /* 0,0,0,0,0,0,0,0, '̘','̙','̚',0,'̜','̝','̞','̟', */
	/* 0320 */ 0xabec,0,0,0,0xabf2,0xabe7,0,0, 0,0xabef,0xabfa,0,0xabe8,0,0,0xabf0, /* '̠',0,0,0,'̤','̥',0,0, 0,'̩','̪',0,'̬',0,0,'̯', */
	/* 0330 */ 0xabf3,0,0,0,0xabf5,0,0,0, 0,0xabe9,0xabfb,0xabfc,0xabf4,0xabee,0,0, /* '̰',0,0,0,'̴',0,0,0, 0,'̹','̺','̻','̼','̽',0,0, */
	/* 0340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0360 */ 0,0xabd2,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'͡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0390 */ 0,0xa6a1,0xa6a2,0xa6a3,0xa6a4,0xa6a5,0xa6a6,0xa6a7, 0xa6a8,0xa6a9,0xa6aa,0xa6ab,0xa6ac,0xa6ad,0xa6ae,0xa6af, /* 0,'Α','Β','Γ','Δ','Ε','Ζ','Η', 'Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο', */
	/* 03a0 */ 0xa6b0,0xa6b1,0,0xa6b2,0xa6b3,0xa6b4,0xa6b5,0xa6b6, 0xa6b7,0xa6b8,0,0,0,0,0,0, /* 'Π','Ρ',0,'Σ','Τ','Υ','Φ','Χ', 'Ψ','Ω',0,0,0,0,0,0, */
	/* 03b0 */ 0,0xa6c1,0xa6c2,0xa6c3,0xa6c4,0xa6c5,0xa6c6,0xa6c7, 0xa6c8,0xa6c9,0xa6ca,0xa6cb,0xa6cc,0xa6cd,0xa6ce,0xa6cf, /* 0,'α','β','γ','δ','ε','ζ','η', 'θ','ι','κ','λ','μ','ν','ξ','ο', */
	/* 03c0 */ 0xa6d0,0xa6d1,0xa6d9,0xa6d2,0xa6d3,0xa6d4,0xa6d5,0xa6d6, 0xa6d7,0xa6d8,0,0,0,0,0,0, /* 'π','ρ','ς','σ','τ','υ','φ','χ', 'ψ','ω',0,0,0,0,0,0, */
	/* 03d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0400 */ 0,0xa7a7,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'Ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0410 */ 0xa7a1,0xa7a2,0xa7a3,0xa7a4,0xa7a5,0xa7a6,0xa7a8,0xa7a9, 0xa7aa,0xa7ab,0xa7ac,0xa7ad,0xa7ae,0xa7af,0xa7b0,0xa7b1, /* 'А','Б','В','Г','Д','Е','Ж','З', 'И','Й','К','Л','М','Н','О','П', */
	/* 0420 */ 0xa7b2,0xa7b3,0xa7b4,0xa7b5,0xa7b6,0xa7b7,0xa7b8,0xa7b9, 0xa7ba,0xa7bb,0xa7bc,0xa7bd,0xa7be,0xa7bf,0xa7c0,0xa7c1, /* 'Р','С','Т','У','Ф','Х','Ц','Ч', 'Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я', */
	/* 0430 */ 0xa7d1,0xa7d2,0xa7d3,0xa7d4,0xa7d5,0xa7d6,0xa7d8,0xa7d9, 0xa7da,0xa7db,0xa7dc,0xa7dd,0xa7de,0xa7df,0xa7e0,0xa7e1, /* 'а','б','в','г','д','е','ж','з', 'и','й','к','л','м','н','о','п', */
	/* 0440 */ 0xa7e2,0xa7e3,0xa7e4,0xa7e5,0xa7e6,0xa7e7,0xa7e8,0xa7e9, 0xa7ea,0xa7eb,0xa7ec,0xa7ed,0xa7ee,0xa7ef,0xa7f0,0xa7f1, /* 'р','с','т','у','ф','х','ц','ч', 'ш','щ','ъ','ы','ь','э','ю','я', */
	/* 0450 */ 0,0xa7d7,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xa8f2,0xa8f3, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'Ḿ','ḿ', */
	/* 1e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f70 */ 0xabc6,0xabc7,0xabd0,0xabd1,0,0,0,0, 0,0,0,0,0,0,0,0, /* 'ὰ','ά','ὲ','έ',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2010 */ 0xa1be,0,0,0xa3fc,0xa1bd,0,0xa1c2,0, 0xa1c6,0xa1c7,0,0,0xa1c8,0xa1c9,0,0, /* '‐',0,0,'–','—',0,'‖',0, '‘','’',0,0,'“','”',0,0, */
	/* 2020 */ 0xa2f7,0xa2f8,0xa3c0,0,0,0xa1c5,0xa1c4,0, 0,0,0,0,0,0,0,0, /* '†','‡','•',0,0,'‥','…',0, 0,0,0,0,0,0,0,0, */
	/* 2030 */ 0xa2f3,0,0xa1ec,0xa1ed,0,0,0,0, 0,0,0,0xa2a8,0xa8eb,0,0xa1b1,0xabd8, /* '‰',0,'′','″',0,0,0,0, 0,0,0,'※','‼',0,'‾','‿', */
	/* 2040 */ 0,0,0xacfe,0,0,0,0,0xa8ec, 0xa8ed,0xa8ee,0,0,0,0,0,0, /* 0,0,'⁂',0,0,0,0,'⁇', '⁈','⁉',0,0,0,0,0,0, */
	/* 2050 */ 0,0xacfd,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'⁑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xa9a1,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'€',0,0,0, */
	/* 20b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2100 */ 0,0,0,0xa1ee,0,0,0,0, 0,0,0,0,0,0,0,0xa3dd, /* 0,0,0,'℃',0,0,0,0, 0,0,0,0,0,0,0,'ℏ', */
	/* 2110 */ 0,0,0,0xa3df,0,0,0xade2,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'ℓ',0,0,'№',0, 0,0,0,0,0,0,0,0, */
	/* 2120 */ 0,0xade4,0,0,0,0,0,0xa3e0, 0,0,0,0xa2f2,0,0,0,0, /* 0,'℡',0,0,0,0,0,'℧', 0,0,0,'Å',0,0,0,0, */
	/* 2130 */ 0,0,0,0,0,0xa3dc,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'ℵ',0,0, 0,0,0,0,0,0,0,0, */
	/* 2140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2150 */ 0,0,0,0xa7f8,0xa7f9,0xa7fa,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'⅓','⅔','⅕',0,0, 0,0,0,0,0,0,0,0, */
	/* 2160 */ 0xadb5,0xadb6,0xadb7,0xadb8,0xadb9,0xadba,0xadbb,0xadbc, 0xadbd,0xadbe,0xadbf,0xadd7,0,0,0,0, /* 'Ⅰ','Ⅱ','Ⅲ','Ⅳ','Ⅴ','Ⅵ','Ⅶ','Ⅷ', 'Ⅸ','Ⅹ','Ⅺ','Ⅻ',0,0,0,0, */
	/* 2170 */ 0xacb5,0xacb6,0xacb7,0xacb8,0xacb9,0xacba,0xacbb,0xacbc, 0xacbd,0xacbe,0xacbf,0xacc0,0,0,0,0, /* 'ⅰ','ⅱ','ⅲ','ⅳ','ⅴ','ⅵ','ⅶ','ⅷ', 'ⅸ','ⅹ','ⅺ','ⅻ',0,0,0,0, */
	/* 2180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2190 */ 0xa2ab,0xa2ac,0xa2aa,0xa2ad,0xa2f1,0,0xa3a7,0xa3a5, 0xa3a6,0xa3a8,0,0,0,0,0,0, /* '←','↑','→','↓','↔',0,'↖','↗', '↘','↙',0,0,0,0,0,0, */
	/* 21a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21c0 */ 0,0,0,0,0xa3a9,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'⇄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21d0 */ 0,0,0xa2cd,0,0xa2ce,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⇒',0,'⇔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21e0 */ 0,0,0,0,0,0,0xa3ab,0xa3ac, 0xa3aa,0xa3ad,0,0,0,0,0,0, /* 0,0,0,0,0,0,'⇦','⇧', '⇨','⇩',0,0,0,0,0,0, */
	/* 21f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2200 */ 0xa2cf,0,0xa2df,0xa2d0,0,0xa2c7,0,0xa2e0, 0xa2ba,0xa2c6,0,0xa2bb,0,0,0,0, /* '∀',0,'∂','∃',0,'∅',0,'∇', '∈','∉',0,'∋',0,0,0,0, */
	/* 2210 */ 0,0,0xa1dd,0xa3db,0,0,0,0, 0,0,0xa2e5,0,0,0xa2e7,0xa1e7,0xadf8, /* 0,0,'−','∓',0,0,0,0, 0,0,'√',0,0,'∝','∞','∟', */
	/* 2220 */ 0xa2dc,0,0,0,0,0xa2d4,0xa2d5,0xa2ca, 0xa2cb,0xa2c1,0xa2c0,0xa2e9,0xa2ea,0,0xadf3,0, /* '∠',0,0,0,0,'∥','∦','∧', '∨','∩','∪','∫','∬',0,'∮',0, */
	/* 2230 */ 0,0,0,0,0xa1e8,0xa2e8,0,0, 0,0,0,0,0,0xa2e6,0,0, /* 0,0,0,0,'∴','∵',0,0, 0,0,0,0,0,'∽',0,0, */
	/* 2240 */ 0,0,0,0xa2ec,0,0xa2ed,0,0, 0xa2ee,0,0,0,0,0,0,0, /* 0,0,0,'≃',0,'≅',0,0, '≈',0,0,0,0,0,0,0, */
	/* 2250 */ 0,0,0xa2e2,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'≒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2260 */ 0xa1e2,0xa2e1,0xa2eb,0,0,0,0xa1e5,0xa1e6, 0,0,0xa2e3,0xa2e4,0,0,0,0, /* '≠','≡','≢',0,0,0,'≦','≧', 0,0,'≪','≫',0,0,0,0, */
	/* 2270 */ 0,0,0,0,0,0,0xa2ef,0xa2f0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'≶','≷', 0,0,0,0,0,0,0,0, */
	/* 2280 */ 0,0,0xa2be,0xa2bf,0xa2c2,0xa2c3,0xa2bc,0xa2bd, 0,0,0xa2c4,0xa2c5,0,0,0,0, /* 0,0,'⊂','⊃','⊄','⊅','⊆','⊇', 0,0,'⊊','⊋',0,0,0,0, */
	/* 2290 */ 0,0,0,0,0,0xa2d1,0xa2d2,0xa2d3, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⊕','⊖','⊗', 0,0,0,0,0,0,0,0, */
	/* 22a0 */ 0,0,0,0,0,0xa2dd,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⊥',0,0, 0,0,0,0,0,0,0,0, */
	/* 22b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xadf9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'⊿', */
	/* 22c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22d0 */ 0,0,0,0,0,0,0,0, 0,0,0xa7f6,0xa7f7,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'⋚','⋛',0,0,0,0, */
	/* 22e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2300 */ 0,0,0,0,0,0xa2c8,0xa2c9,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⌅','⌆',0, 0,0,0,0,0,0,0,0, */
	/* 2310 */ 0,0,0xa2de,0,0,0,0,0, 0xa7fc,0,0,0,0,0,0,0, /* 0,0,'⌒',0,0,0,0,0, '⌘',0,0,0,0,0,0,0, */
	/* 2320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xa7c2,0xa7c3, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'⎾','⎿', */
	/* 23c0 */ 0xa7c4,0xa7c5,0xa7c6,0xa7c7,0xa7c8,0xa7c9,0xa7ca,0xa7cb, 0xa7cc,0xa7cd,0xa7ce,0xa7cf,0xa7d0,0,0xa7fe,0, /* '⏀','⏁','⏂','⏃','⏄','⏅','⏆','⏇', '⏈','⏉','⏊','⏋','⏌',0,'⏎',0, */
	/* 23d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2420 */ 0,0,0,0xa7fd,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'␣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2460 */ 0xada1,0xada2,0xada3,0xada4,0xada5,0xada6,0xada7,0xada8, 0xada9,0xadaa,0xadab,0xadac,0xadad,0xadae,0xadaf,0xadb0, /* '①','②','③','④','⑤','⑥','⑦','⑧', '⑨','⑩','⑪','⑫','⑬','⑭','⑮','⑯', */
	/* 2470 */ 0xadb1,0xadb2,0xadb3,0xadb4,0,0,0,0, 0,0,0,0,0,0,0,0, /* '⑰','⑱','⑲','⑳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24d0 */ 0xacc1,0xacc2,0xacc3,0xacc4,0xacc5,0xacc6,0xacc7,0xacc8, 0xacc9,0xacca,0xaccb,0xaccc,0xaccd,0xacce,0xaccf,0xacd0, /* 'ⓐ','ⓑ','ⓒ','ⓓ','ⓔ','ⓕ','ⓖ','ⓗ', 'ⓘ','ⓙ','ⓚ','ⓛ','ⓜ','ⓝ','ⓞ','ⓟ', */
	/* 24e0 */ 0xacd1,0xacd2,0xacd3,0xacd4,0xacd5,0xacd6,0xacd7,0xacd8, 0xacd9,0xacda,0,0xacab,0xacac,0xacad,0xacae,0xacaf, /* 'ⓠ','ⓡ','ⓢ','ⓣ','ⓤ','ⓥ','ⓦ','ⓧ', 'ⓨ','ⓩ',0,'⓫','⓬','⓭','⓮','⓯', */
	/* 24f0 */ 0xacb0,0xacb1,0xacb2,0xacb3,0xacb4,0xa6da,0xa6db,0xa6dc, 0xa6dd,0xa6de,0xa6df,0xa6e0,0xa6e1,0xa6e2,0xa6e3,0, /* '⓰','⓱','⓲','⓳','⓴','⓵','⓶','⓷', '⓸','⓹','⓺','⓻','⓼','⓽','⓾',0, */
	/* 2500 */ 0xa8a1,0xa8ac,0xa8a2,0xa8ad,0,0,0,0, 0,0,0,0,0xa8a3,0,0,0xa8ae, /* '─','━','│','┃',0,0,0,0, 0,0,0,0,'┌',0,0,'┏', */
	/* 2510 */ 0xa8a4,0,0,0xa8af,0xa8a6,0,0,0xa8b1, 0xa8a5,0,0,0xa8b0,0xa8a7,0xa8bc,0,0, /* '┐',0,0,'┓','└',0,0,'┗', '┘',0,0,'┛','├','┝',0,0, */
	/* 2520 */ 0xa8b7,0,0,0xa8b2,0xa8a9,0xa8be,0,0, 0xa8b9,0,0,0xa8b4,0xa8a8,0,0,0xa8b8, /* '┠',0,0,'┣','┤','┥',0,0, '┨',0,0,'┫','┬',0,0,'┯', */
	/* 2530 */ 0xa8bd,0,0,0xa8b3,0xa8aa,0,0,0xa8ba, 0xa8bf,0,0,0xa8b5,0xa8ab,0,0,0xa8bb, /* '┰',0,0,'┳','┴',0,0,'┷', '┸',0,0,'┻','┼',0,0,'┿', */
	/* 2540 */ 0,0,0xa8c0,0,0,0,0,0, 0,0,0,0xa8b6,0,0,0,0, /* 0,0,'╂',0,0,0,0,0, 0,0,0,'╋',0,0,0,0, */
	/* 2550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25a0 */ 0xa2a3,0xa2a2,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '■','□',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25b0 */ 0,0xa6ed,0xa2a5,0xa2a4,0,0,0xa3a2,0xa3a1, 0,0,0,0,0xa2a7,0xa2a6,0,0, /* 0,'▱','▲','△',0,0,'▶','▷', 0,0,0,0,'▼','▽',0,0, */
	/* 25c0 */ 0xa3a4,0xa3a3,0,0,0,0,0xa2a1,0xa1fe, 0,0xa3bb,0,0xa1fb,0,0,0xa1fd,0xa1fc, /* '◀','◁',0,0,0,0,'◆','◇', 0,'◉',0,'○',0,0,'◎','●', */
	/* 25d0 */ 0xa8e7,0xa8e8,0xa8e9,0xa8ea,0,0,0,0, 0,0,0,0,0,0,0,0, /* '◐','◑','◒','◓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25e0 */ 0,0,0,0,0,0,0xa3bf,0, 0,0,0,0,0,0,0,0xa2fe, /* 0,0,0,0,0,0,'◦',0, 0,0,0,0,0,0,0,'◯', */
	/* 25f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2600 */ 0xa6e8,0xa6e9,0xa6ea,0xa6eb,0,0xa1fa,0xa1f9,0, 0,0,0,0,0,0,0xa6e7,0, /* '☀','☁','☂','☃',0,'★','☆',0, 0,0,0,0,0,0,'☎',0, */
	/* 2610 */ 0,0,0,0,0,0,0xa6e4,0xa6e5, 0,0,0,0,0,0,0xadfe,0, /* 0,0,0,0,0,0,'☖','☗', 0,0,0,0,0,0,'☞',0, */
	/* 2620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2640 */ 0xa1ea,0,0xa1e9,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '♀',0,'♂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2660 */ 0xa6ba,0xa6bd,0xa6bb,0xa6c0,0xa6b9,0xa6be,0xa6bc,0xa6bf, 0xa6ec,0xa2fd,0xa2f6,0xa2fb,0xa2fc,0xa2f5,0xa2fa,0xa2f4, /* '♠','♡','♢','♣','♤','♥','♦','♧', '♨','♩','♪','♫','♬','♭','♮','♯', */
	/* 2670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2710 */ 0,0,0,0xa7fb,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'✓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2750 */ 0,0,0,0,0,0,0xadfd,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'❖',0, 0,0,0,0,0,0,0,0, */
	/* 2760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2770 */ 0,0,0,0,0,0,0xaca1,0xaca2, 0xaca3,0xaca4,0xaca5,0xaca6,0xaca7,0xaca8,0xaca9,0xacaa, /* 0,0,0,0,0,0,'❶','❷', '❸','❹','❺','❻','❼','❽','❾','❿', */
	/* 2780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2930 */ 0,0,0,0,0xa3ae,0xa3af,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'⤴','⤵',0,0, 0,0,0,0,0,0,0,0, */
	/* 2940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xa3ba, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'⦿', */
	/* 29c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29f0 */ 0,0,0,0,0,0,0,0, 0,0,0xa3fd,0xa3fe,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'⧺','⧻',0,0,0,0, */
	/* 2a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3000 */ 0xa1a1,0xa1a2,0xa1a3,0xa1b7,0,0xa1b9,0xa1ba,0xa1bb, 0xa1d2,0xa1d3,0xa1d4,0xa1d5,0xa1d6,0xa1d7,0xa1d8,0xa1d9, /* '　','、','。','〃',0,'々','〆','〇', '〈','〉','《','》','「','」','『','』', */
	/* 3010 */ 0xa1da,0xa1db,0xa2a9,0xa2ae,0xa1cc,0xa1cd,0xa2da,0xa2db, 0xa2d8,0xa2d9,0,0,0xa1c1,0xade0,0,0xade1, /* '【','】','〒','〓','〔','〕','〖','〗', '〘','〙',0,0,'〜','〝',0,'〟', */
	/* 3020 */ 0xa6e6,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '〠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3030 */ 0,0,0,0xa2b3,0xa2b4,0xa2b5,0,0, 0,0,0,0xa2b6,0xa2b7,0xa3bc,0,0, /* 0,0,0,'〳','〴','〵',0,0, 0,0,0,'〻','〼','〽',0,0, */
	/* 3040 */ 0,0xa4a1,0xa4a2,0xa4a3,0xa4a4,0xa4a5,0xa4a6,0xa4a7, 0xa4a8,0xa4a9,0xa4aa,0xa4ab,0xa4ac,0xa4ad,0xa4ae,0xa4af, /* 0,'ぁ','あ','ぃ','い','ぅ','う','ぇ', 'え','ぉ','お','か','が','き','ぎ','く', */
	/* 3050 */ 0xa4b0,0xa4b1,0xa4b2,0xa4b3,0xa4b4,0xa4b5,0xa4b6,0xa4b7, 0xa4b8,0xa4b9,0xa4ba,0xa4bb,0xa4bc,0xa4bd,0xa4be,0xa4bf, /* 'ぐ','け','げ','こ','ご','さ','ざ','し', 'じ','す','ず','せ','ぜ','そ','ぞ','た', */
	/* 3060 */ 0xa4c0,0xa4c1,0xa4c2,0xa4c3,0xa4c4,0xa4c5,0xa4c6,0xa4c7, 0xa4c8,0xa4c9,0xa4ca,0xa4cb,0xa4cc,0xa4cd,0xa4ce,0xa4cf, /* 'だ','ち','ぢ','っ','つ','づ','て','で', 'と','ど','な','に','ぬ','ね','の','は', */
	/* 3070 */ 0xa4d0,0xa4d1,0xa4d2,0xa4d3,0xa4d4,0xa4d5,0xa4d6,0xa4d7, 0xa4d8,0xa4d9,0xa4da,0xa4db,0xa4dc,0xa4dd,0xa4de,0xa4df, /* 'ば','ぱ','ひ','び','ぴ','ふ','ぶ','ぷ', 'へ','べ','ぺ','ほ','ぼ','ぽ','ま','み', */
	/* 3080 */ 0xa4e0,0xa4e1,0xa4e2,0xa4e3,0xa4e4,0xa4e5,0xa4e6,0xa4e7, 0xa4e8,0xa4e9,0xa4ea,0xa4eb,0xa4ec,0xa4ed,0xa4ee,0xa4ef, /* 'む','め','も','ゃ','や','ゅ','ゆ','ょ', 'よ','ら','り','る','れ','ろ','ゎ','わ', */
	/* 3090 */ 0xa4f0,0xa4f1,0xa4f2,0xa4f3,0xa4f4,0xa4f5,0xa4f6,0, 0,0,0,0xa1ab,0xa1ac,0xa1b5,0xa1b6,0xa2b9, /* 'ゐ','ゑ','を','ん','ゔ','ゕ','ゖ',0, 0,0,0,'゛','゜','ゝ','ゞ','ゟ', */
	/* 30a0 */ 0xa3fb,0xa5a1,0xa5a2,0xa5a3,0xa5a4,0xa5a5,0xa5a6,0xa5a7, 0xa5a8,0xa5a9,0xa5aa,0xa5ab,0xa5ac,0xa5ad,0xa5ae,0xa5af, /* '゠','ァ','ア','ィ','イ','ゥ','ウ','ェ', 'エ','ォ','オ','カ','ガ','キ','ギ','ク', */
	/* 30b0 */ 0xa5b0,0xa5b1,0xa5b2,0xa5b3,0xa5b4,0xa5b5,0xa5b6,0xa5b7, 0xa5b8,0xa5b9,0xa5ba,0xa5bb,0xa5bc,0xa5bd,0xa5be,0xa5bf, /* 'グ','ケ','ゲ','コ','ゴ','サ','ザ','シ', 'ジ','ス','ズ','セ','ゼ','ソ','ゾ','タ', */
	/* 30c0 */ 0xa5c0,0xa5c1,0xa5c2,0xa5c3,0xa5c4,0xa5c5,0xa5c6,0xa5c7, 0xa5c8,0xa5c9,0xa5ca,0xa5cb,0xa5cc,0xa5cd,0xa5ce,0xa5cf, /* 'ダ','チ','ヂ','ッ','ツ','ヅ','テ','デ', 'ト','ド','ナ','ニ','ヌ','ネ','ノ','ハ', */
	/* 30d0 */ 0xa5d0,0xa5d1,0xa5d2,0xa5d3,0xa5d4,0xa5d5,0xa5d6,0xa5d7, 0xa5d8,0xa5d9,0xa5da,0xa5db,0xa5dc,0xa5dd,0xa5de,0xa5df, /* 'バ','パ','ヒ','ビ','ピ','フ','ブ','プ', 'ヘ','ベ','ペ','ホ','ボ','ポ','マ','ミ', */
	/* 30e0 */ 0xa5e0,0xa5e1,0xa5e2,0xa5e3,0xa5e4,0xa5e5,0xa5e6,0xa5e7, 0xa5e8,0xa5e9,0xa5ea,0xa5eb,0xa5ec,0xa5ed,0xa5ee,0xa5ef, /* 'ム','メ','モ','ャ','ヤ','ュ','ユ','ョ', 'ヨ','ラ','リ','ル','レ','ロ','ヮ','ワ', */
	/* 30f0 */ 0xa5f0,0xa5f1,0xa5f2,0xa5f3,0xa5f4,0xa5f5,0xa5f6,0xa7f2, 0xa7f3,0xa7f4,0xa7f5,0xa1a6,0xa1bc,0xa1b3,0xa1b4,0xa2b8, /* 'ヰ','ヱ','ヲ','ン','ヴ','ヵ','ヶ','ヷ', 'ヸ','ヹ','ヺ','・','ー','ヽ','ヾ','ヿ', */
	/* 3100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31f0 */ 0xa6ee,0xa6ef,0xa6f0,0xa6f1,0xa6f2,0xa6f3,0xa6f4,0xa6f5, 0xa6f6,0xa6f7,0xa6f9,0xa6fa,0xa6fb,0xa6fc,0xa6fd,0xa6fe, /* 'ㇰ','ㇱ','ㇲ','ㇳ','ㇴ','ㇵ','ㇶ','ㇷ', 'ㇸ','ㇹ','ㇺ','ㇻ','ㇼ','ㇽ','ㇾ','ㇿ', */
	/* 3200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3230 */ 0,0xadea,0xadeb,0,0,0,0,0, 0,0xadec,0,0,0,0,0,0, /* 0,'㈱','㈲',0,0,0,0,0, 0,'㈹',0,0,0,0,0,0, */
	/* 3240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3250 */ 0,0xa8c1,0xa8c2,0xa8c3,0xa8c4,0xa8c5,0xa8c6,0xa8c7, 0xa8c8,0xa8c9,0xa8ca,0xa8cb,0xa8cc,0xa8cd,0xa8ce,0xa8cf, /* 0,'㉑','㉒','㉓','㉔','㉕','㉖','㉗', '㉘','㉙','㉚','㉛','㉜','㉝','㉞','㉟', */
	/* 3260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32a0 */ 0,0,0,0,0xade5,0xade6,0xade7,0xade8, 0xade9,0,0,0,0,0,0,0, /* 0,0,0,0,'㊤','㊥','㊦','㊧', '㊨',0,0,0,0,0,0,0, */
	/* 32b0 */ 0,0xa8d0,0xa8d1,0xa8d2,0xa8d3,0xa8d4,0xa8d5,0xa8d6, 0xa8d7,0xa8d8,0xa8d9,0xa8da,0xa8db,0xa8dc,0xa8dd,0xa8de, /* 0,'㊱','㊲','㊳','㊴','㊵','㊶','㊷', '㊸','㊹','㊺','㊻','㊼','㊽','㊾','㊿', */
	/* 32c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32d0 */ 0xacdb,0xacdc,0xacdd,0xacde,0xacdf,0xace0,0xace1,0xace2, 0xace3,0xace4,0xace5,0xace6,0xace7,0xace8,0xace9,0xacea, /* '㋐','㋑','㋒','㋓','㋔','㋕','㋖','㋗', '㋘','㋙','㋚','㋛','㋜','㋝','㋞','㋟', */
	/* 32e0 */ 0xaceb,0xacec,0xaced,0xacee,0,0xacf1,0,0, 0,0xacf0,0,0,0xacf3,0xacf2,0,0, /* '㋠','㋡','㋢','㋣',0,'㋥',0,0, 0,'㋩',0,0,'㋬','㋭',0,0, */
	/* 32f0 */ 0,0,0,0,0,0,0,0, 0,0,0xacef,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㋺',0,0,0,0,0, */
	/* 3300 */ 0,0,0,0xadc6,0,0,0,0, 0,0,0,0,0,0xadca,0,0, /* 0,0,0,'㌃',0,0,0,0, 0,0,0,0,0,'㌍',0,0, */
	/* 3310 */ 0,0,0,0,0xadc1,0,0,0, 0xadc4,0,0,0,0,0,0,0, /* 0,0,0,0,'㌔',0,0,0, '㌘',0,0,0,0,0,0,0, */
	/* 3320 */ 0,0,0xadc2,0xadcc,0,0,0xadcb,0xadc5, 0,0,0,0xadcd,0,0,0,0, /* 0,0,'㌢','㌣',0,0,'㌦','㌧', 0,0,0,'㌫',0,0,0,0, */
	/* 3330 */ 0,0,0,0,0,0,0xadc7,0, 0,0,0,0xadcf,0,0,0,0, /* 0,0,0,0,0,0,'㌶',0, 0,0,0,'㌻',0,0,0,0, */
	/* 3340 */ 0,0,0,0,0,0,0,0, 0,0xadc0,0xadce,0,0,0xadc3,0,0, /* 0,0,0,0,0,0,0,0, 0,'㍉','㍊',0,0,'㍍',0,0, */
	/* 3350 */ 0,0xadc8,0,0,0,0,0,0xadc9, 0,0,0,0,0,0,0,0, /* 0,'㍑',0,0,0,0,0,'㍗', 0,0,0,0,0,0,0,0, */
	/* 3360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3370 */ 0,0,0,0,0,0,0,0, 0,0,0,0xaddf,0xadef,0xadee,0xaded,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'㍻','㍼','㍽','㍾',0, */
	/* 3380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xadd3,0xadd4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㎎','㎏', */
	/* 3390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xadd0,0xadd1,0xadd2,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㎜','㎝','㎞',0, */
	/* 33a0 */ 0,0xadd6,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'㎡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 33b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33c0 */ 0,0,0,0,0xadd5,0,0,0, 0,0,0,0xa3de,0,0xade3,0,0, /* 0,0,0,0,'㏄',0,0,0, 0,0,0,'㏋',0,'㏍',0,0, */
	/* 33d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3400 */ 0,0,0xaea3,0,0,0,0x8fa1ad,0, 0,0,0,0,0,0,0,0, /* 0,0,'㐂',0,0,0,'㐆',0, 0,0,0,0,0,0,0,0, */
	/* 3410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x8fa1b2,0,0x8fa1b3,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㐬',0,'㐮',0, */
	/* 3430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3460 */ 0,0,0,0,0,0,0,0, 0x8fa1de,0,0x8fa1d6,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '㑨',0,'㑪',0,0,0,0,0, */
	/* 3470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3490 */ 0,0,0x8fa1fe,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'㒒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 34a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34b0 */ 0,0,0,0,0,0xaed3,0,0, 0,0,0,0,0x8fa3ab,0,0,0, /* 0,0,0,0,0,'㒵',0,0, 0,0,0,0,'㒼',0,0,0, */
	/* 34c0 */ 0,0x8ff4e8,0,0,0,0,0,0x8fa3af, 0,0,0,0,0,0,0,0, /* 0,'㓁',0,0,0,0,0,'㓇', 0,0,0,0,0,0,0,0, */
	/* 34d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0xaedb,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'㓛',0,0,0,0, */
	/* 34e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x8fa3c8, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㔟', */
	/* 3520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x8fa3dd,0x8fa3de,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'㕝','㕞',0, */
	/* 3560 */ 0,0,0,0x8fa3e1,0,0,0,0, 0,0,0,0,0,0,0x8fa3e7,0, /* 0,0,0,'㕣',0,0,0,0, 0,0,0,0,0,0,'㕮',0, */
	/* 3570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35a0 */ 0,0,0,0,0,0,0x8fa4a3,0, 0x8fa4a6,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㖦',0, '㖨',0,0,0,0,0,0,0, */
	/* 35b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35c0 */ 0,0,0,0,0,0x8fa4af,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'㗅',0,0, 0,0,0,0,0,0,0,0, */
	/* 35d0 */ 0,0,0,0,0,0,0,0, 0,0,0x8fa4b8,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㗚',0,0,0,0,0, */
	/* 35e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35f0 */ 0,0,0,0,0x8fa4c2,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㗴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3600 */ 0,0,0,0,0,0x8fa4ca,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'㘅',0,0, 0,0,0,0,0,0,0,0, */
	/* 3610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3640 */ 0,0,0,0,0,0,0,0, 0,0,0x8fa4f9,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㙊',0,0,0,0,0, */
	/* 3650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3690 */ 0,0x8fa5bf,0,0,0,0,0x8fa5c3,0, 0,0x8fa5c1,0,0,0,0,0,0, /* 0,'㚑',0,0,0,0,'㚖',0, 0,'㚙',0,0,0,0,0,0, */
	/* 36a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x8fa5d7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㛏', */
	/* 36d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3760 */ 0,0x8fa8a3,0x8fa8a5,0,0,0,0,0, 0,0,0,0x8fa8a9,0x8fa8a8,0,0,0, /* 0,'㝡','㝢',0,0,0,0,0, 0,0,0,'㝫','㝬',0,0,0, */
	/* 3770 */ 0,0,0,0,0,0x8fa8ac,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'㝵',0,0, 0,0,0,0,0,0,0,0, */
	/* 3780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xcfdf,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'㞍',0,0, */
	/* 3790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37c0 */ 0,0x8fa8be,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'㟁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 37d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37e0 */ 0,0,0xcfef,0,0,0,0,0, 0x8fa8d6,0,0,0,0,0,0,0, /* 0,0,'㟢',0,0,0,0,0, '㟨',0,0,0,0,0,0,0, */
	/* 37f0 */ 0,0,0,0,0x8fa8d9,0,0,0, 0,0,0,0,0,0x8fa8dc,0,0, /* 0,0,0,0,'㟴',0,0,0, 0,0,0,0,0,'㟽',0,0, */
	/* 3800 */ 0x8fa8de,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '㠀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x8fa8ef, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㠯', */
	/* 3830 */ 0,0,0,0,0,0,0x8fa8f1,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㠶',0, 0,0,0,0,0,0,0,0, */
	/* 3840 */ 0x8fa8f4,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '㡀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x8fa8f9,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㡜',0,0,0, */
	/* 3860 */ 0,0x8fa8fb,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'㡡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38f0 */ 0,0,0,0,0,0,0,0, 0,0,0x8facbb,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㣺',0,0,0,0,0, */
	/* 3900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3910 */ 0,0,0,0,0,0,0,0x8facc6, 0,0,0x8facca,0,0,0,0,0, /* 0,0,0,0,0,0,0,'㤗', 0,0,'㤚',0,0,0,0,0, */
	/* 3920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x8face0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㥯', */
	/* 3970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x8faddb,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㩮',0, */
	/* 3a70 */ 0,0,0,0x8faddf,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'㩳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ad0 */ 0,0,0,0,0,0,0x8fadf1,0x8faeb6, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㫖','㫗', 0,0,0,0,0,0,0,0, */
	/* 3ae0 */ 0,0,0,0,0,0,0,0, 0,0,0x8fadfc,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㫪',0,0,0,0,0, */
	/* 3af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x8faeae,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㬎',0, */
	/* 3b10 */ 0,0,0,0,0,0,0,0, 0,0,0x8faeb2,0,0x8faeb4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㬚',0,'㬜',0,0,0, */
	/* 3b20 */ 0,0,0xf5c9,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'㬢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x8faeed,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'㭭',0,0, */
	/* 3b70 */ 0,0,0,0,0,0,0,0x8faee5, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'㭷', 0,0,0,0,0,0,0,0, */
	/* 3b80 */ 0,0,0,0,0,0,0,0x8fafa8, 0x8fafa9,0,0,0,0,0x8fafac,0,0, /* 0,0,0,0,0,0,0,'㮇', '㮈',0,0,0,0,'㮍',0,0, */
	/* 3b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ba0 */ 0,0,0,0,0x8fafb4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㮤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3bb0 */ 0,0,0,0,0,0,0xf5fe,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㮶',0, 0,0,0,0,0,0,0,0, */
	/* 3bc0 */ 0,0,0,0xf6a1,0,0,0,0, 0,0,0,0,0,0x8fafc8,0,0, /* 0,0,0,'㯃',0,0,0,0, 0,0,0,0,0,'㯍',0,0, */
	/* 3bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bf0 */ 0x8fafdd,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '㯰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xf6ba, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㰏', */
	/* 3c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c20 */ 0,0,0,0,0,0,0x8faff7,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㰦',0, 0,0,0,0,0,0,0,0, */
	/* 3c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cc0 */ 0,0,0,0x8feebb,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'㳃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3cd0 */ 0,0,0x8feec2,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'㳒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d10 */ 0,0x8feef1,0,0,0,0,0,0, 0,0,0,0,0,0,0x8feefe,0, /* 0,'㴑',0,0,0,0,0,0, 0,0,0,0,0,0,'㴞',0, */
	/* 3d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d60 */ 0,0,0,0,0x8fefc0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㵤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d90 */ 0,0,0,0,0,0,0,0, 0,0,0x8fefd4,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㶚',0,0,0,0,0, */
	/* 3da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dc0 */ 0x8feff0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '㷀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3dd0 */ 0,0,0,0,0x8feff7,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㷔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e00 */ 0,0,0,0,0,0x8ff0a8,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'㸅',0,0, 0,0,0,0,0,0,0,0, */
	/* 3e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xf7e6, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㸿', */
	/* 3e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e60 */ 0x8ff0bf,0,0,0,0,0,0x8ff0c1,0, 0x8ff0c2,0,0,0,0,0,0,0, /* '㹠',0,0,0,0,0,'㹦',0, '㹨',0,0,0,0,0,0,0, */
	/* 3e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e80 */ 0,0,0,0x8ff0c9,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'㺃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3e90 */ 0,0,0,0,0x8ff0d0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㺔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f50 */ 0,0,0,0,0,0,0,0x8ff1b4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'㽗', 0,0,0,0,0,0,0,0, */
	/* 3f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f70 */ 0,0,0xf8cd,0,0,0x8ff1c6,0,0x8ff1c8, 0,0,0,0,0,0,0,0, /* 0,0,'㽲',0,0,'㽵',0,'㽷', 0,0,0,0,0,0,0,0, */
	/* 3f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x8ff1dc,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㾮',0, */
	/* 3fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fc0 */ 0,0,0,0,0,0,0,0, 0,0x8ff1e7,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'㿉',0,0,0,0,0,0, */
	/* 3fd0 */ 0,0,0,0,0,0,0,0x8ff1ec, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'㿗', 0,0,0,0,0,0,0,0, */
	/* 3fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4030 */ 0,0,0,0,0,0,0,0, 0,0x8ff2a2,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'䀹',0,0,0,0,0,0, */
	/* 4040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4050 */ 0,0,0,0,0,0,0,0, 0x8ff2ad,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '䁘',0,0,0,0,0,0,0, */
	/* 4060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4090 */ 0,0,0,0x8ff2b9,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䂓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 40a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4100 */ 0,0,0,0,0,0x8ff2e4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'䄅',0,0, 0,0,0,0,0,0,0,0, */
	/* 4110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4140 */ 0,0,0,0,0,0,0,0, 0x8ff2f4,0,0,0,0,0,0,0x8ff2f7, /* 0,0,0,0,0,0,0,0, '䅈',0,0,0,0,0,0,'䅏', */
	/* 4150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4160 */ 0,0,0,0x8ff2fd,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䅣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41b0 */ 0,0,0,0,0x8ff3b3,0,0,0, 0,0,0,0,0,0,0,0x8ff3b7, /* 0,0,0,0,'䆴',0,0,0, 0,0,0,0,0,0,0,'䆿', */
	/* 41c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41e0 */ 0,0,0,0,0,0,0x8ff3c7,0, 0,0,0,0,0,0,0x8ff3cb,0, /* 0,0,0,0,0,0,'䇦',0, 0,0,0,0,0,0,'䇮',0, */
	/* 41f0 */ 0,0,0,0x8ff3c8,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䇳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4200 */ 0,0,0,0,0,0,0,0x8ff3d3, 0,0,0,0,0,0,0x8ff3d7,0, /* 0,0,0,0,0,0,0,'䈇', 0,0,0,0,0,0,'䈎',0, */
	/* 4210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4260 */ 0,0,0,0,0xf9ed,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䉤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42c0 */ 0,0,0,0,0,0,0x8ff4ab,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'䋆',0, 0,0,0,0,0,0,0,0, */
	/* 42d0 */ 0,0,0,0,0,0,0x8ff4b6,0, 0,0,0,0,0,0x8ff4bb,0,0, /* 0,0,0,0,0,0,'䋖',0, 0,0,0,0,0,'䋝',0,0, */
	/* 42e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4300 */ 0,0,0x8ff4ce,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'䌂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4320 */ 0,0,0,0,0,0,0,0, 0,0,0,0x8ff4dd,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'䌫',0,0,0,0, */
	/* 4330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4340 */ 0,0,0,0x8ff4e1,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䍃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x8ff5be,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'䏮',0, */
	/* 43f0 */ 0x8ff5c2,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '䏰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4400 */ 0,0,0,0,0,0,0,0, 0x8ff5c8,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '䐈',0,0,0,0,0,0,0, */
	/* 4410 */ 0,0,0,0,0,0,0,0x8ff5ca, 0,0,0,0,0x8ff5cc,0,0,0, /* 0,0,0,0,0,0,0,'䐗', 0,0,0,0,'䐜',0,0,0, */
	/* 4420 */ 0,0,0x8ff5cf,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'䐢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4450 */ 0,0,0,0xfad9,0,0,0,0, 0,0,0,0xfada,0,0,0,0, /* 0,0,0,'䑓',0,0,0,0, 0,0,0,'䑛',0,0,0,0, */
	/* 4460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4470 */ 0,0,0,0,0,0,0x8ff5ec,0, 0,0,0x8ff5ee,0,0,0,0,0, /* 0,0,0,0,0,0,'䑶',0, 0,0,'䑺',0,0,0,0,0, */
	/* 4480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4490 */ 0,0x8ff5f7,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'䒑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 44a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44b0 */ 0,0,0,0x8ff6b5,0,0,0,0, 0,0,0,0,0,0,0x8ff6b2,0, /* 0,0,0,'䒳',0,0,0,0, 0,0,0,0,0,0,'䒾',0, */
	/* 44c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44d0 */ 0,0,0,0,0x8ff6b4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䓔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 44e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4500 */ 0,0,0,0,0,0,0,0, 0x8ff6d9,0,0,0,0,0x8ff6d4,0,0, /* 0,0,0,0,0,0,0,0, '䔈',0,0,0,0,'䔍',0,0, */
	/* 4510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4520 */ 0,0,0,0,0,0x8ff6ed,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'䔥',0,0, 0,0,0,0,0,0,0,0, */
	/* 4530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4540 */ 0,0,0,0x8ff6ee,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䕃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xfbd1,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'䖝',0,0, */
	/* 45a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45b0 */ 0,0,0,0,0,0,0,0, 0x8ff7cf,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '䖸',0,0,0,0,0,0,0, */
	/* 45c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45e0 */ 0,0,0,0,0,0x8ff7ec,0,0, 0,0,0xfbe0,0,0,0,0,0, /* 0,0,0,0,0,'䗥',0,0, 0,0,'䗪',0,0,0,0,0, */
	/* 45f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x8ff8a4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'䘏', */
	/* 4610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4640 */ 0,0x8ff8ba,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'䙁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4660 */ 0,0,0,0,0,0x8ff8c3,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'䙥',0,0, 0,0,0,0,0,0,0,0, */
	/* 4670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46a0 */ 0,0x8ff8ce,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x8ff8d3, /* 0,'䚡',0,0,0,0,0,0, 0,0,0,0,0,0,0,'䚯', */
	/* 46b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x8ff8eb,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'䜌',0,0,0, */
	/* 4710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4760 */ 0,0,0,0,0x8ff9a9,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䝤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x8ff9bf,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'䟽',0,0, */
	/* 4800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4810 */ 0,0,0,0,0,0,0x8ff9c9,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'䠖',0, 0,0,0,0,0,0,0,0, */
	/* 4820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4840 */ 0,0,0,0,0xfccb,0,0,0, 0,0,0,0,0,0,0x8ff9dc,0, /* 0,0,0,0,'䡄',0,0,0, 0,0,0,0,0,0,'䡎',0, */
	/* 4850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48b0 */ 0,0,0,0,0,0x8ffaa7,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'䢵',0,0, 0,0,0,0,0,0,0,0, */
	/* 48c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49b0 */ 0xfdd8,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '䦰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 49c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49e0 */ 0,0,0,0,0,0,0,0x8ffbea, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'䧧', 0,0,0,0,0,0,0,0, */
	/* 49f0 */ 0,0,0,0,0,0,0,0, 0,0,0x8ffbf0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'䧺',0,0,0,0,0, */
	/* 4a00 */ 0,0,0,0,0x8ffbf5,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䨄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a20 */ 0,0,0,0,0,0,0,0, 0,0x8ffbf8,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'䨩',0,0,0,0,0,0, */
	/* 4a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x8ffcb7,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'䪼',0,0,0, */
	/* 4ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0x8ffcd5,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'䬻',0,0,0,0, */
	/* 4b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bc0 */ 0,0,0x8ffda6,0,0,0,0,0, 0,0,0x8ffda8,0,0,0,0,0, /* 0,0,'䯂',0,0,0,0,0, 0,0,'䯊',0,0,0,0,0, */
	/* 4bd0 */ 0,0,0x8ffdaa,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'䯒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4be0 */ 0,0,0,0,0,0,0,0, 0x8ffdb1,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '䯨',0,0,0,0,0,0,0, */
	/* 4bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c10 */ 0,0,0,0,0,0,0,0xfebe, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'䰗', 0,0,0,0,0,0,0,0, */
	/* 4c20 */ 0x8ffdbf,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '䰠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cc0 */ 0,0,0,0,0x8ffeaa,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䳄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4cd0 */ 0,0x8ffead,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'䳑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d00 */ 0,0,0,0,0,0,0,0x8ffecb, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'䴇', 0,0,0,0,0,0,0,0, */
	/* 4d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d70 */ 0,0,0,0,0,0,0,0x8ffee0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'䵷', 0,0,0,0,0,0,0,0, */
	/* 4d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e00 */ 0xb0ec,0xc3fa,0x8fa1a2,0xbcb7,0,0,0,0xcbfc, 0xbee6,0xbbb0,0xbee5,0xb2bc,0,0xc9d4,0xcdbf,0x8fa1a3, /* '一','丁','丂','七',0,0,0,'万', '丈','三','上','下',0,'不','与','丏', */
	/* 4e10 */ 0xd0a2,0xb1af,0x8fa1a4,0,0xb3ee,0xd0a3,0xc0a4,0xd2c2, 0xb5d6,0xcaba,0,0,0,0,0xbee7,0, /* '丐','丑','丒',0,'且','丕','世','丗', '丘','丙',0,0,0,0,'丞',0, */
	/* 4e20 */ 0,0xcebe,0,0,0,0,0xcac2,0, 0xaea4,0x8fa1a5,0xd0a4,0x8fa1a6,0x8ff0ae,0xc3e6,0x8fa1a7,0xaea5, /* 0,'両',0,0,0,0,'並',0, '丨','丩','个','丫','丬','中','丮','丯', */
	/* 4e30 */ 0xaea6,0xd0a5,0xb6fa,0,0,0,0xd0a6,0, 0xb4dd,0xc3b0,0,0xbce7,0xd0a7,0,0,0xd0a8, /* '丰','丱','串',0,0,0,'丶',0, '丸','丹',0,'主','丼',0,0,'丿', */
	/* 4e40 */ 0x8fa1a8,0,0xd0a9,0xc7b5,0,0xb5d7,0,0x8fa1a9, 0x8fa1aa,0,0,0xc7b7,0,0xc6e3,0xb8c3,0xcbb3, /* '乀',0,'乂','乃',0,'久',0,'乇', '么',0,0,'之',0,'乍','乎','乏', */
	/* 4e50 */ 0,0x8fa1ac,0,0,0,0xe9c9,0xd0aa,0xbee8, 0xd0ab,0xb2b5,0x8fa1af,0,0,0xb6e5,0xb8f0,0xcce9, /* 0,'乑',0,0,0,'乕','乖','乗', '乘','乙','乚',0,0,'九','乞','也', */
	/* 4e60 */ 0,0,0xd6a6,0,0,0,0,0, 0,0x8fa1b0,0,0,0,0,0,0, /* 0,0,'乢',0,0,0,0,0, 0,'乩',0,0,0,0,0,0, */
	/* 4e70 */ 0,0xcdf0,0,0xc6fd,0,0,0,0, 0,0,0,0,0,0,0xb4a5,0, /* 0,'乱',0,'乳',0,0,0,0, 0,0,0,0,0,0,'乾',0, */
	/* 4e80 */ 0xb5b5,0,0xd0ac,0,0,0xd0ad,0xcebb,0, 0xcdbd,0xc1e8,0xd0af,0xbbf6,0xc6f3,0xaea7,0xd0b2,0, /* '亀',0,'亂',0,0,'亅','了',0, '予','争','亊','事','二','亍','于',0, */
	/* 4e90 */ 0,0xb1be,0xb8df,0,0xb8de,0xb0e6,0,0, 0xcfcb,0xcfca,0,0xbab3,0xb0a1,0x8fa1b1,0xd0b3,0xd0b4, /* 0,'云','互',0,'五','井',0,0, '亘','亙',0,'些','亜','亝','亞','亟', */
	/* 4ea0 */ 0xd0b5,0xcbb4,0xd0b6,0,0xb8f2,0xb0e7,0xcbf2,0, 0xb5fc,0,0,0xb5fd,0xb5fe,0xc4e2,0xcebc,0, /* '亠','亡','亢',0,'交','亥','亦',0, '亨',0,0,'享','京','亭','亮',0, */
	/* 4eb0 */ 0xd0b7,0,0,0xd0b8,0,0,0xd0b9,0, 0,0x8fa1b4,0xbfcd,0x8fa1b5,0x8fa1b7,0,0,0, /* '亰',0,0,'亳',0,0,'亶',0, 0,'亹','人','亻','亼',0,0,0, */
	/* 4ec0 */ 0xbdba,0xbfce,0xd0be,0x8fa1b8,0xd0bc,0,0xd0bd,0xb5d8, 0x8fa1b9,0,0xbaa3,0xb2f0,0,0xd0bb,0xd0ba,0xcaa9, /* '什','仁','仂','仃','仄',0,'仆','仇', '仈',0,'今','介',0,'仍','从','仏', */
	/* 4ed0 */ 0x8fa1ba,0,0,0,0xbbc6,0xbbc5,0xc2be,0xd0bf, 0xc9d5,0xc0e7,0x8fa1bc,0,0,0xa1b8,0xd0c0,0xd0c2, /* '仐',0,0,0,'仔','仕','他','仗', '付','仙','仚',0,0,'仝','仞','仟', */
	/* 4ee0 */ 0,0xaea8,0,0xc2e5,0xcee1,0xb0ca,0,0, 0,0,0,0x8fa1bb,0,0xd0c1,0xb2be,0, /* 0,'仡',0,'代','令','以',0,0, 0,0,0,'仫',0,'仭','仮',0, */
	/* 4ef0 */ 0xb6c4,0x8fa1bd,0xc3e7,0,0,0x8fa1be,0xb7ef,0xd0c3, 0,0,0,0xc7a4,0,0xaea9,0,0xaeaa, /* '仰','仱','仲',0,0,'仵','件','价', 0,0,0,'任',0,'份',0,'仿', */
	/* 4f00 */ 0x8fa1bf,0xb4eb,0,0xaeab,0,0,0,0, 0,0xd0c4,0xb0cb,0xaeac,0,0xb8e0,0xb4ec,0xc9fa, /* '伀','企',0,'伃',0,0,0,0, 0,'伉','伊','伋',0,'伍','伎','伏', */
	/* 4f10 */ 0xc8b2,0xb5d9,0,0,0,0,0x8fa1c0,0, 0,0,0xb2f1,0,0xd0e7,0xc5c1,0,0, /* '伐','休',0,0,0,0,'伖',0, 0,0,'会',0,'伜','伝',0,0, */
	/* 4f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xc7ec, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'伯', */
	/* 4f30 */ 0xd0c6,0,0,0,0xc8bc,0,0xcee2,0x8fa1c2, 0xbfad,0,0xbbc7,0,0xbbf7,0xb2c0,0x8fa1c3,0, /* '估',0,0,0,'伴',0,'伶','伷', '伸',0,'伺',0,'似','伽','伾',0, */
	/* 4f40 */ 0,0,0,0xc4d1,0,0,0xc3a2,0xd0ca, 0xaeae,0xaeaf,0,0,0,0xb0cc,0xc4e3,0xbdbb, /* 0,0,0,'佃',0,0,'但','佇', '佈','佉',0,0,0,'位','低','住', */
	/* 4f50 */ 0xbab4,0xcda4,0,0xc2ce,0x8fa1c4,0xb2bf,0xaeb0,0xd0c9, 0x8fa1c5,0xcdbe,0xd0c5,0xd0c7,0xbaee,0xd0c8,0xd5a4,0xaeb1, /* '佐','佑',0,'体','佔','何','佖','佗', '佘','余','佚','佛','作','佝','佞','佟', */
	/* 4f60 */ 0xaead,0,0,0,0x8fa1c1,0,0,0, 0,0xd0d0,0xaeb2,0,0xaeb3,0,0,0xd0d3, /* '你',0,0,0,'佤',0,0,0, 0,'佩','佪',0,'佬',0,0,'佯', */
	/* 4f70 */ 0xd0d1,0,0,0xb2c2,0,0xcabb,0xd0cb,0x8fa1c7, 0x8fa1c8,0,0x8fa1c9,0xd0cf,0xb8f3,0x8fa1ca,0xaeb4,0xbbc8, /* '佰',0,0,'佳',0,'併','佶','佷', '佸',0,'佺','佻','佼','佽','佾','使', */
	/* 4f80 */ 0,0,0x8fa1cb,0xb4a6,0,0x8fa1cc,0xd0d4,0, 0xd0cc,0,0xaeb5,0xcee3,0,0xbbf8,0,0xd0cd, /* 0,0,'侂','侃',0,'侅','來',0, '侈',0,'侊','例',0,'侍',0,'侏', */
	/* 4f90 */ 0,0xd0d2,0x8fa1cd,0,0xaeb6,0,0xd0d5,0xaeb7, 0xd0ce,0,0x8fa1ce,0xb6a1,0,0xb0cd,0,0, /* 0,'侑','侒',0,'侔',0,'侖','侗', '侘',0,'侚','供',0,'依',0,0, */
	/* 4fa0 */ 0xb6a2,0xb2c1,0,0,0,0,0,0, 0,0,0,0xd5a5,0,0xcbf9,0xc9ee,0xb8f4, /* '侠','価',0,0,0,0,0,0, 0,0,0,'侫',0,'侭','侮','侯', */
	/* 4fb0 */ 0,0,0x8fa1d0,0,0,0xbfaf,0xceb7,0, 0,0,0,0,0,0,0x8fa1d1,0xcad8, /* 0,0,'侲',0,0,'侵','侶',0, 0,0,0,0,0,0,'侾','便', */
	/* 4fc0 */ 0,0,0xb7b8,0xc2a5,0xb2e4,0x8fa1d2,0,0, 0,0xaeb9,0xbdd3,0x8fa1d3,0,0,0xd0d9,0x8fa1d4, /* 0,0,'係','促','俄','俅',0,0, 0,'俉','俊','俋',0,0,'俎','俏', */
	/* 4fd0 */ 0xd0de,0xd0dc,0x8fa1d5,0,0xd0d7,0,0,0xc2af, 0xd0da,0,0xd0dd,0xd0db,0,0xcadd,0,0xd0d8, /* '俐','俑','俒',0,'俔',0,0,'俗', '俘',0,'俚','俛',0,'保',0,'俟', */
	/* 4fe0 */ 0xaeba,0xbfae,0,0xcbf3,0xd0df,0xd0e0,0x8fa1cf,0, 0,0,0,0,0,0,0xbda4,0xd0ed, /* '俠','信',0,'俣','俤','俥','俦',0, 0,0,0,0,0,0,'修','俯', */
	/* 4ff0 */ 0,0xaea1,0x8fa1d7,0xc7d0,0,0xc9b6,0xd0e8,0, 0xcaf0,0,0xb2b6,0,0,0,0xd0ec,0, /* 0,'俱','俲','俳',0,'俵','俶',0, '俸',0,'俺',0,0,0,'俾',0, */
	/* 5000 */ 0x8fa1d8,0xaebb,0xaebc,0,0,0xd0e6,0xd0ef,0, 0,0xc1d2,0,0xb8c4,0,0xc7dc,0xaebd,0xe0c7, /* '倀','倁','倂',0,0,'倅','倆',0, 0,'倉',0,'個',0,'倍','倎','倏', */
	/* 5010 */ 0x8fa1d9,0xd0ee,0xc5dd,0x8fa1da,0xd0e3,0,0xb8f6,0, 0xaebe,0xb8f5,0xd0e1,0,0x8fa1db,0,0x8fa1dc,0xbcda, /* '倐','們','倒','倓','倔',0,'倖',0, '倘','候','倚',0,'倜',0,'倞','借', */
	/* 5020 */ 0,0xd0e9,0x8fa1dd,0xcaef,0xc3cd,0xd0e5,0xb7f1,0xaebf, 0xd0e2,0xd0ea,0xd0e4,0xced1,0xd0eb,0xcfc1,0xaec0,0, /* 0,'倡','倢','倣','値','倥','倦','倧', '倨','倩','倪','倫','倬','倭','倮',0, */
	/* 5030 */ 0,0,0,0,0,0,0xb6e6,0, 0,0xb7f0,0,0xaec2,0,0,0,0, /* 0,0,0,0,0,0,'倶',0, 0,'倹',0,'倻',0,0,0,0, */
	/* 5040 */ 0xaec1,0xaec3,0x8fa1df,0xd0f0,0,0,0x8fa1e0,0xd0f1, 0xd0f5,0xb0ce,0,0,0,0,0x8fa1e1,0xcad0, /* '偀','偁','偂','偃',0,0,'偆','假', '偈','偉',0,0,0,0,'偎','偏', */
	/* 5050 */ 0xd0f4,0,0,0x8fa1e2,0,0xd0f3,0xd0f7,0x8fa1e3, 0,0,0xd0f6,0,0xc4e4,0,0,0, /* '偐',0,0,'偓',0,'偕','偖','偗', 0,0,'做',0,'停',0,0,0, */
	/* 5060 */ 0,0,0,0x8fa1e4,0,0xb7f2,0x8fa1e5,0, 0,0,0x8fa1e6,0,0xd0f8,0,0,0, /* 0,0,0,'偣',0,'健','偦',0, 0,0,'偪',0,'偬',0,0,0, */
	/* 5070 */ 0x8fa1e7,0,0xbcc5,0,0xc2a6,0xc4e5,0xb6f6,0, 0xd0f9,0,0,0,0,0xb5b6,0,0, /* '偰',0,'偲',0,'側','偵','偶',0, '偸',0,0,0,0,'偽',0,0, */
	/* 5080 */ 0xd0fa,0,0,0,0,0xd0fc,0,0, 0x8fa1e9,0,0,0,0,0xcbb5,0,0, /* '傀',0,0,0,0,'傅',0,0, '傈',0,0,0,0,'傍',0,0, */
	/* 5090 */ 0,0xb7e6,0x8fa1ea,0x8fa1eb,0xaec4,0x8fa1ec,0x8fa1ed,0, 0xbbb1,0xc8f7,0xd0fb,0,0x8fa1ee,0,0,0, /* 0,'傑','傒','傓','傔','傕','傖',0, '傘','備','傚',0,'傜',0,0,0, */
	/* 50a0 */ 0,0,0,0x8fa1e8,0,0,0,0, 0,0,0x8fa1ef,0,0xbac5,0xcdc3,0,0, /* 0,0,0,'傣',0,0,0,0, 0,0,'傪',0,'催','傭',0,0, */
	/* 50b0 */ 0,0x8fa1f1,0xd0fe,0xd1a3,0xd0fd,0xbac4,0,0xbdfd, 0,0,0x8fa1f2,0x8fa1f3,0,0,0xb7b9,0, /* 0,'傱','傲','傳','傴','債',0,'傷', 0,0,'傺','傻',0,0,'傾',0, */
	/* 50c0 */ 0,0,0xd1a4,0,0x8fa1f4,0xb6cf,0,0x8fa1f5, 0,0xd1a1,0xd1a2,0,0xaec5,0xc6af,0x8fa1f8,0xc1fc, /* 0,0,'僂',0,'僄','僅',0,'僇', 0,'僉','僊',0,'僌','働','僎','像', */
	/* 50d0 */ 0xaec7,0xb6a3,0,0,0x8fa1fa,0xcbcd,0xd1a5,0, 0,0x8fa1fb,0xcebd,0,0,0,0xd1a6,0, /* '僐','僑',0,0,'僔','僕','僖',0, 0,'僙','僚',0,0,0,'僞',0, */
	/* 50e0 */ 0,0x8fa1fc,0,0xd1a9,0,0xd1a7,0xaec8,0xc1ce, 0,0x8fa1fd,0,0,0,0xd1a8,0xd1aa,0, /* 0,'僡',0,'僣',0,'僥','僦','僧', 0,'僩',0,0,0,'僭','僮',0, */
	/* 50f0 */ 0,0,0xaec6,0x8fa1f6,0,0xd1ac,0,0, 0,0xd1ab,0,0xcac8,0,0,0,0, /* 0,0,'僲','僳',0,'僵',0,0, 0,'價',0,'僻',0,0,0,0, */
	/* 5100 */ 0xb5b7,0xd1ae,0xd1af,0xaecb,0xb2af,0,0xaeca,0, 0x8fa3a1,0xd1ad,0,0xaecc,0,0,0,0, /* '儀','儁','儂','儃','億',0,'儆',0, '儈','儉',0,'儋',0,0,0,0, */
	/* 5110 */ 0,0,0xbcf4,0,0xd1b2,0xd1b1,0xd1b0,0x8fa3a3, 0xd0d6,0,0xd1b3,0x8fa3a4,0,0,0xaecd,0xbdfe, /* 0,0,'儒',0,'儔','儕','儖','儗', '儘',0,'儚','儛',0,0,'儞','償', */
	/* 5120 */ 0,0xd1b4,0,0,0,0,0,0, 0,0,0xcda5,0,0,0,0,0, /* 0,'儡',0,0,0,0,0,0, 0,0,'優',0,0,0,0,0, */
	/* 5130 */ 0,0,0xccd9,0,0,0xaece,0,0xd1b6, 0,0,0xd1b5,0xd1b8,0xd1b7,0,0,0xd1b9, /* 0,0,'儲',0,0,'儵',0,'儷', 0,0,'儺','儻','儼',0,0,'儿', */
	/* 5140 */ 0xd1ba,0xb0f4,0,0xb8b5,0xb7bb,0xbdbc,0xc3fb,0xb6a4, 0xc0e8,0xb8f7,0xaecf,0xb9ee,0xd1bc,0xccc8,0xc5c6,0, /* '兀','允',0,'元','兄','充','兆','兇', '先','光','兊','克','兌','免','兎',0, */
	/* 5150 */ 0xbbf9,0,0xd1bb,0,0xd1bd,0xaed1,0,0xaed2, 0,0,0xc5de,0,0xb3f5,0,0,0, /* '児',0,'兒',0,'兔','兕',0,'兗', 0,0,'党',0,'兜',0,0,0, */
	/* 5160 */ 0x8fa3a6,0,0xd1be,0,0,0xc6fe,0,0, 0xc1b4,0xd1c0,0xd1c1,0xc8ac,0xb8f8,0xcfbb,0xd1c2,0, /* '兠',0,'兢',0,0,'入',0,0, '全','兩','兪','八','公','六','兮',0, */
	/* 5170 */ 0,0xb6a6,0,0x8fa3a8,0,0xcabc,0xc2b6,0xb6f1, 0xc5b5,0,0,0x8ff4f4,0xb7f3,0,0,0, /* 0,'共',0,'关',0,'兵','其','具', '典',0,0,'养','兼',0,0,0, */
	/* 5180 */ 0xd1c3,0,0xd1c4,0x8fa3a9,0,0xc6e2,0xb1df,0, 0,0xd1c7,0xbafd,0x8fa3aa,0xd1c6,0xbac6,0,0xd1c8, /* '冀',0,'冂','冃',0,'内','円',0, 0,'冉','冊','冋','册','再',0,'冏', */
	/* 5190 */ 0xe6ee,0xd1c9,0xcbc1,0xd1ca,0,0xd1cb,0xd1cc,0xbee9, 0x8fa3ac,0xbccc,0,0,0,0xaed4,0,0, /* '冐','冑','冒','冓',0,'冕','冖','冗', '冘','写',0,0,0,'冝',0,0, */
	/* 51a0 */ 0xb4a7,0,0xd1cf,0x8fa3ad,0xd1cd,0xccbd,0xd1ce,0, 0xc9da,0xd1d0,0xd1d1,0xd1d2,0xc5df,0x8fa3ae,0,0, /* '冠',0,'冢','冣','冤','冥','冦',0, '冨','冩','冪','冫','冬','冭',0,0, */
	/* 51b0 */ 0xd1d6,0xd1d4,0xd1d5,0xd1d3,0xbae3,0xd1d7,0xccea,0xcee4, 0,0,0,0,0x8fa3b0,0xd1d8,0,0, /* '冰','冱','冲','决','冴','况','冶','冷', 0,0,0,0,'冼','冽',0,0, */
	/* 51c0 */ 0,0,0,0xaed5,0xc0a8,0xd1d9,0xbdda,0, 0,0xd1da,0xaed6,0xc3fc,0xcebf,0xc5e0,0,0, /* 0,0,0,'凃','凄','凅','准',0, 0,'凉','凊','凋','凌','凍',0,0, */
	/* 51d0 */ 0,0,0,0,0,0,0xd2c5,0, 0,0,0,0xd1db,0xf4a5,0xb6c5,0xaed7,0, /* 0,0,0,0,0,0,'凖',0, 0,0,0,'凛','凜','凝','凞',0, */
	/* 51e0 */ 0xd1dc,0xcbde,0xaed8,0,0,0,0xbde8,0xc2fc, 0,0xd1de,0xc6e4,0,0,0xd1df,0xaed9,0, /* '几','凡','凢',0,0,0,'処','凧', 0,'凩','凪',0,0,'凭','凮',0, */
	/* 51f0 */ 0xd1e0,0xb3ae,0,0x8fa3b3,0x8fa3b4,0xd1e1,0xb6a7,0, 0xc6cc,0xb1fa,0xbdd0,0,0,0xc8a1,0xd1e2,0, /* '凰','凱',0,'凳','凴','凵','凶',0, '凸','凹','出',0,0,'函','凾',0, */
	/* 5200 */ 0xc5e1,0xaeda,0x8fa3b5,0xbfcf,0xd1e3,0,0xcaac,0xc0da, 0xb4a2,0,0xb4a9,0xd1e4,0,0,0xd1e6,0, /* '刀','刁','刂','刃','刄',0,'分','切', '刈',0,'刊','刋',0,0,'刎',0, */
	/* 5210 */ 0,0xb7ba,0x8fa3b6,0xaedc,0xd1e5,0xaedd,0x8fa3b7,0xcef3, 0,0,0,0,0,0xbde9,0,0, /* 0,'刑','划','刓','刔','刕','刖','列', 0,0,0,0,0,'初',0,0, */
	/* 5220 */ 0,0,0,0,0xc8bd,0xcacc,0,0xd1e7, 0,0xcdf8,0xd1e8,0,0,0,0xd1e9,0, /* 0,0,0,0,'判','別',0,'刧', 0,'利','刪',0,0,0,'刮',0, */
	/* 5230 */ 0xc5fe,0,0,0xd1ea,0,0,0xc0a9,0xbafe, 0xb7f4,0xd1eb,0xbbc9,0xb9ef,0,0,0,0, /* '到',0,0,'刳',0,0,'制','刷', '券','刹','刺','刻',0,0,0,0, */
	/* 5240 */ 0,0,0,0xc4e6,0xd1ed,0,0,0xc2a7, 0,0xaede,0xbaef,0xd1ee,0xd1ef,0xc1b0,0,0xd1ec, /* 0,0,0,'剃','剄',0,0,'則', 0,'剉','削','剋','剌','前',0,'剏', */
	/* 5250 */ 0,0,0,0,0xd1f1,0x8fa3b9,0xcbb6,0xaedf, 0,0,0,0xb9e4,0x8fa3ba,0xaffe,0xd1f0,0, /* 0,0,0,0,'剔','剕','剖','剗', 0,0,0,'剛','剜','剝','剞',0, */
	/* 5260 */ 0,0xaee0,0,0xb7f5,0xbade,0xc7ed,0,0, 0,0xd1f4,0xd1f2,0,0x8fa3bb,0,0,0xc9fb, /* 0,'剡',0,'剣','剤','剥',0,0, 0,'剩','剪',0,'剬',0,0,'副', */
	/* 5270 */ 0xbeea,0xd1fb,0xb3e4,0xd1f5,0xd1f3,0xc1cf,0,0x8fa3bc, 0,0,0,0,0,0xd1f7,0,0xd1f6, /* '剰','剱','割','剳','剴','創',0,'剷', 0,0,0,0,0,'剽',0,'剿', */
	/* 5280 */ 0,0,0x8fa3be,0xb3c4,0x8fa3bd,0,0,0xb7e0, 0xd1fc,0xcead,0,0,0,0xd1f8,0,0, /* 0,0,'劂','劃','劄',0,0,'劇', '劈','劉',0,0,0,'劍',0,0, */
	/* 5290 */ 0,0xd1fd,0xd1fa,0xaee1,0xd1f9,0,0,0, 0x8fa3c0,0,0,0xcecf,0,0,0,0xb8f9, /* 0,'劑','劒','劓','劔',0,0,0, '劘',0,0,'力',0,0,0,'功', */
	/* 52a0 */ 0xb2c3,0,0,0xcef4,0x8fa3c2,0,0x8fa3c3,0, 0,0xbdf5,0xc5d8,0xb9e5,0xd2a2,0xd2a3,0,0x8fa3c4, /* '加',0,0,'劣','劤',0,'劦',0, 0,'助','努','劫','劬','劭',0,'劯', */
	/* 52b0 */ 0,0xcee5,0,0,0xcfab,0xd2a5,0,0, 0,0xb8fa,0x8fa3c5,0x8fa3c6,0xd2a4,0,0xb3af,0, /* 0,'励',0,0,'労','劵',0,0, 0,'効','劺','劻','劼',0,'劾',0, */
	/* 52c0 */ 0,0xd2a6,0,0xcbd6,0,0xc4bc,0,0xcda6, 0xaee2,0xcad9,0x8fa3c7,0,0xaee4,0xd2a7,0,0, /* 0,'勁',0,'勃',0,'勅',0,'勇', '勈','勉','勊',0,'勌','勍',0,0, */
	/* 52d0 */ 0xaee5,0x8fa3c9,0xf0d5,0,0,0xc6b0,0xaee6,0xd2a8, 0xb4aa,0xccb3,0,0xaee7,0,0xbea1,0xd2a9,0xcae7, /* '勐','勑','勒',0,0,'動','勖','勗', '勘','務',0,'勛',0,'勝','勞','募', */
	/* 52e0 */ 0xd2ad,0,0xc0aa,0xd2aa,0xb6d0,0,0xd2ab,0xb4ab, 0,0,0,0,0,0,0,0, /* '勠',0,'勢','勣','勤',0,'勦','勧', 0,0,0,0,0,0,0,0, */
	/* 52f0 */ 0xaee9,0,0xb7ae,0xd2ae,0,0xd2af,0,0x8fa3cb, 0xd2b0,0xd2b1,0xbcdb,0xaeea,0,0,0xb8fb,0xccde, /* '勰',0,'勲','勳',0,'勵',0,'勷', '勸','勹','勺','勻',0,0,'勾','勿', */
	/* 5300 */ 0xaeeb,0xcce8,0xc6f7,0,0,0xcaf1,0xd2b2,0xaeec, 0xd2b3,0,0x8fa3cc,0x8fa3cd,0,0xd2b5,0,0xd2b7, /* '匀','匁','匂',0,0,'包','匆','匇', '匈',0,'匊','匋',0,'匍',0,'匏', */
	/* 5310 */ 0xd2b6,0,0,0,0,0xd2b8,0xb2bd,0xcbcc, 0,0xbafc,0xd2b9,0,0xaeed,0xc1d9,0,0, /* '匐',0,0,0,0,'匕','化','北', 0,'匙','匚',0,'匜','匝',0,0, */
	/* 5320 */ 0xbea2,0xb6a9,0,0xd2ba,0x8fa3ce,0,0,0, 0,0,0xc8db,0,0,0,0,0xd2bb, /* '匠','匡',0,'匣','匤',0,0,0, 0,0,'匪',0,0,0,0,'匯', */
	/* 5330 */ 0,0xd2bc,0,0xd2bd,0,0x8fa3cf,0,0, 0xd2be,0xc9a4,0xb6e8,0xb0e5,0,0,0x8fa3d0,0xc6bf, /* 0,'匱',0,'匳',0,'匵',0,0, '匸','匹','区','医',0,0,'匾','匿', */
	/* 5340 */ 0xd2bf,0xbdbd,0x8fa3d1,0xc0e9,0,0xd2c1,0xd2c0,0xbea3, 0xb8e1,0xd2c3,0xc8be,0,0,0xd2c4,0,0, /* '區','十','卂','千',0,'卅','卆','升', '午','卉','半',0,0,'卍',0,0, */
	/* 5350 */ 0,0xc8dc,0xc2b4,0xc2ee,0xb6a8,0,0,0xc6ee, 0xc3b1,0,0xc7ee,0,0xcbce,0,0xd2c6,0, /* 0,'卑','卒','卓','協',0,0,'南', '単',0,'博',0,'卜',0,'卞',0, */
	/* 5360 */ 0xc0ea,0xaeef,0,0xaef0,0,0,0xb7b5,0x8fa3d4, 0,0xd2c7,0,0,0x8fa3d5,0,0xd2c8,0xb1ac, /* '占','卡',0,'卣',0,0,'卦','卧', 0,'卩',0,0,'卬',0,'卮','卯', */
	/* 5370 */ 0xb0f5,0xb4ed,0,0xc2a8,0xb5d1,0xcdf1,0,0xd2cb, 0xb2b7,0,0x8fa3d6,0xd2ca,0,0xaef1,0,0xb6aa, /* '印','危',0,'即','却','卵',0,'卷', '卸',0,'卺','卻',0,'卽',0,'卿', */
	/* 5380 */ 0,0,0xd2cc,0,0xccf1,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'厂',0,'厄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5390 */ 0,0,0,0xaef2,0,0,0xd2cd,0, 0xced2,0,0xb8fc,0,0,0xaef3,0,0xb8b6, /* 0,0,0,'厓',0,0,'厖',0, '厘',0,'厚',0,0,'厝',0,'原', */
	/* 53a0 */ 0xd2ce,0,0,0,0x8fa3d7,0xd2d0,0xd2cf,0, 0xbfdf,0xb1b9,0,0,0,0xb1de,0xd2d1,0, /* '厠',0,0,0,'厤','厥','厦',0, '厨','厩',0,0,0,'厭','厮',0, */
	/* 53b0 */ 0xd2d2,0,0xaef4,0xb8b7,0x8fa3d8,0,0xd2d3,0x8fa3da, 0,0,0,0xb5ee,0,0,0,0, /* '厰',0,'厲','厳','厴',0,'厶','厷', 0,0,0,'去',0,0,0,0, */
	/* 53c0 */ 0x8fa3db,0,0xbbb2,0xd2d4,0,0,0,0, 0xcbf4,0xbab5,0xb5da,0xcda7,0xc1d0,0xc8bf,0xbcfd,0, /* '叀',0,'参','參',0,0,0,0, '又','叉','及','友','双','反','収',0, */
	/* 53d0 */ 0,0,0,0,0xbdc7,0x8fa3df,0xbce8,0xbcf5, 0,0xbdf6,0x8fa3e0,0xc8c0,0,0,0,0xd2d7, /* 0,0,0,0,'叔','叕','取','受', 0,'叙','叚','叛',0,0,0,'叟', */
	/* 53e0 */ 0,0xb1c3,0xc1d1,0xb8fd,0xb8c5,0xb6e7,0,0, 0xd2db,0xc3a1,0xc2fe,0xb6ab,0xbea4,0xd2dc,0xd2da,0xb2c4, /* 0,'叡','叢','口','古','句',0,0, '叨','叩','只','叫','召','叭','叮','可', */
	/* 53f0 */ 0xc2e6,0xbcb8,0xbbcb,0xb1a6,0x8fa3e2,0x8fa3e3,0xb3f0,0xb9e6, 0xbbca,0,0xd2dd,0,0,0,0,0, /* '台','叱','史','右','叴','叵','叶','号', '司',0,'叺',0,0,0,0,0, */
	/* 5400 */ 0,0xd2de,0,0xb5c9,0xb3c6,0,0,0, 0xb9e7,0xb5c8,0xc4df,0xb1a5,0xc6b1,0xccbe,0xb9a1,0xcdf9, /* 0,'吁',0,'吃','各',0,0,0, '合','吉','吊','吋','同','名','后','吏', */
	/* 5410 */ 0xc5c7,0xb8fe,0xaef5,0,0,0,0,0, 0,0,0,0xb7af,0,0xd2e7,0xcffe,0xb6e3, /* '吐','向','吒',0,0,0,0,0, 0,0,0,'君',0,'吝','吞','吟', */
	/* 5420 */ 0xcbca,0,0,0,0x8fa3e5,0,0xc8dd,0xaef6, 0x8fa3e6,0xd2e6,0,0xb4de,0xd2e1,0xd2e2,0xd2e4,0, /* '吠',0,0,0,'吤',0,'否','吧', '吨','吩',0,'含','听','吭','吮',0, */
	/* 5430 */ 0,0,0,0,0,0,0xd2e5,0, 0xb5db,0xbfe1,0,0xcaad,0xd2e3,0xd2df,0xb8e3,0, /* 0,0,0,0,0,0,'吶',0, '吸','吹',0,'吻','吼','吽','吾',0, */
	/* 5440 */ 0xd2e0,0,0xcfa4,0x8fa3e8,0,0,0xcaf2,0, 0xc4e8,0xb8e2,0xb9f0,0,0,0xaef7,0xd2e8,0, /* '呀',0,'呂','呃',0,0,'呆',0, '呈','呉','告',0,0,'呍','呎',0, */
	/* 5450 */ 0,0xc6dd,0,0,0,0x8fa3e4,0,0, 0,0,0,0,0,0,0,0xd2ec, /* 0,'呑',0,0,0,'呕',0,0, 0,0,0,0,0,0,0,'呟', */
	/* 5460 */ 0,0,0x8fa3e9,0,0,0,0x8fa3ea,0, 0xbcfe,0,0xbcf6,0xaef9,0x8fa3eb,0,0,0, /* 0,0,'呢',0,0,0,'呦',0, '周',0,'呪','呫','呬',0,0,0, */
	/* 5470 */ 0xd2ef,0xd2ed,0,0xcca3,0xaefa,0xd2ea,0xd2f3,0xd2ee, 0,0,0,0xd2f1,0xb8c6,0xccbf,0,0xaefb, /* '呰','呱',0,'味','呴','呵','呶','呷', 0,0,0,'呻','呼','命',0,'呿', */
	/* 5480 */ 0xd2f2,0,0,0,0xd2f4,0,0xd2f6,0, 0xaefc,0,0x8fa3ec,0xbaf0,0xcfc2,0x8fa3ed,0xd2eb,0xd2e9, /* '咀',0,0,0,'咄',0,'咆',0, '咈',0,'咊','咋','和','咍','咎','咏', */
	/* 5490 */ 0xd2f5,0,0xd2f0,0,0,0x8fa3ee,0xaefd,0, 0,0,0,0,0xaef8,0,0,0, /* '咐',0,'咒',0,0,'咕','咖',0, 0,0,0,0,'咜',0,0,0, */
	/* 54a0 */ 0x8fa3ef,0xaefe,0xd2f8,0,0xd3a3,0xd2fa,0x8fa3f0,0, 0xd2fe,0xafa1,0,0xd3a1,0xd2fb,0x8fa3f1,0x8fa3f2,0xd3be, /* '咠','咡','咢',0,'咤','咥','咦',0, '咨','咩',0,'咫','咬','咭','咮','咯', */
	/* 54b0 */ 0,0,0xbae9,0xb3b1,0,0,0,0x8fa3f3, 0xd2f9,0,0x8fa3f4,0,0xd3a5,0xb0f6,0xd3a4,0x8fa3f5, /* 0,0,'咲','咳',0,0,0,'咷', '咸',0,'咺',0,'咼','咽','咾','咿', */
	/* 54c0 */ 0xb0a5,0xc9ca,0xd3a2,0x8fa3f6,0xd2fc,0,0xafa2,0xd2f7, 0xd2fd,0xbac8,0,0,0,0,0,0, /* '哀','品','哂','哃','哄',0,'哆','哇', '哈','哉',0,0,0,0,0,0, */
	/* 54d0 */ 0,0,0,0,0,0,0,0, 0xd3a6,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '哘',0,0,0,0,0,0,0, */
	/* 54e0 */ 0,0xb0f7,0xd3af,0,0,0xd3a7,0xd3a8,0, 0xbea5,0xcbe9,0,0,0x8fa3f8,0xd3ad,0xd3ac,0x8fa3f9, /* 0,'員','哢',0,0,'哥','哦',0, '哨','哩',0,0,'哬','哭','哮','哯', */
	/* 54f0 */ 0,0x8fa3fa,0xc5af,0x8fa3fb,0,0,0,0, 0,0,0xd3ae,0,0,0xd3ab,0,0xafa3, /* 0,'哱','哲','哳',0,0,0,0, 0,0,'哺',0,0,'哽',0,'哿', */
	/* 5500 */ 0x8fa3fc,0x8fa3fd,0,0,0xb1b4,0,0xbab6,0xbfb0, 0,0x8fa3fe,0,0,0,0,0xafa4,0xd3a9, /* '唀','唁',0,0,'唄',0,'唆','唇', 0,'唉',0,0,0,0,'唎','唏', */
	/* 5510 */ 0xc5e2,0,0,0,0xd3aa,0,0xb0a2,0, 0,0,0,0,0,0,0,0, /* '唐',0,0,0,'唔',0,'唖',0, 0,0,0,0,0,0,0,0, */
	/* 5520 */ 0,0,0,0,0,0,0,0, 0,0,0,0xafa5,0,0,0xd3b4,0xcda3, /* 0,0,0,0,0,0,0,0, 0,0,0,'唫',0,0,'售','唯', */
	/* 5530 */ 0,0xbea7,0,0xd3ba,0,0xafa6,0,0, 0xd3b9,0xd3b0,0,0,0x8fa4a1,0,0xc2c3,0, /* 0,'唱',0,'唳',0,'唵',0,0, '唸','唹',0,0,'唼',0,'唾',0, */
	/* 5540 */ 0xd3b1,0x8fa4a2,0,0,0xc2ef,0xd3b6,0xbea6,0x8fa4a4, 0,0,0x8fa4a5,0,0xd3b3,0,0,0xcce4, /* '啀','啁',0,0,'啄','啅','商','啇', 0,0,'啊',0,'啌',0,0,'問', */
	/* 5550 */ 0xafa7,0,0,0xb7bc,0,0,0xd3b7,0xd3b8, 0,0,0,0,0xd3b5,0xd3bb,0xafa8,0, /* '啐',0,0,'啓',0,0,'啖','啗', 0,0,0,0,'啜','啝','啞',0, */
	/* 5560 */ 0x8fa4a7,0x8fa4a8,0,0xd3b2,0x8fa4a9,0,0,0, 0,0,0,0,0,0,0,0, /* '啠','啡',0,'啣','啤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5570 */ 0,0,0,0,0,0,0,0, 0,0,0,0xd3c1,0xd3c6,0x8fa4ab,0xd3c2,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'啻','啼','啽','啾',0, */
	/* 5580 */ 0xd3bd,0xafa9,0x8fa4ac,0xd3c7,0xc1b1,0,0xafaa,0xd3c9, 0x8fa4ad,0xb9a2,0xd3bf,0xc3fd,0,0,0xafab,0, /* '喀','喁','喂','喃','善',0,'喆','喇', '喈','喉','喊','喋',0,0,'喎',0, */
	/* 5590 */ 0,0x8fa4ae,0,0,0,0,0,0, 0xd3c3,0xd3bc,0xb4ad,0,0xb4ee,0xb3e5,0xd3c4,0xd3c0, /* 0,'喑',0,0,0,0,0,0, '喘','喙','喚',0,'喜','喝','喞','喟', */
	/* 55a0 */ 0,0,0,0,0,0,0,0xb7f6, 0xd3ca,0xd3c8,0xc1d3,0xb5ca,0xb6ac,0xafad,0xd3c5,0, /* 0,0,0,0,0,0,0,'喧', '喨','喩','喪','喫','喬','喭','單',0, */
	/* 55b0 */ 0xb6f4,0,0,0,0,0,0xb1c4,0, 0,0,0,0,0,0,0,0x8fa4b3, /* '喰',0,0,0,0,0,'営',0, 0,0,0,0,0,0,0,'喿', */
	/* 55c0 */ 0,0,0,0,0xd3ce,0xd3cc,0,0xd4a7, 0,0x8fa4b4,0,0,0x8fa4b5,0,0xafae,0, /* 0,0,0,0,'嗄','嗅',0,'嗇', 0,'嗉',0,0,'嗌',0,'嗎',0, */
	/* 55d0 */ 0,0x8fa4b6,0x8fa4b0,0,0xd3d1,0,0,0, 0,0,0xd3cb,0,0xd3cf,0x8fa4b7,0,0xd3cd, /* 0,'嗑','嗒',0,'嗔',0,0,0, 0,0,'嗚',0,'嗜','嗝',0,'嗟', */
	/* 55e0 */ 0,0,0x8fa4b9,0xbbcc,0xd3d0,0,0,0, 0,0x8fa4bb,0,0,0,0,0,0, /* 0,0,'嗢','嗣','嗤',0,0,0, 0,'嗩',0,0,0,0,0,0, */
	/* 55f0 */ 0,0,0,0,0,0,0,0xd3d3, 0,0xd3d8,0,0,0,0xd3d6,0xd3d5,0, /* 0,0,0,0,0,0,0,'嗷', 0,'嗹',0,0,0,'嗽','嗾',0, */
	/* 5600 */ 0,0,0,0,0,0,0xc3b2,0x8fa4be, 0xafb0,0xb2c5,0,0,0,0,0xafb1,0, /* 0,0,0,0,0,0,'嘆','嘇', '嘈','嘉',0,0,0,0,'嘎',0, */
	/* 5610 */ 0x8fa4bf,0,0,0,0xd3d2,0,0xd3d4,0xbea8, 0xb1b3,0,0,0xd3d7,0,0,0,0, /* '嘐',0,0,0,'嘔',0,'嘖','嘗', '嘘',0,0,'嘛',0,0,0,0, */
	/* 5620 */ 0,0,0,0,0,0,0,0, 0x8fa4bc,0xb2de,0,0,0,0,0,0xd3e2, /* 0,0,0,0,0,0,0,0, '嘨','嘩',0,0,0,0,0,'嘯', */
	/* 5630 */ 0x8fa4c0,0xbefc,0xd3de,0,0xd3dc,0,0xd3dd,0x8fa4c1, 0xd3df,0,0,0xafb2,0,0x8fa4c3,0,0x8fa4c4, /* '嘰','嘱','嘲',0,'嘴',0,'嘶','嘷', '嘸',0,0,'嘻',0,'嘽',0,'嘿', */
	/* 5640 */ 0x8fa4c5,0,0xb1bd,0,0,0,0,0x8fa4c6, 0,0xafb3,0,0,0xc1b9,0,0xd3d9,0, /* '噀',0,'噂',0,0,0,0,'噇', 0,'噉',0,0,'噌',0,'噎',0, */
	/* 5650 */ 0xd3da,0,0,0xf4a7,0,0,0,0, 0,0,0,0xb3fa,0,0,0x8fa4c7,0, /* '噐',0,0,'噓',0,0,0,0, 0,0,0,'噛',0,0,'噞',0, */
	/* 5660 */ 0x8fa4c8,0,0,0,0xd3e1,0,0xafb5,0, 0xb4ef,0,0xd3e4,0xd3e0,0xd3e3,0x8fa4c9,0,0xafb7, /* '噠',0,0,0,'噤',0,'噦',0, '器',0,'噪','噫','噬','噭',0,'噯', */
	/* 5670 */ 0,0xafb8,0xafb9,0,0xcaae,0,0xafb4,0, 0xc6d5,0,0xc8b8,0,0,0,0,0, /* 0,'噱','噲',0,'噴',0,'噶',0, '噸',0,'噺',0,0,0,0,0, */
	/* 5680 */ 0xd3e6,0,0,0,0,0,0xd3e5,0xb3c5, 0x8fa4cb,0,0xd3e7,0,0x8fa4cc,0,0,0xd3ea, /* '嚀',0,0,0,0,0,'嚆','嚇', '嚈',0,'嚊',0,'嚌',0,0,'嚏', */
	/* 5690 */ 0,0,0,0,0xd3e9,0x8fa4cd,0,0, 0,0xafba,0x8fa4ce,0,0,0x8fa4cf,0xafbb,0, /* 0,0,0,0,'嚔','嚕',0,0, 0,'嚙','嚚',0,0,'嚝','嚞',0, */
	/* 56a0 */ 0xd3e8,0,0xc7b9,0,0,0xd3eb,0,0, 0x8fa4d0,0xafbc,0,0,0xafbd,0x8fa4d1,0xd3ec,0, /* '嚠',0,'嚢',0,0,'嚥',0,0, '嚨','嚩',0,0,'嚬','嚭','嚮',0, */
	/* 56b0 */ 0,0,0x8fa4d2,0xafbe,0xd3ee,0,0xd3ed,0, 0,0,0,0,0xd3f0,0,0,0, /* 0,0,'嚲','嚳','嚴',0,'嚶',0, 0,0,0,0,'嚼',0,0,0, */
	/* 56c0 */ 0xd3f3,0xd3f1,0xd3ef,0xd3f2,0,0x8fa4d3,0,0, 0xd3f4,0xafbf,0xafc0,0,0,0x8fa4d4,0xd3f5,0, /* '囀','囁','囂','囃',0,'囅',0,0, '囈','囉','囊',0,0,'囍','囎',0, */
	/* 56d0 */ 0,0xd3f6,0,0xd3f7,0,0,0,0xd3f8, 0xd1c5,0,0xbcfc,0xbbcd,0,0,0xb2f3,0x8fa4d5, /* 0,'囑',0,'囓',0,0,0,'囗', '囘',0,'囚','四',0,0,'回','囟', */
	/* 56e0 */ 0xb0f8,0,0,0xc3c4,0,0,0,0, 0x8fa4d6,0,0,0,0,0,0xd3f9,0, /* '因',0,0,'団',0,0,0,0, '囨',0,0,0,0,0,'囮',0, */
	/* 56f0 */ 0xbaa4,0,0xb0cf,0xbfde,0,0,0x8fa4d7,0x8fa4d8, 0,0xd3fa,0xb8c7,0,0,0xb9f1,0,0xd3fc, /* '困',0,'囲','図',0,0,'囶','囷', 0,'囹','固',0,0,'国',0,'囿', */
	/* 5700 */ 0xd3fb,0,0,0xcae0,0xd3fd,0,0,0, 0xd4a1,0xd3fe,0xafc1,0xd4a2,0,0xd4a3,0,0xb7f7, /* '圀',0,0,'圃','圄',0,0,0, '圈','圉','圊','國',0,'圍',0,'圏', */
	/* 5710 */ 0,0,0xb1e0,0xd4a4,0,0x8fa4da,0xd4a6,0, 0xd4a5,0,0,0,0xd4a8,0,0,0xc5da, /* 0,0,'園','圓',0,'圕','圖',0, '團',0,0,0,'圜',0,0,'土', */
	/* 5720 */ 0,0xafc3,0,0x8fa4db,0,0,0xd4a9,0xb0b5, 0xbadf,0x8fa4dd,0,0,0,0xb7bd,0,0xafc4, /* 0,'圡',0,'圣',0,0,'圦','圧', '在','圩',0,0,0,'圭',0,'圯', */
	/* 5730 */ 0xc3cf,0,0,0xafc5,0xafc6,0,0,0xd4aa, 0xd4ab,0,0,0xd4ad,0,0,0,0, /* '地',0,0,'圳','圴',0,0,'圷', '圸',0,0,'圻',0,0,0,0, */
	/* 5740 */ 0xd4ae,0,0xbae4,0,0,0x8fa4df,0x8fa4e0,0xb6d1, 0,0,0xcbb7,0,0x8fa4e1,0x8fa4e2,0xd4ac,0xd4af, /* '址',0,'坂',0,0,'坅','坆','均', 0,0,'坊',0,'坌','坍','坎','坏', */
	/* 5750 */ 0xbac1,0xb9a3,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '坐','坑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5760 */ 0,0xd4b3,0,0,0xbaa5,0,0xc3b3,0, 0x8fa4e4,0xd4b0,0xc4da,0,0,0,0,0x8fa4e5, /* 0,'坡',0,0,'坤',0,'坦',0, '坨','坩','坪',0,0,0,0,'坯', */
	/* 5770 */ 0xafc7,0,0,0x8fa4e6,0x8fa4e7,0x8fa4e8,0,0xafc8, 0,0,0,0x8fa4e9,0xafc9,0,0,0xd4b4, /* '坰',0,0,'坳','坴','坵',0,'坷', 0,0,0,'坻','坼',0,0,'坿', */
	/* 5780 */ 0,0,0xbfe2,0,0,0,0,0, 0xd4b2,0xd4b5,0,0xb7bf,0,0,0,0, /* 0,0,'垂',0,0,0,0,0, '垈','垉',0,'型',0,0,0,0, */
	/* 5790 */ 0,0,0,0xd4b6,0,0,0,0, 0,0,0x8fa4ed,0,0xafca,0x8fa4ee,0x8fa4ef,0, /* 0,0,0,'垓',0,0,0,0, 0,0,'垚',0,'垜','垝','垞',0, */
	/* 57a0 */ 0xd4b7,0,0xb9a4,0xb3c0,0xd4b9,0,0,0, 0x8fa4f0,0,0xd4ba,0,0x8fa4ec,0,0,0, /* '垠',0,'垢','垣','垤',0,0,0, '垨',0,'垪',0,'垬',0,0,0, */
	/* 57b0 */ 0xd4bb,0,0,0xd4b8,0,0,0,0, 0xafcd,0,0,0,0,0,0,0, /* '垰',0,0,'垳',0,0,0,0, '垸',0,0,0,0,0,0,0, */
	/* 57c0 */ 0xd4b1,0,0,0xd4bc,0,0,0xd4bd,0xafce, 0xafcf,0,0,0xcbe4,0x8fa4f3,0,0xbeeb,0xafd0, /* '埀',0,0,'埃',0,0,'埆','埇', '埈',0,0,'埋','埌',0,'城','埏', */
	/* 57d0 */ 0,0,0xd4bf,0xd4c0,0xd4be,0,0xd4c2,0x8fa4f1, 0,0,0,0,0xc7b8,0,0x8fa4f6,0xb0e8, /* 0,0,'埒','埓','埔',0,'埖','埗', 0,0,0,0,'埜',0,'埞','域', */
	/* 57e0 */ 0xc9d6,0,0,0xd4c3,0xafd1,0,0x8fa4f7,0, 0,0,0,0,0,0xafd2,0,0, /* '埠',0,0,'埣','埤',0,'埦',0, 0,0,0,0,0,'埭',0,0, */
	/* 57f0 */ 0x8fa4f8,0,0,0,0xbefd,0xafd3,0xafd4,0xbcb9, 0x8fa4fa,0xc7dd,0xb4f0,0x8fa4fb,0xbaeb,0x8fa4fc,0,0xafd5, /* '埰',0,0,0,'埴','埵','埶','執', '埸','培','基','埻','埼','埽',0,'埿', */
	/* 5800 */ 0xcbd9,0,0xc6b2,0,0x8fa4fd,0xb7f8,0xc2cf,0, 0,0xafd6,0xd4c1,0xd4c4,0,0,0,0, /* '堀',0,'堂',0,'堄','堅','堆',0, 0,'堉','堊','堋',0,0,0,0, */
	/* 5810 */ 0,0,0,0,0,0xc2c4,0,0, 0,0xd4c5,0,0,0,0xd4c6,0x8fa4fe,0, /* 0,0,0,0,0,'堕',0,0, 0,'堙',0,0,0,'堝','堞',0, */
	/* 5820 */ 0x8fa5a1,0xd4c8,0,0,0xc4e9,0,0,0x8fa5a2, 0,0,0xb4ae,0,0,0,0,0xf4a1, /* '堠','堡',0,0,'堤',0,0,'堧', 0,0,'堪',0,0,0,0,'堯', */
	/* 5830 */ 0xb1e1,0xcaf3,0x8fa5a3,0,0xbeec,0xc5c8,0,0, 0,0x8fa5a4,0xbae6,0,0,0xd4ce,0,0, /* '堰','報','堲',0,'場','堵',0,0, 0,'堹','堺',0,0,'堽',0,0, */
	/* 5840 */ 0xcabd,0xcedd,0,0,0,0,0,0, 0,0x8fa5a6,0xb2f4,0xd4ca,0x8fa5a7,0,0,0, /* '塀','塁',0,0,0,0,0,0, 0,'塉','塊','塋','塌',0,0,0, */
	/* 5850 */ 0,0xc1ba,0xd4cd,0,0xc5e3,0,0,0xc5c9, 0xc5e4,0xc8b9,0xc4cd,0,0,0,0xbac9,0, /* 0,'塑','塒',0,'塔',0,0,'塗', '塘','塙','塚',0,0,0,'塞',0, */
	/* 5860 */ 0,0xafd8,0xd4c9,0,0xafd9,0,0,0x8fa5a8, 0,0xb1f6,0,0xc5b6,0,0,0,0, /* 0,'塡','塢',0,'塤',0,0,'塧', 0,'塩',0,'填',0,0,0,0, */
	/* 5870 */ 0xd4cb,0,0xd4c7,0,0,0xbfd0,0,0, 0,0xd4cf,0,0,0xafdb,0,0xbdce,0, /* '塰',0,'塲',0,0,'塵',0,0, 0,'塹',0,0,'塼',0,'塾',0, */
	/* 5880 */ 0,0,0,0xb6ad,0,0xd4d0,0,0, 0,0xafdc,0x8fa5a9,0x8fa5aa,0,0x8fa5ab,0,0x8fa5ac, /* 0,0,0,'境',0,'墅',0,0, 0,'墉','墊','墋',0,'墍',0,'墏', */
	/* 5890 */ 0x8fa5ad,0,0,0xcae8,0x8fa5ae,0,0,0xc1fd, 0,0,0,0,0xc4c6,0x8fa5af,0xafdd,0xd4d2, /* '墐',0,0,'墓','墔',0,0,'増', 0,0,0,0,'墜','墝','增','墟', */
	/* 58a0 */ 0,0,0,0,0,0,0,0, 0xcbcf,0xafdf,0x8fa5b0,0xd4d3,0,0,0xd4d8,0, /* 0,0,0,0,0,0,0,0, '墨','墩','墪','墫',0,0,'墮',0, */
	/* 58b0 */ 0,0x8fa5b1,0,0xcaaf,0,0,0,0, 0xd4d7,0xd4d1,0xd4d4,0xd4d6,0,0,0xbaa6,0, /* 0,'墱',0,'墳',0,0,0,0, '墸','墹','墺','墻',0,0,'墾',0, */
	/* 58c0 */ 0,0xcac9,0,0x8fa5b3,0,0xd4d9,0,0xc3c5, 0,0,0xb2f5,0,0xbeed,0x8fa5b4,0xafe2,0, /* 0,'壁',0,'壃',0,'壅',0,'壇', 0,0,'壊',0,'壌','壍','壎',0, */
	/* 58d0 */ 0,0xd4db,0xafe1,0xd4da,0xafe3,0xb9e8,0,0xd4dc, 0xd4de,0xd4dd,0xafe4,0,0xd4e0,0,0xd4d5,0xd4e2, /* 0,'壑','壒','壓','壔','壕',0,'壗', '壘','壙','壚',0,'壜',0,'壞','壟', */
	/* 58e0 */ 0xafe5,0,0x8fa5b5,0,0xd4e1,0xd4df,0,0, 0,0xafe6,0,0xbbce,0xbfd1,0,0xc1d4,0xd4e3, /* '壠',0,'壢',0,'壤','壥',0,0, 0,'壩',0,'士','壬',0,'壮','壯', */
	/* 58f0 */ 0xc0bc,0xb0ed,0xc7e4,0x8fa5b6,0x8fa5b7,0,0,0xc4db, 0,0xd4e5,0xd4e4,0xd4e6,0xd4e7,0xd4e8,0,0, /* '声','壱','売','壳','壴',0,0,'壷', 0,'壹','壺','壻','壼','壽',0,0, */
	/* 5900 */ 0,0,0xd4e9,0,0,0x8fa5b8,0x8fa5b9,0, 0,0xcad1,0xd4ea,0x8fa5ba,0xafe7,0x8fa5bb,0,0xb2c6, /* 0,0,'夂',0,0,'夅','夆',0, 0,'変','夊','夋','夌','复',0,'夏', */
	/* 5910 */ 0xd4eb,0,0,0,0x8fa5bc,0xcdbc,0xb3b0,0, 0xd2c9,0xbdc8,0xc2bf,0xd4ec,0xcceb,0,0,0, /* '夐',0,0,0,'夔','夕','外',0, '夘','夙','多','夛','夜',0,0,0, */
	/* 5920 */ 0,0,0xccb4,0,0x8fa5bd,0xd4ee,0,0xc2e7, 0,0xc5b7,0xc2c0,0xc9d7,0xd4ef,0xd4f0,0xb1fb,0, /* 0,0,'夢',0,'夤','夥',0,'大', 0,'天','太','夫','夬','夭','央',0, */
	/* 5930 */ 0,0xbcba,0xd4f1,0,0,0,0,0xb0d0, 0xd4f2,0,0,0,0,0x8fa5c0,0xd4f3,0, /* 0,'失','夲',0,0,0,0,'夷', '夸',0,0,0,0,'夽','夾',0, */
	/* 5940 */ 0,0,0,0,0xb1e2,0,0x8fa5c2,0xb4f1, 0xc6e0,0xcaf4,0,0,0,0,0xd4f7,0xc1d5, /* 0,0,0,0,'奄',0,'奆','奇', '奈','奉',0,0,0,0,'奎','奏', */
	/* 5950 */ 0xd4f6,0xb7c0,0,0,0xcbdb,0xd4f5,0,0xc5e5, 0xd4f9,0,0xd4f8,0x8fa5c5,0,0xafe9,0,0x8fa5c6, /* '奐','契',0,0,'奔','奕',0,'套', '奘',0,'奚','奛',0,'奝',0,'奟', */
	/* 5960 */ 0xd4fb,0,0xd4fa,0,0,0xb1fc,0,0xd4fc, 0xbea9,0xd4fe,0xc3a5,0,0xd4fd,0xafea,0xcab3,0, /* '奠',0,'奢',0,0,'奥',0,'奧', '奨','奩','奪',0,'奬','奭','奮',0, */
	/* 5970 */ 0,0,0,0xbdf7,0xc5db,0x8fa5c8,0x8fa5c9,0, 0xd5a1,0,0,0,0x8fa5ca,0xb9a5,0,0, /* 0,0,0,'女','奴','奵','奶',0, '奸',0,0,0,'奼','好',0,0, */
	/* 5980 */ 0,0xd5a2,0xc7a1,0xc8de,0xccd1,0,0,0, 0,0,0xc7a5,0xafeb,0,0xd5ab,0,0, /* 0,'妁','如','妃','妄',0,0,0, 0,0,'妊','妋',0,'妍',0,0, */
	/* 5990 */ 0,0,0xafec,0xb5b8,0,0,0xcdc5,0, 0,0xccaf,0,0xd6ac,0,0xd5a3,0,0x8fa5cb, /* 0,0,'妒','妓',0,0,'妖',0, 0,'妙',0,'妛',0,'妝',0,'妟', */
	/* 59a0 */ 0,0,0,0xd5a6,0xafed,0xc2c5,0,0, 0xcbb8,0,0,0,0xc5ca,0,0x8fa5cc,0, /* 0,0,0,'妣','妤','妥',0,0, '妨',0,0,0,'妬',0,'妮',0, */
	/* 59b0 */ 0,0,0xd5a7,0,0,0,0,0, 0,0xcbe5,0,0xbaca,0x8fa5cd,0,0xbeaa,0, /* 0,0,'妲',0,0,0,0,0, 0,'妹',0,'妻','妼',0,'妾',0, */
	/* 59c0 */ 0,0,0,0xafee,0,0,0xd5a8,0, 0x8fa5ce,0xbbd0,0,0xbbcf,0,0x8fa5cf,0,0, /* 0,0,0,'姃',0,0,'姆',0, '姈','姉',0,'始',0,'姍',0,0, */
	/* 59d0 */ 0xb0b9,0xb8c8,0xafef,0xc0ab,0xb0d1,0,0,0, 0,0xd5ac,0xd5ad,0,0xd5aa,0xaff0,0x8fa5d0,0, /* '姐','姑','姒','姓','委',0,0,0, 0,'姙','姚',0,'姜','姝','姞',0, */
	/* 59e0 */ 0,0,0,0x8fa5d1,0x8fa5d2,0xb1b8,0xb4af,0x8fa5d3, 0xd5a9,0,0xccc5,0xc9b1,0,0,0x8fa5d4,0, /* 0,0,0,'姣','姤','姥','姦','姧', '姨',0,'姪','姫',0,0,'姮',0, */
	/* 59f0 */ 0,0,0,0,0,0,0xb0a8,0, 0xfefa,0,0,0xb0f9,0,0,0,0xbbd1, /* 0,0,0,0,0,0,'姶',0, '姸',0,0,'姻',0,0,0,'姿', */
	/* 5a00 */ 0,0xb0d2,0,0xb0a3,0,0,0,0, 0,0xd5b2,0,0,0x8fa5d8,0x8fa5d9,0,0, /* 0,'威',0,'娃',0,0,0,0, 0,'娉',0,0,'娌','娍',0,0, */
	/* 5a10 */ 0,0xd5b0,0,0xaff1,0,0,0,0x8fa5da, 0xccbc,0,0xd5b3,0,0xd5b1,0,0,0xd5af, /* 0,'娑',0,'娓',0,0,0,'娗', '娘',0,'娚',0,'娜',0,0,'娟', */
	/* 5a20 */ 0xbfb1,0,0,0xaff2,0,0xd5ae,0,0x8fa5db, 0,0xcada,0,0,0,0x8fa5dc,0,0xb8e4, /* '娠',0,0,'娣',0,'娥',0,'娧', 0,'娩',0,0,0,'娭',0,'娯', */
	/* 5a30 */ 0,0,0,0,0,0xd5b7,0xd5b8,0, 0,0,0,0,0xbeab,0,0,0, /* 0,0,0,0,0,'娵','娶',0, 0,0,0,0,'娼',0,0,0, */
	/* 5a40 */ 0xd5b4,0xcfac,0,0,0,0,0xc7cc,0, 0,0xd5b6,0,0,0,0,0,0, /* '婀','婁',0,0,0,0,'婆',0, 0,'婉',0,0,0,0,0,0, */
	/* 5a50 */ 0,0,0,0,0,0x8fa5dd,0,0, 0,0,0xbaa7,0,0,0,0,0, /* 0,0,0,0,0,'婕',0,0, 0,0,'婚',0,0,0,0,0, */
	/* 5a60 */ 0,0,0xd5b9,0,0,0x8fa5de,0xc9d8,0xaff3, 0,0,0xd5ba,0,0xd5b5,0xaff4,0,0, /* 0,0,'婢',0,0,'婥','婦','婧', 0,0,'婪',0,'婬','婭',0,0, */
	/* 5a70 */ 0,0,0,0,0,0,0,0xaff5, 0,0,0x8fa5df,0,0,0,0xaff6,0xccbb, /* 0,0,0,0,0,0,0,'婷', 0,0,'婺',0,0,0,'婾','婿', */
	/* 5a80 */ 0,0,0,0,0xaff7,0,0,0, 0,0,0,0x8fa5e0,0,0,0,0, /* 0,0,0,0,'媄',0,0,0, 0,0,0,'媋',0,0,0,0, */
	/* 5a90 */ 0,0,0xc7de,0,0,0,0,0, 0,0,0xd5bb,0xc9b2,0x8fa5e1,0,0xaff8,0x8fa5e2, /* 0,0,'媒',0,0,0,0,0, 0,0,'媚','媛','媜',0,'媞','媟', */
	/* 5aa0 */ 0x8fa5e3,0,0x8fa5e4,0,0,0,0,0xaff9, 0,0,0,0,0,0,0,0, /* '媠',0,'媢',0,0,0,0,'媧', 0,0,0,0,0,0,0,0, */
	/* 5ab0 */ 0,0x8fa5e5,0,0x8fa5e6,0,0x8fa5e7,0,0, 0,0,0x8fa5e8,0,0xd5bc,0xd5c0,0xd5bd,0x8fa5e9, /* 0,'媱',0,'媳',0,'媵',0,0, 0,0,'媺',0,'媼','媽','媾','媿', */
	/* 5ac0 */ 0,0xb2c7,0xd5bf,0,0xaffa,0,0,0, 0,0xbcbb,0,0xd5be,0xb7f9,0,0,0, /* 0,'嫁','嫂',0,'嫄',0,0,0, 0,'嫉',0,'嫋','嫌',0,0,0, */
	/* 5ad0 */ 0xd5cc,0,0,0,0,0,0xd5c5,0xd5c2, 0,0,0x8fa5ea,0,0x8fa5eb,0,0,0, /* '嫐',0,0,0,0,0,'嫖','嫗', 0,0,'嫚',0,'嫜',0,0,0, */
	/* 5ae0 */ 0x8fa5ec,0xc3e4,0,0xd5c1,0,0x8fa5ed,0xd5c3,0, 0,0xd5c4,0,0,0,0,0x8fa5ef,0, /* '嫠','嫡',0,'嫣',0,'嫥','嫦',0, 0,'嫩',0,0,0,0,'嫮',0, */
	/* 5af0 */ 0x8fa5ee,0,0,0,0,0x8fa5f0,0,0, 0,0,0xd5c6,0xd5c7,0,0,0,0, /* '嫰',0,0,0,0,'嫵',0,0, 0,0,'嫺','嫻',0,0,0,0, */
	/* 5b00 */ 0x8fa5f1,0,0,0,0,0,0,0, 0x8fa5f2,0xb4f2,0,0xd5c9,0xd5c8,0,0,0, /* '嬀',0,0,0,0,0,0,0, '嬈','嬉',0,'嬋','嬌',0,0,0, */
	/* 5b10 */ 0,0,0,0,0,0,0xd5ca,0x8fa5f3, 0,0xaffc,0,0,0,0,0,0, /* 0,0,0,0,0,0,'嬖','嬗', 0,'嬙',0,0,0,0,0,0, */
	/* 5b20 */ 0,0,0xbeee,0,0,0xaffd,0,0, 0,0,0xd5cd,0,0xc4dc,0x8fa5f5,0,0, /* 0,0,'嬢',0,0,'嬥',0,0, 0,0,'嬪',0,'嬬','嬭',0,0, */
	/* 5b30 */ 0xb1c5,0,0xd5cb,0,0x8fa5f4,0,0xd5ce,0, 0,0,0,0,0,0,0xd5cf,0, /* '嬰',0,'嬲',0,'嬴',0,'嬶',0, 0,0,0,0,0,0,'嬾',0, */
	/* 5b40 */ 0xd5d2,0xcfd5,0,0xd5d0,0,0xd5d1,0,0, 0,0,0,0,0x8fa5f6,0,0,0, /* '孀','孁',0,'孃',0,'孅',0,0, 0,0,0,0,'孌',0,0,0, */
	/* 5b50 */ 0xbbd2,0xd5d3,0x8fa5f7,0,0xb9a6,0xd5d4,0xcfd6,0xbbfa, 0xc2b8,0,0xd5d5,0xd5d6,0xbbda,0xb9a7,0,0xccd2, /* '子','孑','孒',0,'孔','孕','孖','字', '存',0,'孚','孛','孜','孝',0,'孟', */
	/* 5b60 */ 0,0,0,0xb5a8,0xb8c9,0xd5d7,0xb3d8,0, 0x8fa5f8,0xd5d8,0,0xc2b9,0,0,0,0x8fa5f9, /* 0,0,0,'季','孤','孥','学',0, '孨','孩',0,'孫',0,0,0,'孯', */
	/* 5b70 */ 0xd5d9,0xd6a3,0,0xd5da,0,0xd5db,0,0, 0xd5dc,0,0xd5de,0,0x8fa5fa,0xcfd7,0,0x8fa5fb, /* '孰','孱',0,'孳',0,'孵',0,0, '學',0,'孺',0,'孼','孽',0,'孿', */
	/* 5b80 */ 0xd5df,0x8fa5fc,0,0xd5e0,0x8fa5fd,0xc2f0,0,0xb1a7, 0xbce9,0xb0c2,0,0xc1d7,0xb4b0,0xbcb5,0,0xb9a8, /* '宀','宁',0,'它','宄','宅',0,'宇', '守','安',0,'宋','完','宍',0,'宏', */
	/* 5b90 */ 0,0,0,0xcfd8,0,0xc5e6,0x8fa8a1,0xbda1, 0xb4b1,0xc3e8,0xc4ea,0xb0b8,0xb5b9,0xcaf5,0,0xbcc2, /* 0,0,0,'宓',0,'宕','宖','宗', '官','宙','定','宛','宜','宝',0,'実', */
	/* 5ba0 */ 0,0,0xb5d2,0xc0eb,0xbcbc,0xcda8,0xd5e1,0, 0,0,0,0,0x8fa8a2,0,0xb5dc,0, /* 0,0,'客','宣','室','宥','宦',0, 0,0,0,0,'宬',0,'宮',0, */
	/* 5bb0 */ 0xbacb,0,0,0xb3b2,0xb1e3,0xbeac,0xb2c8,0, 0xd5e2,0xcdc6,0,0,0,0,0,0xbdc9, /* '宰',0,0,'害','宴','宵','家',0, '宸','容',0,0,0,0,0,'宿', */
	/* 5bc0 */ 0x8fa8a4,0,0xbce4,0xd5e3,0xb4f3,0xc6d2,0xcca9,0xd5e4, 0,0xd5e5,0,0,0xc9d9,0,0x8fa8a6,0, /* '寀',0,'寂','寃','寄','寅','密','寇', 0,'寉',0,0,'富',0,'寎',0, */
	/* 5bd0 */ 0xd5e7,0,0xb4a8,0xb6f7,0xd5e6,0,0x8fa8a7,0, 0xcfd9,0,0,0xb4b2,0,0xbfb2,0xd5eb,0xbba1, /* '寐',0,'寒','寓','寔',0,'寖',0, '寘',0,0,'寛',0,'寝','寞','察', */
	/* 5be0 */ 0,0xb2c9,0xd5ea,0,0xd5e8,0xd5ec,0xd5e9,0xc7ab, 0xdccd,0xbfb3,0,0xd5ed,0xcfda,0,0xcec0,0, /* 0,'寡','寢',0,'寤','寥','實','寧', '寨','審',0,'寫','寬',0,'寮',0, */
	/* 5bf0 */ 0xd5ee,0x8fa8aa,0,0xd5f0,0,0xc3fe,0xd5ef,0, 0xc0a3,0,0xbbfb,0,0,0x8fa8ab,0xc2d0,0xbcf7, /* '寰','寱',0,'寳',0,'寵','寶',0, '寸',0,'寺',0,0,'寽','対','寿', */
	/* 5c00 */ 0,0xc9f5,0xc0ec,0x8fa8ad,0xbccd,0xd5f1,0xbead,0xd5f2, 0xd5f3,0xb0d3,0xc2ba,0xbfd2,0,0xd5f4,0xc6b3,0xbeae, /* 0,'封','専','尃','射','尅','将','將', '專','尉','尊','尋',0,'對','導','小', */
	/* 5c10 */ 0,0xbeaf,0xcfdb,0xd5f5,0,0,0xc0ed,0, 0,0,0xbeb0,0,0,0,0xcfdc,0, /* 0,'少','尒','尓',0,0,'尖',0, 0,0,'尚',0,0,0,'尞',0, */
	/* 5c20 */ 0xd5f6,0,0xd5f7,0xcfdd,0xcce0,0,0,0, 0xd5f8,0x8fa8ae,0,0xcfde,0,0xb6c6,0,0, /* '尠',0,'尢','尣','尤',0,0,0, '尨','尩',0,'尫',0,'尭',0,0, */
	/* 5c30 */ 0x8fa8af,0xbda2,0,0,0,0,0,0, 0xd5f9,0xd5fa,0xbcdc,0xbfac,0xc6f4,0xbfd4,0xc8f8,0xc7a2, /* '尰','就',0,0,0,0,0,0, '尸','尹','尺','尻','尼','尽','尾','尿', */
	/* 5c40 */ 0xb6c9,0xd5fb,0,0,0,0xb5ef,0xd5fc,0, 0xb6fe,0,0xc6cf,0xb2b0,0,0xbbd3,0xd5fd,0xd6a2, /* '局','屁',0,0,0,'居','屆',0, '屈',0,'届','屋',0,'屍','屎','屏', */
	/* 5c50 */ 0xd6a1,0xb6fd,0,0xd5fe,0,0xc5b8,0,0, 0,0,0,0xfefb,0,0,0xc2b0,0x8fa8b1, /* '屐','屑',0,'屓',0,'展',0,0, 0,0,0,'屛',0,0,'属','屟', */
	/* 5c60 */ 0xc5cb,0xbcc8,0xcfe0,0x8fa8b2,0xc1d8,0xcdfa,0,0x8fa8b3, 0x8fa8b4,0x8fa8b5,0,0,0xd6a4,0,0xd6a5,0xc6d6, /* '屠','屡','屢','屣','層','履',0,'屧', '屨','屩',0,0,'屬',0,'屮','屯', */
	/* 5c70 */ 0x8fa8b6,0xbbb3,0,0,0,0,0xd6a7,0, 0,0xd6a8,0xcfe4,0,0x8fa8b9,0,0,0, /* '屰','山',0,0,0,0,'屶',0, 0,'屹','屺',0,'屼',0,0,0, */
	/* 5c80 */ 0,0,0,0,0,0,0,0, 0x8fa8bc,0,0x8fa8bd,0,0xd6a9,0,0,0xcfe5, /* 0,0,0,0,0,0,0,0, '岈',0,'岊',0,'岌',0,0,'岏', */
	/* 5c90 */ 0xb4f4,0xd6aa,0,0,0xd6ab,0,0,0, 0,0,0,0,0,0,0,0xcfe6, /* '岐','岑',0,0,'岔',0,0,0, 0,0,0,0,0,0,0,'岟', */
	/* 5ca0 */ 0x8fa8c1,0xb2ac,0x8fa8c2,0xcfe7,0,0,0x8fa8c3,0x8fa8c4, 0xc1bb,0xb4e4,0xcfe8,0xd6ad,0xcca8,0x8fa8c6,0,0, /* '岠','岡','岢','岣',0,0,'岦','岧', '岨','岩','岪','岫','岬','岭',0,0, */
	/* 5cb0 */ 0,0xc2d2,0,0xb3d9,0,0x8fa8c7,0xd6af,0xd6b1, 0xb4df,0,0xcfe9,0xd6ae,0xd6b0,0,0xd6b3,0, /* 0,'岱',0,'岳',0,'岵','岶','岷', '岸',0,'岺','岻','岼',0,'岾',0, */
	/* 5cc0 */ 0,0,0,0,0,0xd6b2,0,0xd6b4, 0,0x8fa8c9,0,0xcfea,0,0,0,0, /* 0,0,0,0,0,'峅',0,'峇', 0,'峉',0,'峋',0,0,0,0, */
	/* 5cd0 */ 0xcfeb,0,0xcfec,0,0,0,0,0, 0,0xd6b5,0,0,0,0,0,0, /* '峐',0,'峒',0,0,0,0,0, 0,'峙',0,0,0,0,0,0, */
	/* 5ce0 */ 0xc6bd,0xb6ae,0,0,0,0,0,0, 0xb2e5,0xd6b6,0xd6bb,0,0,0xd6b9,0,0xcaf7, /* '峠','峡',0,0,0,0,0,0, '峨','峩','峪',0,0,'峭',0,'峯', */
	/* 5cf0 */ 0xcaf6,0,0,0,0xcfed,0,0xc5e7,0, 0,0,0xd6b8,0xbdd4,0,0xd6b7,0,0, /* '峰',0,0,0,'峴',0,'島',0, 0,0,'峺','峻',0,'峽',0,0, */
	/* 5d00 */ 0,0,0,0,0,0,0x8fa8cc,0xbff2, 0,0,0,0xd6bc,0,0xcff0,0xbaea,0, /* 0,0,0,0,0,0,'崆','崇', 0,0,0,'崋',0,'崍','崎',0, */
	/* 5d10 */ 0x8fa8cd,0xd6c2,0,0,0xd6c3,0xd6bd,0xb3b3,0xd6be, 0xd6c7,0xd6c6,0xd6c5,0xd6c1,0,0x8fa8cf,0,0xd6c0, /* '崐','崑',0,0,'崔','崕','崖','崗', '崘','崙','崚','崛',0,'崝',0,'崟', */
	/* 5d20 */ 0x8fa8d0,0,0xd6c4,0,0x8fa8d1,0,0x8fa8d2,0xcff1, 0,0xcaf8,0,0x8fa8ce,0,0,0,0, /* '崠',0,'崢',0,'崤',0,'崦','崧', 0,'崩',0,'崫',0,0,0,0, */
	/* 5d30 */ 0,0x8fa8d3,0,0,0,0,0,0, 0,0x8fa8d4,0,0,0,0,0,0, /* 0,'崱',0,0,0,0,0,0, 0,'崹',0,0,0,0,0,0, */
	/* 5d40 */ 0,0,0x8fa8d5,0,0,0,0xcff3,0xcff4, 0,0,0xcff6,0xd6cb,0xd6c8,0,0xd6ca,0, /* 0,0,'嵂',0,0,0,'嵆','嵇', 0,0,'嵊','嵋','嵌',0,'嵎',0, */
	/* 5d50 */ 0xcdf2,0,0xd6c9,0xcff5,0,0,0,0, 0,0,0,0,0xd6bf,0,0,0, /* '嵐',0,'嵒','嵓',0,0,0,0, 0,0,0,0,'嵜',0,0,0, */
	/* 5d60 */ 0,0x8fa8d7,0,0,0,0,0,0, 0,0xbff3,0x8fa8d8,0,0xd6cc,0xcff7,0,0xbab7, /* 0,'嵡',0,0,0,0,0,0, 0,'嵩','嵪',0,'嵬','嵭',0,'嵯', */
	/* 5d70 */ 0x8fa8da,0,0,0xd6cd,0,0,0xd6ce,0, 0,0,0,0,0,0,0,0, /* '嵰',0,0,'嵳',0,0,'嵶',0, 0,0,0,0,0,0,0,0, */
	/* 5d80 */ 0,0xcff8,0xd6d1,0,0xd6d0,0,0,0xd6cf, 0x8fa8dd,0,0,0xc5e8,0xd6ba,0,0,0, /* 0,'嶁','嶂',0,'嶄',0,0,'嶇', '嶈',0,0,'嶋','嶌',0,0,0, */
	/* 5d90 */ 0xd6d7,0,0x8fa8df,0,0x8fa8e0,0,0,0x8fa8e1, 0,0x8fa8e2,0,0,0,0xd6d3,0,0, /* '嶐',0,'嶒',0,'嶔',0,0,'嶗', 0,'嶙',0,0,0,'嶝',0,0, */
	/* 5da0 */ 0xcff9,0,0xd6d2,0,0xcffa,0,0,0xcffb, 0,0,0,0,0xd6d4,0,0xd6d5,0, /* '嶠',0,'嶢',0,'嶤',0,0,'嶧', 0,0,0,0,'嶬',0,'嶮',0, */
	/* 5db0 */ 0x8fa8e3,0,0x8fa8e4,0,0x8fa8e5,0,0,0xd6d8, 0xcffc,0x8fa8e7,0xcee6,0,0xd6d9,0xd6d6,0,0, /* '嶰',0,'嶲',0,'嶴',0,0,'嶷', '嶸','嶹','嶺',0,'嶼','嶽',0,0, */
	/* 5dc0 */ 0,0,0,0,0,0,0,0, 0,0xd6da,0,0xcffd,0xb4e0,0xd6db,0,0, /* 0,0,0,0,0,0,0,0, 0,'巉',0,'巋','巌','巍',0,0, */
	/* 5dd0 */ 0,0x8fa8e8,0xd6dd,0xd6dc,0,0,0xd6de,0x8fa8e9, 0x8fa8ea,0,0,0xd6df,0,0xc0ee,0xbda3,0, /* 0,'巑','巒','巓',0,0,'巖','巗', '巘',0,0,'巛',0,'川','州',0, */
	/* 5de0 */ 0x8fa8eb,0xbde4,0xf4a8,0xc1e3,0x8fa8ed,0xb9a9,0xbab8,0xb9aa, 0xb5f0,0x8fa8ee,0,0xd6e0,0,0,0xbab9,0, /* '巠','巡','巢','巣','巤','工','左','巧', '巨','巩',0,'巫',0,0,'差',0, */
	/* 5df0 */ 0,0xb8ca,0xd6e1,0xcca6,0xc7c3,0xd6e2,0,0xb9ab, 0,0,0,0xb4ac,0,0xc3a7,0xb6d2,0, /* 0,'己','已','巳','巴','巵',0,'巷', 0,0,0,'巻',0,'巽','巾',0, */
	/* 5e00 */ 0x8fa8f0,0,0xbbd4,0xc9db,0,0,0xc8c1,0, 0,0,0,0xd6e3,0xb4f5,0,0,0, /* '帀',0,'市','布',0,0,'帆',0, 0,0,0,'帋','希',0,0,0, */
	/* 5e10 */ 0,0xd6e6,0x8fa8f2,0,0xf4a9,0x8fa8f3,0xc4a1,0, 0xf4aa,0xd6e5,0xd6e4,0xd6e7,0,0xc4eb,0,0x8fa8f5, /* 0,'帑','帒',0,'帔','帕','帖',0, '帘','帙','帚','帛',0,'帝',0,'帟', */
	/* 5e20 */ 0,0,0,0,0,0xbfe3,0,0, 0,0,0,0xbbd5,0,0xc0ca,0x8fa8f6,0xc2d3, /* 0,0,0,0,0,'帥',0,0, 0,0,0,'師',0,'席','帮','帯', */
	/* 5e30 */ 0xb5a2,0,0,0xc4a2,0,0,0xd6e8,0xd6e9, 0xbeef,0,0,0,0,0xcbb9,0x8fa8f7,0, /* '帰',0,0,'帳',0,0,'帶','帷', '常',0,0,0,0,'帽','帾',0, */
	/* 5e40 */ 0xd6ec,0,0,0xd6eb,0xd6ea,0xc9fd,0,0xd6f3, 0,0x8fa8f8,0,0,0xcbda,0,0xd6ed,0, /* '幀',0,0,'幃','幄','幅',0,'幇', 0,'幉',0,0,'幌',0,'幎',0, */
	/* 5e50 */ 0,0,0,0,0xd6ef,0xcbeb,0x8fa8fa,0xd6ee, 0xf4ab,0,0,0,0,0,0xf4ac,0xd6f0, /* 0,0,0,0,'幔','幕','幖','幗', '幘',0,0,0,0,0,'幞','幟', */
	/* 5e60 */ 0,0xc8a8,0xd6f1,0xcabe,0xd6f2,0,0,0, 0,0,0,0x8fa8fc,0x8fa8fd,0x8fa8fe,0x8faca1,0, /* 0,'幡','幢','幣','幤',0,0,0, 0,0,0,'幫','幬','幭','幮',0, */
	/* 5e70 */ 0,0,0xb4b3,0xcabf,0xc7af,0xd6f4,0xd6f5,0xfefc, 0xb9ac,0xb4b4,0xd6f6,0xb8b8,0xcdc4,0xcda9,0xb4f6,0xd6f8, /* 0,0,'干','平','年','幵','并','幷', '幸','幹','幺','幻','幼','幽','幾','广', */
	/* 5e80 */ 0,0xc4a3,0,0xb9ad,0xbeb1,0,0,0xc8df, 0,0,0xbeb2,0,0,0,0,0xbdf8, /* 0,'庁',0,'広','庄',0,0,'庇', 0,0,'床',0,0,0,0,'序', */
	/* 5e90 */ 0,0,0,0,0,0xc4ec,0xcaf9,0xc5b9, 0,0,0xb9ae,0,0xc9dc,0,0,0, /* 0,0,0,0,0,'底','庖','店', 0,0,'庚',0,'府',0,0,0, */
	/* 5ea0 */ 0xd6f9,0,0,0,0,0x8faca3,0xc5d9,0xbac2, 0,0,0x8faca4,0xb8cb,0x8faca5,0xc4ed,0,0, /* '庠',0,0,0,0,'庥','度','座', 0,0,'庪','庫','庬','庭',0,0, */
	/* 5eb0 */ 0,0,0,0,0,0xb0c3,0xbdee,0xb9af, 0xcdc7,0x8faca6,0,0,0,0,0xf4ad,0x8faca7, /* 0,0,0,0,0,'庵','庶','康', '庸','庹',0,0,0,0,'庾','庿', */
	/* 5ec0 */ 0,0xd6fa,0xd6fb,0xc7d1,0,0,0x8faca8,0, 0xd6fc,0xcef7,0xcfad,0xf4af,0,0,0,0xd6fe, /* 0,'廁','廂','廃',0,0,'廆',0, '廈','廉','廊','廋',0,0,0,'廏', */
	/* 5ed0 */ 0xd6fd,0,0x8faca9,0xb3c7,0,0,0xd7a1,0, 0,0x8facaa,0xd7a4,0xd7a5,0,0xd7a3,0,0xc9c0, /* '廐',0,'廒','廓',0,0,'廖',0, 0,'廙','廚','廛',0,'廝',0,'廟', */
	/* 5ee0 */ 0xbeb3,0xd7a7,0xd7a6,0xd7a2,0,0,0,0, 0xd7a8,0xd7a9,0,0,0xd7aa,0,0,0, /* '廠','廡','廢','廣',0,0,0,0, '廨','廩',0,0,'廬',0,0,0, */
	/* 5ef0 */ 0xd7ad,0xd7ab,0,0xd7ac,0xd7ae,0,0xb1e4,0xc4ee, 0xd7af,0xf4b0,0xb7fa,0xb2f6,0xc7b6,0x8facac,0xd7b0,0xc6fb, /* '廰','廱',0,'廳','廴',0,'延','廷', '廸','廹','建','廻','廼','廽','廾','廿', */
	/* 5f00 */ 0xf4b1,0xcadb,0xf4b2,0xd7b1,0xcfae,0,0,0xf4b3, 0x8facad,0xd7b2,0xcac0,0xd7b5,0xd0a1,0xd0b1,0x8facae,0xbcb0, /* '开','弁','异','弃','弄',0,0,'弇', '弈','弉','弊','弋','弌','弍','弎','式', */
	/* 5f10 */ 0xc6f5,0xd7b6,0,0xb5dd,0xc4a4,0xb0fa,0xd7b7,0xcaa6, 0xb9b0,0,0,0xc3d0,0x8facaf,0xf4b4,0x8facb1,0xc4ef, /* '弐','弑',0,'弓','弔','引','弖','弗', '弘',0,0,'弛','弜','弝','弞','弟', */
	/* 5f20 */ 0,0,0,0xf4b5,0,0xccef,0xb8b9,0xb8cc, 0,0xd7b8,0,0,0,0xd7b9,0,0xd7bf, /* 0,0,0,'弣',0,'弥','弦','弧', 0,'弩',0,0,0,'弭',0,'弯', */
	/* 5f30 */ 0,0xbce5,0,0,0xf4b6,0xc4a5,0xf4b7,0xb6af, 0xd7ba,0,0,0,0xc9ab,0xf4b8,0xc3c6,0, /* 0,'弱',0,0,'弴','張','弶','強', '弸',0,0,0,'弼','弽','弾',0, */
	/* 5f40 */ 0xf4b9,0xd7bb,0,0,0,0xf4ba,0,0x8facb2, 0xd7bc,0,0xb6b0,0,0xd7bd,0,0xd7be,0, /* '彀','彁',0,0,0,'彅',0,'彇', '彈',0,'彊',0,'彌',0,'彎',0, */
	/* 5f50 */ 0,0xd7c0,0,0xc5f6,0xf4bb,0,0xd7c1,0xd7c2, 0xf4bc,0xd7c3,0,0,0xd7b4,0xd7b3,0,0, /* 0,'彑',0,'当','彔',0,'彖','彗', '彘','彙',0,0,'彜','彝',0,0, */
	/* 5f60 */ 0,0xd7c4,0xb7c1,0x8facb3,0xf4bd,0,0xc9a7,0xf4be, 0,0xbacc,0xc9b7,0xc4a6,0xc9cb,0xd7c5,0,0, /* 0,'彡','形','彣','彤',0,'彦','彧', 0,'彩','彪','彫','彬','彭',0,0, */
	/* 5f70 */ 0xbeb4,0xb1c6,0x8facb4,0xd7c6,0,0,0,0xd7c7, 0,0xccf2,0,0,0xc8e0,0xf4bf,0x8facb5,0xd7ca, /* '彰','影','彲','彳',0,0,0,'彷', 0,'役',0,0,'彼','彽','彾','彿', */
	/* 5f80 */ 0xb1fd,0xc0ac,0xd7c9,0xd7c8,0xb7c2,0xc2d4,0,0xd7ce, 0xd7cc,0xf4c0,0xd7cb,0xcea7,0xb8e5,0,0,0x8facb6, /* '往','征','徂','徃','径','待',0,'徇', '很','徉','徊','律','後',0,0,'徏', */
	/* 5f90 */ 0xbdf9,0xd7cd,0xc5cc,0xbdbe,0,0,0,0xc6c0, 0xd7d1,0xd7d0,0,0,0xf4c1,0,0xd7cf,0, /* '徐','徑','徒','従',0,0,0,'得', '徘','徙',0,0,'徜',0,'從',0, */
	/* 5fa0 */ 0xd7d2,0xb8e6,0x8facb7,0,0x8facb8,0,0,0xf4c2, 0xd7d3,0xc9fc,0xbddb,0,0,0xd7d4,0xc8f9,0xf4c3, /* '徠','御','徢',0,'徤',0,0,'徧', '徨','復','循',0,0,'徭','微','徯', */
	/* 5fb0 */ 0,0,0,0xc6c1,0xc4a7,0xf4c4,0,0xf4c5, 0x8facb9,0xc5b0,0,0,0xd7d5,0xb5ab,0,0, /* 0,0,0,'徳','徴','徵',0,'德', '徸','徹',0,0,'徼','徽',0,0, */
	/* 5fc0 */ 0,0,0,0xbfb4,0x8facba,0xc9ac,0,0x8facbc, 0,0xf4c6,0,0x8facbd,0xb4f7,0xc7a6,0,0, /* 0,0,0,'心','忄','必',0,'忇', 0,'忉',0,'忋','忌','忍',0,0, */
	/* 5fd0 */ 0,0,0x8facbe,0x8facbf,0x8facc0,0,0xd7d6,0xbbd6, 0xcbba,0xcbbb,0,0,0xb1fe,0xd7db,0xf4c7,0, /* 0,0,'忒','忓','忔',0,'忖','志', '忘','忙',0,0,'応','忝','忞',0, */
	/* 5fe0 */ 0xc3e9,0xf4c8,0x8facc1,0,0xd7d8,0,0,0, 0,0xf4c9,0,0xb2f7,0,0,0x8facc2,0x8facc3, /* '忠','忡','忢',0,'忤',0,0,0, 0,'忩',0,'快',0,0,'忮','忯', */
	/* 5ff0 */ 0xd8ad,0xd7da,0,0x8facc4,0,0xc7b0,0,0, 0xd7d9,0,0,0xd7d7,0x8facc5,0xb9fa,0,0xd7dd, /* '忰','忱',0,'忳',0,'念',0,0, '忸',0,0,'忻','忼','忽',0,'忿', */
	/* 6000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xf4ca,0xd7e3,0xd7e9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'怍','怎','怏', */
	/* 6010 */ 0xd7e1,0,0xc5dc,0,0xf4cb,0xd7e6,0xc9dd,0x8facc7, 0xf4cc,0xd7e0,0,0xd7e5,0xcee7,0xbbd7,0,0, /* '怐',0,'怒',0,'怔','怕','怖','怗', '怘','怙',0,'怛','怜','思',0,0, */
	/* 6020 */ 0xc2d5,0xd7de,0x8facc8,0,0x8facc9,0xb5de,0xd7e8,0xc0ad, 0xb1e5,0xd7e2,0xb2f8,0xd7e7,0,0,0,0xb6b1, /* '怠','怡','怢',0,'怤','急','怦','性', '怨','怩','怪','怫',0,0,0,'怯', */
	/* 6030 */ 0,0xd7e4,0,0xf4cd,0,0xf4ce,0,0, 0,0,0xd7ea,0,0,0,0,0, /* 0,'怱',0,'怳',0,'怵',0,0, 0,0,'怺',0,0,0,0,0, */
	/* 6040 */ 0,0xd7ec,0xd7f6,0xd7f4,0,0,0xd7f1,0xf4cf, 0,0,0xd7f0,0xcef8,0x8faccb,0xd7f2,0,0, /* 0,'恁','恂','恃',0,0,'恆','恇', 0,0,'恊','恋','恌','恍',0,0, */
	/* 6050 */ 0xb6b2,0,0xb9b1,0,0,0xbdfa,0,0, 0,0xd7f9,0xd7eb,0,0,0,0,0xd7ef, /* '恐',0,'恒',0,0,'恕',0,0, 0,'恙','恚',0,0,0,0,'恟', */
	/* 6060 */ 0xd7df,0,0xb2fa,0xd7f3,0xd7f5,0xc3d1,0,0, 0xbaa8,0xb2b8,0xd7ed,0xd7f8,0xd7f7,0xb6b3,0,0xc2a9, /* '恠',0,'恢','恣','恤','恥',0,0, '恨','恩','恪','恫','恬','恭',0,'息', */
	/* 6070 */ 0xb3e6,0,0,0,0,0xb7c3,0,0xd7ee, 0,0,0,0,0,0,0,0x8faccc, /* '恰',0,0,0,0,'恵',0,'恷', 0,0,0,0,0,0,0,'恿', */
	/* 6080 */ 0,0xd7fa,0,0xd7fd,0xd8a1,0,0,0, 0,0xbcbd,0x8faccd,0xd8a7,0xc4f0,0xd7fb,0,0, /* 0,'悁',0,'悃','悄',0,0,0, 0,'悉','悊','悋','悌','悍',0,0, */
	/* 6090 */ 0,0,0xd8a5,0,0xb2f9,0x8facce,0xd8a3,0xd8a4, 0,0,0xd7fe,0xd8a2,0,0xf4d1,0xf4d2,0xb8e7, /* 0,0,'悒',0,'悔','悕','悖','悗', 0,0,'悚','悛',0,'悝','悞','悟', */
	/* 60a0 */ 0xcdaa,0,0,0xb4b5,0,0,0xb1d9,0xd8a6, 0x8faccf,0xc7ba,0xb0ad,0,0,0,0,0, /* '悠',0,0,'患',0,0,'悦','悧', '您','悩','悪',0,0,0,0,0, */
	/* 60b0 */ 0x8facd1,0x8facd2,0xc8e1,0xd7dc,0xd8ac,0xd8b0,0xcce5,0, 0xd8a9,0,0,0,0xc5e9,0xd8ae,0x8facd3,0, /* '悰','悱','悲','悳','悴','悵','悶',0, '悸',0,0,0,'悼','悽','悾',0, */
	/* 60c0 */ 0,0,0,0,0,0xbef0,0xd8af,0xc6d7, 0x8facd4,0,0,0xf4d3,0,0,0,0, /* 0,0,0,0,0,'情','惆','惇', '惈',0,0,'惋',0,0,0,0, */
	/* 60d0 */ 0,0xcfc7,0,0xd8ab,0xf4d4,0xf4d5,0,0, 0xd8b1,0x8facd5,0xb9fb,0x8facd6,0xc0cb,0xf4d6,0,0xb0d4, /* 0,'惑',0,'惓','惔','惕',0,0, '惘','惙','惚','惛','惜','惝',0,'惟', */
	/* 60e0 */ 0xd8aa,0xd8a8,0,0xc1da,0,0,0,0xd7fc, 0xbbb4,0,0,0,0,0,0x8facd7,0, /* '惠','惡',0,'惣',0,0,0,'惧', '惨',0,0,0,0,0,'惮',0, */
	/* 60f0 */ 0xc2c6,0xd8bd,0x8facd8,0xc1db,0xd8b8,0x8facd9,0xd8b5,0xd8b6, 0xf4d7,0xbce6,0xd8b9,0xd8bc,0,0,0,0, /* '惰','惱','惲','想','惴','惵','惶','惷', '惸','惹','惺','惻',0,0,0,0, */
	/* 6100 */ 0xd8b7,0xbda5,0,0xd8ba,0,0,0xd8b4,0, 0xccfc,0xccfb,0,0,0,0xd8be,0xd8bf,0xb0d5, /* '愀','愁',0,'愃',0,0,'愆',0, '愈','愉',0,0,0,'愍','愎','意', */
	/* 6110 */ 0x8facda,0,0x8facdb,0x8facdc,0,0xd8b3,0,0, 0,0x8facdd,0xb6f2,0xb0a6,0xf4d8,0,0x8facde,0xb4b6, /* '愐',0,'愒','愓',0,'愕',0,0, 0,'愙','愚','愛','愜',0,'愞','感', */
	/* 6120 */ 0,0xd8bb,0,0,0,0,0,0xd8c3, 0xd8c2,0,0,0xf4d9,0xd8c7,0,0,0, /* 0,'愡',0,0,0,0,0,'愧', '愨',0,0,'愫','愬',0,0,0, */
	/* 6130 */ 0xf4da,0,0,0,0xd8c8,0,0,0xf4db, 0,0,0x8facdf,0,0xd8c6,0xd8c9,0xd8c1,0xd8c5, /* '愰',0,0,0,'愴',0,0,'愷', 0,0,'愺',0,'愼','愽','愾','愿', */
	/* 6140 */ 0,0x8face1,0xd8ca,0,0xd8cb,0,0x8face2,0xd8c0, 0xbbfc,0,0xd8c4,0xc2d6,0xb9b2,0xd8b2,0xbfb5,0, /* 0,'慁','慂',0,'慄',0,'慆','慇', '慈',0,'慊','態','慌','慍','慎',0, */
	/* 6150 */ 0,0,0,0xd8d8,0,0xcae9,0,0, 0xd8ce,0xd8cf,0xd8d0,0,0,0xd8d7,0,0xd8d6, /* 0,0,0,'慓',0,'慕',0,0, '慘','慙','慚',0,0,'慝',0,'慟', */
	/* 6160 */ 0x8face3,0,0xcbfd,0xb4b7,0,0xd8d4,0,0xb7c5, 0xb3b4,0,0,0xd8d1,0,0,0xceb8,0xd8d3, /* '慠',0,'慢','慣',0,'慥',0,'慧', '慨',0,0,'慫',0,0,'慮','慯', */
	/* 6170 */ 0xb0d6,0xd8d5,0,0xd8cc,0xd8d2,0xd8d9,0xb7c4,0xd8cd, 0,0,0,0,0x8face4,0,0xcddd,0, /* '慰','慱',0,'慳','慴','慵','慶','慷', 0,0,0,0,'慼',0,'慾',0, */
	/* 6180 */ 0,0,0xcdab,0,0,0,0,0xd8dc, 0,0,0xd8e0,0,0,0xf4dd,0xc1fe,0, /* 0,0,'憂',0,0,0,0,'憇', 0,0,'憊',0,0,'憍','憎',0, */
	/* 6190 */ 0xcef9,0xd8e1,0x8face6,0x8face7,0xd8de,0,0xd8db,0x8face8, 0x8face9,0xd8da,0xd8df,0,0,0,0,0, /* '憐','憑','憒','憓','憔',0,'憖','憗', '憘','憙','憚',0,0,0,0,0, */
	/* 61a0 */ 0,0,0,0,0xcab0,0x8facea,0,0xc6b4, 0x8faceb,0xb7c6,0,0xd8e2,0xd8dd,0x8facec,0xd8e3,0, /* 0,0,0,0,'憤','憥',0,'憧', '憨','憩',0,'憫','憬','憭','憮',0, */
	/* 61b0 */ 0,0,0xb7fb,0,0,0,0xb2b1,0, 0,0xf4e0,0xd8eb,0,0xf4df,0,0xb4b8,0, /* 0,0,'憲',0,0,0,'憶',0, 0,'憹','憺',0,'憼',0,'憾',0, */
	/* 61c0 */ 0,0,0,0xd8e9,0,0,0xd8ea,0xbaa9, 0xd8e8,0xd8e6,0xd8e5,0xd8ec,0xd8e4,0xd8ee,0,0, /* 0,0,0,'懃',0,0,'懆','懇', '懈','應','懊','懋','懌','懍',0,0, */
	/* 61d0 */ 0xb2fb,0,0,0,0,0x8facee,0,0, 0,0,0,0,0,0x8facef,0,0x8facf0, /* '懐',0,0,0,0,'懕',0,0, 0,0,0,0,0,'懝',0,'懟', */
	/* 61e0 */ 0,0,0,0xd8f0,0,0,0xd8ef,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'懣',0,0,'懦',0, 0,0,0,0,0,0,0,0, */
	/* 61f0 */ 0,0,0xc4a8,0,0xd8f3,0x8facf1,0xd8f1,0xd8e7, 0xb7fc,0,0xd8f2,0,0xd8f6,0xd8f5,0xd8f7,0xd8f4, /* 0,0,'懲',0,'懴','懵','懶','懷', '懸',0,'懺',0,'懼','懽','懾','懿', */
	/* 6200 */ 0xd8f8,0,0,0,0,0,0,0, 0xd8f9,0xd8fa,0xcaea,0,0xd8fc,0xd8fb,0xbdbf,0, /* '戀',0,0,0,0,0,0,0, '戈','戉','戊',0,'戌','戍','戎',0, */
	/* 6210 */ 0xc0ae,0xb2e6,0xb2fc,0,0xd8fd,0x8facf3,0xb0bf,0, 0,0,0xc0cc,0xd8fe,0,0xecc3,0xd9a1,0xb7e1, /* '成','我','戒',0,'戔','戕','或',0, 0,0,'戚','戛',0,'戝','戞','戟', */
	/* 6220 */ 0,0xd9a2,0xf4e2,0x8facf4,0,0,0xc0ef,0, 0,0x8facf5,0xd9a3,0,0,0,0xd9a4,0xb5ba, /* 0,'戡','戢','戣',0,0,'戦',0, 0,'戩','截',0,0,0,'戮','戯', */
	/* 6230 */ 0xd9a5,0,0xd9a6,0xd9a7,0xc2d7,0,0,0, 0xb8cd,0,0,0xcce1,0,0,0xf4e3,0xcbbc, /* '戰',0,'戲','戳','戴',0,0,0, '戸',0,0,'戻',0,0,'戾','房', */
	/* 6240 */ 0xbdea,0xd9a8,0,0xf4e4,0,0,0x8facf6,0xc0f0, 0xeebd,0xc8e2,0,0xbcea,0x8facf7,0xbacd,0xd9a9,0, /* '所','扁',0,'扃',0,0,'扆','扇', '扈','扉',0,'手','扌','才','扎',0, */
	/* 6250 */ 0,0x8facf8,0x8facf9,0xc2c7,0,0xcaa7,0xf4e5,0, 0xc2f1,0,0xf4e6,0xd9ac,0,0,0xd9aa,0, /* 0,'扑','扒','打',0,'払','扖',0, '托',0,'扚','扛',0,0,'扞',0, */
	/* 6260 */ 0xd9ad,0x8facfa,0,0xd9ab,0x8facfb,0,0,0, 0xd9ae,0,0,0,0,0x8facfd,0xcab1,0xf4e7, /* '扠','扡',0,'扣','扤',0,0,0, '扨',0,0,0,0,'扭','扮','扯', */
	/* 6270 */ 0,0xb0b7,0,0x8facfe,0,0,0xc9de,0, 0,0xc8e3,0,0x8facfc,0xd9af,0,0xd9b2,0xbeb5, /* 0,'扱',0,'扳',0,0,'扶',0, 0,'批',0,'扻','扼',0,'找','承', */
	/* 6280 */ 0xb5bb,0,0xd9b0,0xd9b7,0xbeb6,0xf4e8,0,0, 0,0xd9b1,0xc7c4,0,0,0,0,0, /* '技',0,'抂','抃','抄','抅',0,0, 0,'抉','把',0,0,0,0,0, */
	/* 6290 */ 0,0xcdde,0xd9b3,0xd9b4,0xd9b8,0xc5ea,0xd9b5,0xb9b3, 0xc0de,0x8fada1,0,0xd9c6,0xc8b4,0,0xc2f2,0, /* 0,'抑','抒','抓','抔','投','抖','抗', '折','抙',0,'抛','抜',0,'択',0, */
	/* 62a0 */ 0,0,0,0,0,0,0x8fada2,0, 0,0,0,0xc8e4,0xdaad,0,0,0, /* 0,0,0,0,0,0,'抦',0, 0,0,0,'披','抬',0,0,0, */
	/* 62b0 */ 0,0xcafa,0,0,0,0xc4f1,0,0, 0,0xcbf5,0,0xd9bb,0xb2a1,0xc3ea,0,0, /* 0,'抱',0,0,0,'抵',0,0, 0,'抹',0,'抻','押','抽',0,0, */
	/* 62c0 */ 0,0,0xd9c4,0,0xf4e9,0xc3b4,0xd9be,0xd9c5, 0xd9c0,0xd9c7,0xd9c3,0,0xd9c2,0xc7ef,0,0xd9bc, /* 0,0,'拂',0,'拄','担','拆','拇', '拈','拉','拊',0,'拌','拍',0,'拏', */
	/* 62d0 */ 0xb2fd,0xd9ba,0xb5f1,0xc2f3,0xd9b6,0x8fada3,0xf4ea,0xd9b9, 0xb9b4,0xc0db,0,0xbeb7,0xd9c1,0xc7d2,0,0, /* '拐','拑','拒','拓','拔','拕','拖','拗', '拘','拙',0,'招','拜','拝',0,0, */
	/* 62e0 */ 0xb5f2,0xb3c8,0,0,0,0,0,0, 0,0,0,0,0xb3e7,0xbfa1,0xd9c9,0xd9ce, /* '拠','拡',0,0,0,0,0,0, 0,0,0,0,'括','拭','拮','拯', */
	/* 62f0 */ 0,0xd9ca,0,0xb7fd,0,0xd9cf,0xbba2,0xb9e9, 0,0,0,0,0xf4eb,0x8fada5,0xbda6,0xd9bd, /* 0,'拱',0,'拳',0,'拵','拶','拷', 0,0,0,0,'拼','拽','拾','拿', */
	/* 6300 */ 0,0xbbfd,0xd9cc,0x8fada6,0,0,0,0xbbd8, 0xd9cd,0xb0c4,0xf4ec,0,0xd9c8,0x8fada7,0,0, /* 0,'持','挂','挃',0,0,0,'指', '挈','按','挊',0,'挌','挍',0,0, */
	/* 6310 */ 0x8fada8,0xc4a9,0,0,0,0,0,0, 0xf4ed,0xb5f3,0,0,0,0,0,0xb6b4, /* '挐','挑',0,0,0,0,0,0, '挘','挙',0,0,0,0,0,'挟', */
	/* 6320 */ 0,0,0,0,0,0,0,0xd9cb, 0xb0a7,0,0,0xbac3,0,0,0,0xbfb6, /* 0,0,0,0,0,0,0,'挧', '挨',0,0,'挫',0,0,0,'振', */
	/* 6330 */ 0,0,0x8fadab,0,0,0x8fadac,0,0, 0,0xf4ee,0xc4f2,0x8fadad,0x8fadae,0xc8d4,0xd9d1,0xc1de, /* 0,0,'挲',0,0,'挵',0,0, 0,'挹','挺','挻','挼','挽','挾','挿', */
	/* 6340 */ 0,0x8fadaf,0,0xf4ef,0x8fadb0,0,0,0, 0,0xc2aa,0,0,0xbbab,0xd9d2,0x8fadb1,0xd9d4, /* 0,'捁',0,'捃','捄',0,0,0, 0,'捉',0,0,'捌','捍','捎','捏', */
	/* 6350 */ 0xd9d0,0,0,0,0,0xcae1,0,0xc4bd, 0,0x8fadb3,0,0,0xc1dc,0,0,0, /* '捐',0,0,0,0,'捕',0,'捗', 0,'捙',0,0,'捜',0,0,0, */
	/* 6360 */ 0,0,0,0,0,0xf4f0,0,0xcafb, 0xbcce,0xd9e0,0,0xd9df,0x8fadb6,0,0xbff8,0, /* 0,0,0,0,0,'捥',0,'捧', '捨','捩',0,'捫','捬',0,'据',0, */
	/* 6370 */ 0,0,0xb7fe,0,0,0,0xd9d9,0xbeb9, 0,0,0xc6e8,0xc7b1,0xf4f1,0,0,0, /* 0,0,'捲',0,0,0,'捶','捷', 0,0,'捺','捻','捼',0,0,0, */
	/* 6380 */ 0xd9d7,0,0,0xc1dd,0x8fadb7,0,0,0, 0xbcf8,0xd9dc,0,0,0xbeb8,0,0xd9d6,0xd9db, /* '掀',0,0,'掃','掄',0,0,0, '授','掉',0,0,'掌',0,'掎','掏', */
	/* 6390 */ 0,0,0xc7d3,0,0x8fadba,0,0xd9d5,0, 0xb7a1,0x8fadb8,0,0xb3dd,0,0,0,0xd9dd, /* 0,0,'排',0,'掔',0,'掖',0, '掘','掙',0,'掛',0,0,0,'掟', */
	/* 63a0 */ 0xceab,0xbace,0xc3b5,0xd9da,0,0xc0dc,0,0xb9b5, 0xbfe4,0xb1e6,0xc1bc,0xd9d8,0xb5c5,0,0,0, /* '掠','採','探','掣',0,'接',0,'控', '推','掩','措','掫','掬',0,0,0, */
	/* 63b0 */ 0,0,0xb7c7,0,0xc4cf,0xd9de,0,0, 0,0,0,0xc1df,0,0x8fadbb,0xd9e1,0, /* 0,0,'掲',0,'掴','掵',0,0, 0,0,0,'掻',0,'掽','掾',0, */
	/* 63c0 */ 0xd9e3,0,0,0xc2b7,0xd9e9,0,0xd9e4,0, 0,0xd9e6,0,0,0,0,0,0xc9c1, /* '揀',0,0,'揃','揄',0,'揆',0, 0,'揉',0,0,0,0,0,'描', */
	/* 63d0 */ 0xc4f3,0,0xd9e7,0,0x8fadbd,0x8fadbe,0xcdac,0, 0,0,0xcdc8,0xb4b9,0x8fadbf,0,0,0, /* '提',0,'插',0,'揔','揕','揖',0, 0,0,'揚','換','揜',0,0,0, */
	/* 63e0 */ 0x8fadc0,0xb0ae,0,0xd9e5,0,0xf4f2,0,0, 0,0xd9e2,0,0x8fadc1,0x8fadc2,0xf4f3,0xb4f8,0, /* '揠','握',0,'揣',0,'揥',0,0, 0,'揩',0,'揫','揬','揭','揮',0, */
	/* 63f0 */ 0,0,0x8fadc3,0,0xb1e7,0xf4f4,0xd9e8,0x8fadbc, 0,0,0xcdc9,0,0,0,0,0, /* 0,0,'揲',0,'援','揵','揶','揷', 0,0,'揺',0,0,0,0,0, */
	/* 6400 */ 0,0,0,0,0,0,0xd9ec,0, 0,0x8fadc4,0,0,0,0xc2bb,0,0xd9f3, /* 0,0,0,0,0,0,'搆',0, 0,'搉',0,0,0,'損',0,'搏', */
	/* 6410 */ 0xf4f5,0,0,0xd9ed,0xf4f6,0,0xd9ea,0xd9f1, 0,0,0,0,0xd9d3,0,0x8fadc5,0, /* '搐',0,0,'搓','搔',0,'搖','搗', 0,0,0,0,'搜',0,'搞',0, */
	/* 6420 */ 0,0,0xf4f7,0,0,0x8fadc6,0xd9ee,0, 0xd9f2,0x8fadc7,0,0,0xc8c2,0xc5eb,0,0x8fadc8, /* 0,0,'搢',0,0,'搥','搦',0, '搨','搩',0,0,'搬','搭',0,'搯', */
	/* 6430 */ 0,0,0,0,0xd9eb,0,0xd9ef,0, 0,0,0xb7c8,0,0,0,0xbaf1,0, /* 0,0,0,0,'搴',0,'搶',0, 0,0,'携',0,0,0,'搾',0, */
	/* 6440 */ 0,0,0xc0dd,0,0,0,0,0, 0,0,0,0,0,0,0xd9f7,0, /* 0,0,'摂',0,0,0,0,0, 0,0,0,0,0,0,'摎',0, */
	/* 6450 */ 0,0xf4f9,0,0,0,0,0,0, 0xc5a6,0,0x8fadc9,0x8fadca,0,0x8fadcb,0,0, /* 0,'摑',0,0,0,0,0,0, '摘',0,'摚','摛',0,'摝',0,0, */
	/* 6460 */ 0xf4fa,0,0,0,0,0,0,0xd9f4, 0,0xcbe0,0,0,0,0xf4fb,0,0xd9f5, /* '摠',0,0,0,0,0,0,'摧', 0,'摩',0,0,0,'摭',0,'摯', */
	/* 6470 */ 0,0,0,0x8fadcc,0,0,0xd9f6,0, 0xccce,0xf4f8,0xc0a2,0,0,0x8fadcd,0,0, /* 0,0,0,'摳',0,0,'摶',0, '摸','摹','摺',0,0,'摽',0,0, */
	/* 6480 */ 0,0,0,0xb7e2,0,0,0,0x8fadce, 0xd9fd,0,0,0,0,0,0,0, /* 0,0,0,'撃',0,0,0,'撇', '撈',0,0,0,0,0,0,0, */
	/* 6490 */ 0,0x8fadcf,0xbbb5,0xd9fa,0,0xd9f9,0,0, 0,0,0xc7b2,0,0,0x8fadd0,0xc6b5,0x8fadd1, /* 0,'撑','撒','撓',0,'撕',0,0, 0,0,'撚',0,0,'撝','撞','撟', */
	/* 64a0 */ 0,0,0,0,0xc5b1,0xd9fb,0,0, 0,0xd9fc,0,0xc9ef,0,0xc7c5,0xbba3,0, /* 0,0,0,0,'撤','撥',0,0, 0,'撩',0,'撫',0,'播','撮',0, */
	/* 64b0 */ 0xc0f1,0,0xcbd0,0,0,0,0,0, 0,0xb3c9,0,0xdaa5,0xd9fe,0,0xf4fd,0xf4fe, /* '撰',0,'撲',0,0,0,0,0, 0,'撹',0,'撻','撼',0,'撾','撿', */
	/* 64c0 */ 0,0xcdca,0xdaa7,0,0xf5a1,0xdaa3,0,0xdaa4, 0,0,0xf5a2,0x8fadd2,0x8fadd3,0xc1e0,0xf4fc,0, /* 0,'擁','擂',0,'擄','擅',0,'擇', 0,0,'擊','擋','擌','操','擎',0, */
	/* 64d0 */ 0xf5a3,0,0xdaa2,0,0xd9bf,0x8fadd4,0,0x8fadd5, 0xdaa6,0,0xdaa1,0,0,0,0,0, /* '擐',0,'擒',0,'擔','擕',0,'擗', '擘',0,'據',0,0,0,0,0, */
	/* 64e0 */ 0xdaab,0xdaac,0xc5a7,0xdaae,0x8fadd7,0x8fadd8,0xbba4,0xdaa9, 0,0,0,0,0xb5bc,0,0,0xdaaf, /* '擠','擡','擢','擣','擤','擥','擦','擧', 0,0,0,0,'擬',0,0,'擯', */
	/* 64f0 */ 0,0xdaa8,0xdab3,0,0xdab2,0,0xdab1,0xf5a4, 0,0,0xdab4,0xf5a5,0,0xdab6,0xbef1,0x8fadd9, /* 0,'擱','擲',0,'擴',0,'擶','擷', 0,0,'擺','擻',0,'擽','擾','擿', */
	/* 6500 */ 0xdab5,0,0,0,0x8fadda,0xdab9,0,0, 0,0,0,0,0,0,0,0x8faddc, /* '攀',0,0,0,'攄','攅',0,0, 0,0,0,0,0,0,0,'攏', */
	/* 6510 */ 0,0,0,0,0x8faddd,0,0x8fadde,0, 0xdab7,0,0,0,0xdab8,0xd9f0,0x8fade0,0, /* 0,0,0,0,'攔',0,'攖',0, '攘',0,0,0,'攜','攝','攞',0, */
	/* 6520 */ 0,0,0xf5a6,0xdabb,0xdaba,0,0,0, 0,0xf5a7,0xd9f8,0xdabc,0xdab0,0,0,0xbbd9, /* 0,0,'攢','攣','攤',0,0,0, 0,'攩','攪','攫','攬',0,0,'支', */
	/* 6530 */ 0,0,0x8fade1,0,0xdabd,0xdabe,0xdac0,0xdabf, 0xdac1,0xb2fe,0,0xb9b6,0,0,0xcafc,0xc0af, /* 0,0,'攲',0,'攴','攵','收','攷', '攸','改',0,'攻',0,0,'放','政', */
	/* 6540 */ 0,0,0,0,0x8fade2,0xb8ce,0,0, 0xdac3,0,0,0,0,0xdac6,0,0xc9d2, /* 0,0,0,0,'敄','故',0,0, '效',0,0,0,0,'敍',0,'敏', */
	/* 6550 */ 0,0xb5df,0,0,0x8fade3,0xdac5,0xdac4,0xc7d4, 0xdac7,0xb6b5,0,0,0,0xdac9,0xdac8,0, /* 0,'救',0,0,'敔','敕','敖','敗', '敘','教',0,0,0,'敝','敞',0, */
	/* 6560 */ 0,0,0xb4ba,0xbbb6,0,0,0xc6d8,0xf5a9, 0,0,0,0x8fade4,0xb7c9,0,0,0, /* 0,0,'敢','散',0,0,'敦','敧', 0,0,0,'敫','敬',0,0,0, */
	/* 6570 */ 0xbff4,0,0xdaca,0,0xc0b0,0xc5a8,0,0xc9df, 0xdacb,0,0x8fade5,0,0,0,0,0, /* '数',0,'敲',0,'整','敵',0,'敷', '數',0,'敺',0,0,0,0,0, */
	/* 6580 */ 0,0x8fade6,0xdacc,0xdacd,0x8fade7,0x8fade8,0,0xcab8, 0xd5dd,0xc0c6,0x8fade9,0,0xc9cc,0,0xbad8,0, /* 0,'斁','斂','斃','斄','斅',0,'文', '斈','斉','斊',0,'斌',0,'斎',0, */
	/* 6590 */ 0xc8e5,0xc8c3,0,0,0,0,0,0xc5cd, 0,0xcec1,0,0xdacf,0xbcd0,0xf5aa,0,0xdad0, /* '斐','斑',0,0,0,0,0,'斗', 0,'料',0,'斛','斜','斝',0,'斟', */
	/* 65a0 */ 0,0xb0b6,0,0,0xb6d4,0xc0cd,0,0xc9e0, 0,0,0,0xdad1,0xbbc2,0xc3c7,0,0xbbdb, /* 0,'斡',0,0,'斤','斥',0,'斧', 0,0,0,'斫','斬','断',0,'斯', */
	/* 65b0 */ 0xbfb7,0,0x8fadea,0,0,0x8fadeb,0,0xdad2, 0x8fadec,0xcafd,0,0,0xb1f7,0xbbdc,0,0x8faded, /* '新',0,'斲',0,0,'斵',0,'斷', '斸','方',0,0,'於','施',0,'斿', */
	/* 65c0 */ 0,0xdad5,0x8fadee,0xdad3,0xdad6,0xceb9,0xdad4,0, 0,0x8fadef,0,0xc0fb,0xdad7,0,0,0xc2b2, /* 0,'旁','旂','旃','旄','旅','旆',0, 0,'旉',0,'旋','旌',0,0,'族', */
	/* 65d0 */ 0,0,0xdad8,0,0x8fadf0,0,0,0xb4fa, 0,0xdada,0,0xdad9,0,0,0,0, /* 0,0,'旒',0,'旔',0,0,'旗', 0,'旙',0,'旛',0,0,0,0, */
	/* 65e0 */ 0xdadb,0xdadc,0xb4fb,0,0,0xc6fc,0xc3b6,0xb5ec, 0xbbdd,0xc1e1,0,0,0xbddc,0xb0b0,0,0, /* '无','旡','既',0,0,'日','旦','旧', '旨','早',0,0,'旬','旭',0,0, */
	/* 65f0 */ 0,0xdadd,0x8fadf2,0,0,0,0,0, 0,0x8fadf3,0xb2a2,0xdae1,0x8fadf4,0,0,0, /* 0,'旱','旲',0,0,0,0,0, 0,'旹','旺','旻','旼',0,0,0, */
	/* 6600 */ 0xf5ac,0,0xb9b7,0xdae0,0x8fadf5,0,0xbaab,0xbeba, 0x8fadf6,0xf5ad,0xdadf,0,0xbebb,0,0xccc0,0xbaaa, /* '昀',0,'昂','昃','昄',0,'昆','昇', '昈','昉','昊',0,'昌',0,'明','昏', */
	/* 6610 */ 0,0,0,0xb0d7,0xc0ce,0xf5ae,0,0, 0,0,0,0,0xdae6,0,0xf5af,0xc0b1, /* 0,0,0,'易','昔','昕',0,0, 0,0,0,0,'昜',0,'昞','星', */
	/* 6620 */ 0xb1c7,0x8fadf7,0xf5b1,0,0xf5b2,0xbdd5,0,0xcbe6, 0xbaf2,0,0x8fadf8,0xf5b3,0,0xbebc,0,0xc0a7, /* '映','昡','昢',0,'昤','春',0,'昧', '昨',0,'昪','昫',0,'昭',0,'是', */
	/* 6630 */ 0xf5b4,0xf5b5,0,0xf5b6,0xdae5,0xdae3,0xdae4,0, 0,0,0xf5b0,0,0xc3eb,0,0,0xdba6, /* '昰','昱',0,'昳','昴','昵','昶',0, 0,0,'昺',0,'昼',0,0,'昿', */
	/* 6640 */ 0,0xdaea,0xbbfe,0xb9b8,0xdae8,0x8fadf9,0,0, 0xf5b8,0xdae9,0,0xbfb8,0xf5b9,0,0x8fadfb,0xdae7, /* 0,'晁','時','晃','晄','晅',0,0, '晈','晉',0,'晋','晌',0,'晎','晏', */
	/* 6650 */ 0,0x8fadfa,0xbbaf,0,0,0,0,0x8fadfe, 0,0xf5bb,0xf5bc,0x8faea1,0,0xdaec,0xdaeb,0xdaf0, /* 0,'晑','晒',0,0,0,0,'晗', 0,'晙','晚','晛',0,'晝','晞','晟', */
	/* 6660 */ 0,0xf5bd,0xdaf1,0x8faea2,0xdaed,0xf5be,0xb3a2,0xdaee, 0xdaef,0xc8d5,0x8faea5,0x8faea6,0x8faea7,0x8faea8,0xc9e1,0xb7ca, /* 0,'晡','晢','晣','晤','晥','晦','晧', '晨','晩','晪','晫','晬','晭','普','景', */
	/* 6670 */ 0xdaf2,0,0,0xf5bf,0xc0b2,0,0xbebd,0xf5c0, 0xf5c1,0,0xc3d2,0x8faea9,0,0,0,0, /* '晰',0,0,'晳','晴',0,'晶','晷', '晸',0,'智','晻',0,0,0,0, */
	/* 6680 */ 0x8faeaa,0xb6c7,0,0xdaf3,0xdaf7,0,0,0xb2cb, 0xdaf4,0xdaf6,0,0,0,0xf5c2,0xdaf5,0, /* '暀','暁',0,'暃','暄',0,0,'暇', '暈','暉',0,0,0,'暍','暎',0, */
	/* 6690 */ 0x8faeab,0xbdeb,0x8faeac,0,0,0,0xc3c8,0xb0c5, 0xdaf8,0x8faead,0,0,0,0xdaf9,0,0, /* '暐','暑','暒',0,0,0,'暖','暗', '暘','暙',0,0,0,'暝',0,0, */
	/* 66a0 */ 0xf5c4,0,0xc4aa,0,0,0,0xcef1,0, 0,0,0,0xbbc3,0,0x8faeaf,0xcaeb,0, /* '暠',0,'暢',0,0,0,'暦',0, 0,0,0,'暫',0,'暭','暮',0, */
	/* 66b0 */ 0,0x8faeb0,0xf5c5,0,0xcbbd,0x8faeb1,0,0, 0xdba2,0xdafb,0,0xf5c6,0xdafe,0,0xdafd,0x8faeb3, /* 0,'暱','暲',0,'暴','暵',0,0, '暸','暹',0,'暻','暼',0,'暾','暿', */
	/* 66c0 */ 0,0xdafa,0,0,0xdba1,0,0xf5c7,0xc6de, 0xf5c8,0xdafc,0,0,0,0,0,0, /* 0,'曁',0,0,'曄',0,'曆','曇', '曈','曉',0,0,0,0,0,0, */
	/* 66d0 */ 0,0,0,0,0,0,0xdba3,0, 0,0xbdec,0xdba4,0xf5ca,0xcdcb,0xc7f8,0,0, /* 0,0,0,0,0,0,'曖',0, 0,'曙','曚','曛','曜','曝',0,0, */
	/* 66e0 */ 0xdba5,0,0,0,0,0,0xdba7,0, 0xf5cb,0xdba8,0,0,0x8faeb5,0,0,0, /* '曠',0,0,0,0,0,'曦',0, '曨','曩',0,0,'曬',0,0,0, */
	/* 66f0 */ 0xdba9,0,0xb6ca,0xb1c8,0xb9b9,0xdbaa,0,0xdbab, 0xbdf1,0xc1e2,0xf5cc,0xf5b7,0xd2d8,0xc1be,0xc1bd,0xc2d8, /* '曰',0,'曲','曳','更','曵',0,'曷', '書','曹','曺','曻','曼','曽','曾','替', */
	/* 6700 */ 0xbac7,0x8faeb7,0,0xd0f2,0,0x8faeb8,0,0, 0xb7ee,0xcdad,0,0xcafe,0,0xc9fe,0,0xdbac, /* '最','朁',0,'會',0,'朅',0,0, '月','有',0,'朋',0,'服',0,'朏', */
	/* 6710 */ 0,0,0x8faeb9,0xf5cd,0xbaf3,0xc4bf,0xdbad,0xcfaf, 0,0x8faebb,0,0xcbbe,0,0xc4ab,0xdbae,0xb4fc, /* 0,0,'朒','朓','朔','朕','朖','朗', 0,'朙',0,'望',0,'朝','朞','期', */
	/* 6720 */ 0,0,0,0,0,0,0xdbaf,0xdbb0, 0xccda,0,0xcca4,0xcbf6,0xcbdc,0xbba5,0xdbb2,0, /* 0,0,0,0,0,0,'朦','朧', '木',0,'未','末','本','札','朮',0, */
	/* 6730 */ 0,0xbceb,0,0xf5cf,0xcbd1,0,0xdbb4,0xdbb7, 0xdbb6,0,0xb4f9,0,0,0xb5e0,0,0xdbb3, /* 0,'朱',0,'朳','朴',0,'朶','朷', '朸',0,'机',0,0,'朽',0,'朿', */
	/* 6740 */ 0,0xdbb5,0,0,0,0,0xdbb8,0xf5d1, 0xf5d2,0xbff9,0,0,0x8faebe,0x8faebf,0xcdfb,0xb0c9, /* 0,'杁',0,0,0,0,'杆','杇', '杈','杉',0,0,'杌','杍','李','杏', */
	/* 6750 */ 0xbae0,0xc2bc,0,0xbcdd,0x8faec0,0,0xbef3,0, 0,0xdbbb,0,0,0xc5ce,0x8faec1,0xdbb9,0xc2ab, /* '材','村',0,'杓','杔',0,'杖',0, 0,'杙',0,0,'杜','杝','杞','束', */
	/* 6760 */ 0xdbba,0xbef2,0xccdd,0xdbbc,0xdbbd,0xcde8,0xf5d0,0, 0,0,0xdbc2,0,0,0xb9ba,0,0xc7d5, /* '杠','条','杢','杣','杤','来','杦',0, 0,0,'杪',0,0,'杭',0,'杯', */
	/* 6770 */ 0xdbbf,0xc5ec,0xdade,0xdae2,0x8faec5,0xb5cf,0x8faec6,0xc7c7, 0,0,0,0xf5d3,0xdbc1,0,0xbebe,0xc8c4, /* '杰','東','杲','杳','杴','杵','杶','杷', 0,0,0,'杻','杼',0,'松','板', */
	/* 6780 */ 0,0xf5d4,0,0,0,0xdbc7,0,0xc8fa, 0,0xdbbe,0,0xdbc4,0xdbc3,0,0,0, /* 0,'极',0,0,0,'枅',0,'枇', 0,'枉',0,'枋','枌',0,0,0, */
	/* 6790 */ 0xc0cf,0,0x8faec8,0xf5d5,0,0xcbed,0,0xced3, 0xf5d6,0,0xcbe7,0xf5d7,0xb2cc,0xbbde,0,0, /* '析',0,'枒','枓',0,'枕',0,'林', '枘',0,'枚','枛','果','枝',0,0, */
	/* 67a0 */ 0xcfc8,0xdbc6,0xbff5,0,0,0,0xdbc5,0, 0,0xdbc0,0,0,0,0,0,0xb8cf, /* '枠','枡','枢',0,0,0,'枦',0, 0,'枩',0,0,0,0,0,'枯', */
	/* 67b0 */ 0x8faecc,0,0x8faecd,0xdbcc,0xdbca,0,0xb2cd,0xdbc8, 0xdbce,0xdbd4,0,0xf5d8,0,0,0,0, /* '枰',0,'枲','枳','枴',0,'架','枷', '枸','枹',0,'枻',0,0,0,0, */
	/* 67c0 */ 0xf5da,0xc2c8,0,0x8faece,0xcac1,0,0xdbd6,0, 0x8faecf,0,0xc9a2,0,0,0,0xdbd5,0xc7f0, /* '柀','柁',0,'柃','柄',0,'柆',0, '柈',0,'柊',0,0,0,'柎','柏', */
	/* 67d0 */ 0xcbbf,0xb4bb,0x8faed0,0xc0f7,0xbdc0,0,0,0xf5db, 0xc4d3,0x8faed1,0xcdae,0x8faed2,0,0xdbd1,0xdbd0,0, /* '某','柑','柒','染','柔',0,0,'柗', '柘','柙','柚','柛',0,'柝','柞',0, */
	/* 67e0 */ 0,0,0xdbd2,0,0xdbcf,0,0,0xdbd7, 0,0xdbcd,0,0,0xdbcb,0,0xdbd3,0xdbc9, /* 0,0,'柢',0,'柤',0,0,'柧', 0,'柩',0,0,'柬',0,'柮','柯', */
	/* 67f0 */ 0x8faed3,0xc3ec,0,0xccf8,0xbcc6,0xbaf4,0,0x8faed4, 0,0xf5d9,0,0xbaba,0xf5dc,0,0xcbef,0xb3c1, /* '柰','柱',0,'柳','柴','柵',0,'柷', 0,'柹',0,'査','柼',0,'柾','柿', */
	/* 6800 */ 0,0xf5dd,0xc4ce,0xc6ca,0xb1c9,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'栁','栂','栃','栄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6810 */ 0x8faecb,0,0,0xc0f2,0,0,0xc0b4,0xb7aa, 0x8faed8,0,0,0,0,0xf5df,0xdbd9,0x8faed9, /* '栐',0,0,'栓',0,0,'栖','栗', '栘',0,0,0,0,'栝','栞','栟', */
	/* 6820 */ 0,0xb9bb,0xb3fc,0,0,0,0,0, 0,0xdbdb,0xb3f4,0xdbe1,0xf5e0,0x8faeda,0,0, /* 0,'校','栢',0,0,0,0,0, 0,'栩','株','栫','栬','栭',0,0, */
	/* 6830 */ 0,0xf5e1,0xdbde,0x8faedc,0xc0f3,0,0,0, 0xb3cb,0xbaac,0,0x8faedd,0xb3ca,0xbacf,0x8faede,0, /* 0,'栱','栲','栳','栴',0,0,0, '核','根',0,'栻','格','栽','栾',0, */
	/* 6840 */ 0xdbdc,0xb7e5,0xb7cb,0xc5ed,0x8faedf,0x8faee0,0xdbda,0, 0xb0c6,0x8faee1,0,0,0x8faee2,0xdbdd,0xdbdf,0, /* '桀','桁','桂','桃','桄','桅','框',0, '案','桉',0,0,'桌','桍','桎',0, */
	/* 6850 */ 0xb6cd,0xb7ac,0xf5de,0xb4bc,0xb5cb,0x8faee3,0,0x8faee4, 0,0xdbe2,0,0xf5e2,0xbaf9,0xcbf1,0,0xbbb7, /* '桐','桑','桒','桓','桔','桕',0,'桗', 0,'桙',0,'桛','桜','桝',0,'桟', */
	/* 6860 */ 0,0,0,0xdbe3,0,0,0,0xc9b0, 0,0,0,0x8faee6,0,0,0x8faee7,0, /* 0,0,0,'档',0,0,0,'桧', 0,0,0,'桫',0,0,'桮',0, */
	/* 6870 */ 0,0,0xf5e3,0,0xdbef,0xf5e4,0xb2b3,0xdbe4, 0,0,0x8faee8,0,0x8faee9,0,0xdbf5,0xdbe5, /* 0,0,'桲',0,'桴','桵','桶','桷', 0,0,'桺',0,'桼',0,'桾','桿', */
	/* 6880 */ 0,0xcec2,0x8faeea,0xdbec,0,0xc7df,0,0, 0,0,0,0,0,0xdbf4,0,0xdbe7, /* 0,'梁','梂','梃',0,'梅',0,0, 0,0,0,0,0,'梍',0,'梏', */
	/* 6890 */ 0x8faeeb,0,0,0xb0b4,0xdbe9,0,0x8faeec,0xb9bc, 0x8faeee,0x8faeef,0x8faef0,0xdbeb,0x8faef1,0xdbea,0,0xdbe6, /* '梐',0,0,'梓','梔',0,'梖','梗', '梘','梙','梚','梛','梜','條',0,'梟', */
	/* 68a0 */ 0xdbf1,0,0xbebf,0xf5e6,0,0xf5e7,0xd4ed,0xb8e8, 0xcdfc,0,0x8faef2,0x8faef3,0,0xdbe8,0,0xc4f4, /* '梠',0,'梢','梣',0,'梥','梦','梧', '梨',0,'梪','梫',0,'梭',0,'梯', */
	/* 68b0 */ 0xb3a3,0xbaad,0xf5e8,0xdbe0,0x8faef4,0xdbf0,0xb3e1,0, 0,0xdbee,0xdbf2,0x8faef5,0xc5ee,0,0,0, /* '械','梱','梲','梳','梴','梵','梶',0, 0,'梹','梺','梻','梼',0,0,0, */
	/* 68c0 */ 0,0,0,0x8faefa,0xb4fe,0x8faefb,0xdcb2,0, 0xf5e9,0xccc9,0xdbf7,0xb4fd,0x8faefc,0xdbfe,0,0x8faefd, /* 0,0,0,'棃','棄','棅','棆',0, '棈','棉','棊','棋','棌','棍',0,'棏', */
	/* 68d0 */ 0xf5ea,0,0xcbc0,0,0xdca1,0xdca3,0x8faefe,0xdca7, 0xdbf9,0x8fafa1,0xc3aa,0,0,0,0,0xc5ef, /* '棐',0,'棒',0,'棔','棕','棖','棗', '棘','棙','棚',0,0,0,0,'棟', */
	/* 68e0 */ 0xdcab,0xdbfc,0,0xdca8,0x8fafa2,0x8fafa3,0,0xdca2, 0xf5eb,0,0,0,0x8fafa4,0xf5ec,0xbfb9,0xdcac, /* '棠','棡',0,'棣','棤','棥',0,'棧', '棨',0,0,0,'棬','棭','森','棯', */
	/* 68f0 */ 0xf5ed,0xf5ee,0xc0b3,0,0,0,0,0x8fafa5, 0,0xdcaa,0xb4bd,0x8faef6,0xf5ef,0,0,0, /* '棰','棱','棲',0,0,0,0,'棷', 0,'棹','棺','棻','棼',0,0,0, */
	/* 6900 */ 0xcfd0,0xdbf6,0,0x8fafa6,0xdca6,0xb0d8,0,0x8fafa7, 0xdbf8,0,0xf5f0,0xccba,0xdbfd,0xbfa2,0xc4c7,0xdbf3, /* '椀','椁',0,'椃','椄','椅',0,'椇', '椈',0,'椊','椋','椌','植','椎','椏', */
	/* 6910 */ 0,0,0xdca5,0,0,0,0,0, 0,0xbffa,0xdcaf,0xb3f1,0xb8a1,0,0,0, /* 0,0,'椒',0,0,0,0,0, 0,'椙','椚','椛','検',0,0,0, */
	/* 6920 */ 0,0xdcb1,0xdbfa,0xdcb0,0,0xdca9,0xdbfb,0, 0xdcad,0,0xdcae,0,0,0,0,0, /* 0,'椡','椢','椣',0,'椥','椦',0, '椨',0,'椪',0,0,0,0,0, */
	/* 6930 */ 0xdcbf,0,0,0,0xc6ce,0xf5f3,0xdca4,0, 0,0xdcbb,0,0x8fafab,0,0xdcbd,0,0xc4d8, /* '椰',0,0,0,'椴','椵','椶',0, 0,'椹',0,'椻',0,'椽',0,'椿', */
	/* 6940 */ 0,0,0xf5f4,0,0,0,0x8fafad,0, 0,0xf5f1,0xcdcc,0,0,0,0,0, /* 0,0,'楂',0,0,0,'楆',0, 0,'楉','楊',0,0,0,0,0, */
	/* 6950 */ 0,0,0,0xc9f6,0xdcb8,0xc2ca,0,0xf5f5, 0,0xdcbe,0xc1bf,0,0xdcb5,0xdcc2,0xdcc1,0, /* 0,0,0,'楓','楔','楕',0,'楗', 0,'楙','楚',0,'楜','楝','楞',0, */
	/* 6960 */ 0xc6ef,0xdcc0,0xc6ea,0xf5f6,0xf5f7,0,0,0, 0xf5f8,0x8fafae,0xdcc4,0xdcb7,0x8fafaf,0xb6c8,0xdcba,0xbddd, /* '楠','楡','楢','楣','楤',0,0,0, '楨','楩','楪','楫','楬','業','楮','楯', */
	/* 6970 */ 0,0,0x8fafb0,0xc7e0,0xdcbc,0xb6cb,0,0xdcb4, 0xdcb6,0xdcb3,0x8fafb1,0,0xcfb0,0xb3da,0xdcb9,0x8fafb2, /* 0,0,'楲','楳','楴','極',0,'楷', '楸','楹','楺',0,'楼','楽','楾','楿', */
	/* 6980 */ 0xf5f9,0xdcc3,0xb3b5,0,0,0,0,0, 0,0,0xbae7,0,0,0,0xb1dd,0, /* '榀','榁','概',0,0,0,0,0, 0,0,'榊',0,0,0,'榎',0, */
	/* 6990 */ 0,0xdcd4,0x8fafb3,0,0xcfb1,0xdcd7,0x8fafb5,0, 0x8fafb6,0,0,0xbfba,0xdcd6,0,0,0, /* 0,'榑','榒',0,'榔','榕','榖',0, '榘',0,0,'榛','榜',0,0,0, */
	/* 69a0 */ 0xdcd5,0,0,0,0,0xf5fb,0x8fafb7,0xdcd2, 0,0,0,0,0,0xf5fc,0xdcc6,0, /* '榠',0,0,0,0,'榥','榦','榧', 0,0,0,0,0,'榭','榮',0, */
	/* 69b0 */ 0x8fafb8,0xdce3,0xdcc5,0,0xdcd8,0,0,0x8fafb9, 0,0,0x8fafba,0xdcd0,0x8fafbb,0,0xdccb,0xdcc8, /* '榰','榱','榲',0,'榴',0,0,'榷', 0,0,'榺','榻','榼',0,'榾','榿', */
	/* 69c0 */ 0x8fafbc,0xdcc9,0,0xdcd1,0,0,0,0xf4a2, 0,0,0xdcce,0xb9bd,0xc4c8,0xc1e4,0xdccc,0xf5fd, /* '槀','槁',0,'槃',0,0,0,'槇', 0,0,'槊','構','槌','槍','槎','槏', */
	/* 69d0 */ 0xdcc7,0x8fafbd,0,0xdcca,0,0,0x8fafbe,0, 0xcdcd,0xcbea,0,0,0,0xdccf,0xdcd9,0, /* '槐','槑',0,'槓',0,0,'槖',0, '様','槙',0,0,0,'槝','槞',0, */
	/* 69e0 */ 0,0,0xf6a2,0x8fafc4,0,0,0,0xdce1, 0xdcda,0xf6a3,0xf6a4,0xdce7,0,0xdce5,0x8fafc5,0x8fafc6, /* 0,0,'槢','槣',0,0,0,'槧', '槨','槩','槪','槫',0,'槭','槮','槯', */
	/* 69f0 */ 0,0,0xdce0,0x8fafc7,0x8fafc9,0xf6a5,0xf6a6,0, 0,0xdcdf,0,0xc4d0,0,0xc1e5,0x8fafca,0xdcdd, /* 0,0,'槲','槳','槴','槵','槶',0, 0,'槹',0,'槻',0,'槽','槾','槿', */
	/* 6a00 */ 0,0,0xdcdb,0,0,0xdce2,0,0, 0,0,0xdce8,0xc8f5,0xdcee,0,0,0xf6a7, /* 0,0,'樂',0,0,'樅',0,0, 0,0,'樊','樋','樌',0,0,'樏', */
	/* 6a10 */ 0,0x8fafcb,0xdce9,0xdcec,0xdce6,0xf6a8,0,0xc3f4, 0,0xc9b8,0x8fafcc,0xdcdc,0,0x8fafcd,0xdce4,0xbec0, /* 0,'樑','樒','樓','樔','樕',0,'樗', 0,'標','樚','樛',0,'樝','樞','樟', */
	/* 6a20 */ 0,0xcccf,0xdcf8,0xdceb,0,0,0,0, 0,0xb8a2,0xb2a3,0xb3df,0,0,0xdcd3,0, /* 0,'模','樢','樣',0,0,0,0, 0,'権','横','樫',0,0,'樮',0, */
	/* 6a30 */ 0x8fafc1,0,0x8fafcf,0x8fafd0,0x8fafd1,0xbec1,0xdcf0,0, 0xdcf7,0xbcf9,0xb3f2,0xf6aa,0,0xc3ae,0xf6ab,0x8fafd2, /* '樰',0,'樲','樳','樴','樵','樶',0, '樸','樹','樺','樻',0,'樽','樾','樿', */
	/* 6a40 */ 0,0,0,0,0xdced,0xf6ac,0x8fafd3,0xdcf2, 0xdcf6,0x8fafd4,0,0xb6b6,0,0,0x8fafd6,0, /* 0,0,0,0,'橄','橅','橆','橇', '橈','橉',0,'橋',0,0,'橎',0, */
	/* 6a50 */ 0xf6ad,0,0x8fafd7,0,0,0,0xf6ae,0, 0xb5cc,0xdcf4,0,0xf6af,0,0,0,0xb5a1, /* '橐',0,'橒',0,0,0,'橖',0, '橘','橙',0,'橛',0,0,0,'機', */
	/* 6a60 */ 0,0xc6cb,0xdcf3,0,0x8fafd8,0,0xdcf5,0, 0,0,0,0xf6b0,0,0,0,0, /* 0,'橡','橢',0,'橤',0,'橦',0, 0,0,0,'橫',0,0,0,0, */
	/* 6a70 */ 0,0,0xdcef,0xf6b1,0,0,0,0, 0xdcf1,0,0x8fafd5,0,0,0,0x8fafda,0xb3e0, /* 0,0,'橲','橳',0,0,0,0, '橸',0,'橺',0,0,0,'橾','橿', */
	/* 6a80 */ 0xc3c9,0,0,0x8fafdb,0xdcfc,0,0,0, 0,0xf6b3,0,0x8fafdc,0,0xdcfa,0xb8e9,0, /* '檀',0,0,'檃','檄',0,0,0, 0,'檉',0,'檋',0,'檍','檎',0, */
	/* 6a90 */ 0xdcf9,0x8fafde,0,0,0xf6b4,0,0,0xdda1, 0,0,0,0,0xdbd8,0xf6b5,0xf6b6,0x8fafdf, /* '檐','檑',0,0,'檔',0,0,'檗', 0,0,0,0,'檜','檝','檞','檟', */
	/* 6aa0 */ 0xdcfb,0x8fafe0,0xdcfd,0xdcfe,0,0xf6b7,0,0, 0,0,0xddac,0x8fafe2,0xdda8,0,0xdbed,0, /* '檠','檡','檢','檣',0,'檥',0,0, 0,0,'檪','檫','檬',0,'檮',0, */
	/* 6ab0 */ 0,0,0,0xdda7,0,0,0,0, 0xdda6,0,0,0xdda3,0,0x8fafe3,0,0, /* 0,0,0,'檳',0,0,0,0, '檸',0,0,'檻',0,'檽',0,0, */
	/* 6ac0 */ 0,0xdcea,0xdda5,0xdda4,0,0,0x8fafe4,0, 0,0,0,0,0,0,0,0, /* 0,'櫁','櫂','櫃',0,0,'櫆',0, 0,0,0,0,0,0,0,0, */
	/* 6ad0 */ 0x8fafe6,0xddaa,0,0xcfa6,0x8fafe5,0,0,0, 0,0,0xddad,0xb6fb,0x8fafe7,0x8fafe8,0xdda9,0xddab, /* '櫐','櫑',0,'櫓','櫔',0,0,0, 0,0,'櫚','櫛','櫜','櫝','櫞','櫟', */
	/* 6ae0 */ 0,0,0,0,0xf6b8,0,0,0xf6b9, 0xc8a7,0,0xddae,0,0x8fafeb,0,0,0, /* 0,0,0,0,'櫤',0,0,'櫧', '櫨',0,'櫪',0,'櫬',0,0,0, */
	/* 6af0 */ 0,0x8fafec,0x8fafed,0x8fafee,0,0,0,0, 0,0,0xddb2,0xddaf,0,0x8fafef,0,0, /* 0,'櫱','櫲','櫳',0,0,0,0, 0,0,'櫺','櫻',0,'櫽',0,0, */
	/* 6b00 */ 0,0,0,0,0xcdf3,0xddb0,0,0, 0,0,0xdcde,0x8faff1,0,0,0,0x8faff2, /* 0,0,0,0,'欄','欅',0,0, 0,0,'權','欋',0,0,0,'欏', */
	/* 6b10 */ 0x8faff3,0x8faff4,0xddb3,0,0,0,0xddb4,0x8faff6, 0,0,0,0xf6bc,0,0xb1b5,0xf6bd,0xddb6, /* '欐','欑','欒',0,0,0,'欖','欗', 0,0,0,'欛',0,'欝','欞','欟', */
	/* 6b20 */ 0xb7e7,0xbca1,0,0xb6d5,0,0,0,0xb2a4, 0,0,0,0,0xf6be,0,0,0x8faff8, /* '欠','次',0,'欣',0,0,0,'欧', 0,0,0,0,'欬',0,0,'欯', */
	/* 6b30 */ 0,0,0xcddf,0,0,0xf6bf,0,0xddb8, 0xddb7,0xddba,0xb5bd,0,0,0xb6d6,0xb4be,0, /* 0,0,'欲',0,0,'欵',0,'欷', '欸','欹','欺',0,0,'欽','款',0, */
	/* 6b40 */ 0,0,0,0xddbd,0,0,0xf6c0,0xddbc, 0,0xddbe,0x8faff9,0,0xb2ce,0,0xc3b7,0, /* 0,0,0,'歃',0,0,'歆','歇', 0,'歉','歊',0,'歌',0,'歎',0, */
	/* 6b50 */ 0xddbf,0,0,0xb4bf,0xddc1,0,0xf6c1,0, 0x8faffa,0xddc0,0,0xddc2,0,0,0,0xddc3, /* '歐',0,0,'歓','歔',0,'歖',0, '歘','歙',0,'歛',0,0,0,'歟', */
	/* 6b60 */ 0xf6c2,0xddc4,0xbbdf,0xc0b5,0xbaa1,0xf6c3,0xc9f0,0xf6c4, 0,0xcae2,0xcfc4,0,0x8faffb,0,0,0xbbf5, /* '歠','歡','止','正','此','步','武','歧', 0,'歩','歪',0,'歬',0,0,'歯', */
	/* 6b70 */ 0,0,0,0xbad0,0xcef2,0x8faffc,0,0xf6c5, 0xddc5,0xddc6,0x8faffd,0xbbe0,0,0,0,0xddc7, /* 0,0,0,'歳','歴','歵',0,'歷', '歸','歹','歺','死',0,0,0,'歿', */
	/* 6b80 */ 0xddc8,0x8faffe,0xf6c6,0xddca,0xddc9,0,0xcbd8,0, 0,0xbdde,0xbcec,0xbbc4,0,0xddcb,0,0, /* '殀','殁','殂','殃','殄',0,'殆',0, 0,'殉','殊','残',0,'殍',0,0, */
	/* 6b90 */ 0,0,0,0,0,0xddcd,0xbfa3,0, 0xddcc,0,0,0x8feea1,0,0,0xddce,0, /* 0,0,0,0,0,'殕','殖',0, '殘',0,0,'殛',0,0,'殞',0, */
	/* 6ba0 */ 0,0,0,0,0xddcf,0,0,0, 0,0xf6c7,0xddd0,0xddd1,0,0xf6c8,0x8feea2,0xddd2, /* 0,0,0,0,'殤',0,0,0, 0,'殩','殪','殫',0,'殭','殮','殯', */
	/* 6bb0 */ 0,0xddd4,0xddd3,0xddd5,0xb2a5,0xc3ca,0,0xddd6, 0,0,0xbba6,0xb3cc,0xddd7,0x8feea4,0x8feea5,0xc5c2, /* 0,'殱','殲','殳','殴','段',0,'殷', 0,0,'殺','殻','殼','殽','殾','殿', */
	/* 6bc0 */ 0xd4cc,0,0,0,0,0xb5a3,0xddd8,0x8feea6, 0x8feea7,0x8feea8,0,0xddd9,0,0xcaec,0xcbe8,0xf6ca, /* '毀',0,0,0,0,'毅','毆','毇', '毈','毉',0,'毋',0,'母','毎','每', */
	/* 6bd0 */ 0,0,0xc6c7,0xddda,0xc8e6,0,0xf6cb,0xf6cc, 0xc8fb,0,0x8feea9,0xccd3,0,0,0,0xdddb, /* 0,0,'毒','毓','比',0,'毖','毗', '毘',0,'毚','毛',0,0,0,'毟', */
	/* 6be0 */ 0,0,0,0,0,0,0x8feeaa,0x8feeab, 0,0,0,0xdddd,0xdddc,0,0x8feeac,0xdddf, /* 0,0,0,0,0,0,'毦','毧', 0,0,0,'毫','毬',0,'毮','毯', */
	/* 6bf0 */ 0,0x8feead,0,0xddde,0,0,0,0, 0,0,0,0,0,0,0,0xf6cd, /* 0,'毱',0,'毳',0,0,0,0, 0,0,0,0,0,0,0,'毿', */
	/* 6c00 */ 0,0,0x8feeae,0,0,0xf6ce,0,0, 0xdde1,0,0x8feeaf,0,0,0,0x8feeb0,0xbbe1, /* 0,0,'氂',0,0,'氅',0,0, '氈',0,'氊',0,0,0,'氎','氏', */
	/* 6c10 */ 0xf6cf,0xccb1,0,0xdde2,0xdde3,0,0,0xb5a4, 0,0,0,0xdde4,0,0,0,0, /* '氐','民',0,'氓','气',0,0,'気', 0,0,0,'氛',0,0,0,0, */
	/* 6c20 */ 0,0,0,0xdde6,0xdde5,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'氣','氤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c30 */ 0,0,0,0xf6d0,0xbfe5,0x8feeb1,0x8feeb2,0xc9b9, 0xb1ca,0,0x8feeb3,0,0,0,0xc8c5,0x8feeb5, /* 0,0,0,'氳','水','氵','氶','氷', '永',0,'氺',0,0,0,'氾','氿', */
	/* 6c40 */ 0xc4f5,0xbdc1,0xb5e1,0,0,0,0,0, 0,0,0,0,0,0x8feeb6,0xc8c6,0, /* '汀','汁','求',0,0,0,0,0, 0,0,0,0,0,'汍','汎',0, */
	/* 6c50 */ 0xbcae,0,0,0,0,0xdde8,0,0xb4c0, 0,0xf6d1,0xb1f8,0x8feeb7,0xf6d2,0xc6f2,0xdde7,0xb9be, /* '汐',0,0,0,0,'汕',0,'汗', 0,'汙','汚','汛','汜','汝','汞','江', */
	/* 6c60 */ 0xc3d3,0,0xdde9,0,0,0,0,0x8feecf, 0xddf1,0,0xddea,0,0,0x8feeb8,0,0, /* '池',0,'汢',0,0,0,0,'汧', '汨',0,'汪',0,0,'汭',0,0, */
	/* 6c70 */ 0xc2c1,0,0xb5e2,0xddf2,0xf6d4,0,0xf6d5,0, 0,0,0xb7e8,0,0,0xb5a5,0xddf0,0, /* '汰',0,'汲','汳','汴',0,'汶',0, 0,0,'決',0,0,'汽','汾',0, */
	/* 6c80 */ 0,0xddee,0xddeb,0xcde0,0x8feeb9,0xf6d6,0xf6d7,0, 0xc4c0,0x8feeba,0,0,0xc6d9,0xddec,0,0, /* 0,'沁','沂','沃','沄','沅','沆',0, '沈','沉',0,0,'沌','沍',0,0, */
	/* 6c90 */ 0xddf4,0,0xddf3,0xb7a3,0x8feebc,0x8feebd,0xb2ad,0x8feebe, 0xf6d8,0xbabb,0xdded,0xddef,0xf6d9,0,0,0, /* '沐',0,'沒','沓','沔','沕','沖','沗', '沘','沙','沚','沛','沜',0,0,0, */
	/* 6ca0 */ 0,0xcbd7,0xc2f4,0,0,0,0,0, 0,0,0xf6d3,0xcbf7,0,0x8feebf,0xddfc,0, /* 0,'没','沢',0,0,0,0,0, 0,0,'沪','沫',0,'沭','沮',0, */
	/* 6cb0 */ 0,0xddfd,0,0xb2cf,0,0,0,0, 0xcaa8,0xccfd,0xdea1,0xbca3,0xbec2,0xddf8,0xddfe,0xb1e8, /* 0,'沱',0,'河',0,0,0,0, '沸','油','沺','治','沼','沽','沾','沿', */
	/* 6cc0 */ 0,0xb6b7,0x8feec0,0,0xddf5,0xddfa,0xf6db,0, 0,0xc0f4,0xc7f1,0,0xc8e7,0,0,0, /* 0,'況','泂',0,'泄','泅','泆',0, 0,'泉','泊',0,'泌',0,0,0, */
	/* 6cd0 */ 0x8feec1,0,0,0xddf7,0xf6dc,0xcba1,0x8feec3,0xddf9, 0,0xdea4,0x8feec4,0xdea2,0x8feec5,0xddfb,0,0, /* '泐',0,0,'泓','泔','法','泖','泗', 0,'泙','泚','泛','泜','泝',0,0, */
	/* 6ce0 */ 0xf6dd,0xcba2,0xc7c8,0xb5e3,0,0xc5a5,0,0, 0xc3ed,0x8feec6,0xdea5,0xf6de,0x8feec7,0x8feec8,0xf6df,0xdea3, /* '泠','泡','波','泣',0,'泥',0,0, '注','泩','泪','泫','泬','泭','泮','泯', */
	/* 6cf0 */ 0xc2d9,0xddf6,0,0xb1cb,0,0,0,0, 0,0,0,0xf6da,0,0,0,0, /* '泰','泱',0,'泳',0,0,0,0, 0,0,0,'泻',0,0,0,0, */
	/* 6d00 */ 0x8feeca,0,0,0,0xf6e1,0,0,0, 0,0,0x8feecb,0xcdce,0xdeb0,0,0xf6e2,0, /* '洀',0,0,0,'洄',0,0,0, 0,0,'洊','洋','洌',0,'洎',0, */
	/* 6d10 */ 0,0,0xdeaf,0,0,0,0,0xc0f6, 0,0xdeac,0,0xcdec,0,0,0xc6b6,0xdea6, /* 0,0,'洒',0,0,0,0,'洗', 0,'洙',0,'洛',0,0,'洞','洟', */
	/* 6d20 */ 0,0,0,0,0x8feecc,0xc4c5,0x8feecd,0x8feece, 0,0xb1cc,0xb9bf,0xdea9,0,0,0xf6e3,0x8feed0, /* 0,0,0,0,'洤','津','洦','洧', 0,'洩','洪','洫',0,0,'洮','洯', */
	/* 6d30 */ 0,0xf6e4,0xbda7,0xdeae,0x8feee5,0xdead,0xdea8,0, 0xdeab,0xf6e5,0,0xb3e8,0x8feed1,0xdeaa,0xc7c9,0xf6e6, /* 0,'洱','洲','洳','洴','洵','洶',0, '洸','洹',0,'活','洼','洽','派','洿', */
	/* 6d40 */ 0,0xceae,0,0,0xbef4,0xc0f5,0,0, 0,0,0,0,0,0,0,0, /* 0,'流',0,0,'浄','浅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6d50 */ 0,0,0,0,0,0,0,0, 0xf6e7,0xdeb6,0xdeb4,0x8feed2,0xc9cd,0,0x8feed3,0, /* 0,0,0,0,0,0,0,0, '浘','浙','浚','浛','浜',0,'浞',0, */
	/* 6d60 */ 0x8feed4,0,0,0xdeb1,0xdeb3,0xf6e8,0xb1ba,0, 0,0xb9c0,0xcfb2,0,0xb3bd,0,0xc9e2,0, /* '浠',0,0,'浣','浤','浥','浦',0, 0,'浩','浪',0,'浬',0,'浮',0, */
	/* 6d70 */ 0x8feed5,0,0,0,0xcde1,0,0,0xb3a4, 0xbfbb,0xdeb5,0,0,0,0,0,0, /* '浰',0,0,0,'浴',0,0,'海', '浸','浹',0,0,0,0,0,0, */
	/* 6d80 */ 0x8feed6,0x8feed7,0xf6ea,0,0,0xdeba,0,0xf6eb, 0xbec3,0xf6ec,0x8feed8,0,0xcdb0,0x8feed9,0xdeb7,0, /* '涀','涁','涂',0,0,'涅',0,'涇', '消','涉','涊',0,'涌','涍','涎',0, */
	/* 6d90 */ 0,0x8feeda,0,0xdeb2,0xf6ed,0xdeb8,0,0, 0x8feedb,0xcede,0,0xc5f3,0xc6c2,0,0,0, /* 0,'涑',0,'涓','涔','涕',0,0, '涘','涙',0,'涛','涜',0,0,0, */
	/* 6da0 */ 0,0,0,0,0,0,0,0, 0,0,0xf6ee,0x8feee1,0xf6ef,0,0x8feee2,0xb3b6, /* 0,0,0,0,0,0,0,0, 0,0,'涪','涫','涬',0,'涮','涯', */
	/* 6db0 */ 0,0,0xb1d5,0,0x8feee3,0xdebe,0,0, 0xdec1,0,0,0,0xcec3,0,0,0xf6f0, /* 0,0,'液',0,'涴','涵',0,0, '涸',0,0,0,'涼',0,0,'涿', */
	/* 6dc0 */ 0xcde4,0,0x8feee4,0,0xf6f1,0xdec8,0xdec2,0xdebf, 0x8feee6,0,0,0xced4,0xdec5,0,0x8feee7,0x8feee8, /* '淀',0,'淂',0,'淄','淅','淆','淇', '淈',0,0,'淋','淌',0,'淎','淏', */
	/* 6dd0 */ 0x8feee9,0xbdca,0xdec7,0,0,0xdecc,0xf6f2,0, 0xc5f1,0xdeca,0xf6f3,0xf6f4,0,0xf6f5,0xdec4,0x8feeea, /* '淐','淑','淒',0,0,'淕','淖',0, '淘','淙','淚','淛',0,'淝','淞','淟', */
	/* 6de0 */ 0,0xc3b8,0,0,0xdecb,0,0xdec0,0, 0xdec6,0x8feeeb,0xdecd,0xb0fc,0xdec3,0,0xdece,0, /* 0,'淡',0,0,'淤',0,'淦',0, '淨','淩','淪','淫','淬',0,'淮',0, */
	/* 6df0 */ 0,0xbfbc,0,0xbddf,0,0xcaa5,0x8feeec,0xbaae, 0,0xdebb,0xdec9,0xc5ba,0xf6f6,0,0,0, /* 0,'深',0,'淳',0,'淵','淶','混', 0,'淹','淺','添','淼',0,0,0, */
	/* 6e00 */ 0,0,0,0,0,0xc0b6,0,0xb3e9, 0xbad1,0xbec4,0xdebd,0xbdc2,0,0,0,0, /* 0,0,0,0,0,'清',0,'渇', '済','渉','渊','渋',0,0,0,0, */
	/* 6e10 */ 0,0,0,0xb7cc,0,0xdebc,0,0x8feedd, 0,0xded2,0xbded,0xb8ba,0,0xdee1,0x8feeee,0xdedb, /* 0,0,0,'渓',0,'渕',0,'渗', 0,'渙','渚','減',0,'渝','渞','渟', */
	/* 6e20 */ 0xb5f4,0xc5cf,0x8feeef,0xded6,0xdedf,0xb0af,0xb1b2,0x8feef0, 0,0xb2b9,0,0xded8,0xc2ac,0xdecf,0xded1,0xb9c1, /* '渠','渡','渢','渣','渤','渥','渦','渧', 0,'温',0,'渫','測','渭','渮','港', */
	/* 6e30 */ 0,0,0x8feef2,0,0xf6f8,0,0x8feeed,0, 0xdee2,0,0xdedd,0,0x8feef3,0,0xded5,0, /* 0,0,'渲',0,'渴',0,'渶',0, '游',0,'渺',0,'渼',0,'渾',0, */
	/* 6e40 */ 0,0,0,0xdedc,0xf6f9,0,0,0, 0x8feef4,0x8feef5,0xccab,0x8feef6,0x8feef7,0xdeda,0xdede,0x8feef8, /* 0,0,0,'湃','湄',0,0,0, '湈','湉','湊','湋','湌','湍','湎','湏', */
	/* 6e50 */ 0,0x8feef9,0,0x8feefa,0x8feefb,0,0xb8d0,0x8feefc, 0xbec5,0,0,0xc3b9,0xf6fa,0,0xf6fb,0xded4, /* 0,'湑',0,'湓','湔',0,'湖','湗', '湘',0,0,'湛','湜',0,'湞','湟', */
	/* 6e60 */ 0,0,0,0x8feefd,0,0,0,0xcdaf, 0,0,0,0xded7,0,0,0xded0,0xc5f2, /* 0,0,0,'湣',0,0,0,'湧', 0,0,0,'湫',0,0,'湮','湯', */
	/* 6e70 */ 0,0,0xded3,0,0,0,0xded9,0, 0,0,0,0,0,0,0xcfd1,0xbcbe, /* 0,0,'湲',0,0,0,'湶',0, 0,0,0,0,0,0,'湾','湿', */
	/* 6e80 */ 0xcbfe,0,0xdee3,0,0,0,0,0, 0,0,0,0,0xc8ae,0,0,0xdeef, /* '満',0,'溂',0,0,0,0,0, 0,0,0,0,'溌',0,0,'溏', */
	/* 6e90 */ 0xb8bb,0,0,0x8fefa1,0,0,0xbde0,0, 0xdee5,0,0,0,0xceaf,0xb9c2,0,0xdef2, /* '源',0,0,'溓',0,0,'準',0, '溘',0,0,0,'溜','溝',0,'溟', */
	/* 6ea0 */ 0,0,0xb0ee,0,0,0xdef0,0,0x8fefa2, 0,0,0xdee4,0xf6fc,0,0,0,0xdeea, /* 0,0,'溢',0,0,'溥',0,'溧', 0,0,'溪','溫',0,0,0,'溯', */
	/* 6eb0 */ 0,0xf6fd,0xdeec,0,0x8fefa3,0,0xcdcf,0xdee7, 0,0,0xc5ae,0,0,0xdee9,0,0x8fefa4, /* 0,'溱','溲',0,'溴',0,'溶','溷', 0,0,'溺',0,0,'溽',0,'溿', */
	/* 6ec0 */ 0,0xf6fe,0xdef1,0x8fefa5,0xdeeb,0xccc7,0,0xf7a1, 0,0xdee6,0x8fefa6,0xbca2,0xdefe,0,0xf7a2,0, /* 0,'滁','滂','滃','滄','滅',0,'滇', 0,'滉','滊','滋','滌',0,'滎',0, */
	/* 6ed0 */ 0,0xb3ea,0,0xdee8,0xdeed,0xdeee,0,0, 0,0x8fefa7,0,0,0,0xc2ec,0xc2da,0, /* 0,'滑',0,'滓','滔','滕',0,0, 0,'滙',0,0,0,'滝','滞',0, */
	/* 6ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x8fefa9,0xdef6,0,0,0xdefc, /* 0,0,0,0,0,0,0,0, 0,0,0,'滫','滬',0,0,'滯', */
	/* 6ef0 */ 0,0,0xdefa,0,0xc5a9,0,0,0xdfa3, 0xdef7,0x8fefaa,0,0x8fefab,0,0,0xdef8,0xdee0, /* 0,0,'滲',0,'滴',0,0,'滷', '滸','滹',0,'滻',0,0,'滾','滿', */
	/* 6f00 */ 0,0xb5f9,0xc9ba,0,0,0,0xbcbf,0, 0,0xb9f7,0x8fefac,0,0x8fefad,0,0,0xcfb3, /* 0,'漁','漂',0,0,0,'漆',0, 0,'漉','漊',0,'漌',0,0,'漏', */
	/* 6f10 */ 0xf7a3,0xdef4,0,0xdfa2,0xb1e9,0xc1e6,0,0, 0x8fefae,0,0xf7a4,0,0,0,0,0, /* '漐','漑',0,'漓','演','漕',0,0, '漘',0,'漚',0,0,0,0,0, */
	/* 6f20 */ 0xc7f9,0,0xb4c1,0xcefa,0,0x8fefaf,0,0, 0,0,0xf7a6,0xcca1,0xc4d2,0,0,0xf7a7, /* '漠',0,'漢','漣',0,'漥',0,0, 0,0,'漪','漫','漬',0,0,'漯', */
	/* 6f30 */ 0,0xdefb,0xdefd,0xf7a8,0,0x8fefa8,0x8fefb0,0, 0xc1b2,0,0,0,0x8fefb1,0,0xdfa1,0xdef9, /* 0,'漱','漲','漳',0,'漵','漶',0, '漸',0,0,0,'漼',0,'漾','漿', */
	/* 6f40 */ 0,0xdef3,0,0,0,0xb4c3,0,0, 0,0,0,0,0,0,0,0, /* 0,'潁',0,0,0,'潅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6f50 */ 0,0xf7a9,0x8fefb3,0,0xb7e9,0,0,0x8fefb4, 0xdfaf,0xf7aa,0x8fefb5,0xdfaa,0xc0f8,0,0xf7ab,0xb3e3, /* 0,'潑','潒',0,'潔',0,0,'潗', '潘','潙','潚','潛','潜',0,'潞','潟', */
	/* 6f60 */ 0x8fefb6,0xf7ac,0xf7ad,0,0xbde1,0,0xdfb3,0, 0x8fefb7,0,0,0,0,0xdfac,0xc4ac,0xdfa9, /* '潠','潡','潢',0,'潤',0,'潦',0, '潨',0,0,0,0,'潭','潮','潯', */
	/* 6f70 */ 0xc4d9,0,0,0,0xdfcc,0,0,0, 0xdfa6,0,0xdfa5,0,0xdfae,0x8fefb9,0xf7ae,0, /* '潰',0,0,0,'潴',0,0,0, '潸',0,'潺',0,'潼','潽','潾',0, */
	/* 6f80 */ 0xdfa8,0xdfa7,0xdfad,0,0xc0a1,0,0xdfa4,0, 0xf7af,0,0,0,0xf7b0,0xf7b1,0xdfb0,0, /* '澀','澁','澂',0,'澄',0,'澆',0, '澈',0,0,0,'澌','澍','澎',0, */
	/* 6f90 */ 0x8fefba,0xdfb1,0,0,0xf7b2,0,0x8fefbb,0xb4c2, 0x8fefb8,0,0,0,0,0,0,0x8fefbd, /* '澐','澑',0,0,'澔',0,'澖','澗', '澘',0,0,0,0,0,0,'澟', */
	/* 6fa0 */ 0xf7b3,0xdfb6,0,0xdfb5,0xdfb7,0x8fefbe,0,0xf7b4, 0,0,0xdfba,0,0,0,0,0x8fefbf, /* '澠','澡',0,'澣','澤','澥',0,'澧', 0,0,'澪',0,0,0,0,'澯', */
	/* 6fb0 */ 0,0xc5c3,0,0xdfb4,0,0x8fefc1,0xf7b5,0, 0,0xdfb8,0,0,0xf7b6,0,0x8fefbc,0, /* 0,'澱',0,'澳',0,'澵','澶',0, 0,'澹',0,0,'澼',0,'澾',0, */
	/* 6fc0 */ 0xb7e3,0xc2f9,0xdfb2,0xc7bb,0,0,0xdfb9,0xf7b7, 0x8fefc2,0x8fefc3,0xf7b8,0,0,0,0,0, /* '激','濁','濂','濃',0,0,'濆','濇', '濈','濉','濊',0,0,0,0,0, */
	/* 6fd0 */ 0,0,0,0,0xdfbe,0xdfbc,0,0, 0xdfbf,0,0x8fefc4,0xdfc2,0,0,0x8fefc5,0xdfbb, /* 0,0,0,0,'濔','濕',0,0, '濘',0,'濚','濛',0,0,'濞','濟', */
	/* 6fe0 */ 0xb9ea,0xc7a8,0,0,0xdeb9,0,0,0, 0,0x8fefc6,0,0xcdf4,0xdfbd,0,0xdfc1,0xc2f5, /* '濠','濡',0,0,'濤',0,0,0, 0,'濩',0,'濫','濬',0,'濮','濯', */
	/* 6ff0 */ 0xf7ba,0xdfc0,0,0xdfab,0,0xf7bb,0xefe9,0, 0,0xf7b9,0xdfc5,0,0x8fefc8,0,0xdfc9,0, /* '濰','濱',0,'濳',0,'濵','濶',0, 0,'濹','濺',0,'濼',0,'濾',0, */
	/* 7000 */ 0x8fefc9,0xdfc7,0,0,0,0xf7bc,0xf7bd,0x8fefca, 0,0xdfc3,0x8fefcb,0xdfc4,0,0,0,0xdfc8, /* '瀀','瀁',0,0,0,'瀅','瀆','瀇', 0,'瀉','瀊','瀋',0,0,0,'瀏', */
	/* 7010 */ 0,0xdfc6,0,0,0,0xc9ce,0,0, 0xdfce,0,0xdfcb,0xdfca,0,0xdfcd,0xc6d4,0xdfcf, /* 0,'瀑',0,0,0,'瀕',0,0, '瀘',0,'瀚','瀛',0,'瀝','瀞','瀟', */
	/* 7020 */ 0,0,0,0x8fefcc,0,0,0xc3f5,0xc2ed, 0xf7be,0,0,0,0xc0a5,0,0,0, /* 0,0,0,'瀣',0,0,'瀦','瀧', '瀨',0,0,0,'瀬',0,0,0, */
	/* 7030 */ 0xdfd0,0,0xdfd2,0,0,0,0,0, 0,0x8fefce,0x8fefcf,0,0x8fefd0,0,0xdfd1,0, /* '瀰',0,'瀲',0,0,0,0,0, 0,'瀹','瀺',0,'瀼',0,'瀾',0, */
	/* 7040 */ 0,0,0,0x8fefd1,0,0,0,0x8fefd2, 0,0,0xf7bf,0x8fefd3,0xdef5,0,0xf7c2,0, /* 0,0,0,'灃',0,0,0,'灇', 0,0,'灊','灋','灌',0,'灎',0, */
	/* 7050 */ 0,0xdfd3,0,0,0x8fefd5,0,0,0, 0xc6e7,0,0,0,0,0xf7c0,0xf7c1,0, /* 0,'灑',0,0,'灔',0,0,0, '灘',0,0,0,0,'灝','灞',0, */
	/* 7060 */ 0,0,0,0xdfd4,0xf7c3,0x8fefd6,0,0, 0,0x8fefd7,0,0xb2d0,0x8fefd8,0,0x8fefd9,0xc5f4, /* 0,0,0,'灣','灤','灥',0,0, 0,'灩',0,'火','灬',0,'灮','灯', */
	/* 7070 */ 0xb3a5,0,0,0,0,0xf7c4,0x8fefda,0, 0xb5e4,0,0,0,0xbcde,0xbad2,0x8fefdb,0, /* '灰',0,0,0,0,'灵','灶',0, '灸',0,0,0,'灼','災','灾',0, */
	/* 7080 */ 0,0x8fefdc,0,0,0,0xf7c5,0x8fefdd,0, 0,0xcfa7,0xbfe6,0,0,0,0xb1ea,0, /* 0,'炁',0,0,0,'炅','炆',0, 0,'炉','炊',0,0,0,'炎',0, */
	/* 7090 */ 0,0,0xdfd6,0,0,0x8fefde,0,0x8fefdf, 0,0xdfd5,0,0,0,0,0,0x8fefe2, /* 0,0,'炒',0,0,'炕',0,'炗', 0,'炙',0,0,0,0,0,'炟', */
	/* 70a0 */ 0,0,0,0,0xf7c6,0,0,0, 0,0,0,0xf7c7,0xdfd9,0xc3ba,0xdfdc,0xdfd7, /* 0,0,0,0,'炤',0,0,0, 0,0,0,'炫','炬','炭','炮','炯', */
	/* 70b0 */ 0,0x8fefe3,0,0xdfdb,0,0,0,0xf7c8, 0xdfda,0xc5c0,0xb0d9,0x8fefe0,0,0,0,0, /* 0,'炱',0,'炳',0,0,0,'炷', '炸','点','為','炻',0,0,0,0, */
	/* 70c0 */ 0,0,0,0,0,0,0,0, 0xcef5,0,0x8fefe6,0xdfde,0,0,0,0xb1a8, /* 0,0,0,0,0,0,0,0, '烈',0,'烊','烋',0,0,0,'烏', */
	/* 70d0 */ 0,0x8fefe7,0,0x8fefe8,0xf7c9,0,0,0, 0xf7ca,0xdfe0,0,0,0x8fefe9,0xdfdf,0,0xdfdd, /* 0,'烑',0,'烓','烔',0,0,0, '烘','烙',0,0,'烜','烝',0,'烟', */
	/* 70e0 */ 0,0,0,0,0xf7cb,0,0,0, 0,0,0,0,0x8fefe5,0,0,0, /* 0,0,0,0,'烤',0,0,0, 0,0,0,0,'烬',0,0,0, */
	/* 70f0 */ 0,0xdfd8,0,0,0,0,0,0, 0,0xcba3,0,0,0,0xdfe2,0,0, /* 0,'烱',0,0,0,0,0,0, 0,'烹',0,0,0,'烽',0,0, */
	/* 7100 */ 0,0,0,0x8fefea,0x8fefeb,0,0x8fefec,0x8fefed, 0x8fefee,0xdfe1,0,0,0x8fefef,0,0,0xf7cc, /* 0,0,0,'焃','焄',0,'焆','焇', '焈','焉',0,0,'焌',0,0,'焏', */
	/* 7110 */ 0,0,0,0,0xb1eb,0,0,0, 0,0xdfe4,0xcab2,0,0xdfe3,0,0xf7ce,0, /* 0,0,0,0,'焔',0,0,0, 0,'焙','焚',0,'焜',0,'焞',0, */
	/* 7120 */ 0xf7cf,0xccb5,0,0,0,0,0xbec7,0, 0,0,0,0xf7cd,0,0,0xf7d0,0x8feff1, /* '焠','無',0,0,0,0,'焦',0, 0,0,0,'焫',0,0,'焮','焯', */
	/* 7130 */ 0xf7d1,0x8feff2,0,0,0,0,0xc1b3,0, 0,0,0,0,0xbec6,0,0,0, /* '焰','焱',0,0,0,0,'然',0, 0,0,0,0,'焼',0,0,0, */
	/* 7140 */ 0,0,0,0,0,0,0xf7d2,0xf7d3, 0,0xcefb,0x8feff4,0,0xdfea,0,0xc0f9,0, /* 0,0,0,0,0,0,'煆','煇', 0,'煉','煊',0,'煌',0,'煎',0, */
	/* 7150 */ 0x8feff3,0xf7d4,0xf7d6,0x8feff5,0,0xdfe6,0xdfeb,0, 0,0xb1ec,0,0,0xf7d7,0,0x8feff6,0, /* '煐','煑','煒','煓',0,'煕','煖',0, 0,'煙',0,0,'煜',0,'煞',0, */
	/* 7160 */ 0xf7d8,0,0xdfe9,0,0xc7e1,0xdfe5,0xdfe8,0xbec8, 0xf7d9,0xc8d1,0,0,0xdfec,0,0xbcd1,0, /* '煠',0,'煢',0,'煤','煥','煦','照', '煨','煩',0,0,'煬',0,'煮',0, */
	/* 7170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xc0fa,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'煽',0,0, */
	/* 7180 */ 0x8feff9,0,0,0,0xdfef,0xf7db,0,0xf7dc, 0xdfe7,0,0xb7a7,0,0,0,0,0xdfed, /* '熀',0,0,0,'熄','熅',0,'熇', '熈',0,'熊',0,0,0,0,'熏', */
	/* 7190 */ 0,0,0xf7dd,0,0xcdd0,0xdff0,0x8feff8,0, 0,0xf4a6,0,0x8feffa,0,0,0,0xbdcf, /* 0,0,'熒',0,'熔','熕','熖',0, 0,'熙',0,'熛',0,0,0,'熟', */
	/* 71a0 */ 0x8feffb,0,0x8feffc,0,0,0,0,0, 0xdff1,0,0,0,0xdff2,0,0x8feffd,0x8feffe, /* '熠',0,'熢',0,0,0,0,0, '熨',0,0,0,'熬',0,'熮','熯', */
	/* 71b0 */ 0,0xc7ae,0,0x8ff0a1,0,0,0,0, 0,0xdff4,0xf7df,0,0,0,0xdff5,0, /* 0,'熱',0,'熳',0,0,0,0, 0,'熹','熺',0,0,0,'熾',0, */
	/* 71c0 */ 0,0xf7de,0,0xc7b3,0xf7e0,0,0,0, 0xc5f5,0xdff7,0,0x8ff0a3,0,0,0xdff9,0, /* 0,'燁',0,'燃','燄',0,0,0, '燈','燉',0,'燋',0,0,'燎',0, */
	/* 71d0 */ 0xced5,0,0xdff6,0x8ff0a4,0xdff8,0xb1ed,0,0xdff3, 0,0x8ff0a5,0,0,0x8ff0a6,0,0,0xd3db, /* '燐',0,'燒','燓','燔','燕',0,'燗', 0,'燙',0,0,'燜',0,0,'營', */
	/* 71e0 */ 0xdffa,0,0,0,0,0xc1e7,0xbbb8,0xdffc, 0,0,0,0,0xdffb,0xbfa4,0xd2d9,0, /* '燠',0,0,0,0,'燥','燦','燧', 0,0,0,0,'燬','燭','燮',0, */
	/* 71f0 */ 0,0,0,0,0,0xdffd,0,0, 0,0xe0a1,0,0xdfee,0xdffe,0,0xf7e1,0xe0a2, /* 0,0,0,0,0,'燵',0,0, 0,'燹',0,'燻','燼',0,'燾','燿', */
	/* 7200 */ 0xf7e2,0,0,0,0,0,0xc7fa,0x8ff0a7, 0,0,0,0,0,0xe0a3,0,0, /* '爀',0,0,0,0,0,'爆','爇', 0,0,0,0,0,'爍',0,0, */
	/* 7210 */ 0xe0a4,0,0,0,0,0xf7e3,0,0, 0,0,0,0xe0a5,0,0,0,0, /* '爐',0,0,0,0,'爕',0,0, 0,0,0,'爛',0,0,0,0, */
	/* 7220 */ 0,0,0,0,0,0,0,0, 0xe0a6,0,0xc4de,0x8ff0aa,0xe0a8,0xe0a7,0,0, /* 0,0,0,0,0,0,0,0, '爨',0,'爪','爫','爬','爭',0,0, */
	/* 7230 */ 0xe0a9,0,0xe0aa,0,0x8ff0ab,0xbcdf,0xc9e3,0, 0x8ff0ac,0x8ff0ad,0xccec,0xe0ab,0xe0ac,0xc1d6,0xbca4,0xe0ad, /* '爰',0,'爲',0,'爴','爵','父',0, '爸','爹','爺','爻','爼','爽','爾','爿', */
	/* 7240 */ 0xe0ae,0,0x8ff0af,0,0,0,0xe0af,0xcad2, 0xc8c7,0,0,0xe0b0,0xc7d7,0,0,0, /* '牀',0,'牂',0,0,0,'牆','片', '版',0,0,'牋','牌',0,0,0, */
	/* 7250 */ 0,0,0xc4ad,0x8ff0b0,0,0xf7e4,0xf7e5,0x8ff0b1, 0xe0b1,0xb2e7,0,0xb5ed,0,0xccc6,0,0xccb6, /* 0,0,'牒','牓',0,'牕','牖','牗', '牘','牙',0,'牛',0,'牝',0,'牟', */
	/* 7260 */ 0,0xb2b4,0xcfb4,0x8ff0b2,0,0,0,0xcbd2, 0,0xcaaa,0,0,0,0,0x8ff0b4,0x8ff0b5, /* 0,'牡','牢','牣',0,0,0,'牧', 0,'物',0,0,0,0,'牮','牯', */
	/* 7270 */ 0,0,0xc0b7,0,0xe0b2,0,0,0, 0x8ff0b6,0xc6c3,0,0,0,0xb8a3,0xe0b3,0x8ff0b7, /* 0,0,'牲',0,'牴',0,0,0, '牸','特',0,0,0,'牽','牾','牿', */
	/* 7280 */ 0xbad4,0xe0b5,0xe0b4,0,0,0,0,0xe0b6, 0,0,0,0,0,0xf7e7,0x8ff0b8,0, /* '犀','犁','犂',0,0,0,0,'犇', 0,0,0,0,0,'犍','犎',0, */
	/* 7290 */ 0,0,0xe0b7,0,0,0,0xe0b8,0, 0,0,0,0xf7e8,0,0,0,0, /* 0,0,'犒',0,0,0,'犖',0, 0,0,0,'犛',0,0,0,0, */
	/* 72a0 */ 0xb5be,0,0xe0b9,0,0,0,0,0xe0ba, 0,0,0,0,0xb8a4,0x8ff0ba,0x8ff0bb,0xc8c8, /* '犠',0,'犢',0,0,0,0,'犧', 0,0,0,0,'犬','犭','犮','犯', */
	/* 72b0 */ 0x8ff0bc,0x8ff0bd,0xe0bc,0,0,0,0xbef5,0, 0,0xe0bb,0,0,0,0,0xf7e9,0, /* '犰','犱','犲',0,0,0,'状',0, 0,'犹',0,0,0,0,'犾',0, */
	/* 72c0 */ 0xf7ea,0x8ff0be,0xb6b8,0xe0bd,0xe0bf,0,0xe0be,0, 0,0,0,0,0x8ff0c0,0,0xe0c0,0, /* '狀','狁','狂','狃','狄',0,'狆',0, 0,0,0,0,'狌',0,'狎',0, */
	/* 72d0 */ 0xb8d1,0,0xe0c1,0,0,0,0,0xb6e9, 0,0xc1c0,0,0xb9fd,0,0,0,0, /* '狐',0,'狒',0,0,0,0,'狗', 0,'狙',0,'狛',0,0,0,0, */
	/* 72e0 */ 0xe0c3,0xe0c4,0xe0c2,0,0,0,0,0, 0,0xbced,0,0,0xc6c8,0xb6b9,0,0, /* '狠','狡','狢',0,0,0,0,0, 0,'狩',0,0,'独','狭',0,0, */
	/* 72f0 */ 0,0,0,0x8ff0c3,0,0,0,0xe0c6, 0xc3ac,0xe0c5,0x8ff0c4,0xf7eb,0xcfb5,0xc7e2,0,0, /* 0,0,0,'狳',0,0,0,'狷', '狸','狹','狺','狻','狼','狽',0,0, */
	/* 7300 */ 0,0,0,0,0,0,0,0x8ff0c5, 0,0,0xe0c9,0,0,0,0,0, /* 0,0,0,0,0,0,0,'猇', 0,0,'猊',0,0,0,0,0, */
	/* 7310 */ 0,0,0x8ff0c6,0,0,0,0xe0cb,0xe0c8, 0x8ff0c7,0x8ff0c8,0,0xccd4,0xe0ca,0xe0cc,0,0xcec4, /* 0,0,'猒',0,0,0,'猖','猗', '猘','猙',0,'猛','猜','猝',0,'猟', */
	/* 7320 */ 0,0,0,0,0,0xe0d0,0,0xf7ed, 0xf7ee,0xe0cf,0xc3f6,0xc7ad,0x8ff0cb,0,0xb8a5,0xe0ce, /* 0,0,0,0,0,'猥',0,'猧', '猨','猩','猪','猫','猬',0,'献','猯', */
	/* 7330 */ 0,0x8ff0cc,0,0x8ff0cd,0xe0cd,0,0xcdb1,0xcdb2, 0,0x8ff0ca,0,0,0,0x8ff0ce,0xe0d1,0xb1ee, /* 0,'猱',0,'猳','猴',0,'猶','猷', 0,'猹',0,0,0,'猽','猾','猿', */
	/* 7340 */ 0,0,0,0,0xb9f6,0xbbe2,0,0, 0,0,0,0,0,0,0xe0d2,0xe0d3, /* 0,0,0,0,'獄','獅',0,0, 0,0,0,0,0,0,'獎','獏', */
	/* 7350 */ 0xf7f0,0,0x8ff0cf,0,0,0,0,0xe0d5, 0,0,0,0,0,0,0,0, /* '獐',0,'獒',0,0,0,0,'獗', 0,0,0,0,0,0,0,0, */
	/* 7360 */ 0,0,0,0xbdc3,0,0,0xf7f1,0, 0xe0d7,0,0xe0d6,0x8ff0d1,0x8ff0d2,0,0x8ff0d4,0x8ff0d5, /* 0,0,0,'獣',0,0,'獦',0, '獨',0,'獪','獫','獬',0,'獮','獯', */
	/* 7370 */ 0xe0d8,0x8ff0d6,0xb3cd,0,0,0xe0da,0,0x8ff0d7, 0xe0d9,0,0xe0dc,0xe0db,0xf7f2,0,0,0, /* '獰','獱','獲',0,0,'獵',0,'獷', '獸',0,'獺','獻','獼',0,0,0, */
	/* 7380 */ 0,0x8ff0d8,0,0,0xb8bc,0x8ff0d9,0,0xcea8, 0,0xb6cc,0x8ff0da,0xb2a6,0,0,0,0, /* 0,'玁',0,0,'玄','玅',0,'率', 0,'玉','玊','王',0,0,0,0, */
	/* 7390 */ 0,0,0,0,0x8ff0db,0xf7f3,0xb6ea,0, 0x8ff0dc,0,0,0,0x8ff0dd,0,0x8ff0de,0xf7f4, /* 0,0,0,0,'玔','玕','玖',0, '玘',0,0,0,'玜',0,'玞','玟', */
	/* 73a0 */ 0xf7f5,0,0xf7f6,0,0,0x8ff0df,0xf7f7,0, 0x8ff0e0,0xb4e1,0,0xf7f8,0,0,0,0, /* '玠',0,'玢',0,0,'玥','玦',0, '玨','玩',0,'玫',0,0,0,0, */
	/* 73b0 */ 0,0,0xcee8,0xe0de,0,0x8ff0e1,0,0x8ff0e2, 0,0x8ff0e3,0,0xe0e0,0x8ff0e4,0,0,0x8ff0e5, /* 0,0,'玲','玳',0,'玵',0,'玷', 0,'玹',0,'玻','玼',0,0,'玿', */
	/* 73c0 */ 0xe0e1,0,0xb2d1,0,0,0x8ff0e6,0,0, 0xe0dd,0xf7f9,0xbbb9,0x8ff0e7,0,0xc4c1,0xe0df,0xf7fa, /* '珀',0,'珂',0,0,'珅',0,0, '珈','珉','珊','珋',0,'珍','珎','珏', */
	/* 73d0 */ 0,0,0,0,0,0,0xf7fb,0, 0,0xf7fc,0,0,0,0,0xe0e4,0, /* 0,0,0,0,0,0,'珖',0, 0,'珙',0,0,0,0,'珞',0, */
	/* 73e0 */ 0xbcee,0x8ff0e8,0,0xf7fd,0,0xe0e2,0,0x8ff0e9, 0,0xf7fe,0xb7be,0,0,0xc8c9,0xe0e3,0, /* '珠','珡',0,'珣',0,'珥',0,'珧', 0,'珩','珪',0,0,'班','珮',0, */
	/* 73f0 */ 0,0xe0fe,0,0,0,0,0,0, 0xe0e9,0x8ff0ea,0x8ff0ec,0,0,0,0xb8bd,0, /* 0,'珱',0,0,0,0,0,0, '珸','珹','珺',0,0,0,'現',0, */
	/* 7400 */ 0,0x8ff0ed,0,0xb5e5,0,0xe0e6,0xcdfd,0xf8a1, 0,0xceb0,0xf8a2,0,0,0,0,0, /* 0,'琁',0,'球',0,'琅','理','琇', 0,'琉','琊',0,0,0,0,0, */
	/* 7410 */ 0,0,0,0x8ff0eb,0,0,0,0, 0,0,0xf8a3,0xf8a4,0,0,0,0, /* 0,0,0,'琓',0,0,0,0, 0,0,'琚','琛',0,0,0,0, */
	/* 7420 */ 0,0,0xc2f6,0,0x8ff0ee,0xe0e8,0xf8a6,0, 0xf8a7,0,0xf8a8,0xf8a9,0xf8aa,0,0xf8ab,0xf8ac, /* 0,0,'琢',0,'琤','琥','琦',0, '琨',0,'琪','琫','琬',0,'琮','琯', */
	/* 7430 */ 0xf8ad,0x8ff0ef,0xe0ea,0xced6,0xb6d7,0xc8fc,0xc7ca,0, 0,0x8ff0f0,0xe0eb,0,0,0,0,0xe0ed, /* '琰','琱','琲','琳','琴','琵','琶',0, 0,'琹','琺',0,0,0,0,'琿', */
	/* 7440 */ 0x8ff0f2,0xe0f0,0,0x8ff0f3,0xf8ae,0,0xf8af,0xf8b0, 0,0,0,0xf8b1,0,0x8ff0f4,0,0, /* '瑀','瑁',0,'瑃','瑄',0,'瑆','瑇', 0,0,0,'瑋',0,'瑍',0,0, */
	/* 7450 */ 0,0,0x8ff0f5,0x8ff0f1,0,0xe0ec,0,0xf8b2, 0,0xe0ef,0xb8ea,0xb1cd,0xe0f1,0x8ff0f6,0xbff0,0xe0ee, /* 0,0,'瑒','瑓',0,'瑕',0,'瑗', 0,'瑙','瑚','瑛','瑜','瑝','瑞','瑟', */
	/* 7460 */ 0xcedc,0,0xf8b3,0xe0f4,0xf4a4,0,0,0, 0,0xe0f2,0xe0f5,0xf8b4,0,0xf8b5,0,0xe0e7, /* '瑠',0,'瑢','瑣','瑤',0,0,0, 0,'瑩','瑪','瑫',0,'瑭',0,'瑯', */
	/* 7470 */ 0xe0f3,0x8ff0f7,0,0xbabc,0,0,0xe0f6,0, 0,0,0,0,0,0,0xe0f7,0, /* '瑰','瑱',0,'瑳',0,0,'瑶',0, 0,0,0,0,0,0,'瑾',0, */
	/* 7480 */ 0,0x8ff0f8,0,0xcdfe,0,0x8ff0f9,0xf8b6,0xf8b7, 0x8ff0fa,0xf8b8,0,0xe0f8,0,0,0,0, /* 0,'璁',0,'璃',0,'璅','璆','璇', '璈','璉',0,'璋',0,0,0,0, */
	/* 7490 */ 0xf8bd,0,0x8ff0fc,0,0,0,0,0x8ff0fd, 0xf8b9,0x8ff0fe,0,0,0xf8ba,0,0xe0f9,0xf8bb, /* '璐',0,'璒',0,0,0,0,'璗', '璘','璙',0,0,'璜',0,'璞','璟', */
	/* 74a0 */ 0x8ff1a1,0x8ff1a2,0xe0e5,0xf8bc,0,0x8ff1a3,0xf8be,0xe0fa, 0xf8bf,0xf8c0,0x8ff1a4,0x8ff1a5,0,0,0,0, /* '璠','璡','璢','璣',0,'璥','璦','璧', '璨','璩','璪','璫',0,0,0,0, */
	/* 74b0 */ 0xb4c4,0,0,0,0,0xf8c1,0,0, 0,0x8ff1a6,0x8ff1a8,0x8ff1a7,0,0xbca5,0,0xf8c2, /* '環',0,0,0,0,'璵',0,0, 0,'璹','璺','璻',0,'璽',0,'璿', */
	/* 74c0 */ 0,0,0,0,0,0,0,0, 0xf8c3,0xf8c4,0xe0fb,0,0,0,0,0xe0fc, /* 0,0,0,0,0,0,0,0, '瓈','瓉','瓊',0,0,0,0,'瓏', */
	/* 74d0 */ 0,0,0,0,0xe0fd,0,0x8ff1a9,0, 0x8ff1aa,0,0xf8c5,0,0xb1bb,0,0x8ff1ab,0, /* 0,0,0,0,'瓔',0,'瓖',0, '瓘',0,'瓚',0,'瓜',0,'瓞',0, */
	/* 74e0 */ 0xe1a1,0,0xc9bb,0xe1a2,0,0,0xb4a4,0xe1a3, 0,0xe1a4,0,0x8ff1ad,0,0,0xe1a5,0x8ff1ac, /* '瓠',0,'瓢','瓣',0,0,'瓦','瓧', 0,'瓩',0,'瓫',0,0,'瓮','瓯', */
	/* 74f0 */ 0xe1a7,0xe1a8,0xe1a6,0,0,0,0xc9d3,0xe1aa, 0xe1a9,0,0x8ff1af,0,0,0,0,0xf8c6, /* '瓰','瓱','瓲',0,0,0,'瓶','瓷', '瓸',0,'瓺',0,0,0,0,'瓿', */
	/* 7500 */ 0,0xf8c7,0,0xe1ac,0xe1ab,0xe1ad,0,0, 0,0,0,0,0xe1ae,0xe1b0,0xe1af,0, /* 0,'甁',0,'甃','甄','甅',0,0, 0,0,0,0,'甌','甍','甎',0, */
	/* 7510 */ 0,0xb9f9,0,0xe1b2,0,0xe1b1,0,0xf8c8, 0xb4c5,0,0xbfd3,0,0xc5bc,0,0xe1b3,0xc0b8, /* 0,'甑',0,'甓',0,'甕',0,'甗', '甘',0,'甚',0,'甜',0,'甞','生', */
	/* 7520 */ 0x8ff1b1,0,0,0xbbba,0x8ff1b2,0xb1f9,0xe1b4,0, 0xcdd1,0,0x8ff1b3,0xcae3,0xe1b5,0,0,0xf8c9, /* '甠',0,0,'産','甤','甥','甦',0, '用',0,'甪','甫','甬',0,0,'甯', */
	/* 7530 */ 0xc5c4,0xcdb3,0xb9c3,0xbfbd,0,0,0,0xc3cb, 0xd2b4,0,0xc4ae,0xb2e8,0xe1b6,0x8ff1b6,0x8ff1b7,0, /* '田','由','甲','申',0,0,0,'男', '甸',0,'町','画','甼','甽','甾',0, */
	/* 7540 */ 0x8ff1b8,0,0,0,0xe1b7,0,0xe1bc,0, 0x8ff1b9,0xe1ba,0xe1b9,0xdac2,0xb3a6,0xe1b8,0x8ff1ba,0xb0da, /* '畀',0,0,0,'畄',0,'畆',0, '畈','畉','畊','畋','界','畍','畎','畏', */
	/* 7550 */ 0x8ff1bb,0xc8aa,0x8ff1bc,0,0xc8ca,0,0,0, 0,0xceb1,0xe1bd,0xe1bb,0xc3dc,0xc0a6,0,0, /* '畐','畑','畒',0,'畔',0,0,0, 0,'留','畚','畛','畜','畝',0,0, */
	/* 7560 */ 0xc8ab,0,0xc9ad,0,0xe1bf,0xceac,0xb7cd,0xe1c0, 0,0xe1be,0xc8d6,0xe1c1,0x8ff1bd,0xe1c2,0,0xf8ca, /* '畠',0,'畢',0,'畤','略','畦','畧', 0,'畩','番','畫','畬','畭',0,'畯', */
	/* 7570 */ 0xb0db,0x8ff1bf,0x8ff1be,0xbef6,0xe1c7,0,0xe1c4,0xc6ed, 0xe1c3,0xf8cb,0x8ff1c0,0,0,0x8ff1c1,0x8ff1c2,0xb5a6, /* '異','畱','畲','畳','畴',0,'當','畷', '畸','畹','畺',0,0,'畽','畾','畿', */
	/* 7580 */ 0,0x8ff1c3,0xe1ca,0,0,0,0xe1c5,0xe1c6, 0,0xe1c9,0xe1c8,0xc9a5,0x8ff1c5,0,0xc1c2,0xc1c1, /* 0,'疁','疂',0,0,0,'疆','疇', 0,'疉','疊','疋','疌',0,'疎','疏', */
	/* 7590 */ 0,0xb5bf,0xf8cc,0,0xe1cb,0,0,0, 0,0,0xe1cc,0,0,0xe1cd,0,0, /* 0,'疑','疒',0,'疔',0,0,0, 0,0,'疚',0,0,'疝',0,0, */
	/* 75a0 */ 0,0,0x8ff1c7,0xe1cf,0,0xe1ce,0,0, 0,0,0,0xb1d6,0,0,0,0, /* 0,0,'疢','疣',0,'疥',0,0, 0,0,0,'疫',0,0,0,0, */
	/* 75b0 */ 0x8ff1c9,0xe1d7,0xc8e8,0xe1d1,0,0xe1d3,0,0x8ff1ca, 0xe1d5,0xbfbe,0,0,0xe1d6,0xe1d4,0xbcc0,0x8ff1cb, /* '疰','疱','疲','疳',0,'疵',0,'疷', '疸','疹',0,0,'疼','疽','疾','疿', */
	/* 75c0 */ 0x8ff1cc,0,0xe1d0,0xe1d2,0,0xc9c2,0x8ff1cd,0xbec9, 0,0,0xe1d9,0,0,0xe1d8,0xf8ce,0x8ff1ce, /* '痀',0,'痂','痃',0,'病','痆','症', 0,0,'痊',0,0,'痍','痎','痏', */
	/* 75d0 */ 0,0,0xe1da,0x8ff1cf,0xbca6,0xbaaf,0,0, 0xc5f7,0xe1db,0,0xc4cb,0,0x8ff1d0,0xe1dd,0x8ff1d1, /* 0,0,'痒','痓','痔','痕',0,0, '痘','痙',0,'痛',0,'痝','痞','痟', */
	/* 75e0 */ 0x8ff1d2,0,0xcea1,0xe1dc,0xf8cf,0,0,0x8ff1d3, 0,0xc1e9,0,0,0x8ff1d4,0,0x8ff1d5,0, /* '痠',0,'痢','痣','痤',0,0,'痧', 0,'痩',0,0,'痬',0,'痮',0, */
	/* 75f0 */ 0xe1e2,0x8ff1d6,0xe1e4,0xe1e5,0xc3d4,0,0,0, 0,0x8ff1d7,0xe1e3,0,0xe1e0,0,0xe1de,0xe1df, /* '痰','痱','痲','痳','痴',0,0,0, 0,'痹','痺',0,'痼',0,'痾','痿', */
	/* 7600 */ 0xf8d0,0xe1e1,0xf8d1,0x8ff1d8,0,0,0,0x8ff1da, 0xf8d2,0xe1e8,0,0xe1e6,0,0xe1e7,0,0x8ff1db, /* '瘀','瘁','瘂','瘃',0,0,0,'瘇', '瘈','瘉',0,'瘋',0,'瘍',0,'瘏', */
	/* 7610 */ 0,0,0,0x8ff1de,0,0xf8d3,0xf8d4,0, 0x8ff1d9,0xf8d5,0,0x8ff1df,0x8ff1e0,0,0xf8d6,0xe1e9, /* 0,0,0,'瘓',0,'瘕','瘖',0, '瘘','瘙',0,'瘛','瘜',0,'瘞','瘟', */
	/* 7620 */ 0xe1eb,0xe1ec,0xe1ed,0,0xe1ee,0x8ff1e2,0xfefd,0xe1ea, 0x8ff1e3,0,0,0,0,0xf8d7,0,0, /* '瘠','瘡','瘢',0,'瘤','瘥','瘦','瘧', '瘨',0,0,0,0,'瘭',0,0, */
	/* 7630 */ 0xe1f0,0,0,0x8ff1e5,0xe1ef,0xf8d8,0,0, 0,0,0,0xe1f1,0x8ff1e4,0,0,0, /* '瘰',0,0,'瘳','瘴','瘵',0,0, 0,0,0,'瘻','瘼',0,0,0, */
	/* 7640 */ 0,0x8ff1e8,0xcec5,0xf8d9,0,0,0xe1f4,0xe1f2, 0xe1f3,0x8ff1ea,0,0xf8da,0xb4e2,0,0,0, /* 0,'癁','療','癃',0,0,'癆','癇', '癈','癉',0,'癋','癌',0,0,0, */
	/* 7650 */ 0,0,0xccfe,0,0,0x8ff1eb,0xcaca,0, 0xe1f6,0,0,0,0xe1f5,0,0,0, /* 0,0,'癒',0,0,'癕','癖',0, '癘',0,0,0,'癜',0,0,0, */
	/* 7660 */ 0,0xe1f7,0xe1f8,0,0xf8db,0xf8dc,0,0xe1fc, 0xe1f9,0xe1fa,0xe1fb,0,0xe1fd,0xf8dd,0x8ff1ed,0xf8de, /* 0,'癡','癢',0,'癤','癥',0,'癧', '癨','癩','癪',0,'癬','癭','癮','癯', */
	/* 7670 */ 0xe1fe,0xf8df,0xe2a1,0,0,0,0xe2a2,0, 0xe2a3,0,0xc8af,0xc5d0,0xe2a4,0xc7f2,0xc9b4,0, /* '癰','癱','癲',0,0,0,'癶',0, '癸',0,'発','登','發','白','百',0, */
	/* 7680 */ 0xe2a5,0xf8e0,0,0xe2a6,0xc5aa,0,0xb3a7,0xb9c4, 0xe2a7,0,0,0xe2a8,0,0,0xe2a9,0, /* '皀','皁',0,'皃','的',0,'皆','皇', '皈',0,0,'皋',0,0,'皎',0, */
	/* 7690 */ 0xbba9,0,0,0xe2ab,0,0x8ff1ee,0xe2aa,0, 0,0xe2ac,0xe2ad,0xf8e1,0x8ff1ef,0xf8e2,0xf8e3,0, /* '皐',0,0,'皓',0,'皕','皖',0, 0,'皙','皚','皛','皜','皝','皞',0, */
	/* 76a0 */ 0x8ff1f1,0x8ff1f0,0,0,0,0,0xf8e4,0x8ff1f2, 0x8ff1f3,0,0xf8e5,0,0,0,0xc8e9,0x8ff1f4, /* '皠','皡',0,0,0,0,'皦','皧', '皨',0,'皪',0,0,0,'皮','皯', */
	/* 76b0 */ 0xe2ae,0,0,0,0xe2af,0,0xf8e6,0xf3e9, 0xe2b0,0xe2b1,0xe2b2,0,0,0,0,0xbbae, /* '皰',0,0,0,'皴',0,'皶','皷', '皸','皹','皺',0,0,0,0,'皿', */
	/* 76c0 */ 0,0,0xe2b3,0xc7d6,0,0xf8e7,0xcbdf,0, 0xb1ce,0x8ff1f6,0xb1d7,0,0xf8e8,0xe2b4,0xf8e9,0, /* 0,0,'盂','盃',0,'盅','盆',0, '盈','盉','益',0,'盌','盍','盎',0, */
	/* 76d0 */ 0,0,0xe2b6,0,0xf8ea,0,0xe2b5,0xc5f0, 0,0,0,0xc0b9,0xddb9,0,0xe2b7,0xccc1, /* 0,0,'盒',0,'盔',0,'盖','盗', 0,0,0,'盛','盜',0,'盞','盟', */
	/* 76e0 */ 0,0xe2b8,0,0xb4c6,0xc8d7,0xe2b9,0xf8eb,0xe2ba, 0x8ff1f8,0,0xe2bb,0,0x8ff1f9,0,0xccdc,0, /* 0,'盡',0,'監','盤','盥','盦','盧', '盨',0,'盪',0,'盬',0,'目',0, */
	/* 76f0 */ 0,0xf8ec,0xccd5,0,0xc4be,0,0,0, 0xc1ea,0,0,0xe2bd,0xf8ed,0,0xbde2,0, /* 0,'盱','盲',0,'直',0,0,0, '相',0,0,'盻','盼',0,'盾',0, */
	/* 7700 */ 0,0xbeca,0,0,0xe2c0,0,0,0xe2bf, 0xe2be,0xc8fd,0xf8ee,0xb4c7,0xb8a9,0,0,0, /* 0,'省',0,0,'眄',0,0,'眇', '眈','眉','眊','看','県',0,0,0, */
	/* 7710 */ 0,0,0,0,0,0,0,0x8ff1fb, 0,0xf8ef,0x8ff1fc,0xe2c6,0,0,0xe2c3,0xbfbf, /* 0,0,0,0,0,0,0,'眗', 0,'眙','眚','眛',0,0,'眞','真', */
	/* 7720 */ 0xccb2,0,0,0,0xe2c2,0xe2c4,0xe2c5,0, 0,0xe2c1,0,0,0,0x8ff1fd,0,0, /* '眠',0,0,0,'眤','眥','眦',0, 0,'眩',0,0,0,'眭',0,0, */
	/* 7730 */ 0,0,0,0,0xf8f0,0x8ff1fe,0xf8f1,0xe2c7, 0xe2c8,0,0xc4af,0,0xb4e3,0,0,0, /* 0,0,0,0,'眴','眵','眶','眷', '眸',0,'眺',0,'眼',0,0,0, */
	/* 7740 */ 0xc3e5,0,0,0,0,0,0xf8f2,0xe2c9, 0,0,0,0,0,0xf8f3,0xf8f4,0, /* '着',0,0,0,0,0,'睆','睇', 0,0,0,0,0,'睍','睎',0, */
	/* 7750 */ 0,0,0,0,0,0,0,0, 0x8ff2a5,0,0xe2ca,0xe2cd,0xf8f5,0,0,0xf8f6, /* 0,0,0,0,0,0,0,0, '睘',0,'睚','睛','睜',0,0,'睟', */
	/* 7760 */ 0x8ff2a6,0xbfe7,0xf8f7,0xc6c4,0,0xe2ce,0xcbd3,0, 0xe2cb,0,0x8ff2a7,0xe2cc,0,0,0,0, /* '睠','睡','睢','督',0,'睥','睦',0, '睨',0,'睪','睫',0,0,0,0, */
	/* 7770 */ 0,0,0x8ff2a9,0,0,0,0,0, 0,0xe2d1,0xf8f8,0,0x8ff2aa,0x8ff2ab,0xe2d0,0xe2cf, /* 0,0,'睲',0,0,0,0,0, 0,'睹','睺',0,'睼','睽','睾','睿', */
	/* 7780 */ 0xf8f9,0,0,0,0,0,0,0, 0,0,0,0xe2d3,0,0,0xe2d2,0, /* '瞀',0,0,0,0,0,0,0, 0,0,0,'瞋',0,0,'瞎',0, */
	/* 7790 */ 0,0xe2d4,0,0,0xf8fa,0,0,0, 0,0,0x8ff2ae,0,0,0,0xe2d6,0x8ff2af, /* 0,'瞑',0,0,'瞔',0,0,0, 0,0,'瞚',0,0,0,'瞞','瞟', */
	/* 77a0 */ 0xe2d5,0,0x8ff2b0,0,0x8ff2b1,0xcacd,0,0, 0,0x8ff2b2,0xf8fb,0,0xbdd6,0xcec6,0,0, /* '瞠',0,'瞢',0,'瞤','瞥',0,0, 0,'瞩','瞪',0,'瞬','瞭',0,0, */
	/* 77b0 */ 0xe2d7,0,0,0xc6b7,0,0,0xe2d8,0, 0,0xe2d9,0,0xe2dd,0xe2db,0xe2dc,0,0xe2da, /* '瞰',0,0,'瞳',0,0,'瞶',0, 0,'瞹',0,'瞻','瞼','瞽',0,'瞿', */
	/* 77c0 */ 0,0,0,0,0,0,0,0xe2de, 0,0,0,0,0,0xe2df,0,0, /* 0,0,0,0,0,0,0,'矇', 0,0,0,0,0,'矍',0,0, */
	/* 77d0 */ 0,0,0,0,0,0,0,0xe2e0, 0,0,0xe2e1,0xccb7,0xe2e2,0,0x8ff2b3,0x8ff2b4, /* 0,0,0,0,0,0,0,'矗', 0,0,'矚','矛','矜',0,'矞','矟', */
	/* 77e0 */ 0xf8fc,0,0xccf0,0xe2e3,0x8ff2b5,0xc3ce,0x8ff2b6,0xc7ea, 0,0xb6eb,0x8ff2b7,0,0x8ff2b8,0xc3bb,0xe2e4,0xb6ba, /* '矠',0,'矢','矣','矤','知','矦','矧', 0,'矩','矪',0,'矬','短','矮','矯', */
	/* 77f0 */ 0x8ff2ba,0,0,0xc0d0,0x8ff2bb,0,0,0, 0,0,0,0x8ff2bc,0xe2e5,0,0,0, /* '矰',0,0,'石','矴',0,0,0, 0,0,0,'矻','矼',0,0,0, */
	/* 7800 */ 0,0,0xbabd,0,0,0x8ff2be,0x8ff2bf,0, 0,0x8ff2c0,0,0,0xe2e6,0x8ff2c1,0,0, /* 0,0,'砂',0,0,'砅','砆',0, 0,'砉',0,0,'砌','砍',0,0, */
	/* 7810 */ 0,0,0xe2e7,0,0xb8a6,0xbad5,0,0, 0,0x8ff2c2,0,0,0,0,0,0, /* 0,0,'砒',0,'研','砕',0,0, 0,'砙',0,0,0,0,0,0, */
	/* 7820 */ 0xe2e9,0x8ff2c3,0,0,0,0xc5d6,0xbad6,0xb5ce, 0,0,0,0,0x8ff2c4,0xf8fd,0,0, /* '砠','砡',0,0,0,'砥','砦','砧', 0,0,0,0,'砬','砭',0,0, */
	/* 7830 */ 0,0,0xcba4,0,0xc7cb,0,0,0, 0,0,0xc5d7,0,0,0,0,0xb9dc, /* 0,0,'砲',0,'破',0,0,0, 0,0,'砺',0,0,0,0,'砿', */
	/* 7840 */ 0,0,0,0xf9a1,0,0xe2eb,0,0x8ff2c5, 0,0,0,0,0,0,0xf9a2,0xf9a3, /* 0,0,0,'硃',0,'硅',0,'硇', 0,0,0,0,0,0,'硎','硏', */
	/* 7850 */ 0,0xf9a4,0,0,0,0,0,0, 0,0,0,0,0,0xbecb,0,0, /* 0,'硑',0,0,0,0,0,0, 0,0,0,0,0,'硝',0,0, */
	/* 7860 */ 0,0,0,0,0x8ff2c6,0,0,0, 0xf9a5,0,0x8ff2c7,0xceb2,0xb9c5,0,0xf9a6,0xb8a7, /* 0,0,0,0,'硤',0,0,0, '硨',0,'硪','硫','硬',0,'确','硯', */
	/* 7870 */ 0,0,0xc8a3,0,0xe2ed,0,0,0, 0,0,0,0,0xe2ef,0,0,0, /* 0,0,'硲',0,'硴',0,0,0, 0,0,0,0,'硼',0,0,0, */
	/* 7880 */ 0,0xb8eb,0,0,0,0,0xe2ee,0xc4f6, 0,0,0x8ff2c9,0,0xe2f1,0xb3b7,0xe2ec,0, /* 0,'碁',0,0,0,0,'碆','碇', 0,0,'碊',0,'碌','碍','碎',0, */
	/* 7890 */ 0,0xc8ea,0,0xb1b0,0x8ff2ca,0xbaec,0,0xcfd2, 0,0,0xe2f0,0,0,0x8ff2cc,0x8ff2cd,0x8ff2ce, /* 0,'碑',0,'碓','碔','碕',0,'碗', 0,0,'碚',0,0,'碝','碞','碟', */
	/* 78a0 */ 0,0,0,0xe2f2,0x8ff2cb,0,0,0xcacb, 0,0xc0d9,0xe2f4,0,0,0xf9aa,0,0xe2f5, /* 0,0,0,'碣','碤',0,0,'碧', 0,'碩','碪',0,0,'碭',0,'碯', */
	/* 78b0 */ 0xf9a8,0,0,0,0,0xe2f3,0,0, 0,0,0xb3ce,0x8ff2cf,0xe2fb,0,0xe2fa,0, /* '碰',0,0,0,0,'碵',0,0, 0,0,'確','碻','碼',0,'碾',0, */
	/* 78c0 */ 0,0xbca7,0,0,0,0xe2fc,0xe2f7,0, 0x8ff2d0,0,0xe2fd,0xe2f8,0x8ff2d1,0,0x8ff2d2,0, /* 0,'磁',0,0,0,'磅','磆',0, '磈',0,'磊','磋','磌',0,'磎',0, */
	/* 78d0 */ 0xc8d8,0xe2f6,0,0,0xe2f9,0x8ff2d3,0,0, 0,0,0xe3a2,0,0,0,0,0, /* '磐','磑',0,0,'磔','磕',0,0, 0,0,'磚',0,0,0,0,0, */
	/* 78e0 */ 0x8ff2d4,0x8ff2d5,0,0,0xf9ab,0,0x8ff2d6,0xe3a1, 0xcbe1,0,0,0,0xe2fe,0,0,0xb0eb, /* '磠','磡',0,0,'磤',0,'磦','磧', '磨',0,0,0,'磬',0,0,'磯', */
	/* 78f0 */ 0,0,0xf9ac,0,0xe3a4,0,0,0xf9ae, 0,0x8ff2d7,0x8ff2d8,0x8ff2d9,0,0xe3a3,0x8ff2da,0, /* 0,0,'磲',0,'磴',0,0,'磷', 0,'磹','磺','磻',0,'磽','磾',0, */
	/* 7900 */ 0xf9ad,0xbecc,0,0,0,0,0,0xe3a5, 0,0,0,0,0,0,0xc1c3,0, /* '礀','礁',0,0,0,0,0,'礇', 0,0,0,0,0,0,'礎',0, */
	/* 7910 */ 0x8ff2dc,0xe3a7,0xe3a6,0,0,0,0,0, 0,0xe3a8,0,0x8ff2dd,0xf9af,0,0,0, /* '礐','礑','礒',0,0,0,0,0, 0,'礙',0,'礛','礜',0,0,0, */
	/* 7920 */ 0,0,0,0,0,0x8ff2df,0xe2e8,0, 0,0,0xe2ea,0xe3aa,0xe3a9,0,0xf9b0,0, /* 0,0,0,0,0,'礥','礦',0, 0,0,'礪','礫','礬',0,'礮',0, */
	/* 7930 */ 0x8ff2de,0xf9b1,0,0,0xf9b2,0,0,0, 0,0,0xbca8,0x8ff2e0,0xcee9,0,0xbcd2,0, /* '礰','礱',0,0,'礴',0,0,0, 0,0,'示','礻','礼',0,'社',0, */
	/* 7940 */ 0xe3ab,0xb7b7,0,0,0,0xf9b5,0xf9b6,0xb5c0, 0xb5a7,0xbbe3,0x8ff2e1,0,0,0,0,0, /* '祀','祁',0,0,0,'祅','祆','祇', '祈','祉','祊',0,0,0,0,0, */
	/* 7950 */ 0xcdb4,0,0,0xe3b1,0,0xe3b0,0xc1c4,0xe3ad, 0x8ff2e2,0,0xe3af,0x8ff2e3,0xf9ba,0xbdcb,0xbfc0,0xe3ae, /* '祐',0,0,'祓',0,'祕','祖','祗', '祘',0,'祚','祛','祜','祝','神','祟', */
	/* 7960 */ 0xe3ac,0,0xc7aa,0,0,0xbecd,0,0x8ff2e5, 0xc9bc,0,0,0,0,0xbad7,0,0, /* '祠',0,'祢',0,0,'祥',0,'祧', '票',0,0,0,0,'祭',0,0, */
	/* 7970 */ 0,0,0x8ff2e6,0,0,0,0,0xc5f8, 0,0xf9be,0xe3b2,0,0,0,0,0xe3b3, /* 0,0,'祲',0,0,0,0,'祷', 0,'祹','祺',0,0,0,0,'祿', */
	/* 7980 */ 0xe3c9,0xb6d8,0,0,0xcfbd,0xc1b5,0,0, 0,0,0xe3b4,0,0,0xb2d2,0xc4f7,0xcaa1, /* '禀','禁',0,0,'禄','禅',0,0, 0,0,'禊',0,0,'禍','禎','福', */
	/* 7990 */ 0,0,0,0,0x8ff2e7,0x8ff2e8,0x8ff2e9,0, 0xf9c2,0,0,0x8ff2ea,0,0xe3b5,0,0, /* 0,0,0,0,'禔','禕','禖',0, '禘',0,0,'禛',0,'禝',0,0, */
	/* 79a0 */ 0,0x8ff2eb,0,0,0,0,0xb5fa,0xe3b6, 0,0x8ff2ec,0xe3b8,0,0,0,0xe3b9,0, /* 0,'禡',0,0,0,0,'禦','禧', 0,'禩','禪',0,0,0,'禮',0, */
	/* 79b0 */ 0xc7a9,0xf9c3,0,0xe3ba,0x8ff2ed,0,0,0, 0xf9c4,0xe3bb,0xe3bc,0x8ff2ee,0,0xb6d9,0xb2d3,0xc6c5, /* '禰','禱',0,'禳','禴',0,0,0, '禸','禹','禺','离',0,'禽','禾','禿', */
	/* 79c0 */ 0xbda8,0xbbe4,0x8ff2ef,0,0,0,0,0x8ff2f0, 0xf9c5,0xe3bd,0xf9c6,0xbda9,0x8ff2f1,0x8ff2f2,0,0, /* '秀','私','秂',0,0,0,0,'秇', '秈','秉','秊','秋','秌','种',0,0, */
	/* 79d0 */ 0,0xb2ca,0xc9c3,0,0xf9c8,0xe3be,0x8ff2f3,0, 0xc8eb,0,0,0,0,0,0xf9c9,0xc1c5, /* 0,'科','秒',0,'秔','秕','秖',0, '秘',0,0,0,0,0,'秞','租', */
	/* 79e0 */ 0,0xe3c1,0,0xe3c2,0xc7e9,0,0xbfc1,0xe3bf, 0,0xc3e1,0,0xf9ca,0xe3c0,0xf9cb,0,0, /* 0,'秡',0,'秣','秤',0,'秦','秧', 0,'秩',0,'秫','秬','秭',0,0, */
	/* 79f0 */ 0xbece,0,0,0,0,0,0,0, 0,0,0,0xb0dc,0,0,0,0, /* '称',0,0,0,0,0,0,0, 0,0,0,'移',0,0,0,0, */
	/* 7a00 */ 0xb5a9,0,0,0xf9cc,0,0,0,0, 0xe3c3,0,0x8ff2f8,0xc4f8,0,0xe3c4,0xc0c7,0, /* '稀',0,0,'稃',0,0,0,0, '稈',0,'稊','程',0,'稍','税',0, */
	/* 7a10 */ 0,0x8ff2f9,0,0,0xccad,0x8ff2fa,0,0xc9a3, 0xe3c5,0xe3c6,0xc3d5,0x8ff2fb,0xcec7,0,0x8ff2fc,0xe3c8, /* 0,'稑',0,0,'稔','稕',0,'稗', '稘','稙','稚','稛','稜',0,'稞','稟', */
	/* 7a20 */ 0xe3c7,0,0,0,0,0,0,0, 0,0,0,0,0,0x8ff2fe,0xbcef,0, /* '稠',0,0,0,0,0,0,0, 0,0,0,0,0,'稭','種',0, */
	/* 7a30 */ 0,0xe3ca,0xb0f0,0,0,0,0,0xe3cd, 0x8ff3a1,0xf9ce,0,0xe3cb,0xb2d4,0xb7ce,0xe3cc,0xb9c6, /* 0,'稱','稲',0,0,0,0,'稷', '稸','稹',0,'稻','稼','稽','稾','稿', */
	/* 7a40 */ 0xb9f2,0,0xcae6,0xe3ce,0,0,0xcbd4,0x8ff3a2, 0,0xe3d0,0,0,0x8ff3a3,0xc0d1,0xb1cf,0xb2ba, /* '穀',0,'穂','穃',0,0,'穆','穇', 0,'穉',0,0,'穌','積','穎','穏', */
	/* 7a50 */ 0xb0ac,0,0,0,0,0,0x8ff3a4,0xe3cf, 0,0x8ff3a5,0,0,0x8ff3a6,0xf9cf,0,0x8ff3a7, /* '穐',0,0,0,0,0,'穖','穗', 0,'穙',0,0,'穜','穝',0,'穟', */
	/* 7a60 */ 0x8ff3a8,0xe3d1,0xe3d2,0xbef7,0,0,0,0x8ff3a9, 0,0xe3d3,0x8ff3aa,0xb3cf,0,0xf9d0,0,0, /* '穠','穡','穢','穣',0,0,0,'穧', 0,'穩','穪','穫',0,'穭',0,0, */
	/* 7a70 */ 0xe3d5,0,0,0,0xb7ea,0x8ff3ab,0xb5e6,0, 0x8ff3ac,0xe3d6,0xb6f5,0,0,0xe3d7,0,0xc0fc, /* '穰',0,0,0,'穴','穵','究',0, '穸','穹','空',0,0,'穽',0,'穿', */
	/* 7a80 */ 0,0xc6cd,0x8ff3ad,0xc0e0,0xbaf5,0xf9d2,0,0, 0xe3d8,0,0x8ff3ae,0,0,0,0,0, /* 0,'突','窂','窃','窄','窅',0,0, '窈',0,'窊',0,0,0,0,0, */
	/* 7a90 */ 0x8ff3af,0,0xc3e2,0xc1eb,0,0xe3da,0xe3dc,0xe3d9, 0xe3db,0,0,0,0,0,0,0xb7a2, /* '窐',0,'窒','窓',0,'窕','窖','窗', '窘',0,0,0,0,0,0,'窟', */
	/* 7aa0 */ 0xf9d3,0,0,0x8ff3b0,0,0,0,0, 0,0xe3dd,0xb7a6,0,0x8ff3b1,0,0xb5e7,0xcdd2, /* '窠',0,0,'窣',0,0,0,0, 0,'窩','窪',0,'窬',0,'窮','窯', */
	/* 7ab0 */ 0xe3df,0,0,0xf9d5,0,0,0xe3e0,0, 0,0x8ff3b4,0xb1ae,0xf9d6,0x8ff3b5,0,0x8ff3b6,0xe3e3, /* '窰',0,0,'窳',0,0,'窶',0, 0,'窹','窺','窻','窼',0,'窾','窿', */
	/* 7ac0 */ 0,0,0,0xb3f6,0xe3e2,0xe3e1,0,0xe3e5, 0xe3de,0,0xe3e6,0xcea9,0x8ff3b8,0xe3e7,0xf9d7,0xe3e8, /* 0,0,0,'竃','竄','竅',0,'竇', '竈',0,'竊','立','竌','竍','竎','竏', */
	/* 7ad0 */ 0,0x8ff3b9,0xd4f4,0xe3ea,0,0xe3e9,0,0, 0,0xe3eb,0xe3ec,0,0xceb5,0xe3ed,0,0xf0ef, /* 0,'竑','竒','竓',0,'竕',0,0, 0,'站','竚',0,'竜','竝',0,'竟', */
	/* 7ae0 */ 0xbecf,0xe3ee,0xe3ef,0xbdd7,0,0xc6b8,0xe3f0,0x8ff3ba, 0x8ff3bb,0,0xc3a8,0xf9d8,0,0xe3f1,0,0xc3bc, /* '章','竡','竢','竣',0,'童','竦','竧', '竨',0,'竪','竫',0,'竭',0,'端', */
	/* 7af0 */ 0xe3f2,0,0,0,0x8ff3bc,0,0xb6a5,0, 0xd1bf,0xc3dd,0xbcb3,0,0,0xf9d9,0,0xb4c8, /* '竰',0,0,0,'竴',0,'競',0, '竸','竹','竺',0,0,'竽',0,'竿', */
	/* 7b00 */ 0,0,0xe3f3,0,0xe4a2,0,0xe3f6,0x8ff3bf, 0xb5e8,0,0xe3f5,0xe4a4,0,0,0,0xe3f4, /* 0,0,'笂',0,'笄',0,'笆','笇', '笈',0,'笊','笋',0,0,0,'笏', */
	/* 7b10 */ 0,0xbed0,0xf9da,0,0,0,0,0, 0xe3f8,0xe3f9,0,0xc5ab,0,0,0xe3fa,0, /* 0,'笑','笒',0,0,0,0,0, '笘','笙',0,'笛',0,0,'笞',0, */
	/* 7b20 */ 0xb3de,0,0,0,0,0xbfda,0xc9e4,0x8ff3c2, 0xe3fc,0,0x8ff3c3,0,0xc2e8,0xf9db,0x8ff3c4,0x8ff3c5, /* '笠',0,0,0,0,'笥','符','笧', '笨',0,'笪',0,'第','笭','笮','笯', */
	/* 7b30 */ 0,0x8ff3c6,0,0xe3f7,0,0xe3fb,0xe3fd,0, 0,0xbafb,0,0xf9dc,0,0x8ff3c1,0,0, /* 0,'笱',0,'笳',0,'笵','笶',0, 0,'笹',0,'笻',0,'笽',0,0, */
	/* 7b40 */ 0,0x8ff3ca,0,0,0,0xe4a6,0xc9ae,0xf9dd, 0xc8a6,0xc5f9,0,0xb6da,0xe4a5,0xe4a3,0xf9de,0xc8b5, /* 0,'筁',0,0,0,'筅','筆','筇', '筈','等',0,'筋','筌','筍','筎','筏', */
	/* 7b50 */ 0xe3fe,0xc3de,0xc5fb,0,0xc5fa,0x8ff3cc,0xbaf6,0, 0,0,0,0,0,0xe4b8,0,0, /* '筐','筑','筒',0,'答','筕','策',0, 0,0,0,0,0,'筝',0,0, */
	/* 7b60 */ 0xf9df,0,0,0,0x8ff3ce,0xe4a8,0x8ff3cf,0xe4aa, 0,0x8ff3d0,0,0,0xe4ad,0xf9e0,0xe4ae,0xf9e1, /* '筠',0,0,0,'筤','筥','筦','筧', 0,'筩',0,0,'筬','筭','筮','筯', */
	/* 7b70 */ 0xe4ab,0xe4ac,0xf9e2,0x8ff3d1,0xe4a9,0xe4a7,0,0, 0,0x8ff3cd,0xe4a1,0,0,0,0,0x8ff3c9, /* '筰','筱','筲','筳','筴','筵',0,0, 0,'筹','筺',0,0,0,0,'筿', */
	/* 7b80 */ 0,0,0,0,0,0,0xcacf,0xb2d5, 0,0,0,0xe4b5,0,0xe4b2,0,0xe4b7, /* 0,0,0,0,0,0,'箆','箇', 0,0,0,'箋',0,'箍',0,'箏', */
	/* 7b90 */ 0x8ff3d4,0x8ff3d5,0xe4b6,0,0xc7f3,0xcca7,0,0xbbbb, 0xe4b0,0xe4b9,0xe4b4,0x8ff3d6,0xe4b3,0xe4af,0xf9e3,0xe4b1, /* '箐','箑','箒',0,'箔','箕',0,'算', '箘','箙','箚','箛','箜','箝','箞','箟', */
	/* 7ba0 */ 0,0xb4c9,0,0,0,0,0,0, 0,0,0xc3bd,0,0,0xc0fd,0,0x8ff3d8, /* 0,'管',0,0,0,0,0,0, 0,0,'箪',0,0,'箭',0,'箯', */
	/* 7bb0 */ 0,0xc8a2,0,0,0xe4be,0x8ff3d9,0,0, 0xc8a4,0,0,0,0x8ff3da,0,0,0, /* 0,'箱',0,0,'箴','箵',0,0, '箸',0,0,0,'箼',0,0,0, */
	/* 7bc0 */ 0xc0e1,0xe4bb,0,0,0xc8cf,0x8ff3db,0xe4bf,0xcad3, 0,0xc3db,0x8ff3dc,0xe4ba,0xe4bc,0,0,0xe4bd, /* '節','篁',0,0,'範','篅','篆','篇', 0,'築','篊','篋','篌',0,0,'篏', */
	/* 7bd0 */ 0,0,0,0,0x8ff3df,0,0x8ff3e0,0xf9e5, 0,0xf9e6,0x8ff3e1,0,0,0xe4c0,0,0, /* 0,0,0,0,'篔',0,'篖','篗', 0,'篙','篚',0,0,'篝',0,0, */
	/* 7be0 */ 0xbcc4,0,0,0,0xc6c6,0xe4c5,0xe4c4,0, 0,0xe4c1,0x8ff3e2,0,0,0xcfb6,0,0, /* '篠',0,0,0,'篤','篥','篦',0, 0,'篩','篪',0,0,'篭',0,0, */
	/* 7bf0 */ 0x8ff3e3,0,0,0xe4ca,0,0,0xe4ce,0xe4cb, 0,0,0,0,0,0,0,0, /* '篰',0,0,'篳',0,0,'篶','篷', 0,0,0,0,0,0,0,0, */
	/* 7c00 */ 0xe4c7,0xf9e7,0,0x8ff3e4,0,0,0,0xe4c8, 0,0,0,0x8ff3e5,0,0xe4cd,0x8ff3e6,0x8ff3e7, /* '簀','簁',0,'簃',0,0,0,'簇', 0,0,0,'簋',0,'簍','簎','簏', */
	/* 7c10 */ 0,0xe4c2,0xd2d5,0xe4c9,0xe4c3,0,0,0xe4cc, 0,0,0,0,0,0,0xf9e9,0xe4d2, /* 0,'簑','簒','簓','簔',0,0,'簗', 0,0,0,0,0,0,'簞','簟', */
	/* 7c20 */ 0xf9ea,0xb4ca,0,0xe4cf,0,0,0x8ff3e8,0xe4d0, 0,0,0xe4d1,0xe4d4,0,0,0,0, /* '簠','簡',0,'簣',0,0,'簦','簧', 0,0,'簪','簫',0,0,0,0, */
	/* 7c30 */ 0,0xf9e8,0,0xf9eb,0,0,0xf9ec,0xe4d3, 0xc8f6,0,0,0,0,0xe4d5,0xcefc,0xcaed, /* 0,'簱',0,'簳',0,0,'簶','簷', '簸',0,0,0,0,'簽','簾','簿', */
	/* 7c40 */ 0xe4da,0,0,0xe4d7,0,0x8ff3e9,0,0, 0,0,0x8ff3ea,0,0xe4d6,0xc0d2,0,0xe4d9, /* '籀',0,0,'籃',0,'籅',0,0, 0,0,'籊',0,'籌','籍',0,'籏', */
	/* 7c50 */ 0xe4db,0x8ff3eb,0,0,0xe4d8,0,0xe4df,0x8ff3ec, 0xe4dc,0xf9ef,0,0,0,0,0x8ff3ed,0xe4dd, /* '籐','籑',0,0,'籔',0,'籖','籗', '籘','籙',0,0,0,0,'籞','籟', */
	/* 7c60 */ 0xe4c6,0x8ff3ee,0,0,0xe4de,0xe4e0,0,0, 0,0x8ff3ef,0,0,0xe4e1,0xf9f0,0x8ff3f0,0x8ff3f1, /* '籠','籡',0,0,'籤','籥',0,0, 0,'籩',0,0,'籬','籭','籮','籯', */
	/* 7c70 */ 0x8ff3f2,0,0,0xcac6,0,0xe4e2,0,0, 0,0xf9f1,0,0,0,0,0xcce2,0, /* '籰',0,0,'米',0,'籵',0,0, 0,'籹',0,0,0,0,'籾',0, */
	/* 7c80 */ 0,0xb6ce,0xb7a9,0xe4e3,0,0,0,0, 0,0xcab4,0,0xbfe8,0,0xccb0,0,0xf9f2, /* 0,'粁','粂','粃',0,0,0,0, 0,'粉',0,'粋',0,'粍',0,'粏', */
	/* 7c90 */ 0xe4e4,0,0xceb3,0,0xf9f3,0xc7f4,0,0xc1c6, 0xc7b4,0,0,0xbdcd,0,0,0,0xb0c0, /* '粐',0,'粒',0,'粔','粕',0,'粗', '粘',0,0,'粛',0,0,0,'粟', */
	/* 7ca0 */ 0xf9f4,0xe4e9,0xe4e7,0,0xe4e5,0xb4a1,0x8ff3f6,0xbed1, 0xe4ea,0,0,0xe4e8,0,0xe4e6,0xe4ee,0, /* '粠','粡','粢',0,'粤','粥','粦','粧', '粨',0,0,'粫',0,'粭','粮',0, */
	/* 7cb0 */ 0,0xe4ed,0xe4ec,0xe4eb,0,0,0x8ff3f8,0x8ff3f9, 0,0xe4ef,0,0,0xf9f5,0xe4f0,0xc0ba,0x8ff3fa, /* 0,'粱','粲','粳',0,0,'粶','粷', 0,'粹',0,0,'粼','粽','精','粿', */
	/* 7cc0 */ 0xe4f1,0,0xe4f3,0,0x8ff3fc,0xe4f2,0,0, 0x8ff3fe,0,0xb8d2,0,0,0x8ff4a1,0xc1b8,0, /* '糀',0,'糂',0,'糄','糅',0,0, '糈',0,'糊',0,0,'糍','糎',0, */
	/* 7cd0 */ 0,0,0xe4f5,0,0,0xf9f6,0xc5fc,0x8ff4a3, 0xe4f4,0xf9f7,0,0,0xe4f6,0xf9f8,0xcab5,0xc1ec, /* 0,0,'糒',0,0,'糕','糖','糗', '糘','糙',0,0,'糜','糝','糞','糟', */
	/* 7ce0 */ 0xb9c7,0,0xe4f7,0,0,0,0x8ff4a5,0xcec8, 0,0,0,0x8ff4a6,0,0,0,0xe4f9, /* '糠',0,'糢',0,0,0,'糦','糧', 0,0,0,'糫',0,0,0,'糯', */
	/* 7cf0 */ 0,0,0xe4fa,0,0xe4fb,0x8ff4a8,0xe4fc,0, 0xbbe5,0,0xe4fd,0xb7cf,0,0,0xb5ea,0, /* 0,0,'糲',0,'糴','糵','糶',0, '糸',0,'糺','系',0,0,'糾',0, */
	/* 7d00 */ 0xb5aa,0,0xe5a1,0x8ff4a9,0xccf3,0xb9c8,0xe4fe,0xf9f9, 0xf9fa,0x8ff4aa,0xe5a4,0xcce6,0,0xc7bc,0,0, /* '紀',0,'紂','紃','約','紅','紆','紇', '紈','紉','紊','紋',0,'納',0,0, */
	/* 7d10 */ 0xc9b3,0,0x8ff4ac,0xf9fb,0xbde3,0xe5a3,0,0xbcd3, 0xb9c9,0xbbe6,0xb5e9,0xcab6,0xe5a2,0xf9fc,0x8ff4ad,0, /* '紐',0,'紒','紓','純','紕',0,'紗', '紘','紙','級','紛','紜','紝','紞',0, */
	/* 7d20 */ 0xc1c7,0xcbc2,0xbaf7,0xf9fd,0,0,0,0, 0,0,0,0xbbe7,0xc4dd,0,0xe5a7,0xcedf, /* '素','紡','索','紣',0,0,0,0, 0,0,0,'紫','紬',0,'紮','累', */
	/* 7d30 */ 0xbad9,0xf9fe,0xe5a8,0xbfc2,0,0xe5aa,0,0, 0,0xbed2,0xbab0,0,0,0x8ff4b0,0x8ff4b1,0xe5a9, /* '細','紱','紲','紳',0,'紵',0,0, 0,'紹','紺',0,0,'紽','紾','紿', */
	/* 7d40 */ 0x8ff4b2,0xfaa1,0xbdaa,0xb8be,0xc1c8,0xe5a5,0xe5ab,0x8ff4b3, 0xfaa2,0,0,0xe5a6,0xb7d0,0,0xe5ae,0xe5b2, /* '絀','絁','終','絃','組','絅','絆','絇', '絈',0,0,'絋','経',0,'絎','絏', */
	/* 7d50 */ 0xb7eb,0,0,0xfaa3,0,0,0xe5ad,0, 0,0x8ff4b7,0x8ff4b8,0xe5b6,0xfaa4,0,0xb9ca,0, /* '結',0,0,'絓',0,0,'絖',0, 0,'絙','絚','絛','絜',0,'絞',0, */
	/* 7d60 */ 0,0xcded,0xb0bc,0xe5b3,0,0,0xb5eb,0, 0xe5b0,0,0x8ff4b9,0,0,0,0xe5b1,0, /* 0,'絡','絢','絣',0,0,'給',0, '絨',0,'絪',0,0,0,'絮',0, */
	/* 7d70 */ 0x8ff4ba,0xc5fd,0xe5af,0xe5ac,0,0xb3a8,0xc0e4,0, 0,0xb8a8,0xfaa5,0,0,0xe5b8,0,0x8ff4bc, /* '絰','統','絲','絳',0,'絵','絶',0, 0,'絹','絺',0,0,'絽',0,'絿', */
	/* 7d80 */ 0,0,0,0xfaa6,0,0,0x8ff4be,0, 0x8ff4bf,0xe5b5,0,0xfaa7,0x8ff4c0,0,0,0xe5b7, /* 0,0,0,'綃',0,0,'綆',0, '綈','綉',0,'綋','綌',0,0,'綏', */
	/* 7d90 */ 0,0,0,0xe5b4,0,0,0,0x8ff4c1, 0,0xb7d1,0xc2b3,0xe5b9,0xc1ee,0x8ff4c3,0,0xe5c6, /* 0,0,0,'經',0,0,0,'綗', 0,'継','続','綛','綜','綝',0,'綟', */
	/* 7da0 */ 0xfaa8,0,0xe5c2,0xe5bc,0,0,0xfaa9,0x8ff4c4, 0,0,0x8ff4c5,0xe5c0,0xbcfa,0xb0dd,0xe5bb,0xe5c3, /* '綠',0,'綢','綣',0,0,'綦','綧', 0,0,'綪','綫','綬','維','綮','綯', */
	/* 7db0 */ 0xe5c7,0xb9cb,0xccd6,0,0xc4d6,0xe5bd,0x8ff4c6,0x8ff4c7, 0xe5c5,0,0xe5ba,0xc3be,0,0xe5bf,0xb0bd,0xccca, /* '綰','綱','網',0,'綴','綵','綶','綷', '綸',0,'綺','綻',0,'綽','綾','綿', */
	/* 7dc0 */ 0x8ff4c8,0,0xfaaa,0,0,0,0,0xe5be, 0,0,0xb6db,0xc8ec,0xfaab,0,0,0xc1ed, /* '緀',0,'緂',0,0,0,0,'緇', 0,0,'緊','緋','緌',0,0,'総', */
	/* 7dd0 */ 0,0xced0,0xbdef,0,0,0xe5ee,0xfaac,0x8ff4c9, 0xe5c8,0x8ff4ca,0xc0fe,0,0xe5c4,0xe5c9,0xe5cb,0, /* 0,'緑','緒',0,0,'緕','緖','緗', '緘','緙','線',0,'緜','緝','緞',0, */
	/* 7de0 */ 0xc4f9,0xe5ce,0,0xfaad,0xe5ca,0,0x8ff4cb,0, 0xcad4,0xb4cb,0,0,0xcccb,0,0,0xb0de, /* '締','緡',0,'緣','緤',0,'緦',0, '編','緩',0,0,'緬',0,0,'緯', */
	/* 7df0 */ 0,0x8ff4cc,0xe5cd,0,0xcefd,0,0,0, 0,0x8ff4cd,0,0xe5cc,0,0,0,0, /* 0,'緱','緲',0,'練',0,0,0, 0,'緹',0,'緻',0,0,0,0, */
	/* 7e00 */ 0,0xb1ef,0,0,0xc6ec,0xe5cf,0,0, 0xfab0,0xe5d6,0xe5d0,0xe5d7,0,0,0,0, /* 0,'縁',0,0,'縄','縅',0,0, '縈','縉','縊','縋',0,0,0,0, */
	/* 7e10 */ 0x8ff4d1,0xfab1,0xe5d3,0,0,0xfab2,0,0x8ff4d2, 0,0,0,0xc7fb,0,0x8ff4d3,0xbcca,0xe5d5, /* '縐','縑','縒',0,0,'縕',0,'縗', 0,0,0,'縛',0,'縝','縞','縟', */
	/* 7e20 */ 0x8ff4d4,0xe5d2,0xe5d8,0xe5d1,0,0,0xbdc4,0x8ff4d5, 0xfaaf,0,0,0xcba5,0x8ff4d6,0,0xbdcc,0, /* '縠','縡','縢','縣',0,0,'縦','縧', '縨',0,0,'縫','縬',0,'縮',0, */
	/* 7e30 */ 0,0xe5d4,0xe5e0,0,0,0xe5dc,0,0xe5df, 0,0xe5dd,0xe5e1,0xe5db,0,0xe5c1,0xc0d3,0, /* 0,'縱','縲',0,0,'縵',0,'縷', 0,'縹','縺','縻',0,'總','績',0, */
	/* 7e40 */ 0,0xc8cb,0,0xe5de,0,0x8ff4d7,0xe5d9,0xfab4, 0,0,0xc1a1,0xb7d2,0,0xbdab,0,0, /* 0,'繁',0,'繃',0,'繅','繆','繇', 0,0,'繊','繋',0,'繍',0,0, */
	/* 7e50 */ 0,0,0xfab5,0,0xbfa5,0xc1b6,0xe5e4,0, 0,0xe5e6,0xe5e7,0,0,0xe5e3,0xe5e5,0, /* 0,0,'繒',0,'織','繕','繖',0, 0,'繙','繚',0,0,'繝','繞',0, */
	/* 7e60 */ 0,0xfab6,0,0,0,0,0xe5da,0xe5e2, 0,0xe5ea,0xe5e9,0xfefe,0,0xcbfa,0,0, /* 0,'繡',0,0,0,0,'繦','繧', 0,'繩','繪','繫',0,'繭',0,0, */
	/* 7e70 */ 0xb7ab,0,0,0x8ff4d8,0,0x8ff4d9,0,0, 0,0xe5e8,0,0xe5ec,0xe5eb,0xe5ef,0x8ff4da,0xe5f1, /* '繰',0,0,'繳',0,'繵',0,0, 0,'繹',0,'繻','繼','繽','繾','繿', */
	/* 7e80 */ 0,0,0xbbbc,0xe5ed,0,0,0x8ff4db,0x8ff4dc, 0xe5f2,0xe5f3,0xfab7,0,0xe5f4,0xfab8,0xe5fa,0xc5bb, /* 0,0,'纂','纃',0,0,'纆','纇', '纈','纉','纊',0,'續','纍','纎','纏', */
	/* 7e90 */ 0xe5f6,0x8ff4de,0xe5f5,0xe5f7,0xe5f8,0,0xe5f9,0, 0x8ff4df,0,0x8ff4e0,0xe5fb,0xe5fc,0,0,0, /* '纐','纑','纒','纓','纔',0,'纖',0, '纘',0,'纚','纛','纜',0,0,0, */
	/* 7ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f30 */ 0,0,0,0,0,0,0xb4cc,0, 0xe5fd,0,0xe5fe,0x8ff4e3,0x8ff4e2,0,0x8ff4e4,0, /* 0,0,0,0,0,0,'缶',0, '缸',0,'缺','缻','缼',0,'缾',0, */
	/* 7f40 */ 0,0,0,0x8ff4e5,0x8ff4e6,0xe6a1,0,0xfab9, 0,0,0,0,0xe6a2,0xe6a3,0xe6a4,0x8ff4e7, /* 0,0,0,'罃','罄','罅',0,'罇', 0,0,0,0,'罌','罍','罎','罏', */
	/* 7f50 */ 0xe6a5,0xe6a6,0x8ff4ea,0,0xe6a8,0xe6a7,0,0, 0xe6a9,0,0,0,0,0,0,0xe6aa, /* '罐','网','罒',0,'罔','罕',0,0, '罘',0,0,0,0,0,0,'罟', */
	/* 7f60 */ 0xe6ab,0x8ff4ec,0,0x8ff4ed,0x8ff4ee,0,0,0xe6ae, 0xe6ac,0xe6ad,0xbae1,0xb7d3,0,0x8ff4ef,0xc3d6,0, /* '罠','罡',0,'罣','罤',0,0,'罧', '罨','罩','罪','罫',0,'罭','置',0, */
	/* 7f70 */ 0xc8b3,0,0xbdf0,0,0,0xc7cd,0,0xc8ed, 0xe6af,0xd8ed,0,0,0,0x8ff4f0,0x8ff4f1,0, /* '罰',0,'署',0,0,'罵',0,'罷', '罸','罹',0,0,0,'罽','罾',0, */
	/* 7f80 */ 0,0,0xe6b0,0xe6b2,0,0xcde5,0xe6b1,0xe6b4, 0xe6b3,0,0xcdd3,0,0xe6b5,0,0xc8fe,0, /* 0,0,'羂','羃',0,'羅','羆','羇', '羈',0,'羊',0,'羌',0,'美',0, */
	/* 7f90 */ 0x8ff4f3,0xfabb,0,0,0xe6b6,0,0x8ff4f6,0xfabc, 0,0,0xe6b9,0,0x8ff4f7,0xe6b8,0xe6b7,0, /* '羐','羑',0,0,'羔',0,'羖','羗', 0,0,'羚',0,'羜','羝','羞',0, */
	/* 7fa0 */ 0,0,0,0xe6ba,0xb7b2,0,0,0, 0xc1a2,0xb5c1,0,0,0,0x8ff4f8,0xe6be,0xe6bb, /* 0,0,0,'羣','群',0,0,0, '羨','義',0,0,0,'羭','羮','羯', */
	/* 7fb0 */ 0,0,0xe6bc,0,0,0,0xe6bf,0, 0xe6c0,0xe6bd,0,0,0,0xb1a9,0,0xfabd, /* 0,0,'羲',0,0,0,'羶',0, '羸','羹',0,0,0,'羽',0,'羿', */
	/* 7fc0 */ 0,0xb2a7,0,0x8ff4fa,0,0xe6c2,0xe6c3,0, 0,0,0xe6c4,0,0xcde2,0,0xfabe,0x8ff4fb, /* 0,'翁',0,'翃',0,'翅','翆',0, 0,0,'翊',0,'翌',0,'翎','翏', */
	/* 7fd0 */ 0,0,0xbdac,0,0xe6c6,0xe6c5,0,0, 0,0,0,0xfabf,0,0,0,0xfac0, /* 0,0,'習',0,'翔','翕',0,0, 0,0,0,'翛',0,0,0,'翟', */
	/* 7fe0 */ 0xbfe9,0xe6c7,0,0x8ff4fc,0,0x8ff4fd,0xe6c8,0, 0,0xe6c9,0,0xb4e5,0xfac1,0,0xfac2,0x8ff4fe, /* '翠','翡',0,'翣',0,'翥','翦',0, 0,'翩',0,'翫','翬',0,'翮','翯', */
	/* 7ff0 */ 0xb4cd,0,0x8ff5a1,0xe6ca,0,0,0,0, 0,0xe6cb,0xfac3,0xcbdd,0xcde3,0,0,0, /* '翰',0,'翲','翳',0,0,0,0, 0,'翹','翺','翻','翼',0,0,0, */
	/* 8000 */ 0xcdd4,0xcfb7,0x8ff5a2,0xb9cd,0xe6ce,0xbcd4,0xe6cd,0, 0x8ff5a4,0,0x8ff5a3,0xe6cf,0xbca9,0,0x8ff5a5,0, /* '耀','老','耂','考','耄','者','耆',0, '耈',0,'耊','耋','而',0,'耎',0, */
	/* 8010 */ 0xc2d1,0x8ff5a6,0xe6d0,0,0xfac5,0xb9cc,0x8ff5a7,0xccd7, 0xe6d1,0xe6d2,0,0,0xe6d3,0,0,0, /* '耐','耑','耒',0,'耔','耕','耖','耗', '耘','耙',0,0,'耜',0,0,0, */
	/* 8020 */ 0,0xe6d4,0,0,0x8ff5a8,0,0xfac6,0, 0xe6d5,0,0,0,0x8ff5a9,0,0,0, /* 0,'耡',0,0,'耤',0,'耦',0, '耨',0,0,0,'耬',0,0,0, */
	/* 8030 */ 0x8ff5aa,0,0,0xbcaa,0,0xfac7,0xcced,0xfac8, 0,0,0,0xe6d7,0xfac9,0xc3bf,0,0xe6d6, /* '耰',0,0,'耳',0,'耵','耶','耷', 0,0,0,'耻','耼','耽',0,'耿', */
	/* 8040 */ 0,0,0,0x8ff5ab,0,0,0xe6d9,0, 0,0,0xe6d8,0,0,0,0,0, /* 0,0,0,'聃',0,0,'聆',0, 0,0,'聊',0,0,0,0,0, */
	/* 8050 */ 0,0,0xe6da,0,0,0,0xc0bb,0, 0xe6db,0,0xe6dc,0,0,0,0xcab9,0xe6dd, /* 0,0,'聒',0,0,0,'聖',0, '聘',0,'聚',0,0,0,'聞','聟', */
	/* 8060 */ 0,0xc1ef,0xe6de,0,0,0,0x8ff5ac,0, 0xe6df,0,0,0,0,0,0,0xcefe, /* 0,'聡','聢',0,0,0,'聦',0, '聨',0,0,0,0,0,0,'聯', */
	/* 8070 */ 0xe6e2,0x8ff5ad,0xe6e1,0xe6e0,0xc4b0,0x8ff5ae,0xe6e3,0xbfa6, 0,0xe6e4,0,0x8ff5af,0,0xe6e5,0xcfb8,0xe6e6, /* '聰','聱','聲','聳','聴','聵','聶','職', 0,'聹',0,'聻',0,'聽','聾','聿', */
	/* 8080 */ 0,0,0,0,0xe6e7,0xe6e9,0xe6e8,0xc8a5, 0,0xc6f9,0,0xcfbe,0xc8a9,0,0,0, /* 0,0,0,0,'肄','肅','肆','肇', 0,'肉',0,'肋','肌',0,0,0, */
	/* 8090 */ 0,0,0,0xe6eb,0,0,0xbed3,0, 0xc9aa,0x8ff5b0,0xe6ec,0xe6ea,0x8ff5b1,0xb4ce,0,0, /* 0,0,0,'肓',0,0,'肖',0, '肘','肙','肚','肛','肜','肝',0,0, */
	/* 80a0 */ 0,0xb8d4,0xbbe8,0,0x8ff5b2,0xc8ee,0,0x8ff5b3, 0,0xb8aa,0xcbc3,0,0xe6ef,0xe6ed,0,0xb9ce, /* 0,'股','肢',0,'肤','肥',0,'肧', 0,'肩','肪',0,'肬','肭',0,'肯', */
	/* 80b0 */ 0,0xb9cf,0xb0e9,0,0xbae8,0,0,0, 0x8ff5b4,0,0xc7d9,0,0,0,0,0, /* 0,'肱','育',0,'肴',0,0,0, '肸',0,'肺',0,0,0,0,0, */
	/* 80c0 */ 0,0,0,0xb0df,0xe6f4,0x8ff5b6,0xc3c0,0, 0,0,0xfaca,0,0xc7d8,0,0xc2db,0, /* 0,0,0,'胃','胄','胅','胆',0, 0,0,'胊',0,'背',0,'胎',0, */
	/* 80d0 */ 0,0,0,0,0,0x8ff5b7,0xe6f6,0xfacb, 0x8ff5b8,0xe6f2,0xe6f5,0xe6f0,0,0xe6f3,0xcba6,0, /* 0,0,0,0,0,'胕','胖','胗', '胘','胙','胚','胛',0,'胝','胞',0, */
	/* 80e0 */ 0xfacc,0xb8d5,0,0,0xb0fd,0xe6f1,0x8ff5b9,0, 0,0,0,0,0,0,0,0xe6f8, /* '胠','胡',0,0,'胤','胥','胦',0, 0,0,0,0,0,0,0,'胯', */
	/* 80f0 */ 0,0xe6f9,0,0xfacd,0xc6b9,0x8ff5bc,0,0, 0xb6bb,0,0,0x8ff5bd,0xe7a6,0xc7bd,0,0, /* 0,'胱',0,'胳','胴','胵',0,0, '胸',0,0,'胻','胼','能',0,0, */
	/* 8100 */ 0,0,0xbbe9,0,0,0xb6bc,0xc0c8,0xcfc6, 0xccae,0xe6f7,0xc0d4,0,0,0x8ff5bb,0,0, /* 0,0,'脂',0,0,'脅','脆','脇', '脈','脉','脊',0,0,'脍',0,0, */
	/* 8110 */ 0,0,0,0,0,0,0x8ff5c0,0, 0xface,0,0xb5d3,0xe6fa,0,0,0x8ff5c1,0, /* 0,0,0,0,0,0,'脖',0, '脘',0,'脚','脛',0,0,'脞',0, */
	/* 8120 */ 0,0,0,0xe6fc,0x8ff5c3,0,0,0x8ff5c4, 0,0xe6fb,0,0,0x8ff5c5,0,0,0xe6fd, /* 0,0,0,'脣','脤',0,0,'脧', 0,'脩',0,0,'脬',0,0,'脯', */
	/* 8130 */ 0,0xc3a6,0,0xc7be,0,0x8ff5bf,0,0, 0,0xc4b1,0,0,0,0x8ff5c7,0xe7a3,0, /* 0,'脱',0,'脳',0,'脵',0,0, 0,'脹',0,0,0,'脽','脾',0, */
	/* 8140 */ 0,0,0,0,0,0,0xe7a2,0, 0,0,0xfacf,0xe6fe,0,0,0xbfd5,0, /* 0,0,0,0,0,0,'腆',0, 0,0,'腊','腋',0,0,'腎',0, */
	/* 8150 */ 0xc9e5,0xe7a5,0,0xe7a4,0xb9d0,0xcfd3,0,0, 0,0,0,0,0,0,0,0xe7b5, /* '腐','腑',0,'腓','腔','腕',0,0, 0,0,0,0,0,0,0,'腟', */
	/* 8160 */ 0xfad0,0,0,0,0,0xe7a9,0xe7aa,0xfad1, 0xfad2,0x8ff5c9,0,0xbcf0,0,0xfad3,0xe7a8,0, /* '腠',0,0,0,0,'腥','腦','腧', '腨','腩',0,'腫',0,'腭','腮',0, */
	/* 8170 */ 0xb9f8,0xe7a7,0,0,0xe7ab,0,0,0, 0xc4b2,0xcaa2,0xc1a3,0,0,0,0,0xc2dc, /* '腰','腱',0,0,'腴',0,0,0, '腸','腹','腺',0,0,0,0,'腿', */
	/* 8180 */ 0xe7af,0x8ff5cb,0xe7b0,0xe7ac,0x8ff5cd,0x8ff5ce,0,0, 0xe7ad,0,0xe7ae,0,0,0,0,0xb9d1, /* '膀','膁','膂','膃','膄','膅',0,0, '膈',0,'膊',0,0,0,0,'膏', */
	/* 8190 */ 0,0,0,0xe7b6,0,0xe7b2,0,0, 0x8ff5d0,0,0xc9e6,0,0xcbec,0xc9a8,0,0, /* 0,0,0,'膓',0,'膕',0,0, '膘',0,'膚',0,'膜','膝',0,0, */
	/* 81a0 */ 0xe7b1,0,0,0xe7b4,0xe7b3,0,0,0, 0xcbc4,0xe7b7,0,0,0,0,0,0, /* '膠',0,0,'膣','膤',0,0,0, '膨','膩',0,0,0,0,0,0, */
	/* 81b0 */ 0xe7b8,0,0x8ff5d1,0xc1b7,0,0xe7b9,0,0, 0xe7bb,0,0xe7bf,0xfad4,0,0xe7bc,0xe7ba,0xc7bf, /* '膰',0,'膲','膳',0,'膵',0,0, '膸',0,'膺','膻',0,'膽','膾','膿', */
	/* 81c0 */ 0xe7bd,0x8ff5d2,0xe7be,0x8ff5d3,0,0,0xb2b2,0, 0xe7c5,0xe7c0,0xfad5,0,0,0xe7c1,0,0xfad6, /* '臀','臁','臂','臃',0,0,'臆',0, '臈','臉','臊',0,0,'臍',0,'臏', */
	/* 81d0 */ 0,0xe7c2,0,0xc2a1,0,0,0x8ff5d4,0xfad7, 0xe7c4,0xe7c3,0xe7c6,0x8ff5d5,0,0,0,0xe7c7, /* 0,'臑',0,'臓',0,0,'臖','臗', '臘','臙','臚','臛',0,0,0,'臟', */
	/* 81e0 */ 0xe7c8,0,0,0xbfc3,0x8ff5d7,0xb2e9,0,0xe7c9, 0xced7,0,0xbcab,0,0x8ff5d9,0xbdad,0,0, /* '臠',0,0,'臣','臤','臥',0,'臧', '臨',0,'自',0,'臬','臭',0,0, */
	/* 81f0 */ 0,0,0,0xbbea,0xc3d7,0,0,0, 0,0,0xe7ca,0xe7cb,0xb1b1,0x8ff5db,0xe7cc,0x8ff5dc, /* 0,0,0,'至','致',0,0,0, 0,0,'臺','臻','臼','臽','臾','臿', */
	/* 8200 */ 0,0xe7cd,0xe7ce,0,0x8ff5de,0xe7cf,0,0xe7d0, 0xb6bd,0xdaaa,0xe7d1,0,0xc0e5,0xe7d2,0xbccb,0, /* 0,'舁','舂',0,'舄','舅',0,'與', '興','舉','舊',0,'舌','舍','舎',0, */
	/* 8210 */ 0xe7d3,0,0xd0b0,0,0,0,0xe7d4,0xcade, 0xb4dc,0x8ff5e0,0,0xc1a4,0xbdd8,0,0xc9f1,0xbdae, /* '舐',0,'舒',0,0,0,'舖','舗', '舘','舙',0,'舛','舜',0,'舞','舟', */
	/* 8220 */ 0,0x8ff5e1,0x8ff5e2,0,0,0,0,0, 0,0xe7d5,0xb9d2,0xe7d6,0xc8cc,0,0xe7e4,0, /* 0,'舡','舢',0,0,0,0,0, 0,'舩','航','舫','般',0,'舮',0, */
	/* 8230 */ 0,0,0x8ff5e4,0xe7d8,0x8ff5e5,0xc2c9,0xc7f5,0xb8bf, 0xe7d7,0xc1a5,0,0,0x8ff5e6,0,0,0, /* 0,0,'舲','舳','舴','舵','舶','舷', '舸','船',0,0,'舼',0,0,0, */
	/* 8240 */ 0xe7d9,0,0,0,0,0x8ff5e9,0x8ff5e7,0xc4fa, 0,0x8ff5e8,0,0x8ff5eb,0,0,0,0x8ff5ed, /* '艀',0,0,0,0,'艅','艆','艇', 0,'艉',0,'艋',0,0,0,'艏', */
	/* 8250 */ 0,0,0,0,0,0,0,0x8ff5ef, 0xe7db,0xe7da,0xe7dd,0,0x8ff5f1,0xe7dc,0,0xe7de, /* 0,0,0,0,0,0,0,'艗', '艘','艙','艚',0,'艜','艝',0,'艟', */
	/* 8260 */ 0xfadb,0,0xe7e0,0x8ff5f2,0xe7df,0,0xb4cf,0, 0xe7e1,0,0xe7e2,0xe7e3,0,0,0xbab1,0xcec9, /* '艠',0,'艢','艣','艤',0,'艦',0, '艨',0,'艪','艫',0,0,'艮','良', */
	/* 8270 */ 0,0xe7e5,0xbfa7,0,0xfadc,0,0xb1f0,0xe7e6, 0xe7e7,0x8ff5f6,0,0,0,0x8ff5f8,0xe7e8,0x8ff5f9, /* 0,'艱','色',0,'艴',0,'艶','艷', '艸','艹',0,0,0,'艽','艾','艿', */
	/* 8280 */ 0,0,0,0x8ff5fa,0,0,0,0, 0,0,0x8ff5fb,0xb0f2,0,0xe7e9,0xfade,0, /* 0,0,0,'芃',0,0,0,0, 0,0,'芊','芋',0,'芍','芎',0, */
	/* 8290 */ 0,0,0xe7ea,0x8ff5fc,0,0,0,0, 0,0xc9e7,0,0,0,0xbcc7,0,0xe7ec, /* 0,0,'芒','芓',0,0,0,0, 0,'芙',0,0,0,'芝',0,'芟', */
	/* 82a0 */ 0,0xfadf,0,0xfae0,0xfae1,0xb3a9,0xb0b2,0x8ff5fd, 0x8ff5fe,0xfae2,0,0xe7eb,0xe7ee,0xc7ce,0xfae3,0xbfc4, /* 0,'芡',0,'芣','芤','芥','芦','芧', '芨','芩',0,'芫','芬','芭','芮','芯', */
	/* 82b0 */ 0,0xb2d6,0x8ff6a1,0xcba7,0x8ff6a2,0,0,0xfae4, 0xb7dd,0xb6dc,0x8ff6a3,0xe7ed,0x8ff6a4,0xb2ea,0xfae5,0xfae6, /* 0,'花','芲','芳','芴',0,0,'芷', '芸','芹','芺','芻','芼','芽','芾','芿', */
	/* 82c0 */ 0,0,0,0,0,0xb4a3,0xfae7,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'苅','苆',0, 0,0,0,0,0,0,0,0, */
	/* 82d0 */ 0,0xb1f1,0xe7f2,0xceea,0xc2dd,0xfae8,0,0xc9c4, 0,0xe7fe,0,0xb2d7,0xe7fc,0,0xe7fa,0xe7f1, /* 0,'苑','苒','苓','苔','苕',0,'苗', 0,'苙',0,'苛','苜',0,'苞','苟', */
	/* 82e0 */ 0,0xe7ef,0x8ff6a5,0xe7f0,0,0xbce3,0xb6ec,0xc3f7, 0x8ff6a6,0,0,0xc6d1,0,0,0,0, /* 0,'苡','苢','苣',0,'若','苦','苧', '苨',0,0,'苫',0,0,0,0, */
	/* 82f0 */ 0,0xb1d1,0,0xe7f4,0xe7f3,0,0,0x8ff6a7, 0,0xe7f9,0xe7f5,0xe7f8,0,0xfae9,0xfaea,0, /* 0,'英',0,'苳','苴',0,0,'苷', 0,'苹','苺','苻',0,'苽','苾',0, */
	/* 8300 */ 0xfaeb,0xfaec,0xccd0,0xe7f7,0xb2d8,0xb3fd,0xe7fb,0x8ff6a8, 0x8ff6a9,0xe7fd,0,0,0x8ff6aa,0,0xb7d4,0, /* '茀','茁','茂','范','茄','茅','茆','茇', '茈','茉',0,0,'茌',0,'茎',0, */
	/* 8310 */ 0,0,0,0,0,0,0xe8a3,0xe8ac, 0xe8ad,0,0,0x8ff6ac,0xb0ab,0x8ff6ad,0,0, /* 0,0,0,0,0,0,'茖','茗', '茘',0,0,'茛','茜','茝',0,0, */
	/* 8320 */ 0,0,0xfaee,0xe8b4,0,0,0,0, 0xb0f1,0,0,0xe8ab,0,0xfaef,0,0xe8aa, /* 0,0,'茢','茣',0,0,0,0, '茨',0,0,'茫',0,'茭',0,'茯', */
	/* 8330 */ 0x8ff6ae,0xe8a5,0xe8a4,0,0xe8a2,0xe8a1,0xc3e3,0, 0xc2fb,0xe8a7,0xfaf0,0,0x8ff6af,0,0,0, /* '茰','茱','茲',0,'茴','茵','茶',0, '茸','茹','茺',0,'茼',0,0,0, */
	/* 8340 */ 0xe8a6,0,0,0xfaf1,0x8ff6b0,0xe8a9,0,0xfaf2, 0,0xc1f0,0xb7d5,0,0,0,0,0xb1c1, /* '荀',0,0,'荃','荄','荅',0,'荇', 0,'草','荊',0,0,0,0,'荏', */
	/* 8350 */ 0xe8a8,0xfaf3,0xb9d3,0,0x8ff6ab,0xfaf4,0,0x8ff6b1, 0xc1f1,0,0,0,0,0,0,0, /* '荐','荑','荒',0,'荔','荕',0,'荗', '荘',0,0,0,0,0,0,0, */
	/* 8360 */ 0,0,0xfaed,0x8faeca,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'荢','荣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8370 */ 0,0,0,0xe8ba,0,0xe8bb,0,0xb2d9, 0,0,0,0xb2ae,0xe8b8,0xfaf5,0,0x8ff6b3, /* 0,0,0,'荳',0,'荵',0,'荷', 0,0,0,'荻','荼','荽',0,'荿', */
	/* 8380 */ 0,0,0,0,0,0xe8ae,0xfaf6,0xe8b6, 0,0xe8bd,0xe8b7,0,0,0x8ff6b6,0xe8b5,0, /* 0,0,0,0,0,'莅','莆','莇', 0,'莉','莊',0,0,'莍','莎',0, */
	/* 8390 */ 0,0,0xfaf7,0xe7f6,0x8ff6b7,0x8ff6b8,0xe8b3,0, 0xfaf8,0,0xe8af,0x8ff6b9,0,0x8ff6ba,0xb4d0,0xe8b1, /* 0,0,'莒','莓','莔','莕','莖',0, '莘',0,'莚','莛',0,'莝','莞','莟', */
	/* 83a0 */ 0xe8bc,0,0xe8b2,0,0,0,0,0xfaf9, 0xe8be,0xfafa,0xe8b0,0xc7fc,0,0,0,0, /* '莠',0,'莢',0,0,0,0,'莧', '莨','莩','莪','莫',0,0,0,0, */
	/* 83b0 */ 0,0xcde9,0,0,0,0xe8b9,0,0, 0,0,0,0,0,0xe8cf,0,0xfafb, /* 0,'莱',0,0,0,'莵',0,0, 0,0,0,0,0,'莽',0,'莿', */
	/* 83c0 */ 0xfafc,0xe8c7,0,0,0,0xbffb,0,0xfafd, 0,0x8ff6bb,0xb5c6,0,0xb6dd,0,0xe8c2,0xfafe, /* '菀','菁',0,0,0,'菅',0,'菇', 0,'菉','菊',0,'菌',0,'菎','菏', */
	/* 83d0 */ 0x8ff6bc,0xfba1,0,0xb2db,0x8ff6bd,0,0xbed4,0, 0xe8c5,0,0,0,0xbada,0x8ff6be,0,0xc5d1, /* '菐','菑',0,'菓','菔',0,'菖',0, '菘',0,0,0,'菜','菝',0,'菟', */
	/* 83e0 */ 0xe8ca,0xfba2,0,0,0,0x8ff6bf,0,0, 0,0xcaee,0xfba3,0xe8c1,0,0,0,0xb2da, /* '菠','菡',0,0,0,'菥',0,0, 0,'菩','菪','菫',0,0,0,'華', */
	/* 83f0 */ 0xb8d6,0xc9a9,0xe8cb,0,0xe8bf,0,0,0xe8c8, 0,0x8ff6c0,0,0xe8d2,0,0xe8c3,0,0, /* '菰','菱','菲',0,'菴',0,0,'菷', 0,'菹',0,'菻',0,'菽',0,0, */
	/* 8400 */ 0,0xfba4,0,0xe8c4,0xc6ba,0,0xfba5,0xe8c9, 0,0,0xfba6,0xe8c6,0xcba8,0xe8cc,0xb0e0,0x8ff6c1, /* 0,'萁',0,'萃','萄',0,'萆','萇', 0,0,'萊','萋','萌','萍','萎','萏', */
	/* 8410 */ 0,0x8ff6c2,0,0xe8c0,0,0x8ff6c3,0,0x8ff6c5, 0,0,0,0,0,0,0,0, /* 0,'萑',0,'萓',0,'萕',0,'萗', 0,0,0,0,0,0,0,0, */
	/* 8420 */ 0xe8ce,0,0xe8cd,0,0,0,0,0, 0,0xc7eb,0xe8d4,0,0xe8df,0,0,0, /* '萠',0,'萢',0,0,0,0,0, 0,'萩','萪',0,'萬',0,0,0, */
	/* 8430 */ 0,0xb3fe,0,0,0,0xe8e2,0,0, 0xe8d0,0x8ff6c6,0,0,0xe8d5,0xcdee,0,0, /* 0,'萱',0,0,0,'萵',0,0, '萸','萹',0,0,'萼','落',0,0, */
	/* 8440 */ 0,0,0,0,0,0,0xe8de,0, 0xfba8,0xcdd5,0x8ff6c7,0,0,0,0xceaa,0x8ff6c8, /* 0,0,0,0,0,0,'葆',0, '葈','葉','葊',0,0,0,'葎','葏', */
	/* 8450 */ 0,0x8ff6c9,0x8ff6ca,0,0,0,0,0xc3f8, 0,0x8ff6cb,0x8ff6cc,0xb3eb,0x8ff6cd,0,0,0xfba9, /* 0,'葑','葒',0,0,0,0,'著', 0,'葙','葚','葛','葜',0,0,'葟', */
	/* 8460 */ 0,0xc9f2,0xe8e4,0xc6a1,0,0x8ff6cf,0xb0b1,0, 0,0xe8dd,0,0xe8d9,0xc1f2,0xe8d3,0xe8db,0xe8e0, /* 0,'葡','葢','董',0,'葥','葦',0, 0,'葩',0,'葫','葬','葭','葮','葯', */
	/* 8470 */ 0xfbaa,0xc7ac,0,0xfbab,0,0xb0aa,0x8ff6d0,0xe8d8, 0x8ff6d1,0xe8e1,0xc9f8,0,0x8ff6d2,0,0,0, /* '葰','葱',0,'葳',0,'葵','葶','葷', '葸','葹','葺',0,'葼',0,0,0, */
	/* 8480 */ 0,0x8ff6d3,0xe8dc,0,0xe8d7,0xfbac,0,0, 0,0,0,0xbed5,0,0,0,0, /* 0,'蒁','蒂',0,'蒄','蒅',0,0, 0,0,0,'蒋',0,0,0,0, */
	/* 8490 */ 0xbdaf,0,0,0,0xbcac,0,0,0x8ff6d6, 0,0xccd8,0,0,0xc9c7,0,0xfbad,0xe8e7, /* '蒐',0,0,0,'蒔',0,0,'蒗', 0,'蒙',0,0,'蒜',0,'蒞','蒟', */
	/* 84a0 */ 0,0xe8f0,0,0,0,0,0x8ff6d7,0, 0,0,0,0,0,0xe8da,0,0xfbae, /* 0,'蒡',0,0,0,0,'蒦',0, 0,0,0,0,0,'蒭',0,'蒯', */
	/* 84b0 */ 0,0,0xb3f7,0,0xfbaf,0,0,0, 0xbef8,0xe8e5,0xfbb0,0xe8ea,0xc1f3,0,0x8ff6d8,0xe8e6, /* 0,0,'蒲',0,'蒴',0,0,0, '蒸','蒹','蒺','蒻','蒼',0,'蒾','蒿', */
	/* 84c0 */ 0xfbb1,0xe8ed,0xfbb2,0,0xc3df,0,0xe8ee,0, 0,0xcdd6,0xe8e3,0xb3b8,0,0xe8e9,0x8ff6da,0x8ff6db, /* '蓀','蓁','蓂',0,'蓄',0,'蓆',0, 0,'蓉','蓊','蓋',0,'蓍','蓎','蓏', */
	/* 84d0 */ 0xe8ec,0xccac,0,0x8ff6dc,0,0,0xe8ef,0, 0,0xe8e8,0xe8eb,0,0x8ff6d5,0,0,0, /* '蓐','蓑',0,'蓓',0,0,'蓖',0, 0,'蓙','蓚',0,'蓜',0,0,0, */
	/* 84e0 */ 0,0,0,0,0,0,0,0x8ff6de, 0,0,0x8ff6df,0,0xcba9,0,0xcfa1,0x8ff6e0, /* 0,0,0,0,0,0,0,'蓧', 0,0,'蓪',0,'蓬',0,'蓮','蓯', */
	/* 84f0 */ 0x8ff6e1,0x8ff6e2,0,0,0xe8f3,0,0,0, 0,0,0x8ff6e3,0,0xe8fa,0x8ff6e4,0,0xe8f2, /* '蓰','蓱',0,0,'蓴',0,0,0, 0,0,'蓺',0,'蓼','蓽',0,'蓿', */
	/* 8500 */ 0xbcc3,0,0,0,0,0,0xe8d1,0, 0,0,0,0,0x8ff6e5,0,0,0, /* '蔀',0,0,0,0,0,'蔆',0, 0,0,0,0,'蔌',0,0,0, */
	/* 8510 */ 0,0xcace,0,0xcca2,0xe8f9,0xe8f8,0,0xe8f4, 0xe8f5,0,0xb1b6,0x8ff6e6,0,0,0xfbb5,0xe8f7, /* 0,'蔑',0,'蔓','蔔','蔕',0,'蔗', '蔘',0,'蔚','蔛',0,0,'蔞','蔟', */
	/* 8520 */ 0,0xe8f1,0,0xfbb6,0x8ff6e7,0x8ff6e8,0xc4d5,0, 0,0,0,0x8ff6e9,0xe8f6,0xb0fe,0,0xfbb7, /* 0,'蔡',0,'蔣','蔤','蔥','蔦',0, 0,0,0,'蔫','蔬','蔭',0,'蔯', */
	/* 8530 */ 0,0,0xfbb4,0,0x8ff6ea,0xc2a2,0,0, 0,0,0,0,0,0xcac3,0x8ff6ef,0, /* 0,0,'蔲',0,'蔴','蔵',0,0, 0,0,0,0,0,'蔽','蔾',0, */
	/* 8540 */ 0xe8fb,0xe9a1,0,0xc8d9,0,0,0,0, 0xe8fe,0xbed6,0xbcc9,0xe9a3,0,0,0xb6be,0x8ff6eb, /* '蕀','蕁',0,'蕃',0,0,0,0, '蕈','蕉','蕊','蕋',0,0,'蕎','蕏', */
	/* 8550 */ 0,0x8ff6f0,0,0x8ff6f1,0,0xe9a4,0,0xc9f9, 0xe8fd,0xfbb8,0xe8d6,0,0,0,0x8ff6f2,0, /* 0,'蕑',0,'蕓',0,'蕕',0,'蕗', '蕘','蕙','蕚',0,0,0,'蕞',0, */
	/* 8560 */ 0,0x8ff6f3,0x8ff6f4,0xe8fc,0xfbb9,0,0,0, 0xcfcf,0xc6a2,0xc9f3,0,0,0xe9ab,0,0x8ff6ec, /* 0,'蕡','蕢','蕣','蕤',0,0,0, '蕨','蕩','蕪',0,0,'蕭',0,'蕯', */
	/* 8570 */ 0,0,0,0,0,0,0,0xe9b1, 0,0,0xfbbc,0x8ff6f6,0,0x8ff6f7,0xe9b2,0x8ff6f8, /* 0,0,0,0,0,0,0,'蕷', 0,0,'蕺','蕻',0,'蕽','蕾','蕿', */
	/* 8580 */ 0xe9a5,0x8ff6f9,0,0,0xc7f6,0,0x8ff6fa,0xe9af, 0xe9a7,0,0xe9a9,0,0xfbbd,0,0,0xfbbe, /* '薀','薁',0,0,'薄',0,'薆','薇', '薈',0,'薊',0,'薌',0,0,'薏', */
	/* 8590 */ 0xe9b3,0xe9a8,0,0x8ff6fb,0xe9ac,0,0,0xb1f2, 0,0xc6e5,0,0xe9ad,0xe9b0,0x8ff6fc,0,0x8ff6fd, /* '薐','薑',0,'薓','薔',0,0,'薗', 0,'薙',0,'薛','薜','薝',0,'薟', */
	/* 85a0 */ 0,0,0xfbbf,0,0xe9a6,0,0xc1a6,0, 0xe9aa,0xbba7,0xbfc5,0xb7b0,0xccf4,0xfbbb,0xccf9,0xbdf2, /* 0,0,'薢',0,'薤',0,'薦',0, '薨','薩','薪','薫','薬','薭','薮','薯', */
	/* 85b0 */ 0xfbc0,0,0,0,0,0,0,0x8ff7a3, 0,0xe9b7,0xe9b5,0,0x8ff7a4,0,0,0, /* '薰',0,0,0,0,0,0,'薷', 0,'薹','薺',0,'薼',0,0,0, */
	/* 85c0 */ 0,0xcfce,0,0,0,0,0,0x8ff7a5, 0,0xe9b4,0x8ff7a6,0xfbc1,0,0xcdf5,0xfbc2,0xe9b6, /* 0,'藁',0,0,0,0,0,'藇', 0,'藉','藊','藋',0,'藍','藎','藏', */
	/* 85d0 */ 0xe9b8,0,0,0,0,0xe9b9,0,0, 0x8ff7a7,0x8ff7a8,0,0,0xe9bc,0xe9ba,0,0x8ff7a9, /* '藐',0,0,0,0,'藕',0,0, '藘','藙',0,0,'藜','藝',0,'藟', */
	/* 85e0 */ 0,0x8ff7aa,0,0,0xc6a3,0xe9bb,0x8ff7ab,0, 0,0xc8cd,0xe9ae,0,0,0xfbc3,0,0, /* 0,'藡',0,0,'藤','藥','藦',0, 0,'藩','藪',0,0,'藭',0,0, */
	/* 85f0 */ 0,0,0,0,0,0,0x8ff7ac,0xbdf3, 0,0xe9bd,0xe9c2,0xc1f4,0,0,0xe9c1,0xfbc5, /* 0,0,0,0,0,0,'藶','藷', 0,'藹','藺','藻',0,0,'藾','藿', */
	/* 8600 */ 0x8ff7ad,0,0xe9a2,0,0xfbc6,0xfbc7,0xe9c3,0xc1c9, 0,0,0xe9be,0xe9c0,0,0,0,0, /* '蘀',0,'蘂',0,'蘄','蘅','蘆','蘇', 0,0,'蘊','蘋',0,0,0,0, */
	/* 8610 */ 0xfbc8,0x8ff7ae,0xfbc4,0xe9bf,0,0,0xddb1,0xdda2, 0xfbca,0,0xe9c5,0,0,0,0x8ff7af,0, /* '蘐','蘑','蘒','蘓',0,0,'蘖','蘗', '蘘',0,'蘚',0,0,0,'蘞',0, */
	/* 8620 */ 0,0x8ff7b0,0xe9c4,0,0x8ff7b1,0,0,0x8ff7b2, 0,0xfbcb,0,0,0,0xcdf6,0,0xe2bc, /* 0,'蘡','蘢',0,'蘤',0,0,'蘧', 0,'蘩',0,0,0,'蘭',0,'蘯', */
	/* 8630 */ 0xe9c6,0,0,0,0,0,0,0, 0xfbcc,0x8ff7b4,0,0,0x8ff7b5,0,0,0xe9c7, /* '蘰',0,0,0,0,0,0,0, '蘸','蘹',0,0,'蘼',0,0,'蘿', */
	/* 8640 */ 0x8ff7b7,0xafe8,0,0,0,0,0,0, 0,0,0,0,0,0xe9c8,0xb8d7,0, /* '虀','虁',0,0,0,0,0,0, 0,0,0,0,0,'虍','虎',0, */
	/* 8650 */ 0xb5d4,0,0,0x8ff7b9,0xe9ca,0xd1dd,0x8ff7ba,0xfbcd, 0,0,0xb5f5,0xfbce,0xceba,0,0xb6f3,0xe9cb, /* '虐',0,0,'虓','虔','處','虖','虗', 0,0,'虚','虛','虜',0,'虞','號', */
	/* 8660 */ 0,0,0xfbd0,0,0,0,0,0xe9cc, 0,0,0,0xc3ee,0xfbd2,0,0,0x8ff7bb, /* 0,0,'虢',0,0,0,0,'虧', 0,0,0,'虫','虬',0,0,'虯', */
	/* 8670 */ 0,0xe9cd,0,0,0,0xfbd3,0,0x8ff7bc, 0,0xc6fa,0x8ff7bd,0xb0ba,0,0,0,0, /* 0,'虱',0,0,0,'虵',0,'虷', 0,'虹','虺','虻',0,0,0,0, */
	/* 8680 */ 0,0,0,0,0,0,0,0x8ff7be, 0,0x8ff7bf,0xb2e3,0xe9d2,0xe9d3,0x8ff7c0,0,0, /* 0,0,0,0,0,0,0,'蚇', 0,'蚉','蚊','蚋','蚌','蚍',0,0, */
	/* 8690 */ 0,0x8ff7c1,0,0xe9ce,0,0xbbbd,0,0, 0xfbd4,0,0,0,0x8ff7c2,0x8ff7c3,0,0, /* 0,'蚑',0,'蚓',0,'蚕',0,0, '蚘',0,0,0,'蚜','蚝',0,0, */
	/* 86a0 */ 0,0,0,0xe9cf,0xc7c2,0,0,0, 0x8ff7c4,0xe9d0,0xe9d1,0xe9db,0,0,0,0xe9d5, /* 0,0,0,'蚣','蚤',0,0,0, '蚨','蚩','蚪','蚫',0,0,0,'蚯', */
	/* 86b0 */ 0xe9d8,0x8ff7c6,0,0x8ff7c7,0,0,0xe9d4,0, 0xfbd5,0,0,0,0,0,0,0, /* '蚰','蚱',0,'蚳',0,0,'蚶',0, '蚸',0,0,0,0,0,0,0, */
	/* 86c0 */ 0,0x8ff7c8,0,0x8ff7c9,0xe9d6,0,0xe9d7,0xbcd8, 0,0xe9d9,0,0xc3c1,0,0xb7d6,0xb3c2,0, /* 0,'蛁',0,'蛃','蛄',0,'蛆','蛇', 0,'蛉',0,'蛋',0,'蛍','蛎',0, */
	/* 86d0 */ 0,0x8ff7ca,0,0,0xe9dc,0x8ff7cb,0,0x8ff7cc, 0,0xb3bf,0,0xe9e1,0,0,0xe9dd,0xe9e0, /* 0,'蛑',0,0,'蛔','蛕',0,'蛗', 0,'蛙',0,'蛛',0,0,'蛞','蛟', */
	/* 86e0 */ 0,0,0,0x8ff7cd,0xc8ba,0,0x8ff7ce,0, 0,0xe9de,0,0,0xe9df,0xc9c8,0xc8da,0xe9e2, /* 0,0,0,'蛣','蛤',0,'蛦',0, 0,'蛩',0,0,'蛬','蛭','蛮','蛯', */
	/* 86f0 */ 0,0,0,0,0,0,0,0, 0xc2fd,0xe9ec,0xfbd6,0xe9e8,0xfbd7,0xfbd8,0xb2eb,0, /* 0,0,0,0,0,0,0,0, '蛸','蛹','蛺','蛻','蛼','蛽','蛾',0, */
	/* 8700 */ 0xe9e6,0,0xcbaa,0xe9e7,0,0x8ff7d0,0xe9e4,0x8ff7d1, 0xe9e5,0xe9ea,0xe9ed,0xfbd9,0,0xe9eb,0x8ff7d2,0, /* '蜀',0,'蜂','蜃',0,'蜅','蜆','蜇', '蜈','蜉','蜊','蜋',0,'蜍','蜎',0, */
	/* 8710 */ 0x8ff7d3,0xe9e9,0xe9e3,0x8ff7d4,0,0,0,0, 0xc3d8,0x8ff7d5,0xe9f4,0,0xccaa,0,0,0x8ff7d6, /* '蜐','蜑','蜒','蜓',0,0,0,0, '蜘','蜙','蜚',0,'蜜',0,0,'蜟', */
	/* 8720 */ 0,0x8ff7d7,0,0x8ff7d8,0,0xe9f2,0,0, 0,0xe9f3,0,0,0,0,0,0, /* 0,'蜡',0,'蜣',0,'蜥',0,0, 0,'蜩',0,0,0,0,0,0, */
	/* 8730 */ 0,0x8ff7d9,0,0,0xe9ee,0,0,0xe9f0, 0,0,0x8ff7da,0xe9f1,0,0,0x8ff7db,0xe9ef, /* 0,'蜱',0,0,'蜴',0,0,'蜷', 0,0,'蜺','蜻',0,0,'蜾','蜿', */
	/* 8740 */ 0x8ff7dc,0,0,0x8ff7dd,0,0,0,0, 0,0xc0e6,0,0xcfb9,0xe9f8,0,0xe9f9,0, /* '蝀',0,0,'蝃',0,0,0,0, 0,'蝉',0,'蝋','蝌',0,'蝎',0, */
	/* 8750 */ 0,0x8ff7de,0,0xeaa1,0,0xbfaa,0,0xe9fb, 0x8ff7df,0xe9fe,0,0,0,0,0,0xe9f6, /* 0,'蝑',0,'蝓',0,'蝕',0,'蝗', '蝘','蝙',0,0,0,0,0,'蝟', */
	/* 8760 */ 0xe9f5,0,0,0xeaa2,0x8ff7e0,0x8ff7e1,0xb2dc,0, 0xe9fc,0,0xeaa3,0,0,0,0xe9fd,0, /* '蝠',0,0,'蝣','蝤','蝥','蝦',0, '蝨',0,'蝪',0,0,0,'蝮',0, */
	/* 8770 */ 0,0xfbda,0x8ff7e2,0,0xe9fa,0,0xc4b3,0, 0xe9f7,0,0,0,0x8ff7e3,0,0,0xc7e8, /* 0,'蝱','蝲',0,'蝴',0,'蝶',0, '蝸',0,0,0,'蝼',0,0,'蝿', */
	/* 8780 */ 0,0,0xeaa7,0,0,0,0,0xfbdb, 0xfbdc,0x8ff7e7,0,0x8ff7e8,0,0xcdbb,0,0, /* 0,0,'螂',0,0,0,0,'螇', '螈','螉',0,'螋',0,'融',0,0, */
	/* 8790 */ 0,0,0,0x8ff7e9,0,0,0,0, 0,0,0,0,0,0,0,0xeaa6, /* 0,0,0,'螓',0,0,0,0, 0,0,0,0,0,0,0,'螟', */
	/* 87a0 */ 0x8ff7ea,0,0xeaa5,0,0,0,0,0x8ff7e6, 0,0,0,0xeaae,0xfbdd,0xfbde,0,0xeaa8, /* '螠',0,'螢',0,0,0,0,'螧', 0,0,0,'螫','螬','螭',0,'螯', */
	/* 87b0 */ 0,0,0,0xeab0,0,0xfbdf,0,0, 0,0,0xcde6,0xeab3,0,0xeaaa,0x8ff7ed,0, /* 0,0,0,'螳',0,'螵',0,0, 0,0,'螺','螻',0,'螽','螾',0, */
	/* 87c0 */ 0xeaab,0x8ff7ef,0,0,0xeaaf,0,0xeab2,0xeab1, 0,0,0,0xeaa9,0,0,0x8ff7f0,0, /* '蟀','蟁',0,0,'蟄',0,'蟆','蟇', 0,0,0,'蟋',0,0,'蟎',0, */
	/* 87d0 */ 0xeaac,0,0xeabd,0,0,0,0xfbe1,0, 0,0,0,0,0,0,0,0x8ff7f2, /* '蟐',0,'蟒',0,0,0,'蟖',0, 0,0,0,0,0,0,0,'蟟', */
	/* 87e0 */ 0xeab6,0,0,0x8ff7f4,0,0x8ff7f5,0x8ff7f6,0, 0,0,0x8ff7f7,0x8ff7f8,0xfbe2,0x8ff7f9,0,0xeab4, /* '蟠',0,0,'蟣',0,'蟥','蟦',0, 0,0,'蟪','蟫','蟬','蟭',0,'蟯', */
	/* 87f0 */ 0,0,0xeab5,0,0,0x8ff7f1,0xeaba,0xeabb, 0,0xb3aa,0,0xb5c2,0,0,0xeab9,0, /* 0,0,'蟲',0,0,'蟵','蟶','蟷', 0,'蟹',0,'蟻',0,0,'蟾',0, */
	/* 8800 */ 0,0x8ff7fa,0,0x8ff7fb,0,0xeaa4,0xfbe3,0, 0,0,0xfbe4,0x8ff7fc,0,0xeab8,0xeabc,0xeab7, /* 0,'蠁',0,'蠃',0,'蠅','蠆',0, 0,0,'蠊','蠋',0,'蠍','蠎','蠏', */
	/* 8810 */ 0xfbe5,0xeabe,0,0x8ff7fd,0xfbe6,0xeac0,0xeabf,0, 0,0,0,0,0,0,0,0xfbe7, /* '蠐','蠑',0,'蠓','蠔','蠕','蠖',0, 0,0,0,0,0,0,0,'蠟', */
	/* 8820 */ 0,0xeac2,0xeac1,0xe9da,0,0,0,0xeac6, 0x8ff7fe,0,0,0,0,0,0x8ff8a1,0, /* 0,'蠡','蠢','蠣',0,0,0,'蠧', '蠨',0,0,0,0,0,'蠮',0, */
	/* 8830 */ 0,0xeac3,0x8ff8a2,0,0,0,0xeac4,0, 0,0xeac5,0,0xeac7,0x8ff8a3,0,0,0, /* 0,'蠱','蠲',0,0,0,'蠶',0, 0,'蠹',0,'蠻','蠼',0,0,0, */
	/* 8840 */ 0xb7ec,0,0xeac9,0,0xeac8,0,0xbdb0,0, 0,0,0x8ff8a5,0,0xb9d4,0xdea7,0,0, /* '血',0,'衂',0,'衄',0,'衆',0, 0,0,'衊',0,'行','衍',0,0, */
	/* 8850 */ 0,0,0xeaca,0xbdd1,0,0,0,0xb3b9, 0x8ff8a6,0xeacb,0,0xb1d2,0,0xbed7,0xeacc,0x8ff8a7, /* 0,0,'衒','術',0,0,0,'街', '衘','衙',0,'衛',0,'衝','衞','衟', */
	/* 8860 */ 0,0xb9d5,0xeacd,0xb0e1,0x8ff8a8,0,0,0, 0xc9bd,0x8ff8ab,0,0xeace,0,0,0,0x8ff8ad, /* 0,'衡','衢','衣','衤',0,0,0, '表','衩',0,'衫',0,0,0,'衯', */
	/* 8870 */ 0xbfea,0,0xead5,0,0,0xead2,0,0xc3ef, 0,0,0,0,0,0xead3,0xead0,0xb6de, /* '衰',0,'衲',0,0,'衵',0,'衷', 0,0,0,0,0,'衽','衾','衿', */
	/* 8880 */ 0,0xeacf,0xead6,0,0,0,0,0, 0xb7b6,0,0,0xc2de,0,0xeadc,0,0, /* 0,'袁','袂',0,0,0,0,0, '袈',0,0,'袋',0,'袍',0,0, */
	/* 8890 */ 0,0,0xead8,0,0,0,0xc2b5,0xead7, 0xfbe8,0xeada,0,0,0,0,0xead1,0, /* 0,0,'袒',0,0,0,'袖','袗', '袘','袙',0,0,0,0,'袞',0, */
	/* 88a0 */ 0x8ff8ae,0,0xeadb,0,0xeadd,0,0,0, 0,0,0xfbe9,0xc8ef,0,0,0xead9,0, /* '袠',0,'袢',0,'袤',0,0,0, 0,0,'袪','被',0,0,'袮',0, */
	/* 88b0 */ 0xeade,0xeae0,0,0,0xb8d3,0xead4,0,0xb0c1, 0,0,0,0,0x8ff8af,0x8ff8b0,0x8ff8b1,0xeadf, /* '袰','袱',0,0,'袴','袵',0,'袷', 0,0,0,0,'袼','袽','袾','袿', */
	/* 88c0 */ 0x8ff8b2,0xbadb,0xcef6,0xeae1,0xeae2,0xc1f5,0,0, 0,0,0xfbea,0,0,0,0xfbeb,0xcea2, /* '裀','裁','裂','裃','裄','装',0,0, 0,0,'裊',0,0,0,'裎','裏', */
	/* 88d0 */ 0,0x8ff8b5,0x8ff8b3,0x8ff8b6,0xeae3,0xcdb5,0,0, 0xeae4,0xeae5,0,0x8ff8b7,0xcae4,0xeae6,0,0xbac0, /* 0,'裑','裒','裓','裔','裕',0,0, '裘','裙',0,'裛','補','裝',0,'裟', */
	/* 88e0 */ 0,0xcea3,0,0,0,0,0,0, 0xeaeb,0,0,0,0,0,0,0, /* 0,'裡',0,0,0,0,0,0, '裨',0,0,0,0,0,0,0, */
	/* 88f0 */ 0x8ff8b8,0x8ff8b9,0xeaec,0xbed8,0xeaea,0xfbed,0,0, 0xcde7,0xeae7,0,0,0xeae9,0xc0bd,0xbffe,0, /* '裰','裱','裲','裳','裴','裵',0,0, '裸','裹',0,0,'裼','製','裾',0, */
	/* 8900 */ 0,0x8ff8bb,0xeae8,0,0xeaed,0,0,0xcaa3, 0,0,0xeaef,0,0xeaee,0,0,0, /* 0,'褁','褂',0,'褄',0,0,'複', 0,0,'褊',0,'褌',0,0,0, */
	/* 8910 */ 0xb3ec,0,0xcbab,0xeaf0,0,0,0,0, 0xfbf0,0xfbf1,0xfbf2,0,0xfbee,0xeafc,0xeaf2,0, /* '褐',0,'褒','褓',0,0,0,0, '褘','褙','褚',0,'褜','褝','褞',0, */
	/* 8920 */ 0,0,0,0,0,0xeaf3,0,0xfbf3, 0,0,0xeaf4,0xeaf5,0,0,0,0, /* 0,0,0,0,0,'褥',0,'褧', 0,0,'褪','褫',0,0,0,0, */
	/* 8930 */ 0xfbf4,0,0xfbf5,0,0,0,0xeaf9,0x8ff8bd, 0xeafa,0xfbf6,0,0xeaf8,0,0,0,0, /* '褰',0,'褲',0,0,0,'褶','褷', '褸','褹',0,'褻',0,0,0,0, */
	/* 8940 */ 0xfbf7,0xeaf6,0x8ff8bf,0xeaf1,0xeaf7,0x8ff8c0,0,0, 0,0x8ff8c1,0,0,0xeafb,0xf0b7,0,0, /* '襀','襁','襂','襃','襄','襅',0,0, 0,'襉',0,0,'襌','襍',0,0, */
	/* 8950 */ 0,0,0,0,0,0,0xb2a8,0, 0,0,0,0,0,0,0xeafe,0xb6df, /* 0,0,0,0,0,0,'襖',0, 0,0,0,0,0,0,'襞','襟', */
	/* 8960 */ 0xeafd,0,0x8ff8c4,0,0xeba2,0,0xeba1,0, 0,0,0xeba4,0,0,0xeba3,0,0xeba5, /* '襠',0,'襢',0,'襤',0,'襦',0, 0,0,'襪',0,0,'襭',0,'襯', */
	/* 8970 */ 0,0,0xbdb1,0,0xeba6,0,0,0xeba7, 0,0,0,0,0,0,0xeba8,0xc0be, /* 0,0,'襲',0,'襴',0,0,'襷', 0,0,0,0,0,0,'襾','西', */
	/* 8980 */ 0x8ff8c5,0xcdd7,0,0xeba9,0,0,0xcaa4,0xc7c6, 0xebaa,0x8ff8c6,0xebab,0xb8ab,0,0,0,0xb5ac, /* '覀','要',0,'覃',0,0,'覆','覇', '覈','覉','覊','見',0,0,0,'規', */
	/* 8990 */ 0x8ff8c7,0,0,0xebac,0xfbf8,0,0xbbeb,0xc7c1, 0xebad,0,0xb3d0,0,0,0,0,0x8ff8c8, /* '覐',0,0,'覓','覔',0,'視','覗', '覘',0,'覚',0,0,0,0,'覟', */
	/* 89a0 */ 0,0xebae,0,0,0,0,0xebb0,0xcdf7, 0,0xebaf,0xbfc6,0,0xebb1,0,0,0xebb2, /* 0,'覡',0,0,0,0,'覦','覧', 0,'覩','親',0,'覬',0,0,'覯', */
	/* 89b0 */ 0x8ff8c9,0,0xebb3,0xb4d1,0,0,0,0x8ff8ca, 0,0,0xebb4,0,0,0xebb5,0,0xebb6, /* '覰',0,'覲','観',0,0,0,'覷', 0,0,'覺',0,0,'覽',0,'覿', */
	/* 89c0 */ 0xebb7,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '觀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 89d0 */ 0,0,0xb3d1,0,0xfbfa,0,0x8ff8cb,0, 0x8ff8cc,0,0xebb8,0,0xebb9,0xebba,0,0, /* 0,0,'角',0,'觔',0,'觖',0, '觘',0,'觚',0,'觜','觝',0,0, */
	/* 89e0 */ 0,0,0,0xb2f2,0,0xfbfb,0xbfa8,0xebbb, 0,0,0,0x8ff8cd,0,0,0,0, /* 0,0,0,'解',0,'觥','触','觧', 0,0,0,'觫',0,0,0,0, */
	/* 89f0 */ 0,0x8ff8cf,0,0x8ff8d0,0xebbc,0,0xfbfc,0, 0xebbd,0,0,0,0,0x8ff8d1,0,0x8ff8d2, /* 0,'觱',0,'觳','觴',0,'觶',0, '觸',0,0,0,0,'觽',0,'觿', */
	/* 8a00 */ 0xb8c0,0,0xc4fb,0xebbe,0,0,0,0, 0xb7d7,0,0xbfd6,0,0xebc1,0,0xc6a4,0, /* '言',0,'訂','訃',0,0,0,0, '計',0,'訊',0,'訌',0,'討',0, */
	/* 8a10 */ 0xebc0,0x8ff8d4,0xfbfd,0xb7b1,0x8ff8d5,0xfbfe,0xebbf,0xc2f7, 0xb5ad,0,0,0xebc2,0,0xebc3,0,0xbed9, /* '訐','訑','訒','訓','訔','訕','訖','託', '記',0,0,'訛',0,'訝',0,'訟', */
	/* 8a20 */ 0,0x8ff8d7,0xfca1,0xb7ed,0,0xebc4,0,0, 0,0,0xcbac,0,0,0xc0df,0,0, /* 0,'訡','訢','訣',0,'訥',0,0, 0,0,'訪',0,0,'設',0,0, */
	/* 8a30 */ 0,0xb5f6,0,0xccf5,0xc1ca,0x8ff8d8,0xebc5,0xfca2, 0,0,0xbfc7,0xc3f0,0xbeda,0,0x8ff8d9,0, /* 0,'許',0,'訳','訴','訵','訶','訷', 0,0,'診','註','証',0,'訾',0, */
	/* 8a40 */ 0,0xebc6,0,0,0,0x8ff8da,0xebc9,0xfca3, 0xebca,0,0,0,0,0x8ff8db,0xfca4,0, /* 0,'詁',0,0,0,'詅','詆','詇', '詈',0,0,0,0,'詍','詎',0, */
	/* 8a50 */ 0xbabe,0xc2c2,0xebc8,0,0xbedb,0xc9be,0,0, 0x8ff8dc,0,0,0xebc7,0,0xfca5,0xbbec,0, /* '詐','詑','詒',0,'詔','評',0,0, '詘',0,0,'詛',0,'詝','詞',0, */
	/* 8a60 */ 0xb1d3,0xfca6,0xebce,0xb7d8,0,0,0xbbee,0, 0,0xbbed,0,0xcfcd,0xebcd,0xebcc,0xc1a7,0, /* '詠','詡','詢','詣',0,0,'試',0, 0,'詩',0,'詫','詬','詭','詮',0, */
	/* 8a70 */ 0xb5cd,0xcfc3,0xb3ba,0xbedc,0,0xfca7,0,0, 0,0xfca8,0,0,0xebcb,0,0,0, /* '詰','話','該','詳',0,'詵',0,0, 0,'詹',0,0,'詼',0,0,0, */
	/* 8a80 */ 0,0,0xebd0,0,0xebd1,0xebcf,0,0xb8d8, 0,0xcdc0,0,0,0xbbef,0xc7a7,0,0, /* 0,0,'誂',0,'誄','誅',0,'誇', 0,'誉',0,0,'誌','認',0,0, */
	/* 8a90 */ 0x8ff8de,0xebd4,0,0xc0c0,0,0xc3c2,0,0, 0xcdb6,0,0xebd7,0,0,0,0xb8ec,0, /* '誐','誑',0,'誓',0,'誕',0,0, '誘',0,'誚',0,0,0,'語',0, */
	/* 8aa0 */ 0xc0bf,0xebd3,0,0xebd8,0xb8ed,0xebd5,0xebd6,0xfca9, 0xebd2,0,0,0,0xc0e2,0xc6c9,0x8ff8dd,0, /* '誠','誡',0,'誣','誤','誥','誦','誧', '誨',0,0,0,'説','読','誮',0, */
	/* 8ab0 */ 0xc3af,0,0xb2dd,0,0,0,0,0x8ff8df, 0,0xc8f0,0,0,0xb5c3,0,0x8ff8e0,0xc4b4, /* '誰',0,'課',0,0,0,0,'誷', 0,'誹',0,0,'誼',0,'誾','調', */
	/* 8ac0 */ 0,0,0xebdb,0,0xebd9,0,0,0xc3cc, 0,0,0,0xc0c1,0xb4d2,0xebda,0,0xbfdb, /* 0,0,'諂',0,'諄',0,0,'談', 0,0,0,'請','諌','諍',0,'諏', */
	/* 8ad0 */ 0xfcaa,0,0xceca,0,0,0,0xcfc0,0x8ff8e1, 0,0,0xebdc,0xebe7,0xc4b5,0,0xebe6,0xfcab, /* '諐',0,'諒',0,0,0,'論','諗', 0,0,'諚','諛','諜',0,'諞','諟', */
	/* 8ae0 */ 0xebe3,0xebeb,0xebe4,0,0xebe0,0,0xc4fc,0xebdf, 0,0,0,0xebdd,0,0xcda1,0xbbf0,0, /* '諠','諡','諢',0,'諤',0,'諦','諧', 0,0,0,'諫',0,'諭','諮',0, */
	/* 8af0 */ 0,0xebe1,0,0xebde,0xfcac,0,0xfcad,0xebe5, 0xbdf4,0,0xb8c1,0,0x8ff8e2,0,0xc2fa,0, /* 0,'諱',0,'諳','諴',0,'諶','諷', '諸',0,'諺',0,'諼',0,'諾',0, */
	/* 8b00 */ 0xcbc5,0xb1da,0xb0e2,0,0xc6a5,0x8ff8e5,0,0xebe9, 0,0,0x8ff8e4,0,0xebe8,0x8ff8e6,0xc6e6,0, /* '謀','謁','謂',0,'謄','謅',0,'謇', 0,0,'謊',0,'謌','謍','謎',0, */
	/* 8b10 */ 0xebed,0,0,0,0xebe2,0,0xebec,0xebee, 0,0xb8ac,0xebea,0xb9d6,0x8ff8e7,0xbcd5,0,0x8ff8e8, /* '謐',0,0,0,'謔',0,'謖','謗', 0,'謙','謚','講','謜','謝',0,'謟', */
	/* 8b20 */ 0xebef,0xcdd8,0,0,0,0,0xebf2,0, 0xebf5,0,0,0xebf3,0xc9b5,0x8ff8e9,0,0, /* '謠','謡',0,0,0,0,'謦',0, '謨',0,0,'謫','謬','謭',0,0, */
	/* 8b30 */ 0,0,0,0xebf0,0,0,0,0, 0,0xb6e0,0,0,0,0,0xebf4,0, /* 0,0,0,'謳',0,0,0,0, 0,'謹',0,0,0,0,'謾',0, */
	/* 8b40 */ 0,0xebf6,0,0x8ff8ea,0,0,0xfcb1,0, 0,0xebfa,0,0,0xebf7,0,0xebf9,0xebf8, /* 0,'譁',0,'譃',0,0,'譆',0, 0,'證',0,0,'譌',0,'譎','譏', */
	/* 8b50 */ 0,0x8ff8ec,0,0,0xfcb2,0,0xebfb,0, 0xbcb1,0xfcb3,0xebfd,0xebfc,0xc9e8,0,0x8ff8ed,0xeca1, /* 0,'譑',0,0,'譔',0,'譖',0, '識','譙','譚','譛','譜',0,'譞','譟', */
	/* 8b60 */ 0,0,0,0,0,0,0xb7d9,0, 0,0xfcb4,0,0xebfe,0xeca2,0,0,0xeca3, /* 0,0,0,0,0,0,'警',0, 0,'譩',0,'譫','譬',0,0,'譯', */
	/* 8b70 */ 0xb5c4,0xe6c1,0xbef9,0,0xeca4,0,0x8ff8ee,0xb8ee, 0,0,0,0,0,0xeca5,0,0x8ff8ef, /* '議','譱','譲',0,'譴',0,'譶','護', 0,0,0,0,0,'譽',0,'譿', */
	/* 8b80 */ 0xeca6,0x8ff8f0,0,0xbbbe,0,0,0,0, 0,0,0xdace,0x8ff8f1,0xeca7,0,0xeca8,0, /* '讀','讁',0,'讃',0,0,0,0, 0,0,'變','讋','讌',0,'讎',0, */
	/* 8b90 */ 0xbdb2,0,0xeca9,0xecaa,0x8ff8f2,0x8ff8f3,0xecab,0, 0,0xecac,0xecad,0,0x8ff8f4,0xfcb5,0x8ff8f5,0, /* '讐',0,'讒','讓','讔','讕','讖',0, 0,'讙','讚',0,'讜','讝','讞',0, */
	/* 8ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c30 */ 0,0,0,0,0,0,0,0xc3ab, 0,0x8ff8f6,0xecae,0,0,0x8ff8f8,0,0xecb0, /* 0,0,0,0,0,0,0,'谷', 0,'谹','谺',0,0,'谽',0,'谿', */
	/* 8c40 */ 0,0xecaf,0,0,0,0x8ff8fb,0xc6a6,0x8ff8fc, 0xecb1,0xfcb6,0xcbad,0,0xecb2,0,0xecb3,0x8ff8fd, /* 0,'豁',0,0,0,'豅','豆','豇', '豈','豉','豊',0,'豌',0,'豎','豏', */
	/* 8c50 */ 0xecb4,0,0,0,0x8ff8fe,0xecb5,0,0x8ff9a1, 0,0,0xc6da,0,0,0,0,0, /* '豐',0,0,0,'豔','豕',0,'豗', 0,0,'豚',0,0,0,0,0, */
	/* 8c60 */ 0,0xbedd,0xecb6,0,0,0,0,0, 0xfcb7,0x8ff9a2,0xb9eb,0xd0ae,0xecb7,0x8ff9a3,0,0, /* 0,'象','豢',0,0,0,0,0, '豨','豩','豪','豫','豬','豭',0,0, */
	/* 8c70 */ 0,0,0,0x8ff9a4,0,0,0,0, 0xecb8,0xc9bf,0xecb9,0,0xecc1,0,0,0, /* 0,0,0,'豳',0,0,0,0, '豸','豹','豺',0,'豼',0,0,0, */
	/* 8c80 */ 0,0,0xecba,0,0,0xecbc,0,0, 0,0xecbb,0xecbd,0,0xcbc6,0xecbe,0xecbf,0, /* 0,0,'貂',0,0,'貅',0,0, 0,'貉','貊',0,'貌','貍','貎',0, */
	/* 8c90 */ 0,0,0x8ff9a7,0x8ff9a6,0xecc0,0,0,0, 0xecc2,0x8ff9a8,0,0x8ff9aa,0,0xb3ad,0xc4e7,0, /* 0,0,'貒','貓','貔',0,0,0, '貘','貙',0,'貛',0,'貝','貞',0, */
	/* 8ca0 */ 0xc9e9,0xbae2,0xb9d7,0,0x8ff9ab,0,0,0xc9cf, 0xb2df,0xc8ce,0xecc5,0xb4d3,0xc0d5,0xecc4,0xecc9,0xc3f9, /* '負','財','貢',0,'貤',0,0,'貧', '貨','販','貪','貫','責','貭','貮','貯', */
	/* 8cb0 */ 0xcce3,0,0xecc7,0xecc8,0xb5ae,0,0xecca,0xc7e3, 0xc2df,0,0,0xc8f1,0xc5bd,0xecc6,0,0xcbc7, /* '貰',0,'貲','貳','貴',0,'貶','買', '貸',0,0,'費','貼','貽',0,'貿', */
	/* 8cc0 */ 0xb2ec,0xeccc,0xcfa8,0xc4c2,0xcfc5,0,0,0xbbf1, 0xeccb,0,0xc2b1,0,0,0xecdc,0xc1a8,0, /* '賀','賁','賂','賃','賄',0,0,'資', '賈',0,'賊',0,0,'賍','賎',0, */
	/* 8cd0 */ 0,0xc6f8,0,0xc9d0,0,0x8ff9ad,0x8ff9ac,0, 0,0x8ff9ae,0xeccf,0xbbbf,0xbbf2,0,0xbede,0, /* 0,'賑',0,'賓',0,'賕','賖',0, 0,'賙','賚','賛','賜',0,'賞',0, */
	/* 8ce0 */ 0xc7e5,0xfcb9,0xb8ad,0xecce,0xeccd,0,0xc9ea,0, 0,0,0xbcc1,0,0,0xc5d2,0,0, /* '賠','賡','賢','賣','賤',0,'賦',0, 0,0,'質',0,0,'賭',0,0, */
	/* 8cf0 */ 0x8ff9b0,0x8ff9b1,0,0,0xfcba,0,0,0, 0xfcbb,0,0xecd1,0xecd2,0xb9d8,0xecd0,0xfcbc,0, /* '賰','賱',0,0,'賴',0,0,0, '賸',0,'賺','賻','購','賽','賾',0, */
	/* 8d00 */ 0,0,0,0,0xecd3,0xecd4,0,0xecd6, 0xc2a3,0x8ff9b3,0xecd5,0xb4e6,0,0xecd8,0x8ff9b4,0xecd7, /* 0,0,0,0,'贄','贅',0,'贇', '贈','贉','贊','贋',0,'贍','贎','贏', */
	/* 8d10 */ 0xecd9,0,0xfcbe,0xecdb,0xecdd,0,0xecde,0, 0,0,0,0xfcbf,0,0,0,0, /* '贐',0,'贒','贓','贔',0,'贖',0, 0,0,0,'贛',0,0,0,0, */
	/* 8d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d60 */ 0,0,0,0,0xc0d6,0,0xbccf,0xecdf, 0,0,0,0xb3d2,0x8ff9b5,0xece0,0,0, /* 0,0,0,0,'赤',0,'赦','赧', 0,0,0,'赫','赬','赭',0,0, */
	/* 8d70 */ 0xc1f6,0xece1,0,0xece2,0xc9eb,0,0,0xb5af, 0,0,0,0,0,0,0,0, /* '走','赱',0,'赳','赴',0,0,'起', 0,0,0,0,0,0,0,0, */
	/* 8d80 */ 0,0xece3,0,0,0x8ff9b6,0xc4b6,0,0, 0,0,0xb1db,0,0,0,0,0, /* 0,'趁',0,0,'趄','超',0,0, 0,0,'越',0,0,0,0,0, */
	/* 8d90 */ 0,0,0,0,0,0x8ff9b7,0,0, 0,0xece4,0,0,0,0,0,0, /* 0,0,0,0,0,'趕',0,0, 0,'趙',0,0,0,0,0,0, */
	/* 8da0 */ 0,0,0,0xbcf1,0,0,0x8ff9b8,0, 0xbff6,0,0,0,0,0,0,0xfcc0, /* 0,0,0,'趣',0,0,'趦',0, '趨',0,0,0,0,0,0,'趯', */
	/* 8db0 */ 0,0,0,0xc2ad,0,0,0,0, 0,0,0xece7,0,0,0,0xece6,0, /* 0,0,0,'足',0,0,0,0, 0,0,'趺',0,0,0,'趾',0, */
	/* 8dc0 */ 0,0,0xece5,0,0,0,0x8ff9ba,0, 0x8ff9bb,0,0,0xeced,0xeceb,0,0xfcc1,0xece8, /* 0,0,'跂',0,0,0,'跆',0, '跈',0,0,'跋','跌',0,'跎','跏', */
	/* 8dd0 */ 0,0xfcc2,0,0,0,0,0xecea,0xfcc3, 0,0x8ff9bc,0xece9,0xecec,0,0xb5f7,0,0xecf0, /* 0,'跑',0,0,0,0,'跖','跗', 0,'跙','跚','跛',0,'距',0,'跟', */
	/* 8de0 */ 0,0xc0d7,0,0xecf1,0,0,0,0, 0xb8d9,0,0xecee,0xecef,0x8ff9bd,0,0,0xcfa9, /* 0,'跡',0,'跣',0,0,0,0, '跨',0,'跪','跫','跬',0,0,'路', */
	/* 8df0 */ 0,0,0,0xc4b7,0,0xc1a9,0,0, 0,0,0,0,0xecf2,0x8ff9c0,0,0xecf5, /* 0,0,0,'跳',0,'践',0,0, 0,0,0,0,'跼','跽',0,'跿', */
	/* 8e00 */ 0,0,0,0,0,0,0x8ff9c1,0, 0xecf3,0xecf4,0xcdd9,0,0x8ff9be,0,0,0xc6a7, /* 0,0,0,0,0,0,'踆',0, '踈','踉','踊',0,'踌',0,0,'踏', */
	/* 8e10 */ 0xecf8,0,0,0,0x8ff9c3,0,0x8ff9c4,0, 0,0,0,0,0,0xecf6,0xecf7,0xecf9, /* '踐',0,0,0,'踔',0,'踖',0, 0,0,0,0,0,'踝','踞','踟', */
	/* 8e20 */ 0xfcc4,0x8ff9c5,0x8ff9c6,0xfcc5,0,0,0,0x8ff9c7, 0,0,0xeda9,0,0,0,0,0, /* '踠','踡','踢','踣',0,0,0,'踧', 0,0,'踪',0,0,0,0,0, */
	/* 8e30 */ 0xecfc,0,0,0,0xecfd,0xecfb,0x8ff9ca,0, 0,0x8ff9cb,0,0,0,0xfcc6,0,0, /* '踰',0,0,0,'踴','踵','踶',0, 0,'踹',0,0,0,'踽',0,0, */
	/* 8e40 */ 0,0,0xecfa,0,0xc4fd,0,0,0xeda1, 0xeda5,0xeda2,0xecfe,0x8ff9cc,0xeda3,0,0,0, /* 0,0,'蹂',0,'蹄',0,0,'蹇', '蹈','蹉','蹊','蹋','蹌',0,0,0, */
	/* 8e50 */ 0xeda4,0,0,0,0x8ff9cd,0xedab,0,0, 0,0xeda6,0,0,0,0,0,0xc0d8, /* '蹐',0,0,0,'蹔','蹕',0,0, 0,'蹙',0,0,0,0,0,'蹟', */
	/* 8e60 */ 0xeda8,0,0x8ff9ce,0xedaa,0xeda7,0,0,0, 0,0,0,0,0x8ff9cf,0x8ff9d0,0,0x8ff9d1, /* '蹠',0,'蹢','蹣','蹤',0,0,0, 0,0,0,0,'蹬','蹭',0,'蹯', */
	/* 8e70 */ 0xfcc7,0,0xedad,0,0xbdb3,0,0xedac,0, 0,0,0,0xfcc8,0xedae,0,0,0, /* '蹰',0,'蹲',0,'蹴',0,'蹶',0, 0,0,0,'蹻','蹼',0,0,0, */
	/* 8e80 */ 0,0xedaf,0,0,0xedb2,0xedb1,0,0xedb0, 0,0,0xedb4,0xedb3,0,0xccf6,0,0, /* 0,'躁',0,0,'躄','躅',0,'躇', 0,0,'躊','躋',0,'躍',0,0, */
	/* 8e90 */ 0,0xedb6,0,0xedb5,0xedb7,0,0,0, 0x8ff9d2,0xedb8,0,0,0,0,0x8ff9d3,0, /* 0,'躑',0,'躓','躔',0,0,0, '躘','躙',0,0,0,0,'躞',0, */
	/* 8ea0 */ 0,0xedba,0,0,0,0,0,0, 0,0,0xedb9,0xbfc8,0xedbb,0,0x8ff9d4,0xb6ed, /* 0,'躡',0,0,0,0,0,0, 0,0,'躪','身','躬',0,'躮','躯', */
	/* 8eb0 */ 0xedbc,0xedbe,0,0x8ff9d5,0,0x8ff9d6,0x8ff9d7,0, 0,0,0,0x8ff9d8,0,0,0xedbf,0, /* '躰','躱',0,'躳',0,'躵','躶',0, 0,0,0,'躻',0,0,'躾',0, */
	/* 8ec0 */ 0xfcca,0,0,0,0,0xedc0,0xedbd,0, 0xedc1,0,0xbcd6,0xedc2,0xb5b0,0xb7b3,0,0, /* '軀',0,0,0,0,'軅','軆',0, '軈',0,'車','軋','軌','軍',0,0, */
	/* 8ed0 */ 0,0x8ff9da,0xb8ae,0,0x8ff9db,0,0,0, 0,0,0,0xedc3,0,0,0,0xc6f0, /* 0,'軑','軒',0,'軔',0,0,0, 0,0,0,'軛',0,0,0,'軟', */
	/* 8ee0 */ 0,0,0xc5be,0xedc4,0,0,0,0, 0,0,0,0xedc7,0,0,0,0, /* 0,0,'転','軣',0,0,0,0, 0,0,0,'軫',0,0,0,0, */
	/* 8ef0 */ 0,0,0,0,0,0,0,0, 0xbcb4,0x8ff9dd,0xfccc,0xedc6,0xedc5,0xb7da,0xedc8,0, /* 0,0,0,0,0,0,0,0, '軸','軹','軺','軻','軼','軽','軾',0, */
	/* 8f00 */ 0x8ff9df,0,0,0xb3d3,0,0xedca,0,0, 0x8ff9e0,0xbadc,0xedc9,0,0xedd2,0,0,0, /* '輀',0,0,'較',0,'輅',0,0, '輈','載','輊',0,'輌',0,0,0, */
	/* 8f10 */ 0,0,0xedcc,0xedce,0xcae5,0xedcb,0,0x8ff9e1, 0,0xedcd,0,0xedd1,0xedcf,0xb5b1,0xfccd,0xedd0, /* 0,0,'輒','輓','輔','輕',0,'輗', 0,'輙',0,'輛','輜','輝','輞','輟', */
	/* 8f20 */ 0,0,0,0,0,0,0xedd3,0, 0,0xc7da,0xced8,0x8ff9e2,0,0xfcce,0,0xbdb4, /* 0,0,0,0,0,0,'輦',0, 0,'輩','輪','輫',0,'輭',0,'輯', */
	/* 8f30 */ 0,0,0,0xedd4,0,0,0xfccf,0, 0xcda2,0xedd6,0,0xedd5,0,0,0xedd9,0xcdc1, /* 0,0,0,'輳',0,0,'輶',0, '輸','輹',0,'輻',0,0,'輾','輿', */
	/* 8f40 */ 0x8ff9e3,0,0xedd8,0,0xb3ed,0xedd7,0xeddc,0, 0,0xeddb,0x8ff9e4,0,0xedda,0xc5b2,0xeddd,0, /* '轀',0,'轂',0,'轄','轅','轆',0, 0,'轉','轊',0,'轌','轍','轎',0, */
	/* 8f50 */ 0,0,0,0,0xfcd0,0,0,0xedde, 0x8ff9e5,0,0,0,0xeddf,0,0,0xb9ec, /* 0,0,0,0,'轔',0,0,'轗', '轘',0,0,0,'轜',0,0,'轟', */
	/* 8f60 */ 0,0xb7a5,0xede0,0xede1,0xede2,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'轡','轢','轣','轤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0xbfc9,0xede3,0,0xbcad,0xede4, /* 0,0,0,0,0,0,0,0, 0,0,0,'辛','辜',0,'辞','辟', */
	/* 8fa0 */ 0,0,0,0xede5,0x8ff9e7,0,0xfcd2,0xd2a1, 0xd1fe,0,0,0,0,0xede6,0xe5f0,0xede7, /* 0,0,0,'辣','辤',0,'辦','辧', '辨',0,0,0,0,'辭','辮','辯', */
	/* 8fb0 */ 0xc3a4,0xbfab,0xc7c0,0,0x8ff9e8,0xfcd3,0x8ff9ea,0xede8, 0,0,0xcad5,0xc4d4,0xb9fe,0,0,0xc3a9, /* '辰','辱','農',0,'辴','辵','辶','辷', 0,0,'辺','辻','込',0,0,'辿', */
	/* 8fc0 */ 0,0x8ff9ec,0xb1aa,0,0xcbf8,0xbfd7,0x8ff9ed,0, 0,0,0x8ff9ef,0,0,0x8ff9f0,0xb7de,0, /* 0,'迁','迂',0,'迄','迅','迆',0, 0,0,'迊',0,0,'迍','迎',0, */
	/* 8fd0 */ 0,0xb6e1,0,0x8ff9f1,0xcad6,0x8ff9f2,0,0, 0,0,0xede9,0,0,0,0,0, /* 0,'近',0,'迓','返','迕',0,0, 0,0,'迚',0,0,0,0,0, */
	/* 8fe0 */ 0x8ff9f3,0,0xedeb,0,0xfcd4,0xedea,0xb2e0,0, 0xfcd5,0xc6f6,0xedec,0xc7f7,0,0xc5b3,0xfcd6,0xeded, /* '迠',0,'迢',0,'迤','迥','迦',0, '迨','迩','迪','迫',0,'迭','迮','迯', */
	/* 8ff0 */ 0xbdd2,0x8ff9f4,0,0,0xedef,0x8ff9f5,0,0xccc2, 0xedfe,0xedf1,0xedf2,0x8ff9f6,0,0xc4c9,0,0, /* '述','迱',0,0,'迴','迵',0,'迷', '迸','迹','迺','迻',0,'追',0,0, */
	/* 9000 */ 0xc2e0,0xc1f7,0x8ff9f7,0xc6a8,0,0xedf0,0xb5d5,0, 0xfcd7,0,0,0xedf9,0x8ff9f8,0xedf6,0xeea5,0xc6a9, /* '退','送','适','逃',0,'逅','逆',0, '逈',0,0,'逋','逌','逍','逎','透', */
	/* 9010 */ 0xc3e0,0xedf3,0,0xc4fe,0xc5d3,0xedf4,0xedf8,0xbfe0, 0,0xc7e7,0xc4cc,0,0,0xc0c2,0xedf7,0xc2ae, /* '逐','逑',0,'逓','途','逕','逖','逗', 0,'這','通',0,0,'逝','逞','速', */
	/* 9020 */ 0xc2a4,0xedf5,0xb0a9,0xcfa2,0,0,0,0xedfa, 0,0,0,0,0,0xfcd8,0xc2e1,0, /* '造','逡','逢','連',0,0,0,'逧', 0,0,0,0,0,'逭','逮',0, */
	/* 9030 */ 0,0xbdb5,0xbfca,0,0,0xedfc,0xedfb,0x8ff9f9, 0xb0ef,0xedfd,0,0,0xc9af,0,0xeea7,0, /* 0,'週','進',0,0,'逵','逶','逷', '逸','逹',0,0,'逼',0,'逾',0, */
	/* 9040 */ 0,0xc6db,0xbfeb,0x8ff9fb,0x8ff9fc,0xc3d9,0,0xb6f8, 0,0xeea6,0xcdb7,0xb1bf,0,0xcad7,0xb2e1,0xeea1, /* 0,'遁','遂','遃','遄','遅',0,'遇', 0,'遉','遊','運',0,'遍','過','遏', */
	/* 9050 */ 0xeea2,0xeea3,0xeea4,0xc6bb,0xc3a3,0xb0e3,0xeea8,0, 0xeea9,0xf4a3,0,0,0xc2bd,0x8ff9fd,0xeeaa,0, /* '遐','遑','遒','道','達','違','遖',0, '遘','遙',0,0,'遜','遝','遞',0, */
	/* 9060 */ 0xb1f3,0xc1cc,0,0xb8af,0,0xcdda,0,0, 0xeeab,0xc5ac,0,0,0,0xc1f8,0xbcd7,0xeeac, /* '遠','遡',0,'遣',0,'遥',0,0, '遨','適',0,0,0,'遭','遮','遯', */
	/* 9070 */ 0,0,0xeeaf,0,0,0xbde5,0xeead,0xc1ab, 0xc1aa,0,0xb0e4,0,0xcecb,0xeeb1,0,0xc8f2, /* 0,0,'遲',0,0,'遵','遶','遷', '選',0,'遺',0,'遼','遽',0,'避', */
	/* 9080 */ 0xeeb3,0xeeb2,0xeeb0,0xe3e4,0xb4d4,0x8ffaa2,0,0xedee, 0xfcda,0xeeb5,0xeeb4,0,0x8ffaa3,0,0,0xeeb6, /* '邀','邁','邂','邃','還','邅',0,'邇', '邈','邉','邊',0,'邌',0,0,'邏', */
	/* 9090 */ 0x8ffaa4,0xcdb8,0,0,0,0xfcdb,0,0xfcdc, 0,0xfcdd,0,0xfcde,0,0,0,0, /* '邐','邑',0,0,0,'邕',0,'邗', 0,'邙',0,'邛',0,0,0,0, */
	/* 90a0 */ 0,0x8ffaa6,0xfcdf,0xc6e1,0,0,0xcbae,0, 0xeeb7,0,0xbcd9,0,0,0,0,0xeeb8, /* 0,'邡','邢','那',0,0,'邦',0, '邨',0,'邪',0,0,0,0,'邯', */
	/* 90b0 */ 0x8ffaa8,0xeeb9,0,0xfce0,0,0xeeba,0x8ffaa9,0, 0xc5a1,0,0,0,0,0,0xfce1,0, /* '邰','邱',0,'邳',0,'邵','邶',0, '邸',0,0,0,0,0,'邾',0, */
	/* 90c0 */ 0,0xb0ea,0,0x8ffaaa,0xfce2,0xfce3,0,0xfce4, 0x8ffaab,0,0xb9d9,0,0,0,0xcfba,0, /* 0,'郁',0,'郃','郄','郅',0,'郇', '郈',0,'郊',0,0,0,'郎',0, */
	/* 90d0 */ 0,0,0,0,0,0,0,0xfce5, 0,0,0,0xeebe,0x8ffaad,0xfce6,0xfce7,0x8ffaae, /* 0,0,0,0,0,0,0,'郗', 0,0,0,'郛','郜','郝','郞','郟', */
	/* 90e0 */ 0,0xb7b4,0xeebb,0,0xeebc,0,0,0, 0xc9f4,0,0,0x8ffab3,0,0xb3d4,0,0xfce8, /* 0,'郡','郢',0,'郤',0,0,0, '部',0,0,'郫',0,'郭',0,'郯', */
	/* 90f0 */ 0,0,0x8ffab1,0,0xfce9,0xcdb9,0x8ffab0,0xb6bf, 0,0,0,0,0,0xc5d4,0x8ffab4,0x8ffab5, /* 0,0,'郲',0,'郴','郵','郶','郷', 0,0,0,0,0,'都','郾','郿', */
	/* 9100 */ 0x8ffab2,0,0xeebf,0,0x8ffab6,0,0x8ffab7,0, 0,0,0,0,0,0,0,0, /* '鄀',0,'鄂',0,'鄄',0,'鄆',0, 0,0,0,0,0,0,0,0, */
	/* 9110 */ 0,0,0xeec0,0,0xfceb,0xfcec,0xfced,0, 0x8ffab8,0xeec1,0,0,0x8ffab9,0,0x8ffaba,0, /* 0,0,'鄒',0,'鄔','鄕','鄖',0, '鄘','鄙',0,0,'鄜',0,'鄞',0, */
	/* 9120 */ 0,0,0xfcee,0xfcef,0,0,0,0xfcf0, 0,0,0,0,0,0xc5a2,0,0xfcf1, /* 0,0,'鄢','鄣',0,0,0,'鄧', 0,0,0,0,0,'鄭',0,'鄯', */
	/* 9130 */ 0xeec3,0xfcf2,0xeec2,0,0xfcf3,0,0,0x8ffabb, 0,0x8ffabc,0x8ffabd,0,0,0xfcf4,0,0, /* '鄰','鄱','鄲',0,'鄴',0,0,'鄷', 0,'鄹','鄺',0,0,'鄽',0,0, */
	/* 9140 */ 0,0,0,0,0,0,0x8ffabe,0x8ffabf, 0xfcf5,0xc6d3,0xeec4,0xbdb6,0xbce0,0xc7db,0xc3f1,0, /* 0,0,0,0,0,0,'酆','酇', '酈','酉','酊','酋','酌','配','酎',0, */
	/* 9150 */ 0,0,0xbcf2,0,0xbfec,0,0xeec5,0x8ffac0, 0xeec6,0x8ffac1,0,0xfcf6,0,0,0,0, /* 0,0,'酒',0,'酔',0,'酖','酗', '酘','酙',0,'酛',0,0,0,0, */
	/* 9160 */ 0,0x8ffac2,0xbfdd,0xeec7,0x8ffac3,0xeec8,0,0, 0,0xeec9,0xcdef,0,0xbdb7,0,0,0, /* 0,'酡','酢','酣','酤','酥',0,0, 0,'酩','酪',0,'酬',0,0,0, */
	/* 9170 */ 0,0,0xeecb,0xeeca,0x8ffac4,0xb9da,0,0xb9f3, 0xbbc0,0x8ffac5,0,0,0,0,0,0, /* 0,0,'酲','酳','酴','酵',0,'酷', '酸','酹',0,0,0,0,0,0, */
	/* 9180 */ 0,0,0xeece,0xfcf7,0,0x8ffac6,0,0xbde6, 0,0xeecd,0,0xeecc,0,0xc2e9,0x8ffac7,0, /* 0,0,'醂','醃',0,'醅',0,'醇', 0,'醉',0,'醋',0,'醍','醎',0, */
	/* 9190 */ 0xb8ef,0,0xc0c3,0,0,0,0,0xc8b0, 0,0,0,0,0xbdb9,0,0xfcf8,0, /* '醐',0,'醒',0,0,0,0,'醗', 0,0,0,0,'醜',0,'醞',0, */
	/* 91a0 */ 0,0,0xeecf,0,0xbedf,0,0,0, 0x8ffac8,0,0xeed2,0xeed0,0xfcf9,0,0x8ffac9,0xeed1, /* 0,0,'醢',0,'醤',0,0,0, '醨',0,'醪','醫','醬',0,'醮','醯', */
	/* 91b0 */ 0,0xfcfa,0,0x8ffaca,0xeed4,0xeed3,0x8ffacb,0, 0xbefa,0,0xeed5,0,0xfcfb,0,0,0, /* 0,'醱',0,'醳','醴','醵','醶',0, '醸',0,'醺',0,'醼',0,0,0, */
	/* 91c0 */ 0xeed6,0xeed7,0,0x8ffacc,0x8ffacd,0,0xc8d0,0xbad3, 0xbce1,0xeed8,0,0xeed9,0xcea4,0xbdc5,0xccee,0xcecc, /* '釀','釁',0,'釃','釄',0,'釆','采', '釈','釉',0,'釋','里','重','野','量', */
	/* 91d0 */ 0xeeda,0xb6e2,0,0,0,0,0xeedb,0xfcfc, 0xc5a3,0,0x8fface,0xeede,0xb3f8,0xbfcb,0,0xeedc, /* '釐','金',0,0,0,0,'釖','釗', '釘',0,'釚','釛','釜','針',0,'釟', */
	/* 91e0 */ 0,0xeedd,0,0xc4e0,0xfcfe,0xfda1,0xcbd5,0xb6fc, 0,0,0,0,0x8ffad1,0xfda2,0x8ffad2,0, /* 0,'釡',0,'釣','釤','釥','釦','釧', 0,0,0,0,'釬','釭','釮',0, */
	/* 91f0 */ 0,0xfda3,0,0,0,0xeee0,0xeee1,0, 0,0,0,0xfcfd,0xeedf,0,0,0xeee3, /* 0,'釱',0,0,0,'釵','釶',0, 0,0,0,'釻','釼',0,0,'釿', */
	/* 9200 */ 0,0x8ffad3,0,0,0,0,0,0xfda4, 0,0,0x8ffad4,0,0,0xc6df,0xb3c3,0, /* 0,'鈁',0,0,0,0,0,'鈇', 0,0,'鈊',0,0,'鈍','鈎',0, */
	/* 9210 */ 0xfda5,0xeee7,0,0,0xeee4,0xeee6,0x8ffad5,0x8ffad6, 0,0,0,0,0,0,0xeee2,0, /* '鈐','鈑',0,0,'鈔','鈕','鈖','鈗', 0,0,0,0,0,0,'鈞',0, */
	/* 9220 */ 0,0,0,0,0,0,0,0, 0,0xefcf,0,0,0xeee5,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'鈩',0,0,'鈬',0,0,0, */
	/* 9230 */ 0,0,0,0x8ffad8,0xceeb,0,0,0xb8da, 0xfda6,0xfda7,0xfda8,0,0xfda9,0,0,0xeeef, /* 0,0,0,'鈳','鈴',0,0,'鈷', '鈸','鈹','鈺',0,'鈼',0,0,'鈿', */
	/* 9240 */ 0xfdaa,0,0x8ffad9,0xfdab,0xc5b4,0xeeea,0,0x8ffada, 0xeeed,0xeeeb,0x8ffadb,0xeef0,0,0,0x8ffadc,0xfdac, /* '鉀',0,'鉂','鉃','鉄','鉅',0,'鉇', '鉈','鉉','鉊','鉋',0,0,'鉎','鉏', */
	/* 9250 */ 0xeef1,0x8ffadd,0,0,0,0,0x8ffade,0xeee9, 0,0x8ffadf,0xeef6,0xb1f4,0,0,0xeee8,0, /* '鉐','鉑',0,0,0,0,'鉖','鉗', 0,'鉙','鉚','鉛',0,0,'鉞',0, */
	/* 9260 */ 0x8ffae0,0x8ffae1,0xc8ad,0,0xeeec,0x8ffae2,0xbee0,0x8ffae3, 0x8ffae4,0,0,0,0,0,0,0, /* '鉠','鉡','鉢',0,'鉤','鉥','鉦','鉧', '鉨',0,0,0,0,0,0,0, */
	/* 9270 */ 0,0xb9db,0,0,0,0,0,0, 0xfdad,0,0,0,0x8ffae7,0x8ffae8,0xcbc8,0x8ffae9, /* 0,'鉱',0,0,0,0,0,0, '鉸',0,0,0,'鉼','鉽','鉾','鉿', */
	/* 9280 */ 0xb6e4,0,0,0xbdc6,0,0xc6bc,0,0, 0xfdae,0x8ffaea,0,0,0,0x8ffaeb,0,0, /* '銀',0,0,'銃',0,'銅',0,0, '銈','銉',0,0,0,'銍',0,0, */
	/* 9290 */ 0,0xc1ad,0,0xeef4,0,0xeeee,0xeef3,0x8ffaec, 0xccc3,0x8ffaed,0xc4b8,0xeef5,0xeef2,0,0,0x8ffaee, /* 0,'銑',0,'銓',0,'銕','銖','銗', '銘','銙','銚','銛','銜',0,0,'銟', */
	/* 92a0 */ 0,0,0,0,0,0,0,0x8ffaef, 0,0,0,0x8ffaf0,0,0xc1ac,0,0, /* 0,0,0,0,0,0,0,'銧', 0,0,0,'銫',0,'銭',0,0, */
	/* 92b0 */ 0,0,0x8ffaf3,0,0,0,0,0xeef9, 0,0xeef8,0,0,0,0,0,0x8ffaf4, /* 0,0,'銲',0,0,0,0,'銷', 0,'銹',0,0,0,0,0,'銿', */
	/* 92c0 */ 0x8ffaf5,0,0xfdaf,0,0,0,0x8ffaf6,0, 0,0,0,0xfdb0,0xfdb1,0,0x8ffaf7,0xeef7, /* '鋀',0,'鋂',0,0,0,'鋆',0, 0,0,0,'鋋','鋌',0,'鋎','鋏', */
	/* 92d0 */ 0x8ffaf8,0,0xcbaf,0xfdb2,0,0,0,0x8ffaf9, 0,0x8ffafa,0,0,0,0,0,0, /* '鋐',0,'鋒','鋓',0,0,0,'鋗', 0,'鋙',0,0,0,0,0,0, */
	/* 92e0 */ 0xfdb3,0,0,0,0xbdfb,0x8ffafb,0,0x8ffafc, 0,0xeefa,0xcadf,0,0,0xb1d4,0,0, /* '鋠',0,0,0,'鋤','鋥',0,'鋧', 0,'鋩','鋪',0,0,'鋭',0,0, */
	/* 92f0 */ 0,0,0xc9c6,0xc3f2,0,0,0,0x8ffba2, 0xb5f8,0x8ffba3,0xeefc,0x8ffba4,0xb9dd,0,0,0xfdb4, /* 0,0,'鋲','鋳',0,0,0,'鋷', '鋸','鋹','鋺','鋻','鋼',0,0,'鋿', */
	/* 9300 */ 0,0,0x8ffba5,0,0xfdb5,0,0xbbac,0, 0,0,0,0,0,0x8ffba6,0,0xeefb, /* 0,0,'錂',0,'錄',0,'錆',0, 0,0,0,0,0,'錍',0,'錏', */
	/* 9310 */ 0xbfed,0x8ffafd,0,0,0,0x8ffba7,0,0, 0xbfee,0xefa1,0xefa3,0,0,0x8ffba8,0x8ffba9,0xfdb6, /* '錐','錑',0,0,0,'錕',0,0, '錘','錙','錚',0,0,'錝','錞','錟', */
	/* 9320 */ 0xbefb,0xfdb7,0xefa2,0xefa4,0,0xfdb8,0xb6d3,0x8ffbaa, 0xc9c5,0x8ffbab,0,0xbce2,0xcfa3,0,0xeefe,0xbaf8, /* '錠','錡','錢','錣',0,'錥','錦','錧', '錨','錩',0,'錫','錬',0,'錮','錯', */
	/* 9330 */ 0,0,0xcfbf,0,0,0xefa6,0,0, 0,0,0xefa5,0xefa7,0,0,0,0, /* 0,0,'録',0,0,'錵',0,0, 0,0,'錺','錻',0,0,0,0, */
	/* 9340 */ 0,0,0,0,0xeefd,0,0,0x8ffbae, 0xfdb9,0xfdba,0xfdbb,0xc6e9,0,0xc5d5,0,0, /* 0,0,0,0,'鍄',0,0,'鍇', '鍈','鍉','鍊','鍋',0,'鍍',0,0, */
	/* 9350 */ 0,0x8ffbaf,0,0,0xc4d7,0,0xefac,0x8ffbb0, 0,0,0x8ffbb1,0xc3c3,0xefa8,0,0,0, /* 0,'鍑',0,0,'鍔',0,'鍖','鍗', 0,0,'鍚','鍛','鍜',0,0,0, */
	/* 9360 */ 0xefa9,0,0,0,0xfdbc,0xfdbd,0,0, 0,0,0xfdbe,0x8ffbb2,0xb7ad,0,0xefab,0, /* '鍠',0,0,0,'鍤','鍥',0,0, 0,0,'鍪','鍫','鍬',0,'鍮',0, */
	/* 9370 */ 0xfdbf,0x8ffbb3,0,0x8ffbb4,0,0xb8b0,0,0, 0,0,0,0,0xefaa,0,0xbee1,0, /* '鍰','鍱',0,'鍳',0,'鍵',0,0, 0,0,0,0,'鍼',0,'鍾',0, */
	/* 9380 */ 0,0,0,0,0,0,0,0, 0x8ffbb8,0,0,0x8ffbb9,0xb3f9,0,0,0x8ffbba, /* 0,0,0,0,0,0,0,0, '鎈',0,0,'鎋','鎌',0,0,'鎏', */
	/* 9390 */ 0,0,0,0,0xefb0,0,0xbabf,0xc1f9, 0,0,0xc4ca,0xfdc0,0,0,0x8ffbbb,0, /* 0,0,0,0,'鎔',0,'鎖','鎗', 0,0,'鎚','鎛',0,0,'鎞',0, */
	/* 93a0 */ 0,0x8ffbb5,0,0xfdc1,0,0,0,0xb3bb, 0,0,0,0,0xefae,0xefaf,0xc4c3,0, /* 0,'鎡',0,'鎣',0,0,0,'鎧', 0,0,0,0,'鎬','鎭','鎮',0, */
	/* 93b0 */ 0xefad,0,0,0,0,0,0,0, 0,0xefb1,0xfdc2,0,0,0,0,0, /* '鎰',0,0,0,0,0,0,0, 0,'鎹','鎺',0,0,0,0,0, */
	/* 93c0 */ 0,0x8ffbc0,0,0xefb7,0,0,0xfdc3,0x8ffbc1, 0xefba,0,0,0,0,0,0,0, /* 0,'鏁',0,'鏃',0,0,'鏆','鏇', '鏈',0,0,0,0,0,0,0, */
	/* 93d0 */ 0xefb9,0xc5ad,0,0,0,0,0xefb2,0xefb3, 0xefb6,0,0,0,0x8ffbc2,0xefb8,0xfdc4,0xfdc5, /* '鏐','鏑',0,0,0,0,'鏖','鏗', '鏘',0,0,0,'鏜','鏝','鏞','鏟', */
	/* 93e0 */ 0,0xb6c0,0x8ffbc3,0,0xefbb,0xefb5,0,0x8ffbc4, 0xefb4,0,0,0,0,0,0,0, /* 0,'鏡','鏢',0,'鏤','鏥',0,'鏧', '鏨',0,0,0,0,0,0,0, */
	/* 93f0 */ 0,0x8ffbbf,0,0,0,0x8ffbbc,0,0, 0,0,0,0x8ffbc9,0,0xfdc7,0,0, /* 0,'鏱',0,0,0,'鏵',0,0, 0,0,0,'鏻',0,'鏽',0,0, */
	/* 9400 */ 0,0,0,0xefbf,0xfdc6,0,0,0xefc0, 0,0x8ffbc5,0,0,0,0,0,0x8ffbc6, /* 0,0,0,'鐃','鐄',0,0,'鐇', 0,'鐉',0,0,0,0,0,'鐏', */
	/* 9410 */ 0xefc1,0,0,0xefbe,0xefbd,0,0x8ffbc7,0x8ffbc8, 0xbee2,0xc6aa,0xefbc,0,0,0,0,0, /* '鐐',0,0,'鐓','鐔',0,'鐖','鐗', '鐘','鐙','鐚',0,0,0,0,0, */
	/* 9420 */ 0,0xefc5,0,0,0,0,0,0, 0,0,0,0xefc3,0,0,0,0, /* 0,'鐡',0,0,0,0,0,0, 0,0,0,'鐫',0,0,0,0, */
	/* 9430 */ 0,0,0x8ffbca,0xfdc8,0x8ffbcb,0xefc4,0xefc2,0, 0xc2f8,0,0xefc6,0x8ffbcc,0,0,0,0, /* 0,0,'鐲','鐳','鐴','鐵','鐶',0, '鐸',0,'鐺','鐻',0,0,0,0, */
	/* 9440 */ 0,0xefc7,0,0,0xefc9,0x8ffbcd,0,0, 0,0,0xfdc9,0,0,0,0,0, /* 0,'鑁',0,0,'鑄','鑅',0,0, 0,0,'鑊',0,0,0,0,0, */
	/* 9450 */ 0,0xb4d5,0xefc8,0xccfa,0,0,0,0, 0,0,0xefd4,0xefca,0,0,0xefcd,0, /* 0,'鑑','鑒','鑓',0,0,0,0, 0,0,'鑚','鑛',0,0,'鑞',0, */
	/* 9460 */ 0xefcb,0,0xefcc,0xfdca,0,0,0,0, 0,0,0xefce,0xfdcb,0,0x8ffbd0,0,0x8ffbd1, /* '鑠',0,'鑢','鑣',0,0,0,0, 0,0,'鑪','鑫',0,'鑭',0,'鑯', */
	/* 9470 */ 0xefd0,0xfdcc,0xfdcd,0,0,0xefd1,0,0xefd2, 0,0,0,0,0xefd5,0xefd3,0xefd6,0xefd8, /* '鑰','鑱','鑲',0,0,'鑵',0,'鑷', 0,0,0,0,'鑼','鑽','鑾','鑿', */
	/* 9480 */ 0,0xefd7,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'钁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9570 */ 0,0,0,0,0,0,0,0xc4b9, 0x8ffbd2,0x8ffbd3,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'長', '镸','镹',0,0,0,0,0,0, */
	/* 9580 */ 0xcce7,0,0xefd9,0xc1ae,0,0,0x8ffbd4,0xefda, 0,0xcac4,0xefdb,0xb3ab,0x8ffbd5,0x8ffbd6,0xfdce,0xb1bc, /* '門',0,'閂','閃',0,0,'閆','閇', 0,'閉','閊','開','閌','閍','閎','閏', */
	/* 9590 */ 0,0xb4d7,0,0xb4d6,0xefdc,0,0xefdd,0, 0xefde,0xefdf,0,0,0,0,0,0xfdcf, /* 0,'閑',0,'間','閔',0,'閖',0, '閘','閙',0,0,0,0,0,'閟', */
	/* 95a0 */ 0xefe0,0,0xb4d8,0xb3d5,0xb9de,0xc8b6,0xfdd0,0xefe2, 0xefe1,0xfdd1,0,0x8ffbd8,0xfdd2,0xefe3,0,0, /* '閠',0,'関','閣','閤','閥','閦','閧', '閨','閩',0,'閫','閬','閭',0,0, */
	/* 95b0 */ 0,0,0xb1dc,0,0x8ffbd9,0,0xfdd3,0, 0,0xefe6,0,0xefe5,0xefe4,0xfdd4,0xefe7,0, /* 0,0,'閲',0,'閴',0,'閶',0, 0,'閹',0,'閻','閼','閽','閾',0, */
	/* 95c0 */ 0,0,0,0xefea,0,0,0,0xb0c7, 0x8ffbdb,0,0xefe8,0xfdd5,0xefec,0xefeb,0,0, /* 0,0,0,'闃',0,0,0,'闇', '闈',0,'闊','闋','闌','闍',0,0, */
	/* 95d0 */ 0xfdd6,0,0,0xfdd7,0xefee,0xefed,0xefef,0, 0xc6ae,0,0xfdd9,0,0xeff0,0,0xfdda,0, /* '闐',0,0,'闓','闔','闕','闖',0, '闘',0,'闚',0,'關',0,'闞',0, */
	/* 95e0 */ 0,0xeff1,0xeff3,0,0,0xeff2,0,0, 0,0,0,0,0,0,0,0, /* 0,'闡','闢',0,0,'闥',0,0, 0,0,0,0,0,0,0,0, */
	/* 95f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xc9ec,0x8ffaa5,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'阜','阝',0,0, */
	/* 9620 */ 0,0xeff4,0,0,0,0,0,0, 0xeff5,0,0xbae5,0,0x8ffbde,0,0xeff6,0xeff7, /* 0,'阡',0,0,0,0,0,0, '阨',0,'阪',0,'阬',0,'阮','阯', */
	/* 9630 */ 0,0,0xcbc9,0x8ffbdf,0x8ffbe0,0,0,0, 0,0,0,0xc1cb,0x8ffbe2,0,0,0xb0a4, /* 0,0,'防','阳','阴',0,0,0, 0,0,0,'阻','阼',0,0,'阿', */
	/* 9640 */ 0xc2cb,0x8ffbe3,0xeff8,0,0xc9ed,0,0,0, 0,0,0,0xeffb,0xeff9,0xb9df,0,0xeffa, /* '陀','陁','陂',0,'附',0,0,0, 0,0,0,'陋','陌','降',0,'陏', */
	/* 9650 */ 0xb8c2,0,0,0,0,0,0,0, 0xfddb,0,0,0xcac5,0xeffd,0xf0a1,0xeffe,0xf0a2, /* '限',0,0,0,0,0,0,0, '陘',0,0,'陛','陜','陝','陞','陟', */
	/* 9660 */ 0,0x8ffbe4,0xb1a1,0xbfd8,0xbdfc,0xb4d9,0xf0a3,0, 0,0,0xc7e6,0,0xf0a5,0,0,0, /* 0,'陡','院','陣','除','陥','陦',0, 0,0,'陪',0,'陬',0,0,0, */
	/* 9670 */ 0xb1a2,0,0xf0a4,0xc4c4,0,0xcecd,0xc6ab,0xeffc, 0xcea6,0,0xb8b1,0,0,0xcddb,0,0, /* '陰',0,'陲','陳',0,'陵','陶','陷', '陸',0,'険',0,0,'陽',0,0, */
	/* 9680 */ 0,0,0x8ffbe6,0,0xfddc,0xb6f9,0xceb4,0, 0xb7a8,0,0xc2e2,0xe7a1,0,0xf0a6,0xb3ac,0xbfef, /* 0,0,'隂',0,'隄','隅','隆',0, '隈',0,'隊','隋',0,'隍','階','随', */
	/* 9690 */ 0,0,0,0,0xb3d6,0xf0a8,0,0xf0a9, 0xf0a7,0xb7e4,0x8ffbe8,0xbadd,0xbee3,0xfdde,0,0, /* 0,0,0,0,'隔','隕',0,'隗', '隘','隙','隚','際','障','隝',0,0, */
	/* 96a0 */ 0xb1a3,0,0,0xced9,0xfddf,0xfde0,0,0xf0ab, 0xeeae,0x8ffbeb,0xf0aa,0,0,0,0,0x8ffbec, /* '隠',0,0,'隣','隤','隥',0,'隧', '隨','隩','險',0,0,0,0,'隯', */
	/* 96b0 */ 0xf0ae,0xf0ac,0xf0ad,0x8ffbed,0xf0af,0,0xf0b0,0xceec, 0xf0b1,0xf0b2,0x8ffbee,0xc0c9,0xc8bb,0x8ffbef,0,0, /* '隰','隱','隲','隳','隴',0,'隶','隷', '隸','隹','隺','隻','隼','隽',0,0, */
	/* 96c0 */ 0xbffd,0xb4e7,0,0,0xcdba,0xb2ed,0xbdb8,0xb8db, 0,0xf0b5,0,0xf0b4,0xbbf3,0xf0b6,0xf0b3,0, /* '雀','雁',0,0,'雄','雅','集','雇', 0,'雉',0,'雋','雌','雍','雎',0, */
	/* 96d0 */ 0,0xbba8,0xfde1,0,0,0xf0ba,0xeaad,0, 0x8ffbf2,0xd2d6,0x8ffbf3,0xbff7,0xf0b8,0x8ffbf4,0xfde2,0, /* 0,'雑','雒',0,0,'雕','雖',0, '雘','雙','雚','雛','雜','雝','雞',0, */
	/* 96e0 */ 0,0,0xcea5,0xc6f1,0,0,0,0, 0xb1ab,0xfde4,0xc0e3,0xbcb6,0,0,0,0xfde5, /* 0,0,'離','難',0,0,0,0, '雨','雩','雪','雫',0,0,0,'雯', */
	/* 96f0 */ 0xcab7,0,0xb1c0,0,0,0,0xceed,0xcdeb, 0,0xf0bb,0,0xc5c5,0,0,0,0, /* '雰',0,'雲',0,0,0,'零','雷', 0,'雹',0,'電',0,0,0,0, */
	/* 9700 */ 0xbcfb,0,0,0,0xf0bc,0,0xf0bd,0xbfcc, 0xf0be,0,0xceee,0,0,0xf0b9,0xf0c0,0xf0c2, /* '需',0,0,0,'霄',0,'霆','震', '霈',0,'霊',0,0,'霍','霎','霏', */
	/* 9710 */ 0,0xf0c1,0,0xf0bf,0x8ffbf6,0,0xf0c3,0, 0,0xf0c4,0,0,0xc1fa,0,0xb2e2,0, /* 0,'霑',0,'霓','霔',0,'霖',0, 0,'霙',0,0,'霜',0,'霞',0, */
	/* 9720 */ 0,0,0,0x8ffbf7,0xf0c5,0,0,0xccb8, 0,0,0xf0c6,0,0,0,0,0, /* 0,0,0,'霣','霤',0,0,'霧', 0,0,'霪',0,0,0,0,0, */
	/* 9730 */ 0xf0c7,0,0xcfaa,0xfde6,0,0,0x8ffbf9,0, 0xdbb1,0xf0c8,0,0xfde7,0,0xf0c9,0xf0ca,0, /* '霰',0,'露','霳',0,0,'霶',0, '霸','霹',0,'霻',0,'霽','霾',0, */
	/* 9740 */ 0,0x8ffbfa,0xf0ce,0,0xf0cb,0,0xf0cc,0x8ffbfb, 0xf0cd,0xf0cf,0,0,0,0xfde8,0xfde9,0xfdea, /* 0,'靁','靂',0,'靄',0,'靆','靇', '靈','靉',0,0,0,'靍','靎','靏', */
	/* 9750 */ 0,0,0xc0c4,0,0,0x8ffbfc,0xccf7,0x8ffbfd, 0,0xc0c5,0xfdeb,0x8ffbfe,0xf0d0,0,0xc8f3,0, /* 0,0,'青',0,0,'靕','靖','靗', 0,'静','靚','靛','靜',0,'非',0, */
	/* 9760 */ 0xf0d1,0xf3d3,0xcccc,0,0xf0d2,0,0xf0d3,0, 0xf0d4,0xb3d7,0x8ffca1,0xf0d6,0,0xbfd9,0xfdec,0, /* '靠','靡','面',0,'靤',0,'靦',0, '靨','革','靪','靫',0,'靭','靮',0, */
	/* 9770 */ 0,0xf0d7,0,0xfded,0xb7a4,0,0,0, 0,0xf0d8,0xf0dc,0,0xf0da,0,0,0, /* 0,'靱',0,'靳','靴',0,0,0, 0,'靹','靺',0,'靼',0,0,0, */
	/* 9780 */ 0,0xf0db,0,0,0xb3f3,0xf0d9,0xf0dd,0, 0,0,0,0xf0de,0,0xb0c8,0,0xf0df, /* 0,'鞁',0,0,'鞄','鞅','鞆',0, 0,0,0,'鞋',0,'鞍',0,'鞏', */
	/* 9790 */ 0xf0e0,0,0,0,0,0xfdee,0x8ffca4,0, 0xbee4,0,0x8ffca5,0,0xf0e1,0,0x8ffca6,0, /* '鞐',0,0,0,0,'鞕','鞖',0, '鞘',0,'鞚',0,'鞜',0,'鞞',0, */
	/* 97a0 */ 0xb5c7,0,0x8ffca7,0xf0e4,0,0,0xf0e3,0, 0xf0e2,0,0,0xebf1,0,0xcadc,0xfdef,0, /* '鞠',0,'鞢','鞣',0,0,'鞦',0, '鞨',0,0,'鞫',0,'鞭','鞮',0, */
	/* 97b0 */ 0,0x8ffca8,0x8ffca9,0xf0e5,0xf0e6,0,0,0, 0,0,0xfdf0,0,0,0,0x8ffcaa,0, /* 0,'鞱','鞲','鞳','鞴',0,0,0, 0,0,'鞺',0,0,0,'鞾',0, */
	/* 97c0 */ 0,0xfdf1,0,0xf0e7,0,0,0xf0e8,0, 0xf0e9,0xfdf2,0,0xf0ea,0x8ffcab,0,0,0, /* 0,'韁',0,'韃',0,0,'韆',0, '韈','韉',0,'韋','韌',0,0,0, */
	/* 97d0 */ 0,0x8ffcac,0,0xb4da,0x8ffcad,0,0,0, 0x8ffcae,0x8ffcaf,0,0xfdf4,0xf0eb,0,0xfdf3,0, /* 0,'韑',0,'韓','韔',0,0,0, '韘','韙',0,'韛','韜',0,'韞',0, */
	/* 97e0 */ 0,0x8ffcb0,0,0,0,0,0,0, 0,0,0,0,0,0xf0ec,0xc7a3,0, /* 0,'韡',0,0,0,0,0,0, 0,0,0,0,0,'韭','韮',0, */
	/* 97f0 */ 0,0x8ffcb1,0xf0ee,0xb2bb,0xfdf5,0xf0f1,0xf0f0,0, 0,0,0,0xb1a4,0,0,0,0xb6c1, /* 0,'韱','韲','音','韴','韵','韶',0, 0,0,0,'韻',0,0,0,'響', */
	/* 9800 */ 0,0xcac7,0xc4ba,0xbaa2,0x8ffcb2,0xb9e0,0xbde7,0, 0xbfdc,0,0xfdf7,0,0xf0f3,0x8ffcb3,0x8ffcb4,0xf0f2, /* 0,'頁','頂','頃','頄','項','順',0, '須',0,'頊',0,'頌','頍','頎','頏', */
	/* 9810 */ 0xcdc2,0xb4e8,0xc8d2,0xc6dc,0x8ffcb5,0,0x8ffcb6,0xbffc, 0xcece,0,0xb7db,0,0,0,0xfdf8,0, /* '預','頑','頒','頓','頔',0,'頖','頗', '領',0,'頚',0,0,0,'頞',0, */
	/* 9820 */ 0,0xf0f6,0,0x8ffcb9,0xf0f5,0x8ffcbc,0,0, 0,0,0,0xfdf9,0xcbcb,0xc6ac,0,0, /* 0,'頡',0,'頣','頤','頥',0,0, 0,0,0,'頫','頬','頭',0,0, */
	/* 9830 */ 0xfdfa,0,0x8ffcba,0x8ffcbb,0xb1d0,0,0,0xf0f7, 0xf0f4,0,0,0xc9d1,0xcdea,0xf0f8,0,0, /* '頰',0,'頲','頳','頴',0,0,'頷', '頸',0,0,'頻','頼','頽',0,0, */
	/* 9840 */ 0,0,0,0,0,0,0xf0f9,0x8ffcbd, 0,0,0,0xf0fb,0xc2ea,0xb3db,0xb3dc,0xf0fa, /* 0,0,0,0,0,0,'顆','顇', 0,0,0,'顋','題','額','顎','顏', */
	/* 9850 */ 0,0,0xfdfc,0xfdfd,0xb4e9,0xb8b2,0xfdfe,0xfea1, 0xb4ea,0xfea2,0xfea3,0xc5bf,0,0,0xcee0,0, /* 0,0,'顒','顓','顔','顕','顖','顗', '願','顙','顚','顛',0,0,'類',0, */
	/* 9860 */ 0,0,0,0,0,0xfea5,0x8ffcbe,0xb8dc, 0,0,0,0xf0fc,0xfea6,0,0,0xf0fd, /* 0,0,0,0,0,'顥','顦','顧', 0,0,0,'顫','顬',0,0,'顯', */
	/* 9870 */ 0xf0fe,0xf1a1,0,0xf1a3,0xf1a2,0,0,0, 0,0,0,0,0,0,0,0, /* '顰','顱',0,'顳','顴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 98a0 */ 0,0,0,0,0,0,0,0, 0xc9f7,0,0xf1a4,0x8ffcbf,0,0x8ffcc0,0,0xf1a5, /* 0,0,0,0,0,0,0,0, '風',0,'颪','颫',0,'颭',0,'颯', */
	/* 98b0 */ 0x8ffcc1,0xf1a6,0,0,0,0,0xf1a7,0x8ffcc3, 0x8ffcc4,0,0xfea7,0x8ffcc5,0x8ffcc6,0,0,0x8ffcc7, /* '颰','颱',0,0,0,0,'颶','颷', '颸',0,'颺','颻','颼',0,0,'颿', */
	/* 98c0 */ 0,0,0x8ffcc8,0xf1a9,0xf1a8,0,0xf1aa,0x8ffcc9, 0xfea8,0,0,0x8ffcca,0,0,0,0, /* 0,0,'飂','飃','飄',0,'飆','飇', '飈',0,0,'飋',0,0,0,0, */
	/* 98d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0xc8f4,0xe6cc,0,0,0xbfa9, /* 0,0,0,0,0,0,0,0, 0,0,0,'飛','飜',0,0,'食', */
	/* 98e0 */ 0x8ffccb,0x8ffccd,0xb5b2,0x8ffcce,0,0x8ffccf,0,0xfea9, 0,0xf1ab,0x8ffcd0,0xf1ac,0,0xd2ac,0xddbb,0xc8d3, /* '飠','飡','飢','飣',0,'飥',0,'飧', 0,'飩','飪','飫',0,'飭','飮','飯', */
	/* 98f0 */ 0x8ffcd1,0x8ffcd2,0xb0fb,0x8ffcd3,0xb0bb,0,0,0, 0,0,0,0,0xbbf4,0xcbb0,0xbefe,0, /* '飰','飱','飲','飳','飴',0,0,0, 0,0,0,0,'飼','飽','飾',0, */
	/* 9900 */ 0,0,0,0xf1ad,0,0xccdf,0,0, 0x8ffcd4,0xf1ae,0xcddc,0,0xb1c2,0,0,0, /* 0,0,0,'餃',0,'餅',0,0, '餈','餉','養',0,'餌',0,0,0, */
	/* 9910 */ 0xbbc1,0,0xf1af,0xb2ee,0xf1b0,0,0x8ffcd7,0x8ffcd8, 0xf1b1,0,0x8ffcda,0x8ffcdb,0x8ffcdc,0xf1b3,0xf1b4,0, /* '餐',0,'餒','餓','餔',0,'餖','餗', '餘',0,'餚','餛','餜','餝','餞',0, */
	/* 9920 */ 0xf1b6,0xf1b2,0,0,0xf1b5,0,0,0, 0xb4db,0,0,0,0xf1b7,0,0xf1b8,0, /* '餠','餡',0,0,'餤',0,0,0, '館',0,0,0,'餬',0,'餮',0, */
	/* 9930 */ 0,0x8ffcde,0x8ffcdf,0x8ffce0,0,0,0,0, 0,0,0x8ffce1,0x8ffce2,0x8ffce3,0xf1b9,0xf1ba,0, /* 0,'餱','餲','餳',0,0,0,0, 0,0,'餺','餻','餼','餽','餾',0, */
	/* 9940 */ 0x8ffce4,0x8ffce5,0xf1bb,0,0,0xf1bd,0x8ffce6,0, 0,0xf1bc,0,0xf1bf,0xf1c2,0x8ffce7,0x8ffce8,0, /* '饀','饁','饂',0,0,'饅','饆',0, 0,'饉',0,'饋','饌','饍','饎',0, */
	/* 9950 */ 0xf1be,0xf1c0,0xf1c1,0,0,0xf1c3,0,0xb6c2, 0xfeaa,0,0,0,0x8ffce9,0,0,0x8ffcea, /* '饐','饑','饒',0,0,'饕',0,'饗', '饘',0,0,0,'饜',0,0,'饟', */
	/* 9960 */ 0x8ffceb,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '饠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9990 */ 0,0,0,0,0,0,0xbcf3,0xf1c4, 0xf1c5,0xb9e1,0,0,0,0,0xfeab,0, /* 0,0,0,0,0,0,'首','馗', '馘','香',0,0,0,0,'馞',0, */
	/* 99a0 */ 0,0,0,0x8ffcec,0,0xf1c6,0x8ffced,0, 0xb3be,0,0,0,0xc7cf,0xf1c7,0xf1c8,0, /* 0,0,0,'馣',0,'馥','馦',0, '馨',0,0,0,'馬','馭','馮',0, */
	/* 99b0 */ 0,0,0,0xc3da,0xc6eb,0,0,0, 0,0x8ffcee,0,0,0xf1c9,0x8ffcef,0,0x8ffcf0, /* 0,0,0,'馳','馴',0,0,0, 0,'馹',0,0,'馼','馽',0,'馿', */
	/* 99c0 */ 0,0xc7fd,0,0x8ffcf1,0xc2cc,0xb1d8,0xb6ee,0, 0xb6ef,0x8ffcf2,0,0,0,0,0,0, /* 0,'駁',0,'駃','駄','駅','駆',0, '駈','駉',0,0,0,0,0,0, */
	/* 99d0 */ 0xc3f3,0xf1ce,0xb6f0,0,0x8ffcf3,0xb2ef,0,0, 0xf1cd,0x8ffcf4,0,0xf1cb,0,0xf1cc,0x8ffcf5,0xf1ca, /* '駐','駑','駒',0,'駔','駕',0,0, '駘','駙',0,'駛',0,'駝','駞','駟', */
	/* 99e0 */ 0,0,0xf1d8,0,0,0,0,0, 0,0,0,0,0,0xf1cf,0xf1d0,0, /* 0,0,'駢',0,0,0,0,0, 0,0,0,0,0,'駭','駮',0, */
	/* 99f0 */ 0x8ffcf7,0xf1d1,0xf1d2,0,0,0,0,0, 0xf1d4,0x8ffcf8,0,0xf1d3,0x8ffcf9,0,0,0xbdd9, /* '駰','駱','駲',0,0,0,0,0, '駸','駹',0,'駻','駼',0,0,'駿', */
	/* 9a00 */ 0,0xf1d5,0xfeac,0xfead,0,0xf1d7,0,0, 0,0,0x8ffcfa,0,0,0,0xb5b3,0xf1d6, /* 0,'騁','騂','騃',0,'騅',0,0, 0,0,'騊',0,0,0,'騎','騏', */
	/* 9a10 */ 0,0x8ffcfb,0xc1fb,0xb8b3,0,0,0x8ffcfc,0, 0,0xf1d9,0x8ffcfd,0,0,0,0,0, /* 0,'騑','騒','験',0,0,'騖',0, 0,'騙','騚',0,0,0,0,0, */
	/* 9a20 */ 0x8ffcfe,0,0,0,0xfeae,0,0,0, 0xc2cd,0,0,0xf1da,0,0xfeaf,0xfeb0,0, /* '騠',0,0,0,'騤',0,0,0, '騨',0,0,'騫',0,'騭','騮',0, */
	/* 9a30 */ 0xc6ad,0x8ffda1,0,0,0,0,0x8ffda2,0xf1db, 0xfeb1,0,0,0,0,0,0xf1e0,0, /* '騰','騱',0,0,0,0,'騶','騷', '騸',0,0,0,0,0,'騾',0, */
	/* 9a40 */ 0xf1de,0,0xf1dd,0xf1df,0x8ffda3,0xf1dc,0,0, 0,0,0xfeb2,0,0x8ffda4,0xf1e2,0xfeb3,0, /* '驀',0,'驂','驃','驄','驅',0,0, 0,0,'驊',0,'驌','驍','驎',0, */
	/* 9a50 */ 0,0,0xfeb4,0,0,0xf1e1,0,0xf1e4, 0x8ffda5,0,0xb6c3,0xf1e3,0,0,0,0xf1e5, /* 0,0,'驒',0,0,'驕',0,'驗', '驘',0,'驚','驛',0,0,0,'驟', */
	/* 9a60 */ 0,0,0xf1e6,0,0xf1e8,0xf1e7,0,0, 0,0xf1e9,0xf1eb,0xf1ea,0,0,0,0, /* 0,0,'驢',0,'驤','驥',0,0, 0,'驩','驪','驫',0,0,0,0, */
	/* 9a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9aa0 */ 0,0,0,0,0,0,0,0, 0xb9fc,0,0,0,0,0xf1ec,0,0x8ffda7, /* 0,0,0,0,0,0,0,0, '骨',0,0,0,0,'骭',0,'骯', */
	/* 9ab0 */ 0xf1ed,0,0,0,0,0,0xfeb5,0x8ffda9, 0xb3bc,0x8ffdab,0,0,0xf1ee,0,0,0, /* '骰',0,0,0,0,0,'骶','骷', '骸','骹',0,0,'骼',0,0,0, */
	/* 9ac0 */ 0xf1ef,0xfeb6,0,0xfeb7,0xbff1,0,0x8ffdad,0, 0,0,0,0,0,0,0xfeb8,0xf1f0, /* '髀','髁',0,'髃','髄',0,'髆',0, 0,0,0,0,0,0,'髎','髏', */
	/* 9ad0 */ 0x8ffdae,0xf1f1,0x8ffdaf,0xf1f2,0xf1f3,0x8ffdb0,0xfeb9,0, 0xb9e2,0,0,0,0x8ffdb2,0,0xf1f4,0xf1f5, /* '髐','髑','髒','髓','體','髕','髖',0, '高',0,0,0,'髜',0,'髞','髟', */
	/* 9ae0 */ 0x8ffdb3,0,0xf1f6,0xf1f7,0,0x8ffdb4,0xf1f8,0, 0,0x8ffdb5,0xc8b1,0xf1fa,0,0xc9a6,0xf1fb,0xf1f9, /* '髠',0,'髢','髣',0,'髥','髦',0, 0,'髩','髪','髫',0,'髭','髮','髯', */
	/* 9af0 */ 0,0xf1fd,0,0,0xf1fc,0,0,0xf1fe, 0,0xfeba,0,0xf2a1,0,0,0,0, /* 0,'髱',0,0,'髴',0,0,'髷', 0,'髹',0,'髻',0,0,0,0, */
	/* 9b00 */ 0,0,0xfebb,0x8ffdb6,0,0,0xf2a2,0, 0xfebc,0,0,0,0x8ffdb7,0,0,0, /* 0,0,'鬂','鬃',0,0,'鬆',0, '鬈',0,0,0,'鬌',0,0,0, */
	/* 9b10 */ 0x8ffdb8,0,0x8ffdb9,0,0,0,0x8ffdba,0, 0xf2a3,0,0xf2a4,0,0x8ffdbb,0,0,0xf2a5, /* '鬐',0,'鬒',0,0,0,'鬖',0, '鬘',0,'鬚',0,'鬜',0,0,'鬟', */
	/* 9b20 */ 0xfebd,0,0xf2a6,0xf2a7,0,0xf2a8,0,0xf2a9, 0xf2aa,0xf2ab,0xf2ac,0x8ffdbc,0,0xfebf,0xf2ad,0xf2ae, /* '鬠',0,'鬢','鬣',0,'鬥',0,'鬧', '鬨','鬩','鬪','鬫',0,'鬭','鬮','鬯', */
	/* 9b30 */ 0,0xddb5,0xf2af,0x8ffdbd,0,0,0,0, 0,0,0,0xe4f8,0xb5b4,0x8ffdbe,0,0, /* 0,'鬱','鬲','鬳',0,0,0,0, 0,0,0,'鬻','鬼','鬽',0,0, */
	/* 9b40 */ 0,0xb3a1,0xbab2,0xf2b1,0xf2b0,0xcca5,0,0, 0,0,0,0x8ffdc0,0,0xf2b3,0xf2b4,0xf2b2, /* 0,'魁','魂','魃','魄','魅',0,0, 0,0,0,'魋',0,'魍','魎','魏', */
	/* 9b50 */ 0,0xf2b5,0,0,0xcbe2,0,0,0, 0xf2b6,0,0xb5fb,0,0,0,0xfec0,0, /* 0,'魑',0,0,'魔',0,0,0, '魘',0,'魚',0,0,0,'魞',0, */
	/* 9b60 */ 0,0,0,0x8ffdc1,0,0x8ffdc2,0xfec2,0, 0,0,0,0x8ffdc3,0x8ffdc4,0,0,0xcfa5, /* 0,0,0,'魣',0,'魥','魦',0, 0,0,0,'魫','魬',0,0,'魯', */
	/* 9b70 */ 0,0,0xfec3,0x8ffdc5,0xf2b7,0xfec4,0x8ffdc6,0x8ffdc7, 0,0xfec1,0,0,0,0,0,0, /* 0,0,'魲','魳','魴','魵','魶','魷', 0,'魹',0,0,0,0,0,0, */
	/* 9b80 */ 0,0,0,0xf2b9,0xfec5,0,0,0, 0,0,0xfec6,0,0,0,0xb0be,0xfec7, /* 0,0,0,'鮃','鮄',0,0,0, 0,0,'鮊',0,0,0,'鮎','鮏', */
	/* 9b90 */ 0,0xf2ba,0xcaab,0xf2b8,0,0,0xf2bb,0xf2bc, 0,0,0,0,0,0,0xfec8,0xf2bd, /* 0,'鮑','鮒','鮓',0,0,'鮖','鮗', 0,0,0,0,0,0,'鮞','鮟', */
	/* 9ba0 */ 0xf2be,0,0,0,0,0,0x8ffdc8,0xfec9, 0xf2bf,0,0xcbee,0xbbad,0x8ffdc9,0xbafa,0xc1af,0, /* '鮠',0,0,0,0,0,'鮦','鮧', '鮨',0,'鮪','鮫','鮬','鮭','鮮',0, */
	/* 9bb0 */ 0,0x8ffdca,0x8ffdcd,0,0xf2c0,0,0,0, 0x8ffdce,0xf2c3,0,0,0,0,0x8ffdcf,0, /* 0,'鮱','鮲',0,'鮴',0,0,0, '鮸','鮹',0,0,0,0,'鮾',0, */
	/* 9bc0 */ 0xf2c1,0xfeca,0,0,0,0,0xf2c4,0x8ffdd0, 0,0xb8f1,0xf2c2,0,0,0,0xfecb,0xf2c5, /* '鯀','鯁',0,0,0,0,'鯆','鯇', 0,'鯉','鯊',0,0,0,'鯎','鯏', */
	/* 9bd0 */ 0,0xf2c6,0xf2c7,0,0xf2cb,0,0xbbaa,0, 0x8ffdd2,0,0,0xc2e4,0,0x8ffdd3,0,0, /* 0,'鯑','鯒',0,'鯔',0,'鯖',0, '鯘',0,0,'鯛',0,'鯝',0,0, */
	/* 9be0 */ 0,0xf2cc,0xf2c9,0xf2c8,0xf2ca,0xfecc,0,0x8ffdd4, 0xb7df,0,0x8ffdd5,0x8ffdd6,0,0,0x8ffdd8,0x8ffdd7, /* 0,'鯡','鯢','鯣','鯤','鯥',0,'鯧', '鯨',0,'鯪','鯫',0,0,'鯮','鯯', */
	/* 9bf0 */ 0xf2d0,0xf2cf,0xf2ce,0x8ffdd1,0,0xb0b3,0,0x8ffddc, 0xfecd,0,0x8ffdda,0,0,0xfece,0,0, /* '鯰','鯱','鯲','鯳',0,'鯵',0,'鯷', '鯸',0,'鯺',0,0,'鯽',0,0, */
	/* 9c00 */ 0xfecf,0,0,0,0xf2da,0,0xf2d6,0, 0xf2d7,0xf2d3,0xf2d9,0,0xf2d5,0xb3e2,0,0, /* '鰀',0,0,0,'鰄',0,'鰆',0, '鰈','鰉','鰊',0,'鰌','鰍',0,0, */
	/* 9c10 */ 0xcfcc,0,0xf2d8,0xf2d4,0xf2d2,0xf2d1,0x8ffdde,0, 0x8ffddf,0x8ffde0,0x8ffde1,0xf2dc,0,0x8ffde2,0,0, /* '鰐',0,'鰒','鰓','鰔','鰕','鰖',0, '鰘','鰙','鰚','鰛',0,'鰝',0,0, */
	/* 9c20 */ 0,0xf2df,0x8ffde3,0xfed0,0xf2de,0xf2dd,0,0x8ffde4, 0,0x8ffde5,0x8ffde6,0,0,0xc9c9,0xf2db,0xb0f3, /* 0,'鰡','鰢','鰣','鰤','鰥',0,'鰧', 0,'鰩','鰪',0,0,'鰭','鰮','鰯', */
	/* 9c30 */ 0xf2e0,0x8ffde8,0xf2e2,0,0,0,0x8ffde9,0x8ffdea, 0,0xb3ef,0xf2cd,0xb1b7,0,0,0xf2e4,0, /* '鰰','鰱','鰲',0,0,0,'鰶','鰷', 0,'鰹','鰺','鰻',0,0,'鰾',0, */
	/* 9c40 */ 0,0xfed1,0,0,0,0x8ffdeb,0xf2e3,0xf2e1, 0xc3ad,0x8ffdee,0x8ffdef,0,0,0,0,0xfed2, /* 0,'鱁',0,0,0,'鱅','鱆','鱇', '鱈','鱉','鱊',0,0,0,0,'鱏', */
	/* 9c50 */ 0xfed3,0,0xcbf0,0xfed4,0x8ffdf1,0,0,0xceda, 0x8ffdf2,0,0xf2e5,0x8ffdf3,0x8ffdec,0x8ffdf4,0,0x8ffdf5, /* '鱐',0,'鱒','鱓','鱔',0,0,'鱗', '鱘',0,'鱚','鱛','鱜','鱝',0,'鱟', */
	/* 9c60 */ 0xf2e6,0,0,0xfed5,0,0xfed6,0,0xf2e7, 0,0x8ffdf6,0x8ffdf7,0x8ffdf8,0,0x8ffdf9,0x8ffdfa,0, /* '鱠',0,0,'鱣',0,'鱥',0,'鱧', 0,'鱩','鱪','鱫',0,'鱭','鱮',0, */
	/* 9c70 */ 0x8ffdfb,0,0x8ffdfc,0,0,0x8ffdfd,0xf2e8,0xfed7, 0xf2e9,0,0x8ffdfe,0,0,0,0,0, /* '鱰',0,'鱲',0,0,'鱵','鱶','鱷', '鱸',0,'鱺',0,0,0,0,0, */
	/* 9c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ce0 */ 0,0,0,0,0,0xc4bb,0x8ffea1,0xf2ea, 0,0xc8b7,0,0xf2ef,0xf2eb,0,0,0, /* 0,0,0,0,0,'鳥','鳦','鳧', 0,'鳩',0,'鳫','鳬',0,0,0, */
	/* 9cf0 */ 0xf2ec,0,0x8ffea2,0xcbb1,0xccc4,0,0xc6d0,0, 0,0,0,0,0,0,0,0, /* '鳰',0,'鳲','鳳','鳴',0,'鳶',0, 0,0,0,0,0,0,0,0, */
	/* 9d00 */ 0,0,0x8ffea4,0xf2f0,0,0,0xf2f1,0xc6be, 0xf2ee,0xf2ed,0,0x8ffea3,0,0,0xb2aa,0, /* 0,0,'鴂','鴃',0,0,'鴆','鴇', '鴈','鴉',0,'鴋',0,0,'鴎',0, */
	/* 9d10 */ 0,0x8ffea6,0xf2f9,0,0,0xf2f8,0,0x8ffea7, 0x8ffea8,0,0,0xb1f5,0,0xfed8,0xfed9,0xf2f6, /* 0,'鴑','鴒',0,0,'鴕',0,'鴗', '鴘',0,0,'鴛',0,'鴝','鴞','鴟', */
	/* 9d20 */ 0,0,0,0xf2f5,0,0,0xf2f3,0, 0xb3fb,0,0xf2f2,0xbcb2,0xb2a9,0,0,0, /* 0,0,0,'鴣',0,0,'鴦',0, '鴨',0,'鴪','鴫','鴬',0,0,0, */
	/* 9d30 */ 0,0,0x8ffeac,0,0,0,0,0, 0,0,0,0xb9e3,0,0,0xf2fc,0xf2fb, /* 0,0,'鴲',0,0,0,0,0, 0,0,0,'鴻',0,0,'鴾','鴿', */
	/* 9d40 */ 0,0xf2fa,0x8ffeae,0xfeda,0xf2f7,0,0xf2fd,0xfedb, 0xf2fe,0,0x8ffeaf,0,0,0,0,0, /* 0,'鵁','鵂','鵃','鵄',0,'鵆','鵇', '鵈',0,'鵊',0,0,0,0,0, */
	/* 9d50 */ 0xf3a5,0xf3a4,0xfedc,0,0,0,0,0, 0,0xf3a6,0,0,0xb1ad,0xf3a1,0xf3a2,0x8ffeb0, /* '鵐','鵑','鵒',0,0,0,0,0, 0,'鵙',0,0,'鵜','鵝','鵞','鵟', */
	/* 9d60 */ 0xb9f4,0xccb9,0x8ffeb1,0xfedd,0xf3a3,0,0,0, 0,0x8ffeb3,0,0x8ffeb4,0xcbb2,0,0,0xf3ab, /* '鵠','鵡','鵢','鵣','鵤',0,0,0, 0,'鵩',0,'鵫','鵬',0,0,'鵯', */
	/* 9d70 */ 0xfede,0,0xf3a7,0x8ffeb6,0,0,0x8ffeb7,0x8ffeb8, 0,0,0xf3ac,0,0xfedf,0,0x8ffeb9,0, /* '鵰',0,'鵲','鵳',0,0,'鵶','鵷', 0,0,'鵺',0,'鵼',0,'鵾',0, */
	/* 9d80 */ 0,0,0,0,0x8ffeba,0,0,0xf3a9, 0,0xf3a8,0xfee0,0,0,0x8ffebb,0,0xb7dc, /* 0,0,0,0,'鶄',0,0,'鶇', 0,'鶉','鶊',0,0,'鶍',0,'鶏', */
	/* 9d90 */ 0,0,0,0,0,0,0xfee1,0, 0,0x8ffebc,0xf3ad,0,0,0,0,0, /* 0,0,0,0,0,0,'鶖',0, 0,'鶙','鶚',0,0,0,0,0, */
	/* 9da0 */ 0,0x8ffebd,0,0,0xf3ae,0,0,0, 0,0xf3af,0,0xf3aa,0xfee3,0,0,0xf2f4, /* 0,'鶡',0,0,'鶤',0,0,0, 0,'鶩',0,'鶫','鶬',0,0,'鶯', */
	/* 9db0 */ 0,0,0xf3b0,0,0xc4e1,0x8ffebf,0,0, 0xf3b4,0x8ffec0,0xf3b5,0xf3b3,0xfee4,0x8ffec1,0,0x8ffebe, /* 0,0,'鶲',0,'鶴','鶵',0,0, '鶸','鶹','鶺','鶻','鶼','鶽',0,'鶿', */
	/* 9dc0 */ 0xfee2,0xf3b2,0xf3b8,0x8ffec2,0xf3b1,0,0xf3b6,0x8ffec3, 0,0x8ffec4,0,0,0,0,0,0xf3b7, /* '鷀','鷁','鷂','鷃','鷄',0,'鷆','鷇', 0,'鷉',0,0,0,0,0,'鷏', */
	/* 9dd0 */ 0,0,0,0xf3ba,0,0,0x8ffec5,0xfee5, 0,0xf3b9,0x8ffec6,0,0,0,0,0x8ffec7, /* 0,0,0,'鷓',0,0,'鷖','鷗', 0,'鷙','鷚',0,0,0,0,'鷟', */
	/* 9de0 */ 0x8ffec8,0,0,0x8ffec9,0,0,0xf3bc,0xfee7, 0,0,0,0,0,0xf3bd,0,0xf3be, /* '鷠',0,0,'鷣',0,0,'鷦','鷧', 0,0,0,0,0,'鷭',0,'鷯', */
	/* 9df0 */ 0,0,0xcfc9,0,0x8ffeca,0,0,0, 0xf3bb,0xc2eb,0xbaed,0,0,0xf3bf,0,0, /* 0,0,'鷲',0,'鷴',0,0,0, '鷸','鷹','鷺',0,0,'鷽',0,0, */
	/* 9e00 */ 0,0,0x8ffecd,0,0,0,0,0xfee8, 0,0,0x8ffecc,0,0,0x8ffece,0,0, /* 0,0,'鸂',0,0,0,0,'鸇', 0,0,'鸊',0,0,'鸍',0,0, */
	/* 9e10 */ 0,0,0,0,0,0xfee9,0,0, 0,0x8ffecf,0xf3c0,0xf3c1,0x8ffed0,0x8ffed1,0xf3c2,0, /* 0,0,0,0,0,'鸕',0,0, 0,'鸙','鸚','鸛','鸜','鸝','鸞',0, */
	/* 9e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e70 */ 0,0,0,0,0,0xf3c3,0,0, 0xb8b4,0xf3c4,0,0x8ffed2,0xfeea,0xf3c5,0,0xbcaf, /* 0,0,0,0,0,'鹵',0,0, '鹸','鹹',0,'鹻','鹼','鹽',0,'鹿', */
	/* 9e80 */ 0x8ffed4,0xf3c6,0,0,0,0x8ffed5,0,0, 0xf3c7,0,0,0xf3c8,0xf3c9,0,0,0, /* '麀','麁',0,0,0,'麅',0,0, '麈',0,0,'麋','麌',0,0,0, */
	/* 9e90 */ 0,0xf3cc,0xf3ca,0xcfbc,0,0xf3cb,0,0xceef, 0,0,0,0x8ffed6,0,0xf3cd,0xfeeb,0xcedb, /* 0,'麑','麒','麓',0,'麕',0,'麗', 0,0,0,'麛',0,'麝','麞','麟', */
	/* 9ea0 */ 0,0,0,0,0xfeec,0xf3ce,0xc7fe,0, 0x8ffed7,0xf3cf,0xf3d1,0,0xfeed,0xf3d2,0,0xfeee, /* 0,0,0,0,'麤','麥','麦',0, '麨','麩','麪',0,'麬','麭',0,'麯', */
	/* 9eb0 */ 0,0,0,0,0xfeef,0xfef0,0,0, 0xf3d0,0xb9ed,0xcccd,0xcbe3,0xd6f7,0x8ffed9,0xdde0,0xcbfb, /* 0,0,0,0,'麴','麵',0,0, '麸','麹','麺','麻','麼','麽','麾','麿', */
	/* 9ec0 */ 0,0,0,0xfef1,0xb2ab,0,0,0, 0,0,0,0,0xf3d4,0xb5d0,0xf3d5,0xf3d6, /* 0,0,0,'黃','黄',0,0,0, 0,0,0,0,'黌','黍','黎','黏', */
	/* 9ed0 */ 0xf3d7,0xfef2,0xb9f5,0,0xf3d8,0,0,0, 0xe0d4,0xccdb,0,0xc2e3,0xf3d9,0xf3db,0xf3da,0x8ffedb, /* '黐','黑','黒',0,'黔',0,0,0, '默','黙',0,'黛','黜','黝','點','黟', */
	/* 9ee0 */ 0xf3dc,0,0,0,0,0xf3dd,0,0x8ffedc, 0xf3de,0,0,0,0,0,0x8ffedd,0xf3df, /* '黠',0,0,0,0,'黥',0,'黧', '黨',0,0,0,0,0,'黮','黯', */
	/* 9ef0 */ 0,0,0,0,0xf3e0,0,0xf3e1,0xf3e2, 0,0xf3e3,0,0xf3e4,0xf3e5,0xf3e6,0,0x8ffede, /* 0,0,0,0,'黴',0,'黶','黷', 0,'黹',0,'黻','黼','黽',0,'黿', */
	/* 9f00 */ 0,0,0x8ffedf,0x8ffee1,0,0,0,0xf3e7, 0xf3e8,0,0,0,0,0,0xc5a4,0, /* 0,0,'鼂','鼃',0,0,0,'鼇', '鼈',0,0,0,0,0,'鼎',0, */
	/* 9f10 */ 0xfef3,0,0,0xb8dd,0,0xf3ea,0,0x8ffee2, 0,0x8ffee3,0,0,0,0,0,0, /* '鼐',0,0,'鼓',0,'鼕',0,'鼗', 0,'鼙',0,0,0,0,0,0, */
	/* 9f20 */ 0xc1cd,0xf3eb,0,0,0,0,0,0, 0,0,0,0,0xf3ec,0,0,0x8ffee4, /* '鼠','鼡',0,0,0,0,0,0, 0,0,0,0,'鼬',0,0,'鼯', */
	/* 9f30 */ 0,0,0,0,0,0,0,0x8ffee5, 0,0xfef4,0x8ffee6,0xc9a1,0,0x8ffee7,0xf3ed,0, /* 0,0,0,0,0,0,0,'鼷', 0,'鼹','鼺','鼻',0,'鼽','鼾',0, */
	/* 9f40 */ 0,0x8ffee8,0,0,0,0x8ffee9,0x8ffeea,0, 0,0,0xf3ee,0xe3b7,0,0,0xecda,0xf0ed, /* 0,'齁',0,0,0,'齅','齆',0, 0,0,'齊','齋',0,0,'齎','齏', */
	/* 9f50 */ 0,0,0xf3ef,0x8ffeeb,0xf3f0,0x8ffeec,0,0xfef5, 0x8ffeed,0,0,0,0,0x8ffeef,0,0xf3f2, /* 0,0,'齒','齓','齔','齕',0,'齗', '齘',0,0,0,0,'齝',0,'齟', */
	/* 9f60 */ 0xf3f3,0xf3f4,0xcef0,0xf3f1,0,0,0xf3f5,0xf3f6, 0,0x8ffef1,0xf3f8,0,0xf3f7,0x8ffef3,0,0, /* '齠','齡','齢','齣',0,0,'齦','齧', 0,'齩','齪',0,'齬','齭',0,0, */
	/* 9f70 */ 0x8ffef4,0,0xf3fa,0,0,0x8ffef5,0xf3fb,0xf3f9, 0,0,0,0,0,0,0,0, /* '齰',0,'齲',0,0,'齵','齶','齷', 0,0,0,0,0,0,0,0, */
	/* 9f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xceb6,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'龍',0,0, */
	/* 9f90 */ 0xfef6,0,0,0,0xfef7,0xf3fc,0,0xfef8, 0,0,0,0,0xf3fd,0xe3d4,0,0, /* '龐',0,0,0,'龔','龕',0,'龗', 0,0,0,0,'龜','龝',0,0, */
	/* 9fa0 */ 0xf3fe,0,0xfef9,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '龠',0,'龢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ace0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ada0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* add0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ade0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* beb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ceb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ced0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* deb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ded0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* def0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ead0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ece0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ede0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xf6bb,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'欄',0,0, */
	/* f920 */ 0,0,0,0,0,0,0,0, 0xf4ae,0xf5ce,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '廊','朗',0,0,0,0,0,0, */
	/* f930 */ 0,0,0,0,0,0,0xfbcf,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'虜',0, 0,0,0,0,0,0,0,0, */
	/* f940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f970 */ 0xf6c9,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '殺',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* f980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9d0 */ 0xfea4,0,0,0,0,0,0,0, 0,0,0,0,0xfddd,0,0,0, /* '類',0,0,0,0,0,0,0, 0,0,0,0,'隆',0,0,0, */
	/* f9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xafcb, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'﨏', */
	/* fa10 */ 0xafd7,0xcff2,0,0x8faef9,0xf5fa,0xf7da,0xf7ef,0, 0,0xf9bc,0xf9bd,0xf9c1,0,0,0,0xfbba, /* '塚','﨑',0,'﨓','﨔','凞','猪',0, 0,'神','祥','福',0,0,0,'﨟', */
	/* fa20 */ 0x8ff7b8,0x8ff7c5,0xfcae,0,0x8ff9ee,0,0xfcea,0, 0,0,0,0,0,0,0,0, /* '蘒','﨡','諸',0,'﨤',0,'都',0, 0,0,0,0,0,0,0,0, */
	/* fa30 */ 0xaeb8,0xaec9,0xaed0,0xaee3,0xaee8,0xaeee,0xafac,0xafaf, 0xafb6,0xafda,0xafde,0xcfe1,0xcfe2,0xf4d0,0xf4dc,0xf4de, /* '侮','僧','免','勉','勤','卑','喝','嘆', '器','塀','墨','層','屮','悔','慨','憎', */
	/* fa40 */ 0xf4e1,0xf5a8,0xf5ab,0xf5c3,0xf5e5,0xf6e9,0xf6f7,0xf7a5, 0xf7d5,0x8ff0a9,0xf8a5,0xf9a7,0xf9b3,0xf9b4,0xf9b7,0xf9b8, /* '懲','敏','既','暑','梅','海','渚','漢', '煮','爫','琢','碑','社','祉','祈','祐', */
	/* fa50 */ 0xf9b9,0xf9bb,0xf9bf,0xf9c0,0xf9cd,0xf9d1,0xf9e4,0xfaae, 0x8ff4d0,0xfab3,0xfaba,0xfac4,0xfad8,0x8ff5f4,0x8ff5f5,0xfba7, /* '祖','祝','禍','禎','穀','突','節','練', '縉','繁','署','者','臭','艹','艹','著', */
	/* fa60 */ 0xfbef,0xfbf9,0xfcaf,0xfcb0,0xfcb8,0xfcbd,0x8ff9e9,0xfcd9, 0xfde3,0xfdf6,0xfdfb,0,0,0,0,0, /* '褐','視','謁','謹','賓','贈','辶','逸', '難','響','頻',0,0,0,0,0, */
	/* fa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe40 */ 0,0,0,0,0,0xa3be,0xa3bd,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'﹅','﹆',0, 0,0,0,0,0,0,0,0, */
	/* fe50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* feb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ff00 */ 0,0xa1aa,0xa2b0,0xa1f4,0xa1f0,0xa1f3,0xa1f5,0xa2af, 0xa1ca,0xa1cb,0xa1f6,0xa1dc,0xa1a4,0xa2b1,0xa1a5,0xa1bf, /* 0,'！','＂','＃','＄','％','＆','＇', '（','）','＊','＋','，','－','．','／', */
	/* ff10 */ 0xa3b0,0xa3b1,0xa3b2,0xa3b3,0xa3b4,0xa3b5,0xa3b6,0xa3b7, 0xa3b8,0xa3b9,0xa1a7,0xa1a8,0xa1e3,0xa1e1,0xa1e4,0xa1a9, /* '０','１','２','３','４','５','６','７', '８','９','：','；','＜','＝','＞','？', */
	/* ff20 */ 0xa1f7,0xa3c1,0xa3c2,0xa3c3,0xa3c4,0xa3c5,0xa3c6,0xa3c7, 0xa3c8,0xa3c9,0xa3ca,0xa3cb,0xa3cc,0xa3cd,0xa3ce,0xa3cf, /* '＠','Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ', 'Ｈ','Ｉ','Ｊ','Ｋ','Ｌ','Ｍ','Ｎ','Ｏ', */
	/* ff30 */ 0xa3d0,0xa3d1,0xa3d2,0xa3d3,0xa3d4,0xa3d5,0xa3d6,0xa3d7, 0xa3d8,0xa3d9,0xa3da,0xa1ce,0xa1c0,0xa1cf,0xa1b0,0xa1b2, /* 'Ｐ','Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ', 'Ｘ','Ｙ','Ｚ','［','＼','］','＾','＿', */
	/* ff40 */ 0xa1ae,0xa3e1,0xa3e2,0xa3e3,0xa3e4,0xa3e5,0xa3e6,0xa3e7, 0xa3e8,0xa3e9,0xa3ea,0xa3eb,0xa3ec,0xa3ed,0xa3ee,0xa3ef, /* '｀','ａ','ｂ','ｃ','ｄ','ｅ','ｆ','ｇ', 'ｈ','ｉ','ｊ','ｋ','ｌ','ｍ','ｎ','ｏ', */
	/* ff50 */ 0xa3f0,0xa3f1,0xa3f2,0xa3f3,0xa3f4,0xa3f5,0xa3f6,0xa3f7, 0xa3f8,0xa3f9,0xa3fa,0xa1d0,0xa1c3,0xa1d1,0xa2b2,0xa2d6, /* 'ｐ','ｑ','ｒ','ｓ','ｔ','ｕ','ｖ','ｗ', 'ｘ','ｙ','ｚ','｛','｜','｝','～','｟', */
	/* ff60 */ 0xa2d7,0x8ea1,0x8ea2,0x8ea3,0x8ea4,0x8ea5,0x8ea6,0x8ea7, 0x8ea8,0x8ea9,0x8eaa,0x8eab,0x8eac,0x8ead,0x8eae,0x8eaf, /* '｠','｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* ff70 */ 0x8eb0,0x8eb1,0x8eb2,0x8eb3,0x8eb4,0x8eb5,0x8eb6,0x8eb7, 0x8eb8,0x8eb9,0x8eba,0x8ebb,0x8ebc,0x8ebd,0x8ebe,0x8ebf, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* ff80 */ 0x8ec0,0x8ec1,0x8ec2,0x8ec3,0x8ec4,0x8ec5,0x8ec6,0x8ec7, 0x8ec8,0x8ec9,0x8eca,0x8ecb,0x8ecc,0x8ecd,0x8ece,0x8ecf, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* ff90 */ 0x8ed0,0x8ed1,0x8ed2,0x8ed3,0x8ed4,0x8ed5,0x8ed6,0x8ed7, 0x8ed8,0x8ed9,0x8eda,0x8edb,0x8edc,0x8edd,0x8ede,0x8edf, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
};

const size_t _unibe2euc2004_table_size = sizeof(_unibe2euc2004_table) / sizeof(_unibe2euc2004_table[0]);

#endif /* #ifndef __UNIBE2EUC2004_TABLE_H_ */
