/*
 * _unibe2euc51932_table.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __UNIBE2EUC51932_TABLE_H_
#define __UNIBE2EUC51932_TABLE_H_

#include <stddef.h>
#include <stdint.h>

/* 0x8f code nothing */
const uint16_t _unibe2euc51932_table[] = {
	/* 0000 */ 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, 0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* '','','','','','','','', '','','','','','','','', */
	/* 0010 */ 0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, 0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* '','','','','','','','', '','','','','','','','', */
	/* 0020 */ 0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, 0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* ' ','!','"','#','$','%','&','\'', '(',')','*','+',',','-','.','/', */
	/* 0030 */ 0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, 0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* '0','1','2','3','4','5','6','7', '8','9',':',';','<','=','>','?', */
	/* 0040 */ 0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, 0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O', */
	/* 0050 */ 0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, 0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 'P','Q','R','S','T','U','V','W', 'X','Y','Z','[','\\',']','^','_', */
	/* 0060 */ 0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, 0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* '`','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o', */
	/* 0070 */ 0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, 0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f, /* 'p','q','r','s','t','u','v','w', 'x','y','z','{','|','}','~','', */
	/* 0080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00a0 */ 0,0,0xa1f1,0xa1f2,0,0x5c,0,0xa1f8, 0xa1af,0,0,0,0xa2cc,0,0,0, /* 0,0,'¢','£',0,'\\',0,'§', '¨',0,0,0,'¬',0,0,0, */
	/* 00b0 */ 0xa1eb,0xa1de,0,0,0xa1ad,0,0xa2f9,0, 0,0,0,0,0,0,0,0, /* '°','±',0,0,'´',0,'¶',0, 0,0,0,0,0,0,0,0, */
	/* 00c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00d0 */ 0,0,0,0,0,0,0,0xa1df, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'×', 0,0,0,0,0,0,0,0, */
	/* 00e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00f0 */ 0,0,0,0,0,0,0,0xa1e0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'÷', 0,0,0,0,0,0,0,0, */
	/* 0100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0390 */ 0,0xa6a1,0xa6a2,0xa6a3,0xa6a4,0xa6a5,0xa6a6,0xa6a7, 0xa6a8,0xa6a9,0xa6aa,0xa6ab,0xa6ac,0xa6ad,0xa6ae,0xa6af, /* 0,'Α','Β','Γ','Δ','Ε','Ζ','Η', 'Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο', */
	/* 03a0 */ 0xa6b0,0xa6b1,0,0xa6b2,0xa6b3,0xa6b4,0xa6b5,0xa6b6, 0xa6b7,0xa6b8,0,0,0,0,0,0, /* 'Π','Ρ',0,'Σ','Τ','Υ','Φ','Χ', 'Ψ','Ω',0,0,0,0,0,0, */
	/* 03b0 */ 0,0xa6c1,0xa6c2,0xa6c3,0xa6c4,0xa6c5,0xa6c6,0xa6c7, 0xa6c8,0xa6c9,0xa6ca,0xa6cb,0xa6cc,0xa6cd,0xa6ce,0xa6cf, /* 0,'α','β','γ','δ','ε','ζ','η', 'θ','ι','κ','λ','μ','ν','ξ','ο', */
	/* 03c0 */ 0xa6d0,0xa6d1,0,0xa6d2,0xa6d3,0xa6d4,0xa6d5,0xa6d6, 0xa6d7,0xa6d8,0,0,0,0,0,0, /* 'π','ρ',0,'σ','τ','υ','φ','χ', 'ψ','ω',0,0,0,0,0,0, */
	/* 03d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0400 */ 0,0xa7a7,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'Ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0410 */ 0xa7a1,0xa7a2,0xa7a3,0xa7a4,0xa7a5,0xa7a6,0xa7a8,0xa7a9, 0xa7aa,0xa7ab,0xa7ac,0xa7ad,0xa7ae,0xa7af,0xa7b0,0xa7b1, /* 'А','Б','В','Г','Д','Е','Ж','З', 'И','Й','К','Л','М','Н','О','П', */
	/* 0420 */ 0xa7b2,0xa7b3,0xa7b4,0xa7b5,0xa7b6,0xa7b7,0xa7b8,0xa7b9, 0xa7ba,0xa7bb,0xa7bc,0xa7bd,0xa7be,0xa7bf,0xa7c0,0xa7c1, /* 'Р','С','Т','У','Ф','Х','Ц','Ч', 'Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я', */
	/* 0430 */ 0xa7d1,0xa7d2,0xa7d3,0xa7d4,0xa7d5,0xa7d6,0xa7d8,0xa7d9, 0xa7da,0xa7db,0xa7dc,0xa7dd,0xa7de,0xa7df,0xa7e0,0xa7e1, /* 'а','б','в','г','д','е','ж','з', 'и','й','к','л','м','н','о','п', */
	/* 0440 */ 0xa7e2,0xa7e3,0xa7e4,0xa7e5,0xa7e6,0xa7e7,0xa7e8,0xa7e9, 0xa7ea,0xa7eb,0xa7ec,0xa7ed,0xa7ee,0xa7ef,0xa7f0,0xa7f1, /* 'р','с','т','у','ф','х','ц','ч', 'ш','щ','ъ','ы','ь','э','ю','я', */
	/* 0450 */ 0,0xa7d7,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2010 */ 0xa1be,0,0,0,0,0xa1bd,0xa1c2,0, 0xa1c6,0xa1c7,0,0,0xa1c8,0xa1c9,0,0, /* '‐',0,0,0,0,'―','‖',0, '‘','’',0,0,'“','”',0,0, */
	/* 2020 */ 0xa2f7,0xa2f8,0,0,0,0xa1c5,0xa1c4,0, 0,0,0,0,0,0,0,0, /* '†','‡',0,0,0,'‥','…',0, 0,0,0,0,0,0,0,0, */
	/* 2030 */ 0xa2f3,0,0xa1ec,0xa1ed,0,0,0,0, 0,0,0,0xa2a8,0,0,0,0, /* '‰',0,'′','″',0,0,0,0, 0,0,0,'※',0,0,0,0, */
	/* 2040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2100 */ 0,0,0,0xa1ee,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'℃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2110 */ 0,0,0,0,0,0,0xade2,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'№',0, 0,0,0,0,0,0,0,0, */
	/* 2120 */ 0,0xade4,0,0,0,0,0,0, 0,0,0,0xa2f2,0,0,0,0, /* 0,'℡',0,0,0,0,0,0, 0,0,0,'Å',0,0,0,0, */
	/* 2130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2160 */ 0xadb5,0xadb6,0xadb7,0xadb8,0xadb9,0xadba,0xadbb,0xadbc, 0xadbd,0xadbe,0,0,0,0,0,0, /* 'Ⅰ','Ⅱ','Ⅲ','Ⅳ','Ⅴ','Ⅵ','Ⅶ','Ⅷ', 'Ⅸ','Ⅹ',0,0,0,0,0,0, */
	/* 2170 */ 0xfcf1,0xfcf2,0xfcf3,0xfcf4,0xfcf5,0xfcf6,0xfcf7,0xfcf8, 0xfcf9,0xfcfa,0,0,0,0,0,0, /* 'ⅰ','ⅱ','ⅲ','ⅳ','ⅴ','ⅵ','ⅶ','ⅷ', 'ⅸ','ⅹ',0,0,0,0,0,0, */
	/* 2180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2190 */ 0xa2ab,0xa2ac,0xa2aa,0xa2ad,0,0,0,0, 0,0,0,0,0,0,0,0, /* '←','↑','→','↓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21d0 */ 0,0,0xa2cd,0,0xa2ce,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⇒',0,'⇔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2200 */ 0xa2cf,0,0xa2df,0xa2d0,0,0,0,0xa2e0, 0xa2ba,0,0,0xa2bb,0,0,0,0, /* '∀',0,'∂','∃',0,0,0,'∇', '∈',0,0,'∋',0,0,0,0, */
	/* 2210 */ 0,0xadf4,0xa1dd,0,0,0,0,0, 0,0,0xa2e5,0,0,0xa2e7,0xa1e7,0xadf8, /* 0,'∑','−',0,0,0,0,0, 0,0,'√',0,0,'∝','∞','∟', */
	/* 2220 */ 0xa2dc,0,0,0,0,0xa1c2,0,0xa2ca, 0xa2cb,0xa2c1,0xa2c0,0xa2e9,0xa2ea,0,0xadf3,0, /* '∠',0,0,0,0,'∥',0,'∧', '∨','∩','∪','∫','∬',0,'∮',0, */
	/* 2230 */ 0,0,0,0,0xa1e8,0xa2e8,0,0, 0,0,0,0,0,0xa2e6,0,0, /* 0,0,0,0,'∴','∵',0,0, 0,0,0,0,0,'∽',0,0, */
	/* 2240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2250 */ 0,0,0xa2e2,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'≒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2260 */ 0xa1e2,0xa2e1,0,0,0,0,0xa1e5,0xa1e6, 0,0,0xa2e3,0xa2e4,0,0,0,0, /* '≠','≡',0,0,0,0,'≦','≧', 0,0,'≪','≫',0,0,0,0, */
	/* 2270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2280 */ 0,0,0xa2be,0xa2bf,0,0,0xa2bc,0xa2bd, 0,0,0,0,0,0,0,0, /* 0,0,'⊂','⊃',0,0,'⊆','⊇', 0,0,0,0,0,0,0,0, */
	/* 2290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22a0 */ 0,0,0,0,0,0xa2dd,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⊥',0,0, 0,0,0,0,0,0,0,0, */
	/* 22b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xadf9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'⊿', */
	/* 22c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2310 */ 0,0,0xa2de,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⌒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2460 */ 0xada1,0xada2,0xada3,0xada4,0xada5,0xada6,0xada7,0xada8, 0xada9,0xadaa,0xadab,0xadac,0xadad,0xadae,0xadaf,0xadb0, /* '①','②','③','④','⑤','⑥','⑦','⑧', '⑨','⑩','⑪','⑫','⑬','⑭','⑮','⑯', */
	/* 2470 */ 0xadb1,0xadb2,0xadb3,0xadb4,0,0,0,0, 0,0,0,0,0,0,0,0, /* '⑰','⑱','⑲','⑳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2500 */ 0xa8a1,0xa8ac,0xa8a2,0xa8ad,0,0,0,0, 0,0,0,0,0xa8a3,0,0,0xa8ae, /* '─','━','│','┃',0,0,0,0, 0,0,0,0,'┌',0,0,'┏', */
	/* 2510 */ 0xa8a4,0,0,0xa8af,0xa8a6,0,0,0xa8b1, 0xa8a5,0,0,0xa8b0,0xa8a7,0xa8bc,0,0, /* '┐',0,0,'┓','└',0,0,'┗', '┘',0,0,'┛','├','┝',0,0, */
	/* 2520 */ 0xa8b7,0,0,0xa8b2,0xa8a9,0xa8be,0,0, 0xa8b9,0,0,0xa8b4,0xa8a8,0,0,0xa8b8, /* '┠',0,0,'┣','┤','┥',0,0, '┨',0,0,'┫','┬',0,0,'┯', */
	/* 2530 */ 0xa8bd,0,0,0xa8b3,0xa8aa,0,0,0xa8ba, 0xa8bf,0,0,0xa8b5,0xa8ab,0,0,0xa8bb, /* '┰',0,0,'┳','┴',0,0,'┷', '┸',0,0,'┻','┼',0,0,'┿', */
	/* 2540 */ 0,0,0xa8c0,0,0,0,0,0, 0,0,0,0xa8b6,0,0,0,0, /* 0,0,'╂',0,0,0,0,0, 0,0,0,'╋',0,0,0,0, */
	/* 2550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25a0 */ 0xa2a3,0xa2a2,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '■','□',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25b0 */ 0,0,0xa2a5,0xa2a4,0,0,0,0, 0,0,0,0,0xa2a7,0xa2a6,0,0, /* 0,0,'▲','△',0,0,0,0, 0,0,0,0,'▼','▽',0,0, */
	/* 25c0 */ 0,0,0,0,0,0,0xa2a1,0xa1fe, 0,0,0,0xa1fb,0,0,0xa1fd,0xa1fc, /* 0,0,0,0,0,0,'◆','◇', 0,0,0,'○',0,0,'◎','●', */
	/* 25d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xa2fe, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'◯', */
	/* 25f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2600 */ 0,0,0,0,0,0xa1fa,0xa1f9,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'★','☆',0, 0,0,0,0,0,0,0,0, */
	/* 2610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2640 */ 0xa1ea,0,0xa1e9,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '♀',0,'♂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2660 */ 0,0,0,0,0,0,0,0, 0,0,0xa2f6,0,0,0xa2f5,0,0xa2f4, /* 0,0,0,0,0,0,0,0, 0,0,'♪',0,0,'♭',0,'♯', */
	/* 2670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3000 */ 0xa1a1,0xa1a2,0xa1a3,0xa1b7,0,0xa1b9,0xa1ba,0xa1bb, 0xa1d2,0xa1d3,0xa1d4,0xa1d5,0xa1d6,0xa1d7,0xa1d8,0xa1d9, /* '　','、','。','〃',0,'々','〆','〇', '〈','〉','《','》','「','」','『','』', */
	/* 3010 */ 0xa1da,0xa1db,0xa2a9,0xa2ae,0xa1cc,0xa1cd,0,0, 0,0,0,0,0xa1c1,0xade0,0,0xade1, /* '【','】','〒','〓','〔','〕',0,0, 0,0,0,0,'～','〝',0,'〟', */

	/* 3020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3040 */ 0,0xa4a1,0xa4a2,0xa4a3,0xa4a4,0xa4a5,0xa4a6,0xa4a7, 0xa4a8,0xa4a9,0xa4aa,0xa4ab,0xa4ac,0xa4ad,0xa4ae,0xa4af, /* 0,'ぁ','あ','ぃ','い','ぅ','う','ぇ', 'え','ぉ','お','か','が','き','ぎ','く', */
	/* 3050 */ 0xa4b0,0xa4b1,0xa4b2,0xa4b3,0xa4b4,0xa4b5,0xa4b6,0xa4b7, 0xa4b8,0xa4b9,0xa4ba,0xa4bb,0xa4bc,0xa4bd,0xa4be,0xa4bf, /* 'ぐ','け','げ','こ','ご','さ','ざ','し', 'じ','す','ず','せ','ぜ','そ','ぞ','た', */
	/* 3060 */ 0xa4c0,0xa4c1,0xa4c2,0xa4c3,0xa4c4,0xa4c5,0xa4c6,0xa4c7, 0xa4c8,0xa4c9,0xa4ca,0xa4cb,0xa4cc,0xa4cd,0xa4ce,0xa4cf, /* 'だ','ち','ぢ','っ','つ','づ','て','で', 'と','ど','な','に','ぬ','ね','の','は', */
	/* 3070 */ 0xa4d0,0xa4d1,0xa4d2,0xa4d3,0xa4d4,0xa4d5,0xa4d6,0xa4d7, 0xa4d8,0xa4d9,0xa4da,0xa4db,0xa4dc,0xa4dd,0xa4de,0xa4df, /* 'ば','ぱ','ひ','び','ぴ','ふ','ぶ','ぷ', 'へ','べ','ぺ','ほ','ぼ','ぽ','ま','み', */
	/* 3080 */ 0xa4e0,0xa4e1,0xa4e2,0xa4e3,0xa4e4,0xa4e5,0xa4e6,0xa4e7, 0xa4e8,0xa4e9,0xa4ea,0xa4eb,0xa4ec,0xa4ed,0xa4ee,0xa4ef, /* 'む','め','も','ゃ','や','ゅ','ゆ','ょ', 'よ','ら','り','る','れ','ろ','ゎ','わ', */
	/* 3090 */ 0xa4f0,0xa4f1,0xa4f2,0xa4f3,0,0,0,0, 0,0,0,0xa1ab,0xa1ac,0xa1b5,0xa1b6,0, /* 'ゐ','ゑ','を','ん',0,0,0,0, 0,0,0,'゛','゜','ゝ','ゞ',0, */
	/* 30a0 */ 0,0xa5a1,0xa5a2,0xa5a3,0xa5a4,0xa5a5,0xa5a6,0xa5a7, 0xa5a8,0xa5a9,0xa5aa,0xa5ab,0xa5ac,0xa5ad,0xa5ae,0xa5af, /* 0,'ァ','ア','ィ','イ','ゥ','ウ','ェ', 'エ','ォ','オ','カ','ガ','キ','ギ','ク', */
	/* 30b0 */ 0xa5b0,0xa5b1,0xa5b2,0xa5b3,0xa5b4,0xa5b5,0xa5b6,0xa5b7, 0xa5b8,0xa5b9,0xa5ba,0xa5bb,0xa5bc,0xa5bd,0xa5be,0xa5bf, /* 'グ','ケ','ゲ','コ','ゴ','サ','ザ','シ', 'ジ','ス','ズ','セ','ゼ','ソ','ゾ','タ', */
	/* 30c0 */ 0xa5c0,0xa5c1,0xa5c2,0xa5c3,0xa5c4,0xa5c5,0xa5c6,0xa5c7, 0xa5c8,0xa5c9,0xa5ca,0xa5cb,0xa5cc,0xa5cd,0xa5ce,0xa5cf, /* 'ダ','チ','ヂ','ッ','ツ','ヅ','テ','デ', 'ト','ド','ナ','ニ','ヌ','ネ','ノ','ハ', */
	/* 30d0 */ 0xa5d0,0xa5d1,0xa5d2,0xa5d3,0xa5d4,0xa5d5,0xa5d6,0xa5d7, 0xa5d8,0xa5d9,0xa5da,0xa5db,0xa5dc,0xa5dd,0xa5de,0xa5df, /* 'バ','パ','ヒ','ビ','ピ','フ','ブ','プ', 'ヘ','ベ','ペ','ホ','ボ','ポ','マ','ミ', */
	/* 30e0 */ 0xa5e0,0xa5e1,0xa5e2,0xa5e3,0xa5e4,0xa5e5,0xa5e6,0xa5e7, 0xa5e8,0xa5e9,0xa5ea,0xa5eb,0xa5ec,0xa5ed,0xa5ee,0xa5ef, /* 'ム','メ','モ','ャ','ヤ','ュ','ユ','ョ', 'ヨ','ラ','リ','ル','レ','ロ','ヮ','ワ', */
	/* 30f0 */ 0xa5f0,0xa5f1,0xa5f2,0xa5f3,0xa5f4,0xa5f5,0xa5f6,0, 0,0,0,0xa1a6,0xa1bc,0xa1b3,0xa1b4,0, /* 'ヰ','ヱ','ヲ','ン','ヴ','ヵ','ヶ',0, 0,0,0,'・','ー','ヽ','ヾ',0, */
	/* 3100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3230 */ 0,0xadea,0xadeb,0,0,0,0,0, 0,0xadec,0,0,0,0,0,0, /* 0,'㈱','㈲',0,0,0,0,0, 0,'㈹',0,0,0,0,0,0, */
	/* 3240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32a0 */ 0,0,0,0,0xade5,0xade6,0xade7,0xade8, 0xade9,0,0,0,0,0,0,0, /* 0,0,0,0,'㊤','㊥','㊦','㊧', '㊨',0,0,0,0,0,0,0, */
	/* 32b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3300 */ 0,0,0,0xadc6,0,0,0,0, 0,0,0,0,0,0xadca,0,0, /* 0,0,0,'㌃',0,0,0,0, 0,0,0,0,0,'㌍',0,0, */
	/* 3310 */ 0,0,0,0,0xadc1,0,0,0, 0xadc4,0,0,0,0,0,0,0, /* 0,0,0,0,'㌔',0,0,0, '㌘',0,0,0,0,0,0,0, */
	/* 3320 */ 0,0,0xadc2,0xadcc,0,0,0xadcb,0xadc5, 0,0,0,0xadcd,0,0,0,0, /* 0,0,'㌢','㌣',0,0,'㌦','㌧', 0,0,0,'㌫',0,0,0,0, */
	/* 3330 */ 0,0,0,0,0,0,0xadc7,0, 0,0,0,0xadcf,0,0,0,0, /* 0,0,0,0,0,0,'㌶',0, 0,0,0,'㌻',0,0,0,0, */
	/* 3340 */ 0,0,0,0,0,0,0,0, 0,0xadc0,0xadce,0,0,0xadc3,0,0, /* 0,0,0,0,0,0,0,0, 0,'㍉','㍊',0,0,'㍍',0,0, */
	/* 3350 */ 0,0xadc8,0,0,0,0,0,0xadc9, 0,0,0,0,0,0,0,0, /* 0,'㍑',0,0,0,0,0,'㍗', 0,0,0,0,0,0,0,0, */
	/* 3360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3370 */ 0,0,0,0,0,0,0,0, 0,0,0,0xaddf,0xadef,0xadee,0xaded,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'㍻','㍼','㍽','㍾',0, */
	/* 3380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xadd3,0xadd4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㎎','㎏', */
	/* 3390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xadd0,0xadd1,0xadd2,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㎜','㎝','㎞',0, */
	/* 33a0 */ 0,0xadd6,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'㎡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 33b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33c0 */ 0,0,0,0,0xadd5,0,0,0, 0,0,0,0,0,0xade3,0,0, /* 0,0,0,0,'㏄',0,0,0, 0,0,0,0,0,'㏍',0,0, */
	/* 33d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

	/* 4d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e00 */ 0xb0ec,0xc3fa,0,0xbcb7,0,0,0,0xcbfc, 0xbee6,0xbbb0,0xbee5,0xb2bc,0,0xc9d4,0xcdbf,0, /* '一','丁',0,'七',0,0,0,'万', '丈','三','上','下',0,'不','与',0, */
	/* 4e10 */ 0xd0a2,0xb1af,0,0,0xb3ee,0xd0a3,0xc0a4,0xd2c2, 0xb5d6,0xcaba,0,0,0,0,0xbee7,0, /* '丐','丑',0,0,'且','丕','世','丗', '丘','丙',0,0,0,0,'丞',0, */
	/* 4e20 */ 0,0xcebe,0,0,0,0,0xcac2,0, 0xf9ad,0,0xd0a4,0,0,0xc3e6,0,0, /* 0,'両',0,0,0,0,'並',0, '丨',0,'个',0,0,'中',0,0, */
	/* 4e30 */ 0,0xd0a5,0xb6fa,0,0,0,0xd0a6,0, 0xb4dd,0xc3b0,0,0xbce7,0xd0a7,0,0,0xd0a8, /* 0,'丱','串',0,0,0,'丶',0, '丸','丹',0,'主','丼',0,0,'丿', */
	/* 4e40 */ 0,0,0xd0a9,0xc7b5,0,0xb5d7,0,0, 0,0,0,0xc7b7,0,0xc6e3,0xb8c3,0xcbb3, /* 0,0,'乂','乃',0,'久',0,0, 0,0,0,'之',0,'乍','乎','乏', */
	/* 4e50 */ 0,0,0,0,0,0xe9c9,0xd0aa,0xbee8, 0xd0ab,0xb2b5,0,0,0,0xb6e5,0xb8f0,0xcce9, /* 0,0,0,0,0,'乕','乖','乗', '乘','乙',0,0,0,'九','乞','也', */
	/* 4e60 */ 0,0,0xd6a6,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'乢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4e70 */ 0,0xcdf0,0,0xc6fd,0,0,0,0, 0,0,0,0,0,0,0xb4a5,0, /* 0,'乱',0,'乳',0,0,0,0, 0,0,0,0,0,0,'乾',0, */
	/* 4e80 */ 0xb5b5,0,0xd0ac,0,0,0xd0ad,0xcebb,0, 0xcdbd,0xc1e8,0xd0af,0xbbf6,0xc6f3,0,0xd0b2,0, /* '亀',0,'亂',0,0,'亅','了',0, '予','争','亊','事','二',0,'于',0, */
	/* 4e90 */ 0,0xb1be,0xb8df,0,0xb8de,0xb0e6,0,0, 0xcfcb,0xcfca,0,0xbab3,0xb0a1,0,0xd0b3,0xd0b4, /* 0,'云','互',0,'五','井',0,0, '亘','亙',0,'些','亜',0,'亞','亟', */
	/* 4ea0 */ 0xd0b5,0xcbb4,0xd0b6,0,0xb8f2,0xb0e7,0xcbf2,0, 0xb5fc,0,0,0xb5fd,0xb5fe,0xc4e2,0xcebc,0, /* '亠','亡','亢',0,'交','亥','亦',0, '亨',0,0,'享','京','亭','亮',0, */
	/* 4eb0 */ 0xd0b7,0,0,0xd0b8,0,0,0xd0b9,0, 0,0,0xbfcd,0,0,0,0,0, /* '亰',0,0,'亳',0,0,'亶',0, 0,0,'人',0,0,0,0,0, */
	/* 4ec0 */ 0xbdba,0xbfce,0xd0be,0,0xd0bc,0,0xd0bd,0xb5d8, 0,0,0xbaa3,0xb2f0,0,0xd0bb,0xd0ba,0xcaa9, /* '什','仁','仂',0,'仄',0,'仆','仇', 0,0,'今','介',0,'仍','从','仏', */
	/* 4ed0 */ 0,0,0,0,0xbbc6,0xbbc5,0xc2be,0xd0bf, 0xc9d5,0xc0e7,0,0,0,0xa1b8,0xd0c0,0xd0c2, /* 0,0,0,0,'仔','仕','他','仗', '付','仙',0,0,0,'仝','仞','仟', */
	/* 4ee0 */ 0,0xf9ae,0,0xc2e5,0xcee1,0xb0ca,0,0, 0,0,0,0,0,0xd0c1,0xb2be,0, /* 0,'仡',0,'代','令','以',0,0, 0,0,0,0,0,'仭','仮',0, */
	/* 4ef0 */ 0xb6c4,0,0xc3e7,0,0,0,0xb7ef,0xd0c3, 0,0,0,0xc7a4,0xf9af,0,0,0, /* '仰',0,'仲',0,0,0,'件','价', 0,0,0,'任','仼',0,0,0, */
	/* 4f00 */ 0xf9b0,0xb4eb,0,0xf9b1,0,0,0,0, 0,0xd0c4,0xb0cb,0,0,0xb8e0,0xb4ec,0xc9fa, /* '伀','企',0,'伃',0,0,0,0, 0,'伉','伊',0,0,'伍','伎','伏', */
	/* 4f10 */ 0xc8b2,0xb5d9,0,0,0,0,0,0, 0,0,0xb2f1,0,0xd0e7,0xc5c1,0,0, /* '伐','休',0,0,0,0,0,0, 0,0,'会',0,'伜','伝',0,0, */
	/* 4f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xc7ec, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'伯', */
	/* 4f30 */ 0xd0c6,0,0,0,0xc8bc,0,0xcee2,0, 0xbfad,0xf9b2,0xbbc7,0,0xbbf7,0xb2c0,0,0, /* '估',0,0,0,'伴',0,'伶',0, '伸','伹','伺',0,'似','伽',0,0, */
	/* 4f40 */ 0,0,0,0xc4d1,0,0,0xc3a2,0xd0ca, 0,0,0,0,0,0xb0cc,0xc4e3,0xbdbb, /* 0,0,0,'佃',0,0,'但','佇', 0,0,0,0,0,'位','低','住', */
	/* 4f50 */ 0xbab4,0xcda4,0,0xc2ce,0,0xb2bf,0xf9b3,0xd0c9, 0,0xcdbe,0xd0c5,0xd0c7,0xbaee,0xd0c8,0xd5a4,0, /* '佐','佑',0,'体',0,'何','佖','佗', 0,'余','佚','佛','作','佝','佞',0, */
	/* 4f60 */ 0,0,0,0,0,0,0,0, 0,0xd0d0,0,0,0,0,0,0xd0d3, /* 0,0,0,0,0,0,0,0, 0,'佩',0,0,0,0,0,'佯', */
	/* 4f70 */ 0xd0d1,0,0,0xb2c2,0,0xcabb,0xd0cb,0, 0,0,0,0xd0cf,0xb8f3,0,0,0xbbc8, /* '佰',0,0,'佳',0,'併','佶',0, 0,0,0,'佻','佼',0,0,'使', */
	/* 4f80 */ 0,0,0,0xb4a6,0,0,0xd0d4,0, 0xd0cc,0,0xf9b5,0xcee3,0,0xbbf8,0,0xd0cd, /* 0,0,0,'侃',0,0,'來',0, '侈',0,'侊','例',0,'侍',0,'侏', */
	/* 4f90 */ 0,0xd0d2,0xf9b4,0,0xf9b7,0,0xd0d5,0, 0xd0ce,0,0xf9b6,0xb6a1,0,0xb0cd,0,0, /* 0,'侑','侒',0,'侔',0,'侖',0, '侘',0,'侚','供',0,'依',0,0, */
	/* 4fa0 */ 0xb6a2,0xb2c1,0,0,0,0,0,0, 0,0,0,0xd5a5,0,0xcbf9,0xc9ee,0xb8f4, /* '侠','価',0,0,0,0,0,0, 0,0,0,'侫',0,'侭','侮','侯', */
	/* 4fb0 */ 0,0,0,0,0,0xbfaf,0xceb7,0, 0,0,0,0,0,0,0,0xcad8, /* 0,0,0,0,0,'侵','侶',0, 0,0,0,0,0,0,0,'便', */
	/* 4fc0 */ 0,0,0xb7b8,0xc2a5,0xb2e4,0,0,0, 0,0xf9a6,0xbdd3,0,0,0xf9b8,0xd0d9,0, /* 0,0,'係','促','俄',0,0,0, 0,'俉','俊',0,0,'俍','俎',0, */
	/* 4fd0 */ 0xd0de,0xd0dc,0,0,0xd0d7,0,0,0xc2af, 0xd0da,0,0xd0dd,0xd0db,0,0xcadd,0,0xd0d8, /* '俐','俑',0,0,'俔',0,0,'俗', '俘',0,'俚','俛',0,'保',0,'俟', */
	/* 4fe0 */ 0,0xbfae,0,0xcbf3,0xd0df,0xd0e0,0,0, 0,0,0,0,0,0,0xbda4,0xd0ed, /* 0,'信',0,'俣','俤','俥',0,0, 0,0,0,0,0,0,'修','俯', */
	/* 4ff0 */ 0,0,0,0xc7d0,0,0xc9b6,0xd0e8,0, 0xcaf0,0,0xb2b6,0,0,0,0xd0ec,0xf9bb, /* 0,0,0,'俳',0,'俵','俶',0, '俸',0,'俺',0,0,0,'俾','俿', */
	/* 5000 */ 0,0,0,0,0,0xd0e6,0xd0ef,0, 0,0xc1d2,0,0xb8c4,0,0xc7dc,0,0xe0c7, /* 0,0,0,0,0,'倅','倆',0, 0,'倉',0,'個',0,'倍',0,'倏', */
	/* 5010 */ 0,0xd0ee,0xc5dd,0,0xd0e3,0,0xb8f6,0, 0,0xb8f5,0xd0e1,0,0,0,0xf9bc,0xbcda, /* 0,'們','倒',0,'倔',0,'倖',0, 0,'候','倚',0,0,0,'倞','借', */
	/* 5020 */ 0,0xd0e9,0xf9ba,0xcaef,0xc3cd,0xd0e5,0xb7f1,0, 0xd0e2,0xd0ea,0xd0e4,0xced1,0xd0eb,0xcfc1,0,0, /* 0,'倡','倢','倣','値','倥','倦',0, '倨','倩','倪','倫','倬','倭',0,0, */
	/* 5030 */ 0,0,0,0,0,0,0xb6e6,0, 0,0xb7f0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'倶',0, 0,'倹',0,0,0,0,0,0, */
	/* 5040 */ 0xf9b9,0,0xf9bf,0xd0f0,0,0,0xf9bd,0xd0f1, 0xd0f5,0xb0ce,0,0,0,0,0,0xcad0, /* '偀',0,'偂','偃',0,0,'偆','假', '偈','偉',0,0,0,0,0,'偏', */
	/* 5050 */ 0xd0f4,0,0,0,0,0xd0f3,0xd0f7,0, 0,0,0xd0f6,0,0xc4e4,0,0,0, /* '偐',0,0,0,0,'偕','偖',0, 0,0,'做',0,'停',0,0,0, */
	/* 5060 */ 0,0,0,0,0,0xb7f2,0,0, 0,0,0,0,0xd0f8,0,0,0, /* 0,0,0,0,0,'健',0,0, 0,0,0,0,'偬',0,0,0, */
	/* 5070 */ 0xf9be,0,0xbcc5,0,0xc2a6,0xc4e5,0xb6f6,0, 0xd0f9,0,0,0,0,0xb5b6,0,0, /* '偰',0,'偲',0,'側','偵','偶',0, '偸',0,0,0,0,'偽',0,0, */
	/* 5080 */ 0xd0fa,0,0,0,0,0xd0fc,0,0, 0,0,0,0,0,0xcbb5,0,0, /* '傀',0,0,0,0,'傅',0,0, 0,0,0,0,0,'傍',0,0, */
	/* 5090 */ 0,0xb7e6,0,0,0xf9c0,0,0,0, 0xbbb1,0xc8f7,0xd0fb,0,0,0,0,0, /* 0,'傑',0,0,'傔',0,0,0, '傘','備','傚',0,0,0,0,0, */
	/* 50a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xbac5,0xcdc3,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'催','傭',0,0, */
	/* 50b0 */ 0,0,0xd0fe,0xd1a3,0xd0fd,0xbac4,0,0xbdfd, 0,0,0,0,0,0,0xb7b9,0, /* 0,0,'傲','傳','傴','債',0,'傷', 0,0,0,0,0,0,'傾',0, */
	/* 50c0 */ 0,0,0xd1a4,0,0,0xb6cf,0,0, 0,0xd1a1,0xd1a2,0,0,0xc6af,0,0xc1fc, /* 0,0,'僂',0,0,'僅',0,0, 0,'僉','僊',0,0,'働',0,'像', */
	/* 50d0 */ 0,0xb6a3,0,0,0,0xcbcd,0xd1a5,0, 0xf9c2,0,0xcebd,0,0,0,0xd1a6,0, /* 0,'僑',0,0,0,'僕','僖',0, '僘',0,'僚',0,0,0,'僞',0, */
	/* 50e0 */ 0,0,0,0xd1a9,0,0xd1a7,0,0xc1ce, 0,0,0,0,0,0xd1a8,0xd1aa,0, /* 0,0,0,'僣',0,'僥',0,'僧', 0,0,0,0,0,'僭','僮',0, */
	/* 50f0 */ 0,0,0,0,0xf9c1,0xd1ac,0,0, 0,0xd1ab,0,0xcac8,0,0,0,0, /* 0,0,0,0,'僴','僵',0,0, 0,'價',0,'僻',0,0,0,0, */
	/* 5100 */ 0xb5b7,0xd1ae,0xd1af,0,0xb2af,0,0,0, 0,0xd1ad,0,0,0,0,0,0, /* '儀','儁','儂',0,'億',0,0,0, 0,'儉',0,0,0,0,0,0, */
	/* 5110 */ 0,0,0xbcf4,0,0xd1b2,0xd1b1,0xd1b0,0, 0xd0d6,0,0xd1b3,0,0,0,0,0xbdfe, /* 0,0,'儒',0,'儔','儕','儖',0, '儘',0,'儚',0,0,0,0,'償', */
	/* 5120 */ 0,0xd1b4,0,0,0,0,0,0, 0,0,0xcda5,0,0,0,0,0, /* 0,'儡',0,0,0,0,0,0, 0,0,'優',0,0,0,0,0, */
	/* 5130 */ 0,0,0xccd9,0,0,0,0,0xd1b6, 0,0,0xd1b5,0xd1b8,0xd1b7,0,0,0xd1b9, /* 0,0,'儲',0,0,0,0,'儷', 0,0,'儺','儻','儼',0,0,'儿', */
	/* 5140 */ 0xd1ba,0xb0f4,0,0xb8b5,0xb7bb,0xbdbc,0xc3fb,0xb6a4, 0xc0e8,0xb8f7,0xf9c3,0xb9ee,0xd1bc,0xccc8,0xc5c6,0, /* '兀','允',0,'元','兄','充','兆','兇', '先','光','兊','克','兌','免','兎',0, */
	/* 5150 */ 0xbbf9,0,0xd1bb,0,0xd1bd,0,0,0, 0,0,0xc5de,0,0xb3f5,0,0,0, /* '児',0,'兒',0,'兔',0,0,0, 0,0,'党',0,'兜',0,0,0, */
	/* 5160 */ 0,0,0xd1be,0,0xf9c4,0xc6fe,0,0, 0xc1b4,0xd1c0,0xd1c1,0xc8ac,0xb8f8,0xcfbb,0xd1c2,0, /* 0,0,'兢',0,'兤','入',0,0, '全','兩','兪','八','公','六','兮',0, */
	/* 5170 */ 0,0xb6a6,0,0,0,0xcabc,0xc2b6,0xb6f1, 0xc5b5,0,0,0,0xb7f3,0,0,0, /* 0,'共',0,0,0,'兵','其','具', '典',0,0,0,'兼',0,0,0, */
	/* 5180 */ 0xd1c3,0,0xd1c4,0,0,0xc6e2,0xb1df,0, 0,0xd1c7,0xbafd,0,0xd1c6,0xbac6,0,0xd1c8, /* '冀',0,'冂',0,0,'内','円',0, 0,'冉','冊',0,'册','再',0,'冏', */
	/* 5190 */ 0xe6ee,0xd1c9,0xcbc1,0xd1ca,0,0xd1cb,0xd1cc,0xbee9, 0,0xbccc,0,0,0,0xf9c5,0,0, /* '冐','冑','冒','冓',0,'冕','冖','冗', 0,'写',0,0,0,'冝',0,0, */
	/* 51a0 */ 0xb4a7,0,0xd1cf,0,0xd1cd,0xccbd,0xd1ce,0, 0xc9da,0xd1d0,0xd1d1,0xd1d2,0xc5df,0,0,0, /* '冠',0,'冢',0,'冤','冥','冦',0, '冨','冩','冪','冫','冬',0,0,0, */
	/* 51b0 */ 0xd1d6,0xd1d4,0xd1d5,0xd1d3,0xbae3,0xd1d7,0xccea,0xcee4, 0,0,0,0,0,0xd1d8,0xf9c6,0, /* '冰','冱','冲','决','冴','况','冶','冷', 0,0,0,0,0,'冽','冾',0, */
	/* 51c0 */ 0,0,0,0,0xc0a8,0xd1d9,0xbdda,0, 0,0xd1da,0,0xc3fc,0xcebf,0xc5e0,0,0, /* 0,0,0,0,'凄','凅','准',0, 0,'凉',0,'凋','凌','凍',0,0, */
	/* 51d0 */ 0,0,0,0,0,0,0xd2c5,0, 0,0,0,0xd1db,0xf4a5,0xb6c5,0,0, /* 0,0,0,0,0,0,'凖',0, 0,0,0,'凛','凜','凝',0,0, */
	/* 51e0 */ 0xd1dc,0xcbde,0,0,0,0,0xbde8,0xc2fc, 0,0xd1de,0xc6e4,0,0xf9c7,0xd1df,0,0, /* '几','凡',0,0,0,0,'処','凧', 0,'凩','凪',0,'凬','凭',0,0, */
	/* 51f0 */ 0xd1e0,0xb3ae,0,0,0,0xd1e1,0xb6a7,0, 0xc6cc,0xb1fa,0xbdd0,0,0,0xc8a1,0xd1e2,0, /* '凰','凱',0,0,0,'凵','凶',0, '凸','凹','出',0,0,'函','凾',0, */
	/* 5200 */ 0xc5e1,0,0,0xbfcf,0xd1e3,0,0xcaac,0xc0da, 0xb4a2,0,0xb4a9,0xd1e4,0,0,0xd1e6,0, /* '刀',0,0,'刃','刄',0,'分','切', '刈',0,'刊','刋',0,0,'刎',0, */
	/* 5210 */ 0,0xb7ba,0,0,0xd1e5,0xf9c8,0,0xcef3, 0,0,0,0,0,0xbde9,0,0, /* 0,'刑',0,0,'刔','刕',0,'列', 0,0,0,0,0,'初',0,0, */
	/* 5220 */ 0,0,0,0,0xc8bd,0xcacc,0,0xd1e7, 0,0xcdf8,0xd1e8,0,0,0,0xd1e9,0, /* 0,0,0,0,'判','別',0,'刧', 0,'利','刪',0,0,0,'刮',0, */
	/* 5230 */ 0xc5fe,0,0,0xd1ea,0,0,0xc0a9,0xbafe, 0xb7f4,0xd1eb,0xbbc9,0xb9ef,0,0,0,0, /* '到',0,0,'刳',0,0,'制','刷', '券','刹','刺','刻',0,0,0,0, */
	/* 5240 */ 0,0,0,0xc4e6,0xd1ed,0,0,0xc2a7, 0,0,0xbaef,0xd1ee,0xd1ef,0xc1b0,0,0xd1ec, /* 0,0,0,'剃','剄',0,0,'則', 0,0,'削','剋','剌','前',0,'剏', */
	/* 5250 */ 0,0,0,0,0xd1f1,0,0xcbb6,0, 0,0,0,0xb9e4,0,0,0xd1f0,0, /* 0,0,0,0,'剔',0,'剖',0, 0,0,0,'剛',0,0,'剞',0, */
	/* 5260 */ 0,0,0,0xb7f5,0xbade,0xc7ed,0,0, 0,0xd1f4,0xd1f2,0,0,0,0,0xc9fb, /* 0,0,0,'剣','剤','剥',0,0, 0,'剩','剪',0,0,0,0,'副', */
	/* 5270 */ 0xbeea,0xd1fb,0xb3e4,0xd1f5,0xd1f3,0xc1cf,0,0, 0,0,0,0,0,0xd1f7,0,0xd1f6, /* '剰','剱','割','剳','剴','創',0,0, 0,0,0,0,0,'剽',0,'剿', */
	/* 5280 */ 0,0,0,0xb3c4,0,0,0,0xb7e0, 0xd1fc,0xcead,0,0,0,0xd1f8,0,0, /* 0,0,0,'劃',0,0,0,'劇', '劈','劉',0,0,0,'劍',0,0, */
	/* 5290 */ 0,0xd1fd,0xd1fa,0,0xd1f9,0,0,0, 0,0,0,0xcecf,0xf9c9,0,0,0xb8f9, /* 0,'劑','劒',0,'劔',0,0,0, 0,0,0,'力','劜',0,0,'功', */
	/* 52a0 */ 0xb2c3,0,0,0xcef4,0,0,0xf9ca,0, 0,0xbdf5,0xc5d8,0xb9e5,0xd2a2,0xd2a3,0,0xfbbc, /* '加',0,0,'劣',0,0,'劦',0, 0,'助','努','劫','劬','劭',0,'劯', */
	/* 52b0 */ 0,0xcee5,0,0,0xcfab,0xd2a5,0,0, 0,0xb8fa,0,0,0xd2a4,0,0xb3af,0, /* 0,'励',0,0,'労','劵',0,0, 0,'効',0,0,'劼',0,'劾',0, */
	/* 52c0 */ 0xf9cb,0xd2a6,0,0xcbd6,0,0xc4bc,0,0xcda6, 0,0xcad9,0,0,0,0xd2a7,0,0, /* '勀','勁',0,'勃',0,'勅',0,'勇', 0,'勉',0,0,0,'勍',0,0, */
	/* 52d0 */ 0,0,0xf0d5,0,0,0xc6b0,0,0xd2a8, 0xb4aa,0xccb3,0,0xf9cc,0,0xbea1,0xd2a9,0xcae7, /* 0,0,'勒',0,0,'動',0,'勗', '勘','務',0,'勛',0,'勝','勞','募', */
	/* 52e0 */ 0xd2ad,0,0xc0aa,0xd2aa,0xb6d0,0,0xd2ab,0xb4ab, 0,0,0,0,0,0,0,0, /* '勠',0,'勢','勣','勤',0,'勦','勧', 0,0,0,0,0,0,0,0, */
	/* 52f0 */ 0,0,0xb7ae,0xd2ae,0,0xd2af,0,0, 0xd2b0,0xd2b1,0xbcdb,0,0,0,0xb8fb,0xccde, /* 0,0,'勲','勳',0,'勵',0,0, '勸','勹','勺',0,0,0,'勾','勿', */
	/* 5300 */ 0xf9cd,0xcce8,0xc6f7,0,0,0xcaf1,0xd2b2,0xf9ce, 0xd2b3,0,0,0,0,0xd2b5,0,0xd2b7, /* '匀','匁','匂',0,0,'包','匆','匇', '匈',0,0,0,0,'匍',0,'匏', */
	/* 5310 */ 0xd2b6,0,0,0,0,0xd2b8,0xb2bd,0xcbcc, 0,0xbafc,0xd2b9,0,0,0xc1d9,0,0, /* '匐',0,0,0,0,'匕','化','北', 0,'匙','匚',0,0,'匝',0,0, */
	/* 5320 */ 0xbea2,0xb6a9,0,0xd2ba,0xf9cf,0,0,0, 0,0,0xc8db,0,0,0,0,0xd2bb, /* '匠','匡',0,'匣','匤',0,0,0, 0,0,'匪',0,0,0,0,'匯', */
	/* 5330 */ 0,0xd2bc,0,0xd2bd,0,0,0,0, 0xd2be,0xc9a4,0xb6e8,0xb0e5,0,0,0,0xc6bf, /* 0,'匱',0,'匳',0,0,0,0, '匸','匹','区','医',0,0,0,'匿', */
	/* 5340 */ 0xd2bf,0xbdbd,0,0xc0e9,0,0xd2c1,0xd2c0,0xbea3, 0xb8e1,0xd2c3,0xc8be,0,0,0xd2c4,0,0, /* '區','十',0,'千',0,'卅','卆','升', '午','卉','半',0,0,'卍',0,0, */
	/* 5350 */ 0,0xc8dc,0xc2b4,0xc2ee,0xb6a8,0,0,0xc6ee, 0xc3b1,0,0xc7ee,0,0xcbce,0,0xd2c6,0, /* 0,'卑','卒','卓','協',0,0,'南', '単',0,'博',0,'卜',0,'卞',0, */
	/* 5360 */ 0xc0ea,0,0,0,0,0,0xb7b5,0, 0,0xd2c7,0,0,0,0,0xd2c8,0xb1ac, /* '占',0,0,0,0,0,'卦',0, 0,'卩',0,0,0,0,'卮','卯', */
	/* 5370 */ 0xb0f5,0xb4ed,0xf9d0,0xc2a8,0xb5d1,0xcdf1,0,0xd2cb, 0xb2b7,0,0,0xd2ca,0,0,0,0xb6aa, /* '印','危','卲','即','却','卵',0,'卷', '卸',0,0,'卻',0,0,0,'卿', */
	/* 5380 */ 0,0,0xd2cc,0,0xccf1,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'厂',0,'厄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5390 */ 0,0,0,0xf9d1,0,0,0xd2cd,0, 0xced2,0,0xb8fc,0,0,0,0,0xb8b6, /* 0,0,0,'厓',0,0,'厖',0, '厘',0,'厚',0,0,0,0,'原', */
	/* 53a0 */ 0xd2ce,0,0,0,0,0xd2d0,0xd2cf,0, 0xbfdf,0xb1b9,0,0,0,0xb1de,0xd2d1,0, /* '厠',0,0,0,0,'厥','厦',0, '厨','厩',0,0,0,'厭','厮',0, */
	/* 53b0 */ 0xd2d2,0,0xf9d2,0xb8b7,0,0,0xd2d3,0, 0,0,0,0xb5ee,0,0,0,0, /* '厰',0,'厲','厳',0,0,'厶',0, 0,0,0,'去',0,0,0,0, */
	/* 53c0 */ 0,0,0xbbb2,0xd2d4,0,0,0,0, 0xcbf4,0xbab5,0xb5da,0xcda7,0xc1d0,0xc8bf,0xbcfd,0, /* 0,0,'参','參',0,0,0,0, '又','叉','及','友','双','反','収',0, */
	/* 53d0 */ 0,0,0,0,0xbdc7,0,0xbce8,0xbcf5, 0,0xbdf6,0,0xc8c0,0,0xf9d3,0,0xd2d7, /* 0,0,0,0,'叔',0,'取','受', 0,'叙',0,'叛',0,'叝',0,'叟', */
	/* 53e0 */ 0,0xb1c3,0xc1d1,0xb8fd,0xb8c5,0xb6e7,0,0, 0xd2db,0xc3a1,0xc2fe,0xb6ab,0xbea4,0xd2dc,0xd2da,0xb2c4, /* 0,'叡','叢','口','古','句',0,0, '叨','叩','只','叫','召','叭','叮','可', */
	/* 53f0 */ 0xc2e6,0xbcb8,0xbbcb,0xb1a6,0,0,0xb3f0,0xb9e6, 0xbbca,0,0xd2dd,0,0,0,0,0, /* '台','叱','史','右',0,0,'叶','号', '司',0,'叺',0,0,0,0,0, */
	/* 5400 */ 0,0xd2de,0,0xb5c9,0xb3c6,0,0,0, 0xb9e7,0xb5c8,0xc4df,0xb1a5,0xc6b1,0xccbe,0xb9a1,0xcdf9, /* 0,'吁',0,'吃','各',0,0,0, '合','吉','吊','吋','同','名','后','吏', */
	/* 5410 */ 0xc5c7,0xb8fe,0,0,0,0,0,0, 0,0,0,0xb7af,0,0xd2e7,0,0xb6e3, /* '吐','向',0,0,0,0,0,0, 0,0,0,'君',0,'吝',0,'吟', */
	/* 5420 */ 0xcbca,0,0,0,0,0,0xc8dd,0, 0,0xd2e6,0,0xb4de,0xd2e1,0xd2e2,0xd2e4,0, /* '吠',0,0,0,0,0,'否',0, 0,'吩',0,'含','听','吭','吮',0, */
	/* 5430 */ 0,0,0,0,0,0,0xd2e5,0, 0xb5db,0xbfe1,0,0xcaad,0xd2e3,0xd2df,0xb8e3,0, /* 0,0,0,0,0,0,'吶',0, '吸','吹',0,'吻','吼','吽','吾',0, */
	/* 5440 */ 0xd2e0,0,0xcfa4,0,0,0,0xcaf2,0, 0xc4e8,0xb8e2,0xb9f0,0,0,0,0xd2e8,0, /* '呀',0,'呂',0,0,0,'呆',0, '呈','呉','告',0,0,0,'呎',0, */
	/* 5450 */ 0,0xc6dd,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xd2ec, /* 0,'呑',0,0,0,0,0,0, 0,0,0,0,0,0,0,'呟', */
	/* 5460 */ 0,0,0,0,0,0,0,0, 0xbcfe,0,0xbcf6,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '周',0,'呪',0,0,0,0,0, */
	/* 5470 */ 0xd2ef,0xd2ed,0,0xcca3,0,0xd2ea,0xd2f3,0xd2ee, 0,0,0,0xd2f1,0xb8c6,0xccbf,0,0, /* '呰','呱',0,'味',0,'呵','呶','呷', 0,0,0,'呻','呼','命',0,0, */
	/* 5480 */ 0xd2f2,0,0,0,0xd2f4,0,0xd2f6,0, 0,0,0xf9d6,0xbaf0,0xcfc2,0,0xd2eb,0xd2e9, /* '咀',0,0,0,'咄',0,'咆',0, 0,0,'咊','咋','和',0,'咎','咏', */
	/* 5490 */ 0xd2f5,0,0xd2f0,0,0,0,0,0, 0,0,0,0,0xf9d5,0,0,0, /* '咐',0,'咒',0,0,0,0,0, 0,0,0,0,'咜',0,0,0, */
	/* 54a0 */ 0,0,0xd2f8,0,0xd3a3,0xd2fa,0,0, 0xd2fe,0xf9d7,0,0xd3a1,0xd2fb,0,0,0xd3be, /* 0,0,'咢',0,'咤','咥',0,0, '咨','咩',0,'咫','咬',0,0,'咯', */
	/* 54b0 */ 0,0,0xbae9,0xb3b1,0,0,0,0, 0xd2f9,0,0,0,0xd3a5,0xb0f6,0xd3a4,0, /* 0,0,'咲','咳',0,0,0,0, '咸',0,0,0,'咼','咽','咾',0, */
	/* 54c0 */ 0xb0a5,0xc9ca,0xd3a2,0,0xd2fc,0,0,0xd2f7, 0xd2fd,0xbac8,0,0,0,0,0,0, /* '哀','品','哂',0,'哄',0,0,'哇', '哈','哉',0,0,0,0,0,0, */
	/* 54d0 */ 0,0,0,0,0,0,0,0, 0xd3a6,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '哘',0,0,0,0,0,0,0, */
	/* 54e0 */ 0,0xb0f7,0xd3af,0,0,0xd3a7,0xd3a8,0, 0xbea5,0xcbe9,0,0,0,0xd3ad,0xd3ac,0, /* 0,'員','哢',0,0,'哥','哦',0, '哨','哩',0,0,0,'哭','哮',0, */
	/* 54f0 */ 0,0,0xc5af,0,0,0,0,0, 0,0,0xd3ae,0,0,0xd3ab,0,0xf9d8, /* 0,0,'哲',0,0,0,0,0, 0,0,'哺',0,0,'哽',0,'哿', */
	/* 5500 */ 0,0,0,0,0xb1b4,0,0xbab6,0xbfb0, 0,0,0,0,0,0,0,0xd3a9, /* 0,0,0,0,'唄',0,'唆','唇', 0,0,0,0,0,0,0,'唏', */
	/* 5510 */ 0xc5e2,0,0,0,0xd3aa,0,0xb0a2,0, 0,0,0,0,0,0,0,0, /* '唐',0,0,0,'唔',0,'唖',0, 0,0,0,0,0,0,0,0, */
	/* 5520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xd3b4,0xcda3, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'售','唯', */
	/* 5530 */ 0,0xbea7,0,0xd3ba,0,0,0,0, 0xd3b9,0xd3b0,0,0,0,0,0xc2c3,0, /* 0,'唱',0,'唳',0,0,0,0, '唸','唹',0,0,0,0,'唾',0, */
	/* 5540 */ 0xd3b1,0,0,0,0xc2ef,0xd3b6,0xbea6,0, 0,0,0,0,0xd3b3,0,0,0xcce4, /* '啀',0,0,0,'啄','啅','商',0, 0,0,0,0,'啌',0,0,'問', */
	/* 5550 */ 0,0,0,0xb7bc,0,0,0xd3b7,0xd3b8, 0,0,0,0,0xd3b5,0xd3bb,0,0, /* 0,0,0,'啓',0,0,'啖','啗', 0,0,0,0,'啜','啝',0,0, */
	/* 5560 */ 0,0,0,0xd3b2,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'啣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5570 */ 0,0,0,0,0,0,0,0, 0,0,0,0xd3c1,0xd3c6,0,0xd3c2,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'啻','啼',0,'啾',0, */
	/* 5580 */ 0xd3bd,0,0,0xd3c7,0xc1b1,0,0xf9d9,0xd3c9, 0,0xb9a2,0xd3bf,0xc3fd,0,0,0,0, /* '喀',0,0,'喃','善',0,'喆','喇', 0,'喉','喊','喋',0,0,0,0, */
	/* 5590 */ 0,0,0,0,0,0,0,0, 0xd3c3,0xd3bc,0xb4ad,0,0xb4ee,0xb3e5,0xd3c4,0xd3c0, /* 0,0,0,0,0,0,0,0, '喘','喙','喚',0,'喜','喝','喞','喟', */
	/* 55a0 */ 0,0,0,0,0,0,0,0xb7f6, 0xd3ca,0xd3c8,0xc1d3,0xb5ca,0xb6ac,0,0xd3c5,0, /* 0,0,0,0,0,0,0,'喧', '喨','喩','喪','喫','喬',0,'單',0, */
	/* 55b0 */ 0xb6f4,0,0,0,0,0,0xb1c4,0, 0,0,0,0,0,0,0,0, /* '喰',0,0,0,0,0,'営',0, 0,0,0,0,0,0,0,0, */
	/* 55c0 */ 0,0,0,0,0xd3ce,0xd3cc,0,0xd4a7, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'嗄','嗅',0,'嗇', 0,0,0,0,0,0,0,0, */
	/* 55d0 */ 0,0,0,0,0xd3d1,0,0,0, 0,0,0xd3cb,0,0xd3cf,0,0,0xd3cd, /* 0,0,0,0,'嗔',0,0,0, 0,0,'嗚',0,'嗜',0,0,'嗟', */
	/* 55e0 */ 0,0,0,0xbbcc,0xd3d0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'嗣','嗤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 55f0 */ 0,0,0,0,0,0,0,0xd3d3, 0,0xd3d8,0,0,0,0xd3d6,0xd3d5,0, /* 0,0,0,0,0,0,0,'嗷', 0,'嗹',0,0,0,'嗽','嗾',0, */
	/* 5600 */ 0,0,0,0,0,0,0xc3b2,0, 0,0xb2c5,0,0,0,0,0,0, /* 0,0,0,0,0,0,'嘆',0, 0,'嘉',0,0,0,0,0,0, */
	/* 5610 */ 0,0,0,0,0xd3d2,0,0xd3d4,0xbea8, 0xb1b3,0,0,0xd3d7,0,0,0,0, /* 0,0,0,0,'嘔',0,'嘖','嘗', '嘘',0,0,'嘛',0,0,0,0, */
	/* 5620 */ 0,0,0,0,0,0,0,0, 0,0xb2de,0,0,0,0,0,0xd3e2, /* 0,0,0,0,0,0,0,0, 0,'嘩',0,0,0,0,0,'嘯', */
	/* 5630 */ 0,0xbefc,0xd3de,0,0xd3dc,0,0xd3dd,0, 0xd3df,0,0,0,0,0,0,0, /* 0,'嘱','嘲',0,'嘴',0,'嘶',0, '嘸',0,0,0,0,0,0,0, */
	/* 5640 */ 0,0,0xb1bd,0,0,0,0,0, 0,0,0,0,0xc1b9,0,0xd3d9,0, /* 0,0,'噂',0,0,0,0,0, 0,0,0,0,'噌',0,'噎',0, */
	/* 5650 */ 0xd3da,0,0,0,0,0,0,0, 0,0,0,0xb3fa,0,0,0,0, /* '噐',0,0,0,0,0,0,0, 0,0,0,'噛',0,0,0,0, */
	/* 5660 */ 0,0,0,0,0xd3e1,0,0,0, 0xb4ef,0,0xd3e4,0xd3e0,0xd3e3,0,0,0, /* 0,0,0,0,'噤',0,0,0, '器',0,'噪','噫','噬',0,0,0, */
	/* 5670 */ 0,0,0,0,0xcaae,0,0,0, 0xc6d5,0,0xc8b8,0,0,0,0,0, /* 0,0,0,0,'噴',0,0,0, '噸',0,'噺',0,0,0,0,0, */
	/* 5680 */ 0xd3e6,0,0,0,0,0,0xd3e5,0xb3c5, 0,0,0xd3e7,0,0,0,0,0xd3ea, /* '嚀',0,0,0,0,0,'嚆','嚇', 0,0,'嚊',0,0,0,0,'嚏', */
	/* 5690 */ 0,0,0,0,0xd3e9,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'嚔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 56a0 */ 0xd3e8,0,0xc7b9,0,0,0xd3eb,0,0, 0,0,0,0,0,0,0xd3ec,0, /* '嚠',0,'嚢',0,0,'嚥',0,0, 0,0,0,0,0,0,'嚮',0, */
	/* 56b0 */ 0,0,0,0,0xd3ee,0,0xd3ed,0, 0,0,0,0,0xd3f0,0,0,0, /* 0,0,0,0,'嚴',0,'嚶',0, 0,0,0,0,'嚼',0,0,0, */
	/* 56c0 */ 0xd3f3,0xd3f1,0xd3ef,0xd3f2,0,0,0,0, 0xd3f4,0,0,0,0,0,0xd3f5,0, /* '囀','囁','囂','囃',0,0,0,0, '囈',0,0,0,0,0,'囎',0, */
	/* 56d0 */ 0,0xd3f6,0,0xd3f7,0,0,0,0xd3f8, 0xd1c5,0,0xbcfc,0xbbcd,0,0,0xb2f3,0, /* 0,'囑',0,'囓',0,0,0,'囗', '囘',0,'囚','四',0,0,'回',0, */
	/* 56e0 */ 0xb0f8,0,0,0xc3c4,0,0,0,0, 0,0,0,0,0,0,0xd3f9,0, /* '因',0,0,'団',0,0,0,0, 0,0,0,0,0,0,'囮',0, */
	/* 56f0 */ 0xbaa4,0,0xb0cf,0xbfde,0,0,0,0, 0,0xd3fa,0xb8c7,0,0,0xb9f1,0,0xd3fc, /* '困',0,'囲','図',0,0,0,0, 0,'囹','固',0,0,'国',0,'囿', */
	/* 5700 */ 0xd3fb,0,0,0xcae0,0xd3fd,0,0,0, 0xd4a1,0xd3fe,0,0xd4a2,0,0xd4a3,0,0xb7f7, /* '圀',0,0,'圃','圄',0,0,0, '圈','圉',0,'國',0,'圍',0,'圏', */
	/* 5710 */ 0,0,0xb1e0,0xd4a4,0,0,0xd4a6,0, 0xd4a5,0,0,0,0xd4a8,0,0,0xc5da, /* 0,0,'園','圓',0,0,'圖',0, '團',0,0,0,'圜',0,0,'土', */
	/* 5720 */ 0,0,0,0,0,0,0xd4a9,0xb0b5, 0xbadf,0,0,0,0,0xb7bd,0,0, /* 0,0,0,0,0,0,'圦','圧', '在',0,0,0,0,'圭',0,0, */
	/* 5730 */ 0xc3cf,0,0,0,0,0,0,0xd4aa, 0xd4ab,0,0,0xd4ad,0,0,0,0, /* '地',0,0,0,0,0,0,'圷', '圸',0,0,'圻',0,0,0,0, */
	/* 5740 */ 0xd4ae,0,0xbae4,0,0,0,0,0xb6d1, 0,0,0xcbb7,0,0,0,0xd4ac,0xd4af, /* '址',0,'坂',0,0,0,0,'均', 0,0,'坊',0,0,0,'坎','坏', */
	/* 5750 */ 0xbac1,0xb9a3,0,0,0,0,0,0, 0,0xf9da,0,0,0,0,0,0, /* '坐','坑',0,0,0,0,0,0, 0,'坙',0,0,0,0,0,0, */
	/* 5760 */ 0,0xd4b3,0,0,0xbaa5,0xf9db,0xc3b3,0, 0,0xd4b0,0xc4da,0,0,0,0,0, /* 0,'坡',0,0,'坤','坥','坦',0, 0,'坩','坪',0,0,0,0,0, */
	/* 5770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xd4b4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'坿', */
	/* 5780 */ 0,0,0xbfe2,0,0,0,0,0, 0xd4b2,0xd4b5,0,0xb7bf,0,0,0,0, /* 0,0,'垂',0,0,0,0,0, '垈','垉',0,'型',0,0,0,0, */
	/* 5790 */ 0,0,0,0xd4b6,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'垓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57a0 */ 0xd4b7,0,0xb9a4,0xb3c0,0xd4b9,0,0,0, 0,0,0xd4ba,0,0xf9dc,0,0,0, /* '垠',0,'垢','垣','垤',0,0,0, 0,0,'垪',0,'垬',0,0,0, */
	/* 57b0 */ 0xd4bb,0,0,0xd4b8,0,0,0,0, 0,0,0,0,0,0,0,0, /* '垰',0,0,'垳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57c0 */ 0xd4b1,0,0,0xd4bc,0,0,0xd4bd,0xf9de, 0xf9dd,0,0,0xcbe4,0,0,0xbeeb,0, /* '埀',0,0,'埃',0,0,'埆','埇', '埈',0,0,'埋',0,0,'城',0, */
	/* 57d0 */ 0,0,0xd4bf,0xd4c0,0xd4be,0,0xd4c2,0, 0,0,0,0,0xc7b8,0,0,0xb0e8, /* 0,0,'埒','埓','埔',0,'埖',0, 0,0,0,0,'埜',0,0,'域', */
	/* 57e0 */ 0xc9d6,0,0,0xd4c3,0,0,0,0, 0,0,0,0,0,0,0,0, /* '埠',0,0,'埣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57f0 */ 0,0,0,0,0xbefd,0,0,0xbcb9, 0,0xc7dd,0xb4f0,0,0xbaeb,0,0,0, /* 0,0,0,0,'埴',0,0,'執', 0,'培','基',0,'埼',0,0,0, */
	/* 5800 */ 0xcbd9,0,0xc6b2,0,0,0xb7f8,0xc2cf,0, 0,0,0xd4c1,0xd4c4,0,0,0,0, /* '堀',0,'堂',0,0,'堅','堆',0, 0,0,'堊','堋',0,0,0,0, */
	/* 5810 */ 0,0,0,0,0,0xc2c4,0,0, 0,0xd4c5,0,0,0,0xd4c6,0,0, /* 0,0,0,0,0,'堕',0,0, 0,'堙',0,0,0,'堝',0,0, */
	/* 5820 */ 0,0xd4c8,0,0,0xc4e9,0,0,0, 0,0,0xb4ae,0,0,0,0,0xf4a1, /* 0,'堡',0,0,'堤',0,0,0, 0,0,'堪',0,0,0,0,'堯', */
	/* 5830 */ 0xb1e1,0xcaf3,0,0,0xbeec,0xc5c8,0,0, 0,0,0xbae6,0,0,0xd4ce,0,0, /* '堰','報',0,0,'場','堵',0,0, 0,0,'堺',0,0,'堽',0,0, */
	/* 5840 */ 0xcabd,0xcedd,0,0,0,0,0,0, 0,0,0xb2f4,0xd4ca,0,0,0,0, /* '塀','塁',0,0,0,0,0,0, 0,0,'塊','塋',0,0,0,0, */
	/* 5850 */ 0,0xc1ba,0xd4cd,0,0xc5e3,0,0,0xc5c9, 0xc5e4,0xc8b9,0xc4cd,0,0,0,0xbac9,0, /* 0,'塑','塒',0,'塔',0,0,'塗', '塘','塙','塚',0,0,0,'塞',0, */
	/* 5860 */ 0,0,0xd4c9,0,0,0,0,0, 0,0xb1f6,0,0xc5b6,0,0,0,0, /* 0,0,'塢',0,0,0,0,0, 0,'塩',0,'填',0,0,0,0, */
	/* 5870 */ 0xd4cb,0,0xd4c7,0,0,0xbfd0,0,0, 0,0xd4cf,0,0,0,0,0xbdce,0, /* '塰',0,'塲',0,0,'塵',0,0, 0,'塹',0,0,0,0,'塾',0, */
	/* 5880 */ 0,0,0,0xb6ad,0,0xd4d0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'境',0,'墅',0,0, 0,0,0,0,0,0,0,0, */
	/* 5890 */ 0,0,0,0xcae8,0,0,0,0xc1fd, 0,0,0,0,0xc4c6,0,0xf9e1,0xd4d2, /* 0,0,0,'墓',0,0,0,'増', 0,0,0,0,'墜',0,'增','墟', */
	/* 58a0 */ 0,0,0,0,0,0,0,0, 0xcbcf,0,0,0xd4d3,0,0,0xd4d8,0, /* 0,0,0,0,0,0,0,0, '墨',0,0,'墫',0,0,'墮',0, */
	/* 58b0 */ 0,0,0xf9e2,0xcaaf,0,0,0,0, 0xd4d7,0xd4d1,0xd4d4,0xd4d6,0,0,0xbaa6,0, /* 0,0,'墲','墳',0,0,0,0, '墸','墹','墺','墻',0,0,'墾',0, */
	/* 58c0 */ 0,0xcac9,0,0,0,0xd4d9,0,0xc3c5, 0,0,0xb2f5,0,0xbeed,0,0,0, /* 0,'壁',0,0,0,'壅',0,'壇', 0,0,'壊',0,'壌',0,0,0, */
	/* 58d0 */ 0,0xd4db,0,0xd4da,0,0xb9e8,0,0xd4dc, 0xd4de,0xd4dd,0,0,0xd4e0,0,0xd4d5,0xd4e2, /* 0,'壑',0,'壓',0,'壕',0,'壗', '壘','壙',0,0,'壜',0,'壞','壟', */
	/* 58e0 */ 0,0,0,0,0xd4e1,0xd4df,0,0, 0,0,0,0xbbce,0xbfd1,0,0xc1d4,0xd4e3, /* 0,0,0,0,'壤','壥',0,0, 0,0,0,'士','壬',0,'壮','壯', */
	/* 58f0 */ 0xc0bc,0xb0ed,0xc7e4,0,0,0,0,0xc4db, 0,0xd4e5,0xd4e4,0xd4e6,0xd4e7,0xd4e8,0,0, /* '声','壱','売',0,0,0,0,'壷', 0,'壹','壺','壻','壼','壽',0,0, */
	/* 5900 */ 0,0,0xd4e9,0,0,0,0,0, 0,0xcad1,0xd4ea,0xf9e3,0,0,0,0xb2c6, /* 0,0,'夂',0,0,0,0,0, 0,'変','夊','夋',0,0,0,'夏', */
	/* 5910 */ 0xd4eb,0,0,0,0,0xcdbc,0xb3b0,0, 0xd2c9,0xbdc8,0xc2bf,0xd4ec,0xcceb,0,0,0, /* '夐',0,0,0,0,'夕','外',0, '夘','夙','多','夛','夜',0,0,0, */
	/* 5920 */ 0,0,0xccb4,0,0,0xd4ee,0,0xc2e7, 0,0xc5b7,0xc2c0,0xc9d7,0xd4ef,0xd4f0,0xb1fb,0, /* 0,0,'夢',0,0,'夥',0,'大', 0,'天','太','夫','夬','夭','央',0, */
	/* 5930 */ 0,0xbcba,0xd4f1,0,0,0,0,0xb0d0, 0xd4f2,0,0,0,0,0,0xd4f3,0, /* 0,'失','夲',0,0,0,0,'夷', '夸',0,0,0,0,0,'夾',0, */
	/* 5940 */ 0,0,0,0,0xb1e2,0,0,0xb4f1, 0xc6e0,0xcaf4,0,0,0,0,0xd4f7,0xc1d5, /* 0,0,0,0,'奄',0,0,'奇', '奈','奉',0,0,0,0,'奎','奏', */
	/* 5950 */ 0xd4f6,0xb7c0,0,0xf9e4,0xcbdb,0xd4f5,0,0xc5e5, 0xd4f9,0,0xd4f8,0xf9e5,0,0xf9e6,0,0, /* '奐','契',0,'奓','奔','奕',0,'套', '奘',0,'奚','奛',0,'奝',0,0, */
	/* 5960 */ 0xd4fb,0,0xd4fa,0xf9e7,0,0xb1fc,0,0xd4fc, 0xbea9,0xd4fe,0xc3a5,0,0xd4fd,0,0xcab3,0, /* '奠',0,'奢','奣',0,'奥',0,'奧', '奨','奩','奪',0,'奬',0,'奮',0, */
	/* 5970 */ 0,0,0,0xbdf7,0xc5db,0,0,0, 0xd5a1,0,0,0,0,0xb9a5,0,0, /* 0,0,0,'女','奴',0,0,0, '奸',0,0,0,0,'好',0,0, */
	/* 5980 */ 0,0xd5a2,0xc7a1,0xc8de,0xccd1,0,0,0, 0,0,0xc7a5,0,0,0xd5ab,0,0, /* 0,'妁','如','妃','妄',0,0,0, 0,0,'妊',0,0,'妍',0,0, */
	/* 5990 */ 0,0,0,0xb5b8,0,0,0xcdc5,0, 0,0xccaf,0,0xd6ac,0,0xd5a3,0,0, /* 0,0,0,'妓',0,0,'妖',0, 0,'妙',0,'妛',0,'妝',0,0, */
	/* 59a0 */ 0,0,0,0xd5a6,0xf9e8,0xc2c5,0,0, 0xcbb8,0,0,0,0xc5ca,0,0,0, /* 0,0,0,'妣','妤','妥',0,0, '妨',0,0,0,'妬',0,0,0, */
	/* 59b0 */ 0,0,0xd5a7,0,0,0,0,0, 0,0xcbe5,0xf9e9,0xbaca,0,0,0xbeaa,0, /* 0,0,'妲',0,0,0,0,0, 0,'妹','妺','妻',0,0,'妾',0, */
	/* 59c0 */ 0,0,0,0,0,0,0xd5a8,0, 0,0xbbd0,0,0xbbcf,0,0,0,0, /* 0,0,0,0,0,0,'姆',0, 0,'姉',0,'始',0,0,0,0, */
	/* 59d0 */ 0xb0b9,0xb8c8,0,0xc0ab,0xb0d1,0,0,0, 0,0xd5ac,0xd5ad,0,0xd5aa,0,0,0, /* '姐','姑',0,'姓','委',0,0,0, 0,'姙','姚',0,'姜',0,0,0, */
	/* 59e0 */ 0,0,0,0,0,0xb1b8,0xb4af,0, 0xd5a9,0,0xccc5,0xc9b1,0,0,0,0, /* 0,0,0,0,0,'姥','姦',0, '姨',0,'姪','姫',0,0,0,0, */
	/* 59f0 */ 0,0,0,0,0,0,0xb0a8,0, 0,0,0,0xb0f9,0,0,0,0xbbd1, /* 0,0,0,0,0,0,'姶',0, 0,0,0,'姻',0,0,0,'姿', */
	/* 5a00 */ 0,0xb0d2,0,0xb0a3,0,0,0,0, 0,0xd5b2,0,0,0,0,0,0, /* 0,'威',0,'娃',0,0,0,0, 0,'娉',0,0,0,0,0,0, */
	/* 5a10 */ 0,0xd5b0,0,0,0,0,0,0, 0xccbc,0,0xd5b3,0,0xd5b1,0,0,0xd5af, /* 0,'娑',0,0,0,0,0,0, '娘',0,'娚',0,'娜',0,0,'娟', */
	/* 5a20 */ 0xbfb1,0,0,0,0,0xd5ae,0,0, 0,0xcada,0,0,0,0,0,0xb8e4, /* '娠',0,0,0,0,'娥',0,0, 0,'娩',0,0,0,0,0,'娯', */
	/* 5a30 */ 0,0,0,0,0,0xd5b7,0xd5b8,0, 0,0,0,0,0xbeab,0,0,0, /* 0,0,0,0,0,'娵','娶',0, 0,0,0,0,'娼',0,0,0, */
	/* 5a40 */ 0xd5b4,0xcfac,0,0,0,0,0xc7cc,0, 0,0xd5b6,0,0,0,0,0,0, /* '婀','婁',0,0,0,0,'婆',0, 0,'婉',0,0,0,0,0,0, */
	/* 5a50 */ 0,0,0,0,0,0,0,0, 0,0,0xbaa7,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'婚',0,0,0,0,0, */
	/* 5a60 */ 0,0,0xd5b9,0,0,0,0xc9d8,0, 0,0,0xd5ba,0,0xd5b5,0,0,0, /* 0,0,'婢',0,0,0,'婦',0, 0,0,'婪',0,'婬',0,0,0, */
	/* 5a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xccbb, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'婿', */
	/* 5a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a90 */ 0,0,0xc7de,0,0,0,0,0, 0,0,0xd5bb,0xc9b2,0,0,0,0, /* 0,0,'媒',0,0,0,0,0, 0,0,'媚','媛',0,0,0,0, */
	/* 5aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xd5bc,0xd5c0,0xd5bd,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'媼','媽','媾',0, */
	/* 5ac0 */ 0,0xb2c7,0xd5bf,0,0,0,0,0, 0,0xbcbb,0,0xd5be,0xb7f9,0,0,0, /* 0,'嫁','嫂',0,0,0,0,0, 0,'嫉',0,'嫋','嫌',0,0,0, */
	/* 5ad0 */ 0xd5cc,0,0,0,0,0,0xd5c5,0xd5c2, 0,0,0,0,0,0,0,0, /* '嫐',0,0,0,0,0,'嫖','嫗', 0,0,0,0,0,0,0,0, */
	/* 5ae0 */ 0,0xc3e4,0,0xd5c1,0,0,0xd5c3,0, 0,0xd5c4,0,0,0,0,0,0, /* 0,'嫡',0,'嫣',0,0,'嫦',0, 0,'嫩',0,0,0,0,0,0, */
	/* 5af0 */ 0,0,0,0,0,0,0,0, 0,0,0xd5c6,0xd5c7,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'嫺','嫻',0,0,0,0, */
	/* 5b00 */ 0,0,0,0,0,0,0,0, 0,0xb4f2,0,0xd5c9,0xd5c8,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'嬉',0,'嬋','嬌',0,0,0, */
	/* 5b10 */ 0,0,0,0,0,0,0xd5ca,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'嬖',0, 0,0,0,0,0,0,0,0, */
	/* 5b20 */ 0,0,0xbeee,0,0,0,0,0, 0,0,0xd5cd,0,0xc4dc,0,0,0, /* 0,0,'嬢',0,0,0,0,0, 0,0,'嬪',0,'嬬',0,0,0, */
	/* 5b30 */ 0xb1c5,0,0xd5cb,0,0,0,0xd5ce,0, 0,0,0,0,0,0,0xd5cf,0, /* '嬰',0,'嬲',0,0,0,'嬶',0, 0,0,0,0,0,0,'嬾',0, */
	/* 5b40 */ 0xd5d2,0,0,0xd5d0,0,0xd5d1,0,0, 0,0,0,0,0,0,0,0, /* '孀',0,0,'孃',0,'孅',0,0, 0,0,0,0,0,0,0,0, */
	/* 5b50 */ 0xbbd2,0xd5d3,0,0,0xb9a6,0xd5d4,0xf9ea,0xbbfa, 0xc2b8,0,0xd5d5,0xd5d6,0xbbda,0xb9a7,0,0xccd2, /* '子','孑',0,0,'孔','孕','孖','字', '存',0,'孚','孛','孜','孝',0,'孟', */
	/* 5b60 */ 0,0,0,0xb5a8,0xb8c9,0xd5d7,0xb3d8,0, 0,0xd5d8,0,0xc2b9,0,0,0,0, /* 0,0,0,'季','孤','孥','学',0, 0,'孩',0,'孫',0,0,0,0, */
	/* 5b70 */ 0xd5d9,0xd6a3,0,0xd5da,0,0xd5db,0,0, 0xd5dc,0,0xd5de,0,0,0,0,0, /* '孰','孱',0,'孳',0,'孵',0,0, '學',0,'孺',0,0,0,0,0, */
	/* 5b80 */ 0xd5df,0,0,0xd5e0,0,0xc2f0,0,0xb1a7, 0xbce9,0xb0c2,0,0xc1d7,0xb4b0,0xbcb5,0,0xb9a8, /* '宀',0,0,'它',0,'宅',0,'宇', '守','安',0,'宋','完','宍',0,'宏', */
	/* 5b90 */ 0,0,0,0,0,0xc5e6,0,0xbda1, 0xb4b1,0xc3e8,0xc4ea,0xb0b8,0xb5b9,0xcaf5,0,0xbcc2, /* 0,0,0,0,0,'宕',0,'宗', '官','宙','定','宛','宜','宝',0,'実', */
	/* 5ba0 */ 0,0,0xb5d2,0xc0eb,0xbcbc,0xcda8,0xd5e1,0, 0,0,0,0,0,0,0xb5dc,0, /* 0,0,'客','宣','室','宥','宦',0, 0,0,0,0,0,0,'宮',0, */
	/* 5bb0 */ 0xbacb,0,0,0xb3b2,0xb1e3,0xbeac,0xb2c8,0, 0xd5e2,0xcdc6,0,0,0,0,0,0xbdc9, /* '宰',0,0,'害','宴','宵','家',0, '宸','容',0,0,0,0,0,'宿', */
	/* 5bc0 */ 0xf9eb,0,0xbce4,0xd5e3,0xb4f3,0xc6d2,0xcca9,0xd5e4, 0,0xd5e5,0,0,0xc9d9,0,0,0, /* '寀',0,'寂','寃','寄','寅','密','寇', 0,'寉',0,0,'富',0,0,0, */
	/* 5bd0 */ 0xd5e7,0,0xb4a8,0xb6f7,0xd5e6,0,0,0, 0xf9ed,0,0,0xb4b2,0,0xbfb2,0xd5eb,0xbba1, /* '寐',0,'寒','寓','寔',0,0,0, '寘',0,0,'寛',0,'寝','寞','察', */
	/* 5be0 */ 0,0xb2c9,0xd5ea,0,0xd5e8,0xd5ec,0xd5e9,0xc7ab, 0xdccd,0xbfb3,0,0xd5ed,0xf9ee,0,0xcec0,0, /* 0,'寡','寢',0,'寤','寥','實','寧', '寨','審',0,'寫','寬',0,'寮',0, */
	/* 5bf0 */ 0xd5ee,0,0,0xd5f0,0,0xc3fe,0xd5ef,0, 0xc0a3,0,0xbbfb,0,0,0,0xc2d0,0xbcf7, /* '寰',0,0,'寳',0,'寵','寶',0, '寸',0,'寺',0,0,0,'対','寿', */
	/* 5c00 */ 0,0xc9f5,0xc0ec,0,0xbccd,0xd5f1,0xbead,0xd5f2, 0xd5f3,0xb0d3,0xc2ba,0xbfd2,0,0xd5f4,0xc6b3,0xbeae, /* 0,'封','専',0,'射','尅','将','將', '專','尉','尊','尋',0,'對','導','小', */
	/* 5c10 */ 0,0xbeaf,0,0xd5f5,0,0,0xc0ed,0, 0,0,0xbeb0,0,0,0,0xf9ef,0, /* 0,'少',0,'尓',0,0,'尖',0, 0,0,'尚',0,0,0,'尞',0, */
	/* 5c20 */ 0xd5f6,0,0xd5f7,0,0xcce0,0,0,0, 0xd5f8,0,0,0,0,0xb6c6,0,0, /* '尠',0,'尢',0,'尤',0,0,0, '尨',0,0,0,0,'尭',0,0, */
	/* 5c30 */ 0,0xbda2,0,0,0,0,0,0, 0xd5f9,0xd5fa,0xbcdc,0xbfac,0xc6f4,0xbfd4,0xc8f8,0xc7a2, /* 0,'就',0,0,0,0,0,0, '尸','尹','尺','尻','尼','尽','尾','尿', */
	/* 5c40 */ 0xb6c9,0xd5fb,0,0,0,0xb5ef,0xd5fc,0, 0xb6fe,0,0xc6cf,0xb2b0,0,0xbbd3,0xd5fd,0xd6a2, /* '局','屁',0,0,0,'居','屆',0, '屈',0,'届','屋',0,'屍','屎','屏', */
	/* 5c50 */ 0xd6a1,0xb6fd,0,0xd5fe,0,0xc5b8,0,0, 0,0,0,0,0,0,0xc2b0,0, /* '屐','屑',0,'屓',0,'展',0,0, 0,0,0,0,0,0,'属',0, */
	/* 5c60 */ 0xc5cb,0xbcc8,0,0,0xc1d8,0xcdfa,0,0, 0,0,0,0,0xd6a4,0,0xd6a5,0xc6d6, /* '屠','屡',0,0,'層','履',0,0, 0,0,0,0,'屬',0,'屮','屯', */
	/* 5c70 */ 0,0xbbb3,0,0,0,0,0xd6a7,0, 0,0xd6a8,0,0,0,0,0,0, /* 0,'山',0,0,0,0,'屶',0, 0,'屹',0,0,0,0,0,0, */
	/* 5c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xd6a9,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'岌',0,0,0, */
	/* 5c90 */ 0xb4f4,0xd6aa,0,0,0xd6ab,0,0,0, 0,0,0,0,0,0,0,0, /* '岐','岑',0,0,'岔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5ca0 */ 0,0xb2ac,0,0,0,0,0xf9f0,0, 0xc1bb,0xb4e4,0,0xd6ad,0xcca8,0,0,0, /* 0,'岡',0,0,0,0,'岦',0, '岨','岩',0,'岫','岬',0,0,0, */
	/* 5cb0 */ 0,0xc2d2,0,0xb3d9,0,0,0xd6af,0xd6b1, 0xb4df,0,0xf9f1,0xd6ae,0xd6b0,0,0xd6b3,0, /* 0,'岱',0,'岳',0,0,'岶','岷', '岸',0,'岺','岻','岼',0,'岾',0, */
	/* 5cc0 */ 0,0,0,0,0,0xd6b2,0,0xd6b4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'峅',0,'峇', 0,0,0,0,0,0,0,0, */
	/* 5cd0 */ 0,0,0,0,0,0,0,0, 0,0xd6b5,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'峙',0,0,0,0,0,0, */
	/* 5ce0 */ 0xc6bd,0xb6ae,0,0,0,0,0,0, 0xb2e5,0xd6b6,0xd6bb,0,0,0xd6b9,0,0xcaf7, /* '峠','峡',0,0,0,0,0,0, '峨','峩','峪',0,0,'峭',0,'峯', */
	/* 5cf0 */ 0xcaf6,0,0,0,0,0xf9f2,0xc5e7,0, 0,0,0xd6b8,0xbdd4,0,0xd6b7,0,0, /* '峰',0,0,0,0,'峵','島',0, 0,0,'峺','峻',0,'峽',0,0, */
	/* 5d00 */ 0,0,0,0,0,0,0,0xbff2, 0,0,0,0xd6bc,0,0,0xbaea,0, /* 0,0,0,0,0,0,0,'崇', 0,0,0,'崋',0,0,'崎',0, */
	/* 5d10 */ 0,0xd6c2,0,0,0xd6c3,0xd6bd,0xb3b3,0xd6be, 0xd6c7,0xd6c6,0xd6c5,0xd6c1,0,0,0,0xd6c0, /* 0,'崑',0,0,'崔','崕','崖','崗', '崘','崙','崚','崛',0,0,0,'崟', */
	/* 5d20 */ 0,0,0xd6c4,0,0,0,0,0xf9f3, 0,0xcaf8,0,0,0,0,0,0, /* 0,0,'崢',0,0,0,0,'崧', 0,'崩',0,0,0,0,0,0, */
	/* 5d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d40 */ 0,0,0xf9f6,0,0,0,0,0, 0,0,0,0xd6cb,0xd6c8,0,0xd6ca,0, /* 0,0,'嵂',0,0,0,0,0, 0,0,0,'嵋','嵌',0,'嵎',0, */
	/* 5d50 */ 0xcdf2,0,0xd6c9,0xf9f4,0,0,0,0, 0,0,0,0,0xd6bf,0,0,0, /* '嵐',0,'嵒','嵓',0,0,0,0, 0,0,0,0,'嵜',0,0,0, */
	/* 5d60 */ 0,0,0,0,0,0,0,0, 0,0xbff3,0,0,0xd6cc,0xf9f7,0,0xbab7, /* 0,0,0,0,0,0,0,0, 0,'嵩',0,0,'嵬','嵭',0,'嵯', */
	/* 5d70 */ 0,0,0,0xd6cd,0,0,0xd6ce,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'嵳',0,0,'嵶',0, 0,0,0,0,0,0,0,0, */
	/* 5d80 */ 0,0,0xd6d1,0,0xd6d0,0,0,0xd6cf, 0,0,0,0xc5e8,0xd6ba,0,0,0, /* 0,0,'嶂',0,'嶄',0,0,'嶇', 0,0,0,'嶋','嶌',0,0,0, */
	/* 5d90 */ 0xd6d7,0,0,0,0,0,0,0, 0,0,0,0,0,0xd6d3,0,0, /* '嶐',0,0,0,0,0,0,0, 0,0,0,0,0,'嶝',0,0, */
	/* 5da0 */ 0,0,0xd6d2,0,0,0,0,0, 0,0,0,0,0xd6d4,0,0xd6d5,0, /* 0,0,'嶢',0,0,0,0,0, 0,0,0,0,'嶬',0,'嶮',0, */
	/* 5db0 */ 0,0,0,0,0,0,0,0xd6d8, 0xf9f8,0xf9f9,0xcee6,0,0xd6d9,0xd6d6,0,0, /* 0,0,0,0,0,0,0,'嶷', '嶸','嶹','嶺',0,'嶼','嶽',0,0, */
	/* 5dc0 */ 0,0,0,0,0,0,0,0, 0,0xd6da,0,0,0xb4e0,0xd6db,0,0, /* 0,0,0,0,0,0,0,0, 0,'巉',0,0,'巌','巍',0,0, */
	/* 5dd0 */ 0xf9fa,0,0xd6dd,0xd6dc,0,0,0xd6de,0, 0,0,0,0xd6df,0,0xc0ee,0xbda3,0, /* '巐',0,'巒','巓',0,0,'巖',0, 0,0,0,'巛',0,'川','州',0, */
	/* 5de0 */ 0,0xbde4,0,0xc1e3,0,0xb9a9,0xbab8,0xb9aa, 0xb5f0,0,0,0xd6e0,0,0,0xbab9,0, /* 0,'巡',0,'巣',0,'工','左','巧', '巨',0,0,'巫',0,0,'差',0, */
	/* 5df0 */ 0,0xb8ca,0xd6e1,0xcca6,0xc7c3,0xd6e2,0,0xb9ab, 0,0,0,0xb4ac,0,0xc3a7,0xb6d2,0, /* 0,'己','已','巳','巴','巵',0,'巷', 0,0,0,'巻',0,'巽','巾',0, */
	/* 5e00 */ 0,0,0xbbd4,0xc9db,0,0,0xc8c1,0, 0,0,0,0xd6e3,0xb4f5,0,0,0, /* 0,0,'市','布',0,0,'帆',0, 0,0,0,'帋','希',0,0,0, */
	/* 5e10 */ 0,0xd6e6,0,0,0,0,0xc4a1,0, 0,0xd6e5,0xd6e4,0xd6e7,0,0xc4eb,0,0, /* 0,'帑',0,0,0,0,'帖',0, 0,'帙','帚','帛',0,'帝',0,0, */
	/* 5e20 */ 0,0,0,0,0,0xbfe3,0,0, 0,0,0,0xbbd5,0,0xc0ca,0,0xc2d3, /* 0,0,0,0,0,'帥',0,0, 0,0,0,'師',0,'席',0,'帯', */
	/* 5e30 */ 0xb5a2,0,0,0xc4a2,0,0,0xd6e8,0xd6e9, 0xbeef,0,0,0,0,0xcbb9,0,0, /* '帰',0,0,'帳',0,0,'帶','帷', '常',0,0,0,0,'帽',0,0, */
	/* 5e40 */ 0xd6ec,0,0,0xd6eb,0xd6ea,0xc9fd,0,0xd6f3, 0,0,0,0,0xcbda,0,0xd6ed,0, /* '幀',0,0,'幃','幄','幅',0,'幇', 0,0,0,0,'幌',0,'幎',0, */
	/* 5e50 */ 0,0,0,0,0xd6ef,0xcbeb,0,0xd6ee, 0,0,0,0,0,0,0,0xd6f0, /* 0,0,0,0,'幔','幕',0,'幗', 0,0,0,0,0,0,0,'幟', */
	/* 5e60 */ 0,0xc8a8,0xd6f1,0xcabe,0xd6f2,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'幡','幢','幣','幤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5e70 */ 0,0,0xb4b3,0xcabf,0xc7af,0xd6f4,0xd6f5,0, 0xb9ac,0xb4b4,0xd6f6,0xb8b8,0xcdc4,0xcda9,0xb4f6,0xd6f8, /* 0,0,'干','平','年','幵','并',0, '幸','幹','幺','幻','幼','幽','幾','广', */
	/* 5e80 */ 0,0xc4a3,0,0xb9ad,0xbeb1,0,0,0xc8df, 0,0,0xbeb2,0,0,0,0,0xbdf8, /* 0,'庁',0,'広','庄',0,0,'庇', 0,0,'床',0,0,0,0,'序', */
	/* 5e90 */ 0,0,0,0,0,0xc4ec,0xcaf9,0xc5b9, 0,0,0xb9ae,0,0xc9dc,0,0,0, /* 0,0,0,0,0,'底','庖','店', 0,0,'庚',0,'府',0,0,0, */
	/* 5ea0 */ 0xd6f9,0,0,0,0,0,0xc5d9,0xbac2, 0,0,0,0xb8cb,0,0xc4ed,0,0, /* '庠',0,0,0,0,0,'度','座', 0,0,0,'庫',0,'庭',0,0, */
	/* 5eb0 */ 0,0,0,0,0,0xb0c3,0xbdee,0xb9af, 0xcdc7,0,0,0,0,0,0,0, /* 0,0,0,0,0,'庵','庶','康', '庸',0,0,0,0,0,0,0, */
	/* 5ec0 */ 0,0xd6fa,0xd6fb,0xc7d1,0,0,0,0, 0xd6fc,0xcef7,0xcfad,0,0,0,0,0xd6fe, /* 0,'廁','廂','廃',0,0,0,0, '廈','廉','廊',0,0,0,0,'廏', */
	/* 5ed0 */ 0xd6fd,0,0,0xb3c7,0,0,0xd7a1,0, 0,0,0xd7a4,0xd7a5,0,0xd7a3,0,0xc9c0, /* '廐',0,0,'廓',0,0,'廖',0, 0,0,'廚','廛',0,'廝',0,'廟', */
	/* 5ee0 */ 0xbeb3,0xd7a7,0xd7a6,0xd7a2,0,0,0,0, 0xd7a8,0xd7a9,0,0,0xd7aa,0,0,0, /* '廠','廡','廢','廣',0,0,0,0, '廨','廩',0,0,'廬',0,0,0, */
	/* 5ef0 */ 0xd7ad,0xd7ab,0,0xd7ac,0xd7ae,0,0xb1e4,0xc4ee, 0xd7af,0,0xb7fa,0xb2f6,0xc7b6,0,0xd7b0,0xc6fb, /* '廰','廱',0,'廳','廴',0,'延','廷', '廸',0,'建','廻','廼',0,'廾','廿', */
	/* 5f00 */ 0,0xcadb,0,0xd7b1,0xcfae,0,0,0, 0,0xd7b2,0xcac0,0xd7b5,0xd0a1,0xd0b1,0,0xbcb0, /* 0,'弁',0,'弃','弄',0,0,0, 0,'弉','弊','弋','弌','弍',0,'式', */
	/* 5f10 */ 0xc6f5,0xd7b6,0,0xb5dd,0xc4a4,0xb0fa,0xd7b7,0xcaa6, 0xb9b0,0,0,0xc3d0,0,0,0,0xc4ef, /* '弐','弑',0,'弓','弔','引','弖','弗', '弘',0,0,'弛',0,0,0,'弟', */
	/* 5f20 */ 0,0xf9fb,0,0,0,0xccef,0xb8b9,0xb8cc, 0,0xd7b8,0,0,0,0xd7b9,0,0xd7bf, /* 0,'弡',0,0,0,'弥','弦','弧', 0,'弩',0,0,0,'弭',0,'弯', */
	/* 5f30 */ 0,0xbce5,0,0,0xf9fc,0xc4a5,0,0xb6af, 0xd7ba,0,0,0,0xc9ab,0,0xc3c6,0, /* 0,'弱',0,0,'弴','張',0,'強', '弸',0,0,0,'弼',0,'弾',0, */
	/* 5f40 */ 0,0xd7bb,0,0,0,0xf9ac,0,0, 0xd7bc,0,0xb6b0,0,0xd7bd,0,0xd7be,0, /* 0,'彁',0,0,0,'彅',0,0, '彈',0,'彊',0,'彌',0,'彎',0, */
	/* 5f50 */ 0,0xd7c0,0,0xc5f6,0,0,0xd7c1,0xd7c2, 0,0xd7c3,0,0,0xd7b4,0xd7b3,0,0, /* 0,'彑',0,'当',0,0,'彖','彗', 0,'彙',0,0,'彜','彝',0,0, */
	/* 5f60 */ 0,0xd7c4,0xb7c1,0,0,0,0xc9a7,0xf9fd, 0,0xbacc,0xc9b7,0xc4a6,0xc9cb,0xd7c5,0,0, /* 0,'彡','形',0,0,0,'彦','彧', 0,'彩','彪','彫','彬','彭',0,0, */
	/* 5f70 */ 0xbeb4,0xb1c6,0,0xd7c6,0,0,0,0xd7c7, 0,0xccf2,0,0,0xc8e0,0,0,0xd7ca, /* '彰','影',0,'彳',0,0,0,'彷', 0,'役',0,0,'彼',0,0,'彿', */
	/* 5f80 */ 0xb1fd,0xc0ac,0xd7c9,0xd7c8,0xb7c2,0xc2d4,0,0xd7ce, 0xd7cc,0,0xd7cb,0xcea7,0xb8e5,0,0,0, /* '往','征','徂','徃','径','待',0,'徇', '很',0,'徊','律','後',0,0,0, */
	/* 5f90 */ 0xbdf9,0xd7cd,0xc5cc,0xbdbe,0,0,0,0xc6c0, 0xd7d1,0xd7d0,0,0,0,0,0xd7cf,0, /* '徐','徑','徒','従',0,0,0,'得', '徘','徙',0,0,0,0,'從',0, */
	/* 5fa0 */ 0xd7d2,0xb8e6,0,0,0,0,0,0, 0xd7d3,0xc9fc,0xbddb,0,0,0xd7d4,0xc8f9,0, /* '徠','御',0,0,0,0,0,0, '徨','復','循',0,0,'徭','微',0, */
	/* 5fb0 */ 0,0,0,0xc6c1,0xc4a7,0,0,0xf9fe, 0,0xc5b0,0,0,0xd7d5,0xb5ab,0,0, /* 0,0,0,'徳','徴',0,0,'德', 0,'徹',0,0,'徼','徽',0,0, */
	/* 5fc0 */ 0,0,0,0xbfb4,0,0xc9ac,0,0, 0,0,0,0,0xb4f7,0xc7a6,0,0, /* 0,0,0,'心',0,'必',0,0, 0,0,0,0,'忌','忍',0,0, */
	/* 5fd0 */ 0,0,0,0,0,0,0xd7d6,0xbbd6, 0xcbba,0xcbbb,0,0,0xb1fe,0xd7db,0xfaa1,0, /* 0,0,0,0,0,0,'忖','志', '忘','忙',0,0,'応','忝','忞',0, */
	/* 5fe0 */ 0xc3e9,0,0,0,0xd7d8,0,0,0, 0,0,0,0xb2f7,0,0,0,0, /* '忠',0,0,0,'忤',0,0,0, 0,0,0,'快',0,0,0,0, */
	/* 5ff0 */ 0xd8ad,0xd7da,0,0,0,0xc7b0,0,0, 0xd7d9,0,0,0xd7d7,0,0xb9fa,0,0xd7dd, /* '忰','忱',0,0,0,'念',0,0, '忸',0,0,'忻',0,'忽',0,'忿', */
	/* 6000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xd7e3,0xd7e9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'怎','怏', */
	/* 6010 */ 0xd7e1,0,0xc5dc,0,0,0xd7e6,0xc9dd,0, 0,0xd7e0,0,0xd7e5,0xcee7,0xbbd7,0,0, /* '怐',0,'怒',0,0,'怕','怖',0, 0,'怙',0,'怛','怜','思',0,0, */
	/* 6020 */ 0xc2d5,0xd7de,0,0,0,0xb5de,0xd7e8,0xc0ad, 0xb1e5,0xd7e2,0xb2f8,0xd7e7,0,0,0,0xb6b1, /* '怠','怡',0,0,0,'急','怦','性', '怨','怩','怪','怫',0,0,0,'怯', */
	/* 6030 */ 0,0xd7e4,0,0,0,0,0,0, 0,0,0xd7ea,0,0,0,0,0, /* 0,'怱',0,0,0,0,0,0, 0,0,'怺',0,0,0,0,0, */
	/* 6040 */ 0,0xd7ec,0xd7f6,0xd7f4,0,0,0xd7f1,0, 0,0,0xd7f0,0xcef8,0,0xd7f2,0,0, /* 0,'恁','恂','恃',0,0,'恆',0, 0,0,'恊','恋',0,'恍',0,0, */
	/* 6050 */ 0xb6b2,0,0xb9b1,0,0,0xbdfa,0,0, 0,0xd7f9,0xd7eb,0,0,0xfaa2,0,0xd7ef, /* '恐',0,'恒',0,0,'恕',0,0, 0,'恙','恚',0,0,'恝',0,'恟', */
	/* 6060 */ 0xd7df,0,0xb2fa,0xd7f3,0xd7f5,0xc3d1,0,0, 0xbaa8,0xb2b8,0xd7ed,0xd7f8,0xd7f7,0xb6b3,0,0xc2a9, /* '恠',0,'恢','恣','恤','恥',0,0, '恨','恩','恪','恫','恬','恭',0,'息', */
	/* 6070 */ 0xb3e6,0,0,0,0,0xb7c3,0,0xd7ee, 0,0,0,0,0,0,0,0, /* '恰',0,0,0,0,'恵',0,'恷', 0,0,0,0,0,0,0,0, */
	/* 6080 */ 0,0xd7fa,0,0xd7fd,0xd8a1,0xfaa3,0,0, 0,0xbcbd,0xfaa4,0xd8a7,0xc4f0,0xd7fb,0,0, /* 0,'悁',0,'悃','悄','悅',0,0, 0,'悉','悊','悋','悌','悍',0,0, */
	/* 6090 */ 0,0,0xd8a5,0,0xb2f9,0,0xd8a3,0xd8a4, 0,0,0xd7fe,0xd8a2,0,0,0,0xb8e7, /* 0,0,'悒',0,'悔',0,'悖','悗', 0,0,'悚','悛',0,0,0,'悟', */
	/* 60a0 */ 0xcdaa,0,0,0xb4b5,0,0,0xb1d9,0xd8a6, 0,0xc7ba,0xb0ad,0,0,0,0,0, /* '悠',0,0,'患',0,0,'悦','悧', 0,'悩','悪',0,0,0,0,0, */
	/* 60b0 */ 0,0,0xc8e1,0xd7dc,0xd8ac,0xd8b0,0xcce5,0, 0xd8a9,0,0,0,0xc5e9,0xd8ae,0,0, /* 0,0,'悲','悳','悴','悵','悶',0, '悸',0,0,0,'悼','悽',0,0, */
	/* 60c0 */ 0,0,0,0,0,0xbef0,0xd8af,0xc6d7, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'情','惆','惇', 0,0,0,0,0,0,0,0, */
	/* 60d0 */ 0,0xcfc7,0,0xd8ab,0,0xfaa6,0,0, 0xd8b1,0,0xb9fb,0,0xc0cb,0,0xfaa5,0xb0d4, /* 0,'惑',0,'惓',0,'惕',0,0, '惘',0,'惚',0,'惜',0,'惞','惟', */
	/* 60e0 */ 0xd8aa,0xd8a8,0,0xc1da,0,0,0,0xd7fc, 0xbbb4,0,0,0,0,0,0,0, /* '惠','惡',0,'惣',0,0,0,'惧', '惨',0,0,0,0,0,0,0, */
	/* 60f0 */ 0xc2c6,0xd8bd,0xfaa8,0xc1db,0xd8b8,0,0xd8b5,0xd8b6, 0,0xbce6,0xd8b9,0xd8bc,0,0,0,0, /* '惰','惱','惲','想','惴',0,'惶','惷', 0,'惹','惺','惻',0,0,0,0, */
	/* 6100 */ 0xd8b7,0xbda5,0,0xd8ba,0,0,0xd8b4,0, 0xccfc,0xccfb,0,0,0,0xd8be,0xd8bf,0xb0d5, /* '愀','愁',0,'愃',0,0,'愆',0, '愈','愉',0,0,0,'愍','愎','意', */
	/* 6110 */ 0,0xfaa9,0,0,0,0xd8b3,0,0, 0,0,0xb6f2,0xb0a6,0,0,0,0xb4b6, /* 0,'愑',0,0,0,'愕',0,0, 0,0,'愚','愛',0,0,0,'感', */
	/* 6120 */ 0xfaa7,0xd8bb,0,0,0,0,0,0xd8c3, 0xd8c2,0,0,0,0xd8c7,0,0,0, /* '愠','愡',0,0,0,0,0,'愧', '愨',0,0,0,'愬',0,0,0, */
	/* 6130 */ 0xfaab,0,0,0,0xd8c8,0,0,0xfaaa, 0,0,0,0,0xd8c6,0xd8c9,0xd8c1,0xd8c5, /* '愰',0,0,0,'愴',0,0,'愷', 0,0,0,0,'愼','愽','愾','愿', */
	/* 6140 */ 0,0,0xd8ca,0,0xd8cb,0,0,0xd8c0, 0xbbfc,0,0xd8c4,0xc2d6,0xb9b2,0xd8b2,0xbfb5,0, /* 0,0,'慂',0,'慄',0,0,'慇', '慈',0,'慊','態','慌','慍','慎',0, */
	/* 6150 */ 0,0,0,0xd8d8,0,0xcae9,0,0, 0xd8ce,0xd8cf,0xd8d0,0,0,0xd8d7,0,0xd8d6, /* 0,0,0,'慓',0,'慕',0,0, '慘','慙','慚',0,0,'慝',0,'慟', */
	/* 6160 */ 0,0,0xcbfd,0xb4b7,0,0xd8d4,0,0xb7c5, 0xb3b4,0,0,0xd8d1,0,0,0xceb8,0xd8d3, /* 0,0,'慢','慣',0,'慥',0,'慧', '慨',0,0,'慫',0,0,'慮','慯', */
	/* 6170 */ 0xb0d6,0xd8d5,0,0xd8cc,0xd8d2,0xd8d9,0xb7c4,0xd8cd, 0,0,0,0,0,0,0xcddd,0, /* '慰','慱',0,'慳','慴','慵','慶','慷', 0,0,0,0,0,0,'慾',0, */
	/* 6180 */ 0,0,0xcdab,0,0,0,0,0xd8dc, 0,0,0xd8e0,0,0,0,0xc1fe,0, /* 0,0,'憂',0,0,0,0,'憇', 0,0,'憊',0,0,0,'憎',0, */
	/* 6190 */ 0xcef9,0xd8e1,0,0,0xd8de,0,0xd8db,0, 0xfaac,0xd8da,0xd8df,0,0,0,0,0, /* '憐','憑',0,0,'憔',0,'憖',0, '憘','憙','憚',0,0,0,0,0, */
	/* 61a0 */ 0,0,0,0,0xcab0,0,0,0xc6b4, 0,0xb7c6,0,0xd8e2,0xd8dd,0,0xd8e3,0, /* 0,0,0,0,'憤',0,0,'憧', 0,'憩',0,'憫','憬',0,'憮',0, */
	/* 61b0 */ 0,0,0xb7fb,0,0,0,0xb2b1,0, 0,0,0xd8eb,0,0,0,0xb4b8,0, /* 0,0,'憲',0,0,0,'憶',0, 0,0,'憺',0,0,0,'憾',0, */
	/* 61c0 */ 0,0,0,0xd8e9,0,0,0xd8ea,0xbaa9, 0xd8e8,0xd8e6,0xd8e5,0xd8ec,0xd8e4,0xd8ee,0,0, /* 0,0,0,'懃',0,0,'懆','懇', '懈','應','懊','懋','懌','懍',0,0, */
	/* 61d0 */ 0xb2fb,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '懐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 61e0 */ 0,0,0,0xd8f0,0,0,0xd8ef,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'懣',0,0,'懦',0, 0,0,0,0,0,0,0,0, */
	/* 61f0 */ 0,0,0xc4a8,0,0xd8f3,0,0xd8f1,0xd8e7, 0xb7fc,0,0xd8f2,0,0xd8f6,0xd8f5,0xd8f7,0xd8f4, /* 0,0,'懲',0,'懴',0,'懶','懷', '懸',0,'懺',0,'懼','懽','懾','懿', */
	/* 6200 */ 0xd8f8,0,0,0,0,0,0,0, 0xd8f9,0xd8fa,0xcaea,0,0xd8fc,0xd8fb,0xbdbf,0, /* '戀',0,0,0,0,0,0,0, '戈','戉','戊',0,'戌','戍','戎',0, */
	/* 6210 */ 0xc0ae,0xb2e6,0xb2fc,0xfaad,0xd8fd,0,0xb0bf,0, 0,0,0xc0cc,0xd8fe,0,0xecc3,0xd9a1,0xb7e1, /* '成','我','戒','戓','戔',0,'或',0, 0,0,'戚','戛',0,'戝','戞','戟', */
	/* 6220 */ 0,0xd9a2,0,0,0,0,0xc0ef,0, 0,0,0xd9a3,0,0,0,0xd9a4,0xb5ba, /* 0,'戡',0,0,0,0,'戦',0, 0,0,'截',0,0,0,'戮','戯', */
	/* 6230 */ 0xd9a5,0,0xd9a6,0xd9a7,0xc2d7,0,0,0, 0xb8cd,0,0,0xcce1,0,0,0,0xcbbc, /* '戰',0,'戲','戳','戴',0,0,0, '戸',0,0,'戻',0,0,0,'房', */
	/* 6240 */ 0xbdea,0xd9a8,0,0,0,0,0,0xc0f0, 0xeebd,0xc8e2,0,0xbcea,0,0xbacd,0xd9a9,0, /* '所','扁',0,0,0,0,0,'扇', '扈','扉',0,'手',0,'才','扎',0, */
	/* 6250 */ 0,0,0,0xc2c7,0,0xcaa7,0,0, 0xc2f1,0,0,0xd9ac,0,0,0xd9aa,0, /* 0,0,0,'打',0,'払',0,0, '托',0,0,'扛',0,0,'扞',0, */
	/* 6260 */ 0xd9ad,0,0,0xd9ab,0,0,0,0, 0xd9ae,0,0,0,0,0,0xcab1,0, /* '扠',0,0,'扣',0,0,0,0, '扨',0,0,0,0,0,'扮',0, */
	/* 6270 */ 0,0xb0b7,0,0,0,0,0xc9de,0, 0,0xc8e3,0,0,0xd9af,0,0xd9b2,0xbeb5, /* 0,'扱',0,0,0,0,'扶',0, 0,'批',0,0,'扼',0,'找','承', */
	/* 6280 */ 0xb5bb,0,0xd9b0,0xd9b7,0xbeb6,0,0,0, 0,0xd9b1,0xc7c4,0,0,0,0,0, /* '技',0,'抂','抃','抄',0,0,0, 0,'抉','把',0,0,0,0,0, */
	/* 6290 */ 0,0xcdde,0xd9b3,0xd9b4,0xd9b8,0xc5ea,0xd9b5,0xb9b3, 0xc0de,0,0,0xd9c6,0xc8b4,0,0xc2f2,0, /* 0,'抑','抒','抓','抔','投','抖','抗', '折',0,0,'抛','抜',0,'択',0, */
	/* 62a0 */ 0,0,0,0,0,0,0xfaae,0, 0,0,0,0xc8e4,0xdaad,0,0,0, /* 0,0,0,0,0,0,'抦',0, 0,0,0,'披','抬',0,0,0, */
	/* 62b0 */ 0,0xcafa,0,0,0,0xc4f1,0,0, 0,0xcbf5,0,0xd9bb,0xb2a1,0xc3ea,0,0, /* 0,'抱',0,0,0,'抵',0,0, 0,'抹',0,'抻','押','抽',0,0, */
	/* 62c0 */ 0,0,0xd9c4,0,0,0xc3b4,0xd9be,0xd9c5, 0xd9c0,0xd9c7,0xd9c3,0,0xd9c2,0xc7ef,0,0xd9bc, /* 0,0,'拂',0,0,'担','拆','拇', '拈','拉','拊',0,'拌','拍',0,'拏', */
	/* 62d0 */ 0xb2fd,0xd9ba,0xb5f1,0xc2f3,0xd9b6,0,0,0xd9b9, 0xb9b4,0xc0db,0,0xbeb7,0xd9c1,0xc7d2,0,0, /* '拐','拑','拒','拓','拔',0,0,'拗', '拘','拙',0,'招','拜','拝',0,0, */
	/* 62e0 */ 0xb5f2,0xb3c8,0,0,0,0,0,0, 0,0,0,0,0xb3e7,0xbfa1,0xd9c9,0xd9ce, /* '拠','拡',0,0,0,0,0,0, 0,0,0,0,'括','拭','拮','拯', */
	/* 62f0 */ 0,0xd9ca,0,0xb7fd,0,0xd9cf,0xbba2,0xb9e9, 0,0,0,0,0,0,0xbda6,0xd9bd, /* 0,'拱',0,'拳',0,'拵','拶','拷', 0,0,0,0,0,0,'拾','拿', */
	/* 6300 */ 0,0xbbfd,0xd9cc,0,0,0,0,0xbbd8, 0xd9cd,0xb0c4,0,0,0xd9c8,0,0,0, /* 0,'持','挂',0,0,0,0,'指', '挈','按',0,0,'挌',0,0,0, */
	/* 6310 */ 0,0xc4a9,0,0,0,0,0,0, 0,0xb5f3,0,0,0,0,0,0xb6b4, /* 0,'挑',0,0,0,0,0,0, 0,'挙',0,0,0,0,0,'挟', */
	/* 6320 */ 0,0,0,0,0,0,0,0xd9cb, 0xb0a7,0,0,0xbac3,0,0,0,0xbfb6, /* 0,0,0,0,0,0,0,'挧', '挨',0,0,'挫',0,0,0,'振', */
	/* 6330 */ 0,0,0,0,0,0,0,0, 0,0,0xc4f2,0,0,0xc8d4,0xd9d1,0xc1de, /* 0,0,0,0,0,0,0,0, 0,0,'挺',0,0,'挽','挾','挿', */
	/* 6340 */ 0,0,0,0,0,0,0,0, 0,0xc2aa,0,0,0xbbab,0xd9d2,0,0xd9d4, /* 0,0,0,0,0,0,0,0, 0,'捉',0,0,'捌','捍',0,'捏', */
	/* 6350 */ 0xd9d0,0,0,0,0,0xcae1,0,0xc4bd, 0,0,0,0,0xc1dc,0,0,0, /* '捐',0,0,0,0,'捕',0,'捗', 0,0,0,0,'捜',0,0,0, */
	/* 6360 */ 0,0,0,0,0,0,0,0xcafb, 0xbcce,0xd9e0,0,0xd9df,0,0,0xbff8,0, /* 0,0,0,0,0,0,0,'捧', '捨','捩',0,'捫',0,0,'据',0, */
	/* 6370 */ 0,0,0xb7fe,0,0,0,0xd9d9,0xbeb9, 0,0,0xc6e8,0xc7b1,0,0,0,0, /* 0,0,'捲',0,0,0,'捶','捷', 0,0,'捺','捻',0,0,0,0, */
	/* 6380 */ 0xd9d7,0,0,0xc1dd,0,0,0,0, 0xbcf8,0xd9dc,0,0,0xbeb8,0,0xd9d6,0xd9db, /* '掀',0,0,'掃',0,0,0,0, '授','掉',0,0,'掌',0,'掎','掏', */
	/* 6390 */ 0,0,0xc7d3,0,0,0,0xd9d5,0, 0xb7a1,0,0,0xb3dd,0,0,0,0xd9dd, /* 0,0,'排',0,0,0,'掖',0, '掘',0,0,'掛',0,0,0,'掟', */
	/* 63a0 */ 0xceab,0xbace,0xc3b5,0xd9da,0,0xc0dc,0,0xb9b5, 0xbfe4,0xb1e6,0xc1bc,0xd9d8,0xb5c5,0,0,0, /* '掠','採','探','掣',0,'接',0,'控', '推','掩','措','掫','掬',0,0,0, */
	/* 63b0 */ 0,0,0xb7c7,0,0xc4cf,0xd9de,0,0, 0,0,0,0xc1df,0,0,0xd9e1,0, /* 0,0,'掲',0,'掴','掵',0,0, 0,0,0,'掻',0,0,'掾',0, */
	/* 63c0 */ 0xd9e3,0,0,0xc2b7,0xd9e9,0,0xd9e4,0, 0,0xd9e6,0,0,0,0,0,0xc9c1, /* '揀',0,0,'揃','揄',0,'揆',0, 0,'揉',0,0,0,0,0,'描', */
	/* 63d0 */ 0xc4f3,0,0xd9e7,0,0,0,0xcdac,0, 0,0,0xcdc8,0xb4b9,0,0,0,0, /* '提',0,'插',0,0,0,'揖',0, 0,0,'揚','換',0,0,0,0, */
	/* 63e0 */ 0,0xb0ae,0,0xd9e5,0,0,0,0, 0,0xd9e2,0,0,0,0,0xb4f8,0, /* 0,'握',0,'揣',0,0,0,0, 0,'揩',0,0,0,0,'揮',0, */
	/* 63f0 */ 0,0,0,0,0xb1e7,0xfaaf,0xd9e8,0, 0,0,0xcdc9,0,0,0,0,0, /* 0,0,0,0,'援','揵','揶',0, 0,0,'揺',0,0,0,0,0, */
	/* 6400 */ 0,0,0,0,0,0,0xd9ec,0, 0,0,0,0,0,0xc2bb,0,0xd9f3, /* 0,0,0,0,0,0,'搆',0, 0,0,0,0,0,'損',0,'搏', */
	/* 6410 */ 0,0,0,0xd9ed,0,0,0xd9ea,0xd9f1, 0,0,0,0,0xd9d3,0,0,0, /* 0,0,0,'搓',0,0,'搖','搗', 0,0,0,0,'搜',0,0,0, */
	/* 6420 */ 0,0,0,0,0,0,0xd9ee,0, 0xd9f2,0,0,0,0xc8c2,0xc5eb,0,0, /* 0,0,0,0,0,0,'搦',0, '搨',0,0,0,'搬','搭',0,0, */
	/* 6430 */ 0,0,0,0,0xd9eb,0,0xd9ef,0, 0,0,0xb7c8,0,0,0,0xbaf1,0, /* 0,0,0,0,'搴',0,'搶',0, 0,0,'携',0,0,0,'搾',0, */
	/* 6440 */ 0,0,0xc0dd,0,0,0,0,0, 0,0,0,0,0,0,0xd9f7,0, /* 0,0,'摂',0,0,0,0,0, 0,0,0,0,0,0,'摎',0, */
	/* 6450 */ 0,0,0,0,0,0,0,0, 0xc5a6,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '摘',0,0,0,0,0,0,0, */
	/* 6460 */ 0xfab0,0,0,0,0,0,0,0xd9f4, 0,0xcbe0,0,0,0,0,0,0xd9f5, /* '摠',0,0,0,0,0,0,'摧', 0,'摩',0,0,0,0,0,'摯', */
	/* 6470 */ 0,0,0,0,0,0,0xd9f6,0, 0xccce,0,0xc0a2,0,0,0,0,0, /* 0,0,0,0,0,0,'摶',0, '摸',0,'摺',0,0,0,0,0, */
	/* 6480 */ 0,0,0,0xb7e2,0,0,0,0, 0xd9fd,0,0,0,0,0,0,0, /* 0,0,0,'撃',0,0,0,0, '撈',0,0,0,0,0,0,0, */
	/* 6490 */ 0,0,0xbbb5,0xd9fa,0,0xd9f9,0,0, 0,0,0xc7b2,0,0,0xfab1,0xc6b5,0, /* 0,0,'撒','撓',0,'撕',0,0, 0,0,'撚',0,0,'撝','撞',0, */
	/* 64a0 */ 0,0,0,0,0xc5b1,0xd9fb,0,0, 0,0xd9fc,0,0xc9ef,0,0xc7c5,0xbba3,0, /* 0,0,0,0,'撤','撥',0,0, 0,'撩',0,'撫',0,'播','撮',0, */
	/* 64b0 */ 0xc0f1,0,0xcbd0,0,0,0,0,0, 0,0xb3c9,0,0xdaa5,0xd9fe,0,0,0, /* '撰',0,'撲',0,0,0,0,0, 0,'撹',0,'撻','撼',0,0,0, */
	/* 64c0 */ 0,0xcdca,0xdaa7,0,0,0xdaa3,0,0xdaa4, 0,0,0,0,0,0xc1e0,0xfab2,0, /* 0,'擁','擂',0,0,'擅',0,'擇', 0,0,0,0,0,'操','擎',0, */
	/* 64d0 */ 0,0,0xdaa2,0,0xd9bf,0,0,0, 0xdaa6,0,0xdaa1,0,0,0,0,0, /* 0,0,'擒',0,'擔',0,0,0, '擘',0,'據',0,0,0,0,0, */
	/* 64e0 */ 0xdaab,0xdaac,0xc5a7,0xdaae,0,0,0xbba4,0xdaa9, 0,0,0,0,0xb5bc,0,0,0xdaaf, /* '擠','擡','擢','擣',0,0,'擦','擧', 0,0,0,0,'擬',0,0,'擯', */
	/* 64f0 */ 0,0xdaa8,0xdab3,0,0xdab2,0,0xdab1,0, 0,0,0xdab4,0,0,0xdab6,0xbef1,0, /* 0,'擱','擲',0,'擴',0,'擶',0, 0,0,'擺',0,0,'擽','擾',0, */
	/* 6500 */ 0xdab5,0,0,0,0,0xdab9,0,0, 0,0,0,0,0,0,0,0, /* '攀',0,0,0,0,'攅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6510 */ 0,0,0,0,0,0,0,0, 0xdab7,0,0,0,0xdab8,0xd9f0,0,0, /* 0,0,0,0,0,0,0,0, '攘',0,0,0,'攜','攝',0,0, */
	/* 6520 */ 0,0,0,0xdabb,0xdaba,0,0,0, 0,0,0xd9f8,0xdabc,0xdab0,0,0,0xbbd9, /* 0,0,0,'攣','攤',0,0,0, 0,0,'攪','攫','攬',0,0,'支', */
	/* 6530 */ 0,0,0,0,0xdabd,0xdabe,0xdac0,0xdabf, 0xdac1,0xb2fe,0,0xb9b6,0,0,0xcafc,0xc0af, /* 0,0,0,0,'攴','攵','收','攷', '攸','改',0,'攻',0,0,'放','政', */
	/* 6540 */ 0,0,0,0,0,0xb8ce,0,0, 0xdac3,0,0,0,0,0xdac6,0xfab3,0xc9d2, /* 0,0,0,0,0,'故',0,0, '效',0,0,0,0,'敍','敎','敏', */
	/* 6550 */ 0,0xb5df,0,0,0,0xdac5,0xdac4,0xc7d4, 0xdac7,0xb6b5,0,0,0,0xdac9,0xdac8,0, /* 0,'救',0,0,0,'敕','敖','敗', '敘','教',0,0,0,'敝','敞',0, */
	/* 6560 */ 0,0,0xb4ba,0xbbb6,0,0,0xc6d8,0, 0,0,0,0,0xb7c9,0,0,0, /* 0,0,'敢','散',0,0,'敦',0, 0,0,0,0,'敬',0,0,0, */
	/* 6570 */ 0xbff4,0,0xdaca,0,0xc0b0,0xc5a8,0,0xc9df, 0xdacb,0,0,0,0,0,0,0, /* '数',0,'敲',0,'整','敵',0,'敷', '數',0,0,0,0,0,0,0, */
	/* 6580 */ 0,0,0xdacc,0xdacd,0,0,0,0xcab8, 0xd5dd,0xc0c6,0,0,0xc9cc,0,0xbad8,0, /* 0,0,'斂','斃',0,0,0,'文', '斈','斉',0,0,'斌',0,'斎',0, */
	/* 6590 */ 0xc8e5,0xc8c3,0,0,0,0,0,0xc5cd, 0,0xcec1,0,0xdacf,0xbcd0,0,0,0xdad0, /* '斐','斑',0,0,0,0,0,'斗', 0,'料',0,'斛','斜',0,0,'斟', */
	/* 65a0 */ 0,0xb0b6,0,0,0xb6d4,0xc0cd,0,0xc9e0, 0,0,0,0xdad1,0xbbc2,0xc3c7,0,0xbbdb, /* 0,'斡',0,0,'斤','斥',0,'斧', 0,0,0,'斫','斬','断',0,'斯', */
	/* 65b0 */ 0xbfb7,0,0,0,0,0,0,0xdad2, 0,0xcafd,0,0,0xb1f7,0xbbdc,0,0, /* '新',0,0,0,0,0,0,'斷', 0,'方',0,0,'於','施',0,0, */
	/* 65c0 */ 0,0xdad5,0,0xdad3,0xdad6,0xceb9,0xdad4,0, 0,0,0,0xc0fb,0xdad7,0,0,0xc2b2, /* 0,'旁',0,'旃','旄','旅','旆',0, 0,0,0,'旋','旌',0,0,'族', */
	/* 65d0 */ 0,0,0xdad8,0,0,0,0,0xb4fa, 0,0xdada,0,0xdad9,0,0,0,0, /* 0,0,'旒',0,0,0,0,'旗', 0,'旙',0,'旛',0,0,0,0, */
	/* 65e0 */ 0xdadb,0xdadc,0xb4fb,0,0,0xc6fc,0xc3b6,0xb5ec, 0xbbdd,0xc1e1,0,0,0xbddc,0xb0b0,0,0, /* '无','旡','既',0,0,'日','旦','旧', '旨','早',0,0,'旬','旭',0,0, */
	/* 65f0 */ 0,0xdadd,0,0,0,0,0,0, 0,0,0xb2a2,0xdae1,0,0,0,0, /* 0,'旱',0,0,0,0,0,0, 0,0,'旺','旻',0,0,0,0, */
	/* 6600 */ 0xfab4,0,0xb9b7,0xdae0,0,0,0xbaab,0xbeba, 0,0xfab7,0xdadf,0,0xbebb,0,0xccc0,0xbaaa, /* '昀',0,'昂','昃',0,0,'昆','昇', 0,'昉','昊',0,'昌',0,'明','昏', */
	/* 6610 */ 0,0,0,0xb0d7,0xc0ce,0xfab5,0,0, 0,0,0,0,0xdae6,0,0xfab9,0xc0b1, /* 0,0,0,'易','昔','昕',0,0, 0,0,0,0,'昜',0,'昞','星', */
	/* 6620 */ 0xb1c7,0,0,0,0xfaba,0xbdd5,0,0xcbe6, 0xbaf2,0,0,0,0,0xbebc,0xfab8,0xc0a7, /* '映',0,0,0,'昤','春',0,'昧', '昨',0,0,0,0,'昭','昮','是', */
	/* 6630 */ 0,0xf9a8,0,0,0xdae5,0xdae3,0xdae4,0, 0,0,0,0xfab6,0xc3eb,0,0,0xdba6, /* 0,'昱',0,0,'昴','昵','昶',0, 0,0,0,'昻','昼',0,0,'昿', */
	/* 6640 */ 0,0xdaea,0xbbfe,0xb9b8,0xdae8,0,0,0, 0,0xdae9,0,0xbfb8,0,0,0,0xdae7, /* 0,'晁','時','晃','晄',0,0,0, 0,'晉',0,'晋',0,0,0,'晏', */
	/* 6650 */ 0,0,0xbbaf,0,0,0,0,0xfabc, 0,0xfabd,0,0,0,0xdaec,0xdaeb,0xdaf0, /* 0,0,'晒',0,0,0,0,'晗', 0,'晙',0,0,0,'晝','晞','晟', */
	/* 6660 */ 0,0,0xdaf1,0,0xdaed,0xfabb,0xb3a2,0xdaee, 0xdaef,0xc8d5,0,0,0,0,0xc9e1,0xb7ca, /* 0,0,'晢',0,'晤','晥','晦','晧', '晨','晩',0,0,0,0,'普','景', */
	/* 6670 */ 0xdaf2,0,0,0xfabf,0xc0b2,0,0xbebd,0, 0,0,0xc3d2,0,0,0,0,0, /* '晰',0,0,'晳','晴',0,'晶',0, 0,0,'智',0,0,0,0,0, */
	/* 6680 */ 0,0xb6c7,0,0xdaf3,0xdaf7,0,0,0xb2cb, 0xdaf4,0xdaf6,0,0,0,0,0xdaf5,0, /* 0,'暁',0,'暃','暄',0,0,'暇', '暈','暉',0,0,0,0,'暎',0, */
	/* 6690 */ 0,0xbdeb,0,0,0,0,0xc3c8,0xb0c5, 0xdaf8,0xfac0,0,0,0,0xdaf9,0,0, /* 0,'暑',0,0,0,0,'暖','暗', '暘','暙',0,0,0,'暝',0,0, */
	/* 66a0 */ 0xfac1,0,0xc4aa,0,0,0,0xcef1,0, 0,0,0,0xbbc3,0,0,0xcaeb,0, /* '暠',0,'暢',0,0,0,'暦',0, 0,0,0,'暫',0,0,'暮',0, */
	/* 66b0 */ 0,0,0xfac2,0,0xcbbd,0,0,0, 0xdba2,0xdafb,0,0,0xdafe,0,0xdafd,0xfac3, /* 0,0,'暲',0,'暴',0,0,0, '暸','暹',0,0,'暼',0,'暾','暿', */
	/* 66c0 */ 0,0xdafa,0,0,0xdba1,0,0,0xc6de, 0,0xdafc,0,0,0,0,0,0, /* 0,'曁',0,0,'曄',0,0,'曇', 0,'曉',0,0,0,0,0,0, */
	/* 66d0 */ 0,0,0,0,0,0,0xdba3,0, 0,0xbdec,0xdba4,0,0xcdcb,0xc7f8,0,0, /* 0,0,0,0,0,0,'曖',0, 0,'曙','曚',0,'曜','曝',0,0, */
	/* 66e0 */ 0xdba5,0,0,0,0,0,0xdba7,0, 0,0xdba8,0,0,0,0,0,0, /* '曠',0,0,0,0,0,'曦',0, 0,'曩',0,0,0,0,0,0, */
	/* 66f0 */ 0xdba9,0,0xb6ca,0xb1c8,0xb9b9,0xdbaa,0,0xdbab, 0xbdf1,0xc1e2,0xfac4,0xf9ab,0xd2d8,0xc1be,0xc1bd,0xc2d8, /* '曰',0,'曲','曳','更','曵',0,'曷', '書','曹','曺','曻','曼','曽','曾','替', */
	/* 6700 */ 0xbac7,0,0,0xd0f2,0,0,0,0, 0xb7ee,0xcdad,0,0xcafe,0,0xc9fe,0xfac5,0xdbac, /* '最',0,0,'會',0,0,0,0, '月','有',0,'朋',0,'服','朎','朏', */
	/* 6710 */ 0,0,0,0,0xbaf3,0xc4bf,0xdbad,0xcfaf, 0,0,0,0xcbbe,0,0xc4ab,0xdbae,0xb4fc, /* 0,0,0,0,'朔','朕','朖','朗', 0,0,0,'望',0,'朝','朞','期', */
	/* 6720 */ 0,0,0,0,0,0,0xdbaf,0xdbb0, 0xccda,0,0xcca4,0xcbf6,0xcbdc,0xbba5,0xdbb2,0, /* 0,0,0,0,0,0,'朦','朧', '木',0,'未','末','本','札','朮',0, */
	/* 6730 */ 0,0xbceb,0,0,0xcbd1,0,0xdbb4,0xdbb7, 0xdbb6,0,0xb4f9,0,0,0xb5e0,0,0xdbb3, /* 0,'朱',0,0,'朴',0,'朶','朷', '朸',0,'机',0,0,'朽',0,'朿', */
	/* 6740 */ 0,0xdbb5,0,0,0,0,0xdbb8,0, 0,0xbff9,0,0,0,0,0xcdfb,0xb0c9, /* 0,'杁',0,0,0,0,'杆',0, 0,'杉',0,0,0,0,'李','杏', */
	/* 6750 */ 0xbae0,0xc2bc,0,0xbcdd,0,0,0xbef3,0, 0,0xdbbb,0,0,0xc5ce,0,0xdbb9,0xc2ab, /* '材','村',0,'杓',0,0,'杖',0, 0,'杙',0,0,'杜',0,'杞','束', */
	/* 6760 */ 0xdbba,0xbef2,0xccdd,0xdbbc,0xdbbd,0xcde8,0xfac7,0, 0,0,0xdbc2,0,0,0xb9ba,0,0xc7d5, /* '杠','条','杢','杣','杤','来','杦',0, 0,0,'杪',0,0,'杭',0,'杯', */
	/* 6770 */ 0xdbbf,0xc5ec,0xdade,0xdae2,0,0xb5cf,0,0xc7c7, 0,0,0,0,0xdbc1,0,0xbebe,0xc8c4, /* '杰','東','杲','杳',0,'杵',0,'杷', 0,0,0,0,'杼',0,'松','板', */
	/* 6780 */ 0,0,0,0,0,0xdbc7,0,0xc8fa, 0,0xdbbe,0,0xdbc4,0xdbc3,0,0,0, /* 0,0,0,0,0,'枅',0,'枇', 0,'枉',0,'枋','枌',0,0,0, */
	/* 6790 */ 0xc0cf,0,0,0,0,0xcbed,0,0xced3, 0,0,0xcbe7,0,0xb2cc,0xbbde,0,0, /* '析',0,0,0,0,'枕',0,'林', 0,0,'枚',0,'果','枝',0,0, */
	/* 67a0 */ 0xcfc8,0xdbc6,0xbff5,0,0,0,0xdbc5,0, 0,0xdbc0,0,0,0,0,0,0xb8cf, /* '枠','枡','枢',0,0,0,'枦',0, 0,'枩',0,0,0,0,0,'枯', */
	/* 67b0 */ 0,0,0,0xdbcc,0xdbca,0,0xb2cd,0xdbc8, 0xdbce,0xdbd4,0,0xfac8,0,0,0,0, /* 0,0,0,'枳','枴',0,'架','枷', '枸','枹',0,'枻',0,0,0,0, */
	/* 67c0 */ 0xfaca,0xc2c8,0,0,0xcac1,0,0xdbd6,0, 0,0,0xc9a2,0,0,0,0xdbd5,0xc7f0, /* '柀','柁',0,0,'柄',0,'柆',0, 0,0,'柊',0,0,0,'柎','柏', */
	/* 67d0 */ 0xcbbf,0xb4bb,0,0xc0f7,0xbdc0,0,0,0, 0xc4d3,0,0xcdae,0,0,0xdbd1,0xdbd0,0, /* '某','柑',0,'染','柔',0,0,0, '柘',0,'柚',0,0,'柝','柞',0, */
	/* 67e0 */ 0,0,0xdbd2,0,0xdbcf,0,0,0xdbd7, 0,0xdbcd,0,0,0xdbcb,0,0xdbd3,0xdbc9, /* 0,0,'柢',0,'柤',0,0,'柧', 0,'柩',0,0,'柬',0,'柮','柯', */
	/* 67f0 */ 0,0xc3ec,0,0xccf8,0xbcc6,0xbaf4,0,0, 0,0,0,0xbaba,0,0,0xcbef,0xb3c1, /* 0,'柱',0,'柳','柴','柵',0,0, 0,0,0,'査',0,0,'柾','柿', */
	/* 6800 */ 0,0xfacb,0xc4ce,0xc6ca,0xb1c9,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'栁','栂','栃','栄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6810 */ 0,0,0,0xc0f2,0,0,0xc0b4,0xb7aa, 0,0,0,0,0,0,0xdbd9,0, /* 0,0,0,'栓',0,0,'栖','栗', 0,0,0,0,0,0,'栞',0, */
	/* 6820 */ 0,0xb9bb,0xb3fc,0,0,0,0,0, 0,0xdbdb,0xb3f4,0xdbe1,0,0,0,0, /* 0,'校','栢',0,0,0,0,0, 0,'栩','株','栫',0,0,0,0, */
	/* 6830 */ 0,0,0xdbde,0,0xc0f3,0,0,0, 0xb3cb,0xbaac,0,0,0xb3ca,0xbacf,0,0, /* 0,0,'栲',0,'栴',0,0,0, '核','根',0,0,'格','栽',0,0, */
	/* 6840 */ 0xdbdc,0xb7e5,0xb7cb,0xc5ed,0xfacc,0,0xdbda,0, 0xb0c6,0,0,0,0,0xdbdd,0xdbdf,0, /* '桀','桁','桂','桃','桄',0,'框',0, '案',0,0,0,0,'桍','桎',0, */
	/* 6850 */ 0xb6cd,0xb7ac,0xfac9,0xb4bc,0xb5cb,0,0,0, 0,0xdbe2,0,0,0xbaf9,0xcbf1,0,0xbbb7, /* '桐','桑','桒','桓','桔',0,0,0, 0,'桙',0,0,'桜','桝',0,'桟', */
	/* 6860 */ 0,0,0,0xdbe3,0,0,0,0xc9b0, 0,0,0,0,0,0,0,0, /* 0,0,0,'档',0,0,0,'桧', 0,0,0,0,0,0,0,0, */
	/* 6870 */ 0,0,0,0,0xdbef,0,0xb2b3,0xdbe4, 0,0,0,0,0,0,0xdbf5,0xdbe5, /* 0,0,0,0,'桴',0,'桶','桷', 0,0,0,0,0,0,'桾','桿', */
	/* 6880 */ 0,0xcec2,0,0xdbec,0,0xc7df,0,0, 0,0,0,0,0,0xdbf4,0,0xdbe7, /* 0,'梁',0,'梃',0,'梅',0,0, 0,0,0,0,0,'梍',0,'梏', */
	/* 6890 */ 0,0,0,0xb0b4,0xdbe9,0,0,0xb9bc, 0,0,0,0xdbeb,0,0xdbea,0,0xdbe6, /* 0,0,0,'梓','梔',0,0,'梗', 0,0,0,'梛',0,'條',0,'梟', */
	/* 68a0 */ 0xdbf1,0,0xbebf,0,0,0,0xd4ed,0xb8e8, 0xcdfc,0,0,0,0,0xdbe8,0,0xc4f4, /* '梠',0,'梢',0,0,0,'梦','梧', '梨',0,0,0,0,'梭',0,'梯', */
	/* 68b0 */ 0xb3a3,0xbaad,0,0xdbe0,0,0xdbf0,0xb3e1,0, 0,0xdbee,0xdbf2,0,0xc5ee,0,0,0, /* '械','梱',0,'梳',0,'梵','梶',0, 0,'梹','梺',0,'梼',0,0,0, */
	/* 68c0 */ 0,0,0,0,0xb4fe,0,0xdcb2,0, 0xf9a9,0xccc9,0xdbf7,0xb4fd,0,0xdbfe,0,0xfacd, /* 0,0,0,0,'棄',0,'棆',0, '棈','棉','棊','棋',0,'棍',0,'棏', */
	/* 68d0 */ 0,0,0xcbc0,0,0xdca1,0xdca3,0,0xdca7, 0xdbf9,0,0xc3aa,0,0,0,0,0xc5ef, /* 0,0,'棒',0,'棔','棕',0,'棗', '棘',0,'棚',0,0,0,0,'棟', */
	/* 68e0 */ 0xdcab,0xdbfc,0,0xdca8,0,0,0,0xdca2, 0,0,0,0,0,0,0xbfb9,0xdcac, /* '棠','棡',0,'棣',0,0,0,'棧', 0,0,0,0,0,0,'森','棯', */
	/* 68f0 */ 0,0,0xc0b3,0,0,0,0,0, 0,0xdcaa,0xb4bd,0,0,0,0,0, /* 0,0,'棲',0,0,0,0,0, 0,'棹','棺',0,0,0,0,0, */
	/* 6900 */ 0xcfd0,0xdbf6,0,0,0xdca6,0xb0d8,0,0, 0xdbf8,0,0,0xccba,0xdbfd,0xbfa2,0xc4c7,0xdbf3, /* '椀','椁',0,0,'椄','椅',0,0, '椈',0,0,'椋','椌','植','椎','椏', */
	/* 6910 */ 0,0,0xdca5,0,0,0,0,0, 0,0xbffa,0xdcaf,0xb3f1,0xb8a1,0,0,0, /* 0,0,'椒',0,0,0,0,0, 0,'椙','椚','椛','検',0,0,0, */
	/* 6920 */ 0,0xdcb1,0xdbfa,0xdcb0,0,0xdca9,0xdbfb,0, 0xdcad,0,0xdcae,0,0,0,0,0, /* 0,'椡','椢','椣',0,'椥','椦',0, '椨',0,'椪',0,0,0,0,0, */
	/* 6930 */ 0xdcbf,0,0,0,0xc6ce,0,0xdca4,0, 0,0xdcbb,0,0,0,0xdcbd,0,0xc4d8, /* '椰',0,0,0,'椴',0,'椶',0, 0,'椹',0,0,0,'椽',0,'椿', */
	/* 6940 */ 0,0,0,0,0,0,0,0, 0,0,0xcdcc,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'楊',0,0,0,0,0, */
	/* 6950 */ 0,0,0,0xc9f6,0xdcb8,0xc2ca,0,0, 0,0xdcbe,0xc1bf,0,0xdcb5,0xdcc2,0xdcc1,0, /* 0,0,0,'楓','楔','楕',0,0, 0,'楙','楚',0,'楜','楝','楞',0, */
	/* 6960 */ 0xc6ef,0xdcc0,0xc6ea,0,0,0,0,0, 0xfacf,0,0xdcc4,0xdcb7,0,0xb6c8,0xdcba,0xbddd, /* '楠','楡','楢',0,0,0,0,0, '楨',0,'楪','楫',0,'業','楮','楯', */
	/* 6970 */ 0,0,0,0xc7e0,0xdcbc,0xb6cb,0,0xdcb4, 0xdcb6,0xdcb3,0,0,0xcfb0,0xb3da,0xdcb9,0, /* 0,0,0,'楳','楴','極',0,'楷', '楸','楹',0,0,'楼','楽','楾',0, */
	/* 6980 */ 0,0xdcc3,0xb3b5,0,0,0,0,0, 0,0,0xbae7,0,0,0,0xb1dd,0, /* 0,'榁','概',0,0,0,0,0, 0,0,'榊',0,0,0,'榎',0, */
	/* 6990 */ 0,0xdcd4,0,0,0xcfb1,0xdcd7,0,0, 0xfad1,0,0,0xbfba,0xdcd6,0,0,0, /* 0,'榑',0,0,'榔','榕',0,0, '榘',0,0,'榛','榜',0,0,0, */
	/* 69a0 */ 0xdcd5,0,0,0,0,0,0,0xdcd2, 0,0,0,0,0,0,0xdcc6,0, /* '榠',0,0,0,0,0,0,'榧', 0,0,0,0,0,0,'榮',0, */
	/* 69b0 */ 0,0xdce3,0xdcc5,0,0xdcd8,0,0,0, 0,0,0,0xdcd0,0,0,0xdccb,0xdcc8, /* 0,'榱','榲',0,'榴',0,0,0, 0,0,0,'榻',0,0,'榾','榿', */
	/* 69c0 */ 0,0xdcc9,0,0xdcd1,0,0,0,0xf4a2, 0,0,0xdcce,0xb9bd,0xc4c8,0xc1e4,0xdccc,0, /* 0,'槁',0,'槃',0,0,0,'槇', 0,0,'槊','構','槌','槍','槎',0, */
	/* 69d0 */ 0xdcc7,0,0,0xdcca,0,0,0,0, 0xcdcd,0xcbea,0,0,0,0xdccf,0xdcd9,0, /* '槐',0,0,'槓',0,0,0,0, '様','槙',0,0,0,'槝','槞',0, */
	/* 69e0 */ 0,0,0xfad2,0,0,0,0,0xdce1, 0xdcda,0,0,0xdce7,0,0xdce5,0,0, /* 0,0,'槢',0,0,0,0,'槧', '槨',0,0,'槫',0,'槭',0,0, */
	/* 69f0 */ 0,0,0xdce0,0,0,0,0,0, 0,0xdcdf,0,0xc4d0,0,0xc1e5,0,0xdcdd, /* 0,0,'槲',0,0,0,0,0, 0,'槹',0,'槻',0,'槽',0,'槿', */
	/* 6a00 */ 0,0,0xdcdb,0,0,0xdce2,0,0, 0,0,0xdce8,0xc8f5,0xdcee,0,0,0, /* 0,0,'樂',0,0,'樅',0,0, 0,0,'樊','樋','樌',0,0,0, */
	/* 6a10 */ 0,0,0xdce9,0xdcec,0xdce6,0,0,0xc3f4, 0,0xc9b8,0,0xdcdc,0,0,0xdce4,0xbec0, /* 0,0,'樒','樓','樔',0,0,'樗', 0,'標',0,'樛',0,0,'樞','樟', */
	/* 6a20 */ 0,0xcccf,0xdcf8,0xdceb,0,0,0,0, 0,0xb8a2,0xb2a3,0xb3df,0,0,0xdcd3,0, /* 0,'模','樢','樣',0,0,0,0, 0,'権','横','樫',0,0,'樮',0, */
	/* 6a30 */ 0xfad3,0,0,0,0,0xbec1,0xdcf0,0, 0xdcf7,0xbcf9,0xb3f2,0,0,0xc3ae,0,0, /* '樰',0,0,0,0,'樵','樶',0, '樸','樹','樺',0,0,'樽',0,0, */
	/* 6a40 */ 0,0,0,0,0xdced,0,0xfad5,0xdcf2, 0xdcf6,0,0,0xb6b6,0,0,0,0, /* 0,0,0,0,'橄',0,'橆','橇', '橈',0,0,'橋',0,0,0,0, */
	/* 6a50 */ 0,0,0,0,0,0,0,0, 0xb5cc,0xdcf4,0,0,0,0,0,0xb5a1, /* 0,0,0,0,0,0,0,0, '橘','橙',0,0,0,0,0,'機', */
	/* 6a60 */ 0,0xc6cb,0xdcf3,0,0,0,0xdcf5,0, 0,0,0,0xfad4,0,0,0,0, /* 0,'橡','橢',0,0,0,'橦',0, 0,0,0,'橫',0,0,0,0, */
	/* 6a70 */ 0,0,0xdcef,0xfad6,0,0,0,0, 0xdcf1,0,0,0,0,0,0xfad7,0xb3e0, /* 0,0,'橲','橳',0,0,0,0, '橸',0,0,0,0,0,'橾','橿', */
	/* 6a80 */ 0xc3c9,0,0,0,0xdcfc,0,0,0, 0,0,0,0,0,0xdcfa,0xb8e9,0, /* '檀',0,0,0,'檄',0,0,0, 0,0,0,0,0,'檍','檎',0, */
	/* 6a90 */ 0xdcf9,0,0,0,0,0,0,0xdda1, 0,0,0,0,0xdbd8,0,0,0, /* '檐',0,0,0,0,0,0,'檗', 0,0,0,0,'檜',0,0,0, */
	/* 6aa0 */ 0xdcfb,0,0xdcfd,0xdcfe,0,0,0,0, 0,0,0xddac,0,0xdda8,0,0xdbed,0, /* '檠',0,'檢','檣',0,0,0,0, 0,0,'檪',0,'檬',0,'檮',0, */
	/* 6ab0 */ 0,0,0,0xdda7,0,0,0,0, 0xdda6,0,0,0xdda3,0,0,0,0, /* 0,0,0,'檳',0,0,0,0, '檸',0,0,'檻',0,0,0,0, */
	/* 6ac0 */ 0,0xdcea,0xdda5,0xdda4,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'櫁','櫂','櫃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6ad0 */ 0,0xddaa,0,0xcfa6,0,0,0,0, 0,0,0xddad,0xb6fb,0,0,0xdda9,0xddab, /* 0,'櫑',0,'櫓',0,0,0,0, 0,0,'櫚','櫛',0,0,'櫞','櫟', */
	/* 6ae0 */ 0,0,0xfad8,0,0xfad9,0,0,0, 0xc8a7,0,0xddae,0,0,0,0,0, /* 0,0,'櫢',0,'櫤',0,0,0, '櫨',0,'櫪',0,0,0,0,0, */
	/* 6af0 */ 0,0,0,0,0,0,0,0, 0,0,0xddb2,0xddaf,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'櫺','櫻',0,0,0,0, */
	/* 6b00 */ 0,0,0,0,0xcdf3,0xddb0,0,0, 0,0,0xdcde,0,0,0,0,0, /* 0,0,0,0,'欄','欅',0,0, 0,0,'權',0,0,0,0,0, */
	/* 6b10 */ 0,0,0xddb3,0,0,0,0xddb4,0, 0,0,0,0,0,0xb1b5,0,0xddb6, /* 0,0,'欒',0,0,0,'欖',0, 0,0,0,0,0,'欝',0,'欟', */
	/* 6b20 */ 0xb7e7,0xbca1,0,0xb6d5,0,0,0,0xb2a4, 0,0,0,0,0,0,0,0, /* '欠','次',0,'欣',0,0,0,'欧', 0,0,0,0,0,0,0,0, */
	/* 6b30 */ 0,0,0xcddf,0,0,0,0,0xddb8, 0xddb7,0xddba,0xb5bd,0,0,0xb6d6,0xb4be,0, /* 0,0,'欲',0,0,0,0,'欷', '欸','欹','欺',0,0,'欽','款',0, */
	/* 6b40 */ 0,0,0,0xddbd,0,0,0,0xddbc, 0,0xddbe,0,0,0xb2ce,0,0xc3b7,0, /* 0,0,0,'歃',0,0,0,'歇', 0,'歉',0,0,'歌',0,'歎',0, */
	/* 6b50 */ 0xddbf,0,0,0xb4bf,0xddc1,0,0,0, 0,0xddc0,0,0xddc2,0,0,0,0xddc3, /* '歐',0,0,'歓','歔',0,0,0, 0,'歙',0,'歛',0,0,0,'歟', */
	/* 6b60 */ 0,0xddc4,0xbbdf,0xc0b5,0xbaa1,0,0xc9f0,0, 0,0xcae2,0xcfc4,0,0,0,0,0xbbf5, /* 0,'歡','止','正','此',0,'武',0, 0,'歩','歪',0,0,0,0,'歯', */
	/* 6b70 */ 0,0,0,0xbad0,0xcef2,0,0,0, 0xddc5,0xddc6,0,0xbbe0,0,0,0,0xddc7, /* 0,0,0,'歳','歴',0,0,0, '歸','歹',0,'死',0,0,0,'歿', */
	/* 6b80 */ 0xddc8,0,0,0xddca,0xddc9,0,0xcbd8,0, 0,0xbdde,0xbcec,0xbbc4,0,0xddcb,0,0, /* '殀',0,0,'殃','殄',0,'殆',0, 0,'殉','殊','残',0,'殍',0,0, */
	/* 6b90 */ 0,0,0,0,0,0xddcd,0xbfa3,0, 0xddcc,0,0,0,0,0,0xddce,0, /* 0,0,0,0,0,'殕','殖',0, '殘',0,0,0,0,0,'殞',0, */
	/* 6ba0 */ 0,0,0,0,0xddcf,0,0,0, 0,0,0xddd0,0xddd1,0,0,0,0xddd2, /* 0,0,0,0,'殤',0,0,0, 0,0,'殪','殫',0,0,0,'殯', */
	/* 6bb0 */ 0,0xddd4,0xddd3,0xddd5,0xb2a5,0xc3ca,0,0xddd6, 0,0,0xbba6,0xb3cc,0xddd7,0,0,0xc5c2, /* 0,'殱','殲','殳','殴','段',0,'殷', 0,0,'殺','殻','殼',0,0,'殿', */
	/* 6bc0 */ 0xd4cc,0,0,0,0,0xb5a3,0xddd8,0, 0,0,0,0xddd9,0,0xcaec,0xcbe8,0, /* '毀',0,0,0,0,'毅','毆',0, 0,0,0,'毋',0,'母','毎',0, */
	/* 6bd0 */ 0,0,0xc6c7,0xddda,0xc8e6,0,0xfada,0, 0xc8fb,0,0,0xccd3,0,0,0,0xdddb, /* 0,0,'毒','毓','比',0,'毖',0, '毘',0,0,'毛',0,0,0,'毟', */
	/* 6be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0xdddd,0xdddc,0,0,0xdddf, /* 0,0,0,0,0,0,0,0, 0,0,0,'毫','毬',0,0,'毯', */
	/* 6bf0 */ 0,0,0,0xddde,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'毳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c00 */ 0,0,0,0,0,0,0,0, 0xdde1,0,0,0,0,0,0,0xbbe1, /* 0,0,0,0,0,0,0,0, '氈',0,0,0,0,0,0,'氏', */
	/* 6c10 */ 0,0xccb1,0,0xdde2,0xdde3,0,0,0xb5a4, 0,0,0,0xdde4,0,0,0,0, /* 0,'民',0,'氓','气',0,0,'気', 0,0,0,'氛',0,0,0,0, */
	/* 6c20 */ 0,0,0,0xdde6,0xdde5,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'氣','氤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c30 */ 0,0,0,0,0xbfe5,0,0,0xc9b9, 0xb1ca,0,0,0,0,0,0xc8c5,0xfadb, /* 0,0,0,0,'水',0,0,'氷', '永',0,0,0,0,0,'氾','氿', */
	/* 6c40 */ 0xc4f5,0xbdc1,0xb5e1,0,0,0,0,0, 0,0,0,0,0,0,0xc8c6,0, /* '汀','汁','求',0,0,0,0,0, 0,0,0,0,0,0,'汎',0, */
	/* 6c50 */ 0xbcae,0,0,0,0,0xdde8,0,0xb4c0, 0,0,0xb1f8,0,0xfadc,0xc6f2,0xdde7,0xb9be, /* '汐',0,0,0,0,'汕',0,'汗', 0,0,'汚',0,'汜','汝','汞','江', */
	/* 6c60 */ 0xc3d3,0,0xdde9,0,0,0,0,0, 0xddf1,0,0xddea,0,0,0,0,0xfade, /* '池',0,'汢',0,0,0,0,0, '汨',0,'汪',0,0,0,0,'汯', */
	/* 6c70 */ 0xc2c1,0,0xb5e2,0xddf2,0,0,0,0, 0,0,0xb7e8,0,0,0xb5a5,0xddf0,0, /* '汰',0,'汲','汳',0,0,0,0, 0,0,'決',0,0,'汽','汾',0, */
	/* 6c80 */ 0,0xddee,0xddeb,0xcde0,0,0,0xfadd,0, 0xc4c0,0,0,0,0xc6d9,0xddec,0,0, /* 0,'沁','沂','沃',0,0,'沆',0, '沈',0,0,0,'沌','沍',0,0, */
	/* 6c90 */ 0xddf4,0,0xddf3,0xb7a3,0,0,0xb2ad,0, 0,0xbabb,0xdded,0xddef,0,0,0,0, /* '沐',0,'沒','沓',0,0,'沖',0, 0,'沙','沚','沛',0,0,0,0, */
	/* 6ca0 */ 0,0xcbd7,0xc2f4,0,0,0,0,0, 0,0,0,0xcbf7,0,0,0xddfc,0, /* 0,'没','沢',0,0,0,0,0, 0,0,0,'沫',0,0,'沮',0, */
	/* 6cb0 */ 0,0xddfd,0,0xb2cf,0,0,0,0, 0xcaa8,0xccfd,0xdea1,0xbca3,0xbec2,0xddf8,0xddfe,0xb1e8, /* 0,'沱',0,'河',0,0,0,0, '沸','油','沺','治','沼','沽','沾','沿', */
	/* 6cc0 */ 0,0xb6b7,0,0,0xddf5,0xddfa,0,0, 0,0xc0f4,0xc7f1,0,0xc8e7,0,0,0, /* 0,'況',0,0,'泄','泅',0,0, 0,'泉','泊',0,'泌',0,0,0, */
	/* 6cd0 */ 0,0,0,0xddf7,0,0xcba1,0,0xddf9, 0,0xdea4,0xfadf,0xdea2,0,0xddfb,0,0, /* 0,0,0,'泓',0,'法',0,'泗', 0,'泙','泚','泛',0,'泝',0,0, */
	/* 6ce0 */ 0,0xcba2,0xc7c8,0xb5e3,0,0xc5a5,0,0, 0xc3ed,0,0xdea5,0,0,0,0,0xdea3, /* 0,'泡','波','泣',0,'泥',0,0, '注',0,'泪',0,0,0,0,'泯', */
	/* 6cf0 */ 0xc2d9,0xddf6,0,0xb1cb,0,0,0,0, 0,0,0,0,0,0,0,0, /* '泰','泱',0,'泳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6d00 */ 0,0,0,0,0xfae0,0,0,0, 0,0,0,0xcdce,0xdeb0,0,0,0, /* 0,0,0,0,'洄',0,0,0, 0,0,0,'洋','洌',0,0,0, */
	/* 6d10 */ 0,0,0xdeaf,0,0,0,0,0xc0f6, 0,0xdeac,0,0xcdec,0,0,0xc6b6,0xdea6, /* 0,0,'洒',0,0,0,0,'洗', 0,'洙',0,'洛',0,0,'洞','洟', */
	/* 6d20 */ 0,0,0,0,0,0xc4c5,0,0, 0,0xb1cc,0xb9bf,0xdea9,0,0,0,0, /* 0,0,0,0,0,'津',0,0, 0,'洩','洪','洫',0,0,0,0, */
	/* 6d30 */ 0,0,0xbda7,0xdeae,0,0xdead,0xdea8,0, 0xdeab,0,0,0xb3e8,0,0xdeaa,0xc7c9,0, /* 0,0,'洲','洳',0,'洵','洶',0, '洸',0,0,'活',0,'洽','派',0, */
	/* 6d40 */ 0,0xceae,0,0,0xbef4,0xc0f5,0,0, 0,0,0,0,0,0,0,0, /* 0,'流',0,0,'浄','浅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6d50 */ 0,0,0,0,0,0,0,0, 0,0xdeb6,0xdeb4,0,0xc9cd,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'浙','浚',0,'浜',0,0,0, */
	/* 6d60 */ 0,0,0,0xdeb1,0xdeb3,0,0xb1ba,0, 0,0xb9c0,0xcfb2,0,0xb3bd,0,0xc9e2,0xfae2, /* 0,0,0,'浣','浤',0,'浦',0, 0,'浩','浪',0,'浬',0,'浮','浯', */
	/* 6d70 */ 0,0,0,0,0xcde1,0,0,0xb3a4, 0xbfbb,0xdeb5,0,0,0,0,0,0, /* 0,0,0,0,'浴',0,0,'海', '浸','浹',0,0,0,0,0,0, */
	/* 6d80 */ 0,0,0,0,0,0xdeba,0,0xfae1, 0xbec3,0,0,0,0xcdb0,0,0xdeb7,0, /* 0,0,0,0,0,'涅',0,'涇', '消',0,0,0,'涌',0,'涎',0, */
	/* 6d90 */ 0,0,0,0xdeb2,0,0xdeb8,0xfae3,0, 0,0xcede,0,0xc5f3,0xc6c2,0,0,0, /* 0,0,0,'涓',0,'涕','涖',0, 0,'涙',0,'涛','涜',0,0,0, */
	/* 6da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xfae4,0,0,0xb3b6, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'涬',0,0,'涯', */
	/* 6db0 */ 0,0,0xb1d5,0,0,0xdebe,0,0, 0xdec1,0,0,0,0xcec3,0,0,0, /* 0,0,'液',0,0,'涵',0,0, '涸',0,0,0,'涼',0,0,0, */
	/* 6dc0 */ 0xcde4,0,0,0,0,0xdec8,0xdec2,0xdebf, 0,0,0,0xced4,0xdec5,0,0,0xfae5, /* '淀',0,0,0,0,'淅','淆','淇', 0,0,0,'淋','淌',0,0,'淏', */
	/* 6dd0 */ 0,0xbdca,0xdec7,0,0,0xdecc,0,0, 0xc5f1,0xdeca,0,0,0,0,0xdec4,0, /* 0,'淑','淒',0,0,'淕',0,0, '淘','淙',0,0,0,0,'淞',0, */
	/* 6de0 */ 0,0xc3b8,0,0,0xdecb,0,0xdec0,0, 0xdec6,0,0xdecd,0xb0fc,0xdec3,0,0xdece,0, /* 0,'淡',0,0,'淤',0,'淦',0, '淨',0,'淪','淫','淬',0,'淮',0, */
	/* 6df0 */ 0,0xbfbc,0xfae7,0xbddf,0,0xcaa5,0,0xbaae, 0xfae6,0xdebb,0xdec9,0xc5ba,0xfae8,0,0,0, /* 0,'深','淲','淳',0,'淵',0,'混', '淸','淹','淺','添','淼',0,0,0, */
	/* 6e00 */ 0,0,0,0,0,0xc0b6,0,0xb3e9, 0xbad1,0xbec4,0xdebd,0xbdc2,0,0,0,0, /* 0,0,0,0,0,'清',0,'渇', '済','渉','渊','渋',0,0,0,0, */
	/* 6e10 */ 0,0,0,0xb7cc,0,0xdebc,0,0, 0,0xded2,0xbded,0xb8ba,0,0xdee1,0,0xdedb, /* 0,0,0,'渓',0,'渕',0,0, 0,'渙','渚','減',0,'渝',0,'渟', */
	/* 6e20 */ 0xb5f4,0xc5cf,0,0xded6,0xdedf,0xb0af,0xb1b2,0xfaeb, 0,0xb2b9,0,0xded8,0xc2ac,0xdecf,0xded1,0xb9c1, /* '渠','渡',0,'渣','渤','渥','渦','渧', 0,'温',0,'渫','測','渭','渮','港', */
	/* 6e30 */ 0,0,0,0,0,0,0,0, 0xdee2,0xfae9,0xdedd,0,0xfaec,0,0xded5,0, /* 0,0,0,0,0,0,0,0, '游','渹','渺',0,'渼',0,'渾',0, */
	/* 6e40 */ 0,0,0,0xdedc,0,0,0,0, 0,0,0xccab,0,0,0xdeda,0xdede,0, /* 0,0,0,'湃',0,0,0,0, 0,0,'湊',0,0,'湍','湎',0, */
	/* 6e50 */ 0,0,0,0,0,0,0xb8d0,0, 0xbec5,0,0,0xc3b9,0xfaea,0,0,0xded4, /* 0,0,0,0,0,0,'湖',0, '湘',0,0,'湛','湜',0,0,'湟', */
	/* 6e60 */ 0,0,0,0,0,0,0,0xcdaf, 0,0,0,0xded7,0,0,0xded0,0xc5f2, /* 0,0,0,0,0,0,0,'湧', 0,0,0,'湫',0,0,'湮','湯', */
	/* 6e70 */ 0,0,0xded3,0,0,0,0xded9,0, 0,0,0,0,0,0,0xcfd1,0xbcbe, /* 0,0,'湲',0,0,0,'湶',0, 0,0,0,0,0,0,'湾','湿', */
	/* 6e80 */ 0xcbfe,0,0xdee3,0,0,0,0,0, 0,0,0,0,0xc8ae,0,0,0xdeef, /* '満',0,'溂',0,0,0,0,0, 0,0,0,0,'溌',0,0,'溏', */
	/* 6e90 */ 0xb8bb,0,0,0,0,0,0xbde0,0, 0xdee5,0,0,0,0xceaf,0xb9c2,0,0xdef2, /* '源',0,0,0,0,0,'準',0, '溘',0,0,0,'溜','溝',0,'溟', */
	/* 6ea0 */ 0,0,0xb0ee,0,0,0xdef0,0,0, 0,0,0xdee4,0,0,0,0,0xdeea, /* 0,0,'溢',0,0,'溥',0,0, 0,0,'溪',0,0,0,0,'溯', */
	/* 6eb0 */ 0,0,0xdeec,0,0,0,0xcdcf,0xdee7, 0,0,0xc5ae,0,0,0xdee9,0,0xfaed, /* 0,0,'溲',0,0,0,'溶','溷', 0,0,'溺',0,0,'溽',0,'溿', */
	/* 6ec0 */ 0,0,0xdef1,0,0xdeeb,0xccc7,0,0, 0,0xdee6,0,0xbca2,0xdefe,0,0,0, /* 0,0,'滂',0,'滄','滅',0,0, 0,'滉',0,'滋','滌',0,0,0, */
	/* 6ed0 */ 0,0xb3ea,0,0xdee8,0xdeed,0xdeee,0,0, 0,0,0,0,0,0xc2ec,0xc2da,0, /* 0,'滑',0,'滓','滔','滕',0,0, 0,0,0,0,0,'滝','滞',0, */
	/* 6ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xdef6,0,0,0xdefc, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'滬',0,0,'滯', */
	/* 6ef0 */ 0,0,0xdefa,0,0xc5a9,0,0,0xdfa3, 0xdef7,0,0,0,0,0,0xdef8,0xdee0, /* 0,0,'滲',0,'滴',0,0,'滷', '滸',0,0,0,0,0,'滾','滿', */
	/* 6f00 */ 0,0xb5f9,0xc9ba,0,0,0,0xbcbf,0, 0,0xb9f7,0,0,0,0,0,0xcfb3, /* 0,'漁','漂',0,0,0,'漆',0, 0,'漉',0,0,0,0,0,'漏', */
	/* 6f10 */ 0,0xdef4,0,0xdfa2,0xb1e9,0xc1e6,0,0, 0,0,0,0,0,0,0,0, /* 0,'漑',0,'漓','演','漕',0,0, 0,0,0,0,0,0,0,0, */
	/* 6f20 */ 0xc7f9,0,0xb4c1,0xcefa,0,0,0,0, 0,0,0,0xcca1,0xc4d2,0,0,0, /* '漠',0,'漢','漣',0,0,0,0, 0,0,0,'漫','漬',0,0,0, */
	/* 6f30 */ 0,0xdefb,0xdefd,0,0,0,0,0, 0xc1b2,0,0,0,0,0,0xdfa1,0xdef9, /* 0,'漱','漲',0,0,0,0,0, '漸',0,0,0,0,0,'漾','漿', */
	/* 6f40 */ 0,0xdef3,0,0,0,0xb4c3,0,0, 0,0,0,0,0,0,0,0, /* 0,'潁',0,0,0,'潅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6f50 */ 0,0,0,0,0xb7e9,0,0,0, 0xdfaf,0,0,0xdfaa,0xc0f8,0,0,0xb3e3, /* 0,0,0,0,'潔',0,0,0, '潘',0,0,'潛','潜',0,0,'潟', */
	/* 6f60 */ 0,0,0,0,0xbde1,0,0xdfb3,0, 0,0,0,0,0,0xdfac,0xc4ac,0xdfa9, /* 0,0,0,0,'潤',0,'潦',0, 0,0,0,0,0,'潭','潮','潯', */
	/* 6f70 */ 0xc4d9,0,0,0,0xdfcc,0,0,0, 0xdfa6,0,0xdfa5,0,0xdfae,0,0,0, /* '潰',0,0,0,'潴',0,0,0, '潸',0,'潺',0,'潼',0,0,0, */
	/* 6f80 */ 0xdfa8,0xdfa7,0xdfad,0,0xc0a1,0,0xdfa4,0, 0xfaee,0,0,0,0,0,0xdfb0,0, /* '澀','澁','澂',0,'澄',0,'澆',0, '澈',0,0,0,0,0,'澎',0, */
	/* 6f90 */ 0,0xdfb1,0,0,0,0,0,0xb4c2, 0,0,0,0,0,0,0,0, /* 0,'澑',0,0,0,0,0,'澗', 0,0,0,0,0,0,0,0, */
	/* 6fa0 */ 0,0xdfb6,0,0xdfb5,0xdfb7,0,0,0, 0,0,0xdfba,0,0,0,0,0, /* 0,'澡',0,'澣','澤',0,0,0, 0,0,'澪',0,0,0,0,0, */
	/* 6fb0 */ 0,0xc5c3,0,0xdfb4,0,0xfaef,0,0, 0,0xdfb8,0,0,0,0,0,0, /* 0,'澱',0,'澳',0,'澵',0,0, 0,'澹',0,0,0,0,0,0, */
	/* 6fc0 */ 0xb7e3,0xc2f9,0xdfb2,0xc7bb,0,0,0xdfb9,0, 0,0,0,0,0,0,0,0, /* '激','濁','濂','濃',0,0,'濆',0, 0,0,0,0,0,0,0,0, */
	/* 6fd0 */ 0,0,0,0,0xdfbe,0xdfbc,0,0, 0xdfbf,0,0,0xdfc2,0,0,0,0xdfbb, /* 0,0,0,0,'濔','濕',0,0, '濘',0,0,'濛',0,0,0,'濟', */
	/* 6fe0 */ 0xb9ea,0xc7a8,0,0,0xdeb9,0,0,0, 0,0,0,0xcdf4,0xdfbd,0,0xdfc1,0xc2f5, /* '濠','濡',0,0,'濤',0,0,0, 0,0,0,'濫','濬',0,'濮','濯', */
	/* 6ff0 */ 0,0xdfc0,0,0xdfab,0,0xfaf0,0xefe9,0, 0,0,0xdfc5,0,0,0,0xdfc9,0, /* 0,'濱',0,'濳',0,'濵','濶',0, 0,0,'濺',0,0,0,'濾',0, */
	/* 7000 */ 0,0xdfc7,0,0,0,0xfaf1,0,0xfaf2, 0,0xdfc3,0,0xdfc4,0,0,0,0xdfc8, /* 0,'瀁',0,0,0,'瀅',0,'瀇', 0,'瀉',0,'瀋',0,0,0,'瀏', */
	/* 7010 */ 0,0xdfc6,0,0,0,0xc9ce,0,0, 0xdfce,0,0xdfcb,0xdfca,0,0xdfcd,0xc6d4,0xdfcf, /* 0,'瀑',0,0,0,'瀕',0,0, '瀘',0,'瀚','瀛',0,'瀝','瀞','瀟', */
	/* 7020 */ 0,0,0,0,0,0,0xc3f5,0xc2ed, 0xfaf3,0,0,0,0xc0a5,0,0,0, /* 0,0,0,0,0,0,'瀦','瀧', '瀨',0,0,0,'瀬',0,0,0, */
	/* 7030 */ 0xdfd0,0,0xdfd2,0,0,0,0,0, 0,0,0,0,0,0,0xdfd1,0, /* '瀰',0,'瀲',0,0,0,0,0, 0,0,0,0,0,0,'瀾',0, */
	/* 7040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xdef5,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'灌',0,0,0, */
	/* 7050 */ 0,0xdfd3,0,0,0,0,0,0, 0xc6e7,0,0,0,0,0,0,0, /* 0,'灑',0,0,0,0,0,0, '灘',0,0,0,0,0,0,0, */
	/* 7060 */ 0,0,0,0xdfd4,0,0,0,0, 0,0,0,0xb2d0,0,0,0,0xc5f4, /* 0,0,0,'灣',0,0,0,0, 0,0,0,'火',0,0,0,'灯', */
	/* 7070 */ 0xb3a5,0,0,0,0,0,0,0, 0xb5e4,0,0,0,0xbcde,0xbad2,0,0, /* '灰',0,0,0,0,0,0,0, '灸',0,0,0,'灼','災',0,0, */
	/* 7080 */ 0,0,0,0,0,0xfaf4,0,0, 0,0xcfa7,0xbfe6,0,0,0,0xb1ea,0, /* 0,0,0,0,0,'炅',0,0, 0,'炉','炊',0,0,0,'炎',0, */
	/* 7090 */ 0,0,0xdfd6,0,0,0,0,0, 0,0xdfd5,0,0,0,0,0,0, /* 0,0,'炒',0,0,0,0,0, 0,'炙',0,0,0,0,0,0, */
	/* 70a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0xfaf5,0xdfd9,0xc3ba,0xdfdc,0xdfd7, /* 0,0,0,0,0,0,0,0, 0,0,0,'炫','炬','炭','炮','炯', */
	/* 70b0 */ 0,0,0,0xdfdb,0,0,0,0, 0xdfda,0xc5c0,0xb0d9,0xf9a7,0,0,0,0, /* 0,0,0,'炳',0,0,0,0, '炸','点','為','炻',0,0,0,0, */
	/* 70c0 */ 0,0,0,0,0,0,0,0, 0xcef5,0,0,0xdfde,0,0,0,0xb1a8, /* 0,0,0,0,0,0,0,0, '烈',0,0,'烋',0,0,0,'烏', */
	/* 70d0 */ 0,0,0,0,0,0,0,0, 0,0xdfe0,0,0,0,0xdfdf,0,0xdfdd, /* 0,0,0,0,0,0,0,0, 0,'烙',0,0,0,'烝',0,'烟', */
	/* 70e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 70f0 */ 0,0xdfd8,0,0,0,0,0,0, 0,0xcba3,0,0,0,0xdfe2,0,0, /* 0,'烱',0,0,0,0,0,0, 0,'烹',0,0,0,'烽',0,0, */
	/* 7100 */ 0,0,0,0,0xfaf7,0,0,0, 0,0xdfe1,0,0,0,0,0,0xfaf6, /* 0,0,0,0,'焄',0,0,0, 0,'焉',0,0,0,0,0,'焏', */
	/* 7110 */ 0,0,0,0,0xb1eb,0,0,0, 0,0xdfe4,0xcab2,0,0xdfe3,0,0,0, /* 0,0,0,0,'焔',0,0,0, 0,'焙','焚',0,'焜',0,0,0, */
	/* 7120 */ 0,0xccb5,0,0,0,0,0xbec7,0, 0,0,0,0,0,0,0,0, /* 0,'無',0,0,0,0,'焦',0, 0,0,0,0,0,0,0,0, */
	/* 7130 */ 0,0,0,0,0,0,0xc1b3,0, 0,0,0,0,0xbec6,0,0,0, /* 0,0,0,0,0,0,'然',0, 0,0,0,0,'焼',0,0,0, */
	/* 7140 */ 0,0,0,0,0,0,0xfaf9,0xfafa, 0,0xcefb,0,0,0xdfea,0,0xc0f9,0, /* 0,0,0,0,0,0,'煆','煇', 0,'煉',0,0,'煌',0,'煎',0, */
	/* 7150 */ 0,0,0,0,0,0xdfe6,0xdfeb,0, 0,0xb1ec,0,0,0xfaf8,0,0,0, /* 0,0,0,0,0,'煕','煖',0, 0,'煙',0,0,'煜',0,0,0, */
	/* 7160 */ 0,0,0xdfe9,0,0xc7e1,0xdfe5,0xdfe8,0xbec8, 0,0xc8d1,0,0,0xdfec,0,0xbcd1,0, /* 0,0,'煢',0,'煤','煥','煦','照', 0,'煩',0,0,'煬',0,'煮',0, */
	/* 7170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xc0fa,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'煽',0,0, */
	/* 7180 */ 0,0,0,0,0xdfef,0,0,0, 0xdfe7,0,0xb7a7,0,0,0,0,0xdfed, /* 0,0,0,0,'熄',0,0,0, '熈',0,'熊',0,0,0,0,'熏', */
	/* 7190 */ 0,0,0,0,0xcdd0,0xdff0,0,0, 0,0xf4a6,0,0,0,0,0,0xbdcf, /* 0,0,0,0,'熔','熕',0,0, 0,'熙',0,0,0,0,0,'熟', */
	/* 71a0 */ 0,0,0,0,0,0,0,0, 0xdff1,0,0,0,0xdff2,0,0,0, /* 0,0,0,0,0,0,0,0, '熨',0,0,0,'熬',0,0,0, */
	/* 71b0 */ 0,0xc7ae,0,0,0,0,0,0, 0,0xdff4,0,0,0,0,0xdff5,0, /* 0,'熱',0,0,0,0,0,0, 0,'熹',0,0,0,0,'熾',0, */
	/* 71c0 */ 0,0xfafc,0,0xc7b3,0,0,0,0, 0xc5f5,0xdff7,0,0,0,0,0xdff9,0, /* 0,'燁',0,'燃',0,0,0,0, '燈','燉',0,0,0,0,'燎',0, */
	/* 71d0 */ 0xced5,0,0xdff6,0,0xdff8,0xb1ed,0,0xdff3, 0,0,0,0,0,0,0,0xd3db, /* '燐',0,'燒',0,'燔','燕',0,'燗', 0,0,0,0,0,0,0,'營', */
	/* 71e0 */ 0xdffa,0,0,0,0,0xc1e7,0xbbb8,0xdffc, 0,0,0,0,0xdffb,0xbfa4,0xd2d9,0, /* '燠',0,0,0,0,'燥','燦','燧', 0,0,0,0,'燬','燭','燮',0, */
	/* 71f0 */ 0,0,0,0,0,0xdffd,0,0, 0,0xe0a1,0,0xdfee,0xdffe,0,0xfafd,0xe0a2, /* 0,0,0,0,0,'燵',0,0, 0,'燹',0,'燻','燼',0,'燾','燿', */
	/* 7200 */ 0,0,0,0,0,0,0xc7fa,0, 0,0,0,0,0,0xe0a3,0,0, /* 0,0,0,0,0,0,'爆',0, 0,0,0,0,0,'爍',0,0, */
	/* 7210 */ 0xe0a4,0,0,0,0,0,0,0, 0,0,0,0xe0a5,0,0,0,0, /* '爐',0,0,0,0,0,0,0, 0,0,0,'爛',0,0,0,0, */
	/* 7220 */ 0,0,0,0,0,0,0,0, 0xe0a6,0,0xc4de,0,0xe0a8,0xe0a7,0,0, /* 0,0,0,0,0,0,0,0, '爨',0,'爪',0,'爬','爭',0,0, */
	/* 7230 */ 0xe0a9,0,0xe0aa,0,0,0xbcdf,0xc9e3,0, 0,0,0xccec,0xe0ab,0xe0ac,0xc1d6,0xbca4,0xe0ad, /* '爰',0,'爲',0,0,'爵','父',0, 0,0,'爺','爻','爼','爽','爾','爿', */
	/* 7240 */ 0xe0ae,0,0,0,0,0,0xe0af,0xcad2, 0xc8c7,0,0,0xe0b0,0xc7d7,0,0,0, /* '牀',0,0,0,0,0,'牆','片', '版',0,0,'牋','牌',0,0,0, */
	/* 7250 */ 0,0,0xc4ad,0,0,0,0,0, 0xe0b1,0xb2e7,0,0xb5ed,0,0xccc6,0,0xccb6, /* 0,0,'牒',0,0,0,0,0, '牘','牙',0,'牛',0,'牝',0,'牟', */
	/* 7260 */ 0,0xb2b4,0xcfb4,0,0,0,0,0xcbd2, 0,0xcaaa,0,0,0,0,0,0, /* 0,'牡','牢',0,0,0,0,'牧', 0,'物',0,0,0,0,0,0, */
	/* 7270 */ 0,0,0xc0b7,0,0xe0b2,0,0,0, 0,0xc6c3,0,0,0,0xb8a3,0xe0b3,0, /* 0,0,'牲',0,'牴',0,0,0, 0,'特',0,0,0,'牽','牾',0, */
	/* 7280 */ 0xbad4,0xe0b5,0xe0b4,0,0,0,0,0xe0b6, 0,0,0,0,0,0,0,0, /* '犀','犁','犂',0,0,0,0,'犇', 0,0,0,0,0,0,0,0, */
	/* 7290 */ 0,0,0xe0b7,0,0,0,0xe0b8,0, 0,0,0,0,0,0,0,0, /* 0,0,'犒',0,0,0,'犖',0, 0,0,0,0,0,0,0,0, */
	/* 72a0 */ 0xb5be,0,0xe0b9,0,0,0,0,0xe0ba, 0,0,0,0,0xb8a4,0,0,0xc8c8, /* '犠',0,'犢',0,0,0,0,'犧', 0,0,0,0,'犬',0,0,'犯', */
	/* 72b0 */ 0,0xfafe,0xe0bc,0,0,0,0xbef5,0, 0,0xe0bb,0,0,0,0,0xfba1,0, /* 0,'犱','犲',0,0,0,'状',0, 0,'犹',0,0,0,0,'犾',0, */
	/* 72c0 */ 0,0,0xb6b8,0xe0bd,0xe0bf,0,0xe0be,0, 0,0,0,0,0,0,0xe0c0,0, /* 0,0,'狂','狃','狄',0,'狆',0, 0,0,0,0,0,0,'狎',0, */
	/* 72d0 */ 0xb8d1,0,0xe0c1,0,0,0,0,0xb6e9, 0,0xc1c0,0,0xb9fd,0,0,0,0, /* '狐',0,'狒',0,0,0,0,'狗', 0,'狙',0,'狛',0,0,0,0, */
	/* 72e0 */ 0xe0c3,0xe0c4,0xe0c2,0,0,0,0,0, 0,0xbced,0,0,0xc6c8,0xb6b9,0,0, /* '狠','狡','狢',0,0,0,0,0, 0,'狩',0,0,'独','狭',0,0, */
	/* 72f0 */ 0,0,0,0,0,0,0,0xe0c6, 0xc3ac,0xe0c5,0,0,0xcfb5,0xc7e2,0,0, /* 0,0,0,0,0,0,0,'狷', '狸','狹',0,0,'狼','狽',0,0, */
	/* 7300 */ 0,0,0,0,0,0,0,0, 0,0,0xe0c9,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'猊',0,0,0,0,0, */
	/* 7310 */ 0,0,0,0,0,0,0xe0cb,0xe0c8, 0,0,0,0xccd4,0xe0ca,0xe0cc,0,0xcec4, /* 0,0,0,0,0,0,'猖','猗', 0,0,0,'猛','猜','猝',0,'猟', */
	/* 7320 */ 0,0,0,0,0xfba2,0xe0d0,0,0, 0,0xe0cf,0xc3f6,0xc7ad,0,0,0xb8a5,0xe0ce, /* 0,0,0,0,'猤','猥',0,0, 0,'猩','猪','猫',0,0,'献','猯', */
	/* 7330 */ 0,0,0,0,0xe0cd,0,0xcdb1,0xcdb2, 0,0,0,0,0,0,0xe0d1,0xb1ee, /* 0,0,0,0,'猴',0,'猶','猷', 0,0,0,0,0,0,'猾','猿', */
	/* 7340 */ 0,0,0,0,0xb9f6,0xbbe2,0,0, 0,0,0,0,0,0,0xe0d2,0xe0d3, /* 0,0,0,0,'獄','獅',0,0, 0,0,0,0,0,0,'獎','獏', */
	/* 7350 */ 0,0,0,0,0,0,0,0xe0d5, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'獗', 0,0,0,0,0,0,0,0, */
	/* 7360 */ 0,0,0,0xbdc3,0,0,0,0, 0xe0d7,0,0xe0d6,0,0,0,0,0, /* 0,0,0,'獣',0,0,0,0, '獨',0,'獪',0,0,0,0,0, */
	/* 7370 */ 0xe0d8,0,0xb3cd,0,0,0xe0da,0,0xfba4, 0xe0d9,0,0xe0dc,0xe0db,0,0,0,0, /* '獰',0,'獲',0,0,'獵',0,'獷', '獸',0,'獺','獻',0,0,0,0, */
	/* 7380 */ 0,0,0,0,0xb8bc,0,0,0xcea8, 0,0xb6cc,0,0xb2a6,0,0,0,0, /* 0,0,0,0,'玄',0,0,'率', 0,'玉',0,'王',0,0,0,0, */
	/* 7390 */ 0,0,0,0,0,0,0xb6ea,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'玖',0, 0,0,0,0,0,0,0,0, */
	/* 73a0 */ 0,0,0,0,0,0,0,0, 0,0xb4e1,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'玩',0,0,0,0,0,0, */
	/* 73b0 */ 0,0,0xcee8,0xe0de,0,0,0,0, 0,0,0,0xe0e0,0,0xfba5,0,0, /* 0,0,'玲','玳',0,0,0,0, 0,0,0,'玻',0,'玽',0,0, */
	/* 73c0 */ 0xe0e1,0,0xb2d1,0,0,0,0,0, 0xe0dd,0xfba6,0xbbb9,0,0,0xc4c1,0xe0df,0, /* '珀',0,'珂',0,0,0,0,0, '珈','珉','珊',0,0,'珍','珎',0, */
	/* 73d0 */ 0,0,0xfba9,0,0,0,0xfba7,0, 0,0,0,0,0,0,0xe0e4,0, /* 0,0,'珒',0,0,0,'珖',0, 0,0,0,0,0,0,'珞',0, */
	/* 73e0 */ 0xbcee,0,0,0xfba8,0,0xe0e2,0,0, 0,0,0xb7be,0,0,0xc8c9,0xe0e3,0, /* '珠',0,0,'珣',0,'珥',0,0, 0,0,'珪',0,0,'班','珮',0, */
	/* 73f0 */ 0,0xe0fe,0,0,0,0xfbab,0,0, 0xe0e9,0,0,0,0,0,0xb8bd,0, /* 0,'珱',0,0,0,'珵',0,0, '珸',0,0,0,0,0,'現',0, */
	/* 7400 */ 0,0,0,0xb5e5,0,0xe0e6,0xcdfd,0xfbaa, 0,0xceb0,0,0,0,0,0,0, /* 0,0,0,'球',0,'琅','理','琇', 0,'琉',0,0,0,0,0,0, */
	/* 7410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7420 */ 0,0,0xc2f6,0,0,0xe0e8,0xfbac,0, 0,0xfbae,0xfbad,0,0,0,0xfbaf,0, /* 0,0,'琢',0,0,'琥','琦',0, 0,'琩','琪',0,0,0,'琮',0, */
	/* 7430 */ 0,0,0xe0ea,0xced6,0xb6d7,0xc8fc,0xc7ca,0, 0,0,0xe0eb,0,0,0,0,0xe0ed, /* 0,0,'琲','琳','琴','琵','琶',0, 0,0,'琺',0,0,0,0,'琿', */
	/* 7440 */ 0,0xe0f0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'瑁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7450 */ 0,0,0,0,0,0xe0ec,0,0, 0,0xe0ef,0xb8ea,0xb1cd,0xe0f1,0,0xbff0,0xe0ee, /* 0,0,0,0,0,'瑕',0,0, 0,'瑙','瑚','瑛','瑜',0,'瑞','瑟', */
	/* 7460 */ 0xcedc,0,0xfbb0,0xe0f4,0xf4a4,0,0,0, 0,0xe0f2,0xe0f5,0,0,0,0,0xe0e7, /* '瑠',0,'瑢','瑣','瑤',0,0,0, 0,'瑩','瑪',0,0,0,0,'瑯', */
	/* 7470 */ 0xe0f3,0,0,0xbabc,0,0,0xe0f6,0, 0,0,0,0,0,0,0xe0f7,0, /* '瑰',0,0,'瑳',0,0,'瑶',0, 0,0,0,0,0,0,'瑾',0, */
	/* 7480 */ 0,0,0,0xcdfe,0,0,0,0, 0,0xfbb1,0,0xe0f8,0,0,0,0, /* 0,0,0,'璃',0,0,0,0, 0,'璉',0,'璋',0,0,0,0, */
	/* 7490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xe0f9,0xfbb2, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'璞','璟', */
	/* 74a0 */ 0,0,0xe0e5,0,0,0,0,0xe0fa, 0,0,0,0,0,0,0,0, /* 0,0,'璢',0,0,0,0,'璧', 0,0,0,0,0,0,0,0, */
	/* 74b0 */ 0xb4c4,0,0,0,0,0,0,0, 0,0,0,0,0,0xbca5,0,0, /* '環',0,0,0,0,0,0,0, 0,0,0,0,0,'璽',0,0, */
	/* 74c0 */ 0,0,0,0,0,0,0,0, 0,0,0xe0fb,0,0,0,0,0xe0fc, /* 0,0,0,0,0,0,0,0, 0,0,'瓊',0,0,0,0,'瓏', */
	/* 74d0 */ 0,0,0,0,0xe0fd,0,0,0, 0,0,0,0,0xb1bb,0,0,0, /* 0,0,0,0,'瓔',0,0,0, 0,0,0,0,'瓜',0,0,0, */
	/* 74e0 */ 0xe1a1,0,0xc9bb,0xe1a2,0,0,0xb4a4,0xe1a3, 0,0xe1a4,0,0,0,0,0xe1a5,0, /* '瓠',0,'瓢','瓣',0,0,'瓦','瓧', 0,'瓩',0,0,0,0,'瓮',0, */
	/* 74f0 */ 0xe1a7,0xe1a8,0xe1a6,0,0,0,0xc9d3,0xe1aa, 0xe1a9,0,0,0,0,0,0,0, /* '瓰','瓱','瓲',0,0,0,'瓶','瓷', '瓸',0,0,0,0,0,0,0, */
	/* 7500 */ 0,0xfbb3,0,0xe1ac,0xe1ab,0xe1ad,0,0, 0,0,0,0,0xe1ae,0xe1b0,0xe1af,0, /* 0,'甁',0,'甃','甄','甅',0,0, 0,0,0,0,'甌','甍','甎',0, */
	/* 7510 */ 0,0xb9f9,0,0xe1b2,0,0xe1b1,0,0, 0xb4c5,0,0xbfd3,0,0xc5bc,0,0xe1b3,0xc0b8, /* 0,'甑',0,'甓',0,'甕',0,0, '甘',0,'甚',0,'甜',0,'甞','生', */
	/* 7520 */ 0,0,0,0xbbba,0,0xb1f9,0xe1b4,0, 0xcdd1,0,0,0xcae3,0xe1b5,0,0,0xf9ec, /* 0,0,0,'産',0,'甥','甦',0, '用',0,0,'甫','甬',0,0,'甯', */
	/* 7530 */ 0xc5c4,0xcdb3,0xb9c3,0xbfbd,0,0,0,0xc3cb, 0xd2b4,0,0xc4ae,0xb2e8,0xe1b6,0,0,0, /* '田','由','甲','申',0,0,0,'男', '甸',0,'町','画','甼',0,0,0, */
	/* 7540 */ 0,0,0,0,0xe1b7,0,0xe1bc,0, 0,0xe1ba,0xe1b9,0xdac2,0xb3a6,0xe1b8,0,0xb0da, /* 0,0,0,0,'畄',0,'畆',0, 0,'畉','畊','畋','界','畍',0,'畏', */
	/* 7550 */ 0,0xc8aa,0,0,0xc8ca,0,0,0, 0,0xceb1,0xe1bd,0xe1bb,0xc3dc,0xc0a6,0,0, /* 0,'畑',0,0,'畔',0,0,0, 0,'留','畚','畛','畜','畝',0,0, */
	/* 7560 */ 0xc8ab,0,0xc9ad,0,0xe1bf,0xceac,0xb7cd,0xe1c0, 0,0xe1be,0xc8d6,0xe1c1,0,0xe1c2,0,0xfbb4, /* '畠',0,'畢',0,'畤','略','畦','畧', 0,'畩','番','畫',0,'畭',0,'畯', */
	/* 7570 */ 0xb0db,0,0,0xbef6,0xe1c7,0,0xe1c4,0xc6ed, 0xe1c3,0,0,0,0,0,0,0xb5a6, /* '異',0,0,'畳','畴',0,'當','畷', '畸',0,0,0,0,0,0,'畿', */
	/* 7580 */ 0,0,0xe1ca,0,0,0,0xe1c5,0xe1c6, 0,0xe1c9,0xe1c8,0xc9a5,0,0,0xc1c2,0xc1c1, /* 0,0,'疂',0,0,0,'疆','疇', 0,'疉','疊','疋',0,0,'疎','疏', */
	/* 7590 */ 0,0xb5bf,0,0,0xe1cb,0,0,0, 0,0,0xe1cc,0,0,0xe1cd,0,0, /* 0,'疑',0,0,'疔',0,0,0, 0,0,'疚',0,0,'疝',0,0, */
	/* 75a0 */ 0,0,0,0xe1cf,0,0xe1ce,0,0, 0,0,0,0xb1d6,0,0,0,0, /* 0,0,0,'疣',0,'疥',0,0, 0,0,0,'疫',0,0,0,0, */
	/* 75b0 */ 0,0xe1d7,0xc8e8,0xe1d1,0,0xe1d3,0,0, 0xe1d5,0xbfbe,0,0,0xe1d6,0xe1d4,0xbcc0,0, /* 0,'疱','疲','疳',0,'疵',0,0, '疸','疹',0,0,'疼','疽','疾',0, */
	/* 75c0 */ 0,0,0xe1d0,0xe1d2,0,0xc9c2,0,0xbec9, 0,0,0xe1d9,0,0,0xe1d8,0,0, /* 0,0,'痂','痃',0,'病',0,'症', 0,0,'痊',0,0,'痍',0,0, */
	/* 75d0 */ 0,0,0xe1da,0,0xbca6,0xbaaf,0,0, 0xc5f7,0xe1db,0,0xc4cb,0,0,0xe1dd,0, /* 0,0,'痒',0,'痔','痕',0,0, '痘','痙',0,'痛',0,0,'痞',0, */
	/* 75e0 */ 0,0,0xcea1,0xe1dc,0,0,0,0, 0,0xc1e9,0,0,0,0,0,0, /* 0,0,'痢','痣',0,0,0,0, 0,'痩',0,0,0,0,0,0, */
	/* 75f0 */ 0xe1e2,0,0xe1e4,0xe1e5,0xc3d4,0,0,0, 0,0,0xe1e3,0,0xe1e0,0,0xe1de,0xe1df, /* '痰',0,'痲','痳','痴',0,0,0, 0,0,'痺',0,'痼',0,'痾','痿', */
	/* 7600 */ 0,0xe1e1,0,0,0,0,0,0, 0,0xe1e8,0,0xe1e6,0,0xe1e7,0,0, /* 0,'瘁',0,0,0,0,0,0, 0,'瘉',0,'瘋',0,'瘍',0,0, */
	/* 7610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xe1e9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'瘟', */
	/* 7620 */ 0xe1eb,0xe1ec,0xe1ed,0,0xe1ee,0,0,0xe1ea, 0,0,0,0,0,0,0,0, /* '瘠','瘡','瘢',0,'瘤',0,0,'瘧', 0,0,0,0,0,0,0,0, */
	/* 7630 */ 0xe1f0,0,0,0,0xe1ef,0,0,0, 0,0,0,0xe1f1,0,0,0,0, /* '瘰',0,0,0,'瘴',0,0,0, 0,0,0,'瘻',0,0,0,0, */
	/* 7640 */ 0,0,0xcec5,0,0,0,0xe1f4,0xe1f2, 0xe1f3,0,0,0,0xb4e2,0,0,0, /* 0,0,'療',0,0,0,'癆','癇', '癈',0,0,0,'癌',0,0,0, */
	/* 7650 */ 0,0,0xccfe,0,0,0,0xcaca,0, 0xe1f6,0,0,0,0xe1f5,0,0,0, /* 0,0,'癒',0,0,0,'癖',0, '癘',0,0,0,'癜',0,0,0, */
	/* 7660 */ 0,0xe1f7,0xe1f8,0,0,0,0,0xe1fc, 0xe1f9,0xe1fa,0xe1fb,0,0xe1fd,0,0,0, /* 0,'癡','癢',0,0,0,0,'癧', '癨','癩','癪',0,'癬',0,0,0, */
	/* 7670 */ 0xe1fe,0,0xe2a1,0,0,0,0xe2a2,0, 0xe2a3,0,0xc8af,0xc5d0,0xe2a4,0xc7f2,0xc9b4,0, /* '癰',0,'癲',0,0,0,'癶',0, '癸',0,'発','登','發','白','百',0, */
	/* 7680 */ 0xe2a5,0,0xfbb5,0xe2a6,0xc5aa,0,0xb3a7,0xb9c4, 0xe2a7,0,0,0xe2a8,0,0,0xe2a9,0, /* '皀',0,'皂','皃','的',0,'皆','皇', '皈',0,0,'皋',0,0,'皎',0, */
	/* 7690 */ 0xbba9,0,0,0xe2ab,0,0,0xe2aa,0, 0,0xe2ac,0xe2ad,0xfbb8,0xfbb6,0,0xfbb7,0, /* '皐',0,0,'皓',0,0,'皖',0, 0,'皙','皚','皛','皜',0,'皞',0, */
	/* 76a0 */ 0,0,0,0,0,0,0xfbb9,0, 0,0,0,0,0,0,0xc8e9,0, /* 0,0,0,0,0,0,'皦',0, 0,0,0,0,0,0,'皮',0, */
	/* 76b0 */ 0xe2ae,0,0,0,0xe2af,0,0,0xf3e9, 0xe2b0,0xe2b1,0xe2b2,0,0,0,0,0xbbae, /* '皰',0,0,0,'皴',0,0,'皷', '皸','皹','皺',0,0,0,0,'皿', */
	/* 76c0 */ 0,0,0xe2b3,0xc7d6,0,0,0xcbdf,0, 0xb1ce,0,0xb1d7,0,0,0xe2b4,0,0, /* 0,0,'盂','盃',0,0,'盆',0, '盈',0,'益',0,0,'盍',0,0, */
	/* 76d0 */ 0,0,0xe2b6,0,0,0,0xe2b5,0xc5f0, 0,0,0,0xc0b9,0xddb9,0,0xe2b7,0xccc1, /* 0,0,'盒',0,0,0,'盖','盗', 0,0,0,'盛','盜',0,'盞','盟', */
	/* 76e0 */ 0,0xe2b8,0,0xb4c6,0xc8d7,0xe2b9,0,0xe2ba, 0,0,0xe2bb,0,0,0,0xccdc,0, /* 0,'盡',0,'監','盤','盥',0,'盧', 0,0,'盪',0,0,0,'目',0, */
	/* 76f0 */ 0,0,0xccd5,0,0xc4be,0,0,0, 0xc1ea,0,0,0xe2bd,0,0,0xbde2,0, /* 0,0,'盲',0,'直',0,0,0, '相',0,0,'盻',0,0,'盾',0, */
	/* 7700 */ 0,0xbeca,0,0,0xe2c0,0,0,0xe2bf, 0xe2be,0xc8fd,0,0xb4c7,0xb8a9,0,0,0, /* 0,'省',0,0,'眄',0,0,'眇', '眈','眉',0,'看','県',0,0,0, */
	/* 7710 */ 0,0,0,0,0,0,0,0, 0,0,0,0xe2c6,0,0,0xe2c3,0xbfbf, /* 0,0,0,0,0,0,0,0, 0,0,0,'眛',0,0,'眞','真', */
	/* 7720 */ 0xccb2,0,0,0,0xe2c2,0xe2c4,0xe2c5,0, 0,0xe2c1,0,0,0,0,0,0, /* '眠',0,0,0,'眤','眥','眦',0, 0,'眩',0,0,0,0,0,0, */
	/* 7730 */ 0,0,0,0,0,0,0,0xe2c7, 0xe2c8,0,0xc4af,0,0xb4e3,0,0,0, /* 0,0,0,0,0,0,0,'眷', '眸',0,'眺',0,'眼',0,0,0, */
	/* 7740 */ 0xc3e5,0,0,0,0,0,0xfbbb,0xe2c9, 0,0,0,0,0,0,0,0, /* '着',0,0,0,0,0,'睆','睇', 0,0,0,0,0,0,0,0, */
	/* 7750 */ 0,0,0,0,0,0,0,0, 0,0,0xe2ca,0xe2cd,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'睚','睛',0,0,0,0, */
	/* 7760 */ 0,0xbfe7,0,0xc6c4,0,0xe2ce,0xcbd3,0, 0xe2cb,0,0,0xe2cc,0,0,0,0, /* 0,'睡',0,'督',0,'睥','睦',0, '睨',0,0,'睫',0,0,0,0, */
	/* 7770 */ 0,0,0,0,0,0,0,0, 0,0xe2d1,0,0,0,0,0xe2d0,0xe2cf, /* 0,0,0,0,0,0,0,0, 0,'睹',0,0,0,0,'睾','睿', */
	/* 7780 */ 0,0,0,0,0,0,0,0, 0,0,0,0xe2d3,0,0,0xe2d2,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'瞋',0,0,'瞎',0, */
	/* 7790 */ 0,0xe2d4,0,0,0,0,0,0, 0,0,0,0,0,0,0xe2d6,0, /* 0,'瞑',0,0,0,0,0,0, 0,0,0,0,0,0,'瞞',0, */
	/* 77a0 */ 0xe2d5,0,0,0,0,0xcacd,0,0, 0,0,0,0,0xbdd6,0xcec6,0,0, /* '瞠',0,0,0,0,'瞥',0,0, 0,0,0,0,'瞬','瞭',0,0, */
	/* 77b0 */ 0xe2d7,0,0,0xc6b7,0,0,0xe2d8,0, 0,0xe2d9,0,0xe2dd,0xe2db,0xe2dc,0,0xe2da, /* '瞰',0,0,'瞳',0,0,'瞶',0, 0,'瞹',0,'瞻','瞼','瞽',0,'瞿', */
	/* 77c0 */ 0,0,0,0,0,0,0,0xe2de, 0,0,0,0,0,0xe2df,0,0, /* 0,0,0,0,0,0,0,'矇', 0,0,0,0,0,'矍',0,0, */
	/* 77d0 */ 0,0,0,0,0,0,0,0xe2e0, 0,0,0xe2e1,0xccb7,0xe2e2,0,0,0, /* 0,0,0,0,0,0,0,'矗', 0,0,'矚','矛','矜',0,0,0, */
	/* 77e0 */ 0,0,0xccf0,0xe2e3,0,0xc3ce,0,0xc7ea, 0,0xb6eb,0,0,0,0xc3bb,0xe2e4,0xb6ba, /* 0,0,'矢','矣',0,'知',0,'矧', 0,'矩',0,0,0,'短','矮','矯', */
	/* 77f0 */ 0,0,0,0xc0d0,0,0,0,0, 0,0,0,0,0xe2e5,0,0,0, /* 0,0,0,'石',0,0,0,0, 0,0,0,0,'矼',0,0,0, */
	/* 7800 */ 0,0,0xbabd,0,0,0,0,0, 0,0,0,0,0xe2e6,0,0,0, /* 0,0,'砂',0,0,0,0,0, 0,0,0,0,'砌',0,0,0, */
	/* 7810 */ 0,0,0xe2e7,0,0xb8a6,0xbad5,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'砒',0,'研','砕',0,0, 0,0,0,0,0,0,0,0, */
	/* 7820 */ 0xe2e9,0xfbbd,0,0,0,0xc5d6,0xbad6,0xb5ce, 0,0,0,0,0,0,0,0, /* '砠','砡',0,0,0,'砥','砦','砧', 0,0,0,0,0,0,0,0, */
	/* 7830 */ 0,0,0xcba4,0,0xc7cb,0,0,0, 0,0,0xc5d7,0,0,0,0,0xb9dc, /* 0,0,'砲',0,'破',0,0,0, 0,0,'砺',0,0,0,0,'砿', */
	/* 7840 */ 0,0,0,0,0,0xe2eb,0,0, 0,0,0,0,0,0,0xfbbe,0, /* 0,0,0,0,0,'硅',0,0, 0,0,0,0,0,0,'硎',0, */
	/* 7850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xbecb,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'硝',0,0, */
	/* 7860 */ 0,0,0,0,0xfbbf,0,0,0, 0,0,0,0xceb2,0xb9c5,0,0,0xb8a7, /* 0,0,0,0,'硤',0,0,0, 0,0,0,'硫','硬',0,0,'硯', */
	/* 7870 */ 0,0,0xc8a3,0,0xe2ed,0,0,0, 0,0,0xfbc0,0,0xe2ef,0,0,0, /* 0,0,'硲',0,'硴',0,0,0, 0,0,'硺',0,'硼',0,0,0, */
	/* 7880 */ 0,0xb8eb,0,0,0,0,0xe2ee,0xc4f6, 0,0,0,0,0xe2f1,0xb3b7,0xe2ec,0, /* 0,'碁',0,0,0,0,'碆','碇', 0,0,0,0,'碌','碍','碎',0, */
	/* 7890 */ 0,0xc8ea,0,0xb1b0,0,0xbaec,0,0xcfd2, 0,0,0xe2f0,0,0,0,0,0, /* 0,'碑',0,'碓',0,'碕',0,'碗', 0,0,'碚',0,0,0,0,0, */
	/* 78a0 */ 0,0,0,0xe2f2,0,0,0,0xcacb, 0,0xc0d9,0xe2f4,0,0,0,0,0xe2f5, /* 0,0,0,'碣',0,0,0,'碧', 0,'碩','碪',0,0,0,0,'碯', */
	/* 78b0 */ 0,0,0,0,0,0xe2f3,0,0, 0,0,0xb3ce,0,0xe2fb,0,0xe2fa,0, /* 0,0,0,0,0,'碵',0,0, 0,0,'確',0,'碼',0,'碾',0, */
	/* 78c0 */ 0,0xbca7,0,0,0,0xe2fc,0xe2f7,0, 0,0,0xe2fd,0xe2f8,0,0,0,0, /* 0,'磁',0,0,0,'磅','磆',0, 0,0,'磊','磋',0,0,0,0, */
	/* 78d0 */ 0xc8d8,0xe2f6,0,0,0xe2f9,0,0,0, 0,0,0xe3a2,0,0,0,0,0, /* '磐','磑',0,0,'磔',0,0,0, 0,0,'磚',0,0,0,0,0, */
	/* 78e0 */ 0,0,0,0,0,0,0,0xe3a1, 0xcbe1,0,0,0,0xe2fe,0,0,0xb0eb, /* 0,0,0,0,0,0,0,'磧', '磨',0,0,0,'磬',0,0,'磯', */
	/* 78f0 */ 0,0,0,0,0xe3a4,0,0,0, 0,0,0,0,0,0xe3a3,0,0, /* 0,0,0,0,'磴',0,0,0, 0,0,0,0,0,'磽',0,0, */
	/* 7900 */ 0,0xbecc,0,0,0,0,0,0xe3a5, 0,0,0,0,0,0,0xc1c3,0, /* 0,'礁',0,0,0,0,0,'礇', 0,0,0,0,0,0,'礎',0, */
	/* 7910 */ 0,0xe3a7,0xe3a6,0,0,0,0,0, 0,0xe3a8,0,0,0,0,0,0, /* 0,'礑','礒',0,0,0,0,0, 0,'礙',0,0,0,0,0,0, */
	/* 7920 */ 0,0,0,0,0,0,0xe2e8,0, 0,0,0xe2ea,0xe3aa,0xe3a9,0,0,0, /* 0,0,0,0,0,0,'礦',0, 0,0,'礪','礫','礬',0,0,0, */
	/* 7930 */ 0xfbc1,0,0,0,0,0,0,0, 0,0,0xbca8,0,0xcee9,0,0xbcd2,0, /* '礰',0,0,0,0,0,0,0, 0,0,'示',0,'礼',0,'社',0, */
	/* 7940 */ 0xe3ab,0xb7b7,0,0,0,0,0,0xb5c0, 0xb5a7,0xbbe3,0,0,0,0,0,0, /* '祀','祁',0,0,0,0,0,'祇', '祈','祉',0,0,0,0,0,0, */
	/* 7950 */ 0xcdb4,0,0,0xe3b1,0,0xe3b0,0xc1c4,0xe3ad, 0,0,0xe3af,0,0,0xbdcb,0xbfc0,0xe3ae, /* '祐',0,0,'祓',0,'祕','祖','祗', 0,0,'祚',0,0,'祝','神','祟', */
	/* 7960 */ 0xe3ac,0,0xc7aa,0,0,0xbecd,0,0, 0xc9bc,0,0,0,0,0xbad7,0,0, /* '祠',0,'祢',0,0,'祥',0,0, '票',0,0,0,0,'祭',0,0, */
	/* 7970 */ 0,0,0,0,0,0,0,0xc5f8, 0,0,0xe3b2,0,0,0,0,0xe3b3, /* 0,0,0,0,0,0,0,'祷', 0,0,'祺',0,0,0,0,'祿', */
	/* 7980 */ 0xe3c9,0xb6d8,0,0,0xcfbd,0xc1b5,0,0, 0,0,0xe3b4,0,0,0xb2d2,0xc4f7,0xcaa1, /* '禀','禁',0,0,'禄','禅',0,0, 0,0,'禊',0,0,'禍','禎','福', */
	/* 7990 */ 0,0,0,0,0xfbc5,0,0,0, 0,0,0,0xfbc7,0,0xe3b5,0,0, /* 0,0,0,0,'禔',0,0,0, 0,0,0,'禛',0,'禝',0,0, */
	/* 79a0 */ 0,0,0,0,0,0,0xb5fa,0xe3b6, 0,0,0xe3b8,0,0,0,0xe3b9,0, /* 0,0,0,0,0,0,'禦','禧', 0,0,'禪',0,0,0,'禮',0, */
	/* 79b0 */ 0xc7a9,0,0,0xe3ba,0,0,0,0, 0,0xe3bb,0xe3bc,0,0,0xb6d9,0xb2d3,0xc6c5, /* '禰',0,0,'禳',0,0,0,0, 0,'禹','禺',0,0,'禽','禾','禿', */
	/* 79c0 */ 0xbda8,0xbbe4,0,0,0,0,0,0, 0,0xe3bd,0,0xbda9,0,0,0,0, /* '秀','私',0,0,0,0,0,0, 0,'秉',0,'秋',0,0,0,0, */
	/* 79d0 */ 0,0xb2ca,0xc9c3,0,0,0xe3be,0,0, 0xc8eb,0,0,0,0,0,0,0xc1c5, /* 0,'科','秒',0,0,'秕',0,0, '秘',0,0,0,0,0,0,'租', */
	/* 79e0 */ 0,0xe3c1,0,0xe3c2,0xc7e9,0,0xbfc1,0xe3bf, 0,0xc3e1,0,0,0xe3c0,0,0,0, /* 0,'秡',0,'秣','秤',0,'秦','秧', 0,'秩',0,0,'秬',0,0,0, */
	/* 79f0 */ 0xbece,0,0,0,0,0,0,0, 0,0,0,0xb0dc,0,0,0,0, /* '称',0,0,0,0,0,0,0, 0,0,0,'移',0,0,0,0, */
	/* 7a00 */ 0xb5a9,0,0,0,0,0,0,0, 0xe3c3,0,0,0xc4f8,0,0xe3c4,0xc0c7,0, /* '稀',0,0,0,0,0,0,0, '稈',0,0,'程',0,'稍','税',0, */
	/* 7a10 */ 0,0,0,0,0xccad,0,0,0xc9a3, 0xe3c5,0xe3c6,0xc3d5,0,0xcec7,0,0,0xe3c8, /* 0,0,0,0,'稔',0,0,'稗', '稘','稙','稚',0,'稜',0,0,'稟', */
	/* 7a20 */ 0xe3c7,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xbcef,0, /* '稠',0,0,0,0,0,0,0, 0,0,0,0,0,0,'種',0, */
	/* 7a30 */ 0,0xe3ca,0xb0f0,0,0,0,0,0xe3cd, 0,0,0,0xe3cb,0xb2d4,0xb7ce,0xe3cc,0xb9c6, /* 0,'稱','稲',0,0,0,0,'稷', 0,0,0,'稻','稼','稽','稾','稿', */
	/* 7a40 */ 0xb9f2,0,0xcae6,0xe3ce,0,0,0xcbd4,0, 0,0xe3d0,0,0,0,0xc0d1,0xb1cf,0xb2ba, /* '穀',0,'穂','穃',0,0,'穆',0, 0,'穉',0,0,0,'積','穎','穏', */
	/* 7a50 */ 0xb0ac,0,0,0,0,0,0,0xe3cf, 0,0,0,0,0,0,0,0, /* '穐',0,0,0,0,0,0,'穗', 0,0,0,0,0,0,0,0, */
	/* 7a60 */ 0,0xe3d1,0xe3d2,0xbef7,0,0,0,0, 0,0xe3d3,0,0xb3cf,0,0,0,0, /* 0,'穡','穢','穣',0,0,0,0, 0,'穩',0,'穫',0,0,0,0, */
	/* 7a70 */ 0xe3d5,0,0,0,0xb7ea,0,0xb5e6,0, 0,0xe3d6,0xb6f5,0,0,0xe3d7,0,0xc0fc, /* '穰',0,0,0,'穴',0,'究',0, 0,'穹','空',0,0,'穽',0,'穿', */
	/* 7a80 */ 0,0xc6cd,0,0xc0e0,0xbaf5,0,0,0, 0xe3d8,0,0,0,0,0,0,0, /* 0,'突',0,'窃','窄',0,0,0, '窈',0,0,0,0,0,0,0, */
	/* 7a90 */ 0,0,0xc3e2,0xc1eb,0,0xe3da,0xe3dc,0xe3d9, 0xe3db,0,0,0,0,0,0,0xb7a2, /* 0,0,'窒','窓',0,'窕','窖','窗', '窘',0,0,0,0,0,0,'窟', */
	/* 7aa0 */ 0,0,0,0,0,0,0,0, 0,0xe3dd,0xb7a6,0,0,0,0xb5e7,0xcdd2, /* 0,0,0,0,0,0,0,0, 0,'窩','窪',0,0,0,'窮','窯', */
	/* 7ab0 */ 0xe3df,0,0,0,0,0,0xe3e0,0, 0,0,0xb1ae,0,0,0,0,0xe3e3, /* '窰',0,0,0,0,0,'窶',0, 0,0,'窺',0,0,0,0,'窿', */
	/* 7ac0 */ 0,0,0,0xb3f6,0xe3e2,0xe3e1,0,0xe3e5, 0xe3de,0,0xe3e6,0xcea9,0,0xe3e7,0,0xe3e8, /* 0,0,0,'竃','竄','竅',0,'竇', '竈',0,'竊','立',0,'竍',0,'竏', */
	/* 7ad0 */ 0,0xfbc8,0xd4f4,0xe3ea,0,0xe3e9,0,0, 0,0xe3eb,0xe3ec,0,0xceb5,0xe3ed,0,0xf0ef, /* 0,'竑','竒','竓',0,'竕',0,0, 0,'站','竚',0,'竜','竝',0,'竟', */
	/* 7ae0 */ 0xbecf,0xe3ee,0xe3ef,0xbdd7,0,0xc6b8,0xe3f0,0xfbc9, 0,0,0xc3a8,0xfbcb,0,0xe3f1,0,0xc3bc, /* '章','竡','竢','竣',0,'童','竦','竧', 0,0,'竪','竫',0,'竭',0,'端', */
	/* 7af0 */ 0xe3f2,0,0,0,0,0,0xb6a5,0, 0xd1bf,0xc3dd,0xbcb3,0,0,0,0,0xb4c8, /* '竰',0,0,0,0,0,'競',0, '竸','竹','竺',0,0,0,0,'竿', */
	/* 7b00 */ 0,0,0xe3f3,0,0xe4a2,0,0xe3f6,0, 0xb5e8,0,0xe3f5,0xe4a4,0,0,0,0xe3f4, /* 0,0,'笂',0,'笄',0,'笆',0, '笈',0,'笊','笋',0,0,0,'笏', */
	/* 7b10 */ 0,0xbed0,0,0,0,0,0,0, 0xe3f8,0xe3f9,0,0xc5ab,0,0,0xe3fa,0, /* 0,'笑',0,0,0,0,0,0, '笘','笙',0,'笛',0,0,'笞',0, */
	/* 7b20 */ 0xb3de,0,0,0,0,0xbfda,0xc9e4,0, 0xe3fc,0,0,0,0xc2e8,0,0,0, /* '笠',0,0,0,0,'笥','符',0, '笨',0,0,0,'第',0,0,0, */
	/* 7b30 */ 0,0,0,0xe3f7,0,0xe3fb,0xe3fd,0, 0,0xbafb,0,0,0,0,0,0, /* 0,0,0,'笳',0,'笵','笶',0, 0,'笹',0,0,0,0,0,0, */
	/* 7b40 */ 0,0,0,0,0,0xe4a6,0xc9ae,0, 0xc8a6,0xc5f9,0,0xb6da,0xe4a5,0xe4a3,0,0xc8b5, /* 0,0,0,0,0,'筅','筆',0, '筈','等',0,'筋','筌','筍',0,'筏', */
	/* 7b50 */ 0xe3fe,0xc3de,0xc5fb,0,0xc5fa,0,0xbaf6,0, 0,0,0,0,0,0xe4b8,0,0, /* '筐','筑','筒',0,'答',0,'策',0, 0,0,0,0,0,'筝',0,0, */
	/* 7b60 */ 0,0,0,0,0,0xe4a8,0,0xe4aa, 0,0,0,0,0xe4ad,0,0xe4ae,0, /* 0,0,0,0,0,'筥',0,'筧', 0,0,0,0,'筬',0,'筮',0, */
	/* 7b70 */ 0xe4ab,0xe4ac,0,0,0xe4a9,0xe4a7,0,0, 0,0,0xe4a1,0,0,0,0,0, /* '筰','筱',0,0,'筴','筵',0,0, 0,0,'筺',0,0,0,0,0, */
	/* 7b80 */ 0,0,0,0,0,0,0xcacf,0xb2d5, 0,0,0,0xe4b5,0,0xe4b2,0,0xe4b7, /* 0,0,0,0,0,0,'箆','箇', 0,0,0,'箋',0,'箍',0,'箏', */
	/* 7b90 */ 0,0,0xe4b6,0,0xc7f3,0xcca7,0,0xbbbb, 0xe4b0,0xe4b9,0xe4b4,0,0xe4b3,0xe4af,0xfbcc,0xe4b1, /* 0,0,'箒',0,'箔','箕',0,'算', '箘','箙','箚',0,'箜','箝','箞','箟', */
	/* 7ba0 */ 0,0xb4c9,0,0,0,0,0,0, 0,0,0xc3bd,0,0,0xc0fd,0,0, /* 0,'管',0,0,0,0,0,0, 0,0,'箪',0,0,'箭',0,0, */
	/* 7bb0 */ 0,0xc8a2,0,0,0xe4be,0,0,0, 0xc8a4,0,0,0,0,0,0,0, /* 0,'箱',0,0,'箴',0,0,0, '箸',0,0,0,0,0,0,0, */
	/* 7bc0 */ 0xc0e1,0xe4bb,0,0,0xc8cf,0,0xe4bf,0xcad3, 0,0xc3db,0,0xe4ba,0xe4bc,0,0,0xe4bd, /* '節','篁',0,0,'範',0,'篆','篇', 0,'築',0,'篋','篌',0,0,'篏', */
	/* 7bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xe4c0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'篝',0,0, */
	/* 7be0 */ 0xbcc4,0,0,0,0xc6c6,0xe4c5,0xe4c4,0, 0,0xe4c1,0,0,0,0xcfb6,0,0, /* '篠',0,0,0,'篤','篥','篦',0, 0,'篩',0,0,0,'篭',0,0, */
	/* 7bf0 */ 0,0,0,0xe4ca,0,0,0xe4ce,0xe4cb, 0,0,0,0,0,0,0,0, /* 0,0,0,'篳',0,0,'篶','篷', 0,0,0,0,0,0,0,0, */
	/* 7c00 */ 0xe4c7,0,0,0,0,0,0,0xe4c8, 0,0,0,0,0,0xe4cd,0,0, /* '簀',0,0,0,0,0,0,'簇', 0,0,0,0,0,'簍',0,0, */
	/* 7c10 */ 0,0xe4c2,0xd2d5,0xe4c9,0xe4c3,0,0,0xe4cc, 0,0,0,0,0,0,0,0xe4d2, /* 0,'簑','簒','簓','簔',0,0,'簗', 0,0,0,0,0,0,0,'簟', */
	/* 7c20 */ 0,0xb4ca,0,0xe4cf,0,0,0,0xe4d0, 0,0,0xe4d1,0xe4d4,0,0,0,0, /* 0,'簡',0,'簣',0,0,0,'簧', 0,0,'簪','簫',0,0,0,0, */
	/* 7c30 */ 0,0,0,0,0,0,0,0xe4d3, 0xc8f6,0,0,0,0,0xe4d5,0xcefc,0xcaed, /* 0,0,0,0,0,0,0,'簷', '簸',0,0,0,0,'簽','簾','簿', */
	/* 7c40 */ 0xe4da,0,0,0xe4d7,0,0,0,0, 0,0,0,0,0xe4d6,0xc0d2,0,0xe4d9, /* '籀',0,0,'籃',0,0,0,0, 0,0,0,0,'籌','籍',0,'籏', */
	/* 7c50 */ 0xe4db,0,0,0,0xe4d8,0,0xe4df,0, 0xe4dc,0,0,0,0,0,0,0xe4dd, /* '籐',0,0,0,'籔',0,'籖',0, '籘',0,0,0,0,0,0,'籟', */
	/* 7c60 */ 0xe4c6,0,0,0,0xe4de,0xe4e0,0,0, 0,0,0,0,0xe4e1,0,0,0, /* '籠',0,0,0,'籤','籥',0,0, 0,0,0,0,'籬',0,0,0, */
	/* 7c70 */ 0,0,0,0xcac6,0,0xe4e2,0,0, 0,0,0,0,0,0,0xcce2,0, /* 0,0,0,'米',0,'籵',0,0, 0,0,0,0,0,0,'籾',0, */
	/* 7c80 */ 0,0xb6ce,0xb7a9,0xe4e3,0,0,0,0, 0,0xcab4,0,0xbfe8,0,0xccb0,0,0, /* 0,'粁','粂','粃',0,0,0,0, 0,'粉',0,'粋',0,'粍',0,0, */
	/* 7c90 */ 0xe4e4,0,0xceb3,0,0,0xc7f4,0,0xc1c6, 0xc7b4,0,0,0xbdcd,0,0,0,0xb0c0, /* '粐',0,'粒',0,0,'粕',0,'粗', '粘',0,0,'粛',0,0,0,'粟', */
	/* 7ca0 */ 0,0xe4e9,0xe4e7,0,0xe4e5,0xb4a1,0,0xbed1, 0xe4ea,0,0,0xe4e8,0,0xe4e6,0xe4ee,0, /* 0,'粡','粢',0,'粤','粥',0,'粧', '粨',0,0,'粫',0,'粭','粮',0, */
	/* 7cb0 */ 0,0xe4ed,0xe4ec,0xe4eb,0,0,0,0, 0,0xe4ef,0,0,0,0xe4f0,0xc0ba,0, /* 0,'粱','粲','粳',0,0,0,0, 0,'粹',0,0,0,'粽','精',0, */
	/* 7cc0 */ 0xe4f1,0,0xe4f3,0,0,0xe4f2,0,0, 0,0,0xb8d2,0,0,0,0xc1b8,0, /* '糀',0,'糂',0,0,'糅',0,0, 0,0,'糊',0,0,0,'糎',0, */
	/* 7cd0 */ 0,0,0xe4f5,0,0,0,0xc5fc,0, 0xe4f4,0,0,0,0xe4f6,0,0xcab5,0xc1ec, /* 0,0,'糒',0,0,0,'糖',0, '糘',0,0,0,'糜',0,'糞','糟', */
	/* 7ce0 */ 0xb9c7,0,0xe4f7,0,0,0,0,0xcec8, 0,0,0,0,0,0,0,0xe4f9, /* '糠',0,'糢',0,0,0,0,'糧', 0,0,0,0,0,0,0,'糯', */
	/* 7cf0 */ 0,0,0xe4fa,0,0xe4fb,0,0xe4fc,0, 0xbbe5,0,0xe4fd,0xb7cf,0,0,0xb5ea,0, /* 0,0,'糲',0,'糴',0,'糶',0, '糸',0,'糺','系',0,0,'糾',0, */
	/* 7d00 */ 0xb5aa,0,0xe5a1,0,0xccf3,0xb9c8,0xe4fe,0, 0,0,0xe5a4,0xcce6,0,0xc7bc,0,0, /* '紀',0,'紂',0,'約','紅','紆',0, 0,0,'紊','紋',0,'納',0,0, */
	/* 7d10 */ 0xc9b3,0,0,0,0xbde3,0xe5a3,0,0xbcd3, 0xb9c9,0xbbe6,0xb5e9,0xcab6,0xe5a2,0,0,0, /* '紐',0,0,0,'純','紕',0,'紗', '紘','紙','級','紛','紜',0,0,0, */
	/* 7d20 */ 0xc1c7,0xcbc2,0xbaf7,0,0,0,0,0, 0,0,0,0xbbe7,0xc4dd,0,0xe5a7,0xcedf, /* '素','紡','索',0,0,0,0,0, 0,0,0,'紫','紬',0,'紮','累', */
	/* 7d30 */ 0xbad9,0,0xe5a8,0xbfc2,0,0xe5aa,0,0, 0,0xbed2,0xbab0,0,0,0,0,0xe5a9, /* '細',0,'紲','紳',0,'紵',0,0, 0,'紹','紺',0,0,0,0,'紿', */
	/* 7d40 */ 0,0,0xbdaa,0xb8be,0xc1c8,0xe5a5,0xe5ab,0, 0xfbce,0,0,0xe5a6,0xb7d0,0,0xe5ae,0xe5b2, /* 0,0,'終','絃','組','絅','絆',0, '絈',0,0,'絋','経',0,'絎','絏', */
	/* 7d50 */ 0xb7eb,0,0,0,0,0,0xe5ad,0, 0,0,0,0xe5b6,0xfbcf,0,0xb9ca,0, /* '結',0,0,0,0,0,'絖',0, 0,0,0,'絛','絜',0,'絞',0, */
	/* 7d60 */ 0,0xcded,0xb0bc,0xe5b3,0,0,0xb5eb,0, 0xe5b0,0,0,0,0,0,0xe5b1,0, /* 0,'絡','絢','絣',0,0,'給',0, '絨',0,0,0,0,0,'絮',0, */
	/* 7d70 */ 0,0xc5fd,0xe5af,0xe5ac,0,0xb3a8,0xc0e4,0, 0,0xb8a8,0,0,0,0xe5b8,0,0, /* 0,'統','絲','絳',0,'絵','絶',0, 0,'絹',0,0,0,'絽',0,0, */
	/* 7d80 */ 0,0,0,0,0,0,0,0, 0,0xe5b5,0,0,0,0,0,0xe5b7, /* 0,0,0,0,0,0,0,0, 0,'綉',0,0,0,0,0,'綏', */
	/* 7d90 */ 0,0,0,0xe5b4,0,0,0,0, 0,0xb7d1,0xc2b3,0xe5b9,0xc1ee,0,0,0xe5c6, /* 0,0,0,'經',0,0,0,0, 0,'継','続','綛','綜',0,0,'綟', */
	/* 7da0 */ 0xfbd1,0,0xe5c2,0xe5bc,0,0,0,0, 0,0,0,0xe5c0,0xbcfa,0xb0dd,0xe5bb,0xe5c3, /* '綠',0,'綢','綣',0,0,0,0, 0,0,0,'綫','綬','維','綮','綯', */
	/* 7db0 */ 0xe5c7,0xb9cb,0xccd6,0,0xc4d6,0xe5bd,0,0xfbd0, 0xe5c5,0,0xe5ba,0xc3be,0,0xe5bf,0xb0bd,0xccca, /* '綰','綱','網',0,'綴','綵',0,'綷', '綸',0,'綺','綻',0,'綽','綾','綿', */
	/* 7dc0 */ 0,0,0,0,0,0,0,0xe5be, 0,0,0xb6db,0xc8ec,0,0,0,0xc1ed, /* 0,0,0,0,0,0,0,'緇', 0,0,'緊','緋',0,0,0,'総', */
	/* 7dd0 */ 0,0xced0,0xbdef,0,0,0xe5ee,0xfbd2,0, 0xe5c8,0,0xc0fe,0,0xe5c4,0xe5c9,0xe5cb,0, /* 0,'緑','緒',0,0,'緕','緖',0, '緘',0,'線',0,'緜','緝','緞',0, */
	/* 7de0 */ 0xc4f9,0xe5ce,0,0,0xe5ca,0,0,0, 0xcad4,0xb4cb,0,0,0xcccb,0,0,0xb0de, /* '締','緡',0,0,'緤',0,0,0, '編','緩',0,0,'緬',0,0,'緯', */
	/* 7df0 */ 0,0,0xe5cd,0,0xcefd,0,0,0, 0,0,0,0xe5cc,0,0,0,0, /* 0,0,'緲',0,'練',0,0,0, 0,0,0,'緻',0,0,0,0, */
	/* 7e00 */ 0,0xb1ef,0,0,0xc6ec,0xe5cf,0,0, 0,0xe5d6,0xe5d0,0xe5d7,0,0,0,0, /* 0,'縁',0,0,'縄','縅',0,0, 0,'縉','縊','縋',0,0,0,0, */
	/* 7e10 */ 0,0,0xe5d3,0,0,0,0,0, 0,0,0,0xc7fb,0,0,0xbcca,0xe5d5, /* 0,0,'縒',0,0,0,0,0, 0,0,0,'縛',0,0,'縞','縟', */
	/* 7e20 */ 0,0xe5d2,0xe5d8,0xe5d1,0,0,0xbdc4,0, 0,0,0,0xcba5,0,0,0xbdcc,0, /* 0,'縡','縢','縣',0,0,'縦',0, 0,0,0,'縫',0,0,'縮',0, */
	/* 7e30 */ 0,0xe5d4,0xe5e0,0,0,0xe5dc,0,0xe5df, 0,0xe5dd,0xe5e1,0xe5db,0,0xe5c1,0xc0d3,0, /* 0,'縱','縲',0,0,'縵',0,'縷', 0,'縹','縺','縻',0,'總','績',0, */
	/* 7e40 */ 0,0xc8cb,0,0xe5de,0,0,0xe5d9,0, 0,0,0xc1a1,0xb7d2,0,0xbdab,0,0, /* 0,'繁',0,'繃',0,0,'繆',0, 0,0,'繊','繋',0,'繍',0,0, */
	/* 7e50 */ 0,0,0xfbd3,0,0xbfa5,0xc1b6,0xe5e4,0, 0,0xe5e6,0xe5e7,0,0,0xe5e3,0xe5e5,0, /* 0,0,'繒',0,'織','繕','繖',0, 0,'繙','繚',0,0,'繝','繞',0, */
	/* 7e60 */ 0,0,0,0,0,0,0xe5da,0xe5e2, 0,0xe5ea,0xe5e9,0,0,0xcbfa,0,0, /* 0,0,0,0,0,0,'繦','繧', 0,'繩','繪',0,0,'繭',0,0, */
	/* 7e70 */ 0xb7ab,0,0,0,0,0,0,0, 0,0xe5e8,0,0xe5ec,0xe5eb,0xe5ef,0,0xe5f1, /* '繰',0,0,0,0,0,0,0, 0,'繹',0,'繻','繼','繽',0,'繿', */
	/* 7e80 */ 0,0,0xbbbc,0xe5ed,0,0,0,0, 0xe5f2,0xe5f3,0xf9a1,0,0xe5f4,0,0xe5fa,0xc5bb, /* 0,0,'纂','纃',0,0,0,0, '纈','纉','纊',0,'續',0,'纎','纏', */
	/* 7e90 */ 0xe5f6,0,0xe5f5,0xe5f7,0xe5f8,0,0xe5f9,0, 0,0,0,0xe5fb,0xe5fc,0,0,0, /* '纐',0,'纒','纓','纔',0,'纖',0, 0,0,0,'纛','纜',0,0,0, */
	/* 7ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f30 */ 0,0,0,0,0,0,0xb4cc,0, 0xe5fd,0,0xe5fe,0,0,0,0,0, /* 0,0,0,0,0,0,'缶',0, '缸',0,'缺',0,0,0,0,0, */
	/* 7f40 */ 0,0,0,0,0,0xe6a1,0,0xfbd4, 0,0,0,0,0xe6a2,0xe6a3,0xe6a4,0, /* 0,0,0,0,0,'罅',0,'罇', 0,0,0,0,'罌','罍','罎',0, */
	/* 7f50 */ 0xe6a5,0xe6a6,0,0,0xe6a8,0xe6a7,0,0, 0xe6a9,0,0,0,0,0,0,0xe6aa, /* '罐','网',0,0,'罔','罕',0,0, '罘',0,0,0,0,0,0,'罟', */
	/* 7f60 */ 0xe6ab,0,0,0,0,0,0,0xe6ae, 0xe6ac,0xe6ad,0xbae1,0xb7d3,0,0,0xc3d6,0, /* '罠',0,0,0,0,0,0,'罧', '罨','罩','罪','罫',0,0,'置',0, */
	/* 7f70 */ 0xc8b3,0,0xbdf0,0,0,0xc7cd,0,0xc8ed, 0xe6af,0xd8ed,0,0,0,0,0,0, /* '罰',0,'署',0,0,'罵',0,'罷', '罸','罹',0,0,0,0,0,0, */
	/* 7f80 */ 0,0,0xe6b0,0xe6b2,0,0xcde5,0xe6b1,0xe6b4, 0xe6b3,0,0xcdd3,0,0xe6b5,0,0xc8fe,0, /* 0,0,'羂','羃',0,'羅','羆','羇', '羈',0,'羊',0,'羌',0,'美',0, */
	/* 7f90 */ 0,0,0,0,0xe6b6,0,0,0, 0,0,0xe6b9,0,0,0xe6b8,0xe6b7,0, /* 0,0,0,0,'羔',0,0,0, 0,0,'羚',0,0,'羝','羞',0, */
	/* 7fa0 */ 0,0xfbd5,0,0xe6ba,0xb7b2,0,0,0, 0xc1a2,0xb5c1,0,0,0,0,0xe6be,0xe6bb, /* 0,'羡',0,'羣','群',0,0,0, '羨','義',0,0,0,0,'羮','羯', */
	/* 7fb0 */ 0,0,0xe6bc,0,0,0,0xe6bf,0, 0xe6c0,0xe6bd,0,0,0,0xb1a9,0,0, /* 0,0,'羲',0,0,0,'羶',0, '羸','羹',0,0,0,'羽',0,0, */
	/* 7fc0 */ 0,0xb2a7,0,0,0,0xe6c2,0xe6c3,0, 0,0,0xe6c4,0,0xcde2,0,0,0, /* 0,'翁',0,0,0,'翅','翆',0, 0,0,'翊',0,'翌',0,0,0, */
	/* 7fd0 */ 0,0,0xbdac,0,0xe6c6,0xe6c5,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'習',0,'翔','翕',0,0, 0,0,0,0,0,0,0,0, */
	/* 7fe0 */ 0xbfe9,0xe6c7,0,0,0,0,0xe6c8,0, 0,0xe6c9,0,0xb4e5,0,0,0,0, /* '翠','翡',0,0,0,0,'翦',0, 0,'翩',0,'翫',0,0,0,0, */
	/* 7ff0 */ 0xb4cd,0,0,0xe6ca,0,0,0,0, 0,0xe6cb,0,0xcbdd,0xcde3,0,0,0, /* '翰',0,0,'翳',0,0,0,0, 0,'翹',0,'翻','翼',0,0,0, */
	/* 8000 */ 0xcdd4,0xcfb7,0,0xb9cd,0xe6ce,0xbcd4,0xe6cd,0, 0,0,0,0xe6cf,0xbca9,0,0,0, /* '耀','老',0,'考','耄','者','耆',0, 0,0,0,'耋','而',0,0,0, */
	/* 8010 */ 0xc2d1,0,0xe6d0,0,0,0xb9cc,0,0xccd7, 0xe6d1,0xe6d2,0,0,0xe6d3,0,0,0, /* '耐',0,'耒',0,0,'耕',0,'耗', '耘','耙',0,0,'耜',0,0,0, */
	/* 8020 */ 0,0xe6d4,0,0,0,0,0,0, 0xe6d5,0,0,0,0,0,0,0, /* 0,'耡',0,0,0,0,0,0, '耨',0,0,0,0,0,0,0, */
	/* 8030 */ 0,0,0,0xbcaa,0,0,0xcced,0, 0,0,0,0xe6d7,0,0xc3bf,0,0xe6d6, /* 0,0,0,'耳',0,0,'耶',0, 0,0,0,'耻',0,'耽',0,'耿', */
	/* 8040 */ 0,0,0,0,0,0,0xe6d9,0, 0,0,0xe6d8,0,0,0,0,0, /* 0,0,0,0,0,0,'聆',0, 0,0,'聊',0,0,0,0,0, */
	/* 8050 */ 0,0,0xe6da,0,0,0,0xc0bb,0, 0xe6db,0,0xe6dc,0,0,0,0xcab9,0xe6dd, /* 0,0,'聒',0,0,0,'聖',0, '聘',0,'聚',0,0,0,'聞','聟', */
	/* 8060 */ 0,0xc1ef,0xe6de,0,0,0,0,0, 0xe6df,0,0,0,0,0,0,0xcefe, /* 0,'聡','聢',0,0,0,0,0, '聨',0,0,0,0,0,0,'聯', */
	/* 8070 */ 0xe6e2,0,0xe6e1,0xe6e0,0xc4b0,0,0xe6e3,0xbfa6, 0,0xe6e4,0,0,0,0xe6e5,0xcfb8,0xe6e6, /* '聰',0,'聲','聳','聴',0,'聶','職', 0,'聹',0,0,0,'聽','聾','聿', */
	/* 8080 */ 0,0,0,0,0xe6e7,0xe6e9,0xe6e8,0xc8a5, 0,0xc6f9,0,0xcfbe,0xc8a9,0,0,0, /* 0,0,0,0,'肄','肅','肆','肇', 0,'肉',0,'肋','肌',0,0,0, */
	/* 8090 */ 0,0,0,0xe6eb,0,0,0xbed3,0, 0xc9aa,0,0xe6ec,0xe6ea,0,0xb4ce,0,0, /* 0,0,0,'肓',0,0,'肖',0, '肘',0,'肚','肛',0,'肝',0,0, */
	/* 80a0 */ 0,0xb8d4,0xbbe8,0,0,0xc8ee,0,0, 0,0xb8aa,0xcbc3,0,0xe6ef,0xe6ed,0,0xb9ce, /* 0,'股','肢',0,0,'肥',0,0, 0,'肩','肪',0,'肬','肭',0,'肯', */
	/* 80b0 */ 0,0xb9cf,0xb0e9,0,0xbae8,0,0,0, 0,0,0xc7d9,0,0,0,0,0, /* 0,'肱','育',0,'肴',0,0,0, 0,0,'肺',0,0,0,0,0, */
	/* 80c0 */ 0,0,0,0xb0df,0xe6f4,0,0xc3c0,0, 0,0,0,0,0xc7d8,0,0xc2db,0, /* 0,0,0,'胃','胄',0,'胆',0, 0,0,0,0,'背',0,'胎',0, */
	/* 80d0 */ 0,0,0,0,0,0,0xe6f6,0, 0,0xe6f2,0xe6f5,0xe6f0,0,0xe6f3,0xcba6,0, /* 0,0,0,0,0,0,'胖',0, 0,'胙','胚','胛',0,'胝','胞',0, */
	/* 80e0 */ 0,0xb8d5,0,0,0xb0fd,0xe6f1,0,0, 0,0,0,0,0,0,0,0xe6f8, /* 0,'胡',0,0,'胤','胥',0,0, 0,0,0,0,0,0,0,'胯', */
	/* 80f0 */ 0,0xe6f9,0,0,0xc6b9,0,0,0, 0xb6bb,0,0,0,0xe7a6,0xc7bd,0,0, /* 0,'胱',0,0,'胴',0,0,0, '胸',0,0,0,'胼','能',0,0, */
	/* 8100 */ 0,0,0xbbe9,0,0,0xb6bc,0xc0c8,0xcfc6, 0xccae,0xe6f7,0xc0d4,0,0,0,0,0, /* 0,0,'脂',0,0,'脅','脆','脇', '脈','脉','脊',0,0,0,0,0, */
	/* 8110 */ 0,0,0,0,0,0,0,0, 0,0,0xb5d3,0xe6fa,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'脚','脛',0,0,0,0, */
	/* 8120 */ 0,0,0,0xe6fc,0,0,0,0, 0,0xe6fb,0,0,0,0,0,0xe6fd, /* 0,0,0,'脣',0,0,0,0, 0,'脩',0,0,0,0,0,'脯', */
	/* 8130 */ 0,0xc3a6,0,0xc7be,0,0,0,0, 0,0xc4b1,0,0,0,0,0xe7a3,0, /* 0,'脱',0,'脳',0,0,0,0, 0,'脹',0,0,0,0,'脾',0, */
	/* 8140 */ 0,0,0,0,0,0,0xe7a2,0, 0,0,0,0xe6fe,0,0,0xbfd5,0, /* 0,0,0,0,0,0,'腆',0, 0,0,0,'腋',0,0,'腎',0, */
	/* 8150 */ 0xc9e5,0xe7a5,0,0xe7a4,0xb9d0,0xcfd3,0,0, 0,0,0,0,0,0,0,0xe7b5, /* '腐','腑',0,'腓','腔','腕',0,0, 0,0,0,0,0,0,0,'腟', */
	/* 8160 */ 0,0,0,0,0,0xe7a9,0xe7aa,0, 0,0,0,0xbcf0,0,0,0xe7a8,0, /* 0,0,0,0,0,'腥','腦',0, 0,0,0,'腫',0,0,'腮',0, */
	/* 8170 */ 0xb9f8,0xe7a7,0,0,0xe7ab,0,0,0, 0xc4b2,0xcaa2,0xc1a3,0,0,0,0,0xc2dc, /* '腰','腱',0,0,'腴',0,0,0, '腸','腹','腺',0,0,0,0,'腿', */
	/* 8180 */ 0xe7af,0,0xe7b0,0xe7ac,0,0,0,0, 0xe7ad,0,0xe7ae,0,0,0,0,0xb9d1, /* '膀',0,'膂','膃',0,0,0,0, '膈',0,'膊',0,0,0,0,'膏', */
	/* 8190 */ 0,0,0,0xe7b6,0,0xe7b2,0,0, 0,0,0xc9e6,0,0xcbec,0xc9a8,0,0, /* 0,0,0,'膓',0,'膕',0,0, 0,0,'膚',0,'膜','膝',0,0, */
	/* 81a0 */ 0xe7b1,0,0,0xe7b4,0xe7b3,0,0,0, 0xcbc4,0xe7b7,0,0,0,0,0,0, /* '膠',0,0,'膣','膤',0,0,0, '膨','膩',0,0,0,0,0,0, */
	/* 81b0 */ 0xe7b8,0,0,0xc1b7,0,0xe7b9,0,0, 0xe7bb,0,0xe7bf,0,0,0xe7bc,0xe7ba,0xc7bf, /* '膰',0,0,'膳',0,'膵',0,0, '膸',0,'膺',0,0,'膽','膾','膿', */
	/* 81c0 */ 0xe7bd,0,0xe7be,0,0,0,0xb2b2,0, 0xe7c5,0xe7c0,0,0,0,0xe7c1,0,0, /* '臀',0,'臂',0,0,0,'臆',0, '臈','臉',0,0,0,'臍',0,0, */
	/* 81d0 */ 0,0xe7c2,0,0xc2a1,0,0,0,0, 0xe7c4,0xe7c3,0xe7c6,0,0,0,0,0xe7c7, /* 0,'臑',0,'臓',0,0,0,0, '臘','臙','臚',0,0,0,0,'臟', */
	/* 81e0 */ 0xe7c8,0,0,0xbfc3,0,0xb2e9,0,0xe7c9, 0xced7,0,0xbcab,0,0,0xbdad,0,0, /* '臠',0,0,'臣',0,'臥',0,'臧', '臨',0,'自',0,0,'臭',0,0, */
	/* 81f0 */ 0,0,0,0xbbea,0xc3d7,0,0,0, 0,0,0xe7ca,0xe7cb,0xb1b1,0,0xe7cc,0, /* 0,0,0,'至','致',0,0,0, 0,0,'臺','臻','臼',0,'臾',0, */
	/* 8200 */ 0,0xe7cd,0xe7ce,0,0,0xe7cf,0,0xe7d0, 0xb6bd,0xdaaa,0xe7d1,0,0xc0e5,0xe7d2,0xbccb,0, /* 0,'舁','舂',0,0,'舅',0,'與', '興','舉','舊',0,'舌','舍','舎',0, */
	/* 8210 */ 0xe7d3,0,0xd0b0,0,0,0,0xe7d4,0xcade, 0xb4dc,0,0,0xc1a4,0xbdd8,0,0xc9f1,0xbdae, /* '舐',0,'舒',0,0,0,'舖','舗', '舘',0,0,'舛','舜',0,'舞','舟', */
	/* 8220 */ 0,0,0,0,0,0,0,0, 0,0xe7d5,0xb9d2,0xe7d6,0xc8cc,0,0xe7e4,0, /* 0,0,0,0,0,0,0,0, 0,'舩','航','舫','般',0,'舮',0, */
	/* 8230 */ 0,0,0,0xe7d8,0,0xc2c9,0xc7f5,0xb8bf, 0xe7d7,0xc1a5,0,0,0,0,0,0, /* 0,0,0,'舳',0,'舵','舶','舷', '舸','船',0,0,0,0,0,0, */
	/* 8240 */ 0xe7d9,0,0,0,0,0,0,0xc4fa, 0,0,0,0,0,0,0,0, /* '艀',0,0,0,0,0,0,'艇', 0,0,0,0,0,0,0,0, */
	/* 8250 */ 0,0,0,0,0,0,0,0, 0xe7db,0xe7da,0xe7dd,0,0,0xe7dc,0,0xe7de, /* 0,0,0,0,0,0,0,0, '艘','艙','艚',0,0,'艝',0,'艟', */
	/* 8260 */ 0,0,0xe7e0,0,0xe7df,0,0xb4cf,0, 0xe7e1,0,0xe7e2,0xe7e3,0,0,0xbab1,0xcec9, /* 0,0,'艢',0,'艤',0,'艦',0, '艨',0,'艪','艫',0,0,'艮','良', */
	/* 8270 */ 0,0xe7e5,0xbfa7,0,0,0,0xb1f0,0xe7e6, 0xe7e7,0,0,0,0,0,0xe7e8,0, /* 0,'艱','色',0,0,0,'艶','艷', '艸',0,0,0,0,0,'艾',0, */
	/* 8280 */ 0,0,0,0,0,0,0,0, 0,0,0,0xb0f2,0,0xe7e9,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'芋',0,'芍',0,0, */
	/* 8290 */ 0,0,0xe7ea,0,0,0,0,0, 0,0xc9e7,0,0,0,0xbcc7,0,0xe7ec, /* 0,0,'芒',0,0,0,0,0, 0,'芙',0,0,0,'芝',0,'芟', */
	/* 82a0 */ 0,0,0,0,0,0xb3a9,0xb0b2,0, 0,0,0,0xe7eb,0xe7ee,0xc7ce,0,0xbfc4, /* 0,0,0,0,0,'芥','芦',0, 0,0,0,'芫','芬','芭',0,'芯', */
	/* 82b0 */ 0,0xb2d6,0,0xcba7,0,0,0,0, 0xb7dd,0xb6dc,0,0xe7ed,0,0xb2ea,0,0, /* 0,'花',0,'芳',0,0,0,0, '芸','芹',0,'芻',0,'芽',0,0, */
	/* 82c0 */ 0,0,0,0,0,0xb4a3,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'苅',0,0, 0,0,0,0,0,0,0,0, */
	/* 82d0 */ 0,0xb1f1,0xe7f2,0xceea,0xc2dd,0,0,0xc9c4, 0,0xe7fe,0,0xb2d7,0xe7fc,0,0xe7fa,0xe7f1, /* 0,'苑','苒','苓','苔',0,0,'苗', 0,'苙',0,'苛','苜',0,'苞','苟', */
	/* 82e0 */ 0,0xe7ef,0,0xe7f0,0,0xbce3,0xb6ec,0xc3f7, 0,0,0,0xc6d1,0,0,0,0, /* 0,'苡',0,'苣',0,'若','苦','苧', 0,0,0,'苫',0,0,0,0, */
	/* 82f0 */ 0,0xb1d1,0,0xe7f4,0xe7f3,0,0,0, 0,0xe7f9,0xe7f5,0xe7f8,0,0,0,0, /* 0,'英',0,'苳','苴',0,0,0, 0,'苹','苺','苻',0,0,0,0, */
	/* 8300 */ 0,0xfbd7,0xccd0,0xe7f7,0xb2d8,0xb3fd,0xe7fb,0, 0,0xe7fd,0,0,0,0,0xb7d4,0, /* 0,'茁','茂','范','茄','茅','茆',0, 0,'茉',0,0,0,0,'茎',0, */
	/* 8310 */ 0,0,0,0,0,0,0xe8a3,0xe8ac, 0xe8ad,0,0,0,0xb0ab,0,0,0, /* 0,0,0,0,0,0,'茖','茗', '茘',0,0,0,'茜',0,0,0, */
	/* 8320 */ 0,0,0,0xe8b4,0,0,0,0, 0xb0f1,0,0,0xe8ab,0,0,0,0xe8aa, /* 0,0,0,'茣',0,0,0,0, '茨',0,0,'茫',0,0,0,'茯', */
	/* 8330 */ 0,0xe8a5,0xe8a4,0,0xe8a2,0xe8a1,0xc3e3,0, 0xc2fb,0xe8a7,0,0,0,0,0,0, /* 0,'茱','茲',0,'茴','茵','茶',0, '茸','茹',0,0,0,0,0,0, */
	/* 8340 */ 0xe8a6,0,0,0,0,0xe8a9,0,0, 0,0xc1f0,0xb7d5,0,0,0,0,0xb1c1, /* '荀',0,0,0,0,'荅',0,0, 0,'草','荊',0,0,0,0,'荏', */
	/* 8350 */ 0xe8a8,0,0xb9d3,0,0,0,0,0, 0xc1f1,0,0,0,0,0,0,0, /* '荐',0,'荒',0,0,0,0,0, '荘',0,0,0,0,0,0,0, */
	/* 8360 */ 0,0,0xfbd8,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'荢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8370 */ 0,0,0,0xe8ba,0,0xe8bb,0,0xb2d9, 0,0,0,0xb2ae,0xe8b8,0,0,0xfbd9, /* 0,0,0,'荳',0,'荵',0,'荷', 0,0,0,'荻','荼',0,0,'荿', */
	/* 8380 */ 0,0,0,0,0,0xe8ae,0,0xe8b6, 0,0xe8bd,0xe8b7,0,0,0,0xe8b5,0, /* 0,0,0,0,0,'莅',0,'莇', 0,'莉','莊',0,0,0,'莎',0, */
	/* 8390 */ 0,0,0,0xe7f6,0,0,0xe8b3,0, 0,0,0xe8af,0,0,0,0xb4d0,0xe8b1, /* 0,0,0,'莓',0,0,'莖',0, 0,0,'莚',0,0,0,'莞','莟', */
	/* 83a0 */ 0xe8bc,0,0xe8b2,0,0,0,0,0, 0xe8be,0,0xe8b0,0xc7fc,0,0,0,0, /* '莠',0,'莢',0,0,0,0,0, '莨',0,'莪','莫',0,0,0,0, */
	/* 83b0 */ 0,0xcde9,0,0,0,0xe8b9,0,0, 0,0,0,0,0,0xe8cf,0,0, /* 0,'莱',0,0,0,'莵',0,0, 0,0,0,0,0,'莽',0,0, */
	/* 83c0 */ 0,0xe8c7,0,0,0,0xbffb,0,0xfbda, 0,0,0xb5c6,0,0xb6dd,0,0xe8c2,0, /* 0,'菁',0,0,0,'菅',0,'菇', 0,0,'菊',0,'菌',0,'菎',0, */
	/* 83d0 */ 0,0,0,0xb2db,0,0,0xbed4,0, 0xe8c5,0,0,0,0xbada,0,0,0xc5d1, /* 0,0,0,'菓',0,0,'菖',0, '菘',0,0,0,'菜',0,0,'菟', */
	/* 83e0 */ 0xe8ca,0,0,0,0,0,0,0, 0,0xcaee,0,0xe8c1,0,0,0,0xb2da, /* '菠',0,0,0,0,0,0,0, 0,'菩',0,'菫',0,0,0,'華', */
	/* 83f0 */ 0xb8d6,0xc9a9,0xe8cb,0,0xe8bf,0,0xfbdb,0xe8c8, 0,0,0,0xe8d2,0,0xe8c3,0,0, /* '菰','菱','菲',0,'菴',0,'菶','菷', 0,0,0,'菻',0,'菽',0,0, */
	/* 8400 */ 0,0,0,0xe8c4,0xc6ba,0,0,0xe8c9, 0,0,0,0xe8c6,0xcba8,0xe8cc,0xb0e0,0, /* 0,0,0,'萃','萄',0,0,'萇', 0,0,0,'萋','萌','萍','萎',0, */
	/* 8410 */ 0,0,0,0xe8c0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'萓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8420 */ 0xe8ce,0,0xe8cd,0,0,0,0,0, 0,0xc7eb,0xe8d4,0,0xe8df,0,0,0, /* '萠',0,'萢',0,0,0,0,0, 0,'萩','萪',0,'萬',0,0,0, */
	/* 8430 */ 0,0xb3fe,0,0,0,0xe8e2,0,0, 0xe8d0,0,0,0,0xe8d5,0xcdee,0,0, /* 0,'萱',0,0,0,'萵',0,0, '萸',0,0,0,'萼','落',0,0, */
	/* 8440 */ 0,0,0,0,0,0,0xe8de,0, 0xfbdc,0xcdd5,0,0,0,0,0xceaa,0, /* 0,0,0,0,0,0,'葆',0, '葈','葉',0,0,0,0,'葎',0, */
	/* 8450 */ 0,0,0,0,0,0,0,0xc3f8, 0,0,0,0xb3eb,0,0,0,0, /* 0,0,0,0,0,0,0,'著', 0,0,0,'葛',0,0,0,0, */
	/* 8460 */ 0,0xc9f2,0xe8e4,0xc6a1,0,0,0xb0b1,0, 0,0xe8dd,0,0xe8d9,0xc1f2,0xe8d3,0xe8db,0xe8e0, /* 0,'葡','葢','董',0,0,'葦',0, 0,'葩',0,'葫','葬','葭','葮','葯', */
	/* 8470 */ 0,0xc7ac,0,0,0,0xb0aa,0,0xe8d8, 0,0xe8e1,0xc9f8,0,0,0,0,0, /* 0,'葱',0,0,0,'葵',0,'葷', 0,'葹','葺',0,0,0,0,0, */
	/* 8480 */ 0,0,0xe8dc,0,0xe8d7,0,0,0, 0,0,0,0xbed5,0,0,0,0, /* 0,0,'蒂',0,'蒄',0,0,0, 0,0,0,'蒋',0,0,0,0, */
	/* 8490 */ 0xbdaf,0,0,0,0xbcac,0,0,0, 0,0xccd8,0,0,0xc9c7,0,0,0xe8e7, /* '蒐',0,0,0,'蒔',0,0,0, 0,'蒙',0,0,'蒜',0,0,'蒟', */
	/* 84a0 */ 0,0xe8f0,0,0,0,0,0,0, 0,0,0,0,0,0xe8da,0,0, /* 0,'蒡',0,0,0,0,0,0, 0,0,0,0,0,'蒭',0,0, */
	/* 84b0 */ 0,0,0xb3f7,0,0xfbdd,0,0,0, 0xbef8,0xe8e5,0,0xe8ea,0xc1f3,0,0,0xe8e6, /* 0,0,'蒲',0,'蒴',0,0,0, '蒸','蒹',0,'蒻','蒼',0,0,'蒿', */
	/* 84c0 */ 0,0xe8ed,0,0,0xc3df,0,0xe8ee,0, 0,0xcdd6,0xe8e3,0xb3b8,0,0xe8e9,0,0, /* 0,'蓁',0,0,'蓄',0,'蓆',0, 0,'蓉','蓊','蓋',0,'蓍',0,0, */
	/* 84d0 */ 0xe8ec,0xccac,0,0,0,0,0xe8ef,0, 0,0xe8e8,0xe8eb,0,0xf9a5,0,0,0, /* '蓐','蓑',0,0,0,0,'蓖',0, 0,'蓙','蓚',0,'蓜',0,0,0, */
	/* 84e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xcba9,0,0xcfa1,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'蓬',0,'蓮',0, */
	/* 84f0 */ 0,0,0,0,0xe8f3,0,0,0, 0,0,0,0,0xe8fa,0,0,0xe8f2, /* 0,0,0,0,'蓴',0,0,0, 0,0,0,0,'蓼',0,0,'蓿', */
	/* 8500 */ 0xbcc3,0,0,0,0,0,0xe8d1,0, 0,0,0,0,0,0,0,0, /* '蔀',0,0,0,0,0,'蔆',0, 0,0,0,0,0,0,0,0, */
	/* 8510 */ 0,0xcace,0,0xcca2,0xe8f9,0xe8f8,0,0xe8f4, 0xe8f5,0,0xb1b6,0,0,0,0,0xe8f7, /* 0,'蔑',0,'蔓','蔔','蔕',0,'蔗', '蔘',0,'蔚',0,0,0,0,'蔟', */
	/* 8520 */ 0,0xe8f1,0,0,0,0,0xc4d5,0, 0,0,0,0,0xe8f6,0xb0fe,0,0, /* 0,'蔡',0,0,0,0,'蔦',0, 0,0,0,0,'蔬','蔭',0,0, */
	/* 8530 */ 0,0,0,0,0,0xc2a2,0,0, 0,0,0,0,0,0xcac3,0,0, /* 0,0,0,0,0,'蔵',0,0, 0,0,0,0,0,'蔽',0,0, */
	/* 8540 */ 0xe8fb,0xe9a1,0,0xc8d9,0,0,0,0, 0xe8fe,0xbed6,0xbcc9,0xe9a3,0,0,0xb6be,0, /* '蕀','蕁',0,'蕃',0,0,0,0, '蕈','蕉','蕊','蕋',0,0,'蕎',0, */
	/* 8550 */ 0,0,0,0xfbde,0,0xe9a4,0,0xc9f9, 0xe8fd,0xfbdf,0xe8d6,0,0,0,0,0, /* 0,0,0,'蕓',0,'蕕',0,'蕗', '蕘','蕙','蕚',0,0,0,0,0, */
	/* 8560 */ 0,0,0,0xe8fc,0,0,0,0, 0xcfcf,0xc6a2,0xc9f3,0xfbe0,0,0xe9ab,0,0, /* 0,0,0,'蕣',0,0,0,0, '蕨','蕩','蕪','蕫',0,'蕭',0,0, */
	/* 8570 */ 0,0,0,0,0,0,0,0xe9b1, 0,0,0,0,0,0,0xe9b2,0, /* 0,0,0,0,0,0,0,'蕷', 0,0,0,0,0,0,'蕾',0, */
	/* 8580 */ 0xe9a5,0,0,0,0xc7f6,0,0,0xe9af, 0xe9a7,0,0xe9a9,0,0,0,0,0, /* '薀',0,0,0,'薄',0,0,'薇', '薈',0,'薊',0,0,0,0,0, */
	/* 8590 */ 0xe9b3,0xe9a8,0,0,0xe9ac,0,0,0xb1f2, 0,0xc6e5,0,0xe9ad,0xe9b0,0,0,0, /* '薐','薑',0,0,'薔',0,0,'薗', 0,'薙',0,'薛','薜',0,0,0, */
	/* 85a0 */ 0,0,0,0,0xe9a6,0,0xc1a6,0, 0xe9aa,0xbba7,0xbfc5,0xb7b0,0xccf4,0,0xccf9,0xbdf2, /* 0,0,0,0,'薤',0,'薦',0, '薨','薩','薪','薫','薬',0,'薮','薯', */
	/* 85b0 */ 0xfbe2,0,0,0,0,0,0,0, 0,0xe9b7,0xe9b5,0,0,0,0,0, /* '薰',0,0,0,0,0,0,0, 0,'薹','薺',0,0,0,0,0, */
	/* 85c0 */ 0,0xcfce,0,0,0,0,0,0, 0,0xe9b4,0,0,0,0xcdf5,0,0xe9b6, /* 0,'藁',0,0,0,0,0,0, 0,'藉',0,0,0,'藍',0,'藏', */
	/* 85d0 */ 0xe9b8,0,0,0,0,0xe9b9,0,0, 0,0,0,0,0xe9bc,0xe9ba,0,0, /* '藐',0,0,0,0,'藕',0,0, 0,0,0,0,'藜','藝',0,0, */
	/* 85e0 */ 0,0,0,0,0xc6a3,0xe9bb,0,0, 0,0xc8cd,0xe9ae,0,0,0,0,0, /* 0,0,0,0,'藤','藥',0,0, 0,'藩','藪',0,0,0,0,0, */
	/* 85f0 */ 0,0,0,0,0,0,0,0xbdf3, 0,0xe9bd,0xe9c2,0xc1f4,0,0,0xe9c1,0, /* 0,0,0,0,0,0,0,'藷', 0,'藹','藺','藻',0,0,'藾',0, */
	/* 8600 */ 0,0,0xe9a2,0,0,0,0xe9c3,0xc1c9, 0,0,0xe9be,0xe9c0,0,0,0,0, /* 0,0,'蘂',0,0,0,'蘆','蘇', 0,0,'蘊','蘋',0,0,0,0, */
	/* 8610 */ 0,0,0,0xe9bf,0,0,0xddb1,0xdda2, 0,0,0xe9c5,0,0,0,0,0, /* 0,0,0,'蘓',0,0,'蘖','蘗', 0,0,'蘚',0,0,0,0,0, */
	/* 8620 */ 0,0,0xe9c4,0,0,0,0,0, 0,0,0,0,0,0xcdf6,0,0xe2bc, /* 0,0,'蘢',0,0,0,0,0, 0,0,0,0,0,'蘭',0,'蘯', */
	/* 8630 */ 0xe9c6,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xe9c7, /* '蘰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'蘿', */
	/* 8640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xe9c8,0xb8d7,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'虍','虎',0, */
	/* 8650 */ 0xb5d4,0,0,0,0xe9ca,0xd1dd,0,0, 0,0,0xb5f5,0,0xceba,0,0xb6f3,0xe9cb, /* '虐',0,0,0,'虔','處',0,0, 0,0,'虚',0,'虜',0,'虞','號', */
	/* 8660 */ 0,0,0,0,0,0,0,0xe9cc, 0,0,0,0xc3ee,0,0,0,0, /* 0,0,0,0,0,0,0,'虧', 0,0,0,'虫',0,0,0,0, */
	/* 8670 */ 0,0xe9cd,0,0,0,0,0,0, 0,0xc6fa,0,0xb0ba,0,0,0,0, /* 0,'虱',0,0,0,0,0,0, 0,'虹',0,'虻',0,0,0,0, */
	/* 8680 */ 0,0,0,0,0,0,0,0, 0,0,0xb2e3,0xe9d2,0xe9d3,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'蚊','蚋','蚌',0,0,0, */
	/* 8690 */ 0,0,0,0xe9ce,0,0xbbbd,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'蚓',0,'蚕',0,0, 0,0,0,0,0,0,0,0, */
	/* 86a0 */ 0,0,0,0xe9cf,0xc7c2,0,0,0, 0,0xe9d0,0xe9d1,0xe9db,0,0,0,0xe9d5, /* 0,0,0,'蚣','蚤',0,0,0, 0,'蚩','蚪','蚫',0,0,0,'蚯', */
	/* 86b0 */ 0xe9d8,0,0,0,0,0,0xe9d4,0, 0,0,0,0,0,0,0,0, /* '蚰',0,0,0,0,0,'蚶',0, 0,0,0,0,0,0,0,0, */
	/* 86c0 */ 0,0,0,0,0xe9d6,0,0xe9d7,0xbcd8, 0,0xe9d9,0,0xc3c1,0,0xb7d6,0xb3c2,0, /* 0,0,0,0,'蛄',0,'蛆','蛇', 0,'蛉',0,'蛋',0,'蛍','蛎',0, */
	/* 86d0 */ 0,0,0,0,0xe9dc,0,0,0, 0,0xb3bf,0,0xe9e1,0,0,0xe9dd,0xe9e0, /* 0,0,0,0,'蛔',0,0,0, 0,'蛙',0,'蛛',0,0,'蛞','蛟', */
	/* 86e0 */ 0,0,0,0,0xc8ba,0,0,0, 0,0xe9de,0,0,0xe9df,0xc9c8,0xc8da,0xe9e2, /* 0,0,0,0,'蛤',0,0,0, 0,'蛩',0,0,'蛬','蛭','蛮','蛯', */
	/* 86f0 */ 0,0,0,0,0,0,0,0, 0xc2fd,0xe9ec,0,0xe9e8,0,0,0xb2eb,0, /* 0,0,0,0,0,0,0,0, '蛸','蛹',0,'蛻',0,0,'蛾',0, */
	/* 8700 */ 0xe9e6,0,0xcbaa,0xe9e7,0,0,0xe9e4,0, 0xe9e5,0xe9ea,0xe9ed,0,0,0xe9eb,0,0, /* '蜀',0,'蜂','蜃',0,0,'蜆',0, '蜈','蜉','蜊',0,0,'蜍',0,0, */
	/* 8710 */ 0,0xe9e9,0xe9e3,0,0,0,0,0, 0xc3d8,0,0xe9f4,0,0xccaa,0,0,0, /* 0,'蜑','蜒',0,0,0,0,0, '蜘',0,'蜚',0,'蜜',0,0,0, */
	/* 8720 */ 0,0,0,0,0,0xe9f2,0,0, 0,0xe9f3,0,0,0,0,0,0, /* 0,0,0,0,0,'蜥',0,0, 0,'蜩',0,0,0,0,0,0, */
	/* 8730 */ 0,0,0,0,0xe9ee,0,0,0xe9f0, 0,0,0,0xe9f1,0,0,0,0xe9ef, /* 0,0,0,0,'蜴',0,0,'蜷', 0,0,0,'蜻',0,0,0,'蜿', */
	/* 8740 */ 0,0,0,0,0,0,0,0, 0,0xc0e6,0,0xcfb9,0xe9f8,0,0xe9f9,0, /* 0,0,0,0,0,0,0,0, 0,'蝉',0,'蝋','蝌',0,'蝎',0, */
	/* 8750 */ 0,0,0,0xeaa1,0,0xbfaa,0,0xe9fb, 0,0xe9fe,0,0,0,0,0,0xe9f6, /* 0,0,0,'蝓',0,'蝕',0,'蝗', 0,'蝙',0,0,0,0,0,'蝟', */
	/* 8760 */ 0xe9f5,0,0,0xeaa2,0,0,0xb2dc,0, 0xe9fc,0,0xeaa3,0,0,0,0xe9fd,0, /* '蝠',0,0,'蝣',0,0,'蝦',0, '蝨',0,'蝪',0,0,0,'蝮',0, */
	/* 8770 */ 0,0,0,0,0xe9fa,0,0xc4b3,0, 0xe9f7,0,0,0,0,0,0,0xc7e8, /* 0,0,0,0,'蝴',0,'蝶',0, '蝸',0,0,0,0,0,0,'蝿', */
	/* 8780 */ 0,0,0xeaa7,0,0,0,0,0, 0,0,0,0,0,0xcdbb,0,0, /* 0,0,'螂',0,0,0,0,0, 0,0,0,0,0,'融',0,0, */
	/* 8790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xeaa6, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'螟', */
	/* 87a0 */ 0,0,0xeaa5,0,0,0,0,0, 0,0,0,0xeaae,0,0,0,0xeaa8, /* 0,0,'螢',0,0,0,0,0, 0,0,0,'螫',0,0,0,'螯', */
	/* 87b0 */ 0,0,0,0xeab0,0,0,0,0, 0,0,0xcde6,0xeab3,0,0xeaaa,0,0, /* 0,0,0,'螳',0,0,0,0, 0,0,'螺','螻',0,'螽',0,0, */
	/* 87c0 */ 0xeaab,0,0,0,0xeaaf,0,0xeab2,0xeab1, 0,0,0,0xeaa9,0,0,0,0, /* '蟀',0,0,0,'蟄',0,'蟆','蟇', 0,0,0,'蟋',0,0,0,0, */
	/* 87d0 */ 0xeaac,0,0xeabd,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '蟐',0,'蟒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 87e0 */ 0xeab6,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xeab4, /* '蟠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'蟯', */
	/* 87f0 */ 0,0,0xeab5,0,0,0,0xeaba,0xeabb, 0,0xb3aa,0,0xb5c2,0,0,0xeab9,0, /* 0,0,'蟲',0,0,0,'蟶','蟷', 0,'蟹',0,'蟻',0,0,'蟾',0, */
	/* 8800 */ 0,0,0,0,0,0xeaa4,0,0xfbe5, 0,0,0,0,0,0xeab8,0xeabc,0xeab7, /* 0,0,0,0,0,'蠅',0,'蠇', 0,0,0,0,0,'蠍','蠎','蠏', */
	/* 8810 */ 0,0xeabe,0,0,0,0xeac0,0xeabf,0, 0,0,0,0,0,0,0,0, /* 0,'蠑',0,0,0,'蠕','蠖',0, 0,0,0,0,0,0,0,0, */
	/* 8820 */ 0,0xeac2,0xeac1,0xe9da,0,0,0,0xeac6, 0,0,0,0,0,0,0,0, /* 0,'蠡','蠢','蠣',0,0,0,'蠧', 0,0,0,0,0,0,0,0, */
	/* 8830 */ 0,0xeac3,0,0,0,0,0xeac4,0, 0,0xeac5,0,0xeac7,0,0,0,0, /* 0,'蠱',0,0,0,0,'蠶',0, 0,'蠹',0,'蠻',0,0,0,0, */
	/* 8840 */ 0xb7ec,0,0xeac9,0,0xeac8,0,0xbdb0,0, 0,0,0,0,0xb9d4,0xdea7,0,0, /* '血',0,'衂',0,'衄',0,'衆',0, 0,0,0,0,'行','衍',0,0, */
	/* 8850 */ 0,0,0xeaca,0xbdd1,0,0,0,0xb3b9, 0,0xeacb,0,0xb1d2,0,0xbed7,0xeacc,0, /* 0,0,'衒','術',0,0,0,'街', 0,'衙',0,'衛',0,'衝','衞',0, */
	/* 8860 */ 0,0xb9d5,0xeacd,0xb0e1,0,0,0,0, 0xc9bd,0,0,0xeace,0,0,0,0, /* 0,'衡','衢','衣',0,0,0,0, '表',0,0,'衫',0,0,0,0, */
	/* 8870 */ 0xbfea,0,0xead5,0,0,0xead2,0,0xc3ef, 0,0,0,0,0,0xead3,0xead0,0xb6de, /* '衰',0,'衲',0,0,'衵',0,'衷', 0,0,0,0,0,'衽','衾','衿', */
	/* 8880 */ 0,0xeacf,0xead6,0,0,0,0,0, 0xb7b6,0,0,0xc2de,0,0xeadc,0,0, /* 0,'袁','袂',0,0,0,0,0, '袈',0,0,'袋',0,'袍',0,0, */
	/* 8890 */ 0,0,0xead8,0,0,0,0xc2b5,0xead7, 0,0xeada,0,0,0,0,0xead1,0, /* 0,0,'袒',0,0,0,'袖','袗', 0,'袙',0,0,0,0,'袞',0, */
	/* 88a0 */ 0,0,0xeadb,0,0xeadd,0,0,0, 0,0,0,0xc8ef,0,0,0xead9,0, /* 0,0,'袢',0,'袤',0,0,0, 0,0,0,'被',0,0,'袮',0, */
	/* 88b0 */ 0xeade,0xeae0,0,0,0xb8d3,0xead4,0,0xb0c1, 0,0,0,0,0,0,0,0xeadf, /* '袰','袱',0,0,'袴','袵',0,'袷', 0,0,0,0,0,0,0,'袿', */
	/* 88c0 */ 0,0xbadb,0xcef6,0xeae1,0xeae2,0xc1f5,0,0, 0,0,0,0,0,0,0,0xcea2, /* 0,'裁','裂','裃','裄','装',0,0, 0,0,0,0,0,0,0,'裏', */
	/* 88d0 */ 0,0,0,0,0xeae3,0xcdb5,0,0, 0xeae4,0xeae5,0,0,0xcae4,0xeae6,0,0xbac0, /* 0,0,0,0,'裔','裕',0,0, '裘','裙',0,0,'補','裝',0,'裟', */
	/* 88e0 */ 0,0xcea3,0,0,0,0,0,0, 0xeaeb,0,0,0,0,0,0,0, /* 0,'裡',0,0,0,0,0,0, '裨',0,0,0,0,0,0,0, */
	/* 88f0 */ 0,0,0xeaec,0xbed8,0xeaea,0xfbe6,0,0, 0xcde7,0xeae7,0,0,0xeae9,0xc0bd,0xbffe,0, /* 0,0,'裲','裳','裴','裵',0,0, '裸','裹',0,0,'裼','製','裾',0, */
	/* 8900 */ 0,0,0xeae8,0,0xeaed,0,0,0xcaa3, 0,0,0xeaef,0,0xeaee,0,0,0, /* 0,0,'褂',0,'褄',0,0,'複', 0,0,'褊',0,'褌',0,0,0, */
	/* 8910 */ 0xb3ec,0,0xcbab,0xeaf0,0,0,0,0, 0,0,0,0,0xf9a2,0xeafc,0xeaf2,0, /* '褐',0,'褒','褓',0,0,0,0, 0,0,0,0,'褜','褝','褞',0, */
	/* 8920 */ 0,0,0,0,0,0xeaf3,0,0, 0,0,0xeaf4,0xeaf5,0,0,0,0, /* 0,0,0,0,0,'褥',0,0, 0,0,'褪','褫',0,0,0,0, */
	/* 8930 */ 0,0,0,0,0,0,0xeaf9,0, 0xeafa,0,0,0xeaf8,0,0,0,0, /* 0,0,0,0,0,0,'褶',0, '褸',0,0,'褻',0,0,0,0, */
	/* 8940 */ 0,0xeaf6,0,0xeaf1,0xeaf7,0,0,0, 0,0,0,0,0xeafb,0xf0b7,0,0, /* 0,'襁',0,'襃','襄',0,0,0, 0,0,0,0,'襌','襍',0,0, */
	/* 8950 */ 0,0,0,0,0,0,0xb2a8,0, 0,0,0,0,0,0,0xeafe,0xb6df, /* 0,0,0,0,0,0,'襖',0, 0,0,0,0,0,0,'襞','襟', */
	/* 8960 */ 0xeafd,0,0,0,0xeba2,0,0xeba1,0, 0,0,0xeba4,0,0,0xeba3,0,0xeba5, /* '襠',0,0,0,'襤',0,'襦',0, 0,0,'襪',0,0,'襭',0,'襯', */
	/* 8970 */ 0,0,0xbdb1,0,0xeba6,0,0,0xeba7, 0,0,0,0,0,0,0xeba8,0xc0be, /* 0,0,'襲',0,'襴',0,0,'襷', 0,0,0,0,0,0,'襾','西', */
	/* 8980 */ 0,0xcdd7,0,0xeba9,0,0,0xcaa4,0xc7c6, 0xebaa,0,0xebab,0xb8ab,0,0,0,0xb5ac, /* 0,'要',0,'覃',0,0,'覆','覇', '覈',0,'覊','見',0,0,0,'規', */
	/* 8990 */ 0,0,0,0xebac,0,0,0xbbeb,0xc7c1, 0xebad,0,0xb3d0,0,0,0,0,0, /* 0,0,0,'覓',0,0,'視','覗', '覘',0,'覚',0,0,0,0,0, */
	/* 89a0 */ 0,0xebae,0,0,0,0,0xebb0,0xcdf7, 0,0xebaf,0xbfc6,0,0xebb1,0,0,0xebb2, /* 0,'覡',0,0,0,0,'覦','覧', 0,'覩','親',0,'覬',0,0,'覯', */
	/* 89b0 */ 0,0,0xebb3,0xb4d1,0,0,0,0, 0,0,0xebb4,0,0,0xebb5,0,0xebb6, /* 0,0,'覲','観',0,0,0,0, 0,0,'覺',0,0,'覽',0,'覿', */
	/* 89c0 */ 0xebb7,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '觀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 89d0 */ 0,0,0xb3d1,0,0,0,0,0, 0,0,0xebb8,0,0xebb9,0xebba,0,0, /* 0,0,'角',0,0,0,0,0, 0,0,'觚',0,'觜','觝',0,0, */
	/* 89e0 */ 0,0,0,0xb2f2,0,0,0xbfa8,0xebbb, 0,0,0,0,0,0,0,0, /* 0,0,0,'解',0,0,'触','觧', 0,0,0,0,0,0,0,0, */
	/* 89f0 */ 0,0,0,0,0xebbc,0,0,0, 0xebbd,0,0,0,0,0,0,0, /* 0,0,0,0,'觴',0,0,0, '觸',0,0,0,0,0,0,0, */
	/* 8a00 */ 0xb8c0,0,0xc4fb,0xebbe,0,0,0,0, 0xb7d7,0,0xbfd6,0,0xebc1,0,0xc6a4,0, /* '言',0,'訂','訃',0,0,0,0, '計',0,'訊',0,'訌',0,'討',0, */
	/* 8a10 */ 0xebc0,0,0xfbe7,0xb7b1,0,0,0xebbf,0xc2f7, 0xb5ad,0,0,0xebc2,0,0xebc3,0,0xbed9, /* '訐',0,'訒','訓',0,0,'訖','託', '記',0,0,'訛',0,'訝',0,'訟', */
	/* 8a20 */ 0,0,0,0xb7ed,0,0xebc4,0,0, 0,0,0xcbac,0,0,0xc0df,0,0, /* 0,0,0,'訣',0,'訥',0,0, 0,0,'訪',0,0,'設',0,0, */
	/* 8a30 */ 0,0xb5f6,0,0xccf5,0xc1ca,0,0xebc5,0xfbe8, 0,0,0xbfc7,0xc3f0,0xbeda,0,0,0, /* 0,'許',0,'訳','訴',0,'訶','訷', 0,0,'診','註','証',0,0,0, */
	/* 8a40 */ 0,0xebc6,0,0,0,0,0xebc9,0, 0xebca,0,0,0,0,0,0,0, /* 0,'詁',0,0,0,0,'詆',0, '詈',0,0,0,0,0,0,0, */
	/* 8a50 */ 0xbabe,0xc2c2,0xebc8,0,0xbedb,0xc9be,0,0, 0,0,0,0xebc7,0,0,0xbbec,0, /* '詐','詑','詒',0,'詔','評',0,0, 0,0,0,'詛',0,0,'詞',0, */
	/* 8a60 */ 0xb1d3,0,0xebce,0xb7d8,0,0,0xbbee,0, 0,0xbbed,0,0xcfcd,0xebcd,0xebcc,0xc1a7,0, /* '詠',0,'詢','詣',0,0,'試',0, 0,'詩',0,'詫','詬','詭','詮',0, */
	/* 8a70 */ 0xb5cd,0xcfc3,0xb3ba,0xbedc,0,0,0,0, 0,0xfbe9,0,0,0xebcb,0,0,0, /* '詰','話','該','詳',0,0,0,0, 0,'詹',0,0,'詼',0,0,0, */
	/* 8a80 */ 0,0,0xebd0,0,0xebd1,0xebcf,0,0xb8d8, 0,0xcdc0,0,0,0xbbef,0xc7a7,0,0, /* 0,0,'誂',0,'誄','誅',0,'誇', 0,'誉',0,0,'誌','認',0,0, */
	/* 8a90 */ 0,0xebd4,0,0xc0c0,0,0xc3c2,0,0, 0xcdb6,0,0xebd7,0,0,0,0xb8ec,0, /* 0,'誑',0,'誓',0,'誕',0,0, '誘',0,'誚',0,0,0,'語',0, */
	/* 8aa0 */ 0xc0bf,0xebd3,0,0xebd8,0xb8ed,0xebd5,0xebd6,0xfbea, 0xebd2,0,0,0,0xc0e2,0xc6c9,0,0, /* '誠','誡',0,'誣','誤','誥','誦','誧', '誨',0,0,0,'説','読',0,0, */
	/* 8ab0 */ 0xc3af,0,0xb2dd,0,0,0,0,0, 0,0xc8f0,0,0,0xb5c3,0,0xfbeb,0xc4b4, /* '誰',0,'課',0,0,0,0,0, 0,'誹',0,0,'誼',0,'誾','調', */
	/* 8ac0 */ 0,0,0xebdb,0,0xebd9,0,0,0xc3cc, 0,0,0,0xc0c1,0xb4d2,0xebda,0,0xbfdb, /* 0,0,'諂',0,'諄',0,0,'談', 0,0,0,'請','諌','諍',0,'諏', */
	/* 8ad0 */ 0,0,0xceca,0,0,0,0xcfc0,0, 0,0,0xebdc,0xebe7,0xc4b5,0,0xebe6,0xfbec, /* 0,0,'諒',0,0,0,'論',0, 0,0,'諚','諛','諜',0,'諞','諟', */
	/* 8ae0 */ 0xebe3,0xebeb,0xebe4,0,0xebe0,0,0xc4fc,0xebdf, 0,0,0,0xebdd,0,0xcda1,0xbbf0,0, /* '諠','諡','諢',0,'諤',0,'諦','諧', 0,0,0,'諫',0,'諭','諮',0, */
	/* 8af0 */ 0,0xebe1,0,0xebde,0,0,0xfbee,0xebe5, 0xbdf4,0,0xb8c1,0,0,0,0xc2fa,0, /* 0,'諱',0,'諳',0,0,'諶','諷', '諸',0,'諺',0,0,0,'諾',0, */
	/* 8b00 */ 0xcbc5,0xb1da,0xb0e2,0,0xc6a5,0,0,0xebe9, 0,0,0,0,0xebe8,0,0xc6e6,0, /* '謀','謁','謂',0,'謄',0,0,'謇', 0,0,0,0,'謌',0,'謎',0, */
	/* 8b10 */ 0xebed,0,0,0,0xebe2,0,0xebec,0xebee, 0,0xb8ac,0xebea,0xb9d6,0,0xbcd5,0,0, /* '謐',0,0,0,'謔',0,'謖','謗', 0,'謙','謚','講',0,'謝',0,0, */
	/* 8b20 */ 0xebef,0xcdd8,0,0,0,0,0xebf2,0, 0xebf5,0,0,0xebf3,0xc9b5,0,0,0, /* '謠','謡',0,0,0,0,'謦',0, '謨',0,0,'謫','謬',0,0,0, */
	/* 8b30 */ 0,0,0,0xebf0,0,0,0,0, 0,0xb6e0,0,0,0,0,0xebf4,0, /* 0,0,0,'謳',0,0,0,0, 0,'謹',0,0,0,0,'謾',0, */
	/* 8b40 */ 0,0xebf6,0,0,0,0,0,0, 0,0xebfa,0,0,0xebf7,0,0xebf9,0xebf8, /* 0,'譁',0,0,0,0,0,0, 0,'證',0,0,'譌',0,'譎','譏', */
	/* 8b50 */ 0,0,0,0xfbef,0,0,0xebfb,0, 0xbcb1,0,0xebfd,0xebfc,0xc9e8,0,0,0xeca1, /* 0,0,0,'譓',0,0,'譖',0, '識',0,'譚','譛','譜',0,0,'譟', */
	/* 8b60 */ 0,0,0,0,0,0,0xb7d9,0, 0,0,0,0xebfe,0xeca2,0,0,0xeca3, /* 0,0,0,0,0,0,'警',0, 0,0,0,'譫','譬',0,0,'譯', */
	/* 8b70 */ 0xb5c4,0xe6c1,0xbef9,0,0xeca4,0,0,0xb8ee, 0,0,0,0,0,0xeca5,0,0xfbf0, /* '議','譱','譲',0,'譴',0,0,'護', 0,0,0,0,0,'譽',0,'譿', */
	/* 8b80 */ 0xeca6,0,0,0xbbbe,0,0,0,0, 0,0,0xdace,0,0xeca7,0,0xeca8,0, /* '讀',0,0,'讃',0,0,0,0, 0,0,'變',0,'讌',0,'讎',0, */
	/* 8b90 */ 0xbdb2,0,0xeca9,0xecaa,0,0,0xecab,0, 0,0xecac,0xecad,0,0,0,0,0, /* '讐',0,'讒','讓',0,0,'讖',0, 0,'讙','讚',0,0,0,0,0, */
	/* 8ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c30 */ 0,0,0,0,0,0,0,0xc3ab, 0,0,0xecae,0,0,0,0,0xecb0, /* 0,0,0,0,0,0,0,'谷', 0,0,'谺',0,0,0,0,'谿', */
	/* 8c40 */ 0,0xecaf,0,0,0,0,0xc6a6,0, 0xecb1,0,0xcbad,0,0xecb2,0,0xecb3,0, /* 0,'豁',0,0,0,0,'豆',0, '豈',0,'豊',0,'豌',0,'豎',0, */
	/* 8c50 */ 0xecb4,0,0,0,0,0xecb5,0,0, 0,0,0xc6da,0,0,0,0,0, /* '豐',0,0,0,0,'豕',0,0, 0,0,'豚',0,0,0,0,0, */
	/* 8c60 */ 0,0xbedd,0xecb6,0,0,0,0,0, 0,0,0xb9eb,0xd0ae,0xecb7,0,0,0, /* 0,'象','豢',0,0,0,0,0, 0,0,'豪','豫','豬',0,0,0, */
	/* 8c70 */ 0,0,0,0,0,0,0,0, 0xecb8,0xc9bf,0xecb9,0,0xecc1,0,0,0, /* 0,0,0,0,0,0,0,0, '豸','豹','豺',0,'豼',0,0,0, */
	/* 8c80 */ 0,0,0xecba,0,0,0xecbc,0,0, 0,0xecbb,0xecbd,0,0xcbc6,0xecbe,0xecbf,0, /* 0,0,'貂',0,0,'貅',0,0, 0,'貉','貊',0,'貌','貍','貎',0, */
	/* 8c90 */ 0,0,0,0,0xecc0,0,0,0, 0xecc2,0,0,0,0,0xb3ad,0xc4e7,0, /* 0,0,0,0,'貔',0,0,0, '貘',0,0,0,0,'貝','貞',0, */
	/* 8ca0 */ 0xc9e9,0xbae2,0xb9d7,0,0,0,0,0xc9cf, 0xb2df,0xc8ce,0xecc5,0xb4d3,0xc0d5,0xecc4,0xecc9,0xc3f9, /* '負','財','貢',0,0,0,0,'貧', '貨','販','貪','貫','責','貭','貮','貯', */
	/* 8cb0 */ 0xcce3,0,0xecc7,0xecc8,0xb5ae,0,0xecca,0xc7e3, 0xc2df,0,0,0xc8f1,0xc5bd,0xecc6,0,0xcbc7, /* '貰',0,'貲','貳','貴',0,'貶','買', '貸',0,0,'費','貼','貽',0,'貿', */
	/* 8cc0 */ 0xb2ec,0xeccc,0xcfa8,0xc4c2,0xcfc5,0,0,0xbbf1, 0xeccb,0,0xc2b1,0,0,0xecdc,0xc1a8,0, /* '賀','賁','賂','賃','賄',0,0,'資', '賈',0,'賊',0,0,'賍','賎',0, */
	/* 8cd0 */ 0,0xc6f8,0,0xc9d0,0,0,0,0, 0,0,0xeccf,0xbbbf,0xbbf2,0,0xbede,0, /* 0,'賑',0,'賓',0,0,0,0, 0,0,'賚','賛','賜',0,'賞',0, */
	/* 8ce0 */ 0xc7e5,0,0xb8ad,0xecce,0xeccd,0,0xc9ea,0, 0,0,0xbcc1,0,0,0xc5d2,0,0, /* '賠',0,'賢','賣','賤',0,'賦',0, 0,0,'質',0,0,'賭',0,0, */
	/* 8cf0 */ 0xfbf1,0,0,0,0xfbf2,0,0,0, 0,0,0xecd1,0xecd2,0xb9d8,0xecd0,0,0, /* '賰',0,0,0,'賴',0,0,0, 0,0,'賺','賻','購','賽',0,0, */
	/* 8d00 */ 0,0,0,0,0xecd3,0xecd4,0,0xecd6, 0xc2a3,0,0xecd5,0xb4e6,0,0xecd8,0,0xecd7, /* 0,0,0,0,'贄','贅',0,'贇', '贈',0,'贊','贋',0,'贍',0,'贏', */
	/* 8d10 */ 0xecd9,0,0xfbf3,0xecdb,0xecdd,0,0xecde,0, 0,0,0,0,0,0,0,0, /* '贐',0,'贒','贓','贔',0,'贖',0, 0,0,0,0,0,0,0,0, */
	/* 8d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d60 */ 0,0,0,0,0xc0d6,0,0xbccf,0xecdf, 0,0,0,0xb3d2,0,0xece0,0,0, /* 0,0,0,0,'赤',0,'赦','赧', 0,0,0,'赫',0,'赭',0,0, */
	/* 8d70 */ 0xc1f6,0xece1,0,0xece2,0xc9eb,0,0xfbf4,0xb5af, 0,0,0,0,0,0,0,0, /* '走','赱',0,'赳','赴',0,'赶','起', 0,0,0,0,0,0,0,0, */
	/* 8d80 */ 0,0xece3,0,0,0,0xc4b6,0,0, 0,0,0xb1db,0,0,0,0,0, /* 0,'趁',0,0,0,'超',0,0, 0,0,'越',0,0,0,0,0, */
	/* 8d90 */ 0,0,0,0,0,0,0,0, 0,0xece4,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'趙',0,0,0,0,0,0, */
	/* 8da0 */ 0,0,0,0xbcf1,0,0,0,0, 0xbff6,0,0,0,0,0,0,0, /* 0,0,0,'趣',0,0,0,0, '趨',0,0,0,0,0,0,0, */
	/* 8db0 */ 0,0,0,0xc2ad,0,0,0,0, 0,0,0xece7,0,0,0,0xece6,0, /* 0,0,0,'足',0,0,0,0, 0,0,'趺',0,0,0,'趾',0, */
	/* 8dc0 */ 0,0,0xece5,0,0,0,0,0, 0,0,0,0xeced,0xeceb,0,0,0xece8, /* 0,0,'跂',0,0,0,0,0, 0,0,0,'跋','跌',0,0,'跏', */
	/* 8dd0 */ 0,0,0,0,0,0,0xecea,0, 0,0,0xece9,0xecec,0,0xb5f7,0,0xecf0, /* 0,0,0,0,0,0,'跖',0, 0,0,'跚','跛',0,'距',0,'跟', */
	/* 8de0 */ 0,0xc0d7,0,0xecf1,0,0,0,0, 0xb8d9,0,0xecee,0xecef,0,0,0,0xcfa9, /* 0,'跡',0,'跣',0,0,0,0, '跨',0,'跪','跫',0,0,0,'路', */
	/* 8df0 */ 0,0,0,0xc4b7,0,0xc1a9,0,0, 0,0,0,0,0xecf2,0,0,0xecf5, /* 0,0,0,'跳',0,'践',0,0, 0,0,0,0,'跼',0,0,'跿', */
	/* 8e00 */ 0,0,0,0,0,0,0,0, 0xecf3,0xecf4,0xcdd9,0,0,0,0,0xc6a7, /* 0,0,0,0,0,0,0,0, '踈','踉','踊',0,0,0,0,'踏', */
	/* 8e10 */ 0xecf8,0,0,0,0,0,0,0, 0,0,0,0,0,0xecf6,0xecf7,0xecf9, /* '踐',0,0,0,0,0,0,0, 0,0,0,0,0,'踝','踞','踟', */
	/* 8e20 */ 0,0,0,0,0,0,0,0, 0,0,0xeda9,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'踪',0,0,0,0,0, */
	/* 8e30 */ 0xecfc,0,0,0,0xecfd,0xecfb,0,0, 0,0,0,0,0,0,0,0, /* '踰',0,0,0,'踴','踵',0,0, 0,0,0,0,0,0,0,0, */
	/* 8e40 */ 0,0,0xecfa,0,0xc4fd,0,0,0xeda1, 0xeda5,0xeda2,0xecfe,0,0xeda3,0,0,0, /* 0,0,'蹂',0,'蹄',0,0,'蹇', '蹈','蹉','蹊',0,'蹌',0,0,0, */
	/* 8e50 */ 0xeda4,0,0,0,0,0xedab,0,0, 0,0xeda6,0,0,0,0,0,0xc0d8, /* '蹐',0,0,0,0,'蹕',0,0, 0,'蹙',0,0,0,0,0,'蹟', */
	/* 8e60 */ 0xeda8,0,0,0xedaa,0xeda7,0,0,0, 0,0,0,0,0,0,0,0, /* '蹠',0,0,'蹣','蹤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8e70 */ 0,0,0xedad,0,0xbdb3,0,0xedac,0, 0,0,0,0,0xedae,0,0,0, /* 0,0,'蹲',0,'蹴',0,'蹶',0, 0,0,0,0,'蹼',0,0,0, */
	/* 8e80 */ 0,0xedaf,0,0,0xedb2,0xedb1,0,0xedb0, 0,0,0xedb4,0xedb3,0,0xccf6,0,0, /* 0,'躁',0,0,'躄','躅',0,'躇', 0,0,'躊','躋',0,'躍',0,0, */
	/* 8e90 */ 0,0xedb6,0,0xedb5,0xedb7,0,0,0, 0,0xedb8,0,0,0,0,0,0, /* 0,'躑',0,'躓','躔',0,0,0, 0,'躙',0,0,0,0,0,0, */
	/* 8ea0 */ 0,0xedba,0,0,0,0,0,0, 0,0,0xedb9,0xbfc8,0xedbb,0,0,0xb6ed, /* 0,'躡',0,0,0,0,0,0, 0,0,'躪','身','躬',0,0,'躯', */
	/* 8eb0 */ 0xedbc,0xedbe,0,0,0,0,0,0, 0,0,0,0,0,0,0xedbf,0, /* '躰','躱',0,0,0,0,0,0, 0,0,0,0,0,0,'躾',0, */
	/* 8ec0 */ 0,0,0,0,0,0xedc0,0xedbd,0, 0xedc1,0,0xbcd6,0xedc2,0xb5b0,0xb7b3,0,0xfbf6, /* 0,0,0,0,0,'軅','軆',0, '軈',0,'車','軋','軌','軍',0,'軏', */
	/* 8ed0 */ 0,0,0xb8ae,0,0,0,0,0, 0,0,0,0xedc3,0,0,0,0xc6f0, /* 0,0,'軒',0,0,0,0,0, 0,0,0,'軛',0,0,0,'軟', */
	/* 8ee0 */ 0,0,0xc5be,0xedc4,0,0,0,0, 0,0,0,0xedc7,0,0,0,0, /* 0,0,'転','軣',0,0,0,0, 0,0,0,'軫',0,0,0,0, */
	/* 8ef0 */ 0,0,0,0,0,0,0,0, 0xbcb4,0,0,0xedc6,0xedc5,0xb7da,0xedc8,0, /* 0,0,0,0,0,0,0,0, '軸',0,0,'軻','軼','軽','軾',0, */
	/* 8f00 */ 0,0,0,0xb3d3,0,0xedca,0,0, 0,0xbadc,0xedc9,0,0xedd2,0,0,0, /* 0,0,0,'較',0,'輅',0,0, 0,'載','輊',0,'輌',0,0,0, */
	/* 8f10 */ 0,0,0xedcc,0xedce,0xcae5,0xedcb,0,0, 0,0xedcd,0,0xedd1,0xedcf,0xb5b1,0,0xedd0, /* 0,0,'輒','輓','輔','輕',0,0, 0,'輙',0,'輛','輜','輝',0,'輟', */
	/* 8f20 */ 0,0,0,0,0,0,0xedd3,0, 0,0xc7da,0xced8,0,0,0,0,0xbdb4, /* 0,0,0,0,0,0,'輦',0, 0,'輩','輪',0,0,0,0,'輯', */
	/* 8f30 */ 0,0,0,0xedd4,0,0,0,0, 0xcda2,0xedd6,0,0xedd5,0,0,0xedd9,0xcdc1, /* 0,0,0,'輳',0,0,0,0, '輸','輹',0,'輻',0,0,'輾','輿', */
	/* 8f40 */ 0,0,0xedd8,0,0xb3ed,0xedd7,0xeddc,0, 0,0xeddb,0,0,0xedda,0xc5b2,0xeddd,0, /* 0,0,'轂',0,'轄','轅','轆',0, 0,'轉',0,0,'轌','轍','轎',0, */
	/* 8f50 */ 0,0,0,0,0,0,0,0xedde, 0,0,0,0,0xeddf,0,0,0xb9ec, /* 0,0,0,0,0,0,0,'轗', 0,0,0,0,'轜',0,0,'轟', */
	/* 8f60 */ 0,0xb7a5,0xede0,0xede1,0xede2,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'轡','轢','轣','轤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0xbfc9,0xede3,0,0xbcad,0xede4, /* 0,0,0,0,0,0,0,0, 0,0,0,'辛','辜',0,'辞','辟', */
	/* 8fa0 */ 0,0,0,0xede5,0,0,0,0xd2a1, 0xd1fe,0,0,0,0,0xede6,0xe5f0,0xede7, /* 0,0,0,'辣',0,0,0,'辧', '辨',0,0,0,0,'辭','辮','辯', */
	/* 8fb0 */ 0xc3a4,0xbfab,0xc7c0,0,0,0,0,0xede8, 0,0,0xcad5,0xc4d4,0xb9fe,0,0,0xc3a9, /* '辰','辱','農',0,0,0,0,'辷', 0,0,'辺','辻','込',0,0,'辿', */
	/* 8fc0 */ 0,0,0xb1aa,0,0xcbf8,0xbfd7,0,0, 0,0,0,0,0,0,0xb7de,0, /* 0,0,'迂',0,'迄','迅',0,0, 0,0,0,0,0,0,'迎',0, */
	/* 8fd0 */ 0,0xb6e1,0,0,0xcad6,0,0,0, 0,0,0xede9,0,0,0,0,0, /* 0,'近',0,0,'返',0,0,0, 0,0,'迚',0,0,0,0,0, */
	/* 8fe0 */ 0,0,0xedeb,0,0,0xedea,0xb2e0,0, 0,0xc6f6,0xedec,0xc7f7,0,0xc5b3,0,0xeded, /* 0,0,'迢',0,0,'迥','迦',0, 0,'迩','迪','迫',0,'迭',0,'迯', */
	/* 8ff0 */ 0xbdd2,0,0,0,0xedef,0,0,0xccc2, 0xedfe,0xedf1,0xedf2,0,0,0xc4c9,0,0, /* '述',0,0,0,'迴',0,0,'迷', '迸','迹','迺',0,0,'追',0,0, */
	/* 9000 */ 0xc2e0,0xc1f7,0,0xc6a8,0,0xedf0,0xb5d5,0, 0,0,0,0xedf9,0,0xedf6,0xeea5,0xc6a9, /* '退','送',0,'逃',0,'逅','逆',0, 0,0,0,'逋',0,'逍','逎','透', */
	/* 9010 */ 0xc3e0,0xedf3,0,0xc4fe,0xc5d3,0xedf4,0xedf8,0xbfe0, 0,0xc7e7,0xc4cc,0,0,0xc0c2,0xedf7,0xc2ae, /* '逐','逑',0,'逓','途','逕','逖','逗', 0,'這','通',0,0,'逝','逞','速', */
	/* 9020 */ 0xc2a4,0xedf5,0xb0a9,0xcfa2,0,0,0,0xedfa, 0,0,0,0,0,0,0xc2e1,0, /* '造','逡','逢','連',0,0,0,'逧', 0,0,0,0,0,0,'逮',0, */
	/* 9030 */ 0,0xbdb5,0xbfca,0,0,0xedfc,0xedfb,0, 0xb0ef,0xedfd,0,0,0xc9af,0,0xeea7,0, /* 0,'週','進',0,0,'逵','逶',0, '逸','逹',0,0,'逼',0,'逾',0, */
	/* 9040 */ 0,0xc6db,0xbfeb,0,0,0xc3d9,0,0xb6f8, 0,0xeea6,0xcdb7,0xb1bf,0,0xcad7,0xb2e1,0xeea1, /* 0,'遁','遂',0,0,'遅',0,'遇', 0,'遉','遊','運',0,'遍','過','遏', */
	/* 9050 */ 0xeea2,0xeea3,0xeea4,0xc6bb,0xc3a3,0xb0e3,0xeea8,0, 0xeea9,0xf4a3,0,0,0xc2bd,0,0xeeaa,0, /* '遐','遑','遒','道','達','違','遖',0, '遘','遙',0,0,'遜',0,'遞',0, */
	/* 9060 */ 0xb1f3,0xc1cc,0,0xb8af,0,0xcdda,0,0xfbf9, 0xeeab,0xc5ac,0,0,0,0xc1f8,0xbcd7,0xeeac, /* '遠','遡',0,'遣',0,'遥',0,'遧', '遨','適',0,0,0,'遭','遮','遯', */
	/* 9070 */ 0,0,0xeeaf,0,0,0xbde5,0xeead,0xc1ab, 0xc1aa,0,0xb0e4,0,0xcecb,0xeeb1,0,0xc8f2, /* 0,0,'遲',0,0,'遵','遶','遷', '選',0,'遺',0,'遼','遽',0,'避', */
	/* 9080 */ 0xeeb3,0xeeb2,0xeeb0,0xe3e4,0xb4d4,0,0,0xedee, 0,0xeeb5,0xeeb4,0,0,0,0,0xeeb6, /* '邀','邁','邂','邃','還',0,0,'邇', 0,'邉','邊',0,0,0,0,'邏', */
	/* 9090 */ 0,0xcdb8,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'邑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 90a0 */ 0,0,0,0xc6e1,0,0,0xcbae,0, 0xeeb7,0,0xbcd9,0,0,0,0,0xeeb8, /* 0,0,0,'那',0,0,'邦',0, '邨',0,'邪',0,0,0,0,'邯', */
	/* 90b0 */ 0,0xeeb9,0,0,0,0xeeba,0,0, 0xc5a1,0,0,0,0,0,0,0, /* 0,'邱',0,0,0,'邵',0,0, '邸',0,0,0,0,0,0,0, */
	/* 90c0 */ 0,0xb0ea,0,0,0,0,0,0, 0,0,0xb9d9,0,0,0,0xcfba,0, /* 0,'郁',0,0,0,0,0,0, 0,0,'郊',0,0,0,'郎',0, */
	/* 90d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0xeebe,0,0,0xfbfa,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'郛',0,0,'郞',0, */
	/* 90e0 */ 0,0xb7b4,0xeebb,0,0xeebc,0,0,0, 0xc9f4,0,0,0,0,0xb3d4,0,0, /* 0,'郡','郢',0,'郤',0,0,0, '部',0,0,0,0,'郭',0,0, */
	/* 90f0 */ 0,0,0,0,0,0xcdb9,0,0xb6bf, 0,0,0,0,0,0xc5d4,0,0, /* 0,0,0,0,0,'郵',0,'郷', 0,0,0,0,0,'都',0,0, */
	/* 9100 */ 0,0,0xeebf,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'鄂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9110 */ 0,0,0xeec0,0,0,0xfbfc,0,0, 0,0xeec1,0,0,0,0,0,0, /* 0,0,'鄒',0,0,'鄕',0,0, 0,'鄙',0,0,0,0,0,0, */
	/* 9120 */ 0,0,0,0,0,0,0,0xfbfd, 0,0,0,0,0,0xc5a2,0,0, /* 0,0,0,0,0,0,0,'鄧', 0,0,0,0,0,'鄭',0,0, */
	/* 9130 */ 0xeec3,0,0xeec2,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '鄰',0,'鄲',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9140 */ 0,0,0,0,0,0,0,0, 0,0xc6d3,0xeec4,0xbdb6,0xbce0,0xc7db,0xc3f1,0, /* 0,0,0,0,0,0,0,0, 0,'酉','酊','酋','酌','配','酎',0, */
	/* 9150 */ 0,0,0xbcf2,0,0xbfec,0,0xeec5,0, 0xeec6,0,0,0,0,0,0,0, /* 0,0,'酒',0,'酔',0,'酖',0, '酘',0,0,0,0,0,0,0, */
	/* 9160 */ 0,0,0xbfdd,0xeec7,0,0xeec8,0,0, 0,0xeec9,0xcdef,0,0xbdb7,0,0,0, /* 0,0,'酢','酣',0,'酥',0,0, 0,'酩','酪',0,'酬',0,0,0, */
	/* 9170 */ 0,0,0xeecb,0xeeca,0,0xb9da,0,0xb9f3, 0xbbc0,0,0,0,0,0,0,0, /* 0,0,'酲','酳',0,'酵',0,'酷', '酸',0,0,0,0,0,0,0, */
	/* 9180 */ 0,0,0xeece,0,0,0,0,0xbde6, 0,0xeecd,0,0xeecc,0,0xc2e9,0,0, /* 0,0,'醂',0,0,0,0,'醇', 0,'醉',0,'醋',0,'醍',0,0, */
	/* 9190 */ 0xb8ef,0,0xc0c3,0,0,0,0,0xc8b0, 0,0,0,0,0xbdb9,0,0,0, /* '醐',0,'醒',0,0,0,0,'醗', 0,0,0,0,'醜',0,0,0, */
	/* 91a0 */ 0,0,0xeecf,0,0xbedf,0,0,0, 0,0,0xeed2,0xeed0,0,0,0,0xeed1, /* 0,0,'醢',0,'醤',0,0,0, 0,0,'醪','醫',0,0,0,'醯', */
	/* 91b0 */ 0,0,0,0,0xeed4,0xeed3,0,0, 0xbefa,0,0xeed5,0,0,0,0,0, /* 0,0,0,0,'醴','醵',0,0, '醸',0,'醺',0,0,0,0,0, */
	/* 91c0 */ 0xeed6,0xeed7,0,0,0,0,0xc8d0,0xbad3, 0xbce1,0xeed8,0,0xeed9,0xcea4,0xbdc5,0xccee,0xcecc, /* '釀','釁',0,0,0,0,'釆','采', '釈','釉',0,'釋','里','重','野','量', */
	/* 91d0 */ 0xeeda,0xb6e2,0,0,0,0,0xeedb,0xfca1, 0xc5a3,0,0xfbfe,0xeede,0xb3f8,0xbfcb,0xfca2,0xeedc, /* '釐','金',0,0,0,0,'釖','釗', '釘',0,'釚','釛','釜','針','釞','釟', */
	/* 91e0 */ 0,0xeedd,0,0xc4e0,0xfca5,0xfca6,0xcbd5,0xb6fc, 0,0,0,0,0,0xfca3,0xfca4,0, /* 0,'釡',0,'釣','釤','釥','釦','釧', 0,0,0,0,0,'釭','釮',0, */
	/* 91f0 */ 0,0,0,0,0,0xeee0,0xeee1,0, 0,0,0,0,0xeedf,0,0,0xeee3, /* 0,0,0,0,0,'釵','釶',0, 0,0,0,0,'釼',0,0,'釿', */
	/* 9200 */ 0,0,0,0,0,0,0xfca7,0, 0,0,0xfca9,0,0,0xc6df,0xb3c3,0, /* 0,0,0,0,0,0,'鈆',0, 0,0,'鈊',0,0,'鈍','鈎',0, */
	/* 9210 */ 0xfca8,0xeee7,0,0,0xeee4,0xeee6,0,0, 0,0,0,0,0,0,0xeee2,0, /* '鈐','鈑',0,0,'鈔','鈕',0,0, 0,0,0,0,0,0,'鈞',0, */
	/* 9220 */ 0,0,0,0,0,0,0,0, 0,0xefcf,0,0,0xeee5,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'鈩',0,0,'鈬',0,0,0, */
	/* 9230 */ 0,0,0,0,0xceeb,0,0,0xb8da, 0,0xfcb0,0xfcaa,0,0xfcac,0,0,0xeeef, /* 0,0,0,0,'鈴',0,0,'鈷', 0,'鈹','鈺',0,'鈼',0,0,'鈿', */
	/* 9240 */ 0xfcab,0,0,0,0xc5b4,0xeeea,0,0, 0xeeed,0xeeeb,0,0xeef0,0,0,0xfcad,0, /* '鉀',0,0,0,'鉄','鉅',0,0, '鉈','鉉',0,'鉋',0,0,'鉎',0, */
	/* 9250 */ 0xeef1,0xfcaf,0,0,0,0,0,0xeee9, 0,0xfcae,0xeef6,0xb1f4,0,0,0xeee8,0, /* '鉐','鉑',0,0,0,0,0,'鉗', 0,'鉙','鉚','鉛',0,0,'鉞',0, */
	/* 9260 */ 0,0,0xc8ad,0,0xeeec,0,0xbee0,0xfcb1, 0,0,0,0,0,0,0,0, /* 0,0,'鉢',0,'鉤',0,'鉦','鉧', 0,0,0,0,0,0,0,0, */
	/* 9270 */ 0,0xb9db,0,0,0,0,0,0xfcb3, 0xfcb4,0,0,0,0,0,0xcbc8,0, /* 0,'鉱',0,0,0,0,0,'鉷', '鉸',0,0,0,0,0,'鉾',0, */
	/* 9280 */ 0xb6e4,0,0,0xbdc6,0,0xc6bc,0,0, 0xf9a4,0,0,0,0,0,0,0, /* '銀',0,0,'銃',0,'銅',0,0, '銈',0,0,0,0,0,0,0, */
	/* 9290 */ 0,0xc1ad,0,0xeef4,0,0xeeee,0xeef3,0, 0xccc3,0,0xc4b8,0xeef5,0xeef2,0,0,0, /* 0,'銑',0,'銓',0,'銕','銖',0, '銘',0,'銚','銛','銜',0,0,0, */
	/* 92a0 */ 0,0,0,0,0,0,0,0xfcb2, 0,0,0,0,0,0xc1ac,0,0, /* 0,0,0,0,0,0,0,'銧', 0,0,0,0,0,'銭',0,0, */
	/* 92b0 */ 0,0,0,0,0,0,0,0xeef9, 0,0xeef8,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'銷', 0,'銹',0,0,0,0,0,0, */
	/* 92c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xeef7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'鋏', */
	/* 92d0 */ 0xfcb8,0,0xcbaf,0xfcbc,0,0xfcba,0,0xfcb6, 0,0xfcb7,0,0,0,0,0,0, /* '鋐',0,'鋒','鋓',0,'鋕',0,'鋗', 0,'鋙',0,0,0,0,0,0, */
	/* 92e0 */ 0xfcbb,0,0,0,0xbdfb,0,0,0xfcb5, 0,0xeefa,0xcadf,0,0,0xb1d4,0,0, /* '鋠',0,0,0,'鋤',0,0,'鋧', 0,'鋩','鋪',0,0,'鋭',0,0, */
	/* 92f0 */ 0,0,0xc9c6,0xc3f2,0,0,0,0, 0xb5f8,0xf9aa,0xeefc,0xfcbf,0xb9dd,0,0,0xfcc2, /* 0,0,'鋲','鋳',0,0,0,0, '鋸','鋹','鋺','鋻','鋼',0,0,'鋿', */
	/* 9300 */ 0,0,0xfcc4,0,0,0,0xbbac,0, 0,0,0,0,0,0,0,0xeefb, /* 0,0,'錂',0,0,0,'錆',0, 0,0,0,0,0,0,0,'錏', */
	/* 9310 */ 0xbfed,0,0,0,0,0,0,0, 0xbfee,0xefa1,0xefa3,0,0,0xfcc3,0xfcc1,0, /* '錐',0,0,0,0,0,0,0, '錘','錙','錚',0,0,'錝','錞',0, */
	/* 9320 */ 0xbefb,0xfcbe,0xefa2,0xefa4,0,0xfcbd,0xb6d3,0, 0xc9c5,0,0,0xbce2,0xcfa3,0,0xeefe,0xbaf8, /* '錠','錡','錢','錣',0,'錥','錦',0, '錨',0,0,'錫','錬',0,'錮','錯', */
	/* 9330 */ 0,0,0xcfbf,0,0,0xefa6,0,0, 0,0,0xefa5,0xefa7,0,0,0,0, /* 0,0,'録',0,0,'錵',0,0, 0,0,'錺','錻',0,0,0,0, */
	/* 9340 */ 0,0,0,0,0xeefd,0,0,0, 0xf9a3,0,0,0xc6e9,0,0xc5d5,0,0, /* 0,0,0,0,'鍄',0,0,0, '鍈',0,0,'鍋',0,'鍍',0,0, */
	/* 9350 */ 0,0,0,0,0xc4d7,0,0xefac,0xfcc6, 0,0,0,0xc3c3,0xefa8,0,0,0, /* 0,0,0,0,'鍔',0,'鍖','鍗', 0,0,0,'鍛','鍜',0,0,0, */
	/* 9360 */ 0xefa9,0,0,0,0,0,0,0, 0,0,0,0,0xb7ad,0,0xefab,0, /* '鍠',0,0,0,0,0,0,0, 0,0,0,0,'鍬',0,'鍮',0, */
	/* 9370 */ 0xfcc5,0,0,0,0,0xb8b0,0,0, 0,0,0,0,0xefaa,0,0xbee1,0, /* '鍰',0,0,0,0,'鍵',0,0, 0,0,0,0,'鍼',0,'鍾',0, */
	/* 9380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xb3f9,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'鎌',0,0,0, */
	/* 9390 */ 0,0,0,0,0xefb0,0,0xbabf,0xc1f9, 0,0,0xc4ca,0,0,0,0,0, /* 0,0,0,0,'鎔',0,'鎖','鎗', 0,0,'鎚',0,0,0,0,0, */
	/* 93a0 */ 0,0,0,0,0xfcc7,0,0,0xb3bb, 0,0,0,0,0xefae,0xefaf,0xc4c3,0, /* 0,0,0,0,'鎤',0,0,'鎧', 0,0,0,0,'鎬','鎭','鎮',0, */
	/* 93b0 */ 0xefad,0,0,0,0,0,0,0, 0,0xefb1,0,0,0,0,0,0, /* '鎰',0,0,0,0,0,0,0, 0,'鎹',0,0,0,0,0,0, */
	/* 93c0 */ 0,0,0,0xefb7,0,0,0xfcc8,0, 0xefba,0,0,0,0,0,0,0, /* 0,0,0,'鏃',0,0,'鏆',0, '鏈',0,0,0,0,0,0,0, */
	/* 93d0 */ 0xefb9,0xc5ad,0,0,0,0,0xefb2,0xefb3, 0xefb6,0,0,0,0,0xefb8,0xfcc9,0, /* '鏐','鏑',0,0,0,0,'鏖','鏗', '鏘',0,0,0,0,'鏝','鏞',0, */
	/* 93e0 */ 0,0xb6c0,0,0,0xefbb,0xefb5,0,0, 0xefb4,0,0,0,0,0,0,0, /* 0,'鏡',0,0,'鏤','鏥',0,0, '鏨',0,0,0,0,0,0,0, */
	/* 93f0 */ 0,0,0,0,0,0,0,0, 0xfcca,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '鏸',0,0,0,0,0,0,0, */
	/* 9400 */ 0,0,0,0xefbf,0,0,0,0xefc0, 0,0,0,0,0,0,0,0, /* 0,0,0,'鐃',0,0,0,'鐇', 0,0,0,0,0,0,0,0, */
	/* 9410 */ 0xefc1,0,0,0xefbe,0xefbd,0,0,0, 0xbee2,0xc6aa,0xefbc,0,0,0,0,0, /* '鐐',0,0,'鐓','鐔',0,0,0, '鐘','鐙','鐚',0,0,0,0,0, */
	/* 9420 */ 0,0xefc5,0,0,0,0,0,0, 0,0,0,0xefc3,0,0,0,0, /* 0,'鐡',0,0,0,0,0,0, 0,0,0,'鐫',0,0,0,0, */
	/* 9430 */ 0,0xfccb,0,0,0,0xefc4,0xefc2,0, 0xc2f8,0,0xefc6,0,0,0,0,0, /* 0,'鐱',0,0,0,'鐵','鐶',0, '鐸',0,'鐺',0,0,0,0,0, */
	/* 9440 */ 0,0xefc7,0,0,0xefc9,0xfccc,0,0, 0xfccd,0,0,0,0,0,0,0, /* 0,'鑁',0,0,'鑄','鑅',0,0, '鑈',0,0,0,0,0,0,0, */
	/* 9450 */ 0,0xb4d5,0xefc8,0xccfa,0,0,0,0, 0,0,0xefd4,0xefca,0,0,0xefcd,0, /* 0,'鑑','鑒','鑓',0,0,0,0, 0,0,'鑚','鑛',0,0,'鑞',0, */
	/* 9460 */ 0xefcb,0,0xefcc,0,0,0,0,0, 0,0,0xefce,0,0,0,0,0, /* '鑠',0,'鑢',0,0,0,0,0, 0,0,'鑪',0,0,0,0,0, */
	/* 9470 */ 0xefd0,0,0,0,0,0xefd1,0,0xefd2, 0,0,0,0,0xefd5,0xefd3,0xefd6,0xefd8, /* '鑰',0,0,0,0,'鑵',0,'鑷', 0,0,0,0,'鑼','鑽','鑾','鑿', */
	/* 9480 */ 0,0xefd7,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'钁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9570 */ 0,0,0,0,0,0,0,0xc4b9, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'長', 0,0,0,0,0,0,0,0, */
	/* 9580 */ 0xcce7,0,0xefd9,0xc1ae,0,0,0,0xefda, 0,0xcac4,0xefdb,0xb3ab,0,0,0,0xb1bc, /* '門',0,'閂','閃',0,0,0,'閇', 0,'閉','閊','開',0,0,0,'閏', */
	/* 9590 */ 0,0xb4d7,0xfcce,0xb4d6,0xefdc,0,0xefdd,0, 0xefde,0xefdf,0,0,0,0,0,0, /* 0,'閑','閒','間','閔',0,'閖',0, '閘','閙',0,0,0,0,0,0, */
	/* 95a0 */ 0xefe0,0,0xb4d8,0xb3d5,0xb9de,0xc8b6,0,0xefe2, 0xefe1,0,0,0,0,0xefe3,0,0, /* '閠',0,'関','閣','閤','閥',0,'閧', '閨',0,0,0,0,'閭',0,0, */
	/* 95b0 */ 0,0,0xb1dc,0,0,0,0,0, 0,0xefe6,0,0xefe5,0xefe4,0,0xefe7,0, /* 0,0,'閲',0,0,0,0,0, 0,'閹',0,'閻','閼',0,'閾',0, */
	/* 95c0 */ 0,0,0,0xefea,0,0,0,0xb0c7, 0,0,0xefe8,0,0xefec,0xefeb,0,0, /* 0,0,0,'闃',0,0,0,'闇', 0,0,'闊',0,'闌','闍',0,0, */
	/* 95d0 */ 0,0,0,0,0xefee,0xefed,0xefef,0, 0xc6ae,0,0,0,0xeff0,0,0,0, /* 0,0,0,0,'闔','闕','闖',0, '闘',0,0,0,'關',0,0,0, */
	/* 95e0 */ 0,0xeff1,0xeff3,0,0,0xeff2,0,0, 0,0,0,0,0,0,0,0, /* 0,'闡','闢',0,0,'闥',0,0, 0,0,0,0,0,0,0,0, */
	/* 95f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xc9ec,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'阜',0,0,0, */
	/* 9620 */ 0,0xeff4,0,0,0,0,0,0, 0xeff5,0,0xbae5,0,0,0,0xeff6,0xeff7, /* 0,'阡',0,0,0,0,0,0, '阨',0,'阪',0,0,0,'阮','阯', */
	/* 9630 */ 0,0,0xcbc9,0,0,0,0,0, 0,0,0,0xc1cb,0,0,0,0xb0a4, /* 0,0,'防',0,0,0,0,0, 0,0,0,'阻',0,0,0,'阿', */
	/* 9640 */ 0xc2cb,0,0xeff8,0,0xc9ed,0,0,0, 0,0,0,0xeffb,0xeff9,0xb9df,0,0xeffa, /* '陀',0,'陂',0,'附',0,0,0, 0,0,0,'陋','陌','降',0,'陏', */
	/* 9650 */ 0xb8c2,0,0,0,0,0,0,0, 0,0,0,0xcac5,0xeffd,0xf0a1,0xeffe,0xf0a2, /* '限',0,0,0,0,0,0,0, 0,0,0,'陛','陜','陝','陞','陟', */
	/* 9660 */ 0,0,0xb1a1,0xbfd8,0xbdfc,0xb4d9,0xf0a3,0, 0,0,0xc7e6,0,0xf0a5,0,0,0, /* 0,0,'院','陣','除','陥','陦',0, 0,0,'陪',0,'陬',0,0,0, */
	/* 9670 */ 0xb1a2,0,0xf0a4,0xc4c4,0,0xcecd,0xc6ab,0xeffc, 0xcea6,0,0xb8b1,0,0,0xcddb,0,0, /* '陰',0,'陲','陳',0,'陵','陶','陷', '陸',0,'険',0,0,'陽',0,0, */
	/* 9680 */ 0,0,0,0,0,0xb6f9,0xceb4,0, 0xb7a8,0,0xc2e2,0xe7a1,0,0xf0a6,0xb3ac,0xbfef, /* 0,0,0,0,0,'隅','隆',0, '隈',0,'隊','隋',0,'隍','階','随', */
	/* 9690 */ 0,0,0,0,0xb3d6,0xf0a8,0,0xf0a9, 0xf0a7,0xb7e4,0,0xbadd,0xbee3,0xfcd1,0,0, /* 0,0,0,0,'隔','隕',0,'隗', '隘','隙',0,'際','障','隝',0,0, */
	/* 96a0 */ 0xb1a3,0,0,0xced9,0,0,0,0xf0ab, 0xeeae,0,0xf0aa,0,0,0,0,0xfcd2, /* '隠',0,0,'隣',0,0,0,'隧', '隨',0,'險',0,0,0,0,'隯', */
	/* 96b0 */ 0xf0ae,0xf0ac,0xf0ad,0,0xf0af,0,0xf0b0,0xceec, 0xf0b1,0xf0b2,0,0xc0c9,0xc8bb,0,0,0, /* '隰','隱','隲',0,'隴',0,'隶','隷', '隸','隹',0,'隻','隼',0,0,0, */
	/* 96c0 */ 0xbffd,0xb4e7,0,0,0xcdba,0xb2ed,0xbdb8,0xb8db, 0,0xf0b5,0,0xf0b4,0xbbf3,0xf0b6,0xf0b3,0, /* '雀','雁',0,0,'雄','雅','集','雇', 0,'雉',0,'雋','雌','雍','雎',0, */
	/* 96d0 */ 0,0xbba8,0,0,0,0xf0ba,0xeaad,0, 0,0xd2d6,0,0xbff7,0xf0b8,0,0,0, /* 0,'雑',0,0,0,'雕','雖',0, 0,'雙',0,'雛','雜',0,0,0, */
	/* 96e0 */ 0,0,0xcea5,0xc6f1,0,0,0,0, 0xb1ab,0,0xc0e3,0xbcb6,0,0,0,0, /* 0,0,'離','難',0,0,0,0, '雨',0,'雪','雫',0,0,0,0, */
	/* 96f0 */ 0xcab7,0,0xb1c0,0,0,0,0xceed,0xcdeb, 0,0xf0bb,0,0xc5c5,0,0,0,0, /* '雰',0,'雲',0,0,0,'零','雷', 0,'雹',0,'電',0,0,0,0, */
	/* 9700 */ 0xbcfb,0,0,0,0xf0bc,0,0xf0bd,0xbfcc, 0xf0be,0,0xceee,0,0,0xf0b9,0xf0c0,0xf0c2, /* '需',0,0,0,'霄',0,'霆','震', '霈',0,'霊',0,0,'霍','霎','霏', */
	/* 9710 */ 0,0xf0c1,0,0xf0bf,0,0,0xf0c3,0, 0,0xf0c4,0,0,0xc1fa,0,0xb2e2,0, /* 0,'霑',0,'霓',0,0,'霖',0, 0,'霙',0,0,'霜',0,'霞',0, */
	/* 9720 */ 0,0,0,0,0xf0c5,0,0,0xccb8, 0,0,0xf0c6,0,0,0,0,0, /* 0,0,0,0,'霤',0,0,'霧', 0,0,'霪',0,0,0,0,0, */
	/* 9730 */ 0xf0c7,0,0xcfaa,0xfcd3,0,0,0,0, 0xdbb1,0xf0c8,0,0xfcd4,0,0xf0c9,0xf0ca,0, /* '霰',0,'露','霳',0,0,0,0, '霸','霹',0,'霻',0,'霽','霾',0, */
	/* 9740 */ 0,0,0xf0ce,0xfcd5,0xf0cb,0,0xf0cc,0, 0xf0cd,0xf0cf,0,0,0,0xfcd6,0,0xfcd7, /* 0,0,'靂','靃','靄',0,'靆',0, '靈','靉',0,0,0,'靍',0,'靏', */
	/* 9750 */ 0,0xfcd8,0xc0c4,0,0,0xfcd9,0xccf7,0, 0,0xc0c5,0,0,0xf0d0,0,0xc8f3,0, /* 0,'靑','青',0,0,'靕','靖',0, 0,'静',0,0,'靜',0,'非',0, */
	/* 9760 */ 0xf0d1,0xf3d3,0xcccc,0,0xf0d2,0,0xf0d3,0, 0xf0d4,0xb3d7,0,0xf0d6,0,0xbfd9,0,0, /* '靠','靡','面',0,'靤',0,'靦',0, '靨','革',0,'靫',0,'靭',0,0, */
	/* 9770 */ 0,0xf0d7,0,0,0xb7a4,0,0,0, 0,0xf0d8,0xf0dc,0,0xf0da,0,0,0, /* 0,'靱',0,0,'靴',0,0,0, 0,'靹','靺',0,'靼',0,0,0, */
	/* 9780 */ 0,0xf0db,0,0,0xb3f3,0xf0d9,0xf0dd,0, 0,0,0,0xf0de,0,0xb0c8,0,0xf0df, /* 0,'鞁',0,0,'鞄','鞅','鞆',0, 0,0,0,'鞋',0,'鞍',0,'鞏', */
	/* 9790 */ 0xf0e0,0,0,0,0,0,0,0, 0xbee4,0,0,0,0xf0e1,0,0,0, /* '鞐',0,0,0,0,0,0,0, '鞘',0,0,0,'鞜',0,0,0, */
	/* 97a0 */ 0xb5c7,0,0,0xf0e4,0,0,0xf0e3,0, 0xf0e2,0,0,0xebf1,0,0xcadc,0,0, /* '鞠',0,0,'鞣',0,0,'鞦',0, '鞨',0,0,'鞫',0,'鞭',0,0, */
	/* 97b0 */ 0,0,0,0xf0e5,0xf0e6,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'鞳','鞴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 97c0 */ 0,0,0,0xf0e7,0,0,0xf0e8,0, 0xf0e9,0,0,0xf0ea,0,0,0,0, /* 0,0,0,'韃',0,0,'韆',0, '韈',0,0,'韋',0,0,0,0, */
	/* 97d0 */ 0,0,0,0xb4da,0,0,0,0, 0,0,0,0,0xf0eb,0,0,0, /* 0,0,0,'韓',0,0,0,0, 0,0,0,0,'韜',0,0,0, */
	/* 97e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xf0ec,0xc7a3,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'韭','韮',0, */
	/* 97f0 */ 0,0,0xf0ee,0xb2bb,0,0xf0f1,0xf0f0,0, 0,0,0,0xb1a4,0,0,0,0xb6c1, /* 0,0,'韲','音',0,'韵','韶',0, 0,0,0,'韻',0,0,0,'響', */
	/* 9800 */ 0,0xcac7,0xc4ba,0xbaa2,0,0xb9e0,0xbde7,0, 0xbfdc,0,0,0,0xf0f3,0,0,0xf0f2, /* 0,'頁','頂','頃',0,'項','順',0, '須',0,0,0,'頌',0,0,'頏', */
	/* 9810 */ 0xcdc2,0xb4e8,0xc8d2,0xc6dc,0,0,0,0xbffc, 0xcece,0,0xb7db,0,0,0,0,0, /* '預','頑','頒','頓',0,0,0,'頗', '領',0,'頚',0,0,0,0,0, */
	/* 9820 */ 0,0xf0f6,0,0,0xf0f5,0,0,0, 0,0,0,0,0xcbcb,0xc6ac,0,0, /* 0,'頡',0,0,'頤',0,0,0, 0,0,0,0,'頬','頭',0,0, */
	/* 9830 */ 0,0,0,0,0xb1d0,0,0,0xf0f7, 0xf0f4,0,0,0xc9d1,0xcdea,0xf0f8,0,0, /* 0,0,0,0,'頴',0,0,'頷', '頸',0,0,'頻','頼','頽',0,0, */
	/* 9840 */ 0,0,0,0,0,0,0xf0f9,0, 0,0,0,0xf0fb,0xc2ea,0xb3db,0xb3dc,0xf0fa, /* 0,0,0,0,0,0,'顆',0, 0,0,0,'顋','題','額','顎','顏', */
	/* 9850 */ 0,0,0,0,0xb4e9,0xb8b2,0,0xfcda, 0xb4ea,0,0,0xc5bf,0,0,0xcee0,0, /* 0,0,0,0,'顔','顕',0,'顗', '願',0,0,'顛',0,0,'類',0, */
	/* 9860 */ 0,0,0,0,0,0xfcdb,0,0xb8dc, 0,0,0,0xf0fc,0,0,0,0xf0fd, /* 0,0,0,0,0,'顥',0,'顧', 0,0,0,'顫',0,0,0,'顯', */
	/* 9870 */ 0xf0fe,0xf1a1,0,0xf1a3,0xf1a2,0,0,0, 0,0,0,0,0,0,0,0, /* '顰','顱',0,'顳','顴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 98a0 */ 0,0,0,0,0,0,0,0, 0xc9f7,0,0xf1a4,0,0,0,0,0xf1a5, /* 0,0,0,0,0,0,0,0, '風',0,'颪',0,0,0,0,'颯', */
	/* 98b0 */ 0,0xf1a6,0,0,0,0,0xf1a7,0, 0,0,0,0,0,0,0,0, /* 0,'颱',0,0,0,0,'颶',0, 0,0,0,0,0,0,0,0, */
	/* 98c0 */ 0,0,0,0xf1a9,0xf1a8,0,0xf1aa,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'飃','飄',0,'飆',0, 0,0,0,0,0,0,0,0, */
	/* 98d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0xc8f4,0xe6cc,0,0,0xbfa9, /* 0,0,0,0,0,0,0,0, 0,0,0,'飛','飜',0,0,'食', */
	/* 98e0 */ 0,0,0xb5b2,0,0,0,0,0, 0,0xf1ab,0,0xf1ac,0,0xd2ac,0xddbb,0xc8d3, /* 0,0,'飢',0,0,0,0,0, 0,'飩',0,'飫',0,'飭','飮','飯', */
	/* 98f0 */ 0,0,0xb0fb,0,0xb0bb,0,0,0, 0,0,0,0,0xbbf4,0xcbb0,0xbefe,0, /* 0,0,'飲',0,'飴',0,0,0, 0,0,0,0,'飼','飽','飾',0, */
	/* 9900 */ 0,0,0,0xf1ad,0,0xccdf,0,0, 0,0xf1ae,0xcddc,0,0xb1c2,0,0,0, /* 0,0,0,'餃',0,'餅',0,0, 0,'餉','養',0,'餌',0,0,0, */
	/* 9910 */ 0xbbc1,0,0xf1af,0xb2ee,0xf1b0,0,0,0, 0xf1b1,0,0,0,0,0xf1b3,0xf1b4,0, /* '餐',0,'餒','餓','餔',0,0,0, '餘',0,0,0,0,'餝','餞',0, */
	/* 9920 */ 0xf1b6,0xf1b2,0,0,0xf1b5,0,0,0xfcde, 0xb4db,0,0,0,0xf1b7,0,0xf1b8,0, /* '餠','餡',0,0,'餤',0,0,'餧', '館',0,0,0,'餬',0,'餮',0, */
	/* 9930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xf1b9,0xf1ba,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'餽','餾',0, */
	/* 9940 */ 0,0,0xf1bb,0,0,0xf1bd,0,0, 0,0xf1bc,0,0xf1bf,0xf1c2,0,0,0, /* 0,0,'饂',0,0,'饅',0,0, 0,'饉',0,'饋','饌',0,0,0, */
	/* 9950 */ 0xf1be,0xf1c0,0xf1c1,0,0,0xf1c3,0,0xb6c2, 0,0,0,0,0,0,0,0, /* '饐','饑','饒',0,0,'饕',0,'饗', 0,0,0,0,0,0,0,0, */
	/* 9960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9990 */ 0,0,0,0,0,0,0xbcf3,0xf1c4, 0xf1c5,0xb9e1,0,0,0,0,0xfce0,0, /* 0,0,0,0,0,0,'首','馗', '馘','香',0,0,0,0,'馞',0, */
	/* 99a0 */ 0,0,0,0,0,0xf1c6,0,0, 0xb3be,0,0,0,0xc7cf,0xf1c7,0xf1c8,0, /* 0,0,0,0,0,'馥',0,0, '馨',0,0,0,'馬','馭','馮',0, */
	/* 99b0 */ 0,0,0,0xc3da,0xc6eb,0,0,0, 0,0,0,0,0xf1c9,0,0,0, /* 0,0,0,'馳','馴',0,0,0, 0,0,0,0,'馼',0,0,0, */
	/* 99c0 */ 0,0xc7fd,0,0,0xc2cc,0xb1d8,0xb6ee,0, 0xb6ef,0,0,0,0,0,0,0, /* 0,'駁',0,0,'駄','駅','駆',0, '駈',0,0,0,0,0,0,0, */
	/* 99d0 */ 0xc3f3,0xf1ce,0xb6f0,0,0,0xb2ef,0,0, 0xf1cd,0,0,0xf1cb,0,0xf1cc,0,0xf1ca, /* '駐','駑','駒',0,0,'駕',0,0, '駘',0,0,'駛',0,'駝',0,'駟', */
	/* 99e0 */ 0,0,0xf1d8,0,0,0,0,0, 0,0,0,0,0,0xf1cf,0xf1d0,0, /* 0,0,'駢',0,0,0,0,0, 0,0,0,0,0,'駭','駮',0, */
	/* 99f0 */ 0,0xf1d1,0xf1d2,0,0,0,0,0, 0xf1d4,0,0,0xf1d3,0,0,0,0xbdd9, /* 0,'駱','駲',0,0,0,0,0, '駸',0,0,'駻',0,0,0,'駿', */
	/* 9a00 */ 0,0xf1d5,0,0,0,0xf1d7,0,0, 0,0,0,0,0,0,0xb5b3,0xf1d6, /* 0,'騁',0,0,0,'騅',0,0, 0,0,0,0,0,0,'騎','騏', */
	/* 9a10 */ 0,0,0xc1fb,0xb8b3,0,0,0,0, 0,0xf1d9,0,0,0,0,0,0, /* 0,0,'騒','験',0,0,0,0, 0,'騙',0,0,0,0,0,0, */
	/* 9a20 */ 0,0,0,0,0,0,0,0, 0xc2cd,0,0,0xf1da,0,0,0,0, /* 0,0,0,0,0,0,0,0, '騨',0,0,'騫',0,0,0,0, */
	/* 9a30 */ 0xc6ad,0,0,0,0,0,0,0xf1db, 0,0,0,0,0,0,0xf1e0,0, /* '騰',0,0,0,0,0,0,'騷', 0,0,0,0,0,0,'騾',0, */
	/* 9a40 */ 0xf1de,0,0xf1dd,0xf1df,0,0xf1dc,0,0, 0,0,0,0,0,0xf1e2,0xfce1,0, /* '驀',0,'驂','驃',0,'驅',0,0, 0,0,0,0,0,'驍','驎',0, */
	/* 9a50 */ 0,0,0,0,0,0xf1e1,0,0xf1e4, 0,0,0xb6c3,0xf1e3,0,0,0,0xf1e5, /* 0,0,0,0,0,'驕',0,'驗', 0,0,'驚','驛',0,0,0,'驟', */
	/* 9a60 */ 0,0,0xf1e6,0,0xf1e8,0xf1e7,0,0, 0,0xf1e9,0xf1eb,0xf1ea,0,0,0,0, /* 0,0,'驢',0,'驤','驥',0,0, 0,'驩','驪','驫',0,0,0,0, */
	/* 9a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9aa0 */ 0,0,0,0,0,0,0,0, 0xb9fc,0,0,0,0,0xf1ec,0,0, /* 0,0,0,0,0,0,0,0, '骨',0,0,0,0,'骭',0,0, */
	/* 9ab0 */ 0xf1ed,0,0,0,0,0,0,0, 0xb3bc,0,0,0,0xf1ee,0,0,0, /* '骰',0,0,0,0,0,0,0, '骸',0,0,0,'骼',0,0,0, */
	/* 9ac0 */ 0xf1ef,0,0,0,0xbff1,0,0,0, 0,0,0,0,0,0,0,0xf1f0, /* '髀',0,0,0,'髄',0,0,0, 0,0,0,0,0,0,0,'髏', */
	/* 9ad0 */ 0,0xf1f1,0,0xf1f2,0xf1f3,0,0,0, 0xb9e2,0xfce2,0,0,0xfce3,0,0xf1f4,0xf1f5, /* 0,'髑',0,'髓','體',0,0,0, '高','髙',0,0,'髜',0,'髞','髟', */
	/* 9ae0 */ 0,0,0xf1f6,0xf1f7,0,0,0xf1f8,0, 0,0,0xc8b1,0xf1fa,0,0xc9a6,0xf1fb,0xf1f9, /* 0,0,'髢','髣',0,0,'髦',0, 0,0,'髪','髫',0,'髭','髮','髯', */
	/* 9af0 */ 0,0xf1fd,0,0,0xf1fc,0,0,0xf1fe, 0,0,0,0xf2a1,0,0,0,0, /* 0,'髱',0,0,'髴',0,0,'髷', 0,0,0,'髻',0,0,0,0, */
	/* 9b00 */ 0,0,0,0,0,0,0xf2a2,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'鬆',0, 0,0,0,0,0,0,0,0, */
	/* 9b10 */ 0,0,0,0,0,0,0,0, 0xf2a3,0,0xf2a4,0,0,0,0,0xf2a5, /* 0,0,0,0,0,0,0,0, '鬘',0,'鬚',0,0,0,0,'鬟', */
	/* 9b20 */ 0,0,0xf2a6,0xf2a7,0,0xf2a8,0,0xf2a9, 0xf2aa,0xf2ab,0xf2ac,0,0,0,0xf2ad,0xf2ae, /* 0,0,'鬢','鬣',0,'鬥',0,'鬧', '鬨','鬩','鬪',0,0,0,'鬮','鬯', */
	/* 9b30 */ 0,0xddb5,0xf2af,0,0,0,0,0, 0,0,0,0xe4f8,0xb5b4,0,0,0, /* 0,'鬱','鬲',0,0,0,0,0, 0,0,0,'鬻','鬼',0,0,0, */
	/* 9b40 */ 0,0xb3a1,0xbab2,0xf2b1,0xf2b0,0xcca5,0,0, 0,0,0,0,0,0xf2b3,0xf2b4,0xf2b2, /* 0,'魁','魂','魃','魄','魅',0,0, 0,0,0,0,0,'魍','魎','魏', */
	/* 9b50 */ 0,0xf2b5,0,0,0xcbe2,0,0,0, 0xf2b6,0,0xb5fb,0,0,0,0,0, /* 0,'魑',0,0,'魔',0,0,0, '魘',0,'魚',0,0,0,0,0, */
	/* 9b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xcfa5, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'魯', */
	/* 9b70 */ 0,0,0xfce5,0,0xf2b7,0xfce4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'魲',0,'魴','魵',0,0, 0,0,0,0,0,0,0,0, */
	/* 9b80 */ 0,0,0,0xf2b9,0,0,0,0, 0,0,0,0,0,0,0xb0be,0xfce6, /* 0,0,0,'鮃',0,0,0,0, 0,0,0,0,0,0,'鮎','鮏', */
	/* 9b90 */ 0,0xf2ba,0xcaab,0xf2b8,0,0,0xf2bb,0xf2bc, 0,0,0,0,0,0,0,0xf2bd, /* 0,'鮑','鮒','鮓',0,0,'鮖','鮗', 0,0,0,0,0,0,0,'鮟', */
	/* 9ba0 */ 0xf2be,0,0,0,0,0,0,0, 0xf2bf,0,0xcbee,0xbbad,0,0xbafa,0xc1af,0, /* '鮠',0,0,0,0,0,0,0, '鮨',0,'鮪','鮫',0,'鮭','鮮',0, */
	/* 9bb0 */ 0,0xfce7,0,0,0xf2c0,0,0,0, 0,0xf2c3,0,0xfce8,0,0,0,0, /* 0,'鮱',0,0,'鮴',0,0,0, 0,'鮹',0,'鮻',0,0,0,0, */
	/* 9bc0 */ 0xf2c1,0,0,0,0,0,0xf2c4,0, 0,0xb8f1,0xf2c2,0,0,0,0,0xf2c5, /* '鯀',0,0,0,0,0,'鯆',0, 0,'鯉','鯊',0,0,0,0,'鯏', */
	/* 9bd0 */ 0,0xf2c6,0xf2c7,0,0xf2cb,0,0xbbaa,0, 0,0,0,0xc2e4,0,0,0,0, /* 0,'鯑','鯒',0,'鯔',0,'鯖',0, 0,0,0,'鯛',0,0,0,0, */
	/* 9be0 */ 0,0xf2cc,0xf2c9,0xf2c8,0xf2ca,0,0,0, 0xb7df,0,0,0,0,0,0,0, /* 0,'鯡','鯢','鯣','鯤',0,0,0, '鯨',0,0,0,0,0,0,0, */
	/* 9bf0 */ 0xf2d0,0xf2cf,0xf2ce,0,0,0xb0b3,0,0, 0,0,0,0,0,0,0,0, /* '鯰','鯱','鯲',0,0,'鯵',0,0, 0,0,0,0,0,0,0,0, */
	/* 9c00 */ 0xfce9,0,0,0,0xf2da,0,0xf2d6,0, 0xf2d7,0xf2d3,0xf2d9,0,0xf2d5,0xb3e2,0,0, /* '鰀',0,0,0,'鰄',0,'鰆',0, '鰈','鰉','鰊',0,'鰌','鰍',0,0, */
	/* 9c10 */ 0xcfcc,0,0xf2d8,0xf2d4,0xf2d2,0xf2d1,0,0, 0,0,0,0xf2dc,0,0,0,0, /* '鰐',0,'鰒','鰓','鰔','鰕',0,0, 0,0,0,'鰛',0,0,0,0, */
	/* 9c20 */ 0,0xf2df,0,0,0xf2de,0xf2dd,0,0, 0,0,0,0,0,0xc9c9,0xf2db,0xb0f3, /* 0,'鰡',0,0,'鰤','鰥',0,0, 0,0,0,0,0,'鰭','鰮','鰯', */
	/* 9c30 */ 0xf2e0,0,0xf2e2,0,0,0,0,0, 0,0xb3ef,0xf2cd,0xb1b7,0,0,0xf2e4,0, /* '鰰',0,'鰲',0,0,0,0,0, 0,'鰹','鰺','鰻',0,0,'鰾',0, */
	/* 9c40 */ 0,0,0,0,0,0,0xf2e3,0xf2e1, 0xc3ad,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'鱆','鱇', '鱈',0,0,0,0,0,0,0, */
	/* 9c50 */ 0,0,0xcbf0,0,0,0,0,0xceda, 0,0,0xf2e5,0,0,0,0,0, /* 0,0,'鱒',0,0,0,0,'鱗', 0,0,'鱚',0,0,0,0,0, */
	/* 9c60 */ 0xf2e6,0,0,0,0,0,0,0xf2e7, 0,0,0,0,0,0,0,0, /* '鱠',0,0,0,0,0,0,'鱧', 0,0,0,0,0,0,0,0, */
	/* 9c70 */ 0,0,0,0,0,0,0xf2e8,0, 0xf2e9,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'鱶',0, '鱸',0,0,0,0,0,0,0, */
	/* 9c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ce0 */ 0,0,0,0,0,0xc4bb,0,0xf2ea, 0,0xc8b7,0,0xf2ef,0xf2eb,0,0,0, /* 0,0,0,0,0,'鳥',0,'鳧', 0,'鳩',0,'鳫','鳬',0,0,0, */
	/* 9cf0 */ 0xf2ec,0,0,0xcbb1,0xccc4,0,0xc6d0,0, 0,0,0,0,0,0,0,0, /* '鳰',0,0,'鳳','鳴',0,'鳶',0, 0,0,0,0,0,0,0,0, */
	/* 9d00 */ 0,0,0,0xf2f0,0,0,0xf2f1,0xc6be, 0xf2ee,0xf2ed,0,0,0,0,0xb2aa,0, /* 0,0,0,'鴃',0,0,'鴆','鴇', '鴈','鴉',0,0,0,0,'鴎',0, */
	/* 9d10 */ 0,0,0xf2f9,0,0,0xf2f8,0,0, 0,0,0,0xb1f5,0,0,0,0xf2f6, /* 0,0,'鴒',0,0,'鴕',0,0, 0,0,0,'鴛',0,0,0,'鴟', */
	/* 9d20 */ 0,0,0,0xf2f5,0,0,0xf2f3,0, 0xb3fb,0,0xf2f2,0xbcb2,0xb2a9,0,0,0, /* 0,0,0,'鴣',0,0,'鴦',0, '鴨',0,'鴪','鴫','鴬',0,0,0, */
	/* 9d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0xb9e3,0,0,0xf2fc,0xf2fb, /* 0,0,0,0,0,0,0,0, 0,0,0,'鴻',0,0,'鴾','鴿', */
	/* 9d40 */ 0,0xf2fa,0,0,0xf2f7,0,0xf2fd,0, 0xf2fe,0,0,0,0,0,0,0, /* 0,'鵁',0,0,'鵄',0,'鵆',0, '鵈',0,0,0,0,0,0,0, */
	/* 9d50 */ 0xf3a5,0xf3a4,0,0,0,0,0,0, 0,0xf3a6,0,0,0xb1ad,0xf3a1,0xf3a2,0, /* '鵐','鵑',0,0,0,0,0,0, 0,'鵙',0,0,'鵜','鵝','鵞',0, */
	/* 9d60 */ 0xb9f4,0xccb9,0,0,0xf3a3,0,0,0, 0,0,0,0xfceb,0xcbb2,0,0,0xf3ab, /* '鵠','鵡',0,0,'鵤',0,0,0, 0,0,0,'鵫','鵬',0,0,'鵯', */
	/* 9d70 */ 0xfcea,0,0xf3a7,0,0,0,0,0, 0,0,0xf3ac,0,0,0,0,0, /* '鵰',0,'鵲',0,0,0,0,0, 0,0,'鵺',0,0,0,0,0, */
	/* 9d80 */ 0,0,0,0,0,0,0,0xf3a9, 0,0xf3a8,0,0,0,0,0,0xb7dc, /* 0,0,0,0,0,0,0,'鶇', 0,'鶉',0,0,0,0,0,'鶏', */
	/* 9d90 */ 0,0,0,0,0,0,0,0, 0,0,0xf3ad,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'鶚',0,0,0,0,0, */
	/* 9da0 */ 0,0,0,0,0xf3ae,0,0,0, 0,0xf3af,0,0xf3aa,0,0,0,0xf2f4, /* 0,0,0,0,'鶤',0,0,0, 0,'鶩',0,'鶫',0,0,0,'鶯', */
	/* 9db0 */ 0,0,0xf3b0,0,0xc4e1,0,0,0, 0xf3b4,0,0xf3b5,0xf3b3,0,0,0,0, /* 0,0,'鶲',0,'鶴',0,0,0, '鶸',0,'鶺','鶻',0,0,0,0, */
	/* 9dc0 */ 0,0xf3b2,0xf3b8,0,0xf3b1,0,0xf3b6,0, 0,0,0,0,0,0,0,0xf3b7, /* 0,'鷁','鷂',0,'鷄',0,'鷆',0, 0,0,0,0,0,0,0,'鷏', */
	/* 9dd0 */ 0,0,0,0xf3ba,0,0,0,0, 0,0xf3b9,0,0,0,0,0,0, /* 0,0,0,'鷓',0,0,0,0, 0,'鷙',0,0,0,0,0,0, */
	/* 9de0 */ 0,0,0,0,0,0,0xf3bc,0, 0,0,0,0,0,0xf3bd,0,0xf3be, /* 0,0,0,0,0,0,'鷦',0, 0,0,0,0,0,'鷭',0,'鷯', */
	/* 9df0 */ 0,0,0xcfc9,0,0,0,0,0, 0xf3bb,0xc2eb,0xbaed,0,0,0xf3bf,0,0, /* 0,0,'鷲',0,0,0,0,0, '鷸','鷹','鷺',0,0,'鷽',0,0, */
	/* 9e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e10 */ 0,0,0,0,0,0,0,0, 0,0xfced,0xf3c0,0xf3c1,0,0,0xf3c2,0, /* 0,0,0,0,0,0,0,0, 0,'鸙','鸚','鸛',0,0,'鸞',0, */
	/* 9e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e70 */ 0,0,0,0,0,0xf3c3,0,0, 0xb8b4,0xf3c4,0,0,0,0xf3c5,0,0xbcaf, /* 0,0,0,0,0,'鹵',0,0, '鹸','鹹',0,0,0,'鹽',0,'鹿', */
	/* 9e80 */ 0,0xf3c6,0,0,0,0,0,0, 0xf3c7,0,0,0xf3c8,0xf3c9,0,0,0, /* 0,'麁',0,0,0,0,0,0, '麈',0,0,'麋','麌',0,0,0, */
	/* 9e90 */ 0,0xf3cc,0xf3ca,0xcfbc,0,0xf3cb,0,0xceef, 0,0,0,0,0,0xf3cd,0,0xcedb, /* 0,'麑','麒','麓',0,'麕',0,'麗', 0,0,0,0,0,'麝',0,'麟', */
	/* 9ea0 */ 0,0,0,0,0,0xf3ce,0xc7fe,0, 0,0xf3cf,0xf3d1,0,0,0xf3d2,0,0, /* 0,0,0,0,0,'麥','麦',0, 0,'麩','麪',0,0,'麭',0,0, */
	/* 9eb0 */ 0,0,0,0,0,0,0,0, 0xf3d0,0xb9ed,0xcccd,0xcbe3,0xd6f7,0,0xdde0,0xcbfb, /* 0,0,0,0,0,0,0,0, '麸','麹','麺','麻','麼',0,'麾','麿', */
	/* 9ec0 */ 0,0,0,0,0xb2ab,0,0,0, 0,0,0,0,0xf3d4,0xb5d0,0xf3d5,0xf3d6, /* 0,0,0,0,'黄',0,0,0, 0,0,0,0,'黌','黍','黎','黏', */
	/* 9ed0 */ 0xf3d7,0xfcee,0xb9f5,0,0xf3d8,0,0,0, 0xe0d4,0xccdb,0,0xc2e3,0xf3d9,0xf3db,0xf3da,0, /* '黐','黑','黒',0,'黔',0,0,0, '默','黙',0,'黛','黜','黝','點',0, */
	/* 9ee0 */ 0xf3dc,0,0,0,0,0xf3dd,0,0, 0xf3de,0,0,0,0,0,0,0xf3df, /* '黠',0,0,0,0,'黥',0,0, '黨',0,0,0,0,0,0,'黯', */
	/* 9ef0 */ 0,0,0,0,0xf3e0,0,0xf3e1,0xf3e2, 0,0xf3e3,0,0xf3e4,0xf3e5,0xf3e6,0,0, /* 0,0,0,0,'黴',0,'黶','黷', 0,'黹',0,'黻','黼','黽',0,0, */
	/* 9f00 */ 0,0,0,0,0,0,0,0xf3e7, 0xf3e8,0,0,0,0,0,0xc5a4,0, /* 0,0,0,0,0,0,0,'鼇', '鼈',0,0,0,0,0,'鼎',0, */
	/* 9f10 */ 0,0,0,0xb8dd,0,0xf3ea,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'鼓',0,'鼕',0,0, 0,0,0,0,0,0,0,0, */
	/* 9f20 */ 0xc1cd,0xf3eb,0,0,0,0,0,0, 0,0,0,0,0xf3ec,0,0,0, /* '鼠','鼡',0,0,0,0,0,0, 0,0,0,0,'鼬',0,0,0, */
	/* 9f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0xc9a1,0,0,0xf3ed,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'鼻',0,0,'鼾',0, */
	/* 9f40 */ 0,0,0,0,0,0,0,0, 0,0,0xf3ee,0xe3b7,0,0,0xecda,0xf0ed, /* 0,0,0,0,0,0,0,0, 0,0,'齊','齋',0,0,'齎','齏', */
	/* 9f50 */ 0,0,0xf3ef,0,0xf3f0,0,0,0, 0,0,0,0,0,0,0,0xf3f2, /* 0,0,'齒',0,'齔',0,0,0, 0,0,0,0,0,0,0,'齟', */
	/* 9f60 */ 0xf3f3,0xf3f4,0xcef0,0xf3f1,0,0,0xf3f5,0xf3f6, 0,0,0xf3f8,0,0xf3f7,0,0,0, /* '齠','齡','齢','齣',0,0,'齦','齧', 0,0,'齪',0,'齬',0,0,0, */
	/* 9f70 */ 0,0,0xf3fa,0,0,0,0xf3fb,0xf3f9, 0,0,0,0,0,0,0,0, /* 0,0,'齲',0,0,0,'齶','齷', 0,0,0,0,0,0,0,0, */
	/* 9f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xceb6,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'龍',0,0, */
	/* 9f90 */ 0,0,0,0,0,0xf3fc,0,0, 0,0,0,0,0xf3fd,0xe3d4,0,0, /* 0,0,0,0,0,'龕',0,0, 0,0,0,0,'龜','龝',0,0, */
	/* 9fa0 */ 0xf3fe,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '龠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ace0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ada0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* add0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ade0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

	/* b310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* beb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ceb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ced0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* deb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ded0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* def0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ead0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ece0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ede0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

	/* ef10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f920 */ 0,0,0,0,0,0,0,0, 0,0xfac6,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'朗',0,0,0,0,0,0, */
	/* f930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xfccf,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'隆',0,0,0, */
	/* f9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xf9d4,0xf9df, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'﨎','﨏', */
	/* fa10 */ 0xf9e0,0xf9f5,0xfabe,0xface,0xfad0,0xfafb,0xfba3,0xfbba, 0xfbc2,0xfbc3,0xfbc4,0xfbc6,0xfbca,0xfbcd,0xfbd6,0xfbe1, /* '塚','﨑','晴','﨓','﨔','凞','猪','益', '礼','神','祥','福','靖','精','羽','﨟', */
	/* fa20 */ 0xfbe3,0xfbe4,0xfbed,0xfbf5,0xfbf7,0xfbf8,0xfbfb,0xfcb9, 0xfcc0,0xfcd0,0xfcdc,0xfcdd,0xfcdf,0xfcec,0,0, /* '蘒','﨡','諸','﨣','﨤','逸','都','﨧', '﨨','﨩','飯','飼','館','鶴',0,0, */
	/* fa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* feb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ff00 */ 0,0xa1aa,0xfcfe,0xa1f4,0xa1f0,0xa1f3,0xa1f5,0xfcfd, 0xa1ca,0xa1cb,0xa1f6,0xa1dc,0xa1a4,0xa1dd,0xa1a5,0xa1bf, /* 0,'！','＂','＃','＄','％','＆','＇', '（','）','＊','＋','，','－','．','／', */
	/* ff10 */ 0xa3b0,0xa3b1,0xa3b2,0xa3b3,0xa3b4,0xa3b5,0xa3b6,0xa3b7, 0xa3b8,0xa3b9,0xa1a7,0xa1a8,0xa1e3,0xa1e1,0xa1e4,0xa1a9, /* '０','１','２','３','４','５','６','７', '８','９','：','；','＜','＝','＞','？', */
	/* ff20 */ 0xa1f7,0xa3c1,0xa3c2,0xa3c3,0xa3c4,0xa3c5,0xa3c6,0xa3c7, 0xa3c8,0xa3c9,0xa3ca,0xa3cb,0xa3cc,0xa3cd,0xa3ce,0xa3cf, /* '＠','Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ', 'Ｈ','Ｉ','Ｊ','Ｋ','Ｌ','Ｍ','Ｎ','Ｏ', */
	/* ff30 */ 0xa3d0,0xa3d1,0xa3d2,0xa3d3,0xa3d4,0xa3d5,0xa3d6,0xa3d7, 0xa3d8,0xa3d9,0xa3da,0xa1ce,0xa1c0,0xa1cf,0xa1b0,0xa1b2, /* 'Ｐ','Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ', 'Ｘ','Ｙ','Ｚ','［','＼','］','＾','＿', */
	/* ff40 */ 0xa1ae,0xa3e1,0xa3e2,0xa3e3,0xa3e4,0xa3e5,0xa3e6,0xa3e7, 0xa3e8,0xa3e9,0xa3ea,0xa3eb,0xa3ec,0xa3ed,0xa3ee,0xa3ef, /* '｀','ａ','ｂ','ｃ','ｄ','ｅ','ｆ','ｇ', 'ｈ','ｉ','ｊ','ｋ','ｌ','ｍ','ｎ','ｏ', */
	/* ff50 */ 0xa3f0,0xa3f1,0xa3f2,0xa3f3,0xa3f4,0xa3f5,0xa3f6,0xa3f7, 0xa3f8,0xa3f9,0xa3fa,0xa1d0,0xa1c3,0xa1d1,0xa1c1,0, /* 'ｐ','ｑ','ｒ','ｓ','ｔ','ｕ','ｖ','ｗ', 'ｘ','ｙ','ｚ','｛','｜','｝','～',0, */
	/* ff60 */ 0,0x8ea1,0x8ea2,0x8ea3,0x8ea4,0x8ea5,0x8ea6,0x8ea7, 0x8ea8,0x8ea9,0x8eaa,0x8eab,0x8eac,0x8ead,0x8eae,0x8eaf, /* 0,'｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* ff70 */ 0x8eb0,0x8eb1,0x8eb2,0x8eb3,0x8eb4,0x8eb5,0x8eb6,0x8eb7, 0x8eb8,0x8eb9,0x8eba,0x8ebb,0x8ebc,0x8ebd,0x8ebe,0x8ebf, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* ff80 */ 0x8ec0,0x8ec1,0x8ec2,0x8ec3,0x8ec4,0x8ec5,0x8ec6,0x8ec7, 0x8ec8,0x8ec9,0x8eca,0x8ecb,0x8ecc,0x8ecd,0x8ece,0x8ecf, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* ff90 */ 0x8ed0,0x8ed1,0x8ed2,0x8ed3,0x8ed4,0x8ed5,0x8ed6,0x8ed7, 0x8ed8,0x8ed9,0x8eda,0x8edb,0x8edc,0x8edd,0x8ede,0x8edf, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
	/* ffa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffe0 */ 0xa1f1,0xa1f2,0xa2cc,0xa1b1,0xfcfc,0xa1ef, /* '￠','￡','￢','￣','￤','￥', */
};

const size_t _unibe2euc51932_table_size = sizeof(_unibe2euc51932_table) / sizeof(_unibe2euc51932_table[0]);

#endif /* #ifndef __UNIBE2EUC51932_TABLE_H_ */
