/*
 * _unibe2eucms_table.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __UNIBE2EUCMS_TABLE_H_
#define __UNIBE2EUCMS_TABLE_H_

#include <stddef.h>
#include <stdint.h>

const uint32_t _unibe2eucms_table[] = {
	/* 0000 */ 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, 0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* '','','','','','','','', '','','','','','','','', */
	/* 0010 */ 0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, 0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* '','','','','','','','', '','','','','','','','', */
	/* 0020 */ 0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, 0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* ' ','!','"','#','$','%','&','\'', '(',')','*','+',',','-','.','/', */
	/* 0030 */ 0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, 0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* '0','1','2','3','4','5','6','7', '8','9',':',';','<','=','>','?', */
	/* 0040 */ 0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, 0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O', */
	/* 0050 */ 0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, 0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 'P','Q','R','S','T','U','V','W', 'X','Y','Z','[','\\',']','^','_', */
	/* 0060 */ 0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, 0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* '`','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o', */
	/* 0070 */ 0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, 0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f, /* 'p','q','r','s','t','u','v','w', 'x','y','z','{','|','}','~','', */
	/* 0080 */ 0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087, 0x0088,0x0089,0x008a,0x008b,0x008c,0x008d,0,0, /* '','','','','','','','', '','','','','','',0,0, */
	/* 0090 */ 0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097, 0x0098,0x0099,0x009a,0x009b,0x009c,0x009d,0x009e,0x009f, /* '','','','','','','','', '','','','','','','','', */
	/* 00a0 */ 0,0x8fa2c2,0xa1f1,0xa1f2,0x8fa2f0,0x5c,0,0xa1f8, 0xa1af,0x8fa2ed,0x8fa2ec,0,0xa2cc,0,0x8fa2ee,0x8fa2b4, /* 0,'¡','¢','£','¤','\\',0,'§', '¨','©','ª',0,'¬',0,'®','¯', */
	/* 00b0 */ 0xa1eb,0xa1de,0,0,0xa1ad,0,0xa2f9,0, 0x8fa2b1,0,0x8fa2eb,0,0,0,0,0x8fa2c4, /* '°','±',0,0,'´',0,'¶',0, '¸',0,'º',0,0,0,0,'¿', */
	/* 00c0 */ 0x8faaa2,0x8faaa1,0x8faaa4,0x8faaaa,0x8faaa3,0x8faaa9,0x8fa9a1,0x8faaae, 0x8faab2,0x8faab1,0x8faab4,0x8faab3,0x8faac0,0x8faabf,0x8faac2,0x8faac1, /* 'À','Á','Â','Ã','Ä','Å','Æ','Ç', 'È','É','Ê','Ë','Ì','Í','Î','Ï', */
	/* 00d0 */ 0,0x8faad0,0x8faad2,0x8faad1,0x8faad4,0x8faad8,0x8faad3,0xa1df, 0x8fa9ac,0x8faae3,0x8faae2,0x8faae5,0x8faae4,0x8faaf2,0x8fa9b0,0x8fa9ce, /* 0,'Ñ','Ò','Ó','Ô','Õ','Ö','×', 'Ø','Ù','Ú','Û','Ü','Ý','Þ','ß', */
	/* 00e0 */ 0x8faba2,0x8faba1,0x8faba4,0x8fabaa,0x8faba3,0x8faba9,0x8fa9c1,0x8fabae, 0x8fabb2,0x8fabb1,0x8fabb4,0x8fabb3,0x8fabc0,0x8fabbf,0x8fabc2,0x8fabc1, /* 'à','á','â','ã','ä','å','æ','ç', 'è','é','ê','ë','ì','í','î','ï', */
	/* 00f0 */ 0x8fa9c3,0x8fabd0,0x8fabd2,0x8fabd1,0x8fabd4,0x8fabd8,0x8fabd3,0xa1e0, 0x8fa9cc,0x8fabe3,0x8fabe2,0x8fabe5,0x8fabe4,0x8fabf2,0x8fa9d0,0x8fabf3, /* 'ð','ñ','ò','ó','ô','õ','ö','÷', 'ø','ù','ú','û','ü','ý','þ','ÿ', */
	/* 0100 */ 0x8faaa7,0x8faba7,0x8faaa5,0x8faba5,0x8faaa8,0x8faba8,0x8faaab,0x8fabab, 0x8faaac,0x8fabac,0x8faaaf,0x8fabaf,0x8faaad,0x8fabad,0x8faab0,0x8fabb0, /* 'Ā','ā','Ă','ă','Ą','ą','Ć','ć', 'Ĉ','ĉ','Ċ','ċ','Č','č','Ď','ď', */
	/* 0110 */ 0x8fa9a2,0x8fa9c2,0x8faab7,0x8fabb7,0,0,0x8faab6,0x8fabb6, 0x8faab8,0x8fabb8,0x8faab5,0x8fabb5,0x8faaba,0x8fabba,0x8faabb,0x8fabbb, /* 'Đ','đ','Ē','ē',0,0,'Ė','ė', 'Ę','ę','Ě','ě','Ĝ','ĝ','Ğ','ğ', */
	/* 0120 */ 0x8faabd,0x8fabbd,0x8faabc,0,0x8faabe,0x8fabbe,0x8fa9a4,0x8fa9c4, 0x8faac7,0x8fabc7,0x8faac5,0x8fabc5,0,0,0x8faac6,0x8fabc6, /* 'Ġ','ġ','Ģ',0,'Ĥ','ĥ','Ħ','ħ', 'Ĩ','ĩ','Ī','ī',0,0,'Į','į', */
	/* 0130 */ 0x8faac4,0x8fa9c5,0x8fa9a6,0x8fa9c6,0x8faac8,0x8fabc8,0x8faac9,0x8fabc9, 0x8fa9c7,0x8faaca,0x8fabca,0x8faacc,0x8fabcc,0x8faacb,0x8fabcb,0x8fa9a9, /* 'İ','ı','Ĳ','ĳ','Ĵ','ĵ','Ķ','ķ', 'ĸ','Ĺ','ĺ','Ļ','ļ','Ľ','ľ','Ŀ', */
	/* 0140 */ 0x8fa9c9,0x8fa9a8,0x8fa9c8,0x8faacd,0x8fabcd,0x8faacf,0x8fabcf,0x8faace, 0x8fabce,0x8fa9ca,0x8fa9ab,0x8fa9cb,0x8faad7,0x8fabd7,0,0, /* 'ŀ','Ł','ł','Ń','ń','Ņ','ņ','Ň', 'ň','ŉ','Ŋ','ŋ','Ō','ō',0,0, */
	/* 0150 */ 0x8faad6,0x8fabd6,0x8fa9ad,0x8fa9cd,0x8faad9,0x8fabd9,0x8faadb,0x8fabdb, 0x8faada,0x8fabda,0x8faadc,0x8fabdc,0x8faadd,0x8fabdd,0x8faadf,0x8fabdf, /* 'Ő','ő','Œ','œ','Ŕ','ŕ','Ŗ','ŗ', 'Ř','ř','Ś','ś','Ŝ','ŝ','Ş','ş', */
	/* 0160 */ 0x8faade,0x8fabde,0x8faae1,0x8fabe1,0x8faae0,0x8fabe0,0x8fa9af,0x8fa9cf, 0x8faaec,0x8fabec,0x8faae9,0x8fabe9,0x8faae6,0x8fabe6,0x8faaeb,0x8fabeb, /* 'Š','š','Ţ','ţ','Ť','ť','Ŧ','ŧ', 'Ũ','ũ','Ū','ū','Ŭ','ŭ','Ů','ů', */
	/* 0170 */ 0x8faae8,0x8fabe8,0x8faaea,0x8fabea,0x8faaf1,0x8fabf1,0x8faaf4,0x8fabf4, 0x8faaf3,0x8faaf5,0x8fabf5,0x8faaf7,0x8fabf7,0x8faaf6,0x8fabf6,0, /* 'Ű','ű','Ų','ų','Ŵ','ŵ','Ŷ','ŷ', 'Ÿ','Ź','ź','Ż','ż','Ž','ž',0, */
	/* 0180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x8faaa6,0x8faba6,0x8faac3, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'Ǎ','ǎ','Ǐ', */
	/* 01d0 */ 0x8fabc3,0x8faad5,0x8fabd5,0x8faae7,0x8fabe7,0x8faaf0,0x8fabf0,0x8faaed, 0x8fabed,0x8faaef,0x8fabef,0x8faaee,0x8fabee,0,0,0, /* 'ǐ','Ǒ','ǒ','Ǔ','ǔ','Ǖ','ǖ','Ǘ', 'ǘ','Ǚ','ǚ','Ǜ','ǜ',0,0,0, */
	/* 01e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01f0 */ 0,0,0,0,0,0x8fabb9,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'ǵ',0,0, 0,0,0,0,0,0,0,0, */
	/* 0200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02c0 */ 0,0,0,0,0,0,0,0x8fa2b0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'ˇ', 0,0,0,0,0,0,0,0, */
	/* 02d0 */ 0,0,0,0,0,0,0,0, 0x8fa2af,0x8fa2b2,0x8fa2b6,0x8fa2b5,0,0x8fa2b3,0,0, /* 0,0,0,0,0,0,0,0, '˘','˙','˚','˛',0,'˝',0,0, */
	/* 02e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0380 */ 0,0,0,0,0x8fa2b8,0x8fa2b9,0x8fa6e1,0, 0x8fa6e2,0x8fa6e3,0x8fa6e4,0,0x8fa6e7,0,0x8fa6e9,0x8fa6ec, /* 0,0,0,0,'΄','΅','Ά',0, 'Έ','Ή','Ί',0,'Ό',0,'Ύ','Ώ', */
	/* 0390 */ 0x8fa6f6,0xa6a1,0xa6a2,0xa6a3,0xa6a4,0xa6a5,0xa6a6,0xa6a7, 0xa6a8,0xa6a9,0xa6aa,0xa6ab,0xa6ac,0xa6ad,0xa6ae,0xa6af, /* 'ΐ','Α','Β','Γ','Δ','Ε','Ζ','Η', 'Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο', */
	/* 03a0 */ 0xa6b0,0xa6b1,0,0xa6b2,0xa6b3,0xa6b4,0xa6b5,0xa6b6, 0xa6b7,0xa6b8,0x8fa6e5,0x8fa6ea,0x8fa6f1,0x8fa6f2,0x8fa6f3,0x8fa6f4, /* 'Π','Ρ',0,'Σ','Τ','Υ','Φ','Χ', 'Ψ','Ω','Ϊ','Ϋ','ά','έ','ή','ί', */
	/* 03b0 */ 0x8fa6fb,0xa6c1,0xa6c2,0xa6c3,0xa6c4,0xa6c5,0xa6c6,0xa6c7, 0xa6c8,0xa6c9,0xa6ca,0xa6cb,0xa6cc,0xa6cd,0xa6ce,0xa6cf, /* 'ΰ','α','β','γ','δ','ε','ζ','η', 'θ','ι','κ','λ','μ','ν','ξ','ο', */
	/* 03c0 */ 0xa6d0,0xa6d1,0x8fa6f8,0xa6d2,0xa6d3,0xa6d4,0xa6d5,0xa6d6, 0xa6d7,0xa6d8,0x8fa6f5,0x8fa6fa,0x8fa6f7,0x8fa6f9,0x8fa6fc,0, /* 'π','ρ','ς','σ','τ','υ','φ','χ', 'ψ','ω','ϊ','ϋ','ό','ύ','ώ',0, */
	/* 03d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0400 */ 0,0xa7a7,0x8fa7c2,0x8fa7c3,0x8fa7c4,0x8fa7c5,0x8fa7c6,0x8fa7c7, 0x8fa7c8,0x8fa7c9,0x8fa7ca,0x8fa7cb,0x8fa7cc,0,0x8fa7cd,0x8fa7ce, /* 0,'Ё','Ђ','Ѓ','Є','Ѕ','І','Ї', 'Ј','Љ','Њ','Ћ','Ќ',0,'Ў','Џ', */
	/* 0410 */ 0xa7a1,0xa7a2,0xa7a3,0xa7a4,0xa7a5,0xa7a6,0xa7a8,0xa7a9, 0xa7aa,0xa7ab,0xa7ac,0xa7ad,0xa7ae,0xa7af,0xa7b0,0xa7b1, /* 'А','Б','В','Г','Д','Е','Ж','З', 'И','Й','К','Л','М','Н','О','П', */
	/* 0420 */ 0xa7b2,0xa7b3,0xa7b4,0xa7b5,0xa7b6,0xa7b7,0xa7b8,0xa7b9, 0xa7ba,0xa7bb,0xa7bc,0xa7bd,0xa7be,0xa7bf,0xa7c0,0xa7c1, /* 'Р','С','Т','У','Ф','Х','Ц','Ч', 'Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я', */
	/* 0430 */ 0xa7d1,0xa7d2,0xa7d3,0xa7d4,0xa7d5,0xa7d6,0xa7d8,0xa7d9, 0xa7da,0xa7db,0xa7dc,0xa7dd,0xa7de,0xa7df,0xa7e0,0xa7e1, /* 'а','б','в','г','д','е','ж','з', 'и','й','к','л','м','н','о','п', */
	/* 0440 */ 0xa7e2,0xa7e3,0xa7e4,0xa7e5,0xa7e6,0xa7e7,0xa7e8,0xa7e9, 0xa7ea,0xa7eb,0xa7ec,0xa7ed,0xa7ee,0xa7ef,0xa7f0,0xa7f1, /* 'р','с','т','у','ф','х','ц','ч', 'ш','щ','ъ','ы','ь','э','ю','я', */
	/* 0450 */ 0,0xa7d7,0x8fa7f2,0x8fa7f3,0x8fa7f4,0x8fa7f5,0x8fa7f6,0x8fa7f7, 0x8fa7f8,0x8fa7f9,0x8fa7fa,0x8fa7fb,0x8fa7fc,0,0x8fa7fd,0x8fa7fe, /* 0,'ё','ђ','ѓ','є','ѕ','і','ї', 'ј','љ','њ','ћ','ќ',0,'ў','џ', */
	/* 0460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

	/* 0a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2010 */ 0xa1be,0,0,0,0,0xa1bd,0xa1c2,0, 0xa1c6,0xa1c7,0,0,0xa1c8,0xa1c9,0,0, /* '‐',0,0,0,0,'―','‖',0, '‘','’',0,0,'“','”',0,0, */
	/* 2020 */ 0xa2f7,0xa2f8,0,0,0,0xa1c5,0xa1c4,0, 0,0,0,0,0,0,0,0, /* '†','‡',0,0,0,'‥','…',0, 0,0,0,0,0,0,0,0, */
	/* 2030 */ 0xa2f3,0,0xa1ec,0xa1ed,0,0,0,0, 0,0,0,0xa2a8,0,0,0,0, /* '‰',0,'′','″',0,0,0,0, 0,0,0,'※',0,0,0,0, */
	/* 2040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2100 */ 0,0,0,0xa1ee,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'℃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2110 */ 0,0,0,0,0,0,0xade2,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'№',0, 0,0,0,0,0,0,0,0, */
	/* 2120 */ 0,0xade4,0x8fa2ef,0,0,0,0,0, 0,0,0,0xa2f2,0,0,0,0, /* 0,'℡','™',0,0,0,0,0, 0,0,0,'Å',0,0,0,0, */
	/* 2130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2160 */ 0xadb5,0xadb6,0xadb7,0xadb8,0xadb9,0xadba,0xadbb,0xadbc, 0xadbd,0xadbe,0,0,0,0,0,0, /* 'Ⅰ','Ⅱ','Ⅲ','Ⅳ','Ⅴ','Ⅵ','Ⅶ','Ⅷ', 'Ⅸ','Ⅹ',0,0,0,0,0,0, */
	/* 2170 */ 0x8ff3f3,0x8ff3f4,0x8ff3f5,0x8ff3f6,0x8ff3f7,0x8ff3f8,0x8ff3f9,0x8ff3fa, 0x8ff3fb,0x8ff3fc,0,0,0,0,0,0, /* 'ⅰ','ⅱ','ⅲ','ⅳ','ⅴ','ⅵ','ⅶ','ⅷ', 'ⅸ','ⅹ',0,0,0,0,0,0, */
	/* 2180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2190 */ 0xa2ab,0xa2ac,0xa2aa,0xa2ad,0,0,0,0, 0,0,0,0,0,0,0,0, /* '←','↑','→','↓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21d0 */ 0,0,0xa2cd,0,0xa2ce,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⇒',0,'⇔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2200 */ 0xa2cf,0,0xa2df,0xa2d0,0,0,0,0xa2e0, 0xa2ba,0,0,0xa2bb,0,0,0,0, /* '∀',0,'∂','∃',0,0,0,'∇', '∈',0,0,'∋',0,0,0,0, */
	/* 2210 */ 0,0xadf4,0xa1dd,0,0,0,0,0, 0,0,0xa2e5,0,0,0xa2e7,0xa1e7,0xadf8, /* 0,'∑','−',0,0,0,0,0, 0,0,'√',0,0,'∝','∞','∟', */
	/* 2220 */ 0xa2dc,0,0,0,0,0xa1c2,0,0xa2ca, 0xa2cb,0xa2c1,0xa2c0,0xa2e9,0xa2ea,0,0xadf3,0, /* '∠',0,0,0,0,'∥',0,'∧', '∨','∩','∪','∫','∬',0,'∮',0, */
	/* 2230 */ 0,0,0,0,0xa1e8,0xa2e8,0,0, 0,0,0,0,0,0xa2e6,0,0, /* 0,0,0,0,'∴','∵',0,0, 0,0,0,0,0,'∽',0,0, */
	/* 2240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2250 */ 0,0,0xa2e2,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'≒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2260 */ 0xa1e2,0xa2e1,0,0,0,0,0xa1e5,0xa1e6, 0,0,0xa2e3,0xa2e4,0,0,0,0, /* '≠','≡',0,0,0,0,'≦','≧', 0,0,'≪','≫',0,0,0,0, */
	/* 2270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2280 */ 0,0,0xa2be,0xa2bf,0,0,0xa2bc,0xa2bd, 0,0,0,0,0,0,0,0, /* 0,0,'⊂','⊃',0,0,'⊆','⊇', 0,0,0,0,0,0,0,0, */
	/* 2290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22a0 */ 0,0,0,0,0,0xa2dd,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⊥',0,0, 0,0,0,0,0,0,0,0, */
	/* 22b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xadf9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'⊿', */
	/* 22c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2310 */ 0,0,0xa2de,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⌒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2460 */ 0xada1,0xada2,0xada3,0xada4,0xada5,0xada6,0xada7,0xada8, 0xada9,0xadaa,0xadab,0xadac,0xadad,0xadae,0xadaf,0xadb0, /* '①','②','③','④','⑤','⑥','⑦','⑧', '⑨','⑩','⑪','⑫','⑬','⑭','⑮','⑯', */
	/* 2470 */ 0xadb1,0xadb2,0xadb3,0xadb4,0,0,0,0, 0,0,0,0,0,0,0,0, /* '⑰','⑱','⑲','⑳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2500 */ 0xa8a1,0xa8ac,0xa8a2,0xa8ad,0,0,0,0, 0,0,0,0,0xa8a3,0,0,0xa8ae, /* '─','━','│','┃',0,0,0,0, 0,0,0,0,'┌',0,0,'┏', */
	/* 2510 */ 0xa8a4,0,0,0xa8af,0xa8a6,0,0,0xa8b1, 0xa8a5,0,0,0xa8b0,0xa8a7,0xa8bc,0,0, /* '┐',0,0,'┓','└',0,0,'┗', '┘',0,0,'┛','├','┝',0,0, */
	/* 2520 */ 0xa8b7,0,0,0xa8b2,0xa8a9,0xa8be,0,0, 0xa8b9,0,0,0xa8b4,0xa8a8,0,0,0xa8b8, /* '┠',0,0,'┣','┤','┥',0,0, '┨',0,0,'┫','┬',0,0,'┯', */
	/* 2530 */ 0xa8bd,0,0,0xa8b3,0xa8aa,0,0,0xa8ba, 0xa8bf,0,0,0xa8b5,0xa8ab,0,0,0xa8bb, /* '┰',0,0,'┳','┴',0,0,'┷', '┸',0,0,'┻','┼',0,0,'┿', */
	/* 2540 */ 0,0,0xa8c0,0,0,0,0,0, 0,0,0,0xa8b6,0,0,0,0, /* 0,0,'╂',0,0,0,0,0, 0,0,0,'╋',0,0,0,0, */
	/* 2550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25a0 */ 0xa2a3,0xa2a2,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '■','□',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25b0 */ 0,0,0xa2a5,0xa2a4,0,0,0,0, 0,0,0,0,0xa2a7,0xa2a6,0,0, /* 0,0,'▲','△',0,0,0,0, 0,0,0,0,'▼','▽',0,0, */
	/* 25c0 */ 0,0,0,0,0,0,0xa2a1,0xa1fe, 0,0,0,0xa1fb,0,0,0xa1fd,0xa1fc, /* 0,0,0,0,0,0,'◆','◇', 0,0,0,'○',0,0,'◎','●', */
	/* 25d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xa2fe, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'◯', */
	/* 25f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2600 */ 0,0,0,0,0,0xa1fa,0xa1f9,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'★','☆',0, 0,0,0,0,0,0,0,0, */
	/* 2610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2640 */ 0xa1ea,0,0xa1e9,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '♀',0,'♂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2660 */ 0,0,0,0,0,0,0,0, 0,0,0xa2f6,0,0,0xa2f5,0,0xa2f4, /* 0,0,0,0,0,0,0,0, 0,0,'♪',0,0,'♭',0,'♯', */
	/* 2670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3000 */ 0xa1a1,0xa1a2,0xa1a3,0xa1b7,0,0xa1b9,0xa1ba,0xa1bb, 0xa1d2,0xa1d3,0xa1d4,0xa1d5,0xa1d6,0xa1d7,0xa1d8,0xa1d9, /* '　','、','。','〃',0,'々','〆','〇', '〈','〉','《','》','「','」','『','』', */
	/* 3010 */ 0xa1da,0xa1db,0xa2a9,0xa2ae,0xa1cc,0xa1cd,0,0, 0,0,0,0,0xa1c1,0xade0,0,0xade1, /* '【','】','〒','〓','〔','〕',0,0, 0,0,0,0,'～','〝',0,'〟', */
	/* 3020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3040 */ 0,0xa4a1,0xa4a2,0xa4a3,0xa4a4,0xa4a5,0xa4a6,0xa4a7, 0xa4a8,0xa4a9,0xa4aa,0xa4ab,0xa4ac,0xa4ad,0xa4ae,0xa4af, /* 0,'ぁ','あ','ぃ','い','ぅ','う','ぇ', 'え','ぉ','お','か','が','き','ぎ','く', */
	/* 3050 */ 0xa4b0,0xa4b1,0xa4b2,0xa4b3,0xa4b4,0xa4b5,0xa4b6,0xa4b7, 0xa4b8,0xa4b9,0xa4ba,0xa4bb,0xa4bc,0xa4bd,0xa4be,0xa4bf, /* 'ぐ','け','げ','こ','ご','さ','ざ','し', 'じ','す','ず','せ','ぜ','そ','ぞ','た', */
	/* 3060 */ 0xa4c0,0xa4c1,0xa4c2,0xa4c3,0xa4c4,0xa4c5,0xa4c6,0xa4c7, 0xa4c8,0xa4c9,0xa4ca,0xa4cb,0xa4cc,0xa4cd,0xa4ce,0xa4cf, /* 'だ','ち','ぢ','っ','つ','づ','て','で', 'と','ど','な','に','ぬ','ね','の','は', */
	/* 3070 */ 0xa4d0,0xa4d1,0xa4d2,0xa4d3,0xa4d4,0xa4d5,0xa4d6,0xa4d7, 0xa4d8,0xa4d9,0xa4da,0xa4db,0xa4dc,0xa4dd,0xa4de,0xa4df, /* 'ば','ぱ','ひ','び','ぴ','ふ','ぶ','ぷ', 'へ','べ','ぺ','ほ','ぼ','ぽ','ま','み', */
	/* 3080 */ 0xa4e0,0xa4e1,0xa4e2,0xa4e3,0xa4e4,0xa4e5,0xa4e6,0xa4e7, 0xa4e8,0xa4e9,0xa4ea,0xa4eb,0xa4ec,0xa4ed,0xa4ee,0xa4ef, /* 'む','め','も','ゃ','や','ゅ','ゆ','ょ', 'よ','ら','り','る','れ','ろ','ゎ','わ', */
	/* 3090 */ 0xa4f0,0xa4f1,0xa4f2,0xa4f3,0,0,0,0, 0,0,0,0xa1ab,0xa1ac,0xa1b5,0xa1b6,0, /* 'ゐ','ゑ','を','ん',0,0,0,0, 0,0,0,'゛','゜','ゝ','ゞ',0, */
	/* 30a0 */ 0,0xa5a1,0xa5a2,0xa5a3,0xa5a4,0xa5a5,0xa5a6,0xa5a7, 0xa5a8,0xa5a9,0xa5aa,0xa5ab,0xa5ac,0xa5ad,0xa5ae,0xa5af, /* 0,'ァ','ア','ィ','イ','ゥ','ウ','ェ', 'エ','ォ','オ','カ','ガ','キ','ギ','ク', */
	/* 30b0 */ 0xa5b0,0xa5b1,0xa5b2,0xa5b3,0xa5b4,0xa5b5,0xa5b6,0xa5b7, 0xa5b8,0xa5b9,0xa5ba,0xa5bb,0xa5bc,0xa5bd,0xa5be,0xa5bf, /* 'グ','ケ','ゲ','コ','ゴ','サ','ザ','シ', 'ジ','ス','ズ','セ','ゼ','ソ','ゾ','タ', */
	/* 30c0 */ 0xa5c0,0xa5c1,0xa5c2,0xa5c3,0xa5c4,0xa5c5,0xa5c6,0xa5c7, 0xa5c8,0xa5c9,0xa5ca,0xa5cb,0xa5cc,0xa5cd,0xa5ce,0xa5cf, /* 'ダ','チ','ヂ','ッ','ツ','ヅ','テ','デ', 'ト','ド','ナ','ニ','ヌ','ネ','ノ','ハ', */
	/* 30d0 */ 0xa5d0,0xa5d1,0xa5d2,0xa5d3,0xa5d4,0xa5d5,0xa5d6,0xa5d7, 0xa5d8,0xa5d9,0xa5da,0xa5db,0xa5dc,0xa5dd,0xa5de,0xa5df, /* 'バ','パ','ヒ','ビ','ピ','フ','ブ','プ', 'ヘ','ベ','ペ','ホ','ボ','ポ','マ','ミ', */
	/* 30e0 */ 0xa5e0,0xa5e1,0xa5e2,0xa5e3,0xa5e4,0xa5e5,0xa5e6,0xa5e7, 0xa5e8,0xa5e9,0xa5ea,0xa5eb,0xa5ec,0xa5ed,0xa5ee,0xa5ef, /* 'ム','メ','モ','ャ','ヤ','ュ','ユ','ョ', 'ヨ','ラ','リ','ル','レ','ロ','ヮ','ワ', */
	/* 30f0 */ 0xa5f0,0xa5f1,0xa5f2,0xa5f3,0xa5f4,0xa5f5,0xa5f6,0, 0,0,0,0xa1a6,0xa1bc,0xa1b3,0xa1b4,0, /* 'ヰ','ヱ','ヲ','ン','ヴ','ヵ','ヶ',0, 0,0,0,'・','ー','ヽ','ヾ',0, */
	/* 3100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3230 */ 0,0xadea,0xadeb,0,0,0,0,0, 0,0xadec,0,0,0,0,0,0, /* 0,'㈱','㈲',0,0,0,0,0, 0,'㈹',0,0,0,0,0,0, */
	/* 3240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32a0 */ 0,0,0,0,0xade5,0xade6,0xade7,0xade8, 0xade9,0,0,0,0,0,0,0, /* 0,0,0,0,'㊤','㊥','㊦','㊧', '㊨',0,0,0,0,0,0,0, */
	/* 32b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3300 */ 0,0,0,0xadc6,0,0,0,0, 0,0,0,0,0,0xadca,0,0, /* 0,0,0,'㌃',0,0,0,0, 0,0,0,0,0,'㌍',0,0, */
	/* 3310 */ 0,0,0,0,0xadc1,0,0,0, 0xadc4,0,0,0,0,0,0,0, /* 0,0,0,0,'㌔',0,0,0, '㌘',0,0,0,0,0,0,0, */
	/* 3320 */ 0,0,0xadc2,0xadcc,0,0,0xadcb,0xadc5, 0,0,0,0xadcd,0,0,0,0, /* 0,0,'㌢','㌣',0,0,'㌦','㌧', 0,0,0,'㌫',0,0,0,0, */
	/* 3330 */ 0,0,0,0,0,0,0xadc7,0, 0,0,0,0xadcf,0,0,0,0, /* 0,0,0,0,0,0,'㌶',0, 0,0,0,'㌻',0,0,0,0, */
	/* 3340 */ 0,0,0,0,0,0,0,0, 0,0xadc0,0xadce,0,0,0xadc3,0,0, /* 0,0,0,0,0,0,0,0, 0,'㍉','㍊',0,0,'㍍',0,0, */
	/* 3350 */ 0,0xadc8,0,0,0,0,0,0xadc9, 0,0,0,0,0,0,0,0, /* 0,'㍑',0,0,0,0,0,'㍗', 0,0,0,0,0,0,0,0, */
	/* 3360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3370 */ 0,0,0,0,0,0,0,0, 0,0,0,0xaddf,0xadef,0xadee,0xaded,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'㍻','㍼','㍽','㍾',0, */
	/* 3380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xadd3,0xadd4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㎎','㎏', */
	/* 3390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xadd0,0xadd1,0xadd2,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㎜','㎝','㎞',0, */
	/* 33a0 */ 0,0xadd6,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'㎡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 33b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33c0 */ 0,0,0,0,0xadd5,0,0,0, 0,0,0,0,0,0xade3,0,0, /* 0,0,0,0,'㏄',0,0,0, 0,0,0,0,0,'㏍',0,0, */
	/* 33d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

	/* 36d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e00 */ 0xb0ec,0xc3fa,0x8fb0a1,0xbcb7,0x8fb0a2,0x8fb0a3,0,0xcbfc, 0xbee6,0xbbb0,0xbee5,0xb2bc,0x8fb0a4,0xc9d4,0xcdbf,0, /* '一','丁','丂','七','丄','丅',0,'万', '丈','三','上','下','丌','不','与',0, */
	/* 4e10 */ 0xd0a2,0xb1af,0x8fb0a5,0,0xb3ee,0xd0a3,0xc0a4,0xd2c2, 0xb5d6,0xcaba,0,0,0,0,0xbee7,0x8fb0a6, /* '丐','丑','丒',0,'且','丕','世','丗', '丘','丙',0,0,0,0,'丞','丟', */
	/* 4e20 */ 0,0xcebe,0,0x8fb0a7,0x8fb0a8,0,0xcac2,0, 0x8fb0a9,0,0xd0a4,0x8fb0aa,0,0xc3e6,0x8fb0ab,0x8fb0ac, /* 0,'両',0,'丣','两',0,'並',0, '丨',0,'个','丫',0,'中','丮','丯', */
	/* 4e30 */ 0x8fb0ad,0xd0a5,0xb6fa,0,0,0x8fb0ae,0xd0a6,0, 0xb4dd,0xc3b0,0,0xbce7,0xd0a7,0,0,0xd0a8, /* '丰','丱','串',0,0,'丵','丶',0, '丸','丹',0,'主','丼',0,0,'丿', */
	/* 4e40 */ 0x8fb0af,0x8fb0b0,0xd0a9,0xc7b5,0x8fb0b1,0xb5d7,0,0x8fb0b2, 0,0,0,0xc7b7,0,0xc6e3,0xb8c3,0xcbb3, /* '乀','乁','乂','乃','乄','久',0,'乇', 0,0,0,'之',0,'乍','乎','乏', */
	/* 4e50 */ 0,0x8fb0b3,0,0,0,0xe9c9,0xd0aa,0xbee8, 0xd0ab,0xb2b5,0x8fb0b4,0,0x8fb0b5,0xb6e5,0xb8f0,0xcce9, /* 0,'乑',0,0,0,'乕','乖','乗', '乘','乙','乚',0,'乜','九','乞','也', */
	/* 4e60 */ 0,0,0xd6a6,0x8fb0b6,0,0,0,0, 0x8fb0b7,0x8fb0b8,0,0,0,0,0,0, /* 0,0,'乢','乣',0,0,0,0, '乨','乩',0,0,0,0,0,0, */
	/* 4e70 */ 0,0xcdf0,0,0xc6fd,0x8fb0b9,0x8fb0ba,0,0, 0,0x8fb0bb,0,0,0,0,0xb4a5,0x8fb0bc, /* 0,'乱',0,'乳','乴','乵',0,0, 0,'乹',0,0,0,0,'乾','乿', */
	/* 4e80 */ 0xb5b5,0,0xd0ac,0,0,0xd0ad,0xcebb,0, 0xcdbd,0xc1e8,0xd0af,0xbbf6,0xc6f3,0x8fb0bd,0xd0b2,0, /* '亀',0,'亂',0,0,'亅','了',0, '予','争','亊','事','二','亍','于',0, */
	/* 4e90 */ 0,0xb1be,0xb8df,0,0xb8de,0xb0e6,0x8fb0be,0x8fb0bf, 0xcfcb,0xcfca,0,0xbab3,0xb0a1,0x8fb0c0,0xd0b3,0xd0b4, /* 0,'云','互',0,'五','井','亖','亗', '亘','亙',0,'些','亜','亝','亞','亟', */
	/* 4ea0 */ 0xd0b5,0xcbb4,0xd0b6,0,0xb8f2,0xb0e7,0xcbf2,0, 0xb5fc,0,0,0xb5fd,0xb5fe,0xc4e2,0xcebc,0x8fb0c1, /* '亠','亡','亢',0,'交','亥','亦',0, '亨',0,0,'享','京','亭','亮','亯', */
	/* 4eb0 */ 0xd0b7,0,0,0xd0b8,0,0,0xd0b9,0, 0,0x8fb0c2,0xbfcd,0,0,0,0,0, /* '亰',0,0,'亳',0,0,'亶',0, 0,'亹','人',0,0,0,0,0, */
	/* 4ec0 */ 0xbdba,0xbfce,0xd0be,0x8fb0c3,0xd0bc,0,0xd0bd,0xb5d8, 0,0,0xbaa3,0xb2f0,0,0xd0bb,0xd0ba,0xcaa9, /* '什','仁','仂','仃','仄',0,'仆','仇', 0,0,'今','介',0,'仍','从','仏', */
	/* 4ed0 */ 0x8fb0c4,0,0,0,0xbbc6,0xbbc5,0xc2be,0xd0bf, 0xc9d5,0xc0e7,0x8fb0c5,0x8fb0c6,0,0xa1b8,0xd0c0,0xd0c2, /* '仐',0,0,0,'仔','仕','他','仗', '付','仙','仚','仛',0,'仝','仞','仟', */
	/* 4ee0 */ 0x8fb0c7,0x8fb0c8,0x8fb0c9,0xc2e5,0xcee1,0xb0ca,0,0, 0x8fb0ca,0,0,0,0,0xd0c1,0xb2be,0x8fb0cb, /* '仠','仡','仢','代','令','以',0,0, '仨',0,0,0,0,'仭','仮','仯', */
	/* 4ef0 */ 0xb6c4,0x8fb0cc,0xc3e7,0x8fb0cd,0,0x8fb0ce,0xb7ef,0xd0c3, 0,0,0,0xc7a4,0x8ff4af,0x8fb0cf,0x8fb0d0,0x8fb0d1, /* '仰','仱','仲','仳',0,'仵','件','价', 0,0,0,'任','仼','份','仾','仿', */
	/* 4f00 */ 0x8fb0d2,0xb4eb,0x8fb0d3,0x8fb0d4,0,0,0,0, 0x8fb0d5,0xd0c4,0xb0cb,0x8fb0d6,0x8fb0d7,0xb8e0,0xb4ec,0xc9fa, /* '伀','企','伂','伃',0,0,0,0, '伈','伉','伊','伋','伌','伍','伎','伏', */
	/* 4f10 */ 0xc8b2,0xb5d9,0x8fb0d8,0,0,0x8fb0d9,0x8fb0da,0x8fb0db, 0,0x8fb0dc,0xb2f1,0,0xd0e7,0xc5c1,0,0, /* '伐','休','伒',0,0,'伕','伖','众', 0,'伙','会',0,'伜','伝',0,0, */
	/* 4f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x8fb0dd,0xc7ec, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'伮','伯', */
	/* 4f30 */ 0xd0c6,0x8fb0de,0,0x8fb0e0,0xc8bc,0x8fb0e1,0xcee2,0x8fb0e2, 0xbfad,0x8fb0e3,0xbbc7,0x8fb0e4,0xbbf7,0xb2c0,0x8fb0e5,0, /* '估','伱',0,'伳','伴','伵','伶','伷', '伸','伹','伺','伻','似','伽','伾',0, */
	/* 4f40 */ 0x8fb0e6,0,0x8fb0e7,0xc4d1,0,0,0xc3a2,0xd0ca, 0x8fb0e8,0x8fb0e9,0,0x8fb0ea,0x8fb0eb,0xb0cc,0xc4e3,0xbdbb, /* '佀',0,'佂','佃',0,0,'但','佇', '佈','佉',0,'佋','佌','位','低','住', */
	/* 4f50 */ 0xbab4,0xcda4,0x8fb0ec,0xc2ce,0x8fb0ed,0xb2bf,0x8fb0ee,0xd0c9, 0x8fb0ef,0xcdbe,0xd0c5,0xd0c7,0xbaee,0xd0c8,0xd5a4,0x8fb0f0, /* '佐','佑','佒','体','佔','何','佖','佗', '佘','余','佚','佛','作','佝','佞','佟', */
	/* 4f60 */ 0x8fb0df,0,0,0x8fb0f1,0,0,0,0, 0,0xd0d0,0x8fb0f2,0,0x8fb0f3,0,0x8fb0f4,0xd0d3, /* '你',0,0,'佣',0,0,0,0, 0,'佩','佪',0,'佬',0,'佮','佯', */
	/* 4f70 */ 0xd0d1,0x8fb0f5,0,0xb2c2,0,0xcabb,0xd0cb,0x8fb0f6, 0x8fb0f7,0x8fb0f8,0x8fb0f9,0xd0cf,0xb8f3,0x8fb0fa,0x8fb0fb,0xbbc8, /* '佰','佱',0,'佳',0,'併','佶','佷', '佸','佹','佺','佻','佼','佽','佾','使', */
	/* 4f80 */ 0,0x8fb0fc,0x8fb0fd,0xb4a6,0x8fb0fe,0x8fb1a1,0xd0d4,0, 0xd0cc,0x8fb1a2,0x8fb1a3,0xcee3,0x8fb1a4,0xbbf8,0x8fb1a5,0xd0cd, /* 0,'侁','侂','侃','侄','侅','來',0, '侈','侉','侊','例','侌','侍','侎','侏', */
	/* 4f90 */ 0x8fb1a6,0xd0d2,0x8fb1a7,0x8fb1a8,0x8fb1a9,0,0xd0d5,0x8fb1aa, 0xd0ce,0x8fb1ab,0x8fb1ac,0xb6a1,0,0xb0cd,0x8fb1ad,0x8fb1ae, /* '侐','侑','侒','侓','侔',0,'侖','侗', '侘','侙','侚','供',0,'依','侞','侟', */
	/* 4fa0 */ 0xb6a2,0xb2c1,0,0,0,0,0,0, 0,0,0,0xd5a5,0,0xcbf9,0xc9ee,0xb8f4, /* '侠','価',0,0,0,0,0,0, 0,0,0,'侫',0,'侭','侮','侯', */
	/* 4fb0 */ 0,0,0x8fb1af,0,0,0xbfaf,0xceb7,0x8fb1b0, 0,0x8fb1b1,0,0x8fb1b2,0x8fb1b3,0x8fb1b4,0x8fb1b5,0xcad8, /* 0,0,'侲',0,0,'侵','侶','侷', 0,'侹',0,'侻','侼','侽','侾','便', */
	/* 4fc0 */ 0x8fb1b6,0x8fb1b7,0xb7b8,0xc2a5,0xb2e4,0x8fb1b8,0x8fb1b9,0, 0x8fb1ba,0x8fb1bb,0xbdd3,0x8fb1bc,0x8fb1bd,0x8fb1be,0xd0d9,0x8fb1bf, /* '俀','俁','係','促','俄','俅','俆',0, '俈','俉','俊','俋','俌','俍','俎','俏', */
	/* 4fd0 */ 0xd0de,0xd0dc,0x8fb1c0,0,0xd0d7,0,0,0xc2af, 0xd0da,0,0xd0dd,0xd0db,0x8fb1c1,0xcadd,0,0xd0d8, /* '俐','俑','俒',0,'俔',0,0,'俗', '俘',0,'俚','俛','俜','保',0,'俟', */
	/* 4fe0 */ 0x8fb1c2,0xbfae,0x8fb1c3,0xcbf3,0xd0df,0xd0e0,0,0, 0,0,0,0,0,0,0xbda4,0xd0ed, /* '俠','信','俢','俣','俤','俥',0,0, 0,0,0,0,0,0,'修','俯', */
	/* 4ff0 */ 0x8fb1c4,0,0x8fb1c5,0xc7d0,0,0xc9b6,0xd0e8,0, 0xcaf0,0,0xb2b6,0,0x8fb1c6,0x8fb1c7,0xd0ec,0x8fb1c8, /* '俰',0,'俲','俳',0,'俵','俶',0, '俸',0,'俺',0,'俼','俽','俾','俿', */
	/* 5000 */ 0x8fb1c9,0x8fb1ca,0,0,0x8fb1cb,0xd0e6,0xd0ef,0x8fb1cc, 0,0xc1d2,0x8fb1cd,0xb8c4,0x8fb1ce,0xc7dc,0x8fb1cf,0xe0c7, /* '倀','倁',0,0,'倄','倅','倆','倇', 0,'倉','倊','個','倌','倍','倎','倏', */
	/* 5010 */ 0x8fb1d0,0xd0ee,0xc5dd,0x8fb1d1,0xd0e3,0,0xb8f6,0x8fb1d2, 0x8fb1d3,0xb8f5,0xd0e1,0x8fb1d4,0x8fb1d5,0x8fb1d6,0x8fb1d7,0xbcda, /* '倐','們','倒','倓','倔',0,'倖','倗', '倘','候','倚','倛','倜','倝','倞','借', */
	/* 5020 */ 0,0xd0e9,0x8fb1d8,0xcaef,0xc3cd,0xd0e5,0xb7f1,0x8fb1d9, 0xd0e2,0xd0ea,0xd0e4,0xced1,0xd0eb,0xcfc1,0x8fb1da,0, /* 0,'倡','倢','倣','値','倥','倦','倧', '倨','倩','倪','倫','倬','倭','倮',0, */
	/* 5030 */ 0x8fb1db,0,0x8fb1dc,0x8fb1dd,0,0x8fb1de,0xb6e6,0, 0,0xb7f0,0,0x8fb1f6,0,0,0,0, /* '倰',0,'倲','倳',0,'倵','倶',0, 0,'倹',0,'倻',0,0,0,0, */
	/* 5040 */ 0x8fb1df,0x8fb1e0,0x8fb1e1,0xd0f0,0,0x8fb1e2,0x8fb1e3,0xd0f1, 0xd0f5,0xb0ce,0x8fb1e4,0,0x8fb1e5,0,0x8fb1e6,0xcad0, /* '偀','偁','偂','偃',0,'偅','偆','假', '偈','偉','偊',0,'偌',0,'偎','偏', */
	/* 5050 */ 0xd0f4,0x8fb1e7,0x8fb1e8,0x8fb1e9,0,0xd0f3,0xd0f7,0x8fb1ea, 0,0x8fb1eb,0xd0f6,0,0xc4e4,0,0,0x8fb1ec, /* '偐','偑','偒','偓',0,'偕','偖','偗', 0,'偙','做',0,'停',0,0,'偟', */
	/* 5060 */ 0x8fb1ed,0,0x8fb1ee,0x8fb1ef,0,0xb7f2,0x8fb1f0,0x8fb1f1, 0,0,0x8fb1f2,0,0xd0f8,0x8fb1f3,0,0, /* '偠',0,'偢','偣',0,'健','偦','偧', 0,0,'偪',0,'偬','偭',0,0, */
	/* 5070 */ 0x8fb1f4,0x8fb1f5,0xbcc5,0,0xc2a6,0xc4e5,0xb6f6,0, 0xd0f9,0,0,0,0,0xb5b6,0,0, /* '偰','偱','偲',0,'側','偵','偶',0, '偸',0,0,0,0,'偽',0,0, */
	/* 5080 */ 0xd0fa,0x8fb1f7,0,0x8fb1f8,0x8fb1f9,0xd0fc,0x8fb1fa,0, 0,0,0x8fb1fb,0,0,0xcbb5,0x8fb1fc,0x8fb1fd, /* '傀','傁',0,'傃','傄','傅','傆',0, 0,0,'傊',0,0,'傍','傎','傏', */
	/* 5090 */ 0x8fb1fe,0xb7e6,0x8fb2a1,0x8fb2a2,0x8fb2a3,0,0x8fb2a4,0, 0xbbb1,0xc8f7,0xd0fb,0x8fb2a5,0x8fb2a6,0,0x8fb2a7,0x8fb2a8, /* '傐','傑','傒','傓','傔',0,'傖',0, '傘','備','傚','傛','傜',0,'傞','傟', */
	/* 50a0 */ 0x8fb2a9,0x8fb2aa,0x8fb2ab,0,0,0,0,0, 0,0,0x8fb2ac,0,0xbac5,0xcdc3,0,0x8fb2ad, /* '傠','傡','傢',0,0,0,0,0, 0,0,'傪',0,'催','傭',0,'傯', */
	/* 50b0 */ 0x8fb2ae,0,0xd0fe,0xd1a3,0xd0fd,0xbac4,0,0xbdfd, 0,0x8fb2af,0x8fb2b0,0,0,0x8fb2b1,0xb7b9,0, /* '傰',0,'傲','傳','傴','債',0,'傷', 0,'傹','傺',0,0,'傽','傾',0, */
	/* 50c0 */ 0x8fb2b2,0,0xd1a4,0x8fb2b3,0x8fb2b4,0xb6cf,0,0x8fb2b5, 0,0xd1a1,0xd1a2,0,0x8fb2b6,0xc6af,0x8fb2b7,0xc1fc, /* '僀',0,'僂','僃','僄','僅',0,'僇', 0,'僉','僊',0,'僌','働','僎','像', */
	/* 50d0 */ 0x8fb2b8,0xb6a3,0,0x8fb2b9,0x8fb2ba,0xcbcd,0xd1a5,0, 0x8fb2bb,0,0xcebd,0,0x8fb2bc,0x8fb2bd,0xd1a6,0x8fb2be, /* '僐','僑',0,'僓','僔','僕','僖',0, '僘',0,'僚',0,'僜','僝','僞','僟', */
	/* 50e0 */ 0,0,0x8fb2bf,0xd1a9,0x8fb2c0,0xd1a7,0x8fb2c1,0xc1ce, 0x8fb2c2,0x8fb2c3,0,0,0,0xd1a8,0xd1aa,0x8fb2c4, /* 0,0,'僢','僣','僤','僥','僦','僧', '僨','僩',0,0,0,'僭','僮','僯', */
	/* 50f0 */ 0,0x8fb2c5,0x8fb2d1,0,0x8ff4b0,0xd1ac,0x8fb2c6,0, 0,0xd1ab,0x8fb2c7,0xcac8,0,0,0x8fb2c8,0, /* 0,'僱','僲',0,'僴','僵','僶',0, 0,'價','僺','僻',0,0,'僾',0, */
	/* 5100 */ 0xb5b7,0xd1ae,0xd1af,0x8fb2c9,0xb2af,0,0x8fb2ca,0x8fb2cb, 0x8fb2cc,0xd1ad,0,0x8fb2cd,0x8fb2ce,0x8fb2cf,0x8fb2d0,0, /* '儀','儁','儂','儃','億',0,'儆','儇', '儈','儉',0,'儋','儌','儍','儎',0, */
	/* 5110 */ 0x8fb2d2,0,0xbcf4,0,0xd1b2,0xd1b1,0xd1b0,0x8fb2d3, 0xd0d6,0x8fb2d4,0xd1b3,0x8fb2d5,0x8fb2d6,0x8fb2d7,0x8fb2d8,0xbdfe, /* '儐',0,'儒',0,'儔','儕','儖','儗', '儘','儙','儚','儛','儜','儝','儞','償', */
	/* 5120 */ 0,0xd1b4,0,0x8fb2d9,0,0,0,0x8fb2da, 0x8fb2db,0,0xcda5,0,0x8fb2dc,0x8fb2dd,0,0x8fb2de, /* 0,'儡',0,'儣',0,0,0,'儧', '儨',0,'優',0,'儬','儭',0,'儯', */
	/* 5130 */ 0,0x8fb2df,0xccd9,0x8fb2e0,0x8fb2e1,0x8fb2e2,0,0xd1b6, 0x8fb2e3,0x8fb2e4,0xd1b5,0xd1b8,0xd1b7,0,0,0xd1b9, /* 0,'儱','儲','儳','儴','儵',0,'儷', '儸','儹','儺','儻','儼',0,0,'儿', */
	/* 5140 */ 0xd1ba,0xb0f4,0x8fb2e5,0xb8b5,0xb7bb,0xbdbc,0xc3fb,0xb6a4, 0xc0e8,0xb8f7,0x8fb2e6,0xb9ee,0xd1bc,0xccc8,0xc5c6,0x8fb2e7, /* '兀','允','兂','元','兄','充','兆','兇', '先','光','兊','克','兌','免','兎','兏', */
	/* 5150 */ 0xbbf9,0,0xd1bb,0x8fb2e8,0xd1bd,0x8fb2e9,0,0x8fb2ea, 0x8fb2eb,0,0xc5de,0,0xb3f5,0,0,0x8fb2ec, /* '児',0,'兒','兓','兔','兕',0,'兗', '兘',0,'党',0,'兜',0,0,'兟', */
	/* 5160 */ 0,0,0xd1be,0,0x8fb2ed,0xc6fe,0x8fb2ee,0, 0xc1b4,0xd1c0,0xd1c1,0xc8ac,0xb8f8,0xcfbb,0xd1c2,0, /* 0,0,'兢',0,'兤','入','兦',0, '全','兩','兪','八','公','六','兮',0, */
	/* 5170 */ 0,0xb6a6,0,0,0,0xcabc,0xc2b6,0xb6f1, 0xc5b5,0,0,0,0xb7f3,0,0x8fb2ef,0, /* 0,'共',0,0,0,'兵','其','具', '典',0,0,0,'兼',0,'兾',0, */
	/* 5180 */ 0xd1c3,0,0xd1c4,0x8fb2f0,0x8fb2f1,0xc6e2,0xb1df,0, 0,0xd1c7,0xbafd,0x8fb2f2,0xd1c6,0xbac6,0x8fb2f3,0xd1c8, /* '冀',0,'冂','冃','冄','内','円',0, 0,'冉','冊','冋','册','再','冎','冏', */
	/* 5190 */ 0xe6ee,0xd1c9,0xcbc1,0xd1ca,0,0xd1cb,0xd1cc,0xbee9, 0x8fb2f4,0xbccc,0,0,0,0x8fb2f5,0,0, /* '冐','冑','冒','冓',0,'冕','冖','冗', '冘','写',0,0,0,'冝',0,0, */
	/* 51a0 */ 0xb4a7,0x8fb2f6,0xd1cf,0x8fb2f7,0xd1cd,0xccbd,0xd1ce,0, 0xc9da,0xd1d0,0xd1d1,0xd1d2,0xc5df,0x8fb2f8,0,0, /* '冠','冡','冢','冣','冤','冥','冦',0, '冨','冩','冪','冫','冬','冭',0,0, */
	/* 51b0 */ 0xd1d6,0xd1d4,0xd1d5,0xd1d3,0xbae3,0xd1d7,0xccea,0xcee4, 0x8fb2f9,0,0x8fb2fa,0,0x8fb2fb,0xd1d8,0x8fb2fc,0x8fb2fd, /* '冰','冱','冲','决','冴','况','冶','冷', '冸',0,'冺',0,'冼','冽','冾','冿', */
	/* 51c0 */ 0,0,0x8fb2fe,0,0xc0a8,0xd1d9,0xbdda,0, 0x8fb3a1,0xd1da,0,0xc3fc,0xcebf,0xc5e0,0,0x8fb3a2, /* 0,0,'凂',0,'凄','凅','准',0, '凈','凉',0,'凋','凌','凍',0,'减', */
	/* 51d0 */ 0,0x8fb3a3,0x8fb3a4,0x8fb3a5,0,0x8fb3a6,0xd2c5,0, 0x8fb3a7,0,0,0xd1db,0xf4a5,0xb6c5,0x8fb3a8,0, /* 0,'凑','凒','凓',0,'凕','凖',0, '凘',0,0,'凛','凜','凝','凞',0, */
	/* 51e0 */ 0xd1dc,0xcbde,0x8fb3a9,0,0,0x8fb3aa,0xbde8,0xc2fc, 0,0xd1de,0xc6e4,0,0x8ff4b1,0xd1df,0x8fb3ab,0, /* '几','凡','凢',0,0,'凥','処','凧', 0,'凩','凪',0,'凬','凭','凮',0, */
	/* 51f0 */ 0xd1e0,0xb3ae,0x8fb3ac,0x8fb3ad,0x8fb3ae,0xd1e1,0xb6a7,0x8fb3af, 0xc6cc,0xb1fa,0xbdd0,0,0,0xc8a1,0xd1e2,0, /* '凰','凱','凲','凳','凴','凵','凶','凷', '凸','凹','出',0,0,'函','凾',0, */
	/* 5200 */ 0xc5e1,0x8fb3b0,0x8fb3b1,0xbfcf,0xd1e3,0x8fb3b2,0xcaac,0xc0da, 0xb4a2,0,0xb4a9,0xd1e4,0,0,0xd1e6,0, /* '刀','刁','刂','刃','刄','刅','分','切', '刈',0,'刊','刋',0,0,'刎',0, */
	/* 5210 */ 0,0xb7ba,0x8fb3b3,0x8fb3b4,0xd1e5,0x8fb3b5,0x8fb3b6,0xcef3, 0x8fb3b7,0,0,0,0,0xbde9,0,0, /* 0,'刑','划','刓','刔','刕','刖','列', '刘',0,0,0,0,'初',0,0, */
	/* 5220 */ 0,0,0x8fb3b8,0,0xc8bd,0xcacc,0,0xd1e7, 0x8fb3b9,0xcdf8,0xd1e8,0,0,0,0xd1e9,0, /* 0,0,'刢',0,'判','別',0,'刧', '刨','利','刪',0,0,0,'刮',0, */
	/* 5230 */ 0xc5fe,0x8fb3ba,0x8fb3bb,0xd1ea,0,0x8fb3bc,0xc0a9,0xbafe, 0xb7f4,0xd1eb,0xbbc9,0xb9ef,0x8fb3bd,0,0,0, /* '到','刱','刲','刳',0,'刵','制','刷', '券','刹','刺','刻','刼',0,0,0, */
	/* 5240 */ 0,0,0,0xc4e6,0xd1ed,0x8fb3be,0,0xc2a7, 0,0x8fb3bf,0xbaef,0xd1ee,0xd1ef,0xc1b0,0,0xd1ec, /* 0,0,0,'剃','剄','剅',0,'則', 0,'剉','削','剋','剌','前',0,'剏', */
	/* 5250 */ 0,0,0,0,0xd1f1,0x8fb3c0,0xcbb6,0x8fb3c1, 0x8fb3c2,0,0x8fb3c3,0xb9e4,0x8fb3c4,0,0xd1f0,0x8fb3c5, /* 0,0,0,0,'剔','剕','剖','剗', '剘',0,'剚','剛','剜',0,'剞','剟', */
	/* 5260 */ 0x8fb3c6,0x8fb3c7,0,0xb7f5,0xbade,0xc7ed,0x8fb3c8,0, 0,0xd1f4,0xd1f2,0,0,0,0x8fb3c9,0xc9fb, /* '剠','剡',0,'剣','剤','剥','剦',0, 0,'剩','剪',0,0,0,'剮','副', */
	/* 5270 */ 0xbeea,0xd1fb,0xb3e4,0xd1f5,0xd1f3,0xc1cf,0,0x8fb3ca, 0x8fb3cb,0x8fb3cc,0,0,0,0xd1f7,0,0xd1f6, /* '剰','剱','割','剳','剴','創',0,'剷', '剸','剹',0,0,0,'剽',0,'剿', */
	/* 5280 */ 0x8fb3cd,0,0x8fb3ce,0xb3c4,0,0x8fb3cf,0,0xb7e0, 0xd1fc,0xcead,0x8fb3d0,0,0x8fb3d1,0xd1f8,0,0, /* '劀',0,'劂','劃',0,'劅',0,'劇', '劈','劉','劊',0,'劌','劍',0,0, */
	/* 5290 */ 0,0xd1fd,0xd1fa,0x8fb3d2,0xd1f9,0x8fb3d3,0x8fb3d4,0x8fb3d5, 0x8fb3d6,0,0x8fb3d7,0xcecf,0x8fb3d8,0,0,0xb8f9, /* 0,'劑','劒','劓','劔','劕','劖','劗', '劘',0,'劚','力','劜',0,0,'功', */
	/* 52a0 */ 0xb2c3,0,0,0xcef4,0x8fb3d9,0x8fb3da,0x8fb3db,0x8fb3dc, 0,0xbdf5,0xc5d8,0xb9e5,0xd2a2,0xd2a3,0,0x8fb3dd, /* '加',0,0,'劣','劤','劥','劦','劧', 0,'助','努','劫','劬','劭',0,'劯', */
	/* 52b0 */ 0x8fb3de,0xcee5,0,0,0xcfab,0xd2a5,0x8fb3df,0x8fb3e0, 0x8fb3e1,0xb8fa,0x8fb3e2,0x8fb3e3,0xd2a4,0x8fb3e4,0xb3af,0, /* '劰','励',0,0,'労','劵','劶','劷', '劸','効','劺','劻','劼','劽','劾',0, */
	/* 52c0 */ 0x8fb3e5,0xd2a6,0,0xcbd6,0x8fb3e6,0xc4bc,0x8fb3e7,0xcda6, 0x8fb3e8,0xcad9,0,0,0x8fb3e9,0xd2a7,0,0x8fb3ea, /* '勀','勁',0,'勃','勄','勅','勆','勇', '勈','勉',0,0,'勌','勍',0,'勏', */
	/* 52d0 */ 0,0x8fb3eb,0xf0d5,0,0x8fb3ec,0xc6b0,0x8fb3ed,0xd2a8, 0xb4aa,0xccb3,0,0x8fb3ee,0x8fb3ef,0xbea1,0xd2a9,0xcae7, /* 0,'勑','勒',0,'勔','動','勖','勗', '勘','務',0,'勛','勜','勝','勞','募', */
	/* 52e0 */ 0xd2ad,0x8fb3f0,0xc0aa,0xd2aa,0xb6d0,0x8fb3f1,0xd2ab,0xb4ab, 0x8fb3f2,0x8fb3f3,0x8fb3f4,0,0x8fb3f5,0,0,0, /* '勠','勡','勢','勣','勤','勥','勦','勧', '勨','勩','勪',0,'勬',0,0,0, */
	/* 52f0 */ 0x8fb3f6,0x8fb3f7,0xb7ae,0xd2ae,0x8fb3f8,0xd2af,0x8fb3f9,0x8fb3fa, 0xd2b0,0xd2b1,0xbcdb,0,0,0,0xb8fb,0xccde, /* '勰','勱','勲','勳','勴','勵','勶','勷', '勸','勹','勺',0,0,0,'勾','勿', */
	/* 5300 */ 0x8fb3fb,0xcce8,0xc6f7,0x8fb3fc,0,0xcaf1,0xd2b2,0x8ff4b2, 0xd2b3,0,0x8fb3fd,0x8fb3fe,0x8fb4a1,0xd2b5,0,0xd2b7, /* '匀','匁','匂','匃',0,'包','匆','匇', '匈',0,'匊','匋','匌','匍',0,'匏', */
	/* 5310 */ 0xd2b6,0x8fb4a2,0,0x8fb4a3,0,0xd2b8,0xb2bd,0xcbcc, 0x8fb4a4,0xbafc,0xd2b9,0x8fb4a5,0x8fb4a6,0xc1d9,0x8fb4a7,0x8fb4a8, /* '匐','匑',0,'匓',0,'匕','化','北', '匘','匙','匚','匛','匜','匝','匞','匟', */
	/* 5320 */ 0xbea2,0xb6a9,0,0xd2ba,0x8ff4b3,0x8fb4a9,0,0x8fb4aa, 0x8fb4ab,0x8fb4ac,0xc8db,0x8fb4ad,0x8fb4ae,0x8fb4af,0,0xd2bb, /* '匠','匡',0,'匣','匤','匥',0,'匧', '匨','匩','匪','匫','匬','匭',0,'匯', */
	/* 5330 */ 0x8fb4b0,0xd2bc,0x8fb4b1,0xd2bd,0,0x8fb4b2,0,0, 0xd2be,0xc9a4,0xb6e8,0xb0e5,0x8fb4b3,0x8fb4b4,0x8fb4b5,0xc6bf, /* '匰','匱','匲','匳',0,'匵',0,0, '匸','匹','区','医','匼','匽','匾','匿', */
	/* 5340 */ 0xd2bf,0xbdbd,0x8fb4b6,0xc0e9,0,0xd2c1,0xd2c0,0xbea3, 0xb8e1,0xd2c3,0xc8be,0x8fb4b8,0x8fb4b7,0xd2c4,0,0, /* '區','十','卂','千',0,'卅','卆','升', '午','卉','半','卋','卌','卍',0,0, */
	/* 5350 */ 0,0xc8dc,0xc2b4,0xc2ee,0xb6a8,0,0,0xc6ee, 0xc3b1,0x8fb4b9,0xc7ee,0x8fb4ba,0xcbce,0,0xd2c6,0, /* 0,'卑','卒','卓','協',0,0,'南', '単','卙','博','卛','卜',0,'卞',0, */
	/* 5360 */ 0xc0ea,0x8fb4bb,0,0x8fb4bc,0,0x8fb4bd,0xb7b5,0, 0,0xd2c7,0,0,0x8fb4be,0x8fb4bf,0xd2c8,0xb1ac, /* '占','卡',0,'卣',0,'卥','卦',0, 0,'卩',0,0,'卬','卭','卮','卯', */
	/* 5370 */ 0xb0f5,0xb4ed,0x8fb4c0,0xc2a8,0xb5d1,0xcdf1,0,0xd2cb, 0xb2b7,0x8fb4c1,0,0xd2ca,0,0,0x8fb4c2,0xb6aa, /* '印','危','卲','即','却','卵',0,'卷', '卸','卹',0,'卻',0,0,'卾','卿', */
	/* 5380 */ 0,0,0xd2cc,0x8fb4c3,0xccf1,0,0,0x8fb4c4, 0x8fb4c5,0,0,0,0,0,0x8fb4c6,0, /* 0,0,'厂','厃','厄',0,0,'厇', '厈',0,0,0,0,0,'厎',0, */
	/* 5390 */ 0,0,0,0x8fb4c7,0x8fb4c8,0,0xd2cd,0, 0xced2,0x8fb4c9,0xb8fc,0,0,0x8fb4ca,0,0xb8b6, /* 0,0,0,'厓','厔',0,'厖',0, '厘','厙','厚',0,0,'厝',0,'原', */
	/* 53a0 */ 0xd2ce,0x8fb4cb,0,0,0x8fb4cc,0xd2d0,0xd2cf,0, 0xbfdf,0xb1b9,0x8fb4cd,0x8fb4ce,0,0xb1de,0xd2d1,0x8fb4cf, /* '厠','厡',0,0,'厤','厥','厦',0, '厨','厩','厪','厫',0,'厭','厮','厯', */
	/* 53b0 */ 0xd2d2,0,0x8fb4d0,0xb8b7,0x8fb4d1,0x8fb4d2,0xd2d3,0x8fb4d3, 0x8fb4d4,0,0x8fb4d5,0xb5ee,0,0x8fb4d6,0,0, /* '厰',0,'厲','厳','厴','厵','厶','厷', '厸',0,'厺','去',0,'厽',0,0, */
	/* 53c0 */ 0x8fb4d7,0,0xbbb2,0xd2d4,0,0x8fb4d8,0,0, 0xcbf4,0xbab5,0xb5da,0xcda7,0xc1d0,0xc8bf,0xbcfd,0x8fb4d9, /* '叀',0,'参','參',0,'叅',0,0, '又','叉','及','友','双','反','収','叏', */
	/* 53d0 */ 0,0,0x8fb4da,0x8fb4db,0xbdc7,0x8fb4dc,0xbce8,0xbcf5, 0,0xbdf6,0x8fb4dd,0xc8c0,0,0x8fb4de,0x8fb4df,0xd2d7, /* 0,0,'叒','叓','叔','叕','取','受', 0,'叙','叚','叛',0,'叝','叞','叟', */
	/* 53e0 */ 0x8fb4e0,0xb1c3,0xc1d1,0xb8fd,0xb8c5,0xb6e7,0x8fb4e1,0x8fb4e2, 0xd2db,0xc3a1,0xc2fe,0xb6ab,0xbea4,0xd2dc,0xd2da,0xb2c4, /* '叠','叡','叢','口','古','句','另','叧', '叨','叩','只','叫','召','叭','叮','可', */
	/* 53f0 */ 0xc2e6,0xbcb8,0xbbcb,0xb1a6,0,0x8fb4e3,0xb3f0,0xb9e6, 0xbbca,0,0xd2dd,0,0,0,0,0, /* '台','叱','史','右',0,'叵','叶','号', '司',0,'叺',0,0,0,0,0, */
	/* 5400 */ 0,0xd2de,0x8fb4e4,0xb5c9,0xb3c6,0,0,0, 0xb9e7,0xb5c8,0xc4df,0xb1a5,0xc6b1,0xccbe,0xb9a1,0xcdf9, /* 0,'吁','吂','吃','各',0,0,0, '合','吉','吊','吋','同','名','后','吏', */
	/* 5410 */ 0xc5c7,0xb8fe,0,0x8fb4e5,0,0,0,0, 0,0,0x8fb4e6,0xb7af,0,0xd2e7,0,0xb6e3, /* '吐','向',0,'吓',0,0,0,0, 0,0,'吚','君',0,'吝',0,'吟', */
	/* 5420 */ 0xcbca,0x8fb4e7,0,0,0,0,0xc8dd,0x8fb4e8, 0x8fb4e9,0xd2e6,0x8fb4ea,0xb4de,0xd2e1,0xd2e2,0xd2e4,0x8fb4eb, /* '吠','吡',0,0,0,0,'否','吧', '吨','吩','吪','含','听','吭','吮','启', */
	/* 5430 */ 0,0x8fb4ec,0,0,0x8fb4ed,0x8fb4ee,0xd2e5,0, 0xb5db,0xbfe1,0,0xcaad,0xd2e3,0xd2df,0xb8e3,0, /* 0,'吱',0,0,'吴','吵','吶',0, '吸','吹',0,'吻','吼','吽','吾',0, */
	/* 5440 */ 0xd2e0,0,0xcfa4,0x8fb4ef,0x8fb4f0,0,0xcaf2,0x8fb4f1, 0xc4e8,0xb8e2,0xb9f0,0,0,0x8fb4f2,0xd2e8,0x8fb4f3, /* '呀',0,'呂','呃','呄',0,'呆','呇', '呈','呉','告',0,0,'呍','呎','呏', */
	/* 5450 */ 0,0xc6dd,0,0,0,0,0,0, 0,0,0,0,0,0,0x8fb4f4,0xd2ec, /* 0,'呑',0,0,0,0,0,0, 0,0,0,0,0,0,'呞','呟', */
	/* 5460 */ 0,0,0x8fb4f5,0,0x8fb4f6,0,0x8fb4f7,0x8fb4f8, 0xbcfe,0x8fb4f9,0xbcf6,0x8fb4fa,0,0x8fb4fb,0x8fb4fc,0, /* 0,0,'呢',0,'呤',0,'呦','呧', '周','呩','呪','呫',0,'呭','呮',0, */
	/* 5470 */ 0xd2ef,0xd2ed,0,0xcca3,0x8fb4fd,0xd2ea,0xd2f3,0xd2ee, 0,0,0,0xd2f1,0xb8c6,0xccbf,0,0x8fb4fe, /* '呰','呱',0,'味','呴','呵','呶','呷', 0,0,0,'呻','呼','命',0,'呿', */
	/* 5480 */ 0xd2f2,0x8fb5a1,0,0x8fb5a2,0xd2f4,0x8fb5a3,0xd2f6,0, 0x8fb5a4,0x8fb5a5,0x8ff4b5,0xbaf0,0xcfc2,0x8fb5a6,0xd2eb,0xd2e9, /* '咀','咁',0,'咃','咄','咅','咆',0, '咈','咉','咊','咋','和','咍','咎','咏', */
	/* 5490 */ 0xd2f5,0x8fb5a7,0xd2f0,0,0,0x8fb5a8,0x8fb5a9,0, 0,0,0,0,0x8fb5aa,0,0,0x8fb5ab, /* '咐','咑','咒',0,0,'咕','咖',0, 0,0,0,0,'咜',0,0,'咟', */
	/* 54a0 */ 0,0x8fb5ac,0xd2f8,0,0xd3a3,0xd2fa,0x8fb5ad,0x8fb5ae, 0xd2fe,0x8fb5af,0x8fb5b0,0xd3a1,0xd2fb,0x8fb5b1,0x8fb5b2,0xd3be, /* 0,'咡','咢',0,'咤','咥','咦','咧', '咨','咩','咪','咫','咬','咭','咮','咯', */
	/* 54b0 */ 0,0x8fb5b3,0xbae9,0xb3b1,0,0,0,0x8fb5b4, 0xd2f9,0x8fb5b5,0x8fb5b6,0x8fb5b7,0xd3a5,0xb0f6,0xd3a4,0x8fb5b8, /* 0,'咱','咲','咳',0,0,0,'咷', '咸','咹','咺','咻','咼','咽','咾','咿', */
	/* 54c0 */ 0xb0a5,0xc9ca,0xd3a2,0,0xd2fc,0,0x8fb5b9,0xd2f7, 0xd2fd,0xbac8,0x8fb5ba,0,0,0x8fb5bb,0x8fb5bc,0, /* '哀','品','哂',0,'哄',0,'哆','哇', '哈','哉','哊',0,0,'响','哎',0, */
	/* 54d0 */ 0,0,0,0,0,0,0,0, 0xd3a6,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '哘',0,0,0,0,0,0,0, */
	/* 54e0 */ 0x8fb5bd,0xb0f7,0xd3af,0,0,0xd3a7,0xd3a8,0, 0xbea5,0xcbe9,0x8fb5be,0,0x8fb5bf,0xd3ad,0xd3ac,0x8fb5c0, /* '哠','員','哢',0,0,'哥','哦',0, '哨','哩','哪',0,'哬','哭','哮','哯', */
	/* 54f0 */ 0,0,0xc5af,0,0,0,0x8fb5c1,0, 0,0,0xd3ae,0,0x8fb5c2,0xd3ab,0x8fb5c3,0x8fb5c4, /* 0,0,'哲',0,0,0,'哶',0, 0,0,'哺',0,'哼','哽','哾','哿', */
	/* 5500 */ 0x8fb5c5,0x8fb5c6,0,0,0xb1b4,0x8fb5c7,0xbab6,0xbfb0, 0x8fb5c8,0x8fb5c9,0,0,0x8fb5ca,0x8fb5cb,0x8fb5cc,0xd3a9, /* '唀','唁',0,0,'唄','唅','唆','唇', '唈','唉',0,0,'唌','唍','唎','唏', */
	/* 5510 */ 0xc5e2,0,0,0,0xd3aa,0x8fb5cd,0xb0a2,0, 0,0,0,0,0,0,0,0, /* '唐',0,0,0,'唔','唕','唖',0, 0,0,0,0,0,0,0,0, */
	/* 5520 */ 0,0,0,0,0,0,0,0, 0,0,0x8fb5ce,0x8fb5cf,0,0,0xd3b4,0xcda3, /* 0,0,0,0,0,0,0,0, 0,0,'唪','唫',0,0,'售','唯', */
	/* 5530 */ 0,0xbea7,0x8fb5d0,0xd3ba,0,0x8fb5d1,0x8fb5d2,0, 0xd3b9,0xd3b0,0,0x8fb5d3,0x8fb5d4,0x8fb5d5,0xc2c3,0, /* 0,'唱','唲','唳',0,'唵','唶',0, '唸','唹',0,'唻','唼','唽','唾',0, */
	/* 5540 */ 0xd3b1,0x8fb5d6,0,0,0xc2ef,0xd3b6,0xbea6,0x8fb5d7, 0,0x8fb5d8,0x8fb5d9,0,0xd3b3,0x8fb5da,0,0xcce4, /* '啀','啁',0,0,'啄','啅','商','啇', 0,'啉','啊',0,'啌','啍',0,'問', */
	/* 5550 */ 0x8fb5db,0x8fb5dc,0,0xb7bc,0,0,0xd3b7,0xd3b8, 0x8fb5dd,0,0x8fb5de,0x8fb5df,0xd3b5,0xd3bb,0x8fb5e0,0, /* '啐','啑',0,'啓',0,0,'啖','啗', '啘',0,'啚','啛','啜','啝','啞',0, */
	/* 5560 */ 0x8fb5e1,0x8fb5e2,0,0xd3b2,0x8fb5e3,0,0x8fb5e4,0, 0,0,0,0,0,0,0,0, /* '啠','啡',0,'啣','啤',0,'啦',0, 0,0,0,0,0,0,0,0, */
	/* 5570 */ 0,0,0,0,0,0,0,0, 0,0,0,0xd3c1,0xd3c6,0,0xd3c2,0x8fb5e5, /* 0,0,0,0,0,0,0,0, 0,0,0,'啻','啼',0,'啾','啿', */
	/* 5580 */ 0xd3bd,0x8fb5e6,0x8fb5e7,0xd3c7,0xc1b1,0,0x8fb5e8,0xd3c9, 0x8fb5e9,0xb9a2,0xd3bf,0xc3fd,0,0,0x8fb5ea,0x8fb5eb, /* '喀','喁','喂','喃','善',0,'喆','喇', '喈','喉','喊','喋',0,0,'喎','喏', */
	/* 5590 */ 0,0x8fb5ec,0x8fb5ed,0x8fb5ee,0x8fb5ef,0,0,0x8fb5f0, 0xd3c3,0xd3bc,0xb4ad,0,0xb4ee,0xb3e5,0xd3c4,0xd3c0, /* 0,'喑','喒','喓','喔',0,0,'喗', '喘','喙','喚',0,'喜','喝','喞','喟', */
	/* 55a0 */ 0,0,0,0x8fb5f1,0x8fb5f2,0,0,0xb7f6, 0xd3ca,0xd3c8,0xc1d3,0xb5ca,0xb6ac,0x8fb5f3,0xd3c5,0, /* 0,0,0,'喣','喤',0,0,'喧', '喨','喩','喪','喫','喬','喭','單',0, */
	/* 55b0 */ 0xb6f4,0,0x8fb5f4,0,0,0,0xb1c4,0, 0,0,0,0,0,0,0,0x8fb5f5, /* '喰',0,'喲',0,0,0,'営',0, 0,0,0,0,0,0,0,'喿', */
	/* 55c0 */ 0,0x8fb5f6,0,0x8fb5f7,0xd3ce,0xd3cc,0x8fb5f8,0xd4a7, 0,0x8fb5f9,0,0x8fb5fa,0x8fb5fb,0,0x8fb5fc,0, /* 0,'嗁',0,'嗃','嗄','嗅','嗆','嗇', 0,'嗉',0,'嗋','嗌',0,'嗎',0, */
	/* 55d0 */ 0,0x8fb5fd,0x8fb5fe,0x8fb6a1,0xd3d1,0,0,0x8fb6a2, 0x8fb6a3,0,0xd3cb,0x8fb6a4,0xd3cf,0,0x8fb6a5,0xd3cd, /* 0,'嗑','嗒','嗓','嗔',0,0,'嗗', '嗘',0,'嗚','嗛','嗜',0,'嗞','嗟', */
	/* 55e0 */ 0,0,0x8fb6a6,0xbbcc,0xd3d0,0,0,0, 0,0x8fb6a7,0,0,0,0,0,0, /* 0,0,'嗢','嗣','嗤',0,0,0, 0,'嗩',0,0,0,0,0,0, */
	/* 55f0 */ 0,0,0,0,0,0,0x8fb6a8,0xd3d3, 0,0xd3d8,0,0,0,0xd3d6,0xd3d5,0x8fb6a9, /* 0,0,0,0,0,0,'嗶','嗷', 0,'嗹',0,0,0,'嗽','嗾','嗿', */
	/* 5600 */ 0,0,0,0,0,0x8fb6aa,0xc3b2,0, 0x8fb6ab,0xb2c5,0x8fb6ac,0,0,0x8fb6ad,0x8fb6ae,0x8fb6af, /* 0,0,0,0,0,'嘅','嘆',0, '嘈','嘉','嘊',0,0,'嘍','嘎','嘏', */
	/* 5610 */ 0x8fb6b0,0x8fb6b1,0x8fb6b2,0,0xd3d2,0,0xd3d4,0xbea8, 0xb1b3,0x8fb6b3,0,0xd3d7,0,0,0,0, /* '嘐','嘑','嘒',0,'嘔',0,'嘖','嘗', '嘘','嘙',0,'嘛',0,0,0,0, */
	/* 5620 */ 0,0,0,0,0,0,0,0, 0,0xb2de,0,0,0x8fb6b4,0,0,0xd3e2, /* 0,0,0,0,0,0,0,0, 0,'嘩',0,0,'嘬',0,0,'嘯', */
	/* 5630 */ 0x8fb6b5,0xbefc,0xd3de,0x8fb6b6,0xd3dc,0x8fb6b7,0xd3dd,0x8fb6b8, 0xd3df,0x8fb6b9,0,0x8fb6ba,0x8fb6bb,0x8fb6bc,0,0x8fb6bd, /* '嘰','嘱','嘲','嘳','嘴','嘵','嘶','嘷', '嘸','嘹',0,'嘻','嘼','嘽',0,'嘿', */
	/* 5640 */ 0x8fb6be,0x8fb6bf,0xb1bd,0x8fb6c0,0x8fb6c1,0,0x8fb6c2,0, 0,0x8fb6c3,0,0x8fb6c4,0xc1b9,0x8fb6c5,0xd3d9,0x8fb6c6, /* '噀','噁','噂','噃','噄',0,'噆',0, 0,'噉',0,'噋','噌','噍','噎','噏', */
	/* 5650 */ 0xd3da,0,0,0,0x8fb6c7,0,0,0, 0,0,0,0xb3fa,0,0,0x8fb6c8,0, /* '噐',0,0,0,'噔',0,0,0, 0,0,0,'噛',0,0,'噞',0, */
	/* 5660 */ 0x8fb6c9,0x8fb6ca,0x8fb6cb,0x8fb6cc,0xd3e1,0,0x8fb6cd,0, 0xb4ef,0x8fb6ce,0xd3e4,0xd3e0,0xd3e3,0x8fb6cf,0,0x8fb6d0, /* '噠','噡','噢','噣','噤',0,'噦',0, '器','噩','噪','噫','噬','噭',0,'噯', */
	/* 5670 */ 0,0x8fb6d1,0x8fb6d2,0,0xcaae,0x8fb6d3,0,0, 0xc6d5,0,0xc8b8,0,0,0,0,0, /* 0,'噱','噲',0,'噴','噵',0,0, '噸',0,'噺',0,0,0,0,0, */
	/* 5680 */ 0xd3e6,0,0,0,0x8fb6d4,0x8fb6d5,0xd3e5,0xb3c5, 0x8fb6d6,0,0xd3e7,0x8fb6d7,0x8fb6d8,0,0,0xd3ea, /* '嚀',0,0,0,'嚄','嚅','嚆','嚇', '嚈',0,'嚊','嚋','嚌',0,0,'嚏', */
	/* 5690 */ 0,0,0,0,0xd3e9,0x8fb6d9,0,0, 0,0x8fb6da,0x8fb6db,0,0,0x8fb6dc,0x8fb6dd,0x8fb6de, /* 0,0,0,0,'嚔','嚕',0,0, 0,'嚙','嚚',0,0,'嚝','嚞','嚟', */
	/* 56a0 */ 0xd3e8,0,0xc7b9,0,0,0xd3eb,0x8fb6df,0x8fb6e0, 0x8fb6e1,0x8fb6e2,0,0x8fb6e3,0x8fb6e4,0x8fb6e5,0xd3ec,0, /* '嚠',0,'嚢',0,0,'嚥','嚦','嚧', '嚨','嚩',0,'嚫','嚬','嚭','嚮',0, */
	/* 56b0 */ 0,0x8fb6e6,0,0x8fb6e7,0xd3ee,0,0xd3ed,0x8fb6e8, 0,0,0,0,0xd3f0,0,0x8fb6e9,0, /* 0,'嚱',0,'嚳','嚴',0,'嚶','嚷', 0,0,0,0,'嚼',0,'嚾',0, */
	/* 56c0 */ 0xd3f3,0xd3f1,0xd3ef,0xd3f2,0,0x8fb6ea,0,0, 0xd3f4,0x8fb6eb,0x8fb6ec,0x8fb6ed,0x8fb6f0,0x8fb6f1,0xd3f5,0x8fb6ee, /* '囀','囁','囂','囃',0,'囅',0,0, '囈','囉','囊','囋','囌','囍','囎','囏', */
	/* 56d0 */ 0x8fb6ef,0xd3f6,0,0xd3f7,0,0,0,0xd3f8, 0xd1c5,0x8fb6f2,0xbcfc,0xbbcd,0x8fb6f3,0x8fb6f4,0xb2f3,0x8fb6f5, /* '囐','囑',0,'囓',0,0,0,'囗', '囘','囙','囚','四','囜','囝','回','囟', */
	/* 56e0 */ 0xb0f8,0x8fb6f6,0,0xc3c4,0x8fb6f7,0x8fb6f8,0x8fb6f9,0x8fb6fa, 0x8fb6fb,0,0,0x8fb6fd,0,0x8fb6fe,0xd3f9,0, /* '因','囡',0,'団','囤','囥','囦','囧', '囨',0,0,'囫',0,'园','囮',0, */
	/* 56f0 */ 0xbaa4,0x8fb6fc,0xb0cf,0xbfde,0,0,0x8fb7a1,0x8fb7a2, 0,0xd3fa,0xb8c7,0,0,0xb9f1,0,0xd3fc, /* '困','囱','囲','図',0,0,'囶','囷', 0,'囹','固',0,0,'国',0,'囿', */
	/* 5700 */ 0xd3fb,0x8fb7a3,0x8fb7a4,0xcae0,0xd3fd,0,0,0x8fb7a5, 0xd4a1,0xd3fe,0x8fb7a6,0xd4a2,0x8fb7a7,0xd4a3,0,0xb7f7, /* '圀','圁','圂','圃','圄',0,0,'圇', '圈','圉','圊','國','圌','圍',0,'圏', */
	/* 5710 */ 0,0x8fb7a8,0xb1e0,0xd4a4,0,0x8fb7a9,0xd4a6,0, 0xd4a5,0,0x8fb7aa,0x8fb7ab,0xd4a8,0x8fb7ac,0,0xc5da, /* 0,'圑','園','圓',0,'圕','圖',0, '團',0,'圚','圛','圜','圝',0,'土', */
	/* 5720 */ 0x8fb7ad,0,0x8fb7ae,0x8fb7af,0x8fb7b0,0x8fb7b1,0xd4a9,0xb0b5, 0xbadf,0x8fb7b2,0x8fb7b3,0,0x8fb7b4,0xb7bd,0x8fb7b5,0x8fb7b6, /* '圠',0,'圢','圣','圤','圥','圦','圧', '在','圩','圪',0,'圬','圭','圮','圯', */
	/* 5730 */ 0xc3cf,0,0,0x8fb7b7,0x8fb7b8,0,0,0xd4aa, 0xd4ab,0,0,0xd4ad,0,0x8fb7b9,0x8fb7ba,0x8fb7bb, /* '地',0,0,'圳','圴',0,0,'圷', '圸',0,0,'圻',0,'圽','圾','圿', */
	/* 5740 */ 0xd4ae,0,0xbae4,0,0,0x8fb7bc,0x8fb7bd,0xb6d1, 0,0,0xcbb7,0,0x8fb7be,0x8fb7bf,0xd4ac,0xd4af, /* '址',0,'坂',0,0,'坅','坆','均', 0,0,'坊',0,'坌','坍','坎','坏', */
	/* 5750 */ 0xbac1,0xb9a3,0x8fb7c0,0,0,0,0,0, 0,0x8ff4b6,0,0,0,0,0,0, /* '坐','坑','坒',0,0,0,0,0, 0,'坙',0,0,0,0,0,0, */
	/* 5760 */ 0,0xd4b3,0x8fb7c1,0,0xbaa5,0x8fb7c2,0xc3b3,0x8fb7c3, 0x8fb7c4,0xd4b0,0xc4da,0x8fb7c5,0,0x8fb7c6,0x8fb7c7,0x8fb7c8, /* 0,'坡','坢',0,'坤','坥','坦','坧', '坨','坩','坪','坫',0,'坭','坮','坯', */
	/* 5770 */ 0x8fb7c9,0x8fb7ca,0,0x8fb7cb,0x8fb7cc,0x8fb7cd,0,0x8fb7ce, 0,0x8fb7cf,0x8fb7d0,0x8fb7d1,0x8fb7d2,0,0x8fb7d3,0xd4b4, /* '坰','坱',0,'坳','坴','坵',0,'坷', 0,'坹','坺','坻','坼',0,'坾','坿', */
	/* 5780 */ 0,0x8fb7d4,0xbfe2,0x8fb7d5,0,0,0,0, 0xd4b2,0xd4b5,0,0xb7bf,0x8fb7d6,0,0,0, /* 0,'垁','垂','垃',0,0,0,0, '垈','垉',0,'型','垌',0,0,0, */
	/* 5790 */ 0,0,0,0xd4b6,0x8fb7d7,0x8fb7e0,0,0x8fb7d8, 0,0x8fb7d9,0x8fb7da,0,0x8fb7db,0x8fb7dc,0x8fb7dd,0x8fb7de, /* 0,0,0,'垓','垔','垕',0,'垗', 0,'垙','垚',0,'垜','垝','垞','垟', */
	/* 57a0 */ 0xd4b7,0x8fb7df,0xb9a4,0xb3c0,0xd4b9,0,0,0x8fb7e1, 0x8fb7e2,0x8fb7e3,0xd4ba,0,0x8fb7e4,0,0,0, /* '垠','垡','垢','垣','垤',0,0,'垧', '垨','垩','垪',0,'垬',0,0,0, */
	/* 57b0 */ 0xd4bb,0,0,0xd4b8,0,0,0,0, 0x8fb7e5,0,0,0,0,0x8fb7e6,0,0, /* '垰',0,0,'垳',0,0,0,0, '垸',0,0,0,0,'垽',0,0, */
	/* 57c0 */ 0xd4b1,0,0,0xd4bc,0,0,0xd4bd,0x8fb7e7, 0x8fb7e8,0,0,0xcbe4,0x8fb7e9,0,0xbeeb,0x8fb7ea, /* '埀',0,0,'埃',0,0,'埆','埇', '埈',0,0,'埋','埌',0,'城','埏', */
	/* 57d0 */ 0,0,0xd4bf,0xd4c0,0xd4be,0x8fb7eb,0xd4c2,0, 0,0,0,0,0xc7b8,0x8fb7ec,0x8fb7ed,0xb0e8, /* 0,0,'埒','埓','埔','埕','埖',0, 0,0,0,0,'埜','埝','埞','域', */
	/* 57e0 */ 0xc9d6,0x8fb7fe,0,0xd4c3,0x8fb7ee,0,0x8fb7ef,0x8fb7f0, 0,0x8fb7f1,0,0,0,0x8fb7f2,0,0, /* '埠','埡',0,'埣','埤',0,'埦','埧', 0,'埩',0,0,0,'埭',0,0, */
	/* 57f0 */ 0x8fb7f3,0,0,0,0xbefd,0x8fb7f4,0x8fb7f5,0xbcb9, 0x8fb7f6,0xc7dd,0xb4f0,0,0xbaeb,0x8fb7f7,0x8fb7f8,0x8fb7f9, /* '埰',0,0,0,'埴','埵','埶','執', '埸','培','基',0,'埼','埽','埾','埿', */
	/* 5800 */ 0xcbd9,0,0xc6b2,0x8fb7fa,0x8fb7fb,0xb7f8,0xc2cf,0, 0x8fb7fc,0x8fb7fd,0xd4c1,0xd4c4,0x8fb8a1,0x8fb8a2,0,0, /* '堀',0,'堂','堃','堄','堅','堆',0, '堈','堉','堊','堋','堌','堍',0,0, */
	/* 5810 */ 0,0,0,0,0,0xc2c4,0,0, 0,0xd4c5,0,0x8fb8a3,0,0xd4c6,0x8fb8a4,0x8fb8a5, /* 0,0,0,0,0,'堕',0,0, 0,'堙',0,'堛',0,'堝','堞','堟', */
	/* 5820 */ 0x8fb8a6,0xd4c8,0,0,0xc4e9,0,0x8fb8a7,0x8fb8a8, 0,0,0xb4ae,0,0,0x8fb8a9,0,0xf4a1, /* '堠','堡',0,0,'堤',0,'堦','堧', 0,0,'堪',0,0,'堭',0,'堯', */
	/* 5830 */ 0xb1e1,0xcaf3,0x8fb8aa,0,0xbeec,0xc5c8,0,0, 0,0x8fb8ab,0xbae6,0,0,0xd4ce,0,0x8fb8ac, /* '堰','報','堲',0,'場','堵',0,0, 0,'堹','堺',0,0,'堽',0,'堿', */
	/* 5840 */ 0xcabd,0xcedd,0,0,0,0,0,0, 0,0x8fb8ad,0xb2f4,0xd4ca,0x8fb8ae,0x8fb8af,0,0x8fb8b0, /* '塀','塁',0,0,0,0,0,0, 0,'塉','塊','塋','塌','塍',0,'塏', */
	/* 5850 */ 0x8fb8b1,0xc1ba,0xd4cd,0,0xc5e3,0x8fb8b2,0,0xc5c9, 0xc5e4,0xc8b9,0xc4cd,0,0,0,0xbac9,0x8fb8b3, /* '塐','塑','塒',0,'塔','塕',0,'塗', '塘','塙','塚',0,0,0,'塞','塟', */
	/* 5860 */ 0,0x8fb8b4,0xd4c9,0,0x8fb8b5,0,0,0x8fb8b6, 0x8fb8b7,0xb1f6,0,0xc5b6,0,0,0,0, /* 0,'塡','塢',0,'塤',0,0,'塧', '塨','塩',0,'填',0,0,0,0, */
	/* 5870 */ 0xd4cb,0,0xd4c7,0,0,0xbfd0,0,0, 0x8fb8b8,0xd4cf,0,0,0x8fb8b9,0,0xbdce,0x8fb8ba, /* '塰',0,'塲',0,0,'塵',0,0, '塸','塹',0,0,'塼',0,'塾','塿', */
	/* 5880 */ 0x8fb8bb,0x8fb8bc,0,0xb6ad,0,0xd4d0,0,0x8fb8bd, 0x8fb8be,0x8fb8bf,0x8fb8c0,0,0x8fb8c1,0x8fb8c2,0,0x8fb8c3, /* '墀','墁',0,'境',0,'墅',0,'墇', '墈','墉','墊',0,'墌','墍',0,'墏', */
	/* 5890 */ 0x8fb8c4,0,0,0xcae8,0x8fb8c5,0,0x8fb8c6,0xc1fd, 0,0,0,0,0xc4c6,0x8fb8c7,0x8ff4b9,0xd4d2, /* '墐',0,0,'墓','墔',0,'墖','増', 0,0,0,0,'墜','墝','增','墟', */
	/* 58a0 */ 0x8fb8c8,0x8fb8c9,0x8fb8ca,0,0,0,0x8fb8cb,0, 0xcbcf,0x8fb8cc,0,0xd4d3,0,0,0xd4d8,0, /* '墠','墡','墢',0,0,0,'墦',0, '墨','墩',0,'墫',0,0,'墮',0, */
	/* 58b0 */ 0,0x8fb8cd,0x8fb8ce,0xcaaf,0,0,0,0, 0xd4d7,0xd4d1,0xd4d4,0xd4d6,0x8fb8d0,0,0xbaa6,0, /* 0,'墱','墲','墳',0,0,0,0, '墸','墹','墺','墻','墼',0,'墾',0, */
	/* 58c0 */ 0,0xcac9,0x8fb8d1,0,0x8fb8cf,0xd4d9,0,0xc3c5, 0x8fb8d2,0,0xb2f5,0,0xbeed,0x8fb8d3,0x8fb8d4,0, /* 0,'壁','壂',0,'壄','壅',0,'壇', '壈',0,'壊',0,'壌','壍','壎',0, */
	/* 58d0 */ 0x8fb8d5,0xd4db,0x8fb8d6,0xd4da,0x8fb8d7,0xb9e8,0x8fb8d8,0xd4dc, 0xd4de,0xd4dd,0x8fb8d9,0,0xd4e0,0x8fb8da,0xd4d5,0xd4e2, /* '壐','壑','壒','壓','壔','壕','壖','壗', '壘','壙','壚',0,'壜','壝','壞','壟', */
	/* 58e0 */ 0,0x8fb8db,0x8fb8dc,0,0xd4e1,0xd4df,0,0, 0,0x8fb8dd,0,0xbbce,0xbfd1,0,0xc1d4,0xd4e3, /* 0,'壡','壢',0,'壤','壥',0,0, 0,'壩',0,'士','壬',0,'壮','壯', */
	/* 58f0 */ 0xc0bc,0xb0ed,0xc7e4,0x8fb8de,0,0,0,0xc4db, 0,0xd4e5,0xd4e4,0xd4e6,0xd4e7,0xd4e8,0,0, /* '声','壱','売','壳',0,0,0,'壷', 0,'壹','壺','壻','壼','壽',0,0, */
	/* 5900 */ 0,0,0xd4e9,0,0,0x8fb8df,0x8fb8e0,0, 0,0xcad1,0xd4ea,0x8fb8e1,0x8fb8e2,0,0,0xb2c6, /* 0,0,'夂',0,0,'夅','夆',0, 0,'変','夊','夋','夌',0,0,'夏', */
	/* 5910 */ 0xd4eb,0,0x8fb8e3,0x8fb8e4,0x8fb8e5,0xcdbc,0xb3b0,0, 0xd2c9,0xbdc8,0xc2bf,0xd4ec,0xcceb,0x8fb8e7,0,0, /* '夐',0,'夒','夓','夔','夕','外',0, '夘','夙','多','夛','夜','夝',0,0, */
	/* 5920 */ 0,0x8fb8e8,0xccb4,0x8fb8e9,0x8fb8ea,0xd4ee,0,0xc2e7, 0x8fb8eb,0xc5b7,0xc2c0,0xc9d7,0xd4ef,0xd4f0,0xb1fb,0x8fb8ec, /* 0,'夡','夢','夣','夤','夥',0,'大', '夨','天','太','夫','夬','夭','央','夯', */
	/* 5930 */ 0x8fb8ed,0xbcba,0xd4f1,0x8fb8ee,0,0x8fb8ef,0x8fb8f0,0xb0d0, 0xd4f2,0,0,0,0,0,0xd4f3,0x8fb8f1, /* '夰','失','夲','夳',0,'夵','夶','夷', '夸',0,0,0,0,0,'夾','夿', */
	/* 5940 */ 0,0,0,0x8fb8f2,0xb1e2,0,0x8fb8f3,0xb4f1, 0xc6e0,0xcaf4,0,0,0,0,0xd4f7,0xc1d5, /* 0,0,0,'奃','奄',0,'奆','奇', '奈','奉',0,0,0,0,'奎','奏', */
	/* 5950 */ 0xd4f6,0xb7c0,0x8fb8f4,0x8fb8f5,0xcbdb,0xd4f5,0,0xc5e5, 0xd4f9,0x8fb8f6,0xd4f8,0x8fb8f7,0,0x8fb8f8,0x8fb8f9,0x8fb8fa, /* '奐','契','奒','奓','奔','奕',0,'套', '奘','奙','奚','奛',0,'奝','奞','奟', */
	/* 5960 */ 0xd4fb,0x8fb8fb,0xd4fa,0x8fb8fc,0,0xb1fc,0,0xd4fc, 0xbea9,0xd4fe,0xc3a5,0x8fb8fd,0xd4fd,0x8fb8fe,0xcab3,0x8fb9a1, /* '奠','奡','奢','奣',0,'奥',0,'奧', '奨','奩','奪','奫','奬','奭','奮','奯', */
	/* 5970 */ 0,0,0x8fb9a2,0xbdf7,0xc5db,0x8fb9a3,0x8fb9a4,0, 0xd5a1,0x8fb9a5,0,0x8fb9a6,0x8fb9a7,0xb9a5,0,0, /* 0,0,'奲','女','奴','奵','奶',0, '奸','她',0,'奻','奼','好',0,0, */
	/* 5980 */ 0,0xd5a2,0xc7a1,0xc8de,0xccd1,0,0,0, 0,0,0xc7a5,0x8fb9a8,0x8fb9a9,0xd5ab,0x8fb9aa,0, /* 0,'妁','如','妃','妄',0,0,0, 0,0,'妊','妋','妌','妍','妎',0, */
	/* 5990 */ 0,0,0x8fb9ab,0xb5b8,0,0x8fb9ac,0xcdc5,0x8fb9ad, 0,0xccaf,0,0xd6ac,0,0xd5a3,0,0x8fb9ae, /* 0,0,'妒','妓',0,'妕','妖','妗', 0,'妙',0,'妛',0,'妝',0,'妟', */
	/* 59a0 */ 0,0,0,0xd5a6,0x8fb9af,0xc2c5,0,0x8fb9b0, 0xcbb8,0,0,0,0xc5ca,0x8fb9b1,0x8fb9b2,0x8fb9b3, /* 0,0,0,'妣','妤','妥',0,'妧', '妨',0,0,0,'妬','妭','妮','妯', */
	/* 59b0 */ 0x8fb9b4,0,0xd5a7,0x8fb9b5,0,0,0,0x8fb9b6, 0,0xcbe5,0x8fb9b7,0xbaca,0x8fb9b8,0,0xbeaa,0, /* '妰',0,'妲','妳',0,0,0,'妷', 0,'妹','妺','妻','妼',0,'妾',0, */
	/* 59c0 */ 0,0x8fb9b9,0,0x8fb9ba,0x8fb9bb,0,0xd5a8,0, 0x8fb9bc,0xbbd0,0x8fb9bd,0xbbcf,0,0x8fb9be,0,0, /* 0,'姁',0,'姃','姄',0,'姆',0, '姈','姉','姊','始',0,'姍',0,0, */
	/* 59d0 */ 0xb0b9,0xb8c8,0x8fb9bf,0xc0ab,0xb0d1,0,0,0, 0,0xd5ac,0xd5ad,0,0xd5aa,0x8fb9c0,0x8fb9c1,0x8fb9c2, /* '姐','姑','姒','姓','委',0,0,0, 0,'姙','姚',0,'姜','姝','姞','姟', */
	/* 59e0 */ 0,0,0,0x8fb9c3,0x8fb9c4,0xb1b8,0xb4af,0x8fb9c5, 0xd5a9,0,0xccc5,0xc9b1,0,0,0x8fb9c6,0x8fb9c7, /* 0,0,0,'姣','姤','姥','姦','姧', '姨',0,'姪','姫',0,0,'姮','姯', */
	/* 59f0 */ 0,0x8fb9c8,0x8fb9c9,0,0x8fb9ca,0,0xb0a8,0x8fb9cb, 0,0,0,0xb0f9,0,0,0,0xbbd1, /* 0,'姱','姲',0,'姴',0,'姶','姷', 0,0,0,'姻',0,0,0,'姿', */
	/* 5a00 */ 0x8fb9cc,0xb0d2,0,0xb0a3,0x8fb9cd,0,0,0, 0,0xd5b2,0,0,0x8fb9ce,0x8fb9cf,0x8fb9d0,0, /* '娀','威',0,'娃','娄',0,0,0, 0,'娉',0,0,'娌','娍','娎',0, */
	/* 5a10 */ 0,0xd5b0,0x8fb9d1,0x8fb9d2,0,0,0,0, 0xccbc,0,0xd5b3,0,0xd5b1,0,0x8fb9d3,0xd5af, /* 0,'娑','娒','娓',0,0,0,0, '娘',0,'娚',0,'娜',0,'娞','娟', */
	/* 5a20 */ 0xbfb1,0,0,0x8fb9d4,0x8fb9d5,0xd5ae,0,0x8fb9d6, 0x8fb9d7,0xcada,0x8fb9d8,0,0,0x8fb9d9,0,0xb8e4, /* '娠',0,0,'娣','娤','娥',0,'娧', '娨','娩','娪',0,0,'娭',0,'娯', */
	/* 5a30 */ 0x8fb9da,0,0,0,0,0xd5b7,0xd5b8,0, 0,0,0,0,0xbeab,0,0,0, /* '娰',0,0,0,0,'娵','娶',0, 0,0,0,0,'娼',0,0,0, */
	/* 5a40 */ 0xd5b4,0xcfac,0,0,0x8fb9db,0x8fb9dc,0xc7cc,0x8fb9dd, 0x8fb9de,0xd5b6,0,0,0x8fb9df,0,0,0, /* '婀','婁',0,0,'婄','婅','婆','婇', '婈','婉',0,0,'婌',0,0,0, */
	/* 5a50 */ 0x8fb9e0,0,0,0,0,0x8fb9e1,0,0, 0,0,0xbaa7,0,0,0,0x8fb9e2,0, /* '婐',0,0,0,0,'婕',0,0, 0,0,'婚',0,0,0,'婞',0, */
	/* 5a60 */ 0,0,0xd5b9,0x8fb9e3,0,0x8fb9e4,0xc9d8,0x8fb9e5, 0,0,0xd5ba,0,0xd5b5,0x8fb9e6,0,0, /* 0,0,'婢','婣',0,'婥','婦','婧', 0,0,'婪',0,'婬','婭',0,0, */
	/* 5a70 */ 0,0,0,0,0,0,0,0x8fb9e7, 0,0,0x8fb9e8,0x8fb9e9,0,0,0x8fb9ea,0xccbb, /* 0,0,0,0,0,0,0,'婷', 0,0,'婺','婻',0,0,'婾','婿', */
	/* 5a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0x8fb9eb,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'媋',0,0,0,0, */
	/* 5a90 */ 0x8fb9ec,0,0xc7de,0x8fb9ed,0,0,0x8fb9ee,0, 0,0x8fb9ef,0xd5bb,0xc9b2,0x8fb9f0,0,0x8fb9f1,0x8fb9f2, /* '媐',0,'媒','媓',0,0,'媖',0, 0,'媙','媚','媛','媜',0,'媞','媟', */
	/* 5aa0 */ 0x8fb9f3,0,0x8fb9f4,0,0,0,0,0x8fb9f5, 0,0,0,0,0x8fb9f6,0,0,0, /* '媠',0,'媢',0,0,0,0,'媧', 0,0,0,0,'媬',0,0,0, */
	/* 5ab0 */ 0,0x8fb9f7,0x8fb9f8,0x8fb9f9,0,0x8fb9fa,0,0, 0x8fb9fb,0,0x8fb9fc,0x8fb9fd,0xd5bc,0xd5c0,0xd5bd,0x8fb9fe, /* 0,'媱','媲','媳',0,'媵',0,0, '媸',0,'媺','媻','媼','媽','媾','媿', */
	/* 5ac0 */ 0,0xb2c7,0xd5bf,0,0x8fbaa1,0,0x8fbaa2,0, 0x8fbaa3,0xbcbb,0,0xd5be,0xb7f9,0,0,0x8fbaa4, /* 0,'嫁','嫂',0,'嫄',0,'嫆',0, '嫈','嫉',0,'嫋','嫌',0,0,'嫏', */
	/* 5ad0 */ 0xd5cc,0,0,0,0,0,0xd5c5,0xd5c2, 0,0,0x8fbaa5,0,0x8fbaa6,0,0,0, /* '嫐',0,0,0,0,0,'嫖','嫗', 0,0,'嫚',0,'嫜',0,0,0, */
	/* 5ae0 */ 0x8fbaa7,0xc3e4,0,0xd5c1,0,0x8fbaa8,0xd5c3,0, 0,0xd5c4,0x8fbaa9,0,0,0,0x8fbaaa,0, /* '嫠','嫡',0,'嫣',0,'嫥','嫦',0, 0,'嫩','嫪',0,0,0,'嫮',0, */
	/* 5af0 */ 0,0,0,0,0,0x8fbaab,0x8fbaac,0, 0,0,0xd5c6,0xd5c7,0,0x8fbaad,0,0, /* 0,0,0,0,0,'嫵','嫶',0, 0,0,'嫺','嫻',0,'嫽',0,0, */
	/* 5b00 */ 0x8fbaae,0x8fbaaf,0,0,0,0,0,0, 0x8fbab0,0xb4f2,0,0xd5c9,0xd5c8,0,0,0, /* '嬀','嬁',0,0,0,0,0,0, '嬈','嬉',0,'嬋','嬌',0,0,0, */
	/* 5b10 */ 0,0,0,0,0,0,0xd5ca,0x8fbab1, 0,0x8fbab3,0,0x8fbab4,0,0x8fbab5,0,0, /* 0,0,0,0,0,0,'嬖','嬗', 0,'嬙',0,'嬛',0,'嬝',0,0, */
	/* 5b20 */ 0,0x8fbab6,0xbeee,0,0,0x8fbab7,0,0, 0,0,0xd5cd,0,0xc4dc,0x8fbab8,0,0, /* 0,'嬡','嬢',0,0,'嬥',0,0, 0,0,'嬪',0,'嬬','嬭',0,0, */
	/* 5b30 */ 0xb1c5,0,0xd5cb,0,0x8fbab2,0,0xd5ce,0, 0x8fbab9,0,0,0,0,0,0xd5cf,0, /* '嬰',0,'嬲',0,'嬴',0,'嬶',0, '嬸',0,0,0,0,0,'嬾',0, */
	/* 5b40 */ 0xd5d2,0x8fbaba,0,0xd5d0,0,0xd5d1,0,0, 0,0,0,0x8fbabb,0x8fbabc,0,0,0, /* '孀','孁',0,'孃',0,'孅',0,0, 0,0,0,'孋','孌',0,0,0, */
	/* 5b50 */ 0xbbd2,0xd5d3,0x8fbabd,0,0xb9a6,0xd5d4,0x8fbabe,0xbbfa, 0xc2b8,0,0xd5d5,0xd5d6,0xbbda,0xb9a7,0x8fbabf,0xccd2, /* '子','孑','孒',0,'孔','孕','孖','字', '存',0,'孚','孛','孜','孝','孞','孟', */
	/* 5b60 */ 0,0,0,0xb5a8,0xb8c9,0xd5d7,0xb3d8,0, 0x8fbac0,0xd5d8,0,0xc2b9,0,0,0x8fbac1,0x8fbac2, /* 0,0,0,'季','孤','孥','学',0, '孨','孩',0,'孫',0,0,'孮','孯', */
	/* 5b70 */ 0xd5d9,0xd6a3,0,0xd5da,0,0xd5db,0,0, 0xd5dc,0,0xd5de,0,0x8fbac3,0x8fbac4,0x8fbac5,0x8fbac6, /* '孰','孱',0,'孳',0,'孵',0,0, '學',0,'孺',0,'孼','孽','孾','孿', */
	/* 5b80 */ 0xd5df,0x8fbac7,0,0xd5e0,0x8fbac8,0xc2f0,0x8fbac9,0xb1a7, 0xbce9,0xb0c2,0x8fbaca,0xc1d7,0xb4b0,0xbcb5,0x8fbacb,0xb9a8, /* '宀','宁',0,'它','宄','宅','宆','宇', '守','安','宊','宋','完','宍','宎','宏', */
	/* 5b90 */ 0x8fbacc,0x8fbacd,0,0x8fbace,0x8fbacf,0xc5e6,0x8fbad0,0xbda1, 0xb4b1,0xc3e8,0xc4ea,0xb0b8,0xb5b9,0xcaf5,0,0xbcc2, /* '宐','宑',0,'宓','宔','宕','宖','宗', '官','宙','定','宛','宜','宝',0,'実', */
	/* 5ba0 */ 0,0,0xb5d2,0xc0eb,0xbcbc,0xcda8,0xd5e1,0, 0x8fbad1,0x8fbad2,0,0,0x8fbad3,0x8fbad4,0xb5dc,0x8fbad5, /* 0,0,'客','宣','室','宥','宦',0, '宨','宩',0,0,'宬','宭','宮','宯', */
	/* 5bb0 */ 0xbacb,0x8fbad6,0x8fbad7,0xb3b2,0xb1e3,0xbeac,0xb2c8,0x8fbad8, 0xd5e2,0xcdc6,0x8fbad9,0,0x8fbada,0,0,0xbdc9, /* '宰','宱','宲','害','宴','宵','家','宷', '宸','容','宺',0,'宼',0,0,'宿', */
	/* 5bc0 */ 0x8fbadb,0x8fbadc,0xbce4,0xd5e3,0xb4f3,0xc6d2,0xcca9,0xd5e4, 0,0xd5e5,0,0,0xc9d9,0x8fbadd,0,0x8fbade, /* '寀','寁','寂','寃','寄','寅','密','寇', 0,'寉',0,0,'富','寍',0,'寏', */
	/* 5bd0 */ 0xd5e7,0,0xb4a8,0xb6f7,0xd5e6,0,0x8fbadf,0x8fbae0, 0x8fbae1,0x8fbae2,0x8fbae3,0xb4b2,0,0xbfb2,0xd5eb,0xbba1, /* '寐',0,'寒','寓','寔',0,'寖','寗', '寘','寙','寚','寛',0,'寝','寞','察', */
	/* 5be0 */ 0x8fbae4,0xb2c9,0xd5ea,0,0xd5e8,0xd5ec,0xd5e9,0xc7ab, 0xdccd,0xbfb3,0,0xd5ed,0x8ff4ba,0,0xcec0,0x8fbae5, /* '寠','寡','寢',0,'寤','寥','實','寧', '寨','審',0,'寫','寬',0,'寮','寯', */
	/* 5bf0 */ 0xd5ee,0x8fbae6,0,0xd5f0,0x8fbae7,0xc3fe,0xd5ef,0, 0xc0a3,0,0xbbfb,0,0,0x8fbae8,0xc2d0,0xbcf7, /* '寰','寱',0,'寳','寴','寵','寶',0, '寸',0,'寺',0,0,'寽','対','寿', */
	/* 5c00 */ 0,0xc9f5,0xc0ec,0,0xbccd,0xd5f1,0xbead,0xd5f2, 0xd5f3,0xb0d3,0xc2ba,0xbfd2,0x8fbae9,0xd5f4,0xc6b3,0xbeae, /* 0,'封','専',0,'射','尅','将','將', '專','尉','尊','尋','尌','對','導','小', */
	/* 5c10 */ 0,0xbeaf,0,0xd5f5,0,0,0xc0ed,0x8fbaea, 0,0,0xbeb0,0,0,0,0x8fbaeb,0x8fbaec, /* 0,'少',0,'尓',0,0,'尖','尗', 0,0,'尚',0,0,0,'尞','尟', */
	/* 5c20 */ 0xd5f6,0,0xd5f7,0x8fbaed,0xcce0,0,0x8fbaee,0, 0xd5f8,0x8fbaef,0,0x8fbaf0,0x8fbaf1,0xb6c6,0x8fbaf2,0, /* '尠',0,'尢','尣','尤',0,'尦',0, '尨','尩',0,'尫','尬','尭','尮',0, */
	/* 5c30 */ 0x8fbaf3,0xbda2,0x8fbaf4,0,0,0x8fbaf5,0x8fbaf6,0, 0xd5f9,0xd5fa,0xbcdc,0xbfac,0xc6f4,0xbfd4,0xc8f8,0xc7a2, /* '尰','就','尲',0,0,'尵','尶',0, '尸','尹','尺','尻','尼','尽','尾','尿', */
	/* 5c40 */ 0xb6c9,0xd5fb,0,0,0,0xb5ef,0xd5fc,0, 0xb6fe,0,0xc6cf,0xb2b0,0,0xbbd3,0xd5fd,0xd6a2, /* '局','屁',0,0,0,'居','屆',0, '屈',0,'届','屋',0,'屍','屎','屏', */
	/* 5c50 */ 0xd6a1,0xb6fd,0,0xd5fe,0,0xc5b8,0,0, 0,0x8fbaf7,0x8fbaf8,0,0x8fbaf9,0,0xc2b0,0, /* '屐','屑',0,'屓',0,'展',0,0, 0,'屙','屚',0,'屜',0,'属',0, */
	/* 5c60 */ 0xc5cb,0xbcc8,0x8fbafa,0x8fbafb,0xc1d8,0xcdfa,0,0x8fbafc, 0x8fbafd,0x8fbafe,0,0,0xd6a4,0x8fbba1,0xd6a5,0xc6d6, /* '屠','屡','屢','屣','層','履',0,'屧', '屨','屩',0,0,'屬','屭','屮','屯', */
	/* 5c70 */ 0x8fbba2,0xbbb3,0,0,0x8fbba3,0x8fbba4,0xd6a7,0, 0,0xd6a8,0x8fbba5,0x8fbba6,0x8fbba7,0x8fbba8,0,0, /* '屰','山',0,0,'屴','屵','屶',0, 0,'屹','屺','屻','屼','屽',0,0, */
	/* 5c80 */ 0,0,0,0,0,0,0,0x8fbba9, 0x8fbbaa,0,0x8fbbab,0,0xd6a9,0,0,0x8fbbac, /* 0,0,0,0,0,0,0,'岇', '岈',0,'岊',0,'岌',0,0,'岏', */
	/* 5c90 */ 0xb4f4,0xd6aa,0x8fbbad,0,0xd6ab,0,0,0, 0,0,0,0,0,0x8fbbae,0,0x8fbbaf, /* '岐','岑','岒',0,'岔',0,0,0, 0,0,0,0,0,'岝',0,'岟', */
	/* 5ca0 */ 0x8fbbb0,0xb2ac,0x8fbbb1,0x8fbbb2,0,0,0x8fbbb3,0, 0xc1bb,0xb4e4,0x8fbbb4,0xd6ad,0xcca8,0,0,0, /* '岠','岡','岢','岣',0,0,'岦',0, '岨','岩','岪','岫','岬',0,0,0, */
	/* 5cb0 */ 0,0xc2d2,0x8fbbb5,0xb3d9,0x8fbbb6,0x8fbbb7,0xd6af,0xd6b1, 0xb4df,0,0x8fbbb8,0xd6ae,0xd6b0,0,0xd6b3,0, /* 0,'岱','岲','岳','岴','岵','岶','岷', '岸',0,'岺','岻','岼',0,'岾',0, */
	/* 5cc0 */ 0,0,0,0,0,0xd6b2,0,0xd6b4, 0,0x8fbbb9,0,0x8fbbba,0,0,0,0, /* 0,0,0,0,0,'峅',0,'峇', 0,'峉',0,'峋',0,0,0,0, */
	/* 5cd0 */ 0,0,0x8fbbbb,0,0,0,0,0x8fbbbd, 0,0xd6b5,0,0,0,0x8fbbbc,0,0, /* 0,0,'峒',0,0,0,0,'峗', 0,'峙',0,0,0,'峝',0,0, */
	/* 5ce0 */ 0xc6bd,0xb6ae,0,0,0,0,0,0, 0xb2e5,0xd6b6,0xd6bb,0,0,0xd6b9,0x8fbbbe,0xcaf7, /* '峠','峡',0,0,0,0,0,0, '峨','峩','峪',0,0,'峭','峮','峯', */
	/* 5cf0 */ 0xcaf6,0x8fbbbf,0x8fbbc0,0,0x8fbbc1,0x8ff4bb,0xc5e7,0, 0,0,0xd6b8,0xbdd4,0,0xd6b7,0,0, /* '峰','峱','峲',0,'峴','峵','島',0, 0,0,'峺','峻',0,'峽',0,0, */
	/* 5d00 */ 0,0x8fbbc2,0,0,0,0,0x8fbbc3,0xbff2, 0,0,0,0xd6bc,0,0x8fbbc4,0xbaea,0, /* 0,'崁',0,0,0,0,'崆','崇', 0,0,0,'崋',0,'崍','崎',0, */
	/* 5d10 */ 0,0xd6c2,0x8fbbc5,0,0xd6c3,0xd6bd,0xb3b3,0xd6be, 0xd6c7,0xd6c6,0xd6c5,0xd6c1,0,0,0,0xd6c0, /* 0,'崑','崒',0,'崔','崕','崖','崗', '崘','崙','崚','崛',0,0,0,'崟', */
	/* 5d20 */ 0,0,0xd6c4,0x8fbbc7,0x8fbbc8,0,0x8fbbc9,0x8fbbca, 0,0xcaf8,0,0x8fbbc6,0,0,0,0, /* 0,0,'崢','崣','崤',0,'崦','崧', 0,'崩',0,'崫',0,0,0,0, */
	/* 5d30 */ 0,0x8fbbcb,0,0,0x8fbbcc,0,0,0, 0,0x8fbbcd,0,0,0,0x8fbbce,0,0x8fbbcf, /* 0,'崱',0,0,'崴',0,0,0, 0,'崹',0,0,0,'崽',0,'崿', */
	/* 5d40 */ 0,0,0x8fbbd0,0x8fbbd1,0,0,0x8fbbd2,0, 0x8fbbd3,0,0x8fbbd7,0xd6cb,0xd6c8,0,0xd6ca,0, /* 0,0,'嵂','嵃',0,0,'嵆',0, '嵈',0,'嵊','嵋','嵌',0,'嵎',0, */
	/* 5d50 */ 0xcdf2,0x8fbbd5,0xd6c9,0x8ff4bc,0,0x8fbbd4,0,0, 0,0x8fbbd6,0,0,0xd6bf,0,0,0x8fbbd8, /* '嵐','嵑','嵒','嵓',0,'嵕',0,0, 0,'嵙',0,0,'嵜',0,0,'嵟', */
	/* 5d60 */ 0x8fbbd9,0x8fbbda,0x8fbbdb,0,0x8fbbdc,0,0,0, 0,0xbff3,0x8fbbdd,0,0xd6cc,0x8fbbde,0,0xbab7, /* '嵠','嵡','嵢',0,'嵤',0,0,0, 0,'嵩','嵪',0,'嵬','嵭',0,'嵯', */
	/* 5d70 */ 0x8fbbdf,0,0,0xd6cd,0,0,0xd6ce,0, 0,0x8fbbe0,0x8fbbe1,0,0,0,0x8fbbe2,0x8fbbe3, /* '嵰',0,0,'嵳',0,0,'嵶',0, 0,'嵹','嵺',0,0,0,'嵾','嵿', */
	/* 5d80 */ 0,0x8fbbe4,0xd6d1,0x8fbbe5,0xd6d0,0,0,0xd6cf, 0x8fbbe6,0,0x8fbbe7,0xc5e8,0xd6ba,0,0,0, /* 0,'嶁','嶂','嶃','嶄',0,0,'嶇', '嶈',0,'嶊','嶋','嶌',0,0,0, */
	/* 5d90 */ 0xd6d7,0,0x8fbbe8,0x8fbbe9,0x8fbbea,0x8fbbeb,0,0, 0,0x8fbbec,0,0x8fbbed,0,0xd6d3,0,0x8fbbee, /* '嶐',0,'嶒','嶓','嶔','嶕',0,0, 0,'嶙',0,'嶛',0,'嶝',0,'嶟', */
	/* 5da0 */ 0x8fbbef,0,0xd6d2,0,0,0,0,0x8fbbf0, 0,0,0,0x8fbbf1,0xd6d4,0,0xd6d5,0, /* '嶠',0,'嶢',0,0,0,0,'嶧', 0,0,0,'嶫','嶬',0,'嶮',0, */
	/* 5db0 */ 0x8fbbf2,0,0x8fe6f4,0,0x8fbbf3,0,0,0xd6d8, 0x8fbbf4,0x8fbbf5,0xcee6,0,0xd6d9,0xd6d6,0,0, /* '嶰',0,'嶲',0,'嶴',0,0,'嶷', '嶸','嶹','嶺',0,'嶼','嶽',0,0, */
	/* 5dc0 */ 0,0,0,0x8fbbf6,0,0,0,0x8fbbf7, 0,0xd6da,0,0x8fbbf8,0xb4e0,0xd6db,0x8fbbfa,0, /* 0,0,0,'巃',0,0,0,'巇', 0,'巉',0,'巋','巌','巍','巎',0, */
	/* 5dd0 */ 0x8fbbf9,0,0xd6dd,0xd6dc,0,0,0xd6de,0, 0x8fbbfb,0x8fbbfc,0,0xd6df,0,0xc0ee,0xbda3,0, /* '巐',0,'巒','巓',0,0,'巖',0, '巘','巙',0,'巛',0,'川','州',0, */
	/* 5de0 */ 0x8fbbfd,0xbde4,0,0xc1e3,0x8fbbfe,0xb9a9,0xbab8,0xb9aa, 0xb5f0,0x8fbca1,0,0xd6e0,0,0,0xbab9,0, /* '巠','巡',0,'巣','巤','工','左','巧', '巨','巩',0,'巫',0,0,'差',0, */
	/* 5df0 */ 0,0xb8ca,0xd6e1,0xcca6,0xc7c3,0xd6e2,0,0xb9ab, 0x8fbca2,0x8fbca3,0,0xb4ac,0,0xc3a7,0xb6d2,0, /* 0,'己','已','巳','巴','巵',0,'巷', '巸','巹',0,'巻',0,'巽','巾',0, */
	/* 5e00 */ 0x8fbca4,0,0xbbd4,0xc9db,0,0,0xc8c1,0x8fbca5, 0,0,0,0xd6e3,0xb4f5,0x8fbca6,0,0, /* '帀',0,'市','布',0,0,'帆','帇', 0,0,0,'帋','希','帍',0,0, */
	/* 5e10 */ 0,0xd6e6,0x8fbca7,0,0x8fbca8,0x8fbca9,0xc4a1,0, 0x8fbcaa,0xd6e5,0xd6e4,0xd6e7,0,0xc4eb,0,0x8fbcab, /* 0,'帑','帒',0,'帔','帕','帖',0, '帘','帙','帚','帛',0,'帝',0,'帟', */
	/* 5e20 */ 0x8fbcac,0,0,0,0,0xbfe3,0,0, 0x8fbcae,0,0,0xbbd5,0,0xc0ca,0x8fbcad,0xc2d3, /* '帠',0,0,0,0,'帥',0,0, '帨',0,0,'師',0,'席','帮','帯', */
	/* 5e30 */ 0xb5a2,0,0x8fbcaf,0xc4a2,0,0x8fbcb0,0xd6e8,0xd6e9, 0xbeef,0,0,0,0,0xcbb9,0x8fbcb1,0, /* '帰',0,'帲','帳',0,'帵','帶','帷', '常',0,0,0,0,'帽','帾',0, */
	/* 5e40 */ 0xd6ec,0,0,0xd6eb,0xd6ea,0xc9fd,0,0xd6f3, 0,0x8fbcb4,0,0x8fbcb2,0xcbda,0,0xd6ed,0, /* '幀',0,0,'幃','幄','幅',0,'幇', 0,'幉',0,'幋','幌',0,'幎',0, */
	/* 5e50 */ 0x8fbcb3,0x8fbcb5,0,0,0xd6ef,0xcbeb,0x8fbcb6,0xd6ee, 0x8fbcb7,0,0,0x8fbcb8,0x8fbcb9,0,0x8fbcba,0xd6f0, /* '幐','幑',0,0,'幔','幕','幖','幗', '幘',0,0,'幛','幜',0,'幞','幟', */
	/* 5e60 */ 0,0xc8a8,0xd6f1,0xcabe,0xd6f2,0,0,0, 0x8fbcbb,0,0x8fbcbc,0x8fbcbd,0x8fbcbe,0x8fbcbf,0x8fbcc0,0, /* 0,'幡','幢','幣','幤',0,0,0, '幨',0,'幪','幫','幬','幭','幮',0, */
	/* 5e70 */ 0x8fbcc1,0,0xb4b3,0xcabf,0xc7af,0xd6f4,0xd6f5,0, 0xb9ac,0xb4b4,0xd6f6,0xb8b8,0xcdc4,0xcda9,0xb4f6,0xd6f8, /* '幰',0,'干','平','年','幵','并',0, '幸','幹','幺','幻','幼','幽','幾','广', */
	/* 5e80 */ 0x8fbcc2,0xc4a3,0,0xb9ad,0xbeb1,0,0,0xc8df, 0,0,0xbeb2,0x8fbcc3,0,0,0x8fbcc4,0xbdf8, /* '庀','庁',0,'広','庄',0,0,'庇', 0,0,'床','庋',0,0,'庎','序', */
	/* 5e90 */ 0,0,0,0,0,0xc4ec,0xcaf9,0xc5b9, 0,0,0xb9ae,0,0xc9dc,0,0,0, /* 0,0,0,0,0,'底','庖','店', 0,0,'庚',0,'府',0,0,0, */
	/* 5ea0 */ 0xd6f9,0,0x8fbcc5,0,0x8fbcc6,0x8fbcc7,0xc5d9,0xbac2, 0x8fbcc8,0,0x8fbcc9,0xb8cb,0x8fbcca,0xc4ed,0,0, /* '庠',0,'庢',0,'庤','庥','度','座', '庨',0,'庪','庫','庬','庭',0,0, */
	/* 5eb0 */ 0,0x8fbccb,0,0x8fbccc,0,0xb0c3,0xbdee,0xb9af, 0xcdc7,0,0,0,0,0x8fbccd,0x8fbcce,0x8fbccf, /* 0,'庱',0,'庳',0,'庵','庶','康', '庸',0,0,0,0,'庽','庾','庿', */
	/* 5ec0 */ 0,0xd6fa,0xd6fb,0xc7d1,0,0,0x8fbcd0,0, 0xd6fc,0xcef7,0xcfad,0x8fbcd2,0x8fbcd1,0,0x8fbcd3,0xd6fe, /* 0,'廁','廂','廃',0,0,'廆',0, '廈','廉','廊','廋','廌',0,'廎','廏', */
	/* 5ed0 */ 0xd6fd,0x8fbcd4,0x8fbcd5,0xb3c7,0x8fbcd6,0x8fbcd7,0xd7a1,0, 0,0,0xd7a4,0xd7a5,0x8fbcd8,0xd7a3,0x8fbcd9,0xc9c0, /* '廐','廑','廒','廓','廔','廕','廖',0, 0,0,'廚','廛','廜','廝','廞','廟', */
	/* 5ee0 */ 0xbeb3,0xd7a7,0xd7a6,0xd7a2,0,0x8fbcda,0,0, 0xd7a8,0xd7a9,0,0x8fbcdb,0xd7aa,0,0,0, /* '廠','廡','廢','廣',0,'廥',0,0, '廨','廩',0,'廫','廬',0,0,0, */
	/* 5ef0 */ 0xd7ad,0xd7ab,0,0xd7ac,0xd7ae,0,0xb1e4,0xc4ee, 0xd7af,0,0xb7fa,0xb2f6,0xc7b6,0,0xd7b0,0xc6fb, /* '廰','廱',0,'廳','廴',0,'延','廷', '廸',0,'建','廻','廼',0,'廾','廿', */
	/* 5f00 */ 0,0xcadb,0x8fbcdc,0xd7b1,0xcfae,0,0x8fbcdd,0x8fbcde, 0x8fbcdf,0xd7b2,0xcac0,0xd7b5,0xd0a1,0xd0b1,0x8fbce0,0xbcb0, /* 0,'弁','异','弃','弄',0,'弆','弇', '弈','弉','弊','弋','弌','弍','弎','式', */
	/* 5f10 */ 0xc6f5,0xd7b6,0,0xb5dd,0xc4a4,0xb0fa,0xd7b7,0xcaa6, 0xb9b0,0x8fbce1,0,0xc3d0,0x8fbce2,0x8fbce3,0,0xc4ef, /* '弐','弑',0,'弓','弔','引','弖','弗', '弘','弙',0,'弛','弜','弝',0,'弟', */
	/* 5f20 */ 0,0x8fbce4,0x8fbce5,0x8fbce6,0x8fbce7,0xccef,0xb8b9,0xb8cc, 0x8fbce8,0xd7b8,0,0x8fbce9,0x8fbcea,0xd7b9,0x8fbceb,0xd7bf, /* 0,'弡','弢','弣','弤','弥','弦','弧', '弨','弩',0,'弫','弬','弭','弮','弯', */
	/* 5f30 */ 0x8fbcec,0xbce5,0,0,0x8fbced,0xc4a5,0x8fbcee,0xb6af, 0xd7ba,0,0,0x8fbcef,0xc9ab,0x8fbcf0,0xc3c6,0x8fbcf1, /* '弰','弱',0,0,'弴','張','弶','強', '弸',0,0,'弻','弼','弽','弾','弿', */
	/* 5f40 */ 0x8fbcf2,0xd7bb,0,0,0x8fbcf3,0x8fbcf4,0,0x8fbcf5, 0xd7bc,0,0xb6b0,0,0xd7bd,0x8fbcf6,0xd7be,0, /* '彀','彁',0,0,'彄','彅',0,'彇', '彈',0,'彊',0,'彌','彍','彎',0, */
	/* 5f50 */ 0x8fbcf7,0xd7c0,0,0xc5f6,0x8fbcf8,0,0xd7c1,0xd7c2, 0x8fbcf9,0xd7c3,0,0x8fbcfa,0xd7b4,0xd7b3,0,0, /* '彐','彑',0,'当','彔',0,'彖','彗', '彘','彙',0,'彛','彜','彝',0,0, */
	/* 5f60 */ 0x8fbcfb,0xd7c4,0xb7c1,0x8fbcfc,0x8fbcfd,0,0xc9a7,0x8fbcfe, 0,0xbacc,0xc9b7,0xc4a6,0xc9cb,0xd7c5,0,0x8fbda1, /* '彠','彡','形','彣','彤',0,'彦','彧', 0,'彩','彪','彫','彬','彭',0,'彯', */
	/* 5f70 */ 0xbeb4,0xb1c6,0x8fbda2,0xd7c6,0x8fbda3,0x8fbda4,0,0xd7c7, 0x8fbda5,0xccf2,0x8fbda6,0,0xc8e0,0x8fbda7,0x8fbda8,0xd7ca, /* '彰','影','彲','彳','彴','彵',0,'彷', '彸','役','彺',0,'彼','彽','彾','彿', */
	/* 5f80 */ 0xb1fd,0xc0ac,0xd7c9,0xd7c8,0xb7c2,0xc2d4,0,0xd7ce, 0xd7cc,0x8fbda9,0xd7cb,0xcea7,0xb8e5,0x8fbdaa,0,0x8fbdab, /* '往','征','徂','徃','径','待',0,'徇', '很','徉','徊','律','後','徍',0,'徏', */
	/* 5f90 */ 0xbdf9,0xd7cd,0xc5cc,0xbdbe,0,0,0x8fbdac,0xc6c0, 0xd7d1,0xd7d0,0,0,0x8fbdad,0x8fbdae,0xd7cf,0, /* '徐','徑','徒','従',0,0,'徖','得', '徘','徙',0,0,'徜','徝','從',0, */
	/* 5fa0 */ 0xd7d2,0xb8e6,0x8fbdaf,0,0x8fbdb2,0,0,0x8fbdb0, 0xd7d3,0xc9fc,0xbddb,0x8fbdb1,0x8fbdb3,0xd7d4,0xc8f9,0x8fbdb4, /* '徠','御','徢',0,'徤',0,0,'徧', '徨','復','循','徫','徬','徭','微','徯', */
	/* 5fb0 */ 0x8fbdb5,0x8fbdb6,0,0xc6c1,0xc4a7,0,0,0x8ff4be, 0x8fbdb7,0xc5b0,0,0,0xd7d5,0xb5ab,0,0, /* '徰','徱',0,'徳','徴',0,0,'德', '徸','徹',0,0,'徼','徽',0,0, */
	/* 5fc0 */ 0,0,0,0xbfb4,0x8fbdb8,0xc9ac,0,0x8fbdb9, 0x8fbdba,0x8fbdbb,0,0x8fbdbc,0xb4f7,0xc7a6,0,0, /* 0,0,0,'心','忄','必',0,'忇', '忈','忉',0,'忋','忌','忍',0,0, */
	/* 5fd0 */ 0x8fbdbd,0x8fbdbe,0x8fbdbf,0x8fbdc0,0x8fbdc1,0,0xd7d6,0xbbd6, 0xcbba,0xcbbb,0,0,0xb1fe,0xd7db,0x8fbdc2,0, /* '忐','忑','忒','忓','忔',0,'忖','志', '忘','忙',0,0,'応','忝','忞',0, */
	/* 5fe0 */ 0xc3e9,0x8fbdc3,0x8fbdc4,0,0xd7d8,0,0,0, 0x8fbdc5,0x8fbdc6,0x8fbdc7,0xb2f7,0x8fbdc8,0x8fbdc9,0x8fbdca,0x8fbdcb, /* '忠','忡','忢',0,'忤',0,0,0, '忨','忩','忪','快','忬','忭','忮','忯', */
	/* 5ff0 */ 0xd8ad,0xd7da,0x8fbdcc,0x8fbdcd,0,0xc7b0,0x8fbdce,0, 0xd7d9,0,0x8fbdcf,0xd7d7,0x8fbdd0,0xb9fa,0,0xd7dd, /* '忰','忱','忲','忳',0,'念','忶',0, '忸',0,'忺','忻','忼','忽',0,'忿', */
	/* 6000 */ 0,0,0,0,0,0,0,0x8fbdd1, 0,0,0x8fbdd2,0,0,0x8fbdd3,0xd7e3,0xd7e9, /* 0,0,0,0,0,0,0,'怇', 0,0,'怊',0,0,'怍','怎','怏', */
	/* 6010 */ 0xd7e1,0,0xc5dc,0x8fbdd4,0x8fbdd5,0xd7e6,0xc9dd,0x8fbdd6, 0x8fbdd7,0xd7e0,0x8fbdd8,0xd7e5,0xcee7,0xbbd7,0,0x8fbdd9, /* '怐',0,'怒','怓','怔','怕','怖','怗', '怘','怙','怚','怛','怜','思',0,'怟', */
	/* 6020 */ 0xc2d5,0xd7de,0,0,0x8fbdda,0xb5de,0xd7e8,0xc0ad, 0xb1e5,0xd7e2,0xb2f8,0xd7e7,0,0x8fbddb,0,0xb6b1, /* '怠','怡',0,0,'怤','急','怦','性', '怨','怩','怪','怫',0,'怭',0,'怯', */
	/* 6030 */ 0,0xd7e4,0,0x8fbddc,0,0x8fbddd,0,0, 0,0,0xd7ea,0,0,0,0,0, /* 0,'怱',0,'怳',0,'怵',0,0, 0,0,'怺',0,0,0,0,0, */
	/* 6040 */ 0x8fbdde,0xd7ec,0xd7f6,0xd7f4,0,0,0xd7f1,0x8fbddf, 0x8fbde0,0x8fbde1,0xd7f0,0xcef8,0x8fbde2,0xd7f2,0,0, /* '恀','恁','恂','恃',0,0,'恆','恇', '恈','恉','恊','恋','恌','恍',0,0, */
	/* 6050 */ 0xb6b2,0x8fbde3,0xb9b1,0,0x8fbde4,0xbdfa,0x8fbde5,0x8fbde6, 0,0xd7f9,0xd7eb,0,0,0x8fbde7,0,0xd7ef, /* '恐','恑','恒',0,'恔','恕','恖','恗', 0,'恙','恚',0,0,'恝',0,'恟', */
	/* 6060 */ 0xd7df,0x8fbde8,0xb2fa,0xd7f3,0xd7f5,0xc3d1,0,0x8fbde9, 0xbaa8,0xb2b8,0xd7ed,0xd7f8,0xd7f7,0xb6b3,0,0xc2a9, /* '恠','恡','恢','恣','恤','恥',0,'恧', '恨','恩','恪','恫','恬','恭',0,'息', */
	/* 6070 */ 0xb3e6,0x8fbdea,0,0,0,0xb7c3,0,0xd7ee, 0,0,0,0,0,0,0x8fbdeb,0x8fbdec, /* '恰','恱',0,0,0,'恵',0,'恷', 0,0,0,0,0,0,'恾','恿', */
	/* 6080 */ 0,0xd7fa,0x8fbded,0xd7fd,0xd8a1,0x8ff4bf,0x8fbdee,0, 0x8fbdef,0xbcbd,0x8fbdf0,0xd8a7,0xc4f0,0xd7fb,0x8fbdf1,0, /* 0,'悁','悂','悃','悄','悅','悆',0, '悈','悉','悊','悋','悌','悍','悎',0, */
	/* 6090 */ 0,0x8fbdf2,0xd8a5,0x8fbdf3,0xb2f9,0x8fbdf4,0xd8a3,0xd8a4, 0x8fbdf5,0,0xd7fe,0xd8a2,0,0x8fbdf6,0x8fbdf7,0xb8e7, /* 0,'悑','悒','悓','悔','悕','悖','悗', '悘',0,'悚','悛',0,'悝','悞','悟', */
	/* 60a0 */ 0xcdaa,0,0x8fbdf8,0xb4b5,0x8fbdf9,0x8fbdfa,0xb1d9,0xd8a6, 0x8fbdfb,0xc7ba,0xb0ad,0,0,0,0,0, /* '悠',0,'悢','患','悤','悥','悦','悧', '您','悩','悪',0,0,0,0,0, */
	/* 60b0 */ 0x8fbdfc,0x8fbdfd,0xc8e1,0xd7dc,0xd8ac,0xd8b0,0xcce5,0x8fbdfe, 0xd8a9,0,0,0x8fbea1,0xc5e9,0xd8ae,0x8fbea2,0, /* '悰','悱','悲','悳','悴','悵','悶','悷', '悸',0,0,'悻','悼','悽','悾',0, */
	/* 60c0 */ 0,0,0x8fbea3,0,0x8fbea4,0xbef0,0xd8af,0xc6d7, 0x8fbea5,0x8fbea6,0x8fbea7,0x8fbea8,0,0,0x8fbea9,0x8fbeaa, /* 0,0,'惂',0,'惄','情','惆','惇', '惈','惉','惊','惋',0,0,'惎','惏', */
	/* 60d0 */ 0,0xcfc7,0,0xd8ab,0x8fbeab,0x8fbeac,0,0, 0xd8b1,0x8fbead,0xb9fb,0x8fbeae,0xc0cb,0x8fbeaf,0x8fbeb0,0xb0d4, /* 0,'惑',0,'惓','惔','惕',0,0, '惘','惙','惚','惛','惜','惝','惞','惟', */
	/* 60e0 */ 0xd8aa,0xd8a8,0x8fbeb1,0xc1da,0,0x8fbeb2,0,0xd7fc, 0xbbb4,0,0,0,0,0,0,0, /* '惠','惡','惢','惣',0,'惥',0,'惧', '惨',0,0,0,0,0,0,0, */
	/* 60f0 */ 0xc2c6,0xd8bd,0x8fbeb3,0xc1db,0xd8b8,0x8fbeb4,0xd8b5,0xd8b6, 0x8fbeb5,0xbce6,0xd8b9,0xd8bc,0x8fbeb6,0x8fbeb7,0,0, /* '惰','惱','惲','想','惴','惵','惶','惷', '惸','惹','惺','惻','惼','惽',0,0, */
	/* 6100 */ 0xd8b7,0xbda5,0x8fbeb8,0xd8ba,0,0,0xd8b4,0x8fbeb9, 0xccfc,0xccfb,0x8fbeba,0,0x8fbebb,0xd8be,0xd8bf,0xb0d5, /* '愀','愁','愂','愃',0,0,'愆','愇', '愈','愉','愊',0,'愌','愍','愎','意', */
	/* 6110 */ 0x8fbebc,0x8fbebd,0x8fbebe,0x8fbebf,0x8fbec0,0xd8b3,0x8fbec1,0x8fbec2, 0,0x8fbec3,0xb6f2,0xb0a6,0x8fbec4,0,0x8fbec5,0xb4b6, /* '愐','愑','愒','愓','愔','愕','愖','愗', 0,'愙','愚','愛','愜',0,'愞','感', */
	/* 6120 */ 0x8ff4c0,0xd8bb,0x8fbec6,0,0,0,0,0xd8c3, 0xd8c2,0,0x8fbec7,0x8fbec8,0xd8c7,0,0,0, /* '愠','愡','愢',0,0,0,0,'愧', '愨',0,'愪','愫','愬',0,0,0, */
	/* 6130 */ 0x8fbec9,0x8fbeca,0,0,0xd8c8,0x8fbecb,0x8fbecc,0x8fbecd, 0,0x8fbece,0,0,0xd8c6,0xd8c9,0xd8c1,0xd8c5, /* '愰','愱',0,0,'愴','愵','愶','愷', 0,'愹',0,0,'愼','愽','愾','愿', */
	/* 6140 */ 0,0x8fbecf,0xd8ca,0,0xd8cb,0x8fbed0,0x8fbed1,0xd8c0, 0xbbfc,0x8fbed2,0xd8c4,0xc2d6,0xb9b2,0xd8b2,0xbfb5,0, /* 0,'慁','慂',0,'慄','慅','慆','慇', '慈','慉','慊','態','慌','慍','慎',0, */
	/* 6150 */ 0,0,0,0xd8d8,0,0xcae9,0,0, 0xd8ce,0xd8cf,0xd8d0,0,0,0xd8d7,0x8fbed3,0xd8d6, /* 0,0,0,'慓',0,'慕',0,0, '慘','慙','慚',0,0,'慝','慞','慟', */
	/* 6160 */ 0x8fbed4,0,0xcbfd,0xb4b7,0,0xd8d4,0,0xb7c5, 0xb3b4,0,0,0xd8d1,0x8fbed5,0,0xceb8,0xd8d3, /* '慠',0,'慢','慣',0,'慥',0,'慧', '慨',0,0,'慫','慬',0,'慮','慯', */
	/* 6170 */ 0xb0d6,0xd8d5,0x8fbed6,0xd8cc,0xd8d2,0xd8d9,0xb7c4,0xd8cd, 0x8fbed7,0,0,0x8fbed8,0x8fbed9,0,0xcddd,0x8fbeda, /* '慰','慱','慲','慳','慴','慵','慶','慷', '慸',0,0,'慻','慼',0,'慾','慿', */
	/* 6180 */ 0x8fbedb,0x8fbedc,0xcdab,0x8fbedd,0x8fbede,0,0,0xd8dc, 0,0,0xd8e0,0x8fbedf,0,0x8fbee0,0xc1fe,0, /* '憀','憁','憂','憃','憄',0,0,'憇', 0,0,'憊','憋',0,'憍','憎',0, */
	/* 6190 */ 0xcef9,0xd8e1,0x8fbee1,0x8fbee2,0xd8de,0,0xd8db,0x8fbee3, 0x8fbee4,0xd8da,0xd8df,0,0x8fbee5,0x8fbee6,0,0x8fbee7, /* '憐','憑','憒','憓','憔',0,'憖','憗', '憘','憙','憚',0,'憜','憝',0,'憟', */
	/* 61a0 */ 0x8fbee8,0,0,0,0xcab0,0x8fbee9,0,0xc6b4, 0x8fbeea,0xb7c6,0x8fbeeb,0xd8e2,0xd8dd,0x8fbeec,0xd8e3,0, /* '憠',0,0,0,'憤','憥',0,'憧', '憨','憩','憪','憫','憬','憭','憮',0, */
	/* 61b0 */ 0,0,0xb7fb,0,0,0,0xb2b1,0, 0x8fbeed,0x8fbeee,0xd8eb,0,0x8fbeef,0,0xb4b8,0, /* 0,0,'憲',0,0,0,'憶',0, '憸','憹','憺',0,'憼',0,'憾',0, */
	/* 61c0 */ 0x8fbef0,0x8fbef1,0x8fbef2,0xd8e9,0,0,0xd8ea,0xbaa9, 0xd8e8,0xd8e6,0xd8e5,0xd8ec,0xd8e4,0xd8ee,0x8fbef3,0x8fbef4, /* '懀','懁','懂','懃',0,0,'懆','懇', '懈','應','懊','懋','懌','懍','懎','懏', */
	/* 61d0 */ 0xb2fb,0,0,0,0,0x8fbef5,0,0, 0,0,0,0,0x8fbef6,0x8fbef7,0x8fbef8,0x8fbef9, /* '懐',0,0,0,0,'懕',0,0, 0,0,0,0,'懜','懝','懞','懟', */
	/* 61e0 */ 0,0x8fbefa,0x8fbefb,0xd8f0,0,0x8fbefe,0xd8ef,0x8fbefc, 0,0x8fbefd,0,0,0x8fbfa1,0x8fbfa2,0,0x8fbfa3, /* 0,'懡','懢','懣',0,'懥','懦','懧', 0,'懩',0,0,'懬','懭',0,'懯', */
	/* 61f0 */ 0,0,0xc4a8,0,0xd8f3,0,0xd8f1,0xd8e7, 0xb7fc,0,0xd8f2,0,0xd8f6,0xd8f5,0xd8f7,0xd8f4, /* 0,0,'懲',0,'懴',0,'懶','懷', '懸',0,'懺',0,'懼','懽','懾','懿', */
	/* 6200 */ 0xd8f8,0x8fbfa4,0,0x8fbfa5,0x8fbfa6,0,0,0x8fbfa7, 0xd8f9,0xd8fa,0xcaea,0,0xd8fc,0xd8fb,0xbdbf,0, /* '戀','戁',0,'戃','戄',0,0,'戇', '戈','戉','戊',0,'戌','戍','戎',0, */
	/* 6210 */ 0xc0ae,0xb2e6,0xb2fc,0x8fbfa8,0xd8fd,0x8fbfa9,0xb0bf,0, 0,0,0xc0cc,0xd8fe,0x8fbfaa,0xecc3,0xd9a1,0xb7e1, /* '成','我','戒','戓','戔','戕','或',0, 0,0,'戚','戛','戜','戝','戞','戟', */
	/* 6220 */ 0x8fbfab,0xd9a2,0x8fbfac,0x8fbfad,0,0,0xc0ef,0x8fbfae, 0,0x8fbfaf,0xd9a3,0x8fbfb0,0,0,0xd9a4,0xb5ba, /* '戠','戡','戢','戣',0,0,'戦','戧', 0,'戩','截','戫',0,0,'戮','戯', */
	/* 6230 */ 0xd9a5,0,0xd9a6,0xd9a7,0xc2d7,0,0,0, 0xb8cd,0x8fbfb1,0,0xcce1,0,0x8fbfb2,0,0xcbbc, /* '戰',0,'戲','戳','戴',0,0,0, '戸','戹',0,'戻',0,'戽',0,'房', */
	/* 6240 */ 0xbdea,0xd9a8,0x8fbfb3,0x8fbfb4,0x8fbfb5,0,0x8fbfb6,0xc0f0, 0xeebd,0xc8e2,0,0xbcea,0x8fbfb7,0xbacd,0xd9a9,0, /* '所','扁','扂','扃','扄',0,'扆','扇', '扈','扉',0,'手','扌','才','扎',0, */
	/* 6250 */ 0x8fbfb8,0x8fbfb9,0x8fbfba,0xc2c7,0x8fbfbb,0xcaa7,0x8fbfbc,0, 0xc2f1,0,0x8fbfbd,0xd9ac,0x8fbfbe,0,0xd9aa,0, /* '扐','扑','扒','打','扔','払','扖',0, '托',0,'扚','扛','扜',0,'扞',0, */
	/* 6260 */ 0xd9ad,0,0,0xd9ab,0x8fbfbf,0,0,0, 0xd9ae,0,0,0,0,0x8fbfc0,0xcab1,0x8fbfc1, /* '扠',0,0,'扣','扤',0,0,0, '扨',0,0,0,0,'扭','扮','扯', */
	/* 6270 */ 0,0xb0b7,0,0x8fbfc2,0,0,0xc9de,0, 0,0xc8e3,0x8fbfc3,0,0xd9af,0x8fbfc4,0xd9b2,0xbeb5, /* 0,'扱',0,'扳',0,0,'扶',0, 0,'批','扺',0,'扼','扽','找','承', */
	/* 6280 */ 0xb5bb,0,0xd9b0,0xd9b7,0xbeb6,0,0,0, 0,0xd9b1,0xc7c4,0,0,0x8fbfc5,0x8fbfc6,0x8fbfc7, /* '技',0,'抂','抃','抄',0,0,0, 0,'抉','把',0,0,'抍','抎','抏', */
	/* 6290 */ 0x8fbfc8,0xcdde,0xd9b3,0xd9b4,0xd9b8,0xc5ea,0xd9b5,0xb9b3, 0xc0de,0,0,0xd9c6,0xc8b4,0,0xc2f2,0, /* '抐','抑','抒','抓','抔','投','抖','抗', '折',0,0,'抛','抜',0,'択',0, */
	/* 62a0 */ 0,0,0,0,0,0,0x8fbfc9,0, 0x8fbfca,0,0,0xc8e4,0xdaad,0,0,0, /* 0,0,0,0,0,0,'抦',0, '抨',0,0,'披','抬',0,0,0, */
	/* 62b0 */ 0,0xcafa,0,0x8fbfcb,0,0xc4f1,0x8fbfcc,0x8fbfcd, 0,0xcbf5,0x8fbfce,0xd9bb,0xb2a1,0xc3ea,0x8fbfcf,0x8fbfd0, /* 0,'抱',0,'抳',0,'抵','抶','抷', 0,'抹','抺','抻','押','抽','抾','抿', */
	/* 62c0 */ 0,0,0xd9c4,0,0x8fbfd1,0xc3b4,0xd9be,0xd9c5, 0xd9c0,0xd9c7,0xd9c3,0,0xd9c2,0xc7ef,0x8fbfd2,0xd9bc, /* 0,0,'拂',0,'拄','担','拆','拇', '拈','拉','拊',0,'拌','拍','拎','拏', */
	/* 62d0 */ 0xb2fd,0xd9ba,0xb5f1,0xc2f3,0xd9b6,0x8fbfd3,0x8fbfd4,0xd9b9, 0xb9b4,0xc0db,0x8fbfd5,0xbeb7,0xd9c1,0xc7d2,0,0, /* '拐','拑','拒','拓','拔','拕','拖','拗', '拘','拙','拚','招','拜','拝',0,0, */

	/* 62e0 */ 0xb5f2,0xb3c8,0,0,0,0,0,0, 0,0,0x8fbfd6,0,0xb3e7,0xbfa1,0xd9c9,0xd9ce, /* '拠','拡',0,0,0,0,0,0, 0,0,'拪',0,'括','拭','拮','拯', */
	/* 62f0 */ 0,0xd9ca,0x8fbfd7,0xb7fd,0x8fbfd8,0xd9cf,0xbba2,0xb9e9, 0,0,0,0,0x8fbfd9,0x8fbfda,0xbda6,0xd9bd, /* 0,'拱','拲','拳','拴','拵','拶','拷', 0,0,0,0,'拼','拽','拾','拿', */
	/* 6300 */ 0,0xbbfd,0xd9cc,0x8fbfdb,0x8fbfdc,0,0,0xbbd8, 0xd9cd,0xb0c4,0x8fbfdd,0x8fbfde,0xd9c8,0x8fbfdf,0,0, /* 0,'持','挂','挃','挄',0,0,'指', '挈','按','挊','挋','挌','挍',0,0, */
	/* 6310 */ 0x8fbfe0,0xc4a9,0,0x8fbfe1,0,0,0x8fbfe2,0, 0x8fbfe3,0xb5f3,0,0,0,0,0,0xb6b4, /* '挐','挑',0,'挓',0,0,'挖',0, '挘','挙',0,0,0,0,0,'挟', */
	/* 6320 */ 0,0,0,0,0,0,0,0xd9cb, 0xb0a7,0x8fbfe4,0x8fbfe5,0xbac3,0,0x8fbfe6,0,0xbfb6, /* 0,0,0,0,0,0,0,'挧', '挨','挩','挪','挫',0,'挭',0,'振', */
	/* 6330 */ 0,0,0,0,0,0x8fbfe7,0x8fbfe8,0, 0,0x8fbfe9,0xc4f2,0,0x8fbfea,0xc8d4,0xd9d1,0xc1de, /* 0,0,0,0,0,'挵','挶',0, 0,'挹','挺',0,'挼','挽','挾','挿', */
	/* 6340 */ 0,0x8fbfeb,0x8fbfec,0x8fbfed,0x8fbfee,0,0x8fbfef,0, 0,0xc2aa,0x8fbff0,0x8fbff1,0xbbab,0xd9d2,0x8fbff2,0xd9d4, /* 0,'捁','捂','捃','捄',0,'捆',0, 0,'捉','捊','捋','捌','捍','捎','捏', */
	/* 6350 */ 0xd9d0,0,0x8fbff3,0x8fbff4,0x8fbff5,0xcae1,0,0xc4bd, 0x8fbff6,0,0,0x8fbff7,0xc1dc,0,0,0, /* '捐',0,'捒','捓','捔','捕',0,'捗', '捘',0,0,'捛','捜',0,0,0, */
	/* 6360 */ 0,0,0,0,0,0x8fbff8,0x8fbff9,0xcafb, 0xbcce,0xd9e0,0,0xd9df,0x8fbffa,0x8fbffb,0xbff8,0, /* 0,0,0,0,0,'捥','捦','捧', '捨','捩',0,'捫','捬','捭','据',0, */
	/* 6370 */ 0,0x8fbffc,0xb7fe,0,0x8fbffd,0x8fbffe,0xd9d9,0xbeb9, 0x8fc0a1,0,0xc6e8,0xc7b1,0x8fc0a2,0x8fc0a3,0,0x8fc0a4, /* 0,'捱','捲',0,'捴','捵','捶','捷', '捸',0,'捺','捻','捼','捽',0,'捿', */
	/* 6380 */ 0xd9d7,0,0x8fc0a5,0xc1dd,0x8fc0a6,0,0,0x8fc0a7, 0xbcf8,0xd9dc,0x8fc0a8,0,0xbeb8,0,0xd9d6,0xd9db, /* '掀',0,'掂','掃','掄',0,0,'掇', '授','掉','掊',0,'掌',0,'掎','掏', */
	/* 6390 */ 0x8fc0a9,0,0xc7d3,0,0x8fc0aa,0x8fc0ab,0xd9d5,0, 0xb7a1,0x8fc0ac,0x8fc0ad,0xb3dd,0,0,0x8fc0ae,0xd9dd, /* '掐',0,'排',0,'掔','掕','掖',0, '掘','掙','掚','掛',0,0,'掞','掟', */
	/* 63a0 */ 0xceab,0xbace,0xc3b5,0xd9da,0x8fc0af,0xc0dc,0x8fc0b0,0xb9b5, 0xbfe4,0xb1e6,0xc1bc,0xd9d8,0xb5c5,0x8fc0b1,0x8fc0b2,0x8fc0b3, /* '掠','採','探','掣','掤','接','掦','控', '推','掩','措','掫','掬','掭','掮','掯', */
	/* 63b0 */ 0,0,0xb7c7,0,0xc4cf,0xd9de,0,0, 0,0,0,0xc1df,0,0x8fc0b4,0xd9e1,0, /* 0,0,'掲',0,'掴','掵',0,0, 0,0,0,'掻',0,'掽','掾',0, */
	/* 63c0 */ 0xd9e3,0x8fc0b5,0,0xc2b7,0xd9e9,0x8fc0b6,0xd9e4,0, 0x8fc0b7,0xd9e6,0,0,0,0,0x8fc0b8,0xc9c1, /* '揀','揁',0,'揃','揄','揅','揆',0, '揈','揉',0,0,0,0,'揎','描', */
	/* 63d0 */ 0xc4f3,0x8fc0b9,0xd9e7,0x8fc0ba,0x8fc0bb,0x8fc0bc,0xcdac,0, 0,0,0xcdc8,0xb4b9,0x8fc0bd,0,0,0, /* '提','揑','插','揓','揔','揕','揖',0, 0,0,'揚','換','揜',0,0,0, */
	/* 63e0 */ 0x8fc0be,0xb0ae,0,0xd9e5,0,0x8fc0bf,0,0, 0,0xd9e2,0x8fc0c0,0,0x8fc0c1,0,0xb4f8,0, /* '揠','握',0,'揣',0,'揥',0,0, 0,'揩','揪',0,'揬',0,'揮',0, */
	/* 63f0 */ 0,0,0x8fc0c2,0x8fc0c3,0xb1e7,0x8fc0c4,0xd9e8,0, 0x8fc0c5,0x8fc0c6,0xcdc9,0,0,0,0,0, /* 0,0,'揲','揳','援','揵','揶',0, '揸','揹','揺',0,0,0,0,0, */
	/* 6400 */ 0,0,0,0,0,0,0xd9ec,0, 0,0x8fc0c7,0x8fc0c8,0,0,0xc2bb,0,0xd9f3, /* 0,0,0,0,0,0,'搆',0, 0,'搉','搊',0,0,'損',0,'搏', */
	/* 6410 */ 0x8fc0c9,0,0x8fc0ca,0xd9ed,0x8fc0cb,0,0xd9ea,0xd9f1, 0x8fc0cc,0,0,0,0xd9d3,0,0x8fc0cd,0, /* '搐',0,'搒','搓','搔',0,'搖','搗', '搘',0,0,0,'搜',0,'搞',0, */
	/* 6420 */ 0x8fc0ce,0,0x8fc0cf,0,0x8fc0d0,0x8fc0d1,0xd9ee,0, 0xd9f2,0x8fc0d2,0x8fc0d3,0,0xc8c2,0xc5eb,0,0x8fc0d4, /* '搠',0,'搢',0,'搤','搥','搦',0, '搨','搩','搪',0,'搬','搭',0,'搯', */
	/* 6430 */ 0x8fc0d5,0,0,0,0xd9eb,0x8fc0d6,0xd9ef,0, 0,0,0xb7c8,0,0,0x8fc0d7,0xbaf1,0x8fc0d8, /* '搰',0,0,0,'搴','搵','搶',0, 0,0,'携',0,0,'搽','搾','搿', */
	/* 6440 */ 0,0,0xc0dd,0,0,0,0,0, 0,0,0,0x8fc0d9,0,0,0xd9f7,0x8fc0da, /* 0,0,'摂',0,0,0,0,0, 0,0,0,'摋',0,0,'摎','摏', */
	/* 6450 */ 0,0x8fc0db,0x8fc0dc,0x8fc0dd,0x8fc0de,0,0,0, 0xc5a6,0,0x8fc0df,0x8fc0e0,0x8fc0e1,0x8fc0e2,0,0x8fc0e3, /* 0,'摑','摒','摓','摔',0,0,0, '摘',0,'摚','摛','摜','摝',0,'摟', */
	/* 6460 */ 0x8fc0e4,0x8fc0e5,0,0x8fc0e6,0,0,0,0xd9f4, 0,0xcbe0,0,0,0,0x8fc0e7,0,0xd9f5, /* '摠','摡',0,'摣',0,0,0,'摧', 0,'摩',0,0,0,'摭',0,'摯', */
	/* 6470 */ 0,0,0,0x8fc0e8,0x8fc0e9,0,0xd9f6,0, 0xccce,0,0xc0a2,0x8fc0ea,0,0x8fc0eb,0,0, /* 0,0,0,'摳','摴',0,'摶',0, '摸',0,'摺','摻',0,'摽',0,0, */
	/* 6480 */ 0,0,0,0xb7e2,0,0x8fc0ec,0,0x8fc0ed, 0xd9fd,0,0,0,0,0,0,0x8fc0ee, /* 0,0,0,'撃',0,'撅',0,'撇', '撈',0,0,0,0,0,0,'撏', */
	/* 6490 */ 0x8fc0ef,0x8fc0f0,0xbbb5,0xd9fa,0,0xd9f9,0,0, 0x8fc0f1,0x8fc0f2,0xc7b2,0x8fc0f3,0,0x8fc0f4,0xc6b5,0x8fc0f5, /* '撐','撑','撒','撓',0,'撕',0,0, '撘','撙','撚','撛',0,'撝','撞','撟', */
	/* 64a0 */ 0,0x8fc0f6,0,0x8fc0f7,0xc5b1,0xd9fb,0x8fc0f8,0, 0x8fc0f9,0xd9fc,0,0xc9ef,0x8fc0fa,0xc7c5,0xbba3,0, /* 0,'撡',0,'撣','撤','撥','撦',0, '撨','撩',0,'撫','撬','播','撮',0, */
	/* 64b0 */ 0xc0f1,0,0xcbd0,0x8fc0fb,0,0,0,0, 0,0xb3c9,0,0xdaa5,0xd9fe,0x8fc0fc,0x8fc0fd,0x8fc0fe, /* '撰',0,'撲','撳',0,0,0,0, 0,'撹',0,'撻','撼','撽','撾','撿', */
	/* 64c0 */ 0,0xcdca,0xdaa7,0,0x8fc1a1,0xdaa3,0,0xdaa4, 0,0x8fc1a2,0x8fc1a3,0x8fc1a4,0x8fc1a5,0xc1e0,0x8fc1a6,0, /* 0,'擁','擂',0,'擄','擅',0,'擇', 0,'擉','擊','擋','擌','操','擎',0, */
	/* 64d0 */ 0x8fc1a7,0x8fc1a8,0xdaa2,0,0xd9bf,0x8fc1a9,0,0x8fc1aa, 0xdaa6,0,0xdaa1,0,0,0,0,0, /* '擐','擑','擒',0,'擔','擕',0,'擗', '擘',0,'據',0,0,0,0,0, */
	/* 64e0 */ 0xdaab,0xdaac,0xc5a7,0xdaae,0x8fc1ab,0x8fc1ac,0xbba4,0xdaa9, 0,0x8fc1ad,0x8fc1ae,0,0xb5bc,0x8fc1af,0,0xdaaf, /* '擠','擡','擢','擣','擤','擥','擦','擧', 0,'擩','擪',0,'擬','擭',0,'擯', */
	/* 64f0 */ 0x8fc1b0,0xdaa8,0xdab3,0,0xdab2,0x8fc1b1,0xdab1,0x8fc1b2, 0,0,0xdab4,0x8fc1b3,0,0xdab6,0xbef1,0x8fc1b4, /* '擰','擱','擲',0,'擴','擵','擶','擷', 0,0,'擺','擻',0,'擽','擾','擿', */
	/* 6500 */ 0xdab5,0x8fc1b5,0,0,0x8fc1b6,0xdab9,0,0, 0x8fc1b7,0x8fc1b8,0x8fc1b9,0,0,0,0,0x8fc1ba, /* '攀','攁',0,0,'攄','攅',0,0, '攈','攉','攊',0,0,0,0,'攏', */
	/* 6510 */ 0,0,0,0x8fc1bb,0x8fc1bc,0,0x8fc1bd,0, 0xdab7,0x8fc1be,0,0x8fc1bf,0xdab8,0xd9f0,0x8fc1c0,0x8fc1c1, /* 0,0,0,'攓','攔',0,'攖',0, '攘','攙',0,'攛','攜','攝','攞','攟', */
	/* 6520 */ 0,0,0x8fc1c2,0xdabb,0xdaba,0,0x8fc1c3,0, 0,0x8fc1c4,0xd9f8,0xdabc,0xdab0,0,0x8fc1c5,0xbbd9, /* 0,0,'攢','攣','攤',0,'攦',0, 0,'攩','攪','攫','攬',0,'攮','支', */
	/* 6530 */ 0,0x8fc1c6,0,0,0xdabd,0xdabe,0xdac0,0xdabf, 0xdac1,0xb2fe,0x8fc1c7,0xb9b6,0x8fc1c8,0x8fc1c9,0xcafc,0xc0af, /* 0,'攱',0,0,'攴','攵','收','攷', '攸','改','攺','攻','攼','攽','放','政', */
	/* 6540 */ 0,0,0,0x8fc1ca,0,0xb8ce,0,0x8fc1cb, 0xdac3,0x8fc1cc,0,0,0,0xdac6,0x8ff4c1,0xc9d2, /* 0,0,0,'敃',0,'故',0,'敇', '效','敉',0,0,0,'敍','敎','敏', */
	/* 6550 */ 0x8fc1cd,0xb5df,0x8fc1ce,0,0x8fc1cf,0xdac5,0xdac4,0xc7d4, 0xdac7,0xb6b5,0,0,0,0xdac9,0xdac8,0x8fc1d0, /* '敐','救','敒',0,'敔','敕','敖','敗', '敘','教',0,0,0,'敝','敞','敟', */
	/* 6560 */ 0x8fc1d1,0,0xb4ba,0xbbb6,0,0,0xc6d8,0x8fc1d2, 0,0,0,0x8fc1d3,0xb7c9,0,0,0, /* '敠',0,'敢','散',0,0,'敦','敧', 0,0,0,'敫','敬',0,0,0, */
	/* 6570 */ 0xbff4,0,0xdaca,0,0xc0b0,0xc5a8,0,0xc9df, 0xdacb,0,0x8fc1d4,0,0,0x8fc1d5,0,0, /* '数',0,'敲',0,'整','敵',0,'敷', '數',0,'敺',0,0,'敽',0,0, */
	/* 6580 */ 0,0x8fc1d6,0xdacc,0xdacd,0,0x8fc1d7,0,0xcab8, 0xd5dd,0xc0c6,0x8fc1d8,0,0xc9cc,0,0xbad8,0, /* 0,'斁','斂','斃',0,'斅',0,'文', '斈','斉','斊',0,'斌',0,'斎',0, */
	/* 6590 */ 0xc8e5,0xc8c3,0x8fc1d9,0,0,0x8fc1da,0,0xc5cd, 0x8fc1db,0xcec1,0,0xdacf,0xbcd0,0x8fc1dc,0,0xdad0, /* '斐','斑','斒',0,0,'斕',0,'斗', '斘','料',0,'斛','斜','斝',0,'斟', */
	/* 65a0 */ 0x8fc1dd,0xb0b6,0,0x8fc1de,0xb6d4,0xc0cd,0x8fc1df,0xc9e0, 0,0,0,0xdad1,0xbbc2,0xc3c7,0x8fc1e0,0xbbdb, /* '斠','斡',0,'斣','斤','斥','斦','斧', 0,0,0,'斫','斬','断','斮','斯', */
	/* 65b0 */ 0xbfb7,0,0x8fc1e1,0x8fc1e2,0x8fc1e3,0,0,0xdad2, 0,0xcafd,0,0,0xb1f7,0xbbdc,0,0x8fc1e4, /* '新',0,'斲','斳','斴',0,0,'斷', 0,'方',0,0,'於','施',0,'斿', */
	/* 65c0 */ 0,0xdad5,0x8fc1e5,0xdad3,0xdad6,0xceb9,0xdad4,0, 0x8fc1e6,0x8fc1e7,0,0xc0fb,0xdad7,0,0x8fc1e8,0xc2b2, /* 0,'旁','旂','旃','旄','旅','旆',0, '旈','旉',0,'旋','旌',0,'旎','族', */
	/* 65d0 */ 0x8fc1e9,0,0xdad8,0,0x8fc1ea,0,0x8fc1eb,0xb4fa, 0x8fc1ec,0xdada,0,0xdad9,0,0,0,0x8fc1ed, /* '旐',0,'旒',0,'旔',0,'旖','旗', '旘','旙',0,'旛',0,0,0,'旟', */
	/* 65e0 */ 0xdadb,0xdadc,0xb4fb,0,0,0xc6fc,0xc3b6,0xb5ec, 0xbbdd,0xc1e1,0,0,0xbddc,0xb0b0,0,0, /* '无','旡','既',0,0,'日','旦','旧', '旨','早',0,0,'旬','旭',0,0, */
	/* 65f0 */ 0x8fc1ee,0xdadd,0x8fc1ef,0,0x8fc1f0,0x8fc1f1,0,0, 0,0x8fc1f2,0xb2a2,0xdae1,0,0,0x8fc1f3,0x8fc1f4, /* '旰','旱','旲',0,'旴','旵',0,0, 0,'旹','旺','旻',0,0,'旾','旿', */
	/* 6600 */ 0x8fc1f5,0,0xb9b7,0xdae0,0x8fc1f6,0,0xbaab,0xbeba, 0x8fc1f7,0x8fc1f8,0xdadf,0,0xbebb,0x8fc1f9,0xccc0,0xbaaa, /* '昀',0,'昂','昃','昄',0,'昆','昇', '昈','昉','昊',0,'昌','昍','明','昏', */
	/* 6610 */ 0,0x8fc1fa,0x8fc1fb,0xb0d7,0xc0ce,0x8fc1fc,0x8fc1fd,0, 0,0,0,0,0xdae6,0x8fc1fe,0x8fc2a1,0xc0b1, /* 0,'昑','昒','易','昔','昕','昖',0, 0,0,0,0,'昜','昝','昞','星', */
	/* 6620 */ 0xb1c7,0x8fc2a2,0x8fc2a3,0x8fc2a4,0x8fc2a5,0xbdd5,0x8fc2a6,0xcbe6, 0xbaf2,0x8fc2a7,0x8fc2a8,0x8fc2a9,0x8fc2aa,0xbebc,0x8fc2ab,0xc0a7, /* '映','昡','昢','昣','昤','春','昦','昧', '昨','昩','昪','昫','昬','昭','昮','是', */
	/* 6630 */ 0x8fc2ac,0x8fc2ad,0,0x8fc2ae,0xdae5,0xdae3,0xdae4,0x8fc2b0, 0,0x8fc2af,0,0x8ff4c2,0xc3eb,0,0,0xdba6, /* '昰','昱',0,'昳','昴','昵','昶','昷', 0,'昹',0,'昻','昼',0,0,'昿', */
	/* 6640 */ 0x8fc2b1,0xdaea,0xbbfe,0xb9b8,0xdae8,0x8fc2b2,0x8fc2b3,0, 0,0xdae9,0x8fc2b4,0xbfb8,0x8fc2b5,0,0x8fc2b7,0xdae7, /* '晀','晁','時','晃','晄','晅','晆',0, 0,'晉','晊','晋','晌',0,'晎','晏', */
	/* 6650 */ 0,0x8fc2b6,0xbbaf,0,0,0,0,0x8fc2b8, 0x8fc2b9,0x8fc2ba,0,0x8fc2bb,0x8fc2bc,0xdaec,0xdaeb,0xdaf0, /* 0,'晑','晒',0,0,0,0,'晗', '晘','晙',0,'晛','晜','晝','晞','晟', */
	/* 6660 */ 0x8fc2bd,0x8fc2be,0xdaf1,0,0xdaed,0x8ff4c3,0xb3a2,0xdaee, 0xdaef,0xc8d5,0x8fc2c0,0x8fc2c1,0x8fc2c2,0,0xc9e1,0xb7ca, /* '晠','晡','晢',0,'晤','晥','晦','晧', '晨','晩','晪','晫','晬',0,'普','景', */
	/* 6670 */ 0xdaf2,0,0,0x8fc2c4,0xc0b2,0x8fc2c5,0xbebd,0x8fc2c7, 0x8fc2c8,0x8fc2c9,0xc3d2,0x8fc2ca,0x8fc2cc,0,0x8fc2c3,0x8fc2c6, /* '晰',0,0,'晳','晴','晵','晶','晷', '晸','晹','智','晻','晼',0,'晾','晿', */
	/* 6680 */ 0x8fc2cb,0xb6c7,0,0xdaf3,0xdaf7,0,0,0xb2cb, 0xdaf4,0xdaf6,0,0x8fc2cd,0x8fc2ce,0x8fc2cf,0xdaf5,0, /* '暀','暁',0,'暃','暄',0,0,'暇', '暈','暉',0,'暋','暌','暍','暎',0, */
	/* 6690 */ 0x8fc2d0,0xbdeb,0x8fc2d1,0,0,0,0xc3c8,0xb0c5, 0xdaf8,0x8fc2d2,0x8fc2d3,0x8fc2d4,0x8fc2d5,0xdaf9,0,0x8fc2d6, /* '暐','暑','暒',0,0,0,'暖','暗', '暘','暙','暚','暛','暜','暝',0,'暟', */
	/* 66a0 */ 0x8fc2d7,0,0xc4aa,0,0x8fc2d8,0,0xcef1,0, 0,0,0,0xbbc3,0,0x8fc2d9,0xcaeb,0, /* '暠',0,'暢',0,'暤',0,'暦',0, 0,0,0,'暫',0,'暭','暮',0, */
	/* 66b0 */ 0,0x8fc2da,0x8fc2db,0,0xcbbd,0x8fc2dc,0,0, 0xdba2,0xdafb,0,0x8fc2dd,0xdafe,0,0xdafd,0x8fc2de, /* 0,'暱','暲',0,'暴','暵',0,0, '暸','暹',0,'暻','暼',0,'暾','暿', */
	/* 66c0 */ 0x8fc2df,0xdafa,0x8fc2e0,0x8fc2e1,0xdba1,0,0,0xc6de, 0x8fc2e2,0xdafc,0,0,0x8fc2e3,0,0x8fc2e4,0x8fc2e5, /* '曀','曁','曂','曃','曄',0,0,'曇', '曈','曉',0,0,'曌',0,'曎','曏', */
	/* 66d0 */ 0,0,0,0,0x8fc2e6,0,0xdba3,0, 0,0xbdec,0xdba4,0x8fc2e7,0xcdcb,0xc7f8,0,0x8fc2e8, /* 0,0,0,0,'曔',0,'曖',0, 0,'曙','曚','曛','曜','曝',0,'曟', */
	/* 66e0 */ 0xdba5,0,0,0,0,0,0xdba7,0, 0x8fc2e9,0xdba8,0,0x8fc2ea,0x8fc2eb,0,0x8fc2ec,0, /* '曠',0,0,0,0,0,'曦',0, '曨','曩',0,'曫','曬',0,'曮',0, */
	/* 66f0 */ 0xdba9,0,0xb6ca,0xb1c8,0xb9b9,0xdbaa,0,0xdbab, 0xbdf1,0xc1e2,0x8fc2ed,0x8fc2bf,0xd2d8,0xc1be,0xc1bd,0xc2d8, /* '曰',0,'曲','曳','更','曵',0,'曷', '書','曹','曺','曻','曼','曽','曾','替', */
	/* 6700 */ 0xbac7,0,0,0xd0f2,0,0x8fc2ee,0,0x8fc2ef, 0xb7ee,0xcdad,0,0xcafe,0,0xc9fe,0x8fc2f0,0xdbac, /* '最',0,0,'會',0,'朅',0,'朇', '月','有',0,'朋',0,'服','朎','朏', */
	/* 6710 */ 0,0,0,0x8fc2f1,0xbaf3,0xc4bf,0xdbad,0xcfaf, 0,0x8fc2f2,0,0xcbbe,0x8fc2f3,0xc4ab,0xdbae,0xb4fc, /* 0,0,0,'朓','朔','朕','朖','朗', 0,'朙',0,'望','朜','朝','朞','期', */
	/* 6720 */ 0x8fc2f4,0,0x8fc2f5,0,0,0,0xdbaf,0xdbb0, 0xccda,0,0xcca4,0xcbf6,0xcbdc,0xbba5,0xdbb2,0, /* '朠',0,'朢',0,0,0,'朦','朧', '木',0,'未','末','本','札','朮',0, */
	/* 6730 */ 0,0xbceb,0,0x8fc2f6,0xcbd1,0,0xdbb4,0xdbb7, 0xdbb6,0,0xb4f9,0,0,0xb5e0,0x8fc2f7,0xdbb3, /* 0,'朱',0,'朳','朴',0,'朶','朷', '朸',0,'机',0,0,'朽','朾','朿', */
	/* 6740 */ 0,0xdbb5,0,0,0,0x8fc2f8,0xdbb8,0x8fc2f9, 0x8fc2fa,0xbff9,0,0,0x8fc2fb,0,0xcdfb,0xb0c9, /* 0,'杁',0,0,0,'杅','杆','杇', '杈','杉',0,0,'杌',0,'李','杏', */
	/* 6750 */ 0xbae0,0xc2bc,0,0xbcdd,0x8fc2fc,0x8fc2fd,0xbef3,0, 0,0xdbbb,0,0,0xc5ce,0x8fc2fe,0xdbb9,0xc2ab, /* '材','村',0,'杓','杔','杕','杖',0, 0,'杙',0,0,'杜','杝','杞','束', */
	/* 6760 */ 0xdbba,0xbef2,0xccdd,0xdbbc,0xdbbd,0xcde8,0x8fc3a1,0, 0,0,0xdbc2,0,0x8fc3a2,0xb9ba,0x8fc3a3,0xc7d5, /* '杠','条','杢','杣','杤','来','杦',0, 0,0,'杪',0,'杬','杭','杮','杯', */
	/* 6770 */ 0xdbbf,0xc5ec,0xdade,0xdae2,0x8fc3a4,0xb5cf,0x8fc3a5,0xc7c7, 0,0,0,0x8fc3a6,0xdbc1,0,0xbebe,0xc8c4, /* '杰','東','杲','杳','杴','杵','杶','杷', 0,0,0,'杻','杼',0,'松','板', */
	/* 6780 */ 0,0x8fc3a7,0,0,0x8fc3a8,0xdbc7,0,0xc8fa, 0,0xdbbe,0,0xdbc4,0xdbc3,0,0x8fc3a9,0x8fc3aa, /* 0,'极',0,0,'构','枅',0,'枇', 0,'枉',0,'枋','枌',0,'枎','枏', */
	/* 6790 */ 0xc0cf,0x8fc3ab,0,0x8fc3ac,0,0xcbed,0x8fc3ad,0xced3, 0x8fc3ae,0x8fc3af,0xcbe7,0x8fc3b0,0xb2cc,0xbbde,0,0, /* '析','枑',0,'枓',0,'枕','枖','林', '枘','枙','枚','枛','果','枝',0,0, */
	/* 67a0 */ 0xcfc8,0xdbc6,0xbff5,0,0,0,0xdbc5,0, 0,0xdbc0,0,0,0,0,0,0xb8cf, /* '枠','枡','枢',0,0,0,'枦',0, 0,'枩',0,0,0,0,0,'枯', */
	/* 67b0 */ 0x8fc3b1,0x8fc3b2,0x8fc3b3,0xdbcc,0xdbca,0x8fc3b4,0xb2cd,0xdbc8, 0xdbce,0xdbd4,0,0x8fc3b5,0x8fc3b6,0x8fc3b7,0,0, /* '枰','枱','枲','枳','枴','枵','架','枷', '枸','枹',0,'枻','枼','枽',0,0, */
	/* 67c0 */ 0x8fc3b9,0xc2c8,0x8fc3ba,0x8fc3bb,0xcac1,0x8fc3bc,0xdbd6,0, 0x8fc3bd,0x8fc3be,0xc9a2,0,0,0,0xdbd5,0xc7f0, /* '柀','柁','柂','柃','柄','柅','柆',0, '柈','柉','柊',0,0,0,'柎','柏', */
	/* 67d0 */ 0xcbbf,0xb4bb,0x8fc3bf,0xc0f7,0xbdc0,0,0,0x8fc3c0, 0xc4d3,0x8fc3c1,0xcdae,0,0x8fc3c2,0xdbd1,0xdbd0,0, /* '某','柑','柒','染','柔',0,0,'柗', '柘','柙','柚',0,'柜','柝','柞',0, */
	/* 67e0 */ 0,0x8fc3c3,0xdbd2,0,0xdbcf,0,0x8fc3c4,0xdbd7, 0,0xdbcd,0,0,0xdbcb,0,0xdbd3,0xdbc9, /* 0,'柡','柢',0,'柤',0,'柦','柧', 0,'柩',0,0,'柬',0,'柮','柯', */
	/* 67f0 */ 0x8fc3c5,0xc3ec,0x8fc3c6,0xccf8,0xbcc6,0xbaf4,0x8fc3c7,0x8fc3c8, 0,0x8fc3b8,0,0xbaba,0,0,0xcbef,0xb3c1, /* '柰','柱','柲','柳','柴','柵','柶','柷', 0,'柹',0,'査',0,0,'柾','柿', */
	/* 6800 */ 0,0x8ff4c6,0xc4ce,0xc6ca,0xb1c9,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'栁','栂','栃','栄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6810 */ 0,0,0,0xc0f2,0x8fc3ca,0,0xc0b4,0xb7aa, 0,0x8fc3cb,0,0,0,0x8fc3cc,0xdbd9,0x8fc3cd, /* 0,0,0,'栓','栔',0,'栖','栗', 0,'栙',0,0,0,'栝','栞','栟', */
	/* 6820 */ 0,0xb9bb,0xb3fc,0,0,0,0,0x8fc3cf, 0x8fc3ce,0xdbdb,0xb3f4,0xdbe1,0x8fc3d0,0x8fc3d1,0,0x8fc3d2, /* 0,'校','栢',0,0,0,0,'栧', '栨','栩','株','栫','栬','栭',0,'栯', */
	/* 6830 */ 0x8fc3d3,0x8fc3d4,0xdbde,0x8fc3d5,0xc0f3,0,0,0, 0xb3cb,0xbaac,0,0x8fc3d6,0xb3ca,0xbacf,0,0x8fc3d7, /* '栰','栱','栲','栳','栴',0,0,0, '核','根',0,'栻','格','栽',0,'栿', */
	/* 6840 */ 0xdbdc,0xb7e5,0xb7cb,0xc5ed,0x8fc3d8,0x8fc3d9,0xdbda,0, 0xb0c6,0,0x8fc3da,0,0x8fc3db,0xdbdd,0xdbdf,0, /* '桀','桁','桂','桃','桄','桅','框',0, '案',0,'桊',0,'桌','桍','桎',0, */
	/* 6850 */ 0xb6cd,0xb7ac,0x8fc3c9,0xb4bc,0xb5cb,0x8fc3dc,0,0x8fc3dd, 0x8fc3de,0xdbe2,0,0x8fc3df,0xbaf9,0xcbf1,0,0xbbb7, /* '桐','桑','桒','桓','桔','桕',0,'桗', '桘','桙',0,'桛','桜','桝',0,'桟', */
	/* 6860 */ 0,0,0,0xdbe3,0,0,0,0xc9b0, 0,0,0,0x8fc3e0,0,0,0x8fc3e1,0x8fc3e2, /* 0,0,0,'档',0,0,0,'桧', 0,0,0,'桫',0,0,'桮','桯', */
	/* 6870 */ 0x8fc3e3,0x8fc3e4,0x8fc3e5,0,0xdbef,0x8fc3e6,0xb2b3,0xdbe4, 0,0x8fc3e7,0x8fc3e8,0x8fc3e9,0x8fc3ea,0,0xdbf5,0xdbe5, /* '桰','桱','桲',0,'桴','桵','桶','桷', 0,'桹','桺','桻','桼',0,'桾','桿', */
	/* 6880 */ 0,0xcec2,0x8fc3eb,0xdbec,0x8fc3ec,0xc7df,0x8fc3ed,0, 0x8fc3ee,0,0,0,0,0xdbf4,0,0xdbe7, /* 0,'梁','梂','梃','梄','梅','梆',0, '梈',0,0,0,0,'梍',0,'梏', */
	/* 6890 */ 0,0,0,0xb0b4,0xdbe9,0,0x8fc3ef,0xb9bc, 0x8fc3f0,0,0x8fc3f1,0xdbeb,0x8fc3f2,0xdbea,0,0xdbe6, /* 0,0,0,'梓','梔',0,'梖','梗', '梘',0,'梚','梛','梜','條',0,'梟', */
	/* 68a0 */ 0xdbf1,0x8fc3f3,0xbebf,0x8fc3f4,0,0x8fc3f5,0xd4ed,0xb8e8, 0xcdfc,0x8fc3f6,0x8fc3f7,0,0,0xdbe8,0x8fc3f8,0xc4f4, /* '梠','梡','梢','梣',0,'梥','梦','梧', '梨','梩','梪',0,0,'梭','梮','梯', */
	/* 68b0 */ 0xb3a3,0xbaad,0x8fc3f9,0xdbe0,0,0xdbf0,0xb3e1,0, 0,0xdbee,0xdbf2,0x8fc3fa,0xc5ee,0,0,0, /* '械','梱','梲','梳',0,'梵','梶',0, 0,'梹','梺','梻','梼',0,0,0, */
	/* 68c0 */ 0,0,0,0,0xb4fe,0x8fc3fb,0xdcb2,0, 0x8fc3fc,0xccc9,0xdbf7,0xb4fd,0x8fc3fd,0xdbfe,0,0x8fc3fe, /* 0,0,0,0,'棄','棅','棆',0, '棈','棉','棊','棋','棌','棍',0,'棏', */
	/* 68d0 */ 0x8fc4a1,0x8fc4a2,0xcbc0,0x8fc4a3,0xdca1,0xdca3,0x8fc4a4,0xdca7, 0xdbf9,0x8fc4a5,0xc3aa,0,0x8fc4a6,0x8fc4a7,0,0xc5ef, /* '棐','棑','棒','棓','棔','棕','棖','棗', '棘','棙','棚',0,'棜','棝',0,'棟', */
	/* 68e0 */ 0xdcab,0xdbfc,0,0xdca8,0,0x8fc4a8,0,0xdca2, 0x8fc4a9,0,0x8fc4aa,0x8fc4ab,0x8fc4ac,0x8fc4ad,0xbfb9,0xdcac, /* '棠','棡',0,'棣',0,'棥',0,'棧', '棨',0,'棪','棫','棬','棭','森','棯', */
	/* 68f0 */ 0x8fc4ae,0x8fc4af,0xc0b3,0,0,0x8fc4b0,0x8fc4b1,0, 0,0xdcaa,0xb4bd,0x8fc4b2,0x8fc4b3,0x8fc4b4,0,0, /* '棰','棱','棲',0,0,'棵','棶',0, 0,'棹','棺','棻','棼','棽',0,0, */
	/* 6900 */ 0xcfd0,0xdbf6,0,0,0xdca6,0xb0d8,0x8fc4b5,0, 0xdbf8,0x8fc4b6,0x8fc4b7,0xccba,0xdbfd,0xbfa2,0xc4c7,0xdbf3, /* '椀','椁',0,0,'椄','椅','椆',0, '椈','椉','椊','椋','椌','植','椎','椏', */
	/* 6910 */ 0x8fc4b8,0x8fc4b9,0xdca5,0x8fc4ba,0,0,0x8fc4bb,0x8fc4bc, 0,0xbffa,0xdcaf,0xb3f1,0xb8a1,0,0,0, /* '椐','椑','椒','椓',0,0,'椖','椗', 0,'椙','椚','椛','検',0,0,0, */
	/* 6920 */ 0,0xdcb1,0xdbfa,0xdcb0,0,0xdca9,0xdbfb,0, 0xdcad,0,0xdcae,0,0,0,0,0, /* 0,'椡','椢','椣',0,'椥','椦',0, '椨',0,'椪',0,0,0,0,0, */
	/* 6930 */ 0xdcbf,0x8fc4bd,0,0x8fc4be,0xc6ce,0x8fc4bf,0xdca4,0, 0x8fc4c0,0xdcbb,0,0x8fc4c1,0,0xdcbd,0,0xc4d8, /* '椰','椱',0,'椳','椴','椵','椶',0, '椸','椹',0,'椻',0,'椽',0,'椿', */
	/* 6940 */ 0,0,0x8fc4c2,0,0,0x8fc4c3,0,0, 0,0x8fc4c4,0xcdcc,0,0,0,0x8fc4c5,0, /* 0,0,'楂',0,0,'楅',0,0, 0,'楉','楊',0,0,0,'楎',0, */
	/* 6950 */ 0,0,0,0xc9f6,0xdcb8,0xc2ca,0,0x8fc4c6, 0,0xdcbe,0xc1bf,0x8fc4c7,0xdcb5,0xdcc2,0xdcc1,0, /* 0,0,0,'楓','楔','楕',0,'楗', 0,'楙','楚','楛','楜','楝','楞',0, */
	/* 6960 */ 0xc6ef,0xdcc0,0xc6ea,0x8fc4c8,0x8fc4c9,0x8fc4ca,0x8fc4cb,0, 0x8fc4cc,0x8fc4cd,0xdcc4,0xdcb7,0x8fc4ce,0xb6c8,0xdcba,0xbddd, /* '楠','楡','楢','楣','楤','楥','楦',0, '楨','楩','楪','楫','楬','業','楮','楯', */
	/* 6970 */ 0x8fc4cf,0x8fc4d0,0x8fc4d1,0xc7e0,0xdcbc,0xb6cb,0,0xdcb4, 0xdcb6,0xdcb3,0x8fc4d2,0x8fc4d3,0xcfb0,0xb3da,0xdcb9,0x8fc4d4, /* '楰','楱','楲','楳','楴','極',0,'楷', '楸','楹','楺','楻','楼','楽','楾','楿', */
	/* 6980 */ 0x8fc4d5,0xdcc3,0xb3b5,0,0,0,0,0, 0,0,0xbae7,0,0,0x8fc4d6,0xb1dd,0, /* '榀','榁','概',0,0,0,0,0, 0,0,'榊',0,0,'榍','榎',0, */
	/* 6990 */ 0,0xdcd4,0x8fc4d7,0,0xcfb1,0xdcd7,0x8fc4d8,0, 0x8fc4d9,0,0,0xbfba,0xdcd6,0,0,0, /* 0,'榑','榒',0,'榔','榕','榖',0, '榘',0,0,'榛','榜',0,0,0, */
	/* 69a0 */ 0xdcd5,0x8fc4da,0,0,0,0x8fc4db,0x8fc4dc,0xdcd2, 0x8fc4dd,0,0,0x8fc4de,0,0x8fc4df,0xdcc6,0x8fc4e0, /* '榠','榡',0,0,0,'榥','榦','榧', '榨',0,0,'榫',0,'榭','榮','榯', */
	/* 69b0 */ 0,0xdce3,0xdcc5,0,0xdcd8,0,0,0x8fc4e1, 0x8fc4e2,0,0x8fc4e3,0xdcd0,0x8fc4e4,0,0xdccb,0xdcc8, /* 0,'榱','榲',0,'榴',0,0,'榷', '榸',0,'榺','榻','榼',0,'榾','榿', */
	/* 69c0 */ 0,0xdcc9,0,0xdcd1,0,0x8fc4e5,0,0xf4a2, 0x8fc4e6,0,0xdcce,0xb9bd,0xc4c8,0xc1e4,0xdccc,0, /* 0,'槁',0,'槃',0,'槅',0,'槇', '槈',0,'槊','構','槌','槍','槎',0, */
	/* 69d0 */ 0xdcc7,0x8fc4e7,0,0xdcca,0,0,0x8fc4e8,0x8fc4e9, 0xcdcd,0xcbea,0,0,0,0xdccf,0xdcd9,0, /* '槐','槑',0,'槓',0,0,'槖','槗', '様','槙',0,0,0,'槝','槞',0, */
	/* 69e0 */ 0,0,0x8fc4ea,0,0,0x8fc4eb,0,0xdce1, 0xdcda,0,0,0xdce7,0,0xdce5,0x8fc4ec,0x8fc4ed, /* 0,0,'槢',0,0,'槥',0,'槧', '槨',0,0,'槫',0,'槭','槮','槯', */
	/* 69f0 */ 0,0x8fc4ee,0xdce0,0x8fc4ef,0,0x8fc4f0,0,0, 0,0xdcdf,0,0xc4d0,0,0xc1e5,0x8fc4f1,0xdcdd, /* 0,'槱','槲','槳',0,'槵',0,0, 0,'槹',0,'槻',0,'槽','槾','槿', */
	/* 6a00 */ 0x8fc4f2,0x8fc4f3,0xdcdb,0x8fc4f4,0,0xdce2,0,0, 0,0,0xdce8,0xc8f5,0xdcee,0,0,0x8fc4f5, /* '樀','樁','樂','樃',0,'樅',0,0, 0,0,'樊','樋','樌',0,0,'樏', */
	/* 6a10 */ 0,0x8fc4f6,0xdce9,0xdcec,0xdce6,0x8fc4f7,0,0xc3f4, 0,0xc9b8,0x8fc4f8,0xdcdc,0,0x8fc4f9,0xdce4,0xbec0, /* 0,'樑','樒','樓','樔','樕',0,'樗', 0,'標','樚','樛',0,'樝','樞','樟', */
	/* 6a20 */ 0x8fc4fa,0xcccf,0xdcf8,0xdceb,0x8fc4fb,0,0,0, 0x8fc4fc,0xb8a2,0xb2a3,0xb3df,0,0,0xdcd3,0, /* '樠','模','樢','樣','樤',0,0,0, '樨','権','横','樫',0,0,'樮',0, */
	/* 6a30 */ 0x8fc4fd,0,0x8fc4fe,0,0x8fc5a1,0xbec1,0xdcf0,0x8fc5a2, 0xdcf7,0xbcf9,0xb3f2,0x8fc5a3,0,0xc3ae,0x8fc5a4,0x8fc5a5, /* '樰',0,'樲',0,'樴','樵','樶','樷', '樸','樹','樺','樻',0,'樽','樾','樿', */
	/* 6a40 */ 0,0,0,0,0xdced,0x8fc5a6,0x8fc5a7,0xdcf2, 0xdcf6,0x8fc5a8,0x8fc5a9,0xb6b6,0,0,0x8fc5aa,0, /* 0,0,0,0,'橄','橅','橆','橇', '橈','橉','橊','橋',0,0,'橎',0, */
	/* 6a50 */ 0x8fc5ab,0x8fc5ac,0x8fc5ad,0,0,0x8fc5ae,0x8fc5af,0, 0xb5cc,0xdcf4,0,0x8fc5b0,0,0,0,0xb5a1, /* '橐','橑','橒',0,0,'橕','橖',0, '橘','橙',0,'橛',0,0,0,'機', */
	/* 6a60 */ 0,0xc6cb,0xdcf3,0,0x8fc5b1,0,0xdcf5,0x8fc5b2, 0,0,0x8fc5b3,0x8ff4c9,0,0,0,0, /* 0,'橡','橢',0,'橤',0,'橦','橧', 0,0,'橪','橫',0,0,0,0, */
	/* 6a70 */ 0,0x8fc5b4,0xdcef,0x8fc5b5,0,0,0,0, 0xdcf1,0,0,0,0,0,0x8fc5b6,0xb3e0, /* 0,'橱','橲','橳',0,0,0,0, '橸',0,0,0,0,0,'橾','橿', */
	/* 6a80 */ 0xc3c9,0x8fc5b7,0,0x8fc5b8,0xdcfc,0,0x8fc5b9,0x8fc5ba, 0,0x8fc5bb,0,0x8fc5bc,0,0xdcfa,0xb8e9,0, /* '檀','檁',0,'檃','檄',0,'檆','檇', 0,'檉',0,'檋',0,'檍','檎',0, */
	/* 6a90 */ 0xdcf9,0x8fc5bd,0,0,0,0,0,0xdda1, 0,0,0,0x8fc5be,0xdbd8,0x8fc5bf,0x8fc5c0,0x8fc5c1, /* '檐','檑',0,0,0,0,0,'檗', 0,0,0,'檛','檜','檝','檞','檟', */
	/* 6aa0 */ 0xdcfb,0,0xdcfd,0xdcfe,0,0x8fc5c2,0,0, 0,0,0xddac,0x8fc5c3,0xdda8,0,0xdbed,0x8fc5c4, /* '檠',0,'檢','檣',0,'檥',0,0, 0,0,'檪','檫','檬',0,'檮','檯', */
	/* 6ab0 */ 0x8fc5c5,0x8fc5c6,0,0xdda7,0x8fc5c7,0,0,0, 0xdda6,0,0,0xdda3,0,0x8fc5c8,0x8fc5c9,0x8fc5ca, /* '檰','檱',0,'檳','檴',0,0,0, '檸',0,0,'檻',0,'檽','檾','檿', */
	/* 6ac0 */ 0,0xdcea,0xdda5,0xdda4,0,0,0x8fc5cb,0, 0x8fc5cd,0x8fc5cc,0,0,0x8fc5ce,0,0,0, /* 0,'櫁','櫂','櫃',0,0,'櫆',0, '櫈','櫉',0,0,'櫌',0,0,0, */
	/* 6ad0 */ 0x8fc5cf,0xddaa,0,0xcfa6,0x8fc5d0,0x8fc5d1,0x8fc5d2,0, 0,0,0xddad,0xb6fb,0x8fc5d3,0x8fc5d4,0xdda9,0xddab, /* '櫐','櫑',0,'櫓','櫔','櫕','櫖',0, 0,0,'櫚','櫛','櫜','櫝','櫞','櫟', */
	/* 6ae0 */ 0,0,0x8ff4ca,0,0x8fc5d5,0,0,0x8fc5d6, 0xc8a7,0,0xddae,0,0x8fc5d7,0,0,0, /* 0,0,'櫢',0,'櫤',0,0,'櫧', '櫨',0,'櫪',0,'櫬',0,0,0, */
	/* 6af0 */ 0x8fc5d8,0x8fc5d9,0x8fc5da,0,0,0,0,0, 0,0,0xddb2,0xddaf,0x8fc5db,0x8fc5dc,0,0, /* '櫰','櫱','櫲',0,0,0,0,0, 0,0,'櫺','櫻','櫼','櫽',0,0, */
	/* 6b00 */ 0,0,0x8fc5dd,0x8fc5de,0xcdf3,0xddb0,0x8fc5df,0x8fc5e0, 0,0x8fc5e1,0xdcde,0,0,0,0,0x8fc5e2, /* 0,0,'欂','欃','欄','欅','欆','欇', 0,'欉','權',0,0,0,0,'欏', */
	/* 6b10 */ 0x8fc5e3,0x8fc5e4,0xddb3,0,0,0,0xddb4,0x8fc5e5, 0,0,0,0x8fc5e6,0,0xb1b5,0x8fc5e7,0xddb6, /* '欐','欑','欒',0,0,0,'欖','欗', 0,0,0,'欛',0,'欝','欞','欟', */
	/* 6b20 */ 0xb7e7,0xbca1,0,0xb6d5,0x8fc5e8,0,0,0xb2a4, 0x8fc5e9,0,0,0x8fc5ea,0x8fc5eb,0,0,0x8fc5ec, /* '欠','次',0,'欣','欤',0,0,'欧', '欨',0,0,'欫','欬',0,0,'欯', */
	/* 6b30 */ 0,0,0xcddf,0,0,0x8fc5ed,0x8fc5ee,0xddb8, 0xddb7,0xddba,0xb5bd,0x8fc5ef,0,0xb6d6,0xb4be,0x8fc5f0, /* 0,0,'欲',0,0,'欵','欶','欷', '欸','欹','欺','欻',0,'欽','款','欿', */
	/* 6b40 */ 0,0,0,0xddbd,0,0,0x8fc5f1,0xddbc, 0,0xddbe,0x8fc5f2,0,0xb2ce,0x8fc5f3,0xc3b7,0, /* 0,0,0,'歃',0,0,'歆','歇', 0,'歉','歊',0,'歌','歍','歎',0, */
	/* 6b50 */ 0xddbf,0,0x8fc5f4,0xb4bf,0xddc1,0,0x8fc5f5,0, 0x8fc5f6,0xddc0,0,0xddc2,0,0x8fc5f7,0,0xddc3, /* '歐',0,'歒','歓','歔',0,'歖',0, '歘','歙',0,'歛',0,'歝',0,'歟', */
	/* 6b60 */ 0x8fc5f8,0xddc4,0xbbdf,0xc0b5,0xbaa1,0,0xc9f0,0x8fc5f9, 0,0xcae2,0xcfc4,0x8fc5fa,0,0,0x8fc5fb,0xbbf5, /* '歠','歡','止','正','此',0,'武','歧', 0,'歩','歪','歫',0,0,'歮','歯', */
	/* 6b70 */ 0x8fc5fc,0,0,0xbad0,0xcef2,0x8fc5fd,0,0, 0xddc5,0xddc6,0,0xbbe0,0,0x8fc5fe,0x8fc6a1,0xddc7, /* '歰',0,0,'歳','歴','歵',0,0, '歸','歹',0,'死',0,'歽','歾','歿', */
	/* 6b80 */ 0xddc8,0,0x8fc6a2,0xddca,0xddc9,0x8fc6a3,0xcbd8,0, 0,0xbdde,0xbcec,0xbbc4,0,0xddcb,0,0, /* '殀',0,'殂','殃','殄','殅','殆',0, 0,'殉','殊','残',0,'殍',0,0, */
	/* 6b90 */ 0,0,0,0,0,0xddcd,0xbfa3,0x8fc6a4, 0xddcc,0,0,0x8fc6a5,0,0,0xddce,0x8fc6a6, /* 0,0,0,0,0,'殕','殖','殗', '殘',0,0,'殛',0,0,'殞','殟', */
	/* 6ba0 */ 0x8fc6a7,0,0x8fc6a8,0x8fc6a9,0xddcf,0,0,0, 0x8fc6aa,0x8fc6ab,0xddd0,0xddd1,0x8fc6ac,0x8fc6ad,0x8fc6ae,0xddd2, /* '殠',0,'殢','殣','殤',0,0,0, '殨','殩','殪','殫','殬','殭','殮','殯', */
	/* 6bb0 */ 0x8fc6af,0xddd4,0xddd3,0xddd5,0xb2a5,0xc3ca,0,0xddd6, 0x8fc6b0,0x8fc6b1,0xbba6,0xb3cc,0xddd7,0x8fc6b2,0x8fc6b3,0xc5c2, /* '殰','殱','殲','殳','殴','段',0,'殷', '殸','殹','殺','殻','殼','殽','殾','殿', */
	/* 6bc0 */ 0xd4cc,0,0,0x8fc6b4,0x8fc6b5,0xb5a3,0xddd8,0, 0,0x8fc6b6,0,0xddd9,0x8fc6b7,0xcaec,0xcbe8,0, /* '毀',0,0,'毃','毄','毅','毆',0, 0,'毉',0,'毋','毌','母','毎',0, */
	/* 6bd0 */ 0,0,0xc6c7,0xddda,0xc8e6,0,0x8fc6b8,0, 0xc8fb,0,0x8fc6b9,0xccd3,0,0,0,0xdddb, /* 0,0,'毒','毓','比',0,'毖',0, '毘',0,'毚','毛',0,0,0,'毟', */
	/* 6be0 */ 0,0x8fc6ba,0,0x8fc6bb,0,0,0x8fc6bc,0x8fc6bd, 0,0,0,0xdddd,0xdddc,0,0x8fc6be,0xdddf, /* 0,'毡',0,'毣',0,0,'毦','毧', 0,0,0,'毫','毬',0,'毮','毯', */
	/* 6bf0 */ 0,0x8fc6bf,0,0xddde,0,0,0,0x8fc6c0, 0,0x8fc6c1,0,0,0,0,0,0x8fc6c2, /* 0,'毱',0,'毳',0,0,0,'毷', 0,'毹',0,0,0,0,0,'毿', */
	/* 6c00 */ 0,0,0x8fc6c3,0,0x8fc6c4,0x8fc6c5,0,0, 0xdde1,0x8fc6c6,0,0,0,0x8fc6c7,0x8fc6c8,0xbbe1, /* 0,0,'氂',0,'氄','氅',0,0, '氈','氉',0,0,0,'氍','氎','氏', */
	/* 6c10 */ 0x8fc6c9,0xccb1,0x8fc6ca,0xdde2,0xdde3,0,0,0xb5a4, 0,0x8fc6cb,0,0xdde4,0,0,0,0x8fc6cc, /* '氐','民','氒','氓','气',0,0,'気', 0,'氙',0,'氛',0,0,0,'氟', */
	/* 6c20 */ 0,0,0,0xdde6,0xdde5,0,0x8fc6cd,0x8fc6ce, 0x8fc6cf,0,0,0,0x8fc6d0,0,0x8fc6d1,0, /* 0,0,0,'氣','氤',0,'氦','氧', '氨',0,0,0,'氬',0,'氮',0, */
	/* 6c30 */ 0,0,0,0x8fc6d2,0xbfe5,0x8fc6d3,0x8fc6d4,0xc9b9, 0xb1ca,0,0x8fc6d5,0x8fc6d6,0,0,0xc8c5,0x8fc6d7, /* 0,0,0,'氳','水','氵','氶','氷', '永',0,'氺','氻',0,0,'氾','氿', */
	/* 6c40 */ 0xc4f5,0xbdc1,0xb5e1,0,0,0,0,0, 0,0,0x8fc6d8,0x8fc6d9,0,0x8fc6da,0xc8c6,0x8fc6db, /* '汀','汁','求',0,0,0,0,0, 0,0,'汊','汋',0,'汍','汎','汏', */
	/* 6c50 */ 0xbcae,0,0x8fc6dc,0,0x8fc6dd,0xdde8,0,0xb4c0, 0,0x8fc6de,0xb1f8,0x8fc6df,0x8fc6e0,0xc6f2,0xdde7,0xb9be, /* '汐',0,'汒',0,'汔','汕',0,'汗', 0,'汙','汚','汛','汜','汝','汞','江', */
	/* 6c60 */ 0xc3d3,0,0xdde9,0,0,0,0,0x8fc7b6, 0xddf1,0,0xddea,0x8fc6e1,0,0x8fc6e2,0,0x8fc6e3, /* '池',0,'汢',0,0,0,0,'汧', '汨',0,'汪','汫',0,'汭',0,'汯', */
	/* 6c70 */ 0xc2c1,0,0xb5e2,0xddf2,0x8fc6e4,0,0x8fc6e5,0, 0x8fc6e6,0x8fc6e7,0xb7e8,0x8fc6e8,0,0xb5a5,0xddf0,0, /* '汰',0,'汲','汳','汴',0,'汶',0, '汸','汹','決','汻',0,'汽','汾',0, */
	/* 6c80 */ 0,0xddee,0xddeb,0xcde0,0,0x8fc6e9,0x8fc6ea,0x8fc6eb, 0xc4c0,0x8fc6ec,0,0,0xc6d9,0xddec,0,0, /* 0,'沁','沂','沃',0,'沅','沆','沇', '沈','沉',0,0,'沌','沍',0,0, */
	/* 6c90 */ 0xddf4,0,0xddf3,0xb7a3,0x8fc6ed,0x8fc6ee,0xb2ad,0x8fc6ef, 0x8fc6f0,0xbabb,0xdded,0xddef,0x8fc6f1,0,0,0x8fc6f2, /* '沐',0,'沒','沓','沔','沕','沖','沗', '沘','沙','沚','沛','沜',0,0,'沟', */
	/* 6ca0 */ 0,0xcbd7,0xc2f4,0,0,0,0,0, 0,0,0,0xcbf7,0,0,0xddfc,0, /* 0,'没','沢',0,0,0,0,0, 0,0,0,'沫',0,0,'沮',0, */
	/* 6cb0 */ 0x8fc6f3,0xddfd,0x8fc6f4,0xb2cf,0x8fc6f5,0,0,0, 0xcaa8,0xccfd,0xdea1,0xbca3,0xbec2,0xddf8,0xddfe,0xb1e8, /* '沰','沱','沲','河','沴',0,0,0, '沸','油','沺','治','沼','沽','沾','沿', */
	/* 6cc0 */ 0,0xb6b7,0x8fc6f6,0,0xddf5,0xddfa,0x8fc6f7,0, 0,0xc0f4,0xc7f1,0,0xc8e7,0x8fc6f8,0,0x8fc6f9, /* 0,'況','泂',0,'泄','泅','泆',0, 0,'泉','泊',0,'泌','泍',0,'泏', */
	/* 6cd0 */ 0x8fc6fa,0x8fc6fb,0x8fc6fc,0xddf7,0x8fc6fd,0xcba1,0x8fc6fe,0xddf9, 0,0xdea4,0x8fc7a1,0xdea2,0x8fc7a2,0xddfb,0,0, /* '泐','泑','泒','泓','泔','法','泖','泗', 0,'泙','泚','泛','泜','泝',0,0, */
	/* 6ce0 */ 0x8fc7a3,0xcba2,0xc7c8,0xb5e3,0,0xc5a5,0,0x8fc7a4, 0xc3ed,0x8fc7a5,0xdea5,0x8fc7a6,0x8fc7a7,0,0x8fc7a8,0xdea3, /* '泠','泡','波','泣',0,'泥',0,'泧', '注','泩','泪','泫','泬',0,'泮','泯', */
	/* 6cf0 */ 0xc2d9,0xddf6,0x8fc7a9,0xb1cb,0x8fc7aa,0,0,0, 0,0,0,0,0,0,0,0, /* '泰','泱','泲','泳','泴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6d00 */ 0,0,0,0,0x8fc7ab,0,0,0x8fc7ac, 0,0,0x8fc7ad,0xcdce,0xdeb0,0,0x8fc7ae,0x8fc7af, /* 0,0,0,0,'洄',0,0,'洇', 0,0,'洊','洋','洌',0,'洎','洏', */
	/* 6d10 */ 0,0x8fc7b0,0xdeaf,0x8fc7b1,0,0,0,0xc0f6, 0,0xdeac,0x8fc7b2,0xcdec,0,0,0xc6b6,0xdea6, /* 0,'洑','洒','洓',0,0,0,'洗', 0,'洙','洚','洛',0,0,'洞','洟', */
	/* 6d20 */ 0,0,0,0,0,0xc4c5,0x8fc7b3,0x8fc7b4, 0x8fc7b5,0xb1cc,0xb9bf,0xdea9,0,0,0x8fc7b7,0x8fc7b8, /* 0,0,0,0,0,'津','洦','洧', '洨','洩','洪','洫',0,0,'洮','洯', */
	/* 6d30 */ 0,0x8fc7b9,0xbda7,0xdeae,0,0xdead,0xdea8,0, 0xdeab,0x8fc7ba,0,0xb3e8,0x8fc7bb,0xdeaa,0xc7c9,0x8fc7bc, /* 0,'洱','洲','洳',0,'洵','洶',0, '洸','洹',0,'活','洼','洽','派','洿', */
	/* 6d40 */ 0,0xceae,0,0,0xbef4,0xc0f5,0,0, 0,0,0,0,0,0,0,0, /* 0,'流',0,0,'浄','浅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6d50 */ 0,0,0,0,0,0,0,0x8fc7bd, 0,0xdeb6,0xdeb4,0,0xc9cd,0,0x8fc7be,0x8fc7bf, /* 0,0,0,0,0,0,0,'浗', 0,'浙','浚',0,'浜',0,'浞','浟', */
	/* 6d60 */ 0,0x8fc7c0,0,0xdeb1,0xdeb3,0x8fc7c1,0xb1ba,0x8fc7c2, 0,0xb9c0,0xcfb2,0,0xb3bd,0,0xc9e2,0x8fc7c3, /* 0,'浡',0,'浣','浤','浥','浦','浧', 0,'浩','浪',0,'浬',0,'浮','浯', */
	/* 6d70 */ 0x8fc7c4,0,0,0,0xcde1,0,0,0xb3a4, 0xbfbb,0xdeb5,0,0,0x8fc7c5,0,0,0, /* '浰',0,0,0,'浴',0,0,'海', '浸','浹',0,0,'浼',0,0,0, */
	/* 6d80 */ 0,0,0x8fc7c6,0,0,0xdeba,0,0x8fc7c7, 0xbec3,0,0,0,0xcdb0,0,0xdeb7,0, /* 0,0,'涂',0,0,'涅',0,'涇', '消',0,0,0,'涌',0,'涎',0, */
	/* 6d90 */ 0,0x8fc7c8,0x8fc7c9,0xdeb2,0x8fc7ca,0xdeb8,0x8fc7cb,0x8fc7cc, 0x8fc7cd,0xcede,0,0xc5f3,0xc6c2,0,0,0, /* 0,'涑','涒','涓','涔','涕','涖','涗', '涘','涙',0,'涛','涜',0,0,0, */
	/* 6da0 */ 0,0,0,0,0,0,0,0, 0,0,0x8fc7ce,0,0x8fc7cf,0,0,0xb3b6, /* 0,0,0,0,0,0,0,0, 0,0,'涪',0,'涬',0,0,'涯', */
	/* 6db0 */ 0,0,0xb1d5,0,0x8fc7d0,0xdebe,0,0x8fc7d1, 0xdec1,0x8fc7d2,0,0,0xcec3,0x8fc7d3,0,0x8fc7d4, /* 0,0,'液',0,'涴','涵',0,'涷', '涸','涹',0,0,'涼','涽',0,'涿', */
	/* 6dc0 */ 0xcde4,0,0,0,0x8fc7d5,0xdec8,0xdec2,0xdebf, 0x8fc7d6,0,0x8fc7d7,0xced4,0xdec5,0,0x8fc7d8,0x8fc7d9, /* '淀',0,0,0,'淄','淅','淆','淇', '淈',0,'淊','淋','淌',0,'淎','淏', */
	/* 6dd0 */ 0,0xbdca,0xdec7,0,0,0xdecc,0x8fc7da,0, 0xc5f1,0xdeca,0,0x8fc7db,0,0x8fc7dc,0xdec4,0x8fc7dd, /* 0,'淑','淒',0,0,'淕','淖',0, '淘','淙',0,'淛',0,'淝','淞','淟', */
	/* 6de0 */ 0x8fc7de,0xc3b8,0x8fc7df,0,0xdecb,0x8fc7e0,0xdec0,0, 0xdec6,0x8fc7e1,0xdecd,0xb0fc,0xdec3,0,0xdece,0x8fc7e2, /* '淠','淡','淢',0,'淤','淥','淦',0, '淨','淩','淪','淫','淬',0,'淮','淯', */
	/* 6df0 */ 0x8fc7e3,0xbfbc,0x8ff4cc,0xbddf,0x8fc7e4,0xcaa5,0x8fc7e5,0xbaae, 0x8ff4cb,0xdebb,0xdec9,0xc5ba,0x8fc7e6,0,0,0, /* '淰','深','淲','淳','淴','淵','淶','混', '淸','淹','淺','添','淼',0,0,0, */
	/* 6e00 */ 0x8fc7e7,0,0,0,0x8fc7e8,0xc0b6,0,0xb3e9, 0xbad1,0xbec4,0xdebd,0xbdc2,0,0,0,0, /* '渀',0,0,0,'渄','清',0,'渇', '済','渉','渊','渋',0,0,0,0, */
	/* 6e10 */ 0,0,0,0xb7cc,0,0xdebc,0,0, 0,0xded2,0xbded,0xb8ba,0,0xdee1,0x8fc7e9,0xdedb, /* 0,0,0,'渓',0,'渕',0,0, 0,'渙','渚','減',0,'渝','渞','渟', */
	/* 6e20 */ 0xb5f4,0xc5cf,0x8fc7ea,0xded6,0xdedf,0xb0af,0xb1b2,0x8fc7eb, 0,0xb2b9,0,0xded8,0xc2ac,0xdecf,0xded1,0xb9c1, /* '渠','渡','渢','渣','渤','渥','渦','渧', 0,'温',0,'渫','測','渭','渮','港', */
	/* 6e30 */ 0,0,0x8fc7ec,0,0,0,0x8fc7ed,0, 0xdee2,0x8fc7ee,0xdedd,0x8fc7ef,0x8fc7f0,0,0xded5,0, /* 0,0,'渲',0,0,0,'渶',0, '游','渹','渺','渻','渼',0,'渾',0, */
	/* 6e40 */ 0,0,0,0xdedc,0x8fc7f1,0x8fc7f2,0,0, 0x8fc7f3,0x8fc7f4,0xccab,0x8fc7f5,0,0xdeda,0xdede,0x8fc7f6, /* 0,0,0,'湃','湄','湅',0,0, '湈','湉','湊','湋',0,'湍','湎','湏', */
	/* 6e50 */ 0,0x8fc7f7,0x8fc7f8,0x8fc7f9,0x8fc7fa,0,0xb8d0,0x8fc7fb, 0xbec5,0,0,0xc3b9,0x8fc7fc,0x8fc7fd,0x8fc7fe,0xded4, /* 0,'湑','湒','湓','湔',0,'湖','湗', '湘',0,0,'湛','湜','湝','湞','湟', */
	/* 6e60 */ 0,0,0x8fc8a1,0x8fc8a2,0,0,0,0xcdaf, 0x8fc8a3,0,0,0xded7,0,0,0xded0,0xc5f2, /* 0,0,'湢','湣',0,0,0,'湧', '湨',0,0,'湫',0,0,'湮','湯', */
	/* 6e70 */ 0,0,0xded3,0x8fc8a4,0,0,0xded9,0, 0,0,0,0x8fc8a5,0,0x8fc8a6,0xcfd1,0xbcbe, /* 0,0,'湲','湳',0,0,'湶',0, 0,0,0,'湻',0,'湽','湾','湿', */
	/* 6e80 */ 0xcbfe,0,0xdee3,0,0,0,0,0, 0,0,0,0,0xc8ae,0x8fc8a7,0,0xdeef, /* '満',0,'溂',0,0,0,0,0, 0,0,0,0,'溌','溍',0,'溏', */
	/* 6e90 */ 0xb8bb,0,0,0x8fc8a8,0,0,0xbde0,0, 0xdee5,0x8fc8a9,0,0,0xceaf,0xb9c2,0,0xdef2, /* '源',0,0,'溓',0,0,'準',0, '溘','溙',0,0,'溜','溝',0,'溟', */
	/* 6ea0 */ 0x8fc8aa,0,0xb0ee,0,0,0xdef0,0,0x8fc8ab, 0,0,0xdee4,0,0,0x8fc8ac,0x8fc8ad,0xdeea, /* '溠',0,'溢',0,0,'溥',0,'溧', 0,0,'溪',0,0,'溭','溮','溯', */
	/* 6eb0 */ 0,0x8fc8ae,0xdeec,0x8fc8af,0,0,0xcdcf,0xdee7, 0,0,0xc5ae,0x8fc8b0,0,0xdee9,0,0x8fc8b1, /* 0,'溱','溲','溳',0,0,'溶','溷', 0,0,'溺','溻',0,'溽',0,'溿', */
	/* 6ec0 */ 0x8fc8b2,0x8fc8b3,0xdef1,0x8fc8b4,0xdeeb,0xccc7,0,0x8fc8b5, 0x8fc8b6,0xdee6,0x8fc8b7,0xbca2,0xdefe,0x8fc8b8,0x8fc8b9,0x8fc8ba, /* '滀','滁','滂','滃','滄','滅',0,'滇', '滈','滉','滊','滋','滌','滍','滎','滏', */
	/* 6ed0 */ 0,0xb3ea,0,0xdee8,0xdeed,0xdeee,0,0, 0,0,0,0,0,0xc2ec,0xc2da,0, /* 0,'滑',0,'滓','滔','滕',0,0, 0,0,0,0,0,'滝','滞',0, */
	/* 6ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x8fc8bb,0xdef6,0x8fc8bc,0x8fc8bd,0xdefc, /* 0,0,0,0,0,0,0,0, 0,0,0,'滫','滬','滭','滮','滯', */
	/* 6ef0 */ 0,0,0xdefa,0,0xc5a9,0,0,0xdfa3, 0xdef7,0x8fc8be,0,0x8fc8bf,0,0x8fc8c0,0xdef8,0xdee0, /* 0,0,'滲',0,'滴',0,0,'滷', '滸','滹',0,'滻',0,'滽','滾','滿', */
	/* 6f00 */ 0,0xb5f9,0xc9ba,0,0x8fc8c1,0,0xbcbf,0, 0x8fc8c2,0xb9f7,0x8fc8c3,0,0x8fc8c4,0x8fc8c5,0,0xcfb3, /* 0,'漁','漂',0,'漄',0,'漆',0, '漈','漉','漊',0,'漌','漍',0,'漏', */
	/* 6f10 */ 0,0xdef4,0,0xdfa2,0xb1e9,0xc1e6,0x8fc8c6,0, 0x8fc8c7,0,0x8fc8c8,0x8fc8c9,0,0,0,0, /* 0,'漑',0,'漓','演','漕','漖',0, '漘',0,'漚','漛',0,0,0,0, */
	/* 6f20 */ 0xc7f9,0,0xb4c1,0xcefa,0,0,0x8fc8ca,0, 0,0x8fc8cb,0x8fc8cc,0xcca1,0xc4d2,0x8fc8d3,0,0x8fc8cd, /* '漠',0,'漢','漣',0,0,'漦',0, 0,'漩','漪','漫','漬','漭',0,'漯', */
	/* 6f30 */ 0x8fc8ce,0xdefb,0xdefd,0x8fc8cf,0,0,0x8fc8d0,0, 0xc1b2,0,0,0x8fc8d1,0x8fc8d2,0,0xdfa1,0xdef9, /* '漰','漱','漲','漳',0,0,'漶',0, '漸',0,0,'漻','漼',0,'漾','漿', */
	/* 6f40 */ 0,0xdef3,0,0,0,0xb4c3,0,0, 0,0,0,0,0,0,0,0x8fc8d4, /* 0,'潁',0,0,0,'潅',0,0, 0,0,0,0,0,0,0,'潏', */
	/* 6f50 */ 0,0x8fc8d5,0x8fc8d6,0x8fc8d7,0xb7e9,0,0,0x8fc8d8, 0xdfaf,0x8fc8d9,0x8fc8da,0xdfaa,0xc0f8,0x8fc8db,0x8fc8dc,0xb3e3, /* 0,'潑','潒','潓','潔',0,0,'潗', '潘','潙','潚','潛','潜','潝','潞','潟', */
	/* 6f60 */ 0,0x8fc8dd,0x8fc8de,0,0xbde1,0,0xdfb3,0, 0x8fc8df,0,0,0,0x8fc8e0,0xdfac,0xc4ac,0xdfa9, /* 0,'潡','潢',0,'潤',0,'潦',0, '潨',0,0,0,'潬','潭','潮','潯', */
	/* 6f70 */ 0xc4d9,0,0,0,0xdfcc,0,0,0, 0xdfa6,0,0xdfa5,0,0xdfae,0x8fc8e1,0x8fc8e2,0, /* '潰',0,0,0,'潴',0,0,0, '潸',0,'潺',0,'潼','潽','潾',0, */
	/* 6f80 */ 0xdfa8,0xdfa7,0xdfad,0x8fc8e3,0xc0a1,0,0xdfa4,0x8fc8e4, 0x8fc8e5,0,0,0x8fc8e6,0x8fc8e7,0x8fc8e8,0xdfb0,0, /* '澀','澁','澂','澃','澄',0,'澆','澇', '澈',0,0,'澋','澌','澍','澎',0, */
	/* 6f90 */ 0x8fc8e9,0xdfb1,0x8fc8ea,0x8fc8eb,0x8fc8ec,0,0x8fc8ed,0xb4c2, 0,0,0x8fc8ee,0,0,0,0,0x8fc8ef, /* '澐','澑','澒','澓','澔',0,'澖','澗', 0,0,'澚',0,0,0,0,'澟', */
	/* 6fa0 */ 0x8fc8f0,0xdfb6,0,0xdfb5,0xdfb7,0x8fc8f1,0x8fc8f2,0x8fc8f3, 0x8fc8f4,0,0xdfba,0,0,0,0x8fc8f5,0x8fc8f6, /* '澠','澡',0,'澣','澤','澥','澦','澧', '澨',0,'澪',0,0,0,'澮','澯', */
	/* 6fb0 */ 0x8fc8f7,0xc5c3,0,0xdfb4,0,0x8fc8f8,0x8fc8f9,0, 0,0xdfb8,0,0,0x8fc8fa,0,0,0, /* '澰','澱',0,'澳',0,'澵','澶',0, 0,'澹',0,0,'澼',0,0,0, */
	/* 6fc0 */ 0xb7e3,0xc2f9,0xdfb2,0xc7bb,0,0x8fc8fb,0xdfb9,0x8fc8fc, 0x8fc8fd,0,0x8fc8fe,0,0,0,0,0, /* '激','濁','濂','濃',0,'濅','濆','濇', '濈',0,'濊',0,0,0,0,0, */
	/* 6fd0 */ 0,0,0,0,0xdfbe,0xdfbc,0,0, 0xdfbf,0,0x8fc9a1,0xdfc2,0,0,0x8fc9a2,0xdfbb, /* 0,0,0,0,'濔','濕',0,0, '濘',0,'濚','濛',0,0,'濞','濟', */
	/* 6fe0 */ 0xb9ea,0xc7a8,0,0,0xdeb9,0,0,0, 0x8fc9a3,0x8fc9a4,0,0xcdf4,0xdfbd,0,0xdfc1,0xc2f5, /* '濠','濡',0,0,'濤',0,0,0, '濨','濩',0,'濫','濬',0,'濮','濯', */
	/* 6ff0 */ 0x8fc9a5,0xdfc0,0,0xdfab,0,0x8fc9a6,0xefe9,0, 0,0x8fc9a7,0xdfc5,0,0x8fc9a8,0x8fc9a9,0xdfc9,0, /* '濰','濱',0,'濳',0,'濵','濶',0, 0,'濹','濺',0,'濼','濽','濾',0, */
	/* 7000 */ 0x8fc9aa,0xdfc7,0,0,0,0x8fc9ab,0x8fc9ac,0x8fc9ad, 0,0xdfc3,0,0xdfc4,0,0x8fc9ae,0,0xdfc8, /* '瀀','瀁',0,0,0,'瀅','瀆','瀇', 0,'瀉',0,'瀋',0,'瀍',0,'瀏', */

	/* 7010 */ 0,0xdfc6,0,0,0,0xc9ce,0,0x8fc9af, 0xdfce,0,0xdfcb,0xdfca,0,0xdfcd,0xc6d4,0xdfcf, /* 0,'瀑',0,0,0,'瀕',0,'瀗', '瀘',0,'瀚','瀛',0,'瀝','瀞','瀟', */
	/* 7020 */ 0x8fc9b0,0,0,0x8fc9b1,0,0,0xc3f5,0xc2ed, 0x8ff4cd,0,0,0,0xc0a5,0,0,0x8fc9b2, /* '瀠',0,0,'瀣',0,0,'瀦','瀧', '瀨',0,0,0,'瀬',0,0,'瀯', */
	/* 7030 */ 0xdfd0,0,0xdfd2,0,0x8fc9b3,0,0,0x8fc9b4, 0,0x8fc9b5,0,0,0x8fc9b6,0,0xdfd1,0, /* '瀰',0,'瀲',0,'瀴',0,0,'瀷', 0,'瀹',0,0,'瀼',0,'瀾',0, */
	/* 7040 */ 0,0,0,0x8fc9b7,0x8fc9b8,0,0,0, 0x8fc9b9,0x8fc9ba,0x8fc9bb,0x8fc9bc,0xdef5,0,0x8fc9c1,0, /* 0,0,0,'灃','灄',0,0,0, '灈','灉','灊','灋','灌',0,'灎',0, */
	/* 7050 */ 0,0xdfd3,0,0,0x8fc9bd,0x8fc9be,0,0, 0xc6e7,0,0,0,0,0x8fc9bf,0x8fc9c0,0, /* 0,'灑',0,0,'灔','灕',0,0, '灘',0,0,0,0,'灝','灞',0, */
	/* 7060 */ 0,0,0,0xdfd4,0x8fc9c2,0x8fc9c3,0,0, 0,0,0,0xb2d0,0x8fc9c4,0,0x8fc9c5,0xc5f4, /* 0,0,0,'灣','灤','灥',0,0, 0,0,0,'火','灬',0,'灮','灯', */
	/* 7070 */ 0xb3a5,0,0,0,0,0x8fc9c6,0x8fc9c7,0, 0xb5e4,0,0,0,0xbcde,0xbad2,0x8fc9c8,0, /* '灰',0,0,0,0,'灵','灶',0, '灸',0,0,0,'灼','災','灾',0, */
	/* 7080 */ 0,0x8fc9c9,0,0,0,0x8fc9ca,0x8fc9cb,0, 0,0xcfa7,0xbfe6,0,0,0,0xb1ea,0, /* 0,'炁',0,0,0,'炅','炆',0, 0,'炉','炊',0,0,0,'炎',0, */
	/* 7090 */ 0,0,0xdfd6,0,0x8fc9cc,0x8fc9cd,0x8fc9ce,0x8fc9cf, 0x8fc9d0,0xdfd5,0,0x8fc9d1,0,0,0,0, /* 0,0,'炒',0,'炔','炕','炖','炗', '炘','炙',0,'炛',0,0,0,0, */
	/* 70a0 */ 0,0,0,0,0x8fc9d2,0,0,0, 0,0,0,0x8fc9d3,0xdfd9,0xc3ba,0xdfdc,0xdfd7, /* 0,0,0,0,'炤',0,0,0, 0,0,0,'炫','炬','炭','炮','炯', */
	/* 70b0 */ 0x8fc9d4,0x8fc9d5,0,0xdfdb,0x8fc9d6,0,0,0x8fc9d7, 0xdfda,0xc5c0,0xb0d9,0x8ff4ae,0,0,0,0, /* '炰','炱',0,'炳','炴',0,0,'炷', '炸','点','為','炻',0,0,0,0, */
	/* 70c0 */ 0,0,0,0,0,0,0,0, 0xcef5,0,0x8fc9d8,0xdfde,0,0,0,0xb1a8, /* 0,0,0,0,0,0,0,0, '烈',0,'烊','烋',0,0,0,'烏', */
	/* 70d0 */ 0,0x8fc9d9,0,0x8fc9da,0x8fc9db,0x8fc9dc,0x8fc9dd,0, 0x8fc9de,0xdfe0,0,0,0x8fc9df,0xdfdf,0,0xdfdd, /* 0,'烑',0,'烓','烔','烕','烖',0, '烘','烙',0,0,'烜','烝',0,'烟', */
	/* 70e0 */ 0,0,0,0,0x8fc9e0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'烤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 70f0 */ 0,0xdfd8,0,0,0,0,0,0, 0,0xcba3,0x8fc9e1,0,0,0xdfe2,0,0, /* 0,'烱',0,0,0,0,0,0, 0,'烹','烺',0,0,'烽',0,0, */
	/* 7100 */ 0,0,0,0x8fc9e2,0x8fc9e3,0x8fc9e4,0x8fc9e5,0x8fc9e6, 0,0xdfe1,0,0x8fc9e7,0x8fc9e8,0,0,0x8fc9e9, /* 0,0,0,'焃','焄','焅','焆','焇', 0,'焉',0,'焋','焌',0,0,'焏', */
	/* 7110 */ 0,0,0,0,0xb1eb,0,0,0, 0,0xdfe4,0xcab2,0,0xdfe3,0,0x8fc9ea,0, /* 0,0,0,0,'焔',0,0,0, 0,'焙','焚',0,'焜',0,'焞',0, */
	/* 7120 */ 0x8fc9eb,0xccb5,0,0,0,0,0xbec7,0, 0,0,0,0x8fc9ec,0,0x8fc9ed,0,0x8fc9ee, /* '焠','無',0,0,0,0,'焦',0, 0,0,0,'焫',0,'焭',0,'焯', */
	/* 7130 */ 0x8fc9ef,0x8fc9f0,0,0,0,0,0xc1b3,0, 0x8fc9f1,0,0,0,0xbec6,0,0,0, /* '焰','焱',0,0,0,0,'然',0, '焸',0,0,0,'焼',0,0,0, */
	/* 7140 */ 0,0x8fc9f2,0,0,0,0x8fc9f3,0x8fc9f4,0x8fc9f5, 0,0xcefb,0x8fc9f6,0x8fc9f7,0xdfea,0,0xc0f9,0, /* 0,'煁',0,0,0,'煅','煆','煇', 0,'煉','煊','煋','煌',0,'煎',0, */
	/* 7150 */ 0x8fc9f8,0,0x8fc9f9,0,0,0xdfe6,0xdfeb,0x8fc9fa, 0,0xb1ec,0x8fc9fb,0,0x8fc9fc,0,0x8fc9fd,0, /* '煐',0,'煒',0,0,'煕','煖','煗', 0,'煙','煚',0,'煜',0,'煞',0, */
	/* 7160 */ 0x8fc9fe,0,0xdfe9,0,0xc7e1,0xdfe5,0xdfe8,0xbec8, 0x8fcaa1,0xc8d1,0,0,0xdfec,0,0xbcd1,0, /* '煠',0,'煢',0,'煤','煥','煦','照', '煨','煩',0,0,'煬',0,'煮',0, */
	/* 7170 */ 0,0,0,0,0,0,0,0, 0,0x8fcaa2,0,0,0,0xc0fa,0,0, /* 0,0,0,0,0,0,0,0, 0,'煹',0,0,0,'煽',0,0, */
	/* 7180 */ 0x8fcaa3,0,0,0,0xdfef,0x8fcaa4,0,0x8fcaa5, 0xdfe7,0,0xb7a7,0,0x8fcaa6,0,0,0xdfed, /* '熀',0,0,0,'熄','熅',0,'熇', '熈',0,'熊',0,'熌',0,0,'熏', */
	/* 7190 */ 0,0,0x8fcaa7,0,0xcdd0,0xdff0,0,0, 0,0xf4a6,0x8fcaa8,0x8fcaa9,0,0,0,0xbdcf, /* 0,0,'熒',0,'熔','熕',0,0, 0,'熙','熚','熛',0,0,0,'熟', */
	/* 71a0 */ 0x8fcaaa,0,0x8fcaab,0,0,0,0,0, 0xdff1,0,0,0,0xdff2,0,0,0x8fcaac, /* '熠',0,'熢',0,0,0,0,0, '熨',0,0,0,'熬',0,0,'熯', */
	/* 71b0 */ 0x8fcaad,0xc7ae,0x8fcaae,0x8fcaaf,0,0,0,0, 0,0xdff4,0x8fcab0,0,0,0,0xdff5,0x8fcab1, /* '熰','熱','熲','熳',0,0,0,0, 0,'熹','熺',0,0,0,'熾','熿', */
	/* 71c0 */ 0x8fcab2,0x8fcab3,0,0xc7b3,0x8fcab4,0,0,0, 0xc5f5,0xdff7,0,0x8fcab5,0x8fcab6,0,0xdff9,0, /* '燀','燁',0,'燃','燄',0,0,0, '燈','燉',0,'燋','燌',0,'燎',0, */
	/* 71d0 */ 0xced5,0,0xdff6,0x8fcab7,0xdff8,0xb1ed,0x8fcab8,0xdff3, 0,0x8fcab9,0x8fcaba,0,0x8fcabb,0,0,0xd3db, /* '燐',0,'燒','燓','燔','燕','燖','燗', 0,'燙','燚',0,'燜',0,0,'營', */
	/* 71e0 */ 0xdffa,0,0,0,0,0xc1e7,0xbbb8,0xdffc, 0,0,0,0,0xdffb,0xbfa4,0xd2d9,0, /* '燠',0,0,0,0,'燥','燦','燧', 0,0,0,0,'燬','燭','燮',0, */
	/* 71f0 */ 0,0,0,0,0,0xdffd,0,0, 0x8fcabc,0xe0a1,0,0xdfee,0xdffe,0,0x8fcabd,0xe0a2, /* 0,0,0,0,0,'燵',0,0, '燸','燹',0,'燻','燼',0,'燾','燿', */
	/* 7200 */ 0x8fcabe,0,0,0,0,0,0xc7fa,0x8fcabf, 0x8fcac0,0x8fcac1,0,0,0,0xe0a3,0,0, /* '爀',0,0,0,0,0,'爆','爇', '爈','爉',0,0,0,'爍',0,0, */
	/* 7210 */ 0xe0a4,0,0,0x8fcac2,0,0,0,0x8fcac3, 0,0,0x8fcac4,0xe0a5,0,0x8fcac5,0,0x8fcac6, /* '爐',0,0,'爓',0,0,0,'爗', 0,0,'爚','爛',0,'爝',0,'爟', */
	/* 7220 */ 0,0,0,0,0x8fcac7,0,0,0, 0xe0a6,0,0xc4de,0x8fcac8,0xe0a8,0xe0a7,0,0x8fcac9, /* 0,0,0,0,'爤',0,0,0, '爨',0,'爪','爫','爬','爭',0,'爯', */
	/* 7230 */ 0xe0a9,0,0xe0aa,0,0x8fcaca,0xbcdf,0xc9e3,0, 0x8fcacb,0x8fcacc,0xccec,0xe0ab,0xe0ac,0xc1d6,0xbca4,0xe0ad, /* '爰',0,'爲',0,'爴','爵','父',0, '爸','爹','爺','爻','爼','爽','爾','爿', */
	/* 7240 */ 0xe0ae,0x8fcacd,0x8fcace,0x8fcacf,0,0x8fcad0,0xe0af,0xcad2, 0xc8c7,0,0,0xe0b0,0xc7d7,0,0x8fcad1,0x8fcad2, /* '牀','牁','牂','牃',0,'牅','牆','片', '版',0,0,'牋','牌',0,'牎','牏', */
	/* 7250 */ 0x8fcad3,0,0xc4ad,0x8fcad4,0,0x8fcad5,0x8fcad6,0, 0xe0b1,0xb2e7,0x8fcad7,0xb5ed,0x8fcad8,0xccc6,0x8fcad9,0xccb6, /* '牐',0,'牒','牓',0,'牕','牖',0, '牘','牙','牚','牛','牜','牝','牞','牟', */
	/* 7260 */ 0x8fcada,0xb2b4,0xcfb4,0x8fcadb,0,0,0,0xcbd2, 0x8fcadc,0xcaaa,0,0x8fcadd,0,0,0x8fcade,0x8fcadf, /* '牠','牡','牢','牣',0,0,0,'牧', '牨','物',0,'牫',0,0,'牮','牯', */
	/* 7270 */ 0,0x8fcae0,0xc0b7,0,0xe0b2,0,0,0x8fcae1, 0x8fcae2,0xc6c3,0,0x8fcae3,0x8fcae4,0xb8a3,0xe0b3,0x8fcae5, /* 0,'牱','牲',0,'牴',0,0,'牷', '牸','特',0,'牻','牼','牽','牾','牿', */
	/* 7280 */ 0xbad4,0xe0b5,0xe0b4,0,0x8fcae6,0,0,0xe0b6, 0,0x8fcae7,0,0,0,0x8fcae8,0x8fcae9,0, /* '犀','犁','犂',0,'犄',0,0,'犇', 0,'犉',0,0,0,'犍','犎',0, */
	/* 7290 */ 0,0,0xe0b7,0x8fcaea,0,0,0xe0b8,0, 0,0,0,0x8fcaeb,0,0,0,0, /* 0,0,'犒','犓',0,0,'犖',0, 0,0,0,'犛',0,0,0,0, */
	/* 72a0 */ 0xb5be,0,0xe0b9,0,0,0,0,0xe0ba, 0x8fcaec,0,0,0,0xb8a4,0x8fcaed,0x8fcaee,0xc8c8, /* '犠',0,'犢',0,0,0,0,'犧', '犨',0,0,0,'犬','犭','犮','犯', */
	/* 72b0 */ 0,0x8fcaef,0xe0bc,0,0x8fcaf0,0,0xbef5,0, 0,0xe0bb,0,0,0,0,0x8fcaf1,0, /* 0,'犱','犲',0,'犴',0,'状',0, 0,'犹',0,0,0,0,'犾',0, */
	/* 72c0 */ 0,0x8fcaf2,0xb6b8,0xe0bd,0xe0bf,0,0xe0be,0x8fcaf3, 0,0x8fcaf4,0,0,0x8fcaf5,0,0xe0c0,0, /* 0,'狁','狂','狃','狄',0,'狆','狇', 0,'狉',0,0,'狌',0,'狎',0, */
	/* 72d0 */ 0xb8d1,0,0xe0c1,0,0,0x8fcaf6,0x8fcaf7,0xb6e9, 0x8fcaf8,0xc1c0,0,0xb9fd,0,0,0,0x8fcaf9, /* '狐',0,'狒',0,0,'狕','狖','狗', '狘','狙',0,'狛',0,0,0,'狟', */
	/* 72e0 */ 0xe0c3,0xe0c4,0xe0c2,0,0,0x8fcafa,0,0, 0,0xbced,0,0,0xc6c8,0xb6b9,0,0, /* '狠','狡','狢',0,0,'狥',0,0, 0,'狩',0,0,'独','狭',0,0, */
	/* 72f0 */ 0,0,0,0x8fcafb,0x8fcafc,0,0,0xe0c6, 0xc3ac,0xe0c5,0x8fcafd,0x8fcafe,0xcfb5,0xc7e2,0x8fcba1,0, /* 0,0,0,'狳','狴',0,0,'狷', '狸','狹','狺','狻','狼','狽','狾',0, */
	/* 7300 */ 0,0,0x8fcba2,0,0x8fcba3,0x8fcba4,0,0x8fcba5, 0,0,0xe0c9,0x8fcba6,0,0x8fcba7,0,0, /* 0,0,'猂',0,'猄','猅',0,'猇', 0,0,'猊','猋',0,'猍',0,0, */
	/* 7310 */ 0,0,0x8fcba8,0x8fcba9,0,0,0xe0cb,0xe0c8, 0x8fcbaa,0x8fcbab,0,0xccd4,0xe0ca,0xe0cc,0x8fcbac,0xcec4, /* 0,0,'猒','猓',0,0,'猖','猗', '猘','猙',0,'猛','猜','猝','猞','猟', */
	/* 7320 */ 0,0,0x8fcbad,0,0x8fcbae,0xe0d0,0,0x8fcbaf, 0x8fcbb0,0xe0cf,0xc3f6,0xc7ad,0x8fcbb1,0,0xb8a5,0xe0ce, /* 0,0,'猢',0,'猤','猥',0,'猧', '猨','猩','猪','猫','猬',0,'献','猯', */
	/* 7330 */ 0,0x8fcbb2,0x8fcbb3,0,0xe0cd,0x8fcbb4,0xcdb1,0xcdb2, 0,0,0x8fcbb5,0x8fcbb6,0,0x8fcbb7,0xe0d1,0xb1ee, /* 0,'猱','猲',0,'猴','猵','猶','猷', 0,0,'猺','猻',0,'猽','猾','猿', */
	/* 7340 */ 0,0,0,0x8fcbb8,0xb9f6,0xbbe2,0,0, 0,0,0,0,0,0x8fcbb9,0xe0d2,0xe0d3, /* 0,0,0,'獃','獄','獅',0,0, 0,0,0,0,0,'獍','獎','獏', */
	/* 7350 */ 0x8fcbba,0,0x8fcbbb,0,0,0,0x8fcbbc,0xe0d5, 0x8fcbbd,0,0,0,0,0x8fcbbe,0x8fcbbf,0x8fcbc0, /* '獐',0,'獒',0,0,0,'獖','獗', '獘',0,0,0,0,'獝','獞','獟', */
	/* 7360 */ 0x8fcbc1,0,0,0xbdc3,0,0,0x8fcbc2,0x8fcbc3, 0xe0d7,0x8fcbc4,0xe0d6,0x8fcbc5,0x8fcbc6,0,0x8fcbc7,0x8fcbc8, /* '獠',0,0,'獣',0,0,'獦','獧', '獨','獩','獪','獫','獬',0,'獮','獯', */
	/* 7370 */ 0xe0d8,0x8fcbc9,0xb3cd,0,0,0xe0da,0,0x8fcbca, 0xe0d9,0x8fcbcb,0xe0dc,0xe0db,0x8fcbcc,0,0,0, /* '獰','獱','獲',0,0,'獵',0,'獷', '獸','獹','獺','獻','獼',0,0,0, */
	/* 7380 */ 0x8fcbcd,0x8fcbce,0,0x8fcbcf,0xb8bc,0x8fcbd0,0x8fcbd1,0xcea8, 0,0xb6cc,0,0xb2a6,0,0,0x8fcbd2,0, /* '玀','玁',0,'玃','玄','玅','玆','率', 0,'玉',0,'王',0,0,'玎',0, */
	/* 7390 */ 0x8fcbd3,0,0,0x8fcbd4,0,0x8fcbd5,0xb6ea,0x8fcbd6, 0x8fcbd7,0,0,0,0x8fcbd8,0,0x8fcbd9,0x8fcbda, /* '玐',0,0,'玓',0,'玕','玖','玗', '玘',0,0,0,'玜',0,'玞','玟', */
	/* 73a0 */ 0x8fcbdb,0,0x8fcbdc,0,0,0x8fcbdd,0x8fcbde,0, 0,0xb4e1,0x8fcbdf,0x8fcbe0,0,0x8fcbe1,0,0, /* '玠',0,'玢',0,0,'玥','玦',0, 0,'玩','玪','玫',0,'玭',0,0, */
	/* 73b0 */ 0,0,0xcee8,0xe0de,0,0x8fcbe2,0,0x8fcbe3, 0,0x8fcbe4,0,0xe0e0,0x8fcbe5,0x8fcbe6,0,0x8fcbe7, /* 0,0,'玲','玳',0,'玵',0,'玷', 0,'玹',0,'玻','玼','玽',0,'玿', */
	/* 73c0 */ 0xe0e1,0,0xb2d1,0,0,0x8fcbe8,0x8fcbe9,0, 0xe0dd,0x8fcbea,0xbbb9,0x8fcbeb,0x8fcbec,0xc4c1,0xe0df,0x8fcbed, /* '珀',0,'珂',0,0,'珅','珆',0, '珈','珉','珊','珋','珌','珍','珎','珏', */
	/* 73d0 */ 0,0,0x8fcbee,0x8fcbef,0,0,0x8fcbf0,0, 0,0x8fcbf1,0,0,0,0x8fcbf2,0xe0e4,0, /* 0,0,'珒','珓',0,0,'珖',0, 0,'珙',0,0,0,'珝','珞',0, */
	/* 73e0 */ 0xbcee,0x8fcbf3,0,0x8fcbf4,0,0xe0e2,0x8fcbf5,0x8fcbf6, 0,0x8fcbf7,0xb7be,0,0,0xc8c9,0xe0e3,0, /* '珠','珡',0,'珣',0,'珥','珦','珧', 0,'珩','珪',0,0,'班','珮',0, */
	/* 73f0 */ 0,0xe0fe,0,0,0x8fcbf8,0x8fcbf9,0,0x8fcbfa, 0xe0e9,0x8fcbfb,0x8fcbfc,0x8fcbfd,0,0x8fcbfe,0xb8bd,0x8fcca1, /* 0,'珱',0,0,'珴','珵',0,'珷', '珸','珹','珺','珻',0,'珽','現','珿', */
	/* 7400 */ 0x8fcca2,0x8fcca3,0,0xb5e5,0x8fcca4,0xe0e6,0xcdfd,0x8fcca5, 0,0xceb0,0x8fcca6,0,0,0,0,0, /* '琀','琁',0,'球','琄','琅','理','琇', 0,'琉','琊',0,0,0,0,0, */
	/* 7410 */ 0,0x8fcca7,0,0,0,0,0,0, 0,0,0x8fcca8,0x8fcca9,0,0,0,0, /* 0,'琑',0,0,0,0,0,0, 0,0,'琚','琛',0,0,0,0, */
	/* 7420 */ 0,0,0xc2f6,0,0x8fccaa,0xe0e8,0x8fccab,0, 0x8fccac,0x8fccad,0x8fccae,0x8fccaf,0x8fccb0,0x8fccb1,0x8fccb2,0x8fccb3, /* 0,0,'琢',0,'琤','琥','琦',0, '琨','琩','琪','琫','琬','琭','琮','琯', */
	/* 7430 */ 0x8fccb4,0x8fccb5,0xe0ea,0xced6,0xb6d7,0xc8fc,0xc7ca,0, 0,0x8fccb6,0xe0eb,0,0,0,0,0xe0ed, /* '琰','琱','琲','琳','琴','琵','琶',0, 0,'琹','琺',0,0,0,0,'琿', */
	/* 7440 */ 0x8fccb7,0xe0f0,0,0x8fccb8,0x8fccb9,0,0x8fccba,0x8fccbb, 0,0,0,0x8fccbc,0,0x8fccbd,0,0, /* '瑀','瑁',0,'瑃','瑄',0,'瑆','瑇', 0,0,0,'瑋',0,'瑍',0,0, */
	/* 7450 */ 0,0x8fccbe,0x8fccbf,0,0,0xe0ec,0,0x8fccc0, 0,0xe0ef,0xb8ea,0xb1cd,0xe0f1,0x8fccc1,0xbff0,0xe0ee, /* 0,'瑑','瑒',0,0,'瑕',0,'瑗', 0,'瑙','瑚','瑛','瑜','瑝','瑞','瑟', */
	/* 7460 */ 0xcedc,0,0x8fccc2,0xe0f4,0xf4a4,0,0x8fccc3,0x8fccc4, 0x8fccc5,0xe0f2,0xe0f5,0x8fccc6,0,0x8fccc7,0x8fccc8,0xe0e7, /* '瑠',0,'瑢','瑣','瑤',0,'瑦','瑧', '瑨','瑩','瑪','瑫',0,'瑭','瑮','瑯', */
	/* 7470 */ 0xe0f3,0x8fccc9,0x8fccca,0xbabc,0,0,0xe0f6,0, 0,0,0,0,0,0,0xe0f7,0, /* '瑰','瑱','瑲','瑳',0,0,'瑶',0, 0,0,0,0,0,0,'瑾',0, */
	/* 7480 */ 0x8fcccb,0x8fcccc,0,0xcdfe,0,0x8fcccd,0x8fccce,0x8fcccf, 0,0x8fccd0,0,0xe0f8,0,0,0,0x8fccd1, /* '璀','璁',0,'璃',0,'璅','璆','璇', 0,'璉',0,'璋',0,0,0,'璏', */
	/* 7490 */ 0x8fccd2,0x8fccd3,0x8fccd4,0,0,0,0,0, 0x8fccd5,0x8fccd6,0x8fccd7,0,0x8fccd8,0,0xe0f9,0x8fccd9, /* '璐','璑','璒',0,0,0,0,0, '璘','璙','璚',0,'璜',0,'璞','璟', */
	/* 74a0 */ 0x8fccda,0x8fccdb,0xe0e5,0x8fccdc,0,0,0x8fccdd,0xe0fa, 0x8fccde,0x8fccdf,0x8fcce0,0x8fcce1,0,0,0x8fcce2,0x8fcce3, /* '璠','璡','璢','璣',0,0,'璦','璧', '璨','璩','璪','璫',0,0,'璮','璯', */
	/* 74b0 */ 0xb4c4,0x8fcce4,0x8fcce5,0,0,0x8fcce6,0,0, 0,0x8fcce7,0,0x8fcce8,0,0xbca5,0,0x8fcce9, /* '環','璱','璲',0,0,'璵',0,0, 0,'璹',0,'璻',0,'璽',0,'璿', */
	/* 74c0 */ 0,0,0,0,0,0,0,0, 0x8fccea,0x8fcceb,0xe0fb,0,0x8fccec,0,0,0xe0fc, /* 0,0,0,0,0,0,0,0, '瓈','瓉','瓊',0,'瓌',0,0,'瓏', */
	/* 74d0 */ 0x8fcced,0,0,0x8fccee,0xe0fd,0,0,0, 0x8fccef,0,0x8fccf0,0x8fccf1,0xb1bb,0,0x8fccf2,0x8fccf3, /* '瓐',0,0,'瓓','瓔',0,0,0, '瓘',0,'瓚','瓛','瓜',0,'瓞','瓟', */
	/* 74e0 */ 0xe1a1,0,0xc9bb,0xe1a2,0x8fccf4,0,0xb4a4,0xe1a3, 0x8fccf5,0xe1a4,0x8fccf6,0x8fccf7,0,0,0xe1a5,0x8fccf8, /* '瓠',0,'瓢','瓣','瓤',0,'瓦','瓧', '瓨','瓩','瓪','瓫',0,0,'瓮','瓯', */
	/* 74f0 */ 0xe1a7,0xe1a8,0xe1a6,0,0x8fccf9,0,0xc9d3,0xe1aa, 0xe1a9,0,0x8fccfa,0x8fccfb,0x8fccfc,0,0,0x8fccfd, /* '瓰','瓱','瓲',0,'瓴',0,'瓶','瓷', '瓸',0,'瓺','瓻','瓼',0,0,'瓿', */
	/* 7500 */ 0,0x8ff4d0,0,0xe1ac,0xe1ab,0xe1ad,0x8fccfe,0, 0,0,0,0,0xe1ae,0xe1b0,0xe1af,0, /* 0,'甁',0,'甃','甄','甅','甆',0, 0,0,0,0,'甌','甍','甎',0, */
	/* 7510 */ 0,0xb9f9,0x8fcda1,0xe1b2,0,0xe1b1,0x8fcda2,0x8fcda3, 0xb4c5,0,0xbfd3,0,0xc5bc,0,0xe1b3,0xc0b8, /* 0,'甑','甒','甓',0,'甕','甖','甗', '甘',0,'甚',0,'甜',0,'甞','生', */
	/* 7520 */ 0x8fcda4,0x8fcda5,0,0xbbba,0x8fcda6,0xb1f9,0xe1b4,0x8fcda7, 0xcdd1,0x8fcda8,0x8fcda9,0xcae3,0xe1b5,0,0,0x8fcdaa, /* '甠','甡',0,'産','甤','甥','甦','甧', '用','甩','甪','甫','甬',0,0,'甯', */
	/* 7530 */ 0xc5c4,0xcdb3,0xb9c3,0xbfbd,0,0,0x8fcdab,0xc3cb, 0xd2b4,0x8fcdac,0xc4ae,0xb2e8,0xe1b6,0x8fcdad,0x8fcdae,0x8fcdaf, /* '田','由','甲','申',0,0,'甶','男', '甸','甹','町','画','甼','甽','甾','甿', */
	/* 7540 */ 0x8fcdb0,0,0,0x8fcdb1,0xe1b7,0,0xe1bc,0x8fcdb2, 0x8fcdb3,0xe1ba,0xe1b9,0xdac2,0xb3a6,0xe1b8,0x8fcdb4,0xb0da, /* '畀',0,0,'畃','畄',0,'畆','畇', '畈','畉','畊','畋','界','畍','畎','畏', */
	/* 7550 */ 0x8fcdb5,0xc8aa,0x8fcdb6,0,0xc8ca,0,0,0x8fcdb7, 0,0xceb1,0xe1bd,0xe1bb,0xc3dc,0xc0a6,0x8fcdb8,0x8fcdb9, /* '畐','畑','畒',0,'畔',0,0,'畗', 0,'留','畚','畛','畜','畝','畞','畟', */
	/* 7560 */ 0xc8ab,0x8fcdba,0xc9ad,0,0xe1bf,0xceac,0xb7cd,0xe1c0, 0,0xe1be,0xc8d6,0xe1c1,0,0xe1c2,0,0x8fcdbb, /* '畠','畡','畢',0,'畤','略','畦','畧', 0,'畩','番','畫',0,'畭',0,'畯', */
	/* 7570 */ 0xb0db,0x8fcdbc,0,0xbef6,0xe1c7,0,0xe1c4,0xc6ed, 0xe1c3,0x8fcdbd,0x8fcdbe,0x8fcdbf,0x8fcdc0,0x8fcdc1,0x8fcdc2,0xb5a6, /* '異','畱',0,'畳','畴',0,'當','畷', '畸','畹','畺','畻','畼','畽','畾','畿', */
	/* 7580 */ 0,0x8fcdc3,0xe1ca,0,0,0x8fcdc4,0xe1c5,0xe1c6, 0,0xe1c9,0xe1c8,0xc9a5,0,0,0xc1c2,0xc1c1, /* 0,'疁','疂',0,0,'疅','疆','疇', 0,'疉','疊','疋',0,0,'疎','疏', */
	/* 7590 */ 0x8fcdc5,0xb5bf,0x8fcdc6,0x8fcdc7,0xe1cb,0x8fcdc8,0,0, 0,0x8fcdc9,0xe1cc,0,0x8fcdca,0xe1cd,0,0, /* '疐','疑','疒','疓','疔','疕',0,0, 0,'疙','疚',0,'疜','疝',0,0, */
	/* 75a0 */ 0,0,0x8fcdcb,0xe1cf,0x8fcdcc,0xe1ce,0,0, 0,0,0,0xb1d6,0,0,0,0, /* 0,0,'疢','疣','疤','疥',0,0, 0,0,0,'疫',0,0,0,0, */
	/* 75b0 */ 0,0xe1d7,0xc8e8,0xe1d1,0x8fcdcd,0xe1d3,0,0, 0xe1d5,0xbfbe,0x8fcdce,0,0xe1d6,0xe1d4,0xbcc0,0x8fcdcf, /* 0,'疱','疲','疳','疴','疵',0,0, '疸','疹','疺',0,'疼','疽','疾','疿', */
	/* 75c0 */ 0x8fcdd0,0x8fcdd1,0xe1d0,0xe1d2,0x8fcdd2,0xc9c2,0x8fcdd3,0xbec9, 0,0,0xe1d9,0,0x8fcdd4,0xe1d8,0x8fcdd5,0x8fcdd6, /* '痀','痁','痂','痃','痄','病','痆','症', 0,0,'痊',0,'痌','痍','痎','痏', */
	/* 75d0 */ 0,0,0xe1da,0,0xbca6,0xbaaf,0,0x8fcdd7, 0xc5f7,0xe1db,0,0xc4cb,0x8fcdd8,0,0xe1dd,0x8fcdd9, /* 0,0,'痒',0,'痔','痕',0,'痗', '痘','痙',0,'痛','痜',0,'痞','痟', */
	/* 75e0 */ 0x8fcdda,0x8fcddb,0xcea1,0xe1dc,0x8fcddc,0,0,0x8fcddd, 0,0xc1e9,0,0,0x8fcdde,0,0x8fcddf,0x8fcde0, /* '痠','痡','痢','痣','痤',0,0,'痧', 0,'痩',0,0,'痬',0,'痮','痯', */
	/* 75f0 */ 0xe1e2,0x8fcde1,0xe1e4,0xe1e5,0xc3d4,0,0,0, 0,0x8fcde2,0xe1e3,0,0xe1e0,0,0xe1de,0xe1df, /* '痰','痱','痲','痳','痴',0,0,0, 0,'痹','痺',0,'痼',0,'痾','痿', */
	/* 7600 */ 0x8fcde3,0xe1e1,0x8fcde4,0x8fcde5,0x8fcde6,0,0,0x8fcde7, 0x8fcde8,0xe1e8,0x8fcde9,0xe1e6,0x8fcdea,0xe1e7,0,0x8fcdeb, /* '瘀','瘁','瘂','瘃','瘄',0,0,'瘇', '瘈','瘉','瘊','瘋','瘌','瘍',0,'瘏', */
	/* 7610 */ 0,0,0x8fcdec,0x8fcded,0,0x8fcdee,0x8fcdef,0, 0,0x8fcdf0,0,0x8fcdf1,0x8fcdf2,0x8fcdf3,0x8fcdf4,0xe1e9, /* 0,0,'瘒','瘓',0,'瘕','瘖',0, 0,'瘙',0,'瘛','瘜','瘝','瘞','瘟', */
	/* 7620 */ 0xe1eb,0xe1ec,0xe1ed,0x8fcdf5,0xe1ee,0x8fcdf6,0x8fcdf7,0xe1ea, 0,0x8fcdf8,0,0,0,0x8fcdf9,0,0, /* '瘠','瘡','瘢','瘣','瘤','瘥','瘦','瘧', 0,'瘩',0,0,0,'瘭',0,0, */
	/* 7630 */ 0xe1f0,0,0x8fcdfa,0x8fcdfb,0xe1ef,0x8fcdfc,0,0, 0x8fcdfd,0x8fcdfe,0x8fcea1,0xe1f1,0x8fcea2,0,0,0, /* '瘰',0,'瘲','瘳','瘴','瘵',0,0, '瘸','瘹','瘺','瘻','瘼',0,0,0, */
	/* 7640 */ 0x8fcea4,0x8fcea5,0xcec5,0x8fcea6,0x8fcea7,0x8fcea8,0xe1f4,0xe1f2, 0xe1f3,0x8fcea9,0x8fcea3,0x8fceaa,0xb4e2,0,0,0, /* '癀','癁','療','癃','癄','癅','癆','癇', '癈','癉','癊','癋','癌',0,0,0, */
	/* 7650 */ 0,0,0xccfe,0,0,0x8fceab,0xcaca,0, 0xe1f6,0x8fceac,0,0,0xe1f5,0,0,0x8fcead, /* 0,0,'癒',0,0,'癕','癖',0, '癘','癙',0,0,'癜',0,0,'癟', */
	/* 7660 */ 0,0xe1f7,0xe1f8,0,0x8fceae,0x8fceaf,0,0xe1fc, 0xe1f9,0xe1fa,0xe1fb,0,0xe1fd,0x8fceb0,0x8fceb1,0x8fceb2, /* 0,'癡','癢',0,'癤','癥',0,'癧', '癨','癩','癪',0,'癬','癭','癮','癯', */
	/* 7670 */ 0xe1fe,0x8fceb3,0xe2a1,0,0x8fceb4,0,0xe2a2,0, 0xe2a3,0,0xc8af,0xc5d0,0xe2a4,0xc7f2,0xc9b4,0, /* '癰','癱','癲',0,'癴',0,'癶',0, '癸',0,'発','登','發','白','百',0, */
	/* 7680 */ 0xe2a5,0x8fceb5,0x8ff4d1,0xe2a6,0xc5aa,0x8fceb6,0xb3a7,0xb9c4, 0xe2a7,0,0,0xe2a8,0x8fceb7,0x8fceb8,0xe2a9,0, /* '皀','皁','皂','皃','的','皅','皆','皇', '皈',0,0,'皋','皌','皍','皎',0, */
	/* 7690 */ 0xbba9,0,0,0xe2ab,0,0x8fceb9,0xe2aa,0, 0,0xe2ac,0xe2ad,0x8fceba,0x8fcebb,0x8fcebc,0x8ff4d2,0x8fcebd, /* '皐',0,0,'皓',0,'皕','皖',0, 0,'皙','皚','皛','皜','皝','皞','皟', */
	/* 76a0 */ 0x8fcebe,0,0x8fcebf,0x8fcec0,0x8fcec1,0x8fcec2,0x8fcec3,0x8fcec4, 0x8fcec5,0,0x8fcec6,0,0,0x8fcec7,0xc8e9,0, /* '皠',0,'皢','皣','皤','皥','皦','皧', '皨',0,'皪',0,0,'皭','皮',0, */
	/* 76b0 */ 0xe2ae,0,0,0,0xe2af,0,0,0xf3e9, 0xe2b0,0xe2b1,0xe2b2,0,0,0x8fcec8,0,0xbbae, /* '皰',0,0,0,'皴',0,0,'皷', '皸','皹','皺',0,0,'皽',0,'皿', */
	/* 76c0 */ 0,0x8fcec9,0xe2b3,0xc7d6,0,0x8fceca,0xcbdf,0, 0xb1ce,0x8fcecb,0xb1d7,0x8fcecc,0x8fcecd,0xe2b4,0x8fcece,0, /* 0,'盁','盂','盃',0,'盅','盆',0, '盈','盉','益','盋','盌','盍','盎',0, */
	/* 76d0 */ 0,0,0xe2b6,0,0x8fcecf,0,0xe2b5,0xc5f0, 0,0x8fced0,0,0xc0b9,0xddb9,0,0xe2b7,0xccc1, /* 0,0,'盒',0,'盔',0,'盖','盗', 0,'盙',0,'盛','盜',0,'盞','盟', */
	/* 76e0 */ 0x8fced1,0xe2b8,0,0xb4c6,0xc8d7,0xe2b9,0x8fced2,0xe2ba, 0x8fced3,0,0xe2bb,0,0x8fced4,0,0xccdc,0, /* '盠','盡',0,'監','盤','盥','盦','盧', '盨',0,'盪',0,'盬',0,'目',0, */
	/* 76f0 */ 0x8fced5,0x8fced6,0xccd5,0,0xc4be,0,0x8fced7,0, 0xc1ea,0x8fced8,0,0xe2bd,0x8fced9,0,0xbde2,0, /* '盰','盱','盲',0,'直',0,'盶',0, '相','盹',0,'盻','盼',0,'盾',0, */
	/* 7700 */ 0x8fceda,0xbeca,0,0,0xe2c0,0,0x8fcedb,0xe2bf, 0xe2be,0xc8fd,0x8fcedc,0xb4c7,0xb8a9,0,0x8fcedd,0, /* '眀','省',0,0,'眄',0,'眆','眇', '眈','眉','眊','看','県',0,'眎',0, */
	/* 7710 */ 0,0,0x8fcede,0,0x8fcedf,0x8fcee0,0,0x8fcee1, 0,0x8fcee2,0x8fcee3,0xe2c6,0x8fcee4,0,0xe2c3,0xbfbf, /* 0,0,'眒',0,'眔','眕',0,'眗', 0,'眙','眚','眛','眜',0,'眞','真', */
	/* 7720 */ 0xccb2,0,0x8fcee5,0,0xe2c2,0xe2c4,0xe2c5,0, 0x8fcee6,0xe2c1,0,0,0,0x8fcee7,0x8fcee8,0x8fcee9, /* '眠',0,'眢',0,'眤','眥','眦',0, '眨','眩',0,0,0,'眭','眮','眯', */
	/* 7730 */ 0,0,0,0,0x8fceea,0x8fceeb,0x8fceec,0xe2c7, 0xe2c8,0x8fceed,0xc4af,0,0xb4e3,0x8fceee,0x8fceef,0, /* 0,0,0,0,'眴','眵','眶','眷', '眸','眹','眺',0,'眼','眽','眾',0, */
	/* 7740 */ 0xc3e5,0,0x8fcef0,0,0,0x8fcef1,0x8fcef2,0xe2c9, 0,0,0x8fcef3,0,0,0x8fcef4,0x8fcef5,0x8fcef6, /* '着',0,'睂',0,0,'睅','睆','睇', 0,0,'睊',0,0,'睍','睎','睏', */
	/* 7750 */ 0,0,0x8fcef7,0,0,0,0x8fcef8,0x8fcef9, 0,0,0xe2ca,0xe2cd,0x8fcefa,0,0x8fcefb,0x8fcefc, /* 0,0,'睒',0,0,0,'睖','睗', 0,0,'睚','睛','睜',0,'睞','睟', */
	/* 7760 */ 0x8fcefd,0xbfe7,0x8fcefe,0xc6c4,0x8fcfa1,0xe2ce,0xcbd3,0x8fcfa2, 0xe2cb,0,0x8fcfa3,0xe2cc,0x8fcfa4,0,0,0, /* '睠','睡','睢','督','睤','睥','睦','睧', '睨',0,'睪','睫','睬',0,0,0, */
	/* 7770 */ 0x8fcfa5,0,0x8fcfa6,0x8fcfa7,0x8fcfa8,0,0,0, 0,0xe2d1,0x8fcfa9,0,0,0x8fcfaa,0xe2d0,0xe2cf, /* '睰',0,'睲','睳','睴',0,0,0, 0,'睹','睺',0,0,'睽','睾','睿', */
	/* 7780 */ 0x8fcfab,0,0,0,0x8fcfac,0,0,0, 0,0,0,0xe2d3,0x8fcfad,0x8fcfae,0xe2d2,0, /* '瞀',0,0,0,'瞄',0,0,0, 0,0,0,'瞋','瞌','瞍','瞎',0, */
	/* 7790 */ 0,0xe2d4,0,0,0x8fcfaf,0x8fcfb0,0x8fcfb1,0, 0,0,0x8fcfb2,0,0,0,0xe2d6,0x8fcfb3, /* 0,'瞑',0,0,'瞔','瞕','瞖',0, 0,0,'瞚',0,0,0,'瞞','瞟', */
	/* 77a0 */ 0xe2d5,0,0x8fcfb4,0,0,0xcacd,0,0x8fcfb5, 0,0,0x8fcfb6,0,0xbdd6,0xcec6,0x8fcfb7,0x8fcfb8, /* '瞠',0,'瞢',0,0,'瞥',0,'瞧', 0,0,'瞪',0,'瞬','瞭','瞮','瞯', */
	/* 77b0 */ 0xe2d7,0x8fcfb9,0,0xc6b7,0,0x8fcfba,0xe2d8,0, 0,0xe2d9,0,0xe2dd,0xe2db,0xe2dc,0x8fcfbb,0xe2da, /* '瞰','瞱',0,'瞳',0,'瞵','瞶',0, 0,'瞹',0,'瞻','瞼','瞽','瞾','瞿', */
	/* 77c0 */ 0,0,0,0x8fcfbc,0,0,0,0xe2de, 0,0x8fcfbd,0,0,0,0xe2df,0,0, /* 0,0,0,'矃',0,0,0,'矇', 0,'矉',0,0,0,'矍',0,0, */
	/* 77d0 */ 0,0x8fcfbe,0x8fcfbf,0,0,0x8fcfc0,0,0xe2e0, 0,0x8fcfc1,0xe2e1,0xccb7,0xe2e2,0,0x8fcfc2,0x8fcfc3, /* 0,'矑','矒',0,0,'矕',0,'矗', 0,'矙','矚','矛','矜',0,'矞','矟', */
	/* 77e0 */ 0x8fcfc4,0,0xccf0,0xe2e3,0x8fcfc5,0xc3ce,0x8fcfc6,0xc7ea, 0,0xb6eb,0x8fcfc7,0,0x8fcfc8,0xc3bb,0xe2e4,0xb6ba, /* '矠',0,'矢','矣','矤','知','矦','矧', 0,'矩','矪',0,'矬','短','矮','矯', */
	/* 77f0 */ 0x8fcfc9,0x8fcfca,0,0xc0d0,0x8fcfcb,0,0,0, 0x8fcfcc,0,0,0x8fcfcd,0xe2e5,0,0,0, /* '矰','矱',0,'石','矴',0,0,0, '矸',0,0,'矻','矼',0,0,0, */
	/* 7800 */ 0,0,0xbabd,0,0,0x8fcfce,0x8fcfcf,0, 0,0x8fcfd0,0,0,0xe2e6,0x8fcfd1,0x8fcfd2,0, /* 0,0,'砂',0,0,'砅','砆',0, 0,'砉',0,0,'砌','砍','砎',0, */
	/* 7810 */ 0,0x8fcfd3,0xe2e7,0,0xb8a6,0xbad5,0,0, 0,0,0,0,0,0x8fcfd4,0,0, /* 0,'砑','砒',0,'研','砕',0,0, 0,0,0,0,0,'砝',0,0, */
	/* 7820 */ 0xe2e9,0x8fcfd5,0x8fcfd6,0x8fcfd7,0,0xc5d6,0xbad6,0xb5ce, 0,0,0,0,0,0x8fcfd8,0x8fcfd9,0, /* '砠','砡','砢','砣',0,'砥','砦','砧', 0,0,0,0,0,'砭','砮',0, */
	/* 7830 */ 0x8fcfda,0,0xcba4,0,0xc7cb,0x8fcfdb,0,0x8fcfdc, 0,0,0xc5d7,0,0,0,0,0xb9dc, /* '砰',0,'砲',0,'破','砵',0,'砷', 0,0,'砺',0,0,0,0,'砿', */
	/* 7840 */ 0,0,0,0x8fcfdd,0x8fcfde,0xe2eb,0,0x8fcfdf, 0x8fcfe0,0,0,0,0x8fcfe1,0,0x8fcfe2,0, /* 0,0,0,'硃','硄','硅',0,'硇', '硈',0,0,0,'硌',0,'硎',0, */
	/* 7850 */ 0,0,0x8fcfe3,0,0,0,0,0, 0,0,0,0,0x8fcfe4,0xbecb,0x8fcfe5,0, /* 0,0,'硒',0,0,0,0,0, 0,0,0,0,'硜','硝','硞',0, */
	/* 7860 */ 0x8fcfe6,0x8fcfe7,0,0x8fcfe8,0x8fcfe9,0,0,0, 0x8fcfea,0,0x8fcfeb,0xceb2,0xb9c5,0,0x8fcfec,0xb8a7, /* '硠','硡',0,'硣','硤',0,0,0, '硨',0,'硪','硫','硬',0,'确','硯', */
	/* 7870 */ 0,0,0xc8a3,0,0xe2ed,0,0,0, 0,0,0x8fcfed,0,0xe2ef,0,0x8fcfee,0, /* 0,0,'硲',0,'硴',0,0,0, 0,0,'硺',0,'硼',0,'硾',0, */
	/* 7880 */ 0,0xb8eb,0,0,0,0,0xe2ee,0xc4f6, 0,0,0x8fcfef,0,0xe2f1,0xb3b7,0xe2ec,0x8fcff0, /* 0,'碁',0,0,0,0,'碆','碇', 0,0,'碊',0,'碌','碍','碎','碏', */
	/* 7890 */ 0,0xc8ea,0,0xb1b0,0x8fcff1,0xbaec,0,0xcfd2, 0x8fcff2,0,0xe2f0,0,0,0x8fcff4,0x8fcff5,0x8fcff6, /* 0,'碑',0,'碓','碔','碕',0,'碗', '碘',0,'碚',0,0,'碝','碞','碟', */
	/* 78a0 */ 0,0x8fcff3,0,0xe2f2,0x8fcff7,0,0,0xcacb, 0x8fcff8,0xc0d9,0xe2f4,0,0x8fcff9,0x8fcffa,0,0xe2f5, /* 0,'碡',0,'碣','碤',0,0,'碧', '碨','碩','碪',0,'碬','碭',0,'碯', */
	/* 78b0 */ 0x8fcffb,0x8fcffc,0x8fcffd,0x8fcffe,0,0xe2f3,0,0, 0,0,0xb3ce,0x8fd0a1,0xe2fb,0x8fd0a2,0xe2fa,0x8fd0a3, /* '碰','碱','碲','碳',0,'碵',0,0, 0,0,'確','碻','碼','碽','碾','碿', */
	/* 78c0 */ 0,0xbca7,0,0,0,0xe2fc,0xe2f7,0x8fd0a4, 0x8fd0a5,0x8fd0a6,0xe2fd,0xe2f8,0x8fd0a7,0,0x8fd0a8,0, /* 0,'磁',0,0,0,'磅','磆','磇', '磈','磉','磊','磋','磌',0,'磎',0, */
	/* 78d0 */ 0xc8d8,0xe2f6,0x8fd0a9,0x8fd0aa,0xe2f9,0x8fd0ab,0x8fd0ac,0, 0,0,0xe3a2,0x8fd0ae,0,0,0,0x8fd0af, /* '磐','磑','磒','磓','磔','磕','磖',0, 0,0,'磚','磛',0,0,0,'磟', */
	/* 78e0 */ 0x8fd0b0,0x8fd0b1,0,0,0x8fd0ad,0,0x8fd0b2,0xe3a1, 0xcbe1,0,0x8fd0b3,0,0xe2fe,0,0,0xb0eb, /* '磠','磡',0,0,'磤',0,'磦','磧', '磨',0,'磪',0,'磬',0,0,'磯', */
	/* 78f0 */ 0,0,0x8fd0b4,0x8fd0b5,0xe3a4,0,0x8fd0b7,0x8fd0b8, 0,0,0x8fd0b9,0x8fd0ba,0,0xe3a3,0,0x8fd0bb, /* 0,0,'磲','磳','磴',0,'磶','磷', 0,0,'磺','磻',0,'磽',0,'磿', */
	/* 7900 */ 0x8fd0b6,0xbecc,0,0,0,0,0x8fd0bc,0xe3a5, 0,0,0,0,0x8fd0bd,0,0xc1c3,0, /* '礀','礁',0,0,0,0,'礆','礇', 0,0,0,0,'礌',0,'礎',0, */
	/* 7910 */ 0x8fd0be,0xe3a7,0xe3a6,0,0,0,0,0, 0,0xe3a8,0x8fd0bf,0,0x8fd0c0,0,0x8fd0c1,0x8fd0c2, /* '礐','礑','礒',0,0,0,0,0, 0,'礙','礚',0,'礜',0,'礞','礟', */
	/* 7920 */ 0x8fd0c3,0,0,0,0,0x8fd0c4,0xe2e8,0x8fd0c5, 0,0x8fd0c6,0xe2ea,0xe3aa,0xe3a9,0x8fd0c7,0,0, /* '礠',0,0,0,0,'礥','礦','礧', 0,'礩','礪','礫','礬','礭',0,0, */
	/* 7930 */ 0x8ff4d4,0x8fd0c8,0,0,0x8fd0c9,0x8fd0ca,0,0, 0,0,0xbca8,0x8fd0cb,0xcee9,0x8fd0cc,0xbcd2,0x8fd0cd, /* '礰','礱',0,0,'礴','礵',0,0, 0,0,'示','礻','礼','礽','社','礿', */
	/* 7940 */ 0xe3ab,0xb7b7,0,0,0x8fd0ce,0x8fd0cf,0x8fd0d0,0xb5c0, 0xb5a7,0xbbe3,0x8fd0d1,0x8fd0d2,0,0,0,0x8fd0d3, /* '祀','祁',0,0,'祄','祅','祆','祇', '祈','祉','祊','祋',0,0,0,'祏', */
	/* 7950 */ 0xcdb4,0x8fd0d4,0,0xe3b1,0x8fd0d5,0xe3b0,0xc1c4,0xe3ad, 0x8fd0d6,0,0xe3af,0x8fd0d7,0x8fd0d8,0xbdcb,0xbfc0,0xe3ae, /* '祐','祑',0,'祓','祔','祕','祖','祗', '祘',0,'祚','祛','祜','祝','神','祟', */
	/* 7960 */ 0xe3ac,0,0xc7aa,0,0,0xbecd,0,0x8fd0d9, 0xc9bc,0x8fd0da,0,0x8fd0db,0,0xbad7,0,0, /* '祠',0,'祢',0,0,'祥',0,'祧', '票','祩',0,'祫',0,'祭',0,0, */
	/* 7970 */ 0,0,0x8fd0dc,0,0,0,0,0xc5f8, 0,0x8fd0dd,0xe3b2,0x8fd0de,0x8fd0df,0,0x8fd0e0,0xe3b3, /* 0,0,'祲',0,0,0,0,'祷', 0,'祹','祺','祻','祼',0,'祾','祿', */
	/* 7980 */ 0xe3c9,0xb6d8,0,0,0xcfbd,0xc1b5,0,0, 0,0,0xe3b4,0x8fd0e1,0x8fd0e2,0xb2d2,0xc4f7,0xcaa1, /* '禀','禁',0,0,'禄','禅',0,0, 0,0,'禊','禋','禌','禍','禎','福', */
	/* 7990 */ 0,0x8fd0e3,0,0x8fd0e4,0x8fd0e5,0x8fd0e6,0x8fd0e7,0, 0x8fd0e8,0,0,0x8fd0e9,0x8fd0ea,0xe3b5,0,0, /* 0,'禑',0,'禓','禔','禕','禖',0, '禘',0,0,'禛','禜','禝',0,0, */
	/* 79a0 */ 0,0x8fd0eb,0,0,0,0,0xb5fa,0xe3b6, 0x8fd0ec,0x8fd0ed,0xe3b8,0x8fd0ee,0,0,0xe3b9,0x8fd0ef, /* 0,'禡',0,0,0,0,'禦','禧', '禨','禩','禪','禫',0,0,'禮','禯', */
	/* 79b0 */ 0xc7a9,0x8fd0f0,0,0xe3ba,0x8fd0f1,0,0,0, 0x8fd0f2,0xe3bb,0xe3bc,0x8fd0f3,0,0xb6d9,0xb2d3,0xc6c5, /* '禰','禱',0,'禳','禴',0,0,0, '禸','禹','禺','离',0,'禽','禾','禿', */
	/* 79c0 */ 0xbda8,0xbbe4,0x8fd0f4,0,0x8fd0f5,0,0,0x8fd0f6, 0x8fd0f7,0xe3bd,0x8fd0f8,0xbda9,0,0,0,0x8fd0f9, /* '秀','私','秂',0,'秄',0,0,'秇', '秈','秉','秊','秋',0,0,0,'秏', */
	/* 79d0 */ 0,0xb2ca,0xc9c3,0,0x8fd0fa,0xe3be,0x8fd0fb,0, 0xc8eb,0,0x8fd0fc,0,0,0x8fd0fd,0x8fd0fe,0xc1c5, /* 0,'科','秒',0,'秔','秕','秖',0, '秘',0,'秚',0,0,'秝','秞','租', */
	/* 79e0 */ 0x8fd1a1,0xe3c1,0x8fd1a2,0xe3c2,0xc7e9,0x8fd1a3,0xbfc1,0xe3bf, 0,0xc3e1,0x8fd1a4,0x8fd1a5,0xe3c0,0x8fd1a6,0,0, /* '秠','秡','秢','秣','秤','秥','秦','秧', 0,'秩','秪','秫','秬','秭',0,0, */
	/* 79f0 */ 0xbece,0x8fd1a7,0,0,0,0,0,0, 0x8fd1a8,0,0,0xb0dc,0x8fd1a9,0,0,0, /* '称','秱',0,0,0,0,0,0, '秸',0,0,'移','秼',0,0,0, */
	/* 7a00 */ 0xb5a9,0,0x8fd1aa,0x8fd1ab,0,0,0,0x8fd1ac, 0xe3c3,0x8fd1ad,0x8fd1ae,0xc4f8,0x8fd1af,0xe3c4,0xc0c7,0, /* '稀',0,'稂','稃',0,0,0,'稇', '稈','稉','稊','程','稌','稍','税',0, */
	/* 7a10 */ 0,0x8fd1b0,0,0,0xccad,0x8fd1b1,0,0xc9a3, 0xe3c5,0xe3c6,0xc3d5,0x8fd1b2,0xcec7,0,0x8fd1b3,0xe3c8, /* 0,'稑',0,0,'稔','稕',0,'稗', '稘','稙','稚','稛','稜',0,'稞','稟', */
	/* 7a20 */ 0xe3c7,0x8fd1b4,0,0,0,0,0,0x8fd1b5, 0,0,0,0x8fd1b6,0,0x8fd1b7,0xbcef,0x8fd1b8, /* '稠','稡',0,0,0,0,0,'稧', 0,0,0,'稫',0,'稭','種','稯', */
	/* 7a30 */ 0x8fd1b9,0xe3ca,0xb0f0,0,0x8fd1ba,0x8fd1bb,0,0xe3cd, 0x8fd1bc,0x8fd1bd,0x8fd1be,0xe3cb,0xb2d4,0xb7ce,0xe3cc,0xb9c6, /* '稰','稱','稲',0,'稴','稵',0,'稷', '稸','稹','稺','稻','稼','稽','稾','稿', */
	/* 7a40 */ 0xb9f2,0,0xcae6,0xe3ce,0x8fd1bf,0x8fd1c0,0xcbd4,0x8fd1c1, 0x8fd1c2,0xe3d0,0,0,0x8fd1c3,0xc0d1,0xb1cf,0xb2ba, /* '穀',0,'穂','穃','穄','穅','穆','穇', '穈','穉',0,0,'穌','積','穎','穏', */
	/* 7a50 */ 0xb0ac,0,0,0,0,0x8fd1c4,0x8fd1c5,0xe3cf, 0,0x8fd1c6,0,0,0x8fd1c7,0x8fd1c8,0,0x8fd1c9, /* '穐',0,0,0,0,'穕','穖','穗', 0,'穙',0,0,'穜','穝',0,'穟', */
	/* 7a60 */ 0x8fd1ca,0xe3d1,0xe3d2,0xbef7,0,0x8fd1cb,0,0x8fd1cc, 0,0xe3d3,0x8fd1cd,0xb3cf,0,0x8fd1ce,0,0, /* '穠','穡','穢','穣',0,'穥',0,'穧', 0,'穩','穪','穫',0,'穭',0,0, */
	/* 7a70 */ 0xe3d5,0,0,0,0xb7ea,0x8fd1cf,0xb5e6,0, 0x8fd1d0,0xe3d6,0xb6f5,0,0,0xe3d7,0x8fd1d1,0xc0fc, /* '穰',0,0,0,'穴','穵','究',0, '穸','穹','空',0,0,'穽','穾','穿', */
	/* 7a80 */ 0x8fd1d2,0xc6cd,0x8fd1d3,0xc0e0,0xbaf5,0x8fd1d4,0x8fd1d5,0, 0xe3d8,0,0x8fd1d6,0x8fd1d7,0,0,0,0, /* '窀','突','窂','窃','窄','窅','窆',0, '窈',0,'窊','窋',0,0,0,0, */
	/* 7a90 */ 0x8fd1d8,0x8fd1d9,0xc3e2,0xc1eb,0x8fd1da,0xe3da,0xe3dc,0xe3d9, 0xe3db,0,0,0,0,0,0x8fd1db,0xb7a2, /* '窐','窑','窒','窓','窔','窕','窖','窗', '窘',0,0,0,0,0,'窞','窟', */
	/* 7aa0 */ 0x8fd1dc,0,0,0x8fd1dd,0,0,0,0, 0,0xe3dd,0xb7a6,0,0x8fd1de,0,0xb5e7,0xcdd2, /* '窠',0,0,'窣',0,0,0,0, 0,'窩','窪',0,'窬',0,'窮','窯', */
	/* 7ab0 */ 0xe3df,0,0,0x8fd1df,0,0x8fd1e0,0xe3e0,0, 0,0x8fd1e1,0xb1ae,0x8fd1e2,0x8fd1e3,0,0,0xe3e3, /* '窰',0,0,'窳',0,'窵','窶',0, 0,'窹','窺','窻','窼',0,0,'窿', */
	/* 7ac0 */ 0,0,0,0xb3f6,0xe3e2,0xe3e1,0x8fd1e4,0xe3e5, 0xe3de,0x8fd1e5,0xe3e6,0xcea9,0x8fd1e6,0xe3e7,0x8fd1e7,0xe3e8, /* 0,0,0,'竃','竄','竅','竆','竇', '竈','竉','竊','立','竌','竍','竎','竏', */
	/* 7ad0 */ 0,0x8fd1e8,0xd4f4,0xe3ea,0,0xe3e9,0,0, 0,0xe3eb,0xe3ec,0x8fd1e9,0xceb5,0xe3ed,0,0xf0ef, /* 0,'竑','竒','竓',0,'竕',0,0, 0,'站','竚','竛','竜','竝',0,'竟', */
	/* 7ae0 */ 0xbecf,0xe3ee,0xe3ef,0xbdd7,0,0xc6b8,0xe3f0,0x8ff4d9, 0x8fd1ea,0x8fd1eb,0xc3a8,0x8fd1ec,0x8fd1ed,0xe3f1,0,0xc3bc, /* '章','竡','竢','竣',0,'童','竦','竧', '竨','竩','竪','竫','竬','竭',0,'端', */
	/* 7af0 */ 0xe3f2,0x8fd1ee,0,0,0x8fd1ef,0,0xb6a5,0, 0xd1bf,0xc3dd,0xbcb3,0x8fd1f0,0,0x8fd1f1,0x8fd1f2,0xb4c8, /* '竰','竱',0,0,'竴',0,'競',0, '竸','竹','竺','竻',0,'竽','竾','竿', */
	/* 7b00 */ 0,0,0xe3f3,0,0xe4a2,0,0xe3f6,0x8fd1f3, 0xb5e8,0,0xe3f5,0xe4a4,0,0,0,0xe3f4, /* 0,0,'笂',0,'笄',0,'笆','笇', '笈',0,'笊','笋',0,0,0,'笏', */
	/* 7b10 */ 0,0xbed0,0,0,0x8fd1f4,0,0,0, 0xe3f8,0xe3f9,0,0xc5ab,0,0,0xe3fa,0x8fd1f5, /* 0,'笑',0,0,'笔',0,0,0, '笘','笙',0,'笛',0,0,'笞','笟', */
	/* 7b20 */ 0xb3de,0,0,0x8fd1f6,0,0xbfda,0xc9e4,0x8fd1f7, 0xe3fc,0x8fd1f8,0x8fd1f9,0x8fd1fa,0xc2e8,0x8fd1fb,0x8fd1fc,0x8fd1fd, /* '笠',0,0,'笣',0,'笥','符','笧', '笨','笩','笪','笫','第','笭','笮','笯', */
	/* 7b30 */ 0x8fd1fe,0x8fd2a1,0,0xe3f7,0x8fd2a2,0xe3fb,0xe3fd,0, 0,0xbafb,0,0,0,0x8fd2a3,0,0x8fd2a4, /* '笰','笱',0,'笳','笴','笵','笶',0, 0,'笹',0,0,0,'笽',0,'笿', */
	/* 7b40 */ 0x8fd2a5,0x8fd2a6,0,0,0,0xe4a6,0xc9ae,0x8fd2a7, 0xc8a6,0xc5f9,0,0xb6da,0xe4a5,0xe4a3,0x8fd2a8,0xc8b5, /* '筀','筁',0,0,0,'筅','筆','筇', '筈','等',0,'筋','筌','筍','筎','筏', */
	/* 7b50 */ 0xe3fe,0xc3de,0xc5fb,0,0xc5fa,0x8fd2a9,0xbaf6,0, 0,0,0,0,0,0xe4b8,0,0, /* '筐','筑','筒',0,'答','筕','策',0, 0,0,0,0,0,'筝',0,0, */
	/* 7b60 */ 0x8fd2aa,0,0,0,0x8fd2ab,0xe4a8,0x8fd2ac,0xe4aa, 0,0x8fd2ad,0x8fd2ae,0,0xe4ad,0x8fd2af,0xe4ae,0x8fd2b0, /* '筠',0,0,0,'筤','筥','筦','筧', 0,'筩','筪',0,'筬','筭','筮','筯', */
	/* 7b70 */ 0xe4ab,0xe4ac,0x8fd2b1,0x8fd2b2,0xe4a9,0xe4a7,0,0x8fd2b3, 0,0,0xe4a1,0,0,0,0,0, /* '筰','筱','筲','筳','筴','筵',0,'筷', 0,0,'筺',0,0,0,0,0, */
	/* 7b80 */ 0,0,0,0,0x8fd2b4,0,0xcacf,0xb2d5, 0,0x8fd2b5,0,0xe4b5,0,0xe4b2,0x8fd2b6,0xe4b7, /* 0,0,0,0,'箄',0,'箆','箇', 0,'箉',0,'箋',0,'箍','箎','箏', */
	/* 7b90 */ 0x8fd2b7,0x8fd2b8,0xe4b6,0,0xc7f3,0xcca7,0x8fd2b9,0xbbbb, 0xe4b0,0xe4b9,0xe4b4,0x8fd2ba,0xe4b3,0xe4af,0x8fd2bb,0xe4b1, /* '箐','箑','箒',0,'箔','箕','箖','算', '箘','箙','箚','箛','箜','箝','箞','箟', */
	/* 7ba0 */ 0x8fd2bc,0xb4c9,0,0,0,0x8fd2bd,0,0, 0,0,0xc3bd,0,0x8fd2be,0xc0fd,0,0x8fd2bf, /* '箠','管',0,0,0,'箥',0,0, 0,0,'箪',0,'箬','箭',0,'箯', */
	/* 7bb0 */ 0x8fd2c0,0xc8a2,0x8fd2c1,0,0xe4be,0x8fd2c2,0x8fd2c3,0, 0xc8a4,0,0x8fd2c4,0x8fd2c5,0x8fd2c6,0x8fd2c7,0,0, /* '箰','箱','箲',0,'箴','箵','箶',0, '箸',0,'箺','箻','箼','箽',0,0, */
	/* 7bc0 */ 0xc0e1,0xe4bb,0x8fd2c8,0,0xc8cf,0x8fd2c9,0xe4bf,0xcad3, 0x8fd2ca,0xc3db,0x8fd2cb,0xe4ba,0xe4bc,0,0,0xe4bd, /* '節','篁','篂',0,'範','篅','篆','篇', '篈','築','篊','篋','篌',0,0,'篏', */
	/* 7bd0 */ 0,0,0,0,0x8fd2cc,0,0x8fd2cd,0x8fd2ce, 0,0x8fd2cf,0x8fd2d0,0x8fd2d1,0,0xe4c0,0,0, /* 0,0,0,0,'篔',0,'篖','篗', 0,'篙','篚','篛',0,'篝',0,0, */
	/* 7be0 */ 0xbcc4,0,0,0,0xc6c6,0xe4c5,0xe4c4,0, 0x8fd2d2,0xe4c1,0x8fd2d3,0,0,0xcfb6,0,0, /* '篠',0,0,0,'篤','篥','篦',0, '篨','篩','篪',0,0,'篭',0,0, */
	/* 7bf0 */ 0,0,0x8fd2d4,0xe4ca,0x8fd2d5,0x8fd2d6,0xe4ce,0xe4cb, 0x8fd2d7,0x8fd2d8,0x8fd2d9,0,0x8fd2da,0,0x8fd2db,0, /* 0,0,'篲','篳','篴','篵','篶','篷', '篸','篹','篺',0,'篼',0,'篾',0, */
	/* 7c00 */ 0xe4c7,0x8fd2dc,0x8fd2dd,0x8fd2de,0x8fd2df,0,0x8fd2e0,0xe4c8, 0,0x8fd2e1,0,0x8fd2e2,0x8fd2e3,0xe4cd,0x8fd2e4,0x8fd2e5, /* '簀','簁','簂','簃','簄',0,'簆','簇', 0,'簉',0,'簋','簌','簍','簎','簏', */
	/* 7c10 */ 0,0xe4c2,0xd2d5,0xe4c9,0xe4c3,0,0,0xe4cc, 0,0x8fd2e6,0,0x8fd2e7,0,0,0,0xe4d2, /* 0,'簑','簒','簓','簔',0,0,'簗', 0,'簙',0,'簛',0,0,0,'簟', */
	/* 7c20 */ 0x8fd2e8,0xb4ca,0,0xe4cf,0,0x8fd2e9,0x8fd2ea,0xe4d0, 0x8fd2eb,0,0xe4d1,0xe4d4,0x8fd2ec,0,0,0, /* '簠','簡',0,'簣',0,'簥','簦','簧', '簨',0,'簪','簫','簬',0,0,0, */
	/* 7c30 */ 0,0x8fd2ed,0,0x8fd2ee,0x8fd2ef,0,0x8fd2f0,0xe4d3, 0xc8f6,0x8fd2f1,0x8fd2f2,0,0,0xe4d5,0xcefc,0xcaed, /* 0,'簱',0,'簳','簴',0,'簶','簷', '簸','簹','簺',0,0,'簽','簾','簿', */
	/* 7c40 */ 0xe4da,0,0,0xe4d7,0,0,0x8fd2f3,0, 0,0,0x8fd2f4,0,0xe4d6,0xc0d2,0,0xe4d9, /* '籀',0,0,'籃',0,0,'籆',0, 0,0,'籊',0,'籌','籍',0,'籏', */
	/* 7c50 */ 0xe4db,0x8fd2f6,0x8fd2f7,0x8fd2f8,0xe4d8,0x8fd2f5,0xe4df,0, 0xe4dc,0x8fd2f9,0x8fd2fa,0x8fd2fb,0x8fd2fc,0x8fd2fd,0x8fd2fe,0xe4dd, /* '籐','籑','籒','籓','籔','籕','籖',0, '籘','籙','籚','籛','籜','籝','籞','籟', */
	/* 7c60 */ 0xe4c6,0x8fd3a1,0,0x8fd3a2,0xe4de,0xe4e0,0,0x8fd3a3, 0,0x8fd3a4,0,0,0xe4e1,0x8fd3a5,0x8fd3a6,0, /* '籠','籡',0,'籣','籤','籥',0,'籧', 0,'籩',0,0,'籬','籭','籮',0, */
	/* 7c70 */ 0x8fd3a7,0,0x8fd3a8,0xcac6,0,0xe4e2,0,0, 0,0x8fd3a9,0,0,0x8fd3aa,0x8fd3ab,0xcce2,0, /* '籰',0,'籲','米',0,'籵',0,0, 0,'籹',0,0,'籼','籽','籾',0, */
	/* 7c80 */ 0,0xb6ce,0xb7a9,0xe4e3,0,0,0x8fd3ac,0x8fd3ad, 0,0xcab4,0,0xbfe8,0,0xccb0,0,0x8fd3ae, /* 0,'粁','粂','粃',0,0,'粆','粇', 0,'粉',0,'粋',0,'粍',0,'粏', */
	/* 7c90 */ 0xe4e4,0,0xceb3,0,0x8fd3af,0xc7f4,0,0xc1c6, 0xc7b4,0,0,0xbdcd,0,0,0x8fd3b0,0xb0c0, /* '粐',0,'粒',0,'粔','粕',0,'粗', '粘',0,0,'粛',0,0,'粞','粟', */
	/* 7ca0 */ 0x8fd3b1,0xe4e9,0xe4e7,0,0xe4e5,0xb4a1,0x8fd3b2,0xbed1, 0xe4ea,0,0,0xe4e8,0,0xe4e6,0xe4ee,0, /* '粠','粡','粢',0,'粤','粥','粦','粧', '粨',0,0,'粫',0,'粭','粮',0, */
	/* 7cb0 */ 0x8fd3b3,0xe4ed,0xe4ec,0xe4eb,0,0,0x8fd3b4,0x8fd3b5, 0,0xe4ef,0x8fd3b6,0x8fd3b7,0x8fd3b8,0xe4f0,0xc0ba,0x8fd3b9, /* '粰','粱','粲','粳',0,0,'粶','粷', 0,'粹','粺','粻','粼','粽','精','粿', */
	/* 7cc0 */ 0xe4f1,0,0xe4f3,0,0x8fd3ba,0xe4f2,0,0x8fd3bb, 0x8fd3bc,0x8fd3bd,0xb8d2,0,0,0x8fd3be,0xc1b8,0x8fd3bf, /* '糀',0,'糂',0,'糄','糅',0,'糇', '糈','糉','糊',0,0,'糍','糎','糏', */
	/* 7cd0 */ 0,0,0xe4f5,0x8fd3c0,0x8fd3c1,0x8fd3c2,0xc5fc,0x8fd3c3, 0xe4f4,0x8fd3c4,0x8fd3c5,0,0xe4f6,0x8fd3c6,0xcab5,0xc1ec, /* 0,0,'糒','糓','糔','糕','糖','糗', '糘','糙','糚',0,'糜','糝','糞','糟', */
	/* 7ce0 */ 0xb9c7,0,0xe4f7,0,0,0,0x8fd3c7,0xcec8, 0,0x8fd3c8,0,0x8fd3c9,0,0,0,0xe4f9, /* '糠',0,'糢',0,0,0,'糦','糧', 0,'糩',0,'糫',0,0,0,'糯', */
	/* 7cf0 */ 0,0,0xe4fa,0,0xe4fb,0x8fd3ca,0xe4fc,0, 0xbbe5,0,0xe4fd,0xb7cf,0,0,0xb5ea,0, /* 0,0,'糲',0,'糴','糵','糶',0, '糸',0,'糺','系',0,0,'糾',0, */
	/* 7d00 */ 0xb5aa,0,0xe5a1,0x8fd3cb,0xccf3,0xb9c8,0xe4fe,0x8fd3cc, 0x8fd3cd,0x8fd3ce,0xe5a4,0xcce6,0,0xc7bc,0,0x8fd3cf, /* '紀',0,'紂','紃','約','紅','紆','紇', '紈','紉','紊','紋',0,'納',0,'紏', */
	/* 7d10 */ 0xc9b3,0x8fd3d0,0x8fd3d1,0x8fd3d2,0xbde3,0xe5a3,0x8fd3d3,0xbcd3, 0xb9c9,0xbbe6,0xb5e9,0xcab6,0xe5a2,0x8fd3d4,0x8fd3d5,0, /* '紐','紑','紒','紓','純','紕','紖','紗', '紘','紙','級','紛','紜','紝','紞',0, */
	/* 7d20 */ 0xc1c7,0xcbc2,0xbaf7,0x8fd3d6,0,0,0x8fd3d7,0, 0,0,0x8fd3d8,0xbbe7,0xc4dd,0x8fd3d9,0xe5a7,0xcedf, /* '素','紡','索','紣',0,0,'紦',0, 0,0,'紪','紫','紬','紭','紮','累', */
	/* 7d30 */ 0xbad9,0x8fd3da,0xe5a8,0xbfc2,0,0xe5aa,0,0, 0,0xbed2,0xbab0,0,0x8fd3db,0x8fd3dc,0x8fd3dd,0xe5a9, /* '細','紱','紲','紳',0,'紵',0,0, 0,'紹','紺',0,'紼','紽','紾','紿', */
	/* 7d40 */ 0x8fd3de,0x8fd3df,0xbdaa,0xb8be,0xc1c8,0xe5a5,0xe5ab,0x8fd3e0, 0x8fd3e1,0,0,0xe5a6,0xb7d0,0x8fd3e2,0xe5ae,0xe5b2, /* '絀','絁','終','絃','組','絅','絆','絇', '絈',0,0,'絋','経','絍','絎','絏', */
	/* 7d50 */ 0xb7eb,0x8fd3e3,0,0x8fd3e4,0,0,0xe5ad,0x8fd3e5, 0,0x8fd3e6,0x8fd3e7,0xe5b6,0x8fd3e8,0x8fd3e9,0xb9ca,0, /* '結','絑',0,'絓',0,0,'絖','絗', 0,'絙','絚','絛','絜','絝','絞',0, */
	/* 7d60 */ 0,0xcded,0xb0bc,0xe5b3,0,0x8fd3ea,0xb5eb,0x8fd3eb, 0xe5b0,0,0x8fd3ec,0,0,0,0xe5b1,0, /* 0,'絡','絢','絣',0,'絥','給','絧', '絨',0,'絪',0,0,0,'絮',0, */
	/* 7d70 */ 0x8fd3ed,0xc5fd,0xe5af,0xe5ac,0,0xb3a8,0xc0e4,0, 0x8fd3ee,0xb8a8,0x8fd3ef,0x8fd3f0,0,0xe5b8,0,0x8fd3f1, /* '絰','統','絲','絳',0,'絵','絶',0, '絸','絹','絺','絻',0,'絽',0,'絿', */
	/* 7d80 */ 0,0x8fd3f2,0x8fd3f3,0x8fd3f4,0,0x8fd3f5,0x8fd3f6,0, 0x8fd3f7,0xe5b5,0,0x8fd3f8,0x8fd3f9,0x8fd3fa,0,0xe5b7, /* 0,'綁','綂','綃',0,'綅','綆',0, '綈','綉',0,'綋','綌','綍',0,'綏', */
	/* 7d90 */ 0,0x8fd3fb,0,0xe5b4,0,0,0x8fd3fc,0x8fd3fd, 0,0xb7d1,0xc2b3,0xe5b9,0xc1ee,0x8fd3fe,0x8fd4a1,0xe5c6, /* 0,'綑',0,'經',0,0,'綖','綗', 0,'継','続','綛','綜','綝','綞','綟', */
	/* 7da0 */ 0x8ff4dc,0,0xe5c2,0xe5bc,0,0,0x8fd4a2,0x8fd4a3, 0,0,0x8fd4a4,0xe5c0,0xbcfa,0xb0dd,0xe5bb,0xe5c3, /* '綠',0,'綢','綣',0,0,'綦','綧', 0,0,'綪','綫','綬','維','綮','綯', */
	/* 7db0 */ 0xe5c7,0xb9cb,0xccd6,0x8fd4a5,0xc4d6,0xe5bd,0x8fd4a6,0x8fd4a7, 0xe5c5,0x8fd4a8,0xe5ba,0xc3be,0,0xe5bf,0xb0bd,0xccca, /* '綰','綱','網','綳','綴','綵','綶','綷', '綸','綹','綺','綻',0,'綽','綾','綿', */
	/* 7dc0 */ 0,0,0x8fd4a9,0x8fd4aa,0x8fd4ab,0x8fd4ac,0x8fd4ad,0xe5be, 0,0,0xb6db,0xc8ec,0x8fd4ae,0x8fd4af,0x8fd4b0,0xc1ed, /* 0,0,'緂','緃','緄','緅','緆','緇', 0,0,'緊','緋','緌','緍','緎','総', */
	/* 7dd0 */ 0,0xced0,0xbdef,0,0,0xe5ee,0x8ff4dd,0x8fd4b1, 0xe5c8,0x8fd4b2,0xc0fe,0,0xe5c4,0xe5c9,0xe5cb,0, /* 0,'緑','緒',0,0,'緕','緖','緗', '緘','緙','線',0,'緜','緝','緞',0, */
	/* 7de0 */ 0xc4f9,0xe5ce,0x8fd4b4,0,0xe5ca,0x8fd4b5,0x8fd4b6,0, 0xcad4,0xb4cb,0x8fd4b7,0x8fd4b8,0xcccb,0x8fd4b9,0,0xb0de, /* '締','緡','緢',0,'緤','緥','緦',0, '編','緩','緪','緫','緬','緭',0,'緯', */
	/* 7df0 */ 0,0x8fd4ba,0xe5cd,0,0xcefd,0x8fd4bb,0x8fd4bc,0, 0,0x8fd4bd,0x8fd4be,0xe5cc,0,0,0,0, /* 0,'緱','緲',0,'練','緵','緶',0, 0,'緹','緺','緻',0,0,0,0, */
	/* 7e00 */ 0x8fd4b3,0xb1ef,0,0,0xc6ec,0xe5cf,0,0, 0x8fd4bf,0xe5d6,0xe5d0,0xe5d7,0,0,0,0, /* '縀','縁',0,0,'縄','縅',0,0, '縈','縉','縊','縋',0,0,0,0, */
	/* 7e10 */ 0x8fd4c0,0x8fd4c1,0xe5d3,0,0,0x8fd4c2,0,0x8fd4c3, 0,0,0,0xc7fb,0x8fd4c4,0x8fd4c5,0xbcca,0xe5d5, /* '縐','縑','縒',0,0,'縕',0,'縗', 0,0,0,'縛','縜','縝','縞','縟', */
	/* 7e20 */ 0x8fd4c6,0xe5d2,0xe5d8,0xe5d1,0,0,0xbdc4,0x8fd4c7, 0x8fd4c8,0,0,0xcba5,0x8fd4c9,0x8fd4ca,0xbdcc,0x8fd4cb, /* '縠','縡','縢','縣',0,0,'縦','縧', '縨',0,0,'縫','縬','縭','縮','縯', */
	/* 7e30 */ 0,0xe5d4,0xe5e0,0x8fd4cc,0,0xe5dc,0x8fd4cd,0xe5df, 0,0xe5dd,0xe5e1,0xe5db,0,0xe5c1,0xc0d3,0x8fd4ce, /* 0,'縱','縲','縳',0,'縵','縶','縷', 0,'縹','縺','縻',0,'總','績','縿', */
	/* 7e40 */ 0,0xc8cb,0,0xe5de,0x8fd4cf,0x8fd4d0,0xe5d9,0x8fd4d1, 0,0,0xc1a1,0xb7d2,0,0xbdab,0x8fd4d2,0, /* 0,'繁',0,'繃','繄','繅','繆','繇', 0,0,'繊','繋',0,'繍','繎',0, */
	/* 7e50 */ 0x8fd4d3,0,0x8fd4d4,0,0xbfa5,0xc1b6,0xe5e4,0, 0x8fd4d5,0xe5e6,0xe5e7,0,0,0xe5e3,0xe5e5,0x8fd4d6, /* '繐',0,'繒',0,'織','繕','繖',0, '繘','繙','繚',0,0,'繝','繞','繟', */
	/* 7e60 */ 0,0x8fd4d7,0x8fd4d8,0,0,0x8fd4d9,0xe5da,0xe5e2, 0,0xe5ea,0xe5e9,0x8fd4da,0,0xcbfa,0x8fd4db,0x8fd4dc, /* 0,'繡','繢',0,0,'繥','繦','繧', 0,'繩','繪','繫',0,'繭','繮','繯', */
	/* 7e70 */ 0xb7ab,0,0,0x8fd4dd,0,0,0,0, 0x8fd4de,0xe5e8,0,0xe5ec,0xe5eb,0xe5ef,0x8fd4df,0xe5f1, /* '繰',0,0,'繳',0,0,0,0, '繸','繹',0,'繻','繼','繽','繾','繿', */
	/* 7e80 */ 0,0x8fd4e0,0xbbbc,0xe5ed,0,0,0x8fd4e1,0x8fd4e2, 0xe5f2,0xe5f3,0x8fd4e3,0,0xe5f4,0x8fd4e4,0xe5fa,0xc5bb, /* 0,'纁','纂','纃',0,0,'纆','纇', '纈','纉','纊',0,'續','纍','纎','纏', */
	/* 7e90 */ 0xe5f6,0x8fd4e5,0xe5f5,0xe5f7,0xe5f8,0x8fd4e6,0xe5f9,0, 0x8fd4e7,0,0x8fd4e8,0xe5fb,0xe5fc,0x8fd4e9,0x8fd4ea,0, /* '纐','纑','纒','纓','纔','纕','纖',0, '纘',0,'纚','纛','纜','纝','纞',0, */
	/* 7ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f30 */ 0,0,0,0,0,0,0xb4cc,0, 0xe5fd,0,0xe5fe,0x8fd4ec,0x8fd4eb,0x8fd4ed,0x8fd4ee,0x8fd4ef, /* 0,0,0,0,0,0,'缶',0, '缸',0,'缺','缻','缼','缽','缾','缿', */
	/* 7f40 */ 0,0,0,0x8fd4f0,0x8fd4f1,0xe6a1,0,0x8fd4f2, 0,0,0,0,0xe6a2,0xe6a3,0xe6a4,0x8fd4f3, /* 0,0,0,'罃','罄','罅',0,'罇', 0,0,0,0,'罌','罍','罎','罏', */
	/* 7f50 */ 0xe6a5,0xe6a6,0x8fd4f4,0x8fd4f5,0xe6a8,0xe6a7,0,0, 0xe6a9,0,0,0x8fd4f6,0x8fd4f7,0x8fd4f8,0,0xe6aa, /* '罐','网','罒','罓','罔','罕',0,0, '罘',0,0,'罛','罜','罝',0,'罟', */
	/* 7f60 */ 0xe6ab,0x8fd4f9,0,0x8fd4fa,0x8fd4fb,0x8fd4fc,0x8fd4fd,0xe6ae, 0xe6ac,0xe6ad,0xbae1,0xb7d3,0,0x8fd4fe,0xc3d6,0, /* '罠','罡',0,'罣','罤','罥','罦','罧', '罨','罩','罪','罫',0,'罭','置',0, */
	/* 7f70 */ 0xc8b3,0x8fd5a1,0xbdf0,0,0,0xc7cd,0,0xc8ed, 0xe6af,0xd8ed,0,0,0,0x8fd5a2,0x8fd5a3,0x8fd5a4, /* '罰','罱','署',0,0,'罵',0,'罷', '罸','罹',0,0,0,'罽','罾','罿', */
	/* 7f80 */ 0x8fd5a5,0,0xe6b0,0xe6b2,0,0xcde5,0xe6b1,0xe6b4, 0xe6b3,0,0xcdd3,0x8fd5a6,0xe6b5,0x8fd5a7,0xc8fe,0x8fd5a8, /* '羀',0,'羂','羃',0,'羅','羆','羇', '羈',0,'羊','羋','羌','羍','美','羏', */
	/* 7f90 */ 0x8fd5a9,0x8fd5aa,0,0,0xe6b6,0,0x8fd5ab,0x8fd5ac, 0,0,0xe6b9,0,0x8fd5ad,0xe6b8,0xe6b7,0, /* '羐','羑',0,0,'羔',0,'羖','羗', 0,0,'羚',0,'羜','羝','羞',0, */
	/* 7fa0 */ 0,0x8fd5ae,0x8fd5af,0xe6ba,0xb7b2,0,0x8fd5b0,0, 0xc1a2,0xb5c1,0x8fd5b1,0,0,0x8fd5b2,0xe6be,0xe6bb, /* 0,'羡','羢','羣','群',0,'羦',0, '羨','義','羪',0,0,'羭','羮','羯', */
	/* 7fb0 */ 0,0,0xe6bc,0,0x8fd5b3,0,0xe6bf,0, 0xe6c0,0xe6bd,0,0,0x8fd5b4,0xb1a9,0,0x8fd5b5, /* 0,0,'羲',0,'羴',0,'羶',0, '羸','羹',0,0,'羼','羽',0,'羿', */
	/* 7fc0 */ 0x8fd5b6,0xb2a7,0,0x8fd5b7,0,0xe6c2,0xe6c3,0, 0x8fd5b8,0,0xe6c4,0,0xcde2,0,0x8fd5b9,0x8fd5ba, /* '翀','翁',0,'翃',0,'翅','翆',0, '翈',0,'翊',0,'翌',0,'翎','翏', */
	/* 7fd0 */ 0,0,0xbdac,0,0xe6c6,0xe6c5,0,0, 0,0,0,0x8fd5bb,0,0,0,0x8fd5bc, /* 0,0,'習',0,'翔','翕',0,0, 0,0,0,'翛',0,0,0,'翟', */
	/* 7fe0 */ 0xbfe9,0xe6c7,0,0x8fd5bd,0,0x8fd5be,0xe6c8,0, 0x8fd5bf,0xe6c9,0,0xb4e5,0x8fd5c0,0,0x8fd5c1,0x8fd5c2, /* '翠','翡',0,'翣',0,'翥','翦',0, '翨','翩',0,'翫','翬',0,'翮','翯', */
	/* 7ff0 */ 0xb4cd,0,0x8fd5c3,0xe6ca,0,0,0,0, 0,0xe6cb,0x8fd5c4,0xcbdd,0xcde3,0x8fd5c5,0x8fd5c6,0x8fd5c7, /* '翰',0,'翲','翳',0,0,0,0, 0,'翹','翺','翻','翼','翽','翾','翿', */
	/* 8000 */ 0xcdd4,0xcfb7,0,0xb9cd,0xe6ce,0xbcd4,0xe6cd,0x8fd5c8, 0x8fd5c9,0,0x8fd5ca,0xe6cf,0xbca9,0x8fd5cb,0x8fd5cc,0x8fd5cd, /* '耀','老',0,'考','耄','者','耆','耇', '耈',0,'耊','耋','而','耍','耎','耏', */
	/* 8010 */ 0xc2d1,0x8fd5ce,0xe6d0,0x8fd5cf,0x8fd5d0,0xb9cc,0x8fd5d1,0xccd7, 0xe6d1,0xe6d2,0,0,0xe6d3,0x8fd5d2,0x8fd5d3,0x8fd5d4, /* '耐','耑','耒','耓','耔','耕','耖','耗', '耘','耙',0,0,'耜','耝','耞','耟', */
	/* 8020 */ 0x8fd5d5,0xe6d4,0,0,0x8fd5d6,0,0x8fd5d7,0, 0xe6d5,0,0,0,0x8fd5d8,0,0x8fd5d9,0, /* '耠','耡',0,0,'耤',0,'耦',0, '耨',0,0,0,'耬',0,'耮',0, */
	/* 8030 */ 0x8fd5da,0,0,0xbcaa,0x8fd5db,0x8fd5dc,0xcced,0x8fd5dd, 0,0x8fd5de,0x8fd5df,0xe6d7,0x8fd5e0,0xc3bf,0x8fd5e1,0xe6d6, /* '耰',0,0,'耳','耴','耵','耶','耷', 0,'耹','耺','耻','耼','耽','耾','耿', */
	/* 8040 */ 0x8fd5e2,0,0,0,0x8fd5e3,0,0xe6d9,0, 0,0,0xe6d8,0,0,0,0,0, /* '聀',0,0,0,'聄',0,'聆',0, 0,0,'聊',0,0,0,0,0, */
	/* 8050 */ 0,0,0xe6da,0,0,0,0xc0bb,0, 0xe6db,0,0xe6dc,0,0,0,0xcab9,0xe6dd, /* 0,0,'聒',0,0,0,'聖',0, '聘',0,'聚',0,0,0,'聞','聟', */
	/* 8060 */ 0x8fd5e4,0xc1ef,0xe6de,0,0x8fd5e5,0,0x8fd5e6,0, 0xe6df,0,0,0,0,0x8fd5e7,0,0xcefe, /* '聠','聡','聢',0,'聤',0,'聦',0, '聨',0,0,0,0,'聭',0,'聯', */
	/* 8070 */ 0xe6e2,0x8fd5e8,0xe6e1,0xe6e0,0xc4b0,0x8fd5e9,0xe6e3,0xbfa6, 0,0xe6e4,0,0,0,0xe6e5,0xcfb8,0xe6e6, /* '聰','聱','聲','聳','聴','聵','聶','職', 0,'聹',0,0,0,'聽','聾','聿', */
	/* 8080 */ 0,0x8fd5ea,0,0,0xe6e7,0xe6e9,0xe6e8,0xc8a5, 0x8fd5eb,0xc6f9,0,0xcfbe,0xc8a9,0,0x8fd5ec,0, /* 0,'肁',0,0,'肄','肅','肆','肇', '肈','肉',0,'肋','肌',0,'肎',0, */
	/* 8090 */ 0,0,0,0xe6eb,0,0,0xbed3,0, 0xc9aa,0,0xe6ec,0xe6ea,0x8fd5ed,0xb4ce,0x8fd5ee,0, /* 0,0,0,'肓',0,0,'肖',0, '肘',0,'肚','肛','肜','肝','肞',0, */
	/* 80a0 */ 0,0xb8d4,0xbbe8,0,0,0xc8ee,0x8fd5ef,0x8fd5f0, 0,0xb8aa,0xcbc3,0x8fd5f1,0xe6ef,0xe6ed,0,0xb9ce, /* 0,'股','肢',0,0,'肥','肦','肧', 0,'肩','肪','肫','肬','肭',0,'肯', */
	/* 80b0 */ 0,0xb9cf,0xb0e9,0,0xbae8,0,0,0, 0x8fd5f2,0x8fd5f3,0xc7d9,0,0,0,0,0, /* 0,'肱','育',0,'肴',0,0,0, '肸','肹','肺',0,0,0,0,0, */
	/* 80c0 */ 0,0,0,0xb0df,0xe6f4,0,0xc3c0,0, 0x8fd5f4,0,0,0,0xc7d8,0x8fd5f5,0xc2db,0x8fd5f6, /* 0,0,0,'胃','胄',0,'胆',0, '胈',0,0,0,'背','胍','胎','胏', */
	/* 80d0 */ 0,0,0x8fd5f7,0,0x8fd5f8,0x8fd5f9,0xe6f6,0x8fd5fa, 0x8fd5fb,0xe6f2,0xe6f5,0xe6f0,0,0xe6f3,0xcba6,0, /* 0,0,'胒',0,'胔','胕','胖','胗', '胘','胙','胚','胛',0,'胝','胞',0, */
	/* 80e0 */ 0x8fd5fc,0xb8d5,0,0,0xb0fd,0xe6f1,0,0, 0,0,0,0,0,0x8fd5fd,0x8fd5fe,0xe6f8, /* '胠','胡',0,0,'胤','胥',0,0, 0,0,0,0,0,'胭','胮','胯', */
	/* 80f0 */ 0x8fd6a1,0xe6f9,0x8fd6a2,0x8fd6a3,0xc6b9,0,0x8fd6a4,0, 0xb6bb,0x8fd6a5,0x8fd6a6,0,0xe7a6,0xc7bd,0x8fd6a7,0, /* '胰','胱','胲','胳','胴',0,'胶',0, '胸','胹','胺',0,'胼','能','胾',0, */
	/* 8100 */ 0,0,0xbbe9,0x8fd6a8,0,0xb6bc,0xc0c8,0xcfc6, 0xccae,0xe6f7,0xc0d4,0x8fd6a9,0,0,0,0, /* 0,0,'脂','脃',0,'脅','脆','脇', '脈','脉','脊','脋',0,0,0,0, */
	/* 8110 */ 0,0,0,0,0,0,0x8fd6aa,0x8fd6ab, 0x8fd6ac,0,0xb5d3,0xe6fa,0x8fd6ad,0,0x8fd6ae,0, /* 0,0,0,0,0,0,'脖','脗', '脘',0,'脚','脛','脜',0,'脞',0, */
	/* 8120 */ 0x8fd6af,0,0,0xe6fc,0x8fd6b0,0,0,0x8fd6b1, 0,0xe6fb,0,0,0x8fd6b2,0,0,0xe6fd, /* '脠',0,0,'脣','脤',0,0,'脧', 0,'脩',0,0,'脬',0,0,'脯', */
	/* 8130 */ 0x8fd6b3,0xc3a6,0,0xc7be,0,0x8fd6b4,0,0, 0,0xc4b1,0x8fd6b5,0,0x8fd6b6,0,0xe7a3,0, /* '脰','脱',0,'脳',0,'脵',0,0, 0,'脹','脺',0,'脼',0,'脾',0, */
	/* 8140 */ 0,0,0,0,0,0x8fd6b7,0xe7a2,0x8fd6b8, 0,0,0x8fd6b9,0xe6fe,0x8fd6ba,0,0xbfd5,0, /* 0,0,0,0,0,'腅','腆','腇', 0,0,'腊','腋','腌',0,'腎',0, */
	/* 8150 */ 0xc9e5,0xe7a5,0x8fd6bb,0xe7a4,0xb9d0,0xcfd3,0,0x8fd6bc, 0,0,0,0,0,0,0,0xe7b5, /* '腐','腑','腒','腓','腔','腕',0,'腗', 0,0,0,0,0,0,0,'腟', */
	/* 8160 */ 0x8fd6bd,0x8fd6be,0,0,0,0xe7a9,0xe7aa,0x8fd6bf, 0x8fd6c0,0x8fd6c1,0,0xbcf0,0,0x8fd6c2,0xe7a8,0x8fd6c3, /* '腠','腡',0,0,0,'腥','腦','腧', '腨','腩',0,'腫',0,'腭','腮','腯', */
	/* 8170 */ 0xb9f8,0xe7a7,0,0,0xe7ab,0,0,0x8fd6c4, 0xc4b2,0xcaa2,0xc1a3,0,0,0,0,0xc2dc, /* '腰','腱',0,0,'腴',0,0,'腷', '腸','腹','腺',0,0,0,0,'腿', */
	/* 8180 */ 0xe7af,0x8fd6c5,0xe7b0,0xe7ac,0x8fd6c7,0x8fd6c8,0x8fd6c9,0, 0xe7ad,0,0xe7ae,0x8fd6ca,0,0,0x8fd6cb,0xb9d1, /* '膀','膁','膂','膃','膄','膅','膆',0, '膈',0,'膊','膋',0,0,'膎','膏', */
	/* 8190 */ 0x8fd6c6,0,0,0xe7b6,0,0xe7b2,0x8fd6cc,0, 0x8fd6cd,0,0xc9e6,0x8fd6ce,0xcbec,0xc9a8,0x8fd6cf,0, /* '膐',0,0,'膓',0,'膕','膖',0, '膘',0,'膚','膛','膜','膝','膞',0, */
	/* 81a0 */ 0xe7b1,0,0x8fd6d0,0xe7b4,0xe7b3,0,0,0, 0xcbc4,0xe7b7,0,0,0,0,0x8fd6d1,0, /* '膠',0,'膢','膣','膤',0,0,0, '膨','膩',0,0,0,0,'膮',0, */
	/* 81b0 */ 0xe7b8,0,0x8fd6d2,0xc1b7,0x8fd6d3,0xe7b9,0,0, 0xe7bb,0,0xe7bf,0x8fd6d4,0,0xe7bc,0xe7ba,0xc7bf, /* '膰',0,'膲','膳','膴','膵',0,0, '膸',0,'膺','膻',0,'膽','膾','膿', */
	/* 81c0 */ 0xe7bd,0,0xe7be,0x8fd6d6,0,0x8fd6d7,0xb2b2,0, 0xe7c5,0xe7c0,0x8fd6d8,0x8fd6d5,0,0xe7c1,0x8fd6d9,0x8fd6da, /* '臀',0,'臂','臃',0,'臅','臆',0, '臈','臉','臊','臋',0,'臍','臎','臏', */
	/* 81d0 */ 0,0xe7c2,0,0xc2a1,0,0x8fd6db,0,0x8fd6dc, 0xe7c4,0xe7c3,0xe7c6,0x8fd6dd,0,0x8fd6de,0x8fd6df,0xe7c7, /* 0,'臑',0,'臓',0,'臕',0,'臗', '臘','臙','臚','臛',0,'臝','臞','臟', */
	/* 81e0 */ 0xe7c8,0x8fd6e0,0,0xbfc3,0x8fd6e1,0xb2e9,0,0xe7c9, 0xced7,0,0xbcab,0x8fd6e2,0x8fd6e3,0xbdad,0,0, /* '臠','臡',0,'臣','臤','臥',0,'臧', '臨',0,'自','臫','臬','臭',0,0, */
	/* 81f0 */ 0x8fd6e4,0x8fd6e5,0x8fd6e6,0xbbea,0xc3d7,0x8fd6e7,0x8fd6e8,0, 0x8fd6e9,0x8fd6ea,0xe7ca,0xe7cb,0xb1b1,0x8fd6eb,0xe7cc,0x8fd6ec, /* '臰','臱','臲','至','致','臵','臶',0, '臸','臹','臺','臻','臼','臽','臾','臿', */
	/* 8200 */ 0x8fd6ed,0xe7cd,0xe7ce,0x8fd6ee,0,0xe7cf,0,0xe7d0, 0xb6bd,0xdaaa,0xe7d1,0,0xc0e5,0xe7d2,0xbccb,0x8fd6ef, /* '舀','舁','舂','舃',0,'舅',0,'與', '興','舉','舊',0,'舌','舍','舎','舏', */
	/* 8210 */ 0xe7d3,0,0xd0b0,0x8fd6f0,0x8fd6f1,0,0xe7d4,0xcade, 0xb4dc,0x8fd6f2,0x8fd6f3,0xc1a4,0xbdd8,0x8fd6f4,0xc9f1,0xbdae, /* '舐',0,'舒','舓','舔',0,'舖','舗', '舘','舙','舚','舛','舜','舝','舞','舟', */
	/* 8220 */ 0,0x8fd6f5,0x8fd6f6,0,0,0,0,0, 0x8fd6f7,0xe7d5,0xb9d2,0xe7d6,0xc8cc,0,0xe7e4,0, /* 0,'舡','舢',0,0,0,0,0, '舨','舩','航','舫','般',0,'舮',0, */
	/* 8230 */ 0,0,0x8fd6f8,0xe7d8,0x8fd6f9,0xc2c9,0xc7f5,0xb8bf, 0xe7d7,0xc1a5,0x8fd6fa,0,0,0,0,0, /* 0,0,'舲','舳','舴','舵','舶','舷', '舸','船','舺',0,0,0,0,0, */
	/* 8240 */ 0xe7d9,0,0,0x8fd6fb,0x8fd6fc,0x8fd6fd,0x8fd6fe,0xc4fa, 0,0,0,0x8fd7a1,0,0,0x8fd7a2,0x8fd7a3, /* '艀',0,0,'艃','艄','艅','艆','艇', 0,0,0,'艋',0,0,'艎','艏', */
	/* 8250 */ 0,0x8fd7a4,0,0,0,0,0x8fd7a5,0, 0xe7db,0xe7da,0xe7dd,0,0x8fd7a6,0xe7dc,0,0xe7de, /* 0,'艑',0,0,0,0,'艖',0, '艘','艙','艚',0,'艜','艝',0,'艟', */
	/* 8260 */ 0x8fd7a7,0,0xe7e0,0x8fd7a8,0xe7df,0,0xb4cf,0x8fd7a9, 0xe7e1,0,0xe7e2,0xe7e3,0,0x8fd7aa,0xbab1,0xcec9, /* '艠',0,'艢','艣','艤',0,'艦','艧', '艨',0,'艪','艫',0,'艭','艮','良', */
	/* 8270 */ 0,0xe7e5,0xbfa7,0,0x8fd7ab,0,0xb1f0,0xe7e6, 0xe7e7,0,0,0x8fd7ac,0,0x8fd7ad,0xe7e8,0x8fd7ae, /* 0,'艱','色',0,'艴',0,'艶','艷', '艸',0,0,'艻',0,'艽','艾','艿', */
	/* 8280 */ 0x8fd7af,0x8fd7b0,0,0x8fd7b1,0x8fd7b2,0,0,0x8fd7b3, 0,0x8fd7b4,0x8fd7b5,0xb0f2,0,0xe7e9,0x8fd7b6,0, /* '芀','芁',0,'芃','芄',0,0,'芇', 0,'芉','芊','芋',0,'芍','芎',0, */
	/* 8290 */ 0,0x8fd7b7,0xe7ea,0,0x8fd7b8,0,0x8fd7b9,0, 0x8fd7ba,0xc9e7,0x8fd7bb,0x8fd7bc,0,0xbcc7,0,0xe7ec, /* 0,'芑','芒',0,'芔',0,'芖',0, '芘','芙','芚','芛',0,'芝',0,'芟', */
	/* 82a0 */ 0x8fd7bd,0x8fd7be,0,0x8fd7bf,0x8fd7c0,0xb3a9,0xb0b2,0x8fd7c1, 0x8fd7c2,0x8fd7c3,0x8fd7c4,0xe7eb,0xe7ee,0xc7ce,0x8fd7c5,0xbfc4, /* '芠','芡',0,'芣','芤','芥','芦','芧', '芨','芩','芪','芫','芬','芭','芮','芯', */
	/* 82b0 */ 0x8fd7c6,0xb2d6,0x8fd7c7,0xcba7,0x8fd7c8,0,0,0x8fd7c9, 0xb7dd,0xb6dc,0x8fd7ca,0xe7ed,0x8fd7cb,0xb2ea,0x8fd7cc,0x8fd7cd, /* '芰','花','芲','芳','芴',0,0,'芷', '芸','芹','芺','芻','芼','芽','芾','芿', */
	/* 82c0 */ 0,0,0,0,0,0xb4a3,0x8fd7ce,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'苅','苆',0, 0,0,0,0,0,0,0,0, */
	/* 82d0 */ 0x8fd7cf,0xb1f1,0xe7f2,0xceea,0xc2dd,0x8fd7d0,0,0xc9c4, 0,0xe7fe,0x8fd7d1,0xb2d7,0xe7fc,0,0xe7fa,0xe7f1, /* '苐','苑','苒','苓','苔','苕',0,'苗', 0,'苙','苚','苛','苜',0,'苞','苟', */
	/* 82e0 */ 0x8fd7d2,0xe7ef,0x8fd7d3,0xe7f0,0x8fd7d4,0xbce3,0xb6ec,0xc3f7, 0x8fd7d5,0,0x8fd7d6,0xc6d1,0,0x8fd7d7,0,0x8fd7d8, /* '苠','苡','苢','苣','苤','若','苦','苧', '苨',0,'苪','苫',0,'苭',0,'苯', */
	/* 82f0 */ 0,0xb1d1,0,0xe7f4,0xe7f3,0,0x8fd7d9,0x8fd7da, 0,0xe7f9,0xe7f5,0xe7f8,0,0x8fd7db,0x8fd7dc,0, /* 0,'英',0,'苳','苴',0,'苶','苷', 0,'苹','苺','苻',0,'苽','苾',0, */
	/* 8300 */ 0x8fd7dd,0x8fd7de,0xccd0,0xe7f7,0xb2d8,0xb3fd,0xe7fb,0x8fd7df, 0x8fd7e0,0xe7fd,0x8fd7e1,0x8fd7e2,0,0,0xb7d4,0, /* '茀','茁','茂','范','茄','茅','茆','茇', '茈','茉','茊','茋',0,0,'茎',0, */
	/* 8310 */ 0,0,0,0,0,0,0xe8a3,0xe8ac, 0xe8ad,0,0,0x8fd7e4,0xb0ab,0x8fd7e5,0x8fd7e6,0x8fd7e7, /* 0,0,0,0,0,0,'茖','茗', '茘',0,0,'茛','茜','茝','茞','茟', */
	/* 8320 */ 0,0x8fd7e8,0x8fd7e9,0xe8b4,0,0,0,0, 0xb0f1,0,0,0xe8ab,0x8fd7ea,0x8fd7eb,0x8fd7ec,0xe8aa, /* 0,'茡','茢','茣',0,0,0,0, '茨',0,0,'茫','茬','茭','茮','茯', */
	/* 8330 */ 0x8fd7ed,0xe8a5,0xe8a4,0x8fd7ee,0xe8a2,0xe8a1,0xc3e3,0x8fd7ef, 0xc2fb,0xe8a7,0x8fd7f0,0,0x8fd7f1,0x8fd7f2,0,0, /* '茰','茱','茲','茳','茴','茵','茶','茷', '茸','茹','茺',0,'茼','茽',0,0, */
	/* 8340 */ 0xe8a6,0,0x8fd7f3,0x8fd7f4,0x8fd7f5,0xe8a9,0,0x8fd7f6, 0,0xc1f0,0xb7d5,0,0,0x8fd7f7,0x8fd7f8,0xb1c1, /* '荀',0,'荂','荃','荄','荅',0,'荇', 0,'草','荊',0,0,'荍','荎','荏', */
	/* 8350 */ 0xe8a8,0x8fd7f9,0xb9d3,0x8fd8be,0x8fd7e3,0x8fd7fa,0x8fd7fb,0x8fd7fc, 0xc1f1,0,0,0,0,0,0,0, /* '荐','荑','荒','荓','荔','荕','荖','荗', '荘',0,0,0,0,0,0,0, */
	/* 8360 */ 0,0,0x8ff4df,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'荢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8370 */ 0x8fd7fd,0,0,0xe8ba,0,0xe8bb,0,0xb2d9, 0x8fd7fe,0,0,0xb2ae,0xe8b8,0x8fd8a1,0,0x8fd8a2, /* '荰',0,0,'荳',0,'荵',0,'荷', '荸',0,0,'荻','荼','荽',0,'荿', */
	/* 8380 */ 0x8fd8a3,0,0x8fd8a4,0,0x8fd8a5,0xe8ae,0x8fd8a6,0xe8b6, 0,0xe8bd,0xe8b7,0,0,0x8fd8a7,0xe8b5,0, /* '莀',0,'莂',0,'莄','莅','莆','莇', 0,'莉','莊',0,0,'莍','莎',0, */
	/* 8390 */ 0,0,0x8fd8a8,0xe7f6,0x8fd8a9,0x8fd8aa,0xe8b3,0, 0x8fd8ab,0x8fd8ac,0xe8af,0x8fd8ad,0x8fd8ae,0x8fd8af,0xb4d0,0xe8b1, /* 0,0,'莒','莓','莔','莕','莖',0, '莘','莙','莚','莛','莜','莝','莞','莟', */
	/* 83a0 */ 0xe8bc,0,0xe8b2,0,0,0,0x8fd8b0,0x8fd8b1, 0xe8be,0x8fd8b2,0xe8b0,0xc7fc,0x8fd8b3,0x8fd8cc,0,0, /* '莠',0,'莢',0,0,0,'莦','莧', '莨','莩','莪','莫','莬','莭',0,0, */
	/* 83b0 */ 0,0xcde9,0,0,0,0xe8b9,0,0, 0,0,0,0,0,0xe8cf,0x8fd8b4,0x8fd8b5, /* 0,'莱',0,0,0,'莵',0,0, 0,0,0,0,0,'莽','莾','莿', */
	/* 83c0 */ 0x8fd8b6,0xe8c7,0,0,0,0xbffb,0,0x8fd8b7, 0,0x8fd8b8,0xb5c6,0,0xb6dd,0,0xe8c2,0x8fd8b9, /* '菀','菁',0,0,0,'菅',0,'菇', 0,'菉','菊',0,'菌',0,'菎','菏', */
	/* 83d0 */ 0x8fd8ba,0x8fd8bb,0,0xb2db,0x8fd8bc,0,0xbed4,0, 0xe8c5,0,0,0,0xbada,0x8fd8bd,0,0xc5d1, /* '菐','菑',0,'菓','菔',0,'菖',0, '菘',0,0,0,'菜','菝',0,'菟', */
	/* 83e0 */ 0xe8ca,0,0,0,0,0,0,0, 0x8fd8bf,0xcaee,0x8fd8c0,0xe8c1,0,0,0,0xb2da, /* '菠',0,0,0,0,0,0,0, '菨','菩','菪','菫',0,0,0,'華', */
	/* 83f0 */ 0xb8d6,0xc9a9,0xe8cb,0,0xe8bf,0,0x8fd8c1,0xe8c8, 0x8fd8c2,0x8fd8c3,0,0xe8d2,0x8fd8c4,0xe8c3,0,0, /* '菰','菱','菲',0,'菴',0,'菶','菷', '菸','菹',0,'菻','菼','菽',0,0, */
	/* 8400 */ 0,0x8fd8c5,0,0xe8c4,0xc6ba,0,0x8fd8c6,0xe8c9, 0,0,0x8fd8c7,0xe8c6,0xcba8,0xe8cc,0xb0e0,0x8fd8c8, /* 0,'萁',0,'萃','萄',0,'萆','萇', 0,0,'萊','萋','萌','萍','萎','萏', */
	/* 8410 */ 0,0x8fd8c9,0,0xe8c0,0,0x8fd8ca,0,0, 0,0x8fd8cb,0,0,0,0,0,0, /* 0,'萑',0,'萓',0,'萕',0,0, 0,'萙',0,0,0,0,0,0, */
	/* 8420 */ 0xe8ce,0,0xe8cd,0,0,0,0,0, 0,0xc7eb,0xe8d4,0,0xe8df,0,0,0x8fd8cd, /* '萠',0,'萢',0,0,0,0,0, 0,'萩','萪',0,'萬',0,0,'萯', */
	/* 8430 */ 0,0xb3fe,0,0,0,0xe8e2,0,0, 0xe8d0,0x8fd8ce,0,0,0xe8d5,0xcdee,0,0, /* 0,'萱',0,0,0,'萵',0,0, '萸','萹',0,0,'萼','落',0,0, */
	/* 8440 */ 0,0,0,0,0,0x8fd8cf,0xe8de,0x8fd8d0, 0x8fd8d1,0xcdd5,0x8fd8d2,0,0,0x8fd8d3,0xceaa,0x8fd8d4, /* 0,0,0,0,0,'葅','葆','葇', '葈','葉','葊',0,0,'葍','葎','葏', */
	/* 8450 */ 0,0x8fd8d5,0x8fd8d6,0,0,0,0x8fd8d7,0xc3f8, 0x8fd8d8,0x8fd8d9,0x8fd8da,0xb3eb,0x8fd8db,0,0,0, /* 0,'葑','葒',0,0,0,'葖','著', '葘','葙','葚','葛','葜',0,0,0, */
	/* 8460 */ 0x8fd8dc,0xc9f2,0xe8e4,0xc6a1,0x8fd8dd,0x8fd8de,0xb0b1,0x8fd8df, 0,0xe8dd,0x8fd8e0,0xe8d9,0xc1f2,0xe8d3,0xe8db,0xe8e0, /* '葠','葡','葢','董','葤','葥','葦','葧', 0,'葩','葪','葫','葬','葭','葮','葯', */
	/* 8470 */ 0x8fd8e1,0xc7ac,0,0x8fd8e2,0x8fd8e3,0xb0aa,0x8fd8e4,0xe8d8, 0x8fd8e5,0xe8e1,0xc9f8,0,0x8fd8e6,0x8fd8e7,0,0, /* '葰','葱',0,'葳','葴','葵','葶','葷', '葸','葹','葺',0,'葼','葽',0,0, */
	/* 8480 */ 0,0x8fd8e8,0xe8dc,0,0xe8d7,0x8fd8e9,0,0, 0,0,0,0xbed5,0,0,0,0, /* 0,'蒁','蒂',0,'蒄','蒅',0,0, 0,0,0,'蒋',0,0,0,0, */
	/* 8490 */ 0xbdaf,0,0x8fd8ea,0x8fd8eb,0xbcac,0x8fd8ec,0,0, 0,0xccd8,0,0,0xc9c7,0,0x8fd8ed,0xe8e7, /* '蒐',0,'蒒','蒓','蒔','蒕',0,0, 0,'蒙',0,0,'蒜',0,'蒞','蒟', */
	/* 84a0 */ 0,0xe8f0,0,0,0,0,0x8fd8ee,0, 0x8fd8ef,0x8fd8f0,0x8fd8f1,0,0,0xe8da,0,0x8fd8f2, /* 0,'蒡',0,0,0,0,'蒦',0, '蒨','蒩','蒪',0,0,'蒭',0,'蒯', */
	/* 84b0 */ 0,0x8fd8f3,0xb3f7,0,0x8fd8f4,0,0,0, 0xbef8,0xe8e5,0x8fd8f5,0xe8ea,0xc1f3,0x8fd8f6,0x8fd8f7,0xe8e6, /* 0,'蒱','蒲',0,'蒴',0,0,0, '蒸','蒹','蒺','蒻','蒼','蒽','蒾','蒿', */
	/* 84c0 */ 0x8fd8f8,0xe8ed,0x8fd8f9,0,0xc3df,0,0xe8ee,0x8fd8fa, 0x8fd8fb,0xcdd6,0xe8e3,0xb3b8,0x8fd8fc,0xe8e9,0,0x8fd8fd, /* '蓀','蓁','蓂',0,'蓄',0,'蓆','蓇', '蓈','蓉','蓊','蓋','蓌','蓍',0,'蓏', */
	/* 84d0 */ 0xe8ec,0xccac,0,0x8fd8fe,0,0,0xe8ef,0, 0,0xe8e8,0xe8eb,0,0x8fd9a1,0,0,0, /* '蓐','蓑',0,'蓓',0,0,'蓖',0, 0,'蓙','蓚',0,'蓜',0,0,0, */
	/* 84e0 */ 0,0,0,0,0,0,0,0x8fd9a2, 0,0,0x8fd9a3,0,0xcba9,0,0xcfa1,0x8fd9a4, /* 0,0,0,0,0,0,0,'蓧', 0,0,'蓪',0,'蓬',0,'蓮','蓯', */
	/* 84f0 */ 0x8fd9a5,0x8fd9a6,0x8fd9a7,0,0xe8f3,0,0,0x8fd9a8, 0,0,0x8fd9aa,0x8fd9ab,0xe8fa,0x8fd9ac,0,0xe8f2, /* '蓰','蓱','蓲',0,'蓴',0,0,'蓷', 0,0,'蓺','蓻','蓼','蓽',0,'蓿', */
	/* 8500 */ 0xbcc3,0,0x8fd9ad,0x8fd9ae,0,0,0xe8d1,0x8fd9af, 0,0,0,0,0x8fd9b0,0,0x8fd9b1,0, /* '蔀',0,'蔂','蔃',0,0,'蔆','蔇', 0,0,0,0,'蔌',0,'蔎',0, */
	/* 8510 */ 0x8fd9b2,0xcace,0,0xcca2,0xe8f9,0xe8f8,0,0xe8f4, 0xe8f5,0,0xb1b6,0,0x8fd9b3,0,0x8fd9b4,0xe8f7, /* '蔐','蔑',0,'蔓','蔔','蔕',0,'蔗', '蔘',0,'蔚',0,'蔜',0,'蔞','蔟', */
	/* 8520 */ 0,0xe8f1,0x8fd9b5,0x8fd9b6,0x8fd9b7,0x8fd9b8,0xc4d5,0x8fd9b9, 0,0,0x8fd9ba,0x8fd9bb,0xe8f6,0xb0fe,0,0x8fd9bc, /* 0,'蔡','蔢','蔣','蔤','蔥','蔦','蔧', 0,0,'蔪','蔫','蔬','蔭',0,'蔯', */
	/* 8530 */ 0,0,0x8fd9a9,0x8fd9bd,0x8fd9be,0xc2a2,0x8fd9bf,0, 0,0,0,0,0,0xcac3,0,0x8fd9c0, /* 0,0,'蔲','蔳','蔴','蔵','蔶',0, 0,0,0,0,0,'蔽',0,'蔿', */
	/* 8540 */ 0xe8fb,0xe9a1,0,0xc8d9,0,0,0x8fd9c1,0, 0xe8fe,0xbed6,0xbcc9,0xe9a3,0,0,0xb6be,0x8fd9c2, /* '蕀','蕁',0,'蕃',0,0,'蕆',0, '蕈','蕉','蕊','蕋',0,0,'蕎','蕏', */
	/* 8550 */ 0x8fd9c3,0x8fd9c4,0x8fd9c5,0x8fd9c6,0,0xe9a4,0x8fd9c7,0xc9f9, 0xe8fd,0x8fd9c8,0xe8d6,0,0x8fd9c9,0x8fd9ca,0x8fd9cb,0x8fd9cc, /* '蕐','蕑','蕒','蕓',0,'蕕','蕖','蕗', '蕘','蕙','蕚',0,'蕜','蕝','蕞','蕟', */
	/* 8560 */ 0x8fd9cd,0x8fd9ce,0x8fd9cf,0xe8fc,0x8fd9d0,0,0,0, 0xcfcf,0xc6a2,0xc9f3,0x8fd9d1,0,0xe9ab,0,0x8fd9d2, /* '蕠','蕡','蕢','蕣','蕤',0,0,0, '蕨','蕩','蕪','蕫',0,'蕭',0,'蕯', */
	/* 8570 */ 0,0,0,0,0,0,0,0xe9b1, 0,0x8fd9d3,0x8fd9d4,0x8fd9d5,0,0x8fd9d6,0xe9b2,0x8fd9d7, /* 0,0,0,0,0,0,0,'蕷', 0,'蕹','蕺','蕻',0,'蕽','蕾','蕿', */
	/* 8580 */ 0xe9a5,0x8fd9d8,0,0,0xc7f6,0x8fd9d9,0x8fd9da,0xe9af, 0xe9a7,0x8fd9db,0xe9a9,0x8fd9dc,0x8fd9dd,0,0,0x8fd9de, /* '薀','薁',0,0,'薄','薅','薆','薇', '薈','薉','薊','薋','薌',0,0,'薏', */
	/* 8590 */ 0xe9b3,0xe9a8,0,0x8fd9df,0xe9ac,0,0,0xb1f2, 0x8fd9e0,0xc6e5,0,0xe9ad,0xe9b0,0x8fd9e1,0,0x8fd9e2, /* '薐','薑',0,'薓','薔',0,0,'薗', '薘','薙',0,'薛','薜','薝',0,'薟', */
	/* 85a0 */ 0x8fd9e3,0,0x8fd9e4,0,0xe9a6,0x8fd9e5,0xc1a6,0x8fd9e6, 0xe9aa,0xbba7,0xbfc5,0xb7b0,0xccf4,0x8fd9f4,0xccf9,0xbdf2, /* '薠',0,'薢',0,'薤','薥','薦','薧', '薨','薩','薪','薫','薬','薭','薮','薯', */
	/* 85b0 */ 0x8ff4e1,0,0,0,0x8fd9e7,0,0x8fd9e8,0x8fd9e9, 0x8fd9ea,0xe9b7,0xe9b5,0,0x8fd9eb,0x8fd9ec,0x8fd9ed,0x8fd9ee, /* '薰',0,0,0,'薴',0,'薶','薷', '薸','薹','薺',0,'薼','薽','薾','薿', */
	/* 85c0 */ 0,0xcfce,0x8fd9ef,0,0,0,0,0x8fd9f0, 0,0xe9b4,0x8fd9f1,0x8fd9f2,0,0xcdf5,0x8fd9f3,0xe9b6, /* 0,'藁','藂',0,0,0,0,'藇', 0,'藉','藊','藋',0,'藍','藎','藏', */
	/* 85d0 */ 0xe9b8,0,0,0,0,0xe9b9,0,0, 0x8fd9f5,0,0x8fd9f6,0,0xe9bc,0xe9ba,0,0x8fd9f7, /* '藐',0,0,0,0,'藕',0,0, '藘',0,'藚',0,'藜','藝',0,'藟', */
	/* 85e0 */ 0x8fd9f8,0,0,0,0xc6a3,0xe9bb,0x8fd9f9,0, 0x8fd9fa,0xc8cd,0xe9ae,0,0,0x8fd9fb,0,0, /* '藠',0,0,0,'藤','藥','藦',0, '藨','藩','藪',0,0,'藭',0,0, */
	/* 85f0 */ 0,0,0,0x8fd9fc,0,0,0x8fd9fd,0xbdf3, 0,0xe9bd,0xe9c2,0xc1f4,0x8fd9fe,0,0xe9c1,0x8fdaa1, /* 0,0,0,'藳',0,0,'藶','藷', 0,'藹','藺','藻','藼',0,'藾','藿', */
	/* 8600 */ 0x8fdaa2,0,0xe9a2,0,0x8fdaa3,0x8fdaa4,0xe9c3,0xc1c9, 0,0,0xe9be,0xe9c0,0,0x8fdaa5,0x8fdaa6,0, /* '蘀',0,'蘂',0,'蘄','蘅','蘆','蘇', 0,0,'蘊','蘋',0,'蘍','蘎',0, */
	/* 8610 */ 0x8fdaa7,0x8fdaa8,0x8fdaa9,0xe9bf,0,0,0xddb1,0xdda2, 0x8fdaaa,0x8fdaab,0xe9c5,0x8fdaac,0,0,0x8fdaad,0, /* '蘐','蘑','蘒','蘓',0,0,'蘖','蘗', '蘘','蘙','蘚','蘛',0,0,'蘞',0, */
	/* 8620 */ 0,0x8fdaae,0xe9c4,0,0,0,0,0x8fdaaf, 0,0x8fdab0,0,0,0,0xcdf6,0,0xe2bc, /* 0,'蘡','蘢',0,0,0,0,'蘧', 0,'蘩',0,0,0,'蘭',0,'蘯', */
	/* 8630 */ 0xe9c6,0,0,0,0,0,0x8fdab1,0, 0x8fdab2,0,0x8fdab3,0,0x8fdab4,0x8fdab5,0,0xe9c7, /* '蘰',0,0,0,0,0,'蘶',0, '蘸',0,'蘺',0,'蘼','蘽',0,'蘿', */
	/* 8640 */ 0x8fdab6,0x8fb8e6,0x8fdab7,0,0,0,0x8fdab8,0, 0,0,0,0,0,0xe9c8,0xb8d7,0, /* '虀','虁','虂',0,0,0,'虆',0, 0,0,0,0,0,'虍','虎',0, */
	/* 8650 */ 0xb5d4,0,0x8fdab9,0x8fdaba,0xe9ca,0xd1dd,0x8fdabb,0x8fdabc, 0x8fdabd,0x8fdabe,0xb5f5,0,0xceba,0x8fdabf,0xb6f3,0xe9cb, /* '虐',0,'虒','虓','虔','處','虖','虗', '虘','虙','虚',0,'虜','虝','虞','號', */
	/* 8660 */ 0x8fdac0,0x8fdac1,0x8fdac2,0x8fdac3,0x8fdac4,0,0,0xe9cc, 0,0x8fdac5,0,0xc3ee,0x8fdac6,0,0,0x8fdac7, /* '虠','虡','虢','虣','虤',0,0,'虧', 0,'虩',0,'虫','虬',0,0,'虯', */
	/* 8670 */ 0,0xe9cd,0,0,0,0x8fdac8,0x8fdac9,0x8fdaca, 0,0xc6fa,0x8fdacb,0xb0ba,0,0,0,0, /* 0,'虱',0,0,0,'虵','虶','虷', 0,'虹','虺','虻',0,0,0,0, */
	/* 8680 */ 0,0,0,0,0,0,0,0, 0x8fdaed,0,0xb2e3,0xe9d2,0xe9d3,0x8fdacc,0,0, /* 0,0,0,0,0,0,0,0, '蚈',0,'蚊','蚋','蚌','蚍',0,0, */
	/* 8690 */ 0,0x8fdacd,0,0xe9ce,0,0xbbbd,0x8fdace,0, 0x8fdacf,0,0x8fdad0,0,0x8fdad1,0,0,0, /* 0,'蚑',0,'蚓',0,'蚕','蚖',0, '蚘',0,'蚚',0,'蚜',0,0,0, */
	/* 86a0 */ 0,0x8fdad2,0,0xe9cf,0xc7c2,0,0x8fdad3,0x8fdad4, 0x8fdad5,0xe9d0,0xe9d1,0xe9db,0,0x8fdad6,0,0xe9d5, /* 0,'蚡',0,'蚣','蚤',0,'蚦','蚧', '蚨','蚩','蚪','蚫',0,'蚭',0,'蚯', */
	/* 86b0 */ 0xe9d8,0x8fdad7,0,0x8fdad8,0x8fdad9,0x8fdada,0xe9d4,0x8fdadb, 0x8fdadc,0x8fdadd,0,0,0,0,0,0x8fdade, /* '蚰','蚱',0,'蚳','蚴','蚵','蚶','蚷', '蚸','蚹',0,0,0,0,0,'蚿', */
	/* 86c0 */ 0x8fdadf,0x8fdae0,0,0x8fdae1,0xe9d6,0x8fdae2,0xe9d7,0xbcd8, 0,0xe9d9,0,0xc3c1,0,0xb7d6,0xb3c2,0, /* '蛀','蛁',0,'蛃','蛄','蛅','蛆','蛇', 0,'蛉',0,'蛋',0,'蛍','蛎',0, */
	/* 86d0 */ 0,0x8fdae3,0x8fdae4,0,0xe9dc,0x8fdae5,0,0x8fdae6, 0,0xb3bf,0x8fdae7,0xe9e1,0x8fdae8,0,0xe9dd,0xe9e0, /* 0,'蛑','蛒',0,'蛔','蛕',0,'蛗', 0,'蛙','蛚','蛛','蛜',0,'蛞','蛟', */
	/* 86e0 */ 0x8fdae9,0,0,0x8fdaea,0xc8ba,0x8fdaeb,0,0x8fdaec, 0,0xe9de,0,0,0xe9df,0xc9c8,0xc8da,0xe9e2, /* '蛠',0,0,'蛣','蛤','蛥',0,'蛧', 0,'蛩',0,0,'蛬','蛭','蛮','蛯', */
	/* 86f0 */ 0,0,0,0,0,0,0,0, 0xc2fd,0xe9ec,0x8fdaee,0xe9e8,0x8fdaef,0x8fdaf0,0xb2eb,0, /* 0,0,0,0,0,0,0,0, '蛸','蛹','蛺','蛻','蛼','蛽','蛾',0, */
	/* 8700 */ 0xe9e6,0,0xcbaa,0xe9e7,0x8fdaf1,0x8fdaf2,0xe9e4,0x8fdaf3, 0xe9e5,0xe9ea,0xe9ed,0x8fdaf4,0,0xe9eb,0x8fdaf5,0x8fdaf6, /* '蜀',0,'蜂','蜃','蜄','蜅','蜆','蜇', '蜈','蜉','蜊','蜋',0,'蜍','蜎','蜏', */
	/* 8710 */ 0x8fdaf7,0xe9e9,0xe9e3,0x8fdaf8,0x8fdaf9,0,0,0, 0xc3d8,0x8fdafa,0xe9f4,0,0xccaa,0,0x8fdafb,0x8fdafc, /* '蜐','蜑','蜒','蜓','蜔',0,0,0, '蜘','蜙','蜚',0,'蜜',0,'蜞','蜟', */
	/* 8720 */ 0,0x8fdafd,0,0x8fdafe,0,0xe9f2,0,0, 0x8fdba1,0xe9f3,0,0,0,0,0x8fdba2,0x8fdba3, /* 0,'蜡',0,'蜣',0,'蜥',0,0, '蜨','蜩',0,0,0,0,'蜮','蜯', */
	/* 8730 */ 0,0x8fdba4,0x8fdba5,0,0xe9ee,0,0,0xe9f0, 0,0x8fdba6,0x8fdba7,0xe9f1,0x8fdba8,0x8fdba9,0x8fdbaa,0xe9ef, /* 0,'蜱','蜲',0,'蜴',0,0,'蜷', 0,'蜹','蜺','蜻','蜼','蜽','蜾','蜿', */
	/* 8740 */ 0x8fdbab,0,0,0x8fdbac,0,0x8fdbad,0,0, 0,0xc0e6,0,0xcfb9,0xe9f8,0x8fdbae,0xe9f9,0, /* '蝀',0,0,'蝃',0,'蝅',0,0, 0,'蝉',0,'蝋','蝌','蝍','蝎',0, */
	/* 8750 */ 0,0,0,0xeaa1,0,0xbfaa,0,0xe9fb, 0x8fdbaf,0xe9fe,0,0,0,0x8fdbb0,0,0xe9f6, /* 0,0,0,'蝓',0,'蝕',0,'蝗', '蝘','蝙',0,0,0,'蝝',0,'蝟', */
	/* 8760 */ 0xe9f5,0x8fdbb1,0,0xeaa2,0x8fdbb2,0x8fdbb3,0xb2dc,0, 0xe9fc,0,0xeaa3,0,0,0,0xe9fd,0x8fdbb4, /* '蝠','蝡',0,'蝣','蝤','蝥','蝦',0, '蝨',0,'蝪',0,0,0,'蝮','蝯', */
	/* 8770 */ 0,0x8fdbb5,0x8fdbb6,0,0xe9fa,0,0xc4b3,0, 0xe9f7,0,0,0x8fdbb7,0,0,0,0xc7e8, /* 0,'蝱','蝲',0,'蝴',0,'蝶',0, '蝸',0,0,'蝻',0,0,0,'蝿', */
	/* 8780 */ 0,0,0xeaa7,0x8fdbb8,0x8fdbb9,0x8fdbba,0x8fdbbb,0x8fdbbc, 0x8fdbbd,0x8fdbbe,0,0x8fdbbf,0x8fdbc0,0xcdbb,0,0, /* 0,0,'螂','螃','螄','螅','螆','螇', '螈','螉',0,'螋','螌','融',0,0, */
	/* 8790 */ 0x8fdbc1,0,0,0x8fdbc2,0,0x8fdbc3,0,0x8fdbc4, 0x8fdbc5,0x8fdbc6,0,0,0,0,0x8fdbc7,0xeaa6, /* '螐',0,0,'螓',0,'螕',0,'螗', '螘','螙',0,0,0,0,'螞','螟', */
	/* 87a0 */ 0x8fdbc8,0,0xeaa5,0x8fdbc9,0,0,0,0x8fdbca, 0,0,0,0xeaae,0x8fdbcb,0x8fdbcc,0x8fdbcd,0xeaa8, /* '螠',0,'螢','螣',0,0,0,'螧', 0,0,0,'螫','螬','螭','螮','螯', */
	/* 87b0 */ 0,0x8fdbce,0,0xeab0,0,0x8fdbcf,0,0, 0,0,0xcde6,0xeab3,0,0xeaaa,0x8fdbd0,0x8fdbd1, /* 0,'螱',0,'螳',0,'螵',0,0, 0,0,'螺','螻',0,'螽','螾','螿', */
	/* 87c0 */ 0xeaab,0x8fdbd2,0,0,0xeaaf,0,0xeab2,0xeab1, 0x8fdbd3,0x8fdbd4,0x8fdbd5,0xeaa9,0,0,0x8fdbd6,0, /* '蟀','蟁',0,0,'蟄',0,'蟆','蟇', '蟈','蟉','蟊','蟋',0,0,'蟎',0, */
	/* 87d0 */ 0xeaac,0,0xeabd,0,0,0x8fdbd7,0x8fdbd8,0, 0,0x8fdbd9,0x8fdbda,0,0x8fdbdb,0,0,0x8fdbdc, /* '蟐',0,'蟒',0,0,'蟕','蟖',0, 0,'蟙','蟚',0,'蟜',0,0,'蟟', */
	/* 87e0 */ 0xeab6,0,0x8fdbdd,0x8fdbde,0x8fdbdf,0,0,0, 0,0,0x8fdbe0,0x8fdbe1,0,0x8fdbe2,0,0xeab4, /* '蟠',0,'蟢','蟣','蟤',0,0,0, 0,0,'蟪','蟫',0,'蟭',0,'蟯', */
	/* 87f0 */ 0,0x8fdbe3,0xeab5,0x8fdbe4,0,0,0xeaba,0xeabb, 0x8fdbe5,0xb3aa,0x8fdbe6,0xb5c2,0,0,0xeab9,0x8fdbe7, /* 0,'蟱','蟲','蟳',0,0,'蟶','蟷', '蟸','蟹','蟺','蟻',0,0,'蟾','蟿', */
	/* 8800 */ 0,0x8fdbe8,0,0x8fdbe9,0,0xeaa4,0x8fdbea,0x8ff4e4, 0,0x8fdbeb,0x8fdbec,0x8fdbed,0,0xeab8,0xeabc,0xeab7, /* 0,'蠁',0,'蠃',0,'蠅','蠆','蠇', 0,'蠉','蠊','蠋',0,'蠍','蠎','蠏', */
	/* 8810 */ 0x8fdbee,0xeabe,0x8fdbf0,0x8fdbf1,0x8fdbf2,0xeac0,0xeabf,0, 0x8fdbf3,0x8fdbef,0x8fdbf4,0x8fdbf5,0x8fdbf6,0,0x8fdbf7,0x8fdbf8, /* '蠐','蠑','蠒','蠓','蠔','蠕','蠖',0, '蠘','蠙','蠚','蠛','蠜',0,'蠞','蠟', */
	/* 8820 */ 0,0xeac2,0xeac1,0xe9da,0,0,0,0xeac6, 0x8fdbf9,0,0,0,0,0x8fdbfa,0x8fdbfb,0, /* 0,'蠡','蠢','蠣',0,0,0,'蠧', '蠨',0,0,0,0,'蠭','蠮',0, */
	/* 8830 */ 0x8fdbfc,0xeac3,0x8fdbfd,0,0,0x8fdbfe,0xeac4,0, 0,0xeac5,0x8fdca1,0xeac7,0x8fdca2,0,0,0, /* '蠰','蠱','蠲',0,0,'蠵','蠶',0, 0,'蠹','蠺','蠻','蠼',0,0,0, */
	/* 8840 */ 0xb7ec,0x8fdca3,0xeac9,0x8fdca4,0xeac8,0x8fdca5,0xbdb0,0, 0x8fdca6,0x8fdca7,0x8fdca8,0x8fdca9,0xb9d4,0xdea7,0x8fdcaa,0, /* '血','衁','衂','衃','衄','衅','衆',0, '衈','衉','衊','衋','行','衍','衎',0, */
	/* 8850 */ 0,0x8fdcab,0xeaca,0xbdd1,0,0x8fdcac,0x8fdcad,0xb3b9, 0x8fdcae,0xeacb,0x8fdcaf,0xb1d2,0x8fdcb0,0xbed7,0xeacc,0x8fdcb1, /* 0,'衑','衒','術',0,'衕','衖','街', '衘','衙','衚','衛','衜','衝','衞','衟', */
	/* 8860 */ 0x8fdcb2,0xb9d5,0xeacd,0xb0e1,0x8fdcb3,0,0,0, 0xc9bd,0x8fdcb4,0,0xeace,0,0,0,0, /* '衠','衡','衢','衣','衤',0,0,0, '表','衩',0,'衫',0,0,0,0, */
	/* 8870 */ 0xbfea,0x8fdcb5,0xead5,0,0,0xead2,0,0xc3ef, 0,0x8fdcb6,0,0x8fdcb7,0,0xead3,0xead0,0xb6de, /* '衰','衱','衲',0,0,'衵',0,'衷', 0,'衹',0,'衻',0,'衽','衾','衿', */
	/* 8880 */ 0x8fdcb8,0xeacf,0xead6,0,0,0,0,0, 0xb7b6,0,0,0xc2de,0,0xeadc,0,0, /* '袀','袁','袂',0,0,0,0,0, '袈',0,0,'袋',0,'袍',0,0, */
	/* 8890 */ 0,0,0xead8,0,0,0,0xc2b5,0xead7, 0x8fdcb9,0xeada,0x8fdcba,0x8fdcbb,0x8fdcbc,0,0xead1,0x8fdcbd, /* 0,0,'袒',0,0,0,'袖','袗', '袘','袙','袚','袛','袜',0,'袞','袟', */
	/* 88a0 */ 0x8fdcbe,0,0xeadb,0,0xeadd,0,0,0, 0x8fdcbf,0,0x8fdcc0,0xc8ef,0,0,0xead9,0, /* '袠',0,'袢',0,'袤',0,0,0, '袨',0,'袪','被',0,0,'袮',0, */
	/* 88b0 */ 0xeade,0xeae0,0,0,0xb8d3,0xead4,0,0xb0c1, 0,0,0x8fdcc1,0,0,0x8fdcc2,0x8fdcc3,0xeadf, /* '袰','袱',0,0,'袴','袵',0,'袷', 0,0,'袺',0,0,'袽','袾','袿', */
	/* 88c0 */ 0x8fdcc4,0xbadb,0xcef6,0xeae1,0xeae2,0xc1f5,0,0, 0,0,0x8fdcc5,0x8fdcc6,0x8fdcc7,0x8fdcc8,0x8fdcc9,0xcea2, /* '裀','裁','裂','裃','裄','装',0,0, 0,0,'裊','裋','裌','裍','裎','裏', */
	/* 88d0 */ 0,0x8fdcca,0x8fdccb,0x8fdccc,0xeae3,0xcdb5,0,0, 0xeae4,0xeae5,0,0x8fdccd,0xcae4,0xeae6,0x8fdcce,0xbac0, /* 0,'裑','裒','裓','裔','裕',0,0, '裘','裙',0,'裛','補','裝','裞','裟', */
	/* 88e0 */ 0,0xcea3,0,0,0,0,0,0x8fdccf, 0xeaeb,0,0,0,0,0,0,0x8fdcd0, /* 0,'裡',0,0,0,0,0,'裧', '裨',0,0,0,0,0,0,'裯', */
	/* 88f0 */ 0x8fdcd1,0x8fdcd2,0xeaec,0xbed8,0xeaea,0x8fdcd3,0,0x8fdcd4, 0xcde7,0xeae7,0,0,0xeae9,0xc0bd,0xbffe,0, /* '裰','裱','裲','裳','裴','裵',0,'裷', '裸','裹',0,0,'裼','製','裾',0, */
	/* 8900 */ 0,0x8fdcd5,0xeae8,0,0xeaed,0,0x8fdcd6,0xcaa3, 0,0,0xeaef,0,0xeaee,0x8fdcd7,0x8fdcd8,0x8fdcd9, /* 0,'褁','褂',0,'褄',0,'褆','複', 0,0,'褊',0,'褌','褍','褎','褏', */
	/* 8910 */ 0xb3ec,0,0xcbab,0xeaf0,0,0x8fdcda,0x8fdcdb,0, 0x8fdcdc,0x8fdcdd,0x8fdcde,0,0x8fdcdf,0xeafc,0xeaf2,0, /* '褐',0,'褒','褓',0,'褕','褖',0, '褘','褙','褚',0,'褜','褝','褞',0, */
	/* 8920 */ 0x8fdce0,0,0,0,0,0xeaf3,0x8fdce1,0x8fdce2, 0x8fdce3,0,0xeaf4,0xeaf5,0,0,0,0, /* '褠',0,0,0,0,'褥','褦','褧', '褨',0,'褪','褫',0,0,0,0, */
	/* 8930 */ 0x8fdce4,0x8fdce5,0x8fdce6,0,0,0x8fdce7,0xeaf9,0, 0xeafa,0x8fdce8,0x8fdce9,0xeaf8,0,0,0x8fdcea,0, /* '褰','褱','褲',0,0,'褵','褶',0, '褸','褹','褺','褻',0,0,'褾',0, */
	/* 8940 */ 0x8fdceb,0xeaf6,0x8fdcec,0xeaf1,0xeaf7,0x8fdced,0x8fdcee,0, 0,0x8fdcef,0,0,0xeafb,0xf0b7,0,0x8fdcf0, /* '襀','襁','襂','襃','襄','襅','襆',0, 0,'襉',0,0,'襌','襍',0,'襏', */
	/* 8950 */ 0,0,0x8fdcf1,0,0,0,0xb2a8,0x8fdcf2, 0,0,0x8fdcf3,0x8fdcf4,0x8fdcf5,0,0xeafe,0xb6df, /* 0,0,'襒',0,0,0,'襖','襗', 0,0,'襚','襛','襜',0,'襞','襟', */
	/* 8960 */ 0xeafd,0x8fdcf6,0x8fdcf7,0x8fdcf8,0xeba2,0,0xeba1,0, 0,0,0xeba4,0x8fdcf9,0,0xeba3,0x8fdcfa,0xeba5, /* '襠','襡','襢','襣','襤',0,'襦',0, 0,0,'襪','襫',0,'襭','襮','襯', */
	/* 8970 */ 0x8fdcfb,0,0xbdb1,0x8fdcfc,0xeba6,0x8fdcfd,0,0xeba7, 0,0,0x8fdcfe,0x8fdda1,0x8fdda2,0x8fdda3,0xeba8,0xc0be, /* '襰',0,'襲','襳','襴','襵',0,'襷', 0,0,'襺','襻','襼','襽','襾','西', */
	/* 8980 */ 0,0xcdd7,0,0xeba9,0,0,0xcaa4,0xc7c6, 0xebaa,0x8fdda4,0xebab,0xb8ab,0,0x8fdda5,0,0xb5ac, /* 0,'要',0,'覃',0,0,'覆','覇', '覈','覉','覊','見',0,'覍',0,'規', */
	/* 8990 */ 0x8fdda6,0,0,0xebac,0x8fdda7,0x8fdda8,0xbbeb,0xc7c1, 0xebad,0,0xb3d0,0x8fdda9,0x8fddaa,0,0,0x8fddab, /* '覐',0,0,'覓','覔','覕','視','覗', '覘',0,'覚','覛','覜',0,0,'覟', */
	/* 89a0 */ 0x8fddac,0xebae,0,0,0,0x8fddad,0xebb0,0xcdf7, 0,0xebaf,0xbfc6,0,0xebb1,0,0,0xebb2, /* '覠','覡',0,0,0,'覥','覦','覧', 0,'覩','親',0,'覬',0,0,'覯', */
	/* 89b0 */ 0x8fddae,0,0xebb3,0xb4d1,0x8fddaf,0x8fddb0,0x8fddb1,0x8fddb2, 0,0,0xebb4,0,0x8fddb3,0xebb5,0,0xebb6, /* '覰',0,'覲','観','覴','覵','覶','覷', 0,0,'覺',0,'覼','覽',0,'覿', */
	/* 89c0 */ 0xebb7,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '觀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 89d0 */ 0,0,0xb3d1,0,0x8fddb4,0x8fddb5,0x8fddb6,0x8fddb7, 0x8fddb8,0,0xebb8,0,0xebb9,0xebba,0,0, /* 0,0,'角',0,'觔','觕','觖','觗', '觘',0,'觚',0,'觜','觝',0,0, */
	/* 89e0 */ 0,0,0,0xb2f2,0,0x8fddb9,0xbfa8,0xebbb, 0,0x8fddba,0,0x8fddbb,0,0x8fddbc,0,0, /* 0,0,0,'解',0,'觥','触','觧', 0,'觩',0,'觫',0,'觭',0,0, */
	/* 89f0 */ 0,0x8fddbd,0,0x8fddbe,0xebbc,0,0x8fddbf,0, 0xebbd,0x8fddc0,0,0,0,0x8fddc1,0,0x8fddc2, /* 0,'觱',0,'觳','觴',0,'觶',0, '觸','觹',0,0,0,'觽',0,'觿', */
	/* 8a00 */ 0xb8c0,0,0xc4fb,0xebbe,0x8fddc3,0x8fddc4,0,0x8fddc5, 0xb7d7,0,0xbfd6,0,0xebc1,0,0xc6a4,0x8fddc6, /* '言',0,'訂','訃','訄','訅',0,'訇', '計',0,'訊',0,'訌',0,'討','訏', */
	/* 8a10 */ 0xebc0,0x8fddc7,0x8fddc8,0xb7b1,0x8fddc9,0x8fddca,0xebbf,0xc2f7, 0xb5ad,0,0,0xebc2,0,0xebc3,0x8fddcb,0xbed9, /* '訐','訑','訒','訓','訔','訕','訖','託', '記',0,0,'訛',0,'訝','訞','訟', */
	/* 8a20 */ 0x8fddcc,0,0x8fddcd,0xb7ed,0x8fddce,0xebc4,0x8fddcf,0, 0,0,0xcbac,0x8fddd0,0x8fddd1,0xc0df,0,0x8fddd2, /* '訠',0,'訢','訣','訤','訥','訦',0, 0,0,'訪','訫','訬','設',0,'訯', */
	/* 8a30 */ 0,0xb5f6,0,0xccf5,0xc1ca,0x8fddd3,0xebc5,0x8fddd4, 0,0,0xbfc7,0xc3f0,0xbeda,0x8fddd5,0x8fddd6,0, /* 0,'許',0,'訳','訴','訵','訶','訷', 0,0,'診','註','証','訽','訾',0, */
	/* 8a40 */ 0x8fddd7,0xebc6,0,0x8fddd8,0,0x8fddd9,0xebc9,0x8fddda, 0xebca,0x8fdddb,0,0,0,0x8fdddc,0x8fdddd,0, /* '詀','詁',0,'詃',0,'詅','詆','詇', '詈','詉',0,0,0,'詍','詎',0, */
	/* 8a50 */ 0xbabe,0xc2c2,0xebc8,0x8fddde,0xbedb,0xc9be,0x8fdddf,0x8fdde0, 0x8fdde1,0,0,0xebc7,0x8fdde2,0x8fdde3,0xbbec,0, /* '詐','詑','詒','詓','詔','評','詖','詗', '詘',0,0,'詛','詜','詝','詞',0, */
	/* 8a60 */ 0xb1d3,0x8fdde4,0xebce,0xb7d8,0,0x8fdde5,0xbbee,0x8fdde6, 0,0xbbed,0,0xcfcd,0xebcd,0xebcc,0xc1a7,0, /* '詠','詡','詢','詣',0,'詥','試','詧', 0,'詩',0,'詫','詬','詭','詮',0, */
	/* 8a70 */ 0xb5cd,0xcfc3,0xb3ba,0xbedc,0,0x8fdde7,0x8fdde8,0x8fdde9, 0,0x8fddea,0x8fddeb,0x8fddec,0xebcb,0,0x8fdded,0x8fddee, /* '詰','話','該','詳',0,'詵','詶','詷', 0,'詹','詺','詻','詼',0,'詾','詿', */
	/* 8a80 */ 0x8fddef,0,0xebd0,0x8fddf0,0xebd1,0xebcf,0x8fddf1,0xb8d8, 0,0xcdc0,0,0x8fddf2,0xbbef,0xc7a7,0,0x8fddf3, /* '誀',0,'誂','誃','誄','誅','誆','誇', 0,'誉',0,'誋','誌','認',0,'誏', */
	/* 8a90 */ 0x8fddf4,0xebd4,0x8fddf5,0xc0c0,0,0xc3c2,0x8fddf6,0x8fddf7, 0xcdb6,0x8fddf8,0xebd7,0,0,0,0xb8ec,0x8fddf9, /* '誐','誑','誒','誓',0,'誕','誖','誗', '誘','誙','誚',0,0,0,'語','誟', */
	/* 8aa0 */ 0xc0bf,0xebd3,0,0xebd8,0xb8ed,0xebd5,0xebd6,0x8fddfa, 0xebd2,0x8fddfb,0,0,0xc0e2,0xc6c9,0x8fddfc,0x8fddfd, /* '誠','誡',0,'誣','誤','誥','誦','誧', '誨','誩',0,0,'説','読','誮','誯', */
	/* 8ab0 */ 0xc3af,0,0xb2dd,0x8fddfe,0,0,0x8fdea1,0x8fdea2, 0,0xc8f0,0,0x8fdea3,0xb5c3,0,0x8fdea4,0xc4b4, /* '誰',0,'課','誳',0,0,'誶','誷', 0,'誹',0,'誻','誼',0,'誾','調', */
	/* 8ac0 */ 0,0,0xebdb,0x8fdea5,0xebd9,0,0x8fdea6,0xc3cc, 0x8fdea7,0x8fdea8,0x8fdea9,0xc0c1,0xb4d2,0xebda,0,0xbfdb, /* 0,0,'諂','諃','諄',0,'諆','談', '諈','諉','諊','請','諌','諍',0,'諏', */
	/* 8ad0 */ 0,0x8fdeaa,0xceca,0x8fdeab,0x8fdeac,0x8fdead,0xcfc0,0x8fdeae, 0,0,0xebdc,0xebe7,0xc4b5,0x8fdeaf,0xebe6,0x8fdeb0, /* 0,'諑','諒','諓','諔','諕','論','諗', 0,0,'諚','諛','諜','諝','諞','諟', */
	/* 8ae0 */ 0xebe3,0xebeb,0xebe4,0,0xebe0,0,0xc4fc,0xebdf, 0,0,0,0xebdd,0x8fdeb1,0xcda1,0xbbf0,0, /* '諠','諡','諢',0,'諤',0,'諦','諧', 0,0,0,'諫','諬','諭','諮',0, */
	/* 8af0 */ 0x8fdeb2,0xebe1,0,0xebde,0x8fdeb3,0x8fdeb4,0x8fdeb5,0xebe5, 0xbdf4,0,0xb8c1,0,0x8fdeb6,0,0xc2fa,0x8fdeb7, /* '諰','諱',0,'諳','諴','諵','諶','諷', '諸',0,'諺',0,'諼',0,'諾','諿', */
	/* 8b00 */ 0xcbc5,0xb1da,0xb0e2,0,0xc6a5,0x8fdeb8,0x8fdeb9,0xebe9, 0,0,0x8fdebf,0x8fdeba,0xebe8,0,0xc6e6,0, /* '謀','謁','謂',0,'謄','謅','謆','謇', 0,0,'謊','謋','謌',0,'謎',0, */
	/* 8b10 */ 0xebed,0x8fdebb,0,0,0xebe2,0,0xebec,0xebee, 0,0xb8ac,0xebea,0xb9d6,0x8fdebc,0xbcd5,0x8fdebd,0x8fdebe, /* '謐','謑',0,0,'謔',0,'謖','謗', 0,'謙','謚','講','謜','謝','謞','謟', */
	/* 8b20 */ 0xebef,0xcdd8,0,0,0,0,0xebf2,0, 0xebf5,0,0,0xebf3,0xc9b5,0x8fdec0,0,0, /* '謠','謡',0,0,0,0,'謦',0, '謨',0,0,'謫','謬','謭',0,0, */
	/* 8b30 */ 0x8fdec1,0,0,0xebf0,0,0,0,0x8fdec2, 0,0xb6e0,0,0,0x8fdec3,0,0xebf4,0, /* '謰',0,0,'謳',0,0,0,'謷', 0,'謹',0,0,'謼',0,'謾',0, */
	/* 8b40 */ 0,0xebf6,0x8fdec4,0x8fdec5,0x8fdec6,0x8fdec7,0x8fdec8,0, 0x8fdec9,0xebfa,0,0,0xebf7,0x8fdece,0xebf9,0xebf8, /* 0,'譁','譂','譃','譄','譅','譆',0, '譈','證',0,0,'譌','譍','譎','譏', */
	/* 8b50 */ 0,0,0x8fdeca,0x8fdecb,0x8fdecc,0,0xebfb,0, 0xbcb1,0x8fdecd,0xebfd,0xebfc,0xc9e8,0,0x8fdecf,0xeca1, /* 0,0,'譒','譓','譔',0,'譖',0, '識','譙','譚','譛','譜',0,'譞','譟', */
	/* 8b60 */ 0,0,0,0x8fded0,0,0,0xb7d9,0, 0,0,0,0xebfe,0xeca2,0x8fded1,0,0xeca3, /* 0,0,0,'譣',0,0,'警',0, 0,0,0,'譫','譬','譭',0,'譯', */
	/* 8b70 */ 0xb5c4,0xe6c1,0xbef9,0,0xeca4,0,0x8fded2,0xb8ee, 0x8fded3,0x8fded4,0,0,0x8fded5,0xeca5,0x8fded6,0x8ff4e6, /* '議','譱','譲',0,'譴',0,'譶','護', '譸','譹',0,0,'譼','譽','譾','譿', */
	/* 8b80 */ 0xeca6,0x8fded7,0,0xbbbe,0x8fded8,0x8fded9,0,0, 0,0,0xdace,0x8fdeda,0xeca7,0x8fdedb,0xeca8,0x8fdedc, /* '讀','讁',0,'讃','讄','讅',0,0, 0,0,'變','讋','讌','讍','讎','讏', */
	/* 8b90 */ 0xbdb2,0,0xeca9,0xecaa,0x8fdedd,0x8fdede,0xecab,0, 0,0xecac,0xecad,0,0x8fdedf,0,0x8fdee0,0x8fdee1, /* '讐',0,'讒','讓','讔','讕','讖',0, 0,'讙','讚',0,'讜',0,'讞','讟', */
	/* 8ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c30 */ 0,0,0,0,0,0,0,0xc3ab, 0x8fdee2,0x8fdee3,0xecae,0,0,0x8fdee4,0x8fdee5,0xecb0, /* 0,0,0,0,0,0,0,'谷', '谸','谹','谺',0,0,'谽','谾','谿', */
	/* 8c40 */ 0,0xecaf,0,0,0,0x8fdee6,0xc6a6,0x8fdee7, 0xecb1,0x8fdee8,0xcbad,0x8fdee9,0xecb2,0,0xecb3,0x8fdeea, /* 0,'豁',0,0,0,'豅','豆','豇', '豈','豉','豊','豋','豌',0,'豎','豏', */
	/* 8c50 */ 0xecb4,0x8fdeeb,0,0x8fdeec,0x8fdeed,0xecb5,0,0x8fdeee, 0x8fdeef,0x8fdef2,0xc6da,0x8fdef0,0,0x8fdef1,0,0, /* '豐','豑',0,'豓','豔','豕',0,'豗', '豘','豙','豚','豛',0,'豝',0,0, */
	/* 8c60 */ 0,0xbedd,0xecb6,0x8fdef3,0x8fdef4,0,0x8fdef5,0, 0x8fdef6,0x8fdef7,0xb9eb,0xd0ae,0xecb7,0x8fdef8,0,0, /* 0,'象','豢','豣','豤',0,'豦',0, '豨','豩','豪','豫','豬','豭',0,0, */
	/* 8c70 */ 0,0,0,0x8fdef9,0,0x8fdefa,0x8fdefb,0, 0xecb8,0xc9bf,0xecb9,0x8fdefc,0xecc1,0,0x8fdefd,0, /* 0,0,0,'豳',0,'豵','豶',0, '豸','豹','豺','豻','豼',0,'豾',0, */
	/* 8c80 */ 0,0,0xecba,0,0,0xecbc,0x8fdefe,0x8fdfa1, 0,0xecbb,0xecbd,0x8fdfa2,0xcbc6,0xecbe,0xecbf,0, /* 0,0,'貂',0,0,'貅','貆','貇', 0,'貉','貊','貋','貌','貍','貎',0, */
	/* 8c90 */ 0x8fdfa3,0,0x8fdfa4,0x8fdfa5,0xecc0,0,0,0, 0xecc2,0x8fdfa6,0,0x8fdfa7,0x8fdfa8,0xb3ad,0xc4e7,0, /* '貐',0,'貒','貓','貔',0,0,0, '貘','貙',0,'貛','貜','貝','貞',0, */
	/* 8ca0 */ 0xc9e9,0xbae2,0xb9d7,0,0x8fdfa9,0,0,0xc9cf, 0xb2df,0xc8ce,0xecc5,0xb4d3,0xc0d5,0xecc4,0xecc9,0xc3f9, /* '負','財','貢',0,'貤',0,0,'貧', '貨','販','貪','貫','責','貭','貮','貯', */
	/* 8cb0 */ 0xcce3,0,0xecc7,0xecc8,0xb5ae,0,0xecca,0xc7e3, 0xc2df,0x8fdfaa,0x8fdfab,0xc8f1,0xc5bd,0xecc6,0,0xcbc7, /* '貰',0,'貲','貳','貴',0,'貶','買', '貸','貹','貺','費','貼','貽',0,'貿', */
	/* 8cc0 */ 0xb2ec,0xeccc,0xcfa8,0xc4c2,0xcfc5,0x8fdfac,0x8fdfad,0xbbf1, 0xeccb,0x8fdfae,0xc2b1,0x8fdfaf,0,0xecdc,0xc1a8,0x8fdfb0, /* '賀','賁','賂','賃','賄','賅','賆','資', '賈','賉','賊','賋',0,'賍','賎','賏', */
	/* 8cd0 */ 0,0xc6f8,0,0xc9d0,0,0x8fdfb2,0x8fdfb1,0, 0,0x8fdfb3,0xeccf,0xbbbf,0xbbf2,0x8fdfb4,0xbede,0, /* 0,'賑',0,'賓',0,'賕','賖',0, 0,'賙','賚','賛','賜','賝','賞',0, */
	/* 8ce0 */ 0xc7e5,0x8fdfb5,0xb8ad,0xecce,0xeccd,0,0xc9ea,0, 0x8fdfb6,0,0xbcc1,0,0x8fdfb7,0xc5d2,0,0x8fdfb8, /* '賠','賡','賢','賣','賤',0,'賦',0, '賨',0,'質',0,'賬','賭',0,'賯', */
	/* 8cf0 */ 0x8fdfb9,0,0x8fdfba,0,0x8ff4e7,0x8fdfbb,0,0x8fdfbc, 0x8fdfbd,0,0xecd1,0xecd2,0xb9d8,0xecd0,0x8fdfbe,0x8fdfbf, /* '賰',0,'賲',0,'賴','賵',0,'賷', '賸',0,'賺','賻','購','賽','賾','賿', */
	/* 8d00 */ 0,0x8fdfc0,0,0x8fdfc1,0xecd3,0xecd4,0,0xecd6, 0xc2a3,0x8fdfc2,0xecd5,0xb4e6,0,0xecd8,0,0xecd7, /* 0,'贁',0,'贃','贄','贅',0,'贇', '贈','贉','贊','贋',0,'贍',0,'贏', */
	/* 8d10 */ 0xecd9,0,0x8fdfc3,0xecdb,0xecdd,0,0xecde,0x8fdfc4, 0,0,0,0x8fdfc5,0,0,0,0, /* '贐',0,'贒','贓','贔',0,'贖','贗', 0,0,0,'贛',0,0,0,0, */
	/* 8d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d60 */ 0,0,0,0,0xc0d6,0x8fdfc6,0xbccf,0xecdf, 0,0x8fdfc7,0,0xb3d2,0x8fdfc8,0xece0,0x8fdfc9,0, /* 0,0,0,0,'赤','赥','赦','赧', 0,'赩',0,'赫','赬','赭','赮',0, */
	/* 8d70 */ 0xc1f6,0xece1,0,0xece2,0xc9eb,0,0x8ff4e8,0xb5af, 0,0,0,0,0,0,0,0x8fdfca, /* '走','赱',0,'赳','赴',0,'赶','起', 0,0,0,0,0,0,0,'赿', */
	/* 8d80 */ 0,0xece3,0x8fdfcb,0,0x8fdfcc,0xc4b6,0,0, 0x8fdfcd,0,0xb1db,0,0,0x8fdfce,0,0, /* 0,'趁','趂',0,'趄','超',0,0, '趈',0,'越',0,0,'趍',0,0, */
	/* 8d90 */ 0x8fdfcf,0x8fdfd0,0,0,0,0x8fdfd1,0,0, 0,0xece4,0,0,0,0,0x8fdfd2,0x8fdfd3, /* '趐','趑',0,0,0,'趕',0,0, 0,'趙',0,0,0,0,'趞','趟', */
	/* 8da0 */ 0x8fdfd4,0,0,0xbcf1,0,0,0x8fdfd5,0, 0xbff6,0,0,0x8fdfd6,0x8fdfd7,0,0,0x8fdfd8, /* '趠',0,0,'趣',0,0,'趦',0, '趨',0,0,'趫','趬',0,0,'趯', */
	/* 8db0 */ 0,0,0x8fdfd9,0xc2ad,0,0x8fdfda,0,0x8fdfdb, 0,0x8fdfdc,0xece7,0x8fdfdd,0x8fdfef,0,0xece6,0, /* 0,0,'趲','足',0,'趵',0,'趷', 0,'趹','趺','趻','趼',0,'趾',0, */
	/* 8dc0 */ 0x8fdfde,0,0xece5,0,0,0x8fdfdf,0x8fdfe0,0x8fdfe1, 0x8fdfe2,0,0x8fdfe3,0xeced,0xeceb,0,0x8fdfe4,0xece8, /* '跀',0,'跂',0,0,'跅','跆','跇', '跈',0,'跊','跋','跌',0,'跎','跏', */
	/* 8dd0 */ 0,0x8fdfe5,0,0,0x8fdfe6,0x8fdfe7,0xecea,0x8fdfe8, 0,0x8fdfe9,0xece9,0xecec,0,0xb5f7,0,0xecf0, /* 0,'跑',0,0,'跔','跕','跖','跗', 0,'跙','跚','跛',0,'距',0,'跟', */
	/* 8de0 */ 0,0xc0d7,0,0xecf1,0x8fdfea,0x8fdfeb,0,0x8fdfec, 0xb8d9,0,0xecee,0xecef,0x8fdfed,0,0,0xcfa9, /* 0,'跡',0,'跣','跤','跥',0,'跧', '跨',0,'跪','跫','跬',0,0,'路', */
	/* 8df0 */ 0x8fdfee,0x8fdff0,0x8fdff1,0xc4b7,0x8fdff2,0xc1a9,0,0, 0,0,0,0,0xecf2,0x8fdff3,0,0xecf5, /* '跰','跱','跲','跳','跴','践',0,0, 0,0,0,0,'跼','跽',0,'跿', */
	/* 8e00 */ 0,0x8fdff4,0,0,0x8fdff5,0x8fdff6,0x8fdff7,0, 0xecf3,0xecf4,0xcdd9,0x8fdff8,0,0,0,0xc6a7, /* 0,'踁',0,0,'踄','踅','踆',0, '踈','踉','踊','踋',0,0,0,'踏', */
	/* 8e10 */ 0xecf8,0x8fdff9,0,0,0x8fdffa,0,0x8fdffb,0, 0,0,0,0,0,0xecf6,0xecf7,0xecf9, /* '踐','踑',0,0,'踔',0,'踖',0, 0,0,0,0,0,'踝','踞','踟', */
	/* 8e20 */ 0x8fdffc,0x8fdffd,0x8fdffe,0x8fe0a1,0,0,0x8fe0a2,0x8fe0a3, 0,0,0xeda9,0,0,0,0,0, /* '踠','踡','踢','踣',0,0,'踦','踧', 0,0,'踪',0,0,0,0,0, */
	/* 8e30 */ 0xecfc,0x8fe0a4,0,0x8fe0a5,0xecfd,0xecfb,0x8fe0a6,0x8fe0a7, 0x8fe0a8,0x8fe0a9,0,0,0,0x8fe0aa,0,0, /* '踰','踱',0,'踳','踴','踵','踶','踷', '踸','踹',0,0,0,'踽',0,0, */
	/* 8e40 */ 0x8fe0ab,0x8fe0ac,0xecfa,0,0xc4fd,0,0,0xeda1, 0xeda5,0xeda2,0xecfe,0x8fe0ad,0xeda3,0x8fe0ae,0x8fe0af,0x8fe0b0, /* '蹀','蹁','蹂',0,'蹄',0,0,'蹇', '蹈','蹉','蹊','蹋','蹌','蹍','蹎','蹏', */
	/* 8e50 */ 0xeda4,0,0,0,0x8fe0b1,0xedab,0,0, 0,0xeda6,0,0x8fe0b2,0x8fe0b3,0x8fe0b4,0x8fe0b5,0xc0d8, /* '蹐',0,0,0,'蹔','蹕',0,0, 0,'蹙',0,'蹛','蹜','蹝','蹞','蹟', */
	/* 8e60 */ 0xeda8,0x8fe0b6,0x8fe0b7,0xedaa,0xeda7,0,0,0, 0,0x8fe0b8,0,0,0x8fe0b9,0x8fe0ba,0,0x8fe0bb, /* '蹠','蹡','蹢','蹣','蹤',0,0,0, 0,'蹩',0,0,'蹬','蹭',0,'蹯', */
	/* 8e70 */ 0x8fe0bc,0x8fe0bd,0xedad,0,0xbdb3,0,0xedac,0, 0,0x8fe0be,0x8fe0bf,0x8fe0c0,0xedae,0,0,0, /* '蹰','蹱','蹲',0,'蹴',0,'蹶',0, 0,'蹹','蹺','蹻','蹼',0,0,0, */
	/* 8e80 */ 0,0xedaf,0x8fe0c1,0x8fe0c2,0xedb2,0xedb1,0,0xedb0, 0,0x8fe0c3,0xedb4,0xedb3,0,0xccf6,0,0, /* 0,'躁','躂','躃','躄','躅',0,'躇', 0,'躉','躊','躋',0,'躍',0,0, */
	/* 8e90 */ 0x8fe0c4,0xedb6,0x8fe0c5,0xedb5,0xedb7,0x8fe0c6,0,0, 0,0xedb8,0x8fe0c7,0x8fe0c8,0,0x8fe0c9,0x8fe0ca,0, /* '躐','躑','躒','躓','躔','躕',0,0, 0,'躙','躚','躛',0,'躝','躞',0, */
	/* 8ea0 */ 0,0xedba,0x8fe0cb,0,0,0,0,0x8fe0cc, 0,0x8fe0cd,0xedb9,0xbfc8,0xedbb,0x8fe0ce,0x8fe0cf,0xb6ed, /* 0,'躡','躢',0,0,0,0,'躧', 0,'躩','躪','身','躬','躭','躮','躯', */
	/* 8eb0 */ 0xedbc,0xedbe,0,0x8fe0d0,0,0x8fe0d1,0,0, 0,0,0x8fe0d2,0x8fe0d3,0,0,0xedbf,0, /* '躰','躱',0,'躳',0,'躵',0,0, 0,0,'躺','躻',0,0,'躾',0, */
	/* 8ec0 */ 0x8fe0d4,0x8fe0d5,0,0x8fe0d6,0x8fe0d7,0xedc0,0xedbd,0x8fe0d8, 0xedc1,0,0xbcd6,0xedc2,0xb5b0,0xb7b3,0,0x8fe0d9, /* '軀','軁',0,'軃','軄','軅','軆','軇', '軈',0,'車','軋','軌','軍',0,'軏', */
	/* 8ed0 */ 0,0x8fe0da,0xb8ae,0,0x8fe0db,0,0,0, 0,0,0,0xedc3,0x8fe0dc,0,0,0xc6f0, /* 0,'軑','軒',0,'軔',0,0,0, 0,0,0,'軛','軜',0,0,'軟', */
	/* 8ee0 */ 0,0,0xc5be,0xedc4,0,0,0,0, 0x8fe0dd,0,0,0xedc7,0,0x8fe0e4,0x8fe0de,0, /* 0,0,'転','軣',0,0,0,0, '軨',0,0,'軫',0,'軭','軮',0, */
	/* 8ef0 */ 0x8fe0df,0x8fe0e0,0,0,0,0,0,0x8fe0e1, 0xbcb4,0x8fe0e2,0x8fe0e3,0xedc6,0xedc5,0xb7da,0xedc8,0, /* '軰','軱',0,0,0,0,0,'軷', '軸','軹','軺','軻','軼','軽','軾',0, */
	/* 8f00 */ 0x8fe0e5,0,0x8fe0e6,0xb3d3,0,0xedca,0,0x8fe0e7, 0x8fe0e8,0xbadc,0xedc9,0,0xedd2,0,0,0x8fe0e9, /* '輀',0,'輂','較',0,'輅',0,'輇', '輈','載','輊',0,'輌',0,0,'輏', */
	/* 8f10 */ 0x8fe0ea,0,0xedcc,0xedce,0xcae5,0xedcb,0x8fe0eb,0x8fe0ec, 0x8fe0ed,0xedcd,0,0xedd1,0xedcf,0xb5b1,0x8fe0ee,0xedd0, /* '輐',0,'輒','輓','輔','輕','輖','輗', '輘','輙',0,'輛','輜','輝','輞','輟', */
	/* 8f20 */ 0x8fe0ef,0x8fe0f0,0,0x8fe0f1,0,0x8fe0f2,0xedd3,0x8fe0f3, 0x8fe0f4,0xc7da,0xced8,0,0x8fe0f5,0x8fe0f6,0x8fe0f7,0xbdb4, /* '輠','輡',0,'輣',0,'輥','輦','輧', '輨','輩','輪',0,'輬','輭','輮','輯', */
	/* 8f30 */ 0,0,0,0xedd4,0x8fe0f8,0x8fe0f9,0x8fe0fa,0x8fe0fb, 0xcda2,0xedd6,0x8fe0fc,0xedd5,0,0,0xedd9,0xcdc1, /* 0,0,0,'輳','輴','輵','輶','輷', '輸','輹','輺','輻',0,0,'輾','輿', */
	/* 8f40 */ 0x8fe0fd,0x8fe0fe,0xedd8,0x8fe1a1,0xb3ed,0xedd7,0xeddc,0x8fe1a2, 0,0xeddb,0,0,0xedda,0xc5b2,0xeddd,0x8fe1a3, /* '轀','轁','轂','轃','轄','轅','轆','轇', 0,'轉',0,0,'轌','轍','轎','轏', */
	/* 8f50 */ 0,0x8fe1a4,0x8fe1a5,0x8fe1a6,0x8fe1a7,0x8fe1a8,0,0xedde, 0x8fe1a9,0,0,0,0xeddf,0x8fe1aa,0x8fe1ab,0xb9ec, /* 0,'轑','轒','轓','轔','轕',0,'轗', '轘',0,0,0,'轜','轝','轞','轟', */
	/* 8f60 */ 0,0xb7a5,0xede0,0xede1,0xede2,0x8fe1ac,0,0, 0,0,0,0,0,0,0,0, /* 0,'轡','轢','轣','轤','轥',0,0, 0,0,0,0,0,0,0,0, */
	/* 8f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0xbfc9,0xede3,0x8fe1ad,0xbcad,0xede4, /* 0,0,0,0,0,0,0,0, 0,0,0,'辛','辜','辝','辞','辟', */
	/* 8fa0 */ 0x8fe1ae,0x8fe1af,0,0xede5,0x8fe1b0,0x8fe1b1,0x8fe1b2,0xd2a1, 0xd1fe,0,0,0,0,0xede6,0xe5f0,0xede7, /* '辠','辡',0,'辣','辤','辥','辦','辧', '辨',0,0,0,0,'辭','辮','辯', */
	/* 8fb0 */ 0xc3a4,0xbfab,0xc7c0,0,0,0x8fe1b3,0x8fe1b4,0xede8, 0x8fe1b5,0,0xcad5,0xc4d4,0xb9fe,0,0x8fe1b6,0xc3a9, /* '辰','辱','農',0,0,'辵','辶','辷', '辸',0,'辺','辻','込',0,'达','辿', */
	/* 8fc0 */ 0x8fe1b7,0x8fe1b8,0xb1aa,0,0xcbf8,0xbfd7,0x8fe1b9,0, 0,0,0x8fe1ba,0x8fe1bb,0,0x8fe1bc,0xb7de,0, /* '迀','迁','迂',0,'迄','迅','迆',0, 0,0,'迊','迋',0,'迍','迎',0, */
	/* 8fd0 */ 0x8fe1bd,0xb6e1,0x8fe1be,0x8fe1bf,0xcad6,0x8fe1c0,0,0, 0,0,0xede9,0,0,0,0,0, /* '运','近','迒','迓','返','迕',0,0, 0,0,'迚',0,0,0,0,0, */
	/* 8fe0 */ 0x8fe1c1,0,0xedeb,0x8fe1c2,0x8fe1c3,0xedea,0xb2e0,0, 0x8fe1c4,0xc6f6,0xedec,0xc7f7,0,0xc5b3,0x8fe1c5,0xeded, /* '迠',0,'迢','迣','迤','迥','迦',0, '迨','迩','迪','迫',0,'迭','迮','迯', */
	/* 8ff0 */ 0xbdd2,0x8fe1c6,0,0,0xedef,0x8fe1c7,0x8fe1c8,0xccc2, 0xedfe,0xedf1,0xedf2,0x8fe1c9,0,0xc4c9,0x8fe1ca,0, /* '述','迱',0,0,'迴','迵','迶','迷', '迸','迹','迺','迻',0,'追','迾',0, */
	/* 9000 */ 0xc2e0,0xc1f7,0x8fe1cb,0xc6a8,0x8fe1cc,0xedf0,0xb5d5,0, 0x8fe1cd,0,0,0xedf9,0x8fe1ce,0xedf6,0xeea5,0xc6a9, /* '退','送','适','逃','逄','逅','逆',0, '逈',0,0,'逋','逌','逍','逎','透', */
	/* 9010 */ 0xc3e0,0xedf3,0,0xc4fe,0xc5d3,0xedf4,0xedf8,0xbfe0, 0x8fe1cf,0xc7e7,0xc4cc,0x8fe1d0,0,0xc0c2,0xedf7,0xc2ae, /* '逐','逑',0,'逓','途','逕','逖','逗', '逘','這','通','逛',0,'逝','逞','速', */
	/* 9020 */ 0xc2a4,0xedf5,0xb0a9,0xcfa2,0,0,0,0xedfa, 0x8fe1d1,0x8fe1d2,0x8fe1d4,0,0x8fe1d5,0x8fe1d6,0xc2e1,0x8fe1d3, /* '造','逡','逢','連',0,0,0,'逧', '逨','逩','逪',0,'逬','逭','逮','逯', */
	/* 9030 */ 0,0xbdb5,0xbfca,0x8fe1d7,0x8fe1d8,0xedfc,0xedfb,0x8fe1d9, 0xb0ef,0xedfd,0,0,0xc9af,0,0xeea7,0x8fe1da, /* 0,'週','進','逳','逴','逵','逶','逷', '逸','逹',0,0,'逼',0,'逾','逿', */
	/* 9040 */ 0,0xc6db,0xbfeb,0x8fe1db,0x8fe1dc,0xc3d9,0,0xb6f8, 0,0xeea6,0xcdb7,0xb1bf,0x8fe1dd,0xcad7,0xb2e1,0xeea1, /* 0,'遁','遂','遃','遄','遅',0,'遇', 0,'遉','遊','運','遌','遍','過','遏', */
	/* 9050 */ 0xeea2,0xeea3,0xeea4,0xc6bb,0xc3a3,0xb0e3,0xeea8,0, 0xeea9,0xf4a3,0,0x8fe1de,0xc2bd,0x8fe1df,0xeeaa,0, /* '遐','遑','遒','道','達','違','遖',0, '遘','遙',0,'遛','遜','遝','遞',0, */
	/* 9060 */ 0xb1f3,0xc1cc,0x8fe1e0,0xb8af,0,0xcdda,0x8fe1e1,0x8fe1e2, 0xeeab,0xc5ac,0,0,0x8fe1e3,0xc1f8,0xbcd7,0xeeac, /* '遠','遡','遢','遣',0,'遥','遦','遧', '遨','適',0,0,'遬','遭','遮','遯', */
	/* 9070 */ 0x8fe1e4,0,0xeeaf,0,0x8fe1e5,0xbde5,0xeead,0xc1ab, 0xc1aa,0x8fe1e6,0xb0e4,0,0xcecb,0xeeb1,0,0xc8f2, /* '遰',0,'遲',0,'遴','遵','遶','遷', '選','遹','遺',0,'遼','遽',0,'避', */
	/* 9080 */ 0xeeb3,0xeeb2,0xeeb0,0xe3e4,0xb4d4,0x8fe1e7,0,0xedee, 0x8fe1e8,0xeeb5,0xeeb4,0x8fe1e9,0x8fe1ea,0,0x8fe1eb,0xeeb6, /* '邀','邁','邂','邃','還','邅',0,'邇', '邈','邉','邊','邋','邌',0,'邎','邏', */
	/* 9090 */ 0x8fe1ec,0xcdb8,0,0,0,0x8fe1ed,0,0x8fe1ee, 0x8fe1ef,0x8fe1f0,0,0x8fe1f1,0,0,0,0, /* '邐','邑',0,0,0,'邕',0,'邗', '邘','邙',0,'邛',0,0,0,0, */
	/* 90a0 */ 0x8fe1f2,0x8fe1f3,0x8fe1f4,0xc6e1,0,0x8fe1f5,0xcbae,0, 0xeeb7,0,0xbcd9,0,0,0,0,0xeeb8, /* '邠','邡','邢','那',0,'邥','邦',0, '邨',0,'邪',0,0,0,0,'邯', */
	/* 90b0 */ 0x8fe1f6,0xeeb9,0x8fe1f7,0x8fe1f8,0x8fe1f9,0xeeba,0x8fe1fa,0, 0xc5a1,0,0,0,0,0x8fe1fb,0x8fe1fd,0, /* '邰','邱','邲','邳','邴','邵','邶',0, '邸',0,0,0,0,'邽','邾',0, */
	/* 90c0 */ 0,0xb0ea,0,0x8fe1fe,0x8fe2a1,0x8fe2a2,0,0x8fe2a3, 0x8fe2a4,0,0xb9d9,0,0x8fe1fc,0,0xcfba,0, /* 0,'郁',0,'郃','郄','郅',0,'郇', '郈',0,'郊',0,'郌',0,'郎',0, */
	/* 90d0 */ 0,0,0x8fe2ad,0,0,0x8fe2a5,0,0x8fe2a6, 0x8fe2a7,0x8fe2a8,0,0xeebe,0x8fe2a9,0x8fe2aa,0x8ff4ec,0x8fe2ab, /* 0,0,'郒',0,0,'郕',0,'郗', '郘','郙',0,'郛','郜','郝','郞','郟', */
	/* 90e0 */ 0,0xb7b4,0xeebb,0,0xeebc,0x8fe2ac,0,0, 0xc9f4,0,0,0x8fe2af,0,0xb3d4,0,0x8fe2b0, /* 0,'郡','郢',0,'郤','郥',0,0, '部',0,0,'郫',0,'郭',0,'郯', */
	/* 90f0 */ 0x8fe2b1,0,0,0,0x8fe2b2,0xcdb9,0x8fe2ae,0xb6bf, 0,0,0,0,0,0xc5d4,0x8fe2b3,0x8fe2b4, /* '郰',0,0,0,'郴','郵','郶','郷', 0,0,0,0,0,'都','郾','郿', */
	/* 9100 */ 0x8fe2b5,0,0xeebf,0,0x8fe2b6,0x8fe2b7,0x8fe2b8,0, 0x8fe2b9,0,0,0,0,0x8fe2ba,0,0, /* '鄀',0,'鄂',0,'鄄','鄅','鄆',0, '鄈',0,0,0,0,'鄍',0,0, */
	/* 9110 */ 0x8fe2bb,0,0xeec0,0,0x8fe2bc,0x8ff4ee,0x8fe2bd,0x8fe2be, 0x8fe2bf,0xeec1,0x8fe2c0,0,0x8fe2c1,0,0x8fe2c2,0, /* '鄐',0,'鄒',0,'鄔','鄕','鄖','鄗', '鄘','鄙','鄚',0,'鄜',0,'鄞',0, */
	/* 9120 */ 0x8fe2c3,0,0x8fe2c5,0x8fe2c6,0,0x8fe2c4,0,0x8fe2c7, 0,0x8fe2c8,0,0,0,0xc5a2,0x8fe2c9,0x8fe2ca, /* '鄠',0,'鄢','鄣',0,'鄥',0,'鄧', 0,'鄩',0,0,0,'鄭','鄮','鄯', */
	/* 9130 */ 0xeec3,0x8fe2cb,0xeec2,0,0x8fe2cc,0,0x8fe2cd,0x8fe2ce, 0,0x8fe2cf,0x8fe2d0,0,0x8fe2d1,0x8fe2d2,0,0, /* '鄰','鄱','鄲',0,'鄴',0,'鄶','鄷', 0,'鄹','鄺',0,'鄼','鄽',0,0, */
	/* 9140 */ 0,0,0,0x8fe2d3,0,0,0,0x8fe2d4, 0x8fe2d5,0xc6d3,0xeec4,0xbdb6,0xbce0,0xc7db,0xc3f1,0x8fe2d6, /* 0,0,0,'酃',0,0,0,'酇', '酈','酉','酊','酋','酌','配','酎','酏', */
	/* 9150 */ 0,0,0xbcf2,0x8fe2d7,0xbfec,0,0xeec5,0x8fe2d8, 0xeec6,0x8fe2d9,0x8fe2da,0x8fe2db,0,0,0,0, /* 0,0,'酒','酓','酔',0,'酖','酗', '酘','酙','酚','酛',0,0,0,0, */
	/* 9160 */ 0,0x8fe2dc,0xbfdd,0xeec7,0x8fe2dd,0xeec8,0,0x8fe2de, 0,0xeec9,0xcdef,0,0xbdb7,0x8fe2df,0,0, /* 0,'酡','酢','酣','酤','酥',0,'酧', 0,'酩','酪',0,'酬','酭',0,0, */
	/* 9170 */ 0,0,0xeecb,0xeeca,0x8fe2e0,0xb9da,0,0xb9f3, 0xbbc0,0x8fe2e1,0x8fe2e2,0x8fe2e3,0,0,0,0, /* 0,0,'酲','酳','酴','酵',0,'酷', '酸','酹','酺','酻',0,0,0,0, */
	/* 9180 */ 0,0x8fe2e4,0xeece,0x8fe2e5,0,0x8fe2e6,0x8fe2e7,0xbde6, 0,0xeecd,0x8fe2e8,0xeecc,0,0xc2e9,0x8fe2e9,0, /* 0,'醁','醂','醃',0,'醅','醆','醇', 0,'醉','醊','醋',0,'醍','醎',0, */
	/* 9190 */ 0xb8ef,0x8fe2ea,0xc0c3,0x8fe2eb,0x8fe2ec,0x8fe2ed,0,0xc8b0, 0x8fe2ee,0,0,0,0xbdb9,0,0x8fe2ef,0, /* '醐','醑','醒','醓','醔','醕',0,'醗', '醘',0,0,0,'醜',0,'醞',0, */
	/* 91a0 */ 0,0x8fe2f0,0xeecf,0,0xbedf,0,0x8fe2f1,0, 0x8fe2f2,0,0xeed2,0xeed0,0x8fe2f3,0x8fe2f4,0x8fe2f5,0xeed1, /* 0,'醡','醢',0,'醤',0,'醦',0, '醨',0,'醪','醫','醬','醭','醮','醯', */
	/* 91b0 */ 0x8fe2f6,0x8fe2f7,0x8fe2f8,0x8fe2f9,0xeed4,0xeed3,0x8fe2fa,0, 0xbefa,0,0xeed5,0x8fe2fb,0x8fe2fc,0x8fe2fd,0,0x8fe2fe, /* '醰','醱','醲','醳','醴','醵','醶',0, '醸',0,'醺','醻','醼','醽',0,'醿', */
	/* 91c0 */ 0xeed6,0xeed7,0x8fe3a1,0x8fe3a2,0,0x8fe3a3,0xc8d0,0xbad3, 0xbce1,0xeed8,0,0xeed9,0xcea4,0xbdc5,0xccee,0xcecc, /* '釀','釁','釂','釃',0,'釅','釆','采', '釈','釉',0,'釋','里','重','野','量', */
	/* 91d0 */ 0xeeda,0xb6e2,0,0x8fe3a4,0x8fe3a5,0,0xeedb,0x8fe3a6, 0xc5a3,0x8fe3a7,0x8fe3a8,0xeede,0xb3f8,0xbfcb,0x8fe3a9,0xeedc, /* '釐','金',0,'釓','釔',0,'釖','釗', '釘','釙','釚','釛','釜','針','釞','釟', */
	/* 91e0 */ 0,0xeedd,0,0xc4e0,0x8fe3aa,0x8fe3ab,0xcbd5,0xb6fc, 0,0x8fe3ac,0x8fe3ad,0,0x8fe3ae,0x8fe3af,0x8fe3b0,0x8fe3b1, /* 0,'釡',0,'釣','釤','釥','釦','釧', 0,'釩','釪',0,'釬','釭','釮','釯', */
	/* 91f0 */ 0x8fe3b2,0x8fe3b3,0,0,0,0xeee0,0xeee1,0x8fe3b4, 0,0x8fe3b5,0,0x8fe3b6,0xeedf,0x8fe3b7,0,0xeee3, /* '釰','釱',0,0,0,'釵','釶','釷', 0,'釹',0,'釻','釼','釽',0,'釿', */
	/* 9200 */ 0x8fe3b8,0x8fe3b9,0,0,0x8fe3ba,0x8fe3bb,0x8fe3bc,0x8fe3bd, 0,0x8fe3be,0x8fe3bf,0,0x8fe3c0,0xc6df,0xb3c3,0, /* '鈀','鈁',0,0,'鈄','鈅','鈆','鈇', 0,'鈉','鈊',0,'鈌','鈍','鈎',0, */
	/* 9210 */ 0x8fe3c1,0xeee7,0x8fe3c2,0x8fe3c3,0xeee4,0xeee6,0x8fe3c4,0, 0x8fe3c5,0,0,0,0x8fe3c6,0x8fe3c7,0xeee2,0, /* '鈐','鈑','鈒','鈓','鈔','鈕','鈖',0, '鈘',0,0,0,'鈜','鈝','鈞',0, */
	/* 9220 */ 0,0,0,0x8fe3c8,0x8fe3c9,0x8fe3ca,0x8fe3cb,0, 0x8fe3cc,0xefcf,0,0,0xeee5,0,0x8fe3cd,0x8fe3ce, /* 0,0,0,'鈣','鈤','鈥','鈦',0, '鈨','鈩',0,0,'鈬',0,'鈮','鈯', */
	/* 9230 */ 0x8fe3cf,0,0,0x8fe3d0,0xceeb,0x8fe3d1,0x8fe3d2,0xb8da, 0x8fe3d3,0x8fe3d4,0x8fe3d5,0,0x8fe3d6,0,0x8fe3d7,0xeeef, /* '鈰',0,0,'鈳','鈴','鈵','鈶','鈷', '鈸','鈹','鈺',0,'鈼',0,'鈾','鈿', */
	/* 9240 */ 0x8fe3d8,0,0x8fe3d9,0x8fe3da,0xc5b4,0xeeea,0x8fe3db,0x8fe3dc, 0xeeed,0xeeeb,0x8fe3dd,0xeef0,0,0x8fe3de,0x8fe3df,0x8fe3e0, /* '鉀',0,'鉂','鉃','鉄','鉅','鉆','鉇', '鉈','鉉','鉊','鉋',0,'鉍','鉎','鉏', */
	/* 9250 */ 0xeef1,0x8fe3e1,0,0,0,0,0,0xeee9, 0x8fe3e2,0x8fe3e3,0xeef6,0xb1f4,0x8fe3e4,0x8fe3e5,0xeee8,0, /* '鉐','鉑',0,0,0,0,0,'鉗', '鉘','鉙','鉚','鉛','鉜','鉝','鉞',0, */
	/* 9260 */ 0x8fe3e6,0x8fe3e7,0xc8ad,0,0xeeec,0x8fe3e8,0xbee0,0x8fe3e9, 0x8fe3ea,0x8fe3eb,0,0,0,0,0x8fe3ec,0x8fe3ed, /* '鉠','鉡','鉢',0,'鉤','鉥','鉦','鉧', '鉨','鉩',0,0,0,0,'鉮','鉯', */
	/* 9270 */ 0x8fe3ee,0xb9db,0,0,0,0x8fe3ef,0x8fe3f0,0x8fe3f1, 0x8fe3f2,0x8fe3f3,0,0x8fe3f4,0x8fe3f5,0x8fe3f6,0xcbc8,0x8fe3f7, /* '鉰','鉱',0,0,0,'鉵','鉶','鉷', '鉸','鉹',0,'鉻','鉼','鉽','鉾','鉿', */
	/* 9280 */ 0xb6e4,0,0,0xbdc6,0,0xc6bc,0,0, 0x8fe3f8,0x8fe3f9,0x8fe3fa,0,0,0x8fe3fb,0x8fe3fc,0, /* '銀',0,0,'銃',0,'銅',0,0, '銈','銉','銊',0,0,'銍','銎',0, */
	/* 9290 */ 0,0xc1ad,0x8fe3fd,0xeef4,0,0xeeee,0xeef3,0x8fe3fe, 0xccc3,0x8fe4a1,0xc4b8,0xeef5,0xeef2,0,0,0x8fe4a2, /* 0,'銑','銒','銓',0,'銕','銖','銗', '銘','銙','銚','銛','銜',0,0,'銟', */
	/* 92a0 */ 0x8fe4a3,0,0,0,0x8fe4a4,0x8fe4a5,0,0x8fe4a6, 0x8fe4a7,0,0,0x8fe4a8,0,0xc1ac,0,0x8fe4a9, /* '銠',0,0,0,'銤','銥',0,'銧', '銨',0,0,'銫',0,'銭',0,'銯', */
	/* 92b0 */ 0,0,0x8fe4aa,0,0,0,0x8fe4ab,0xeef9, 0x8fe4ac,0xeef8,0x8fe4ad,0x8fe4ae,0x8fe4af,0x8fe4b0,0,0x8fe4b1, /* 0,0,'銲',0,0,0,'銶','銷', '銸','銹','銺','銻','銼','銽',0,'銿', */
	/* 92c0 */ 0x8fe4b2,0x8fe4b3,0x8fe4b4,0x8fe4b5,0,0x8fe4b6,0x8fe4b7,0x8fe4b8, 0x8fe4b9,0,0,0x8fe4ba,0x8fe4bb,0x8fe4bc,0x8fe4bd,0xeef7, /* '鋀','鋁','鋂','鋃',0,'鋅','鋆','鋇', '鋈',0,0,'鋋','鋌','鋍','鋎','鋏', */
	/* 92d0 */ 0x8fe4be,0,0xcbaf,0x8fe4bf,0,0x8fe4c0,0,0x8fe4c1, 0x8fe4c2,0x8fe4c3,0,0,0x8fe4c4,0x8fe4c5,0,0x8fe4c6, /* '鋐',0,'鋒','鋓',0,'鋕',0,'鋗', '鋘','鋙',0,0,'鋜','鋝',0,'鋟', */
	/* 92e0 */ 0x8fe4c7,0x8fe4c8,0,0x8fe4c9,0xbdfb,0x8fe4ca,0,0x8fe4cb, 0x8fe4cc,0xeefa,0xcadf,0,0x8fe4cd,0xb1d4,0x8fe4ce,0, /* '鋠','鋡',0,'鋣','鋤','鋥',0,'鋧', '鋨','鋩','鋪',0,'鋬','鋭','鋮',0, */
	/* 92f0 */ 0x8fe4cf,0,0xc9c6,0xc3f2,0,0,0,0, 0xb5f8,0x8fe4d0,0xeefc,0x8fe4d1,0xb9dd,0,0,0x8fe4d2, /* '鋰',0,'鋲','鋳',0,0,0,0, '鋸','鋹','鋺','鋻','鋼',0,0,'鋿', */
	/* 9300 */ 0x8fe4d3,0,0x8fe4d4,0,0,0,0xbbac,0, 0x8fe4d5,0,0,0,0,0x8fe4d6,0,0xeefb, /* '錀',0,'錂',0,0,0,'錆',0, '錈',0,0,0,0,'錍',0,'錏', */
	/* 9310 */ 0xbfed,0x8fe4d7,0,0,0x8fe4d8,0x8fe4d9,0,0, 0xbfee,0xefa1,0xefa3,0,0x8fe4da,0x8fe4db,0x8fe4dc,0x8fe4dd, /* '錐','錑',0,0,'錔','錕',0,0, '錘','錙','錚',0,'錜','錝','錞','錟', */
	/* 9320 */ 0xbefb,0x8fe4de,0xefa2,0xefa4,0x8fe4df,0x8fe4e0,0xb6d3,0x8fe4e1, 0xc9c5,0x8fe4e2,0x8fe4e3,0xbce2,0xcfa3,0,0xeefe,0xbaf8, /* '錠','錡','錢','錣','錤','錥','錦','錧', '錨','錩','錪','錫','錬',0,'錮','錯', */
	/* 9330 */ 0,0,0xcfbf,0x8fe4e4,0x8fe4e5,0xefa6,0x8fe4e6,0x8fe4e7, 0,0,0xefa5,0xefa7,0,0,0,0, /* 0,0,'録','錳','錴','錵','錶','錷', 0,0,'錺','錻',0,0,0,0, */
	/* 9340 */ 0,0,0,0,0xeefd,0,0,0x8fe4e8, 0x8fe4e9,0x8fe4ea,0,0xc6e9,0,0xc5d5,0,0, /* 0,0,0,0,'鍄',0,0,'鍇', '鍈','鍉',0,'鍋',0,'鍍',0,0, */
	/* 9350 */ 0x8fe4eb,0x8fe4ec,0x8fe4ed,0,0xc4d7,0x8fe4ee,0xefac,0x8fe4ef, 0x8fe4f0,0,0x8fe4f1,0xc3c3,0xefa8,0,0x8fe4f2,0, /* '鍐','鍑','鍒',0,'鍔','鍕','鍖','鍗', '鍘',0,'鍚','鍛','鍜',0,'鍞',0, */
	/* 9360 */ 0xefa9,0,0,0,0x8fe4f3,0x8fe4f4,0,0x8fe4f5, 0,0x8fe4f6,0x8fe4f7,0,0xb7ad,0x8fe4f8,0xefab,0x8fe4f9, /* '鍠',0,0,0,'鍤','鍥',0,'鍧', 0,'鍩','鍪',0,'鍬','鍭','鍮','鍯', */
	/* 9370 */ 0x8fe4fa,0x8fe4fb,0,0x8fe4fc,0x8fe4fd,0xb8b0,0x8fe4fe,0, 0,0,0x8fe5a1,0,0xefaa,0x8fe5a2,0xbee1,0x8fe5a3, /* '鍰','鍱',0,'鍳','鍴','鍵','鍶',0, 0,0,'鍺',0,'鍼','鍽','鍾','鍿', */
	/* 9380 */ 0x8fe5a4,0x8fe5a5,0x8fe5a6,0,0,0,0,0, 0x8fe5a7,0,0x8fe5a8,0x8fe5a9,0xb3f9,0x8fe5aa,0,0x8fe5ab, /* '鎀','鎁','鎂',0,0,0,0,0, '鎈',0,'鎊','鎋','鎌','鎍',0,'鎏', */
	/* 9390 */ 0,0,0x8fe5ac,0,0xefb0,0x8fe5ad,0xbabf,0xc1f9, 0x8fe5ae,0,0xc4ca,0x8fe5af,0,0,0x8fe5b0,0, /* 0,0,'鎒',0,'鎔','鎕','鎖','鎗', '鎘',0,'鎚','鎛',0,0,'鎞',0, */
	/* 93a0 */ 0,0x8fe5b1,0,0x8fe5b2,0x8fe5b3,0,0x8fe5b4,0xb3bb, 0x8fe5b5,0x8fe5bb,0,0x8fe5b6,0xefae,0xefaf,0xc4c3,0, /* 0,'鎡',0,'鎣','鎤',0,'鎦','鎧', '鎨','鎩',0,'鎫','鎬','鎭','鎮',0, */
	/* 93b0 */ 0xefad,0,0,0,0x8fe5b7,0x8fe5b8,0x8fe5b9,0, 0,0xefb1,0x8fe5ba,0,0,0,0,0, /* '鎰',0,0,0,'鎴','鎵','鎶',0, 0,'鎹','鎺',0,0,0,0,0, */
	/* 93c0 */ 0,0x8fe5bc,0,0xefb7,0x8fe5bd,0x8fe5be,0x8fe5bf,0x8fe5c0, 0xefba,0x8fe5c1,0x8fe5c2,0x8fe5c3,0x8fe5c4,0x8fe5c5,0,0, /* 0,'鏁',0,'鏃','鏄','鏅','鏆','鏇', '鏈','鏉','鏊','鏋','鏌','鏍',0,0, */
	/* 93d0 */ 0xefb9,0xc5ad,0,0x8fe5c6,0,0,0xefb2,0xefb3, 0xefb6,0x8fe5c7,0,0,0x8fe5c8,0xefb8,0x8fe5c9,0x8fe5ca, /* '鏐','鏑',0,'鏓',0,0,'鏖','鏗', '鏘','鏙',0,0,'鏜','鏝','鏞','鏟', */
	/* 93e0 */ 0,0xb6c0,0x8fe5cb,0,0xefbb,0xefb5,0x8fe5cc,0x8fe5cd, 0xefb4,0,0,0,0,0,0,0, /* 0,'鏡','鏢',0,'鏤','鏥','鏦','鏧', '鏨',0,0,0,0,0,0,0, */
	/* 93f0 */ 0,0,0,0,0,0,0,0x8fe5cf, 0x8fe5d0,0x8fe5ce,0x8fe5d1,0x8fe5d2,0,0x8fe5d3,0,0, /* 0,0,0,0,0,0,0,'鏷', '鏸','鏹','鏺','鏻',0,'鏽',0,0, */
	/* 9400 */ 0,0x8fe5d4,0x8fe5d5,0xefbf,0x8fe5d6,0,0,0xefc0, 0x8fe5d7,0x8fe5d8,0,0,0,0x8fe5d9,0x8fe5da,0x8fe5db, /* 0,'鐁','鐂','鐃','鐄',0,0,'鐇', '鐈','鐉',0,0,0,'鐍','鐎','鐏', */
	/* 9410 */ 0xefc1,0,0,0xefbe,0xefbd,0x8fe5dc,0x8fe5dd,0x8fe5de, 0xbee2,0xc6aa,0xefbc,0,0,0,0,0x8fe5df, /* '鐐',0,0,'鐓','鐔','鐕','鐖','鐗', '鐘','鐙','鐚',0,0,0,0,'鐟', */
	/* 9420 */ 0,0xefc5,0,0,0,0,0,0, 0,0,0,0xefc3,0,0,0x8fe5e0,0x8fe5e1, /* 0,'鐡',0,0,0,0,0,0, 0,0,0,'鐫',0,0,'鐮','鐯', */
	/* 9430 */ 0,0x8fe5e2,0x8fe5e3,0x8fe5e4,0x8fe5e5,0xefc4,0xefc2,0, 0xc2f8,0,0xefc6,0x8fe5e6,0,0x8fe5e8,0,0x8fe5e7, /* 0,'鐱','鐲','鐳','鐴','鐵','鐶',0, '鐸',0,'鐺','鐻',0,'鐽',0,'鐿', */
	/* 9440 */ 0,0xefc7,0,0x8fe5e9,0xefc9,0x8fe5ea,0,0, 0x8fe5eb,0,0x8fe5ec,0,0x8fe5ed,0,0,0, /* 0,'鑁',0,'鑃','鑄','鑅',0,0, '鑈',0,'鑊',0,'鑌',0,0,0, */
	/* 9450 */ 0,0xb4d5,0xefc8,0xccfa,0,0x8fe5ee,0,0, 0,0x8fe5ef,0xefd4,0xefca,0x8fe5f0,0,0xefcd,0x8fe5f1, /* 0,'鑑','鑒','鑓',0,'鑕',0,0, 0,'鑙','鑚','鑛','鑜',0,'鑞','鑟', */
	/* 9460 */ 0xefcb,0x8fe5f2,0xefcc,0x8fe5f3,0,0,0,0, 0x8fe5f4,0,0xefce,0x8fe5f5,0,0x8fe5f6,0x8fe5f7,0x8fe5f8, /* '鑠','鑡','鑢','鑣',0,0,0,0, '鑨',0,'鑪','鑫',0,'鑭','鑮','鑯', */
	/* 9470 */ 0xefd0,0x8fe5f9,0x8fe5fa,0,0,0xefd1,0,0xefd2, 0,0,0,0,0xefd5,0xefd3,0xefd6,0xefd8, /* '鑰','鑱','鑲',0,0,'鑵',0,'鑷', 0,0,0,0,'鑼','鑽','鑾','鑿', */
	/* 9480 */ 0,0xefd7,0,0x8fe5fc,0x8fe5fb,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'钁',0,'钃','钄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9570 */ 0,0,0,0,0,0,0,0xc4b9, 0x8fe5fd,0x8fe5fe,0,0,0,0,0x8fe6a1,0, /* 0,0,0,0,0,0,0,'長', '镸','镹',0,0,0,0,'镾',0, */
	/* 9580 */ 0xcce7,0,0xefd9,0xc1ae,0x8fe6a2,0,0,0xefda, 0x8fe6a3,0xcac4,0xefdb,0xb3ab,0x8fe6a4,0x8fe6a5,0x8fe6a6,0xb1bc, /* '門',0,'閂','閃','閄',0,0,'閇', '閈','閉','閊','開','閌','閍','閎','閏', */
	/* 9590 */ 0,0xb4d7,0x8ff4f1,0xb4d6,0xefdc,0,0xefdd,0, 0xefde,0xefdf,0,0,0,0x8fe6a7,0x8fe6a8,0x8fe6a9, /* 0,'閑','閒','間','閔',0,'閖',0, '閘','閙',0,0,0,'閝','閞','閟', */
	/* 95a0 */ 0xefe0,0x8fe6aa,0xb4d8,0xb3d5,0xb9de,0xc8b6,0x8fe6ab,0xefe2, 0xefe1,0x8fe6ac,0,0x8fe6ad,0x8fe6ae,0xefe3,0,0, /* '閠','閡','関','閣','閤','閥','閦','閧', '閨','閩',0,'閫','閬','閭',0,0, */
	/* 95b0 */ 0,0,0xb1dc,0,0x8fe6af,0,0x8fe6b0,0, 0,0xefe6,0x8fe6b1,0xefe5,0xefe4,0x8fe6b2,0xefe7,0x8fe6b3, /* 0,0,'閲',0,'閴',0,'閶',0, 0,'閹','閺','閻','閼','閽','閾','閿', */
	/* 95c0 */ 0,0,0,0xefea,0,0,0x8fe6b4,0xb0c7, 0x8fe6b5,0x8fe6b6,0xefe8,0x8fe6b7,0xefec,0xefeb,0,0, /* 0,0,0,'闃',0,0,'闆','闇', '闈','闉','闊','闋','闌','闍',0,0, */
	/* 95d0 */ 0x8fe6b8,0x8fe6b9,0x8fe6ba,0x8fe6bb,0xefee,0xefed,0xefef,0, 0xc6ae,0x8fe6bc,0x8fe6bd,0,0xeff0,0x8fe6be,0x8fe6bf,0x8fe6c0, /* '闐','闑','闒','闓','闔','闕','闖',0, '闘','闙','闚',0,'關','闝','闞','闟', */
	/* 95e0 */ 0x8fe6c1,0xeff1,0xeff3,0,0x8fe6c2,0xeff2,0x8fe6c3,0, 0,0,0,0,0,0,0,0, /* '闠','闡','闢',0,'闤','闥','闦',0, 0,0,0,0,0,0,0,0, */
	/* 95f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xc9ec,0x8fe6c4,0x8fe6c5,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'阜','阝','阞',0, */
	/* 9620 */ 0,0xeff4,0x8fe6c6,0,0x8fe6c7,0x8fe6c8,0x8fe6c9,0, 0xeff5,0,0xbae5,0,0x8fe6ca,0,0xeff6,0xeff7, /* 0,'阡','阢',0,'阤','阥','阦',0, '阨',0,'阪',0,'阬',0,'阮','阯', */
	/* 9630 */ 0,0x8fe6cb,0xcbc9,0x8fe6cc,0,0,0,0x8fe6cd, 0x8fe6ce,0x8fe6cf,0x8fe6d0,0xc1cb,0x8fe6d1,0x8fe6d2,0,0xb0a4, /* 0,'阱','防','阳',0,0,0,'阷', '阸','阹','阺','阻','阼','阽',0,'阿', */
	/* 9640 */ 0xc2cb,0x8fe6d3,0xeff8,0,0xc9ed,0,0,0, 0,0,0,0xeffb,0xeff9,0xb9df,0,0xeffa, /* '陀','陁','陂',0,'附',0,0,0, 0,0,0,'陋','陌','降',0,'陏', */
	/* 9650 */ 0xb8c2,0,0x8fe6d4,0,0x8fe6d5,0,0x8fe6d6,0x8fe6d7, 0x8fe6d8,0,0,0xcac5,0xeffd,0xf0a1,0xeffe,0xf0a2, /* '限',0,'陒',0,'陔',0,'陖','陗', '陘',0,0,'陛','陜','陝','陞','陟', */
	/* 9660 */ 0,0x8fe6d9,0xb1a1,0xbfd8,0xbdfc,0xb4d9,0xf0a3,0, 0,0,0xc7e6,0,0xf0a5,0,0x8fe6da,0, /* 0,'陡','院','陣','除','陥','陦',0, 0,0,'陪',0,'陬',0,'陮',0, */
	/* 9670 */ 0xb1a2,0,0xf0a4,0xc4c4,0x8fe6db,0xcecd,0xc6ab,0xeffc, 0xcea6,0,0xb8b1,0x8fe6dc,0x8fe6dd,0xcddb,0x8fe6de,0x8fe6df, /* '陰',0,'陲','陳','陴','陵','陶','陷', '陸',0,'険','陻','陼','陽','陾','陿', */
	/* 9680 */ 0,0x8fe6e0,0x8fe6e1,0x8fe6e2,0x8fe6e3,0xb6f9,0xceb4,0, 0xb7a8,0x8fe6e4,0xc2e2,0xe7a1,0,0xf0a6,0xb3ac,0xbfef, /* 0,'隁','隂','隃','隄','隅','隆',0, '隈','隉','隊','隋',0,'隍','階','随', */
	/* 9690 */ 0,0x8fe6e5,0,0,0xb3d6,0xf0a8,0x8fe6e6,0xf0a9, 0xf0a7,0xb7e4,0x8fe6e7,0xbadd,0xbee3,0x8fe6e8,0,0x8fe6e9, /* 0,'隑',0,0,'隔','隕','隖','隗', '隘','隙','隚','際','障','隝',0,'隟', */
	/* 96a0 */ 0xb1a3,0,0,0xced9,0x8fe6ea,0x8fe6eb,0x8fe6ec,0xf0ab, 0xeeae,0x8fe6ed,0xf0aa,0,0,0,0x8fe6ee,0x8fe6ef, /* '隠',0,0,'隣','隤','隥','隦','隧', '隨','隩','險',0,0,0,'隮','隯', */
	/* 96b0 */ 0xf0ae,0xf0ac,0xf0ad,0x8fe6f0,0xf0af,0,0xf0b0,0xceec, 0xf0b1,0xf0b2,0x8fe6f1,0xc0c9,0xc8bb,0,0,0, /* '隰','隱','隲','隳','隴',0,'隶','隷', '隸','隹','隺','隻','隼',0,0,0, */
	/* 96c0 */ 0xbffd,0xb4e7,0,0,0xcdba,0xb2ed,0xbdb8,0xb8db, 0,0xf0b5,0x8fe6f2,0xf0b4,0xbbf3,0xf0b6,0xf0b3,0, /* '雀','雁',0,0,'雄','雅','集','雇', 0,'雉','雊','雋','雌','雍','雎',0, */
	/* 96d0 */ 0,0xbba8,0x8fe6f3,0,0,0xf0ba,0xeaad,0, 0x8fe6f5,0xd2d6,0x8fe6f6,0xbff7,0xf0b8,0x8fe6f7,0x8fe6f8,0x8fe6f9, /* 0,'雑','雒',0,0,'雕','雖',0, '雘','雙','雚','雛','雜','雝','雞','雟', */
	/* 96e0 */ 0,0,0xcea5,0xc6f1,0,0,0,0, 0xb1ab,0x8fe6fa,0xc0e3,0xbcb6,0,0,0,0x8fe6fb, /* 0,0,'離','難',0,0,0,0, '雨','雩','雪','雫',0,0,0,'雯', */
	/* 96f0 */ 0xcab7,0x8fe6fc,0xb1c0,0,0,0,0xceed,0xcdeb, 0,0xf0bb,0x8fe6fd,0xc5c5,0,0,0,0, /* '雰','雱','雲',0,0,0,'零','雷', 0,'雹','雺','電',0,0,0,0, */
	/* 9700 */ 0xbcfb,0,0x8fe6fe,0x8fe7a1,0xf0bc,0x8fe7a2,0xf0bd,0xbfcc, 0xf0be,0x8fe7a3,0xceee,0,0,0xf0b9,0xf0c0,0xf0c2, /* '需',0,'霂','霃','霄','霅','霆','震', '霈','霉','霊',0,0,'霍','霎','霏', */
	/* 9710 */ 0,0xf0c1,0,0xf0bf,0,0,0xf0c3,0, 0,0xf0c4,0x8fe7a4,0x8fe7a5,0xc1fa,0x8fe7a6,0xb2e2,0, /* 0,'霑',0,'霓',0,0,'霖',0, 0,'霙','霚','霛','霜','霝','霞',0, */
	/* 9720 */ 0,0x8fe7a7,0x8fe7a8,0x8fe7a9,0xf0c5,0,0,0xccb8, 0x8fe7aa,0,0xf0c6,0,0,0,0,0, /* 0,'霡','霢','霣','霤',0,0,'霧', '霨',0,'霪',0,0,0,0,0, */
	/* 9730 */ 0xf0c7,0x8fe7ab,0xcfaa,0x8fe7ac,0,0,0,0, 0xdbb1,0xf0c8,0,0x8ff4f4,0,0xf0c9,0xf0ca,0, /* '霰','霱','露','霳',0,0,0,0, '霸','霹',0,'霻',0,'霽','霾',0, */
	/* 9740 */ 0,0x8fe7ad,0xf0ce,0x8fe7ae,0xf0cb,0,0xf0cc,0, 0xf0cd,0xf0cf,0x8fe7af,0,0,0x8ff4f5,0x8fe7b0,0x8fe7b1, /* 0,'靁','靂','靃','靄',0,'靆',0, '靈','靉','靊',0,0,'靍','靎','靏', */
	/* 9750 */ 0,0x8ff4f6,0xc0c4,0,0,0x8fe7b2,0xccf7,0x8fe7b3, 0x8fe7b4,0xc0c5,0x8fe7b5,0x8fe7b6,0xf0d0,0,0xc8f3,0, /* 0,'靑','青',0,0,'靕','靖','靗', '靘','静','靚','靛','靜',0,'非',0, */
	/* 9760 */ 0xf0d1,0xf3d3,0xcccc,0x8fe7b7,0xf0d2,0,0xf0d3,0x8fe7b8, 0xf0d4,0xb3d7,0x8fe7b9,0xf0d6,0,0xbfd9,0x8fe7ba,0, /* '靠','靡','面','靣','靤',0,'靦','靧', '靨','革','靪','靫',0,'靭','靮',0, */
	/* 9770 */ 0,0xf0d7,0,0x8fe7bb,0xb7a4,0,0x8fe7bc,0x8fe7bd, 0x8fe7be,0xf0d8,0xf0dc,0x8fe7bf,0xf0da,0x8fe7c0,0,0x8fe7c1, /* 0,'靱',0,'靳','靴',0,'靶','靷', '靸','靹','靺','靻','靼','靽',0,'靿', */
	/* 9780 */ 0x8fe7c2,0xf0db,0,0,0xb3f3,0xf0d9,0xf0dd,0, 0,0x8fe7c3,0,0xf0de,0,0xb0c8,0,0xf0df, /* '鞀','鞁',0,0,'鞄','鞅','鞆',0, 0,'鞉',0,'鞋',0,'鞍',0,'鞏', */
	/* 9790 */ 0xf0e0,0,0,0,0,0x8fe7c4,0x8fe7c5,0x8fe7c6, 0xbee4,0x8fe7c7,0x8fe7c8,0,0xf0e1,0,0x8fe7c9,0x8fe7ca, /* '鞐',0,0,0,0,'鞕','鞖','鞗', '鞘','鞙','鞚',0,'鞜',0,'鞞','鞟', */
	/* 97a0 */ 0xb5c7,0,0x8fe7cb,0xf0e4,0,0,0xf0e3,0, 0xf0e2,0,0,0xebf1,0x8fe7cc,0xcadc,0x8fe7cd,0, /* '鞠',0,'鞢','鞣',0,0,'鞦',0, '鞨',0,0,'鞫','鞬','鞭','鞮',0, */
	/* 97b0 */ 0,0x8fe7ce,0x8fe7cf,0xf0e5,0xf0e6,0x8fe7d0,0x8fe7d1,0, 0x8fe7d2,0x8fe7d3,0x8fe7d4,0,0x8fe7d5,0,0x8fe7d6,0x8fe7d7, /* 0,'鞱','鞲','鞳','鞴','鞵','鞶',0, '鞸','鞹','鞺',0,'鞼',0,'鞾','鞿', */
	/* 97c0 */ 0,0x8fe7d8,0,0xf0e7,0x8fe7d9,0x8fe7da,0xf0e8,0x8fe7db, 0xf0e9,0x8fe7dc,0x8fe7dd,0xf0ea,0x8fe7de,0x8fe7df,0x8fe7e0,0, /* 0,'韁',0,'韃','韄','韅','韆','韇', '韈','韉','韊','韋','韌','韍','韎',0, */
	/* 97d0 */ 0x8fe7e1,0x8fe7e2,0,0xb4da,0x8fe7e3,0,0,0x8fe7e4, 0x8fe7e5,0x8fe7e6,0,0x8fe7ea,0xf0eb,0x8fe7e7,0x8fe7e8,0, /* '韐','韑',0,'韓','韔',0,0,'韗', '韘','韙',0,'韛','韜','韝','韞',0, */
	/* 97e0 */ 0x8fe7e9,0x8fe7eb,0,0,0x8fe7ec,0,0,0, 0,0,0,0,0,0xf0ec,0xc7a3,0x8fe7ed, /* '韠','韡',0,0,'韤',0,0,0, 0,0,0,0,0,'韭','韮','韯', */
	/* 97f0 */ 0,0x8fe7ee,0xf0ee,0xb2bb,0x8fe7ef,0xf0f1,0xf0f0,0x8fe7f0, 0x8fe7f1,0,0x8fe7f2,0xb1a4,0,0,0,0xb6c1, /* 0,'韱','韲','音','韴','韵','韶','韷', '韸',0,'韺','韻',0,0,0,'響', */
	/* 9800 */ 0,0xcac7,0xc4ba,0xbaa2,0,0xb9e0,0xbde7,0x8fe7f3, 0xbfdc,0,0x8fe7f4,0,0xf0f3,0x8fe7f6,0x8fe7f7,0xf0f2, /* 0,'頁','頂','頃',0,'項','順','頇', '須',0,'頊',0,'頌','頍','頎','頏', */
	/* 9810 */ 0xcdc2,0xb4e8,0xc8d2,0xc6dc,0x8fe7f8,0,0x8fe7f9,0xbffc, 0xcece,0x8fe7f5,0xb7db,0,0x8fe7fa,0,0x8fe7fb,0, /* '預','頑','頒','頓','頔',0,'頖','頗', '領','頙','頚',0,'頜',0,'頞',0, */
	/* 9820 */ 0x8fe7fc,0xf0f6,0,0x8fe7fd,0xf0f5,0x8fe8a8,0x8fe7fe,0, 0,0,0,0x8fe8a1,0xcbcb,0xc6ac,0x8fe8a2,0x8fe8a3, /* '頠','頡',0,'頣','頤','頥','頦',0, 0,0,0,'頫','頬','頭','頮','頯', */
	/* 9830 */ 0x8fe8a4,0,0x8fe8a5,0x8fe8a6,0xb1d0,0x8fe8a7,0,0xf0f7, 0xf0f4,0,0,0xc9d1,0xcdea,0xf0f8,0x8fe8a9,0, /* '頰',0,'頲','頳','頴','頵',0,'頷', '頸',0,0,'頻','頼','頽','頾',0, */
	/* 9840 */ 0,0,0,0,0x8fe8aa,0,0xf0f9,0x8fe8ab, 0,0,0x8fe8ac,0xf0fb,0xc2ea,0xb3db,0xb3dc,0xf0fa, /* 0,0,0,0,'顄',0,'顆','顇', 0,0,'顊','顋','題','額','顎','顏', */
	/* 9850 */ 0,0x8fe8ad,0x8fe8ae,0x8fe8af,0xb4e9,0xb8b2,0x8fe8b0,0x8fe8b1, 0xb4ea,0x8fe8b2,0x8fe8b3,0xc5bf,0,0,0xcee0,0, /* 0,'顑','顒','顓','顔','顕','顖','顗', '願','顙','顚','顛',0,0,'類',0, */
	/* 9860 */ 0,0,0x8fe8b4,0x8fe8b5,0,0x8fe8b6,0x8fe8b7,0xb8dc, 0,0,0x8fe8b8,0xf0fc,0x8fe8b9,0,0,0xf0fd, /* 0,0,'顢','顣',0,'顥','顦','顧', 0,0,'顪','顫','顬',0,0,'顯', */
	/* 9870 */ 0xf0fe,0xf1a1,0,0xf1a3,0xf1a2,0,0,0, 0,0,0,0,0,0,0,0, /* '顰','顱',0,'顳','顴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 98a0 */ 0,0,0,0,0,0,0,0, 0xc9f7,0,0xf1a4,0x8fe8ba,0,0x8fe8bb,0x8fe8bc,0xf1a5, /* 0,0,0,0,0,0,0,0, '風',0,'颪','颫',0,'颭','颮','颯', */
	/* 98b0 */ 0x8fe8bd,0xf1a6,0,0,0x8fe8be,0,0xf1a7,0x8fe8bf, 0x8fe8c0,0,0x8fe8c1,0x8fe8c2,0,0,0,0x8fe8c3, /* '颰','颱',0,0,'颴',0,'颶','颷', '颸',0,'颺','颻',0,0,0,'颿', */
	/* 98c0 */ 0,0,0x8fe8c4,0xf1a9,0xf1a8,0x8fe8c5,0xf1aa,0, 0x8fe8c6,0,0,0,0x8fe8c7,0,0,0, /* 0,0,'飂','飃','飄','飅','飆',0, '飈',0,0,0,'飌',0,0,0, */
	/* 98d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0xc8f4,0xe6cc,0,0,0xbfa9, /* 0,0,0,0,0,0,0,0, 0,0,0,'飛','飜',0,0,'食', */
	/* 98e0 */ 0,0x8fe8c8,0xb5b2,0x8fe8c9,0,0x8fe8ca,0x8fe8cb,0x8fe8cc, 0,0xf1ab,0x8fe8cd,0xf1ac,0,0xd2ac,0xddbb,0xc8d3, /* 0,'飡','飢','飣',0,'飥','飦','飧', 0,'飩','飪','飫',0,'飭','飮','飯', */
	/* 98f0 */ 0,0,0xb0fb,0x8fe8ce,0xb0bb,0,0x8fe8cf,0, 0,0,0,0,0xbbf4,0xcbb0,0xbefe,0, /* 0,0,'飲','飳','飴',0,'飶',0, 0,0,0,0,'飼','飽','飾',0, */
	/* 9900 */ 0,0,0x8fe8d0,0xf1ad,0,0xccdf,0,0x8fe8d1, 0x8fe8d2,0xf1ae,0xcddc,0,0xb1c2,0,0,0, /* 0,0,'餂','餃',0,'餅',0,'餇', '餈','餉','養',0,'餌',0,0,0, */
	/* 9910 */ 0xbbc1,0x8fe8d3,0xf1af,0xb2ee,0xf1b0,0x8fe8d4,0x8fe8d5,0x8fe8d6, 0xf1b1,0,0x8fe8d7,0x8fe8d8,0x8fe8d9,0xf1b3,0xf1b4,0x8fe8da, /* '餐','餑','餒','餓','餔','餕','餖','餗', '餘',0,'餚','餛','餜','餝','餞','餟', */
	/* 9920 */ 0xf1b6,0xf1b2,0x8fe8db,0,0xf1b5,0,0x8fe8dc,0x8fe8dd, 0xb4db,0,0,0x8fe8de,0xf1b7,0,0xf1b8,0, /* '餠','餡','餢',0,'餤',0,'餦','餧', '館',0,0,'餫','餬',0,'餮',0, */
	/* 9930 */ 0,0x8fe8df,0x8fe8e0,0x8fe8e1,0x8fe8e2,0x8fe8e3,0,0, 0,0x8fe8e4,0x8fe8e5,0x8fe8e6,0x8fe8e7,0xf1b9,0xf1ba,0, /* 0,'餱','餲','餳','餴','餵',0,0, 0,'餹','餺','餻','餼','餽','餾',0, */
	/* 9940 */ 0x8fe8e8,0x8fe8e9,0xf1bb,0,0,0xf1bd,0x8fe8ea,0x8fe8eb, 0x8fe8ec,0xf1bc,0,0xf1bf,0xf1c2,0x8fe8ed,0x8fe8ee,0, /* '饀','饁','饂',0,0,'饅','饆','饇', '饈','饉',0,'饋','饌','饍','饎',0, */
	/* 9950 */ 0xf1be,0xf1c0,0xf1c1,0,0x8fe8ef,0xf1c3,0,0xb6c2, 0x8fe8f0,0x8fe8f1,0,0x8fe8f2,0x8fe8f3,0,0x8fe8f4,0x8fe8f5, /* '饐','饑','饒',0,'饔','饕',0,'饗', '饘','饙',0,'饛','饜',0,'饞','饟', */
	/* 9960 */ 0x8fe8f6,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '饠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9990 */ 0,0,0,0,0,0,0xbcf3,0xf1c4, 0xf1c5,0xb9e1,0,0x8fe8f7,0,0x8fe8f8,0x8ff4fa,0x8fe8f9, /* 0,0,0,0,0,0,'首','馗', '馘','香',0,'馛',0,'馝','馞','馟', */
	/* 99a0 */ 0,0,0,0,0,0xf1c6,0x8fe8fa,0, 0xb3be,0,0,0,0xc7cf,0xf1c7,0xf1c8,0, /* 0,0,0,0,0,'馥','馦',0, '馨',0,0,0,'馬','馭','馮',0, */
	/* 99b0 */ 0x8fe8fb,0x8fe8fc,0x8fe8fd,0xc3da,0xc6eb,0x8fe8fe,0,0, 0,0x8fe9a1,0x8fe9a2,0,0xf1c9,0x8fe9a3,0,0x8fe9a4, /* '馰','馱','馲','馳','馴','馵',0,0, 0,'馹','馺',0,'馼','馽',0,'馿', */
	/* 99c0 */ 0,0xc7fd,0,0x8fe9a5,0xc2cc,0xb1d8,0xb6ee,0, 0xb6ef,0x8fe9a6,0,0,0,0,0,0, /* 0,'駁',0,'駃','駄','駅','駆',0, '駈','駉',0,0,0,0,0,0, */
	/* 99d0 */ 0xc3f3,0xf1ce,0xb6f0,0x8fe9a7,0x8fe9a8,0xb2ef,0,0, 0xf1cd,0x8fe9a9,0x8fe9aa,0xf1cb,0x8fe9ab,0xf1cc,0x8fe9ac,0xf1ca, /* '駐','駑','駒','駓','駔','駕',0,0, '駘','駙','駚','駛','駜','駝','駞','駟', */
	/* 99e0 */ 0,0,0xf1d8,0,0,0,0,0x8fe9ad, 0,0,0x8fe9ae,0x8fe9af,0x8fe9b0,0xf1cf,0xf1d0,0, /* 0,0,'駢',0,0,0,0,'駧', 0,0,'駪','駫','駬','駭','駮',0, */
	/* 99f0 */ 0x8fe9b1,0xf1d1,0xf1d2,0,0x8fe9b2,0x8fe9b3,0,0, 0xf1d4,0x8fe9b4,0,0xf1d3,0,0x8fe9b5,0x8fe9b6,0xbdd9, /* '駰','駱','駲',0,'駴','駵',0,0, '駸','駹',0,'駻',0,'駽','駾','駿', */
	/* 9a00 */ 0,0xf1d5,0x8fe9b7,0x8fe9b8,0x8fe9b9,0xf1d7,0,0, 0,0,0,0x8fe9ba,0x8fe9bb,0,0xb5b3,0xf1d6, /* 0,'騁','騂','騃','騄','騅',0,0, 0,0,0,'騋','騌',0,'騎','騏', */
	/* 9a10 */ 0x8fe9bc,0x8fe9bd,0xc1fb,0xb8b3,0,0,0x8fe9be,0, 0,0xf1d9,0,0,0,0,0x8fe9bf,0, /* '騐','騑','騒','験',0,0,'騖',0, 0,'騙',0,0,0,0,'騞',0, */
	/* 9a20 */ 0x8fe9c0,0,0x8fe9c1,0x8fe9c2,0x8fe9c3,0,0,0x8fe9c4, 0xc2cd,0,0,0xf1da,0,0x8fe9c5,0x8fe9c6,0, /* '騠',0,'騢','騣','騤',0,0,'騧', '騨',0,0,'騫',0,'騭','騮',0, */
	/* 9a30 */ 0xc6ad,0,0,0x8fe9c7,0,0x8fe9c8,0x8fe9c9,0xf1db, 0x8fe9ca,0,0,0,0,0,0xf1e0,0, /* '騰',0,0,'騳',0,'騵','騶','騷', '騸',0,0,0,0,0,'騾',0, */

	/* 9a40 */ 0xf1de,0x8fe9cc,0xf1dd,0xf1df,0x8fe9cd,0xf1dc,0,0x8fe9cb, 0,0,0x8fe9ce,0x8fe9cf,0x8fe9d0,0xf1e2,0x8fe9d1,0, /* '驀','驁','驂','驃','驄','驅',0,'驇', 0,0,'驊','驋','驌','驍','驎',0, */
	/* 9a50 */ 0,0x8fe9d2,0,0,0x8fe9d3,0xf1e1,0x8fe9d4,0xf1e4, 0,0,0xb6c3,0xf1e3,0,0x8fe9d5,0,0xf1e5, /* 0,'驑',0,0,'驔','驕','驖','驗', 0,0,'驚','驛',0,'驝',0,'驟', */
	/* 9a60 */ 0,0,0xf1e6,0,0xf1e8,0xf1e7,0,0, 0,0xf1e9,0xf1eb,0xf1ea,0,0,0,0, /* 0,0,'驢',0,'驤','驥',0,0, 0,'驩','驪','驫',0,0,0,0, */
	/* 9a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9aa0 */ 0,0,0,0,0,0,0,0, 0xb9fc,0,0x8fe9d6,0,0x8fe9d7,0xf1ec,0x8fe9d8,0x8fe9d9, /* 0,0,0,0,0,0,0,0, '骨',0,'骪',0,'骬','骭','骮','骯', */
	/* 9ab0 */ 0xf1ed,0,0x8fe9da,0,0x8fe9db,0x8fe9dc,0x8fe9dd,0, 0xb3bc,0x8fe9de,0,0x8fe9df,0xf1ee,0,0x8fe9e0,0x8fe9e1, /* '骰',0,'骲',0,'骴','骵','骶',0, '骸','骹',0,'骻','骼',0,'骾','骿', */
	/* 9ac0 */ 0xf1ef,0x8fe9e2,0,0x8fe9e3,0xbff1,0,0x8fe9e4,0, 0x8fe9e5,0,0,0,0,0,0x8fe9e6,0xf1f0, /* '髀','髁',0,'髃','髄',0,'髆',0, '髈',0,0,0,0,0,'髎','髏', */
	/* 9ad0 */ 0x8fe9e7,0xf1f1,0x8fe9e8,0xf1f2,0xf1f3,0x8fe9e9,0x8fe9ea,0x8fe9eb, 0xb9e2,0x8ff4fb,0,0x8fe9ec,0x8fe9ed,0,0xf1f4,0xf1f5, /* '髐','髑','髒','髓','體','髕','髖','髗', '高','髙',0,'髛','髜',0,'髞','髟', */
	/* 9ae0 */ 0x8fe9ee,0,0xf1f6,0xf1f7,0x8fe9ef,0x8fe9f0,0xf1f8,0x8fe9f1, 0,0x8fe9f2,0xc8b1,0xf1fa,0x8fe9f3,0xc9a6,0xf1fb,0xf1f9, /* '髠',0,'髢','髣','髤','髥','髦','髧', 0,'髩','髪','髫','髬','髭','髮','髯', */
	/* 9af0 */ 0,0xf1fd,0x8fe9f4,0x8fe9f5,0xf1fc,0x8fe9f6,0,0xf1fe, 0,0x8fe9f7,0x8fe9f8,0xf2a1,0,0x8fe9f9,0,0x8fe9fa, /* 0,'髱','髲','髳','髴','髵',0,'髷', 0,'髹','髺','髻',0,'髽',0,'髿', */
	/* 9b00 */ 0x8fe9fb,0x8fe9fc,0x8fe9fd,0x8fe9fe,0x8feaa1,0x8feaa2,0xf2a2,0, 0x8feaa3,0x8feaa4,0,0x8feaa5,0x8feaa6,0x8feaa7,0x8feaa8,0, /* '鬀','鬁','鬂','鬃','鬄','鬅','鬆',0, '鬈','鬉',0,'鬋','鬌','鬍','鬎',0, */
	/* 9b10 */ 0x8feaa9,0,0x8feaaa,0,0,0,0x8feaab,0, 0xf2a3,0x8feaac,0xf2a4,0x8feaad,0x8feaae,0,0,0xf2a5, /* '鬐',0,'鬒',0,0,0,'鬖',0, '鬘','鬙','鬚','鬛','鬜',0,0,'鬟', */
	/* 9b20 */ 0x8feaaf,0,0xf2a6,0xf2a7,0,0xf2a8,0x8feab0,0xf2a9, 0xf2aa,0xf2ab,0xf2ac,0x8feab1,0,0x8feab2,0xf2ad,0xf2ae, /* '鬠',0,'鬢','鬣',0,'鬥','鬦','鬧', '鬨','鬩','鬪','鬫',0,'鬭','鬮','鬯', */
	/* 9b30 */ 0,0xddb5,0xf2af,0x8feab3,0x8feab4,0x8feab5,0,0x8feab6, 0,0x8feab7,0x8feab8,0xe4f8,0xb5b4,0x8feab9,0,0, /* 0,'鬱','鬲','鬳','鬴','鬵',0,'鬷', 0,'鬹','鬺','鬻','鬼','鬽',0,0, */
	/* 9b40 */ 0,0xb3a1,0xbab2,0xf2b1,0xf2b0,0xcca5,0,0, 0x8feaba,0,0,0x8feabb,0x8feabc,0xf2b3,0xf2b4,0xf2b2, /* 0,'魁','魂','魃','魄','魅',0,0, '魈',0,0,'魋','魌','魍','魎','魏', */
	/* 9b50 */ 0,0xf2b5,0,0,0xcbe2,0x8feabd,0x8feabe,0x8feabf, 0xf2b6,0,0xb5fb,0x8feac0,0,0,0x8feac1,0, /* 0,'魑',0,0,'魔','魕','魖','魗', '魘',0,'魚','魛',0,0,'魞',0, */
	/* 9b60 */ 0,0x8feac2,0,0x8feac3,0,0x8feac4,0x8feac5,0, 0x8feac6,0,0x8feac7,0x8feac8,0x8feac9,0x8feaca,0x8feacb,0xcfa5, /* 0,'魡',0,'魣',0,'魥','魦',0, '魨',0,'魪','魫','魬','魭','魮','魯', */
	/* 9b70 */ 0,0,0x8ff4fc,0x8feacc,0xf2b7,0x8feacd,0,0x8feace, 0x8feacf,0x8fead0,0,0,0,0,0,0x8fead1, /* 0,0,'魲','魳','魴','魵',0,'魷', '魸','魹',0,0,0,0,0,'魿', */
	/* 9b80 */ 0x8fead2,0,0,0xf2b9,0x8fead3,0x8fead4,0x8fead5,0x8fead6, 0,0x8fead7,0x8fead8,0x8fead9,0,0x8feada,0xb0be,0x8feadb, /* '鮀',0,0,'鮃','鮄','鮅','鮆','鮇', 0,'鮉','鮊','鮋',0,'鮍','鮎','鮏', */
	/* 9b90 */ 0x8feadc,0xf2ba,0xcaab,0xf2b8,0x8feadd,0,0xf2bb,0xf2bc, 0,0,0x8feade,0,0,0x8feadf,0x8feae0,0xf2bd, /* '鮐','鮑','鮒','鮓','鮔',0,'鮖','鮗', 0,0,'鮚',0,0,'鮝','鮞','鮟', */
	/* 9ba0 */ 0xf2be,0,0,0,0,0,0x8feae1,0x8feae2, 0xf2bf,0x8feae3,0xcbee,0xbbad,0x8feae4,0xbafa,0xc1af,0, /* '鮠',0,0,0,0,0,'鮦','鮧', '鮨','鮩','鮪','鮫','鮬','鮭','鮮',0, */
	/* 9bb0 */ 0x8feae5,0x8feae6,0x8feae7,0,0xf2c0,0,0,0x8feae8, 0x8feae9,0xf2c3,0,0x8feaea,0x8feaeb,0,0x8feaec,0x8feaed, /* '鮰','鮱','鮲',0,'鮴',0,0,'鮷', '鮸','鮹',0,'鮻','鮼',0,'鮾','鮿', */
	/* 9bc0 */ 0xf2c1,0x8feaee,0,0,0,0,0xf2c4,0x8feaef, 0x8feaf0,0xb8f1,0xf2c2,0,0,0,0x8feaf1,0xf2c5, /* '鯀','鯁',0,0,0,0,'鯆','鯇', '鯈','鯉','鯊',0,0,0,'鯎','鯏', */
	/* 9bd0 */ 0x8feaf2,0xf2c6,0xf2c7,0,0xf2cb,0,0xbbaa,0x8feaf3, 0x8feaf4,0,0,0xc2e4,0,0x8feaf5,0,0x8feaf6, /* '鯐','鯑','鯒',0,'鯔',0,'鯖','鯗', '鯘',0,0,'鯛',0,'鯝',0,'鯟', */
	/* 9be0 */ 0,0xf2cc,0xf2c9,0xf2c8,0xf2ca,0x8feaf7,0,0x8feaf8, 0xb7df,0,0x8feaf9,0x8feafa,0,0,0,0x8feafb, /* 0,'鯡','鯢','鯣','鯤','鯥',0,'鯧', '鯨',0,'鯪','鯫',0,0,0,'鯯', */
	/* 9bf0 */ 0xf2d0,0xf2cf,0xf2ce,0x8feafc,0,0xb0b3,0,0x8feafd, 0x8feafe,0x8feba1,0x8feba2,0,0,0x8feba3,0,0x8feba4, /* '鯰','鯱','鯲','鯳',0,'鯵',0,'鯷', '鯸','鯹','鯺',0,0,'鯽',0,'鯿', */
	/* 9c00 */ 0x8feba5,0,0x8feba6,0,0xf2da,0,0xf2d6,0, 0xf2d7,0xf2d3,0xf2d9,0x8feba7,0xf2d5,0xb3e2,0,0x8feba8, /* '鰀',0,'鰂',0,'鰄',0,'鰆',0, '鰈','鰉','鰊','鰋','鰌','鰍',0,'鰏', */
	/* 9c10 */ 0xcfcc,0x8feba9,0xf2d8,0xf2d4,0xf2d2,0xf2d1,0x8febaa,0, 0x8febab,0x8febac,0x8febad,0xf2dc,0x8febae,0,0x8febaf,0, /* '鰐','鰑','鰒','鰓','鰔','鰕','鰖',0, '鰘','鰙','鰚','鰛','鰜',0,'鰞',0, */
	/* 9c20 */ 0,0xf2df,0x8febb0,0x8febb1,0xf2de,0xf2dd,0x8febb2,0x8febb3, 0x8febb4,0x8febb5,0x8febb6,0,0,0xc9c9,0xf2db,0xb0f3, /* 0,'鰡','鰢','鰣','鰤','鰥','鰦','鰧', '鰨','鰩','鰪',0,0,'鰭','鰮','鰯', */
	/* 9c30 */ 0xf2e0,0x8febb7,0xf2e2,0,0,0x8febb8,0x8febb9,0x8febba, 0,0xb3ef,0xf2cd,0xb1b7,0,0x8febbb,0xf2e4,0, /* '鰰','鰱','鰲',0,0,'鰵','鰶','鰷', 0,'鰹','鰺','鰻',0,'鰽','鰾',0, */
	/* 9c40 */ 0,0x8febbc,0,0x8febbd,0x8febbe,0x8febbf,0xf2e3,0xf2e1, 0xc3ad,0x8febc0,0x8febc1,0,0,0,0x8febc2,0x8febc3, /* 0,'鱁',0,'鱃','鱄','鱅','鱆','鱇', '鱈','鱉','鱊',0,0,0,'鱎','鱏', */
	/* 9c50 */ 0x8febc4,0,0xcbf0,0x8febc5,0x8febc6,0,0x8febc7,0xceda, 0x8febc8,0,0xf2e5,0x8febc9,0x8febd0,0x8febca,0x8febcb,0x8febcc, /* '鱐',0,'鱒','鱓','鱔',0,'鱖','鱗', '鱘',0,'鱚','鱛','鱜','鱝','鱞','鱟', */
	/* 9c60 */ 0xf2e6,0,0,0x8febcd,0,0,0,0xf2e7, 0x8febd2,0x8febce,0x8febcf,0x8febd1,0,0,0x8febd3,0, /* '鱠',0,0,'鱣',0,0,0,'鱧', '鱨','鱩','鱪','鱫',0,0,'鱮',0, */
	/* 9c70 */ 0x8febd4,0,0x8febd5,0,0,0x8febd6,0xf2e8,0x8febd7, 0xf2e9,0,0,0x8febd8,0,0,0,0, /* '鱰',0,'鱲',0,0,'鱵','鱶','鱷', '鱸',0,0,'鱻',0,0,0,0, */
	/* 9c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ce0 */ 0,0,0,0,0,0xc4bb,0x8febd9,0xf2ea, 0,0xc8b7,0,0xf2ef,0xf2eb,0,0,0, /* 0,0,0,0,0,'鳥','鳦','鳧', 0,'鳩',0,'鳫','鳬',0,0,0, */
	/* 9cf0 */ 0xf2ec,0,0x8febda,0xcbb1,0xccc4,0,0xc6d0,0x8febdb, 0,0x8febdc,0,0,0,0,0,0, /* '鳰',0,'鳲','鳳','鳴',0,'鳶','鳷', 0,'鳹',0,0,0,0,0,0, */
	/* 9d00 */ 0,0,0x8febde,0xf2f0,0,0,0xf2f1,0xc6be, 0xf2ee,0xf2ed,0,0x8febdd,0,0,0xb2aa,0, /* 0,0,'鴂','鴃',0,0,'鴆','鴇', '鴈','鴉',0,'鴋',0,0,'鴎',0, */
	/* 9d10 */ 0,0x8febdf,0xf2f9,0,0,0xf2f8,0,0x8febe0, 0x8febe1,0,0,0xb1f5,0x8febe2,0x8febe3,0x8febe4,0xf2f6, /* 0,'鴑','鴒',0,0,'鴕',0,'鴗', '鴘',0,0,'鴛','鴜','鴝','鴞','鴟', */
	/* 9d20 */ 0,0,0,0xf2f5,0,0,0xf2f3,0, 0xb3fb,0,0xf2f2,0xbcb2,0xb2a9,0,0,0x8febe5, /* 0,0,0,'鴣',0,0,'鴦',0, '鴨',0,'鴪','鴫','鴬',0,0,'鴯', */
	/* 9d30 */ 0x8febe6,0,0x8febe7,0x8febe8,0x8febe9,0,0,0, 0,0,0x8febea,0xb9e3,0x8febeb,0x8febed,0xf2fc,0xf2fb, /* '鴰',0,'鴲','鴳','鴴',0,0,0, 0,0,'鴺','鴻','鴼','鴽','鴾','鴿', */
	/* 9d40 */ 0,0xf2fa,0x8febee,0x8febef,0xf2f7,0x8febec,0xf2fd,0x8febf0, 0xf2fe,0,0x8febf1,0,0,0,0,0, /* 0,'鵁','鵂','鵃','鵄','鵅','鵆','鵇', '鵈',0,'鵊',0,0,0,0,0, */
	/* 9d50 */ 0xf3a5,0xf3a4,0,0x8febf2,0x8febf3,0,0,0, 0,0xf3a6,0,0,0xb1ad,0xf3a1,0xf3a2,0x8febf4, /* '鵐','鵑',0,'鵓','鵔',0,0,0, 0,'鵙',0,0,'鵜','鵝','鵞','鵟', */
	/* 9d60 */ 0xb9f4,0xccb9,0x8febf6,0x8febf5,0xf3a3,0x8febf7,0,0, 0,0x8febf8,0x8febf9,0x8febfa,0xcbb2,0,0,0xf3ab, /* '鵠','鵡','鵢','鵣','鵤','鵥',0,0, 0,'鵩','鵪','鵫','鵬',0,0,'鵯', */
	/* 9d70 */ 0x8febfb,0,0xf3a7,0,0,0,0x8febfc,0x8febfd, 0,0,0xf3ac,0x8febfe,0x8feca1,0,0x8feca2,0, /* '鵰',0,'鵲',0,0,0,'鵶','鵷', 0,0,'鵺','鵻','鵼',0,'鵾',0, */
	/* 9d80 */ 0,0,0,0x8feca3,0x8feca4,0,0x8feca5,0xf3a9, 0,0xf3a8,0x8feca6,0,0,0x8feca7,0x8feca8,0xb7dc, /* 0,0,0,'鶃','鶄',0,'鶆','鶇', 0,'鶉','鶊',0,0,'鶍','鶎','鶏', */
	/* 9d90 */ 0,0,0x8feca9,0x8fecaa,0,0x8fecab,0x8fecac,0x8fecad, 0x8fecae,0,0xf3ad,0,0,0,0,0, /* 0,0,'鶒','鶓',0,'鶕','鶖','鶗', '鶘',0,'鶚',0,0,0,0,0, */
	/* 9da0 */ 0,0x8fecaf,0,0,0xf3ae,0,0,0, 0,0xf3af,0x8fecb0,0xf3aa,0x8fecb1,0,0x8fecb2,0xf2f4, /* 0,'鶡',0,0,'鶤',0,0,0, 0,'鶩','鶪','鶫','鶬',0,'鶮','鶯', */
	/* 9db0 */ 0,0x8fecb3,0xf3b0,0,0xc4e1,0x8fecb4,0,0, 0xf3b4,0x8fecb5,0xf3b5,0xf3b3,0x8fecb6,0,0,0x8fecb7, /* 0,'鶱','鶲',0,'鶴','鶵',0,0, '鶸','鶹','鶺','鶻','鶼',0,0,'鶿', */
	/* 9dc0 */ 0,0xf3b2,0xf3b8,0x8fecb8,0xf3b1,0,0xf3b6,0x8fecb9, 0,0x8fecba,0x8fecbb,0,0,0,0,0xf3b7, /* 0,'鷁','鷂','鷃','鷄',0,'鷆','鷇', 0,'鷉','鷊',0,0,0,0,'鷏', */
	/* 9dd0 */ 0,0,0,0xf3ba,0x8fecbc,0x8fecbd,0x8fecbe,0x8fecbf, 0,0xf3b9,0x8fecc0,0,0,0,0x8fecc1,0x8fecc2, /* 0,0,0,'鷓','鷔','鷕','鷖','鷗', 0,'鷙','鷚',0,0,0,'鷞','鷟', */
	/* 9de0 */ 0x8fecc3,0,0,0,0,0x8fecc4,0xf3bc,0x8fecc5, 0,0x8fecc6,0,0x8fecc7,0,0xf3bd,0x8fecc8,0xf3be, /* '鷠',0,0,0,0,'鷥','鷦','鷧', 0,'鷩',0,'鷫',0,'鷭','鷮','鷯', */
	/* 9df0 */ 0x8fecc9,0,0xcfc9,0x8fecca,0x8feccb,0,0,0, 0xf3bb,0xc2eb,0xbaed,0,0,0xf3bf,0x8feccc,0, /* '鷰',0,'鷲','鷳','鷴',0,0,0, '鷸','鷹','鷺',0,0,'鷽','鷾',0, */
	/* 9e00 */ 0,0,0x8fecce,0,0,0,0,0x8feccf, 0,0,0x8feccd,0,0,0,0x8fecd0,0, /* 0,0,'鸂',0,0,0,0,'鸇', 0,0,'鸊',0,0,0,'鸎',0, */
	/* 9e10 */ 0x8fecd1,0x8fecd2,0x8fecd3,0,0,0x8fecd4,0x8fecd5,0, 0,0x8fecd6,0xf3c0,0xf3c1,0x8fecd7,0x8fecd8,0xf3c2,0, /* '鸐','鸑','鸒',0,0,'鸕','鸖',0, 0,'鸙','鸚','鸛','鸜','鸝','鸞',0, */
	/* 9e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e70 */ 0,0,0,0,0,0xf3c3,0,0, 0xb8b4,0xf3c4,0x8fecd9,0x8fecda,0x8fecdb,0xf3c5,0,0xbcaf, /* 0,0,0,0,0,'鹵',0,0, '鹸','鹹','鹺','鹻','鹼','鹽',0,'鹿', */
	/* 9e80 */ 0x8fecdc,0xf3c6,0x8fecdd,0x8fecde,0x8fecdf,0x8fece0,0,0x8fece1, 0xf3c7,0,0,0xf3c8,0xf3c9,0,0x8fece2,0x8fece3, /* '麀','麁','麂','麃','麄','麅',0,'麇', '麈',0,0,'麋','麌',0,'麎','麏', */
	/* 9e90 */ 0,0xf3cc,0xf3ca,0xcfbc,0,0xf3cb,0x8fece4,0xceef, 0x8fece5,0,0,0x8fece6,0,0xf3cd,0x8fece7,0xcedb, /* 0,'麑','麒','麓',0,'麕','麖','麗', '麘',0,0,'麛',0,'麝','麞','麟', */
	/* 9ea0 */ 0,0,0,0,0x8fece8,0xf3ce,0xc7fe,0, 0x8fece9,0xf3cf,0xf3d1,0,0x8fecea,0xf3d2,0x8feceb,0x8fecec, /* 0,0,0,0,'麤','麥','麦',0, '麨','麩','麪',0,'麬','麭','麮','麯', */
	/* 9eb0 */ 0x8feced,0,0,0x8fecee,0x8fecef,0x8fecf0,0,0, 0xf3d0,0xb9ed,0xcccd,0xcbe3,0xd6f7,0,0xdde0,0xcbfb, /* '麰',0,0,'麳','麴','麵',0,0, '麸','麹','麺','麻','麼',0,'麾','麿', */
	/* 9ec0 */ 0,0,0,0,0xb2ab,0,0x8fecf1,0, 0x8fecf2,0,0,0x8fecf3,0xf3d4,0xb5d0,0xf3d5,0xf3d6, /* 0,0,0,0,'黄',0,'黆',0, '黈',0,0,'黋','黌','黍','黎','黏', */
	/* 9ed0 */ 0xf3d7,0x8ff4fe,0xb9f5,0,0xf3d8,0x8fecf4,0,0, 0xe0d4,0xccdb,0,0xc2e3,0xf3d9,0xf3db,0xf3da,0x8fecf5, /* '黐','黑','黒',0,'黔','黕',0,0, '默','黙',0,'黛','黜','黝','點','黟', */
	/* 9ee0 */ 0xf3dc,0,0,0,0x8fecf6,0xf3dd,0,0x8fecf7, 0xf3de,0,0,0,0x8fecf8,0x8fecf9,0x8fecfa,0xf3df, /* '黠',0,0,0,'黤','黥',0,'黧', '黨',0,0,0,'黬','黭','黮','黯', */
	/* 9ef0 */ 0x8fecfb,0x8fecfc,0x8fecfd,0,0xf3e0,0x8fecfe,0xf3e1,0xf3e2, 0x8feda1,0xf3e3,0,0xf3e4,0xf3e5,0xf3e6,0,0x8feda2, /* '黰','黱','黲',0,'黴','黵','黶','黷', '黸','黹',0,'黻','黼','黽',0,'黿', */
	/* 9f00 */ 0,0,0x8feda3,0x8feda4,0,0,0,0xf3e7, 0xf3e8,0x8feda5,0,0,0,0,0xc5a4,0x8feda6, /* 0,0,'鼂','鼃',0,0,0,'鼇', '鼈','鼉',0,0,0,0,'鼎','鼏', */
	/* 9f10 */ 0x8feda7,0x8feda8,0x8feda9,0xb8dd,0x8fedaa,0xf3ea,0x8fedab,0x8fedac, 0,0x8fedad,0x8fedae,0x8fedaf,0,0,0,0x8fedb0, /* '鼐','鼑','鼒','鼓','鼔','鼕','鼖','鼗', 0,'鼙','鼚','鼛',0,0,0,'鼟', */
	/* 9f20 */ 0xc1cd,0xf3eb,0x8fedb1,0,0,0,0x8fedb2,0, 0,0,0x8fedb3,0x8fedb4,0xf3ec,0,0,0x8fedb5, /* '鼠','鼡','鼢',0,0,0,'鼦',0, 0,0,'鼪','鼫','鼬',0,0,'鼯', */
	/* 9f30 */ 0,0x8fedb6,0x8fedb7,0,0x8fedb8,0,0,0x8fedb9, 0,0x8fedba,0x8fedbb,0xc9a1,0x8fedbc,0x8fedbd,0xf3ed,0x8fedbe, /* 0,'鼱','鼲',0,'鼴',0,0,'鼷', 0,'鼹','鼺','鼻','鼼','鼽','鼾','鼿', */
	/* 9f40 */ 0,0x8fedbf,0,0x8fedc0,0x8fedc1,0x8fedc2,0x8fedc3,0x8fedc4, 0,0,0xf3ee,0xe3b7,0,0,0xecda,0xf0ed, /* 0,'齁',0,'齃','齄','齅','齆','齇', 0,0,'齊','齋',0,0,'齎','齏', */
	/* 9f50 */ 0,0,0xf3ef,0x8fedc5,0xf3f0,0x8fedc6,0x8fedc7,0x8fedc8, 0x8fedc9,0,0x8fedca,0,0,0x8fedcb,0x8fedcc,0xf3f2, /* 0,0,'齒','齓','齔','齕','齖','齗', '齘',0,'齚',0,0,'齝','齞','齟', */
	/* 9f60 */ 0xf3f3,0xf3f4,0xcef0,0xf3f1,0,0,0xf3f5,0xf3f6, 0x8fedcd,0x8fedce,0xf3f8,0,0xf3f7,0x8fedcf,0x8fedd0,0x8fedd1, /* '齠','齡','齢','齣',0,0,'齦','齧', '齨','齩','齪',0,'齬','齭','齮','齯', */
	/* 9f70 */ 0x8fedd2,0x8fedd3,0xf3fa,0x8fedd4,0,0x8fedd5,0xf3fb,0xf3f9, 0,0,0x8fedd6,0,0,0x8fedd7,0,0, /* '齰','齱','齲','齳',0,'齵','齶','齷', 0,0,'齺',0,0,'齽',0,0, */
	/* 9f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xceb6,0,0x8fedd8, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'龍',0,'龏', */
	/* 9f90 */ 0x8fedd9,0x8fedda,0x8feddb,0,0x8feddc,0xf3fc,0x8feddd,0x8fedde, 0,0,0,0,0xf3fd,0xe3d4,0x8feddf,0, /* '龐','龑','龒',0,'龔','龕','龖','龗', 0,0,0,0,'龜','龝','龞',0, */
	/* 9fa0 */ 0xf3fe,0x8fede0,0x8fede1,0x8fede2,0,0x8fede3,0,0, 0,0,0,0,0,0,0,0, /* '龠','龡','龢','龣',0,'龥',0,0, 0,0,0,0,0,0,0,0, */
	/* 9fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

	/* a510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ace0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ada0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* add0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ade0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* beb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ceb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ced0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* deb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ded0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* def0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

	/* e110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ead0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ece0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ede0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f920 */ 0,0,0,0,0,0,0,0, 0,0x8ff4c5,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'朗',0,0,0,0,0,0, */
	/* f930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

	/* f940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x8ff4f2,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'隆',0,0,0, */
	/* f9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x8ff4b4,0x8ff4b7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'﨎','﨏', */
	/* fa10 */ 0x8ff4b8,0x8ff4bd,0x8ff4c4,0x8ff4c7,0x8ff4c8,0x8ff4ce,0x8ff4cf,0x8ff4d3, 0x8ff4d5,0x8ff4d6,0x8ff4d7,0x8ff4d8,0x8ff4da,0x8ff4db,0x8ff4de,0x8ff4e0, /* '塚','﨑','晴','﨓','﨔','凞','猪','益', '礼','神','祥','福','靖','精','羽','﨟', */
	/* fa20 */ 0x8ff4e2,0x8ff4e3,0x8ff4e5,0x8ff4e9,0x8ff4ea,0x8ff4eb,0x8ff4ed,0x8ff4ef, 0x8ff4f0,0x8ff4f3,0x8ff4f7,0x8ff4f8,0x8ff4f9,0x8ff4fd,0,0, /* '蘒','﨡','諸','﨣','﨤','逸','都','﨧', '﨨','﨩','飯','飼','館','鶴',0,0, */
	/* fa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* feb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

	/* fef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ff00 */ 0,0xa1aa,0x8ff4aa,0xa1f4,0xa1f0,0xa1f3,0xa1f5,0x8ff4a9, 0xa1ca,0xa1cb,0xa1f6,0xa1dc,0xa1a4,0xa1dd,0xa1a5,0xa1bf, /* 0,'！','＂','＃','＄','％','＆','＇', '（','）','＊','＋','，','－','．','／', */
	/* ff10 */ 0xa3b0,0xa3b1,0xa3b2,0xa3b3,0xa3b4,0xa3b5,0xa3b6,0xa3b7, 0xa3b8,0xa3b9,0xa1a7,0xa1a8,0xa1e3,0xa1e1,0xa1e4,0xa1a9, /* '０','１','２','３','４','５','６','７', '８','９','：','；','＜','＝','＞','？', */
	/* ff20 */ 0xa1f7,0xa3c1,0xa3c2,0xa3c3,0xa3c4,0xa3c5,0xa3c6,0xa3c7, 0xa3c8,0xa3c9,0xa3ca,0xa3cb,0xa3cc,0xa3cd,0xa3ce,0xa3cf, /* '＠','Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ', 'Ｈ','Ｉ','Ｊ','Ｋ','Ｌ','Ｍ','Ｎ','Ｏ', */
	/* ff30 */ 0xa3d0,0xa3d1,0xa3d2,0xa3d3,0xa3d4,0xa3d5,0xa3d6,0xa3d7, 0xa3d8,0xa3d9,0xa3da,0xa1ce,0xa1c0,0xa1cf,0xa1b0,0xa1b2, /* 'Ｐ','Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ', 'Ｘ','Ｙ','Ｚ','［','＼','］','＾','＿', */
	/* ff40 */ 0xa1ae,0xa3e1,0xa3e2,0xa3e3,0xa3e4,0xa3e5,0xa3e6,0xa3e7, 0xa3e8,0xa3e9,0xa3ea,0xa3eb,0xa3ec,0xa3ed,0xa3ee,0xa3ef, /* '｀','ａ','ｂ','ｃ','ｄ','ｅ','ｆ','ｇ', 'ｈ','ｉ','ｊ','ｋ','ｌ','ｍ','ｎ','ｏ', */
	/* ff50 */ 0xa3f0,0xa3f1,0xa3f2,0xa3f3,0xa3f4,0xa3f5,0xa3f6,0xa3f7, 0xa3f8,0xa3f9,0xa3fa,0xa1d0,0xa1c3,0xa1d1,0xa1c1,0, /* 'ｐ','ｑ','ｒ','ｓ','ｔ','ｕ','ｖ','ｗ', 'ｘ','ｙ','ｚ','｛','｜','｝','～',0, */
	/* ff60 */ 0,0x8ea1,0x8ea2,0x8ea3,0x8ea4,0x8ea5,0x8ea6,0x8ea7, 0x8ea8,0x8ea9,0x8eaa,0x8eab,0x8eac,0x8ead,0x8eae,0x8eaf, /* 0,'｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* ff70 */ 0x8eb0,0x8eb1,0x8eb2,0x8eb3,0x8eb4,0x8eb5,0x8eb6,0x8eb7, 0x8eb8,0x8eb9,0x8eba,0x8ebb,0x8ebc,0x8ebd,0x8ebe,0x8ebf, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* ff80 */ 0x8ec0,0x8ec1,0x8ec2,0x8ec3,0x8ec4,0x8ec5,0x8ec6,0x8ec7, 0x8ec8,0x8ec9,0x8eca,0x8ecb,0x8ecc,0x8ecd,0x8ece,0x8ecf, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* ff90 */ 0x8ed0,0x8ed1,0x8ed2,0x8ed3,0x8ed4,0x8ed5,0x8ed6,0x8ed7, 0x8ed8,0x8ed9,0x8eda,0x8edb,0x8edc,0x8edd,0x8ede,0x8edf, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
	/* ffa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffe0 */ 0xa1f1,0xa1f2,0xa2cc,0xa1b1,0x8fa2c3,0xa1ef, /* '￠','￡','￢','￣','￤','￥', */
};

const size_t _unibe2eucms_table_size = sizeof(_unibe2eucms_table) / sizeof(_unibe2eucms_table[0]);

#endif /* #ifndef __UNIBE2EUCMS_TABLE_H_ */
