/*
 * _unibe2jis2022jp2004_table.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __UNIBE2JIS2022JP2004_TABLE_H_
#define __UNIBE2JIS2022JP2004_TABLE_H_

#include <stddef.h>
#include <stdint.h>

const uint16_t _unibe2jis2022jp2004_table[] = {
	/* 0000 */ 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, 0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* '','','','','','','','', '','','','','','','','', */
	/* 0010 */ 0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, 0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* '','','','','','','','', '','','','','','','','', */
	/* 0020 */ 0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, 0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /*  ,!,",#,$,%,&,', (,),*,+,,,-,.,/, */
	/* 0030 */ 0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, 0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* 0,1,2,3,4,5,6,7, 8,9,:,;,<,=,>,?, */
	/* 0040 */ 0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, 0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* @,A,B,C,D,E,F,G, H,I,J,K,L,M,N,O, */
	/* 0050 */ 0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, 0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* P,Q,R,S,T,U,V,W, X,Y,Z,[,\,],^,_, */
	/* 0060 */ 0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, 0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* `,a,b,c,d,e,f,g, h,i,j,k,l,m,n,o, */
	/* 0070 */ 0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, 0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f, /* p,q,r,s,t,u,v,w, x,y,z,{,|,},~,0, */
	/* 0080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00a0 */ 0x2922,0x2923,0x2171,0x2172,0x2924,0x216f,0x2925,0x2178, 0x212f,0x2926,0x2927,0x2928,0x224c,0x2929,0x292a,0x292b, /*  ,¡,¢,£,¤,¥,¦,§, ¨,©,ª,«,¬,­,®,¯, */
	/* 00b0 */ 0x216b,0x215e,0x292c,0x292d,0x212d,0,0x2279,0x292e, 0x292f,0x2930,0x2931,0x2932,0x2933,0x2934,0x2935,0x2936, /* °,±,²,³,´,0,¶,·, ¸,¹,º,»,¼,½,¾,¿, */
	/* 00c0 */ 0x2937,0x2938,0x2939,0x293a,0x293b,0x293c,0x293d,0x293e, 0x293f,0x2940,0x2941,0x2942,0x2943,0x2944,0x2945,0x2946, /* À,Á,Â,Ã,Ä,Å,Æ,Ç, È,É,Ê,Ë,Ì,Í,Î,Ï, */
	/* 00d0 */ 0x2947,0x2948,0x2949,0x294a,0x294b,0x294c,0x294d,0x215f, 0x294e,0x294f,0x2950,0x2951,0x2952,0x2953,0x2954,0x2955, /* Ð,Ñ,Ò,Ó,Ô,Õ,Ö,×, Ø,Ù,Ú,Û,Ü,Ý,Þ,ß, */
	/* 00e0 */ 0x2956,0x2957,0x2958,0x2959,0x295a,0x295b,0x295c,0x295d, 0x295e,0x295f,0x2960,0x2961,0x2962,0x2963,0x2964,0x2965, /* à,á,â,ã,ä,å,æ,ç, è,é,ê,ë,ì,í,î,ï, */
	/* 00f0 */ 0x2966,0x2967,0x2968,0x2969,0x296a,0x296b,0x296c,0x2160, 0x296d,0x296e,0x296f,0x2970,0x2971,0x2972,0x2973,0x2974, /* ð,ñ,ò,ó,ô,õ,ö,÷, ø,ù,ú,û,ü,ý,þ,ÿ, */
	/* 0100 */ 0x2975,0x297a,0x2a3a,0x2a49,0x2a21,0x2a2c,0x2a3c,0x2a4b, 0x2a59,0x2a5f,0,0,0x2a3d,0x2a4c,0x2a40,0x2a4f, /* Ā,ā,Ă,ă,Ą,ą,Ć,ć, Ĉ,ĉ,0,0,Č,č,Ď,ď, */
	/* 0110 */ 0,0x2a50,0x2978,0x297d,0,0,0,0, 0x2a3e,0x2a4d,0x2a3f,0x2a4e,0x2a5a,0x2a60,0,0, /* 0,đ,Ē,ē,0,0,0,0, Ę,ę,Ě,ě,Ĝ,ĝ,0,0, */
	/* 0120 */ 0,0,0,0,0x2a5b,0x2a61,0,0x2a7d, 0,0,0x2976,0x297b,0,0,0,0, /* 0,0,0,0,Ĥ,ĥ,0,ħ, 0,0,Ī,ī,0,0,0,0, */
	/* 0130 */ 0,0,0,0,0x2a5c,0x2a62,0,0, 0,0x2a3b,0x2a4a,0,0,0x2a24,0x2a2f,0, /* 0,0,0,0,Ĵ,ĵ,0,0, 0,Ĺ,ĺ,0,0,Ľ,ľ,0, */
	/* 0140 */ 0,0x2a23,0x2a2e,0x2a41,0x2a51,0,0,0x2a42, 0x2a52,0,0,0x2a7a,0x2979,0x297e,0,0, /* 0,Ł,ł,Ń,ń,0,0,Ň, ň,0,0,ŋ,Ō,ō,0,0, */
	/* 0150 */ 0x2a43,0x2a53,0x2b2b,0x2b2a,0x2a39,0x2a48,0,0, 0x2a44,0x2a54,0x2a25,0x2a30,0x2a5d,0x2a63,0x2a27,0x2a33, /* Ő,ő,Œ,œ,Ŕ,ŕ,0,0, Ř,ř,Ś,ś,Ŝ,ŝ,Ş,ş, */
	/* 0160 */ 0x2a26,0x2a32,0x2a47,0x2a57,0x2a28,0x2a34,0,0, 0,0,0x2977,0x297c,0x2a5e,0x2a64,0x2a45,0x2a55, /* Š,š,Ţ,ţ,Ť,ť,0,0, 0,0,Ū,ū,Ŭ,ŭ,Ů,ů, */
	/* 0170 */ 0x2a46,0x2a56,0,0,0,0,0,0, 0,0x2a29,0x2a35,0x2a2b,0x2a38,0x2a2a,0x2a37,0, /* Ű,ű,0,0,0,0,0,0, 0,Ź,ź,Ż,ż,Ž,ž,0, */
	/* 0180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0190 */ 0,0,0,0x2b29,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,Ɠ,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 01a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01c0 */ 0,0,0x2b24,0,0,0,0,0, 0,0,0,0,0,0x286f,0x2870,0, /* 0,0,ǂ,0,0,0,0,0, 0,0,0,0,0,Ǎ,ǎ,0, */
	/* 01d0 */ 0x2871,0x2876,0x2877,0,0x2878,0,0x2879,0, 0x287a,0,0x287b,0,0x287c,0,0,0, /* ǐ,Ǒ,ǒ,0,ǔ,0,ǖ,0, ǘ,0,ǚ,0,ǜ,0,0,0, */
	/* 01e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01f0 */ 0,0,0,0,0,0,0,0, 0x2874,0x2875,0,0,0,0x2b45,0,0, /* 0,0,0,0,0,0,0,0, Ǹ,ǹ,0,0,0,ǽ,0,0, */
	/* 0200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0250 */ 0x2b33,0x2b39,0x2b3a,0x2b25,0x2b38,0x2b3f,0x2a6e,0x2b26, 0x2b2e,0x2b30,0x2b43,0,0x2b31,0,0x2b32,0x2a75, /* ɐ,ɑ,ɒ,ɓ,ɔ,ɕ,ɖ,ɗ, ɘ,ə,ɚ,0,ɜ,0,ɞ,ɟ, */
	/* 0260 */ 0x2b28,0x2a79,0,0,0x2b36,0x2b3c,0x2b22,0x2b42, 0x2b2c,0,0,0,0x2a6a,0x2a74,0x2a6b,0x2b34, /* ɠ,ɡ,0,0,ɤ,ɥ,ɦ,ɧ, ɨ,0,0,0,ɬ,ɭ,ɮ,ɯ, */
	/* 0270 */ 0x2a7b,0x2a65,0x2a76,0x2a6f,0,0x2b2f,0,0, 0,0x2a6c,0x2b41,0x2a73,0,0x2a70,0x2a67,0, /* ɰ,ɱ,ɲ,ɳ,0,ɵ,0,0, 0,ɹ,ɺ,ɻ,0,ɽ,ɾ,0, */
	/* 0280 */ 0,0x2a7c,0x2a71,0x2a68,0x2b27,0,0,0, 0x2a6d,0x2b2d,0x2b35,0x2a66,0x2b37,0x2b3b,0x2a78,0, /* 0,ʁ,ʂ,ʃ,ʄ,0,0,0, ʈ,ʉ,ʊ,ʋ,ʌ,ʍ,ʎ,0, */
	/* 0290 */ 0x2a72,0x2b40,0x2a69,0,0x2b21,0x2a7e,0,0, 0x2b23,0,0,0,0,0x2a77,0,0, /* ʐ,ʑ,ʒ,0,ʔ,ʕ,0,0, ʘ,0,0,0,0,ʝ,0,0, */
	/* 02a0 */ 0,0x2b3e,0x2b3d,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,ʡ,ʢ,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 02b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02c0 */ 0,0,0,0,0,0,0,0x2a31, 0x2b53,0,0,0,0x2b54,0,0,0, /* 0,0,0,0,0,0,0,ˇ, ˈ,0,0,0,ˌ,0,0,0, */
	/* 02d0 */ 0x2b55,0x2b56,0,0,0,0,0,0, 0x2a22,0x2a58,0,0x2a2d,0,0x2a36,0x2b71,0, /* ː,ˑ,0,0,0,0,0,0, ˘,˙,0,˛,0,˝,˞,0, */
	/* 02e0 */ 0,0,0,0,0,0x2b60,0x2b61,0x2b62, 0x2b63,0x2b64,0,0,0,0,0,0, /* 0,0,0,0,0,˥,˦,˧, ˨,˩,0,0,0,0,0,0, */
	/* 02f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0300 */ 0x2b5c,0x2b5a,0x2b5f,0x2b7d,0x2b5b,0,0x2b57,0, 0x2b6d,0,0,0x2b59,0x2b5e,0,0,0x2b5d, /* ̀,́,̂,̃,̄,0,̆,0, ̈,0,0,̋,̌,0,0,̏, */
	/* 0310 */ 0,0,0,0,0,0,0,0, 0x2b78,0x2b79,0x2b7e,0,0x2b6a,0x2b76,0x2b77,0x2b6b, /* 0,0,0,0,0,0,0,0, ̘,̙,̚,0,̜,̝,̞,̟, */
	/* 0320 */ 0x2b6c,0,0,0,0x2b72,0x2b67,0,0, 0,0x2b6f,0x2b7a,0,0x2b68,0,0,0x2b70, /* ̠,0,0,0,̤,̥,0,0, 0,̩,̪,0,̬,0,0,̯, */
	/* 0330 */ 0x2b73,0,0,0,0x2b75,0,0,0, 0,0x2b69,0x2b7b,0x2b7c,0x2b74,0x2b6e,0,0, /* ̰,0,0,0,̴,0,0,0, 0,̹,̺,̻,̼,̽,0,0, */
	/* 0340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0360 */ 0,0x2b52,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,͡,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0390 */ 0,0x2621,0x2622,0x2623,0x2624,0x2625,0x2626,0x2627, 0x2628,0x2629,0x262a,0x262b,0x262c,0x262d,0x262e,0x262f, /* 0,Α,Β,Γ,Δ,Ε,Ζ,Η, Θ,Ι,Κ,Λ,Μ,Ν,Ξ,Ο, */
	/* 03a0 */ 0x2630,0x2631,0,0x2632,0x2633,0x2634,0x2635,0x2636, 0x2637,0x2638,0,0,0,0,0,0, /* Π,Ρ,0,Σ,Τ,Υ,Φ,Χ, Ψ,Ω,0,0,0,0,0,0, */
	/* 03b0 */ 0,0x2641,0x2642,0x2643,0x2644,0x2645,0x2646,0x2647, 0x2648,0x2649,0x264a,0x264b,0x264c,0x264d,0x264e,0x264f, /* 0,α,β,γ,δ,ε,ζ,η, θ,ι,κ,λ,μ,ν,ξ,ο, */
	/* 03c0 */ 0x2650,0x2651,0x2659,0x2652,0x2653,0x2654,0x2655,0x2656, 0x2657,0x2658,0,0,0,0,0,0, /* π,ρ,ς,σ,τ,υ,φ,χ, ψ,ω,0,0,0,0,0,0, */
	/* 03d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0400 */ 0,0x2727,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,Ё,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0410 */ 0x2721,0x2722,0x2723,0x2724,0x2725,0x2726,0x2728,0x2729, 0x272a,0x272b,0x272c,0x272d,0x272e,0x272f,0x2730,0x2731, /* А,Б,В,Г,Д,Е,Ж,З, И,Й,К,Л,М,Н,О,П, */
	/* 0420 */ 0x2732,0x2733,0x2734,0x2735,0x2736,0x2737,0x2738,0x2739, 0x273a,0x273b,0x273c,0x273d,0x273e,0x273f,0x2740,0x2741, /* Р,С,Т,У,Ф,Х,Ц,Ч, Ш,Щ,Ъ,Ы,Ь,Э,Ю,Я, */
	/* 0430 */ 0x2751,0x2752,0x2753,0x2754,0x2755,0x2756,0x2758,0x2759, 0x275a,0x275b,0x275c,0x275d,0x275e,0x275f,0x2760,0x2761, /* а,б,в,г,д,е,ж,з, и,й,к,л,м,н,о,п, */
	/* 0440 */ 0x2762,0x2763,0x2764,0x2765,0x2766,0x2767,0x2768,0x2769, 0x276a,0x276b,0x276c,0x276d,0x276e,0x276f,0x2770,0x2771, /* р,с,т,у,ф,х,ц,ч, ш,щ,ъ,ы,ь,э,ю,я, */
	/* 0450 */ 0,0x2757,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,ё,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x2872,0x2873, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,Ḿ,ḿ, */
	/* 1e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f70 */ 0x2b46,0x2b47,0x2b50,0x2b51,0,0,0,0, 0,0,0,0,0,0,0,0, /* ὰ,ά,ὲ,έ,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2010 */ 0x213e,0,0,0x237c,0x213d,0x213d,0x2142,0, 0x2146,0x2147,0,0,0x2148,0x2149,0,0, /* ‐,0,0,–,—,—,‖,0, ‘,’,0,0,“,”,0,0, */
	/* 2020 */ 0x2277,0x2278,0x2340,0,0,0x2145,0x2144,0, 0,0,0,0,0,0,0,0, /* †,‡,•,0,0,‥,…,0, 0,0,0,0,0,0,0,0, */
	/* 2030 */ 0x2273,0,0x216c,0x216d,0,0,0,0, 0,0,0,0x2228,0x286b,0,0x2131,0x2b58, /* ‰,0,′,″,0,0,0,0, 0,0,0,※,‼,0,‾,‿, */
	/* 2040 */ 0,0,0x2c7e,0,0,0,0,0x286c, 0x286d,0x286e,0,0,0,0,0,0, /* 0,0,⁂,0,0,0,0,⁇, ⁈,⁉,0,0,0,0,0,0, */
	/* 2050 */ 0,0x2c7d,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,⁑,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x2921,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,€,0,0,0, */
	/* 20b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2100 */ 0,0,0,0x216e,0,0,0,0, 0,0,0,0,0,0,0,0x235d, /* 0,0,0,℃,0,0,0,0, 0,0,0,0,0,0,0,ℏ, */
	/* 2110 */ 0,0,0,0x235f,0,0,0x2d62,0, 0,0,0,0,0,0,0,0, /* 0,0,0,ℓ,0,0,№,0, 0,0,0,0,0,0,0,0, */
	/* 2120 */ 0,0x2d64,0,0,0,0,0,0x2360, 0,0,0,0x2272,0,0,0,0, /* 0,℡,0,0,0,0,0,℧, 0,0,0,Å,0,0,0,0, */
	/* 2130 */ 0,0,0,0,0,0x235c,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,ℵ,0,0, 0,0,0,0,0,0,0,0, */
	/* 2140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2150 */ 0,0,0,0x2778,0x2779,0x277a,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,⅓,⅔,⅕,0,0, 0,0,0,0,0,0,0,0, */
	/* 2160 */ 0x2d35,0x2d36,0x2d37,0x2d38,0x2d39,0x2d3a,0x2d3b,0x2d3c, 0x2d3d,0x2d3e,0x2d3f,0x2d57,0,0,0,0, /* Ⅰ,Ⅱ,Ⅲ,Ⅳ,Ⅴ,Ⅵ,Ⅶ,Ⅷ, Ⅸ,Ⅹ,Ⅺ,Ⅻ,0,0,0,0, */
	/* 2170 */ 0x2c35,0x2c36,0x2c37,0x2c38,0x2c39,0x2c3a,0x2c3b,0x2c3c, 0x2c3d,0x2c3e,0x2c3f,0x2c40,0,0,0,0, /* ⅰ,ⅱ,ⅲ,ⅳ,ⅴ,ⅵ,ⅶ,ⅷ, ⅸ,ⅹ,ⅺ,ⅻ,0,0,0,0, */
	/* 2180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2190 */ 0x222b,0x222c,0x222a,0x222d,0x2271,0,0x2327,0x2325, 0x2326,0x2328,0,0,0,0,0,0, /* ←,↑,→,↓,↔,0,↖,↗, ↘,↙,0,0,0,0,0,0, */
	/* 21a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21c0 */ 0,0,0,0,0x2329,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,⇄,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21d0 */ 0,0,0x224d,0,0x224e,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,⇒,0,⇔,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21e0 */ 0,0,0,0,0,0,0x232b,0x232c, 0x232a,0x232d,0,0,0,0,0,0, /* 0,0,0,0,0,0,⇦,⇧, ⇨,⇩,0,0,0,0,0,0, */
	/* 21f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2200 */ 0x224f,0,0x225f,0x2250,0,0x2247,0,0x2260, 0x223a,0x2246,0,0x223b,0,0,0,0, /* ∀,0,∂,∃,0,∅,0,∇, ∈,∉,0,∋,0,0,0,0, */
	/* 2210 */ 0,0,0x215d,0x235b,0,0,0,0, 0,0,0x2265,0,0,0x2267,0x2167,0x2d78, /* 0,0,−,∓,0,0,0,0, 0,0,√,0,0,∝,∞,∟, */
	/* 2220 */ 0x225c,0,0,0,0,0x2254,0x2255,0x224a, 0x224b,0x2241,0x2240,0x2269,0x226a,0,0x2d73,0, /* ∠,0,0,0,0,∥,∦,∧, ∨,∩,∪,∫,∬,0,∮,0, */
	/* 2230 */ 0,0,0,0,0x2168,0x2268,0,0, 0,0,0,0,0,0x2266,0,0, /* 0,0,0,0,∴,∵,0,0, 0,0,0,0,0,∽,0,0, */
	/* 2240 */ 0,0,0,0x226c,0,0x226d,0,0, 0x226e,0,0,0,0,0,0,0, /* 0,0,0,≃,0,≅,0,0, ≈,0,0,0,0,0,0,0, */
	/* 2250 */ 0,0,0x2262,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,≒,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2260 */ 0x2162,0x2261,0x226b,0,0,0,0x2165,0x2166, 0,0,0x2263,0x2264,0,0,0,0, /* ≠,≡,≢,0,0,0,≦,≧, 0,0,≪,≫,0,0,0,0, */
	/* 2270 */ 0,0,0,0,0,0,0x226f,0x2270, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,≶,≷, 0,0,0,0,0,0,0,0, */
	/* 2280 */ 0,0,0x223e,0x223f,0x2242,0x2243,0x223c,0x223d, 0,0,0x2244,0x2245,0,0,0,0, /* 0,0,⊂,⊃,⊄,⊅,⊆,⊇, 0,0,⊊,⊋,0,0,0,0, */
	/* 2290 */ 0,0,0,0,0,0x2251,0x2252,0x2253, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,⊕,⊖,⊗, 0,0,0,0,0,0,0,0, */
	/* 22a0 */ 0,0,0,0,0,0x225d,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,⊥,0,0, 0,0,0,0,0,0,0,0, */
	/* 22b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x2d79, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,⊿, */
	/* 22c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22d0 */ 0,0,0,0,0,0,0,0, 0,0,0x2776,0x2777,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,⋚,⋛,0,0,0,0, */
	/* 22e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2300 */ 0,0,0,0,0,0x2248,0x2249,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,⌅,⌆,0, 0,0,0,0,0,0,0,0, */
	/* 2310 */ 0,0,0x225e,0,0,0,0,0, 0x277c,0,0,0,0,0,0,0, /* 0,0,⌒,0,0,0,0,0, ⌘,0,0,0,0,0,0,0, */
	/* 2320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x2742,0x2743, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,⎾,⎿, */
	/* 23c0 */ 0x2744,0x2745,0x2746,0x2747,0x2748,0x2749,0x274a,0x274b, 0x274c,0x274d,0x274e,0x274f,0x2750,0,0x277e,0, /* ⏀,⏁,⏂,⏃,⏄,⏅,⏆,⏇, ⏈,⏉,⏊,⏋,⏌,0,⏎,0, */
	/* 23d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2420 */ 0,0,0,0x277d,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,␣,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2460 */ 0x2d21,0x2d22,0x2d23,0x2d24,0x2d25,0x2d26,0x2d27,0x2d28, 0x2d29,0x2d2a,0x2d2b,0x2d2c,0x2d2d,0x2d2e,0x2d2f,0x2d30, /* ①,②,③,④,⑤,⑥,⑦,⑧, ⑨,⑩,⑪,⑫,⑬,⑭,⑮,⑯, */
	/* 2470 */ 0x2d31,0x2d32,0x2d33,0x2d34,0,0,0,0, 0,0,0,0,0,0,0,0, /* ⑰,⑱,⑲,⑳,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24d0 */ 0x2c41,0x2c42,0x2c43,0x2c44,0x2c45,0x2c46,0x2c47,0x2c48, 0x2c49,0x2c4a,0x2c4b,0x2c4c,0x2c4d,0x2c4e,0x2c4f,0x2c50, /* ⓐ,ⓑ,ⓒ,ⓓ,ⓔ,ⓕ,ⓖ,ⓗ, ⓘ,ⓙ,ⓚ,ⓛ,ⓜ,ⓝ,ⓞ,ⓟ, */
	/* 24e0 */ 0x2c51,0x2c52,0x2c53,0x2c54,0x2c55,0x2c56,0x2c57,0x2c58, 0x2c59,0x2c5a,0,0x2c2b,0x2c2c,0x2c2d,0x2c2e,0x2c2f, /* ⓠ,ⓡ,ⓢ,ⓣ,ⓤ,ⓥ,ⓦ,ⓧ, ⓨ,ⓩ,0,⓫,⓬,⓭,⓮,⓯, */
	/* 24f0 */ 0x2c30,0x2c31,0x2c32,0x2c33,0x2c34,0x265a,0x265b,0x265c, 0x265d,0x265e,0x265f,0x2660,0x2661,0x2662,0x2663,0, /* ⓰,⓱,⓲,⓳,⓴,⓵,⓶,⓷, ⓸,⓹,⓺,⓻,⓼,⓽,⓾,0, */
	/* 2500 */ 0x2821,0x282c,0x2822,0x282d,0,0,0,0, 0,0,0,0,0x2823,0,0,0x282e, /* ─,━,│,┃,0,0,0,0, 0,0,0,0,┌,0,0,┏, */
	/* 2510 */ 0x2824,0,0,0x282f,0x2826,0,0,0x2831, 0x2825,0,0,0x2830,0x2827,0x283c,0,0, /* ┐,0,0,┓,└,0,0,┗, ┘,0,0,┛,├,┝,0,0, */
	/* 2520 */ 0x2837,0,0,0x2832,0x2829,0x283e,0,0, 0x2839,0,0,0x2834,0x2828,0,0,0x2838, /* ┠,0,0,┣,┤,┥,0,0, ┨,0,0,┫,┬,0,0,┯, */
	/* 2530 */ 0x283d,0,0,0x2833,0x282a,0,0,0x283a, 0x283f,0,0,0x2835,0x282b,0,0,0x283b, /* ┰,0,0,┳,┴,0,0,┷, ┸,0,0,┻,┼,0,0,┿, */
	/* 2540 */ 0,0,0x2840,0,0,0,0,0, 0,0,0,0x2836,0,0,0,0, /* 0,0,╂,0,0,0,0,0, 0,0,0,╋,0,0,0,0, */
	/* 2550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25a0 */ 0x2223,0x2222,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* ■,□,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25b0 */ 0,0x266d,0x2225,0x2224,0,0,0x2322,0x2321, 0,0,0,0,0x2227,0x2226,0,0, /* 0,▱,▲,△,0,0,▶,▷, 0,0,0,0,▼,▽,0,0, */
	/* 25c0 */ 0x2324,0x2323,0,0,0,0,0x2221,0x217e, 0,0x233b,0,0x217b,0,0,0x217d,0x217c, /* ◀,◁,0,0,0,0,◆,◇, 0,◉,0,○,0,0,◎,●, */
	/* 25d0 */ 0x2867,0x2868,0x2869,0x286a,0,0,0,0, 0,0,0,0,0,0,0,0, /* ◐,◑,◒,◓,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25e0 */ 0,0,0,0,0,0,0x233f,0, 0,0,0,0,0,0,0,0x227e, /* 0,0,0,0,0,0,◦,0, 0,0,0,0,0,0,0,◯, */
	/* 25f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2600 */ 0x2668,0x2669,0x266a,0x266b,0,0x217a,0x2179,0, 0,0,0,0,0,0,0x2667,0, /* ☀,☁,☂,☃,0,★,☆,0, 0,0,0,0,0,0,☎,0, */
	/* 2610 */ 0,0,0,0,0,0,0x2664,0x2665, 0,0,0,0,0,0,0x2d7e,0, /* 0,0,0,0,0,0,☖,☗, 0,0,0,0,0,0,☞,0, */
	/* 2620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2640 */ 0x216a,0,0x2169,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* ♀,0,♂,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2660 */ 0x263a,0x263d,0x263b,0x2640,0x2639,0x263e,0x263c,0x263f, 0x266c,0x227d,0x2276,0x227b,0x227c,0x2275,0x227a,0x2274, /* ♠,♡,♢,♣,♤,♥,♦,♧, ♨,♩,♪,♫,♬,♭,♮,♯, */
	/* 2670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2710 */ 0,0,0,0x277b,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,✓,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2750 */ 0,0,0,0,0,0,0x2d7d,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,❖,0, 0,0,0,0,0,0,0,0, */
	/* 2760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2770 */ 0,0,0,0,0,0,0x2c21,0x2c22, 0x2c23,0x2c24,0x2c25,0x2c26,0x2c27,0x2c28,0x2c29,0x2c2a, /* 0,0,0,0,0,0,❶,❷, ❸,❹,❺,❻,❼,❽,❾,❿, */
	/* 2780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2930 */ 0,0,0,0,0x232e,0x232f,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,⤴,⤵,0,0, 0,0,0,0,0,0,0,0, */
	/* 2940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x233a, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,⦿, */
	/* 29c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29f0 */ 0,0,0,0,0,0,0,0, 0,0,0x237d,0x237e,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,⧺,⧻,0,0,0,0, */
	/* 2a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3000 */ 0x2121,0x2122,0x2123,0x2137,0,0x2139,0x213a,0x213b, 0x2152,0x2153,0x2154,0x2155,0x2156,0x2157,0x2158,0x2159, /* 　,、,。,〃,0,々,〆,〇, 〈,〉,《,》,「,」,『,』, */
	/* 3010 */ 0x215a,0x215b,0x2229,0x222e,0x214c,0x214d,0x225a,0x225b, 0x2258,0x2259,0,0,0x2141,0x2d60,0,0x2d61, /* 【,】,〒,〓,〔,〕,〖,〗, 〘,〙,0,0,〜,〝,0,〟, */
	/* 3020 */ 0x2666,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 〠,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3030 */ 0,0,0,0x2233,0x2234,0x2235,0,0, 0,0,0,0x2236,0x2237,0x233c,0,0, /* 0,0,0,〳,〴,〵,0,0, 0,0,0,〻,〼,〽,0,0, */
	/* 3040 */ 0,0x2421,0x2422,0x2423,0x2424,0x2425,0x2426,0x2427, 0x2428,0x2429,0x242a,0x242b,0x242c,0x242d,0x242e,0x242f, /* 0,ぁ,あ,ぃ,い,ぅ,う,ぇ, え,ぉ,お,か,が,き,ぎ,く, */
	/* 3050 */ 0x2430,0x2431,0x2432,0x2433,0x2434,0x2435,0x2436,0x2437, 0x2438,0x2439,0x243a,0x243b,0x243c,0x243d,0x243e,0x243f, /* ぐ,け,げ,こ,ご,さ,ざ,し, じ,す,ず,せ,ぜ,そ,ぞ,た, */
	/* 3060 */ 0x2440,0x2441,0x2442,0x2443,0x2444,0x2445,0x2446,0x2447, 0x2448,0x2449,0x244a,0x244b,0x244c,0x244d,0x244e,0x244f, /* だ,ち,ぢ,っ,つ,づ,て,で, と,ど,な,に,ぬ,ね,の,は, */
	/* 3070 */ 0x2450,0x2451,0x2452,0x2453,0x2454,0x2455,0x2456,0x2457, 0x2458,0x2459,0x245a,0x245b,0x245c,0x245d,0x245e,0x245f, /* ば,ぱ,ひ,び,ぴ,ふ,ぶ,ぷ, へ,べ,ぺ,ほ,ぼ,ぽ,ま,み, */
	/* 3080 */ 0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,0x2467, 0x2468,0x2469,0x246a,0x246b,0x246c,0x246d,0x246e,0x246f, /* む,め,も,ゃ,や,ゅ,ゆ,ょ, よ,ら,り,る,れ,ろ,ゎ,わ, */
	/* 3090 */ 0x2470,0x2471,0x2472,0x2473,0x2474,0x2475,0x2476,0, 0,0,0,0x212b,0x212c,0x2135,0x2136,0x2239, /* ゐ,ゑ,を,ん,ゔ,ゕ,ゖ,0, 0,0,0,゛,゜,ゝ,ゞ,ゟ, */
	/* 30a0 */ 0x237b,0x2521,0x2522,0x2523,0x2524,0x2525,0x2526,0x2527, 0x2528,0x2529,0x252a,0x252b,0x252c,0x252d,0x252e,0x252f, /* ゠,ァ,ア,ィ,イ,ゥ,ウ,ェ, エ,ォ,オ,カ,ガ,キ,ギ,ク, */
	/* 30b0 */ 0x2530,0x2531,0x2532,0x2533,0x2534,0x2535,0x2536,0x2537, 0x2538,0x2539,0x253a,0x253b,0x253c,0x253d,0x253e,0x253f, /* グ,ケ,ゲ,コ,ゴ,サ,ザ,シ, ジ,ス,ズ,セ,ゼ,ソ,ゾ,タ, */
	/* 30c0 */ 0x2540,0x2541,0x2542,0x2543,0x2544,0x2545,0x2546,0x2547, 0x2548,0x2549,0x254a,0x254b,0x254c,0x254d,0x254e,0x254f, /* ダ,チ,ヂ,ッ,ツ,ヅ,テ,デ, ト,ド,ナ,ニ,ヌ,ネ,ノ,ハ, */
	/* 30d0 */ 0x2550,0x2551,0x2552,0x2553,0x2554,0x2555,0x2556,0x2557, 0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,0x255f, /* バ,パ,ヒ,ビ,ピ,フ,ブ,プ, ヘ,ベ,ペ,ホ,ボ,ポ,マ,ミ, */
	/* 30e0 */ 0x2560,0x2561,0x2562,0x2563,0x2564,0x2565,0x2566,0x2567, 0x2568,0x2569,0x256a,0x256b,0x256c,0x256d,0x256e,0x256f, /* ム,メ,モ,ャ,ヤ,ュ,ユ,ョ, ヨ,ラ,リ,ル,レ,ロ,ヮ,ワ, */
	/* 30f0 */ 0x2570,0x2571,0x2572,0x2573,0x2574,0x2575,0x2576,0x2772, 0x2773,0x2774,0x2775,0x2126,0x213c,0x2133,0x2134,0x2238, /* ヰ,ヱ,ヲ,ン,ヴ,ヵ,ヶ,ヷ, ヸ,ヹ,ヺ,・,ー,ヽ,ヾ,ヿ, */
	/* 3100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31f0 */ 0x266e,0x266f,0x2670,0x2671,0x2672,0x2673,0x2674,0x2675, 0x2676,0x2677,0x2679,0x267a,0x267b,0x267c,0x267d,0x267e, /* ㇰ,ㇱ,ㇲ,ㇳ,ㇴ,ㇵ,ㇶ,ㇷ, ㇸ,ㇹ,ㇺ,ㇻ,ㇼ,ㇽ,ㇾ,ㇿ, */
	/* 3200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3230 */ 0,0x2d6a,0x2d6b,0,0,0,0,0, 0,0x2d6c,0,0,0,0,0,0, /* 0,㈱,㈲,0,0,0,0,0, 0,㈹,0,0,0,0,0,0, */
	/* 3240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3250 */ 0,0x2841,0x2842,0x2843,0x2844,0x2845,0x2846,0x2847, 0x2848,0x2849,0x284a,0x284b,0x284c,0x284d,0x284e,0x284f, /* 0,㉑,㉒,㉓,㉔,㉕,㉖,㉗, ㉘,㉙,㉚,㉛,㉜,㉝,㉞,㉟, */
	/* 3260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32a0 */ 0,0,0,0,0x2d65,0x2d66,0x2d67,0x2d68, 0x2d69,0,0,0,0,0,0,0, /* 0,0,0,0,㊤,㊥,㊦,㊧, ㊨,0,0,0,0,0,0,0, */
	/* 32b0 */ 0,0x2850,0x2851,0x2852,0x2853,0x2854,0x2855,0x2856, 0x2857,0x2858,0x2859,0x285a,0x285b,0x285c,0x285d,0x285e, /* 0,㊱,㊲,㊳,㊴,㊵,㊶,㊷, ㊸,㊹,㊺,㊻,㊼,㊽,㊾,㊿, */
	/* 32c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32d0 */ 0x2c5b,0x2c5c,0x2c5d,0x2c5e,0x2c5f,0x2c60,0x2c61,0x2c62, 0x2c63,0x2c64,0x2c65,0x2c66,0x2c67,0x2c68,0x2c69,0x2c6a, /* ㋐,㋑,㋒,㋓,㋔,㋕,㋖,㋗, ㋘,㋙,㋚,㋛,㋜,㋝,㋞,㋟, */
	/* 32e0 */ 0x2c6b,0x2c6c,0x2c6d,0x2c6e,0,0x2c71,0,0, 0,0x2c70,0,0,0x2c73,0x2c72,0,0, /* ㋠,㋡,㋢,㋣,0,㋥,0,0, 0,㋩,0,0,㋬,㋭,0,0, */
	/* 32f0 */ 0,0,0,0,0,0,0,0, 0,0,0x2c6f,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,㋺,0,0,0,0,0, */
	/* 3300 */ 0,0,0,0x2d46,0,0,0,0, 0,0,0,0,0,0x2d4a,0,0, /* 0,0,0,㌃,0,0,0,0, 0,0,0,0,0,㌍,0,0, */
	/* 3310 */ 0,0,0,0,0x2d41,0,0,0, 0x2d44,0,0,0,0,0,0,0, /* 0,0,0,0,㌔,0,0,0, ㌘,0,0,0,0,0,0,0, */
	/* 3320 */ 0,0,0x2d42,0x2d4c,0,0,0x2d4b,0x2d45, 0,0,0,0x2d4d,0,0,0,0, /* 0,0,㌢,㌣,0,0,㌦,㌧, 0,0,0,㌫,0,0,0,0, */
	/* 3330 */ 0,0,0,0,0,0,0x2d47,0, 0,0,0,0x2d4f,0,0,0,0, /* 0,0,0,0,0,0,㌶,0, 0,0,0,㌻,0,0,0,0, */
	/* 3340 */ 0,0,0,0,0,0,0,0, 0,0x2d40,0x2d4e,0,0,0x2d43,0,0, /* 0,0,0,0,0,0,0,0, 0,㍉,㍊,0,0,㍍,0,0, */
	/* 3350 */ 0,0x2d48,0,0,0,0,0,0x2d49, 0,0,0,0,0,0,0,0, /* 0,㍑,0,0,0,0,0,㍗, 0,0,0,0,0,0,0,0, */
	/* 3360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3370 */ 0,0,0,0,0,0,0,0, 0,0,0,0x2d5f,0x2d6f,0x2d6e,0x2d6d,0, /* 0,0,0,0,0,0,0,0, 0,0,0,㍻,㍼,㍽,㍾,0, */
	/* 3380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x2d53,0x2d54, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,㎎,㎏, */
	/* 3390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x2d50,0x2d51,0x2d52,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,㎜,㎝,㎞,0, */
	/* 33a0 */ 0,0x2d56,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,㎡,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 33b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33c0 */ 0,0,0,0,0x2d55,0,0,0, 0,0,0,0x235e,0,0x2d63,0,0, /* 0,0,0,0,㏄,0,0,0, 0,0,0,㏋,0,㏍,0,0, */
	/* 33d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3400 */ 0,0,0x2e23,0,0,0,0x212d,0, 0,0,0,0,0,0,0,0, /* 0,0,㐂,0,0,0,㐆,0, 0,0,0,0,0,0,0,0, */
	/* 3410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x2132,0,0x2133,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,㐬,0,㐮,0, */
	/* 3430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3460 */ 0,0,0,0,0,0,0,0, 0x215e,0,0x2156,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 㑨,0,㑪,0,0,0,0,0, */
	/* 3470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3490 */ 0,0,0x217e,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,㒒,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 34a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34b0 */ 0,0,0,0,0,0x2e53,0,0, 0,0,0,0,0x232b,0,0,0, /* 0,0,0,0,0,㒵,0,0, 0,0,0,0,㒼,0,0,0, */
	/* 34c0 */ 0,0x7468,0,0,0,0,0,0x232f, 0,0,0,0,0,0,0,0, /* 0,㓁,0,0,0,0,0,㓇, 0,0,0,0,0,0,0,0, */
	/* 34d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x2e5b,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,㓛,0,0,0,0, */
	/* 34e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x2348, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,㔟, */
	/* 3520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x235d,0x235e,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,㕝,㕞,0, */
	/* 3560 */ 0,0,0,0x2361,0,0,0,0, 0,0,0,0,0,0,0x2367,0, /* 0,0,0,㕣,0,0,0,0, 0,0,0,0,0,0,㕮,0, */
	/* 3570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35a0 */ 0,0,0,0,0,0,0x2423,0, 0x2426,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,㖦,0, 㖨,0,0,0,0,0,0,0, */
	/* 35b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35c0 */ 0,0,0,0,0,0x242f,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,㗅,0,0, 0,0,0,0,0,0,0,0, */
	/* 35d0 */ 0,0,0,0,0,0,0,0, 0,0,0x2438,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,㗚,0,0,0,0,0, */
	/* 35e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35f0 */ 0,0,0,0,0x2442,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,㗴,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3600 */ 0,0,0,0,0,0x244a,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,㘅,0,0, 0,0,0,0,0,0,0,0, */
	/* 3610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3640 */ 0,0,0,0,0,0,0,0, 0,0,0x2479,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,㙊,0,0,0,0,0, */
	/* 3650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3690 */ 0,0x253f,0,0,0,0,0x2543,0, 0,0x2541,0,0,0,0,0,0, /* 0,㚑,0,0,0,0,㚖,0, 0,㚙,0,0,0,0,0,0, */
	/* 36a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x2557, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,㛏, */
	/* 36d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3760 */ 0,0x2823,0x2825,0,0,0,0,0, 0,0,0,0x2829,0x2828,0,0,0, /* 0,㝡,㝢,0,0,0,0,0, 0,0,0,㝫,㝬,0,0,0, */
	/* 3770 */ 0,0,0,0,0,0x282c,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,㝵,0,0, 0,0,0,0,0,0,0,0, */
	/* 3780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x4f5f,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,㞍,0,0, */
	/* 3790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37c0 */ 0,0x283e,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,㟁,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 37d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37e0 */ 0,0,0x4f6f,0,0,0,0,0, 0x2856,0,0,0,0,0,0,0, /* 0,0,㟢,0,0,0,0,0, 㟨,0,0,0,0,0,0,0, */
	/* 37f0 */ 0,0,0,0,0x2859,0,0,0, 0,0,0,0,0,0x285c,0,0, /* 0,0,0,0,㟴,0,0,0, 0,0,0,0,0,㟽,0,0, */
	/* 3800 */ 0x285e,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 㠀,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x286f, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,㠯, */
	/* 3830 */ 0,0,0,0,0,0,0x2871,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,㠶,0, 0,0,0,0,0,0,0,0, */
	/* 3840 */ 0x2874,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 㡀,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x2879,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,㡜,0,0,0, */
	/* 3860 */ 0,0x287b,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,㡡,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38f0 */ 0,0,0,0,0,0,0,0, 0,0,0x2c3b,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,㣺,0,0,0,0,0, */
	/* 3900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3910 */ 0,0,0,0,0,0,0,0x2c46, 0,0,0x2c4a,0,0,0,0,0, /* 0,0,0,0,0,0,0,㤗, 0,0,㤚,0,0,0,0,0, */
	/* 3920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x2c60, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,㥯, */
	/* 3970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x2d5b,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,㩮,0, */
	/* 3a70 */ 0,0,0,0x2d5f,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,㩳,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ad0 */ 0,0,0,0,0,0,0x2d71,0x2e36, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,㫖,㫗, 0,0,0,0,0,0,0,0, */
	/* 3ae0 */ 0,0,0,0,0,0,0,0, 0,0,0x2d7c,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,㫪,0,0,0,0,0, */
	/* 3af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x2e2e,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,㬎,0, */
	/* 3b10 */ 0,0,0,0,0,0,0,0, 0,0,0x2e32,0,0x2e34,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,㬚,0,㬜,0,0,0, */
	/* 3b20 */ 0,0,0x7549,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,㬢,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x2e6d,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,㭭,0,0, */
	/* 3b70 */ 0,0,0,0,0,0,0,0x2e65, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,㭷, 0,0,0,0,0,0,0,0, */
	/* 3b80 */ 0,0,0,0,0,0,0,0x2f28, 0x2f29,0,0,0,0,0x2f2c,0,0, /* 0,0,0,0,0,0,0,㮇, 㮈,0,0,0,0,㮍,0,0, */
	/* 3b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ba0 */ 0,0,0,0,0x2f34,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,㮤,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3bb0 */ 0,0,0,0,0,0,0x757e,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,㮶,0, 0,0,0,0,0,0,0,0, */
	/* 3bc0 */ 0,0,0,0x7621,0,0,0,0, 0,0,0,0,0,0x2f48,0,0, /* 0,0,0,㯃,0,0,0,0, 0,0,0,0,0,㯍,0,0, */
	/* 3bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bf0 */ 0x2f5d,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 㯰,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x763a, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,㰏, */
	/* 3c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c20 */ 0,0,0,0,0,0,0x2f77,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,㰦,0, 0,0,0,0,0,0,0,0, */
	/* 3c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cc0 */ 0,0,0,0x6e3b,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,㳃,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3cd0 */ 0,0,0x6e42,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,㳒,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d10 */ 0,0x6e71,0,0,0,0,0,0, 0,0,0,0,0,0,0x6e7e,0, /* 0,㴑,0,0,0,0,0,0, 0,0,0,0,0,0,㴞,0, */
	/* 3d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d60 */ 0,0,0,0,0x6f40,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,㵤,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d90 */ 0,0,0,0,0,0,0,0, 0,0,0x6f54,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,㶚,0,0,0,0,0, */
	/* 3da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dc0 */ 0x6f70,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 㷀,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3dd0 */ 0,0,0,0,0x6f77,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,㷔,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e00 */ 0,0,0,0,0,0x7028,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,㸅,0,0, 0,0,0,0,0,0,0,0, */
	/* 3e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x7766, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,㸿, */
	/* 3e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e60 */ 0x703f,0,0,0,0,0,0x7041,0, 0x7042,0,0,0,0,0,0,0, /* 㹠,0,0,0,0,0,㹦,0, 㹨,0,0,0,0,0,0,0, */
	/* 3e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e80 */ 0,0,0,0x7049,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,㺃,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3e90 */ 0,0,0,0,0x7050,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,㺔,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f50 */ 0,0,0,0,0,0,0,0x7134, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,㽗, 0,0,0,0,0,0,0,0, */
	/* 3f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f70 */ 0,0,0x784d,0,0,0x7146,0,0x7148, 0,0,0,0,0,0,0,0, /* 0,0,㽲,0,0,㽵,0,㽷, 0,0,0,0,0,0,0,0, */
	/* 3f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x715c,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,㾮,0, */
	/* 3fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fc0 */ 0,0,0,0,0,0,0,0, 0,0x7167,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,㿉,0,0,0,0,0,0, */
	/* 3fd0 */ 0,0,0,0,0,0,0,0x716c, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,㿗, 0,0,0,0,0,0,0,0, */
	/* 3fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4030 */ 0,0,0,0,0,0,0,0, 0,0x7222,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,䀹,0,0,0,0,0,0, */
	/* 4040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4050 */ 0,0,0,0,0,0,0,0, 0x722d,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 䁘,0,0,0,0,0,0,0, */
	/* 4060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4090 */ 0,0,0,0x7239,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,䂓,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 40a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4100 */ 0,0,0,0,0,0x7264,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,䄅,0,0, 0,0,0,0,0,0,0,0, */
	/* 4110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4140 */ 0,0,0,0,0,0,0,0, 0x7274,0,0,0,0,0,0,0x7277, /* 0,0,0,0,0,0,0,0, 䅈,0,0,0,0,0,0,䅏, */
	/* 4150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4160 */ 0,0,0,0x727d,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,䅣,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41b0 */ 0,0,0,0,0x7333,0,0,0, 0,0,0,0,0,0,0,0x7337, /* 0,0,0,0,䆴,0,0,0, 0,0,0,0,0,0,0,䆿, */
	/* 41c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41e0 */ 0,0,0,0,0,0,0x7347,0, 0,0,0,0,0,0,0x734b,0, /* 0,0,0,0,0,0,䇦,0, 0,0,0,0,0,0,䇮,0, */
	/* 41f0 */ 0,0,0,0x7348,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,䇳,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4200 */ 0,0,0,0,0,0,0,0x7353, 0,0,0,0,0,0,0x7357,0, /* 0,0,0,0,0,0,0,䈇, 0,0,0,0,0,0,䈎,0, */
	/* 4210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4260 */ 0,0,0,0,0x796d,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,䉤,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42c0 */ 0,0,0,0,0,0,0x742b,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,䋆,0, 0,0,0,0,0,0,0,0, */
	/* 42d0 */ 0,0,0,0,0,0,0x7436,0, 0,0,0,0,0,0x743b,0,0, /* 0,0,0,0,0,0,䋖,0, 0,0,0,0,0,䋝,0,0, */
	/* 42e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4300 */ 0,0,0x744e,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,䌂,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4320 */ 0,0,0,0,0,0,0,0, 0,0,0,0x745d,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,䌫,0,0,0,0, */
	/* 4330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4340 */ 0,0,0,0x7461,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,䍃,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x753e,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,䏮,0, */
	/* 43f0 */ 0x7542,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 䏰,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4400 */ 0,0,0,0,0,0,0,0, 0x7548,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 䐈,0,0,0,0,0,0,0, */
	/* 4410 */ 0,0,0,0,0,0,0,0x754a, 0,0,0,0,0x754c,0,0,0, /* 0,0,0,0,0,0,0,䐗, 0,0,0,0,䐜,0,0,0, */
	/* 4420 */ 0,0,0x754f,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,䐢,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4450 */ 0,0,0,0x7a59,0,0,0,0, 0,0,0,0x7a5a,0,0,0,0, /* 0,0,0,䑓,0,0,0,0, 0,0,0,䑛,0,0,0,0, */
	/* 4460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4470 */ 0,0,0,0,0,0,0x756c,0, 0,0,0x756e,0,0,0,0,0, /* 0,0,0,0,0,0,䑶,0, 0,0,䑺,0,0,0,0,0, */
	/* 4480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4490 */ 0,0x7577,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,䒑,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 44a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44b0 */ 0,0,0,0x7635,0,0,0,0, 0,0,0,0,0,0,0x7632,0, /* 0,0,0,䒳,0,0,0,0, 0,0,0,0,0,0,䒾,0, */
	/* 44c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44d0 */ 0,0,0,0,0x7634,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,䓔,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 44e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4500 */ 0,0,0,0,0,0,0,0, 0x7659,0,0,0,0,0x7654,0,0, /* 0,0,0,0,0,0,0,0, 䔈,0,0,0,0,䔍,0,0, */
	/* 4510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4520 */ 0,0,0,0,0,0x766d,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,䔥,0,0, 0,0,0,0,0,0,0,0, */
	/* 4530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4540 */ 0,0,0,0x766e,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,䕃,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x7b51,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,䖝,0,0, */
	/* 45a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45b0 */ 0,0,0,0,0,0,0,0, 0x774f,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 䖸,0,0,0,0,0,0,0, */
	/* 45c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45e0 */ 0,0,0,0,0,0x776c,0,0, 0,0,0x7b60,0,0,0,0,0, /* 0,0,0,0,0,䗥,0,0, 0,0,䗪,0,0,0,0,0, */
	/* 45f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x7824, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,䘏, */
	/* 4610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4640 */ 0,0x783a,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,䙁,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4660 */ 0,0,0,0,0,0x7843,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,䙥,0,0, 0,0,0,0,0,0,0,0, */
	/* 4670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46a0 */ 0,0x784e,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x7853, /* 0,䚡,0,0,0,0,0,0, 0,0,0,0,0,0,0,䚯, */
	/* 46b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x786b,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,䜌,0,0,0, */
	/* 4710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4760 */ 0,0,0,0,0x7929,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,䝤,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x793f,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,䟽,0,0, */
	/* 4800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4810 */ 0,0,0,0,0,0,0x7949,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,䠖,0, 0,0,0,0,0,0,0,0, */
	/* 4820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4840 */ 0,0,0,0,0x7c4b,0,0,0, 0,0,0,0,0,0,0x795c,0, /* 0,0,0,0,䡄,0,0,0, 0,0,0,0,0,0,䡎,0, */
	/* 4850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48b0 */ 0,0,0,0,0,0x7a27,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,䢵,0,0, 0,0,0,0,0,0,0,0, */
	/* 48c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49b0 */ 0x7d58,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 䦰,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 49c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49e0 */ 0,0,0,0,0,0,0,0x7b6a, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,䧧, 0,0,0,0,0,0,0,0, */
	/* 49f0 */ 0,0,0,0,0,0,0,0, 0,0,0x7b70,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,䧺,0,0,0,0,0, */
	/* 4a00 */ 0,0,0,0,0x7b75,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,䨄,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a20 */ 0,0,0,0,0,0,0,0, 0,0x7b78,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,䨩,0,0,0,0,0,0, */
	/* 4a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x7c37,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,䪼,0,0,0, */
	/* 4ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0x7c55,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,䬻,0,0,0,0, */
	/* 4b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bc0 */ 0,0,0x7d26,0,0,0,0,0, 0,0,0x7d28,0,0,0,0,0, /* 0,0,䯂,0,0,0,0,0, 0,0,䯊,0,0,0,0,0, */
	/* 4bd0 */ 0,0,0x7d2a,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,䯒,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4be0 */ 0,0,0,0,0,0,0,0, 0x7d31,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 䯨,0,0,0,0,0,0,0, */
	/* 4bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c10 */ 0,0,0,0,0,0,0,0x7e3e, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,䰗, 0,0,0,0,0,0,0,0, */
	/* 4c20 */ 0x7d3f,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 䰠,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cc0 */ 0,0,0,0,0x7e2a,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,䳄,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4cd0 */ 0,0x7e2d,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,䳑,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d00 */ 0,0,0,0,0,0,0,0x7e4b, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,䴇, 0,0,0,0,0,0,0,0, */
	/* 4d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d70 */ 0,0,0,0,0,0,0,0x7e60, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,䵷, 0,0,0,0,0,0,0,0, */
	/* 4d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e00 */ 0x306c,0x437a,0x2122,0x3c37,0,0,0,0x4b7c, 0x3e66,0x3b30,0x3e65,0x323c,0,0x4954,0x4d3f,0x2123, /* 一,丁,丂,七,0,0,0,万, 丈,三,上,下,0,不,与,丏, */
	/* 4e10 */ 0x5022,0x312f,0x2124,0,0x336e,0x5023,0x4024,0x5242, 0x3556,0x4a3a,0,0,0,0,0x3e67,0, /* 丐,丑,丒,0,且,丕,世,丗, 丘,丙,0,0,0,0,丞,0, */
	/* 4e20 */ 0,0x4e3e,0,0,0,0,0x4a42,0, 0x2e24,0x2125,0x5024,0x2126,0x702e,0x4366,0x2127,0x2e25, /* 0,両,0,0,0,0,並,0, 丨,丩,个,丫,丬,中,丮,丯, */
	/* 4e30 */ 0x2e26,0x5025,0x367a,0,0,0,0x5026,0, 0x345d,0x4330,0,0x3c67,0x5027,0,0,0x5028, /* 丰,丱,串,0,0,0,丶,0, 丸,丹,0,主,丼,0,0,丿, */
	/* 4e40 */ 0x2128,0,0x5029,0x4735,0,0x3557,0,0x2129, 0x212a,0,0,0x4737,0,0x4663,0x3843,0x4b33, /* 乀,0,乂,乃,0,久,0,乇, 么,0,0,之,0,乍,乎,乏, */
	/* 4e50 */ 0,0x212c,0,0,0,0x6949,0x502a,0x3e68, 0x502b,0x3235,0x212f,0,0,0x3665,0x3870,0x4c69, /* 0,乑,0,0,0,乕,乖,乗, 乘,乙,乚,0,0,九,乞,也, */
	/* 4e60 */ 0,0,0x5626,0,0,0,0,0, 0,0x2130,0,0,0,0,0,0, /* 0,0,乢,0,0,0,0,0, 0,乩,0,0,0,0,0,0, */
	/* 4e70 */ 0,0x4d70,0,0x467d,0,0,0,0, 0,0,0,0,0,0,0x3425,0, /* 0,乱,0,乳,0,0,0,0, 0,0,0,0,0,0,乾,0, */
	/* 4e80 */ 0x3535,0,0x502c,0,0,0x502d,0x4e3b,0, 0x4d3d,0x4168,0x502f,0x3b76,0x4673,0x2e27,0x5032,0, /* 亀,0,亂,0,0,亅,了,0, 予,争,亊,事,二,亍,于,0, */
	/* 4e90 */ 0,0x313e,0x385f,0,0x385e,0x3066,0,0, 0x4f4b,0x4f4a,0,0x3a33,0x3021,0x2131,0x5033,0x5034, /* 0,云,互,0,五,井,0,0, 亘,亙,0,些,亜,亝,亞,亟, */
	/* 4ea0 */ 0x5035,0x4b34,0x5036,0,0x3872,0x3067,0x4b72,0, 0x357c,0,0,0x357d,0x357e,0x4462,0x4e3c,0, /* 亠,亡,亢,0,交,亥,亦,0, 亨,0,0,享,京,亭,亮,0, */
	/* 4eb0 */ 0x5037,0,0,0x5038,0,0,0x5039,0, 0,0x2134,0x3f4d,0x2135,0x2137,0,0,0, /* 亰,0,0,亳,0,0,亶,0, 0,亹,人,亻,亼,0,0,0, */
	/* 4ec0 */ 0x3d3a,0x3f4e,0x503e,0x2138,0x503c,0,0x503d,0x3558, 0x2139,0,0x3a23,0x3270,0,0x503b,0x503a,0x4a29, /* 什,仁,仂,仃,仄,0,仆,仇, 仈,0,今,介,0,仍,从,仏, */
	/* 4ed0 */ 0x213a,0,0,0,0x3b46,0x3b45,0x423e,0x503f, 0x4955,0x4067,0x213c,0,0,0x2138,0x5040,0x5042, /* 仐,0,0,0,仔,仕,他,仗, 付,仙,仚,0,0,仝,仞,仟, */
	/* 4ee0 */ 0,0x2e28,0,0x4265,0x4e61,0x304a,0,0, 0,0,0,0x213b,0,0x5041,0x323e,0, /* 0,仡,0,代,令,以,0,0, 0,0,0,仫,0,仭,仮,0, */
	/* 4ef0 */ 0x3644,0x213d,0x4367,0,0,0x213e,0x376f,0x5043, 0,0,0,0x4724,0,0x2e29,0,0x2e2a, /* 仰,仱,仲,0,0,仵,件,价, 0,0,0,任,0,份,0,仿, */
	/* 4f00 */ 0x213f,0x346b,0,0x2e2b,0,0,0,0, 0,0x5044,0x304b,0x2e2c,0,0x3860,0x346c,0x497a, /* 伀,企,0,伃,0,0,0,0, 0,伉,伊,伋,0,伍,伎,伏, */
	/* 4f10 */ 0x4832,0x3559,0,0,0,0,0x2140,0, 0,0,0x3271,0,0x5067,0x4541,0,0, /* 伐,休,0,0,0,0,伖,0, 0,0,会,0,伜,伝,0,0, */
	/* 4f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x476c, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,伯, */
	/* 4f30 */ 0x5046,0,0,0,0x483c,0,0x4e62,0x2142, 0x3f2d,0,0x3b47,0,0x3b77,0x3240,0x2143,0, /* 估,0,0,0,伴,0,伶,伷, 伸,0,伺,0,似,伽,伾,0, */
	/* 4f40 */ 0,0,0,0x4451,0,0,0x4322,0x504a, 0x2e2e,0x2e2f,0,0,0,0x304c,0x4463,0x3d3b, /* 0,0,0,佃,0,0,但,佇, 佈,佉,0,0,0,位,低,住, */
	/* 4f50 */ 0x3a34,0x4d24,0,0x424e,0x2144,0x323f,0x2e30,0x5049, 0x2145,0x4d3e,0x5045,0x5047,0x3a6e,0x5048,0x5524,0x2e31, /* 佐,佑,0,体,佔,何,佖,佗, 佘,余,佚,佛,作,佝,佞,佟, */
	/* 4f60 */ 0x2e2d,0,0,0,0x2141,0,0,0, 0,0x5050,0x2e32,0,0x2e33,0,0,0x5053, /* 你,0,0,0,佤,0,0,0, 0,佩,佪,0,佬,0,0,佯, */
	/* 4f70 */ 0x5051,0,0,0x3242,0,0x4a3b,0x504b,0x2147, 0x2148,0,0x2149,0x504f,0x3873,0x214a,0x2e34,0x3b48, /* 佰,0,0,佳,0,併,佶,佷, 佸,0,佺,佻,佼,佽,佾,使, */
	/* 4f80 */ 0,0,0x214b,0x3426,0,0x214c,0x5054,0, 0x504c,0,0x2e35,0x4e63,0,0x3b78,0,0x504d, /* 0,0,侂,侃,0,侅,來,0, 侈,0,侊,例,0,侍,0,侏, */
	/* 4f90 */ 0,0x5052,0x214d,0,0x2e36,0,0x5055,0x2e37, 0x504e,0,0x214e,0x3621,0,0x304d,0,0, /* 0,侑,侒,0,侔,0,侖,侗, 侘,0,侚,供,0,依,0,0, */
	/* 4fa0 */ 0x3622,0x3241,0,0,0,0,0,0, 0,0,0,0x5525,0,0x4b79,0x496e,0x3874, /* 侠,価,0,0,0,0,0,0, 0,0,0,侫,0,侭,侮,侯, */
	/* 4fb0 */ 0,0,0x2150,0,0,0x3f2f,0x4e37,0, 0,0,0,0,0,0,0x2151,0x4a58, /* 0,0,侲,0,0,侵,侶,0, 0,0,0,0,0,0,侾,便, */
	/* 4fc0 */ 0,0,0x3738,0x4225,0x3264,0x2152,0,0, 0,0x2e39,0x3d53,0x2153,0,0,0x5059,0x2154, /* 0,0,係,促,俄,俅,0,0, 0,俉,俊,俋,0,0,俎,俏, */
	/* 4fd0 */ 0x505e,0x505c,0x2155,0,0x5057,0,0,0x422f, 0x505a,0,0x505d,0x505b,0,0x4a5d,0,0x5058, /* 俐,俑,俒,0,俔,0,0,俗, 俘,0,俚,俛,0,保,0,俟, */
	/* 4fe0 */ 0x2e3a,0x3f2e,0,0x4b73,0x505f,0x5060,0x214f,0, 0,0,0,0,0,0,0x3d24,0x506d, /* 俠,信,0,俣,俤,俥,俦,0, 0,0,0,0,0,0,修,俯, */
	/* 4ff0 */ 0,0x2e21,0x2157,0x4750,0,0x4936,0x5068,0, 0x4a70,0,0x3236,0,0,0,0x506c,0, /* 0,俱,俲,俳,0,俵,俶,0, 俸,0,俺,0,0,0,俾,0, */
	/* 5000 */ 0x2158,0x2e3b,0x2e3c,0,0,0x5066,0x506f,0, 0,0x4152,0,0x3844,0,0x475c,0x2e3d,0x6047, /* 倀,倁,倂,0,0,倅,倆,0, 0,倉,0,個,0,倍,倎,倏, */
	/* 5010 */ 0x2159,0x506e,0x455d,0x215a,0x5063,0,0x3876,0, 0x2e3e,0x3875,0x5061,0,0x215b,0,0x215c,0x3c5a, /* 倐,們,倒,倓,倔,0,倖,0, 倘,候,倚,0,倜,0,倞,借, */
	/* 5020 */ 0,0x5069,0x215d,0x4a6f,0x434d,0x5065,0x3771,0x2e3f, 0x5062,0x506a,0x5064,0x4e51,0x506b,0x4f41,0x2e40,0, /* 0,倡,倢,倣,値,倥,倦,倧, 倨,倩,倪,倫,倬,倭,倮,0, */
	/* 5030 */ 0,0,0,0,0,0,0x3666,0, 0,0x3770,0,0x2e42,0,0,0,0, /* 0,0,0,0,0,0,倶,0, 0,倹,0,倻,0,0,0,0, */
	/* 5040 */ 0x2e41,0x2e43,0x215f,0x5070,0,0,0x2160,0x5071, 0x5075,0x304e,0,0,0,0,0x2161,0x4a50, /* 偀,偁,偂,偃,0,0,偆,假, 偈,偉,0,0,0,0,偎,偏, */
	/* 5050 */ 0x5074,0,0,0x2162,0,0x5073,0x5077,0x2163, 0,0,0x5076,0,0x4464,0,0,0, /* 偐,0,0,偓,0,偕,偖,偗, 0,0,做,0,停,0,0,0, */
	/* 5060 */ 0,0,0,0x2164,0,0x3772,0x2165,0, 0,0,0x2166,0,0x5078,0,0,0, /* 0,0,0,偣,0,健,偦,0, 0,0,偪,0,偬,0,0,0, */
	/* 5070 */ 0x2167,0,0x3c45,0,0x4226,0x4465,0x3676,0, 0x5079,0,0,0,0,0x3536,0,0, /* 偰,0,偲,0,側,偵,偶,0, 偸,0,0,0,0,偽,0,0, */
	/* 5080 */ 0x507a,0,0,0,0,0x507c,0,0, 0x2169,0,0,0,0,0x4b35,0,0, /* 傀,0,0,0,0,傅,0,0, 傈,0,0,0,0,傍,0,0, */
	/* 5090 */ 0,0x3766,0x216a,0x216b,0x2e44,0x216c,0x216d,0, 0x3b31,0x4877,0x507b,0,0x216e,0,0,0, /* 0,傑,傒,傓,傔,傕,傖,0, 傘,備,傚,0,傜,0,0,0, */
	/* 50a0 */ 0,0,0,0x2168,0,0,0,0, 0,0,0x216f,0,0x3a45,0x4d43,0,0, /* 0,0,0,傣,0,0,0,0, 0,0,傪,0,催,傭,0,0, */
	/* 50b0 */ 0,0x2171,0x507e,0x5123,0x507d,0x3a44,0,0x3d7d, 0,0,0x2172,0x2173,0,0,0x3739,0, /* 0,傱,傲,傳,傴,債,0,傷, 0,0,傺,傻,0,0,傾,0, */
	/* 50c0 */ 0,0,0x5124,0,0x2174,0x364f,0,0x2175, 0,0x5121,0x5122,0,0x2e45,0x462f,0x2178,0x417c, /* 0,0,僂,0,僄,僅,0,僇, 0,僉,僊,0,僌,働,僎,像, */
	/* 50d0 */ 0x2e47,0x3623,0,0,0x217a,0x4b4d,0x5125,0, 0,0x217b,0x4e3d,0,0,0,0x5126,0, /* 僐,僑,0,0,僔,僕,僖,0, 0,僙,僚,0,0,0,僞,0, */
	/* 50e0 */ 0,0x217c,0,0x5129,0,0x5127,0x2e48,0x414e, 0,0x217d,0,0,0,0x5128,0x512a,0, /* 0,僡,0,僣,0,僥,僦,僧, 0,僩,0,0,0,僭,僮,0, */
	/* 50f0 */ 0,0,0x2e46,0x2176,0,0x512c,0,0, 0,0x512b,0,0x4a48,0,0,0,0, /* 0,0,僲,僳,0,僵,0,0, 0,價,0,僻,0,0,0,0, */
	/* 5100 */ 0x3537,0x512e,0x512f,0x2e4b,0x322f,0,0x2e4a,0, 0x2321,0x512d,0,0x2e4c,0,0,0,0, /* 儀,儁,儂,儃,億,0,儆,0, 儈,儉,0,儋,0,0,0,0, */
	/* 5110 */ 0,0,0x3c74,0,0x5132,0x5131,0x5130,0x2323, 0x5056,0,0x5133,0x2324,0,0,0x2e4d,0x3d7e, /* 0,0,儒,0,儔,儕,儖,儗, 儘,0,儚,儛,0,0,儞,償, */
	/* 5120 */ 0,0x5134,0,0,0,0,0,0, 0,0,0x4d25,0,0,0,0,0, /* 0,儡,0,0,0,0,0,0, 0,0,優,0,0,0,0,0, */
	/* 5130 */ 0,0,0x4c59,0,0,0x2e4e,0,0x5136, 0,0,0x5135,0x5138,0x5137,0,0,0x5139, /* 0,0,儲,0,0,儵,0,儷, 0,0,儺,儻,儼,0,0,儿, */
	/* 5140 */ 0x513a,0x3074,0,0x3835,0x373b,0x3d3c,0x437b,0x3624, 0x4068,0x3877,0x2e4f,0x396e,0x513c,0x4c48,0x4546,0, /* 兀,允,0,元,兄,充,兆,兇, 先,光,兊,克,兌,免,兎,0, */
	/* 5150 */ 0x3b79,0,0x513b,0,0x513d,0x2e51,0,0x2e52, 0,0,0x455e,0,0x3375,0,0,0, /* 児,0,兒,0,兔,兕,0,兗, 0,0,党,0,兜,0,0,0, */
	/* 5160 */ 0x2326,0,0x513e,0,0,0x467e,0,0, 0x4134,0x5140,0x5141,0x482c,0x3878,0x4f3b,0x5142,0, /* 兠,0,兢,0,0,入,0,0, 全,兩,兪,八,公,六,兮,0, */
	/* 5170 */ 0,0x3626,0,0x2328,0,0x4a3c,0x4236,0x3671, 0x4535,0,0,0x7474,0x3773,0,0,0, /* 0,共,0,关,0,兵,其,具, 典,0,0,养,兼,0,0,0, */
	/* 5180 */ 0x5143,0,0x5144,0x2329,0,0x4662,0x315f,0, 0,0x5147,0x3a7d,0x232a,0x5146,0x3a46,0,0x5148, /* 冀,0,冂,冃,0,内,円,0, 0,冉,冊,冋,册,再,0,冏, */
	/* 5190 */ 0x666e,0x5149,0x4b41,0x514a,0,0x514b,0x514c,0x3e69, 0x232c,0x3c4c,0,0,0,0x2e54,0,0, /* 冐,冑,冒,冓,0,冕,冖,冗, 冘,写,0,0,0,冝,0,0, */
	/* 51a0 */ 0x3427,0,0x514f,0x232d,0x514d,0x4c3d,0x514e,0, 0x495a,0x5150,0x5151,0x5152,0x455f,0x232e,0,0, /* 冠,0,冢,冣,冤,冥,冦,0, 冨,冩,冪,冫,冬,冭,0,0, */
	/* 51b0 */ 0x5156,0x5154,0x5155,0x5153,0x3a63,0x5157,0x4c6a,0x4e64, 0,0,0,0,0x2330,0x5158,0,0, /* 冰,冱,冲,决,冴,况,冶,冷, 0,0,0,0,冼,冽,0,0, */
	/* 51c0 */ 0,0,0,0x2e55,0x4028,0x5159,0x3d5a,0, 0,0x515a,0x2e56,0x437c,0x4e3f,0x4560,0,0, /* 0,0,0,凃,凄,凅,准,0, 0,凉,凊,凋,凌,凍,0,0, */
	/* 51d0 */ 0,0,0,0,0,0,0x5245,0, 0,0,0,0x515b,0x7425,0x3645,0x2e57,0, /* 0,0,0,0,0,0,凖,0, 0,0,0,凛,凜,凝,凞,0, */
	/* 51e0 */ 0x515c,0x4b5e,0x2e58,0,0,0,0x3d68,0x427c, 0,0x515e,0x4664,0,0,0x515f,0x2e59,0, /* 几,凡,凢,0,0,0,処,凧, 0,凩,凪,0,0,凭,凮,0, */
	/* 51f0 */ 0x5160,0x332e,0,0x2333,0x2334,0x5161,0x3627,0, 0x464c,0x317a,0x3d50,0,0,0x4821,0x5162,0, /* 凰,凱,0,凳,凴,凵,凶,0, 凸,凹,出,0,0,函,凾,0, */
	/* 5200 */ 0x4561,0x2e5a,0x2335,0x3f4f,0x5163,0,0x4a2c,0x405a, 0x3422,0,0x3429,0x5164,0,0,0x5166,0, /* 刀,刁,刂,刃,刄,0,分,切, 刈,0,刊,刋,0,0,刎,0, */
	/* 5210 */ 0,0x373a,0x2336,0x2e5c,0x5165,0x2e5d,0x2337,0x4e73, 0,0,0,0,0,0x3d69,0,0, /* 0,刑,划,刓,刔,刕,刖,列, 0,0,0,0,0,初,0,0, */
	/* 5220 */ 0,0,0,0,0x483d,0x4a4c,0,0x5167, 0,0x4d78,0x5168,0,0,0,0x5169,0, /* 0,0,0,0,判,別,0,刧, 0,利,刪,0,0,0,刮,0, */
	/* 5230 */ 0x457e,0,0,0x516a,0,0,0x4029,0x3a7e, 0x3774,0x516b,0x3b49,0x396f,0,0,0,0, /* 到,0,0,刳,0,0,制,刷, 券,刹,刺,刻,0,0,0,0, */
	/* 5240 */ 0,0,0,0x4466,0x516d,0,0,0x4227, 0,0x2e5e,0x3a6f,0x516e,0x516f,0x4130,0,0x516c, /* 0,0,0,剃,剄,0,0,則, 0,剉,削,剋,剌,前,0,剏, */
	/* 5250 */ 0,0,0,0,0x5171,0x2339,0x4b36,0x2e5f, 0,0,0,0x3964,0x233a,0x2f7e,0x5170,0, /* 0,0,0,0,剔,剕,剖,剗, 0,0,0,剛,剜,剝,剞,0, */
	/* 5260 */ 0,0x2e60,0,0x3775,0x3a5e,0x476d,0,0, 0,0x5174,0x5172,0,0x233b,0,0,0x497b, /* 0,剡,0,剣,剤,剥,0,0, 0,剩,剪,0,剬,0,0,副, */
	/* 5270 */ 0x3e6a,0x517b,0x3364,0x5175,0x5173,0x414f,0,0x233c, 0,0,0,0,0,0x5177,0,0x5176, /* 剰,剱,割,剳,剴,創,0,剷, 0,0,0,0,0,剽,0,剿, */
	/* 5280 */ 0,0,0x233e,0x3344,0x233d,0,0,0x3760, 0x517c,0x4e2d,0,0,0,0x5178,0,0, /* 0,0,劂,劃,劄,0,0,劇, 劈,劉,0,0,0,劍,0,0, */
	/* 5290 */ 0,0x517d,0x517a,0x2e61,0x5179,0,0,0, 0x2340,0,0,0x4e4f,0,0,0,0x3879, /* 0,劑,劒,劓,劔,0,0,0, 劘,0,0,力,0,0,0,功, */
	/* 52a0 */ 0x3243,0,0,0x4e74,0x2342,0,0x2343,0, 0,0x3d75,0x4558,0x3965,0x5222,0x5223,0,0x2344, /* 加,0,0,劣,劤,0,劦,0, 0,助,努,劫,劬,劭,0,劯, */
	/* 52b0 */ 0,0x4e65,0,0,0x4f2b,0x5225,0,0, 0,0x387a,0x2345,0x2346,0x5224,0,0x332f,0, /* 0,励,0,0,労,劵,0,0, 0,効,劺,劻,劼,0,劾,0, */
	/* 52c0 */ 0,0x5226,0,0x4b56,0,0x443c,0,0x4d26, 0x2e62,0x4a59,0x2347,0,0x2e64,0x5227,0,0, /* 0,勁,0,勃,0,勅,0,勇, 勈,勉,勊,0,勌,勍,0,0, */
	/* 52d0 */ 0x2e65,0x2349,0x7055,0,0,0x4630,0x2e66,0x5228, 0x342a,0x4c33,0,0x2e67,0,0x3e21,0x5229,0x4a67, /* 勐,勑,勒,0,0,動,勖,勗, 勘,務,0,勛,0,勝,勞,募, */
	/* 52e0 */ 0x522d,0,0x402a,0x522a,0x3650,0,0x522b,0x342b, 0,0,0,0,0,0,0,0, /* 勠,0,勢,勣,勤,0,勦,勧, 0,0,0,0,0,0,0,0, */
	/* 52f0 */ 0x2e69,0,0x372e,0x522e,0,0x522f,0,0x234b, 0x5230,0x5231,0x3c5b,0x2e6a,0,0,0x387b,0x4c5e, /* 勰,0,勲,勳,0,勵,0,勷, 勸,勹,勺,勻,0,0,勾,勿, */
	/* 5300 */ 0x2e6b,0x4c68,0x4677,0,0,0x4a71,0x5232,0x2e6c, 0x5233,0,0x234c,0x234d,0,0x5235,0,0x5237, /* 匀,匁,匂,0,0,包,匆,匇, 匈,0,匊,匋,0,匍,0,匏, */
	/* 5310 */ 0x5236,0,0,0,0,0x5238,0x323d,0x4b4c, 0,0x3a7c,0x5239,0,0x2e6d,0x4159,0,0, /* 匐,0,0,0,0,匕,化,北, 0,匙,匚,0,匜,匝,0,0, */
	/* 5320 */ 0x3e22,0x3629,0,0x523a,0x234e,0,0,0, 0,0,0x485b,0,0,0,0,0x523b, /* 匠,匡,0,匣,匤,0,0,0, 0,0,匪,0,0,0,0,匯, */
	/* 5330 */ 0,0x523c,0,0x523d,0,0x234f,0,0, 0x523e,0x4924,0x3668,0x3065,0,0,0x2350,0x463f, /* 0,匱,0,匳,0,匵,0,0, 匸,匹,区,医,0,0,匾,匿, */
	/* 5340 */ 0x523f,0x3d3d,0x2351,0x4069,0,0x5241,0x5240,0x3e23, 0x3861,0x5243,0x483e,0,0,0x5244,0,0, /* 區,十,卂,千,0,卅,卆,升, 午,卉,半,0,0,卍,0,0, */
	/* 5350 */ 0,0x485c,0x4234,0x426e,0x3628,0,0,0x466e, 0x4331,0,0x476e,0,0x4b4e,0,0x5246,0, /* 0,卑,卒,卓,協,0,0,南, 単,0,博,0,卜,0,卞,0, */
	/* 5360 */ 0x406a,0x2e6f,0,0x2e70,0,0,0x3735,0x2354, 0,0x5247,0,0,0x2355,0,0x5248,0x312c, /* 占,卡,0,卣,0,0,卦,卧, 0,卩,0,0,卬,0,卮,卯, */
	/* 5370 */ 0x3075,0x346d,0,0x4228,0x3551,0x4d71,0,0x524b, 0x3237,0,0x2356,0x524a,0,0x2e71,0,0x362a, /* 印,危,0,即,却,卵,0,卷, 卸,0,卺,卻,0,卽,0,卿, */
	/* 5380 */ 0,0,0x524c,0,0x4c71,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,厂,0,厄,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5390 */ 0,0,0,0x2e72,0,0,0x524d,0, 0x4e52,0,0x387c,0,0,0x2e73,0,0x3836, /* 0,0,0,厓,0,0,厖,0, 厘,0,厚,0,0,厝,0,原, */
	/* 53a0 */ 0x524e,0,0,0,0x2357,0x5250,0x524f,0, 0x3f5f,0x3139,0,0,0,0x315e,0x5251,0, /* 厠,0,0,0,厤,厥,厦,0, 厨,厩,0,0,0,厭,厮,0, */
	/* 53b0 */ 0x5252,0,0x2e74,0x3837,0x2358,0,0x5253,0x235a, 0,0,0,0x356e,0,0,0,0, /* 厰,0,厲,厳,厴,0,厶,厷, 0,0,0,去,0,0,0,0, */
	/* 53c0 */ 0x235b,0,0x3b32,0x5254,0,0,0,0, 0x4b74,0x3a35,0x355a,0x4d27,0x4150,0x483f,0x3c7d,0, /* 叀,0,参,參,0,0,0,0, 又,叉,及,友,双,反,収,0, */
	/* 53d0 */ 0,0,0,0,0x3d47,0x235f,0x3c68,0x3c75, 0,0x3d76,0x2360,0x4840,0,0,0,0x5257, /* 0,0,0,0,叔,叕,取,受, 0,叙,叚,叛,0,0,0,叟, */
	/* 53e0 */ 0,0x3143,0x4151,0x387d,0x3845,0x3667,0,0, 0x525b,0x4321,0x427e,0x362b,0x3e24,0x525c,0x525a,0x3244, /* 0,叡,叢,口,古,句,0,0, 叨,叩,只,叫,召,叭,叮,可, */
	/* 53f0 */ 0x4266,0x3c38,0x3b4b,0x3126,0x2362,0x2363,0x3370,0x3966, 0x3b4a,0,0x525d,0,0,0,0,0, /* 台,叱,史,右,叴,叵,叶,号, 司,0,叺,0,0,0,0,0, */
	/* 5400 */ 0,0x525e,0,0x3549,0x3346,0,0,0, 0x3967,0x3548,0x445f,0x3125,0x4631,0x4c3e,0x3921,0x4d79, /* 0,吁,0,吃,各,0,0,0, 合,吉,吊,吋,同,名,后,吏, */
	/* 5410 */ 0x4547,0x387e,0x2e75,0,0,0,0,0, 0,0,0,0x372f,0,0x5267,0x4f7e,0x3663, /* 吐,向,吒,0,0,0,0,0, 0,0,0,君,0,吝,吞,吟, */
	/* 5420 */ 0x4b4a,0,0,0,0x2365,0,0x485d,0x2e76, 0x2366,0x5266,0,0x345e,0x5261,0x5262,0x5264,0, /* 吠,0,0,0,吤,0,否,吧, 吨,吩,0,含,听,吭,吮,0, */
	/* 5430 */ 0,0,0,0,0,0,0x5265,0, 0x355b,0x3f61,0,0x4a2d,0x5263,0x525f,0x3863,0, /* 0,0,0,0,0,0,吶,0, 吸,吹,0,吻,吼,吽,吾,0, */
	/* 5440 */ 0x5260,0,0x4f24,0x2368,0,0,0x4a72,0, 0x4468,0x3862,0x3970,0,0,0x2e77,0x5268,0, /* 呀,0,呂,呃,0,0,呆,0, 呈,呉,告,0,0,呍,呎,0, */
	/* 5450 */ 0,0x465d,0,0,0,0x2364,0,0, 0,0,0,0,0,0,0,0x526c, /* 0,呑,0,0,0,呕,0,0, 0,0,0,0,0,0,0,呟, */
	/* 5460 */ 0,0,0x2369,0,0,0,0x236a,0, 0x3c7e,0,0x3c76,0x2e79,0x236b,0,0,0, /* 0,0,呢,0,0,0,呦,0, 周,0,呪,呫,呬,0,0,0, */
	/* 5470 */ 0x526f,0x526d,0,0x4c23,0x2e7a,0x526a,0x5273,0x526e, 0,0,0,0x5271,0x3846,0x4c3f,0,0x2e7b, /* 呰,呱,0,味,呴,呵,呶,呷, 0,0,0,呻,呼,命,0,呿, */
	/* 5480 */ 0x5272,0,0,0,0x5274,0,0x5276,0, 0x2e7c,0,0x236c,0x3a70,0x4f42,0x236d,0x526b,0x5269, /* 咀,0,0,0,咄,0,咆,0, 咈,0,咊,咋,和,咍,咎,咏, */
	/* 5490 */ 0x5275,0,0x5270,0,0,0x236e,0x2e7d,0, 0,0,0,0,0x2e78,0,0,0, /* 咐,0,咒,0,0,咕,咖,0, 0,0,0,0,咜,0,0,0, */
	/* 54a0 */ 0x236f,0x2e7e,0x5278,0,0x5323,0x527a,0x2370,0, 0x527e,0x2f21,0,0x5321,0x527b,0x2371,0x2372,0x533e, /* 咠,咡,咢,0,咤,咥,咦,0, 咨,咩,0,咫,咬,咭,咮,咯, */
	/* 54b0 */ 0,0,0x3a69,0x3331,0,0,0,0x2373, 0x5279,0,0x2374,0,0x5325,0x3076,0x5324,0x2375, /* 0,0,咲,咳,0,0,0,咷, 咸,0,咺,0,咼,咽,咾,咿, */
	/* 54c0 */ 0x3025,0x494a,0x5322,0x2376,0x527c,0,0x2f22,0x5277, 0x527d,0x3a48,0,0,0,0,0,0, /* 哀,品,哂,哃,哄,0,哆,哇, 哈,哉,0,0,0,0,0,0, */
	/* 54d0 */ 0,0,0,0,0,0,0,0, 0x5326,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 哘,0,0,0,0,0,0,0, */
	/* 54e0 */ 0,0x3077,0x532f,0,0,0x5327,0x5328,0, 0x3e25,0x4b69,0,0,0x2378,0x532d,0x532c,0x2379, /* 0,員,哢,0,0,哥,哦,0, 哨,哩,0,0,哬,哭,哮,哯, */
	/* 54f0 */ 0,0x237a,0x452f,0x237b,0,0,0,0, 0,0,0x532e,0,0,0x532b,0,0x2f23, /* 0,哱,哲,哳,0,0,0,0, 0,0,哺,0,0,哽,0,哿, */
	/* 5500 */ 0x237c,0x237d,0,0,0x3134,0,0x3a36,0x3f30, 0,0x237e,0,0,0,0,0x2f24,0x5329, /* 唀,唁,0,0,唄,0,唆,唇, 0,唉,0,0,0,0,唎,唏, */
	/* 5510 */ 0x4562,0,0,0,0x532a,0,0x3022,0, 0,0,0,0,0,0,0,0, /* 唐,0,0,0,唔,0,唖,0, 0,0,0,0,0,0,0,0, */
	/* 5520 */ 0,0,0,0,0,0,0,0, 0,0,0,0x2f25,0,0,0x5334,0x4d23, /* 0,0,0,0,0,0,0,0, 0,0,0,唫,0,0,售,唯, */
	/* 5530 */ 0,0x3e27,0,0x533a,0,0x2f26,0,0, 0x5339,0x5330,0,0,0x2421,0,0x4243,0, /* 0,唱,0,唳,0,唵,0,0, 唸,唹,0,0,唼,0,唾,0, */
	/* 5540 */ 0x5331,0x2422,0,0,0x426f,0x5336,0x3e26,0x2424, 0,0,0x2425,0,0x5333,0,0,0x4c64, /* 啀,啁,0,0,啄,啅,商,啇, 0,0,啊,0,啌,0,0,問, */
	/* 5550 */ 0x2f27,0,0,0x373c,0,0,0x5337,0x5338, 0,0,0,0,0x5335,0x533b,0x2f28,0, /* 啐,0,0,啓,0,0,啖,啗, 0,0,0,0,啜,啝,啞,0, */
	/* 5560 */ 0x2427,0x2428,0,0x5332,0x2429,0,0,0, 0,0,0,0,0,0,0,0, /* 啠,啡,0,啣,啤,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5570 */ 0,0,0,0,0,0,0,0, 0,0,0,0x5341,0x5346,0x242b,0x5342,0, /* 0,0,0,0,0,0,0,0, 0,0,0,啻,啼,啽,啾,0, */
	/* 5580 */ 0x533d,0x2f29,0x242c,0x5347,0x4131,0,0x2f2a,0x5349, 0x242d,0x3922,0x533f,0x437d,0,0,0x2f2b,0, /* 喀,喁,喂,喃,善,0,喆,喇, 喈,喉,喊,喋,0,0,喎,0, */
	/* 5590 */ 0,0x242e,0,0,0,0,0,0, 0x5343,0x533c,0x342d,0,0x346e,0x3365,0x5344,0x5340, /* 0,喑,0,0,0,0,0,0, 喘,喙,喚,0,喜,喝,喞,喟, */
	/* 55a0 */ 0,0,0,0,0,0,0,0x3776, 0x534a,0x5348,0x4153,0x354a,0x362c,0x2f2d,0x5345,0, /* 0,0,0,0,0,0,0,喧, 喨,喩,喪,喫,喬,喭,單,0, */
	/* 55b0 */ 0x3674,0,0,0,0,0,0x3144,0, 0,0,0,0,0,0,0,0x2433, /* 喰,0,0,0,0,0,営,0, 0,0,0,0,0,0,0,喿, */
	/* 55c0 */ 0,0,0,0,0x534e,0x534c,0,0x5427, 0,0x2434,0,0,0x2435,0,0x2f2e,0, /* 0,0,0,0,嗄,嗅,0,嗇, 0,嗉,0,0,嗌,0,嗎,0, */
	/* 55d0 */ 0,0x2436,0x2430,0,0x5351,0,0,0, 0,0,0x534b,0,0x534f,0x2437,0,0x534d, /* 0,嗑,嗒,0,嗔,0,0,0, 0,0,嗚,0,嗜,嗝,0,嗟, */
	/* 55e0 */ 0,0,0x2439,0x3b4c,0x5350,0,0,0, 0,0x243b,0,0,0,0,0,0, /* 0,0,嗢,嗣,嗤,0,0,0, 0,嗩,0,0,0,0,0,0, */
	/* 55f0 */ 0,0,0,0,0,0,0,0x5353, 0,0x5358,0,0,0,0x5356,0x5355,0, /* 0,0,0,0,0,0,0,嗷, 0,嗹,0,0,0,嗽,嗾,0, */
	/* 5600 */ 0,0,0,0,0,0,0x4332,0x243e, 0x2f30,0x3245,0,0,0,0,0x2f31,0, /* 0,0,0,0,0,0,嘆,嘇, 嘈,嘉,0,0,0,0,嘎,0, */
	/* 5610 */ 0x243f,0,0,0,0x5352,0,0x5354,0x3e28, 0x3133,0,0,0x5357,0,0,0,0, /* 嘐,0,0,0,嘔,0,嘖,嘗, 嘘,0,0,嘛,0,0,0,0, */
	/* 5620 */ 0,0,0,0,0,0,0,0, 0x243c,0x325e,0,0,0,0,0,0x5362, /* 0,0,0,0,0,0,0,0, 嘨,嘩,0,0,0,0,0,嘯, */
	/* 5630 */ 0x2440,0x3e7c,0x535e,0,0x535c,0,0x535d,0x2441, 0x535f,0,0,0x2f32,0,0x2443,0,0x2444, /* 嘰,嘱,嘲,0,嘴,0,嘶,嘷, 嘸,0,0,嘻,0,嘽,0,嘿, */
	/* 5640 */ 0x2445,0,0x313d,0,0,0,0,0x2446, 0,0x2f33,0,0,0x4139,0,0x5359,0, /* 噀,0,噂,0,0,0,0,噇, 0,噉,0,0,噌,0,噎,0, */
	/* 5650 */ 0x535a,0,0,0x7427,0,0,0,0, 0,0,0,0x337a,0,0,0x2447,0, /* 噐,0,0,噓,0,0,0,0, 0,0,0,噛,0,0,噞,0, */
	/* 5660 */ 0x2448,0,0,0,0x5361,0,0x2f35,0, 0x346f,0,0x5364,0x5360,0x5363,0x2449,0,0x2f37, /* 噠,0,0,0,噤,0,噦,0, 器,0,噪,噫,噬,噭,0,噯, */
	/* 5670 */ 0,0x2f38,0x2f39,0,0x4a2e,0,0x2f34,0, 0x4655,0,0x4838,0,0,0,0,0, /* 0,噱,噲,0,噴,0,噶,0, 噸,0,噺,0,0,0,0,0, */
	/* 5680 */ 0x5366,0,0,0,0,0,0x5365,0x3345, 0x244b,0,0x5367,0,0x244c,0,0,0x536a, /* 嚀,0,0,0,0,0,嚆,嚇, 嚈,0,嚊,0,嚌,0,0,嚏, */
	/* 5690 */ 0,0,0,0,0x5369,0x244d,0,0, 0,0x2f3a,0x244e,0,0,0x244f,0x2f3b,0, /* 0,0,0,0,嚔,嚕,0,0, 0,嚙,嚚,0,0,嚝,嚞,0, */
	/* 56a0 */ 0x5368,0,0x4739,0,0,0x536b,0,0, 0x2450,0x2f3c,0,0,0x2f3d,0x2451,0x536c,0, /* 嚠,0,嚢,0,0,嚥,0,0, 嚨,嚩,0,0,嚬,嚭,嚮,0, */
	/* 56b0 */ 0,0,0x2452,0x2f3e,0x536e,0,0x536d,0, 0,0,0,0,0x5370,0,0,0, /* 0,0,嚲,嚳,嚴,0,嚶,0, 0,0,0,0,嚼,0,0,0, */
	/* 56c0 */ 0x5373,0x5371,0x536f,0x5372,0,0x2453,0,0, 0x5374,0x2f3f,0x2f40,0,0,0x2454,0x5375,0, /* 囀,囁,囂,囃,0,囅,0,0, 囈,囉,囊,0,0,囍,囎,0, */
	/* 56d0 */ 0,0x5376,0,0x5377,0,0,0,0x5378, 0x5145,0,0x3c7c,0x3b4d,0,0,0x3273,0x2455, /* 0,囑,0,囓,0,0,0,囗, 囘,0,囚,四,0,0,回,囟, */
	/* 56e0 */ 0x3078,0,0,0x4344,0,0,0,0, 0x2456,0,0,0,0,0,0x5379,0, /* 因,0,0,団,0,0,0,0, 囨,0,0,0,0,0,囮,0, */
	/* 56f0 */ 0x3a24,0,0x304f,0x3f5e,0,0,0x2457,0x2458, 0,0x537a,0x3847,0,0,0x3971,0,0x537c, /* 困,0,囲,図,0,0,囶,囷, 0,囹,固,0,0,国,0,囿, */
	/* 5700 */ 0x537b,0,0,0x4a60,0x537d,0,0,0, 0x5421,0x537e,0x2f41,0x5422,0,0x5423,0,0x3777, /* 圀,0,0,圃,圄,0,0,0, 圈,圉,圊,國,0,圍,0,圏, */
	/* 5710 */ 0,0,0x3160,0x5424,0,0x245a,0x5426,0, 0x5425,0,0,0,0x5428,0,0,0x455a, /* 0,0,園,圓,0,圕,圖,0, 團,0,0,0,圜,0,0,土, */
	/* 5720 */ 0,0x2f43,0,0x245b,0,0,0x5429,0x3035, 0x3a5f,0x245d,0,0,0,0x373d,0,0x2f44, /* 0,圡,0,圣,0,0,圦,圧, 在,圩,0,0,0,圭,0,圯, */
	/* 5730 */ 0x434f,0,0,0x2f45,0x2f46,0,0,0x542a, 0x542b,0,0,0x542d,0,0,0,0, /* 地,0,0,圳,圴,0,0,圷, 圸,0,0,圻,0,0,0,0, */
	/* 5740 */ 0x542e,0,0x3a64,0,0,0x245f,0x2460,0x3651, 0,0,0x4b37,0,0x2461,0x2462,0x542c,0x542f, /* 址,0,坂,0,0,坅,坆,均, 0,0,坊,0,坌,坍,坎,坏, */
	/* 5750 */ 0x3a41,0x3923,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 坐,坑,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5760 */ 0,0x5433,0,0,0x3a25,0,0x4333,0, 0x2464,0x5430,0x445a,0,0,0,0,0x2465, /* 0,坡,0,0,坤,0,坦,0, 坨,坩,坪,0,0,0,0,坯, */
	/* 5770 */ 0x2f47,0,0,0x2466,0x2467,0x2468,0,0x2f48, 0,0,0,0x2469,0x2f49,0,0,0x5434, /* 坰,0,0,坳,坴,坵,0,坷, 0,0,0,坻,坼,0,0,坿, */
	/* 5780 */ 0,0,0x3f62,0,0,0,0,0, 0x5432,0x5435,0,0x373f,0,0,0,0, /* 0,0,垂,0,0,0,0,0, 垈,垉,0,型,0,0,0,0, */
	/* 5790 */ 0,0,0,0x5436,0,0,0,0, 0,0,0x246d,0,0x2f4a,0x246e,0x246f,0, /* 0,0,0,垓,0,0,0,0, 0,0,垚,0,垜,垝,垞,0, */
	/* 57a0 */ 0x5437,0,0x3924,0x3340,0x5439,0,0,0, 0x2470,0,0x543a,0,0x246c,0,0,0, /* 垠,0,垢,垣,垤,0,0,0, 垨,0,垪,0,垬,0,0,0, */
	/* 57b0 */ 0x543b,0,0,0x5438,0,0,0,0, 0x2f4d,0,0,0,0,0,0,0, /* 垰,0,0,垳,0,0,0,0, 垸,0,0,0,0,0,0,0, */
	/* 57c0 */ 0x5431,0,0,0x543c,0,0,0x543d,0x2f4e, 0x2f4f,0,0,0x4b64,0x2473,0,0x3e6b,0x2f50, /* 埀,0,0,埃,0,0,埆,埇, 埈,0,0,埋,埌,0,城,埏, */
	/* 57d0 */ 0,0,0x543f,0x5440,0x543e,0,0x5442,0x2471, 0,0,0,0,0x4738,0,0x2476,0x3068, /* 0,0,埒,埓,埔,0,埖,埗, 0,0,0,0,埜,0,埞,域, */
	/* 57e0 */ 0x4956,0,0,0x5443,0x2f51,0,0x2477,0, 0,0,0,0,0,0x2f52,0,0, /* 埠,0,0,埣,埤,0,埦,0, 0,0,0,0,0,埭,0,0, */
	/* 57f0 */ 0x2478,0,0,0,0x3e7d,0x2f53,0x2f54,0x3c39, 0x247a,0x475d,0x3470,0x247b,0x3a6b,0x247c,0,0x2f55, /* 埰,0,0,0,埴,埵,埶,執, 埸,培,基,埻,埼,埽,0,埿, */
	/* 5800 */ 0x4b59,0,0x4632,0,0x247d,0x3778,0x424f,0, 0,0x2f56,0x5441,0x5444,0,0,0,0, /* 堀,0,堂,0,堄,堅,堆,0, 0,堉,堊,堋,0,0,0,0, */
	/* 5810 */ 0,0,0,0,0,0x4244,0,0, 0,0x5445,0,0,0,0x5446,0x247e,0, /* 0,0,0,0,0,堕,0,0, 0,堙,0,0,0,堝,堞,0, */
	/* 5820 */ 0x2521,0x5448,0,0,0x4469,0,0,0x2522, 0,0,0x342e,0,0,0,0,0x7421, /* 堠,堡,0,0,堤,0,0,堧, 0,0,堪,0,0,0,0,堯, */
	/* 5830 */ 0x3161,0x4a73,0x2523,0,0x3e6c,0x4548,0,0, 0,0x2524,0x3a66,0,0,0x544e,0,0, /* 堰,報,堲,0,場,堵,0,0, 0,堹,堺,0,0,堽,0,0, */
	/* 5840 */ 0x4a3d,0x4e5d,0,0,0,0,0,0, 0,0x2526,0x3274,0x544a,0x2527,0,0,0, /* 塀,塁,0,0,0,0,0,0, 0,塉,塊,塋,塌,0,0,0, */
	/* 5850 */ 0,0x413a,0x544d,0,0x4563,0,0,0x4549, 0x4564,0x4839,0x444d,0,0,0,0x3a49,0, /* 0,塑,塒,0,塔,0,0,塗, 塘,塙,塚,0,0,0,塞,0, */
	/* 5860 */ 0,0x2f58,0x5449,0,0x2f59,0,0,0x2528, 0,0x3176,0,0x4536,0,0,0,0, /* 0,塡,塢,0,塤,0,0,塧, 0,塩,0,填,0,0,0,0, */
	/* 5870 */ 0x544b,0,0x5447,0,0,0x3f50,0,0, 0,0x544f,0,0,0x2f5b,0,0x3d4e,0, /* 塰,0,塲,0,0,塵,0,0, 0,塹,0,0,塼,0,塾,0, */
	/* 5880 */ 0,0,0,0x362d,0,0x5450,0,0, 0,0x2f5c,0x2529,0x252a,0,0x252b,0,0x252c, /* 0,0,0,境,0,墅,0,0, 0,墉,墊,墋,0,墍,0,墏, */
	/* 5890 */ 0x252d,0,0,0x4a68,0x252e,0,0,0x417d, 0,0,0,0,0x4446,0x252f,0x2f5d,0x5452, /* 墐,0,0,墓,墔,0,0,増, 0,0,0,0,墜,墝,增,墟, */
	/* 58a0 */ 0,0,0,0,0,0,0,0, 0x4b4f,0x2f5f,0x2530,0x5453,0,0,0x5458,0, /* 0,0,0,0,0,0,0,0, 墨,墩,墪,墫,0,0,墮,0, */
	/* 58b0 */ 0,0x2531,0,0x4a2f,0,0,0,0, 0x5457,0x5451,0x5454,0x5456,0,0,0x3a26,0, /* 0,墱,0,墳,0,0,0,0, 墸,墹,墺,墻,0,0,墾,0, */
	/* 58c0 */ 0,0x4a49,0,0x2533,0,0x5459,0,0x4345, 0,0,0x3275,0,0x3e6d,0x2534,0x2f62,0, /* 0,壁,0,壃,0,壅,0,壇, 0,0,壊,0,壌,壍,壎,0, */
	/* 58d0 */ 0,0x545b,0x2f61,0x545a,0x2f63,0x3968,0,0x545c, 0x545e,0x545d,0x2f64,0,0x5460,0,0x5455,0x5462, /* 0,壑,壒,壓,壔,壕,0,壗, 壘,壙,壚,0,壜,0,壞,壟, */
	/* 58e0 */ 0x2f65,0,0x2535,0,0x5461,0x545f,0,0, 0,0x2f66,0,0x3b4e,0x3f51,0,0x4154,0x5463, /* 壠,0,壢,0,壤,壥,0,0, 0,壩,0,士,壬,0,壮,壯, */
	/* 58f0 */ 0x403c,0x306d,0x4764,0x2536,0x2537,0,0,0x445b, 0,0x5465,0x5464,0x5466,0x5467,0x5468,0,0, /* 声,壱,売,壳,壴,0,0,壷, 0,壹,壺,壻,壼,壽,0,0, */
	/* 5900 */ 0,0,0x5469,0,0,0x2538,0x2539,0, 0,0x4a51,0x546a,0x253a,0x2f67,0x253b,0,0x3246, /* 0,0,夂,0,0,夅,夆,0, 0,変,夊,夋,夌,复,0,夏, */
	/* 5910 */ 0x546b,0,0,0,0x253c,0x4d3c,0x3330,0, 0x5249,0x3d48,0x423f,0x546c,0x4c6b,0,0,0, /* 夐,0,0,0,夔,夕,外,0, 夘,夙,多,夛,夜,0,0,0, */
	/* 5920 */ 0,0,0x4c34,0,0x253d,0x546e,0,0x4267, 0,0x4537,0x4240,0x4957,0x546f,0x5470,0x317b,0, /* 0,0,夢,0,夤,夥,0,大, 0,天,太,夫,夬,夭,央,0, */
	/* 5930 */ 0,0x3c3a,0x5471,0,0,0,0,0x3050, 0x5472,0,0,0,0,0x2540,0x5473,0, /* 0,失,夲,0,0,0,0,夷, 夸,0,0,0,0,夽,夾,0, */
	/* 5940 */ 0,0,0,0,0x3162,0,0x2542,0x3471, 0x4660,0x4a74,0,0,0,0,0x5477,0x4155, /* 0,0,0,0,奄,0,奆,奇, 奈,奉,0,0,0,0,奎,奏, */
	/* 5950 */ 0x5476,0x3740,0,0,0x4b5b,0x5475,0,0x4565, 0x5479,0,0x5478,0x2545,0,0x2f69,0,0x2546, /* 奐,契,0,0,奔,奕,0,套, 奘,0,奚,奛,0,奝,0,奟, */
	/* 5960 */ 0x547b,0,0x547a,0,0,0x317c,0,0x547c, 0x3e29,0x547e,0x4325,0,0x547d,0x2f6a,0x4a33,0, /* 奠,0,奢,0,0,奥,0,奧, 奨,奩,奪,0,奬,奭,奮,0, */
	/* 5970 */ 0,0,0,0x3d77,0x455b,0x2548,0x2549,0, 0x5521,0,0,0,0x254a,0x3925,0,0, /* 0,0,0,女,奴,奵,奶,0, 奸,0,0,0,奼,好,0,0, */
	/* 5980 */ 0,0x5522,0x4721,0x485e,0x4c51,0,0,0, 0,0,0x4725,0x2f6b,0,0x552b,0,0, /* 0,妁,如,妃,妄,0,0,0, 0,0,妊,妋,0,妍,0,0, */
	/* 5990 */ 0,0,0x2f6c,0x3538,0,0,0x4d45,0, 0,0x4c2f,0,0x562c,0,0x5523,0,0x254b, /* 0,0,妒,妓,0,0,妖,0, 0,妙,0,妛,0,妝,0,妟, */
	/* 59a0 */ 0,0,0,0x5526,0x2f6d,0x4245,0,0, 0x4b38,0,0,0,0x454a,0,0x254c,0, /* 0,0,0,妣,妤,妥,0,0, 妨,0,0,0,妬,0,妮,0, */
	/* 59b0 */ 0,0,0x5527,0,0,0,0,0, 0,0x4b65,0,0x3a4a,0x254d,0,0x3e2a,0, /* 0,0,妲,0,0,0,0,0, 0,妹,0,妻,妼,0,妾,0, */
	/* 59c0 */ 0,0,0,0x2f6e,0,0,0x5528,0, 0x254e,0x3b50,0,0x3b4f,0,0x254f,0,0, /* 0,0,0,姃,0,0,姆,0, 姈,姉,0,始,0,姍,0,0, */
	/* 59d0 */ 0x3039,0x3848,0x2f6f,0x402b,0x3051,0,0,0, 0,0x552c,0x552d,0,0x552a,0x2f70,0x2550,0, /* 姐,姑,姒,姓,委,0,0,0, 0,姙,姚,0,姜,姝,姞,0, */
	/* 59e0 */ 0,0,0,0x2551,0x2552,0x3138,0x342f,0x2553, 0x5529,0,0x4c45,0x4931,0,0,0x2554,0, /* 0,0,0,姣,姤,姥,姦,姧, 姨,0,姪,姫,0,0,姮,0, */
	/* 59f0 */ 0,0,0,0,0,0,0x3028,0, 0x7e7a,0,0,0x3079,0,0,0,0x3b51, /* 0,0,0,0,0,0,姶,0, 姸,0,0,姻,0,0,0,姿, */
	/* 5a00 */ 0,0x3052,0,0x3023,0,0,0,0, 0,0x5532,0,0,0x2558,0x2559,0,0, /* 0,威,0,娃,0,0,0,0, 0,娉,0,0,娌,娍,0,0, */
	/* 5a10 */ 0,0x5530,0,0x2f71,0,0,0,0x255a, 0x4c3c,0,0x5533,0,0x5531,0,0,0x552f, /* 0,娑,0,娓,0,0,0,娗, 娘,0,娚,0,娜,0,0,娟, */
	/* 5a20 */ 0x3f31,0,0,0x2f72,0,0x552e,0,0x255b, 0,0x4a5a,0,0,0,0x255c,0,0x3864, /* 娠,0,0,娣,0,娥,0,娧, 0,娩,0,0,0,娭,0,娯, */
	/* 5a30 */ 0,0,0,0,0,0x5537,0x5538,0, 0,0,0,0,0x3e2b,0,0,0, /* 0,0,0,0,0,娵,娶,0, 0,0,0,0,娼,0,0,0, */
	/* 5a40 */ 0x5534,0x4f2c,0,0,0,0,0x474c,0, 0,0x5536,0,0,0,0,0,0, /* 婀,婁,0,0,0,0,婆,0, 0,婉,0,0,0,0,0,0, */
	/* 5a50 */ 0,0,0,0,0,0x255d,0,0, 0,0,0x3a27,0,0,0,0,0, /* 0,0,0,0,0,婕,0,0, 0,0,婚,0,0,0,0,0, */
	/* 5a60 */ 0,0,0x5539,0,0,0x255e,0x4958,0x2f73, 0,0,0x553a,0,0x5535,0x2f74,0,0, /* 0,0,婢,0,0,婥,婦,婧, 0,0,婪,0,婬,婭,0,0, */
	/* 5a70 */ 0,0,0,0,0,0,0,0x2f75, 0,0,0x255f,0,0,0,0x2f76,0x4c3b, /* 0,0,0,0,0,0,0,婷, 0,0,婺,0,0,0,婾,婿, */
	/* 5a80 */ 0,0,0,0,0x2f77,0,0,0, 0,0,0,0x2560,0,0,0,0, /* 0,0,0,0,媄,0,0,0, 0,0,0,媋,0,0,0,0, */
	/* 5a90 */ 0,0,0x475e,0,0,0,0,0, 0,0,0x553b,0x4932,0x2561,0,0x2f78,0x2562, /* 0,0,媒,0,0,0,0,0, 0,0,媚,媛,媜,0,媞,媟, */
	/* 5aa0 */ 0x2563,0,0x2564,0,0,0,0,0x2f79, 0,0,0,0,0,0,0,0, /* 媠,0,媢,0,0,0,0,媧, 0,0,0,0,0,0,0,0, */
	/* 5ab0 */ 0,0x2565,0,0x2566,0,0x2567,0,0, 0,0,0x2568,0,0x553c,0x5540,0x553d,0x2569, /* 0,媱,0,媳,0,媵,0,0, 0,0,媺,0,媼,媽,媾,媿, */
	/* 5ac0 */ 0,0x3247,0x553f,0,0x2f7a,0,0,0, 0,0x3c3b,0,0x553e,0x3779,0,0,0, /* 0,嫁,嫂,0,嫄,0,0,0, 0,嫉,0,嫋,嫌,0,0,0, */
	/* 5ad0 */ 0x554c,0,0,0,0,0,0x5545,0x5542, 0,0,0x256a,0,0x256b,0,0,0, /* 嫐,0,0,0,0,0,嫖,嫗, 0,0,嫚,0,嫜,0,0,0, */
	/* 5ae0 */ 0x256c,0x4364,0,0x5541,0,0x256d,0x5543,0, 0,0x5544,0,0,0,0,0x256f,0, /* 嫠,嫡,0,嫣,0,嫥,嫦,0, 0,嫩,0,0,0,0,嫮,0, */
	/* 5af0 */ 0x256e,0,0,0,0,0x2570,0,0, 0,0,0x5546,0x5547,0,0,0,0, /* 嫰,0,0,0,0,嫵,0,0, 0,0,嫺,嫻,0,0,0,0, */
	/* 5b00 */ 0x2571,0,0,0,0,0,0,0, 0x2572,0x3472,0,0x5549,0x5548,0,0,0, /* 嬀,0,0,0,0,0,0,0, 嬈,嬉,0,嬋,嬌,0,0,0, */
	/* 5b10 */ 0,0,0,0,0,0,0x554a,0x2573, 0,0x2f7c,0,0,0,0,0,0, /* 0,0,0,0,0,0,嬖,嬗, 0,嬙,0,0,0,0,0,0, */
	/* 5b20 */ 0,0,0x3e6e,0,0,0x2f7d,0,0, 0,0,0x554d,0,0x445c,0x2575,0,0, /* 0,0,嬢,0,0,嬥,0,0, 0,0,嬪,0,嬬,嬭,0,0, */
	/* 5b30 */ 0x3145,0,0x554b,0,0x2574,0,0x554e,0, 0,0,0,0,0,0,0x554f,0, /* 嬰,0,嬲,0,嬴,0,嬶,0, 0,0,0,0,0,0,嬾,0, */
	/* 5b40 */ 0x5552,0x4f55,0,0x5550,0,0x5551,0,0, 0,0,0,0,0x2576,0,0,0, /* 孀,孁,0,孃,0,孅,0,0, 0,0,0,0,孌,0,0,0, */
	/* 5b50 */ 0x3b52,0x5553,0x2577,0,0x3926,0x5554,0x4f56,0x3b7a, 0x4238,0,0x5555,0x5556,0x3b5a,0x3927,0,0x4c52, /* 子,孑,孒,0,孔,孕,孖,字, 存,0,孚,孛,孜,孝,0,孟, */
	/* 5b60 */ 0,0,0,0x3528,0x3849,0x5557,0x3358,0, 0x2578,0x5558,0,0x4239,0,0,0,0x2579, /* 0,0,0,季,孤,孥,学,0, 孨,孩,0,孫,0,0,0,孯, */
	/* 5b70 */ 0x5559,0x5623,0,0x555a,0,0x555b,0,0, 0x555c,0,0x555e,0,0x257a,0x4f57,0,0x257b, /* 孰,孱,0,孳,0,孵,0,0, 學,0,孺,0,孼,孽,0,孿, */
	/* 5b80 */ 0x555f,0x257c,0,0x5560,0x257d,0x4270,0,0x3127, 0x3c69,0x3042,0,0x4157,0x3430,0x3c35,0,0x3928, /* 宀,宁,0,它,宄,宅,0,宇, 守,安,0,宋,完,宍,0,宏, */
	/* 5b90 */ 0,0,0,0x4f58,0,0x4566,0x2821,0x3d21, 0x3431,0x4368,0x446a,0x3038,0x3539,0x4a75,0,0x3c42, /* 0,0,0,宓,0,宕,宖,宗, 官,宙,定,宛,宜,宝,0,実, */
	/* 5ba0 */ 0,0,0x3552,0x406b,0x3c3c,0x4d28,0x5561,0, 0,0,0,0,0x2822,0,0x355c,0, /* 0,0,客,宣,室,宥,宦,0, 0,0,0,0,宬,0,宮,0, */
	/* 5bb0 */ 0x3a4b,0,0,0x3332,0x3163,0x3e2c,0x3248,0, 0x5562,0x4d46,0,0,0,0,0,0x3d49, /* 宰,0,0,害,宴,宵,家,0, 宸,容,0,0,0,0,0,宿, */
	/* 5bc0 */ 0x2824,0,0x3c64,0x5563,0x3473,0x4652,0x4c29,0x5564, 0,0x5565,0,0,0x4959,0,0x2826,0, /* 寀,0,寂,寃,寄,寅,密,寇, 0,寉,0,0,富,0,寎,0, */
	/* 5bd0 */ 0x5567,0,0x3428,0x3677,0x5566,0,0x2827,0, 0x4f59,0,0,0x3432,0,0x3f32,0x556b,0x3b21, /* 寐,0,寒,寓,寔,0,寖,0, 寘,0,0,寛,0,寝,寞,察, */
	/* 5be0 */ 0,0x3249,0x556a,0,0x5568,0x556c,0x5569,0x472b, 0x5c4d,0x3f33,0,0x556d,0x4f5a,0,0x4e40,0, /* 0,寡,寢,0,寤,寥,實,寧, 寨,審,0,寫,寬,0,寮,0, */
	/* 5bf0 */ 0x556e,0x282a,0,0x5570,0,0x437e,0x556f,0, 0x4023,0,0x3b7b,0,0,0x282b,0x4250,0x3c77, /* 寰,寱,0,寳,0,寵,寶,0, 寸,0,寺,0,0,寽,対,寿, */
	/* 5c00 */ 0,0x4975,0x406c,0x282d,0x3c4d,0x5571,0x3e2d,0x5572, 0x5573,0x3053,0x423a,0x3f52,0,0x5574,0x4633,0x3e2e, /* 0,封,専,尃,射,尅,将,將, 專,尉,尊,尋,0,對,導,小, */
	/* 5c10 */ 0,0x3e2f,0x4f5b,0x5575,0,0,0x406d,0, 0,0,0x3e30,0,0,0,0x4f5c,0, /* 0,少,尒,尓,0,0,尖,0, 0,0,尚,0,0,0,尞,0, */
	/* 5c20 */ 0x5576,0,0x5577,0x4f5d,0x4c60,0,0,0, 0x5578,0x282e,0,0x4f5e,0,0x3646,0,0, /* 尠,0,尢,尣,尤,0,0,0, 尨,尩,0,尫,0,尭,0,0, */
	/* 5c30 */ 0x282f,0x3d22,0,0,0,0,0,0, 0x5579,0x557a,0x3c5c,0x3f2c,0x4674,0x3f54,0x4878,0x4722, /* 尰,就,0,0,0,0,0,0, 尸,尹,尺,尻,尼,尽,尾,尿, */
	/* 5c40 */ 0x3649,0x557b,0,0,0,0x356f,0x557c,0, 0x367e,0,0x464f,0x3230,0,0x3b53,0x557d,0x5622, /* 局,屁,0,0,0,居,屆,0, 屈,0,届,屋,0,屍,屎,屏, */
	/* 5c50 */ 0x5621,0x367d,0,0x557e,0,0x4538,0,0, 0,0,0,0x7e7b,0,0,0x4230,0x2831, /* 屐,屑,0,屓,0,展,0,0, 0,0,0,屛,0,0,属,屟, */
	/* 5c60 */ 0x454b,0x3c48,0x4f60,0x2832,0x4158,0x4d7a,0,0x2833, 0x2834,0x2835,0,0,0x5624,0,0x5625,0x4656, /* 屠,屡,屢,屣,層,履,0,屧, 屨,屩,0,0,屬,0,屮,屯, */
	/* 5c70 */ 0x2836,0x3b33,0,0,0,0,0x5627,0, 0,0x5628,0x4f64,0,0x2839,0,0,0, /* 屰,山,0,0,0,0,屶,0, 0,屹,屺,0,屼,0,0,0, */
	/* 5c80 */ 0,0,0,0,0,0,0,0, 0x283c,0,0x283d,0,0x5629,0,0,0x4f65, /* 0,0,0,0,0,0,0,0, 岈,0,岊,0,岌,0,0,岏, */
	/* 5c90 */ 0x3474,0x562a,0,0,0x562b,0,0,0, 0,0,0,0,0,0,0,0x4f66, /* 岐,岑,0,0,岔,0,0,0, 0,0,0,0,0,0,0,岟, */
	/* 5ca0 */ 0x2841,0x322c,0x2842,0x4f67,0,0,0x2843,0x2844, 0x413b,0x3464,0x4f68,0x562d,0x4c28,0x2846,0,0, /* 岠,岡,岢,岣,0,0,岦,岧, 岨,岩,岪,岫,岬,岭,0,0, */
	/* 5cb0 */ 0,0x4252,0,0x3359,0,0x2847,0x562f,0x5631, 0x345f,0,0x4f69,0x562e,0x5630,0,0x5633,0, /* 0,岱,0,岳,0,岵,岶,岷, 岸,0,岺,岻,岼,0,岾,0, */
	/* 5cc0 */ 0,0,0,0,0,0x5632,0,0x5634, 0,0x2849,0,0x4f6a,0,0,0,0, /* 0,0,0,0,0,峅,0,峇, 0,峉,0,峋,0,0,0,0, */
	/* 5cd0 */ 0x4f6b,0,0x4f6c,0,0,0,0,0, 0,0x5635,0,0,0,0,0,0, /* 峐,0,峒,0,0,0,0,0, 0,峙,0,0,0,0,0,0, */
	/* 5ce0 */ 0x463d,0x362e,0,0,0,0,0,0, 0x3265,0x5636,0x563b,0,0,0x5639,0,0x4a77, /* 峠,峡,0,0,0,0,0,0, 峨,峩,峪,0,0,峭,0,峯, */
	/* 5cf0 */ 0x4a76,0,0,0,0x4f6d,0,0x4567,0, 0,0,0x5638,0x3d54,0,0x5637,0,0, /* 峰,0,0,0,峴,0,島,0, 0,0,峺,峻,0,峽,0,0, */
	/* 5d00 */ 0,0,0,0,0,0,0x284c,0x3f72, 0,0,0,0x563c,0,0x4f70,0x3a6a,0, /* 0,0,0,0,0,0,崆,崇, 0,0,0,崋,0,崍,崎,0, */
	/* 5d10 */ 0x284d,0x5642,0,0,0x5643,0x563d,0x3333,0x563e, 0x5647,0x5646,0x5645,0x5641,0,0x284f,0,0x5640, /* 崐,崑,0,0,崔,崕,崖,崗, 崘,崙,崚,崛,0,崝,0,崟, */
	/* 5d20 */ 0x2850,0,0x5644,0,0x2851,0,0x2852,0x4f71, 0,0x4a78,0,0x284e,0,0,0,0, /* 崠,0,崢,0,崤,0,崦,崧, 0,崩,0,崫,0,0,0,0, */
	/* 5d30 */ 0,0x2853,0,0,0,0,0,0, 0,0x2854,0,0,0,0,0,0, /* 0,崱,0,0,0,0,0,0, 0,崹,0,0,0,0,0,0, */
	/* 5d40 */ 0,0,0x2855,0,0,0,0x4f73,0x4f74, 0,0,0x4f76,0x564b,0x5648,0,0x564a,0, /* 0,0,嵂,0,0,0,嵆,嵇, 0,0,嵊,嵋,嵌,0,嵎,0, */
	/* 5d50 */ 0x4d72,0,0x5649,0x4f75,0,0,0,0, 0,0,0,0,0x563f,0,0,0, /* 嵐,0,嵒,嵓,0,0,0,0, 0,0,0,0,嵜,0,0,0, */
	/* 5d60 */ 0,0x2857,0,0,0,0,0,0, 0,0x3f73,0x2858,0,0x564c,0x4f77,0,0x3a37, /* 0,嵡,0,0,0,0,0,0, 0,嵩,嵪,0,嵬,嵭,0,嵯, */
	/* 5d70 */ 0x285a,0,0,0x564d,0,0,0x564e,0, 0,0,0,0,0,0,0,0, /* 嵰,0,0,嵳,0,0,嵶,0, 0,0,0,0,0,0,0,0, */
	/* 5d80 */ 0,0x4f78,0x5651,0,0x5650,0,0,0x564f, 0x285d,0,0,0x4568,0x563a,0,0,0, /* 0,嶁,嶂,0,嶄,0,0,嶇, 嶈,0,0,嶋,嶌,0,0,0, */
	/* 5d90 */ 0x5657,0,0x285f,0,0x2860,0,0,0x2861, 0,0x2862,0,0,0,0x5653,0,0, /* 嶐,0,嶒,0,嶔,0,0,嶗, 0,嶙,0,0,0,嶝,0,0, */
	/* 5da0 */ 0x4f79,0,0x5652,0,0x4f7a,0,0,0x4f7b, 0,0,0,0,0x5654,0,0x5655,0, /* 嶠,0,嶢,0,嶤,0,0,嶧, 0,0,0,0,嶬,0,嶮,0, */
	/* 5db0 */ 0x2863,0,0x2864,0,0x2865,0,0,0x5658, 0x4f7c,0x2867,0x4e66,0,0x5659,0x5656,0,0, /* 嶰,0,嶲,0,嶴,0,0,嶷, 嶸,嶹,嶺,0,嶼,嶽,0,0, */
	/* 5dc0 */ 0,0,0,0,0,0,0,0, 0,0x565a,0,0x4f7d,0x3460,0x565b,0,0, /* 0,0,0,0,0,0,0,0, 0,巉,0,巋,巌,巍,0,0, */
	/* 5dd0 */ 0,0x2868,0x565d,0x565c,0,0,0x565e,0x2869, 0x286a,0,0,0x565f,0,0x406e,0x3d23,0, /* 0,巑,巒,巓,0,0,巖,巗, 巘,0,0,巛,0,川,州,0, */
	/* 5de0 */ 0x286b,0x3d64,0x7428,0x4163,0x286d,0x3929,0x3a38,0x392a, 0x3570,0x286e,0,0x5660,0,0,0x3a39,0, /* 巠,巡,巢,巣,巤,工,左,巧, 巨,巩,0,巫,0,0,差,0, */
	/* 5df0 */ 0,0x384a,0x5661,0x4c26,0x4743,0x5662,0,0x392b, 0,0,0,0x342c,0,0x4327,0x3652,0, /* 0,己,已,巳,巴,巵,0,巷, 0,0,0,巻,0,巽,巾,0, */
	/* 5e00 */ 0x2870,0,0x3b54,0x495b,0,0,0x4841,0, 0,0,0,0x5663,0x3475,0,0,0, /* 帀,0,市,布,0,0,帆,0, 0,0,0,帋,希,0,0,0, */
	/* 5e10 */ 0,0x5666,0x2872,0,0x7429,0x2873,0x4421,0, 0x742a,0x5665,0x5664,0x5667,0,0x446b,0,0x2875, /* 0,帑,帒,0,帔,帕,帖,0, 帘,帙,帚,帛,0,帝,0,帟, */
	/* 5e20 */ 0,0,0,0,0,0x3f63,0,0, 0,0,0,0x3b55,0,0x404a,0x2876,0x4253, /* 0,0,0,0,0,帥,0,0, 0,0,0,師,0,席,帮,帯, */
	/* 5e30 */ 0x3522,0,0,0x4422,0,0,0x5668,0x5669, 0x3e6f,0,0,0,0,0x4b39,0x2877,0, /* 帰,0,0,帳,0,0,帶,帷, 常,0,0,0,0,帽,帾,0, */
	/* 5e40 */ 0x566c,0,0,0x566b,0x566a,0x497d,0,0x5673, 0,0x2878,0,0,0x4b5a,0,0x566d,0, /* 幀,0,0,幃,幄,幅,0,幇, 0,幉,0,0,幌,0,幎,0, */
	/* 5e50 */ 0,0,0,0,0x566f,0x4b6b,0x287a,0x566e, 0x742b,0,0,0,0,0,0x742c,0x5670, /* 0,0,0,0,幔,幕,幖,幗, 幘,0,0,0,0,0,幞,幟, */
	/* 5e60 */ 0,0x4828,0x5671,0x4a3e,0x5672,0,0,0, 0,0,0,0x287c,0x287d,0x287e,0x2c21,0, /* 0,幡,幢,幣,幤,0,0,0, 0,0,0,幫,幬,幭,幮,0, */
	/* 5e70 */ 0,0,0x3433,0x4a3f,0x472f,0x5674,0x5675,0x7e7c, 0x392c,0x3434,0x5676,0x3838,0x4d44,0x4d29,0x3476,0x5678, /* 0,0,干,平,年,幵,并,幷, 幸,幹,幺,幻,幼,幽,幾,广, */
	/* 5e80 */ 0,0x4423,0,0x392d,0x3e31,0,0,0x485f, 0,0,0x3e32,0,0,0,0,0x3d78, /* 0,庁,0,広,庄,0,0,庇, 0,0,床,0,0,0,0,序, */
	/* 5e90 */ 0,0,0,0,0,0x446c,0x4a79,0x4539, 0,0,0x392e,0,0x495c,0,0,0, /* 0,0,0,0,0,底,庖,店, 0,0,庚,0,府,0,0,0, */
	/* 5ea0 */ 0x5679,0,0,0,0,0x2c23,0x4559,0x3a42, 0,0,0x2c24,0x384b,0x2c25,0x446d,0,0, /* 庠,0,0,0,0,庥,度,座, 0,0,庪,庫,庬,庭,0,0, */
	/* 5eb0 */ 0,0,0,0,0,0x3043,0x3d6e,0x392f, 0x4d47,0x2c26,0,0,0,0,0x742d,0x2c27, /* 0,0,0,0,0,庵,庶,康, 庸,庹,0,0,0,0,庾,庿, */
	/* 5ec0 */ 0,0x567a,0x567b,0x4751,0,0,0x2c28,0, 0x567c,0x4e77,0x4f2d,0x742f,0,0,0,0x567e, /* 0,廁,廂,廃,0,0,廆,0, 廈,廉,廊,廋,0,0,0,廏, */
	/* 5ed0 */ 0x567d,0,0x2c29,0x3347,0,0,0x5721,0, 0,0x2c2a,0x5724,0x5725,0,0x5723,0,0x4940, /* 廐,0,廒,廓,0,0,廖,0, 0,廙,廚,廛,0,廝,0,廟, */
	/* 5ee0 */ 0x3e33,0x5727,0x5726,0x5722,0,0,0,0, 0x5728,0x5729,0,0,0x572a,0,0,0, /* 廠,廡,廢,廣,0,0,0,0, 廨,廩,0,0,廬,0,0,0, */
	/* 5ef0 */ 0x572d,0x572b,0,0x572c,0x572e,0,0x3164,0x446e, 0x572f,0x7430,0x377a,0x3276,0x4736,0x2c2c,0x5730,0x467b, /* 廰,廱,0,廳,廴,0,延,廷, 廸,廹,建,廻,廼,廽,廾,廿, */
	/* 5f00 */ 0x7431,0x4a5b,0x7432,0x5731,0x4f2e,0,0,0x7433, 0x2c2d,0x5732,0x4a40,0x5735,0x5021,0x5031,0x2c2e,0x3c30, /* 开,弁,异,弃,弄,0,0,弇, 弈,弉,弊,弋,弌,弍,弎,式, */
	/* 5f10 */ 0x4675,0x5736,0,0x355d,0x4424,0x307a,0x5737,0x4a26, 0x3930,0,0,0x4350,0x2c2f,0x7434,0x2c31,0x446f, /* 弐,弑,0,弓,弔,引,弖,弗, 弘,0,0,弛,弜,弝,弞,弟, */
	/* 5f20 */ 0,0,0,0x7435,0,0x4c6f,0x3839,0x384c, 0,0x5738,0,0,0,0x5739,0,0x573f, /* 0,0,0,弣,0,弥,弦,弧, 0,弩,0,0,0,弭,0,弯, */
	/* 5f30 */ 0,0x3c65,0,0,0x7436,0x4425,0x7437,0x362f, 0x573a,0,0,0,0x492b,0x7438,0x4346,0, /* 0,弱,0,0,弴,張,弶,強, 弸,0,0,0,弼,弽,弾,0, */
	/* 5f40 */ 0x7439,0x573b,0,0,0,0x743a,0,0x2c32, 0x573c,0,0x3630,0,0x573d,0,0x573e,0, /* 彀,彁,0,0,0,彅,0,彇, 彈,0,彊,0,彌,0,彎,0, */
	/* 5f50 */ 0,0x5740,0,0x4576,0x743b,0,0x5741,0x5742, 0x743c,0x5743,0,0,0x5734,0x5733,0,0, /* 0,彑,0,当,彔,0,彖,彗, 彘,彙,0,0,彜,彝,0,0, */
	/* 5f60 */ 0,0x5744,0x3741,0x2c33,0x743d,0,0x4927,0x743e, 0,0x3a4c,0x4937,0x4426,0x494b,0x5745,0,0, /* 0,彡,形,彣,彤,0,彦,彧, 0,彩,彪,彫,彬,彭,0,0, */
	/* 5f70 */ 0x3e34,0x3146,0x2c34,0x5746,0,0,0,0x5747, 0,0x4c72,0,0,0x4860,0x743f,0x2c35,0x574a, /* 彰,影,彲,彳,0,0,0,彷, 0,役,0,0,彼,彽,彾,彿, */
	/* 5f80 */ 0x317d,0x402c,0x5749,0x5748,0x3742,0x4254,0,0x574e, 0x574c,0x7440,0x574b,0x4e27,0x3865,0,0,0x2c36, /* 往,征,徂,徃,径,待,0,徇, 很,徉,徊,律,後,0,0,徏, */
	/* 5f90 */ 0x3d79,0x574d,0x454c,0x3d3e,0,0,0,0x4640, 0x5751,0x5750,0,0,0x7441,0,0x574f,0, /* 徐,徑,徒,従,0,0,0,得, 徘,徙,0,0,徜,0,從,0, */
	/* 5fa0 */ 0x5752,0x3866,0x2c37,0,0x2c38,0,0,0x7442, 0x5753,0x497c,0x3d5b,0,0,0x5754,0x4879,0x7443, /* 徠,御,徢,0,徤,0,0,徧, 徨,復,循,0,0,徭,微,徯, */
	/* 5fb0 */ 0,0,0,0x4641,0x4427,0x7444,0,0x7445, 0x2c39,0x4530,0,0,0x5755,0x352b,0,0, /* 0,0,0,徳,徴,徵,0,德, 徸,徹,0,0,徼,徽,0,0, */
	/* 5fc0 */ 0,0,0,0x3f34,0x2c3a,0x492c,0,0x2c3c, 0,0x7446,0,0x2c3d,0x3477,0x4726,0,0, /* 0,0,0,心,忄,必,0,忇, 0,忉,0,忋,忌,忍,0,0, */
	/* 5fd0 */ 0,0,0x2c3e,0x2c3f,0x2c40,0,0x5756,0x3b56, 0x4b3a,0x4b3b,0,0,0x317e,0x575b,0x7447,0, /* 0,0,忒,忓,忔,0,忖,志, 忘,忙,0,0,応,忝,忞,0, */
	/* 5fe0 */ 0x4369,0x7448,0x2c41,0,0x5758,0,0,0, 0,0x7449,0,0x3277,0,0,0x2c42,0x2c43, /* 忠,忡,忢,0,忤,0,0,0, 0,忩,0,快,0,0,忮,忯, */
	/* 5ff0 */ 0x582d,0x575a,0,0x2c44,0,0x4730,0,0, 0x5759,0,0,0x5757,0x2c45,0x397a,0,0x575d, /* 忰,忱,0,忳,0,念,0,0, 忸,0,0,忻,忼,忽,0,忿, */
	/* 6000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x744a,0x5763,0x5769, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,怍,怎,怏, */
	/* 6010 */ 0x5761,0,0x455c,0,0x744b,0x5766,0x495d,0x2c47, 0x744c,0x5760,0,0x5765,0x4e67,0x3b57,0,0, /* 怐,0,怒,0,怔,怕,怖,怗, 怘,怙,0,怛,怜,思,0,0, */
	/* 6020 */ 0x4255,0x575e,0x2c48,0,0x2c49,0x355e,0x5768,0x402d, 0x3165,0x5762,0x3278,0x5767,0,0,0,0x3631, /* 怠,怡,怢,0,怤,急,怦,性, 怨,怩,怪,怫,0,0,0,怯, */
	/* 6030 */ 0,0x5764,0,0x744d,0,0x744e,0,0, 0,0,0x576a,0,0,0,0,0, /* 0,怱,0,怳,0,怵,0,0, 0,0,怺,0,0,0,0,0, */
	/* 6040 */ 0,0x576c,0x5776,0x5774,0,0,0x5771,0x744f, 0,0,0x5770,0x4e78,0x2c4b,0x5772,0,0, /* 0,恁,恂,恃,0,0,恆,恇, 0,0,恊,恋,恌,恍,0,0, */
	/* 6050 */ 0x3632,0,0x3931,0,0,0x3d7a,0,0, 0,0x5779,0x576b,0,0,0,0,0x576f, /* 恐,0,恒,0,0,恕,0,0, 0,恙,恚,0,0,0,0,恟, */
	/* 6060 */ 0x575f,0,0x327a,0x5773,0x5775,0x4351,0,0, 0x3a28,0x3238,0x576d,0x5778,0x5777,0x3633,0,0x4229, /* 恠,0,恢,恣,恤,恥,0,0, 恨,恩,恪,恫,恬,恭,0,息, */
	/* 6070 */ 0x3366,0,0,0,0,0x3743,0,0x576e, 0,0,0,0,0,0,0,0x2c4c, /* 恰,0,0,0,0,恵,0,恷, 0,0,0,0,0,0,0,恿, */
	/* 6080 */ 0,0x577a,0,0x577d,0x5821,0,0,0, 0,0x3c3d,0x2c4d,0x5827,0x4470,0x577b,0,0, /* 0,悁,0,悃,悄,0,0,0, 0,悉,悊,悋,悌,悍,0,0, */
	/* 6090 */ 0,0,0x5825,0,0x3279,0x2c4e,0x5823,0x5824, 0,0,0x577e,0x5822,0,0x7451,0x7452,0x3867, /* 0,0,悒,0,悔,悕,悖,悗, 0,0,悚,悛,0,悝,悞,悟, */
	/* 60a0 */ 0x4d2a,0,0,0x3435,0,0,0x3159,0x5826, 0x2c4f,0x473a,0x302d,0,0,0,0,0, /* 悠,0,0,患,0,0,悦,悧, 您,悩,悪,0,0,0,0,0, */
	/* 60b0 */ 0x2c51,0x2c52,0x4861,0x575c,0x582c,0x5830,0x4c65,0, 0x5829,0,0,0,0x4569,0x582e,0x2c53,0, /* 悰,悱,悲,悳,悴,悵,悶,0, 悸,0,0,0,悼,悽,悾,0, */
	/* 60c0 */ 0,0,0,0,0,0x3e70,0x582f,0x4657, 0x2c54,0,0,0x7453,0,0,0,0, /* 0,0,0,0,0,情,惆,惇, 惈,0,0,惋,0,0,0,0, */
	/* 60d0 */ 0,0x4f47,0,0x582b,0x7454,0x7455,0,0, 0x5831,0x2c55,0x397b,0x2c56,0x404b,0x7456,0,0x3054, /* 0,惑,0,惓,惔,惕,0,0, 惘,惙,惚,惛,惜,惝,0,惟, */
	/* 60e0 */ 0x582a,0x5828,0,0x415a,0,0,0,0x577c, 0x3b34,0,0,0,0,0,0x2c57,0, /* 惠,惡,0,惣,0,0,0,惧, 惨,0,0,0,0,0,惮,0, */
	/* 60f0 */ 0x4246,0x583d,0x2c58,0x415b,0x5838,0x2c59,0x5835,0x5836, 0x7457,0x3c66,0x5839,0x583c,0,0,0,0, /* 惰,惱,惲,想,惴,惵,惶,惷, 惸,惹,惺,惻,0,0,0,0, */
	/* 6100 */ 0x5837,0x3d25,0,0x583a,0,0,0x5834,0, 0x4c7c,0x4c7b,0,0,0,0x583e,0x583f,0x3055, /* 愀,愁,0,愃,0,0,愆,0, 愈,愉,0,0,0,愍,愎,意, */
	/* 6110 */ 0x2c5a,0,0x2c5b,0x2c5c,0,0x5833,0,0, 0,0x2c5d,0x3672,0x3026,0x7458,0,0x2c5e,0x3436, /* 愐,0,愒,愓,0,愕,0,0, 0,愙,愚,愛,愜,0,愞,感, */
	/* 6120 */ 0,0x583b,0,0,0,0,0,0x5843, 0x5842,0,0,0x7459,0x5847,0,0,0, /* 0,愡,0,0,0,0,0,愧, 愨,0,0,愫,愬,0,0,0, */
	/* 6130 */ 0x745a,0,0,0,0x5848,0,0,0x745b, 0,0,0x2c5f,0,0x5846,0x5849,0x5841,0x5845, /* 愰,0,0,0,愴,0,0,愷, 0,0,愺,0,愼,愽,愾,愿, */
	/* 6140 */ 0,0x2c61,0x584a,0,0x584b,0,0x2c62,0x5840, 0x3b7c,0,0x5844,0x4256,0x3932,0x5832,0x3f35,0, /* 0,慁,慂,0,慄,0,慆,慇, 慈,0,慊,態,慌,慍,慎,0, */
	/* 6150 */ 0,0,0,0x5858,0,0x4a69,0,0, 0x584e,0x584f,0x5850,0,0,0x5857,0,0x5856, /* 0,0,0,慓,0,慕,0,0, 慘,慙,慚,0,0,慝,0,慟, */
	/* 6160 */ 0x2c63,0,0x4b7d,0x3437,0,0x5854,0,0x3745, 0x3334,0,0,0x5851,0,0,0x4e38,0x5853, /* 慠,0,慢,慣,0,慥,0,慧, 慨,0,0,慫,0,0,慮,慯, */
	/* 6170 */ 0x3056,0x5855,0,0x584c,0x5852,0x5859,0x3744,0x584d, 0,0,0,0,0x2c64,0,0x4d5d,0, /* 慰,慱,0,慳,慴,慵,慶,慷, 0,0,0,0,慼,0,慾,0, */
	/* 6180 */ 0,0,0x4d2b,0,0,0,0,0x585c, 0,0,0x5860,0,0,0x745d,0x417e,0, /* 0,0,憂,0,0,0,0,憇, 0,0,憊,0,0,憍,憎,0, */
	/* 6190 */ 0x4e79,0x5861,0x2c66,0x2c67,0x585e,0,0x585b,0x2c68, 0x2c69,0x585a,0x585f,0,0,0,0,0, /* 憐,憑,憒,憓,憔,0,憖,憗, 憘,憙,憚,0,0,0,0,0, */
	/* 61a0 */ 0,0,0,0,0x4a30,0x2c6a,0,0x4634, 0x2c6b,0x3746,0,0x5862,0x585d,0x2c6c,0x5863,0, /* 0,0,0,0,憤,憥,0,憧, 憨,憩,0,憫,憬,憭,憮,0, */
	/* 61b0 */ 0,0,0x377b,0,0,0,0x3231,0, 0,0x7460,0x586b,0,0x745f,0,0x3438,0, /* 0,0,憲,0,0,0,憶,0, 0,憹,憺,0,憼,0,憾,0, */
	/* 61c0 */ 0,0,0,0x5869,0,0,0x586a,0x3a29, 0x5868,0x5866,0x5865,0x586c,0x5864,0x586e,0,0, /* 0,0,0,懃,0,0,懆,懇, 懈,應,懊,懋,懌,懍,0,0, */
	/* 61d0 */ 0x327b,0,0,0,0,0x2c6e,0,0, 0,0,0,0,0,0x2c6f,0,0x2c70, /* 懐,0,0,0,0,懕,0,0, 0,0,0,0,0,懝,0,懟, */
	/* 61e0 */ 0,0,0,0x5870,0,0,0x586f,0, 0,0,0,0,0,0,0,0, /* 0,0,0,懣,0,0,懦,0, 0,0,0,0,0,0,0,0, */
	/* 61f0 */ 0,0,0x4428,0,0x5873,0x2c71,0x5871,0x5867, 0x377c,0,0x5872,0,0x5876,0x5875,0x5877,0x5874, /* 0,0,懲,0,懴,懵,懶,懷, 懸,0,懺,0,懼,懽,懾,懿, */
	/* 6200 */ 0x5878,0,0,0,0,0,0,0, 0x5879,0x587a,0x4a6a,0,0x587c,0x587b,0x3d3f,0, /* 戀,0,0,0,0,0,0,0, 戈,戉,戊,0,戌,戍,戎,0, */
	/* 6210 */ 0x402e,0x3266,0x327c,0,0x587d,0x2c73,0x303f,0, 0,0,0x404c,0x587e,0,0x6c43,0x5921,0x3761, /* 成,我,戒,0,戔,戕,或,0, 0,0,戚,戛,0,戝,戞,戟, */
	/* 6220 */ 0,0x5922,0x7462,0x2c74,0,0,0x406f,0, 0,0x2c75,0x5923,0,0,0,0x5924,0x353a, /* 0,戡,戢,戣,0,0,戦,0, 0,戩,截,0,0,0,戮,戯, */
	/* 6230 */ 0x5925,0,0x5926,0x5927,0x4257,0,0,0, 0x384d,0,0,0x4c61,0,0,0x7463,0x4b3c, /* 戰,0,戲,戳,戴,0,0,0, 戸,0,0,戻,0,0,戾,房, */
	/* 6240 */ 0x3d6a,0x5928,0,0x7464,0,0,0x2c76,0x4070, 0x6e3d,0x4862,0,0x3c6a,0x2c77,0x3a4d,0x5929,0, /* 所,扁,0,扃,0,0,扆,扇, 扈,扉,0,手,扌,才,扎,0, */
	/* 6250 */ 0,0x2c78,0x2c79,0x4247,0,0x4a27,0x7465,0, 0x4271,0,0x7466,0x592c,0,0,0x592a,0, /* 0,扑,扒,打,0,払,扖,0, 托,0,扚,扛,0,0,扞,0, */
	/* 6260 */ 0x592d,0x2c7a,0,0x592b,0x2c7b,0,0,0, 0x592e,0,0,0,0,0x2c7d,0x4a31,0x7467, /* 扠,扡,0,扣,扤,0,0,0, 扨,0,0,0,0,扭,扮,扯, */
	/* 6270 */ 0,0x3037,0,0x2c7e,0,0,0x495e,0, 0,0x4863,0,0x2c7c,0x592f,0,0x5932,0x3e35, /* 0,扱,0,扳,0,0,扶,0, 0,批,0,扻,扼,0,找,承, */
	/* 6280 */ 0x353b,0,0x5930,0x5937,0x3e36,0x7468,0,0, 0,0x5931,0x4744,0,0,0,0,0, /* 技,0,抂,抃,抄,抅,0,0, 0,抉,把,0,0,0,0,0, */
	/* 6290 */ 0,0x4d5e,0x5933,0x5934,0x5938,0x456a,0x5935,0x3933, 0x405e,0x2d21,0,0x5946,0x4834,0,0x4272,0, /* 0,抑,抒,抓,抔,投,抖,抗, 折,抙,0,抛,抜,0,択,0, */
	/* 62a0 */ 0,0,0,0,0,0,0x2d22,0, 0,0,0,0x4864,0x5a2d,0,0,0, /* 0,0,0,0,0,0,抦,0, 0,0,0,披,抬,0,0,0, */
	/* 62b0 */ 0,0x4a7a,0,0,0,0x4471,0,0, 0,0x4b75,0,0x593b,0x3221,0x436a,0,0, /* 0,抱,0,0,0,抵,0,0, 0,抹,0,抻,押,抽,0,0, */
	/* 62c0 */ 0,0,0x5944,0,0x7469,0x4334,0x593e,0x5945, 0x5940,0x5947,0x5943,0,0x5942,0x476f,0,0x593c, /* 0,0,拂,0,拄,担,拆,拇, 拈,拉,拊,0,拌,拍,0,拏, */
	/* 62d0 */ 0x327d,0x593a,0x3571,0x4273,0x5936,0x2d23,0x746a,0x5939, 0x3934,0x405b,0,0x3e37,0x5941,0x4752,0,0, /* 拐,拑,拒,拓,拔,拕,拖,拗, 拘,拙,0,招,拜,拝,0,0, */
	/* 62e0 */ 0x3572,0x3348,0,0,0,0,0,0, 0,0,0,0,0x3367,0x3f21,0x5949,0x594e, /* 拠,拡,0,0,0,0,0,0, 0,0,0,0,括,拭,拮,拯, */
	/* 62f0 */ 0,0x594a,0,0x377d,0,0x594f,0x3b22,0x3969, 0,0,0,0,0x746b,0x2d25,0x3d26,0x593d, /* 0,拱,0,拳,0,拵,拶,拷, 0,0,0,0,拼,拽,拾,拿, */
	/* 6300 */ 0,0x3b7d,0x594c,0x2d26,0,0,0,0x3b58, 0x594d,0x3044,0x746c,0,0x5948,0x2d27,0,0, /* 0,持,挂,挃,0,0,0,指, 挈,按,挊,0,挌,挍,0,0, */
	/* 6310 */ 0x2d28,0x4429,0,0,0,0,0,0, 0x746d,0x3573,0,0,0,0,0,0x3634, /* 挐,挑,0,0,0,0,0,0, 挘,挙,0,0,0,0,0,挟, */
	/* 6320 */ 0,0,0,0,0,0,0,0x594b, 0x3027,0,0,0x3a43,0,0,0,0x3f36, /* 0,0,0,0,0,0,0,挧, 挨,0,0,挫,0,0,0,振, */
	/* 6330 */ 0,0,0x2d2b,0,0,0x2d2c,0,0, 0,0x746e,0x4472,0x2d2d,0x2d2e,0x4854,0x5951,0x415e, /* 0,0,挲,0,0,挵,0,0, 0,挹,挺,挻,挼,挽,挾,挿, */
	/* 6340 */ 0,0x2d2f,0,0x746f,0x2d30,0,0,0, 0,0x422a,0,0,0x3b2b,0x5952,0x2d31,0x5954, /* 0,捁,0,捃,捄,0,0,0, 0,捉,0,0,捌,捍,捎,捏, */
	/* 6350 */ 0x5950,0,0,0,0,0x4a61,0,0x443d, 0,0x2d33,0,0,0x415c,0,0,0, /* 捐,0,0,0,0,捕,0,捗, 0,捙,0,0,捜,0,0,0, */
	/* 6360 */ 0,0,0,0,0,0x7470,0,0x4a7b, 0x3c4e,0x5960,0,0x595f,0x2d36,0,0x3f78,0, /* 0,0,0,0,0,捥,0,捧, 捨,捩,0,捫,捬,0,据,0, */
	/* 6370 */ 0,0,0x377e,0,0,0,0x5959,0x3e39, 0,0,0x4668,0x4731,0x7471,0,0,0, /* 0,0,捲,0,0,0,捶,捷, 0,0,捺,捻,捼,0,0,0, */
	/* 6380 */ 0x5957,0,0,0x415d,0x2d37,0,0,0, 0x3c78,0x595c,0,0,0x3e38,0,0x5956,0x595b, /* 掀,0,0,掃,掄,0,0,0, 授,掉,0,0,掌,0,掎,掏, */
	/* 6390 */ 0,0,0x4753,0,0x2d3a,0,0x5955,0, 0x3721,0x2d38,0,0x335d,0,0,0,0x595d, /* 0,0,排,0,掔,0,掖,0, 掘,掙,0,掛,0,0,0,掟, */
	/* 63a0 */ 0x4e2b,0x3a4e,0x4335,0x595a,0,0x405c,0,0x3935, 0x3f64,0x3166,0x413c,0x5958,0x3545,0,0,0, /* 掠,採,探,掣,0,接,0,控, 推,掩,措,掫,掬,0,0,0, */
	/* 63b0 */ 0,0,0x3747,0,0x444f,0x595e,0,0, 0,0,0,0x415f,0,0x2d3b,0x5961,0, /* 0,0,掲,0,掴,掵,0,0, 0,0,0,掻,0,掽,掾,0, */
	/* 63c0 */ 0x5963,0,0,0x4237,0x5969,0,0x5964,0, 0,0x5966,0,0,0,0,0,0x4941, /* 揀,0,0,揃,揄,0,揆,0, 0,揉,0,0,0,0,0,描, */
	/* 63d0 */ 0x4473,0,0x5967,0,0x2d3d,0x2d3e,0x4d2c,0, 0,0,0x4d48,0x3439,0x2d3f,0,0,0, /* 提,0,插,0,揔,揕,揖,0, 0,0,揚,換,揜,0,0,0, */
	/* 63e0 */ 0x2d40,0x302e,0,0x5965,0,0x7472,0,0, 0,0x5962,0,0x2d41,0x2d42,0x7473,0x3478,0, /* 揠,握,0,揣,0,揥,0,0, 0,揩,0,揫,揬,揭,揮,0, */
	/* 63f0 */ 0,0,0x2d43,0,0x3167,0x7474,0x5968,0x2d3c, 0,0,0x4d49,0,0,0,0,0, /* 0,0,揲,0,援,揵,揶,揷, 0,0,揺,0,0,0,0,0, */
	/* 6400 */ 0,0,0,0,0,0,0x596c,0, 0,0x2d44,0,0,0,0x423b,0,0x5973, /* 0,0,0,0,0,0,搆,0, 0,搉,0,0,0,損,0,搏, */
	/* 6410 */ 0x7475,0,0,0x596d,0x7476,0,0x596a,0x5971, 0,0,0,0,0x5953,0,0x2d45,0, /* 搐,0,0,搓,搔,0,搖,搗, 0,0,0,0,搜,0,搞,0, */
	/* 6420 */ 0,0,0x7477,0,0,0x2d46,0x596e,0, 0x5972,0x2d47,0,0,0x4842,0x456b,0,0x2d48, /* 0,0,搢,0,0,搥,搦,0, 搨,搩,0,0,搬,搭,0,搯, */
	/* 6430 */ 0,0,0,0,0x596b,0,0x596f,0, 0,0,0x3748,0,0,0,0x3a71,0, /* 0,0,0,0,搴,0,搶,0, 0,0,携,0,0,0,搾,0, */
	/* 6440 */ 0,0,0x405d,0,0,0,0,0, 0,0,0,0,0,0,0x5977,0, /* 0,0,摂,0,0,0,0,0, 0,0,0,0,0,0,摎,0, */
	/* 6450 */ 0,0x7479,0,0,0,0,0,0, 0x4526,0,0x2d49,0x2d4a,0,0x2d4b,0,0, /* 0,摑,0,0,0,0,0,0, 摘,0,摚,摛,0,摝,0,0, */
	/* 6460 */ 0x747a,0,0,0,0,0,0,0x5974, 0,0x4b60,0,0,0,0x747b,0,0x5975, /* 摠,0,0,0,0,0,0,摧, 0,摩,0,0,0,摭,0,摯, */
	/* 6470 */ 0,0,0,0x2d4c,0,0,0x5976,0, 0x4c4e,0x7478,0x4022,0,0,0x2d4d,0,0, /* 0,0,0,摳,0,0,摶,0, 摸,摹,摺,0,0,摽,0,0, */
	/* 6480 */ 0,0,0,0x3762,0,0,0,0x2d4e, 0x597d,0,0,0,0,0,0,0, /* 0,0,0,撃,0,0,0,撇, 撈,0,0,0,0,0,0,0, */
	/* 6490 */ 0,0x2d4f,0x3b35,0x597a,0,0x5979,0,0, 0,0,0x4732,0,0,0x2d50,0x4635,0x2d51, /* 0,撑,撒,撓,0,撕,0,0, 0,0,撚,0,0,撝,撞,撟, */
	/* 64a0 */ 0,0,0,0,0x4531,0x597b,0,0, 0,0x597c,0,0x496f,0,0x4745,0x3b23,0, /* 0,0,0,0,撤,撥,0,0, 0,撩,0,撫,0,播,撮,0, */
	/* 64b0 */ 0x4071,0,0x4b50,0,0,0,0,0, 0,0x3349,0,0x5a25,0x597e,0,0x747d,0x747e, /* 撰,0,撲,0,0,0,0,0, 0,撹,0,撻,撼,0,撾,撿, */
	/* 64c0 */ 0,0x4d4a,0x5a27,0,0x7521,0x5a23,0,0x5a24, 0,0,0x7522,0x2d52,0x2d53,0x4160,0x747c,0, /* 0,擁,擂,0,擄,擅,0,擇, 0,0,擊,擋,擌,操,擎,0, */
	/* 64d0 */ 0x7523,0,0x5a22,0,0x593f,0x2d54,0,0x2d55, 0x5a26,0,0x5a21,0,0,0,0,0, /* 擐,0,擒,0,擔,擕,0,擗, 擘,0,據,0,0,0,0,0, */
	/* 64e0 */ 0x5a2b,0x5a2c,0x4527,0x5a2e,0x2d57,0x2d58,0x3b24,0x5a29, 0,0,0,0,0x353c,0,0,0x5a2f, /* 擠,擡,擢,擣,擤,擥,擦,擧, 0,0,0,0,擬,0,0,擯, */
	/* 64f0 */ 0,0x5a28,0x5a33,0,0x5a32,0,0x5a31,0x7524, 0,0,0x5a34,0x7525,0,0x5a36,0x3e71,0x2d59, /* 0,擱,擲,0,擴,0,擶,擷, 0,0,擺,擻,0,擽,擾,擿, */
	/* 6500 */ 0x5a35,0,0,0,0x2d5a,0x5a39,0,0, 0,0,0,0,0,0,0,0x2d5c, /* 攀,0,0,0,攄,攅,0,0, 0,0,0,0,0,0,0,攏, */
	/* 6510 */ 0,0,0,0,0x2d5d,0,0x2d5e,0, 0x5a37,0,0,0,0x5a38,0x5970,0x2d60,0, /* 0,0,0,0,攔,0,攖,0, 攘,0,0,0,攜,攝,攞,0, */
	/* 6520 */ 0,0,0x7526,0x5a3b,0x5a3a,0,0,0, 0,0x7527,0x5978,0x5a3c,0x5a30,0,0,0x3b59, /* 0,0,攢,攣,攤,0,0,0, 0,攩,攪,攫,攬,0,0,支, */
	/* 6530 */ 0,0,0x2d61,0,0x5a3d,0x5a3e,0x5a40,0x5a3f, 0x5a41,0x327e,0,0x3936,0,0,0x4a7c,0x402f, /* 0,0,攲,0,攴,攵,收,攷, 攸,改,0,攻,0,0,放,政, */
	/* 6540 */ 0,0,0,0,0x2d62,0x384e,0,0, 0x5a43,0,0,0,0,0x5a46,0,0x4952, /* 0,0,0,0,敄,故,0,0, 效,0,0,0,0,敍,0,敏, */
	/* 6550 */ 0,0x355f,0,0,0x2d63,0x5a45,0x5a44,0x4754, 0x5a47,0x3635,0,0,0,0x5a49,0x5a48,0, /* 0,救,0,0,敔,敕,敖,敗, 敘,教,0,0,0,敝,敞,0, */
	/* 6560 */ 0,0,0x343a,0x3b36,0,0,0x4658,0x7529, 0,0,0,0x2d64,0x3749,0,0,0, /* 0,0,敢,散,0,0,敦,敧, 0,0,0,敫,敬,0,0,0, */
	/* 6570 */ 0x3f74,0,0x5a4a,0,0x4030,0x4528,0,0x495f, 0x5a4b,0,0x2d65,0,0,0,0,0, /* 数,0,敲,0,整,敵,0,敷, 數,0,敺,0,0,0,0,0, */
	/* 6580 */ 0,0x2d66,0x5a4c,0x5a4d,0x2d67,0x2d68,0,0x4a38, 0x555d,0x4046,0x2d69,0,0x494c,0,0x3a58,0, /* 0,斁,斂,斃,斄,斅,0,文, 斈,斉,斊,0,斌,0,斎,0, */
	/* 6590 */ 0x4865,0x4843,0,0,0,0,0,0x454d, 0,0x4e41,0,0x5a4f,0x3c50,0x752a,0,0x5a50, /* 斐,斑,0,0,0,0,0,斗, 0,料,0,斛,斜,斝,0,斟, */
	/* 65a0 */ 0,0x3036,0,0,0x3654,0x404d,0,0x4960, 0,0,0,0x5a51,0x3b42,0x4347,0,0x3b5b, /* 0,斡,0,0,斤,斥,0,斧, 0,0,0,斫,斬,断,0,斯, */
	/* 65b0 */ 0x3f37,0,0x2d6a,0,0,0x2d6b,0,0x5a52, 0x2d6c,0x4a7d,0,0,0x3177,0x3b5c,0,0x2d6d, /* 新,0,斲,0,0,斵,0,斷, 斸,方,0,0,於,施,0,斿, */
	/* 65c0 */ 0,0x5a55,0x2d6e,0x5a53,0x5a56,0x4e39,0x5a54,0, 0,0x2d6f,0,0x407b,0x5a57,0,0,0x4232, /* 0,旁,旂,旃,旄,旅,旆,0, 0,旉,0,旋,旌,0,0,族, */
	/* 65d0 */ 0,0,0x5a58,0,0x2d70,0,0,0x347a, 0,0x5a5a,0,0x5a59,0,0,0,0, /* 0,0,旒,0,旔,0,0,旗, 0,旙,0,旛,0,0,0,0, */
	/* 65e0 */ 0x5a5b,0x5a5c,0x347b,0,0,0x467c,0x4336,0x356c, 0x3b5d,0x4161,0,0,0x3d5c,0x3030,0,0, /* 无,旡,既,0,0,日,旦,旧, 旨,早,0,0,旬,旭,0,0, */
	/* 65f0 */ 0,0x5a5d,0x2d72,0,0,0,0,0, 0,0x2d73,0x3222,0x5a61,0x2d74,0,0,0, /* 0,旱,旲,0,0,0,0,0, 0,旹,旺,旻,旼,0,0,0, */
	/* 6600 */ 0x752c,0,0x3937,0x5a60,0x2d75,0,0x3a2b,0x3e3a, 0x2d76,0x752d,0x5a5f,0,0x3e3b,0,0x4c40,0x3a2a, /* 昀,0,昂,昃,昄,0,昆,昇, 昈,昉,昊,0,昌,0,明,昏, */
	/* 6610 */ 0,0,0,0x3057,0x404e,0x752e,0,0, 0,0,0,0,0x5a66,0,0x752f,0x4031, /* 0,0,0,易,昔,昕,0,0, 0,0,0,0,昜,0,昞,星, */
	/* 6620 */ 0x3147,0x2d77,0x7531,0,0x7532,0x3d55,0,0x4b66, 0x3a72,0,0x2d78,0x7533,0,0x3e3c,0,0x4027, /* 映,昡,昢,0,昤,春,0,昧, 昨,0,昪,昫,0,昭,0,是, */
	/* 6630 */ 0x7534,0x7535,0,0x7536,0x5a65,0x5a63,0x5a64,0, 0,0,0x7530,0,0x436b,0,0,0x5b26, /* 昰,昱,0,昳,昴,昵,昶,0, 0,0,昺,0,昼,0,0,昿, */
	/* 6640 */ 0,0x5a6a,0x3b7e,0x3938,0x5a68,0x2d79,0,0, 0x7538,0x5a69,0,0x3f38,0x7539,0,0x2d7b,0x5a67, /* 0,晁,時,晃,晄,晅,0,0, 晈,晉,0,晋,晌,0,晎,晏, */
	/* 6650 */ 0,0x2d7a,0x3b2f,0,0,0,0,0x2d7e, 0,0x753b,0x753c,0x2e21,0,0x5a6c,0x5a6b,0x5a70, /* 0,晑,晒,0,0,0,0,晗, 0,晙,晚,晛,0,晝,晞,晟, */
	/* 6660 */ 0,0x753d,0x5a71,0x2e22,0x5a6d,0x753e,0x3322,0x5a6e, 0x5a6f,0x4855,0x2e25,0x2e26,0x2e27,0x2e28,0x4961,0x374a, /* 0,晡,晢,晣,晤,晥,晦,晧, 晨,晩,晪,晫,晬,晭,普,景, */
	/* 6670 */ 0x5a72,0,0,0x753f,0x4032,0,0x3e3d,0x7540, 0x7541,0,0x4352,0x2e29,0,0,0,0, /* 晰,0,0,晳,晴,0,晶,晷, 晸,0,智,晻,0,0,0,0, */
	/* 6680 */ 0x2e2a,0x3647,0,0x5a73,0x5a77,0,0,0x324b, 0x5a74,0x5a76,0,0,0,0x7542,0x5a75,0, /* 暀,暁,0,暃,暄,0,0,暇, 暈,暉,0,0,0,暍,暎,0, */
	/* 6690 */ 0x2e2b,0x3d6b,0x2e2c,0,0,0,0x4348,0x3045, 0x5a78,0x2e2d,0,0,0,0x5a79,0,0, /* 暐,暑,暒,0,0,0,暖,暗, 暘,暙,0,0,0,暝,0,0, */
	/* 66a0 */ 0x7544,0,0x442a,0,0,0,0x4e71,0, 0,0,0,0x3b43,0,0x2e2f,0x4a6b,0, /* 暠,0,暢,0,0,0,暦,0, 0,0,0,暫,0,暭,暮,0, */
	/* 66b0 */ 0,0x2e30,0x7545,0,0x4b3d,0x2e31,0,0, 0x5b22,0x5a7b,0,0x7546,0x5a7e,0,0x5a7d,0x2e33, /* 0,暱,暲,0,暴,暵,0,0, 暸,暹,0,暻,暼,0,暾,暿, */
	/* 66c0 */ 0,0x5a7a,0,0,0x5b21,0,0x7547,0x465e, 0x7548,0x5a7c,0,0,0,0,0,0, /* 0,曁,0,0,曄,0,曆,曇, 曈,曉,0,0,0,0,0,0, */
	/* 66d0 */ 0,0,0,0,0,0,0x5b23,0, 0,0x3d6c,0x5b24,0x754a,0x4d4b,0x4778,0,0, /* 0,0,0,0,0,0,曖,0, 0,曙,曚,曛,曜,曝,0,0, */
	/* 66e0 */ 0x5b25,0,0,0,0,0,0x5b27,0, 0x754b,0x5b28,0,0,0x2e35,0,0,0, /* 曠,0,0,0,0,0,曦,0, 曨,曩,0,0,曬,0,0,0, */
	/* 66f0 */ 0x5b29,0,0x364a,0x3148,0x3939,0x5b2a,0,0x5b2b, 0x3d71,0x4162,0x754c,0x7537,0x5258,0x413e,0x413d,0x4258, /* 曰,0,曲,曳,更,曵,0,曷, 書,曹,曺,曻,曼,曽,曾,替, */
	/* 6700 */ 0x3a47,0x2e37,0,0x5072,0,0x2e38,0,0, 0x376e,0x4d2d,0,0x4a7e,0,0x497e,0,0x5b2c, /* 最,朁,0,會,0,朅,0,0, 月,有,0,朋,0,服,0,朏, */
	/* 6710 */ 0,0,0x2e39,0x754d,0x3a73,0x443f,0x5b2d,0x4f2f, 0,0x2e3b,0,0x4b3e,0,0x442b,0x5b2e,0x347c, /* 0,0,朒,朓,朔,朕,朖,朗, 0,朙,0,望,0,朝,朞,期, */
	/* 6720 */ 0,0,0,0,0,0,0x5b2f,0x5b30, 0x4c5a,0,0x4c24,0x4b76,0x4b5c,0x3b25,0x5b32,0, /* 0,0,0,0,0,0,朦,朧, 木,0,未,末,本,札,朮,0, */
	/* 6730 */ 0,0x3c6b,0,0x754f,0x4b51,0,0x5b34,0x5b37, 0x5b36,0,0x3479,0,0,0x3560,0,0x5b33, /* 0,朱,0,朳,朴,0,朶,朷, 朸,0,机,0,0,朽,0,朿, */
	/* 6740 */ 0,0x5b35,0,0,0,0,0x5b38,0x7551, 0x7552,0x3f79,0,0,0x2e3e,0x2e3f,0x4d7b,0x3049, /* 0,杁,0,0,0,0,杆,杇, 杈,杉,0,0,杌,杍,李,杏, */
	/* 6750 */ 0x3a60,0x423c,0,0x3c5d,0x2e40,0,0x3e73,0, 0,0x5b3b,0,0,0x454e,0x2e41,0x5b39,0x422b, /* 材,村,0,杓,杔,0,杖,0, 0,杙,0,0,杜,杝,杞,束, */
	/* 6760 */ 0x5b3a,0x3e72,0x4c5d,0x5b3c,0x5b3d,0x4d68,0x7550,0, 0,0,0x5b42,0,0,0x393a,0,0x4755, /* 杠,条,杢,杣,杤,来,杦,0, 0,0,杪,0,0,杭,0,杯, */
	/* 6770 */ 0x5b3f,0x456c,0x5a5e,0x5a62,0x2e45,0x354f,0x2e46,0x4747, 0,0,0,0x7553,0x5b41,0,0x3e3e,0x4844, /* 杰,東,杲,杳,杴,杵,杶,杷, 0,0,0,杻,杼,0,松,板, */
	/* 6780 */ 0,0x7554,0,0,0,0x5b47,0,0x487a, 0,0x5b3e,0,0x5b44,0x5b43,0,0,0, /* 0,极,0,0,0,枅,0,枇, 0,枉,0,枋,枌,0,0,0, */
	/* 6790 */ 0x404f,0,0x2e48,0x7555,0,0x4b6d,0,0x4e53, 0x7556,0,0x4b67,0x7557,0x324c,0x3b5e,0,0, /* 析,0,枒,枓,0,枕,0,林, 枘,0,枚,枛,果,枝,0,0, */
	/* 67a0 */ 0x4f48,0x5b46,0x3f75,0,0,0,0x5b45,0, 0,0x5b40,0,0,0,0,0,0x384f, /* 枠,枡,枢,0,0,0,枦,0, 0,枩,0,0,0,0,0,枯, */
	/* 67b0 */ 0x2e4c,0,0x2e4d,0x5b4c,0x5b4a,0,0x324d,0x5b48, 0x5b4e,0x5b54,0,0x7558,0,0,0,0, /* 枰,0,枲,枳,枴,0,架,枷, 枸,枹,0,枻,0,0,0,0, */
	/* 67c0 */ 0x755a,0x4248,0,0x2e4e,0x4a41,0,0x5b56,0, 0x2e4f,0,0x4922,0,0,0,0x5b55,0x4770, /* 柀,柁,0,柃,柄,0,柆,0, 柈,0,柊,0,0,0,柎,柏, */
	/* 67d0 */ 0x4b3f,0x343b,0x2e50,0x4077,0x3d40,0,0,0x755b, 0x4453,0x2e51,0x4d2e,0x2e52,0,0x5b51,0x5b50,0, /* 某,柑,柒,染,柔,0,0,柗, 柘,柙,柚,柛,0,柝,柞,0, */
	/* 67e0 */ 0,0,0x5b52,0,0x5b4f,0,0,0x5b57, 0,0x5b4d,0,0,0x5b4b,0,0x5b53,0x5b49, /* 0,0,柢,0,柤,0,0,柧, 0,柩,0,0,柬,0,柮,柯, */
	/* 67f0 */ 0x2e53,0x436c,0,0x4c78,0x3c46,0x3a74,0,0x2e54, 0,0x7559,0,0x3a3a,0x755c,0,0x4b6f,0x3341, /* 柰,柱,0,柳,柴,柵,0,柷, 0,柹,0,査,柼,0,柾,柿, */
	/* 6800 */ 0,0x755d,0x444e,0x464a,0x3149,0,0,0, 0,0,0,0,0,0,0,0, /* 0,栁,栂,栃,栄,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6810 */ 0x2e4b,0,0,0x4072,0,0,0x4034,0x372a, 0x2e58,0,0,0,0,0x755f,0x5b59,0x2e59, /* 栐,0,0,栓,0,0,栖,栗, 栘,0,0,0,0,栝,栞,栟, */
	/* 6820 */ 0,0x393b,0x337c,0,0,0,0,0, 0,0x5b5b,0x3374,0x5b61,0x7560,0x2e5a,0,0, /* 0,校,栢,0,0,0,0,0, 0,栩,株,栫,栬,栭,0,0, */
	/* 6830 */ 0,0x7561,0x5b5e,0x2e5c,0x4073,0,0,0, 0x334b,0x3a2c,0,0x2e5d,0x334a,0x3a4f,0x2e5e,0, /* 0,栱,栲,栳,栴,0,0,0, 核,根,0,栻,格,栽,栾,0, */
	/* 6840 */ 0x5b5c,0x3765,0x374b,0x456d,0x2e5f,0x2e60,0x5b5a,0, 0x3046,0x2e61,0,0,0x2e62,0x5b5d,0x5b5f,0, /* 桀,桁,桂,桃,桄,桅,框,0, 案,桉,0,0,桌,桍,桎,0, */
	/* 6850 */ 0x364d,0x372c,0x755e,0x343c,0x354b,0x2e63,0,0x2e64, 0,0x5b62,0,0x7562,0x3a79,0x4b71,0,0x3b37, /* 桐,桑,桒,桓,桔,桕,0,桗, 0,桙,0,桛,桜,桝,0,桟, */
	/* 6860 */ 0,0,0,0x5b63,0,0,0,0x4930, 0,0,0,0x2e66,0,0,0x2e67,0, /* 0,0,0,档,0,0,0,桧, 0,0,0,桫,0,0,桮,0, */
	/* 6870 */ 0,0,0x7563,0,0x5b6f,0x7564,0x3233,0x5b64, 0,0,0x2e68,0,0x2e69,0,0x5b75,0x5b65, /* 0,0,桲,0,桴,桵,桶,桷, 0,0,桺,0,桼,0,桾,桿, */
	/* 6880 */ 0,0x4e42,0x2e6a,0x5b6c,0,0x475f,0,0, 0,0,0,0,0,0x5b74,0,0x5b67, /* 0,梁,梂,梃,0,梅,0,0, 0,0,0,0,0,梍,0,梏, */
	/* 6890 */ 0x2e6b,0,0,0x3034,0x5b69,0,0x2e6c,0x393c, 0x2e6e,0x2e6f,0x2e70,0x5b6b,0x2e71,0x5b6a,0,0x5b66, /* 梐,0,0,梓,梔,0,梖,梗, 梘,梙,梚,梛,梜,條,0,梟, */
	/* 68a0 */ 0x5b71,0,0x3e3f,0x7566,0,0x7567,0x546d,0x3868, 0x4d7c,0,0x2e72,0x2e73,0,0x5b68,0,0x4474, /* 梠,0,梢,梣,0,梥,梦,梧, 梨,0,梪,梫,0,梭,0,梯, */
	/* 68b0 */ 0x3323,0x3a2d,0x7568,0x5b60,0x2e74,0x5b70,0x3361,0, 0,0x5b6e,0x5b72,0x2e75,0x456e,0,0,0, /* 械,梱,梲,梳,梴,梵,梶,0, 0,梹,梺,梻,梼,0,0,0, */
	/* 68c0 */ 0,0,0,0x2e7a,0x347e,0x2e7b,0x5c32,0, 0x7569,0x4c49,0x5b77,0x347d,0x2e7c,0x5b7e,0,0x2e7d, /* 0,0,0,棃,棄,棅,棆,0, 棈,棉,棊,棋,棌,棍,0,棏, */
	/* 68d0 */ 0x756a,0,0x4b40,0,0x5c21,0x5c23,0x2e7e,0x5c27, 0x5b79,0x2f21,0x432a,0,0,0,0,0x456f, /* 棐,0,棒,0,棔,棕,棖,棗, 棘,棙,棚,0,0,0,0,棟, */
	/* 68e0 */ 0x5c2b,0x5b7c,0,0x5c28,0x2f22,0x2f23,0,0x5c22, 0x756b,0,0,0,0x2f24,0x756c,0x3f39,0x5c2c, /* 棠,棡,0,棣,棤,棥,0,棧, 棨,0,0,0,棬,棭,森,棯, */
	/* 68f0 */ 0x756d,0x756e,0x4033,0,0,0,0,0x2f25, 0,0x5c2a,0x343d,0x2e76,0x756f,0,0,0, /* 棰,棱,棲,0,0,0,0,棷, 0,棹,棺,棻,棼,0,0,0, */
	/* 6900 */ 0x4f50,0x5b76,0,0x2f26,0x5c26,0x3058,0,0x2f27, 0x5b78,0,0x7570,0x4c3a,0x5b7d,0x3f22,0x4447,0x5b73, /* 椀,椁,0,椃,椄,椅,0,椇, 椈,0,椊,椋,椌,植,椎,椏, */
	/* 6910 */ 0,0,0x5c25,0,0,0,0,0, 0,0x3f7a,0x5c2f,0x3371,0x3821,0,0,0, /* 0,0,椒,0,0,0,0,0, 0,椙,椚,椛,検,0,0,0, */
	/* 6920 */ 0,0x5c31,0x5b7a,0x5c30,0,0x5c29,0x5b7b,0, 0x5c2d,0,0x5c2e,0,0,0,0,0, /* 0,椡,椢,椣,0,椥,椦,0, 椨,0,椪,0,0,0,0,0, */
	/* 6930 */ 0x5c3f,0,0,0,0x464e,0x7573,0x5c24,0, 0,0x5c3b,0,0x2f2b,0,0x5c3d,0,0x4458, /* 椰,0,0,0,椴,椵,椶,0, 0,椹,0,椻,0,椽,0,椿, */
	/* 6940 */ 0,0,0x7574,0,0,0,0x2f2d,0, 0,0x7571,0x4d4c,0,0,0,0,0, /* 0,0,楂,0,0,0,楆,0, 0,楉,楊,0,0,0,0,0, */
	/* 6950 */ 0,0,0,0x4976,0x5c38,0x424a,0,0x7575, 0,0x5c3e,0x413f,0,0x5c35,0x5c42,0x5c41,0, /* 0,0,0,楓,楔,楕,0,楗, 0,楙,楚,0,楜,楝,楞,0, */
	/* 6960 */ 0x466f,0x5c40,0x466a,0x7576,0x7577,0,0,0, 0x7578,0x2f2e,0x5c44,0x5c37,0x2f2f,0x3648,0x5c3a,0x3d5d, /* 楠,楡,楢,楣,楤,0,0,0, 楨,楩,楪,楫,楬,業,楮,楯, */
	/* 6970 */ 0,0,0x2f30,0x4760,0x5c3c,0x364b,0,0x5c34, 0x5c36,0x5c33,0x2f31,0,0x4f30,0x335a,0x5c39,0x2f32, /* 0,0,楲,楳,楴,極,0,楷, 楸,楹,楺,0,楼,楽,楾,楿, */
	/* 6980 */ 0x7579,0x5c43,0x3335,0,0,0,0,0, 0,0,0x3a67,0,0,0,0x315d,0, /* 榀,榁,概,0,0,0,0,0, 0,0,榊,0,0,0,榎,0, */
	/* 6990 */ 0,0x5c54,0x2f33,0,0x4f31,0x5c57,0x2f35,0, 0x2f36,0,0,0x3f3a,0x5c56,0,0,0, /* 0,榑,榒,0,榔,榕,榖,0, 榘,0,0,榛,榜,0,0,0, */
	/* 69a0 */ 0x5c55,0,0,0,0,0x757b,0x2f37,0x5c52, 0,0,0,0,0,0x757c,0x5c46,0, /* 榠,0,0,0,0,榥,榦,榧, 0,0,0,0,0,榭,榮,0, */
	/* 69b0 */ 0x2f38,0x5c63,0x5c45,0,0x5c58,0,0,0x2f39, 0,0,0x2f3a,0x5c50,0x2f3b,0,0x5c4b,0x5c48, /* 榰,榱,榲,0,榴,0,0,榷, 0,0,榺,榻,榼,0,榾,榿, */
	/* 69c0 */ 0x2f3c,0x5c49,0,0x5c51,0,0,0,0x7422, 0,0,0x5c4e,0x393d,0x4448,0x4164,0x5c4c,0x757d, /* 槀,槁,0,槃,0,0,0,槇, 0,0,槊,構,槌,槍,槎,槏, */
	/* 69d0 */ 0x5c47,0x2f3d,0,0x5c4a,0,0,0x2f3e,0, 0x4d4d,0x4b6a,0,0,0,0x5c4f,0x5c59,0, /* 槐,槑,0,槓,0,0,槖,0, 様,槙,0,0,0,槝,槞,0, */
	/* 69e0 */ 0,0,0x7622,0x2f44,0,0,0,0x5c61, 0x5c5a,0x7623,0x7624,0x5c67,0,0x5c65,0x2f45,0x2f46, /* 0,0,槢,槣,0,0,0,槧, 槨,槩,槪,槫,0,槭,槮,槯, */
	/* 69f0 */ 0,0,0x5c60,0x2f47,0x2f49,0x7625,0x7626,0, 0,0x5c5f,0,0x4450,0,0x4165,0x2f4a,0x5c5d, /* 0,0,槲,槳,槴,槵,槶,0, 0,槹,0,槻,0,槽,槾,槿, */
	/* 6a00 */ 0,0,0x5c5b,0,0,0x5c62,0,0, 0,0,0x5c68,0x4875,0x5c6e,0,0,0x7627, /* 0,0,樂,0,0,樅,0,0, 0,0,樊,樋,樌,0,0,樏, */
	/* 6a10 */ 0,0x2f4b,0x5c69,0x5c6c,0x5c66,0x7628,0,0x4374, 0,0x4938,0x2f4c,0x5c5c,0,0x2f4d,0x5c64,0x3e40, /* 0,樑,樒,樓,樔,樕,0,樗, 0,標,樚,樛,0,樝,樞,樟, */
	/* 6a20 */ 0,0x4c4f,0x5c78,0x5c6b,0,0,0,0, 0,0x3822,0x3223,0x335f,0,0,0x5c53,0, /* 0,模,樢,樣,0,0,0,0, 0,権,横,樫,0,0,樮,0, */
	/* 6a30 */ 0x2f41,0,0x2f4f,0x2f50,0x2f51,0x3e41,0x5c70,0, 0x5c77,0x3c79,0x3372,0x762a,0,0x432e,0x762b,0x2f52, /* 樰,0,樲,樳,樴,樵,樶,0, 樸,樹,樺,樻,0,樽,樾,樿, */
	/* 6a40 */ 0,0,0,0,0x5c6d,0x762c,0x2f53,0x5c72, 0x5c76,0x2f54,0,0x3636,0,0,0x2f56,0, /* 0,0,0,0,橄,橅,橆,橇, 橈,橉,0,橋,0,0,橎,0, */
	/* 6a50 */ 0x762d,0,0x2f57,0,0,0,0x762e,0, 0x354c,0x5c74,0,0x762f,0,0,0,0x3521, /* 橐,0,橒,0,0,0,橖,0, 橘,橙,0,橛,0,0,0,機, */
	/* 6a60 */ 0,0x464b,0x5c73,0,0x2f58,0,0x5c75,0, 0,0,0,0x7630,0,0,0,0, /* 0,橡,橢,0,橤,0,橦,0, 0,0,0,橫,0,0,0,0, */
	/* 6a70 */ 0,0,0x5c6f,0x7631,0,0,0,0, 0x5c71,0,0x2f55,0,0,0,0x2f5a,0x3360, /* 0,0,橲,橳,0,0,0,0, 橸,0,橺,0,0,0,橾,橿, */
	/* 6a80 */ 0x4349,0,0,0x2f5b,0x5c7c,0,0,0, 0,0x7633,0,0x2f5c,0,0x5c7a,0x3869,0, /* 檀,0,0,檃,檄,0,0,0, 0,檉,0,檋,0,檍,檎,0, */
	/* 6a90 */ 0x5c79,0x2f5e,0,0,0x7634,0,0,0x5d21, 0,0,0,0,0x5b58,0x7635,0x7636,0x2f5f, /* 檐,檑,0,0,檔,0,0,檗, 0,0,0,0,檜,檝,檞,檟, */
	/* 6aa0 */ 0x5c7b,0x2f60,0x5c7d,0x5c7e,0,0x7637,0,0, 0,0,0x5d2c,0x2f62,0x5d28,0,0x5b6d,0, /* 檠,檡,檢,檣,0,檥,0,0, 0,0,檪,檫,檬,0,檮,0, */
	/* 6ab0 */ 0,0,0,0x5d27,0,0,0,0, 0x5d26,0,0,0x5d23,0,0x2f63,0,0, /* 0,0,0,檳,0,0,0,0, 檸,0,0,檻,0,檽,0,0, */
	/* 6ac0 */ 0,0x5c6a,0x5d25,0x5d24,0,0,0x2f64,0, 0,0,0,0,0,0,0,0, /* 0,櫁,櫂,櫃,0,0,櫆,0, 0,0,0,0,0,0,0,0, */
	/* 6ad0 */ 0x2f66,0x5d2a,0,0x4f26,0x2f65,0,0,0, 0,0,0x5d2d,0x367b,0x2f67,0x2f68,0x5d29,0x5d2b, /* 櫐,櫑,0,櫓,櫔,0,0,0, 0,0,櫚,櫛,櫜,櫝,櫞,櫟, */
	/* 6ae0 */ 0,0,0,0,0x7638,0,0,0x7639, 0x4827,0,0x5d2e,0,0x2f6b,0,0,0, /* 0,0,0,0,櫤,0,0,櫧, 櫨,0,櫪,0,櫬,0,0,0, */
	/* 6af0 */ 0,0x2f6c,0x2f6d,0x2f6e,0,0,0,0, 0,0,0x5d32,0x5d2f,0,0x2f6f,0,0, /* 0,櫱,櫲,櫳,0,0,0,0, 0,0,櫺,櫻,0,櫽,0,0, */
	/* 6b00 */ 0,0,0,0,0x4d73,0x5d30,0,0, 0,0,0x5c5e,0x2f71,0,0,0,0x2f72, /* 0,0,0,0,欄,欅,0,0, 0,0,權,欋,0,0,0,欏, */
	/* 6b10 */ 0x2f73,0x2f74,0x5d33,0,0,0,0x5d34,0x2f76, 0,0,0,0x763c,0,0x3135,0x763d,0x5d36, /* 欐,欑,欒,0,0,0,欖,欗, 0,0,0,欛,0,欝,欞,欟, */
	/* 6b20 */ 0x3767,0x3c21,0,0x3655,0,0,0,0x3224, 0,0,0,0,0x763e,0,0,0x2f78, /* 欠,次,0,欣,0,0,0,欧, 0,0,0,0,欬,0,0,欯, */
	/* 6b30 */ 0,0,0x4d5f,0,0,0x763f,0,0x5d38, 0x5d37,0x5d3a,0x353d,0,0,0x3656,0x343e,0, /* 0,0,欲,0,0,欵,0,欷, 欸,欹,欺,0,0,欽,款,0, */
	/* 6b40 */ 0,0,0,0x5d3d,0,0,0x7640,0x5d3c, 0,0x5d3e,0x2f79,0,0x324e,0,0x4337,0, /* 0,0,0,歃,0,0,歆,歇, 0,歉,歊,0,歌,0,歎,0, */
	/* 6b50 */ 0x5d3f,0,0,0x343f,0x5d41,0,0x7641,0, 0x2f7a,0x5d40,0,0x5d42,0,0,0,0x5d43, /* 歐,0,0,歓,歔,0,歖,0, 歘,歙,0,歛,0,0,0,歟, */
	/* 6b60 */ 0x7642,0x5d44,0x3b5f,0x4035,0x3a21,0x7643,0x4970,0x7644, 0,0x4a62,0x4f44,0,0x2f7b,0,0,0x3b75, /* 歠,歡,止,正,此,步,武,歧, 0,歩,歪,0,歬,0,0,歯, */
	/* 6b70 */ 0,0,0,0x3a50,0x4e72,0x2f7c,0,0x7645, 0x5d45,0x5d46,0x2f7d,0x3b60,0,0,0,0x5d47, /* 0,0,0,歳,歴,歵,0,歷, 歸,歹,歺,死,0,0,0,歿, */
	/* 6b80 */ 0x5d48,0x2f7e,0x7646,0x5d4a,0x5d49,0,0x4b58,0, 0,0x3d5e,0x3c6c,0x3b44,0,0x5d4b,0,0, /* 殀,殁,殂,殃,殄,0,殆,0, 0,殉,殊,残,0,殍,0,0, */
	/* 6b90 */ 0,0,0,0,0,0x5d4d,0x3f23,0, 0x5d4c,0,0,0x6e21,0,0,0x5d4e,0, /* 0,0,0,0,0,殕,殖,0, 殘,0,0,殛,0,0,殞,0, */
	/* 6ba0 */ 0,0,0,0,0x5d4f,0,0,0, 0,0x7647,0x5d50,0x5d51,0,0x7648,0x6e22,0x5d52, /* 0,0,0,0,殤,0,0,0, 0,殩,殪,殫,0,殭,殮,殯, */
	/* 6bb0 */ 0,0x5d54,0x5d53,0x5d55,0x3225,0x434a,0,0x5d56, 0,0,0x3b26,0x334c,0x5d57,0x6e24,0x6e25,0x4542, /* 0,殱,殲,殳,殴,段,0,殷, 0,0,殺,殻,殼,殽,殾,殿, */
	/* 6bc0 */ 0x544c,0,0,0,0,0x3523,0x5d58,0x6e26, 0x6e27,0x6e28,0,0x5d59,0,0x4a6c,0x4b68,0x764a, /* 毀,0,0,0,0,毅,毆,毇, 毈,毉,0,毋,0,母,毎,每, */
	/* 6bd0 */ 0,0,0x4647,0x5d5a,0x4866,0,0x764b,0x764c, 0x487b,0,0x6e29,0x4c53,0,0,0,0x5d5b, /* 0,0,毒,毓,比,0,毖,毗, 毘,0,毚,毛,0,0,0,毟, */
	/* 6be0 */ 0,0,0,0,0,0,0x6e2a,0x6e2b, 0,0,0,0x5d5d,0x5d5c,0,0x6e2c,0x5d5f, /* 0,0,0,0,0,0,毦,毧, 0,0,0,毫,毬,0,毮,毯, */
	/* 6bf0 */ 0,0x6e2d,0,0x5d5e,0,0,0,0, 0,0,0,0,0,0,0,0x764d, /* 0,毱,0,毳,0,0,0,0, 0,0,0,0,0,0,0,毿, */
	/* 6c00 */ 0,0,0x6e2e,0,0,0x764e,0,0, 0x5d61,0,0x6e2f,0,0,0,0x6e30,0x3b61, /* 0,0,氂,0,0,氅,0,0, 氈,0,氊,0,0,0,氎,氏, */
	/* 6c10 */ 0x764f,0x4c31,0,0x5d62,0x5d63,0,0,0x3524, 0,0,0,0x5d64,0,0,0,0, /* 氐,民,0,氓,气,0,0,気, 0,0,0,氛,0,0,0,0, */
	/* 6c20 */ 0,0,0,0x5d66,0x5d65,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,氣,氤,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c30 */ 0,0,0,0x7650,0x3f65,0x6e31,0x6e32,0x4939, 0x314a,0,0x6e33,0,0,0,0x4845,0x6e35, /* 0,0,0,氳,水,氵,氶,氷, 永,0,氺,0,0,0,氾,氿, */
	/* 6c40 */ 0x4475,0x3d41,0x3561,0,0,0,0,0, 0,0,0,0,0,0x6e36,0x4846,0, /* 汀,汁,求,0,0,0,0,0, 0,0,0,0,0,汍,汎,0, */
	/* 6c50 */ 0x3c2e,0,0,0,0,0x5d68,0,0x3440, 0,0x7651,0x3178,0x6e37,0x7652,0x4672,0x5d67,0x393e, /* 汐,0,0,0,0,汕,0,汗, 0,汙,汚,汛,汜,汝,汞,江, */
	/* 6c60 */ 0x4353,0,0x5d69,0,0,0,0,0x6e4f, 0x5d71,0,0x5d6a,0,0,0x6e38,0,0, /* 池,0,汢,0,0,0,0,汧, 汨,0,汪,0,0,汭,0,0, */
	/* 6c70 */ 0x4241,0,0x3562,0x5d72,0x7654,0,0x7655,0, 0,0,0x3768,0,0,0x3525,0x5d70,0, /* 汰,0,汲,汳,汴,0,汶,0, 0,0,決,0,0,汽,汾,0, */
	/* 6c80 */ 0,0x5d6e,0x5d6b,0x4d60,0x6e39,0x7656,0x7657,0, 0x4440,0x6e3a,0,0,0x4659,0x5d6c,0,0, /* 0,沁,沂,沃,沄,沅,沆,0, 沈,沉,0,0,沌,沍,0,0, */
	/* 6c90 */ 0x5d74,0,0x5d73,0x3723,0x6e3c,0x6e3d,0x322d,0x6e3e, 0x7658,0x3a3b,0x5d6d,0x5d6f,0x7659,0,0,0, /* 沐,0,沒,沓,沔,沕,沖,沗, 沘,沙,沚,沛,沜,0,0,0, */
	/* 6ca0 */ 0,0x4b57,0x4274,0,0,0,0,0, 0,0,0x7653,0x4b77,0,0x6e3f,0x5d7c,0, /* 0,没,沢,0,0,0,0,0, 0,0,沪,沫,0,沭,沮,0, */
	/* 6cb0 */ 0,0x5d7d,0,0x324f,0,0,0,0, 0x4a28,0x4c7d,0x5e21,0x3c23,0x3e42,0x5d78,0x5d7e,0x3168, /* 0,沱,0,河,0,0,0,0, 沸,油,沺,治,沼,沽,沾,沿, */
	/* 6cc0 */ 0,0x3637,0x6e40,0,0x5d75,0x5d7a,0x765b,0, 0,0x4074,0x4771,0,0x4867,0,0,0, /* 0,況,泂,0,泄,泅,泆,0, 0,泉,泊,0,泌,0,0,0, */
	/* 6cd0 */ 0x6e41,0,0,0x5d77,0x765c,0x4b21,0x6e43,0x5d79, 0,0x5e24,0x6e44,0x5e22,0x6e45,0x5d7b,0,0, /* 泐,0,0,泓,泔,法,泖,泗, 0,泙,泚,泛,泜,泝,0,0, */
	/* 6ce0 */ 0x765d,0x4b22,0x4748,0x3563,0,0x4525,0,0, 0x436d,0x6e46,0x5e25,0x765e,0x6e47,0x6e48,0x765f,0x5e23, /* 泠,泡,波,泣,0,泥,0,0, 注,泩,泪,泫,泬,泭,泮,泯, */
	/* 6cf0 */ 0x4259,0x5d76,0,0x314b,0,0,0,0, 0,0,0,0x765a,0,0,0,0, /* 泰,泱,0,泳,0,0,0,0, 0,0,0,泻,0,0,0,0, */
	/* 6d00 */ 0x6e4a,0,0,0,0x7661,0,0,0, 0,0,0x6e4b,0x4d4e,0x5e30,0,0x7662,0, /* 洀,0,0,0,洄,0,0,0, 0,0,洊,洋,洌,0,洎,0, */
	/* 6d10 */ 0,0,0x5e2f,0,0,0,0,0x4076, 0,0x5e2c,0,0x4d6c,0,0,0x4636,0x5e26, /* 0,0,洒,0,0,0,0,洗, 0,洙,0,洛,0,0,洞,洟, */
	/* 6d20 */ 0,0,0,0,0x6e4c,0x4445,0x6e4d,0x6e4e, 0,0x314c,0x393f,0x5e29,0,0,0x7663,0x6e50, /* 0,0,0,0,洤,津,洦,洧, 0,洩,洪,洫,0,0,洮,洯, */
	/* 6d30 */ 0,0x7664,0x3d27,0x5e2e,0x6e65,0x5e2d,0x5e28,0, 0x5e2b,0x7665,0,0x3368,0x6e51,0x5e2a,0x4749,0x7666, /* 0,洱,洲,洳,洴,洵,洶,0, 洸,洹,0,活,洼,洽,派,洿, */
	/* 6d40 */ 0,0x4e2e,0,0,0x3e74,0x4075,0,0, 0,0,0,0,0,0,0,0, /* 0,流,0,0,浄,浅,0,0, 0,0,0,0,0,0,0,0, */
	/* 6d50 */ 0,0,0,0,0,0,0,0, 0x7667,0x5e36,0x5e34,0x6e52,0x494d,0,0x6e53,0, /* 0,0,0,0,0,0,0,0, 浘,浙,浚,浛,浜,0,浞,0, */
	/* 6d60 */ 0x6e54,0,0,0x5e31,0x5e33,0x7668,0x313a,0, 0,0x3940,0x4f32,0,0x333d,0,0x4962,0, /* 浠,0,0,浣,浤,浥,浦,0, 0,浩,浪,0,浬,0,浮,0, */
	/* 6d70 */ 0x6e55,0,0,0,0x4d61,0,0,0x3324, 0x3f3b,0x5e35,0,0,0,0,0,0, /* 浰,0,0,0,浴,0,0,海, 浸,浹,0,0,0,0,0,0, */
	/* 6d80 */ 0x6e56,0x6e57,0x766a,0,0,0x5e3a,0,0x766b, 0x3e43,0x766c,0x6e58,0,0x4d30,0x6e59,0x5e37,0, /* 涀,涁,涂,0,0,涅,0,涇, 消,涉,涊,0,涌,涍,涎,0, */
	/* 6d90 */ 0,0x6e5a,0,0x5e32,0x766d,0x5e38,0,0, 0x6e5b,0x4e5e,0,0x4573,0x4642,0,0,0, /* 0,涑,0,涓,涔,涕,0,0, 涘,涙,0,涛,涜,0,0,0, */
	/* 6da0 */ 0,0,0,0,0,0,0,0, 0,0,0x766e,0x6e61,0x766f,0,0x6e62,0x3336, /* 0,0,0,0,0,0,0,0, 0,0,涪,涫,涬,0,涮,涯, */
	/* 6db0 */ 0,0,0x3155,0,0x6e63,0x5e3e,0,0, 0x5e41,0,0,0,0x4e43,0,0,0x7670, /* 0,0,液,0,涴,涵,0,0, 涸,0,0,0,涼,0,0,涿, */
	/* 6dc0 */ 0x4d64,0,0x6e64,0,0x7671,0x5e48,0x5e42,0x5e3f, 0x6e66,0,0,0x4e54,0x5e45,0,0x6e67,0x6e68, /* 淀,0,淂,0,淄,淅,淆,淇, 淈,0,0,淋,淌,0,淎,淏, */
	/* 6dd0 */ 0x6e69,0x3d4a,0x5e47,0,0,0x5e4c,0x7672,0, 0x4571,0x5e4a,0x7673,0x7674,0,0x7675,0x5e44,0x6e6a, /* 淐,淑,淒,0,0,淕,淖,0, 淘,淙,淚,淛,0,淝,淞,淟, */
	/* 6de0 */ 0,0x4338,0,0,0x5e4b,0,0x5e40,0, 0x5e46,0x6e6b,0x5e4d,0x307c,0x5e43,0,0x5e4e,0, /* 0,淡,0,0,淤,0,淦,0, 淨,淩,淪,淫,淬,0,淮,0, */
	/* 6df0 */ 0,0x3f3c,0,0x3d5f,0,0x4a25,0x6e6c,0x3a2e, 0,0x5e3b,0x5e49,0x453a,0x7676,0,0,0, /* 0,深,0,淳,0,淵,淶,混, 0,淹,淺,添,淼,0,0,0, */
	/* 6e00 */ 0,0,0,0,0,0x4036,0,0x3369, 0x3a51,0x3e44,0x5e3d,0x3d42,0,0,0,0, /* 0,0,0,0,0,清,0,渇, 済,渉,渊,渋,0,0,0,0, */
	/* 6e10 */ 0,0,0,0x374c,0,0x5e3c,0,0x6e5d, 0,0x5e52,0x3d6d,0x383a,0,0x5e61,0x6e6e,0x5e5b, /* 0,0,0,渓,0,渕,0,渗, 0,渙,渚,減,0,渝,渞,渟, */
	/* 6e20 */ 0x3574,0x454f,0x6e6f,0x5e56,0x5e5f,0x302f,0x3132,0x6e70, 0,0x3239,0,0x5e58,0x422c,0x5e4f,0x5e51,0x3941, /* 渠,渡,渢,渣,渤,渥,渦,渧, 0,温,0,渫,測,渭,渮,港, */
	/* 6e30 */ 0,0,0x6e72,0,0x7678,0,0x6e6d,0, 0x5e62,0,0x5e5d,0,0x6e73,0,0x5e55,0, /* 0,0,渲,0,渴,0,渶,0, 游,0,渺,0,渼,0,渾,0, */
	/* 6e40 */ 0,0,0,0x5e5c,0x7679,0,0,0, 0x6e74,0x6e75,0x4c2b,0x6e76,0x6e77,0x5e5a,0x5e5e,0x6e78, /* 0,0,0,湃,湄,0,0,0, 湈,湉,湊,湋,湌,湍,湎,湏, */
	/* 6e50 */ 0,0x6e79,0,0x6e7a,0x6e7b,0,0x3850,0x6e7c, 0x3e45,0,0,0x4339,0x767a,0,0x767b,0x5e54, /* 0,湑,0,湓,湔,0,湖,湗, 湘,0,0,湛,湜,0,湞,湟, */
	/* 6e60 */ 0,0,0,0x6e7d,0,0,0,0x4d2f, 0,0,0,0x5e57,0,0,0x5e50,0x4572, /* 0,0,0,湣,0,0,0,湧, 0,0,0,湫,0,0,湮,湯, */
	/* 6e70 */ 0,0,0x5e53,0,0,0,0x5e59,0, 0,0,0,0,0,0,0x4f51,0x3c3e, /* 0,0,湲,0,0,0,湶,0, 0,0,0,0,0,0,湾,湿, */
	/* 6e80 */ 0x4b7e,0,0x5e63,0,0,0,0,0, 0,0,0,0,0x482e,0,0,0x5e6f, /* 満,0,溂,0,0,0,0,0, 0,0,0,0,溌,0,0,溏, */
	/* 6e90 */ 0x383b,0,0,0x6f21,0,0,0x3d60,0, 0x5e65,0,0,0,0x4e2f,0x3942,0,0x5e72, /* 源,0,0,溓,0,0,準,0, 溘,0,0,0,溜,溝,0,溟, */
	/* 6ea0 */ 0,0,0x306e,0,0,0x5e70,0,0x6f22, 0,0,0x5e64,0x767c,0,0,0,0x5e6a, /* 0,0,溢,0,0,溥,0,溧, 0,0,溪,溫,0,0,0,溯, */
	/* 6eb0 */ 0,0x767d,0x5e6c,0,0x6f23,0,0x4d4f,0x5e67, 0,0,0x452e,0,0,0x5e69,0,0x6f24, /* 0,溱,溲,0,溴,0,溶,溷, 0,0,溺,0,0,溽,0,溿, */
	/* 6ec0 */ 0,0x767e,0x5e71,0x6f25,0x5e6b,0x4c47,0,0x7721, 0,0x5e66,0x6f26,0x3c22,0x5e7e,0,0x7722,0, /* 0,滁,滂,滃,滄,滅,0,滇, 0,滉,滊,滋,滌,0,滎,0, */
	/* 6ed0 */ 0,0x336a,0,0x5e68,0x5e6d,0x5e6e,0,0, 0,0x6f27,0,0,0,0x426c,0x425a,0, /* 0,滑,0,滓,滔,滕,0,0, 0,滙,0,0,0,滝,滞,0, */
	/* 6ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x6f29,0x5e76,0,0,0x5e7c, /* 0,0,0,0,0,0,0,0, 0,0,0,滫,滬,0,0,滯, */
	/* 6ef0 */ 0,0,0x5e7a,0,0x4529,0,0,0x5f23, 0x5e77,0x6f2a,0,0x6f2b,0,0,0x5e78,0x5e60, /* 0,0,滲,0,滴,0,0,滷, 滸,滹,0,滻,0,0,滾,滿, */
	/* 6f00 */ 0,0x3579,0x493a,0,0,0,0x3c3f,0, 0,0x3977,0x6f2c,0,0x6f2d,0,0,0x4f33, /* 0,漁,漂,0,0,0,漆,0, 0,漉,漊,0,漌,0,0,漏, */
	/* 6f10 */ 0x7723,0x5e74,0,0x5f22,0x3169,0x4166,0,0, 0x6f2e,0,0x7724,0,0,0,0,0, /* 漐,漑,0,漓,演,漕,0,0, 漘,0,漚,0,0,0,0,0, */
	/* 6f20 */ 0x4779,0,0x3441,0x4e7a,0,0x6f2f,0,0, 0,0,0x7726,0x4c21,0x4452,0,0,0x7727, /* 漠,0,漢,漣,0,漥,0,0, 0,0,漪,漫,漬,0,0,漯, */
	/* 6f30 */ 0,0x5e7b,0x5e7d,0x7728,0,0x6f28,0x6f30,0, 0x4132,0,0,0,0x6f31,0,0x5f21,0x5e79, /* 0,漱,漲,漳,0,漵,漶,0, 漸,0,0,0,漼,0,漾,漿, */
	/* 6f40 */ 0,0x5e73,0,0,0,0x3443,0,0, 0,0,0,0,0,0,0,0, /* 0,潁,0,0,0,潅,0,0, 0,0,0,0,0,0,0,0, */
	/* 6f50 */ 0,0x7729,0x6f33,0,0x3769,0,0,0x6f34, 0x5f2f,0x772a,0x6f35,0x5f2a,0x4078,0,0x772b,0x3363, /* 0,潑,潒,0,潔,0,0,潗, 潘,潙,潚,潛,潜,0,潞,潟, */
	/* 6f60 */ 0x6f36,0x772c,0x772d,0,0x3d61,0,0x5f33,0, 0x6f37,0,0,0,0,0x5f2c,0x442c,0x5f29, /* 潠,潡,潢,0,潤,0,潦,0, 潨,0,0,0,0,潭,潮,潯, */
	/* 6f70 */ 0x4459,0,0,0,0x5f4c,0,0,0, 0x5f26,0,0x5f25,0,0x5f2e,0x6f39,0x772e,0, /* 潰,0,0,0,潴,0,0,0, 潸,0,潺,0,潼,潽,潾,0, */
	/* 6f80 */ 0x5f28,0x5f27,0x5f2d,0,0x4021,0,0x5f24,0, 0x772f,0,0,0,0x7730,0x7731,0x5f30,0, /* 澀,澁,澂,0,澄,0,澆,0, 澈,0,0,0,澌,澍,澎,0, */
	/* 6f90 */ 0x6f3a,0x5f31,0,0,0x7732,0,0x6f3b,0x3442, 0x6f38,0,0,0,0,0,0,0x6f3d, /* 澐,澑,0,0,澔,0,澖,澗, 澘,0,0,0,0,0,0,澟, */
	/* 6fa0 */ 0x7733,0x5f36,0,0x5f35,0x5f37,0x6f3e,0,0x7734, 0,0,0x5f3a,0,0,0,0,0x6f3f, /* 澠,澡,0,澣,澤,澥,0,澧, 0,0,澪,0,0,0,0,澯, */
	/* 6fb0 */ 0,0x4543,0,0x5f34,0,0x6f41,0x7735,0, 0,0x5f38,0,0,0x7736,0,0x6f3c,0, /* 0,澱,0,澳,0,澵,澶,0, 0,澹,0,0,澼,0,澾,0, */
	/* 6fc0 */ 0x3763,0x4279,0x5f32,0x473b,0,0,0x5f39,0x7737, 0x6f42,0x6f43,0x7738,0,0,0,0,0, /* 激,濁,濂,濃,0,0,濆,濇, 濈,濉,濊,0,0,0,0,0, */
	/* 6fd0 */ 0,0,0,0,0x5f3e,0x5f3c,0,0, 0x5f3f,0,0x6f44,0x5f42,0,0,0x6f45,0x5f3b, /* 0,0,0,0,濔,濕,0,0, 濘,0,濚,濛,0,0,濞,濟, */
	/* 6fe0 */ 0x396a,0x4728,0,0,0x5e39,0,0,0, 0,0x6f46,0,0x4d74,0x5f3d,0,0x5f41,0x4275, /* 濠,濡,0,0,濤,0,0,0, 0,濩,0,濫,濬,0,濮,濯, */
	/* 6ff0 */ 0x773a,0x5f40,0,0x5f2b,0,0x773b,0x6f69,0, 0,0x7739,0x5f45,0,0x6f48,0,0x5f49,0, /* 濰,濱,0,濳,0,濵,濶,0, 0,濹,濺,0,濼,0,濾,0, */
	/* 7000 */ 0x6f49,0x5f47,0,0,0,0x773c,0x773d,0x6f4a, 0,0x5f43,0x6f4b,0x5f44,0,0,0,0x5f48, /* 瀀,瀁,0,0,0,瀅,瀆,瀇, 0,瀉,瀊,瀋,0,0,0,瀏, */
	/* 7010 */ 0,0x5f46,0,0,0,0x494e,0,0, 0x5f4e,0,0x5f4b,0x5f4a,0,0x5f4d,0x4654,0x5f4f, /* 0,瀑,0,0,0,瀕,0,0, 瀘,0,瀚,瀛,0,瀝,瀞,瀟, */
	/* 7020 */ 0,0,0,0x6f4c,0,0,0x4375,0x426d, 0x773e,0,0,0,0x4025,0,0,0, /* 0,0,0,瀣,0,0,瀦,瀧, 瀨,0,0,0,瀬,0,0,0, */
	/* 7030 */ 0x5f50,0,0x5f52,0,0,0,0,0, 0,0x6f4e,0x6f4f,0,0x6f50,0,0x5f51,0, /* 瀰,0,瀲,0,0,0,0,0, 0,瀹,瀺,0,瀼,0,瀾,0, */
	/* 7040 */ 0,0,0,0x6f51,0,0,0,0x6f52, 0,0,0x773f,0x6f53,0x5e75,0,0x7742,0, /* 0,0,0,灃,0,0,0,灇, 0,0,灊,灋,灌,0,灎,0, */
	/* 7050 */ 0,0x5f53,0,0,0x6f55,0,0,0, 0x4667,0,0,0,0,0x7740,0x7741,0, /* 0,灑,0,0,灔,0,0,0, 灘,0,0,0,0,灝,灞,0, */
	/* 7060 */ 0,0,0,0x5f54,0x7743,0x6f56,0,0, 0,0x6f57,0,0x3250,0x6f58,0,0x6f59,0x4574, /* 0,0,0,灣,灤,灥,0,0, 0,灩,0,火,灬,0,灮,灯, */
	/* 7070 */ 0x3325,0,0,0,0,0x7744,0x6f5a,0, 0x3564,0,0,0,0x3c5e,0x3a52,0x6f5b,0, /* 灰,0,0,0,0,灵,灶,0, 灸,0,0,0,灼,災,灾,0, */
	/* 7080 */ 0,0x6f5c,0,0,0,0x7745,0x6f5d,0, 0,0x4f27,0x3f66,0,0,0,0x316a,0, /* 0,炁,0,0,0,炅,炆,0, 0,炉,炊,0,0,0,炎,0, */
	/* 7090 */ 0,0,0x5f56,0,0,0x6f5e,0,0x6f5f, 0,0x5f55,0,0,0,0,0,0x6f62, /* 0,0,炒,0,0,炕,0,炗, 0,炙,0,0,0,0,0,炟, */
	/* 70a0 */ 0,0,0,0,0x7746,0,0,0, 0,0,0,0x7747,0x5f59,0x433a,0x5f5c,0x5f57, /* 0,0,0,0,炤,0,0,0, 0,0,0,炫,炬,炭,炮,炯, */
	/* 70b0 */ 0,0x6f63,0,0x5f5b,0,0,0,0x7748, 0x5f5a,0x4540,0x3059,0x6f60,0,0,0,0, /* 0,炱,0,炳,0,0,0,炷, 炸,点,為,炻,0,0,0,0, */
	/* 70c0 */ 0,0,0,0,0,0,0,0, 0x4e75,0,0x6f66,0x5f5e,0,0,0,0x3128, /* 0,0,0,0,0,0,0,0, 烈,0,烊,烋,0,0,0,烏, */
	/* 70d0 */ 0,0x6f67,0,0x6f68,0x7749,0,0,0, 0x774a,0x5f60,0,0,0x6f69,0x5f5f,0,0x5f5d, /* 0,烑,0,烓,烔,0,0,0, 烘,烙,0,0,烜,烝,0,烟, */
	/* 70e0 */ 0,0,0,0,0x774b,0,0,0, 0,0,0,0,0x6f65,0,0,0, /* 0,0,0,0,烤,0,0,0, 0,0,0,0,烬,0,0,0, */
	/* 70f0 */ 0,0x5f58,0,0,0,0,0,0, 0,0x4b23,0,0,0,0x5f62,0,0, /* 0,烱,0,0,0,0,0,0, 0,烹,0,0,0,烽,0,0, */
	/* 7100 */ 0,0,0,0x6f6a,0x6f6b,0,0x6f6c,0x6f6d, 0x6f6e,0x5f61,0,0,0x6f6f,0,0,0x774c, /* 0,0,0,焃,焄,0,焆,焇, 焈,焉,0,0,焌,0,0,焏, */
	/* 7110 */ 0,0,0,0,0x316b,0,0,0, 0,0x5f64,0x4a32,0,0x5f63,0,0x774e,0, /* 0,0,0,0,焔,0,0,0, 0,焙,焚,0,焜,0,焞,0, */
	/* 7120 */ 0x774f,0x4c35,0,0,0,0,0x3e47,0, 0,0,0,0x774d,0,0,0x7750,0x6f71, /* 焠,無,0,0,0,0,焦,0, 0,0,0,焫,0,0,焮,焯, */
	/* 7130 */ 0x7751,0x6f72,0,0,0,0,0x4133,0, 0,0,0,0,0x3e46,0,0,0, /* 焰,焱,0,0,0,0,然,0, 0,0,0,0,焼,0,0,0, */
	/* 7140 */ 0,0,0,0,0,0,0x7752,0x7753, 0,0x4e7b,0x6f74,0,0x5f6a,0,0x4079,0, /* 0,0,0,0,0,0,煆,煇, 0,煉,煊,0,煌,0,煎,0, */
	/* 7150 */ 0x6f73,0x7754,0x7756,0x6f75,0,0x5f66,0x5f6b,0, 0,0x316c,0,0,0x7757,0,0x6f76,0, /* 煐,煑,煒,煓,0,煕,煖,0, 0,煙,0,0,煜,0,煞,0, */
	/* 7160 */ 0x7758,0,0x5f69,0,0x4761,0x5f65,0x5f68,0x3e48, 0x7759,0x4851,0,0,0x5f6c,0,0x3c51,0, /* 煠,0,煢,0,煤,煥,煦,照, 煨,煩,0,0,煬,0,煮,0, */
	/* 7170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x407a,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,煽,0,0, */
	/* 7180 */ 0x6f79,0,0,0,0x5f6f,0x775b,0,0x775c, 0x5f67,0,0x3727,0,0,0,0,0x5f6d, /* 熀,0,0,0,熄,熅,0,熇, 熈,0,熊,0,0,0,0,熏, */
	/* 7190 */ 0,0,0x775d,0,0x4d50,0x5f70,0x6f78,0, 0,0x7426,0,0x6f7a,0,0,0,0x3d4f, /* 0,0,熒,0,熔,熕,熖,0, 0,熙,0,熛,0,0,0,熟, */
	/* 71a0 */ 0x6f7b,0,0x6f7c,0,0,0,0,0, 0x5f71,0,0,0,0x5f72,0,0x6f7d,0x6f7e, /* 熠,0,熢,0,0,0,0,0, 熨,0,0,0,熬,0,熮,熯, */
	/* 71b0 */ 0,0x472e,0,0x7021,0,0,0,0, 0,0x5f74,0x775f,0,0,0,0x5f75,0, /* 0,熱,0,熳,0,0,0,0, 0,熹,熺,0,0,0,熾,0, */
	/* 71c0 */ 0,0x775e,0,0x4733,0x7760,0,0,0, 0x4575,0x5f77,0,0x7023,0,0,0x5f79,0, /* 0,燁,0,燃,燄,0,0,0, 燈,燉,0,燋,0,0,燎,0, */
	/* 71d0 */ 0x4e55,0,0x5f76,0x7024,0x5f78,0x316d,0,0x5f73, 0,0x7025,0,0,0x7026,0,0,0x535b, /* 燐,0,燒,燓,燔,燕,0,燗, 0,燙,0,0,燜,0,0,營, */
	/* 71e0 */ 0x5f7a,0,0,0,0,0x4167,0x3b38,0x5f7c, 0,0,0,0,0x5f7b,0x3f24,0x5259,0, /* 燠,0,0,0,0,燥,燦,燧, 0,0,0,0,燬,燭,燮,0, */
	/* 71f0 */ 0,0,0,0,0,0x5f7d,0,0, 0,0x6021,0,0x5f6e,0x5f7e,0,0x7761,0x6022, /* 0,0,0,0,0,燵,0,0, 0,燹,0,燻,燼,0,燾,燿, */
	/* 7200 */ 0x7762,0,0,0,0,0,0x477a,0x7027, 0,0,0,0,0,0x6023,0,0, /* 爀,0,0,0,0,0,爆,爇, 0,0,0,0,0,爍,0,0, */
	/* 7210 */ 0x6024,0,0,0,0,0x7763,0,0, 0,0,0,0x6025,0,0,0,0, /* 爐,0,0,0,0,爕,0,0, 0,0,0,爛,0,0,0,0, */
	/* 7220 */ 0,0,0,0,0,0,0,0, 0x6026,0,0x445e,0x702a,0x6028,0x6027,0,0, /* 0,0,0,0,0,0,0,0, 爨,0,爪,爫,爬,爭,0,0, */
	/* 7230 */ 0x6029,0,0x602a,0,0x702b,0x3c5f,0x4963,0, 0x702c,0x702d,0x4c6c,0x602b,0x602c,0x4156,0x3c24,0x602d, /* 爰,0,爲,0,爴,爵,父,0, 爸,爹,爺,爻,爼,爽,爾,爿, */
	/* 7240 */ 0x602e,0,0x702f,0,0,0,0x602f,0x4a52, 0x4847,0,0,0x6030,0x4757,0,0,0, /* 牀,0,牂,0,0,0,牆,片, 版,0,0,牋,牌,0,0,0, */
	/* 7250 */ 0,0,0x442d,0x7030,0,0x7764,0x7765,0x7031, 0x6031,0x3267,0,0x356d,0,0x4c46,0,0x4c36, /* 0,0,牒,牓,0,牕,牖,牗, 牘,牙,0,牛,0,牝,0,牟, */
	/* 7260 */ 0,0x3234,0x4f34,0x7032,0,0,0,0x4b52, 0,0x4a2a,0,0,0,0,0x7034,0x7035, /* 0,牡,牢,牣,0,0,0,牧, 0,物,0,0,0,0,牮,牯, */
	/* 7270 */ 0,0,0x4037,0,0x6032,0,0,0, 0x7036,0x4643,0,0,0,0x3823,0x6033,0x7037, /* 0,0,牲,0,牴,0,0,0, 牸,特,0,0,0,牽,牾,牿, */
	/* 7280 */ 0x3a54,0x6035,0x6034,0,0,0,0,0x6036, 0,0,0,0,0,0x7767,0x7038,0, /* 犀,犁,犂,0,0,0,0,犇, 0,0,0,0,0,犍,犎,0, */
	/* 7290 */ 0,0,0x6037,0,0,0,0x6038,0, 0,0,0,0x7768,0,0,0,0, /* 0,0,犒,0,0,0,犖,0, 0,0,0,犛,0,0,0,0, */
	/* 72a0 */ 0x353e,0,0x6039,0,0,0,0,0x603a, 0,0,0,0,0x3824,0x703a,0x703b,0x4848, /* 犠,0,犢,0,0,0,0,犧, 0,0,0,0,犬,犭,犮,犯, */
	/* 72b0 */ 0x703c,0x703d,0x603c,0,0,0,0x3e75,0, 0,0x603b,0,0,0,0,0x7769,0, /* 犰,犱,犲,0,0,0,状,0, 0,犹,0,0,0,0,犾,0, */
	/* 72c0 */ 0x776a,0x703e,0x3638,0x603d,0x603f,0,0x603e,0, 0,0,0,0,0x7040,0,0x6040,0, /* 狀,狁,狂,狃,狄,0,狆,0, 0,0,0,0,狌,0,狎,0, */
	/* 72d0 */ 0x3851,0,0x6041,0,0,0,0,0x3669, 0,0x4140,0,0x397d,0,0,0,0, /* 狐,0,狒,0,0,0,0,狗, 0,狙,0,狛,0,0,0,0, */
	/* 72e0 */ 0x6043,0x6044,0x6042,0,0,0,0,0, 0,0x3c6d,0,0,0x4648,0x3639,0,0, /* 狠,狡,狢,0,0,0,0,0, 0,狩,0,0,独,狭,0,0, */
	/* 72f0 */ 0,0,0,0x7043,0,0,0,0x6046, 0x432c,0x6045,0x7044,0x776b,0x4f35,0x4762,0,0, /* 0,0,0,狳,0,0,0,狷, 狸,狹,狺,狻,狼,狽,0,0, */
	/* 7300 */ 0,0,0,0,0,0,0,0x7045, 0,0,0x6049,0,0,0,0,0, /* 0,0,0,0,0,0,0,猇, 0,0,猊,0,0,0,0,0, */
	/* 7310 */ 0,0,0x7046,0,0,0,0x604b,0x6048, 0x7047,0x7048,0,0x4c54,0x604a,0x604c,0,0x4e44, /* 0,0,猒,0,0,0,猖,猗, 猘,猙,0,猛,猜,猝,0,猟, */
	/* 7320 */ 0,0,0,0,0,0x6050,0,0x776d, 0x776e,0x604f,0x4376,0x472d,0x704b,0,0x3825,0x604e, /* 0,0,0,0,0,猥,0,猧, 猨,猩,猪,猫,猬,0,献,猯, */
	/* 7330 */ 0,0x704c,0,0x704d,0x604d,0,0x4d31,0x4d32, 0,0x704a,0,0,0,0x704e,0x6051,0x316e, /* 0,猱,0,猳,猴,0,猶,猷, 0,猹,0,0,0,猽,猾,猿, */
	/* 7340 */ 0,0,0,0,0x3976,0x3b62,0,0, 0,0,0,0,0,0,0x6052,0x6053, /* 0,0,0,0,獄,獅,0,0, 0,0,0,0,0,0,獎,獏, */
	/* 7350 */ 0x7770,0,0x704f,0,0,0,0,0x6055, 0,0,0,0,0,0,0,0, /* 獐,0,獒,0,0,0,0,獗, 0,0,0,0,0,0,0,0, */
	/* 7360 */ 0,0,0,0x3d43,0,0,0x7771,0, 0x6057,0,0x6056,0x7051,0x7052,0,0x7054,0x7055, /* 0,0,0,獣,0,0,獦,0, 獨,0,獪,獫,獬,0,獮,獯, */
	/* 7370 */ 0x6058,0x7056,0x334d,0,0,0x605a,0,0x7057, 0x6059,0,0x605c,0x605b,0x7772,0,0,0, /* 獰,獱,獲,0,0,獵,0,獷, 獸,0,獺,獻,獼,0,0,0, */
	/* 7380 */ 0,0x7058,0,0,0x383c,0x7059,0,0x4e28, 0,0x364c,0x705a,0x3226,0,0,0,0, /* 0,玁,0,0,玄,玅,0,率, 0,玉,玊,王,0,0,0,0, */
	/* 7390 */ 0,0,0,0,0x705b,0x7773,0x366a,0, 0x705c,0,0,0,0x705d,0,0x705e,0x7774, /* 0,0,0,0,玔,玕,玖,0, 玘,0,0,0,玜,0,玞,玟, */
	/* 73a0 */ 0x7775,0,0x7776,0,0,0x705f,0x7777,0, 0x7060,0x3461,0,0x7778,0,0,0,0, /* 玠,0,玢,0,0,玥,玦,0, 玨,玩,0,玫,0,0,0,0, */
	/* 73b0 */ 0,0,0x4e68,0x605e,0,0x7061,0,0x7062, 0,0x7063,0,0x6060,0x7064,0,0,0x7065, /* 0,0,玲,玳,0,玵,0,玷, 0,玹,0,玻,玼,0,0,玿, */
	/* 73c0 */ 0x6061,0,0x3251,0,0,0x7066,0,0, 0x605d,0x7779,0x3b39,0x7067,0,0x4441,0x605f,0x777a, /* 珀,0,珂,0,0,珅,0,0, 珈,珉,珊,珋,0,珍,珎,珏, */
	/* 73d0 */ 0,0,0,0,0,0,0x777b,0, 0,0x777c,0,0,0,0,0x6064,0, /* 0,0,0,0,0,0,珖,0, 0,珙,0,0,0,0,珞,0, */
	/* 73e0 */ 0x3c6e,0x7068,0,0x777d,0,0x6062,0,0x7069, 0,0x777e,0x373e,0,0,0x4849,0x6063,0, /* 珠,珡,0,珣,0,珥,0,珧, 0,珩,珪,0,0,班,珮,0, */
	/* 73f0 */ 0,0x607e,0,0,0,0,0,0, 0x6069,0x706a,0x706c,0,0,0,0x383d,0, /* 0,珱,0,0,0,0,0,0, 珸,珹,珺,0,0,0,現,0, */
	/* 7400 */ 0,0x706d,0,0x3565,0,0x6066,0x4d7d,0x7821, 0,0x4e30,0x7822,0,0,0,0,0, /* 0,琁,0,球,0,琅,理,琇, 0,琉,琊,0,0,0,0,0, */
	/* 7410 */ 0,0,0,0x706b,0,0,0,0, 0,0,0x7823,0x7824,0,0,0,0, /* 0,0,0,琓,0,0,0,0, 0,0,琚,琛,0,0,0,0, */
	/* 7420 */ 0,0,0x4276,0,0x706e,0x6068,0x7826,0, 0x7827,0,0x7828,0x7829,0x782a,0,0x782b,0x782c, /* 0,0,琢,0,琤,琥,琦,0, 琨,0,琪,琫,琬,0,琮,琯, */
	/* 7430 */ 0x782d,0x706f,0x606a,0x4e56,0x3657,0x487c,0x474a,0, 0,0x7070,0x606b,0,0,0,0,0x606d, /* 琰,琱,琲,琳,琴,琵,琶,0, 0,琹,琺,0,0,0,0,琿, */
	/* 7440 */ 0x7072,0x6070,0,0x7073,0x782e,0,0x782f,0x7830, 0,0,0,0x7831,0,0x7074,0,0, /* 瑀,瑁,0,瑃,瑄,0,瑆,瑇, 0,0,0,瑋,0,瑍,0,0, */
	/* 7450 */ 0,0,0x7075,0x7071,0,0x606c,0,0x7832, 0,0x606f,0x386a,0x314d,0x6071,0x7076,0x3f70,0x606e, /* 0,0,瑒,瑓,0,瑕,0,瑗, 0,瑙,瑚,瑛,瑜,瑝,瑞,瑟, */
	/* 7460 */ 0x4e5c,0,0x7833,0x6074,0x7424,0,0,0, 0,0x6072,0x6075,0x7834,0,0x7835,0,0x6067, /* 瑠,0,瑢,瑣,瑤,0,0,0, 0,瑩,瑪,瑫,0,瑭,0,瑯, */
	/* 7470 */ 0x6073,0x7077,0,0x3a3c,0,0,0x6076,0, 0,0,0,0,0,0,0x6077,0, /* 瑰,瑱,0,瑳,0,0,瑶,0, 0,0,0,0,0,0,瑾,0, */
	/* 7480 */ 0,0x7078,0,0x4d7e,0,0x7079,0x7836,0x7837, 0x707a,0x7838,0,0x6078,0,0,0,0, /* 0,璁,0,璃,0,璅,璆,璇, 璈,璉,0,璋,0,0,0,0, */
	/* 7490 */ 0x783d,0,0x707c,0,0,0,0,0x707d, 0x7839,0x707e,0,0,0x783a,0,0x6079,0x783b, /* 璐,0,璒,0,0,0,0,璗, 璘,璙,0,0,璜,0,璞,璟, */
	/* 74a0 */ 0x7121,0x7122,0x6065,0x783c,0,0x7123,0x783e,0x607a, 0x783f,0x7840,0x7124,0x7125,0,0,0,0, /* 璠,璡,璢,璣,0,璥,璦,璧, 璨,璩,璪,璫,0,0,0,0, */
	/* 74b0 */ 0x3444,0,0,0,0,0x7841,0,0, 0,0x7126,0x7128,0x7127,0,0x3c25,0,0x7842, /* 環,0,0,0,0,璵,0,0, 0,璹,璺,璻,0,璽,0,璿, */
	/* 74c0 */ 0,0,0,0,0,0,0,0, 0x7843,0x7844,0x607b,0,0,0,0,0x607c, /* 0,0,0,0,0,0,0,0, 瓈,瓉,瓊,0,0,0,0,瓏, */
	/* 74d0 */ 0,0,0,0,0x607d,0,0x7129,0, 0x712a,0,0x7845,0,0x313b,0,0x712b,0, /* 0,0,0,0,瓔,0,瓖,0, 瓘,0,瓚,0,瓜,0,瓞,0, */
	/* 74e0 */ 0x6121,0,0x493b,0x6122,0,0,0x3424,0x6123, 0,0x6124,0,0x712d,0,0,0x6125,0x712c, /* 瓠,0,瓢,瓣,0,0,瓦,瓧, 0,瓩,0,瓫,0,0,瓮,瓯, */
	/* 74f0 */ 0x6127,0x6128,0x6126,0,0,0,0x4953,0x612a, 0x6129,0,0x712f,0,0,0,0,0x7846, /* 瓰,瓱,瓲,0,0,0,瓶,瓷, 瓸,0,瓺,0,0,0,0,瓿, */
	/* 7500 */ 0,0x7847,0,0x612c,0x612b,0x612d,0,0, 0,0,0,0,0x612e,0x6130,0x612f,0, /* 0,甁,0,甃,甄,甅,0,0, 0,0,0,0,甌,甍,甎,0, */
	/* 7510 */ 0,0x3979,0,0x6132,0,0x6131,0,0x7848, 0x3445,0,0x3f53,0,0x453c,0,0x6133,0x4038, /* 0,甑,0,甓,0,甕,0,甗, 甘,0,甚,0,甜,0,甞,生, */
	/* 7520 */ 0x7131,0,0,0x3b3a,0x7132,0x3179,0x6134,0, 0x4d51,0,0x7133,0x4a63,0x6135,0,0,0x7849, /* 甠,0,0,産,甤,甥,甦,0, 用,0,甪,甫,甬,0,0,甯, */
	/* 7530 */ 0x4544,0x4d33,0x3943,0x3f3d,0,0,0,0x434b, 0x5234,0,0x442e,0x3268,0x6136,0x7136,0x7137,0, /* 田,由,甲,申,0,0,0,男, 甸,0,町,画,甼,甽,甾,0, */
	/* 7540 */ 0x7138,0,0,0,0x6137,0,0x613c,0, 0x7139,0x613a,0x6139,0x5a42,0x3326,0x6138,0x713a,0x305a, /* 畀,0,0,0,畄,0,畆,0, 畈,畉,畊,畋,界,畍,畎,畏, */
	/* 7550 */ 0x713b,0x482a,0x713c,0,0x484a,0,0,0, 0,0x4e31,0x613d,0x613b,0x435c,0x4026,0,0, /* 畐,畑,畒,0,畔,0,0,0, 0,留,畚,畛,畜,畝,0,0, */
	/* 7560 */ 0x482b,0,0x492d,0,0x613f,0x4e2c,0x374d,0x6140, 0,0x613e,0x4856,0x6141,0x713d,0x6142,0,0x784a, /* 畠,0,畢,0,畤,略,畦,畧, 0,畩,番,畫,畬,畭,0,畯, */
	/* 7570 */ 0x305b,0x713f,0x713e,0x3e76,0x6147,0,0x6144,0x466d, 0x6143,0x784b,0x7140,0,0,0x7141,0x7142,0x3526, /* 異,畱,畲,畳,畴,0,當,畷, 畸,畹,畺,0,0,畽,畾,畿, */
	/* 7580 */ 0,0x7143,0x614a,0,0,0,0x6145,0x6146, 0,0x6149,0x6148,0x4925,0x7145,0,0x4142,0x4141, /* 0,疁,疂,0,0,0,疆,疇, 0,疉,疊,疋,疌,0,疎,疏, */
	/* 7590 */ 0,0x353f,0x784c,0,0x614b,0,0,0, 0,0,0x614c,0,0,0x614d,0,0, /* 0,疑,疒,0,疔,0,0,0, 0,0,疚,0,0,疝,0,0, */
	/* 75a0 */ 0,0,0x7147,0x614f,0,0x614e,0,0, 0,0,0,0x3156,0,0,0,0, /* 0,0,疢,疣,0,疥,0,0, 0,0,0,疫,0,0,0,0, */
	/* 75b0 */ 0x7149,0x6157,0x4868,0x6151,0,0x6153,0,0x714a, 0x6155,0x3f3e,0,0,0x6156,0x6154,0x3c40,0x714b, /* 疰,疱,疲,疳,0,疵,0,疷, 疸,疹,0,0,疼,疽,疾,疿, */
	/* 75c0 */ 0x714c,0,0x6150,0x6152,0,0x4942,0x714d,0x3e49, 0,0,0x6159,0,0,0x6158,0x784e,0x714e, /* 痀,0,痂,痃,0,病,痆,症, 0,0,痊,0,0,痍,痎,痏, */
	/* 75d0 */ 0,0,0x615a,0x714f,0x3c26,0x3a2f,0,0, 0x4577,0x615b,0,0x444b,0,0x7150,0x615d,0x7151, /* 0,0,痒,痓,痔,痕,0,0, 痘,痙,0,痛,0,痝,痞,痟, */
	/* 75e0 */ 0x7152,0,0x4e21,0x615c,0x784f,0,0,0x7153, 0,0x4169,0,0,0x7154,0,0x7155,0, /* 痠,0,痢,痣,痤,0,0,痧, 0,痩,0,0,痬,0,痮,0, */
	/* 75f0 */ 0x6162,0x7156,0x6164,0x6165,0x4354,0,0,0, 0,0x7157,0x6163,0,0x6160,0,0x615e,0x615f, /* 痰,痱,痲,痳,痴,0,0,0, 0,痹,痺,0,痼,0,痾,痿, */
	/* 7600 */ 0x7850,0x6161,0x7851,0x7158,0,0,0,0x715a, 0x7852,0x6168,0,0x6166,0,0x6167,0,0x715b, /* 瘀,瘁,瘂,瘃,0,0,0,瘇, 瘈,瘉,0,瘋,0,瘍,0,瘏, */
	/* 7610 */ 0,0,0,0x715e,0,0x7853,0x7854,0, 0x7159,0x7855,0,0x715f,0x7160,0,0x7856,0x6169, /* 0,0,0,瘓,0,瘕,瘖,0, 瘘,瘙,0,瘛,瘜,0,瘞,瘟, */
	/* 7620 */ 0x616b,0x616c,0x616d,0,0x616e,0x7162,0x7e7d,0x616a, 0x7163,0,0,0,0,0x7857,0,0, /* 瘠,瘡,瘢,0,瘤,瘥,瘦,瘧, 瘨,0,0,0,0,瘭,0,0, */
	/* 7630 */ 0x6170,0,0,0x7165,0x616f,0x7858,0,0, 0,0,0,0x6171,0x7164,0,0,0, /* 瘰,0,0,瘳,瘴,瘵,0,0, 0,0,0,瘻,瘼,0,0,0, */
	/* 7640 */ 0,0x7168,0x4e45,0x7859,0,0,0x6174,0x6172, 0x6173,0x716a,0,0x785a,0x3462,0,0,0, /* 0,癁,療,癃,0,0,癆,癇, 癈,癉,0,癋,癌,0,0,0, */
	/* 7650 */ 0,0,0x4c7e,0,0,0x716b,0x4a4a,0, 0x6176,0,0,0,0x6175,0,0,0, /* 0,0,癒,0,0,癕,癖,0, 癘,0,0,0,癜,0,0,0, */
	/* 7660 */ 0,0x6177,0x6178,0,0x785b,0x785c,0,0x617c, 0x6179,0x617a,0x617b,0,0x617d,0x785d,0x716d,0x785e, /* 0,癡,癢,0,癤,癥,0,癧, 癨,癩,癪,0,癬,癭,癮,癯, */
	/* 7670 */ 0x617e,0x785f,0x6221,0,0,0,0x6222,0, 0x6223,0,0x482f,0x4550,0x6224,0x4772,0x4934,0, /* 癰,癱,癲,0,0,0,癶,0, 癸,0,発,登,發,白,百,0, */
	/* 7680 */ 0x6225,0x7860,0,0x6226,0x452a,0,0x3327,0x3944, 0x6227,0,0,0x6228,0,0,0x6229,0, /* 皀,皁,0,皃,的,0,皆,皇, 皈,0,0,皋,0,0,皎,0, */
	/* 7690 */ 0x3b29,0,0,0x622b,0,0x716e,0x622a,0, 0,0x622c,0x622d,0x7861,0x716f,0x7862,0x7863,0, /* 皐,0,0,皓,0,皕,皖,0, 0,皙,皚,皛,皜,皝,皞,0, */
	/* 76a0 */ 0x7171,0x7170,0,0,0,0,0x7864,0x7172, 0x7173,0,0x7865,0,0,0,0x4869,0x7174, /* 皠,皡,0,0,0,0,皦,皧, 皨,0,皪,0,0,0,皮,皯, */
	/* 76b0 */ 0x622e,0,0,0,0x622f,0,0x7866,0x7369, 0x6230,0x6231,0x6232,0,0,0,0,0x3b2e, /* 皰,0,0,0,皴,0,皶,皷, 皸,皹,皺,0,0,0,0,皿, */
	/* 76c0 */ 0,0,0x6233,0x4756,0,0x7867,0x4b5f,0, 0x314e,0x7176,0x3157,0,0x7868,0x6234,0x7869,0, /* 0,0,盂,盃,0,盅,盆,0, 盈,盉,益,0,盌,盍,盎,0, */
	/* 76d0 */ 0,0,0x6236,0,0x786a,0,0x6235,0x4570, 0,0,0,0x4039,0x5d39,0,0x6237,0x4c41, /* 0,0,盒,0,盔,0,盖,盗, 0,0,0,盛,盜,0,盞,盟, */
	/* 76e0 */ 0,0x6238,0,0x3446,0x4857,0x6239,0x786b,0x623a, 0x7178,0,0x623b,0,0x7179,0,0x4c5c,0, /* 0,盡,0,監,盤,盥,盦,盧, 盨,0,盪,0,盬,0,目,0, */
	/* 76f0 */ 0,0x786c,0x4c55,0,0x443e,0,0,0, 0x416a,0,0,0x623d,0x786d,0,0x3d62,0, /* 0,盱,盲,0,直,0,0,0, 相,0,0,盻,盼,0,盾,0, */
	/* 7700 */ 0,0x3e4a,0,0,0x6240,0,0,0x623f, 0x623e,0x487d,0x786e,0x3447,0x3829,0,0,0, /* 0,省,0,0,眄,0,0,眇, 眈,眉,眊,看,県,0,0,0, */
	/* 7710 */ 0,0,0,0,0,0,0,0x717b, 0,0x786f,0x717c,0x6246,0,0,0x6243,0x3f3f, /* 0,0,0,0,0,0,0,眗, 0,眙,眚,眛,0,0,眞,真, */
	/* 7720 */ 0x4c32,0,0,0,0x6242,0x6244,0x6245,0, 0,0x6241,0,0,0,0x717d,0,0, /* 眠,0,0,0,眤,眥,眦,0, 0,眩,0,0,0,眭,0,0, */
	/* 7730 */ 0,0,0,0,0x7870,0x717e,0x7871,0x6247, 0x6248,0,0x442f,0,0x3463,0,0,0, /* 0,0,0,0,眴,眵,眶,眷, 眸,0,眺,0,眼,0,0,0, */
	/* 7740 */ 0x4365,0,0,0,0,0,0x7872,0x6249, 0,0,0,0,0,0x7873,0x7874,0, /* 着,0,0,0,0,0,睆,睇, 0,0,0,0,0,睍,睎,0, */
	/* 7750 */ 0,0,0,0,0,0,0,0, 0x7225,0,0x624a,0x624d,0x7875,0,0,0x7876, /* 0,0,0,0,0,0,0,0, 睘,0,睚,睛,睜,0,0,睟, */
	/* 7760 */ 0x7226,0x3f67,0x7877,0x4644,0,0x624e,0x4b53,0, 0x624b,0,0x7227,0x624c,0,0,0,0, /* 睠,睡,睢,督,0,睥,睦,0, 睨,0,睪,睫,0,0,0,0, */
	/* 7770 */ 0,0,0x7229,0,0,0,0,0, 0,0x6251,0x7878,0,0x722a,0x722b,0x6250,0x624f, /* 0,0,睲,0,0,0,0,0, 0,睹,睺,0,睼,睽,睾,睿, */
	/* 7780 */ 0x7879,0,0,0,0,0,0,0, 0,0,0,0x6253,0,0,0x6252,0, /* 瞀,0,0,0,0,0,0,0, 0,0,0,瞋,0,0,瞎,0, */
	/* 7790 */ 0,0x6254,0,0,0x787a,0,0,0, 0,0,0x722e,0,0,0,0x6256,0x722f, /* 0,瞑,0,0,瞔,0,0,0, 0,0,瞚,0,0,0,瞞,瞟, */
	/* 77a0 */ 0x6255,0,0x7230,0,0x7231,0x4a4d,0,0, 0,0x7232,0x787b,0,0x3d56,0x4e46,0,0, /* 瞠,0,瞢,0,瞤,瞥,0,0, 0,瞩,瞪,0,瞬,瞭,0,0, */
	/* 77b0 */ 0x6257,0,0,0x4637,0,0,0x6258,0, 0,0x6259,0,0x625d,0x625b,0x625c,0,0x625a, /* 瞰,0,0,瞳,0,0,瞶,0, 0,瞹,0,瞻,瞼,瞽,0,瞿, */
	/* 77c0 */ 0,0,0,0,0,0,0,0x625e, 0,0,0,0,0,0x625f,0,0, /* 0,0,0,0,0,0,0,矇, 0,0,0,0,0,矍,0,0, */
	/* 77d0 */ 0,0,0,0,0,0,0,0x6260, 0,0,0x6261,0x4c37,0x6262,0,0x7233,0x7234, /* 0,0,0,0,0,0,0,矗, 0,0,矚,矛,矜,0,矞,矟, */
	/* 77e0 */ 0x787c,0,0x4c70,0x6263,0x7235,0x434e,0x7236,0x476a, 0,0x366b,0x7237,0,0x7238,0x433b,0x6264,0x363a, /* 矠,0,矢,矣,矤,知,矦,矧, 0,矩,矪,0,矬,短,矮,矯, */
	/* 77f0 */ 0x723a,0,0,0x4050,0x723b,0,0,0, 0,0,0,0x723c,0x6265,0,0,0, /* 矰,0,0,石,矴,0,0,0, 0,0,0,矻,矼,0,0,0, */
	/* 7800 */ 0,0,0x3a3d,0,0,0x723e,0x723f,0, 0,0x7240,0,0,0x6266,0x7241,0,0, /* 0,0,砂,0,0,砅,砆,0, 0,砉,0,0,砌,砍,0,0, */
	/* 7810 */ 0,0,0x6267,0,0x3826,0x3a55,0,0, 0,0x7242,0,0,0,0,0,0, /* 0,0,砒,0,研,砕,0,0, 0,砙,0,0,0,0,0,0, */
	/* 7820 */ 0x6269,0x7243,0,0,0,0x4556,0x3a56,0x354e, 0,0,0,0,0x7244,0x787d,0,0, /* 砠,砡,0,0,0,砥,砦,砧, 0,0,0,0,砬,砭,0,0, */
	/* 7830 */ 0,0,0x4b24,0,0x474b,0,0,0, 0,0,0x4557,0,0,0,0,0x395c, /* 0,0,砲,0,破,0,0,0, 0,0,砺,0,0,0,0,砿, */
	/* 7840 */ 0,0,0,0x7921,0,0x626b,0,0x7245, 0,0,0,0,0,0,0x7922,0x7923, /* 0,0,0,硃,0,硅,0,硇, 0,0,0,0,0,0,硎,硏, */
	/* 7850 */ 0,0x7924,0,0,0,0,0,0, 0,0,0,0,0,0x3e4b,0,0, /* 0,硑,0,0,0,0,0,0, 0,0,0,0,0,硝,0,0, */
	/* 7860 */ 0,0,0,0,0x7246,0,0,0, 0x7925,0,0x7247,0x4e32,0x3945,0,0x7926,0x3827, /* 0,0,0,0,硤,0,0,0, 硨,0,硪,硫,硬,0,确,硯, */
	/* 7870 */ 0,0,0x4823,0,0x626d,0,0,0, 0,0,0,0,0x626f,0,0,0, /* 0,0,硲,0,硴,0,0,0, 0,0,0,0,硼,0,0,0, */
	/* 7880 */ 0,0x386b,0,0,0,0,0x626e,0x4476, 0,0,0x7249,0,0x6271,0x3337,0x626c,0, /* 0,碁,0,0,0,0,碆,碇, 0,0,碊,0,碌,碍,碎,0, */
	/* 7890 */ 0,0x486a,0,0x3130,0x724a,0x3a6c,0,0x4f52, 0,0,0x6270,0,0,0x724c,0x724d,0x724e, /* 0,碑,0,碓,碔,碕,0,碗, 0,0,碚,0,0,碝,碞,碟, */
	/* 78a0 */ 0,0,0,0x6272,0x724b,0,0,0x4a4b, 0,0x4059,0x6274,0,0,0x792a,0,0x6275, /* 0,0,0,碣,碤,0,0,碧, 0,碩,碪,0,0,碭,0,碯, */
	/* 78b0 */ 0x7928,0,0,0,0,0x6273,0,0, 0,0,0x334e,0x724f,0x627b,0,0x627a,0, /* 碰,0,0,0,0,碵,0,0, 0,0,確,碻,碼,0,碾,0, */
	/* 78c0 */ 0,0x3c27,0,0,0,0x627c,0x6277,0, 0x7250,0,0x627d,0x6278,0x7251,0,0x7252,0, /* 0,磁,0,0,0,磅,磆,0, 磈,0,磊,磋,磌,0,磎,0, */
	/* 78d0 */ 0x4858,0x6276,0,0,0x6279,0x7253,0,0, 0,0,0x6322,0,0,0,0,0, /* 磐,磑,0,0,磔,磕,0,0, 0,0,磚,0,0,0,0,0, */
	/* 78e0 */ 0x7254,0x7255,0,0,0x792b,0,0x7256,0x6321, 0x4b61,0,0,0,0x627e,0,0,0x306b, /* 磠,磡,0,0,磤,0,磦,磧, 磨,0,0,0,磬,0,0,磯, */
	/* 78f0 */ 0,0,0x792c,0,0x6324,0,0,0x792e, 0,0x7257,0x7258,0x7259,0,0x6323,0x725a,0, /* 0,0,磲,0,磴,0,0,磷, 0,磹,磺,磻,0,磽,磾,0, */
	/* 7900 */ 0x792d,0x3e4c,0,0,0,0,0,0x6325, 0,0,0,0,0,0,0x4143,0, /* 礀,礁,0,0,0,0,0,礇, 0,0,0,0,0,0,礎,0, */
	/* 7910 */ 0x725c,0x6327,0x6326,0,0,0,0,0, 0,0x6328,0,0x725d,0x792f,0,0,0, /* 礐,礑,礒,0,0,0,0,0, 0,礙,0,礛,礜,0,0,0, */
	/* 7920 */ 0,0,0,0,0,0x725f,0x6268,0, 0,0,0x626a,0x632a,0x6329,0,0x7930,0, /* 0,0,0,0,0,礥,礦,0, 0,0,礪,礫,礬,0,礮,0, */
	/* 7930 */ 0x725e,0x7931,0,0,0x7932,0,0,0, 0,0,0x3c28,0x7260,0x4e69,0,0x3c52,0, /* 礰,礱,0,0,礴,0,0,0, 0,0,示,礻,礼,0,社,0, */
	/* 7940 */ 0x632b,0x3737,0,0,0,0x7935,0x7936,0x3540, 0x3527,0x3b63,0x7261,0,0,0,0,0, /* 祀,祁,0,0,0,祅,祆,祇, 祈,祉,祊,0,0,0,0,0, */
	/* 7950 */ 0x4d34,0,0,0x6331,0,0x6330,0x4144,0x632d, 0x7262,0,0x632f,0x7263,0x793a,0x3d4b,0x3f40,0x632e, /* 祐,0,0,祓,0,祕,祖,祗, 祘,0,祚,祛,祜,祝,神,祟, */
	/* 7960 */ 0x632c,0,0x472a,0,0,0x3e4d,0,0x7265, 0x493c,0,0,0,0,0x3a57,0,0, /* 祠,0,祢,0,0,祥,0,祧, 票,0,0,0,0,祭,0,0, */
	/* 7970 */ 0,0,0x7266,0,0,0,0,0x4578, 0,0x793e,0x6332,0,0,0,0,0x6333, /* 0,0,祲,0,0,0,0,祷, 0,祹,祺,0,0,0,0,祿, */
	/* 7980 */ 0x6349,0x3658,0,0,0x4f3d,0x4135,0,0, 0,0,0x6334,0,0,0x3252,0x4477,0x4a21, /* 禀,禁,0,0,禄,禅,0,0, 0,0,禊,0,0,禍,禎,福, */
	/* 7990 */ 0,0,0,0,0x7267,0x7268,0x7269,0, 0x7942,0,0,0x726a,0,0x6335,0,0, /* 0,0,0,0,禔,禕,禖,0, 禘,0,0,禛,0,禝,0,0, */
	/* 79a0 */ 0,0x726b,0,0,0,0,0x357a,0x6336, 0,0x726c,0x6338,0,0,0,0x6339,0, /* 0,禡,0,0,0,0,禦,禧, 0,禩,禪,0,0,0,禮,0, */
	/* 79b0 */ 0x4729,0x7943,0,0x633a,0x726d,0,0,0, 0x7944,0x633b,0x633c,0x726e,0,0x3659,0x3253,0x4645, /* 禰,禱,0,禳,禴,0,0,0, 禸,禹,禺,离,0,禽,禾,禿, */
	/* 79c0 */ 0x3d28,0x3b64,0x726f,0,0,0,0,0x7270, 0x7945,0x633d,0x7946,0x3d29,0x7271,0x7272,0,0, /* 秀,私,秂,0,0,0,0,秇, 秈,秉,秊,秋,秌,种,0,0, */
	/* 79d0 */ 0,0x324a,0x4943,0,0x7948,0x633e,0x7273,0, 0x486b,0,0,0,0,0,0x7949,0x4145, /* 0,科,秒,0,秔,秕,秖,0, 秘,0,0,0,0,0,秞,租, */
	/* 79e0 */ 0,0x6341,0,0x6342,0x4769,0,0x3f41,0x633f, 0,0x4361,0,0x794a,0x6340,0x794b,0,0, /* 0,秡,0,秣,秤,0,秦,秧, 0,秩,0,秫,秬,秭,0,0, */
	/* 79f0 */ 0x3e4e,0,0,0,0,0,0,0, 0,0,0,0x305c,0,0,0,0, /* 称,0,0,0,0,0,0,0, 0,0,0,移,0,0,0,0, */
	/* 7a00 */ 0x3529,0,0,0x794c,0,0,0,0, 0x6343,0,0x7278,0x4478,0,0x6344,0x4047,0, /* 稀,0,0,稃,0,0,0,0, 稈,0,稊,程,0,稍,税,0, */
	/* 7a10 */ 0,0x7279,0,0,0x4c2d,0x727a,0,0x4923, 0x6345,0x6346,0x4355,0x727b,0x4e47,0,0x727c,0x6348, /* 0,稑,0,0,稔,稕,0,稗, 稘,稙,稚,稛,稜,0,稞,稟, */
	/* 7a20 */ 0x6347,0,0,0,0,0,0,0, 0,0,0,0,0,0x727e,0x3c6f,0, /* 稠,0,0,0,0,0,0,0, 0,0,0,0,0,稭,種,0, */
	/* 7a30 */ 0,0x634a,0x3070,0,0,0,0,0x634d, 0x7321,0x794e,0,0x634b,0x3254,0x374e,0x634c,0x3946, /* 0,稱,稲,0,0,0,0,稷, 稸,稹,0,稻,稼,稽,稾,稿, */
	/* 7a40 */ 0x3972,0,0x4a66,0x634e,0,0,0x4b54,0x7322, 0,0x6350,0,0,0x7323,0x4051,0x314f,0x323a, /* 穀,0,穂,穃,0,0,穆,穇, 0,穉,0,0,穌,積,穎,穏, */
	/* 7a50 */ 0x302c,0,0,0,0,0,0x7324,0x634f, 0,0x7325,0,0,0x7326,0x794f,0,0x7327, /* 穐,0,0,0,0,0,穖,穗, 0,穙,0,0,穜,穝,0,穟, */
	/* 7a60 */ 0x7328,0x6351,0x6352,0x3e77,0,0,0,0x7329, 0,0x6353,0x732a,0x334f,0,0x7950,0,0, /* 穠,穡,穢,穣,0,0,0,穧, 0,穩,穪,穫,0,穭,0,0, */
	/* 7a70 */ 0x6355,0,0,0,0x376a,0x732b,0x3566,0, 0x732c,0x6356,0x3675,0,0,0x6357,0,0x407c, /* 穰,0,0,0,穴,穵,究,0, 穸,穹,空,0,0,穽,0,穿, */
	/* 7a80 */ 0,0x464d,0x732d,0x4060,0x3a75,0x7952,0,0, 0x6358,0,0x732e,0,0,0,0,0, /* 0,突,窂,窃,窄,窅,0,0, 窈,0,窊,0,0,0,0,0, */
	/* 7a90 */ 0x732f,0,0x4362,0x416b,0,0x635a,0x635c,0x6359, 0x635b,0,0,0,0,0,0,0x3722, /* 窐,0,窒,窓,0,窕,窖,窗, 窘,0,0,0,0,0,0,窟, */
	/* 7aa0 */ 0x7953,0,0,0x7330,0,0,0,0, 0,0x635d,0x3726,0,0x7331,0,0x3567,0x4d52, /* 窠,0,0,窣,0,0,0,0, 0,窩,窪,0,窬,0,窮,窯, */
	/* 7ab0 */ 0x635f,0,0,0x7955,0,0,0x6360,0, 0,0x7334,0x312e,0x7956,0x7335,0,0x7336,0x6363, /* 窰,0,0,窳,0,0,窶,0, 0,窹,窺,窻,窼,0,窾,窿, */
	/* 7ac0 */ 0,0,0,0x3376,0x6362,0x6361,0,0x6365, 0x635e,0,0x6366,0x4e29,0x7338,0x6367,0x7957,0x6368, /* 0,0,0,竃,竄,竅,0,竇, 竈,0,竊,立,竌,竍,竎,竏, */
	/* 7ad0 */ 0,0x7339,0x5474,0x636a,0,0x6369,0,0, 0,0x636b,0x636c,0,0x4e35,0x636d,0,0x706f, /* 0,竑,竒,竓,0,竕,0,0, 0,站,竚,0,竜,竝,0,竟, */
	/* 7ae0 */ 0x3e4f,0x636e,0x636f,0x3d57,0,0x4638,0x6370,0x733a, 0x733b,0,0x4328,0x7958,0,0x6371,0,0x433c, /* 章,竡,竢,竣,0,童,竦,竧, 竨,0,竪,竫,0,竭,0,端, */
	/* 7af0 */ 0x6372,0,0,0,0x733c,0,0x3625,0, 0x513f,0x435d,0x3c33,0,0,0x7959,0,0x3448, /* 竰,0,0,0,竴,0,競,0, 竸,竹,竺,0,0,竽,0,竿, */
	/* 7b00 */ 0,0,0x6373,0,0x6422,0,0x6376,0x733f, 0x3568,0,0x6375,0x6424,0,0,0,0x6374, /* 0,0,笂,0,笄,0,笆,笇, 笈,0,笊,笋,0,0,0,笏, */
	/* 7b10 */ 0,0x3e50,0x795a,0,0,0,0,0, 0x6378,0x6379,0,0x452b,0,0,0x637a,0, /* 0,笑,笒,0,0,0,0,0, 笘,笙,0,笛,0,0,笞,0, */
	/* 7b20 */ 0x335e,0,0,0,0,0x3f5a,0x4964,0x7342, 0x637c,0,0x7343,0,0x4268,0x795b,0x7344,0x7345, /* 笠,0,0,0,0,笥,符,笧, 笨,0,笪,0,第,笭,笮,笯, */
	/* 7b30 */ 0,0x7346,0,0x6377,0,0x637b,0x637d,0, 0,0x3a7b,0,0x795c,0,0x7341,0,0, /* 0,笱,0,笳,0,笵,笶,0, 0,笹,0,笻,0,笽,0,0, */
	/* 7b40 */ 0,0x734a,0,0,0,0x6426,0x492e,0x795d, 0x4826,0x4579,0,0x365a,0x6425,0x6423,0x795e,0x4835, /* 0,筁,0,0,0,筅,筆,筇, 筈,等,0,筋,筌,筍,筎,筏, */
	/* 7b50 */ 0x637e,0x435e,0x457b,0,0x457a,0x734c,0x3a76,0, 0,0,0,0,0,0x6438,0,0, /* 筐,筑,筒,0,答,筕,策,0, 0,0,0,0,0,筝,0,0, */
	/* 7b60 */ 0x795f,0,0,0,0x734e,0x6428,0x734f,0x642a, 0,0x7350,0,0,0x642d,0x7960,0x642e,0x7961, /* 筠,0,0,0,筤,筥,筦,筧, 0,筩,0,0,筬,筭,筮,筯, */
	/* 7b70 */ 0x642b,0x642c,0x7962,0x7351,0x6429,0x6427,0,0, 0,0x734d,0x6421,0,0,0,0,0x7349, /* 筰,筱,筲,筳,筴,筵,0,0, 0,筹,筺,0,0,0,0,筿, */
	/* 7b80 */ 0,0,0,0,0,0,0x4a4f,0x3255, 0,0,0,0x6435,0,0x6432,0,0x6437, /* 0,0,0,0,0,0,箆,箇, 0,0,0,箋,0,箍,0,箏, */
	/* 7b90 */ 0x7354,0x7355,0x6436,0,0x4773,0x4c27,0,0x3b3b, 0x6430,0x6439,0x6434,0x7356,0x6433,0x642f,0x7963,0x6431, /* 箐,箑,箒,0,箔,箕,0,算, 箘,箙,箚,箛,箜,箝,箞,箟, */
	/* 7ba0 */ 0,0x3449,0,0,0,0,0,0, 0,0,0x433d,0,0,0x407d,0,0x7358, /* 0,管,0,0,0,0,0,0, 0,0,箪,0,0,箭,0,箯, */
	/* 7bb0 */ 0,0x4822,0,0,0x643e,0x7359,0,0, 0x4824,0,0,0,0x735a,0,0,0, /* 0,箱,0,0,箴,箵,0,0, 箸,0,0,0,箼,0,0,0, */
	/* 7bc0 */ 0x4061,0x643b,0,0,0x484f,0x735b,0x643f,0x4a53, 0,0x435b,0x735c,0x643a,0x643c,0,0,0x643d, /* 節,篁,0,0,範,篅,篆,篇, 0,築,篊,篋,篌,0,0,篏, */
	/* 7bd0 */ 0,0,0,0,0x735f,0,0x7360,0x7965, 0,0x7966,0x7361,0,0,0x6440,0,0, /* 0,0,0,0,篔,0,篖,篗, 0,篙,篚,0,0,篝,0,0, */
	/* 7be0 */ 0x3c44,0,0,0,0x4646,0x6445,0x6444,0, 0,0x6441,0x7362,0,0,0x4f36,0,0, /* 篠,0,0,0,篤,篥,篦,0, 0,篩,篪,0,0,篭,0,0, */
	/* 7bf0 */ 0x7363,0,0,0x644a,0,0,0x644e,0x644b, 0,0,0,0,0,0,0,0, /* 篰,0,0,篳,0,0,篶,篷, 0,0,0,0,0,0,0,0, */
	/* 7c00 */ 0x6447,0x7967,0,0x7364,0,0,0,0x6448, 0,0,0,0x7365,0,0x644d,0x7366,0x7367, /* 簀,簁,0,簃,0,0,0,簇, 0,0,0,簋,0,簍,簎,簏, */
	/* 7c10 */ 0,0x6442,0x5255,0x6449,0x6443,0,0,0x644c, 0,0,0,0,0,0,0x7969,0x6452, /* 0,簑,簒,簓,簔,0,0,簗, 0,0,0,0,0,0,簞,簟, */
	/* 7c20 */ 0x796a,0x344a,0,0x644f,0,0,0x7368,0x6450, 0,0,0x6451,0x6454,0,0,0,0, /* 簠,簡,0,簣,0,0,簦,簧, 0,0,簪,簫,0,0,0,0, */
	/* 7c30 */ 0,0x7968,0,0x796b,0,0,0x796c,0x6453, 0x4876,0,0,0,0,0x6455,0x4e7c,0x4a6d, /* 0,簱,0,簳,0,0,簶,簷, 簸,0,0,0,0,簽,簾,簿, */
	/* 7c40 */ 0x645a,0,0,0x6457,0,0x7369,0,0, 0,0,0x736a,0,0x6456,0x4052,0,0x6459, /* 籀,0,0,籃,0,籅,0,0, 0,0,籊,0,籌,籍,0,籏, */
	/* 7c50 */ 0x645b,0x736b,0,0,0x6458,0,0x645f,0x736c, 0x645c,0x796f,0,0,0,0,0x736d,0x645d, /* 籐,籑,0,0,籔,0,籖,籗, 籘,籙,0,0,0,0,籞,籟, */
	/* 7c60 */ 0x6446,0x736e,0,0,0x645e,0x6460,0,0, 0,0x736f,0,0,0x6461,0x7970,0x7370,0x7371, /* 籠,籡,0,0,籤,籥,0,0, 0,籩,0,0,籬,籭,籮,籯, */
	/* 7c70 */ 0x7372,0,0,0x4a46,0,0x6462,0,0, 0,0x7971,0,0,0,0,0x4c62,0, /* 籰,0,0,米,0,籵,0,0, 0,籹,0,0,0,0,籾,0, */
	/* 7c80 */ 0,0x364e,0x3729,0x6463,0,0,0,0, 0,0x4a34,0,0x3f68,0,0x4c30,0,0x7972, /* 0,粁,粂,粃,0,0,0,0, 0,粉,0,粋,0,粍,0,粏, */
	/* 7c90 */ 0x6464,0,0x4e33,0,0x7973,0x4774,0,0x4146, 0x4734,0,0,0x3d4d,0,0,0,0x3040, /* 粐,0,粒,0,粔,粕,0,粗, 粘,0,0,粛,0,0,0,粟, */
	/* 7ca0 */ 0x7974,0x6469,0x6467,0,0x6465,0x3421,0x7376,0x3e51, 0x646a,0,0,0x6468,0,0x6466,0x646e,0, /* 粠,粡,粢,0,粤,粥,粦,粧, 粨,0,0,粫,0,粭,粮,0, */
	/* 7cb0 */ 0,0x646d,0x646c,0x646b,0,0,0x7378,0x7379, 0,0x646f,0,0,0x7975,0x6470,0x403a,0x737a, /* 0,粱,粲,粳,0,0,粶,粷, 0,粹,0,0,粼,粽,精,粿, */
	/* 7cc0 */ 0x6471,0,0x6473,0,0x737c,0x6472,0,0, 0x737e,0,0x3852,0,0,0x7421,0x4138,0, /* 糀,0,糂,0,糄,糅,0,0, 糈,0,糊,0,0,糍,糎,0, */
	/* 7cd0 */ 0,0,0x6475,0,0,0x7976,0x457c,0x7423, 0x6474,0x7977,0,0,0x6476,0x7978,0x4a35,0x416c, /* 0,0,糒,0,0,糕,糖,糗, 糘,糙,0,0,糜,糝,糞,糟, */
	/* 7ce0 */ 0x3947,0,0x6477,0,0,0,0x7425,0x4e48, 0,0,0,0x7426,0,0,0,0x6479, /* 糠,0,糢,0,0,0,糦,糧, 0,0,0,糫,0,0,0,糯, */
	/* 7cf0 */ 0,0,0x647a,0,0x647b,0x7428,0x647c,0, 0x3b65,0,0x647d,0x374f,0,0,0x356a,0, /* 0,0,糲,0,糴,糵,糶,0, 糸,0,糺,系,0,0,糾,0, */
	/* 7d00 */ 0x352a,0,0x6521,0x7429,0x4c73,0x3948,0x647e,0x7979, 0x797a,0x742a,0x6524,0x4c66,0,0x473c,0,0, /* 紀,0,紂,紃,約,紅,紆,紇, 紈,紉,紊,紋,0,納,0,0, */
	/* 7d10 */ 0x4933,0,0x742c,0x797b,0x3d63,0x6523,0,0x3c53, 0x3949,0x3b66,0x3569,0x4a36,0x6522,0x797c,0x742d,0, /* 紐,0,紒,紓,純,紕,0,紗, 紘,紙,級,紛,紜,紝,紞,0, */
	/* 7d20 */ 0x4147,0x4b42,0x3a77,0x797d,0,0,0,0, 0,0,0,0x3b67,0x445d,0,0x6527,0x4e5f, /* 素,紡,索,紣,0,0,0,0, 0,0,0,紫,紬,0,紮,累, */
	/* 7d30 */ 0x3a59,0x797e,0x6528,0x3f42,0,0x652a,0,0, 0,0x3e52,0x3a30,0,0,0x7430,0x7431,0x6529, /* 細,紱,紲,紳,0,紵,0,0, 0,紹,紺,0,0,紽,紾,紿, */
	/* 7d40 */ 0x7432,0x7a21,0x3d2a,0x383e,0x4148,0x6525,0x652b,0x7433, 0x7a22,0,0,0x6526,0x3750,0,0x652e,0x6532, /* 絀,絁,終,絃,組,絅,絆,絇, 絈,0,0,絋,経,0,絎,絏, */
	/* 7d50 */ 0x376b,0,0,0x7a23,0,0,0x652d,0, 0,0x7437,0x7438,0x6536,0x7a24,0,0x394a,0, /* 結,0,0,絓,0,0,絖,0, 0,絙,絚,絛,絜,0,絞,0, */
	/* 7d60 */ 0,0x4d6d,0x303c,0x6533,0,0,0x356b,0, 0x6530,0,0x7439,0,0,0,0x6531,0, /* 0,絡,絢,絣,0,0,給,0, 絨,0,絪,0,0,0,絮,0, */
	/* 7d70 */ 0x743a,0x457d,0x652f,0x652c,0,0x3328,0x4064,0, 0,0x3828,0x7a25,0,0,0x6538,0,0x743c, /* 絰,統,絲,絳,0,絵,絶,0, 0,絹,絺,0,0,絽,0,絿, */
	/* 7d80 */ 0,0,0,0x7a26,0,0,0x743e,0, 0x743f,0x6535,0,0x7a27,0x7440,0,0,0x6537, /* 0,0,0,綃,0,0,綆,0, 綈,綉,0,綋,綌,0,0,綏, */
	/* 7d90 */ 0,0,0,0x6534,0,0,0,0x7441, 0,0x3751,0x4233,0x6539,0x416e,0x7443,0,0x6546, /* 0,0,0,經,0,0,0,綗, 0,継,続,綛,綜,綝,0,綟, */
	/* 7da0 */ 0x7a28,0,0x6542,0x653c,0,0,0x7a29,0x7444, 0,0,0x7445,0x6540,0x3c7a,0x305d,0x653b,0x6543, /* 綠,0,綢,綣,0,0,綦,綧, 0,0,綪,綫,綬,維,綮,綯, */
	/* 7db0 */ 0x6547,0x394b,0x4c56,0,0x4456,0x653d,0x7446,0x7447, 0x6545,0,0x653a,0x433e,0,0x653f,0x303d,0x4c4a, /* 綰,綱,網,0,綴,綵,綶,綷, 綸,0,綺,綻,0,綽,綾,綿, */
	/* 7dc0 */ 0x7448,0,0x7a2a,0,0,0,0,0x653e, 0,0,0x365b,0x486c,0x7a2b,0,0,0x416d, /* 緀,0,緂,0,0,0,0,緇, 0,0,緊,緋,緌,0,0,総, */
	/* 7dd0 */ 0,0x4e50,0x3d6f,0,0,0x656e,0x7a2c,0x7449, 0x6548,0x744a,0x407e,0,0x6544,0x6549,0x654b,0, /* 0,緑,緒,0,0,緕,緖,緗, 緘,緙,線,0,緜,緝,緞,0, */
	/* 7de0 */ 0x4479,0x654e,0,0x7a2d,0x654a,0,0x744b,0, 0x4a54,0x344b,0,0,0x4c4b,0,0,0x305e, /* 締,緡,0,緣,緤,0,緦,0, 編,緩,0,0,緬,0,0,緯, */
	/* 7df0 */ 0,0x744c,0x654d,0,0x4e7d,0,0,0, 0,0x744d,0,0x654c,0,0,0,0, /* 0,緱,緲,0,練,0,0,0, 0,緹,0,緻,0,0,0,0, */
	/* 7e00 */ 0,0x316f,0,0,0x466c,0x654f,0,0, 0x7a30,0x6556,0x6550,0x6557,0,0,0,0, /* 0,縁,0,0,縄,縅,0,0, 縈,縉,縊,縋,0,0,0,0, */
	/* 7e10 */ 0x7451,0x7a31,0x6553,0,0,0x7a32,0,0x7452, 0,0,0,0x477b,0,0x7453,0x3c4a,0x6555, /* 縐,縑,縒,0,0,縕,0,縗, 0,0,0,縛,0,縝,縞,縟, */
	/* 7e20 */ 0x7454,0x6552,0x6558,0x6551,0,0,0x3d44,0x7455, 0x7a2f,0,0,0x4b25,0x7456,0,0x3d4c,0, /* 縠,縡,縢,縣,0,0,縦,縧, 縨,0,0,縫,縬,0,縮,0, */
	/* 7e30 */ 0,0x6554,0x6560,0,0,0x655c,0,0x655f, 0,0x655d,0x6561,0x655b,0,0x6541,0x4053,0, /* 0,縱,縲,0,0,縵,0,縷, 0,縹,縺,縻,0,總,績,0, */
	/* 7e40 */ 0,0x484b,0,0x655e,0,0x7457,0x6559,0x7a34, 0,0,0x4121,0x3752,0,0x3d2b,0,0, /* 0,繁,0,繃,0,繅,繆,繇, 0,0,繊,繋,0,繍,0,0, */
	/* 7e50 */ 0,0,0x7a35,0,0x3f25,0x4136,0x6564,0, 0,0x6566,0x6567,0,0,0x6563,0x6565,0, /* 0,0,繒,0,織,繕,繖,0, 0,繙,繚,0,0,繝,繞,0, */
	/* 7e60 */ 0,0x7a36,0,0,0,0,0x655a,0x6562, 0,0x656a,0x6569,0x7e7e,0,0x4b7a,0,0, /* 0,繡,0,0,0,0,繦,繧, 0,繩,繪,繫,0,繭,0,0, */
	/* 7e70 */ 0x372b,0,0,0x7458,0,0x7459,0,0, 0,0x6568,0,0x656c,0x656b,0x656f,0x745a,0x6571, /* 繰,0,0,繳,0,繵,0,0, 0,繹,0,繻,繼,繽,繾,繿, */
	/* 7e80 */ 0,0,0x3b3c,0x656d,0,0,0x745b,0x745c, 0x6572,0x6573,0x7a37,0,0x6574,0x7a38,0x657a,0x453b, /* 0,0,纂,纃,0,0,纆,纇, 纈,纉,纊,0,續,纍,纎,纏, */
	/* 7e90 */ 0x6576,0x745e,0x6575,0x6577,0x6578,0,0x6579,0, 0x745f,0,0x7460,0x657b,0x657c,0,0,0, /* 纐,纑,纒,纓,纔,0,纖,0, 纘,0,纚,纛,纜,0,0,0, */
	/* 7ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f30 */ 0,0,0,0,0,0,0x344c,0, 0x657d,0,0x657e,0x7463,0x7462,0,0x7464,0, /* 0,0,0,0,0,0,缶,0, 缸,0,缺,缻,缼,0,缾,0, */
	/* 7f40 */ 0,0,0,0x7465,0x7466,0x6621,0,0x7a39, 0,0,0,0,0x6622,0x6623,0x6624,0x7467, /* 0,0,0,罃,罄,罅,0,罇, 0,0,0,0,罌,罍,罎,罏, */
	/* 7f50 */ 0x6625,0x6626,0x746a,0,0x6628,0x6627,0,0, 0x6629,0,0,0,0,0,0,0x662a, /* 罐,网,罒,0,罔,罕,0,0, 罘,0,0,0,0,0,0,罟, */
	/* 7f60 */ 0x662b,0x746c,0,0x746d,0x746e,0,0,0x662e, 0x662c,0x662d,0x3a61,0x3753,0,0x746f,0x4356,0, /* 罠,罡,0,罣,罤,0,0,罧, 罨,罩,罪,罫,0,罭,置,0, */
	/* 7f70 */ 0x4833,0,0x3d70,0,0,0x474d,0,0x486d, 0x662f,0x586d,0,0,0,0x7470,0x7471,0, /* 罰,0,署,0,0,罵,0,罷, 罸,罹,0,0,0,罽,罾,0, */
	/* 7f80 */ 0,0,0x6630,0x6632,0,0x4d65,0x6631,0x6634, 0x6633,0,0x4d53,0,0x6635,0,0x487e,0, /* 0,0,羂,羃,0,羅,羆,羇, 羈,0,羊,0,羌,0,美,0, */
	/* 7f90 */ 0x7473,0x7a3b,0,0,0x6636,0,0x7476,0x7a3c, 0,0,0x6639,0,0x7477,0x6638,0x6637,0, /* 羐,羑,0,0,羔,0,羖,羗, 0,0,羚,0,羜,羝,羞,0, */
	/* 7fa0 */ 0,0,0,0x663a,0x3732,0,0,0, 0x4122,0x3541,0,0,0,0x7478,0x663e,0x663b, /* 0,0,0,羣,群,0,0,0, 羨,義,0,0,0,羭,羮,羯, */
	/* 7fb0 */ 0,0,0x663c,0,0,0,0x663f,0, 0x6640,0x663d,0,0,0,0x3129,0,0x7a3d, /* 0,0,羲,0,0,0,羶,0, 羸,羹,0,0,0,羽,0,羿, */
	/* 7fc0 */ 0,0x3227,0,0x747a,0,0x6642,0x6643,0, 0,0,0x6644,0,0x4d62,0,0x7a3e,0x747b, /* 0,翁,0,翃,0,翅,翆,0, 0,0,翊,0,翌,0,翎,翏, */
	/* 7fd0 */ 0,0,0x3d2c,0,0x6646,0x6645,0,0, 0,0,0,0x7a3f,0,0,0,0x7a40, /* 0,0,習,0,翔,翕,0,0, 0,0,0,翛,0,0,0,翟, */
	/* 7fe0 */ 0x3f69,0x6647,0,0x747c,0,0x747d,0x6648,0, 0,0x6649,0,0x3465,0x7a41,0,0x7a42,0x747e, /* 翠,翡,0,翣,0,翥,翦,0, 0,翩,0,翫,翬,0,翮,翯, */
	/* 7ff0 */ 0x344d,0,0x7521,0x664a,0,0,0,0, 0,0x664b,0x7a43,0x4b5d,0x4d63,0,0,0, /* 翰,0,翲,翳,0,0,0,0, 0,翹,翺,翻,翼,0,0,0, */
	/* 8000 */ 0x4d54,0x4f37,0x7522,0x394d,0x664e,0x3c54,0x664d,0, 0x7524,0,0x7523,0x664f,0x3c29,0,0x7525,0, /* 耀,老,耂,考,耄,者,耆,0, 耈,0,耊,耋,而,0,耎,0, */
	/* 8010 */ 0x4251,0x7526,0x6650,0,0x7a45,0x394c,0x7527,0x4c57, 0x6651,0x6652,0,0,0x6653,0,0,0, /* 耐,耑,耒,0,耔,耕,耖,耗, 耘,耙,0,0,耜,0,0,0, */
	/* 8020 */ 0,0x6654,0,0,0x7528,0,0x7a46,0, 0x6655,0,0,0,0x7529,0,0,0, /* 0,耡,0,0,耤,0,耦,0, 耨,0,0,0,耬,0,0,0, */
	/* 8030 */ 0x752a,0,0,0x3c2a,0,0x7a47,0x4c6d,0x7a48, 0,0,0,0x6657,0x7a49,0x433f,0,0x6656, /* 耰,0,0,耳,0,耵,耶,耷, 0,0,0,耻,耼,耽,0,耿, */
	/* 8040 */ 0,0,0,0x752b,0,0,0x6659,0, 0,0,0x6658,0,0,0,0,0, /* 0,0,0,聃,0,0,聆,0, 0,0,聊,0,0,0,0,0, */
	/* 8050 */ 0,0,0x665a,0,0,0,0x403b,0, 0x665b,0,0x665c,0,0,0,0x4a39,0x665d, /* 0,0,聒,0,0,0,聖,0, 聘,0,聚,0,0,0,聞,聟, */
	/* 8060 */ 0,0x416f,0x665e,0,0,0,0x752c,0, 0x665f,0,0,0,0,0,0,0x4e7e, /* 0,聡,聢,0,0,0,聦,0, 聨,0,0,0,0,0,0,聯, */
	/* 8070 */ 0x6662,0x752d,0x6661,0x6660,0x4430,0x752e,0x6663,0x3f26, 0,0x6664,0,0x752f,0,0x6665,0x4f38,0x6666, /* 聰,聱,聲,聳,聴,聵,聶,職, 0,聹,0,聻,0,聽,聾,聿, */
	/* 8080 */ 0,0,0,0,0x6667,0x6669,0x6668,0x4825, 0,0x4679,0,0x4f3e,0x4829,0,0,0, /* 0,0,0,0,肄,肅,肆,肇, 0,肉,0,肋,肌,0,0,0, */
	/* 8090 */ 0,0,0,0x666b,0,0,0x3e53,0, 0x492a,0x7530,0x666c,0x666a,0x7531,0x344e,0,0, /* 0,0,0,肓,0,0,肖,0, 肘,肙,肚,肛,肜,肝,0,0, */
	/* 80a0 */ 0,0x3854,0x3b68,0,0x7532,0x486e,0,0x7533, 0,0x382a,0x4b43,0,0x666f,0x666d,0,0x394e, /* 0,股,肢,0,肤,肥,0,肧, 0,肩,肪,0,肬,肭,0,肯, */
	/* 80b0 */ 0,0x394f,0x3069,0,0x3a68,0,0,0, 0x7534,0,0x4759,0,0,0,0,0, /* 0,肱,育,0,肴,0,0,0, 肸,0,肺,0,0,0,0,0, */
	/* 80c0 */ 0,0,0,0x305f,0x6674,0x7536,0x4340,0, 0,0,0x7a4a,0,0x4758,0,0x425b,0, /* 0,0,0,胃,胄,胅,胆,0, 0,0,胊,0,背,0,胎,0, */
	/* 80d0 */ 0,0,0,0,0,0x7537,0x6676,0x7a4b, 0x7538,0x6672,0x6675,0x6670,0,0x6673,0x4b26,0, /* 0,0,0,0,0,胕,胖,胗, 胘,胙,胚,胛,0,胝,胞,0, */
	/* 80e0 */ 0x7a4c,0x3855,0,0,0x307d,0x6671,0x7539,0, 0,0,0,0,0,0,0,0x6678, /* 胠,胡,0,0,胤,胥,胦,0, 0,0,0,0,0,0,0,胯, */
	/* 80f0 */ 0,0x6679,0,0x7a4d,0x4639,0x753c,0,0, 0x363b,0,0,0x753d,0x6726,0x473d,0,0, /* 0,胱,0,胳,胴,胵,0,0, 胸,0,0,胻,胼,能,0,0, */
	/* 8100 */ 0,0,0x3b69,0,0,0x363c,0x4048,0x4f46, 0x4c2e,0x6677,0x4054,0,0,0x753b,0,0, /* 0,0,脂,0,0,脅,脆,脇, 脈,脉,脊,0,0,脍,0,0, */
	/* 8110 */ 0,0,0,0,0,0,0x7540,0, 0x7a4e,0,0x3553,0x667a,0,0,0x7541,0, /* 0,0,0,0,0,0,脖,0, 脘,0,脚,脛,0,0,脞,0, */
	/* 8120 */ 0,0,0,0x667c,0x7543,0,0,0x7544, 0,0x667b,0,0,0x7545,0,0,0x667d, /* 0,0,0,脣,脤,0,0,脧, 0,脩,0,0,脬,0,0,脯, */
	/* 8130 */ 0,0x4326,0,0x473e,0,0x753f,0,0, 0,0x4431,0,0,0,0x7547,0x6723,0, /* 0,脱,0,脳,0,脵,0,0, 0,脹,0,0,0,脽,脾,0, */
	/* 8140 */ 0,0,0,0,0,0,0x6722,0, 0,0,0x7a4f,0x667e,0,0,0x3f55,0, /* 0,0,0,0,0,0,腆,0, 0,0,腊,腋,0,0,腎,0, */
	/* 8150 */ 0x4965,0x6725,0,0x6724,0x3950,0x4f53,0,0, 0,0,0,0,0,0,0,0x6735, /* 腐,腑,0,腓,腔,腕,0,0, 0,0,0,0,0,0,0,腟, */
	/* 8160 */ 0x7a50,0,0,0,0,0x6729,0x672a,0x7a51, 0x7a52,0x7549,0,0x3c70,0,0x7a53,0x6728,0, /* 腠,0,0,0,0,腥,腦,腧, 腨,腩,0,腫,0,腭,腮,0, */
	/* 8170 */ 0x3978,0x6727,0,0,0x672b,0,0,0, 0x4432,0x4a22,0x4123,0,0,0,0,0x425c, /* 腰,腱,0,0,腴,0,0,0, 腸,腹,腺,0,0,0,0,腿, */
	/* 8180 */ 0x672f,0x754b,0x6730,0x672c,0x754d,0x754e,0,0, 0x672d,0,0x672e,0,0,0,0,0x3951, /* 膀,膁,膂,膃,膄,膅,0,0, 膈,0,膊,0,0,0,0,膏, */
	/* 8190 */ 0,0,0,0x6736,0,0x6732,0,0, 0x7550,0,0x4966,0,0x4b6c,0x4928,0,0, /* 0,0,0,膓,0,膕,0,0, 膘,0,膚,0,膜,膝,0,0, */
	/* 81a0 */ 0x6731,0,0,0x6734,0x6733,0,0,0, 0x4b44,0x6737,0,0,0,0,0,0, /* 膠,0,0,膣,膤,0,0,0, 膨,膩,0,0,0,0,0,0, */
	/* 81b0 */ 0x6738,0,0x7551,0x4137,0,0x6739,0,0, 0x673b,0,0x673f,0x7a54,0,0x673c,0x673a,0x473f, /* 膰,0,膲,膳,0,膵,0,0, 膸,0,膺,膻,0,膽,膾,膿, */
	/* 81c0 */ 0x673d,0x7552,0x673e,0x7553,0,0,0x3232,0, 0x6745,0x6740,0x7a55,0,0,0x6741,0,0x7a56, /* 臀,臁,臂,臃,0,0,臆,0, 臈,臉,臊,0,0,臍,0,臏, */
	/* 81d0 */ 0,0x6742,0,0x4221,0,0,0x7554,0x7a57, 0x6744,0x6743,0x6746,0x7555,0,0,0,0x6747, /* 0,臑,0,臓,0,0,臖,臗, 臘,臙,臚,臛,0,0,0,臟, */
	/* 81e0 */ 0x6748,0,0,0x3f43,0x7557,0x3269,0,0x6749, 0x4e57,0,0x3c2b,0,0x7559,0x3d2d,0,0, /* 臠,0,0,臣,臤,臥,0,臧, 臨,0,自,0,臬,臭,0,0, */
	/* 81f0 */ 0,0,0,0x3b6a,0x4357,0,0,0, 0,0,0x674a,0x674b,0x3131,0x755b,0x674c,0x755c, /* 0,0,0,至,致,0,0,0, 0,0,臺,臻,臼,臽,臾,臿, */
	/* 8200 */ 0,0x674d,0x674e,0,0x755e,0x674f,0,0x6750, 0x363d,0x5a2a,0x6751,0,0x4065,0x6752,0x3c4b,0, /* 0,舁,舂,0,舄,舅,0,與, 興,舉,舊,0,舌,舍,舎,0, */
	/* 8210 */ 0x6753,0,0x5030,0,0,0,0x6754,0x4a5e, 0x345c,0x7560,0,0x4124,0x3d58,0,0x4971,0x3d2e, /* 舐,0,舒,0,0,0,舖,舗, 舘,舙,0,舛,舜,0,舞,舟, */
	/* 8220 */ 0,0x7561,0x7562,0,0,0,0,0, 0,0x6755,0x3952,0x6756,0x484c,0,0x6764,0, /* 0,舡,舢,0,0,0,0,0, 0,舩,航,舫,般,0,舮,0, */
	/* 8230 */ 0,0,0x7564,0x6758,0x7565,0x4249,0x4775,0x383f, 0x6757,0x4125,0,0,0x7566,0,0,0, /* 0,0,舲,舳,舴,舵,舶,舷, 舸,船,0,0,舼,0,0,0, */
	/* 8240 */ 0x6759,0,0,0,0,0x7569,0x7567,0x447a, 0,0x7568,0,0x756b,0,0,0,0x756d, /* 艀,0,0,0,0,艅,艆,艇, 0,艉,0,艋,0,0,0,艏, */
	/* 8250 */ 0,0,0,0,0,0,0,0x756f, 0x675b,0x675a,0x675d,0,0x7571,0x675c,0,0x675e, /* 0,0,0,0,0,0,0,艗, 艘,艙,艚,0,艜,艝,0,艟, */
	/* 8260 */ 0x7a5b,0,0x6760,0x7572,0x675f,0,0x344f,0, 0x6761,0,0x6762,0x6763,0,0,0x3a31,0x4e49, /* 艠,0,艢,艣,艤,0,艦,0, 艨,0,艪,艫,0,0,艮,良, */
	/* 8270 */ 0,0x6765,0x3f27,0,0x7a5c,0,0x3170,0x6766, 0x6767,0x7576,0,0,0,0x7578,0x6768,0x7579, /* 0,艱,色,0,艴,0,艶,艷, 艸,艹,0,0,0,艽,艾,艿, */
	/* 8280 */ 0,0,0,0x757a,0,0,0,0, 0,0,0x757b,0x3072,0,0x6769,0x7a5e,0, /* 0,0,0,芃,0,0,0,0, 0,0,芊,芋,0,芍,芎,0, */
	/* 8290 */ 0,0,0x676a,0x757c,0,0,0,0, 0,0x4967,0,0,0,0x3c47,0,0x676c, /* 0,0,芒,芓,0,0,0,0, 0,芙,0,0,0,芝,0,芟, */
	/* 82a0 */ 0,0x7a5f,0,0x7a60,0x7a61,0x3329,0x3032,0x757d, 0x757e,0x7a62,0,0x676b,0x676e,0x474e,0x7a63,0x3f44, /* 0,芡,0,芣,芤,芥,芦,芧, 芨,芩,0,芫,芬,芭,芮,芯, */
	/* 82b0 */ 0,0x3256,0x7621,0x4b27,0x7622,0,0,0x7a64, 0x375d,0x365c,0x7623,0x676d,0x7624,0x326a,0x7a65,0x7a66, /* 0,花,芲,芳,芴,0,0,芷, 芸,芹,芺,芻,芼,芽,芾,芿, */
	/* 82c0 */ 0,0,0,0,0,0x3423,0x7a67,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,苅,苆,0, 0,0,0,0,0,0,0,0, */
	/* 82d0 */ 0,0x3171,0x6772,0x4e6a,0x425d,0x7a68,0,0x4944, 0,0x677e,0,0x3257,0x677c,0,0x677a,0x6771, /* 0,苑,苒,苓,苔,苕,0,苗, 0,苙,0,苛,苜,0,苞,苟, */
	/* 82e0 */ 0,0x676f,0x7625,0x6770,0,0x3c63,0x366c,0x4377, 0x7626,0,0,0x4651,0,0,0,0, /* 0,苡,苢,苣,0,若,苦,苧, 苨,0,0,苫,0,0,0,0, */
	/* 82f0 */ 0,0x3151,0,0x6774,0x6773,0,0,0x7627, 0,0x6779,0x6775,0x6778,0,0x7a69,0x7a6a,0, /* 0,英,0,苳,苴,0,0,苷, 0,苹,苺,苻,0,苽,苾,0, */
	/* 8300 */ 0x7a6b,0x7a6c,0x4c50,0x6777,0x3258,0x337d,0x677b,0x7628, 0x7629,0x677d,0,0,0x762a,0,0x3754,0, /* 茀,茁,茂,范,茄,茅,茆,茇, 茈,茉,0,0,茌,0,茎,0, */
	/* 8310 */ 0,0,0,0,0,0,0x6823,0x682c, 0x682d,0,0,0x762c,0x302b,0x762d,0,0, /* 0,0,0,0,0,0,茖,茗, 茘,0,0,茛,茜,茝,0,0, */
	/* 8320 */ 0,0,0x7a6e,0x6834,0,0,0,0, 0x3071,0,0,0x682b,0,0x7a6f,0,0x682a, /* 0,0,茢,茣,0,0,0,0, 茨,0,0,茫,0,茭,0,茯, */
	/* 8330 */ 0x762e,0x6825,0x6824,0,0x6822,0x6821,0x4363,0, 0x427b,0x6827,0x7a70,0,0x762f,0,0,0, /* 茰,茱,茲,0,茴,茵,茶,0, 茸,茹,茺,0,茼,0,0,0, */
	/* 8340 */ 0x6826,0,0,0x7a71,0x7630,0x6829,0,0x7a72, 0,0x4170,0x3755,0,0,0,0,0x3141, /* 荀,0,0,荃,荄,荅,0,荇, 0,草,荊,0,0,0,0,荏, */
	/* 8350 */ 0x6828,0x7a73,0x3953,0,0x762b,0x7a74,0,0x7631, 0x4171,0,0,0,0,0,0,0, /* 荐,荑,荒,0,荔,荕,0,荗, 荘,0,0,0,0,0,0,0, */
	/* 8360 */ 0,0,0x7a6d,0x2e4a,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,荢,荣,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8370 */ 0,0,0,0x683a,0,0x683b,0,0x3259, 0,0,0,0x322e,0x6838,0x7a75,0,0x7633, /* 0,0,0,荳,0,荵,0,荷, 0,0,0,荻,荼,荽,0,荿, */
	/* 8380 */ 0,0,0,0,0,0x682e,0x7a76,0x6836, 0,0x683d,0x6837,0,0,0x7636,0x6835,0, /* 0,0,0,0,0,莅,莆,莇, 0,莉,莊,0,0,莍,莎,0, */
	/* 8390 */ 0,0,0x7a77,0x6776,0x7637,0x7638,0x6833,0, 0x7a78,0,0x682f,0x7639,0,0x763a,0x3450,0x6831, /* 0,0,莒,莓,莔,莕,莖,0, 莘,0,莚,莛,0,莝,莞,莟, */
	/* 83a0 */ 0x683c,0,0x6832,0,0,0,0,0x7a79, 0x683e,0x7a7a,0x6830,0x477c,0,0,0,0, /* 莠,0,莢,0,0,0,0,莧, 莨,莩,莪,莫,0,0,0,0, */
	/* 83b0 */ 0,0x4d69,0,0,0,0x6839,0,0, 0,0,0,0,0,0x684f,0,0x7a7b, /* 0,莱,0,0,0,莵,0,0, 0,0,0,0,0,莽,0,莿, */
	/* 83c0 */ 0x7a7c,0x6847,0,0,0,0x3f7b,0,0x7a7d, 0,0x763b,0x3546,0,0x365d,0,0x6842,0x7a7e, /* 菀,菁,0,0,0,菅,0,菇, 0,菉,菊,0,菌,0,菎,菏, */
	/* 83d0 */ 0x763c,0x7b21,0,0x325b,0x763d,0,0x3e54,0, 0x6845,0,0,0,0x3a5a,0x763e,0,0x4551, /* 菐,菑,0,菓,菔,0,菖,0, 菘,0,0,0,菜,菝,0,菟, */
	/* 83e0 */ 0x684a,0x7b22,0,0,0,0x763f,0,0, 0,0x4a6e,0x7b23,0x6841,0,0,0,0x325a, /* 菠,菡,0,0,0,菥,0,0, 0,菩,菪,菫,0,0,0,華, */
	/* 83f0 */ 0x3856,0x4929,0x684b,0,0x683f,0,0,0x6848, 0,0x7640,0,0x6852,0,0x6843,0,0, /* 菰,菱,菲,0,菴,0,0,菷, 0,菹,0,菻,0,菽,0,0, */
	/* 8400 */ 0,0x7b24,0,0x6844,0x463a,0,0x7b25,0x6849, 0,0,0x7b26,0x6846,0x4b28,0x684c,0x3060,0x7641, /* 0,萁,0,萃,萄,0,萆,萇, 0,0,萊,萋,萌,萍,萎,萏, */
	/* 8410 */ 0,0x7642,0,0x6840,0,0x7643,0,0x7645, 0,0,0,0,0,0,0,0, /* 0,萑,0,萓,0,萕,0,萗, 0,0,0,0,0,0,0,0, */
	/* 8420 */ 0x684e,0,0x684d,0,0,0,0,0, 0,0x476b,0x6854,0,0x685f,0,0,0, /* 萠,0,萢,0,0,0,0,0, 0,萩,萪,0,萬,0,0,0, */
	/* 8430 */ 0,0x337e,0,0,0,0x6862,0,0, 0x6850,0x7646,0,0,0x6855,0x4d6e,0,0, /* 0,萱,0,0,0,萵,0,0, 萸,萹,0,0,萼,落,0,0, */
	/* 8440 */ 0,0,0,0,0,0,0x685e,0, 0x7b28,0x4d55,0x7647,0,0,0,0x4e2a,0x7648, /* 0,0,0,0,0,0,葆,0, 葈,葉,葊,0,0,0,葎,葏, */
	/* 8450 */ 0,0x7649,0x764a,0,0,0,0,0x4378, 0,0x764b,0x764c,0x336b,0x764d,0,0,0x7b29, /* 0,葑,葒,0,0,0,0,著, 0,葙,葚,葛,葜,0,0,葟, */
	/* 8460 */ 0,0x4972,0x6864,0x4621,0,0x764f,0x3031,0, 0,0x685d,0,0x6859,0x4172,0x6853,0x685b,0x6860, /* 0,葡,葢,董,0,葥,葦,0, 0,葩,0,葫,葬,葭,葮,葯, */
	/* 8470 */ 0x7b2a,0x472c,0,0x7b2b,0,0x302a,0x7650,0x6858, 0x7651,0x6861,0x4978,0,0x7652,0,0,0, /* 葰,葱,0,葳,0,葵,葶,葷, 葸,葹,葺,0,葼,0,0,0, */
	/* 8480 */ 0,0x7653,0x685c,0,0x6857,0x7b2c,0,0, 0,0,0,0x3e55,0,0,0,0, /* 0,蒁,蒂,0,蒄,蒅,0,0, 0,0,0,蒋,0,0,0,0, */
	/* 8490 */ 0x3d2f,0,0,0,0x3c2c,0,0,0x7656, 0,0x4c58,0,0,0x4947,0,0x7b2d,0x6867, /* 蒐,0,0,0,蒔,0,0,蒗, 0,蒙,0,0,蒜,0,蒞,蒟, */
	/* 84a0 */ 0,0x6870,0,0,0,0,0x7657,0, 0,0,0,0,0,0x685a,0,0x7b2e, /* 0,蒡,0,0,0,0,蒦,0, 0,0,0,0,0,蒭,0,蒯, */
	/* 84b0 */ 0,0,0x3377,0,0x7b2f,0,0,0, 0x3e78,0x6865,0x7b30,0x686a,0x4173,0,0x7658,0x6866, /* 0,0,蒲,0,蒴,0,0,0, 蒸,蒹,蒺,蒻,蒼,0,蒾,蒿, */
	/* 84c0 */ 0x7b31,0x686d,0x7b32,0,0x435f,0,0x686e,0, 0,0x4d56,0x6863,0x3338,0,0x6869,0x765a,0x765b, /* 蓀,蓁,蓂,0,蓄,0,蓆,0, 0,蓉,蓊,蓋,0,蓍,蓎,蓏, */
	/* 84d0 */ 0x686c,0x4c2c,0,0x765c,0,0,0x686f,0, 0,0x6868,0x686b,0,0x7655,0,0,0, /* 蓐,蓑,0,蓓,0,0,蓖,0, 0,蓙,蓚,0,蓜,0,0,0, */
	/* 84e0 */ 0,0,0,0,0,0,0,0x765e, 0,0,0x765f,0,0x4b29,0,0x4f21,0x7660, /* 0,0,0,0,0,0,0,蓧, 0,0,蓪,0,蓬,0,蓮,蓯, */
	/* 84f0 */ 0x7661,0x7662,0,0,0x6873,0,0,0, 0,0,0x7663,0,0x687a,0x7664,0,0x6872, /* 蓰,蓱,0,0,蓴,0,0,0, 0,0,蓺,0,蓼,蓽,0,蓿, */
	/* 8500 */ 0x3c43,0,0,0,0,0,0x6851,0, 0,0,0,0,0x7665,0,0,0, /* 蔀,0,0,0,0,0,蔆,0, 0,0,0,0,蔌,0,0,0, */
	/* 8510 */ 0,0x4a4e,0,0x4c22,0x6879,0x6878,0,0x6874, 0x6875,0,0x3136,0x7666,0,0,0x7b35,0x6877, /* 0,蔑,0,蔓,蔔,蔕,0,蔗, 蔘,0,蔚,蔛,0,0,蔞,蔟, */
	/* 8520 */ 0,0x6871,0,0x7b36,0x7667,0x7668,0x4455,0, 0,0,0,0x7669,0x6876,0x307e,0,0x7b37, /* 0,蔡,0,蔣,蔤,蔥,蔦,0, 0,0,0,蔫,蔬,蔭,0,蔯, */
	/* 8530 */ 0,0,0x7b34,0,0x766a,0x4222,0,0, 0,0,0,0,0,0x4a43,0x766f,0, /* 0,0,蔲,0,蔴,蔵,0,0, 0,0,0,0,0,蔽,蔾,0, */
	/* 8540 */ 0x687b,0x6921,0,0x4859,0,0,0,0, 0x687e,0x3e56,0x3c49,0x6923,0,0,0x363e,0x766b, /* 蕀,蕁,0,蕃,0,0,0,0, 蕈,蕉,蕊,蕋,0,0,蕎,蕏, */
	/* 8550 */ 0,0x7670,0,0x7671,0,0x6924,0,0x4979, 0x687d,0x7b38,0x6856,0,0,0,0x7672,0, /* 0,蕑,0,蕓,0,蕕,0,蕗, 蕘,蕙,蕚,0,0,0,蕞,0, */
	/* 8560 */ 0,0x7673,0x7674,0x687c,0x7b39,0,0,0, 0x4f4f,0x4622,0x4973,0,0,0x692b,0,0x766c, /* 0,蕡,蕢,蕣,蕤,0,0,0, 蕨,蕩,蕪,0,0,蕭,0,蕯, */
	/* 8570 */ 0,0,0,0,0,0,0,0x6931, 0,0,0x7b3c,0x7676,0,0x7677,0x6932,0x7678, /* 0,0,0,0,0,0,0,蕷, 0,0,蕺,蕻,0,蕽,蕾,蕿, */
	/* 8580 */ 0x6925,0x7679,0,0,0x4776,0,0x767a,0x692f, 0x6927,0,0x6929,0,0x7b3d,0,0,0x7b3e, /* 薀,薁,0,0,薄,0,薆,薇, 薈,0,薊,0,薌,0,0,薏, */
	/* 8590 */ 0x6933,0x6928,0,0x767b,0x692c,0,0,0x3172, 0,0x4665,0,0x692d,0x6930,0x767c,0,0x767d, /* 薐,薑,0,薓,薔,0,0,薗, 0,薙,0,薛,薜,薝,0,薟, */
	/* 85a0 */ 0,0,0x7b3f,0,0x6926,0,0x4126,0, 0x692a,0x3b27,0x3f45,0x3730,0x4c74,0x7b3b,0x4c79,0x3d72, /* 0,0,薢,0,薤,0,薦,0, 薨,薩,薪,薫,薬,薭,薮,薯, */
	/* 85b0 */ 0x7b40,0,0,0,0,0,0,0x7723, 0,0x6937,0x6935,0,0x7724,0,0,0, /* 薰,0,0,0,0,0,0,薷, 0,薹,薺,0,薼,0,0,0, */
	/* 85c0 */ 0,0x4f4e,0,0,0,0,0,0x7725, 0,0x6934,0x7726,0x7b41,0,0x4d75,0x7b42,0x6936, /* 0,藁,0,0,0,0,0,藇, 0,藉,藊,藋,0,藍,藎,藏, */
	/* 85d0 */ 0x6938,0,0,0,0,0x6939,0,0, 0x7727,0x7728,0,0,0x693c,0x693a,0,0x7729, /* 藐,0,0,0,0,藕,0,0, 藘,藙,0,0,藜,藝,0,藟, */
	/* 85e0 */ 0,0x772a,0,0,0x4623,0x693b,0x772b,0, 0,0x484d,0x692e,0,0,0x7b43,0,0, /* 0,藡,0,0,藤,藥,藦,0, 0,藩,藪,0,0,藭,0,0, */
	/* 85f0 */ 0,0,0,0,0,0,0x772c,0x3d73, 0,0x693d,0x6942,0x4174,0,0,0x6941,0x7b45, /* 0,0,0,0,0,0,藶,藷, 0,藹,藺,藻,0,0,藾,藿, */
	/* 8600 */ 0x772d,0,0x6922,0,0x7b46,0x7b47,0x6943,0x4149, 0,0,0x693e,0x6940,0,0,0,0, /* 蘀,0,蘂,0,蘄,蘅,蘆,蘇, 0,0,蘊,蘋,0,0,0,0, */
	/* 8610 */ 0x7b48,0x772e,0x7b44,0x693f,0,0,0x5d31,0x5d22, 0x7b4a,0,0x6945,0,0,0,0x772f,0, /* 蘐,蘑,蘒,蘓,0,0,蘖,蘗, 蘘,0,蘚,0,0,0,蘞,0, */
	/* 8620 */ 0,0x7730,0x6944,0,0x7731,0,0,0x7732, 0,0x7b4b,0,0,0,0x4d76,0,0x623c, /* 0,蘡,蘢,0,蘤,0,0,蘧, 0,蘩,0,0,0,蘭,0,蘯, */
	/* 8630 */ 0x6946,0,0,0,0,0,0,0, 0x7b4c,0x7734,0,0,0x7735,0,0,0x6947, /* 蘰,0,0,0,0,0,0,0, 蘸,蘹,0,0,蘼,0,0,蘿, */
	/* 8640 */ 0x7737,0x2f68,0,0,0,0,0,0, 0,0,0,0,0,0x6948,0x3857,0, /* 虀,虁,0,0,0,0,0,0, 0,0,0,0,0,虍,虎,0, */
	/* 8650 */ 0x3554,0,0,0x7739,0x694a,0x515d,0x773a,0x7b4d, 0,0,0x3575,0x7b4e,0x4e3a,0,0x3673,0x694b, /* 虐,0,0,虓,虔,處,虖,虗, 0,0,虚,虛,虜,0,虞,號, */
	/* 8660 */ 0,0,0x7b50,0,0,0,0,0x694c, 0,0,0,0x436e,0x7b52,0,0,0x773b, /* 0,0,虢,0,0,0,0,虧, 0,0,0,虫,虬,0,0,虯, */
	/* 8670 */ 0,0x694d,0,0,0,0x7b53,0,0x773c, 0,0x467a,0x773d,0x303a,0,0,0,0, /* 0,虱,0,0,0,虵,0,虷, 0,虹,虺,虻,0,0,0,0, */
	/* 8680 */ 0,0,0,0,0,0,0,0x773e, 0,0x773f,0x3263,0x6952,0x6953,0x7740,0,0, /* 0,0,0,0,0,0,0,蚇, 0,蚉,蚊,蚋,蚌,蚍,0,0, */
	/* 8690 */ 0,0x7741,0,0x694e,0,0x3b3d,0,0, 0x7b54,0,0,0,0x7742,0x7743,0,0, /* 0,蚑,0,蚓,0,蚕,0,0, 蚘,0,0,0,蚜,蚝,0,0, */
	/* 86a0 */ 0,0,0,0x694f,0x4742,0,0,0, 0x7744,0x6950,0x6951,0x695b,0,0,0,0x6955, /* 0,0,0,蚣,蚤,0,0,0, 蚨,蚩,蚪,蚫,0,0,0,蚯, */
	/* 86b0 */ 0x6958,0x7746,0,0x7747,0,0,0x6954,0, 0x7b55,0,0,0,0,0,0,0, /* 蚰,蚱,0,蚳,0,0,蚶,0, 蚸,0,0,0,0,0,0,0, */
	/* 86c0 */ 0,0x7748,0,0x7749,0x6956,0,0x6957,0x3c58, 0,0x6959,0,0x4341,0,0x3756,0x3342,0, /* 0,蛁,0,蛃,蛄,0,蛆,蛇, 0,蛉,0,蛋,0,蛍,蛎,0, */
	/* 86d0 */ 0,0x774a,0,0,0x695c,0x774b,0,0x774c, 0,0x333f,0,0x6961,0,0,0x695d,0x6960, /* 0,蛑,0,0,蛔,蛕,0,蛗, 0,蛙,0,蛛,0,0,蛞,蛟, */
	/* 86e0 */ 0,0,0,0x774d,0x483a,0,0x774e,0, 0,0x695e,0,0,0x695f,0x4948,0x485a,0x6962, /* 0,0,0,蛣,蛤,0,蛦,0, 0,蛩,0,0,蛬,蛭,蛮,蛯, */
	/* 86f0 */ 0,0,0,0,0,0,0,0, 0x427d,0x696c,0x7b56,0x6968,0x7b57,0x7b58,0x326b,0, /* 0,0,0,0,0,0,0,0, 蛸,蛹,蛺,蛻,蛼,蛽,蛾,0, */
	/* 8700 */ 0x6966,0,0x4b2a,0x6967,0,0x7750,0x6964,0x7751, 0x6965,0x696a,0x696d,0x7b59,0,0x696b,0x7752,0, /* 蜀,0,蜂,蜃,0,蜅,蜆,蜇, 蜈,蜉,蜊,蜋,0,蜍,蜎,0, */
	/* 8710 */ 0x7753,0x6969,0x6963,0x7754,0,0,0,0, 0x4358,0x7755,0x6974,0,0x4c2a,0,0,0x7756, /* 蜐,蜑,蜒,蜓,0,0,0,0, 蜘,蜙,蜚,0,蜜,0,0,蜟, */
	/* 8720 */ 0,0x7757,0,0x7758,0,0x6972,0,0, 0,0x6973,0,0,0,0,0,0, /* 0,蜡,0,蜣,0,蜥,0,0, 0,蜩,0,0,0,0,0,0, */
	/* 8730 */ 0,0x7759,0,0,0x696e,0,0,0x6970, 0,0,0x775a,0x6971,0,0,0x775b,0x696f, /* 0,蜱,0,0,蜴,0,0,蜷, 0,0,蜺,蜻,0,0,蜾,蜿, */
	/* 8740 */ 0x775c,0,0,0x775d,0,0,0,0, 0,0x4066,0,0x4f39,0x6978,0,0x6979,0, /* 蝀,0,0,蝃,0,0,0,0, 0,蝉,0,蝋,蝌,0,蝎,0, */
	/* 8750 */ 0,0x775e,0,0x6a21,0,0x3f2a,0,0x697b, 0x775f,0x697e,0,0,0,0,0,0x6976, /* 0,蝑,0,蝓,0,蝕,0,蝗, 蝘,蝙,0,0,0,0,0,蝟, */
	/* 8760 */ 0x6975,0,0,0x6a22,0x7760,0x7761,0x325c,0, 0x697c,0,0x6a23,0,0,0,0x697d,0, /* 蝠,0,0,蝣,蝤,蝥,蝦,0, 蝨,0,蝪,0,0,0,蝮,0, */
	/* 8770 */ 0,0x7b5a,0x7762,0,0x697a,0,0x4433,0, 0x6977,0,0,0,0x7763,0,0,0x4768, /* 0,蝱,蝲,0,蝴,0,蝶,0, 蝸,0,0,0,蝼,0,0,蝿, */
	/* 8780 */ 0,0,0x6a27,0,0,0,0,0x7b5b, 0x7b5c,0x7767,0,0x7768,0,0x4d3b,0,0, /* 0,0,螂,0,0,0,0,螇, 螈,螉,0,螋,0,融,0,0, */
	/* 8790 */ 0,0,0,0x7769,0,0,0,0, 0,0,0,0,0,0,0,0x6a26, /* 0,0,0,螓,0,0,0,0, 0,0,0,0,0,0,0,螟, */
	/* 87a0 */ 0x776a,0,0x6a25,0,0,0,0,0x7766, 0,0,0,0x6a2e,0x7b5d,0x7b5e,0,0x6a28, /* 螠,0,螢,0,0,0,0,螧, 0,0,0,螫,螬,螭,0,螯, */
	/* 87b0 */ 0,0,0,0x6a30,0,0x7b5f,0,0, 0,0,0x4d66,0x6a33,0,0x6a2a,0x776d,0, /* 0,0,0,螳,0,螵,0,0, 0,0,螺,螻,0,螽,螾,0, */
	/* 87c0 */ 0x6a2b,0x776f,0,0,0x6a2f,0,0x6a32,0x6a31, 0,0,0,0x6a29,0,0,0x7770,0, /* 蟀,蟁,0,0,蟄,0,蟆,蟇, 0,0,0,蟋,0,0,蟎,0, */
	/* 87d0 */ 0x6a2c,0,0x6a3d,0,0,0,0x7b61,0, 0,0,0,0,0,0,0,0x7772, /* 蟐,0,蟒,0,0,0,蟖,0, 0,0,0,0,0,0,0,蟟, */
	/* 87e0 */ 0x6a36,0,0,0x7774,0,0x7775,0x7776,0, 0,0,0x7777,0x7778,0x7b62,0x7779,0,0x6a34, /* 蟠,0,0,蟣,0,蟥,蟦,0, 0,0,蟪,蟫,蟬,蟭,0,蟯, */
	/* 87f0 */ 0,0,0x6a35,0,0,0x7771,0x6a3a,0x6a3b, 0,0x332a,0,0x3542,0,0,0x6a39,0, /* 0,0,蟲,0,0,蟵,蟶,蟷, 0,蟹,0,蟻,0,0,蟾,0, */
	/* 8800 */ 0,0x777a,0,0x777b,0,0x6a24,0x7b63,0, 0,0,0x7b64,0x777c,0,0x6a38,0x6a3c,0x6a37, /* 0,蠁,0,蠃,0,蠅,蠆,0, 0,0,蠊,蠋,0,蠍,蠎,蠏, */
	/* 8810 */ 0x7b65,0x6a3e,0,0x777d,0x7b66,0x6a40,0x6a3f,0, 0,0,0,0,0,0,0,0x7b67, /* 蠐,蠑,0,蠓,蠔,蠕,蠖,0, 0,0,0,0,0,0,0,蠟, */
	/* 8820 */ 0,0x6a42,0x6a41,0x695a,0,0,0,0x6a46, 0x777e,0,0,0,0,0,0x7821,0, /* 0,蠡,蠢,蠣,0,0,0,蠧, 蠨,0,0,0,0,0,蠮,0, */
	/* 8830 */ 0,0x6a43,0x7822,0,0,0,0x6a44,0, 0,0x6a45,0,0x6a47,0x7823,0,0,0, /* 0,蠱,蠲,0,0,0,蠶,0, 0,蠹,0,蠻,蠼,0,0,0, */
	/* 8840 */ 0x376c,0,0x6a49,0,0x6a48,0,0x3d30,0, 0,0,0x7825,0,0x3954,0x5e27,0,0, /* 血,0,衂,0,衄,0,衆,0, 0,0,衊,0,行,衍,0,0, */
	/* 8850 */ 0,0,0x6a4a,0x3d51,0,0,0,0x3339, 0x7826,0x6a4b,0,0x3152,0,0x3e57,0x6a4c,0x7827, /* 0,0,衒,術,0,0,0,街, 衘,衙,0,衛,0,衝,衞,衟, */
	/* 8860 */ 0,0x3955,0x6a4d,0x3061,0x7828,0,0,0, 0x493d,0x782b,0,0x6a4e,0,0,0,0x782d, /* 0,衡,衢,衣,衤,0,0,0, 表,衩,0,衫,0,0,0,衯, */
	/* 8870 */ 0x3f6a,0,0x6a55,0,0,0x6a52,0,0x436f, 0,0,0,0,0,0x6a53,0x6a50,0x365e, /* 衰,0,衲,0,0,衵,0,衷, 0,0,0,0,0,衽,衾,衿, */
	/* 8880 */ 0,0x6a4f,0x6a56,0,0,0,0,0, 0x3736,0,0,0x425e,0,0x6a5c,0,0, /* 0,袁,袂,0,0,0,0,0, 袈,0,0,袋,0,袍,0,0, */
	/* 8890 */ 0,0,0x6a58,0,0,0,0x4235,0x6a57, 0x7b68,0x6a5a,0,0,0,0,0x6a51,0, /* 0,0,袒,0,0,0,袖,袗, 袘,袙,0,0,0,0,袞,0, */
	/* 88a0 */ 0x782e,0,0x6a5b,0,0x6a5d,0,0,0, 0,0,0x7b69,0x486f,0,0,0x6a59,0, /* 袠,0,袢,0,袤,0,0,0, 0,0,袪,被,0,0,袮,0, */
	/* 88b0 */ 0x6a5e,0x6a60,0,0,0x3853,0x6a54,0,0x3041, 0,0,0,0,0x782f,0x7830,0x7831,0x6a5f, /* 袰,袱,0,0,袴,袵,0,袷, 0,0,0,0,袼,袽,袾,袿, */
	/* 88c0 */ 0x7832,0x3a5b,0x4e76,0x6a61,0x6a62,0x4175,0,0, 0,0,0x7b6a,0,0,0,0x7b6b,0x4e22, /* 裀,裁,裂,裃,裄,装,0,0, 0,0,裊,0,0,0,裎,裏, */
	/* 88d0 */ 0,0x7835,0x7833,0x7836,0x6a63,0x4d35,0,0, 0x6a64,0x6a65,0,0x7837,0x4a64,0x6a66,0,0x3a40, /* 0,裑,裒,裓,裔,裕,0,0, 裘,裙,0,裛,補,裝,0,裟, */
	/* 88e0 */ 0,0x4e23,0,0,0,0,0,0, 0x6a6b,0,0,0,0,0,0,0, /* 0,裡,0,0,0,0,0,0, 裨,0,0,0,0,0,0,0, */
	/* 88f0 */ 0x7838,0x7839,0x6a6c,0x3e58,0x6a6a,0x7b6d,0,0, 0x4d67,0x6a67,0,0,0x6a69,0x403d,0x3f7e,0, /* 裰,裱,裲,裳,裴,裵,0,0, 裸,裹,0,0,裼,製,裾,0, */
	/* 8900 */ 0,0x783b,0x6a68,0,0x6a6d,0,0,0x4a23, 0,0,0x6a6f,0,0x6a6e,0,0,0, /* 0,褁,褂,0,褄,0,0,複, 0,0,褊,0,褌,0,0,0, */
	/* 8910 */ 0x336c,0,0x4b2b,0x6a70,0,0,0,0, 0x7b70,0x7b71,0x7b72,0,0x7b6e,0x6a7c,0x6a72,0, /* 褐,0,褒,褓,0,0,0,0, 褘,褙,褚,0,褜,褝,褞,0, */
	/* 8920 */ 0,0,0,0,0,0x6a73,0,0x7b73, 0,0,0x6a74,0x6a75,0,0,0,0, /* 0,0,0,0,0,褥,0,褧, 0,0,褪,褫,0,0,0,0, */
	/* 8930 */ 0x7b74,0,0x7b75,0,0,0,0x6a79,0x783d, 0x6a7a,0x7b76,0,0x6a78,0,0,0,0, /* 褰,0,褲,0,0,0,褶,褷, 褸,褹,0,褻,0,0,0,0, */
	/* 8940 */ 0x7b77,0x6a76,0x783f,0x6a71,0x6a77,0x7840,0,0, 0,0x7841,0,0,0x6a7b,0x7037,0,0, /* 襀,襁,襂,襃,襄,襅,0,0, 0,襉,0,0,襌,襍,0,0, */
	/* 8950 */ 0,0,0,0,0,0,0x3228,0, 0,0,0,0,0,0,0x6a7e,0x365f, /* 0,0,0,0,0,0,襖,0, 0,0,0,0,0,0,襞,襟, */
	/* 8960 */ 0x6a7d,0,0x7844,0,0x6b22,0,0x6b21,0, 0,0,0x6b24,0,0,0x6b23,0,0x6b25, /* 襠,0,襢,0,襤,0,襦,0, 0,0,襪,0,0,襭,0,襯, */
	/* 8970 */ 0,0,0x3d31,0,0x6b26,0,0,0x6b27, 0,0,0,0,0,0,0x6b28,0x403e, /* 0,0,襲,0,襴,0,0,襷, 0,0,0,0,0,0,襾,西, */
	/* 8980 */ 0x7845,0x4d57,0,0x6b29,0,0,0x4a24,0x4746, 0x6b2a,0x7846,0x6b2b,0x382b,0,0,0,0x352c, /* 覀,要,0,覃,0,0,覆,覇, 覈,覉,覊,見,0,0,0,規, */
	/* 8990 */ 0x7847,0,0,0x6b2c,0x7b78,0,0x3b6b,0x4741, 0x6b2d,0,0x3350,0,0,0,0,0x7848, /* 覐,0,0,覓,覔,0,視,覗, 覘,0,覚,0,0,0,0,覟, */
	/* 89a0 */ 0,0x6b2e,0,0,0,0,0x6b30,0x4d77, 0,0x6b2f,0x3f46,0,0x6b31,0,0,0x6b32, /* 0,覡,0,0,0,0,覦,覧, 0,覩,親,0,覬,0,0,覯, */
	/* 89b0 */ 0x7849,0,0x6b33,0x3451,0,0,0,0x784a, 0,0,0x6b34,0,0,0x6b35,0,0x6b36, /* 覰,0,覲,観,0,0,0,覷, 0,0,覺,0,0,覽,0,覿, */
	/* 89c0 */ 0x6b37,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 觀,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 89d0 */ 0,0,0x3351,0,0x7b7a,0,0x784b,0, 0x784c,0,0x6b38,0,0x6b39,0x6b3a,0,0, /* 0,0,角,0,觔,0,觖,0, 觘,0,觚,0,觜,觝,0,0, */
	/* 89e0 */ 0,0,0,0x3272,0,0x7b7b,0x3f28,0x6b3b, 0,0,0,0x784d,0,0,0,0, /* 0,0,0,解,0,觥,触,觧, 0,0,0,觫,0,0,0,0, */
	/* 89f0 */ 0,0x784f,0,0x7850,0x6b3c,0,0x7b7c,0, 0x6b3d,0,0,0,0,0x7851,0,0x7852, /* 0,觱,0,觳,觴,0,觶,0, 觸,0,0,0,0,觽,0,觿, */
	/* 8a00 */ 0x3840,0,0x447b,0x6b3e,0,0,0,0, 0x3757,0,0x3f56,0,0x6b41,0,0x4624,0, /* 言,0,訂,訃,0,0,0,0, 計,0,訊,0,訌,0,討,0, */
	/* 8a10 */ 0x6b40,0x7854,0x7b7d,0x3731,0x7855,0x7b7e,0x6b3f,0x4277, 0x352d,0,0,0x6b42,0,0x6b43,0,0x3e59, /* 訐,訑,訒,訓,訔,訕,訖,託, 記,0,0,訛,0,訝,0,訟, */
	/* 8a20 */ 0,0x7857,0x7c21,0x376d,0,0x6b44,0,0, 0,0,0x4b2c,0,0,0x405f,0,0, /* 0,訡,訢,訣,0,訥,0,0, 0,0,訪,0,0,設,0,0, */
	/* 8a30 */ 0,0x3576,0,0x4c75,0x414a,0x7858,0x6b45,0x7c22, 0,0,0x3f47,0x4370,0x3e5a,0,0x7859,0, /* 0,許,0,訳,訴,訵,訶,訷, 0,0,診,註,証,0,訾,0, */
	/* 8a40 */ 0,0x6b46,0,0,0,0x785a,0x6b49,0x7c23, 0x6b4a,0,0,0,0,0x785b,0x7c24,0, /* 0,詁,0,0,0,詅,詆,詇, 詈,0,0,0,0,詍,詎,0, */
	/* 8a50 */ 0x3a3e,0x4242,0x6b48,0,0x3e5b,0x493e,0,0, 0x785c,0,0,0x6b47,0,0x7c25,0x3b6c,0, /* 詐,詑,詒,0,詔,評,0,0, 詘,0,0,詛,0,詝,詞,0, */
	/* 8a60 */ 0x3153,0x7c26,0x6b4e,0x3758,0,0,0x3b6e,0, 0,0x3b6d,0,0x4f4d,0x6b4d,0x6b4c,0x4127,0, /* 詠,詡,詢,詣,0,0,試,0, 0,詩,0,詫,詬,詭,詮,0, */
	/* 8a70 */ 0x354d,0x4f43,0x333a,0x3e5c,0,0x7c27,0,0, 0,0x7c28,0,0,0x6b4b,0,0,0, /* 詰,話,該,詳,0,詵,0,0, 0,詹,0,0,詼,0,0,0, */
	/* 8a80 */ 0,0,0x6b50,0,0x6b51,0x6b4f,0,0x3858, 0,0x4d40,0,0,0x3b6f,0x4727,0,0, /* 0,0,誂,0,誄,誅,0,誇, 0,誉,0,0,誌,認,0,0, */
	/* 8a90 */ 0x785e,0x6b54,0,0x4040,0,0x4342,0,0, 0x4d36,0,0x6b57,0,0,0,0x386c,0, /* 誐,誑,0,誓,0,誕,0,0, 誘,0,誚,0,0,0,語,0, */
	/* 8aa0 */ 0x403f,0x6b53,0,0x6b58,0x386d,0x6b55,0x6b56,0x7c29, 0x6b52,0,0,0,0x4062,0x4649,0x785d,0, /* 誠,誡,0,誣,誤,誥,誦,誧, 誨,0,0,0,説,読,誮,0, */
	/* 8ab0 */ 0x432f,0,0x325d,0,0,0,0,0x785f, 0,0x4870,0,0,0x3543,0,0x7860,0x4434, /* 誰,0,課,0,0,0,0,誷, 0,誹,0,0,誼,0,誾,調, */
	/* 8ac0 */ 0,0,0x6b5b,0,0x6b59,0,0,0x434c, 0,0,0,0x4041,0x3452,0x6b5a,0,0x3f5b, /* 0,0,諂,0,諄,0,0,談, 0,0,0,請,諌,諍,0,諏, */
	/* 8ad0 */ 0x7c2a,0,0x4e4a,0,0,0,0x4f40,0x7861, 0,0,0x6b5c,0x6b67,0x4435,0,0x6b66,0x7c2b, /* 諐,0,諒,0,0,0,論,諗, 0,0,諚,諛,諜,0,諞,諟, */
	/* 8ae0 */ 0x6b63,0x6b6b,0x6b64,0,0x6b60,0,0x447c,0x6b5f, 0,0,0,0x6b5d,0,0x4d21,0x3b70,0, /* 諠,諡,諢,0,諤,0,諦,諧, 0,0,0,諫,0,諭,諮,0, */
	/* 8af0 */ 0,0x6b61,0,0x6b5e,0x7c2c,0,0x7c2d,0x6b65, 0x3d74,0,0x3841,0,0x7862,0,0x427a,0, /* 0,諱,0,諳,諴,0,諶,諷, 諸,0,諺,0,諼,0,諾,0, */
	/* 8b00 */ 0x4b45,0x315a,0x3062,0,0x4625,0x7865,0,0x6b69, 0,0,0x7864,0,0x6b68,0x7866,0x4666,0, /* 謀,謁,謂,0,謄,謅,0,謇, 0,0,謊,0,謌,謍,謎,0, */
	/* 8b10 */ 0x6b6d,0,0,0,0x6b62,0,0x6b6c,0x6b6e, 0,0x382c,0x6b6a,0x3956,0x7867,0x3c55,0,0x7868, /* 謐,0,0,0,謔,0,謖,謗, 0,謙,謚,講,謜,謝,0,謟, */
	/* 8b20 */ 0x6b6f,0x4d58,0,0,0,0,0x6b72,0, 0x6b75,0,0,0x6b73,0x4935,0x7869,0,0, /* 謠,謡,0,0,0,0,謦,0, 謨,0,0,謫,謬,謭,0,0, */
	/* 8b30 */ 0,0,0,0x6b70,0,0,0,0, 0,0x3660,0,0,0,0,0x6b74,0, /* 0,0,0,謳,0,0,0,0, 0,謹,0,0,0,0,謾,0, */
	/* 8b40 */ 0,0x6b76,0,0x786a,0,0,0x7c31,0, 0,0x6b7a,0,0,0x6b77,0,0x6b79,0x6b78, /* 0,譁,0,譃,0,0,譆,0, 0,證,0,0,譌,0,譎,譏, */
	/* 8b50 */ 0,0x786c,0,0,0x7c32,0,0x6b7b,0, 0x3c31,0x7c33,0x6b7d,0x6b7c,0x4968,0,0x786d,0x6c21, /* 0,譑,0,0,譔,0,譖,0, 識,譙,譚,譛,譜,0,譞,譟, */
	/* 8b60 */ 0,0,0,0,0,0,0x3759,0, 0,0x7c34,0,0x6b7e,0x6c22,0,0,0x6c23, /* 0,0,0,0,0,0,警,0, 0,譩,0,譫,譬,0,0,譯, */
	/* 8b70 */ 0x3544,0x6641,0x3e79,0,0x6c24,0,0x786e,0x386e, 0,0,0,0,0,0x6c25,0,0x786f, /* 議,譱,譲,0,譴,0,譶,護, 0,0,0,0,0,譽,0,譿, */
	/* 8b80 */ 0x6c26,0x7870,0,0x3b3e,0,0,0,0, 0,0,0x5a4e,0x7871,0x6c27,0,0x6c28,0, /* 讀,讁,0,讃,0,0,0,0, 0,0,變,讋,讌,0,讎,0, */
	/* 8b90 */ 0x3d32,0,0x6c29,0x6c2a,0x7872,0x7873,0x6c2b,0, 0,0x6c2c,0x6c2d,0,0x7874,0x7c35,0x7875,0, /* 讐,0,讒,讓,讔,讕,讖,0, 0,讙,讚,0,讜,讝,讞,0, */
	/* 8ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c30 */ 0,0,0,0,0,0,0,0x432b, 0,0x7876,0x6c2e,0,0,0x7878,0,0x6c30, /* 0,0,0,0,0,0,0,谷, 0,谹,谺,0,0,谽,0,谿, */
	/* 8c40 */ 0,0x6c2f,0,0,0,0x787b,0x4626,0x787c, 0x6c31,0x7c36,0x4b2d,0,0x6c32,0,0x6c33,0x787d, /* 0,豁,0,0,0,豅,豆,豇, 豈,豉,豊,0,豌,0,豎,豏, */
	/* 8c50 */ 0x6c34,0,0,0,0x787e,0x6c35,0,0x7921, 0,0,0x465a,0,0,0,0,0, /* 豐,0,0,0,豔,豕,0,豗, 0,0,豚,0,0,0,0,0, */
	/* 8c60 */ 0,0x3e5d,0x6c36,0,0,0,0,0, 0x7c37,0x7922,0x396b,0x502e,0x6c37,0x7923,0,0, /* 0,象,豢,0,0,0,0,0, 豨,豩,豪,豫,豬,豭,0,0, */
	/* 8c70 */ 0,0,0,0x7924,0,0,0,0, 0x6c38,0x493f,0x6c39,0,0x6c41,0,0,0, /* 0,0,0,豳,0,0,0,0, 豸,豹,豺,0,豼,0,0,0, */
	/* 8c80 */ 0,0,0x6c3a,0,0,0x6c3c,0,0, 0,0x6c3b,0x6c3d,0,0x4b46,0x6c3e,0x6c3f,0, /* 0,0,貂,0,0,貅,0,0, 0,貉,貊,0,貌,貍,貎,0, */
	/* 8c90 */ 0,0,0x7927,0x7926,0x6c40,0,0,0, 0x6c42,0x7928,0,0x792a,0,0x332d,0x4467,0, /* 0,0,貒,貓,貔,0,0,0, 貘,貙,0,貛,0,貝,貞,0, */
	/* 8ca0 */ 0x4969,0x3a62,0x3957,0,0x792b,0,0,0x494f, 0x325f,0x484e,0x6c45,0x3453,0x4055,0x6c44,0x6c49,0x4379, /* 負,財,貢,0,貤,0,0,貧, 貨,販,貪,貫,責,貭,貮,貯, */
	/* 8cb0 */ 0x4c63,0,0x6c47,0x6c48,0x352e,0,0x6c4a,0x4763, 0x425f,0,0,0x4871,0x453d,0x6c46,0,0x4b47, /* 貰,0,貲,貳,貴,0,貶,買, 貸,0,0,費,貼,貽,0,貿, */
	/* 8cc0 */ 0x326c,0x6c4c,0x4f28,0x4442,0x4f45,0,0,0x3b71, 0x6c4b,0,0x4231,0,0,0x6c5c,0x4128,0, /* 賀,賁,賂,賃,賄,0,0,資, 賈,0,賊,0,0,賍,賎,0, */
	/* 8cd0 */ 0,0x4678,0,0x4950,0,0x792d,0x792c,0, 0,0x792e,0x6c4f,0x3b3f,0x3b72,0,0x3e5e,0, /* 0,賑,0,賓,0,賕,賖,0, 0,賙,賚,賛,賜,0,賞,0, */
	/* 8ce0 */ 0x4765,0x7c39,0x382d,0x6c4e,0x6c4d,0,0x496a,0, 0,0,0x3c41,0,0,0x4552,0,0, /* 賠,賡,賢,賣,賤,0,賦,0, 0,0,質,0,0,賭,0,0, */
	/* 8cf0 */ 0x7930,0x7931,0,0,0x7c3a,0,0,0, 0x7c3b,0,0x6c51,0x6c52,0x3958,0x6c50,0x7c3c,0, /* 賰,賱,0,0,賴,0,0,0, 賸,0,賺,賻,購,賽,賾,0, */
	/* 8d00 */ 0,0,0,0,0x6c53,0x6c54,0,0x6c56, 0x4223,0x7933,0x6c55,0x3466,0,0x6c58,0x7934,0x6c57, /* 0,0,0,0,贄,贅,0,贇, 贈,贉,贊,贋,0,贍,贎,贏, */
	/* 8d10 */ 0x6c59,0,0x7c3e,0x6c5b,0x6c5d,0,0x6c5e,0, 0,0,0,0x7c3f,0,0,0,0, /* 贐,0,贒,贓,贔,0,贖,0, 0,0,0,贛,0,0,0,0, */
	/* 8d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d60 */ 0,0,0,0,0x4056,0,0x3c4f,0x6c5f, 0,0,0,0x3352,0x7935,0x6c60,0,0, /* 0,0,0,0,赤,0,赦,赧, 0,0,0,赫,赬,赭,0,0, */
	/* 8d70 */ 0x4176,0x6c61,0,0x6c62,0x496b,0,0,0x352f, 0,0,0,0,0,0,0,0, /* 走,赱,0,赳,赴,0,0,起, 0,0,0,0,0,0,0,0, */
	/* 8d80 */ 0,0x6c63,0,0,0x7936,0x4436,0,0, 0,0,0x315b,0,0,0,0,0, /* 0,趁,0,0,趄,超,0,0, 0,0,越,0,0,0,0,0, */
	/* 8d90 */ 0,0,0,0,0,0x7937,0,0, 0,0x6c64,0,0,0,0,0,0, /* 0,0,0,0,0,趕,0,0, 0,趙,0,0,0,0,0,0, */
	/* 8da0 */ 0,0,0,0x3c71,0,0,0x7938,0, 0x3f76,0,0,0,0,0,0,0x7c40, /* 0,0,0,趣,0,0,趦,0, 趨,0,0,0,0,0,0,趯, */
	/* 8db0 */ 0,0,0,0x422d,0,0,0,0, 0,0,0x6c67,0,0,0,0x6c66,0, /* 0,0,0,足,0,0,0,0, 0,0,趺,0,0,0,趾,0, */
	/* 8dc0 */ 0,0,0x6c65,0,0,0,0x793a,0, 0x793b,0,0,0x6c6d,0x6c6b,0,0x7c41,0x6c68, /* 0,0,跂,0,0,0,跆,0, 跈,0,0,跋,跌,0,跎,跏, */
	/* 8dd0 */ 0,0x7c42,0,0,0,0,0x6c6a,0x7c43, 0,0x793c,0x6c69,0x6c6c,0,0x3577,0,0x6c70, /* 0,跑,0,0,0,0,跖,跗, 0,跙,跚,跛,0,距,0,跟, */
	/* 8de0 */ 0,0x4057,0,0x6c71,0,0,0,0, 0x3859,0,0x6c6e,0x6c6f,0x793d,0,0,0x4f29, /* 0,跡,0,跣,0,0,0,0, 跨,0,跪,跫,跬,0,0,路, */
	/* 8df0 */ 0,0,0,0x4437,0,0x4129,0,0, 0,0,0,0,0x6c72,0x7940,0,0x6c75, /* 0,0,0,跳,0,践,0,0, 0,0,0,0,跼,跽,0,跿, */
	/* 8e00 */ 0,0,0,0,0,0,0x7941,0, 0x6c73,0x6c74,0x4d59,0,0x793e,0,0,0x4627, /* 0,0,0,0,0,0,踆,0, 踈,踉,踊,0,踌,0,0,踏, */
	/* 8e10 */ 0x6c78,0,0,0,0x7943,0,0x7944,0, 0,0,0,0,0,0x6c76,0x6c77,0x6c79, /* 踐,0,0,0,踔,0,踖,0, 0,0,0,0,0,踝,踞,踟, */
	/* 8e20 */ 0x7c44,0x7945,0x7946,0x7c45,0,0,0,0x7947, 0,0,0x6d29,0,0,0,0,0, /* 踠,踡,踢,踣,0,0,0,踧, 0,0,踪,0,0,0,0,0, */
	/* 8e30 */ 0x6c7c,0,0,0,0x6c7d,0x6c7b,0x794a,0, 0,0x794b,0,0,0,0x7c46,0,0, /* 踰,0,0,0,踴,踵,踶,0, 0,踹,0,0,0,踽,0,0, */
	/* 8e40 */ 0,0,0x6c7a,0,0x447d,0,0,0x6d21, 0x6d25,0x6d22,0x6c7e,0x794c,0x6d23,0,0,0, /* 0,0,蹂,0,蹄,0,0,蹇, 蹈,蹉,蹊,蹋,蹌,0,0,0, */
	/* 8e50 */ 0x6d24,0,0,0,0x794d,0x6d2b,0,0, 0,0x6d26,0,0,0,0,0,0x4058, /* 蹐,0,0,0,蹔,蹕,0,0, 0,蹙,0,0,0,0,0,蹟, */
	/* 8e60 */ 0x6d28,0,0x794e,0x6d2a,0x6d27,0,0,0, 0,0,0,0,0x794f,0x7950,0,0x7951, /* 蹠,0,蹢,蹣,蹤,0,0,0, 0,0,0,0,蹬,蹭,0,蹯, */
	/* 8e70 */ 0x7c47,0,0x6d2d,0,0x3d33,0,0x6d2c,0, 0,0,0,0x7c48,0x6d2e,0,0,0, /* 蹰,0,蹲,0,蹴,0,蹶,0, 0,0,0,蹻,蹼,0,0,0, */
	/* 8e80 */ 0,0x6d2f,0,0,0x6d32,0x6d31,0,0x6d30, 0,0,0x6d34,0x6d33,0,0x4c76,0,0, /* 0,躁,0,0,躄,躅,0,躇, 0,0,躊,躋,0,躍,0,0, */
	/* 8e90 */ 0,0x6d36,0,0x6d35,0x6d37,0,0,0, 0x7952,0x6d38,0,0,0,0,0x7953,0, /* 0,躑,0,躓,躔,0,0,0, 躘,躙,0,0,0,0,躞,0, */
	/* 8ea0 */ 0,0x6d3a,0,0,0,0,0,0, 0,0,0x6d39,0x3f48,0x6d3b,0,0x7954,0x366d, /* 0,躡,0,0,0,0,0,0, 0,0,躪,身,躬,0,躮,躯, */
	/* 8eb0 */ 0x6d3c,0x6d3e,0,0x7955,0,0x7956,0x7957,0, 0,0,0,0x7958,0,0,0x6d3f,0, /* 躰,躱,0,躳,0,躵,躶,0, 0,0,0,躻,0,0,躾,0, */
	/* 8ec0 */ 0x7c4a,0,0,0,0,0x6d40,0x6d3d,0, 0x6d41,0,0x3c56,0x6d42,0x3530,0x3733,0,0, /* 軀,0,0,0,0,軅,軆,0, 軈,0,車,軋,軌,軍,0,0, */
	/* 8ed0 */ 0,0x795a,0x382e,0,0x795b,0,0,0, 0,0,0,0x6d43,0,0,0,0x4670, /* 0,軑,軒,0,軔,0,0,0, 0,0,0,軛,0,0,0,軟, */
	/* 8ee0 */ 0,0,0x453e,0x6d44,0,0,0,0, 0,0,0,0x6d47,0,0,0,0, /* 0,0,転,軣,0,0,0,0, 0,0,0,軫,0,0,0,0, */
	/* 8ef0 */ 0,0,0,0,0,0,0,0, 0x3c34,0x795d,0x7c4c,0x6d46,0x6d45,0x375a,0x6d48,0, /* 0,0,0,0,0,0,0,0, 軸,軹,軺,軻,軼,軽,軾,0, */
	/* 8f00 */ 0x795f,0,0,0x3353,0,0x6d4a,0,0, 0x7960,0x3a5c,0x6d49,0,0x6d52,0,0,0, /* 輀,0,0,較,0,輅,0,0, 輈,載,輊,0,輌,0,0,0, */
	/* 8f10 */ 0,0,0x6d4c,0x6d4e,0x4a65,0x6d4b,0,0x7961, 0,0x6d4d,0,0x6d51,0x6d4f,0x3531,0x7c4d,0x6d50, /* 0,0,輒,輓,輔,輕,0,輗, 0,輙,0,輛,輜,輝,輞,輟, */
	/* 8f20 */ 0,0,0,0,0,0,0x6d53,0, 0,0x475a,0x4e58,0x7962,0,0x7c4e,0,0x3d34, /* 0,0,0,0,0,0,輦,0, 0,輩,輪,輫,0,輭,0,輯, */
	/* 8f30 */ 0,0,0,0x6d54,0,0,0x7c4f,0, 0x4d22,0x6d56,0,0x6d55,0,0,0x6d59,0x4d41, /* 0,0,0,輳,0,0,輶,0, 輸,輹,0,輻,0,0,輾,輿, */
	/* 8f40 */ 0x7963,0,0x6d58,0,0x336d,0x6d57,0x6d5c,0, 0,0x6d5b,0x7964,0,0x6d5a,0x4532,0x6d5d,0, /* 轀,0,轂,0,轄,轅,轆,0, 0,轉,轊,0,轌,轍,轎,0, */
	/* 8f50 */ 0,0,0,0,0x7c50,0,0,0x6d5e, 0x7965,0,0,0,0x6d5f,0,0,0x396c, /* 0,0,0,0,轔,0,0,轗, 轘,0,0,0,轜,0,0,轟, */
	/* 8f60 */ 0,0x3725,0x6d60,0x6d61,0x6d62,0,0,0, 0,0,0,0,0,0,0,0, /* 0,轡,轢,轣,轤,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0x3f49,0x6d63,0,0x3c2d,0x6d64, /* 0,0,0,0,0,0,0,0, 0,0,0,辛,辜,0,辞,辟, */
	/* 8fa0 */ 0,0,0,0x6d65,0x7967,0,0x7c52,0x5221, 0x517e,0,0,0,0,0x6d66,0x6570,0x6d67, /* 0,0,0,辣,辤,0,辦,辧, 辨,0,0,0,0,辭,辮,辯, */
	/* 8fb0 */ 0x4324,0x3f2b,0x4740,0,0x7968,0x7c53,0x796a,0x6d68, 0,0,0x4a55,0x4454,0x397e,0,0,0x4329, /* 辰,辱,農,0,辴,辵,辶,辷, 0,0,辺,辻,込,0,0,辿, */
	/* 8fc0 */ 0,0x796c,0x312a,0,0x4b78,0x3f57,0x796d,0, 0,0,0x796f,0,0,0x7970,0x375e,0, /* 0,迁,迂,0,迄,迅,迆,0, 0,0,迊,0,0,迍,迎,0, */
	/* 8fd0 */ 0,0x3661,0,0x7971,0x4a56,0x7972,0,0, 0,0,0x6d69,0,0,0,0,0, /* 0,近,0,迓,返,迕,0,0, 0,0,迚,0,0,0,0,0, */
	/* 8fe0 */ 0x7973,0,0x6d6b,0,0x7c54,0x6d6a,0x3260,0, 0x7c55,0x4676,0x6d6c,0x4777,0,0x4533,0x7c56,0x6d6d, /* 迠,0,迢,0,迤,迥,迦,0, 迨,迩,迪,迫,0,迭,迮,迯, */
	/* 8ff0 */ 0x3d52,0x7974,0,0,0x6d6f,0x7975,0,0x4c42, 0x6d7e,0x6d71,0x6d72,0x7976,0,0x4449,0,0, /* 述,迱,0,0,迴,迵,0,迷, 迸,迹,迺,迻,0,追,0,0, */
	/* 9000 */ 0x4260,0x4177,0x7977,0x4628,0,0x6d70,0x3555,0, 0x7c57,0,0,0x6d79,0x7978,0x6d76,0x6e25,0x4629, /* 退,送,适,逃,0,逅,逆,0, 逈,0,0,逋,逌,逍,逎,透, */
	/* 9010 */ 0x4360,0x6d73,0,0x447e,0x4553,0x6d74,0x6d78,0x3f60, 0,0x4767,0x444c,0,0,0x4042,0x6d77,0x422e, /* 逐,逑,0,逓,途,逕,逖,逗, 0,這,通,0,0,逝,逞,速, */
	/* 9020 */ 0x4224,0x6d75,0x3029,0x4f22,0,0,0,0x6d7a, 0,0,0,0,0,0x7c58,0x4261,0, /* 造,逡,逢,連,0,0,0,逧, 0,0,0,0,0,逭,逮,0, */
	/* 9030 */ 0,0x3d35,0x3f4a,0,0,0x6d7c,0x6d7b,0x7979, 0x306f,0x6d7d,0,0,0x492f,0,0x6e27,0, /* 0,週,進,0,0,逵,逶,逷, 逸,逹,0,0,逼,0,逾,0, */
	/* 9040 */ 0,0x465b,0x3f6b,0x797b,0x797c,0x4359,0,0x3678, 0,0x6e26,0x4d37,0x313f,0,0x4a57,0x3261,0x6e21, /* 0,遁,遂,遃,遄,遅,0,遇, 0,遉,遊,運,0,遍,過,遏, */
	/* 9050 */ 0x6e22,0x6e23,0x6e24,0x463b,0x4323,0x3063,0x6e28,0, 0x6e29,0x7423,0,0,0x423d,0x797d,0x6e2a,0, /* 遐,遑,遒,道,達,違,遖,0, 遘,遙,0,0,遜,遝,遞,0, */
	/* 9060 */ 0x3173,0x414c,0,0x382f,0,0x4d5a,0,0, 0x6e2b,0x452c,0,0,0,0x4178,0x3c57,0x6e2c, /* 遠,遡,0,遣,0,遥,0,0, 遨,適,0,0,0,遭,遮,遯, */
	/* 9070 */ 0,0,0x6e2f,0,0,0x3d65,0x6e2d,0x412b, 0x412a,0,0x3064,0,0x4e4b,0x6e31,0,0x4872, /* 0,0,遲,0,0,遵,遶,遷, 選,0,遺,0,遼,遽,0,避, */
	/* 9080 */ 0x6e33,0x6e32,0x6e30,0x6364,0x3454,0x7a22,0,0x6d6e, 0x7c5a,0x6e35,0x6e34,0,0x7a23,0,0,0x6e36, /* 邀,邁,邂,邃,還,邅,0,邇, 邈,邉,邊,0,邌,0,0,邏, */
	/* 9090 */ 0x7a24,0x4d38,0,0,0,0x7c5b,0,0x7c5c, 0,0x7c5d,0,0x7c5e,0,0,0,0, /* 邐,邑,0,0,0,邕,0,邗, 0,邙,0,邛,0,0,0,0, */
	/* 90a0 */ 0,0x7a26,0x7c5f,0x4661,0,0,0x4b2e,0, 0x6e37,0,0x3c59,0,0,0,0,0x6e38, /* 0,邡,邢,那,0,0,邦,0, 邨,0,邪,0,0,0,0,邯, */
	/* 90b0 */ 0x7a28,0x6e39,0,0x7c60,0,0x6e3a,0x7a29,0, 0x4521,0,0,0,0,0,0x7c61,0, /* 邰,邱,0,邳,0,邵,邶,0, 邸,0,0,0,0,0,邾,0, */
	/* 90c0 */ 0,0x306a,0,0x7a2a,0x7c62,0x7c63,0,0x7c64, 0x7a2b,0,0x3959,0,0,0,0x4f3a,0, /* 0,郁,0,郃,郄,郅,0,郇, 郈,0,郊,0,0,0,郎,0, */
	/* 90d0 */ 0,0,0,0,0,0,0,0x7c65, 0,0,0,0x6e3e,0x7a2d,0x7c66,0x7c67,0x7a2e, /* 0,0,0,0,0,0,0,郗, 0,0,0,郛,郜,郝,郞,郟, */
	/* 90e0 */ 0,0x3734,0x6e3b,0,0x6e3c,0,0,0, 0x4974,0,0,0x7a33,0,0x3354,0,0x7c68, /* 0,郡,郢,0,郤,0,0,0, 部,0,0,郫,0,郭,0,郯, */
	/* 90f0 */ 0,0,0x7a31,0,0x7c69,0x4d39,0x7a30,0x363f, 0,0,0,0,0,0x4554,0x7a34,0x7a35, /* 0,0,郲,0,郴,郵,郶,郷, 0,0,0,0,0,都,郾,郿, */
	/* 9100 */ 0x7a32,0,0x6e3f,0,0x7a36,0,0x7a37,0, 0,0,0,0,0,0,0,0, /* 鄀,0,鄂,0,鄄,0,鄆,0, 0,0,0,0,0,0,0,0, */
	/* 9110 */ 0,0,0x6e40,0,0x7c6b,0x7c6c,0x7c6d,0, 0x7a38,0x6e41,0,0,0x7a39,0,0x7a3a,0, /* 0,0,鄒,0,鄔,鄕,鄖,0, 鄘,鄙,0,0,鄜,0,鄞,0, */
	/* 9120 */ 0,0,0x7c6e,0x7c6f,0,0,0,0x7c70, 0,0,0,0,0,0x4522,0,0x7c71, /* 0,0,鄢,鄣,0,0,0,鄧, 0,0,0,0,0,鄭,0,鄯, */
	/* 9130 */ 0x6e43,0x7c72,0x6e42,0,0x7c73,0,0,0x7a3b, 0,0x7a3c,0x7a3d,0,0,0x7c74,0,0, /* 鄰,鄱,鄲,0,鄴,0,0,鄷, 0,鄹,鄺,0,0,鄽,0,0, */
	/* 9140 */ 0,0,0,0,0,0,0x7a3e,0x7a3f, 0x7c75,0x4653,0x6e44,0x3d36,0x3c60,0x475b,0x4371,0, /* 0,0,0,0,0,0,酆,酇, 酈,酉,酊,酋,酌,配,酎,0, */
	/* 9150 */ 0,0,0x3c72,0,0x3f6c,0,0x6e45,0x7a40, 0x6e46,0x7a41,0,0x7c76,0,0,0,0, /* 0,0,酒,0,酔,0,酖,酗, 酘,酙,0,酛,0,0,0,0, */
	/* 9160 */ 0,0x7a42,0x3f5d,0x6e47,0x7a43,0x6e48,0,0, 0,0x6e49,0x4d6f,0,0x3d37,0,0,0, /* 0,酡,酢,酣,酤,酥,0,0, 0,酩,酪,0,酬,0,0,0, */
	/* 9170 */ 0,0,0x6e4b,0x6e4a,0x7a44,0x395a,0,0x3973, 0x3b40,0x7a45,0,0,0,0,0,0, /* 0,0,酲,酳,酴,酵,0,酷, 酸,酹,0,0,0,0,0,0, */
	/* 9180 */ 0,0,0x6e4e,0x7c77,0,0x7a46,0,0x3d66, 0,0x6e4d,0,0x6e4c,0,0x4269,0x7a47,0, /* 0,0,醂,醃,0,醅,0,醇, 0,醉,0,醋,0,醍,醎,0, */
	/* 9190 */ 0x386f,0,0x4043,0,0,0,0,0x4830, 0,0,0,0,0x3d39,0,0x7c78,0, /* 醐,0,醒,0,0,0,0,醗, 0,0,0,0,醜,0,醞,0, */
	/* 91a0 */ 0,0,0x6e4f,0,0x3e5f,0,0,0, 0x7a48,0,0x6e52,0x6e50,0x7c79,0,0x7a49,0x6e51, /* 0,0,醢,0,醤,0,0,0, 醨,0,醪,醫,醬,0,醮,醯, */
	/* 91b0 */ 0,0x7c7a,0,0x7a4a,0x6e54,0x6e53,0x7a4b,0, 0x3e7a,0,0x6e55,0,0x7c7b,0,0,0, /* 0,醱,0,醳,醴,醵,醶,0, 醸,0,醺,0,醼,0,0,0, */
	/* 91c0 */ 0x6e56,0x6e57,0,0x7a4c,0x7a4d,0,0x4850,0x3a53, 0x3c61,0x6e58,0,0x6e59,0x4e24,0x3d45,0x4c6e,0x4e4c, /* 釀,釁,0,釃,釄,0,釆,采, 釈,釉,0,釋,里,重,野,量, */
	/* 91d0 */ 0x6e5a,0x3662,0,0,0,0,0x6e5b,0x7c7c, 0x4523,0,0x7a4e,0x6e5e,0x3378,0x3f4b,0,0x6e5c, /* 釐,金,0,0,0,0,釖,釗, 釘,0,釚,釛,釜,針,0,釟, */
	/* 91e0 */ 0,0x6e5d,0,0x4460,0x7c7e,0x7d21,0x4b55,0x367c, 0,0,0,0,0x7a51,0x7d22,0x7a52,0, /* 0,釡,0,釣,釤,釥,釦,釧, 0,0,0,0,釬,釭,釮,0, */
	/* 91f0 */ 0,0x7d23,0,0,0,0x6e60,0x6e61,0, 0,0,0,0x7c7d,0x6e5f,0,0,0x6e63, /* 0,釱,0,0,0,釵,釶,0, 0,0,0,釻,釼,0,0,釿, */
	/* 9200 */ 0,0x7a53,0,0,0,0,0,0x7d24, 0,0,0x7a54,0,0,0x465f,0x3343,0, /* 0,鈁,0,0,0,0,0,鈇, 0,0,鈊,0,0,鈍,鈎,0, */
	/* 9210 */ 0x7d25,0x6e67,0,0,0x6e64,0x6e66,0x7a55,0x7a56, 0,0,0,0,0,0,0x6e62,0, /* 鈐,鈑,0,0,鈔,鈕,鈖,鈗, 0,0,0,0,0,0,鈞,0, */
	/* 9220 */ 0,0,0,0,0,0,0,0, 0,0x6f4f,0,0,0x6e65,0,0,0, /* 0,0,0,0,0,0,0,0, 0,鈩,0,0,鈬,0,0,0, */
	/* 9230 */ 0,0,0,0x7a58,0x4e6b,0,0,0x385a, 0x7d26,0x7d27,0x7d28,0,0x7d29,0,0,0x6e6f, /* 0,0,0,鈳,鈴,0,0,鈷, 鈸,鈹,鈺,0,鈼,0,0,鈿, */
	/* 9240 */ 0x7d2a,0,0x7a59,0x7d2b,0x4534,0x6e6a,0,0x7a5a, 0x6e6d,0x6e6b,0x7a5b,0x6e70,0,0,0x7a5c,0x7d2c, /* 鉀,0,鉂,鉃,鉄,鉅,0,鉇, 鉈,鉉,鉊,鉋,0,0,鉎,鉏, */
	/* 9250 */ 0x6e71,0x7a5d,0,0,0,0,0x7a5e,0x6e69, 0,0x7a5f,0x6e76,0x3174,0,0,0x6e68,0, /* 鉐,鉑,0,0,0,0,鉖,鉗, 0,鉙,鉚,鉛,0,0,鉞,0, */
	/* 9260 */ 0x7a60,0x7a61,0x482d,0,0x6e6c,0x7a62,0x3e60,0x7a63, 0x7a64,0,0,0,0,0,0,0, /* 鉠,鉡,鉢,0,鉤,鉥,鉦,鉧, 鉨,0,0,0,0,0,0,0, */
	/* 9270 */ 0,0x395b,0,0,0,0,0,0, 0x7d2d,0,0,0,0x7a67,0x7a68,0x4b48,0x7a69, /* 0,鉱,0,0,0,0,0,0, 鉸,0,0,0,鉼,鉽,鉾,鉿, */
	/* 9280 */ 0x3664,0,0,0x3d46,0,0x463c,0,0, 0x7d2e,0x7a6a,0,0,0,0x7a6b,0,0, /* 銀,0,0,銃,0,銅,0,0, 銈,銉,0,0,0,銍,0,0, */
	/* 9290 */ 0,0x412d,0,0x6e74,0,0x6e6e,0x6e73,0x7a6c, 0x4c43,0x7a6d,0x4438,0x6e75,0x6e72,0,0,0x7a6e, /* 0,銑,0,銓,0,銕,銖,銗, 銘,銙,銚,銛,銜,0,0,銟, */
	/* 92a0 */ 0,0,0,0,0,0,0,0x7a6f, 0,0,0,0x7a70,0,0x412c,0,0, /* 0,0,0,0,0,0,0,銧, 0,0,0,銫,0,銭,0,0, */
	/* 92b0 */ 0,0,0x7a73,0,0,0,0,0x6e79, 0,0x6e78,0,0,0,0,0,0x7a74, /* 0,0,銲,0,0,0,0,銷, 0,銹,0,0,0,0,0,銿, */
	/* 92c0 */ 0x7a75,0,0x7d2f,0,0,0,0x7a76,0, 0,0,0,0x7d30,0x7d31,0,0x7a77,0x6e77, /* 鋀,0,鋂,0,0,0,鋆,0, 0,0,0,鋋,鋌,0,鋎,鋏, */
	/* 92d0 */ 0x7a78,0,0x4b2f,0x7d32,0,0,0,0x7a79, 0,0x7a7a,0,0,0,0,0,0, /* 鋐,0,鋒,鋓,0,0,0,鋗, 0,鋙,0,0,0,0,0,0, */
	/* 92e0 */ 0x7d33,0,0,0,0x3d7b,0x7a7b,0,0x7a7c, 0,0x6e7a,0x4a5f,0,0,0x3154,0,0, /* 鋠,0,0,0,鋤,鋥,0,鋧, 0,鋩,鋪,0,0,鋭,0,0, */
	/* 92f0 */ 0,0,0x4946,0x4372,0,0,0,0x7b22, 0x3578,0x7b23,0x6e7c,0x7b24,0x395d,0,0,0x7d34, /* 0,0,鋲,鋳,0,0,0,鋷, 鋸,鋹,鋺,鋻,鋼,0,0,鋿, */
	/* 9300 */ 0,0,0x7b25,0,0x7d35,0,0x3b2c,0, 0,0,0,0,0,0x7b26,0,0x6e7b, /* 0,0,錂,0,錄,0,錆,0, 0,0,0,0,0,錍,0,錏, */
	/* 9310 */ 0x3f6d,0x7a7d,0,0,0,0x7b27,0,0, 0x3f6e,0x6f21,0x6f23,0,0,0x7b28,0x7b29,0x7d36, /* 錐,錑,0,0,0,錕,0,0, 錘,錙,錚,0,0,錝,錞,錟, */
	/* 9320 */ 0x3e7b,0x7d37,0x6f22,0x6f24,0,0x7d38,0x3653,0x7b2a, 0x4945,0x7b2b,0,0x3c62,0x4f23,0,0x6e7e,0x3a78, /* 錠,錡,錢,錣,0,錥,錦,錧, 錨,錩,0,錫,錬,0,錮,錯, */
	/* 9330 */ 0,0,0x4f3f,0,0,0x6f26,0,0, 0,0,0x6f25,0x6f27,0,0,0,0, /* 0,0,録,0,0,錵,0,0, 0,0,錺,錻,0,0,0,0, */
	/* 9340 */ 0,0,0,0,0x6e7d,0,0,0x7b2e, 0x7d39,0x7d3a,0x7d3b,0x4669,0,0x4555,0,0, /* 0,0,0,0,鍄,0,0,鍇, 鍈,鍉,鍊,鍋,0,鍍,0,0, */
	/* 9350 */ 0,0x7b2f,0,0,0x4457,0,0x6f2c,0x7b30, 0,0,0x7b31,0x4343,0x6f28,0,0,0, /* 0,鍑,0,0,鍔,0,鍖,鍗, 0,0,鍚,鍛,鍜,0,0,0, */
	/* 9360 */ 0x6f29,0,0,0,0x7d3c,0x7d3d,0,0, 0,0,0x7d3e,0x7b32,0x372d,0,0x6f2b,0, /* 鍠,0,0,0,鍤,鍥,0,0, 0,0,鍪,鍫,鍬,0,鍮,0, */
	/* 9370 */ 0x7d3f,0x7b33,0,0x7b34,0,0x3830,0,0, 0,0,0,0,0x6f2a,0,0x3e61,0, /* 鍰,鍱,0,鍳,0,鍵,0,0, 0,0,0,0,鍼,0,鍾,0, */
	/* 9380 */ 0,0,0,0,0,0,0,0, 0x7b38,0,0,0x7b39,0x3379,0,0,0x7b3a, /* 0,0,0,0,0,0,0,0, 鎈,0,0,鎋,鎌,0,0,鎏, */
	/* 9390 */ 0,0,0,0,0x6f30,0,0x3a3f,0x4179, 0,0,0x444a,0x7d40,0,0,0x7b3b,0, /* 0,0,0,0,鎔,0,鎖,鎗, 0,0,鎚,鎛,0,0,鎞,0, */
	/* 93a0 */ 0,0x7b35,0,0x7d41,0,0,0,0x333b, 0,0,0,0,0x6f2e,0x6f2f,0x4443,0, /* 0,鎡,0,鎣,0,0,0,鎧, 0,0,0,0,鎬,鎭,鎮,0, */
	/* 93b0 */ 0x6f2d,0,0,0,0,0,0,0, 0,0x6f31,0x7d42,0,0,0,0,0, /* 鎰,0,0,0,0,0,0,0, 0,鎹,鎺,0,0,0,0,0, */
	/* 93c0 */ 0,0x7b40,0,0x6f37,0,0,0x7d43,0x7b41, 0x6f3a,0,0,0,0,0,0,0, /* 0,鏁,0,鏃,0,0,鏆,鏇, 鏈,0,0,0,0,0,0,0, */
	/* 93d0 */ 0x6f39,0x452d,0,0,0,0,0x6f32,0x6f33, 0x6f36,0,0,0,0x7b42,0x6f38,0x7d44,0x7d45, /* 鏐,鏑,0,0,0,0,鏖,鏗, 鏘,0,0,0,鏜,鏝,鏞,鏟, */
	/* 93e0 */ 0,0x3640,0x7b43,0,0x6f3b,0x6f35,0,0x7b44, 0x6f34,0,0,0,0,0,0,0, /* 0,鏡,鏢,0,鏤,鏥,0,鏧, 鏨,0,0,0,0,0,0,0, */
	/* 93f0 */ 0,0x7b3f,0,0,0,0x7b3c,0,0, 0,0,0,0x7b49,0,0x7d47,0,0, /* 0,鏱,0,0,0,鏵,0,0, 0,0,0,鏻,0,鏽,0,0, */
	/* 9400 */ 0,0,0,0x6f3f,0x7d46,0,0,0x6f40, 0,0x7b45,0,0,0,0,0,0x7b46, /* 0,0,0,鐃,鐄,0,0,鐇, 0,鐉,0,0,0,0,0,鐏, */
	/* 9410 */ 0x6f41,0,0,0x6f3e,0x6f3d,0,0x7b47,0x7b48, 0x3e62,0x462a,0x6f3c,0,0,0,0,0, /* 鐐,0,0,鐓,鐔,0,鐖,鐗, 鐘,鐙,鐚,0,0,0,0,0, */
	/* 9420 */ 0,0x6f45,0,0,0,0,0,0, 0,0,0,0x6f43,0,0,0,0, /* 0,鐡,0,0,0,0,0,0, 0,0,0,鐫,0,0,0,0, */
	/* 9430 */ 0,0,0x7b4a,0x7d48,0x7b4b,0x6f44,0x6f42,0, 0x4278,0,0x6f46,0x7b4c,0,0,0,0, /* 0,0,鐲,鐳,鐴,鐵,鐶,0, 鐸,0,鐺,鐻,0,0,0,0, */
	/* 9440 */ 0,0x6f47,0,0,0x6f49,0x7b4d,0,0, 0,0,0x7d49,0,0,0,0,0, /* 0,鑁,0,0,鑄,鑅,0,0, 0,0,鑊,0,0,0,0,0, */
	/* 9450 */ 0,0x3455,0x6f48,0x4c7a,0,0,0,0, 0,0,0x6f54,0x6f4a,0,0,0x6f4d,0, /* 0,鑑,鑒,鑓,0,0,0,0, 0,0,鑚,鑛,0,0,鑞,0, */
	/* 9460 */ 0x6f4b,0,0x6f4c,0x7d4a,0,0,0,0, 0,0,0x6f4e,0x7d4b,0,0x7b50,0,0x7b51, /* 鑠,0,鑢,鑣,0,0,0,0, 0,0,鑪,鑫,0,鑭,0,鑯, */
	/* 9470 */ 0x6f50,0x7d4c,0x7d4d,0,0,0x6f51,0,0x6f52, 0,0,0,0,0x6f55,0x6f53,0x6f56,0x6f58, /* 鑰,鑱,鑲,0,0,鑵,0,鑷, 0,0,0,0,鑼,鑽,鑾,鑿, */
	/* 9480 */ 0,0x6f57,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,钁,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9570 */ 0,0,0,0,0,0,0,0x4439, 0x7b52,0x7b53,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,長, 镸,镹,0,0,0,0,0,0, */
	/* 9580 */ 0x4c67,0,0x6f59,0x412e,0,0,0x7b54,0x6f5a, 0,0x4a44,0x6f5b,0x332b,0x7b55,0x7b56,0x7d4e,0x313c, /* 門,0,閂,閃,0,0,閆,閇, 0,閉,閊,開,閌,閍,閎,閏, */
	/* 9590 */ 0,0x3457,0,0x3456,0x6f5c,0,0x6f5d,0, 0x6f5e,0x6f5f,0,0,0,0,0,0x7d4f, /* 0,閑,0,間,閔,0,閖,0, 閘,閙,0,0,0,0,0,閟, */
	/* 95a0 */ 0x6f60,0,0x3458,0x3355,0x395e,0x4836,0x7d50,0x6f62, 0x6f61,0x7d51,0,0x7b58,0x7d52,0x6f63,0,0, /* 閠,0,関,閣,閤,閥,閦,閧, 閨,閩,0,閫,閬,閭,0,0, */
	/* 95b0 */ 0,0,0x315c,0,0x7b59,0,0x7d53,0, 0,0x6f66,0,0x6f65,0x6f64,0x7d54,0x6f67,0, /* 0,0,閲,0,閴,0,閶,0, 0,閹,0,閻,閼,閽,閾,0, */
	/* 95c0 */ 0,0,0,0x6f6a,0,0,0,0x3047, 0x7b5b,0,0x6f68,0x7d55,0x6f6c,0x6f6b,0,0, /* 0,0,0,闃,0,0,0,闇, 闈,0,闊,闋,闌,闍,0,0, */
	/* 95d0 */ 0x7d56,0,0,0x7d57,0x6f6e,0x6f6d,0x6f6f,0, 0x462e,0,0x7d59,0,0x6f70,0,0x7d5a,0, /* 闐,0,0,闓,闔,闕,闖,0, 闘,0,闚,0,關,0,闞,0, */
	/* 95e0 */ 0,0x6f71,0x6f73,0,0,0x6f72,0,0, 0,0,0,0,0,0,0,0, /* 0,闡,闢,0,0,闥,0,0, 0,0,0,0,0,0,0,0, */
	/* 95f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x496c,0x7a25,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,阜,阝,0,0, */
	/* 9620 */ 0,0x6f74,0,0,0,0,0,0, 0x6f75,0,0x3a65,0,0x7b5e,0,0x6f76,0x6f77, /* 0,阡,0,0,0,0,0,0, 阨,0,阪,0,阬,0,阮,阯, */
	/* 9630 */ 0,0,0x4b49,0x7b5f,0x7b60,0,0,0, 0,0,0,0x414b,0x7b62,0,0,0x3024, /* 0,0,防,阳,阴,0,0,0, 0,0,0,阻,阼,0,0,阿, */
	/* 9640 */ 0x424b,0x7b63,0x6f78,0,0x496d,0,0,0, 0,0,0,0x6f7b,0x6f79,0x395f,0,0x6f7a, /* 陀,陁,陂,0,附,0,0,0, 0,0,0,陋,陌,降,0,陏, */
	/* 9650 */ 0x3842,0,0,0,0,0,0,0, 0x7d5b,0,0,0x4a45,0x6f7d,0x7021,0x6f7e,0x7022, /* 限,0,0,0,0,0,0,0, 陘,0,0,陛,陜,陝,陞,陟, */
	/* 9660 */ 0,0x7b64,0x3121,0x3f58,0x3d7c,0x3459,0x7023,0, 0,0,0x4766,0,0x7025,0,0,0, /* 0,陡,院,陣,除,陥,陦,0, 0,0,陪,0,陬,0,0,0, */
	/* 9670 */ 0x3122,0,0x7024,0x4444,0,0x4e4d,0x462b,0x6f7c, 0x4e26,0,0x3831,0,0,0x4d5b,0,0, /* 陰,0,陲,陳,0,陵,陶,陷, 陸,0,険,0,0,陽,0,0, */
	/* 9680 */ 0,0,0x7b66,0,0x7d5c,0x3679,0x4e34,0, 0x3728,0,0x4262,0x6721,0,0x7026,0x332c,0x3f6f, /* 0,0,隂,0,隄,隅,隆,0, 隈,0,隊,隋,0,隍,階,随, */
	/* 9690 */ 0,0,0,0,0x3356,0x7028,0,0x7029, 0x7027,0x3764,0x7b68,0x3a5d,0x3e63,0x7d5e,0,0, /* 0,0,0,0,隔,隕,0,隗, 隘,隙,隚,際,障,隝,0,0, */
	/* 96a0 */ 0x3123,0,0,0x4e59,0x7d5f,0x7d60,0,0x702b, 0x6e2e,0x7b6b,0x702a,0,0,0,0,0x7b6c, /* 隠,0,0,隣,隤,隥,0,隧, 隨,隩,險,0,0,0,0,隯, */
	/* 96b0 */ 0x702e,0x702c,0x702d,0x7b6d,0x702f,0,0x7030,0x4e6c, 0x7031,0x7032,0x7b6e,0x4049,0x483b,0x7b6f,0,0, /* 隰,隱,隲,隳,隴,0,隶,隷, 隸,隹,隺,隻,隼,隽,0,0, */
	/* 96c0 */ 0x3f7d,0x3467,0,0,0x4d3a,0x326d,0x3d38,0x385b, 0,0x7035,0,0x7034,0x3b73,0x7036,0x7033,0, /* 雀,雁,0,0,雄,雅,集,雇, 0,雉,0,雋,雌,雍,雎,0, */
	/* 96d0 */ 0,0x3b28,0x7d61,0,0,0x703a,0x6a2d,0, 0x7b72,0x5256,0x7b73,0x3f77,0x7038,0x7b74,0x7d62,0, /* 0,雑,雒,0,0,雕,雖,0, 雘,雙,雚,雛,雜,雝,雞,0, */
	/* 96e0 */ 0,0,0x4e25,0x4671,0,0,0,0, 0x312b,0x7d64,0x4063,0x3c36,0,0,0,0x7d65, /* 0,0,離,難,0,0,0,0, 雨,雩,雪,雫,0,0,0,雯, */
	/* 96f0 */ 0x4a37,0,0x3140,0,0,0,0x4e6d,0x4d6b, 0,0x703b,0,0x4545,0,0,0,0, /* 雰,0,雲,0,0,0,零,雷, 0,雹,0,電,0,0,0,0, */
	/* 9700 */ 0x3c7b,0,0,0,0x703c,0,0x703d,0x3f4c, 0x703e,0,0x4e6e,0,0,0x7039,0x7040,0x7042, /* 需,0,0,0,霄,0,霆,震, 霈,0,霊,0,0,霍,霎,霏, */
	/* 9710 */ 0,0x7041,0,0x703f,0x7b76,0,0x7043,0, 0,0x7044,0,0,0x417a,0,0x3262,0, /* 0,霑,0,霓,霔,0,霖,0, 0,霙,0,0,霜,0,霞,0, */
	/* 9720 */ 0,0,0,0x7b77,0x7045,0,0,0x4c38, 0,0,0x7046,0,0,0,0,0, /* 0,0,0,霣,霤,0,0,霧, 0,0,霪,0,0,0,0,0, */
	/* 9730 */ 0x7047,0,0x4f2a,0x7d66,0,0,0x7b79,0, 0x5b31,0x7048,0,0x7d67,0,0x7049,0x704a,0, /* 霰,0,露,霳,0,0,霶,0, 霸,霹,0,霻,0,霽,霾,0, */
	/* 9740 */ 0,0x7b7a,0x704e,0,0x704b,0,0x704c,0x7b7b, 0x704d,0x704f,0,0,0,0x7d68,0x7d69,0x7d6a, /* 0,靁,靂,0,靄,0,靆,靇, 靈,靉,0,0,0,靍,靎,靏, */
	/* 9750 */ 0,0,0x4044,0,0,0x7b7c,0x4c77,0x7b7d, 0,0x4045,0x7d6b,0x7b7e,0x7050,0,0x4873,0, /* 0,0,青,0,0,靕,靖,靗, 0,静,靚,靛,靜,0,非,0, */
	/* 9760 */ 0x7051,0x7353,0x4c4c,0,0x7052,0,0x7053,0, 0x7054,0x3357,0x7c21,0x7056,0,0x3f59,0x7d6c,0, /* 靠,靡,面,0,靤,0,靦,0, 靨,革,靪,靫,0,靭,靮,0, */
	/* 9770 */ 0,0x7057,0,0x7d6d,0x3724,0,0,0, 0,0x7058,0x705c,0,0x705a,0,0,0, /* 0,靱,0,靳,靴,0,0,0, 0,靹,靺,0,靼,0,0,0, */
	/* 9780 */ 0,0x705b,0,0,0x3373,0x7059,0x705d,0, 0,0,0,0x705e,0,0x3048,0,0x705f, /* 0,鞁,0,0,鞄,鞅,鞆,0, 0,0,0,鞋,0,鞍,0,鞏, */
	/* 9790 */ 0x7060,0,0,0,0,0x7d6e,0x7c24,0, 0x3e64,0,0x7c25,0,0x7061,0,0x7c26,0, /* 鞐,0,0,0,0,鞕,鞖,0, 鞘,0,鞚,0,鞜,0,鞞,0, */
	/* 97a0 */ 0x3547,0,0x7c27,0x7064,0,0,0x7063,0, 0x7062,0,0,0x6b71,0,0x4a5c,0x7d6f,0, /* 鞠,0,鞢,鞣,0,0,鞦,0, 鞨,0,0,鞫,0,鞭,鞮,0, */
	/* 97b0 */ 0,0x7c28,0x7c29,0x7065,0x7066,0,0,0, 0,0,0x7d70,0,0,0,0x7c2a,0, /* 0,鞱,鞲,鞳,鞴,0,0,0, 0,0,鞺,0,0,0,鞾,0, */
	/* 97c0 */ 0,0x7d71,0,0x7067,0,0,0x7068,0, 0x7069,0x7d72,0,0x706a,0x7c2b,0,0,0, /* 0,韁,0,韃,0,0,韆,0, 韈,韉,0,韋,韌,0,0,0, */
	/* 97d0 */ 0,0x7c2c,0,0x345a,0x7c2d,0,0,0, 0x7c2e,0x7c2f,0,0x7d74,0x706b,0,0x7d73,0, /* 0,韑,0,韓,韔,0,0,0, 韘,韙,0,韛,韜,0,韞,0, */
	/* 97e0 */ 0,0x7c30,0,0,0,0,0,0, 0,0,0,0,0,0x706c,0x4723,0, /* 0,韡,0,0,0,0,0,0, 0,0,0,0,0,韭,韮,0, */
	/* 97f0 */ 0,0x7c31,0x706e,0x323b,0x7d75,0x7071,0x7070,0, 0,0,0,0x3124,0,0,0,0x3641, /* 0,韱,韲,音,韴,韵,韶,0, 0,0,0,韻,0,0,0,響, */
	/* 9800 */ 0,0x4a47,0x443a,0x3a22,0x7c32,0x3960,0x3d67,0, 0x3f5c,0,0x7d77,0,0x7073,0x7c33,0x7c34,0x7072, /* 0,頁,頂,頃,頄,項,順,0, 須,0,頊,0,頌,頍,頎,頏, */
	/* 9810 */ 0x4d42,0x3468,0x4852,0x465c,0x7c35,0,0x7c36,0x3f7c, 0x4e4e,0,0x375b,0,0,0,0x7d78,0, /* 預,頑,頒,頓,頔,0,頖,頗, 領,0,頚,0,0,0,頞,0, */
	/* 9820 */ 0,0x7076,0,0x7c39,0x7075,0x7c3c,0,0, 0,0,0,0x7d79,0x4b4b,0x462c,0,0, /* 0,頡,0,頣,頤,頥,0,0, 0,0,0,頫,頬,頭,0,0, */
	/* 9830 */ 0x7d7a,0,0x7c3a,0x7c3b,0x3150,0,0,0x7077, 0x7074,0,0,0x4951,0x4d6a,0x7078,0,0, /* 頰,0,頲,頳,頴,0,0,頷, 頸,0,0,頻,頼,頽,0,0, */
	/* 9840 */ 0,0,0,0,0,0,0x7079,0x7c3d, 0,0,0,0x707b,0x426a,0x335b,0x335c,0x707a, /* 0,0,0,0,0,0,顆,顇, 0,0,0,顋,題,額,顎,顏, */
	/* 9850 */ 0,0,0x7d7c,0x7d7d,0x3469,0x3832,0x7d7e,0x7e21, 0x346a,0x7e22,0x7e23,0x453f,0,0,0x4e60,0, /* 0,0,顒,顓,顔,顕,顖,顗, 願,顙,顚,顛,0,0,類,0, */
	/* 9860 */ 0,0,0,0,0,0x7e25,0x7c3e,0x385c, 0,0,0,0x707c,0x7e26,0,0,0x707d, /* 0,0,0,0,0,顥,顦,顧, 0,0,0,顫,顬,0,0,顯, */
	/* 9870 */ 0x707e,0x7121,0,0x7123,0x7122,0,0,0, 0,0,0,0,0,0,0,0, /* 顰,顱,0,顳,顴,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 98a0 */ 0,0,0,0,0,0,0,0, 0x4977,0,0x7124,0x7c3f,0,0x7c40,0,0x7125, /* 0,0,0,0,0,0,0,0, 風,0,颪,颫,0,颭,0,颯, */
	/* 98b0 */ 0x7c41,0x7126,0,0,0,0,0x7127,0x7c43, 0x7c44,0,0x7e27,0x7c45,0x7c46,0,0,0x7c47, /* 颰,颱,0,0,0,0,颶,颷, 颸,0,颺,颻,颼,0,0,颿, */
	/* 98c0 */ 0,0,0x7c48,0x7129,0x7128,0,0x712a,0x7c49, 0x7e28,0,0,0x7c4a,0,0,0,0, /* 0,0,飂,飃,飄,0,飆,飇, 飈,0,0,飋,0,0,0,0, */
	/* 98d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x4874,0x664c,0,0,0x3f29, /* 0,0,0,0,0,0,0,0, 0,0,0,飛,飜,0,0,食, */
	/* 98e0 */ 0x7c4b,0x7c4d,0x3532,0x7c4e,0,0x7c4f,0,0x7e29, 0,0x712b,0x7c50,0x712c,0,0x522c,0x5d3b,0x4853, /* 飠,飡,飢,飣,0,飥,0,飧, 0,飩,飪,飫,0,飭,飮,飯, */
	/* 98f0 */ 0x7c51,0x7c52,0x307b,0x7c53,0x303b,0,0,0, 0,0,0,0,0x3b74,0x4b30,0x3e7e,0, /* 飰,飱,飲,飳,飴,0,0,0, 0,0,0,0,飼,飽,飾,0, */
	/* 9900 */ 0,0,0,0x712d,0,0x4c5f,0,0, 0x7c54,0x712e,0x4d5c,0,0x3142,0,0,0, /* 0,0,0,餃,0,餅,0,0, 餈,餉,養,0,餌,0,0,0, */
	/* 9910 */ 0x3b41,0,0x712f,0x326e,0x7130,0,0x7c57,0x7c58, 0x7131,0,0x7c5a,0x7c5b,0x7c5c,0x7133,0x7134,0, /* 餐,0,餒,餓,餔,0,餖,餗, 餘,0,餚,餛,餜,餝,餞,0, */
	/* 9920 */ 0x7136,0x7132,0,0,0x7135,0,0,0, 0x345b,0,0,0,0x7137,0,0x7138,0, /* 餠,餡,0,0,餤,0,0,0, 館,0,0,0,餬,0,餮,0, */
	/* 9930 */ 0,0x7c5e,0x7c5f,0x7c60,0,0,0,0, 0,0,0x7c61,0x7c62,0x7c63,0x7139,0x713a,0, /* 0,餱,餲,餳,0,0,0,0, 0,0,餺,餻,餼,餽,餾,0, */
	/* 9940 */ 0x7c64,0x7c65,0x713b,0,0,0x713d,0x7c66,0, 0,0x713c,0,0x713f,0x7142,0x7c67,0x7c68,0, /* 饀,饁,饂,0,0,饅,饆,0, 0,饉,0,饋,饌,饍,饎,0, */
	/* 9950 */ 0x713e,0x7140,0x7141,0,0,0x7143,0,0x3642, 0x7e2a,0,0,0,0x7c69,0,0,0x7c6a, /* 饐,饑,饒,0,0,饕,0,饗, 饘,0,0,0,饜,0,0,饟, */
	/* 9960 */ 0x7c6b,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 饠,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9990 */ 0,0,0,0,0,0,0x3c73,0x7144, 0x7145,0x3961,0,0,0,0,0x7e2b,0, /* 0,0,0,0,0,0,首,馗, 馘,香,0,0,0,0,馞,0, */
	/* 99a0 */ 0,0,0,0x7c6c,0,0x7146,0x7c6d,0, 0x333e,0,0,0,0x474f,0x7147,0x7148,0, /* 0,0,0,馣,0,馥,馦,0, 馨,0,0,0,馬,馭,馮,0, */
	/* 99b0 */ 0,0,0,0x435a,0x466b,0,0,0, 0,0x7c6e,0,0,0x7149,0x7c6f,0,0x7c70, /* 0,0,0,馳,馴,0,0,0, 0,馹,0,0,馼,馽,0,馿, */
	/* 99c0 */ 0,0x477d,0,0x7c71,0x424c,0x3158,0x366e,0, 0x366f,0x7c72,0,0,0,0,0,0, /* 0,駁,0,駃,駄,駅,駆,0, 駈,駉,0,0,0,0,0,0, */
	/* 99d0 */ 0x4373,0x714e,0x3670,0,0x7c73,0x326f,0,0, 0x714d,0x7c74,0,0x714b,0,0x714c,0x7c75,0x714a, /* 駐,駑,駒,0,駔,駕,0,0, 駘,駙,0,駛,0,駝,駞,駟, */
	/* 99e0 */ 0,0,0x7158,0,0,0,0,0, 0,0,0,0,0,0x714f,0x7150,0, /* 0,0,駢,0,0,0,0,0, 0,0,0,0,0,駭,駮,0, */
	/* 99f0 */ 0x7c77,0x7151,0x7152,0,0,0,0,0, 0x7154,0x7c78,0,0x7153,0x7c79,0,0,0x3d59, /* 駰,駱,駲,0,0,0,0,0, 駸,駹,0,駻,駼,0,0,駿, */
	/* 9a00 */ 0,0x7155,0x7e2c,0x7e2d,0,0x7157,0,0, 0,0,0x7c7a,0,0,0,0x3533,0x7156, /* 0,騁,騂,騃,0,騅,0,0, 0,0,騊,0,0,0,騎,騏, */
	/* 9a10 */ 0,0x7c7b,0x417b,0x3833,0,0,0x7c7c,0, 0,0x7159,0x7c7d,0,0,0,0,0, /* 0,騑,騒,験,0,0,騖,0, 0,騙,騚,0,0,0,0,0, */
	/* 9a20 */ 0x7c7e,0,0,0,0x7e2e,0,0,0, 0x424d,0,0,0x715a,0,0x7e2f,0x7e30,0, /* 騠,0,0,0,騤,0,0,0, 騨,0,0,騫,0,騭,騮,0, */
	/* 9a30 */ 0x462d,0x7d21,0,0,0,0,0x7d22,0x715b, 0x7e31,0,0,0,0,0,0x7160,0, /* 騰,騱,0,0,0,0,騶,騷, 騸,0,0,0,0,0,騾,0, */
	/* 9a40 */ 0x715e,0,0x715d,0x715f,0x7d23,0x715c,0,0, 0,0,0x7e32,0,0x7d24,0x7162,0x7e33,0, /* 驀,0,驂,驃,驄,驅,0,0, 0,0,驊,0,驌,驍,驎,0, */
	/* 9a50 */ 0,0,0x7e34,0,0,0x7161,0,0x7164, 0x7d25,0,0x3643,0x7163,0,0,0,0x7165, /* 0,0,驒,0,0,驕,0,驗, 驘,0,驚,驛,0,0,0,驟, */
	/* 9a60 */ 0,0,0x7166,0,0x7168,0x7167,0,0, 0,0x7169,0x716b,0x716a,0,0,0,0, /* 0,0,驢,0,驤,驥,0,0, 0,驩,驪,驫,0,0,0,0, */
	/* 9a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9aa0 */ 0,0,0,0,0,0,0,0, 0x397c,0,0,0,0,0x716c,0,0x7d27, /* 0,0,0,0,0,0,0,0, 骨,0,0,0,0,骭,0,骯, */
	/* 9ab0 */ 0x716d,0,0,0,0,0,0x7e35,0x7d29, 0x333c,0x7d2b,0,0,0x716e,0,0,0, /* 骰,0,0,0,0,0,骶,骷, 骸,骹,0,0,骼,0,0,0, */
	/* 9ac0 */ 0x716f,0x7e36,0,0x7e37,0x3f71,0,0x7d2d,0, 0,0,0,0,0,0,0x7e38,0x7170, /* 髀,髁,0,髃,髄,0,髆,0, 0,0,0,0,0,0,髎,髏, */
	/* 9ad0 */ 0x7d2e,0x7171,0x7d2f,0x7172,0x7173,0x7d30,0x7e39,0, 0x3962,0,0,0,0x7d32,0,0x7174,0x7175, /* 髐,髑,髒,髓,體,髕,髖,0, 高,0,0,0,髜,0,髞,髟, */
	/* 9ae0 */ 0x7d33,0,0x7176,0x7177,0,0x7d34,0x7178,0, 0,0x7d35,0x4831,0x717a,0,0x4926,0x717b,0x7179, /* 髠,0,髢,髣,0,髥,髦,0, 0,髩,髪,髫,0,髭,髮,髯, */
	/* 9af0 */ 0,0x717d,0,0,0x717c,0,0,0x717e, 0,0x7e3a,0,0x7221,0,0,0,0, /* 0,髱,0,0,髴,0,0,髷, 0,髹,0,髻,0,0,0,0, */
	/* 9b00 */ 0,0,0x7e3b,0x7d36,0,0,0x7222,0, 0x7e3c,0,0,0,0x7d37,0,0,0, /* 0,0,鬂,鬃,0,0,鬆,0, 鬈,0,0,0,鬌,0,0,0, */
	/* 9b10 */ 0x7d38,0,0x7d39,0,0,0,0x7d3a,0, 0x7223,0,0x7224,0,0x7d3b,0,0,0x7225, /* 鬐,0,鬒,0,0,0,鬖,0, 鬘,0,鬚,0,鬜,0,0,鬟, */
	/* 9b20 */ 0x7e3d,0,0x7226,0x7227,0,0x7228,0,0x7229, 0x722a,0x722b,0x722c,0x7d3c,0,0x7e3f,0x722d,0x722e, /* 鬠,0,鬢,鬣,0,鬥,0,鬧, 鬨,鬩,鬪,鬫,0,鬭,鬮,鬯, */
	/* 9b30 */ 0,0x5d35,0x722f,0x7d3d,0,0,0,0, 0,0,0,0x6478,0x3534,0x7d3e,0,0, /* 0,鬱,鬲,鬳,0,0,0,0, 0,0,0,鬻,鬼,鬽,0,0, */
	/* 9b40 */ 0,0x3321,0x3a32,0x7231,0x7230,0x4c25,0,0, 0,0,0,0x7d40,0,0x7233,0x7234,0x7232, /* 0,魁,魂,魃,魄,魅,0,0, 0,0,0,魋,0,魍,魎,魏, */
	/* 9b50 */ 0,0x7235,0,0,0x4b62,0,0,0, 0x7236,0,0x357b,0,0,0,0x7e40,0, /* 0,魑,0,0,魔,0,0,0, 魘,0,魚,0,0,0,魞,0, */
	/* 9b60 */ 0,0,0,0x7d41,0,0x7d42,0x7e42,0, 0,0,0,0x7d43,0x7d44,0,0,0x4f25, /* 0,0,0,魣,0,魥,魦,0, 0,0,0,魫,魬,0,0,魯, */
	/* 9b70 */ 0,0,0x7e43,0x7d45,0x7237,0x7e44,0x7d46,0x7d47, 0,0x7e41,0,0,0,0,0,0, /* 0,0,魲,魳,魴,魵,魶,魷, 0,魹,0,0,0,0,0,0, */
	/* 9b80 */ 0,0,0,0x7239,0x7e45,0,0,0, 0,0,0x7e46,0,0,0,0x303e,0x7e47, /* 0,0,0,鮃,鮄,0,0,0, 0,0,鮊,0,0,0,鮎,鮏, */
	/* 9b90 */ 0,0x723a,0x4a2b,0x7238,0,0,0x723b,0x723c, 0,0,0,0,0,0,0x7e48,0x723d, /* 0,鮑,鮒,鮓,0,0,鮖,鮗, 0,0,0,0,0,0,鮞,鮟, */
	/* 9ba0 */ 0x723e,0,0,0,0,0,0x7d48,0x7e49, 0x723f,0,0x4b6e,0x3b2d,0x7d49,0x3a7a,0x412f,0, /* 鮠,0,0,0,0,0,鮦,鮧, 鮨,0,鮪,鮫,鮬,鮭,鮮,0, */
	/* 9bb0 */ 0,0x7d4a,0x7d4d,0,0x7240,0,0,0, 0x7d4e,0x7243,0,0,0,0,0x7d4f,0, /* 0,鮱,鮲,0,鮴,0,0,0, 鮸,鮹,0,0,0,0,鮾,0, */
	/* 9bc0 */ 0x7241,0x7e4a,0,0,0,0,0x7244,0x7d50, 0,0x3871,0x7242,0,0,0,0x7e4b,0x7245, /* 鯀,鯁,0,0,0,0,鯆,鯇, 0,鯉,鯊,0,0,0,鯎,鯏, */
	/* 9bd0 */ 0,0x7246,0x7247,0,0x724b,0,0x3b2a,0, 0x7d52,0,0,0x4264,0,0x7d53,0,0, /* 0,鯑,鯒,0,鯔,0,鯖,0, 鯘,0,0,鯛,0,鯝,0,0, */
	/* 9be0 */ 0,0x724c,0x7249,0x7248,0x724a,0x7e4c,0,0x7d54, 0x375f,0,0x7d55,0x7d56,0,0,0x7d58,0x7d57, /* 0,鯡,鯢,鯣,鯤,鯥,0,鯧, 鯨,0,鯪,鯫,0,0,鯮,鯯, */
	/* 9bf0 */ 0x7250,0x724f,0x724e,0x7d51,0,0x3033,0,0x7d5c, 0x7e4d,0,0x7d5a,0,0,0x7e4e,0,0, /* 鯰,鯱,鯲,鯳,0,鯵,0,鯷, 鯸,0,鯺,0,0,鯽,0,0, */
	/* 9c00 */ 0x7e4f,0,0,0,0x725a,0,0x7256,0, 0x7257,0x7253,0x7259,0,0x7255,0x3362,0,0, /* 鰀,0,0,0,鰄,0,鰆,0, 鰈,鰉,鰊,0,鰌,鰍,0,0, */
	/* 9c10 */ 0x4f4c,0,0x7258,0x7254,0x7252,0x7251,0x7d5e,0, 0x7d5f,0x7d60,0x7d61,0x725c,0,0x7d62,0,0, /* 鰐,0,鰒,鰓,鰔,鰕,鰖,0, 鰘,鰙,鰚,鰛,0,鰝,0,0, */
	/* 9c20 */ 0,0x725f,0x7d63,0x7e50,0x725e,0x725d,0,0x7d64, 0,0x7d65,0x7d66,0,0,0x4949,0x725b,0x3073, /* 0,鰡,鰢,鰣,鰤,鰥,0,鰧, 0,鰩,鰪,0,0,鰭,鰮,鰯, */
	/* 9c30 */ 0x7260,0x7d68,0x7262,0,0,0,0x7d69,0x7d6a, 0,0x336f,0x724d,0x3137,0,0,0x7264,0, /* 鰰,鰱,鰲,0,0,0,鰶,鰷, 0,鰹,鰺,鰻,0,0,鰾,0, */
	/* 9c40 */ 0,0x7e51,0,0,0,0x7d6b,0x7263,0x7261, 0x432d,0x7d6e,0x7d6f,0,0,0,0,0x7e52, /* 0,鱁,0,0,0,鱅,鱆,鱇, 鱈,鱉,鱊,0,0,0,0,鱏, */
	/* 9c50 */ 0x7e53,0,0x4b70,0x7e54,0x7d71,0,0,0x4e5a, 0x7d72,0,0x7265,0x7d73,0x7d6c,0x7d74,0,0x7d75, /* 鱐,0,鱒,鱓,鱔,0,0,鱗, 鱘,0,鱚,鱛,鱜,鱝,0,鱟, */
	/* 9c60 */ 0x7266,0,0,0x7e55,0,0x7e56,0,0x7267, 0,0x7d76,0x7d77,0x7d78,0,0x7d79,0x7d7a,0, /* 鱠,0,0,鱣,0,鱥,0,鱧, 0,鱩,鱪,鱫,0,鱭,鱮,0, */
	/* 9c70 */ 0x7d7b,0,0x7d7c,0,0,0x7d7d,0x7268,0x7e57, 0x7269,0,0x7d7e,0,0,0,0,0, /* 鱰,0,鱲,0,0,鱵,鱶,鱷, 鱸,0,鱺,0,0,0,0,0, */
	/* 9c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ce0 */ 0,0,0,0,0,0x443b,0x7e21,0x726a, 0,0x4837,0,0x726f,0x726b,0,0,0, /* 0,0,0,0,0,鳥,鳦,鳧, 0,鳩,0,鳫,鳬,0,0,0, */
	/* 9cf0 */ 0x726c,0,0x7e22,0x4b31,0x4c44,0,0x4650,0, 0,0,0,0,0,0,0,0, /* 鳰,0,鳲,鳳,鳴,0,鳶,0, 0,0,0,0,0,0,0,0, */
	/* 9d00 */ 0,0,0x7e24,0x7270,0,0,0x7271,0x463e, 0x726e,0x726d,0,0x7e23,0,0,0x322a,0, /* 0,0,鴂,鴃,0,0,鴆,鴇, 鴈,鴉,0,鴋,0,0,鴎,0, */
	/* 9d10 */ 0,0x7e26,0x7279,0,0,0x7278,0,0x7e27, 0x7e28,0,0,0x3175,0,0x7e58,0x7e59,0x7276, /* 0,鴑,鴒,0,0,鴕,0,鴗, 鴘,0,0,鴛,0,鴝,鴞,鴟, */
	/* 9d20 */ 0,0,0,0x7275,0,0,0x7273,0, 0x337b,0,0x7272,0x3c32,0x3229,0,0,0, /* 0,0,0,鴣,0,0,鴦,0, 鴨,0,鴪,鴫,鴬,0,0,0, */
	/* 9d30 */ 0,0,0x7e2c,0,0,0,0,0, 0,0,0,0x3963,0,0,0x727c,0x727b, /* 0,0,鴲,0,0,0,0,0, 0,0,0,鴻,0,0,鴾,鴿, */
	/* 9d40 */ 0,0x727a,0x7e2e,0x7e5a,0x7277,0,0x727d,0x7e5b, 0x727e,0,0x7e2f,0,0,0,0,0, /* 0,鵁,鵂,鵃,鵄,0,鵆,鵇, 鵈,0,鵊,0,0,0,0,0, */
	/* 9d50 */ 0x7325,0x7324,0x7e5c,0,0,0,0,0, 0,0x7326,0,0,0x312d,0x7321,0x7322,0x7e30, /* 鵐,鵑,鵒,0,0,0,0,0, 0,鵙,0,0,鵜,鵝,鵞,鵟, */
	/* 9d60 */ 0x3974,0x4c39,0x7e31,0x7e5d,0x7323,0,0,0, 0,0x7e33,0,0x7e34,0x4b32,0,0,0x732b, /* 鵠,鵡,鵢,鵣,鵤,0,0,0, 0,鵩,0,鵫,鵬,0,0,鵯, */
	/* 9d70 */ 0x7e5e,0,0x7327,0x7e36,0,0,0x7e37,0x7e38, 0,0,0x732c,0,0x7e5f,0,0x7e39,0, /* 鵰,0,鵲,鵳,0,0,鵶,鵷, 0,0,鵺,0,鵼,0,鵾,0, */
	/* 9d80 */ 0,0,0,0,0x7e3a,0,0,0x7329, 0,0x7328,0x7e60,0,0,0x7e3b,0,0x375c, /* 0,0,0,0,鶄,0,0,鶇, 0,鶉,鶊,0,0,鶍,0,鶏, */
	/* 9d90 */ 0,0,0,0,0,0,0x7e61,0, 0,0x7e3c,0x732d,0,0,0,0,0, /* 0,0,0,0,0,0,鶖,0, 0,鶙,鶚,0,0,0,0,0, */
	/* 9da0 */ 0,0x7e3d,0,0,0x732e,0,0,0, 0,0x732f,0,0x732a,0x7e63,0,0,0x7274, /* 0,鶡,0,0,鶤,0,0,0, 0,鶩,0,鶫,鶬,0,0,鶯, */
	/* 9db0 */ 0,0,0x7330,0,0x4461,0x7e3f,0,0, 0x7334,0x7e40,0x7335,0x7333,0x7e64,0x7e41,0,0x7e3e, /* 0,0,鶲,0,鶴,鶵,0,0, 鶸,鶹,鶺,鶻,鶼,鶽,0,鶿, */
	/* 9dc0 */ 0x7e62,0x7332,0x7338,0x7e42,0x7331,0,0x7336,0x7e43, 0,0x7e44,0,0,0,0,0,0x7337, /* 鷀,鷁,鷂,鷃,鷄,0,鷆,鷇, 0,鷉,0,0,0,0,0,鷏, */
	/* 9dd0 */ 0,0,0,0x733a,0,0,0x7e45,0x7e65, 0,0x7339,0x7e46,0,0,0,0,0x7e47, /* 0,0,0,鷓,0,0,鷖,鷗, 0,鷙,鷚,0,0,0,0,鷟, */
	/* 9de0 */ 0x7e48,0,0,0x7e49,0,0,0x733c,0x7e67, 0,0,0,0,0,0x733d,0,0x733e, /* 鷠,0,0,鷣,0,0,鷦,鷧, 0,0,0,0,0,鷭,0,鷯, */
	/* 9df0 */ 0,0,0x4f49,0,0x7e4a,0,0,0, 0x733b,0x426b,0x3a6d,0,0,0x733f,0,0, /* 0,0,鷲,0,鷴,0,0,0, 鷸,鷹,鷺,0,0,鷽,0,0, */
	/* 9e00 */ 0,0,0x7e4d,0,0,0,0,0x7e68, 0,0,0x7e4c,0,0,0x7e4e,0,0, /* 0,0,鸂,0,0,0,0,鸇, 0,0,鸊,0,0,鸍,0,0, */
	/* 9e10 */ 0,0,0,0,0,0x7e69,0,0, 0,0x7e4f,0x7340,0x7341,0x7e50,0x7e51,0x7342,0, /* 0,0,0,0,0,鸕,0,0, 0,鸙,鸚,鸛,鸜,鸝,鸞,0, */
	/* 9e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e70 */ 0,0,0,0,0,0x7343,0,0, 0x3834,0x7344,0,0x7e52,0x7e6a,0x7345,0,0x3c2f, /* 0,0,0,0,0,鹵,0,0, 鹸,鹹,0,鹻,鹼,鹽,0,鹿, */
	/* 9e80 */ 0x7e54,0x7346,0,0,0,0x7e55,0,0, 0x7347,0,0,0x7348,0x7349,0,0,0, /* 麀,麁,0,0,0,麅,0,0, 麈,0,0,麋,麌,0,0,0, */
	/* 9e90 */ 0,0x734c,0x734a,0x4f3c,0,0x734b,0,0x4e6f, 0,0,0,0x7e56,0,0x734d,0x7e6b,0x4e5b, /* 0,麑,麒,麓,0,麕,0,麗, 0,0,0,麛,0,麝,麞,麟, */
	/* 9ea0 */ 0,0,0,0,0x7e6c,0x734e,0x477e,0, 0x7e57,0x734f,0x7351,0,0x7e6d,0x7352,0,0x7e6e, /* 0,0,0,0,麤,麥,麦,0, 麨,麩,麪,0,麬,麭,0,麯, */
	/* 9eb0 */ 0,0,0,0,0x7e6f,0x7e70,0,0, 0x7350,0x396d,0x4c4d,0x4b63,0x5677,0x7e59,0x5d60,0x4b7b, /* 0,0,0,0,麴,麵,0,0, 麸,麹,麺,麻,麼,麽,麾,麿, */
	/* 9ec0 */ 0,0,0,0x7e71,0x322b,0,0,0, 0,0,0,0,0x7354,0x3550,0x7355,0x7356, /* 0,0,0,黃,黄,0,0,0, 0,0,0,0,黌,黍,黎,黏, */
	/* 9ed0 */ 0x7357,0x7e72,0x3975,0,0x7358,0,0,0, 0x6054,0x4c5b,0,0x4263,0x7359,0x735b,0x735a,0x7e5b, /* 黐,黑,黒,0,黔,0,0,0, 默,黙,0,黛,黜,黝,點,黟, */
	/* 9ee0 */ 0x735c,0,0,0,0,0x735d,0,0x7e5c, 0x735e,0,0,0,0,0,0x7e5d,0x735f, /* 黠,0,0,0,0,黥,0,黧, 黨,0,0,0,0,0,黮,黯, */
	/* 9ef0 */ 0,0,0,0,0x7360,0,0x7361,0x7362, 0,0x7363,0,0x7364,0x7365,0x7366,0,0x7e5e, /* 0,0,0,0,黴,0,黶,黷, 0,黹,0,黻,黼,黽,0,黿, */
	/* 9f00 */ 0,0,0x7e5f,0x7e61,0,0,0,0x7367, 0x7368,0,0,0,0,0,0x4524,0, /* 0,0,鼂,鼃,0,0,0,鼇, 鼈,0,0,0,0,0,鼎,0, */
	/* 9f10 */ 0x7e73,0,0,0x385d,0,0x736a,0,0x7e62, 0,0x7e63,0,0,0,0,0,0, /* 鼐,0,0,鼓,0,鼕,0,鼗, 0,鼙,0,0,0,0,0,0, */
	/* 9f20 */ 0x414d,0x736b,0,0,0,0,0,0, 0,0,0,0,0x736c,0,0,0x7e64, /* 鼠,鼡,0,0,0,0,0,0, 0,0,0,0,鼬,0,0,鼯, */
	/* 9f30 */ 0,0,0,0,0,0,0,0x7e65, 0,0x7e74,0x7e66,0x4921,0,0x7e67,0x736d,0, /* 0,0,0,0,0,0,0,鼷, 0,鼹,鼺,鼻,0,鼽,鼾,0, */
	/* 9f40 */ 0,0x7e68,0,0,0,0x7e69,0x7e6a,0, 0,0,0x736e,0x6337,0,0,0x6c5a,0x706d, /* 0,齁,0,0,0,齅,齆,0, 0,0,齊,齋,0,0,齎,齏, */
	/* 9f50 */ 0,0,0x736f,0x7e6b,0x7370,0x7e6c,0,0x7e75, 0x7e6d,0,0,0,0,0x7e6f,0,0x7372, /* 0,0,齒,齓,齔,齕,0,齗, 齘,0,0,0,0,齝,0,齟, */
	/* 9f60 */ 0x7373,0x7374,0x4e70,0x7371,0,0,0x7375,0x7376, 0,0x7e71,0x7378,0,0x7377,0x7e73,0,0, /* 齠,齡,齢,齣,0,0,齦,齧, 0,齩,齪,0,齬,齭,0,0, */
	/* 9f70 */ 0x7e74,0,0x737a,0,0,0x7e75,0x737b,0x7379, 0,0,0,0,0,0,0,0, /* 齰,0,齲,0,0,齵,齶,齷, 0,0,0,0,0,0,0,0, */
	/* 9f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x4e36,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,龍,0,0, */
	/* 9f90 */ 0x7e76,0,0,0,0x7e77,0x737c,0,0x7e78, 0,0,0,0,0x737d,0x6354,0,0, /* 龐,0,0,0,龔,龕,0,龗, 0,0,0,0,龜,龝,0,0, */
	/* 9fa0 */ 0x737e,0,0x7e79,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 龠,0,龢,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ace0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ada0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* add0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ade0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* beb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ceb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ced0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* deb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ded0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* def0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ead0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ece0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ede0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x763b,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,欄,0,0, */
	/* f920 */ 0,0,0,0,0,0,0,0, 0x742e,0x754e,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 廊,朗,0,0,0,0,0,0, */
	/* f930 */ 0,0,0,0,0,0,0x7b4f,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,虜,0, 0,0,0,0,0,0,0,0, */
	/* f940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f970 */ 0x7649,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 殺,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* f980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9d0 */ 0x7e24,0,0,0,0,0,0,0, 0,0,0,0,0x7d5d,0,0,0, /* 類,0,0,0,0,0,0,0, 0,0,0,0,隆,0,0,0, */
	/* f9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x2f4b, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,﨏, */
	/* fa10 */ 0x2f57,0x4f72,0,0x2e79,0x757a,0x775a,0x776f,0, 0,0x793c,0x793d,0x7941,0,0,0,0x7b3a, /* 塚,﨑,0,﨓,﨔,凞,猪,0, 0,神,祥,福,0,0,0,﨟, */
	/* fa20 */ 0x7738,0x7745,0x7c2e,0,0x796e,0,0x7c6a,0, 0,0,0,0,0,0,0,0, /* 蘒,﨡,諸,0,﨤,0,都,0, 0,0,0,0,0,0,0,0, */
	/* fa30 */ 0x2e38,0x2e49,0x2e50,0x2e63,0x2e68,0x2e6e,0x2f2c,0x2f2f, 0x2f36,0x2f5a,0x2f5e,0x4f61,0x4f62,0x7450,0x745c,0x745e, /* 侮,僧,免,勉,勤,卑,喝,嘆, 器,塀,墨,層,屮,悔,慨,憎, */
	/* fa40 */ 0x7461,0x7528,0x752b,0x7543,0x7565,0x7669,0x7677,0x7725, 0x7755,0x7029,0x7825,0x7927,0x7933,0x7934,0x7937,0x7938, /* 懲,敏,既,暑,梅,海,渚,漢, 煮,爫,琢,碑,社,祉,祈,祐, */
	/* fa50 */ 0x7939,0x793b,0x793f,0x7940,0x794d,0x7951,0x7964,0x7a2e, 0x7450,0x7a33,0x7a3a,0x7a44,0x7a58,0x7574,0x7575,0x7b27, /* 祖,祝,禍,禎,穀,突,節,練, 縉,繁,署,者,臭,艹,艹,著, */
	/* fa60 */ 0x7b6f,0x7b79,0x7c2f,0x7c30,0x7c38,0x7c3d,0x7969,0x7c59, 0x7d63,0x7d76,0x7d7b,0,0,0,0,0, /* 褐,視,謁,謹,賓,贈,辶,逸, 難,響,頻,0,0,0,0,0, */
	/* fa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe40 */ 0,0,0,0,0,0x233e,0x233d,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,﹅,﹆,0, 0,0,0,0,0,0,0,0, */
	/* fe50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* feb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ff00 */ 0,0x212a,0x2230,0x2174,0x2170,0x2173,0x2175,0x222f, 0x214a,0x214b,0x2176,0x215c,0x2124,0x2231,0x2125,0x213f, /* 0,！,＂,＃,＄,％,＆,＇, （,）,＊,＋,，,－,．,／, */
	/* ff10 */ 0x2330,0x2331,0x2332,0x2333,0x2334,0x2335,0x2336,0x2337, 0x2338,0x2339,0x2127,0x2128,0x2163,0x2161,0x2164,0x2129, /* ０,１,２,３,４,５,６,７, ８,９,：,；,＜,＝,＞,？, */
	/* ff20 */ 0x2177,0x2341,0x2342,0x2343,0x2344,0x2345,0x2346,0x2347, 0x2348,0x2349,0x234a,0x234b,0x234c,0x234d,0x234e,0x234f, /* ＠,Ａ,Ｂ,Ｃ,Ｄ,Ｅ,Ｆ,Ｇ, Ｈ,Ｉ,Ｊ,Ｋ,Ｌ,Ｍ,Ｎ,Ｏ, */
	/* ff30 */ 0x2350,0x2351,0x2352,0x2353,0x2354,0x2355,0x2356,0x2357, 0x2358,0x2359,0x235a,0x214e,0x2140,0x214f,0x2130,0x2132, /* Ｐ,Ｑ,Ｒ,Ｓ,Ｔ,Ｕ,Ｖ,Ｗ, Ｘ,Ｙ,Ｚ,［,＼,］,＾,＿, */
	/* ff40 */ 0x212e,0x2361,0x2362,0x2363,0x2364,0x2365,0x2366,0x2367, 0x2368,0x2369,0x236a,0x236b,0x236c,0x236d,0x236e,0x236f, /* ｀,ａ,ｂ,ｃ,ｄ,ｅ,ｆ,ｇ, ｈ,ｉ,ｊ,ｋ,ｌ,ｍ,ｎ,ｏ, */
	/* ff50 */ 0x2370,0x2371,0x2372,0x2373,0x2374,0x2375,0x2376,0x2377, 0x2378,0x2379,0x237a,0x2150,0x2143,0x2151,0x2232,0x2256, /* ｐ,ｑ,ｒ,ｓ,ｔ,ｕ,ｖ,ｗ, ｘ,ｙ,ｚ,｛,｜,｝,～,｟, */
	/* ff60 */ 0x2257,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, 0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* '｠','｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* ff70 */ 0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, 0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* ff80 */ 0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, 0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* ff90 */ 0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, 0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
	/* ffa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffe0 */ 0x2171,0x2172,0x224c,0x2131,0,0x216f, /* '￠','￡','￢','￣',0,'￥', */
};

const size_t _unibe2jis2022jp2004_table_size = sizeof(_unibe2jis2022jp2004_table) / sizeof(_unibe2jis2022jp2004_table[0]);

#endif /* #ifndef __UNIBE2JIS2022JP2004_TABLE_H_ */
