/*
 * _unibe2jis2022jp3_table_bits.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __UNIBE2JIS2022JP3_TABLE_BITS_H_
#define __UNIBE2JIS2022JP3_TABLE_BITS_H_

#include <stddef.h>

const char _unibe2jis2022jp3_table_bits[] = {
	/* 0000 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	/* 0010 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	/* 0020 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* ' ','!','"','#','$','%','&','\'', '(',')','*','+',',','-','.','/', */
	/* 0030 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* '0','1','2','3','4','5','6','7', '8','9',':',';','<','=','>','?', */
	/* 0040 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O', */
	/* 0050 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* 'P','Q','R','S','T','U','V','W', 'X','Y','Z','[','\\',']','^','_', */
	/* 0060 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* '`','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o', */
	/* 0070 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0,-1, /* 'p','q','r','s','t','u','v','w', 'x','y','z','{','|','}','~',0, */
	/* 0080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00a0 */  7, 7, 7, 7, 7, 2, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* ' ','¡','¢','£','¤','¥','¦','§', '¨','©','ª','«','¬','­','®','¯', */
	/* 00b0 */  7, 7, 7, 7, 7,-1, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '°','±','²','³','´',0,'¶','·', '¸','¹','º','»','¼','½','¾','¿', */
	/* 00c0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'À','Á','Â','Ã','Ä','Å','Æ','Ç', 'È','É','Ê','Ë','Ì','Í','Î','Ï', */
	/* 00d0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'Ð','Ñ','Ò','Ó','Ô','Õ','Ö','×', 'Ø','Ù','Ú','Û','Ü','Ý','Þ','ß', */
	/* 00e0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'à','á','â','ã','ä','å','æ','ç', 'è','é','ê','ë','ì','í','î','ï', */
	/* 00f0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'ð','ñ','ò','ó','ô','õ','ö','÷', 'ø','ù','ú','û','ü','ý','þ','ÿ', */
	/* 0100 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7,-1,-1, 7, 7, 7, 7, /* 'Ā','ā','Ă','ă','Ą','ą','Ć','ć', 'Ĉ','ĉ',0,0,'Č','č','Ď','ď', */
	/* 0110 */ -1, 7, 7, 7,-1,-1,-1,-1,  7, 7, 7, 7, 7, 7,-1,-1, /* 0,'đ','Ē','ē',0,0,0,0, 'Ę','ę','Ě','ě','Ĝ','ĝ',0,0, */
	/* 0120 */ -1,-1,-1,-1, 7, 7,-1, 7, -1,-1, 7, 7,-1,-1,-1,-1, /* 0,0,0,0,'Ĥ','ĥ',0,'ħ', 0,0,'Ī','ī',0,0,0,0, */
	/* 0130 */ -1,-1,-1,-1, 7, 7,-1,-1, -1, 7, 7,-1,-1, 7, 7,-1, /* 0,0,0,0,'Ĵ','ĵ',0,0, 0,'Ĺ','ĺ',0,0,'Ľ','ľ',0, */
	/* 0140 */ -1, 7, 7, 7, 7,-1,-1, 7,  7,-1,-1, 7, 7, 7,-1,-1, /* 0,'Ł','ł','Ń','ń',0,0,'Ň', 'ň',0,0,'ŋ','Ō','ō',0,0, */
	/* 0150 */  7, 7, 7, 7, 7, 7,-1,-1,  7, 7, 7, 7, 7, 7, 7, 7, /* 'Ő','ő','Œ','œ','Ŕ','ŕ',0,0, 'Ř','ř','Ś','ś','Ŝ','ŝ','Ş','ş', */
	/* 0160 */  7, 7, 7, 7, 7, 7,-1,-1, -1,-1, 7, 7, 7, 7, 7, 7, /* 'Š','š','Ţ','ţ','Ť','ť',0,0, 0,0,'Ū','ū','Ŭ','ŭ','Ů','ů', */
	/* 0170 */  7, 7,-1,-1,-1,-1,-1,-1, -1, 7, 7, 7, 7, 7, 7,-1, /* 'Ű','ű',0,0,0,0,0,0, 0,'Ź','ź','Ż','ż','Ž','ž',0, */
	/* 0180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0190 */ -1,-1,-1, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'Ɠ',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 01a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01c0 */ -1,-1, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7, 7,-1, /* 0,0,'ǂ',0,0,0,0,0, 0,0,0,0,0,'Ǎ','ǎ',0, */
	/* 01d0 */  7, 7, 7,-1, 7,-1, 7,-1,  7,-1, 7,-1, 7,-1,-1,-1, /* 'ǐ','Ǒ','ǒ',0,'ǔ',0,'ǖ',0, 'ǘ',0,'ǚ',0,'ǜ',0,0,0, */
	/* 01e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01f0 */ -1,-1,-1,-1,-1,-1,-1,-1,  7, 7,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 'Ǹ','ǹ',0,0,0,'ǽ',0,0, */
	/* 0200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0250 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7,-1, 7,-1, 7, 7, /* 'ɐ','ɑ','ɒ','ɓ','ɔ','ɕ','ɖ','ɗ', 'ɘ','ə','ɚ',0,'ɜ',0,'ɞ','ɟ', */
	/* 0260 */  7, 7,-1,-1, 7, 7, 7, 7,  7,-1,-1,-1, 7, 7, 7, 7, /* 'ɠ','ɡ',0,0,'ɤ','ɥ','ɦ','ɧ', 'ɨ',0,0,0,'ɬ','ɭ','ɮ','ɯ', */
	/* 0270 */  7, 7, 7, 7,-1, 7,-1,-1, -1, 7, 7, 7,-1, 7, 7,-1, /* 'ɰ','ɱ','ɲ','ɳ',0,'ɵ',0,0, 0,'ɹ','ɺ','ɻ',0,'ɽ','ɾ',0, */
	/* 0280 */ -1, 7, 7, 7, 7,-1,-1,-1,  7, 7, 7, 7, 7, 7, 7,-1, /* 0,'ʁ','ʂ','ʃ','ʄ',0,0,0, 'ʈ','ʉ','ʊ','ʋ','ʌ','ʍ','ʎ',0, */
	/* 0290 */  7, 7, 7,-1, 7, 7,-1,-1,  7,-1,-1,-1,-1, 7,-1,-1, /* 'ʐ','ʑ','ʒ',0,'ʔ','ʕ',0,0, 'ʘ',0,0,0,0,'ʝ',0,0, */
	/* 02a0 */ -1, 7, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'ʡ','ʢ',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 02b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02c0 */ -1,-1,-1,-1,-1,-1,-1, 7,  7,-1,-1,-1, 7,-1,-1,-1, /* 0,0,0,0,0,0,0,'ˇ', 'ˈ',0,0,0,'ˌ',0,0,0, */
	/* 02d0 */  7, 7,-1,-1,-1,-1,-1,-1,  7, 7,-1, 7,-1, 7, 7,-1, /* 'ː','ˑ',0,0,0,0,0,0, '˘','˙',0,'˛',0,'˝','˞',0, */
	/* 02e0 */ -1,-1,-1,-1,-1, 7, 7, 7,  7, 7,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'˥','˦','˧', '˨','˩',0,0,0,0,0,0, */
	/* 02f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0300 */  7, 7, 7, 7, 7,-1, 7,-1,  7,-1,-1, 7, 7,-1,-1, 7, /* '̀','́','̂','̃','̄',0,'̆',0, '̈',0,0,'̋','̌',0,0,'̏', */
	/* 0310 */ -1,-1,-1,-1,-1,-1,-1,-1,  7, 7, 7,-1, 7, 7, 7, 7, /* 0,0,0,0,0,0,0,0, '̘','̙','̚',0,'̜','̝','̞','̟', */
	/* 0320 */  7,-1,-1,-1, 7, 7,-1,-1, -1, 7, 7,-1, 7,-1,-1, 7, /* '̠',0,0,0,'̤','̥',0,0, 0,'̩','̪',0,'̬',0,0,'̯', */
	/* 0330 */  7,-1,-1,-1, 7,-1,-1,-1, -1, 7, 7, 7, 7, 7,-1,-1, /* '̰',0,0,0,'̴',0,0,0, 0,'̹','̺','̻','̼','̽',0,0, */
	/* 0340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0360 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'͡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0390 */ -1, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,'Α','Β','Γ','Δ','Ε','Ζ','Η', 'Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο', */
	/* 03a0 */  7, 7,-1, 7, 7, 7, 7, 7,  7, 7,-1,-1,-1,-1,-1,-1, /* 'Π','Ρ',0,'Σ','Τ','Υ','Φ','Χ', 'Ψ','Ω',0,0,0,0,0,0, */
	/* 03b0 */ -1, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,'α','β','γ','δ','ε','ζ','η', 'θ','ι','κ','λ','μ','ν','ξ','ο', */
	/* 03c0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7,-1,-1,-1,-1,-1,-1, /* 'π','ρ','ς','σ','τ','υ','φ','χ', 'ψ','ω',0,0,0,0,0,0, */
	/* 03d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0400 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'Ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0410 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'А','Б','В','Г','Д','Е','Ж','З', 'И','Й','К','Л','М','Н','О','П', */
	/* 0420 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'Р','С','Т','У','Ф','Х','Ц','Ч', 'Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я', */
	/* 0430 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'а','б','в','г','д','е','ж','з', 'и','й','к','л','м','н','о','п', */
	/* 0440 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'р','с','т','у','ф','х','ц','ч', 'ш','щ','ъ','ы','ь','э','ю','я', */
	/* 0450 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'Ḿ','ḿ', */
	/* 1e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f70 */  7, 7, 7, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 'ὰ','ά','ὲ','έ',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2010 */  7,-1,-1, 7, 7, 7, 7,-1,  7, 7,-1,-1, 7, 7,-1,-1, /* '‐',0,0,'–','—','—','‖',0, '‘','’',0,0,'“','”',0,0, */
	/* 2020 */  7, 7, 7,-1,-1, 7, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '†','‡','•',0,0,'‥','…',0, 0,0,0,0,0,0,0,0, */
	/* 2030 */  7,-1, 7, 7,-1,-1,-1,-1, -1,-1,-1, 7, 7,-1, 2, 7, /* '‰',0,'′','″',0,0,0,0, 0,0,0,'※','‼',0,'‾','‿', */
	/* 2040 */ -1,-1, 7,-1,-1,-1,-1, 7,  7, 7,-1,-1,-1,-1,-1,-1, /* 0,0,'⁂',0,0,0,0,'⁇', '⁈','⁉',0,0,0,0,0,0, */
	/* 2050 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'⁑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 7,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'€',0,0,0, */
	/* 20b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2100 */ -1,-1,-1, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,'℃',0,0,0,0, 0,0,0,0,0,0,0,'ℏ', */
	/* 2110 */ -1,-1,-1, 7,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'ℓ',0,0,'№',0, 0,0,0,0,0,0,0,0, */
	/* 2120 */ -1, 7,-1,-1,-1,-1,-1, 7, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,'℡',0,0,0,0,0,'℧', 0,0,0,'Å',0,0,0,0, */
	/* 2130 */ -1,-1,-1,-1,-1, 7,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'ℵ',0,0, 0,0,0,0,0,0,0,0, */
	/* 2140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2150 */ -1,-1,-1, 7, 7, 7,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'⅓','⅔','⅕',0,0, 0,0,0,0,0,0,0,0, */
	/* 2160 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7,-1,-1,-1,-1, /* 'Ⅰ','Ⅱ','Ⅲ','Ⅳ','Ⅴ','Ⅵ','Ⅶ','Ⅷ', 'Ⅸ','Ⅹ','Ⅺ','Ⅻ',0,0,0,0, */
	/* 2170 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7,-1,-1,-1,-1, /* 'ⅰ','ⅱ','ⅲ','ⅳ','ⅴ','ⅵ','ⅶ','ⅷ', 'ⅸ','ⅹ','ⅺ','ⅻ',0,0,0,0, */
	/* 2180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2190 */  7, 7, 7, 7, 7,-1, 7, 7,  7, 7,-1,-1,-1,-1,-1,-1, /* '←','↑','→','↓','↔',0,'↖','↗', '↘','↙',0,0,0,0,0,0, */
	/* 21a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21c0 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'⇄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21d0 */ -1,-1, 7,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'⇒',0,'⇔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21e0 */ -1,-1,-1,-1,-1,-1, 7, 7,  7, 7,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'⇦','⇧', '⇨','⇩',0,0,0,0,0,0, */
	/* 21f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2200 */  7,-1, 7, 7,-1, 7,-1, 7,  7, 7,-1, 7,-1,-1,-1,-1, /* '∀',0,'∂','∃',0,'∅',0,'∇', '∈','∉',0,'∋',0,0,0,0, */
	/* 2210 */ -1,-1, 7, 7,-1,-1,-1,-1, -1,-1, 7,-1,-1, 7, 7, 7, /* 0,0,'−','∓',0,0,0,0, 0,0,'√',0,0,'∝','∞','∟', */
	/* 2220 */  7,-1,-1,-1,-1, 7, 7, 7,  7, 7, 7, 7, 7,-1, 7,-1, /* '∠',0,0,0,0,'∥','∦','∧', '∨','∩','∪','∫','∬',0,'∮',0, */
	/* 2230 */ -1,-1,-1,-1, 7, 7,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,'∴','∵',0,0, 0,0,0,0,0,'∽',0,0, */
	/* 2240 */ -1,-1,-1, 7,-1, 7,-1,-1,  7,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'≃',0,'≅',0,0, '≈',0,0,0,0,0,0,0, */
	/* 2250 */ -1,-1, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'≒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2260 */  7, 7, 7,-1,-1,-1, 7, 7, -1,-1, 7, 7,-1,-1,-1,-1, /* '≠','≡','≢',0,0,0,'≦','≧', 0,0,'≪','≫',0,0,0,0, */
	/* 2270 */ -1,-1,-1,-1,-1,-1, 7, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'≶','≷', 0,0,0,0,0,0,0,0, */
	/* 2280 */ -1,-1, 7, 7, 7, 7, 7, 7, -1,-1, 7, 7,-1,-1,-1,-1, /* 0,0,'⊂','⊃','⊄','⊅','⊆','⊇', 0,0,'⊊','⊋',0,0,0,0, */
	/* 2290 */ -1,-1,-1,-1,-1, 7, 7, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'⊕','⊖','⊗', 0,0,0,0,0,0,0,0, */
	/* 22a0 */ -1,-1,-1,-1,-1, 7,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'⊥',0,0, 0,0,0,0,0,0,0,0, */
	/* 22b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'⊿', */
	/* 22c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 7, 7,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'⋚','⋛',0,0,0,0, */
	/* 22e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2300 */ -1,-1,-1,-1,-1, 7, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'⌅','⌆',0, 0,0,0,0,0,0,0,0, */
	/* 2310 */ -1,-1, 7,-1,-1,-1,-1,-1,  7,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'⌒',0,0,0,0,0, '⌘',0,0,0,0,0,0,0, */
	/* 2320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'⎾','⎿', */
	/* 23c0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7,-1, 7,-1, /* '⏀','⏁','⏂','⏃','⏄','⏅','⏆','⏇', '⏈','⏉','⏊','⏋','⏌',0,'⏎',0, */
	/* 23d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2420 */ -1,-1,-1, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'␣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2460 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '①','②','③','④','⑤','⑥','⑦','⑧', '⑨','⑩','⑪','⑫','⑬','⑭','⑮','⑯', */
	/* 2470 */  7, 7, 7, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '⑰','⑱','⑲','⑳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24d0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'ⓐ','ⓑ','ⓒ','ⓓ','ⓔ','ⓕ','ⓖ','ⓗ', 'ⓘ','ⓙ','ⓚ','ⓛ','ⓜ','ⓝ','ⓞ','ⓟ', */
	/* 24e0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7,-1, 7, 7, 7, 7, 7, /* 'ⓠ','ⓡ','ⓢ','ⓣ','ⓤ','ⓥ','ⓦ','ⓧ', 'ⓨ','ⓩ',0,'⓫','⓬','⓭','⓮','⓯', */
	/* 24f0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7,-1, /* '⓰','⓱','⓲','⓳','⓴','⓵','⓶','⓷', '⓸','⓹','⓺','⓻','⓼','⓽','⓾',0, */
	/* 2500 */  7, 7, 7, 7,-1,-1,-1,-1, -1,-1,-1,-1, 7,-1,-1, 7, /* '─','━','│','┃',0,0,0,0, 0,0,0,0,'┌',0,0,'┏', */
	/* 2510 */  7,-1,-1, 7, 7,-1,-1, 7,  7,-1,-1, 7, 7, 7,-1,-1, /* '┐',0,0,'┓','└',0,0,'┗', '┘',0,0,'┛','├','┝',0,0, */
	/* 2520 */  7,-1,-1, 7, 7, 7,-1,-1,  7,-1,-1, 7, 7,-1,-1, 7, /* '┠',0,0,'┣','┤','┥',0,0, '┨',0,0,'┫','┬',0,0,'┯', */
	/* 2530 */  7,-1,-1, 7, 7,-1,-1, 7,  7,-1,-1, 7, 7,-1,-1, 7, /* '┰',0,0,'┳','┴',0,0,'┷', '┸',0,0,'┻','┼',0,0,'┿', */
	/* 2540 */ -1,-1, 7,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,'╂',0,0,0,0,0, 0,0,0,'╋',0,0,0,0, */
	/* 2550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25a0 */  7, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '■','□',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25b0 */ -1, 7, 7, 7,-1,-1, 7, 7, -1,-1,-1,-1, 7, 7,-1,-1, /* 0,'▱','▲','△',0,0,'▶','▷', 0,0,0,0,'▼','▽',0,0, */
	/* 25c0 */  7, 7,-1,-1,-1,-1, 7, 7, -1, 7,-1, 7,-1,-1, 7, 7, /* '◀','◁',0,0,0,0,'◆','◇', 0,'◉',0,'○',0,0,'◎','●', */
	/* 25d0 */  7, 7, 7, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '◐','◑','◒','◓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25e0 */ -1,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,'◦',0, 0,0,0,0,0,0,0,'◯', */
	/* 25f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2600 */  7, 7, 7, 7,-1, 7, 7,-1, -1,-1,-1,-1,-1,-1, 7,-1, /* '☀','☁','☂','☃',0,'★','☆',0, 0,0,0,0,0,0,'☎',0, */
	/* 2610 */ -1,-1,-1,-1,-1,-1, 7, 7, -1,-1,-1,-1,-1,-1, 7,-1, /* 0,0,0,0,0,0,'☖','☗', 0,0,0,0,0,0,'☞',0, */
	/* 2620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2640 */  7,-1, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '♀',0,'♂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2660 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '♠','♡','♢','♣','♤','♥','♦','♧', '♨','♩','♪','♫','♬','♭','♮','♯', */
	/* 2670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2710 */ -1,-1,-1, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'✓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2750 */ -1,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'❖',0, 0,0,0,0,0,0,0,0, */
	/* 2760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2770 */ -1,-1,-1,-1,-1,-1, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,0,0,0,0,0,'❶','❷', '❸','❹','❺','❻','❼','❽','❾','❿', */
	/* 2780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2930 */ -1,-1,-1,-1, 7, 7,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'⤴','⤵',0,0, 0,0,0,0,0,0,0,0, */
	/* 2940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'⦿', */
	/* 29c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 7, 7,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'⧺','⧻',0,0,0,0, */
	/* 2a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3000 */  7, 7, 7, 7,-1, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '　','、','。','〃',0,'々','〆','〇', '〈','〉','《','》','「','」','『','』', */
	/* 3010 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7,-1,-1, 7, 7,-1, 7, /* '【','】','〒','〓','〔','〕','〖','〗', '〘','〙',0,0,'〜','〝',0,'〟', */
	/* 3020 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '〠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3030 */ -1,-1,-1, 7, 7, 7,-1,-1, -1,-1,-1, 7, 7, 7,-1,-1, /* 0,0,0,'〳','〴','〵',0,0, 0,0,0,'〻','〼','〽',0,0, */
	/* 3040 */ -1, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,'ぁ','あ','ぃ','い','ぅ','う','ぇ', 'え','ぉ','お','か','が','き','ぎ','く', */
	/* 3050 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'ぐ','け','げ','こ','ご','さ','ざ','し', 'じ','す','ず','せ','ぜ','そ','ぞ','た', */
	/* 3060 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'だ','ち','ぢ','っ','つ','づ','て','で', 'と','ど','な','に','ぬ','ね','の','は', */
	/* 3070 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'ば','ぱ','ひ','び','ぴ','ふ','ぶ','ぷ', 'へ','べ','ぺ','ほ','ぼ','ぽ','ま','み', */
	/* 3080 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'む','め','も','ゃ','や','ゅ','ゆ','ょ', 'よ','ら','り','る','れ','ろ','ゎ','わ', */
	/* 3090 */  7, 7, 7, 7, 7, 7, 7,-1, -1,-1,-1, 7, 7, 7, 7, 7, /* 'ゐ','ゑ','を','ん','ゔ','ゕ','ゖ',0, 0,0,0,'゛','゜','ゝ','ゞ','ゟ', */
	/* 30a0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '゠','ァ','ア','ィ','イ','ゥ','ウ','ェ', 'エ','ォ','オ','カ','ガ','キ','ギ','ク', */
	/* 30b0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'グ','ケ','ゲ','コ','ゴ','サ','ザ','シ', 'ジ','ス','ズ','セ','ゼ','ソ','ゾ','タ', */
	/* 30c0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'ダ','チ','ヂ','ッ','ツ','ヅ','テ','デ', 'ト','ド','ナ','ニ','ヌ','ネ','ノ','ハ', */
	/* 30d0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'バ','パ','ヒ','ビ','ピ','フ','ブ','プ', 'ヘ','ベ','ペ','ホ','ボ','ポ','マ','ミ', */
	/* 30e0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'ム','メ','モ','ャ','ヤ','ュ','ユ','ョ', 'ヨ','ラ','リ','ル','レ','ロ','ヮ','ワ', */
	/* 30f0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'ヰ','ヱ','ヲ','ン','ヴ','ヵ','ヶ','ヷ', 'ヸ','ヹ','ヺ','・','ー','ヽ','ヾ','ヿ', */
	/* 3100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31f0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'ㇰ','ㇱ','ㇲ','ㇳ','ㇴ','ㇵ','ㇶ','ㇷ', 'ㇸ','ㇹ','ㇺ','ㇻ','ㇼ','ㇽ','ㇾ','ㇿ', */
	/* 3200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3230 */ -1, 7, 7,-1,-1,-1,-1,-1, -1, 7,-1,-1,-1,-1,-1,-1, /* 0,'㈱','㈲',0,0,0,0,0, 0,'㈹',0,0,0,0,0,0, */
	/* 3240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3250 */ -1, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,'㉑','㉒','㉓','㉔','㉕','㉖','㉗', '㉘','㉙','㉚','㉛','㉜','㉝','㉞','㉟', */
	/* 3260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32a0 */ -1,-1,-1,-1, 7, 7, 7, 7,  7,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'㊤','㊥','㊦','㊧', '㊨',0,0,0,0,0,0,0, */
	/* 32b0 */ -1, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,'㊱','㊲','㊳','㊴','㊵','㊶','㊷', '㊸','㊹','㊺','㊻','㊼','㊽','㊾','㊿', */
	/* 32c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32d0 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '㋐','㋑','㋒','㋓','㋔','㋕','㋖','㋗', '㋘','㋙','㋚','㋛','㋜','㋝','㋞','㋟', */
	/* 32e0 */  7, 7, 7, 7,-1, 7,-1,-1, -1, 7,-1,-1, 7, 7,-1,-1, /* '㋠','㋡','㋢','㋣',0,'㋥',0,0, 0,'㋩',0,0,'㋬','㋭',0,0, */
	/* 32f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'㋺',0,0,0,0,0, */
	/* 3300 */ -1,-1,-1, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,'㌃',0,0,0,0, 0,0,0,0,0,'㌍',0,0, */
	/* 3310 */ -1,-1,-1,-1, 7,-1,-1,-1,  7,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'㌔',0,0,0, '㌘',0,0,0,0,0,0,0, */
	/* 3320 */ -1,-1, 7, 7,-1,-1, 7, 7, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,'㌢','㌣',0,0,'㌦','㌧', 0,0,0,'㌫',0,0,0,0, */
	/* 3330 */ -1,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,0,0,0,0,'㌶',0, 0,0,0,'㌻',0,0,0,0, */
	/* 3340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 7, 7,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'㍉','㍊',0,0,'㍍',0,0, */
	/* 3350 */ -1, 7,-1,-1,-1,-1,-1, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'㍑',0,0,0,0,0,'㍗', 0,0,0,0,0,0,0,0, */
	/* 3360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7, 7, 7, 7,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'㍻','㍼','㍽','㍾',0, */
	/* 3380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㎎','㎏', */
	/* 3390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 7, 7, 7,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㎜','㎝','㎞',0, */
	/* 33a0 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'㎡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 33b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33c0 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1, 7,-1, 7,-1,-1, /* 0,0,0,0,'㏄',0,0,0, 0,0,0,'㏋',0,'㏍',0,0, */
	/* 33d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3400 */ -1,-1, 7,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'㐂',0,0,0,'㐆',0, 0,0,0,0,0,0,0,0, */
	/* 3410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㐬',0,'㐮',0, */
	/* 3430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3460 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '㑨',0,'㑪',0,0,0,0,0, */
	/* 3470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3490 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'㒒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 34a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34b0 */ -1,-1,-1,-1,-1, 7,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,'㒵',0,0, 0,0,0,0,'㒼',0,0,0, */
	/* 34c0 */ -1, 9,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'㓁',0,0,0,0,0,'㓇', 0,0,0,0,0,0,0,0, */
	/* 34d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'㓛',0,0,0,0, */
	/* 34e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㔟', */
	/* 3520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'㕝','㕞',0, */
	/* 3560 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,'㕣',0,0,0,0, 0,0,0,0,0,0,'㕮',0, */
	/* 3570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35a0 */ -1,-1,-1,-1,-1,-1, 9,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'㖦',0, '㖨',0,0,0,0,0,0,0, */
	/* 35b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35c0 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'㗅',0,0, 0,0,0,0,0,0,0,0, */
	/* 35d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'㗚',0,0,0,0,0, */
	/* 35e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35f0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'㗴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3600 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'㘅',0,0, 0,0,0,0,0,0,0,0, */
	/* 3610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'㙊',0,0,0,0,0, */
	/* 3650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3690 */ -1, 9,-1,-1,-1,-1, 9,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,'㚑',0,0,0,0,'㚖',0, 0,'㚙',0,0,0,0,0,0, */
	/* 36a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㛏', */
	/* 36d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3760 */ -1, 9, 9,-1,-1,-1,-1,-1, -1,-1,-1, 9, 9,-1,-1,-1, /* 0,'㝡','㝢',0,0,0,0,0, 0,0,0,'㝫','㝬',0,0,0, */
	/* 3770 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'㝵',0,0, 0,0,0,0,0,0,0,0, */
	/* 3780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'㞍',0,0, */
	/* 3790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37c0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'㟁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 37d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37e0 */ -1,-1, 7,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'㟢',0,0,0,0,0, '㟨',0,0,0,0,0,0,0, */
	/* 37f0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,'㟴',0,0,0, 0,0,0,0,0,'㟽',0,0, */
	/* 3800 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '㠀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㠯', */
	/* 3830 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'㠶',0, 0,0,0,0,0,0,0,0, */
	/* 3840 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '㡀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㡜',0,0,0, */
	/* 3860 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'㡡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'㣺',0,0,0,0,0, */
	/* 3900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3910 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'㤗', 0,0,'㤚',0,0,0,0,0, */
	/* 3920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㥯', */
	/* 3970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㩮',0, */
	/* 3a70 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'㩳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ad0 */ -1,-1,-1,-1,-1,-1, 9, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'㫖','㫗', 0,0,0,0,0,0,0,0, */
	/* 3ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'㫪',0,0,0,0,0, */
	/* 3af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㬎',0, */
	/* 3b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'㬚',0,'㬜',0,0,0, */
	/* 3b20 */ -1,-1, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'㬢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'㭭',0,0, */
	/* 3b70 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'㭷', 0,0,0,0,0,0,0,0, */
	/* 3b80 */ -1,-1,-1,-1,-1,-1,-1, 9,  9,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,'㮇', '㮈',0,0,0,0,'㮍',0,0, */
	/* 3b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ba0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'㮤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3bb0 */ -1,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'㮶',0, 0,0,0,0,0,0,0,0, */
	/* 3bc0 */ -1,-1,-1, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,'㯃',0,0,0,0, 0,0,0,0,0,'㯍',0,0, */
	/* 3bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bf0 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '㯰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㰏', */
	/* 3c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c20 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'㰦',0, 0,0,0,0,0,0,0,0, */
	/* 3c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cc0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'㳃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3cd0 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'㳒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d10 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,'㴑',0,0,0,0,0,0, 0,0,0,0,0,0,'㴞',0, */
	/* 3d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d60 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'㵤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'㶚',0,0,0,0,0, */
	/* 3da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3dc0 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '㷀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3dd0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'㷔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e00 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'㸅',0,0, 0,0,0,0,0,0,0,0, */
	/* 3e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㸿', */
	/* 3e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e60 */  9,-1,-1,-1,-1,-1, 9,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* '㹠',0,0,0,0,0,'㹦',0, '㹨',0,0,0,0,0,0,0, */
	/* 3e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e80 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'㺃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3e90 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'㺔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f50 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'㽗', 0,0,0,0,0,0,0,0, */
	/* 3f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f70 */ -1,-1, 7,-1,-1, 9,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'㽲',0,0,'㽵',0,'㽷', 0,0,0,0,0,0,0,0, */
	/* 3f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㾮',0, */
	/* 3fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'㿉',0,0,0,0,0,0, */
	/* 3fd0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'㿗', 0,0,0,0,0,0,0,0, */
	/* 3fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'䀹',0,0,0,0,0,0, */
	/* 4040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4050 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '䁘',0,0,0,0,0,0,0, */
	/* 4060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4090 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'䂓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 40a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4100 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'䄅',0,0, 0,0,0,0,0,0,0,0, */
	/* 4110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4140 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, '䅈',0,0,0,0,0,0,'䅏', */
	/* 4150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4160 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'䅣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41b0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,'䆴',0,0,0, 0,0,0,0,0,0,0,'䆿', */
	/* 41c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41e0 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,'䇦',0, 0,0,0,0,0,0,'䇮',0, */
	/* 41f0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'䇳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4200 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,'䈇', 0,0,0,0,0,0,'䈎',0, */
	/* 4210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4260 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'䉤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42c0 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'䋆',0, 0,0,0,0,0,0,0,0, */
	/* 42d0 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,'䋖',0, 0,0,0,0,0,'䋝',0,0, */
	/* 42e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4300 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'䌂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'䌫',0,0,0,0, */
	/* 4330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4340 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'䍃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'䏮',0, */
	/* 43f0 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '䏰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4400 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '䐈',0,0,0,0,0,0,0, */
	/* 4410 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,'䐗', 0,0,0,0,'䐜',0,0,0, */
	/* 4420 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'䐢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4450 */ -1,-1,-1, 7,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,0,'䑓',0,0,0,0, 0,0,0,'䑛',0,0,0,0, */
	/* 4460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4470 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'䑶',0, 0,0,'䑺',0,0,0,0,0, */
	/* 4480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4490 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'䒑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 44a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44b0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,'䒳',0,0,0,0, 0,0,0,0,0,0,'䒾',0, */
	/* 44c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44d0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'䓔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 44e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4500 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, '䔈',0,0,0,0,'䔍',0,0, */
	/* 4510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4520 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'䔥',0,0, 0,0,0,0,0,0,0,0, */
	/* 4530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4540 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'䕃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'䖝',0,0, */
	/* 45a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45b0 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '䖸',0,0,0,0,0,0,0, */
	/* 45c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45e0 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'䗥',0,0, 0,0,'䗪',0,0,0,0,0, */
	/* 45f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'䘏', */
	/* 4610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4640 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'䙁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4660 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'䙥',0,0, 0,0,0,0,0,0,0,0, */
	/* 4670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46a0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,'䚡',0,0,0,0,0,0, 0,0,0,0,0,0,0,'䚯', */
	/* 46b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'䜌',0,0,0, */
	/* 4710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4760 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'䝤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'䟽',0,0, */
	/* 4800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4810 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'䠖',0, 0,0,0,0,0,0,0,0, */
	/* 4820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4840 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,'䡄',0,0,0, 0,0,0,0,0,0,'䡎',0, */
	/* 4850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48b0 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'䢵',0,0, 0,0,0,0,0,0,0,0, */
	/* 48c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49b0 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '䦰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 49c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49e0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'䧧', 0,0,0,0,0,0,0,0, */
	/* 49f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'䧺',0,0,0,0,0, */
	/* 4a00 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'䨄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'䨩',0,0,0,0,0,0, */
	/* 4a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'䪼',0,0,0, */
	/* 4ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'䬻',0,0,0,0, */
	/* 4b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bc0 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,'䯂',0,0,0,0,0, 0,0,'䯊',0,0,0,0,0, */
	/* 4bd0 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'䯒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4be0 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '䯨',0,0,0,0,0,0,0, */
	/* 4bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c10 */ -1,-1,-1,-1,-1,-1,-1, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'䰗', 0,0,0,0,0,0,0,0, */
	/* 4c20 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '䰠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cc0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'䳄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4cd0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'䳑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d00 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'䴇', 0,0,0,0,0,0,0,0, */
	/* 4d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d70 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'䵷', 0,0,0,0,0,0,0,0, */
	/* 4d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4e00 */  7, 7, 9, 7,-1,-1,-1, 7,  7, 7, 7, 7,-1, 7, 7, 9, /* '一','丁','丂','七',0,0,0,'万', '丈','三','上','下',0,'不','与','丏', */
	/* 4e10 */  7, 7, 9,-1, 7, 7, 7, 7,  7, 7,-1,-1,-1,-1, 7,-1, /* '丐','丑','丒',0,'且','丕','世','丗', '丘','丙',0,0,0,0,'丞',0, */
	/* 4e20 */ -1, 7,-1,-1,-1,-1, 7,-1,  7, 9, 7, 9, 9, 7, 9, 7, /* 0,'両',0,0,0,0,'並',0, '丨','丩','个','丫','丬','中','丮','丯', */
	/* 4e30 */  7, 7, 7,-1,-1,-1, 7,-1,  7, 7,-1, 7, 7,-1,-1, 7, /* '丰','丱','串',0,0,0,'丶',0, '丸','丹',0,'主','丼',0,0,'丿', */
	/* 4e40 */  9,-1, 7, 7,-1, 7,-1, 9,  9,-1,-1, 7,-1, 7, 7, 7, /* '乀',0,'乂','乃',0,'久',0,'乇', '么',0,0,'之',0,'乍','乎','乏', */
	/* 4e50 */ -1, 9,-1,-1,-1, 7, 7, 7,  7, 7, 9,-1,-1, 7, 7, 7, /* 0,'乑',0,0,0,'乕','乖','乗', '乘','乙','乚',0,0,'九','乞','也', */
	/* 4e60 */ -1,-1, 7,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,'乢',0,0,0,0,0, 0,'乩',0,0,0,0,0,0, */
	/* 4e70 */ -1, 7,-1, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 7,-1, /* 0,'乱',0,'乳',0,0,0,0, 0,0,0,0,0,0,'乾',0, */
	/* 4e80 */  7,-1, 7,-1,-1, 7, 7,-1,  7, 7, 7, 7, 7, 7, 7,-1, /* '亀',0,'亂',0,0,'亅','了',0, '予','争','亊','事','二','亍','于',0, */
	/* 4e90 */ -1, 7, 7,-1, 7, 7,-1,-1,  7, 7,-1, 7, 7, 9, 7, 7, /* 0,'云','互',0,'五','井',0,0, '亘','亙',0,'些','亜','亝','亞','亟', */
	/* 4ea0 */  7, 7, 7,-1, 7, 7, 7,-1,  7,-1,-1, 7, 7, 7, 7,-1, /* '亠','亡','亢',0,'交','亥','亦',0, '亨',0,0,'享','京','亭','亮',0, */
	/* 4eb0 */  7,-1,-1, 7,-1,-1, 7,-1, -1, 9, 7, 9, 9,-1,-1,-1, /* '亰',0,0,'亳',0,0,'亶',0, 0,'亹','人','亻','亼',0,0,0, */
	/* 4ec0 */  7, 7, 7, 9, 7,-1, 7, 7,  9,-1, 7, 7,-1, 7, 7, 7, /* '什','仁','仂','仃','仄',0,'仆','仇', '仈',0,'今','介',0,'仍','从','仏', */
	/* 4ed0 */  9,-1,-1,-1, 7, 7, 7, 7,  7, 7, 9,-1,-1, 7, 7, 7, /* '仐',0,0,0,'仔','仕','他','仗', '付','仙','仚',0,0,'仝','仞','仟', */
	/* 4ee0 */ -1, 7,-1, 7, 7, 7,-1,-1, -1,-1,-1, 9,-1, 7, 7,-1, /* 0,'仡',0,'代','令','以',0,0, 0,0,0,'仫',0,'仭','仮',0, */
	/* 4ef0 */  7, 9, 7,-1,-1, 9, 7, 7, -1,-1,-1, 7,-1, 7,-1, 7, /* '仰','仱','仲',0,0,'仵','件','价', 0,0,0,'任',0,'份',0,'仿', */
	/* 4f00 */  9, 7,-1, 7,-1,-1,-1,-1, -1, 7, 7, 7,-1, 7, 7, 7, /* '伀','企',0,'伃',0,0,0,0, 0,'伉','伊','伋',0,'伍','伎','伏', */
	/* 4f10 */  7, 7,-1,-1,-1,-1, 9,-1, -1,-1, 7,-1, 7, 7,-1,-1, /* '伐','休',0,0,0,0,'伖',0, 0,0,'会',0,'伜','伝',0,0, */
	/* 4f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'伯', */
	/* 4f30 */  7,-1,-1,-1, 7,-1, 7, 9,  7,-1, 7,-1, 7, 7, 9,-1, /* '估',0,0,0,'伴',0,'伶','伷', '伸',0,'伺',0,'似','伽','伾',0, */
	/* 4f40 */ -1,-1,-1, 7,-1,-1, 7, 7,  7, 7,-1,-1,-1, 7, 7, 7, /* 0,0,0,'佃',0,0,'但','佇', '佈','佉',0,0,0,'位','低','住', */
	/* 4f50 */  7, 7,-1, 7, 9, 7, 7, 7,  9, 7, 7, 7, 7, 7, 7, 7, /* '佐','佑',0,'体','佔','何','佖','佗', '佘','余','佚','佛','作','佝','佞','佟', */
	/* 4f60 */  7,-1,-1,-1, 9,-1,-1,-1, -1, 7, 7,-1, 7,-1,-1, 7, /* '你',0,0,0,'佤',0,0,0, 0,'佩','佪',0,'佬',0,0,'佯', */
	/* 4f70 */  7,-1,-1, 7,-1, 7, 7, 9,  9,-1, 9, 7, 7, 9, 7, 7, /* '佰',0,0,'佳',0,'併','佶','佷', '佸',0,'佺','佻','佼','佽','佾','使', */
	/* 4f80 */ -1,-1, 9, 7,-1, 9, 7,-1,  7,-1, 7, 7,-1, 7,-1, 7, /* 0,0,'侂','侃',0,'侅','來',0, '侈',0,'侊','例',0,'侍',0,'侏', */
	/* 4f90 */ -1, 7, 9,-1, 7,-1, 7, 7,  7,-1, 9, 7,-1, 7,-1,-1, /* 0,'侑','侒',0,'侔',0,'侖','侗', '侘',0,'侚','供',0,'依',0,0, */
	/* 4fa0 */  7, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1, 7, 7, 7, /* '侠','価',0,0,0,0,0,0, 0,0,0,'侫',0,'侭','侮','侯', */
	/* 4fb0 */ -1,-1, 9,-1,-1, 7, 7,-1, -1,-1,-1,-1,-1,-1, 9, 7, /* 0,0,'侲',0,0,'侵','侶',0, 0,0,0,0,0,0,'侾','便', */
	/* 4fc0 */ -1,-1, 7, 7, 7, 9,-1,-1, -1, 7, 7, 9,-1,-1, 7, 9, /* 0,0,'係','促','俄','俅',0,0, 0,'俉','俊','俋',0,0,'俎','俏', */
	/* 4fd0 */  7, 7, 9,-1, 7,-1,-1, 7,  7,-1, 7, 7,-1, 7,-1, 7, /* '俐','俑','俒',0,'俔',0,0,'俗', '俘',0,'俚','俛',0,'保',0,'俟', */
	/* 4fe0 */  7, 7,-1, 7, 7, 7, 9,-1, -1,-1,-1,-1,-1,-1, 7, 7, /* '俠','信',0,'俣','俤','俥','俦',0, 0,0,0,0,0,0,'修','俯', */
	/* 4ff0 */ -1,-1, 9, 7,-1, 7, 7,-1,  7,-1, 7,-1,-1,-1, 7,-1, /* 0,0,'俲','俳',0,'俵','俶',0, '俸',0,'俺',0,0,0,'俾',0, */
	/* 5000 */  9, 7, 7,-1,-1, 7, 7,-1, -1, 7,-1, 7,-1, 7, 7, 7, /* '倀','倁','倂',0,0,'倅','倆',0, 0,'倉',0,'個',0,'倍','倎','倏', */
	/* 5010 */  9, 7, 7, 9, 7,-1, 7,-1,  7, 7, 7,-1, 9,-1, 9, 7, /* '倐','們','倒','倓','倔',0,'倖',0, '倘','候','倚',0,'倜',0,'倞','借', */
	/* 5020 */ -1, 7, 9, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7,-1, /* 0,'倡','倢','倣','値','倥','倦','倧', '倨','倩','倪','倫','倬','倭','倮',0, */
	/* 5030 */ -1,-1,-1,-1,-1,-1, 7,-1, -1, 7,-1, 7,-1,-1,-1,-1, /* 0,0,0,0,0,0,'倶',0, 0,'倹',0,'倻',0,0,0,0, */
	/* 5040 */  7, 7, 9, 7,-1,-1, 9, 7,  7, 7,-1,-1,-1,-1, 9, 7, /* '偀','偁','偂','偃',0,0,'偆','假', '偈','偉',0,0,0,0,'偎','偏', */
	/* 5050 */  7,-1,-1, 9,-1, 7, 7, 9, -1,-1, 7,-1, 7,-1,-1,-1, /* '偐',0,0,'偓',0,'偕','偖','偗', 0,0,'做',0,'停',0,0,0, */
	/* 5060 */ -1,-1,-1, 9,-1, 7, 9,-1, -1,-1, 9,-1, 7,-1,-1,-1, /* 0,0,0,'偣',0,'健','偦',0, 0,0,'偪',0,'偬',0,0,0, */
	/* 5070 */  9,-1, 7,-1, 7, 7, 7,-1,  7,-1,-1,-1,-1, 7,-1,-1, /* '偰',0,'偲',0,'側','偵','偶',0, '偸',0,0,0,0,'偽',0,0, */
	/* 5080 */  7,-1,-1,-1,-1, 7,-1,-1,  9,-1,-1,-1,-1, 7,-1,-1, /* '傀',0,0,0,0,'傅',0,0, '傈',0,0,0,0,'傍',0,0, */
	/* 5090 */ -1, 7, 9, 9, 7, 9, 9,-1,  7, 7, 7,-1, 9,-1,-1,-1, /* 0,'傑','傒','傓','傔','傕','傖',0, '傘','備','傚',0,'傜',0,0,0, */
	/* 50a0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1, 9,-1, 7, 7,-1,-1, /* 0,0,0,'傣',0,0,0,0, 0,0,'傪',0,'催','傭',0,0, */
	/* 50b0 */ -1, 9, 7, 7, 7, 7,-1, 7, -1,-1, 9, 9,-1,-1, 7,-1, /* 0,'傱','傲','傳','傴','債',0,'傷', 0,0,'傺','傻',0,0,'傾',0, */
	/* 50c0 */ -1,-1, 7,-1, 9, 7,-1, 9, -1, 7, 7,-1, 7, 7, 9, 7, /* 0,0,'僂',0,'僄','僅',0,'僇', 0,'僉','僊',0,'僌','働','僎','像', */
	/* 50d0 */  7, 7,-1,-1, 9, 7, 7,-1, -1, 9, 7,-1,-1,-1, 7,-1, /* '僐','僑',0,0,'僔','僕','僖',0, 0,'僙','僚',0,0,0,'僞',0, */
	/* 50e0 */ -1, 9,-1, 7,-1, 7, 7, 7, -1, 9,-1,-1,-1, 7, 7,-1, /* 0,'僡',0,'僣',0,'僥','僦','僧', 0,'僩',0,0,0,'僭','僮',0, */
	/* 50f0 */ -1,-1, 7, 9,-1, 7,-1,-1, -1, 7,-1, 7,-1,-1,-1,-1, /* 0,0,'僲','僳',0,'僵',0,0, 0,'價',0,'僻',0,0,0,0, */
	/* 5100 */  7, 7, 7, 7, 7,-1, 7,-1,  9, 7,-1, 7,-1,-1,-1,-1, /* '儀','儁','儂','儃','億',0,'儆',0, '儈','儉',0,'儋',0,0,0,0, */
	/* 5110 */ -1,-1, 7,-1, 7, 7, 7, 9,  7,-1, 7, 9,-1,-1, 7, 7, /* 0,0,'儒',0,'儔','儕','儖','儗', '儘',0,'儚','儛',0,0,'儞','償', */
	/* 5120 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,'儡',0,0,0,0,0,0, 0,0,'優',0,0,0,0,0, */
	/* 5130 */ -1,-1, 7,-1,-1, 7,-1, 7, -1,-1, 7, 7, 7,-1,-1, 7, /* 0,0,'儲',0,0,'儵',0,'儷', 0,0,'儺','儻','儼',0,0,'儿', */
	/* 5140 */  7, 7,-1, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7,-1, /* '兀','允',0,'元','兄','充','兆','兇', '先','光','兊','克','兌','免','兎',0, */
	/* 5150 */  7,-1, 7,-1, 7, 7,-1, 7, -1,-1, 7,-1, 7,-1,-1,-1, /* '児',0,'兒',0,'兔','兕',0,'兗', 0,0,'党',0,'兜',0,0,0, */
	/* 5160 */  9,-1, 7,-1,-1, 7,-1,-1,  7, 7, 7, 7, 7, 7, 7,-1, /* '兠',0,'兢',0,0,'入',0,0, '全','兩','兪','八','公','六','兮',0, */
	/* 5170 */ -1, 7,-1, 9,-1, 7, 7, 7,  7,-1,-1, 9, 7,-1,-1,-1, /* 0,'共',0,'关',0,'兵','其','具', '典',0,0,'养','兼',0,0,0, */
	/* 5180 */  7,-1, 7, 9,-1, 7, 7,-1, -1, 7, 7, 9, 7, 7,-1, 7, /* '冀',0,'冂','冃',0,'内','円',0, 0,'冉','冊','冋','册','再',0,'冏', */
	/* 5190 */  7, 7, 7, 7,-1, 7, 7, 7,  9, 7,-1,-1,-1, 7,-1,-1, /* '冐','冑','冒','冓',0,'冕','冖','冗', '冘','写',0,0,0,'冝',0,0, */
	/* 51a0 */  7,-1, 7, 9, 7, 7, 7,-1,  7, 7, 7, 7, 7, 9,-1,-1, /* '冠',0,'冢','冣','冤','冥','冦',0, '冨','冩','冪','冫','冬','冭',0,0, */
	/* 51b0 */  7, 7, 7, 7, 7, 7, 7, 7, -1,-1,-1,-1, 9, 7,-1,-1, /* '冰','冱','冲','决','冴','况','冶','冷', 0,0,0,0,'冼','冽',0,0, */
	/* 51c0 */ -1,-1,-1, 7, 7, 7, 7,-1, -1, 7, 7, 7, 7, 7,-1,-1, /* 0,0,0,'凃','凄','凅','准',0, 0,'凉','凊','凋','凌','凍',0,0, */
	/* 51d0 */ -1,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1, 7, 7, 7, 7,-1, /* 0,0,0,0,0,0,'凖',0, 0,0,0,'凛','凜','凝','凞',0, */
	/* 51e0 */  7, 7, 7,-1,-1,-1, 7, 7, -1, 7, 7,-1,-1, 7, 7,-1, /* '几','凡','凢',0,0,0,'処','凧', 0,'凩','凪',0,0,'凭','凮',0, */
	/* 51f0 */  7, 7,-1, 9, 9, 7, 7,-1,  7, 7, 7,-1,-1, 7, 7,-1, /* '凰','凱',0,'凳','凴','凵','凶',0, '凸','凹','出',0,0,'函','凾',0, */
	/* 5200 */  7, 7, 9, 7, 7,-1, 7, 7,  7,-1, 7, 7,-1,-1, 7,-1, /* '刀','刁','刂','刃','刄',0,'分','切', '刈',0,'刊','刋',0,0,'刎',0, */
	/* 5210 */ -1, 7, 9, 7, 7, 7, 9, 7, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,'刑','划','刓','刔','刕','刖','列', 0,0,0,0,0,'初',0,0, */
	/* 5220 */ -1,-1,-1,-1, 7, 7,-1, 7, -1, 7, 7,-1,-1,-1, 7,-1, /* 0,0,0,0,'判','別',0,'刧', 0,'利','刪',0,0,0,'刮',0, */
	/* 5230 */  7,-1,-1, 7,-1,-1, 7, 7,  7, 7, 7, 7,-1,-1,-1,-1, /* '到',0,0,'刳',0,0,'制','刷', '券','刹','刺','刻',0,0,0,0, */
	/* 5240 */ -1,-1,-1, 7, 7,-1,-1, 7, -1, 7, 7, 7, 7, 7,-1, 7, /* 0,0,0,'剃','剄',0,0,'則', 0,'剉','削','剋','剌','前',0,'剏', */
	/* 5250 */ -1,-1,-1,-1, 7, 9, 7, 7, -1,-1,-1, 7, 9,-1, 7,-1, /* 0,0,0,0,'剔','剕','剖','剗', 0,0,0,'剛','剜',0,'剞',0, */
	/* 5260 */ -1, 7,-1, 7, 7, 7,-1,-1, -1, 7, 7,-1, 9,-1,-1, 7, /* 0,'剡',0,'剣','剤','剥',0,0, 0,'剩','剪',0,'剬',0,0,'副', */
	/* 5270 */  7, 7, 7, 7, 7, 7,-1, 9, -1,-1,-1,-1,-1, 7,-1, 7, /* '剰','剱','割','剳','剴','創',0,'剷', 0,0,0,0,0,'剽',0,'剿', */
	/* 5280 */ -1,-1, 9, 7, 9,-1,-1, 7,  7, 7,-1,-1,-1, 7,-1,-1, /* 0,0,'劂','劃','劄',0,0,'劇', '劈','劉',0,0,0,'劍',0,0, */
	/* 5290 */ -1, 7, 7, 7, 7,-1,-1,-1,  9,-1,-1, 7,-1,-1,-1, 7, /* 0,'劑','劒','劓','劔',0,0,0, '劘',0,0,'力',0,0,0,'功', */
	/* 52a0 */  7,-1,-1, 7, 9,-1, 9,-1, -1, 7, 7, 7, 7, 7,-1, 9, /* '加',0,0,'劣','劤',0,'劦',0, 0,'助','努','劫','劬','劭',0,'劯', */
	/* 52b0 */ -1, 7,-1,-1, 7, 7,-1,-1, -1, 7, 9, 9, 7,-1, 7,-1, /* 0,'励',0,0,'労','劵',0,0, 0,'効','劺','劻','劼',0,'劾',0, */
	/* 52c0 */ -1, 7,-1, 7,-1, 7,-1, 7,  7, 7, 9,-1, 7, 7,-1,-1, /* 0,'勁',0,'勃',0,'勅',0,'勇', '勈','勉','勊',0,'勌','勍',0,0, */
	/* 52d0 */  7, 9, 7,-1,-1, 7, 7, 7,  7, 7,-1, 7,-1, 7, 7, 7, /* '勐','勑','勒',0,0,'動','勖','勗', '勘','務',0,'勛',0,'勝','勞','募', */
	/* 52e0 */  7,-1, 7, 7, 7,-1, 7, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* '勠',0,'勢','勣','勤',0,'勦','勧', 0,0,0,0,0,0,0,0, */
	/* 52f0 */  7,-1, 7, 7,-1, 7,-1, 9,  7, 7, 7, 7,-1,-1, 7, 7, /* '勰',0,'勲','勳',0,'勵',0,'勷', '勸','勹','勺','勻',0,0,'勾','勿', */
	/* 5300 */  7, 7, 7,-1,-1, 7, 7, 7,  7,-1, 9, 9,-1, 7,-1, 7, /* '匀','匁','匂',0,0,'包','匆','匇', '匈',0,'匊','匋',0,'匍',0,'匏', */
	/* 5310 */  7,-1,-1,-1,-1, 7, 7, 7, -1, 7, 7,-1, 7, 7,-1,-1, /* '匐',0,0,0,0,'匕','化','北', 0,'匙','匚',0,'匜','匝',0,0, */
	/* 5320 */  7, 7,-1, 7, 9,-1,-1,-1, -1,-1, 7,-1,-1,-1,-1, 7, /* '匠','匡',0,'匣','匤',0,0,0, 0,0,'匪',0,0,0,0,'匯', */
	/* 5330 */ -1, 7,-1, 7,-1, 9,-1,-1,  7, 7, 7, 7,-1,-1, 9, 7, /* 0,'匱',0,'匳',0,'匵',0,0, '匸','匹','区','医',0,0,'匾','匿', */
	/* 5340 */  7, 7, 9, 7,-1, 7, 7, 7,  7, 7, 7,-1,-1, 7,-1,-1, /* '區','十','卂','千',0,'卅','卆','升', '午','卉','半',0,0,'卍',0,0, */
	/* 5350 */ -1, 7, 7, 7, 7,-1,-1, 7,  7,-1, 7,-1, 7,-1, 7,-1, /* 0,'卑','卒','卓','協',0,0,'南', '単',0,'博',0,'卜',0,'卞',0, */
	/* 5360 */  7, 7,-1, 7,-1,-1, 7, 9, -1, 7,-1,-1, 9,-1, 7, 7, /* '占','卡',0,'卣',0,0,'卦','卧', 0,'卩',0,0,'卬',0,'卮','卯', */
	/* 5370 */  7, 7,-1, 7, 7, 7,-1, 7,  7,-1, 9, 7,-1, 7,-1, 7, /* '印','危',0,'即','却','卵',0,'卷', '卸',0,'卺','卻',0,'卽',0,'卿', */
	/* 5380 */ -1,-1, 7,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'厂',0,'厄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5390 */ -1,-1,-1, 7,-1,-1, 7,-1,  7,-1, 7,-1,-1, 7,-1, 7, /* 0,0,0,'厓',0,0,'厖',0, '厘',0,'厚',0,0,'厝',0,'原', */
	/* 53a0 */  7,-1,-1,-1, 9, 7, 7,-1,  7, 7,-1,-1,-1, 7, 7,-1, /* '厠',0,0,0,'厤','厥','厦',0, '厨','厩',0,0,0,'厭','厮',0, */
	/* 53b0 */  7,-1, 7, 7, 9,-1, 7, 9, -1,-1,-1, 7,-1,-1,-1,-1, /* '厰',0,'厲','厳','厴',0,'厶','厷', 0,0,0,'去',0,0,0,0, */
	/* 53c0 */  9,-1, 7, 7,-1,-1,-1,-1,  7, 7, 7, 7, 7, 7, 7,-1, /* '叀',0,'参','參',0,0,0,0, '又','叉','及','友','双','反','収',0, */
	/* 53d0 */ -1,-1,-1,-1, 7, 9, 7, 7, -1, 7, 9, 7,-1,-1,-1, 7, /* 0,0,0,0,'叔','叕','取','受', 0,'叙','叚','叛',0,0,0,'叟', */
	/* 53e0 */ -1, 7, 7, 7, 7, 7,-1,-1,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,'叡','叢','口','古','句',0,0, '叨','叩','只','叫','召','叭','叮','可', */
	/* 53f0 */  7, 7, 7, 7, 9, 9, 7, 7,  7,-1, 7,-1,-1,-1,-1,-1, /* '台','叱','史','右','叴','叵','叶','号', '司',0,'叺',0,0,0,0,0, */
	/* 5400 */ -1, 7,-1, 7, 7,-1,-1,-1,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,'吁',0,'吃','各',0,0,0, '合','吉','吊','吋','同','名','后','吏', */
	/* 5410 */  7, 7, 7,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1, 7,-1, 7, /* '吐','向','吒',0,0,0,0,0, 0,0,0,'君',0,'吝',0,'吟', */
	/* 5420 */  7,-1,-1,-1, 9,-1, 7, 7,  9, 7,-1, 7, 7, 7, 7,-1, /* '吠',0,0,0,'吤',0,'否','吧', '吨','吩',0,'含','听','吭','吮',0, */
	/* 5430 */ -1,-1,-1,-1,-1,-1, 7,-1,  7, 7,-1, 7, 7, 7, 7,-1, /* 0,0,0,0,0,0,'吶',0, '吸','吹',0,'吻','吼','吽','吾',0, */
	/* 5440 */  7,-1, 7, 9,-1,-1, 7,-1,  7, 7, 7,-1,-1, 7, 7,-1, /* '呀',0,'呂','呃',0,0,'呆',0, '呈','呉','告',0,0,'呍','呎',0, */
	/* 5450 */ -1, 7,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,'呑',0,0,0,'呕',0,0, 0,0,0,0,0,0,0,'呟', */
	/* 5460 */ -1,-1, 9,-1,-1,-1, 9,-1,  7,-1, 7, 7, 9,-1,-1,-1, /* 0,0,'呢',0,0,0,'呦',0, '周',0,'呪','呫','呬',0,0,0, */
	/* 5470 */  7, 7,-1, 7, 7, 7, 7, 7, -1,-1,-1, 7, 7, 7,-1, 7, /* '呰','呱',0,'味','呴','呵','呶','呷', 0,0,0,'呻','呼','命',0,'呿', */
	/* 5480 */  7,-1,-1,-1, 7,-1, 7,-1,  7,-1, 9, 7, 7, 9, 7, 7, /* '咀',0,0,0,'咄',0,'咆',0, '咈',0,'咊','咋','和','咍','咎','咏', */
	/* 5490 */  7,-1, 7,-1,-1, 9, 7,-1, -1,-1,-1,-1, 7,-1,-1,-1, /* '咐',0,'咒',0,0,'咕','咖',0, 0,0,0,0,'咜',0,0,0, */
	/* 54a0 */  9, 7, 7,-1, 7, 7, 9,-1,  7, 7,-1, 7, 7, 9, 9, 7, /* '咠','咡','咢',0,'咤','咥','咦',0, '咨','咩',0,'咫','咬','咭','咮','咯', */
	/* 54b0 */ -1,-1, 7, 7,-1,-1,-1, 9,  7,-1, 9,-1, 7, 7, 7, 9, /* 0,0,'咲','咳',0,0,0,'咷', '咸',0,'咺',0,'咼','咽','咾','咿', */
	/* 54c0 */  7, 7, 7, 9, 7,-1, 7, 7,  7, 7,-1,-1,-1,-1,-1,-1, /* '哀','品','哂','哃','哄',0,'哆','哇', '哈','哉',0,0,0,0,0,0, */
	/* 54d0 */ -1,-1,-1,-1,-1,-1,-1,-1,  7,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '哘',0,0,0,0,0,0,0, */
	/* 54e0 */ -1, 7, 7,-1,-1, 7, 7,-1,  7, 7,-1,-1, 9, 7, 7, 9, /* 0,'員','哢',0,0,'哥','哦',0, '哨','哩',0,0,'哬','哭','哮','哯', */
	/* 54f0 */ -1, 9, 7, 9,-1,-1,-1,-1, -1,-1, 7,-1,-1, 7,-1, 7, /* 0,'哱','哲','哳',0,0,0,0, 0,0,'哺',0,0,'哽',0,'哿', */
	/* 5500 */  9, 9,-1,-1, 7,-1, 7, 7, -1, 9,-1,-1,-1,-1, 7, 7, /* '唀','唁',0,0,'唄',0,'唆','唇', 0,'唉',0,0,0,0,'唎','唏', */
	/* 5510 */  7,-1,-1,-1, 7,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '唐',0,0,0,'唔',0,'唖',0, 0,0,0,0,0,0,0,0, */
	/* 5520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1, 7, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,'唫',0,0,'售','唯', */
	/* 5530 */ -1, 7,-1, 7,-1, 7,-1,-1,  7, 7,-1,-1, 9,-1, 7,-1, /* 0,'唱',0,'唳',0,'唵',0,0, '唸','唹',0,0,'唼',0,'唾',0, */
	/* 5540 */  7, 9,-1,-1, 7, 7, 7, 9, -1,-1, 9,-1, 7,-1,-1, 7, /* '啀','啁',0,0,'啄','啅','商','啇', 0,0,'啊',0,'啌',0,0,'問', */
	/* 5550 */  7,-1,-1, 7,-1,-1, 7, 7, -1,-1,-1,-1, 7, 7, 7,-1, /* '啐',0,0,'啓',0,0,'啖','啗', 0,0,0,0,'啜','啝','啞',0, */
	/* 5560 */  9, 9,-1, 7, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '啠','啡',0,'啣','啤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7, 7, 9, 7,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'啻','啼','啽','啾',0, */
	/* 5580 */  7, 7, 9, 7, 7,-1, 7, 7,  9, 7, 7, 7,-1,-1, 7,-1, /* '喀','喁','喂','喃','善',0,'喆','喇', '喈','喉','喊','喋',0,0,'喎',0, */
	/* 5590 */ -1, 9,-1,-1,-1,-1,-1,-1,  7, 7, 7,-1, 7, 7, 7, 7, /* 0,'喑',0,0,0,0,0,0, '喘','喙','喚',0,'喜','喝','喞','喟', */
	/* 55a0 */ -1,-1,-1,-1,-1,-1,-1, 7,  7, 7, 7, 7, 7, 7, 7,-1, /* 0,0,0,0,0,0,0,'喧', '喨','喩','喪','喫','喬','喭','單',0, */
	/* 55b0 */  7,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* '喰',0,0,0,0,0,'営',0, 0,0,0,0,0,0,0,'喿', */
	/* 55c0 */ -1,-1,-1,-1, 7, 7,-1, 7, -1, 9,-1,-1, 9,-1, 7,-1, /* 0,0,0,0,'嗄','嗅',0,'嗇', 0,'嗉',0,0,'嗌',0,'嗎',0, */
	/* 55d0 */ -1, 9, 9,-1, 7,-1,-1,-1, -1,-1, 7,-1, 7, 9,-1, 7, /* 0,'嗑','嗒',0,'嗔',0,0,0, 0,0,'嗚',0,'嗜','嗝',0,'嗟', */
	/* 55e0 */ -1,-1, 9, 7, 7,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,'嗢','嗣','嗤',0,0,0, 0,'嗩',0,0,0,0,0,0, */
	/* 55f0 */ -1,-1,-1,-1,-1,-1,-1, 7, -1, 7,-1,-1,-1, 7, 7,-1, /* 0,0,0,0,0,0,0,'嗷', 0,'嗹',0,0,0,'嗽','嗾',0, */
	/* 5600 */ -1,-1,-1,-1,-1,-1, 7, 9,  7, 7,-1,-1,-1,-1, 7,-1, /* 0,0,0,0,0,0,'嘆','嘇', '嘈','嘉',0,0,0,0,'嘎',0, */
	/* 5610 */  9,-1,-1,-1, 7,-1, 7, 7,  7,-1,-1, 7,-1,-1,-1,-1, /* '嘐',0,0,0,'嘔',0,'嘖','嘗', '嘘',0,0,'嘛',0,0,0,0, */
	/* 5620 */ -1,-1,-1,-1,-1,-1,-1,-1,  9, 7,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, '嘨','嘩',0,0,0,0,0,'嘯', */
	/* 5630 */  9, 7, 7,-1, 7,-1, 7, 9,  7,-1,-1, 7,-1, 9,-1, 9, /* '嘰','嘱','嘲',0,'嘴',0,'嘶','嘷', '嘸',0,0,'嘻',0,'嘽',0,'嘿', */
	/* 5640 */  9,-1, 7,-1,-1,-1,-1, 9, -1, 7,-1,-1, 7,-1, 7,-1, /* '噀',0,'噂',0,0,0,0,'噇', 0,'噉',0,0,'噌',0,'噎',0, */
	/* 5650 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1, 9,-1, /* '噐',0,0,0,0,0,0,0, 0,0,0,'噛',0,0,'噞',0, */
	/* 5660 */  9,-1,-1,-1, 7,-1, 7,-1,  7,-1, 7, 7, 7, 9,-1, 7, /* '噠',0,0,0,'噤',0,'噦',0, '器',0,'噪','噫','噬','噭',0,'噯', */
	/* 5670 */ -1, 7, 7,-1, 7,-1, 7,-1,  7,-1, 7,-1,-1,-1,-1,-1, /* 0,'噱','噲',0,'噴',0,'噶',0, '噸',0,'噺',0,0,0,0,0, */
	/* 5680 */  7,-1,-1,-1,-1,-1, 7, 7,  9,-1, 7,-1, 9,-1,-1, 7, /* '嚀',0,0,0,0,0,'嚆','嚇', '嚈',0,'嚊',0,'嚌',0,0,'嚏', */
	/* 5690 */ -1,-1,-1,-1, 7, 9,-1,-1, -1, 7, 9,-1,-1, 9, 7,-1, /* 0,0,0,0,'嚔','嚕',0,0, 0,'嚙','嚚',0,0,'嚝','嚞',0, */
	/* 56a0 */  7,-1, 7,-1,-1, 7,-1,-1,  9, 7,-1,-1, 7, 9, 7,-1, /* '嚠',0,'嚢',0,0,'嚥',0,0, '嚨','嚩',0,0,'嚬','嚭','嚮',0, */
	/* 56b0 */ -1,-1, 9, 7, 7,-1, 7,-1, -1,-1,-1,-1, 7,-1,-1,-1, /* 0,0,'嚲','嚳','嚴',0,'嚶',0, 0,0,0,0,'嚼',0,0,0, */
	/* 56c0 */  7, 7, 7, 7,-1, 9,-1,-1,  7, 7, 7,-1,-1, 9, 7,-1, /* '囀','囁','囂','囃',0,'囅',0,0, '囈','囉','囊',0,0,'囍','囎',0, */
	/* 56d0 */ -1, 7,-1, 7,-1,-1,-1, 7,  7,-1, 7, 7,-1,-1, 7, 9, /* 0,'囑',0,'囓',0,0,0,'囗', '囘',0,'囚','四',0,0,'回','囟', */
	/* 56e0 */  7,-1,-1, 7,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1, 7,-1, /* '因',0,0,'団',0,0,0,0, '囨',0,0,0,0,0,'囮',0, */
	/* 56f0 */  7,-1, 7, 7,-1,-1, 9, 9, -1, 7, 7,-1,-1, 7,-1, 7, /* '困',0,'囲','図',0,0,'囶','囷', 0,'囹','固',0,0,'国',0,'囿', */
	/* 5700 */  7,-1,-1, 7, 7,-1,-1,-1,  7, 7, 7, 7,-1, 7,-1, 7, /* '圀',0,0,'圃','圄',0,0,0, '圈','圉','圊','國',0,'圍',0,'圏', */
	/* 5710 */ -1,-1, 7, 7,-1, 9, 7,-1,  7,-1,-1,-1, 7,-1,-1, 7, /* 0,0,'園','圓',0,'圕','圖',0, '團',0,0,0,'圜',0,0,'土', */
	/* 5720 */ -1, 7,-1, 9,-1,-1, 7, 7,  7, 9,-1,-1,-1, 7,-1, 7, /* 0,'圡',0,'圣',0,0,'圦','圧', '在','圩',0,0,0,'圭',0,'圯', */
	/* 5730 */  7,-1,-1, 7, 7,-1,-1, 7,  7,-1,-1, 7,-1,-1,-1,-1, /* '地',0,0,'圳','圴',0,0,'圷', '圸',0,0,'圻',0,0,0,0, */
	/* 5740 */  7,-1, 7,-1,-1, 9, 9, 7, -1,-1, 7,-1, 9, 9, 7, 7, /* '址',0,'坂',0,0,'坅','坆','均', 0,0,'坊',0,'坌','坍','坎','坏', */
	/* 5750 */  7, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '坐','坑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5760 */ -1, 7,-1,-1, 7,-1, 7,-1,  9, 7, 7,-1,-1,-1,-1, 9, /* 0,'坡',0,0,'坤',0,'坦',0, '坨','坩','坪',0,0,0,0,'坯', */
	/* 5770 */  7,-1,-1, 9, 9, 9,-1, 7, -1,-1,-1, 9, 7,-1,-1, 7, /* '坰',0,0,'坳','坴','坵',0,'坷', 0,0,0,'坻','坼',0,0,'坿', */
	/* 5780 */ -1,-1, 7,-1,-1,-1,-1,-1,  7, 7,-1, 7,-1,-1,-1,-1, /* 0,0,'垂',0,0,0,0,0, '垈','垉',0,'型',0,0,0,0, */
	/* 5790 */ -1,-1,-1, 7,-1,-1,-1,-1, -1,-1, 9,-1, 7, 9, 9,-1, /* 0,0,0,'垓',0,0,0,0, 0,0,'垚',0,'垜','垝','垞',0, */
	/* 57a0 */  7,-1, 7, 7, 7,-1,-1,-1,  9,-1, 7,-1, 9,-1,-1,-1, /* '垠',0,'垢','垣','垤',0,0,0, '垨',0,'垪',0,'垬',0,0,0, */
	/* 57b0 */  7,-1,-1, 7,-1,-1,-1,-1,  7,-1,-1,-1,-1,-1,-1,-1, /* '垰',0,0,'垳',0,0,0,0, '垸',0,0,0,0,0,0,0, */
	/* 57c0 */  7,-1,-1, 7,-1,-1, 7, 7,  7,-1,-1, 7, 9,-1, 7, 7, /* '埀',0,0,'埃',0,0,'埆','埇', '埈',0,0,'埋','埌',0,'城','埏', */
	/* 57d0 */ -1,-1, 7, 7, 7,-1, 7, 9, -1,-1,-1,-1, 7,-1, 9, 7, /* 0,0,'埒','埓','埔',0,'埖','埗', 0,0,0,0,'埜',0,'埞','域', */
	/* 57e0 */  7,-1,-1, 7, 7,-1, 9,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* '埠',0,0,'埣','埤',0,'埦',0, 0,0,0,0,0,'埭',0,0, */
	/* 57f0 */  9,-1,-1,-1, 7, 7, 7, 7,  9, 7, 7, 9, 7, 9,-1, 7, /* '埰',0,0,0,'埴','埵','埶','執', '埸','培','基','埻','埼','埽',0,'埿', */
	/* 5800 */  7,-1, 7,-1, 9, 7, 7,-1, -1, 7, 7, 7,-1,-1,-1,-1, /* '堀',0,'堂',0,'堄','堅','堆',0, 0,'堉','堊','堋',0,0,0,0, */
	/* 5810 */ -1,-1,-1,-1,-1, 7,-1,-1, -1, 7,-1,-1,-1, 7, 9,-1, /* 0,0,0,0,0,'堕',0,0, 0,'堙',0,0,0,'堝','堞',0, */
	/* 5820 */  9, 7,-1,-1, 7,-1,-1, 9, -1,-1, 7,-1,-1,-1,-1, 7, /* '堠','堡',0,0,'堤',0,0,'堧', 0,0,'堪',0,0,0,0,'堯', */
	/* 5830 */  7, 7, 9,-1, 7, 7,-1,-1, -1, 9, 7,-1,-1, 7,-1,-1, /* '堰','報','堲',0,'場','堵',0,0, 0,'堹','堺',0,0,'堽',0,0, */
	/* 5840 */  7, 7,-1,-1,-1,-1,-1,-1, -1, 9, 7, 7, 9,-1,-1,-1, /* '塀','塁',0,0,0,0,0,0, 0,'塉','塊','塋','塌',0,0,0, */
	/* 5850 */ -1, 7, 7,-1, 7,-1,-1, 7,  7, 7, 7,-1,-1,-1, 7,-1, /* 0,'塑','塒',0,'塔',0,0,'塗', '塘','塙','塚',0,0,0,'塞',0, */
	/* 5860 */ -1, 7, 7,-1, 7,-1,-1, 9, -1, 7,-1, 7,-1,-1,-1,-1, /* 0,'塡','塢',0,'塤',0,0,'塧', 0,'塩',0,'填',0,0,0,0, */
	/* 5870 */  7,-1, 7,-1,-1, 7,-1,-1, -1, 7,-1,-1, 7,-1, 7,-1, /* '塰',0,'塲',0,0,'塵',0,0, 0,'塹',0,0,'塼',0,'塾',0, */
	/* 5880 */ -1,-1,-1, 7,-1, 7,-1,-1, -1, 7, 9, 9,-1, 9,-1, 9, /* 0,0,0,'境',0,'墅',0,0, 0,'墉','墊','墋',0,'墍',0,'墏', */
	/* 5890 */  9,-1,-1, 7, 9,-1,-1, 7, -1,-1,-1,-1, 7, 9, 7, 7, /* '墐',0,0,'墓','墔',0,0,'増', 0,0,0,0,'墜','墝','增','墟', */
	/* 58a0 */ -1,-1,-1,-1,-1,-1,-1,-1,  7, 7, 9, 7,-1,-1, 7,-1, /* 0,0,0,0,0,0,0,0, '墨','墩','墪','墫',0,0,'墮',0, */
	/* 58b0 */ -1, 9,-1, 7,-1,-1,-1,-1,  7, 7, 7, 7,-1,-1, 7,-1, /* 0,'墱',0,'墳',0,0,0,0, '墸','墹','墺','墻',0,0,'墾',0, */
	/* 58c0 */ -1, 7,-1, 9,-1, 7,-1, 7, -1,-1, 7,-1, 7, 9, 7,-1, /* 0,'壁',0,'壃',0,'壅',0,'壇', 0,0,'壊',0,'壌','壍','壎',0, */
	/* 58d0 */ -1, 7, 7, 7, 7, 7,-1, 7,  7, 7, 7,-1, 7,-1, 7, 7, /* 0,'壑','壒','壓','壔','壕',0,'壗', '壘','壙','壚',0,'壜',0,'壞','壟', */
	/* 58e0 */  7,-1, 9,-1, 7, 7,-1,-1, -1, 7,-1, 7, 7,-1, 7, 7, /* '壠',0,'壢',0,'壤','壥',0,0, 0,'壩',0,'士','壬',0,'壮','壯', */
	/* 58f0 */  7, 7, 7, 9, 9,-1,-1, 7, -1, 7, 7, 7, 7, 7,-1,-1, /* '声','壱','売','壳','壴',0,0,'壷', 0,'壹','壺','壻','壼','壽',0,0, */
	/* 5900 */ -1,-1, 7,-1,-1, 9, 9,-1, -1, 7, 7, 9, 7, 9,-1, 7, /* 0,0,'夂',0,0,'夅','夆',0, 0,'変','夊','夋','夌','复',0,'夏', */
	/* 5910 */  7,-1,-1,-1, 9, 7, 7,-1,  7, 7, 7, 7, 7,-1,-1,-1, /* '夐',0,0,0,'夔','夕','外',0, '夘','夙','多','夛','夜',0,0,0, */
	/* 5920 */ -1,-1, 7,-1, 9, 7,-1, 7, -1, 7, 7, 7, 7, 7, 7,-1, /* 0,0,'夢',0,'夤','夥',0,'大', 0,'天','太','夫','夬','夭','央',0, */
	/* 5930 */ -1, 7, 7,-1,-1,-1,-1, 7,  7,-1,-1,-1,-1, 9, 7,-1, /* 0,'失','夲',0,0,0,0,'夷', '夸',0,0,0,0,'夽','夾',0, */
	/* 5940 */ -1,-1,-1,-1, 7,-1, 9, 7,  7, 7,-1,-1,-1,-1, 7, 7, /* 0,0,0,0,'奄',0,'奆','奇', '奈','奉',0,0,0,0,'奎','奏', */
	/* 5950 */  7, 7,-1,-1, 7, 7,-1, 7,  7,-1, 7, 9,-1, 7,-1, 9, /* '奐','契',0,0,'奔','奕',0,'套', '奘',0,'奚','奛',0,'奝',0,'奟', */
	/* 5960 */  7,-1, 7,-1,-1, 7,-1, 7,  7, 7, 7,-1, 7, 7, 7,-1, /* '奠',0,'奢',0,0,'奥',0,'奧', '奨','奩','奪',0,'奬','奭','奮',0, */
	/* 5970 */ -1,-1,-1, 7, 7, 9, 9,-1,  7,-1,-1,-1, 9, 7,-1,-1, /* 0,0,0,'女','奴','奵','奶',0, '奸',0,0,0,'奼','好',0,0, */
	/* 5980 */ -1, 7, 7, 7, 7,-1,-1,-1, -1,-1, 7, 7,-1, 7,-1,-1, /* 0,'妁','如','妃','妄',0,0,0, 0,0,'妊','妋',0,'妍',0,0, */
	/* 5990 */ -1,-1, 7, 7,-1,-1, 7,-1, -1, 7,-1, 7,-1, 7,-1, 9, /* 0,0,'妒','妓',0,0,'妖',0, 0,'妙',0,'妛',0,'妝',0,'妟', */
	/* 59a0 */ -1,-1,-1, 7, 7, 7,-1,-1,  7,-1,-1,-1, 7,-1, 9,-1, /* 0,0,0,'妣','妤','妥',0,0, '妨',0,0,0,'妬',0,'妮',0, */
	/* 59b0 */ -1,-1, 7,-1,-1,-1,-1,-1, -1, 7,-1, 7, 9,-1, 7,-1, /* 0,0,'妲',0,0,0,0,0, 0,'妹',0,'妻','妼',0,'妾',0, */
	/* 59c0 */ -1,-1,-1, 7,-1,-1, 7,-1,  9, 7,-1, 7,-1, 9,-1,-1, /* 0,0,0,'姃',0,0,'姆',0, '姈','姉',0,'始',0,'姍',0,0, */
	/* 59d0 */  7, 7, 7, 7, 7,-1,-1,-1, -1, 7, 7,-1, 7, 7, 9,-1, /* '姐','姑','姒','姓','委',0,0,0, 0,'姙','姚',0,'姜','姝','姞',0, */
	/* 59e0 */ -1,-1,-1, 9, 9, 7, 7, 9,  7,-1, 7, 7,-1,-1, 9,-1, /* 0,0,0,'姣','姤','姥','姦','姧', '姨',0,'姪','姫',0,0,'姮',0, */
	/* 59f0 */ -1,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1, 7,-1,-1,-1, 7, /* 0,0,0,0,0,0,'姶',0, 0,0,0,'姻',0,0,0,'姿', */
	/* 5a00 */ -1, 7,-1, 7,-1,-1,-1,-1, -1, 7,-1,-1, 9, 9,-1,-1, /* 0,'威',0,'娃',0,0,0,0, 0,'娉',0,0,'娌','娍',0,0, */
	/* 5a10 */ -1, 7,-1, 7,-1,-1,-1, 9,  7,-1, 7,-1, 7,-1,-1, 7, /* 0,'娑',0,'娓',0,0,0,'娗', '娘',0,'娚',0,'娜',0,0,'娟', */
	/* 5a20 */  7,-1,-1, 7,-1, 7,-1, 9, -1, 7,-1,-1,-1, 9,-1, 7, /* '娠',0,0,'娣',0,'娥',0,'娧', 0,'娩',0,0,0,'娭',0,'娯', */
	/* 5a30 */ -1,-1,-1,-1,-1, 7, 7,-1, -1,-1,-1,-1, 7,-1,-1,-1, /* 0,0,0,0,0,'娵','娶',0, 0,0,0,0,'娼',0,0,0, */
	/* 5a40 */  7, 7,-1,-1,-1,-1, 7,-1, -1, 7,-1,-1,-1,-1,-1,-1, /* '婀','婁',0,0,0,0,'婆',0, 0,'婉',0,0,0,0,0,0, */
	/* 5a50 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'婕',0,0, 0,0,'婚',0,0,0,0,0, */
	/* 5a60 */ -1,-1, 7,-1,-1, 9, 7, 7, -1,-1, 7,-1, 7, 7,-1,-1, /* 0,0,'婢',0,0,'婥','婦','婧', 0,0,'婪',0,'婬','婭',0,0, */
	/* 5a70 */ -1,-1,-1,-1,-1,-1,-1, 7, -1,-1, 9,-1,-1,-1, 7, 7, /* 0,0,0,0,0,0,0,'婷', 0,0,'婺',0,0,0,'婾','婿', */
	/* 5a80 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,'媄',0,0,0, 0,0,0,'媋',0,0,0,0, */
	/* 5a90 */ -1,-1, 7,-1,-1,-1,-1,-1, -1,-1, 7, 7, 9,-1, 7, 9, /* 0,0,'媒',0,0,0,0,0, 0,0,'媚','媛','媜',0,'媞','媟', */
	/* 5aa0 */  9,-1, 9,-1,-1,-1,-1, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* '媠',0,'媢',0,0,0,0,'媧', 0,0,0,0,0,0,0,0, */
	/* 5ab0 */ -1, 9,-1, 9,-1, 9,-1,-1, -1,-1, 9,-1, 7, 7, 7, 9, /* 0,'媱',0,'媳',0,'媵',0,0, 0,0,'媺',0,'媼','媽','媾','媿', */
	/* 5ac0 */ -1, 7, 7,-1, 7,-1,-1,-1, -1, 7,-1, 7, 7,-1,-1,-1, /* 0,'嫁','嫂',0,'嫄',0,0,0, 0,'嫉',0,'嫋','嫌',0,0,0, */
	/* 5ad0 */  7,-1,-1,-1,-1,-1, 7, 7, -1,-1, 9,-1, 9,-1,-1,-1, /* '嫐',0,0,0,0,0,'嫖','嫗', 0,0,'嫚',0,'嫜',0,0,0, */
	/* 5ae0 */  9, 7,-1, 7,-1, 9, 7,-1, -1, 7,-1,-1,-1,-1, 9,-1, /* '嫠','嫡',0,'嫣',0,'嫥','嫦',0, 0,'嫩',0,0,0,0,'嫮',0, */
	/* 5af0 */  9,-1,-1,-1,-1, 9,-1,-1, -1,-1, 7, 7,-1,-1,-1,-1, /* '嫰',0,0,0,0,'嫵',0,0, 0,0,'嫺','嫻',0,0,0,0, */
	/* 5b00 */  9,-1,-1,-1,-1,-1,-1,-1,  9, 7,-1, 7, 7,-1,-1,-1, /* '嬀',0,0,0,0,0,0,0, '嬈','嬉',0,'嬋','嬌',0,0,0, */
	/* 5b10 */ -1,-1,-1,-1,-1,-1, 7, 9, -1, 7,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'嬖','嬗', 0,'嬙',0,0,0,0,0,0, */
	/* 5b20 */ -1,-1, 7,-1,-1, 7,-1,-1, -1,-1, 7,-1, 7, 9,-1,-1, /* 0,0,'嬢',0,0,'嬥',0,0, 0,0,'嬪',0,'嬬','嬭',0,0, */
	/* 5b30 */  7,-1, 7,-1, 9,-1, 7,-1, -1,-1,-1,-1,-1,-1, 7,-1, /* '嬰',0,'嬲',0,'嬴',0,'嬶',0, 0,0,0,0,0,0,'嬾',0, */
	/* 5b40 */  7, 7,-1, 7,-1, 7,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* '孀','孁',0,'孃',0,'孅',0,0, 0,0,0,0,'孌',0,0,0, */
	/* 5b50 */  7, 7, 9,-1, 7, 7, 7, 7,  7,-1, 7, 7, 7, 7,-1, 7, /* '子','孑','孒',0,'孔','孕','孖','字', '存',0,'孚','孛','孜','孝',0,'孟', */
	/* 5b60 */ -1,-1,-1, 7, 7, 7, 7,-1,  9, 7,-1, 7,-1,-1,-1, 9, /* 0,0,0,'季','孤','孥','学',0, '孨','孩',0,'孫',0,0,0,'孯', */
	/* 5b70 */  7, 7,-1, 7,-1, 7,-1,-1,  7,-1, 7,-1, 9, 7,-1, 9, /* '孰','孱',0,'孳',0,'孵',0,0, '學',0,'孺',0,'孼','孽',0,'孿', */
	/* 5b80 */  7, 9,-1, 7, 9, 7,-1, 7,  7, 7,-1, 7, 7, 7,-1, 7, /* '宀','宁',0,'它','宄','宅',0,'宇', '守','安',0,'宋','完','宍',0,'宏', */
	/* 5b90 */ -1,-1,-1, 7,-1, 7, 9, 7,  7, 7, 7, 7, 7, 7,-1, 7, /* 0,0,0,'宓',0,'宕','宖','宗', '官','宙','定','宛','宜','宝',0,'実', */
	/* 5ba0 */ -1,-1, 7, 7, 7, 7, 7,-1, -1,-1,-1,-1, 9,-1, 7,-1, /* 0,0,'客','宣','室','宥','宦',0, 0,0,0,0,'宬',0,'宮',0, */
	/* 5bb0 */  7,-1,-1, 7, 7, 7, 7,-1,  7, 7,-1,-1,-1,-1,-1, 7, /* '宰',0,0,'害','宴','宵','家',0, '宸','容',0,0,0,0,0,'宿', */
	/* 5bc0 */  9,-1, 7, 7, 7, 7, 7, 7, -1, 7,-1,-1, 7,-1, 9,-1, /* '寀',0,'寂','寃','寄','寅','密','寇', 0,'寉',0,0,'富',0,'寎',0, */
	/* 5bd0 */  7,-1, 7, 7, 7,-1, 9,-1,  7,-1,-1, 7,-1, 7, 7, 7, /* '寐',0,'寒','寓','寔',0,'寖',0, '寘',0,0,'寛',0,'寝','寞','察', */
	/* 5be0 */ -1, 7, 7,-1, 7, 7, 7, 7,  7, 7,-1, 7, 7,-1, 7,-1, /* 0,'寡','寢',0,'寤','寥','實','寧', '寨','審',0,'寫','寬',0,'寮',0, */
	/* 5bf0 */  7, 9,-1, 7,-1, 7, 7,-1,  7,-1, 7,-1,-1, 9, 7, 7, /* '寰','寱',0,'寳',0,'寵','寶',0, '寸',0,'寺',0,0,'寽','対','寿', */
	/* 5c00 */ -1, 7, 7, 9, 7, 7, 7, 7,  7, 7, 7, 7,-1, 7, 7, 7, /* 0,'封','専','尃','射','尅','将','將', '專','尉','尊','尋',0,'對','導','小', */
	/* 5c10 */ -1, 7, 7, 7,-1,-1, 7,-1, -1,-1, 7,-1,-1,-1, 7,-1, /* 0,'少','尒','尓',0,0,'尖',0, 0,0,'尚',0,0,0,'尞',0, */
	/* 5c20 */  7,-1, 7, 7, 7,-1,-1,-1,  7, 9,-1, 7,-1, 7,-1,-1, /* '尠',0,'尢','尣','尤',0,0,0, '尨','尩',0,'尫',0,'尭',0,0, */
	/* 5c30 */  9, 7,-1,-1,-1,-1,-1,-1,  7, 7, 7, 7, 7, 7, 7, 7, /* '尰','就',0,0,0,0,0,0, '尸','尹','尺','尻','尼','尽','尾','尿', */
	/* 5c40 */  7, 7,-1,-1,-1, 7, 7,-1,  7,-1, 7, 7,-1, 7, 7, 7, /* '局','屁',0,0,0,'居','屆',0, '屈',0,'届','屋',0,'屍','屎','屏', */
	/* 5c50 */  7, 7,-1, 7,-1, 7,-1,-1, -1,-1,-1,-1,-1,-1, 7, 9, /* '屐','屑',0,'屓',0,'展',0,0, 0,0,0,0,0,0,'属','屟', */
	/* 5c60 */  7, 7, 7, 9, 7, 7,-1, 9,  9, 9,-1,-1, 7,-1, 7, 7, /* '屠','屡','屢','屣','層','履',0,'屧', '屨','屩',0,0,'屬',0,'屮','屯', */
	/* 5c70 */  9, 7,-1,-1,-1,-1, 7,-1, -1, 7, 7,-1, 9,-1,-1,-1, /* '屰','山',0,0,0,0,'屶',0, 0,'屹','屺',0,'屼',0,0,0, */
	/* 5c80 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1, 9,-1, 7,-1,-1, 7, /* 0,0,0,0,0,0,0,0, '岈',0,'岊',0,'岌',0,0,'岏', */
	/* 5c90 */  7, 7,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* '岐','岑',0,0,'岔',0,0,0, 0,0,0,0,0,0,0,'岟', */
	/* 5ca0 */  9, 7, 9, 7,-1,-1, 9, 9,  7, 7, 7, 7, 7, 9,-1,-1, /* '岠','岡','岢','岣',0,0,'岦','岧', '岨','岩','岪','岫','岬','岭',0,0, */
	/* 5cb0 */ -1, 7,-1, 7,-1, 9, 7, 7,  7,-1, 7, 7, 7,-1, 7,-1, /* 0,'岱',0,'岳',0,'岵','岶','岷', '岸',0,'岺','岻','岼',0,'岾',0, */
	/* 5cc0 */ -1,-1,-1,-1,-1, 7,-1, 7, -1, 9,-1, 7,-1,-1,-1,-1, /* 0,0,0,0,0,'峅',0,'峇', 0,'峉',0,'峋',0,0,0,0, */
	/* 5cd0 */  7,-1, 7,-1,-1,-1,-1,-1, -1, 7,-1,-1,-1,-1,-1,-1, /* '峐',0,'峒',0,0,0,0,0, 0,'峙',0,0,0,0,0,0, */
	/* 5ce0 */  7, 7,-1,-1,-1,-1,-1,-1,  7, 7, 7,-1,-1, 7,-1, 7, /* '峠','峡',0,0,0,0,0,0, '峨','峩','峪',0,0,'峭',0,'峯', */
	/* 5cf0 */  7,-1,-1,-1, 7,-1, 7,-1, -1,-1, 7, 7,-1, 7,-1,-1, /* '峰',0,0,0,'峴',0,'島',0, 0,0,'峺','峻',0,'峽',0,0, */
	/* 5d00 */ -1,-1,-1,-1,-1,-1, 9, 7, -1,-1,-1, 7,-1, 7, 7,-1, /* 0,0,0,0,0,0,'崆','崇', 0,0,0,'崋',0,'崍','崎',0, */
	/* 5d10 */  9, 7,-1,-1, 7, 7, 7, 7,  7, 7, 7, 7,-1, 9,-1, 7, /* '崐','崑',0,0,'崔','崕','崖','崗', '崘','崙','崚','崛',0,'崝',0,'崟', */
	/* 5d20 */  9,-1, 7,-1, 9,-1, 9, 7, -1, 7,-1, 9,-1,-1,-1,-1, /* '崠',0,'崢',0,'崤',0,'崦','崧', 0,'崩',0,'崫',0,0,0,0, */
	/* 5d30 */ -1, 9,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,'崱',0,0,0,0,0,0, 0,'崹',0,0,0,0,0,0, */
	/* 5d40 */ -1,-1, 9,-1,-1,-1, 7, 7, -1,-1, 7, 7, 7,-1, 7,-1, /* 0,0,'嵂',0,0,0,'嵆','嵇', 0,0,'嵊','嵋','嵌',0,'嵎',0, */
	/* 5d50 */  7,-1, 7, 7,-1,-1,-1,-1, -1,-1,-1,-1, 7,-1,-1,-1, /* '嵐',0,'嵒','嵓',0,0,0,0, 0,0,0,0,'嵜',0,0,0, */
	/* 5d60 */ -1, 9,-1,-1,-1,-1,-1,-1, -1, 7, 9,-1, 7, 7,-1, 7, /* 0,'嵡',0,0,0,0,0,0, 0,'嵩','嵪',0,'嵬','嵭',0,'嵯', */
	/* 5d70 */  9,-1,-1, 7,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '嵰',0,0,'嵳',0,0,'嵶',0, 0,0,0,0,0,0,0,0, */
	/* 5d80 */ -1, 7, 7,-1, 7,-1,-1, 7,  9,-1,-1, 7, 7,-1,-1,-1, /* 0,'嶁','嶂',0,'嶄',0,0,'嶇', '嶈',0,0,'嶋','嶌',0,0,0, */
	/* 5d90 */  7,-1, 9,-1, 9,-1,-1, 9, -1, 9,-1,-1,-1, 7,-1,-1, /* '嶐',0,'嶒',0,'嶔',0,0,'嶗', 0,'嶙',0,0,0,'嶝',0,0, */
	/* 5da0 */  7,-1, 7,-1, 7,-1,-1, 7, -1,-1,-1,-1, 7,-1, 7,-1, /* '嶠',0,'嶢',0,'嶤',0,0,'嶧', 0,0,0,0,'嶬',0,'嶮',0, */
	/* 5db0 */  9,-1, 9,-1, 9,-1,-1, 7,  7, 9, 7,-1, 7, 7,-1,-1, /* '嶰',0,'嶲',0,'嶴',0,0,'嶷', '嶸','嶹','嶺',0,'嶼','嶽',0,0, */
	/* 5dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 7,-1, 7, 7, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'巉',0,'巋','巌','巍',0,0, */
	/* 5dd0 */ -1, 9, 7, 7,-1,-1, 7, 9,  9,-1,-1, 7,-1, 7, 7,-1, /* 0,'巑','巒','巓',0,0,'巖','巗', '巘',0,0,'巛',0,'川','州',0, */
	/* 5de0 */  9, 7, 7, 7, 9, 7, 7, 7,  7, 9,-1, 7,-1,-1, 7,-1, /* '巠','巡','巢','巣','巤','工','左','巧', '巨','巩',0,'巫',0,0,'差',0, */
	/* 5df0 */ -1, 7, 7, 7, 7, 7,-1, 7, -1,-1,-1, 7,-1, 7, 7,-1, /* 0,'己','已','巳','巴','巵',0,'巷', 0,0,0,'巻',0,'巽','巾',0, */
	/* 5e00 */  9,-1, 7, 7,-1,-1, 7,-1, -1,-1,-1, 7, 7,-1,-1,-1, /* '帀',0,'市','布',0,0,'帆',0, 0,0,0,'帋','希',0,0,0, */
	/* 5e10 */ -1, 7, 9,-1, 7, 9, 7,-1,  7, 7, 7, 7,-1, 7,-1, 9, /* 0,'帑','帒',0,'帔','帕','帖',0, '帘','帙','帚','帛',0,'帝',0,'帟', */
	/* 5e20 */ -1,-1,-1,-1,-1, 7,-1,-1, -1,-1,-1, 7,-1, 7, 9, 7, /* 0,0,0,0,0,'帥',0,0, 0,0,0,'師',0,'席','帮','帯', */
	/* 5e30 */  7,-1,-1, 7,-1,-1, 7, 7,  7,-1,-1,-1,-1, 7, 9,-1, /* '帰',0,0,'帳',0,0,'帶','帷', '常',0,0,0,0,'帽','帾',0, */
	/* 5e40 */  7,-1,-1, 7, 7, 7,-1, 7, -1, 9,-1,-1, 7,-1, 7,-1, /* '幀',0,0,'幃','幄','幅',0,'幇', 0,'幉',0,0,'幌',0,'幎',0, */
	/* 5e50 */ -1,-1,-1,-1, 7, 7, 9, 7,  7,-1,-1,-1,-1,-1, 7, 7, /* 0,0,0,0,'幔','幕','幖','幗', '幘',0,0,0,0,0,'幞','幟', */
	/* 5e60 */ -1, 7, 7, 7, 7,-1,-1,-1, -1,-1,-1, 9, 9, 9, 9,-1, /* 0,'幡','幢','幣','幤',0,0,0, 0,0,0,'幫','幬','幭','幮',0, */
	/* 5e70 */ -1,-1, 7, 7, 7, 7, 7,-1,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,0,'干','平','年','幵','并',0, '幸','幹','幺','幻','幼','幽','幾','广', */
	/* 5e80 */ -1, 7,-1, 7, 7,-1,-1, 7, -1,-1, 7,-1,-1,-1,-1, 7, /* 0,'庁',0,'広','庄',0,0,'庇', 0,0,'床',0,0,0,0,'序', */
	/* 5e90 */ -1,-1,-1,-1,-1, 7, 7, 7, -1,-1, 7,-1, 7,-1,-1,-1, /* 0,0,0,0,0,'底','庖','店', 0,0,'庚',0,'府',0,0,0, */
	/* 5ea0 */  7,-1,-1,-1,-1, 9, 7, 7, -1,-1, 9, 7, 9, 7,-1,-1, /* '庠',0,0,0,0,'庥','度','座', 0,0,'庪','庫','庬','庭',0,0, */
	/* 5eb0 */ -1,-1,-1,-1,-1, 7, 7, 7,  7, 9,-1,-1,-1,-1, 7, 9, /* 0,0,0,0,0,'庵','庶','康', '庸','庹',0,0,0,0,'庾','庿', */
	/* 5ec0 */ -1, 7, 7, 7,-1,-1, 9,-1,  7, 7, 7, 7,-1,-1,-1, 7, /* 0,'廁','廂','廃',0,0,'廆',0, '廈','廉','廊','廋',0,0,0,'廏', */
	/* 5ed0 */  7,-1, 9, 7,-1,-1, 7,-1, -1, 9, 7, 7,-1, 7,-1, 7, /* '廐',0,'廒','廓',0,0,'廖',0, 0,'廙','廚','廛',0,'廝',0,'廟', */
	/* 5ee0 */  7, 7, 7, 7,-1,-1,-1,-1,  7, 7,-1,-1, 7,-1,-1,-1, /* '廠','廡','廢','廣',0,0,0,0, '廨','廩',0,0,'廬',0,0,0, */
	/* 5ef0 */  7, 7,-1, 7, 7,-1, 7, 7,  7, 7, 7, 7, 7, 9, 7, 7, /* '廰','廱',0,'廳','廴',0,'延','廷', '廸','廹','建','廻','廼','廽','廾','廿', */
	/* 5f00 */  7, 7, 7, 7, 7,-1,-1, 7,  9, 7, 7, 7, 7, 7, 9, 7, /* '开','弁','异','弃','弄',0,0,'弇', '弈','弉','弊','弋','弌','弍','弎','式', */
	/* 5f10 */  7, 7,-1, 7, 7, 7, 7, 7,  7,-1,-1, 7, 9, 7, 9, 7, /* '弐','弑',0,'弓','弔','引','弖','弗', '弘',0,0,'弛','弜','弝','弞','弟', */
	/* 5f20 */ -1,-1,-1, 7,-1, 7, 7, 7, -1, 7,-1,-1,-1, 7,-1, 7, /* 0,0,0,'弣',0,'弥','弦','弧', 0,'弩',0,0,0,'弭',0,'弯', */
	/* 5f30 */ -1, 7,-1,-1, 7, 7, 7, 7,  7,-1,-1,-1, 7, 7, 7,-1, /* 0,'弱',0,0,'弴','張','弶','強', '弸',0,0,0,'弼','弽','弾',0, */
	/* 5f40 */  7, 7,-1,-1,-1, 7,-1, 9,  7,-1, 7,-1, 7,-1, 7,-1, /* '彀','彁',0,0,0,'彅',0,'彇', '彈',0,'彊',0,'彌',0,'彎',0, */
	/* 5f50 */ -1, 7,-1, 7, 7,-1, 7, 7,  7, 7,-1,-1, 7, 7,-1,-1, /* 0,'彑',0,'当','彔',0,'彖','彗', '彘','彙',0,0,'彜','彝',0,0, */
	/* 5f60 */ -1, 7, 7, 9, 7,-1, 7, 7, -1, 7, 7, 7, 7, 7,-1,-1, /* 0,'彡','形','彣','彤',0,'彦','彧', 0,'彩','彪','彫','彬','彭',0,0, */
	/* 5f70 */  7, 7, 9, 7,-1,-1,-1, 7, -1, 7,-1,-1, 7, 7, 9, 7, /* '彰','影','彲','彳',0,0,0,'彷', 0,'役',0,0,'彼','彽','彾','彿', */
	/* 5f80 */  7, 7, 7, 7, 7, 7,-1, 7,  7, 7, 7, 7, 7,-1,-1, 9, /* '往','征','徂','徃','径','待',0,'徇', '很','徉','徊','律','後',0,0,'徏', */
	/* 5f90 */  7, 7, 7, 7,-1,-1,-1, 7,  7, 7,-1,-1, 7,-1, 7,-1, /* '徐','徑','徒','従',0,0,0,'得', '徘','徙',0,0,'徜',0,'從',0, */
	/* 5fa0 */  7, 7, 9,-1, 9,-1,-1, 7,  7, 7, 7,-1,-1, 7, 7, 7, /* '徠','御','徢',0,'徤',0,0,'徧', '徨','復','循',0,0,'徭','微','徯', */
	/* 5fb0 */ -1,-1,-1, 7, 7, 7,-1, 7,  9, 7,-1,-1, 7, 7,-1,-1, /* 0,0,0,'徳','徴','徵',0,'德', '徸','徹',0,0,'徼','徽',0,0, */
	/* 5fc0 */ -1,-1,-1, 7, 9, 7,-1, 9, -1, 7,-1, 9, 7, 7,-1,-1, /* 0,0,0,'心','忄','必',0,'忇', 0,'忉',0,'忋','忌','忍',0,0, */
	/* 5fd0 */ -1,-1, 9, 9, 9,-1, 7, 7,  7, 7,-1,-1, 7, 7, 7,-1, /* 0,0,'忒','忓','忔',0,'忖','志', '忘','忙',0,0,'応','忝','忞',0, */
	/* 5fe0 */  7, 7, 9,-1, 7,-1,-1,-1, -1, 7,-1, 7,-1,-1, 9, 9, /* '忠','忡','忢',0,'忤',0,0,0, 0,'忩',0,'快',0,0,'忮','忯', */
	/* 5ff0 */  7, 7,-1, 9,-1, 7,-1,-1,  7,-1,-1, 7, 9, 7,-1, 7, /* '忰','忱',0,'忳',0,'念',0,0, '忸',0,0,'忻','忼','忽',0,'忿', */
	/* 6000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7, 7, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'怍','怎','怏', */
	/* 6010 */  7,-1, 7,-1, 7, 7, 7, 9,  7, 7,-1, 7, 7, 7,-1,-1, /* '怐',0,'怒',0,'怔','怕','怖','怗', '怘','怙',0,'怛','怜','思',0,0, */
	/* 6020 */  7, 7, 9,-1, 9, 7, 7, 7,  7, 7, 7, 7,-1,-1,-1, 7, /* '怠','怡','怢',0,'怤','急','怦','性', '怨','怩','怪','怫',0,0,0,'怯', */
	/* 6030 */ -1, 7,-1, 7,-1, 7,-1,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,'怱',0,'怳',0,'怵',0,0, 0,0,'怺',0,0,0,0,0, */
	/* 6040 */ -1, 7, 7, 7,-1,-1, 7, 7, -1,-1, 7, 7, 9, 7,-1,-1, /* 0,'恁','恂','恃',0,0,'恆','恇', 0,0,'恊','恋','恌','恍',0,0, */
	/* 6050 */  7,-1, 7,-1,-1, 7,-1,-1, -1, 7, 7,-1,-1,-1,-1, 7, /* '恐',0,'恒',0,0,'恕',0,0, 0,'恙','恚',0,0,0,0,'恟', */
	/* 6060 */  7,-1, 7, 7, 7, 7,-1,-1,  7, 7, 7, 7, 7, 7,-1, 7, /* '恠',0,'恢','恣','恤','恥',0,0, '恨','恩','恪','恫','恬','恭',0,'息', */
	/* 6070 */  7,-1,-1,-1,-1, 7,-1, 7, -1,-1,-1,-1,-1,-1,-1, 9, /* '恰',0,0,0,0,'恵',0,'恷', 0,0,0,0,0,0,0,'恿', */
	/* 6080 */ -1, 7,-1, 7, 7,-1,-1,-1, -1, 7, 9, 7, 7, 7,-1,-1, /* 0,'悁',0,'悃','悄',0,0,0, 0,'悉','悊','悋','悌','悍',0,0, */
	/* 6090 */ -1,-1, 7,-1, 7, 9, 7, 7, -1,-1, 7, 7,-1, 7, 7, 7, /* 0,0,'悒',0,'悔','悕','悖','悗', 0,0,'悚','悛',0,'悝','悞','悟', */
	/* 60a0 */  7,-1,-1, 7,-1,-1, 7, 7,  9, 7, 7,-1,-1,-1,-1,-1, /* '悠',0,0,'患',0,0,'悦','悧', '您','悩','悪',0,0,0,0,0, */
	/* 60b0 */  9, 9, 7, 7, 7, 7, 7,-1,  7,-1,-1,-1, 7, 7, 9,-1, /* '悰','悱','悲','悳','悴','悵','悶',0, '悸',0,0,0,'悼','悽','悾',0, */
	/* 60c0 */ -1,-1,-1,-1,-1, 7, 7, 7,  9,-1,-1, 7,-1,-1,-1,-1, /* 0,0,0,0,0,'情','惆','惇', '惈',0,0,'惋',0,0,0,0, */
	/* 60d0 */ -1, 7,-1, 7, 7, 7,-1,-1,  7, 9, 7, 9, 7, 7,-1, 7, /* 0,'惑',0,'惓','惔','惕',0,0, '惘','惙','惚','惛','惜','惝',0,'惟', */
	/* 60e0 */  7, 7,-1, 7,-1,-1,-1, 7,  7,-1,-1,-1,-1,-1, 9,-1, /* '惠','惡',0,'惣',0,0,0,'惧', '惨',0,0,0,0,0,'惮',0, */
	/* 60f0 */  7, 7, 9, 7, 7, 9, 7, 7,  7, 7, 7, 7,-1,-1,-1,-1, /* '惰','惱','惲','想','惴','惵','惶','惷', '惸','惹','惺','惻',0,0,0,0, */
	/* 6100 */  7, 7,-1, 7,-1,-1, 7,-1,  7, 7,-1,-1,-1, 7, 7, 7, /* '愀','愁',0,'愃',0,0,'愆',0, '愈','愉',0,0,0,'愍','愎','意', */
	/* 6110 */  9,-1, 9, 9,-1, 7,-1,-1, -1, 9, 7, 7, 7,-1, 9, 7, /* '愐',0,'愒','愓',0,'愕',0,0, 0,'愙','愚','愛','愜',0,'愞','感', */
	/* 6120 */ -1, 7,-1,-1,-1,-1,-1, 7,  7,-1,-1, 7, 7,-1,-1,-1, /* 0,'愡',0,0,0,0,0,'愧', '愨',0,0,'愫','愬',0,0,0, */
	/* 6130 */  7,-1,-1,-1, 7,-1,-1, 7, -1,-1, 9,-1, 7, 7, 7, 7, /* '愰',0,0,0,'愴',0,0,'愷', 0,0,'愺',0,'愼','愽','愾','愿', */
	/* 6140 */ -1, 9, 7,-1, 7,-1, 9, 7,  7,-1, 7, 7, 7, 7, 7,-1, /* 0,'慁','慂',0,'慄',0,'慆','慇', '慈',0,'慊','態','慌','慍','慎',0, */
	/* 6150 */ -1,-1,-1, 7,-1, 7,-1,-1,  7, 7, 7,-1,-1, 7,-1, 7, /* 0,0,0,'慓',0,'慕',0,0, '慘','慙','慚',0,0,'慝',0,'慟', */
	/* 6160 */  9,-1, 7, 7,-1, 7,-1, 7,  7,-1,-1, 7,-1,-1, 7, 7, /* '慠',0,'慢','慣',0,'慥',0,'慧', '慨',0,0,'慫',0,0,'慮','慯', */
	/* 6170 */  7, 7,-1, 7, 7, 7, 7, 7, -1,-1,-1,-1, 9,-1, 7,-1, /* '慰','慱',0,'慳','慴','慵','慶','慷', 0,0,0,0,'慼',0,'慾',0, */
	/* 6180 */ -1,-1, 7,-1,-1,-1,-1, 7, -1,-1, 7,-1,-1, 7, 7,-1, /* 0,0,'憂',0,0,0,0,'憇', 0,0,'憊',0,0,'憍','憎',0, */
	/* 6190 */  7, 7, 9, 9, 7,-1, 7, 9,  9, 7, 7,-1,-1,-1,-1,-1, /* '憐','憑','憒','憓','憔',0,'憖','憗', '憘','憙','憚',0,0,0,0,0, */
	/* 61a0 */ -1,-1,-1,-1, 7, 9,-1, 7,  9, 7,-1, 7, 7, 9, 7,-1, /* 0,0,0,0,'憤','憥',0,'憧', '憨','憩',0,'憫','憬','憭','憮',0, */
	/* 61b0 */ -1,-1, 7,-1,-1,-1, 7,-1, -1, 7, 7,-1, 7,-1, 7,-1, /* 0,0,'憲',0,0,0,'憶',0, 0,'憹','憺',0,'憼',0,'憾',0, */
	/* 61c0 */ -1,-1,-1, 7,-1,-1, 7, 7,  7, 7, 7, 7, 7, 7,-1,-1, /* 0,0,0,'懃',0,0,'懆','懇', '懈','應','懊','懋','懌','懍',0,0, */
	/* 61d0 */  7,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1, 9,-1, 9, /* '懐',0,0,0,0,'懕',0,0, 0,0,0,0,0,'懝',0,'懟', */
	/* 61e0 */ -1,-1,-1, 7,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'懣',0,0,'懦',0, 0,0,0,0,0,0,0,0, */
	/* 61f0 */ -1,-1, 7,-1, 7, 9, 7, 7,  7,-1, 7,-1, 7, 7, 7, 7, /* 0,0,'懲',0,'懴','懵','懶','懷', '懸',0,'懺',0,'懼','懽','懾','懿', */
	/* 6200 */  7,-1,-1,-1,-1,-1,-1,-1,  7, 7, 7,-1, 7, 7, 7,-1, /* '戀',0,0,0,0,0,0,0, '戈','戉','戊',0,'戌','戍','戎',0, */
	/* 6210 */  7, 7, 7,-1, 7, 9, 7,-1, -1,-1, 7, 7,-1, 7, 7, 7, /* '成','我','戒',0,'戔','戕','或',0, 0,0,'戚','戛',0,'戝','戞','戟', */
	/* 6220 */ -1, 7, 7, 9,-1,-1, 7,-1, -1, 9, 7,-1,-1,-1, 7, 7, /* 0,'戡','戢','戣',0,0,'戦',0, 0,'戩','截',0,0,0,'戮','戯', */
	/* 6230 */  7,-1, 7, 7, 7,-1,-1,-1,  7,-1,-1, 7,-1,-1, 7, 7, /* '戰',0,'戲','戳','戴',0,0,0, '戸',0,0,'戻',0,0,'戾','房', */
	/* 6240 */  7, 7,-1, 7,-1,-1, 9, 7,  7, 7,-1, 7, 9, 7, 7,-1, /* '所','扁',0,'扃',0,0,'扆','扇', '扈','扉',0,'手','扌','才','扎',0, */
	/* 6250 */ -1, 9, 9, 7,-1, 7, 7,-1,  7,-1, 7, 7,-1,-1, 7,-1, /* 0,'扑','扒','打',0,'払','扖',0, '托',0,'扚','扛',0,0,'扞',0, */
	/* 6260 */  7, 9,-1, 7, 9,-1,-1,-1,  7,-1,-1,-1,-1, 9, 7, 7, /* '扠','扡',0,'扣','扤',0,0,0, '扨',0,0,0,0,'扭','扮','扯', */
	/* 6270 */ -1, 7,-1, 9,-1,-1, 7,-1, -1, 7,-1, 9, 7,-1, 7, 7, /* 0,'扱',0,'扳',0,0,'扶',0, 0,'批',0,'扻','扼',0,'找','承', */
	/* 6280 */  7,-1, 7, 7, 7, 7,-1,-1, -1, 7, 7,-1,-1,-1,-1,-1, /* '技',0,'抂','抃','抄','抅',0,0, 0,'抉','把',0,0,0,0,0, */
	/* 6290 */ -1, 7, 7, 7, 7, 7, 7, 7,  7, 9,-1, 7, 7,-1, 7,-1, /* 0,'抑','抒','抓','抔','投','抖','抗', '折','抙',0,'抛','抜',0,'択',0, */
	/* 62a0 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1, 7, 7,-1,-1,-1, /* 0,0,0,0,0,0,'抦',0, 0,0,0,'披','抬',0,0,0, */
	/* 62b0 */ -1, 7,-1,-1,-1, 7,-1,-1, -1, 7,-1, 7, 7, 7,-1,-1, /* 0,'抱',0,0,0,'抵',0,0, 0,'抹',0,'抻','押','抽',0,0, */
	/* 62c0 */ -1,-1, 7,-1, 7, 7, 7, 7,  7, 7, 7,-1, 7, 7,-1, 7, /* 0,0,'拂',0,'拄','担','拆','拇', '拈','拉','拊',0,'拌','拍',0,'拏', */
	/* 62d0 */  7, 7, 7, 7, 7, 9, 7, 7,  7, 7,-1, 7, 7, 7,-1,-1, /* '拐','拑','拒','拓','拔','拕','拖','拗', '拘','拙',0,'招','拜','拝',0,0, */
	/* 62e0 */  7, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 7, 7, 7, 7, /* '拠','拡',0,0,0,0,0,0, 0,0,0,0,'括','拭','拮','拯', */
	/* 62f0 */ -1, 7,-1, 7,-1, 7, 7, 7, -1,-1,-1,-1, 7, 9, 7, 7, /* 0,'拱',0,'拳',0,'拵','拶','拷', 0,0,0,0,'拼','拽','拾','拿', */
	/* 6300 */ -1, 7, 7, 9,-1,-1,-1, 7,  7, 7, 7,-1, 7, 9,-1,-1, /* 0,'持','挂','挃',0,0,0,'指', '挈','按','挊',0,'挌','挍',0,0, */
	/* 6310 */  9, 7,-1,-1,-1,-1,-1,-1,  7, 7,-1,-1,-1,-1,-1, 7, /* '挐','挑',0,0,0,0,0,0, '挘','挙',0,0,0,0,0,'挟', */
	/* 6320 */ -1,-1,-1,-1,-1,-1,-1, 7,  7,-1,-1, 7,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,'挧', '挨',0,0,'挫',0,0,0,'振', */
	/* 6330 */ -1,-1, 9,-1,-1, 9,-1,-1, -1, 7, 7, 9, 9, 7, 7, 7, /* 0,0,'挲',0,0,'挵',0,0, 0,'挹','挺','挻','挼','挽','挾','挿', */
	/* 6340 */ -1, 9,-1, 7, 9,-1,-1,-1, -1, 7,-1,-1, 7, 7, 9, 7, /* 0,'捁',0,'捃','捄',0,0,0, 0,'捉',0,0,'捌','捍','捎','捏', */
	/* 6350 */  7,-1,-1,-1,-1, 7,-1, 7, -1, 9,-1,-1, 7,-1,-1,-1, /* '捐',0,0,0,0,'捕',0,'捗', 0,'捙',0,0,'捜',0,0,0, */
	/* 6360 */ -1,-1,-1,-1,-1, 7,-1, 7,  7, 7,-1, 7, 9,-1, 7,-1, /* 0,0,0,0,0,'捥',0,'捧', '捨','捩',0,'捫','捬',0,'据',0, */
	/* 6370 */ -1,-1, 7,-1,-1,-1, 7, 7, -1,-1, 7, 7, 7,-1,-1,-1, /* 0,0,'捲',0,0,0,'捶','捷', 0,0,'捺','捻','捼',0,0,0, */
	/* 6380 */  7,-1,-1, 7, 9,-1,-1,-1,  7, 7,-1,-1, 7,-1, 7, 7, /* '掀',0,0,'掃','掄',0,0,0, '授','掉',0,0,'掌',0,'掎','掏', */
	/* 6390 */ -1,-1, 7,-1, 9,-1, 7,-1,  7, 9,-1, 7,-1,-1,-1, 7, /* 0,0,'排',0,'掔',0,'掖',0, '掘','掙',0,'掛',0,0,0,'掟', */
	/* 63a0 */  7, 7, 7, 7,-1, 7,-1, 7,  7, 7, 7, 7, 7,-1,-1,-1, /* '掠','採','探','掣',0,'接',0,'控', '推','掩','措','掫','掬',0,0,0, */
	/* 63b0 */ -1,-1, 7,-1, 7, 7,-1,-1, -1,-1,-1, 7,-1, 9, 7,-1, /* 0,0,'掲',0,'掴','掵',0,0, 0,0,0,'掻',0,'掽','掾',0, */
	/* 63c0 */  7,-1,-1, 7, 7,-1, 7,-1, -1, 7,-1,-1,-1,-1,-1, 7, /* '揀',0,0,'揃','揄',0,'揆',0, 0,'揉',0,0,0,0,0,'描', */
	/* 63d0 */  7,-1, 7,-1, 9, 9, 7,-1, -1,-1, 7, 7, 9,-1,-1,-1, /* '提',0,'插',0,'揔','揕','揖',0, 0,0,'揚','換','揜',0,0,0, */
	/* 63e0 */  9, 7,-1, 7,-1, 7,-1,-1, -1, 7,-1, 9, 9, 7, 7,-1, /* '揠','握',0,'揣',0,'揥',0,0, 0,'揩',0,'揫','揬','揭','揮',0, */
	/* 63f0 */ -1,-1, 9,-1, 7, 7, 7, 9, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,0,'揲',0,'援','揵','揶','揷', 0,0,'揺',0,0,0,0,0, */
	/* 6400 */ -1,-1,-1,-1,-1,-1, 7,-1, -1, 9,-1,-1,-1, 7,-1, 7, /* 0,0,0,0,0,0,'搆',0, 0,'搉',0,0,0,'損',0,'搏', */
	/* 6410 */  7,-1,-1, 7, 7,-1, 7, 7, -1,-1,-1,-1, 7,-1, 9,-1, /* '搐',0,0,'搓','搔',0,'搖','搗', 0,0,0,0,'搜',0,'搞',0, */
	/* 6420 */ -1,-1, 7,-1,-1, 9, 7,-1,  7, 9,-1,-1, 7, 7,-1, 9, /* 0,0,'搢',0,0,'搥','搦',0, '搨','搩',0,0,'搬','搭',0,'搯', */
	/* 6430 */ -1,-1,-1,-1, 7,-1, 7,-1, -1,-1, 7,-1,-1,-1, 7,-1, /* 0,0,0,0,'搴',0,'搶',0, 0,0,'携',0,0,0,'搾',0, */
	/* 6440 */ -1,-1, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 7,-1, /* 0,0,'摂',0,0,0,0,0, 0,0,0,0,0,0,'摎',0, */
	/* 6450 */ -1, 7,-1,-1,-1,-1,-1,-1,  7,-1, 9, 9,-1, 9,-1,-1, /* 0,'摑',0,0,0,0,0,0, '摘',0,'摚','摛',0,'摝',0,0, */
	/* 6460 */  7,-1,-1,-1,-1,-1,-1, 7, -1, 7,-1,-1,-1, 7,-1, 7, /* '摠',0,0,0,0,0,0,'摧', 0,'摩',0,0,0,'摭',0,'摯', */
	/* 6470 */ -1,-1,-1, 9,-1,-1, 7,-1,  7, 7, 7,-1,-1, 9,-1,-1, /* 0,0,0,'摳',0,0,'摶',0, '摸','摹','摺',0,0,'摽',0,0, */
	/* 6480 */ -1,-1,-1, 7,-1,-1,-1, 9,  7,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'撃',0,0,0,'撇', '撈',0,0,0,0,0,0,0, */
	/* 6490 */ -1, 9, 7, 7,-1, 7,-1,-1, -1,-1, 7,-1,-1, 9, 7, 9, /* 0,'撑','撒','撓',0,'撕',0,0, 0,0,'撚',0,0,'撝','撞','撟', */
	/* 64a0 */ -1,-1,-1,-1, 7, 7,-1,-1, -1, 7,-1, 7,-1, 7, 7,-1, /* 0,0,0,0,'撤','撥',0,0, 0,'撩',0,'撫',0,'播','撮',0, */
	/* 64b0 */  7,-1, 7,-1,-1,-1,-1,-1, -1, 7,-1, 7, 7,-1, 7, 7, /* '撰',0,'撲',0,0,0,0,0, 0,'撹',0,'撻','撼',0,'撾','撿', */
	/* 64c0 */ -1, 7, 7,-1, 7, 7,-1, 7, -1,-1, 7, 9, 9, 7, 7,-1, /* 0,'擁','擂',0,'擄','擅',0,'擇', 0,0,'擊','擋','擌','操','擎',0, */
	/* 64d0 */  7,-1, 7,-1, 7, 9,-1, 9,  7,-1, 7,-1,-1,-1,-1,-1, /* '擐',0,'擒',0,'擔','擕',0,'擗', '擘',0,'據',0,0,0,0,0, */
	/* 64e0 */  7, 7, 7, 7, 9, 9, 7, 7, -1,-1,-1,-1, 7,-1,-1, 7, /* '擠','擡','擢','擣','擤','擥','擦','擧', 0,0,0,0,'擬',0,0,'擯', */
	/* 64f0 */ -1, 7, 7,-1, 7,-1, 7, 7, -1,-1, 7, 7,-1, 7, 7, 9, /* 0,'擱','擲',0,'擴',0,'擶','擷', 0,0,'擺','擻',0,'擽','擾','擿', */
	/* 6500 */  7,-1,-1,-1, 9, 7,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* '攀',0,0,0,'攄','攅',0,0, 0,0,0,0,0,0,0,'攏', */
	/* 6510 */ -1,-1,-1,-1, 9,-1, 9,-1,  7,-1,-1,-1, 7, 7, 9,-1, /* 0,0,0,0,'攔',0,'攖',0, '攘',0,0,0,'攜','攝','攞',0, */
	/* 6520 */ -1,-1, 7, 7, 7,-1,-1,-1, -1, 7, 7, 7, 7,-1,-1, 7, /* 0,0,'攢','攣','攤',0,0,0, 0,'攩','攪','攫','攬',0,0,'支', */
	/* 6530 */ -1,-1, 9,-1, 7, 7, 7, 7,  7, 7,-1, 7,-1,-1, 7, 7, /* 0,0,'攲',0,'攴','攵','收','攷', '攸','改',0,'攻',0,0,'放','政', */
	/* 6540 */ -1,-1,-1,-1, 9, 7,-1,-1,  7,-1,-1,-1,-1, 7,-1, 7, /* 0,0,0,0,'敄','故',0,0, '效',0,0,0,0,'敍',0,'敏', */
	/* 6550 */ -1, 7,-1,-1, 9, 7, 7, 7,  7, 7,-1,-1,-1, 7, 7,-1, /* 0,'救',0,0,'敔','敕','敖','敗', '敘','教',0,0,0,'敝','敞',0, */
	/* 6560 */ -1,-1, 7, 7,-1,-1, 7, 7, -1,-1,-1, 9, 7,-1,-1,-1, /* 0,0,'敢','散',0,0,'敦','敧', 0,0,0,'敫','敬',0,0,0, */
	/* 6570 */  7,-1, 7,-1, 7, 7,-1, 7,  7,-1, 9,-1,-1,-1,-1,-1, /* '数',0,'敲',0,'整','敵',0,'敷', '數',0,'敺',0,0,0,0,0, */
	/* 6580 */ -1, 9, 7, 7, 9, 9,-1, 7,  7, 7, 9,-1, 7,-1, 7,-1, /* 0,'斁','斂','斃','斄','斅',0,'文', '斈','斉','斊',0,'斌',0,'斎',0, */
	/* 6590 */  7, 7,-1,-1,-1,-1,-1, 7, -1, 7,-1, 7, 7, 7,-1, 7, /* '斐','斑',0,0,0,0,0,'斗', 0,'料',0,'斛','斜','斝',0,'斟', */
	/* 65a0 */ -1, 7,-1,-1, 7, 7,-1, 7, -1,-1,-1, 7, 7, 7,-1, 7, /* 0,'斡',0,0,'斤','斥',0,'斧', 0,0,0,'斫','斬','断',0,'斯', */
	/* 65b0 */  7,-1, 9,-1,-1, 9,-1, 7,  9, 7,-1,-1, 7, 7,-1, 9, /* '新',0,'斲',0,0,'斵',0,'斷', '斸','方',0,0,'於','施',0,'斿', */
	/* 65c0 */ -1, 7, 9, 7, 7, 7, 7,-1, -1, 9,-1, 7, 7,-1,-1, 7, /* 0,'旁','旂','旃','旄','旅','旆',0, 0,'旉',0,'旋','旌',0,0,'族', */
	/* 65d0 */ -1,-1, 7,-1, 9,-1,-1, 7, -1, 7,-1, 7,-1,-1,-1,-1, /* 0,0,'旒',0,'旔',0,0,'旗', 0,'旙',0,'旛',0,0,0,0, */
	/* 65e0 */  7, 7, 7,-1,-1, 7, 7, 7,  7, 7,-1,-1, 7, 7,-1,-1, /* '无','旡','既',0,0,'日','旦','旧', '旨','早',0,0,'旬','旭',0,0, */
	/* 65f0 */ -1, 7, 9,-1,-1,-1,-1,-1, -1, 9, 7, 7, 9,-1,-1,-1, /* 0,'旱','旲',0,0,0,0,0, 0,'旹','旺','旻','旼',0,0,0, */
	/* 6600 */  7,-1, 7, 7, 9,-1, 7, 7,  9, 7, 7,-1, 7,-1, 7, 7, /* '昀',0,'昂','昃','昄',0,'昆','昇', '昈','昉','昊',0,'昌',0,'明','昏', */
	/* 6610 */ -1,-1,-1, 7, 7, 7,-1,-1, -1,-1,-1,-1, 7,-1, 7, 7, /* 0,0,0,'易','昔','昕',0,0, 0,0,0,0,'昜',0,'昞','星', */
	/* 6620 */  7, 9, 7,-1, 7, 7,-1, 7,  7,-1, 9, 7,-1, 7,-1, 7, /* '映','昡','昢',0,'昤','春',0,'昧', '昨',0,'昪','昫',0,'昭',0,'是', */
	/* 6630 */  7, 7,-1, 7, 7, 7, 7,-1, -1,-1, 7,-1, 7,-1,-1, 7, /* '昰','昱',0,'昳','昴','昵','昶',0, 0,0,'昺',0,'昼',0,0,'昿', */
	/* 6640 */ -1, 7, 7, 7, 7, 9,-1,-1,  7, 7,-1, 7, 7,-1, 9, 7, /* 0,'晁','時','晃','晄','晅',0,0, '晈','晉',0,'晋','晌',0,'晎','晏', */
	/* 6650 */ -1, 9, 7,-1,-1,-1,-1, 9, -1, 7, 7, 9,-1, 7, 7, 7, /* 0,'晑','晒',0,0,0,0,'晗', 0,'晙','晚','晛',0,'晝','晞','晟', */
	/* 6660 */ -1, 7, 7, 9, 7, 7, 7, 7,  7, 7, 9, 9, 9, 9, 7, 7, /* 0,'晡','晢','晣','晤','晥','晦','晧', '晨','晩','晪','晫','晬','晭','普','景', */
	/* 6670 */  7,-1,-1, 7, 7,-1, 7, 7,  7,-1, 7, 9,-1,-1,-1,-1, /* '晰',0,0,'晳','晴',0,'晶','晷', '晸',0,'智','晻',0,0,0,0, */
	/* 6680 */  9, 7,-1, 7, 7,-1,-1, 7,  7, 7,-1,-1,-1, 7, 7,-1, /* '暀','暁',0,'暃','暄',0,0,'暇', '暈','暉',0,0,0,'暍','暎',0, */
	/* 6690 */  9, 7, 9,-1,-1,-1, 7, 7,  7, 9,-1,-1,-1, 7,-1,-1, /* '暐','暑','暒',0,0,0,'暖','暗', '暘','暙',0,0,0,'暝',0,0, */
	/* 66a0 */  7,-1, 7,-1,-1,-1, 7,-1, -1,-1,-1, 7,-1, 9, 7,-1, /* '暠',0,'暢',0,0,0,'暦',0, 0,0,0,'暫',0,'暭','暮',0, */
	/* 66b0 */ -1, 9, 7,-1, 7, 9,-1,-1,  7, 7,-1, 7, 7,-1, 7, 9, /* 0,'暱','暲',0,'暴','暵',0,0, '暸','暹',0,'暻','暼',0,'暾','暿', */
	/* 66c0 */ -1, 7,-1,-1, 7,-1, 7, 7,  7, 7,-1,-1,-1,-1,-1,-1, /* 0,'曁',0,0,'曄',0,'曆','曇', '曈','曉',0,0,0,0,0,0, */
	/* 66d0 */ -1,-1,-1,-1,-1,-1, 7,-1, -1, 7, 7, 7, 7, 7,-1,-1, /* 0,0,0,0,0,0,'曖',0, 0,'曙','曚','曛','曜','曝',0,0, */
	/* 66e0 */  7,-1,-1,-1,-1,-1, 7,-1,  7, 7,-1,-1, 9,-1,-1,-1, /* '曠',0,0,0,0,0,'曦',0, '曨','曩',0,0,'曬',0,0,0, */
	/* 66f0 */  7,-1, 7, 7, 7, 7,-1, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '曰',0,'曲','曳','更','曵',0,'曷', '書','曹','曺','曻','曼','曽','曾','替', */
	/* 6700 */  7, 9,-1, 7,-1, 9,-1,-1,  7, 7,-1, 7,-1, 7,-1, 7, /* '最','朁',0,'會',0,'朅',0,0, '月','有',0,'朋',0,'服',0,'朏', */
	/* 6710 */ -1,-1, 9, 7, 7, 7, 7, 7, -1, 9,-1, 7,-1, 7, 7, 7, /* 0,0,'朒','朓','朔','朕','朖','朗', 0,'朙',0,'望',0,'朝','朞','期', */
	/* 6720 */ -1,-1,-1,-1,-1,-1, 7, 7,  7,-1, 7, 7, 7, 7, 7,-1, /* 0,0,0,0,0,0,'朦','朧', '木',0,'未','末','本','札','朮',0, */
	/* 6730 */ -1, 7,-1, 7, 7,-1, 7, 7,  7,-1, 7,-1,-1, 7,-1, 7, /* 0,'朱',0,'朳','朴',0,'朶','朷', '朸',0,'机',0,0,'朽',0,'朿', */
	/* 6740 */ -1, 7,-1,-1,-1,-1, 7, 7,  7, 7,-1,-1, 9, 9, 7, 7, /* 0,'杁',0,0,0,0,'杆','杇', '杈','杉',0,0,'杌','杍','李','杏', */
	/* 6750 */  7, 7,-1, 7, 9,-1, 7,-1, -1, 7,-1,-1, 7, 9, 7, 7, /* '材','村',0,'杓','杔',0,'杖',0, 0,'杙',0,0,'杜','杝','杞','束', */
	/* 6760 */  7, 7, 7, 7, 7, 7, 7,-1, -1,-1, 7,-1,-1, 7,-1, 7, /* '杠','条','杢','杣','杤','来','杦',0, 0,0,'杪',0,0,'杭',0,'杯', */
	/* 6770 */  7, 7, 7, 7, 9, 7, 9, 7, -1,-1,-1, 7, 7,-1, 7, 7, /* '杰','東','杲','杳','杴','杵','杶','杷', 0,0,0,'杻','杼',0,'松','板', */
	/* 6780 */ -1, 7,-1,-1,-1, 7,-1, 7, -1, 7,-1, 7, 7,-1,-1,-1, /* 0,'极',0,0,0,'枅',0,'枇', 0,'枉',0,'枋','枌',0,0,0, */
	/* 6790 */  7,-1, 9, 7,-1, 7,-1, 7,  7,-1, 7, 7, 7, 7,-1,-1, /* '析',0,'枒','枓',0,'枕',0,'林', '枘',0,'枚','枛','果','枝',0,0, */
	/* 67a0 */  7, 7, 7,-1,-1,-1, 7,-1, -1, 7,-1,-1,-1,-1,-1, 7, /* '枠','枡','枢',0,0,0,'枦',0, 0,'枩',0,0,0,0,0,'枯', */
	/* 67b0 */  9,-1, 9, 7, 7,-1, 7, 7,  7, 7,-1, 7,-1,-1,-1,-1, /* '枰',0,'枲','枳','枴',0,'架','枷', '枸','枹',0,'枻',0,0,0,0, */
	/* 67c0 */  7, 7,-1, 9, 7,-1, 7,-1,  9,-1, 7,-1,-1,-1, 7, 7, /* '柀','柁',0,'柃','柄',0,'柆',0, '柈',0,'柊',0,0,0,'柎','柏', */
	/* 67d0 */  7, 7, 9, 7, 7,-1,-1, 7,  7, 9, 7, 9,-1, 7, 7,-1, /* '某','柑','柒','染','柔',0,0,'柗', '柘','柙','柚','柛',0,'柝','柞',0, */
	/* 67e0 */ -1,-1, 7,-1, 7,-1,-1, 7, -1, 7,-1,-1, 7,-1, 7, 7, /* 0,0,'柢',0,'柤',0,0,'柧', 0,'柩',0,0,'柬',0,'柮','柯', */
	/* 67f0 */  9, 7,-1, 7, 7, 7,-1, 9, -1, 7,-1, 7, 7,-1, 7, 7, /* '柰','柱',0,'柳','柴','柵',0,'柷', 0,'柹',0,'査','柼',0,'柾','柿', */
	/* 6800 */ -1, 7, 7, 7, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'栁','栂','栃','栄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6810 */  9,-1,-1, 7,-1,-1, 7, 7,  9,-1,-1,-1,-1, 7, 7, 9, /* '栐',0,0,'栓',0,0,'栖','栗', '栘',0,0,0,0,'栝','栞','栟', */
	/* 6820 */ -1, 7, 7,-1,-1,-1,-1,-1, -1, 7, 7, 7, 7, 9,-1,-1, /* 0,'校','栢',0,0,0,0,0, 0,'栩','株','栫','栬','栭',0,0, */
	/* 6830 */ -1, 7, 7, 9, 7,-1,-1,-1,  7, 7,-1, 9, 7, 7, 9,-1, /* 0,'栱','栲','栳','栴',0,0,0, '核','根',0,'栻','格','栽','栾',0, */
	/* 6840 */  7, 7, 7, 7, 9, 9, 7,-1,  7, 9,-1,-1, 9, 7, 7,-1, /* '桀','桁','桂','桃','桄','桅','框',0, '案','桉',0,0,'桌','桍','桎',0, */
	/* 6850 */  7, 7, 7, 7, 7, 9,-1, 9, -1, 7,-1, 7, 7, 7,-1, 7, /* '桐','桑','桒','桓','桔','桕',0,'桗', 0,'桙',0,'桛','桜','桝',0,'桟', */
	/* 6860 */ -1,-1,-1, 7,-1,-1,-1, 7, -1,-1,-1, 9,-1,-1, 9,-1, /* 0,0,0,'档',0,0,0,'桧', 0,0,0,'桫',0,0,'桮',0, */
	/* 6870 */ -1,-1, 7,-1, 7, 7, 7, 7, -1,-1, 9,-1, 9,-1, 7, 7, /* 0,0,'桲',0,'桴','桵','桶','桷', 0,0,'桺',0,'桼',0,'桾','桿', */
	/* 6880 */ -1, 7, 9, 7,-1, 7,-1,-1, -1,-1,-1,-1,-1, 7,-1, 7, /* 0,'梁','梂','梃',0,'梅',0,0, 0,0,0,0,0,'梍',0,'梏', */
	/* 6890 */  9,-1,-1, 7, 7,-1, 9, 7,  9, 9, 9, 7, 9, 7,-1, 7, /* '梐',0,0,'梓','梔',0,'梖','梗', '梘','梙','梚','梛','梜','條',0,'梟', */
	/* 68a0 */  7,-1, 7, 7,-1, 7, 7, 7,  7,-1, 9, 9,-1, 7,-1, 7, /* '梠',0,'梢','梣',0,'梥','梦','梧', '梨',0,'梪','梫',0,'梭',0,'梯', */
	/* 68b0 */  7, 7, 7, 7, 9, 7, 7,-1, -1, 7, 7, 9, 7,-1,-1,-1, /* '械','梱','梲','梳','梴','梵','梶',0, 0,'梹','梺','梻','梼',0,0,0, */
	/* 68c0 */ -1,-1,-1, 9, 7, 9, 7,-1,  7, 7, 7, 7, 9, 7,-1, 9, /* 0,0,0,'棃','棄','棅','棆',0, '棈','棉','棊','棋','棌','棍',0,'棏', */
	/* 68d0 */  7,-1, 7,-1, 7, 7, 9, 7,  7, 9, 7,-1,-1,-1,-1, 7, /* '棐',0,'棒',0,'棔','棕','棖','棗', '棘','棙','棚',0,0,0,0,'棟', */
	/* 68e0 */  7, 7,-1, 7, 9, 9,-1, 7,  7,-1,-1,-1, 9, 7, 7, 7, /* '棠','棡',0,'棣','棤','棥',0,'棧', '棨',0,0,0,'棬','棭','森','棯', */
	/* 68f0 */  7, 7, 7,-1,-1,-1,-1, 9, -1, 7, 7, 9, 7,-1,-1,-1, /* '棰','棱','棲',0,0,0,0,'棷', 0,'棹','棺','棻','棼',0,0,0, */
	/* 6900 */  7, 7,-1, 9, 7, 7,-1, 9,  7,-1, 7, 7, 7, 7, 7, 7, /* '椀','椁',0,'椃','椄','椅',0,'椇', '椈',0,'椊','椋','椌','植','椎','椏', */
	/* 6910 */ -1,-1, 7,-1,-1,-1,-1,-1, -1, 7, 7, 7, 7,-1,-1,-1, /* 0,0,'椒',0,0,0,0,0, 0,'椙','椚','椛','検',0,0,0, */
	/* 6920 */ -1, 7, 7, 7,-1, 7, 7,-1,  7,-1, 7,-1,-1,-1,-1,-1, /* 0,'椡','椢','椣',0,'椥','椦',0, '椨',0,'椪',0,0,0,0,0, */
	/* 6930 */  7,-1,-1,-1, 7, 7, 7,-1, -1, 7,-1, 9,-1, 7,-1, 7, /* '椰',0,0,0,'椴','椵','椶',0, 0,'椹',0,'椻',0,'椽',0,'椿', */
	/* 6940 */ -1,-1, 7,-1,-1,-1, 9,-1, -1, 7, 7,-1,-1,-1,-1,-1, /* 0,0,'楂',0,0,0,'楆',0, 0,'楉','楊',0,0,0,0,0, */
	/* 6950 */ -1,-1,-1, 7, 7, 7,-1, 7, -1, 7, 7,-1, 7, 7, 7,-1, /* 0,0,0,'楓','楔','楕',0,'楗', 0,'楙','楚',0,'楜','楝','楞',0, */
	/* 6960 */  7, 7, 7, 7, 7,-1,-1,-1,  7, 9, 7, 7, 9, 7, 7, 7, /* '楠','楡','楢','楣','楤',0,0,0, '楨','楩','楪','楫','楬','業','楮','楯', */
	/* 6970 */ -1,-1, 9, 7, 7, 7,-1, 7,  7, 7, 9,-1, 7, 7, 7, 9, /* 0,0,'楲','楳','楴','極',0,'楷', '楸','楹','楺',0,'楼','楽','楾','楿', */
	/* 6980 */  7, 7, 7,-1,-1,-1,-1,-1, -1,-1, 7,-1,-1,-1, 7,-1, /* '榀','榁','概',0,0,0,0,0, 0,0,'榊',0,0,0,'榎',0, */
	/* 6990 */ -1, 7, 9,-1, 7, 7, 9,-1,  9,-1,-1, 7, 7,-1,-1,-1, /* 0,'榑','榒',0,'榔','榕','榖',0, '榘',0,0,'榛','榜',0,0,0, */
	/* 69a0 */  7,-1,-1,-1,-1, 7, 9, 7, -1,-1,-1,-1,-1, 7, 7,-1, /* '榠',0,0,0,0,'榥','榦','榧', 0,0,0,0,0,'榭','榮',0, */
	/* 69b0 */  9, 7, 7,-1, 7,-1,-1, 9, -1,-1, 9, 7, 9,-1, 7, 7, /* '榰','榱','榲',0,'榴',0,0,'榷', 0,0,'榺','榻','榼',0,'榾','榿', */
	/* 69c0 */  9, 7,-1, 7,-1,-1,-1, 7, -1,-1, 7, 7, 7, 7, 7, 7, /* '槀','槁',0,'槃',0,0,0,'槇', 0,0,'槊','構','槌','槍','槎','槏', */
	/* 69d0 */  7, 9,-1, 7,-1,-1, 9,-1,  7, 7,-1,-1,-1, 7, 7,-1, /* '槐','槑',0,'槓',0,0,'槖',0, '様','槙',0,0,0,'槝','槞',0, */
	/* 69e0 */ -1,-1, 7, 9,-1,-1,-1, 7,  7, 7, 7, 7,-1, 7, 9, 9, /* 0,0,'槢','槣',0,0,0,'槧', '槨','槩','槪','槫',0,'槭','槮','槯', */
	/* 69f0 */ -1,-1, 7, 9, 9, 7, 7,-1, -1, 7,-1, 7,-1, 7, 9, 7, /* 0,0,'槲','槳','槴','槵','槶',0, 0,'槹',0,'槻',0,'槽','槾','槿', */
	/* 6a00 */ -1,-1, 7,-1,-1, 7,-1,-1, -1,-1, 7, 7, 7,-1,-1, 7, /* 0,0,'樂',0,0,'樅',0,0, 0,0,'樊','樋','樌',0,0,'樏', */
	/* 6a10 */ -1, 9, 7, 7, 7, 7,-1, 7, -1, 7, 9, 7,-1, 9, 7, 7, /* 0,'樑','樒','樓','樔','樕',0,'樗', 0,'標','樚','樛',0,'樝','樞','樟', */
	/* 6a20 */ -1, 7, 7, 7,-1,-1,-1,-1, -1, 7, 7, 7,-1,-1, 7,-1, /* 0,'模','樢','樣',0,0,0,0, 0,'権','横','樫',0,0,'樮',0, */
	/* 6a30 */  9,-1, 9, 9, 9, 7, 7,-1,  7, 7, 7, 7,-1, 7, 7, 9, /* '樰',0,'樲','樳','樴','樵','樶',0, '樸','樹','樺','樻',0,'樽','樾','樿', */
	/* 6a40 */ -1,-1,-1,-1, 7, 7, 9, 7,  7, 9,-1, 7,-1,-1, 9,-1, /* 0,0,0,0,'橄','橅','橆','橇', '橈','橉',0,'橋',0,0,'橎',0, */
	/* 6a50 */  7,-1, 9,-1,-1,-1, 7,-1,  7, 7,-1, 7,-1,-1,-1, 7, /* '橐',0,'橒',0,0,0,'橖',0, '橘','橙',0,'橛',0,0,0,'機', */
	/* 6a60 */ -1, 7, 7,-1, 9,-1, 7,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,'橡','橢',0,'橤',0,'橦',0, 0,0,0,'橫',0,0,0,0, */
	/* 6a70 */ -1,-1, 7, 7,-1,-1,-1,-1,  7,-1, 9,-1,-1,-1, 9, 7, /* 0,0,'橲','橳',0,0,0,0, '橸',0,'橺',0,0,0,'橾','橿', */
	/* 6a80 */  7,-1,-1, 9, 7,-1,-1,-1, -1, 7,-1, 9,-1, 7, 7,-1, /* '檀',0,0,'檃','檄',0,0,0, 0,'檉',0,'檋',0,'檍','檎',0, */
	/* 6a90 */  7, 9,-1,-1, 7,-1,-1, 7, -1,-1,-1,-1, 7, 7, 7, 9, /* '檐','檑',0,0,'檔',0,0,'檗', 0,0,0,0,'檜','檝','檞','檟', */
	/* 6aa0 */  7, 9, 7, 7,-1, 7,-1,-1, -1,-1, 7, 9, 7,-1, 7,-1, /* '檠','檡','檢','檣',0,'檥',0,0, 0,0,'檪','檫','檬',0,'檮',0, */
	/* 6ab0 */ -1,-1,-1, 7,-1,-1,-1,-1,  7,-1,-1, 7,-1, 9,-1,-1, /* 0,0,0,'檳',0,0,0,0, '檸',0,0,'檻',0,'檽',0,0, */
	/* 6ac0 */ -1, 7, 7, 7,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'櫁','櫂','櫃',0,0,'櫆',0, 0,0,0,0,0,0,0,0, */
	/* 6ad0 */  9, 7,-1, 7, 9,-1,-1,-1, -1,-1, 7, 7, 9, 9, 7, 7, /* '櫐','櫑',0,'櫓','櫔',0,0,0, 0,0,'櫚','櫛','櫜','櫝','櫞','櫟', */
	/* 6ae0 */ -1,-1,-1,-1, 7,-1,-1, 7,  7,-1, 7,-1, 9,-1,-1,-1, /* 0,0,0,0,'櫤',0,0,'櫧', '櫨',0,'櫪',0,'櫬',0,0,0, */
	/* 6af0 */ -1, 9, 9, 9,-1,-1,-1,-1, -1,-1, 7, 7,-1, 9,-1,-1, /* 0,'櫱','櫲','櫳',0,0,0,0, 0,0,'櫺','櫻',0,'櫽',0,0, */
	/* 6b00 */ -1,-1,-1,-1, 7, 7,-1,-1, -1,-1, 7, 9,-1,-1,-1, 9, /* 0,0,0,0,'欄','欅',0,0, 0,0,'權','欋',0,0,0,'欏', */
	/* 6b10 */  9, 9, 7,-1,-1,-1, 7, 9, -1,-1,-1, 7,-1, 7, 7, 7, /* '欐','欑','欒',0,0,0,'欖','欗', 0,0,0,'欛',0,'欝','欞','欟', */
	/* 6b20 */  7, 7,-1, 7,-1,-1,-1, 7, -1,-1,-1,-1, 7,-1,-1, 9, /* '欠','次',0,'欣',0,0,0,'欧', 0,0,0,0,'欬',0,0,'欯', */
	/* 6b30 */ -1,-1, 7,-1,-1, 7,-1, 7,  7, 7, 7,-1,-1, 7, 7,-1, /* 0,0,'欲',0,0,'欵',0,'欷', '欸','欹','欺',0,0,'欽','款',0, */
	/* 6b40 */ -1,-1,-1, 7,-1,-1, 7, 7, -1, 7, 9,-1, 7,-1, 7,-1, /* 0,0,0,'歃',0,0,'歆','歇', 0,'歉','歊',0,'歌',0,'歎',0, */
	/* 6b50 */  7,-1,-1, 7, 7,-1, 7,-1,  9, 7,-1, 7,-1,-1,-1, 7, /* '歐',0,0,'歓','歔',0,'歖',0, '歘','歙',0,'歛',0,0,0,'歟', */
	/* 6b60 */  7, 7, 7, 7, 7, 7, 7, 7, -1, 7, 7,-1, 9,-1,-1, 7, /* '歠','歡','止','正','此','步','武','歧', 0,'歩','歪',0,'歬',0,0,'歯', */
	/* 6b70 */ -1,-1,-1, 7, 7, 9,-1, 7,  7, 7, 9, 7,-1,-1,-1, 7, /* 0,0,0,'歳','歴','歵',0,'歷', '歸','歹','歺','死',0,0,0,'歿', */
	/* 6b80 */  7, 9, 7, 7, 7,-1, 7,-1, -1, 7, 7, 7,-1, 7,-1,-1, /* '殀','殁','殂','殃','殄',0,'殆',0, 0,'殉','殊','残',0,'殍',0,0, */
	/* 6b90 */ -1,-1,-1,-1,-1, 7, 7,-1,  7,-1,-1, 9,-1,-1, 7,-1, /* 0,0,0,0,0,'殕','殖',0, '殘',0,0,'殛',0,0,'殞',0, */
	/* 6ba0 */ -1,-1,-1,-1, 7,-1,-1,-1, -1, 7, 7, 7,-1, 7, 9, 7, /* 0,0,0,0,'殤',0,0,0, 0,'殩','殪','殫',0,'殭','殮','殯', */
	/* 6bb0 */ -1, 7, 7, 7, 7, 7,-1, 7, -1,-1, 7, 7, 7, 9, 9, 7, /* 0,'殱','殲','殳','殴','段',0,'殷', 0,0,'殺','殻','殼','殽','殾','殿', */
	/* 6bc0 */  7,-1,-1,-1,-1, 7, 7, 9,  9, 9,-1, 7,-1, 7, 7, 7, /* '毀',0,0,0,0,'毅','毆','毇', '毈','毉',0,'毋',0,'母','毎','每', */
	/* 6bd0 */ -1,-1, 7, 7, 7,-1, 7, 7,  7,-1, 9, 7,-1,-1,-1, 7, /* 0,0,'毒','毓','比',0,'毖','毗', '毘',0,'毚','毛',0,0,0,'毟', */
	/* 6be0 */ -1,-1,-1,-1,-1,-1, 9, 9, -1,-1,-1, 7, 7,-1, 9, 7, /* 0,0,0,0,0,0,'毦','毧', 0,0,0,'毫','毬',0,'毮','毯', */
	/* 6bf0 */ -1, 9,-1, 7,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,'毱',0,'毳',0,0,0,0, 0,0,0,0,0,0,0,'毿', */
	/* 6c00 */ -1,-1, 9,-1,-1, 7,-1,-1,  7,-1, 9,-1,-1,-1, 9, 7, /* 0,0,'氂',0,0,'氅',0,0, '氈',0,'氊',0,0,0,'氎','氏', */
	/* 6c10 */  7, 7,-1, 7, 7,-1,-1, 7, -1,-1,-1, 7,-1,-1,-1,-1, /* '氐','民',0,'氓','气',0,0,'気', 0,0,0,'氛',0,0,0,0, */
	/* 6c20 */ -1,-1,-1, 7, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'氣','氤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c30 */ -1,-1,-1, 7, 7, 9, 9, 7,  7,-1, 9,-1,-1,-1, 7, 9, /* 0,0,0,'氳','水','氵','氶','氷', '永',0,'氺',0,0,0,'氾','氿', */
	/* 6c40 */  7, 7, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9, 7,-1, /* '汀','汁','求',0,0,0,0,0, 0,0,0,0,0,'汍','汎',0, */
	/* 6c50 */  7,-1,-1,-1,-1, 7,-1, 7, -1, 7, 7, 9, 7, 7, 7, 7, /* '汐',0,0,0,0,'汕',0,'汗', 0,'汙','汚','汛','汜','汝','汞','江', */
	/* 6c60 */  7,-1, 7,-1,-1,-1,-1, 9,  7,-1, 7,-1,-1, 9,-1,-1, /* '池',0,'汢',0,0,0,0,'汧', '汨',0,'汪',0,0,'汭',0,0, */
	/* 6c70 */  7,-1, 7, 7, 7,-1, 7,-1, -1,-1, 7,-1,-1, 7, 7,-1, /* '汰',0,'汲','汳','汴',0,'汶',0, 0,0,'決',0,0,'汽','汾',0, */
	/* 6c80 */ -1, 7, 7, 7, 9, 7, 7,-1,  7, 9,-1,-1, 7, 7,-1,-1, /* 0,'沁','沂','沃','沄','沅','沆',0, '沈','沉',0,0,'沌','沍',0,0, */
	/* 6c90 */  7,-1, 7, 7, 9, 9, 7, 9,  7, 7, 7, 7, 7,-1,-1,-1, /* '沐',0,'沒','沓','沔','沕','沖','沗', '沘','沙','沚','沛','沜',0,0,0, */
	/* 6ca0 */ -1, 7, 7,-1,-1,-1,-1,-1, -1,-1, 7, 7,-1, 9, 7,-1, /* 0,'没','沢',0,0,0,0,0, 0,0,'沪','沫',0,'沭','沮',0, */
	/* 6cb0 */ -1, 7,-1, 7,-1,-1,-1,-1,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,'沱',0,'河',0,0,0,0, '沸','油','沺','治','沼','沽','沾','沿', */
	/* 6cc0 */ -1, 7, 9,-1, 7, 7, 7,-1, -1, 7, 7,-1, 7,-1,-1,-1, /* 0,'況','泂',0,'泄','泅','泆',0, 0,'泉','泊',0,'泌',0,0,0, */
	/* 6cd0 */  9,-1,-1, 7, 7, 7, 9, 7, -1, 7, 9, 7, 9, 7,-1,-1, /* '泐',0,0,'泓','泔','法','泖','泗', 0,'泙','泚','泛','泜','泝',0,0, */
	/* 6ce0 */  7, 7, 7, 7,-1, 7,-1,-1,  7, 9, 7, 7, 9, 9, 7, 7, /* '泠','泡','波','泣',0,'泥',0,0, '注','泩','泪','泫','泬','泭','泮','泯', */
	/* 6cf0 */  7, 7,-1, 7,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* '泰','泱',0,'泳',0,0,0,0, 0,0,0,'泻',0,0,0,0, */
	/* 6d00 */  9,-1,-1,-1, 7,-1,-1,-1, -1,-1, 9, 7, 7,-1, 7,-1, /* '洀',0,0,0,'洄',0,0,0, 0,0,'洊','洋','洌',0,'洎',0, */
	/* 6d10 */ -1,-1, 7,-1,-1,-1,-1, 7, -1, 7,-1, 7,-1,-1, 7, 7, /* 0,0,'洒',0,0,0,0,'洗', 0,'洙',0,'洛',0,0,'洞','洟', */
	/* 6d20 */ -1,-1,-1,-1, 9, 7, 9, 9, -1, 7, 7, 7,-1,-1, 7, 9, /* 0,0,0,0,'洤','津','洦','洧', 0,'洩','洪','洫',0,0,'洮','洯', */
	/* 6d30 */ -1, 7, 7, 7, 9, 7, 7,-1,  7, 7,-1, 7, 9, 7, 7, 7, /* 0,'洱','洲','洳','洴','洵','洶',0, '洸','洹',0,'活','洼','洽','派','洿', */
	/* 6d40 */ -1, 7,-1,-1, 7, 7,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'流',0,0,'浄','浅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6d50 */ -1,-1,-1,-1,-1,-1,-1,-1,  7, 7, 7, 9, 7,-1, 9,-1, /* 0,0,0,0,0,0,0,0, '浘','浙','浚','浛','浜',0,'浞',0, */
	/* 6d60 */  9,-1,-1, 7, 7, 7, 7,-1, -1, 7, 7,-1, 7,-1, 7,-1, /* '浠',0,0,'浣','浤','浥','浦',0, 0,'浩','浪',0,'浬',0,'浮',0, */
	/* 6d70 */  9,-1,-1,-1, 7,-1,-1, 7,  7, 7,-1,-1,-1,-1,-1,-1, /* '浰',0,0,0,'浴',0,0,'海', '浸','浹',0,0,0,0,0,0, */
	/* 6d80 */  9, 9, 7,-1,-1, 7,-1, 7,  7, 7, 9,-1, 7, 9, 7,-1, /* '涀','涁','涂',0,0,'涅',0,'涇', '消','涉','涊',0,'涌','涍','涎',0, */
	/* 6d90 */ -1, 9,-1, 7, 7, 7,-1,-1,  9, 7,-1, 7, 7,-1,-1,-1, /* 0,'涑',0,'涓','涔','涕',0,0, '涘','涙',0,'涛','涜',0,0,0, */
	/* 6da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 7, 9, 7,-1, 9, 7, /* 0,0,0,0,0,0,0,0, 0,0,'涪','涫','涬',0,'涮','涯', */
	/* 6db0 */ -1,-1, 7,-1, 9, 7,-1,-1,  7,-1,-1,-1, 7,-1,-1, 7, /* 0,0,'液',0,'涴','涵',0,0, '涸',0,0,0,'涼',0,0,'涿', */
	/* 6dc0 */  7,-1, 9,-1, 7, 7, 7, 7,  9,-1,-1, 7, 7,-1, 9, 9, /* '淀',0,'淂',0,'淄','淅','淆','淇', '淈',0,0,'淋','淌',0,'淎','淏', */
	/* 6dd0 */  9, 7, 7,-1,-1, 7, 7,-1,  7, 7, 7, 7,-1, 7, 7, 9, /* '淐','淑','淒',0,0,'淕','淖',0, '淘','淙','淚','淛',0,'淝','淞','淟', */
	/* 6de0 */ -1, 7,-1,-1, 7,-1, 7,-1,  7, 9, 7, 7, 7,-1, 7,-1, /* 0,'淡',0,0,'淤',0,'淦',0, '淨','淩','淪','淫','淬',0,'淮',0, */
	/* 6df0 */ -1, 7,-1, 7,-1, 7, 9, 7, -1, 7, 7, 7, 7,-1,-1,-1, /* 0,'深',0,'淳',0,'淵','淶','混', 0,'淹','淺','添','淼',0,0,0, */
	/* 6e00 */ -1,-1,-1,-1,-1, 7,-1, 7,  7, 7, 7, 7,-1,-1,-1,-1, /* 0,0,0,0,0,'清',0,'渇', '済','渉','渊','渋',0,0,0,0, */
	/* 6e10 */ -1,-1,-1, 7,-1, 7,-1, 9, -1, 7, 7, 7,-1, 7, 9, 7, /* 0,0,0,'渓',0,'渕',0,'渗', 0,'渙','渚','減',0,'渝','渞','渟', */
	/* 6e20 */  7, 7, 9, 7, 7, 7, 7, 9, -1, 7,-1, 7, 7, 7, 7, 7, /* '渠','渡','渢','渣','渤','渥','渦','渧', 0,'温',0,'渫','測','渭','渮','港', */
	/* 6e30 */ -1,-1, 9,-1, 7,-1, 9,-1,  7,-1, 7,-1, 9,-1, 7,-1, /* 0,0,'渲',0,'渴',0,'渶',0, '游',0,'渺',0,'渼',0,'渾',0, */
	/* 6e40 */ -1,-1,-1, 7, 7,-1,-1,-1,  9, 9, 7, 9, 9, 7, 7, 9, /* 0,0,0,'湃','湄',0,0,0, '湈','湉','湊','湋','湌','湍','湎','湏', */
	/* 6e50 */ -1, 9,-1, 9, 9,-1, 7, 9,  7,-1,-1, 7, 7,-1, 7, 7, /* 0,'湑',0,'湓','湔',0,'湖','湗', '湘',0,0,'湛','湜',0,'湞','湟', */
	/* 6e60 */ -1,-1,-1, 9,-1,-1,-1, 7, -1,-1,-1, 7,-1,-1, 7, 7, /* 0,0,0,'湣',0,0,0,'湧', 0,0,0,'湫',0,0,'湮','湯', */
	/* 6e70 */ -1,-1, 7,-1,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,0,'湲',0,0,0,'湶',0, 0,0,0,0,0,0,'湾','湿', */
	/* 6e80 */  7,-1, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1, 7,-1,-1, 7, /* '満',0,'溂',0,0,0,0,0, 0,0,0,0,'溌',0,0,'溏', */
	/* 6e90 */  7,-1,-1, 9,-1,-1, 7,-1,  7,-1,-1,-1, 7, 7,-1, 7, /* '源',0,0,'溓',0,0,'準',0, '溘',0,0,0,'溜','溝',0,'溟', */
	/* 6ea0 */ -1,-1, 7,-1,-1, 7,-1, 9, -1,-1, 7, 7,-1,-1,-1, 7, /* 0,0,'溢',0,0,'溥',0,'溧', 0,0,'溪','溫',0,0,0,'溯', */
	/* 6eb0 */ -1, 7, 7,-1, 9,-1, 7, 7, -1,-1, 7,-1,-1, 7,-1, 9, /* 0,'溱','溲',0,'溴',0,'溶','溷', 0,0,'溺',0,0,'溽',0,'溿', */
	/* 6ec0 */ -1, 7, 7, 9, 7, 7,-1, 7, -1, 7, 9, 7, 7,-1, 7,-1, /* 0,'滁','滂','滃','滄','滅',0,'滇', 0,'滉','滊','滋','滌',0,'滎',0, */
	/* 6ed0 */ -1, 7,-1, 7, 7, 7,-1,-1, -1, 9,-1,-1,-1, 7, 7,-1, /* 0,'滑',0,'滓','滔','滕',0,0, 0,'滙',0,0,0,'滝','滞',0, */
	/* 6ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9, 7,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,'滫','滬',0,0,'滯', */
	/* 6ef0 */ -1,-1, 7,-1, 7,-1,-1, 7,  7, 9,-1, 9,-1,-1, 7, 7, /* 0,0,'滲',0,'滴',0,0,'滷', '滸','滹',0,'滻',0,0,'滾','滿', */
	/* 6f00 */ -1, 7, 7,-1,-1,-1, 7,-1, -1, 7, 9,-1, 9,-1,-1, 7, /* 0,'漁','漂',0,0,0,'漆',0, 0,'漉','漊',0,'漌',0,0,'漏', */
	/* 6f10 */  7, 7,-1, 7, 7, 7,-1,-1,  9,-1, 7,-1,-1,-1,-1,-1, /* '漐','漑',0,'漓','演','漕',0,0, '漘',0,'漚',0,0,0,0,0, */
	/* 6f20 */  7,-1, 7, 7,-1, 9,-1,-1, -1,-1, 7, 7, 7,-1,-1, 7, /* '漠',0,'漢','漣',0,'漥',0,0, 0,0,'漪','漫','漬',0,0,'漯', */
	/* 6f30 */ -1, 7, 7, 7,-1, 9, 9,-1,  7,-1,-1,-1, 9,-1, 7, 7, /* 0,'漱','漲','漳',0,'漵','漶',0, '漸',0,0,0,'漼',0,'漾','漿', */
	/* 6f40 */ -1, 7,-1,-1,-1, 7,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'潁',0,0,0,'潅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6f50 */ -1, 7, 9,-1, 7,-1,-1, 9,  7, 7, 9, 7, 7,-1, 7, 7, /* 0,'潑','潒',0,'潔',0,0,'潗', '潘','潙','潚','潛','潜',0,'潞','潟', */
	/* 6f60 */  9, 7, 7,-1, 7,-1, 7,-1,  9,-1,-1,-1,-1, 7, 7, 7, /* '潠','潡','潢',0,'潤',0,'潦',0, '潨',0,0,0,0,'潭','潮','潯', */
	/* 6f70 */  7,-1,-1,-1, 7,-1,-1,-1,  7,-1, 7,-1, 7, 9, 7,-1, /* '潰',0,0,0,'潴',0,0,0, '潸',0,'潺',0,'潼','潽','潾',0, */
	/* 6f80 */  7, 7, 7,-1, 7,-1, 7,-1,  7,-1,-1,-1, 7, 7, 7,-1, /* '澀','澁','澂',0,'澄',0,'澆',0, '澈',0,0,0,'澌','澍','澎',0, */
	/* 6f90 */  9, 7,-1,-1, 7,-1, 9, 7,  9,-1,-1,-1,-1,-1,-1, 9, /* '澐','澑',0,0,'澔',0,'澖','澗', '澘',0,0,0,0,0,0,'澟', */
	/* 6fa0 */  7, 7,-1, 7, 7, 9,-1, 7, -1,-1, 7,-1,-1,-1,-1, 9, /* '澠','澡',0,'澣','澤','澥',0,'澧', 0,0,'澪',0,0,0,0,'澯', */
	/* 6fb0 */ -1, 7,-1, 7,-1, 9, 7,-1, -1, 7,-1,-1, 7,-1, 9,-1, /* 0,'澱',0,'澳',0,'澵','澶',0, 0,'澹',0,0,'澼',0,'澾',0, */
	/* 6fc0 */  7, 7, 7, 7,-1,-1, 7, 7,  9, 9, 7,-1,-1,-1,-1,-1, /* '激','濁','濂','濃',0,0,'濆','濇', '濈','濉','濊',0,0,0,0,0, */
	/* 6fd0 */ -1,-1,-1,-1, 7, 7,-1,-1,  7,-1, 9, 7,-1,-1, 9, 7, /* 0,0,0,0,'濔','濕',0,0, '濘',0,'濚','濛',0,0,'濞','濟', */
	/* 6fe0 */  7, 7,-1,-1, 7,-1,-1,-1, -1, 9,-1, 7, 7,-1, 7, 7, /* '濠','濡',0,0,'濤',0,0,0, 0,'濩',0,'濫','濬',0,'濮','濯', */
	/* 6ff0 */  7, 7,-1, 7,-1, 7, 7,-1, -1, 7, 7,-1, 9,-1, 7,-1, /* '濰','濱',0,'濳',0,'濵','濶',0, 0,'濹','濺',0,'濼',0,'濾',0, */
	/* 7000 */  9, 7,-1,-1,-1, 7, 7, 9, -1, 7, 9, 7,-1,-1,-1, 7, /* '瀀','瀁',0,0,0,'瀅','瀆','瀇', 0,'瀉','瀊','瀋',0,0,0,'瀏', */
	/* 7010 */ -1, 7,-1,-1,-1, 7,-1,-1,  7,-1, 7, 7,-1, 7, 7, 7, /* 0,'瀑',0,0,0,'瀕',0,0, '瀘',0,'瀚','瀛',0,'瀝','瀞','瀟', */
	/* 7020 */ -1,-1,-1, 9,-1,-1, 7, 7,  7,-1,-1,-1, 7,-1,-1,-1, /* 0,0,0,'瀣',0,0,'瀦','瀧', '瀨',0,0,0,'瀬',0,0,0, */
	/* 7030 */  7,-1, 7,-1,-1,-1,-1,-1, -1, 9, 9,-1, 9,-1, 7,-1, /* '瀰',0,'瀲',0,0,0,0,0, 0,'瀹','瀺',0,'瀼',0,'瀾',0, */
	/* 7040 */ -1,-1,-1, 9,-1,-1,-1, 9, -1,-1, 7, 9, 7,-1, 7,-1, /* 0,0,0,'灃',0,0,0,'灇', 0,0,'灊','灋','灌',0,'灎',0, */
	/* 7050 */ -1, 7,-1,-1, 9,-1,-1,-1,  7,-1,-1,-1,-1, 7, 7,-1, /* 0,'灑',0,0,'灔',0,0,0, '灘',0,0,0,0,'灝','灞',0, */
	/* 7060 */ -1,-1,-1, 7, 7, 9,-1,-1, -1, 9,-1, 7, 9,-1, 9, 7, /* 0,0,0,'灣','灤','灥',0,0, 0,'灩',0,'火','灬',0,'灮','灯', */
	/* 7070 */  7,-1,-1,-1,-1, 7, 9,-1,  7,-1,-1,-1, 7, 7, 9,-1, /* '灰',0,0,0,0,'灵','灶',0, '灸',0,0,0,'灼','災','灾',0, */
	/* 7080 */ -1, 9,-1,-1,-1, 7, 9,-1, -1, 7, 7,-1,-1,-1, 7,-1, /* 0,'炁',0,0,0,'炅','炆',0, 0,'炉','炊',0,0,0,'炎',0, */
	/* 7090 */ -1,-1, 7,-1,-1, 9,-1, 9, -1, 7,-1,-1,-1,-1,-1, 9, /* 0,0,'炒',0,0,'炕',0,'炗', 0,'炙',0,0,0,0,0,'炟', */
	/* 70a0 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1, 7, 7, 7, 7, 7, /* 0,0,0,0,'炤',0,0,0, 0,0,0,'炫','炬','炭','炮','炯', */
	/* 70b0 */ -1, 9,-1, 7,-1,-1,-1, 7,  7, 7, 7, 9,-1,-1,-1,-1, /* 0,'炱',0,'炳',0,0,0,'炷', '炸','点','為','炻',0,0,0,0, */
	/* 70c0 */ -1,-1,-1,-1,-1,-1,-1,-1,  7,-1, 9, 7,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, '烈',0,'烊','烋',0,0,0,'烏', */
	/* 70d0 */ -1, 9,-1, 9, 7,-1,-1,-1,  7, 7,-1,-1, 9, 7,-1, 7, /* 0,'烑',0,'烓','烔',0,0,0, '烘','烙',0,0,'烜','烝',0,'烟', */
	/* 70e0 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,'烤',0,0,0, 0,0,0,0,'烬',0,0,0, */
	/* 70f0 */ -1, 7,-1,-1,-1,-1,-1,-1, -1, 7,-1,-1,-1, 7,-1,-1, /* 0,'烱',0,0,0,0,0,0, 0,'烹',0,0,0,'烽',0,0, */
	/* 7100 */ -1,-1,-1, 9, 9,-1, 9, 9,  9, 7,-1,-1, 9,-1,-1, 7, /* 0,0,0,'焃','焄',0,'焆','焇', '焈','焉',0,0,'焌',0,0,'焏', */
	/* 7110 */ -1,-1,-1,-1, 7,-1,-1,-1, -1, 7, 7,-1, 7,-1, 7,-1, /* 0,0,0,0,'焔',0,0,0, 0,'焙','焚',0,'焜',0,'焞',0, */
	/* 7120 */  7, 7,-1,-1,-1,-1, 7,-1, -1,-1,-1, 7,-1,-1, 7, 9, /* '焠','無',0,0,0,0,'焦',0, 0,0,0,'焫',0,0,'焮','焯', */
	/* 7130 */  7, 9,-1,-1,-1,-1, 7,-1, -1,-1,-1,-1, 7,-1,-1,-1, /* '焰','焱',0,0,0,0,'然',0, 0,0,0,0,'焼',0,0,0, */
	/* 7140 */ -1,-1,-1,-1,-1,-1, 7, 7, -1, 7, 9,-1, 7,-1, 7,-1, /* 0,0,0,0,0,0,'煆','煇', 0,'煉','煊',0,'煌',0,'煎',0, */
	/* 7150 */  9, 7, 7, 9,-1, 7, 7,-1, -1, 7,-1,-1, 7,-1, 9,-1, /* '煐','煑','煒','煓',0,'煕','煖',0, 0,'煙',0,0,'煜',0,'煞',0, */
	/* 7160 */  7,-1, 7,-1, 7, 7, 7, 7,  7, 7,-1,-1, 7,-1, 7,-1, /* '煠',0,'煢',0,'煤','煥','煦','照', '煨','煩',0,0,'煬',0,'煮',0, */
	/* 7170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'煽',0,0, */
	/* 7180 */  9,-1,-1,-1, 7, 7,-1, 7,  7,-1, 7,-1,-1,-1,-1, 7, /* '熀',0,0,0,'熄','熅',0,'熇', '熈',0,'熊',0,0,0,0,'熏', */
	/* 7190 */ -1,-1, 7,-1, 7, 7, 9,-1, -1, 7,-1, 9,-1,-1,-1, 7, /* 0,0,'熒',0,'熔','熕','熖',0, 0,'熙',0,'熛',0,0,0,'熟', */
	/* 71a0 */  9,-1, 9,-1,-1,-1,-1,-1,  7,-1,-1,-1, 7,-1, 9, 9, /* '熠',0,'熢',0,0,0,0,0, '熨',0,0,0,'熬',0,'熮','熯', */
	/* 71b0 */ -1, 7,-1, 9,-1,-1,-1,-1, -1, 7, 7,-1,-1,-1, 7,-1, /* 0,'熱',0,'熳',0,0,0,0, 0,'熹','熺',0,0,0,'熾',0, */
	/* 71c0 */ -1, 7,-1, 7, 7,-1,-1,-1,  7, 7,-1, 9,-1,-1, 7,-1, /* 0,'燁',0,'燃','燄',0,0,0, '燈','燉',0,'燋',0,0,'燎',0, */
	/* 71d0 */  7,-1, 7, 9, 7, 7,-1, 7, -1, 9,-1,-1, 9,-1,-1, 7, /* '燐',0,'燒','燓','燔','燕',0,'燗', 0,'燙',0,0,'燜',0,0,'營', */
	/* 71e0 */  7,-1,-1,-1,-1, 7, 7, 7, -1,-1,-1,-1, 7, 7, 7,-1, /* '燠',0,0,0,0,'燥','燦','燧', 0,0,0,0,'燬','燭','燮',0, */
	/* 71f0 */ -1,-1,-1,-1,-1, 7,-1,-1, -1, 7,-1, 7, 7,-1, 7, 7, /* 0,0,0,0,0,'燵',0,0, 0,'燹',0,'燻','燼',0,'燾','燿', */
	/* 7200 */  7,-1,-1,-1,-1,-1, 7, 9, -1,-1,-1,-1,-1, 7,-1,-1, /* '爀',0,0,0,0,0,'爆','爇', 0,0,0,0,0,'爍',0,0, */
	/* 7210 */  7,-1,-1,-1,-1, 7,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* '爐',0,0,0,0,'爕',0,0, 0,0,0,'爛',0,0,0,0, */
	/* 7220 */ -1,-1,-1,-1,-1,-1,-1,-1,  7,-1, 7, 9, 7, 7,-1,-1, /* 0,0,0,0,0,0,0,0, '爨',0,'爪','爫','爬','爭',0,0, */
	/* 7230 */  7,-1, 7,-1, 9, 7, 7,-1,  9, 9, 7, 7, 7, 7, 7, 7, /* '爰',0,'爲',0,'爴','爵','父',0, '爸','爹','爺','爻','爼','爽','爾','爿', */
	/* 7240 */  7,-1, 9,-1,-1,-1, 7, 7,  7,-1,-1, 7, 7,-1,-1,-1, /* '牀',0,'牂',0,0,0,'牆','片', '版',0,0,'牋','牌',0,0,0, */
	/* 7250 */ -1,-1, 7, 9,-1, 7, 7, 9,  7, 7,-1, 7,-1, 7,-1, 7, /* 0,0,'牒','牓',0,'牕','牖','牗', '牘','牙',0,'牛',0,'牝',0,'牟', */
	/* 7260 */ -1, 7, 7, 9,-1,-1,-1, 7, -1, 7,-1,-1,-1,-1, 9, 9, /* 0,'牡','牢','牣',0,0,0,'牧', 0,'物',0,0,0,0,'牮','牯', */
	/* 7270 */ -1,-1, 7,-1, 7,-1,-1,-1,  9, 7,-1,-1,-1, 7, 7, 9, /* 0,0,'牲',0,'牴',0,0,0, '牸','特',0,0,0,'牽','牾','牿', */
	/* 7280 */  7, 7, 7,-1,-1,-1,-1, 7, -1,-1,-1,-1,-1, 7, 9,-1, /* '犀','犁','犂',0,0,0,0,'犇', 0,0,0,0,0,'犍','犎',0, */
	/* 7290 */ -1,-1, 7,-1,-1,-1, 7,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,'犒',0,0,0,'犖',0, 0,0,0,'犛',0,0,0,0, */
	/* 72a0 */  7,-1, 7,-1,-1,-1,-1, 7, -1,-1,-1,-1, 7, 9, 9, 7, /* '犠',0,'犢',0,0,0,0,'犧', 0,0,0,0,'犬','犭','犮','犯', */
	/* 72b0 */  9, 9, 7,-1,-1,-1, 7,-1, -1, 7,-1,-1,-1,-1, 7,-1, /* '犰','犱','犲',0,0,0,'状',0, 0,'犹',0,0,0,0,'犾',0, */
	/* 72c0 */  7, 9, 7, 7, 7,-1, 7,-1, -1,-1,-1,-1, 9,-1, 7,-1, /* '狀','狁','狂','狃','狄',0,'狆',0, 0,0,0,0,'狌',0,'狎',0, */
	/* 72d0 */  7,-1, 7,-1,-1,-1,-1, 7, -1, 7,-1, 7,-1,-1,-1,-1, /* '狐',0,'狒',0,0,0,0,'狗', 0,'狙',0,'狛',0,0,0,0, */
	/* 72e0 */  7, 7, 7,-1,-1,-1,-1,-1, -1, 7,-1,-1, 7, 7,-1,-1, /* '狠','狡','狢',0,0,0,0,0, 0,'狩',0,0,'独','狭',0,0, */
	/* 72f0 */ -1,-1,-1, 9,-1,-1,-1, 7,  7, 7, 9, 7, 7, 7,-1,-1, /* 0,0,0,'狳',0,0,0,'狷', '狸','狹','狺','狻','狼','狽',0,0, */
	/* 7300 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'猇', 0,0,'猊',0,0,0,0,0, */
	/* 7310 */ -1,-1, 9,-1,-1,-1, 7, 7,  9, 9,-1, 7, 7, 7,-1, 7, /* 0,0,'猒',0,0,0,'猖','猗', '猘','猙',0,'猛','猜','猝',0,'猟', */
	/* 7320 */ -1,-1,-1,-1,-1, 7,-1, 7,  7, 7, 7, 7, 9,-1, 7, 7, /* 0,0,0,0,0,'猥',0,'猧', '猨','猩','猪','猫','猬',0,'献','猯', */
	/* 7330 */ -1, 9,-1, 9, 7,-1, 7, 7, -1, 9,-1,-1,-1, 9, 7, 7, /* 0,'猱',0,'猳','猴',0,'猶','猷', 0,'猹',0,0,0,'猽','猾','猿', */
	/* 7340 */ -1,-1,-1,-1, 7, 7,-1,-1, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,0,0,0,'獄','獅',0,0, 0,0,0,0,0,0,'獎','獏', */
	/* 7350 */  7,-1, 9,-1,-1,-1,-1, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* '獐',0,'獒',0,0,0,0,'獗', 0,0,0,0,0,0,0,0, */
	/* 7360 */ -1,-1,-1, 7,-1,-1, 7,-1,  7,-1, 7, 9, 9,-1, 9, 9, /* 0,0,0,'獣',0,0,'獦',0, '獨',0,'獪','獫','獬',0,'獮','獯', */
	/* 7370 */  7, 9, 7,-1,-1, 7,-1, 9,  7,-1, 7, 7, 7,-1,-1,-1, /* '獰','獱','獲',0,0,'獵',0,'獷', '獸',0,'獺','獻','獼',0,0,0, */
	/* 7380 */ -1, 9,-1,-1, 7, 9,-1, 7, -1, 7, 9, 7,-1,-1,-1,-1, /* 0,'玁',0,0,'玄','玅',0,'率', 0,'玉','玊','王',0,0,0,0, */
	/* 7390 */ -1,-1,-1,-1, 9, 7, 7,-1,  9,-1,-1,-1, 9,-1, 9, 7, /* 0,0,0,0,'玔','玕','玖',0, '玘',0,0,0,'玜',0,'玞','玟', */
	/* 73a0 */  7,-1, 7,-1,-1, 9, 7,-1,  9, 7,-1, 7,-1,-1,-1,-1, /* '玠',0,'玢',0,0,'玥','玦',0, '玨','玩',0,'玫',0,0,0,0, */
	/* 73b0 */ -1,-1, 7, 7,-1, 9,-1, 9, -1, 9,-1, 7, 9,-1,-1, 9, /* 0,0,'玲','玳',0,'玵',0,'玷', 0,'玹',0,'玻','玼',0,0,'玿', */
	/* 73c0 */  7,-1, 7,-1,-1, 9,-1,-1,  7, 7, 7, 9,-1, 7, 7, 7, /* '珀',0,'珂',0,0,'珅',0,0, '珈','珉','珊','珋',0,'珍','珎','珏', */
	/* 73d0 */ -1,-1,-1,-1,-1,-1, 7,-1, -1, 7,-1,-1,-1,-1, 7,-1, /* 0,0,0,0,0,0,'珖',0, 0,'珙',0,0,0,0,'珞',0, */
	/* 73e0 */  7, 9,-1, 7,-1, 7,-1, 9, -1, 7, 7,-1,-1, 7, 7,-1, /* '珠','珡',0,'珣',0,'珥',0,'珧', 0,'珩','珪',0,0,'班','珮',0, */
	/* 73f0 */ -1, 7,-1,-1,-1,-1,-1,-1,  7, 9, 9,-1,-1,-1, 7,-1, /* 0,'珱',0,0,0,0,0,0, '珸','珹','珺',0,0,0,'現',0, */
	/* 7400 */ -1, 9,-1, 7,-1, 7, 7, 7, -1, 7, 7,-1,-1,-1,-1,-1, /* 0,'琁',0,'球',0,'琅','理','琇', 0,'琉','琊',0,0,0,0,0, */
	/* 7410 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1, 7, 7,-1,-1,-1,-1, /* 0,0,0,'琓',0,0,0,0, 0,0,'琚','琛',0,0,0,0, */
	/* 7420 */ -1,-1, 7,-1, 9, 7, 7,-1,  7,-1, 7, 7, 7,-1, 7, 7, /* 0,0,'琢',0,'琤','琥','琦',0, '琨',0,'琪','琫','琬',0,'琮','琯', */
	/* 7430 */  7, 9, 7, 7, 7, 7, 7,-1, -1, 9, 7,-1,-1,-1,-1, 7, /* '琰','琱','琲','琳','琴','琵','琶',0, 0,'琹','琺',0,0,0,0,'琿', */
	/* 7440 */  9, 7,-1, 9, 7,-1, 7, 7, -1,-1,-1, 7,-1, 9,-1,-1, /* '瑀','瑁',0,'瑃','瑄',0,'瑆','瑇', 0,0,0,'瑋',0,'瑍',0,0, */
	/* 7450 */ -1,-1, 9, 9,-1, 7,-1, 7, -1, 7, 7, 7, 7, 9, 7, 7, /* 0,0,'瑒','瑓',0,'瑕',0,'瑗', 0,'瑙','瑚','瑛','瑜','瑝','瑞','瑟', */
	/* 7460 */  7,-1, 7, 7, 7,-1,-1,-1, -1, 7, 7, 7,-1, 7,-1, 7, /* '瑠',0,'瑢','瑣','瑤',0,0,0, 0,'瑩','瑪','瑫',0,'瑭',0,'瑯', */
	/* 7470 */  7, 9,-1, 7,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1, 7,-1, /* '瑰','瑱',0,'瑳',0,0,'瑶',0, 0,0,0,0,0,0,'瑾',0, */
	/* 7480 */ -1, 9,-1, 7,-1, 9, 7, 7,  9, 7,-1, 7,-1,-1,-1,-1, /* 0,'璁',0,'璃',0,'璅','璆','璇', '璈','璉',0,'璋',0,0,0,0, */
	/* 7490 */  7,-1, 9,-1,-1,-1,-1, 9,  7, 9,-1,-1, 7,-1, 7, 7, /* '璐',0,'璒',0,0,0,0,'璗', '璘','璙',0,0,'璜',0,'璞','璟', */
	/* 74a0 */  9, 9, 7, 7,-1, 9, 7, 7,  7, 7, 9, 9,-1,-1,-1,-1, /* '璠','璡','璢','璣',0,'璥','璦','璧', '璨','璩','璪','璫',0,0,0,0, */
	/* 74b0 */  7,-1,-1,-1,-1, 7,-1,-1, -1, 9, 9, 9,-1, 7,-1, 7, /* '環',0,0,0,0,'璵',0,0, 0,'璹','璺','璻',0,'璽',0,'璿', */
	/* 74c0 */ -1,-1,-1,-1,-1,-1,-1,-1,  7, 7, 7,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, '瓈','瓉','瓊',0,0,0,0,'瓏', */
	/* 74d0 */ -1,-1,-1,-1, 7,-1, 9,-1,  9,-1, 7,-1, 7,-1, 9,-1, /* 0,0,0,0,'瓔',0,'瓖',0, '瓘',0,'瓚',0,'瓜',0,'瓞',0, */
	/* 74e0 */  7,-1, 7, 7,-1,-1, 7, 7, -1, 7,-1, 9,-1,-1, 7, 9, /* '瓠',0,'瓢','瓣',0,0,'瓦','瓧', 0,'瓩',0,'瓫',0,0,'瓮','瓯', */
	/* 74f0 */  7, 7, 7,-1,-1,-1, 7, 7,  7,-1, 9,-1,-1,-1,-1, 7, /* '瓰','瓱','瓲',0,0,0,'瓶','瓷', '瓸',0,'瓺',0,0,0,0,'瓿', */
	/* 7500 */ -1, 7,-1, 7, 7, 7,-1,-1, -1,-1,-1,-1, 7, 7, 7,-1, /* 0,'甁',0,'甃','甄','甅',0,0, 0,0,0,0,'甌','甍','甎',0, */
	/* 7510 */ -1, 7,-1, 7,-1, 7,-1, 7,  7,-1, 7,-1, 7,-1, 7, 7, /* 0,'甑',0,'甓',0,'甕',0,'甗', '甘',0,'甚',0,'甜',0,'甞','生', */
	/* 7520 */  9,-1,-1, 7, 9, 7, 7,-1,  7,-1, 9, 7, 7,-1,-1, 7, /* '甠',0,0,'産','甤','甥','甦',0, '用',0,'甪','甫','甬',0,0,'甯', */
	/* 7530 */  7, 7, 7, 7,-1,-1,-1, 7,  7,-1, 7, 7, 7, 9, 9,-1, /* '田','由','甲','申',0,0,0,'男', '甸',0,'町','画','甼','甽','甾',0, */
	/* 7540 */  9,-1,-1,-1, 7,-1, 7,-1,  9, 7, 7, 7, 7, 7, 9, 7, /* '畀',0,0,0,'畄',0,'畆',0, '畈','畉','畊','畋','界','畍','畎','畏', */
	/* 7550 */  9, 7, 9,-1, 7,-1,-1,-1, -1, 7, 7, 7, 7, 7,-1,-1, /* '畐','畑','畒',0,'畔',0,0,0, 0,'留','畚','畛','畜','畝',0,0, */
	/* 7560 */  7,-1, 7,-1, 7, 7, 7, 7, -1, 7, 7, 7, 9, 7,-1, 7, /* '畠',0,'畢',0,'畤','略','畦','畧', 0,'畩','番','畫','畬','畭',0,'畯', */
	/* 7570 */  7, 9, 9, 7, 7,-1, 7, 7,  7, 7, 9,-1,-1, 9, 9, 7, /* '異','畱','畲','畳','畴',0,'當','畷', '畸','畹','畺',0,0,'畽','畾','畿', */
	/* 7580 */ -1, 9, 7,-1,-1,-1, 7, 7, -1, 7, 7, 7, 9,-1, 7, 7, /* 0,'疁','疂',0,0,0,'疆','疇', 0,'疉','疊','疋','疌',0,'疎','疏', */
	/* 7590 */ -1, 7, 7,-1, 7,-1,-1,-1, -1,-1, 7,-1,-1, 7,-1,-1, /* 0,'疑','疒',0,'疔',0,0,0, 0,0,'疚',0,0,'疝',0,0, */
	/* 75a0 */ -1,-1, 9, 7,-1, 7,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,'疢','疣',0,'疥',0,0, 0,0,0,'疫',0,0,0,0, */
	/* 75b0 */  9, 7, 7, 7,-1, 7,-1, 9,  7, 7,-1,-1, 7, 7, 7, 9, /* '疰','疱','疲','疳',0,'疵',0,'疷', '疸','疹',0,0,'疼','疽','疾','疿', */
	/* 75c0 */  9,-1, 7, 7,-1, 7, 9, 7, -1,-1, 7,-1,-1, 7, 7, 9, /* '痀',0,'痂','痃',0,'病','痆','症', 0,0,'痊',0,0,'痍','痎','痏', */
	/* 75d0 */ -1,-1, 7, 9, 7, 7,-1,-1,  7, 7,-1, 7,-1, 9, 7, 9, /* 0,0,'痒','痓','痔','痕',0,0, '痘','痙',0,'痛',0,'痝','痞','痟', */
	/* 75e0 */  9,-1, 7, 7, 7,-1,-1, 9, -1, 7,-1,-1, 9,-1, 9,-1, /* '痠',0,'痢','痣','痤',0,0,'痧', 0,'痩',0,0,'痬',0,'痮',0, */
	/* 75f0 */  7, 9, 7, 7, 7,-1,-1,-1, -1, 9, 7,-1, 7,-1, 7, 7, /* '痰','痱','痲','痳','痴',0,0,0, 0,'痹','痺',0,'痼',0,'痾','痿', */
	/* 7600 */  7, 7, 7, 9,-1,-1,-1, 9,  7, 7,-1, 7,-1, 7,-1, 9, /* '瘀','瘁','瘂','瘃',0,0,0,'瘇', '瘈','瘉',0,'瘋',0,'瘍',0,'瘏', */
	/* 7610 */ -1,-1,-1, 9,-1, 7, 7,-1,  9, 7,-1, 9, 9,-1, 7, 7, /* 0,0,0,'瘓',0,'瘕','瘖',0, '瘘','瘙',0,'瘛','瘜',0,'瘞','瘟', */
	/* 7620 */  7, 7, 7,-1, 7, 9,-1, 7,  9,-1,-1,-1,-1, 7,-1,-1, /* '瘠','瘡','瘢',0,'瘤','瘥',0,'瘧', '瘨',0,0,0,0,'瘭',0,0, */
	/* 7630 */  7,-1,-1, 9, 7, 7,-1,-1, -1,-1,-1, 7, 9,-1,-1,-1, /* '瘰',0,0,'瘳','瘴','瘵',0,0, 0,0,0,'瘻','瘼',0,0,0, */
	/* 7640 */ -1, 9, 7, 7,-1,-1, 7, 7,  7, 9,-1, 7, 7,-1,-1,-1, /* 0,'癁','療','癃',0,0,'癆','癇', '癈','癉',0,'癋','癌',0,0,0, */
	/* 7650 */ -1,-1, 7,-1,-1, 9, 7,-1,  7,-1,-1,-1, 7,-1,-1,-1, /* 0,0,'癒',0,0,'癕','癖',0, '癘',0,0,0,'癜',0,0,0, */
	/* 7660 */ -1, 7, 7,-1, 7, 7,-1, 7,  7, 7, 7,-1, 7, 7, 9, 7, /* 0,'癡','癢',0,'癤','癥',0,'癧', '癨','癩','癪',0,'癬','癭','癮','癯', */
	/* 7670 */  7, 7, 7,-1,-1,-1, 7,-1,  7,-1, 7, 7, 7, 7, 7,-1, /* '癰','癱','癲',0,0,0,'癶',0, '癸',0,'発','登','發','白','百',0, */
	/* 7680 */  7, 7,-1, 7, 7,-1, 7, 7,  7,-1,-1, 7,-1,-1, 7,-1, /* '皀','皁',0,'皃','的',0,'皆','皇', '皈',0,0,'皋',0,0,'皎',0, */
	/* 7690 */  7,-1,-1, 7,-1, 9, 7,-1, -1, 7, 7, 7, 9, 7, 7,-1, /* '皐',0,0,'皓',0,'皕','皖',0, 0,'皙','皚','皛','皜','皝','皞',0, */
	/* 76a0 */  9, 9,-1,-1,-1,-1, 7, 9,  9,-1, 7,-1,-1,-1, 7, 9, /* '皠','皡',0,0,0,0,'皦','皧', '皨',0,'皪',0,0,0,'皮','皯', */
	/* 76b0 */  7,-1,-1,-1, 7,-1, 7, 7,  7, 7, 7,-1,-1,-1,-1, 7, /* '皰',0,0,0,'皴',0,'皶','皷', '皸','皹','皺',0,0,0,0,'皿', */
	/* 76c0 */ -1,-1, 7, 7,-1, 7, 7,-1,  7, 9, 7,-1, 7, 7, 7,-1, /* 0,0,'盂','盃',0,'盅','盆',0, '盈','盉','益',0,'盌','盍','盎',0, */
	/* 76d0 */ -1,-1, 7,-1, 7,-1, 7, 7, -1,-1,-1, 7, 7,-1, 7, 7, /* 0,0,'盒',0,'盔',0,'盖','盗', 0,0,0,'盛','盜',0,'盞','盟', */
	/* 76e0 */ -1, 7,-1, 7, 7, 7, 7, 7,  9,-1, 7,-1, 9,-1, 7,-1, /* 0,'盡',0,'監','盤','盥','盦','盧', '盨',0,'盪',0,'盬',0,'目',0, */
	/* 76f0 */ -1, 7, 7,-1, 7,-1,-1,-1,  7,-1,-1, 7, 7,-1, 7,-1, /* 0,'盱','盲',0,'直',0,0,0, '相',0,0,'盻','盼',0,'盾',0, */
	/* 7700 */ -1, 7,-1,-1, 7,-1,-1, 7,  7, 7, 7, 7, 7,-1,-1,-1, /* 0,'省',0,0,'眄',0,0,'眇', '眈','眉','眊','看','県',0,0,0, */
	/* 7710 */ -1,-1,-1,-1,-1,-1,-1, 9, -1, 7, 9, 7,-1,-1, 7, 7, /* 0,0,0,0,0,0,0,'眗', 0,'眙','眚','眛',0,0,'眞','真', */
	/* 7720 */  7,-1,-1,-1, 7, 7, 7,-1, -1, 7,-1,-1,-1, 9,-1,-1, /* '眠',0,0,0,'眤','眥','眦',0, 0,'眩',0,0,0,'眭',0,0, */
	/* 7730 */ -1,-1,-1,-1, 7, 9, 7, 7,  7,-1, 7,-1, 7,-1,-1,-1, /* 0,0,0,0,'眴','眵','眶','眷', '眸',0,'眺',0,'眼',0,0,0, */
	/* 7740 */  7,-1,-1,-1,-1,-1, 7, 7, -1,-1,-1,-1,-1, 7, 7,-1, /* '着',0,0,0,0,0,'睆','睇', 0,0,0,0,0,'睍','睎',0, */
	/* 7750 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1, 7, 7, 7,-1,-1, 7, /* 0,0,0,0,0,0,0,0, '睘',0,'睚','睛','睜',0,0,'睟', */
	/* 7760 */  9, 7, 7, 7,-1, 7, 7,-1,  7,-1, 9, 7,-1,-1,-1,-1, /* '睠','睡','睢','督',0,'睥','睦',0, '睨',0,'睪','睫',0,0,0,0, */
	/* 7770 */ -1,-1, 9,-1,-1,-1,-1,-1, -1, 7, 7,-1, 9, 9, 7, 7, /* 0,0,'睲',0,0,0,0,0, 0,'睹','睺',0,'睼','睽','睾','睿', */
	/* 7780 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1, 7,-1, /* '瞀',0,0,0,0,0,0,0, 0,0,0,'瞋',0,0,'瞎',0, */
	/* 7790 */ -1, 7,-1,-1, 7,-1,-1,-1, -1,-1, 9,-1,-1,-1, 7, 9, /* 0,'瞑',0,0,'瞔',0,0,0, 0,0,'瞚',0,0,0,'瞞','瞟', */
	/* 77a0 */  7,-1, 9,-1, 9, 7,-1,-1, -1, 9, 7,-1, 7, 7,-1,-1, /* '瞠',0,'瞢',0,'瞤','瞥',0,0, 0,'瞩','瞪',0,'瞬','瞭',0,0, */
	/* 77b0 */  7,-1,-1, 7,-1,-1, 7,-1, -1, 7,-1, 7, 7, 7,-1, 7, /* '瞰',0,0,'瞳',0,0,'瞶',0, 0,'瞹',0,'瞻','瞼','瞽',0,'瞿', */
	/* 77c0 */ -1,-1,-1,-1,-1,-1,-1, 7, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,'矇', 0,0,0,0,0,'矍',0,0, */
	/* 77d0 */ -1,-1,-1,-1,-1,-1,-1, 7, -1,-1, 7, 7, 7,-1, 9, 9, /* 0,0,0,0,0,0,0,'矗', 0,0,'矚','矛','矜',0,'矞','矟', */
	/* 77e0 */  7,-1, 7, 7, 9, 7, 9, 7, -1, 7, 9,-1, 9, 7, 7, 7, /* '矠',0,'矢','矣','矤','知','矦','矧', 0,'矩','矪',0,'矬','短','矮','矯', */
	/* 77f0 */  9,-1,-1, 7, 9,-1,-1,-1, -1,-1,-1, 9, 7,-1,-1,-1, /* '矰',0,0,'石','矴',0,0,0, 0,0,0,'矻','矼',0,0,0, */
	/* 7800 */ -1,-1, 7,-1,-1, 9, 9,-1, -1, 9,-1,-1, 7, 9,-1,-1, /* 0,0,'砂',0,0,'砅','砆',0, 0,'砉',0,0,'砌','砍',0,0, */
	/* 7810 */ -1,-1, 7,-1, 7, 7,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,'砒',0,'研','砕',0,0, 0,'砙',0,0,0,0,0,0, */
	/* 7820 */  7, 9,-1,-1,-1, 7, 7, 7, -1,-1,-1,-1, 9, 7,-1,-1, /* '砠','砡',0,0,0,'砥','砦','砧', 0,0,0,0,'砬','砭',0,0, */
	/* 7830 */ -1,-1, 7,-1, 7,-1,-1,-1, -1,-1, 7,-1,-1,-1,-1, 7, /* 0,0,'砲',0,'破',0,0,0, 0,0,'砺',0,0,0,0,'砿', */
	/* 7840 */ -1,-1,-1, 7,-1, 7,-1, 9, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,0,0,'硃',0,'硅',0,'硇', 0,0,0,0,0,0,'硎','硏', */
	/* 7850 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,'硑',0,0,0,0,0,0, 0,0,0,0,0,'硝',0,0, */
	/* 7860 */ -1,-1,-1,-1, 9,-1,-1,-1,  7,-1, 9, 7, 7,-1, 7, 7, /* 0,0,0,0,'硤',0,0,0, '硨',0,'硪','硫','硬',0,'确','硯', */
	/* 7870 */ -1,-1, 7,-1, 7,-1,-1,-1, -1,-1,-1,-1, 7,-1,-1,-1, /* 0,0,'硲',0,'硴',0,0,0, 0,0,0,0,'硼',0,0,0, */
	/* 7880 */ -1, 7,-1,-1,-1,-1, 7, 7, -1,-1, 9,-1, 7, 7, 7,-1, /* 0,'碁',0,0,0,0,'碆','碇', 0,0,'碊',0,'碌','碍','碎',0, */
	/* 7890 */ -1, 7,-1, 7, 9, 7,-1, 7, -1,-1, 7,-1,-1, 9, 9, 9, /* 0,'碑',0,'碓','碔','碕',0,'碗', 0,0,'碚',0,0,'碝','碞','碟', */
	/* 78a0 */ -1,-1,-1, 7, 9,-1,-1, 7, -1, 7, 7,-1,-1, 7,-1, 7, /* 0,0,0,'碣','碤',0,0,'碧', 0,'碩','碪',0,0,'碭',0,'碯', */
	/* 78b0 */  7,-1,-1,-1,-1, 7,-1,-1, -1,-1, 7, 9, 7,-1, 7,-1, /* '碰',0,0,0,0,'碵',0,0, 0,0,'確','碻','碼',0,'碾',0, */
	/* 78c0 */ -1, 7,-1,-1,-1, 7, 7,-1,  9,-1, 7, 7, 9,-1, 9,-1, /* 0,'磁',0,0,0,'磅','磆',0, '磈',0,'磊','磋','磌',0,'磎',0, */
	/* 78d0 */  7, 7,-1,-1, 7, 9,-1,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* '磐','磑',0,0,'磔','磕',0,0, 0,0,'磚',0,0,0,0,0, */
	/* 78e0 */  9, 9,-1,-1, 7,-1, 9, 7,  7,-1,-1,-1, 7,-1,-1, 7, /* '磠','磡',0,0,'磤',0,'磦','磧', '磨',0,0,0,'磬',0,0,'磯', */
	/* 78f0 */ -1,-1, 7,-1, 7,-1,-1, 7, -1, 9, 9, 9,-1, 7, 9,-1, /* 0,0,'磲',0,'磴',0,0,'磷', 0,'磹','磺','磻',0,'磽','磾',0, */
	/* 7900 */  7, 7,-1,-1,-1,-1,-1, 7, -1,-1,-1,-1,-1,-1, 7,-1, /* '礀','礁',0,0,0,0,0,'礇', 0,0,0,0,0,0,'礎',0, */
	/* 7910 */  9, 7, 7,-1,-1,-1,-1,-1, -1, 7,-1, 9, 7,-1,-1,-1, /* '礐','礑','礒',0,0,0,0,0, 0,'礙',0,'礛','礜',0,0,0, */
	/* 7920 */ -1,-1,-1,-1,-1, 9, 7,-1, -1,-1, 7, 7, 7,-1, 7,-1, /* 0,0,0,0,0,'礥','礦',0, 0,0,'礪','礫','礬',0,'礮',0, */
	/* 7930 */  9, 7,-1,-1, 7,-1,-1,-1, -1,-1, 7, 9, 7,-1, 7,-1, /* '礰','礱',0,0,'礴',0,0,0, 0,0,'示','礻','礼',0,'社',0, */
	/* 7940 */  7, 7,-1,-1,-1, 7, 7, 7,  7, 7, 9,-1,-1,-1,-1,-1, /* '祀','祁',0,0,0,'祅','祆','祇', '祈','祉','祊',0,0,0,0,0, */
	/* 7950 */  7,-1,-1, 7,-1, 7, 7, 7,  9,-1, 7, 9, 7, 7, 7, 7, /* '祐',0,0,'祓',0,'祕','祖','祗', '祘',0,'祚','祛','祜','祝','神','祟', */
	/* 7960 */  7,-1, 7,-1,-1, 7,-1, 9,  7,-1,-1,-1,-1, 7,-1,-1, /* '祠',0,'祢',0,0,'祥',0,'祧', '票',0,0,0,0,'祭',0,0, */
	/* 7970 */ -1,-1, 9,-1,-1,-1,-1, 7, -1, 7, 7,-1,-1,-1,-1, 7, /* 0,0,'祲',0,0,0,0,'祷', 0,'祹','祺',0,0,0,0,'祿', */
	/* 7980 */  7, 7,-1,-1, 7, 7,-1,-1, -1,-1, 7,-1,-1, 7, 7, 7, /* '禀','禁',0,0,'禄','禅',0,0, 0,0,'禊',0,0,'禍','禎','福', */
	/* 7990 */ -1,-1,-1,-1, 9, 9, 9,-1,  7,-1,-1, 9,-1, 7,-1,-1, /* 0,0,0,0,'禔','禕','禖',0, '禘',0,0,'禛',0,'禝',0,0, */
	/* 79a0 */ -1, 9,-1,-1,-1,-1, 7, 7, -1, 9, 7,-1,-1,-1, 7,-1, /* 0,'禡',0,0,0,0,'禦','禧', 0,'禩','禪',0,0,0,'禮',0, */
	/* 79b0 */  7, 7,-1, 7, 9,-1,-1,-1,  7, 7, 7, 9,-1, 7, 7, 7, /* '禰','禱',0,'禳','禴',0,0,0, '禸','禹','禺','离',0,'禽','禾','禿', */
	/* 79c0 */  7, 7, 9,-1,-1,-1,-1, 9,  7, 7, 7, 7, 9, 9,-1,-1, /* '秀','私','秂',0,0,0,0,'秇', '秈','秉','秊','秋','秌','种',0,0, */
	/* 79d0 */ -1, 7, 7,-1, 7, 7, 9,-1,  7,-1,-1,-1,-1,-1, 7, 7, /* 0,'科','秒',0,'秔','秕','秖',0, '秘',0,0,0,0,0,'秞','租', */
	/* 79e0 */ -1, 7,-1, 7, 7,-1, 7, 7, -1, 7,-1, 7, 7, 7,-1,-1, /* 0,'秡',0,'秣','秤',0,'秦','秧', 0,'秩',0,'秫','秬','秭',0,0, */
	/* 79f0 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* '称',0,0,0,0,0,0,0, 0,0,0,'移',0,0,0,0, */
	/* 7a00 */  7,-1,-1, 7,-1,-1,-1,-1,  7,-1, 9, 7,-1, 7, 7,-1, /* '稀',0,0,'稃',0,0,0,0, '稈',0,'稊','程',0,'稍','税',0, */
	/* 7a10 */ -1, 9,-1,-1, 7, 9,-1, 7,  7, 7, 7, 9, 7,-1, 9, 7, /* 0,'稑',0,0,'稔','稕',0,'稗', '稘','稙','稚','稛','稜',0,'稞','稟', */
	/* 7a20 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9, 7,-1, /* '稠',0,0,0,0,0,0,0, 0,0,0,0,0,'稭','種',0, */
	/* 7a30 */ -1, 7, 7,-1,-1,-1,-1, 7,  9, 7,-1, 7, 7, 7, 7, 7, /* 0,'稱','稲',0,0,0,0,'稷', '稸','稹',0,'稻','稼','稽','稾','稿', */
	/* 7a40 */  7,-1, 7, 7,-1,-1, 7, 9, -1, 7,-1,-1, 9, 7, 7, 7, /* '穀',0,'穂','穃',0,0,'穆','穇', 0,'穉',0,0,'穌','積','穎','穏', */
	/* 7a50 */  7,-1,-1,-1,-1,-1, 9, 7, -1, 9,-1,-1, 9, 7,-1, 9, /* '穐',0,0,0,0,0,'穖','穗', 0,'穙',0,0,'穜','穝',0,'穟', */
	/* 7a60 */  9, 7, 7, 7,-1,-1,-1, 9, -1, 7, 9, 7,-1, 7,-1,-1, /* '穠','穡','穢','穣',0,0,0,'穧', 0,'穩','穪','穫',0,'穭',0,0, */
	/* 7a70 */  7,-1,-1,-1, 7, 9, 7,-1,  9, 7, 7,-1,-1, 7,-1, 7, /* '穰',0,0,0,'穴','穵','究',0, '穸','穹','空',0,0,'穽',0,'穿', */
	/* 7a80 */ -1, 7, 9, 7, 7, 7,-1,-1,  7,-1, 9,-1,-1,-1,-1,-1, /* 0,'突','窂','窃','窄','窅',0,0, '窈',0,'窊',0,0,0,0,0, */
	/* 7a90 */  9,-1, 7, 7,-1, 7, 7, 7,  7,-1,-1,-1,-1,-1,-1, 7, /* '窐',0,'窒','窓',0,'窕','窖','窗', '窘',0,0,0,0,0,0,'窟', */
	/* 7aa0 */  7,-1,-1, 9,-1,-1,-1,-1, -1, 7, 7,-1, 9,-1, 7, 7, /* '窠',0,0,'窣',0,0,0,0, 0,'窩','窪',0,'窬',0,'窮','窯', */
	/* 7ab0 */  7,-1,-1, 7,-1,-1, 7,-1, -1, 9, 7, 7, 9,-1, 9, 7, /* '窰',0,0,'窳',0,0,'窶',0, 0,'窹','窺','窻','窼',0,'窾','窿', */
	/* 7ac0 */ -1,-1,-1, 7, 7, 7,-1, 7,  7,-1, 7, 7, 9, 7, 7, 7, /* 0,0,0,'竃','竄','竅',0,'竇', '竈',0,'竊','立','竌','竍','竎','竏', */
	/* 7ad0 */ -1, 9, 7, 7,-1, 7,-1,-1, -1, 7, 7,-1, 7, 7,-1, 7, /* 0,'竑','竒','竓',0,'竕',0,0, 0,'站','竚',0,'竜','竝',0,'竟', */
	/* 7ae0 */  7, 7, 7, 7,-1, 7, 7, 9,  9,-1, 7, 7,-1, 7,-1, 7, /* '章','竡','竢','竣',0,'童','竦','竧', '竨',0,'竪','竫',0,'竭',0,'端', */
	/* 7af0 */  7,-1,-1,-1, 9,-1, 7,-1,  7, 7, 7,-1,-1, 7,-1, 7, /* '竰',0,0,0,'竴',0,'競',0, '竸','竹','竺',0,0,'竽',0,'竿', */
	/* 7b00 */ -1,-1, 7,-1, 7,-1, 7, 9,  7,-1, 7, 7,-1,-1,-1, 7, /* 0,0,'笂',0,'笄',0,'笆','笇', '笈',0,'笊','笋',0,0,0,'笏', */
	/* 7b10 */ -1, 7, 7,-1,-1,-1,-1,-1,  7, 7,-1, 7,-1,-1, 7,-1, /* 0,'笑','笒',0,0,0,0,0, '笘','笙',0,'笛',0,0,'笞',0, */
	/* 7b20 */  7,-1,-1,-1,-1, 7, 7, 9,  7,-1, 9,-1, 7, 7, 9, 9, /* '笠',0,0,0,0,'笥','符','笧', '笨',0,'笪',0,'第','笭','笮','笯', */
	/* 7b30 */ -1, 9,-1, 7,-1, 7, 7,-1, -1, 7,-1, 7,-1, 9,-1,-1, /* 0,'笱',0,'笳',0,'笵','笶',0, 0,'笹',0,'笻',0,'笽',0,0, */
	/* 7b40 */ -1, 9,-1,-1,-1, 7, 7, 7,  7, 7,-1, 7, 7, 7, 7, 7, /* 0,'筁',0,0,0,'筅','筆','筇', '筈','等',0,'筋','筌','筍','筎','筏', */
	/* 7b50 */  7, 7, 7,-1, 7, 9, 7,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* '筐','筑','筒',0,'答','筕','策',0, 0,0,0,0,0,'筝',0,0, */
	/* 7b60 */  7,-1,-1,-1, 9, 7, 9, 7, -1, 9,-1,-1, 7, 7, 7, 7, /* '筠',0,0,0,'筤','筥','筦','筧', 0,'筩',0,0,'筬','筭','筮','筯', */
	/* 7b70 */  7, 7, 7, 9, 7, 7,-1,-1, -1, 9, 7,-1,-1,-1,-1, 9, /* '筰','筱','筲','筳','筴','筵',0,0, 0,'筹','筺',0,0,0,0,'筿', */
	/* 7b80 */ -1,-1,-1,-1,-1,-1, 7, 7, -1,-1,-1, 7,-1, 7,-1, 7, /* 0,0,0,0,0,0,'箆','箇', 0,0,0,'箋',0,'箍',0,'箏', */
	/* 7b90 */  9, 9, 7,-1, 7, 7,-1, 7,  7, 7, 7, 9, 7, 7, 7, 7, /* '箐','箑','箒',0,'箔','箕',0,'算', '箘','箙','箚','箛','箜','箝','箞','箟', */
	/* 7ba0 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1, 7,-1,-1, 7,-1, 9, /* 0,'管',0,0,0,0,0,0, 0,0,'箪',0,0,'箭',0,'箯', */
	/* 7bb0 */ -1, 7,-1,-1, 7, 9,-1,-1,  7,-1,-1,-1, 9,-1,-1,-1, /* 0,'箱',0,0,'箴','箵',0,0, '箸',0,0,0,'箼',0,0,0, */
	/* 7bc0 */  7, 7,-1,-1, 7, 9, 7, 7, -1, 7, 9, 7, 7,-1,-1, 7, /* '節','篁',0,0,'範','篅','篆','篇', 0,'築','篊','篋','篌',0,0,'篏', */
	/* 7bd0 */ -1,-1,-1,-1, 9,-1, 9, 7, -1, 7, 9,-1,-1, 7,-1,-1, /* 0,0,0,0,'篔',0,'篖','篗', 0,'篙','篚',0,0,'篝',0,0, */
	/* 7be0 */  7,-1,-1,-1, 7, 7, 7,-1, -1, 7, 9,-1,-1, 7,-1,-1, /* '篠',0,0,0,'篤','篥','篦',0, 0,'篩','篪',0,0,'篭',0,0, */
	/* 7bf0 */  9,-1,-1, 7,-1,-1, 7, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* '篰',0,0,'篳',0,0,'篶','篷', 0,0,0,0,0,0,0,0, */
	/* 7c00 */  7, 7,-1, 9,-1,-1,-1, 7, -1,-1,-1, 9,-1, 7, 9, 9, /* '簀','簁',0,'簃',0,0,0,'簇', 0,0,0,'簋',0,'簍','簎','簏', */
	/* 7c10 */ -1, 7, 7, 7, 7,-1,-1, 7, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,'簑','簒','簓','簔',0,0,'簗', 0,0,0,0,0,0,'簞','簟', */
	/* 7c20 */  7, 7,-1, 7,-1,-1, 9, 7, -1,-1, 7, 7,-1,-1,-1,-1, /* '簠','簡',0,'簣',0,0,'簦','簧', 0,0,'簪','簫',0,0,0,0, */
	/* 7c30 */ -1, 7,-1, 7,-1,-1, 7, 7,  7,-1,-1,-1,-1, 7, 7, 7, /* 0,'簱',0,'簳',0,0,'簶','簷', '簸',0,0,0,0,'簽','簾','簿', */
	/* 7c40 */  7,-1,-1, 7,-1, 9,-1,-1, -1,-1, 9,-1, 7, 7,-1, 7, /* '籀',0,0,'籃',0,'籅',0,0, 0,0,'籊',0,'籌','籍',0,'籏', */
	/* 7c50 */  7, 9,-1,-1, 7,-1, 7, 9,  7, 7,-1,-1,-1,-1, 9, 7, /* '籐','籑',0,0,'籔',0,'籖','籗', '籘','籙',0,0,0,0,'籞','籟', */
	/* 7c60 */  7, 9,-1,-1, 7, 7,-1,-1, -1, 9,-1,-1, 7, 7, 9, 9, /* '籠','籡',0,0,'籤','籥',0,0, 0,'籩',0,0,'籬','籭','籮','籯', */
	/* 7c70 */  9,-1,-1, 7,-1, 7,-1,-1, -1, 7,-1,-1,-1,-1, 7,-1, /* '籰',0,0,'米',0,'籵',0,0, 0,'籹',0,0,0,0,'籾',0, */
	/* 7c80 */ -1, 7, 7, 7,-1,-1,-1,-1, -1, 7,-1, 7,-1, 7,-1, 7, /* 0,'粁','粂','粃',0,0,0,0, 0,'粉',0,'粋',0,'粍',0,'粏', */
	/* 7c90 */  7,-1, 7,-1, 7, 7,-1, 7,  7,-1,-1, 7,-1,-1,-1, 7, /* '粐',0,'粒',0,'粔','粕',0,'粗', '粘',0,0,'粛',0,0,0,'粟', */
	/* 7ca0 */  7, 7, 7,-1, 7, 7, 9, 7,  7,-1,-1, 7,-1, 7, 7,-1, /* '粠','粡','粢',0,'粤','粥','粦','粧', '粨',0,0,'粫',0,'粭','粮',0, */
	/* 7cb0 */ -1, 7, 7, 7,-1,-1, 9, 9, -1, 7,-1,-1, 7, 7, 7, 9, /* 0,'粱','粲','粳',0,0,'粶','粷', 0,'粹',0,0,'粼','粽','精','粿', */
	/* 7cc0 */  7,-1, 7,-1, 9, 7,-1,-1,  9,-1, 7,-1,-1, 9, 7,-1, /* '糀',0,'糂',0,'糄','糅',0,0, '糈',0,'糊',0,0,'糍','糎',0, */
	/* 7cd0 */ -1,-1, 7,-1,-1, 7, 7, 9,  7, 7,-1,-1, 7, 7, 7, 7, /* 0,0,'糒',0,0,'糕','糖','糗', '糘','糙',0,0,'糜','糝','糞','糟', */
	/* 7ce0 */  7,-1, 7,-1,-1,-1, 9, 7, -1,-1,-1, 9,-1,-1,-1, 7, /* '糠',0,'糢',0,0,0,'糦','糧', 0,0,0,'糫',0,0,0,'糯', */
	/* 7cf0 */ -1,-1, 7,-1, 7, 9, 7,-1,  7,-1, 7, 7,-1,-1, 7,-1, /* 0,0,'糲',0,'糴','糵','糶',0, '糸',0,'糺','系',0,0,'糾',0, */
	/* 7d00 */  7,-1, 7, 9, 7, 7, 7, 7,  7, 9, 7, 7,-1, 7,-1,-1, /* '紀',0,'紂','紃','約','紅','紆','紇', '紈','紉','紊','紋',0,'納',0,0, */
	/* 7d10 */  7,-1, 9, 7, 7, 7,-1, 7,  7, 7, 7, 7, 7, 7, 9,-1, /* '紐',0,'紒','紓','純','紕',0,'紗', '紘','紙','級','紛','紜','紝','紞',0, */
	/* 7d20 */  7, 7, 7, 7,-1,-1,-1,-1, -1,-1,-1, 7, 7,-1, 7, 7, /* '素','紡','索','紣',0,0,0,0, 0,0,0,'紫','紬',0,'紮','累', */
	/* 7d30 */  7, 7, 7, 7,-1, 7,-1,-1, -1, 7, 7,-1,-1, 9, 9, 7, /* '細','紱','紲','紳',0,'紵',0,0, 0,'紹','紺',0,0,'紽','紾','紿', */
	/* 7d40 */  9, 7, 7, 7, 7, 7, 7, 9,  7,-1,-1, 7, 7,-1, 7, 7, /* '絀','絁','終','絃','組','絅','絆','絇', '絈',0,0,'絋','経',0,'絎','絏', */
	/* 7d50 */  7,-1,-1, 7,-1,-1, 7,-1, -1, 9, 9, 7, 7,-1, 7,-1, /* '結',0,0,'絓',0,0,'絖',0, 0,'絙','絚','絛','絜',0,'絞',0, */
	/* 7d60 */ -1, 7, 7, 7,-1,-1, 7,-1,  7,-1, 9,-1,-1,-1, 7,-1, /* 0,'絡','絢','絣',0,0,'給',0, '絨',0,'絪',0,0,0,'絮',0, */
	/* 7d70 */  9, 7, 7, 7,-1, 7, 7,-1, -1, 7, 7,-1,-1, 7,-1, 9, /* '絰','統','絲','絳',0,'絵','絶',0, 0,'絹','絺',0,0,'絽',0,'絿', */
	/* 7d80 */ -1,-1,-1, 7,-1,-1, 9,-1,  9, 7,-1, 7, 9,-1,-1, 7, /* 0,0,0,'綃',0,0,'綆',0, '綈','綉',0,'綋','綌',0,0,'綏', */
	/* 7d90 */ -1,-1,-1, 7,-1,-1,-1, 9, -1, 7, 7, 7, 7, 9,-1, 7, /* 0,0,0,'經',0,0,0,'綗', 0,'継','続','綛','綜','綝',0,'綟', */
	/* 7da0 */  7,-1, 7, 7,-1,-1, 7, 9, -1,-1, 9, 7, 7, 7, 7, 7, /* '綠',0,'綢','綣',0,0,'綦','綧', 0,0,'綪','綫','綬','維','綮','綯', */
	/* 7db0 */  7, 7, 7,-1, 7, 7, 9, 9,  7,-1, 7, 7,-1, 7, 7, 7, /* '綰','綱','網',0,'綴','綵','綶','綷', '綸',0,'綺','綻',0,'綽','綾','綿', */
	/* 7dc0 */  9,-1, 7,-1,-1,-1,-1, 7, -1,-1, 7, 7, 7,-1,-1, 7, /* '緀',0,'緂',0,0,0,0,'緇', 0,0,'緊','緋','緌',0,0,'総', */
	/* 7dd0 */ -1, 7, 7,-1,-1, 7, 7, 9,  7, 9, 7,-1, 7, 7, 7,-1, /* 0,'緑','緒',0,0,'緕','緖','緗', '緘','緙','線',0,'緜','緝','緞',0, */
	/* 7de0 */  7, 7,-1, 7, 7,-1, 9,-1,  7, 7,-1,-1, 7,-1,-1, 7, /* '締','緡',0,'緣','緤',0,'緦',0, '編','緩',0,0,'緬',0,0,'緯', */
	/* 7df0 */ -1, 9, 7,-1, 7,-1,-1,-1, -1, 9,-1, 7,-1,-1,-1,-1, /* 0,'緱','緲',0,'練',0,0,0, 0,'緹',0,'緻',0,0,0,0, */
	/* 7e00 */ -1, 7,-1,-1, 7, 7,-1,-1,  7, 7, 7, 7,-1,-1,-1,-1, /* 0,'縁',0,0,'縄','縅',0,0, '縈','縉','縊','縋',0,0,0,0, */
	/* 7e10 */  9, 7, 7,-1,-1, 7,-1, 9, -1,-1,-1, 7,-1, 9, 7, 7, /* '縐','縑','縒',0,0,'縕',0,'縗', 0,0,0,'縛',0,'縝','縞','縟', */
	/* 7e20 */  9, 7, 7, 7,-1,-1, 7, 9,  7,-1,-1, 7, 9,-1, 7,-1, /* '縠','縡','縢','縣',0,0,'縦','縧', '縨',0,0,'縫','縬',0,'縮',0, */
	/* 7e30 */ -1, 7, 7,-1,-1, 7,-1, 7, -1, 7, 7, 7,-1, 7, 7,-1, /* 0,'縱','縲',0,0,'縵',0,'縷', 0,'縹','縺','縻',0,'總','績',0, */
	/* 7e40 */ -1, 7,-1, 7,-1, 9, 7, 7, -1,-1, 7, 7,-1, 7,-1,-1, /* 0,'繁',0,'繃',0,'繅','繆','繇', 0,0,'繊','繋',0,'繍',0,0, */
	/* 7e50 */ -1,-1, 7,-1, 7, 7, 7,-1, -1, 7, 7,-1,-1, 7, 7,-1, /* 0,0,'繒',0,'織','繕','繖',0, 0,'繙','繚',0,0,'繝','繞',0, */
	/* 7e60 */ -1, 7,-1,-1,-1,-1, 7, 7, -1, 7, 7,-1,-1, 7,-1,-1, /* 0,'繡',0,0,0,0,'繦','繧', 0,'繩','繪',0,0,'繭',0,0, */
	/* 7e70 */  7,-1,-1, 9,-1, 9,-1,-1, -1, 7,-1, 7, 7, 7, 9, 7, /* '繰',0,0,'繳',0,'繵',0,0, 0,'繹',0,'繻','繼','繽','繾','繿', */
	/* 7e80 */ -1,-1, 7, 7,-1,-1, 9, 9,  7, 7, 7,-1, 7, 7, 7, 7, /* 0,0,'纂','纃',0,0,'纆','纇', '纈','纉','纊',0,'續','纍','纎','纏', */
	/* 7e90 */  7, 9, 7, 7, 7,-1, 7,-1,  9,-1, 9, 7, 7,-1,-1,-1, /* '纐','纑','纒','纓','纔',0,'纖',0, '纘',0,'纚','纛','纜',0,0,0, */
	/* 7ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f30 */ -1,-1,-1,-1,-1,-1, 7,-1,  7,-1, 7, 9, 9,-1, 9,-1, /* 0,0,0,0,0,0,'缶',0, '缸',0,'缺','缻','缼',0,'缾',0, */
	/* 7f40 */ -1,-1,-1, 9, 9, 7,-1, 7, -1,-1,-1,-1, 7, 7, 7, 9, /* 0,0,0,'罃','罄','罅',0,'罇', 0,0,0,0,'罌','罍','罎','罏', */
	/* 7f50 */  7, 7, 9,-1, 7, 7,-1,-1,  7,-1,-1,-1,-1,-1,-1, 7, /* '罐','网','罒',0,'罔','罕',0,0, '罘',0,0,0,0,0,0,'罟', */
	/* 7f60 */  7, 9,-1, 9, 9,-1,-1, 7,  7, 7, 7, 7,-1, 9, 7,-1, /* '罠','罡',0,'罣','罤',0,0,'罧', '罨','罩','罪','罫',0,'罭','置',0, */
	/* 7f70 */  7,-1, 7,-1,-1, 7,-1, 7,  7, 7,-1,-1,-1, 9, 9,-1, /* '罰',0,'署',0,0,'罵',0,'罷', '罸','罹',0,0,0,'罽','罾',0, */
	/* 7f80 */ -1,-1, 7, 7,-1, 7, 7, 7,  7,-1, 7,-1, 7,-1, 7,-1, /* 0,0,'羂','羃',0,'羅','羆','羇', '羈',0,'羊',0,'羌',0,'美',0, */
	/* 7f90 */  9, 7,-1,-1, 7,-1, 9, 7, -1,-1, 7,-1, 9, 7, 7,-1, /* '羐','羑',0,0,'羔',0,'羖','羗', 0,0,'羚',0,'羜','羝','羞',0, */
	/* 7fa0 */ -1,-1,-1, 7, 7,-1,-1,-1,  7, 7,-1,-1,-1, 9, 7, 7, /* 0,0,0,'羣','群',0,0,0, '羨','義',0,0,0,'羭','羮','羯', */
	/* 7fb0 */ -1,-1, 7,-1,-1,-1, 7,-1,  7, 7,-1,-1,-1, 7,-1, 7, /* 0,0,'羲',0,0,0,'羶',0, '羸','羹',0,0,0,'羽',0,'羿', */
	/* 7fc0 */ -1, 7,-1, 9,-1, 7, 7,-1, -1,-1, 7,-1, 7,-1, 7, 9, /* 0,'翁',0,'翃',0,'翅','翆',0, 0,0,'翊',0,'翌',0,'翎','翏', */
	/* 7fd0 */ -1,-1, 7,-1, 7, 7,-1,-1, -1,-1,-1, 7,-1,-1,-1, 7, /* 0,0,'習',0,'翔','翕',0,0, 0,0,0,'翛',0,0,0,'翟', */
	/* 7fe0 */  7, 7,-1, 9,-1, 9, 7,-1, -1, 7,-1, 7, 7,-1, 7, 9, /* '翠','翡',0,'翣',0,'翥','翦',0, 0,'翩',0,'翫','翬',0,'翮','翯', */
	/* 7ff0 */  7,-1, 9, 7,-1,-1,-1,-1, -1, 7, 7, 7, 7,-1,-1,-1, /* '翰',0,'翲','翳',0,0,0,0, 0,'翹','翺','翻','翼',0,0,0, */
	/* 8000 */  7, 7, 9, 7, 7, 7, 7,-1,  9,-1, 9, 7, 7,-1, 9,-1, /* '耀','老','耂','考','耄','者','耆',0, '耈',0,'耊','耋','而',0,'耎',0, */
	/* 8010 */  7, 9, 7,-1, 7, 7, 9, 7,  7, 7,-1,-1, 7,-1,-1,-1, /* '耐','耑','耒',0,'耔','耕','耖','耗', '耘','耙',0,0,'耜',0,0,0, */
	/* 8020 */ -1, 7,-1,-1, 9,-1, 7,-1,  7,-1,-1,-1, 9,-1,-1,-1, /* 0,'耡',0,0,'耤',0,'耦',0, '耨',0,0,0,'耬',0,0,0, */
	/* 8030 */  9,-1,-1, 7,-1, 7, 7, 7, -1,-1,-1, 7, 7, 7,-1, 7, /* '耰',0,0,'耳',0,'耵','耶','耷', 0,0,0,'耻','耼','耽',0,'耿', */
	/* 8040 */ -1,-1,-1, 9,-1,-1, 7,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,0,0,'聃',0,0,'聆',0, 0,0,'聊',0,0,0,0,0, */
	/* 8050 */ -1,-1, 7,-1,-1,-1, 7,-1,  7,-1, 7,-1,-1,-1, 7, 7, /* 0,0,'聒',0,0,0,'聖',0, '聘',0,'聚',0,0,0,'聞','聟', */
	/* 8060 */ -1, 7, 7,-1,-1,-1, 9,-1,  7,-1,-1,-1,-1,-1,-1, 7, /* 0,'聡','聢',0,0,0,'聦',0, '聨',0,0,0,0,0,0,'聯', */
	/* 8070 */  7, 9, 7, 7, 7, 9, 7, 7, -1, 7,-1, 9,-1, 7, 7, 7, /* '聰','聱','聲','聳','聴','聵','聶','職', 0,'聹',0,'聻',0,'聽','聾','聿', */
	/* 8080 */ -1,-1,-1,-1, 7, 7, 7, 7, -1, 7,-1, 7, 7,-1,-1,-1, /* 0,0,0,0,'肄','肅','肆','肇', 0,'肉',0,'肋','肌',0,0,0, */
	/* 8090 */ -1,-1,-1, 7,-1,-1, 7,-1,  7, 9, 7, 7, 9, 7,-1,-1, /* 0,0,0,'肓',0,0,'肖',0, '肘','肙','肚','肛','肜','肝',0,0, */
	/* 80a0 */ -1, 7, 7,-1, 9, 7,-1, 9, -1, 7, 7,-1, 7, 7,-1, 7, /* 0,'股','肢',0,'肤','肥',0,'肧', 0,'肩','肪',0,'肬','肭',0,'肯', */
	/* 80b0 */ -1, 7, 7,-1, 7,-1,-1,-1,  9,-1, 7,-1,-1,-1,-1,-1, /* 0,'肱','育',0,'肴',0,0,0, '肸',0,'肺',0,0,0,0,0, */
	/* 80c0 */ -1,-1,-1, 7, 7, 9, 7,-1, -1,-1, 7,-1, 7,-1, 7,-1, /* 0,0,0,'胃','胄','胅','胆',0, 0,0,'胊',0,'背',0,'胎',0, */
	/* 80d0 */ -1,-1,-1,-1,-1, 9, 7, 7,  9, 7, 7, 7,-1, 7, 7,-1, /* 0,0,0,0,0,'胕','胖','胗', '胘','胙','胚','胛',0,'胝','胞',0, */
	/* 80e0 */  7, 7,-1,-1, 7, 7, 9,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* '胠','胡',0,0,'胤','胥','胦',0, 0,0,0,0,0,0,0,'胯', */
	/* 80f0 */ -1, 7,-1, 7, 7, 9,-1,-1,  7,-1,-1, 9, 7, 7,-1,-1, /* 0,'胱',0,'胳','胴','胵',0,0, '胸',0,0,'胻','胼','能',0,0, */
	/* 8100 */ -1,-1, 7,-1,-1, 7, 7, 7,  7, 7, 7,-1,-1, 9,-1,-1, /* 0,0,'脂',0,0,'脅','脆','脇', '脈','脉','脊',0,0,'脍',0,0, */
	/* 8110 */ -1,-1,-1,-1,-1,-1, 9,-1,  7,-1, 7, 7,-1,-1, 9,-1, /* 0,0,0,0,0,0,'脖',0, '脘',0,'脚','脛',0,0,'脞',0, */
	/* 8120 */ -1,-1,-1, 7, 9,-1,-1, 9, -1, 7,-1,-1, 9,-1,-1, 7, /* 0,0,0,'脣','脤',0,0,'脧', 0,'脩',0,0,'脬',0,0,'脯', */
	/* 8130 */ -1, 7,-1, 7,-1, 9,-1,-1, -1, 7,-1,-1,-1, 9, 7,-1, /* 0,'脱',0,'脳',0,'脵',0,0, 0,'脹',0,0,0,'脽','脾',0, */
	/* 8140 */ -1,-1,-1,-1,-1,-1, 7,-1, -1,-1, 7, 7,-1,-1, 7,-1, /* 0,0,0,0,0,0,'腆',0, 0,0,'腊','腋',0,0,'腎',0, */
	/* 8150 */  7, 7,-1, 7, 7, 7,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* '腐','腑',0,'腓','腔','腕',0,0, 0,0,0,0,0,0,0,'腟', */
	/* 8160 */  7,-1,-1,-1,-1, 7, 7, 7,  7, 9,-1, 7,-1, 7, 7,-1, /* '腠',0,0,0,0,'腥','腦','腧', '腨','腩',0,'腫',0,'腭','腮',0, */
	/* 8170 */  7, 7,-1,-1, 7,-1,-1,-1,  7, 7, 7,-1,-1,-1,-1, 7, /* '腰','腱',0,0,'腴',0,0,0, '腸','腹','腺',0,0,0,0,'腿', */
	/* 8180 */  7, 9, 7, 7, 9, 9,-1,-1,  7,-1, 7,-1,-1,-1,-1, 7, /* '膀','膁','膂','膃','膄','膅',0,0, '膈',0,'膊',0,0,0,0,'膏', */
	/* 8190 */ -1,-1,-1, 7,-1, 7,-1,-1,  9,-1, 7,-1, 7, 7,-1,-1, /* 0,0,0,'膓',0,'膕',0,0, '膘',0,'膚',0,'膜','膝',0,0, */
	/* 81a0 */  7,-1,-1, 7, 7,-1,-1,-1,  7, 7,-1,-1,-1,-1,-1,-1, /* '膠',0,0,'膣','膤',0,0,0, '膨','膩',0,0,0,0,0,0, */
	/* 81b0 */  7,-1, 9, 7,-1, 7,-1,-1,  7,-1, 7, 7,-1, 7, 7, 7, /* '膰',0,'膲','膳',0,'膵',0,0, '膸',0,'膺','膻',0,'膽','膾','膿', */
	/* 81c0 */  7, 9, 7, 9,-1,-1, 7,-1,  7, 7, 7,-1,-1, 7,-1, 7, /* '臀','臁','臂','臃',0,0,'臆',0, '臈','臉','臊',0,0,'臍',0,'臏', */
	/* 81d0 */ -1, 7,-1, 7,-1,-1, 9, 7,  7, 7, 7, 9,-1,-1,-1, 7, /* 0,'臑',0,'臓',0,0,'臖','臗', '臘','臙','臚','臛',0,0,0,'臟', */
	/* 81e0 */  7,-1,-1, 7, 9, 7,-1, 7,  7,-1, 7,-1, 9, 7,-1,-1, /* '臠',0,0,'臣','臤','臥',0,'臧', '臨',0,'自',0,'臬','臭',0,0, */
	/* 81f0 */ -1,-1,-1, 7, 7,-1,-1,-1, -1,-1, 7, 7, 7, 9, 7, 9, /* 0,0,0,'至','致',0,0,0, 0,0,'臺','臻','臼','臽','臾','臿', */
	/* 8200 */ -1, 7, 7,-1, 9, 7,-1, 7,  7, 7, 7,-1, 7, 7, 7,-1, /* 0,'舁','舂',0,'舄','舅',0,'與', '興','舉','舊',0,'舌','舍','舎',0, */
	/* 8210 */  7,-1, 7,-1,-1,-1, 7, 7,  7, 9,-1, 7, 7,-1, 7, 7, /* '舐',0,'舒',0,0,0,'舖','舗', '舘','舙',0,'舛','舜',0,'舞','舟', */
	/* 8220 */ -1, 9, 9,-1,-1,-1,-1,-1, -1, 7, 7, 7, 7,-1, 7,-1, /* 0,'舡','舢',0,0,0,0,0, 0,'舩','航','舫','般',0,'舮',0, */
	/* 8230 */ -1,-1, 9, 7, 9, 7, 7, 7,  7, 7,-1,-1, 9,-1,-1,-1, /* 0,0,'舲','舳','舴','舵','舶','舷', '舸','船',0,0,'舼',0,0,0, */
	/* 8240 */  7,-1,-1,-1,-1, 9, 9, 7, -1, 9,-1, 9,-1,-1,-1, 9, /* '艀',0,0,0,0,'艅','艆','艇', 0,'艉',0,'艋',0,0,0,'艏', */
	/* 8250 */ -1,-1,-1,-1,-1,-1,-1, 9,  7, 7, 7,-1, 9, 7,-1, 7, /* 0,0,0,0,0,0,0,'艗', '艘','艙','艚',0,'艜','艝',0,'艟', */
	/* 8260 */  7,-1, 7, 9, 7,-1, 7,-1,  7,-1, 7, 7,-1,-1, 7, 7, /* '艠',0,'艢','艣','艤',0,'艦',0, '艨',0,'艪','艫',0,0,'艮','良', */
	/* 8270 */ -1, 7, 7,-1, 7,-1, 7, 7,  7, 9,-1,-1,-1, 9, 7, 9, /* 0,'艱','色',0,'艴',0,'艶','艷', '艸','艹',0,0,0,'艽','艾','艿', */
	/* 8280 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1, 9, 7,-1, 7, 7,-1, /* 0,0,0,'芃',0,0,0,0, 0,0,'芊','芋',0,'芍','芎',0, */
	/* 8290 */ -1,-1, 7, 9,-1,-1,-1,-1, -1, 7,-1,-1,-1, 7,-1, 7, /* 0,0,'芒','芓',0,0,0,0, 0,'芙',0,0,0,'芝',0,'芟', */
	/* 82a0 */ -1, 7,-1, 7, 7, 7, 7, 9,  9, 7,-1, 7, 7, 7, 7, 7, /* 0,'芡',0,'芣','芤','芥','芦','芧', '芨','芩',0,'芫','芬','芭','芮','芯', */
	/* 82b0 */ -1, 7, 9, 7, 9,-1,-1, 7,  7, 7, 9, 7, 9, 7, 7, 7, /* 0,'花','芲','芳','芴',0,0,'芷', '芸','芹','芺','芻','芼','芽','芾','芿', */
	/* 82c0 */ -1,-1,-1,-1,-1, 7, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'苅','苆',0, 0,0,0,0,0,0,0,0, */
	/* 82d0 */ -1, 7, 7, 7, 7, 7,-1, 7, -1, 7,-1, 7, 7,-1, 7, 7, /* 0,'苑','苒','苓','苔','苕',0,'苗', 0,'苙',0,'苛','苜',0,'苞','苟', */
	/* 82e0 */ -1, 7, 9, 7,-1, 7, 7, 7,  9,-1,-1, 7,-1,-1,-1,-1, /* 0,'苡','苢','苣',0,'若','苦','苧', '苨',0,0,'苫',0,0,0,0, */
	/* 82f0 */ -1, 7,-1, 7, 7,-1,-1, 9, -1, 7, 7, 7,-1, 7, 7,-1, /* 0,'英',0,'苳','苴',0,0,'苷', 0,'苹','苺','苻',0,'苽','苾',0, */
	/* 8300 */  7, 7, 7, 7, 7, 7, 7, 9,  9, 7,-1,-1, 9,-1, 7,-1, /* '茀','茁','茂','范','茄','茅','茆','茇', '茈','茉',0,0,'茌',0,'茎',0, */
	/* 8310 */ -1,-1,-1,-1,-1,-1, 7, 7,  7,-1,-1, 9, 7, 9,-1,-1, /* 0,0,0,0,0,0,'茖','茗', '茘',0,0,'茛','茜','茝',0,0, */
	/* 8320 */ -1,-1, 7, 7,-1,-1,-1,-1,  7,-1,-1, 7,-1, 7,-1, 7, /* 0,0,'茢','茣',0,0,0,0, '茨',0,0,'茫',0,'茭',0,'茯', */
	/* 8330 */  9, 7, 7,-1, 7, 7, 7,-1,  7, 7, 7,-1, 9,-1,-1,-1, /* '茰','茱','茲',0,'茴','茵','茶',0, '茸','茹','茺',0,'茼',0,0,0, */
	/* 8340 */  7,-1,-1, 7, 9, 7,-1, 7, -1, 7, 7,-1,-1,-1,-1, 7, /* '荀',0,0,'荃','荄','荅',0,'荇', 0,'草','荊',0,0,0,0,'荏', */
	/* 8350 */  7, 7, 7,-1, 9, 7,-1, 9,  7,-1,-1,-1,-1,-1,-1,-1, /* '荐','荑','荒',0,'荔','荕',0,'荗', '荘',0,0,0,0,0,0,0, */
	/* 8360 */ -1,-1, 7, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'荢','荣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8370 */ -1,-1,-1, 7,-1, 7,-1, 7, -1,-1,-1, 7, 7, 7,-1, 9, /* 0,0,0,'荳',0,'荵',0,'荷', 0,0,0,'荻','荼','荽',0,'荿', */
	/* 8380 */ -1,-1,-1,-1,-1, 7, 7, 7, -1, 7, 7,-1,-1, 9, 7,-1, /* 0,0,0,0,0,'莅','莆','莇', 0,'莉','莊',0,0,'莍','莎',0, */
	/* 8390 */ -1,-1, 7, 7, 9, 9, 7,-1,  7,-1, 7, 9,-1, 9, 7, 7, /* 0,0,'莒','莓','莔','莕','莖',0, '莘',0,'莚','莛',0,'莝','莞','莟', */
	/* 83a0 */  7,-1, 7,-1,-1,-1,-1, 7,  7, 7, 7, 7,-1,-1,-1,-1, /* '莠',0,'莢',0,0,0,0,'莧', '莨','莩','莪','莫',0,0,0,0, */
	/* 83b0 */ -1, 7,-1,-1,-1, 7,-1,-1, -1,-1,-1,-1,-1, 7,-1, 7, /* 0,'莱',0,0,0,'莵',0,0, 0,0,0,0,0,'莽',0,'莿', */
	/* 83c0 */  7, 7,-1,-1,-1, 7,-1, 7, -1, 9, 7,-1, 7,-1, 7, 7, /* '菀','菁',0,0,0,'菅',0,'菇', 0,'菉','菊',0,'菌',0,'菎','菏', */
	/* 83d0 */  9, 7,-1, 7, 9,-1, 7,-1,  7,-1,-1,-1, 7, 9,-1, 7, /* '菐','菑',0,'菓','菔',0,'菖',0, '菘',0,0,0,'菜','菝',0,'菟', */
	/* 83e0 */  7, 7,-1,-1,-1, 9,-1,-1, -1, 7, 7, 7,-1,-1,-1, 7, /* '菠','菡',0,0,0,'菥',0,0, 0,'菩','菪','菫',0,0,0,'華', */
	/* 83f0 */  7, 7, 7,-1, 7,-1,-1, 7, -1, 9,-1, 7,-1, 7,-1,-1, /* '菰','菱','菲',0,'菴',0,0,'菷', 0,'菹',0,'菻',0,'菽',0,0, */
	/* 8400 */ -1, 7,-1, 7, 7,-1, 7, 7, -1,-1, 7, 7, 7, 7, 7, 9, /* 0,'萁',0,'萃','萄',0,'萆','萇', 0,0,'萊','萋','萌','萍','萎','萏', */
	/* 8410 */ -1, 9,-1, 7,-1, 9,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'萑',0,'萓',0,'萕',0,'萗', 0,0,0,0,0,0,0,0, */
	/* 8420 */  7,-1, 7,-1,-1,-1,-1,-1, -1, 7, 7,-1, 7,-1,-1,-1, /* '萠',0,'萢',0,0,0,0,0, 0,'萩','萪',0,'萬',0,0,0, */
	/* 8430 */ -1, 7,-1,-1,-1, 7,-1,-1,  7, 9,-1,-1, 7, 7,-1,-1, /* 0,'萱',0,0,0,'萵',0,0, '萸','萹',0,0,'萼','落',0,0, */
	/* 8440 */ -1,-1,-1,-1,-1,-1, 7,-1,  7, 7, 9,-1,-1,-1, 7, 9, /* 0,0,0,0,0,0,'葆',0, '葈','葉','葊',0,0,0,'葎','葏', */
	/* 8450 */ -1, 9, 9,-1,-1,-1,-1, 7, -1, 9, 9, 7, 9,-1,-1, 7, /* 0,'葑','葒',0,0,0,0,'著', 0,'葙','葚','葛','葜',0,0,'葟', */
	/* 8460 */ -1, 7, 7, 7,-1, 9, 7,-1, -1, 7,-1, 7, 7, 7, 7, 7, /* 0,'葡','葢','董',0,'葥','葦',0, 0,'葩',0,'葫','葬','葭','葮','葯', */
	/* 8470 */  7, 7,-1, 7,-1, 7, 9, 7,  9, 7, 7,-1, 9,-1,-1,-1, /* '葰','葱',0,'葳',0,'葵','葶','葷', '葸','葹','葺',0,'葼',0,0,0, */
	/* 8480 */ -1, 9, 7,-1, 7, 7,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,'蒁','蒂',0,'蒄','蒅',0,0, 0,0,0,'蒋',0,0,0,0, */
	/* 8490 */  7,-1,-1,-1, 7,-1,-1, 9, -1, 7,-1,-1, 7,-1, 7, 7, /* '蒐',0,0,0,'蒔',0,0,'蒗', 0,'蒙',0,0,'蒜',0,'蒞','蒟', */
	/* 84a0 */ -1, 7,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1, 7,-1, 7, /* 0,'蒡',0,0,0,0,'蒦',0, 0,0,0,0,0,'蒭',0,'蒯', */
	/* 84b0 */ -1,-1, 7,-1, 7,-1,-1,-1,  7, 7, 7, 7, 7,-1, 9, 7, /* 0,0,'蒲',0,'蒴',0,0,0, '蒸','蒹','蒺','蒻','蒼',0,'蒾','蒿', */
	/* 84c0 */  7, 7, 7,-1, 7,-1, 7,-1, -1, 7, 7, 7,-1, 7, 9, 9, /* '蓀','蓁','蓂',0,'蓄',0,'蓆',0, 0,'蓉','蓊','蓋',0,'蓍','蓎','蓏', */
	/* 84d0 */  7, 7,-1, 9,-1,-1, 7,-1, -1, 7, 7,-1, 9,-1,-1,-1, /* '蓐','蓑',0,'蓓',0,0,'蓖',0, 0,'蓙','蓚',0,'蓜',0,0,0, */
	/* 84e0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1, 9,-1, 7,-1, 7, 9, /* 0,0,0,0,0,0,0,'蓧', 0,0,'蓪',0,'蓬',0,'蓮','蓯', */
	/* 84f0 */  9, 9,-1,-1, 7,-1,-1,-1, -1,-1, 9,-1, 7, 9,-1, 7, /* '蓰','蓱',0,0,'蓴',0,0,0, 0,0,'蓺',0,'蓼','蓽',0,'蓿', */
	/* 8500 */  7,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* '蔀',0,0,0,0,0,'蔆',0, 0,0,0,0,'蔌',0,0,0, */
	/* 8510 */ -1, 7,-1, 7, 7, 7,-1, 7,  7,-1, 7, 9,-1,-1, 7, 7, /* 0,'蔑',0,'蔓','蔔','蔕',0,'蔗', '蔘',0,'蔚','蔛',0,0,'蔞','蔟', */
	/* 8520 */ -1, 7,-1, 7, 9, 9, 7,-1, -1,-1,-1, 9, 7, 7,-1, 7, /* 0,'蔡',0,'蔣','蔤','蔥','蔦',0, 0,0,0,'蔫','蔬','蔭',0,'蔯', */
	/* 8530 */ -1,-1, 7,-1, 9, 7,-1,-1, -1,-1,-1,-1,-1, 7, 9,-1, /* 0,0,'蔲',0,'蔴','蔵',0,0, 0,0,0,0,0,'蔽','蔾',0, */
	/* 8540 */  7, 7,-1, 7,-1,-1,-1,-1,  7, 7, 7, 7,-1,-1, 7, 9, /* '蕀','蕁',0,'蕃',0,0,0,0, '蕈','蕉','蕊','蕋',0,0,'蕎','蕏', */
	/* 8550 */ -1, 9,-1, 9,-1, 7,-1, 7,  7, 7, 7,-1,-1,-1, 9,-1, /* 0,'蕑',0,'蕓',0,'蕕',0,'蕗', '蕘','蕙','蕚',0,0,0,'蕞',0, */
	/* 8560 */ -1, 9, 9, 7, 7,-1,-1,-1,  7, 7, 7,-1,-1, 7,-1, 9, /* 0,'蕡','蕢','蕣','蕤',0,0,0, '蕨','蕩','蕪',0,0,'蕭',0,'蕯', */
	/* 8570 */ -1,-1,-1,-1,-1,-1,-1, 7, -1,-1, 7, 9,-1, 9, 7, 9, /* 0,0,0,0,0,0,0,'蕷', 0,0,'蕺','蕻',0,'蕽','蕾','蕿', */
	/* 8580 */  7, 9,-1,-1, 7,-1, 9, 7,  7,-1, 7,-1, 7,-1,-1, 7, /* '薀','薁',0,0,'薄',0,'薆','薇', '薈',0,'薊',0,'薌',0,0,'薏', */
	/* 8590 */  7, 7,-1, 9, 7,-1,-1, 7, -1, 7,-1, 7, 7, 9,-1, 9, /* '薐','薑',0,'薓','薔',0,0,'薗', 0,'薙',0,'薛','薜','薝',0,'薟', */
	/* 85a0 */ -1,-1, 7,-1, 7,-1, 7,-1,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,0,'薢',0,'薤',0,'薦',0, '薨','薩','薪','薫','薬','薭','薮','薯', */
	/* 85b0 */  7,-1,-1,-1,-1,-1,-1, 9, -1, 7, 7,-1, 9,-1,-1,-1, /* '薰',0,0,0,0,0,0,'薷', 0,'薹','薺',0,'薼',0,0,0, */
	/* 85c0 */ -1, 7,-1,-1,-1,-1,-1, 9, -1, 7, 9, 7,-1, 7, 7, 7, /* 0,'藁',0,0,0,0,0,'藇', 0,'藉','藊','藋',0,'藍','藎','藏', */
	/* 85d0 */  7,-1,-1,-1,-1, 7,-1,-1,  9, 9,-1,-1, 7, 7,-1, 9, /* '藐',0,0,0,0,'藕',0,0, '藘','藙',0,0,'藜','藝',0,'藟', */
	/* 85e0 */ -1, 9,-1,-1, 7, 7, 9,-1, -1, 7, 7,-1,-1, 7,-1,-1, /* 0,'藡',0,0,'藤','藥','藦',0, 0,'藩','藪',0,0,'藭',0,0, */
	/* 85f0 */ -1,-1,-1,-1,-1,-1, 9, 7, -1, 7, 7, 7,-1,-1, 7, 7, /* 0,0,0,0,0,0,'藶','藷', 0,'藹','藺','藻',0,0,'藾','藿', */
	/* 8600 */  9,-1, 7,-1, 7, 7, 7, 7, -1,-1, 7, 7,-1,-1,-1,-1, /* '蘀',0,'蘂',0,'蘄','蘅','蘆','蘇', 0,0,'蘊','蘋',0,0,0,0, */
	/* 8610 */  7, 9, 7, 7,-1,-1, 7, 7,  7,-1, 7,-1,-1,-1, 9,-1, /* '蘐','蘑','蘒','蘓',0,0,'蘖','蘗', '蘘',0,'蘚',0,0,0,'蘞',0, */
	/* 8620 */ -1, 9, 7,-1, 9,-1,-1, 9, -1, 7,-1,-1,-1, 7,-1, 7, /* 0,'蘡','蘢',0,'蘤',0,0,'蘧', 0,'蘩',0,0,0,'蘭',0,'蘯', */
	/* 8630 */  7,-1,-1,-1,-1,-1,-1,-1,  7, 9,-1,-1, 9,-1,-1, 7, /* '蘰',0,0,0,0,0,0,0, '蘸','蘹',0,0,'蘼',0,0,'蘿', */
	/* 8640 */  9, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7, 7,-1, /* '虀','虁',0,0,0,0,0,0, 0,0,0,0,0,'虍','虎',0, */
	/* 8650 */  7,-1,-1, 9, 7, 7, 9, 7, -1,-1, 7, 7, 7,-1, 7, 7, /* '虐',0,0,'虓','虔','處','虖','虗', 0,0,'虚','虛','虜',0,'虞','號', */
	/* 8660 */ -1,-1, 7,-1,-1,-1,-1, 7, -1,-1,-1, 7, 7,-1,-1, 9, /* 0,0,'虢',0,0,0,0,'虧', 0,0,0,'虫','虬',0,0,'虯', */
	/* 8670 */ -1, 7,-1,-1,-1, 7,-1, 9, -1, 7, 9, 7,-1,-1,-1,-1, /* 0,'虱',0,0,0,'虵',0,'虷', 0,'虹','虺','虻',0,0,0,0, */
	/* 8680 */ -1,-1,-1,-1,-1,-1,-1, 9, -1, 9, 7, 7, 7, 9,-1,-1, /* 0,0,0,0,0,0,0,'蚇', 0,'蚉','蚊','蚋','蚌','蚍',0,0, */
	/* 8690 */ -1, 9,-1, 7,-1, 7,-1,-1,  7,-1,-1,-1, 9, 9,-1,-1, /* 0,'蚑',0,'蚓',0,'蚕',0,0, '蚘',0,0,0,'蚜','蚝',0,0, */
	/* 86a0 */ -1,-1,-1, 7, 7,-1,-1,-1,  9, 7, 7, 7,-1,-1,-1, 7, /* 0,0,0,'蚣','蚤',0,0,0, '蚨','蚩','蚪','蚫',0,0,0,'蚯', */
	/* 86b0 */  7, 9,-1, 9,-1,-1, 7,-1,  7,-1,-1,-1,-1,-1,-1,-1, /* '蚰','蚱',0,'蚳',0,0,'蚶',0, '蚸',0,0,0,0,0,0,0, */
	/* 86c0 */ -1, 9,-1, 9, 7,-1, 7, 7, -1, 7,-1, 7,-1, 7, 7,-1, /* 0,'蛁',0,'蛃','蛄',0,'蛆','蛇', 0,'蛉',0,'蛋',0,'蛍','蛎',0, */
	/* 86d0 */ -1, 9,-1,-1, 7, 9,-1, 9, -1, 7,-1, 7,-1,-1, 7, 7, /* 0,'蛑',0,0,'蛔','蛕',0,'蛗', 0,'蛙',0,'蛛',0,0,'蛞','蛟', */
	/* 86e0 */ -1,-1,-1, 9, 7,-1, 9,-1, -1, 7,-1,-1, 7, 7, 7, 7, /* 0,0,0,'蛣','蛤',0,'蛦',0, 0,'蛩',0,0,'蛬','蛭','蛮','蛯', */
	/* 86f0 */ -1,-1,-1,-1,-1,-1,-1,-1,  7, 7, 7, 7, 7, 7, 7,-1, /* 0,0,0,0,0,0,0,0, '蛸','蛹','蛺','蛻','蛼','蛽','蛾',0, */
	/* 8700 */  7,-1, 7, 7,-1, 9, 7, 9,  7, 7, 7, 7,-1, 7, 9,-1, /* '蜀',0,'蜂','蜃',0,'蜅','蜆','蜇', '蜈','蜉','蜊','蜋',0,'蜍','蜎',0, */
	/* 8710 */  9, 7, 7, 9,-1,-1,-1,-1,  7, 9, 7,-1, 7,-1,-1, 9, /* '蜐','蜑','蜒','蜓',0,0,0,0, '蜘','蜙','蜚',0,'蜜',0,0,'蜟', */
	/* 8720 */ -1, 9,-1, 9,-1, 7,-1,-1, -1, 7,-1,-1,-1,-1,-1,-1, /* 0,'蜡',0,'蜣',0,'蜥',0,0, 0,'蜩',0,0,0,0,0,0, */
	/* 8730 */ -1, 9,-1,-1, 7,-1,-1, 7, -1,-1, 9, 7,-1,-1, 9, 7, /* 0,'蜱',0,0,'蜴',0,0,'蜷', 0,0,'蜺','蜻',0,0,'蜾','蜿', */
	/* 8740 */  9,-1,-1, 9,-1,-1,-1,-1, -1, 7,-1, 7, 7,-1, 7,-1, /* '蝀',0,0,'蝃',0,0,0,0, 0,'蝉',0,'蝋','蝌',0,'蝎',0, */
	/* 8750 */ -1, 9,-1, 7,-1, 7,-1, 7,  9, 7,-1,-1,-1,-1,-1, 7, /* 0,'蝑',0,'蝓',0,'蝕',0,'蝗', '蝘','蝙',0,0,0,0,0,'蝟', */
	/* 8760 */  7,-1,-1, 7, 9, 9, 7,-1,  7,-1, 7,-1,-1,-1, 7,-1, /* '蝠',0,0,'蝣','蝤','蝥','蝦',0, '蝨',0,'蝪',0,0,0,'蝮',0, */
	/* 8770 */ -1, 7, 9,-1, 7,-1, 7,-1,  7,-1,-1,-1, 9,-1,-1, 7, /* 0,'蝱','蝲',0,'蝴',0,'蝶',0, '蝸',0,0,0,'蝼',0,0,'蝿', */
	/* 8780 */ -1,-1, 7,-1,-1,-1,-1, 7,  7, 9,-1, 9,-1, 7,-1,-1, /* 0,0,'螂',0,0,0,0,'螇', '螈','螉',0,'螋',0,'融',0,0, */
	/* 8790 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,'螓',0,0,0,0, 0,0,0,0,0,0,0,'螟', */
	/* 87a0 */  9,-1, 7,-1,-1,-1,-1, 9, -1,-1,-1, 7, 7, 7,-1, 7, /* '螠',0,'螢',0,0,0,0,'螧', 0,0,0,'螫','螬','螭',0,'螯', */
	/* 87b0 */ -1,-1,-1, 7,-1, 7,-1,-1, -1,-1, 7, 7,-1, 7, 9,-1, /* 0,0,0,'螳',0,'螵',0,0, 0,0,'螺','螻',0,'螽','螾',0, */
	/* 87c0 */  7, 9,-1,-1, 7,-1, 7, 7, -1,-1,-1, 7,-1,-1, 9,-1, /* '蟀','蟁',0,0,'蟄',0,'蟆','蟇', 0,0,0,'蟋',0,0,'蟎',0, */
	/* 87d0 */  7,-1, 7,-1,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* '蟐',0,'蟒',0,0,0,'蟖',0, 0,0,0,0,0,0,0,'蟟', */
	/* 87e0 */  7,-1,-1, 9,-1, 9, 9,-1, -1,-1, 9, 9, 7, 9,-1, 7, /* '蟠',0,0,'蟣',0,'蟥','蟦',0, 0,0,'蟪','蟫','蟬','蟭',0,'蟯', */
	/* 87f0 */ -1,-1, 7,-1,-1, 9, 7, 7, -1, 7,-1, 7,-1,-1, 7,-1, /* 0,0,'蟲',0,0,'蟵','蟶','蟷', 0,'蟹',0,'蟻',0,0,'蟾',0, */
	/* 8800 */ -1, 9,-1, 9,-1, 7, 7,-1, -1,-1, 7, 9,-1, 7, 7, 7, /* 0,'蠁',0,'蠃',0,'蠅','蠆',0, 0,0,'蠊','蠋',0,'蠍','蠎','蠏', */
	/* 8810 */  7, 7,-1, 9, 7, 7, 7,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* '蠐','蠑',0,'蠓','蠔','蠕','蠖',0, 0,0,0,0,0,0,0,'蠟', */
	/* 8820 */ -1, 7, 7, 7,-1,-1,-1, 7,  9,-1,-1,-1,-1,-1, 9,-1, /* 0,'蠡','蠢','蠣',0,0,0,'蠧', '蠨',0,0,0,0,0,'蠮',0, */
	/* 8830 */ -1, 7, 9,-1,-1,-1, 7,-1, -1, 7,-1, 7, 9,-1,-1,-1, /* 0,'蠱','蠲',0,0,0,'蠶',0, 0,'蠹',0,'蠻','蠼',0,0,0, */
	/* 8840 */  7,-1, 7,-1, 7,-1, 7,-1, -1,-1, 9,-1, 7, 7,-1,-1, /* '血',0,'衂',0,'衄',0,'衆',0, 0,0,'衊',0,'行','衍',0,0, */
	/* 8850 */ -1,-1, 7, 7,-1,-1,-1, 7,  9, 7,-1, 7,-1, 7, 7, 9, /* 0,0,'衒','術',0,0,0,'街', '衘','衙',0,'衛',0,'衝','衞','衟', */
	/* 8860 */ -1, 7, 7, 7, 9,-1,-1,-1,  7, 9,-1, 7,-1,-1,-1, 9, /* 0,'衡','衢','衣','衤',0,0,0, '表','衩',0,'衫',0,0,0,'衯', */
	/* 8870 */  7,-1, 7,-1,-1, 7,-1, 7, -1,-1,-1,-1,-1, 7, 7, 7, /* '衰',0,'衲',0,0,'衵',0,'衷', 0,0,0,0,0,'衽','衾','衿', */
	/* 8880 */ -1, 7, 7,-1,-1,-1,-1,-1,  7,-1,-1, 7,-1, 7,-1,-1, /* 0,'袁','袂',0,0,0,0,0, '袈',0,0,'袋',0,'袍',0,0, */
	/* 8890 */ -1,-1, 7,-1,-1,-1, 7, 7,  7, 7,-1,-1,-1,-1, 7,-1, /* 0,0,'袒',0,0,0,'袖','袗', '袘','袙',0,0,0,0,'袞',0, */
	/* 88a0 */  9,-1, 7,-1, 7,-1,-1,-1, -1,-1, 7, 7,-1,-1, 7,-1, /* '袠',0,'袢',0,'袤',0,0,0, 0,0,'袪','被',0,0,'袮',0, */
	/* 88b0 */  7, 7,-1,-1, 7, 7,-1, 7, -1,-1,-1,-1, 9, 9, 9, 7, /* '袰','袱',0,0,'袴','袵',0,'袷', 0,0,0,0,'袼','袽','袾','袿', */
	/* 88c0 */  9, 7, 7, 7, 7, 7,-1,-1, -1,-1, 7,-1,-1,-1, 7, 7, /* '裀','裁','裂','裃','裄','装',0,0, 0,0,'裊',0,0,0,'裎','裏', */
	/* 88d0 */ -1, 9, 9, 9, 7, 7,-1,-1,  7, 7,-1, 9, 7, 7,-1, 7, /* 0,'裑','裒','裓','裔','裕',0,0, '裘','裙',0,'裛','補','裝',0,'裟', */
	/* 88e0 */ -1, 7,-1,-1,-1,-1,-1,-1,  7,-1,-1,-1,-1,-1,-1,-1, /* 0,'裡',0,0,0,0,0,0, '裨',0,0,0,0,0,0,0, */
	/* 88f0 */  9, 9, 7, 7, 7, 7,-1,-1,  7, 7,-1,-1, 7, 7, 7,-1, /* '裰','裱','裲','裳','裴','裵',0,0, '裸','裹',0,0,'裼','製','裾',0, */
	/* 8900 */ -1, 9, 7,-1, 7,-1,-1, 7, -1,-1, 7,-1, 7,-1,-1,-1, /* 0,'褁','褂',0,'褄',0,0,'複', 0,0,'褊',0,'褌',0,0,0, */
	/* 8910 */  7,-1, 7, 7,-1,-1,-1,-1,  7, 7, 7,-1, 7, 7, 7,-1, /* '褐',0,'褒','褓',0,0,0,0, '褘','褙','褚',0,'褜','褝','褞',0, */
	/* 8920 */ -1,-1,-1,-1,-1, 7,-1, 7, -1,-1, 7, 7,-1,-1,-1,-1, /* 0,0,0,0,0,'褥',0,'褧', 0,0,'褪','褫',0,0,0,0, */
	/* 8930 */  7,-1, 7,-1,-1,-1, 7, 9,  7, 7,-1, 7,-1,-1,-1,-1, /* '褰',0,'褲',0,0,0,'褶','褷', '褸','褹',0,'褻',0,0,0,0, */
	/* 8940 */  7, 7, 9, 7, 7, 9,-1,-1, -1, 9,-1,-1, 7, 7,-1,-1, /* '襀','襁','襂','襃','襄','襅',0,0, 0,'襉',0,0,'襌','襍',0,0, */
	/* 8950 */ -1,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,0,0,0,0,0,'襖',0, 0,0,0,0,0,0,'襞','襟', */
	/* 8960 */  7,-1, 9,-1, 7,-1, 7,-1, -1,-1, 7,-1,-1, 7,-1, 7, /* '襠',0,'襢',0,'襤',0,'襦',0, 0,0,'襪',0,0,'襭',0,'襯', */
	/* 8970 */ -1,-1, 7,-1, 7,-1,-1, 7, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,0,'襲',0,'襴',0,0,'襷', 0,0,0,0,0,0,'襾','西', */
	/* 8980 */  9, 7,-1, 7,-1,-1, 7, 7,  7, 9, 7, 7,-1,-1,-1, 7, /* '覀','要',0,'覃',0,0,'覆','覇', '覈','覉','覊','見',0,0,0,'規', */
	/* 8990 */  9,-1,-1, 7, 7,-1, 7, 7,  7,-1, 7,-1,-1,-1,-1, 9, /* '覐',0,0,'覓','覔',0,'視','覗', '覘',0,'覚',0,0,0,0,'覟', */
	/* 89a0 */ -1, 7,-1,-1,-1,-1, 7, 7, -1, 7, 7,-1, 7,-1,-1, 7, /* 0,'覡',0,0,0,0,'覦','覧', 0,'覩','親',0,'覬',0,0,'覯', */
	/* 89b0 */  9,-1, 7, 7,-1,-1,-1, 9, -1,-1, 7,-1,-1, 7,-1, 7, /* '覰',0,'覲','観',0,0,0,'覷', 0,0,'覺',0,0,'覽',0,'覿', */
	/* 89c0 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '觀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 89d0 */ -1,-1, 7,-1, 7,-1, 9,-1,  9,-1, 7,-1, 7, 7,-1,-1, /* 0,0,'角',0,'觔',0,'觖',0, '觘',0,'觚',0,'觜','觝',0,0, */
	/* 89e0 */ -1,-1,-1, 7,-1, 7, 7, 7, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,'解',0,'觥','触','觧', 0,0,0,'觫',0,0,0,0, */
	/* 89f0 */ -1, 9,-1, 9, 7,-1, 7,-1,  7,-1,-1,-1,-1, 9,-1, 9, /* 0,'觱',0,'觳','觴',0,'觶',0, '觸',0,0,0,0,'觽',0,'觿', */
	/* 8a00 */  7,-1, 7, 7,-1,-1,-1,-1,  7,-1, 7,-1, 7,-1, 7,-1, /* '言',0,'訂','訃',0,0,0,0, '計',0,'訊',0,'訌',0,'討',0, */
	/* 8a10 */  7, 9, 7, 7, 9, 7, 7, 7,  7,-1,-1, 7,-1, 7,-1, 7, /* '訐','訑','訒','訓','訔','訕','訖','託', '記',0,0,'訛',0,'訝',0,'訟', */
	/* 8a20 */ -1, 9, 7, 7,-1, 7,-1,-1, -1,-1, 7,-1,-1, 7,-1,-1, /* 0,'訡','訢','訣',0,'訥',0,0, 0,0,'訪',0,0,'設',0,0, */
	/* 8a30 */ -1, 7,-1, 7, 7, 9, 7, 7, -1,-1, 7, 7, 7,-1, 9,-1, /* 0,'許',0,'訳','訴','訵','訶','訷', 0,0,'診','註','証',0,'訾',0, */
	/* 8a40 */ -1, 7,-1,-1,-1, 9, 7, 7,  7,-1,-1,-1,-1, 9, 7,-1, /* 0,'詁',0,0,0,'詅','詆','詇', '詈',0,0,0,0,'詍','詎',0, */
	/* 8a50 */  7, 7, 7,-1, 7, 7,-1,-1,  9,-1,-1, 7,-1, 7, 7,-1, /* '詐','詑','詒',0,'詔','評',0,0, '詘',0,0,'詛',0,'詝','詞',0, */
	/* 8a60 */  7, 7, 7, 7,-1,-1, 7,-1, -1, 7,-1, 7, 7, 7, 7,-1, /* '詠','詡','詢','詣',0,0,'試',0, 0,'詩',0,'詫','詬','詭','詮',0, */
	/* 8a70 */  7, 7, 7, 7,-1, 7,-1,-1, -1, 7,-1,-1, 7,-1,-1,-1, /* '詰','話','該','詳',0,'詵',0,0, 0,'詹',0,0,'詼',0,0,0, */
	/* 8a80 */ -1,-1, 7,-1, 7, 7,-1, 7, -1, 7,-1,-1, 7, 7,-1,-1, /* 0,0,'誂',0,'誄','誅',0,'誇', 0,'誉',0,0,'誌','認',0,0, */
	/* 8a90 */  9, 7,-1, 7,-1, 7,-1,-1,  7,-1, 7,-1,-1,-1, 7,-1, /* '誐','誑',0,'誓',0,'誕',0,0, '誘',0,'誚',0,0,0,'語',0, */
	/* 8aa0 */  7, 7,-1, 7, 7, 7, 7, 7,  7,-1,-1,-1, 7, 7, 9,-1, /* '誠','誡',0,'誣','誤','誥','誦','誧', '誨',0,0,0,'説','読','誮',0, */
	/* 8ab0 */  7,-1, 7,-1,-1,-1,-1, 9, -1, 7,-1,-1, 7,-1, 9, 7, /* '誰',0,'課',0,0,0,0,'誷', 0,'誹',0,0,'誼',0,'誾','調', */
	/* 8ac0 */ -1,-1, 7,-1, 7,-1,-1, 7, -1,-1,-1, 7, 7, 7,-1, 7, /* 0,0,'諂',0,'諄',0,0,'談', 0,0,0,'請','諌','諍',0,'諏', */
	/* 8ad0 */  7,-1, 7,-1,-1,-1, 7, 9, -1,-1, 7, 7, 7,-1, 7, 7, /* '諐',0,'諒',0,0,0,'論','諗', 0,0,'諚','諛','諜',0,'諞','諟', */
	/* 8ae0 */  7, 7, 7,-1, 7,-1, 7, 7, -1,-1,-1, 7,-1, 7, 7,-1, /* '諠','諡','諢',0,'諤',0,'諦','諧', 0,0,0,'諫',0,'諭','諮',0, */
	/* 8af0 */ -1, 7,-1, 7, 7,-1, 7, 7,  7,-1, 7,-1, 9,-1, 7,-1, /* 0,'諱',0,'諳','諴',0,'諶','諷', '諸',0,'諺',0,'諼',0,'諾',0, */
	/* 8b00 */  7, 7, 7,-1, 7, 9,-1, 7, -1,-1, 9,-1, 7, 9, 7,-1, /* '謀','謁','謂',0,'謄','謅',0,'謇', 0,0,'謊',0,'謌','謍','謎',0, */
	/* 8b10 */  7,-1,-1,-1, 7,-1, 7, 7, -1, 7, 7, 7, 9, 7,-1, 9, /* '謐',0,0,0,'謔',0,'謖','謗', 0,'謙','謚','講','謜','謝',0,'謟', */
	/* 8b20 */  7, 7,-1,-1,-1,-1, 7,-1,  7,-1,-1, 7, 7, 9,-1,-1, /* '謠','謡',0,0,0,0,'謦',0, '謨',0,0,'謫','謬','謭',0,0, */
	/* 8b30 */ -1,-1,-1, 7,-1,-1,-1,-1, -1, 7,-1,-1,-1,-1, 7,-1, /* 0,0,0,'謳',0,0,0,0, 0,'謹',0,0,0,0,'謾',0, */
	/* 8b40 */ -1, 7,-1, 9,-1,-1, 7,-1, -1, 7,-1,-1, 7,-1, 7, 7, /* 0,'譁',0,'譃',0,0,'譆',0, 0,'證',0,0,'譌',0,'譎','譏', */
	/* 8b50 */ -1, 9,-1,-1, 7,-1, 7,-1,  7, 7, 7, 7, 7,-1, 9, 7, /* 0,'譑',0,0,'譔',0,'譖',0, '識','譙','譚','譛','譜',0,'譞','譟', */
	/* 8b60 */ -1,-1,-1,-1,-1,-1, 7,-1, -1, 7,-1, 7, 7,-1,-1, 7, /* 0,0,0,0,0,0,'警',0, 0,'譩',0,'譫','譬',0,0,'譯', */
	/* 8b70 */  7, 7, 7,-1, 7,-1, 9, 7, -1,-1,-1,-1,-1, 7,-1, 9, /* '議','譱','譲',0,'譴',0,'譶','護', 0,0,0,0,0,'譽',0,'譿', */
	/* 8b80 */  7, 9,-1, 7,-1,-1,-1,-1, -1,-1, 7, 9, 7,-1, 7,-1, /* '讀','讁',0,'讃',0,0,0,0, 0,0,'變','讋','讌',0,'讎',0, */
	/* 8b90 */  7,-1, 7, 7, 9, 9, 7,-1, -1, 7, 7,-1, 9, 7, 9,-1, /* '讐',0,'讒','讓','讔','讕','讖',0, 0,'讙','讚',0,'讜','讝','讞',0, */
	/* 8ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c30 */ -1,-1,-1,-1,-1,-1,-1, 7, -1, 9, 7,-1,-1, 9,-1, 7, /* 0,0,0,0,0,0,0,'谷', 0,'谹','谺',0,0,'谽',0,'谿', */
	/* 8c40 */ -1, 7,-1,-1,-1, 9, 7, 9,  7, 7, 7,-1, 7,-1, 7, 9, /* 0,'豁',0,0,0,'豅','豆','豇', '豈','豉','豊',0,'豌',0,'豎','豏', */
	/* 8c50 */  7,-1,-1,-1, 9, 7,-1, 9, -1,-1, 7,-1,-1,-1,-1,-1, /* '豐',0,0,0,'豔','豕',0,'豗', 0,0,'豚',0,0,0,0,0, */
	/* 8c60 */ -1, 7, 7,-1,-1,-1,-1,-1,  7, 9, 7, 7, 7, 9,-1,-1, /* 0,'象','豢',0,0,0,0,0, '豨','豩','豪','豫','豬','豭',0,0, */
	/* 8c70 */ -1,-1,-1, 9,-1,-1,-1,-1,  7, 7, 7,-1, 7,-1,-1,-1, /* 0,0,0,'豳',0,0,0,0, '豸','豹','豺',0,'豼',0,0,0, */
	/* 8c80 */ -1,-1, 7,-1,-1, 7,-1,-1, -1, 7, 7,-1, 7, 7, 7,-1, /* 0,0,'貂',0,0,'貅',0,0, 0,'貉','貊',0,'貌','貍','貎',0, */
	/* 8c90 */ -1,-1, 9, 9, 7,-1,-1,-1,  7, 9,-1, 9,-1, 7, 7,-1, /* 0,0,'貒','貓','貔',0,0,0, '貘','貙',0,'貛',0,'貝','貞',0, */
	/* 8ca0 */  7, 7, 7,-1, 9,-1,-1, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '負','財','貢',0,'貤',0,0,'貧', '貨','販','貪','貫','責','貭','貮','貯', */
	/* 8cb0 */  7,-1, 7, 7, 7,-1, 7, 7,  7,-1,-1, 7, 7, 7,-1, 7, /* '貰',0,'貲','貳','貴',0,'貶','買', '貸',0,0,'費','貼','貽',0,'貿', */
	/* 8cc0 */  7, 7, 7, 7, 7,-1,-1, 7,  7,-1, 7,-1,-1, 7, 7,-1, /* '賀','賁','賂','賃','賄',0,0,'資', '賈',0,'賊',0,0,'賍','賎',0, */
	/* 8cd0 */ -1, 7,-1, 7,-1, 9, 9,-1, -1, 9, 7, 7, 7,-1, 7,-1, /* 0,'賑',0,'賓',0,'賕','賖',0, 0,'賙','賚','賛','賜',0,'賞',0, */
	/* 8ce0 */  7, 7, 7, 7, 7,-1, 7,-1, -1,-1, 7,-1,-1, 7,-1,-1, /* '賠','賡','賢','賣','賤',0,'賦',0, 0,0,'質',0,0,'賭',0,0, */
	/* 8cf0 */  9, 9,-1,-1, 7,-1,-1,-1,  7,-1, 7, 7, 7, 7, 7,-1, /* '賰','賱',0,0,'賴',0,0,0, '賸',0,'賺','賻','購','賽','賾',0, */
	/* 8d00 */ -1,-1,-1,-1, 7, 7,-1, 7,  7, 9, 7, 7,-1, 7, 9, 7, /* 0,0,0,0,'贄','贅',0,'贇', '贈','贉','贊','贋',0,'贍','贎','贏', */
	/* 8d10 */  7,-1, 7, 7, 7,-1, 7,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* '贐',0,'贒','贓','贔',0,'贖',0, 0,0,0,'贛',0,0,0,0, */
	/* 8d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d60 */ -1,-1,-1,-1, 7,-1, 7, 7, -1,-1,-1, 7, 9, 7,-1,-1, /* 0,0,0,0,'赤',0,'赦','赧', 0,0,0,'赫','赬','赭',0,0, */
	/* 8d70 */  7, 7,-1, 7, 7,-1,-1, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* '走','赱',0,'赳','赴',0,0,'起', 0,0,0,0,0,0,0,0, */
	/* 8d80 */ -1, 7,-1,-1, 9, 7,-1,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,'趁',0,0,'趄','超',0,0, 0,0,'越',0,0,0,0,0, */
	/* 8d90 */ -1,-1,-1,-1,-1, 9,-1,-1, -1, 7,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'趕',0,0, 0,'趙',0,0,0,0,0,0, */
	/* 8da0 */ -1,-1,-1, 7,-1,-1, 9,-1,  7,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,'趣',0,0,'趦',0, '趨',0,0,0,0,0,0,'趯', */
	/* 8db0 */ -1,-1,-1, 7,-1,-1,-1,-1, -1,-1, 7,-1,-1,-1, 7,-1, /* 0,0,0,'足',0,0,0,0, 0,0,'趺',0,0,0,'趾',0, */
	/* 8dc0 */ -1,-1, 7,-1,-1,-1, 9,-1,  9,-1,-1, 7, 7,-1, 7, 7, /* 0,0,'跂',0,0,0,'跆',0, '跈',0,0,'跋','跌',0,'跎','跏', */
	/* 8dd0 */ -1, 7,-1,-1,-1,-1, 7, 7, -1, 9, 7, 7,-1, 7,-1, 7, /* 0,'跑',0,0,0,0,'跖','跗', 0,'跙','跚','跛',0,'距',0,'跟', */
	/* 8de0 */ -1, 7,-1, 7,-1,-1,-1,-1,  7,-1, 7, 7, 9,-1,-1, 7, /* 0,'跡',0,'跣',0,0,0,0, '跨',0,'跪','跫','跬',0,0,'路', */
	/* 8df0 */ -1,-1,-1, 7,-1, 7,-1,-1, -1,-1,-1,-1, 7, 9,-1, 7, /* 0,0,0,'跳',0,'践',0,0, 0,0,0,0,'跼','跽',0,'跿', */
	/* 8e00 */ -1,-1,-1,-1,-1,-1, 9,-1,  7, 7, 7,-1, 9,-1,-1, 7, /* 0,0,0,0,0,0,'踆',0, '踈','踉','踊',0,'踌',0,0,'踏', */
	/* 8e10 */  7,-1,-1,-1, 9,-1, 9,-1, -1,-1,-1,-1,-1, 7, 7, 7, /* '踐',0,0,0,'踔',0,'踖',0, 0,0,0,0,0,'踝','踞','踟', */
	/* 8e20 */  7, 9, 9, 7,-1,-1,-1, 9, -1,-1, 7,-1,-1,-1,-1,-1, /* '踠','踡','踢','踣',0,0,0,'踧', 0,0,'踪',0,0,0,0,0, */
	/* 8e30 */  7,-1,-1,-1, 7, 7, 9,-1, -1, 9,-1,-1,-1, 7,-1,-1, /* '踰',0,0,0,'踴','踵','踶',0, 0,'踹',0,0,0,'踽',0,0, */
	/* 8e40 */ -1,-1, 7,-1, 7,-1,-1, 7,  7, 7, 7, 9, 7,-1,-1,-1, /* 0,0,'蹂',0,'蹄',0,0,'蹇', '蹈','蹉','蹊','蹋','蹌',0,0,0, */
	/* 8e50 */  7,-1,-1,-1, 9, 7,-1,-1, -1, 7,-1,-1,-1,-1,-1, 7, /* '蹐',0,0,0,'蹔','蹕',0,0, 0,'蹙',0,0,0,0,0,'蹟', */
	/* 8e60 */  7,-1, 9, 7, 7,-1,-1,-1, -1,-1,-1,-1, 9, 9,-1, 9, /* '蹠',0,'蹢','蹣','蹤',0,0,0, 0,0,0,0,'蹬','蹭',0,'蹯', */
	/* 8e70 */  7,-1, 7,-1, 7,-1, 7,-1, -1,-1,-1, 7, 7,-1,-1,-1, /* '蹰',0,'蹲',0,'蹴',0,'蹶',0, 0,0,0,'蹻','蹼',0,0,0, */
	/* 8e80 */ -1, 7,-1,-1, 7, 7,-1, 7, -1,-1, 7, 7,-1, 7,-1,-1, /* 0,'躁',0,0,'躄','躅',0,'躇', 0,0,'躊','躋',0,'躍',0,0, */
	/* 8e90 */ -1, 7,-1, 7, 7,-1,-1,-1,  9, 7,-1,-1,-1,-1, 9,-1, /* 0,'躑',0,'躓','躔',0,0,0, '躘','躙',0,0,0,0,'躞',0, */
	/* 8ea0 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1, 7, 7, 7,-1, 9, 7, /* 0,'躡',0,0,0,0,0,0, 0,0,'躪','身','躬',0,'躮','躯', */
	/* 8eb0 */  7, 7,-1, 9,-1, 9, 9,-1, -1,-1,-1, 9,-1,-1, 7,-1, /* '躰','躱',0,'躳',0,'躵','躶',0, 0,0,0,'躻',0,0,'躾',0, */
	/* 8ec0 */  7,-1,-1,-1,-1, 7, 7,-1,  7,-1, 7, 7, 7, 7,-1,-1, /* '軀',0,0,0,0,'軅','軆',0, '軈',0,'車','軋','軌','軍',0,0, */
	/* 8ed0 */ -1, 9, 7,-1, 9,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1, 7, /* 0,'軑','軒',0,'軔',0,0,0, 0,0,0,'軛',0,0,0,'軟', */
	/* 8ee0 */ -1,-1, 7, 7,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,'転','軣',0,0,0,0, 0,0,0,'軫',0,0,0,0, */
	/* 8ef0 */ -1,-1,-1,-1,-1,-1,-1,-1,  7, 9, 7, 7, 7, 7, 7,-1, /* 0,0,0,0,0,0,0,0, '軸','軹','軺','軻','軼','軽','軾',0, */
	/* 8f00 */  9,-1,-1, 7,-1, 7,-1,-1,  9, 7, 7,-1, 7,-1,-1,-1, /* '輀',0,0,'較',0,'輅',0,0, '輈','載','輊',0,'輌',0,0,0, */
	/* 8f10 */ -1,-1, 7, 7, 7, 7,-1, 9, -1, 7,-1, 7, 7, 7, 7, 7, /* 0,0,'輒','輓','輔','輕',0,'輗', 0,'輙',0,'輛','輜','輝','輞','輟', */
	/* 8f20 */ -1,-1,-1,-1,-1,-1, 7,-1, -1, 7, 7, 9,-1, 7,-1, 7, /* 0,0,0,0,0,0,'輦',0, 0,'輩','輪','輫',0,'輭',0,'輯', */
	/* 8f30 */ -1,-1,-1, 7,-1,-1, 7,-1,  7, 7,-1, 7,-1,-1, 7, 7, /* 0,0,0,'輳',0,0,'輶',0, '輸','輹',0,'輻',0,0,'輾','輿', */
	/* 8f40 */  9,-1, 7,-1, 7, 7, 7,-1, -1, 7, 9,-1, 7, 7, 7,-1, /* '轀',0,'轂',0,'轄','轅','轆',0, 0,'轉','轊',0,'轌','轍','轎',0, */
	/* 8f50 */ -1,-1,-1,-1, 7,-1,-1, 7,  9,-1,-1,-1, 7,-1,-1, 7, /* 0,0,0,0,'轔',0,0,'轗', '轘',0,0,0,'轜',0,0,'轟', */
	/* 8f60 */ -1, 7, 7, 7, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'轡','轢','轣','轤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7, 7,-1, 7, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,'辛','辜',0,'辞','辟', */
	/* 8fa0 */ -1,-1,-1, 7, 9,-1, 7, 7,  7,-1,-1,-1,-1, 7, 7, 7, /* 0,0,0,'辣','辤',0,'辦','辧', '辨',0,0,0,0,'辭','辮','辯', */
	/* 8fb0 */  7, 7, 7,-1, 9, 7, 9, 7, -1,-1, 7, 7, 7,-1,-1, 7, /* '辰','辱','農',0,'辴','辵','辶','辷', 0,0,'辺','辻','込',0,0,'辿', */
	/* 8fc0 */ -1, 9, 7,-1, 7, 7, 9,-1, -1,-1, 9,-1,-1, 9, 7,-1, /* 0,'迁','迂',0,'迄','迅','迆',0, 0,0,'迊',0,0,'迍','迎',0, */
	/* 8fd0 */ -1, 7,-1, 9, 7, 9,-1,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,'近',0,'迓','返','迕',0,0, 0,0,'迚',0,0,0,0,0, */
	/* 8fe0 */  9,-1, 7,-1, 7, 7, 7,-1,  7, 7, 7, 7,-1, 7, 7, 7, /* '迠',0,'迢',0,'迤','迥','迦',0, '迨','迩','迪','迫',0,'迭','迮','迯', */
	/* 8ff0 */  7, 9,-1,-1, 7, 9,-1, 7,  7, 7, 7, 9,-1, 7,-1,-1, /* '述','迱',0,0,'迴','迵',0,'迷', '迸','迹','迺','迻',0,'追',0,0, */
	/* 9000 */  7, 7, 9, 7,-1, 7, 7,-1,  7,-1,-1, 7, 9, 7, 7, 7, /* '退','送','适','逃',0,'逅','逆',0, '逈',0,0,'逋','逌','逍','逎','透', */
	/* 9010 */  7, 7,-1, 7, 7, 7, 7, 7, -1, 7, 7,-1,-1, 7, 7, 7, /* '逐','逑',0,'逓','途','逕','逖','逗', 0,'這','通',0,0,'逝','逞','速', */
	/* 9020 */  7, 7, 7, 7,-1,-1,-1, 7, -1,-1,-1,-1,-1, 7, 7,-1, /* '造','逡','逢','連',0,0,0,'逧', 0,0,0,0,0,'逭','逮',0, */
	/* 9030 */ -1, 7, 7,-1,-1, 7, 7, 9,  7, 7,-1,-1, 7,-1, 7,-1, /* 0,'週','進',0,0,'逵','逶','逷', '逸','逹',0,0,'逼',0,'逾',0, */
	/* 9040 */ -1, 7, 7, 9, 9, 7,-1, 7, -1, 7, 7, 7,-1, 7, 7, 7, /* 0,'遁','遂','遃','遄','遅',0,'遇', 0,'遉','遊','運',0,'遍','過','遏', */
	/* 9050 */  7, 7, 7, 7, 7, 7, 7,-1,  7, 7,-1,-1, 7, 9, 7,-1, /* '遐','遑','遒','道','達','違','遖',0, '遘','遙',0,0,'遜','遝','遞',0, */
	/* 9060 */  7, 7,-1, 7,-1, 7,-1,-1,  7, 7,-1,-1,-1, 7, 7, 7, /* '遠','遡',0,'遣',0,'遥',0,0, '遨','適',0,0,0,'遭','遮','遯', */
	/* 9070 */ -1,-1, 7,-1,-1, 7, 7, 7,  7,-1, 7,-1, 7, 7,-1, 7, /* 0,0,'遲',0,0,'遵','遶','遷', '選',0,'遺',0,'遼','遽',0,'避', */
	/* 9080 */  7, 7, 7, 7, 7, 9,-1, 7,  7, 7, 7,-1, 9,-1,-1, 7, /* '邀','邁','邂','邃','還','邅',0,'邇', '邈','邉','邊',0,'邌',0,0,'邏', */
	/* 9090 */  9, 7,-1,-1,-1, 7,-1, 7, -1, 7,-1, 7,-1,-1,-1,-1, /* '邐','邑',0,0,0,'邕',0,'邗', 0,'邙',0,'邛',0,0,0,0, */
	/* 90a0 */ -1, 9, 7, 7,-1,-1, 7,-1,  7,-1, 7,-1,-1,-1,-1, 7, /* 0,'邡','邢','那',0,0,'邦',0, '邨',0,'邪',0,0,0,0,'邯', */
	/* 90b0 */  9, 7,-1, 7,-1, 7, 9,-1,  7,-1,-1,-1,-1,-1, 7,-1, /* '邰','邱',0,'邳',0,'邵','邶',0, '邸',0,0,0,0,0,'邾',0, */
	/* 90c0 */ -1, 7,-1, 9, 7, 7,-1, 7,  9,-1, 7,-1,-1,-1, 7,-1, /* 0,'郁',0,'郃','郄','郅',0,'郇', '郈',0,'郊',0,0,0,'郎',0, */
	/* 90d0 */ -1,-1,-1,-1,-1,-1,-1, 7, -1,-1,-1, 7, 9, 7, 7, 9, /* 0,0,0,0,0,0,0,'郗', 0,0,0,'郛','郜','郝','郞','郟', */
	/* 90e0 */ -1, 7, 7,-1, 7,-1,-1,-1,  7,-1,-1, 9,-1, 7,-1, 7, /* 0,'郡','郢',0,'郤',0,0,0, '部',0,0,'郫',0,'郭',0,'郯', */
	/* 90f0 */ -1,-1, 9,-1, 7, 7, 9, 7, -1,-1,-1,-1,-1, 7, 9, 9, /* 0,0,'郲',0,'郴','郵','郶','郷', 0,0,0,0,0,'都','郾','郿', */
	/* 9100 */  9,-1, 7,-1, 9,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '鄀',0,'鄂',0,'鄄',0,'鄆',0, 0,0,0,0,0,0,0,0, */
	/* 9110 */ -1,-1, 7,-1, 7, 7, 7,-1,  9, 7,-1,-1, 9,-1, 9,-1, /* 0,0,'鄒',0,'鄔','鄕','鄖',0, '鄘','鄙',0,0,'鄜',0,'鄞',0, */
	/* 9120 */ -1,-1, 7, 7,-1,-1,-1, 7, -1,-1,-1,-1,-1, 7,-1, 7, /* 0,0,'鄢','鄣',0,0,0,'鄧', 0,0,0,0,0,'鄭',0,'鄯', */
	/* 9130 */  7, 7, 7,-1, 7,-1,-1, 9, -1, 9, 9,-1,-1, 7,-1,-1, /* '鄰','鄱','鄲',0,'鄴',0,0,'鄷', 0,'鄹','鄺',0,0,'鄽',0,0, */
	/* 9140 */ -1,-1,-1,-1,-1,-1, 9, 9,  7, 7, 7, 7, 7, 7, 7,-1, /* 0,0,0,0,0,0,'酆','酇', '酈','酉','酊','酋','酌','配','酎',0, */
	/* 9150 */ -1,-1, 7,-1, 7,-1, 7, 9,  7, 9,-1, 7,-1,-1,-1,-1, /* 0,0,'酒',0,'酔',0,'酖','酗', '酘','酙',0,'酛',0,0,0,0, */
	/* 9160 */ -1, 9, 7, 7, 9, 7,-1,-1, -1, 7, 7,-1, 7,-1,-1,-1, /* 0,'酡','酢','酣','酤','酥',0,0, 0,'酩','酪',0,'酬',0,0,0, */
	/* 9170 */ -1,-1, 7, 7, 9, 7,-1, 7,  7, 9,-1,-1,-1,-1,-1,-1, /* 0,0,'酲','酳','酴','酵',0,'酷', '酸','酹',0,0,0,0,0,0, */
	/* 9180 */ -1,-1, 7, 7,-1, 9,-1, 7, -1, 7,-1, 7,-1, 7, 9,-1, /* 0,0,'醂','醃',0,'醅',0,'醇', 0,'醉',0,'醋',0,'醍','醎',0, */
	/* 9190 */  7,-1, 7,-1,-1,-1,-1, 7, -1,-1,-1,-1, 7,-1, 7,-1, /* '醐',0,'醒',0,0,0,0,'醗', 0,0,0,0,'醜',0,'醞',0, */
	/* 91a0 */ -1,-1, 7,-1, 7,-1,-1,-1,  9,-1, 7, 7, 7,-1, 9, 7, /* 0,0,'醢',0,'醤',0,0,0, '醨',0,'醪','醫','醬',0,'醮','醯', */
	/* 91b0 */ -1, 7,-1, 9, 7, 7, 9,-1,  7,-1, 7,-1, 7,-1,-1,-1, /* 0,'醱',0,'醳','醴','醵','醶',0, '醸',0,'醺',0,'醼',0,0,0, */
	/* 91c0 */  7, 7,-1, 9, 9,-1, 7, 7,  7, 7,-1, 7, 7, 7, 7, 7, /* '釀','釁',0,'釃','釄',0,'釆','采', '釈','釉',0,'釋','里','重','野','量', */
	/* 91d0 */  7, 7,-1,-1,-1,-1, 7, 7,  7,-1, 9, 7, 7, 7,-1, 7, /* '釐','金',0,0,0,0,'釖','釗', '釘',0,'釚','釛','釜','針',0,'釟', */
	/* 91e0 */ -1, 7,-1, 7, 7, 7, 7, 7, -1,-1,-1,-1, 9, 7, 9,-1, /* 0,'釡',0,'釣','釤','釥','釦','釧', 0,0,0,0,'釬','釭','釮',0, */
	/* 91f0 */ -1, 7,-1,-1,-1, 7, 7,-1, -1,-1,-1, 7, 7,-1,-1, 7, /* 0,'釱',0,0,0,'釵','釶',0, 0,0,0,'釻','釼',0,0,'釿', */
	/* 9200 */ -1, 9,-1,-1,-1,-1,-1, 7, -1,-1, 9,-1,-1, 7, 7,-1, /* 0,'鈁',0,0,0,0,0,'鈇', 0,0,'鈊',0,0,'鈍','鈎',0, */
	/* 9210 */  7, 7,-1,-1, 7, 7, 9, 9, -1,-1,-1,-1,-1,-1, 7,-1, /* '鈐','鈑',0,0,'鈔','鈕','鈖','鈗', 0,0,0,0,0,0,'鈞',0, */
	/* 9220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 7,-1,-1, 7,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'鈩',0,0,'鈬',0,0,0, */
	/* 9230 */ -1,-1,-1, 9, 7,-1,-1, 7,  7, 7, 7,-1, 7,-1,-1, 7, /* 0,0,0,'鈳','鈴',0,0,'鈷', '鈸','鈹','鈺',0,'鈼',0,0,'鈿', */
	/* 9240 */  7,-1, 9, 7, 7, 7,-1, 9,  7, 7, 9, 7,-1,-1, 9, 7, /* '鉀',0,'鉂','鉃','鉄','鉅',0,'鉇', '鉈','鉉','鉊','鉋',0,0,'鉎','鉏', */
	/* 9250 */  7, 9,-1,-1,-1,-1, 9, 7, -1, 9, 7, 7,-1,-1, 7,-1, /* '鉐','鉑',0,0,0,0,'鉖','鉗', 0,'鉙','鉚','鉛',0,0,'鉞',0, */
	/* 9260 */  9, 9, 7,-1, 7, 9, 7, 9,  9,-1,-1,-1,-1,-1,-1,-1, /* '鉠','鉡','鉢',0,'鉤','鉥','鉦','鉧', '鉨',0,0,0,0,0,0,0, */
	/* 9270 */ -1, 7,-1,-1,-1,-1,-1,-1,  7,-1,-1,-1, 9, 9, 7, 9, /* 0,'鉱',0,0,0,0,0,0, '鉸',0,0,0,'鉼','鉽','鉾','鉿', */
	/* 9280 */  7,-1,-1, 7,-1, 7,-1,-1,  7, 9,-1,-1,-1, 9,-1,-1, /* '銀',0,0,'銃',0,'銅',0,0, '銈','銉',0,0,0,'銍',0,0, */
	/* 9290 */ -1, 7,-1, 7,-1, 7, 7, 9,  7, 9, 7, 7, 7,-1,-1, 9, /* 0,'銑',0,'銓',0,'銕','銖','銗', '銘','銙','銚','銛','銜',0,0,'銟', */
	/* 92a0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1, 9,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,'銧', 0,0,0,'銫',0,'銭',0,0, */
	/* 92b0 */ -1,-1, 9,-1,-1,-1,-1, 7, -1, 7,-1,-1,-1,-1,-1, 9, /* 0,0,'銲',0,0,0,0,'銷', 0,'銹',0,0,0,0,0,'銿', */
	/* 92c0 */  9,-1, 7,-1,-1,-1, 9,-1, -1,-1,-1, 7, 7,-1, 9, 7, /* '鋀',0,'鋂',0,0,0,'鋆',0, 0,0,0,'鋋','鋌',0,'鋎','鋏', */
	/* 92d0 */  9,-1, 7, 7,-1,-1,-1, 9, -1, 9,-1,-1,-1,-1,-1,-1, /* '鋐',0,'鋒','鋓',0,0,0,'鋗', 0,'鋙',0,0,0,0,0,0, */
	/* 92e0 */  7,-1,-1,-1, 7, 9,-1, 9, -1, 7, 7,-1,-1, 7,-1,-1, /* '鋠',0,0,0,'鋤','鋥',0,'鋧', 0,'鋩','鋪',0,0,'鋭',0,0, */
	/* 92f0 */ -1,-1, 7, 7,-1,-1,-1, 9,  7, 9, 7, 9, 7,-1,-1, 7, /* 0,0,'鋲','鋳',0,0,0,'鋷', '鋸','鋹','鋺','鋻','鋼',0,0,'鋿', */
	/* 9300 */ -1,-1, 9,-1, 7,-1, 7,-1, -1,-1,-1,-1,-1, 9,-1, 7, /* 0,0,'錂',0,'錄',0,'錆',0, 0,0,0,0,0,'錍',0,'錏', */
	/* 9310 */  7, 9,-1,-1,-1, 9,-1,-1,  7, 7, 7,-1,-1, 9, 9, 7, /* '錐','錑',0,0,0,'錕',0,0, '錘','錙','錚',0,0,'錝','錞','錟', */
	/* 9320 */  7, 7, 7, 7,-1, 7, 7, 9,  7, 9,-1, 7, 7,-1, 7, 7, /* '錠','錡','錢','錣',0,'錥','錦','錧', '錨','錩',0,'錫','錬',0,'錮','錯', */
	/* 9330 */ -1,-1, 7,-1,-1, 7,-1,-1, -1,-1, 7, 7,-1,-1,-1,-1, /* 0,0,'録',0,0,'錵',0,0, 0,0,'錺','錻',0,0,0,0, */
	/* 9340 */ -1,-1,-1,-1, 7,-1,-1, 9,  7, 7, 7, 7,-1, 7,-1,-1, /* 0,0,0,0,'鍄',0,0,'鍇', '鍈','鍉','鍊','鍋',0,'鍍',0,0, */
	/* 9350 */ -1, 9,-1,-1, 7,-1, 7, 9, -1,-1, 9, 7, 7,-1,-1,-1, /* 0,'鍑',0,0,'鍔',0,'鍖','鍗', 0,0,'鍚','鍛','鍜',0,0,0, */
	/* 9360 */  7,-1,-1,-1, 7, 7,-1,-1, -1,-1, 7, 9, 7,-1, 7,-1, /* '鍠',0,0,0,'鍤','鍥',0,0, 0,0,'鍪','鍫','鍬',0,'鍮',0, */
	/* 9370 */  7, 9,-1, 9,-1, 7,-1,-1, -1,-1,-1,-1, 7,-1, 7,-1, /* '鍰','鍱',0,'鍳',0,'鍵',0,0, 0,0,0,0,'鍼',0,'鍾',0, */
	/* 9380 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1, 9, 7,-1,-1, 9, /* 0,0,0,0,0,0,0,0, '鎈',0,0,'鎋','鎌',0,0,'鎏', */
	/* 9390 */ -1,-1,-1,-1, 7,-1, 7, 7, -1,-1, 7, 7,-1,-1, 9,-1, /* 0,0,0,0,'鎔',0,'鎖','鎗', 0,0,'鎚','鎛',0,0,'鎞',0, */
	/* 93a0 */ -1, 9,-1, 7,-1,-1,-1, 7, -1,-1,-1,-1, 7, 7, 7,-1, /* 0,'鎡',0,'鎣',0,0,0,'鎧', 0,0,0,0,'鎬','鎭','鎮',0, */
	/* 93b0 */  7,-1,-1,-1,-1,-1,-1,-1, -1, 7, 7,-1,-1,-1,-1,-1, /* '鎰',0,0,0,0,0,0,0, 0,'鎹','鎺',0,0,0,0,0, */
	/* 93c0 */ -1, 9,-1, 7,-1,-1, 7, 9,  7,-1,-1,-1,-1,-1,-1,-1, /* 0,'鏁',0,'鏃',0,0,'鏆','鏇', '鏈',0,0,0,0,0,0,0, */
	/* 93d0 */  7, 7,-1,-1,-1,-1, 7, 7,  7,-1,-1,-1, 9, 7, 7, 7, /* '鏐','鏑',0,0,0,0,'鏖','鏗', '鏘',0,0,0,'鏜','鏝','鏞','鏟', */
	/* 93e0 */ -1, 7, 9,-1, 7, 7,-1, 9,  7,-1,-1,-1,-1,-1,-1,-1, /* 0,'鏡','鏢',0,'鏤','鏥',0,'鏧', '鏨',0,0,0,0,0,0,0, */
	/* 93f0 */ -1, 9,-1,-1,-1, 9,-1,-1, -1,-1,-1, 9,-1, 7,-1,-1, /* 0,'鏱',0,0,0,'鏵',0,0, 0,0,0,'鏻',0,'鏽',0,0, */
	/* 9400 */ -1,-1,-1, 7, 7,-1,-1, 7, -1, 9,-1,-1,-1,-1,-1, 9, /* 0,0,0,'鐃','鐄',0,0,'鐇', 0,'鐉',0,0,0,0,0,'鐏', */
	/* 9410 */  7,-1,-1, 7, 7,-1, 9, 9,  7, 7, 7,-1,-1,-1,-1,-1, /* '鐐',0,0,'鐓','鐔',0,'鐖','鐗', '鐘','鐙','鐚',0,0,0,0,0, */
	/* 9420 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,'鐡',0,0,0,0,0,0, 0,0,0,'鐫',0,0,0,0, */
	/* 9430 */ -1,-1, 9, 7, 9, 7, 7,-1,  7,-1, 7, 9,-1,-1,-1,-1, /* 0,0,'鐲','鐳','鐴','鐵','鐶',0, '鐸',0,'鐺','鐻',0,0,0,0, */
	/* 9440 */ -1, 7,-1,-1, 7, 9,-1,-1, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,'鑁',0,0,'鑄','鑅',0,0, 0,0,'鑊',0,0,0,0,0, */
	/* 9450 */ -1, 7, 7, 7,-1,-1,-1,-1, -1,-1, 7, 7,-1,-1, 7,-1, /* 0,'鑑','鑒','鑓',0,0,0,0, 0,0,'鑚','鑛',0,0,'鑞',0, */
	/* 9460 */  7,-1, 7, 7,-1,-1,-1,-1, -1,-1, 7, 7,-1, 9,-1, 9, /* '鑠',0,'鑢','鑣',0,0,0,0, 0,0,'鑪','鑫',0,'鑭',0,'鑯', */
	/* 9470 */  7, 7, 7,-1,-1, 7,-1, 7, -1,-1,-1,-1, 7, 7, 7, 7, /* '鑰','鑱','鑲',0,0,'鑵',0,'鑷', 0,0,0,0,'鑼','鑽','鑾','鑿', */
	/* 9480 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'钁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9570 */ -1,-1,-1,-1,-1,-1,-1, 7,  9, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'長', '镸','镹',0,0,0,0,0,0, */
	/* 9580 */  7,-1, 7, 7,-1,-1, 9, 7, -1, 7, 7, 7, 9, 9, 7, 7, /* '門',0,'閂','閃',0,0,'閆','閇', 0,'閉','閊','開','閌','閍','閎','閏', */
	/* 9590 */ -1, 7,-1, 7, 7,-1, 7,-1,  7, 7,-1,-1,-1,-1,-1, 7, /* 0,'閑',0,'間','閔',0,'閖',0, '閘','閙',0,0,0,0,0,'閟', */
	/* 95a0 */  7,-1, 7, 7, 7, 7, 7, 7,  7, 7,-1, 9, 7, 7,-1,-1, /* '閠',0,'関','閣','閤','閥','閦','閧', '閨','閩',0,'閫','閬','閭',0,0, */
	/* 95b0 */ -1,-1, 7,-1, 9,-1, 7,-1, -1, 7,-1, 7, 7, 7, 7,-1, /* 0,0,'閲',0,'閴',0,'閶',0, 0,'閹',0,'閻','閼','閽','閾',0, */
	/* 95c0 */ -1,-1,-1, 7,-1,-1,-1, 7,  9,-1, 7, 7, 7, 7,-1,-1, /* 0,0,0,'闃',0,0,0,'闇', '闈',0,'闊','闋','闌','闍',0,0, */
	/* 95d0 */  7,-1,-1, 7, 7, 7, 7,-1,  7,-1, 7,-1, 7,-1, 7,-1, /* '闐',0,0,'闓','闔','闕','闖',0, '闘',0,'闚',0,'關',0,'闞',0, */
	/* 95e0 */ -1, 7, 7,-1,-1, 7,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'闡','闢',0,0,'闥',0,0, 0,0,0,0,0,0,0,0, */
	/* 95f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 7, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'阜','阝',0,0, */
	/* 9620 */ -1, 7,-1,-1,-1,-1,-1,-1,  7,-1, 7,-1, 9,-1, 7, 7, /* 0,'阡',0,0,0,0,0,0, '阨',0,'阪',0,'阬',0,'阮','阯', */
	/* 9630 */ -1,-1, 7, 9, 9,-1,-1,-1, -1,-1,-1, 7, 9,-1,-1, 7, /* 0,0,'防','阳','阴',0,0,0, 0,0,0,'阻','阼',0,0,'阿', */
	/* 9640 */  7, 9, 7,-1, 7,-1,-1,-1, -1,-1,-1, 7, 7, 7,-1, 7, /* '陀','陁','陂',0,'附',0,0,0, 0,0,0,'陋','陌','降',0,'陏', */
	/* 9650 */  7,-1,-1,-1,-1,-1,-1,-1,  7,-1,-1, 7, 7, 7, 7, 7, /* '限',0,0,0,0,0,0,0, '陘',0,0,'陛','陜','陝','陞','陟', */
	/* 9660 */ -1, 9, 7, 7, 7, 7, 7,-1, -1,-1, 7,-1, 7,-1,-1,-1, /* 0,'陡','院','陣','除','陥','陦',0, 0,0,'陪',0,'陬',0,0,0, */
	/* 9670 */  7,-1, 7, 7,-1, 7, 7, 7,  7,-1, 7,-1,-1, 7,-1,-1, /* '陰',0,'陲','陳',0,'陵','陶','陷', '陸',0,'険',0,0,'陽',0,0, */
	/* 9680 */ -1,-1, 9,-1, 7, 7, 7,-1,  7,-1, 7, 7,-1, 7, 7, 7, /* 0,0,'隂',0,'隄','隅','隆',0, '隈',0,'隊','隋',0,'隍','階','随', */
	/* 9690 */ -1,-1,-1,-1, 7, 7,-1, 7,  7, 7, 9, 7, 7, 7,-1,-1, /* 0,0,0,0,'隔','隕',0,'隗', '隘','隙','隚','際','障','隝',0,0, */
	/* 96a0 */  7,-1,-1, 7, 7, 7,-1, 7,  7, 9, 7,-1,-1,-1,-1, 9, /* '隠',0,0,'隣','隤','隥',0,'隧', '隨','隩','險',0,0,0,0,'隯', */
	/* 96b0 */  7, 7, 7, 9, 7,-1, 7, 7,  7, 7, 9, 7, 7, 9,-1,-1, /* '隰','隱','隲','隳','隴',0,'隶','隷', '隸','隹','隺','隻','隼','隽',0,0, */
	/* 96c0 */  7, 7,-1,-1, 7, 7, 7, 7, -1, 7,-1, 7, 7, 7, 7,-1, /* '雀','雁',0,0,'雄','雅','集','雇', 0,'雉',0,'雋','雌','雍','雎',0, */
	/* 96d0 */ -1, 7, 7,-1,-1, 7, 7,-1,  9, 7, 9, 7, 7, 9, 7,-1, /* 0,'雑','雒',0,0,'雕','雖',0, '雘','雙','雚','雛','雜','雝','雞',0, */
	/* 96e0 */ -1,-1, 7, 7,-1,-1,-1,-1,  7, 7, 7, 7,-1,-1,-1, 7, /* 0,0,'離','難',0,0,0,0, '雨','雩','雪','雫',0,0,0,'雯', */
	/* 96f0 */  7,-1, 7,-1,-1,-1, 7, 7, -1, 7,-1, 7,-1,-1,-1,-1, /* '雰',0,'雲',0,0,0,'零','雷', 0,'雹',0,'電',0,0,0,0, */
	/* 9700 */  7,-1,-1,-1, 7,-1, 7, 7,  7,-1, 7,-1,-1, 7, 7, 7, /* '需',0,0,0,'霄',0,'霆','震', '霈',0,'霊',0,0,'霍','霎','霏', */
	/* 9710 */ -1, 7,-1, 7, 9,-1, 7,-1, -1, 7,-1,-1, 7,-1, 7,-1, /* 0,'霑',0,'霓','霔',0,'霖',0, 0,'霙',0,0,'霜',0,'霞',0, */
	/* 9720 */ -1,-1,-1, 9, 7,-1,-1, 7, -1,-1, 7,-1,-1,-1,-1,-1, /* 0,0,0,'霣','霤',0,0,'霧', 0,0,'霪',0,0,0,0,0, */
	/* 9730 */  7,-1, 7, 7,-1,-1, 9,-1,  7, 7,-1, 7,-1, 7, 7,-1, /* '霰',0,'露','霳',0,0,'霶',0, '霸','霹',0,'霻',0,'霽','霾',0, */
	/* 9740 */ -1, 9, 7,-1, 7,-1, 7, 9,  7, 7,-1,-1,-1, 7, 7, 7, /* 0,'靁','靂',0,'靄',0,'靆','靇', '靈','靉',0,0,0,'靍','靎','靏', */
	/* 9750 */ -1,-1, 7,-1,-1, 9, 7, 9, -1, 7, 7, 9, 7,-1, 7,-1, /* 0,0,'青',0,0,'靕','靖','靗', 0,'静','靚','靛','靜',0,'非',0, */
	/* 9760 */  7, 7, 7,-1, 7,-1, 7,-1,  7, 7, 9, 7,-1, 7, 7,-1, /* '靠','靡','面',0,'靤',0,'靦',0, '靨','革','靪','靫',0,'靭','靮',0, */
	/* 9770 */ -1, 7,-1, 7, 7,-1,-1,-1, -1, 7, 7,-1, 7,-1,-1,-1, /* 0,'靱',0,'靳','靴',0,0,0, 0,'靹','靺',0,'靼',0,0,0, */
	/* 9780 */ -1, 7,-1,-1, 7, 7, 7,-1, -1,-1,-1, 7,-1, 7,-1, 7, /* 0,'鞁',0,0,'鞄','鞅','鞆',0, 0,0,0,'鞋',0,'鞍',0,'鞏', */
	/* 9790 */  7,-1,-1,-1,-1, 7, 9,-1,  7,-1, 9,-1, 7,-1, 9,-1, /* '鞐',0,0,0,0,'鞕','鞖',0, '鞘',0,'鞚',0,'鞜',0,'鞞',0, */
	/* 97a0 */  7,-1, 9, 7,-1,-1, 7,-1,  7,-1,-1, 7,-1, 7, 7,-1, /* '鞠',0,'鞢','鞣',0,0,'鞦',0, '鞨',0,0,'鞫',0,'鞭','鞮',0, */
	/* 97b0 */ -1, 9, 9, 7, 7,-1,-1,-1, -1,-1, 7,-1,-1,-1, 9,-1, /* 0,'鞱','鞲','鞳','鞴',0,0,0, 0,0,'鞺',0,0,0,'鞾',0, */
	/* 97c0 */ -1, 7,-1, 7,-1,-1, 7,-1,  7, 7,-1, 7, 9,-1,-1,-1, /* 0,'韁',0,'韃',0,0,'韆',0, '韈','韉',0,'韋','韌',0,0,0, */
	/* 97d0 */ -1, 9,-1, 7, 9,-1,-1,-1,  9, 9,-1, 7, 7,-1, 7,-1, /* 0,'韑',0,'韓','韔',0,0,0, '韘','韙',0,'韛','韜',0,'韞',0, */
	/* 97e0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7, 7,-1, /* 0,'韡',0,0,0,0,0,0, 0,0,0,0,0,'韭','韮',0, */
	/* 97f0 */ -1, 9, 7, 7, 7, 7, 7,-1, -1,-1,-1, 7,-1,-1,-1, 7, /* 0,'韱','韲','音','韴','韵','韶',0, 0,0,0,'韻',0,0,0,'響', */
	/* 9800 */ -1, 7, 7, 7, 9, 7, 7,-1,  7,-1, 7,-1, 7, 9, 9, 7, /* 0,'頁','頂','頃','頄','項','順',0, '須',0,'頊',0,'頌','頍','頎','頏', */
	/* 9810 */  7, 7, 7, 7, 9,-1, 9, 7,  7,-1, 7,-1,-1,-1, 7,-1, /* '預','頑','頒','頓','頔',0,'頖','頗', '領',0,'頚',0,0,0,'頞',0, */
	/* 9820 */ -1, 7,-1, 9, 7, 9,-1,-1, -1,-1,-1, 7, 7, 7,-1,-1, /* 0,'頡',0,'頣','頤','頥',0,0, 0,0,0,'頫','頬','頭',0,0, */
	/* 9830 */  7,-1, 9, 9, 7,-1,-1, 7,  7,-1,-1, 7, 7, 7,-1,-1, /* '頰',0,'頲','頳','頴',0,0,'頷', '頸',0,0,'頻','頼','頽',0,0, */
	/* 9840 */ -1,-1,-1,-1,-1,-1, 7, 9, -1,-1,-1, 7, 7, 7, 7, 7, /* 0,0,0,0,0,0,'顆','顇', 0,0,0,'顋','題','額','顎','顏', */
	/* 9850 */ -1,-1, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7,-1,-1, 7,-1, /* 0,0,'顒','顓','顔','顕','顖','顗', '願','顙','顚','顛',0,0,'類',0, */
	/* 9860 */ -1,-1,-1,-1,-1, 7, 9, 7, -1,-1,-1, 7, 7,-1,-1, 7, /* 0,0,0,0,0,'顥','顦','顧', 0,0,0,'顫','顬',0,0,'顯', */
	/* 9870 */  7, 7,-1, 7, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '顰','顱',0,'顳','顴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 98a0 */ -1,-1,-1,-1,-1,-1,-1,-1,  7,-1, 7, 9,-1, 9,-1, 7, /* 0,0,0,0,0,0,0,0, '風',0,'颪','颫',0,'颭',0,'颯', */
	/* 98b0 */  9, 7,-1,-1,-1,-1, 7, 9,  9,-1, 7, 9, 9,-1,-1, 9, /* '颰','颱',0,0,0,0,'颶','颷', '颸',0,'颺','颻','颼',0,0,'颿', */
	/* 98c0 */ -1,-1, 9, 7, 7,-1, 7, 9,  7,-1,-1, 9,-1,-1,-1,-1, /* 0,0,'飂','飃','飄',0,'飆','飇', '飈',0,0,'飋',0,0,0,0, */
	/* 98d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7, 7,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,'飛','飜',0,0,'食', */
	/* 98e0 */  9, 9, 7, 9,-1, 9,-1, 7, -1, 7, 9, 7,-1, 7, 7, 7, /* '飠','飡','飢','飣',0,'飥',0,'飧', 0,'飩','飪','飫',0,'飭','飮','飯', */
	/* 98f0 */  9, 9, 7, 9, 7,-1,-1,-1, -1,-1,-1,-1, 7, 7, 7,-1, /* '飰','飱','飲','飳','飴',0,0,0, 0,0,0,0,'飼','飽','飾',0, */
	/* 9900 */ -1,-1,-1, 7,-1, 7,-1,-1,  9, 7, 7,-1, 7,-1,-1,-1, /* 0,0,0,'餃',0,'餅',0,0, '餈','餉','養',0,'餌',0,0,0, */
	/* 9910 */  7,-1, 7, 7, 7,-1, 9, 9,  7,-1, 9, 9, 9, 7, 7,-1, /* '餐',0,'餒','餓','餔',0,'餖','餗', '餘',0,'餚','餛','餜','餝','餞',0, */
	/* 9920 */  7, 7,-1,-1, 7,-1,-1,-1,  7,-1,-1,-1, 7,-1, 7,-1, /* '餠','餡',0,0,'餤',0,0,0, '館',0,0,0,'餬',0,'餮',0, */
	/* 9930 */ -1, 9, 9, 9,-1,-1,-1,-1, -1,-1, 9, 9, 9, 7, 7,-1, /* 0,'餱','餲','餳',0,0,0,0, 0,0,'餺','餻','餼','餽','餾',0, */
	/* 9940 */  9, 9, 7,-1,-1, 7, 9,-1, -1, 7,-1, 7, 7, 9, 9,-1, /* '饀','饁','饂',0,0,'饅','饆',0, 0,'饉',0,'饋','饌','饍','饎',0, */
	/* 9950 */  7, 7, 7,-1,-1, 7,-1, 7,  7,-1,-1,-1, 9,-1,-1, 9, /* '饐','饑','饒',0,0,'饕',0,'饗', '饘',0,0,0,'饜',0,0,'饟', */
	/* 9960 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '饠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9990 */ -1,-1,-1,-1,-1,-1, 7, 7,  7, 7,-1,-1,-1,-1, 7,-1, /* 0,0,0,0,0,0,'首','馗', '馘','香',0,0,0,0,'馞',0, */
	/* 99a0 */ -1,-1,-1, 9,-1, 7, 9,-1,  7,-1,-1,-1, 7, 7, 7,-1, /* 0,0,0,'馣',0,'馥','馦',0, '馨',0,0,0,'馬','馭','馮',0, */
	/* 99b0 */ -1,-1,-1, 7, 7,-1,-1,-1, -1, 9,-1,-1, 7, 9,-1, 9, /* 0,0,0,'馳','馴',0,0,0, 0,'馹',0,0,'馼','馽',0,'馿', */
	/* 99c0 */ -1, 7,-1, 9, 7, 7, 7,-1,  7, 9,-1,-1,-1,-1,-1,-1, /* 0,'駁',0,'駃','駄','駅','駆',0, '駈','駉',0,0,0,0,0,0, */
	/* 99d0 */  7, 7, 7,-1, 9, 7,-1,-1,  7, 9,-1, 7,-1, 7, 9, 7, /* '駐','駑','駒',0,'駔','駕',0,0, '駘','駙',0,'駛',0,'駝','駞','駟', */
	/* 99e0 */ -1,-1, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7, 7,-1, /* 0,0,'駢',0,0,0,0,0, 0,0,0,0,0,'駭','駮',0, */
	/* 99f0 */  9, 7, 7,-1,-1,-1,-1,-1,  7, 9,-1, 7, 9,-1,-1, 7, /* '駰','駱','駲',0,0,0,0,0, '駸','駹',0,'駻','駼',0,0,'駿', */
	/* 9a00 */ -1, 7, 7, 7,-1, 7,-1,-1, -1,-1, 9,-1,-1,-1, 7, 7, /* 0,'騁','騂','騃',0,'騅',0,0, 0,0,'騊',0,0,0,'騎','騏', */
	/* 9a10 */ -1, 9, 7, 7,-1,-1, 9,-1, -1, 7, 9,-1,-1,-1,-1,-1, /* 0,'騑','騒','験',0,0,'騖',0, 0,'騙','騚',0,0,0,0,0, */
	/* 9a20 */  9,-1,-1,-1, 7,-1,-1,-1,  7,-1,-1, 7,-1, 7, 7,-1, /* '騠',0,0,0,'騤',0,0,0, '騨',0,0,'騫',0,'騭','騮',0, */
	/* 9a30 */  7, 9,-1,-1,-1,-1, 9, 7,  7,-1,-1,-1,-1,-1, 7,-1, /* '騰','騱',0,0,0,0,'騶','騷', '騸',0,0,0,0,0,'騾',0, */
	/* 9a40 */  7,-1, 7, 7, 9, 7,-1,-1, -1,-1, 7,-1, 9, 7, 7,-1, /* '驀',0,'驂','驃','驄','驅',0,0, 0,0,'驊',0,'驌','驍','驎',0, */
	/* 9a50 */ -1,-1, 7,-1,-1, 7,-1, 7,  9,-1, 7, 7,-1,-1,-1, 7, /* 0,0,'驒',0,0,'驕',0,'驗', '驘',0,'驚','驛',0,0,0,'驟', */
	/* 9a60 */ -1,-1, 7,-1, 7, 7,-1,-1, -1, 7, 7, 7,-1,-1,-1,-1, /* 0,0,'驢',0,'驤','驥',0,0, 0,'驩','驪','驫',0,0,0,0, */
	/* 9a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9aa0 */ -1,-1,-1,-1,-1,-1,-1,-1,  7,-1,-1,-1,-1, 7,-1, 9, /* 0,0,0,0,0,0,0,0, '骨',0,0,0,0,'骭',0,'骯', */
	/* 9ab0 */  7,-1,-1,-1,-1,-1, 7, 9,  7, 9,-1,-1, 7,-1,-1,-1, /* '骰',0,0,0,0,0,'骶','骷', '骸','骹',0,0,'骼',0,0,0, */
	/* 9ac0 */  7, 7,-1, 7, 7,-1, 9,-1, -1,-1,-1,-1,-1,-1, 7, 7, /* '髀','髁',0,'髃','髄',0,'髆',0, 0,0,0,0,0,0,'髎','髏', */
	/* 9ad0 */  9, 7, 9, 7, 7, 9, 7,-1,  7,-1,-1,-1, 9,-1, 7, 7, /* '髐','髑','髒','髓','體','髕','髖',0, '高',0,0,0,'髜',0,'髞','髟', */
	/* 9ae0 */  9,-1, 7, 7,-1, 9, 7,-1, -1, 9, 7, 7,-1, 7, 7, 7, /* '髠',0,'髢','髣',0,'髥','髦',0, 0,'髩','髪','髫',0,'髭','髮','髯', */
	/* 9af0 */ -1, 7,-1,-1, 7,-1,-1, 7, -1, 7,-1, 7,-1,-1,-1,-1, /* 0,'髱',0,0,'髴',0,0,'髷', 0,'髹',0,'髻',0,0,0,0, */
	/* 9b00 */ -1,-1, 7, 9,-1,-1, 7,-1,  7,-1,-1,-1, 9,-1,-1,-1, /* 0,0,'鬂','鬃',0,0,'鬆',0, '鬈',0,0,0,'鬌',0,0,0, */
	/* 9b10 */  9,-1, 9,-1,-1,-1, 9,-1,  7,-1, 7,-1, 9,-1,-1, 7, /* '鬐',0,'鬒',0,0,0,'鬖',0, '鬘',0,'鬚',0,'鬜',0,0,'鬟', */
	/* 9b20 */  7,-1, 7, 7,-1, 7,-1, 7,  7, 7, 7, 9,-1, 7, 7, 7, /* '鬠',0,'鬢','鬣',0,'鬥',0,'鬧', '鬨','鬩','鬪','鬫',0,'鬭','鬮','鬯', */
	/* 9b30 */ -1, 7, 7, 9,-1,-1,-1,-1, -1,-1,-1, 7, 7, 9,-1,-1, /* 0,'鬱','鬲','鬳',0,0,0,0, 0,0,0,'鬻','鬼','鬽',0,0, */
	/* 9b40 */ -1, 7, 7, 7, 7, 7,-1,-1, -1,-1,-1, 9,-1, 7, 7, 7, /* 0,'魁','魂','魃','魄','魅',0,0, 0,0,0,'魋',0,'魍','魎','魏', */
	/* 9b50 */ -1, 7,-1,-1, 7,-1,-1,-1,  7,-1, 7,-1,-1,-1, 7,-1, /* 0,'魑',0,0,'魔',0,0,0, '魘',0,'魚',0,0,0,'魞',0, */
	/* 9b60 */ -1,-1,-1, 9,-1, 9, 7,-1, -1,-1,-1, 9, 9,-1,-1, 7, /* 0,0,0,'魣',0,'魥','魦',0, 0,0,0,'魫','魬',0,0,'魯', */
	/* 9b70 */ -1,-1, 7, 9, 7, 7, 9, 9, -1, 7,-1,-1,-1,-1,-1,-1, /* 0,0,'魲','魳','魴','魵','魶','魷', 0,'魹',0,0,0,0,0,0, */
	/* 9b80 */ -1,-1,-1, 7, 7,-1,-1,-1, -1,-1, 7,-1,-1,-1, 7, 7, /* 0,0,0,'鮃','鮄',0,0,0, 0,0,'鮊',0,0,0,'鮎','鮏', */
	/* 9b90 */ -1, 7, 7, 7,-1,-1, 7, 7, -1,-1,-1,-1,-1,-1, 7, 7, /* 0,'鮑','鮒','鮓',0,0,'鮖','鮗', 0,0,0,0,0,0,'鮞','鮟', */
	/* 9ba0 */  7,-1,-1,-1,-1,-1, 9, 7,  7,-1, 7, 7, 9, 7, 7,-1, /* '鮠',0,0,0,0,0,'鮦','鮧', '鮨',0,'鮪','鮫','鮬','鮭','鮮',0, */
	/* 9bb0 */ -1, 9, 9,-1, 7,-1,-1,-1,  9, 7,-1,-1,-1,-1, 9,-1, /* 0,'鮱','鮲',0,'鮴',0,0,0, '鮸','鮹',0,0,0,0,'鮾',0, */
	/* 9bc0 */  7, 7,-1,-1,-1,-1, 7, 9, -1, 7, 7,-1,-1,-1, 7, 7, /* '鯀','鯁',0,0,0,0,'鯆','鯇', 0,'鯉','鯊',0,0,0,'鯎','鯏', */
	/* 9bd0 */ -1, 7, 7,-1, 7,-1, 7,-1,  9,-1,-1, 7,-1, 9,-1,-1, /* 0,'鯑','鯒',0,'鯔',0,'鯖',0, '鯘',0,0,'鯛',0,'鯝',0,0, */
	/* 9be0 */ -1, 7, 7, 7, 7, 7,-1, 9,  7,-1, 9, 9,-1,-1, 9, 9, /* 0,'鯡','鯢','鯣','鯤','鯥',0,'鯧', '鯨',0,'鯪','鯫',0,0,'鯮','鯯', */
	/* 9bf0 */  7, 7, 7, 9,-1, 7,-1, 9,  7,-1, 9,-1,-1, 7,-1,-1, /* '鯰','鯱','鯲','鯳',0,'鯵',0,'鯷', '鯸',0,'鯺',0,0,'鯽',0,0, */
	/* 9c00 */  7,-1,-1,-1, 7,-1, 7,-1,  7, 7, 7,-1, 7, 7,-1,-1, /* '鰀',0,0,0,'鰄',0,'鰆',0, '鰈','鰉','鰊',0,'鰌','鰍',0,0, */
	/* 9c10 */  7,-1, 7, 7, 7, 7, 9,-1,  9, 9, 9, 7,-1, 9,-1,-1, /* '鰐',0,'鰒','鰓','鰔','鰕','鰖',0, '鰘','鰙','鰚','鰛',0,'鰝',0,0, */
	/* 9c20 */ -1, 7, 9, 7, 7, 7,-1, 9, -1, 9, 9,-1,-1, 7, 7, 7, /* 0,'鰡','鰢','鰣','鰤','鰥',0,'鰧', 0,'鰩','鰪',0,0,'鰭','鰮','鰯', */
	/* 9c30 */  7, 9, 7,-1,-1,-1, 9, 9, -1, 7, 7, 7,-1,-1, 7,-1, /* '鰰','鰱','鰲',0,0,0,'鰶','鰷', 0,'鰹','鰺','鰻',0,0,'鰾',0, */
	/* 9c40 */ -1, 7,-1,-1,-1, 9, 7, 7,  7, 9, 9,-1,-1,-1,-1, 7, /* 0,'鱁',0,0,0,'鱅','鱆','鱇', '鱈','鱉','鱊',0,0,0,0,'鱏', */
	/* 9c50 */  7,-1, 7, 7, 9,-1,-1, 7,  9,-1, 7, 9, 9, 9,-1, 9, /* '鱐',0,'鱒','鱓','鱔',0,0,'鱗', '鱘',0,'鱚','鱛','鱜','鱝',0,'鱟', */
	/* 9c60 */  7,-1,-1, 7,-1, 7,-1, 7, -1, 9, 9, 9,-1, 9, 9,-1, /* '鱠',0,0,'鱣',0,'鱥',0,'鱧', 0,'鱩','鱪','鱫',0,'鱭','鱮',0, */
	/* 9c70 */  9,-1, 9,-1,-1, 9, 7, 7,  7,-1, 9,-1,-1,-1,-1,-1, /* '鱰',0,'鱲',0,0,'鱵','鱶','鱷', '鱸',0,'鱺',0,0,0,0,0, */
	/* 9c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ce0 */ -1,-1,-1,-1,-1, 7, 9, 7, -1, 7,-1, 7, 7,-1,-1,-1, /* 0,0,0,0,0,'鳥','鳦','鳧', 0,'鳩',0,'鳫','鳬',0,0,0, */
	/* 9cf0 */  7,-1, 9, 7, 7,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '鳰',0,'鳲','鳳','鳴',0,'鳶',0, 0,0,0,0,0,0,0,0, */
	/* 9d00 */ -1,-1, 9, 7,-1,-1, 7, 7,  7, 7,-1, 9,-1,-1, 7,-1, /* 0,0,'鴂','鴃',0,0,'鴆','鴇', '鴈','鴉',0,'鴋',0,0,'鴎',0, */
	/* 9d10 */ -1, 9, 7,-1,-1, 7,-1, 9,  9,-1,-1, 7,-1, 7, 7, 7, /* 0,'鴑','鴒',0,0,'鴕',0,'鴗', '鴘',0,0,'鴛',0,'鴝','鴞','鴟', */
	/* 9d20 */ -1,-1,-1, 7,-1,-1, 7,-1,  7,-1, 7, 7, 7,-1,-1,-1, /* 0,0,0,'鴣',0,0,'鴦',0, '鴨',0,'鴪','鴫','鴬',0,0,0, */
	/* 9d30 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1, 7, 7, /* 0,0,'鴲',0,0,0,0,0, 0,0,0,'鴻',0,0,'鴾','鴿', */
	/* 9d40 */ -1, 7, 9, 7, 7,-1, 7, 7,  7,-1, 9,-1,-1,-1,-1,-1, /* 0,'鵁','鵂','鵃','鵄',0,'鵆','鵇', '鵈',0,'鵊',0,0,0,0,0, */
	/* 9d50 */  7, 7, 7,-1,-1,-1,-1,-1, -1, 7,-1,-1, 7, 7, 7, 9, /* '鵐','鵑','鵒',0,0,0,0,0, 0,'鵙',0,0,'鵜','鵝','鵞','鵟', */
	/* 9d60 */  7, 7, 9, 7, 7,-1,-1,-1, -1, 9,-1, 9, 7,-1,-1, 7, /* '鵠','鵡','鵢','鵣','鵤',0,0,0, 0,'鵩',0,'鵫','鵬',0,0,'鵯', */
	/* 9d70 */  7,-1, 7, 9,-1,-1, 9, 9, -1,-1, 7,-1, 7,-1, 9,-1, /* '鵰',0,'鵲','鵳',0,0,'鵶','鵷', 0,0,'鵺',0,'鵼',0,'鵾',0, */
	/* 9d80 */ -1,-1,-1,-1, 9,-1,-1, 7, -1, 7, 7,-1,-1, 9,-1, 7, /* 0,0,0,0,'鶄',0,0,'鶇', 0,'鶉','鶊',0,0,'鶍',0,'鶏', */
	/* 9d90 */ -1,-1,-1,-1,-1,-1, 7,-1, -1, 9, 7,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'鶖',0, 0,'鶙','鶚',0,0,0,0,0, */
	/* 9da0 */ -1, 9,-1,-1, 7,-1,-1,-1, -1, 7,-1, 7, 7,-1,-1, 7, /* 0,'鶡',0,0,'鶤',0,0,0, 0,'鶩',0,'鶫','鶬',0,0,'鶯', */
	/* 9db0 */ -1,-1, 7,-1, 7, 9,-1,-1,  7, 9, 7, 7, 7, 9,-1, 9, /* 0,0,'鶲',0,'鶴','鶵',0,0, '鶸','鶹','鶺','鶻','鶼','鶽',0,'鶿', */
	/* 9dc0 */  7, 7, 7, 9, 7,-1, 7, 9, -1, 9,-1,-1,-1,-1,-1, 7, /* '鷀','鷁','鷂','鷃','鷄',0,'鷆','鷇', 0,'鷉',0,0,0,0,0,'鷏', */
	/* 9dd0 */ -1,-1,-1, 7,-1,-1, 9, 7, -1, 7, 9,-1,-1,-1,-1, 9, /* 0,0,0,'鷓',0,0,'鷖','鷗', 0,'鷙','鷚',0,0,0,0,'鷟', */
	/* 9de0 */  9,-1,-1, 9,-1,-1, 7, 7, -1,-1,-1,-1,-1, 7,-1, 7, /* '鷠',0,0,'鷣',0,0,'鷦','鷧', 0,0,0,0,0,'鷭',0,'鷯', */
	/* 9df0 */ -1,-1, 7,-1, 9,-1,-1,-1,  7, 7, 7,-1,-1, 7,-1,-1, /* 0,0,'鷲',0,'鷴',0,0,0, '鷸','鷹','鷺',0,0,'鷽',0,0, */
	/* 9e00 */ -1,-1, 9,-1,-1,-1,-1, 7, -1,-1, 9,-1,-1, 9,-1,-1, /* 0,0,'鸂',0,0,0,0,'鸇', 0,0,'鸊',0,0,'鸍',0,0, */
	/* 9e10 */ -1,-1,-1,-1,-1, 7,-1,-1, -1, 9, 7, 7, 9, 9, 7,-1, /* 0,0,0,0,0,'鸕',0,0, 0,'鸙','鸚','鸛','鸜','鸝','鸞',0, */
	/* 9e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e70 */ -1,-1,-1,-1,-1, 7,-1,-1,  7, 7,-1, 9, 7, 7,-1, 7, /* 0,0,0,0,0,'鹵',0,0, '鹸','鹹',0,'鹻','鹼','鹽',0,'鹿', */
	/* 9e80 */  9, 7,-1,-1,-1, 9,-1,-1,  7,-1,-1, 7, 7,-1,-1,-1, /* '麀','麁',0,0,0,'麅',0,0, '麈',0,0,'麋','麌',0,0,0, */
	/* 9e90 */ -1, 7, 7, 7,-1, 7,-1, 7, -1,-1,-1, 9,-1, 7, 7, 7, /* 0,'麑','麒','麓',0,'麕',0,'麗', 0,0,0,'麛',0,'麝','麞','麟', */
	/* 9ea0 */ -1,-1,-1,-1, 7, 7, 7,-1,  9, 7, 7,-1, 7, 7,-1, 7, /* 0,0,0,0,'麤','麥','麦',0, '麨','麩','麪',0,'麬','麭',0,'麯', */
	/* 9eb0 */ -1,-1,-1,-1, 7, 7,-1,-1,  7, 7, 7, 7, 7, 9, 7, 7, /* 0,0,0,0,'麴','麵',0,0, '麸','麹','麺','麻','麼','麽','麾','麿', */
	/* 9ec0 */ -1,-1,-1, 7, 7,-1,-1,-1, -1,-1,-1,-1, 7, 7, 7, 7, /* 0,0,0,'黃','黄',0,0,0, 0,0,0,0,'黌','黍','黎','黏', */
	/* 9ed0 */  7, 7, 7,-1, 7,-1,-1,-1,  7, 7,-1, 7, 7, 7, 7, 9, /* '黐','黑','黒',0,'黔',0,0,0, '默','黙',0,'黛','黜','黝','點','黟', */
	/* 9ee0 */  7,-1,-1,-1,-1, 7,-1, 9,  7,-1,-1,-1,-1,-1, 9, 7, /* '黠',0,0,0,0,'黥',0,'黧', '黨',0,0,0,0,0,'黮','黯', */
	/* 9ef0 */ -1,-1,-1,-1, 7,-1, 7, 7, -1, 7,-1, 7, 7, 7,-1, 9, /* 0,0,0,0,'黴',0,'黶','黷', 0,'黹',0,'黻','黼','黽',0,'黿', */
	/* 9f00 */ -1,-1, 9, 9,-1,-1,-1, 7,  7,-1,-1,-1,-1,-1, 7,-1, /* 0,0,'鼂','鼃',0,0,0,'鼇', '鼈',0,0,0,0,0,'鼎',0, */
	/* 9f10 */  7,-1,-1, 7,-1, 7,-1, 9, -1, 9,-1,-1,-1,-1,-1,-1, /* '鼐',0,0,'鼓',0,'鼕',0,'鼗', 0,'鼙',0,0,0,0,0,0, */
	/* 9f20 */  7, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 7,-1,-1, 9, /* '鼠','鼡',0,0,0,0,0,0, 0,0,0,0,'鼬',0,0,'鼯', */
	/* 9f30 */ -1,-1,-1,-1,-1,-1,-1, 9, -1, 7, 9, 7,-1, 9, 7,-1, /* 0,0,0,0,0,0,0,'鼷', 0,'鼹','鼺','鼻',0,'鼽','鼾',0, */
	/* 9f40 */ -1, 9,-1,-1,-1, 9, 9,-1, -1,-1, 7, 7,-1,-1, 7, 7, /* 0,'齁',0,0,0,'齅','齆',0, 0,0,'齊','齋',0,0,'齎','齏', */
	/* 9f50 */ -1,-1, 7, 9, 7, 9,-1, 7,  9,-1,-1,-1,-1, 9,-1, 7, /* 0,0,'齒','齓','齔','齕',0,'齗', '齘',0,0,0,0,'齝',0,'齟', */
	/* 9f60 */  7, 7, 7, 7,-1,-1, 7, 7, -1, 9, 7,-1, 7, 9,-1,-1, /* '齠','齡','齢','齣',0,0,'齦','齧', 0,'齩','齪',0,'齬','齭',0,0, */
	/* 9f70 */  9,-1, 7,-1,-1, 9, 7, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* '齰',0,'齲',0,0,'齵','齶','齷', 0,0,0,0,0,0,0,0, */
	/* 9f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'龍',0,0, */
	/* 9f90 */  7,-1,-1,-1, 7, 7,-1, 7, -1,-1,-1,-1, 7, 7,-1,-1, /* '龐',0,0,0,'龔','龕',0,'龗', 0,0,0,0,'龜','龝',0,0, */
	/* 9fa0 */  7,-1, 7,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '龠',0,'龢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aaa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aaf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ace0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ada0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* adb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* adc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* add0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ade0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* adf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aeb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* baa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* baf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* beb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* caa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* caf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ceb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ced0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* daa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* daf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* deb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ded0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* def0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eaa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ead0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eaf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ece0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ede0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eeb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'欄',0,0, */
	/* f920 */ -1,-1,-1,-1,-1,-1,-1,-1,  7, 7,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '廊','朗',0,0,0,0,0,0, */
	/* f930 */ -1,-1,-1,-1,-1,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'虜',0, 0,0,0,0,0,0,0,0, */
	/* f940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f970 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '殺',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* f980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9d0 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 7,-1,-1,-1, /* '類',0,0,0,0,0,0,0, 0,0,0,0,'隆',0,0,0, */
	/* f9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'﨏', */
	/* fa10 */  7, 7,-1, 9, 7, 7, 7,-1, -1, 7, 7, 7,-1,-1,-1, 7, /* '塚','﨑',0,'﨓','﨔','凞','猪',0, 0,'神','祥','福',0,0,0,'﨟', */
	/* fa20 */  9, 9, 7,-1, 9,-1, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '蘒','﨡','諸',0,'﨤',0,'都',0, 0,0,0,0,0,0,0,0, */
	/* fa30 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '侮','僧','免','勉','勤','卑','喝','嘆', '器','塀','墨','層','屮','悔','慨','憎', */
	/* fa40 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 9, 7, 7, 7, 7, 7, 7, /* '懲','敏','既','暑','梅','海','渚','漢', '煮','爫','琢','碑','社','祉','祈','祐', */
	/* fa50 */  7, 7, 7, 7, 7, 7, 7, 7,  9, 7, 7, 7, 7, 9, 9, 7, /* '祖','祝','禍','禎','穀','突','節','練', '縉','繁','署','者','臭','艹','艹','著', */
	/* fa60 */  7, 7, 7, 7, 7, 7, 9, 7,  7, 7, 7,-1,-1,-1,-1,-1, /* '褐','視','謁','謹','賓','贈','辶','逸', '難','響','頻',0,0,0,0,0, */
	/* fa70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* faa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* faf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe40 */ -1,-1,-1,-1,-1, 7, 7,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'﹅','﹆',0, 0,0,0,0,0,0,0,0, */
	/* fe50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* feb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ff00 */ -1, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 0,'！','＂','＃','＄','％','＆','＇', '（','）','＊','＋','，','－','．','／', */
	/* ff10 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '０','１','２','３','４','５','６','７', '８','９','：','；','＜','＝','＞','？', */
	/* ff20 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '＠','Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ', 'Ｈ','Ｉ','Ｊ','Ｋ','Ｌ','Ｍ','Ｎ','Ｏ', */
	/* ff30 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'Ｐ','Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ', 'Ｘ','Ｙ','Ｚ','［','＼','］','＾','＿', */
	/* ff40 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* '｀','ａ','ｂ','ｃ','ｄ','ｅ','ｆ','ｇ', 'ｈ','ｉ','ｊ','ｋ','ｌ','ｍ','ｎ','ｏ', */
	/* ff50 */  7, 7, 7, 7, 7, 7, 7, 7,  7, 7, 7, 7, 7, 7, 7, 7, /* 'ｐ','ｑ','ｒ','ｓ','ｔ','ｕ','ｖ','ｗ', 'ｘ','ｙ','ｚ','｛','｜','｝','～','｟', */
	/* ff60 */  7, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1, /* '｠','｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* ff70 */  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* ff80 */  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* ff90 */  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
	/* ffa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffe0 */  7, 7, 7, 7, -1, 7, /* '￠','￡','￢','￣',0,'￥', */
};

const size_t _unibe2jis2022jp3_table_srg_bits_offset = 0x2e20;

const char _unibe2jis2022jp3_table_srg_bits[] = {
	/* 0000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𠀋',0,0,0,0, */
	/* 0010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𠂉',0,0,0,0,0,0, */
	/* 0090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00a0 */ -1,-1, 9,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𠂢',0,'𠂤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 00b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01a0 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𠆢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 01b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0210 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𠈓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𠌫',0,0,0,0, */
	/* 0330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0370 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𠍱',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0380 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𠎁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𠏹',0,0,0,0,0,0, */
	/* 0400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𠑊',0,0,0,0,0, */
	/* 0450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𠔉',0,0,0,0,0,0, */
	/* 0510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05d0 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𠗖',0, 0,0,0,0,0,0,0,0, */
	/* 05e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0620 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𠘨',0,0,0,0,0,0,0, */
	/* 0630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𠝏', */
	/* 0750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0800 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𠠇', 0,0,0,0,0,0,0,0, */
	/* 0810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𠠺',0,0,0,0,0, */
	/* 0840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𠢹',0,0,0,0,0,0, */
	/* 08c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𠥼',0,0,0, */
	/* 0980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𠦝',0,0, */
	/* 09a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ad0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𠫓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𠬝',0,0, */
	/* 0b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d40 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𠵅',0,0, 0,0,0,0,0,0,0,0, */
	/* 0d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0de0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𠷡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e60 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,'𠹤',0,0,0, 0,0,0,0,0,'𠹭',0,0, */
	/* 0e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e90 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𠺕',0,0, 0,0,0,0,0,0,0,0, */
	/* 0ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𠽟', */
	/* 0f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1200 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𡈁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𡈽',0,0, */
	/* 1240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1250 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𡉕',0,0, 0,0,0,0,0,0,0,0, */
	/* 1260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1270 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,'𡉴',0,0,0, 0,0,0,'𡉻',0,0,0,0, */
	/* 1280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12d0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𡋗', 0,0,0,0,0,0,0,0, */
	/* 12e0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𡋤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 12f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𡋽',0,0, */
	/* 1300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 7,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𡌛',0,0,0,0, */
	/* 1320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1330 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𡌶',0, 0,0,0,0,0,0,0,0, */
	/* 1340 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𡍄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13c0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𡏄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 13d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9, 7,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𡑭','𡑮',0, */
	/* 1470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15d0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𡗗', 0,0,0,0,0,0,0,0, */
	/* 15e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1640 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𡙇', 0,0,0,0,0,0,0,0, */
	/* 1650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16b0 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𡚴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 16c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1700 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𡜆',0, 0,0,0,0,0,0,0,0, */
	/* 1710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1740 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𡝂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𡢽',0,0, */
	/* 18c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19c0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𡧃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 19d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c50 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𡱖',0, 0,0,0,0,0,0,0,0, */
	/* 1c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𡴭',0,0, */
	/* 1d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d40 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𡵅',0,0, 0,0,0,0,0,0,0,0, */
	/* 1d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d60 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𡵢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1d70 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𡵸',0,0,0,0,0,0,0, */
	/* 1d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d90 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,'𡶒',0,0,0,0,0, 0,0,0,0,'𡶜',0,0,0, */
	/* 1da0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𡶡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1db0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𡶷', 0,0,0,0,0,0,0,0, */
	/* 1dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1de0 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𡷠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e30 */ -1,-1,-1, 9, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𡸳','𡸴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𡼞',0, */
	/* 1f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f70 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𡽶',0, 0,0,0,0,0,0,0,0, */
	/* 1f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𡿺',0,0,0,0,0, */
	/* 2000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𢅻',0,0,0,0, */
	/* 2180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2210 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𢈘',0,0,0,0,0,0,0, */
	/* 2220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𢌞',0, */
	/* 2320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𢎭',0,0, */
	/* 23b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26f0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𢛳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𢡛',0,0,0,0, */
	/* 2860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𢢫',0,0,0,0, */
	/* 28b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𢦏', */
	/* 2990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ab0 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𢪸',0,0,0,0,0,0,0, */
	/* 2ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b40 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,'𢭆',0, 0,0,0,0,0,0,0,'𢭏', */
	/* 2b50 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𢭐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ba0 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𢮦',0, 0,0,0,0,0,0,0,0, */
	/* 2bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𢰝',0,0, */
	/* 2c20 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𢰤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2de0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𢷡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 30a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 30b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 30c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 30d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 30e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 30f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31b0 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𣆶',0, 0,0,0,0,0,0,0,0, */
	/* 31c0 */ -1,-1,-1, 9, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𣇃','𣇄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 31d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31f0 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𣇵',0,0, 0,0,0,0,0,0,0,0, */
	/* 3200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3370 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𣍲',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33d0 */  9,-1, 9, 9,-1, 9,-1,-1, -1,-1, 9,-1,-1,-1,-1, 9, /* '𣏐',0,'𣏒','𣏓',0,'𣏕',0,0, 0,0,'𣏚',0,0,0,0,'𣏟', */
	/* 33e0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𣏤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 33f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𣑊','𣑋',0,0,0,0, */
	/* 3450 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𣑑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3460 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𣑥',0,0, 0,0,0,0,0,0,0,0, */
	/* 3470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34e0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𣓤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 34f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𣕚',0,0,0,0,0, */
	/* 3560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3590 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𣖔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 35a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35c0 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𣗄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 35d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3630 */ -1,-1,-1,-1,-1,-1,-1,-1,  9, 9, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𣘸','𣘹','𣘺',0,0,0,0,0, */
	/* 3640 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𣙇', 0,0,0,0,0,0,0,0, */
	/* 3650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𣜌',0,0,0, */
	/* 3710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𣜜',0,0,0, */
	/* 3720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𣜿', */
	/* 3740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3760 */ -1,-1,-1, 7, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𣝣','𣝤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37e0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𣟧', 0,0,0,0,0,0,0,0, */
	/* 37f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𣟿', */
	/* 3800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3820 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𣠤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𣠽',0,0, */
	/* 3840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a90 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𣪘',0,0,0,0,0,0,0, */
	/* 3aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𣱿', */
	/* 3c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 7,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𣳾',0, */
	/* 3d00 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* '𣴀',0,0,0,0,0,0,0, 0,0,0,0,0,0,'𣴎',0, */
	/* 3d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d40 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𣵀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3dd0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𣷓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𣷹','𣷺',0,0,0,0,0, */
	/* 3e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𣽾',0, */
	/* 3f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4090 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𤂖',0, 0,0,0,0,0,0,0,0, */
	/* 40a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4100 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𤄃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41c0 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𤇆',0, 0,0,0,0,0,0,0,0, */
	/* 41d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𤇾',0, */
	/* 4200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𤎼',0,0,0, */
	/* 43c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𤘩',0,0,0,0,0,0, */
	/* 4630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46a0 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𤚥',0,0, 0,0,0,0,0,0,0,0, */
	/* 46b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47f0 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𤟱',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4890 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𤢖',0, 0,0,0,0,0,0,0,0, */
	/* 48a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𤩍',0,0, */
	/* 4a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b50 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𤭖',0, 0,0,0,0,0,0,0,0, */
	/* 4b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𤭯', */
	/* 4b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c10 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𤰖',0, 0,0,0,0,0,0,0,0, */
	/* 4c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d10 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𤴔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𤸎',0, */
	/* 4e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4e30 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𤸷', 0,0,0,0,0,0,0,0, */
	/* 4e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𤹪',0,0,0,0,0, */
	/* 4e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𤺋',0,0,0,0, */
	/* 4e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𥁊',0,0,0,0,0, */
	/* 5050 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𥁕',0,0, 0,0,0,0,0,0,0,0, */
	/* 5060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 50a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 50b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 50c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 50d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 50e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 50f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5120 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𥄢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 51a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𥆩',0,0,0,0,0,0, */
	/* 51b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 51c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𥇍',0,0, */
	/* 51d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 51e0 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𥇥',0,0, 0,0,0,0,0,0,0,0, */
	/* 51f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𥈞',0, */
	/* 5220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𥉌',0,0,0, */
	/* 5250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 52a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 52b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 52c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 52d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 52e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 52f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 53a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 53b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 53c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 53d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 53e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 53f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𥐮',0, */
	/* 5430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 7,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𥒎',0, */
	/* 5490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 54a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 54b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 54c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 54d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𥓙',0,0,0,0,0,0, */
	/* 54e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 54f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 7,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𥔎',0, */
	/* 5510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 55a0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𥖧', 0,0,0,0,0,0,0,0, */
	/* 55b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 55c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 55d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 55e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 55f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 56a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 56b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 56c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 56d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 56e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 56f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5770 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𥝱',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 57a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𥞩',0,0,0,0,0,0, */
	/* 57b0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𥞴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 57d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 57e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 57f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 58a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 58b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 58c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 58d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 58e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 58f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 59a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 59b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 59c0 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𥧄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 59d0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𥧔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 59e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 59f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ae0 */ -1,-1,-1, 9, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𥫣','𥫤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5af0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𥫱',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5bb0 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𥮲',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𥱋',0,0,0,0, */
	/* 5c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5c60 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𥱤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5da0 */ -1, 7,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𥶡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𥸮',0, */
	/* 5e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5e50 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𥹖',0, 0,0,0,0,0,0,0,0, */
	/* 5e60 */ -1,-1, 9,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𥹢',0,0,'𥹥',0,0, 0,0,0,0,0,0,0,0, */
	/* 5e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ec0 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𥻂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5ed0 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𥻘',0,0,0,0,0,0,0, */
	/* 5ee0 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𥻨',0,0,0,0,0,0,0, */
	/* 5ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5f20 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𥼣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𥽜',0,0,0, */
	/* 5f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5fd0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𥿔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5fe0 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𥿠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𥿻',0,0,0,0, */
	/* 6000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𦀌',0,0,0, */
	/* 6010 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𦀗', 0,0,0,0,0,0,0,0, */
	/* 6020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6060 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𦁠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 60a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 60b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 60c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 60d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 60e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𦃭',0,0, */
	/* 60f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 61a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 61b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 61c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 61d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 61e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 61f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6270 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𦉰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6280 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𦊆',0, 0,0,0,0,0,0,0,0, */
	/* 6290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 62a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 62b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 62c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 62d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 62e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 62f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𦍌',0,0,0, */
	/* 6350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 63a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 63b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 63c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 63d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 63e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 63f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6400 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𦐂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 64a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 64b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 64c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 64d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 64e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 64f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 65a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 65b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 65c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 65d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 65e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 65f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𦙾',0, */
	/* 6680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 66a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 66b0 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𦚰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 66c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 66d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 66e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 66f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𦜝',0,0, */
	/* 6720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 67a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 67b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 67c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 67d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 67e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 67f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 68a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 68b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 68c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 68d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𦣝',0,0, */
	/* 68e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𦣪',0,0,0,0,0, */
	/* 68f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6950 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𦥑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𦥯', */
	/* 6970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 69a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 69b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 69c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 69d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𦧝',0,0, */
	/* 69e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 69f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𦨞',0, */
	/* 6a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6a50 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𦩘',0,0,0,0,0,0,0, */
	/* 6a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𦪌',0,0,0, */
	/* 6a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ab0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𦪷', 0,0,0,0,0,0,0,0, */
	/* 6ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 7, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𦫿', */
	/* 6b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𦰩',0,0,0,0,0,0, */
	/* 6c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6c70 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𦱳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𦳝',0,0, */
	/* 6ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6e40 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𦹀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6e60 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𦹥',0,0, 0,0,0,0,0,0,0,0, */
	/* 6e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6f90 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𦾔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 6ff0 */ -1,-1,-1,-1,-1,-1, 9, 9,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𦿶','𦿷', '𦿸',0,0,0,0,0,0,0, */
	/* 7000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 70a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 70b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 70c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 70d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 70e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 70f0 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𧃴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𧄍',0,0, */
	/* 7110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𧄹',0,0,0,0,0,0, */
	/* 7140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 71a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 71b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 71c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 71d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 71e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 71f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 72a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 72b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 72c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 72d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 72e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 72f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 73a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 73b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 73c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 73d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𧏚','𧏛',0,0,0,0, */
	/* 73e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 73f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𧏾',0, */
	/* 7400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7410 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𧐐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𧑉',0,0,0,0,0,0, */
	/* 7450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 74a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 74b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 74c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 74d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 74e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 74f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 75a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 75b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 75c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 75d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 75e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 75f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7610 */ -1,-1,-1,-1, 9, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𧘔','𧘕',0,0, 0,0,0,0,0,0,0,0, */
	/* 7620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7630 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𧘱',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7680 */ -1,-1,-1,-1, 7,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𧚄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7690 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𧚓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 76a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 76b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 76c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 76d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 76e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 76f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𧜎',0, */
	/* 7710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7720 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𧜣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7750 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𧝒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 77a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 77b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 77c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 77d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 77e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 77f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 78a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 78b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 78c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 78d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 78e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 78f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7980 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𧦅',0,0, 0,0,0,0,0,0,0,0, */
	/* 7990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 79a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 79b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 79c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 79d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 79e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 79f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7a80 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𧪄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7bb0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,'𧮳',0,0,0,0, 0,0,0,0,0,0,'𧮾',0, */
	/* 7bc0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𧯇', 0,0,0,0,0,0,0,0, */
	/* 7bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7cb0 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𧲸',0,0,0,0,0,0,0, */
	/* 7cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7da0 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𧶠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7e10 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𧸐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7fb0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𧾷', 0,0,0,0,0,0,0,0, */
	/* 7fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𨂊',0,0,0,0,0, */
	/* 8090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 80a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 80b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𨂻',0,0,0,0, */
	/* 80c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 80d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 80e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 80f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 81a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 81b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 81c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 81d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 81e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 81f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8270 */ -1,-1,-1,-1,-1,-1,-1, 7, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𨉷', 0,0,0,0,0,0,0,0, */
	/* 8280 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𨊂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 82a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 82b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 82c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 82d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 82e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 82f0 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𨋳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 83a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 83b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 83c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 7,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𨏍',0,0, */
	/* 83d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 83e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 83f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𨐌',0,0,0, */
	/* 8410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8450 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𨑕',0,0, 0,0,0,0,0,0,0,0, */
	/* 8460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 84a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 84b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 84c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 84d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 84e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 84f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𨕫',0,0,0,0, */
	/* 8570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 85a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 85b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 85c0 */ -1,-1,-1,-1,-1,-1,-1,-1,  9, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𨗈','𨗉',0,0,0,0,0,0, */
	/* 85d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 85e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 85f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 86a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 86b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 86c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 86d0 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𨛗', 0,0,0,0,0,0,0,0, */
	/* 86e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 86f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𨛺',0,0,0,0,0, */
	/* 8700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 87a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 87b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 87c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 87d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 87e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 87f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 88a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 88b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 88c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 88d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 88e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 88f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8940 */ -1,-1,-1,-1,-1,-1, 9,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𨥆',0, 0,'𨥉',0,0,0,0,0,0, */
	/* 8950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𨥫',0,0,0,0, */
	/* 8970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8980 */ -1,-1,-1,-1,-1,-1,-1, 9,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𨦇', '𨦈',0,0,0,0,0,0,0, */
	/* 8990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 89a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 89b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𨦺','𨦻',0,0,0,0, */
	/* 89c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 89d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 89e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 89f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𨨞',0, */
	/* 8a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𨨩',0,0,0,0,0,0, */
	/* 8a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8a40 */ -1,-1,-1, 9,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'𨩃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8a70 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𨩱',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𨪙',0,0,0,0,0,0, */
	/* 8aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𨫍',0,0, */
	/* 8ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𨫝',0,0, */
	/* 8ae0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𨫤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bc0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𨯁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𨯯', */
	/* 8bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d10 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𨴐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d70 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𨵱',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𨷻',0,0,0,0, */
	/* 8e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𨸟', */
	/* 8e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8e30 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𨸶',0, 0,0,0,0,0,0,0,0, */
	/* 8e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𨺉',0,0,0,0,0,0, */
	/* 8e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𨻫',0,0,0,0, */
	/* 8ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f30 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𨼲',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8ff0 */ -1,-1,-1,-1,-1,-1,-1,-1,  9,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '𨿸',0,0,0,0,0,0,0, */
	/* 9000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 90a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 90b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 90c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 90d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 90e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 90f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 91a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 91b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 91c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 91d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 91e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 91f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 92a0 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𩊠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 92b0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𩊱',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 92c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 92d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 92e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 92f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 93a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 93b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 93c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 93d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 93e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 93f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9490 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𩒐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 94a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 95a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 95b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 95c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𩗏', */
	/* 95d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 95e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 95f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𩙿', */
	/* 9680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 96a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 96b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 96c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 96d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 96e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 96f0 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𩛰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𩜙',0,0,0,0,0,0, */
	/* 9720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9750 */  9,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𩝐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 97a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 97b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 97c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 97d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 97e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 97f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 98a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 98b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 98c0 */ -1,-1,-1,-1,-1,-1, 9,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'𩣆',0, 0,0,0,0,0,0,0,0, */
	/* 98d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 98e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 98f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 99a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 99b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 99c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 99d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 99e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 99f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a70 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𩩲',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𩷛',0,0,0,0, */
	/* 9de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e10 */ -1,-1,-1,-1,-1, 9,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'𩸕',0,0, 0,0,0,0,0,0,0,0, */
	/* 9e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 9,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'𩸽',0,0, */
	/* 9e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𩹉',0,0,0,0,0,0, */
	/* 9e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𩺊',0,0,0,0,0, */
	/* 9e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ec0 */ -1,-1,-1,-1, 9,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'𩻄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 9,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'𩻛',0,0,0,0, */
	/* 9ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𩻩',0,0,0,0,0,0, */
	/* 9ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 9,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'𩿎',0, */
	/* 9fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𪀚',0,0,0,0,0, */
	/* a020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 9, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'𪀯', */
	/* a030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a080 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𪂂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* a090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 9,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'𪃹',0,0,0,0,0,0, */
	/* a100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a190 */  7,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '𪆐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* a1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 9,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'𪎌',0,0,0, */
	/* a390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a430 */ -1,-1,-1,-1,-1,-1,-1, 9, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'𪐷', 0,0,0,0,0,0,0,0, */
	/* a440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5f0 */ -1, 9,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'𪗱',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* a600 */ -1,-1, 9,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'𪘂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* a610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 9,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,'𪘚',0,0,0,0,0, */
	/* a620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6b0 */ -1,-1, 9, /* 0,0,'𪚲', */
};

const size_t _unibe2jis2022jp3_table_bits_size = sizeof(_unibe2jis2022jp3_table_bits) / sizeof(_unibe2jis2022jp3_table_bits[0]);
const size_t _unibe2jis2022jp3_table_srg_bits_size = sizeof(_unibe2jis2022jp3_table_srg_bits) / sizeof(_unibe2jis2022jp3_table_srg_bits[0]);

#endif /* #ifndef __UNIBE2JIS2022JP3_TABLE_BITS_H_ */
