/*
 * _unibe2jis2022jp_table.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __UNIBE2JIS2022_JP_TABLE_H_
#define __UNIBE2JIS2022_JP_TABLE_H_

#include <stddef.h>
#include <stdint.h>

const uint16_t _unibe2jis2022jp_table[] = {
	/* 0000 */ 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, 0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* '','','','','','','','', '','','','','','','','', */
	/* 0010 */ 0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, 0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* '','','','','','','','', '','','','','','','','', */
	/* 0020 */ 0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, 0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* ' ','!','"','#','$','%','&','\\'', '(',')','*','+',',','-','.','/', */
	/* 0030 */ 0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, 0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* '0','1','2','3','4','5','6','7', '8','9',':',';','<','=','>','?', */
	/* 0040 */ 0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, 0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O', */
	/* 0050 */ 0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, 0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 'P','Q','R','S','T','U','V','W', 'X','Y','Z','[','\',']','^','_', */
	/* 0060 */ 0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, 0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* '`','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o', */
	/* 0070 */ 0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, 0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0, /* 'p','q','r','s','t','u','v','w', 'x','y','z','{','|','}','~',0, */
	/* 0080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00a0 */ 0,0,0x2171,0x2172,0,0,0,0x2178, 0x212f,0,0,0,0x224c,0,0,0, /* 0,0,'¢','£',0,0,0,'§', '¨',0,0,0,'¬',0,0,0, */
	/* 00b0 */ 0x216b,0x215e,0,0,0x212d,0,0x2279,0, 0,0,0,0,0,0,0,0, /* '°','±',0,0,'´',0,'¶',0, 0,0,0,0,0,0,0,0, */
	/* 00c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00d0 */ 0,0,0,0,0,0,0,0x215f, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'×', 0,0,0,0,0,0,0,0, */
	/* 00e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00f0 */ 0,0,0,0,0,0,0,0x2160, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'÷', 0,0,0,0,0,0,0,0, */
	/* 0100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0390 */ 0,0x2621,0x2622,0x2623,0x2624,0x2625,0x2626,0x2627, 0x2628,0x2629,0x262a,0x262b,0x262c,0x262d,0x262e,0x262f, /* 0,'Α','Β','Γ','Δ','Ε','Ζ','Η', 'Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο', */
	/* 03a0 */ 0x2630,0x2631,0,0x2632,0x2633,0x2634,0x2635,0x2636, 0x2637,0x2638,0,0,0,0,0,0, /* 'Π','Ρ',0,'Σ','Τ','Υ','Φ','Χ', 'Ψ','Ω',0,0,0,0,0,0, */
	/* 03b0 */ 0,0x2641,0x2642,0x2643,0x2644,0x2645,0x2646,0x2647, 0x2648,0x2649,0x264a,0x264b,0x264c,0x264d,0x264e,0x264f, /* 0,'α','β','γ','δ','ε','ζ','η', 'θ','ι','κ','λ','μ','ν','ξ','ο', */
	/* 03c0 */ 0x2650,0x2651,0,0x2652,0x2653,0x2654,0x2655,0x2656, 0x2657,0x2658,0,0,0,0,0,0, /* 'π','ρ',0,'σ','τ','υ','φ','χ', 'ψ','ω',0,0,0,0,0,0, */
	/* 03d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0400 */ 0,0x2727,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'Ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0410 */ 0x2721,0x2722,0x2723,0x2724,0x2725,0x2726,0x2728,0x2729, 0x272a,0x272b,0x272c,0x272d,0x272e,0x272f,0x2730,0x2731, /* 'А','Б','В','Г','Д','Е','Ж','З', 'И','Й','К','Л','М','Н','О','П', */
	/* 0420 */ 0x2732,0x2733,0x2734,0x2735,0x2736,0x2737,0x2738,0x2739, 0x273a,0x273b,0x273c,0x273d,0x273e,0x273f,0x2740,0x2741, /* 'Р','С','Т','У','Ф','Х','Ц','Ч', 'Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я', */
	/* 0430 */ 0x2751,0x2752,0x2753,0x2754,0x2755,0x2756,0x2758,0x2759, 0x275a,0x275b,0x275c,0x275d,0x275e,0x275f,0x2760,0x2761, /* 'а','б','в','г','д','е','ж','з', 'и','й','к','л','м','н','о','п', */
	/* 0440 */ 0x2762,0x2763,0x2764,0x2765,0x2766,0x2767,0x2768,0x2769, 0x276a,0x276b,0x276c,0x276d,0x276e,0x276f,0x2770,0x2771, /* 'р','с','т','у','ф','х','ц','ч', 'ш','щ','ъ','ы','ь','э','ю','я', */
	/* 0450 */ 0,0x2757,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2010 */ 0x213e,0,0,0,0,0x213d,0x2142,0, 0x2146,0x2147,0,0,0x2148,0x2149,0,0, /* '‐',0,0,0,0,'―','‖',0, '‘','’',0,0,'“','”',0,0, */
	/* 2020 */ 0x2277,0x2278,0,0,0,0x2145,0x2144,0, 0,0,0,0,0,0,0,0, /* '†','‡',0,0,0,'‥','…',0, 0,0,0,0,0,0,0,0, */
	/* 2030 */ 0x2273,0,0x216c,0x216d,0,0,0,0, 0,0,0,0x2228,0,0,0x007e,0, /* '‰',0,'′','″',0,0,0,0, 0,0,0,'※',0,0,'‾',0, */
	/* 2040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2100 */ 0,0,0,0x216e,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'℃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2120 */ 0,0,0,0,0,0,0,0, 0,0,0,0x2272,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'Å',0,0,0,0, */
	/* 2130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2190 */ 0x222b,0x222c,0x222a,0x222d,0,0,0,0, 0,0,0,0,0,0,0,0, /* '←','↑','→','↓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21d0 */ 0,0,0x224d,0,0x224e,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⇒',0,'⇔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2200 */ 0x224f,0,0x225f,0x2250,0,0,0,0x2260, 0x223a,0,0,0x223b,0,0,0,0, /* '∀',0,'∂','∃',0,0,0,'∇', '∈',0,0,'∋',0,0,0,0, */
	/* 2210 */ 0,0,0x215d,0,0,0,0,0, 0,0,0x2265,0,0,0x2267,0x2167,0, /* 0,0,'−',0,0,0,0,0, 0,0,'√',0,0,'∝','∞',0, */
	/* 2220 */ 0x225c,0,0,0,0,0,0,0x224a, 0x224b,0x2241,0x2240,0x2269,0x226a,0,0,0, /* '∠',0,0,0,0,0,0,'∧', '∨','∩','∪','∫','∬',0,0,0, */
	/* 2230 */ 0,0,0,0,0x2168,0x2268,0,0, 0,0,0,0,0,0x2266,0,0, /* 0,0,0,0,'∴','∵',0,0, 0,0,0,0,0,'∽',0,0, */
	/* 2240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2250 */ 0,0,0x2262,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'≒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2260 */ 0x2162,0x2261,0,0,0,0,0x2165,0x2166, 0,0,0x2263,0x2264,0,0,0,0, /* '≠','≡',0,0,0,0,'≦','≧', 0,0,'≪','≫',0,0,0,0, */
	/* 2270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2280 */ 0,0,0x223e,0x223f,0,0,0x223c,0x223d, 0,0,0,0,0,0,0,0, /* 0,0,'⊂','⊃',0,0,'⊆','⊇', 0,0,0,0,0,0,0,0, */
	/* 2290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22a0 */ 0,0,0,0,0,0x225d,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⊥',0,0, 0,0,0,0,0,0,0,0, */
	/* 22b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2310 */ 0,0,0x225e,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⌒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2500 */ 0x2821,0x282c,0x2822,0x282d,0,0,0,0, 0,0,0,0,0x2823,0,0,0x282e, /* '─','━','│','┃',0,0,0,0, 0,0,0,0,'┌',0,0,'┏', */
	/* 2510 */ 0x2824,0,0,0x282f,0x2826,0,0,0x2831, 0x2825,0,0,0x2830,0x2827,0x283c,0,0, /* '┐',0,0,'┓','└',0,0,'┗', '┘',0,0,'┛','├','┝',0,0, */
	/* 2520 */ 0x2837,0,0,0x2832,0x2829,0x283e,0,0, 0x2839,0,0,0x2834,0x2828,0,0,0x2838, /* '┠',0,0,'┣','┤','┥',0,0, '┨',0,0,'┫','┬',0,0,'┯', */
	/* 2530 */ 0x283d,0,0,0x2833,0x282a,0,0,0x283a, 0x283f,0,0,0x2835,0x282b,0,0,0x283b, /* '┰',0,0,'┳','┴',0,0,'┷', '┸',0,0,'┻','┼',0,0,'┿', */
	/* 2540 */ 0,0,0x2840,0,0,0,0,0, 0,0,0,0x2836,0,0,0,0, /* 0,0,'╂',0,0,0,0,0, 0,0,0,'╋',0,0,0,0, */
	/* 2550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25a0 */ 0x2223,0x2222,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '■','□',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25b0 */ 0,0,0x2225,0x2224,0,0,0,0, 0,0,0,0,0x2227,0x2226,0,0, /* 0,0,'▲','△',0,0,0,0, 0,0,0,0,'▼','▽',0,0, */
	/* 25c0 */ 0,0,0,0,0,0,0x2221,0x217e, 0,0,0,0x217b,0,0,0x217d,0x217c, /* 0,0,0,0,0,0,'◆','◇', 0,0,0,'○',0,0,'◎','●', */
	/* 25d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x227e, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'◯', */
	/* 25f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2600 */ 0,0,0,0,0,0x217a,0x2179,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'★','☆',0, 0,0,0,0,0,0,0,0, */
	/* 2610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2640 */ 0x216a,0,0x2169,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '♀',0,'♂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2660 */ 0,0,0,0,0,0,0,0, 0,0,0x2276,0,0,0x2275,0,0x2274, /* 0,0,0,0,0,0,0,0, 0,0,'♪',0,0,'♭',0,'♯', */
	/* 2670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3000 */ 0x2121,0x2122,0x2123,0x2137,0,0x2139,0x213a,0x213b, 0x2152,0x2153,0x2154,0x2155,0x2156,0x2157,0x2158,0x2159, /* '　','、','。','〃',0,'々','〆','〇', '〈','〉','《','》','「','」','『','』', */
	/* 3010 */ 0x215a,0x215b,0x2229,0x222e,0x214c,0x214d,0,0, 0,0,0,0,0x2141,0,0,0, /* '【','】','〒','〓','〔','〕',0,0, 0,0,0,0,'〜',0,0,0, */
	/* 3020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3040 */ 0,0x2421,0x2422,0x2423,0x2424,0x2425,0x2426,0x2427, 0x2428,0x2429,0x242a,0x242b,0x242c,0x242d,0x242e,0x242f, /* 0,'ぁ','あ','ぃ','い','ぅ','う','ぇ', 'え','ぉ','お','か','が','き','ぎ','く', */
	/* 3050 */ 0x2430,0x2431,0x2432,0x2433,0x2434,0x2435,0x2436,0x2437, 0x2438,0x2439,0x243a,0x243b,0x243c,0x243d,0x243e,0x243f, /* 'ぐ','け','げ','こ','ご','さ','ざ','し', 'じ','す','ず','せ','ぜ','そ','ぞ','た', */
	/* 3060 */ 0x2440,0x2441,0x2442,0x2443,0x2444,0x2445,0x2446,0x2447, 0x2448,0x2449,0x244a,0x244b,0x244c,0x244d,0x244e,0x244f, /* 'だ','ち','ぢ','っ','つ','づ','て','で', 'と','ど','な','に','ぬ','ね','の','は', */
	/* 3070 */ 0x2450,0x2451,0x2452,0x2453,0x2454,0x2455,0x2456,0x2457, 0x2458,0x2459,0x245a,0x245b,0x245c,0x245d,0x245e,0x245f, /* 'ば','ぱ','ひ','び','ぴ','ふ','ぶ','ぷ', 'へ','べ','ぺ','ほ','ぼ','ぽ','ま','み', */
	/* 3080 */ 0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,0x2467, 0x2468,0x2469,0x246a,0x246b,0x246c,0x246d,0x246e,0x246f, /* 'む','め','も','ゃ','や','ゅ','ゆ','ょ', 'よ','ら','り','る','れ','ろ','ゎ','わ', */
	/* 3090 */ 0x2470,0x2471,0x2472,0x2473,0,0,0,0, 0,0,0,0x212b,0x212c,0x2135,0x2136,0, /* 'ゐ','ゑ','を','ん',0,0,0,0, 0,0,0,'゛','゜','ゝ','ゞ',0, */
	/* 30a0 */ 0,0x2521,0x2522,0x2523,0x2524,0x2525,0x2526,0x2527, 0x2528,0x2529,0x252a,0x252b,0x252c,0x252d,0x252e,0x252f, /* 0,'ァ','ア','ィ','イ','ゥ','ウ','ェ', 'エ','ォ','オ','カ','ガ','キ','ギ','ク', */
	/* 30b0 */ 0x2530,0x2531,0x2532,0x2533,0x2534,0x2535,0x2536,0x2537, 0x2538,0x2539,0x253a,0x253b,0x253c,0x253d,0x253e,0x253f, /* 'グ','ケ','ゲ','コ','ゴ','サ','ザ','シ', 'ジ','ス','ズ','セ','ゼ','ソ','ゾ','タ', */
	/* 30c0 */ 0x2540,0x2541,0x2542,0x2543,0x2544,0x2545,0x2546,0x2547, 0x2548,0x2549,0x254a,0x254b,0x254c,0x254d,0x254e,0x254f, /* 'ダ','チ','ヂ','ッ','ツ','ヅ','テ','デ', 'ト','ド','ナ','ニ','ヌ','ネ','ノ','ハ', */
	/* 30d0 */ 0x2550,0x2551,0x2552,0x2553,0x2554,0x2555,0x2556,0x2557, 0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,0x255f, /* 'バ','パ','ヒ','ビ','ピ','フ','ブ','プ', 'ヘ','ベ','ペ','ホ','ボ','ポ','マ','ミ', */
	/* 30e0 */ 0x2560,0x2561,0x2562,0x2563,0x2564,0x2565,0x2566,0x2567, 0x2568,0x2569,0x256a,0x256b,0x256c,0x256d,0x256e,0x256f, /* 'ム','メ','モ','ャ','ヤ','ュ','ユ','ョ', 'ヨ','ラ','リ','ル','レ','ロ','ヮ','ワ', */
	/* 30f0 */ 0x2570,0x2571,0x2572,0x2573,0x2574,0x2575,0x2576,0, 0,0,0,0x2126,0x213c,0x2133,0x2134,0, /* 'ヰ','ヱ','ヲ','ン','ヴ','ヵ','ヶ',0, 0,0,0,'・','ー','ヽ','ヾ',0, */
	/* 3100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e00 */ 0x306c,0x437a,0,0x3c37,0,0,0,0x4b7c, 0x3e66,0x3b30,0x3e65,0x323c,0,0x4954,0x4d3f,0, /* '一','丁',0,'七',0,0,0,'万', '丈','三','上','下',0,'不','与',0, */
	/* 4e10 */ 0x5022,0x312f,0,0,0x336e,0x5023,0x4024,0x5242, 0x3556,0x4a3a,0,0,0,0,0x3e67,0, /* '丐','丑',0,0,'且','丕','世','丗', '丘','丙',0,0,0,0,'丞',0, */
	/* 4e20 */ 0,0x4e3e,0,0,0,0,0x4a42,0, 0,0,0x5024,0,0,0x4366,0,0, /* 0,'両',0,0,0,0,'並',0, 0,0,'个',0,0,'中',0,0, */
	/* 4e30 */ 0,0x5025,0x367a,0,0,0,0x5026,0, 0x345d,0x4330,0,0x3c67,0x5027,0,0,0x5028, /* 0,'丱','串',0,0,0,'丶',0, '丸','丹',0,'主','丼',0,0,'丿', */
	/* 4e40 */ 0,0,0x5029,0x4735,0,0x3557,0,0, 0,0,0,0x4737,0,0x4663,0x3843,0x4b33, /* 0,0,'乂','乃',0,'久',0,0, 0,0,0,'之',0,'乍','乎','乏', */
	/* 4e50 */ 0,0,0,0,0,0x6949,0x502a,0x3e68, 0x502b,0x3235,0,0,0,0x3665,0x3870,0x4c69, /* 0,0,0,0,0,'乕','乖','乗', '乘','乙',0,0,0,'九','乞','也', */
	/* 4e60 */ 0,0,0x5626,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'乢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4e70 */ 0,0x4d70,0,0x467d,0,0,0,0, 0,0,0,0,0,0,0x3425,0, /* 0,'乱',0,'乳',0,0,0,0, 0,0,0,0,0,0,'乾',0, */
	/* 4e80 */ 0x3535,0,0x502c,0,0,0x502d,0x4e3b,0, 0x4d3d,0x4168,0x502f,0x3b76,0x4673,0,0x5032,0, /* '亀',0,'亂',0,0,'亅','了',0, '予','争','亊','事','二',0,'于',0, */
	/* 4e90 */ 0,0x313e,0x385f,0,0x385e,0x3066,0,0, 0x4f4b,0x4f4a,0,0x3a33,0x3021,0,0x5033,0x5034, /* 0,'云','互',0,'五','井',0,0, '亘','亙',0,'些','亜',0,'亞','亟', */
	/* 4ea0 */ 0x5035,0x4b34,0x5036,0,0x3872,0x3067,0x4b72,0, 0x357c,0,0,0x357d,0x357e,0x4462,0x4e3c,0, /* '亠','亡','亢',0,'交','亥','亦',0, '亨',0,0,'享','京','亭','亮',0, */
	/* 4eb0 */ 0x5037,0,0,0x5038,0,0,0x5039,0, 0,0,0x3f4d,0,0,0,0,0, /* '亰',0,0,'亳',0,0,'亶',0, 0,0,'人',0,0,0,0,0, */
	/* 4ec0 */ 0x3d3a,0x3f4e,0x503e,0,0x503c,0,0x503d,0x3558, 0,0,0x3a23,0x3270,0,0x503b,0x503a,0x4a29, /* '什','仁','仂',0,'仄',0,'仆','仇', 0,0,'今','介',0,'仍','从','仏', */
	/* 4ed0 */ 0,0,0,0,0x3b46,0x3b45,0x423e,0x503f, 0x4955,0x4067,0,0,0,0x2138,0x5040,0x5042, /* 0,0,0,0,'仔','仕','他','仗', '付','仙',0,0,0,'仝','仞','仟', */
	/* 4ee0 */ 0,0,0,0x4265,0x4e61,0x304a,0,0, 0,0,0,0,0,0x5041,0x323e,0, /* 0,0,0,'代','令','以',0,0, 0,0,0,0,0,'仭','仮',0, */
	/* 4ef0 */ 0x3644,0,0x4367,0,0,0,0x376f,0x5043, 0,0,0,0x4724,0,0,0,0, /* '仰',0,'仲',0,0,0,'件','价', 0,0,0,'任',0,0,0,0, */
	/* 4f00 */ 0,0x346b,0,0,0,0,0,0, 0,0x5044,0x304b,0,0,0x3860,0x346c,0x497a, /* 0,'企',0,0,0,0,0,0, 0,'伉','伊',0,0,'伍','伎','伏', */
	/* 4f10 */ 0x4832,0x3559,0,0,0,0,0,0, 0,0,0x3271,0,0x5067,0x4541,0,0, /* '伐','休',0,0,0,0,0,0, 0,0,'会',0,'伜','伝',0,0, */
	/* 4f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x476c, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'伯', */
	/* 4f30 */ 0x5046,0,0,0,0x483c,0,0x4e62,0, 0x3f2d,0,0x3b47,0,0x3b77,0x3240,0,0, /* '估',0,0,0,'伴',0,'伶',0, '伸',0,'伺',0,'似','伽',0,0, */
	/* 4f40 */ 0,0,0,0x4451,0,0,0x4322,0x504a, 0,0,0,0,0,0x304c,0x4463,0x3d3b, /* 0,0,0,'佃',0,0,'但','佇', 0,0,0,0,0,'位','低','住', */
	/* 4f50 */ 0x3a34,0x4d24,0,0x424e,0,0x323f,0,0x5049, 0,0x4d3e,0x5045,0x5047,0x3a6e,0x5048,0x5524,0, /* '佐','佑',0,'体',0,'何',0,'佗', 0,'余','佚','佛','作','佝','佞',0, */
	/* 4f60 */ 0,0,0,0,0,0,0,0, 0,0x5050,0,0,0,0,0,0x5053, /* 0,0,0,0,0,0,0,0, 0,'佩',0,0,0,0,0,'佯', */
	/* 4f70 */ 0x5051,0,0,0x3242,0,0x4a3b,0x504b,0, 0,0,0,0x504f,0x3873,0,0,0x3b48, /* '佰',0,0,'佳',0,'併','佶',0, 0,0,0,'佻','佼',0,0,'使', */
	/* 4f80 */ 0,0,0,0x3426,0,0,0x5054,0, 0x504c,0,0,0x4e63,0,0x3b78,0,0x504d, /* 0,0,0,'侃',0,0,'來',0, '侈',0,0,'例',0,'侍',0,'侏', */
	/* 4f90 */ 0,0x5052,0,0,0,0,0x5055,0, 0x504e,0,0,0x3621,0,0x304d,0,0, /* 0,'侑',0,0,0,0,'侖',0, '侘',0,0,'供',0,'依',0,0, */
	/* 4fa0 */ 0x3622,0x3241,0,0,0,0,0,0, 0,0,0,0x5525,0,0x4b79,0x496e,0x3874, /* '侠','価',0,0,0,0,0,0, 0,0,0,'侫',0,'侭','侮','侯', */
	/* 4fb0 */ 0,0,0,0,0,0x3f2f,0x4e37,0, 0,0,0,0,0,0,0,0x4a58, /* 0,0,0,0,0,'侵','侶',0, 0,0,0,0,0,0,0,'便', */
	/* 4fc0 */ 0,0,0x3738,0x4225,0x3264,0,0,0, 0,0,0x3d53,0,0,0,0x5059,0, /* 0,0,'係','促','俄',0,0,0, 0,0,'俊',0,0,0,'俎',0, */
	/* 4fd0 */ 0x505e,0x505c,0,0,0x5057,0,0,0x422f, 0x505a,0,0x505d,0x505b,0,0x4a5d,0,0x5058, /* '俐','俑',0,0,'俔',0,0,'俗', '俘',0,'俚','俛',0,'保',0,'俟', */
	/* 4fe0 */ 0,0x3f2e,0,0x4b73,0x505f,0x5060,0,0, 0,0,0,0,0,0,0x3d24,0x506d, /* 0,'信',0,'俣','俤','俥',0,0, 0,0,0,0,0,0,'修','俯', */
	/* 4ff0 */ 0,0,0,0x4750,0,0x4936,0x5068,0, 0x4a70,0,0x3236,0,0,0,0x506c,0, /* 0,0,0,'俳',0,'俵','俶',0, '俸',0,'俺',0,0,0,'俾',0, */
	/* 5000 */ 0,0,0,0,0,0x5066,0x506f,0, 0,0x4152,0,0x3844,0,0x475c,0,0x6047, /* 0,0,0,0,0,'倅','倆',0, 0,'倉',0,'個',0,'倍',0,'倏', */
	/* 5010 */ 0,0x506e,0x455d,0,0x5063,0,0x3876,0, 0,0x3875,0x5061,0,0,0,0,0x3c5a, /* 0,'們','倒',0,'倔',0,'倖',0, 0,'候','倚',0,0,0,0,'借', */
	/* 5020 */ 0,0x5069,0,0x4a6f,0x434d,0x5065,0x3771,0, 0x5062,0x506a,0x5064,0x4e51,0x506b,0x4f41,0,0, /* 0,'倡',0,'倣','値','倥','倦',0, '倨','倩','倪','倫','倬','倭',0,0, */
	/* 5030 */ 0,0,0,0,0,0,0x3666,0, 0,0x3770,0,0,0,0,0,0, /* 0,0,0,0,0,0,'倶',0, 0,'倹',0,0,0,0,0,0, */
	/* 5040 */ 0,0,0,0x5070,0,0,0,0x5071, 0x5075,0x304e,0,0,0,0,0,0x4a50, /* 0,0,0,'偃',0,0,0,'假', '偈','偉',0,0,0,0,0,'偏', */
	/* 5050 */ 0x5074,0,0,0,0,0x5073,0x5077,0, 0,0,0x5076,0,0x4464,0,0,0, /* '偐',0,0,0,0,'偕','偖',0, 0,0,'做',0,'停',0,0,0, */
	/* 5060 */ 0,0,0,0,0,0x3772,0,0, 0,0,0,0,0x5078,0,0,0, /* 0,0,0,0,0,'健',0,0, 0,0,0,0,'偬',0,0,0, */
	/* 5070 */ 0,0,0x3c45,0,0x4226,0x4465,0x3676,0, 0x5079,0,0,0,0,0x3536,0,0, /* 0,0,'偲',0,'側','偵','偶',0, '偸',0,0,0,0,'偽',0,0, */
	/* 5080 */ 0x507a,0,0,0,0,0x507c,0,0, 0,0,0,0,0,0x4b35,0,0, /* '傀',0,0,0,0,'傅',0,0, 0,0,0,0,0,'傍',0,0, */
	/* 5090 */ 0,0x3766,0,0,0,0,0,0, 0x3b31,0x4877,0x507b,0,0,0,0,0, /* 0,'傑',0,0,0,0,0,0, '傘','備','傚',0,0,0,0,0, */
	/* 50a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x3a45,0x4d43,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'催','傭',0,0, */
	/* 50b0 */ 0,0,0x507e,0x5123,0x507d,0x3a44,0,0x3d7d, 0,0,0,0,0,0,0x3739,0, /* 0,0,'傲','傳','傴','債',0,'傷', 0,0,0,0,0,0,'傾',0, */
	/* 50c0 */ 0,0,0x5124,0,0,0x364f,0,0, 0,0x5121,0x5122,0,0,0x462f,0,0x417c, /* 0,0,'僂',0,0,'僅',0,0, 0,'僉','僊',0,0,'働',0,'像', */
	/* 50d0 */ 0,0x3623,0,0,0,0x4b4d,0x5125,0, 0,0,0x4e3d,0,0,0,0x5126,0, /* 0,'僑',0,0,0,'僕','僖',0, 0,0,'僚',0,0,0,'僞',0, */
	/* 50e0 */ 0,0,0,0x5129,0,0x5127,0,0x414e, 0,0,0,0,0,0x5128,0x512a,0, /* 0,0,0,'僣',0,'僥',0,'僧', 0,0,0,0,0,'僭','僮',0, */
	/* 50f0 */ 0,0,0,0,0,0x512c,0,0, 0,0x512b,0,0x4a48,0,0,0,0, /* 0,0,0,0,0,'僵',0,0, 0,'價',0,'僻',0,0,0,0, */
	/* 5100 */ 0x3537,0x512e,0x512f,0,0x322f,0,0,0, 0,0x512d,0,0,0,0,0,0, /* '儀','儁','儂',0,'億',0,0,0, 0,'儉',0,0,0,0,0,0, */
	/* 5110 */ 0,0,0x3c74,0,0x5132,0x5131,0x5130,0, 0x5056,0,0x5133,0,0,0,0,0x3d7e, /* 0,0,'儒',0,'儔','儕','儖',0, '儘',0,'儚',0,0,0,0,'償', */
	/* 5120 */ 0,0x5134,0,0,0,0,0,0, 0,0,0x4d25,0,0,0,0,0, /* 0,'儡',0,0,0,0,0,0, 0,0,'優',0,0,0,0,0, */
	/* 5130 */ 0,0,0x4c59,0,0,0,0,0x5136, 0,0,0x5135,0x5138,0x5137,0,0,0x5139, /* 0,0,'儲',0,0,0,0,'儷', 0,0,'儺','儻','儼',0,0,'儿', */
	/* 5140 */ 0x513a,0x3074,0,0x3835,0x373b,0x3d3c,0x437b,0x3624, 0x4068,0x3877,0,0x396e,0x513c,0x4c48,0x4546,0, /* '兀','允',0,'元','兄','充','兆','兇', '先','光',0,'克','兌','免','兎',0, */
	/* 5150 */ 0x3b79,0,0x513b,0,0x513d,0,0,0, 0,0,0x455e,0,0x3375,0,0,0, /* '児',0,'兒',0,'兔',0,0,0, 0,0,'党',0,'兜',0,0,0, */
	/* 5160 */ 0,0,0x513e,0,0,0x467e,0,0, 0x4134,0x5140,0x5141,0x482c,0x3878,0x4f3b,0x5142,0, /* 0,0,'兢',0,0,'入',0,0, '全','兩','兪','八','公','六','兮',0, */
	/* 5170 */ 0,0x3626,0,0,0,0x4a3c,0x4236,0x3671, 0x4535,0,0,0,0x3773,0,0,0, /* 0,'共',0,0,0,'兵','其','具', '典',0,0,0,'兼',0,0,0, */
	/* 5180 */ 0x5143,0,0x5144,0,0,0x4662,0x315f,0, 0,0x5147,0x3a7d,0,0x5146,0x3a46,0,0x5148, /* '冀',0,'冂',0,0,'内','円',0, 0,'冉','冊',0,'册','再',0,'冏', */
	/* 5190 */ 0x666e,0x5149,0x4b41,0x514a,0,0x514b,0x514c,0x3e69, 0,0x3c4c,0,0,0,0,0,0, /* '冐','冑','冒','冓',0,'冕','冖','冗', 0,'写',0,0,0,0,0,0, */
	/* 51a0 */ 0x3427,0,0x514f,0,0x514d,0x4c3d,0x514e,0, 0x495a,0x5150,0x5151,0x5152,0x455f,0,0,0, /* '冠',0,'冢',0,'冤','冥','冦',0, '冨','冩','冪','冫','冬',0,0,0, */
	/* 51b0 */ 0x5156,0x5154,0x5155,0x5153,0x3a63,0x5157,0x4c6a,0x4e64, 0,0,0,0,0,0x5158,0,0, /* '冰','冱','冲','决','冴','况','冶','冷', 0,0,0,0,0,'冽',0,0, */
	/* 51c0 */ 0,0,0,0,0x4028,0x5159,0x3d5a,0, 0,0x515a,0,0x437c,0x4e3f,0x4560,0,0, /* 0,0,0,0,'凄','凅','准',0, 0,'凉',0,'凋','凌','凍',0,0, */
	/* 51d0 */ 0,0,0,0,0,0,0x5245,0, 0,0,0,0x515b,0x7425,0x3645,0,0, /* 0,0,0,0,0,0,'凖',0, 0,0,0,'凛','凜','凝',0,0, */
	/* 51e0 */ 0x515c,0x4b5e,0,0,0,0,0x3d68,0x427c, 0,0x515e,0x4664,0,0,0x515f,0,0, /* '几','凡',0,0,0,0,'処','凧', 0,'凩','凪',0,0,'凭',0,0, */
	/* 51f0 */ 0x5160,0x332e,0,0,0,0x5161,0x3627,0, 0x464c,0x317a,0x3d50,0,0,0x4821,0x5162,0, /* '凰','凱',0,0,0,'凵','凶',0, '凸','凹','出',0,0,'函','凾',0, */
	/* 5200 */ 0x4561,0,0,0x3f4f,0x5163,0,0x4a2c,0x405a, 0x3422,0,0x3429,0x5164,0,0,0x5166,0, /* '刀',0,0,'刃','刄',0,'分','切', '刈',0,'刊','刋',0,0,'刎',0, */
	/* 5210 */ 0,0x373a,0,0,0x5165,0,0,0x4e73, 0,0,0,0,0,0x3d69,0,0, /* 0,'刑',0,0,'刔',0,0,'列', 0,0,0,0,0,'初',0,0, */
	/* 5220 */ 0,0,0,0,0x483d,0x4a4c,0,0x5167, 0,0x4d78,0x5168,0,0,0,0x5169,0, /* 0,0,0,0,'判','別',0,'刧', 0,'利','刪',0,0,0,'刮',0, */
	/* 5230 */ 0x457e,0,0,0x516a,0,0,0x4029,0x3a7e, 0x3774,0x516b,0x3b49,0x396f,0,0,0,0, /* '到',0,0,'刳',0,0,'制','刷', '券','刹','刺','刻',0,0,0,0, */
	/* 5240 */ 0,0,0,0x4466,0x516d,0,0,0x4227, 0,0,0x3a6f,0x516e,0x516f,0x4130,0,0x516c, /* 0,0,0,'剃','剄',0,0,'則', 0,0,'削','剋','剌','前',0,'剏', */
	/* 5250 */ 0,0,0,0,0x5171,0,0x4b36,0, 0,0,0,0x3964,0,0,0x5170,0, /* 0,0,0,0,'剔',0,'剖',0, 0,0,0,'剛',0,0,'剞',0, */
	/* 5260 */ 0,0,0,0x3775,0x3a5e,0x476d,0,0, 0,0x5174,0x5172,0,0,0,0,0x497b, /* 0,0,0,'剣','剤','剥',0,0, 0,'剩','剪',0,0,0,0,'副', */
	/* 5270 */ 0x3e6a,0x517b,0x3364,0x5175,0x5173,0x414f,0,0, 0,0,0,0,0,0x5177,0,0x5176, /* '剰','剱','割','剳','剴','創',0,0, 0,0,0,0,0,'剽',0,'剿', */
	/* 5280 */ 0,0,0,0x3344,0,0,0,0x3760, 0x517c,0x4e2d,0,0,0,0x5178,0,0, /* 0,0,0,'劃',0,0,0,'劇', '劈','劉',0,0,0,'劍',0,0, */
	/* 5290 */ 0,0x517d,0x517a,0,0x5179,0,0,0, 0,0,0,0x4e4f,0,0,0,0x3879, /* 0,'劑','劒',0,'劔',0,0,0, 0,0,0,'力',0,0,0,'功', */
	/* 52a0 */ 0x3243,0,0,0x4e74,0,0,0,0, 0,0x3d75,0x4558,0x3965,0x5222,0x5223,0,0, /* '加',0,0,'劣',0,0,0,0, 0,'助','努','劫','劬','劭',0,0, */
	/* 52b0 */ 0,0x4e65,0,0,0x4f2b,0x5225,0,0, 0,0x387a,0,0,0x5224,0,0x332f,0, /* 0,'励',0,0,'労','劵',0,0, 0,'効',0,0,'劼',0,'劾',0, */
	/* 52c0 */ 0,0x5226,0,0x4b56,0,0x443c,0,0x4d26, 0,0x4a59,0,0,0,0x5227,0,0, /* 0,'勁',0,'勃',0,'勅',0,'勇', 0,'勉',0,0,0,'勍',0,0, */
	/* 52d0 */ 0,0,0x7055,0,0,0x4630,0,0x5228, 0x342a,0x4c33,0,0,0,0x3e21,0x5229,0x4a67, /* 0,0,'勒',0,0,'動',0,'勗', '勘','務',0,0,0,'勝','勞','募', */
	/* 52e0 */ 0x522d,0,0x402a,0x522a,0x3650,0,0x522b,0x342b, 0,0,0,0,0,0,0,0, /* '勠',0,'勢','勣','勤',0,'勦','勧', 0,0,0,0,0,0,0,0, */
	/* 52f0 */ 0,0,0x372e,0x522e,0,0x522f,0,0, 0x5230,0x5231,0x3c5b,0,0,0,0x387b,0x4c5e, /* 0,0,'勲','勳',0,'勵',0,0, '勸','勹','勺',0,0,0,'勾','勿', */
	/* 5300 */ 0,0x4c68,0x4677,0,0,0x4a71,0x5232,0, 0x5233,0,0,0,0,0x5235,0,0x5237, /* 0,'匁','匂',0,0,'包','匆',0, '匈',0,0,0,0,'匍',0,'匏', */
	/* 5310 */ 0x5236,0,0,0,0,0x5238,0x323d,0x4b4c, 0,0x3a7c,0x5239,0,0,0x4159,0,0, /* '匐',0,0,0,0,'匕','化','北', 0,'匙','匚',0,0,'匝',0,0, */
	/* 5320 */ 0x3e22,0x3629,0,0x523a,0,0,0,0, 0,0,0x485b,0,0,0,0,0x523b, /* '匠','匡',0,'匣',0,0,0,0, 0,0,'匪',0,0,0,0,'匯', */
	/* 5330 */ 0,0x523c,0,0x523d,0,0,0,0, 0x523e,0x4924,0x3668,0x3065,0,0,0,0x463f, /* 0,'匱',0,'匳',0,0,0,0, '匸','匹','区','医',0,0,0,'匿', */
	/* 5340 */ 0x523f,0x3d3d,0,0x4069,0,0x5241,0x5240,0x3e23, 0x3861,0x5243,0x483e,0,0,0x5244,0,0, /* '區','十',0,'千',0,'卅','卆','升', '午','卉','半',0,0,'卍',0,0, */
	/* 5350 */ 0,0x485c,0x4234,0x426e,0x3628,0,0,0x466e, 0x4331,0,0x476e,0,0x4b4e,0,0x5246,0, /* 0,'卑','卒','卓','協',0,0,'南', '単',0,'博',0,'卜',0,'卞',0, */
	/* 5360 */ 0x406a,0,0,0,0,0,0x3735,0, 0,0x5247,0,0,0,0,0x5248,0x312c, /* '占',0,0,0,0,0,'卦',0, 0,'卩',0,0,0,0,'卮','卯', */
	/* 5370 */ 0x3075,0x346d,0,0x4228,0x3551,0x4d71,0,0x524b, 0x3237,0,0,0x524a,0,0,0,0x362a, /* '印','危',0,'即','却','卵',0,'卷', '卸',0,0,'卻',0,0,0,'卿', */
	/* 5380 */ 0,0,0x524c,0,0x4c71,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'厂',0,'厄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5390 */ 0,0,0,0,0,0,0x524d,0, 0x4e52,0,0x387c,0,0,0,0,0x3836, /* 0,0,0,0,0,0,'厖',0, '厘',0,'厚',0,0,0,0,'原', */
	/* 53a0 */ 0x524e,0,0,0,0,0x5250,0x524f,0, 0x3f5f,0x3139,0,0,0,0x315e,0x5251,0, /* '厠',0,0,0,0,'厥','厦',0, '厨','厩',0,0,0,'厭','厮',0, */
	/* 53b0 */ 0x5252,0,0,0x3837,0,0,0x5253,0, 0,0,0,0x356e,0,0,0,0, /* '厰',0,0,'厳',0,0,'厶',0, 0,0,0,'去',0,0,0,0, */
	/* 53c0 */ 0,0,0x3b32,0x5254,0,0,0,0, 0x4b74,0x3a35,0x355a,0x4d27,0x4150,0x483f,0x3c7d,0, /* 0,0,'参','參',0,0,0,0, '又','叉','及','友','双','反','収',0, */
	/* 53d0 */ 0,0,0,0,0x3d47,0,0x3c68,0x3c75, 0,0x3d76,0,0x4840,0,0,0,0x5257, /* 0,0,0,0,'叔',0,'取','受', 0,'叙',0,'叛',0,0,0,'叟', */
	/* 53e0 */ 0,0x3143,0x4151,0x387d,0x3845,0x3667,0,0, 0x525b,0x4321,0x427e,0x362b,0x3e24,0x525c,0x525a,0x3244, /* 0,'叡','叢','口','古','句',0,0, '叨','叩','只','叫','召','叭','叮','可', */
	/* 53f0 */ 0x4266,0x3c38,0x3b4b,0x3126,0,0,0x3370,0x3966, 0x3b4a,0,0x525d,0,0,0,0,0, /* '台','叱','史','右',0,0,'叶','号', '司',0,'叺',0,0,0,0,0, */
	/* 5400 */ 0,0x525e,0,0x3549,0x3346,0,0,0, 0x3967,0x3548,0x445f,0x3125,0x4631,0x4c3e,0x3921,0x4d79, /* 0,'吁',0,'吃','各',0,0,0, '合','吉','吊','吋','同','名','后','吏', */
	/* 5410 */ 0x4547,0x387e,0,0,0,0,0,0, 0,0,0,0x372f,0,0x5267,0,0x3663, /* '吐','向',0,0,0,0,0,0, 0,0,0,'君',0,'吝',0,'吟', */
	/* 5420 */ 0x4b4a,0,0,0,0,0,0x485d,0, 0,0x5266,0,0x345e,0x5261,0x5262,0x5264,0, /* '吠',0,0,0,0,0,'否',0, 0,'吩',0,'含','听','吭','吮',0, */
	/* 5430 */ 0,0,0,0,0,0,0x5265,0, 0x355b,0x3f61,0,0x4a2d,0x5263,0x525f,0x3863,0, /* 0,0,0,0,0,0,'吶',0, '吸','吹',0,'吻','吼','吽','吾',0, */
	/* 5440 */ 0x5260,0,0x4f24,0,0,0,0x4a72,0, 0x4468,0x3862,0x3970,0,0,0,0x5268,0, /* '呀',0,'呂',0,0,0,'呆',0, '呈','呉','告',0,0,0,'呎',0, */
	/* 5450 */ 0,0x465d,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x526c, /* 0,'呑',0,0,0,0,0,0, 0,0,0,0,0,0,0,'呟', */
	/* 5460 */ 0,0,0,0,0,0,0,0, 0x3c7e,0,0x3c76,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '周',0,'呪',0,0,0,0,0, */
	/* 5470 */ 0x526f,0x526d,0,0x4c23,0,0x526a,0x5273,0x526e, 0,0,0,0x5271,0x3846,0x4c3f,0,0, /* '呰','呱',0,'味',0,'呵','呶','呷', 0,0,0,'呻','呼','命',0,0, */
	/* 5480 */ 0x5272,0,0,0,0x5274,0,0x5276,0, 0,0,0,0x3a70,0x4f42,0,0x526b,0x5269, /* '咀',0,0,0,'咄',0,'咆',0, 0,0,0,'咋','和',0,'咎','咏', */
	/* 5490 */ 0x5275,0,0x5270,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '咐',0,'咒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 54a0 */ 0,0,0x5278,0,0x5323,0x527a,0,0, 0x527e,0,0,0x5321,0x527b,0,0,0x533e, /* 0,0,'咢',0,'咤','咥',0,0, '咨',0,0,'咫','咬',0,0,'咯', */
	/* 54b0 */ 0,0,0x3a69,0x3331,0,0,0,0, 0x5279,0,0,0,0x5325,0x3076,0x5324,0, /* 0,0,'咲','咳',0,0,0,0, '咸',0,0,0,'咼','咽','咾',0, */
	/* 54c0 */ 0x3025,0x494a,0x5322,0,0x527c,0,0,0x5277, 0x527d,0x3a48,0,0,0,0,0,0, /* '哀','品','哂',0,'哄',0,0,'哇', '哈','哉',0,0,0,0,0,0, */
	/* 54d0 */ 0,0,0,0,0,0,0,0, 0x5326,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '哘',0,0,0,0,0,0,0, */
	/* 54e0 */ 0,0x3077,0x532f,0,0,0x5327,0x5328,0, 0x3e25,0x4b69,0,0,0,0x532d,0x532c,0, /* 0,'員','哢',0,0,'哥','哦',0, '哨','哩',0,0,0,'哭','哮',0, */
	/* 54f0 */ 0,0,0x452f,0,0,0,0,0, 0,0,0x532e,0,0,0x532b,0,0, /* 0,0,'哲',0,0,0,0,0, 0,0,'哺',0,0,'哽',0,0, */
	/* 5500 */ 0,0,0,0,0x3134,0,0x3a36,0x3f30, 0,0,0,0,0,0,0,0x5329, /* 0,0,0,0,'唄',0,'唆','唇', 0,0,0,0,0,0,0,'唏', */
	/* 5510 */ 0x4562,0,0,0,0x532a,0,0x3022,0, 0,0,0,0,0,0,0,0, /* '唐',0,0,0,'唔',0,'唖',0, 0,0,0,0,0,0,0,0, */
	/* 5520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x5334,0x4d23, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'售','唯', */
	/* 5530 */ 0,0x3e27,0,0x533a,0,0,0,0, 0x5339,0x5330,0,0,0,0,0x4243,0, /* 0,'唱',0,'唳',0,0,0,0, '唸','唹',0,0,0,0,'唾',0, */
	/* 5540 */ 0x5331,0,0,0,0x426f,0x5336,0x3e26,0, 0,0,0,0,0x5333,0,0,0x4c64, /* '啀',0,0,0,'啄','啅','商',0, 0,0,0,0,'啌',0,0,'問', */
	/* 5550 */ 0,0,0,0x373c,0,0,0x5337,0x5338, 0,0,0,0,0x5335,0x533b,0,0, /* 0,0,0,'啓',0,0,'啖','啗', 0,0,0,0,'啜','啝',0,0, */
	/* 5560 */ 0,0,0,0x5332,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'啣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5570 */ 0,0,0,0,0,0,0,0, 0,0,0,0x5341,0x5346,0,0x5342,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'啻','啼',0,'啾',0, */
	/* 5580 */ 0x533d,0,0,0x5347,0x4131,0,0,0x5349, 0,0x3922,0x533f,0x437d,0,0,0,0, /* '喀',0,0,'喃','善',0,0,'喇', 0,'喉','喊','喋',0,0,0,0, */
	/* 5590 */ 0,0,0,0,0,0,0,0, 0x5343,0x533c,0x342d,0,0x346e,0x3365,0x5344,0x5340, /* 0,0,0,0,0,0,0,0, '喘','喙','喚',0,'喜','喝','喞','喟', */
	/* 55a0 */ 0,0,0,0,0,0,0,0x3776, 0x534a,0x5348,0x4153,0x354a,0x362c,0,0x5345,0, /* 0,0,0,0,0,0,0,'喧', '喨','喩','喪','喫','喬',0,'單',0, */
	/* 55b0 */ 0x3674,0,0,0,0,0,0x3144,0, 0,0,0,0,0,0,0,0, /* '喰',0,0,0,0,0,'営',0, 0,0,0,0,0,0,0,0, */
	/* 55c0 */ 0,0,0,0,0x534e,0x534c,0,0x5427, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'嗄','嗅',0,'嗇', 0,0,0,0,0,0,0,0, */
	/* 55d0 */ 0,0,0,0,0x5351,0,0,0, 0,0,0x534b,0,0x534f,0,0,0x534d, /* 0,0,0,0,'嗔',0,0,0, 0,0,'嗚',0,'嗜',0,0,'嗟', */
	/* 55e0 */ 0,0,0,0x3b4c,0x5350,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'嗣','嗤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 55f0 */ 0,0,0,0,0,0,0,0x5353, 0,0x5358,0,0,0,0x5356,0x5355,0, /* 0,0,0,0,0,0,0,'嗷', 0,'嗹',0,0,0,'嗽','嗾',0, */
	/* 5600 */ 0,0,0,0,0,0,0x4332,0, 0,0x3245,0,0,0,0,0,0, /* 0,0,0,0,0,0,'嘆',0, 0,'嘉',0,0,0,0,0,0, */
	/* 5610 */ 0,0,0,0,0x5352,0,0x5354,0x3e28, 0x3133,0,0,0x5357,0,0,0,0, /* 0,0,0,0,'嘔',0,'嘖','嘗', '嘘',0,0,'嘛',0,0,0,0, */
	/* 5620 */ 0,0,0,0,0,0,0,0, 0,0x325e,0,0,0,0,0,0x5362, /* 0,0,0,0,0,0,0,0, 0,'嘩',0,0,0,0,0,'嘯', */
	/* 5630 */ 0,0x3e7c,0x535e,0,0x535c,0,0x535d,0, 0x535f,0,0,0,0,0,0,0, /* 0,'嘱','嘲',0,'嘴',0,'嘶',0, '嘸',0,0,0,0,0,0,0, */
	/* 5640 */ 0,0,0x313d,0,0,0,0,0, 0,0,0,0,0x4139,0,0x5359,0, /* 0,0,'噂',0,0,0,0,0, 0,0,0,0,'噌',0,'噎',0, */
	/* 5650 */ 0x535a,0,0,0,0,0,0,0, 0,0,0,0x337a,0,0,0,0, /* '噐',0,0,0,0,0,0,0, 0,0,0,'噛',0,0,0,0, */
	/* 5660 */ 0,0,0,0,0x5361,0,0,0, 0x346f,0,0x5364,0x5360,0x5363,0,0,0, /* 0,0,0,0,'噤',0,0,0, '器',0,'噪','噫','噬',0,0,0, */
	/* 5670 */ 0,0,0,0,0x4a2e,0,0,0, 0x4655,0,0x4838,0,0,0,0,0, /* 0,0,0,0,'噴',0,0,0, '噸',0,'噺',0,0,0,0,0, */
	/* 5680 */ 0x5366,0,0,0,0,0,0x5365,0x3345, 0,0,0x5367,0,0,0,0,0x536a, /* '嚀',0,0,0,0,0,'嚆','嚇', 0,0,'嚊',0,0,0,0,'嚏', */
	/* 5690 */ 0,0,0,0,0x5369,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'嚔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 56a0 */ 0x5368,0,0x4739,0,0,0x536b,0,0, 0,0,0,0,0,0,0x536c,0, /* '嚠',0,'嚢',0,0,'嚥',0,0, 0,0,0,0,0,0,'嚮',0, */
	/* 56b0 */ 0,0,0,0,0x536e,0,0x536d,0, 0,0,0,0,0x5370,0,0,0, /* 0,0,0,0,'嚴',0,'嚶',0, 0,0,0,0,'嚼',0,0,0, */
	/* 56c0 */ 0x5373,0x5371,0x536f,0x5372,0,0,0,0, 0x5374,0,0,0,0,0,0x5375,0, /* '囀','囁','囂','囃',0,0,0,0, '囈',0,0,0,0,0,'囎',0, */
	/* 56d0 */ 0,0x5376,0,0x5377,0,0,0,0x5378, 0x5145,0,0x3c7c,0x3b4d,0,0,0x3273,0, /* 0,'囑',0,'囓',0,0,0,'囗', '囘',0,'囚','四',0,0,'回',0, */
	/* 56e0 */ 0x3078,0,0,0x4344,0,0,0,0, 0,0,0,0,0,0,0x5379,0, /* '因',0,0,'団',0,0,0,0, 0,0,0,0,0,0,'囮',0, */
	/* 56f0 */ 0x3a24,0,0x304f,0x3f5e,0,0,0,0, 0,0x537a,0x3847,0,0,0x3971,0,0x537c, /* '困',0,'囲','図',0,0,0,0, 0,'囹','固',0,0,'国',0,'囿', */
	/* 5700 */ 0x537b,0,0,0x4a60,0x537d,0,0,0, 0x5421,0x537e,0,0x5422,0,0x5423,0,0x3777, /* '圀',0,0,'圃','圄',0,0,0, '圈','圉',0,'國',0,'圍',0,'圏', */
	/* 5710 */ 0,0,0x3160,0x5424,0,0,0x5426,0, 0x5425,0,0,0,0x5428,0,0,0x455a, /* 0,0,'園','圓',0,0,'圖',0, '團',0,0,0,'圜',0,0,'土', */
	/* 5720 */ 0,0,0,0,0,0,0x5429,0x3035, 0x3a5f,0,0,0,0,0x373d,0,0, /* 0,0,0,0,0,0,'圦','圧', '在',0,0,0,0,'圭',0,0, */
	/* 5730 */ 0x434f,0,0,0,0,0,0,0x542a, 0x542b,0,0,0x542d,0,0,0,0, /* '地',0,0,0,0,0,0,'圷', '圸',0,0,'圻',0,0,0,0, */
	/* 5740 */ 0x542e,0,0x3a64,0,0,0,0,0x3651, 0,0,0x4b37,0,0,0,0x542c,0x542f, /* '址',0,'坂',0,0,0,0,'均', 0,0,'坊',0,0,0,'坎','坏', */
	/* 5750 */ 0x3a41,0x3923,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '坐','坑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5760 */ 0,0x5433,0,0,0x3a25,0,0x4333,0, 0,0x5430,0x445a,0,0,0,0,0, /* 0,'坡',0,0,'坤',0,'坦',0, 0,'坩','坪',0,0,0,0,0, */
	/* 5770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x5434, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'坿', */
	/* 5780 */ 0,0,0x3f62,0,0,0,0,0, 0x5432,0x5435,0,0x373f,0,0,0,0, /* 0,0,'垂',0,0,0,0,0, '垈','垉',0,'型',0,0,0,0, */
	/* 5790 */ 0,0,0,0x5436,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'垓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57a0 */ 0x5437,0,0x3924,0x3340,0x5439,0,0,0, 0,0,0x543a,0,0,0,0,0, /* '垠',0,'垢','垣','垤',0,0,0, 0,0,'垪',0,0,0,0,0, */
	/* 57b0 */ 0x543b,0,0,0x5438,0,0,0,0, 0,0,0,0,0,0,0,0, /* '垰',0,0,'垳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57c0 */ 0x5431,0,0,0x543c,0,0,0x543d,0, 0,0,0,0x4b64,0,0,0x3e6b,0, /* '埀',0,0,'埃',0,0,'埆',0, 0,0,0,'埋',0,0,'城',0, */
	/* 57d0 */ 0,0,0x543f,0x5440,0x543e,0,0x5442,0, 0,0,0,0,0x4738,0,0,0x3068, /* 0,0,'埒','埓','埔',0,'埖',0, 0,0,0,0,'埜',0,0,'域', */
	/* 57e0 */ 0x4956,0,0,0x5443,0,0,0,0, 0,0,0,0,0,0,0,0, /* '埠',0,0,'埣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57f0 */ 0,0,0,0,0x3e7d,0,0,0x3c39, 0,0x475d,0x3470,0,0x3a6b,0,0,0, /* 0,0,0,0,'埴',0,0,'執', 0,'培','基',0,'埼',0,0,0, */
	/* 5800 */ 0x4b59,0,0x4632,0,0,0x3778,0x424f,0, 0,0,0x5441,0x5444,0,0,0,0, /* '堀',0,'堂',0,0,'堅','堆',0, 0,0,'堊','堋',0,0,0,0, */
	/* 5810 */ 0,0,0,0,0,0x4244,0,0, 0,0x5445,0,0,0,0x5446,0,0, /* 0,0,0,0,0,'堕',0,0, 0,'堙',0,0,0,'堝',0,0, */
	/* 5820 */ 0,0x5448,0,0,0x4469,0,0,0, 0,0,0x342e,0,0,0,0,0x7421, /* 0,'堡',0,0,'堤',0,0,0, 0,0,'堪',0,0,0,0,'堯', */
	/* 5830 */ 0x3161,0x4a73,0,0,0x3e6c,0x4548,0,0, 0,0,0x3a66,0,0,0x544e,0,0, /* '堰','報',0,0,'場','堵',0,0, 0,0,'堺',0,0,'堽',0,0, */
	/* 5840 */ 0x4a3d,0x4e5d,0,0,0,0,0,0, 0,0,0x3274,0x544a,0,0,0,0, /* '塀','塁',0,0,0,0,0,0, 0,0,'塊','塋',0,0,0,0, */
	/* 5850 */ 0,0x413a,0x544d,0,0x4563,0,0,0x4549, 0x4564,0x4839,0x444d,0,0,0,0x3a49,0, /* 0,'塑','塒',0,'塔',0,0,'塗', '塘','塙','塚',0,0,0,'塞',0, */
	/* 5860 */ 0,0,0x5449,0,0,0,0,0, 0,0x3176,0,0x4536,0,0,0,0, /* 0,0,'塢',0,0,0,0,0, 0,'塩',0,'填',0,0,0,0, */
	/* 5870 */ 0x544b,0,0x5447,0,0,0x3f50,0,0, 0,0x544f,0,0,0,0,0x3d4e,0, /* '塰',0,'塲',0,0,'塵',0,0, 0,'塹',0,0,0,0,'塾',0, */
	/* 5880 */ 0,0,0,0x362d,0,0x5450,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'境',0,'墅',0,0, 0,0,0,0,0,0,0,0, */
	/* 5890 */ 0,0,0,0x4a68,0,0,0,0x417d, 0,0,0,0,0x4446,0,0,0x5452, /* 0,0,0,'墓',0,0,0,'増', 0,0,0,0,'墜',0,0,'墟', */
	/* 58a0 */ 0,0,0,0,0,0,0,0, 0x4b4f,0,0,0x5453,0,0,0x5458,0, /* 0,0,0,0,0,0,0,0, '墨',0,0,'墫',0,0,'墮',0, */
	/* 58b0 */ 0,0,0,0x4a2f,0,0,0,0, 0x5457,0x5451,0x5454,0x5456,0,0,0x3a26,0, /* 0,0,0,'墳',0,0,0,0, '墸','墹','墺','墻',0,0,'墾',0, */
	/* 58c0 */ 0,0x4a49,0,0,0,0x5459,0,0x4345, 0,0,0x3275,0,0x3e6d,0,0,0, /* 0,'壁',0,0,0,'壅',0,'壇', 0,0,'壊',0,'壌',0,0,0, */
	/* 58d0 */ 0,0x545b,0,0x545a,0,0x3968,0,0x545c, 0x545e,0x545d,0,0,0x5460,0,0x5455,0x5462, /* 0,'壑',0,'壓',0,'壕',0,'壗', '壘','壙',0,0,'壜',0,'壞','壟', */
	/* 58e0 */ 0,0,0,0,0x5461,0x545f,0,0, 0,0,0,0x3b4e,0x3f51,0,0x4154,0x5463, /* 0,0,0,0,'壤','壥',0,0, 0,0,0,'士','壬',0,'壮','壯', */
	/* 58f0 */ 0x403c,0x306d,0x4764,0,0,0,0,0x445b, 0,0x5465,0x5464,0x5466,0x5467,0x5468,0,0, /* '声','壱','売',0,0,0,0,'壷', 0,'壹','壺','壻','壼','壽',0,0, */
	/* 5900 */ 0,0,0x5469,0,0,0,0,0, 0,0x4a51,0x546a,0,0,0,0,0x3246, /* 0,0,'夂',0,0,0,0,0, 0,'変','夊',0,0,0,0,'夏', */
	/* 5910 */ 0x546b,0,0,0,0,0x4d3c,0x3330,0, 0x5249,0x3d48,0x423f,0x546c,0x4c6b,0,0,0, /* '夐',0,0,0,0,'夕','外',0, '夘','夙','多','夛','夜',0,0,0, */
	/* 5920 */ 0,0,0x4c34,0,0,0x546e,0,0x4267, 0,0x4537,0x4240,0x4957,0x546f,0x5470,0x317b,0, /* 0,0,'夢',0,0,'夥',0,'大', 0,'天','太','夫','夬','夭','央',0, */
	/* 5930 */ 0,0x3c3a,0x5471,0,0,0,0,0x3050, 0x5472,0,0,0,0,0,0x5473,0, /* 0,'失','夲',0,0,0,0,'夷', '夸',0,0,0,0,0,'夾',0, */
	/* 5940 */ 0,0,0,0,0x3162,0,0,0x3471, 0x4660,0x4a74,0,0,0,0,0x5477,0x4155, /* 0,0,0,0,'奄',0,0,'奇', '奈','奉',0,0,0,0,'奎','奏', */
	/* 5950 */ 0x5476,0x3740,0,0,0x4b5b,0x5475,0,0x4565, 0x5479,0,0x5478,0,0,0,0,0, /* '奐','契',0,0,'奔','奕',0,'套', '奘',0,'奚',0,0,0,0,0, */
	/* 5960 */ 0x547b,0,0x547a,0,0,0x317c,0,0x547c, 0x3e29,0x547e,0x4325,0,0x547d,0,0x4a33,0, /* '奠',0,'奢',0,0,'奥',0,'奧', '奨','奩','奪',0,'奬',0,'奮',0, */
	/* 5970 */ 0,0,0,0x3d77,0x455b,0,0,0, 0x5521,0,0,0,0,0x3925,0,0, /* 0,0,0,'女','奴',0,0,0, '奸',0,0,0,0,'好',0,0, */
	/* 5980 */ 0,0x5522,0x4721,0x485e,0x4c51,0,0,0, 0,0,0x4725,0,0,0x552b,0,0, /* 0,'妁','如','妃','妄',0,0,0, 0,0,'妊',0,0,'妍',0,0, */
	/* 5990 */ 0,0,0,0x3538,0,0,0x4d45,0, 0,0x4c2f,0,0x562c,0,0x5523,0,0, /* 0,0,0,'妓',0,0,'妖',0, 0,'妙',0,'妛',0,'妝',0,0, */
	/* 59a0 */ 0,0,0,0x5526,0,0x4245,0,0, 0x4b38,0,0,0,0x454a,0,0,0, /* 0,0,0,'妣',0,'妥',0,0, '妨',0,0,0,'妬',0,0,0, */
	/* 59b0 */ 0,0,0x5527,0,0,0,0,0, 0,0x4b65,0,0x3a4a,0,0,0x3e2a,0, /* 0,0,'妲',0,0,0,0,0, 0,'妹',0,'妻',0,0,'妾',0, */
	/* 59c0 */ 0,0,0,0,0,0,0x5528,0, 0,0x3b50,0,0x3b4f,0,0,0,0, /* 0,0,0,0,0,0,'姆',0, 0,'姉',0,'始',0,0,0,0, */
	/* 59d0 */ 0x3039,0x3848,0,0x402b,0x3051,0,0,0, 0,0x552c,0x552d,0,0x552a,0,0,0, /* '姐','姑',0,'姓','委',0,0,0, 0,'姙','姚',0,'姜',0,0,0, */
	/* 59e0 */ 0,0,0,0,0,0x3138,0x342f,0, 0x5529,0,0x4c45,0x4931,0,0,0,0, /* 0,0,0,0,0,'姥','姦',0, '姨',0,'姪','姫',0,0,0,0, */
	/* 59f0 */ 0,0,0,0,0,0,0x3028,0, 0,0,0,0x3079,0,0,0,0x3b51, /* 0,0,0,0,0,0,'姶',0, 0,0,0,'姻',0,0,0,'姿', */
	/* 5a00 */ 0,0x3052,0,0x3023,0,0,0,0, 0,0x5532,0,0,0,0,0,0, /* 0,'威',0,'娃',0,0,0,0, 0,'娉',0,0,0,0,0,0, */
	/* 5a10 */ 0,0x5530,0,0,0,0,0,0, 0x4c3c,0,0x5533,0,0x5531,0,0,0x552f, /* 0,'娑',0,0,0,0,0,0, '娘',0,'娚',0,'娜',0,0,'娟', */
	/* 5a20 */ 0x3f31,0,0,0,0,0x552e,0,0, 0,0x4a5a,0,0,0,0,0,0x3864, /* '娠',0,0,0,0,'娥',0,0, 0,'娩',0,0,0,0,0,'娯', */
	/* 5a30 */ 0,0,0,0,0,0x5537,0x5538,0, 0,0,0,0,0x3e2b,0,0,0, /* 0,0,0,0,0,'娵','娶',0, 0,0,0,0,'娼',0,0,0, */
	/* 5a40 */ 0x5534,0x4f2c,0,0,0,0,0x474c,0, 0,0x5536,0,0,0,0,0,0, /* '婀','婁',0,0,0,0,'婆',0, 0,'婉',0,0,0,0,0,0, */
	/* 5a50 */ 0,0,0,0,0,0,0,0, 0,0,0x3a27,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'婚',0,0,0,0,0, */
	/* 5a60 */ 0,0,0x5539,0,0,0,0x4958,0, 0,0,0x553a,0,0x5535,0,0,0, /* 0,0,'婢',0,0,0,'婦',0, 0,0,'婪',0,'婬',0,0,0, */
	/* 5a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x4c3b, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'婿', */
	/* 5a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5a90 */ 0,0,0x475e,0,0,0,0,0, 0,0,0x553b,0x4932,0,0,0,0, /* 0,0,'媒',0,0,0,0,0, 0,0,'媚','媛',0,0,0,0, */
	/* 5aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x553c,0x5540,0x553d,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'媼','媽','媾',0, */
	/* 5ac0 */ 0,0x3247,0x553f,0,0,0,0,0, 0,0x3c3b,0,0x553e,0x3779,0,0,0, /* 0,'嫁','嫂',0,0,0,0,0, 0,'嫉',0,'嫋','嫌',0,0,0, */
	/* 5ad0 */ 0x554c,0,0,0,0,0,0x5545,0x5542, 0,0,0,0,0,0,0,0, /* '嫐',0,0,0,0,0,'嫖','嫗', 0,0,0,0,0,0,0,0, */
	/* 5ae0 */ 0,0x4364,0,0x5541,0,0,0x5543,0, 0,0x5544,0,0,0,0,0,0, /* 0,'嫡',0,'嫣',0,0,'嫦',0, 0,'嫩',0,0,0,0,0,0, */
	/* 5af0 */ 0,0,0,0,0,0,0,0, 0,0,0x5546,0x5547,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'嫺','嫻',0,0,0,0, */
	/* 5b00 */ 0,0,0,0,0,0,0,0, 0,0x3472,0,0x5549,0x5548,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'嬉',0,'嬋','嬌',0,0,0, */
	/* 5b10 */ 0,0,0,0,0,0,0x554a,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'嬖',0, 0,0,0,0,0,0,0,0, */
	/* 5b20 */ 0,0,0x3e6e,0,0,0,0,0, 0,0,0x554d,0,0x445c,0,0,0, /* 0,0,'嬢',0,0,0,0,0, 0,0,'嬪',0,'嬬',0,0,0, */
	/* 5b30 */ 0x3145,0,0x554b,0,0,0,0x554e,0, 0,0,0,0,0,0,0x554f,0, /* '嬰',0,'嬲',0,0,0,'嬶',0, 0,0,0,0,0,0,'嬾',0, */
	/* 5b40 */ 0x5552,0,0,0x5550,0,0x5551,0,0, 0,0,0,0,0,0,0,0, /* '孀',0,0,'孃',0,'孅',0,0, 0,0,0,0,0,0,0,0, */
	/* 5b50 */ 0x3b52,0x5553,0,0,0x3926,0x5554,0,0x3b7a, 0x4238,0,0x5555,0x5556,0x3b5a,0x3927,0,0x4c52, /* '子','孑',0,0,'孔','孕',0,'字', '存',0,'孚','孛','孜','孝',0,'孟', */
	/* 5b60 */ 0,0,0,0x3528,0x3849,0x5557,0x3358,0, 0,0x5558,0,0x4239,0,0,0,0, /* 0,0,0,'季','孤','孥','学',0, 0,'孩',0,'孫',0,0,0,0, */
	/* 5b70 */ 0x5559,0x5623,0,0x555a,0,0x555b,0,0, 0x555c,0,0x555e,0,0,0,0,0, /* '孰','孱',0,'孳',0,'孵',0,0, '學',0,'孺',0,0,0,0,0, */
	/* 5b80 */ 0x555f,0,0,0x5560,0,0x4270,0,0x3127, 0x3c69,0x3042,0,0x4157,0x3430,0x3c35,0,0x3928, /* '宀',0,0,'它',0,'宅',0,'宇', '守','安',0,'宋','完','宍',0,'宏', */
	/* 5b90 */ 0,0,0,0,0,0x4566,0,0x3d21, 0x3431,0x4368,0x446a,0x3038,0x3539,0x4a75,0,0x3c42, /* 0,0,0,0,0,'宕',0,'宗', '官','宙','定','宛','宜','宝',0,'実', */
	/* 5ba0 */ 0,0,0x3552,0x406b,0x3c3c,0x4d28,0x5561,0, 0,0,0,0,0,0,0x355c,0, /* 0,0,'客','宣','室','宥','宦',0, 0,0,0,0,0,0,'宮',0, */
	/* 5bb0 */ 0x3a4b,0,0,0x3332,0x3163,0x3e2c,0x3248,0, 0x5562,0x4d46,0,0,0,0,0,0x3d49, /* '宰',0,0,'害','宴','宵','家',0, '宸','容',0,0,0,0,0,'宿', */
	/* 5bc0 */ 0,0,0x3c64,0x5563,0x3473,0x4652,0x4c29,0x5564, 0,0x5565,0,0,0x4959,0,0,0, /* 0,0,'寂','寃','寄','寅','密','寇', 0,'寉',0,0,'富',0,0,0, */
	/* 5bd0 */ 0x5567,0,0x3428,0x3677,0x5566,0,0,0, 0,0,0,0x3432,0,0x3f32,0x556b,0x3b21, /* '寐',0,'寒','寓','寔',0,0,0, 0,0,0,'寛',0,'寝','寞','察', */
	/* 5be0 */ 0,0x3249,0x556a,0,0x5568,0x556c,0x5569,0x472b, 0x5c4d,0x3f33,0,0x556d,0,0,0x4e40,0, /* 0,'寡','寢',0,'寤','寥','實','寧', '寨','審',0,'寫',0,0,'寮',0, */
	/* 5bf0 */ 0x556e,0,0,0x5570,0,0x437e,0x556f,0, 0x4023,0,0x3b7b,0,0,0,0x4250,0x3c77, /* '寰',0,0,'寳',0,'寵','寶',0, '寸',0,'寺',0,0,0,'対','寿', */
	/* 5c00 */ 0,0x4975,0x406c,0,0x3c4d,0x5571,0x3e2d,0x5572, 0x5573,0x3053,0x423a,0x3f52,0,0x5574,0x4633,0x3e2e, /* 0,'封','専',0,'射','尅','将','將', '專','尉','尊','尋',0,'對','導','小', */
	/* 5c10 */ 0,0x3e2f,0,0x5575,0,0,0x406d,0, 0,0,0x3e30,0,0,0,0,0, /* 0,'少',0,'尓',0,0,'尖',0, 0,0,'尚',0,0,0,0,0, */
	/* 5c20 */ 0x5576,0,0x5577,0,0x4c60,0,0,0, 0x5578,0,0,0,0,0x3646,0,0, /* '尠',0,'尢',0,'尤',0,0,0, '尨',0,0,0,0,'尭',0,0, */
	/* 5c30 */ 0,0x3d22,0,0,0,0,0,0, 0x5579,0x557a,0x3c5c,0x3f2c,0x4674,0x3f54,0x4878,0x4722, /* 0,'就',0,0,0,0,0,0, '尸','尹','尺','尻','尼','尽','尾','尿', */
	/* 5c40 */ 0x3649,0x557b,0,0,0,0x356f,0x557c,0, 0x367e,0,0x464f,0x3230,0,0x3b53,0x557d,0x5622, /* '局','屁',0,0,0,'居','屆',0, '屈',0,'届','屋',0,'屍','屎','屏', */
	/* 5c50 */ 0x5621,0x367d,0,0x557e,0,0x4538,0,0, 0,0,0,0,0,0,0x4230,0, /* '屐','屑',0,'屓',0,'展',0,0, 0,0,0,0,0,0,'属',0, */
	/* 5c60 */ 0x454b,0x3c48,0,0,0x4158,0x4d7a,0,0, 0,0,0,0,0x5624,0,0x5625,0x4656, /* '屠','屡',0,0,'層','履',0,0, 0,0,0,0,'屬',0,'屮','屯', */
	/* 5c70 */ 0,0x3b33,0,0,0,0,0x5627,0, 0,0x5628,0,0,0,0,0,0, /* 0,'山',0,0,0,0,'屶',0, 0,'屹',0,0,0,0,0,0, */
	/* 5c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x5629,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'岌',0,0,0, */
	/* 5c90 */ 0x3474,0x562a,0,0,0x562b,0,0,0, 0,0,0,0,0,0,0,0, /* '岐','岑',0,0,'岔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5ca0 */ 0,0x322c,0,0,0,0,0,0, 0x413b,0x3464,0,0x562d,0x4c28,0,0,0, /* 0,'岡',0,0,0,0,0,0, '岨','岩',0,'岫','岬',0,0,0, */
	/* 5cb0 */ 0,0x4252,0,0x3359,0,0,0x562f,0x5631, 0x345f,0,0,0x562e,0x5630,0,0x5633,0, /* 0,'岱',0,'岳',0,0,'岶','岷', '岸',0,0,'岻','岼',0,'岾',0, */
	/* 5cc0 */ 0,0,0,0,0,0x5632,0,0x5634, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'峅',0,'峇', 0,0,0,0,0,0,0,0, */
	/* 5cd0 */ 0,0,0,0,0,0,0,0, 0,0x5635,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'峙',0,0,0,0,0,0, */
	/* 5ce0 */ 0x463d,0x362e,0,0,0,0,0,0, 0x3265,0x5636,0x563b,0,0,0x5639,0,0x4a77, /* '峠','峡',0,0,0,0,0,0, '峨','峩','峪',0,0,'峭',0,'峯', */
	/* 5cf0 */ 0x4a76,0,0,0,0,0,0x4567,0, 0,0,0x5638,0x3d54,0,0x5637,0,0, /* '峰',0,0,0,0,0,'島',0, 0,0,'峺','峻',0,'峽',0,0, */
	/* 5d00 */ 0,0,0,0,0,0,0,0x3f72, 0,0,0,0x563c,0,0,0x3a6a,0, /* 0,0,0,0,0,0,0,'崇', 0,0,0,'崋',0,0,'崎',0, */
	/* 5d10 */ 0,0x5642,0,0,0x5643,0x563d,0x3333,0x563e, 0x5647,0x5646,0x5645,0x5641,0,0,0,0x5640, /* 0,'崑',0,0,'崔','崕','崖','崗', '崘','崙','崚','崛',0,0,0,'崟', */
	/* 5d20 */ 0,0,0x5644,0,0,0,0,0, 0,0x4a78,0,0,0,0,0,0, /* 0,0,'崢',0,0,0,0,0, 0,'崩',0,0,0,0,0,0, */
	/* 5d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 5d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0x564b,0x5648,0,0x564a,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'嵋','嵌',0,'嵎',0, */
	/* 5d50 */ 0x4d72,0,0x5649,0,0,0,0,0, 0,0,0,0,0x563f,0,0,0, /* '嵐',0,'嵒',0,0,0,0,0, 0,0,0,0,'嵜',0,0,0, */
	/* 5d60 */ 0,0,0,0,0,0,0,0, 0,0x3f73,0,0,0x564c,0,0,0x3a37, /* 0,0,0,0,0,0,0,0, 0,'嵩',0,0,'嵬',0,0,'嵯', */
	/* 5d70 */ 0,0,0,0x564d,0,0,0x564e,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'嵳',0,0,'嵶',0, 0,0,0,0,0,0,0,0, */
	/* 5d80 */ 0,0,0x5651,0,0x5650,0,0,0x564f, 0,0,0,0x4568,0x563a,0,0,0, /* 0,0,'嶂',0,'嶄',0,0,'嶇', 0,0,0,'嶋','嶌',0,0,0, */
	/* 5d90 */ 0x5657,0,0,0,0,0,0,0, 0,0,0,0,0,0x5653,0,0, /* '嶐',0,0,0,0,0,0,0, 0,0,0,0,0,'嶝',0,0, */
	/* 5da0 */ 0,0,0x5652,0,0,0,0,0, 0,0,0,0,0x5654,0,0x5655,0, /* 0,0,'嶢',0,0,0,0,0, 0,0,0,0,'嶬',0,'嶮',0, */
	/* 5db0 */ 0,0,0,0,0,0,0,0x5658, 0,0,0x4e66,0,0x5659,0x5656,0,0, /* 0,0,0,0,0,0,0,'嶷', 0,0,'嶺',0,'嶼','嶽',0,0, */
	/* 5dc0 */ 0,0,0,0,0,0,0,0, 0,0x565a,0,0,0x3460,0x565b,0,0, /* 0,0,0,0,0,0,0,0, 0,'巉',0,0,'巌','巍',0,0, */
	/* 5dd0 */ 0,0,0x565d,0x565c,0,0,0x565e,0, 0,0,0,0x565f,0,0x406e,0x3d23,0, /* 0,0,'巒','巓',0,0,'巖',0, 0,0,0,'巛',0,'川','州',0, */
	/* 5de0 */ 0,0x3d64,0,0x4163,0,0x3929,0x3a38,0x392a, 0x3570,0,0,0x5660,0,0,0x3a39,0, /* 0,'巡',0,'巣',0,'工','左','巧', '巨',0,0,'巫',0,0,'差',0, */
	/* 5df0 */ 0,0x384a,0x5661,0x4c26,0x4743,0x5662,0,0x392b, 0,0,0,0x342c,0,0x4327,0x3652,0, /* 0,'己','已','巳','巴','巵',0,'巷', 0,0,0,'巻',0,'巽','巾',0, */
	/* 5e00 */ 0,0,0x3b54,0x495b,0,0,0x4841,0, 0,0,0,0x5663,0x3475,0,0,0, /* 0,0,'市','布',0,0,'帆',0, 0,0,0,'帋','希',0,0,0, */
	/* 5e10 */ 0,0x5666,0,0,0,0,0x4421,0, 0,0x5665,0x5664,0x5667,0,0x446b,0,0, /* 0,'帑',0,0,0,0,'帖',0, 0,'帙','帚','帛',0,'帝',0,0, */
	/* 5e20 */ 0,0,0,0,0,0x3f63,0,0, 0,0,0,0x3b55,0,0x404a,0,0x4253, /* 0,0,0,0,0,'帥',0,0, 0,0,0,'師',0,'席',0,'帯', */
	/* 5e30 */ 0x3522,0,0,0x4422,0,0,0x5668,0x5669, 0x3e6f,0,0,0,0,0x4b39,0,0, /* '帰',0,0,'帳',0,0,'帶','帷', '常',0,0,0,0,'帽',0,0, */
	/* 5e40 */ 0x566c,0,0,0x566b,0x566a,0x497d,0,0x5673, 0,0,0,0,0x4b5a,0,0x566d,0, /* '幀',0,0,'幃','幄','幅',0,'幇', 0,0,0,0,'幌',0,'幎',0, */
	/* 5e50 */ 0,0,0,0,0x566f,0x4b6b,0,0x566e, 0,0,0,0,0,0,0,0x5670, /* 0,0,0,0,'幔','幕',0,'幗', 0,0,0,0,0,0,0,'幟', */
	/* 5e60 */ 0,0x4828,0x5671,0x4a3e,0x5672,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'幡','幢','幣','幤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5e70 */ 0,0,0x3433,0x4a3f,0x472f,0x5674,0x5675,0, 0x392c,0x3434,0x5676,0x3838,0x4d44,0x4d29,0x3476,0x5678, /* 0,0,'干','平','年','幵','并',0, '幸','幹','幺','幻','幼','幽','幾','广', */
	/* 5e80 */ 0,0x4423,0,0x392d,0x3e31,0,0,0x485f, 0,0,0x3e32,0,0,0,0,0x3d78, /* 0,'庁',0,'広','庄',0,0,'庇', 0,0,'床',0,0,0,0,'序', */
	/* 5e90 */ 0,0,0,0,0,0x446c,0x4a79,0x4539, 0,0,0x392e,0,0x495c,0,0,0, /* 0,0,0,0,0,'底','庖','店', 0,0,'庚',0,'府',0,0,0, */
	/* 5ea0 */ 0x5679,0,0,0,0,0,0x4559,0x3a42, 0,0,0,0x384b,0,0x446d,0,0, /* '庠',0,0,0,0,0,'度','座', 0,0,0,'庫',0,'庭',0,0, */
	/* 5eb0 */ 0,0,0,0,0,0x3043,0x3d6e,0x392f, 0x4d47,0,0,0,0,0,0,0, /* 0,0,0,0,0,'庵','庶','康', '庸',0,0,0,0,0,0,0, */
	/* 5ec0 */ 0,0x567a,0x567b,0x4751,0,0,0,0, 0x567c,0x4e77,0x4f2d,0,0,0,0,0x567e, /* 0,'廁','廂','廃',0,0,0,0, '廈','廉','廊',0,0,0,0,'廏', */
	/* 5ed0 */ 0x567d,0,0,0x3347,0,0,0x5721,0, 0,0,0x5724,0x5725,0,0x5723,0,0x4940, /* '廐',0,0,'廓',0,0,'廖',0, 0,0,'廚','廛',0,'廝',0,'廟', */
	/* 5ee0 */ 0x3e33,0x5727,0x5726,0x5722,0,0,0,0, 0x5728,0x5729,0,0,0x572a,0,0,0, /* '廠','廡','廢','廣',0,0,0,0, '廨','廩',0,0,'廬',0,0,0, */
	/* 5ef0 */ 0x572d,0x572b,0,0x572c,0x572e,0,0x3164,0x446e, 0x572f,0,0x377a,0x3276,0x4736,0,0x5730,0x467b, /* '廰','廱',0,'廳','廴',0,'延','廷', '廸',0,'建','廻','廼',0,'廾','廿', */
	/* 5f00 */ 0,0x4a5b,0,0x5731,0x4f2e,0,0,0, 0,0x5732,0x4a40,0x5735,0x5021,0x5031,0,0x3c30, /* 0,'弁',0,'弃','弄',0,0,0, 0,'弉','弊','弋','弌','弍',0,'式', */
	/* 5f10 */ 0x4675,0x5736,0,0x355d,0x4424,0x307a,0x5737,0x4a26, 0x3930,0,0,0x4350,0,0,0,0x446f, /* '弐','弑',0,'弓','弔','引','弖','弗', '弘',0,0,'弛',0,0,0,'弟', */
	/* 5f20 */ 0,0,0,0,0,0x4c6f,0x3839,0x384c, 0,0x5738,0,0,0,0x5739,0,0x573f, /* 0,0,0,0,0,'弥','弦','弧', 0,'弩',0,0,0,'弭',0,'弯', */
	/* 5f30 */ 0,0x3c65,0,0,0,0x4425,0,0x362f, 0x573a,0,0,0,0x492b,0,0x4346,0, /* 0,'弱',0,0,0,'張',0,'強', '弸',0,0,0,'弼',0,'弾',0, */
	/* 5f40 */ 0,0x573b,0,0,0,0,0,0, 0x573c,0,0x3630,0,0x573d,0,0x573e,0, /* 0,'彁',0,0,0,0,0,0, '彈',0,'彊',0,'彌',0,'彎',0, */
	/* 5f50 */ 0,0x5740,0,0x4576,0,0,0x5741,0x5742, 0,0x5743,0,0,0x5734,0x5733,0,0, /* 0,'彑',0,'当',0,0,'彖','彗', 0,'彙',0,0,'彜','彝',0,0, */
	/* 5f60 */ 0,0x5744,0x3741,0,0,0,0x4927,0, 0,0x3a4c,0x4937,0x4426,0x494b,0x5745,0,0, /* 0,'彡','形',0,0,0,'彦',0, 0,'彩','彪','彫','彬','彭',0,0, */
	/* 5f70 */ 0x3e34,0x3146,0,0x5746,0,0,0,0x5747, 0,0x4c72,0,0,0x4860,0,0,0x574a, /* '彰','影',0,'彳',0,0,0,'彷', 0,'役',0,0,'彼',0,0,'彿', */
	/* 5f80 */ 0x317d,0x402c,0x5749,0x5748,0x3742,0x4254,0,0x574e, 0x574c,0,0x574b,0x4e27,0x3865,0,0,0, /* '往','征','徂','徃','径','待',0,'徇', '很',0,'徊','律','後',0,0,0, */
	/* 5f90 */ 0x3d79,0x574d,0x454c,0x3d3e,0,0,0,0x4640, 0x5751,0x5750,0,0,0,0,0x574f,0, /* '徐','徑','徒','従',0,0,0,'得', '徘','徙',0,0,0,0,'從',0, */
	/* 5fa0 */ 0x5752,0x3866,0,0,0,0,0,0, 0x5753,0x497c,0x3d5b,0,0,0x5754,0x4879,0, /* '徠','御',0,0,0,0,0,0, '徨','復','循',0,0,'徭','微',0, */
	/* 5fb0 */ 0,0,0,0x4641,0x4427,0,0,0, 0,0x4530,0,0,0x5755,0x352b,0,0, /* 0,0,0,'徳','徴',0,0,0, 0,'徹',0,0,'徼','徽',0,0, */
	/* 5fc0 */ 0,0,0,0x3f34,0,0x492c,0,0, 0,0,0,0,0x3477,0x4726,0,0, /* 0,0,0,'心',0,'必',0,0, 0,0,0,0,'忌','忍',0,0, */
	/* 5fd0 */ 0,0,0,0,0,0,0x5756,0x3b56, 0x4b3a,0x4b3b,0,0,0x317e,0x575b,0,0, /* 0,0,0,0,0,0,'忖','志', '忘','忙',0,0,'応','忝',0,0, */
	/* 5fe0 */ 0x4369,0,0,0,0x5758,0,0,0, 0,0,0,0x3277,0,0,0,0, /* '忠',0,0,0,'忤',0,0,0, 0,0,0,'快',0,0,0,0, */
	/* 5ff0 */ 0x582d,0x575a,0,0,0,0x4730,0,0, 0x5759,0,0,0x5757,0,0x397a,0,0x575d, /* '忰','忱',0,0,0,'念',0,0, '忸',0,0,'忻',0,'忽',0,'忿', */
	/* 6000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x5763,0x5769, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'怎','怏', */
	/* 6010 */ 0x5761,0,0x455c,0,0,0x5766,0x495d,0, 0,0x5760,0,0x5765,0x4e67,0x3b57,0,0, /* '怐',0,'怒',0,0,'怕','怖',0, 0,'怙',0,'怛','怜','思',0,0, */
	/* 6020 */ 0x4255,0x575e,0,0,0,0x355e,0x5768,0x402d, 0x3165,0x5762,0x3278,0x5767,0,0,0,0x3631, /* '怠','怡',0,0,0,'急','怦','性', '怨','怩','怪','怫',0,0,0,'怯', */
	/* 6030 */ 0,0x5764,0,0,0,0,0,0, 0,0,0x576a,0,0,0,0,0, /* 0,'怱',0,0,0,0,0,0, 0,0,'怺',0,0,0,0,0, */
	/* 6040 */ 0,0x576c,0x5776,0x5774,0,0,0x5771,0, 0,0,0x5770,0x4e78,0,0x5772,0,0, /* 0,'恁','恂','恃',0,0,'恆',0, 0,0,'恊','恋',0,'恍',0,0, */
	/* 6050 */ 0x3632,0,0x3931,0,0,0x3d7a,0,0, 0,0x5779,0x576b,0,0,0,0,0x576f, /* '恐',0,'恒',0,0,'恕',0,0, 0,'恙','恚',0,0,0,0,'恟', */
	/* 6060 */ 0x575f,0,0x327a,0x5773,0x5775,0x4351,0,0, 0x3a28,0x3238,0x576d,0x5778,0x5777,0x3633,0,0x4229, /* '恠',0,'恢','恣','恤','恥',0,0, '恨','恩','恪','恫','恬','恭',0,'息', */
	/* 6070 */ 0x3366,0,0,0,0,0x3743,0,0x576e, 0,0,0,0,0,0,0,0, /* '恰',0,0,0,0,'恵',0,'恷', 0,0,0,0,0,0,0,0, */
	/* 6080 */ 0,0x577a,0,0x577d,0x5821,0,0,0, 0,0x3c3d,0,0x5827,0x4470,0x577b,0,0, /* 0,'悁',0,'悃','悄',0,0,0, 0,'悉',0,'悋','悌','悍',0,0, */
	/* 6090 */ 0,0,0x5825,0,0x3279,0,0x5823,0x5824, 0,0,0x577e,0x5822,0,0,0,0x3867, /* 0,0,'悒',0,'悔',0,'悖','悗', 0,0,'悚','悛',0,0,0,'悟', */
	/* 60a0 */ 0x4d2a,0,0,0x3435,0,0,0x3159,0x5826, 0,0x473a,0x302d,0,0,0,0,0, /* '悠',0,0,'患',0,0,'悦','悧', 0,'悩','悪',0,0,0,0,0, */
	/* 60b0 */ 0,0,0x4861,0x575c,0x582c,0x5830,0x4c65,0, 0x5829,0,0,0,0x4569,0x582e,0,0, /* 0,0,'悲','悳','悴','悵','悶',0, '悸',0,0,0,'悼','悽',0,0, */
	/* 60c0 */ 0,0,0,0,0,0x3e70,0x582f,0x4657, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'情','惆','惇', 0,0,0,0,0,0,0,0, */
	/* 60d0 */ 0,0x4f47,0,0x582b,0,0,0,0, 0x5831,0,0x397b,0,0x404b,0,0,0x3054, /* 0,'惑',0,'惓',0,0,0,0, '惘',0,'惚',0,'惜',0,0,'惟', */
	/* 60e0 */ 0x582a,0x5828,0,0x415a,0,0,0,0x577c, 0x3b34,0,0,0,0,0,0,0, /* '惠','惡',0,'惣',0,0,0,'惧', '惨',0,0,0,0,0,0,0, */
	/* 60f0 */ 0x4246,0x583d,0,0x415b,0x5838,0,0x5835,0x5836, 0,0x3c66,0x5839,0x583c,0,0,0,0, /* '惰','惱',0,'想','惴',0,'惶','惷', 0,'惹','惺','惻',0,0,0,0, */
	/* 6100 */ 0x5837,0x3d25,0,0x583a,0,0,0x5834,0, 0x4c7c,0x4c7b,0,0,0,0x583e,0x583f,0x3055, /* '愀','愁',0,'愃',0,0,'愆',0, '愈','愉',0,0,0,'愍','愎','意', */
	/* 6110 */ 0,0,0,0,0,0x5833,0,0, 0,0,0x3672,0x3026,0,0,0,0x3436, /* 0,0,0,0,0,'愕',0,0, 0,0,'愚','愛',0,0,0,'感', */
	/* 6120 */ 0,0x583b,0,0,0,0,0,0x5843, 0x5842,0,0,0,0x5847,0,0,0, /* 0,'愡',0,0,0,0,0,'愧', '愨',0,0,0,'愬',0,0,0, */
	/* 6130 */ 0,0,0,0,0x5848,0,0,0, 0,0,0,0,0x5846,0x5849,0x5841,0x5845, /* 0,0,0,0,'愴',0,0,0, 0,0,0,0,'愼','愽','愾','愿', */
	/* 6140 */ 0,0,0x584a,0,0x584b,0,0,0x5840, 0x3b7c,0,0x5844,0x4256,0x3932,0x5832,0x3f35,0, /* 0,0,'慂',0,'慄',0,0,'慇', '慈',0,'慊','態','慌','慍','慎',0, */
	/* 6150 */ 0,0,0,0x5858,0,0x4a69,0,0, 0x584e,0x584f,0x5850,0,0,0x5857,0,0x5856, /* 0,0,0,'慓',0,'慕',0,0, '慘','慙','慚',0,0,'慝',0,'慟', */
	/* 6160 */ 0,0,0x4b7d,0x3437,0,0x5854,0,0x3745, 0x3334,0,0,0x5851,0,0,0x4e38,0x5853, /* 0,0,'慢','慣',0,'慥',0,'慧', '慨',0,0,'慫',0,0,'慮','慯', */
	/* 6170 */ 0x3056,0x5855,0,0x584c,0x5852,0x5859,0x3744,0x584d, 0,0,0,0,0,0,0x4d5d,0, /* '慰','慱',0,'慳','慴','慵','慶','慷', 0,0,0,0,0,0,'慾',0, */
	/* 6180 */ 0,0,0x4d2b,0,0,0,0,0x585c, 0,0,0x5860,0,0,0,0x417e,0, /* 0,0,'憂',0,0,0,0,'憇', 0,0,'憊',0,0,0,'憎',0, */
	/* 6190 */ 0x4e79,0x5861,0,0,0x585e,0,0x585b,0, 0,0x585a,0x585f,0,0,0,0,0, /* '憐','憑',0,0,'憔',0,'憖',0, 0,'憙','憚',0,0,0,0,0, */
	/* 61a0 */ 0,0,0,0,0x4a30,0,0,0x4634, 0,0x3746,0,0x5862,0x585d,0,0x5863,0, /* 0,0,0,0,'憤',0,0,'憧', 0,'憩',0,'憫','憬',0,'憮',0, */
	/* 61b0 */ 0,0,0x377b,0,0,0,0x3231,0, 0,0,0x586b,0,0,0,0x3438,0, /* 0,0,'憲',0,0,0,'憶',0, 0,0,'憺',0,0,0,'憾',0, */
	/* 61c0 */ 0,0,0,0x5869,0,0,0x586a,0x3a29, 0x5868,0x5866,0x5865,0x586c,0x5864,0x586e,0,0, /* 0,0,0,'懃',0,0,'懆','懇', '懈','應','懊','懋','懌','懍',0,0, */
	/* 61d0 */ 0x327b,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '懐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 61e0 */ 0,0,0,0x5870,0,0,0x586f,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'懣',0,0,'懦',0, 0,0,0,0,0,0,0,0, */
	/* 61f0 */ 0,0,0x4428,0,0x5873,0,0x5871,0x5867, 0x377c,0,0x5872,0,0x5876,0x5875,0x5877,0x5874, /* 0,0,'懲',0,'懴',0,'懶','懷', '懸',0,'懺',0,'懼','懽','懾','懿', */
	/* 6200 */ 0x5878,0,0,0,0,0,0,0, 0x5879,0x587a,0x4a6a,0,0x587c,0x587b,0x3d3f,0, /* '戀',0,0,0,0,0,0,0, '戈','戉','戊',0,'戌','戍','戎',0, */
	/* 6210 */ 0x402e,0x3266,0x327c,0,0x587d,0,0x303f,0, 0,0,0x404c,0x587e,0,0x6c43,0x5921,0x3761, /* '成','我','戒',0,'戔',0,'或',0, 0,0,'戚','戛',0,'戝','戞','戟', */
	/* 6220 */ 0,0x5922,0,0,0,0,0x406f,0, 0,0,0x5923,0,0,0,0x5924,0x353a, /* 0,'戡',0,0,0,0,'戦',0, 0,0,'截',0,0,0,'戮','戯', */
	/* 6230 */ 0x5925,0,0x5926,0x5927,0x4257,0,0,0, 0x384d,0,0,0x4c61,0,0,0,0x4b3c, /* '戰',0,'戲','戳','戴',0,0,0, '戸',0,0,'戻',0,0,0,'房', */
	/* 6240 */ 0x3d6a,0x5928,0,0,0,0,0,0x4070, 0x6e3d,0x4862,0,0x3c6a,0,0x3a4d,0x5929,0, /* '所','扁',0,0,0,0,0,'扇', '扈','扉',0,'手',0,'才','扎',0, */
	/* 6250 */ 0,0,0,0x4247,0,0x4a27,0,0, 0x4271,0,0,0x592c,0,0,0x592a,0, /* 0,0,0,'打',0,'払',0,0, '托',0,0,'扛',0,0,'扞',0, */
	/* 6260 */ 0x592d,0,0,0x592b,0,0,0,0, 0x592e,0,0,0,0,0,0x4a31,0, /* '扠',0,0,'扣',0,0,0,0, '扨',0,0,0,0,0,'扮',0, */
	/* 6270 */ 0,0x3037,0,0,0,0,0x495e,0, 0,0x4863,0,0,0x592f,0,0x5932,0x3e35, /* 0,'扱',0,0,0,0,'扶',0, 0,'批',0,0,'扼',0,'找','承', */
	/* 6280 */ 0x353b,0,0x5930,0x5937,0x3e36,0,0,0, 0,0x5931,0x4744,0,0,0,0,0, /* '技',0,'抂','抃','抄',0,0,0, 0,'抉','把',0,0,0,0,0, */
	/* 6290 */ 0,0x4d5e,0x5933,0x5934,0x5938,0x456a,0x5935,0x3933, 0x405e,0,0,0x5946,0x4834,0,0x4272,0, /* 0,'抑','抒','抓','抔','投','抖','抗', '折',0,0,'抛','抜',0,'択',0, */
	/* 62a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x4864,0x5a2d,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'披','抬',0,0,0, */
	/* 62b0 */ 0,0x4a7a,0,0,0,0x4471,0,0, 0,0x4b75,0,0x593b,0x3221,0x436a,0,0, /* 0,'抱',0,0,0,'抵',0,0, 0,'抹',0,'抻','押','抽',0,0, */
	/* 62c0 */ 0,0,0x5944,0,0,0x4334,0x593e,0x5945, 0x5940,0x5947,0x5943,0,0x5942,0x476f,0,0x593c, /* 0,0,'拂',0,0,'担','拆','拇', '拈','拉','拊',0,'拌','拍',0,'拏', */
	/* 62d0 */ 0x327d,0x593a,0x3571,0x4273,0x5936,0,0,0x5939, 0x3934,0x405b,0,0x3e37,0x5941,0x4752,0,0, /* '拐','拑','拒','拓','拔',0,0,'拗', '拘','拙',0,'招','拜','拝',0,0, */
	/* 62e0 */ 0x3572,0x3348,0,0,0,0,0,0, 0,0,0,0,0x3367,0x3f21,0x5949,0x594e, /* '拠','拡',0,0,0,0,0,0, 0,0,0,0,'括','拭','拮','拯', */
	/* 62f0 */ 0,0x594a,0,0x377d,0,0x594f,0x3b22,0x3969, 0,0,0,0,0,0,0x3d26,0x593d, /* 0,'拱',0,'拳',0,'拵','拶','拷', 0,0,0,0,0,0,'拾','拿', */
	/* 6300 */ 0,0x3b7d,0x594c,0,0,0,0,0x3b58, 0x594d,0x3044,0,0,0x5948,0,0,0, /* 0,'持','挂',0,0,0,0,'指', '挈','按',0,0,'挌',0,0,0, */
	/* 6310 */ 0,0x4429,0,0,0,0,0,0, 0,0x3573,0,0,0,0,0,0x3634, /* 0,'挑',0,0,0,0,0,0, 0,'挙',0,0,0,0,0,'挟', */
	/* 6320 */ 0,0,0,0,0,0,0,0x594b, 0x3027,0,0,0x3a43,0,0,0,0x3f36, /* 0,0,0,0,0,0,0,'挧', '挨',0,0,'挫',0,0,0,'振', */
	/* 6330 */ 0,0,0,0,0,0,0,0, 0,0,0x4472,0,0,0x4854,0x5951,0x415e, /* 0,0,0,0,0,0,0,0, 0,0,'挺',0,0,'挽','挾','挿', */
	/* 6340 */ 0,0,0,0,0,0,0,0, 0,0x422a,0,0,0x3b2b,0x5952,0,0x5954, /* 0,0,0,0,0,0,0,0, 0,'捉',0,0,'捌','捍',0,'捏', */
	/* 6350 */ 0x5950,0,0,0,0,0x4a61,0,0x443d, 0,0,0,0,0x415c,0,0,0, /* '捐',0,0,0,0,'捕',0,'捗', 0,0,0,0,'捜',0,0,0, */
	/* 6360 */ 0,0,0,0,0,0,0,0x4a7b, 0x3c4e,0x5960,0,0x595f,0,0,0x3f78,0, /* 0,0,0,0,0,0,0,'捧', '捨','捩',0,'捫',0,0,'据',0, */
	/* 6370 */ 0,0,0x377e,0,0,0,0x5959,0x3e39, 0,0,0x4668,0x4731,0,0,0,0, /* 0,0,'捲',0,0,0,'捶','捷', 0,0,'捺','捻',0,0,0,0, */
	/* 6380 */ 0x5957,0,0,0x415d,0,0,0,0, 0x3c78,0x595c,0,0,0x3e38,0,0x5956,0x595b, /* '掀',0,0,'掃',0,0,0,0, '授','掉',0,0,'掌',0,'掎','掏', */
	/* 6390 */ 0,0,0x4753,0,0,0,0x5955,0, 0x3721,0,0,0x335d,0,0,0,0x595d, /* 0,0,'排',0,0,0,'掖',0, '掘',0,0,'掛',0,0,0,'掟', */
	/* 63a0 */ 0x4e2b,0x3a4e,0x4335,0x595a,0,0x405c,0,0x3935, 0x3f64,0x3166,0x413c,0x5958,0x3545,0,0,0, /* '掠','採','探','掣',0,'接',0,'控', '推','掩','措','掫','掬',0,0,0, */
	/* 63b0 */ 0,0,0x3747,0,0x444f,0x595e,0,0, 0,0,0,0x415f,0,0,0x5961,0, /* 0,0,'掲',0,'掴','掵',0,0, 0,0,0,'掻',0,0,'掾',0, */
	/* 63c0 */ 0x5963,0,0,0x4237,0x5969,0,0x5964,0, 0,0x5966,0,0,0,0,0,0x4941, /* '揀',0,0,'揃','揄',0,'揆',0, 0,'揉',0,0,0,0,0,'描', */
	/* 63d0 */ 0x4473,0,0x5967,0,0,0,0x4d2c,0, 0,0,0x4d48,0x3439,0,0,0,0, /* '提',0,'插',0,0,0,'揖',0, 0,0,'揚','換',0,0,0,0, */
	/* 63e0 */ 0,0x302e,0,0x5965,0,0,0,0, 0,0x5962,0,0,0,0,0x3478,0, /* 0,'握',0,'揣',0,0,0,0, 0,'揩',0,0,0,0,'揮',0, */
	/* 63f0 */ 0,0,0,0,0x3167,0,0x5968,0, 0,0,0x4d49,0,0,0,0,0, /* 0,0,0,0,'援',0,'揶',0, 0,0,'揺',0,0,0,0,0, */
	/* 6400 */ 0,0,0,0,0,0,0x596c,0, 0,0,0,0,0,0x423b,0,0x5973, /* 0,0,0,0,0,0,'搆',0, 0,0,0,0,0,'損',0,'搏', */
	/* 6410 */ 0,0,0,0x596d,0,0,0x596a,0x5971, 0,0,0,0,0x5953,0,0,0, /* 0,0,0,'搓',0,0,'搖','搗', 0,0,0,0,'搜',0,0,0, */
	/* 6420 */ 0,0,0,0,0,0,0x596e,0, 0x5972,0,0,0,0x4842,0x456b,0,0, /* 0,0,0,0,0,0,'搦',0, '搨',0,0,0,'搬','搭',0,0, */
	/* 6430 */ 0,0,0,0,0x596b,0,0x596f,0, 0,0,0x3748,0,0,0,0x3a71,0, /* 0,0,0,0,'搴',0,'搶',0, 0,0,'携',0,0,0,'搾',0, */
	/* 6440 */ 0,0,0x405d,0,0,0,0,0, 0,0,0,0,0,0,0x5977,0, /* 0,0,'摂',0,0,0,0,0, 0,0,0,0,0,0,'摎',0, */
	/* 6450 */ 0,0,0,0,0,0,0,0, 0x4526,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '摘',0,0,0,0,0,0,0, */
	/* 6460 */ 0,0,0,0,0,0,0,0x5974, 0,0x4b60,0,0,0,0,0,0x5975, /* 0,0,0,0,0,0,0,'摧', 0,'摩',0,0,0,0,0,'摯', */
	/* 6470 */ 0,0,0,0,0,0,0x5976,0, 0x4c4e,0,0x4022,0,0,0,0,0, /* 0,0,0,0,0,0,'摶',0, '摸',0,'摺',0,0,0,0,0, */
	/* 6480 */ 0,0,0,0x3762,0,0,0,0, 0x597d,0,0,0,0,0,0,0, /* 0,0,0,'撃',0,0,0,0, '撈',0,0,0,0,0,0,0, */
	/* 6490 */ 0,0,0x3b35,0x597a,0,0x5979,0,0, 0,0,0x4732,0,0,0,0x4635,0, /* 0,0,'撒','撓',0,'撕',0,0, 0,0,'撚',0,0,0,'撞',0, */
	/* 64a0 */ 0,0,0,0,0x4531,0x597b,0,0, 0,0x597c,0,0x496f,0,0x4745,0x3b23,0, /* 0,0,0,0,'撤','撥',0,0, 0,'撩',0,'撫',0,'播','撮',0, */
	/* 64b0 */ 0x4071,0,0x4b50,0,0,0,0,0, 0,0x3349,0,0x5a25,0x597e,0,0,0, /* '撰',0,'撲',0,0,0,0,0, 0,'撹',0,'撻','撼',0,0,0, */
	/* 64c0 */ 0,0x4d4a,0x5a27,0,0,0x5a23,0,0x5a24, 0,0,0,0,0,0x4160,0,0, /* 0,'擁','擂',0,0,'擅',0,'擇', 0,0,0,0,0,'操',0,0, */
	/* 64d0 */ 0,0,0x5a22,0,0x593f,0,0,0, 0x5a26,0,0x5a21,0,0,0,0,0, /* 0,0,'擒',0,'擔',0,0,0, '擘',0,'據',0,0,0,0,0, */
	/* 64e0 */ 0x5a2b,0x5a2c,0x4527,0x5a2e,0,0,0x3b24,0x5a29, 0,0,0,0,0x353c,0,0,0x5a2f, /* '擠','擡','擢','擣',0,0,'擦','擧', 0,0,0,0,'擬',0,0,'擯', */
	/* 64f0 */ 0,0x5a28,0x5a33,0,0x5a32,0,0x5a31,0, 0,0,0x5a34,0,0,0x5a36,0x3e71,0, /* 0,'擱','擲',0,'擴',0,'擶',0, 0,0,'擺',0,0,'擽','擾',0, */
	/* 6500 */ 0x5a35,0,0,0,0,0x5a39,0,0, 0,0,0,0,0,0,0,0, /* '攀',0,0,0,0,'攅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6510 */ 0,0,0,0,0,0,0,0, 0x5a37,0,0,0,0x5a38,0x5970,0,0, /* 0,0,0,0,0,0,0,0, '攘',0,0,0,'攜','攝',0,0, */
	/* 6520 */ 0,0,0,0x5a3b,0x5a3a,0,0,0, 0,0,0x5978,0x5a3c,0x5a30,0,0,0x3b59, /* 0,0,0,'攣','攤',0,0,0, 0,0,'攪','攫','攬',0,0,'支', */
	/* 6530 */ 0,0,0,0,0x5a3d,0x5a3e,0x5a40,0x5a3f, 0x5a41,0x327e,0,0x3936,0,0,0x4a7c,0x402f, /* 0,0,0,0,'攴','攵','收','攷', '攸','改',0,'攻',0,0,'放','政', */
	/* 6540 */ 0,0,0,0,0,0x384e,0,0, 0x5a43,0,0,0,0,0x5a46,0,0x4952, /* 0,0,0,0,0,'故',0,0, '效',0,0,0,0,'敍',0,'敏', */
	/* 6550 */ 0,0x355f,0,0,0,0x5a45,0x5a44,0x4754, 0x5a47,0x3635,0,0,0,0x5a49,0x5a48,0, /* 0,'救',0,0,0,'敕','敖','敗', '敘','教',0,0,0,'敝','敞',0, */
	/* 6560 */ 0,0,0x343a,0x3b36,0,0,0x4658,0, 0,0,0,0,0x3749,0,0,0, /* 0,0,'敢','散',0,0,'敦',0, 0,0,0,0,'敬',0,0,0, */
	/* 6570 */ 0x3f74,0,0x5a4a,0,0x4030,0x4528,0,0x495f, 0x5a4b,0,0,0,0,0,0,0, /* '数',0,'敲',0,'整','敵',0,'敷', '數',0,0,0,0,0,0,0, */
	/* 6580 */ 0,0,0x5a4c,0x5a4d,0,0,0,0x4a38, 0x555d,0x4046,0,0,0x494c,0,0x3a58,0, /* 0,0,'斂','斃',0,0,0,'文', '斈','斉',0,0,'斌',0,'斎',0, */
	/* 6590 */ 0x4865,0x4843,0,0,0,0,0,0x454d, 0,0x4e41,0,0x5a4f,0x3c50,0,0,0x5a50, /* '斐','斑',0,0,0,0,0,'斗', 0,'料',0,'斛','斜',0,0,'斟', */
	/* 65a0 */ 0,0x3036,0,0,0x3654,0x404d,0,0x4960, 0,0,0,0x5a51,0x3b42,0x4347,0,0x3b5b, /* 0,'斡',0,0,'斤','斥',0,'斧', 0,0,0,'斫','斬','断',0,'斯', */
	/* 65b0 */ 0x3f37,0,0,0,0,0,0,0x5a52, 0,0x4a7d,0,0,0x3177,0x3b5c,0,0, /* '新',0,0,0,0,0,0,'斷', 0,'方',0,0,'於','施',0,0, */
	/* 65c0 */ 0,0x5a55,0,0x5a53,0x5a56,0x4e39,0x5a54,0, 0,0,0,0x407b,0x5a57,0,0,0x4232, /* 0,'旁',0,'旃','旄','旅','旆',0, 0,0,0,'旋','旌',0,0,'族', */
	/* 65d0 */ 0,0,0x5a58,0,0,0,0,0x347a, 0,0x5a5a,0,0x5a59,0,0,0,0, /* 0,0,'旒',0,0,0,0,'旗', 0,'旙',0,'旛',0,0,0,0, */
	/* 65e0 */ 0x5a5b,0x5a5c,0x347b,0,0,0x467c,0x4336,0x356c, 0x3b5d,0x4161,0,0,0x3d5c,0x3030,0,0, /* '无','旡','既',0,0,'日','旦','旧', '旨','早',0,0,'旬','旭',0,0, */
	/* 65f0 */ 0,0x5a5d,0,0,0,0,0,0, 0,0,0x3222,0x5a61,0,0,0,0, /* 0,'旱',0,0,0,0,0,0, 0,0,'旺','旻',0,0,0,0, */
	/* 6600 */ 0,0,0x3937,0x5a60,0,0,0x3a2b,0x3e3a, 0,0,0x5a5f,0,0x3e3b,0,0x4c40,0x3a2a, /* 0,0,'昂','昃',0,0,'昆','昇', 0,0,'昊',0,'昌',0,'明','昏', */
	/* 6610 */ 0,0,0,0x3057,0x404e,0,0,0, 0,0,0,0,0x5a66,0,0,0x4031, /* 0,0,0,'易','昔',0,0,0, 0,0,0,0,'昜',0,0,'星', */
	/* 6620 */ 0x3147,0,0,0,0,0x3d55,0,0x4b66, 0x3a72,0,0,0,0,0x3e3c,0,0x4027, /* '映',0,0,0,0,'春',0,'昧', '昨',0,0,0,0,'昭',0,'是', */
	/* 6630 */ 0,0,0,0,0x5a65,0x5a63,0x5a64,0, 0,0,0,0,0x436b,0,0,0x5b26, /* 0,0,0,0,'昴','昵','昶',0, 0,0,0,0,'昼',0,0,'昿', */
	/* 6640 */ 0,0x5a6a,0x3b7e,0x3938,0x5a68,0,0,0, 0,0x5a69,0,0x3f38,0,0,0,0x5a67, /* 0,'晁','時','晃','晄',0,0,0, 0,'晉',0,'晋',0,0,0,'晏', */
	/* 6650 */ 0,0,0x3b2f,0,0,0,0,0, 0,0,0,0,0,0x5a6c,0x5a6b,0x5a70, /* 0,0,'晒',0,0,0,0,0, 0,0,0,0,0,'晝','晞','晟', */
	/* 6660 */ 0,0,0x5a71,0,0x5a6d,0,0x3322,0x5a6e, 0x5a6f,0x4855,0,0,0,0,0x4961,0x374a, /* 0,0,'晢',0,'晤',0,'晦','晧', '晨','晩',0,0,0,0,'普','景', */
	/* 6670 */ 0x5a72,0,0,0,0x4032,0,0x3e3d,0, 0,0,0x4352,0,0,0,0,0, /* '晰',0,0,0,'晴',0,'晶',0, 0,0,'智',0,0,0,0,0, */
	/* 6680 */ 0,0x3647,0,0x5a73,0x5a77,0,0,0x324b, 0x5a74,0x5a76,0,0,0,0,0x5a75,0, /* 0,'暁',0,'暃','暄',0,0,'暇', '暈','暉',0,0,0,0,'暎',0, */
	/* 6690 */ 0,0x3d6b,0,0,0,0,0x4348,0x3045, 0x5a78,0,0,0,0,0x5a79,0,0, /* 0,'暑',0,0,0,0,'暖','暗', '暘',0,0,0,0,'暝',0,0, */
	/* 66a0 */ 0,0,0x442a,0,0,0,0x4e71,0, 0,0,0,0x3b43,0,0,0x4a6b,0, /* 0,0,'暢',0,0,0,'暦',0, 0,0,0,'暫',0,0,'暮',0, */
	/* 66b0 */ 0,0,0,0,0x4b3d,0,0,0, 0x5b22,0x5a7b,0,0,0x5a7e,0,0x5a7d,0, /* 0,0,0,0,'暴',0,0,0, '暸','暹',0,0,'暼',0,'暾',0, */
	/* 66c0 */ 0,0x5a7a,0,0,0x5b21,0,0,0x465e, 0,0x5a7c,0,0,0,0,0,0, /* 0,'曁',0,0,'曄',0,0,'曇', 0,'曉',0,0,0,0,0,0, */
	/* 66d0 */ 0,0,0,0,0,0,0x5b23,0, 0,0x3d6c,0x5b24,0,0x4d4b,0x4778,0,0, /* 0,0,0,0,0,0,'曖',0, 0,'曙','曚',0,'曜','曝',0,0, */
	/* 66e0 */ 0x5b25,0,0,0,0,0,0x5b27,0, 0,0x5b28,0,0,0,0,0,0, /* '曠',0,0,0,0,0,'曦',0, 0,'曩',0,0,0,0,0,0, */
	/* 66f0 */ 0x5b29,0,0x364a,0x3148,0x3939,0x5b2a,0,0x5b2b, 0x3d71,0x4162,0,0,0x5258,0x413e,0x413d,0x4258, /* '曰',0,'曲','曳','更','曵',0,'曷', '書','曹',0,0,'曼','曽','曾','替', */
	/* 6700 */ 0x3a47,0,0,0x5072,0,0,0,0, 0x376e,0x4d2d,0,0x4a7e,0,0x497e,0,0x5b2c, /* '最',0,0,'會',0,0,0,0, '月','有',0,'朋',0,'服',0,'朏', */
	/* 6710 */ 0,0,0,0,0x3a73,0x443f,0x5b2d,0x4f2f, 0,0,0,0x4b3e,0,0x442b,0x5b2e,0x347c, /* 0,0,0,0,'朔','朕','朖','朗', 0,0,0,'望',0,'朝','朞','期', */
	/* 6720 */ 0,0,0,0,0,0,0x5b2f,0x5b30, 0x4c5a,0,0x4c24,0x4b76,0x4b5c,0x3b25,0x5b32,0, /* 0,0,0,0,0,0,'朦','朧', '木',0,'未','末','本','札','朮',0, */
	/* 6730 */ 0,0x3c6b,0,0,0x4b51,0,0x5b34,0x5b37, 0x5b36,0,0x3479,0,0,0x3560,0,0x5b33, /* 0,'朱',0,0,'朴',0,'朶','朷', '朸',0,'机',0,0,'朽',0,'朿', */
	/* 6740 */ 0,0x5b35,0,0,0,0,0x5b38,0, 0,0x3f79,0,0,0,0,0x4d7b,0x3049, /* 0,'杁',0,0,0,0,'杆',0, 0,'杉',0,0,0,0,'李','杏', */
	/* 6750 */ 0x3a60,0x423c,0,0x3c5d,0,0,0x3e73,0, 0,0x5b3b,0,0,0x454e,0,0x5b39,0x422b, /* '材','村',0,'杓',0,0,'杖',0, 0,'杙',0,0,'杜',0,'杞','束', */
	/* 6760 */ 0x5b3a,0x3e72,0x4c5d,0x5b3c,0x5b3d,0x4d68,0,0, 0,0,0x5b42,0,0,0x393a,0,0x4755, /* '杠','条','杢','杣','杤','来',0,0, 0,0,'杪',0,0,'杭',0,'杯', */
	/* 6770 */ 0x5b3f,0x456c,0x5a5e,0x5a62,0,0x354f,0,0x4747, 0,0,0,0,0x5b41,0,0x3e3e,0x4844, /* '杰','東','杲','杳',0,'杵',0,'杷', 0,0,0,0,'杼',0,'松','板', */
	/* 6780 */ 0,0,0,0,0,0x5b47,0,0x487a, 0,0x5b3e,0,0x5b44,0x5b43,0,0,0, /* 0,0,0,0,0,'枅',0,'枇', 0,'枉',0,'枋','枌',0,0,0, */
	/* 6790 */ 0x404f,0,0,0,0,0x4b6d,0,0x4e53, 0,0,0x4b67,0,0x324c,0x3b5e,0,0, /* '析',0,0,0,0,'枕',0,'林', 0,0,'枚',0,'果','枝',0,0, */
	/* 67a0 */ 0x4f48,0x5b46,0x3f75,0,0,0,0x5b45,0, 0,0x5b40,0,0,0,0,0,0x384f, /* '枠','枡','枢',0,0,0,'枦',0, 0,'枩',0,0,0,0,0,'枯', */
	/* 67b0 */ 0,0,0,0x5b4c,0x5b4a,0,0x324d,0x5b48, 0x5b4e,0x5b54,0,0,0,0,0,0, /* 0,0,0,'枳','枴',0,'架','枷', '枸','枹',0,0,0,0,0,0, */
	/* 67c0 */ 0,0x4248,0,0,0x4a41,0,0x5b56,0, 0,0,0x4922,0,0,0,0x5b55,0x4770, /* 0,'柁',0,0,'柄',0,'柆',0, 0,0,'柊',0,0,0,'柎','柏', */
	/* 67d0 */ 0x4b3f,0x343b,0,0x4077,0x3d40,0,0,0, 0x4453,0,0x4d2e,0,0,0x5b51,0x5b50,0, /* '某','柑',0,'染','柔',0,0,0, '柘',0,'柚',0,0,'柝','柞',0, */
	/* 67e0 */ 0,0,0x5b52,0,0x5b4f,0,0,0x5b57, 0,0x5b4d,0,0,0x5b4b,0,0x5b53,0x5b49, /* 0,0,'柢',0,'柤',0,0,'柧', 0,'柩',0,0,'柬',0,'柮','柯', */
	/* 67f0 */ 0,0x436c,0,0x4c78,0x3c46,0x3a74,0,0, 0,0,0,0x3a3a,0,0,0x4b6f,0x3341, /* 0,'柱',0,'柳','柴','柵',0,0, 0,0,0,'査',0,0,'柾','柿', */
	/* 6800 */ 0,0,0x444e,0x464a,0x3149,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'栂','栃','栄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6810 */ 0,0,0,0x4072,0,0,0x4034,0x372a, 0,0,0,0,0,0,0x5b59,0, /* 0,0,0,'栓',0,0,'栖','栗', 0,0,0,0,0,0,'栞',0, */
	/* 6820 */ 0,0x393b,0x337c,0,0,0,0,0, 0,0x5b5b,0x3374,0x5b61,0,0,0,0, /* 0,'校','栢',0,0,0,0,0, 0,'栩','株','栫',0,0,0,0, */
	/* 6830 */ 0,0,0x5b5e,0,0x4073,0,0,0, 0x334b,0x3a2c,0,0,0x334a,0x3a4f,0,0, /* 0,0,'栲',0,'栴',0,0,0, '核','根',0,0,'格','栽',0,0, */
	/* 6840 */ 0x5b5c,0x3765,0x374b,0x456d,0,0,0x5b5a,0, 0x3046,0,0,0,0,0x5b5d,0x5b5f,0, /* '桀','桁','桂','桃',0,0,'框',0, '案',0,0,0,0,'桍','桎',0, */
	/* 6850 */ 0x364d,0x372c,0,0x343c,0x354b,0,0,0, 0,0x5b62,0,0,0x3a79,0x4b71,0,0x3b37, /* '桐','桑',0,'桓','桔',0,0,0, 0,'桙',0,0,'桜','桝',0,'桟', */
	/* 6860 */ 0,0,0,0x5b63,0,0,0,0x4930, 0,0,0,0,0,0,0,0, /* 0,0,0,'档',0,0,0,'桧', 0,0,0,0,0,0,0,0, */
	/* 6870 */ 0,0,0,0,0x5b6f,0,0x3233,0x5b64, 0,0,0,0,0,0,0x5b75,0x5b65, /* 0,0,0,0,'桴',0,'桶','桷', 0,0,0,0,0,0,'桾','桿', */
	/* 6880 */ 0,0x4e42,0,0x5b6c,0,0x475f,0,0, 0,0,0,0,0,0x5b74,0,0x5b67, /* 0,'梁',0,'梃',0,'梅',0,0, 0,0,0,0,0,'梍',0,'梏', */
	/* 6890 */ 0,0,0,0x3034,0x5b69,0,0,0x393c, 0,0,0,0x5b6b,0,0x5b6a,0,0x5b66, /* 0,0,0,'梓','梔',0,0,'梗', 0,0,0,'梛',0,'條',0,'梟', */
	/* 68a0 */ 0x5b71,0,0x3e3f,0,0,0,0x546d,0x3868, 0x4d7c,0,0,0,0,0x5b68,0,0x4474, /* '梠',0,'梢',0,0,0,'梦','梧', '梨',0,0,0,0,'梭',0,'梯', */
	/* 68b0 */ 0x3323,0x3a2d,0,0x5b60,0,0x5b70,0x3361,0, 0,0x5b6e,0x5b72,0,0x456e,0,0,0, /* '械','梱',0,'梳',0,'梵','梶',0, 0,'梹','梺',0,'梼',0,0,0, */
	/* 68c0 */ 0,0,0,0,0x347e,0,0x5c32,0, 0,0x4c49,0x5b77,0x347d,0,0x5b7e,0,0, /* 0,0,0,0,'棄',0,'棆',0, 0,'棉','棊','棋',0,'棍',0,0, */
	/* 68d0 */ 0,0,0x4b40,0,0x5c21,0x5c23,0,0x5c27, 0x5b79,0,0x432a,0,0,0,0,0x456f, /* 0,0,'棒',0,'棔','棕',0,'棗', '棘',0,'棚',0,0,0,0,'棟', */
	/* 68e0 */ 0x5c2b,0x5b7c,0,0x5c28,0,0,0,0x5c22, 0,0,0,0,0,0,0x3f39,0x5c2c, /* '棠','棡',0,'棣',0,0,0,'棧', 0,0,0,0,0,0,'森','棯', */
	/* 68f0 */ 0,0,0x4033,0,0,0,0,0, 0,0x5c2a,0x343d,0,0,0,0,0, /* 0,0,'棲',0,0,0,0,0, 0,'棹','棺',0,0,0,0,0, */
	/* 6900 */ 0x4f50,0x5b76,0,0,0x5c26,0x3058,0,0, 0x5b78,0,0,0x4c3a,0x5b7d,0x3f22,0x4447,0x5b73, /* '椀','椁',0,0,'椄','椅',0,0, '椈',0,0,'椋','椌','植','椎','椏', */
	/* 6910 */ 0,0,0x5c25,0,0,0,0,0, 0,0x3f7a,0x5c2f,0x3371,0x3821,0,0,0, /* 0,0,'椒',0,0,0,0,0, 0,'椙','椚','椛','検',0,0,0, */
	/* 6920 */ 0,0x5c31,0x5b7a,0x5c30,0,0x5c29,0x5b7b,0, 0x5c2d,0,0x5c2e,0,0,0,0,0, /* 0,'椡','椢','椣',0,'椥','椦',0, '椨',0,'椪',0,0,0,0,0, */
	/* 6930 */ 0x5c3f,0,0,0,0x464e,0,0x5c24,0, 0,0x5c3b,0,0,0,0x5c3d,0,0x4458, /* '椰',0,0,0,'椴',0,'椶',0, 0,'椹',0,0,0,'椽',0,'椿', */
	/* 6940 */ 0,0,0,0,0,0,0,0, 0,0,0x4d4c,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'楊',0,0,0,0,0, */
	/* 6950 */ 0,0,0,0x4976,0x5c38,0x424a,0,0, 0,0x5c3e,0x413f,0,0x5c35,0x5c42,0x5c41,0, /* 0,0,0,'楓','楔','楕',0,0, 0,'楙','楚',0,'楜','楝','楞',0, */
	/* 6960 */ 0x466f,0x5c40,0x466a,0,0,0,0,0, 0,0,0x5c44,0x5c37,0,0x3648,0x5c3a,0x3d5d, /* '楠','楡','楢',0,0,0,0,0, 0,0,'楪','楫',0,'業','楮','楯', */
	/* 6970 */ 0,0,0,0x4760,0x5c3c,0x364b,0,0x5c34, 0x5c36,0x5c33,0,0,0x4f30,0x335a,0x5c39,0, /* 0,0,0,'楳','楴','極',0,'楷', '楸','楹',0,0,'楼','楽','楾',0, */
	/* 6980 */ 0,0x5c43,0x3335,0,0,0,0,0, 0,0,0x3a67,0,0,0,0x315d,0, /* 0,'榁','概',0,0,0,0,0, 0,0,'榊',0,0,0,'榎',0, */
	/* 6990 */ 0,0x5c54,0,0,0x4f31,0x5c57,0,0, 0,0,0,0x3f3a,0x5c56,0,0,0, /* 0,'榑',0,0,'榔','榕',0,0, 0,0,0,'榛','榜',0,0,0, */
	/* 69a0 */ 0x5c55,0,0,0,0,0,0,0x5c52, 0,0,0,0,0,0,0x5c46,0, /* '榠',0,0,0,0,0,0,'榧', 0,0,0,0,0,0,'榮',0, */
	/* 69b0 */ 0,0x5c63,0x5c45,0,0x5c58,0,0,0, 0,0,0,0x5c50,0,0,0x5c4b,0x5c48, /* 0,'榱','榲',0,'榴',0,0,0, 0,0,0,'榻',0,0,'榾','榿', */
	/* 69c0 */ 0,0x5c49,0,0x5c51,0,0,0,0x7422, 0,0,0x5c4e,0x393d,0x4448,0x4164,0x5c4c,0, /* 0,'槁',0,'槃',0,0,0,'槇', 0,0,'槊','構','槌','槍','槎',0, */
	/* 69d0 */ 0x5c47,0,0,0x5c4a,0,0,0,0, 0x4d4d,0x4b6a,0,0,0,0x5c4f,0x5c59,0, /* '槐',0,0,'槓',0,0,0,0, '様','槙',0,0,0,'槝','槞',0, */
	/* 69e0 */ 0,0,0,0,0,0,0,0x5c61, 0x5c5a,0,0,0x5c67,0,0x5c65,0,0, /* 0,0,0,0,0,0,0,'槧', '槨',0,0,'槫',0,'槭',0,0, */
	/* 69f0 */ 0,0,0x5c60,0,0,0,0,0, 0,0x5c5f,0,0x4450,0,0x4165,0,0x5c5d, /* 0,0,'槲',0,0,0,0,0, 0,'槹',0,'槻',0,'槽',0,'槿', */
	/* 6a00 */ 0,0,0x5c5b,0,0,0x5c62,0,0, 0,0,0x5c68,0x4875,0x5c6e,0,0,0, /* 0,0,'樂',0,0,'樅',0,0, 0,0,'樊','樋','樌',0,0,0, */
	/* 6a10 */ 0,0,0x5c69,0x5c6c,0x5c66,0,0,0x4374, 0,0x4938,0,0x5c5c,0,0,0x5c64,0x3e40, /* 0,0,'樒','樓','樔',0,0,'樗', 0,'標',0,'樛',0,0,'樞','樟', */
	/* 6a20 */ 0,0x4c4f,0x5c78,0x5c6b,0,0,0,0, 0,0x3822,0x3223,0x335f,0,0,0x5c53,0, /* 0,'模','樢','樣',0,0,0,0, 0,'権','横','樫',0,0,'樮',0, */
	/* 6a30 */ 0,0,0,0,0,0x3e41,0x5c70,0, 0x5c77,0x3c79,0x3372,0,0,0x432e,0,0, /* 0,0,0,0,0,'樵','樶',0, '樸','樹','樺',0,0,'樽',0,0, */
	/* 6a40 */ 0,0,0,0,0x5c6d,0,0,0x5c72, 0x5c76,0,0,0x3636,0,0,0,0, /* 0,0,0,0,'橄',0,0,'橇', '橈',0,0,'橋',0,0,0,0, */
	/* 6a50 */ 0,0,0,0,0,0,0,0, 0x354c,0x5c74,0,0,0,0,0,0x3521, /* 0,0,0,0,0,0,0,0, '橘','橙',0,0,0,0,0,'機', */
	/* 6a60 */ 0,0x464b,0x5c73,0,0,0,0x5c75,0, 0,0,0,0,0,0,0,0, /* 0,'橡','橢',0,0,0,'橦',0, 0,0,0,0,0,0,0,0, */
	/* 6a70 */ 0,0,0x5c6f,0,0,0,0,0, 0x5c71,0,0,0,0,0,0,0x3360, /* 0,0,'橲',0,0,0,0,0, '橸',0,0,0,0,0,0,'橿', */
	/* 6a80 */ 0x4349,0,0,0,0x5c7c,0,0,0, 0,0,0,0,0,0x5c7a,0x3869,0, /* '檀',0,0,0,'檄',0,0,0, 0,0,0,0,0,'檍','檎',0, */
	/* 6a90 */ 0x5c79,0,0,0,0,0,0,0x5d21, 0,0,0,0,0x5b58,0,0,0, /* '檐',0,0,0,0,0,0,'檗', 0,0,0,0,'檜',0,0,0, */
	/* 6aa0 */ 0x5c7b,0,0x5c7d,0x5c7e,0,0,0,0, 0,0,0x5d2c,0,0x5d28,0,0x5b6d,0, /* '檠',0,'檢','檣',0,0,0,0, 0,0,'檪',0,'檬',0,'檮',0, */
	/* 6ab0 */ 0,0,0,0x5d27,0,0,0,0, 0x5d26,0,0,0x5d23,0,0,0,0, /* 0,0,0,'檳',0,0,0,0, '檸',0,0,'檻',0,0,0,0, */
	/* 6ac0 */ 0,0x5c6a,0x5d25,0x5d24,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'櫁','櫂','櫃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6ad0 */ 0,0x5d2a,0,0x4f26,0,0,0,0, 0,0,0x5d2d,0x367b,0,0,0x5d29,0x5d2b, /* 0,'櫑',0,'櫓',0,0,0,0, 0,0,'櫚','櫛',0,0,'櫞','櫟', */
	/* 6ae0 */ 0,0,0,0,0,0,0,0, 0x4827,0,0x5d2e,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '櫨',0,'櫪',0,0,0,0,0, */
	/* 6af0 */ 0,0,0,0,0,0,0,0, 0,0,0x5d32,0x5d2f,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'櫺','櫻',0,0,0,0, */
	/* 6b00 */ 0,0,0,0,0x4d73,0x5d30,0,0, 0,0,0x5c5e,0,0,0,0,0, /* 0,0,0,0,'欄','欅',0,0, 0,0,'權',0,0,0,0,0, */
	/* 6b10 */ 0,0,0x5d33,0,0,0,0x5d34,0, 0,0,0,0,0,0x3135,0,0x5d36, /* 0,0,'欒',0,0,0,'欖',0, 0,0,0,0,0,'欝',0,'欟', */
	/* 6b20 */ 0x3767,0x3c21,0,0x3655,0,0,0,0x3224, 0,0,0,0,0,0,0,0, /* '欠','次',0,'欣',0,0,0,'欧', 0,0,0,0,0,0,0,0, */
	/* 6b30 */ 0,0,0x4d5f,0,0,0,0,0x5d38, 0x5d37,0x5d3a,0x353d,0,0,0x3656,0x343e,0, /* 0,0,'欲',0,0,0,0,'欷', '欸','欹','欺',0,0,'欽','款',0, */
	/* 6b40 */ 0,0,0,0x5d3d,0,0,0,0x5d3c, 0,0x5d3e,0,0,0x324e,0,0x4337,0, /* 0,0,0,'歃',0,0,0,'歇', 0,'歉',0,0,'歌',0,'歎',0, */
	/* 6b50 */ 0x5d3f,0,0,0x343f,0x5d41,0,0,0, 0,0x5d40,0,0x5d42,0,0,0,0x5d43, /* '歐',0,0,'歓','歔',0,0,0, 0,'歙',0,'歛',0,0,0,'歟', */
	/* 6b60 */ 0,0x5d44,0x3b5f,0x4035,0x3a21,0,0x4970,0, 0,0x4a62,0x4f44,0,0,0,0,0x3b75, /* 0,'歡','止','正','此',0,'武',0, 0,'歩','歪',0,0,0,0,'歯', */
	/* 6b70 */ 0,0,0,0x3a50,0x4e72,0,0,0, 0x5d45,0x5d46,0,0x3b60,0,0,0,0x5d47, /* 0,0,0,'歳','歴',0,0,0, '歸','歹',0,'死',0,0,0,'歿', */
	/* 6b80 */ 0x5d48,0,0,0x5d4a,0x5d49,0,0x4b58,0, 0,0x3d5e,0x3c6c,0x3b44,0,0x5d4b,0,0, /* '殀',0,0,'殃','殄',0,'殆',0, 0,'殉','殊','残',0,'殍',0,0, */
	/* 6b90 */ 0,0,0,0,0,0x5d4d,0x3f23,0, 0x5d4c,0,0,0,0,0,0x5d4e,0, /* 0,0,0,0,0,'殕','殖',0, '殘',0,0,0,0,0,'殞',0, */
	/* 6ba0 */ 0,0,0,0,0x5d4f,0,0,0, 0,0,0x5d50,0x5d51,0,0,0,0x5d52, /* 0,0,0,0,'殤',0,0,0, 0,0,'殪','殫',0,0,0,'殯', */
	/* 6bb0 */ 0,0x5d54,0x5d53,0x5d55,0x3225,0x434a,0,0x5d56, 0,0,0x3b26,0x334c,0x5d57,0,0,0x4542, /* 0,'殱','殲','殳','殴','段',0,'殷', 0,0,'殺','殻','殼',0,0,'殿', */
	/* 6bc0 */ 0x544c,0,0,0,0,0x3523,0x5d58,0, 0,0,0,0x5d59,0,0x4a6c,0x4b68,0, /* '毀',0,0,0,0,'毅','毆',0, 0,0,0,'毋',0,'母','毎',0, */
	/* 6bd0 */ 0,0,0x4647,0x5d5a,0x4866,0,0,0, 0x487b,0,0,0x4c53,0,0,0,0x5d5b, /* 0,0,'毒','毓','比',0,0,0, '毘',0,0,'毛',0,0,0,'毟', */
	/* 6be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x5d5d,0x5d5c,0,0,0x5d5f, /* 0,0,0,0,0,0,0,0, 0,0,0,'毫','毬',0,0,'毯', */
	/* 6bf0 */ 0,0,0,0x5d5e,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'毳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c00 */ 0,0,0,0,0,0,0,0, 0x5d61,0,0,0,0,0,0,0x3b61, /* 0,0,0,0,0,0,0,0, '氈',0,0,0,0,0,0,'氏', */
	/* 6c10 */ 0,0x4c31,0,0x5d62,0x5d63,0,0,0x3524, 0,0,0,0x5d64,0,0,0,0, /* 0,'民',0,'氓','气',0,0,'気', 0,0,0,'氛',0,0,0,0, */
	/* 6c20 */ 0,0,0,0x5d66,0x5d65,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'氣','氤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c30 */ 0,0,0,0,0x3f65,0,0,0x4939, 0x314a,0,0,0,0,0,0x4845,0, /* 0,0,0,0,'水',0,0,'氷', '永',0,0,0,0,0,'氾',0, */
	/* 6c40 */ 0x4475,0x3d41,0x3561,0,0,0,0,0, 0,0,0,0,0,0,0x4846,0, /* '汀','汁','求',0,0,0,0,0, 0,0,0,0,0,0,'汎',0, */
	/* 6c50 */ 0x3c2e,0,0,0,0,0x5d68,0,0x3440, 0,0,0x3178,0,0,0x4672,0x5d67,0x393e, /* '汐',0,0,0,0,'汕',0,'汗', 0,0,'汚',0,0,'汝','汞','江', */
	/* 6c60 */ 0x4353,0,0x5d69,0,0,0,0,0, 0x5d71,0,0x5d6a,0,0,0,0,0, /* '池',0,'汢',0,0,0,0,0, '汨',0,'汪',0,0,0,0,0, */
	/* 6c70 */ 0x4241,0,0x3562,0x5d72,0,0,0,0, 0,0,0x3768,0,0,0x3525,0x5d70,0, /* '汰',0,'汲','汳',0,0,0,0, 0,0,'決',0,0,'汽','汾',0, */
	/* 6c80 */ 0,0x5d6e,0x5d6b,0x4d60,0,0,0,0, 0x4440,0,0,0,0x4659,0x5d6c,0,0, /* 0,'沁','沂','沃',0,0,0,0, '沈',0,0,0,'沌','沍',0,0, */
	/* 6c90 */ 0x5d74,0,0x5d73,0x3723,0,0,0x322d,0, 0,0x3a3b,0x5d6d,0x5d6f,0,0,0,0, /* '沐',0,'沒','沓',0,0,'沖',0, 0,'沙','沚','沛',0,0,0,0, */
	/* 6ca0 */ 0,0x4b57,0x4274,0,0,0,0,0, 0,0,0,0x4b77,0,0,0x5d7c,0, /* 0,'没','沢',0,0,0,0,0, 0,0,0,'沫',0,0,'沮',0, */
	/* 6cb0 */ 0,0x5d7d,0,0x324f,0,0,0,0, 0x4a28,0x4c7d,0x5e21,0x3c23,0x3e42,0x5d78,0x5d7e,0x3168, /* 0,'沱',0,'河',0,0,0,0, '沸','油','沺','治','沼','沽','沾','沿', */
	/* 6cc0 */ 0,0x3637,0,0,0x5d75,0x5d7a,0,0, 0,0x4074,0x4771,0,0x4867,0,0,0, /* 0,'況',0,0,'泄','泅',0,0, 0,'泉','泊',0,'泌',0,0,0, */
	/* 6cd0 */ 0,0,0,0x5d77,0,0x4b21,0,0x5d79, 0,0x5e24,0,0x5e22,0,0x5d7b,0,0, /* 0,0,0,'泓',0,'法',0,'泗', 0,'泙',0,'泛',0,'泝',0,0, */
	/* 6ce0 */ 0,0x4b22,0x4748,0x3563,0,0x4525,0,0, 0x436d,0,0x5e25,0,0,0,0,0x5e23, /* 0,'泡','波','泣',0,'泥',0,0, '注',0,'泪',0,0,0,0,'泯', */
	/* 6cf0 */ 0x4259,0x5d76,0,0x314b,0,0,0,0, 0,0,0,0,0,0,0,0, /* '泰','泱',0,'泳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0x4d4e,0x5e30,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'洋','洌',0,0,0, */
	/* 6d10 */ 0,0,0x5e2f,0,0,0,0,0x4076, 0,0x5e2c,0,0x4d6c,0,0,0x4636,0x5e26, /* 0,0,'洒',0,0,0,0,'洗', 0,'洙',0,'洛',0,0,'洞','洟', */
	/* 6d20 */ 0,0,0,0,0,0x4445,0,0, 0,0x314c,0x393f,0x5e29,0,0,0,0, /* 0,0,0,0,0,'津',0,0, 0,'洩','洪','洫',0,0,0,0, */
	/* 6d30 */ 0,0,0x3d27,0x5e2e,0,0x5e2d,0x5e28,0, 0x5e2b,0,0,0x3368,0,0x5e2a,0x4749,0, /* 0,0,'洲','洳',0,'洵','洶',0, '洸',0,0,'活',0,'洽','派',0, */
	/* 6d40 */ 0,0x4e2e,0,0,0x3e74,0x4075,0,0, 0,0,0,0,0,0,0,0, /* 0,'流',0,0,'浄','浅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6d50 */ 0,0,0,0,0,0,0,0, 0,0x5e36,0x5e34,0,0x494d,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'浙','浚',0,'浜',0,0,0, */
	/* 6d60 */ 0,0,0,0x5e31,0x5e33,0,0x313a,0, 0,0x3940,0x4f32,0,0x333d,0,0x4962,0, /* 0,0,0,'浣','浤',0,'浦',0, 0,'浩','浪',0,'浬',0,'浮',0, */
	/* 6d70 */ 0,0,0,0,0x4d61,0,0,0x3324, 0x3f3b,0x5e35,0,0,0,0,0,0, /* 0,0,0,0,'浴',0,0,'海', '浸','浹',0,0,0,0,0,0, */
	/* 6d80 */ 0,0,0,0,0,0x5e3a,0,0, 0x3e43,0,0,0,0x4d30,0,0x5e37,0, /* 0,0,0,0,0,'涅',0,0, '消',0,0,0,'涌',0,'涎',0, */
	/* 6d90 */ 0,0,0,0x5e32,0,0x5e38,0,0, 0,0x4e5e,0,0x4573,0x4642,0,0,0, /* 0,0,0,'涓',0,'涕',0,0, 0,'涙',0,'涛','涜',0,0,0, */
	/* 6da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x3336, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'涯', */
	/* 6db0 */ 0,0,0x3155,0,0,0x5e3e,0,0, 0x5e41,0,0,0,0x4e43,0,0,0, /* 0,0,'液',0,0,'涵',0,0, '涸',0,0,0,'涼',0,0,0, */
	/* 6dc0 */ 0x4d64,0,0,0,0,0x5e48,0x5e42,0x5e3f, 0,0,0,0x4e54,0x5e45,0,0,0, /* '淀',0,0,0,0,'淅','淆','淇', 0,0,0,'淋','淌',0,0,0, */
	/* 6dd0 */ 0,0x3d4a,0x5e47,0,0,0x5e4c,0,0, 0x4571,0x5e4a,0,0,0,0,0x5e44,0, /* 0,'淑','淒',0,0,'淕',0,0, '淘','淙',0,0,0,0,'淞',0, */
	/* 6de0 */ 0,0x4338,0,0,0x5e4b,0,0x5e40,0, 0x5e46,0,0x5e4d,0x307c,0x5e43,0,0x5e4e,0, /* 0,'淡',0,0,'淤',0,'淦',0, '淨',0,'淪','淫','淬',0,'淮',0, */
	/* 6df0 */ 0,0x3f3c,0,0x3d5f,0,0x4a25,0,0x3a2e, 0,0x5e3b,0x5e49,0x453a,0,0,0,0, /* 0,'深',0,'淳',0,'淵',0,'混', 0,'淹','淺','添',0,0,0,0, */
	/* 6e00 */ 0,0,0,0,0,0x4036,0,0x3369, 0x3a51,0x3e44,0x5e3d,0x3d42,0,0,0,0, /* 0,0,0,0,0,'清',0,'渇', '済','渉','渊','渋',0,0,0,0, */
	/* 6e10 */ 0,0,0,0x374c,0,0x5e3c,0,0, 0,0x5e52,0x3d6d,0x383a,0,0x5e61,0,0x5e5b, /* 0,0,0,'渓',0,'渕',0,0, 0,'渙','渚','減',0,'渝',0,'渟', */
	/* 6e20 */ 0x3574,0x454f,0,0x5e56,0x5e5f,0x302f,0x3132,0, 0,0x3239,0,0x5e58,0x422c,0x5e4f,0x5e51,0x3941, /* '渠','渡',0,'渣','渤','渥','渦',0, 0,'温',0,'渫','測','渭','渮','港', */
	/* 6e30 */ 0,0,0,0,0,0,0,0, 0x5e62,0,0x5e5d,0,0,0,0x5e55,0, /* 0,0,0,0,0,0,0,0, '游',0,'渺',0,0,0,'渾',0, */
	/* 6e40 */ 0,0,0,0x5e5c,0,0,0,0, 0,0,0x4c2b,0,0,0x5e5a,0x5e5e,0, /* 0,0,0,'湃',0,0,0,0, 0,0,'湊',0,0,'湍','湎',0, */
	/* 6e50 */ 0,0,0,0,0,0,0x3850,0, 0x3e45,0,0,0x4339,0,0,0,0x5e54, /* 0,0,0,0,0,0,'湖',0, '湘',0,0,'湛',0,0,0,'湟', */
	/* 6e60 */ 0,0,0,0,0,0,0,0x4d2f, 0,0,0,0x5e57,0,0,0x5e50,0x4572, /* 0,0,0,0,0,0,0,'湧', 0,0,0,'湫',0,0,'湮','湯', */
	/* 6e70 */ 0,0,0x5e53,0,0,0,0x5e59,0, 0,0,0,0,0,0,0x4f51,0x3c3e, /* 0,0,'湲',0,0,0,'湶',0, 0,0,0,0,0,0,'湾','湿', */
	/* 6e80 */ 0x4b7e,0,0x5e63,0,0,0,0,0, 0,0,0,0,0x482e,0,0,0x5e6f, /* '満',0,'溂',0,0,0,0,0, 0,0,0,0,'溌',0,0,'溏', */
	/* 6e90 */ 0x383b,0,0,0,0,0,0x3d60,0, 0x5e65,0,0,0,0x4e2f,0x3942,0,0x5e72, /* '源',0,0,0,0,0,'準',0, '溘',0,0,0,'溜','溝',0,'溟', */
	/* 6ea0 */ 0,0,0x306e,0,0,0x5e70,0,0, 0,0,0x5e64,0,0,0,0,0x5e6a, /* 0,0,'溢',0,0,'溥',0,0, 0,0,'溪',0,0,0,0,'溯', */
	/* 6eb0 */ 0,0,0x5e6c,0,0,0,0x4d4f,0x5e67, 0,0,0x452e,0,0,0x5e69,0,0, /* 0,0,'溲',0,0,0,'溶','溷', 0,0,'溺',0,0,'溽',0,0, */
	/* 6ec0 */ 0,0,0x5e71,0,0x5e6b,0x4c47,0,0, 0,0x5e66,0,0x3c22,0x5e7e,0,0,0, /* 0,0,'滂',0,'滄','滅',0,0, 0,'滉',0,'滋','滌',0,0,0, */
	/* 6ed0 */ 0,0x336a,0,0x5e68,0x5e6d,0x5e6e,0,0, 0,0,0,0,0,0x426c,0x425a,0, /* 0,'滑',0,'滓','滔','滕',0,0, 0,0,0,0,0,'滝','滞',0, */
	/* 6ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x5e76,0,0,0x5e7c, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'滬',0,0,'滯', */
	/* 6ef0 */ 0,0,0x5e7a,0,0x4529,0,0,0x5f23, 0x5e77,0,0,0,0,0,0x5e78,0x5e60, /* 0,0,'滲',0,'滴',0,0,'滷', '滸',0,0,0,0,0,'滾','滿', */
	/* 6f00 */ 0,0x3579,0x493a,0,0,0,0x3c3f,0, 0,0x3977,0,0,0,0,0,0x4f33, /* 0,'漁','漂',0,0,0,'漆',0, 0,'漉',0,0,0,0,0,'漏', */
	/* 6f10 */ 0,0x5e74,0,0x5f22,0x3169,0x4166,0,0, 0,0,0,0,0,0,0,0, /* 0,'漑',0,'漓','演','漕',0,0, 0,0,0,0,0,0,0,0, */
	/* 6f20 */ 0x4779,0,0x3441,0x4e7a,0,0,0,0, 0,0,0,0x4c21,0x4452,0,0,0, /* '漠',0,'漢','漣',0,0,0,0, 0,0,0,'漫','漬',0,0,0, */
	/* 6f30 */ 0,0x5e7b,0x5e7d,0,0,0,0,0, 0x4132,0,0,0,0,0,0x5f21,0x5e79, /* 0,'漱','漲',0,0,0,0,0, '漸',0,0,0,0,0,'漾','漿', */
	/* 6f40 */ 0,0x5e73,0,0,0,0x3443,0,0, 0,0,0,0,0,0,0,0, /* 0,'潁',0,0,0,'潅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6f50 */ 0,0,0,0,0x3769,0,0,0, 0x5f2f,0,0,0x5f2a,0x4078,0,0,0x3363, /* 0,0,0,0,'潔',0,0,0, '潘',0,0,'潛','潜',0,0,'潟', */
	/* 6f60 */ 0,0,0,0,0x3d61,0,0x5f33,0, 0,0,0,0,0,0x5f2c,0x442c,0x5f29, /* 0,0,0,0,'潤',0,'潦',0, 0,0,0,0,0,'潭','潮','潯', */
	/* 6f70 */ 0x4459,0,0,0,0x5f4c,0,0,0, 0x5f26,0,0x5f25,0,0x5f2e,0,0,0, /* '潰',0,0,0,'潴',0,0,0, '潸',0,'潺',0,'潼',0,0,0, */
	/* 6f80 */ 0x5f28,0x5f27,0x5f2d,0,0x4021,0,0x5f24,0, 0,0,0,0,0,0,0x5f30,0, /* '澀','澁','澂',0,'澄',0,'澆',0, 0,0,0,0,0,0,'澎',0, */
	/* 6f90 */ 0,0x5f31,0,0,0,0,0,0x3442, 0,0,0,0,0,0,0,0, /* 0,'澑',0,0,0,0,0,'澗', 0,0,0,0,0,0,0,0, */
	/* 6fa0 */ 0,0x5f36,0,0x5f35,0x5f37,0,0,0, 0,0,0x5f3a,0,0,0,0,0, /* 0,'澡',0,'澣','澤',0,0,0, 0,0,'澪',0,0,0,0,0, */
	/* 6fb0 */ 0,0x4543,0,0x5f34,0,0,0,0, 0,0x5f38,0,0,0,0,0,0, /* 0,'澱',0,'澳',0,0,0,0, 0,'澹',0,0,0,0,0,0, */
	/* 6fc0 */ 0x3763,0x4279,0x5f32,0x473b,0,0,0x5f39,0, 0,0,0,0,0,0,0,0, /* '激','濁','濂','濃',0,0,'濆',0, 0,0,0,0,0,0,0,0, */
	/* 6fd0 */ 0,0,0,0,0x5f3e,0x5f3c,0,0, 0x5f3f,0,0,0x5f42,0,0,0,0x5f3b, /* 0,0,0,0,'濔','濕',0,0, '濘',0,0,'濛',0,0,0,'濟', */
	/* 6fe0 */ 0x396a,0x4728,0,0,0x5e39,0,0,0, 0,0,0,0x4d74,0x5f3d,0,0x5f41,0x4275, /* '濠','濡',0,0,'濤',0,0,0, 0,0,0,'濫','濬',0,'濮','濯', */
	/* 6ff0 */ 0,0x5f40,0,0x5f2b,0,0,0x6f69,0, 0,0,0x5f45,0,0,0,0x5f49,0, /* 0,'濱',0,'濳',0,0,'濶',0, 0,0,'濺',0,0,0,'濾',0, */
	/* 7000 */ 0,0x5f47,0,0,0,0,0,0, 0,0x5f43,0,0x5f44,0,0,0,0x5f48, /* 0,'瀁',0,0,0,0,0,0, 0,'瀉',0,'瀋',0,0,0,'瀏', */
	/* 7010 */ 0,0x5f46,0,0,0,0x494e,0,0, 0x5f4e,0,0x5f4b,0x5f4a,0,0x5f4d,0x4654,0x5f4f, /* 0,'瀑',0,0,0,'瀕',0,0, '瀘',0,'瀚','瀛',0,'瀝','瀞','瀟', */
	/* 7020 */ 0,0,0,0,0,0,0x4375,0x426d, 0,0,0,0,0x4025,0,0,0, /* 0,0,0,0,0,0,'瀦','瀧', 0,0,0,0,'瀬',0,0,0, */
	/* 7030 */ 0x5f50,0,0x5f52,0,0,0,0,0, 0,0,0,0,0,0,0x5f51,0, /* '瀰',0,'瀲',0,0,0,0,0, 0,0,0,0,0,0,'瀾',0, */
	/* 7040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x5e75,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'灌',0,0,0, */
	/* 7050 */ 0,0x5f53,0,0,0,0,0,0, 0x4667,0,0,0,0,0,0,0, /* 0,'灑',0,0,0,0,0,0, '灘',0,0,0,0,0,0,0, */
	/* 7060 */ 0,0,0,0x5f54,0,0,0,0, 0,0,0,0x3250,0,0,0,0x4574, /* 0,0,0,'灣',0,0,0,0, 0,0,0,'火',0,0,0,'灯', */
	/* 7070 */ 0x3325,0,0,0,0,0,0,0, 0x3564,0,0,0,0x3c5e,0x3a52,0,0, /* '灰',0,0,0,0,0,0,0, '灸',0,0,0,'灼','災',0,0, */
	/* 7080 */ 0,0,0,0,0,0,0,0, 0,0x4f27,0x3f66,0,0,0,0x316a,0, /* 0,0,0,0,0,0,0,0, 0,'炉','炊',0,0,0,'炎',0, */
	/* 7090 */ 0,0,0x5f56,0,0,0,0,0, 0,0x5f55,0,0,0,0,0,0, /* 0,0,'炒',0,0,0,0,0, 0,'炙',0,0,0,0,0,0, */
	/* 70a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x5f59,0x433a,0x5f5c,0x5f57, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'炬','炭','炮','炯', */
	/* 70b0 */ 0,0,0,0x5f5b,0,0,0,0, 0x5f5a,0x4540,0x3059,0,0,0,0,0, /* 0,0,0,'炳',0,0,0,0, '炸','点','為',0,0,0,0,0, */
	/* 70c0 */ 0,0,0,0,0,0,0,0, 0x4e75,0,0,0x5f5e,0,0,0,0x3128, /* 0,0,0,0,0,0,0,0, '烈',0,0,'烋',0,0,0,'烏', */
	/* 70d0 */ 0,0,0,0,0,0,0,0, 0,0x5f60,0,0,0,0x5f5f,0,0x5f5d, /* 0,0,0,0,0,0,0,0, 0,'烙',0,0,0,'烝',0,'烟', */
	/* 70e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 70f0 */ 0,0x5f58,0,0,0,0,0,0, 0,0x4b23,0,0,0,0x5f62,0,0, /* 0,'烱',0,0,0,0,0,0, 0,'烹',0,0,0,'烽',0,0, */
	/* 7100 */ 0,0,0,0,0,0,0,0, 0,0x5f61,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'焉',0,0,0,0,0,0, */
	/* 7110 */ 0,0,0,0,0x316b,0,0,0, 0,0x5f64,0x4a32,0,0x5f63,0,0,0, /* 0,0,0,0,'焔',0,0,0, 0,'焙','焚',0,'焜',0,0,0, */
	/* 7120 */ 0,0x4c35,0,0,0,0,0x3e47,0, 0,0,0,0,0,0,0,0, /* 0,'無',0,0,0,0,'焦',0, 0,0,0,0,0,0,0,0, */
	/* 7130 */ 0,0,0,0,0,0,0x4133,0, 0,0,0,0,0x3e46,0,0,0, /* 0,0,0,0,0,0,'然',0, 0,0,0,0,'焼',0,0,0, */
	/* 7140 */ 0,0,0,0,0,0,0,0, 0,0x4e7b,0,0,0x5f6a,0,0x4079,0, /* 0,0,0,0,0,0,0,0, 0,'煉',0,0,'煌',0,'煎',0, */
	/* 7150 */ 0,0,0,0,0,0x5f66,0x5f6b,0, 0,0x316c,0,0,0,0,0,0, /* 0,0,0,0,0,'煕','煖',0, 0,'煙',0,0,0,0,0,0, */
	/* 7160 */ 0,0,0x5f69,0,0x4761,0x5f65,0x5f68,0x3e48, 0,0x4851,0,0,0x5f6c,0,0x3c51,0, /* 0,0,'煢',0,'煤','煥','煦','照', 0,'煩',0,0,'煬',0,'煮',0, */
	/* 7170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x407a,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'煽',0,0, */
	/* 7180 */ 0,0,0,0,0x5f6f,0,0,0, 0x5f67,0,0x3727,0,0,0,0,0x5f6d, /* 0,0,0,0,'熄',0,0,0, '熈',0,'熊',0,0,0,0,'熏', */
	/* 7190 */ 0,0,0,0,0x4d50,0x5f70,0,0, 0,0x7426,0,0,0,0,0,0x3d4f, /* 0,0,0,0,'熔','熕',0,0, 0,'熙',0,0,0,0,0,'熟', */
	/* 71a0 */ 0,0,0,0,0,0,0,0, 0x5f71,0,0,0,0x5f72,0,0,0, /* 0,0,0,0,0,0,0,0, '熨',0,0,0,'熬',0,0,0, */
	/* 71b0 */ 0,0x472e,0,0,0,0,0,0, 0,0x5f74,0,0,0,0,0x5f75,0, /* 0,'熱',0,0,0,0,0,0, 0,'熹',0,0,0,0,'熾',0, */
	/* 71c0 */ 0,0,0,0x4733,0,0,0,0, 0x4575,0x5f77,0,0,0,0,0x5f79,0, /* 0,0,0,'燃',0,0,0,0, '燈','燉',0,0,0,0,'燎',0, */
	/* 71d0 */ 0x4e55,0,0x5f76,0,0x5f78,0x316d,0,0x5f73, 0,0,0,0,0,0,0,0x535b, /* '燐',0,'燒',0,'燔','燕',0,'燗', 0,0,0,0,0,0,0,'營', */
	/* 71e0 */ 0x5f7a,0,0,0,0,0x4167,0x3b38,0x5f7c, 0,0,0,0,0x5f7b,0x3f24,0x5259,0, /* '燠',0,0,0,0,'燥','燦','燧', 0,0,0,0,'燬','燭','燮',0, */
	/* 71f0 */ 0,0,0,0,0,0x5f7d,0,0, 0,0x6021,0,0x5f6e,0x5f7e,0,0,0x6022, /* 0,0,0,0,0,'燵',0,0, 0,'燹',0,'燻','燼',0,0,'燿', */
	/* 7200 */ 0,0,0,0,0,0,0x477a,0, 0,0,0,0,0,0x6023,0,0, /* 0,0,0,0,0,0,'爆',0, 0,0,0,0,0,'爍',0,0, */
	/* 7210 */ 0x6024,0,0,0,0,0,0,0, 0,0,0,0x6025,0,0,0,0, /* '爐',0,0,0,0,0,0,0, 0,0,0,'爛',0,0,0,0, */
	/* 7220 */ 0,0,0,0,0,0,0,0, 0x6026,0,0x445e,0,0x6028,0x6027,0,0, /* 0,0,0,0,0,0,0,0, '爨',0,'爪',0,'爬','爭',0,0, */
	/* 7230 */ 0x6029,0,0x602a,0,0,0x3c5f,0x4963,0, 0,0,0x4c6c,0x602b,0x602c,0x4156,0x3c24,0x602d, /* '爰',0,'爲',0,0,'爵','父',0, 0,0,'爺','爻','爼','爽','爾','爿', */
	/* 7240 */ 0x602e,0,0,0,0,0,0x602f,0x4a52, 0x4847,0,0,0x6030,0x4757,0,0,0, /* '牀',0,0,0,0,0,'牆','片', '版',0,0,'牋','牌',0,0,0, */
	/* 7250 */ 0,0,0x442d,0,0,0,0,0, 0x6031,0x3267,0,0x356d,0,0x4c46,0,0x4c36, /* 0,0,'牒',0,0,0,0,0, '牘','牙',0,'牛',0,'牝',0,'牟', */
	/* 7260 */ 0,0x3234,0x4f34,0,0,0,0,0x4b52, 0,0x4a2a,0,0,0,0,0,0, /* 0,'牡','牢',0,0,0,0,'牧', 0,'物',0,0,0,0,0,0, */
	/* 7270 */ 0,0,0x4037,0,0x6032,0,0,0, 0,0x4643,0,0,0,0x3823,0x6033,0, /* 0,0,'牲',0,'牴',0,0,0, 0,'特',0,0,0,'牽','牾',0, */
	/* 7280 */ 0x3a54,0x6035,0x6034,0,0,0,0,0x6036, 0,0,0,0,0,0,0,0, /* '犀','犁','犂',0,0,0,0,'犇', 0,0,0,0,0,0,0,0, */
	/* 7290 */ 0,0,0x6037,0,0,0,0x6038,0, 0,0,0,0,0,0,0,0, /* 0,0,'犒',0,0,0,'犖',0, 0,0,0,0,0,0,0,0, */
	/* 72a0 */ 0x353e,0,0x6039,0,0,0,0,0x603a, 0,0,0,0,0x3824,0,0,0x4848, /* '犠',0,'犢',0,0,0,0,'犧', 0,0,0,0,'犬',0,0,'犯', */
	/* 72b0 */ 0,0,0x603c,0,0,0,0x3e75,0, 0,0x603b,0,0,0,0,0,0, /* 0,0,'犲',0,0,0,'状',0, 0,'犹',0,0,0,0,0,0, */
	/* 72c0 */ 0,0,0x3638,0x603d,0x603f,0,0x603e,0, 0,0,0,0,0,0,0x6040,0, /* 0,0,'狂','狃','狄',0,'狆',0, 0,0,0,0,0,0,'狎',0, */
	/* 72d0 */ 0x3851,0,0x6041,0,0,0,0,0x3669, 0,0x4140,0,0x397d,0,0,0,0, /* '狐',0,'狒',0,0,0,0,'狗', 0,'狙',0,'狛',0,0,0,0, */
	/* 72e0 */ 0x6043,0x6044,0x6042,0,0,0,0,0, 0,0x3c6d,0,0,0x4648,0x3639,0,0, /* '狠','狡','狢',0,0,0,0,0, 0,'狩',0,0,'独','狭',0,0, */
	/* 72f0 */ 0,0,0,0,0,0,0,0x6046, 0x432c,0x6045,0,0,0x4f35,0x4762,0,0, /* 0,0,0,0,0,0,0,'狷', '狸','狹',0,0,'狼','狽',0,0, */
	/* 7300 */ 0,0,0,0,0,0,0,0, 0,0,0x6049,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'猊',0,0,0,0,0, */
	/* 7310 */ 0,0,0,0,0,0,0x604b,0x6048, 0,0,0,0x4c54,0x604a,0x604c,0,0x4e44, /* 0,0,0,0,0,0,'猖','猗', 0,0,0,'猛','猜','猝',0,'猟', */
	/* 7320 */ 0,0,0,0,0,0x6050,0,0, 0,0x604f,0x4376,0x472d,0,0,0x3825,0x604e, /* 0,0,0,0,0,'猥',0,0, 0,'猩','猪','猫',0,0,'献','猯', */
	/* 7330 */ 0,0,0,0,0x604d,0,0x4d31,0x4d32, 0,0,0,0,0,0,0x6051,0x316e, /* 0,0,0,0,'猴',0,'猶','猷', 0,0,0,0,0,0,'猾','猿', */
	/* 7340 */ 0,0,0,0,0x3976,0x3b62,0,0, 0,0,0,0,0,0,0x6052,0x6053, /* 0,0,0,0,'獄','獅',0,0, 0,0,0,0,0,0,'獎','獏', */
	/* 7350 */ 0,0,0,0,0,0,0,0x6055, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'獗', 0,0,0,0,0,0,0,0, */
	/* 7360 */ 0,0,0,0x3d43,0,0,0,0, 0x6057,0,0x6056,0,0,0,0,0, /* 0,0,0,'獣',0,0,0,0, '獨',0,'獪',0,0,0,0,0, */
	/* 7370 */ 0x6058,0,0x334d,0,0,0x605a,0,0, 0x6059,0,0x605c,0x605b,0,0,0,0, /* '獰',0,'獲',0,0,'獵',0,0, '獸',0,'獺','獻',0,0,0,0, */
	/* 7380 */ 0,0,0,0,0x383c,0,0,0x4e28, 0,0x364c,0,0x3226,0,0,0,0, /* 0,0,0,0,'玄',0,0,'率', 0,'玉',0,'王',0,0,0,0, */
	/* 7390 */ 0,0,0,0,0,0,0x366a,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'玖',0, 0,0,0,0,0,0,0,0, */
	/* 73a0 */ 0,0,0,0,0,0,0,0, 0,0x3461,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'玩',0,0,0,0,0,0, */
	/* 73b0 */ 0,0,0x4e68,0x605e,0,0,0,0, 0,0,0,0x6060,0,0,0,0, /* 0,0,'玲','玳',0,0,0,0, 0,0,0,'玻',0,0,0,0, */
	/* 73c0 */ 0x6061,0,0x3251,0,0,0,0,0, 0x605d,0,0x3b39,0,0,0x4441,0x605f,0, /* '珀',0,'珂',0,0,0,0,0, '珈',0,'珊',0,0,'珍','珎',0, */
	/* 73d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x6064,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'珞',0, */
	/* 73e0 */ 0x3c6e,0,0,0,0,0x6062,0,0, 0,0,0x373e,0,0,0x4849,0x6063,0, /* '珠',0,0,0,0,'珥',0,0, 0,0,'珪',0,0,'班','珮',0, */
	/* 73f0 */ 0,0x607e,0,0,0,0,0,0, 0x6069,0,0,0,0,0,0x383d,0, /* 0,'珱',0,0,0,0,0,0, '珸',0,0,0,0,0,'現',0, */
	/* 7400 */ 0,0,0,0x3565,0,0x6066,0x4d7d,0, 0,0x4e30,0,0,0,0,0,0, /* 0,0,0,'球',0,'琅','理',0, 0,'琉',0,0,0,0,0,0, */
	/* 7410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7420 */ 0,0,0x4276,0,0,0x6068,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'琢',0,0,'琥',0,0, 0,0,0,0,0,0,0,0, */
	/* 7430 */ 0,0,0x606a,0x4e56,0x3657,0x487c,0x474a,0, 0,0,0x606b,0,0,0,0,0x606d, /* 0,0,'琲','琳','琴','琵','琶',0, 0,0,'琺',0,0,0,0,'琿', */
	/* 7440 */ 0,0x6070,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'瑁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7450 */ 0,0,0,0,0,0x606c,0,0, 0,0x606f,0x386a,0x314d,0x6071,0,0x3f70,0x606e, /* 0,0,0,0,0,'瑕',0,0, 0,'瑙','瑚','瑛','瑜',0,'瑞','瑟', */
	/* 7460 */ 0x4e5c,0,0,0x6074,0x7424,0,0,0, 0,0x6072,0x6075,0,0,0,0,0x6067, /* '瑠',0,0,'瑣','瑤',0,0,0, 0,'瑩','瑪',0,0,0,0,'瑯', */
	/* 7470 */ 0x6073,0,0,0x3a3c,0,0,0x6076,0, 0,0,0,0,0,0,0x6077,0, /* '瑰',0,0,'瑳',0,0,'瑶',0, 0,0,0,0,0,0,'瑾',0, */
	/* 7480 */ 0,0,0,0x4d7e,0,0,0,0, 0,0,0,0x6078,0,0,0,0, /* 0,0,0,'璃',0,0,0,0, 0,0,0,'璋',0,0,0,0, */
	/* 7490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x6079,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'璞',0, */
	/* 74a0 */ 0,0,0x6065,0,0,0,0,0x607a, 0,0,0,0,0,0,0,0, /* 0,0,'璢',0,0,0,0,'璧', 0,0,0,0,0,0,0,0, */
	/* 74b0 */ 0x3444,0,0,0,0,0,0,0, 0,0,0,0,0,0x3c25,0,0, /* '環',0,0,0,0,0,0,0, 0,0,0,0,0,'璽',0,0, */
	/* 74c0 */ 0,0,0,0,0,0,0,0, 0,0,0x607b,0,0,0,0,0x607c, /* 0,0,0,0,0,0,0,0, 0,0,'瓊',0,0,0,0,'瓏', */
	/* 74d0 */ 0,0,0,0,0x607d,0,0,0, 0,0,0,0,0x313b,0,0,0, /* 0,0,0,0,'瓔',0,0,0, 0,0,0,0,'瓜',0,0,0, */
	/* 74e0 */ 0x6121,0,0x493b,0x6122,0,0,0x3424,0x6123, 0,0x6124,0,0,0,0,0x6125,0, /* '瓠',0,'瓢','瓣',0,0,'瓦','瓧', 0,'瓩',0,0,0,0,'瓮',0, */
	/* 74f0 */ 0x6127,0x6128,0x6126,0,0,0,0x4953,0x612a, 0x6129,0,0,0,0,0,0,0, /* '瓰','瓱','瓲',0,0,0,'瓶','瓷', '瓸',0,0,0,0,0,0,0, */
	/* 7500 */ 0,0,0,0x612c,0x612b,0x612d,0,0, 0,0,0,0,0x612e,0x6130,0x612f,0, /* 0,0,0,'甃','甄','甅',0,0, 0,0,0,0,'甌','甍','甎',0, */
	/* 7510 */ 0,0x3979,0,0x6132,0,0x6131,0,0, 0x3445,0,0x3f53,0,0x453c,0,0x6133,0x4038, /* 0,'甑',0,'甓',0,'甕',0,0, '甘',0,'甚',0,'甜',0,'甞','生', */
	/* 7520 */ 0,0,0,0x3b3a,0,0x3179,0x6134,0, 0x4d51,0,0,0x4a63,0x6135,0,0,0, /* 0,0,0,'産',0,'甥','甦',0, '用',0,0,'甫','甬',0,0,0, */
	/* 7530 */ 0x4544,0x4d33,0x3943,0x3f3d,0,0,0,0x434b, 0x5234,0,0x442e,0x3268,0x6136,0,0,0, /* '田','由','甲','申',0,0,0,'男', '甸',0,'町','画','甼',0,0,0, */
	/* 7540 */ 0,0,0,0,0x6137,0,0x613c,0, 0,0x613a,0x6139,0x5a42,0x3326,0x6138,0,0x305a, /* 0,0,0,0,'畄',0,'畆',0, 0,'畉','畊','畋','界','畍',0,'畏', */
	/* 7550 */ 0,0x482a,0,0,0x484a,0,0,0, 0,0x4e31,0x613d,0x613b,0x435c,0x4026,0,0, /* 0,'畑',0,0,'畔',0,0,0, 0,'留','畚','畛','畜','畝',0,0, */
	/* 7560 */ 0x482b,0,0x492d,0,0x613f,0x4e2c,0x374d,0x6140, 0,0x613e,0x4856,0x6141,0,0x6142,0,0, /* '畠',0,'畢',0,'畤','略','畦','畧', 0,'畩','番','畫',0,'畭',0,0, */
	/* 7570 */ 0x305b,0,0,0x3e76,0x6147,0,0x6144,0x466d, 0x6143,0,0,0,0,0,0,0x3526, /* '異',0,0,'畳','畴',0,'當','畷', '畸',0,0,0,0,0,0,'畿', */
	/* 7580 */ 0,0,0x614a,0,0,0,0x6145,0x6146, 0,0x6149,0x6148,0x4925,0,0,0x4142,0x4141, /* 0,0,'疂',0,0,0,'疆','疇', 0,'疉','疊','疋',0,0,'疎','疏', */
	/* 7590 */ 0,0x353f,0,0,0x614b,0,0,0, 0,0,0x614c,0,0,0x614d,0,0, /* 0,'疑',0,0,'疔',0,0,0, 0,0,'疚',0,0,'疝',0,0, */
	/* 75a0 */ 0,0,0,0x614f,0,0x614e,0,0, 0,0,0,0x3156,0,0,0,0, /* 0,0,0,'疣',0,'疥',0,0, 0,0,0,'疫',0,0,0,0, */
	/* 75b0 */ 0,0x6157,0x4868,0x6151,0,0x6153,0,0, 0x6155,0x3f3e,0,0,0x6156,0x6154,0x3c40,0, /* 0,'疱','疲','疳',0,'疵',0,0, '疸','疹',0,0,'疼','疽','疾',0, */
	/* 75c0 */ 0,0,0x6150,0x6152,0,0x4942,0,0x3e49, 0,0,0x6159,0,0,0x6158,0,0, /* 0,0,'痂','痃',0,'病',0,'症', 0,0,'痊',0,0,'痍',0,0, */
	/* 75d0 */ 0,0,0x615a,0,0x3c26,0x3a2f,0,0, 0x4577,0x615b,0,0x444b,0,0,0x615d,0, /* 0,0,'痒',0,'痔','痕',0,0, '痘','痙',0,'痛',0,0,'痞',0, */
	/* 75e0 */ 0,0,0x4e21,0x615c,0,0,0,0, 0,0x4169,0,0,0,0,0,0, /* 0,0,'痢','痣',0,0,0,0, 0,'痩',0,0,0,0,0,0, */
	/* 75f0 */ 0x6162,0,0x6164,0x6165,0x4354,0,0,0, 0,0,0x6163,0,0x6160,0,0x615e,0x615f, /* '痰',0,'痲','痳','痴',0,0,0, 0,0,'痺',0,'痼',0,'痾','痿', */
	/* 7600 */ 0,0x6161,0,0,0,0,0,0, 0,0x6168,0,0x6166,0,0x6167,0,0, /* 0,'瘁',0,0,0,0,0,0, 0,'瘉',0,'瘋',0,'瘍',0,0, */
	/* 7610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x6169, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'瘟', */
	/* 7620 */ 0x616b,0x616c,0x616d,0,0x616e,0,0,0x616a, 0,0,0,0,0,0,0,0, /* '瘠','瘡','瘢',0,'瘤',0,0,'瘧', 0,0,0,0,0,0,0,0, */
	/* 7630 */ 0x6170,0,0,0,0x616f,0,0,0, 0,0,0,0x6171,0,0,0,0, /* '瘰',0,0,0,'瘴',0,0,0, 0,0,0,'瘻',0,0,0,0, */
	/* 7640 */ 0,0,0x4e45,0,0,0,0x6174,0x6172, 0x6173,0,0,0,0x3462,0,0,0, /* 0,0,'療',0,0,0,'癆','癇', '癈',0,0,0,'癌',0,0,0, */
	/* 7650 */ 0,0,0x4c7e,0,0,0,0x4a4a,0, 0x6176,0,0,0,0x6175,0,0,0, /* 0,0,'癒',0,0,0,'癖',0, '癘',0,0,0,'癜',0,0,0, */
	/* 7660 */ 0,0x6177,0x6178,0,0,0,0,0x617c, 0x6179,0x617a,0x617b,0,0x617d,0,0,0, /* 0,'癡','癢',0,0,0,0,'癧', '癨','癩','癪',0,'癬',0,0,0, */
	/* 7670 */ 0x617e,0,0x6221,0,0,0,0x6222,0, 0x6223,0,0x482f,0x4550,0x6224,0x4772,0x4934,0, /* '癰',0,'癲',0,0,0,'癶',0, '癸',0,'発','登','發','白','百',0, */
	/* 7680 */ 0x6225,0,0,0x6226,0x452a,0,0x3327,0x3944, 0x6227,0,0,0x6228,0,0,0x6229,0, /* '皀',0,0,'皃','的',0,'皆','皇', '皈',0,0,'皋',0,0,'皎',0, */
	/* 7690 */ 0x3b29,0,0,0x622b,0,0,0x622a,0, 0,0x622c,0x622d,0,0,0,0,0, /* '皐',0,0,'皓',0,0,'皖',0, 0,'皙','皚',0,0,0,0,0, */
	/* 76a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x4869,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'皮',0, */
	/* 76b0 */ 0x622e,0,0,0,0x622f,0,0,0x7369, 0x6230,0x6231,0x6232,0,0,0,0,0x3b2e, /* '皰',0,0,0,'皴',0,0,'皷', '皸','皹','皺',0,0,0,0,'皿', */
	/* 76c0 */ 0,0,0x6233,0x4756,0,0,0x4b5f,0, 0x314e,0,0x3157,0,0,0x6234,0,0, /* 0,0,'盂','盃',0,0,'盆',0, '盈',0,'益',0,0,'盍',0,0, */
	/* 76d0 */ 0,0,0x6236,0,0,0,0x6235,0x4570, 0,0,0,0x4039,0x5d39,0,0x6237,0x4c41, /* 0,0,'盒',0,0,0,'盖','盗', 0,0,0,'盛','盜',0,'盞','盟', */
	/* 76e0 */ 0,0x6238,0,0x3446,0x4857,0x6239,0,0x623a, 0,0,0x623b,0,0,0,0x4c5c,0, /* 0,'盡',0,'監','盤','盥',0,'盧', 0,0,'盪',0,0,0,'目',0, */
	/* 76f0 */ 0,0,0x4c55,0,0x443e,0,0,0, 0x416a,0,0,0x623d,0,0,0x3d62,0, /* 0,0,'盲',0,'直',0,0,0, '相',0,0,'盻',0,0,'盾',0, */
	/* 7700 */ 0,0x3e4a,0,0,0x6240,0,0,0x623f, 0x623e,0x487d,0,0x3447,0x3829,0,0,0, /* 0,'省',0,0,'眄',0,0,'眇', '眈','眉',0,'看','県',0,0,0, */
	/* 7710 */ 0,0,0,0,0,0,0,0, 0,0,0,0x6246,0,0,0x6243,0x3f3f, /* 0,0,0,0,0,0,0,0, 0,0,0,'眛',0,0,'眞','真', */
	/* 7720 */ 0x4c32,0,0,0,0x6242,0x6244,0x6245,0, 0,0x6241,0,0,0,0,0,0, /* '眠',0,0,0,'眤','眥','眦',0, 0,'眩',0,0,0,0,0,0, */
	/* 7730 */ 0,0,0,0,0,0,0,0x6247, 0x6248,0,0x442f,0,0x3463,0,0,0, /* 0,0,0,0,0,0,0,'眷', '眸',0,'眺',0,'眼',0,0,0, */
	/* 7740 */ 0x4365,0,0,0,0,0,0,0x6249, 0,0,0,0,0,0,0,0, /* '着',0,0,0,0,0,0,'睇', 0,0,0,0,0,0,0,0, */
	/* 7750 */ 0,0,0,0,0,0,0,0, 0,0,0x624a,0x624d,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'睚','睛',0,0,0,0, */
	/* 7760 */ 0,0x3f67,0,0x4644,0,0x624e,0x4b53,0, 0x624b,0,0,0x624c,0,0,0,0, /* 0,'睡',0,'督',0,'睥','睦',0, '睨',0,0,'睫',0,0,0,0, */
	/* 7770 */ 0,0,0,0,0,0,0,0, 0,0x6251,0,0,0,0,0x6250,0x624f, /* 0,0,0,0,0,0,0,0, 0,'睹',0,0,0,0,'睾','睿', */
	/* 7780 */ 0,0,0,0,0,0,0,0, 0,0,0,0x6253,0,0,0x6252,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'瞋',0,0,'瞎',0, */
	/* 7790 */ 0,0x6254,0,0,0,0,0,0, 0,0,0,0,0,0,0x6256,0, /* 0,'瞑',0,0,0,0,0,0, 0,0,0,0,0,0,'瞞',0, */
	/* 77a0 */ 0x6255,0,0,0,0,0x4a4d,0,0, 0,0,0,0,0x3d56,0x4e46,0,0, /* '瞠',0,0,0,0,'瞥',0,0, 0,0,0,0,'瞬','瞭',0,0, */
	/* 77b0 */ 0x6257,0,0,0x4637,0,0,0x6258,0, 0,0x6259,0,0x625d,0x625b,0x625c,0,0x625a, /* '瞰',0,0,'瞳',0,0,'瞶',0, 0,'瞹',0,'瞻','瞼','瞽',0,'瞿', */
	/* 77c0 */ 0,0,0,0,0,0,0,0x625e, 0,0,0,0,0,0x625f,0,0, /* 0,0,0,0,0,0,0,'矇', 0,0,0,0,0,'矍',0,0, */
	/* 77d0 */ 0,0,0,0,0,0,0,0x6260, 0,0,0x6261,0x4c37,0x6262,0,0,0, /* 0,0,0,0,0,0,0,'矗', 0,0,'矚','矛','矜',0,0,0, */
	/* 77e0 */ 0,0,0x4c70,0x6263,0,0x434e,0,0x476a, 0,0x366b,0,0,0,0x433b,0x6264,0x363a, /* 0,0,'矢','矣',0,'知',0,'矧', 0,'矩',0,0,0,'短','矮','矯', */
	/* 77f0 */ 0,0,0,0x4050,0,0,0,0, 0,0,0,0,0x6265,0,0,0, /* 0,0,0,'石',0,0,0,0, 0,0,0,0,'矼',0,0,0, */
	/* 7800 */ 0,0,0x3a3d,0,0,0,0,0, 0,0,0,0,0x6266,0,0,0, /* 0,0,'砂',0,0,0,0,0, 0,0,0,0,'砌',0,0,0, */
	/* 7810 */ 0,0,0x6267,0,0x3826,0x3a55,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'砒',0,'研','砕',0,0, 0,0,0,0,0,0,0,0, */
	/* 7820 */ 0x6269,0,0,0,0,0x4556,0x3a56,0x354e, 0,0,0,0,0,0,0,0, /* '砠',0,0,0,0,'砥','砦','砧', 0,0,0,0,0,0,0,0, */
	/* 7830 */ 0,0,0x4b24,0,0x474b,0,0,0, 0,0,0x4557,0,0,0,0,0x395c, /* 0,0,'砲',0,'破',0,0,0, 0,0,'砺',0,0,0,0,'砿', */
	/* 7840 */ 0,0,0,0,0,0x626b,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'硅',0,0, 0,0,0,0,0,0,0,0, */
	/* 7850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x3e4b,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'硝',0,0, */
	/* 7860 */ 0,0,0,0,0,0,0,0, 0,0,0,0x4e32,0x3945,0,0,0x3827, /* 0,0,0,0,0,0,0,0, 0,0,0,'硫','硬',0,0,'硯', */
	/* 7870 */ 0,0,0x4823,0,0x626d,0,0,0, 0,0,0,0,0x626f,0,0,0, /* 0,0,'硲',0,'硴',0,0,0, 0,0,0,0,'硼',0,0,0, */
	/* 7880 */ 0,0x386b,0,0,0,0,0x626e,0x4476, 0,0,0,0,0x6271,0x3337,0x626c,0, /* 0,'碁',0,0,0,0,'碆','碇', 0,0,0,0,'碌','碍','碎',0, */
	/* 7890 */ 0,0x486a,0,0x3130,0,0x3a6c,0,0x4f52, 0,0,0x6270,0,0,0,0,0, /* 0,'碑',0,'碓',0,'碕',0,'碗', 0,0,'碚',0,0,0,0,0, */
	/* 78a0 */ 0,0,0,0x6272,0,0,0,0x4a4b, 0,0x4059,0x6274,0,0,0,0,0x6275, /* 0,0,0,'碣',0,0,0,'碧', 0,'碩','碪',0,0,0,0,'碯', */
	/* 78b0 */ 0,0,0,0,0,0x6273,0,0, 0,0,0x334e,0,0x627b,0,0x627a,0, /* 0,0,0,0,0,'碵',0,0, 0,0,'確',0,'碼',0,'碾',0, */
	/* 78c0 */ 0,0x3c27,0,0,0,0x627c,0x6277,0, 0,0,0x627d,0x6278,0,0,0,0, /* 0,'磁',0,0,0,'磅','磆',0, 0,0,'磊','磋',0,0,0,0, */
	/* 78d0 */ 0x4858,0x6276,0,0,0x6279,0,0,0, 0,0,0x6322,0,0,0,0,0, /* '磐','磑',0,0,'磔',0,0,0, 0,0,'磚',0,0,0,0,0, */
	/* 78e0 */ 0,0,0,0,0,0,0,0x6321, 0x4b61,0,0,0,0x627e,0,0,0x306b, /* 0,0,0,0,0,0,0,'磧', '磨',0,0,0,'磬',0,0,'磯', */
	/* 78f0 */ 0,0,0,0,0x6324,0,0,0, 0,0,0,0,0,0x6323,0,0, /* 0,0,0,0,'磴',0,0,0, 0,0,0,0,0,'磽',0,0, */
	/* 7900 */ 0,0x3e4c,0,0,0,0,0,0x6325, 0,0,0,0,0,0,0x4143,0, /* 0,'礁',0,0,0,0,0,'礇', 0,0,0,0,0,0,'礎',0, */
	/* 7910 */ 0,0x6327,0x6326,0,0,0,0,0, 0,0x6328,0,0,0,0,0,0, /* 0,'礑','礒',0,0,0,0,0, 0,'礙',0,0,0,0,0,0, */
	/* 7920 */ 0,0,0,0,0,0,0x6268,0, 0,0,0x626a,0x632a,0x6329,0,0,0, /* 0,0,0,0,0,0,'礦',0, 0,0,'礪','礫','礬',0,0,0, */
	/* 7930 */ 0,0,0,0,0,0,0,0, 0,0,0x3c28,0,0x4e69,0,0x3c52,0, /* 0,0,0,0,0,0,0,0, 0,0,'示',0,'礼',0,'社',0, */
	/* 7940 */ 0x632b,0x3737,0,0,0,0,0,0x3540, 0x3527,0x3b63,0,0,0,0,0,0, /* '祀','祁',0,0,0,0,0,'祇', '祈','祉',0,0,0,0,0,0, */
	/* 7950 */ 0x4d34,0,0,0x6331,0,0x6330,0x4144,0x632d, 0,0,0x632f,0,0,0x3d4b,0x3f40,0x632e, /* '祐',0,0,'祓',0,'祕','祖','祗', 0,0,'祚',0,0,'祝','神','祟', */
	/* 7960 */ 0x632c,0,0x472a,0,0,0x3e4d,0,0, 0x493c,0,0,0,0,0x3a57,0,0, /* '祠',0,'祢',0,0,'祥',0,0, '票',0,0,0,0,'祭',0,0, */
	/* 7970 */ 0,0,0,0,0,0,0,0x4578, 0,0,0x6332,0,0,0,0,0x6333, /* 0,0,0,0,0,0,0,'祷', 0,0,'祺',0,0,0,0,'祿', */
	/* 7980 */ 0x6349,0x3658,0,0,0x4f3d,0x4135,0,0, 0,0,0x6334,0,0,0x3252,0x4477,0x4a21, /* '禀','禁',0,0,'禄','禅',0,0, 0,0,'禊',0,0,'禍','禎','福', */
	/* 7990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x6335,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'禝',0,0, */
	/* 79a0 */ 0,0,0,0,0,0,0x357a,0x6336, 0,0,0x6338,0,0,0,0x6339,0, /* 0,0,0,0,0,0,'禦','禧', 0,0,'禪',0,0,0,'禮',0, */
	/* 79b0 */ 0x4729,0,0,0x633a,0,0,0,0, 0,0x633b,0x633c,0,0,0x3659,0x3253,0x4645, /* '禰',0,0,'禳',0,0,0,0, 0,'禹','禺',0,0,'禽','禾','禿', */
	/* 79c0 */ 0x3d28,0x3b64,0,0,0,0,0,0, 0,0x633d,0,0x3d29,0,0,0,0, /* '秀','私',0,0,0,0,0,0, 0,'秉',0,'秋',0,0,0,0, */
	/* 79d0 */ 0,0x324a,0x4943,0,0,0x633e,0,0, 0x486b,0,0,0,0,0,0,0x4145, /* 0,'科','秒',0,0,'秕',0,0, '秘',0,0,0,0,0,0,'租', */
	/* 79e0 */ 0,0x6341,0,0x6342,0x4769,0,0x3f41,0x633f, 0,0x4361,0,0,0x6340,0,0,0, /* 0,'秡',0,'秣','秤',0,'秦','秧', 0,'秩',0,0,'秬',0,0,0, */
	/* 79f0 */ 0x3e4e,0,0,0,0,0,0,0, 0,0,0,0x305c,0,0,0,0, /* '称',0,0,0,0,0,0,0, 0,0,0,'移',0,0,0,0, */
	/* 7a00 */ 0x3529,0,0,0,0,0,0,0, 0x6343,0,0,0x4478,0,0x6344,0x4047,0, /* '稀',0,0,0,0,0,0,0, '稈',0,0,'程',0,'稍','税',0, */
	/* 7a10 */ 0,0,0,0,0x4c2d,0,0,0x4923, 0x6345,0x6346,0x4355,0,0x4e47,0,0,0x6348, /* 0,0,0,0,'稔',0,0,'稗', '稘','稙','稚',0,'稜',0,0,'稟', */
	/* 7a20 */ 0x6347,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x3c6f,0, /* '稠',0,0,0,0,0,0,0, 0,0,0,0,0,0,'種',0, */
	/* 7a30 */ 0,0x634a,0x3070,0,0,0,0,0x634d, 0,0,0,0x634b,0x3254,0x374e,0x634c,0x3946, /* 0,'稱','稲',0,0,0,0,'稷', 0,0,0,'稻','稼','稽','稾','稿', */
	/* 7a40 */ 0x3972,0,0x4a66,0x634e,0,0,0x4b54,0, 0,0x6350,0,0,0,0x4051,0x314f,0x323a, /* '穀',0,'穂','穃',0,0,'穆',0, 0,'穉',0,0,0,'積','穎','穏', */
	/* 7a50 */ 0x302c,0,0,0,0,0,0,0x634f, 0,0,0,0,0,0,0,0, /* '穐',0,0,0,0,0,0,'穗', 0,0,0,0,0,0,0,0, */
	/* 7a60 */ 0,0x6351,0x6352,0x3e77,0,0,0,0, 0,0x6353,0,0x334f,0,0,0,0, /* 0,'穡','穢','穣',0,0,0,0, 0,'穩',0,'穫',0,0,0,0, */
	/* 7a70 */ 0x6355,0,0,0,0x376a,0,0x3566,0, 0,0x6356,0x3675,0,0,0x6357,0,0x407c, /* '穰',0,0,0,'穴',0,'究',0, 0,'穹','空',0,0,'穽',0,'穿', */
	/* 7a80 */ 0,0x464d,0,0x4060,0x3a75,0,0,0, 0x6358,0,0,0,0,0,0,0, /* 0,'突',0,'窃','窄',0,0,0, '窈',0,0,0,0,0,0,0, */
	/* 7a90 */ 0,0,0x4362,0x416b,0,0x635a,0x635c,0x6359, 0x635b,0,0,0,0,0,0,0x3722, /* 0,0,'窒','窓',0,'窕','窖','窗', '窘',0,0,0,0,0,0,'窟', */
	/* 7aa0 */ 0,0,0,0,0,0,0,0, 0,0x635d,0x3726,0,0,0,0x3567,0x4d52, /* 0,0,0,0,0,0,0,0, 0,'窩','窪',0,0,0,'窮','窯', */
	/* 7ab0 */ 0x635f,0,0,0,0,0,0x6360,0, 0,0,0x312e,0,0,0,0,0x6363, /* '窰',0,0,0,0,0,'窶',0, 0,0,'窺',0,0,0,0,'窿', */
	/* 7ac0 */ 0,0,0,0x3376,0x6362,0x6361,0,0x6365, 0x635e,0,0x6366,0x4e29,0,0x6367,0,0x6368, /* 0,0,0,'竃','竄','竅',0,'竇', '竈',0,'竊','立',0,'竍',0,'竏', */
	/* 7ad0 */ 0,0,0x5474,0x636a,0,0x6369,0,0, 0,0x636b,0x636c,0,0x4e35,0x636d,0,0x706f, /* 0,0,'竒','竓',0,'竕',0,0, 0,'站','竚',0,'竜','竝',0,'竟', */
	/* 7ae0 */ 0x3e4f,0x636e,0x636f,0x3d57,0,0x4638,0x6370,0, 0,0,0x4328,0,0,0x6371,0,0x433c, /* '章','竡','竢','竣',0,'童','竦',0, 0,0,'竪',0,0,'竭',0,'端', */
	/* 7af0 */ 0x6372,0,0,0,0,0,0x3625,0, 0x513f,0x435d,0x3c33,0,0,0,0,0x3448, /* '竰',0,0,0,0,0,'競',0, '竸','竹','竺',0,0,0,0,'竿', */
	/* 7b00 */ 0,0,0x6373,0,0x6422,0,0x6376,0, 0x3568,0,0x6375,0x6424,0,0,0,0x6374, /* 0,0,'笂',0,'笄',0,'笆',0, '笈',0,'笊','笋',0,0,0,'笏', */
	/* 7b10 */ 0,0x3e50,0,0,0,0,0,0, 0x6378,0x6379,0,0x452b,0,0,0x637a,0, /* 0,'笑',0,0,0,0,0,0, '笘','笙',0,'笛',0,0,'笞',0, */
	/* 7b20 */ 0x335e,0,0,0,0,0x3f5a,0x4964,0, 0x637c,0,0,0,0x4268,0,0,0, /* '笠',0,0,0,0,'笥','符',0, '笨',0,0,0,'第',0,0,0, */
	/* 7b30 */ 0,0,0,0x6377,0,0x637b,0x637d,0, 0,0x3a7b,0,0,0,0,0,0, /* 0,0,0,'笳',0,'笵','笶',0, 0,'笹',0,0,0,0,0,0, */
	/* 7b40 */ 0,0,0,0,0,0x6426,0x492e,0, 0x4826,0x4579,0,0x365a,0x6425,0x6423,0,0x4835, /* 0,0,0,0,0,'筅','筆',0, '筈','等',0,'筋','筌','筍',0,'筏', */
	/* 7b50 */ 0x637e,0x435e,0x457b,0,0x457a,0,0x3a76,0, 0,0,0,0,0,0x6438,0,0, /* '筐','筑','筒',0,'答',0,'策',0, 0,0,0,0,0,'筝',0,0, */
	/* 7b60 */ 0,0,0,0,0,0x6428,0,0x642a, 0,0,0,0,0x642d,0,0x642e,0, /* 0,0,0,0,0,'筥',0,'筧', 0,0,0,0,'筬',0,'筮',0, */
	/* 7b70 */ 0x642b,0x642c,0,0,0x6429,0x6427,0,0, 0,0,0x6421,0,0,0,0,0, /* '筰','筱',0,0,'筴','筵',0,0, 0,0,'筺',0,0,0,0,0, */
	/* 7b80 */ 0,0,0,0,0,0,0x4a4f,0x3255, 0,0,0,0x6435,0,0x6432,0,0x6437, /* 0,0,0,0,0,0,'箆','箇', 0,0,0,'箋',0,'箍',0,'箏', */
	/* 7b90 */ 0,0,0x6436,0,0x4773,0x4c27,0,0x3b3b, 0x6430,0x6439,0x6434,0,0x6433,0x642f,0,0x6431, /* 0,0,'箒',0,'箔','箕',0,'算', '箘','箙','箚',0,'箜','箝',0,'箟', */
	/* 7ba0 */ 0,0x3449,0,0,0,0,0,0, 0,0,0x433d,0,0,0x407d,0,0, /* 0,'管',0,0,0,0,0,0, 0,0,'箪',0,0,'箭',0,0, */
	/* 7bb0 */ 0,0x4822,0,0,0x643e,0,0,0, 0x4824,0,0,0,0,0,0,0, /* 0,'箱',0,0,'箴',0,0,0, '箸',0,0,0,0,0,0,0, */
	/* 7bc0 */ 0x4061,0x643b,0,0,0x484f,0,0x643f,0x4a53, 0,0x435b,0,0x643a,0x643c,0,0,0x643d, /* '節','篁',0,0,'範',0,'篆','篇', 0,'築',0,'篋','篌',0,0,'篏', */
	/* 7bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x6440,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'篝',0,0, */
	/* 7be0 */ 0x3c44,0,0,0,0x4646,0x6445,0x6444,0, 0,0x6441,0,0,0,0x4f36,0,0, /* '篠',0,0,0,'篤','篥','篦',0, 0,'篩',0,0,0,'篭',0,0, */
	/* 7bf0 */ 0,0,0,0x644a,0,0,0x644e,0x644b, 0,0,0,0,0,0,0,0, /* 0,0,0,'篳',0,0,'篶','篷', 0,0,0,0,0,0,0,0, */
	/* 7c00 */ 0x6447,0,0,0,0,0,0,0x6448, 0,0,0,0,0,0x644d,0,0, /* '簀',0,0,0,0,0,0,'簇', 0,0,0,0,0,'簍',0,0, */
	/* 7c10 */ 0,0x6442,0x5255,0x6449,0x6443,0,0,0x644c, 0,0,0,0,0,0,0,0x6452, /* 0,'簑','簒','簓','簔',0,0,'簗', 0,0,0,0,0,0,0,'簟', */
	/* 7c20 */ 0,0x344a,0,0x644f,0,0,0,0x6450, 0,0,0x6451,0x6454,0,0,0,0, /* 0,'簡',0,'簣',0,0,0,'簧', 0,0,'簪','簫',0,0,0,0, */
	/* 7c30 */ 0,0,0,0,0,0,0,0x6453, 0x4876,0,0,0,0,0x6455,0x4e7c,0x4a6d, /* 0,0,0,0,0,0,0,'簷', '簸',0,0,0,0,'簽','簾','簿', */
	/* 7c40 */ 0x645a,0,0,0x6457,0,0,0,0, 0,0,0,0,0x6456,0x4052,0,0x6459, /* '籀',0,0,'籃',0,0,0,0, 0,0,0,0,'籌','籍',0,'籏', */
	/* 7c50 */ 0x645b,0,0,0,0x6458,0,0x645f,0, 0x645c,0,0,0,0,0,0,0x645d, /* '籐',0,0,0,'籔',0,'籖',0, '籘',0,0,0,0,0,0,'籟', */
	/* 7c60 */ 0x6446,0,0,0,0x645e,0x6460,0,0, 0,0,0,0,0x6461,0,0,0, /* '籠',0,0,0,'籤','籥',0,0, 0,0,0,0,'籬',0,0,0, */
	/* 7c70 */ 0,0,0,0x4a46,0,0x6462,0,0, 0,0,0,0,0,0,0x4c62,0, /* 0,0,0,'米',0,'籵',0,0, 0,0,0,0,0,0,'籾',0, */
	/* 7c80 */ 0,0x364e,0x3729,0x6463,0,0,0,0, 0,0x4a34,0,0x3f68,0,0x4c30,0,0, /* 0,'粁','粂','粃',0,0,0,0, 0,'粉',0,'粋',0,'粍',0,0, */
	/* 7c90 */ 0x6464,0,0x4e33,0,0,0x4774,0,0x4146, 0x4734,0,0,0x3d4d,0,0,0,0x3040, /* '粐',0,'粒',0,0,'粕',0,'粗', '粘',0,0,'粛',0,0,0,'粟', */
	/* 7ca0 */ 0,0x6469,0x6467,0,0x6465,0x3421,0,0x3e51, 0x646a,0,0,0x6468,0,0x6466,0x646e,0, /* 0,'粡','粢',0,'粤','粥',0,'粧', '粨',0,0,'粫',0,'粭','粮',0, */
	/* 7cb0 */ 0,0x646d,0x646c,0x646b,0,0,0,0, 0,0x646f,0,0,0,0x6470,0x403a,0, /* 0,'粱','粲','粳',0,0,0,0, 0,'粹',0,0,0,'粽','精',0, */
	/* 7cc0 */ 0x6471,0,0x6473,0,0,0x6472,0,0, 0,0,0x3852,0,0,0,0x4138,0, /* '糀',0,'糂',0,0,'糅',0,0, 0,0,'糊',0,0,0,'糎',0, */
	/* 7cd0 */ 0,0,0x6475,0,0,0,0x457c,0, 0x6474,0,0,0,0x6476,0,0x4a35,0x416c, /* 0,0,'糒',0,0,0,'糖',0, '糘',0,0,0,'糜',0,'糞','糟', */
	/* 7ce0 */ 0x3947,0,0x6477,0,0,0,0,0x4e48, 0,0,0,0,0,0,0,0x6479, /* '糠',0,'糢',0,0,0,0,'糧', 0,0,0,0,0,0,0,'糯', */
	/* 7cf0 */ 0,0,0x647a,0,0x647b,0,0x647c,0, 0x3b65,0,0x647d,0x374f,0,0,0x356a,0, /* 0,0,'糲',0,'糴',0,'糶',0, '糸',0,'糺','系',0,0,'糾',0, */
	/* 7d00 */ 0x352a,0,0x6521,0,0x4c73,0x3948,0x647e,0, 0,0,0x6524,0x4c66,0,0x473c,0,0, /* '紀',0,'紂',0,'約','紅','紆',0, 0,0,'紊','紋',0,'納',0,0, */
	/* 7d10 */ 0x4933,0,0,0,0x3d63,0x6523,0,0x3c53, 0x3949,0x3b66,0x3569,0x4a36,0x6522,0,0,0, /* '紐',0,0,0,'純','紕',0,'紗', '紘','紙','級','紛','紜',0,0,0, */
	/* 7d20 */ 0x4147,0x4b42,0x3a77,0,0,0,0,0, 0,0,0,0x3b67,0x445d,0,0x6527,0x4e5f, /* '素','紡','索',0,0,0,0,0, 0,0,0,'紫','紬',0,'紮','累', */
	/* 7d30 */ 0x3a59,0,0x6528,0x3f42,0,0x652a,0,0, 0,0x3e52,0x3a30,0,0,0,0,0x6529, /* '細',0,'紲','紳',0,'紵',0,0, 0,'紹','紺',0,0,0,0,'紿', */
	/* 7d40 */ 0,0,0x3d2a,0x383e,0x4148,0x6525,0x652b,0, 0,0,0,0x6526,0x3750,0,0x652e,0x6532, /* 0,0,'終','絃','組','絅','絆',0, 0,0,0,'絋','経',0,'絎','絏', */
	/* 7d50 */ 0x376b,0,0,0,0,0,0x652d,0, 0,0,0,0x6536,0,0,0x394a,0, /* '結',0,0,0,0,0,'絖',0, 0,0,0,'絛',0,0,'絞',0, */
	/* 7d60 */ 0,0x4d6d,0x303c,0x6533,0,0,0x356b,0, 0x6530,0,0,0,0,0,0x6531,0, /* 0,'絡','絢','絣',0,0,'給',0, '絨',0,0,0,0,0,'絮',0, */
	/* 7d70 */ 0,0x457d,0x652f,0x652c,0,0x3328,0x4064,0, 0,0x3828,0,0,0,0x6538,0,0, /* 0,'統','絲','絳',0,'絵','絶',0, 0,'絹',0,0,0,'絽',0,0, */
	/* 7d80 */ 0,0,0,0,0,0,0,0, 0,0x6535,0,0,0,0,0,0x6537, /* 0,0,0,0,0,0,0,0, 0,'綉',0,0,0,0,0,'綏', */
	/* 7d90 */ 0,0,0,0x6534,0,0,0,0, 0,0x3751,0x4233,0x6539,0x416e,0,0,0x6546, /* 0,0,0,'經',0,0,0,0, 0,'継','続','綛','綜',0,0,'綟', */
	/* 7da0 */ 0,0,0x6542,0x653c,0,0,0,0, 0,0,0,0x6540,0x3c7a,0x305d,0x653b,0x6543, /* 0,0,'綢','綣',0,0,0,0, 0,0,0,'綫','綬','維','綮','綯', */
	/* 7db0 */ 0x6547,0x394b,0x4c56,0,0x4456,0x653d,0,0, 0x6545,0,0x653a,0x433e,0,0x653f,0x303d,0x4c4a, /* '綰','綱','網',0,'綴','綵',0,0, '綸',0,'綺','綻',0,'綽','綾','綿', */
	/* 7dc0 */ 0,0,0,0,0,0,0,0x653e, 0,0,0x365b,0x486c,0,0,0,0x416d, /* 0,0,0,0,0,0,0,'緇', 0,0,'緊','緋',0,0,0,'総', */
	/* 7dd0 */ 0,0x4e50,0x3d6f,0,0,0x656e,0,0, 0x6548,0,0x407e,0,0x6544,0x6549,0x654b,0, /* 0,'緑','緒',0,0,'緕',0,0, '緘',0,'線',0,'緜','緝','緞',0, */
	/* 7de0 */ 0x4479,0x654e,0,0,0x654a,0,0,0, 0x4a54,0x344b,0,0,0x4c4b,0,0,0x305e, /* '締','緡',0,0,'緤',0,0,0, '編','緩',0,0,'緬',0,0,'緯', */
	/* 7df0 */ 0,0,0x654d,0,0x4e7d,0,0,0, 0,0,0,0x654c,0,0,0,0, /* 0,0,'緲',0,'練',0,0,0, 0,0,0,'緻',0,0,0,0, */
	/* 7e00 */ 0,0x316f,0,0,0x466c,0x654f,0,0, 0,0x6556,0x6550,0x6557,0,0,0,0, /* 0,'縁',0,0,'縄','縅',0,0, 0,'縉','縊','縋',0,0,0,0, */
	/* 7e10 */ 0,0,0x6553,0,0,0,0,0, 0,0,0,0x477b,0,0,0x3c4a,0x6555, /* 0,0,'縒',0,0,0,0,0, 0,0,0,'縛',0,0,'縞','縟', */
	/* 7e20 */ 0,0x6552,0x6558,0x6551,0,0,0x3d44,0, 0,0,0,0x4b25,0,0,0x3d4c,0, /* 0,'縡','縢','縣',0,0,'縦',0, 0,0,0,'縫',0,0,'縮',0, */
	/* 7e30 */ 0,0x6554,0x6560,0,0,0x655c,0,0x655f, 0,0x655d,0x6561,0x655b,0,0x6541,0x4053,0, /* 0,'縱','縲',0,0,'縵',0,'縷', 0,'縹','縺','縻',0,'總','績',0, */
	/* 7e40 */ 0,0x484b,0,0x655e,0,0,0x6559,0, 0,0,0x4121,0x3752,0,0x3d2b,0,0, /* 0,'繁',0,'繃',0,0,'繆',0, 0,0,'繊','繋',0,'繍',0,0, */
	/* 7e50 */ 0,0,0,0,0x3f25,0x4136,0x6564,0, 0,0x6566,0x6567,0,0,0x6563,0x6565,0, /* 0,0,0,0,'織','繕','繖',0, 0,'繙','繚',0,0,'繝','繞',0, */
	/* 7e60 */ 0,0,0,0,0,0,0x655a,0x6562, 0,0x656a,0x6569,0,0,0x4b7a,0,0, /* 0,0,0,0,0,0,'繦','繧', 0,'繩','繪',0,0,'繭',0,0, */
	/* 7e70 */ 0x372b,0,0,0,0,0,0,0, 0,0x6568,0,0x656c,0x656b,0x656f,0,0x6571, /* '繰',0,0,0,0,0,0,0, 0,'繹',0,'繻','繼','繽',0,'繿', */
	/* 7e80 */ 0,0,0x3b3c,0x656d,0,0,0,0, 0x6572,0x6573,0,0,0x6574,0,0x657a,0x453b, /* 0,0,'纂','纃',0,0,0,0, '纈','纉',0,0,'續',0,'纎','纏', */
	/* 7e90 */ 0x6576,0,0x6575,0x6577,0x6578,0,0x6579,0, 0,0,0,0x657b,0x657c,0,0,0, /* '纐',0,'纒','纓','纔',0,'纖',0, 0,0,0,'纛','纜',0,0,0, */
	/* 7ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f30 */ 0,0,0,0,0,0,0x344c,0, 0x657d,0,0x657e,0,0,0,0,0, /* 0,0,0,0,0,0,'缶',0, '缸',0,'缺',0,0,0,0,0, */
	/* 7f40 */ 0,0,0,0,0,0x6621,0,0, 0,0,0,0,0x6622,0x6623,0x6624,0, /* 0,0,0,0,0,'罅',0,0, 0,0,0,0,'罌','罍','罎',0, */
	/* 7f50 */ 0x6625,0x6626,0,0,0x6628,0x6627,0,0, 0x6629,0,0,0,0,0,0,0x662a, /* '罐','网',0,0,'罔','罕',0,0, '罘',0,0,0,0,0,0,'罟', */
	/* 7f60 */ 0x662b,0,0,0,0,0,0,0x662e, 0x662c,0x662d,0x3a61,0x3753,0,0,0x4356,0, /* '罠',0,0,0,0,0,0,'罧', '罨','罩','罪','罫',0,0,'置',0, */
	/* 7f70 */ 0x4833,0,0x3d70,0,0,0x474d,0,0x486d, 0x662f,0x586d,0,0,0,0,0,0, /* '罰',0,'署',0,0,'罵',0,'罷', '罸','罹',0,0,0,0,0,0, */
	/* 7f80 */ 0,0,0x6630,0x6632,0,0x4d65,0x6631,0x6634, 0x6633,0,0x4d53,0,0x6635,0,0x487e,0, /* 0,0,'羂','羃',0,'羅','羆','羇', '羈',0,'羊',0,'羌',0,'美',0, */
	/* 7f90 */ 0,0,0,0,0x6636,0,0,0, 0,0,0x6639,0,0,0x6638,0x6637,0, /* 0,0,0,0,'羔',0,0,0, 0,0,'羚',0,0,'羝','羞',0, */
	/* 7fa0 */ 0,0,0,0x663a,0x3732,0,0,0, 0x4122,0x3541,0,0,0,0,0x663e,0x663b, /* 0,0,0,'羣','群',0,0,0, '羨','義',0,0,0,0,'羮','羯', */
	/* 7fb0 */ 0,0,0x663c,0,0,0,0x663f,0, 0x6640,0x663d,0,0,0,0x3129,0,0, /* 0,0,'羲',0,0,0,'羶',0, '羸','羹',0,0,0,'羽',0,0, */
	/* 7fc0 */ 0,0x3227,0,0,0,0x6642,0x6643,0, 0,0,0x6644,0,0x4d62,0,0,0, /* 0,'翁',0,0,0,'翅','翆',0, 0,0,'翊',0,'翌',0,0,0, */
	/* 7fd0 */ 0,0,0x3d2c,0,0x6646,0x6645,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'習',0,'翔','翕',0,0, 0,0,0,0,0,0,0,0, */
	/* 7fe0 */ 0x3f69,0x6647,0,0,0,0,0x6648,0, 0,0x6649,0,0x3465,0,0,0,0, /* '翠','翡',0,0,0,0,'翦',0, 0,'翩',0,'翫',0,0,0,0, */
	/* 7ff0 */ 0x344d,0,0,0x664a,0,0,0,0, 0,0x664b,0,0x4b5d,0x4d63,0,0,0, /* '翰',0,0,'翳',0,0,0,0, 0,'翹',0,'翻','翼',0,0,0, */
	/* 8000 */ 0x4d54,0x4f37,0,0x394d,0x664e,0x3c54,0x664d,0, 0,0,0,0x664f,0x3c29,0,0,0, /* '耀','老',0,'考','耄','者','耆',0, 0,0,0,'耋','而',0,0,0, */
	/* 8010 */ 0x4251,0,0x6650,0,0,0x394c,0,0x4c57, 0x6651,0x6652,0,0,0x6653,0,0,0, /* '耐',0,'耒',0,0,'耕',0,'耗', '耘','耙',0,0,'耜',0,0,0, */
	/* 8020 */ 0,0x6654,0,0,0,0,0,0, 0x6655,0,0,0,0,0,0,0, /* 0,'耡',0,0,0,0,0,0, '耨',0,0,0,0,0,0,0, */
	/* 8030 */ 0,0,0,0x3c2a,0,0,0x4c6d,0, 0,0,0,0x6657,0,0x433f,0,0x6656, /* 0,0,0,'耳',0,0,'耶',0, 0,0,0,'耻',0,'耽',0,'耿', */
	/* 8040 */ 0,0,0,0,0,0,0x6659,0, 0,0,0x6658,0,0,0,0,0, /* 0,0,0,0,0,0,'聆',0, 0,0,'聊',0,0,0,0,0, */
	/* 8050 */ 0,0,0x665a,0,0,0,0x403b,0, 0x665b,0,0x665c,0,0,0,0x4a39,0x665d, /* 0,0,'聒',0,0,0,'聖',0, '聘',0,'聚',0,0,0,'聞','聟', */
	/* 8060 */ 0,0x416f,0x665e,0,0,0,0,0, 0x665f,0,0,0,0,0,0,0x4e7e, /* 0,'聡','聢',0,0,0,0,0, '聨',0,0,0,0,0,0,'聯', */
	/* 8070 */ 0x6662,0,0x6661,0x6660,0x4430,0,0x6663,0x3f26, 0,0x6664,0,0,0,0x6665,0x4f38,0x6666, /* '聰',0,'聲','聳','聴',0,'聶','職', 0,'聹',0,0,0,'聽','聾','聿', */
	/* 8080 */ 0,0,0,0,0x6667,0x6669,0x6668,0x4825, 0,0x4679,0,0x4f3e,0x4829,0,0,0, /* 0,0,0,0,'肄','肅','肆','肇', 0,'肉',0,'肋','肌',0,0,0, */
	/* 8090 */ 0,0,0,0x666b,0,0,0x3e53,0, 0x492a,0,0x666c,0x666a,0,0x344e,0,0, /* 0,0,0,'肓',0,0,'肖',0, '肘',0,'肚','肛',0,'肝',0,0, */
	/* 80a0 */ 0,0x3854,0x3b68,0,0,0x486e,0,0, 0,0x382a,0x4b43,0,0x666f,0x666d,0,0x394e, /* 0,'股','肢',0,0,'肥',0,0, 0,'肩','肪',0,'肬','肭',0,'肯', */
	/* 80b0 */ 0,0x394f,0x3069,0,0x3a68,0,0,0, 0,0,0x4759,0,0,0,0,0, /* 0,'肱','育',0,'肴',0,0,0, 0,0,'肺',0,0,0,0,0, */
	/* 80c0 */ 0,0,0,0x305f,0x6674,0,0x4340,0, 0,0,0,0,0x4758,0,0x425b,0, /* 0,0,0,'胃','胄',0,'胆',0, 0,0,0,0,'背',0,'胎',0, */
	/* 80d0 */ 0,0,0,0,0,0,0x6676,0, 0,0x6672,0x6675,0x6670,0,0x6673,0x4b26,0, /* 0,0,0,0,0,0,'胖',0, 0,'胙','胚','胛',0,'胝','胞',0, */
	/* 80e0 */ 0,0x3855,0,0,0x307d,0x6671,0,0, 0,0,0,0,0,0,0,0x6678, /* 0,'胡',0,0,'胤','胥',0,0, 0,0,0,0,0,0,0,'胯', */
	/* 80f0 */ 0,0x6679,0,0,0x4639,0,0,0, 0x363b,0,0,0,0x6726,0x473d,0,0, /* 0,'胱',0,0,'胴',0,0,0, '胸',0,0,0,'胼','能',0,0, */
	/* 8100 */ 0,0,0x3b69,0,0,0x363c,0x4048,0x4f46, 0x4c2e,0x6677,0x4054,0,0,0,0,0, /* 0,0,'脂',0,0,'脅','脆','脇', '脈','脉','脊',0,0,0,0,0, */
	/* 8110 */ 0,0,0,0,0,0,0,0, 0,0,0x3553,0x667a,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'脚','脛',0,0,0,0, */
	/* 8120 */ 0,0,0,0x667c,0,0,0,0, 0,0x667b,0,0,0,0,0,0x667d, /* 0,0,0,'脣',0,0,0,0, 0,'脩',0,0,0,0,0,'脯', */
	/* 8130 */ 0,0x4326,0,0x473e,0,0,0,0, 0,0x4431,0,0,0,0,0x6723,0, /* 0,'脱',0,'脳',0,0,0,0, 0,'脹',0,0,0,0,'脾',0, */
	/* 8140 */ 0,0,0,0,0,0,0x6722,0, 0,0,0,0x667e,0,0,0x3f55,0, /* 0,0,0,0,0,0,'腆',0, 0,0,0,'腋',0,0,'腎',0, */
	/* 8150 */ 0x4965,0x6725,0,0x6724,0x3950,0x4f53,0,0, 0,0,0,0,0,0,0,0x6735, /* '腐','腑',0,'腓','腔','腕',0,0, 0,0,0,0,0,0,0,'腟', */
	/* 8160 */ 0,0,0,0,0,0x6729,0x672a,0, 0,0,0,0x3c70,0,0,0x6728,0, /* 0,0,0,0,0,'腥','腦',0, 0,0,0,'腫',0,0,'腮',0, */
	/* 8170 */ 0x3978,0x6727,0,0,0x672b,0,0,0, 0x4432,0x4a22,0x4123,0,0,0,0,0x425c, /* '腰','腱',0,0,'腴',0,0,0, '腸','腹','腺',0,0,0,0,'腿', */
	/* 8180 */ 0x672f,0,0x6730,0x672c,0,0,0,0, 0x672d,0,0x672e,0,0,0,0,0x3951, /* '膀',0,'膂','膃',0,0,0,0, '膈',0,'膊',0,0,0,0,'膏', */
	/* 8190 */ 0,0,0,0x6736,0,0x6732,0,0, 0,0,0x4966,0,0x4b6c,0x4928,0,0, /* 0,0,0,'膓',0,'膕',0,0, 0,0,'膚',0,'膜','膝',0,0, */
	/* 81a0 */ 0x6731,0,0,0x6734,0x6733,0,0,0, 0x4b44,0x6737,0,0,0,0,0,0, /* '膠',0,0,'膣','膤',0,0,0, '膨','膩',0,0,0,0,0,0, */
	/* 81b0 */ 0x6738,0,0,0x4137,0,0x6739,0,0, 0x673b,0,0x673f,0,0,0x673c,0x673a,0x473f, /* '膰',0,0,'膳',0,'膵',0,0, '膸',0,'膺',0,0,'膽','膾','膿', */
	/* 81c0 */ 0x673d,0,0x673e,0,0,0,0x3232,0, 0x6745,0x6740,0,0,0,0x6741,0,0, /* '臀',0,'臂',0,0,0,'臆',0, '臈','臉',0,0,0,'臍',0,0, */
	/* 81d0 */ 0,0x6742,0,0x4221,0,0,0,0, 0x6744,0x6743,0x6746,0,0,0,0,0x6747, /* 0,'臑',0,'臓',0,0,0,0, '臘','臙','臚',0,0,0,0,'臟', */
	/* 81e0 */ 0x6748,0,0,0x3f43,0,0x3269,0,0x6749, 0x4e57,0,0x3c2b,0,0,0x3d2d,0,0, /* '臠',0,0,'臣',0,'臥',0,'臧', '臨',0,'自',0,0,'臭',0,0, */
	/* 81f0 */ 0,0,0,0x3b6a,0x4357,0,0,0, 0,0,0x674a,0x674b,0x3131,0,0x674c,0, /* 0,0,0,'至','致',0,0,0, 0,0,'臺','臻','臼',0,'臾',0, */
	/* 8200 */ 0,0x674d,0x674e,0,0,0x674f,0,0x6750, 0x363d,0x5a2a,0x6751,0,0x4065,0x6752,0x3c4b,0, /* 0,'舁','舂',0,0,'舅',0,'與', '興','舉','舊',0,'舌','舍','舎',0, */
	/* 8210 */ 0x6753,0,0x5030,0,0,0,0x6754,0x4a5e, 0x345c,0,0,0x4124,0x3d58,0,0x4971,0x3d2e, /* '舐',0,'舒',0,0,0,'舖','舗', '舘',0,0,'舛','舜',0,'舞','舟', */
	/* 8220 */ 0,0,0,0,0,0,0,0, 0,0x6755,0x3952,0x6756,0x484c,0,0x6764,0, /* 0,0,0,0,0,0,0,0, 0,'舩','航','舫','般',0,'舮',0, */
	/* 8230 */ 0,0,0,0x6758,0,0x4249,0x4775,0x383f, 0x6757,0x4125,0,0,0,0,0,0, /* 0,0,0,'舳',0,'舵','舶','舷', '舸','船',0,0,0,0,0,0, */
	/* 8240 */ 0x6759,0,0,0,0,0,0,0x447a, 0,0,0,0,0,0,0,0, /* '艀',0,0,0,0,0,0,'艇', 0,0,0,0,0,0,0,0, */
	/* 8250 */ 0,0,0,0,0,0,0,0, 0x675b,0x675a,0x675d,0,0,0x675c,0,0x675e, /* 0,0,0,0,0,0,0,0, '艘','艙','艚',0,0,'艝',0,'艟', */
	/* 8260 */ 0,0,0x6760,0,0x675f,0,0x344f,0, 0x6761,0,0x6762,0x6763,0,0,0x3a31,0x4e49, /* 0,0,'艢',0,'艤',0,'艦',0, '艨',0,'艪','艫',0,0,'艮','良', */
	/* 8270 */ 0,0x6765,0x3f27,0,0,0,0x3170,0x6766, 0x6767,0,0,0,0,0,0x6768,0, /* 0,'艱','色',0,0,0,'艶','艷', '艸',0,0,0,0,0,'艾',0, */
	/* 8280 */ 0,0,0,0,0,0,0,0, 0,0,0,0x3072,0,0x6769,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'芋',0,'芍',0,0, */
	/* 8290 */ 0,0,0x676a,0,0,0,0,0, 0,0x4967,0,0,0,0x3c47,0,0x676c, /* 0,0,'芒',0,0,0,0,0, 0,'芙',0,0,0,'芝',0,'芟', */
	/* 82a0 */ 0,0,0,0,0,0x3329,0x3032,0, 0,0,0,0x676b,0x676e,0x474e,0,0x3f44, /* 0,0,0,0,0,'芥','芦',0, 0,0,0,'芫','芬','芭',0,'芯', */
	/* 82b0 */ 0,0x3256,0,0x4b27,0,0,0,0, 0x375d,0x365c,0,0x676d,0,0x326a,0,0, /* 0,'花',0,'芳',0,0,0,0, '芸','芹',0,'芻',0,'芽',0,0, */
	/* 82c0 */ 0,0,0,0,0,0x3423,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'苅',0,0, 0,0,0,0,0,0,0,0, */
	/* 82d0 */ 0,0x3171,0x6772,0x4e6a,0x425d,0,0,0x4944, 0,0x677e,0,0x3257,0x677c,0,0x677a,0x6771, /* 0,'苑','苒','苓','苔',0,0,'苗', 0,'苙',0,'苛','苜',0,'苞','苟', */
	/* 82e0 */ 0,0x676f,0,0x6770,0,0x3c63,0x366c,0x4377, 0,0,0,0x4651,0,0,0,0, /* 0,'苡',0,'苣',0,'若','苦','苧', 0,0,0,'苫',0,0,0,0, */
	/* 82f0 */ 0,0x3151,0,0x6774,0x6773,0,0,0, 0,0x6779,0x6775,0x6778,0,0,0,0, /* 0,'英',0,'苳','苴',0,0,0, 0,'苹','苺','苻',0,0,0,0, */
	/* 8300 */ 0,0,0x4c50,0x6777,0x3258,0x337d,0x677b,0, 0,0x677d,0,0,0,0,0x3754,0, /* 0,0,'茂','范','茄','茅','茆',0, 0,'茉',0,0,0,0,'茎',0, */
	/* 8310 */ 0,0,0,0,0,0,0x6823,0x682c, 0x682d,0,0,0,0x302b,0,0,0, /* 0,0,0,0,0,0,'茖','茗', '茘',0,0,0,'茜',0,0,0, */
	/* 8320 */ 0,0,0,0x6834,0,0,0,0, 0x3071,0,0,0x682b,0,0,0,0x682a, /* 0,0,0,'茣',0,0,0,0, '茨',0,0,'茫',0,0,0,'茯', */
	/* 8330 */ 0,0x6825,0x6824,0,0x6822,0x6821,0x4363,0, 0x427b,0x6827,0,0,0,0,0,0, /* 0,'茱','茲',0,'茴','茵','茶',0, '茸','茹',0,0,0,0,0,0, */
	/* 8340 */ 0x6826,0,0,0,0,0x6829,0,0, 0,0x4170,0x3755,0,0,0,0,0x3141, /* '荀',0,0,0,0,'荅',0,0, 0,'草','荊',0,0,0,0,'荏', */
	/* 8350 */ 0x6828,0,0x3953,0,0,0,0,0, 0x4171,0,0,0,0,0,0,0, /* '荐',0,'荒',0,0,0,0,0, '荘',0,0,0,0,0,0,0, */
	/* 8360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8370 */ 0,0,0,0x683a,0,0x683b,0,0x3259, 0,0,0,0x322e,0x6838,0,0,0, /* 0,0,0,'荳',0,'荵',0,'荷', 0,0,0,'荻','荼',0,0,0, */
	/* 8380 */ 0,0,0,0,0,0x682e,0,0x6836, 0,0x683d,0x6837,0,0,0,0x6835,0, /* 0,0,0,0,0,'莅',0,'莇', 0,'莉','莊',0,0,0,'莎',0, */
	/* 8390 */ 0,0,0,0x6776,0,0,0x6833,0, 0,0,0x682f,0,0,0,0x3450,0x6831, /* 0,0,0,'莓',0,0,'莖',0, 0,0,'莚',0,0,0,'莞','莟', */
	/* 83a0 */ 0x683c,0,0x6832,0,0,0,0,0, 0x683e,0,0x6830,0x477c,0,0,0,0, /* '莠',0,'莢',0,0,0,0,0, '莨',0,'莪','莫',0,0,0,0, */
	/* 83b0 */ 0,0x4d69,0,0,0,0x6839,0,0, 0,0,0,0,0,0x684f,0,0, /* 0,'莱',0,0,0,'莵',0,0, 0,0,0,0,0,'莽',0,0, */
	/* 83c0 */ 0,0x6847,0,0,0,0x3f7b,0,0, 0,0,0x3546,0,0x365d,0,0x6842,0, /* 0,'菁',0,0,0,'菅',0,0, 0,0,'菊',0,'菌',0,'菎',0, */
	/* 83d0 */ 0,0,0,0x325b,0,0,0x3e54,0, 0x6845,0,0,0,0x3a5a,0,0,0x4551, /* 0,0,0,'菓',0,0,'菖',0, '菘',0,0,0,'菜',0,0,'菟', */
	/* 83e0 */ 0x684a,0,0,0,0,0,0,0, 0,0x4a6e,0,0x6841,0,0,0,0x325a, /* '菠',0,0,0,0,0,0,0, 0,'菩',0,'菫',0,0,0,'華', */
	/* 83f0 */ 0x3856,0x4929,0x684b,0,0x683f,0,0,0x6848, 0,0,0,0x6852,0,0x6843,0,0, /* '菰','菱','菲',0,'菴',0,0,'菷', 0,0,0,'菻',0,'菽',0,0, */
	/* 8400 */ 0,0,0,0x6844,0x463a,0,0,0x6849, 0,0,0,0x6846,0x4b28,0x684c,0x3060,0, /* 0,0,0,'萃','萄',0,0,'萇', 0,0,0,'萋','萌','萍','萎',0, */
	/* 8410 */ 0,0,0,0x6840,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'萓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8420 */ 0x684e,0,0x684d,0,0,0,0,0, 0,0x476b,0x6854,0,0x685f,0,0,0, /* '萠',0,'萢',0,0,0,0,0, 0,'萩','萪',0,'萬',0,0,0, */
	/* 8430 */ 0,0x337e,0,0,0,0x6862,0,0, 0x6850,0,0,0,0x6855,0x4d6e,0,0, /* 0,'萱',0,0,0,'萵',0,0, '萸',0,0,0,'萼','落',0,0, */
	/* 8440 */ 0,0,0,0,0,0,0x685e,0, 0,0x4d55,0,0,0,0,0x4e2a,0, /* 0,0,0,0,0,0,'葆',0, 0,'葉',0,0,0,0,'葎',0, */
	/* 8450 */ 0,0,0,0,0,0,0,0x4378, 0,0,0,0x336b,0,0,0,0, /* 0,0,0,0,0,0,0,'著', 0,0,0,'葛',0,0,0,0, */
	/* 8460 */ 0,0x4972,0x6864,0x4621,0,0,0x3031,0, 0,0x685d,0,0x6859,0x4172,0x6853,0x685b,0x6860, /* 0,'葡','葢','董',0,0,'葦',0, 0,'葩',0,'葫','葬','葭','葮','葯', */
	/* 8470 */ 0,0x472c,0,0,0,0x302a,0,0x6858, 0,0x6861,0x4978,0,0,0,0,0, /* 0,'葱',0,0,0,'葵',0,'葷', 0,'葹','葺',0,0,0,0,0, */
	/* 8480 */ 0,0,0x685c,0,0x6857,0,0,0, 0,0,0,0x3e55,0,0,0,0, /* 0,0,'蒂',0,'蒄',0,0,0, 0,0,0,'蒋',0,0,0,0, */
	/* 8490 */ 0x3d2f,0,0,0,0x3c2c,0,0,0, 0,0x4c58,0,0,0x4947,0,0,0x6867, /* '蒐',0,0,0,'蒔',0,0,0, 0,'蒙',0,0,'蒜',0,0,'蒟', */
	/* 84a0 */ 0,0x6870,0,0,0,0,0,0, 0,0,0,0,0,0x685a,0,0, /* 0,'蒡',0,0,0,0,0,0, 0,0,0,0,0,'蒭',0,0, */
	/* 84b0 */ 0,0,0x3377,0,0,0,0,0, 0x3e78,0x6865,0,0x686a,0x4173,0,0,0x6866, /* 0,0,'蒲',0,0,0,0,0, '蒸','蒹',0,'蒻','蒼',0,0,'蒿', */
	/* 84c0 */ 0,0x686d,0,0,0x435f,0,0x686e,0, 0,0x4d56,0x6863,0x3338,0,0x6869,0,0, /* 0,'蓁',0,0,'蓄',0,'蓆',0, 0,'蓉','蓊','蓋',0,'蓍',0,0, */
	/* 84d0 */ 0x686c,0x4c2c,0,0,0,0,0x686f,0, 0,0x6868,0x686b,0,0,0,0,0, /* '蓐','蓑',0,0,0,0,'蓖',0, 0,'蓙','蓚',0,0,0,0,0, */
	/* 84e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x4b29,0,0x4f21,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'蓬',0,'蓮',0, */
	/* 84f0 */ 0,0,0,0,0x6873,0,0,0, 0,0,0,0,0x687a,0,0,0x6872, /* 0,0,0,0,'蓴',0,0,0, 0,0,0,0,'蓼',0,0,'蓿', */
	/* 8500 */ 0x3c43,0,0,0,0,0,0x6851,0, 0,0,0,0,0,0,0,0, /* '蔀',0,0,0,0,0,'蔆',0, 0,0,0,0,0,0,0,0, */
	/* 8510 */ 0,0x4a4e,0,0x4c22,0x6879,0x6878,0,0x6874, 0x6875,0,0x3136,0,0,0,0,0x6877, /* 0,'蔑',0,'蔓','蔔','蔕',0,'蔗', '蔘',0,'蔚',0,0,0,0,'蔟', */
	/* 8520 */ 0,0x6871,0,0,0,0,0x4455,0, 0,0,0,0,0x6876,0x307e,0,0, /* 0,'蔡',0,0,0,0,'蔦',0, 0,0,0,0,'蔬','蔭',0,0, */
	/* 8530 */ 0,0,0,0,0,0x4222,0,0, 0,0,0,0,0,0x4a43,0,0, /* 0,0,0,0,0,'蔵',0,0, 0,0,0,0,0,'蔽',0,0, */
	/* 8540 */ 0x687b,0x6921,0,0x4859,0,0,0,0, 0x687e,0x3e56,0x3c49,0x6923,0,0,0x363e,0, /* '蕀','蕁',0,'蕃',0,0,0,0, '蕈','蕉','蕊','蕋',0,0,'蕎',0, */
	/* 8550 */ 0,0,0,0,0,0x6924,0,0x4979, 0x687d,0,0x6856,0,0,0,0,0, /* 0,0,0,0,0,'蕕',0,'蕗', '蕘',0,'蕚',0,0,0,0,0, */
	/* 8560 */ 0,0,0,0x687c,0,0,0,0, 0x4f4f,0x4622,0x4973,0,0,0x692b,0,0, /* 0,0,0,'蕣',0,0,0,0, '蕨','蕩','蕪',0,0,'蕭',0,0, */
	/* 8570 */ 0,0,0,0,0,0,0,0x6931, 0,0,0,0,0,0,0x6932,0, /* 0,0,0,0,0,0,0,'蕷', 0,0,0,0,0,0,'蕾',0, */
	/* 8580 */ 0x6925,0,0,0,0x4776,0,0,0x692f, 0x6927,0,0x6929,0,0,0,0,0, /* '薀',0,0,0,'薄',0,0,'薇', '薈',0,'薊',0,0,0,0,0, */
	/* 8590 */ 0x6933,0x6928,0,0,0x692c,0,0,0x3172, 0,0x4665,0,0x692d,0x6930,0,0,0, /* '薐','薑',0,0,'薔',0,0,'薗', 0,'薙',0,'薛','薜',0,0,0, */
	/* 85a0 */ 0,0,0,0,0x6926,0,0x4126,0, 0x692a,0x3b27,0x3f45,0x3730,0x4c74,0,0x4c79,0x3d72, /* 0,0,0,0,'薤',0,'薦',0, '薨','薩','薪','薫','薬',0,'薮','薯', */
	/* 85b0 */ 0,0,0,0,0,0,0,0, 0,0x6937,0x6935,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'薹','薺',0,0,0,0,0, */
	/* 85c0 */ 0,0x4f4e,0,0,0,0,0,0, 0,0x6934,0,0,0,0x4d75,0,0x6936, /* 0,'藁',0,0,0,0,0,0, 0,'藉',0,0,0,'藍',0,'藏', */
	/* 85d0 */ 0x6938,0,0,0,0,0x6939,0,0, 0,0,0,0,0x693c,0x693a,0,0, /* '藐',0,0,0,0,'藕',0,0, 0,0,0,0,'藜','藝',0,0, */
	/* 85e0 */ 0,0,0,0,0x4623,0x693b,0,0, 0,0x484d,0x692e,0,0,0,0,0, /* 0,0,0,0,'藤','藥',0,0, 0,'藩','藪',0,0,0,0,0, */
	/* 85f0 */ 0,0,0,0,0,0,0,0x3d73, 0,0x693d,0x6942,0x4174,0,0,0x6941,0, /* 0,0,0,0,0,0,0,'藷', 0,'藹','藺','藻',0,0,'藾',0, */
	/* 8600 */ 0,0,0x6922,0,0,0,0x6943,0x4149, 0,0,0x693e,0x6940,0,0,0,0, /* 0,0,'蘂',0,0,0,'蘆','蘇', 0,0,'蘊','蘋',0,0,0,0, */
	/* 8610 */ 0,0,0,0x693f,0,0,0x5d31,0x5d22, 0,0,0x6945,0,0,0,0,0, /* 0,0,0,'蘓',0,0,'蘖','蘗', 0,0,'蘚',0,0,0,0,0, */
	/* 8620 */ 0,0,0x6944,0,0,0,0,0, 0,0,0,0,0,0x4d76,0,0x623c, /* 0,0,'蘢',0,0,0,0,0, 0,0,0,0,0,'蘭',0,'蘯', */
	/* 8630 */ 0x6946,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x6947, /* '蘰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'蘿', */
	/* 8640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x6948,0x3857,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'虍','虎',0, */
	/* 8650 */ 0x3554,0,0,0,0x694a,0x515d,0,0, 0,0,0x3575,0,0x4e3a,0,0x3673,0x694b, /* '虐',0,0,0,'虔','處',0,0, 0,0,'虚',0,'虜',0,'虞','號', */
	/* 8660 */ 0,0,0,0,0,0,0,0x694c, 0,0,0,0x436e,0,0,0,0, /* 0,0,0,0,0,0,0,'虧', 0,0,0,'虫',0,0,0,0, */
	/* 8670 */ 0,0x694d,0,0,0,0,0,0, 0,0x467a,0,0x303a,0,0,0,0, /* 0,'虱',0,0,0,0,0,0, 0,'虹',0,'虻',0,0,0,0, */
	/* 8680 */ 0,0,0,0,0,0,0,0, 0,0,0x3263,0x6952,0x6953,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'蚊','蚋','蚌',0,0,0, */
	/* 8690 */ 0,0,0,0x694e,0,0x3b3d,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'蚓',0,'蚕',0,0, 0,0,0,0,0,0,0,0, */
	/* 86a0 */ 0,0,0,0x694f,0x4742,0,0,0, 0,0x6950,0x6951,0x695b,0,0,0,0x6955, /* 0,0,0,'蚣','蚤',0,0,0, 0,'蚩','蚪','蚫',0,0,0,'蚯', */
	/* 86b0 */ 0x6958,0,0,0,0,0,0x6954,0, 0,0,0,0,0,0,0,0, /* '蚰',0,0,0,0,0,'蚶',0, 0,0,0,0,0,0,0,0, */
	/* 86c0 */ 0,0,0,0,0x6956,0,0x6957,0x3c58, 0,0x6959,0,0x4341,0,0x3756,0x3342,0, /* 0,0,0,0,'蛄',0,'蛆','蛇', 0,'蛉',0,'蛋',0,'蛍','蛎',0, */
	/* 86d0 */ 0,0,0,0,0x695c,0,0,0, 0,0x333f,0,0x6961,0,0,0x695d,0x6960, /* 0,0,0,0,'蛔',0,0,0, 0,'蛙',0,'蛛',0,0,'蛞','蛟', */
	/* 86e0 */ 0,0,0,0,0x483a,0,0,0, 0,0x695e,0,0,0x695f,0x4948,0x485a,0x6962, /* 0,0,0,0,'蛤',0,0,0, 0,'蛩',0,0,'蛬','蛭','蛮','蛯', */
	/* 86f0 */ 0,0,0,0,0,0,0,0, 0x427d,0x696c,0,0x6968,0,0,0x326b,0, /* 0,0,0,0,0,0,0,0, '蛸','蛹',0,'蛻',0,0,'蛾',0, */
	/* 8700 */ 0x6966,0,0x4b2a,0x6967,0,0,0x6964,0, 0x6965,0x696a,0x696d,0,0,0x696b,0,0, /* '蜀',0,'蜂','蜃',0,0,'蜆',0, '蜈','蜉','蜊',0,0,'蜍',0,0, */
	/* 8710 */ 0,0x6969,0x6963,0,0,0,0,0, 0x4358,0,0x6974,0,0x4c2a,0,0,0, /* 0,'蜑','蜒',0,0,0,0,0, '蜘',0,'蜚',0,'蜜',0,0,0, */
	/* 8720 */ 0,0,0,0,0,0x6972,0,0, 0,0x6973,0,0,0,0,0,0, /* 0,0,0,0,0,'蜥',0,0, 0,'蜩',0,0,0,0,0,0, */
	/* 8730 */ 0,0,0,0,0x696e,0,0,0x6970, 0,0,0,0x6971,0,0,0,0x696f, /* 0,0,0,0,'蜴',0,0,'蜷', 0,0,0,'蜻',0,0,0,'蜿', */
	/* 8740 */ 0,0,0,0,0,0,0,0, 0,0x4066,0,0x4f39,0x6978,0,0x6979,0, /* 0,0,0,0,0,0,0,0, 0,'蝉',0,'蝋','蝌',0,'蝎',0, */
	/* 8750 */ 0,0,0,0x6a21,0,0x3f2a,0,0x697b, 0,0x697e,0,0,0,0,0,0x6976, /* 0,0,0,'蝓',0,'蝕',0,'蝗', 0,'蝙',0,0,0,0,0,'蝟', */
	/* 8760 */ 0x6975,0,0,0x6a22,0,0,0x325c,0, 0x697c,0,0x6a23,0,0,0,0x697d,0, /* '蝠',0,0,'蝣',0,0,'蝦',0, '蝨',0,'蝪',0,0,0,'蝮',0, */
	/* 8770 */ 0,0,0,0,0x697a,0,0x4433,0, 0x6977,0,0,0,0,0,0,0x4768, /* 0,0,0,0,'蝴',0,'蝶',0, '蝸',0,0,0,0,0,0,'蝿', */
	/* 8780 */ 0,0,0x6a27,0,0,0,0,0, 0,0,0,0,0,0x4d3b,0,0, /* 0,0,'螂',0,0,0,0,0, 0,0,0,0,0,'融',0,0, */
	/* 8790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x6a26, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'螟', */
	/* 87a0 */ 0,0,0x6a25,0,0,0,0,0, 0,0,0,0x6a2e,0,0,0,0x6a28, /* 0,0,'螢',0,0,0,0,0, 0,0,0,'螫',0,0,0,'螯', */
	/* 87b0 */ 0,0,0,0x6a30,0,0,0,0, 0,0,0x4d66,0x6a33,0,0x6a2a,0,0, /* 0,0,0,'螳',0,0,0,0, 0,0,'螺','螻',0,'螽',0,0, */
	/* 87c0 */ 0x6a2b,0,0,0,0x6a2f,0,0x6a32,0x6a31, 0,0,0,0x6a29,0,0,0,0, /* '蟀',0,0,0,'蟄',0,'蟆','蟇', 0,0,0,'蟋',0,0,0,0, */
	/* 87d0 */ 0x6a2c,0,0x6a3d,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '蟐',0,'蟒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 87e0 */ 0x6a36,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x6a34, /* '蟠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'蟯', */
	/* 87f0 */ 0,0,0x6a35,0,0,0,0x6a3a,0x6a3b, 0,0x332a,0,0x3542,0,0,0x6a39,0, /* 0,0,'蟲',0,0,0,'蟶','蟷', 0,'蟹',0,'蟻',0,0,'蟾',0, */
	/* 8800 */ 0,0,0,0,0,0x6a24,0,0, 0,0,0,0,0,0x6a38,0x6a3c,0x6a37, /* 0,0,0,0,0,'蠅',0,0, 0,0,0,0,0,'蠍','蠎','蠏', */
	/* 8810 */ 0,0x6a3e,0,0,0,0x6a40,0x6a3f,0, 0,0,0,0,0,0,0,0, /* 0,'蠑',0,0,0,'蠕','蠖',0, 0,0,0,0,0,0,0,0, */
	/* 8820 */ 0,0x6a42,0x6a41,0x695a,0,0,0,0x6a46, 0,0,0,0,0,0,0,0, /* 0,'蠡','蠢','蠣',0,0,0,'蠧', 0,0,0,0,0,0,0,0, */
	/* 8830 */ 0,0x6a43,0,0,0,0,0x6a44,0, 0,0x6a45,0,0x6a47,0,0,0,0, /* 0,'蠱',0,0,0,0,'蠶',0, 0,'蠹',0,'蠻',0,0,0,0, */
	/* 8840 */ 0x376c,0,0x6a49,0,0x6a48,0,0x3d30,0, 0,0,0,0,0x3954,0x5e27,0,0, /* '血',0,'衂',0,'衄',0,'衆',0, 0,0,0,0,'行','衍',0,0, */
	/* 8850 */ 0,0,0x6a4a,0x3d51,0,0,0,0x3339, 0,0x6a4b,0,0x3152,0,0x3e57,0x6a4c,0, /* 0,0,'衒','術',0,0,0,'街', 0,'衙',0,'衛',0,'衝','衞',0, */
	/* 8860 */ 0,0x3955,0x6a4d,0x3061,0,0,0,0, 0x493d,0,0,0x6a4e,0,0,0,0, /* 0,'衡','衢','衣',0,0,0,0, '表',0,0,'衫',0,0,0,0, */
	/* 8870 */ 0x3f6a,0,0x6a55,0,0,0x6a52,0,0x436f, 0,0,0,0,0,0x6a53,0x6a50,0x365e, /* '衰',0,'衲',0,0,'衵',0,'衷', 0,0,0,0,0,'衽','衾','衿', */
	/* 8880 */ 0,0x6a4f,0x6a56,0,0,0,0,0, 0x3736,0,0,0x425e,0,0x6a5c,0,0, /* 0,'袁','袂',0,0,0,0,0, '袈',0,0,'袋',0,'袍',0,0, */
	/* 8890 */ 0,0,0x6a58,0,0,0,0x4235,0x6a57, 0,0x6a5a,0,0,0,0,0x6a51,0, /* 0,0,'袒',0,0,0,'袖','袗', 0,'袙',0,0,0,0,'袞',0, */
	/* 88a0 */ 0,0,0x6a5b,0,0x6a5d,0,0,0, 0,0,0,0x486f,0,0,0x6a59,0, /* 0,0,'袢',0,'袤',0,0,0, 0,0,0,'被',0,0,'袮',0, */
	/* 88b0 */ 0x6a5e,0x6a60,0,0,0x3853,0x6a54,0,0x3041, 0,0,0,0,0,0,0,0x6a5f, /* '袰','袱',0,0,'袴','袵',0,'袷', 0,0,0,0,0,0,0,'袿', */
	/* 88c0 */ 0,0x3a5b,0x4e76,0x6a61,0x6a62,0x4175,0,0, 0,0,0,0,0,0,0,0x4e22, /* 0,'裁','裂','裃','裄','装',0,0, 0,0,0,0,0,0,0,'裏', */
	/* 88d0 */ 0,0,0,0,0x6a63,0x4d35,0,0, 0x6a64,0x6a65,0,0,0x4a64,0x6a66,0,0x3a40, /* 0,0,0,0,'裔','裕',0,0, '裘','裙',0,0,'補','裝',0,'裟', */
	/* 88e0 */ 0,0x4e23,0,0,0,0,0,0, 0x6a6b,0,0,0,0,0,0,0, /* 0,'裡',0,0,0,0,0,0, '裨',0,0,0,0,0,0,0, */
	/* 88f0 */ 0,0,0x6a6c,0x3e58,0x6a6a,0,0,0, 0x4d67,0x6a67,0,0,0x6a69,0x403d,0x3f7e,0, /* 0,0,'裲','裳','裴',0,0,0, '裸','裹',0,0,'裼','製','裾',0, */
	/* 8900 */ 0,0,0x6a68,0,0x6a6d,0,0,0x4a23, 0,0,0x6a6f,0,0x6a6e,0,0,0, /* 0,0,'褂',0,'褄',0,0,'複', 0,0,'褊',0,'褌',0,0,0, */
	/* 8910 */ 0x336c,0,0x4b2b,0x6a70,0,0,0,0, 0,0,0,0,0,0x6a7c,0x6a72,0, /* '褐',0,'褒','褓',0,0,0,0, 0,0,0,0,0,'褝','褞',0, */
	/* 8920 */ 0,0,0,0,0,0x6a73,0,0, 0,0,0x6a74,0x6a75,0,0,0,0, /* 0,0,0,0,0,'褥',0,0, 0,0,'褪','褫',0,0,0,0, */
	/* 8930 */ 0,0,0,0,0,0,0x6a79,0, 0x6a7a,0,0,0x6a78,0,0,0,0, /* 0,0,0,0,0,0,'褶',0, '褸',0,0,'褻',0,0,0,0, */
	/* 8940 */ 0,0x6a76,0,0x6a71,0x6a77,0,0,0, 0,0,0,0,0x6a7b,0x7037,0,0, /* 0,'襁',0,'襃','襄',0,0,0, 0,0,0,0,'襌','襍',0,0, */
	/* 8950 */ 0,0,0,0,0,0,0x3228,0, 0,0,0,0,0,0,0x6a7e,0x365f, /* 0,0,0,0,0,0,'襖',0, 0,0,0,0,0,0,'襞','襟', */
	/* 8960 */ 0x6a7d,0,0,0,0x6b22,0,0x6b21,0, 0,0,0x6b24,0,0,0x6b23,0,0x6b25, /* '襠',0,0,0,'襤',0,'襦',0, 0,0,'襪',0,0,'襭',0,'襯', */
	/* 8970 */ 0,0,0x3d31,0,0x6b26,0,0,0x6b27, 0,0,0,0,0,0,0x6b28,0x403e, /* 0,0,'襲',0,'襴',0,0,'襷', 0,0,0,0,0,0,'襾','西', */
	/* 8980 */ 0,0x4d57,0,0x6b29,0,0,0x4a24,0x4746, 0x6b2a,0,0x6b2b,0x382b,0,0,0,0x352c, /* 0,'要',0,'覃',0,0,'覆','覇', '覈',0,'覊','見',0,0,0,'規', */
	/* 8990 */ 0,0,0,0x6b2c,0,0,0x3b6b,0x4741, 0x6b2d,0,0x3350,0,0,0,0,0, /* 0,0,0,'覓',0,0,'視','覗', '覘',0,'覚',0,0,0,0,0, */
	/* 89a0 */ 0,0x6b2e,0,0,0,0,0x6b30,0x4d77, 0,0x6b2f,0x3f46,0,0x6b31,0,0,0x6b32, /* 0,'覡',0,0,0,0,'覦','覧', 0,'覩','親',0,'覬',0,0,'覯', */
	/* 89b0 */ 0,0,0x6b33,0x3451,0,0,0,0, 0,0,0x6b34,0,0,0x6b35,0,0x6b36, /* 0,0,'覲','観',0,0,0,0, 0,0,'覺',0,0,'覽',0,'覿', */
	/* 89c0 */ 0x6b37,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '觀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 89d0 */ 0,0,0x3351,0,0,0,0,0, 0,0,0x6b38,0,0x6b39,0x6b3a,0,0, /* 0,0,'角',0,0,0,0,0, 0,0,'觚',0,'觜','觝',0,0, */
	/* 89e0 */ 0,0,0,0x3272,0,0,0x3f28,0x6b3b, 0,0,0,0,0,0,0,0, /* 0,0,0,'解',0,0,'触','觧', 0,0,0,0,0,0,0,0, */
	/* 89f0 */ 0,0,0,0,0x6b3c,0,0,0, 0x6b3d,0,0,0,0,0,0,0, /* 0,0,0,0,'觴',0,0,0, '觸',0,0,0,0,0,0,0, */
	/* 8a00 */ 0x3840,0,0x447b,0x6b3e,0,0,0,0, 0x3757,0,0x3f56,0,0x6b41,0,0x4624,0, /* '言',0,'訂','訃',0,0,0,0, '計',0,'訊',0,'訌',0,'討',0, */
	/* 8a10 */ 0x6b40,0,0,0x3731,0,0,0x6b3f,0x4277, 0x352d,0,0,0x6b42,0,0x6b43,0,0x3e59, /* '訐',0,0,'訓',0,0,'訖','託', '記',0,0,'訛',0,'訝',0,'訟', */
	/* 8a20 */ 0,0,0,0x376d,0,0x6b44,0,0, 0,0,0x4b2c,0,0,0x405f,0,0, /* 0,0,0,'訣',0,'訥',0,0, 0,0,'訪',0,0,'設',0,0, */
	/* 8a30 */ 0,0x3576,0,0x4c75,0x414a,0,0x6b45,0, 0,0,0x3f47,0x4370,0x3e5a,0,0,0, /* 0,'許',0,'訳','訴',0,'訶',0, 0,0,'診','註','証',0,0,0, */
	/* 8a40 */ 0,0x6b46,0,0,0,0,0x6b49,0, 0x6b4a,0,0,0,0,0,0,0, /* 0,'詁',0,0,0,0,'詆',0, '詈',0,0,0,0,0,0,0, */
	/* 8a50 */ 0x3a3e,0x4242,0x6b48,0,0x3e5b,0x493e,0,0, 0,0,0,0x6b47,0,0,0x3b6c,0, /* '詐','詑','詒',0,'詔','評',0,0, 0,0,0,'詛',0,0,'詞',0, */
	/* 8a60 */ 0x3153,0,0x6b4e,0x3758,0,0,0x3b6e,0, 0,0x3b6d,0,0x4f4d,0x6b4d,0x6b4c,0x4127,0, /* '詠',0,'詢','詣',0,0,'試',0, 0,'詩',0,'詫','詬','詭','詮',0, */
	/* 8a70 */ 0x354d,0x4f43,0x333a,0x3e5c,0,0,0,0, 0,0,0,0,0x6b4b,0,0,0, /* '詰','話','該','詳',0,0,0,0, 0,0,0,0,'詼',0,0,0, */
	/* 8a80 */ 0,0,0x6b50,0,0x6b51,0x6b4f,0,0x3858, 0,0x4d40,0,0,0x3b6f,0x4727,0,0, /* 0,0,'誂',0,'誄','誅',0,'誇', 0,'誉',0,0,'誌','認',0,0, */
	/* 8a90 */ 0,0x6b54,0,0x4040,0,0x4342,0,0, 0x4d36,0,0x6b57,0,0,0,0x386c,0, /* 0,'誑',0,'誓',0,'誕',0,0, '誘',0,'誚',0,0,0,'語',0, */
	/* 8aa0 */ 0x403f,0x6b53,0,0x6b58,0x386d,0x6b55,0x6b56,0, 0x6b52,0,0,0,0x4062,0x4649,0,0, /* '誠','誡',0,'誣','誤','誥','誦',0, '誨',0,0,0,'説','読',0,0, */
	/* 8ab0 */ 0x432f,0,0x325d,0,0,0,0,0, 0,0x4870,0,0,0x3543,0,0,0x4434, /* '誰',0,'課',0,0,0,0,0, 0,'誹',0,0,'誼',0,0,'調', */
	/* 8ac0 */ 0,0,0x6b5b,0,0x6b59,0,0,0x434c, 0,0,0,0x4041,0x3452,0x6b5a,0,0x3f5b, /* 0,0,'諂',0,'諄',0,0,'談', 0,0,0,'請','諌','諍',0,'諏', */
	/* 8ad0 */ 0,0,0x4e4a,0,0,0,0x4f40,0, 0,0,0x6b5c,0x6b67,0x4435,0,0x6b66,0, /* 0,0,'諒',0,0,0,'論',0, 0,0,'諚','諛','諜',0,'諞',0, */
	/* 8ae0 */ 0x6b63,0x6b6b,0x6b64,0,0x6b60,0,0x447c,0x6b5f, 0,0,0,0x6b5d,0,0x4d21,0x3b70,0, /* '諠','諡','諢',0,'諤',0,'諦','諧', 0,0,0,'諫',0,'諭','諮',0, */
	/* 8af0 */ 0,0x6b61,0,0x6b5e,0,0,0,0x6b65, 0x3d74,0,0x3841,0,0,0,0x427a,0, /* 0,'諱',0,'諳',0,0,0,'諷', '諸',0,'諺',0,0,0,'諾',0, */
	/* 8b00 */ 0x4b45,0x315a,0x3062,0,0x4625,0,0,0x6b69, 0,0,0,0,0x6b68,0,0x4666,0, /* '謀','謁','謂',0,'謄',0,0,'謇', 0,0,0,0,'謌',0,'謎',0, */
	/* 8b10 */ 0x6b6d,0,0,0,0x6b62,0,0x6b6c,0x6b6e, 0,0x382c,0x6b6a,0x3956,0,0x3c55,0,0, /* '謐',0,0,0,'謔',0,'謖','謗', 0,'謙','謚','講',0,'謝',0,0, */
	/* 8b20 */ 0x6b6f,0x4d58,0,0,0,0,0x6b72,0, 0x6b75,0,0,0x6b73,0x4935,0,0,0, /* '謠','謡',0,0,0,0,'謦',0, '謨',0,0,'謫','謬',0,0,0, */
	/* 8b30 */ 0,0,0,0x6b70,0,0,0,0, 0,0x3660,0,0,0,0,0x6b74,0, /* 0,0,0,'謳',0,0,0,0, 0,'謹',0,0,0,0,'謾',0, */
	/* 8b40 */ 0,0x6b76,0,0,0,0,0,0, 0,0x6b7a,0,0,0x6b77,0,0x6b79,0x6b78, /* 0,'譁',0,0,0,0,0,0, 0,'證',0,0,'譌',0,'譎','譏', */
	/* 8b50 */ 0,0,0,0,0,0,0x6b7b,0, 0x3c31,0,0x6b7d,0x6b7c,0x4968,0,0,0x6c21, /* 0,0,0,0,0,0,'譖',0, '識',0,'譚','譛','譜',0,0,'譟', */
	/* 8b60 */ 0,0,0,0,0,0,0x3759,0, 0,0,0,0x6b7e,0x6c22,0,0,0x6c23, /* 0,0,0,0,0,0,'警',0, 0,0,0,'譫','譬',0,0,'譯', */
	/* 8b70 */ 0x3544,0x6641,0x3e79,0,0x6c24,0,0,0x386e, 0,0,0,0,0,0x6c25,0,0, /* '議','譱','譲',0,'譴',0,0,'護', 0,0,0,0,0,'譽',0,0, */
	/* 8b80 */ 0x6c26,0,0,0x3b3e,0,0,0,0, 0,0,0x5a4e,0,0x6c27,0,0x6c28,0, /* '讀',0,0,'讃',0,0,0,0, 0,0,'變',0,'讌',0,'讎',0, */
	/* 8b90 */ 0x3d32,0,0x6c29,0x6c2a,0,0,0x6c2b,0, 0,0x6c2c,0x6c2d,0,0,0,0,0, /* '讐',0,'讒','讓',0,0,'讖',0, 0,'讙','讚',0,0,0,0,0, */
	/* 8ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c30 */ 0,0,0,0,0,0,0,0x432b, 0,0,0x6c2e,0,0,0,0,0x6c30, /* 0,0,0,0,0,0,0,'谷', 0,0,'谺',0,0,0,0,'谿', */
	/* 8c40 */ 0,0x6c2f,0,0,0,0,0x4626,0, 0x6c31,0,0x4b2d,0,0x6c32,0,0x6c33,0, /* 0,'豁',0,0,0,0,'豆',0, '豈',0,'豊',0,'豌',0,'豎',0, */
	/* 8c50 */ 0x6c34,0,0,0,0,0x6c35,0,0, 0,0,0x465a,0,0,0,0,0, /* '豐',0,0,0,0,'豕',0,0, 0,0,'豚',0,0,0,0,0, */
	/* 8c60 */ 0,0x3e5d,0x6c36,0,0,0,0,0, 0,0,0x396b,0x502e,0x6c37,0,0,0, /* 0,'象','豢',0,0,0,0,0, 0,0,'豪','豫','豬',0,0,0, */
	/* 8c70 */ 0,0,0,0,0,0,0,0, 0x6c38,0x493f,0x6c39,0,0x6c41,0,0,0, /* 0,0,0,0,0,0,0,0, '豸','豹','豺',0,'豼',0,0,0, */
	/* 8c80 */ 0,0,0x6c3a,0,0,0x6c3c,0,0, 0,0x6c3b,0x6c3d,0,0x4b46,0x6c3e,0x6c3f,0, /* 0,0,'貂',0,0,'貅',0,0, 0,'貉','貊',0,'貌','貍','貎',0, */
	/* 8c90 */ 0,0,0,0,0x6c40,0,0,0, 0x6c42,0,0,0,0,0x332d,0x4467,0, /* 0,0,0,0,'貔',0,0,0, '貘',0,0,0,0,'貝','貞',0, */
	/* 8ca0 */ 0x4969,0x3a62,0x3957,0,0,0,0,0x494f, 0x325f,0x484e,0x6c45,0x3453,0x4055,0x6c44,0x6c49,0x4379, /* '負','財','貢',0,0,0,0,'貧', '貨','販','貪','貫','責','貭','貮','貯', */
	/* 8cb0 */ 0x4c63,0,0x6c47,0x6c48,0x352e,0,0x6c4a,0x4763, 0x425f,0,0,0x4871,0x453d,0x6c46,0,0x4b47, /* '貰',0,'貲','貳','貴',0,'貶','買', '貸',0,0,'費','貼','貽',0,'貿', */
	/* 8cc0 */ 0x326c,0x6c4c,0x4f28,0x4442,0x4f45,0,0,0x3b71, 0x6c4b,0,0x4231,0,0,0x6c5c,0x4128,0, /* '賀','賁','賂','賃','賄',0,0,'資', '賈',0,'賊',0,0,'賍','賎',0, */
	/* 8cd0 */ 0,0x4678,0,0x4950,0,0,0,0, 0,0,0x6c4f,0x3b3f,0x3b72,0,0x3e5e,0, /* 0,'賑',0,'賓',0,0,0,0, 0,0,'賚','賛','賜',0,'賞',0, */
	/* 8ce0 */ 0x4765,0,0x382d,0x6c4e,0x6c4d,0,0x496a,0, 0,0,0x3c41,0,0,0x4552,0,0, /* '賠',0,'賢','賣','賤',0,'賦',0, 0,0,'質',0,0,'賭',0,0, */
	/* 8cf0 */ 0,0,0,0,0,0,0,0, 0,0,0x6c51,0x6c52,0x3958,0x6c50,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'賺','賻','購','賽',0,0, */
	/* 8d00 */ 0,0,0,0,0x6c53,0x6c54,0,0x6c56, 0x4223,0,0x6c55,0x3466,0,0x6c58,0,0x6c57, /* 0,0,0,0,'贄','贅',0,'贇', '贈',0,'贊','贋',0,'贍',0,'贏', */
	/* 8d10 */ 0x6c59,0,0,0x6c5b,0x6c5d,0,0x6c5e,0, 0,0,0,0,0,0,0,0, /* '贐',0,0,'贓','贔',0,'贖',0, 0,0,0,0,0,0,0,0, */
	/* 8d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d60 */ 0,0,0,0,0x4056,0,0x3c4f,0x6c5f, 0,0,0,0x3352,0,0x6c60,0,0, /* 0,0,0,0,'赤',0,'赦','赧', 0,0,0,'赫',0,'赭',0,0, */
	/* 8d70 */ 0x4176,0x6c61,0,0x6c62,0x496b,0,0,0x352f, 0,0,0,0,0,0,0,0, /* '走','赱',0,'赳','赴',0,0,'起', 0,0,0,0,0,0,0,0, */
	/* 8d80 */ 0,0x6c63,0,0,0,0x4436,0,0, 0,0,0x315b,0,0,0,0,0, /* 0,'趁',0,0,0,'超',0,0, 0,0,'越',0,0,0,0,0, */
	/* 8d90 */ 0,0,0,0,0,0,0,0, 0,0x6c64,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'趙',0,0,0,0,0,0, */
	/* 8da0 */ 0,0,0,0x3c71,0,0,0,0, 0x3f76,0,0,0,0,0,0,0, /* 0,0,0,'趣',0,0,0,0, '趨',0,0,0,0,0,0,0, */
	/* 8db0 */ 0,0,0,0x422d,0,0,0,0, 0,0,0x6c67,0,0,0,0x6c66,0, /* 0,0,0,'足',0,0,0,0, 0,0,'趺',0,0,0,'趾',0, */
	/* 8dc0 */ 0,0,0x6c65,0,0,0,0,0, 0,0,0,0x6c6d,0x6c6b,0,0,0x6c68, /* 0,0,'跂',0,0,0,0,0, 0,0,0,'跋','跌',0,0,'跏', */
	/* 8dd0 */ 0,0,0,0,0,0,0x6c6a,0, 0,0,0x6c69,0x6c6c,0,0x3577,0,0x6c70, /* 0,0,0,0,0,0,'跖',0, 0,0,'跚','跛',0,'距',0,'跟', */
	/* 8de0 */ 0,0x4057,0,0x6c71,0,0,0,0, 0x3859,0,0x6c6e,0x6c6f,0,0,0,0x4f29, /* 0,'跡',0,'跣',0,0,0,0, '跨',0,'跪','跫',0,0,0,'路', */
	/* 8df0 */ 0,0,0,0x4437,0,0x4129,0,0, 0,0,0,0,0x6c72,0,0,0x6c75, /* 0,0,0,'跳',0,'践',0,0, 0,0,0,0,'跼',0,0,'跿', */
	/* 8e00 */ 0,0,0,0,0,0,0,0, 0x6c73,0x6c74,0x4d59,0,0,0,0,0x4627, /* 0,0,0,0,0,0,0,0, '踈','踉','踊',0,0,0,0,'踏', */
	/* 8e10 */ 0x6c78,0,0,0,0,0,0,0, 0,0,0,0,0,0x6c76,0x6c77,0x6c79, /* '踐',0,0,0,0,0,0,0, 0,0,0,0,0,'踝','踞','踟', */
	/* 8e20 */ 0,0,0,0,0,0,0,0, 0,0,0x6d29,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'踪',0,0,0,0,0, */
	/* 8e30 */ 0x6c7c,0,0,0,0x6c7d,0x6c7b,0,0, 0,0,0,0,0,0,0,0, /* '踰',0,0,0,'踴','踵',0,0, 0,0,0,0,0,0,0,0, */
	/* 8e40 */ 0,0,0x6c7a,0,0x447d,0,0,0x6d21, 0x6d25,0x6d22,0x6c7e,0,0x6d23,0,0,0, /* 0,0,'蹂',0,'蹄',0,0,'蹇', '蹈','蹉','蹊',0,'蹌',0,0,0, */
	/* 8e50 */ 0x6d24,0,0,0,0,0x6d2b,0,0, 0,0x6d26,0,0,0,0,0,0x4058, /* '蹐',0,0,0,0,'蹕',0,0, 0,'蹙',0,0,0,0,0,'蹟', */
	/* 8e60 */ 0x6d28,0,0,0x6d2a,0x6d27,0,0,0, 0,0,0,0,0,0,0,0, /* '蹠',0,0,'蹣','蹤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8e70 */ 0,0,0x6d2d,0,0x3d33,0,0x6d2c,0, 0,0,0,0,0x6d2e,0,0,0, /* 0,0,'蹲',0,'蹴',0,'蹶',0, 0,0,0,0,'蹼',0,0,0, */
	/* 8e80 */ 0,0x6d2f,0,0,0x6d32,0x6d31,0,0x6d30, 0,0,0x6d34,0x6d33,0,0x4c76,0,0, /* 0,'躁',0,0,'躄','躅',0,'躇', 0,0,'躊','躋',0,'躍',0,0, */
	/* 8e90 */ 0,0x6d36,0,0x6d35,0x6d37,0,0,0, 0,0x6d38,0,0,0,0,0,0, /* 0,'躑',0,'躓','躔',0,0,0, 0,'躙',0,0,0,0,0,0, */
	/* 8ea0 */ 0,0x6d3a,0,0,0,0,0,0, 0,0,0x6d39,0x3f48,0x6d3b,0,0,0x366d, /* 0,'躡',0,0,0,0,0,0, 0,0,'躪','身','躬',0,0,'躯', */
	/* 8eb0 */ 0x6d3c,0x6d3e,0,0,0,0,0,0, 0,0,0,0,0,0,0x6d3f,0, /* '躰','躱',0,0,0,0,0,0, 0,0,0,0,0,0,'躾',0, */
	/* 8ec0 */ 0,0,0,0,0,0x6d40,0x6d3d,0, 0x6d41,0,0x3c56,0x6d42,0x3530,0x3733,0,0, /* 0,0,0,0,0,'軅','軆',0, '軈',0,'車','軋','軌','軍',0,0, */
	/* 8ed0 */ 0,0,0x382e,0,0,0,0,0, 0,0,0,0x6d43,0,0,0,0x4670, /* 0,0,'軒',0,0,0,0,0, 0,0,0,'軛',0,0,0,'軟', */
	/* 8ee0 */ 0,0,0x453e,0x6d44,0,0,0,0, 0,0,0,0x6d47,0,0,0,0, /* 0,0,'転','軣',0,0,0,0, 0,0,0,'軫',0,0,0,0, */
	/* 8ef0 */ 0,0,0,0,0,0,0,0, 0x3c34,0,0,0x6d46,0x6d45,0x375a,0x6d48,0, /* 0,0,0,0,0,0,0,0, '軸',0,0,'軻','軼','軽','軾',0, */
	/* 8f00 */ 0,0,0,0x3353,0,0x6d4a,0,0, 0,0x3a5c,0x6d49,0,0x6d52,0,0,0, /* 0,0,0,'較',0,'輅',0,0, 0,'載','輊',0,'輌',0,0,0, */
	/* 8f10 */ 0,0,0x6d4c,0x6d4e,0x4a65,0x6d4b,0,0, 0,0x6d4d,0,0x6d51,0x6d4f,0x3531,0,0x6d50, /* 0,0,'輒','輓','輔','輕',0,0, 0,'輙',0,'輛','輜','輝',0,'輟', */
	/* 8f20 */ 0,0,0,0,0,0,0x6d53,0, 0,0x475a,0x4e58,0,0,0,0,0x3d34, /* 0,0,0,0,0,0,'輦',0, 0,'輩','輪',0,0,0,0,'輯', */
	/* 8f30 */ 0,0,0,0x6d54,0,0,0,0, 0x4d22,0x6d56,0,0x6d55,0,0,0x6d59,0x4d41, /* 0,0,0,'輳',0,0,0,0, '輸','輹',0,'輻',0,0,'輾','輿', */
	/* 8f40 */ 0,0,0x6d58,0,0x336d,0x6d57,0x6d5c,0, 0,0x6d5b,0,0,0x6d5a,0x4532,0x6d5d,0, /* 0,0,'轂',0,'轄','轅','轆',0, 0,'轉',0,0,'轌','轍','轎',0, */
	/* 8f50 */ 0,0,0,0,0,0,0,0x6d5e, 0,0,0,0,0x6d5f,0,0,0x396c, /* 0,0,0,0,0,0,0,'轗', 0,0,0,0,'轜',0,0,'轟', */
	/* 8f60 */ 0,0x3725,0x6d60,0x6d61,0x6d62,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'轡','轢','轣','轤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0x3f49,0x6d63,0,0x3c2d,0x6d64, /* 0,0,0,0,0,0,0,0, 0,0,0,'辛','辜',0,'辞','辟', */
	/* 8fa0 */ 0,0,0,0x6d65,0,0,0,0x5221, 0x517e,0,0,0,0,0x6d66,0x6570,0x6d67, /* 0,0,0,'辣',0,0,0,'辧', '辨',0,0,0,0,'辭','辮','辯', */
	/* 8fb0 */ 0x4324,0x3f2b,0x4740,0,0,0,0,0x6d68, 0,0,0x4a55,0x4454,0x397e,0,0,0x4329, /* '辰','辱','農',0,0,0,0,'辷', 0,0,'辺','辻','込',0,0,'辿', */
	/* 8fc0 */ 0,0,0x312a,0,0x4b78,0x3f57,0,0, 0,0,0,0,0,0,0x375e,0, /* 0,0,'迂',0,'迄','迅',0,0, 0,0,0,0,0,0,'迎',0, */
	/* 8fd0 */ 0,0x3661,0,0,0x4a56,0,0,0, 0,0,0x6d69,0,0,0,0,0, /* 0,'近',0,0,'返',0,0,0, 0,0,'迚',0,0,0,0,0, */
	/* 8fe0 */ 0,0,0x6d6b,0,0,0x6d6a,0x3260,0, 0,0x4676,0x6d6c,0x4777,0,0x4533,0,0x6d6d, /* 0,0,'迢',0,0,'迥','迦',0, 0,'迩','迪','迫',0,'迭',0,'迯', */
	/* 8ff0 */ 0x3d52,0,0,0,0x6d6f,0,0,0x4c42, 0x6d7e,0x6d71,0x6d72,0,0,0x4449,0,0, /* '述',0,0,0,'迴',0,0,'迷', '迸','迹','迺',0,0,'追',0,0, */
	/* 9000 */ 0x4260,0x4177,0,0x4628,0,0x6d70,0x3555,0, 0,0,0,0x6d79,0,0x6d76,0x6e25,0x4629, /* '退','送',0,'逃',0,'逅','逆',0, 0,0,0,'逋',0,'逍','逎','透', */
	/* 9010 */ 0x4360,0x6d73,0,0x447e,0x4553,0x6d74,0x6d78,0x3f60, 0,0x4767,0x444c,0,0,0x4042,0x6d77,0x422e, /* '逐','逑',0,'逓','途','逕','逖','逗', 0,'這','通',0,0,'逝','逞','速', */
	/* 9020 */ 0x4224,0x6d75,0x3029,0x4f22,0,0,0,0x6d7a, 0,0,0,0,0,0,0x4261,0, /* '造','逡','逢','連',0,0,0,'逧', 0,0,0,0,0,0,'逮',0, */
	/* 9030 */ 0,0x3d35,0x3f4a,0,0,0x6d7c,0x6d7b,0, 0x306f,0x6d7d,0,0,0x492f,0,0x6e27,0, /* 0,'週','進',0,0,'逵','逶',0, '逸','逹',0,0,'逼',0,'逾',0, */
	/* 9040 */ 0,0x465b,0x3f6b,0,0,0x4359,0,0x3678, 0,0x6e26,0x4d37,0x313f,0,0x4a57,0x3261,0x6e21, /* 0,'遁','遂',0,0,'遅',0,'遇', 0,'遉','遊','運',0,'遍','過','遏', */
	/* 9050 */ 0x6e22,0x6e23,0x6e24,0x463b,0x4323,0x3063,0x6e28,0, 0x6e29,0x7423,0,0,0x423d,0,0x6e2a,0, /* '遐','遑','遒','道','達','違','遖',0, '遘','遙',0,0,'遜',0,'遞',0, */
	/* 9060 */ 0x3173,0x414c,0,0x382f,0,0x4d5a,0,0, 0x6e2b,0x452c,0,0,0,0x4178,0x3c57,0x6e2c, /* '遠','遡',0,'遣',0,'遥',0,0, '遨','適',0,0,0,'遭','遮','遯', */
	/* 9070 */ 0,0,0x6e2f,0,0,0x3d65,0x6e2d,0x412b, 0x412a,0,0x3064,0,0x4e4b,0x6e31,0,0x4872, /* 0,0,'遲',0,0,'遵','遶','遷', '選',0,'遺',0,'遼','遽',0,'避', */
	/* 9080 */ 0x6e33,0x6e32,0x6e30,0x6364,0x3454,0,0,0x6d6e, 0,0x6e35,0x6e34,0,0,0,0,0x6e36, /* '邀','邁','邂','邃','還',0,0,'邇', 0,'邉','邊',0,0,0,0,'邏', */
	/* 9090 */ 0,0x4d38,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'邑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 90a0 */ 0,0,0,0x4661,0,0,0x4b2e,0, 0x6e37,0,0x3c59,0,0,0,0,0x6e38, /* 0,0,0,'那',0,0,'邦',0, '邨',0,'邪',0,0,0,0,'邯', */
	/* 90b0 */ 0,0x6e39,0,0,0,0x6e3a,0,0, 0x4521,0,0,0,0,0,0,0, /* 0,'邱',0,0,0,'邵',0,0, '邸',0,0,0,0,0,0,0, */
	/* 90c0 */ 0,0x306a,0,0,0,0,0,0, 0,0,0x3959,0,0,0,0x4f3a,0, /* 0,'郁',0,0,0,0,0,0, 0,0,'郊',0,0,0,'郎',0, */
	/* 90d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x6e3e,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'郛',0,0,0,0, */
	/* 90e0 */ 0,0x3734,0x6e3b,0,0x6e3c,0,0,0, 0x4974,0,0,0,0,0x3354,0,0, /* 0,'郡','郢',0,'郤',0,0,0, '部',0,0,0,0,'郭',0,0, */
	/* 90f0 */ 0,0,0,0,0,0x4d39,0,0x363f, 0,0,0,0,0,0x4554,0,0, /* 0,0,0,0,0,'郵',0,'郷', 0,0,0,0,0,'都',0,0, */
	/* 9100 */ 0,0,0x6e3f,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'鄂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9110 */ 0,0,0x6e40,0,0,0,0,0, 0,0x6e41,0,0,0,0,0,0, /* 0,0,'鄒',0,0,0,0,0, 0,'鄙',0,0,0,0,0,0, */
	/* 9120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x4522,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'鄭',0,0, */
	/* 9130 */ 0x6e43,0,0x6e42,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '鄰',0,'鄲',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9140 */ 0,0,0,0,0,0,0,0, 0,0x4653,0x6e44,0x3d36,0x3c60,0x475b,0x4371,0, /* 0,0,0,0,0,0,0,0, 0,'酉','酊','酋','酌','配','酎',0, */
	/* 9150 */ 0,0,0x3c72,0,0x3f6c,0,0x6e45,0, 0x6e46,0,0,0,0,0,0,0, /* 0,0,'酒',0,'酔',0,'酖',0, '酘',0,0,0,0,0,0,0, */
	/* 9160 */ 0,0,0x3f5d,0x6e47,0,0x6e48,0,0, 0,0x6e49,0x4d6f,0,0x3d37,0,0,0, /* 0,0,'酢','酣',0,'酥',0,0, 0,'酩','酪',0,'酬',0,0,0, */
	/* 9170 */ 0,0,0x6e4b,0x6e4a,0,0x395a,0,0x3973, 0x3b40,0,0,0,0,0,0,0, /* 0,0,'酲','酳',0,'酵',0,'酷', '酸',0,0,0,0,0,0,0, */
	/* 9180 */ 0,0,0x6e4e,0,0,0,0,0x3d66, 0,0x6e4d,0,0x6e4c,0,0x4269,0,0, /* 0,0,'醂',0,0,0,0,'醇', 0,'醉',0,'醋',0,'醍',0,0, */
	/* 9190 */ 0x386f,0,0x4043,0,0,0,0,0x4830, 0,0,0,0,0x3d39,0,0,0, /* '醐',0,'醒',0,0,0,0,'醗', 0,0,0,0,'醜',0,0,0, */
	/* 91a0 */ 0,0,0x6e4f,0,0x3e5f,0,0,0, 0,0,0x6e52,0x6e50,0,0,0,0x6e51, /* 0,0,'醢',0,'醤',0,0,0, 0,0,'醪','醫',0,0,0,'醯', */
	/* 91b0 */ 0,0,0,0,0x6e54,0x6e53,0,0, 0x3e7a,0,0x6e55,0,0,0,0,0, /* 0,0,0,0,'醴','醵',0,0, '醸',0,'醺',0,0,0,0,0, */
	/* 91c0 */ 0x6e56,0x6e57,0,0,0,0,0x4850,0x3a53, 0x3c61,0x6e58,0,0x6e59,0x4e24,0x3d45,0x4c6e,0x4e4c, /* '釀','釁',0,0,0,0,'釆','采', '釈','釉',0,'釋','里','重','野','量', */
	/* 91d0 */ 0x6e5a,0x3662,0,0,0,0,0x6e5b,0, 0x4523,0,0,0x6e5e,0x3378,0x3f4b,0,0x6e5c, /* '釐','金',0,0,0,0,'釖',0, '釘',0,0,'釛','釜','針',0,'釟', */
	/* 91e0 */ 0,0x6e5d,0,0x4460,0,0,0x4b55,0x367c, 0,0,0,0,0,0,0,0, /* 0,'釡',0,'釣',0,0,'釦','釧', 0,0,0,0,0,0,0,0, */
	/* 91f0 */ 0,0,0,0,0,0x6e60,0x6e61,0, 0,0,0,0,0x6e5f,0,0,0x6e63, /* 0,0,0,0,0,'釵','釶',0, 0,0,0,0,'釼',0,0,'釿', */
	/* 9200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x465f,0x3343,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'鈍','鈎',0, */
	/* 9210 */ 0,0x6e67,0,0,0x6e64,0x6e66,0,0, 0,0,0,0,0,0,0x6e62,0, /* 0,'鈑',0,0,'鈔','鈕',0,0, 0,0,0,0,0,0,'鈞',0, */
	/* 9220 */ 0,0,0,0,0,0,0,0, 0,0x6f4f,0,0,0x6e65,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'鈩',0,0,'鈬',0,0,0, */
	/* 9230 */ 0,0,0,0,0x4e6b,0,0,0x385a, 0,0,0,0,0,0,0,0x6e6f, /* 0,0,0,0,'鈴',0,0,'鈷', 0,0,0,0,0,0,0,'鈿', */
	/* 9240 */ 0,0,0,0,0x4534,0x6e6a,0,0, 0x6e6d,0x6e6b,0,0x6e70,0,0,0,0, /* 0,0,0,0,'鉄','鉅',0,0, '鉈','鉉',0,'鉋',0,0,0,0, */
	/* 9250 */ 0x6e71,0,0,0,0,0,0,0x6e69, 0,0,0x6e76,0x3174,0,0,0x6e68,0, /* '鉐',0,0,0,0,0,0,'鉗', 0,0,'鉚','鉛',0,0,'鉞',0, */
	/* 9260 */ 0,0,0x482d,0,0x6e6c,0,0x3e60,0, 0,0,0,0,0,0,0,0, /* 0,0,'鉢',0,'鉤',0,'鉦',0, 0,0,0,0,0,0,0,0, */
	/* 9270 */ 0,0x395b,0,0,0,0,0,0, 0,0,0,0,0,0,0x4b48,0, /* 0,'鉱',0,0,0,0,0,0, 0,0,0,0,0,0,'鉾',0, */
	/* 9280 */ 0x3664,0,0,0x3d46,0,0x463c,0,0, 0,0,0,0,0,0,0,0, /* '銀',0,0,'銃',0,'銅',0,0, 0,0,0,0,0,0,0,0, */
	/* 9290 */ 0,0x412d,0,0x6e74,0,0x6e6e,0x6e73,0, 0x4c43,0,0x4438,0x6e75,0x6e72,0,0,0, /* 0,'銑',0,'銓',0,'銕','銖',0, '銘',0,'銚','銛','銜',0,0,0, */
	/* 92a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x412c,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'銭',0,0, */
	/* 92b0 */ 0,0,0,0,0,0,0,0x6e79, 0,0x6e78,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'銷', 0,'銹',0,0,0,0,0,0, */
	/* 92c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x6e77, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'鋏', */
	/* 92d0 */ 0,0,0x4b2f,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'鋒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 92e0 */ 0,0,0,0,0x3d7b,0,0,0, 0,0x6e7a,0x4a5f,0,0,0x3154,0,0, /* 0,0,0,0,'鋤',0,0,0, 0,'鋩','鋪',0,0,'鋭',0,0, */
	/* 92f0 */ 0,0,0x4946,0x4372,0,0,0,0, 0x3578,0,0x6e7c,0,0x395d,0,0,0, /* 0,0,'鋲','鋳',0,0,0,0, '鋸',0,'鋺',0,'鋼',0,0,0, */
	/* 9300 */ 0,0,0,0,0,0,0x3b2c,0, 0,0,0,0,0,0,0,0x6e7b, /* 0,0,0,0,0,0,'錆',0, 0,0,0,0,0,0,0,'錏', */
	/* 9310 */ 0x3f6d,0,0,0,0,0,0,0, 0x3f6e,0x6f21,0x6f23,0,0,0,0,0, /* '錐',0,0,0,0,0,0,0, '錘','錙','錚',0,0,0,0,0, */
	/* 9320 */ 0x3e7b,0,0x6f22,0x6f24,0,0,0x3653,0, 0x4945,0,0,0x3c62,0x4f23,0,0x6e7e,0x3a78, /* '錠',0,'錢','錣',0,0,'錦',0, '錨',0,0,'錫','錬',0,'錮','錯', */
	/* 9330 */ 0,0,0x4f3f,0,0,0x6f26,0,0, 0,0,0x6f25,0x6f27,0,0,0,0, /* 0,0,'録',0,0,'錵',0,0, 0,0,'錺','錻',0,0,0,0, */
	/* 9340 */ 0,0,0,0,0x6e7d,0,0,0, 0,0,0,0x4669,0,0x4555,0,0, /* 0,0,0,0,'鍄',0,0,0, 0,0,0,'鍋',0,'鍍',0,0, */
	/* 9350 */ 0,0,0,0,0x4457,0,0x6f2c,0, 0,0,0,0x4343,0x6f28,0,0,0, /* 0,0,0,0,'鍔',0,'鍖',0, 0,0,0,'鍛','鍜',0,0,0, */
	/* 9360 */ 0x6f29,0,0,0,0,0,0,0, 0,0,0,0,0x372d,0,0x6f2b,0, /* '鍠',0,0,0,0,0,0,0, 0,0,0,0,'鍬',0,'鍮',0, */
	/* 9370 */ 0,0,0,0,0,0x3830,0,0, 0,0,0,0,0x6f2a,0,0x3e61,0, /* 0,0,0,0,0,'鍵',0,0, 0,0,0,0,'鍼',0,'鍾',0, */
	/* 9380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x3379,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'鎌',0,0,0, */
	/* 9390 */ 0,0,0,0,0x6f30,0,0x3a3f,0x4179, 0,0,0x444a,0,0,0,0,0, /* 0,0,0,0,'鎔',0,'鎖','鎗', 0,0,'鎚',0,0,0,0,0, */
	/* 93a0 */ 0,0,0,0,0,0,0,0x333b, 0,0,0,0,0x6f2e,0x6f2f,0x4443,0, /* 0,0,0,0,0,0,0,'鎧', 0,0,0,0,'鎬','鎭','鎮',0, */
	/* 93b0 */ 0x6f2d,0,0,0,0,0,0,0, 0,0x6f31,0,0,0,0,0,0, /* '鎰',0,0,0,0,0,0,0, 0,'鎹',0,0,0,0,0,0, */
	/* 93c0 */ 0,0,0,0x6f37,0,0,0,0, 0x6f3a,0,0,0,0,0,0,0, /* 0,0,0,'鏃',0,0,0,0, '鏈',0,0,0,0,0,0,0, */
	/* 93d0 */ 0x6f39,0x452d,0,0,0,0,0x6f32,0x6f33, 0x6f36,0,0,0,0,0x6f38,0,0, /* '鏐','鏑',0,0,0,0,'鏖','鏗', '鏘',0,0,0,0,'鏝',0,0, */
	/* 93e0 */ 0,0x3640,0,0,0x6f3b,0x6f35,0,0, 0x6f34,0,0,0,0,0,0,0, /* 0,'鏡',0,0,'鏤','鏥',0,0, '鏨',0,0,0,0,0,0,0, */
	/* 93f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9400 */ 0,0,0,0x6f3f,0,0,0,0x6f40, 0,0,0,0,0,0,0,0, /* 0,0,0,'鐃',0,0,0,'鐇', 0,0,0,0,0,0,0,0, */
	/* 9410 */ 0x6f41,0,0,0x6f3e,0x6f3d,0,0,0, 0x3e62,0x462a,0x6f3c,0,0,0,0,0, /* '鐐',0,0,'鐓','鐔',0,0,0, '鐘','鐙','鐚',0,0,0,0,0, */
	/* 9420 */ 0,0x6f45,0,0,0,0,0,0, 0,0,0,0x6f43,0,0,0,0, /* 0,'鐡',0,0,0,0,0,0, 0,0,0,'鐫',0,0,0,0, */
	/* 9430 */ 0,0,0,0,0,0x6f44,0x6f42,0, 0x4278,0,0x6f46,0,0,0,0,0, /* 0,0,0,0,0,'鐵','鐶',0, '鐸',0,'鐺',0,0,0,0,0, */
	/* 9440 */ 0,0x6f47,0,0,0x6f49,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'鑁',0,0,'鑄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9450 */ 0,0x3455,0x6f48,0x4c7a,0,0,0,0, 0,0,0x6f54,0x6f4a,0,0,0x6f4d,0, /* 0,'鑑','鑒','鑓',0,0,0,0, 0,0,'鑚','鑛',0,0,'鑞',0, */
	/* 9460 */ 0x6f4b,0,0x6f4c,0,0,0,0,0, 0,0,0x6f4e,0,0,0,0,0, /* '鑠',0,'鑢',0,0,0,0,0, 0,0,'鑪',0,0,0,0,0, */
	/* 9470 */ 0x6f50,0,0,0,0,0x6f51,0,0x6f52, 0,0,0,0,0x6f55,0x6f53,0x6f56,0x6f58, /* '鑰',0,0,0,0,'鑵',0,'鑷', 0,0,0,0,'鑼','鑽','鑾','鑿', */
	/* 9480 */ 0,0x6f57,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'钁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9570 */ 0,0,0,0,0,0,0,0x4439, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'長', 0,0,0,0,0,0,0,0, */
	/* 9580 */ 0x4c67,0,0x6f59,0x412e,0,0,0,0x6f5a, 0,0x4a44,0x6f5b,0x332b,0,0,0,0x313c, /* '門',0,'閂','閃',0,0,0,'閇', 0,'閉','閊','開',0,0,0,'閏', */
	/* 9590 */ 0,0x3457,0,0x3456,0x6f5c,0,0x6f5d,0, 0x6f5e,0x6f5f,0,0,0,0,0,0, /* 0,'閑',0,'間','閔',0,'閖',0, '閘','閙',0,0,0,0,0,0, */
	/* 95a0 */ 0x6f60,0,0x3458,0x3355,0x395e,0x4836,0,0x6f62, 0x6f61,0,0,0,0,0x6f63,0,0, /* '閠',0,'関','閣','閤','閥',0,'閧', '閨',0,0,0,0,'閭',0,0, */
	/* 95b0 */ 0,0,0x315c,0,0,0,0,0, 0,0x6f66,0,0x6f65,0x6f64,0,0x6f67,0, /* 0,0,'閲',0,0,0,0,0, 0,'閹',0,'閻','閼',0,'閾',0, */
	/* 95c0 */ 0,0,0,0x6f6a,0,0,0,0x3047, 0,0,0x6f68,0,0x6f6c,0x6f6b,0,0, /* 0,0,0,'闃',0,0,0,'闇', 0,0,'闊',0,'闌','闍',0,0, */
	/* 95d0 */ 0,0,0,0,0x6f6e,0x6f6d,0x6f6f,0, 0x462e,0,0,0,0x6f70,0,0,0, /* 0,0,0,0,'闔','闕','闖',0, '闘',0,0,0,'關',0,0,0, */
	/* 95e0 */ 0,0x6f71,0x6f73,0,0,0x6f72,0,0, 0,0,0,0,0,0,0,0, /* 0,'闡','闢',0,0,'闥',0,0, 0,0,0,0,0,0,0,0, */
	/* 95f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x496c,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'阜',0,0,0, */
	/* 9620 */ 0,0x6f74,0,0,0,0,0,0, 0x6f75,0,0x3a65,0,0,0,0x6f76,0x6f77, /* 0,'阡',0,0,0,0,0,0, '阨',0,'阪',0,0,0,'阮','阯', */
	/* 9630 */ 0,0,0x4b49,0,0,0,0,0, 0,0,0,0x414b,0,0,0,0x3024, /* 0,0,'防',0,0,0,0,0, 0,0,0,'阻',0,0,0,'阿', */
	/* 9640 */ 0x424b,0,0x6f78,0,0x496d,0,0,0, 0,0,0,0x6f7b,0x6f79,0x395f,0,0x6f7a, /* '陀',0,'陂',0,'附',0,0,0, 0,0,0,'陋','陌','降',0,'陏', */
	/* 9650 */ 0x3842,0,0,0,0,0,0,0, 0,0,0,0x4a45,0x6f7d,0x7021,0x6f7e,0x7022, /* '限',0,0,0,0,0,0,0, 0,0,0,'陛','陜','陝','陞','陟', */
	/* 9660 */ 0,0,0x3121,0x3f58,0x3d7c,0x3459,0x7023,0, 0,0,0x4766,0,0x7025,0,0,0, /* 0,0,'院','陣','除','陥','陦',0, 0,0,'陪',0,'陬',0,0,0, */
	/* 9670 */ 0x3122,0,0x7024,0x4444,0,0x4e4d,0x462b,0x6f7c, 0x4e26,0,0x3831,0,0,0x4d5b,0,0, /* '陰',0,'陲','陳',0,'陵','陶','陷', '陸',0,'険',0,0,'陽',0,0, */
	/* 9680 */ 0,0,0,0,0,0x3679,0x4e34,0, 0x3728,0,0x4262,0x6721,0,0x7026,0x332c,0x3f6f, /* 0,0,0,0,0,'隅','隆',0, '隈',0,'隊','隋',0,'隍','階','随', */
	/* 9690 */ 0,0,0,0,0x3356,0x7028,0,0x7029, 0x7027,0x3764,0,0x3a5d,0x3e63,0,0,0, /* 0,0,0,0,'隔','隕',0,'隗', '隘','隙',0,'際','障',0,0,0, */
	/* 96a0 */ 0x3123,0,0,0x4e59,0,0,0,0x702b, 0x6e2e,0,0x702a,0,0,0,0,0, /* '隠',0,0,'隣',0,0,0,'隧', '隨',0,'險',0,0,0,0,0, */
	/* 96b0 */ 0x702e,0x702c,0x702d,0,0x702f,0,0x7030,0x4e6c, 0x7031,0x7032,0,0x4049,0x483b,0,0,0, /* '隰','隱','隲',0,'隴',0,'隶','隷', '隸','隹',0,'隻','隼',0,0,0, */
	/* 96c0 */ 0x3f7d,0x3467,0,0,0x4d3a,0x326d,0x3d38,0x385b, 0,0x7035,0,0x7034,0x3b73,0x7036,0x7033,0, /* '雀','雁',0,0,'雄','雅','集','雇', 0,'雉',0,'雋','雌','雍','雎',0, */
	/* 96d0 */ 0,0x3b28,0,0,0,0x703a,0x6a2d,0, 0,0x5256,0,0x3f77,0x7038,0,0,0, /* 0,'雑',0,0,0,'雕','雖',0, 0,'雙',0,'雛','雜',0,0,0, */
	/* 96e0 */ 0,0,0x4e25,0x4671,0,0,0,0, 0x312b,0,0x4063,0x3c36,0,0,0,0, /* 0,0,'離','難',0,0,0,0, '雨',0,'雪','雫',0,0,0,0, */
	/* 96f0 */ 0x4a37,0,0x3140,0,0,0,0x4e6d,0x4d6b, 0,0x703b,0,0x4545,0,0,0,0, /* '雰',0,'雲',0,0,0,'零','雷', 0,'雹',0,'電',0,0,0,0, */
	/* 9700 */ 0x3c7b,0,0,0,0x703c,0,0x703d,0x3f4c, 0x703e,0,0x4e6e,0,0,0x7039,0x7040,0x7042, /* '需',0,0,0,'霄',0,'霆','震', '霈',0,'霊',0,0,'霍','霎','霏', */
	/* 9710 */ 0,0x7041,0,0x703f,0,0,0x7043,0, 0,0x7044,0,0,0x417a,0,0x3262,0, /* 0,'霑',0,'霓',0,0,'霖',0, 0,'霙',0,0,'霜',0,'霞',0, */
	/* 9720 */ 0,0,0,0,0x7045,0,0,0x4c38, 0,0,0x7046,0,0,0,0,0, /* 0,0,0,0,'霤',0,0,'霧', 0,0,'霪',0,0,0,0,0, */
	/* 9730 */ 0x7047,0,0x4f2a,0,0,0,0,0, 0x5b31,0x7048,0,0,0,0x7049,0x704a,0, /* '霰',0,'露',0,0,0,0,0, '霸','霹',0,0,0,'霽','霾',0, */
	/* 9740 */ 0,0,0x704e,0,0x704b,0,0x704c,0, 0x704d,0x704f,0,0,0,0,0,0, /* 0,0,'靂',0,'靄',0,'靆',0, '靈','靉',0,0,0,0,0,0, */
	/* 9750 */ 0,0,0x4044,0,0,0,0x4c77,0, 0,0x4045,0,0,0x7050,0,0x4873,0, /* 0,0,'青',0,0,0,'靖',0, 0,'静',0,0,'靜',0,'非',0, */
	/* 9760 */ 0x7051,0x7353,0x4c4c,0,0x7052,0,0x7053,0, 0x7054,0x3357,0,0x7056,0,0x3f59,0,0, /* '靠','靡','面',0,'靤',0,'靦',0, '靨','革',0,'靫',0,'靭',0,0, */
	/* 9770 */ 0,0x7057,0,0,0x3724,0,0,0, 0,0x7058,0x705c,0,0x705a,0,0,0, /* 0,'靱',0,0,'靴',0,0,0, 0,'靹','靺',0,'靼',0,0,0, */
	/* 9780 */ 0,0x705b,0,0,0x3373,0x7059,0x705d,0, 0,0,0,0x705e,0,0x3048,0,0x705f, /* 0,'鞁',0,0,'鞄','鞅','鞆',0, 0,0,0,'鞋',0,'鞍',0,'鞏', */
	/* 9790 */ 0x7060,0,0,0,0,0,0,0, 0x3e64,0,0,0,0x7061,0,0,0, /* '鞐',0,0,0,0,0,0,0, '鞘',0,0,0,'鞜',0,0,0, */
	/* 97a0 */ 0x3547,0,0,0x7064,0,0,0x7063,0, 0x7062,0,0,0x6b71,0,0x4a5c,0,0, /* '鞠',0,0,'鞣',0,0,'鞦',0, '鞨',0,0,'鞫',0,'鞭',0,0, */
	/* 97b0 */ 0,0,0,0x7065,0x7066,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'鞳','鞴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 97c0 */ 0,0,0,0x7067,0,0,0x7068,0, 0x7069,0,0,0x706a,0,0,0,0, /* 0,0,0,'韃',0,0,'韆',0, '韈',0,0,'韋',0,0,0,0, */
	/* 97d0 */ 0,0,0,0x345a,0,0,0,0, 0,0,0,0,0x706b,0,0,0, /* 0,0,0,'韓',0,0,0,0, 0,0,0,0,'韜',0,0,0, */
	/* 97e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x706c,0x4723,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'韭','韮',0, */
	/* 97f0 */ 0,0,0x706e,0x323b,0,0x7071,0x7070,0, 0,0,0,0x3124,0,0,0,0x3641, /* 0,0,'韲','音',0,'韵','韶',0, 0,0,0,'韻',0,0,0,'響', */
	/* 9800 */ 0,0x4a47,0x443a,0x3a22,0,0x3960,0x3d67,0, 0x3f5c,0,0,0,0x7073,0,0,0x7072, /* 0,'頁','頂','頃',0,'項','順',0, '須',0,0,0,'頌',0,0,'頏', */
	/* 9810 */ 0x4d42,0x3468,0x4852,0x465c,0,0,0,0x3f7c, 0x4e4e,0,0x375b,0,0,0,0,0, /* '預','頑','頒','頓',0,0,0,'頗', '領',0,'頚',0,0,0,0,0, */
	/* 9820 */ 0,0x7076,0,0,0x7075,0,0,0, 0,0,0,0,0x4b4b,0x462c,0,0, /* 0,'頡',0,0,'頤',0,0,0, 0,0,0,0,'頬','頭',0,0, */
	/* 9830 */ 0,0,0,0,0x3150,0,0,0x7077, 0x7074,0,0,0x4951,0x4d6a,0x7078,0,0, /* 0,0,0,0,'頴',0,0,'頷', '頸',0,0,'頻','頼','頽',0,0, */
	/* 9840 */ 0,0,0,0,0,0,0x7079,0, 0,0,0,0x707b,0x426a,0x335b,0x335c,0x707a, /* 0,0,0,0,0,0,'顆',0, 0,0,0,'顋','題','額','顎','顏', */
	/* 9850 */ 0,0,0,0,0x3469,0x3832,0,0, 0x346a,0,0,0x453f,0,0,0x4e60,0, /* 0,0,0,0,'顔','顕',0,0, '願',0,0,'顛',0,0,'類',0, */
	/* 9860 */ 0,0,0,0,0,0,0,0x385c, 0,0,0,0x707c,0,0,0,0x707d, /* 0,0,0,0,0,0,0,'顧', 0,0,0,'顫',0,0,0,'顯', */
	/* 9870 */ 0x707e,0x7121,0,0x7123,0x7122,0,0,0, 0,0,0,0,0,0,0,0, /* '顰','顱',0,'顳','顴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 98a0 */ 0,0,0,0,0,0,0,0, 0x4977,0,0x7124,0,0,0,0,0x7125, /* 0,0,0,0,0,0,0,0, '風',0,'颪',0,0,0,0,'颯', */
	/* 98b0 */ 0,0x7126,0,0,0,0,0x7127,0, 0,0,0,0,0,0,0,0, /* 0,'颱',0,0,0,0,'颶',0, 0,0,0,0,0,0,0,0, */
	/* 98c0 */ 0,0,0,0x7129,0x7128,0,0x712a,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'飃','飄',0,'飆',0, 0,0,0,0,0,0,0,0, */
	/* 98d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x4874,0x664c,0,0,0x3f29, /* 0,0,0,0,0,0,0,0, 0,0,0,'飛','飜',0,0,'食', */
	/* 98e0 */ 0,0,0x3532,0,0,0,0,0, 0,0x712b,0,0x712c,0,0x522c,0x5d3b,0x4853, /* 0,0,'飢',0,0,0,0,0, 0,'飩',0,'飫',0,'飭','飮','飯', */
	/* 98f0 */ 0,0,0x307b,0,0x303b,0,0,0, 0,0,0,0,0x3b74,0x4b30,0x3e7e,0, /* 0,0,'飲',0,'飴',0,0,0, 0,0,0,0,'飼','飽','飾',0, */
	/* 9900 */ 0,0,0,0x712d,0,0x4c5f,0,0, 0,0x712e,0x4d5c,0,0x3142,0,0,0, /* 0,0,0,'餃',0,'餅',0,0, 0,'餉','養',0,'餌',0,0,0, */
	/* 9910 */ 0x3b41,0,0x712f,0x326e,0x7130,0,0,0, 0x7131,0,0,0,0,0x7133,0x7134,0, /* '餐',0,'餒','餓','餔',0,0,0, '餘',0,0,0,0,'餝','餞',0, */
	/* 9920 */ 0x7136,0x7132,0,0,0x7135,0,0,0, 0x345b,0,0,0,0x7137,0,0x7138,0, /* '餠','餡',0,0,'餤',0,0,0, '館',0,0,0,'餬',0,'餮',0, */
	/* 9930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x7139,0x713a,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'餽','餾',0, */
	/* 9940 */ 0,0,0x713b,0,0,0x713d,0,0, 0,0x713c,0,0x713f,0x7142,0,0,0, /* 0,0,'饂',0,0,'饅',0,0, 0,'饉',0,'饋','饌',0,0,0, */
	/* 9950 */ 0x713e,0x7140,0x7141,0,0,0x7143,0,0x3642, 0,0,0,0,0,0,0,0, /* '饐','饑','饒',0,0,'饕',0,'饗', 0,0,0,0,0,0,0,0, */
	/* 9960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9990 */ 0,0,0,0,0,0,0x3c73,0x7144, 0x7145,0x3961,0,0,0,0,0,0, /* 0,0,0,0,0,0,'首','馗', '馘','香',0,0,0,0,0,0, */
	/* 99a0 */ 0,0,0,0,0,0x7146,0,0, 0x333e,0,0,0,0x474f,0x7147,0x7148,0, /* 0,0,0,0,0,'馥',0,0, '馨',0,0,0,'馬','馭','馮',0, */
	/* 99b0 */ 0,0,0,0x435a,0x466b,0,0,0, 0,0,0,0,0x7149,0,0,0, /* 0,0,0,'馳','馴',0,0,0, 0,0,0,0,'馼',0,0,0, */
	/* 99c0 */ 0,0x477d,0,0,0x424c,0x3158,0x366e,0, 0x366f,0,0,0,0,0,0,0, /* 0,'駁',0,0,'駄','駅','駆',0, '駈',0,0,0,0,0,0,0, */
	/* 99d0 */ 0x4373,0x714e,0x3670,0,0,0x326f,0,0, 0x714d,0,0,0x714b,0,0x714c,0,0x714a, /* '駐','駑','駒',0,0,'駕',0,0, '駘',0,0,'駛',0,'駝',0,'駟', */
	/* 99e0 */ 0,0,0x7158,0,0,0,0,0, 0,0,0,0,0,0x714f,0x7150,0, /* 0,0,'駢',0,0,0,0,0, 0,0,0,0,0,'駭','駮',0, */
	/* 99f0 */ 0,0x7151,0x7152,0,0,0,0,0, 0x7154,0,0,0x7153,0,0,0,0x3d59, /* 0,'駱','駲',0,0,0,0,0, '駸',0,0,'駻',0,0,0,'駿', */
	/* 9a00 */ 0,0x7155,0,0,0,0x7157,0,0, 0,0,0,0,0,0,0x3533,0x7156, /* 0,'騁',0,0,0,'騅',0,0, 0,0,0,0,0,0,'騎','騏', */
	/* 9a10 */ 0,0,0x417b,0x3833,0,0,0,0, 0,0x7159,0,0,0,0,0,0, /* 0,0,'騒','験',0,0,0,0, 0,'騙',0,0,0,0,0,0, */
	/* 9a20 */ 0,0,0,0,0,0,0,0, 0x424d,0,0,0x715a,0,0,0,0, /* 0,0,0,0,0,0,0,0, '騨',0,0,'騫',0,0,0,0, */
	/* 9a30 */ 0x462d,0,0,0,0,0,0,0x715b, 0,0,0,0,0,0,0x7160,0, /* '騰',0,0,0,0,0,0,'騷', 0,0,0,0,0,0,'騾',0, */
	/* 9a40 */ 0x715e,0,0x715d,0x715f,0,0x715c,0,0, 0,0,0,0,0,0x7162,0,0, /* '驀',0,'驂','驃',0,'驅',0,0, 0,0,0,0,0,'驍',0,0, */
	/* 9a50 */ 0,0,0,0,0,0x7161,0,0x7164, 0,0,0x3643,0x7163,0,0,0,0x7165, /* 0,0,0,0,0,'驕',0,'驗', 0,0,'驚','驛',0,0,0,'驟', */
	/* 9a60 */ 0,0,0x7166,0,0x7168,0x7167,0,0, 0,0x7169,0x716b,0x716a,0,0,0,0, /* 0,0,'驢',0,'驤','驥',0,0, 0,'驩','驪','驫',0,0,0,0, */
	/* 9a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9aa0 */ 0,0,0,0,0,0,0,0, 0x397c,0,0,0,0,0x716c,0,0, /* 0,0,0,0,0,0,0,0, '骨',0,0,0,0,'骭',0,0, */
	/* 9ab0 */ 0x716d,0,0,0,0,0,0,0, 0x333c,0,0,0,0x716e,0,0,0, /* '骰',0,0,0,0,0,0,0, '骸',0,0,0,'骼',0,0,0, */
	/* 9ac0 */ 0x716f,0,0,0,0x3f71,0,0,0, 0,0,0,0,0,0,0,0x7170, /* '髀',0,0,0,'髄',0,0,0, 0,0,0,0,0,0,0,'髏', */
	/* 9ad0 */ 0,0x7171,0,0x7172,0x7173,0,0,0, 0x3962,0,0,0,0,0,0x7174,0x7175, /* 0,'髑',0,'髓','體',0,0,0, '高',0,0,0,0,0,'髞','髟', */
	/* 9ae0 */ 0,0,0x7176,0x7177,0,0,0x7178,0, 0,0,0x4831,0x717a,0,0x4926,0x717b,0x7179, /* 0,0,'髢','髣',0,0,'髦',0, 0,0,'髪','髫',0,'髭','髮','髯', */
	/* 9af0 */ 0,0x717d,0,0,0x717c,0,0,0x717e, 0,0,0,0x7221,0,0,0,0, /* 0,'髱',0,0,'髴',0,0,'髷', 0,0,0,'髻',0,0,0,0, */
	/* 9b00 */ 0,0,0,0,0,0,0x7222,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'鬆',0, 0,0,0,0,0,0,0,0, */
	/* 9b10 */ 0,0,0,0,0,0,0,0, 0x7223,0,0x7224,0,0,0,0,0x7225, /* 0,0,0,0,0,0,0,0, '鬘',0,'鬚',0,0,0,0,'鬟', */
	/* 9b20 */ 0,0,0x7226,0x7227,0,0x7228,0,0x7229, 0x722a,0x722b,0x722c,0,0,0,0x722d,0x722e, /* 0,0,'鬢','鬣',0,'鬥',0,'鬧', '鬨','鬩','鬪',0,0,0,'鬮','鬯', */
	/* 9b30 */ 0,0x5d35,0x722f,0,0,0,0,0, 0,0,0,0x6478,0x3534,0,0,0, /* 0,'鬱','鬲',0,0,0,0,0, 0,0,0,'鬻','鬼',0,0,0, */
	/* 9b40 */ 0,0x3321,0x3a32,0x7231,0x7230,0x4c25,0,0, 0,0,0,0,0,0x7233,0x7234,0x7232, /* 0,'魁','魂','魃','魄','魅',0,0, 0,0,0,0,0,'魍','魎','魏', */
	/* 9b50 */ 0,0x7235,0,0,0x4b62,0,0,0, 0x7236,0,0x357b,0,0,0,0,0, /* 0,'魑',0,0,'魔',0,0,0, '魘',0,'魚',0,0,0,0,0, */
	/* 9b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x4f25, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'魯', */
	/* 9b70 */ 0,0,0,0,0x7237,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'魴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9b80 */ 0,0,0,0x7239,0,0,0,0, 0,0,0,0,0,0,0x303e,0, /* 0,0,0,'鮃',0,0,0,0, 0,0,0,0,0,0,'鮎',0, */
	/* 9b90 */ 0,0x723a,0x4a2b,0x7238,0,0,0x723b,0x723c, 0,0,0,0,0,0,0,0x723d, /* 0,'鮑','鮒','鮓',0,0,'鮖','鮗', 0,0,0,0,0,0,0,'鮟', */
	/* 9ba0 */ 0x723e,0,0,0,0,0,0,0, 0x723f,0,0x4b6e,0x3b2d,0,0x3a7a,0x412f,0, /* '鮠',0,0,0,0,0,0,0, '鮨',0,'鮪','鮫',0,'鮭','鮮',0, */
	/* 9bb0 */ 0,0,0,0,0x7240,0,0,0, 0,0x7243,0,0,0,0,0,0, /* 0,0,0,0,'鮴',0,0,0, 0,'鮹',0,0,0,0,0,0, */
	/* 9bc0 */ 0x7241,0,0,0,0,0,0x7244,0, 0,0x3871,0x7242,0,0,0,0,0x7245, /* '鯀',0,0,0,0,0,'鯆',0, 0,'鯉','鯊',0,0,0,0,'鯏', */
	/* 9bd0 */ 0,0x7246,0x7247,0,0x724b,0,0x3b2a,0, 0,0,0,0x4264,0,0,0,0, /* 0,'鯑','鯒',0,'鯔',0,'鯖',0, 0,0,0,'鯛',0,0,0,0, */
	/* 9be0 */ 0,0x724c,0x7249,0x7248,0x724a,0,0,0, 0x375f,0,0,0,0,0,0,0, /* 0,'鯡','鯢','鯣','鯤',0,0,0, '鯨',0,0,0,0,0,0,0, */
	/* 9bf0 */ 0x7250,0x724f,0x724e,0,0,0x3033,0,0, 0,0,0,0,0,0,0,0, /* '鯰','鯱','鯲',0,0,'鯵',0,0, 0,0,0,0,0,0,0,0, */
	/* 9c00 */ 0,0,0,0,0x725a,0,0x7256,0, 0x7257,0x7253,0x7259,0,0x7255,0x3362,0,0, /* 0,0,0,0,'鰄',0,'鰆',0, '鰈','鰉','鰊',0,'鰌','鰍',0,0, */
	/* 9c10 */ 0x4f4c,0,0x7258,0x7254,0x7252,0x7251,0,0, 0,0,0,0x725c,0,0,0,0, /* '鰐',0,'鰒','鰓','鰔','鰕',0,0, 0,0,0,'鰛',0,0,0,0, */
	/* 9c20 */ 0,0x725f,0,0,0x725e,0x725d,0,0, 0,0,0,0,0,0x4949,0x725b,0x3073, /* 0,'鰡',0,0,'鰤','鰥',0,0, 0,0,0,0,0,'鰭','鰮','鰯', */
	/* 9c30 */ 0x7260,0,0x7262,0,0,0,0,0, 0,0x336f,0x724d,0x3137,0,0,0x7264,0, /* '鰰',0,'鰲',0,0,0,0,0, 0,'鰹','鰺','鰻',0,0,'鰾',0, */
	/* 9c40 */ 0,0,0,0,0,0,0x7263,0x7261, 0x432d,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'鱆','鱇', '鱈',0,0,0,0,0,0,0, */
	/* 9c50 */ 0,0,0x4b70,0,0,0,0,0x4e5a, 0,0,0x7265,0,0,0,0,0, /* 0,0,'鱒',0,0,0,0,'鱗', 0,0,'鱚',0,0,0,0,0, */
	/* 9c60 */ 0x7266,0,0,0,0,0,0,0x7267, 0,0,0,0,0,0,0,0, /* '鱠',0,0,0,0,0,0,'鱧', 0,0,0,0,0,0,0,0, */
	/* 9c70 */ 0,0,0,0,0,0,0x7268,0, 0x7269,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'鱶',0, '鱸',0,0,0,0,0,0,0, */
	/* 9c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ce0 */ 0,0,0,0,0,0x443b,0,0x726a, 0,0x4837,0,0x726f,0x726b,0,0,0, /* 0,0,0,0,0,'鳥',0,'鳧', 0,'鳩',0,'鳫','鳬',0,0,0, */
	/* 9cf0 */ 0x726c,0,0,0x4b31,0x4c44,0,0x4650,0, 0,0,0,0,0,0,0,0, /* '鳰',0,0,'鳳','鳴',0,'鳶',0, 0,0,0,0,0,0,0,0, */
	/* 9d00 */ 0,0,0,0x7270,0,0,0x7271,0x463e, 0x726e,0x726d,0,0,0,0,0x322a,0, /* 0,0,0,'鴃',0,0,'鴆','鴇', '鴈','鴉',0,0,0,0,'鴎',0, */
	/* 9d10 */ 0,0,0x7279,0,0,0x7278,0,0, 0,0,0,0x3175,0,0,0,0x7276, /* 0,0,'鴒',0,0,'鴕',0,0, 0,0,0,'鴛',0,0,0,'鴟', */
	/* 9d20 */ 0,0,0,0x7275,0,0,0x7273,0, 0x337b,0,0x7272,0x3c32,0x3229,0,0,0, /* 0,0,0,'鴣',0,0,'鴦',0, '鴨',0,'鴪','鴫','鴬',0,0,0, */
	/* 9d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0x3963,0,0,0x727c,0x727b, /* 0,0,0,0,0,0,0,0, 0,0,0,'鴻',0,0,'鴾','鴿', */
	/* 9d40 */ 0,0x727a,0,0,0x7277,0,0x727d,0, 0x727e,0,0,0,0,0,0,0, /* 0,'鵁',0,0,'鵄',0,'鵆',0, '鵈',0,0,0,0,0,0,0, */
	/* 9d50 */ 0x7325,0x7324,0,0,0,0,0,0, 0,0x7326,0,0,0x312d,0x7321,0x7322,0, /* '鵐','鵑',0,0,0,0,0,0, 0,'鵙',0,0,'鵜','鵝','鵞',0, */
	/* 9d60 */ 0x3974,0x4c39,0,0,0x7323,0,0,0, 0,0,0,0,0x4b32,0,0,0x732b, /* '鵠','鵡',0,0,'鵤',0,0,0, 0,0,0,0,'鵬',0,0,'鵯', */
	/* 9d70 */ 0,0,0x7327,0,0,0,0,0, 0,0,0x732c,0,0,0,0,0, /* 0,0,'鵲',0,0,0,0,0, 0,0,'鵺',0,0,0,0,0, */
	/* 9d80 */ 0,0,0,0,0,0,0,0x7329, 0,0x7328,0,0,0,0,0,0x375c, /* 0,0,0,0,0,0,0,'鶇', 0,'鶉',0,0,0,0,0,'鶏', */
	/* 9d90 */ 0,0,0,0,0,0,0,0, 0,0,0x732d,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'鶚',0,0,0,0,0, */
	/* 9da0 */ 0,0,0,0,0x732e,0,0,0, 0,0x732f,0,0x732a,0,0,0,0x7274, /* 0,0,0,0,'鶤',0,0,0, 0,'鶩',0,'鶫',0,0,0,'鶯', */
	/* 9db0 */ 0,0,0x7330,0,0x4461,0,0,0, 0x7334,0,0x7335,0x7333,0,0,0,0, /* 0,0,'鶲',0,'鶴',0,0,0, '鶸',0,'鶺','鶻',0,0,0,0, */
	/* 9dc0 */ 0,0x7332,0x7338,0,0x7331,0,0x7336,0, 0,0,0,0,0,0,0,0x7337, /* 0,'鷁','鷂',0,'鷄',0,'鷆',0, 0,0,0,0,0,0,0,'鷏', */
	/* 9dd0 */ 0,0,0,0x733a,0,0,0,0, 0,0x7339,0,0,0,0,0,0, /* 0,0,0,'鷓',0,0,0,0, 0,'鷙',0,0,0,0,0,0, */
	/* 9de0 */ 0,0,0,0,0,0,0x733c,0, 0,0,0,0,0,0x733d,0,0x733e, /* 0,0,0,0,0,0,'鷦',0, 0,0,0,0,0,'鷭',0,'鷯', */
	/* 9df0 */ 0,0,0x4f49,0,0,0,0,0, 0x733b,0x426b,0x3a6d,0,0,0x733f,0,0, /* 0,0,'鷲',0,0,0,0,0, '鷸','鷹','鷺',0,0,'鷽',0,0, */
	/* 9e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e10 */ 0,0,0,0,0,0,0,0, 0,0,0x7340,0x7341,0,0,0x7342,0, /* 0,0,0,0,0,0,0,0, 0,0,'鸚','鸛',0,0,'鸞',0, */
	/* 9e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e70 */ 0,0,0,0,0,0x7343,0,0, 0x3834,0x7344,0,0,0,0x7345,0,0x3c2f, /* 0,0,0,0,0,'鹵',0,0, '鹸','鹹',0,0,0,'鹽',0,'鹿', */
	/* 9e80 */ 0,0x7346,0,0,0,0,0,0, 0x7347,0,0,0x7348,0x7349,0,0,0, /* 0,'麁',0,0,0,0,0,0, '麈',0,0,'麋','麌',0,0,0, */
	/* 9e90 */ 0,0x734c,0x734a,0x4f3c,0,0x734b,0,0x4e6f, 0,0,0,0,0,0x734d,0,0x4e5b, /* 0,'麑','麒','麓',0,'麕',0,'麗', 0,0,0,0,0,'麝',0,'麟', */
	/* 9ea0 */ 0,0,0,0,0,0x734e,0x477e,0, 0,0x734f,0x7351,0,0,0x7352,0,0, /* 0,0,0,0,0,'麥','麦',0, 0,'麩','麪',0,0,'麭',0,0, */
	/* 9eb0 */ 0,0,0,0,0,0,0,0, 0x7350,0x396d,0x4c4d,0x4b63,0x5677,0,0x5d60,0x4b7b, /* 0,0,0,0,0,0,0,0, '麸','麹','麺','麻','麼',0,'麾','麿', */
	/* 9ec0 */ 0,0,0,0,0x322b,0,0,0, 0,0,0,0,0x7354,0x3550,0x7355,0x7356, /* 0,0,0,0,'黄',0,0,0, 0,0,0,0,'黌','黍','黎','黏', */
	/* 9ed0 */ 0x7357,0,0x3975,0,0x7358,0,0,0, 0x6054,0x4c5b,0,0x4263,0x7359,0x735b,0x735a,0, /* '黐',0,'黒',0,'黔',0,0,0, '默','黙',0,'黛','黜','黝','點',0, */
	/* 9ee0 */ 0x735c,0,0,0,0,0x735d,0,0, 0x735e,0,0,0,0,0,0,0x735f, /* '黠',0,0,0,0,'黥',0,0, '黨',0,0,0,0,0,0,'黯', */
	/* 9ef0 */ 0,0,0,0,0x7360,0,0x7361,0x7362, 0,0x7363,0,0x7364,0x7365,0x7366,0,0, /* 0,0,0,0,'黴',0,'黶','黷', 0,'黹',0,'黻','黼','黽',0,0, */
	/* 9f00 */ 0,0,0,0,0,0,0,0x7367, 0x7368,0,0,0,0,0,0x4524,0, /* 0,0,0,0,0,0,0,'鼇', '鼈',0,0,0,0,0,'鼎',0, */
	/* 9f10 */ 0,0,0,0x385d,0,0x736a,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'鼓',0,'鼕',0,0, 0,0,0,0,0,0,0,0, */
	/* 9f20 */ 0x414d,0x736b,0,0,0,0,0,0, 0,0,0,0,0x736c,0,0,0, /* '鼠','鼡',0,0,0,0,0,0, 0,0,0,0,'鼬',0,0,0, */
	/* 9f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0x4921,0,0,0x736d,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'鼻',0,0,'鼾',0, */
	/* 9f40 */ 0,0,0,0,0,0,0,0, 0,0,0x736e,0x6337,0,0,0x6c5a,0x706d, /* 0,0,0,0,0,0,0,0, 0,0,'齊','齋',0,0,'齎','齏', */
	/* 9f50 */ 0,0,0x736f,0,0x7370,0,0,0, 0,0,0,0,0,0,0,0x7372, /* 0,0,'齒',0,'齔',0,0,0, 0,0,0,0,0,0,0,'齟', */
	/* 9f60 */ 0x7373,0x7374,0x4e70,0x7371,0,0,0x7375,0x7376, 0,0,0x7378,0,0x7377,0,0,0, /* '齠','齡','齢','齣',0,0,'齦','齧', 0,0,'齪',0,'齬',0,0,0, */
	/* 9f70 */ 0,0,0x737a,0,0,0,0x737b,0x7379, 0,0,0,0,0,0,0,0, /* 0,0,'齲',0,0,0,'齶','齷', 0,0,0,0,0,0,0,0, */
	/* 9f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x4e36,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'龍',0,0, */
	/* 9f90 */ 0,0,0,0,0,0x737c,0,0, 0,0,0,0,0x737d,0x6354,0,0, /* 0,0,0,0,0,'龕',0,0, 0,0,0,0,'龜','龝',0,0, */
	/* 9fa0 */ 0x737e,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '龠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ace0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ada0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* add0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ade0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* beb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ceb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ced0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* deb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ded0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* def0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ead0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ece0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ede0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* feb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ff00 */ 0,0x212a,0,0x2174,0x2170,0x2173,0x2175,0, 0x214a,0x214b,0x2176,0x215c,0x2124,0,0x2125,0x213f, /* 0,'！',0,'＃','＄','％','＆',0, '（','）','＊','＋','，',0,'．','／', */
	/* ff10 */ 0x2330,0x2331,0x2332,0x2333,0x2334,0x2335,0x2336,0x2337, 0x2338,0x2339,0x2127,0x2128,0x2163,0x2161,0x2164,0x2129, /* '０','１','２','３','４','５','６','７', '８','９','：','；','＜','＝','＞','？', */
	/* ff20 */ 0x2177,0x2341,0x2342,0x2343,0x2344,0x2345,0x2346,0x2347, 0x2348,0x2349,0x234a,0x234b,0x234c,0x234d,0x234e,0x234f, /* '＠','Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ', 'Ｈ','Ｉ','Ｊ','Ｋ','Ｌ','Ｍ','Ｎ','Ｏ', */
	/* ff30 */ 0x2350,0x2351,0x2352,0x2353,0x2354,0x2355,0x2356,0x2357, 0x2358,0x2359,0x235a,0x214e,0x2140,0x214f,0x2130,0x2132, /* 'Ｐ','Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ', 'Ｘ','Ｙ','Ｚ','［','＼','］','＾','＿', */
	/* ff40 */ 0x212e,0x2361,0x2362,0x2363,0x2364,0x2365,0x2366,0x2367, 0x2368,0x2369,0x236a,0x236b,0x236c,0x236d,0x236e,0x236f, /* '｀','ａ','ｂ','ｃ','ｄ','ｅ','ｆ','ｇ', 'ｈ','ｉ','ｊ','ｋ','ｌ','ｍ','ｎ','ｏ', */
	/* ff50 */ 0x2370,0x2371,0x2372,0x2373,0x2374,0x2375,0x2376,0x2377, 0x2378,0x2379,0x237a,0x2150,0x2143,0x2151,0,0, /* 'ｐ','ｑ','ｒ','ｓ','ｔ','ｕ','ｖ','ｗ', 'ｘ','ｙ','ｚ','｛','｜','｝',0,0, */
	/* ff60 */ 0,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, 0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* 0,'｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* ff70 */ 0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, 0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* ff80 */ 0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, 0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* ff90 */ 0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, 0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
	/* ffa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffe0 */ 0,0,0,0x2131,0,0x216f, /* 0,0,0,'￣',0,'￥', */
};

const size_t _unibe2jis2022jp_table_size = sizeof(_unibe2jis2022jp_table) / sizeof(_unibe2jis2022jp_table[0]);

#endif /* #ifndef __UNIBE2JIS2022_JP_TABLE_H_ */
