/*
 * _unibe2jis2022jp_table_bits.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __UNIBE2JIS2022_JP_TABLE_BITS_H_
#define __UNIBE2JIS2022_JP_TABLE_BITS_H_

#include <stddef.h>
#include <stdint.h>

const char _unibe2jis2022jp_table_bits[] = {
	/* 0000 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	/* 0010 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	/* 0020 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* ' ','!','"','#','$','%','&','\'', '(',')','*','+',',','-','.','/', */
	/* 0030 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* '0','1','2','3','4','5','6','7', '8','9',':',';','<','=','>','?', */
	/* 0040 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O', */
	/* 0050 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* 'P','Q','R','S','T','U','V','W', 'X','Y','Z','[','\\',']','^','_', */
	/* 0060 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* '`','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o', */
	/* 0070 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0,-1, /* 'p','q','r','s','t','u','v','w', 'x','y','z','{','|','}','~',0, */
	/* 0080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00a0 */ -1,-1, 4, 4,-1,-1,-1, 4,  4,-1,-1,-1, 4,0,0,0, /* 0,0,'¢','£',0,0,0,'§', '¨',0,0,0,'¬',0,0,0, */
	/* 00b0 */  4, 4,-1,-1, 4,-1, 4,0, 0,0,0,0,0,0,0,0, /* '°','±',0,0,'´',0,'¶',0, 0,0,0,0,0,0,0,0, */
	/* 00c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00d0 */ -1,-1,-1,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'×', 0,0,0,0,0,0,0,0, */
	/* 00e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00f0 */ -1,-1,-1,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'÷', 0,0,0,0,0,0,0,0, */
	/* 0100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0390 */ -1, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'Α','Β','Γ','Δ','Ε','Ζ','Η', 'Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο', */
	/* 03a0 */  4, 4,-1, 4, 4, 4, 4, 4,  4, 4,0,0,0,0,0,0, /* 'Π','Ρ',0,'Σ','Τ','Υ','Φ','Χ', 'Ψ','Ω',0,0,0,0,0,0, */
	/* 03b0 */ -1, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'α','β','γ','δ','ε','ζ','η', 'θ','ι','κ','λ','μ','ν','ξ','ο', */
	/* 03c0 */  4, 4,-1, 4, 4, 4, 4, 4,  4, 4,0,0,0,0,0,0, /* 'π','ρ',0,'σ','τ','υ','φ','χ', 'ψ','ω',0,0,0,0,0,0, */
	/* 03d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0400 */ -1, 4,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'Ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0410 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'А','Б','В','Г','Д','Е','Ж','З', 'И','Й','К','Л','М','Н','О','П', */
	/* 0420 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'Р','С','Т','У','Ф','Х','Ц','Ч', 'Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я', */
	/* 0430 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'а','б','в','г','д','е','ж','з', 'и','й','к','л','м','н','о','п', */
	/* 0440 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'р','с','т','у','ф','х','ц','ч', 'ш','щ','ъ','ы','ь','э','ю','я', */
	/* 0450 */ -1, 4,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2010 */  4,-1,-1,-1,-1, 4, 4,-1,  4, 4,-1,-1, 4, 4,0,0, /* '‐',0,0,0,0,'―','‖',0, '‘','’',0,0,'“','”',0,0, */
	/* 2020 */  4, 4,-1,-1,-1, 4, 4,0, 0,0,0,0,0,0,0,0, /* '†','‡',0,0,0,'‥','…',0, 0,0,0,0,0,0,0,0, */
	/* 2030 */  4,-1, 4, 4,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 3,0, /* '‰',0,'′','″',0,0,0,0, 0,0,0,'※',0,0,'‾',0, */
	/* 2040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2100 */ -1,-1,-1, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'℃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'Å',0,0,0,0, */
	/* 2130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2190 */  4, 4, 4, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* '←','↑','→','↓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21d0 */ -1,-1, 4,-1, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⇒',0,'⇔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2200 */  4,-1, 4, 4,-1,-1,-1, 4,  4,-1,-1, 4,0,0,0,0, /* '∀',0,'∂','∃',0,0,0,'∇', '∈',0,0,'∋',0,0,0,0, */
	/* 2210 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4, 4,0, /* 0,0,'−',0,0,0,0,0, 0,0,'√',0,0,'∝','∞',0, */
	/* 2220 */  4,-1,-1,-1,-1,-1,-1, 4,  4, 4, 4, 4, 4,0,0,0, /* '∠',0,0,0,0,0,0,'∧', '∨','∩','∪','∫','∬',0,0,0, */
	/* 2230 */ -1,-1,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,'∴','∵',0,0, 0,0,0,0,0,'∽',0,0, */
	/* 2240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2250 */ -1,-1, 4,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'≒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2260 */  4, 4,-1,-1,-1,-1, 4, 4, -1,-1, 4, 4,0,0,0,0, /* '≠','≡',0,0,0,0,'≦','≧', 0,0,'≪','≫',0,0,0,0, */
	/* 2270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2280 */ -1,-1, 4, 4,-1,-1, 4, 4, 0,0,0,0,0,0,0,0, /* 0,0,'⊂','⊃',0,0,'⊆','⊇', 0,0,0,0,0,0,0,0, */
	/* 2290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22a0 */ -1,-1,-1,-1,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⊥',0,0, 0,0,0,0,0,0,0,0, */
	/* 22b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2310 */ -1,-1, 4,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⌒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2500 */  4, 4, 4, 4,-1,-1,-1,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* '─','━','│','┃',0,0,0,0, 0,0,0,0,'┌',0,0,'┏', */
	/* 2510 */  4,-1,-1, 4, 4,-1,-1, 4,  4,-1,-1, 4, 4, 4,0,0, /* '┐',0,0,'┓','└',0,0,'┗', '┘',0,0,'┛','├','┝',0,0, */
	/* 2520 */  4,-1,-1, 4, 4, 4,-1,-1,  4,-1,-1, 4, 4,-1,-1, 4, /* '┠',0,0,'┣','┤','┥',0,0, '┨',0,0,'┫','┬',0,0,'┯', */
	/* 2530 */  4,-1,-1, 4, 4,-1,-1, 4,  4,-1,-1, 4, 4,-1,-1, 4, /* '┰',0,0,'┳','┴',0,0,'┷', '┸',0,0,'┻','┼',0,0,'┿', */
	/* 2540 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,0,'╂',0,0,0,0,0, 0,0,0,'╋',0,0,0,0, */
	/* 2550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25a0 */  4, 4,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '■','□',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25b0 */ -1,-1, 4, 4,-1,-1,-1,-1, -1,-1,-1,-1, 4, 4,0,0, /* 0,0,'▲','△',0,0,0,0, 0,0,0,0,'▼','▽',0,0, */
	/* 25c0 */ -1,-1,-1,-1,-1,-1, 4, 4, -1,-1,-1, 4,-1,-1, 4, 4, /* 0,0,0,0,0,0,'◆','◇', 0,0,0,'○',0,0,'◎','●', */
	/* 25d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'◯', */
	/* 25f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2600 */ -1,-1,-1,-1,-1, 4, 4,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'★','☆',0, 0,0,0,0,0,0,0,0, */
	/* 2610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2640 */  4,-1, 4,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '♀',0,'♂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,'♪',0,0,'♭',0,'♯', */
	/* 2670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3000 */  4, 4, 4, 4,-1, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '　','、','。','〃',0,'々','〆','〇', '〈','〉','《','》','「','」','『','』', */
	/* 3010 */  4, 4, 4, 4, 4, 4,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* '【','】','〒','〓','〔','〕',0,0, 0,0,0,0,'〜',0,0,0, */
	/* 3020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3040 */ -1, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'ぁ','あ','ぃ','い','ぅ','う','ぇ', 'え','ぉ','お','か','が','き','ぎ','く', */
	/* 3050 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ぐ','け','げ','こ','ご','さ','ざ','し', 'じ','す','ず','せ','ぜ','そ','ぞ','た', */
	/* 3060 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'だ','ち','ぢ','っ','つ','づ','て','で', 'と','ど','な','に','ぬ','ね','の','は', */
	/* 3070 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ば','ぱ','ひ','び','ぴ','ふ','ぶ','ぷ', 'へ','べ','ぺ','ほ','ぼ','ぽ','ま','み', */
	/* 3080 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'む','め','も','ゃ','や','ゅ','ゆ','ょ', 'よ','ら','り','る','れ','ろ','ゎ','わ', */
	/* 3090 */  4, 4, 4, 4,-1,-1,-1,-1, -1,-1,-1, 4, 4, 4, 4,0, /* 'ゐ','ゑ','を','ん',0,0,0,0, 0,0,0,'゛','゜','ゝ','ゞ',0, */
	/* 30a0 */ -1, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'ァ','ア','ィ','イ','ゥ','ウ','ェ', 'エ','ォ','オ','カ','ガ','キ','ギ','ク', */
	/* 30b0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'グ','ケ','ゲ','コ','ゴ','サ','ザ','シ', 'ジ','ス','ズ','セ','ゼ','ソ','ゾ','タ', */
	/* 30c0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ダ','チ','ヂ','ッ','ツ','ヅ','テ','デ', 'ト','ド','ナ','ニ','ヌ','ネ','ノ','ハ', */
	/* 30d0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'バ','パ','ヒ','ビ','ピ','フ','ブ','プ', 'ヘ','ベ','ペ','ホ','ボ','ポ','マ','ミ', */
	/* 30e0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ム','メ','モ','ャ','ヤ','ュ','ユ','ョ', 'ヨ','ラ','リ','ル','レ','ロ','ヮ','ワ', */
	/* 30f0 */  4, 4, 4, 4, 4, 4, 4,-1, -1,-1,-1, 4, 4, 4, 4,0, /* 'ヰ','ヱ','ヲ','ン','ヴ','ヵ','ヶ',0, 0,0,0,'・','ー','ヽ','ヾ',0, */
	/* 3100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4e00 */  4, 4,-1, 4,-1,-1,-1, 4,  4, 4, 4, 4,-1, 4, 4,0, /* '一','丁',0,'七',0,0,0,'万', '丈','三','上','下',0,'不','与',0, */
	/* 4e10 */  4, 4,-1,-1, 4, 4, 4, 4,  4, 4,-1,-1,-1,-1, 4,0, /* '丐','丑',0,0,'且','丕','世','丗', '丘','丙',0,0,0,0,'丞',0, */
	/* 4e20 */ -1, 4,-1,-1,-1,-1, 4,-1, -1,-1, 4,-1,-1, 4,0,0, /* 0,'両',0,0,0,0,'並',0, 0,0,'个',0,0,'中',0,0, */
	/* 4e30 */ -1, 4, 4,-1,-1,-1, 4,-1,  4, 4,-1, 4, 4,-1,-1, 4, /* 0,'丱','串',0,0,0,'丶',0, '丸','丹',0,'主','丼',0,0,'丿', */
	/* 4e40 */ -1,-1, 4, 4,-1, 4,-1,-1, -1,-1,-1, 4,-1, 4, 4, 4, /* 0,0,'乂','乃',0,'久',0,0, 0,0,0,'之',0,'乍','乎','乏', */
	/* 4e50 */ -1,-1,-1,-1,-1, 4, 4, 4,  4, 4,-1,-1,-1, 4, 4, 4, /* 0,0,0,0,0,'乕','乖','乗', '乘','乙',0,0,0,'九','乞','也', */
	/* 4e60 */ -1,-1, 4,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'乢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4e70 */ -1, 4,-1, 4,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,'乱',0,'乳',0,0,0,0, 0,0,0,0,0,0,'乾',0, */
	/* 4e80 */  4,-1, 4,-1,-1, 4, 4,-1,  4, 4, 4, 4, 4,-1, 4,0, /* '亀',0,'亂',0,0,'亅','了',0, '予','争','亊','事','二',0,'于',0, */
	/* 4e90 */ -1, 4, 4,-1, 4, 4,-1,-1,  4, 4,-1, 4, 4,-1, 4, 4, /* 0,'云','互',0,'五','井',0,0, '亘','亙',0,'些','亜',0,'亞','亟', */
	/* 4ea0 */  4, 4, 4,-1, 4, 4, 4,-1,  4,-1,-1, 4, 4, 4, 4,0, /* '亠','亡','亢',0,'交','亥','亦',0, '亨',0,0,'享','京','亭','亮',0, */
	/* 4eb0 */  4,-1,-1, 4,-1,-1, 4,-1, -1,-1, 4,0,0,0,0,0, /* '亰',0,0,'亳',0,0,'亶',0, 0,0,'人',0,0,0,0,0, */
	/* 4ec0 */  4, 4, 4,-1, 4,-1, 4, 4, -1,-1, 4, 4,-1, 4, 4, 4, /* '什','仁','仂',0,'仄',0,'仆','仇', 0,0,'今','介',0,'仍','从','仏', */
	/* 4ed0 */ -1,-1,-1,-1, 4, 4, 4, 4,  4, 4,-1,-1,-1, 4, 4, 4, /* 0,0,0,0,'仔','仕','他','仗', '付','仙',0,0,0,'仝','仞','仟', */
	/* 4ee0 */ -1,-1,-1, 4, 4, 4,-1,-1, -1,-1,-1,-1,-1, 4, 4,0, /* 0,0,0,'代','令','以',0,0, 0,0,0,0,0,'仭','仮',0, */
	/* 4ef0 */  4,-1, 4,-1,-1,-1, 4, 4, -1,-1,-1, 4,0,0,0,0, /* '仰',0,'仲',0,0,0,'件','价', 0,0,0,'任',0,0,0,0, */
	/* 4f00 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4, 4,-1,-1, 4, 4, 4, /* 0,'企',0,0,0,0,0,0, 0,'伉','伊',0,0,'伍','伎','伏', */
	/* 4f10 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1, 4,-1, 4, 4,0,0, /* '伐','休',0,0,0,0,0,0, 0,0,'会',0,'伜','伝',0,0, */
	/* 4f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'伯', */
	/* 4f30 */  4,-1,-1,-1, 4,-1, 4,-1,  4,-1, 4,-1, 4, 4,0,0, /* '估',0,0,0,'伴',0,'伶',0, '伸',0,'伺',0,'似','伽',0,0, */
	/* 4f40 */ -1,-1,-1, 4,-1,-1, 4, 4, -1,-1,-1,-1,-1, 4, 4, 4, /* 0,0,0,'佃',0,0,'但','佇', 0,0,0,0,0,'位','低','住', */
	/* 4f50 */  4, 4,-1, 4,-1, 4,-1, 4, -1, 4, 4, 4, 4, 4, 4,0, /* '佐','佑',0,'体',0,'何',0,'佗', 0,'余','佚','佛','作','佝','佞',0, */
	/* 4f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,'佩',0,0,0,0,0,'佯', */
	/* 4f70 */  4,-1,-1, 4,-1, 4, 4,-1, -1,-1,-1, 4, 4,-1,-1, 4, /* '佰',0,0,'佳',0,'併','佶',0, 0,0,0,'佻','佼',0,0,'使', */
	/* 4f80 */ -1,-1,-1, 4,-1,-1, 4,-1,  4,-1,-1, 4,-1, 4,-1, 4, /* 0,0,0,'侃',0,0,'來',0, '侈',0,0,'例',0,'侍',0,'侏', */
	/* 4f90 */ -1, 4,-1,-1,-1,-1, 4,-1,  4,-1,-1, 4,-1, 4,0,0, /* 0,'侑',0,0,0,0,'侖',0, '侘',0,0,'供',0,'依',0,0, */
	/* 4fa0 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1, 4, 4, 4, /* '侠','価',0,0,0,0,0,0, 0,0,0,'侫',0,'侭','侮','侯', */
	/* 4fb0 */ -1,-1,-1,-1,-1, 4, 4,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,'侵','侶',0, 0,0,0,0,0,0,0,'便', */
	/* 4fc0 */ -1,-1, 4, 4, 4,-1,-1,-1, -1,-1, 4,-1,-1,-1, 4,0, /* 0,0,'係','促','俄',0,0,0, 0,0,'俊',0,0,0,'俎',0, */
	/* 4fd0 */  4, 4,-1,-1, 4,-1,-1, 4,  4,-1, 4, 4,-1, 4,-1, 4, /* '俐','俑',0,0,'俔',0,0,'俗', '俘',0,'俚','俛',0,'保',0,'俟', */
	/* 4fe0 */ -1, 4,-1, 4, 4, 4,-1,-1, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,'信',0,'俣','俤','俥',0,0, 0,0,0,0,0,0,'修','俯', */
	/* 4ff0 */ -1,-1,-1, 4,-1, 4, 4,-1,  4,-1, 4,-1,-1,-1, 4,0, /* 0,0,0,'俳',0,'俵','俶',0, '俸',0,'俺',0,0,0,'俾',0, */
	/* 5000 */ -1,-1,-1,-1,-1, 4, 4,-1, -1, 4,-1, 4,-1, 4,-1, 4, /* 0,0,0,0,0,'倅','倆',0, 0,'倉',0,'個',0,'倍',0,'倏', */
	/* 5010 */ -1, 4, 4,-1, 4,-1, 4,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* 0,'們','倒',0,'倔',0,'倖',0, 0,'候','倚',0,0,0,0,'借', */
	/* 5020 */ -1, 4,-1, 4, 4, 4, 4,-1,  4, 4, 4, 4, 4, 4,0,0, /* 0,'倡',0,'倣','値','倥','倦',0, '倨','倩','倪','倫','倬','倭',0,0, */
	/* 5030 */ -1,-1,-1,-1,-1,-1, 4,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,0,0,'倶',0, 0,'倹',0,0,0,0,0,0, */
	/* 5040 */ -1,-1,-1, 4,-1,-1,-1, 4,  4, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,'偃',0,0,0,'假', '偈','偉',0,0,0,0,0,'偏', */
	/* 5050 */  4,-1,-1,-1,-1, 4, 4,-1, -1,-1, 4,-1, 4,0,0,0, /* '偐',0,0,0,0,'偕','偖',0, 0,0,'做',0,'停',0,0,0, */
	/* 5060 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,'健',0,0, 0,0,0,0,'偬',0,0,0, */
	/* 5070 */ -1,-1, 4,-1, 4, 4, 4,-1,  4,-1,-1,-1,-1, 4,0,0, /* 0,0,'偲',0,'側','偵','偶',0, '偸',0,0,0,0,'偽',0,0, */
	/* 5080 */  4,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* '傀',0,0,0,0,'傅',0,0, 0,0,0,0,0,'傍',0,0, */
	/* 5090 */ -1, 4,-1,-1,-1,-1,-1,-1,  4, 4, 4,0,0,0,0,0, /* 0,'傑',0,0,0,0,0,0, '傘','備','傚',0,0,0,0,0, */
	/* 50a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'催','傭',0,0, */
	/* 50b0 */ -1,-1, 4, 4, 4, 4,-1, 4, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,'傲','傳','傴','債',0,'傷', 0,0,0,0,0,0,'傾',0, */
	/* 50c0 */ -1,-1, 4,-1,-1, 4,-1,-1, -1, 4, 4,-1,-1, 4,-1, 4, /* 0,0,'僂',0,0,'僅',0,0, 0,'僉','僊',0,0,'働',0,'像', */
	/* 50d0 */ -1, 4,-1,-1,-1, 4, 4,-1, -1,-1, 4,-1,-1,-1, 4,0, /* 0,'僑',0,0,0,'僕','僖',0, 0,0,'僚',0,0,0,'僞',0, */
	/* 50e0 */ -1,-1,-1, 4,-1, 4,-1, 4, -1,-1,-1,-1,-1, 4, 4,0, /* 0,0,0,'僣',0,'僥',0,'僧', 0,0,0,0,0,'僭','僮',0, */
	/* 50f0 */ -1,-1,-1,-1,-1, 4,-1,-1, -1, 4,-1, 4,0,0,0,0, /* 0,0,0,0,0,'僵',0,0, 0,'價',0,'僻',0,0,0,0, */
	/* 5100 */  4, 4, 4,-1, 4,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* '儀','儁','儂',0,'億',0,0,0, 0,'儉',0,0,0,0,0,0, */
	/* 5110 */ -1,-1, 4,-1, 4, 4, 4,-1,  4,-1, 4,-1,-1,-1,-1, 4, /* 0,0,'儒',0,'儔','儕','儖',0, '儘',0,'儚',0,0,0,0,'償', */
	/* 5120 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,'儡',0,0,0,0,0,0, 0,0,'優',0,0,0,0,0, */
	/* 5130 */ -1,-1, 4,-1,-1,-1,-1, 4, -1,-1, 4, 4, 4,-1,-1, 4, /* 0,0,'儲',0,0,0,0,'儷', 0,0,'儺','儻','儼',0,0,'儿', */
	/* 5140 */  4, 4,-1, 4, 4, 4, 4, 4,  4, 4,-1, 4, 4, 4, 4,0, /* '兀','允',0,'元','兄','充','兆','兇', '先','光',0,'克','兌','免','兎',0, */
	/* 5150 */  4,-1, 4,-1, 4,-1,-1,-1, -1,-1, 4,-1, 4,0,0,0, /* '児',0,'兒',0,'兔',0,0,0, 0,0,'党',0,'兜',0,0,0, */
	/* 5160 */ -1,-1, 4,-1,-1, 4,-1,-1,  4, 4, 4, 4, 4, 4, 4,0, /* 0,0,'兢',0,0,'入',0,0, '全','兩','兪','八','公','六','兮',0, */
	/* 5170 */ -1, 4,-1,-1,-1, 4, 4, 4,  4,-1,-1,-1, 4,0,0,0, /* 0,'共',0,0,0,'兵','其','具', '典',0,0,0,'兼',0,0,0, */
	/* 5180 */  4,-1, 4,-1,-1, 4, 4,-1, -1, 4, 4,-1, 4, 4,-1, 4, /* '冀',0,'冂',0,0,'内','円',0, 0,'冉','冊',0,'册','再',0,'冏', */
	/* 5190 */  4, 4, 4, 4,-1, 4, 4, 4, -1, 4,0,0,0,0,0,0, /* '冐','冑','冒','冓',0,'冕','冖','冗', 0,'写',0,0,0,0,0,0, */
	/* 51a0 */  4,-1, 4,-1, 4, 4, 4,-1,  4, 4, 4, 4, 4,0,0,0, /* '冠',0,'冢',0,'冤','冥','冦',0, '冨','冩','冪','冫','冬',0,0,0, */
	/* 51b0 */  4, 4, 4, 4, 4, 4, 4, 4, -1,-1,-1,-1,-1, 4,0,0, /* '冰','冱','冲','决','冴','况','冶','冷', 0,0,0,0,0,'冽',0,0, */
	/* 51c0 */ -1,-1,-1,-1, 4, 4, 4,-1, -1, 4,-1, 4, 4, 4,0,0, /* 0,0,0,0,'凄','凅','准',0, 0,'凉',0,'凋','凌','凍',0,0, */
	/* 51d0 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1, 4, 4, 4,0,0, /* 0,0,0,0,0,0,'凖',0, 0,0,0,'凛','凜','凝',0,0, */
	/* 51e0 */  4, 4,-1,-1,-1,-1, 4, 4, -1, 4, 4,-1,-1, 4,0,0, /* '几','凡',0,0,0,0,'処','凧', 0,'凩','凪',0,0,'凭',0,0, */
	/* 51f0 */  4, 4,-1,-1,-1, 4, 4,-1,  4, 4, 4,-1,-1, 4, 4,0, /* '凰','凱',0,0,0,'凵','凶',0, '凸','凹','出',0,0,'函','凾',0, */
	/* 5200 */  4,-1,-1, 4, 4,-1, 4, 4,  4,-1, 4, 4,-1,-1, 4,0, /* '刀',0,0,'刃','刄',0,'分','切', '刈',0,'刊','刋',0,0,'刎',0, */
	/* 5210 */ -1, 4,-1,-1, 4,-1,-1, 4, -1,-1,-1,-1,-1, 4,0,0, /* 0,'刑',0,0,'刔',0,0,'列', 0,0,0,0,0,'初',0,0, */
	/* 5220 */ -1,-1,-1,-1, 4, 4,-1, 4, -1, 4, 4,-1,-1,-1, 4,0, /* 0,0,0,0,'判','別',0,'刧', 0,'利','刪',0,0,0,'刮',0, */
	/* 5230 */  4,-1,-1, 4,-1,-1, 4, 4,  4, 4, 4, 4,0,0,0,0, /* '到',0,0,'刳',0,0,'制','刷', '券','刹','刺','刻',0,0,0,0, */
	/* 5240 */ -1,-1,-1, 4, 4,-1,-1, 4, -1,-1, 4, 4, 4, 4,-1, 4, /* 0,0,0,'剃','剄',0,0,'則', 0,0,'削','剋','剌','前',0,'剏', */
	/* 5250 */ -1,-1,-1,-1, 4,-1, 4,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,0,0,0,'剔',0,'剖',0, 0,0,0,'剛',0,0,'剞',0, */
	/* 5260 */ -1,-1,-1, 4, 4, 4,-1,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* 0,0,0,'剣','剤','剥',0,0, 0,'剩','剪',0,0,0,0,'副', */
	/* 5270 */  4, 4, 4, 4, 4, 4,-1,-1, -1,-1,-1,-1,-1, 4,-1, 4, /* '剰','剱','割','剳','剴','創',0,0, 0,0,0,0,0,'剽',0,'剿', */
	/* 5280 */ -1,-1,-1, 4,-1,-1,-1, 4,  4, 4,-1,-1,-1, 4,0,0, /* 0,0,0,'劃',0,0,0,'劇', '劈','劉',0,0,0,'劍',0,0, */
	/* 5290 */ -1, 4, 4,-1, 4,-1,-1,-1, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,'劑','劒',0,'劔',0,0,0, 0,0,0,'力',0,0,0,'功', */
	/* 52a0 */  4,-1,-1, 4,-1,-1,-1,-1, -1, 4, 4, 4, 4, 4,0,0, /* '加',0,0,'劣',0,0,0,0, 0,'助','努','劫','劬','劭',0,0, */
	/* 52b0 */ -1, 4,-1,-1, 4, 4,-1,-1, -1, 4,-1,-1, 4,-1, 4,0, /* 0,'励',0,0,'労','劵',0,0, 0,'効',0,0,'劼',0,'劾',0, */
	/* 52c0 */ -1, 4,-1, 4,-1, 4,-1, 4, -1, 4,-1,-1,-1, 4,0,0, /* 0,'勁',0,'勃',0,'勅',0,'勇', 0,'勉',0,0,0,'勍',0,0, */
	/* 52d0 */ -1,-1, 4,-1,-1, 4,-1, 4,  4, 4,-1,-1,-1, 4, 4, 4, /* 0,0,'勒',0,0,'動',0,'勗', '勘','務',0,0,0,'勝','勞','募', */
	/* 52e0 */  4,-1, 4, 4, 4,-1, 4, 4, 0,0,0,0,0,0,0,0, /* '勠',0,'勢','勣','勤',0,'勦','勧', 0,0,0,0,0,0,0,0, */
	/* 52f0 */ -1,-1, 4, 4,-1, 4,-1,-1,  4, 4, 4,-1,-1,-1, 4, 4, /* 0,0,'勲','勳',0,'勵',0,0, '勸','勹','勺',0,0,0,'勾','勿', */
	/* 5300 */ -1, 4, 4,-1,-1, 4, 4,-1,  4,-1,-1,-1,-1, 4,-1, 4, /* 0,'匁','匂',0,0,'包','匆',0, '匈',0,0,0,0,'匍',0,'匏', */
	/* 5310 */  4,-1,-1,-1,-1, 4, 4, 4, -1, 4, 4,-1,-1, 4,0,0, /* '匐',0,0,0,0,'匕','化','北', 0,'匙','匚',0,0,'匝',0,0, */
	/* 5320 */  4, 4,-1, 4,-1,-1,-1,-1, -1,-1, 4,-1,-1,-1,-1, 4, /* '匠','匡',0,'匣',0,0,0,0, 0,0,'匪',0,0,0,0,'匯', */
	/* 5330 */ -1, 4,-1, 4,-1,-1,-1,-1,  4, 4, 4, 4,-1,-1,-1, 4, /* 0,'匱',0,'匳',0,0,0,0, '匸','匹','区','医',0,0,0,'匿', */
	/* 5340 */  4, 4,-1, 4,-1, 4, 4, 4,  4, 4, 4,-1,-1, 4,0,0, /* '區','十',0,'千',0,'卅','卆','升', '午','卉','半',0,0,'卍',0,0, */
	/* 5350 */ -1, 4, 4, 4, 4,-1,-1, 4,  4,-1, 4,-1, 4,-1, 4,0, /* 0,'卑','卒','卓','協',0,0,'南', '単',0,'博',0,'卜',0,'卞',0, */
	/* 5360 */  4,-1,-1,-1,-1,-1, 4,-1, -1, 4,-1,-1,-1,-1, 4, 4, /* '占',0,0,0,0,0,'卦',0, 0,'卩',0,0,0,0,'卮','卯', */
	/* 5370 */  4, 4,-1, 4, 4, 4,-1, 4,  4,-1,-1, 4,-1,-1,-1, 4, /* '印','危',0,'即','却','卵',0,'卷', '卸',0,0,'卻',0,0,0,'卿', */
	/* 5380 */ -1,-1, 4,-1, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'厂',0,'厄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5390 */ -1,-1,-1,-1,-1,-1, 4,-1,  4,-1, 4,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,'厖',0, '厘',0,'厚',0,0,0,0,'原', */
	/* 53a0 */  4,-1,-1,-1,-1, 4, 4,-1,  4, 4,-1,-1,-1, 4, 4,0, /* '厠',0,0,0,0,'厥','厦',0, '厨','厩',0,0,0,'厭','厮',0, */
	/* 53b0 */  4,-1,-1, 4,-1,-1, 4,-1, -1,-1,-1, 4,0,0,0,0, /* '厰',0,0,'厳',0,0,'厶',0, 0,0,0,'去',0,0,0,0, */
	/* 53c0 */ -1,-1, 4, 4,-1,-1,-1,-1,  4, 4, 4, 4, 4, 4, 4,0, /* 0,0,'参','參',0,0,0,0, '又','叉','及','友','双','反','収',0, */
	/* 53d0 */ -1,-1,-1,-1, 4,-1, 4, 4, -1, 4,-1, 4,-1,-1,-1, 4, /* 0,0,0,0,'叔',0,'取','受', 0,'叙',0,'叛',0,0,0,'叟', */
	/* 53e0 */ -1, 4, 4, 4, 4, 4,-1,-1,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'叡','叢','口','古','句',0,0, '叨','叩','只','叫','召','叭','叮','可', */
	/* 53f0 */  4, 4, 4, 4,-1,-1, 4, 4,  4,-1, 4,0,0,0,0,0, /* '台','叱','史','右',0,0,'叶','号', '司',0,'叺',0,0,0,0,0, */
	/* 5400 */ -1, 4,-1, 4, 4,-1,-1,-1,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'吁',0,'吃','各',0,0,0, '合','吉','吊','吋','同','名','后','吏', */
	/* 5410 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1, 4,-1, 4, /* '吐','向',0,0,0,0,0,0, 0,0,0,'君',0,'吝',0,'吟', */
	/* 5420 */  4,-1,-1,-1,-1,-1, 4,-1, -1, 4,-1, 4, 4, 4, 4,0, /* '吠',0,0,0,0,0,'否',0, 0,'吩',0,'含','听','吭','吮',0, */
	/* 5430 */ -1,-1,-1,-1,-1,-1, 4,-1,  4, 4,-1, 4, 4, 4, 4,0, /* 0,0,0,0,0,0,'吶',0, '吸','吹',0,'吻','吼','吽','吾',0, */
	/* 5440 */  4,-1, 4,-1,-1,-1, 4,-1,  4, 4, 4,-1,-1,-1, 4,0, /* '呀',0,'呂',0,0,0,'呆',0, '呈','呉','告',0,0,0,'呎',0, */
	/* 5450 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,'呑',0,0,0,0,0,0, 0,0,0,0,0,0,0,'呟', */
	/* 5460 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '周',0,'呪',0,0,0,0,0, */
	/* 5470 */  4, 4,-1, 4,-1, 4, 4, 4, -1,-1,-1, 4, 4, 4,0,0, /* '呰','呱',0,'味',0,'呵','呶','呷', 0,0,0,'呻','呼','命',0,0, */
	/* 5480 */  4,-1,-1,-1, 4,-1, 4,-1, -1,-1,-1, 4, 4,-1, 4, 4, /* '咀',0,0,0,'咄',0,'咆',0, 0,0,0,'咋','和',0,'咎','咏', */
	/* 5490 */  4,-1, 4,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '咐',0,'咒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 54a0 */ -1,-1, 4,-1, 4, 4,-1,-1,  4,-1,-1, 4, 4,-1,-1, 4, /* 0,0,'咢',0,'咤','咥',0,0, '咨',0,0,'咫','咬',0,0,'咯', */
	/* 54b0 */ -1,-1, 4, 4,-1,-1,-1,-1,  4,-1,-1,-1, 4, 4, 4,0, /* 0,0,'咲','咳',0,0,0,0, '咸',0,0,0,'咼','咽','咾',0, */
	/* 54c0 */  4, 4, 4,-1, 4,-1,-1, 4,  4, 4,0,0,0,0,0,0, /* '哀','品','哂',0,'哄',0,0,'哇', '哈','哉',0,0,0,0,0,0, */
	/* 54d0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '哘',0,0,0,0,0,0,0, */
	/* 54e0 */ -1, 4, 4,-1,-1, 4, 4,-1,  4, 4,-1,-1,-1, 4, 4,0, /* 0,'員','哢',0,0,'哥','哦',0, '哨','哩',0,0,0,'哭','哮',0, */
	/* 54f0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4,0,0, /* 0,0,'哲',0,0,0,0,0, 0,0,'哺',0,0,'哽',0,0, */
	/* 5500 */ -1,-1,-1,-1, 4,-1, 4, 4, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,'唄',0,'唆','唇', 0,0,0,0,0,0,0,'唏', */
	/* 5510 */  4,-1,-1,-1, 4,-1, 4,0, 0,0,0,0,0,0,0,0, /* '唐',0,0,0,'唔',0,'唖',0, 0,0,0,0,0,0,0,0, */
	/* 5520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'售','唯', */
	/* 5530 */ -1, 4,-1, 4,-1,-1,-1,-1,  4, 4,-1,-1,-1,-1, 4,0, /* 0,'唱',0,'唳',0,0,0,0, '唸','唹',0,0,0,0,'唾',0, */
	/* 5540 */  4,-1,-1,-1, 4, 4, 4,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* '啀',0,0,0,'啄','啅','商',0, 0,0,0,0,'啌',0,0,'問', */
	/* 5550 */ -1,-1,-1, 4,-1,-1, 4, 4, -1,-1,-1,-1, 4, 4,0,0, /* 0,0,0,'啓',0,0,'啖','啗', 0,0,0,0,'啜','啝',0,0, */
	/* 5560 */ -1,-1,-1, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'啣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'啻','啼',0,'啾',0, */
	/* 5580 */  4,-1,-1, 4, 4,-1,-1, 4, -1, 4, 4, 4,0,0,0,0, /* '喀',0,0,'喃','善',0,0,'喇', 0,'喉','喊','喋',0,0,0,0, */
	/* 5590 */ -1,-1,-1,-1,-1,-1,-1,-1,  4, 4, 4,-1, 4, 4, 4, 4, /* 0,0,0,0,0,0,0,0, '喘','喙','喚',0,'喜','喝','喞','喟', */
	/* 55a0 */ -1,-1,-1,-1,-1,-1,-1, 4,  4, 4, 4, 4, 4,-1, 4,0, /* 0,0,0,0,0,0,0,'喧', '喨','喩','喪','喫','喬',0,'單',0, */
	/* 55b0 */  4,-1,-1,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* '喰',0,0,0,0,0,'営',0, 0,0,0,0,0,0,0,0, */
	/* 55c0 */ -1,-1,-1,-1, 4, 4,-1, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'嗄','嗅',0,'嗇', 0,0,0,0,0,0,0,0, */
	/* 55d0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1, 4,-1, 4,-1,-1, 4, /* 0,0,0,0,'嗔',0,0,0, 0,0,'嗚',0,'嗜',0,0,'嗟', */
	/* 55e0 */ -1,-1,-1, 4, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'嗣','嗤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 55f0 */ -1,-1,-1,-1,-1,-1,-1, 4, -1, 4,-1,-1,-1, 4, 4,0, /* 0,0,0,0,0,0,0,'嗷', 0,'嗹',0,0,0,'嗽','嗾',0, */
	/* 5600 */ -1,-1,-1,-1,-1,-1, 4,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,0,0,'嘆',0, 0,'嘉',0,0,0,0,0,0, */
	/* 5610 */ -1,-1,-1,-1, 4,-1, 4, 4,  4,-1,-1, 4,0,0,0,0, /* 0,0,0,0,'嘔',0,'嘖','嘗', '嘘',0,0,'嘛',0,0,0,0, */
	/* 5620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,'嘩',0,0,0,0,0,'嘯', */
	/* 5630 */ -1, 4, 4,-1, 4,-1, 4,-1,  4,0,0,0,0,0,0,0, /* 0,'嘱','嘲',0,'嘴',0,'嘶',0, '嘸',0,0,0,0,0,0,0, */
	/* 5640 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,-1, 4,0, /* 0,0,'噂',0,0,0,0,0, 0,0,0,0,'噌',0,'噎',0, */
	/* 5650 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* '噐',0,0,0,0,0,0,0, 0,0,0,'噛',0,0,0,0, */
	/* 5660 */ -1,-1,-1,-1, 4,-1,-1,-1,  4,-1, 4, 4, 4,0,0,0, /* 0,0,0,0,'噤',0,0,0, '器',0,'噪','噫','噬',0,0,0, */
	/* 5670 */ -1,-1,-1,-1, 4,-1,-1,-1,  4,-1, 4,0,0,0,0,0, /* 0,0,0,0,'噴',0,0,0, '噸',0,'噺',0,0,0,0,0, */
	/* 5680 */  4,-1,-1,-1,-1,-1, 4, 4, -1,-1, 4,-1,-1,-1,-1, 4, /* '嚀',0,0,0,0,0,'嚆','嚇', 0,0,'嚊',0,0,0,0,'嚏', */
	/* 5690 */ -1,-1,-1,-1, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'嚔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 56a0 */  4,-1, 4,-1,-1, 4,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '嚠',0,'嚢',0,0,'嚥',0,0, 0,0,0,0,0,0,'嚮',0, */
	/* 56b0 */ -1,-1,-1,-1, 4,-1, 4,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,'嚴',0,'嚶',0, 0,0,0,0,'嚼',0,0,0, */
	/* 56c0 */  4, 4, 4, 4,-1,-1,-1,-1,  4,-1,-1,-1,-1,-1, 4,0, /* '囀','囁','囂','囃',0,0,0,0, '囈',0,0,0,0,0,'囎',0, */
	/* 56d0 */ -1, 4,-1, 4,-1,-1,-1, 4,  4,-1, 4, 4,-1,-1, 4,0, /* 0,'囑',0,'囓',0,0,0,'囗', '囘',0,'囚','四',0,0,'回',0, */
	/* 56e0 */  4,-1,-1, 4,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '因',0,0,'団',0,0,0,0, 0,0,0,0,0,0,'囮',0, */
	/* 56f0 */  4,-1, 4, 4,-1,-1,-1,-1, -1, 4, 4,-1,-1, 4,-1, 4, /* '困',0,'囲','図',0,0,0,0, 0,'囹','固',0,0,'国',0,'囿', */
	/* 5700 */  4,-1,-1, 4, 4,-1,-1,-1,  4, 4,-1, 4,-1, 4,-1, 4, /* '圀',0,0,'圃','圄',0,0,0, '圈','圉',0,'國',0,'圍',0,'圏', */
	/* 5710 */ -1,-1, 4, 4,-1,-1, 4,-1,  4,-1,-1,-1, 4,-1,-1, 4, /* 0,0,'園','圓',0,0,'圖',0, '團',0,0,0,'圜',0,0,'土', */
	/* 5720 */ -1,-1,-1,-1,-1,-1, 4, 4,  4,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,'圦','圧', '在',0,0,0,0,'圭',0,0, */
	/* 5730 */  4,-1,-1,-1,-1,-1,-1, 4,  4,-1,-1, 4,0,0,0,0, /* '地',0,0,0,0,0,0,'圷', '圸',0,0,'圻',0,0,0,0, */
	/* 5740 */  4,-1, 4,-1,-1,-1,-1, 4, -1,-1, 4,-1,-1,-1, 4, 4, /* '址',0,'坂',0,0,0,0,'均', 0,0,'坊',0,0,0,'坎','坏', */
	/* 5750 */  4, 4,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '坐','坑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5760 */ -1, 4,-1,-1, 4,-1, 4,-1, -1, 4, 4,0,0,0,0,0, /* 0,'坡',0,0,'坤',0,'坦',0, 0,'坩','坪',0,0,0,0,0, */
	/* 5770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'坿', */
	/* 5780 */ -1,-1, 4,-1,-1,-1,-1,-1,  4, 4,-1, 4,0,0,0,0, /* 0,0,'垂',0,0,0,0,0, '垈','垉',0,'型',0,0,0,0, */
	/* 5790 */ -1,-1,-1, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'垓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57a0 */  4,-1, 4, 4, 4,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* '垠',0,'垢','垣','垤',0,0,0, 0,0,'垪',0,0,0,0,0, */
	/* 57b0 */  4,-1,-1, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* '垰',0,0,'垳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57c0 */  4,-1,-1, 4,-1,-1, 4,-1, -1,-1,-1, 4,-1,-1, 4,0, /* '埀',0,0,'埃',0,0,'埆',0, 0,0,0,'埋',0,0,'城',0, */
	/* 57d0 */ -1,-1, 4, 4, 4,-1, 4,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* 0,0,'埒','埓','埔',0,'埖',0, 0,0,0,0,'埜',0,0,'域', */
	/* 57e0 */  4,-1,-1, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* '埠',0,0,'埣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 57f0 */ -1,-1,-1,-1, 4,-1,-1, 4, -1, 4, 4,-1, 4,0,0,0, /* 0,0,0,0,'埴',0,0,'執', 0,'培','基',0,'埼',0,0,0, */
	/* 5800 */  4,-1, 4,-1,-1, 4, 4,-1, -1,-1, 4, 4,0,0,0,0, /* '堀',0,'堂',0,0,'堅','堆',0, 0,0,'堊','堋',0,0,0,0, */
	/* 5810 */ -1,-1,-1,-1,-1, 4,-1,-1, -1, 4,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,'堕',0,0, 0,'堙',0,0,0,'堝',0,0, */
	/* 5820 */ -1, 4,-1,-1, 4,-1,-1,-1, -1,-1, 4,-1,-1,-1,-1, 4, /* 0,'堡',0,0,'堤',0,0,0, 0,0,'堪',0,0,0,0,'堯', */
	/* 5830 */  4, 4,-1,-1, 4, 4,-1,-1, -1,-1, 4,-1,-1, 4,0,0, /* '堰','報',0,0,'場','堵',0,0, 0,0,'堺',0,0,'堽',0,0, */
	/* 5840 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4,0,0,0,0, /* '塀','塁',0,0,0,0,0,0, 0,0,'塊','塋',0,0,0,0, */
	/* 5850 */ -1, 4, 4,-1, 4,-1,-1, 4,  4, 4, 4,-1,-1,-1, 4,0, /* 0,'塑','塒',0,'塔',0,0,'塗', '塘','塙','塚',0,0,0,'塞',0, */
	/* 5860 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4,-1, 4,0,0,0,0, /* 0,0,'塢',0,0,0,0,0, 0,'塩',0,'填',0,0,0,0, */
	/* 5870 */  4,-1, 4,-1,-1, 4,-1,-1, -1, 4,-1,-1,-1,-1, 4,0, /* '塰',0,'塲',0,0,'塵',0,0, 0,'塹',0,0,0,0,'塾',0, */
	/* 5880 */ -1,-1,-1, 4,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'境',0,'墅',0,0, 0,0,0,0,0,0,0,0, */
	/* 5890 */ -1,-1,-1, 4,-1,-1,-1, 4, -1,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,'墓',0,0,0,'増', 0,0,0,0,'墜',0,0,'墟', */
	/* 58a0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1, 4,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, '墨',0,0,'墫',0,0,'墮',0, */
	/* 58b0 */ -1,-1,-1, 4,-1,-1,-1,-1,  4, 4, 4, 4,-1,-1, 4,0, /* 0,0,0,'墳',0,0,0,0, '墸','墹','墺','墻',0,0,'墾',0, */
	/* 58c0 */ -1, 4,-1,-1,-1, 4,-1, 4, -1,-1, 4,-1, 4,0,0,0, /* 0,'壁',0,0,0,'壅',0,'壇', 0,0,'壊',0,'壌',0,0,0, */
	/* 58d0 */ -1, 4,-1, 4,-1, 4,-1, 4,  4, 4,-1,-1, 4,-1, 4, 4, /* 0,'壑',0,'壓',0,'壕',0,'壗', '壘','壙',0,0,'壜',0,'壞','壟', */
	/* 58e0 */ -1,-1,-1,-1, 4, 4,-1,-1, -1,-1,-1, 4, 4,-1, 4, 4, /* 0,0,0,0,'壤','壥',0,0, 0,0,0,'士','壬',0,'壮','壯', */
	/* 58f0 */  4, 4, 4,-1,-1,-1,-1, 4, -1, 4, 4, 4, 4, 4,0,0, /* '声','壱','売',0,0,0,0,'壷', 0,'壹','壺','壻','壼','壽',0,0, */
	/* 5900 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* 0,0,'夂',0,0,0,0,0, 0,'変','夊',0,0,0,0,'夏', */
	/* 5910 */  4,-1,-1,-1,-1, 4, 4,-1,  4, 4, 4, 4, 4,0,0,0, /* '夐',0,0,0,0,'夕','外',0, '夘','夙','多','夛','夜',0,0,0, */
	/* 5920 */ -1,-1, 4,-1,-1, 4,-1, 4, -1, 4, 4, 4, 4, 4, 4,0, /* 0,0,'夢',0,0,'夥',0,'大', 0,'天','太','夫','夬','夭','央',0, */
	/* 5930 */ -1, 4, 4,-1,-1,-1,-1, 4,  4,-1,-1,-1,-1,-1, 4,0, /* 0,'失','夲',0,0,0,0,'夷', '夸',0,0,0,0,0,'夾',0, */
	/* 5940 */ -1,-1,-1,-1, 4,-1,-1, 4,  4, 4,-1,-1,-1,-1, 4, 4, /* 0,0,0,0,'奄',0,0,'奇', '奈','奉',0,0,0,0,'奎','奏', */
	/* 5950 */  4, 4,-1,-1, 4, 4,-1, 4,  4,-1, 4,0,0,0,0,0, /* '奐','契',0,0,'奔','奕',0,'套', '奘',0,'奚',0,0,0,0,0, */
	/* 5960 */  4,-1, 4,-1,-1, 4,-1, 4,  4, 4, 4,-1, 4,-1, 4,0, /* '奠',0,'奢',0,0,'奥',0,'奧', '奨','奩','奪',0,'奬',0,'奮',0, */
	/* 5970 */ -1,-1,-1, 4, 4,-1,-1,-1,  4,-1,-1,-1,-1, 4,0,0, /* 0,0,0,'女','奴',0,0,0, '奸',0,0,0,0,'好',0,0, */
	/* 5980 */ -1, 4, 4, 4, 4,-1,-1,-1, -1,-1, 4,-1,-1, 4,0,0, /* 0,'妁','如','妃','妄',0,0,0, 0,0,'妊',0,0,'妍',0,0, */
	/* 5990 */ -1,-1,-1, 4,-1,-1, 4,-1, -1, 4,-1, 4,-1, 4,0,0, /* 0,0,0,'妓',0,0,'妖',0, 0,'妙',0,'妛',0,'妝',0,0, */
	/* 59a0 */ -1,-1,-1, 4,-1, 4,-1,-1,  4,-1,-1,-1, 4,0,0,0, /* 0,0,0,'妣',0,'妥',0,0, '妨',0,0,0,'妬',0,0,0, */
	/* 59b0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4,-1, 4,-1,-1, 4,0, /* 0,0,'妲',0,0,0,0,0, 0,'妹',0,'妻',0,0,'妾',0, */
	/* 59c0 */ -1,-1,-1,-1,-1,-1, 4,-1, -1, 4,-1, 4,0,0,0,0, /* 0,0,0,0,0,0,'姆',0, 0,'姉',0,'始',0,0,0,0, */
	/* 59d0 */  4, 4,-1, 4, 4,-1,-1,-1, -1, 4, 4,-1, 4,0,0,0, /* '姐','姑',0,'姓','委',0,0,0, 0,'姙','姚',0,'姜',0,0,0, */
	/* 59e0 */ -1,-1,-1,-1,-1, 4, 4,-1,  4,-1, 4, 4,0,0,0,0, /* 0,0,0,0,0,'姥','姦',0, '姨',0,'姪','姫',0,0,0,0, */
	/* 59f0 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,0,0,0,0,0,'姶',0, 0,0,0,'姻',0,0,0,'姿', */
	/* 5a00 */ -1, 4,-1, 4,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,'威',0,'娃',0,0,0,0, 0,'娉',0,0,0,0,0,0, */
	/* 5a10 */ -1, 4,-1,-1,-1,-1,-1,-1,  4,-1, 4,-1, 4,-1,-1, 4, /* 0,'娑',0,0,0,0,0,0, '娘',0,'娚',0,'娜',0,0,'娟', */
	/* 5a20 */  4,-1,-1,-1,-1, 4,-1,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* '娠',0,0,0,0,'娥',0,0, 0,'娩',0,0,0,0,0,'娯', */
	/* 5a30 */ -1,-1,-1,-1,-1, 4, 4,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,'娵','娶',0, 0,0,0,0,'娼',0,0,0, */
	/* 5a40 */  4, 4,-1,-1,-1,-1, 4,-1, -1, 4,0,0,0,0,0,0, /* '婀','婁',0,0,0,0,'婆',0, 0,'婉',0,0,0,0,0,0, */
	/* 5a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'婚',0,0,0,0,0, */
	/* 5a60 */ -1,-1, 4,-1,-1,-1, 4,-1, -1,-1, 4,-1, 4,0,0,0, /* 0,0,'婢',0,0,0,'婦',0, 0,0,'婪',0,'婬',0,0,0, */
	/* 5a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'婿', */
	/* 5a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5a90 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1, 4, 4,0,0,0,0, /* 0,0,'媒',0,0,0,0,0, 0,0,'媚','媛',0,0,0,0, */
	/* 5aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4, 4, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'媼','媽','媾',0, */
	/* 5ac0 */ -1, 4, 4,-1,-1,-1,-1,-1, -1, 4,-1, 4, 4,0,0,0, /* 0,'嫁','嫂',0,0,0,0,0, 0,'嫉',0,'嫋','嫌',0,0,0, */
	/* 5ad0 */  4,-1,-1,-1,-1,-1, 4, 4, 0,0,0,0,0,0,0,0, /* '嫐',0,0,0,0,0,'嫖','嫗', 0,0,0,0,0,0,0,0, */
	/* 5ae0 */ -1, 4,-1, 4,-1,-1, 4,-1, -1, 4,0,0,0,0,0,0, /* 0,'嫡',0,'嫣',0,0,'嫦',0, 0,'嫩',0,0,0,0,0,0, */
	/* 5af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'嫺','嫻',0,0,0,0, */
	/* 5b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1, 4, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'嬉',0,'嬋','嬌',0,0,0, */
	/* 5b10 */ -1,-1,-1,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'嬖',0, 0,0,0,0,0,0,0,0, */
	/* 5b20 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1, 4,-1, 4,0,0,0, /* 0,0,'嬢',0,0,0,0,0, 0,0,'嬪',0,'嬬',0,0,0, */
	/* 5b30 */  4,-1, 4,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '嬰',0,'嬲',0,0,0,'嬶',0, 0,0,0,0,0,0,'嬾',0, */
	/* 5b40 */  4,-1,-1, 4,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* '孀',0,0,'孃',0,'孅',0,0, 0,0,0,0,0,0,0,0, */
	/* 5b50 */  4, 4,-1,-1, 4, 4,-1, 4,  4,-1, 4, 4, 4, 4,-1, 4, /* '子','孑',0,0,'孔','孕',0,'字', '存',0,'孚','孛','孜','孝',0,'孟', */
	/* 5b60 */ -1,-1,-1, 4, 4, 4, 4,-1, -1, 4,-1, 4,0,0,0,0, /* 0,0,0,'季','孤','孥','学',0, 0,'孩',0,'孫',0,0,0,0, */
	/* 5b70 */  4, 4,-1, 4,-1, 4,-1,-1,  4,-1, 4,0,0,0,0,0, /* '孰','孱',0,'孳',0,'孵',0,0, '學',0,'孺',0,0,0,0,0, */
	/* 5b80 */  4,-1,-1, 4,-1, 4,-1, 4,  4, 4,-1, 4, 4, 4,-1, 4, /* '宀',0,0,'它',0,'宅',0,'宇', '守','安',0,'宋','完','宍',0,'宏', */
	/* 5b90 */ -1,-1,-1,-1,-1, 4,-1, 4,  4, 4, 4, 4, 4, 4,-1, 4, /* 0,0,0,0,0,'宕',0,'宗', '官','宙','定','宛','宜','宝',0,'実', */
	/* 5ba0 */ -1,-1, 4, 4, 4, 4, 4,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,'客','宣','室','宥','宦',0, 0,0,0,0,0,0,'宮',0, */
	/* 5bb0 */  4,-1,-1, 4, 4, 4, 4,-1,  4, 4,-1,-1,-1,-1,-1, 4, /* '宰',0,0,'害','宴','宵','家',0, '宸','容',0,0,0,0,0,'宿', */
	/* 5bc0 */ -1,-1, 4, 4, 4, 4, 4, 4, -1, 4,-1,-1, 4,0,0,0, /* 0,0,'寂','寃','寄','寅','密','寇', 0,'寉',0,0,'富',0,0,0, */
	/* 5bd0 */  4,-1, 4, 4, 4,-1,-1,-1, -1,-1,-1, 4,-1, 4, 4, 4, /* '寐',0,'寒','寓','寔',0,0,0, 0,0,0,'寛',0,'寝','寞','察', */
	/* 5be0 */ -1, 4, 4,-1, 4, 4, 4, 4,  4, 4,-1, 4,-1,-1, 4,0, /* 0,'寡','寢',0,'寤','寥','實','寧', '寨','審',0,'寫',0,0,'寮',0, */
	/* 5bf0 */  4,-1,-1, 4,-1, 4, 4,-1,  4,-1, 4,-1,-1,-1, 4, 4, /* '寰',0,0,'寳',0,'寵','寶',0, '寸',0,'寺',0,0,0,'対','寿', */
	/* 5c00 */ -1, 4, 4,-1, 4, 4, 4, 4,  4, 4, 4, 4,-1, 4, 4, 4, /* 0,'封','専',0,'射','尅','将','將', '專','尉','尊','尋',0,'對','導','小', */
	/* 5c10 */ -1, 4,-1, 4,-1,-1, 4,-1, -1,-1, 4,0,0,0,0,0, /* 0,'少',0,'尓',0,0,'尖',0, 0,0,'尚',0,0,0,0,0, */
	/* 5c20 */  4,-1, 4,-1, 4,-1,-1,-1,  4,-1,-1,-1,-1, 4,0,0, /* '尠',0,'尢',0,'尤',0,0,0, '尨',0,0,0,0,'尭',0,0, */
	/* 5c30 */ -1, 4,-1,-1,-1,-1,-1,-1,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'就',0,0,0,0,0,0, '尸','尹','尺','尻','尼','尽','尾','尿', */
	/* 5c40 */  4, 4,-1,-1,-1, 4, 4,-1,  4,-1, 4, 4,-1, 4, 4, 4, /* '局','屁',0,0,0,'居','屆',0, '屈',0,'届','屋',0,'屍','屎','屏', */
	/* 5c50 */  4, 4,-1, 4,-1, 4,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '屐','屑',0,'屓',0,'展',0,0, 0,0,0,0,0,0,'属',0, */
	/* 5c60 */  4, 4,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1, 4,-1, 4, 4, /* '屠','屡',0,0,'層','履',0,0, 0,0,0,0,'屬',0,'屮','屯', */
	/* 5c70 */ -1, 4,-1,-1,-1,-1, 4,-1, -1, 4,0,0,0,0,0,0, /* 0,'山',0,0,0,0,'屶',0, 0,'屹',0,0,0,0,0,0, */
	/* 5c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'岌',0,0,0, */
	/* 5c90 */  4, 4,-1,-1, 4,0,0,0, 0,0,0,0,0,0,0,0, /* '岐','岑',0,0,'岔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5ca0 */ -1, 4,-1,-1,-1,-1,-1,-1,  4, 4,-1, 4, 4,0,0,0, /* 0,'岡',0,0,0,0,0,0, '岨','岩',0,'岫','岬',0,0,0, */
	/* 5cb0 */ -1, 4,-1, 4,-1,-1, 4, 4,  4,-1,-1, 4, 4,-1, 4,0, /* 0,'岱',0,'岳',0,0,'岶','岷', '岸',0,0,'岻','岼',0,'岾',0, */
	/* 5cc0 */ -1,-1,-1,-1,-1, 4,-1, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'峅',0,'峇', 0,0,0,0,0,0,0,0, */
	/* 5cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'峙',0,0,0,0,0,0, */
	/* 5ce0 */  4, 4,-1,-1,-1,-1,-1,-1,  4, 4, 4,-1,-1, 4,-1, 4, /* '峠','峡',0,0,0,0,0,0, '峨','峩','峪',0,0,'峭',0,'峯', */
	/* 5cf0 */  4,-1,-1,-1,-1,-1, 4,-1, -1,-1, 4, 4,-1, 4,0,0, /* '峰',0,0,0,0,0,'島',0, 0,0,'峺','峻',0,'峽',0,0, */
	/* 5d00 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1, 4,-1,-1, 4,0, /* 0,0,0,0,0,0,0,'崇', 0,0,0,'崋',0,0,'崎',0, */
	/* 5d10 */ -1, 4,-1,-1, 4, 4, 4, 4,  4, 4, 4, 4,-1,-1,-1, 4, /* 0,'崑',0,0,'崔','崕','崖','崗', '崘','崙','崚','崛',0,0,0,'崟', */
	/* 5d20 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,'崢',0,0,0,0,0, 0,'崩',0,0,0,0,0,0, */
	/* 5d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 5d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'嵋','嵌',0,'嵎',0, */
	/* 5d50 */  4,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* '嵐',0,'嵒',0,0,0,0,0, 0,0,0,0,'嵜',0,0,0, */
	/* 5d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1, 4,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,'嵩',0,0,'嵬',0,0,'嵯', */
	/* 5d70 */ -1,-1,-1, 4,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'嵳',0,0,'嵶',0, 0,0,0,0,0,0,0,0, */
	/* 5d80 */ -1,-1, 4,-1, 4,-1,-1, 4, -1,-1,-1, 4, 4,0,0,0, /* 0,0,'嶂',0,'嶄',0,0,'嶇', 0,0,0,'嶋','嶌',0,0,0, */
	/* 5d90 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* '嶐',0,0,0,0,0,0,0, 0,0,0,0,0,'嶝',0,0, */
	/* 5da0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,-1, 4,0, /* 0,0,'嶢',0,0,0,0,0, 0,0,0,0,'嶬',0,'嶮',0, */
	/* 5db0 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1, 4,-1, 4, 4,0,0, /* 0,0,0,0,0,0,0,'嶷', 0,0,'嶺',0,'嶼','嶽',0,0, */
	/* 5dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1, 4, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,'巉',0,0,'巌','巍',0,0, */
	/* 5dd0 */ -1,-1, 4, 4,-1,-1, 4,-1, -1,-1,-1, 4,-1, 4, 4,0, /* 0,0,'巒','巓',0,0,'巖',0, 0,0,0,'巛',0,'川','州',0, */
	/* 5de0 */ -1, 4,-1, 4,-1, 4, 4, 4,  4,-1,-1, 4,-1,-1, 4,0, /* 0,'巡',0,'巣',0,'工','左','巧', '巨',0,0,'巫',0,0,'差',0, */
	/* 5df0 */ -1, 4, 4, 4, 4, 4,-1, 4, -1,-1,-1, 4,-1, 4, 4,0, /* 0,'己','已','巳','巴','巵',0,'巷', 0,0,0,'巻',0,'巽','巾',0, */
	/* 5e00 */ -1,-1, 4, 4,-1,-1, 4,-1, -1,-1,-1, 4, 4,0,0,0, /* 0,0,'市','布',0,0,'帆',0, 0,0,0,'帋','希',0,0,0, */
	/* 5e10 */ -1, 4,-1,-1,-1,-1, 4,-1, -1, 4, 4, 4,-1, 4,0,0, /* 0,'帑',0,0,0,0,'帖',0, 0,'帙','帚','帛',0,'帝',0,0, */
	/* 5e20 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1, 4,-1, 4,-1, 4, /* 0,0,0,0,0,'帥',0,0, 0,0,0,'師',0,'席',0,'帯', */
	/* 5e30 */  4,-1,-1, 4,-1,-1, 4, 4,  4,-1,-1,-1,-1, 4,0,0, /* '帰',0,0,'帳',0,0,'帶','帷', '常',0,0,0,0,'帽',0,0, */
	/* 5e40 */  4,-1,-1, 4, 4, 4,-1, 4, -1,-1,-1,-1, 4,-1, 4,0, /* '幀',0,0,'幃','幄','幅',0,'幇', 0,0,0,0,'幌',0,'幎',0, */
	/* 5e50 */ -1,-1,-1,-1, 4, 4,-1, 4, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,'幔','幕',0,'幗', 0,0,0,0,0,0,0,'幟', */
	/* 5e60 */ -1, 4, 4, 4, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'幡','幢','幣','幤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5e70 */ -1,-1, 4, 4, 4, 4, 4,-1,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,0,'干','平','年','幵','并',0, '幸','幹','幺','幻','幼','幽','幾','广', */
	/* 5e80 */ -1, 4,-1, 4, 4,-1,-1, 4, -1,-1, 4,-1,-1,-1,-1, 4, /* 0,'庁',0,'広','庄',0,0,'庇', 0,0,'床',0,0,0,0,'序', */
	/* 5e90 */ -1,-1,-1,-1,-1, 4, 4, 4, -1,-1, 4,-1, 4,0,0,0, /* 0,0,0,0,0,'底','庖','店', 0,0,'庚',0,'府',0,0,0, */
	/* 5ea0 */  4,-1,-1,-1,-1,-1, 4, 4, -1,-1,-1, 4,-1, 4,0,0, /* '庠',0,0,0,0,0,'度','座', 0,0,0,'庫',0,'庭',0,0, */
	/* 5eb0 */ -1,-1,-1,-1,-1, 4, 4, 4,  4,0,0,0,0,0,0,0, /* 0,0,0,0,0,'庵','庶','康', '庸',0,0,0,0,0,0,0, */
	/* 5ec0 */ -1, 4, 4, 4,-1,-1,-1,-1,  4, 4, 4,-1,-1,-1,-1, 4, /* 0,'廁','廂','廃',0,0,0,0, '廈','廉','廊',0,0,0,0,'廏', */
	/* 5ed0 */  4,-1,-1, 4,-1,-1, 4,-1, -1,-1, 4, 4,-1, 4,-1, 4, /* '廐',0,0,'廓',0,0,'廖',0, 0,0,'廚','廛',0,'廝',0,'廟', */
	/* 5ee0 */  4, 4, 4, 4,-1,-1,-1,-1,  4, 4,-1,-1, 4,0,0,0, /* '廠','廡','廢','廣',0,0,0,0, '廨','廩',0,0,'廬',0,0,0, */
	/* 5ef0 */  4, 4,-1, 4, 4,-1, 4, 4,  4,-1, 4, 4, 4,-1, 4, 4, /* '廰','廱',0,'廳','廴',0,'延','廷', '廸',0,'建','廻','廼',0,'廾','廿', */
	/* 5f00 */ -1, 4,-1, 4, 4,-1,-1,-1, -1, 4, 4, 4, 4, 4,-1, 4, /* 0,'弁',0,'弃','弄',0,0,0, 0,'弉','弊','弋','弌','弍',0,'式', */
	/* 5f10 */  4, 4,-1, 4, 4, 4, 4, 4,  4,-1,-1, 4,-1,-1,-1, 4, /* '弐','弑',0,'弓','弔','引','弖','弗', '弘',0,0,'弛',0,0,0,'弟', */
	/* 5f20 */ -1,-1,-1,-1,-1, 4, 4, 4, -1, 4,-1,-1,-1, 4,-1, 4, /* 0,0,0,0,0,'弥','弦','弧', 0,'弩',0,0,0,'弭',0,'弯', */
	/* 5f30 */ -1, 4,-1,-1,-1, 4,-1, 4,  4,-1,-1,-1, 4,-1, 4,0, /* 0,'弱',0,0,0,'張',0,'強', '弸',0,0,0,'弼',0,'弾',0, */
	/* 5f40 */ -1, 4,-1,-1,-1,-1,-1,-1,  4,-1, 4,-1, 4,-1, 4,0, /* 0,'彁',0,0,0,0,0,0, '彈',0,'彊',0,'彌',0,'彎',0, */
	/* 5f50 */ -1, 4,-1, 4,-1,-1, 4, 4, -1, 4,-1,-1, 4, 4,0,0, /* 0,'彑',0,'当',0,0,'彖','彗', 0,'彙',0,0,'彜','彝',0,0, */
	/* 5f60 */ -1, 4, 4,-1,-1,-1, 4,-1, -1, 4, 4, 4, 4, 4,0,0, /* 0,'彡','形',0,0,0,'彦',0, 0,'彩','彪','彫','彬','彭',0,0, */
	/* 5f70 */  4, 4,-1, 4,-1,-1,-1, 4, -1, 4,-1,-1, 4,-1,-1, 4, /* '彰','影',0,'彳',0,0,0,'彷', 0,'役',0,0,'彼',0,0,'彿', */
	/* 5f80 */  4, 4, 4, 4, 4, 4,-1, 4,  4,-1, 4, 4, 4,0,0,0, /* '往','征','徂','徃','径','待',0,'徇', '很',0,'徊','律','後',0,0,0, */
	/* 5f90 */  4, 4, 4, 4,-1,-1,-1, 4,  4, 4,-1,-1,-1,-1, 4,0, /* '徐','徑','徒','従',0,0,0,'得', '徘','徙',0,0,0,0,'從',0, */
	/* 5fa0 */  4, 4,-1,-1,-1,-1,-1,-1,  4, 4, 4,-1,-1, 4, 4,0, /* '徠','御',0,0,0,0,0,0, '徨','復','循',0,0,'徭','微',0, */
	/* 5fb0 */ -1,-1,-1, 4, 4,-1,-1,-1, -1, 4,-1,-1, 4, 4,0,0, /* 0,0,0,'徳','徴',0,0,0, 0,'徹',0,0,'徼','徽',0,0, */
	/* 5fc0 */ -1,-1,-1, 4,-1, 4,-1,-1, -1,-1,-1,-1, 4, 4,0,0, /* 0,0,0,'心',0,'必',0,0, 0,0,0,0,'忌','忍',0,0, */
	/* 5fd0 */ -1,-1,-1,-1,-1,-1, 4, 4,  4, 4,-1,-1, 4, 4,0,0, /* 0,0,0,0,0,0,'忖','志', '忘','忙',0,0,'応','忝',0,0, */
	/* 5fe0 */  4,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* '忠',0,0,0,'忤',0,0,0, 0,0,0,'快',0,0,0,0, */
	/* 5ff0 */  4, 4,-1,-1,-1, 4,-1,-1,  4,-1,-1, 4,-1, 4,-1, 4, /* '忰','忱',0,0,0,'念',0,0, '忸',0,0,'忻',0,'忽',0,'忿', */
	/* 6000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'怎','怏', */
	/* 6010 */  4,-1, 4,-1,-1, 4, 4,-1, -1, 4,-1, 4, 4, 4,0,0, /* '怐',0,'怒',0,0,'怕','怖',0, 0,'怙',0,'怛','怜','思',0,0, */
	/* 6020 */  4, 4,-1,-1,-1, 4, 4, 4,  4, 4, 4, 4,-1,-1,-1, 4, /* '怠','怡',0,0,0,'急','怦','性', '怨','怩','怪','怫',0,0,0,'怯', */
	/* 6030 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,'怱',0,0,0,0,0,0, 0,0,'怺',0,0,0,0,0, */
	/* 6040 */ -1, 4, 4, 4,-1,-1, 4,-1, -1,-1, 4, 4,-1, 4,0,0, /* 0,'恁','恂','恃',0,0,'恆',0, 0,0,'恊','恋',0,'恍',0,0, */
	/* 6050 */  4,-1, 4,-1,-1, 4,-1,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* '恐',0,'恒',0,0,'恕',0,0, 0,'恙','恚',0,0,0,0,'恟', */
	/* 6060 */  4,-1, 4, 4, 4, 4,-1,-1,  4, 4, 4, 4, 4, 4,-1, 4, /* '恠',0,'恢','恣','恤','恥',0,0, '恨','恩','恪','恫','恬','恭',0,'息', */
	/* 6070 */  4,-1,-1,-1,-1, 4,-1, 4, 0,0,0,0,0,0,0,0, /* '恰',0,0,0,0,'恵',0,'恷', 0,0,0,0,0,0,0,0, */
	/* 6080 */ -1, 4,-1, 4, 4,-1,-1,-1, -1, 4,-1, 4, 4, 4,0,0, /* 0,'悁',0,'悃','悄',0,0,0, 0,'悉',0,'悋','悌','悍',0,0, */
	/* 6090 */ -1,-1, 4,-1, 4,-1, 4, 4, -1,-1, 4, 4,-1,-1,-1, 4, /* 0,0,'悒',0,'悔',0,'悖','悗', 0,0,'悚','悛',0,0,0,'悟', */
	/* 60a0 */  4,-1,-1, 4,-1,-1, 4, 4, -1, 4, 4,0,0,0,0,0, /* '悠',0,0,'患',0,0,'悦','悧', 0,'悩','悪',0,0,0,0,0, */
	/* 60b0 */ -1,-1, 4, 4, 4, 4, 4,-1,  4,-1,-1,-1, 4, 4,0,0, /* 0,0,'悲','悳','悴','悵','悶',0, '悸',0,0,0,'悼','悽',0,0, */
	/* 60c0 */ -1,-1,-1,-1,-1, 4, 4, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'情','惆','惇', 0,0,0,0,0,0,0,0, */
	/* 60d0 */ -1, 4,-1, 4,-1,-1,-1,-1,  4,-1, 4,-1, 4,-1,-1, 4, /* 0,'惑',0,'惓',0,0,0,0, '惘',0,'惚',0,'惜',0,0,'惟', */
	/* 60e0 */  4, 4,-1, 4,-1,-1,-1, 4,  4,0,0,0,0,0,0,0, /* '惠','惡',0,'惣',0,0,0,'惧', '惨',0,0,0,0,0,0,0, */
	/* 60f0 */  4, 4,-1, 4, 4,-1, 4, 4, -1, 4, 4, 4,0,0,0,0, /* '惰','惱',0,'想','惴',0,'惶','惷', 0,'惹','惺','惻',0,0,0,0, */
	/* 6100 */  4, 4,-1, 4,-1,-1, 4,-1,  4, 4,-1,-1,-1, 4, 4, 4, /* '愀','愁',0,'愃',0,0,'愆',0, '愈','愉',0,0,0,'愍','愎','意', */
	/* 6110 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1, 4, 4,-1,-1,-1, 4, /* 0,0,0,0,0,'愕',0,0, 0,0,'愚','愛',0,0,0,'感', */
	/* 6120 */ -1, 4,-1,-1,-1,-1,-1, 4,  4,-1,-1,-1, 4,0,0,0, /* 0,'愡',0,0,0,0,0,'愧', '愨',0,0,0,'愬',0,0,0, */
	/* 6130 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1, 4, 4, 4, 4, /* 0,0,0,0,'愴',0,0,0, 0,0,0,0,'愼','愽','愾','愿', */
	/* 6140 */ -1,-1, 4,-1, 4,-1,-1, 4,  4,-1, 4, 4, 4, 4, 4,0, /* 0,0,'慂',0,'慄',0,0,'慇', '慈',0,'慊','態','慌','慍','慎',0, */
	/* 6150 */ -1,-1,-1, 4,-1, 4,-1,-1,  4, 4, 4,-1,-1, 4,-1, 4, /* 0,0,0,'慓',0,'慕',0,0, '慘','慙','慚',0,0,'慝',0,'慟', */
	/* 6160 */ -1,-1, 4, 4,-1, 4,-1, 4,  4,-1,-1, 4,-1,-1, 4, 4, /* 0,0,'慢','慣',0,'慥',0,'慧', '慨',0,0,'慫',0,0,'慮','慯', */
	/* 6170 */  4, 4,-1, 4, 4, 4, 4, 4, -1,-1,-1,-1,-1,-1, 4,0, /* '慰','慱',0,'慳','慴','慵','慶','慷', 0,0,0,0,0,0,'慾',0, */
	/* 6180 */ -1,-1, 4,-1,-1,-1,-1, 4, -1,-1, 4,-1,-1,-1, 4,0, /* 0,0,'憂',0,0,0,0,'憇', 0,0,'憊',0,0,0,'憎',0, */
	/* 6190 */  4, 4,-1,-1, 4,-1, 4,-1, -1, 4, 4,0,0,0,0,0, /* '憐','憑',0,0,'憔',0,'憖',0, 0,'憙','憚',0,0,0,0,0, */
	/* 61a0 */ -1,-1,-1,-1, 4,-1,-1, 4, -1, 4,-1, 4, 4,-1, 4,0, /* 0,0,0,0,'憤',0,0,'憧', 0,'憩',0,'憫','憬',0,'憮',0, */
	/* 61b0 */ -1,-1, 4,-1,-1,-1, 4,-1, -1,-1, 4,-1,-1,-1, 4,0, /* 0,0,'憲',0,0,0,'憶',0, 0,0,'憺',0,0,0,'憾',0, */
	/* 61c0 */ -1,-1,-1, 4,-1,-1, 4, 4,  4, 4, 4, 4, 4, 4,0,0, /* 0,0,0,'懃',0,0,'懆','懇', '懈','應','懊','懋','懌','懍',0,0, */
	/* 61d0 */  4,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '懐',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 61e0 */ -1,-1,-1, 4,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'懣',0,0,'懦',0, 0,0,0,0,0,0,0,0, */
	/* 61f0 */ -1,-1, 4,-1, 4,-1, 4, 4,  4,-1, 4,-1, 4, 4, 4, 4, /* 0,0,'懲',0,'懴',0,'懶','懷', '懸',0,'懺',0,'懼','懽','懾','懿', */
	/* 6200 */  4,-1,-1,-1,-1,-1,-1,-1,  4, 4, 4,-1, 4, 4, 4,0, /* '戀',0,0,0,0,0,0,0, '戈','戉','戊',0,'戌','戍','戎',0, */
	/* 6210 */  4, 4, 4,-1, 4,-1, 4,-1, -1,-1, 4, 4,-1, 4, 4, 4, /* '成','我','戒',0,'戔',0,'或',0, 0,0,'戚','戛',0,'戝','戞','戟', */
	/* 6220 */ -1, 4,-1,-1,-1,-1, 4,-1, -1,-1, 4,-1,-1,-1, 4, 4, /* 0,'戡',0,0,0,0,'戦',0, 0,0,'截',0,0,0,'戮','戯', */
	/* 6230 */  4,-1, 4, 4, 4,-1,-1,-1,  4,-1,-1, 4,-1,-1,-1, 4, /* '戰',0,'戲','戳','戴',0,0,0, '戸',0,0,'戻',0,0,0,'房', */
	/* 6240 */  4, 4,-1,-1,-1,-1,-1, 4,  4, 4,-1, 4,-1, 4, 4,0, /* '所','扁',0,0,0,0,0,'扇', '扈','扉',0,'手',0,'才','扎',0, */
	/* 6250 */ -1,-1,-1, 4,-1, 4,-1,-1,  4,-1,-1, 4,-1,-1, 4,0, /* 0,0,0,'打',0,'払',0,0, '托',0,0,'扛',0,0,'扞',0, */
	/* 6260 */  4,-1,-1, 4,-1,-1,-1,-1,  4,-1,-1,-1,-1,-1, 4,0, /* '扠',0,0,'扣',0,0,0,0, '扨',0,0,0,0,0,'扮',0, */
	/* 6270 */ -1, 4,-1,-1,-1,-1, 4,-1, -1, 4,-1,-1, 4,-1, 4, 4, /* 0,'扱',0,0,0,0,'扶',0, 0,'批',0,0,'扼',0,'找','承', */
	/* 6280 */  4,-1, 4, 4, 4,-1,-1,-1, -1, 4, 4,0,0,0,0,0, /* '技',0,'抂','抃','抄',0,0,0, 0,'抉','把',0,0,0,0,0, */
	/* 6290 */ -1, 4, 4, 4, 4, 4, 4, 4,  4,-1,-1, 4, 4,-1, 4,0, /* 0,'抑','抒','抓','抔','投','抖','抗', '折',0,0,'抛','抜',0,'択',0, */
	/* 62a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'披','抬',0,0,0, */
	/* 62b0 */ -1, 4,-1,-1,-1, 4,-1,-1, -1, 4,-1, 4, 4, 4,0,0, /* 0,'抱',0,0,0,'抵',0,0, 0,'抹',0,'抻','押','抽',0,0, */
	/* 62c0 */ -1,-1, 4,-1,-1, 4, 4, 4,  4, 4, 4,-1, 4, 4,-1, 4, /* 0,0,'拂',0,0,'担','拆','拇', '拈','拉','拊',0,'拌','拍',0,'拏', */
	/* 62d0 */  4, 4, 4, 4, 4,-1,-1, 4,  4, 4,-1, 4, 4, 4,0,0, /* '拐','拑','拒','拓','拔',0,0,'拗', '拘','拙',0,'招','拜','拝',0,0, */
	/* 62e0 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4, 4, 4, 4, /* '拠','拡',0,0,0,0,0,0, 0,0,0,0,'括','拭','拮','拯', */
	/* 62f0 */ -1, 4,-1, 4,-1, 4, 4, 4, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,'拱',0,'拳',0,'拵','拶','拷', 0,0,0,0,0,0,'拾','拿', */
	/* 6300 */ -1, 4, 4,-1,-1,-1,-1, 4,  4, 4,-1,-1, 4,0,0,0, /* 0,'持','挂',0,0,0,0,'指', '挈','按',0,0,'挌',0,0,0, */
	/* 6310 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,'挑',0,0,0,0,0,0, 0,'挙',0,0,0,0,0,'挟', */
	/* 6320 */ -1,-1,-1,-1,-1,-1,-1, 4,  4,-1,-1, 4,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,'挧', '挨',0,0,'挫',0,0,0,'振', */
	/* 6330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,'挺',0,0,'挽','挾','挿', */
	/* 6340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1, 4, 4,-1, 4, /* 0,0,0,0,0,0,0,0, 0,'捉',0,0,'捌','捍',0,'捏', */
	/* 6350 */  4,-1,-1,-1,-1, 4,-1, 4, -1,-1,-1,-1, 4,0,0,0, /* '捐',0,0,0,0,'捕',0,'捗', 0,0,0,0,'捜',0,0,0, */
	/* 6360 */ -1,-1,-1,-1,-1,-1,-1, 4,  4, 4,-1, 4,-1,-1, 4,0, /* 0,0,0,0,0,0,0,'捧', '捨','捩',0,'捫',0,0,'据',0, */
	/* 6370 */ -1,-1, 4,-1,-1,-1, 4, 4, -1,-1, 4, 4,0,0,0,0, /* 0,0,'捲',0,0,0,'捶','捷', 0,0,'捺','捻',0,0,0,0, */
	/* 6380 */  4,-1,-1, 4,-1,-1,-1,-1,  4, 4,-1,-1, 4,-1, 4, 4, /* '掀',0,0,'掃',0,0,0,0, '授','掉',0,0,'掌',0,'掎','掏', */
	/* 6390 */ -1,-1, 4,-1,-1,-1, 4,-1,  4,-1,-1, 4,-1,-1,-1, 4, /* 0,0,'排',0,0,0,'掖',0, '掘',0,0,'掛',0,0,0,'掟', */
	/* 63a0 */  4, 4, 4, 4,-1, 4,-1, 4,  4, 4, 4, 4, 4,0,0,0, /* '掠','採','探','掣',0,'接',0,'控', '推','掩','措','掫','掬',0,0,0, */
	/* 63b0 */ -1,-1, 4,-1, 4, 4,-1,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,0,'掲',0,'掴','掵',0,0, 0,0,0,'掻',0,0,'掾',0, */
	/* 63c0 */  4,-1,-1, 4, 4,-1, 4,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* '揀',0,0,'揃','揄',0,'揆',0, 0,'揉',0,0,0,0,0,'描', */
	/* 63d0 */  4,-1, 4,-1,-1,-1, 4,-1, -1,-1, 4, 4,0,0,0,0, /* '提',0,'插',0,0,0,'揖',0, 0,0,'揚','換',0,0,0,0, */
	/* 63e0 */ -1, 4,-1, 4,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1, 4,0, /* 0,'握',0,'揣',0,0,0,0, 0,'揩',0,0,0,0,'揮',0, */
	/* 63f0 */ -1,-1,-1,-1, 4,-1, 4,-1, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,'援',0,'揶',0, 0,0,'揺',0,0,0,0,0, */
	/* 6400 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1, 4,-1, 4, /* 0,0,0,0,0,0,'搆',0, 0,0,0,0,0,'損',0,'搏', */
	/* 6410 */ -1,-1,-1, 4,-1,-1, 4, 4, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,'搓',0,0,'搖','搗', 0,0,0,0,'搜',0,0,0, */
	/* 6420 */ -1,-1,-1,-1,-1,-1, 4,-1,  4,-1,-1,-1, 4, 4,0,0, /* 0,0,0,0,0,0,'搦',0, '搨',0,0,0,'搬','搭',0,0, */
	/* 6430 */ -1,-1,-1,-1, 4,-1, 4,-1, -1,-1, 4,-1,-1,-1, 4,0, /* 0,0,0,0,'搴',0,'搶',0, 0,0,'携',0,0,0,'搾',0, */
	/* 6440 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,'摂',0,0,0,0,0, 0,0,0,0,0,0,'摎',0, */
	/* 6450 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '摘',0,0,0,0,0,0,0, */
	/* 6460 */ -1,-1,-1,-1,-1,-1,-1, 4, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,'摧', 0,'摩',0,0,0,0,0,'摯', */
	/* 6470 */ -1,-1,-1,-1,-1,-1, 4,-1,  4,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,'摶',0, '摸',0,'摺',0,0,0,0,0, */
	/* 6480 */ -1,-1,-1, 4,-1,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,0,0,'撃',0,0,0,0, '撈',0,0,0,0,0,0,0, */
	/* 6490 */ -1,-1, 4, 4,-1, 4,-1,-1, -1,-1, 4,-1,-1,-1, 4,0, /* 0,0,'撒','撓',0,'撕',0,0, 0,0,'撚',0,0,0,'撞',0, */
	/* 64a0 */ -1,-1,-1,-1, 4, 4,-1,-1, -1, 4,-1, 4,-1, 4, 4,0, /* 0,0,0,0,'撤','撥',0,0, 0,'撩',0,'撫',0,'播','撮',0, */
	/* 64b0 */  4,-1, 4,-1,-1,-1,-1,-1, -1, 4,-1, 4, 4,0,0,0, /* '撰',0,'撲',0,0,0,0,0, 0,'撹',0,'撻','撼',0,0,0, */
	/* 64c0 */ -1, 4, 4,-1,-1, 4,-1, 4, -1,-1,-1,-1,-1, 4,0,0, /* 0,'擁','擂',0,0,'擅',0,'擇', 0,0,0,0,0,'操',0,0, */
	/* 64d0 */ -1,-1, 4,-1, 4,-1,-1,-1,  4,-1, 4,0,0,0,0,0, /* 0,0,'擒',0,'擔',0,0,0, '擘',0,'據',0,0,0,0,0, */
	/* 64e0 */  4, 4, 4, 4,-1,-1, 4, 4, -1,-1,-1,-1, 4,-1,-1, 4, /* '擠','擡','擢','擣',0,0,'擦','擧', 0,0,0,0,'擬',0,0,'擯', */
	/* 64f0 */ -1, 4, 4,-1, 4,-1, 4,-1, -1,-1, 4,-1,-1, 4, 4,0, /* 0,'擱','擲',0,'擴',0,'擶',0, 0,0,'擺',0,0,'擽','擾',0, */
	/* 6500 */  4,-1,-1,-1,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* '攀',0,0,0,0,'攅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6510 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1,-1, 4, 4,0,0, /* 0,0,0,0,0,0,0,0, '攘',0,0,0,'攜','攝',0,0, */
	/* 6520 */ -1,-1,-1, 4, 4,-1,-1,-1, -1,-1, 4, 4, 4,-1,-1, 4, /* 0,0,0,'攣','攤',0,0,0, 0,0,'攪','攫','攬',0,0,'支', */
	/* 6530 */ -1,-1,-1,-1, 4, 4, 4, 4,  4, 4,-1, 4,-1,-1, 4, 4, /* 0,0,0,0,'攴','攵','收','攷', '攸','改',0,'攻',0,0,'放','政', */
	/* 6540 */ -1,-1,-1,-1,-1, 4,-1,-1,  4,-1,-1,-1,-1, 4,-1, 4, /* 0,0,0,0,0,'故',0,0, '效',0,0,0,0,'敍',0,'敏', */
	/* 6550 */ -1, 4,-1,-1,-1, 4, 4, 4,  4, 4,-1,-1,-1, 4, 4,0, /* 0,'救',0,0,0,'敕','敖','敗', '敘','教',0,0,0,'敝','敞',0, */
	/* 6560 */ -1,-1, 4, 4,-1,-1, 4,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,'敢','散',0,0,'敦',0, 0,0,0,0,'敬',0,0,0, */
	/* 6570 */  4,-1, 4,-1, 4, 4,-1, 4,  4,0,0,0,0,0,0,0, /* '数',0,'敲',0,'整','敵',0,'敷', '數',0,0,0,0,0,0,0, */
	/* 6580 */ -1,-1, 4, 4,-1,-1,-1, 4,  4, 4,-1,-1, 4,-1, 4,0, /* 0,0,'斂','斃',0,0,0,'文', '斈','斉',0,0,'斌',0,'斎',0, */
	/* 6590 */  4, 4,-1,-1,-1,-1,-1, 4, -1, 4,-1, 4, 4,-1,-1, 4, /* '斐','斑',0,0,0,0,0,'斗', 0,'料',0,'斛','斜',0,0,'斟', */
	/* 65a0 */ -1, 4,-1,-1, 4, 4,-1, 4, -1,-1,-1, 4, 4, 4,-1, 4, /* 0,'斡',0,0,'斤','斥',0,'斧', 0,0,0,'斫','斬','断',0,'斯', */
	/* 65b0 */  4,-1,-1,-1,-1,-1,-1, 4, -1, 4,-1,-1, 4, 4,0,0, /* '新',0,0,0,0,0,0,'斷', 0,'方',0,0,'於','施',0,0, */
	/* 65c0 */ -1, 4,-1, 4, 4, 4, 4,-1, -1,-1,-1, 4, 4,-1,-1, 4, /* 0,'旁',0,'旃','旄','旅','旆',0, 0,0,0,'旋','旌',0,0,'族', */
	/* 65d0 */ -1,-1, 4,-1,-1,-1,-1, 4, -1, 4,-1, 4,0,0,0,0, /* 0,0,'旒',0,0,0,0,'旗', 0,'旙',0,'旛',0,0,0,0, */
	/* 65e0 */  4, 4, 4,-1,-1, 4, 4, 4,  4, 4,-1,-1, 4, 4,0,0, /* '无','旡','既',0,0,'日','旦','旧', '旨','早',0,0,'旬','旭',0,0, */
	/* 65f0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4,0,0,0,0, /* 0,'旱',0,0,0,0,0,0, 0,0,'旺','旻',0,0,0,0, */
	/* 6600 */ -1,-1, 4, 4,-1,-1, 4, 4, -1,-1, 4,-1, 4,-1, 4, 4, /* 0,0,'昂','昃',0,0,'昆','昇', 0,0,'昊',0,'昌',0,'明','昏', */
	/* 6610 */ -1,-1,-1, 4, 4,-1,-1,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,'易','昔',0,0,0, 0,0,0,0,'昜',0,0,'星', */
	/* 6620 */  4,-1,-1,-1,-1, 4,-1, 4,  4,-1,-1,-1,-1, 4,-1, 4, /* '映',0,0,0,0,'春',0,'昧', '昨',0,0,0,0,'昭',0,'是', */
	/* 6630 */ -1,-1,-1,-1, 4, 4, 4,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,0,'昴','昵','昶',0, 0,0,0,0,'昼',0,0,'昿', */
	/* 6640 */ -1, 4, 4, 4, 4,-1,-1,-1, -1, 4,-1, 4,-1,-1,-1, 4, /* 0,'晁','時','晃','晄',0,0,0, 0,'晉',0,'晋',0,0,0,'晏', */
	/* 6650 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4, 4, /* 0,0,'晒',0,0,0,0,0, 0,0,0,0,0,'晝','晞','晟', */
	/* 6660 */ -1,-1, 4,-1, 4,-1, 4, 4,  4, 4,-1,-1,-1,-1, 4, 4, /* 0,0,'晢',0,'晤',0,'晦','晧', '晨','晩',0,0,0,0,'普','景', */
	/* 6670 */  4,-1,-1,-1, 4,-1, 4,-1, -1,-1, 4,0,0,0,0,0, /* '晰',0,0,0,'晴',0,'晶',0, 0,0,'智',0,0,0,0,0, */
	/* 6680 */ -1, 4,-1, 4, 4,-1,-1, 4,  4, 4,-1,-1,-1,-1, 4,0, /* 0,'暁',0,'暃','暄',0,0,'暇', '暈','暉',0,0,0,0,'暎',0, */
	/* 6690 */ -1, 4,-1,-1,-1,-1, 4, 4,  4,-1,-1,-1,-1, 4,0,0, /* 0,'暑',0,0,0,0,'暖','暗', '暘',0,0,0,0,'暝',0,0, */
	/* 66a0 */ -1,-1, 4,-1,-1,-1, 4,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,0,'暢',0,0,0,'暦',0, 0,0,0,'暫',0,0,'暮',0, */
	/* 66b0 */ -1,-1,-1,-1, 4,-1,-1,-1,  4, 4,-1,-1, 4,-1, 4,0, /* 0,0,0,0,'暴',0,0,0, '暸','暹',0,0,'暼',0,'暾',0, */
	/* 66c0 */ -1, 4,-1,-1, 4,-1,-1, 4, -1, 4,0,0,0,0,0,0, /* 0,'曁',0,0,'曄',0,0,'曇', 0,'曉',0,0,0,0,0,0, */
	/* 66d0 */ -1,-1,-1,-1,-1,-1, 4,-1, -1, 4, 4,-1, 4, 4,0,0, /* 0,0,0,0,0,0,'曖',0, 0,'曙','曚',0,'曜','曝',0,0, */
	/* 66e0 */  4,-1,-1,-1,-1,-1, 4,-1, -1, 4,0,0,0,0,0,0, /* '曠',0,0,0,0,0,'曦',0, 0,'曩',0,0,0,0,0,0, */
	/* 66f0 */  4,-1, 4, 4, 4, 4,-1, 4,  4, 4,-1,-1, 4, 4, 4, 4, /* '曰',0,'曲','曳','更','曵',0,'曷', '書','曹',0,0,'曼','曽','曾','替', */
	/* 6700 */  4,-1,-1, 4,-1,-1,-1,-1,  4, 4,-1, 4,-1, 4,-1, 4, /* '最',0,0,'會',0,0,0,0, '月','有',0,'朋',0,'服',0,'朏', */
	/* 6710 */ -1,-1,-1,-1, 4, 4, 4, 4, -1,-1,-1, 4,-1, 4, 4, 4, /* 0,0,0,0,'朔','朕','朖','朗', 0,0,0,'望',0,'朝','朞','期', */
	/* 6720 */ -1,-1,-1,-1,-1,-1, 4, 4,  4,-1, 4, 4, 4, 4, 4,0, /* 0,0,0,0,0,0,'朦','朧', '木',0,'未','末','本','札','朮',0, */
	/* 6730 */ -1, 4,-1,-1, 4,-1, 4, 4,  4,-1, 4,-1,-1, 4,-1, 4, /* 0,'朱',0,0,'朴',0,'朶','朷', '朸',0,'机',0,0,'朽',0,'朿', */
	/* 6740 */ -1, 4,-1,-1,-1,-1, 4,-1, -1, 4,-1,-1,-1,-1, 4, 4, /* 0,'杁',0,0,0,0,'杆',0, 0,'杉',0,0,0,0,'李','杏', */
	/* 6750 */  4, 4,-1, 4,-1,-1, 4,-1, -1, 4,-1,-1, 4,-1, 4, 4, /* '材','村',0,'杓',0,0,'杖',0, 0,'杙',0,0,'杜',0,'杞','束', */
	/* 6760 */  4, 4, 4, 4, 4, 4,-1,-1, -1,-1, 4,-1,-1, 4,-1, 4, /* '杠','条','杢','杣','杤','来',0,0, 0,0,'杪',0,0,'杭',0,'杯', */
	/* 6770 */  4, 4, 4, 4,-1, 4,-1, 4, -1,-1,-1,-1, 4,-1, 4, 4, /* '杰','東','杲','杳',0,'杵',0,'杷', 0,0,0,0,'杼',0,'松','板', */
	/* 6780 */ -1,-1,-1,-1,-1, 4,-1, 4, -1, 4,-1, 4, 4,0,0,0, /* 0,0,0,0,0,'枅',0,'枇', 0,'枉',0,'枋','枌',0,0,0, */
	/* 6790 */  4,-1,-1,-1,-1, 4,-1, 4, -1,-1, 4,-1, 4, 4,0,0, /* '析',0,0,0,0,'枕',0,'林', 0,0,'枚',0,'果','枝',0,0, */
	/* 67a0 */  4, 4, 4,-1,-1,-1, 4,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* '枠','枡','枢',0,0,0,'枦',0, 0,'枩',0,0,0,0,0,'枯', */
	/* 67b0 */ -1,-1,-1, 4, 4,-1, 4, 4,  4, 4,0,0,0,0,0,0, /* 0,0,0,'枳','枴',0,'架','枷', '枸','枹',0,0,0,0,0,0, */
	/* 67c0 */ -1, 4,-1,-1, 4,-1, 4,-1, -1,-1, 4,-1,-1,-1, 4, 4, /* 0,'柁',0,0,'柄',0,'柆',0, 0,0,'柊',0,0,0,'柎','柏', */
	/* 67d0 */  4, 4,-1, 4, 4,-1,-1,-1,  4,-1, 4,-1,-1, 4, 4,0, /* '某','柑',0,'染','柔',0,0,0, '柘',0,'柚',0,0,'柝','柞',0, */
	/* 67e0 */ -1,-1, 4,-1, 4,-1,-1, 4, -1, 4,-1,-1, 4,-1, 4, 4, /* 0,0,'柢',0,'柤',0,0,'柧', 0,'柩',0,0,'柬',0,'柮','柯', */
	/* 67f0 */ -1, 4,-1, 4, 4, 4,-1,-1, -1,-1,-1, 4,-1,-1, 4, 4, /* 0,'柱',0,'柳','柴','柵',0,0, 0,0,0,'査',0,0,'柾','柿', */
	/* 6800 */ -1,-1, 4, 4, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'栂','栃','栄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6810 */ -1,-1,-1, 4,-1,-1, 4, 4, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,'栓',0,0,'栖','栗', 0,0,0,0,0,0,'栞',0, */
	/* 6820 */ -1, 4, 4,-1,-1,-1,-1,-1, -1, 4, 4, 4,0,0,0,0, /* 0,'校','栢',0,0,0,0,0, 0,'栩','株','栫',0,0,0,0, */
	/* 6830 */ -1,-1, 4,-1, 4,-1,-1,-1,  4, 4,-1,-1, 4, 4,0,0, /* 0,0,'栲',0,'栴',0,0,0, '核','根',0,0,'格','栽',0,0, */
	/* 6840 */  4, 4, 4, 4,-1,-1, 4,-1,  4,-1,-1,-1,-1, 4, 4,0, /* '桀','桁','桂','桃',0,0,'框',0, '案',0,0,0,0,'桍','桎',0, */
	/* 6850 */  4, 4,-1, 4, 4,-1,-1,-1, -1, 4,-1,-1, 4, 4,-1, 4, /* '桐','桑',0,'桓','桔',0,0,0, 0,'桙',0,0,'桜','桝',0,'桟', */
	/* 6860 */ -1,-1,-1, 4,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,'档',0,0,0,'桧', 0,0,0,0,0,0,0,0, */
	/* 6870 */ -1,-1,-1,-1, 4,-1, 4, 4, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,0,0,0,'桴',0,'桶','桷', 0,0,0,0,0,0,'桾','桿', */
	/* 6880 */ -1, 4,-1, 4,-1, 4,-1,-1, -1,-1,-1,-1,-1, 4,-1, 4, /* 0,'梁',0,'梃',0,'梅',0,0, 0,0,0,0,0,'梍',0,'梏', */
	/* 6890 */ -1,-1,-1, 4, 4,-1,-1, 4, -1,-1,-1, 4,-1, 4,-1, 4, /* 0,0,0,'梓','梔',0,0,'梗', 0,0,0,'梛',0,'條',0,'梟', */
	/* 68a0 */  4,-1, 4,-1,-1,-1, 4, 4,  4,-1,-1,-1,-1, 4,-1, 4, /* '梠',0,'梢',0,0,0,'梦','梧', '梨',0,0,0,0,'梭',0,'梯', */
	/* 68b0 */  4, 4,-1, 4,-1, 4, 4,-1, -1, 4, 4,-1, 4,0,0,0, /* '械','梱',0,'梳',0,'梵','梶',0, 0,'梹','梺',0,'梼',0,0,0, */
	/* 68c0 */ -1,-1,-1,-1, 4,-1, 4,-1, -1, 4, 4, 4,-1, 4,0,0, /* 0,0,0,0,'棄',0,'棆',0, 0,'棉','棊','棋',0,'棍',0,0, */
	/* 68d0 */ -1,-1, 4,-1, 4, 4,-1, 4,  4,-1, 4,-1,-1,-1,-1, 4, /* 0,0,'棒',0,'棔','棕',0,'棗', '棘',0,'棚',0,0,0,0,'棟', */
	/* 68e0 */  4, 4,-1, 4,-1,-1,-1, 4, -1,-1,-1,-1,-1,-1, 4, 4, /* '棠','棡',0,'棣',0,0,0,'棧', 0,0,0,0,0,0,'森','棯', */
	/* 68f0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4, 4,0,0,0,0,0, /* 0,0,'棲',0,0,0,0,0, 0,'棹','棺',0,0,0,0,0, */
	/* 6900 */  4, 4,-1,-1, 4, 4,-1,-1,  4,-1,-1, 4, 4, 4, 4, 4, /* '椀','椁',0,0,'椄','椅',0,0, '椈',0,0,'椋','椌','植','椎','椏', */
	/* 6910 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4, 4, 4, 4,0,0,0, /* 0,0,'椒',0,0,0,0,0, 0,'椙','椚','椛','検',0,0,0, */
	/* 6920 */ -1, 4, 4, 4,-1, 4, 4,-1,  4,-1, 4,0,0,0,0,0, /* 0,'椡','椢','椣',0,'椥','椦',0, '椨',0,'椪',0,0,0,0,0, */
	/* 6930 */  4,-1,-1,-1, 4,-1, 4,-1, -1, 4,-1,-1,-1, 4,-1, 4, /* '椰',0,0,0,'椴',0,'椶',0, 0,'椹',0,0,0,'椽',0,'椿', */
	/* 6940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'楊',0,0,0,0,0, */
	/* 6950 */ -1,-1,-1, 4, 4, 4,-1,-1, -1, 4, 4,-1, 4, 4, 4,0, /* 0,0,0,'楓','楔','楕',0,0, 0,'楙','楚',0,'楜','楝','楞',0, */
	/* 6960 */  4, 4, 4,-1,-1,-1,-1,-1, -1,-1, 4, 4,-1, 4, 4, 4, /* '楠','楡','楢',0,0,0,0,0, 0,0,'楪','楫',0,'業','楮','楯', */
	/* 6970 */ -1,-1,-1, 4, 4, 4,-1, 4,  4, 4,-1,-1, 4, 4, 4,0, /* 0,0,0,'楳','楴','極',0,'楷', '楸','楹',0,0,'楼','楽','楾',0, */
	/* 6980 */ -1, 4, 4,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1,-1, 4,0, /* 0,'榁','概',0,0,0,0,0, 0,0,'榊',0,0,0,'榎',0, */
	/* 6990 */ -1, 4,-1,-1, 4, 4,-1,-1, -1,-1,-1, 4, 4,0,0,0, /* 0,'榑',0,0,'榔','榕',0,0, 0,0,0,'榛','榜',0,0,0, */
	/* 69a0 */  4,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1,-1,-1, 4,0, /* '榠',0,0,0,0,0,0,'榧', 0,0,0,0,0,0,'榮',0, */
	/* 69b0 */ -1, 4, 4,-1, 4,-1,-1,-1, -1,-1,-1, 4,-1,-1, 4, 4, /* 0,'榱','榲',0,'榴',0,0,0, 0,0,0,'榻',0,0,'榾','榿', */
	/* 69c0 */ -1, 4,-1, 4,-1,-1,-1, 4, -1,-1, 4, 4, 4, 4, 4,0, /* 0,'槁',0,'槃',0,0,0,'槇', 0,0,'槊','構','槌','槍','槎',0, */
	/* 69d0 */  4,-1,-1, 4,-1,-1,-1,-1,  4, 4,-1,-1,-1, 4, 4,0, /* '槐',0,0,'槓',0,0,0,0, '様','槙',0,0,0,'槝','槞',0, */
	/* 69e0 */ -1,-1,-1,-1,-1,-1,-1, 4,  4,-1,-1, 4,-1, 4,0,0, /* 0,0,0,0,0,0,0,'槧', '槨',0,0,'槫',0,'槭',0,0, */
	/* 69f0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4,-1, 4,-1, 4,-1, 4, /* 0,0,'槲',0,0,0,0,0, 0,'槹',0,'槻',0,'槽',0,'槿', */
	/* 6a00 */ -1,-1, 4,-1,-1, 4,-1,-1, -1,-1, 4, 4, 4,0,0,0, /* 0,0,'樂',0,0,'樅',0,0, 0,0,'樊','樋','樌',0,0,0, */
	/* 6a10 */ -1,-1, 4, 4, 4,-1,-1, 4, -1, 4,-1, 4,-1,-1, 4, 4, /* 0,0,'樒','樓','樔',0,0,'樗', 0,'標',0,'樛',0,0,'樞','樟', */
	/* 6a20 */ -1, 4, 4, 4,-1,-1,-1,-1, -1, 4, 4, 4,-1,-1, 4,0, /* 0,'模','樢','樣',0,0,0,0, 0,'権','横','樫',0,0,'樮',0, */
	/* 6a30 */ -1,-1,-1,-1,-1, 4, 4,-1,  4, 4, 4,-1,-1, 4,0,0, /* 0,0,0,0,0,'樵','樶',0, '樸','樹','樺',0,0,'樽',0,0, */
	/* 6a40 */ -1,-1,-1,-1, 4,-1,-1, 4,  4,-1,-1, 4,0,0,0,0, /* 0,0,0,0,'橄',0,0,'橇', '橈',0,0,'橋',0,0,0,0, */
	/* 6a50 */ -1,-1,-1,-1,-1,-1,-1,-1,  4, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, '橘','橙',0,0,0,0,0,'機', */
	/* 6a60 */ -1, 4, 4,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,'橡','橢',0,0,0,'橦',0, 0,0,0,0,0,0,0,0, */
	/* 6a70 */ -1,-1, 4,-1,-1,-1,-1,-1,  4,-1,-1,-1,-1,-1,-1, 4, /* 0,0,'橲',0,0,0,0,0, '橸',0,0,0,0,0,0,'橿', */
	/* 6a80 */  4,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4,0, /* '檀',0,0,0,'檄',0,0,0, 0,0,0,0,0,'檍','檎',0, */
	/* 6a90 */  4,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1, 4,0,0,0, /* '檐',0,0,0,0,0,0,'檗', 0,0,0,0,'檜',0,0,0, */
	/* 6aa0 */  4,-1, 4, 4,-1,-1,-1,-1, -1,-1, 4,-1, 4,-1, 4,0, /* '檠',0,'檢','檣',0,0,0,0, 0,0,'檪',0,'檬',0,'檮',0, */
	/* 6ab0 */ -1,-1,-1, 4,-1,-1,-1,-1,  4,-1,-1, 4,0,0,0,0, /* 0,0,0,'檳',0,0,0,0, '檸',0,0,'檻',0,0,0,0, */
	/* 6ac0 */ -1, 4, 4, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'櫁','櫂','櫃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6ad0 */ -1, 4,-1, 4,-1,-1,-1,-1, -1,-1, 4, 4,-1,-1, 4, 4, /* 0,'櫑',0,'櫓',0,0,0,0, 0,0,'櫚','櫛',0,0,'櫞','櫟', */
	/* 6ae0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '櫨',0,'櫪',0,0,0,0,0, */
	/* 6af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'櫺','櫻',0,0,0,0, */
	/* 6b00 */ -1,-1,-1,-1, 4, 4,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,'欄','欅',0,0, 0,0,'權',0,0,0,0,0, */
	/* 6b10 */ -1,-1, 4,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1, 4,-1, 4, /* 0,0,'欒',0,0,0,'欖',0, 0,0,0,0,0,'欝',0,'欟', */
	/* 6b20 */  4, 4,-1, 4,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* '欠','次',0,'欣',0,0,0,'欧', 0,0,0,0,0,0,0,0, */
	/* 6b30 */ -1,-1, 4,-1,-1,-1,-1, 4,  4, 4, 4,-1,-1, 4, 4,0, /* 0,0,'欲',0,0,0,0,'欷', '欸','欹','欺',0,0,'欽','款',0, */
	/* 6b40 */ -1,-1,-1, 4,-1,-1,-1, 4, -1, 4,-1,-1, 4,-1, 4,0, /* 0,0,0,'歃',0,0,0,'歇', 0,'歉',0,0,'歌',0,'歎',0, */
	/* 6b50 */  4,-1,-1, 4, 4,-1,-1,-1, -1, 4,-1, 4,-1,-1,-1, 4, /* '歐',0,0,'歓','歔',0,0,0, 0,'歙',0,'歛',0,0,0,'歟', */
	/* 6b60 */ -1, 4, 4, 4, 4,-1, 4,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* 0,'歡','止','正','此',0,'武',0, 0,'歩','歪',0,0,0,0,'歯', */
	/* 6b70 */ -1,-1,-1, 4, 4,-1,-1,-1,  4, 4,-1, 4,-1,-1,-1, 4, /* 0,0,0,'歳','歴',0,0,0, '歸','歹',0,'死',0,0,0,'歿', */
	/* 6b80 */  4,-1,-1, 4, 4,-1, 4,-1, -1, 4, 4, 4,-1, 4,0,0, /* '殀',0,0,'殃','殄',0,'殆',0, 0,'殉','殊','残',0,'殍',0,0, */
	/* 6b90 */ -1,-1,-1,-1,-1, 4, 4,-1,  4,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,0,0,'殕','殖',0, '殘',0,0,0,0,0,'殞',0, */
	/* 6ba0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1, 4, 4,-1,-1,-1, 4, /* 0,0,0,0,'殤',0,0,0, 0,0,'殪','殫',0,0,0,'殯', */
	/* 6bb0 */ -1, 4, 4, 4, 4, 4,-1, 4, -1,-1, 4, 4, 4,-1,-1, 4, /* 0,'殱','殲','殳','殴','段',0,'殷', 0,0,'殺','殻','殼',0,0,'殿', */
	/* 6bc0 */  4,-1,-1,-1,-1, 4, 4,-1, -1,-1,-1, 4,-1, 4, 4,0, /* '毀',0,0,0,0,'毅','毆',0, 0,0,0,'毋',0,'母','毎',0, */
	/* 6bd0 */ -1,-1, 4, 4, 4,-1,-1,-1,  4,-1,-1, 4,-1,-1,-1, 4, /* 0,0,'毒','毓','比',0,0,0, '毘',0,0,'毛',0,0,0,'毟', */
	/* 6be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,'毫','毬',0,0,'毯', */
	/* 6bf0 */ -1,-1,-1, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'毳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c00 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, '氈',0,0,0,0,0,0,'氏', */
	/* 6c10 */ -1, 4,-1, 4, 4,-1,-1, 4, -1,-1,-1, 4,0,0,0,0, /* 0,'民',0,'氓','气',0,0,'気', 0,0,0,'氛',0,0,0,0, */
	/* 6c20 */ -1,-1,-1, 4, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'氣','氤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c30 */ -1,-1,-1,-1, 4,-1,-1, 4,  4,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,0,'水',0,0,'氷', '永',0,0,0,0,0,'氾',0, */
	/* 6c40 */  4, 4, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '汀','汁','求',0,0,0,0,0, 0,0,0,0,0,0,'汎',0, */
	/* 6c50 */  4,-1,-1,-1,-1, 4,-1, 4, -1,-1, 4,-1,-1, 4, 4, 4, /* '汐',0,0,0,0,'汕',0,'汗', 0,0,'汚',0,0,'汝','汞','江', */
	/* 6c60 */  4,-1, 4,-1,-1,-1,-1,-1,  4,-1, 4,0,0,0,0,0, /* '池',0,'汢',0,0,0,0,0, '汨',0,'汪',0,0,0,0,0, */
	/* 6c70 */  4,-1, 4, 4,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4, 4,0, /* '汰',0,'汲','汳',0,0,0,0, 0,0,'決',0,0,'汽','汾',0, */
	/* 6c80 */ -1, 4, 4, 4,-1,-1,-1,-1,  4,-1,-1,-1, 4, 4,0,0, /* 0,'沁','沂','沃',0,0,0,0, '沈',0,0,0,'沌','沍',0,0, */
	/* 6c90 */  4,-1, 4, 4,-1,-1, 4,-1, -1, 4, 4, 4,0,0,0,0, /* '沐',0,'沒','沓',0,0,'沖',0, 0,'沙','沚','沛',0,0,0,0, */
	/* 6ca0 */ -1, 4, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,'没','沢',0,0,0,0,0, 0,0,0,'沫',0,0,'沮',0, */
	/* 6cb0 */ -1, 4,-1, 4,-1,-1,-1,-1,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'沱',0,'河',0,0,0,0, '沸','油','沺','治','沼','沽','沾','沿', */
	/* 6cc0 */ -1, 4,-1,-1, 4, 4,-1,-1, -1, 4, 4,-1, 4,0,0,0, /* 0,'況',0,0,'泄','泅',0,0, 0,'泉','泊',0,'泌',0,0,0, */
	/* 6cd0 */ -1,-1,-1, 4,-1, 4,-1, 4, -1, 4,-1, 4,-1, 4,0,0, /* 0,0,0,'泓',0,'法',0,'泗', 0,'泙',0,'泛',0,'泝',0,0, */
	/* 6ce0 */ -1, 4, 4, 4,-1, 4,-1,-1,  4,-1, 4,-1,-1,-1,-1, 4, /* 0,'泡','波','泣',0,'泥',0,0, '注',0,'泪',0,0,0,0,'泯', */
	/* 6cf0 */  4, 4,-1, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* '泰','泱',0,'泳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'洋','洌',0,0,0, */
	/* 6d10 */ -1,-1, 4,-1,-1,-1,-1, 4, -1, 4,-1, 4,-1,-1, 4, 4, /* 0,0,'洒',0,0,0,0,'洗', 0,'洙',0,'洛',0,0,'洞','洟', */
	/* 6d20 */ -1,-1,-1,-1,-1, 4,-1,-1, -1, 4, 4, 4,0,0,0,0, /* 0,0,0,0,0,'津',0,0, 0,'洩','洪','洫',0,0,0,0, */
	/* 6d30 */ -1,-1, 4, 4,-1, 4, 4,-1,  4,-1,-1, 4,-1, 4, 4,0, /* 0,0,'洲','洳',0,'洵','洶',0, '洸',0,0,'活',0,'洽','派',0, */
	/* 6d40 */ -1, 4,-1,-1, 4, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,'流',0,0,'浄','浅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4, 4,-1, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'浙','浚',0,'浜',0,0,0, */
	/* 6d60 */ -1,-1,-1, 4, 4,-1, 4,-1, -1, 4, 4,-1, 4,-1, 4,0, /* 0,0,0,'浣','浤',0,'浦',0, 0,'浩','浪',0,'浬',0,'浮',0, */
	/* 6d70 */ -1,-1,-1,-1, 4,-1,-1, 4,  4, 4,0,0,0,0,0,0, /* 0,0,0,0,'浴',0,0,'海', '浸','浹',0,0,0,0,0,0, */
	/* 6d80 */ -1,-1,-1,-1,-1, 4,-1,-1,  4,-1,-1,-1, 4,-1, 4,0, /* 0,0,0,0,0,'涅',0,0, '消',0,0,0,'涌',0,'涎',0, */
	/* 6d90 */ -1,-1,-1, 4,-1, 4,-1,-1, -1, 4,-1, 4, 4,0,0,0, /* 0,0,0,'涓',0,'涕',0,0, 0,'涙',0,'涛','涜',0,0,0, */
	/* 6da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'涯', */
	/* 6db0 */ -1,-1, 4,-1,-1, 4,-1,-1,  4,-1,-1,-1, 4,0,0,0, /* 0,0,'液',0,0,'涵',0,0, '涸',0,0,0,'涼',0,0,0, */
	/* 6dc0 */  4,-1,-1,-1,-1, 4, 4, 4, -1,-1,-1, 4, 4,0,0,0, /* '淀',0,0,0,0,'淅','淆','淇', 0,0,0,'淋','淌',0,0,0, */
	/* 6dd0 */ -1, 4, 4,-1,-1, 4,-1,-1,  4, 4,-1,-1,-1,-1, 4,0, /* 0,'淑','淒',0,0,'淕',0,0, '淘','淙',0,0,0,0,'淞',0, */
	/* 6de0 */ -1, 4,-1,-1, 4,-1, 4,-1,  4,-1, 4, 4, 4,-1, 4,0, /* 0,'淡',0,0,'淤',0,'淦',0, '淨',0,'淪','淫','淬',0,'淮',0, */
	/* 6df0 */ -1, 4,-1, 4,-1, 4,-1, 4, -1, 4, 4, 4,0,0,0,0, /* 0,'深',0,'淳',0,'淵',0,'混', 0,'淹','淺','添',0,0,0,0, */
	/* 6e00 */ -1,-1,-1,-1,-1, 4,-1, 4,  4, 4, 4, 4,0,0,0,0, /* 0,0,0,0,0,'清',0,'渇', '済','渉','渊','渋',0,0,0,0, */
	/* 6e10 */ -1,-1,-1, 4,-1, 4,-1,-1, -1, 4, 4, 4,-1, 4,-1, 4, /* 0,0,0,'渓',0,'渕',0,0, 0,'渙','渚','減',0,'渝',0,'渟', */
	/* 6e20 */  4, 4,-1, 4, 4, 4, 4,-1, -1, 4,-1, 4, 4, 4, 4, 4, /* '渠','渡',0,'渣','渤','渥','渦',0, 0,'温',0,'渫','測','渭','渮','港', */
	/* 6e30 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1, 4,-1,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, '游',0,'渺',0,0,0,'渾',0, */
	/* 6e40 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4, 4,0, /* 0,0,0,'湃',0,0,0,0, 0,0,'湊',0,0,'湍','湎',0, */
	/* 6e50 */ -1,-1,-1,-1,-1,-1, 4,-1,  4,-1,-1, 4,-1,-1,-1, 4, /* 0,0,0,0,0,0,'湖',0, '湘',0,0,'湛',0,0,0,'湟', */
	/* 6e60 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1, 4,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,'湧', 0,0,0,'湫',0,0,'湮','湯', */
	/* 6e70 */ -1,-1, 4,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,0,'湲',0,0,0,'湶',0, 0,0,0,0,0,0,'湾','湿', */
	/* 6e80 */  4,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* '満',0,'溂',0,0,0,0,0, 0,0,0,0,'溌',0,0,'溏', */
	/* 6e90 */  4,-1,-1,-1,-1,-1, 4,-1,  4,-1,-1,-1, 4, 4,-1, 4, /* '源',0,0,0,0,0,'準',0, '溘',0,0,0,'溜','溝',0,'溟', */
	/* 6ea0 */ -1,-1, 4,-1,-1, 4,-1,-1, -1,-1, 4,-1,-1,-1,-1, 4, /* 0,0,'溢',0,0,'溥',0,0, 0,0,'溪',0,0,0,0,'溯', */
	/* 6eb0 */ -1,-1, 4,-1,-1,-1, 4, 4, -1,-1, 4,-1,-1, 4,0,0, /* 0,0,'溲',0,0,0,'溶','溷', 0,0,'溺',0,0,'溽',0,0, */
	/* 6ec0 */ -1,-1, 4,-1, 4, 4,-1,-1, -1, 4,-1, 4, 4,0,0,0, /* 0,0,'滂',0,'滄','滅',0,0, 0,'滉',0,'滋','滌',0,0,0, */
	/* 6ed0 */ -1, 4,-1, 4, 4, 4,-1,-1, -1,-1,-1,-1,-1, 4, 4,0, /* 0,'滑',0,'滓','滔','滕',0,0, 0,0,0,0,0,'滝','滞',0, */
	/* 6ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'滬',0,0,'滯', */
	/* 6ef0 */ -1,-1, 4,-1, 4,-1,-1, 4,  4,-1,-1,-1,-1,-1, 4, 4, /* 0,0,'滲',0,'滴',0,0,'滷', '滸',0,0,0,0,0,'滾','滿', */
	/* 6f00 */ -1, 4, 4,-1,-1,-1, 4,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,'漁','漂',0,0,0,'漆',0, 0,'漉',0,0,0,0,0,'漏', */
	/* 6f10 */ -1, 4,-1, 4, 4, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,'漑',0,'漓','演','漕',0,0, 0,0,0,0,0,0,0,0, */
	/* 6f20 */  4,-1, 4, 4,-1,-1,-1,-1, -1,-1,-1, 4, 4,0,0,0, /* '漠',0,'漢','漣',0,0,0,0, 0,0,0,'漫','漬',0,0,0, */
	/* 6f30 */ -1, 4, 4,-1,-1,-1,-1,-1,  4,-1,-1,-1,-1,-1, 4, 4, /* 0,'漱','漲',0,0,0,0,0, '漸',0,0,0,0,0,'漾','漿', */
	/* 6f40 */ -1, 4,-1,-1,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,'潁',0,0,0,'潅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6f50 */ -1,-1,-1,-1, 4,-1,-1,-1,  4,-1,-1, 4, 4,-1,-1, 4, /* 0,0,0,0,'潔',0,0,0, '潘',0,0,'潛','潜',0,0,'潟', */
	/* 6f60 */ -1,-1,-1,-1, 4,-1, 4,-1, -1,-1,-1,-1,-1, 4, 4, 4, /* 0,0,0,0,'潤',0,'潦',0, 0,0,0,0,0,'潭','潮','潯', */
	/* 6f70 */  4,-1,-1,-1, 4,-1,-1,-1,  4,-1, 4,-1, 4,0,0,0, /* '潰',0,0,0,'潴',0,0,0, '潸',0,'潺',0,'潼',0,0,0, */
	/* 6f80 */  4, 4, 4,-1, 4,-1, 4,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '澀','澁','澂',0,'澄',0,'澆',0, 0,0,0,0,0,0,'澎',0, */
	/* 6f90 */ -1, 4,-1,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* 0,'澑',0,0,0,0,0,'澗', 0,0,0,0,0,0,0,0, */
	/* 6fa0 */ -1, 4,-1, 4, 4,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,'澡',0,'澣','澤',0,0,0, 0,0,'澪',0,0,0,0,0, */
	/* 6fb0 */ -1, 4,-1, 4,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,'澱',0,'澳',0,0,0,0, 0,'澹',0,0,0,0,0,0, */
	/* 6fc0 */  4, 4, 4, 4,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* '激','濁','濂','濃',0,0,'濆',0, 0,0,0,0,0,0,0,0, */
	/* 6fd0 */ -1,-1,-1,-1, 4, 4,-1,-1,  4,-1,-1, 4,-1,-1,-1, 4, /* 0,0,0,0,'濔','濕',0,0, '濘',0,0,'濛',0,0,0,'濟', */
	/* 6fe0 */  4, 4,-1,-1, 4,-1,-1,-1, -1,-1,-1, 4, 4,-1, 4, 4, /* '濠','濡',0,0,'濤',0,0,0, 0,0,0,'濫','濬',0,'濮','濯', */
	/* 6ff0 */ -1, 4,-1, 4,-1,-1, 4,-1, -1,-1, 4,-1,-1,-1, 4,0, /* 0,'濱',0,'濳',0,0,'濶',0, 0,0,'濺',0,0,0,'濾',0, */
	/* 7000 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1, 4,-1,-1,-1, 4, /* 0,'瀁',0,0,0,0,0,0, 0,'瀉',0,'瀋',0,0,0,'瀏', */
	/* 7010 */ -1, 4,-1,-1,-1, 4,-1,-1,  4,-1, 4, 4,-1, 4, 4, 4, /* 0,'瀑',0,0,0,'瀕',0,0, '瀘',0,'瀚','瀛',0,'瀝','瀞','瀟', */
	/* 7020 */ -1,-1,-1,-1,-1,-1, 4, 4, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,0,'瀦','瀧', 0,0,0,0,'瀬',0,0,0, */
	/* 7030 */  4,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '瀰',0,'瀲',0,0,0,0,0, 0,0,0,0,0,0,'瀾',0, */
	/* 7040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'灌',0,0,0, */
	/* 7050 */ -1, 4,-1,-1,-1,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,'灑',0,0,0,0,0,0, '灘',0,0,0,0,0,0,0, */
	/* 7060 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,0,0,'灣',0,0,0,0, 0,0,0,'火',0,0,0,'灯', */
	/* 7070 */  4,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1,-1, 4, 4,0,0, /* '灰',0,0,0,0,0,0,0, '灸',0,0,0,'灼','災',0,0, */
	/* 7080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4, 4,-1,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,'炉','炊',0,0,0,'炎',0, */
	/* 7090 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,'炒',0,0,0,0,0, 0,'炙',0,0,0,0,0,0, */
	/* 70a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4, 4, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'炬','炭','炮','炯', */
	/* 70b0 */ -1,-1,-1, 4,-1,-1,-1,-1,  4, 4, 4,0,0,0,0,0, /* 0,0,0,'炳',0,0,0,0, '炸','点','為',0,0,0,0,0, */
	/* 70c0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1, 4,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, '烈',0,0,'烋',0,0,0,'烏', */
	/* 70d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1, 4,-1, 4, /* 0,0,0,0,0,0,0,0, 0,'烙',0,0,0,'烝',0,'烟', */
	/* 70e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 70f0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1, 4,0,0, /* 0,'烱',0,0,0,0,0,0, 0,'烹',0,0,0,'烽',0,0, */
	/* 7100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'焉',0,0,0,0,0,0, */
	/* 7110 */ -1,-1,-1,-1, 4,-1,-1,-1, -1, 4, 4,-1, 4,0,0,0, /* 0,0,0,0,'焔',0,0,0, 0,'焙','焚',0,'焜',0,0,0, */
	/* 7120 */ -1, 4,-1,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,'無',0,0,0,0,'焦',0, 0,0,0,0,0,0,0,0, */
	/* 7130 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,0,'然',0, 0,0,0,0,'焼',0,0,0, */
	/* 7140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1, 4,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,'煉',0,0,'煌',0,'煎',0, */
	/* 7150 */ -1,-1,-1,-1,-1, 4, 4,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,0,'煕','煖',0, 0,'煙',0,0,0,0,0,0, */
	/* 7160 */ -1,-1, 4,-1, 4, 4, 4, 4, -1, 4,-1,-1, 4,-1, 4,0, /* 0,0,'煢',0,'煤','煥','煦','照', 0,'煩',0,0,'煬',0,'煮',0, */
	/* 7170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'煽',0,0, */
	/* 7180 */ -1,-1,-1,-1, 4,-1,-1,-1,  4,-1, 4,-1,-1,-1,-1, 4, /* 0,0,0,0,'熄',0,0,0, '熈',0,'熊',0,0,0,0,'熏', */
	/* 7190 */ -1,-1,-1,-1, 4, 4,-1,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,'熔','熕',0,0, 0,'熙',0,0,0,0,0,'熟', */
	/* 71a0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,0,0,0, '熨',0,0,0,'熬',0,0,0, */
	/* 71b0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1, 4,0, /* 0,'熱',0,0,0,0,0,0, 0,'熹',0,0,0,0,'熾',0, */
	/* 71c0 */ -1,-1,-1, 4,-1,-1,-1,-1,  4, 4,-1,-1,-1,-1, 4,0, /* 0,0,0,'燃',0,0,0,0, '燈','燉',0,0,0,0,'燎',0, */
	/* 71d0 */  4,-1, 4,-1, 4, 4,-1, 4, -1,-1,-1,-1,-1,-1,-1, 4, /* '燐',0,'燒',0,'燔','燕',0,'燗', 0,0,0,0,0,0,0,'營', */
	/* 71e0 */  4,-1,-1,-1,-1, 4, 4, 4, -1,-1,-1,-1, 4, 4, 4,0, /* '燠',0,0,0,0,'燥','燦','燧', 0,0,0,0,'燬','燭','燮',0, */
	/* 71f0 */ -1,-1,-1,-1,-1, 4,-1,-1, -1, 4,-1, 4, 4,-1,-1, 4, /* 0,0,0,0,0,'燵',0,0, 0,'燹',0,'燻','燼',0,0,'燿', */
	/* 7200 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,'爆',0, 0,0,0,0,0,'爍',0,0, */
	/* 7210 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* '爐',0,0,0,0,0,0,0, 0,0,0,'爛',0,0,0,0, */
	/* 7220 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1, 4,-1, 4, 4,0,0, /* 0,0,0,0,0,0,0,0, '爨',0,'爪',0,'爬','爭',0,0, */
	/* 7230 */  4,-1, 4,-1,-1, 4, 4,-1, -1,-1, 4, 4, 4, 4, 4, 4, /* '爰',0,'爲',0,0,'爵','父',0, 0,0,'爺','爻','爼','爽','爾','爿', */
	/* 7240 */  4,-1,-1,-1,-1,-1, 4, 4,  4,-1,-1, 4, 4,0,0,0, /* '牀',0,0,0,0,0,'牆','片', '版',0,0,'牋','牌',0,0,0, */
	/* 7250 */ -1,-1, 4,-1,-1,-1,-1,-1,  4, 4,-1, 4,-1, 4,-1, 4, /* 0,0,'牒',0,0,0,0,0, '牘','牙',0,'牛',0,'牝',0,'牟', */
	/* 7260 */ -1, 4, 4,-1,-1,-1,-1, 4, -1, 4,0,0,0,0,0,0, /* 0,'牡','牢',0,0,0,0,'牧', 0,'物',0,0,0,0,0,0, */
	/* 7270 */ -1,-1, 4,-1, 4,-1,-1,-1, -1, 4,-1,-1,-1, 4, 4,0, /* 0,0,'牲',0,'牴',0,0,0, 0,'特',0,0,0,'牽','牾',0, */
	/* 7280 */  4, 4, 4,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* '犀','犁','犂',0,0,0,0,'犇', 0,0,0,0,0,0,0,0, */
	/* 7290 */ -1,-1, 4,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,0,'犒',0,0,0,'犖',0, 0,0,0,0,0,0,0,0, */
	/* 72a0 */  4,-1, 4,-1,-1,-1,-1, 4, -1,-1,-1,-1, 4,-1,-1, 4, /* '犠',0,'犢',0,0,0,0,'犧', 0,0,0,0,'犬',0,0,'犯', */
	/* 72b0 */ -1,-1, 4,-1,-1,-1, 4,-1, -1, 4,0,0,0,0,0,0, /* 0,0,'犲',0,0,0,'状',0, 0,'犹',0,0,0,0,0,0, */
	/* 72c0 */ -1,-1, 4, 4, 4,-1, 4,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,'狂','狃','狄',0,'狆',0, 0,0,0,0,0,0,'狎',0, */
	/* 72d0 */  4,-1, 4,-1,-1,-1,-1, 4, -1, 4,-1, 4,0,0,0,0, /* '狐',0,'狒',0,0,0,0,'狗', 0,'狙',0,'狛',0,0,0,0, */
	/* 72e0 */  4, 4, 4,-1,-1,-1,-1,-1, -1, 4,-1,-1, 4, 4,0,0, /* '狠','狡','狢',0,0,0,0,0, 0,'狩',0,0,'独','狭',0,0, */
	/* 72f0 */ -1,-1,-1,-1,-1,-1,-1, 4,  4, 4,-1,-1, 4, 4,0,0, /* 0,0,0,0,0,0,0,'狷', '狸','狹',0,0,'狼','狽',0,0, */
	/* 7300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'猊',0,0,0,0,0, */
	/* 7310 */ -1,-1,-1,-1,-1,-1, 4, 4, -1,-1,-1, 4, 4, 4,-1, 4, /* 0,0,0,0,0,0,'猖','猗', 0,0,0,'猛','猜','猝',0,'猟', */
	/* 7320 */ -1,-1,-1,-1,-1, 4,-1,-1, -1, 4, 4, 4,-1,-1, 4, 4, /* 0,0,0,0,0,'猥',0,0, 0,'猩','猪','猫',0,0,'献','猯', */
	/* 7330 */ -1,-1,-1,-1, 4,-1, 4, 4, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,0,0,0,'猴',0,'猶','猷', 0,0,0,0,0,0,'猾','猿', */
	/* 7340 */ -1,-1,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,0,0,0,'獄','獅',0,0, 0,0,0,0,0,0,'獎','獏', */
	/* 7350 */ -1,-1,-1,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'獗', 0,0,0,0,0,0,0,0, */
	/* 7360 */ -1,-1,-1, 4,-1,-1,-1,-1,  4,-1, 4,0,0,0,0,0, /* 0,0,0,'獣',0,0,0,0, '獨',0,'獪',0,0,0,0,0, */
	/* 7370 */  4,-1, 4,-1,-1, 4,-1,-1,  4,-1, 4, 4,0,0,0,0, /* '獰',0,'獲',0,0,'獵',0,0, '獸',0,'獺','獻',0,0,0,0, */
	/* 7380 */ -1,-1,-1,-1, 4,-1,-1, 4, -1, 4,-1, 4,0,0,0,0, /* 0,0,0,0,'玄',0,0,'率', 0,'玉',0,'王',0,0,0,0, */
	/* 7390 */ -1,-1,-1,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'玖',0, 0,0,0,0,0,0,0,0, */
	/* 73a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'玩',0,0,0,0,0,0, */
	/* 73b0 */ -1,-1, 4, 4,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,0,'玲','玳',0,0,0,0, 0,0,0,'玻',0,0,0,0, */
	/* 73c0 */  4,-1, 4,-1,-1,-1,-1,-1,  4,-1, 4,-1,-1, 4, 4,0, /* '珀',0,'珂',0,0,0,0,0, '珈',0,'珊',0,0,'珍','珎',0, */
	/* 73d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'珞',0, */
	/* 73e0 */  4,-1,-1,-1,-1, 4,-1,-1, -1,-1, 4,-1,-1, 4, 4,0, /* '珠',0,0,0,0,'珥',0,0, 0,0,'珪',0,0,'班','珮',0, */
	/* 73f0 */ -1, 4,-1,-1,-1,-1,-1,-1,  4,-1,-1,-1,-1,-1, 4,0, /* 0,'珱',0,0,0,0,0,0, '珸',0,0,0,0,0,'現',0, */
	/* 7400 */ -1,-1,-1, 4,-1, 4, 4,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,'球',0,'琅','理',0, 0,'琉',0,0,0,0,0,0, */
	/* 7410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7420 */ -1,-1, 4,-1,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'琢',0,0,'琥',0,0, 0,0,0,0,0,0,0,0, */
	/* 7430 */ -1,-1, 4, 4, 4, 4, 4,-1, -1,-1, 4,-1,-1,-1,-1, 4, /* 0,0,'琲','琳','琴','琵','琶',0, 0,0,'琺',0,0,0,0,'琿', */
	/* 7440 */ -1, 4,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'瑁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 7450 */ -1,-1,-1,-1,-1, 4,-1,-1, -1, 4, 4, 4, 4,-1, 4, 4, /* 0,0,0,0,0,'瑕',0,0, 0,'瑙','瑚','瑛','瑜',0,'瑞','瑟', */
	/* 7460 */  4,-1,-1, 4, 4,-1,-1,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* '瑠',0,0,'瑣','瑤',0,0,0, 0,'瑩','瑪',0,0,0,0,'瑯', */
	/* 7470 */  4,-1,-1, 4,-1,-1, 4,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '瑰',0,0,'瑳',0,0,'瑶',0, 0,0,0,0,0,0,'瑾',0, */
	/* 7480 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,0,0,'璃',0,0,0,0, 0,0,0,'璋',0,0,0,0, */
	/* 7490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'璞',0, */
	/* 74a0 */ -1,-1, 4,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* 0,0,'璢',0,0,0,0,'璧', 0,0,0,0,0,0,0,0, */
	/* 74b0 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* '環',0,0,0,0,0,0,0, 0,0,0,0,0,'璽',0,0, */
	/* 74c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,'瓊',0,0,0,0,'瓏', */
	/* 74d0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,'瓔',0,0,0, 0,0,0,0,'瓜',0,0,0, */
	/* 74e0 */  4,-1, 4, 4,-1,-1, 4, 4, -1, 4,-1,-1,-1,-1, 4,0, /* '瓠',0,'瓢','瓣',0,0,'瓦','瓧', 0,'瓩',0,0,0,0,'瓮',0, */
	/* 74f0 */  4, 4, 4,-1,-1,-1, 4, 4,  4,0,0,0,0,0,0,0, /* '瓰','瓱','瓲',0,0,0,'瓶','瓷', '瓸',0,0,0,0,0,0,0, */
	/* 7500 */ -1,-1,-1, 4, 4, 4,-1,-1, -1,-1,-1,-1, 4, 4, 4,0, /* 0,0,0,'甃','甄','甅',0,0, 0,0,0,0,'甌','甍','甎',0, */
	/* 7510 */ -1, 4,-1, 4,-1, 4,-1,-1,  4,-1, 4,-1, 4,-1, 4, 4, /* 0,'甑',0,'甓',0,'甕',0,0, '甘',0,'甚',0,'甜',0,'甞','生', */
	/* 7520 */ -1,-1,-1, 4,-1, 4, 4,-1,  4,-1,-1, 4, 4,0,0,0, /* 0,0,0,'産',0,'甥','甦',0, '用',0,0,'甫','甬',0,0,0, */
	/* 7530 */  4, 4, 4, 4,-1,-1,-1, 4,  4,-1, 4, 4, 4,0,0,0, /* '田','由','甲','申',0,0,0,'男', '甸',0,'町','画','甼',0,0,0, */
	/* 7540 */ -1,-1,-1,-1, 4,-1, 4,-1, -1, 4, 4, 4, 4, 4,-1, 4, /* 0,0,0,0,'畄',0,'畆',0, 0,'畉','畊','畋','界','畍',0,'畏', */
	/* 7550 */ -1, 4,-1,-1, 4,-1,-1,-1, -1, 4, 4, 4, 4, 4,0,0, /* 0,'畑',0,0,'畔',0,0,0, 0,'留','畚','畛','畜','畝',0,0, */
	/* 7560 */  4,-1, 4,-1, 4, 4, 4, 4, -1, 4, 4, 4,-1, 4,0,0, /* '畠',0,'畢',0,'畤','略','畦','畧', 0,'畩','番','畫',0,'畭',0,0, */
	/* 7570 */  4,-1,-1, 4, 4,-1, 4, 4,  4,-1,-1,-1,-1,-1,-1, 4, /* '異',0,0,'畳','畴',0,'當','畷', '畸',0,0,0,0,0,0,'畿', */
	/* 7580 */ -1,-1, 4,-1,-1,-1, 4, 4, -1, 4, 4, 4,-1,-1, 4, 4, /* 0,0,'疂',0,0,0,'疆','疇', 0,'疉','疊','疋',0,0,'疎','疏', */
	/* 7590 */ -1, 4,-1,-1, 4,-1,-1,-1, -1,-1, 4,-1,-1, 4,0,0, /* 0,'疑',0,0,'疔',0,0,0, 0,0,'疚',0,0,'疝',0,0, */
	/* 75a0 */ -1,-1,-1, 4,-1, 4,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,0,0,'疣',0,'疥',0,0, 0,0,0,'疫',0,0,0,0, */
	/* 75b0 */ -1, 4, 4, 4,-1, 4,-1,-1,  4, 4,-1,-1, 4, 4, 4,0, /* 0,'疱','疲','疳',0,'疵',0,0, '疸','疹',0,0,'疼','疽','疾',0, */
	/* 75c0 */ -1,-1, 4, 4,-1, 4,-1, 4, -1,-1, 4,-1,-1, 4,0,0, /* 0,0,'痂','痃',0,'病',0,'症', 0,0,'痊',0,0,'痍',0,0, */
	/* 75d0 */ -1,-1, 4,-1, 4, 4,-1,-1,  4, 4,-1, 4,-1,-1, 4,0, /* 0,0,'痒',0,'痔','痕',0,0, '痘','痙',0,'痛',0,0,'痞',0, */
	/* 75e0 */ -1,-1, 4, 4,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,'痢','痣',0,0,0,0, 0,'痩',0,0,0,0,0,0, */
	/* 75f0 */  4,-1, 4, 4, 4,-1,-1,-1, -1,-1, 4,-1, 4,-1, 4, 4, /* '痰',0,'痲','痳','痴',0,0,0, 0,0,'痺',0,'痼',0,'痾','痿', */
	/* 7600 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1, 4,-1, 4,0,0, /* 0,'瘁',0,0,0,0,0,0, 0,'瘉',0,'瘋',0,'瘍',0,0, */
	/* 7610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'瘟', */
	/* 7620 */  4, 4, 4,-1, 4,-1,-1, 4, 0,0,0,0,0,0,0,0, /* '瘠','瘡','瘢',0,'瘤',0,0,'瘧', 0,0,0,0,0,0,0,0, */
	/* 7630 */  4,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* '瘰',0,0,0,'瘴',0,0,0, 0,0,0,'瘻',0,0,0,0, */
	/* 7640 */ -1,-1, 4,-1,-1,-1, 4, 4,  4,-1,-1,-1, 4,0,0,0, /* 0,0,'療',0,0,0,'癆','癇', '癈',0,0,0,'癌',0,0,0, */
	/* 7650 */ -1,-1, 4,-1,-1,-1, 4,-1,  4,-1,-1,-1, 4,0,0,0, /* 0,0,'癒',0,0,0,'癖',0, '癘',0,0,0,'癜',0,0,0, */
	/* 7660 */ -1, 4, 4,-1,-1,-1,-1, 4,  4, 4, 4,-1, 4,0,0,0, /* 0,'癡','癢',0,0,0,0,'癧', '癨','癩','癪',0,'癬',0,0,0, */
	/* 7670 */  4,-1, 4,-1,-1,-1, 4,-1,  4,-1, 4, 4, 4, 4, 4,0, /* '癰',0,'癲',0,0,0,'癶',0, '癸',0,'発','登','發','白','百',0, */
	/* 7680 */  4,-1,-1, 4, 4,-1, 4, 4,  4,-1,-1, 4,-1,-1, 4,0, /* '皀',0,0,'皃','的',0,'皆','皇', '皈',0,0,'皋',0,0,'皎',0, */
	/* 7690 */  4,-1,-1, 4,-1,-1, 4,-1, -1, 4, 4,0,0,0,0,0, /* '皐',0,0,'皓',0,0,'皖',0, 0,'皙','皚',0,0,0,0,0, */
	/* 76a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'皮',0, */
	/* 76b0 */  4,-1,-1,-1, 4,-1,-1, 4,  4, 4, 4,-1,-1,-1,-1, 4, /* '皰',0,0,0,'皴',0,0,'皷', '皸','皹','皺',0,0,0,0,'皿', */
	/* 76c0 */ -1,-1, 4, 4,-1,-1, 4,-1,  4,-1, 4,-1,-1, 4,0,0, /* 0,0,'盂','盃',0,0,'盆',0, '盈',0,'益',0,0,'盍',0,0, */
	/* 76d0 */ -1,-1, 4,-1,-1,-1, 4, 4, -1,-1,-1, 4, 4,-1, 4, 4, /* 0,0,'盒',0,0,0,'盖','盗', 0,0,0,'盛','盜',0,'盞','盟', */
	/* 76e0 */ -1, 4,-1, 4, 4, 4,-1, 4, -1,-1, 4,-1,-1,-1, 4,0, /* 0,'盡',0,'監','盤','盥',0,'盧', 0,0,'盪',0,0,0,'目',0, */
	/* 76f0 */ -1,-1, 4,-1, 4,-1,-1,-1,  4,-1,-1, 4,-1,-1, 4,0, /* 0,0,'盲',0,'直',0,0,0, '相',0,0,'盻',0,0,'盾',0, */
	/* 7700 */ -1, 4,-1,-1, 4,-1,-1, 4,  4, 4,-1, 4, 4,0,0,0, /* 0,'省',0,0,'眄',0,0,'眇', '眈','眉',0,'看','県',0,0,0, */
	/* 7710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,'眛',0,0,'眞','真', */
	/* 7720 */  4,-1,-1,-1, 4, 4, 4,-1, -1, 4,0,0,0,0,0,0, /* '眠',0,0,0,'眤','眥','眦',0, 0,'眩',0,0,0,0,0,0, */
	/* 7730 */ -1,-1,-1,-1,-1,-1,-1, 4,  4,-1, 4,-1, 4,0,0,0, /* 0,0,0,0,0,0,0,'眷', '眸',0,'眺',0,'眼',0,0,0, */
	/* 7740 */  4,-1,-1,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* '着',0,0,0,0,0,0,'睇', 0,0,0,0,0,0,0,0, */
	/* 7750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'睚','睛',0,0,0,0, */
	/* 7760 */ -1, 4,-1, 4,-1, 4, 4,-1,  4,-1,-1, 4,0,0,0,0, /* 0,'睡',0,'督',0,'睥','睦',0, '睨',0,0,'睫',0,0,0,0, */
	/* 7770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,'睹',0,0,0,0,'睾','睿', */
	/* 7780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'瞋',0,0,'瞎',0, */
	/* 7790 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,'瞑',0,0,0,0,0,0, 0,0,0,0,0,0,'瞞',0, */
	/* 77a0 */  4,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1, 4, 4,0,0, /* '瞠',0,0,0,0,'瞥',0,0, 0,0,0,0,'瞬','瞭',0,0, */
	/* 77b0 */  4,-1,-1, 4,-1,-1, 4,-1, -1, 4,-1, 4, 4, 4,-1, 4, /* '瞰',0,0,'瞳',0,0,'瞶',0, 0,'瞹',0,'瞻','瞼','瞽',0,'瞿', */
	/* 77c0 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,0,'矇', 0,0,0,0,0,'矍',0,0, */
	/* 77d0 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1, 4, 4, 4,0,0,0, /* 0,0,0,0,0,0,0,'矗', 0,0,'矚','矛','矜',0,0,0, */
	/* 77e0 */ -1,-1, 4, 4,-1, 4,-1, 4, -1, 4,-1,-1,-1, 4, 4, 4, /* 0,0,'矢','矣',0,'知',0,'矧', 0,'矩',0,0,0,'短','矮','矯', */
	/* 77f0 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,'石',0,0,0,0, 0,0,0,0,'矼',0,0,0, */
	/* 7800 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,'砂',0,0,0,0,0, 0,0,0,0,'砌',0,0,0, */
	/* 7810 */ -1,-1, 4,-1, 4, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'砒',0,'研','砕',0,0, 0,0,0,0,0,0,0,0, */
	/* 7820 */  4,-1,-1,-1,-1, 4, 4, 4, 0,0,0,0,0,0,0,0, /* '砠',0,0,0,0,'砥','砦','砧', 0,0,0,0,0,0,0,0, */
	/* 7830 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1, 4,-1,-1,-1,-1, 4, /* 0,0,'砲',0,'破',0,0,0, 0,0,'砺',0,0,0,0,'砿', */
	/* 7840 */ -1,-1,-1,-1,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'硅',0,0, 0,0,0,0,0,0,0,0, */
	/* 7850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'硝',0,0, */
	/* 7860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,'硫','硬',0,0,'硯', */
	/* 7870 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,'硲',0,'硴',0,0,0, 0,0,0,0,'硼',0,0,0, */
	/* 7880 */ -1, 4,-1,-1,-1,-1, 4, 4, -1,-1,-1,-1, 4, 4, 4,0, /* 0,'碁',0,0,0,0,'碆','碇', 0,0,0,0,'碌','碍','碎',0, */
	/* 7890 */ -1, 4,-1, 4,-1, 4,-1, 4, -1,-1, 4,0,0,0,0,0, /* 0,'碑',0,'碓',0,'碕',0,'碗', 0,0,'碚',0,0,0,0,0, */
	/* 78a0 */ -1,-1,-1, 4,-1,-1,-1, 4, -1, 4, 4,-1,-1,-1,-1, 4, /* 0,0,0,'碣',0,0,0,'碧', 0,'碩','碪',0,0,0,0,'碯', */
	/* 78b0 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1, 4,-1, 4,-1, 4,0, /* 0,0,0,0,0,'碵',0,0, 0,0,'確',0,'碼',0,'碾',0, */
	/* 78c0 */ -1, 4,-1,-1,-1, 4, 4,-1, -1,-1, 4, 4,0,0,0,0, /* 0,'磁',0,0,0,'磅','磆',0, 0,0,'磊','磋',0,0,0,0, */
	/* 78d0 */  4, 4,-1,-1, 4,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* '磐','磑',0,0,'磔',0,0,0, 0,0,'磚',0,0,0,0,0, */
	/* 78e0 */ -1,-1,-1,-1,-1,-1,-1, 4,  4,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,0,0,0,0,'磧', '磨',0,0,0,'磬',0,0,'磯', */
	/* 78f0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,'磴',0,0,0, 0,0,0,0,0,'磽',0,0, */
	/* 7900 */ -1, 4,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1,-1,-1, 4,0, /* 0,'礁',0,0,0,0,0,'礇', 0,0,0,0,0,0,'礎',0, */
	/* 7910 */ -1, 4, 4,-1,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,'礑','礒',0,0,0,0,0, 0,'礙',0,0,0,0,0,0, */
	/* 7920 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1, 4, 4, 4,0,0,0, /* 0,0,0,0,0,0,'礦',0, 0,0,'礪','礫','礬',0,0,0, */
	/* 7930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,-1, 4,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,'示',0,'礼',0,'社',0, */
	/* 7940 */  4, 4,-1,-1,-1,-1,-1, 4,  4, 4,0,0,0,0,0,0, /* '祀','祁',0,0,0,0,0,'祇', '祈','祉',0,0,0,0,0,0, */
	/* 7950 */  4,-1,-1, 4,-1, 4, 4, 4, -1,-1, 4,-1,-1, 4, 4, 4, /* '祐',0,0,'祓',0,'祕','祖','祗', 0,0,'祚',0,0,'祝','神','祟', */
	/* 7960 */  4,-1, 4,-1,-1, 4,-1,-1,  4,-1,-1,-1,-1, 4,0,0, /* '祠',0,'祢',0,0,'祥',0,0, '票',0,0,0,0,'祭',0,0, */
	/* 7970 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1, 4,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,'祷', 0,0,'祺',0,0,0,0,'祿', */
	/* 7980 */  4, 4,-1,-1, 4, 4,-1,-1, -1,-1, 4,-1,-1, 4, 4, 4, /* '禀','禁',0,0,'禄','禅',0,0, 0,0,'禊',0,0,'禍','禎','福', */
	/* 7990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'禝',0,0, */
	/* 79a0 */ -1,-1,-1,-1,-1,-1, 4, 4, -1,-1, 4,-1,-1,-1, 4,0, /* 0,0,0,0,0,0,'禦','禧', 0,0,'禪',0,0,0,'禮',0, */
	/* 79b0 */  4,-1,-1, 4,-1,-1,-1,-1, -1, 4, 4,-1,-1, 4, 4, 4, /* '禰',0,0,'禳',0,0,0,0, 0,'禹','禺',0,0,'禽','禾','禿', */
	/* 79c0 */  4, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1, 4,0,0,0,0, /* '秀','私',0,0,0,0,0,0, 0,'秉',0,'秋',0,0,0,0, */
	/* 79d0 */ -1, 4, 4,-1,-1, 4,-1,-1,  4,-1,-1,-1,-1,-1,-1, 4, /* 0,'科','秒',0,0,'秕',0,0, '秘',0,0,0,0,0,0,'租', */
	/* 79e0 */ -1, 4,-1, 4, 4,-1, 4, 4, -1, 4,-1,-1, 4,0,0,0, /* 0,'秡',0,'秣','秤',0,'秦','秧', 0,'秩',0,0,'秬',0,0,0, */
	/* 79f0 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* '称',0,0,0,0,0,0,0, 0,0,0,'移',0,0,0,0, */
	/* 7a00 */  4,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1, 4,-1, 4, 4,0, /* '稀',0,0,0,0,0,0,0, '稈',0,0,'程',0,'稍','税',0, */
	/* 7a10 */ -1,-1,-1,-1, 4,-1,-1, 4,  4, 4, 4,-1, 4,-1,-1, 4, /* 0,0,0,0,'稔',0,0,'稗', '稘','稙','稚',0,'稜',0,0,'稟', */
	/* 7a20 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '稠',0,0,0,0,0,0,0, 0,0,0,0,0,0,'種',0, */
	/* 7a30 */ -1, 4, 4,-1,-1,-1,-1, 4, -1,-1,-1, 4, 4, 4, 4, 4, /* 0,'稱','稲',0,0,0,0,'稷', 0,0,0,'稻','稼','稽','稾','稿', */
	/* 7a40 */  4,-1, 4, 4,-1,-1, 4,-1, -1, 4,-1,-1,-1, 4, 4, 4, /* '穀',0,'穂','穃',0,0,'穆',0, 0,'穉',0,0,0,'積','穎','穏', */
	/* 7a50 */  4,-1,-1,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* '穐',0,0,0,0,0,0,'穗', 0,0,0,0,0,0,0,0, */
	/* 7a60 */ -1, 4, 4, 4,-1,-1,-1,-1, -1, 4,-1, 4,0,0,0,0, /* 0,'穡','穢','穣',0,0,0,0, 0,'穩',0,'穫',0,0,0,0, */
	/* 7a70 */  4,-1,-1,-1, 4,-1, 4,-1, -1, 4, 4,-1,-1, 4,-1, 4, /* '穰',0,0,0,'穴',0,'究',0, 0,'穹','空',0,0,'穽',0,'穿', */
	/* 7a80 */ -1, 4,-1, 4, 4,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,'突',0,'窃','窄',0,0,0, '窈',0,0,0,0,0,0,0, */
	/* 7a90 */ -1,-1, 4, 4,-1, 4, 4, 4,  4,-1,-1,-1,-1,-1,-1, 4, /* 0,0,'窒','窓',0,'窕','窖','窗', '窘',0,0,0,0,0,0,'窟', */
	/* 7aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4, 4,-1,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,'窩','窪',0,0,0,'窮','窯', */
	/* 7ab0 */  4,-1,-1,-1,-1,-1, 4,-1, -1,-1, 4,-1,-1,-1,-1, 4, /* '窰',0,0,0,0,0,'窶',0, 0,0,'窺',0,0,0,0,'窿', */
	/* 7ac0 */ -1,-1,-1, 4, 4, 4,-1, 4,  4,-1, 4, 4,-1, 4,-1, 4, /* 0,0,0,'竃','竄','竅',0,'竇', '竈',0,'竊','立',0,'竍',0,'竏', */
	/* 7ad0 */ -1,-1, 4, 4,-1, 4,-1,-1, -1, 4, 4,-1, 4, 4,-1, 4, /* 0,0,'竒','竓',0,'竕',0,0, 0,'站','竚',0,'竜','竝',0,'竟', */
	/* 7ae0 */  4, 4, 4, 4,-1, 4, 4,-1, -1,-1, 4,-1,-1, 4,-1, 4, /* '章','竡','竢','竣',0,'童','竦',0, 0,0,'竪',0,0,'竭',0,'端', */
	/* 7af0 */  4,-1,-1,-1,-1,-1, 4,-1,  4, 4, 4,-1,-1,-1,-1, 4, /* '竰',0,0,0,0,0,'競',0, '竸','竹','竺',0,0,0,0,'竿', */
	/* 7b00 */ -1,-1, 4,-1, 4,-1, 4,-1,  4,-1, 4, 4,-1,-1,-1, 4, /* 0,0,'笂',0,'笄',0,'笆',0, '笈',0,'笊','笋',0,0,0,'笏', */
	/* 7b10 */ -1, 4,-1,-1,-1,-1,-1,-1,  4, 4,-1, 4,-1,-1, 4,0, /* 0,'笑',0,0,0,0,0,0, '笘','笙',0,'笛',0,0,'笞',0, */
	/* 7b20 */  4,-1,-1,-1,-1, 4, 4,-1,  4,-1,-1,-1, 4,0,0,0, /* '笠',0,0,0,0,'笥','符',0, '笨',0,0,0,'第',0,0,0, */
	/* 7b30 */ -1,-1,-1, 4,-1, 4, 4,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,'笳',0,'笵','笶',0, 0,'笹',0,0,0,0,0,0, */
	/* 7b40 */ -1,-1,-1,-1,-1, 4, 4,-1,  4, 4,-1, 4, 4, 4,-1, 4, /* 0,0,0,0,0,'筅','筆',0, '筈','等',0,'筋','筌','筍',0,'筏', */
	/* 7b50 */  4, 4, 4,-1, 4,-1, 4,-1, -1,-1,-1,-1,-1, 4,0,0, /* '筐','筑','筒',0,'答',0,'策',0, 0,0,0,0,0,'筝',0,0, */
	/* 7b60 */ -1,-1,-1,-1,-1, 4,-1, 4, -1,-1,-1,-1, 4,-1, 4,0, /* 0,0,0,0,0,'筥',0,'筧', 0,0,0,0,'筬',0,'筮',0, */
	/* 7b70 */  4, 4,-1,-1, 4, 4,-1,-1, -1,-1, 4,0,0,0,0,0, /* '筰','筱',0,0,'筴','筵',0,0, 0,0,'筺',0,0,0,0,0, */
	/* 7b80 */ -1,-1,-1,-1,-1,-1, 4, 4, -1,-1,-1, 4,-1, 4,-1, 4, /* 0,0,0,0,0,0,'箆','箇', 0,0,0,'箋',0,'箍',0,'箏', */
	/* 7b90 */ -1,-1, 4,-1, 4, 4,-1, 4,  4, 4, 4,-1, 4, 4,-1, 4, /* 0,0,'箒',0,'箔','箕',0,'算', '箘','箙','箚',0,'箜','箝',0,'箟', */
	/* 7ba0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4,0,0, /* 0,'管',0,0,0,0,0,0, 0,0,'箪',0,0,'箭',0,0, */
	/* 7bb0 */ -1, 4,-1,-1, 4,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,'箱',0,0,'箴',0,0,0, '箸',0,0,0,0,0,0,0, */
	/* 7bc0 */  4, 4,-1,-1, 4,-1, 4, 4, -1, 4,-1, 4, 4,-1,-1, 4, /* '節','篁',0,0,'範',0,'篆','篇', 0,'築',0,'篋','篌',0,0,'篏', */
	/* 7bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'篝',0,0, */
	/* 7be0 */  4,-1,-1,-1, 4, 4, 4,-1, -1, 4,-1,-1,-1, 4,0,0, /* '篠',0,0,0,'篤','篥','篦',0, 0,'篩',0,0,0,'篭',0,0, */
	/* 7bf0 */ -1,-1,-1, 4,-1,-1, 4, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,'篳',0,0,'篶','篷', 0,0,0,0,0,0,0,0, */
	/* 7c00 */  4,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1,-1, 4,0,0, /* '簀',0,0,0,0,0,0,'簇', 0,0,0,0,0,'簍',0,0, */
	/* 7c10 */ -1, 4, 4, 4, 4,-1,-1, 4, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,'簑','簒','簓','簔',0,0,'簗', 0,0,0,0,0,0,0,'簟', */
	/* 7c20 */ -1, 4,-1, 4,-1,-1,-1, 4, -1,-1, 4, 4,0,0,0,0, /* 0,'簡',0,'簣',0,0,0,'簧', 0,0,'簪','簫',0,0,0,0, */
	/* 7c30 */ -1,-1,-1,-1,-1,-1,-1, 4,  4,-1,-1,-1,-1, 4, 4, 4, /* 0,0,0,0,0,0,0,'簷', '簸',0,0,0,0,'簽','簾','簿', */
	/* 7c40 */  4,-1,-1, 4,-1,-1,-1,-1, -1,-1,-1,-1, 4, 4,-1, 4, /* '籀',0,0,'籃',0,0,0,0, 0,0,0,0,'籌','籍',0,'籏', */
	/* 7c50 */  4,-1,-1,-1, 4,-1, 4,-1,  4,-1,-1,-1,-1,-1,-1, 4, /* '籐',0,0,0,'籔',0,'籖',0, '籘',0,0,0,0,0,0,'籟', */
	/* 7c60 */  4,-1,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* '籠',0,0,0,'籤','籥',0,0, 0,0,0,0,'籬',0,0,0, */
	/* 7c70 */ -1,-1,-1, 4,-1, 4,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,'米',0,'籵',0,0, 0,0,0,0,0,0,'籾',0, */
	/* 7c80 */ -1, 4, 4, 4,-1,-1,-1,-1, -1, 4,-1, 4,-1, 4,0,0, /* 0,'粁','粂','粃',0,0,0,0, 0,'粉',0,'粋',0,'粍',0,0, */
	/* 7c90 */  4,-1, 4,-1,-1, 4,-1, 4,  4,-1,-1, 4,-1,-1,-1, 4, /* '粐',0,'粒',0,0,'粕',0,'粗', '粘',0,0,'粛',0,0,0,'粟', */
	/* 7ca0 */ -1, 4, 4,-1, 4, 4,-1, 4,  4,-1,-1, 4,-1, 4, 4,0, /* 0,'粡','粢',0,'粤','粥',0,'粧', '粨',0,0,'粫',0,'粭','粮',0, */
	/* 7cb0 */ -1, 4, 4, 4,-1,-1,-1,-1, -1, 4,-1,-1,-1, 4, 4,0, /* 0,'粱','粲','粳',0,0,0,0, 0,'粹',0,0,0,'粽','精',0, */
	/* 7cc0 */  4,-1, 4,-1,-1, 4,-1,-1, -1,-1, 4,-1,-1,-1, 4,0, /* '糀',0,'糂',0,0,'糅',0,0, 0,0,'糊',0,0,0,'糎',0, */
	/* 7cd0 */ -1,-1, 4,-1,-1,-1, 4,-1,  4,-1,-1,-1, 4,-1, 4, 4, /* 0,0,'糒',0,0,0,'糖',0, '糘',0,0,0,'糜',0,'糞','糟', */
	/* 7ce0 */  4,-1, 4,-1,-1,-1,-1, 4, -1,-1,-1,-1,-1,-1,-1, 4, /* '糠',0,'糢',0,0,0,0,'糧', 0,0,0,0,0,0,0,'糯', */
	/* 7cf0 */ -1,-1, 4,-1, 4,-1, 4,-1,  4,-1, 4, 4,-1,-1, 4,0, /* 0,0,'糲',0,'糴',0,'糶',0, '糸',0,'糺','系',0,0,'糾',0, */
	/* 7d00 */  4,-1, 4,-1, 4, 4, 4,-1, -1,-1, 4, 4,-1, 4,0,0, /* '紀',0,'紂',0,'約','紅','紆',0, 0,0,'紊','紋',0,'納',0,0, */
	/* 7d10 */  4,-1,-1,-1, 4, 4,-1, 4,  4, 4, 4, 4, 4,0,0,0, /* '紐',0,0,0,'純','紕',0,'紗', '紘','紙','級','紛','紜',0,0,0, */
	/* 7d20 */  4, 4, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1, 4, 4, /* '素','紡','索',0,0,0,0,0, 0,0,0,'紫','紬',0,'紮','累', */
	/* 7d30 */  4,-1, 4, 4,-1, 4,-1,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* '細',0,'紲','紳',0,'紵',0,0, 0,'紹','紺',0,0,0,0,'紿', */
	/* 7d40 */ -1,-1, 4, 4, 4, 4, 4,-1, -1,-1,-1, 4, 4,-1, 4, 4, /* 0,0,'終','絃','組','絅','絆',0, 0,0,0,'絋','経',0,'絎','絏', */
	/* 7d50 */  4,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1, 4,-1,-1, 4,0, /* '結',0,0,0,0,0,'絖',0, 0,0,0,'絛',0,0,'絞',0, */
	/* 7d60 */ -1, 4, 4, 4,-1,-1, 4,-1,  4,-1,-1,-1,-1,-1, 4,0, /* 0,'絡','絢','絣',0,0,'給',0, '絨',0,0,0,0,0,'絮',0, */
	/* 7d70 */ -1, 4, 4, 4,-1, 4, 4,-1, -1, 4,-1,-1,-1, 4,0,0, /* 0,'統','絲','絳',0,'絵','絶',0, 0,'絹',0,0,0,'絽',0,0, */
	/* 7d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,'綉',0,0,0,0,0,'綏', */
	/* 7d90 */ -1,-1,-1, 4,-1,-1,-1,-1, -1, 4, 4, 4, 4,-1,-1, 4, /* 0,0,0,'經',0,0,0,0, 0,'継','続','綛','綜',0,0,'綟', */
	/* 7da0 */ -1,-1, 4, 4,-1,-1,-1,-1, -1,-1,-1, 4, 4, 4, 4, 4, /* 0,0,'綢','綣',0,0,0,0, 0,0,0,'綫','綬','維','綮','綯', */
	/* 7db0 */  4, 4, 4,-1, 4, 4,-1,-1,  4,-1, 4, 4,-1, 4, 4, 4, /* '綰','綱','網',0,'綴','綵',0,0, '綸',0,'綺','綻',0,'綽','綾','綿', */
	/* 7dc0 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1, 4, 4,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,'緇', 0,0,'緊','緋',0,0,0,'総', */
	/* 7dd0 */ -1, 4, 4,-1,-1, 4,-1,-1,  4,-1, 4,-1, 4, 4, 4,0, /* 0,'緑','緒',0,0,'緕',0,0, '緘',0,'線',0,'緜','緝','緞',0, */
	/* 7de0 */  4, 4,-1,-1, 4,-1,-1,-1,  4, 4,-1,-1, 4,-1,-1, 4, /* '締','緡',0,0,'緤',0,0,0, '編','緩',0,0,'緬',0,0,'緯', */
	/* 7df0 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,0,'緲',0,'練',0,0,0, 0,0,0,'緻',0,0,0,0, */
	/* 7e00 */ -1, 4,-1,-1, 4, 4,-1,-1, -1, 4, 4, 4,0,0,0,0, /* 0,'縁',0,0,'縄','縅',0,0, 0,'縉','縊','縋',0,0,0,0, */
	/* 7e10 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 4, 4, /* 0,0,'縒',0,0,0,0,0, 0,0,0,'縛',0,0,'縞','縟', */
	/* 7e20 */ -1, 4, 4, 4,-1,-1, 4,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,'縡','縢','縣',0,0,'縦',0, 0,0,0,'縫',0,0,'縮',0, */
	/* 7e30 */ -1, 4, 4,-1,-1, 4,-1, 4, -1, 4, 4, 4,-1, 4, 4,0, /* 0,'縱','縲',0,0,'縵',0,'縷', 0,'縹','縺','縻',0,'總','績',0, */
	/* 7e40 */ -1, 4,-1, 4,-1,-1, 4,-1, -1,-1, 4, 4,-1, 4,0,0, /* 0,'繁',0,'繃',0,0,'繆',0, 0,0,'繊','繋',0,'繍',0,0, */
	/* 7e50 */ -1,-1,-1,-1, 4, 4, 4,-1, -1, 4, 4,-1,-1, 4, 4,0, /* 0,0,0,0,'織','繕','繖',0, 0,'繙','繚',0,0,'繝','繞',0, */
	/* 7e60 */ -1,-1,-1,-1,-1,-1, 4, 4, -1, 4, 4,-1,-1, 4,0,0, /* 0,0,0,0,0,0,'繦','繧', 0,'繩','繪',0,0,'繭',0,0, */
	/* 7e70 */  4,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1, 4, 4, 4,-1, 4, /* '繰',0,0,0,0,0,0,0, 0,'繹',0,'繻','繼','繽',0,'繿', */
	/* 7e80 */ -1,-1, 4, 4,-1,-1,-1,-1,  4, 4,-1,-1, 4,-1, 4, 4, /* 0,0,'纂','纃',0,0,0,0, '纈','纉',0,0,'續',0,'纎','纏', */
	/* 7e90 */  4,-1, 4, 4, 4,-1, 4,-1, -1,-1,-1, 4, 4,0,0,0, /* '纐',0,'纒','纓','纔',0,'纖',0, 0,0,0,'纛','纜',0,0,0, */
	/* 7ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f30 */ -1,-1,-1,-1,-1,-1, 4,-1,  4,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,'缶',0, '缸',0,'缺',0,0,0,0,0, */
	/* 7f40 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1, 4, 4, 4,0, /* 0,0,0,0,0,'罅',0,0, 0,0,0,0,'罌','罍','罎',0, */
	/* 7f50 */  4, 4,-1,-1, 4, 4,-1,-1,  4,-1,-1,-1,-1,-1,-1, 4, /* '罐','网',0,0,'罔','罕',0,0, '罘',0,0,0,0,0,0,'罟', */
	/* 7f60 */  4,-1,-1,-1,-1,-1,-1, 4,  4, 4, 4, 4,-1,-1, 4,0, /* '罠',0,0,0,0,0,0,'罧', '罨','罩','罪','罫',0,0,'置',0, */
	/* 7f70 */  4,-1, 4,-1,-1, 4,-1, 4,  4, 4,0,0,0,0,0,0, /* '罰',0,'署',0,0,'罵',0,'罷', '罸','罹',0,0,0,0,0,0, */
	/* 7f80 */ -1,-1, 4, 4,-1, 4, 4, 4,  4,-1, 4,-1, 4,-1, 4,0, /* 0,0,'羂','羃',0,'羅','羆','羇', '羈',0,'羊',0,'羌',0,'美',0, */
	/* 7f90 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1, 4,-1,-1, 4, 4,0, /* 0,0,0,0,'羔',0,0,0, 0,0,'羚',0,0,'羝','羞',0, */
	/* 7fa0 */ -1,-1,-1, 4, 4,-1,-1,-1,  4, 4,-1,-1,-1,-1, 4, 4, /* 0,0,0,'羣','群',0,0,0, '羨','義',0,0,0,0,'羮','羯', */
	/* 7fb0 */ -1,-1, 4,-1,-1,-1, 4,-1,  4, 4,-1,-1,-1, 4,0,0, /* 0,0,'羲',0,0,0,'羶',0, '羸','羹',0,0,0,'羽',0,0, */
	/* 7fc0 */ -1, 4,-1,-1,-1, 4, 4,-1, -1,-1, 4,-1, 4,0,0,0, /* 0,'翁',0,0,0,'翅','翆',0, 0,0,'翊',0,'翌',0,0,0, */
	/* 7fd0 */ -1,-1, 4,-1, 4, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'習',0,'翔','翕',0,0, 0,0,0,0,0,0,0,0, */
	/* 7fe0 */  4, 4,-1,-1,-1,-1, 4,-1, -1, 4,-1, 4,0,0,0,0, /* '翠','翡',0,0,0,0,'翦',0, 0,'翩',0,'翫',0,0,0,0, */
	/* 7ff0 */  4,-1,-1, 4,-1,-1,-1,-1, -1, 4,-1, 4, 4,0,0,0, /* '翰',0,0,'翳',0,0,0,0, 0,'翹',0,'翻','翼',0,0,0, */
	/* 8000 */  4, 4,-1, 4, 4, 4, 4,-1, -1,-1,-1, 4, 4,0,0,0, /* '耀','老',0,'考','耄','者','耆',0, 0,0,0,'耋','而',0,0,0, */
	/* 8010 */  4,-1, 4,-1,-1, 4,-1, 4,  4, 4,-1,-1, 4,0,0,0, /* '耐',0,'耒',0,0,'耕',0,'耗', '耘','耙',0,0,'耜',0,0,0, */
	/* 8020 */ -1, 4,-1,-1,-1,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,'耡',0,0,0,0,0,0, '耨',0,0,0,0,0,0,0, */
	/* 8030 */ -1,-1,-1, 4,-1,-1, 4,-1, -1,-1,-1, 4,-1, 4,-1, 4, /* 0,0,0,'耳',0,0,'耶',0, 0,0,0,'耻',0,'耽',0,'耿', */
	/* 8040 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,'聆',0, 0,0,'聊',0,0,0,0,0, */
	/* 8050 */ -1,-1, 4,-1,-1,-1, 4,-1,  4,-1, 4,-1,-1,-1, 4, 4, /* 0,0,'聒',0,0,0,'聖',0, '聘',0,'聚',0,0,0,'聞','聟', */
	/* 8060 */ -1, 4, 4,-1,-1,-1,-1,-1,  4,-1,-1,-1,-1,-1,-1, 4, /* 0,'聡','聢',0,0,0,0,0, '聨',0,0,0,0,0,0,'聯', */
	/* 8070 */  4,-1, 4, 4, 4,-1, 4, 4, -1, 4,-1,-1,-1, 4, 4, 4, /* '聰',0,'聲','聳','聴',0,'聶','職', 0,'聹',0,0,0,'聽','聾','聿', */
	/* 8080 */ -1,-1,-1,-1, 4, 4, 4, 4, -1, 4,-1, 4, 4,0,0,0, /* 0,0,0,0,'肄','肅','肆','肇', 0,'肉',0,'肋','肌',0,0,0, */
	/* 8090 */ -1,-1,-1, 4,-1,-1, 4,-1,  4,-1, 4, 4,-1, 4,0,0, /* 0,0,0,'肓',0,0,'肖',0, '肘',0,'肚','肛',0,'肝',0,0, */
	/* 80a0 */ -1, 4, 4,-1,-1, 4,-1,-1, -1, 4, 4,-1, 4, 4,-1, 4, /* 0,'股','肢',0,0,'肥',0,0, 0,'肩','肪',0,'肬','肭',0,'肯', */
	/* 80b0 */ -1, 4, 4,-1, 4,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,'肱','育',0,'肴',0,0,0, 0,0,'肺',0,0,0,0,0, */
	/* 80c0 */ -1,-1,-1, 4, 4,-1, 4,-1, -1,-1,-1,-1, 4,-1, 4,0, /* 0,0,0,'胃','胄',0,'胆',0, 0,0,0,0,'背',0,'胎',0, */
	/* 80d0 */ -1,-1,-1,-1,-1,-1, 4,-1, -1, 4, 4, 4,-1, 4, 4,0, /* 0,0,0,0,0,0,'胖',0, 0,'胙','胚','胛',0,'胝','胞',0, */
	/* 80e0 */ -1, 4,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,'胡',0,0,'胤','胥',0,0, 0,0,0,0,0,0,0,'胯', */
	/* 80f0 */ -1, 4,-1,-1, 4,-1,-1,-1,  4,-1,-1,-1, 4, 4,0,0, /* 0,'胱',0,0,'胴',0,0,0, '胸',0,0,0,'胼','能',0,0, */
	/* 8100 */ -1,-1, 4,-1,-1, 4, 4, 4,  4, 4, 4,0,0,0,0,0, /* 0,0,'脂',0,0,'脅','脆','脇', '脈','脉','脊',0,0,0,0,0, */
	/* 8110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'脚','脛',0,0,0,0, */
	/* 8120 */ -1,-1,-1, 4,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,'脣',0,0,0,0, 0,'脩',0,0,0,0,0,'脯', */
	/* 8130 */ -1, 4,-1, 4,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1, 4,0, /* 0,'脱',0,'脳',0,0,0,0, 0,'脹',0,0,0,0,'脾',0, */
	/* 8140 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,0,0,0,0,0,'腆',0, 0,0,0,'腋',0,0,'腎',0, */
	/* 8150 */  4, 4,-1, 4, 4, 4,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* '腐','腑',0,'腓','腔','腕',0,0, 0,0,0,0,0,0,0,'腟', */
	/* 8160 */ -1,-1,-1,-1,-1, 4, 4,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,0,0,0,0,'腥','腦',0, 0,0,0,'腫',0,0,'腮',0, */
	/* 8170 */  4, 4,-1,-1, 4,-1,-1,-1,  4, 4, 4,-1,-1,-1,-1, 4, /* '腰','腱',0,0,'腴',0,0,0, '腸','腹','腺',0,0,0,0,'腿', */
	/* 8180 */  4,-1, 4, 4,-1,-1,-1,-1,  4,-1, 4,-1,-1,-1,-1, 4, /* '膀',0,'膂','膃',0,0,0,0, '膈',0,'膊',0,0,0,0,'膏', */
	/* 8190 */ -1,-1,-1, 4,-1, 4,-1,-1, -1,-1, 4,-1, 4, 4,0,0, /* 0,0,0,'膓',0,'膕',0,0, 0,0,'膚',0,'膜','膝',0,0, */
	/* 81a0 */  4,-1,-1, 4, 4,-1,-1,-1,  4, 4,0,0,0,0,0,0, /* '膠',0,0,'膣','膤',0,0,0, '膨','膩',0,0,0,0,0,0, */
	/* 81b0 */  4,-1,-1, 4,-1, 4,-1,-1,  4,-1, 4,-1,-1, 4, 4, 4, /* '膰',0,0,'膳',0,'膵',0,0, '膸',0,'膺',0,0,'膽','膾','膿', */
	/* 81c0 */  4,-1, 4,-1,-1,-1, 4,-1,  4, 4,-1,-1,-1, 4,0,0, /* '臀',0,'臂',0,0,0,'臆',0, '臈','臉',0,0,0,'臍',0,0, */
	/* 81d0 */ -1, 4,-1, 4,-1,-1,-1,-1,  4, 4, 4,-1,-1,-1,-1, 4, /* 0,'臑',0,'臓',0,0,0,0, '臘','臙','臚',0,0,0,0,'臟', */
	/* 81e0 */  4,-1,-1, 4,-1, 4,-1, 4,  4,-1, 4,-1,-1, 4,0,0, /* '臠',0,0,'臣',0,'臥',0,'臧', '臨',0,'自',0,0,'臭',0,0, */
	/* 81f0 */ -1,-1,-1, 4, 4,-1,-1,-1, -1,-1, 4, 4, 4,-1, 4,0, /* 0,0,0,'至','致',0,0,0, 0,0,'臺','臻','臼',0,'臾',0, */
	/* 8200 */ -1, 4, 4,-1,-1, 4,-1, 4,  4, 4, 4,-1, 4, 4, 4,0, /* 0,'舁','舂',0,0,'舅',0,'與', '興','舉','舊',0,'舌','舍','舎',0, */
	/* 8210 */  4,-1, 4,-1,-1,-1, 4, 4,  4,-1,-1, 4, 4,-1, 4, 4, /* '舐',0,'舒',0,0,0,'舖','舗', '舘',0,0,'舛','舜',0,'舞','舟', */
	/* 8220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4, 4, 4, 4,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,'舩','航','舫','般',0,'舮',0, */
	/* 8230 */ -1,-1,-1, 4,-1, 4, 4, 4,  4, 4,0,0,0,0,0,0, /* 0,0,0,'舳',0,'舵','舶','舷', '舸','船',0,0,0,0,0,0, */
	/* 8240 */  4,-1,-1,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* '艀',0,0,0,0,0,0,'艇', 0,0,0,0,0,0,0,0, */
	/* 8250 */ -1,-1,-1,-1,-1,-1,-1,-1,  4, 4, 4,-1,-1, 4,-1, 4, /* 0,0,0,0,0,0,0,0, '艘','艙','艚',0,0,'艝',0,'艟', */
	/* 8260 */ -1,-1, 4,-1, 4,-1, 4,-1,  4,-1, 4, 4,-1,-1, 4, 4, /* 0,0,'艢',0,'艤',0,'艦',0, '艨',0,'艪','艫',0,0,'艮','良', */
	/* 8270 */ -1, 4, 4,-1,-1,-1, 4, 4,  4,-1,-1,-1,-1,-1, 4,0, /* 0,'艱','色',0,0,0,'艶','艷', '艸',0,0,0,0,0,'艾',0, */
	/* 8280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'芋',0,'芍',0,0, */
	/* 8290 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1, 4,-1, 4, /* 0,0,'芒',0,0,0,0,0, 0,'芙',0,0,0,'芝',0,'芟', */
	/* 82a0 */ -1,-1,-1,-1,-1, 4, 4,-1, -1,-1,-1, 4, 4, 4,-1, 4, /* 0,0,0,0,0,'芥','芦',0, 0,0,0,'芫','芬','芭',0,'芯', */
	/* 82b0 */ -1, 4,-1, 4,-1,-1,-1,-1,  4, 4,-1, 4,-1, 4,0,0, /* 0,'花',0,'芳',0,0,0,0, '芸','芹',0,'芻',0,'芽',0,0, */
	/* 82c0 */ -1,-1,-1,-1,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'苅',0,0, 0,0,0,0,0,0,0,0, */
	/* 82d0 */ -1, 4, 4, 4, 4,-1,-1, 4, -1, 4,-1, 4, 4,-1, 4, 4, /* 0,'苑','苒','苓','苔',0,0,'苗', 0,'苙',0,'苛','苜',0,'苞','苟', */
	/* 82e0 */ -1, 4,-1, 4,-1, 4, 4, 4, -1,-1,-1, 4,0,0,0,0, /* 0,'苡',0,'苣',0,'若','苦','苧', 0,0,0,'苫',0,0,0,0, */
	/* 82f0 */ -1, 4,-1, 4, 4,-1,-1,-1, -1, 4, 4, 4,0,0,0,0, /* 0,'英',0,'苳','苴',0,0,0, 0,'苹','苺','苻',0,0,0,0, */
	/* 8300 */ -1,-1, 4, 4, 4, 4, 4,-1, -1, 4,-1,-1,-1,-1, 4,0, /* 0,0,'茂','范','茄','茅','茆',0, 0,'茉',0,0,0,0,'茎',0, */
	/* 8310 */ -1,-1,-1,-1,-1,-1, 4, 4,  4,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,0,'茖','茗', '茘',0,0,0,'茜',0,0,0, */
	/* 8320 */ -1,-1,-1, 4,-1,-1,-1,-1,  4,-1,-1, 4,-1,-1,-1, 4, /* 0,0,0,'茣',0,0,0,0, '茨',0,0,'茫',0,0,0,'茯', */
	/* 8330 */ -1, 4, 4,-1, 4, 4, 4,-1,  4, 4,0,0,0,0,0,0, /* 0,'茱','茲',0,'茴','茵','茶',0, '茸','茹',0,0,0,0,0,0, */
	/* 8340 */  4,-1,-1,-1,-1, 4,-1,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* '荀',0,0,0,0,'荅',0,0, 0,'草','荊',0,0,0,0,'荏', */
	/* 8350 */  4,-1, 4,-1,-1,-1,-1,-1,  4,0,0,0,0,0,0,0, /* '荐',0,'荒',0,0,0,0,0, '荘',0,0,0,0,0,0,0, */
	/* 8360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8370 */ -1,-1,-1, 4,-1, 4,-1, 4, -1,-1,-1, 4, 4,0,0,0, /* 0,0,0,'荳',0,'荵',0,'荷', 0,0,0,'荻','荼',0,0,0, */
	/* 8380 */ -1,-1,-1,-1,-1, 4,-1, 4, -1, 4, 4,-1,-1,-1, 4,0, /* 0,0,0,0,0,'莅',0,'莇', 0,'莉','莊',0,0,0,'莎',0, */
	/* 8390 */ -1,-1,-1, 4,-1,-1, 4,-1, -1,-1, 4,-1,-1,-1, 4, 4, /* 0,0,0,'莓',0,0,'莖',0, 0,0,'莚',0,0,0,'莞','莟', */
	/* 83a0 */  4,-1, 4,-1,-1,-1,-1,-1,  4,-1, 4, 4,0,0,0,0, /* '莠',0,'莢',0,0,0,0,0, '莨',0,'莪','莫',0,0,0,0, */
	/* 83b0 */ -1, 4,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,'莱',0,0,0,'莵',0,0, 0,0,0,0,0,'莽',0,0, */
	/* 83c0 */ -1, 4,-1,-1,-1, 4,-1,-1, -1,-1, 4,-1, 4,-1, 4,0, /* 0,'菁',0,0,0,'菅',0,0, 0,0,'菊',0,'菌',0,'菎',0, */
	/* 83d0 */ -1,-1,-1, 4,-1,-1, 4,-1,  4,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,'菓',0,0,'菖',0, '菘',0,0,0,'菜',0,0,'菟', */
	/* 83e0 */  4,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1, 4,-1,-1,-1, 4, /* '菠',0,0,0,0,0,0,0, 0,'菩',0,'菫',0,0,0,'華', */
	/* 83f0 */  4, 4, 4,-1, 4,-1,-1, 4, -1,-1,-1, 4,-1, 4,0,0, /* '菰','菱','菲',0,'菴',0,0,'菷', 0,0,0,'菻',0,'菽',0,0, */
	/* 8400 */ -1,-1,-1, 4, 4,-1,-1, 4, -1,-1,-1, 4, 4, 4, 4,0, /* 0,0,0,'萃','萄',0,0,'萇', 0,0,0,'萋','萌','萍','萎',0, */
	/* 8410 */ -1,-1,-1, 4,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'萓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8420 */  4,-1, 4,-1,-1,-1,-1,-1, -1, 4, 4,-1, 4,0,0,0, /* '萠',0,'萢',0,0,0,0,0, 0,'萩','萪',0,'萬',0,0,0, */
	/* 8430 */ -1, 4,-1,-1,-1, 4,-1,-1,  4,-1,-1,-1, 4, 4,0,0, /* 0,'萱',0,0,0,'萵',0,0, '萸',0,0,0,'萼','落',0,0, */
	/* 8440 */ -1,-1,-1,-1,-1,-1, 4,-1, -1, 4,-1,-1,-1,-1, 4,0, /* 0,0,0,0,0,0,'葆',0, 0,'葉',0,0,0,0,'葎',0, */
	/* 8450 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1, 4,0,0,0,0, /* 0,0,0,0,0,0,0,'著', 0,0,0,'葛',0,0,0,0, */
	/* 8460 */ -1, 4, 4, 4,-1,-1, 4,-1, -1, 4,-1, 4, 4, 4, 4, 4, /* 0,'葡','葢','董',0,0,'葦',0, 0,'葩',0,'葫','葬','葭','葮','葯', */
	/* 8470 */ -1, 4,-1,-1,-1, 4,-1, 4, -1, 4, 4,0,0,0,0,0, /* 0,'葱',0,0,0,'葵',0,'葷', 0,'葹','葺',0,0,0,0,0, */
	/* 8480 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,0,'蒂',0,'蒄',0,0,0, 0,0,0,'蒋',0,0,0,0, */
	/* 8490 */  4,-1,-1,-1, 4,-1,-1,-1, -1, 4,-1,-1, 4,-1,-1, 4, /* '蒐',0,0,0,'蒔',0,0,0, 0,'蒙',0,0,'蒜',0,0,'蒟', */
	/* 84a0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,'蒡',0,0,0,0,0,0, 0,0,0,0,0,'蒭',0,0, */
	/* 84b0 */ -1,-1, 4,-1,-1,-1,-1,-1,  4, 4,-1, 4, 4,-1,-1, 4, /* 0,0,'蒲',0,0,0,0,0, '蒸','蒹',0,'蒻','蒼',0,0,'蒿', */
	/* 84c0 */ -1, 4,-1,-1, 4,-1, 4,-1, -1, 4, 4, 4,-1, 4,0,0, /* 0,'蓁',0,0,'蓄',0,'蓆',0, 0,'蓉','蓊','蓋',0,'蓍',0,0, */
	/* 84d0 */  4, 4,-1,-1,-1,-1, 4,-1, -1, 4, 4,0,0,0,0,0, /* '蓐','蓑',0,0,0,0,'蓖',0, 0,'蓙','蓚',0,0,0,0,0, */
	/* 84e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'蓬',0,'蓮',0, */
	/* 84f0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,0,'蓴',0,0,0, 0,0,0,0,'蓼',0,0,'蓿', */
	/* 8500 */  4,-1,-1,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* '蔀',0,0,0,0,0,'蔆',0, 0,0,0,0,0,0,0,0, */
	/* 8510 */ -1, 4,-1, 4, 4, 4,-1, 4,  4,-1, 4,-1,-1,-1,-1, 4, /* 0,'蔑',0,'蔓','蔔','蔕',0,'蔗', '蔘',0,'蔚',0,0,0,0,'蔟', */
	/* 8520 */ -1, 4,-1,-1,-1,-1, 4,-1, -1,-1,-1,-1, 4, 4,0,0, /* 0,'蔡',0,0,0,0,'蔦',0, 0,0,0,0,'蔬','蔭',0,0, */
	/* 8530 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,'蔵',0,0, 0,0,0,0,0,'蔽',0,0, */
	/* 8540 */  4, 4,-1, 4,-1,-1,-1,-1,  4, 4, 4, 4,-1,-1, 4,0, /* '蕀','蕁',0,'蕃',0,0,0,0, '蕈','蕉','蕊','蕋',0,0,'蕎',0, */
	/* 8550 */ -1,-1,-1,-1,-1, 4,-1, 4,  4,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,'蕕',0,'蕗', '蕘',0,'蕚',0,0,0,0,0, */
	/* 8560 */ -1,-1,-1, 4,-1,-1,-1,-1,  4, 4, 4,-1,-1, 4,0,0, /* 0,0,0,'蕣',0,0,0,0, '蕨','蕩','蕪',0,0,'蕭',0,0, */
	/* 8570 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,0,0,0,0,'蕷', 0,0,0,0,0,0,'蕾',0, */
	/* 8580 */  4,-1,-1,-1, 4,-1,-1, 4,  4,-1, 4,0,0,0,0,0, /* '薀',0,0,0,'薄',0,0,'薇', '薈',0,'薊',0,0,0,0,0, */
	/* 8590 */  4, 4,-1,-1, 4,-1,-1, 4, -1, 4,-1, 4, 4,0,0,0, /* '薐','薑',0,0,'薔',0,0,'薗', 0,'薙',0,'薛','薜',0,0,0, */
	/* 85a0 */ -1,-1,-1,-1, 4,-1, 4,-1,  4, 4, 4, 4, 4,-1, 4, 4, /* 0,0,0,0,'薤',0,'薦',0, '薨','薩','薪','薫','薬',0,'薮','薯', */
	/* 85b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4, 4,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'薹','薺',0,0,0,0,0, */
	/* 85c0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1, 4,-1, 4, /* 0,'藁',0,0,0,0,0,0, 0,'藉',0,0,0,'藍',0,'藏', */
	/* 85d0 */  4,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1, 4, 4,0,0, /* '藐',0,0,0,0,'藕',0,0, 0,0,0,0,'藜','藝',0,0, */
	/* 85e0 */ -1,-1,-1,-1, 4, 4,-1,-1, -1, 4, 4,0,0,0,0,0, /* 0,0,0,0,'藤','藥',0,0, 0,'藩','藪',0,0,0,0,0, */
	/* 85f0 */ -1,-1,-1,-1,-1,-1,-1, 4, -1, 4, 4, 4,-1,-1, 4,0, /* 0,0,0,0,0,0,0,'藷', 0,'藹','藺','藻',0,0,'藾',0, */
	/* 8600 */ -1,-1, 4,-1,-1,-1, 4, 4, -1,-1, 4, 4,0,0,0,0, /* 0,0,'蘂',0,0,0,'蘆','蘇', 0,0,'蘊','蘋',0,0,0,0, */
	/* 8610 */ -1,-1,-1, 4,-1,-1, 4, 4, -1,-1, 4,0,0,0,0,0, /* 0,0,0,'蘓',0,0,'蘖','蘗', 0,0,'蘚',0,0,0,0,0, */
	/* 8620 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,-1, 4, /* 0,0,'蘢',0,0,0,0,0, 0,0,0,0,0,'蘭',0,'蘯', */
	/* 8630 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* '蘰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'蘿', */
	/* 8640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'虍','虎',0, */
	/* 8650 */  4,-1,-1,-1, 4, 4,-1,-1, -1,-1, 4,-1, 4,-1, 4, 4, /* '虐',0,0,0,'虔','處',0,0, 0,0,'虚',0,'虜',0,'虞','號', */
	/* 8660 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1, 4,0,0,0,0, /* 0,0,0,0,0,0,0,'虧', 0,0,0,'虫',0,0,0,0, */
	/* 8670 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1, 4,0,0,0,0, /* 0,'虱',0,0,0,0,0,0, 0,'虹',0,'虻',0,0,0,0, */
	/* 8680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'蚊','蚋','蚌',0,0,0, */
	/* 8690 */ -1,-1,-1, 4,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'蚓',0,'蚕',0,0, 0,0,0,0,0,0,0,0, */
	/* 86a0 */ -1,-1,-1, 4, 4,-1,-1,-1, -1, 4, 4, 4,-1,-1,-1, 4, /* 0,0,0,'蚣','蚤',0,0,0, 0,'蚩','蚪','蚫',0,0,0,'蚯', */
	/* 86b0 */  4,-1,-1,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* '蚰',0,0,0,0,0,'蚶',0, 0,0,0,0,0,0,0,0, */
	/* 86c0 */ -1,-1,-1,-1, 4,-1, 4, 4, -1, 4,-1, 4,-1, 4, 4,0, /* 0,0,0,0,'蛄',0,'蛆','蛇', 0,'蛉',0,'蛋',0,'蛍','蛎',0, */
	/* 86d0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1, 4,-1, 4,-1,-1, 4, 4, /* 0,0,0,0,'蛔',0,0,0, 0,'蛙',0,'蛛',0,0,'蛞','蛟', */
	/* 86e0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1, 4,-1,-1, 4, 4, 4, 4, /* 0,0,0,0,'蛤',0,0,0, 0,'蛩',0,0,'蛬','蛭','蛮','蛯', */
	/* 86f0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4, 4,-1, 4,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, '蛸','蛹',0,'蛻',0,0,'蛾',0, */
	/* 8700 */  4,-1, 4, 4,-1,-1, 4,-1,  4, 4, 4,-1,-1, 4,0,0, /* '蜀',0,'蜂','蜃',0,0,'蜆',0, '蜈','蜉','蜊',0,0,'蜍',0,0, */
	/* 8710 */ -1, 4, 4,-1,-1,-1,-1,-1,  4,-1, 4,-1, 4,0,0,0, /* 0,'蜑','蜒',0,0,0,0,0, '蜘',0,'蜚',0,'蜜',0,0,0, */
	/* 8720 */ -1,-1,-1,-1,-1, 4,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,0,'蜥',0,0, 0,'蜩',0,0,0,0,0,0, */
	/* 8730 */ -1,-1,-1,-1, 4,-1,-1, 4, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,0,0,0,'蜴',0,0,'蜷', 0,0,0,'蜻',0,0,0,'蜿', */
	/* 8740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1, 4, 4,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,'蝉',0,'蝋','蝌',0,'蝎',0, */
	/* 8750 */ -1,-1,-1, 4,-1, 4,-1, 4, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,'蝓',0,'蝕',0,'蝗', 0,'蝙',0,0,0,0,0,'蝟', */
	/* 8760 */  4,-1,-1, 4,-1,-1, 4,-1,  4,-1, 4,-1,-1,-1, 4,0, /* '蝠',0,0,'蝣',0,0,'蝦',0, '蝨',0,'蝪',0,0,0,'蝮',0, */
	/* 8770 */ -1,-1,-1,-1, 4,-1, 4,-1,  4,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,'蝴',0,'蝶',0, '蝸',0,0,0,0,0,0,'蝿', */
	/* 8780 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,'螂',0,0,0,0,0, 0,0,0,0,0,'融',0,0, */
	/* 8790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'螟', */
	/* 87a0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,0,'螢',0,0,0,0,0, 0,0,0,'螫',0,0,0,'螯', */
	/* 87b0 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1, 4, 4,-1, 4,0,0, /* 0,0,0,'螳',0,0,0,0, 0,0,'螺','螻',0,'螽',0,0, */
	/* 87c0 */  4,-1,-1,-1, 4,-1, 4, 4, -1,-1,-1, 4,0,0,0,0, /* '蟀',0,0,0,'蟄',0,'蟆','蟇', 0,0,0,'蟋',0,0,0,0, */
	/* 87d0 */  4,-1, 4,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '蟐',0,'蟒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 87e0 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* '蟠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'蟯', */
	/* 87f0 */ -1,-1, 4,-1,-1,-1, 4, 4, -1, 4,-1, 4,-1,-1, 4,0, /* 0,0,'蟲',0,0,0,'蟶','蟷', 0,'蟹',0,'蟻',0,0,'蟾',0, */
	/* 8800 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1,-1, 4, 4, 4, /* 0,0,0,0,0,'蠅',0,0, 0,0,0,0,0,'蠍','蠎','蠏', */
	/* 8810 */ -1, 4,-1,-1,-1, 4, 4,0, 0,0,0,0,0,0,0,0, /* 0,'蠑',0,0,0,'蠕','蠖',0, 0,0,0,0,0,0,0,0, */
	/* 8820 */ -1, 4, 4, 4,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* 0,'蠡','蠢','蠣',0,0,0,'蠧', 0,0,0,0,0,0,0,0, */
	/* 8830 */ -1, 4,-1,-1,-1,-1, 4,-1, -1, 4,-1, 4,0,0,0,0, /* 0,'蠱',0,0,0,0,'蠶',0, 0,'蠹',0,'蠻',0,0,0,0, */
	/* 8840 */  4,-1, 4,-1, 4,-1, 4,-1, -1,-1,-1,-1, 4, 4,0,0, /* '血',0,'衂',0,'衄',0,'衆',0, 0,0,0,0,'行','衍',0,0, */
	/* 8850 */ -1,-1, 4, 4,-1,-1,-1, 4, -1, 4,-1, 4,-1, 4, 4,0, /* 0,0,'衒','術',0,0,0,'街', 0,'衙',0,'衛',0,'衝','衞',0, */
	/* 8860 */ -1, 4, 4, 4,-1,-1,-1,-1,  4,-1,-1, 4,0,0,0,0, /* 0,'衡','衢','衣',0,0,0,0, '表',0,0,'衫',0,0,0,0, */
	/* 8870 */  4,-1, 4,-1,-1, 4,-1, 4, -1,-1,-1,-1,-1, 4, 4, 4, /* '衰',0,'衲',0,0,'衵',0,'衷', 0,0,0,0,0,'衽','衾','衿', */
	/* 8880 */ -1, 4, 4,-1,-1,-1,-1,-1,  4,-1,-1, 4,-1, 4,0,0, /* 0,'袁','袂',0,0,0,0,0, '袈',0,0,'袋',0,'袍',0,0, */
	/* 8890 */ -1,-1, 4,-1,-1,-1, 4, 4, -1, 4,-1,-1,-1,-1, 4,0, /* 0,0,'袒',0,0,0,'袖','袗', 0,'袙',0,0,0,0,'袞',0, */
	/* 88a0 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,0,'袢',0,'袤',0,0,0, 0,0,0,'被',0,0,'袮',0, */
	/* 88b0 */  4, 4,-1,-1, 4, 4,-1, 4, -1,-1,-1,-1,-1,-1,-1, 4, /* '袰','袱',0,0,'袴','袵',0,'袷', 0,0,0,0,0,0,0,'袿', */
	/* 88c0 */ -1, 4, 4, 4, 4, 4,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,'裁','裂','裃','裄','装',0,0, 0,0,0,0,0,0,0,'裏', */
	/* 88d0 */ -1,-1,-1,-1, 4, 4,-1,-1,  4, 4,-1,-1, 4, 4,-1, 4, /* 0,0,0,0,'裔','裕',0,0, '裘','裙',0,0,'補','裝',0,'裟', */
	/* 88e0 */ -1, 4,-1,-1,-1,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,'裡',0,0,0,0,0,0, '裨',0,0,0,0,0,0,0, */
	/* 88f0 */ -1,-1, 4, 4, 4,-1,-1,-1,  4, 4,-1,-1, 4, 4, 4,0, /* 0,0,'裲','裳','裴',0,0,0, '裸','裹',0,0,'裼','製','裾',0, */
	/* 8900 */ -1,-1, 4,-1, 4,-1,-1, 4, -1,-1, 4,-1, 4,0,0,0, /* 0,0,'褂',0,'褄',0,0,'複', 0,0,'褊',0,'褌',0,0,0, */
	/* 8910 */  4,-1, 4, 4,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4,0, /* '褐',0,'褒','褓',0,0,0,0, 0,0,0,0,0,'褝','褞',0, */
	/* 8920 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1, 4, 4,0,0,0,0, /* 0,0,0,0,0,'褥',0,0, 0,0,'褪','褫',0,0,0,0, */
	/* 8930 */ -1,-1,-1,-1,-1,-1, 4,-1,  4,-1,-1, 4,0,0,0,0, /* 0,0,0,0,0,0,'褶',0, '褸',0,0,'褻',0,0,0,0, */
	/* 8940 */ -1, 4,-1, 4, 4,-1,-1,-1, -1,-1,-1,-1, 4, 4,0,0, /* 0,'襁',0,'襃','襄',0,0,0, 0,0,0,0,'襌','襍',0,0, */
	/* 8950 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,0,0,0,0,0,'襖',0, 0,0,0,0,0,0,'襞','襟', */
	/* 8960 */  4,-1,-1,-1, 4,-1, 4,-1, -1,-1, 4,-1,-1, 4,-1, 4, /* '襠',0,0,0,'襤',0,'襦',0, 0,0,'襪',0,0,'襭',0,'襯', */
	/* 8970 */ -1,-1, 4,-1, 4,-1,-1, 4, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,0,'襲',0,'襴',0,0,'襷', 0,0,0,0,0,0,'襾','西', */
	/* 8980 */ -1, 4,-1, 4,-1,-1, 4, 4,  4,-1, 4, 4,-1,-1,-1, 4, /* 0,'要',0,'覃',0,0,'覆','覇', '覈',0,'覊','見',0,0,0,'規', */
	/* 8990 */ -1,-1,-1, 4,-1,-1, 4, 4,  4,-1, 4,0,0,0,0,0, /* 0,0,0,'覓',0,0,'視','覗', '覘',0,'覚',0,0,0,0,0, */
	/* 89a0 */ -1, 4,-1,-1,-1,-1, 4, 4, -1, 4, 4,-1, 4,-1,-1, 4, /* 0,'覡',0,0,0,0,'覦','覧', 0,'覩','親',0,'覬',0,0,'覯', */
	/* 89b0 */ -1,-1, 4, 4,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4,-1, 4, /* 0,0,'覲','観',0,0,0,0, 0,0,'覺',0,0,'覽',0,'覿', */
	/* 89c0 */  4,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '觀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 89d0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1, 4,-1, 4, 4,0,0, /* 0,0,'角',0,0,0,0,0, 0,0,'觚',0,'觜','觝',0,0, */
	/* 89e0 */ -1,-1,-1, 4,-1,-1, 4, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,'解',0,0,'触','觧', 0,0,0,0,0,0,0,0, */
	/* 89f0 */ -1,-1,-1,-1, 4,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,0,0,0,'觴',0,0,0, '觸',0,0,0,0,0,0,0, */
	/* 8a00 */  4,-1, 4, 4,-1,-1,-1,-1,  4,-1, 4,-1, 4,-1, 4,0, /* '言',0,'訂','訃',0,0,0,0, '計',0,'訊',0,'訌',0,'討',0, */
	/* 8a10 */  4,-1,-1, 4,-1,-1, 4, 4,  4,-1,-1, 4,-1, 4,-1, 4, /* '訐',0,0,'訓',0,0,'訖','託', '記',0,0,'訛',0,'訝',0,'訟', */
	/* 8a20 */ -1,-1,-1, 4,-1, 4,-1,-1, -1,-1, 4,-1,-1, 4,0,0, /* 0,0,0,'訣',0,'訥',0,0, 0,0,'訪',0,0,'設',0,0, */
	/* 8a30 */ -1, 4,-1, 4, 4,-1, 4,-1, -1,-1, 4, 4, 4,0,0,0, /* 0,'許',0,'訳','訴',0,'訶',0, 0,0,'診','註','証',0,0,0, */
	/* 8a40 */ -1, 4,-1,-1,-1,-1, 4,-1,  4,0,0,0,0,0,0,0, /* 0,'詁',0,0,0,0,'詆',0, '詈',0,0,0,0,0,0,0, */
	/* 8a50 */  4, 4, 4,-1, 4, 4,-1,-1, -1,-1,-1, 4,-1,-1, 4,0, /* '詐','詑','詒',0,'詔','評',0,0, 0,0,0,'詛',0,0,'詞',0, */
	/* 8a60 */  4,-1, 4, 4,-1,-1, 4,-1, -1, 4,-1, 4, 4, 4, 4,0, /* '詠',0,'詢','詣',0,0,'試',0, 0,'詩',0,'詫','詬','詭','詮',0, */
	/* 8a70 */  4, 4, 4, 4,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* '詰','話','該','詳',0,0,0,0, 0,0,0,0,'詼',0,0,0, */
	/* 8a80 */ -1,-1, 4,-1, 4, 4,-1, 4, -1, 4,-1,-1, 4, 4,0,0, /* 0,0,'誂',0,'誄','誅',0,'誇', 0,'誉',0,0,'誌','認',0,0, */
	/* 8a90 */ -1, 4,-1, 4,-1, 4,-1,-1,  4,-1, 4,-1,-1,-1, 4,0, /* 0,'誑',0,'誓',0,'誕',0,0, '誘',0,'誚',0,0,0,'語',0, */
	/* 8aa0 */  4, 4,-1, 4, 4, 4, 4,-1,  4,-1,-1,-1, 4, 4,0,0, /* '誠','誡',0,'誣','誤','誥','誦',0, '誨',0,0,0,'説','読',0,0, */
	/* 8ab0 */  4,-1, 4,-1,-1,-1,-1,-1, -1, 4,-1,-1, 4,-1,-1, 4, /* '誰',0,'課',0,0,0,0,0, 0,'誹',0,0,'誼',0,0,'調', */
	/* 8ac0 */ -1,-1, 4,-1, 4,-1,-1, 4, -1,-1,-1, 4, 4, 4,-1, 4, /* 0,0,'諂',0,'諄',0,0,'談', 0,0,0,'請','諌','諍',0,'諏', */
	/* 8ad0 */ -1,-1, 4,-1,-1,-1, 4,-1, -1,-1, 4, 4, 4,-1, 4,0, /* 0,0,'諒',0,0,0,'論',0, 0,0,'諚','諛','諜',0,'諞',0, */
	/* 8ae0 */  4, 4, 4,-1, 4,-1, 4, 4, -1,-1,-1, 4,-1, 4, 4,0, /* '諠','諡','諢',0,'諤',0,'諦','諧', 0,0,0,'諫',0,'諭','諮',0, */
	/* 8af0 */ -1, 4,-1, 4,-1,-1,-1, 4,  4,-1, 4,-1,-1,-1, 4,0, /* 0,'諱',0,'諳',0,0,0,'諷', '諸',0,'諺',0,0,0,'諾',0, */
	/* 8b00 */  4, 4, 4,-1, 4,-1,-1, 4, -1,-1,-1,-1, 4,-1, 4,0, /* '謀','謁','謂',0,'謄',0,0,'謇', 0,0,0,0,'謌',0,'謎',0, */
	/* 8b10 */  4,-1,-1,-1, 4,-1, 4, 4, -1, 4, 4, 4,-1, 4,0,0, /* '謐',0,0,0,'謔',0,'謖','謗', 0,'謙','謚','講',0,'謝',0,0, */
	/* 8b20 */  4, 4,-1,-1,-1,-1, 4,-1,  4,-1,-1, 4, 4,0,0,0, /* '謠','謡',0,0,0,0,'謦',0, '謨',0,0,'謫','謬',0,0,0, */
	/* 8b30 */ -1,-1,-1, 4,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1, 4,0, /* 0,0,0,'謳',0,0,0,0, 0,'謹',0,0,0,0,'謾',0, */
	/* 8b40 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1, 4,-1, 4, 4, /* 0,'譁',0,0,0,0,0,0, 0,'證',0,0,'譌',0,'譎','譏', */
	/* 8b50 */ -1,-1,-1,-1,-1,-1, 4,-1,  4,-1, 4, 4, 4,-1,-1, 4, /* 0,0,0,0,0,0,'譖',0, '識',0,'譚','譛','譜',0,0,'譟', */
	/* 8b60 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1, 4, 4,-1,-1, 4, /* 0,0,0,0,0,0,'警',0, 0,0,0,'譫','譬',0,0,'譯', */
	/* 8b70 */  4, 4, 4,-1, 4,-1,-1, 4, -1,-1,-1,-1,-1, 4,0,0, /* '議','譱','譲',0,'譴',0,0,'護', 0,0,0,0,0,'譽',0,0, */
	/* 8b80 */  4,-1,-1, 4,-1,-1,-1,-1, -1,-1, 4,-1, 4,-1, 4,0, /* '讀',0,0,'讃',0,0,0,0, 0,0,'變',0,'讌',0,'讎',0, */
	/* 8b90 */  4,-1, 4, 4,-1,-1, 4,-1, -1, 4, 4,0,0,0,0,0, /* '讐',0,'讒','讓',0,0,'讖',0, 0,'讙','讚',0,0,0,0,0, */
	/* 8ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c30 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1, 4,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,'谷', 0,0,'谺',0,0,0,0,'谿', */
	/* 8c40 */ -1, 4,-1,-1,-1,-1, 4,-1,  4,-1, 4,-1, 4,-1, 4,0, /* 0,'豁',0,0,0,0,'豆',0, '豈',0,'豊',0,'豌',0,'豎',0, */
	/* 8c50 */  4,-1,-1,-1,-1, 4,-1,-1, -1,-1, 4,0,0,0,0,0, /* '豐',0,0,0,0,'豕',0,0, 0,0,'豚',0,0,0,0,0, */
	/* 8c60 */ -1, 4, 4,-1,-1,-1,-1,-1, -1,-1, 4, 4, 4,0,0,0, /* 0,'象','豢',0,0,0,0,0, 0,0,'豪','豫','豬',0,0,0, */
	/* 8c70 */ -1,-1,-1,-1,-1,-1,-1,-1,  4, 4, 4,-1, 4,0,0,0, /* 0,0,0,0,0,0,0,0, '豸','豹','豺',0,'豼',0,0,0, */
	/* 8c80 */ -1,-1, 4,-1,-1, 4,-1,-1, -1, 4, 4,-1, 4, 4, 4,0, /* 0,0,'貂',0,0,'貅',0,0, 0,'貉','貊',0,'貌','貍','貎',0, */
	/* 8c90 */ -1,-1,-1,-1, 4,-1,-1,-1,  4,-1,-1,-1,-1, 4, 4,0, /* 0,0,0,0,'貔',0,0,0, '貘',0,0,0,0,'貝','貞',0, */
	/* 8ca0 */  4, 4, 4,-1,-1,-1,-1, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '負','財','貢',0,0,0,0,'貧', '貨','販','貪','貫','責','貭','貮','貯', */
	/* 8cb0 */  4,-1, 4, 4, 4,-1, 4, 4,  4,-1,-1, 4, 4, 4,-1, 4, /* '貰',0,'貲','貳','貴',0,'貶','買', '貸',0,0,'費','貼','貽',0,'貿', */
	/* 8cc0 */  4, 4, 4, 4, 4,-1,-1, 4,  4,-1, 4,-1,-1, 4, 4,0, /* '賀','賁','賂','賃','賄',0,0,'資', '賈',0,'賊',0,0,'賍','賎',0, */
	/* 8cd0 */ -1, 4,-1, 4,-1,-1,-1,-1, -1,-1, 4, 4, 4,-1, 4,0, /* 0,'賑',0,'賓',0,0,0,0, 0,0,'賚','賛','賜',0,'賞',0, */
	/* 8ce0 */  4,-1, 4, 4, 4,-1, 4,-1, -1,-1, 4,-1,-1, 4,0,0, /* '賠',0,'賢','賣','賤',0,'賦',0, 0,0,'質',0,0,'賭',0,0, */
	/* 8cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4, 4, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'賺','賻','購','賽',0,0, */
	/* 8d00 */ -1,-1,-1,-1, 4, 4,-1, 4,  4,-1, 4, 4,-1, 4,-1, 4, /* 0,0,0,0,'贄','贅',0,'贇', '贈',0,'贊','贋',0,'贍',0,'贏', */
	/* 8d10 */  4,-1,-1, 4, 4,-1, 4,0, 0,0,0,0,0,0,0,0, /* '贐',0,0,'贓','贔',0,'贖',0, 0,0,0,0,0,0,0,0, */
	/* 8d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d60 */ -1,-1,-1,-1, 4,-1, 4, 4, -1,-1,-1, 4,-1, 4,0,0, /* 0,0,0,0,'赤',0,'赦','赧', 0,0,0,'赫',0,'赭',0,0, */
	/* 8d70 */  4, 4,-1, 4, 4,-1,-1, 4, 0,0,0,0,0,0,0,0, /* '走','赱',0,'赳','赴',0,0,'起', 0,0,0,0,0,0,0,0, */
	/* 8d80 */ -1, 4,-1,-1,-1, 4,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,'趁',0,0,0,'超',0,0, 0,0,'越',0,0,0,0,0, */
	/* 8d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'趙',0,0,0,0,0,0, */
	/* 8da0 */ -1,-1,-1, 4,-1,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,0,0,'趣',0,0,0,0, '趨',0,0,0,0,0,0,0, */
	/* 8db0 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1, 4,-1,-1,-1, 4,0, /* 0,0,0,'足',0,0,0,0, 0,0,'趺',0,0,0,'趾',0, */
	/* 8dc0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1,-1, 4, /* 0,0,'跂',0,0,0,0,0, 0,0,0,'跋','跌',0,0,'跏', */
	/* 8dd0 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1, 4, 4,-1, 4,-1, 4, /* 0,0,0,0,0,0,'跖',0, 0,0,'跚','跛',0,'距',0,'跟', */
	/* 8de0 */ -1, 4,-1, 4,-1,-1,-1,-1,  4,-1, 4, 4,-1,-1,-1, 4, /* 0,'跡',0,'跣',0,0,0,0, '跨',0,'跪','跫',0,0,0,'路', */
	/* 8df0 */ -1,-1,-1, 4,-1, 4,-1,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,'跳',0,'践',0,0, 0,0,0,0,'跼',0,0,'跿', */
	/* 8e00 */ -1,-1,-1,-1,-1,-1,-1,-1,  4, 4, 4,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, '踈','踉','踊',0,0,0,0,'踏', */
	/* 8e10 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4, 4, /* '踐',0,0,0,0,0,0,0, 0,0,0,0,0,'踝','踞','踟', */
	/* 8e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'踪',0,0,0,0,0, */
	/* 8e30 */  4,-1,-1,-1, 4, 4,0,0, 0,0,0,0,0,0,0,0, /* '踰',0,0,0,'踴','踵',0,0, 0,0,0,0,0,0,0,0, */
	/* 8e40 */ -1,-1, 4,-1, 4,-1,-1, 4,  4, 4, 4,-1, 4,0,0,0, /* 0,0,'蹂',0,'蹄',0,0,'蹇', '蹈','蹉','蹊',0,'蹌',0,0,0, */
	/* 8e50 */  4,-1,-1,-1,-1, 4,-1,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* '蹐',0,0,0,0,'蹕',0,0, 0,'蹙',0,0,0,0,0,'蹟', */
	/* 8e60 */  4,-1,-1, 4, 4,0,0,0, 0,0,0,0,0,0,0,0, /* '蹠',0,0,'蹣','蹤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8e70 */ -1,-1, 4,-1, 4,-1, 4,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,'蹲',0,'蹴',0,'蹶',0, 0,0,0,0,'蹼',0,0,0, */
	/* 8e80 */ -1, 4,-1,-1, 4, 4,-1, 4, -1,-1, 4, 4,-1, 4,0,0, /* 0,'躁',0,0,'躄','躅',0,'躇', 0,0,'躊','躋',0,'躍',0,0, */
	/* 8e90 */ -1, 4,-1, 4, 4,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,'躑',0,'躓','躔',0,0,0, 0,'躙',0,0,0,0,0,0, */
	/* 8ea0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4, 4,-1,-1, 4, /* 0,'躡',0,0,0,0,0,0, 0,0,'躪','身','躬',0,0,'躯', */
	/* 8eb0 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* '躰','躱',0,0,0,0,0,0, 0,0,0,0,0,0,'躾',0, */
	/* 8ec0 */ -1,-1,-1,-1,-1, 4, 4,-1,  4,-1, 4, 4, 4, 4,0,0, /* 0,0,0,0,0,'軅','軆',0, '軈',0,'車','軋','軌','軍',0,0, */
	/* 8ed0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,0,'軒',0,0,0,0,0, 0,0,0,'軛',0,0,0,'軟', */
	/* 8ee0 */ -1,-1, 4, 4,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,0,'転','軣',0,0,0,0, 0,0,0,'軫',0,0,0,0, */
	/* 8ef0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1, 4, 4, 4, 4,0, /* 0,0,0,0,0,0,0,0, '軸',0,0,'軻','軼','軽','軾',0, */
	/* 8f00 */ -1,-1,-1, 4,-1, 4,-1,-1, -1, 4, 4,-1, 4,0,0,0, /* 0,0,0,'較',0,'輅',0,0, 0,'載','輊',0,'輌',0,0,0, */
	/* 8f10 */ -1,-1, 4, 4, 4, 4,-1,-1, -1, 4,-1, 4, 4, 4,-1, 4, /* 0,0,'輒','輓','輔','輕',0,0, 0,'輙',0,'輛','輜','輝',0,'輟', */
	/* 8f20 */ -1,-1,-1,-1,-1,-1, 4,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,'輦',0, 0,'輩','輪',0,0,0,0,'輯', */
	/* 8f30 */ -1,-1,-1, 4,-1,-1,-1,-1,  4, 4,-1, 4,-1,-1, 4, 4, /* 0,0,0,'輳',0,0,0,0, '輸','輹',0,'輻',0,0,'輾','輿', */
	/* 8f40 */ -1,-1, 4,-1, 4, 4, 4,-1, -1, 4,-1,-1, 4, 4, 4,0, /* 0,0,'轂',0,'轄','轅','轆',0, 0,'轉',0,0,'轌','轍','轎',0, */
	/* 8f50 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,0,0,0,0,'轗', 0,0,0,0,'轜',0,0,'轟', */
	/* 8f60 */ -1, 4, 4, 4, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'轡','轢','轣','轤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,'辛','辜',0,'辞','辟', */
	/* 8fa0 */ -1,-1,-1, 4,-1,-1,-1, 4,  4,-1,-1,-1,-1, 4, 4, 4, /* 0,0,0,'辣',0,0,0,'辧', '辨',0,0,0,0,'辭','辮','辯', */
	/* 8fb0 */  4, 4, 4,-1,-1,-1,-1, 4, -1,-1, 4, 4, 4,-1,-1, 4, /* '辰','辱','農',0,0,0,0,'辷', 0,0,'辺','辻','込',0,0,'辿', */
	/* 8fc0 */ -1,-1, 4,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,'迂',0,'迄','迅',0,0, 0,0,0,0,0,0,'迎',0, */
	/* 8fd0 */ -1, 4,-1,-1, 4,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,'近',0,0,'返',0,0,0, 0,0,'迚',0,0,0,0,0, */
	/* 8fe0 */ -1,-1, 4,-1,-1, 4, 4,-1, -1, 4, 4, 4,-1, 4,-1, 4, /* 0,0,'迢',0,0,'迥','迦',0, 0,'迩','迪','迫',0,'迭',0,'迯', */
	/* 8ff0 */  4,-1,-1,-1, 4,-1,-1, 4,  4, 4, 4,-1,-1, 4,0,0, /* '述',0,0,0,'迴',0,0,'迷', '迸','迹','迺',0,0,'追',0,0, */
	/* 9000 */  4, 4,-1, 4,-1, 4, 4,-1, -1,-1,-1, 4,-1, 4, 4, 4, /* '退','送',0,'逃',0,'逅','逆',0, 0,0,0,'逋',0,'逍','逎','透', */
	/* 9010 */  4, 4,-1, 4, 4, 4, 4, 4, -1, 4, 4,-1,-1, 4, 4, 4, /* '逐','逑',0,'逓','途','逕','逖','逗', 0,'這','通',0,0,'逝','逞','速', */
	/* 9020 */  4, 4, 4, 4,-1,-1,-1, 4, -1,-1,-1,-1,-1,-1, 4,0, /* '造','逡','逢','連',0,0,0,'逧', 0,0,0,0,0,0,'逮',0, */
	/* 9030 */ -1, 4, 4,-1,-1, 4, 4,-1,  4, 4,-1,-1, 4,-1, 4,0, /* 0,'週','進',0,0,'逵','逶',0, '逸','逹',0,0,'逼',0,'逾',0, */
	/* 9040 */ -1, 4, 4,-1,-1, 4,-1, 4, -1, 4, 4, 4,-1, 4, 4, 4, /* 0,'遁','遂',0,0,'遅',0,'遇', 0,'遉','遊','運',0,'遍','過','遏', */
	/* 9050 */  4, 4, 4, 4, 4, 4, 4,-1,  4, 4,-1,-1, 4,-1, 4,0, /* '遐','遑','遒','道','達','違','遖',0, '遘','遙',0,0,'遜',0,'遞',0, */
	/* 9060 */  4, 4,-1, 4,-1, 4,-1,-1,  4, 4,-1,-1,-1, 4, 4, 4, /* '遠','遡',0,'遣',0,'遥',0,0, '遨','適',0,0,0,'遭','遮','遯', */
	/* 9070 */ -1,-1, 4,-1,-1, 4, 4, 4,  4,-1, 4,-1, 4, 4,-1, 4, /* 0,0,'遲',0,0,'遵','遶','遷', '選',0,'遺',0,'遼','遽',0,'避', */
	/* 9080 */  4, 4, 4, 4, 4,-1,-1, 4, -1, 4, 4,-1,-1,-1,-1, 4, /* '邀','邁','邂','邃','還',0,0,'邇', 0,'邉','邊',0,0,0,0,'邏', */
	/* 9090 */ -1, 4,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'邑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 90a0 */ -1,-1,-1, 4,-1,-1, 4,-1,  4,-1, 4,-1,-1,-1,-1, 4, /* 0,0,0,'那',0,0,'邦',0, '邨',0,'邪',0,0,0,0,'邯', */
	/* 90b0 */ -1, 4,-1,-1,-1, 4,-1,-1,  4,0,0,0,0,0,0,0, /* 0,'邱',0,0,0,'邵',0,0, '邸',0,0,0,0,0,0,0, */
	/* 90c0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1,-1, 4,0, /* 0,'郁',0,0,0,0,0,0, 0,0,'郊',0,0,0,'郎',0, */
	/* 90d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'郛',0,0,0,0, */
	/* 90e0 */ -1, 4, 4,-1, 4,-1,-1,-1,  4,-1,-1,-1,-1, 4,0,0, /* 0,'郡','郢',0,'郤',0,0,0, '部',0,0,0,0,'郭',0,0, */
	/* 90f0 */ -1,-1,-1,-1,-1, 4,-1, 4, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,'郵',0,'郷', 0,0,0,0,0,'都',0,0, */
	/* 9100 */ -1,-1, 4,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'鄂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9110 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,'鄒',0,0,0,0,0, 0,'鄙',0,0,0,0,0,0, */
	/* 9120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'鄭',0,0, */
	/* 9130 */  4,-1, 4,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '鄰',0,'鄲',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4, 4, 4, 4, 4, 4,0, /* 0,0,0,0,0,0,0,0, 0,'酉','酊','酋','酌','配','酎',0, */
	/* 9150 */ -1,-1, 4,-1, 4,-1, 4,-1,  4,0,0,0,0,0,0,0, /* 0,0,'酒',0,'酔',0,'酖',0, '酘',0,0,0,0,0,0,0, */
	/* 9160 */ -1,-1, 4, 4,-1, 4,-1,-1, -1, 4, 4,-1, 4,0,0,0, /* 0,0,'酢','酣',0,'酥',0,0, 0,'酩','酪',0,'酬',0,0,0, */
	/* 9170 */ -1,-1, 4, 4,-1, 4,-1, 4,  4,0,0,0,0,0,0,0, /* 0,0,'酲','酳',0,'酵',0,'酷', '酸',0,0,0,0,0,0,0, */
	/* 9180 */ -1,-1, 4,-1,-1,-1,-1, 4, -1, 4,-1, 4,-1, 4,0,0, /* 0,0,'醂',0,0,0,0,'醇', 0,'醉',0,'醋',0,'醍',0,0, */
	/* 9190 */  4,-1, 4,-1,-1,-1,-1, 4, -1,-1,-1,-1, 4,0,0,0, /* '醐',0,'醒',0,0,0,0,'醗', 0,0,0,0,'醜',0,0,0, */
	/* 91a0 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1, 4, 4,-1,-1,-1, 4, /* 0,0,'醢',0,'醤',0,0,0, 0,0,'醪','醫',0,0,0,'醯', */
	/* 91b0 */ -1,-1,-1,-1, 4, 4,-1,-1,  4,-1, 4,0,0,0,0,0, /* 0,0,0,0,'醴','醵',0,0, '醸',0,'醺',0,0,0,0,0, */
	/* 91c0 */  4, 4,-1,-1,-1,-1, 4, 4,  4, 4,-1, 4, 4, 4, 4, 4, /* '釀','釁',0,0,0,0,'釆','采', '釈','釉',0,'釋','里','重','野','量', */
	/* 91d0 */  4, 4,-1,-1,-1,-1, 4,-1,  4,-1,-1, 4, 4, 4,-1, 4, /* '釐','金',0,0,0,0,'釖',0, '釘',0,0,'釛','釜','針',0,'釟', */
	/* 91e0 */ -1, 4,-1, 4,-1,-1, 4, 4, 0,0,0,0,0,0,0,0, /* 0,'釡',0,'釣',0,0,'釦','釧', 0,0,0,0,0,0,0,0, */
	/* 91f0 */ -1,-1,-1,-1,-1, 4, 4,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* 0,0,0,0,0,'釵','釶',0, 0,0,0,0,'釼',0,0,'釿', */
	/* 9200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'鈍','鈎',0, */
	/* 9210 */ -1, 4,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,'鈑',0,0,'鈔','鈕',0,0, 0,0,0,0,0,0,'鈞',0, */
	/* 9220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'鈩',0,0,'鈬',0,0,0, */
	/* 9230 */ -1,-1,-1,-1, 4,-1,-1, 4, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,'鈴',0,0,'鈷', 0,0,0,0,0,0,0,'鈿', */
	/* 9240 */ -1,-1,-1,-1, 4, 4,-1,-1,  4, 4,-1, 4,0,0,0,0, /* 0,0,0,0,'鉄','鉅',0,0, '鉈','鉉',0,'鉋',0,0,0,0, */
	/* 9250 */  4,-1,-1,-1,-1,-1,-1, 4, -1,-1, 4, 4,-1,-1, 4,0, /* '鉐',0,0,0,0,0,0,'鉗', 0,0,'鉚','鉛',0,0,'鉞',0, */
	/* 9260 */ -1,-1, 4,-1, 4,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,0,'鉢',0,'鉤',0,'鉦',0, 0,0,0,0,0,0,0,0, */
	/* 9270 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,'鉱',0,0,0,0,0,0, 0,0,0,0,0,0,'鉾',0, */
	/* 9280 */  4,-1,-1, 4,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* '銀',0,0,'銃',0,'銅',0,0, 0,0,0,0,0,0,0,0, */
	/* 9290 */ -1, 4,-1, 4,-1, 4, 4,-1,  4,-1, 4, 4, 4,0,0,0, /* 0,'銑',0,'銓',0,'銕','銖',0, '銘',0,'銚','銛','銜',0,0,0, */
	/* 92a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'銭',0,0, */
	/* 92b0 */ -1,-1,-1,-1,-1,-1,-1, 4, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'銷', 0,'銹',0,0,0,0,0,0, */
	/* 92c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'鋏', */
	/* 92d0 */ -1,-1, 4,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'鋒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 92e0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1, 4, 4,-1,-1, 4,0,0, /* 0,0,0,0,'鋤',0,0,0, 0,'鋩','鋪',0,0,'鋭',0,0, */
	/* 92f0 */ -1,-1, 4, 4,-1,-1,-1,-1,  4,-1, 4,-1, 4,0,0,0, /* 0,0,'鋲','鋳',0,0,0,0, '鋸',0,'鋺',0,'鋼',0,0,0, */
	/* 9300 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,'錆',0, 0,0,0,0,0,0,0,'錏', */
	/* 9310 */  4,-1,-1,-1,-1,-1,-1,-1,  4, 4, 4,0,0,0,0,0, /* '錐',0,0,0,0,0,0,0, '錘','錙','錚',0,0,0,0,0, */
	/* 9320 */  4,-1, 4, 4,-1,-1, 4,-1,  4,-1,-1, 4, 4,-1, 4, 4, /* '錠',0,'錢','錣',0,0,'錦',0, '錨',0,0,'錫','錬',0,'錮','錯', */
	/* 9330 */ -1,-1, 4,-1,-1, 4,-1,-1, -1,-1, 4, 4,0,0,0,0, /* 0,0,'録',0,0,'錵',0,0, 0,0,'錺','錻',0,0,0,0, */
	/* 9340 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1, 4,-1, 4,0,0, /* 0,0,0,0,'鍄',0,0,0, 0,0,0,'鍋',0,'鍍',0,0, */
	/* 9350 */ -1,-1,-1,-1, 4,-1, 4,-1, -1,-1,-1, 4, 4,0,0,0, /* 0,0,0,0,'鍔',0,'鍖',0, 0,0,0,'鍛','鍜',0,0,0, */
	/* 9360 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,-1, 4,0, /* '鍠',0,0,0,0,0,0,0, 0,0,0,0,'鍬',0,'鍮',0, */
	/* 9370 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1, 4,-1, 4,0, /* 0,0,0,0,0,'鍵',0,0, 0,0,0,0,'鍼',0,'鍾',0, */
	/* 9380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'鎌',0,0,0, */
	/* 9390 */ -1,-1,-1,-1, 4,-1, 4, 4, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,'鎔',0,'鎖','鎗', 0,0,'鎚',0,0,0,0,0, */
	/* 93a0 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1, 4, 4, 4,0, /* 0,0,0,0,0,0,0,'鎧', 0,0,0,0,'鎬','鎭','鎮',0, */
	/* 93b0 */  4,-1,-1,-1,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* '鎰',0,0,0,0,0,0,0, 0,'鎹',0,0,0,0,0,0, */
	/* 93c0 */ -1,-1,-1, 4,-1,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,0,0,'鏃',0,0,0,0, '鏈',0,0,0,0,0,0,0, */
	/* 93d0 */  4, 4,-1,-1,-1,-1, 4, 4,  4,-1,-1,-1,-1, 4,0,0, /* '鏐','鏑',0,0,0,0,'鏖','鏗', '鏘',0,0,0,0,'鏝',0,0, */
	/* 93e0 */ -1, 4,-1,-1, 4, 4,-1,-1,  4,0,0,0,0,0,0,0, /* 0,'鏡',0,0,'鏤','鏥',0,0, '鏨',0,0,0,0,0,0,0, */
	/* 93f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9400 */ -1,-1,-1, 4,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,'鐃',0,0,0,'鐇', 0,0,0,0,0,0,0,0, */
	/* 9410 */  4,-1,-1, 4, 4,-1,-1,-1,  4, 4, 4,0,0,0,0,0, /* '鐐',0,0,'鐓','鐔',0,0,0, '鐘','鐙','鐚',0,0,0,0,0, */
	/* 9420 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,0,0,0,0, /* 0,'鐡',0,0,0,0,0,0, 0,0,0,'鐫',0,0,0,0, */
	/* 9430 */ -1,-1,-1,-1,-1, 4, 4,-1,  4,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,'鐵','鐶',0, '鐸',0,'鐺',0,0,0,0,0, */
	/* 9440 */ -1, 4,-1,-1, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'鑁',0,0,'鑄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9450 */ -1, 4, 4, 4,-1,-1,-1,-1, -1,-1, 4, 4,-1,-1, 4,0, /* 0,'鑑','鑒','鑓',0,0,0,0, 0,0,'鑚','鑛',0,0,'鑞',0, */
	/* 9460 */  4,-1, 4,-1,-1,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* '鑠',0,'鑢',0,0,0,0,0, 0,0,'鑪',0,0,0,0,0, */
	/* 9470 */  4,-1,-1,-1,-1, 4,-1, 4, -1,-1,-1,-1, 4, 4, 4, 4, /* '鑰',0,0,0,0,'鑵',0,'鑷', 0,0,0,0,'鑼','鑽','鑾','鑿', */
	/* 9480 */ -1, 4,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'钁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9570 */ -1,-1,-1,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'長', 0,0,0,0,0,0,0,0, */
	/* 9580 */  4,-1, 4, 4,-1,-1,-1, 4, -1, 4, 4, 4,-1,-1,-1, 4, /* '門',0,'閂','閃',0,0,0,'閇', 0,'閉','閊','開',0,0,0,'閏', */
	/* 9590 */ -1, 4,-1, 4, 4,-1, 4,-1,  4, 4,0,0,0,0,0,0, /* 0,'閑',0,'間','閔',0,'閖',0, '閘','閙',0,0,0,0,0,0, */
	/* 95a0 */  4,-1, 4, 4, 4, 4,-1, 4,  4,-1,-1,-1,-1, 4,0,0, /* '閠',0,'関','閣','閤','閥',0,'閧', '閨',0,0,0,0,'閭',0,0, */
	/* 95b0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4,-1, 4, 4,-1, 4,0, /* 0,0,'閲',0,0,0,0,0, 0,'閹',0,'閻','閼',0,'閾',0, */
	/* 95c0 */ -1,-1,-1, 4,-1,-1,-1, 4, -1,-1, 4,-1, 4, 4,0,0, /* 0,0,0,'闃',0,0,0,'闇', 0,0,'闊',0,'闌','闍',0,0, */
	/* 95d0 */ -1,-1,-1,-1, 4, 4, 4,-1,  4,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,'闔','闕','闖',0, '闘',0,0,0,'關',0,0,0, */
	/* 95e0 */ -1, 4, 4,-1,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,'闡','闢',0,0,'闥',0,0, 0,0,0,0,0,0,0,0, */
	/* 95f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'阜',0,0,0, */
	/* 9620 */ -1, 4,-1,-1,-1,-1,-1,-1,  4,-1, 4,-1,-1,-1, 4, 4, /* 0,'阡',0,0,0,0,0,0, '阨',0,'阪',0,0,0,'阮','阯', */
	/* 9630 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,0,'防',0,0,0,0,0, 0,0,0,'阻',0,0,0,'阿', */
	/* 9640 */  4,-1, 4,-1, 4,-1,-1,-1, -1,-1,-1, 4, 4, 4,-1, 4, /* '陀',0,'陂',0,'附',0,0,0, 0,0,0,'陋','陌','降',0,'陏', */
	/* 9650 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4, 4, 4, 4, /* '限',0,0,0,0,0,0,0, 0,0,0,'陛','陜','陝','陞','陟', */
	/* 9660 */ -1,-1, 4, 4, 4, 4, 4,-1, -1,-1, 4,-1, 4,0,0,0, /* 0,0,'院','陣','除','陥','陦',0, 0,0,'陪',0,'陬',0,0,0, */
	/* 9670 */  4,-1, 4, 4,-1, 4, 4, 4,  4,-1, 4,-1,-1, 4,0,0, /* '陰',0,'陲','陳',0,'陵','陶','陷', '陸',0,'険',0,0,'陽',0,0, */
	/* 9680 */ -1,-1,-1,-1,-1, 4, 4,-1,  4,-1, 4, 4,-1, 4, 4, 4, /* 0,0,0,0,0,'隅','隆',0, '隈',0,'隊','隋',0,'隍','階','随', */
	/* 9690 */ -1,-1,-1,-1, 4, 4,-1, 4,  4, 4,-1, 4, 4,0,0,0, /* 0,0,0,0,'隔','隕',0,'隗', '隘','隙',0,'際','障',0,0,0, */
	/* 96a0 */  4,-1,-1, 4,-1,-1,-1, 4,  4,-1, 4,0,0,0,0,0, /* '隠',0,0,'隣',0,0,0,'隧', '隨',0,'險',0,0,0,0,0, */
	/* 96b0 */  4, 4, 4,-1, 4,-1, 4, 4,  4, 4,-1, 4, 4,0,0,0, /* '隰','隱','隲',0,'隴',0,'隶','隷', '隸','隹',0,'隻','隼',0,0,0, */
	/* 96c0 */  4, 4,-1,-1, 4, 4, 4, 4, -1, 4,-1, 4, 4, 4, 4,0, /* '雀','雁',0,0,'雄','雅','集','雇', 0,'雉',0,'雋','雌','雍','雎',0, */
	/* 96d0 */ -1, 4,-1,-1,-1, 4, 4,-1, -1, 4,-1, 4, 4,0,0,0, /* 0,'雑',0,0,0,'雕','雖',0, 0,'雙',0,'雛','雜',0,0,0, */
	/* 96e0 */ -1,-1, 4, 4,-1,-1,-1,-1,  4,-1, 4, 4,0,0,0,0, /* 0,0,'離','難',0,0,0,0, '雨',0,'雪','雫',0,0,0,0, */
	/* 96f0 */  4,-1, 4,-1,-1,-1, 4, 4, -1, 4,-1, 4,0,0,0,0, /* '雰',0,'雲',0,0,0,'零','雷', 0,'雹',0,'電',0,0,0,0, */
	/* 9700 */  4,-1,-1,-1, 4,-1, 4, 4,  4,-1, 4,-1,-1, 4, 4, 4, /* '需',0,0,0,'霄',0,'霆','震', '霈',0,'霊',0,0,'霍','霎','霏', */
	/* 9710 */ -1, 4,-1, 4,-1,-1, 4,-1, -1, 4,-1,-1, 4,-1, 4,0, /* 0,'霑',0,'霓',0,0,'霖',0, 0,'霙',0,0,'霜',0,'霞',0, */
	/* 9720 */ -1,-1,-1,-1, 4,-1,-1, 4, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,'霤',0,0,'霧', 0,0,'霪',0,0,0,0,0, */
	/* 9730 */  4,-1, 4,-1,-1,-1,-1,-1,  4, 4,-1,-1,-1, 4, 4,0, /* '霰',0,'露',0,0,0,0,0, '霸','霹',0,0,0,'霽','霾',0, */
	/* 9740 */ -1,-1, 4,-1, 4,-1, 4,-1,  4, 4,0,0,0,0,0,0, /* 0,0,'靂',0,'靄',0,'靆',0, '靈','靉',0,0,0,0,0,0, */
	/* 9750 */ -1,-1, 4,-1,-1,-1, 4,-1, -1, 4,-1,-1, 4,-1, 4,0, /* 0,0,'青',0,0,0,'靖',0, 0,'静',0,0,'靜',0,'非',0, */
	/* 9760 */  4, 4, 4,-1, 4,-1, 4,-1,  4, 4,-1, 4,-1, 4,0,0, /* '靠','靡','面',0,'靤',0,'靦',0, '靨','革',0,'靫',0,'靭',0,0, */
	/* 9770 */ -1, 4,-1,-1, 4,-1,-1,-1, -1, 4, 4,-1, 4,0,0,0, /* 0,'靱',0,0,'靴',0,0,0, 0,'靹','靺',0,'靼',0,0,0, */
	/* 9780 */ -1, 4,-1,-1, 4, 4, 4,-1, -1,-1,-1, 4,-1, 4,-1, 4, /* 0,'鞁',0,0,'鞄','鞅','鞆',0, 0,0,0,'鞋',0,'鞍',0,'鞏', */
	/* 9790 */  4,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1,-1, 4,0,0,0, /* '鞐',0,0,0,0,0,0,0, '鞘',0,0,0,'鞜',0,0,0, */
	/* 97a0 */  4,-1,-1, 4,-1,-1, 4,-1,  4,-1,-1, 4,-1, 4,0,0, /* '鞠',0,0,'鞣',0,0,'鞦',0, '鞨',0,0,'鞫',0,'鞭',0,0, */
	/* 97b0 */ -1,-1,-1, 4, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'鞳','鞴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 97c0 */ -1,-1,-1, 4,-1,-1, 4,-1,  4,-1,-1, 4,0,0,0,0, /* 0,0,0,'韃',0,0,'韆',0, '韈',0,0,'韋',0,0,0,0, */
	/* 97d0 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,'韓',0,0,0,0, 0,0,0,0,'韜',0,0,0, */
	/* 97e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'韭','韮',0, */
	/* 97f0 */ -1,-1, 4, 4,-1, 4, 4,-1, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,0,'韲','音',0,'韵','韶',0, 0,0,0,'韻',0,0,0,'響', */
	/* 9800 */ -1, 4, 4, 4,-1, 4, 4,-1,  4,-1,-1,-1, 4,-1,-1, 4, /* 0,'頁','頂','頃',0,'項','順',0, '須',0,0,0,'頌',0,0,'頏', */
	/* 9810 */  4, 4, 4, 4,-1,-1,-1, 4,  4,-1, 4,0,0,0,0,0, /* '預','頑','頒','頓',0,0,0,'頗', '領',0,'頚',0,0,0,0,0, */
	/* 9820 */ -1, 4,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1, 4, 4,0,0, /* 0,'頡',0,0,'頤',0,0,0, 0,0,0,0,'頬','頭',0,0, */
	/* 9830 */ -1,-1,-1,-1, 4,-1,-1, 4,  4,-1,-1, 4, 4, 4,0,0, /* 0,0,0,0,'頴',0,0,'頷', '頸',0,0,'頻','頼','頽',0,0, */
	/* 9840 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1, 4, 4, 4, 4, 4, /* 0,0,0,0,0,0,'顆',0, 0,0,0,'顋','題','額','顎','顏', */
	/* 9850 */ -1,-1,-1,-1, 4, 4,-1,-1,  4,-1,-1, 4,-1,-1, 4,0, /* 0,0,0,0,'顔','顕',0,0, '願',0,0,'顛',0,0,'類',0, */
	/* 9860 */ -1,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,'顧', 0,0,0,'顫',0,0,0,'顯', */
	/* 9870 */  4, 4,-1, 4, 4,0,0,0, 0,0,0,0,0,0,0,0, /* '顰','顱',0,'顳','顴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 98a0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1, 4,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, '風',0,'颪',0,0,0,0,'颯', */
	/* 98b0 */ -1, 4,-1,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,'颱',0,0,0,0,'颶',0, 0,0,0,0,0,0,0,0, */
	/* 98c0 */ -1,-1,-1, 4, 4,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'飃','飄',0,'飆',0, 0,0,0,0,0,0,0,0, */
	/* 98d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,'飛','飜',0,0,'食', */
	/* 98e0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1, 4,-1, 4,-1, 4, 4, 4, /* 0,0,'飢',0,0,0,0,0, 0,'飩',0,'飫',0,'飭','飮','飯', */
	/* 98f0 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1,-1,-1, 4, 4, 4,0, /* 0,0,'飲',0,'飴',0,0,0, 0,0,0,0,'飼','飽','飾',0, */
	/* 9900 */ -1,-1,-1, 4,-1, 4,-1,-1, -1, 4, 4,-1, 4,0,0,0, /* 0,0,0,'餃',0,'餅',0,0, 0,'餉','養',0,'餌',0,0,0, */
	/* 9910 */  4,-1, 4, 4, 4,-1,-1,-1,  4,-1,-1,-1,-1, 4, 4,0, /* '餐',0,'餒','餓','餔',0,0,0, '餘',0,0,0,0,'餝','餞',0, */
	/* 9920 */  4, 4,-1,-1, 4,-1,-1,-1,  4,-1,-1,-1, 4,-1, 4,0, /* '餠','餡',0,0,'餤',0,0,0, '館',0,0,0,'餬',0,'餮',0, */
	/* 9930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'餽','餾',0, */
	/* 9940 */ -1,-1, 4,-1,-1, 4,-1,-1, -1, 4,-1, 4, 4,0,0,0, /* 0,0,'饂',0,0,'饅',0,0, 0,'饉',0,'饋','饌',0,0,0, */
	/* 9950 */  4, 4, 4,-1,-1, 4,-1, 4, 0,0,0,0,0,0,0,0, /* '饐','饑','饒',0,0,'饕',0,'饗', 0,0,0,0,0,0,0,0, */
	/* 9960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9990 */ -1,-1,-1,-1,-1,-1, 4, 4,  4, 4,0,0,0,0,0,0, /* 0,0,0,0,0,0,'首','馗', '馘','香',0,0,0,0,0,0, */
	/* 99a0 */ -1,-1,-1,-1,-1, 4,-1,-1,  4,-1,-1,-1, 4, 4, 4,0, /* 0,0,0,0,0,'馥',0,0, '馨',0,0,0,'馬','馭','馮',0, */
	/* 99b0 */ -1,-1,-1, 4, 4,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* 0,0,0,'馳','馴',0,0,0, 0,0,0,0,'馼',0,0,0, */
	/* 99c0 */ -1, 4,-1,-1, 4, 4, 4,-1,  4,0,0,0,0,0,0,0, /* 0,'駁',0,0,'駄','駅','駆',0, '駈',0,0,0,0,0,0,0, */
	/* 99d0 */  4, 4, 4,-1,-1, 4,-1,-1,  4,-1,-1, 4,-1, 4,-1, 4, /* '駐','駑','駒',0,0,'駕',0,0, '駘',0,0,'駛',0,'駝',0,'駟', */
	/* 99e0 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4,0, /* 0,0,'駢',0,0,0,0,0, 0,0,0,0,0,'駭','駮',0, */
	/* 99f0 */ -1, 4, 4,-1,-1,-1,-1,-1,  4,-1,-1, 4,-1,-1,-1, 4, /* 0,'駱','駲',0,0,0,0,0, '駸',0,0,'駻',0,0,0,'駿', */
	/* 9a00 */ -1, 4,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,'騁',0,0,0,'騅',0,0, 0,0,0,0,0,0,'騎','騏', */
	/* 9a10 */ -1,-1, 4, 4,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,'騒','験',0,0,0,0, 0,'騙',0,0,0,0,0,0, */
	/* 9a20 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1, 4,0,0,0,0, /* 0,0,0,0,0,0,0,0, '騨',0,0,'騫',0,0,0,0, */
	/* 9a30 */  4,-1,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1,-1,-1, 4,0, /* '騰',0,0,0,0,0,0,'騷', 0,0,0,0,0,0,'騾',0, */
	/* 9a40 */  4,-1, 4, 4,-1, 4,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* '驀',0,'驂','驃',0,'驅',0,0, 0,0,0,0,0,'驍',0,0, */
	/* 9a50 */ -1,-1,-1,-1,-1, 4,-1, 4, -1,-1, 4, 4,-1,-1,-1, 4, /* 0,0,0,0,0,'驕',0,'驗', 0,0,'驚','驛',0,0,0,'驟', */
	/* 9a60 */ -1,-1, 4,-1, 4, 4,-1,-1, -1, 4, 4, 4,0,0,0,0, /* 0,0,'驢',0,'驤','驥',0,0, 0,'驩','驪','驫',0,0,0,0, */
	/* 9a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9aa0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,0,0, '骨',0,0,0,0,'骭',0,0, */
	/* 9ab0 */  4,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1,-1, 4,0,0,0, /* '骰',0,0,0,0,0,0,0, '骸',0,0,0,'骼',0,0,0, */
	/* 9ac0 */  4,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* '髀',0,0,0,'髄',0,0,0, 0,0,0,0,0,0,0,'髏', */
	/* 9ad0 */ -1, 4,-1, 4, 4,-1,-1,-1,  4,-1,-1,-1,-1,-1, 4, 4, /* 0,'髑',0,'髓','體',0,0,0, '高',0,0,0,0,0,'髞','髟', */
	/* 9ae0 */ -1,-1, 4, 4,-1,-1, 4,-1, -1,-1, 4, 4,-1, 4, 4, 4, /* 0,0,'髢','髣',0,0,'髦',0, 0,0,'髪','髫',0,'髭','髮','髯', */
	/* 9af0 */ -1, 4,-1,-1, 4,-1,-1, 4, -1,-1,-1, 4,0,0,0,0, /* 0,'髱',0,0,'髴',0,0,'髷', 0,0,0,'髻',0,0,0,0, */
	/* 9b00 */ -1,-1,-1,-1,-1,-1, 4,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'鬆',0, 0,0,0,0,0,0,0,0, */
	/* 9b10 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1, 4,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, '鬘',0,'鬚',0,0,0,0,'鬟', */
	/* 9b20 */ -1,-1, 4, 4,-1, 4,-1, 4,  4, 4, 4,-1,-1,-1, 4, 4, /* 0,0,'鬢','鬣',0,'鬥',0,'鬧', '鬨','鬩','鬪',0,0,0,'鬮','鬯', */
	/* 9b30 */ -1, 4, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,0,0,0, /* 0,'鬱','鬲',0,0,0,0,0, 0,0,0,'鬻','鬼',0,0,0, */
	/* 9b40 */ -1, 4, 4, 4, 4, 4,-1,-1, -1,-1,-1,-1,-1, 4, 4, 4, /* 0,'魁','魂','魃','魄','魅',0,0, 0,0,0,0,0,'魍','魎','魏', */
	/* 9b50 */ -1, 4,-1,-1, 4,-1,-1,-1,  4,-1, 4,0,0,0,0,0, /* 0,'魑',0,0,'魔',0,0,0, '魘',0,'魚',0,0,0,0,0, */
	/* 9b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'魯', */
	/* 9b70 */ -1,-1,-1,-1, 4,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'魴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9b80 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,'鮃',0,0,0,0, 0,0,0,0,0,0,'鮎',0, */
	/* 9b90 */ -1, 4, 4, 4,-1,-1, 4, 4, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,'鮑','鮒','鮓',0,0,'鮖','鮗', 0,0,0,0,0,0,0,'鮟', */
	/* 9ba0 */  4,-1,-1,-1,-1,-1,-1,-1,  4,-1, 4, 4,-1, 4, 4,0, /* '鮠',0,0,0,0,0,0,0, '鮨',0,'鮪','鮫',0,'鮭','鮮',0, */
	/* 9bb0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,0,'鮴',0,0,0, 0,'鮹',0,0,0,0,0,0, */
	/* 9bc0 */  4,-1,-1,-1,-1,-1, 4,-1, -1, 4, 4,-1,-1,-1,-1, 4, /* '鯀',0,0,0,0,0,'鯆',0, 0,'鯉','鯊',0,0,0,0,'鯏', */
	/* 9bd0 */ -1, 4, 4,-1, 4,-1, 4,-1, -1,-1,-1, 4,0,0,0,0, /* 0,'鯑','鯒',0,'鯔',0,'鯖',0, 0,0,0,'鯛',0,0,0,0, */
	/* 9be0 */ -1, 4, 4, 4, 4,-1,-1,-1,  4,0,0,0,0,0,0,0, /* 0,'鯡','鯢','鯣','鯤',0,0,0, '鯨',0,0,0,0,0,0,0, */
	/* 9bf0 */  4, 4, 4,-1,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* '鯰','鯱','鯲',0,0,'鯵',0,0, 0,0,0,0,0,0,0,0, */
	/* 9c00 */ -1,-1,-1,-1, 4,-1, 4,-1,  4, 4, 4,-1, 4, 4,0,0, /* 0,0,0,0,'鰄',0,'鰆',0, '鰈','鰉','鰊',0,'鰌','鰍',0,0, */
	/* 9c10 */  4,-1, 4, 4, 4, 4,-1,-1, -1,-1,-1, 4,0,0,0,0, /* '鰐',0,'鰒','鰓','鰔','鰕',0,0, 0,0,0,'鰛',0,0,0,0, */
	/* 9c20 */ -1, 4,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1, 4, 4, 4, /* 0,'鰡',0,0,'鰤','鰥',0,0, 0,0,0,0,0,'鰭','鰮','鰯', */
	/* 9c30 */  4,-1, 4,-1,-1,-1,-1,-1, -1, 4, 4, 4,-1,-1, 4,0, /* '鰰',0,'鰲',0,0,0,0,0, 0,'鰹','鰺','鰻',0,0,'鰾',0, */
	/* 9c40 */ -1,-1,-1,-1,-1,-1, 4, 4,  4,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'鱆','鱇', '鱈',0,0,0,0,0,0,0, */
	/* 9c50 */ -1,-1, 4,-1,-1,-1,-1, 4, -1,-1, 4,0,0,0,0,0, /* 0,0,'鱒',0,0,0,0,'鱗', 0,0,'鱚',0,0,0,0,0, */
	/* 9c60 */  4,-1,-1,-1,-1,-1,-1, 4, 0,0,0,0,0,0,0,0, /* '鱠',0,0,0,0,0,0,'鱧', 0,0,0,0,0,0,0,0, */
	/* 9c70 */ -1,-1,-1,-1,-1,-1, 4,-1,  4,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'鱶',0, '鱸',0,0,0,0,0,0,0, */
	/* 9c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ce0 */ -1,-1,-1,-1,-1, 4,-1, 4, -1, 4,-1, 4, 4,0,0,0, /* 0,0,0,0,0,'鳥',0,'鳧', 0,'鳩',0,'鳫','鳬',0,0,0, */
	/* 9cf0 */  4,-1,-1, 4, 4,-1, 4,0, 0,0,0,0,0,0,0,0, /* '鳰',0,0,'鳳','鳴',0,'鳶',0, 0,0,0,0,0,0,0,0, */
	/* 9d00 */ -1,-1,-1, 4,-1,-1, 4, 4,  4, 4,-1,-1,-1,-1, 4,0, /* 0,0,0,'鴃',0,0,'鴆','鴇', '鴈','鴉',0,0,0,0,'鴎',0, */
	/* 9d10 */ -1,-1, 4,-1,-1, 4,-1,-1, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,0,'鴒',0,0,'鴕',0,0, 0,0,0,'鴛',0,0,0,'鴟', */
	/* 9d20 */ -1,-1,-1, 4,-1,-1, 4,-1,  4,-1, 4, 4, 4,0,0,0, /* 0,0,0,'鴣',0,0,'鴦',0, '鴨',0,'鴪','鴫','鴬',0,0,0, */
	/* 9d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,'鴻',0,0,'鴾','鴿', */
	/* 9d40 */ -1, 4,-1,-1, 4,-1, 4,-1,  4,0,0,0,0,0,0,0, /* 0,'鵁',0,0,'鵄',0,'鵆',0, '鵈',0,0,0,0,0,0,0, */
	/* 9d50 */  4, 4,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1, 4, 4, 4,0, /* '鵐','鵑',0,0,0,0,0,0, 0,'鵙',0,0,'鵜','鵝','鵞',0, */
	/* 9d60 */  4, 4,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* '鵠','鵡',0,0,'鵤',0,0,0, 0,0,0,0,'鵬',0,0,'鵯', */
	/* 9d70 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,0,'鵲',0,0,0,0,0, 0,0,'鵺',0,0,0,0,0, */
	/* 9d80 */ -1,-1,-1,-1,-1,-1,-1, 4, -1, 4,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,'鶇', 0,'鶉',0,0,0,0,0,'鶏', */
	/* 9d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'鶚',0,0,0,0,0, */
	/* 9da0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1, 4,-1, 4,-1,-1,-1, 4, /* 0,0,0,0,'鶤',0,0,0, 0,'鶩',0,'鶫',0,0,0,'鶯', */
	/* 9db0 */ -1,-1, 4,-1, 4,-1,-1,-1,  4,-1, 4, 4,0,0,0,0, /* 0,0,'鶲',0,'鶴',0,0,0, '鶸',0,'鶺','鶻',0,0,0,0, */
	/* 9dc0 */ -1, 4, 4,-1, 4,-1, 4,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,'鷁','鷂',0,'鷄',0,'鷆',0, 0,0,0,0,0,0,0,'鷏', */
	/* 9dd0 */ -1,-1,-1, 4,-1,-1,-1,-1, -1, 4,0,0,0,0,0,0, /* 0,0,0,'鷓',0,0,0,0, 0,'鷙',0,0,0,0,0,0, */
	/* 9de0 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1, 4,-1, 4, /* 0,0,0,0,0,0,'鷦',0, 0,0,0,0,0,'鷭',0,'鷯', */
	/* 9df0 */ -1,-1, 4,-1,-1,-1,-1,-1,  4, 4, 4,-1,-1, 4,0,0, /* 0,0,'鷲',0,0,0,0,0, '鷸','鷹','鷺',0,0,'鷽',0,0, */
	/* 9e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,'鸚','鸛',0,0,'鸞',0, */
	/* 9e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e70 */ -1,-1,-1,-1,-1, 4,-1,-1,  4, 4,-1,-1,-1, 4,-1, 4, /* 0,0,0,0,0,'鹵',0,0, '鹸','鹹',0,0,0,'鹽',0,'鹿', */
	/* 9e80 */ -1, 4,-1,-1,-1,-1,-1,-1,  4,-1,-1, 4, 4,0,0,0, /* 0,'麁',0,0,0,0,0,0, '麈',0,0,'麋','麌',0,0,0, */
	/* 9e90 */ -1, 4, 4, 4,-1, 4,-1, 4, -1,-1,-1,-1,-1, 4,-1, 4, /* 0,'麑','麒','麓',0,'麕',0,'麗', 0,0,0,0,0,'麝',0,'麟', */
	/* 9ea0 */ -1,-1,-1,-1,-1, 4, 4,-1, -1, 4, 4,-1,-1, 4,0,0, /* 0,0,0,0,0,'麥','麦',0, 0,'麩','麪',0,0,'麭',0,0, */
	/* 9eb0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4, 4, 4, 4, 4,-1, 4, 4, /* 0,0,0,0,0,0,0,0, '麸','麹','麺','麻','麼',0,'麾','麿', */
	/* 9ec0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1, 4, 4, 4, 4, /* 0,0,0,0,'黄',0,0,0, 0,0,0,0,'黌','黍','黎','黏', */
	/* 9ed0 */  4,-1, 4,-1, 4,-1,-1,-1,  4, 4,-1, 4, 4, 4, 4,0, /* '黐',0,'黒',0,'黔',0,0,0, '默','黙',0,'黛','黜','黝','點',0, */
	/* 9ee0 */  4,-1,-1,-1,-1, 4,-1,-1,  4,-1,-1,-1,-1,-1,-1, 4, /* '黠',0,0,0,0,'黥',0,0, '黨',0,0,0,0,0,0,'黯', */
	/* 9ef0 */ -1,-1,-1,-1, 4,-1, 4, 4, -1, 4,-1, 4, 4, 4,0,0, /* 0,0,0,0,'黴',0,'黶','黷', 0,'黹',0,'黻','黼','黽',0,0, */
	/* 9f00 */ -1,-1,-1,-1,-1,-1,-1, 4,  4,-1,-1,-1,-1,-1, 4,0, /* 0,0,0,0,0,0,0,'鼇', '鼈',0,0,0,0,0,'鼎',0, */
	/* 9f10 */ -1,-1,-1, 4,-1, 4,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'鼓',0,'鼕',0,0, 0,0,0,0,0,0,0,0, */
	/* 9f20 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4,0,0,0, /* '鼠','鼡',0,0,0,0,0,0, 0,0,0,0,'鼬',0,0,0, */
	/* 9f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 4,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'鼻',0,0,'鼾',0, */
	/* 9f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4, 4,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,'齊','齋',0,0,'齎','齏', */
	/* 9f50 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,'齒',0,'齔',0,0,0, 0,0,0,0,0,0,0,'齟', */
	/* 9f60 */  4, 4, 4, 4,-1,-1, 4, 4, -1,-1, 4,-1, 4,0,0,0, /* '齠','齡','齢','齣',0,0,'齦','齧', 0,0,'齪',0,'齬',0,0,0, */
	/* 9f70 */ -1,-1, 4,-1,-1,-1, 4, 4, 0,0,0,0,0,0,0,0, /* 0,0,'齲',0,0,0,'齶','齷', 0,0,0,0,0,0,0,0, */
	/* 9f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'龍',0,0, */
	/* 9f90 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1, 4, 4,0,0, /* 0,0,0,0,0,'龕',0,0, 0,0,0,0,'龜','龝',0,0, */
	/* 9fa0 */  4,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '龠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aaa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aaf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ace0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ada0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* adb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* adc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* add0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ade0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* adf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aeb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* baa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* baf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* beb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* caa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* caf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ceb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ced0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* daa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* daf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* deb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ded0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* def0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eaa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ead0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eaf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ece0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ede0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eeb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* faa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* faf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* feb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ff00 */ -1, 4,-1, 4, 4, 4, 4,-1,  4, 4, 4, 4, 4,-1, 4, 4, /* 0,'！',0,'＃','＄','％','＆',0, '（','）','＊','＋','，',0,'．','／', */
	/* ff10 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '０','１','２','３','４','５','６','７', '８','９','：','；','＜','＝','＞','？', */
	/* ff20 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '＠','Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ', 'Ｈ','Ｉ','Ｊ','Ｋ','Ｌ','Ｍ','Ｎ','Ｏ', */
	/* ff30 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'Ｐ','Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ', 'Ｘ','Ｙ','Ｚ','［','＼','］','＾','＿', */
	/* ff40 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '｀','ａ','ｂ','ｃ','ｄ','ｅ','ｆ','ｇ', 'ｈ','ｉ','ｊ','ｋ','ｌ','ｍ','ｎ','ｏ', */
	/* ff50 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4,0,0, /* 'ｐ','ｑ','ｒ','ｓ','ｔ','ｕ','ｖ','ｗ', 'ｘ','ｙ','ｚ','｛','｜','｝',0,0, */
	/* ff60 */ -1, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* ff70 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* ff80 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* ff90 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
	/* ffa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffe0 */ -1,-1,-1, 4,-1, 4, /* 0,0,0,'￣',0,'￥', */
};

const size_t _unibe2jis2022jp_table_bits_size = sizeof(_unibe2jis2022jp_table_bits) / sizeof(_unibe2jis2022jp_table_bits[0]);

#endif /* #ifndef __UNIBE2JIS2022_JP_TABLE_BITS_H_ */
