/*
 * _unibe2jis50221_table.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __UNIBE2JIS50221_TABLE_BITS_H_
#define __UNIBE2JIS50221_TABLE_BITS_H_

#include <stddef.h>

const char _unibe2jis50221_table_bits[] = {
	/* 0000 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	/* 0010 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	/* 0020 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* ' ','!','"','#','$','%','&','\'', '(',')','*','+',',','-','.','/', */
	/* 0030 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* '0','1','2','3','4','5','6','7', '8','9',':',';','<','=','>','?', */
	/* 0040 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O', */
	/* 0050 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* 'P','Q','R','S','T','U','V','W', 'X','Y','Z','[','\\',']','^','_', */
	/* 0060 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* '`','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o', */
	/* 0070 */  0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, /* 'p','q','r','s','t','u','v','w', 'x','y','z','{','|','}','~','', */
	/* 0080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 00a0 */ -1, 6, 4, 4, 6, 2, 6, 4,  4, 6, 6,-1, 4,-1, 6, 6, /* 0,'¡','¢','£','¤','¥','¦','§', '¨','©','ª',0,'¬',0,'®','¯', */
	/* 00b0 */  4, 4,-1,-1, 4,-1, 4,-1,  6,-1, 6,-1,-1,-1,-1, 6, /* '°','±',0,0,'´',0,'¶',0, '¸',0,'º',0,0,0,0,'¿', */
	/* 00c0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* 'À','Á','Â','Ã','Ä','Å','Æ','Ç', 'È','É','Ê','Ë','Ì','Í','Î','Ï', */
	/* 00d0 */ -1, 6, 6, 6, 6, 6, 6, 4,  6, 6, 6, 6, 6, 6, 6, 6, /* 0,'Ñ','Ò','Ó','Ô','Õ','Ö','×', 'Ø','Ù','Ú','Û','Ü','Ý','Þ','ß', */
	/* 00e0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* 'à','á','â','ã','ä','å','æ','ç', 'è','é','ê','ë','ì','í','î','ï', */
	/* 00f0 */  6, 6, 6, 6, 6, 6, 6, 4,  6, 6, 6, 6, 6, 6, 6, 6, /* 'ð','ñ','ò','ó','ô','õ','ö','÷', 'ø','ù','ú','û','ü','ý','þ','ÿ', */
	/* 0100 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* 'Ā','ā','Ă','ă','Ą','ą','Ć','ć', 'Ĉ','ĉ','Ċ','ċ','Č','č','Ď','ď', */
	/* 0110 */  6, 6, 6, 6,-1,-1, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* 'Đ','đ','Ē','ē',0,0,'Ė','ė', 'Ę','ę','Ě','ě','Ĝ','ĝ','Ğ','ğ', */
	/* 0120 */  6, 6, 6,-1, 6, 6, 6, 6,  6, 6, 6, 6,-1,-1, 6, 6, /* 'Ġ','ġ','Ģ',0,'Ĥ','ĥ','Ħ','ħ', 'Ĩ','ĩ','Ī','ī',0,0,'Į','į', */
	/* 0130 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* 'İ','ı','Ĳ','ĳ','Ĵ','ĵ','Ķ','ķ', 'ĸ','Ĺ','ĺ','Ļ','ļ','Ľ','ľ','Ŀ', */
	/* 0140 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6,-1,-1, /* 'ŀ','Ł','ł','Ń','ń','Ņ','ņ','Ň', 'ň','ŉ','Ŋ','ŋ','Ō','ō',0,0, */
	/* 0150 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* 'Ő','ő','Œ','œ','Ŕ','ŕ','Ŗ','ŗ', 'Ř','ř','Ś','ś','Ŝ','ŝ','Ş','ş', */
	/* 0160 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* 'Š','š','Ţ','ţ','Ť','ť','Ŧ','ŧ', 'Ũ','ũ','Ū','ū','Ŭ','ŭ','Ů','ů', */
	/* 0170 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6,-1, /* 'Ű','ű','Ų','ų','Ŵ','ŵ','Ŷ','ŷ', 'Ÿ','Ź','ź','Ż','ż','Ž','ž',0, */
	/* 0180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 6, 6, 6, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'Ǎ','ǎ','Ǐ', */
	/* 01d0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6,-1,-1,-1, /* 'ǐ','Ǒ','ǒ','Ǔ','ǔ','Ǖ','ǖ','Ǘ', 'ǘ','Ǚ','ǚ','Ǜ','ǜ',0,0,0, */
	/* 01e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 01f0 */ -1,-1,-1,-1,-1, 6,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'ǵ',0,0, 0,0,0,0,0,0,0,0, */
	/* 0200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02c0 */ -1,-1,-1,-1,-1,-1,-1, 6, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,'ˇ', 0,0,0,0,0,0,0,0, */
	/* 02d0 */ -1,-1,-1,-1,-1,-1,-1,-1,  6, 6, 6, 6,-1, 6,-1,-1, /* 0,0,0,0,0,0,0,0, '˘','˙','˚','˛',0,'˝',0,0, */
	/* 02e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 02f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0380 */ -1,-1,-1,-1, 6, 6, 6,-1,  6, 6, 6,-1, 6,-1, 6, 6, /* 0,0,0,0,'΄','΅','Ά',0, 'Έ','Ή','Ί',0,'Ό',0,'Ύ','Ώ', */
	/* 0390 */  6, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ΐ','Α','Β','Γ','Δ','Ε','Ζ','Η', 'Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο', */
	/* 03a0 */  4, 4,-1, 4, 4, 4, 4, 4,  4, 4, 6, 6, 6, 6, 6, 6, /* 'Π','Ρ',0,'Σ','Τ','Υ','Φ','Χ', 'Ψ','Ω','Ϊ','Ϋ','ά','έ','ή','ί', */
	/* 03b0 */  6, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ΰ','α','β','γ','δ','ε','ζ','η', 'θ','ι','κ','λ','μ','ν','ξ','ο', */
	/* 03c0 */  4, 4, 6, 4, 4, 4, 4, 4,  4, 4, 6, 6, 6, 6, 6,-1, /* 'π','ρ','ς','σ','τ','υ','φ','χ', 'ψ','ω','ϊ','ϋ','ό','ύ','ώ',0, */
	/* 03d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 03f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0400 */ -1, 4, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6,-1, 6, 6, /* 0,'Ё','Ђ','Ѓ','Є','Ѕ','І','Ї', 'Ј','Љ','Њ','Ћ','Ќ',0,'Ў','Џ', */
	/* 0410 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'А','Б','В','Г','Д','Е','Ж','З', 'И','Й','К','Л','М','Н','О','П', */
	/* 0420 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'Р','С','Т','У','Ф','Х','Ц','Ч', 'Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я', */
	/* 0430 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'а','б','в','г','д','е','ж','з', 'и','й','к','л','м','н','о','п', */
	/* 0440 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'р','с','т','у','ф','х','ц','ч', 'ш','щ','ъ','ы','ь','э','ю','я', */
	/* 0450 */ -1, 4, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6,-1, 6, 6, /* 0,'ё','ђ','ѓ','є','ѕ','і','ї', 'ј','љ','њ','ћ','ќ',0,'ў','џ', */
	/* 0460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 04f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 05f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 06f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 07f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 08f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 09f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 0ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 10f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 11f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 12f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 13f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 14f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 15f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 16f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 17f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 18f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 19f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 1ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2010 */  4,-1,-1,-1,-1, 4, 4,-1,  4, 4,-1,-1, 4, 4,-1,-1, /* '‐',0,0,0,0,'―','‖',0, '‘','’',0,0,'“','”',0,0, */
	/* 2020 */  4, 4,-1,-1,-1, 4, 4,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '†','‡',0,0,0,'‥','…',0, 0,0,0,0,0,0,0,0, */
	/* 2030 */  4,-1, 4, 4,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 2,-1, /* '‰',0,'′','″',0,0,0,0, 0,0,0,'※',0,0,'‾',0, */
	/* 2040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 20f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2100 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,'℃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2110 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,'№',0, 0,0,0,0,0,0,0,0, */
	/* 2120 */ -1, 4, 6,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1,-1,-1, /* 0,'℡','™',0,0,0,0,0, 0,0,0,'Å',0,0,0,0, */
	/* 2130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2160 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4,-1,-1,-1,-1,-1,-1, /* 'Ⅰ','Ⅱ','Ⅲ','Ⅳ','Ⅴ','Ⅵ','Ⅶ','Ⅷ', 'Ⅸ','Ⅹ',0,0,0,0,0,0, */
	/* 2170 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6,-1,-1,-1,-1,-1,-1, /* 'ⅰ','ⅱ','ⅲ','ⅳ','ⅴ','ⅵ','ⅶ','ⅷ', 'ⅸ','ⅹ',0,0,0,0,0,0, */
	/* 2180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2190 */  4, 4, 4, 4,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '←','↑','→','↓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21d0 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'⇒',0,'⇔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 21f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2200 */  4,-1, 4, 4,-1,-1,-1, 4,  4,-1,-1, 4,-1,-1,-1,-1, /* '∀',0,'∂','∃',0,0,0,'∇', '∈',0,0,'∋',0,0,0,0, */
	/* 2210 */ -1, 4, 4,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4, 4, 4, /* 0,'∑','−',0,0,0,0,0, 0,0,'√',0,0,'∝','∞','∟', */
	/* 2220 */  4,-1,-1,-1,-1, 4,-1, 4,  4, 4, 4, 4, 4,-1, 4,-1, /* '∠',0,0,0,0,'∥',0,'∧', '∨','∩','∪','∫','∬',0,'∮',0, */
	/* 2230 */ -1,-1,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1, 4,-1,-1, /* 0,0,0,0,'∴','∵',0,0, 0,0,0,0,0,'∽',0,0, */
	/* 2240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2250 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'≒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2260 */  4, 4,-1,-1,-1,-1, 4, 4, -1,-1, 4, 4,-1,-1,-1,-1, /* '≠','≡',0,0,0,0,'≦','≧', 0,0,'≪','≫',0,0,0,0, */
	/* 2270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2280 */ -1,-1, 4, 4,-1,-1, 4, 4, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'⊂','⊃',0,0,'⊆','⊇', 0,0,0,0,0,0,0,0, */
	/* 2290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22a0 */ -1,-1,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'⊥',0,0, 0,0,0,0,0,0,0,0, */
	/* 22b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'⊿', */
	/* 22c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 22f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2310 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'⌒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 23f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2460 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '①','②','③','④','⑤','⑥','⑦','⑧', '⑨','⑩','⑪','⑫','⑬','⑭','⑮','⑯', */
	/* 2470 */  4, 4, 4, 4,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '⑰','⑱','⑲','⑳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 24f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2500 */  4, 4, 4, 4,-1,-1,-1,-1, -1,-1,-1,-1, 4,-1,-1, 4, /* '─','━','│','┃',0,0,0,0, 0,0,0,0,'┌',0,0,'┏', */
	/* 2510 */  4,-1,-1, 4, 4,-1,-1, 4,  4,-1,-1, 4, 4, 4,-1,-1, /* '┐',0,0,'┓','└',0,0,'┗', '┘',0,0,'┛','├','┝',0,0, */
	/* 2520 */  4,-1,-1, 4, 4, 4,-1,-1,  4,-1,-1, 4, 4,-1,-1, 4, /* '┠',0,0,'┣','┤','┥',0,0, '┨',0,0,'┫','┬',0,0,'┯', */
	/* 2530 */  4,-1,-1, 4, 4,-1,-1, 4,  4,-1,-1, 4, 4,-1,-1, 4, /* '┰',0,0,'┳','┴',0,0,'┷', '┸',0,0,'┻','┼',0,0,'┿', */
	/* 2540 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1,-1,-1, /* 0,0,'╂',0,0,0,0,0, 0,0,0,'╋',0,0,0,0, */
	/* 2550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25a0 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '■','□',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25b0 */ -1,-1, 4, 4,-1,-1,-1,-1, -1,-1,-1,-1, 4, 4,-1,-1, /* 0,0,'▲','△',0,0,0,0, 0,0,0,0,'▼','▽',0,0, */
	/* 25c0 */ -1,-1,-1,-1,-1,-1, 4, 4, -1,-1,-1, 4,-1,-1, 4, 4, /* 0,0,0,0,0,0,'◆','◇', 0,0,0,'○',0,0,'◎','●', */
	/* 25d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 25e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'◯', */
	/* 25f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2600 */ -1,-1,-1,-1,-1, 4, 4,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'★','☆',0, 0,0,0,0,0,0,0,0, */
	/* 2610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2640 */  4,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '♀',0,'♂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1, 4,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,'♪',0,0,'♭',0,'♯', */
	/* 2670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 26f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 27f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 28f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 29f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 2ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3000 */  4, 4, 4, 4,-1, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '　','、','。','〃',0,'々','〆','〇', '〈','〉','《','》','「','」','『','』', */
	/* 3010 */  4, 4, 4, 4, 4, 4,-1,-1, -1,-1,-1,-1, 4, 4,-1, 4, /* '【','】','〒','〓','〔','〕',0,0, 0,0,0,0,'〜','〞',0,'〟', */
	/* 3020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3040 */ -1, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'ぁ','あ','ぃ','い','ぅ','う','ぇ', 'え','ぉ','お','か','が','き','ぎ','く', */
	/* 3050 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ぐ','け','げ','こ','ご','さ','ざ','し', 'じ','す','ず','せ','ぜ','そ','ぞ','た', */
	/* 3060 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'だ','ち','ぢ','っ','つ','づ','て','で', 'と','ど','な','に','ぬ','ね','の','は', */
	/* 3070 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ば','ぱ','ひ','び','ぴ','ふ','ぶ','ぷ', 'へ','べ','ぺ','ほ','ぼ','ぽ','ま','み', */
	/* 3080 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'む','め','も','ゃ','や','ゅ','ゆ','ょ', 'よ','ら','り','る','れ','ろ','ゎ','わ', */
	/* 3090 */  4, 4, 4, 4,-1,-1,-1,-1, -1,-1,-1, 4, 4, 4, 4,-1, /* 'ゐ','ゑ','を','ん',0,0,0,0, 0,0,0,'゛','゜','ゝ','ゞ',0, */
	/* 30a0 */ -1, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'ァ','ア','ィ','イ','ゥ','ウ','ェ', 'エ','ォ','オ','カ','ガ','キ','ギ','ク', */
	/* 30b0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'グ','ケ','ゲ','コ','ゴ','サ','ザ','シ', 'ジ','ス','ズ','セ','ゼ','ソ','ゾ','タ', */
	/* 30c0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ダ','チ','ヂ','ッ','ツ','ヅ','テ','デ', 'ト','ド','ナ','ニ','ヌ','ネ','ノ','ハ', */
	/* 30d0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'バ','パ','ヒ','ビ','ピ','フ','ブ','プ', 'ヘ','ベ','ペ','ホ','ボ','ポ','マ','ミ', */
	/* 30e0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'ム','メ','モ','ャ','ヤ','ュ','ユ','ョ', 'ヨ','ラ','リ','ル','レ','ロ','ヮ','ワ', */
	/* 30f0 */  4, 4, 4, 4, 4, 4, 4,-1, -1,-1,-1, 4, 4, 4, 4,-1, /* 'ヰ','ヱ','ヲ','ン','ヴ','ヵ','ヶ',0, 0,0,0,'・','ー','ヽ','ヾ',0, */
	/* 3100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 31f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3230 */ -1, 4, 4,-1,-1,-1,-1,-1, -1, 4,-1,-1,-1,-1,-1,-1, /* 0,'㈱','㈲',0,0,0,0,0, 0,'㈹',0,0,0,0,0,0, */
	/* 3240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32a0 */ -1,-1,-1,-1, 4, 4, 4, 4,  4,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'㊤','㊥','㊦','㊧', '㊨',0,0,0,0,0,0,0, */
	/* 32b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 32f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3300 */ -1,-1,-1, 4,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,-1,-1, /* 0,0,0,'㌃',0,0,0,0, 0,0,0,0,0,'㌍',0,0, */
	/* 3310 */ -1,-1,-1,-1, 4,-1,-1,-1,  4,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'㌔',0,0,0, '㌘',0,0,0,0,0,0,0, */
	/* 3320 */ -1,-1, 4, 4,-1,-1, 4, 4, -1,-1,-1, 4,-1,-1,-1,-1, /* 0,0,'㌢','㌣',0,0,'㌦','㌧', 0,0,0,'㌫',0,0,0,0, */
	/* 3330 */ -1,-1,-1,-1,-1,-1, 4,-1, -1,-1,-1, 4,-1,-1,-1,-1, /* 0,0,0,0,0,0,'㌶',0, 0,0,0,'㌻',0,0,0,0, */
	/* 3340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4, 4,-1,-1, 4,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'㍉','㍊',0,0,'㍍',0,0, */
	/* 3350 */ -1, 4,-1,-1,-1,-1,-1, 4, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'㍑',0,0,0,0,0,'㍗', 0,0,0,0,0,0,0,0, */
	/* 3360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4, 4, 4,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'㍻','㍼','㍽','㍾',0, */
	/* 3380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㎎','㎏', */
	/* 3390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4, 4, 4,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㎜','㎝','㎞',0, */
	/* 33a0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'㎡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 33b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33c0 */ -1,-1,-1,-1, 4,-1,-1,-1, -1,-1,-1,-1,-1, 4,-1,-1, /* 0,0,0,0,'㏄',0,0,0, 0,0,0,0,0,'㏍',0,0, */
	/* 33d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 33f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 34f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 35f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 36f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 37f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 38f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 39f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3e90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 3ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 40f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 41f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 42f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 43f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 44f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 45f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 46f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 47f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 48f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 49f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4aa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4af0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4b90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4ce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4cf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4d90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4db0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4dc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4dd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4de0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4df0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 4e00 */  4, 4, 6, 4, 6, 6,-1, 4,  4, 4, 4, 4, 6, 4, 4,-1, /* '一','丁','丂','七','丄','丅',0,'万', '丈','三','上','下','丌','不','与',0, */
	/* 4e10 */  4, 4, 6,-1, 4, 4, 4, 4,  4, 4,-1,-1,-1,-1, 4, 6, /* '丐','丑','丒',0,'且','丕','世','丗', '丘','丙',0,0,0,0,'丞','丟', */
	/* 4e20 */ -1, 4,-1, 6, 6,-1, 4,-1,  6,-1, 4, 6,-1, 4, 6, 6, /* 0,'両',0,'丣','两',0,'並',0, '丨',0,'个','丫',0,'中','丮','丯', */
	/* 4e30 */  6, 4, 4,-1,-1, 6, 4,-1,  4, 4,-1, 4, 4,-1,-1, 4, /* '丰','丱','串',0,0,'丵','丶',0, '丸','丹',0,'主','丼',0,0,'丿', */
	/* 4e40 */  6, 6, 4, 4, 6, 4,-1, 6, -1,-1,-1, 4,-1, 4, 4, 4, /* '乀','乁','乂','乃','乄','久',0,'乇', 0,0,0,'之',0,'乍','乎','乏', */
	/* 4e50 */ -1, 6,-1,-1,-1, 4, 4, 4,  4, 4, 6,-1, 6, 4, 4, 4, /* 0,'乑',0,0,0,'乕','乖','乗', '乘','乙','乚',0,'乜','九','乞','也', */
	/* 4e60 */ -1,-1, 4, 6,-1,-1,-1,-1,  6, 6,-1,-1,-1,-1,-1,-1, /* 0,0,'乢','乣',0,0,0,0, '乨','乩',0,0,0,0,0,0, */
	/* 4e70 */ -1, 4,-1, 4, 6, 6,-1,-1, -1, 6,-1,-1,-1,-1, 4, 6, /* 0,'乱',0,'乳','乴','乵',0,0, 0,'乹',0,0,0,0,'乾','乿', */
	/* 4e80 */  4,-1, 4,-1,-1, 4, 4,-1,  4, 4, 4, 4, 4, 6, 4,-1, /* '亀',0,'亂',0,0,'亅','了',0, '予','争','亊','事','二','亍','于',0, */
	/* 4e90 */ -1, 4, 4,-1, 4, 4, 6, 6,  4, 4,-1, 4, 4, 6, 4, 4, /* 0,'云','互',0,'五','井','亖','亗', '亘','亙',0,'些','亜','亝','亞','亟', */
	/* 4ea0 */  4, 4, 4,-1, 4, 4, 4,-1,  4,-1,-1, 4, 4, 4, 4, 6, /* '亠','亡','亢',0,'交','亥','亦',0, '亨',0,0,'享','京','亭','亮','亯', */
	/* 4eb0 */  4,-1,-1, 4,-1,-1, 4,-1, -1, 6, 4,-1,-1,-1,-1,-1, /* '亰',0,0,'亳',0,0,'亶',0, 0,'亹','人',0,0,0,0,0, */
	/* 4ec0 */  4, 4, 4, 6, 4,-1, 4, 4, -1,-1, 4, 4,-1, 4, 4, 4, /* '什','仁','仂','仃','仄',0,'仆','仇', 0,0,'今','介',0,'仍','从','仏', */
	/* 4ed0 */  6,-1,-1,-1, 4, 4, 4, 4,  4, 4, 6, 6,-1, 4, 4, 4, /* '仐',0,0,0,'仔','仕','他','仗', '付','仙','仚','仛',0,'仝','仞','仟', */
	/* 4ee0 */  6, 6, 6, 4, 4, 4,-1,-1,  6,-1,-1,-1,-1, 4, 4, 6, /* '仠','仡','仢','代','令','以',0,0, '仨',0,0,0,0,'仭','仮','仯', */
	/* 4ef0 */  4, 6, 4, 6,-1, 6, 4, 4, -1,-1,-1, 4, 6, 6, 6, 6, /* '仰','仱','仲','仳',0,'仵','件','价', 0,0,0,'任','仼','份','仾','仿', */
	/* 4f00 */  6, 4, 6, 6,-1,-1,-1,-1,  6, 4, 4, 6, 6, 4, 4, 4, /* '伀','企','伂','伃',0,0,0,0, '伈','伉','伊','伋','伌','伍','伎','伏', */
	/* 4f10 */  4, 4, 6,-1,-1, 6, 6, 6, -1, 6, 4,-1, 4, 4,-1,-1, /* '伐','休','伒',0,0,'伕','伖','众', 0,'伙','会',0,'伜','伝',0,0, */
	/* 4f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 6, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'伮','伯', */
	/* 4f30 */  4, 6,-1, 6, 4, 6, 4, 6,  4, 6, 4, 6, 4, 4, 6,-1, /* '估','伱',0,'伳','伴','伵','伶','伷', '伸','伹','伺','伻','似','伽','伾',0, */
	/* 4f40 */  6,-1, 6, 4,-1,-1, 4, 4,  6, 6,-1, 6, 6, 4, 4, 4, /* '佀',0,'佂','佃',0,0,'但','佇', '佈','佉',0,'佋','佌','位','低','住', */
	/* 4f50 */  4, 4, 6, 4, 6, 4, 6, 4,  6, 4, 4, 4, 4, 4, 4, 6, /* '佐','佑','佒','体','佔','何','佖','佗', '佘','余','佚','佛','作','佝','佞','佟', */
	/* 4f60 */  6,-1,-1, 6,-1,-1,-1,-1, -1, 4, 6,-1, 6,-1, 6, 4, /* '你',0,0,'佣',0,0,0,0, 0,'佩','佪',0,'佬',0,'佮','佯', */
	/* 4f70 */  4, 6,-1, 4,-1, 4, 4, 6,  6, 6, 6, 4, 4, 6, 6, 4, /* '佰','佱',0,'佳',0,'併','佶','佷', '佸','佹','佺','佻','佼','佽','佾','使', */
	/* 4f80 */ -1, 6, 6, 4, 6, 6, 4,-1,  4, 6, 6, 4, 6, 4, 6, 4, /* 0,'侁','侂','侃','侄','侅','來',0, '侈','侉','侊','例','侌','侍','侎','侏', */
	/* 4f90 */  6, 4, 6, 6, 6,-1, 4, 6,  4, 6, 6, 4,-1, 4, 6, 6, /* '侐','侑','侒','侓','侔',0,'侖','侗', '侘','侙','侚','供',0,'依','侞','侟', */
	/* 4fa0 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1, 4, 4, 4, /* '侠','価',0,0,0,0,0,0, 0,0,0,'侫',0,'侭','侮','侯', */
	/* 4fb0 */ -1,-1, 6,-1,-1, 4, 4, 6, -1, 6,-1, 6, 6, 6, 6, 4, /* 0,0,'侲',0,0,'侵','侶','侷', 0,'侹',0,'侻','侼','侽','侾','便', */
	/* 4fc0 */  6, 6, 4, 4, 4, 6, 6,-1,  6, 6, 4, 6, 6, 6, 4, 6, /* '俀','俁','係','促','俄','俅','俆',0, '俈','俉','俊','俋','俌','俍','俎','俏', */
	/* 4fd0 */  4, 4, 6,-1, 4,-1,-1, 4,  4,-1, 4, 4, 6, 4,-1, 4, /* '俐','俑','俒',0,'俔',0,0,'俗', '俘',0,'俚','俛','俜','保',0,'俟', */
	/* 4fe0 */  6, 4, 6, 4, 4, 4,-1,-1, -1,-1,-1,-1,-1,-1, 4, 4, /* '俠','信','俢','俣','俤','俥',0,0, 0,0,0,0,0,0,'修','俯', */
	/* 4ff0 */  6,-1, 6, 4,-1, 4, 4,-1,  4,-1, 4,-1, 6, 6, 4, 6, /* '俰',0,'俲','俳',0,'俵','俶',0, '俸',0,'俺',0,'俼','俽','俾','俿', */
	/* 5000 */  6, 6,-1,-1, 6, 4, 4, 6, -1, 4, 6, 4, 6, 4, 6, 4, /* '倀','倁',0,0,'倄','倅','倆','倇', 0,'倉','倊','個','倌','倍','倎','倏', */
	/* 5010 */  6, 4, 4, 6, 4,-1, 4, 6,  6, 4, 4, 6, 6, 6, 6, 4, /* '倐','們','倒','倓','倔',0,'倖','倗', '倘','候','倚','倛','倜','倝','倞','借', */
	/* 5020 */ -1, 4, 6, 4, 4, 4, 4, 6,  4, 4, 4, 4, 4, 4, 6,-1, /* 0,'倡','倢','倣','値','倥','倦','倧', '倨','倩','倪','倫','倬','倭','倮',0, */
	/* 5030 */  6,-1, 6, 6,-1, 6, 4,-1, -1, 4,-1, 6,-1,-1,-1,-1, /* '倰',0,'倲','倳',0,'倵','倶',0, 0,'倹',0,'倻',0,0,0,0, */
	/* 5040 */  6, 6, 6, 4,-1, 6, 6, 4,  4, 4, 6,-1, 6,-1, 6, 4, /* '偀','偁','偂','偃',0,'偅','偆','假', '偈','偉','偊',0,'偌',0,'偎','偏', */
	/* 5050 */  4, 6, 6, 6,-1, 4, 4, 6, -1, 6, 4,-1, 4,-1,-1, 6, /* '偐','偑','偒','偓',0,'偕','偖','偗', 0,'偙','做',0,'停',0,0,'偟', */
	/* 5060 */  6,-1, 6, 6,-1, 4, 6, 6, -1,-1, 6,-1, 4, 6,-1,-1, /* '偠',0,'偢','偣',0,'健','偦','偧', 0,0,'偪',0,'偬','偭',0,0, */
	/* 5070 */  6, 6, 4,-1, 4, 4, 4,-1,  4,-1,-1,-1,-1, 4,-1,-1, /* '偰','偱','偲',0,'側','偵','偶',0, '偸',0,0,0,0,'偽',0,0, */
	/* 5080 */  4, 6,-1, 6, 6, 4, 6,-1, -1,-1, 6,-1,-1, 4, 6, 6, /* '傀','傁',0,'傃','傄','傅','傆',0, 0,0,'傊',0,0,'傍','傎','傏', */
	/* 5090 */  6, 4, 6, 6, 6,-1, 6,-1,  4, 4, 4, 6, 6,-1, 6, 6, /* '傐','傑','傒','傓','傔',0,'傖',0, '傘','備','傚','傛','傜',0,'傞','傟', */
	/* 50a0 */  6, 6, 6,-1,-1,-1,-1,-1, -1,-1, 6,-1, 4, 4,-1, 6, /* '傠','傡','傢',0,0,0,0,0, 0,0,'傪',0,'催','傭',0,'傯', */
	/* 50b0 */  6,-1, 4, 4, 4, 4,-1, 4, -1, 6, 6,-1,-1, 6, 4,-1, /* '傰',0,'傲','傳','傴','債',0,'傷', 0,'傹','傺',0,0,'傽','傾',0, */
	/* 50c0 */  6,-1, 4, 6, 6, 4,-1, 6, -1, 4, 4,-1, 6, 4, 6, 4, /* '僀',0,'僂','僃','僄','僅',0,'僇', 0,'僉','僊',0,'僌','働','僎','像', */
	/* 50d0 */  6, 4,-1, 6, 6, 4, 4,-1,  6,-1, 4,-1, 6, 6, 4, 6, /* '僐','僑',0,'僓','僔','僕','僖',0, '僘',0,'僚',0,'僜','僝','僞','僟', */
	/* 50e0 */ -1,-1, 6, 4, 6, 4, 6, 4,  6, 6,-1,-1,-1, 4, 4, 6, /* 0,0,'僢','僣','僤','僥','僦','僧', '僨','僩',0,0,0,'僭','僮','僯', */
	/* 50f0 */ -1, 6, 6,-1, 6, 4, 6,-1, -1, 4, 6, 4,-1,-1, 6,-1, /* 0,'僱','僲',0,'僴','僵','僶',0, 0,'價','僺','僻',0,0,'僾',0, */
	/* 5100 */  4, 4, 4, 6, 4,-1, 6, 6,  6, 4,-1, 6, 6, 6, 6,-1, /* '儀','儁','儂','儃','億',0,'儆','儇', '儈','儉',0,'儋','儌','儍','儎',0, */
	/* 5110 */  6,-1, 4,-1, 4, 4, 4, 6,  4, 6, 4, 6, 6, 6, 6, 4, /* '儐',0,'儒',0,'儔','儕','儖','儗', '儘','儙','儚','儛','儜','儝','儞','償', */
	/* 5120 */ -1, 4,-1, 6,-1,-1,-1, 6,  6,-1, 4,-1, 6, 6,-1, 6, /* 0,'儡',0,'儣',0,0,0,'儧', '儨',0,'優',0,'儬','儭',0,'儯', */
	/* 5130 */ -1, 6, 4, 6, 6, 6,-1, 4,  6, 6, 4, 4, 4,-1,-1, 4, /* 0,'儱','儲','儳','儴','儵',0,'儷', '儸','儹','儺','儻','儼',0,0,'儿', */
	/* 5140 */  4, 4, 6, 4, 4, 4, 4, 4,  4, 4, 6, 4, 4, 4, 4, 6, /* '兀','允','兂','元','兄','充','兆','兇', '先','光','兊','克','兌','免','兎','兏', */
	/* 5150 */  4,-1, 4, 6, 4, 6,-1, 6,  6,-1, 4,-1, 4,-1,-1, 6, /* '児',0,'兒','兓','兔','兕',0,'兗', '兘',0,'党',0,'兜',0,0,'兟', */
	/* 5160 */ -1,-1, 4,-1, 6, 4, 6,-1,  4, 4, 4, 4, 4, 4, 4,-1, /* 0,0,'兢',0,'兤','入','兦',0, '全','兩','兪','八','公','六','兮',0, */
	/* 5170 */ -1, 4,-1,-1,-1, 4, 4, 4,  4,-1,-1,-1, 4,-1, 6,-1, /* 0,'共',0,0,0,'兵','其','具', '典',0,0,0,'兼',0,'兾',0, */
	/* 5180 */  4,-1, 4, 6, 6, 4, 4,-1, -1, 4, 4, 6, 4, 4, 6, 4, /* '冀',0,'冂','冃','冄','内','円',0, 0,'冉','冊','冋','册','再','冎','冏', */
	/* 5190 */  4, 4, 4, 4,-1, 4, 4, 4,  6, 4,-1,-1,-1, 6,-1,-1, /* '冐','冑','冒','冓',0,'冕','冖','冗', '冘','写',0,0,0,'冝',0,0, */
	/* 51a0 */  4, 6, 4, 6, 4, 4, 4,-1,  4, 4, 4, 4, 4, 6,-1,-1, /* '冠','冡','冢','冣','冤','冥','冦',0, '冨','冩','冪','冫','冬','冭',0,0, */
	/* 51b0 */  4, 4, 4, 4, 4, 4, 4, 4,  6,-1, 6,-1, 6, 4, 6, 6, /* '冰','冱','冲','决','冴','况','冶','冷', '冸',0,'冺',0,'冼','冽','冾','冿', */
	/* 51c0 */ -1,-1, 6,-1, 4, 4, 4,-1,  6, 4,-1, 4, 4, 4,-1, 6, /* 0,0,'凂',0,'凄','凅','准',0, '凈','凉',0,'凋','凌','凍',0,'减', */
	/* 51d0 */ -1, 6, 6, 6,-1, 6, 4,-1,  6,-1,-1, 4, 4, 4, 6,-1, /* 0,'凑','凒','凓',0,'凕','凖',0, '凘',0,0,'凛','凜','凝','凞',0, */
	/* 51e0 */  4, 4, 6,-1,-1, 6, 4, 4, -1, 4, 4,-1, 6, 4, 6,-1, /* '几','凡','凢',0,0,'凥','処','凧', 0,'凩','凪',0,'凬','凭','凮',0, */
	/* 51f0 */  4, 4, 6, 6, 6, 4, 4, 6,  4, 4, 4,-1,-1, 4, 4,-1, /* '凰','凱','凲','凳','凴','凵','凶','凷', '凸','凹','出',0,0,'函','凾',0, */
	/* 5200 */  4, 6, 6, 4, 4, 6, 4, 4,  4,-1, 4, 4,-1,-1, 4,-1, /* '刀','刁','刂','刃','刄','刅','分','切', '刈',0,'刊','刋',0,0,'刎',0, */
	/* 5210 */ -1, 4, 6, 6, 4, 6, 6, 4,  6,-1,-1,-1,-1, 4,-1,-1, /* 0,'刑','划','刓','刔','刕','刖','列', '刘',0,0,0,0,'初',0,0, */
	/* 5220 */ -1,-1, 6,-1, 4, 4,-1, 4,  6, 4, 4,-1,-1,-1, 4,-1, /* 0,0,'刢',0,'判','別',0,'刧', '刨','利','刪',0,0,0,'刮',0, */
	/* 5230 */  4, 6, 6, 4,-1, 6, 4, 4,  4, 4, 4, 4, 6,-1,-1,-1, /* '到','刱','刲','刳',0,'刵','制','刷', '券','刹','刺','刻','刼',0,0,0, */
	/* 5240 */ -1,-1,-1, 4, 4, 6,-1, 4, -1, 6, 4, 4, 4, 4,-1, 4, /* 0,0,0,'剃','剄','剅',0,'則', 0,'剉','削','剋','剌','前',0,'剏', */
	/* 5250 */ -1,-1,-1,-1, 4, 6, 4, 6,  6,-1, 6, 4, 6,-1, 4, 6, /* 0,0,0,0,'剔','剕','剖','剗', '剘',0,'剚','剛','剜',0,'剞','剟', */
	/* 5260 */  6, 6,-1, 4, 4, 4, 6,-1, -1, 4, 4,-1,-1,-1, 6, 4, /* '剠','剡',0,'剣','剤','剥','剦',0, 0,'剩','剪',0,0,0,'剮','副', */
	/* 5270 */  4, 4, 4, 4, 4, 4,-1, 6,  6, 6,-1,-1,-1, 4,-1, 4, /* '剰','剱','割','剳','剴','創',0,'剷', '剸','剹',0,0,0,'剽',0,'剿', */
	/* 5280 */  6,-1, 6, 4,-1, 6,-1, 4,  4, 4, 6,-1, 6, 4,-1,-1, /* '劀',0,'劂','劃',0,'劅',0,'劇', '劈','劉','劊',0,'劌','劍',0,0, */
	/* 5290 */ -1, 4, 4, 6, 4, 6, 6, 6,  6,-1, 6, 4, 6,-1,-1, 4, /* 0,'劑','劒','劓','劔','劕','劖','劗', '劘',0,'劚','力','劜',0,0,'功', */
	/* 52a0 */  4,-1,-1, 4, 6, 6, 6, 6, -1, 4, 4, 4, 4, 4,-1, 6, /* '加',0,0,'劣','劤','劥','劦','劧', 0,'助','努','劫','劬','劭',0,'劯', */
	/* 52b0 */  6, 4,-1,-1, 4, 4, 6, 6,  6, 4, 6, 6, 4, 6, 4,-1, /* '劰','励',0,0,'労','劵','劶','劷', '劸','効','劺','劻','劼','劽','劾',0, */
	/* 52c0 */  6, 4,-1, 4, 6, 4, 6, 4,  6, 4,-1,-1, 6, 4,-1, 6, /* '勀','勁',0,'勃','勄','勅','勆','勇', '勈','勉',0,0,'勌','勍',0,'勏', */
	/* 52d0 */ -1, 6, 4,-1, 6, 4, 6, 4,  4, 4,-1, 6, 6, 4, 4, 4, /* 0,'勑','勒',0,'勔','動','勖','勗', '勘','務',0,'勛','勜','勝','勞','募', */
	/* 52e0 */  4, 6, 4, 4, 4, 6, 4, 4,  6, 6, 6,-1, 6,-1,-1,-1, /* '勠','勡','勢','勣','勤','勥','勦','勧', '勨','勩','勪',0,'勬',0,0,0, */
	/* 52f0 */  6, 6, 4, 4, 6, 4, 6, 6,  4, 4, 4,-1,-1,-1, 4, 4, /* '勰','勱','勲','勳','勴','勵','勶','勷', '勸','勹','勺',0,0,0,'勾','勿', */
	/* 5300 */  6, 4, 4, 6,-1, 4, 4, 6,  4,-1, 6, 6, 6, 4,-1, 4, /* '匀','匁','匂','匃',0,'包','匆','匇', '匈',0,'匊','匋','匌','匍',0,'匏', */
	/* 5310 */  4, 6,-1, 6,-1, 4, 4, 4,  6, 4, 4, 6, 6, 4, 6, 6, /* '匐','匑',0,'匓',0,'匕','化','北', '匘','匙','匚','匛','匜','匝','匞','匟', */
	/* 5320 */  4, 4,-1, 4, 6, 6,-1, 6,  6, 6, 4, 6, 6, 6,-1, 4, /* '匠','匡',0,'匣','匤','匥',0,'匧', '匨','匩','匪','匫','匬','匭',0,'匯', */
	/* 5330 */  6, 4, 6, 4,-1, 6,-1,-1,  4, 4, 4, 4, 6, 6, 6, 4, /* '匰','匱','匲','匳',0,'匵',0,0, '匸','匹','区','医','匼','匽','匾','匿', */
	/* 5340 */  4, 4, 6, 4,-1, 4, 4, 4,  4, 4, 4, 6, 6, 4,-1,-1, /* '區','十','卂','千',0,'卅','卆','升', '午','卉','半','卋','卌','卍',0,0, */
	/* 5350 */ -1, 4, 4, 4, 4,-1,-1, 4,  4, 6, 4, 6, 4,-1, 4,-1, /* 0,'卑','卒','卓','協',0,0,'南', '単','卙','博','卛','卜',0,'卞',0, */
	/* 5360 */  4, 6,-1, 6,-1, 6, 4,-1, -1, 4,-1,-1, 6, 6, 4, 4, /* '占','卡',0,'卣',0,'卥','卦',0, 0,'卩',0,0,'卬','卭','卮','卯', */
	/* 5370 */  4, 4, 6, 4, 4, 4,-1, 4,  4, 6,-1, 4,-1,-1, 6, 4, /* '印','危','卲','即','却','卵',0,'卷', '卸','卹',0,'卻',0,0,'卾','卿', */
	/* 5380 */ -1,-1, 4, 6, 4,-1,-1, 6,  6,-1,-1,-1,-1,-1, 6,-1, /* 0,0,'厂','厃','厄',0,0,'厇', '厈',0,0,0,0,0,'厎',0, */
	/* 5390 */ -1,-1,-1, 6, 6,-1, 4,-1,  4, 6, 4,-1,-1, 6,-1, 4, /* 0,0,0,'厓','厔',0,'厖',0, '厘','厙','厚',0,0,'厝',0,'原', */
	/* 53a0 */  4, 6,-1,-1, 6, 4, 4,-1,  4, 4, 6, 6,-1, 4, 4, 6, /* '厠','厡',0,0,'厤','厥','厦',0, '厨','厩','厪','厫',0,'厭','厮','厯', */
	/* 53b0 */  4,-1, 6, 4, 6, 6, 4, 6,  6,-1, 6, 4,-1, 6,-1,-1, /* '厰',0,'厲','厳','厴','厵','厶','厷', '厸',0,'厺','去',0,'厽',0,0, */
	/* 53c0 */  6,-1, 4, 4,-1, 6,-1,-1,  4, 4, 4, 4, 4, 4, 4, 6, /* '叀',0,'参','參',0,'叅',0,0, '又','叉','及','友','双','反','収','叏', */
	/* 53d0 */ -1,-1, 6, 6, 4, 6, 4, 4, -1, 4, 6, 4,-1, 6, 6, 4, /* 0,0,'叒','叓','叔','叕','取','受', 0,'叙','叚','叛',0,'叝','叞','叟', */
	/* 53e0 */  6, 4, 4, 4, 4, 4, 6, 6,  4, 4, 4, 4, 4, 4, 4, 4, /* '叠','叡','叢','口','古','句','另','叧', '叨','叩','只','叫','召','叭','叮','可', */
	/* 53f0 */  4, 4, 4, 4,-1, 6, 4, 4,  4,-1, 4,-1,-1,-1,-1,-1, /* '台','叱','史','右',0,'叵','叶','号', '司',0,'叺',0,0,0,0,0, */
	/* 5400 */ -1, 4, 6, 4, 4,-1,-1,-1,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'吁','吂','吃','各',0,0,0, '合','吉','吊','吋','同','名','后','吏', */
	/* 5410 */  4, 4,-1, 6,-1,-1,-1,-1, -1,-1, 6, 4,-1, 4,-1, 4, /* '吐','向',0,'吓',0,0,0,0, 0,0,'吚','君',0,'吝',0,'吟', */
	/* 5420 */  4, 6,-1,-1,-1,-1, 4, 6,  6, 4, 6, 4, 4, 4, 4, 6, /* '吠','吡',0,0,0,0,'否','吧', '吨','吩','吪','含','听','吭','吮','启', */
	/* 5430 */ -1, 6,-1,-1, 6, 6, 4,-1,  4, 4,-1, 4, 4, 4, 4,-1, /* 0,'吱',0,0,'吴','吵','吶',0, '吸','吹',0,'吻','吼','吽','吾',0, */
	/* 5440 */  4,-1, 4, 6, 6,-1, 4, 6,  4, 4, 4,-1,-1, 6, 4, 6, /* '呀',0,'呂','呃','呄',0,'呆','呇', '呈','呉','告',0,0,'呍','呎','呏', */
	/* 5450 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 6, 4, /* 0,'呑',0,0,0,0,0,0, 0,0,0,0,0,0,'呞','呟', */
	/* 5460 */ -1,-1, 6,-1, 6,-1, 6, 6,  4, 6, 4, 6,-1, 6, 6,-1, /* 0,0,'呢',0,'呤',0,'呦','呧', '周','呩','呪','呫',0,'呭','呮',0, */
	/* 5470 */  4, 4,-1, 4, 6, 4, 4, 4, -1,-1,-1, 4, 4, 4,-1, 6, /* '呰','呱',0,'味','呴','呵','呶','呷', 0,0,0,'呻','呼','命',0,'呿', */
	/* 5480 */  4, 6,-1, 6, 4, 6, 4,-1,  6, 6, 6, 4, 4, 6, 4, 4, /* '咀','咁',0,'咃','咄','咅','咆',0, '咈','咉','咊','咋','和','咍','咎','咏', */
	/* 5490 */  4, 6, 4,-1,-1, 6, 6,-1, -1,-1,-1,-1, 6,-1,-1, 6, /* '咐','咑','咒',0,0,'咕','咖',0, 0,0,0,0,'咜',0,0,'咟', */
	/* 54a0 */ -1, 6, 4,-1, 4, 4, 6, 6,  4, 6, 6, 4, 4, 6, 6, 4, /* 0,'咡','咢',0,'咤','咥','咦','咧', '咨','咩','咪','咫','咬','咭','咮','咯', */
	/* 54b0 */ -1, 6, 4, 4,-1,-1,-1, 6,  4, 6, 6, 6, 4, 4, 4, 6, /* 0,'咱','咲','咳',0,0,0,'咷', '咸','咹','咺','咻','咼','咽','咾','咿', */
	/* 54c0 */  4, 4, 4,-1, 4,-1, 6, 4,  4, 4, 6,-1,-1, 6, 6,-1, /* '哀','品','哂',0,'哄',0,'哆','哇', '哈','哉','哊',0,0,'响','哎',0, */
	/* 54d0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, '哘',0,0,0,0,0,0,0, */
	/* 54e0 */  6, 4, 4,-1,-1, 4, 4,-1,  4, 4, 6,-1, 6, 4, 4, 6, /* '哠','員','哢',0,0,'哥','哦',0, '哨','哩','哪',0,'哬','哭','哮','哯', */
	/* 54f0 */ -1,-1, 4,-1,-1,-1, 6,-1, -1,-1, 4,-1, 6, 4, 6, 6, /* 0,0,'哲',0,0,0,'哶',0, 0,0,'哺',0,'哼','哽','哾','哿', */
	/* 5500 */  6, 6,-1,-1, 4, 6, 4, 4,  6, 6,-1,-1, 6, 6, 6, 4, /* '唀','唁',0,0,'唄','唅','唆','唇', '唈','唉',0,0,'唌','唍','唎','唏', */
	/* 5510 */  4,-1,-1,-1, 4, 6, 4,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '唐',0,0,0,'唔','唕','唖',0, 0,0,0,0,0,0,0,0, */
	/* 5520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 6, 6,-1,-1, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,'唪','唫',0,0,'售','唯', */
	/* 5530 */ -1, 4, 6, 4,-1, 6, 6,-1,  4, 4,-1, 6, 6, 6, 4,-1, /* 0,'唱','唲','唳',0,'唵','唶',0, '唸','唹',0,'唻','唼','唽','唾',0, */
	/* 5540 */  4, 6,-1,-1, 4, 4, 4, 6, -1, 6, 6,-1, 4, 6,-1, 4, /* '啀','啁',0,0,'啄','啅','商','啇', 0,'啉','啊',0,'啌','啍',0,'問', */
	/* 5550 */  6, 6,-1, 4,-1,-1, 4, 4,  6,-1, 6, 6, 4, 4, 6,-1, /* '啐','啑',0,'啓',0,0,'啖','啗', '啘',0,'啚','啛','啜','啝','啞',0, */
	/* 5560 */  6, 6,-1, 4, 6,-1, 6,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '啠','啡',0,'啣','啤',0,'啦',0, 0,0,0,0,0,0,0,0, */
	/* 5570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1, 4, 6, /* 0,0,0,0,0,0,0,0, 0,0,0,'啻','啼',0,'啾','啿', */
	/* 5580 */  4, 6, 6, 4, 4,-1, 6, 4,  6, 4, 4, 4,-1,-1, 6, 6, /* '喀','喁','喂','喃','善',0,'喆','喇', '喈','喉','喊','喋',0,0,'喎','喏', */
	/* 5590 */ -1, 6, 6, 6, 6,-1,-1, 6,  4, 4, 4,-1, 4, 4, 4, 4, /* 0,'喑','喒','喓','喔',0,0,'喗', '喘','喙','喚',0,'喜','喝','喞','喟', */
	/* 55a0 */ -1,-1,-1, 6, 6,-1,-1, 4,  4, 4, 4, 4, 4, 6, 4,-1, /* 0,0,0,'喣','喤',0,0,'喧', '喨','喩','喪','喫','喬','喭','單',0, */
	/* 55b0 */  4,-1, 6,-1,-1,-1, 4,-1, -1,-1,-1,-1,-1,-1,-1, 6, /* '喰',0,'喲',0,0,0,'営',0, 0,0,0,0,0,0,0,'喿', */
	/* 55c0 */ -1, 6,-1, 6, 4, 4, 6, 4, -1, 6,-1, 6, 6,-1, 6,-1, /* 0,'嗁',0,'嗃','嗄','嗅','嗆','嗇', 0,'嗉',0,'嗋','嗌',0,'嗎',0, */
	/* 55d0 */ -1, 6, 6, 6, 4,-1,-1, 6,  6,-1, 4, 6, 4,-1, 6, 4, /* 0,'嗑','嗒','嗓','嗔',0,0,'嗗', '嗘',0,'嗚','嗛','嗜',0,'嗞','嗟', */
	/* 55e0 */ -1,-1, 6, 4, 4,-1,-1,-1, -1, 6,-1,-1,-1,-1,-1,-1, /* 0,0,'嗢','嗣','嗤',0,0,0, 0,'嗩',0,0,0,0,0,0, */
	/* 55f0 */ -1,-1,-1,-1,-1,-1, 6, 4, -1, 4,-1,-1,-1, 4, 4, 6, /* 0,0,0,0,0,0,'嗶','嗷', 0,'嗹',0,0,0,'嗽','嗾','嗿', */
	/* 5600 */ -1,-1,-1,-1,-1, 6, 4,-1,  6, 4, 6,-1,-1, 6, 6, 6, /* 0,0,0,0,0,'嘅','嘆',0, '嘈','嘉','嘊',0,0,'嘍','嘎','嘏', */
	/* 5610 */  6, 6, 6,-1, 4,-1, 4, 4,  4, 6,-1, 4,-1,-1,-1,-1, /* '嘐','嘑','嘒',0,'嘔',0,'嘖','嘗', '嘘','嘙',0,'嘛',0,0,0,0, */
	/* 5620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 4,-1,-1, 6,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,'嘩',0,0,'嘬',0,0,'嘯', */
	/* 5630 */  6, 4, 4, 6, 4, 6, 4, 6,  4, 6,-1, 6, 6, 6,-1, 6, /* '嘰','嘱','嘲','嘳','嘴','嘵','嘶','嘷', '嘸','嘹',0,'嘻','嘼','嘽',0,'嘿', */
	/* 5640 */  6, 6, 4, 6, 6,-1, 6,-1, -1, 6,-1, 6, 4, 6, 4, 6, /* '噀','噁','噂','噃','噄',0,'噆',0, 0,'噉',0,'噋','噌','噍','噎','噏', */
	/* 5650 */  4,-1,-1,-1, 6,-1,-1,-1, -1,-1,-1, 4,-1,-1, 6,-1, /* '噐',0,0,0,'噔',0,0,0, 0,0,0,'噛',0,0,'噞',0, */
	/* 5660 */  6, 6, 6, 6, 4,-1, 6,-1,  4, 6, 4, 4, 4, 6,-1, 6, /* '噠','噡','噢','噣','噤',0,'噦',0, '器','噩','噪','噫','噬','噭',0,'噯', */
	/* 5670 */ -1, 6, 6,-1, 4, 6,-1,-1,  4,-1, 4,-1,-1,-1,-1,-1, /* 0,'噱','噲',0,'噴','噵',0,0, '噸',0,'噺',0,0,0,0,0, */
	/* 5680 */  4,-1,-1,-1, 6, 6, 4, 4,  6,-1, 4, 6, 6,-1,-1, 4, /* '嚀',0,0,0,'嚄','嚅','嚆','嚇', '嚈',0,'嚊','嚋','嚌',0,0,'嚏', */
	/* 5690 */ -1,-1,-1,-1, 4, 6,-1,-1, -1, 6, 6,-1,-1, 6, 6, 6, /* 0,0,0,0,'嚔','嚕',0,0, 0,'嚙','嚚',0,0,'嚝','嚞','嚟', */
	/* 56a0 */  4,-1, 4,-1,-1, 4, 6, 6,  6, 6,-1, 6, 6, 6, 4,-1, /* '嚠',0,'嚢',0,0,'嚥','嚦','嚧', '嚨','嚩',0,'嚫','嚬','嚭','嚮',0, */
	/* 56b0 */ -1, 6,-1, 6, 4,-1, 4, 6, -1,-1,-1,-1, 4,-1, 6,-1, /* 0,'嚱',0,'嚳','嚴',0,'嚶','嚷', 0,0,0,0,'嚼',0,'嚾',0, */
	/* 56c0 */  4, 4, 4, 4,-1, 6,-1,-1,  4, 6, 6, 6, 6, 6, 4, 6, /* '囀','囁','囂','囃',0,'囅',0,0, '囈','囉','囊','囋','囌','囍','囎','囏', */
	/* 56d0 */  6, 4,-1, 4,-1,-1,-1, 4,  4, 6, 4, 4, 6, 6, 4, 6, /* '囐','囑',0,'囓',0,0,0,'囗', '囘','囙','囚','四','囜','囝','回','囟', */
	/* 56e0 */  4, 6,-1, 4, 6, 6, 6, 6,  6,-1,-1, 6,-1, 6, 4,-1, /* '因','囡',0,'団','囤','囥','囦','囧', '囨',0,0,'囫',0,'园','囮',0, */
	/* 56f0 */  4, 6, 4, 4,-1,-1, 6, 6, -1, 4, 4,-1,-1, 4,-1, 4, /* '困','囱','囲','図',0,0,'囶','囷', 0,'囹','固',0,0,'国',0,'囿', */
	/* 5700 */  4, 6, 6, 4, 4,-1,-1, 6,  4, 4, 6, 4, 6, 4,-1, 4, /* '圀','圁','圂','圃','圄',0,0,'圇', '圈','圉','圊','國','圌','圍',0,'圏', */
	/* 5710 */ -1, 6, 4, 4,-1, 6, 4,-1,  4,-1, 6, 6, 4, 6,-1, 4, /* 0,'圑','園','圓',0,'圕','圖',0, '團',0,'圚','圛','圜','圝',0,'土', */
	/* 5720 */  6,-1, 6, 6, 6, 6, 4, 4,  4, 6, 6,-1, 6, 4, 6, 6, /* '圠',0,'圢','圣','圤','圥','圦','圧', '在','圩','圪',0,'圬','圭','圮','圯', */
	/* 5730 */  4,-1,-1, 6, 6,-1,-1, 4,  4,-1,-1, 4,-1, 6, 6, 6, /* '地',0,0,'圳','圴',0,0,'圷', '圸',0,0,'圻',0,'圽','圾','圿', */
	/* 5740 */  4,-1, 4,-1,-1, 6, 6, 4, -1,-1, 4,-1, 6, 6, 4, 4, /* '址',0,'坂',0,0,'坅','坆','均', 0,0,'坊',0,'坌','坍','坎','坏', */
	/* 5750 */  4, 4, 6,-1,-1,-1,-1,-1, -1, 6,-1,-1,-1,-1,-1,-1, /* '坐','坑','坒',0,0,0,0,0, 0,'坙',0,0,0,0,0,0, */
	/* 5760 */ -1, 4, 6,-1, 4, 6, 4, 6,  6, 4, 4, 6,-1, 6, 6, 6, /* 0,'坡','坢',0,'坤','坥','坦','坧', '坨','坩','坪','坫',0,'坭','坮','坯', */
	/* 5770 */  6, 6,-1, 6, 6, 6,-1, 6, -1, 6, 6, 6, 6,-1, 6, 4, /* '坰','坱',0,'坳','坴','坵',0,'坷', 0,'坹','坺','坻','坼',0,'坾','坿', */
	/* 5780 */ -1, 6, 4, 6,-1,-1,-1,-1,  4, 4,-1, 4, 6,-1,-1,-1, /* 0,'垁','垂','垃',0,0,0,0, '垈','垉',0,'型','垌',0,0,0, */
	/* 5790 */ -1,-1,-1, 4, 6, 6,-1, 6, -1, 6, 6,-1, 6, 6, 6, 6, /* 0,0,0,'垓','垔','垕',0,'垗', 0,'垙','垚',0,'垜','垝','垞','垟', */
	/* 57a0 */  4, 6, 4, 4, 4,-1,-1, 6,  6, 6, 4,-1, 6,-1,-1,-1, /* '垠','垡','垢','垣','垤',0,0,'垧', '垨','垩','垪',0,'垬',0,0,0, */
	/* 57b0 */  4,-1,-1, 4,-1,-1,-1,-1,  6,-1,-1,-1,-1, 6,-1,-1, /* '垰',0,0,'垳',0,0,0,0, '垸',0,0,0,0,'垽',0,0, */
	/* 57c0 */  4,-1,-1, 4,-1,-1, 4, 6,  6,-1,-1, 4, 6,-1, 4, 6, /* '埀',0,0,'埃',0,0,'埆','埇', '埈',0,0,'埋','埌',0,'城','埏', */
	/* 57d0 */ -1,-1, 4, 4, 4, 6, 4,-1, -1,-1,-1,-1, 4, 6, 6, 4, /* 0,0,'埒','埓','埔','埕','埖',0, 0,0,0,0,'埜','埝','埞','域', */
	/* 57e0 */  4, 6,-1, 4, 6,-1, 6, 6, -1, 6,-1,-1,-1, 6,-1,-1, /* '埠','埡',0,'埣','埤',0,'埦','埧', 0,'埩',0,0,0,'埭',0,0, */
	/* 57f0 */  6,-1,-1,-1, 4, 6, 6, 4,  6, 4, 4,-1, 4, 6, 6, 6, /* '埰',0,0,0,'埴','埵','埶','執', '埸','培','基',0,'埼','埽','埾','埿', */
	/* 5800 */  4,-1, 4, 6, 6, 4, 4,-1,  6, 6, 4, 4, 6, 6,-1,-1, /* '堀',0,'堂','堃','堄','堅','堆',0, '堈','堉','堊','堋','堌','堍',0,0, */
	/* 5810 */ -1,-1,-1,-1,-1, 4,-1,-1, -1, 4,-1, 6,-1, 4, 6, 6, /* 0,0,0,0,0,'堕',0,0, 0,'堙',0,'堛',0,'堝','堞','堟', */
	/* 5820 */  6, 4,-1,-1, 4,-1, 6, 6, -1,-1, 4,-1,-1, 6,-1, 4, /* '堠','堡',0,0,'堤',0,'堦','堧', 0,0,'堪',0,0,'堭',0,'堯', */
	/* 5830 */  4, 4, 6,-1, 4, 4,-1,-1, -1, 6, 4,-1,-1, 4,-1, 6, /* '堰','報','堲',0,'場','堵',0,0, 0,'堹','堺',0,0,'堽',0,'堿', */
	/* 5840 */  4, 4,-1,-1,-1,-1,-1,-1, -1, 6, 4, 4, 6, 6,-1, 6, /* '塀','塁',0,0,0,0,0,0, 0,'塉','塊','塋','塌','塍',0,'塏', */
	/* 5850 */  6, 4, 4,-1, 4, 6,-1, 4,  4, 4, 4,-1,-1,-1, 4, 6, /* '塐','塑','塒',0,'塔','塕',0,'塗', '塘','塙','塚',0,0,0,'塞','塟', */
	/* 5860 */ -1, 6, 4,-1, 6,-1,-1, 6,  6, 4,-1, 4,-1,-1,-1,-1, /* 0,'塡','塢',0,'塤',0,0,'塧', '塨','塩',0,'填',0,0,0,0, */
	/* 5870 */  4,-1, 4,-1,-1, 4,-1,-1,  6, 4,-1,-1, 6,-1, 4, 6, /* '塰',0,'塲',0,0,'塵',0,0, '塸','塹',0,0,'塼',0,'塾','塿', */
	/* 5880 */  6, 6,-1, 4,-1, 4,-1, 6,  6, 6, 6,-1, 6, 6,-1, 6, /* '墀','墁',0,'境',0,'墅',0,'墇', '墈','墉','墊',0,'墌','墍',0,'墏', */
	/* 5890 */  6,-1,-1, 4, 6,-1, 6, 4, -1,-1,-1,-1, 4, 6, 6, 4, /* '墐',0,0,'墓','墔',0,'墖','増', 0,0,0,0,'墜','墝','增','墟', */
	/* 58a0 */  6, 6, 6,-1,-1,-1, 6,-1,  4, 6,-1, 4,-1,-1, 4,-1, /* '墠','墡','墢',0,0,0,'墦',0, '墨','墩',0,'墫',0,0,'墮',0, */
	/* 58b0 */ -1, 6, 6, 4,-1,-1,-1,-1,  4, 4, 4, 4, 6,-1, 4,-1, /* 0,'墱','墲','墳',0,0,0,0, '墸','墹','墺','墻','墼',0,'墾',0, */
	/* 58c0 */ -1, 4, 6,-1, 6, 4,-1, 4,  6,-1, 4,-1, 4, 6, 6,-1, /* 0,'壁','壂',0,'壄','壅',0,'壇', '壈',0,'壊',0,'壌','壍','壎',0, */
	/* 58d0 */  6, 4, 6, 4, 6, 4, 6, 4,  4, 4, 6,-1, 4, 6, 4, 4, /* '壐','壑','壒','壓','壔','壕','壖','壗', '壘','壙','壚',0,'壜','壝','壞','壟', */
	/* 58e0 */ -1, 6, 6,-1, 4, 4,-1,-1, -1, 6,-1, 4, 4,-1, 4, 4, /* 0,'壡','壢',0,'壤','壥',0,0, 0,'壩',0,'士','壬',0,'壮','壯', */
	/* 58f0 */  4, 4, 4, 6,-1,-1,-1, 4, -1, 4, 4, 4, 4, 4,-1,-1, /* '声','壱','売','壳',0,0,0,'壷', 0,'壹','壺','壻','壼','壽',0,0, */
	/* 5900 */ -1,-1, 4,-1,-1, 6, 6,-1, -1, 4, 4, 6, 6,-1,-1, 4, /* 0,0,'夂',0,0,'夅','夆',0, 0,'変','夊','夋','夌',0,0,'夏', */
	/* 5910 */  4,-1, 6, 6, 6, 4, 4,-1,  4, 4, 4, 4, 4, 6,-1,-1, /* '夐',0,'夒','夓','夔','夕','外',0, '夘','夙','多','夛','夜','夝',0,0, */
	/* 5920 */ -1, 6, 4, 6, 6, 4,-1, 4,  6, 4, 4, 4, 4, 4, 4, 6, /* 0,'夡','夢','夣','夤','夥',0,'大', '夨','天','太','夫','夬','夭','央','夯', */
	/* 5930 */  6, 4, 4, 6,-1, 6, 6, 4,  4,-1,-1,-1,-1,-1, 4, 6, /* '夰','失','夲','夳',0,'夵','夶','夷', '夸',0,0,0,0,0,'夾','夿', */
	/* 5940 */ -1,-1,-1, 6, 4,-1, 6, 4,  4, 4,-1,-1,-1,-1, 4, 4, /* 0,0,0,'奃','奄',0,'奆','奇', '奈','奉',0,0,0,0,'奎','奏', */
	/* 5950 */  4, 4, 6, 6, 4, 4,-1, 4,  4, 6, 4, 6,-1, 6, 6, 6, /* '奐','契','奒','奓','奔','奕',0,'套', '奘','奙','奚','奛',0,'奝','奞','奟', */
	/* 5960 */  4, 6, 4, 6,-1, 4,-1, 4,  4, 4, 4, 6, 4, 6, 4, 6, /* '奠','奡','奢','奣',0,'奥',0,'奧', '奨','奩','奪','奫','奬','奭','奮','奯', */
	/* 5970 */ -1,-1, 6, 4, 4, 6, 6,-1,  4, 6,-1, 6, 6, 4,-1,-1, /* 0,0,'奲','女','奴','奵','奶',0, '奸','她',0,'奻','奼','好',0,0, */
	/* 5980 */ -1, 4, 4, 4, 4,-1,-1,-1, -1,-1, 4, 6, 6, 4, 6,-1, /* 0,'妁','如','妃','妄',0,0,0, 0,0,'妊','妋','妌','妍','妎',0, */
	/* 5990 */ -1,-1, 6, 4,-1, 6, 4, 6, -1, 4,-1, 4,-1, 4,-1, 6, /* 0,0,'妒','妓',0,'妕','妖','妗', 0,'妙',0,'妛',0,'妝',0,'妟', */
	/* 59a0 */ -1,-1,-1, 4, 6, 4,-1, 6,  4,-1,-1,-1, 4, 6, 6, 6, /* 0,0,0,'妣','妤','妥',0,'妧', '妨',0,0,0,'妬','妭','妮','妯', */
	/* 59b0 */  6,-1, 4, 6,-1,-1,-1, 6, -1, 4, 6, 4, 6,-1, 4,-1, /* '妰',0,'妲','妳',0,0,0,'妷', 0,'妹','妺','妻','妼',0,'妾',0, */
	/* 59c0 */ -1, 6,-1, 6, 6,-1, 4,-1,  6, 4, 6, 4,-1, 6,-1,-1, /* 0,'姁',0,'姃','姄',0,'姆',0, '姈','姉','姊','始',0,'姍',0,0, */
	/* 59d0 */  4, 4, 6, 4, 4,-1,-1,-1, -1, 4, 4,-1, 4, 6, 6, 6, /* '姐','姑','姒','姓','委',0,0,0, 0,'姙','姚',0,'姜','姝','姞','姟', */
	/* 59e0 */ -1,-1,-1, 6, 6, 4, 4, 6,  4,-1, 4, 4,-1,-1, 6, 6, /* 0,0,0,'姣','姤','姥','姦','姧', '姨',0,'姪','姫',0,0,'姮','姯', */
	/* 59f0 */ -1, 6, 6,-1, 6,-1, 4, 6, -1,-1,-1, 4,-1,-1,-1, 4, /* 0,'姱','姲',0,'姴',0,'姶','姷', 0,0,0,'姻',0,0,0,'姿', */
	/* 5a00 */  6, 4,-1, 4, 6,-1,-1,-1, -1, 4,-1,-1, 6, 6, 6,-1, /* '娀','威',0,'娃','娄',0,0,0, 0,'娉',0,0,'娌','娍','娎',0, */
	/* 5a10 */ -1, 4, 6, 6,-1,-1,-1,-1,  4,-1, 4,-1, 4,-1, 6, 4, /* 0,'娑','娒','娓',0,0,0,0, '娘',0,'娚',0,'娜',0,'娞','娟', */
	/* 5a20 */  4,-1,-1, 6, 6, 4,-1, 6,  6, 4, 6,-1,-1, 6,-1, 4, /* '娠',0,0,'娣','娤','娥',0,'娧', '娨','娩','娪',0,0,'娭',0,'娯', */
	/* 5a30 */  6,-1,-1,-1,-1, 4, 4,-1, -1,-1,-1,-1, 4,-1,-1,-1, /* '娰',0,0,0,0,'娵','娶',0, 0,0,0,0,'娼',0,0,0, */
	/* 5a40 */  4, 4,-1,-1, 6, 6, 4, 6,  6, 4,-1,-1, 6,-1,-1,-1, /* '婀','婁',0,0,'婄','婅','婆','婇', '婈','婉',0,0,'婌',0,0,0, */
	/* 5a50 */  6,-1,-1,-1,-1, 6,-1,-1, -1,-1, 4,-1,-1,-1, 6,-1, /* '婐',0,0,0,0,'婕',0,0, 0,0,'婚',0,0,0,'婞',0, */
	/* 5a60 */ -1,-1, 4, 6,-1, 6, 4, 6, -1,-1, 4,-1, 4, 6,-1,-1, /* 0,0,'婢','婣',0,'婥','婦','婧', 0,0,'婪',0,'婬','婭',0,0, */
	/* 5a70 */ -1,-1,-1,-1,-1,-1,-1, 6, -1,-1, 6, 6,-1,-1, 6, 4, /* 0,0,0,0,0,0,0,'婷', 0,0,'婺','婻',0,0,'婾','婿', */
	/* 5a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 6,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,'媋',0,0,0,0, */
	/* 5a90 */  6,-1, 4, 6,-1,-1, 6,-1, -1, 6, 4, 4, 6,-1, 6, 6, /* '媐',0,'媒','媓',0,0,'媖',0, 0,'媙','媚','媛','媜',0,'媞','媟', */
	/* 5aa0 */  6,-1, 6,-1,-1,-1,-1, 6, -1,-1,-1,-1, 6,-1,-1,-1, /* '媠',0,'媢',0,0,0,0,'媧', 0,0,0,0,'媬',0,0,0, */
	/* 5ab0 */ -1, 6, 6, 6,-1, 6,-1,-1,  6,-1, 6, 6, 4, 4, 4, 6, /* 0,'媱','媲','媳',0,'媵',0,0, '媸',0,'媺','媻','媼','媽','媾','媿', */
	/* 5ac0 */ -1, 4, 4,-1, 6,-1, 6,-1,  6, 4,-1, 4, 4,-1,-1, 6, /* 0,'嫁','嫂',0,'嫄',0,'嫆',0, '嫈','嫉',0,'嫋','嫌',0,0,'嫏', */
	/* 5ad0 */  4,-1,-1,-1,-1,-1, 4, 4, -1,-1, 6,-1, 6,-1,-1,-1, /* '嫐',0,0,0,0,0,'嫖','嫗', 0,0,'嫚',0,'嫜',0,0,0, */
	/* 5ae0 */  6, 4,-1, 4,-1, 6, 4,-1, -1, 4, 6,-1,-1,-1, 6,-1, /* '嫠','嫡',0,'嫣',0,'嫥','嫦',0, 0,'嫩','嫪',0,0,0,'嫮',0, */
	/* 5af0 */ -1,-1,-1,-1,-1, 6, 6,-1, -1,-1, 4, 4,-1, 6,-1,-1, /* 0,0,0,0,0,'嫵','嫶',0, 0,0,'嫺','嫻',0,'嫽',0,0, */
	/* 5b00 */  6, 6,-1,-1,-1,-1,-1,-1,  6, 4,-1, 4, 4,-1,-1,-1, /* '嬀','嬁',0,0,0,0,0,0, '嬈','嬉',0,'嬋','嬌',0,0,0, */
	/* 5b10 */ -1,-1,-1,-1,-1,-1, 4, 6, -1, 6,-1, 6,-1, 6,-1,-1, /* 0,0,0,0,0,0,'嬖','嬗', 0,'嬙',0,'嬛',0,'嬝',0,0, */
	/* 5b20 */ -1, 6, 4,-1,-1, 6,-1,-1, -1,-1, 4,-1, 4, 6,-1,-1, /* 0,'嬡','嬢',0,0,'嬥',0,0, 0,0,'嬪',0,'嬬','嬭',0,0, */
	/* 5b30 */  4,-1, 4,-1, 6,-1, 4,-1,  6,-1,-1,-1,-1,-1, 4,-1, /* '嬰',0,'嬲',0,'嬴',0,'嬶',0, '嬸',0,0,0,0,0,'嬾',0, */
	/* 5b40 */  4, 6,-1, 4,-1, 4,-1,-1, -1,-1,-1, 6, 6,-1,-1,-1, /* '孀','孁',0,'孃',0,'孅',0,0, 0,0,0,'孋','孌',0,0,0, */
	/* 5b50 */  4, 4, 6,-1, 4, 4, 6, 4,  4,-1, 4, 4, 4, 4, 6, 4, /* '子','孑','孒',0,'孔','孕','孖','字', '存',0,'孚','孛','孜','孝','孞','孟', */
	/* 5b60 */ -1,-1,-1, 4, 4, 4, 4,-1,  6, 4,-1, 4,-1,-1, 6, 6, /* 0,0,0,'季','孤','孥','学',0, '孨','孩',0,'孫',0,0,'孮','孯', */
	/* 5b70 */  4, 4,-1, 4,-1, 4,-1,-1,  4,-1, 4,-1, 6, 6, 6, 6, /* '孰','孱',0,'孳',0,'孵',0,0, '學',0,'孺',0,'孼','孽','孾','孿', */
	/* 5b80 */  4, 6,-1, 4, 6, 4, 6, 4,  4, 4, 6, 4, 4, 4, 6, 4, /* '宀','宁',0,'它','宄','宅','宆','宇', '守','安','宊','宋','完','宍','宎','宏', */
	/* 5b90 */  6, 6,-1, 6, 6, 4, 6, 4,  4, 4, 4, 4, 4, 4,-1, 4, /* '宐','宑',0,'宓','宔','宕','宖','宗', '官','宙','定','宛','宜','宝',0,'実', */
	/* 5ba0 */ -1,-1, 4, 4, 4, 4, 4,-1,  6, 6,-1,-1, 6, 6, 4, 6, /* 0,0,'客','宣','室','宥','宦',0, '宨','宩',0,0,'宬','宭','宮','宯', */
	/* 5bb0 */  4, 6, 6, 4, 4, 4, 4, 6,  4, 4, 6,-1, 6,-1,-1, 4, /* '宰','宱','宲','害','宴','宵','家','宷', '宸','容','宺',0,'宼',0,0,'宿', */
	/* 5bc0 */  6, 6, 4, 4, 4, 4, 4, 4, -1, 4,-1,-1, 4, 6,-1, 6, /* '寀','寁','寂','寃','寄','寅','密','寇', 0,'寉',0,0,'富','寍',0,'寏', */
	/* 5bd0 */  4,-1, 4, 4, 4,-1, 6, 6,  6, 6, 6, 4,-1, 4, 4, 4, /* '寐',0,'寒','寓','寔',0,'寖','寗', '寘','寙','寚','寛',0,'寝','寞','察', */
	/* 5be0 */  6, 4, 4,-1, 4, 4, 4, 4,  4, 4,-1, 4, 6,-1, 4, 6, /* '寠','寡','寢',0,'寤','寥','實','寧', '寨','審',0,'寫','寬',0,'寮','寯', */
	/* 5bf0 */  4, 6,-1, 4, 6, 4, 4,-1,  4,-1, 4,-1,-1, 6, 4, 4, /* '寰','寱',0,'寳','寴','寵','寶',0, '寸',0,'寺',0,0,'寽','対','寿', */
	/* 5c00 */ -1, 4, 4,-1, 4, 4, 4, 4,  4, 4, 4, 4, 6, 4, 4, 4, /* 0,'封','専',0,'射','尅','将','將', '專','尉','尊','尋','尌','對','導','小', */
	/* 5c10 */ -1, 4,-1, 4,-1,-1, 4, 6, -1,-1, 4,-1,-1,-1, 6, 6, /* 0,'少',0,'尓',0,0,'尖','尗', 0,0,'尚',0,0,0,'尞','尟', */
	/* 5c20 */  4,-1, 4, 6, 4,-1, 6,-1,  4, 6,-1, 6, 6, 4, 6,-1, /* '尠',0,'尢','尣','尤',0,'尦',0, '尨','尩',0,'尫','尬','尭','尮',0, */
	/* 5c30 */  6, 4, 6,-1,-1, 6, 6,-1,  4, 4, 4, 4, 4, 4, 4, 4, /* '尰','就','尲',0,0,'尵','尶',0, '尸','尹','尺','尻','尼','尽','尾','尿', */
	/* 5c40 */  4, 4,-1,-1,-1, 4, 4,-1,  4,-1, 4, 4,-1, 4, 4, 4, /* '局','屁',0,0,0,'居','屆',0, '屈',0,'届','屋',0,'屍','屎','屏', */
	/* 5c50 */  4, 4,-1, 4,-1, 4,-1,-1, -1, 6, 6,-1, 6,-1, 4,-1, /* '屐','屑',0,'屓',0,'展',0,0, 0,'屙','屚',0,'屜',0,'属',0, */
	/* 5c60 */  4, 4, 6, 6, 4, 4,-1, 6,  6, 6,-1,-1, 4, 6, 4, 4, /* '屠','屡','屢','屣','層','履',0,'屧', '屨','屩',0,0,'屬','屭','屮','屯', */
	/* 5c70 */  6, 4,-1,-1, 6, 6, 4,-1, -1, 4, 6, 6, 6, 6,-1,-1, /* '屰','山',0,0,'屴','屵','屶',0, 0,'屹','屺','屻','屼','屽',0,0, */
	/* 5c80 */ -1,-1,-1,-1,-1,-1,-1, 6,  6,-1, 6,-1, 4,-1,-1, 6, /* 0,0,0,0,0,0,0,'岇', '岈',0,'岊',0,'岌',0,0,'岏', */
	/* 5c90 */  4, 4, 6,-1, 4,-1,-1,-1, -1,-1,-1,-1,-1, 6,-1, 6, /* '岐','岑','岒',0,'岔',0,0,0, 0,0,0,0,0,'岝',0,'岟', */
	/* 5ca0 */  6, 4, 6, 6,-1,-1, 6,-1,  4, 4, 6, 4, 4,-1,-1,-1, /* '岠','岡','岢','岣',0,0,'岦',0, '岨','岩','岪','岫','岬',0,0,0, */
	/* 5cb0 */ -1, 4, 6, 4, 6, 6, 4, 4,  4,-1, 6, 4, 4,-1, 4,-1, /* 0,'岱','岲','岳','岴','岵','岶','岷', '岸',0,'岺','岻','岼',0,'岾',0, */
	/* 5cc0 */ -1,-1,-1,-1,-1, 4,-1, 4, -1, 6,-1, 6,-1,-1,-1,-1, /* 0,0,0,0,0,'峅',0,'峇', 0,'峉',0,'峋',0,0,0,0, */
	/* 5cd0 */ -1,-1, 6,-1,-1,-1,-1, 6, -1, 4,-1,-1,-1, 6,-1,-1, /* 0,0,'峒',0,0,0,0,'峗', 0,'峙',0,0,0,'峝',0,0, */
	/* 5ce0 */  4, 4,-1,-1,-1,-1,-1,-1,  4, 4, 4,-1,-1, 4, 6, 4, /* '峠','峡',0,0,0,0,0,0, '峨','峩','峪',0,0,'峭','峮','峯', */
	/* 5cf0 */  4, 6, 6,-1, 6, 6, 4,-1, -1,-1, 4, 4,-1, 4,-1,-1, /* '峰','峱','峲',0,'峴','峵','島',0, 0,0,'峺','峻',0,'峽',0,0, */
	/* 5d00 */ -1, 6,-1,-1,-1,-1, 6, 4, -1,-1,-1, 4,-1, 6, 4,-1, /* 0,'崁',0,0,0,0,'崆','崇', 0,0,0,'崋',0,'崍','崎',0, */
	/* 5d10 */ -1, 4, 6,-1, 4, 4, 4, 4,  4, 4, 4, 4,-1,-1,-1, 4, /* 0,'崑','崒',0,'崔','崕','崖','崗', '崘','崙','崚','崛',0,0,0,'崟', */
	/* 5d20 */ -1,-1, 4, 6, 6,-1, 6, 6, -1, 4,-1, 6,-1,-1,-1,-1, /* 0,0,'崢','崣','崤',0,'崦','崧', 0,'崩',0,'崫',0,0,0,0, */
	/* 5d30 */ -1, 6,-1,-1, 6,-1,-1,-1, -1, 6,-1,-1,-1, 6,-1, 6, /* 0,'崱',0,0,'崴',0,0,0, 0,'崹',0,0,0,'崽',0,'崿', */
	/* 5d40 */ -1,-1, 6, 6,-1,-1, 6,-1,  6,-1, 6, 4, 4,-1, 4,-1, /* 0,0,'嵂','嵃',0,0,'嵆',0, '嵈',0,'嵊','嵋','嵌',0,'嵎',0, */
	/* 5d50 */  4, 6, 4, 6,-1, 6,-1,-1, -1, 6,-1,-1, 4,-1,-1, 6, /* '嵐','嵑','嵒','嵓',0,'嵕',0,0, 0,'嵙',0,0,'嵜',0,0,'嵟', */
	/* 5d60 */  6, 6, 6,-1, 6,-1,-1,-1, -1, 4, 6,-1, 4, 6,-1, 4, /* '嵠','嵡','嵢',0,'嵤',0,0,0, 0,'嵩','嵪',0,'嵬','嵭',0,'嵯', */
	/* 5d70 */  6,-1,-1, 4,-1,-1, 4,-1, -1, 6, 6,-1,-1,-1, 6, 6, /* '嵰',0,0,'嵳',0,0,'嵶',0, 0,'嵹','嵺',0,0,0,'嵾','嵿', */
	/* 5d80 */ -1, 6, 4, 6, 4,-1,-1, 4,  6,-1, 6, 4, 4,-1,-1,-1, /* 0,'嶁','嶂','嶃','嶄',0,0,'嶇', '嶈',0,'嶊','嶋','嶌',0,0,0, */
	/* 5d90 */  4,-1, 6, 6, 6, 6,-1,-1, -1, 6,-1, 6,-1, 4,-1, 6, /* '嶐',0,'嶒','嶓','嶔','嶕',0,0, 0,'嶙',0,'嶛',0,'嶝',0,'嶟', */
	/* 5da0 */  6,-1, 4,-1,-1,-1,-1, 6, -1,-1,-1, 6, 4,-1, 4,-1, /* '嶠',0,'嶢',0,0,0,0,'嶧', 0,0,0,'嶫','嶬',0,'嶮',0, */
	/* 5db0 */  6,-1, 6,-1, 6,-1,-1, 4,  6, 6, 4,-1, 4, 4,-1,-1, /* '嶰',0,'嶲',0,'嶴',0,0,'嶷', '嶸','嶹','嶺',0,'嶼','嶽',0,0, */
	/* 5dc0 */ -1,-1,-1, 6,-1,-1,-1, 6, -1, 4,-1, 6, 4, 4, 6,-1, /* 0,0,0,'巃',0,0,0,'巇', 0,'巉',0,'巋','巌','巍','巎',0, */
	/* 5dd0 */  6,-1, 4, 4,-1,-1, 4,-1,  6, 6,-1, 4,-1, 4, 4,-1, /* '巐',0,'巒','巓',0,0,'巖',0, '巘','巙',0,'巛',0,'川','州',0, */
	/* 5de0 */  6, 4,-1, 4, 6, 4, 4, 4,  4, 6,-1, 4,-1,-1, 4,-1, /* '巠','巡',0,'巣','巤','工','左','巧', '巨','巩',0,'巫',0,0,'差',0, */
	/* 5df0 */ -1, 4, 4, 4, 4, 4,-1, 4,  6, 6,-1, 4,-1, 4, 4,-1, /* 0,'己','已','巳','巴','巵',0,'巷', '巸','巹',0,'巻',0,'巽','巾',0, */
	/* 5e00 */  6,-1, 4, 4,-1,-1, 4, 6, -1,-1,-1, 4, 4, 6,-1,-1, /* '帀',0,'市','布',0,0,'帆','帇', 0,0,0,'帋','希','帍',0,0, */
	/* 5e10 */ -1, 4, 6,-1, 6, 6, 4,-1,  6, 4, 4, 4,-1, 4,-1, 6, /* 0,'帑','帒',0,'帔','帕','帖',0, '帘','帙','帚','帛',0,'帝',0,'帟', */
	/* 5e20 */  6,-1,-1,-1,-1, 4,-1,-1,  6,-1,-1, 4,-1, 4, 6, 4, /* '帠',0,0,0,0,'帥',0,0, '帨',0,0,'師',0,'席','帮','帯', */
	/* 5e30 */  4,-1, 6, 4,-1, 6, 4, 4,  4,-1,-1,-1,-1, 4, 6,-1, /* '帰',0,'帲','帳',0,'帵','帶','帷', '常',0,0,0,0,'帽','帾',0, */
	/* 5e40 */  4,-1,-1, 4, 4, 4,-1, 4, -1, 6,-1, 6, 4,-1, 4,-1, /* '幀',0,0,'幃','幄','幅',0,'幇', 0,'幉',0,'幋','幌',0,'幎',0, */
	/* 5e50 */  6, 6,-1,-1, 4, 4, 6, 4,  6,-1,-1, 6, 6,-1, 6, 4, /* '幐','幑',0,0,'幔','幕','幖','幗', '幘',0,0,'幛','幜',0,'幞','幟', */
	/* 5e60 */ -1, 4, 4, 4, 4,-1,-1,-1,  6,-1, 6, 6, 6, 6, 6,-1, /* 0,'幡','幢','幣','幤',0,0,0, '幨',0,'幪','幫','幬','幭','幮',0, */
	/* 5e70 */  6,-1, 4, 4, 4, 4, 4,-1,  4, 4, 4, 4, 4, 4, 4, 4, /* '幰',0,'干','平','年','幵','并',0, '幸','幹','幺','幻','幼','幽','幾','广', */
	/* 5e80 */  6, 4,-1, 4, 4,-1,-1, 4, -1,-1, 4, 6,-1,-1, 6, 4, /* '庀','庁',0,'広','庄',0,0,'庇', 0,0,'床','庋',0,0,'庎','序', */
	/* 5e90 */ -1,-1,-1,-1,-1, 4, 4, 4, -1,-1, 4,-1, 4,-1,-1,-1, /* 0,0,0,0,0,'底','庖','店', 0,0,'庚',0,'府',0,0,0, */
	/* 5ea0 */  4,-1, 6,-1, 6, 6, 4, 4,  6,-1, 6, 4, 6, 4,-1,-1, /* '庠',0,'庢',0,'庤','庥','度','座', '庨',0,'庪','庫','庬','庭',0,0, */
	/* 5eb0 */ -1, 6,-1, 6,-1, 4, 4, 4,  4,-1,-1,-1,-1, 6, 6, 6, /* 0,'庱',0,'庳',0,'庵','庶','康', '庸',0,0,0,0,'庽','庾','庿', */
	/* 5ec0 */ -1, 4, 4, 4,-1,-1, 6,-1,  4, 4, 4, 6, 6,-1, 6, 4, /* 0,'廁','廂','廃',0,0,'廆',0, '廈','廉','廊','廋','廌',0,'廎','廏', */
	/* 5ed0 */  4, 6, 6, 4, 6, 6, 4,-1, -1,-1, 4, 4, 6, 4, 6, 4, /* '廐','廑','廒','廓','廔','廕','廖',0, 0,0,'廚','廛','廜','廝','廞','廟', */
	/* 5ee0 */  4, 4, 4, 4,-1, 6,-1,-1,  4, 4,-1, 6, 4,-1,-1,-1, /* '廠','廡','廢','廣',0,'廥',0,0, '廨','廩',0,'廫','廬',0,0,0, */
	/* 5ef0 */  4, 4,-1, 4, 4,-1, 4, 4,  4,-1, 4, 4, 4,-1, 4, 4, /* '廰','廱',0,'廳','廴',0,'延','廷', '廸',0,'建','廻','廼',0,'廾','廿', */
	/* 5f00 */ -1, 4, 6, 4, 4,-1, 6, 6,  6, 4, 4, 4, 4, 4, 6, 4, /* 0,'弁','异','弃','弄',0,'弆','弇', '弈','弉','弊','弋','弌','弍','弎','式', */
	/* 5f10 */  4, 4,-1, 4, 4, 4, 4, 4,  4, 6,-1, 4, 6, 6,-1, 4, /* '弐','弑',0,'弓','弔','引','弖','弗', '弘','弙',0,'弛','弜','弝',0,'弟', */
	/* 5f20 */ -1, 6, 6, 6, 6, 4, 4, 4,  6, 4,-1, 6, 6, 4, 6, 4, /* 0,'弡','弢','弣','弤','弥','弦','弧', '弨','弩',0,'弫','弬','弭','弮','弯', */
	/* 5f30 */  6, 4,-1,-1, 6, 4, 6, 4,  4,-1,-1, 6, 4, 6, 4, 6, /* '弰','弱',0,0,'弴','張','弶','強', '弸',0,0,'弻','弼','弽','弾','弿', */
	/* 5f40 */  6, 4,-1,-1, 6, 6,-1, 6,  4,-1, 4,-1, 4, 6, 4,-1, /* '彀','彁',0,0,'彄','彅',0,'彇', '彈',0,'彊',0,'彌','彍','彎',0, */
	/* 5f50 */  6, 4,-1, 4, 6,-1, 4, 4,  6, 4,-1, 6, 4, 4,-1,-1, /* '彐','彑',0,'当','彔',0,'彖','彗', '彘','彙',0,'彛','彜','彝',0,0, */
	/* 5f60 */  6, 4, 4, 6, 6,-1, 4, 6, -1, 4, 4, 4, 4, 4,-1, 6, /* '彠','彡','形','彣','彤',0,'彦','彧', 0,'彩','彪','彫','彬','彭',0,'彯', */
	/* 5f70 */  4, 4, 6, 4, 6, 6,-1, 4,  6, 4, 6,-1, 4, 6, 6, 4, /* '彰','影','彲','彳','彴','彵',0,'彷', '彸','役','彺',0,'彼','彽','彾','彿', */
	/* 5f80 */  4, 4, 4, 4, 4, 4,-1, 4,  4, 6, 4, 4, 4, 6,-1, 6, /* '往','征','徂','徃','径','待',0,'徇', '很','徉','徊','律','後','徍',0,'徏', */
	/* 5f90 */  4, 4, 4, 4,-1,-1, 6, 4,  4, 4,-1,-1, 6, 6, 4,-1, /* '徐','徑','徒','従',0,0,'徖','得', '徘','徙',0,0,'徜','徝','從',0, */
	/* 5fa0 */  4, 4, 6,-1, 6,-1,-1, 6,  4, 4, 4, 6, 6, 4, 4, 6, /* '徠','御','徢',0,'徤',0,0,'徧', '徨','復','循','徫','徬','徭','微','徯', */
	/* 5fb0 */  6, 6,-1, 4, 4,-1,-1, 6,  6, 4,-1,-1, 4, 4,-1,-1, /* '徰','徱',0,'徳','徴',0,0,'德', '徸','徹',0,0,'徼','徽',0,0, */
	/* 5fc0 */ -1,-1,-1, 4, 6, 4,-1, 6,  6, 6,-1, 6, 4, 4,-1,-1, /* 0,0,0,'心','忄','必',0,'忇', '忈','忉',0,'忋','忌','忍',0,0, */
	/* 5fd0 */  6, 6, 6, 6, 6,-1, 4, 4,  4, 4,-1,-1, 4, 4, 6,-1, /* '忐','忑','忒','忓','忔',0,'忖','志', '忘','忙',0,0,'応','忝','忞',0, */
	/* 5fe0 */  4, 6, 6,-1, 4,-1,-1,-1,  6, 6, 6, 4, 6, 6, 6, 6, /* '忠','忡','忢',0,'忤',0,0,0, '忨','忩','忪','快','忬','忭','忮','忯', */
	/* 5ff0 */  4, 4, 6, 6,-1, 4, 6,-1,  4,-1, 6, 4, 6, 4,-1, 4, /* '忰','忱','忲','忳',0,'念','忶',0, '忸',0,'忺','忻','忼','忽',0,'忿', */
	/* 6000 */ -1,-1,-1,-1,-1,-1,-1, 6, -1,-1, 6,-1,-1, 6, 4, 4, /* 0,0,0,0,0,0,0,'怇', 0,0,'怊',0,0,'怍','怎','怏', */
	/* 6010 */  4,-1, 4, 6, 6, 4, 4, 6,  6, 4, 6, 4, 4, 4,-1, 6, /* '怐',0,'怒','怓','怔','怕','怖','怗', '怘','怙','怚','怛','怜','思',0,'怟', */
	/* 6020 */  4, 4,-1,-1, 6, 4, 4, 4,  4, 4, 4, 4,-1, 6,-1, 4, /* '怠','怡',0,0,'怤','急','怦','性', '怨','怩','怪','怫',0,'怭',0,'怯', */
	/* 6030 */ -1, 4,-1, 6,-1, 6,-1,-1, -1,-1, 4,-1,-1,-1,-1,-1, /* 0,'怱',0,'怳',0,'怵',0,0, 0,0,'怺',0,0,0,0,0, */
	/* 6040 */  6, 4, 4, 4,-1,-1, 4, 6,  6, 6, 4, 4, 6, 4,-1,-1, /* '恀','恁','恂','恃',0,0,'恆','恇', '恈','恉','恊','恋','恌','恍',0,0, */
	/* 6050 */  4, 6, 4,-1, 6, 4, 6, 6, -1, 4, 4,-1,-1, 6,-1, 4, /* '恐','恑','恒',0,'恔','恕','恖','恗', 0,'恙','恚',0,0,'恝',0,'恟', */
	/* 6060 */  4, 6, 4, 4, 4, 4,-1, 6,  4, 4, 4, 4, 4, 4,-1, 4, /* '恠','恡','恢','恣','恤','恥',0,'恧', '恨','恩','恪','恫','恬','恭',0,'息', */
	/* 6070 */  4, 6,-1,-1,-1, 4,-1, 4, -1,-1,-1,-1,-1,-1, 6, 6, /* '恰','恱',0,0,0,'恵',0,'恷', 0,0,0,0,0,0,'恾','恿', */
	/* 6080 */ -1, 4, 6, 4, 4, 6, 6,-1,  6, 4, 6, 4, 4, 4, 6,-1, /* 0,'悁','悂','悃','悄','悅','悆',0, '悈','悉','悊','悋','悌','悍','悎',0, */
	/* 6090 */ -1, 6, 4, 6, 4, 6, 4, 4,  6,-1, 4, 4,-1, 6, 6, 4, /* 0,'悑','悒','悓','悔','悕','悖','悗', '悘',0,'悚','悛',0,'悝','悞','悟', */
	/* 60a0 */  4,-1, 6, 4, 6, 6, 4, 4,  6, 4, 4,-1,-1,-1,-1,-1, /* '悠',0,'悢','患','悤','悥','悦','悧', '您','悩','悪',0,0,0,0,0, */
	/* 60b0 */  6, 6, 4, 4, 4, 4, 4, 6,  4,-1,-1, 6, 4, 4, 6,-1, /* '悰','悱','悲','悳','悴','悵','悶','悷', '悸',0,0,'悻','悼','悽','悾',0, */
	/* 60c0 */ -1,-1, 6,-1, 6, 4, 4, 4,  6, 6, 6, 6,-1,-1, 6, 6, /* 0,0,'惂',0,'惄','情','惆','惇', '惈','惉','惊','惋',0,0,'惎','惏', */
	/* 60d0 */ -1, 4,-1, 4, 6, 6,-1,-1,  4, 6, 4, 6, 4, 6, 6, 4, /* 0,'惑',0,'惓','惔','惕',0,0, '惘','惙','惚','惛','惜','惝','惞','惟', */
	/* 60e0 */  4, 4, 6, 4,-1, 6,-1, 4,  4,-1,-1,-1,-1,-1,-1,-1, /* '惠','惡','惢','惣',0,'惥',0,'惧', '惨',0,0,0,0,0,0,0, */
	/* 60f0 */  4, 4, 6, 4, 4, 6, 4, 4,  6, 4, 4, 4, 6, 6,-1,-1, /* '惰','惱','惲','想','惴','惵','惶','惷', '惸','惹','惺','惻','惼','惽',0,0, */
	/* 6100 */  4, 4, 6, 4,-1,-1, 4, 6,  4, 4, 6,-1, 6, 4, 4, 4, /* '愀','愁','愂','愃',0,0,'愆','愇', '愈','愉','愊',0,'愌','愍','愎','意', */
	/* 6110 */  6, 6, 6, 6, 6, 4, 6, 6, -1, 6, 4, 4, 6,-1, 6, 4, /* '愐','愑','愒','愓','愔','愕','愖','愗', 0,'愙','愚','愛','愜',0,'愞','感', */
	/* 6120 */  6, 4, 6,-1,-1,-1,-1, 4,  4,-1, 6, 6, 4,-1,-1,-1, /* '愠','愡','愢',0,0,0,0,'愧', '愨',0,'愪','愫','愬',0,0,0, */
	/* 6130 */  6, 6,-1,-1, 4, 6, 6, 6, -1, 6,-1,-1, 4, 4, 4, 4, /* '愰','愱',0,0,'愴','愵','愶','愷', 0,'愹',0,0,'愼','愽','愾','愿', */
	/* 6140 */ -1, 6, 4,-1, 4, 6, 6, 4,  4, 6, 4, 4, 4, 4, 4,-1, /* 0,'慁','慂',0,'慄','慅','慆','慇', '慈','慉','慊','態','慌','慍','慎',0, */
	/* 6150 */ -1,-1,-1, 4,-1, 4,-1,-1,  4, 4, 4,-1,-1, 4, 6, 4, /* 0,0,0,'慓',0,'慕',0,0, '慘','慙','慚',0,0,'慝','慞','慟', */
	/* 6160 */  6,-1, 4, 4,-1, 4,-1, 4,  4,-1,-1, 4, 6,-1, 4, 4, /* '慠',0,'慢','慣',0,'慥',0,'慧', '慨',0,0,'慫','慬',0,'慮','慯', */
	/* 6170 */  4, 4, 6, 4, 4, 4, 4, 4,  6,-1,-1, 6, 6,-1, 4, 6, /* '慰','慱','慲','慳','慴','慵','慶','慷', '慸',0,0,'慻','慼',0,'慾','慿', */
	/* 6180 */  6, 6, 4, 6, 6,-1,-1, 4, -1,-1, 4, 6,-1, 6, 4,-1, /* '憀','憁','憂','憃','憄',0,0,'憇', 0,0,'憊','憋',0,'憍','憎',0, */
	/* 6190 */  4, 4, 6, 6, 4,-1, 4, 6,  6, 4, 4,-1, 6, 6,-1, 6, /* '憐','憑','憒','憓','憔',0,'憖','憗', '憘','憙','憚',0,'憜','憝',0,'憟', */
	/* 61a0 */  6,-1,-1,-1, 4, 6,-1, 4,  6, 4, 6, 4, 4, 6, 4,-1, /* '憠',0,0,0,'憤','憥',0,'憧', '憨','憩','憪','憫','憬','憭','憮',0, */
	/* 61b0 */ -1,-1, 4,-1,-1,-1, 4,-1,  6, 6, 4,-1, 6,-1, 4,-1, /* 0,0,'憲',0,0,0,'憶',0, '憸','憹','憺',0,'憼',0,'憾',0, */
	/* 61c0 */  6, 6, 6, 4,-1,-1, 4, 4,  4, 4, 4, 4, 4, 4, 6, 6, /* '懀','懁','懂','懃',0,0,'懆','懇', '懈','應','懊','懋','懌','懍','懎','懏', */
	/* 61d0 */  4,-1,-1,-1,-1, 6,-1,-1, -1,-1,-1,-1, 6, 6, 6, 6, /* '懐',0,0,0,0,'懕',0,0, 0,0,0,0,'懜','懝','懞','懟', */
	/* 61e0 */ -1, 6, 6, 4,-1, 6, 4, 6, -1, 6,-1,-1, 6, 6,-1, 6, /* 0,'懡','懢','懣',0,'懥','懦','懧', 0,'懩',0,0,'懬','懭',0,'懯', */
	/* 61f0 */ -1,-1, 4,-1, 4,-1, 4, 4,  4,-1, 4,-1, 4, 4, 4, 4, /* 0,0,'懲',0,'懴',0,'懶','懷', '懸',0,'懺',0,'懼','懽','懾','懿', */
	/* 6200 */  4, 6,-1, 6, 6,-1,-1, 6,  4, 4, 4,-1, 4, 4, 4,-1, /* '戀','戁',0,'戃','戄',0,0,'戇', '戈','戉','戊',0,'戌','戍','戎',0, */
	/* 6210 */  4, 4, 4, 6, 4, 6, 4,-1, -1,-1, 4, 4, 6, 4, 4, 4, /* '成','我','戒','戓','戔','戕','或',0, 0,0,'戚','戛','戜','戝','戞','戟', */
	/* 6220 */  6, 4, 6, 6,-1,-1, 4, 6, -1, 6, 4, 6,-1,-1, 4, 4, /* '戠','戡','戢','戣',0,0,'戦','戧', 0,'戩','截','戫',0,0,'戮','戯', */
	/* 6230 */  4,-1, 4, 4, 4,-1,-1,-1,  4, 6,-1, 4,-1, 6,-1, 4, /* '戰',0,'戲','戳','戴',0,0,0, '戸','戹',0,'戻',0,'戽',0,'房', */
	/* 6240 */  4, 4, 6, 6, 6,-1, 6, 4,  4, 4,-1, 4, 6, 4, 4,-1, /* '所','扁','扂','扃','扄',0,'扆','扇', '扈','扉',0,'手','扌','才','扎',0, */
	/* 6250 */  6, 6, 6, 4, 6, 4, 6,-1,  4,-1, 6, 4, 6,-1, 4,-1, /* '扐','扑','扒','打','扔','払','扖',0, '托',0,'扚','扛','扜',0,'扞',0, */
	/* 6260 */  4,-1,-1, 4, 6,-1,-1,-1,  4,-1,-1,-1,-1, 6, 4, 6, /* '扠',0,0,'扣','扤',0,0,0, '扨',0,0,0,0,'扭','扮','扯', */
	/* 6270 */ -1, 4,-1, 6,-1,-1, 4,-1, -1, 4, 6,-1, 4, 6, 4, 4, /* 0,'扱',0,'扳',0,0,'扶',0, 0,'批','扺',0,'扼','扽','找','承', */
	/* 6280 */  4,-1, 4, 4, 4,-1,-1,-1, -1, 4, 4,-1,-1, 6, 6, 6, /* '技',0,'抂','抃','抄',0,0,0, 0,'抉','把',0,0,'抍','抎','抏', */
	/* 6290 */  6, 4, 4, 4, 4, 4, 4, 4,  4,-1,-1, 4, 4,-1, 4,-1, /* '抐','抑','抒','抓','抔','投','抖','抗', '折',0,0,'抛','抜',0,'択',0, */
	/* 62a0 */ -1,-1,-1,-1,-1,-1, 6,-1,  6,-1,-1, 4, 4,-1,-1,-1, /* 0,0,0,0,0,0,'抦',0, '抨',0,0,'披','抬',0,0,0, */
	/* 62b0 */ -1, 4,-1, 6,-1, 4, 6, 6, -1, 4, 6, 4, 4, 4, 6, 6, /* 0,'抱',0,'抳',0,'抵','抶','抷', 0,'抹','抺','抻','押','抽','抾','抿', */
	/* 62c0 */ -1,-1, 4,-1, 6, 4, 4, 4,  4, 4, 4,-1, 4, 4, 6, 4, /* 0,0,'拂',0,'拄','担','拆','拇', '拈','拉','拊',0,'拌','拍','拎','拏', */
	/* 62d0 */  4, 4, 4, 4, 4, 6, 6, 4,  4, 4, 6, 4, 4, 4,-1,-1, /* '拐','拑','拒','拓','拔','拕','拖','拗', '拘','拙','拚','招','拜','拝',0,0, */
	/* 62e0 */  4, 4,-1,-1,-1,-1,-1,-1, -1,-1, 6,-1, 4, 4, 4, 4, /* '拠','拡',0,0,0,0,0,0, 0,0,'拪',0,'括','拭','拮','拯', */
	/* 62f0 */ -1, 4, 6, 4, 6, 4, 4, 4, -1,-1,-1,-1, 6, 6, 4, 4, /* 0,'拱','拲','拳','拴','拵','拶','拷', 0,0,0,0,'拼','拽','拾','拿', */
	/* 6300 */ -1, 4, 4, 6, 6,-1,-1, 4,  4, 4, 6, 6, 4, 6,-1,-1, /* 0,'持','挂','挃','挄',0,0,'指', '挈','按','挊','挋','挌','挍',0,0, */
	/* 6310 */  6, 4,-1, 6,-1,-1, 6,-1,  6, 4,-1,-1,-1,-1,-1, 4, /* '挐','挑',0,'挓',0,0,'挖',0, '挘','挙',0,0,0,0,0,'挟', */
	/* 6320 */ -1,-1,-1,-1,-1,-1,-1, 4,  4, 6, 6, 4,-1, 6,-1, 4, /* 0,0,0,0,0,0,0,'挧', '挨','挩','挪','挫',0,'挭',0,'振', */
	/* 6330 */ -1,-1,-1,-1,-1, 6, 6,-1, -1, 6, 4,-1, 6, 4, 4, 4, /* 0,0,0,0,0,'挵','挶',0, 0,'挹','挺',0,'挼','挽','挾','挿', */
	/* 6340 */ -1, 6, 6, 6, 6,-1, 6,-1, -1, 4, 6, 6, 4, 4, 6, 4, /* 0,'捁','捂','捃','捄',0,'捆',0, 0,'捉','捊','捋','捌','捍','捎','捏', */
	/* 6350 */  4,-1, 6, 6, 6, 4,-1, 4,  6,-1,-1, 6, 4,-1,-1,-1, /* '捐',0,'捒','捓','捔','捕',0,'捗', '捘',0,0,'捛','捜',0,0,0, */
	/* 6360 */ -1,-1,-1,-1,-1, 6, 6, 4,  4, 4,-1, 4, 6, 6, 4,-1, /* 0,0,0,0,0,'捥','捦','捧', '捨','捩',0,'捫','捬','捭','据',0, */
	/* 6370 */ -1, 6, 4,-1, 6, 6, 4, 4,  6,-1, 4, 4, 6, 6,-1, 6, /* 0,'捱','捲',0,'捴','捵','捶','捷', '捸',0,'捺','捻','捼','捽',0,'捿', */
	/* 6380 */  4,-1, 6, 4, 6,-1,-1, 6,  4, 4, 6,-1, 4,-1, 4, 4, /* '掀',0,'掂','掃','掄',0,0,'掇', '授','掉','掊',0,'掌',0,'掎','掏', */
	/* 6390 */  6,-1, 4,-1, 6, 6, 4,-1,  4, 6, 6, 4,-1,-1, 6, 4, /* '掐',0,'排',0,'掔','掕','掖',0, '掘','掙','掚','掛',0,0,'掞','掟', */
	/* 63a0 */  4, 4, 4, 4, 6, 4, 6, 4,  4, 4, 4, 4, 4, 6, 6, 6, /* '掠','採','探','掣','掤','接','掦','控', '推','掩','措','掫','掬','掭','掮','掯', */
	/* 63b0 */ -1,-1, 4,-1, 4, 4,-1,-1, -1,-1,-1, 4,-1, 6, 4,-1, /* 0,0,'掲',0,'掴','掵',0,0, 0,0,0,'掻',0,'掽','掾',0, */
	/* 63c0 */  4, 6,-1, 4, 4, 6, 4,-1,  6, 4,-1,-1,-1,-1, 6, 4, /* '揀','揁',0,'揃','揄','揅','揆',0, '揈','揉',0,0,0,0,'揎','描', */
	/* 63d0 */  4, 6, 4, 6, 6, 6, 4,-1, -1,-1, 4, 4, 6,-1,-1,-1, /* '提','揑','插','揓','揔','揕','揖',0, 0,0,'揚','換','揜',0,0,0, */
	/* 63e0 */  6, 4,-1, 4,-1, 6,-1,-1, -1, 4, 6,-1, 6,-1, 4,-1, /* '揠','握',0,'揣',0,'揥',0,0, 0,'揩','揪',0,'揬',0,'揮',0, */
	/* 63f0 */ -1,-1, 6, 6, 4, 6, 4,-1,  6, 6, 4,-1,-1,-1,-1,-1, /* 0,0,'揲','揳','援','揵','揶',0, '揸','揹','揺',0,0,0,0,0, */
	/* 6400 */ -1,-1,-1,-1,-1,-1, 4,-1, -1, 6, 6,-1,-1, 4,-1, 4, /* 0,0,0,0,0,0,'搆',0, 0,'搉','搊',0,0,'損',0,'搏', */
	/* 6410 */  6,-1, 6, 4, 6,-1, 4, 4,  6,-1,-1,-1, 4,-1, 6,-1, /* '搐',0,'搒','搓','搔',0,'搖','搗', '搘',0,0,0,'搜',0,'搞',0, */
	/* 6420 */  6,-1, 6,-1, 6, 6, 4,-1,  4, 6, 6,-1, 4, 4,-1, 6, /* '搠',0,'搢',0,'搤','搥','搦',0, '搨','搩','搪',0,'搬','搭',0,'搯', */
	/* 6430 */  6,-1,-1,-1, 4, 6, 4,-1, -1,-1, 4,-1,-1, 6, 4, 6, /* '搰',0,0,0,'搴','搵','搶',0, 0,0,'携',0,0,'搽','搾','搿', */
	/* 6440 */ -1,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1, 6,-1,-1, 4, 6, /* 0,0,'摂',0,0,0,0,0, 0,0,0,'摋',0,0,'摎','摏', */
	/* 6450 */ -1, 6, 6, 6, 6,-1,-1,-1,  4,-1, 6, 6, 6, 6,-1, 6, /* 0,'摑','摒','摓','摔',0,0,0, '摘',0,'摚','摛','摜','摝',0,'摟', */
	/* 6460 */  6, 6,-1, 6,-1,-1,-1, 4, -1, 4,-1,-1,-1, 6,-1, 4, /* '摠','摡',0,'摣',0,0,0,'摧', 0,'摩',0,0,0,'摭',0,'摯', */
	/* 6470 */ -1,-1,-1, 6, 6,-1, 4,-1,  4,-1, 4, 6,-1, 6,-1,-1, /* 0,0,0,'摳','摴',0,'摶',0, '摸',0,'摺','摻',0,'摽',0,0, */
	/* 6480 */ -1,-1,-1, 4,-1, 6,-1, 6,  4,-1,-1,-1,-1,-1,-1, 6, /* 0,0,0,'撃',0,'撅',0,'撇', '撈',0,0,0,0,0,0,'撏', */
	/* 6490 */  6, 6, 4, 4,-1, 4,-1,-1,  6, 6, 4, 6,-1, 6, 4, 6, /* '撐','撑','撒','撓',0,'撕',0,0, '撘','撙','撚','撛',0,'撝','撞','撟', */
	/* 64a0 */ -1, 6,-1, 6, 4, 4, 6,-1,  6, 4,-1, 4, 6, 4, 4,-1, /* 0,'撡',0,'撣','撤','撥','撦',0, '撨','撩',0,'撫','撬','播','撮',0, */
	/* 64b0 */  4,-1, 4, 6,-1,-1,-1,-1, -1, 4,-1, 4, 4, 6, 6, 6, /* '撰',0,'撲','撳',0,0,0,0, 0,'撹',0,'撻','撼','撽','撾','撿', */
	/* 64c0 */ -1, 4, 4,-1, 6, 4,-1, 4, -1, 6, 6, 6, 6, 4, 6,-1, /* 0,'擁','擂',0,'擄','擅',0,'擇', 0,'擉','擊','擋','擌','操','擎',0, */
	/* 64d0 */  6, 6, 4,-1, 4, 6,-1, 6,  4,-1, 4,-1,-1,-1,-1,-1, /* '擐','擑','擒',0,'擔','擕',0,'擗', '擘',0,'據',0,0,0,0,0, */
	/* 64e0 */  4, 4, 4, 4, 6, 6, 4, 4, -1, 6, 6,-1, 4, 6,-1, 4, /* '擠','擡','擢','擣','擤','擥','擦','擧', 0,'擩','擪',0,'擬','擭',0,'擯', */
	/* 64f0 */  6, 4, 4,-1, 4, 6, 4, 6, -1,-1, 4, 6,-1, 4, 4, 6, /* '擰','擱','擲',0,'擴','擵','擶','擷', 0,0,'擺','擻',0,'擽','擾','擿', */
	/* 6500 */  4, 6,-1,-1, 6, 4,-1,-1,  6, 6, 6,-1,-1,-1,-1, 6, /* '攀','攁',0,0,'攄','攅',0,0, '攈','攉','攊',0,0,0,0,'攏', */
	/* 6510 */ -1,-1,-1, 6, 6,-1, 6,-1,  4, 6,-1, 6, 4, 4, 6, 6, /* 0,0,0,'攓','攔',0,'攖',0, '攘','攙',0,'攛','攜','攝','攞','攟', */
	/* 6520 */ -1,-1, 6, 4, 4,-1, 6,-1, -1, 6, 4, 4, 4,-1, 6, 4, /* 0,0,'攢','攣','攤',0,'攦',0, 0,'攩','攪','攫','攬',0,'攮','支', */
	/* 6530 */ -1, 6,-1,-1, 4, 4, 4, 4,  4, 4, 6, 4, 6, 6, 4, 4, /* 0,'攱',0,0,'攴','攵','收','攷', '攸','改','攺','攻','攼','攽','放','政', */
	/* 6540 */ -1,-1,-1, 6,-1, 4,-1, 6,  4, 6,-1,-1,-1, 4, 6, 4, /* 0,0,0,'敃',0,'故',0,'敇', '效','敉',0,0,0,'敍','敎','敏', */
	/* 6550 */  6, 4, 6,-1, 6, 4, 4, 4,  4, 4,-1,-1,-1, 4, 4, 6, /* '敐','救','敒',0,'敔','敕','敖','敗', '敘','教',0,0,0,'敝','敞','敟', */
	/* 6560 */  6,-1, 4, 4,-1,-1, 4, 6, -1,-1,-1, 6, 4,-1,-1,-1, /* '敠',0,'敢','散',0,0,'敦','敧', 0,0,0,'敫','敬',0,0,0, */
	/* 6570 */  4,-1, 4,-1, 4, 4,-1, 4,  4,-1, 6,-1,-1, 6,-1,-1, /* '数',0,'敲',0,'整','敵',0,'敷', '數',0,'敺',0,0,'敽',0,0, */
	/* 6580 */ -1, 6, 4, 4,-1, 6,-1, 4,  4, 4, 6,-1, 4,-1, 4,-1, /* 0,'斁','斂','斃',0,'斅',0,'文', '斈','斉','斊',0,'斌',0,'斎',0, */
	/* 6590 */  4, 4, 6,-1,-1, 6,-1, 4,  6, 4,-1, 4, 4, 6,-1, 4, /* '斐','斑','斒',0,0,'斕',0,'斗', '斘','料',0,'斛','斜','斝',0,'斟', */
	/* 65a0 */  6, 4,-1, 6, 4, 4, 6, 4, -1,-1,-1, 4, 4, 4, 6, 4, /* '斠','斡',0,'斣','斤','斥','斦','斧', 0,0,0,'斫','斬','断','斮','斯', */
	/* 65b0 */  4,-1, 6, 6, 6,-1,-1, 4, -1, 4,-1,-1, 4, 4,-1, 6, /* '新',0,'斲','斳','斴',0,0,'斷', 0,'方',0,0,'於','施',0,'斿', */
	/* 65c0 */ -1, 4, 6, 4, 4, 4, 4,-1,  6, 6,-1, 4, 4,-1, 6, 4, /* 0,'旁','旂','旃','旄','旅','旆',0, '旈','旉',0,'旋','旌',0,'旎','族', */
	/* 65d0 */  6,-1, 4,-1, 6,-1, 6, 4,  6, 4,-1, 4,-1,-1,-1, 6, /* '旐',0,'旒',0,'旔',0,'旖','旗', '旘','旙',0,'旛',0,0,0,'旟', */
	/* 65e0 */  4, 4, 4,-1,-1, 4, 4, 4,  4, 4,-1,-1, 4, 4,-1,-1, /* '无','旡','既',0,0,'日','旦','旧', '旨','早',0,0,'旬','旭',0,0, */
	/* 65f0 */  6, 4, 6,-1, 6, 6,-1,-1, -1, 6, 4, 4,-1,-1, 6, 6, /* '旰','旱','旲',0,'旴','旵',0,0, 0,'旹','旺','旻',0,0,'旾','旿', */
	/* 6600 */  6,-1, 4, 4, 6,-1, 4, 4,  6, 6, 4,-1, 4, 6, 4, 4, /* '昀',0,'昂','昃','昄',0,'昆','昇', '昈','昉','昊',0,'昌','昍','明','昏', */
	/* 6610 */ -1, 6, 6, 4, 4, 6, 6,-1, -1,-1,-1,-1, 4, 6, 6, 4, /* 0,'昑','昒','易','昔','昕','昖',0, 0,0,0,0,'昜','昝','昞','星', */
	/* 6620 */  4, 6, 6, 6, 6, 4, 6, 4,  4, 6, 6, 6, 6, 4, 6, 4, /* '映','昡','昢','昣','昤','春','昦','昧', '昨','昩','昪','昫','昬','昭','昮','是', */
	/* 6630 */  6, 6,-1, 6, 4, 4, 4, 6, -1, 6,-1,-1, 4,-1,-1, 4, /* '昰','昱',0,'昳','昴','昵','昶','昷', 0,'昹',0,0,'昼',0,0,'昿', */
	/* 6640 */  6, 4, 4, 4, 4, 6, 6,-1, -1, 4, 6, 4, 6,-1, 6, 4, /* '晀','晁','時','晃','晄','晅','晆',0, 0,'晉','晊','晋','晌',0,'晎','晏', */
	/* 6650 */ -1, 6, 4,-1,-1,-1,-1, 6,  6, 6,-1, 6, 6, 4, 4, 4, /* 0,'晑','晒',0,0,0,0,'晗', '晘','晙',0,'晛','晜','晝','晞','晟', */
	/* 6660 */  6, 6, 4,-1, 4, 6, 4, 4,  4, 4, 6, 6, 6,-1, 4, 4, /* '晠','晡','晢',0,'晤','晥','晦','晧', '晨','晩','晪','晫','晬',0,'普','景', */
	/* 6670 */  4,-1,-1, 6, 4, 6, 4, 6,  6, 6, 4, 6, 6,-1, 6, 6, /* '晰',0,0,'晳','晴','晵','晶','晷', '晸','晹','智','晻','晼',0,'晾','晿', */
	/* 6680 */  6, 4,-1, 4, 4,-1,-1, 4,  4, 4,-1, 6, 6, 6, 4,-1, /* '暀','暁',0,'暃','暄',0,0,'暇', '暈','暉',0,'暋','暌','暍','暎',0, */
	/* 6690 */  6, 4, 6,-1,-1,-1, 4, 4,  4, 6, 6, 6, 6, 4,-1, 6, /* '暐','暑','暒',0,0,0,'暖','暗', '暘','暙','暚','暛','暜','暝',0,'暟', */
	/* 66a0 */  6,-1, 4,-1, 6,-1, 4,-1, -1,-1,-1, 4,-1, 6, 4,-1, /* '暠',0,'暢',0,'暤',0,'暦',0, 0,0,0,'暫',0,'暭','暮',0, */
	/* 66b0 */ -1, 6, 6,-1, 4, 6,-1,-1,  4, 4,-1, 6, 4,-1, 4, 6, /* 0,'暱','暲',0,'暴','暵',0,0, '暸','暹',0,'暻','暼',0,'暾','暿', */
	/* 66c0 */  6, 4, 6, 6, 4,-1,-1, 4,  6, 4,-1,-1, 6,-1, 6, 6, /* '曀','曁','曂','曃','曄',0,0,'曇', '曈','曉',0,0,'曌',0,'曎','曏', */
	/* 66d0 */ -1,-1,-1,-1, 6,-1, 4,-1, -1, 4, 4, 6, 4, 4,-1, 6, /* 0,0,0,0,'曔',0,'曖',0, 0,'曙','曚','曛','曜','曝',0,'曟', */
	/* 66e0 */  4,-1,-1,-1,-1,-1, 4,-1,  6, 4,-1, 6, 6,-1, 6,-1, /* '曠',0,0,0,0,0,'曦',0, '曨','曩',0,'曫','曬',0,'曮',0, */
	/* 66f0 */  4,-1, 4, 4, 4, 4,-1, 4,  4, 4, 6, 6, 4, 4, 4, 4, /* '曰',0,'曲','曳','更','曵',0,'曷', '書','曹','曺','曻','曼','曽','曾','替', */
	/* 6700 */  4,-1,-1, 4,-1, 6,-1, 6,  4, 4,-1, 4,-1, 4, 6, 4, /* '最',0,0,'會',0,'朅',0,'朇', '月','有',0,'朋',0,'服','朎','朏', */
	/* 6710 */ -1,-1,-1, 6, 4, 4, 4, 4, -1, 6,-1, 4, 6, 4, 4, 4, /* 0,0,0,'朓','朔','朕','朖','朗', 0,'朙',0,'望','朜','朝','朞','期', */
	/* 6720 */  6,-1, 6,-1,-1,-1, 4, 4,  4,-1, 4, 4, 4, 4, 4,-1, /* '朠',0,'朢',0,0,0,'朦','朧', '木',0,'未','末','本','札','朮',0, */
	/* 6730 */ -1, 4,-1, 6, 4,-1, 4, 4,  4,-1, 4,-1,-1, 4, 6, 4, /* 0,'朱',0,'朳','朴',0,'朶','朷', '朸',0,'机',0,0,'朽','朾','朿', */
	/* 6740 */ -1, 4,-1,-1,-1, 6, 4, 6,  6, 4,-1,-1, 6,-1, 4, 4, /* 0,'杁',0,0,0,'杅','杆','杇', '杈','杉',0,0,'杌',0,'李','杏', */
	/* 6750 */  4, 4,-1, 4, 6, 6, 4,-1, -1, 4,-1,-1, 4, 6, 4, 4, /* '材','村',0,'杓','杔','杕','杖',0, 0,'杙',0,0,'杜','杝','杞','束', */
	/* 6760 */  4, 4, 4, 4, 4, 4, 6,-1, -1,-1, 4,-1, 6, 4, 6, 4, /* '杠','条','杢','杣','杤','来','杦',0, 0,0,'杪',0,'杬','杭','杮','杯', */
	/* 6770 */  4, 4, 4, 4, 6, 4, 6, 4, -1,-1,-1, 6, 4,-1, 4, 4, /* '杰','東','杲','杳','杴','杵','杶','杷', 0,0,0,'杻','杼',0,'松','板', */
	/* 6780 */ -1, 6,-1,-1, 6, 4,-1, 4, -1, 4,-1, 4, 4,-1, 6, 6, /* 0,'极',0,0,'构','枅',0,'枇', 0,'枉',0,'枋','枌',0,'枎','枏', */
	/* 6790 */  4, 6,-1, 6,-1, 4, 6, 4,  6, 6, 4, 6, 4, 4,-1,-1, /* '析','枑',0,'枓',0,'枕','枖','林', '枘','枙','枚','枛','果','枝',0,0, */
	/* 67a0 */  4, 4, 4,-1,-1,-1, 4,-1, -1, 4,-1,-1,-1,-1,-1, 4, /* '枠','枡','枢',0,0,0,'枦',0, 0,'枩',0,0,0,0,0,'枯', */
	/* 67b0 */  6, 6, 6, 4, 4, 6, 4, 4,  4, 4,-1, 6, 6, 6,-1,-1, /* '枰','枱','枲','枳','枴','枵','架','枷', '枸','枹',0,'枻','枼','枽',0,0, */
	/* 67c0 */  6, 4, 6, 6, 4, 6, 4,-1,  6, 6, 4,-1,-1,-1, 4, 4, /* '柀','柁','柂','柃','柄','柅','柆',0, '柈','柉','柊',0,0,0,'柎','柏', */
	/* 67d0 */  4, 4, 6, 4, 4,-1,-1, 6,  4, 6, 4,-1, 6, 4, 4,-1, /* '某','柑','柒','染','柔',0,0,'柗', '柘','柙','柚',0,'柜','柝','柞',0, */
	/* 67e0 */ -1, 6, 4,-1, 4,-1, 6, 4, -1, 4,-1,-1, 4,-1, 4, 4, /* 0,'柡','柢',0,'柤',0,'柦','柧', 0,'柩',0,0,'柬',0,'柮','柯', */
	/* 67f0 */  6, 4, 6, 4, 4, 4, 6, 6, -1, 6,-1, 4,-1,-1, 4, 4, /* '柰','柱','柲','柳','柴','柵','柶','柷', 0,'柹',0,'査',0,0,'柾','柿', */
	/* 6800 */ -1, 6, 4, 4, 4,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'栁','栂','栃','栄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6810 */ -1,-1,-1, 4, 6,-1, 4, 4, -1, 6,-1,-1,-1, 6, 4, 6, /* 0,0,0,'栓','栔',0,'栖','栗', 0,'栙',0,0,0,'栝','栞','栟', */
	/* 6820 */ -1, 4, 4,-1,-1,-1,-1, 6,  6, 4, 4, 4, 6, 6,-1, 6, /* 0,'校','栢',0,0,0,0,'栧', '栨','栩','株','栫','栬','栭',0,'栯', */
	/* 6830 */  6, 6, 4, 6, 4,-1,-1,-1,  4, 4,-1, 6, 4, 4,-1, 6, /* '栰','栱','栲','栳','栴',0,0,0, '核','根',0,'栻','格','栽',0,'栿', */
	/* 6840 */  4, 4, 4, 4, 6, 6, 4,-1,  4,-1, 6,-1, 6, 4, 4,-1, /* '桀','桁','桂','桃','桄','桅','框',0, '案',0,'桊',0,'桌','桍','桎',0, */
	/* 6850 */  4, 4, 6, 4, 4, 6,-1, 6,  6, 4,-1, 6, 4, 4,-1, 4, /* '桐','桑','桒','桓','桔','桕',0,'桗', '桘','桙',0,'桛','桜','桝',0,'桟', */
	/* 6860 */ -1,-1,-1, 4,-1,-1,-1, 4, -1,-1,-1, 6,-1,-1, 6, 6, /* 0,0,0,'档',0,0,0,'桧', 0,0,0,'桫',0,0,'桮','桯', */
	/* 6870 */  6, 6, 6,-1, 4, 6, 4, 4, -1, 6, 6, 6, 6,-1, 4, 4, /* '桰','桱','桲',0,'桴','桵','桶','桷', 0,'桹','桺','桻','桼',0,'桾','桿', */
	/* 6880 */ -1, 4, 6, 4, 6, 4, 6,-1,  6,-1,-1,-1,-1, 4,-1, 4, /* 0,'梁','梂','梃','梄','梅','梆',0, '梈',0,0,0,0,'梍',0,'梏', */
	/* 6890 */ -1,-1,-1, 4, 4,-1, 6, 4,  6,-1, 6, 4, 6, 4,-1, 4, /* 0,0,0,'梓','梔',0,'梖','梗', '梘',0,'梚','梛','梜','條',0,'梟', */
	/* 68a0 */  4, 6, 4, 6,-1, 6, 4, 4,  4, 6, 6,-1,-1, 4, 6, 4, /* '梠','梡','梢','梣',0,'梥','梦','梧', '梨','梩','梪',0,0,'梭','梮','梯', */
	/* 68b0 */  4, 4, 6, 4,-1, 4, 4,-1, -1, 4, 4, 6, 4,-1,-1,-1, /* '械','梱','梲','梳',0,'梵','梶',0, 0,'梹','梺','梻','梼',0,0,0, */
	/* 68c0 */ -1,-1,-1,-1, 4, 6, 4,-1,  6, 4, 4, 4, 6, 4,-1, 6, /* 0,0,0,0,'棄','棅','棆',0, '棈','棉','棊','棋','棌','棍',0,'棏', */
	/* 68d0 */  6, 6, 4, 6, 4, 4, 6, 4,  4, 6, 4,-1, 6, 6,-1, 4, /* '棐','棑','棒','棓','棔','棕','棖','棗', '棘','棙','棚',0,'棜','棝',0,'棟', */
	/* 68e0 */  4, 4,-1, 4,-1, 6,-1, 4,  6,-1, 6, 6, 6, 6, 4, 4, /* '棠','棡',0,'棣',0,'棥',0,'棧', '棨',0,'棪','棫','棬','棭','森','棯', */
	/* 68f0 */  6, 6, 4,-1,-1, 6, 6,-1, -1, 4, 4, 6, 6, 6,-1,-1, /* '棰','棱','棲',0,0,'棵','棶',0, 0,'棹','棺','棻','棼','棽',0,0, */
	/* 6900 */  4, 4,-1,-1, 4, 4, 6,-1,  4, 6, 6, 4, 4, 4, 4, 4, /* '椀','椁',0,0,'椄','椅','椆',0, '椈','椉','椊','椋','椌','植','椎','椏', */
	/* 6910 */  6, 6, 4, 6,-1,-1, 6, 6, -1, 4, 4, 4, 4,-1,-1,-1, /* '椐','椑','椒','椓',0,0,'椖','椗', 0,'椙','椚','椛','検',0,0,0, */
	/* 6920 */ -1, 4, 4, 4,-1, 4, 4,-1,  4,-1, 4,-1,-1,-1,-1,-1, /* 0,'椡','椢','椣',0,'椥','椦',0, '椨',0,'椪',0,0,0,0,0, */
	/* 6930 */  4, 6,-1, 6, 4, 6, 4,-1,  6, 4,-1, 6,-1, 4,-1, 4, /* '椰','椱',0,'椳','椴','椵','椶',0, '椸','椹',0,'椻',0,'椽',0,'椿', */
	/* 6940 */ -1,-1, 6,-1,-1, 6,-1,-1, -1, 6, 4,-1,-1,-1, 6,-1, /* 0,0,'楂',0,0,'楅',0,0, 0,'楉','楊',0,0,0,'楎',0, */
	/* 6950 */ -1,-1,-1, 4, 4, 4,-1, 6, -1, 4, 4, 6, 4, 4, 4,-1, /* 0,0,0,'楓','楔','楕',0,'楗', 0,'楙','楚','楛','楜','楝','楞',0, */
	/* 6960 */  4, 4, 4, 6, 6, 6, 6,-1,  6, 6, 4, 4, 6, 4, 4, 4, /* '楠','楡','楢','楣','楤','楥','楦',0, '楨','楩','楪','楫','楬','業','楮','楯', */
	/* 6970 */  6, 6, 6, 4, 4, 4,-1, 4,  4, 4, 6, 6, 4, 4, 4, 6, /* '楰','楱','楲','楳','楴','極',0,'楷', '楸','楹','楺','楻','楼','楽','楾','楿', */
	/* 6980 */  6, 4, 4,-1,-1,-1,-1,-1, -1,-1, 4,-1,-1, 6, 4,-1, /* '榀','榁','概',0,0,0,0,0, 0,0,'榊',0,0,'榍','榎',0, */
	/* 6990 */ -1, 4, 6,-1, 4, 4, 6,-1,  6,-1,-1, 4, 4,-1,-1,-1, /* 0,'榑','榒',0,'榔','榕','榖',0, '榘',0,0,'榛','榜',0,0,0, */
	/* 69a0 */  4, 6,-1,-1,-1, 6, 6, 4,  6,-1,-1, 6,-1, 6, 4, 6, /* '榠','榡',0,0,0,'榥','榦','榧', '榨',0,0,'榫',0,'榭','榮','榯', */
	/* 69b0 */ -1, 4, 4,-1, 4,-1,-1, 6,  6,-1, 6, 4, 6,-1, 4, 4, /* 0,'榱','榲',0,'榴',0,0,'榷', '榸',0,'榺','榻','榼',0,'榾','榿', */
	/* 69c0 */ -1, 4,-1, 4,-1, 6,-1, 4,  6,-1, 4, 4, 4, 4, 4,-1, /* 0,'槁',0,'槃',0,'槅',0,'槇', '槈',0,'槊','構','槌','槍','槎',0, */
	/* 69d0 */  4, 6,-1, 4,-1,-1, 6, 6,  4, 4,-1,-1,-1, 4, 4,-1, /* '槐','槑',0,'槓',0,0,'槖','槗', '様','槙',0,0,0,'槝','槞',0, */
	/* 69e0 */ -1,-1, 6,-1,-1, 6,-1, 4,  4,-1,-1, 4,-1, 4, 6, 6, /* 0,0,'槢',0,0,'槥',0,'槧', '槨',0,0,'槫',0,'槭','槮','槯', */
	/* 69f0 */ -1, 6, 4, 6,-1, 6,-1,-1, -1, 4,-1, 4,-1, 4, 6, 4, /* 0,'槱','槲','槳',0,'槵',0,0, 0,'槹',0,'槻',0,'槽','槾','槿', */
	/* 6a00 */  6, 6, 4, 6,-1, 4,-1,-1, -1,-1, 4, 4, 4,-1,-1, 6, /* '樀','樁','樂','樃',0,'樅',0,0, 0,0,'樊','樋','樌',0,0,'樏', */
	/* 6a10 */ -1, 6, 4, 4, 4, 6,-1, 4, -1, 4, 6, 4,-1, 6, 4, 4, /* 0,'樑','樒','樓','樔','樕',0,'樗', 0,'標','樚','樛',0,'樝','樞','樟', */
	/* 6a20 */  6, 4, 4, 4, 6,-1,-1,-1,  6, 4, 4, 4,-1,-1, 4,-1, /* '樠','模','樢','樣','樤',0,0,0, '樨','権','横','樫',0,0,'樮',0, */
	/* 6a30 */  6,-1, 6,-1, 6, 4, 4, 6,  4, 4, 4, 6,-1, 4, 6, 6, /* '樰',0,'樲',0,'樴','樵','樶','樷', '樸','樹','樺','樻',0,'樽','樾','樿', */
	/* 6a40 */ -1,-1,-1,-1, 4, 6, 6, 4,  4, 6, 6, 4,-1,-1, 6,-1, /* 0,0,0,0,'橄','橅','橆','橇', '橈','橉','橊','橋',0,0,'橎',0, */
	/* 6a50 */  6, 6, 6,-1,-1, 6, 6,-1,  4, 4,-1, 6,-1,-1,-1, 4, /* '橐','橑','橒',0,0,'橕','橖',0, '橘','橙',0,'橛',0,0,0,'機', */
	/* 6a60 */ -1, 4, 4,-1, 6,-1, 4, 6, -1,-1, 6, 6,-1,-1,-1,-1, /* 0,'橡','橢',0,'橤',0,'橦','橧', 0,0,'橪','橫',0,0,0,0, */
	/* 6a70 */ -1, 6, 4, 6,-1,-1,-1,-1,  4,-1,-1,-1,-1,-1, 6, 4, /* 0,'橱','橲','橳',0,0,0,0, '橸',0,0,0,0,0,'橾','橿', */
	/* 6a80 */  4, 6,-1, 6, 4,-1, 6, 6, -1, 6,-1, 6,-1, 4, 4,-1, /* '檀','檁',0,'檃','檄',0,'檆','檇', 0,'檉',0,'檋',0,'檍','檎',0, */
	/* 6a90 */  4, 6,-1,-1,-1,-1,-1, 4, -1,-1,-1, 6, 4, 6, 6, 6, /* '檐','檑',0,0,0,0,0,'檗', 0,0,0,'檛','檜','檝','檞','檟', */
	/* 6aa0 */  4,-1, 4, 4,-1, 6,-1,-1, -1,-1, 4, 6, 4,-1, 4, 6, /* '檠',0,'檢','檣',0,'檥',0,0, 0,0,'檪','檫','檬',0,'檮','檯', */
	/* 6ab0 */  6, 6,-1, 4, 6,-1,-1,-1,  4,-1,-1, 4,-1, 6, 6, 6, /* '檰','檱',0,'檳','檴',0,0,0, '檸',0,0,'檻',0,'檽','檾','檿', */
	/* 6ac0 */ -1, 4, 4, 4,-1,-1, 6,-1,  6, 6,-1,-1, 6,-1,-1,-1, /* 0,'櫁','櫂','櫃',0,0,'櫆',0, '櫈','櫉',0,0,'櫌',0,0,0, */
	/* 6ad0 */  6, 4,-1, 4, 6, 6, 6,-1, -1,-1, 4, 4, 6, 6, 4, 4, /* '櫐','櫑',0,'櫓','櫔','櫕','櫖',0, 0,0,'櫚','櫛','櫜','櫝','櫞','櫟', */
	/* 6ae0 */ -1,-1, 6,-1, 6,-1,-1, 6,  4,-1, 4,-1, 6,-1,-1,-1, /* 0,0,'櫢',0,'櫤',0,0,'櫧', '櫨',0,'櫪',0,'櫬',0,0,0, */
	/* 6af0 */  6, 6, 6,-1,-1,-1,-1,-1, -1,-1, 4, 4, 6, 6,-1,-1, /* '櫰','櫱','櫲',0,0,0,0,0, 0,0,'櫺','櫻','櫼','櫽',0,0, */
	/* 6b00 */ -1,-1, 6, 6, 4, 4, 6, 6, -1, 6, 4,-1,-1,-1,-1, 6, /* 0,0,'欂','欃','欄','欅','欆','欇', 0,'欉','權',0,0,0,0,'欏', */
	/* 6b10 */  6, 6, 4,-1,-1,-1, 4, 6, -1,-1,-1, 6,-1, 4, 6, 4, /* '欐','欑','欒',0,0,0,'欖','欗', 0,0,0,'欛',0,'欝','欞','欟', */
	/* 6b20 */  4, 4,-1, 4, 6,-1,-1, 4,  6,-1,-1, 6, 6,-1,-1, 6, /* '欠','次',0,'欣','欤',0,0,'欧', '欨',0,0,'欫','欬',0,0,'欯', */
	/* 6b30 */ -1,-1, 4,-1,-1, 6, 6, 4,  4, 4, 4, 6,-1, 4, 4, 6, /* 0,0,'欲',0,0,'欵','欶','欷', '欸','欹','欺','欻',0,'欽','款','欿', */
	/* 6b40 */ -1,-1,-1, 4,-1,-1, 6, 4, -1, 4, 6,-1, 4, 6, 4,-1, /* 0,0,0,'歃',0,0,'歆','歇', 0,'歉','歊',0,'歌','歍','歎',0, */
	/* 6b50 */  4,-1, 6, 4, 4,-1, 6,-1,  6, 4,-1, 4,-1, 6,-1, 4, /* '歐',0,'歒','歓','歔',0,'歖',0, '歘','歙',0,'歛',0,'歝',0,'歟', */
	/* 6b60 */  6, 4, 4, 4, 4,-1, 4, 6, -1, 4, 4, 6,-1,-1, 6, 4, /* '歠','歡','止','正','此',0,'武','歧', 0,'歩','歪','歫',0,0,'歮','歯', */
	/* 6b70 */  6,-1,-1, 4, 4, 6,-1,-1,  4, 4,-1, 4,-1, 6, 6, 4, /* '歰',0,0,'歳','歴','歵',0,0, '歸','歹',0,'死',0,'歽','歾','歿', */
	/* 6b80 */  4,-1, 6, 4, 4, 6, 4,-1, -1, 4, 4, 4,-1, 4,-1,-1, /* '殀',0,'殂','殃','殄','殅','殆',0, 0,'殉','殊','残',0,'殍',0,0, */
	/* 6b90 */ -1,-1,-1,-1,-1, 4, 4, 6,  4,-1,-1, 6,-1,-1, 4, 6, /* 0,0,0,0,0,'殕','殖','殗', '殘',0,0,'殛',0,0,'殞','殟', */
	/* 6ba0 */  6,-1, 6, 6, 4,-1,-1,-1,  6, 6, 4, 4, 6, 6, 6, 4, /* '殠',0,'殢','殣','殤',0,0,0, '殨','殩','殪','殫','殬','殭','殮','殯', */
	/* 6bb0 */  6, 4, 4, 4, 4, 4,-1, 4,  6, 6, 4, 4, 4, 6, 6, 4, /* '殰','殱','殲','殳','殴','段',0,'殷', '殸','殹','殺','殻','殼','殽','殾','殿', */
	/* 6bc0 */  4,-1,-1, 6, 6, 4, 4,-1, -1, 6,-1, 4, 6, 4, 4,-1, /* '毀',0,0,'毃','毄','毅','毆',0, 0,'毉',0,'毋','毌','母','毎',0, */
	/* 6bd0 */ -1,-1, 4, 4, 4,-1, 6,-1,  4,-1, 6, 4,-1,-1,-1, 4, /* 0,0,'毒','毓','比',0,'毖',0, '毘',0,'毚','毛',0,0,0,'毟', */
	/* 6be0 */ -1, 6,-1, 6,-1,-1, 6, 6, -1,-1,-1, 4, 4,-1, 6, 4, /* 0,'毡',0,'毣',0,0,'毦','毧', 0,0,0,'毫','毬',0,'毮','毯', */
	/* 6bf0 */ -1, 6,-1, 4,-1,-1,-1, 6, -1, 6,-1,-1,-1,-1,-1, 6, /* 0,'毱',0,'毳',0,0,0,'毷', 0,'毹',0,0,0,0,0,'毿', */
	/* 6c00 */ -1,-1, 6,-1, 6, 6,-1,-1,  4, 6,-1,-1,-1, 6, 6, 4, /* 0,0,'氂',0,'氄','氅',0,0, '氈','氉',0,0,0,'氍','氎','氏', */
	/* 6c10 */  6, 4, 6, 4, 4,-1,-1, 4, -1, 6,-1, 4,-1,-1,-1, 6, /* '氐','民','氒','氓','气',0,0,'気', 0,'氙',0,'氛',0,0,0,'氟', */
	/* 6c20 */ -1,-1,-1, 4, 4,-1, 6, 6,  6,-1,-1,-1, 6,-1, 6,-1, /* 0,0,0,'氣','氤',0,'氦','氧', '氨',0,0,0,'氬',0,'氮',0, */
	/* 6c30 */ -1,-1,-1, 6, 4, 6, 6, 4,  4,-1, 6, 6,-1,-1, 4, 6, /* 0,0,0,'氳','水','氵','氶','氷', '永',0,'氺','氻',0,0,'氾','氿', */
	/* 6c40 */  4, 4, 4,-1,-1,-1,-1,-1, -1,-1, 6, 6,-1, 6, 4, 6, /* '汀','汁','求',0,0,0,0,0, 0,0,'汊','汋',0,'汍','汎','汏', */
	/* 6c50 */  4,-1, 6,-1, 6, 4,-1, 4, -1, 6, 4, 6, 6, 4, 4, 4, /* '汐',0,'汒',0,'汔','汕',0,'汗', 0,'汙','汚','汛','汜','汝','汞','江', */
	/* 6c60 */  4,-1, 4,-1,-1,-1,-1, 6,  4,-1, 4, 6,-1, 6,-1, 6, /* '池',0,'汢',0,0,0,0,'汧', '汨',0,'汪','汫',0,'汭',0,'汯', */
	/* 6c70 */  4,-1, 4, 4, 6,-1, 6,-1,  6, 6, 4, 6,-1, 4, 4,-1, /* '汰',0,'汲','汳','汴',0,'汶',0, '汸','汹','決','汻',0,'汽','汾',0, */
	/* 6c80 */ -1, 4, 4, 4,-1, 6, 6, 6,  4, 6,-1,-1, 4, 4,-1,-1, /* 0,'沁','沂','沃',0,'沅','沆','沇', '沈','沉',0,0,'沌','沍',0,0, */
	/* 6c90 */  4,-1, 4, 4, 6, 6, 4, 6,  6, 4, 4, 4, 6,-1,-1, 6, /* '沐',0,'沒','沓','沔','沕','沖','沗', '沘','沙','沚','沛','沜',0,0,'沟', */
	/* 6ca0 */ -1, 4, 4,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 4,-1, /* 0,'没','沢',0,0,0,0,0, 0,0,0,'沫',0,0,'沮',0, */
	/* 6cb0 */  6, 4, 6, 4, 6,-1,-1,-1,  4, 4, 4, 4, 4, 4, 4, 4, /* '沰','沱','沲','河','沴',0,0,0, '沸','油','沺','治','沼','沽','沾','沿', */
	/* 6cc0 */ -1, 4, 6,-1, 4, 4, 6,-1, -1, 4, 4,-1, 4, 6,-1, 6, /* 0,'況','泂',0,'泄','泅','泆',0, 0,'泉','泊',0,'泌','泍',0,'泏', */
	/* 6cd0 */  6, 6, 6, 4, 6, 4, 6, 4, -1, 4, 6, 4, 6, 4,-1,-1, /* '泐','泑','泒','泓','泔','法','泖','泗', 0,'泙','泚','泛','泜','泝',0,0, */
	/* 6ce0 */  6, 4, 4, 4,-1, 4,-1, 6,  4, 6, 4, 6, 6,-1, 6, 4, /* '泠','泡','波','泣',0,'泥',0,'泧', '注','泩','泪','泫','泬',0,'泮','泯', */
	/* 6cf0 */  4, 4, 6, 4, 6,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '泰','泱','泲','泳','泴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6d00 */ -1,-1,-1,-1, 6,-1,-1, 6, -1,-1, 6, 4, 4,-1, 6, 6, /* 0,0,0,0,'洄',0,0,'洇', 0,0,'洊','洋','洌',0,'洎','洏', */
	/* 6d10 */ -1, 6, 4, 6,-1,-1,-1, 4, -1, 4, 6, 4,-1,-1, 4, 4, /* 0,'洑','洒','洓',0,0,0,'洗', 0,'洙','洚','洛',0,0,'洞','洟', */
	/* 6d20 */ -1,-1,-1,-1,-1, 4, 6, 6,  6, 4, 4, 4,-1,-1, 6, 6, /* 0,0,0,0,0,'津','洦','洧', '洨','洩','洪','洫',0,0,'洮','洯', */
	/* 6d30 */ -1, 6, 4, 4,-1, 4, 4,-1,  4, 6,-1, 4, 6, 4, 4, 6, /* 0,'洱','洲','洳',0,'洵','洶',0, '洸','洹',0,'活','洼','洽','派','洿', */
	/* 6d40 */ -1, 4,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'流',0,0,'浄','浅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6d50 */ -1,-1,-1,-1,-1,-1,-1, 6, -1, 4, 4,-1, 4,-1, 6, 6, /* 0,0,0,0,0,0,0,'浗', 0,'浙','浚',0,'浜',0,'浞','浟', */
	/* 6d60 */ -1, 6,-1, 4, 4, 6, 4, 6, -1, 4, 4,-1, 4,-1, 4, 6, /* 0,'浡',0,'浣','浤','浥','浦','浧', 0,'浩','浪',0,'浬',0,'浮','浯', */
	/* 6d70 */  6,-1,-1,-1, 4,-1,-1, 4,  4, 4,-1,-1, 6,-1,-1,-1, /* '浰',0,0,0,'浴',0,0,'海', '浸','浹',0,0,'浼',0,0,0, */
	/* 6d80 */ -1,-1, 6,-1,-1, 4,-1, 6,  4,-1,-1,-1, 4,-1, 4,-1, /* 0,0,'涂',0,0,'涅',0,'涇', '消',0,0,0,'涌',0,'涎',0, */
	/* 6d90 */ -1, 6, 6, 4, 6, 4, 6, 6,  6, 4,-1, 4, 4,-1,-1,-1, /* 0,'涑','涒','涓','涔','涕','涖','涗', '涘','涙',0,'涛','涜',0,0,0, */
	/* 6da0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1, 6,-1, 6,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,'涪',0,'涬',0,0,'涯', */
	/* 6db0 */ -1,-1, 4,-1, 6, 4,-1, 6,  4, 6,-1,-1, 4, 6,-1, 6, /* 0,0,'液',0,'涴','涵',0,'涷', '涸','涹',0,0,'涼','涽',0,'涿', */
	/* 6dc0 */  4,-1,-1,-1, 6, 4, 4, 4,  6,-1, 6, 4, 4,-1, 6, 6, /* '淀',0,0,0,'淄','淅','淆','淇', '淈',0,'淊','淋','淌',0,'淎','淏', */
	/* 6dd0 */ -1, 4, 4,-1,-1, 4, 6,-1,  4, 4,-1, 6,-1, 6, 4, 6, /* 0,'淑','淒',0,0,'淕','淖',0, '淘','淙',0,'淛',0,'淝','淞','淟', */
	/* 6de0 */  6, 4, 6,-1, 4, 6, 4,-1,  4, 6, 4, 4, 4,-1, 4, 6, /* '淠','淡','淢',0,'淤','淥','淦',0, '淨','淩','淪','淫','淬',0,'淮','淯', */
	/* 6df0 */  6, 4, 6, 4, 6, 4, 6, 4,  6, 4, 4, 4, 6,-1,-1,-1, /* '淰','深','淲','淳','淴','淵','淶','混', '淸','淹','淺','添','淼',0,0,0, */
	/* 6e00 */  6,-1,-1,-1, 6, 4,-1, 4,  4, 4, 4, 4,-1,-1,-1,-1, /* '渀',0,0,0,'渄','清',0,'渇', '済','渉','渊','渋',0,0,0,0, */
	/* 6e10 */ -1,-1,-1, 4,-1, 4,-1,-1, -1, 4, 4, 4,-1, 4, 6, 4, /* 0,0,0,'渓',0,'渕',0,0, 0,'渙','渚','減',0,'渝','渞','渟', */
	/* 6e20 */  4, 4, 6, 4, 4, 4, 4, 6, -1, 4,-1, 4, 4, 4, 4, 4, /* '渠','渡','渢','渣','渤','渥','渦','渧', 0,'温',0,'渫','測','渭','渮','港', */
	/* 6e30 */ -1,-1, 6,-1,-1,-1, 6,-1,  4, 6, 4, 6, 6,-1, 4,-1, /* 0,0,'渲',0,0,0,'渶',0, '游','渹','渺','渻','渼',0,'渾',0, */
	/* 6e40 */ -1,-1,-1, 4, 6, 6,-1,-1,  6, 6, 4, 6,-1, 4, 4, 6, /* 0,0,0,'湃','湄','湅',0,0, '湈','湉','湊','湋',0,'湍','湎','湏', */
	/* 6e50 */ -1, 6, 6, 6, 6,-1, 4, 6,  4,-1,-1, 4, 6, 6, 6, 4, /* 0,'湑','湒','湓','湔',0,'湖','湗', '湘',0,0,'湛','湜','湝','湞','湟', */
	/* 6e60 */ -1,-1, 6, 6,-1,-1,-1, 4,  6,-1,-1, 4,-1,-1, 4, 4, /* 0,0,'湢','湣',0,0,0,'湧', '湨',0,0,'湫',0,0,'湮','湯', */
	/* 6e70 */ -1,-1, 4, 6,-1,-1, 4,-1, -1,-1,-1, 6,-1, 6, 4, 4, /* 0,0,'湲','湳',0,0,'湶',0, 0,0,0,'湻',0,'湽','湾','湿', */
	/* 6e80 */  4,-1, 4,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4, 6,-1, 4, /* '満',0,'溂',0,0,0,0,0, 0,0,0,0,'溌','溍',0,'溏', */
	/* 6e90 */  4,-1,-1, 6,-1,-1, 4,-1,  4, 6,-1,-1, 4, 4,-1, 4, /* '源',0,0,'溓',0,0,'準',0, '溘','溙',0,0,'溜','溝',0,'溟', */
	/* 6ea0 */  6,-1, 4,-1,-1, 4,-1, 6, -1,-1, 4,-1,-1, 6, 6, 4, /* '溠',0,'溢',0,0,'溥',0,'溧', 0,0,'溪',0,0,'溭','溮','溯', */
	/* 6eb0 */ -1, 6, 4, 6,-1,-1, 4, 4, -1,-1, 4, 6,-1, 4,-1, 6, /* 0,'溱','溲','溳',0,0,'溶','溷', 0,0,'溺','溻',0,'溽',0,'溿', */
	/* 6ec0 */  6, 6, 4, 6, 4, 4,-1, 6,  6, 4, 6, 4, 4, 6, 6, 6, /* '滀','滁','滂','滃','滄','滅',0,'滇', '滈','滉','滊','滋','滌','滍','滎','滏', */
	/* 6ed0 */ -1, 4,-1, 4, 4, 4,-1,-1, -1,-1,-1,-1,-1, 4, 4,-1, /* 0,'滑',0,'滓','滔','滕',0,0, 0,0,0,0,0,'滝','滞',0, */
	/* 6ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 6, 4, 6, 6, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,'滫','滬','滭','滮','滯', */
	/* 6ef0 */ -1,-1, 4,-1, 4,-1,-1, 4,  4, 6,-1, 6,-1, 6, 4, 4, /* 0,0,'滲',0,'滴',0,0,'滷', '滸','滹',0,'滻',0,'滽','滾','滿', */
	/* 6f00 */ -1, 4, 4,-1, 6,-1, 4,-1,  6, 4, 6,-1, 6, 6,-1, 4, /* 0,'漁','漂',0,'漄',0,'漆',0, '漈','漉','漊',0,'漌','漍',0,'漏', */
	/* 6f10 */ -1, 4,-1, 4, 4, 4, 6,-1,  6,-1, 6, 6,-1,-1,-1,-1, /* 0,'漑',0,'漓','演','漕','漖',0, '漘',0,'漚','漛',0,0,0,0, */
	/* 6f20 */  4,-1, 4, 4,-1,-1, 6,-1, -1, 6, 6, 4, 4, 6,-1, 6, /* '漠',0,'漢','漣',0,0,'漦',0, 0,'漩','漪','漫','漬','漭',0,'漯', */
	/* 6f30 */  6, 4, 4, 6,-1,-1, 6,-1,  4,-1,-1, 6, 6,-1, 4, 4, /* '漰','漱','漲','漳',0,0,'漶',0, '漸',0,0,'漻','漼',0,'漾','漿', */
	/* 6f40 */ -1, 4,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1,-1,-1,-1, 6, /* 0,'潁',0,0,0,'潅',0,0, 0,0,0,0,0,0,0,'潏', */
	/* 6f50 */ -1, 6, 6, 6, 4,-1,-1, 6,  4, 6, 6, 4, 4, 6, 6, 4, /* 0,'潑','潒','潓','潔',0,0,'潗', '潘','潙','潚','潛','潜','潝','潞','潟', */
	/* 6f60 */ -1, 6, 6,-1, 4,-1, 4,-1,  6,-1,-1,-1, 6, 4, 4, 4, /* 0,'潡','潢',0,'潤',0,'潦',0, '潨',0,0,0,'潬','潭','潮','潯', */
	/* 6f70 */  4,-1,-1,-1, 4,-1,-1,-1,  4,-1, 4,-1, 4, 6, 6,-1, /* '潰',0,0,0,'潴',0,0,0, '潸',0,'潺',0,'潼','潽','潾',0, */
	/* 6f80 */  4, 4, 4, 6, 4,-1, 4, 6,  6,-1,-1, 6, 6, 6, 4,-1, /* '澀','澁','澂','澃','澄',0,'澆','澇', '澈',0,0,'澋','澌','澍','澎',0, */
	/* 6f90 */  6, 4, 6, 6, 6,-1, 6, 4, -1,-1, 6,-1,-1,-1,-1, 6, /* '澐','澑','澒','澓','澔',0,'澖','澗', 0,0,'澚',0,0,0,0,'澟', */
	/* 6fa0 */  6, 4,-1, 4, 4, 6, 6, 6,  6,-1, 4,-1,-1,-1, 6, 6, /* '澠','澡',0,'澣','澤','澥','澦','澧', '澨',0,'澪',0,0,0,'澮','澯', */
	/* 6fb0 */  6, 4,-1, 4,-1, 6, 6,-1, -1, 4,-1,-1, 6,-1,-1,-1, /* '澰','澱',0,'澳',0,'澵','澶',0, 0,'澹',0,0,'澼',0,0,0, */
	/* 6fc0 */  4, 4, 4, 4,-1, 6, 4, 6,  6,-1, 6,-1,-1,-1,-1,-1, /* '激','濁','濂','濃',0,'濅','濆','濇', '濈',0,'濊',0,0,0,0,0, */
	/* 6fd0 */ -1,-1,-1,-1, 4, 4,-1,-1,  4,-1, 6, 4,-1,-1, 6, 4, /* 0,0,0,0,'濔','濕',0,0, '濘',0,'濚','濛',0,0,'濞','濟', */
	/* 6fe0 */  4, 4,-1,-1, 4,-1,-1,-1,  6, 6,-1, 4, 4,-1, 4, 4, /* '濠','濡',0,0,'濤',0,0,0, '濨','濩',0,'濫','濬',0,'濮','濯', */
	/* 6ff0 */  6, 4,-1, 4,-1, 6, 4,-1, -1, 6, 4,-1, 6, 6, 4,-1, /* '濰','濱',0,'濳',0,'濵','濶',0, 0,'濹','濺',0,'濼','濽','濾',0, */
	/* 7000 */  6, 4,-1,-1,-1, 6, 6, 6, -1, 4,-1, 4,-1, 6,-1, 4, /* '瀀','瀁',0,0,0,'瀅','瀆','瀇', 0,'瀉',0,'瀋',0,'瀍',0,'瀏', */
	/* 7010 */ -1, 4,-1,-1,-1, 4,-1, 6,  4,-1, 4, 4,-1, 4, 4, 4, /* 0,'瀑',0,0,0,'瀕',0,'瀗', '瀘',0,'瀚','瀛',0,'瀝','瀞','瀟', */
	/* 7020 */  6,-1,-1, 6,-1,-1, 4, 4,  6,-1,-1,-1, 4,-1,-1, 6, /* '瀠',0,0,'瀣',0,0,'瀦','瀧', '瀨',0,0,0,'瀬',0,0,'瀯', */
	/* 7030 */  4,-1, 4,-1, 6,-1,-1, 6, -1, 6,-1,-1, 6,-1, 4,-1, /* '瀰',0,'瀲',0,'瀴',0,0,'瀷', 0,'瀹',0,0,'瀼',0,'瀾',0, */
	/* 7040 */ -1,-1,-1, 6, 6,-1,-1,-1,  6, 6, 6, 6, 4,-1, 6,-1, /* 0,0,0,'灃','灄',0,0,0, '灈','灉','灊','灋','灌',0,'灎',0, */
	/* 7050 */ -1, 4,-1,-1, 6, 6,-1,-1,  4,-1,-1,-1,-1, 6, 6,-1, /* 0,'灑',0,0,'灔','灕',0,0, '灘',0,0,0,0,'灝','灞',0, */
	/* 7060 */ -1,-1,-1, 4, 6, 6,-1,-1, -1,-1,-1, 4, 6,-1, 6, 4, /* 0,0,0,'灣','灤','灥',0,0, 0,0,0,'火','灬',0,'灮','灯', */
	/* 7070 */  4,-1,-1,-1,-1, 6, 6,-1,  4,-1,-1,-1, 4, 4, 6,-1, /* '灰',0,0,0,0,'灵','灶',0, '灸',0,0,0,'灼','災','灾',0, */
	/* 7080 */ -1, 6,-1,-1,-1, 6, 6,-1, -1, 4, 4,-1,-1,-1, 4,-1, /* 0,'炁',0,0,0,'炅','炆',0, 0,'炉','炊',0,0,0,'炎',0, */
	/* 7090 */ -1,-1, 4,-1, 6, 6, 6, 6,  6, 4,-1, 6,-1,-1,-1,-1, /* 0,0,'炒',0,'炔','炕','炖','炗', '炘','炙',0,'炛',0,0,0,0, */
	/* 70a0 */ -1,-1,-1,-1, 6,-1,-1,-1, -1,-1,-1, 6, 4, 4, 4, 4, /* 0,0,0,0,'炤',0,0,0, 0,0,0,'炫','炬','炭','炮','炯', */
	/* 70b0 */  6, 6,-1, 4, 6,-1,-1, 6,  4, 4, 4, 6,-1,-1,-1,-1, /* '炰','炱',0,'炳','炴',0,0,'炷', '炸','点','為','炻',0,0,0,0, */
	/* 70c0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1, 6, 4,-1,-1,-1, 4, /* 0,0,0,0,0,0,0,0, '烈',0,'烊','烋',0,0,0,'烏', */
	/* 70d0 */ -1, 6,-1, 6, 6, 6, 6,-1,  6, 4,-1,-1, 6, 4,-1, 4, /* 0,'烑',0,'烓','烔','烕','烖',0, '烘','烙',0,0,'烜','烝',0,'烟', */
	/* 70e0 */ -1,-1,-1,-1, 6,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,'烤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 70f0 */ -1, 4,-1,-1,-1,-1,-1,-1, -1, 4, 6,-1,-1, 4,-1,-1, /* 0,'烱',0,0,0,0,0,0, 0,'烹','烺',0,0,'烽',0,0, */
	/* 7100 */ -1,-1,-1, 6, 6, 6, 6, 6, -1, 4,-1, 6, 6,-1,-1, 6, /* 0,0,0,'焃','焄','焅','焆','焇', 0,'焉',0,'焋','焌',0,0,'焏', */
	/* 7110 */ -1,-1,-1,-1, 4,-1,-1,-1, -1, 4, 4,-1, 4,-1, 6,-1, /* 0,0,0,0,'焔',0,0,0, 0,'焙','焚',0,'焜',0,'焞',0, */
	/* 7120 */  6, 4,-1,-1,-1,-1, 4,-1, -1,-1,-1, 6,-1, 6,-1, 6, /* '焠','無',0,0,0,0,'焦',0, 0,0,0,'焫',0,'焭',0,'焯', */
	/* 7130 */  6, 6,-1,-1,-1,-1, 4,-1,  6,-1,-1,-1, 4,-1,-1,-1, /* '焰','焱',0,0,0,0,'然',0, '焸',0,0,0,'焼',0,0,0, */
	/* 7140 */ -1, 6,-1,-1,-1, 6, 6, 6, -1, 4, 6, 6, 4,-1, 4,-1, /* 0,'煁',0,0,0,'煅','煆','煇', 0,'煉','煊','煋','煌',0,'煎',0, */
	/* 7150 */  6,-1, 6,-1,-1, 4, 4, 6, -1, 4, 6,-1, 6,-1, 6,-1, /* '煐',0,'煒',0,0,'煕','煖','煗', 0,'煙','煚',0,'煜',0,'煞',0, */
	/* 7160 */  6,-1, 4,-1, 4, 4, 4, 4,  6, 4,-1,-1, 4,-1, 4,-1, /* '煠',0,'煢',0,'煤','煥','煦','照', '煨','煩',0,0,'煬',0,'煮',0, */
	/* 7170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 6,-1,-1,-1, 4,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'煹',0,0,0,'煽',0,0, */
	/* 7180 */  6,-1,-1,-1, 4, 6,-1, 6,  4,-1, 4,-1, 6,-1,-1, 4, /* '熀',0,0,0,'熄','熅',0,'熇', '熈',0,'熊',0,'熌',0,0,'熏', */
	/* 7190 */ -1,-1, 6,-1, 4, 4,-1,-1, -1, 4, 6, 6,-1,-1,-1, 4, /* 0,0,'熒',0,'熔','熕',0,0, 0,'熙','熚','熛',0,0,0,'熟', */
	/* 71a0 */  6,-1, 6,-1,-1,-1,-1,-1,  4,-1,-1,-1, 4,-1,-1, 6, /* '熠',0,'熢',0,0,0,0,0, '熨',0,0,0,'熬',0,0,'熯', */
	/* 71b0 */  6, 4, 6, 6,-1,-1,-1,-1, -1, 4, 6,-1,-1,-1, 4, 6, /* '熰','熱','熲','熳',0,0,0,0, 0,'熹','熺',0,0,0,'熾','熿', */
	/* 71c0 */  6, 6,-1, 4, 6,-1,-1,-1,  4, 4,-1, 6, 6,-1, 4,-1, /* '燀','燁',0,'燃','燄',0,0,0, '燈','燉',0,'燋','燌',0,'燎',0, */
	/* 71d0 */  4,-1, 4, 6, 4, 4, 6, 4, -1, 6, 6,-1, 6,-1,-1, 4, /* '燐',0,'燒','燓','燔','燕','燖','燗', 0,'燙','燚',0,'燜',0,0,'營', */
	/* 71e0 */  4,-1,-1,-1,-1, 4, 4, 4, -1,-1,-1,-1, 4, 4, 4,-1, /* '燠',0,0,0,0,'燥','燦','燧', 0,0,0,0,'燬','燭','燮',0, */
	/* 71f0 */ -1,-1,-1,-1,-1, 4,-1,-1,  6, 4,-1, 4, 4,-1, 6, 4, /* 0,0,0,0,0,'燵',0,0, '燸','燹',0,'燻','燼',0,'燾','燿', */
	/* 7200 */  6,-1,-1,-1,-1,-1, 4, 6,  6, 6,-1,-1,-1, 4,-1,-1, /* '爀',0,0,0,0,0,'爆','爇', '爈','爉',0,0,0,'爍',0,0, */
	/* 7210 */  4,-1,-1, 6,-1,-1,-1, 6, -1,-1, 6, 4,-1, 6,-1, 6, /* '爐',0,0,'爓',0,0,0,'爗', 0,0,'爚','爛',0,'爝',0,'爟', */
	/* 7220 */ -1,-1,-1,-1, 6,-1,-1,-1,  4,-1, 4, 6, 4, 4,-1, 6, /* 0,0,0,0,'爤',0,0,0, '爨',0,'爪','爫','爬','爭',0,'爯', */
	/* 7230 */  4,-1, 4,-1, 6, 4, 4,-1,  6, 6, 4, 4, 4, 4, 4, 4, /* '爰',0,'爲',0,'爴','爵','父',0, '爸','爹','爺','爻','爼','爽','爾','爿', */
	/* 7240 */  4, 6, 6, 6,-1, 6, 4, 4,  4,-1,-1, 4, 4,-1, 6, 6, /* '牀','牁','牂','牃',0,'牅','牆','片', '版',0,0,'牋','牌',0,'牎','牏', */
	/* 7250 */  6,-1, 4, 6,-1, 6, 6,-1,  4, 4, 6, 4, 6, 4, 6, 4, /* '牐',0,'牒','牓',0,'牕','牖',0, '牘','牙','牚','牛','牜','牝','牞','牟', */
	/* 7260 */  6, 4, 4, 6,-1,-1,-1, 4,  6, 4,-1, 6,-1,-1, 6, 6, /* '牠','牡','牢','牣',0,0,0,'牧', '牨','物',0,'牫',0,0,'牮','牯', */
	/* 7270 */ -1, 6, 4,-1, 4,-1,-1, 6,  6, 4,-1, 6, 6, 4, 4, 6, /* 0,'牱','牲',0,'牴',0,0,'牷', '牸','特',0,'牻','牼','牽','牾','牿', */
	/* 7280 */  4, 4, 4,-1, 6,-1,-1, 4, -1, 6,-1,-1,-1, 6, 6,-1, /* '犀','犁','犂',0,'犄',0,0,'犇', 0,'犉',0,0,0,'犍','犎',0, */
	/* 7290 */ -1,-1, 4, 6,-1,-1, 4,-1, -1,-1,-1, 6,-1,-1,-1,-1, /* 0,0,'犒','犓',0,0,'犖',0, 0,0,0,'犛',0,0,0,0, */
	/* 72a0 */  4,-1, 4,-1,-1,-1,-1, 4,  6,-1,-1,-1, 4, 6, 6, 4, /* '犠',0,'犢',0,0,0,0,'犧', '犨',0,0,0,'犬','犭','犮','犯', */
	/* 72b0 */ -1, 6, 4,-1, 6,-1, 4,-1, -1, 4,-1,-1,-1,-1, 6,-1, /* 0,'犱','犲',0,'犴',0,'状',0, 0,'犹',0,0,0,0,'犾',0, */
	/* 72c0 */ -1, 6, 4, 4, 4,-1, 4, 6, -1, 6,-1,-1, 6,-1, 4,-1, /* 0,'狁','狂','狃','狄',0,'狆','狇', 0,'狉',0,0,'狌',0,'狎',0, */
	/* 72d0 */  4,-1, 4,-1,-1, 6, 6, 4,  6, 4,-1, 4,-1,-1,-1, 6, /* '狐',0,'狒',0,0,'狕','狖','狗', '狘','狙',0,'狛',0,0,0,'狟', */
	/* 72e0 */  4, 4, 4,-1,-1, 6,-1,-1, -1, 4,-1,-1, 4, 4,-1,-1, /* '狠','狡','狢',0,0,'狥',0,0, 0,'狩',0,0,'独','狭',0,0, */
	/* 72f0 */ -1,-1,-1, 6, 6,-1,-1, 4,  4, 4, 6, 6, 4, 4, 6,-1, /* 0,0,0,'狳','狴',0,0,'狷', '狸','狹','狺','狻','狼','狽','狾',0, */
	/* 7300 */ -1,-1, 6,-1, 6, 6,-1, 6, -1,-1, 4, 6,-1, 6,-1,-1, /* 0,0,'猂',0,'猄','猅',0,'猇', 0,0,'猊','猋',0,'猍',0,0, */
	/* 7310 */ -1,-1, 6, 6,-1,-1, 4, 4,  6, 6,-1, 4, 4, 4, 6, 4, /* 0,0,'猒','猓',0,0,'猖','猗', '猘','猙',0,'猛','猜','猝','猞','猟', */
	/* 7320 */ -1,-1, 6,-1, 6, 4,-1, 6,  6, 4, 4, 4, 6,-1, 4, 4, /* 0,0,'猢',0,'猤','猥',0,'猧', '猨','猩','猪','猫','猬',0,'献','猯', */
	/* 7330 */ -1, 6, 6,-1, 4, 6, 4, 4, -1,-1, 6, 6,-1, 6, 4, 4, /* 0,'猱','猲',0,'猴','猵','猶','猷', 0,0,'猺','猻',0,'猽','猾','猿', */
	/* 7340 */ -1,-1,-1, 6, 4, 4,-1,-1, -1,-1,-1,-1,-1, 6, 4, 4, /* 0,0,0,'獃','獄','獅',0,0, 0,0,0,0,0,'獍','獎','獏', */
	/* 7350 */  6,-1, 6,-1,-1,-1, 6, 4,  6,-1,-1,-1,-1, 6, 6, 6, /* '獐',0,'獒',0,0,0,'獖','獗', '獘',0,0,0,0,'獝','獞','獟', */
	/* 7360 */  6,-1,-1, 4,-1,-1, 6, 6,  4, 6, 4, 6, 6,-1, 6, 6, /* '獠',0,0,'獣',0,0,'獦','獧', '獨','獩','獪','獫','獬',0,'獮','獯', */
	/* 7370 */  4, 6, 4,-1,-1, 4,-1, 6,  4, 6, 4, 4, 6,-1,-1,-1, /* '獰','獱','獲',0,0,'獵',0,'獷', '獸','獹','獺','獻','獼',0,0,0, */
	/* 7380 */  6, 6,-1, 6, 4, 6, 6, 4, -1, 4,-1, 4,-1,-1, 6,-1, /* '玀','玁',0,'玃','玄','玅','玆','率', 0,'玉',0,'王',0,0,'玎',0, */
	/* 7390 */  6,-1,-1, 6,-1, 6, 4, 6,  6,-1,-1,-1, 6,-1, 6, 6, /* '玐',0,0,'玓',0,'玕','玖','玗', '玘',0,0,0,'玜',0,'玞','玟', */
	/* 73a0 */  6,-1, 6,-1,-1, 6, 6,-1, -1, 4, 6, 6,-1, 6,-1,-1, /* '玠',0,'玢',0,0,'玥','玦',0, 0,'玩','玪','玫',0,'玭',0,0, */
	/* 73b0 */ -1,-1, 4, 4,-1, 6,-1, 6, -1, 6,-1, 4, 6, 6,-1, 6, /* 0,0,'玲','玳',0,'玵',0,'玷', 0,'玹',0,'玻','玼','玽',0,'玿', */
	/* 73c0 */  4,-1, 4,-1,-1, 6, 6,-1,  4, 6, 4, 6, 6, 4, 4, 6, /* '珀',0,'珂',0,0,'珅','珆',0, '珈','珉','珊','珋','珌','珍','珎','珏', */
	/* 73d0 */ -1,-1, 6, 6,-1,-1, 6,-1, -1, 6,-1,-1,-1, 6, 4,-1, /* 0,0,'珒','珓',0,0,'珖',0, 0,'珙',0,0,0,'珝','珞',0, */
	/* 73e0 */  4, 6,-1, 6,-1, 4, 6, 6, -1, 6, 4,-1,-1, 4, 4,-1, /* '珠','珡',0,'珣',0,'珥','珦','珧', 0,'珩','珪',0,0,'班','珮',0, */
	/* 73f0 */ -1, 4,-1,-1, 6, 6,-1, 6,  4, 6, 6, 6,-1, 6, 4, 6, /* 0,'珱',0,0,'珴','珵',0,'珷', '珸','珹','珺','珻',0,'珽','現','珿', */
	/* 7400 */  6, 6,-1, 4, 6, 4, 4, 6, -1, 4, 6,-1,-1,-1,-1,-1, /* '琀','琁',0,'球','琄','琅','理','琇', 0,'琉','琊',0,0,0,0,0, */
	/* 7410 */ -1, 6,-1,-1,-1,-1,-1,-1, -1,-1, 6, 6,-1,-1,-1,-1, /* 0,'琑',0,0,0,0,0,0, 0,0,'琚','琛',0,0,0,0, */
	/* 7420 */ -1,-1, 4,-1, 6, 4, 6,-1,  6, 6, 6, 6, 6, 6, 6, 6, /* 0,0,'琢',0,'琤','琥','琦',0, '琨','琩','琪','琫','琬','琭','琮','琯', */
	/* 7430 */  6, 6, 4, 4, 4, 4, 4,-1, -1, 6, 4,-1,-1,-1,-1, 4, /* '琰','琱','琲','琳','琴','琵','琶',0, 0,'琹','琺',0,0,0,0,'琿', */
	/* 7440 */  6, 4,-1, 6, 6,-1, 6, 6, -1,-1,-1, 6,-1, 6,-1,-1, /* '瑀','瑁',0,'瑃','瑄',0,'瑆','瑇', 0,0,0,'瑋',0,'瑍',0,0, */
	/* 7450 */ -1, 6, 6,-1,-1, 4,-1, 6, -1, 4, 4, 4, 4, 6, 4, 4, /* 0,'瑑','瑒',0,0,'瑕',0,'瑗', 0,'瑙','瑚','瑛','瑜','瑝','瑞','瑟', */
	/* 7460 */  4,-1, 6, 4, 4,-1, 6, 6,  6, 4, 4, 6,-1, 6, 6, 4, /* '瑠',0,'瑢','瑣','瑤',0,'瑦','瑧', '瑨','瑩','瑪','瑫',0,'瑭','瑮','瑯', */
	/* 7470 */  4, 6, 6, 4,-1,-1, 4,-1, -1,-1,-1,-1,-1,-1, 4,-1, /* '瑰','瑱','瑲','瑳',0,0,'瑶',0, 0,0,0,0,0,0,'瑾',0, */
	/* 7480 */  6, 6,-1, 4,-1, 6, 6, 6, -1, 6,-1, 4,-1,-1,-1, 6, /* '璀','璁',0,'璃',0,'璅','璆','璇', 0,'璉',0,'璋',0,0,0,'璏', */
	/* 7490 */  6, 6, 6,-1,-1,-1,-1,-1,  6, 6, 6,-1, 6,-1, 4, 6, /* '璐','璑','璒',0,0,0,0,0, '璘','璙','璚',0,'璜',0,'璞','璟', */
	/* 74a0 */  6, 6, 4, 6,-1,-1, 6, 4,  6, 6, 6, 6,-1,-1, 6, 6, /* '璠','璡','璢','璣',0,0,'璦','璧', '璨','璩','璪','璫',0,0,'璮','璯', */
	/* 74b0 */  4, 6, 6,-1,-1, 6,-1,-1, -1, 6,-1, 6,-1, 4,-1, 6, /* '環','璱','璲',0,0,'璵',0,0, 0,'璹',0,'璻',0,'璽',0,'璿', */
	/* 74c0 */ -1,-1,-1,-1,-1,-1,-1,-1,  6, 6, 4,-1, 6,-1,-1, 4, /* 0,0,0,0,0,0,0,0, '瓈','瓉','瓊',0,'瓌',0,0,'瓏', */
	/* 74d0 */  6,-1,-1, 6, 4,-1,-1,-1,  6,-1, 6, 6, 4,-1, 6, 6, /* '瓐',0,0,'瓓','瓔',0,0,0, '瓘',0,'瓚','瓛','瓜',0,'瓞','瓟', */
	/* 74e0 */  4,-1, 4, 4, 6,-1, 4, 4,  6, 4, 6, 6,-1,-1, 4, 6, /* '瓠',0,'瓢','瓣','瓤',0,'瓦','瓧', '瓨','瓩','瓪','瓫',0,0,'瓮','瓯', */
	/* 74f0 */  4, 4, 4,-1, 6,-1, 4, 4,  4,-1, 6, 6, 6,-1,-1, 6, /* '瓰','瓱','瓲',0,'瓴',0,'瓶','瓷', '瓸',0,'瓺','瓻','瓼',0,0,'瓿', */
	/* 7500 */ -1, 6,-1, 4, 4, 4, 6,-1, -1,-1,-1,-1, 4, 4, 4,-1, /* 0,'甁',0,'甃','甄','甅','甆',0, 0,0,0,0,'甌','甍','甎',0, */
	/* 7510 */ -1, 4, 6, 4,-1, 4, 6, 6,  4,-1, 4,-1, 4,-1, 4, 4, /* 0,'甑','甒','甓',0,'甕','甖','甗', '甘',0,'甚',0,'甜',0,'甞','生', */
	/* 7520 */  6, 6,-1, 4, 6, 4, 4, 6,  4, 6, 6, 4, 4,-1,-1, 6, /* '甠','甡',0,'産','甤','甥','甦','甧', '用','甩','甪','甫','甬',0,0,'甯', */
	/* 7530 */  4, 4, 4, 4,-1,-1, 6, 4,  4, 6, 4, 4, 4, 6, 6, 6, /* '田','由','甲','申',0,0,'甶','男', '甸','甹','町','画','甼','甽','甾','甿', */
	/* 7540 */  6,-1,-1, 6, 4,-1, 4, 6,  6, 4, 4, 4, 4, 4, 6, 4, /* '畀',0,0,'畃','畄',0,'畆','畇', '畈','畉','畊','畋','界','畍','畎','畏', */
	/* 7550 */  6, 4, 6,-1, 4,-1,-1, 6, -1, 4, 4, 4, 4, 4, 6, 6, /* '畐','畑','畒',0,'畔',0,0,'畗', 0,'留','畚','畛','畜','畝','畞','畟', */
	/* 7560 */  4, 6, 4,-1, 4, 4, 4, 4, -1, 4, 4, 4,-1, 4,-1, 6, /* '畠','畡','畢',0,'畤','略','畦','畧', 0,'畩','番','畫',0,'畭',0,'畯', */
	/* 7570 */  4, 6,-1, 4, 4,-1, 4, 4,  4, 6, 6, 6, 6, 6, 6, 4, /* '異','畱',0,'畳','畴',0,'當','畷', '畸','畹','畺','畻','畼','畽','畾','畿', */
	/* 7580 */ -1, 6, 4,-1,-1, 6, 4, 4, -1, 4, 4, 4,-1,-1, 4, 4, /* 0,'疁','疂',0,0,'疅','疆','疇', 0,'疉','疊','疋',0,0,'疎','疏', */
	/* 7590 */  6, 4, 6, 6, 4, 6,-1,-1, -1, 6, 4,-1, 6, 4,-1,-1, /* '疐','疑','疒','疓','疔','疕',0,0, 0,'疙','疚',0,'疜','疝',0,0, */
	/* 75a0 */ -1,-1, 6, 4, 6, 4,-1,-1, -1,-1,-1, 4,-1,-1,-1,-1, /* 0,0,'疢','疣','疤','疥',0,0, 0,0,0,'疫',0,0,0,0, */
	/* 75b0 */ -1, 4, 4, 4, 6, 4,-1,-1,  4, 4, 6,-1, 4, 4, 4, 6, /* 0,'疱','疲','疳','疴','疵',0,0, '疸','疹','疺',0,'疼','疽','疾','疿', */
	/* 75c0 */  6, 6, 4, 4, 6, 4, 6, 4, -1,-1, 4,-1, 6, 4, 6, 6, /* '痀','痁','痂','痃','痄','病','痆','症', 0,0,'痊',0,'痌','痍','痎','痏', */
	/* 75d0 */ -1,-1, 4,-1, 4, 4,-1, 6,  4, 4,-1, 4, 6,-1, 4, 6, /* 0,0,'痒',0,'痔','痕',0,'痗', '痘','痙',0,'痛','痜',0,'痞','痟', */
	/* 75e0 */  6, 6, 4, 4, 6,-1,-1, 6, -1, 4,-1,-1, 6,-1, 6, 6, /* '痠','痡','痢','痣','痤',0,0,'痧', 0,'痩',0,0,'痬',0,'痮','痯', */
	/* 75f0 */  4, 6, 4, 4, 4,-1,-1,-1, -1, 6, 4,-1, 4,-1, 4, 4, /* '痰','痱','痲','痳','痴',0,0,0, 0,'痹','痺',0,'痼',0,'痾','痿', */
	/* 7600 */  6, 4, 6, 6, 6,-1,-1, 6,  6, 4, 6, 4, 6, 4,-1, 6, /* '瘀','瘁','瘂','瘃','瘄',0,0,'瘇', '瘈','瘉','瘊','瘋','瘌','瘍',0,'瘏', */
	/* 7610 */ -1,-1, 6, 6,-1, 6, 6,-1, -1, 6,-1, 6, 6, 6, 6, 4, /* 0,0,'瘒','瘓',0,'瘕','瘖',0, 0,'瘙',0,'瘛','瘜','瘝','瘞','瘟', */
	/* 7620 */  4, 4, 4, 6, 4, 6, 6, 4, -1, 6,-1,-1,-1, 6,-1,-1, /* '瘠','瘡','瘢','瘣','瘤','瘥','瘦','瘧', 0,'瘩',0,0,0,'瘭',0,0, */
	/* 7630 */  4,-1, 6, 6, 4, 6,-1,-1,  6, 6, 6, 4, 6,-1,-1,-1, /* '瘰',0,'瘲','瘳','瘴','瘵',0,0, '瘸','瘹','瘺','瘻','瘼',0,0,0, */
	/* 7640 */  6, 6, 4, 6, 6, 6, 4, 4,  4, 6, 6, 6, 4,-1,-1,-1, /* '癀','癁','療','癃','癄','癅','癆','癇', '癈','癉','癊','癋','癌',0,0,0, */
	/* 7650 */ -1,-1, 4,-1,-1, 6, 4,-1,  4, 6,-1,-1, 4,-1,-1, 6, /* 0,0,'癒',0,0,'癕','癖',0, '癘','癙',0,0,'癜',0,0,'癟', */
	/* 7660 */ -1, 4, 4,-1, 6, 6,-1, 4,  4, 4, 4,-1, 4, 6, 6, 6, /* 0,'癡','癢',0,'癤','癥',0,'癧', '癨','癩','癪',0,'癬','癭','癮','癯', */
	/* 7670 */  4, 6, 4,-1, 6,-1, 4,-1,  4,-1, 4, 4, 4, 4, 4,-1, /* '癰','癱','癲',0,'癴',0,'癶',0, '癸',0,'発','登','發','白','百',0, */
	/* 7680 */  4, 6, 6, 4, 4, 6, 4, 4,  4,-1,-1, 4, 6, 6, 4,-1, /* '皀','皁','皂','皃','的','皅','皆','皇', '皈',0,0,'皋','皌','皍','皎',0, */
	/* 7690 */  4,-1,-1, 4,-1, 6, 4,-1, -1, 4, 4, 6, 6, 6, 6, 6, /* '皐',0,0,'皓',0,'皕','皖',0, 0,'皙','皚','皛','皜','皝','皞','皟', */
	/* 76a0 */  6,-1, 6, 6, 6, 6, 6, 6,  6,-1, 6,-1,-1, 6, 4,-1, /* '皠',0,'皢','皣','皤','皥','皦','皧', '皨',0,'皪',0,0,'皭','皮',0, */
	/* 76b0 */  4,-1,-1,-1, 4,-1,-1, 4,  4, 4, 4,-1,-1, 6,-1, 4, /* '皰',0,0,0,'皴',0,0,'皷', '皸','皹','皺',0,0,'皽',0,'皿', */
	/* 76c0 */ -1, 6, 4, 4,-1, 6, 4,-1,  4, 6, 4, 6, 6, 4, 6,-1, /* 0,'盁','盂','盃',0,'盅','盆',0, '盈','盉','益','盋','盌','盍','盎',0, */
	/* 76d0 */ -1,-1, 4,-1, 6,-1, 4, 4, -1, 6,-1, 4, 4,-1, 4, 4, /* 0,0,'盒',0,'盔',0,'盖','盗', 0,'盙',0,'盛','盜',0,'盞','盟', */
	/* 76e0 */  6, 4,-1, 4, 4, 4, 6, 4,  6,-1, 4,-1, 6,-1, 4,-1, /* '盠','盡',0,'監','盤','盥','盦','盧', '盨',0,'盪',0,'盬',0,'目',0, */
	/* 76f0 */  6, 6, 4,-1, 4,-1, 6,-1,  4, 6,-1, 4, 6,-1, 4,-1, /* '盰','盱','盲',0,'直',0,'盶',0, '相','盹',0,'盻','盼',0,'盾',0, */
	/* 7700 */  6, 4,-1,-1, 4,-1, 6, 4,  4, 4, 6, 4, 4,-1, 6,-1, /* '眀','省',0,0,'眄',0,'眆','眇', '眈','眉','眊','看','県',0,'眎',0, */
	/* 7710 */ -1,-1, 6,-1, 6, 6,-1, 6, -1, 6, 6, 4, 6,-1, 4, 4, /* 0,0,'眒',0,'眔','眕',0,'眗', 0,'眙','眚','眛','眜',0,'眞','真', */
	/* 7720 */  4,-1, 6,-1, 4, 4, 4,-1,  6, 4,-1,-1,-1, 6, 6, 6, /* '眠',0,'眢',0,'眤','眥','眦',0, '眨','眩',0,0,0,'眭','眮','眯', */
	/* 7730 */ -1,-1,-1,-1, 6, 6, 6, 4,  4, 6, 4,-1, 4, 6, 6,-1, /* 0,0,0,0,'眴','眵','眶','眷', '眸','眹','眺',0,'眼','眽','眾',0, */
	/* 7740 */  4,-1, 6,-1,-1, 6, 6, 4, -1,-1, 6,-1,-1, 6, 6, 6, /* '着',0,'睂',0,0,'睅','睆','睇', 0,0,'睊',0,0,'睍','睎','睏', */
	/* 7750 */ -1,-1, 6,-1,-1,-1, 6, 6, -1,-1, 4, 4, 6,-1, 6, 6, /* 0,0,'睒',0,0,0,'睖','睗', 0,0,'睚','睛','睜',0,'睞','睟', */
	/* 7760 */  6, 4, 6, 4, 6, 4, 4, 6,  4,-1, 6, 4, 6,-1,-1,-1, /* '睠','睡','睢','督','睤','睥','睦','睧', '睨',0,'睪','睫','睬',0,0,0, */
	/* 7770 */  6,-1, 6, 6, 6,-1,-1,-1, -1, 4, 6,-1,-1, 6, 4, 4, /* '睰',0,'睲','睳','睴',0,0,0, 0,'睹','睺',0,0,'睽','睾','睿', */
	/* 7780 */  6,-1,-1,-1, 6,-1,-1,-1, -1,-1,-1, 4, 6, 6, 4,-1, /* '瞀',0,0,0,'瞄',0,0,0, 0,0,0,'瞋','瞌','瞍','瞎',0, */
	/* 7790 */ -1, 4,-1,-1, 6, 6, 6,-1, -1,-1, 6,-1,-1,-1, 4, 6, /* 0,'瞑',0,0,'瞔','瞕','瞖',0, 0,0,'瞚',0,0,0,'瞞','瞟', */
	/* 77a0 */  4,-1, 6,-1,-1, 4,-1, 6, -1,-1, 6,-1, 4, 4, 6, 6, /* '瞠',0,'瞢',0,0,'瞥',0,'瞧', 0,0,'瞪',0,'瞬','瞭','瞮','瞯', */
	/* 77b0 */  4, 6,-1, 4,-1, 6, 4,-1, -1, 4,-1, 4, 4, 4, 6, 4, /* '瞰','瞱',0,'瞳',0,'瞵','瞶',0, 0,'瞹',0,'瞻','瞼','瞽','瞾','瞿', */
	/* 77c0 */ -1,-1,-1, 6,-1,-1,-1, 4, -1, 6,-1,-1,-1, 4,-1,-1, /* 0,0,0,'矃',0,0,0,'矇', 0,'矉',0,0,0,'矍',0,0, */
	/* 77d0 */ -1, 6, 6,-1,-1, 6,-1, 4, -1, 6, 4, 4, 4,-1, 6, 6, /* 0,'矑','矒',0,0,'矕',0,'矗', 0,'矙','矚','矛','矜',0,'矞','矟', */
	/* 77e0 */  6,-1, 4, 4, 6, 4, 6, 4, -1, 4, 6,-1, 6, 4, 4, 4, /* '矠',0,'矢','矣','矤','知','矦','矧', 0,'矩','矪',0,'矬','短','矮','矯', */
	/* 77f0 */  6, 6,-1, 4, 6,-1,-1,-1,  6,-1,-1, 6, 4,-1,-1,-1, /* '矰','矱',0,'石','矴',0,0,0, '矸',0,0,'矻','矼',0,0,0, */
	/* 7800 */ -1,-1, 4,-1,-1, 6, 6,-1, -1, 6,-1,-1, 4, 6, 6,-1, /* 0,0,'砂',0,0,'砅','砆',0, 0,'砉',0,0,'砌','砍','砎',0, */
	/* 7810 */ -1, 6, 4,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1, 6,-1,-1, /* 0,'砑','砒',0,'研','砕',0,0, 0,0,0,0,0,'砝',0,0, */
	/* 7820 */  4, 6, 6, 6,-1, 4, 4, 4, -1,-1,-1,-1,-1, 6, 6,-1, /* '砠','砡','砢','砣',0,'砥','砦','砧', 0,0,0,0,0,'砭','砮',0, */
	/* 7830 */  6,-1, 4,-1, 4, 6,-1, 6, -1,-1, 4,-1,-1,-1,-1, 4, /* '砰',0,'砲',0,'破','砵',0,'砷', 0,0,'砺',0,0,0,0,'砿', */
	/* 7840 */ -1,-1,-1, 6, 6, 4,-1, 6,  6,-1,-1,-1, 6,-1, 6,-1, /* 0,0,0,'硃','硄','硅',0,'硇', '硈',0,0,0,'硌',0,'硎',0, */
	/* 7850 */ -1,-1, 6,-1,-1,-1,-1,-1, -1,-1,-1,-1, 6, 4, 6,-1, /* 0,0,'硒',0,0,0,0,0, 0,0,0,0,'硜','硝','硞',0, */
	/* 7860 */  6, 6,-1, 6, 6,-1,-1,-1,  6,-1, 6, 4, 4,-1, 6, 4, /* '硠','硡',0,'硣','硤',0,0,0, '硨',0,'硪','硫','硬',0,'确','硯', */
	/* 7870 */ -1,-1, 4,-1, 4,-1,-1,-1, -1,-1, 6,-1, 4,-1, 6,-1, /* 0,0,'硲',0,'硴',0,0,0, 0,0,'硺',0,'硼',0,'硾',0, */
	/* 7880 */ -1, 4,-1,-1,-1,-1, 4, 4, -1,-1, 6,-1, 4, 4, 4, 6, /* 0,'碁',0,0,0,0,'碆','碇', 0,0,'碊',0,'碌','碍','碎','碏', */
	/* 7890 */ -1, 4,-1, 4, 6, 4,-1, 4,  6,-1, 4,-1,-1, 6, 6, 6, /* 0,'碑',0,'碓','碔','碕',0,'碗', '碘',0,'碚',0,0,'碝','碞','碟', */
	/* 78a0 */ -1, 6,-1, 4, 6,-1,-1, 4,  6, 4, 4,-1, 6, 6,-1, 4, /* 0,'碡',0,'碣','碤',0,0,'碧', '碨','碩','碪',0,'碬','碭',0,'碯', */
	/* 78b0 */  6, 6, 6, 6,-1, 4,-1,-1, -1,-1, 4, 6, 4, 6, 4, 6, /* '碰','碱','碲','碳',0,'碵',0,0, 0,0,'確','碻','碼','碽','碾','碿', */
	/* 78c0 */ -1, 4,-1,-1,-1, 4, 4, 6,  6, 6, 4, 4, 6,-1, 6,-1, /* 0,'磁',0,0,0,'磅','磆','磇', '磈','磉','磊','磋','磌',0,'磎',0, */
	/* 78d0 */  4, 4, 6, 6, 4, 6, 6,-1, -1,-1, 4, 6,-1,-1,-1, 6, /* '磐','磑','磒','磓','磔','磕','磖',0, 0,0,'磚','磛',0,0,0,'磟', */
	/* 78e0 */  6, 6,-1,-1, 6,-1, 6, 4,  4,-1, 6,-1, 4,-1,-1, 4, /* '磠','磡',0,0,'磤',0,'磦','磧', '磨',0,'磪',0,'磬',0,0,'磯', */
	/* 78f0 */ -1,-1, 6, 6, 4,-1, 6, 6, -1,-1, 6, 6,-1, 4,-1, 6, /* 0,0,'磲','磳','磴',0,'磶','磷', 0,0,'磺','磻',0,'磽',0,'磿', */
	/* 7900 */  6, 4,-1,-1,-1,-1, 6, 4, -1,-1,-1,-1, 6,-1, 4,-1, /* '礀','礁',0,0,0,0,'礆','礇', 0,0,0,0,'礌',0,'礎',0, */
	/* 7910 */  6, 4, 4,-1,-1,-1,-1,-1, -1, 4, 6,-1, 6,-1, 6, 6, /* '礐','礑','礒',0,0,0,0,0, 0,'礙','礚',0,'礜',0,'礞','礟', */
	/* 7920 */  6,-1,-1,-1,-1, 6, 4, 6, -1, 6, 4, 4, 4, 6,-1,-1, /* '礠',0,0,0,0,'礥','礦','礧', 0,'礩','礪','礫','礬','礭',0,0, */
	/* 7930 */  6, 6,-1,-1, 6, 6,-1,-1, -1,-1, 4, 6, 4, 6, 4, 6, /* '礰','礱',0,0,'礴','礵',0,0, 0,0,'示','礻','礼','礽','社','礿', */
	/* 7940 */  4, 4,-1,-1, 6, 6, 6, 4,  4, 4, 6, 6,-1,-1,-1, 6, /* '祀','祁',0,0,'祄','祅','祆','祇', '祈','祉','祊','祋',0,0,0,'祏', */
	/* 7950 */  4, 6,-1, 4, 6, 4, 4, 4,  6,-1, 4, 6, 6, 4, 4, 4, /* '祐','祑',0,'祓','祔','祕','祖','祗', '祘',0,'祚','祛','祜','祝','神','祟', */
	/* 7960 */  4,-1, 4,-1,-1, 4,-1, 6,  4, 6,-1, 6,-1, 4,-1,-1, /* '祠',0,'祢',0,0,'祥',0,'祧', '票','祩',0,'祫',0,'祭',0,0, */
	/* 7970 */ -1,-1, 6,-1,-1,-1,-1, 4, -1, 6, 4, 6, 6,-1, 6, 4, /* 0,0,'祲',0,0,0,0,'祷', 0,'祹','祺','祻','祼',0,'祾','祿', */
	/* 7980 */  4, 4,-1,-1, 4, 4,-1,-1, -1,-1, 4, 6, 6, 4, 4, 4, /* '禀','禁',0,0,'禄','禅',0,0, 0,0,'禊','禋','禌','禍','禎','福', */
	/* 7990 */ -1, 6,-1, 6, 6, 6, 6,-1,  6,-1,-1, 6, 6, 4,-1,-1, /* 0,'禑',0,'禓','禔','禕','禖',0, '禘',0,0,'禛','禜','禝',0,0, */
	/* 79a0 */ -1, 6,-1,-1,-1,-1, 4, 4,  6, 6, 4, 6,-1,-1, 4, 6, /* 0,'禡',0,0,0,0,'禦','禧', '禨','禩','禪','禫',0,0,'禮','禯', */
	/* 79b0 */  4, 6,-1, 4, 6,-1,-1,-1,  6, 4, 4, 6,-1, 4, 4, 4, /* '禰','禱',0,'禳','禴',0,0,0, '禸','禹','禺','离',0,'禽','禾','禿', */
	/* 79c0 */  4, 4, 6,-1, 6,-1,-1, 6,  6, 4, 6, 4,-1,-1,-1, 6, /* '秀','私','秂',0,'秄',0,0,'秇', '秈','秉','秊','秋',0,0,0,'秏', */
	/* 79d0 */ -1, 4, 4,-1, 6, 4, 6,-1,  4,-1, 6,-1,-1, 6, 6, 4, /* 0,'科','秒',0,'秔','秕','秖',0, '秘',0,'秚',0,0,'秝','秞','租', */
	/* 79e0 */  6, 4, 6, 4, 4, 6, 4, 4, -1, 4, 6, 6, 4, 6,-1,-1, /* '秠','秡','秢','秣','秤','秥','秦','秧', 0,'秩','秪','秫','秬','秭',0,0, */
	/* 79f0 */  4, 6,-1,-1,-1,-1,-1,-1,  6,-1,-1, 4, 6,-1,-1,-1, /* '称','秱',0,0,0,0,0,0, '秸',0,0,'移','秼',0,0,0, */
	/* 7a00 */  4,-1, 6, 6,-1,-1,-1, 6,  4, 6, 6, 4, 6, 4, 4,-1, /* '稀',0,'稂','稃',0,0,0,'稇', '稈','稉','稊','程','稌','稍','税',0, */
	/* 7a10 */ -1, 6,-1,-1, 4, 6,-1, 4,  4, 4, 4, 6, 4,-1, 6, 4, /* 0,'稑',0,0,'稔','稕',0,'稗', '稘','稙','稚','稛','稜',0,'稞','稟', */
	/* 7a20 */  4, 6,-1,-1,-1,-1,-1, 6, -1,-1,-1, 6,-1, 6, 4, 6, /* '稠','稡',0,0,0,0,0,'稧', 0,0,0,'稫',0,'稭','種','稯', */
	/* 7a30 */  6, 4, 4,-1, 6, 6,-1, 4,  6, 6, 6, 4, 4, 4, 4, 4, /* '稰','稱','稲',0,'稴','稵',0,'稷', '稸','稹','稺','稻','稼','稽','稾','稿', */
	/* 7a40 */  4,-1, 4, 4, 6, 6, 4, 6,  6, 4,-1,-1, 6, 4, 4, 4, /* '穀',0,'穂','穃','穄','穅','穆','穇', '穈','穉',0,0,'穌','積','穎','穏', */
	/* 7a50 */  4,-1,-1,-1,-1, 6, 6, 4, -1, 6,-1,-1, 6, 6,-1, 6, /* '穐',0,0,0,0,'穕','穖','穗', 0,'穙',0,0,'穜','穝',0,'穟', */
	/* 7a60 */  6, 4, 4, 4,-1, 6,-1, 6, -1, 4, 6, 4,-1, 6,-1,-1, /* '穠','穡','穢','穣',0,'穥',0,'穧', 0,'穩','穪','穫',0,'穭',0,0, */
	/* 7a70 */  4,-1,-1,-1, 4, 6, 4,-1,  6, 4, 4,-1,-1, 4, 6, 4, /* '穰',0,0,0,'穴','穵','究',0, '穸','穹','空',0,0,'穽','穾','穿', */
	/* 7a80 */  6, 4, 6, 4, 4, 6, 6,-1,  4,-1, 6, 6,-1,-1,-1,-1, /* '窀','突','窂','窃','窄','窅','窆',0, '窈',0,'窊','窋',0,0,0,0, */
	/* 7a90 */  6, 6, 4, 4, 6, 4, 4, 4,  4,-1,-1,-1,-1,-1, 6, 4, /* '窐','窑','窒','窓','窔','窕','窖','窗', '窘',0,0,0,0,0,'窞','窟', */
	/* 7aa0 */  6,-1,-1, 6,-1,-1,-1,-1, -1, 4, 4,-1, 6,-1, 4, 4, /* '窠',0,0,'窣',0,0,0,0, 0,'窩','窪',0,'窬',0,'窮','窯', */
	/* 7ab0 */  4,-1,-1, 6,-1, 6, 4,-1, -1, 6, 4, 6, 6,-1,-1, 4, /* '窰',0,0,'窳',0,'窵','窶',0, 0,'窹','窺','窻','窼',0,0,'窿', */
	/* 7ac0 */ -1,-1,-1, 4, 4, 4, 6, 4,  4, 6, 4, 4, 6, 4, 6, 4, /* 0,0,0,'竃','竄','竅','竆','竇', '竈','竉','竊','立','竌','竍','竎','竏', */
	/* 7ad0 */ -1, 6, 4, 4,-1, 4,-1,-1, -1, 4, 4, 6, 4, 4,-1, 4, /* 0,'竑','竒','竓',0,'竕',0,0, 0,'站','竚','竛','竜','竝',0,'竟', */
	/* 7ae0 */  4, 4, 4, 4,-1, 4, 4, 6,  6, 6, 4, 6, 6, 4,-1, 4, /* '章','竡','竢','竣',0,'童','竦','竧', '竨','竩','竪','竫','竬','竭',0,'端', */
	/* 7af0 */  4, 6,-1,-1, 6,-1, 4,-1,  4, 4, 4, 6,-1, 6, 6, 4, /* '竰','竱',0,0,'竴',0,'競',0, '竸','竹','竺','竻',0,'竽','竾','竿', */
	/* 7b00 */ -1,-1, 4,-1, 4,-1, 4, 6,  4,-1, 4, 4,-1,-1,-1, 4, /* 0,0,'笂',0,'笄',0,'笆','笇', '笈',0,'笊','笋',0,0,0,'笏', */
	/* 7b10 */ -1, 4,-1,-1, 6,-1,-1,-1,  4, 4,-1, 4,-1,-1, 4, 6, /* 0,'笑',0,0,'笔',0,0,0, '笘','笙',0,'笛',0,0,'笞','笟', */
	/* 7b20 */  4,-1,-1, 6,-1, 4, 4, 6,  4, 6, 6, 6, 4, 6, 6, 6, /* '笠',0,0,'笣',0,'笥','符','笧', '笨','笩','笪','笫','第','笭','笮','笯', */
	/* 7b30 */  6, 6,-1, 4, 6, 4, 4,-1, -1, 4,-1,-1,-1, 6,-1, 6, /* '笰','笱',0,'笳','笴','笵','笶',0, 0,'笹',0,0,0,'笽',0,'笿', */
	/* 7b40 */  6, 6,-1,-1,-1, 4, 4, 6,  4, 4,-1, 4, 4, 4, 6, 4, /* '筀','筁',0,0,0,'筅','筆','筇', '筈','等',0,'筋','筌','筍','筎','筏', */
	/* 7b50 */  4, 4, 4,-1, 4, 6, 4,-1, -1,-1,-1,-1,-1, 4,-1,-1, /* '筐','筑','筒',0,'答','筕','策',0, 0,0,0,0,0,'筝',0,0, */
	/* 7b60 */  6,-1,-1,-1, 6, 4, 6, 4, -1, 6, 6,-1, 4, 6, 4, 6, /* '筠',0,0,0,'筤','筥','筦','筧', 0,'筩','筪',0,'筬','筭','筮','筯', */
	/* 7b70 */  4, 4, 6, 6, 4, 4,-1, 6, -1,-1, 4,-1,-1,-1,-1,-1, /* '筰','筱','筲','筳','筴','筵',0,'筷', 0,0,'筺',0,0,0,0,0, */
	/* 7b80 */ -1,-1,-1,-1, 6,-1, 4, 4, -1, 6,-1, 4,-1, 4, 6, 4, /* 0,0,0,0,'箄',0,'箆','箇', 0,'箉',0,'箋',0,'箍','箎','箏', */
	/* 7b90 */  6, 6, 4,-1, 4, 4, 6, 4,  4, 4, 4, 6, 4, 4, 6, 4, /* '箐','箑','箒',0,'箔','箕','箖','算', '箘','箙','箚','箛','箜','箝','箞','箟', */
	/* 7ba0 */  6, 4,-1,-1,-1, 6,-1,-1, -1,-1, 4,-1, 6, 4,-1, 6, /* '箠','管',0,0,0,'箥',0,0, 0,0,'箪',0,'箬','箭',0,'箯', */
	/* 7bb0 */  6, 4, 6,-1, 4, 6, 6,-1,  4,-1, 6, 6, 6, 6,-1,-1, /* '箰','箱','箲',0,'箴','箵','箶',0, '箸',0,'箺','箻','箼','箽',0,0, */
	/* 7bc0 */  4, 4, 6,-1, 4, 6, 4, 4,  6, 4, 6, 4, 4,-1,-1, 4, /* '節','篁','篂',0,'範','篅','篆','篇', '篈','築','篊','篋','篌',0,0,'篏', */
	/* 7bd0 */ -1,-1,-1,-1, 6,-1, 6, 6, -1, 6, 6, 6,-1, 4,-1,-1, /* 0,0,0,0,'篔',0,'篖','篗', 0,'篙','篚','篛',0,'篝',0,0, */
	/* 7be0 */  4,-1,-1,-1, 4, 4, 4,-1,  6, 4, 6,-1,-1, 4,-1,-1, /* '篠',0,0,0,'篤','篥','篦',0, '篨','篩','篪',0,0,'篭',0,0, */
	/* 7bf0 */ -1,-1, 6, 4, 6, 6, 4, 4,  6, 6, 6,-1, 6,-1, 6,-1, /* 0,0,'篲','篳','篴','篵','篶','篷', '篸','篹','篺',0,'篼',0,'篾',0, */
	/* 7c00 */  4, 6, 6, 6, 6,-1, 6, 4, -1, 6,-1, 6, 6, 4, 6, 6, /* '簀','簁','簂','簃','簄',0,'簆','簇', 0,'簉',0,'簋','簌','簍','簎','簏', */
	/* 7c10 */ -1, 4, 4, 4, 4,-1,-1, 4, -1, 6,-1, 6,-1,-1,-1, 4, /* 0,'簑','簒','簓','簔',0,0,'簗', 0,'簙',0,'簛',0,0,0,'簟', */
	/* 7c20 */  6, 4,-1, 4,-1, 6, 6, 4,  6,-1, 4, 4, 6,-1,-1,-1, /* '簠','簡',0,'簣',0,'簥','簦','簧', '簨',0,'簪','簫','簬',0,0,0, */
	/* 7c30 */ -1, 6,-1, 6, 6,-1, 6, 4,  4, 6, 6,-1,-1, 4, 4, 4, /* 0,'簱',0,'簳','簴',0,'簶','簷', '簸','簹','簺',0,0,'簽','簾','簿', */
	/* 7c40 */  4,-1,-1, 4,-1,-1, 6,-1, -1,-1, 6,-1, 4, 4,-1, 4, /* '籀',0,0,'籃',0,0,'籆',0, 0,0,'籊',0,'籌','籍',0,'籏', */
	/* 7c50 */  4, 6, 6, 6, 4, 6, 4,-1,  4, 6, 6, 6, 6, 6, 6, 4, /* '籐','籑','籒','籓','籔','籕','籖',0, '籘','籙','籚','籛','籜','籝','籞','籟', */
	/* 7c60 */  4, 6,-1, 6, 4, 4,-1, 6, -1, 6,-1,-1, 4, 6, 6,-1, /* '籠','籡',0,'籣','籤','籥',0,'籧', 0,'籩',0,0,'籬','籭','籮',0, */
	/* 7c70 */  6,-1, 6, 4,-1, 4,-1,-1, -1, 6,-1,-1, 6, 6, 4,-1, /* '籰',0,'籲','米',0,'籵',0,0, 0,'籹',0,0,'籼','籽','籾',0, */
	/* 7c80 */ -1, 4, 4, 4,-1,-1, 6, 6, -1, 4,-1, 4,-1, 4,-1, 6, /* 0,'粁','粂','粃',0,0,'粆','粇', 0,'粉',0,'粋',0,'粍',0,'粏', */
	/* 7c90 */  4,-1, 4,-1, 6, 4,-1, 4,  4,-1,-1, 4,-1,-1, 6, 4, /* '粐',0,'粒',0,'粔','粕',0,'粗', '粘',0,0,'粛',0,0,'粞','粟', */
	/* 7ca0 */  6, 4, 4,-1, 4, 4, 6, 4,  4,-1,-1, 4,-1, 4, 4,-1, /* '粠','粡','粢',0,'粤','粥','粦','粧', '粨',0,0,'粫',0,'粭','粮',0, */
	/* 7cb0 */  6, 4, 4, 4,-1,-1, 6, 6, -1, 4, 6, 6, 6, 4, 4, 6, /* '粰','粱','粲','粳',0,0,'粶','粷', 0,'粹','粺','粻','粼','粽','精','粿', */
	/* 7cc0 */  4,-1, 4,-1, 6, 4,-1, 6,  6, 6, 4,-1,-1, 6, 4, 6, /* '糀',0,'糂',0,'糄','糅',0,'糇', '糈','糉','糊',0,0,'糍','糎','糏', */
	/* 7cd0 */ -1,-1, 4, 6, 6, 6, 4, 6,  4, 6, 6,-1, 4, 6, 4, 4, /* 0,0,'糒','糓','糔','糕','糖','糗', '糘','糙','糚',0,'糜','糝','糞','糟', */
	/* 7ce0 */  4,-1, 4,-1,-1,-1, 6, 4, -1, 6,-1, 6,-1,-1,-1, 4, /* '糠',0,'糢',0,0,0,'糦','糧', 0,'糩',0,'糫',0,0,0,'糯', */
	/* 7cf0 */ -1,-1, 4,-1, 4, 6, 4,-1,  4,-1, 4, 4,-1,-1, 4,-1, /* 0,0,'糲',0,'糴','糵','糶',0, '糸',0,'糺','系',0,0,'糾',0, */
	/* 7d00 */  4,-1, 4, 6, 4, 4, 4, 6,  6, 6, 4, 4,-1, 4,-1, 6, /* '紀',0,'紂','紃','約','紅','紆','紇', '紈','紉','紊','紋',0,'納',0,'紏', */
	/* 7d10 */  4, 6, 6, 6, 4, 4, 6, 4,  4, 4, 4, 4, 4, 6, 6,-1, /* '紐','紑','紒','紓','純','紕','紖','紗', '紘','紙','級','紛','紜','紝','紞',0, */
	/* 7d20 */  4, 4, 4, 6,-1,-1, 6,-1, -1,-1, 6, 4, 4, 6, 4, 4, /* '素','紡','索','紣',0,0,'紦',0, 0,0,'紪','紫','紬','紭','紮','累', */
	/* 7d30 */  4, 6, 4, 4,-1, 4,-1,-1, -1, 4, 4,-1, 6, 6, 6, 4, /* '細','紱','紲','紳',0,'紵',0,0, 0,'紹','紺',0,'紼','紽','紾','紿', */
	/* 7d40 */  6, 6, 4, 4, 4, 4, 4, 6,  6,-1,-1, 4, 4, 6, 4, 4, /* '絀','絁','終','絃','組','絅','絆','絇', '絈',0,0,'絋','経','絍','絎','絏', */
	/* 7d50 */  4, 6,-1, 6,-1,-1, 4, 6, -1, 6, 6, 4, 6, 6, 4,-1, /* '結','絑',0,'絓',0,0,'絖','絗', 0,'絙','絚','絛','絜','絝','絞',0, */
	/* 7d60 */ -1, 4, 4, 4,-1, 6, 4, 6,  4,-1, 6,-1,-1,-1, 4,-1, /* 0,'絡','絢','絣',0,'絥','給','絧', '絨',0,'絪',0,0,0,'絮',0, */
	/* 7d70 */  6, 4, 4, 4,-1, 4, 4,-1,  6, 4, 6, 6,-1, 4,-1, 6, /* '絰','統','絲','絳',0,'絵','絶',0, '絸','絹','絺','絻',0,'絽',0,'絿', */
	/* 7d80 */ -1, 6, 6, 6,-1, 6, 6,-1,  6, 4,-1, 6, 6, 6,-1, 4, /* 0,'綁','綂','綃',0,'綅','綆',0, '綈','綉',0,'綋','綌','綍',0,'綏', */
	/* 7d90 */ -1, 6,-1, 4,-1,-1, 6, 6, -1, 4, 4, 4, 4, 6, 6, 4, /* 0,'綑',0,'經',0,0,'綖','綗', 0,'継','続','綛','綜','綝','綞','綟', */
	/* 7da0 */  6,-1, 4, 4,-1,-1, 6, 6, -1,-1, 6, 4, 4, 4, 4, 4, /* '綠',0,'綢','綣',0,0,'綦','綧', 0,0,'綪','綫','綬','維','綮','綯', */
	/* 7db0 */  4, 4, 4, 6, 4, 4, 6, 6,  4, 6, 4, 4,-1, 4, 4, 4, /* '綰','綱','網','綳','綴','綵','綶','綷', '綸','綹','綺','綻',0,'綽','綾','綿', */
	/* 7dc0 */ -1,-1, 6, 6, 6, 6, 6, 4, -1,-1, 4, 4, 6, 6, 6, 4, /* 0,0,'緂','緃','緄','緅','緆','緇', 0,0,'緊','緋','緌','緍','緎','総', */
	/* 7dd0 */ -1, 4, 4,-1,-1, 4, 6, 6,  4, 6, 4,-1, 4, 4, 4,-1, /* 0,'緑','緒',0,0,'緕','緖','緗', '緘','緙','線',0,'緜','緝','緞',0, */
	/* 7de0 */  4, 4, 6,-1, 4, 6, 6,-1,  4, 4, 6, 6, 4, 6,-1, 4, /* '締','緡','緢',0,'緤','緥','緦',0, '編','緩','緪','緫','緬','緭',0,'緯', */
	/* 7df0 */ -1, 6, 4,-1, 4, 6, 6,-1, -1, 6, 6, 4,-1,-1,-1,-1, /* 0,'緱','緲',0,'練','緵','緶',0, 0,'緹','緺','緻',0,0,0,0, */
	/* 7e00 */  6, 4,-1,-1, 4, 4,-1,-1,  6, 4, 4, 4,-1,-1,-1,-1, /* '縀','縁',0,0,'縄','縅',0,0, '縈','縉','縊','縋',0,0,0,0, */
	/* 7e10 */  6, 6, 4,-1,-1, 6,-1, 6, -1,-1,-1, 4, 6, 6, 4, 4, /* '縐','縑','縒',0,0,'縕',0,'縗', 0,0,0,'縛','縜','縝','縞','縟', */
	/* 7e20 */  6, 4, 4, 4,-1,-1, 4, 6,  6,-1,-1, 4, 6, 6, 4, 6, /* '縠','縡','縢','縣',0,0,'縦','縧', '縨',0,0,'縫','縬','縭','縮','縯', */
	/* 7e30 */ -1, 4, 4, 6,-1, 4, 6, 4, -1, 4, 4, 4,-1, 4, 4, 6, /* 0,'縱','縲','縳',0,'縵','縶','縷', 0,'縹','縺','縻',0,'總','績','縿', */
	/* 7e40 */ -1, 4,-1, 4, 6, 6, 4, 6, -1,-1, 4, 4,-1, 4, 6,-1, /* 0,'繁',0,'繃','繄','繅','繆','繇', 0,0,'繊','繋',0,'繍','繎',0, */
	/* 7e50 */  6,-1, 6,-1, 4, 4, 4,-1,  6, 4, 4,-1,-1, 4, 4, 6, /* '繐',0,'繒',0,'織','繕','繖',0, '繘','繙','繚',0,0,'繝','繞','繟', */
	/* 7e60 */ -1, 6, 6,-1,-1, 6, 4, 4, -1, 4, 4, 6,-1, 4, 6, 6, /* 0,'繡','繢',0,0,'繥','繦','繧', 0,'繩','繪','繫',0,'繭','繮','繯', */
	/* 7e70 */  4,-1,-1, 6,-1,-1,-1,-1,  6, 4,-1, 4, 4, 4, 6, 4, /* '繰',0,0,'繳',0,0,0,0, '繸','繹',0,'繻','繼','繽','繾','繿', */
	/* 7e80 */ -1, 6, 4, 4,-1,-1, 6, 6,  4, 4, 6,-1, 4, 6, 4, 4, /* 0,'纁','纂','纃',0,0,'纆','纇', '纈','纉','纊',0,'續','纍','纎','纏', */
	/* 7e90 */  4, 6, 4, 4, 4, 6, 4,-1,  6,-1, 6, 4, 4, 6, 6,-1, /* '纐','纑','纒','纓','纔','纕','纖',0, '纘',0,'纚','纛','纜','纝','纞',0, */
	/* 7ea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7eb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7ef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 7f30 */ -1,-1,-1,-1,-1,-1, 4,-1,  4,-1, 4, 6, 6, 6, 6, 6, /* 0,0,0,0,0,0,'缶',0, '缸',0,'缺','缻','缼','缽','缾','缿', */
	/* 7f40 */ -1,-1,-1, 6, 6, 4,-1, 6, -1,-1,-1,-1, 4, 4, 4, 6, /* 0,0,0,'罃','罄','罅',0,'罇', 0,0,0,0,'罌','罍','罎','罏', */
	/* 7f50 */  4, 4, 6, 6, 4, 4,-1,-1,  4,-1,-1, 6, 6, 6,-1, 4, /* '罐','网','罒','罓','罔','罕',0,0, '罘',0,0,'罛','罜','罝',0,'罟', */
	/* 7f60 */  4, 6,-1, 6, 6, 6, 6, 4,  4, 4, 4, 4,-1, 6, 4,-1, /* '罠','罡',0,'罣','罤','罥','罦','罧', '罨','罩','罪','罫',0,'罭','置',0, */
	/* 7f70 */  4, 6, 4,-1,-1, 4,-1, 4,  4, 4,-1,-1,-1, 6, 6, 6, /* '罰','罱','署',0,0,'罵',0,'罷', '罸','罹',0,0,0,'罽','罾','罿', */
	/* 7f80 */  6,-1, 4, 4,-1, 4, 4, 4,  4,-1, 4, 6, 4, 6, 4, 6, /* '羀',0,'羂','羃',0,'羅','羆','羇', '羈',0,'羊','羋','羌','羍','美','羏', */
	/* 7f90 */  6, 6,-1,-1, 4,-1, 6, 6, -1,-1, 4,-1, 6, 4, 4,-1, /* '羐','羑',0,0,'羔',0,'羖','羗', 0,0,'羚',0,'羜','羝','羞',0, */
	/* 7fa0 */ -1, 6, 6, 4, 4,-1, 6,-1,  4, 4, 6,-1,-1, 6, 4, 4, /* 0,'羡','羢','羣','群',0,'羦',0, '羨','義','羪',0,0,'羭','羮','羯', */
	/* 7fb0 */ -1,-1, 4,-1, 6,-1, 4,-1,  4, 4,-1,-1, 6, 4,-1, 6, /* 0,0,'羲',0,'羴',0,'羶',0, '羸','羹',0,0,'羼','羽',0,'羿', */
	/* 7fc0 */  6, 4,-1, 6,-1, 4, 4,-1,  6,-1, 4,-1, 4,-1, 6, 6, /* '翀','翁',0,'翃',0,'翅','翆',0, '翈',0,'翊',0,'翌',0,'翎','翏', */
	/* 7fd0 */ -1,-1, 4,-1, 4, 4,-1,-1, -1,-1,-1, 6,-1,-1,-1, 6, /* 0,0,'習',0,'翔','翕',0,0, 0,0,0,'翛',0,0,0,'翟', */
	/* 7fe0 */  4, 4,-1, 6,-1, 6, 4,-1,  6, 4,-1, 4, 6,-1, 6, 6, /* '翠','翡',0,'翣',0,'翥','翦',0, '翨','翩',0,'翫','翬',0,'翮','翯', */
	/* 7ff0 */  4,-1, 6, 4,-1,-1,-1,-1, -1, 4, 6, 4, 4, 6, 6, 6, /* '翰',0,'翲','翳',0,0,0,0, 0,'翹','翺','翻','翼','翽','翾','翿', */
	/* 8000 */  4, 4,-1, 4, 4, 4, 4, 6,  6,-1, 6, 4, 4, 6, 6, 6, /* '耀','老',0,'考','耄','者','耆','耇', '耈',0,'耊','耋','而','耍','耎','耏', */
	/* 8010 */  4, 6, 4, 6, 6, 4, 6, 4,  4, 4,-1,-1, 4, 6, 6, 6, /* '耐','耑','耒','耓','耔','耕','耖','耗', '耘','耙',0,0,'耜','耝','耞','耟', */
	/* 8020 */  6, 4,-1,-1, 6,-1, 6,-1,  4,-1,-1,-1, 6,-1, 6,-1, /* '耠','耡',0,0,'耤',0,'耦',0, '耨',0,0,0,'耬',0,'耮',0, */
	/* 8030 */  6,-1,-1, 4, 6, 6, 4, 6, -1, 6, 6, 4, 6, 4, 6, 4, /* '耰',0,0,'耳','耴','耵','耶','耷', 0,'耹','耺','耻','耼','耽','耾','耿', */
	/* 8040 */  6,-1,-1,-1, 6,-1, 4,-1, -1,-1, 4,-1,-1,-1,-1,-1, /* '聀',0,0,0,'聄',0,'聆',0, 0,0,'聊',0,0,0,0,0, */
	/* 8050 */ -1,-1, 4,-1,-1,-1, 4,-1,  4,-1, 4,-1,-1,-1, 4, 4, /* 0,0,'聒',0,0,0,'聖',0, '聘',0,'聚',0,0,0,'聞','聟', */
	/* 8060 */  6, 4, 4,-1, 6,-1, 6,-1,  4,-1,-1,-1,-1, 6,-1, 4, /* '聠','聡','聢',0,'聤',0,'聦',0, '聨',0,0,0,0,'聭',0,'聯', */
	/* 8070 */  4, 6, 4, 4, 4, 6, 4, 4, -1, 4,-1,-1,-1, 4, 4, 4, /* '聰','聱','聲','聳','聴','聵','聶','職', 0,'聹',0,0,0,'聽','聾','聿', */
	/* 8080 */ -1, 6,-1,-1, 4, 4, 4, 4,  6, 4,-1, 4, 4,-1, 6,-1, /* 0,'肁',0,0,'肄','肅','肆','肇', '肈','肉',0,'肋','肌',0,'肎',0, */
	/* 8090 */ -1,-1,-1, 4,-1,-1, 4,-1,  4,-1, 4, 4, 6, 4, 6,-1, /* 0,0,0,'肓',0,0,'肖',0, '肘',0,'肚','肛','肜','肝','肞',0, */
	/* 80a0 */ -1, 4, 4,-1,-1, 4, 6, 6, -1, 4, 4, 6, 4, 4,-1, 4, /* 0,'股','肢',0,0,'肥','肦','肧', 0,'肩','肪','肫','肬','肭',0,'肯', */
	/* 80b0 */ -1, 4, 4,-1, 4,-1,-1,-1,  6, 6, 4,-1,-1,-1,-1,-1, /* 0,'肱','育',0,'肴',0,0,0, '肸','肹','肺',0,0,0,0,0, */
	/* 80c0 */ -1,-1,-1, 4, 4,-1, 4,-1,  6,-1,-1,-1, 4, 6, 4, 6, /* 0,0,0,'胃','胄',0,'胆',0, '胈',0,0,0,'背','胍','胎','胏', */
	/* 80d0 */ -1,-1, 6,-1, 6, 6, 4, 6,  6, 4, 4, 4,-1, 4, 4,-1, /* 0,0,'胒',0,'胔','胕','胖','胗', '胘','胙','胚','胛',0,'胝','胞',0, */
	/* 80e0 */  6, 4,-1,-1, 4, 4,-1,-1, -1,-1,-1,-1,-1, 6, 6, 4, /* '胠','胡',0,0,'胤','胥',0,0, 0,0,0,0,0,'胭','胮','胯', */
	/* 80f0 */  6, 4, 6, 6, 4,-1, 6,-1,  4, 6, 6,-1, 4, 4, 6,-1, /* '胰','胱','胲','胳','胴',0,'胶',0, '胸','胹','胺',0,'胼','能','胾',0, */
	/* 8100 */ -1,-1, 4, 6,-1, 4, 4, 4,  4, 4, 4, 6,-1,-1,-1,-1, /* 0,0,'脂','脃',0,'脅','脆','脇', '脈','脉','脊','脋',0,0,0,0, */
	/* 8110 */ -1,-1,-1,-1,-1,-1, 6, 6,  6,-1, 4, 4, 6,-1, 6,-1, /* 0,0,0,0,0,0,'脖','脗', '脘',0,'脚','脛','脜',0,'脞',0, */
	/* 8120 */  6,-1,-1, 4, 6,-1,-1, 6, -1, 4,-1,-1, 6,-1,-1, 4, /* '脠',0,0,'脣','脤',0,0,'脧', 0,'脩',0,0,'脬',0,0,'脯', */
	/* 8130 */  6, 4,-1, 4,-1, 6,-1,-1, -1, 4, 6,-1, 6,-1, 4,-1, /* '脰','脱',0,'脳',0,'脵',0,0, 0,'脹','脺',0,'脼',0,'脾',0, */
	/* 8140 */ -1,-1,-1,-1,-1, 6, 4, 6, -1,-1, 6, 4, 6,-1, 4,-1, /* 0,0,0,0,0,'腅','腆','腇', 0,0,'腊','腋','腌',0,'腎',0, */
	/* 8150 */  4, 4, 6, 4, 4, 4,-1, 6, -1,-1,-1,-1,-1,-1,-1, 4, /* '腐','腑','腒','腓','腔','腕',0,'腗', 0,0,0,0,0,0,0,'腟', */
	/* 8160 */  6, 6,-1,-1,-1, 4, 4, 6,  6, 6,-1, 4,-1, 6, 4, 6, /* '腠','腡',0,0,0,'腥','腦','腧', '腨','腩',0,'腫',0,'腭','腮','腯', */
	/* 8170 */  4, 4,-1,-1, 4,-1,-1, 6,  4, 4, 4,-1,-1,-1,-1, 4, /* '腰','腱',0,0,'腴',0,0,'腷', '腸','腹','腺',0,0,0,0,'腿', */
	/* 8180 */  4, 6, 4, 4, 6, 6, 6,-1,  4,-1, 4, 6,-1,-1, 6, 4, /* '膀','膁','膂','膃','膄','膅','膆',0, '膈',0,'膊','膋',0,0,'膎','膏', */
	/* 8190 */  6,-1,-1, 4,-1, 4, 6,-1,  6,-1, 4, 6, 4, 4, 6,-1, /* '膐',0,0,'膓',0,'膕','膖',0, '膘',0,'膚','膛','膜','膝','膞',0, */
	/* 81a0 */  4,-1, 6, 4, 4,-1,-1,-1,  4, 4,-1,-1,-1,-1, 6,-1, /* '膠',0,'膢','膣','膤',0,0,0, '膨','膩',0,0,0,0,'膮',0, */
	/* 81b0 */  4,-1, 6, 4, 6, 4,-1,-1,  4,-1, 4, 6,-1, 4, 4, 4, /* '膰',0,'膲','膳','膴','膵',0,0, '膸',0,'膺','膻',0,'膽','膾','膿', */
	/* 81c0 */  4,-1, 4, 6,-1, 6, 4,-1,  4, 4, 6, 6,-1, 4, 6, 6, /* '臀',0,'臂','臃',0,'臅','臆',0, '臈','臉','臊','臋',0,'臍','臎','臏', */
	/* 81d0 */ -1, 4,-1, 4,-1, 6,-1, 6,  4, 4, 4, 6,-1, 6, 6, 4, /* 0,'臑',0,'臓',0,'臕',0,'臗', '臘','臙','臚','臛',0,'臝','臞','臟', */
	/* 81e0 */  4, 6,-1, 4, 6, 4,-1, 4,  4,-1, 4, 6, 6, 4,-1,-1, /* '臠','臡',0,'臣','臤','臥',0,'臧', '臨',0,'自','臫','臬','臭',0,0, */
	/* 81f0 */  6, 6, 6, 4, 4, 6, 6,-1,  6, 6, 4, 4, 4, 6, 4, 6, /* '臰','臱','臲','至','致','臵','臶',0, '臸','臹','臺','臻','臼','臽','臾','臿', */
	/* 8200 */  6, 4, 4, 6,-1, 4,-1, 4,  4, 4, 4,-1, 4, 4, 4, 6, /* '舀','舁','舂','舃',0,'舅',0,'與', '興','舉','舊',0,'舌','舍','舎','舏', */
	/* 8210 */  4,-1, 4, 6, 6,-1, 4, 4,  4, 6, 6, 4, 4, 6, 4, 4, /* '舐',0,'舒','舓','舔',0,'舖','舗', '舘','舙','舚','舛','舜','舝','舞','舟', */
	/* 8220 */ -1, 6, 6,-1,-1,-1,-1,-1,  6, 4, 4, 4, 4,-1, 4,-1, /* 0,'舡','舢',0,0,0,0,0, '舨','舩','航','舫','般',0,'舮',0, */
	/* 8230 */ -1,-1, 6, 4, 6, 4, 4, 4,  4, 4, 6,-1,-1,-1,-1,-1, /* 0,0,'舲','舳','舴','舵','舶','舷', '舸','船','舺',0,0,0,0,0, */
	/* 8240 */  4,-1,-1, 6, 6, 6, 6, 4, -1,-1,-1, 6,-1,-1, 6, 6, /* '艀',0,0,'艃','艄','艅','艆','艇', 0,0,0,'艋',0,0,'艎','艏', */
	/* 8250 */ -1, 6,-1,-1,-1,-1, 6,-1,  4, 4, 4,-1, 6, 4,-1, 4, /* 0,'艑',0,0,0,0,'艖',0, '艘','艙','艚',0,'艜','艝',0,'艟', */
	/* 8260 */  6,-1, 4, 6, 4,-1, 4, 6,  4,-1, 4, 4,-1, 6, 4, 4, /* '艠',0,'艢','艣','艤',0,'艦','艧', '艨',0,'艪','艫',0,'艭','艮','良', */
	/* 8270 */ -1, 4, 4,-1, 6,-1, 4, 4,  4,-1,-1, 6,-1, 6, 4, 6, /* 0,'艱','色',0,'艴',0,'艶','艷', '艸',0,0,'艻',0,'艽','艾','艿', */
	/* 8280 */  6, 6,-1, 6, 6,-1,-1, 6, -1, 6, 6, 4,-1, 4, 6,-1, /* '芀','芁',0,'芃','芄',0,0,'芇', 0,'芉','芊','芋',0,'芍','芎',0, */
	/* 8290 */ -1, 6, 4,-1, 6,-1, 6,-1,  6, 4, 6, 6,-1, 4,-1, 4, /* 0,'芑','芒',0,'芔',0,'芖',0, '芘','芙','芚','芛',0,'芝',0,'芟', */
	/* 82a0 */  6, 6,-1, 6, 6, 4, 4, 6,  6, 6, 6, 4, 4, 4, 6, 4, /* '芠','芡',0,'芣','芤','芥','芦','芧', '芨','芩','芪','芫','芬','芭','芮','芯', */
	/* 82b0 */  6, 4, 6, 4, 6,-1,-1, 6,  4, 4, 6, 4, 6, 4, 6, 6, /* '芰','花','芲','芳','芴',0,0,'芷', '芸','芹','芺','芻','芼','芽','芾','芿', */
	/* 82c0 */ -1,-1,-1,-1,-1, 4, 6,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,'苅','苆',0, 0,0,0,0,0,0,0,0, */
	/* 82d0 */  6, 4, 4, 4, 4, 6,-1, 4, -1, 4, 6, 4, 4,-1, 4, 4, /* '苐','苑','苒','苓','苔','苕',0,'苗', 0,'苙','苚','苛','苜',0,'苞','苟', */
	/* 82e0 */  6, 4, 6, 4, 6, 4, 4, 4,  6,-1, 6, 4,-1, 6,-1, 6, /* '苠','苡','苢','苣','苤','若','苦','苧', '苨',0,'苪','苫',0,'苭',0,'苯', */
	/* 82f0 */ -1, 4,-1, 4, 4,-1, 6, 6, -1, 4, 4, 4,-1, 6, 6,-1, /* 0,'英',0,'苳','苴',0,'苶','苷', 0,'苹','苺','苻',0,'苽','苾',0, */
	/* 8300 */  6, 6, 4, 4, 4, 4, 4, 6,  6, 4, 6, 6,-1,-1, 4,-1, /* '茀','茁','茂','范','茄','茅','茆','茇', '茈','茉','茊','茋',0,0,'茎',0, */
	/* 8310 */ -1,-1,-1,-1,-1,-1, 4, 4,  4,-1,-1, 6, 4, 6, 6, 6, /* 0,0,0,0,0,0,'茖','茗', '茘',0,0,'茛','茜','茝','茞','茟', */
	/* 8320 */ -1, 6, 6, 4,-1,-1,-1,-1,  4,-1,-1, 4, 6, 6, 6, 4, /* 0,'茡','茢','茣',0,0,0,0, '茨',0,0,'茫','茬','茭','茮','茯', */
	/* 8330 */  6, 4, 4, 6, 4, 4, 4, 6,  4, 4, 6,-1, 6, 6,-1,-1, /* '茰','茱','茲','茳','茴','茵','茶','茷', '茸','茹','茺',0,'茼','茽',0,0, */
	/* 8340 */  4,-1, 6, 6, 6, 4,-1, 6, -1, 4, 4,-1,-1, 6, 6, 4, /* '荀',0,'荂','荃','荄','荅',0,'荇', 0,'草','荊',0,0,'荍','荎','荏', */
	/* 8350 */  4, 6, 4, 6, 6, 6, 6, 6,  4,-1,-1,-1,-1,-1,-1,-1, /* '荐','荑','荒','荓','荔','荕','荖','荗', '荘',0,0,0,0,0,0,0, */
	/* 8360 */ -1,-1, 6,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,0,'荢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8370 */  6,-1,-1, 4,-1, 4,-1, 4,  6,-1,-1, 4, 4, 6,-1, 6, /* '荰',0,0,'荳',0,'荵',0,'荷', '荸',0,0,'荻','荼','荽',0,'荿', */
	/* 8380 */  6,-1, 6,-1, 6, 4, 6, 4, -1, 4, 4,-1,-1, 6, 4,-1, /* '莀',0,'莂',0,'莄','莅','莆','莇', 0,'莉','莊',0,0,'莍','莎',0, */
	/* 8390 */ -1,-1, 6, 4, 6, 6, 4,-1,  6, 6, 4, 6, 6, 6, 4, 4, /* 0,0,'莒','莓','莔','莕','莖',0, '莘','莙','莚','莛','莜','莝','莞','莟', */
	/* 83a0 */  4,-1, 4,-1,-1,-1, 6, 6,  4, 6, 4, 4, 6, 6,-1,-1, /* '莠',0,'莢',0,0,0,'莦','莧', '莨','莩','莪','莫','莬','莭',0,0, */
	/* 83b0 */ -1, 4,-1,-1,-1, 4,-1,-1, -1,-1,-1,-1,-1, 4, 6, 6, /* 0,'莱',0,0,0,'莵',0,0, 0,0,0,0,0,'莽','莾','莿', */
	/* 83c0 */  6, 4,-1,-1,-1, 4,-1, 6, -1, 6, 4,-1, 4,-1, 4, 6, /* '菀','菁',0,0,0,'菅',0,'菇', 0,'菉','菊',0,'菌',0,'菎','菏', */
	/* 83d0 */  6, 6,-1, 4, 6,-1, 4,-1,  4,-1,-1,-1, 4, 6,-1, 4, /* '菐','菑',0,'菓','菔',0,'菖',0, '菘',0,0,0,'菜','菝',0,'菟', */
	/* 83e0 */  4,-1,-1,-1,-1,-1,-1,-1,  6, 4, 6, 4,-1,-1,-1, 4, /* '菠',0,0,0,0,0,0,0, '菨','菩','菪','菫',0,0,0,'華', */
	/* 83f0 */  4, 4, 4,-1, 4,-1, 6, 4,  6, 6,-1, 4, 6, 4,-1,-1, /* '菰','菱','菲',0,'菴',0,'菶','菷', '菸','菹',0,'菻','菼','菽',0,0, */
	/* 8400 */ -1, 6,-1, 4, 4,-1, 6, 4, -1,-1, 6, 4, 4, 4, 4, 6, /* 0,'萁',0,'萃','萄',0,'萆','萇', 0,0,'萊','萋','萌','萍','萎','萏', */
	/* 8410 */ -1, 6,-1, 4,-1, 6,-1,-1, -1, 6,-1,-1,-1,-1,-1,-1, /* 0,'萑',0,'萓',0,'萕',0,0, 0,'萙',0,0,0,0,0,0, */
	/* 8420 */  4,-1, 4,-1,-1,-1,-1,-1, -1, 4, 4,-1, 4,-1,-1, 6, /* '萠',0,'萢',0,0,0,0,0, 0,'萩','萪',0,'萬',0,0,'萯', */
	/* 8430 */ -1, 4,-1,-1,-1, 4,-1,-1,  4, 6,-1,-1, 4, 4,-1,-1, /* 0,'萱',0,0,0,'萵',0,0, '萸','萹',0,0,'萼','落',0,0, */
	/* 8440 */ -1,-1,-1,-1,-1, 6, 4, 6,  6, 4, 6,-1,-1, 6, 4, 6, /* 0,0,0,0,0,'葅','葆','葇', '葈','葉','葊',0,0,'葍','葎','葏', */
	/* 8450 */ -1, 6, 6,-1,-1,-1, 6, 4,  6, 6, 6, 4, 6,-1,-1,-1, /* 0,'葑','葒',0,0,0,'葖','著', '葘','葙','葚','葛','葜',0,0,0, */
	/* 8460 */  6, 4, 4, 4, 6, 6, 4, 6, -1, 4, 6, 4, 4, 4, 4, 4, /* '葠','葡','葢','董','葤','葥','葦','葧', 0,'葩','葪','葫','葬','葭','葮','葯', */
	/* 8470 */  6, 4,-1, 6, 6, 4, 6, 4,  6, 4, 4,-1, 6, 6,-1,-1, /* '葰','葱',0,'葳','葴','葵','葶','葷', '葸','葹','葺',0,'葼','葽',0,0, */
	/* 8480 */ -1, 6, 4,-1, 4, 6,-1,-1, -1,-1,-1, 4,-1,-1,-1,-1, /* 0,'蒁','蒂',0,'蒄','蒅',0,0, 0,0,0,'蒋',0,0,0,0, */
	/* 8490 */  4,-1, 6, 6, 4, 6,-1,-1, -1, 4,-1,-1, 4,-1, 6, 4, /* '蒐',0,'蒒','蒓','蒔','蒕',0,0, 0,'蒙',0,0,'蒜',0,'蒞','蒟', */
	/* 84a0 */ -1, 4,-1,-1,-1,-1, 6,-1,  6, 6, 6,-1,-1, 4,-1, 6, /* 0,'蒡',0,0,0,0,'蒦',0, '蒨','蒩','蒪',0,0,'蒭',0,'蒯', */
	/* 84b0 */ -1, 6, 4,-1, 6,-1,-1,-1,  4, 4, 6, 4, 4, 6, 6, 4, /* 0,'蒱','蒲',0,'蒴',0,0,0, '蒸','蒹','蒺','蒻','蒼','蒽','蒾','蒿', */
	/* 84c0 */  6, 4, 6,-1, 4,-1, 4, 6,  6, 4, 4, 4, 6, 4,-1, 6, /* '蓀','蓁','蓂',0,'蓄',0,'蓆','蓇', '蓈','蓉','蓊','蓋','蓌','蓍',0,'蓏', */
	/* 84d0 */  4, 4,-1, 6,-1,-1, 4,-1, -1, 4, 4,-1, 6,-1,-1,-1, /* '蓐','蓑',0,'蓓',0,0,'蓖',0, 0,'蓙','蓚',0,'蓜',0,0,0, */
	/* 84e0 */ -1,-1,-1,-1,-1,-1,-1, 6, -1,-1, 6,-1, 4,-1, 4, 6, /* 0,0,0,0,0,0,0,'蓧', 0,0,'蓪',0,'蓬',0,'蓮','蓯', */
	/* 84f0 */  6, 6, 6,-1, 4,-1,-1, 6, -1,-1, 6, 6, 4, 6,-1, 4, /* '蓰','蓱','蓲',0,'蓴',0,0,'蓷', 0,0,'蓺','蓻','蓼','蓽',0,'蓿', */
	/* 8500 */  4,-1, 6, 6,-1,-1, 4, 6, -1,-1,-1,-1, 6,-1, 6,-1, /* '蔀',0,'蔂','蔃',0,0,'蔆','蔇', 0,0,0,0,'蔌',0,'蔎',0, */
	/* 8510 */  6, 4,-1, 4, 4, 4,-1, 4,  4,-1, 4,-1, 6,-1, 6, 4, /* '蔐','蔑',0,'蔓','蔔','蔕',0,'蔗', '蔘',0,'蔚',0,'蔜',0,'蔞','蔟', */
	/* 8520 */ -1, 4, 6, 6, 6, 6, 4, 6, -1,-1, 6, 6, 4, 4,-1, 6, /* 0,'蔡','蔢','蔣','蔤','蔥','蔦','蔧', 0,0,'蔪','蔫','蔬','蔭',0,'蔯', */
	/* 8530 */ -1,-1, 6, 6, 6, 4, 6,-1, -1,-1,-1,-1,-1, 4,-1, 6, /* 0,0,'蔲','蔳','蔴','蔵','蔶',0, 0,0,0,0,0,'蔽',0,'蔿', */
	/* 8540 */  4, 4,-1, 4,-1,-1, 6,-1,  4, 4, 4, 4,-1,-1, 4, 6, /* '蕀','蕁',0,'蕃',0,0,'蕆',0, '蕈','蕉','蕊','蕋',0,0,'蕎','蕏', */
	/* 8550 */  6, 6, 6, 6,-1, 4, 6, 4,  4, 6, 4,-1, 6, 6, 6, 6, /* '蕐','蕑','蕒','蕓',0,'蕕','蕖','蕗', '蕘','蕙','蕚',0,'蕜','蕝','蕞','蕟', */
	/* 8560 */  6, 6, 6, 4, 6,-1,-1,-1,  4, 4, 4, 6,-1, 4,-1, 6, /* '蕠','蕡','蕢','蕣','蕤',0,0,0, '蕨','蕩','蕪','蕫',0,'蕭',0,'蕯', */
	/* 8570 */ -1,-1,-1,-1,-1,-1,-1, 4, -1, 6, 6, 6,-1, 6, 4, 6, /* 0,0,0,0,0,0,0,'蕷', 0,'蕹','蕺','蕻',0,'蕽','蕾','蕿', */
	/* 8580 */  4, 6,-1,-1, 4, 6, 6, 4,  4, 6, 4, 6, 6,-1,-1, 6, /* '薀','薁',0,0,'薄','薅','薆','薇', '薈','薉','薊','薋','薌',0,0,'薏', */
	/* 8590 */  4, 4,-1, 6, 4,-1,-1, 4,  6, 4,-1, 4, 4, 6,-1, 6, /* '薐','薑',0,'薓','薔',0,0,'薗', '薘','薙',0,'薛','薜','薝',0,'薟', */
	/* 85a0 */  6,-1, 6,-1, 4, 6, 4, 6,  4, 4, 4, 4, 4, 6, 4, 4, /* '薠',0,'薢',0,'薤','薥','薦','薧', '薨','薩','薪','薫','薬','薭','薮','薯', */
	/* 85b0 */  6,-1,-1,-1, 6,-1, 6, 6,  6, 4, 4,-1, 6, 6, 6, 6, /* '薰',0,0,0,'薴',0,'薶','薷', '薸','薹','薺',0,'薼','薽','薾','薿', */
	/* 85c0 */ -1, 4, 6,-1,-1,-1,-1, 6, -1, 4, 6, 6,-1, 4, 6, 4, /* 0,'藁','藂',0,0,0,0,'藇', 0,'藉','藊','藋',0,'藍','藎','藏', */
	/* 85d0 */  4,-1,-1,-1,-1, 4,-1,-1,  6,-1, 6,-1, 4, 4,-1, 6, /* '藐',0,0,0,0,'藕',0,0, '藘',0,'藚',0,'藜','藝',0,'藟', */
	/* 85e0 */  6,-1,-1,-1, 4, 4, 6,-1,  6, 4, 4,-1,-1, 6,-1,-1, /* '藠',0,0,0,'藤','藥','藦',0, '藨','藩','藪',0,0,'藭',0,0, */
	/* 85f0 */ -1,-1,-1, 6,-1,-1, 6, 4, -1, 4, 4, 4, 6,-1, 4, 6, /* 0,0,0,'藳',0,0,'藶','藷', 0,'藹','藺','藻','藼',0,'藾','藿', */
	/* 8600 */  6,-1, 4,-1, 6, 6, 4, 4, -1,-1, 4, 4,-1, 6, 6,-1, /* '蘀',0,'蘂',0,'蘄','蘅','蘆','蘇', 0,0,'蘊','蘋',0,'蘍','蘎',0, */
	/* 8610 */  6, 6, 6, 4,-1,-1, 4, 4,  6, 6, 4, 6,-1,-1, 6,-1, /* '蘐','蘑','蘒','蘓',0,0,'蘖','蘗', '蘘','蘙','蘚','蘛',0,0,'蘞',0, */
	/* 8620 */ -1, 6, 4,-1,-1,-1,-1, 6, -1, 6,-1,-1,-1, 4,-1, 4, /* 0,'蘡','蘢',0,0,0,0,'蘧', 0,'蘩',0,0,0,'蘭',0,'蘯', */
	/* 8630 */  4,-1,-1,-1,-1,-1, 6,-1,  6,-1, 6,-1, 6, 6,-1, 4, /* '蘰',0,0,0,0,0,'蘶',0, '蘸',0,'蘺',0,'蘼','蘽',0,'蘿', */
	/* 8640 */  6, 6, 6,-1,-1,-1, 6,-1, -1,-1,-1,-1,-1, 4, 4,-1, /* '虀','虁','虂',0,0,0,'虆',0, 0,0,0,0,0,'虍','虎',0, */
	/* 8650 */  4,-1, 6, 6, 4, 4, 6, 6,  6, 6, 4,-1, 4, 6, 4, 4, /* '虐',0,'虒','虓','虔','處','虖','虗', '虘','虙','虚',0,'虜','虝','虞','號', */
	/* 8660 */  6, 6, 6, 6, 6,-1,-1, 4, -1, 6,-1, 4, 6,-1,-1, 6, /* '虠','虡','虢','虣','虤',0,0,'虧', 0,'虩',0,'虫','虬',0,0,'虯', */
	/* 8670 */ -1, 4,-1,-1,-1, 6, 6, 6, -1, 4, 6, 4,-1,-1,-1,-1, /* 0,'虱',0,0,0,'虵','虶','虷', 0,'虹','虺','虻',0,0,0,0, */
	/* 8680 */ -1,-1,-1,-1,-1,-1,-1,-1,  6,-1, 4, 4, 4, 6,-1,-1, /* 0,0,0,0,0,0,0,0, '蚈',0,'蚊','蚋','蚌','蚍',0,0, */
	/* 8690 */ -1, 6,-1, 4,-1, 4, 6,-1,  6,-1, 6,-1, 6,-1,-1,-1, /* 0,'蚑',0,'蚓',0,'蚕','蚖',0, '蚘',0,'蚚',0,'蚜',0,0,0, */
	/* 86a0 */ -1, 6,-1, 4, 4,-1, 6, 6,  6, 4, 4, 4,-1, 6,-1, 4, /* 0,'蚡',0,'蚣','蚤',0,'蚦','蚧', '蚨','蚩','蚪','蚫',0,'蚭',0,'蚯', */
	/* 86b0 */  4, 6,-1, 6, 6, 6, 4, 6,  6, 6,-1,-1,-1,-1,-1, 6, /* '蚰','蚱',0,'蚳','蚴','蚵','蚶','蚷', '蚸','蚹',0,0,0,0,0,'蚿', */
	/* 86c0 */  6, 6,-1, 6, 4, 6, 4, 4, -1, 4,-1, 4,-1, 4, 4,-1, /* '蛀','蛁',0,'蛃','蛄','蛅','蛆','蛇', 0,'蛉',0,'蛋',0,'蛍','蛎',0, */
	/* 86d0 */ -1, 6, 6,-1, 4, 6,-1, 6, -1, 4, 6, 4, 6,-1, 4, 4, /* 0,'蛑','蛒',0,'蛔','蛕',0,'蛗', 0,'蛙','蛚','蛛','蛜',0,'蛞','蛟', */
	/* 86e0 */  6,-1,-1, 6, 4, 6,-1, 6, -1, 4,-1,-1, 4, 4, 4, 4, /* '蛠',0,0,'蛣','蛤','蛥',0,'蛧', 0,'蛩',0,0,'蛬','蛭','蛮','蛯', */
	/* 86f0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4, 4, 6, 4, 6, 6, 4,-1, /* 0,0,0,0,0,0,0,0, '蛸','蛹','蛺','蛻','蛼','蛽','蛾',0, */
	/* 8700 */  4,-1, 4, 4, 6, 6, 4, 6,  4, 4, 4, 6,-1, 4, 6, 6, /* '蜀',0,'蜂','蜃','蜄','蜅','蜆','蜇', '蜈','蜉','蜊','蜋',0,'蜍','蜎','蜏', */
	/* 8710 */  6, 4, 4, 6, 6,-1,-1,-1,  4, 6, 4,-1, 4,-1, 6, 6, /* '蜐','蜑','蜒','蜓','蜔',0,0,0, '蜘','蜙','蜚',0,'蜜',0,'蜞','蜟', */
	/* 8720 */ -1, 6,-1, 6,-1, 4,-1,-1,  6, 4,-1,-1,-1,-1, 6, 6, /* 0,'蜡',0,'蜣',0,'蜥',0,0, '蜨','蜩',0,0,0,0,'蜮','蜯', */
	/* 8730 */ -1, 6, 6,-1, 4,-1,-1, 4, -1, 6, 6, 4, 6, 6, 6, 4, /* 0,'蜱','蜲',0,'蜴',0,0,'蜷', 0,'蜹','蜺','蜻','蜼','蜽','蜾','蜿', */
	/* 8740 */  6,-1,-1, 6,-1, 6,-1,-1, -1, 4,-1, 4, 4, 6, 4,-1, /* '蝀',0,0,'蝃',0,'蝅',0,0, 0,'蝉',0,'蝋','蝌','蝍','蝎',0, */
	/* 8750 */ -1,-1,-1, 4,-1, 4,-1, 4,  6, 4,-1,-1,-1, 6,-1, 4, /* 0,0,0,'蝓',0,'蝕',0,'蝗', '蝘','蝙',0,0,0,'蝝',0,'蝟', */
	/* 8760 */  4, 6,-1, 4, 6, 6, 4,-1,  4,-1, 4,-1,-1,-1, 4, 6, /* '蝠','蝡',0,'蝣','蝤','蝥','蝦',0, '蝨',0,'蝪',0,0,0,'蝮','蝯', */
	/* 8770 */ -1, 6, 6,-1, 4,-1, 4,-1,  4,-1,-1, 6,-1,-1,-1, 4, /* 0,'蝱','蝲',0,'蝴',0,'蝶',0, '蝸',0,0,'蝻',0,0,0,'蝿', */
	/* 8780 */ -1,-1, 4, 6, 6, 6, 6, 6,  6, 6,-1, 6, 6, 4,-1,-1, /* 0,0,'螂','螃','螄','螅','螆','螇', '螈','螉',0,'螋','螌','融',0,0, */
	/* 8790 */  6,-1,-1, 6,-1, 6,-1, 6,  6, 6,-1,-1,-1,-1, 6, 4, /* '螐',0,0,'螓',0,'螕',0,'螗', '螘','螙',0,0,0,0,'螞','螟', */
	/* 87a0 */  6,-1, 4, 6,-1,-1,-1, 6, -1,-1,-1, 4, 6, 6, 6, 4, /* '螠',0,'螢','螣',0,0,0,'螧', 0,0,0,'螫','螬','螭','螮','螯', */
	/* 87b0 */ -1, 6,-1, 4,-1, 6,-1,-1, -1,-1, 4, 4,-1, 4, 6, 6, /* 0,'螱',0,'螳',0,'螵',0,0, 0,0,'螺','螻',0,'螽','螾','螿', */
	/* 87c0 */  4, 6,-1,-1, 4,-1, 4, 4,  6, 6, 6, 4,-1,-1, 6,-1, /* '蟀','蟁',0,0,'蟄',0,'蟆','蟇', '蟈','蟉','蟊','蟋',0,0,'蟎',0, */
	/* 87d0 */  4,-1, 4,-1,-1, 6, 6,-1, -1, 6, 6,-1, 6,-1,-1, 6, /* '蟐',0,'蟒',0,0,'蟕','蟖',0, 0,'蟙','蟚',0,'蟜',0,0,'蟟', */
	/* 87e0 */  4,-1, 6, 6, 6,-1,-1,-1, -1,-1, 6, 6,-1, 6,-1, 4, /* '蟠',0,'蟢','蟣','蟤',0,0,0, 0,0,'蟪','蟫',0,'蟭',0,'蟯', */
	/* 87f0 */ -1, 6, 4, 6,-1,-1, 4, 4,  6, 4, 6, 4,-1,-1, 4, 6, /* 0,'蟱','蟲','蟳',0,0,'蟶','蟷', '蟸','蟹','蟺','蟻',0,0,'蟾','蟿', */
	/* 8800 */ -1, 6,-1, 6,-1, 4, 6, 6, -1, 6, 6, 6,-1, 4, 4, 4, /* 0,'蠁',0,'蠃',0,'蠅','蠆','蠇', 0,'蠉','蠊','蠋',0,'蠍','蠎','蠏', */
	/* 8810 */  6, 4, 6, 6, 6, 4, 4,-1,  6, 6, 6, 6, 6,-1, 6, 6, /* '蠐','蠑','蠒','蠓','蠔','蠕','蠖',0, '蠘','蠙','蠚','蠛','蠜',0,'蠞','蠟', */
	/* 8820 */ -1, 4, 4, 4,-1,-1,-1, 4,  6,-1,-1,-1,-1, 6, 6,-1, /* 0,'蠡','蠢','蠣',0,0,0,'蠧', '蠨',0,0,0,0,'蠭','蠮',0, */
	/* 8830 */  6, 4, 6,-1,-1, 6, 4,-1, -1, 4, 6, 4, 6,-1,-1,-1, /* '蠰','蠱','蠲',0,0,'蠵','蠶',0, 0,'蠹','蠺','蠻','蠼',0,0,0, */
	/* 8840 */  4, 6, 4, 6, 4, 6, 4,-1,  6, 6, 6, 6, 4, 4, 6,-1, /* '血','衁','衂','衃','衄','衅','衆',0, '衈','衉','衊','衋','行','衍','衎',0, */
	/* 8850 */ -1, 6, 4, 4,-1, 6, 6, 4,  6, 4, 6, 4, 6, 4, 4, 6, /* 0,'衑','衒','術',0,'衕','衖','街', '衘','衙','衚','衛','衜','衝','衞','衟', */
	/* 8860 */  6, 4, 4, 4, 6,-1,-1,-1,  4, 6,-1, 4,-1,-1,-1,-1, /* '衠','衡','衢','衣','衤',0,0,0, '表','衩',0,'衫',0,0,0,0, */
	/* 8870 */  4, 6, 4,-1,-1, 4,-1, 4, -1, 6,-1, 6,-1, 4, 4, 4, /* '衰','衱','衲',0,0,'衵',0,'衷', 0,'衹',0,'衻',0,'衽','衾','衿', */
	/* 8880 */  6, 4, 4,-1,-1,-1,-1,-1,  4,-1,-1, 4,-1, 4,-1,-1, /* '袀','袁','袂',0,0,0,0,0, '袈',0,0,'袋',0,'袍',0,0, */
	/* 8890 */ -1,-1, 4,-1,-1,-1, 4, 4,  6, 4, 6, 6, 6,-1, 4, 6, /* 0,0,'袒',0,0,0,'袖','袗', '袘','袙','袚','袛','袜',0,'袞','袟', */
	/* 88a0 */  6,-1, 4,-1, 4,-1,-1,-1,  6,-1, 6, 4,-1,-1, 4,-1, /* '袠',0,'袢',0,'袤',0,0,0, '袨',0,'袪','被',0,0,'袮',0, */
	/* 88b0 */  4, 4,-1,-1, 4, 4,-1, 4, -1,-1, 6,-1,-1, 6, 6, 4, /* '袰','袱',0,0,'袴','袵',0,'袷', 0,0,'袺',0,0,'袽','袾','袿', */
	/* 88c0 */  6, 4, 4, 4, 4, 4,-1,-1, -1,-1, 6, 6, 6, 6, 6, 4, /* '裀','裁','裂','裃','裄','装',0,0, 0,0,'裊','裋','裌','裍','裎','裏', */
	/* 88d0 */ -1, 6, 6, 6, 4, 4,-1,-1,  4, 4,-1, 6, 4, 4, 6, 4, /* 0,'裑','裒','裓','裔','裕',0,0, '裘','裙',0,'裛','補','裝','裞','裟', */
	/* 88e0 */ -1, 4,-1,-1,-1,-1,-1, 6,  4,-1,-1,-1,-1,-1,-1, 6, /* 0,'裡',0,0,0,0,0,'裧', '裨',0,0,0,0,0,0,'裯', */
	/* 88f0 */  6, 6, 4, 4, 4, 6,-1, 6,  4, 4,-1,-1, 4, 4, 4,-1, /* '裰','裱','裲','裳','裴','裵',0,'裷', '裸','裹',0,0,'裼','製','裾',0, */
	/* 8900 */ -1, 6, 4,-1, 4,-1, 6, 4, -1,-1, 4,-1, 4, 6, 6, 6, /* 0,'褁','褂',0,'褄',0,'褆','複', 0,0,'褊',0,'褌','褍','褎','褏', */
	/* 8910 */  4,-1, 4, 4,-1, 6, 6,-1,  6, 6, 6,-1, 6, 4, 4,-1, /* '褐',0,'褒','褓',0,'褕','褖',0, '褘','褙','褚',0,'褜','褝','褞',0, */
	/* 8920 */  6,-1,-1,-1,-1, 4, 6, 6,  6,-1, 4, 4,-1,-1,-1,-1, /* '褠',0,0,0,0,'褥','褦','褧', '褨',0,'褪','褫',0,0,0,0, */
	/* 8930 */  6, 6, 6,-1,-1, 6, 4,-1,  4, 6, 6, 4,-1,-1, 6,-1, /* '褰','褱','褲',0,0,'褵','褶',0, '褸','褹','褺','褻',0,0,'褾',0, */
	/* 8940 */  6, 4, 6, 4, 4, 6, 6,-1, -1, 6,-1,-1, 4, 4,-1, 6, /* '襀','襁','襂','襃','襄','襅','襆',0, 0,'襉',0,0,'襌','襍',0,'襏', */
	/* 8950 */ -1,-1, 6,-1,-1,-1, 4, 6, -1,-1, 6, 6, 6,-1, 4, 4, /* 0,0,'襒',0,0,0,'襖','襗', 0,0,'襚','襛','襜',0,'襞','襟', */
	/* 8960 */  4, 6, 6, 6, 4,-1, 4,-1, -1,-1, 4, 6,-1, 4, 6, 4, /* '襠','襡','襢','襣','襤',0,'襦',0, 0,0,'襪','襫',0,'襭','襮','襯', */
	/* 8970 */  6,-1, 4, 6, 4, 6,-1, 4, -1,-1, 6, 6, 6, 6, 4, 4, /* '襰',0,'襲','襳','襴','襵',0,'襷', 0,0,'襺','襻','襼','襽','襾','西', */
	/* 8980 */ -1, 4,-1, 4,-1,-1, 4, 4,  4, 6, 4, 4,-1, 6,-1, 4, /* 0,'要',0,'覃',0,0,'覆','覇', '覈','覉','覊','見',0,'覍',0,'規', */
	/* 8990 */  6,-1,-1, 4, 6, 6, 4, 4,  4,-1, 4, 6, 6,-1,-1, 6, /* '覐',0,0,'覓','覔','覕','視','覗', '覘',0,'覚','覛','覜',0,0,'覟', */
	/* 89a0 */  6, 4,-1,-1,-1, 6, 4, 4, -1, 4, 4,-1, 4,-1,-1, 4, /* '覠','覡',0,0,0,'覥','覦','覧', 0,'覩','親',0,'覬',0,0,'覯', */
	/* 89b0 */  6,-1, 4, 4, 6, 6, 6, 6, -1,-1, 4,-1, 6, 4,-1, 4, /* '覰',0,'覲','観','覴','覵','覶','覷', 0,0,'覺',0,'覼','覽',0,'覿', */
	/* 89c0 */  4,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '觀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 89d0 */ -1,-1, 4,-1, 6, 6, 6, 6,  6,-1, 4,-1, 4, 4,-1,-1, /* 0,0,'角',0,'觔','觕','觖','觗', '觘',0,'觚',0,'觜','觝',0,0, */
	/* 89e0 */ -1,-1,-1, 4,-1, 6, 4, 4, -1, 6,-1, 6,-1, 6,-1,-1, /* 0,0,0,'解',0,'觥','触','觧', 0,'觩',0,'觫',0,'觭',0,0, */
	/* 89f0 */ -1, 6,-1, 6, 4,-1, 6,-1,  4, 6,-1,-1,-1, 6,-1, 6, /* 0,'觱',0,'觳','觴',0,'觶',0, '觸','觹',0,0,0,'觽',0,'觿', */
	/* 8a00 */  4,-1, 4, 4, 6, 6,-1, 6,  4,-1, 4,-1, 4,-1, 4, 6, /* '言',0,'訂','訃','訄','訅',0,'訇', '計',0,'訊',0,'訌',0,'討','訏', */
	/* 8a10 */  4, 6, 6, 4, 6, 6, 4, 4,  4,-1,-1, 4,-1, 4, 6, 4, /* '訐','訑','訒','訓','訔','訕','訖','託', '記',0,0,'訛',0,'訝','訞','訟', */
	/* 8a20 */  6,-1, 6, 4, 6, 4, 6,-1, -1,-1, 4, 6, 6, 4,-1, 6, /* '訠',0,'訢','訣','訤','訥','訦',0, 0,0,'訪','訫','訬','設',0,'訯', */
	/* 8a30 */ -1, 4,-1, 4, 4, 6, 4, 6, -1,-1, 4, 4, 4, 6, 6,-1, /* 0,'許',0,'訳','訴','訵','訶','訷', 0,0,'診','註','証','訽','訾',0, */
	/* 8a40 */  6, 4,-1, 6,-1, 6, 4, 6,  4, 6,-1,-1,-1, 6, 6,-1, /* '詀','詁',0,'詃',0,'詅','詆','詇', '詈','詉',0,0,0,'詍','詎',0, */
	/* 8a50 */  4, 4, 4, 6, 4, 4, 6, 6,  6,-1,-1, 4, 6, 6, 4,-1, /* '詐','詑','詒','詓','詔','評','詖','詗', '詘',0,0,'詛','詜','詝','詞',0, */
	/* 8a60 */  4, 6, 4, 4,-1, 6, 4, 6, -1, 4,-1, 4, 4, 4, 4,-1, /* '詠','詡','詢','詣',0,'詥','試','詧', 0,'詩',0,'詫','詬','詭','詮',0, */
	/* 8a70 */  4, 4, 4, 4,-1, 6, 6, 6, -1, 6, 6, 6, 4,-1, 6, 6, /* '詰','話','該','詳',0,'詵','詶','詷', 0,'詹','詺','詻','詼',0,'詾','詿', */
	/* 8a80 */  6,-1, 4, 6, 4, 4, 6, 4, -1, 4,-1, 6, 4, 4,-1, 6, /* '誀',0,'誂','誃','誄','誅','誆','誇', 0,'誉',0,'誋','誌','認',0,'誏', */
	/* 8a90 */  6, 4, 6, 4,-1, 4, 6, 6,  4, 6, 4,-1,-1,-1, 4, 6, /* '誐','誑','誒','誓',0,'誕','誖','誗', '誘','誙','誚',0,0,0,'語','誟', */
	/* 8aa0 */  4, 4,-1, 4, 4, 4, 4, 6,  4, 6,-1,-1, 4, 4, 6, 6, /* '誠','誡',0,'誣','誤','誥','誦','誧', '誨','誩',0,0,'説','読','誮','誯', */
	/* 8ab0 */  4,-1, 4, 6,-1,-1, 6, 6, -1, 4,-1, 6, 4,-1, 6, 4, /* '誰',0,'課','誳',0,0,'誶','誷', 0,'誹',0,'誻','誼',0,'誾','調', */
	/* 8ac0 */ -1,-1, 4, 6, 4,-1, 6, 4,  6, 6, 6, 4, 4, 4,-1, 4, /* 0,0,'諂','諃','諄',0,'諆','談', '諈','諉','諊','請','諌','諍',0,'諏', */
	/* 8ad0 */ -1, 6, 4, 6, 6, 6, 4, 6, -1,-1, 4, 4, 4, 6, 4, 6, /* 0,'諑','諒','諓','諔','諕','論','諗', 0,0,'諚','諛','諜','諝','諞','諟', */
	/* 8ae0 */  4, 4, 4,-1, 4,-1, 4, 4, -1,-1,-1, 4, 6, 4, 4,-1, /* '諠','諡','諢',0,'諤',0,'諦','諧', 0,0,0,'諫','諬','諭','諮',0, */
	/* 8af0 */  6, 4,-1, 4, 6, 6, 6, 4,  4,-1, 4,-1, 6,-1, 4, 6, /* '諰','諱',0,'諳','諴','諵','諶','諷', '諸',0,'諺',0,'諼',0,'諾','諿', */
	/* 8b00 */  4, 4, 4,-1, 4, 6, 6, 4, -1,-1, 6, 6, 4,-1, 4,-1, /* '謀','謁','謂',0,'謄','謅','謆','謇', 0,0,'謊','謋','謌',0,'謎',0, */
	/* 8b10 */  4, 6,-1,-1, 4,-1, 4, 4, -1, 4, 4, 4, 6, 4, 6, 6, /* '謐','謑',0,0,'謔',0,'謖','謗', 0,'謙','謚','講','謜','謝','謞','謟', */
	/* 8b20 */  4, 4,-1,-1,-1,-1, 4,-1,  4,-1,-1, 4, 4, 6,-1,-1, /* '謠','謡',0,0,0,0,'謦',0, '謨',0,0,'謫','謬','謭',0,0, */
	/* 8b30 */  6,-1,-1, 4,-1,-1,-1, 6, -1, 4,-1,-1, 6,-1, 4,-1, /* '謰',0,0,'謳',0,0,0,'謷', 0,'謹',0,0,'謼',0,'謾',0, */
	/* 8b40 */ -1, 4, 6, 6, 6, 6, 6,-1,  6, 4,-1,-1, 4, 6, 4, 4, /* 0,'譁','譂','譃','譄','譅','譆',0, '譈','證',0,0,'譌','譍','譎','譏', */
	/* 8b50 */ -1,-1, 6, 6, 6,-1, 4,-1,  4, 6, 4, 4, 4,-1, 6, 4, /* 0,0,'譒','譓','譔',0,'譖',0, '識','譙','譚','譛','譜',0,'譞','譟', */
	/* 8b60 */ -1,-1,-1, 6,-1,-1, 4,-1, -1,-1,-1, 4, 4, 6,-1, 4, /* 0,0,0,'譣',0,0,'警',0, 0,0,0,'譫','譬','譭',0,'譯', */
	/* 8b70 */  4, 4, 4,-1, 4,-1, 6, 4,  6, 6,-1,-1, 6, 4, 6, 6, /* '議','譱','譲',0,'譴',0,'譶','護', '譸','譹',0,0,'譼','譽','譾','譿', */
	/* 8b80 */  4, 6,-1, 4, 6, 6,-1,-1, -1,-1, 4, 6, 4, 6, 4, 6, /* '讀','讁',0,'讃','讄','讅',0,0, 0,0,'變','讋','讌','讍','讎','讏', */
	/* 8b90 */  4,-1, 4, 4, 6, 6, 4,-1, -1, 4, 4,-1, 6,-1, 6, 6, /* '讐',0,'讒','讓','讔','讕','讖',0, 0,'讙','讚',0,'讜',0,'讞','讟', */
	/* 8ba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8be0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8bf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8c30 */ -1,-1,-1,-1,-1,-1,-1, 4,  6, 6, 4,-1,-1, 6, 6, 4, /* 0,0,0,0,0,0,0,'谷', '谸','谹','谺',0,0,'谽','谾','谿', */
	/* 8c40 */ -1, 4,-1,-1,-1, 6, 4, 6,  4, 6, 4, 6, 4,-1, 4, 6, /* 0,'豁',0,0,0,'豅','豆','豇', '豈','豉','豊','豋','豌',0,'豎','豏', */
	/* 8c50 */  4, 6,-1, 6, 6, 4,-1, 6,  6, 6, 4, 6,-1, 6,-1,-1, /* '豐','豑',0,'豓','豔','豕',0,'豗', '豘','豙','豚','豛',0,'豝',0,0, */
	/* 8c60 */ -1, 4, 4, 6, 6,-1, 6,-1,  6, 6, 4, 4, 4, 6,-1,-1, /* 0,'象','豢','豣','豤',0,'豦',0, '豨','豩','豪','豫','豬','豭',0,0, */
	/* 8c70 */ -1,-1,-1, 6,-1, 6, 6,-1,  4, 4, 4, 6, 4,-1, 6,-1, /* 0,0,0,'豳',0,'豵','豶',0, '豸','豹','豺','豻','豼',0,'豾',0, */
	/* 8c80 */ -1,-1, 4,-1,-1, 4, 6, 6, -1, 4, 4, 6, 4, 4, 4,-1, /* 0,0,'貂',0,0,'貅','貆','貇', 0,'貉','貊','貋','貌','貍','貎',0, */
	/* 8c90 */  6,-1, 6, 6, 4,-1,-1,-1,  4, 6,-1, 6, 6, 4, 4,-1, /* '貐',0,'貒','貓','貔',0,0,0, '貘','貙',0,'貛','貜','貝','貞',0, */
	/* 8ca0 */  4, 4, 4,-1, 6,-1,-1, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '負','財','貢',0,'貤',0,0,'貧', '貨','販','貪','貫','責','貭','貮','貯', */
	/* 8cb0 */  4,-1, 4, 4, 4,-1, 4, 4,  4, 6, 6, 4, 4, 4,-1, 4, /* '貰',0,'貲','貳','貴',0,'貶','買', '貸','貹','貺','費','貼','貽',0,'貿', */
	/* 8cc0 */  4, 4, 4, 4, 4, 6, 6, 4,  4, 6, 4, 6,-1, 4, 4, 6, /* '賀','賁','賂','賃','賄','賅','賆','資', '賈','賉','賊','賋',0,'賍','賎','賏', */
	/* 8cd0 */ -1, 4,-1, 4,-1, 6, 6,-1, -1, 6, 4, 4, 4, 6, 4,-1, /* 0,'賑',0,'賓',0,'賕','賖',0, 0,'賙','賚','賛','賜','賝','賞',0, */
	/* 8ce0 */  4, 6, 4, 4, 4,-1, 4,-1,  6,-1, 4,-1, 6, 4,-1, 6, /* '賠','賡','賢','賣','賤',0,'賦',0, '賨',0,'質',0,'賬','賭',0,'賯', */
	/* 8cf0 */  6,-1, 6,-1, 6, 6,-1, 6,  6,-1, 4, 4, 4, 4, 6, 6, /* '賰',0,'賲',0,'賴','賵',0,'賷', '賸',0,'賺','賻','購','賽','賾','賿', */
	/* 8d00 */ -1, 6,-1, 6, 4, 4,-1, 4,  4, 6, 4, 4,-1, 4,-1, 4, /* 0,'贁',0,'贃','贄','贅',0,'贇', '贈','贉','贊','贋',0,'贍',0,'贏', */
	/* 8d10 */  4,-1, 6, 4, 4,-1, 4, 6, -1,-1,-1, 6,-1,-1,-1,-1, /* '贐',0,'贒','贓','贔',0,'贖','贗', 0,0,0,'贛',0,0,0,0, */
	/* 8d20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8d60 */ -1,-1,-1,-1, 4, 6, 4, 4, -1, 6,-1, 4, 6, 4, 6,-1, /* 0,0,0,0,'赤','赥','赦','赧', 0,'赩',0,'赫','赬','赭','赮',0, */
	/* 8d70 */  4, 4,-1, 4, 4,-1, 6, 4, -1,-1,-1,-1,-1,-1,-1, 6, /* '走','赱',0,'赳','赴',0,'赶','起', 0,0,0,0,0,0,0,'赿', */
	/* 8d80 */ -1, 4, 6,-1, 6, 4,-1,-1,  6,-1, 4,-1,-1, 6,-1,-1, /* 0,'趁','趂',0,'趄','超',0,0, '趈',0,'越',0,0,'趍',0,0, */
	/* 8d90 */  6, 6,-1,-1,-1, 6,-1,-1, -1, 4,-1,-1,-1,-1, 6, 6, /* '趐','趑',0,0,0,'趕',0,0, 0,'趙',0,0,0,0,'趞','趟', */
	/* 8da0 */  6,-1,-1, 4,-1,-1, 6,-1,  4,-1,-1, 6, 6,-1,-1, 6, /* '趠',0,0,'趣',0,0,'趦',0, '趨',0,0,'趫','趬',0,0,'趯', */
	/* 8db0 */ -1,-1, 6, 4,-1, 6,-1, 6, -1, 6, 4, 6, 6,-1, 4,-1, /* 0,0,'趲','足',0,'趵',0,'趷', 0,'趹','趺','趻','趼',0,'趾',0, */
	/* 8dc0 */  6,-1, 4,-1,-1, 6, 6, 6,  6,-1, 6, 4, 4,-1, 6, 4, /* '跀',0,'跂',0,0,'跅','跆','跇', '跈',0,'跊','跋','跌',0,'跎','跏', */
	/* 8dd0 */ -1, 6,-1,-1, 6, 6, 4, 6, -1, 6, 4, 4,-1, 4,-1, 4, /* 0,'跑',0,0,'跔','跕','跖','跗', 0,'跙','跚','跛',0,'距',0,'跟', */
	/* 8de0 */ -1, 4,-1, 4, 6, 6,-1, 6,  4,-1, 4, 4, 6,-1,-1, 4, /* 0,'跡',0,'跣','跤','跥',0,'跧', '跨',0,'跪','跫','跬',0,0,'路', */
	/* 8df0 */  6, 6, 6, 4, 6, 4,-1,-1, -1,-1,-1,-1, 4, 6,-1, 4, /* '跰','跱','跲','跳','跴','践',0,0, 0,0,0,0,'跼','跽',0,'跿', */
	/* 8e00 */ -1, 6,-1,-1, 6, 6, 6,-1,  4, 4, 4, 6,-1,-1,-1, 4, /* 0,'踁',0,0,'踄','踅','踆',0, '踈','踉','踊','踋',0,0,0,'踏', */
	/* 8e10 */  4, 6,-1,-1, 6,-1, 6,-1, -1,-1,-1,-1,-1, 4, 4, 4, /* '踐','踑',0,0,'踔',0,'踖',0, 0,0,0,0,0,'踝','踞','踟', */
	/* 8e20 */  6, 6, 6, 6,-1,-1, 6, 6, -1,-1, 4,-1,-1,-1,-1,-1, /* '踠','踡','踢','踣',0,0,'踦','踧', 0,0,'踪',0,0,0,0,0, */
	/* 8e30 */  4, 6,-1, 6, 4, 4, 6, 6,  6, 6,-1,-1,-1, 6,-1,-1, /* '踰','踱',0,'踳','踴','踵','踶','踷', '踸','踹',0,0,0,'踽',0,0, */
	/* 8e40 */  6, 6, 4,-1, 4,-1,-1, 4,  4, 4, 4, 6, 4, 6, 6, 6, /* '蹀','蹁','蹂',0,'蹄',0,0,'蹇', '蹈','蹉','蹊','蹋','蹌','蹍','蹎','蹏', */
	/* 8e50 */  4,-1,-1,-1, 6, 4,-1,-1, -1, 4,-1, 6, 6, 6, 6, 4, /* '蹐',0,0,0,'蹔','蹕',0,0, 0,'蹙',0,'蹛','蹜','蹝','蹞','蹟', */
	/* 8e60 */  4, 6, 6, 4, 4,-1,-1,-1, -1, 6,-1,-1, 6, 6,-1, 6, /* '蹠','蹡','蹢','蹣','蹤',0,0,0, 0,'蹩',0,0,'蹬','蹭',0,'蹯', */
	/* 8e70 */  6, 6, 4,-1, 4,-1, 4,-1, -1, 6, 6, 6, 4,-1,-1,-1, /* '蹰','蹱','蹲',0,'蹴',0,'蹶',0, 0,'蹹','蹺','蹻','蹼',0,0,0, */
	/* 8e80 */ -1, 4, 6, 6, 4, 4,-1, 4, -1, 6, 4, 4,-1, 4,-1,-1, /* 0,'躁','躂','躃','躄','躅',0,'躇', 0,'躉','躊','躋',0,'躍',0,0, */
	/* 8e90 */  6, 4, 6, 4, 4, 6,-1,-1, -1, 4, 6, 6,-1, 6, 6,-1, /* '躐','躑','躒','躓','躔','躕',0,0, 0,'躙','躚','躛',0,'躝','躞',0, */
	/* 8ea0 */ -1, 4, 6,-1,-1,-1,-1, 6, -1, 6, 4, 4, 4, 6, 6, 4, /* 0,'躡','躢',0,0,0,0,'躧', 0,'躩','躪','身','躬','躭','躮','躯', */
	/* 8eb0 */  4, 4,-1, 6,-1, 6,-1,-1, -1,-1, 6, 6,-1,-1, 4,-1, /* '躰','躱',0,'躳',0,'躵',0,0, 0,0,'躺','躻',0,0,'躾',0, */
	/* 8ec0 */  6, 6,-1, 6, 6, 4, 4, 6,  4,-1, 4, 4, 4, 4,-1, 6, /* '軀','軁',0,'軃','軄','軅','軆','軇', '軈',0,'車','軋','軌','軍',0,'軏', */
	/* 8ed0 */ -1, 6, 4,-1, 6,-1,-1,-1, -1,-1,-1, 4, 6,-1,-1, 4, /* 0,'軑','軒',0,'軔',0,0,0, 0,0,0,'軛','軜',0,0,'軟', */
	/* 8ee0 */ -1,-1, 4, 4,-1,-1,-1,-1,  6,-1,-1, 4,-1, 6, 6,-1, /* 0,0,'転','軣',0,0,0,0, '軨',0,0,'軫',0,'軭','軮',0, */
	/* 8ef0 */  6, 6,-1,-1,-1,-1,-1, 6,  4, 6, 6, 4, 4, 4, 4,-1, /* '軰','軱',0,0,0,0,0,'軷', '軸','軹','軺','軻','軼','軽','軾',0, */
	/* 8f00 */  6,-1, 6, 4,-1, 4,-1, 6,  6, 4, 4,-1, 4,-1,-1, 6, /* '輀',0,'輂','較',0,'輅',0,'輇', '輈','載','輊',0,'輌',0,0,'輏', */
	/* 8f10 */  6,-1, 4, 4, 4, 4, 6, 6,  6, 4,-1, 4, 4, 4, 6, 4, /* '輐',0,'輒','輓','輔','輕','輖','輗', '輘','輙',0,'輛','輜','輝','輞','輟', */
	/* 8f20 */  6, 6,-1, 6,-1, 6, 4, 6,  6, 4, 4,-1, 6, 6, 6, 4, /* '輠','輡',0,'輣',0,'輥','輦','輧', '輨','輩','輪',0,'輬','輭','輮','輯', */
	/* 8f30 */ -1,-1,-1, 4, 6, 6, 6, 6,  4, 4, 6, 4,-1,-1, 4, 4, /* 0,0,0,'輳','輴','輵','輶','輷', '輸','輹','輺','輻',0,0,'輾','輿', */
	/* 8f40 */  6, 6, 4, 6, 4, 4, 4, 6, -1, 4,-1,-1, 4, 4, 4, 6, /* '轀','轁','轂','轃','轄','轅','轆','轇', 0,'轉',0,0,'轌','轍','轎','轏', */
	/* 8f50 */ -1, 6, 6, 6, 6, 6,-1, 4,  6,-1,-1,-1, 4, 6, 6, 4, /* 0,'轑','轒','轓','轔','轕',0,'轗', '轘',0,0,0,'轜','轝','轞','轟', */
	/* 8f60 */ -1, 4, 4, 4, 4, 6,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'轡','轢','轣','轤','轥',0,0, 0,0,0,0,0,0,0,0, */
	/* 8f70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 8f90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4, 6, 4, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,'辛','辜','辝','辞','辟', */
	/* 8fa0 */  6, 6,-1, 4, 6, 6, 6, 4,  4,-1,-1,-1,-1, 4, 4, 4, /* '辠','辡',0,'辣','辤','辥','辦','辧', '辨',0,0,0,0,'辭','辮','辯', */
	/* 8fb0 */  4, 4, 4,-1,-1, 6, 6, 4,  6,-1, 4, 4, 4,-1, 6, 4, /* '辰','辱','農',0,0,'辵','辶','辷', '辸',0,'辺','辻','込',0,'达','辿', */
	/* 8fc0 */  6, 6, 4,-1, 4, 4, 6,-1, -1,-1, 6, 6,-1, 6, 4,-1, /* '迀','迁','迂',0,'迄','迅','迆',0, 0,0,'迊','迋',0,'迍','迎',0, */
	/* 8fd0 */  6, 4, 6, 6, 4, 6,-1,-1, -1,-1, 4,-1,-1,-1,-1,-1, /* '运','近','迒','迓','返','迕',0,0, 0,0,'迚',0,0,0,0,0, */
	/* 8fe0 */  6,-1, 4, 6, 6, 4, 4,-1,  6, 4, 4, 4,-1, 4, 6, 4, /* '迠',0,'迢','迣','迤','迥','迦',0, '迨','迩','迪','迫',0,'迭','迮','迯', */
	/* 8ff0 */  4, 6,-1,-1, 4, 6, 6, 4,  4, 4, 4, 6,-1, 4, 6,-1, /* '述','迱',0,0,'迴','迵','迶','迷', '迸','迹','迺','迻',0,'追','迾',0, */
	/* 9000 */  4, 4, 6, 4, 6, 4, 4,-1,  6,-1,-1, 4, 6, 4, 4, 4, /* '退','送','适','逃','逄','逅','逆',0, '逈',0,0,'逋','逌','逍','逎','透', */
	/* 9010 */  4, 4,-1, 4, 4, 4, 4, 4,  6, 4, 4, 6,-1, 4, 4, 4, /* '逐','逑',0,'逓','途','逕','逖','逗', '逘','這','通','逛',0,'逝','逞','速', */
	/* 9020 */  4, 4, 4, 4,-1,-1,-1, 4,  6, 6, 6,-1, 6, 6, 4, 6, /* '造','逡','逢','連',0,0,0,'逧', '逨','逩','逪',0,'逬','逭','逮','逯', */
	/* 9030 */ -1, 4, 4, 6, 6, 4, 4, 6,  4, 4,-1,-1, 4,-1, 4, 6, /* 0,'週','進','逳','逴','逵','逶','逷', '逸','逹',0,0,'逼',0,'逾','逿', */
	/* 9040 */ -1, 4, 4, 6, 6, 4,-1, 4, -1, 4, 4, 4, 6, 4, 4, 4, /* 0,'遁','遂','遃','遄','遅',0,'遇', 0,'遉','遊','運','遌','遍','過','遏', */
	/* 9050 */  4, 4, 4, 4, 4, 4, 4,-1,  4, 4,-1, 6, 4, 6, 4,-1, /* '遐','遑','遒','道','達','違','遖',0, '遘','遙',0,'遛','遜','遝','遞',0, */
	/* 9060 */  4, 4, 6, 4,-1, 4, 6, 6,  4, 4,-1,-1, 6, 4, 4, 4, /* '遠','遡','遢','遣',0,'遥','遦','遧', '遨','適',0,0,'遬','遭','遮','遯', */
	/* 9070 */  6,-1, 4,-1, 6, 4, 4, 4,  4, 6, 4,-1, 4, 4,-1, 4, /* '遰',0,'遲',0,'遴','遵','遶','遷', '選','遹','遺',0,'遼','遽',0,'避', */
	/* 9080 */  4, 4, 4, 4, 4, 6,-1, 4,  6, 4, 4, 6, 6,-1, 6, 4, /* '邀','邁','邂','邃','還','邅',0,'邇', '邈','邉','邊','邋','邌',0,'邎','邏', */
	/* 9090 */  6, 4,-1,-1,-1, 6,-1, 6,  6, 6,-1, 6,-1,-1,-1,-1, /* '邐','邑',0,0,0,'邕',0,'邗', '邘','邙',0,'邛',0,0,0,0, */
	/* 90a0 */  6, 6, 6, 4,-1, 6, 4,-1,  4,-1, 4,-1,-1,-1,-1, 4, /* '邠','邡','邢','那',0,'邥','邦',0, '邨',0,'邪',0,0,0,0,'邯', */
	/* 90b0 */  6, 4, 6, 6, 6, 4, 6,-1,  4,-1,-1,-1,-1, 6, 6,-1, /* '邰','邱','邲','邳','邴','邵','邶',0, '邸',0,0,0,0,'邽','邾',0, */
	/* 90c0 */ -1, 4,-1, 6, 6, 6,-1, 6,  6,-1, 4,-1, 6,-1, 4,-1, /* 0,'郁',0,'郃','郄','郅',0,'郇', '郈',0,'郊',0,'郌',0,'郎',0, */
	/* 90d0 */ -1,-1, 6,-1,-1, 6,-1, 6,  6, 6,-1, 4, 6, 6, 6, 6, /* 0,0,'郒',0,0,'郕',0,'郗', '郘','郙',0,'郛','郜','郝','郞','郟', */
	/* 90e0 */ -1, 4, 4,-1, 4, 6,-1,-1,  4,-1,-1, 6,-1, 4,-1, 6, /* 0,'郡','郢',0,'郤','郥',0,0, '部',0,0,'郫',0,'郭',0,'郯', */
	/* 90f0 */  6,-1,-1,-1, 6, 4, 6, 4, -1,-1,-1,-1,-1, 4, 6, 6, /* '郰',0,0,0,'郴','郵','郶','郷', 0,0,0,0,0,'都','郾','郿', */
	/* 9100 */  6,-1, 4,-1, 6, 6, 6,-1,  6,-1,-1,-1,-1, 6,-1,-1, /* '鄀',0,'鄂',0,'鄄','鄅','鄆',0, '鄈',0,0,0,0,'鄍',0,0, */
	/* 9110 */  6,-1, 4,-1, 6, 6, 6, 6,  6, 4, 6,-1, 6,-1, 6,-1, /* '鄐',0,'鄒',0,'鄔','鄕','鄖','鄗', '鄘','鄙','鄚',0,'鄜',0,'鄞',0, */
	/* 9120 */  6,-1, 6, 6,-1, 6,-1, 6, -1, 6,-1,-1,-1, 4, 6, 6, /* '鄠',0,'鄢','鄣',0,'鄥',0,'鄧', 0,'鄩',0,0,0,'鄭','鄮','鄯', */
	/* 9130 */  4, 6, 4,-1, 6,-1, 6, 6, -1, 6, 6,-1, 6, 6,-1,-1, /* '鄰','鄱','鄲',0,'鄴',0,'鄶','鄷', 0,'鄹','鄺',0,'鄼','鄽',0,0, */
	/* 9140 */ -1,-1,-1, 6,-1,-1,-1, 6,  6, 4, 4, 4, 4, 4, 4, 6, /* 0,0,0,'酃',0,0,0,'酇', '酈','酉','酊','酋','酌','配','酎','酏', */
	/* 9150 */ -1,-1, 4, 6, 4,-1, 4, 6,  4, 6, 6, 6,-1,-1,-1,-1, /* 0,0,'酒','酓','酔',0,'酖','酗', '酘','酙','酚','酛',0,0,0,0, */
	/* 9160 */ -1, 6, 4, 4, 6, 4,-1, 6, -1, 4, 4,-1, 4, 6,-1,-1, /* 0,'酡','酢','酣','酤','酥',0,'酧', 0,'酩','酪',0,'酬','酭',0,0, */
	/* 9170 */ -1,-1, 4, 4, 6, 4,-1, 4,  4, 6, 6, 6,-1,-1,-1,-1, /* 0,0,'酲','酳','酴','酵',0,'酷', '酸','酹','酺','酻',0,0,0,0, */
	/* 9180 */ -1, 6, 4, 6,-1, 6, 6, 4, -1, 4, 6, 4,-1, 4, 6,-1, /* 0,'醁','醂','醃',0,'醅','醆','醇', 0,'醉','醊','醋',0,'醍','醎',0, */
	/* 9190 */  4, 6, 4, 6, 6, 6,-1, 4,  6,-1,-1,-1, 4,-1, 6,-1, /* '醐','醑','醒','醓','醔','醕',0,'醗', '醘',0,0,0,'醜',0,'醞',0, */
	/* 91a0 */ -1, 6, 4,-1, 4,-1, 6,-1,  6,-1, 4, 4, 6, 6, 6, 4, /* 0,'醡','醢',0,'醤',0,'醦',0, '醨',0,'醪','醫','醬','醭','醮','醯', */
	/* 91b0 */  6, 6, 6, 6, 4, 4, 6,-1,  4,-1, 4, 6, 6, 6,-1, 6, /* '醰','醱','醲','醳','醴','醵','醶',0, '醸',0,'醺','醻','醼','醽',0,'醿', */
	/* 91c0 */  4, 4, 6, 6,-1, 6, 4, 4,  4, 4,-1, 4, 4, 4, 4, 4, /* '釀','釁','釂','釃',0,'釅','釆','采', '釈','釉',0,'釋','里','重','野','量', */
	/* 91d0 */  4, 4,-1, 6, 6,-1, 4, 6,  4, 6, 6, 4, 4, 4, 6, 4, /* '釐','金',0,'釓','釔',0,'釖','釗', '釘','釙','釚','釛','釜','針','釞','釟', */
	/* 91e0 */ -1, 4,-1, 4, 6, 6, 4, 4, -1, 6, 6,-1, 6, 6, 6, 6, /* 0,'釡',0,'釣','釤','釥','釦','釧', 0,'釩','釪',0,'釬','釭','釮','釯', */
	/* 91f0 */  6, 6,-1,-1,-1, 4, 4, 6, -1, 6,-1, 6, 4, 6,-1, 4, /* '釰','釱',0,0,0,'釵','釶','釷', 0,'釹',0,'釻','釼','釽',0,'釿', */
	/* 9200 */  6, 6,-1,-1, 6, 6, 6, 6, -1, 6, 6,-1, 6, 4, 4,-1, /* '鈀','鈁',0,0,'鈄','鈅','鈆','鈇', 0,'鈉','鈊',0,'鈌','鈍','鈎',0, */
	/* 9210 */  6, 4, 6, 6, 4, 4, 6,-1,  6,-1,-1,-1, 6, 6, 4,-1, /* '鈐','鈑','鈒','鈓','鈔','鈕','鈖',0, '鈘',0,0,0,'鈜','鈝','鈞',0, */
	/* 9220 */ -1,-1,-1, 6, 6, 6, 6,-1,  6, 4,-1,-1, 4,-1, 6, 6, /* 0,0,0,'鈣','鈤','鈥','鈦',0, '鈨','鈩',0,0,'鈬',0,'鈮','鈯', */
	/* 9230 */  6,-1,-1, 6, 4, 6, 6, 4,  6, 6, 6,-1, 6,-1, 6, 4, /* '鈰',0,0,'鈳','鈴','鈵','鈶','鈷', '鈸','鈹','鈺',0,'鈼',0,'鈾','鈿', */
	/* 9240 */  6,-1, 6, 6, 4, 4, 6, 6,  4, 4, 6, 4,-1, 6, 6, 6, /* '鉀',0,'鉂','鉃','鉄','鉅','鉆','鉇', '鉈','鉉','鉊','鉋',0,'鉍','鉎','鉏', */
	/* 9250 */  4, 6,-1,-1,-1,-1,-1, 4,  6, 6, 4, 4, 6, 6, 4,-1, /* '鉐','鉑',0,0,0,0,0,'鉗', '鉘','鉙','鉚','鉛','鉜','鉝','鉞',0, */
	/* 9260 */  6, 6, 4,-1, 4, 6, 4, 6,  6, 6,-1,-1,-1,-1, 6, 6, /* '鉠','鉡','鉢',0,'鉤','鉥','鉦','鉧', '鉨','鉩',0,0,0,0,'鉮','鉯', */
	/* 9270 */  6, 4,-1,-1,-1, 6, 6, 6,  6, 6,-1, 6, 6, 6, 4, 6, /* '鉰','鉱',0,0,0,'鉵','鉶','鉷', '鉸','鉹',0,'鉻','鉼','鉽','鉾','鉿', */
	/* 9280 */  4,-1,-1, 4,-1, 4,-1,-1,  6, 6, 6,-1,-1, 6, 6,-1, /* '銀',0,0,'銃',0,'銅',0,0, '銈','銉','銊',0,0,'銍','銎',0, */
	/* 9290 */ -1, 4, 6, 4,-1, 4, 4, 6,  4, 6, 4, 4, 4,-1,-1, 6, /* 0,'銑','銒','銓',0,'銕','銖','銗', '銘','銙','銚','銛','銜',0,0,'銟', */
	/* 92a0 */  6,-1,-1,-1, 6, 6,-1, 6,  6,-1,-1, 6,-1, 4,-1, 6, /* '銠',0,0,0,'銤','銥',0,'銧', '銨',0,0,'銫',0,'銭',0,'銯', */
	/* 92b0 */ -1,-1, 6,-1,-1,-1, 6, 4,  6, 4, 6, 6, 6, 6,-1, 6, /* 0,0,'銲',0,0,0,'銶','銷', '銸','銹','銺','銻','銼','銽',0,'銿', */
	/* 92c0 */  6, 6, 6, 6,-1, 6, 6, 6,  6,-1,-1, 6, 6, 6, 6, 4, /* '鋀','鋁','鋂','鋃',0,'鋅','鋆','鋇', '鋈',0,0,'鋋','鋌','鋍','鋎','鋏', */
	/* 92d0 */  6,-1, 4, 6,-1, 6,-1, 6,  6, 6,-1,-1, 6, 6,-1, 6, /* '鋐',0,'鋒','鋓',0,'鋕',0,'鋗', '鋘','鋙',0,0,'鋜','鋝',0,'鋟', */
	/* 92e0 */  6, 6,-1, 6, 4, 6,-1, 6,  6, 4, 4,-1, 6, 4, 6,-1, /* '鋠','鋡',0,'鋣','鋤','鋥',0,'鋧', '鋨','鋩','鋪',0,'鋬','鋭','鋮',0, */
	/* 92f0 */  6,-1, 4, 4,-1,-1,-1,-1,  4, 6, 4, 6, 4,-1,-1, 6, /* '鋰',0,'鋲','鋳',0,0,0,0, '鋸','鋹','鋺','鋻','鋼',0,0,'鋿', */
	/* 9300 */  6,-1, 6,-1,-1,-1, 4,-1,  6,-1,-1,-1,-1, 6,-1, 4, /* '錀',0,'錂',0,0,0,'錆',0, '錈',0,0,0,0,'錍',0,'錏', */
	/* 9310 */  4, 6,-1,-1, 6, 6,-1,-1,  4, 4, 4,-1, 6, 6, 6, 6, /* '錐','錑',0,0,'錔','錕',0,0, '錘','錙','錚',0,'錜','錝','錞','錟', */
	/* 9320 */  4, 6, 4, 4, 6, 6, 4, 6,  4, 6, 6, 4, 4,-1, 4, 4, /* '錠','錡','錢','錣','錤','錥','錦','錧', '錨','錩','錪','錫','錬',0,'錮','錯', */
	/* 9330 */ -1,-1, 4, 6, 6, 4, 6, 6, -1,-1, 4, 4,-1,-1,-1,-1, /* 0,0,'録','錳','錴','錵','錶','錷', 0,0,'錺','錻',0,0,0,0, */
	/* 9340 */ -1,-1,-1,-1, 4,-1,-1, 6,  6, 6,-1, 4,-1, 4,-1,-1, /* 0,0,0,0,'鍄',0,0,'鍇', '鍈','鍉',0,'鍋',0,'鍍',0,0, */
	/* 9350 */  6, 6, 6,-1, 4, 6, 4, 6,  6,-1, 6, 4, 4,-1, 6,-1, /* '鍐','鍑','鍒',0,'鍔','鍕','鍖','鍗', '鍘',0,'鍚','鍛','鍜',0,'鍞',0, */
	/* 9360 */  4,-1,-1,-1, 6, 6,-1, 6, -1, 6, 6,-1, 4, 6, 4, 6, /* '鍠',0,0,0,'鍤','鍥',0,'鍧', 0,'鍩','鍪',0,'鍬','鍭','鍮','鍯', */
	/* 9370 */  6, 6,-1, 6, 6, 4, 6,-1, -1,-1, 6,-1, 4, 6, 4, 6, /* '鍰','鍱',0,'鍳','鍴','鍵','鍶',0, 0,0,'鍺',0,'鍼','鍽','鍾','鍿', */
	/* 9380 */  6, 6, 6,-1,-1,-1,-1,-1,  6,-1, 6, 6, 4, 6,-1, 6, /* '鎀','鎁','鎂',0,0,0,0,0, '鎈',0,'鎊','鎋','鎌','鎍',0,'鎏', */
	/* 9390 */ -1,-1, 6,-1, 4, 6, 4, 4,  6,-1, 4, 6,-1,-1, 6,-1, /* 0,0,'鎒',0,'鎔','鎕','鎖','鎗', '鎘',0,'鎚','鎛',0,0,'鎞',0, */
	/* 93a0 */ -1, 6,-1, 6, 6,-1, 6, 4,  6, 6,-1, 6, 4, 4, 4,-1, /* 0,'鎡',0,'鎣','鎤',0,'鎦','鎧', '鎨','鎩',0,'鎫','鎬','鎭','鎮',0, */
	/* 93b0 */  4,-1,-1,-1, 6, 6, 6,-1, -1, 4, 6,-1,-1,-1,-1,-1, /* '鎰',0,0,0,'鎴','鎵','鎶',0, 0,'鎹','鎺',0,0,0,0,0, */
	/* 93c0 */ -1, 6,-1, 4, 6, 6, 6, 6,  4, 6, 6, 6, 6, 6,-1,-1, /* 0,'鏁',0,'鏃','鏄','鏅','鏆','鏇', '鏈','鏉','鏊','鏋','鏌','鏍',0,0, */
	/* 93d0 */  4, 4,-1, 6,-1,-1, 4, 4,  4, 6,-1,-1, 6, 4, 6, 6, /* '鏐','鏑',0,'鏓',0,0,'鏖','鏗', '鏘','鏙',0,0,'鏜','鏝','鏞','鏟', */
	/* 93e0 */ -1, 4, 6,-1, 4, 4, 6, 6,  4,-1,-1,-1,-1,-1,-1,-1, /* 0,'鏡','鏢',0,'鏤','鏥','鏦','鏧', '鏨',0,0,0,0,0,0,0, */
	/* 93f0 */ -1,-1,-1,-1,-1,-1,-1, 6,  6, 6, 6, 6,-1, 6,-1,-1, /* 0,0,0,0,0,0,0,'鏷', '鏸','鏹','鏺','鏻',0,'鏽',0,0, */
	/* 9400 */ -1, 6, 6, 4, 6,-1,-1, 4,  6, 6,-1,-1,-1, 6, 6, 6, /* 0,'鐁','鐂','鐃','鐄',0,0,'鐇', '鐈','鐉',0,0,0,'鐍','鐎','鐏', */
	/* 9410 */  4,-1,-1, 4, 4, 6, 6, 6,  4, 4, 4,-1,-1,-1,-1, 6, /* '鐐',0,0,'鐓','鐔','鐕','鐖','鐗', '鐘','鐙','鐚',0,0,0,0,'鐟', */
	/* 9420 */ -1, 4,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4,-1,-1, 6, 6, /* 0,'鐡',0,0,0,0,0,0, 0,0,0,'鐫',0,0,'鐮','鐯', */
	/* 9430 */ -1, 6, 6, 6, 6, 4, 4,-1,  4,-1, 4, 6,-1, 6,-1, 6, /* 0,'鐱','鐲','鐳','鐴','鐵','鐶',0, '鐸',0,'鐺','鐻',0,'鐽',0,'鐿', */
	/* 9440 */ -1, 4,-1, 6, 4, 6,-1,-1,  6,-1, 6,-1, 6,-1,-1,-1, /* 0,'鑁',0,'鑃','鑄','鑅',0,0, '鑈',0,'鑊',0,'鑌',0,0,0, */
	/* 9450 */ -1, 4, 4, 4,-1, 6,-1,-1, -1, 6, 4, 4, 6,-1, 4, 6, /* 0,'鑑','鑒','鑓',0,'鑕',0,0, 0,'鑙','鑚','鑛','鑜',0,'鑞','鑟', */
	/* 9460 */  4, 6, 4, 6,-1,-1,-1,-1,  6,-1, 4, 6,-1, 6, 6, 6, /* '鑠','鑡','鑢','鑣',0,0,0,0, '鑨',0,'鑪','鑫',0,'鑭','鑮','鑯', */
	/* 9470 */  4, 6, 6,-1,-1, 4,-1, 4, -1,-1,-1,-1, 4, 4, 4, 4, /* '鑰','鑱','鑲',0,0,'鑵',0,'鑷', 0,0,0,0,'鑼','鑽','鑾','鑿', */
	/* 9480 */ -1, 4,-1, 6, 6,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* 0,'钁',0,'钃','钄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 94f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9570 */ -1,-1,-1,-1,-1,-1,-1, 4,  6, 6,-1,-1,-1,-1, 6,-1, /* 0,0,0,0,0,0,0,'長', '镸','镹',0,0,0,0,'镾',0, */
	/* 9580 */  4,-1, 4, 4, 6,-1,-1, 4,  6, 4, 4, 4, 6, 6, 6, 4, /* '門',0,'閂','閃','閄',0,0,'閇', '閈','閉','閊','開','閌','閍','閎','閏', */
	/* 9590 */ -1, 4, 6, 4, 4,-1, 4,-1,  4, 4,-1,-1,-1, 6, 6, 6, /* 0,'閑','閒','間','閔',0,'閖',0, '閘','閙',0,0,0,'閝','閞','閟', */
	/* 95a0 */  4, 6, 4, 4, 4, 4, 6, 4,  4, 6,-1, 6, 6, 4,-1,-1, /* '閠','閡','関','閣','閤','閥','閦','閧', '閨','閩',0,'閫','閬','閭',0,0, */
	/* 95b0 */ -1,-1, 4,-1, 6,-1, 6,-1, -1, 4, 6, 4, 4, 6, 4, 6, /* 0,0,'閲',0,'閴',0,'閶',0, 0,'閹','閺','閻','閼','閽','閾','閿', */
	/* 95c0 */ -1,-1,-1, 4,-1,-1, 6, 4,  6, 6, 4, 6, 4, 4,-1,-1, /* 0,0,0,'闃',0,0,'闆','闇', '闈','闉','闊','闋','闌','闍',0,0, */
	/* 95d0 */  6, 6, 6, 6, 4, 4, 4,-1,  4, 6, 6,-1, 4, 6, 6, 6, /* '闐','闑','闒','闓','闔','闕','闖',0, '闘','闙','闚',0,'關','闝','闞','闟', */
	/* 95e0 */  6, 4, 4,-1, 6, 4, 6,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '闠','闡','闢',0,'闤','闥','闦',0, 0,0,0,0,0,0,0,0, */
	/* 95f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 4, 6, 6,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'阜','阝','阞',0, */
	/* 9620 */ -1, 4, 6,-1, 6, 6, 6,-1,  4,-1, 4,-1, 6,-1, 4, 4, /* 0,'阡','阢',0,'阤','阥','阦',0, '阨',0,'阪',0,'阬',0,'阮','阯', */
	/* 9630 */ -1, 6, 4, 6,-1,-1,-1, 6,  6, 6, 6, 4, 6, 6,-1, 4, /* 0,'阱','防','阳',0,0,0,'阷', '阸','阹','阺','阻','阼','阽',0,'阿', */
	/* 9640 */  4, 6, 4,-1, 4,-1,-1,-1, -1,-1,-1, 4, 4, 4,-1, 4, /* '陀','陁','陂',0,'附',0,0,0, 0,0,0,'陋','陌','降',0,'陏', */
	/* 9650 */  4,-1, 6,-1, 6,-1, 6, 6,  6,-1,-1, 4, 4, 4, 4, 4, /* '限',0,'陒',0,'陔',0,'陖','陗', '陘',0,0,'陛','陜','陝','陞','陟', */
	/* 9660 */ -1, 6, 4, 4, 4, 4, 4,-1, -1,-1, 4,-1, 4,-1, 6,-1, /* 0,'陡','院','陣','除','陥','陦',0, 0,0,'陪',0,'陬',0,'陮',0, */
	/* 9670 */  4,-1, 4, 4, 6, 4, 4, 4,  4,-1, 4, 6, 6, 4, 6, 6, /* '陰',0,'陲','陳','陴','陵','陶','陷', '陸',0,'険','陻','陼','陽','陾','陿', */
	/* 9680 */ -1, 6, 6, 6, 6, 4, 4,-1,  4, 6, 4, 4,-1, 4, 4, 4, /* 0,'隁','隂','隃','隄','隅','隆',0, '隈','隉','隊','隋',0,'隍','階','随', */
	/* 9690 */ -1, 6,-1,-1, 4, 4, 6, 4,  4, 4, 6, 4, 4, 6,-1, 6, /* 0,'隑',0,0,'隔','隕','隖','隗', '隘','隙','隚','際','障','隝',0,'隟', */
	/* 96a0 */  4,-1,-1, 4, 6, 6, 6, 4,  4, 6, 4,-1,-1,-1, 6, 6, /* '隠',0,0,'隣','隤','隥','隦','隧', '隨','隩','險',0,0,0,'隮','隯', */
	/* 96b0 */  4, 4, 4, 6, 4,-1, 4, 4,  4, 4, 6, 4, 4,-1,-1,-1, /* '隰','隱','隲','隳','隴',0,'隶','隷', '隸','隹','隺','隻','隼',0,0,0, */
	/* 96c0 */  4, 4,-1,-1, 4, 4, 4, 4, -1, 4, 6, 4, 4, 4, 4,-1, /* '雀','雁',0,0,'雄','雅','集','雇', 0,'雉','雊','雋','雌','雍','雎',0, */
	/* 96d0 */ -1, 4, 6,-1,-1, 4, 4,-1,  6, 4, 6, 4, 4, 6, 6, 6, /* 0,'雑','雒',0,0,'雕','雖',0, '雘','雙','雚','雛','雜','雝','雞','雟', */
	/* 96e0 */ -1,-1, 4, 4,-1,-1,-1,-1,  4, 6, 4, 4,-1,-1,-1, 6, /* 0,0,'離','難',0,0,0,0, '雨','雩','雪','雫',0,0,0,'雯', */
	/* 96f0 */  4, 6, 4,-1,-1,-1, 4, 4, -1, 4, 6, 4,-1,-1,-1,-1, /* '雰','雱','雲',0,0,0,'零','雷', 0,'雹','雺','電',0,0,0,0, */
	/* 9700 */  4,-1, 6, 6, 4, 6, 4, 4,  4, 6, 4,-1,-1, 4, 4, 4, /* '需',0,'霂','霃','霄','霅','霆','震', '霈','霉','霊',0,0,'霍','霎','霏', */
	/* 9710 */ -1, 4,-1, 4,-1,-1, 4,-1, -1, 4, 6, 6, 4, 6, 4,-1, /* 0,'霑',0,'霓',0,0,'霖',0, 0,'霙','霚','霛','霜','霝','霞',0, */
	/* 9720 */ -1, 6, 6, 6, 4,-1,-1, 4,  6,-1, 4,-1,-1,-1,-1,-1, /* 0,'霡','霢','霣','霤',0,0,'霧', '霨',0,'霪',0,0,0,0,0, */
	/* 9730 */  4, 6, 4, 6,-1,-1,-1,-1,  4, 4,-1, 6,-1, 4, 4,-1, /* '霰','霱','露','霳',0,0,0,0, '霸','霹',0,'霻',0,'霽','霾',0, */
	/* 9740 */ -1, 6, 4, 6, 4,-1, 4,-1,  4, 4, 6,-1,-1, 6, 6, 6, /* 0,'靁','靂','靃','靄',0,'靆',0, '靈','靉','靊',0,0,'靍','靎','靏', */
	/* 9750 */ -1, 6, 4,-1,-1, 6, 4, 6,  6, 4, 6, 6, 4,-1, 4,-1, /* 0,'靑','青',0,0,'靕','靖','靗', '靘','静','靚','靛','靜',0,'非',0, */
	/* 9760 */  4, 4, 4, 6, 4,-1, 4, 6,  4, 4, 6, 4,-1, 4, 6,-1, /* '靠','靡','面','靣','靤',0,'靦','靧', '靨','革','靪','靫',0,'靭','靮',0, */
	/* 9770 */ -1, 4,-1, 6, 4,-1, 6, 6,  6, 4, 4, 6, 4, 6,-1, 6, /* 0,'靱',0,'靳','靴',0,'靶','靷', '靸','靹','靺','靻','靼','靽',0,'靿', */
	/* 9780 */  6, 4,-1,-1, 4, 4, 4,-1, -1, 6,-1, 4,-1, 4,-1, 4, /* '鞀','鞁',0,0,'鞄','鞅','鞆',0, 0,'鞉',0,'鞋',0,'鞍',0,'鞏', */
	/* 9790 */  4,-1,-1,-1,-1, 6, 6, 6,  4, 6, 6,-1, 4,-1, 6, 6, /* '鞐',0,0,0,0,'鞕','鞖','鞗', '鞘','鞙','鞚',0,'鞜',0,'鞞','鞟', */
	/* 97a0 */  4,-1, 6, 4,-1,-1, 4,-1,  4,-1,-1, 4, 6, 4, 6,-1, /* '鞠',0,'鞢','鞣',0,0,'鞦',0, '鞨',0,0,'鞫','鞬','鞭','鞮',0, */
	/* 97b0 */ -1, 6, 6, 4, 4, 6, 6,-1,  6, 6, 6,-1, 6,-1, 6, 6, /* 0,'鞱','鞲','鞳','鞴','鞵','鞶',0, '鞸','鞹','鞺',0,'鞼',0,'鞾','鞿', */
	/* 97c0 */ -1, 6,-1, 4, 6, 6, 4, 6,  4, 6, 6, 4, 6, 6, 6,-1, /* 0,'韁',0,'韃','韄','韅','韆','韇', '韈','韉','韊','韋','韌','韍','韎',0, */
	/* 97d0 */  6, 6,-1, 4, 6,-1,-1, 6,  6, 6,-1, 6, 4, 6, 6,-1, /* '韐','韑',0,'韓','韔',0,0,'韗', '韘','韙',0,'韛','韜','韝','韞',0, */
	/* 97e0 */  6, 6,-1,-1, 6,-1,-1,-1, -1,-1,-1,-1,-1, 4, 4, 6, /* '韠','韡',0,0,'韤',0,0,0, 0,0,0,0,0,'韭','韮','韯', */
	/* 97f0 */ -1, 6, 4, 4, 6, 4, 4, 6,  6,-1, 6, 4,-1,-1,-1, 4, /* 0,'韱','韲','音','韴','韵','韶','韷', '韸',0,'韺','韻',0,0,0,'響', */
	/* 9800 */ -1, 4, 4, 4,-1, 4, 4, 6,  4,-1, 6,-1, 4, 6, 6, 4, /* 0,'頁','頂','頃',0,'項','順','頇', '須',0,'頊',0,'頌','頍','頎','頏', */
	/* 9810 */  4, 4, 4, 4, 6,-1, 6, 4,  4, 6, 4,-1, 6,-1, 6,-1, /* '預','頑','頒','頓','頔',0,'頖','頗', '領','頙','頚',0,'頜',0,'頞',0, */
	/* 9820 */  6, 4,-1, 6, 4, 6, 6,-1, -1,-1,-1, 6, 4, 4, 6, 6, /* '頠','頡',0,'頣','頤','頥','頦',0, 0,0,0,'頫','頬','頭','頮','頯', */
	/* 9830 */  6,-1, 6, 6, 4, 6,-1, 4,  4,-1,-1, 4, 4, 4, 6,-1, /* '頰',0,'頲','頳','頴','頵',0,'頷', '頸',0,0,'頻','頼','頽','頾',0, */
	/* 9840 */ -1,-1,-1,-1, 6,-1, 4, 6, -1,-1, 6, 4, 4, 4, 4, 4, /* 0,0,0,0,'顄',0,'顆','顇', 0,0,'顊','顋','題','額','顎','顏', */
	/* 9850 */ -1, 6, 6, 6, 4, 4, 6, 6,  4, 6, 6, 4,-1,-1, 4,-1, /* 0,'顑','顒','顓','顔','顕','顖','顗', '願','顙','顚','顛',0,0,'類',0, */
	/* 9860 */ -1,-1, 6, 6,-1, 6, 6, 4, -1,-1, 6, 4, 6,-1,-1, 4, /* 0,0,'顢','顣',0,'顥','顦','顧', 0,0,'顪','顫','顬',0,0,'顯', */
	/* 9870 */  4, 4,-1, 4, 4,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '顰','顱',0,'顳','顴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 98a0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1, 4, 6,-1, 6, 6, 4, /* 0,0,0,0,0,0,0,0, '風',0,'颪','颫',0,'颭','颮','颯', */
	/* 98b0 */  6, 4,-1,-1, 6,-1, 4, 6,  6,-1, 6, 6,-1,-1,-1, 6, /* '颰','颱',0,0,'颴',0,'颶','颷', '颸',0,'颺','颻',0,0,0,'颿', */
	/* 98c0 */ -1,-1, 6, 4, 4, 6, 4,-1,  6,-1,-1,-1, 6,-1,-1,-1, /* 0,0,'飂','飃','飄','飅','飆',0, '飈',0,0,0,'飌',0,0,0, */
	/* 98d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1, 4, 4,-1,-1, 4, /* 0,0,0,0,0,0,0,0, 0,0,0,'飛','飜',0,0,'食', */
	/* 98e0 */ -1, 6, 4, 6,-1, 6, 6, 6, -1, 4, 6, 4,-1, 4, 4, 4, /* 0,'飡','飢','飣',0,'飥','飦','飧', 0,'飩','飪','飫',0,'飭','飮','飯', */
	/* 98f0 */ -1,-1, 4, 6, 4,-1, 6,-1, -1,-1,-1,-1, 4, 4, 4,-1, /* 0,0,'飲','飳','飴',0,'飶',0, 0,0,0,0,'飼','飽','飾',0, */
	/* 9900 */ -1,-1, 6, 4,-1, 4,-1, 6,  6, 4, 4,-1, 4,-1,-1,-1, /* 0,0,'餂','餃',0,'餅',0,'餇', '餈','餉','養',0,'餌',0,0,0, */
	/* 9910 */  4, 6, 4, 4, 4, 6, 6, 6,  4,-1, 6, 6, 6, 4, 4, 6, /* '餐','餑','餒','餓','餔','餕','餖','餗', '餘',0,'餚','餛','餜','餝','餞','餟', */
	/* 9920 */  4, 4, 6,-1, 4,-1, 6, 6,  4,-1,-1, 6, 4,-1, 4,-1, /* '餠','餡','餢',0,'餤',0,'餦','餧', '館',0,0,'餫','餬',0,'餮',0, */
	/* 9930 */ -1, 6, 6, 6, 6, 6,-1,-1, -1, 6, 6, 6, 6, 4, 4,-1, /* 0,'餱','餲','餳','餴','餵',0,0, 0,'餹','餺','餻','餼','餽','餾',0, */
	/* 9940 */  6, 6, 4,-1,-1, 4, 6, 6,  6, 4,-1, 4, 4, 6, 6,-1, /* '饀','饁','饂',0,0,'饅','饆','饇', '饈','饉',0,'饋','饌','饍','饎',0, */
	/* 9950 */  4, 4, 4,-1, 6, 4,-1, 4,  6, 6,-1, 6, 6,-1, 6, 6, /* '饐','饑','饒',0,'饔','饕',0,'饗', '饘','饙',0,'饛','饜',0,'饞','饟', */
	/* 9960 */  6,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '饠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9990 */ -1,-1,-1,-1,-1,-1, 4, 4,  4, 4,-1, 6,-1, 6, 6, 6, /* 0,0,0,0,0,0,'首','馗', '馘','香',0,'馛',0,'馝','馞','馟', */
	/* 99a0 */ -1,-1,-1,-1,-1, 4, 6,-1,  4,-1,-1,-1, 4, 4, 4,-1, /* 0,0,0,0,0,'馥','馦',0, '馨',0,0,0,'馬','馭','馮',0, */
	/* 99b0 */  6, 6, 6, 4, 4, 6,-1,-1, -1, 6, 6,-1, 4, 6,-1, 6, /* '馰','馱','馲','馳','馴','馵',0,0, 0,'馹','馺',0,'馼','馽',0,'馿', */
	/* 99c0 */ -1, 4,-1, 6, 4, 4, 4,-1,  4, 6,-1,-1,-1,-1,-1,-1, /* 0,'駁',0,'駃','駄','駅','駆',0, '駈','駉',0,0,0,0,0,0, */
	/* 99d0 */  4, 4, 4, 6, 6, 4,-1,-1,  4, 6, 6, 4, 6, 4, 6, 4, /* '駐','駑','駒','駓','駔','駕',0,0, '駘','駙','駚','駛','駜','駝','駞','駟', */
	/* 99e0 */ -1,-1, 4,-1,-1,-1,-1, 6, -1,-1, 6, 6, 6, 4, 4,-1, /* 0,0,'駢',0,0,0,0,'駧', 0,0,'駪','駫','駬','駭','駮',0, */
	/* 99f0 */  6, 4, 4,-1, 6, 6,-1,-1,  4, 6,-1, 4,-1, 6, 6, 4, /* '駰','駱','駲',0,'駴','駵',0,0, '駸','駹',0,'駻',0,'駽','駾','駿', */
	/* 9a00 */ -1, 4, 6, 6, 6, 4,-1,-1, -1,-1,-1, 6, 6,-1, 4, 4, /* 0,'騁','騂','騃','騄','騅',0,0, 0,0,0,'騋','騌',0,'騎','騏', */
	/* 9a10 */  6, 6, 4, 4,-1,-1, 6,-1, -1, 4,-1,-1,-1,-1, 6,-1, /* '騐','騑','騒','験',0,0,'騖',0, 0,'騙',0,0,0,0,'騞',0, */
	/* 9a20 */  6,-1, 6, 6, 6,-1,-1, 6,  4,-1,-1, 4,-1, 6, 6,-1, /* '騠',0,'騢','騣','騤',0,0,'騧', '騨',0,0,'騫',0,'騭','騮',0, */
	/* 9a30 */  4,-1,-1, 6,-1, 6, 6, 4,  6,-1,-1,-1,-1,-1, 4,-1, /* '騰',0,0,'騳',0,'騵','騶','騷', '騸',0,0,0,0,0,'騾',0, */
	/* 9a40 */  4, 6, 4, 4, 6, 4,-1, 6, -1,-1, 6, 6, 6, 4, 6,-1, /* '驀','驁','驂','驃','驄','驅',0,'驇', 0,0,'驊','驋','驌','驍','驎',0, */
	/* 9a50 */ -1, 6,-1,-1, 6, 4, 6, 4, -1,-1, 4, 4,-1, 6,-1, 4, /* 0,'驑',0,0,'驔','驕','驖','驗', 0,0,'驚','驛',0,'驝',0,'驟', */
	/* 9a60 */ -1,-1, 4,-1, 4, 4,-1,-1, -1, 4, 4, 4,-1,-1,-1,-1, /* 0,0,'驢',0,'驤','驥',0,0, 0,'驩','驪','驫',0,0,0,0, */
	/* 9a70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9a90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9aa0 */ -1,-1,-1,-1,-1,-1,-1,-1,  4,-1, 6,-1, 6, 4, 6, 6, /* 0,0,0,0,0,0,0,0, '骨',0,'骪',0,'骬','骭','骮','骯', */
	/* 9ab0 */  4,-1, 6,-1, 6, 6, 6,-1,  4, 6,-1, 6, 4,-1, 6, 6, /* '骰',0,'骲',0,'骴','骵','骶',0, '骸','骹',0,'骻','骼',0,'骾','骿', */
	/* 9ac0 */  4, 6,-1, 6, 4,-1, 6,-1,  6,-1,-1,-1,-1,-1, 6, 4, /* '髀','髁',0,'髃','髄',0,'髆',0, '髈',0,0,0,0,0,'髎','髏', */
	/* 9ad0 */  6, 4, 6, 4, 4, 6, 6, 6,  4, 6,-1, 6, 6,-1, 4, 4, /* '髐','髑','髒','髓','體','髕','髖','髗', '高','髙',0,'髛','髜',0,'髞','髟', */
	/* 9ae0 */  6,-1, 4, 4, 6, 6, 4, 6, -1, 6, 4, 4, 6, 4, 4, 4, /* '髠',0,'髢','髣','髤','髥','髦','髧', 0,'髩','髪','髫','髬','髭','髮','髯', */
	/* 9af0 */ -1, 4, 6, 6, 4, 6,-1, 4, -1, 6, 6, 4,-1, 6,-1, 6, /* 0,'髱','髲','髳','髴','髵',0,'髷', 0,'髹','髺','髻',0,'髽',0,'髿', */
	/* 9b00 */  6, 6, 6, 6, 6, 6, 4,-1,  6, 6,-1, 6, 6, 6, 6,-1, /* '鬀','鬁','鬂','鬃','鬄','鬅','鬆',0, '鬈','鬉',0,'鬋','鬌','鬍','鬎',0, */
	/* 9b10 */  6,-1, 6,-1,-1,-1, 6,-1,  4, 6, 4, 6, 6,-1,-1, 4, /* '鬐',0,'鬒',0,0,0,'鬖',0, '鬘','鬙','鬚','鬛','鬜',0,0,'鬟', */
	/* 9b20 */  6,-1, 4, 4,-1, 4, 6, 4,  4, 4, 4, 6,-1, 6, 4, 4, /* '鬠',0,'鬢','鬣',0,'鬥','鬦','鬧', '鬨','鬩','鬪','鬫',0,'鬭','鬮','鬯', */
	/* 9b30 */ -1, 4, 4, 6, 6, 6,-1, 6, -1, 6, 6, 4, 4, 6,-1,-1, /* 0,'鬱','鬲','鬳','鬴','鬵',0,'鬷', 0,'鬹','鬺','鬻','鬼','鬽',0,0, */
	/* 9b40 */ -1, 4, 4, 4, 4, 4,-1,-1,  6,-1,-1, 6, 6, 4, 4, 4, /* 0,'魁','魂','魃','魄','魅',0,0, '魈',0,0,'魋','魌','魍','魎','魏', */
	/* 9b50 */ -1, 4,-1,-1, 4, 6, 6, 6,  4,-1, 4, 6,-1,-1, 6,-1, /* 0,'魑',0,0,'魔','魕','魖','魗', '魘',0,'魚','魛',0,0,'魞',0, */
	/* 9b60 */ -1, 6,-1, 6,-1, 6, 6,-1,  6,-1, 6, 6, 6, 6, 6, 4, /* 0,'魡',0,'魣',0,'魥','魦',0, '魨',0,'魪','魫','魬','魭','魮','魯', */
	/* 9b70 */ -1,-1, 6, 6, 4, 6,-1, 6,  6, 6,-1,-1,-1,-1,-1, 6, /* 0,0,'魲','魳','魴','魵',0,'魷', '魸','魹',0,0,0,0,0,'魿', */
	/* 9b80 */  6,-1,-1, 4, 6, 6, 6, 6, -1, 6, 6, 6,-1, 6, 4, 6, /* '鮀',0,0,'鮃','鮄','鮅','鮆','鮇', 0,'鮉','鮊','鮋',0,'鮍','鮎','鮏', */
	/* 9b90 */  6, 4, 4, 4, 6,-1, 4, 4, -1,-1, 6,-1,-1, 6, 6, 4, /* '鮐','鮑','鮒','鮓','鮔',0,'鮖','鮗', 0,0,'鮚',0,0,'鮝','鮞','鮟', */
	/* 9ba0 */  4,-1,-1,-1,-1,-1, 6, 6,  4, 6, 4, 4, 6, 4, 4,-1, /* '鮠',0,0,0,0,0,'鮦','鮧', '鮨','鮩','鮪','鮫','鮬','鮭','鮮',0, */
	/* 9bb0 */  6, 6, 6,-1, 4,-1,-1, 6,  6, 4,-1, 6, 6,-1, 6, 6, /* '鮰','鮱','鮲',0,'鮴',0,0,'鮷', '鮸','鮹',0,'鮻','鮼',0,'鮾','鮿', */
	/* 9bc0 */  4, 6,-1,-1,-1,-1, 4, 6,  6, 4, 4,-1,-1,-1, 6, 4, /* '鯀','鯁',0,0,0,0,'鯆','鯇', '鯈','鯉','鯊',0,0,0,'鯎','鯏', */
	/* 9bd0 */  6, 4, 4,-1, 4,-1, 4, 6,  6,-1,-1, 4,-1, 6,-1, 6, /* '鯐','鯑','鯒',0,'鯔',0,'鯖','鯗', '鯘',0,0,'鯛',0,'鯝',0,'鯟', */
	/* 9be0 */ -1, 4, 4, 4, 4, 6,-1, 6,  4,-1, 6, 6,-1,-1,-1, 6, /* 0,'鯡','鯢','鯣','鯤','鯥',0,'鯧', '鯨',0,'鯪','鯫',0,0,0,'鯯', */
	/* 9bf0 */  4, 4, 4, 6,-1, 4,-1, 6,  6, 6, 6,-1,-1, 6,-1, 6, /* '鯰','鯱','鯲','鯳',0,'鯵',0,'鯷', '鯸','鯹','鯺',0,0,'鯽',0,'鯿', */
	/* 9c00 */  6,-1, 6,-1, 4,-1, 4,-1,  4, 4, 4, 6, 4, 4,-1, 6, /* '鰀',0,'鰂',0,'鰄',0,'鰆',0, '鰈','鰉','鰊','鰋','鰌','鰍',0,'鰏', */
	/* 9c10 */  4, 6, 4, 4, 4, 4, 6,-1,  6, 6, 6, 4, 6,-1, 6,-1, /* '鰐','鰑','鰒','鰓','鰔','鰕','鰖',0, '鰘','鰙','鰚','鰛','鰜',0,'鰞',0, */
	/* 9c20 */ -1, 4, 6, 6, 4, 4, 6, 6,  6, 6, 6,-1,-1, 4, 4, 4, /* 0,'鰡','鰢','鰣','鰤','鰥','鰦','鰧', '鰨','鰩','鰪',0,0,'鰭','鰮','鰯', */
	/* 9c30 */  4, 6, 4,-1,-1, 6, 6, 6, -1, 4, 4, 4,-1, 6, 4,-1, /* '鰰','鰱','鰲',0,0,'鰵','鰶','鰷', 0,'鰹','鰺','鰻',0,'鰽','鰾',0, */
	/* 9c40 */ -1, 6,-1, 6, 6, 6, 4, 4,  4, 6, 6,-1,-1,-1, 6, 6, /* 0,'鱁',0,'鱃','鱄','鱅','鱆','鱇', '鱈','鱉','鱊',0,0,0,'鱎','鱏', */
	/* 9c50 */  6,-1, 4, 6, 6,-1, 6, 4,  6,-1, 4, 6, 6, 6, 6, 6, /* '鱐',0,'鱒','鱓','鱔',0,'鱖','鱗', '鱘',0,'鱚','鱛','鱜','鱝','鱞','鱟', */
	/* 9c60 */  4,-1,-1, 6,-1,-1,-1, 4,  6, 6, 6, 6,-1,-1, 6,-1, /* '鱠',0,0,'鱣',0,0,0,'鱧', '鱨','鱩','鱪','鱫',0,0,'鱮',0, */
	/* 9c70 */  6,-1, 6,-1,-1, 6, 4, 6,  4,-1,-1, 6,-1,-1,-1,-1, /* '鱰',0,'鱲',0,0,'鱵','鱶','鱷', '鱸',0,0,'鱻',0,0,0,0, */
	/* 9c80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9c90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9cd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ce0 */ -1,-1,-1,-1,-1, 4, 6, 4, -1, 4,-1, 4, 4,-1,-1,-1, /* 0,0,0,0,0,'鳥','鳦','鳧', 0,'鳩',0,'鳫','鳬',0,0,0, */
	/* 9cf0 */  4,-1, 6, 4, 4,-1, 4, 6, -1, 6,-1,-1,-1,-1,-1,-1, /* '鳰',0,'鳲','鳳','鳴',0,'鳶','鳷', 0,'鳹',0,0,0,0,0,0, */
	/* 9d00 */ -1,-1, 6, 4,-1,-1, 4, 4,  4, 4,-1, 6,-1,-1, 4,-1, /* 0,0,'鴂','鴃',0,0,'鴆','鴇', '鴈','鴉',0,'鴋',0,0,'鴎',0, */
	/* 9d10 */ -1, 6, 4,-1,-1, 4,-1, 6,  6,-1,-1, 4, 6, 6, 6, 4, /* 0,'鴑','鴒',0,0,'鴕',0,'鴗', '鴘',0,0,'鴛','鴜','鴝','鴞','鴟', */
	/* 9d20 */ -1,-1,-1, 4,-1,-1, 4,-1,  4,-1, 4, 4, 4,-1,-1, 6, /* 0,0,0,'鴣',0,0,'鴦',0, '鴨',0,'鴪','鴫','鴬',0,0,'鴯', */
	/* 9d30 */  6,-1, 6, 6, 6,-1,-1,-1, -1,-1, 6, 4, 6, 6, 4, 4, /* '鴰',0,'鴲','鴳','鴴',0,0,0, 0,0,'鴺','鴻','鴼','鴽','鴾','鴿', */
	/* 9d40 */ -1, 4, 6, 6, 4, 6, 4, 6,  4,-1, 6,-1,-1,-1,-1,-1, /* 0,'鵁','鵂','鵃','鵄','鵅','鵆','鵇', '鵈',0,'鵊',0,0,0,0,0, */
	/* 9d50 */  4, 4,-1, 6, 6,-1,-1,-1, -1, 4,-1,-1, 4, 4, 4, 6, /* '鵐','鵑',0,'鵓','鵔',0,0,0, 0,'鵙',0,0,'鵜','鵝','鵞','鵟', */
	/* 9d60 */  4, 4, 6, 6, 4, 6,-1,-1, -1, 6, 6, 6, 4,-1,-1, 4, /* '鵠','鵡','鵢','鵣','鵤','鵥',0,0, 0,'鵩','鵪','鵫','鵬',0,0,'鵯', */
	/* 9d70 */  6,-1, 4,-1,-1,-1, 6, 6, -1,-1, 4, 6, 6,-1, 6,-1, /* '鵰',0,'鵲',0,0,0,'鵶','鵷', 0,0,'鵺','鵻','鵼',0,'鵾',0, */
	/* 9d80 */ -1,-1,-1, 6, 6,-1, 6, 4, -1, 4, 6,-1,-1, 6, 6, 4, /* 0,0,0,'鶃','鶄',0,'鶆','鶇', 0,'鶉','鶊',0,0,'鶍','鶎','鶏', */
	/* 9d90 */ -1,-1, 6, 6,-1, 6, 6, 6,  6,-1, 4,-1,-1,-1,-1,-1, /* 0,0,'鶒','鶓',0,'鶕','鶖','鶗', '鶘',0,'鶚',0,0,0,0,0, */
	/* 9da0 */ -1, 6,-1,-1, 4,-1,-1,-1, -1, 4, 6, 4, 6,-1, 6, 4, /* 0,'鶡',0,0,'鶤',0,0,0, 0,'鶩','鶪','鶫','鶬',0,'鶮','鶯', */
	/* 9db0 */ -1, 6, 4,-1, 4, 6,-1,-1,  4, 6, 4, 4, 6,-1,-1, 6, /* 0,'鶱','鶲',0,'鶴','鶵',0,0, '鶸','鶹','鶺','鶻','鶼',0,0,'鶿', */
	/* 9dc0 */ -1, 4, 4, 6, 4,-1, 4, 6, -1, 6, 6,-1,-1,-1,-1, 4, /* 0,'鷁','鷂','鷃','鷄',0,'鷆','鷇', 0,'鷉','鷊',0,0,0,0,'鷏', */
	/* 9dd0 */ -1,-1,-1, 4, 6, 6, 6, 6, -1, 4, 6,-1,-1,-1, 6, 6, /* 0,0,0,'鷓','鷔','鷕','鷖','鷗', 0,'鷙','鷚',0,0,0,'鷞','鷟', */
	/* 9de0 */  6,-1,-1,-1,-1, 6, 4, 6, -1, 6,-1, 6,-1, 4, 6, 4, /* '鷠',0,0,0,0,'鷥','鷦','鷧', 0,'鷩',0,'鷫',0,'鷭','鷮','鷯', */
	/* 9df0 */  6,-1, 4, 6, 6,-1,-1,-1,  4, 4, 4,-1,-1, 4, 6,-1, /* '鷰',0,'鷲','鷳','鷴',0,0,0, '鷸','鷹','鷺',0,0,'鷽','鷾',0, */
	/* 9e00 */ -1,-1, 6,-1,-1,-1,-1, 6, -1,-1, 6,-1,-1,-1, 6,-1, /* 0,0,'鸂',0,0,0,0,'鸇', 0,0,'鸊',0,0,0,'鸎',0, */
	/* 9e10 */  6, 6, 6,-1,-1, 6, 6,-1, -1, 6, 4, 4, 6, 6, 4,-1, /* '鸐','鸑','鸒',0,0,'鸕','鸖',0, 0,'鸙','鸚','鸛','鸜','鸝','鸞',0, */
	/* 9e20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9e70 */ -1,-1,-1,-1,-1, 4,-1,-1,  4, 4, 6, 6, 6, 4,-1, 4, /* 0,0,0,0,0,'鹵',0,0, '鹸','鹹','鹺','鹻','鹼','鹽',0,'鹿', */
	/* 9e80 */  6, 4, 6, 6, 6, 6,-1, 6,  4,-1,-1, 4, 4,-1, 6, 6, /* '麀','麁','麂','麃','麄','麅',0,'麇', '麈',0,0,'麋','麌',0,'麎','麏', */
	/* 9e90 */ -1, 4, 4, 4,-1, 4, 6, 4,  6,-1,-1, 6,-1, 4, 6, 4, /* 0,'麑','麒','麓',0,'麕','麖','麗', '麘',0,0,'麛',0,'麝','麞','麟', */
	/* 9ea0 */ -1,-1,-1,-1, 6, 4, 4,-1,  6, 4, 4,-1, 6, 4, 6, 6, /* 0,0,0,0,'麤','麥','麦',0, '麨','麩','麪',0,'麬','麭','麮','麯', */
	/* 9eb0 */  6,-1,-1, 6, 6, 6,-1,-1,  4, 4, 4, 4, 4,-1, 4, 4, /* '麰',0,0,'麳','麴','麵',0,0, '麸','麹','麺','麻','麼',0,'麾','麿', */
	/* 9ec0 */ -1,-1,-1,-1, 4,-1, 6,-1,  6,-1,-1, 6, 4, 4, 4, 4, /* 0,0,0,0,'黄',0,'黆',0, '黈',0,0,'黋','黌','黍','黎','黏', */
	/* 9ed0 */  4, 6, 4,-1, 4, 6,-1,-1,  4, 4,-1, 4, 4, 4, 4, 6, /* '黐','黑','黒',0,'黔','黕',0,0, '默','黙',0,'黛','黜','黝','點','黟', */
	/* 9ee0 */  4,-1,-1,-1, 6, 4,-1, 6,  4,-1,-1,-1, 6, 6, 6, 4, /* '黠',0,0,0,'黤','黥',0,'黧', '黨',0,0,0,'黬','黭','黮','黯', */
	/* 9ef0 */  6, 6, 6,-1, 4, 6, 4, 4,  6, 4,-1, 4, 4, 4,-1, 6, /* '黰','黱','黲',0,'黴','黵','黶','黷', '黸','黹',0,'黻','黼','黽',0,'黿', */
	/* 9f00 */ -1,-1, 6, 6,-1,-1,-1, 4,  4, 6,-1,-1,-1,-1, 4, 6, /* 0,0,'鼂','鼃',0,0,0,'鼇', '鼈','鼉',0,0,0,0,'鼎','鼏', */
	/* 9f10 */  6, 6, 6, 4, 6, 4, 6, 6, -1, 6, 6, 6,-1,-1,-1, 6, /* '鼐','鼑','鼒','鼓','鼔','鼕','鼖','鼗', 0,'鼙','鼚','鼛',0,0,0,'鼟', */
	/* 9f20 */  4, 4, 6,-1,-1,-1, 6,-1, -1,-1, 6, 6, 4,-1,-1, 6, /* '鼠','鼡','鼢',0,0,0,'鼦',0, 0,0,'鼪','鼫','鼬',0,0,'鼯', */
	/* 9f30 */ -1, 6, 6,-1, 6,-1,-1, 6, -1, 6, 6, 4, 6, 6, 4, 6, /* 0,'鼱','鼲',0,'鼴',0,0,'鼷', 0,'鼹','鼺','鼻','鼼','鼽','鼾','鼿', */
	/* 9f40 */ -1, 6,-1, 6, 6, 6, 6, 6, -1,-1, 4, 4,-1,-1, 4, 4, /* 0,'齁',0,'齃','齄','齅','齆','齇', 0,0,'齊','齋',0,0,'齎','齏', */
	/* 9f50 */ -1,-1, 4, 6, 4, 6, 6, 6,  6,-1, 6,-1,-1, 6, 6, 4, /* 0,0,'齒','齓','齔','齕','齖','齗', '齘',0,'齚',0,0,'齝','齞','齟', */
	/* 9f60 */  4, 4, 4, 4,-1,-1, 4, 4,  6, 6, 4,-1, 4, 6, 6, 6, /* '齠','齡','齢','齣',0,0,'齦','齧', '齨','齩','齪',0,'齬','齭','齮','齯', */
	/* 9f70 */  6, 6, 4, 6,-1, 6, 4, 4, -1,-1, 6,-1,-1, 6,-1,-1, /* '齰','齱','齲','齳',0,'齵','齶','齷', 0,0,'齺',0,0,'齽',0,0, */
	/* 9f80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, 4,-1, 6, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'龍',0,'龏', */
	/* 9f90 */  6, 6, 6,-1, 6, 4, 6, 6, -1,-1,-1,-1, 4, 4, 6,-1, /* '龐','龑','龒',0,'龔','龕','龖','龗', 0,0,0,0,'龜','龝','龞',0, */
	/* 9fa0 */  4, 6, 6, 6,-1, 6,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '龠','龡','龢','龣',0,'龥',0,0, 0,0,0,0,0,0,0,0, */
	/* 9fb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9fe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* 9ff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* a9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aa90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aaa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aaf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ab90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* abf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ac90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ace0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* acf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ad90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ada0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* adb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* adc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* add0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ade0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* adf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ae90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aeb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* af90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* afe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* aff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* b9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ba90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* baa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* baf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bcf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bdf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* be90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* beb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bf90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bfe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* bff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* c9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ca90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* caa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* caf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ccf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cdf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ce90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ceb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ced0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cf90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cfe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* cff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* d9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* da90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* daa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* daf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* db90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dcf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ddf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* de90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* deb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ded0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* def0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* df90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dfe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* dff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e000 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e010 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e020 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e030 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e040 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e050 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e060 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e070 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e080 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e090 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e0a0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e0b0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e0c0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e0d0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e0e0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e0f0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e100 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e110 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e120 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e130 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e140 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e150 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e160 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e170 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e180 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e190 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e1a0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e1b0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e1c0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e1d0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e1e0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e1f0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e200 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e210 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e220 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e230 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e240 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e250 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e260 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e270 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e280 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e290 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e2a0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e2b0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e2c0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e2d0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e2e0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e2f0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e300 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e310 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e320 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e330 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e340 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e350 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e360 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e370 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e380 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e390 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '','','','','','','','', '','','','','','','','', */
	/* e3a0 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e3b0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e3c0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e3d0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e3e0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e3f0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e400 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e410 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e420 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e430 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e440 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e450 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e460 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e470 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e480 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e490 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e4a0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e4b0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e4c0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e4d0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e4e0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e4f0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e500 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e510 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e520 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e530 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e540 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e550 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e560 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e570 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e580 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e590 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e5a0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e5b0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e5c0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e5d0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e5e0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e5f0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e600 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e610 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e620 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e630 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e640 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e650 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e660 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e670 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e680 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e690 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e6a0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e6b0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e6c0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e6d0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e6e0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e6f0 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e700 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e710 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e720 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e730 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e740 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '','','','','','','','', '','','','','','','','', */
	/* e750 */  6, 6, 6, 6, 6, 6, 6, 6, -1,-1,-1,-1,-1,-1,-1,-1, /* '','','','','','','','', 0,0,0,0,0,0,0,0, */
	/* e760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* e9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ea90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eaa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ead0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eaf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ebf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ec90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ece0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ecf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ed90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ede0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* edf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ee90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eeb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ef90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* efe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* eff0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f000 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f010 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f020 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f030 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f040 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f050 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f060 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f070 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f080 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f090 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f0f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f100 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f110 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f120 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f130 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f140 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f150 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f160 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f170 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f180 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f190 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f1f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f200 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f210 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f220 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f230 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f240 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f250 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f260 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f270 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f280 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f290 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f2f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f300 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f310 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f320 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f330 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f340 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f350 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f360 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f370 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f380 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f390 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f3f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f400 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f410 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f420 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f430 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f440 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f450 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f460 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f470 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f480 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f490 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f4f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f500 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f510 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f520 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f530 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f540 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f550 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f560 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f570 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f580 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f590 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f5f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f600 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f610 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f620 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f630 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f640 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f650 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f660 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f670 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f680 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f690 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f6f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f700 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f710 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f720 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f730 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f740 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f750 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f760 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f770 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f780 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f790 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f7f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f800 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f810 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f820 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f830 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f840 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f850 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f860 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f870 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f880 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f890 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f8f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f900 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f910 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f920 */ -1,-1,-1,-1,-1,-1,-1,-1, -1, 6,-1,-1,-1,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,'朗',0,0,0,0,0,0, */
	/* f930 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f940 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f950 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f960 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f970 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f980 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f990 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9a0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9b0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9c0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9d0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1, 6,-1,-1,-1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'隆',0,0,0, */
	/* f9e0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* f9f0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1, 6, 6, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'﨎','﨏', */
	/* fa10 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6, 6, 6, /* '塚','﨑','晴','﨓','﨔','凞','猪','益', '礼','神','祥','福','靖','精','羽','﨟', */
	/* fa20 */  6, 6, 6, 6, 6, 6, 6, 6,  6, 6, 6, 6, 6, 6,-1,-1, /* '蘒','﨡','諸','﨣','﨤','逸','都','﨧', '﨨','﨩','飯','飼','館','鶴',0,0, */
	/* fa30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fa90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* faa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fab0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fac0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fad0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fae0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* faf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fb90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fba0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbe0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fbf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fc90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fca0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fce0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fcf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fd90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fda0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fde0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fdf0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe00 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe10 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe20 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe30 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe40 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe50 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe60 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe70 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe80 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fe90 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fea0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* feb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fec0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fed0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fee0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* fef0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ff00 */ -1, 4, 6, 4, 4, 4, 4, 6,  4, 4, 4, 4, 4, 4, 4, 4, /* 0,'！','＂','＃','＄','％','＆','＇', '（','）','＊','＋','，','－','．','／', */
	/* ff10 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '０','１','２','３','４','５','６','７', '８','９','：','；','＜','＝','＞','？', */
	/* ff20 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '＠','Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ', 'Ｈ','Ｉ','Ｊ','Ｋ','Ｌ','Ｍ','Ｎ','Ｏ', */
	/* ff30 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* 'Ｐ','Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ', 'Ｘ','Ｙ','Ｚ','［','＼','］','＾','＿', */
	/* ff40 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4, /* '｀','ａ','ｂ','ｃ','ｄ','ｅ','ｆ','ｇ', 'ｈ','ｉ','ｊ','ｋ','ｌ','ｍ','ｎ','ｏ', */
	/* ff50 */  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 6,-1, /* 'ｐ','ｑ','ｒ','ｓ','ｔ','ｕ','ｖ','ｗ', 'ｘ','ｙ','ｚ','｛','｜','｝','～',0, */
	/* ff60 */ -1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1, /* 0,'｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* ff70 */  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* ff80 */  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* ff90 */  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
	/* ffa0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffb0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffc0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffd0 */ -1,-1,-1,-1,-1,-1,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1,
	/* ffe0 */  4, 4, 4, 4,-1, 4,-1,-1, -1,-1,-1,-1,-1,-1,-1,-1, /* '￠','￡','￢','￣',0,'￥',0,0, 0,0,0,0,0,0,0,0, */
};

const size_t _unibe2jis50221_table_bits_size = sizeof(_unibe2jis50221_table_bits) / sizeof(_unibe2jis50221_table_bits[0]);

#endif /* #ifndef __UNIBE2JIS50221_TABLE_BITS_H_ */
