/*
 * _unibe2sjis2004_table.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef __UNIBE2SJIS2004_TABLE_H_
#define __UNIBE2SJIS2004_TABLE_H_

#include <stddef.h>
#include <stdint.h>

const uint16_t _unibe2sjis2004_table[] = {
	/* 0000 */ 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, 0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* '','','','','','','','', '','','','','','','','', */
	/* 0010 */ 0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, 0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* '','','','','','','','', '','','','','','','','', */
	/* 0020 */ 0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, 0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* ' ','!','"','#','$','%','&','\'', '(',')','*','+',',','-','.','/', */
	/* 0030 */ 0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, 0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* '0','1','2','3','4','5','6','7', '8','9',':',';','<','=','>','?', */
	/* 0040 */ 0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, 0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O', */
	/* 0050 */ 0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, 0x0058,0x0059,0x005a,0x005b,0x815f,0x005d,0x005e,0x005f, /* 'P','Q','R','S','T','U','V','W', 'X','Y','Z','[','\\',']','^','_', */
	/* 0060 */ 0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, 0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* '`','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o', */
	/* 0070 */ 0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, 0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x81b0,0x007f, /* 'p','q','r','s','t','u','v','w', 'x','y','z','{','|','}','~','', */
	/* 0080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 00a0 */ 0x8541,0x8542,0x8191,0x8192,0x8543,0x005c,0x8544,0x8198, 0x814e,0x8545,0x8546,0x8547,0x81ca,0x8548,0x8549,0x854a, /* ' ','¡','¢','£','¤','¥','¦','§', '¨','©','ª','«','¬','­','®','¯', */
	/* 00b0 */ 0x818b,0x817d,0x854b,0x854c,0x814c,0,0x81f7,0x854d, 0x854e,0x854f,0x8550,0x8551,0x8552,0x8553,0x8554,0x8555, /* '°','±','²','³','´',0,'¶','·', '¸','¹','º','»','¼','½','¾','¿', */
	/* 00c0 */ 0x8556,0x8557,0x8558,0x8559,0x855a,0x855b,0x855c,0x855d, 0x855e,0x855f,0x8560,0x8561,0x8562,0x8563,0x8564,0x8565, /* 'À','Á','Â','Ã','Ä','Å','Æ','Ç', 'È','É','Ê','Ë','Ì','Í','Î','Ï', */
	/* 00d0 */ 0x8566,0x8567,0x8568,0x8569,0x856a,0x856b,0x856c,0x817e, 0x856d,0x856e,0x856f,0x8570,0x8571,0x8572,0x8573,0x8574, /* 'Ð','Ñ','Ò','Ó','Ô','Õ','Ö','×', 'Ø','Ù','Ú','Û','Ü','Ý','Þ','ß', */
	/* 00e0 */ 0x8575,0x8576,0x8577,0x8578,0x8579,0x857a,0x857b,0x857c, 0x857d,0x857e,0x8580,0x8581,0x8582,0x8583,0x8584,0x8585, /* 'à','á','â','ã','ä','å','æ','ç', 'è','é','ê','ë','ì','í','î','ï', */
	/* 00f0 */ 0x8586,0x8587,0x8588,0x8589,0x858a,0x858b,0x858c,0x8180, 0x858d,0x858e,0x858f,0x8590,0x8591,0x8592,0x8593,0x8594, /* 'ð','ñ','ò','ó','ô','õ','ö','÷', 'ø','ù','ú','û','ü','ý','þ','ÿ', */
	/* 0100 */ 0x8595,0x859a,0x85b8,0x85c7,0x859f,0x85aa,0x85ba,0x85c9, 0x85d7,0x85dd,0,0,0x85bb,0x85ca,0x85be,0x85cd, /* 'Ā','ā','Ă','ă','Ą','ą','Ć','ć', 'Ĉ','ĉ',0,0,'Č','č','Ď','ď', */
	/* 0110 */ 0,0x85ce,0x8598,0x859d,0,0,0,0, 0x85bc,0x85cb,0x85bd,0x85cc,0x85d8,0x85de,0,0, /* 0,'đ','Ē','ē',0,0,0,0, 'Ę','ę','Ě','ě','Ĝ','ĝ',0,0, */
	/* 0120 */ 0,0,0,0,0x85d9,0x85df,0,0x85fb, 0,0,0x8596,0x859b,0,0,0,0, /* 0,0,0,0,'Ĥ','ĥ',0,'ħ', 0,0,'Ī','ī',0,0,0,0, */
	/* 0130 */ 0,0,0,0,0x85da,0x85e0,0,0, 0,0x85b9,0x85c8,0,0,0x85a2,0x85ad,0, /* 0,0,0,0,'Ĵ','ĵ',0,0, 0,'Ĺ','ĺ',0,0,'Ľ','ľ',0, */
	/* 0140 */ 0,0x85a1,0x85ac,0x85bf,0x85cf,0,0,0x85c0, 0x85d0,0,0,0x85f8,0x8599,0x859e,0,0, /* 0,'Ł','ł','Ń','ń',0,0,'Ň', 'ň',0,0,'ŋ','Ō','ō',0,0, */
	/* 0150 */ 0x85c1,0x85d1,0x864a,0x8649,0x85b7,0x85c6,0,0, 0x85c2,0x85d2,0x85a3,0x85ae,0x85db,0x85e1,0x85a5,0x85b1, /* 'Ő','ő','Œ','œ','Ŕ','ŕ',0,0, 'Ř','ř','Ś','ś','Ŝ','ŝ','Ş','ş', */
	/* 0160 */ 0x85a4,0x85b0,0x85c5,0x85d5,0x85a6,0x85b2,0,0, 0,0,0x8597,0x859c,0x85dc,0x85e2,0x85c3,0x85d3, /* 'Š','š','Ţ','ţ','Ť','ť',0,0, 0,0,'Ū','ū','Ŭ','ŭ','Ů','ů', */
	/* 0170 */ 0x85c4,0x85d4,0,0,0,0,0,0, 0,0x85a7,0x85b3,0x85a9,0x85b6,0x85a8,0x85b5,0, /* 'Ű','ű',0,0,0,0,0,0, 0,'Ź','ź','Ż','ż','Ž','ž',0, */
	/* 0180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0190 */ 0,0,0,0x8648,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'Ɠ',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 01a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01c0 */ 0,0,0x8643,0,0,0,0,0, 0,0,0,0,0,0x84ed,0x84ee,0, /* 0,0,'ǂ',0,0,0,0,0, 0,0,0,0,0,'Ǎ','ǎ',0, */
	/* 01d0 */ 0x84ef,0x84f4,0x84f5,0,0x84f6,0,0x84f7,0, 0x84f8,0,0x84f9,0,0x84fa,0,0,0, /* 'ǐ','Ǒ','ǒ',0,'ǔ',0,'ǖ',0, 'ǘ',0,'ǚ',0,'ǜ',0,0,0, */
	/* 01e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 01f0 */ 0,0,0,0,0,0,0,0, 0x84f2,0x84f3,0,0,0,0x8664,0,0, /* 0,0,0,0,0,0,0,0, 'Ǹ','ǹ',0,0,0,'ǽ',0,0, */
	/* 0200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0250 */ 0x8652,0x8658,0x8659,0x8644,0x8657,0x865e,0x85ec,0x8645, 0x864d,0x864f,0x8662,0,0x8650,0,0x8651,0x85f3, /* 'ɐ','ɑ','ɒ','ɓ','ɔ','ɕ','ɖ','ɗ', 'ɘ','ə','ɚ',0,'ɜ',0,'ɞ','ɟ', */
	/* 0260 */ 0x8647,0x85f7,0,0,0x8655,0x865b,0x8641,0x8661, 0x864b,0,0,0,0x85e8,0x85f2,0x85e9,0x8653, /* 'ɠ','ɡ',0,0,'ɤ','ɥ','ɦ','ɧ', 'ɨ',0,0,0,'ɬ','ɭ','ɮ','ɯ', */
	/* 0270 */ 0x85f9,0x85e3,0x85f4,0x85ed,0,0x864e,0,0, 0,0x85ea,0x8660,0x85f1,0,0x85ee,0x85e5,0, /* 'ɰ','ɱ','ɲ','ɳ',0,'ɵ',0,0, 0,'ɹ','ɺ','ɻ',0,'ɽ','ɾ',0, */
	/* 0280 */ 0,0x85fa,0x85ef,0x85e6,0x8646,0,0,0, 0x85eb,0x864c,0x8654,0x85e4,0x8656,0x865a,0x85f6,0, /* 0,'ʁ','ʂ','ʃ','ʄ',0,0,0, 'ʈ','ʉ','ʊ','ʋ','ʌ','ʍ','ʎ',0, */
	/* 0290 */ 0x85f0,0x865f,0x85e7,0,0x8640,0x85fc,0,0, 0x8642,0,0,0,0,0x85f5,0,0, /* 'ʐ','ʑ','ʒ',0,'ʔ','ʕ',0,0, 'ʘ',0,0,0,0,'ʝ',0,0, */
	/* 02a0 */ 0,0x865d,0x865c,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'ʡ','ʢ',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 02b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 02c0 */ 0,0,0,0,0,0,0,0x85af, 0x8672,0,0,0,0x8673,0,0,0, /* 0,0,0,0,0,0,0,'ˇ', 'ˈ',0,0,0,'ˌ',0,0,0, */
	/* 02d0 */ 0x8674,0x8675,0,0,0,0,0,0, 0x85a0,0x85d6,0,0x85ab,0,0x85b4,0x8691,0, /* 'ː','ˑ',0,0,0,0,0,0, '˘','˙',0,'˛',0,'˝','˞',0, */
	/* 02e0 */ 0,0,0,0,0,0x8680,0x8681,0x8682, 0x8683,0x8684,0,0,0,0,0,0, /* 0,0,0,0,0,'˥','˦','˧', '˨','˩',0,0,0,0,0,0, */
	/* 02f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0300 */ 0x867b,0x8679,0x867e,0x869d,0x867a,0,0x8676,0, 0x868d,0,0,0x8678,0x867d,0,0,0x867c, /* '̀','́','̂','̃','̄',0,'̆',0, '̈',0,0,'̋','̌',0,0,'̏', */
	/* 0310 */ 0,0,0,0,0,0,0,0, 0x8698,0x8699,0x869e,0,0x868a,0x8696,0x8697,0x868b, /* 0,0,0,0,0,0,0,0, '̘','̙','̚',0,'̜','̝','̞','̟', */
	/* 0320 */ 0x868c,0,0,0,0x8692,0x8687,0,0, 0,0x868f,0x869a,0,0x8688,0,0,0x8690, /* '̠',0,0,0,'̤','̥',0,0, 0,'̩','̪',0,'̬',0,0,'̯', */
	/* 0330 */ 0x8693,0,0,0,0x8695,0,0,0, 0,0x8689,0x869b,0x869c,0x8694,0x868e,0,0, /* '̰',0,0,0,'̴',0,0,0, 0,'̹','̺','̻','̼','̽',0,0, */
	/* 0340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0360 */ 0,0x8671,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'͡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0390 */ 0,0x839f,0x83a0,0x83a1,0x83a2,0x83a3,0x83a4,0x83a5, 0x83a6,0x83a7,0x83a8,0x83a9,0x83aa,0x83ab,0x83ac,0x83ad, /* 0,'Α','Β','Γ','Δ','Ε','Ζ','Η', 'Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο', */
	/* 03a0 */ 0x83ae,0x83af,0,0x83b0,0x83b1,0x83b2,0x83b3,0x83b4, 0x83b5,0x83b6,0,0,0,0,0,0, /* 'Π','Ρ',0,'Σ','Τ','Υ','Φ','Χ', 'Ψ','Ω',0,0,0,0,0,0, */
	/* 03b0 */ 0,0x83bf,0x83c0,0x83c1,0x83c2,0x83c3,0x83c4,0x83c5, 0x83c6,0x83c7,0x83c8,0x83c9,0x83ca,0x83cb,0x83cc,0x83cd, /* 0,'α','β','γ','δ','ε','ζ','η', 'θ','ι','κ','λ','μ','ν','ξ','ο', */
	/* 03c0 */ 0x83ce,0x83cf,0x83d7,0x83d0,0x83d1,0x83d2,0x83d3,0x83d4, 0x83d5,0x83d6,0,0,0,0,0,0, /* 'π','ρ','ς','σ','τ','υ','φ','χ', 'ψ','ω',0,0,0,0,0,0, */
	/* 03d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 03f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0400 */ 0,0x8446,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'Ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0410 */ 0x8440,0x8441,0x8442,0x8443,0x8444,0x8445,0x8447,0x8448, 0x8449,0x844a,0x844b,0x844c,0x844d,0x844e,0x844f,0x8450, /* 'А','Б','В','Г','Д','Е','Ж','З', 'И','Й','К','Л','М','Н','О','П', */
	/* 0420 */ 0x8451,0x8452,0x8453,0x8454,0x8455,0x8456,0x8457,0x8458, 0x8459,0x845a,0x845b,0x845c,0x845d,0x845e,0x845f,0x8460, /* 'Р','С','Т','У','Ф','Х','Ц','Ч', 'Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я', */
	/* 0430 */ 0x8470,0x8471,0x8472,0x8473,0x8474,0x8475,0x8477,0x8478, 0x8479,0x847a,0x847b,0x847c,0x847d,0x847e,0x8480,0x8481, /* 'а','б','в','г','д','е','ж','з', 'и','й','к','л','м','н','о','п', */
	/* 0440 */ 0x8482,0x8483,0x8484,0x8485,0x8486,0x8487,0x8488,0x8489, 0x848a,0x848b,0x848c,0x848d,0x848e,0x848f,0x8490,0x8491, /* 'р','с','т','у','ф','х','ц','ч', 'ш','щ','ъ','ы','ь','э','ю','я', */
	/* 0450 */ 0,0x8476,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'ё',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 0460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 04f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 05f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 06f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 07f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 08f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 09f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 0ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 10f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 11f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 12f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 13f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 14f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 15f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 16f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 17f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 18f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 19f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x84f0,0x84f1, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'Ḿ','ḿ', */
	/* 1e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f70 */ 0x8665,0x8666,0x866f,0x8670,0,0,0,0, 0,0,0,0,0,0,0,0, /* 'ὰ','ά','ὲ','έ',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 1f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 1ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2010 */ 0x815d,0,0,0x829c,0x815c,0,0x8161,0, 0x8165,0x8166,0,0,0x8167,0x8168,0,0, /* '‐',0,0,'–','—',0,'‖',0, '‘','’',0,0,'“','”',0,0, */
	/* 2020 */ 0x81f5,0x81f6,0x825f,0,0,0x8164,0x8163,0, 0,0,0,0,0,0,0,0, /* '†','‡','•',0,0,'‥','…',0, 0,0,0,0,0,0,0,0, */
	/* 2030 */ 0x81f1,0,0x818c,0x818d,0,0,0,0, 0,0,0,0x81a6,0x84e9,0,0x007e,0x8677, /* '‰',0,'′','″',0,0,0,0, 0,0,0,'※','‼',0,'‾','‿', */
	/* 2040 */ 0,0,0x86fc,0,0,0,0,0x84ea, 0x84eb,0x84ec,0,0,0,0,0,0, /* 0,0,'⁂',0,0,0,0,'⁇', '⁈','⁉',0,0,0,0,0,0, */
	/* 2050 */ 0,0x86fb,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'⁑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x8540,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'€',0,0,0, */
	/* 20b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 20f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2100 */ 0,0,0,0x818e,0,0,0,0, 0,0,0,0,0,0,0,0x827c, /* 0,0,0,'℃',0,0,0,0, 0,0,0,0,0,0,0,'ℏ', */
	/* 2110 */ 0,0,0,0x827e,0,0,0x8782,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'ℓ',0,0,'№',0, 0,0,0,0,0,0,0,0, */
	/* 2120 */ 0,0x8784,0,0,0,0,0,0x8280, 0,0,0,0x81f0,0,0,0,0, /* 0,'℡',0,0,0,0,0,'℧', 0,0,0,'Å',0,0,0,0, */
	/* 2130 */ 0,0,0,0,0,0x827b,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'ℵ',0,0, 0,0,0,0,0,0,0,0, */
	/* 2140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2150 */ 0,0,0,0x8498,0x8499,0x849a,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'⅓','⅔','⅕',0,0, 0,0,0,0,0,0,0,0, */
	/* 2160 */ 0x8754,0x8755,0x8756,0x8757,0x8758,0x8759,0x875a,0x875b, 0x875c,0x875d,0x875e,0x8776,0,0,0,0, /* 'Ⅰ','Ⅱ','Ⅲ','Ⅳ','Ⅴ','Ⅵ','Ⅶ','Ⅷ', 'Ⅸ','Ⅹ','Ⅺ','Ⅻ',0,0,0,0, */
	/* 2170 */ 0x86b3,0x86b4,0x86b5,0x86b6,0x86b7,0x86b8,0x86b9,0x86ba, 0x86bb,0x86bc,0x86bd,0x86be,0,0,0,0, /* 'ⅰ','ⅱ','ⅲ','ⅳ','ⅴ','ⅵ','ⅶ','ⅷ', 'ⅸ','ⅹ','ⅺ','ⅻ',0,0,0,0, */
	/* 2180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2190 */ 0x81a9,0x81aa,0x81a8,0x81ab,0x81ef,0,0x8246,0x8244, 0x8245,0x8247,0,0,0,0,0,0, /* '←','↑','→','↓','↔',0,'↖','↗', '↘','↙',0,0,0,0,0,0, */
	/* 21a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 21c0 */ 0,0,0,0,0x8248,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'⇄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21d0 */ 0,0,0x81cb,0,0x81cc,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'⇒',0,'⇔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 21e0 */ 0,0,0,0,0,0,0x824a,0x824b, 0x8249,0x824c,0,0,0,0,0,0, /* 0,0,0,0,0,0,'⇦','⇧', '⇨','⇩',0,0,0,0,0,0, */
	/* 21f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2200 */ 0x81cd,0,0x81dd,0x81ce,0,0x81c5,0,0x81de, 0x81b8,0x81c4,0,0x81b9,0,0,0,0, /* '∀',0,'∂','∃',0,'∅',0,'∇', '∈','∉',0,'∋',0,0,0,0, */
	/* 2210 */ 0,0,0x817c,0x827a,0,0,0,0, 0,0,0x81e3,0,0,0x81e5,0x8187,0x8798, /* 0,0,'−','∓',0,0,0,0, 0,0,'√',0,0,'∝','∞','∟', */
	/* 2220 */ 0x81da,0,0,0,0,0x81d2,0x81d3,0x81c8, 0x81c9,0x81bf,0x81be,0x81e7,0x81e8,0,0x8793,0, /* '∠',0,0,0,0,'∥','∦','∧', '∨','∩','∪','∫','∬',0,'∮',0, */
	/* 2230 */ 0,0,0,0,0x8188,0x81e6,0,0, 0,0,0,0,0,0x81e4,0,0, /* 0,0,0,0,'∴','∵',0,0, 0,0,0,0,0,'∽',0,0, */
	/* 2240 */ 0,0,0,0x81ea,0,0x81eb,0,0, 0x81ec,0,0,0,0,0,0,0, /* 0,0,0,'≃',0,'≅',0,0, '≈',0,0,0,0,0,0,0, */
	/* 2250 */ 0,0,0x81e0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'≒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2260 */ 0x8182,0x81df,0x81e9,0,0,0,0x8185,0x8186, 0,0,0x81e1,0x81e2,0,0,0,0, /* '≠','≡','≢',0,0,0,'≦','≧', 0,0,'≪','≫',0,0,0,0, */
	/* 2270 */ 0,0,0,0,0,0,0x81ed,0x81ee, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'≶','≷', 0,0,0,0,0,0,0,0, */
	/* 2280 */ 0,0,0x81bc,0x81bd,0x81c0,0x81c1,0x81ba,0x81bb, 0,0,0x81c2,0x81c3,0,0,0,0, /* 0,0,'⊂','⊃','⊄','⊅','⊆','⊇', 0,0,'⊊','⊋',0,0,0,0, */
	/* 2290 */ 0,0,0,0,0,0x81cf,0x81d0,0x81d1, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⊕','⊖','⊗', 0,0,0,0,0,0,0,0, */
	/* 22a0 */ 0,0,0,0,0,0x81db,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⊥',0,0, 0,0,0,0,0,0,0,0, */
	/* 22b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x8799, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'⊿', */
	/* 22c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22d0 */ 0,0,0,0,0,0,0,0, 0,0,0x8496,0x8497,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'⋚','⋛',0,0,0,0, */
	/* 22e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 22f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2300 */ 0,0,0,0,0,0x81c6,0x81c7,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'⌅','⌆',0, 0,0,0,0,0,0,0,0, */
	/* 2310 */ 0,0,0x81dc,0,0,0,0,0, 0x849c,0,0,0,0,0,0,0, /* 0,0,'⌒',0,0,0,0,0, '⌘',0,0,0,0,0,0,0, */
	/* 2320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x8461,0x8462, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'⎾','⎿', */
	/* 23c0 */ 0x8463,0x8464,0x8465,0x8466,0x8467,0x8468,0x8469,0x846a, 0x846b,0x846c,0x846d,0x846e,0x846f,0,0x849e,0, /* '⏀','⏁','⏂','⏃','⏄','⏅','⏆','⏇', '⏈','⏉','⏊','⏋','⏌',0,'⏎',0, */
	/* 23d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 23f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2420 */ 0,0,0,0x849d,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'␣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2460 */ 0x8740,0x8741,0x8742,0x8743,0x8744,0x8745,0x8746,0x8747, 0x8748,0x8749,0x874a,0x874b,0x874c,0x874d,0x874e,0x874f, /* '①','②','③','④','⑤','⑥','⑦','⑧', '⑨','⑩','⑪','⑫','⑬','⑭','⑮','⑯', */
	/* 2470 */ 0x8750,0x8751,0x8752,0x8753,0,0,0,0, 0,0,0,0,0,0,0,0, /* '⑰','⑱','⑲','⑳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 24d0 */ 0x86bf,0x86c0,0x86c1,0x86c2,0x86c3,0x86c4,0x86c5,0x86c6, 0x86c7,0x86c8,0x86c9,0x86ca,0x86cb,0x86cc,0x86cd,0x86ce, /* 'ⓐ','ⓑ','ⓒ','ⓓ','ⓔ','ⓕ','ⓖ','ⓗ', 'ⓘ','ⓙ','ⓚ','ⓛ','ⓜ','ⓝ','ⓞ','ⓟ', */
	/* 24e0 */ 0x86cf,0x86d0,0x86d1,0x86d2,0x86d3,0x86d4,0x86d5,0x86d6, 0x86d7,0x86d8,0,0x86a9,0x86aa,0x86ab,0x86ac,0x86ad, /* 'ⓠ','ⓡ','ⓢ','ⓣ','ⓤ','ⓥ','ⓦ','ⓧ', 'ⓨ','ⓩ',0,'⓫','⓬','⓭','⓮','⓯', */
	/* 24f0 */ 0x86ae,0x86af,0x86b0,0x86b1,0x86b2,0x83d8,0x83d9,0x83da, 0x83db,0x83dc,0x83dd,0x83de,0x83df,0x83e0,0x83e1,0, /* '⓰','⓱','⓲','⓳','⓴','⓵','⓶','⓷', '⓸','⓹','⓺','⓻','⓼','⓽','⓾',0, */
	/* 2500 */ 0x849f,0x84aa,0x84a0,0x84ab,0,0,0,0, 0,0,0,0,0x84a1,0,0,0x84ac, /* '─','━','│','┃',0,0,0,0, 0,0,0,0,'┌',0,0,'┏', */
	/* 2510 */ 0x84a2,0,0,0x84ad,0x84a4,0,0,0x84af, 0x84a3,0,0,0x84ae,0x84a5,0x84ba,0,0, /* '┐',0,0,'┓','└',0,0,'┗', '┘',0,0,'┛','├','┝',0,0, */
	/* 2520 */ 0x84b5,0,0,0x84b0,0x84a7,0x84bc,0,0, 0x84b7,0,0,0x84b2,0x84a6,0,0,0x84b6, /* '┠',0,0,'┣','┤','┥',0,0, '┨',0,0,'┫','┬',0,0,'┯', */
	/* 2530 */ 0x84bb,0,0,0x84b1,0x84a8,0,0,0x84b8, 0x84bd,0,0,0x84b3,0x84a9,0,0,0x84b9, /* '┰',0,0,'┳','┴',0,0,'┷', '┸',0,0,'┻','┼',0,0,'┿', */
	/* 2540 */ 0,0,0x84be,0,0,0,0,0, 0,0,0,0x84b4,0,0,0,0, /* 0,0,'╂',0,0,0,0,0, 0,0,0,'╋',0,0,0,0, */
	/* 2550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 25a0 */ 0x81a1,0x81a0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '■','□',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25b0 */ 0,0x83eb,0x81a3,0x81a2,0,0,0x8241,0x8240, 0,0,0,0,0x81a5,0x81a4,0,0, /* 0,'▱','▲','△',0,0,'▶','▷', 0,0,0,0,'▼','▽',0,0, */
	/* 25c0 */ 0x8243,0x8242,0,0,0,0,0x819f,0x819e, 0,0x825a,0,0x819b,0,0,0x819d,0x819c, /* '◀','◁',0,0,0,0,'◆','◇', 0,'◉',0,'○',0,0,'◎','●', */
	/* 25d0 */ 0x84e5,0x84e6,0x84e7,0x84e8,0,0,0,0, 0,0,0,0,0,0,0,0, /* '◐','◑','◒','◓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 25e0 */ 0,0,0,0,0,0,0x825e,0, 0,0,0,0,0,0,0,0x81fc, /* 0,0,0,0,0,0,'◦',0, 0,0,0,0,0,0,0,'◯', */
	/* 25f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2600 */ 0x83e6,0x83e7,0x83e8,0x83e9,0,0x819a,0x8199,0, 0,0,0,0,0,0,0x83e5,0, /* '☀','☁','☂','☃',0,'★','☆',0, 0,0,0,0,0,0,'☎',0, */
	/* 2610 */ 0,0,0,0,0,0,0x83e2,0x83e3, 0,0,0,0,0,0,0x879e,0, /* 0,0,0,0,0,0,'☖','☗', 0,0,0,0,0,0,'☞',0, */
	/* 2620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2640 */ 0x818a,0,0x8189,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '♀',0,'♂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2660 */ 0x83b8,0x83bb,0x83b9,0x83be,0x83b7,0x83bc,0x83ba,0x83bd, 0x83ea,0x81fb,0x81f4,0x81f9,0x81fa,0x81f3,0x81f8,0x81f2, /* '♠','♡','♢','♣','♤','♥','♦','♧', '♨','♩','♪','♫','♬','♭','♮','♯', */
	/* 2670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 26f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2710 */ 0,0,0,0x849b,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'✓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 2720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2750 */ 0,0,0,0,0,0,0x879d,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'❖',0, 0,0,0,0,0,0,0,0, */
	/* 2760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2770 */ 0,0,0,0,0,0,0x869f,0x86a0, 0x86a1,0x86a2,0x86a3,0x86a4,0x86a5,0x86a6,0x86a7,0x86a8, /* 0,0,0,0,0,0,'❶','❷', '❸','❹','❺','❻','❼','❽','❾','❿', */
	/* 2780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 27f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 28f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2930 */ 0,0,0,0,0x824d,0x824e,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'⤴','⤵',0,0, 0,0,0,0,0,0,0,0, */
	/* 2940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x8259, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'⦿', */
	/* 29c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 29f0 */ 0,0,0,0,0,0,0,0, 0,0,0x829d,0x829e,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'⧺','⧻',0,0,0,0, */
	/* 2a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2e90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 2ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3000 */ 0x8140,0x8141,0x8142,0x8156,0,0x8158,0x8159,0x815a, 0x8171,0x8172,0x8173,0x8174,0x8175,0x8176,0x8177,0x8178, /* '　','、','。','〃',0,'々','〆','〇', '〈','〉','《','》','「','」','『','』', */
	/* 3010 */ 0x8179,0x817a,0x81a7,0x81ac,0x816b,0x816c,0x81d8,0x81d9, 0x81d6,0x81d7,0,0,0x8160,0x8780,0,0x8781, /* '【','】','〒','〓','〔','〕','〖','〗', '〘','〙',0,0,'〜','〝',0,'〟', */
	/* 3020 */ 0x83e4,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '〠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3030 */ 0,0,0,0x81b1,0x81b2,0x81b3,0,0, 0,0,0,0x81b4,0x81b5,0x825b,0,0, /* 0,0,0,'〳','〴','〵',0,0, 0,0,0,'〻','〼','〽',0,0, */
	/* 3040 */ 0,0x829f,0x82a0,0x82a1,0x82a2,0x82a3,0x82a4,0x82a5, 0x82a6,0x82a7,0x82a8,0x82a9,0x82aa,0x82ab,0x82ac,0x82ad, /* 0,'ぁ','あ','ぃ','い','ぅ','う','ぇ', 'え','ぉ','お','か','が','き','ぎ','く', */
	/* 3050 */ 0x82ae,0x82af,0x82b0,0x82b1,0x82b2,0x82b3,0x82b4,0x82b5, 0x82b6,0x82b7,0x82b8,0x82b9,0x82ba,0x82bb,0x82bc,0x82bd, /* 'ぐ','け','げ','こ','ご','さ','ざ','し', 'じ','す','ず','せ','ぜ','そ','ぞ','た', */
	/* 3060 */ 0x82be,0x82bf,0x82c0,0x82c1,0x82c2,0x82c3,0x82c4,0x82c5, 0x82c6,0x82c7,0x82c8,0x82c9,0x82ca,0x82cb,0x82cc,0x82cd, /* 'だ','ち','ぢ','っ','つ','づ','て','で', 'と','ど','な','に','ぬ','ね','の','は', */
	/* 3070 */ 0x82ce,0x82cf,0x82d0,0x82d1,0x82d2,0x82d3,0x82d4,0x82d5, 0x82d6,0x82d7,0x82d8,0x82d9,0x82da,0x82db,0x82dc,0x82dd, /* 'ば','ぱ','ひ','び','ぴ','ふ','ぶ','ぷ', 'へ','べ','ぺ','ほ','ぼ','ぽ','ま','み', */
	/* 3080 */ 0x82de,0x82df,0x82e0,0x82e1,0x82e2,0x82e3,0x82e4,0x82e5, 0x82e6,0x82e7,0x82e8,0x82e9,0x82ea,0x82eb,0x82ec,0x82ed, /* 'む','め','も','ゃ','や','ゅ','ゆ','ょ', 'よ','ら','り','る','れ','ろ','ゎ','わ', */
	/* 3090 */ 0x82ee,0x82ef,0x82f0,0x82f1,0x82f2,0x82f3,0x82f4,0, 0,0,0,0x814a,0x814b,0x8154,0x8155,0x81b7, /* 'ゐ','ゑ','を','ん','ゔ','ゕ','ゖ',0, 0,0,0,'゛','゜','ゝ','ゞ','ゟ', */
	/* 30a0 */ 0x829b,0x8340,0x8341,0x8342,0x8343,0x8344,0x8345,0x8346, 0x8347,0x8348,0x8349,0x834a,0x834b,0x834c,0x834d,0x834e, /* '゠','ァ','ア','ィ','イ','ゥ','ウ','ェ', 'エ','ォ','オ','カ','ガ','キ','ギ','ク', */
	/* 30b0 */ 0x834f,0x8350,0x8351,0x8352,0x8353,0x8354,0x8355,0x8356, 0x8357,0x8358,0x8359,0x835a,0x835b,0x835c,0x835d,0x835e, /* 'グ','ケ','ゲ','コ','ゴ','サ','ザ','シ', 'ジ','ス','ズ','セ','ゼ','ソ','ゾ','タ', */
	/* 30c0 */ 0x835f,0x8360,0x8361,0x8362,0x8363,0x8364,0x8365,0x8366, 0x8367,0x8368,0x8369,0x836a,0x836b,0x836c,0x836d,0x836e, /* 'ダ','チ','ヂ','ッ','ツ','ヅ','テ','デ', 'ト','ド','ナ','ニ','ヌ','ネ','ノ','ハ', */
	/* 30d0 */ 0x836f,0x8370,0x8371,0x8372,0x8373,0x8374,0x8375,0x8376, 0x8377,0x8378,0x8379,0x837a,0x837b,0x837c,0x837d,0x837e, /* 'バ','パ','ヒ','ビ','ピ','フ','ブ','プ', 'ヘ','ベ','ペ','ホ','ボ','ポ','マ','ミ', */
	/* 30e0 */ 0x8380,0x8381,0x8382,0x8383,0x8384,0x8385,0x8386,0x8387, 0x8388,0x8389,0x838a,0x838b,0x838c,0x838d,0x838e,0x838f, /* 'ム','メ','モ','ャ','ヤ','ュ','ユ','ョ', 'ヨ','ラ','リ','ル','レ','ロ','ヮ','ワ', */
	/* 30f0 */ 0x8390,0x8391,0x8392,0x8393,0x8394,0x8395,0x8396,0x8492, 0x8493,0x8494,0x8495,0x8145,0x815b,0x8152,0x8153,0x81b6, /* 'ヰ','ヱ','ヲ','ン','ヴ','ヵ','ヶ','ヷ', 'ヸ','ヹ','ヺ','・','ー','ヽ','ヾ','ヿ', */
	/* 3100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 31f0 */ 0x83ec,0x83ed,0x83ee,0x83ef,0x83f0,0x83f1,0x83f2,0x83f3, 0x83f4,0x83f5,0x83f7,0x83f8,0x83f9,0x83fa,0x83fb,0x83fc, /* 'ㇰ','ㇱ','ㇲ','ㇳ','ㇴ','ㇵ','ㇶ','ㇷ', 'ㇸ','ㇹ','ㇺ','ㇻ','ㇼ','ㇽ','ㇾ','ㇿ', */
	/* 3200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3230 */ 0,0x878a,0x878b,0,0,0,0,0, 0,0x878c,0,0,0,0,0,0, /* 0,'㈱','㈲',0,0,0,0,0, 0,'㈹',0,0,0,0,0,0, */
	/* 3240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3250 */ 0,0x84bf,0x84c0,0x84c1,0x84c2,0x84c3,0x84c4,0x84c5, 0x84c6,0x84c7,0x84c8,0x84c9,0x84ca,0x84cb,0x84cc,0x84cd, /* 0,'㉑','㉒','㉓','㉔','㉕','㉖','㉗', '㉘','㉙','㉚','㉛','㉜','㉝','㉞','㉟', */
	/* 3260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32a0 */ 0,0,0,0,0x8785,0x8786,0x8787,0x8788, 0x8789,0,0,0,0,0,0,0, /* 0,0,0,0,'㊤','㊥','㊦','㊧', '㊨',0,0,0,0,0,0,0, */
	/* 32b0 */ 0,0x84ce,0x84cf,0x84d0,0x84d1,0x84d2,0x84d3,0x84d4, 0x84d5,0x84d6,0x84d7,0x84d8,0x84d9,0x84da,0x84db,0x84dc, /* 0,'㊱','㊲','㊳','㊴','㊵','㊶','㊷', '㊸','㊹','㊺','㊻','㊼','㊽','㊾','㊿', */
	/* 32c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 32d0 */ 0x86d9,0x86da,0x86db,0x86dc,0x86dd,0x86de,0x86df,0x86e0, 0x86e1,0x86e2,0x86e3,0x86e4,0x86e5,0x86e6,0x86e7,0x86e8, /* '㋐','㋑','㋒','㋓','㋔','㋕','㋖','㋗', '㋘','㋙','㋚','㋛','㋜','㋝','㋞','㋟', */
	/* 32e0 */ 0x86e9,0x86ea,0x86eb,0x86ec,0,0x86ef,0,0, 0,0x86ee,0,0,0x86f1,0x86f0,0,0, /* '㋠','㋡','㋢','㋣',0,'㋥',0,0, 0,'㋩',0,0,'㋬','㋭',0,0, */
	/* 32f0 */ 0,0,0,0,0,0,0,0, 0,0,0x86ed,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㋺',0,0,0,0,0, */
	/* 3300 */ 0,0,0,0x8765,0,0,0,0, 0,0,0,0,0,0x8769,0,0, /* 0,0,0,'㌃',0,0,0,0, 0,0,0,0,0,'㌍',0,0, */
	/* 3310 */ 0,0,0,0,0x8760,0,0,0, 0x8763,0,0,0,0,0,0,0, /* 0,0,0,0,'㌔',0,0,0, '㌘',0,0,0,0,0,0,0, */
	/* 3320 */ 0,0,0x8761,0x876b,0,0,0x876a,0x8764, 0,0,0,0x876c,0,0,0,0, /* 0,0,'㌢','㌣',0,0,'㌦','㌧', 0,0,0,'㌫',0,0,0,0, */
	/* 3330 */ 0,0,0,0,0,0,0x8766,0, 0,0,0,0x876e,0,0,0,0, /* 0,0,0,0,0,0,'㌶',0, 0,0,0,'㌻',0,0,0,0, */
	/* 3340 */ 0,0,0,0,0,0,0,0, 0,0x875f,0x876d,0,0,0x8762,0,0, /* 0,0,0,0,0,0,0,0, 0,'㍉','㍊',0,0,'㍍',0,0, */
	/* 3350 */ 0,0x8767,0,0,0,0,0,0x8768, 0,0,0,0,0,0,0,0, /* 0,'㍑',0,0,0,0,0,'㍗', 0,0,0,0,0,0,0,0, */
	/* 3360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3370 */ 0,0,0,0,0,0,0,0, 0,0,0,0x877e,0x878f,0x878e,0x878d,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'㍻','㍼','㍽','㍾',0, */
	/* 3380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0x8772,0x8773, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㎎','㎏', */
	/* 3390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x876f,0x8770,0x8771,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㎜','㎝','㎞',0, */
	/* 33a0 */ 0,0x8775,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'㎡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 33b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33c0 */ 0,0,0,0,0x8774,0,0,0, 0,0,0,0x827d,0,0x8783,0,0, /* 0,0,0,0,'㏄',0,0,0, 0,0,0,'㏋',0,'㏍',0,0, */
	/* 33d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 33f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3400 */ 0,0,0x87a1,0,0,0,0xf04c,0, 0,0,0,0,0,0,0,0, /* 0,0,'㐂',0,0,0,'㐆',0, 0,0,0,0,0,0,0,0, */
	/* 3410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xf051,0,0xf052,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㐬',0,'㐮',0, */
	/* 3430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3460 */ 0,0,0,0,0,0,0,0, 0xf07d,0,0xf075,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '㑨',0,'㑪',0,0,0,0,0, */
	/* 3470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3490 */ 0,0,0xf09e,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'㒒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 34a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34b0 */ 0,0,0,0,0,0x87d1,0,0, 0,0,0,0,0xf14a,0,0,0, /* 0,0,0,0,0,'㒵',0,0, 0,0,0,0,'㒼',0,0,0, */
	/* 34c0 */ 0,0xf7e6,0,0,0,0,0,0xf14e, 0,0,0,0,0,0,0,0, /* 0,'㓁',0,0,0,0,0,'㓇', 0,0,0,0,0,0,0,0, */
	/* 34d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x87d9,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'㓛',0,0,0,0, */
	/* 34e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 34f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xf167, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㔟', */
	/* 3520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xf17c,0xf17d,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'㕝','㕞',0, */
	/* 3560 */ 0,0,0,0xf181,0,0,0,0, 0,0,0,0,0,0,0xf187,0, /* 0,0,0,'㕣',0,0,0,0, 0,0,0,0,0,0,'㕮',0, */
	/* 3570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35a0 */ 0,0,0,0,0,0,0xf1a1,0, 0xf1a4,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㖦',0, '㖨',0,0,0,0,0,0,0, */
	/* 35b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35c0 */ 0,0,0,0,0,0xf1ad,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'㗅',0,0, 0,0,0,0,0,0,0,0, */
	/* 35d0 */ 0,0,0,0,0,0,0,0, 0,0,0xf1b6,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㗚',0,0,0,0,0, */
	/* 35e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 35f0 */ 0,0,0,0,0xf1c0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㗴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3600 */ 0,0,0,0,0,0xf1c8,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'㘅',0,0, 0,0,0,0,0,0,0,0, */
	/* 3610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3640 */ 0,0,0,0,0,0,0,0, 0,0,0xf1f7,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㙊',0,0,0,0,0, */
	/* 3650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3690 */ 0,0xf25e,0,0,0,0,0xf262,0, 0,0xf260,0,0,0,0,0,0, /* 0,'㚑',0,0,0,0,'㚖',0, 0,'㚙',0,0,0,0,0,0, */
	/* 36a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xf276, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㛏', */
	/* 36d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 36f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3760 */ 0,0xf0a1,0xf0a3,0,0,0,0,0, 0,0,0,0xf0a7,0xf0a6,0,0,0, /* 0,'㝡','㝢',0,0,0,0,0, 0,0,0,'㝫','㝬',0,0,0, */
	/* 3770 */ 0,0,0,0,0,0xf0aa,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'㝵',0,0, 0,0,0,0,0,0,0,0, */
	/* 3780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x987e,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'㞍',0,0, */
	/* 3790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37c0 */ 0,0xf0bc,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'㟁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 37d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 37e0 */ 0,0,0x988f,0,0,0,0,0, 0xf0d4,0,0,0,0,0,0,0, /* 0,0,'㟢',0,0,0,0,0, '㟨',0,0,0,0,0,0,0, */
	/* 37f0 */ 0,0,0,0,0xf0d7,0,0,0, 0,0,0,0,0,0xf0da,0,0, /* 0,0,0,0,'㟴',0,0,0, 0,0,0,0,0,'㟽',0,0, */
	/* 3800 */ 0xf0dc,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '㠀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xf0ed, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㠯', */
	/* 3830 */ 0,0,0,0,0,0,0xf0ef,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㠶',0, 0,0,0,0,0,0,0,0, */
	/* 3840 */ 0xf0f2,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '㡀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xf0f7,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'㡜',0,0,0, */
	/* 3860 */ 0,0xf0f9,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'㡡',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 38f0 */ 0,0,0,0,0,0,0,0, 0,0,0xf2b9,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㣺',0,0,0,0,0, */
	/* 3900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3910 */ 0,0,0,0,0,0,0,0xf2c4, 0,0,0xf2c8,0,0,0,0,0, /* 0,0,0,0,0,0,0,'㤗', 0,0,'㤚',0,0,0,0,0, */
	/* 3920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xf2de, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㥯', */
	/* 3970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 39f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xf37a,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㩮',0, */
	/* 3a70 */ 0,0,0,0xf37e,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'㩳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ad0 */ 0,0,0,0,0,0,0xf391,0xf3b4, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㫖','㫗', 0,0,0,0,0,0,0,0, */
	/* 3ae0 */ 0,0,0,0,0,0,0,0, 0,0,0xf39c,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㫪',0,0,0,0,0, */
	/* 3af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xf3ac,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㬎',0, */
	/* 3b10 */ 0,0,0,0,0,0,0,0, 0,0,0xf3b0,0,0xf3b2,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㬚',0,'㬜',0,0,0, */
	/* 3b20 */ 0,0,0xeb68,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'㬢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xf3eb,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'㭭',0,0, */
	/* 3b70 */ 0,0,0,0,0,0,0,0xf3e3, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'㭷', 0,0,0,0,0,0,0,0, */
	/* 3b80 */ 0,0,0,0,0,0,0,0xf447, 0xf448,0,0,0,0,0xf44b,0,0, /* 0,0,0,0,0,0,0,'㮇', '㮈',0,0,0,0,'㮍',0,0, */
	/* 3b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ba0 */ 0,0,0,0,0xf453,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㮤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3bb0 */ 0,0,0,0,0,0,0xeb9e,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㮶',0, 0,0,0,0,0,0,0,0, */
	/* 3bc0 */ 0,0,0,0xeb9f,0,0,0,0, 0,0,0,0,0,0xf467,0,0, /* 0,0,0,'㯃',0,0,0,0, 0,0,0,0,0,'㯍',0,0, */
	/* 3bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3bf0 */ 0xf47c,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '㯰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xebb8, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㰏', */
	/* 3c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c20 */ 0,0,0,0,0,0,0xf497,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'㰦',0, 0,0,0,0,0,0,0,0, */
	/* 3c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cc0 */ 0,0,0,0xf4b9,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'㳃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3cd0 */ 0,0,0xf4c0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'㳒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d10 */ 0,0xf4ef,0,0,0,0,0,0, 0,0,0,0,0,0,0xf4fc,0, /* 0,'㴑',0,0,0,0,0,0, 0,0,0,0,0,0,'㴞',0, */
	/* 3d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d60 */ 0,0,0,0,0xf55f,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㵤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3d70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3d90 */ 0,0,0,0,0,0,0,0, 0,0,0xf573,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'㶚',0,0,0,0,0, */
	/* 3da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3dc0 */ 0xf590,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '㷀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3dd0 */ 0,0,0,0,0xf597,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㷔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e00 */ 0,0,0,0,0,0xf5a6,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'㸅',0,0, 0,0,0,0,0,0,0,0, */
	/* 3e10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xec86, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'㸿', */
	/* 3e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e60 */ 0xf5bd,0,0,0,0,0,0xf5bf,0, 0xf5c0,0,0,0,0,0,0,0, /* '㹠',0,0,0,0,0,'㹦',0, '㹨',0,0,0,0,0,0,0, */
	/* 3e70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3e80 */ 0,0,0,0xf5c7,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'㺃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3e90 */ 0,0,0,0,0xf5ce,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'㺔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 3ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f50 */ 0,0,0,0,0,0,0,0xf653, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'㽗', 0,0,0,0,0,0,0,0, */
	/* 3f60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f70 */ 0,0,0xeccb,0,0,0xf665,0,0xf667, 0,0,0,0,0,0,0,0, /* 0,0,'㽲',0,0,'㽵',0,'㽷', 0,0,0,0,0,0,0,0, */
	/* 3f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xf67b,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'㾮',0, */
	/* 3fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3fc0 */ 0,0,0,0,0,0,0,0, 0,0xf687,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'㿉',0,0,0,0,0,0, */
	/* 3fd0 */ 0,0,0,0,0,0,0,0xf68c, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'㿗', 0,0,0,0,0,0,0,0, */
	/* 3fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 3ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4030 */ 0,0,0,0,0,0,0,0, 0,0xf6a0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'䀹',0,0,0,0,0,0, */
	/* 4040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4050 */ 0,0,0,0,0,0,0,0, 0xf6ab,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '䁘',0,0,0,0,0,0,0, */
	/* 4060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4090 */ 0,0,0,0xf6b7,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䂓',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 40a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 40f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4100 */ 0,0,0,0,0,0xf6e2,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'䄅',0,0, 0,0,0,0,0,0,0,0, */
	/* 4110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4140 */ 0,0,0,0,0,0,0,0, 0xf6f2,0,0,0,0,0,0,0xf6f5, /* 0,0,0,0,0,0,0,0, '䅈',0,0,0,0,0,0,'䅏', */
	/* 4150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4160 */ 0,0,0,0xf6fb,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䅣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41b0 */ 0,0,0,0,0xf752,0,0,0, 0,0,0,0,0,0,0,0xf756, /* 0,0,0,0,'䆴',0,0,0, 0,0,0,0,0,0,0,'䆿', */
	/* 41c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 41e0 */ 0,0,0,0,0,0,0xf766,0, 0,0,0,0,0,0,0xf76a,0, /* 0,0,0,0,0,0,'䇦',0, 0,0,0,0,0,0,'䇮',0, */
	/* 41f0 */ 0,0,0,0xf767,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䇳',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4200 */ 0,0,0,0,0,0,0,0xf772, 0,0,0,0,0,0,0xf776,0, /* 0,0,0,0,0,0,0,'䈇', 0,0,0,0,0,0,'䈎',0, */
	/* 4210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4260 */ 0,0,0,0,0xed8d,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䉤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42c0 */ 0,0,0,0,0,0,0xf7a9,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'䋆',0, 0,0,0,0,0,0,0,0, */
	/* 42d0 */ 0,0,0,0,0,0,0xf7b4,0, 0,0,0,0,0,0xf7b9,0,0, /* 0,0,0,0,0,0,'䋖',0, 0,0,0,0,0,'䋝',0,0, */
	/* 42e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 42f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4300 */ 0,0,0xf7cc,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'䌂',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4320 */ 0,0,0,0,0,0,0,0, 0,0,0,0xf7db,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'䌫',0,0,0,0, */
	/* 4330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4340 */ 0,0,0,0xf7df,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䍃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 43e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0xf85d,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,'䏮',0, */
	/* 43f0 */ 0xf861,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '䏰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4400 */ 0,0,0,0,0,0,0,0, 0xf867,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '䐈',0,0,0,0,0,0,0, */
	/* 4410 */ 0,0,0,0,0,0,0,0xf869, 0,0,0,0,0xf86b,0,0,0, /* 0,0,0,0,0,0,0,'䐗', 0,0,0,0,'䐜',0,0,0, */
	/* 4420 */ 0,0,0xf86e,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'䐢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4450 */ 0,0,0,0xedd7,0,0,0,0, 0,0,0,0xedd8,0,0,0,0, /* 0,0,0,'䑓',0,0,0,0, 0,0,0,'䑛',0,0,0,0, */
	/* 4460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4470 */ 0,0,0,0,0,0,0xf88c,0, 0,0,0xf88e,0,0,0,0,0, /* 0,0,0,0,0,0,'䑶',0, 0,0,'䑺',0,0,0,0,0, */
	/* 4480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4490 */ 0,0xf897,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'䒑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 44a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44b0 */ 0,0,0,0xf8b3,0,0,0,0, 0,0,0,0,0,0,0xf8b0,0, /* 0,0,0,'䒳',0,0,0,0, 0,0,0,0,0,0,'䒾',0, */
	/* 44c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44d0 */ 0,0,0,0,0xf8b2,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䓔',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 44e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 44f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4500 */ 0,0,0,0,0,0,0,0, 0xf8d7,0,0,0,0,0xf8d2,0,0, /* 0,0,0,0,0,0,0,0, '䔈',0,0,0,0,'䔍',0,0, */
	/* 4510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4520 */ 0,0,0,0,0,0xf8eb,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'䔥',0,0, 0,0,0,0,0,0,0,0, */
	/* 4530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4540 */ 0,0,0,0xf8ec,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'䕃',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xee70,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'䖝',0,0, */
	/* 45a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45b0 */ 0,0,0,0,0,0,0,0, 0xf96e,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '䖸',0,0,0,0,0,0,0, */
	/* 45c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 45e0 */ 0,0,0,0,0,0xf98c,0,0, 0,0,0xee80,0,0,0,0,0, /* 0,0,0,0,0,'䗥',0,0, 0,0,'䗪',0,0,0,0,0, */
	/* 45f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xf9a2, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'䘏', */
	/* 4610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4640 */ 0,0xf9b8,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'䙁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4660 */ 0,0,0,0,0,0xf9c1,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'䙥',0,0, 0,0,0,0,0,0,0,0, */
	/* 4670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46a0 */ 0,0xf9cc,0,0,0,0,0,0, 0,0,0,0,0,0,0,0xf9d1, /* 0,'䚡',0,0,0,0,0,0, 0,0,0,0,0,0,0,'䚯', */
	/* 46b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 46f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xf9e9,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'䜌',0,0,0, */
	/* 4710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4760 */ 0,0,0,0,0xfa48,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䝤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 47f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xfa5e,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'䟽',0,0, */
	/* 4800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4810 */ 0,0,0,0,0,0,0xfa68,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'䠖',0, 0,0,0,0,0,0,0,0, */
	/* 4820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4840 */ 0,0,0,0,0xeec9,0,0,0, 0,0,0,0,0,0,0xfa7b,0, /* 0,0,0,0,'䡄',0,0,0, 0,0,0,0,0,0,'䡎',0, */
	/* 4850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48b0 */ 0,0,0,0,0,0xfaa5,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'䢵',0,0, 0,0,0,0,0,0,0,0, */
	/* 48c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 48f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49b0 */ 0xef77,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '䦰',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 49c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 49e0 */ 0,0,0,0,0,0,0,0xfb8a, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'䧧', 0,0,0,0,0,0,0,0, */
	/* 49f0 */ 0,0,0,0,0,0,0,0, 0,0,0xfb90,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,'䧺',0,0,0,0,0, */
	/* 4a00 */ 0,0,0,0,0xfb95,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䨄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4a10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a20 */ 0,0,0,0,0,0,0,0, 0,0xfb98,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'䨩',0,0,0,0,0,0, */
	/* 4a30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4aa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0xfbb5,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'䪼',0,0,0, */
	/* 4ac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4af0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b30 */ 0,0,0,0,0,0,0,0, 0,0,0,0xfbd3,0,0,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'䬻',0,0,0,0, */
	/* 4b40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4b90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4bc0 */ 0,0,0xfc45,0,0,0,0,0, 0,0,0xfc47,0,0,0,0,0, /* 0,0,'䯂',0,0,0,0,0, 0,0,'䯊',0,0,0,0,0, */
	/* 4bd0 */ 0,0,0xfc49,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'䯒',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4be0 */ 0,0,0,0,0,0,0,0, 0xfc50,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '䯨',0,0,0,0,0,0,0, */
	/* 4bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c10 */ 0,0,0,0,0,0,0,0xefbc, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'䰗', 0,0,0,0,0,0,0,0, */
	/* 4c20 */ 0xfc5e,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '䰠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4c30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cc0 */ 0,0,0,0,0xfca8,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,'䳄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4cd0 */ 0,0xfcab,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'䳑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 4ce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4cf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d00 */ 0,0,0,0,0,0,0,0xfcc9, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'䴇', 0,0,0,0,0,0,0,0, */
	/* 4d10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d70 */ 0,0,0,0,0,0,0,0xfcde, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'䵷', 0,0,0,0,0,0,0,0, */
	/* 4d80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4d90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4da0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4db0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4dd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4de0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4df0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 4e00 */ 0x88ea,0x929a,0xf041,0x8eb5,0,0,0,0x969c, 0x8fe4,0x8e4f,0x8fe3,0x89ba,0,0x9573,0x975e,0xf042, /* '一','丁','丂','七',0,0,0,'万', '丈','三','上','下',0,'不','与','丏', */
	/* 4e10 */ 0x98a0,0x894e,0xf043,0,0x8a8e,0x98a1,0x90a2,0x99c0, 0x8b75,0x95b8,0,0,0,0,0x8fe5,0, /* '丐','丑','丒',0,'且','丕','世','丗', '丘','丙',0,0,0,0,'丞',0, */
	/* 4e20 */ 0,0x97bc,0,0,0,0,0x95c0,0, 0x87a2,0xf044,0x98a2,0xf045,0xf5ac,0x9286,0xf046,0x87a3, /* 0,'両',0,0,0,0,'並',0, '丨','丩','个','丫','丬','中','丮','丯', */
	/* 4e30 */ 0x87a4,0x98a3,0x8bf8,0,0,0,0x98a4,0, 0x8adb,0x924f,0,0x8ee5,0x98a5,0,0,0x98a6, /* '丰','丱','串',0,0,0,'丶',0, '丸','丹',0,'主','丼',0,0,'丿', */
	/* 4e40 */ 0xf047,0,0x98a7,0x9454,0,0x8b76,0,0xf048, 0xf049,0,0,0x9456,0,0x93e1,0x8cc1,0x9652, /* '乀',0,'乂','乃',0,'久',0,'乇', '么',0,0,'之',0,'乍','乎','乏', */
	/* 4e50 */ 0,0xf04b,0,0,0,0xe568,0x98a8,0x8fe6, 0x98a9,0x89b3,0xf04e,0,0,0x8be3,0x8cee,0x96e7, /* 0,'乑',0,0,0,'乕','乖','乗', '乘','乙','乚',0,0,'九','乞','也', */
	/* 4e60 */ 0,0,0x9ba4,0,0,0,0,0, 0,0xf04f,0,0,0,0,0,0, /* 0,0,'乢',0,0,0,0,0, 0,'乩',0,0,0,0,0,0, */
	/* 4e70 */ 0,0x9790,0,0x93fb,0,0,0,0, 0,0,0,0,0,0,0x8aa3,0, /* 0,'乱',0,'乳',0,0,0,0, 0,0,0,0,0,0,'乾',0, */
	/* 4e80 */ 0x8b54,0,0x98aa,0,0,0x98ab,0x97b9,0, 0x975c,0x9188,0x98ad,0x8e96,0x93f1,0x87a5,0x98b0,0, /* '亀',0,'亂',0,0,'亅','了',0, '予','争','亊','事','二','亍','于',0, */
	/* 4e90 */ 0,0x895d,0x8cdd,0,0x8cdc,0x88e4,0,0, 0x986a,0x9869,0,0x8db1,0x889f,0xf050,0x98b1,0x98b2, /* 0,'云','互',0,'五','井',0,0, '亘','亙',0,'些','亜','亝','亞','亟', */
	/* 4ea0 */ 0x98b3,0x9653,0x98b4,0,0x8cf0,0x88e5,0x9692,0, 0x8b9c,0,0,0x8b9d,0x8b9e,0x92e0,0x97ba,0, /* '亠','亡','亢',0,'交','亥','亦',0, '亨',0,0,'享','京','亭','亮',0, */
	/* 4eb0 */ 0x98b5,0,0,0x98b6,0,0,0x98b7,0, 0,0xf053,0x906c,0xf054,0xf056,0,0,0, /* '亰',0,0,'亳',0,0,'亶',0, 0,'亹','人','亻','亼',0,0,0, */
	/* 4ec0 */ 0x8f59,0x906d,0x98bc,0xf057,0x98ba,0,0x98bb,0x8b77, 0xf058,0,0x8da1,0x89ee,0,0x98b9,0x98b8,0x95a7, /* '什','仁','仂','仃','仄',0,'仆','仇', '仈',0,'今','介',0,'仍','从','仏', */
	/* 4ed0 */ 0xf059,0,0,0,0x8e65,0x8e64,0x91bc,0x98bd, 0x9574,0x90e5,0xf05b,0,0,0x8157,0x98be,0x98c0, /* '仐',0,0,0,'仔','仕','他','仗', '付','仙','仚',0,0,'仝','仞','仟', */
	/* 4ee0 */ 0,0x87a6,0,0x91e3,0x97df,0x88c8,0,0, 0,0,0,0xf05a,0,0x98bf,0x89bc,0, /* 0,'仡',0,'代','令','以',0,0, 0,0,0,'仫',0,'仭','仮',0, */
	/* 4ef0 */ 0x8bc2,0xf05c,0x9287,0,0,0xf05d,0x8c8f,0x98c1, 0,0,0,0x9443,0,0x87a7,0,0x87a8, /* '仰','仱','仲',0,0,'仵','件','价', 0,0,0,'任',0,'份',0,'仿', */
	/* 4f00 */ 0xf05e,0x8ae9,0,0x87a9,0,0,0,0, 0,0x98c2,0x88c9,0x87aa,0,0x8cde,0x8aea,0x959a, /* '伀','企',0,'伃',0,0,0,0, 0,'伉','伊','伋',0,'伍','伎','伏', */
	/* 4f10 */ 0x94b0,0x8b78,0,0,0,0,0xf05f,0, 0,0,0x89ef,0,0x98e5,0x9360,0,0, /* '伐','休',0,0,0,0,'伖',0, 0,0,'会',0,'伜','伝',0,0, */
	/* 4f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x948c, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'伯', */
	/* 4f30 */ 0x98c4,0,0,0,0x94ba,0,0x97e0,0xf061, 0x904c,0,0x8e66,0,0x8e97,0x89be,0xf062,0, /* '估',0,0,0,'伴',0,'伶','伷', '伸',0,'伺',0,'似','伽','伾',0, */
	/* 4f40 */ 0,0,0,0x92cf,0,0,0x9241,0x98c8, 0x87ac,0x87ad,0,0,0,0x88ca,0x92e1,0x8f5a, /* 0,0,0,'佃',0,0,'但','佇', '佈','佉',0,0,0,'位','低','住', */
	/* 4f50 */ 0x8db2,0x9743,0,0x91cc,0xf063,0x89bd,0x87ae,0x98c7, 0xf064,0x975d,0x98c3,0x98c5,0x8dec,0x98c6,0x9b43,0x87af, /* '佐','佑',0,'体','佔','何','佖','佗', '佘','余','佚','佛','作','佝','佞','佟', */
	/* 4f60 */ 0x87ab,0,0,0,0xf060,0,0,0, 0,0x98ce,0x87b0,0,0x87b1,0,0,0x98d1, /* '你',0,0,0,'佤',0,0,0, 0,'佩','佪',0,'佬',0,0,'佯', */
	/* 4f70 */ 0x98cf,0,0,0x89c0,0,0x95b9,0x98c9,0xf066, 0xf067,0,0xf068,0x98cd,0x8cf1,0xf069,0x87b2,0x8e67, /* '佰',0,0,'佳',0,'併','佶','佷', '佸',0,'佺','佻','佼','佽','佾','使', */
	/* 4f80 */ 0,0,0xf06a,0x8aa4,0,0xf06b,0x98d2,0, 0x98ca,0,0x87b3,0x97e1,0,0x8e98,0,0x98cb, /* 0,0,'侂','侃',0,'侅','來',0, '侈',0,'侊','例',0,'侍',0,'侏', */
	/* 4f90 */ 0,0x98d0,0xf06c,0,0x87b4,0,0x98d3,0x87b5, 0x98cc,0,0xf06d,0x8b9f,0,0x88cb,0,0, /* 0,'侑','侒',0,'侔',0,'侖','侗', '侘',0,'侚','供',0,'依',0,0, */
	/* 4fa0 */ 0x8ba0,0x89bf,0,0,0,0,0,0, 0,0,0,0x9b44,0,0x9699,0x958e,0x8cf2, /* '侠','価',0,0,0,0,0,0, 0,0,0,'侫',0,'侭','侮','侯', */
	/* 4fb0 */ 0,0,0xf06f,0,0,0x904e,0x97b5,0, 0,0,0,0,0,0,0xf070,0x95d6, /* 0,0,'侲',0,0,'侵','侶',0, 0,0,0,0,0,0,'侾','便', */
	/* 4fc0 */ 0,0,0x8c57,0x91a3,0x89e2,0xf071,0,0, 0,0x87b7,0x8f72,0xf072,0,0,0x98d7,0xf073, /* 0,0,'係','促','俄','俅',0,0, 0,'俉','俊','俋',0,0,'俎','俏', */
	/* 4fd0 */ 0x98dc,0x98da,0xf074,0,0x98d5,0,0,0x91ad, 0x98d8,0,0x98db,0x98d9,0,0x95db,0,0x98d6, /* '俐','俑','俒',0,'俔',0,0,'俗', '俘',0,'俚','俛',0,'保',0,'俟', */
	/* 4fe0 */ 0x87b8,0x904d,0,0x9693,0x98dd,0x98de,0xf06e,0, 0,0,0,0,0,0,0x8f43,0x98eb, /* '俠','信',0,'俣','俤','俥','俦',0, 0,0,0,0,0,0,'修','俯', */
	/* 4ff0 */ 0,0x879f,0xf076,0x946f,0,0x9555,0x98e6,0, 0x95ee,0,0x89b4,0,0,0,0x98ea,0, /* 0,'俱','俲','俳',0,'俵','俶',0, '俸',0,'俺',0,0,0,'俾',0, */
	/* 5000 */ 0xf077,0x87b9,0x87ba,0,0,0x98e4,0x98ed,0, 0,0x9171,0,0x8cc2,0,0x947b,0x87bb,0xe0c5, /* '倀','倁','倂',0,0,'倅','倆',0, 0,'倉',0,'個',0,'倍','倎','倏', */
	/* 5010 */ 0xf078,0x98ec,0x937c,0xf079,0x98e1,0,0x8cf4,0, 0x87bc,0x8cf3,0x98df,0,0xf07a,0,0xf07b,0x8ed8, /* '倐','們','倒','倓','倔',0,'倖',0, '倘','候','倚',0,'倜',0,'倞','借', */
	/* 5020 */ 0,0x98e7,0xf07c,0x95ed,0x926c,0x98e3,0x8c91,0x87bd, 0x98e0,0x98e8,0x98e2,0x97cf,0x98e9,0x9860,0x87be,0, /* 0,'倡','倢','倣','値','倥','倦','倧', '倨','倩','倪','倫','倬','倭','倮',0, */
	/* 5030 */ 0,0,0,0,0,0,0x8be4,0, 0,0x8c90,0,0x87c0,0,0,0,0, /* 0,0,0,0,0,0,'倶',0, 0,'倹',0,'倻',0,0,0,0, */
	/* 5040 */ 0x87bf,0x87c1,0xf07e,0x98ee,0,0,0xf080,0x98ef, 0x98f3,0x88cc,0,0,0,0,0xf081,0x95ce, /* '偀','偁','偂','偃',0,0,'偆','假', '偈','偉',0,0,0,0,'偎','偏', */
	/* 5050 */ 0x98f2,0,0,0xf082,0,0x98f1,0x98f5,0xf083, 0,0,0x98f4,0,0x92e2,0,0,0, /* '偐',0,0,'偓',0,'偕','偖','偗', 0,0,'做',0,'停',0,0,0, */
	/* 5060 */ 0,0,0,0xf084,0,0x8c92,0xf085,0, 0,0,0xf086,0,0x98f6,0,0,0, /* 0,0,0,'偣',0,'健','偦',0, 0,0,'偪',0,'偬',0,0,0, */
	/* 5070 */ 0xf087,0,0x8ec3,0,0x91a4,0x92e3,0x8bf4,0, 0x98f7,0,0,0,0,0x8b55,0,0, /* '偰',0,'偲',0,'側','偵','偶',0, '偸',0,0,0,0,'偽',0,0, */
	/* 5080 */ 0x98f8,0,0,0,0,0x98fa,0,0, 0xf089,0,0,0,0,0x9654,0,0, /* '傀',0,0,0,0,'傅',0,0, '傈',0,0,0,0,'傍',0,0, */
	/* 5090 */ 0,0x8c86,0xf08a,0xf08b,0x87c2,0xf08c,0xf08d,0, 0x8e50,0x94f5,0x98f9,0,0xf08e,0,0,0, /* 0,'傑','傒','傓','傔','傕','傖',0, '傘','備','傚',0,'傜',0,0,0, */
	/* 50a0 */ 0,0,0,0xf088,0,0,0,0, 0,0,0xf08f,0,0x8dc3,0x9762,0,0, /* 0,0,0,'傣',0,0,0,0, 0,0,'傪',0,'催','傭',0,0, */
	/* 50b0 */ 0,0xf091,0x98fc,0x9942,0x98fb,0x8dc2,0,0x8f9d, 0,0,0xf092,0xf093,0,0,0x8c58,0, /* 0,'傱','傲','傳','傴','債',0,'傷', 0,0,'傺','傻',0,0,'傾',0, */
	/* 50c0 */ 0,0,0x9943,0,0xf094,0x8bcd,0,0xf095, 0,0x9940,0x9941,0,0x87c3,0x93ad,0xf098,0x919c, /* 0,0,'僂',0,'僄','僅',0,'僇', 0,'僉','僊',0,'僌','働','僎','像', */
	/* 50d0 */ 0x87c5,0x8ba1,0,0,0xf09a,0x966c,0x9944,0, 0,0xf09b,0x97bb,0,0,0,0x9945,0, /* '僐','僑',0,0,'僔','僕','僖',0, 0,'僙','僚',0,0,0,'僞',0, */
	/* 50e0 */ 0,0xf09c,0,0x9948,0,0x9946,0x87c6,0x916d, 0,0xf09d,0,0,0,0x9947,0x9949,0, /* 0,'僡',0,'僣',0,'僥','僦','僧', 0,'僩',0,0,0,'僭','僮',0, */
	/* 50f0 */ 0,0,0x87c4,0xf096,0,0x994b,0,0, 0,0x994a,0,0x95c6,0,0,0,0, /* 0,0,'僲','僳',0,'僵',0,0, 0,'價',0,'僻',0,0,0,0, */
	/* 5100 */ 0x8b56,0x994d,0x994e,0x87c9,0x89ad,0,0x87c8,0, 0xf140,0x994c,0,0x87ca,0,0,0,0, /* '儀','儁','儂','儃','億',0,'儆',0, '儈','儉',0,'儋',0,0,0,0, */
	/* 5110 */ 0,0,0x8ef2,0,0x9951,0x9950,0x994f,0xf142, 0x98d4,0,0x9952,0xf143,0,0,0x87cb,0x8f9e, /* 0,0,'儒',0,'儔','儕','儖','儗', '儘',0,'儚','儛',0,0,'儞','償', */
	/* 5120 */ 0,0x9953,0,0,0,0,0,0, 0,0,0x9744,0,0,0,0,0, /* 0,'儡',0,0,0,0,0,0, 0,0,'優',0,0,0,0,0, */
	/* 5130 */ 0,0,0x96d7,0,0,0x87cc,0,0x9955, 0,0,0x9954,0x9957,0x9956,0,0,0x9958, /* 0,0,'儲',0,0,'儵',0,'儷', 0,0,'儺','儻','儼',0,0,'儿', */
	/* 5140 */ 0x9959,0x88f2,0,0x8cb3,0x8c5a,0x8f5b,0x929b,0x8ba2, 0x90e6,0x8cf5,0x87cd,0x8d8e,0x995b,0x96c6,0x9365,0, /* '兀','允',0,'元','兄','充','兆','兇', '先','光','兊','克','兌','免','兎',0, */
	/* 5150 */ 0x8e99,0,0x995a,0,0x995c,0x87cf,0,0x87d0, 0,0,0x937d,0,0x8a95,0,0,0, /* '児',0,'兒',0,'兔','兕',0,'兗', 0,0,'党',0,'兜',0,0,0, */
	/* 5160 */ 0xf145,0,0x995d,0,0,0x93fc,0,0, 0x9153,0x995f,0x9960,0x94aa,0x8cf6,0x985a,0x9961,0, /* '兠',0,'兢',0,0,'入',0,0, '全','兩','兪','八','公','六','兮',0, */
	/* 5170 */ 0,0x8ba4,0,0xf147,0,0x95ba,0x91b4,0x8bef, 0x9354,0,0,0xf7f2,0x8c93,0,0,0, /* 0,'共',0,'关',0,'兵','其','具', '典',0,0,'养','兼',0,0,0, */
	/* 5180 */ 0x9962,0,0x9963,0xf148,0,0x93e0,0x897e,0, 0,0x9966,0x8dfb,0xf149,0x9965,0x8dc4,0,0x9967, /* '冀',0,'冂','冃',0,'内','円',0, 0,'冉','冊','冋','册','再',0,'冏', */
	/* 5190 */ 0xe3ec,0x9968,0x9660,0x9969,0,0x996a,0x996b,0x8fe7, 0xf14b,0x8eca,0,0,0,0x87d2,0,0, /* '冐','冑','冒','冓',0,'冕','冖','冗', '冘','写',0,0,0,'冝',0,0, */
	/* 51a0 */ 0x8aa5,0,0x996e,0xf14c,0x996c,0x96bb,0x996d,0, 0x9579,0x996f,0x9970,0x9971,0x937e,0xf14d,0,0, /* '冠',0,'冢','冣','冤','冥','冦',0, '冨','冩','冪','冫','冬','冭',0,0, */
	/* 51b0 */ 0x9975,0x9973,0x9974,0x9972,0x8de1,0x9976,0x96e8,0x97e2, 0,0,0,0,0xf14f,0x9977,0,0, /* '冰','冱','冲','决','冴','况','冶','冷', 0,0,0,0,'冼','冽',0,0, */
	/* 51c0 */ 0,0,0,0x87d3,0x90a6,0x9978,0x8f79,0, 0,0x9979,0x87d4,0x929c,0x97bd,0x9380,0,0, /* 0,0,0,'凃','凄','凅','准',0, 0,'凉','凊','凋','凌','凍',0,0, */
	/* 51d0 */ 0,0,0,0,0,0,0x99c3,0, 0,0,0,0x997a,0xeaa3,0x8bc3,0x87d5,0, /* 0,0,0,0,0,0,'凖',0, 0,0,0,'凛','凜','凝','凞',0, */
	/* 51e0 */ 0x997b,0x967d,0x87d6,0,0,0,0x8f88,0x91fa, 0,0x997d,0x93e2,0,0,0x997e,0x87d7,0, /* '几','凡','凢',0,0,0,'処','凧', 0,'凩','凪',0,0,'凭','凮',0, */
	/* 51f0 */ 0x9980,0x8a4d,0,0xf152,0xf153,0x9981,0x8ba5,0, 0x93ca,0x899a,0x8f6f,0,0,0x949f,0x9982,0, /* '凰','凱',0,'凳','凴','凵','凶',0, '凸','凹','出',0,0,'函','凾',0, */
	/* 5200 */ 0x9381,0x87d8,0xf154,0x906e,0x9983,0,0x95aa,0x90d8, 0x8aa0,0,0x8aa7,0x9984,0,0,0x9986,0, /* '刀','刁','刂','刃','刄',0,'分','切', '刈',0,'刊','刋',0,0,'刎',0, */
	/* 5210 */ 0,0x8c59,0xf155,0x87da,0x9985,0x87db,0xf156,0x97f1, 0,0,0,0,0,0x8f89,0,0, /* 0,'刑','划','刓','刔','刕','刖','列', 0,0,0,0,0,'初',0,0, */
	/* 5220 */ 0,0,0,0,0x94bb,0x95ca,0,0x9987, 0,0x9798,0x9988,0,0,0,0x9989,0, /* 0,0,0,0,'判','別',0,'刧', 0,'利','刪',0,0,0,'刮',0, */
	/* 5230 */ 0x939e,0,0,0x998a,0,0,0x90a7,0x8dfc, 0x8c94,0x998b,0x8e68,0x8d8f,0,0,0,0, /* '到',0,0,'刳',0,0,'制','刷', '券','刹','刺','刻',0,0,0,0, */
	/* 5240 */ 0,0,0,0x92e4,0x998d,0,0,0x91a5, 0,0x87dc,0x8ded,0x998e,0x998f,0x914f,0,0x998c, /* 0,0,0,'剃','剄',0,0,'則', 0,'剉','削','剋','剌','前',0,'剏', */
	/* 5250 */ 0,0,0,0,0x9991,0xf158,0x9655,0x87dd, 0,0,0,0x8d84,0xf159,0x889e,0x9990,0, /* 0,0,0,0,'剔','剕','剖','剗', 0,0,0,'剛','剜','剝','剞',0, */
	/* 5260 */ 0,0x87de,0,0x8c95,0x8ddc,0x948d,0,0, 0,0x9994,0x9992,0,0xf15a,0,0,0x959b, /* 0,'剡',0,'剣','剤','剥',0,0, 0,'剩','剪',0,'剬',0,0,'副', */
	/* 5270 */ 0x8fe8,0x999b,0x8a84,0x9995,0x9993,0x916e,0,0xf15b, 0,0,0,0,0,0x9997,0,0x9996, /* '剰','剱','割','剳','剴','創',0,'剷', 0,0,0,0,0,'剽',0,'剿', */
	/* 5280 */ 0,0,0xf15d,0x8a63,0xf15c,0,0,0x8c80, 0x999c,0x97ab,0,0,0,0x9998,0,0, /* 0,0,'劂','劃','劄',0,0,'劇', '劈','劉',0,0,0,'劍',0,0, */
	/* 5290 */ 0,0x999d,0x999a,0x87df,0x9999,0,0,0, 0xf15f,0,0,0x97cd,0,0,0,0x8cf7, /* 0,'劑','劒','劓','劔',0,0,0, '劘',0,0,'力',0,0,0,'功', */
	/* 52a0 */ 0x89c1,0,0,0x97f2,0xf161,0,0xf162,0, 0,0x8f95,0x9377,0x8d85,0x99a0,0x99a1,0,0xf163, /* '加',0,0,'劣','劤',0,'劦',0, 0,'助','努','劫','劬','劭',0,'劯', */
	/* 52b0 */ 0,0x97e3,0,0,0x984a,0x99a3,0,0, 0,0x8cf8,0xf164,0xf165,0x99a2,0,0x8a4e,0, /* 0,'励',0,0,'労','劵',0,0, 0,'効','劺','劻','劼',0,'劾',0, */
	/* 52c0 */ 0,0x99a4,0,0x9675,0,0x92ba,0,0x9745, 0x87e0,0x95d7,0xf166,0,0x87e2,0x99a5,0,0, /* 0,'勁',0,'勃',0,'勅',0,'勇', '勈','勉','勊',0,'勌','勍',0,0, */
	/* 52d0 */ 0x87e3,0xf168,0xe8d3,0,0,0x93ae,0x87e4,0x99a6, 0x8aa8,0x96b1,0,0x87e5,0,0x8f9f,0x99a7,0x95e5, /* '勐','勑','勒',0,0,'動','勖','勗', '勘','務',0,'勛',0,'勝','勞','募', */
	/* 52e0 */ 0x99ab,0,0x90a8,0x99a8,0x8bce,0,0x99a9,0x8aa9, 0,0,0,0,0,0,0,0, /* '勠',0,'勢','勣','勤',0,'勦','勧', 0,0,0,0,0,0,0,0, */
	/* 52f0 */ 0x87e7,0,0x8c4d,0x99ac,0,0x99ad,0,0xf16a, 0x99ae,0x99af,0x8ed9,0x87e8,0,0,0x8cf9,0x96dc, /* '勰',0,'勲','勳',0,'勵',0,'勷', '勸','勹','勺','勻',0,0,'勾','勿', */
	/* 5300 */ 0x87e9,0x96e6,0x93f5,0,0,0x95ef,0x99b0,0x87ea, 0x99b1,0,0xf16b,0xf16c,0,0x99b3,0,0x99b5, /* '匀','匁','匂',0,0,'包','匆','匇', '匈',0,'匊','匋',0,'匍',0,'匏', */
	/* 5310 */ 0x99b4,0,0,0,0,0x99b6,0x89bb,0x966b, 0,0x8dfa,0x99b7,0,0x87eb,0x9178,0,0, /* '匐',0,0,0,0,'匕','化','北', 0,'匙','匚',0,'匜','匝',0,0, */
	/* 5320 */ 0x8fa0,0x8ba7,0,0x99b8,0xf16d,0,0,0, 0,0,0x94d9,0,0,0,0,0x99b9, /* '匠','匡',0,'匣','匤',0,0,0, 0,0,'匪',0,0,0,0,'匯', */
	/* 5330 */ 0,0x99ba,0,0x99bb,0,0xf16e,0,0, 0x99bc,0x9543,0x8be6,0x88e3,0,0,0xf16f,0x93bd, /* 0,'匱',0,'匳',0,'匵',0,0, '匸','匹','区','医',0,0,'匾','匿', */
	/* 5340 */ 0x99bd,0x8f5c,0xf170,0x90e7,0,0x99bf,0x99be,0x8fa1, 0x8cdf,0x99c1,0x94bc,0,0,0x99c2,0,0, /* '區','十','卂','千',0,'卅','卆','升', '午','卉','半',0,0,'卍',0,0, */
	/* 5350 */ 0,0x94da,0x91b2,0x91ec,0x8ba6,0,0,0x93ec, 0x9250,0,0x948e,0,0x966d,0,0x99c4,0, /* 0,'卑','卒','卓','協',0,0,'南', '単',0,'博',0,'卜',0,'卞',0, */
	/* 5360 */ 0x90e8,0x87ed,0,0x87ee,0,0,0x8c54,0xf173, 0,0x99c5,0,0,0xf174,0,0x99c6,0x894b, /* '占','卡',0,'卣',0,0,'卦','卧', 0,'卩',0,0,'卬',0,'卮','卯', */
	/* 5370 */ 0x88f3,0x8aeb,0,0x91a6,0x8b70,0x9791,0,0x99c9, 0x89b5,0,0xf175,0x99c8,0,0x87ef,0,0x8ba8, /* '印','危',0,'即','却','卵',0,'卷', '卸',0,'卺','卻',0,'卽',0,'卿', */
	/* 5380 */ 0,0,0x99ca,0,0x96ef,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'厂',0,'厄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5390 */ 0,0,0,0x87f0,0,0,0x99cb,0, 0x97d0,0,0x8cfa,0,0,0x87f1,0,0x8cb4, /* 0,0,0,'厓',0,0,'厖',0, '厘',0,'厚',0,0,'厝',0,'原', */
	/* 53a0 */ 0x99cc,0,0,0,0xf176,0x99ce,0x99cd,0, 0x907e,0x8958,0,0,0,0x897d,0x99cf,0, /* '厠',0,0,0,'厤','厥','厦',0, '厨','厩',0,0,0,'厭','厮',0, */
	/* 53b0 */ 0x99d0,0,0x87f2,0x8cb5,0xf177,0,0x99d1,0xf179, 0,0,0,0x8b8e,0,0,0,0, /* '厰',0,'厲','厳','厴',0,'厶','厷', 0,0,0,'去',0,0,0,0, */
	/* 53c0 */ 0xf17a,0,0x8e51,0x99d2,0,0,0,0, 0x9694,0x8db3,0x8b79,0x9746,0x916f,0x94bd,0x8efb,0, /* '叀',0,'参','參',0,0,0,0, '又','叉','及','友','双','反','収',0, */
	/* 53d0 */ 0,0,0,0,0x8f66,0xf17e,0x8ee6,0x8ef3, 0,0x8f96,0xf180,0x94be,0,0,0,0x99d5, /* 0,0,0,0,'叔','叕','取','受', 0,'叙','叚','叛',0,0,0,'叟', */
	/* 53e0 */ 0,0x8962,0x9170,0x8cfb,0x8cc3,0x8be5,0,0, 0x99d9,0x9240,0x91fc,0x8ba9,0x8fa2,0x99da,0x99d8,0x89c2, /* 0,'叡','叢','口','古','句',0,0, '叨','叩','只','叫','召','叭','叮','可', */
	/* 53f0 */ 0x91e4,0x8eb6,0x8e6a,0x8945,0xf182,0xf183,0x8a90,0x8d86, 0x8e69,0,0x99db,0,0,0,0,0, /* '台','叱','史','右','叴','叵','叶','号', '司',0,'叺',0,0,0,0,0, */
	/* 5400 */ 0,0x99dc,0,0x8b68,0x8a65,0,0,0, 0x8d87,0x8b67,0x92dd,0x8944,0x93af,0x96bc,0x8d40,0x9799, /* 0,'吁',0,'吃','各',0,0,0, '合','吉','吊','吋','同','名','后','吏', */
	/* 5410 */ 0x9366,0x8cfc,0x87f3,0,0,0,0,0, 0,0,0,0x8c4e,0,0x99e5,0x989e,0x8be1, /* '吐','向','吒',0,0,0,0,0, 0,0,0,'君',0,'吝','吞','吟', */
	/* 5420 */ 0x9669,0,0,0,0xf185,0,0x94db,0x87f4, 0xf186,0x99e4,0,0x8adc,0x99df,0x99e0,0x99e2,0, /* '吠',0,0,0,'吤',0,'否','吧', '吨','吩',0,'含','听','吭','吮',0, */
	/* 5430 */ 0,0,0,0,0,0,0x99e3,0, 0x8b7a,0x9081,0,0x95ab,0x99e1,0x99dd,0x8ce1,0, /* 0,0,0,0,0,0,'吶',0, '吸','吹',0,'吻','吼','吽','吾',0, */
	/* 5440 */ 0x99de,0,0x9843,0xf188,0,0,0x95f0,0, 0x92e6,0x8ce0,0x8d90,0,0,0x87f5,0x99e6,0, /* '呀',0,'呂','呃',0,0,'呆',0, '呈','呉','告',0,0,'呍','呎',0, */
	/* 5450 */ 0,0x93db,0,0,0,0xf184,0,0, 0,0,0,0,0,0,0,0x99ea, /* 0,'呑',0,0,0,'呕',0,0, 0,0,0,0,0,0,0,'呟', */
	/* 5460 */ 0,0,0xf189,0,0,0,0xf18a,0, 0x8efc,0,0x8ef4,0x87f7,0xf18b,0,0,0, /* 0,0,'呢',0,0,0,'呦',0, '周',0,'呪','呫','呬',0,0,0, */
	/* 5470 */ 0x99ed,0x99eb,0,0x96a1,0x87f8,0x99e8,0x99f1,0x99ec, 0,0,0,0x99ef,0x8cc4,0x96bd,0,0x87f9, /* '呰','呱',0,'味','呴','呵','呶','呷', 0,0,0,'呻','呼','命',0,'呿', */
	/* 5480 */ 0x99f0,0,0,0,0x99f2,0,0x99f4,0, 0x87fa,0,0xf18c,0x8dee,0x9861,0xf18d,0x99e9,0x99e7, /* '咀',0,0,0,'咄',0,'咆',0, '咈',0,'咊','咋','和','咍','咎','咏', */
	/* 5490 */ 0x99f3,0,0x99ee,0,0,0xf18e,0x87fb,0, 0,0,0,0,0x87f6,0,0,0, /* '咐',0,'咒',0,0,'咕','咖',0, 0,0,0,0,'咜',0,0,0, */
	/* 54a0 */ 0xf18f,0x87fc,0x99f6,0,0x9a42,0x99f8,0xf190,0, 0x99fc,0x8840,0,0x9a40,0x99f9,0xf191,0xf192,0x9a5d, /* '咠','咡','咢',0,'咤','咥','咦',0, '咨','咩',0,'咫','咬','咭','咮','咯', */
	/* 54b0 */ 0,0,0x8de7,0x8a50,0,0,0,0xf193, 0x99f7,0,0xf194,0,0x9a44,0x88f4,0x9a43,0xf195, /* 0,0,'咲','咳',0,0,0,'咷', '咸',0,'咺',0,'咼','咽','咾','咿', */
	/* 54c0 */ 0x88a3,0x9569,0x9a41,0xf196,0x99fa,0,0x8841,0x99f5, 0x99fb,0x8dc6,0,0,0,0,0,0, /* '哀','品','哂','哃','哄',0,'哆','哇', '哈','哉',0,0,0,0,0,0, */
	/* 54d0 */ 0,0,0,0,0,0,0,0, 0x9a45,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '哘',0,0,0,0,0,0,0, */
	/* 54e0 */ 0,0x88f5,0x9a4e,0,0,0x9a46,0x9a47,0, 0x8fa3,0x9689,0,0,0xf198,0x9a4c,0x9a4b,0xf199, /* 0,'員','哢',0,0,'哥','哦',0, '哨','哩',0,0,'哬','哭','哮','哯', */
	/* 54f0 */ 0,0xf19a,0x934e,0xf19b,0,0,0,0, 0,0,0x9a4d,0,0,0x9a4a,0,0x8842, /* 0,'哱','哲','哳',0,0,0,0, 0,0,'哺',0,0,'哽',0,'哿', */
	/* 5500 */ 0xf19c,0xf19d,0,0,0x8953,0,0x8db4,0x904f, 0,0xf19e,0,0,0,0,0x8843,0x9a48, /* '唀','唁',0,0,'唄',0,'唆','唇', 0,'唉',0,0,0,0,'唎','唏', */
	/* 5510 */ 0x9382,0,0,0,0x9a49,0,0x88a0,0, 0,0,0,0,0,0,0,0, /* '唐',0,0,0,'唔',0,'唖',0, 0,0,0,0,0,0,0,0, */
	/* 5520 */ 0,0,0,0,0,0,0,0, 0,0,0,0x8844,0,0,0x9a53,0x9742, /* 0,0,0,0,0,0,0,0, 0,0,0,'唫',0,0,'售','唯', */
	/* 5530 */ 0,0x8fa5,0,0x9a59,0,0x8845,0,0, 0x9a58,0x9a4f,0,0,0xf19f,0,0x91c1,0, /* 0,'唱',0,'唳',0,'唵',0,0, '唸','唹',0,0,'唼',0,'唾',0, */
	/* 5540 */ 0x9a50,0xf1a0,0,0,0x91ed,0x9a55,0x8fa4,0xf1a2, 0,0,0xf1a3,0,0x9a52,0,0,0x96e2, /* '啀','啁',0,0,'啄','啅','商','啇', 0,0,'啊',0,'啌',0,0,'問', */
	/* 5550 */ 0x8846,0,0,0x8c5b,0,0,0x9a56,0x9a57, 0,0,0,0,0x9a54,0x9a5a,0x8847,0, /* '啐',0,0,'啓',0,0,'啖','啗', 0,0,0,0,'啜','啝','啞',0, */
	/* 5560 */ 0xf1a5,0xf1a6,0,0x9a51,0xf1a7,0,0,0, 0,0,0,0,0,0,0,0, /* '啠','啡',0,'啣','啤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5570 */ 0,0,0,0,0,0,0,0, 0,0,0,0x9a60,0x9a65,0xf1a9,0x9a61,0, /* 0,0,0,0,0,0,0,0, 0,0,0,'啻','啼','啽','啾',0, */
	/* 5580 */ 0x9a5c,0x8848,0xf1aa,0x9a66,0x9150,0,0x8849,0x9a68, 0xf1ab,0x8d41,0x9a5e,0x929d,0,0,0x884a,0, /* '喀','喁','喂','喃','善',0,'喆','喇', '喈','喉','喊','喋',0,0,'喎',0, */
	/* 5590 */ 0,0xf1ac,0,0,0,0,0,0, 0x9a62,0x9a5b,0x8aab,0,0x8aec,0x8a85,0x9a63,0x9a5f, /* 0,'喑',0,0,0,0,0,0, '喘','喙','喚',0,'喜','喝','喞','喟', */
	/* 55a0 */ 0,0,0,0,0,0,0,0x8c96, 0x9a69,0x9a67,0x9172,0x8b69,0x8baa,0x884c,0x9a64,0, /* 0,0,0,0,0,0,0,'喧', '喨','喩','喪','喫','喬','喭','單',0, */
	/* 55b0 */ 0x8bf2,0,0,0,0,0,0x8963,0, 0,0,0,0,0,0,0,0xf1b1, /* '喰',0,0,0,0,0,'営',0, 0,0,0,0,0,0,0,'喿', */
	/* 55c0 */ 0,0,0,0,0x9a6d,0x9a6b,0,0x9aa5, 0,0xf1b2,0,0,0xf1b3,0,0x884d,0, /* 0,0,0,0,'嗄','嗅',0,'嗇', 0,'嗉',0,0,'嗌',0,'嗎',0, */
	/* 55d0 */ 0,0xf1b4,0xf1ae,0,0x9a70,0,0,0, 0,0,0x9a6a,0,0x9a6e,0xf1b5,0,0x9a6c, /* 0,'嗑','嗒',0,'嗔',0,0,0, 0,0,'嗚',0,'嗜','嗝',0,'嗟', */
	/* 55e0 */ 0,0,0xf1b7,0x8e6b,0x9a6f,0,0,0, 0,0xf1b9,0,0,0,0,0,0, /* 0,0,'嗢','嗣','嗤',0,0,0, 0,'嗩',0,0,0,0,0,0, */
	/* 55f0 */ 0,0,0,0,0,0,0,0x9a72, 0,0x9a77,0,0,0,0x9a75,0x9a74,0, /* 0,0,0,0,0,0,0,'嗷', 0,'嗹',0,0,0,'嗽','嗾',0, */
	/* 5600 */ 0,0,0,0,0,0,0x9251,0xf1bc, 0x884f,0x89c3,0,0,0,0,0x8850,0, /* 0,0,0,0,0,0,'嘆','嘇', '嘈','嘉',0,0,0,0,'嘎',0, */
	/* 5610 */ 0xf1bd,0,0,0,0x9a71,0,0x9a73,0x8fa6, 0x8952,0,0,0x9a76,0,0,0,0, /* '嘐',0,0,0,'嘔',0,'嘖','嘗', '嘘',0,0,'嘛',0,0,0,0, */
	/* 5620 */ 0,0,0,0,0,0,0,0, 0xf1ba,0x89dc,0,0,0,0,0,0x9a82, /* 0,0,0,0,0,0,0,0, '嘨','嘩',0,0,0,0,0,'嘯', */
	/* 5630 */ 0xf1be,0x8ffa,0x9a7d,0,0x9a7b,0,0x9a7c,0xf1bf, 0x9a7e,0,0,0x8851,0,0xf1c1,0,0xf1c2, /* '嘰','嘱','嘲',0,'嘴',0,'嘶','嘷', '嘸',0,0,'嘻',0,'嘽',0,'嘿', */
	/* 5640 */ 0xf1c3,0,0x895c,0,0,0,0,0xf1c4, 0,0x8852,0,0,0x9158,0,0x9a78,0, /* '噀',0,'噂',0,0,0,0,'噇', 0,'噉',0,0,'噌',0,'噎',0, */
	/* 5650 */ 0x9a79,0,0,0xeaa5,0,0,0,0, 0,0,0,0x8a9a,0,0,0xf1c5,0, /* '噐',0,0,'噓',0,0,0,0, 0,0,0,'噛',0,0,'噞',0, */
	/* 5660 */ 0xf1c6,0,0,0,0x9a81,0,0x8854,0, 0x8aed,0,0x9a84,0x9a80,0x9a83,0xf1c7,0,0x8856, /* '噠',0,0,0,'噤',0,'噦',0, '器',0,'噪','噫','噬','噭',0,'噯', */
	/* 5670 */ 0,0x8857,0x8858,0,0x95ac,0,0x8853,0, 0x93d3,0,0x94b6,0,0,0,0,0, /* 0,'噱','噲',0,'噴',0,'噶',0, '噸',0,'噺',0,0,0,0,0, */
	/* 5680 */ 0x9a86,0,0,0,0,0,0x9a85,0x8a64, 0xf1c9,0,0x9a87,0,0xf1ca,0,0,0x9a8a, /* '嚀',0,0,0,0,0,'嚆','嚇', '嚈',0,'嚊',0,'嚌',0,0,'嚏', */
	/* 5690 */ 0,0,0,0,0x9a89,0xf1cb,0,0, 0,0x8859,0xf1cc,0,0,0xf1cd,0x885a,0, /* 0,0,0,0,'嚔','嚕',0,0, 0,'嚙','嚚',0,0,'嚝','嚞',0, */
	/* 56a0 */ 0x9a88,0,0x9458,0,0,0x9a8b,0,0, 0xf1ce,0x885b,0,0,0x885c,0xf1cf,0x9a8c,0, /* '嚠',0,'嚢',0,0,'嚥',0,0, '嚨','嚩',0,0,'嚬','嚭','嚮',0, */
	/* 56b0 */ 0,0,0xf1d0,0x885d,0x9a8e,0,0x9a8d,0, 0,0,0,0,0x9a90,0,0,0, /* 0,0,'嚲','嚳','嚴',0,'嚶',0, 0,0,0,0,'嚼',0,0,0, */
	/* 56c0 */ 0x9a93,0x9a91,0x9a8f,0x9a92,0,0xf1d1,0,0, 0x9a94,0x885e,0x885f,0,0,0xf1d2,0x9a95,0, /* '囀','囁','囂','囃',0,'囅',0,0, '囈','囉','囊',0,0,'囍','囎',0, */
	/* 56d0 */ 0,0x9a96,0,0x9a97,0,0,0,0x9a98, 0x9964,0,0x8efa,0x8e6c,0,0,0x89f1,0xf1d3, /* 0,'囑',0,'囓',0,0,0,'囗', '囘',0,'囚','四',0,0,'回','囟', */
	/* 56e0 */ 0x88f6,0,0,0x9263,0,0,0,0, 0xf1d4,0,0,0,0,0,0x9a99,0, /* '因',0,0,'団',0,0,0,0, '囨',0,0,0,0,0,'囮',0, */
	/* 56f0 */ 0x8da2,0,0x88cd,0x907d,0,0,0xf1d5,0xf1d6, 0,0x9a9a,0x8cc5,0,0,0x8d91,0,0x9a9c, /* '困',0,'囲','図',0,0,'囶','囷', 0,'囹','固',0,0,'国',0,'囿', */
	/* 5700 */ 0x9a9b,0,0,0x95de,0x9a9d,0,0,0, 0x9a9f,0x9a9e,0x8860,0x9aa0,0,0x9aa1,0,0x8c97, /* '圀',0,0,'圃','圄',0,0,0, '圈','圉','圊','國',0,'圍',0,'圏', */
	/* 5710 */ 0,0,0x8980,0x9aa2,0,0xf1d8,0x9aa4,0, 0x9aa3,0,0,0,0x9aa6,0,0,0x9379, /* 0,0,'園','圓',0,'圕','圖',0, '團',0,0,0,'圜',0,0,'土', */
	/* 5720 */ 0,0x8862,0,0xf1d9,0,0,0x9aa7,0x88b3, 0x8ddd,0xf1db,0,0,0,0x8c5c,0,0x8863, /* 0,'圡',0,'圣',0,0,'圦','圧', '在','圩',0,0,0,'圭',0,'圯', */
	/* 5730 */ 0x926e,0,0,0x8864,0x8865,0,0,0x9aa8, 0x9aa9,0,0,0x9aab,0,0,0,0, /* '地',0,0,'圳','圴',0,0,'圷', '圸',0,0,'圻',0,0,0,0, */
	/* 5740 */ 0x9aac,0,0x8de2,0,0,0xf1dd,0xf1de,0x8bcf, 0,0,0x9656,0,0xf1df,0xf1e0,0x9aaa,0x9aad, /* '址',0,'坂',0,0,'坅','坆','均', 0,0,'坊',0,'坌','坍','坎','坏', */
	/* 5750 */ 0x8dbf,0x8d42,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '坐','坑',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 5760 */ 0,0x9ab1,0,0,0x8da3,0,0x9252,0, 0xf1e2,0x9aae,0x92d8,0,0,0,0,0xf1e3, /* 0,'坡',0,0,'坤',0,'坦',0, '坨','坩','坪',0,0,0,0,'坯', */
	/* 5770 */ 0x8866,0,0,0xf1e4,0xf1e5,0xf1e6,0,0x8867, 0,0,0,0xf1e7,0x8868,0,0,0x9ab2, /* '坰',0,0,'坳','坴','坵',0,'坷', 0,0,0,'坻','坼',0,0,'坿', */
	/* 5780 */ 0,0,0x9082,0,0,0,0,0, 0x9ab0,0x9ab3,0,0x8c5e,0,0,0,0, /* 0,0,'垂',0,0,0,0,0, '垈','垉',0,'型',0,0,0,0, */
	/* 5790 */ 0,0,0,0x9ab4,0,0,0,0, 0,0,0xf1eb,0,0x8869,0xf1ec,0xf1ed,0, /* 0,0,0,'垓',0,0,0,0, 0,0,'垚',0,'垜','垝','垞',0, */
	/* 57a0 */ 0x9ab5,0,0x8d43,0x8a5f,0x9ab7,0,0,0, 0xf1ee,0,0x9ab8,0,0xf1ea,0,0,0, /* '垠',0,'垢','垣','垤',0,0,0, '垨',0,'垪',0,'垬',0,0,0, */
	/* 57b0 */ 0x9ab9,0,0,0x9ab6,0,0,0,0, 0x886c,0,0,0,0,0,0,0, /* '垰',0,0,'垳',0,0,0,0, '垸',0,0,0,0,0,0,0, */
	/* 57c0 */ 0x9aaf,0,0,0x9aba,0,0,0x9abb,0x886d, 0x886e,0,0,0x9684,0xf1f1,0,0x8fe9,0x886f, /* '埀',0,0,'埃',0,0,'埆','埇', '埈',0,0,'埋','埌',0,'城','埏', */
	/* 57d0 */ 0,0,0x9abd,0x9abe,0x9abc,0,0x9ac0,0xf1ef, 0,0,0,0,0x9457,0,0xf1f4,0x88e6, /* 0,0,'埒','埓','埔',0,'埖','埗', 0,0,0,0,'埜',0,'埞','域', */
	/* 57e0 */ 0x9575,0,0,0x9ac1,0x8870,0,0xf1f5,0, 0,0,0,0,0,0x8871,0,0, /* '埠',0,0,'埣','埤',0,'埦',0, 0,0,0,0,0,'埭',0,0, */
	/* 57f0 */ 0xf1f6,0,0,0,0x8ffb,0x8872,0x8873,0x8eb7, 0xf1f8,0x947c,0x8aee,0xf1f9,0x8de9,0xf1fa,0,0x8874, /* '埰',0,0,0,'埴','埵','埶','執', '埸','培','基','埻','埼','埽',0,'埿', */
	/* 5800 */ 0x9678,0,0x93b0,0,0xf1fb,0x8c98,0x91cd,0, 0,0x8875,0x9abf,0x9ac2,0,0,0,0, /* '堀',0,'堂',0,'堄','堅','堆',0, 0,'堉','堊','堋',0,0,0,0, */
	/* 5810 */ 0,0,0,0,0,0x91c2,0,0, 0,0x9ac3,0,0,0,0x9ac4,0xf1fc,0, /* 0,0,0,0,0,'堕',0,0, 0,'堙',0,0,0,'堝','堞',0, */
	/* 5820 */ 0xf240,0x9ac6,0,0,0x92e7,0,0,0xf241, 0,0,0x8aac,0,0,0,0,0xea9f, /* '堠','堡',0,0,'堤',0,0,'堧', 0,0,'堪',0,0,0,0,'堯', */
	/* 5830 */ 0x8981,0x95f1,0xf242,0,0x8fea,0x9367,0,0, 0,0xf243,0x8de4,0,0,0x9acc,0,0, /* '堰','報','堲',0,'場','堵',0,0, 0,'堹','堺',0,0,'堽',0,0, */
	/* 5840 */ 0x95bb,0x97db,0,0,0,0,0,0, 0,0xf245,0x89f2,0x9ac8,0xf246,0,0,0, /* '塀','塁',0,0,0,0,0,0, 0,'塉','塊','塋','塌',0,0,0, */
	/* 5850 */ 0,0x9159,0x9acb,0,0x9383,0,0,0x9368, 0x9384,0x94b7,0x92cb,0,0,0,0x8dc7,0, /* 0,'塑','塒',0,'塔',0,0,'塗', '塘','塙','塚',0,0,0,'塞',0, */
	/* 5860 */ 0,0x8877,0x9ac7,0,0x8878,0,0,0xf247, 0,0x8996,0,0x9355,0,0,0,0, /* 0,'塡','塢',0,'塤',0,0,'塧', 0,'塩',0,'填',0,0,0,0, */
	/* 5870 */ 0x9ac9,0,0x9ac5,0,0,0x906f,0,0, 0,0x9acd,0,0,0x887a,0,0x8f6d,0, /* '塰',0,'塲',0,0,'塵',0,0, 0,'塹',0,0,'塼',0,'塾',0, */
	/* 5880 */ 0,0,0,0x8bab,0,0x9ace,0,0, 0,0x887b,0xf248,0xf249,0,0xf24a,0,0xf24b, /* 0,0,0,'境',0,'墅',0,0, 0,'墉','墊','墋',0,'墍',0,'墏', */
	/* 5890 */ 0xf24c,0,0,0x95e6,0xf24d,0,0,0x919d, 0,0,0,0,0x92c4,0xf24e,0x887c,0x9ad0, /* '墐',0,0,'墓','墔',0,0,'増', 0,0,0,0,'墜','墝','增','墟', */
	/* 58a0 */ 0,0,0,0,0,0,0,0, 0x966e,0x887e,0xf24f,0x9ad1,0,0,0x9ad6,0, /* 0,0,0,0,0,0,0,0, '墨','墩','墪','墫',0,0,'墮',0, */
	/* 58b0 */ 0,0xf250,0,0x95ad,0,0,0,0, 0x9ad5,0x9acf,0x9ad2,0x9ad4,0,0,0x8da4,0, /* 0,'墱',0,'墳',0,0,0,0, '墸','墹','墺','墻',0,0,'墾',0, */
	/* 58c0 */ 0,0x95c7,0,0xf252,0,0x9ad7,0,0x9264, 0,0,0x89f3,0,0x8feb,0xf253,0x8882,0, /* 0,'壁',0,'壃',0,'壅',0,'壇', 0,0,'壊',0,'壌','壍','壎',0, */
	/* 58d0 */ 0,0x9ad9,0x8881,0x9ad8,0x8883,0x8d88,0,0x9ada, 0x9adc,0x9adb,0x8884,0,0x9ade,0,0x9ad3,0x9ae0, /* 0,'壑','壒','壓','壔','壕',0,'壗', '壘','壙','壚',0,'壜',0,'壞','壟', */
	/* 58e0 */ 0x8885,0,0xf254,0,0x9adf,0x9add,0,0, 0,0x8886,0,0x8e6d,0x9070,0,0x9173,0x9ae1, /* '壠',0,'壢',0,'壤','壥',0,0, 0,'壩',0,'士','壬',0,'壮','壯', */
	/* 58f0 */ 0x90ba,0x88eb,0x9484,0xf255,0xf256,0,0,0x92d9, 0,0x9ae3,0x9ae2,0x9ae4,0x9ae5,0x9ae6,0,0, /* '声','壱','売','壳','壴',0,0,'壷', 0,'壹','壺','壻','壼','壽',0,0, */
	/* 5900 */ 0,0,0x9ae7,0,0,0xf257,0xf258,0, 0,0x95cf,0x9ae8,0xf259,0x8887,0xf25a,0,0x89c4, /* 0,0,'夂',0,0,'夅','夆',0, 0,'変','夊','夋','夌','复',0,'夏', */
	/* 5910 */ 0x9ae9,0,0,0,0xf25b,0x975b,0x8a4f,0, 0x99c7,0x8f67,0x91bd,0x9aea,0x96e9,0,0,0, /* '夐',0,0,0,'夔','夕','外',0, '夘','夙','多','夛','夜',0,0,0, */
	/* 5920 */ 0,0,0x96b2,0,0xf25c,0x9aec,0,0x91e5, 0,0x9356,0x91be,0x9576,0x9aed,0x9aee,0x899b,0, /* 0,0,'夢',0,'夤','夥',0,'大', 0,'天','太','夫','夬','夭','央',0, */
	/* 5930 */ 0,0x8eb8,0x9aef,0,0,0,0,0x88ce, 0x9af0,0,0,0,0,0xf25f,0x9af1,0, /* 0,'失','夲',0,0,0,0,'夷', '夸',0,0,0,0,'夽','夾',0, */
	/* 5940 */ 0,0,0,0,0x8982,0,0xf261,0x8aef, 0x93de,0x95f2,0,0,0,0,0x9af5,0x9174, /* 0,0,0,0,'奄',0,'奆','奇', '奈','奉',0,0,0,0,'奎','奏', */
	/* 5950 */ 0x9af4,0x8c5f,0,0,0x967a,0x9af3,0,0x9385, 0x9af7,0,0x9af6,0xf264,0,0x8889,0,0xf265, /* '奐','契',0,0,'奔','奕',0,'套', '奘',0,'奚','奛',0,'奝',0,'奟', */
	/* 5960 */ 0x9af9,0,0x9af8,0,0,0x899c,0,0x9afa, 0x8fa7,0x9afc,0x9244,0,0x9afb,0x888a,0x95b1,0, /* '奠',0,'奢',0,0,'奥',0,'奧', '奨','奩','奪',0,'奬','奭','奮',0, */
	/* 5970 */ 0,0,0,0x8f97,0x937a,0xf267,0xf268,0, 0x9b40,0,0,0,0xf269,0x8d44,0,0, /* 0,0,0,'女','奴','奵','奶',0, '奸',0,0,0,'奼','好',0,0, */
	/* 5980 */ 0,0x9b41,0x9440,0x94dc,0x96cf,0,0,0, 0,0,0x9444,0x888b,0,0x9b4a,0,0, /* 0,'妁','如','妃','妄',0,0,0, 0,0,'妊','妋',0,'妍',0,0, */
	/* 5990 */ 0,0,0x888c,0x8b57,0,0,0x9764,0, 0,0x96ad,0,0x9baa,0,0x9b42,0,0xf26a, /* 0,0,'妒','妓',0,0,'妖',0, 0,'妙',0,'妛',0,'妝',0,'妟', */
	/* 59a0 */ 0,0,0,0x9b45,0x888d,0x91c3,0,0, 0x9657,0,0,0,0x9369,0,0xf26b,0, /* 0,0,0,'妣','妤','妥',0,0, '妨',0,0,0,'妬',0,'妮',0, */
	/* 59b0 */ 0,0,0x9b46,0,0,0,0,0, 0,0x9685,0,0x8dc8,0xf26c,0,0x8fa8,0, /* 0,0,'妲',0,0,0,0,0, 0,'妹',0,'妻','妼',0,'妾',0, */
	/* 59c0 */ 0,0,0,0x888e,0,0,0x9b47,0, 0xf26d,0x8e6f,0,0x8e6e,0,0xf26e,0,0, /* 0,0,0,'姃',0,0,'姆',0, '姈','姉',0,'始',0,'姍',0,0, */
	/* 59d0 */ 0x88b7,0x8cc6,0x888f,0x90a9,0x88cf,0,0,0, 0,0x9b4b,0x9b4c,0,0x9b49,0x8890,0xf26f,0, /* '姐','姑','姒','姓','委',0,0,0, 0,'姙','姚',0,'姜','姝','姞',0, */
	/* 59e0 */ 0,0,0,0xf270,0xf271,0x8957,0x8aad,0xf272, 0x9b48,0,0x96c3,0x9550,0,0,0xf273,0, /* 0,0,0,'姣','姤','姥','姦','姧', '姨',0,'姪','姫',0,0,'姮',0, */
	/* 59f0 */ 0,0,0,0,0,0,0x88a6,0, 0xeff8,0,0,0x88f7,0,0,0,0x8e70, /* 0,0,0,0,0,0,'姶',0, '姸',0,0,'姻',0,0,0,'姿', */
	/* 5a00 */ 0,0x88d0,0,0x88a1,0,0,0,0, 0,0x9b51,0,0,0xf277,0xf278,0,0, /* 0,'威',0,'娃',0,0,0,0, 0,'娉',0,0,'娌','娍',0,0, */
	/* 5a10 */ 0,0x9b4f,0,0x8891,0,0,0,0xf279, 0x96ba,0,0x9b52,0,0x9b50,0,0,0x9b4e, /* 0,'娑',0,'娓',0,0,0,'娗', '娘',0,'娚',0,'娜',0,0,'娟', */
	/* 5a20 */ 0x9050,0,0,0x8892,0,0x9b4d,0,0xf27a, 0,0x95d8,0,0,0,0xf27b,0,0x8ce2, /* '娠',0,0,'娣',0,'娥',0,'娧', 0,'娩',0,0,0,'娭',0,'娯', */
	/* 5a30 */ 0,0,0,0,0,0x9b56,0x9b57,0, 0,0,0,0,0x8fa9,0,0,0, /* 0,0,0,0,0,'娵','娶',0, 0,0,0,0,'娼',0,0,0, */
	/* 5a40 */ 0x9b53,0x984b,0,0,0,0,0x946b,0, 0,0x9b55,0,0,0,0,0,0, /* '婀','婁',0,0,0,0,'婆',0, 0,'婉',0,0,0,0,0,0, */
	/* 5a50 */ 0,0,0,0,0,0xf27c,0,0, 0,0,0x8da5,0,0,0,0,0, /* 0,0,0,0,0,'婕',0,0, 0,0,'婚',0,0,0,0,0, */
	/* 5a60 */ 0,0,0x9b58,0,0,0xf27d,0x9577,0x8893, 0,0,0x9b59,0,0x9b54,0x8894,0,0, /* 0,0,'婢',0,0,'婥','婦','婧', 0,0,'婪',0,'婬','婭',0,0, */
	/* 5a70 */ 0,0,0,0,0,0,0,0x8895, 0,0,0xf27e,0,0,0,0x8896,0x96b9, /* 0,0,0,0,0,0,0,'婷', 0,0,'婺',0,0,0,'婾','婿', */
	/* 5a80 */ 0,0,0,0,0x8897,0,0,0, 0,0,0,0xf280,0,0,0,0, /* 0,0,0,0,'媄',0,0,0, 0,0,0,'媋',0,0,0,0, */
	/* 5a90 */ 0,0,0x947d,0,0,0,0,0, 0,0,0x9b5a,0x9551,0xf281,0,0x8898,0xf282, /* 0,0,'媒',0,0,0,0,0, 0,0,'媚','媛','媜',0,'媞','媟', */
	/* 5aa0 */ 0xf283,0,0xf284,0,0,0,0,0x8899, 0,0,0,0,0,0,0,0, /* '媠',0,'媢',0,0,0,0,'媧', 0,0,0,0,0,0,0,0, */
	/* 5ab0 */ 0,0xf285,0,0xf286,0,0xf287,0,0, 0,0,0xf288,0,0x9b5b,0x9b5f,0x9b5c,0xf289, /* 0,'媱',0,'媳',0,'媵',0,0, 0,0,'媺',0,'媼','媽','媾','媿', */
	/* 5ac0 */ 0,0x89c5,0x9b5e,0,0x889a,0,0,0, 0,0x8eb9,0,0x9b5d,0x8c99,0,0,0, /* 0,'嫁','嫂',0,'嫄',0,0,0, 0,'嫉',0,'嫋','嫌',0,0,0, */
	/* 5ad0 */ 0x9b6b,0,0,0,0,0,0x9b64,0x9b61, 0,0,0xf28a,0,0xf28b,0,0,0, /* '嫐',0,0,0,0,0,'嫖','嫗', 0,0,'嫚',0,'嫜',0,0,0, */
	/* 5ae0 */ 0xf28c,0x9284,0,0x9b60,0,0xf28d,0x9b62,0, 0,0x9b63,0,0,0,0,0xf28f,0, /* '嫠','嫡',0,'嫣',0,'嫥','嫦',0, 0,'嫩',0,0,0,0,'嫮',0, */
	/* 5af0 */ 0xf28e,0,0,0,0,0xf290,0,0, 0,0,0x9b65,0x9b66,0,0,0,0, /* '嫰',0,0,0,0,'嫵',0,0, 0,0,'嫺','嫻',0,0,0,0, */
	/* 5b00 */ 0xf291,0,0,0,0,0,0,0, 0xf292,0x8af0,0,0x9b68,0x9b67,0,0,0, /* '嬀',0,0,0,0,0,0,0, '嬈','嬉',0,'嬋','嬌',0,0,0, */
	/* 5b10 */ 0,0,0,0,0,0,0x9b69,0xf293, 0,0x889c,0,0,0,0,0,0, /* 0,0,0,0,0,0,'嬖','嬗', 0,'嬙',0,0,0,0,0,0, */
	/* 5b20 */ 0,0,0x8fec,0,0,0x889d,0,0, 0,0,0x9b6c,0,0x92da,0xf295,0,0, /* 0,0,'嬢',0,0,'嬥',0,0, 0,0,'嬪',0,'嬬','嬭',0,0, */
	/* 5b30 */ 0x8964,0,0x9b6a,0,0xf294,0,0x9b6d,0, 0,0,0,0,0,0,0x9b6e,0, /* '嬰',0,'嬲',0,'嬴',0,'嬶',0, 0,0,0,0,0,0,'嬾',0, */
	/* 5b40 */ 0x9b71,0x9874,0,0x9b6f,0,0x9b70,0,0, 0,0,0,0,0xf296,0,0,0, /* '孀','孁',0,'孃',0,'孅',0,0, 0,0,0,0,'孌',0,0,0, */
	/* 5b50 */ 0x8e71,0x9b72,0xf297,0,0x8d45,0x9b73,0x9875,0x8e9a, 0x91b6,0,0x9b74,0x9b75,0x8e79,0x8d46,0,0x96d0, /* '子','孑','孒',0,'孔','孕','孖','字', '存',0,'孚','孛','孜','孝',0,'孟', */
	/* 5b60 */ 0,0,0,0x8b47,0x8cc7,0x9b76,0x8a77,0, 0xf298,0x9b77,0,0x91b7,0,0,0,0xf299, /* 0,0,0,'季','孤','孥','学',0, '孨','孩',0,'孫',0,0,0,'孯', */
	/* 5b70 */ 0x9b78,0x9ba1,0,0x9b79,0,0x9b7a,0,0, 0x9b7b,0,0x9b7d,0,0xf29a,0x9876,0,0xf29b, /* '孰','孱',0,'孳',0,'孵',0,0, '學',0,'孺',0,'孼','孽',0,'孿', */
	/* 5b80 */ 0x9b7e,0xf29c,0,0x9b80,0xf29d,0x91ee,0,0x8946, 0x8ee7,0x88c0,0,0x9176,0x8aae,0x8eb3,0,0x8d47, /* '宀','宁',0,'它','宄','宅',0,'宇', '守','安',0,'宋','完','宍',0,'宏', */
	/* 5b90 */ 0,0,0,0x9877,0,0x9386,0xf09f,0x8f40, 0x8aaf,0x9288,0x92e8,0x88b6,0x8b58,0x95f3,0,0x8ec0, /* 0,0,0,'宓',0,'宕','宖','宗', '官','宙','定','宛','宜','宝',0,'実', */
	/* 5ba0 */ 0,0,0x8b71,0x90e9,0x8eba,0x9747,0x9b81,0, 0,0,0,0,0xf0a0,0,0x8b7b,0, /* 0,0,'客','宣','室','宥','宦',0, 0,0,0,0,'宬',0,'宮',0, */
	/* 5bb0 */ 0x8dc9,0,0,0x8a51,0x8983,0x8faa,0x89c6,0, 0x9b82,0x9765,0,0,0,0,0,0x8f68, /* '宰',0,0,'害','宴','宵','家',0, '宸','容',0,0,0,0,0,'宿', */
	/* 5bc0 */ 0xf0a2,0,0x8ee2,0x9b83,0x8af1,0x93d0,0x96a7,0x9b84, 0,0x9b85,0,0,0x9578,0,0xf0a4,0, /* '寀',0,'寂','寃','寄','寅','密','寇', 0,'寉',0,0,'富',0,'寎',0, */
	/* 5bd0 */ 0x9b87,0,0x8aa6,0x8bf5,0x9b86,0,0xf0a5,0, 0x9878,0,0,0x8ab0,0,0x9051,0x9b8b,0x8e40, /* '寐',0,'寒','寓','寔',0,'寖',0, '寘',0,0,'寛',0,'寝','寞','察', */
	/* 5be0 */ 0,0x89c7,0x9b8a,0,0x9b88,0x9b8c,0x9b89,0x944a, 0x9ecb,0x9052,0,0x9b8d,0x9879,0,0x97be,0, /* 0,'寡','寢',0,'寤','寥','實','寧', '寨','審',0,'寫','寬',0,'寮',0, */
	/* 5bf0 */ 0x9b8e,0xf0a8,0,0x9b90,0,0x929e,0x9b8f,0, 0x90a1,0,0x8e9b,0,0,0xf0a9,0x91ce,0x8ef5, /* '寰','寱',0,'寳',0,'寵','寶',0, '寸',0,'寺',0,0,'寽','対','寿', */
	/* 5c00 */ 0,0x9595,0x90ea,0xf0ab,0x8ecb,0x9b91,0x8fab,0x9b92, 0x9b93,0x88d1,0x91b8,0x9071,0,0x9b94,0x93b1,0x8fac, /* 0,'封','専','尃','射','尅','将','將', '專','尉','尊','尋',0,'對','導','小', */
	/* 5c10 */ 0,0x8fad,0x987a,0x9b95,0,0,0x90eb,0, 0,0,0x8fae,0,0,0,0x987b,0, /* 0,'少','尒','尓',0,0,'尖',0, 0,0,'尚',0,0,0,'尞',0, */
	/* 5c20 */ 0x9b96,0,0x9b97,0x987c,0x96de,0,0,0, 0x9b98,0xf0ac,0,0x987d,0,0x8bc4,0,0, /* '尠',0,'尢','尣','尤',0,0,0, '尨','尩',0,'尫',0,'尭',0,0, */
	/* 5c30 */ 0xf0ad,0x8f41,0,0,0,0,0,0, 0x9b99,0x9b9a,0x8eda,0x904b,0x93f2,0x9073,0x94f6,0x9441, /* '尰','就',0,0,0,0,0,0, '尸','尹','尺','尻','尼','尽','尾','尿', */
	/* 5c40 */ 0x8bc7,0x9b9b,0,0,0,0x8b8f,0x9b9c,0, 0x8bfc,0,0x93cd,0x89ae,0,0x8e72,0x9b9d,0x9ba0, /* '局','屁',0,0,0,'居','屆',0, '屈',0,'届','屋',0,'屍','屎','屏', */
	/* 5c50 */ 0x9b9f,0x8bfb,0,0x9b9e,0,0x9357,0,0, 0,0,0,0xeff9,0,0,0x91ae,0xf0af, /* '屐','屑',0,'屓',0,'展',0,0, 0,0,0,'屛',0,0,'属','屟', */
	/* 5c60 */ 0x936a,0x8ec6,0x9880,0xf0b0,0x9177,0x979a,0,0xf0b1, 0xf0b2,0xf0b3,0,0,0x9ba2,0,0x9ba3,0x93d4, /* '屠','屡','屢','屣','層','履',0,'屧', '屨','屩',0,0,'屬',0,'屮','屯', */
	/* 5c70 */ 0xf0b4,0x8e52,0,0,0,0,0x9ba5,0, 0,0x9ba6,0x9884,0,0xf0b7,0,0,0, /* '屰','山',0,0,0,0,'屶',0, 0,'屹','屺',0,'屼',0,0,0, */
	/* 5c80 */ 0,0,0,0,0,0,0,0, 0xf0ba,0,0xf0bb,0,0x9ba7,0,0,0x9885, /* 0,0,0,0,0,0,0,0, '岈',0,'岊',0,'岌',0,0,'岏', */
	/* 5c90 */ 0x8af2,0x9ba8,0,0,0x9ba9,0,0,0, 0,0,0,0,0,0,0,0x9886, /* '岐','岑',0,0,'岔',0,0,0, 0,0,0,0,0,0,0,'岟', */
	/* 5ca0 */ 0xf0bf,0x89aa,0xf0c0,0x9887,0,0,0xf0c1,0xf0c2, 0x915a,0x8ae2,0x9888,0x9bab,0x96a6,0xf0c4,0,0, /* '岠','岡','岢','岣',0,0,'岦','岧', '岨','岩','岪','岫','岬','岭',0,0, */
	/* 5cb0 */ 0,0x91d0,0,0x8a78,0,0xf0c5,0x9bad,0x9baf, 0x8add,0,0x9889,0x9bac,0x9bae,0,0x9bb1,0, /* 0,'岱',0,'岳',0,'岵','岶','岷', '岸',0,'岺','岻','岼',0,'岾',0, */
	/* 5cc0 */ 0,0,0,0,0,0x9bb0,0,0x9bb2, 0,0xf0c7,0,0x988a,0,0,0,0, /* 0,0,0,0,0,'峅',0,'峇', 0,'峉',0,'峋',0,0,0,0, */
	/* 5cd0 */ 0x988b,0,0x988c,0,0,0,0,0, 0,0x9bb3,0,0,0,0,0,0, /* '峐',0,'峒',0,0,0,0,0, 0,'峙',0,0,0,0,0,0, */
	/* 5ce0 */ 0x93bb,0x8bac,0,0,0,0,0,0, 0x89e3,0x9bb4,0x9bb9,0,0,0x9bb7,0,0x95f5, /* '峠','峡',0,0,0,0,0,0, '峨','峩','峪',0,0,'峭',0,'峯', */
	/* 5cf0 */ 0x95f4,0,0,0,0x988d,0,0x9387,0, 0,0,0x9bb6,0x8f73,0,0x9bb5,0,0, /* '峰',0,0,0,'峴',0,'島',0, 0,0,'峺','峻',0,'峽',0,0, */
	/* 5d00 */ 0,0,0,0,0,0,0xf0ca,0x9092, 0,0,0,0x9bba,0,0x9890,0x8de8,0, /* 0,0,0,0,0,0,'崆','崇', 0,0,0,'崋',0,'崍','崎',0, */
	/* 5d10 */ 0xf0cb,0x9bc0,0,0,0x9bc1,0x9bbb,0x8a52,0x9bbc, 0x9bc5,0x9bc4,0x9bc3,0x9bbf,0,0xf0cd,0,0x9bbe, /* '崐','崑',0,0,'崔','崕','崖','崗', '崘','崙','崚','崛',0,'崝',0,'崟', */
	/* 5d20 */ 0xf0ce,0,0x9bc2,0,0xf0cf,0,0xf0d0,0x9891, 0,0x95f6,0,0xf0cc,0,0,0,0, /* '崠',0,'崢',0,'崤',0,'崦','崧', 0,'崩',0,'崫',0,0,0,0, */
	/* 5d30 */ 0,0xf0d1,0,0,0,0,0,0, 0,0xf0d2,0,0,0,0,0,0, /* 0,'崱',0,0,0,0,0,0, 0,'崹',0,0,0,0,0,0, */
	/* 5d40 */ 0,0,0xf0d3,0,0,0,0x9893,0x9894, 0,0,0x9896,0x9bc9,0x9bc6,0,0x9bc8,0, /* 0,0,'嵂',0,0,0,'嵆','嵇', 0,0,'嵊','嵋','嵌',0,'嵎',0, */
	/* 5d50 */ 0x9792,0,0x9bc7,0x9895,0,0,0,0, 0,0,0,0,0x9bbd,0,0,0, /* '嵐',0,'嵒','嵓',0,0,0,0, 0,0,0,0,'嵜',0,0,0, */
	/* 5d60 */ 0,0xf0d5,0,0,0,0,0,0, 0,0x9093,0xf0d6,0,0x9bca,0x9897,0,0x8db5, /* 0,'嵡',0,0,0,0,0,0, 0,'嵩','嵪',0,'嵬','嵭',0,'嵯', */
	/* 5d70 */ 0xf0d8,0,0,0x9bcb,0,0,0x9bcc,0, 0,0,0,0,0,0,0,0, /* '嵰',0,0,'嵳',0,0,'嵶',0, 0,0,0,0,0,0,0,0, */
	/* 5d80 */ 0,0x9898,0x9bcf,0,0x9bce,0,0,0x9bcd, 0xf0db,0,0,0x9388,0x9bb8,0,0,0, /* 0,'嶁','嶂',0,'嶄',0,0,'嶇', '嶈',0,0,'嶋','嶌',0,0,0, */
	/* 5d90 */ 0x9bd5,0,0xf0dd,0,0xf0de,0,0,0xf0df, 0,0xf0e0,0,0,0,0x9bd1,0,0, /* '嶐',0,'嶒',0,'嶔',0,0,'嶗', 0,'嶙',0,0,0,'嶝',0,0, */
	/* 5da0 */ 0x9899,0,0x9bd0,0,0x989a,0,0,0x989b, 0,0,0,0,0x9bd2,0,0x9bd3,0, /* '嶠',0,'嶢',0,'嶤',0,0,'嶧', 0,0,0,0,'嶬',0,'嶮',0, */
	/* 5db0 */ 0xf0e1,0,0xf0e2,0,0xf0e3,0,0,0x9bd6, 0x989c,0xf0e5,0x97e4,0,0x9bd7,0x9bd4,0,0, /* '嶰',0,'嶲',0,'嶴',0,0,'嶷', '嶸','嶹','嶺',0,'嶼','嶽',0,0, */
	/* 5dc0 */ 0,0,0,0,0,0,0,0, 0,0x9bd8,0,0x989d,0x8ade,0x9bd9,0,0, /* 0,0,0,0,0,0,0,0, 0,'巉',0,'巋','巌','巍',0,0, */
	/* 5dd0 */ 0,0xf0e6,0x9bdb,0x9bda,0,0,0x9bdc,0xf0e7, 0xf0e8,0,0,0x9bdd,0,0x90ec,0x8f42,0, /* 0,'巑','巒','巓',0,0,'巖','巗', '巘',0,0,'巛',0,'川','州',0, */
	/* 5de0 */ 0xf0e9,0x8f84,0xeaa6,0x9183,0xf0eb,0x8d48,0x8db6,0x8d49, 0x8b90,0xf0ec,0,0x9bde,0,0,0x8db7,0, /* '巠','巡','巢','巣','巤','工','左','巧', '巨','巩',0,'巫',0,0,'差',0, */
	/* 5df0 */ 0,0x8cc8,0x9bdf,0x96a4,0x9462,0x9be0,0,0x8d4a, 0,0,0,0x8aaa,0,0x9246,0x8bd0,0, /* 0,'己','已','巳','巴','巵',0,'巷', 0,0,0,'巻',0,'巽','巾',0, */
	/* 5e00 */ 0xf0ee,0,0x8e73,0x957a,0,0,0x94bf,0, 0,0,0,0x9be1,0x8af3,0,0,0, /* '帀',0,'市','布',0,0,'帆',0, 0,0,0,'帋','希',0,0,0, */
	/* 5e10 */ 0,0x9be4,0xf0f0,0,0xeaa7,0xf0f1,0x929f,0, 0xeaa8,0x9be3,0x9be2,0x9be5,0,0x92e9,0,0xf0f3, /* 0,'帑','帒',0,'帔','帕','帖',0, '帘','帙','帚','帛',0,'帝',0,'帟', */
	/* 5e20 */ 0,0,0,0,0,0x9083,0,0, 0,0,0,0x8e74,0,0x90c8,0xf0f4,0x91d1, /* 0,0,0,0,0,'帥',0,0, 0,0,0,'師',0,'席','帮','帯', */
	/* 5e30 */ 0x8b41,0,0,0x92a0,0,0,0x9be6,0x9be7, 0x8fed,0,0,0,0,0x9658,0xf0f5,0, /* '帰',0,0,'帳',0,0,'帶','帷', '常',0,0,0,0,'帽','帾',0, */
	/* 5e40 */ 0x9bea,0,0,0x9be9,0x9be8,0x959d,0,0x9bf1, 0,0xf0f6,0,0,0x9679,0,0x9beb,0, /* '幀',0,0,'幃','幄','幅',0,'幇', 0,'幉',0,0,'幌',0,'幎',0, */
	/* 5e50 */ 0,0,0,0,0x9bed,0x968b,0xf0f8,0x9bec, 0xeaa9,0,0,0,0,0,0xeaaa,0x9bee, /* 0,0,0,0,'幔','幕','幖','幗', '幘',0,0,0,0,0,'幞','幟', */
	/* 5e60 */ 0,0x94a6,0x9bef,0x95bc,0x9bf0,0,0,0, 0,0,0,0xf0fa,0xf0fb,0xf0fc,0xf29f,0, /* 0,'幡','幢','幣','幤',0,0,0, 0,0,0,'幫','幬','幭','幮',0, */
	/* 5e70 */ 0,0,0x8ab1,0x95bd,0x944e,0x9bf2,0x9bf3,0xeffa, 0x8d4b,0x8ab2,0x9bf4,0x8cb6,0x9763,0x9748,0x8af4,0x9bf6, /* 0,0,'干','平','年','幵','并','幷', '幸','幹','幺','幻','幼','幽','幾','广', */
	/* 5e80 */ 0,0x92a1,0,0x8d4c,0x8faf,0,0,0x94dd, 0,0,0x8fb0,0,0,0,0,0x8f98, /* 0,'庁',0,'広','庄',0,0,'庇', 0,0,'床',0,0,0,0,'序', */
	/* 5e90 */ 0,0,0,0,0,0x92ea,0x95f7,0x9358, 0,0,0x8d4d,0,0x957b,0,0,0, /* 0,0,0,0,0,'底','庖','店', 0,0,'庚',0,'府',0,0,0, */
	/* 5ea0 */ 0x9bf7,0,0,0,0,0xf2a1,0x9378,0x8dc0, 0,0,0xf2a2,0x8cc9,0xf2a3,0x92eb,0,0, /* '庠',0,0,0,0,'庥','度','座', 0,0,'庪','庫','庬','庭',0,0, */
	/* 5eb0 */ 0,0,0,0,0,0x88c1,0x8f8e,0x8d4e, 0x9766,0xf2a4,0,0,0,0,0xeaab,0xf2a5, /* 0,0,0,0,0,'庵','庶','康', '庸','庹',0,0,0,0,'庾','庿', */
	/* 5ec0 */ 0,0x9bf8,0x9bf9,0x9470,0,0,0xf2a6,0, 0x9bfa,0x97f5,0x984c,0xeaad,0,0,0,0x9bfc, /* 0,'廁','廂','廃',0,0,'廆',0, '廈','廉','廊','廋',0,0,0,'廏', */
	/* 5ed0 */ 0x9bfb,0,0xf2a7,0x8a66,0,0,0x9c40,0, 0,0xf2a8,0x9c43,0x9c44,0,0x9c42,0,0x955f, /* '廐',0,'廒','廓',0,0,'廖',0, 0,'廙','廚','廛',0,'廝',0,'廟', */
	/* 5ee0 */ 0x8fb1,0x9c46,0x9c45,0x9c41,0,0,0,0, 0x9c47,0x9c48,0,0,0x9c49,0,0,0, /* '廠','廡','廢','廣',0,0,0,0, '廨','廩',0,0,'廬',0,0,0, */
	/* 5ef0 */ 0x9c4c,0x9c4a,0,0x9c4b,0x9c4d,0,0x8984,0x92ec, 0x9c4e,0xeaae,0x8c9a,0x89f4,0x9455,0xf2aa,0x9c4f,0x93f9, /* '廰','廱',0,'廳','廴',0,'延','廷', '廸','廹','建','廻','廼','廽','廾','廿', */
	/* 5f00 */ 0xeaaf,0x95d9,0xeab0,0x9c50,0x984d,0,0,0xeab1, 0xf2ab,0x9c51,0x95be,0x9c54,0x989f,0x98af,0xf2ac,0x8eae, /* '开','弁','异','弃','弄',0,0,'弇', '弈','弉','弊','弋','弌','弍','弎','式', */
	/* 5f10 */ 0x93f3,0x9c55,0,0x8b7c,0x92a2,0x88f8,0x9c56,0x95a4, 0x8d4f,0,0,0x926f,0xf2ad,0xeab2,0xf2af,0x92ed, /* '弐','弑',0,'弓','弔','引','弖','弗', '弘',0,0,'弛','弜','弝','弞','弟', */
	/* 5f20 */ 0,0,0,0xeab3,0,0x96ed,0x8cb7,0x8cca, 0,0x9c57,0,0,0,0x9c58,0,0x9c5e, /* 0,0,0,'弣',0,'弥','弦','弧', 0,'弩',0,0,0,'弭',0,'弯', */
	/* 5f30 */ 0,0x8ee3,0,0,0xeab4,0x92a3,0xeab5,0x8bad, 0x9c59,0,0,0,0x954a,0xeab6,0x9265,0, /* 0,'弱',0,0,'弴','張','弶','強', '弸',0,0,0,'弼','弽','弾',0, */
	/* 5f40 */ 0xeab7,0x9c5a,0,0,0,0xeab8,0,0xf2b0, 0x9c5b,0,0x8bae,0,0x9c5c,0,0x9c5d,0, /* '彀','彁',0,0,0,'彅',0,'彇', '彈',0,'彊',0,'彌',0,'彎',0, */
	/* 5f50 */ 0,0x9c5f,0,0x9396,0xeab9,0,0x9c60,0x9c61, 0xeaba,0x9c62,0,0,0x9c53,0x9c52,0,0, /* 0,'彑',0,'当','彔',0,'彖','彗', '彘','彙',0,0,'彜','彝',0,0, */
	/* 5f60 */ 0,0x9c63,0x8c60,0xf2b1,0xeabb,0,0x9546,0xeabc, 0,0x8dca,0x9556,0x92a4,0x956a,0x9c64,0,0, /* 0,'彡','形','彣','彤',0,'彦','彧', 0,'彩','彪','彫','彬','彭',0,0, */
	/* 5f70 */ 0x8fb2,0x8965,0xf2b2,0x9c65,0,0,0,0x9c66, 0,0x96f0,0,0,0x94de,0xeabd,0xf2b3,0x9c69, /* '彰','影','彲','彳',0,0,0,'彷', 0,'役',0,0,'彼','彽','彾','彿', */
	/* 5f80 */ 0x899d,0x90aa,0x9c68,0x9c67,0x8c61,0x91d2,0,0x9c6d, 0x9c6b,0xeabe,0x9c6a,0x97a5,0x8ce3,0,0,0xf2b4, /* '往','征','徂','徃','径','待',0,'徇', '很','徉','徊','律','後',0,0,'徏', */
	/* 5f90 */ 0x8f99,0x9c6c,0x936b,0x8f5d,0,0,0,0x93be, 0x9c70,0x9c6f,0,0,0xeabf,0,0x9c6e,0, /* '徐','徑','徒','従',0,0,0,'得', '徘','徙',0,0,'徜',0,'從',0, */
	/* 5fa0 */ 0x9c71,0x8ce4,0xf2b5,0,0xf2b6,0,0,0xeac0, 0x9c72,0x959c,0x8f7a,0,0,0x9c73,0x94f7,0xeac1, /* '徠','御','徢',0,'徤',0,0,'徧', '徨','復','循',0,0,'徭','微','徯', */
	/* 5fb0 */ 0,0,0,0x93bf,0x92a5,0xeac2,0,0xeac3, 0xf2b7,0x934f,0,0,0x9c74,0x8b4a,0,0, /* 0,0,0,'徳','徴','徵',0,'德', '徸','徹',0,0,'徼','徽',0,0, */
	/* 5fc0 */ 0,0,0,0x9053,0xf2b8,0x954b,0,0xf2ba, 0,0xeac4,0,0xf2bb,0x8af5,0x9445,0,0, /* 0,0,0,'心','忄','必',0,'忇', 0,'忉',0,'忋','忌','忍',0,0, */
	/* 5fd0 */ 0,0,0xf2bc,0xf2bd,0xf2be,0,0x9c75,0x8e75, 0x9659,0x965a,0,0,0x899e,0x9c7a,0xeac5,0, /* 0,0,'忒','忓','忔',0,'忖','志', '忘','忙',0,0,'応','忝','忞',0, */
	/* 5fe0 */ 0x9289,0xeac6,0xf2bf,0,0x9c77,0,0,0, 0,0xeac7,0,0x89f5,0,0,0xf2c0,0xf2c1, /* '忠','忡','忢',0,'忤',0,0,0, 0,'忩',0,'快',0,0,'忮','忯', */
	/* 5ff0 */ 0x9cab,0x9c79,0,0xf2c2,0,0x944f,0,0, 0x9c78,0,0,0x9c76,0xf2c3,0x8d9a,0,0x9c7c, /* '忰','忱',0,'忳',0,'念',0,0, '忸',0,0,'忻','忼','忽',0,'忿', */
	/* 6000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xeac8,0x9c83,0x9c89, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'怍','怎','怏', */
	/* 6010 */ 0x9c81,0,0x937b,0,0xeac9,0x9c86,0x957c,0xf2c5, 0xeaca,0x9c80,0,0x9c85,0x97e5,0x8e76,0,0, /* '怐',0,'怒',0,'怔','怕','怖','怗', '怘','怙',0,'怛','怜','思',0,0, */
	/* 6020 */ 0x91d3,0x9c7d,0xf2c6,0,0xf2c7,0x8b7d,0x9c88,0x90ab, 0x8985,0x9c82,0x89f6,0x9c87,0,0,0,0x8baf, /* '怠','怡','怢',0,'怤','急','怦','性', '怨','怩','怪','怫',0,0,0,'怯', */
	/* 6030 */ 0,0x9c84,0,0xeacb,0,0xeacc,0,0, 0,0,0x9c8a,0,0,0,0,0, /* 0,'怱',0,'怳',0,'怵',0,0, 0,0,'怺',0,0,0,0,0, */
	/* 6040 */ 0,0x9c8c,0x9c96,0x9c94,0,0,0x9c91,0xeacd, 0,0,0x9c90,0x97f6,0xf2c9,0x9c92,0,0, /* 0,'恁','恂','恃',0,0,'恆','恇', 0,0,'恊','恋','恌','恍',0,0, */
	/* 6050 */ 0x8bb0,0,0x8d50,0,0,0x8f9a,0,0, 0,0x9c99,0x9c8b,0,0,0,0,0x9c8f, /* '恐',0,'恒',0,0,'恕',0,0, 0,'恙','恚',0,0,0,0,'恟', */
	/* 6060 */ 0x9c7e,0,0x89f8,0x9c93,0x9c95,0x9270,0,0, 0x8da6,0x89b6,0x9c8d,0x9c98,0x9c97,0x8bb1,0,0x91a7, /* '恠',0,'恢','恣','恤','恥',0,0, '恨','恩','恪','恫','恬','恭',0,'息', */
	/* 6070 */ 0x8a86,0,0,0,0,0x8c62,0,0x9c8e, 0,0,0,0,0,0,0,0xf2ca, /* '恰',0,0,0,0,'恵',0,'恷', 0,0,0,0,0,0,0,'恿', */
	/* 6080 */ 0,0x9c9a,0,0x9c9d,0x9c9f,0,0,0, 0,0x8ebb,0xf2cb,0x9ca5,0x92ee,0x9c9b,0,0, /* 0,'悁',0,'悃','悄',0,0,0, 0,'悉','悊','悋','悌','悍',0,0, */
	/* 6090 */ 0,0,0x9ca3,0,0x89f7,0xf2cc,0x9ca1,0x9ca2, 0,0,0x9c9e,0x9ca0,0,0xeacf,0xead0,0x8ce5, /* 0,0,'悒',0,'悔','悕','悖','悗', 0,0,'悚','悛',0,'悝','悞','悟', */
	/* 60a0 */ 0x9749,0,0,0x8ab3,0,0,0x8978,0x9ca4, 0xf2cd,0x9459,0x88ab,0,0,0,0,0, /* '悠',0,0,'患',0,0,'悦','悧', '您','悩','悪',0,0,0,0,0, */
	/* 60b0 */ 0xf2cf,0xf2d0,0x94df,0x9c7b,0x9caa,0x9cae,0x96e3,0, 0x9ca7,0,0,0,0x9389,0x9cac,0xf2d1,0, /* '悰','悱','悲','悳','悴','悵','悶',0, '悸',0,0,0,'悼','悽','悾',0, */
	/* 60c0 */ 0,0,0,0,0,0x8fee,0x9cad,0x93d5, 0xf2d2,0,0,0xead1,0,0,0,0, /* 0,0,0,0,0,'情','惆','惇', '惈',0,0,'惋',0,0,0,0, */
	/* 60d0 */ 0,0x9866,0,0x9ca9,0xead2,0xead3,0,0, 0x9caf,0xf2d3,0x8d9b,0xf2d4,0x90c9,0xead4,0,0x88d2, /* 0,'惑',0,'惓','惔','惕',0,0, '惘','惙','惚','惛','惜','惝',0,'惟', */
	/* 60e0 */ 0x9ca8,0x9ca6,0,0x9179,0,0,0,0x9c9c, 0x8e53,0,0,0,0,0,0xf2d5,0, /* '惠','惡',0,'惣',0,0,0,'惧', '惨',0,0,0,0,0,'惮',0, */
	/* 60f0 */ 0x91c4,0x9cbb,0xf2d6,0x917a,0x9cb6,0xf2d7,0x9cb3,0x9cb4, 0xead5,0x8ee4,0x9cb7,0x9cba,0,0,0,0, /* '惰','惱','惲','想','惴','惵','惶','惷', '惸','惹','惺','惻',0,0,0,0, */
	/* 6100 */ 0x9cb5,0x8f44,0,0x9cb8,0,0,0x9cb2,0, 0x96fa,0x96f9,0,0,0,0x9cbc,0x9cbd,0x88d3, /* '愀','愁',0,'愃',0,0,'愆',0, '愈','愉',0,0,0,'愍','愎','意', */
	/* 6110 */ 0xf2d8,0,0xf2d9,0xf2da,0,0x9cb1,0,0, 0,0xf2db,0x8bf0,0x88a4,0xead6,0,0xf2dc,0x8ab4, /* '愐',0,'愒','愓',0,'愕',0,0, 0,'愙','愚','愛','愜',0,'愞','感', */
	/* 6120 */ 0,0x9cb9,0,0,0,0,0,0x9cc1, 0x9cc0,0,0,0xead7,0x9cc5,0,0,0, /* 0,'愡',0,0,0,0,0,'愧', '愨',0,0,'愫','愬',0,0,0, */
	/* 6130 */ 0xead8,0,0,0,0x9cc6,0,0,0xead9, 0,0,0xf2dd,0,0x9cc4,0x9cc7,0x9cbf,0x9cc3, /* '愰',0,0,0,'愴',0,0,'愷', 0,0,'愺',0,'愼','愽','愾','愿', */
	/* 6140 */ 0,0xf2df,0x9cc8,0,0x9cc9,0,0xf2e0,0x9cbe, 0x8e9c,0,0x9cc2,0x91d4,0x8d51,0x9cb0,0x9054,0, /* 0,'慁','慂',0,'慄',0,'慆','慇', '慈',0,'慊','態','慌','慍','慎',0, */
	/* 6150 */ 0,0,0,0x9cd6,0,0x95e7,0,0, 0x9ccc,0x9ccd,0x9cce,0,0,0x9cd5,0,0x9cd4, /* 0,0,0,'慓',0,'慕',0,0, '慘','慙','慚',0,0,'慝',0,'慟', */
	/* 6160 */ 0xf2e1,0,0x969d,0x8ab5,0,0x9cd2,0,0x8c64, 0x8a53,0,0,0x9ccf,0,0,0x97b6,0x9cd1, /* '慠',0,'慢','慣',0,'慥',0,'慧', '慨',0,0,'慫',0,0,'慮','慯', */
	/* 6170 */ 0x88d4,0x9cd3,0,0x9cca,0x9cd0,0x9cd7,0x8c63,0x9ccb, 0,0,0,0,0xf2e2,0,0x977c,0, /* '慰','慱',0,'慳','慴','慵','慶','慷', 0,0,0,0,'慼',0,'慾',0, */
	/* 6180 */ 0,0,0x974a,0,0,0,0,0x9cda, 0,0,0x9cde,0,0,0xeadb,0x919e,0, /* 0,0,'憂',0,0,0,0,'憇', 0,0,'憊',0,0,'憍','憎',0, */
	/* 6190 */ 0x97f7,0x9cdf,0xf2e4,0xf2e5,0x9cdc,0,0x9cd9,0xf2e6, 0xf2e7,0x9cd8,0x9cdd,0,0,0,0,0, /* '憐','憑','憒','憓','憔',0,'憖','憗', '憘','憙','憚',0,0,0,0,0, */
	/* 61a0 */ 0,0,0,0,0x95ae,0xf2e8,0,0x93b2, 0xf2e9,0x8c65,0,0x9ce0,0x9cdb,0xf2ea,0x9ce1,0, /* 0,0,0,0,'憤','憥',0,'憧', '憨','憩',0,'憫','憬','憭','憮',0, */
	/* 61b0 */ 0,0,0x8c9b,0,0,0,0x89af,0, 0,0xeade,0x9ce9,0,0xeadd,0,0x8ab6,0, /* 0,0,'憲',0,0,0,'憶',0, 0,'憹','憺',0,'憼',0,'憾',0, */
	/* 61c0 */ 0,0,0,0x9ce7,0,0,0x9ce8,0x8da7, 0x9ce6,0x9ce4,0x9ce3,0x9cea,0x9ce2,0x9cec,0,0, /* 0,0,0,'懃',0,0,'懆','懇', '懈','應','懊','懋','懌','懍',0,0, */
	/* 61d0 */ 0x89f9,0,0,0,0,0xf2ec,0,0, 0,0,0,0,0,0xf2ed,0,0xf2ee, /* '懐',0,0,0,0,'懕',0,0, 0,0,0,0,0,'懝',0,'懟', */
	/* 61e0 */ 0,0,0,0x9cee,0,0,0x9ced,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'懣',0,0,'懦',0, 0,0,0,0,0,0,0,0, */
	/* 61f0 */ 0,0,0x92a6,0,0x9cf1,0xf2ef,0x9cef,0x9ce5, 0x8c9c,0,0x9cf0,0,0x9cf4,0x9cf3,0x9cf5,0x9cf2, /* 0,0,'懲',0,'懴','懵','懶','懷', '懸',0,'懺',0,'懼','懽','懾','懿', */
	/* 6200 */ 0x9cf6,0,0,0,0,0,0,0, 0x9cf7,0x9cf8,0x95e8,0,0x9cfa,0x9cf9,0x8f5e,0, /* '戀',0,0,0,0,0,0,0, '戈','戉','戊',0,'戌','戍','戎',0, */
	/* 6210 */ 0x90ac,0x89e4,0x89fa,0,0x9cfb,0xf2f1,0x88bd,0, 0,0,0x90ca,0x9cfc,0,0xe6c1,0x9d40,0x8c81, /* '成','我','戒',0,'戔','戕','或',0, 0,0,'戚','戛',0,'戝','戞','戟', */
	/* 6220 */ 0,0x9d41,0xeae0,0xf2f2,0,0,0x90ed,0, 0,0xf2f3,0x9d42,0,0,0,0x9d43,0x8b59, /* 0,'戡','戢','戣',0,0,'戦',0, 0,'戩','截',0,0,0,'戮','戯', */
	/* 6230 */ 0x9d44,0,0x9d45,0x9d46,0x91d5,0,0,0, 0x8ccb,0,0,0x96df,0,0,0xeae1,0x965b, /* '戰',0,'戲','戳','戴',0,0,0, '戸',0,0,'戻',0,0,'戾','房', */
	/* 6240 */ 0x8f8a,0x9d47,0,0xeae2,0,0,0xf2f4,0x90ee, 0xe7bb,0x94e0,0,0x8ee8,0xf2f5,0x8dcb,0x9d48,0, /* '所','扁',0,'扃',0,0,'扆','扇', '扈','扉',0,'手','扌','才','扎',0, */
	/* 6250 */ 0,0xf2f6,0xf2f7,0x91c5,0,0x95a5,0xeae3,0, 0x91ef,0,0xeae4,0x9d4b,0,0,0x9d49,0, /* 0,'扑','扒','打',0,'払','扖',0, '托',0,'扚','扛',0,0,'扞',0, */
	/* 6260 */ 0x9d4c,0xf2f8,0,0x9d4a,0xf2f9,0,0,0, 0x9d4d,0,0,0,0,0xf2fb,0x95af,0xeae5, /* '扠','扡',0,'扣','扤',0,0,0, '扨',0,0,0,0,'扭','扮','扯', */
	/* 6270 */ 0,0x88b5,0,0xf2fc,0,0,0x957d,0, 0,0x94e1,0,0xf2fa,0x9d4e,0,0x9d51,0x8fb3, /* 0,'扱',0,'扳',0,0,'扶',0, 0,'批',0,'扻','扼',0,'找','承', */
	/* 6280 */ 0x8b5a,0,0x9d4f,0x9d56,0x8fb4,0xeae6,0,0, 0,0x9d50,0x9463,0,0,0,0,0, /* '技',0,'抂','抃','抄','抅',0,0, 0,'抉','把',0,0,0,0,0, */
	/* 6290 */ 0,0x977d,0x9d52,0x9d53,0x9d57,0x938a,0x9d54,0x8d52, 0x90dc,0xf340,0,0x9d65,0x94b2,0,0x91f0,0, /* 0,'抑','抒','抓','抔','投','抖','抗', '折','抙',0,'抛','抜',0,'択',0, */
	/* 62a0 */ 0,0,0,0,0,0,0xf341,0, 0,0,0,0x94e2,0x9dab,0,0,0, /* 0,0,0,0,0,0,'抦',0, 0,0,0,'披','抬',0,0,0, */
	/* 62b0 */ 0,0x95f8,0,0,0,0x92ef,0,0, 0,0x9695,0,0x9d5a,0x899f,0x928a,0,0, /* 0,'抱',0,0,0,'抵',0,0, 0,'抹',0,'抻','押','抽',0,0, */
	/* 62c0 */ 0,0,0x9d63,0,0xeae7,0x9253,0x9d5d,0x9d64, 0x9d5f,0x9d66,0x9d62,0,0x9d61,0x948f,0,0x9d5b, /* 0,0,'拂',0,'拄','担','拆','拇', '拈','拉','拊',0,'拌','拍',0,'拏', */
	/* 62d0 */ 0x89fb,0x9d59,0x8b91,0x91f1,0x9d55,0xf342,0xeae8,0x9d58, 0x8d53,0x90d9,0,0x8fb5,0x9d60,0x9471,0,0, /* '拐','拑','拒','拓','拔','拕','拖','拗', '拘','拙',0,'招','拜','拝',0,0, */
	/* 62e0 */ 0x8b92,0x8a67,0,0,0,0,0,0, 0,0,0,0,0x8a87,0x9040,0x9d68,0x9d6d, /* '拠','拡',0,0,0,0,0,0, 0,0,0,0,'括','拭','拮','拯', */
	/* 62f0 */ 0,0x9d69,0,0x8c9d,0,0x9d6e,0x8e41,0x8d89, 0,0,0,0,0xeae9,0xf344,0x8f45,0x9d5c, /* 0,'拱',0,'拳',0,'拵','拶','拷', 0,0,0,0,'拼','拽','拾','拿', */
	/* 6300 */ 0,0x8e9d,0x9d6b,0xf345,0,0,0,0x8e77, 0x9d6c,0x88c2,0xeaea,0,0x9d67,0xf346,0,0, /* 0,'持','挂','挃',0,0,0,'指', '挈','按','挊',0,'挌','挍',0,0, */
	/* 6310 */ 0xf347,0x92a7,0,0,0,0,0,0, 0xeaeb,0x8b93,0,0,0,0,0,0x8bb2, /* '挐','挑',0,0,0,0,0,0, '挘','挙',0,0,0,0,0,'挟', */
	/* 6320 */ 0,0,0,0,0,0,0,0x9d6a, 0x88a5,0,0,0x8dc1,0,0,0,0x9055, /* 0,0,0,0,0,0,0,'挧', '挨',0,0,'挫',0,0,0,'振', */
	/* 6330 */ 0,0,0xf34a,0,0,0xf34b,0,0, 0,0xeaec,0x92f0,0xf34c,0xf34d,0x94d2,0x9d70,0x917d, /* 0,0,'挲',0,0,'挵',0,0, 0,'挹','挺','挻','挼','挽','挾','挿', */
	/* 6340 */ 0,0xf34e,0,0xeaed,0xf34f,0,0,0, 0,0x91a8,0,0,0x8e4a,0x9d71,0xf350,0x9d73, /* 0,'捁',0,'捃','捄',0,0,0, 0,'捉',0,0,'捌','捍','捎','捏', */
	/* 6350 */ 0x9d6f,0,0,0,0,0x95df,0,0x92bb, 0,0xf352,0,0,0x917b,0,0,0, /* '捐',0,0,0,0,'捕',0,'捗', 0,'捙',0,0,'捜',0,0,0, */
	/* 6360 */ 0,0,0,0,0,0xeaee,0,0x95f9, 0x8ecc,0x9d80,0,0x9d7e,0xf355,0,0x9098,0, /* 0,0,0,0,0,'捥',0,'捧', '捨','捩',0,'捫','捬',0,'据',0, */
	/* 6370 */ 0,0,0x8c9e,0,0,0,0x9d78,0x8fb7, 0,0,0x93e6,0x9450,0xeaef,0,0,0, /* 0,0,'捲',0,0,0,'捶','捷', 0,0,'捺','捻','捼',0,0,0, */
	/* 6380 */ 0x9d76,0,0,0x917c,0xf356,0,0,0, 0x8ef6,0x9d7b,0,0,0x8fb6,0,0x9d75,0x9d7a, /* '掀',0,0,'掃','掄',0,0,0, '授','掉',0,0,'掌',0,'掎','掏', */
	/* 6390 */ 0,0,0x9472,0,0xf359,0,0x9d74,0, 0x8c40,0xf357,0,0x8a7c,0,0,0,0x9d7c, /* 0,0,'排',0,'掔',0,'掖',0, '掘','掙',0,'掛',0,0,0,'掟', */
	/* 63a0 */ 0x97a9,0x8dcc,0x9254,0x9d79,0,0x90da,0,0x8d54, 0x9084,0x8986,0x915b,0x9d77,0x8b64,0,0,0, /* '掠','採','探','掣',0,'接',0,'控', '推','掩','措','掫','掬',0,0,0, */
	/* 63b0 */ 0,0,0x8c66,0,0x92cd,0x9d7d,0,0, 0,0,0,0x917e,0,0xf35a,0x9d81,0, /* 0,0,'掲',0,'掴','掵',0,0, 0,0,0,'掻',0,'掽','掾',0, */
	/* 63c0 */ 0x9d83,0,0,0x91b5,0x9d89,0,0x9d84,0, 0,0x9d86,0,0,0,0,0,0x9560, /* '揀',0,0,'揃','揄',0,'揆',0, 0,'揉',0,0,0,0,0,'描', */
	/* 63d0 */ 0x92f1,0,0x9d87,0,0xf35c,0xf35d,0x974b,0, 0,0,0x9767,0x8ab7,0xf35e,0,0,0, /* '提',0,'插',0,'揔','揕','揖',0, 0,0,'揚','換','揜',0,0,0, */
	/* 63e0 */ 0xf35f,0x88ac,0,0x9d85,0,0xeaf0,0,0, 0,0x9d82,0,0xf360,0xf361,0xeaf1,0x8af6,0, /* '揠','握',0,'揣',0,'揥',0,0, 0,'揩',0,'揫','揬','揭','揮',0, */
	/* 63f0 */ 0,0,0xf362,0,0x8987,0xeaf2,0x9d88,0xf35b, 0,0,0x9768,0,0,0,0,0, /* 0,0,'揲',0,'援','揵','揶','揷', 0,0,'揺',0,0,0,0,0, */
	/* 6400 */ 0,0,0,0,0,0,0x9d8c,0, 0,0xf363,0,0,0,0x91b9,0,0x9d93, /* 0,0,0,0,0,0,'搆',0, 0,'搉',0,0,0,'損',0,'搏', */
	/* 6410 */ 0xeaf3,0,0,0x9d8d,0xeaf4,0,0x9d8a,0x9d91, 0,0,0,0,0x9d72,0,0xf364,0, /* '搐',0,0,'搓','搔',0,'搖','搗', 0,0,0,0,'搜',0,'搞',0, */
	/* 6420 */ 0,0,0xeaf5,0,0,0xf365,0x9d8e,0, 0x9d92,0xf366,0,0,0x94c0,0x938b,0,0xf367, /* 0,0,'搢',0,0,'搥','搦',0, '搨','搩',0,0,'搬','搭',0,'搯', */
	/* 6430 */ 0,0,0,0,0x9d8b,0,0x9d8f,0, 0,0,0x8c67,0,0,0,0x8def,0, /* 0,0,0,0,'搴',0,'搶',0, 0,0,'携',0,0,0,'搾',0, */
	/* 6440 */ 0,0,0x90db,0,0,0,0,0, 0,0,0,0,0,0,0x9d97,0, /* 0,0,'摂',0,0,0,0,0, 0,0,0,0,0,0,'摎',0, */
	/* 6450 */ 0,0xeaf7,0,0,0,0,0,0, 0x9345,0,0xf368,0xf369,0,0xf36a,0,0, /* 0,'摑',0,0,0,0,0,0, '摘',0,'摚','摛',0,'摝',0,0, */
	/* 6460 */ 0xeaf8,0,0,0,0,0,0,0x9d94, 0,0x9680,0,0,0,0xeaf9,0,0x9d95, /* '摠',0,0,0,0,0,0,'摧', 0,'摩',0,0,0,'摭',0,'摯', */
	/* 6470 */ 0,0,0,0xf36b,0,0,0x9d96,0, 0x96cc,0xeaf6,0x90a0,0,0,0xf36c,0,0, /* 0,0,0,'摳',0,0,'摶',0, '摸','摹','摺',0,0,'摽',0,0, */
	/* 6480 */ 0,0,0,0x8c82,0,0,0,0xf36d, 0x9d9d,0,0,0,0,0,0,0, /* 0,0,0,'撃',0,0,0,'撇', '撈',0,0,0,0,0,0,0, */
	/* 6490 */ 0,0xf36e,0x8e54,0x9d9a,0,0x9d99,0,0, 0,0,0x9451,0,0,0xf36f,0x93b3,0xf370, /* 0,'撑','撒','撓',0,'撕',0,0, 0,0,'撚',0,0,'撝','撞','撟', */
	/* 64a0 */ 0,0,0,0,0x9350,0x9d9b,0,0, 0,0x9d9c,0,0x958f,0,0x9464,0x8e42,0, /* 0,0,0,0,'撤','撥',0,0, 0,'撩',0,'撫',0,'播','撮',0, */
	/* 64b0 */ 0x90ef,0,0x966f,0,0,0,0,0, 0,0x8a68,0,0x9da3,0x9d9e,0,0xeafb,0xeafc, /* '撰',0,'撲',0,0,0,0,0, 0,'撹',0,'撻','撼',0,'撾','撿', */
	/* 64c0 */ 0,0x9769,0x9da5,0,0xeb40,0x9da1,0,0x9da2, 0,0,0xeb41,0xf371,0xf372,0x9180,0xeafa,0, /* 0,'擁','擂',0,'擄','擅',0,'擇', 0,0,'擊','擋','擌','操','擎',0, */
	/* 64d0 */ 0xeb42,0,0x9da0,0,0x9d5e,0xf373,0,0xf374, 0x9da4,0,0x9d9f,0,0,0,0,0, /* '擐',0,'擒',0,'擔','擕',0,'擗', '擘',0,'據',0,0,0,0,0, */
	/* 64e0 */ 0x9da9,0x9daa,0x9346,0x9dac,0xf376,0xf377,0x8e43,0x9da7, 0,0,0,0,0x8b5b,0,0,0x9dad, /* '擠','擡','擢','擣','擤','擥','擦','擧', 0,0,0,0,'擬',0,0,'擯', */
	/* 64f0 */ 0,0x9da6,0x9db1,0,0x9db0,0,0x9daf,0xeb43, 0,0,0x9db2,0xeb44,0,0x9db4,0x8fef,0xf378, /* 0,'擱','擲',0,'擴',0,'擶','擷', 0,0,'擺','擻',0,'擽','擾','擿', */
	/* 6500 */ 0x9db3,0,0,0,0xf379,0x9db7,0,0, 0,0,0,0,0,0,0,0xf37b, /* '攀',0,0,0,'攄','攅',0,0, 0,0,0,0,0,0,0,'攏', */
	/* 6510 */ 0,0,0,0,0xf37c,0,0xf37d,0, 0x9db5,0,0,0,0x9db6,0x9d90,0xf380,0, /* 0,0,0,0,'攔',0,'攖',0, '攘',0,0,0,'攜','攝','攞',0, */
	/* 6520 */ 0,0,0xeb45,0x9db9,0x9db8,0,0,0, 0,0xeb46,0x9d98,0x9dba,0x9dae,0,0,0x8e78, /* 0,0,'攢','攣','攤',0,0,0, 0,'攩','攪','攫','攬',0,0,'支', */
	/* 6530 */ 0,0,0xf381,0,0x9dbb,0x9dbc,0x9dbe,0x9dbd, 0x9dbf,0x89fc,0,0x8d55,0,0,0x95fa,0x90ad, /* 0,0,'攲',0,'攴','攵','收','攷', '攸','改',0,'攻',0,0,'放','政', */
	/* 6540 */ 0,0,0,0,0xf382,0x8ccc,0,0, 0x9dc1,0,0,0,0,0x9dc4,0,0x9571, /* 0,0,0,0,'敄','故',0,0, '效',0,0,0,0,'敍',0,'敏', */
	/* 6550 */ 0,0x8b7e,0,0,0xf383,0x9dc3,0x9dc2,0x9473, 0x9dc5,0x8bb3,0,0,0,0x9dc7,0x9dc6,0, /* 0,'救',0,0,'敔','敕','敖','敗', '敘','教',0,0,0,'敝','敞',0, */
	/* 6560 */ 0,0,0x8ab8,0x8e55,0,0,0x93d6,0xeb48, 0,0,0,0xf384,0x8c68,0,0,0, /* 0,0,'敢','散',0,0,'敦','敧', 0,0,0,'敫','敬',0,0,0, */
	/* 6570 */ 0x9094,0,0x9dc8,0,0x90ae,0x9347,0,0x957e, 0x9dc9,0,0xf385,0,0,0,0,0, /* '数',0,'敲',0,'整','敵',0,'敷', '數',0,'敺',0,0,0,0,0, */
	/* 6580 */ 0,0xf386,0x9dca,0x9dcb,0xf387,0xf388,0,0x95b6, 0x9b7c,0x90c4,0xf389,0,0x956b,0,0x8dd6,0, /* 0,'斁','斂','斃','斄','斅',0,'文', '斈','斉','斊',0,'斌',0,'斎',0, */
	/* 6590 */ 0x94e3,0x94c1,0,0,0,0,0,0x936c, 0,0x97bf,0,0x9dcd,0x8ece,0xeb49,0,0x9dce, /* '斐','斑',0,0,0,0,0,'斗', 0,'料',0,'斛','斜','斝',0,'斟', */
	/* 65a0 */ 0,0x88b4,0,0,0x8bd2,0x90cb,0,0x9580, 0,0,0,0x9dcf,0x8e61,0x9266,0,0x8e7a, /* 0,'斡',0,0,'斤','斥',0,'斧', 0,0,0,'斫','斬','断',0,'斯', */
	/* 65b0 */ 0x9056,0,0xf38a,0,0,0xf38b,0,0x9dd0, 0xf38c,0x95fb,0,0,0x8997,0x8e7b,0,0xf38d, /* '新',0,'斲',0,0,'斵',0,'斷', '斸','方',0,0,'於','施',0,'斿', */
	/* 65c0 */ 0,0x9dd3,0xf38e,0x9dd1,0x9dd4,0x97b7,0x9dd2,0, 0,0xf38f,0,0x90f9,0x9dd5,0,0,0x91b0, /* 0,'旁','旂','旃','旄','旅','旆',0, 0,'旉',0,'旋','旌',0,0,'族', */
	/* 65d0 */ 0,0,0x9dd6,0,0xf390,0,0,0x8af8, 0,0x9dd8,0,0x9dd7,0,0,0,0, /* 0,0,'旒',0,'旔',0,0,'旗', 0,'旙',0,'旛',0,0,0,0, */
	/* 65e0 */ 0x9dd9,0x9dda,0x8af9,0,0,0x93fa,0x9255,0x8b8c, 0x8e7c,0x9181,0,0,0x8f7b,0x88ae,0,0, /* '无','旡','既',0,0,'日','旦','旧', '旨','早',0,0,'旬','旭',0,0, */
	/* 65f0 */ 0,0x9ddb,0xf392,0,0,0,0,0, 0,0xf393,0x89a0,0x9ddf,0xf394,0,0,0, /* 0,'旱','旲',0,0,0,0,0, 0,'旹','旺','旻','旼',0,0,0, */
	/* 6600 */ 0xeb4b,0,0x8d56,0x9dde,0xf395,0,0x8da9,0x8fb8, 0xf396,0xeb4c,0x9ddd,0,0x8fb9,0,0x96be,0x8da8, /* '昀',0,'昂','昃','昄',0,'昆','昇', '昈','昉','昊',0,'昌',0,'明','昏', */
	/* 6610 */ 0,0,0,0x88d5,0x90cc,0xeb4d,0,0, 0,0,0,0,0x9de4,0,0xeb4e,0x90af, /* 0,0,0,'易','昔','昕',0,0, 0,0,0,0,'昜',0,'昞','星', */
	/* 6620 */ 0x8966,0xf397,0xeb50,0,0xeb51,0x8f74,0,0x9686, 0x8df0,0,0xf398,0xeb52,0,0x8fba,0,0x90a5, /* '映','昡','昢',0,'昤','春',0,'昧', '昨',0,'昪','昫',0,'昭',0,'是', */
	/* 6630 */ 0xeb53,0xeb54,0,0xeb55,0x9de3,0x9de1,0x9de2,0, 0,0,0xeb4f,0,0x928b,0,0,0x9e45, /* '昰','昱',0,'昳','昴','昵','昶',0, 0,0,'昺',0,'昼',0,0,'昿', */
	/* 6640 */ 0,0x9de8,0x8e9e,0x8d57,0x9de6,0xf399,0,0, 0xeb57,0x9de7,0,0x9057,0xeb58,0,0xf39b,0x9de5, /* 0,'晁','時','晃','晄','晅',0,0, '晈','晉',0,'晋','晌',0,'晎','晏', */
	/* 6650 */ 0,0xf39a,0x8e4e,0,0,0,0,0xf39e, 0,0xeb5a,0xeb5b,0xf39f,0,0x9dea,0x9de9,0x9dee, /* 0,'晑','晒',0,0,0,0,'晗', 0,'晙','晚','晛',0,'晝','晞','晟', */
	/* 6660 */ 0,0xeb5c,0x9def,0xf3a0,0x9deb,0xeb5d,0x8a41,0x9dec, 0x9ded,0x94d3,0xf3a3,0xf3a4,0xf3a5,0xf3a6,0x9581,0x8c69, /* 0,'晡','晢','晣','晤','晥','晦','晧', '晨','晩','晪','晫','晬','晭','普','景', */
	/* 6670 */ 0x9df0,0,0,0xeb5e,0x90b0,0,0x8fbb,0xeb5f, 0xeb60,0,0x9271,0xf3a7,0,0,0,0, /* '晰',0,0,'晳','晴',0,'晶','晷', '晸',0,'智','晻',0,0,0,0, */
	/* 6680 */ 0xf3a8,0x8bc5,0,0x9df1,0x9df5,0,0,0x89c9, 0x9df2,0x9df4,0,0,0,0xeb61,0x9df3,0, /* '暀','暁',0,'暃','暄',0,0,'暇', '暈','暉',0,0,0,'暍','暎',0, */
	/* 6690 */ 0xf3a9,0x8f8b,0xf3aa,0,0,0,0x9267,0x88c3, 0x9df6,0xf3ab,0,0,0,0x9df7,0,0, /* '暐','暑','暒',0,0,0,'暖','暗', '暘','暙',0,0,0,'暝',0,0, */
	/* 66a0 */ 0xeb63,0,0x92a8,0,0,0,0x97ef,0, 0,0,0,0x8e62,0,0xf3ad,0x95e9,0, /* '暠',0,'暢',0,0,0,'暦',0, 0,0,0,'暫',0,'暭','暮',0, */
	/* 66b0 */ 0,0xf3ae,0xeb64,0,0x965c,0xf3af,0,0, 0x9e41,0x9df9,0,0xeb65,0x9dfc,0,0x9dfb,0xf3b1, /* 0,'暱','暲',0,'暴','暵',0,0, '暸','暹',0,'暻','暼',0,'暾','暿', */
	/* 66c0 */ 0,0x9df8,0,0,0x9e40,0,0xeb66,0x93dc, 0xeb67,0x9dfa,0,0,0,0,0,0, /* 0,'曁',0,0,'曄',0,'曆','曇', '曈','曉',0,0,0,0,0,0, */
	/* 66d0 */ 0,0,0,0,0,0,0x9e42,0, 0,0x8f8c,0x9e43,0xeb69,0x976a,0x9498,0,0, /* 0,0,0,0,0,0,'曖',0, 0,'曙','曚','曛','曜','曝',0,0, */
	/* 66e0 */ 0x9e44,0,0,0,0,0,0x9e46,0, 0xeb6a,0x9e47,0,0,0xf3b3,0,0,0, /* '曠',0,0,0,0,0,'曦',0, '曨','曩',0,0,'曬',0,0,0, */
	/* 66f0 */ 0x9e48,0,0x8bc8,0x8967,0x8d58,0x9e49,0,0x9e4a, 0x8f91,0x9182,0xeb6b,0xeb56,0x99d6,0x915d,0x915c,0x91d6, /* '曰',0,'曲','曳','更','曵',0,'曷', '書','曹','曺','曻','曼','曽','曾','替', */
	/* 6700 */ 0x8dc5,0xf3b5,0,0x98f0,0,0xf3b6,0,0, 0x8c8e,0x974c,0,0x95fc,0,0x959e,0,0x9e4b, /* '最','朁',0,'會',0,'朅',0,0, '月','有',0,'朋',0,'服',0,'朏', */
	/* 6710 */ 0,0,0xf3b7,0xeb6c,0x8df1,0x92bd,0x9e4c,0x984e, 0,0xf3b9,0,0x965d,0,0x92a9,0x9e4d,0x8afa, /* 0,0,'朒','朓','朔','朕','朖','朗', 0,'朙',0,'望',0,'朝','朞','期', */
	/* 6720 */ 0,0,0,0,0,0,0x9e4e,0x9e4f, 0x96d8,0,0x96a2,0x9696,0x967b,0x8e44,0x9e51,0, /* 0,0,0,0,0,0,'朦','朧', '木',0,'未','末','本','札','朮',0, */
	/* 6730 */ 0,0x8ee9,0,0xeb6e,0x9670,0,0x9e53,0x9e56, 0x9e55,0,0x8af7,0,0,0x8b80,0,0x9e52, /* 0,'朱',0,'朳','朴',0,'朶','朷', '朸',0,'机',0,0,'朽',0,'朿', */
	/* 6740 */ 0,0x9e54,0,0,0,0,0x9e57,0xeb70, 0xeb71,0x9099,0,0,0xf3bc,0xf3bd,0x979b,0x88c7, /* 0,'杁',0,0,0,0,'杆','杇', '杈','杉',0,0,'杌','杍','李','杏', */
	/* 6750 */ 0x8dde,0x91ba,0,0x8edb,0xf3be,0,0x8ff1,0, 0,0x9e5a,0,0,0x936d,0xf3bf,0x9e58,0x91a9, /* '材','村',0,'杓','杔',0,'杖',0, 0,'杙',0,0,'杜','杝','杞','束', */
	/* 6760 */ 0x9e59,0x8ff0,0x96db,0x9e5b,0x9e5c,0x9788,0xeb6f,0, 0,0,0x9e61,0,0,0x8d59,0,0x9474, /* '杠','条','杢','杣','杤','来','杦',0, 0,0,'杪',0,0,'杭',0,'杯', */
	/* 6770 */ 0x9e5e,0x938c,0x9ddc,0x9de0,0xf3c3,0x8b6e,0xf3c4,0x9466, 0,0,0,0xeb72,0x9e60,0,0x8fbc,0x94c2, /* '杰','東','杲','杳','杴','杵','杶','杷', 0,0,0,'杻','杼',0,'松','板', */
	/* 6780 */ 0,0xeb73,0,0,0,0x9e66,0,0x94f8, 0,0x9e5d,0,0x9e63,0x9e62,0,0,0, /* 0,'极',0,0,0,'枅',0,'枇', 0,'枉',0,'枋','枌',0,0,0, */
	/* 6790 */ 0x90cd,0,0xf3c6,0xeb74,0,0x968d,0,0x97d1, 0xeb75,0,0x9687,0xeb76,0x89ca,0x8e7d,0,0, /* '析',0,'枒','枓',0,'枕',0,'林', '枘',0,'枚','枛','果','枝',0,0, */
	/* 67a0 */ 0x9867,0x9e65,0x9095,0,0,0,0x9e64,0, 0,0x9e5f,0,0,0,0,0,0x8ccd, /* '枠','枡','枢',0,0,0,'枦',0, 0,'枩',0,0,0,0,0,'枯', */
	/* 67b0 */ 0xf3ca,0,0xf3cb,0x9e6b,0x9e69,0,0x89cb,0x9e67, 0x9e6d,0x9e73,0,0xeb77,0,0,0,0, /* '枰',0,'枲','枳','枴',0,'架','枷', '枸','枹',0,'枻',0,0,0,0, */
	/* 67c0 */ 0xeb79,0x91c6,0,0xf3cc,0x95bf,0,0x9e75,0, 0xf3cd,0,0x9541,0,0,0,0x9e74,0x9490, /* '柀','柁',0,'柃','柄',0,'柆',0, '柈',0,'柊',0,0,0,'柎','柏', */
	/* 67d0 */ 0x965e,0x8ab9,0xf3ce,0x90f5,0x8f5f,0,0,0xeb7a, 0x92d1,0xf3cf,0x974d,0xf3d0,0,0x9e70,0x9e6f,0, /* '某','柑','柒','染','柔',0,0,'柗', '柘','柙','柚','柛',0,'柝','柞',0, */
	/* 67e0 */ 0,0,0x9e71,0,0x9e6e,0,0,0x9e76, 0,0x9e6c,0,0,0x9e6a,0,0x9e72,0x9e68, /* 0,0,'柢',0,'柤',0,0,'柧', 0,'柩',0,0,'柬',0,'柮','柯', */
	/* 67f0 */ 0xf3d1,0x928c,0,0x96f6,0x8ec4,0x8df2,0,0xf3d2, 0,0xeb78,0,0x8db8,0xeb7b,0,0x968f,0x8a60, /* '柰','柱',0,'柳','柴','柵',0,'柷', 0,'柹',0,'査','柼',0,'柾','柿', */
	/* 6800 */ 0,0xeb7c,0x92cc,0x93c8,0x8968,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'栁','栂','栃','栄',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6810 */ 0xf3c9,0,0,0x90f0,0,0,0x90b2,0x8c49, 0xf3d6,0,0,0,0,0xeb7e,0x9e78,0xf3d7, /* '栐',0,0,'栓',0,0,'栖','栗', '栘',0,0,0,0,'栝','栞','栟', */
	/* 6820 */ 0,0x8d5a,0x8a9c,0,0,0,0,0, 0,0x9e7a,0x8a94,0x9e81,0xeb80,0xf3d8,0,0, /* 0,'校','栢',0,0,0,0,0, 0,'栩','株','栫','栬','栭',0,0, */
	/* 6830 */ 0,0xeb81,0x9e7d,0xf3da,0x90f1,0,0,0, 0x8a6a,0x8daa,0,0xf3db,0x8a69,0x8dcd,0xf3dc,0, /* 0,'栱','栲','栳','栴',0,0,0, '核','根',0,'栻','格','栽','栾',0, */
	/* 6840 */ 0x9e7b,0x8c85,0x8c6a,0x938d,0xf3dd,0xf3de,0x9e79,0, 0x88c4,0xf3df,0,0,0xf3e0,0x9e7c,0x9e7e,0, /* '桀','桁','桂','桃','桄','桅','框',0, '案','桉',0,0,'桌','桍','桎',0, */
	/* 6850 */ 0x8bcb,0x8c4b,0xeb7d,0x8aba,0x8b6a,0xf3e1,0,0xf3e2, 0,0x9e82,0,0xeb82,0x8df7,0x9691,0,0x8e56, /* '桐','桑','桒','桓','桔','桕',0,'桗', 0,'桙',0,'桛','桜','桝',0,'桟', */
	/* 6860 */ 0,0,0,0x9e83,0,0,0,0x954f, 0,0,0,0xf3e4,0,0,0xf3e5,0, /* 0,0,0,'档',0,0,0,'桧', 0,0,0,'桫',0,0,'桮',0, */
	/* 6870 */ 0,0,0xeb83,0,0x9e8f,0xeb84,0x89b1,0x9e84, 0,0,0xf3e6,0,0xf3e7,0,0x9e95,0x9e85, /* 0,0,'桲',0,'桴','桵','桶','桷', 0,0,'桺',0,'桼',0,'桾','桿', */
	/* 6880 */ 0,0x97c0,0xf3e8,0x9e8c,0,0x947e,0,0, 0,0,0,0,0,0x9e94,0,0x9e87, /* 0,'梁','梂','梃',0,'梅',0,0, 0,0,0,0,0,'梍',0,'梏', */
	/* 6890 */ 0xf3e9,0,0,0x88b2,0x9e89,0,0xf3ea,0x8d5b, 0xf3ec,0xf3ed,0xf3ee,0x9e8b,0xf3ef,0x9e8a,0,0x9e86, /* '梐',0,0,'梓','梔',0,'梖','梗', '梘','梙','梚','梛','梜','條',0,'梟', */
	/* 68a0 */ 0x9e91,0,0x8fbd,0xeb86,0,0xeb87,0x9aeb,0x8ce6, 0x979c,0,0xf3f0,0xf3f1,0,0x9e88,0,0x92f2, /* '梠',0,'梢','梣',0,'梥','梦','梧', '梨',0,'梪','梫',0,'梭',0,'梯', */
	/* 68b0 */ 0x8a42,0x8dab,0xeb88,0x9e80,0xf3f2,0x9e90,0x8a81,0, 0,0x9e8e,0x9e92,0xf3f3,0x938e,0,0,0, /* '械','梱','梲','梳','梴','梵','梶',0, 0,'梹','梺','梻','梼',0,0,0, */
	/* 68c0 */ 0,0,0,0xf3f8,0x8afc,0xf3f9,0x9eb0,0, 0xeb89,0x96c7,0x9e97,0x8afb,0xf3fa,0x9e9e,0,0xf3fb, /* 0,0,0,'棃','棄','棅','棆',0, '棈','棉','棊','棋','棌','棍',0,'棏', */
	/* 68d0 */ 0xeb8a,0,0x965f,0,0x9e9f,0x9ea1,0xf3fc,0x9ea5, 0x9e99,0xf440,0x9249,0,0,0,0,0x938f, /* '棐',0,'棒',0,'棔','棕','棖','棗', '棘','棙','棚',0,0,0,0,'棟', */
	/* 68e0 */ 0x9ea9,0x9e9c,0,0x9ea6,0xf441,0xf442,0,0x9ea0, 0xeb8b,0,0,0,0xf443,0xeb8c,0x9058,0x9eaa, /* '棠','棡',0,'棣','棤','棥',0,'棧', '棨',0,0,0,'棬','棭','森','棯', */
	/* 68f0 */ 0xeb8d,0xeb8e,0x90b1,0,0,0,0,0xf444, 0,0x9ea8,0x8abb,0xf3f4,0xeb8f,0,0,0, /* '棰','棱','棲',0,0,0,0,'棷', 0,'棹','棺','棻','棼',0,0,0, */
	/* 6900 */ 0x986f,0x9e96,0,0xf445,0x9ea4,0x88d6,0,0xf446, 0x9e98,0,0xeb90,0x96b8,0x9e9d,0x9041,0x92c5,0x9e93, /* '椀','椁',0,'椃','椄','椅',0,'椇', '椈',0,'椊','椋','椌','植','椎','椏', */
	/* 6910 */ 0,0,0x9ea3,0,0,0,0,0, 0,0x909a,0x9ead,0x8a91,0x8c9f,0,0,0, /* 0,0,'椒',0,0,0,0,0, 0,'椙','椚','椛','検',0,0,0, */
	/* 6920 */ 0,0x9eaf,0x9e9a,0x9eae,0,0x9ea7,0x9e9b,0, 0x9eab,0,0x9eac,0,0,0,0,0, /* 0,'椡','椢','椣',0,'椥','椦',0, '椨',0,'椪',0,0,0,0,0, */
	/* 6930 */ 0x9ebd,0,0,0,0x93cc,0xeb93,0x9ea2,0, 0,0x9eb9,0,0xf44a,0,0x9ebb,0,0x92d6, /* '椰',0,0,0,'椴','椵','椶',0, 0,'椹',0,'椻',0,'椽',0,'椿', */
	/* 6940 */ 0,0,0xeb94,0,0,0,0xf44c,0, 0,0xeb91,0x976b,0,0,0,0,0, /* 0,0,'楂',0,0,0,'楆',0, 0,'楉','楊',0,0,0,0,0, */
	/* 6950 */ 0,0,0,0x9596,0x9eb6,0x91c8,0,0xeb95, 0,0x9ebc,0x915e,0,0x9eb3,0x9ec0,0x9ebf,0, /* 0,0,0,'楓','楔','楕',0,'楗', 0,'楙','楚',0,'楜','楝','楞',0, */
	/* 6960 */ 0x93ed,0x9ebe,0x93e8,0xeb96,0xeb97,0,0,0, 0xeb98,0xf44d,0x9ec2,0x9eb5,0xf44e,0x8bc6,0x9eb8,0x8f7c, /* '楠','楡','楢','楣','楤',0,0,0, '楨','楩','楪','楫','楬','業','楮','楯', */
	/* 6970 */ 0,0,0xf44f,0x9480,0x9eba,0x8bc9,0,0x9eb2, 0x9eb4,0x9eb1,0xf450,0,0x984f,0x8a79,0x9eb7,0xf451, /* 0,0,'楲','楳','楴','極',0,'楷', '楸','楹','楺',0,'楼','楽','楾','楿', */
	/* 6980 */ 0xeb99,0x9ec1,0x8a54,0,0,0,0,0, 0,0,0x8de5,0,0,0,0x897c,0, /* '榀','榁','概',0,0,0,0,0, 0,0,'榊',0,0,0,'榎',0, */
	/* 6990 */ 0,0x9ed2,0xf452,0,0x9850,0x9ed5,0xf454,0, 0xf455,0,0,0x9059,0x9ed4,0,0,0, /* 0,'榑','榒',0,'榔','榕','榖',0, '榘',0,0,'榛','榜',0,0,0, */
	/* 69a0 */ 0x9ed3,0,0,0,0,0xeb9b,0xf456,0x9ed0, 0,0,0,0,0,0xeb9c,0x9ec4,0, /* '榠',0,0,0,0,'榥','榦','榧', 0,0,0,0,0,'榭','榮',0, */
	/* 69b0 */ 0xf457,0x9ee1,0x9ec3,0,0x9ed6,0,0,0xf458, 0,0,0xf459,0x9ece,0xf45a,0,0x9ec9,0x9ec6, /* '榰','榱','榲',0,'榴',0,0,'榷', 0,0,'榺','榻','榼',0,'榾','榿', */
	/* 69c0 */ 0xf45b,0x9ec7,0,0x9ecf,0,0,0,0xeaa0, 0,0,0x9ecc,0x8d5c,0x92c6,0x9184,0x9eca,0xeb9d, /* '槀','槁',0,'槃',0,0,0,'槇', 0,0,'槊','構','槌','槍','槎','槏', */
	/* 69d0 */ 0x9ec5,0xf45c,0,0x9ec8,0,0,0xf45d,0, 0x976c,0x968a,0,0,0,0x9ecd,0x9ed7,0, /* '槐','槑',0,'槓',0,0,'槖',0, '様','槙',0,0,0,'槝','槞',0, */
	/* 69e0 */ 0,0,0xeba0,0xf463,0,0,0,0x9edf, 0x9ed8,0xeba1,0xeba2,0x9ee5,0,0x9ee3,0xf464,0xf465, /* 0,0,'槢','槣',0,0,0,'槧', '槨','槩','槪','槫',0,'槭','槮','槯', */
	/* 69f0 */ 0,0,0x9ede,0xf466,0xf468,0xeba3,0xeba4,0, 0,0x9edd,0,0x92ce,0,0x9185,0xf469,0x9edb, /* 0,0,'槲','槳','槴','槵','槶',0, 0,'槹',0,'槻',0,'槽','槾','槿', */
	/* 6a00 */ 0,0,0x9ed9,0,0,0x9ee0,0,0, 0,0,0x9ee6,0x94f3,0x9eec,0,0,0xeba5, /* 0,0,'樂',0,0,'樅',0,0, 0,0,'樊','樋','樌',0,0,'樏', */
	/* 6a10 */ 0,0xf46a,0x9ee7,0x9eea,0x9ee4,0xeba6,0,0x9294, 0,0x9557,0xf46b,0x9eda,0,0xf46c,0x9ee2,0x8fbe, /* 0,'樑','樒','樓','樔','樕',0,'樗', 0,'標','樚','樛',0,'樝','樞','樟', */
	/* 6a20 */ 0,0x96cd,0x9ef6,0x9ee9,0,0,0,0, 0,0x8ca0,0x89a1,0x8a7e,0,0,0x9ed1,0, /* 0,'模','樢','樣',0,0,0,0, 0,'権','横','樫',0,0,'樮',0, */
	/* 6a30 */ 0xf460,0,0xf46e,0xf46f,0xf470,0x8fbf,0x9eee,0, 0x9ef5,0x8ef7,0x8a92,0xeba8,0,0x924d,0xeba9,0xf471, /* '樰',0,'樲','樳','樴','樵','樶',0, '樸','樹','樺','樻',0,'樽','樾','樿', */
	/* 6a40 */ 0,0,0,0,0x9eeb,0xebaa,0xf472,0x9ef0, 0x9ef4,0xf473,0,0x8bb4,0,0,0xf475,0, /* 0,0,0,0,'橄','橅','橆','橇', '橈','橉',0,'橋',0,0,'橎',0, */
	/* 6a50 */ 0xebab,0,0xf476,0,0,0,0xebac,0, 0x8b6b,0x9ef2,0,0xebad,0,0,0,0x8b40, /* '橐',0,'橒',0,0,0,'橖',0, '橘','橙',0,'橛',0,0,0,'機', */
	/* 6a60 */ 0,0x93c9,0x9ef1,0,0xf477,0,0x9ef3,0, 0,0,0,0xebae,0,0,0,0, /* 0,'橡','橢',0,'橤',0,'橦',0, 0,0,0,'橫',0,0,0,0, */
	/* 6a70 */ 0,0,0x9eed,0xebaf,0,0,0,0, 0x9eef,0,0xf474,0,0,0,0xf479,0x8a80, /* 0,0,'橲','橳',0,0,0,0, '橸',0,'橺',0,0,0,'橾','橿', */
	/* 6a80 */ 0x9268,0,0,0xf47a,0x9efa,0,0,0, 0,0xebb1,0,0xf47b,0,0x9ef8,0x8ce7,0, /* '檀',0,0,'檃','檄',0,0,0, 0,'檉',0,'檋',0,'檍','檎',0, */
	/* 6a90 */ 0x9ef7,0xf47d,0,0,0xebb2,0,0,0x9f40, 0,0,0,0,0x9e77,0xebb3,0xebb4,0xf47e, /* '檐','檑',0,0,'檔',0,0,'檗', 0,0,0,0,'檜','檝','檞','檟', */
	/* 6aa0 */ 0x9ef9,0xf480,0x9efb,0x9efc,0,0xebb5,0,0, 0,0,0x9f4b,0xf482,0x9f47,0,0x9e8d,0, /* '檠','檡','檢','檣',0,'檥',0,0, 0,0,'檪','檫','檬',0,'檮',0, */
	/* 6ab0 */ 0,0,0,0x9f46,0,0,0,0, 0x9f45,0,0,0x9f42,0,0xf483,0,0, /* 0,0,0,'檳',0,0,0,0, '檸',0,0,'檻',0,'檽',0,0, */
	/* 6ac0 */ 0,0x9ee8,0x9f44,0x9f43,0,0,0xf484,0, 0,0,0,0,0,0,0,0, /* 0,'櫁','櫂','櫃',0,0,'櫆',0, 0,0,0,0,0,0,0,0, */
	/* 6ad0 */ 0xf486,0x9f49,0,0x9845,0xf485,0,0,0, 0,0,0x9f4c,0x8bf9,0xf487,0xf488,0x9f48,0x9f4a, /* '櫐','櫑',0,'櫓','櫔',0,0,0, 0,0,'櫚','櫛','櫜','櫝','櫞','櫟', */
	/* 6ae0 */ 0,0,0,0,0xebb6,0,0,0xebb7, 0x94a5,0,0x9f4d,0,0xf48b,0,0,0, /* 0,0,0,0,'櫤',0,0,'櫧', '櫨',0,'櫪',0,'櫬',0,0,0, */
	/* 6af0 */ 0,0xf48c,0xf48d,0xf48e,0,0,0,0, 0,0,0x9f51,0x9f4e,0,0xf48f,0,0, /* 0,'櫱','櫲','櫳',0,0,0,0, 0,0,'櫺','櫻',0,'櫽',0,0, */
	/* 6b00 */ 0,0,0,0,0x9793,0x9f4f,0,0, 0,0,0x9edc,0xf491,0,0,0,0xf492, /* 0,0,0,0,'欄','欅',0,0, 0,0,'權','欋',0,0,0,'欏', */
	/* 6b10 */ 0xf493,0xf494,0x9f52,0,0,0,0x9f53,0xf496, 0,0,0,0xebba,0,0x8954,0xebbb,0x9f55, /* '欐','欑','欒',0,0,0,'欖','欗', 0,0,0,'欛',0,'欝','欞','欟', */
	/* 6b20 */ 0x8c87,0x8e9f,0,0x8bd3,0,0,0,0x89a2, 0,0,0,0,0xebbc,0,0,0xf498, /* '欠','次',0,'欣',0,0,0,'欧', 0,0,0,0,'欬',0,0,'欯', */
	/* 6b30 */ 0,0,0x977e,0,0,0xebbd,0,0x9f57, 0x9f56,0x9f59,0x8b5c,0,0,0x8bd4,0x8abc,0, /* 0,0,'欲',0,0,'欵',0,'欷', '欸','欹','欺',0,0,'欽','款',0, */
	/* 6b40 */ 0,0,0,0x9f5c,0,0,0xebbe,0x9f5b, 0,0x9f5d,0xf499,0,0x89cc,0,0x9256,0, /* 0,0,0,'歃',0,0,'歆','歇', 0,'歉','歊',0,'歌',0,'歎',0, */
	/* 6b50 */ 0x9f5e,0,0,0x8abd,0x9f60,0,0xebbf,0, 0xf49a,0x9f5f,0,0x9f61,0,0,0,0x9f62, /* '歐',0,0,'歓','歔',0,'歖',0, '歘','歙',0,'歛',0,0,0,'歟', */
	/* 6b60 */ 0xebc0,0x9f63,0x8e7e,0x90b3,0x8d9f,0xebc1,0x9590,0xebc2, 0,0x95e0,0x9863,0,0xf49b,0,0,0x8e95, /* '歠','歡','止','正','此','步','武','歧', 0,'歩','歪',0,'歬',0,0,'歯', */
	/* 6b70 */ 0,0,0,0x8dce,0x97f0,0xf49c,0,0xebc3, 0x9f64,0x9f65,0xf49d,0x8e80,0,0,0,0x9f66, /* 0,0,0,'歳','歴','歵',0,'歷', '歸','歹','歺','死',0,0,0,'歿', */
	/* 6b80 */ 0x9f67,0xf49e,0xebc4,0x9f69,0x9f68,0,0x9677,0, 0,0x8f7d,0x8eea,0x8e63,0,0x9f6a,0,0, /* '殀','殁','殂','殃','殄',0,'殆',0, 0,'殉','殊','残',0,'殍',0,0, */
	/* 6b90 */ 0,0,0,0,0,0x9f6c,0x9042,0, 0x9f6b,0,0,0xf49f,0,0,0x9f6d,0, /* 0,0,0,0,0,'殕','殖',0, '殘',0,0,'殛',0,0,'殞',0, */
	/* 6ba0 */ 0,0,0,0,0x9f6e,0,0,0, 0,0xebc5,0x9f6f,0x9f70,0,0xebc6,0xf4a0,0x9f71, /* 0,0,0,0,'殤',0,0,0, 0,'殩','殪','殫',0,'殭','殮','殯', */
	/* 6bb0 */ 0,0x9f73,0x9f72,0x9f74,0x89a3,0x9269,0,0x9f75, 0,0,0x8e45,0x8a6b,0x9f76,0xf4a2,0xf4a3,0x9361, /* 0,'殱','殲','殳','殴','段',0,'殷', 0,0,'殺','殻','殼','殽','殾','殿', */
	/* 6bc0 */ 0x9aca,0,0,0,0,0x8b42,0x9f77,0xf4a4, 0xf4a5,0xf4a6,0,0x9f78,0,0x95ea,0x9688,0xebc8, /* '毀',0,0,0,0,'毅','毆','毇', '毈','毉',0,'毋',0,'母','毎','每', */
	/* 6bd0 */ 0,0,0x93c5,0x9f79,0x94e4,0,0xebc9,0xebca, 0x94f9,0,0xf4a7,0x96d1,0,0,0,0x9f7a, /* 0,0,'毒','毓','比',0,'毖','毗', '毘',0,'毚','毛',0,0,0,'毟', */
	/* 6be0 */ 0,0,0,0,0,0,0xf4a8,0xf4a9, 0,0,0,0x9f7c,0x9f7b,0,0xf4aa,0x9f7e, /* 0,0,0,0,0,0,'毦','毧', 0,0,0,'毫','毬',0,'毮','毯', */
	/* 6bf0 */ 0,0xf4ab,0,0x9f7d,0,0,0,0, 0,0,0,0,0,0,0,0xebcb, /* 0,'毱',0,'毳',0,0,0,0, 0,0,0,0,0,0,0,'毿', */
	/* 6c00 */ 0,0,0xf4ac,0,0,0xebcc,0,0, 0x9f81,0,0xf4ad,0,0,0,0xf4ae,0x8e81, /* 0,0,'氂',0,0,'氅',0,0, '氈',0,'氊',0,0,0,'氎','氏', */
	/* 6c10 */ 0xebcd,0x96af,0,0x9f82,0x9f83,0,0,0x8b43, 0,0,0,0x9f84,0,0,0,0, /* '氐','民',0,'氓','气',0,0,'気', 0,0,0,'氛',0,0,0,0, */
	/* 6c20 */ 0,0,0,0x9f86,0x9f85,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,0,'氣','氤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 6c30 */ 0,0,0,0xebce,0x9085,0xf4af,0xf4b0,0x9558, 0x8969,0,0xf4b1,0,0,0,0x94c3,0xf4b3, /* 0,0,0,'氳','水','氵','氶','氷', '永',0,'氺',0,0,0,'氾','氿', */
	/* 6c40 */ 0x92f3,0x8f60,0x8b81,0,0,0,0,0, 0,0,0,0,0,0xf4b4,0x94c4,0, /* '汀','汁','求',0,0,0,0,0, 0,0,0,0,0,'汍','汎',0, */
	/* 6c50 */ 0x8eac,0,0,0,0,0x9f88,0,0x8abe, 0,0xebcf,0x8998,0xf4b5,0xebd0,0x93f0,0x9f87,0x8d5d, /* '汐',0,0,0,0,'汕',0,'汗', 0,'汙','汚','汛','汜','汝','汞','江', */
	/* 6c60 */ 0x9272,0,0x9f89,0,0,0,0,0xf4cd, 0x9f91,0,0x9f8a,0,0,0xf4b6,0,0, /* '池',0,'汢',0,0,0,0,'汧', '汨',0,'汪',0,0,'汭',0,0, */
	/* 6c70 */ 0x91bf,0,0x8b82,0x9f92,0xebd2,0,0xebd3,0, 0,0,0x8c88,0,0,0x8b44,0x9f90,0, /* '汰',0,'汲','汳','汴',0,'汶',0, 0,0,'決',0,0,'汽','汾',0, */
	/* 6c80 */ 0,0x9f8e,0x9f8b,0x9780,0xf4b7,0xebd4,0xebd5,0, 0x92be,0xf4b8,0,0,0x93d7,0x9f8c,0,0, /* 0,'沁','沂','沃','沄','沅','沆',0, '沈','沉',0,0,'沌','沍',0,0, */
	/* 6c90 */ 0x9f94,0,0x9f93,0x8c42,0xf4ba,0xf4bb,0x89ab,0xf4bc, 0xebd6,0x8db9,0x9f8d,0x9f8f,0xebd7,0,0,0, /* '沐',0,'沒','沓','沔','沕','沖','沗', '沘','沙','沚','沛','沜',0,0,0, */
	/* 6ca0 */ 0,0x9676,0x91f2,0,0,0,0,0, 0,0,0xebd1,0x9697,0,0xf4bd,0x9f9c,0, /* 0,'没','沢',0,0,0,0,0, 0,0,'沪','沫',0,'沭','沮',0, */
	/* 6cb0 */ 0,0x9f9d,0,0x89cd,0,0,0,0, 0x95a6,0x96fb,0x9f9f,0x8ea1,0x8fc0,0x9f98,0x9f9e,0x8988, /* 0,'沱',0,'河',0,0,0,0, '沸','油','沺','治','沼','沽','沾','沿', */
	/* 6cc0 */ 0,0x8bb5,0xf4be,0,0x9f95,0x9f9a,0xebd9,0, 0,0x90f2,0x9491,0,0x94e5,0,0,0, /* 0,'況','泂',0,'泄','泅','泆',0, 0,'泉','泊',0,'泌',0,0,0, */
	/* 6cd0 */ 0xf4bf,0,0,0x9f97,0xebda,0x9640,0xf4c1,0x9f99, 0,0x9fa2,0xf4c2,0x9fa0,0xf4c3,0x9f9b,0,0, /* '泐',0,0,'泓','泔','法','泖','泗', 0,'泙','泚','泛','泜','泝',0,0, */
	/* 6ce0 */ 0xebdb,0x9641,0x9467,0x8b83,0,0x9344,0,0, 0x928d,0xf4c4,0x9fa3,0xebdc,0xf4c5,0xf4c6,0xebdd,0x9fa1, /* '泠','泡','波','泣',0,'泥',0,0, '注','泩','泪','泫','泬','泭','泮','泯', */
	/* 6cf0 */ 0x91d7,0x9f96,0,0x896a,0,0,0,0, 0,0,0,0xebd8,0,0,0,0, /* '泰','泱',0,'泳',0,0,0,0, 0,0,0,'泻',0,0,0,0, */
	/* 6d00 */ 0xf4c8,0,0,0,0xebdf,0,0,0, 0,0,0xf4c9,0x976d,0x9fae,0,0xebe0,0, /* '洀',0,0,0,'洄',0,0,0, 0,0,'洊','洋','洌',0,'洎',0, */
	/* 6d10 */ 0,0,0x9fad,0,0,0,0,0x90f4, 0,0x9faa,0,0x978c,0,0,0x93b4,0x9fa4, /* 0,0,'洒',0,0,0,0,'洗', 0,'洙',0,'洛',0,0,'洞','洟', */
	/* 6d20 */ 0,0,0,0,0xf4ca,0x92c3,0xf4cb,0xf4cc, 0,0x896b,0x8d5e,0x9fa7,0,0,0xebe1,0xf4ce, /* 0,0,0,0,'洤','津','洦','洧', 0,'洩','洪','洫',0,0,'洮','洯', */
	/* 6d30 */ 0,0xebe2,0x8f46,0x9fac,0xf4e3,0x9fab,0x9fa6,0, 0x9fa9,0xebe3,0,0x8a88,0xf4cf,0x9fa8,0x9468,0xebe4, /* 0,'洱','洲','洳','洴','洵','洶',0, '洸','洹',0,'活','洼','洽','派','洿', */
	/* 6d40 */ 0,0x97ac,0,0,0x8ff2,0x90f3,0,0, 0,0,0,0,0,0,0,0, /* 0,'流',0,0,'浄','浅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6d50 */ 0,0,0,0,0,0,0,0, 0xebe5,0x9fb4,0x9fb2,0xf4d0,0x956c,0,0xf4d1,0, /* 0,0,0,0,0,0,0,0, '浘','浙','浚','浛','浜',0,'浞',0, */
	/* 6d60 */ 0xf4d2,0,0,0x9faf,0x9fb1,0xebe6,0x8959,0, 0,0x8d5f,0x9851,0,0x8a5c,0,0x9582,0, /* '浠',0,0,'浣','浤','浥','浦',0, 0,'浩','浪',0,'浬',0,'浮',0, */
	/* 6d70 */ 0xf4d3,0,0,0,0x9781,0,0,0x8a43, 0x905a,0x9fb3,0,0,0,0,0,0, /* '浰',0,0,0,'浴',0,0,'海', '浸','浹',0,0,0,0,0,0, */
	/* 6d80 */ 0xf4d4,0xf4d5,0xebe8,0,0,0x9fb8,0,0xebe9, 0x8fc1,0xebea,0xf4d6,0,0x974f,0xf4d7,0x9fb5,0, /* '涀','涁','涂',0,0,'涅',0,'涇', '消','涉','涊',0,'涌','涍','涎',0, */
	/* 6d90 */ 0,0xf4d8,0,0x9fb0,0xebeb,0x9fb6,0,0, 0xf4d9,0x97dc,0,0x9393,0x93c0,0,0,0, /* 0,'涑',0,'涓','涔','涕',0,0, '涘','涙',0,'涛','涜',0,0,0, */
	/* 6da0 */ 0,0,0,0,0,0,0,0, 0,0,0xebec,0xf4df,0xebed,0,0xf4e0,0x8a55, /* 0,0,0,0,0,0,0,0, 0,0,'涪','涫','涬',0,'涮','涯', */
	/* 6db0 */ 0,0,0x8974,0,0xf4e1,0x9fbc,0,0, 0x9fbf,0,0,0,0x97c1,0,0,0xebee, /* 0,0,'液',0,'涴','涵',0,0, '涸',0,0,0,'涼',0,0,'涿', */
	/* 6dc0 */ 0x9784,0,0xf4e2,0,0xebef,0x9fc6,0x9fc0,0x9fbd, 0xf4e4,0,0,0x97d2,0x9fc3,0,0xf4e5,0xf4e6, /* '淀',0,'淂',0,'淄','淅','淆','淇', '淈',0,0,'淋','淌',0,'淎','淏', */
	/* 6dd0 */ 0xf4e7,0x8f69,0x9fc5,0,0,0x9fca,0xebf0,0, 0x9391,0x9fc8,0xebf1,0xebf2,0,0xebf3,0x9fc2,0xf4e8, /* '淐','淑','淒',0,0,'淕','淖',0, '淘','淙','淚','淛',0,'淝','淞','淟', */
	/* 6de0 */ 0,0x9257,0,0,0x9fc9,0,0x9fbe,0, 0x9fc4,0xf4e9,0x9fcb,0x88fa,0x9fc1,0,0x9fcc,0, /* 0,'淡',0,0,'淤',0,'淦',0, '淨','淩','淪','淫','淬',0,'淮',0, */
	/* 6df0 */ 0,0x905b,0,0x8f7e,0,0x95a3,0xf4ea,0x8dac, 0,0x9fb9,0x9fc7,0x9359,0xebf4,0,0,0, /* 0,'深',0,'淳',0,'淵','淶','混', 0,'淹','淺','添','淼',0,0,0, */
	/* 6e00 */ 0,0,0,0,0,0x90b4,0,0x8a89, 0x8dcf,0x8fc2,0x9fbb,0x8f61,0,0,0,0, /* 0,0,0,0,0,'清',0,'渇', '済','渉','渊','渋',0,0,0,0, */
	/* 6e10 */ 0,0,0,0x8c6b,0,0x9fba,0,0xf4db, 0,0x9fd0,0x8f8d,0x8cb8,0,0x9fdf,0xf4ec,0x9fd9, /* 0,0,0,'渓',0,'渕',0,'渗', 0,'渙','渚','減',0,'渝','渞','渟', */
	/* 6e20 */ 0x8b94,0x936e,0xf4ed,0x9fd4,0x9fdd,0x88ad,0x8951,0xf4ee, 0,0x89b7,0,0x9fd6,0x91aa,0x9fcd,0x9fcf,0x8d60, /* '渠','渡','渢','渣','渤','渥','渦','渧', 0,'温',0,'渫','測','渭','渮','港', */
	/* 6e30 */ 0,0,0xf4f0,0,0xebf6,0,0xf4eb,0, 0x9fe0,0,0x9fdb,0,0xf4f1,0,0x9fd3,0, /* 0,0,'渲',0,'渴',0,'渶',0, '游',0,'渺',0,'渼',0,'渾',0, */
	/* 6e40 */ 0,0,0,0x9fda,0xebf7,0,0,0, 0xf4f2,0xf4f3,0x96a9,0xf4f4,0xf4f5,0x9fd8,0x9fdc,0xf4f6, /* 0,0,0,'湃','湄',0,0,0, '湈','湉','湊','湋','湌','湍','湎','湏', */
	/* 6e50 */ 0,0xf4f7,0,0xf4f8,0xf4f9,0,0x8cce,0xf4fa, 0x8fc3,0,0,0x9258,0xebf8,0,0xebf9,0x9fd2, /* 0,'湑',0,'湓','湔',0,'湖','湗', '湘',0,0,'湛','湜',0,'湞','湟', */
	/* 6e60 */ 0,0,0,0xf4fb,0,0,0,0x974e, 0,0,0,0x9fd5,0,0,0x9fce,0x9392, /* 0,0,0,'湣',0,0,0,'湧', 0,0,0,'湫',0,0,'湮','湯', */
	/* 6e70 */ 0,0,0x9fd1,0,0,0,0x9fd7,0, 0,0,0,0,0,0,0x9870,0x8ebc, /* 0,0,'湲',0,0,0,'湶',0, 0,0,0,0,0,0,'湾','湿', */
	/* 6e80 */ 0x969e,0,0x9fe1,0,0,0,0,0, 0,0,0,0,0x94ac,0,0,0x9fed, /* '満',0,'溂',0,0,0,0,0, 0,0,0,0,'溌',0,0,'溏', */
	/* 6e90 */ 0x8cb9,0,0,0xf540,0,0,0x8f80,0, 0x9fe3,0,0,0,0x97ad,0x8d61,0,0x9ff0, /* '源',0,0,'溓',0,0,'準',0, '溘',0,0,0,'溜','溝',0,'溟', */
	/* 6ea0 */ 0,0,0x88ec,0,0,0x9fee,0,0xf541, 0,0,0x9fe2,0xebfa,0,0,0,0x9fe8, /* 0,0,'溢',0,0,'溥',0,'溧', 0,0,'溪','溫',0,0,0,'溯', */
	/* 6eb0 */ 0,0xebfb,0x9fea,0,0xf542,0,0x976e,0x9fe5, 0,0,0x934d,0,0,0x9fe7,0,0xf543, /* 0,'溱','溲',0,'溴',0,'溶','溷', 0,0,'溺',0,0,'溽',0,'溿', */
	/* 6ec0 */ 0,0xebfc,0x9fef,0xf544,0x9fe9,0x96c5,0,0xec40, 0,0x9fe4,0xf545,0x8ea0,0x9ffc,0,0xec41,0, /* 0,'滁','滂','滃','滄','滅',0,'滇', 0,'滉','滊','滋','滌',0,'滎',0, */
	/* 6ed0 */ 0,0x8a8a,0,0x9fe6,0x9feb,0x9fec,0,0, 0,0xf546,0,0,0,0x91ea,0x91d8,0, /* 0,'滑',0,'滓','滔','滕',0,0, 0,'滙',0,0,0,'滝','滞',0, */
	/* 6ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0xf548,0x9ff4,0,0,0x9ffa, /* 0,0,0,0,0,0,0,0, 0,0,0,'滫','滬',0,0,'滯', */
	/* 6ef0 */ 0,0,0x9ff8,0,0x9348,0,0,0xe042, 0x9ff5,0xf549,0,0xf54a,0,0,0x9ff6,0x9fde, /* 0,0,'滲',0,'滴',0,0,'滷', '滸','滹',0,'滻',0,0,'滾','滿', */
	/* 6f00 */ 0,0x8b99,0x9559,0,0,0,0x8ebd,0, 0,0x8d97,0xf54b,0,0xf54c,0,0,0x9852, /* 0,'漁','漂',0,0,0,'漆',0, 0,'漉','漊',0,'漌',0,0,'漏', */
	/* 6f10 */ 0xec42,0x9ff2,0,0xe041,0x8989,0x9186,0,0, 0xf54d,0,0xec43,0,0,0,0,0, /* '漐','漑',0,'漓','演','漕',0,0, '漘',0,'漚',0,0,0,0,0, */
	/* 6f20 */ 0x9499,0,0x8abf,0x97f8,0,0xf54e,0,0, 0,0,0xec45,0x969f,0x92d0,0,0,0xec46, /* '漠',0,'漢','漣',0,'漥',0,0, 0,0,'漪','漫','漬',0,0,'漯', */
	/* 6f30 */ 0,0x9ff9,0x9ffb,0xec47,0,0xf547,0xf54f,0, 0x9151,0,0,0,0xf550,0,0xe040,0x9ff7, /* 0,'漱','漲','漳',0,'漵','漶',0, '漸',0,0,0,'漼',0,'漾','漿', */
	/* 6f40 */ 0,0x9ff1,0,0,0,0x8ac1,0,0, 0,0,0,0,0,0,0,0, /* 0,'潁',0,0,0,'潅',0,0, 0,0,0,0,0,0,0,0, */
	/* 6f50 */ 0,0xec48,0xf552,0,0x8c89,0,0,0xf553, 0xe04e,0xec49,0xf554,0xe049,0x90f6,0,0xec4a,0x8a83, /* 0,'潑','潒',0,'潔',0,0,'潗', '潘','潙','潚','潛','潜',0,'潞','潟', */
	/* 6f60 */ 0xf555,0xec4b,0xec4c,0,0x8f81,0,0xe052,0, 0xf556,0,0,0,0,0xe04b,0x92aa,0xe048, /* '潠','潡','潢',0,'潤',0,'潦',0, '潨',0,0,0,0,'潭','潮','潯', */
	/* 6f70 */ 0x92d7,0,0,0,0xe06b,0,0,0, 0xe045,0,0xe044,0,0xe04d,0xf558,0xec4d,0, /* '潰',0,0,0,'潴',0,0,0, '潸',0,'潺',0,'潼','潽','潾',0, */
	/* 6f80 */ 0xe047,0xe046,0xe04c,0,0x909f,0,0xe043,0, 0xec4e,0,0,0,0xec4f,0xec50,0xe04f,0, /* '澀','澁','澂',0,'澄',0,'澆',0, '澈',0,0,0,'澌','澍','澎',0, */
	/* 6f90 */ 0xf559,0xe050,0,0,0xec51,0,0xf55a,0x8ac0, 0xf557,0,0,0,0,0,0,0xf55c, /* '澐','澑',0,0,'澔',0,'澖','澗', '澘',0,0,0,0,0,0,'澟', */
	/* 6fa0 */ 0xec52,0xe055,0,0xe054,0xe056,0xf55d,0,0xec53, 0,0,0xe059,0,0,0,0,0xf55e, /* '澠','澡',0,'澣','澤','澥',0,'澧', 0,0,'澪',0,0,0,0,'澯', */
	/* 6fb0 */ 0,0x9362,0,0xe053,0,0xf560,0xec54,0, 0,0xe057,0,0,0xec55,0,0xf55b,0, /* 0,'澱',0,'澳',0,'澵','澶',0, 0,'澹',0,0,'澼',0,'澾',0, */
	/* 6fc0 */ 0x8c83,0x91f7,0xe051,0x945a,0,0,0xe058,0xec56, 0xf561,0xf562,0xec57,0,0,0,0,0, /* '激','濁','濂','濃',0,0,'濆','濇', '濈','濉','濊',0,0,0,0,0, */
	/* 6fd0 */ 0,0,0,0,0xe05d,0xe05b,0,0, 0xe05e,0,0xf563,0xe061,0,0,0xf564,0xe05a, /* 0,0,0,0,'濔','濕',0,0, '濘',0,'濚','濛',0,0,'濞','濟', */
	/* 6fe0 */ 0x8d8a,0x9447,0,0,0x9fb7,0,0,0, 0,0xf565,0,0x9794,0xe05c,0,0xe060,0x91f3, /* '濠','濡',0,0,'濤',0,0,0, 0,'濩',0,'濫','濬',0,'濮','濯', */
	/* 6ff0 */ 0xec59,0xe05f,0,0xe04a,0,0xec5a,0xe889,0, 0,0xec58,0xe064,0,0xf567,0,0xe068,0, /* '濰','濱',0,'濳',0,'濵','濶',0, 0,'濹','濺',0,'濼',0,'濾',0, */
	/* 7000 */ 0xf568,0xe066,0,0,0,0xec5b,0xec5c,0xf569, 0,0xe062,0xf56a,0xe063,0,0,0,0xe067, /* '瀀','瀁',0,0,0,'瀅','瀆','瀇', 0,'瀉','瀊','瀋',0,0,0,'瀏', */
	/* 7010 */ 0,0xe065,0,0,0,0x956d,0,0, 0xe06d,0,0xe06a,0xe069,0,0xe06c,0x93d2,0xe06e, /* 0,'瀑',0,0,0,'瀕',0,0, '瀘',0,'瀚','瀛',0,'瀝','瀞','瀟', */
	/* 7020 */ 0,0,0,0xf56b,0,0,0x9295,0x91eb, 0xec5d,0,0,0,0x90a3,0,0,0, /* 0,0,0,'瀣',0,0,'瀦','瀧', '瀨',0,0,0,'瀬',0,0,0, */
	/* 7030 */ 0xe06f,0,0xe071,0,0,0,0,0, 0,0xf56d,0xf56e,0,0xf56f,0,0xe070,0, /* '瀰',0,'瀲',0,0,0,0,0, 0,'瀹','瀺',0,'瀼',0,'瀾',0, */
	/* 7040 */ 0,0,0,0xf570,0,0,0,0xf571, 0,0,0xec5e,0xf572,0x9ff3,0,0xec61,0, /* 0,0,0,'灃',0,0,0,'灇', 0,0,'灊','灋','灌',0,'灎',0, */
	/* 7050 */ 0,0xe072,0,0,0xf574,0,0,0, 0x93e5,0,0,0,0,0xec5f,0xec60,0, /* 0,'灑',0,0,'灔',0,0,0, '灘',0,0,0,0,'灝','灞',0, */
	/* 7060 */ 0,0,0,0xe073,0xec62,0xf575,0,0, 0,0xf576,0,0x89ce,0xf577,0,0xf578,0x9394, /* 0,0,0,'灣','灤','灥',0,0, 0,'灩',0,'火','灬',0,'灮','灯', */
	/* 7070 */ 0x8a44,0,0,0,0,0xec63,0xf579,0, 0x8b84,0,0,0,0x8edc,0x8dd0,0xf57a,0, /* '灰',0,0,0,0,'灵','灶',0, '灸',0,0,0,'灼','災','灾',0, */
	/* 7080 */ 0,0xf57b,0,0,0,0xec64,0xf57c,0, 0,0x9846,0x9086,0,0,0,0x898a,0, /* 0,'炁',0,0,0,'炅','炆',0, 0,'炉','炊',0,0,0,'炎',0, */
	/* 7090 */ 0,0,0xe075,0,0,0xf57d,0,0xf57e, 0,0xe074,0,0,0,0,0,0xf582, /* 0,0,'炒',0,0,'炕',0,'炗', 0,'炙',0,0,0,0,0,'炟', */
	/* 70a0 */ 0,0,0,0,0xec65,0,0,0, 0,0,0,0xec66,0xe078,0x9259,0xe07b,0xe076, /* 0,0,0,0,'炤',0,0,0, 0,0,0,'炫','炬','炭','炮','炯', */
	/* 70b0 */ 0,0xf583,0,0xe07a,0,0,0,0xec67, 0xe079,0x935f,0x88d7,0xf580,0,0,0,0, /* 0,'炱',0,'炳',0,0,0,'炷', '炸','点','為','炻',0,0,0,0, */
	/* 70c0 */ 0,0,0,0,0,0,0,0, 0x97f3,0,0xf586,0xe07d,0,0,0,0x8947, /* 0,0,0,0,0,0,0,0, '烈',0,'烊','烋',0,0,0,'烏', */
	/* 70d0 */ 0,0xf587,0,0xf588,0xec68,0,0,0, 0xec69,0xe080,0,0,0xf589,0xe07e,0,0xe07c, /* 0,'烑',0,'烓','烔',0,0,0, '烘','烙',0,0,'烜','烝',0,'烟', */
	/* 70e0 */ 0,0,0,0,0xec6a,0,0,0, 0,0,0,0,0xf585,0,0,0, /* 0,0,0,0,'烤',0,0,0, 0,0,0,0,'烬',0,0,0, */
	/* 70f0 */ 0,0xe077,0,0,0,0,0,0, 0,0x9642,0,0,0,0xe082,0,0, /* 0,'烱',0,0,0,0,0,0, 0,'烹',0,0,0,'烽',0,0, */
	/* 7100 */ 0,0,0,0xf58a,0xf58b,0,0xf58c,0xf58d, 0xf58e,0xe081,0,0,0xf58f,0,0,0xec6b, /* 0,0,0,'焃','焄',0,'焆','焇', '焈','焉',0,0,'焌',0,0,'焏', */
	/* 7110 */ 0,0,0,0,0x898b,0,0,0, 0,0xe084,0x95b0,0,0xe083,0,0xec6d,0, /* 0,0,0,0,'焔',0,0,0, 0,'焙','焚',0,'焜',0,'焞',0, */
	/* 7120 */ 0xec6e,0x96b3,0,0,0,0,0x8fc5,0, 0,0,0,0xec6c,0,0,0xec6f,0xf591, /* '焠','無',0,0,0,0,'焦',0, 0,0,0,'焫',0,0,'焮','焯', */
	/* 7130 */ 0xec70,0xf592,0,0,0,0,0x9152,0, 0,0,0,0,0x8fc4,0,0,0, /* '焰','焱',0,0,0,0,'然',0, 0,0,0,0,'焼',0,0,0, */
	/* 7140 */ 0,0,0,0,0,0,0xec71,0xec72, 0,0x97f9,0xf594,0,0xe08a,0,0x90f7,0, /* 0,0,0,0,0,0,'煆','煇', 0,'煉','煊',0,'煌',0,'煎',0, */
	/* 7150 */ 0xf593,0xec73,0xec75,0xf595,0,0xe086,0xe08b,0, 0,0x898c,0,0,0xec76,0,0xf596,0, /* '煐','煑','煒','煓',0,'煕','煖',0, 0,'煙',0,0,'煜',0,'煞',0, */
	/* 7160 */ 0xec77,0,0xe089,0,0x9481,0xe085,0xe088,0x8fc6, 0xec78,0x94cf,0,0,0xe08c,0,0x8ecf,0, /* '煠',0,'煢',0,'煤','煥','煦','照', '煨','煩',0,0,'煬',0,'煮',0, */
	/* 7170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x90f8,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'煽',0,0, */
	/* 7180 */ 0xf599,0,0,0,0xe08f,0xec7a,0,0xec7b, 0xe087,0,0x8c46,0,0,0,0,0xe08d, /* '熀',0,0,0,'熄','熅',0,'熇', '熈',0,'熊',0,0,0,0,'熏', */
	/* 7190 */ 0,0,0xec7c,0,0x976f,0xe090,0xf598,0, 0,0xeaa4,0,0xf59a,0,0,0,0x8f6e, /* 0,0,'熒',0,'熔','熕','熖',0, 0,'熙',0,'熛',0,0,0,'熟', */
	/* 71a0 */ 0xf59b,0,0xf59c,0,0,0,0,0, 0xe091,0,0,0,0xe092,0,0xf59d,0xf59e, /* '熠',0,'熢',0,0,0,0,0, '熨',0,0,0,'熬',0,'熮','熯', */
	/* 71b0 */ 0,0x944d,0,0xf59f,0,0,0,0, 0,0xe094,0xec7e,0,0,0,0xe095,0, /* 0,'熱',0,'熳',0,0,0,0, 0,'熹','熺',0,0,0,'熾',0, */
	/* 71c0 */ 0,0xec7d,0,0x9452,0xec80,0,0,0, 0x9395,0xe097,0,0xf5a1,0,0,0xe099,0, /* 0,'燁',0,'燃','燄',0,0,0, '燈','燉',0,'燋',0,0,'燎',0, */
	/* 71d0 */ 0x97d3,0,0xe096,0xf5a2,0xe098,0x898d,0,0xe093, 0,0xf5a3,0,0,0xf5a4,0,0,0x9a7a, /* '燐',0,'燒','燓','燔','燕',0,'燗', 0,'燙',0,0,'燜',0,0,'營', */
	/* 71e0 */ 0xe09a,0,0,0,0,0x9187,0x8e57,0xe09c, 0,0,0,0,0xe09b,0x9043,0x99d7,0, /* '燠',0,0,0,0,'燥','燦','燧', 0,0,0,0,'燬','燭','燮',0, */
	/* 71f0 */ 0,0,0,0,0,0xe09d,0,0, 0,0xe09f,0,0xe08e,0xe09e,0,0xec81,0xe0a0, /* 0,0,0,0,0,'燵',0,0, 0,'燹',0,'燻','燼',0,'燾','燿', */
	/* 7200 */ 0xec82,0,0,0,0,0,0x949a,0xf5a5, 0,0,0,0,0,0xe0a1,0,0, /* '爀',0,0,0,0,0,'爆','爇', 0,0,0,0,0,'爍',0,0, */
	/* 7210 */ 0xe0a2,0,0,0,0,0xec83,0,0, 0,0,0,0xe0a3,0,0,0,0, /* '爐',0,0,0,0,'爕',0,0, 0,0,0,'爛',0,0,0,0, */
	/* 7220 */ 0,0,0,0,0,0,0,0, 0xe0a4,0,0x92dc,0xf5a8,0xe0a6,0xe0a5,0,0, /* 0,0,0,0,0,0,0,0, '爨',0,'爪','爫','爬','爭',0,0, */
	/* 7230 */ 0xe0a7,0,0xe0a8,0,0xf5a9,0x8edd,0x9583,0, 0xf5aa,0xf5ab,0x96ea,0xe0a9,0xe0aa,0x9175,0x8ea2,0xe0ab, /* '爰',0,'爲',0,'爴','爵','父',0, '爸','爹','爺','爻','爼','爽','爾','爿', */
	/* 7240 */ 0xe0ac,0,0xf5ad,0,0,0,0xe0ad,0x95d0, 0x94c5,0,0,0xe0ae,0x9476,0,0,0, /* '牀',0,'牂',0,0,0,'牆','片', '版',0,0,'牋','牌',0,0,0, */
	/* 7250 */ 0,0,0x92ab,0xf5ae,0,0xec84,0xec85,0xf5af, 0xe0af,0x89e5,0,0x8b8d,0,0x96c4,0,0x96b4, /* 0,0,'牒','牓',0,'牕','牖','牗', '牘','牙',0,'牛',0,'牝',0,'牟', */
	/* 7260 */ 0,0x89b2,0x9853,0xf5b0,0,0,0,0x9671, 0,0x95a8,0,0,0,0,0xf5b2,0xf5b3, /* 0,'牡','牢','牣',0,0,0,'牧', 0,'物',0,0,0,0,'牮','牯', */
	/* 7270 */ 0,0,0x90b5,0,0xe0b0,0,0,0, 0xf5b4,0x93c1,0,0,0,0x8ca1,0xe0b1,0xf5b5, /* 0,0,'牲',0,'牴',0,0,0, '牸','特',0,0,0,'牽','牾','牿', */
	/* 7280 */ 0x8dd2,0xe0b3,0xe0b2,0,0,0,0,0xe0b4, 0,0,0,0,0,0xec87,0xf5b6,0, /* '犀','犁','犂',0,0,0,0,'犇', 0,0,0,0,0,'犍','犎',0, */
	/* 7290 */ 0,0,0xe0b5,0,0,0,0xe0b6,0, 0,0,0,0xec88,0,0,0,0, /* 0,0,'犒',0,0,0,'犖',0, 0,0,0,'犛',0,0,0,0, */
	/* 72a0 */ 0x8b5d,0,0xe0b7,0,0,0,0,0xe0b8, 0,0,0,0,0x8ca2,0xf5b8,0xf5b9,0x94c6, /* '犠',0,'犢',0,0,0,0,'犧', 0,0,0,0,'犬','犭','犮','犯', */
	/* 72b0 */ 0xf5ba,0xf5bb,0xe0ba,0,0,0,0x8ff3,0, 0,0xe0b9,0,0,0,0,0xec89,0, /* '犰','犱','犲',0,0,0,'状',0, 0,'犹',0,0,0,0,'犾',0, */
	/* 72c0 */ 0xec8a,0xf5bc,0x8bb6,0xe0bb,0xe0bd,0,0xe0bc,0, 0,0,0,0,0xf5be,0,0xe0be,0, /* '狀','狁','狂','狃','狄',0,'狆',0, 0,0,0,0,'狌',0,'狎',0, */
	/* 72d0 */ 0x8ccf,0,0xe0bf,0,0,0,0,0x8be7, 0,0x915f,0,0x8d9d,0,0,0,0, /* '狐',0,'狒',0,0,0,0,'狗', 0,'狙',0,'狛',0,0,0,0, */
	/* 72e0 */ 0xe0c1,0xe0c2,0xe0c0,0,0,0,0,0, 0,0x8eeb,0,0,0x93c6,0x8bb7,0,0, /* '狠','狡','狢',0,0,0,0,0, 0,'狩',0,0,'独','狭',0,0, */
	/* 72f0 */ 0,0,0,0xf5c1,0,0,0,0xe0c4, 0x924b,0xe0c3,0xf5c2,0xec8b,0x9854,0x9482,0,0, /* 0,0,0,'狳',0,0,0,'狷', '狸','狹','狺','狻','狼','狽',0,0, */
	/* 7300 */ 0,0,0,0,0,0,0,0xf5c3, 0,0,0xe0c7,0,0,0,0,0, /* 0,0,0,0,0,0,0,'猇', 0,0,'猊',0,0,0,0,0, */
	/* 7310 */ 0,0,0xf5c4,0,0,0,0xe0c9,0xe0c6, 0xf5c5,0xf5c6,0,0x96d2,0xe0c8,0xe0ca,0,0x97c2, /* 0,0,'猒',0,0,0,'猖','猗', '猘','猙',0,'猛','猜','猝',0,'猟', */
	/* 7320 */ 0,0,0,0,0,0xe0ce,0,0xec8d, 0xec8e,0xe0cd,0x9296,0x944c,0xf5c9,0,0x8ca3,0xe0cc, /* 0,0,0,0,0,'猥',0,'猧', '猨','猩','猪','猫','猬',0,'献','猯', */
	/* 7330 */ 0,0xf5ca,0,0xf5cb,0xe0cb,0,0x9750,0x9751, 0,0xf5c8,0,0,0,0xf5cc,0xe0cf,0x898e, /* 0,'猱',0,'猳','猴',0,'猶','猷', 0,'猹',0,0,0,'猽','猾','猿', */
	/* 7340 */ 0,0,0,0,0x8d96,0x8e82,0,0, 0,0,0,0,0,0,0xe0d0,0xe0d1, /* 0,0,0,0,'獄','獅',0,0, 0,0,0,0,0,0,'獎','獏', */
	/* 7350 */ 0xec90,0,0xf5cd,0,0,0,0,0xe0d3, 0,0,0,0,0,0,0,0, /* '獐',0,'獒',0,0,0,0,'獗', 0,0,0,0,0,0,0,0, */
	/* 7360 */ 0,0,0,0x8f62,0,0,0xec91,0, 0xe0d5,0,0xe0d4,0xf5cf,0xf5d0,0,0xf5d2,0xf5d3, /* 0,0,0,'獣',0,0,'獦',0, '獨',0,'獪','獫','獬',0,'獮','獯', */
	/* 7370 */ 0xe0d6,0xf5d4,0x8a6c,0,0,0xe0d8,0,0xf5d5, 0xe0d7,0,0xe0da,0xe0d9,0xec92,0,0,0, /* '獰','獱','獲',0,0,'獵',0,'獷', '獸',0,'獺','獻','獼',0,0,0, */
	/* 7380 */ 0,0xf5d6,0,0,0x8cba,0xf5d7,0,0x97a6, 0,0x8bca,0xf5d8,0x89a4,0,0,0,0, /* 0,'玁',0,0,'玄','玅',0,'率', 0,'玉','玊','王',0,0,0,0, */
	/* 7390 */ 0,0,0,0,0xf5d9,0xec93,0x8be8,0, 0xf5da,0,0,0,0xf5db,0,0xf5dc,0xec94, /* 0,0,0,0,'玔','玕','玖',0, '玘',0,0,0,'玜',0,'玞','玟', */
	/* 73a0 */ 0xec95,0,0xec96,0,0,0xf5dd,0xec97,0, 0xf5de,0x8adf,0,0xec98,0,0,0,0, /* '玠',0,'玢',0,0,'玥','玦',0, '玨','玩',0,'玫',0,0,0,0, */
	/* 73b0 */ 0,0,0x97e6,0xe0dc,0,0xf5df,0,0xf5e0, 0,0xf5e1,0,0xe0de,0xf5e2,0,0,0xf5e3, /* 0,0,'玲','玳',0,'玵',0,'玷', 0,'玹',0,'玻','玼',0,0,'玿', */
	/* 73c0 */ 0xe0df,0,0x89cf,0,0,0xf5e4,0,0, 0xe0db,0xec99,0x8e58,0xf5e5,0,0x92bf,0xe0dd,0xec9a, /* '珀',0,'珂',0,0,'珅',0,0, '珈','珉','珊','珋',0,'珍','珎','珏', */
	/* 73d0 */ 0,0,0,0,0,0,0xec9b,0, 0,0xec9c,0,0,0,0,0xe0e2,0, /* 0,0,0,0,0,0,'珖',0, 0,'珙',0,0,0,0,'珞',0, */
	/* 73e0 */ 0x8eec,0xf5e6,0,0xec9d,0,0xe0e0,0,0xf5e7, 0,0xec9e,0x8c5d,0,0,0x94c7,0xe0e1,0, /* '珠','珡',0,'珣',0,'珥',0,'珧', 0,'珩','珪',0,0,'班','珮',0, */
	/* 73f0 */ 0,0xe0fc,0,0,0,0,0,0, 0xe0e7,0xf5e8,0xf5ea,0,0,0,0x8cbb,0, /* 0,'珱',0,0,0,0,0,0, '珸','珹','珺',0,0,0,'現',0, */
	/* 7400 */ 0,0xf5eb,0,0x8b85,0,0xe0e4,0x979d,0xec9f, 0,0x97ae,0xeca0,0,0,0,0,0, /* 0,'琁',0,'球',0,'琅','理','琇', 0,'琉','琊',0,0,0,0,0, */
	/* 7410 */ 0,0,0,0xf5e9,0,0,0,0, 0,0,0xeca1,0xeca2,0,0,0,0, /* 0,0,0,'琓',0,0,0,0, 0,0,'琚','琛',0,0,0,0, */
	/* 7420 */ 0,0,0x91f4,0,0xf5ec,0xe0e6,0xeca4,0, 0xeca5,0,0xeca6,0xeca7,0xeca8,0,0xeca9,0xecaa, /* 0,0,'琢',0,'琤','琥','琦',0, '琨',0,'琪','琫','琬',0,'琮','琯', */
	/* 7430 */ 0xecab,0xf5ed,0xe0e8,0x97d4,0x8bd5,0x94fa,0x9469,0, 0,0xf5ee,0xe0e9,0,0,0,0,0xe0eb, /* '琰','琱','琲','琳','琴','琵','琶',0, 0,'琹','琺',0,0,0,0,'琿', */
	/* 7440 */ 0xf5f0,0xe0ee,0,0xf5f1,0xecac,0,0xecad,0xecae, 0,0,0,0xecaf,0,0xf5f2,0,0, /* '瑀','瑁',0,'瑃','瑄',0,'瑆','瑇', 0,0,0,'瑋',0,'瑍',0,0, */
	/* 7450 */ 0,0,0xf5f3,0xf5ef,0,0xe0ea,0,0xecb0, 0,0xe0ed,0x8ce8,0x896c,0xe0ef,0xf5f4,0x9090,0xe0ec, /* 0,0,'瑒','瑓',0,'瑕',0,'瑗', 0,'瑙','瑚','瑛','瑜','瑝','瑞','瑟', */
	/* 7460 */ 0x97da,0,0xecb1,0xe0f2,0xeaa2,0,0,0, 0,0xe0f0,0xe0f3,0xecb2,0,0xecb3,0,0xe0e5, /* '瑠',0,'瑢','瑣','瑤',0,0,0, 0,'瑩','瑪','瑫',0,'瑭',0,'瑯', */
	/* 7470 */ 0xe0f1,0xf5f5,0,0x8dba,0,0,0xe0f4,0, 0,0,0,0,0,0,0xe0f5,0, /* '瑰','瑱',0,'瑳',0,0,'瑶',0, 0,0,0,0,0,0,'瑾',0, */
	/* 7480 */ 0,0xf5f6,0,0x979e,0,0xf5f7,0xecb4,0xecb5, 0xf5f8,0xecb6,0,0xe0f6,0,0,0,0, /* 0,'璁',0,'璃',0,'璅','璆','璇', '璈','璉',0,'璋',0,0,0,0, */
	/* 7490 */ 0xecbb,0,0xf5fa,0,0,0,0,0xf5fb, 0xecb7,0xf5fc,0,0,0xecb8,0,0xe0f7,0xecb9, /* '璐',0,'璒',0,0,0,0,'璗', '璘','璙',0,0,'璜',0,'璞','璟', */
	/* 74a0 */ 0xf640,0xf641,0xe0e3,0xecba,0,0xf642,0xecbc,0xe0f8, 0xecbd,0xecbe,0xf643,0xf644,0,0,0,0, /* '璠','璡','璢','璣',0,'璥','璦','璧', '璨','璩','璪','璫',0,0,0,0, */
	/* 74b0 */ 0x8ac2,0,0,0,0,0xecbf,0,0, 0,0xf645,0xf647,0xf646,0,0x8ea3,0,0xecc0, /* '環',0,0,0,0,'璵',0,0, 0,'璹','璺','璻',0,'璽',0,'璿', */
	/* 74c0 */ 0,0,0,0,0,0,0,0, 0xecc1,0xecc2,0xe0f9,0,0,0,0,0xe0fa, /* 0,0,0,0,0,0,0,0, '瓈','瓉','瓊',0,0,0,0,'瓏', */
	/* 74d0 */ 0,0,0,0,0xe0fb,0,0xf648,0, 0xf649,0,0xecc3,0,0x895a,0,0xf64a,0, /* 0,0,0,0,'瓔',0,'瓖',0, '瓘',0,'瓚',0,'瓜',0,'瓞',0, */
	/* 74e0 */ 0xe140,0,0x955a,0xe141,0,0,0x8aa2,0xe142, 0,0xe143,0,0xf64c,0,0,0xe144,0xf64b, /* '瓠',0,'瓢','瓣',0,0,'瓦','瓧', 0,'瓩',0,'瓫',0,0,'瓮','瓯', */
	/* 74f0 */ 0xe146,0xe147,0xe145,0,0,0,0x9572,0xe149, 0xe148,0,0xf64e,0,0,0,0,0xecc4, /* '瓰','瓱','瓲',0,0,0,'瓶','瓷', '瓸',0,'瓺',0,0,0,0,'瓿', */
	/* 7500 */ 0,0xecc5,0,0xe14b,0xe14a,0xe14c,0,0, 0,0,0,0,0xe14d,0xe14f,0xe14e,0, /* 0,'甁',0,'甃','甄','甅',0,0, 0,0,0,0,'甌','甍','甎',0, */
	/* 7510 */ 0,0x8d99,0,0xe151,0,0xe150,0,0xecc6, 0x8ac3,0,0x9072,0,0x935b,0,0xe152,0x90b6, /* 0,'甑',0,'甓',0,'甕',0,'甗', '甘',0,'甚',0,'甜',0,'甞','生', */
	/* 7520 */ 0xf650,0,0,0x8e59,0xf651,0x8999,0xe153,0, 0x9770,0,0xf652,0x95e1,0xe154,0,0,0xecc7, /* '甠',0,0,'産','甤','甥','甦',0, '用',0,'甪','甫','甬',0,0,'甯', */
	/* 7530 */ 0x9363,0x9752,0x8d62,0x905c,0,0,0,0x926a, 0x99b2,0,0x92ac,0x89e6,0xe155,0xf655,0xf656,0, /* '田','由','甲','申',0,0,0,'男', '甸',0,'町','画','甼','甽','甾',0, */
	/* 7540 */ 0xf657,0,0,0,0xe156,0,0xe15b,0, 0xf658,0xe159,0xe158,0x9dc0,0x8a45,0xe157,0xf659,0x88d8, /* '畀',0,0,0,'畄',0,'畆',0, '畈','畉','畊','畋','界','畍','畎','畏', */
	/* 7550 */ 0xf65a,0x94a8,0xf65b,0,0x94c8,0,0,0, 0,0x97af,0xe15c,0xe15a,0x927b,0x90a4,0,0, /* '畐','畑','畒',0,'畔',0,0,0, 0,'留','畚','畛','畜','畝',0,0, */
	/* 7560 */ 0x94a9,0,0x954c,0,0xe15e,0x97aa,0x8c6c,0xe15f, 0,0xe15d,0x94d4,0xe160,0xf65c,0xe161,0,0xecc8, /* '畠',0,'畢',0,'畤','略','畦','畧', 0,'畩','番','畫','畬','畭',0,'畯', */
	/* 7570 */ 0x88d9,0xf65e,0xf65d,0x8ff4,0xe166,0,0xe163,0x93eb, 0xe162,0xecc9,0xf65f,0,0,0xf660,0xf661,0x8b45, /* '異','畱','畲','畳','畴',0,'當','畷', '畸','畹','畺',0,0,'畽','畾','畿', */
	/* 7580 */ 0,0xf662,0xe169,0,0,0,0xe164,0xe165, 0,0xe168,0xe167,0x9544,0xf664,0,0x9161,0x9160, /* 0,'疁','疂',0,0,0,'疆','疇', 0,'疉','疊','疋','疌',0,'疎','疏', */
	/* 7590 */ 0,0x8b5e,0xecca,0,0xe16a,0,0,0, 0,0,0xe16b,0,0,0xe16c,0,0, /* 0,'疑','疒',0,'疔',0,0,0, 0,0,'疚',0,0,'疝',0,0, */
	/* 75a0 */ 0,0,0xf666,0xe16e,0,0xe16d,0,0, 0,0,0,0x8975,0,0,0,0, /* 0,0,'疢','疣',0,'疥',0,0, 0,0,0,'疫',0,0,0,0, */
	/* 75b0 */ 0xf668,0xe176,0x94e6,0xe170,0,0xe172,0,0xf669, 0xe174,0x905d,0,0,0xe175,0xe173,0x8ebe,0xf66a, /* '疰','疱','疲','疳',0,'疵',0,'疷', '疸','疹',0,0,'疼','疽','疾','疿', */
	/* 75c0 */ 0xf66b,0,0xe16f,0xe171,0,0x9561,0xf66c,0x8fc7, 0,0,0xe178,0,0,0xe177,0xeccc,0xf66d, /* '痀',0,'痂','痃',0,'病','痆','症', 0,0,'痊',0,0,'痍','痎','痏', */
	/* 75d0 */ 0,0,0xe179,0xf66e,0x8ea4,0x8dad,0,0, 0x9397,0xe17a,0,0x92c9,0,0xf66f,0xe17c,0xf670, /* 0,0,'痒','痓','痔','痕',0,0, '痘','痙',0,'痛',0,'痝','痞','痟', */
	/* 75e0 */ 0xf671,0,0x979f,0xe17b,0xeccd,0,0,0xf672, 0,0x9189,0,0,0xf673,0,0xf674,0, /* '痠',0,'痢','痣','痤',0,0,'痧', 0,'痩',0,0,'痬',0,'痮',0, */
	/* 75f0 */ 0xe182,0xf675,0xe184,0xe185,0x9273,0,0,0, 0,0xf676,0xe183,0,0xe180,0,0xe17d,0xe17e, /* '痰','痱','痲','痳','痴',0,0,0, 0,'痹','痺',0,'痼',0,'痾','痿', */
	/* 7600 */ 0xecce,0xe181,0xeccf,0xf677,0,0,0,0xf679, 0xecd0,0xe188,0,0xe186,0,0xe187,0,0xf67a, /* '瘀','瘁','瘂','瘃',0,0,0,'瘇', '瘈','瘉',0,'瘋',0,'瘍',0,'瘏', */
	/* 7610 */ 0,0,0,0xf67d,0,0xecd1,0xecd2,0, 0xf678,0xecd3,0,0xf67e,0xf680,0,0xecd4,0xe189, /* 0,0,0,'瘓',0,'瘕','瘖',0, '瘘','瘙',0,'瘛','瘜',0,'瘞','瘟', */
	/* 7620 */ 0xe18b,0xe18c,0xe18d,0,0xe18e,0xf682,0xeffb,0xe18a, 0xf683,0,0,0,0,0xecd5,0,0, /* '瘠','瘡','瘢',0,'瘤','瘥','瘦','瘧', '瘨',0,0,0,0,'瘭',0,0, */
	/* 7630 */ 0xe190,0,0,0xf685,0xe18f,0xecd6,0,0, 0,0,0,0xe191,0xf684,0,0,0, /* '瘰',0,0,'瘳','瘴','瘵',0,0, 0,0,0,'瘻','瘼',0,0,0, */
	/* 7640 */ 0,0xf688,0x97c3,0xecd7,0,0,0xe194,0xe192, 0xe193,0xf68a,0,0xecd8,0x8ae0,0,0,0, /* 0,'癁','療','癃',0,0,'癆','癇', '癈','癉',0,'癋','癌',0,0,0, */
	/* 7650 */ 0,0,0x96fc,0,0,0xf68b,0x95c8,0, 0xe196,0,0,0,0xe195,0,0,0, /* 0,0,'癒',0,0,'癕','癖',0, '癘',0,0,0,'癜',0,0,0, */
	/* 7660 */ 0,0xe197,0xe198,0,0xecd9,0xecda,0,0xe19c, 0xe199,0xe19a,0xe19b,0,0xe19d,0xecdb,0xf68d,0xecdc, /* 0,'癡','癢',0,'癤','癥',0,'癧', '癨','癩','癪',0,'癬','癭','癮','癯', */
	/* 7670 */ 0xe19e,0xecdd,0xe19f,0,0,0,0xe1a0,0, 0xe1a1,0,0x94ad,0x936f,0xe1a2,0x9492,0x9553,0, /* '癰','癱','癲',0,0,0,'癶',0, '癸',0,'発','登','發','白','百',0, */
	/* 7680 */ 0xe1a3,0xecde,0,0xe1a4,0x9349,0,0x8a46,0x8d63, 0xe1a5,0,0,0xe1a6,0,0,0xe1a7,0, /* '皀','皁',0,'皃','的',0,'皆','皇', '皈',0,0,'皋',0,0,'皎',0, */
	/* 7690 */ 0x8e48,0,0,0xe1a9,0,0xf68e,0xe1a8,0, 0,0xe1aa,0xe1ab,0xecdf,0xf68f,0xece0,0xece1,0, /* '皐',0,0,'皓',0,'皕','皖',0, 0,'皙','皚','皛','皜','皝','皞',0, */
	/* 76a0 */ 0xf691,0xf690,0,0,0,0,0xece2,0xf692, 0xf693,0,0xece3,0,0,0,0x94e7,0xf694, /* '皠','皡',0,0,0,0,'皦','皧', '皨',0,'皪',0,0,0,'皮','皯', */
	/* 76b0 */ 0xe1ac,0,0,0,0xe1ad,0,0xece4,0xea89, 0xe1ae,0xe1af,0xe1b0,0,0,0,0,0x8e4d, /* '皰',0,0,0,'皴',0,'皶','皷', '皸','皹','皺',0,0,0,0,'皿', */
	/* 76c0 */ 0,0,0xe1b1,0x9475,0,0xece5,0x967e,0, 0x896d,0xf696,0x8976,0,0xece6,0xe1b2,0xece7,0, /* 0,0,'盂','盃',0,'盅','盆',0, '盈','盉','益',0,'盌','盍','盎',0, */
	/* 76d0 */ 0,0,0xe1b4,0,0xece8,0,0xe1b3,0x9390, 0,0,0,0x90b7,0x9f58,0,0xe1b5,0x96bf, /* 0,0,'盒',0,'盔',0,'盖','盗', 0,0,0,'盛','盜',0,'盞','盟', */
	/* 76e0 */ 0,0xe1b6,0,0x8ac4,0x94d5,0xe1b7,0xece9,0xe1b8, 0xf698,0,0xe1b9,0,0xf699,0,0x96da,0, /* 0,'盡',0,'監','盤','盥','盦','盧', '盨',0,'盪',0,'盬',0,'目',0, */
	/* 76f0 */ 0,0xecea,0x96d3,0,0x92bc,0,0,0, 0x918a,0,0,0xe1bb,0xeceb,0,0x8f82,0, /* 0,'盱','盲',0,'直',0,0,0, '相',0,0,'盻','盼',0,'盾',0, */
	/* 7700 */ 0,0x8fc8,0,0,0xe1be,0,0,0xe1bd, 0xe1bc,0x94fb,0xecec,0x8ac5,0x8ca7,0,0,0, /* 0,'省',0,0,'眄',0,0,'眇', '眈','眉','眊','看','県',0,0,0, */
	/* 7710 */ 0,0,0,0,0,0,0,0xf69b, 0,0xeced,0xf69c,0xe1c4,0,0,0xe1c1,0x905e, /* 0,0,0,0,0,0,0,'眗', 0,'眙','眚','眛',0,0,'眞','真', */
	/* 7720 */ 0x96b0,0,0,0,0xe1c0,0xe1c2,0xe1c3,0, 0,0xe1bf,0,0,0,0xf69d,0,0, /* '眠',0,0,0,'眤','眥','眦',0, 0,'眩',0,0,0,'眭',0,0, */
	/* 7730 */ 0,0,0,0,0xecee,0xf69e,0xecef,0xe1c5, 0xe1c6,0,0x92ad,0,0x8ae1,0,0,0, /* 0,0,0,0,'眴','眵','眶','眷', '眸',0,'眺',0,'眼',0,0,0, */
	/* 7740 */ 0x9285,0,0,0,0,0,0xecf0,0xe1c7, 0,0,0,0,0,0xecf1,0xecf2,0, /* '着',0,0,0,0,0,'睆','睇', 0,0,0,0,0,'睍','睎',0, */
	/* 7750 */ 0,0,0,0,0,0,0,0, 0xf6a3,0,0xe1c8,0xe1cb,0xecf3,0,0,0xecf4, /* 0,0,0,0,0,0,0,0, '睘',0,'睚','睛','睜',0,0,'睟', */
	/* 7760 */ 0xf6a4,0x9087,0xecf5,0x93c2,0,0xe1cc,0x9672,0, 0xe1c9,0,0xf6a5,0xe1ca,0,0,0,0, /* '睠','睡','睢','督',0,'睥','睦',0, '睨',0,'睪','睫',0,0,0,0, */
	/* 7770 */ 0,0,0xf6a7,0,0,0,0,0, 0,0xe1cf,0xecf6,0,0xf6a8,0xf6a9,0xe1ce,0xe1cd, /* 0,0,'睲',0,0,0,0,0, 0,'睹','睺',0,'睼','睽','睾','睿', */
	/* 7780 */ 0xecf7,0,0,0,0,0,0,0, 0,0,0,0xe1d1,0,0,0xe1d0,0, /* '瞀',0,0,0,0,0,0,0, 0,0,0,'瞋',0,0,'瞎',0, */
	/* 7790 */ 0,0xe1d2,0,0,0xecf8,0,0,0, 0,0,0xf6ac,0,0,0,0xe1d4,0xf6ad, /* 0,'瞑',0,0,'瞔',0,0,0, 0,0,'瞚',0,0,0,'瞞','瞟', */
	/* 77a0 */ 0xe1d3,0,0xf6ae,0,0xf6af,0x95cb,0,0, 0,0xf6b0,0xecf9,0,0x8f75,0x97c4,0,0, /* '瞠',0,'瞢',0,'瞤','瞥',0,0, 0,'瞩','瞪',0,'瞬','瞭',0,0, */
	/* 77b0 */ 0xe1d5,0,0,0x93b5,0,0,0xe1d6,0, 0,0xe1d7,0,0xe1db,0xe1d9,0xe1da,0,0xe1d8, /* '瞰',0,0,'瞳',0,0,'瞶',0, 0,'瞹',0,'瞻','瞼','瞽',0,'瞿', */
	/* 77c0 */ 0,0,0,0,0,0,0,0xe1dc, 0,0,0,0,0,0xe1dd,0,0, /* 0,0,0,0,0,0,0,'矇', 0,0,0,0,0,'矍',0,0, */
	/* 77d0 */ 0,0,0,0,0,0,0,0xe1de, 0,0,0xe1df,0x96b5,0xe1e0,0,0xf6b1,0xf6b2, /* 0,0,0,0,0,0,0,'矗', 0,0,'矚','矛','矜',0,'矞','矟', */
	/* 77e0 */ 0xecfa,0,0x96ee,0xe1e1,0xf6b3,0x926d,0xf6b4,0x948a, 0,0x8be9,0xf6b5,0,0xf6b6,0x925a,0xe1e2,0x8bb8, /* '矠',0,'矢','矣','矤','知','矦','矧', 0,'矩','矪',0,'矬','短','矮','矯', */
	/* 77f0 */ 0xf6b8,0,0,0x90ce,0xf6b9,0,0,0, 0,0,0,0xf6ba,0xe1e3,0,0,0, /* '矰',0,0,'石','矴',0,0,0, 0,0,0,'矻','矼',0,0,0, */
	/* 7800 */ 0,0,0x8dbb,0,0,0xf6bc,0xf6bd,0, 0,0xf6be,0,0,0xe1e4,0xf6bf,0,0, /* 0,0,'砂',0,0,'砅','砆',0, 0,'砉',0,0,'砌','砍',0,0, */
	/* 7810 */ 0,0,0xe1e5,0,0x8ca4,0x8dd3,0,0, 0,0xf6c0,0,0,0,0,0,0, /* 0,0,'砒',0,'研','砕',0,0, 0,'砙',0,0,0,0,0,0, */
	/* 7820 */ 0xe1e7,0xf6c1,0,0,0,0x9375,0x8dd4,0x8b6d, 0,0,0,0,0xf6c2,0xecfb,0,0, /* '砠','砡',0,0,0,'砥','砦','砧', 0,0,0,0,'砬','砭',0,0, */
	/* 7830 */ 0,0,0x9643,0,0x946a,0,0,0, 0,0,0x9376,0,0,0,0,0x8d7b, /* 0,0,'砲',0,'破',0,0,0, 0,0,'砺',0,0,0,0,'砿', */
	/* 7840 */ 0,0,0,0xed40,0,0xe1e9,0,0xf6c3, 0,0,0,0,0,0,0xed41,0xed42, /* 0,0,0,'硃',0,'硅',0,'硇', 0,0,0,0,0,0,'硎','硏', */
	/* 7850 */ 0,0xed43,0,0,0,0,0,0, 0,0,0,0,0,0x8fc9,0,0, /* 0,'硑',0,0,0,0,0,0, 0,0,0,0,0,'硝',0,0, */
	/* 7860 */ 0,0,0,0,0xf6c4,0,0,0, 0xed44,0,0xf6c5,0x97b0,0x8d64,0,0xed45,0x8ca5, /* 0,0,0,0,'硤',0,0,0, '硨',0,'硪','硫','硬',0,'确','硯', */
	/* 7870 */ 0,0,0x94a1,0,0xe1eb,0,0,0, 0,0,0,0,0xe1ed,0,0,0, /* 0,0,'硲',0,'硴',0,0,0, 0,0,0,0,'硼',0,0,0, */
	/* 7880 */ 0,0x8ce9,0,0,0,0,0xe1ec,0x92f4, 0,0,0xf6c7,0,0xe1ef,0x8a56,0xe1ea,0, /* 0,'碁',0,0,0,0,'碆','碇', 0,0,'碊',0,'碌','碍','碎',0, */
	/* 7890 */ 0,0x94e8,0,0x894f,0xf6c8,0x8dea,0,0x9871, 0,0,0xe1ee,0,0,0xf6ca,0xf6cb,0xf6cc, /* 0,'碑',0,'碓','碔','碕',0,'碗', 0,0,'碚',0,0,'碝','碞','碟', */
	/* 78a0 */ 0,0,0,0xe1f0,0xf6c9,0,0,0x95c9, 0,0x90d7,0xe1f2,0,0,0xed49,0,0xe1f3, /* 0,0,0,'碣','碤',0,0,'碧', 0,'碩','碪',0,0,'碭',0,'碯', */
	/* 78b0 */ 0xed47,0,0,0,0,0xe1f1,0,0, 0,0,0x8a6d,0xf6cd,0xe1f9,0,0xe1f8,0, /* '碰',0,0,0,0,'碵',0,0, 0,0,'確','碻','碼',0,'碾',0, */
	/* 78c0 */ 0,0x8ea5,0,0,0,0xe1fa,0xe1f5,0, 0xf6ce,0,0xe1fb,0xe1f6,0xf6cf,0,0xf6d0,0, /* 0,'磁',0,0,0,'磅','磆',0, '磈',0,'磊','磋','磌',0,'磎',0, */
	/* 78d0 */ 0x94d6,0xe1f4,0,0,0xe1f7,0xf6d1,0,0, 0,0,0xe241,0,0,0,0,0, /* '磐','磑',0,0,'磔','磕',0,0, 0,0,'磚',0,0,0,0,0, */
	/* 78e0 */ 0xf6d2,0xf6d3,0,0,0xed4a,0,0xf6d4,0xe240, 0x9681,0,0,0,0xe1fc,0,0,0x88e9, /* '磠','磡',0,0,'磤',0,'磦','磧', '磨',0,0,0,'磬',0,0,'磯', */
	/* 78f0 */ 0,0,0xed4b,0,0xe243,0,0,0xed4d, 0,0xf6d5,0xf6d6,0xf6d7,0,0xe242,0xf6d8,0, /* 0,0,'磲',0,'磴',0,0,'磷', 0,'磹','磺','磻',0,'磽','磾',0, */
	/* 7900 */ 0xed4c,0x8fca,0,0,0,0,0,0xe244, 0,0,0,0,0,0,0x9162,0, /* '礀','礁',0,0,0,0,0,'礇', 0,0,0,0,0,0,'礎',0, */
	/* 7910 */ 0xf6da,0xe246,0xe245,0,0,0,0,0, 0,0xe247,0,0xf6db,0xed4e,0,0,0, /* '礐','礑','礒',0,0,0,0,0, 0,'礙',0,'礛','礜',0,0,0, */
	/* 7920 */ 0,0,0,0,0,0xf6dd,0xe1e6,0, 0,0,0xe1e8,0xe249,0xe248,0,0xed4f,0, /* 0,0,0,0,0,'礥','礦',0, 0,0,'礪','礫','礬',0,'礮',0, */
	/* 7930 */ 0xf6dc,0xed50,0,0,0xed51,0,0,0, 0,0,0x8ea6,0xf6de,0x97e7,0,0x8ed0,0, /* '礰','礱',0,0,'礴',0,0,0, 0,0,'示','礻','礼',0,'社',0, */
	/* 7940 */ 0xe24a,0x8c56,0,0,0,0xed54,0xed55,0x8b5f, 0x8b46,0x8e83,0xf6df,0,0,0,0,0, /* '祀','祁',0,0,0,'祅','祆','祇', '祈','祉','祊',0,0,0,0,0, */
	/* 7950 */ 0x9753,0,0,0xe250,0,0xe24f,0x9163,0xe24c, 0xf6e0,0,0xe24e,0xf6e1,0xed59,0x8f6a,0x905f,0xe24d, /* '祐',0,0,'祓',0,'祕','祖','祗', '祘',0,'祚','祛','祜','祝','神','祟', */
	/* 7960 */ 0xe24b,0,0x9449,0,0,0x8fcb,0,0xf6e3, 0x955b,0,0,0,0,0x8dd5,0,0, /* '祠',0,'祢',0,0,'祥',0,'祧', '票',0,0,0,0,'祭',0,0, */
	/* 7970 */ 0,0,0xf6e4,0,0,0,0,0x9398, 0,0xed5d,0xe251,0,0,0,0,0xe252, /* 0,0,'祲',0,0,0,0,'祷', 0,'祹','祺',0,0,0,0,'祿', */
	/* 7980 */ 0xe268,0x8bd6,0,0,0x985c,0x9154,0,0, 0,0,0xe253,0,0,0x89d0,0x92f5,0x959f, /* '禀','禁',0,0,'禄','禅',0,0, 0,0,'禊',0,0,'禍','禎','福', */
	/* 7990 */ 0,0,0,0,0xf6e5,0xf6e6,0xf6e7,0, 0xed61,0,0,0xf6e8,0,0xe254,0,0, /* 0,0,0,0,'禔','禕','禖',0, '禘',0,0,'禛',0,'禝',0,0, */
	/* 79a0 */ 0,0xf6e9,0,0,0,0,0x8b9a,0xe255, 0,0xf6ea,0xe257,0,0,0,0xe258,0, /* 0,'禡',0,0,0,0,'禦','禧', 0,'禩','禪',0,0,0,'禮',0, */
	/* 79b0 */ 0x9448,0xed62,0,0xe259,0xf6eb,0,0,0, 0xed63,0xe25a,0xe25b,0xf6ec,0,0x8bd7,0x89d1,0x93c3, /* '禰','禱',0,'禳','禴',0,0,0, '禸','禹','禺','离',0,'禽','禾','禿', */
	/* 79c0 */ 0x8f47,0x8e84,0xf6ed,0,0,0,0,0xf6ee, 0xed64,0xe25c,0xed65,0x8f48,0xf6ef,0xf6f0,0,0, /* '秀','私','秂',0,0,0,0,'秇', '秈','秉','秊','秋','秌','种',0,0, */
	/* 79d0 */ 0,0x89c8,0x9562,0,0xed67,0xe25d,0xf6f1,0, 0x94e9,0,0,0,0,0,0xed68,0x9164, /* 0,'科','秒',0,'秔','秕','秖',0, '秘',0,0,0,0,0,'秞','租', */
	/* 79e0 */ 0,0xe260,0,0xe261,0x9489,0,0x9060,0xe25e, 0,0x9281,0,0xed69,0xe25f,0xed6a,0,0, /* 0,'秡',0,'秣','秤',0,'秦','秧', 0,'秩',0,'秫','秬','秭',0,0, */
	/* 79f0 */ 0x8fcc,0,0,0,0,0,0,0, 0,0,0,0x88da,0,0,0,0, /* '称',0,0,0,0,0,0,0, 0,0,0,'移',0,0,0,0, */
	/* 7a00 */ 0x8b48,0,0,0xed6b,0,0,0,0, 0xe262,0,0xf6f6,0x92f6,0,0xe263,0x90c5,0, /* '稀',0,0,'稃',0,0,0,0, '稈',0,'稊','程',0,'稍','税',0, */
	/* 7a10 */ 0,0xf6f7,0,0,0x96ab,0xf6f8,0,0x9542, 0xe264,0xe265,0x9274,0xf6f9,0x97c5,0,0xf6fa,0xe267, /* 0,'稑',0,0,'稔','稕',0,'稗', '稘','稙','稚','稛','稜',0,'稞','稟', */
	/* 7a20 */ 0xe266,0,0,0,0,0,0,0, 0,0,0,0,0,0xf6fc,0x8eed,0, /* '稠',0,0,0,0,0,0,0, 0,0,0,0,0,'稭','種',0, */
	/* 7a30 */ 0,0xe269,0x88ee,0,0,0,0,0xe26c, 0xf740,0xed6d,0,0xe26a,0x89d2,0x8c6d,0xe26b,0x8d65, /* 0,'稱','稲',0,0,0,0,'稷', '稸','稹',0,'稻','稼','稽','稾','稿', */
	/* 7a40 */ 0x8d92,0,0x95e4,0xe26d,0,0,0x9673,0xf741, 0,0xe26f,0,0,0xf742,0x90cf,0x896e,0x89b8, /* '穀',0,'穂','穃',0,0,'穆','穇', 0,'穉',0,0,'穌','積','穎','穏', */
	/* 7a50 */ 0x88aa,0,0,0,0,0,0xf743,0xe26e, 0,0xf744,0,0,0xf745,0xed6e,0,0xf746, /* '穐',0,0,0,0,0,'穖','穗', 0,'穙',0,0,'穜','穝',0,'穟', */
	/* 7a60 */ 0xf747,0xe270,0xe271,0x8ff5,0,0,0,0xf748, 0,0xe272,0xf749,0x8a6e,0,0xed6f,0,0, /* '穠','穡','穢','穣',0,0,0,'穧', 0,'穩','穪','穫',0,'穭',0,0, */
	/* 7a70 */ 0xe274,0,0,0,0x8c8a,0xf74a,0x8b86,0, 0xf74b,0xe275,0x8bf3,0,0,0xe276,0,0x90fa, /* '穰',0,0,0,'穴','穵','究',0, '穸','穹','空',0,0,'穽',0,'穿', */
	/* 7a80 */ 0,0x93cb,0xf74c,0x90de,0x8df3,0xed71,0,0, 0xe277,0,0xf74d,0,0,0,0,0, /* 0,'突','窂','窃','窄','窅',0,0, '窈',0,'窊',0,0,0,0,0, */
	/* 7a90 */ 0xf74e,0,0x9282,0x918b,0,0xe279,0xe27b,0xe278, 0xe27a,0,0,0,0,0,0,0x8c41, /* '窐',0,'窒','窓',0,'窕','窖','窗', '窘',0,0,0,0,0,0,'窟', */
	/* 7aa0 */ 0xed72,0,0,0xf74f,0,0,0,0, 0,0xe27c,0x8c45,0,0xf750,0,0x8b87,0x9771, /* '窠',0,0,'窣',0,0,0,0, 0,'窩','窪',0,'窬',0,'窮','窯', */
	/* 7ab0 */ 0xe27e,0,0,0xed74,0,0,0xe280,0, 0,0xf753,0x894d,0xed75,0xf754,0,0xf755,0xe283, /* '窰',0,0,'窳',0,0,'窶',0, 0,'窹','窺','窻','窼',0,'窾','窿', */
	/* 7ac0 */ 0,0,0,0x8a96,0xe282,0xe281,0,0xe285, 0xe27d,0,0xe286,0x97a7,0xf757,0xe287,0xed76,0xe288, /* 0,0,0,'竃','竄','竅',0,'竇', '竈',0,'竊','立','竌','竍','竎','竏', */
	/* 7ad0 */ 0,0xf758,0x9af2,0xe28a,0,0xe289,0,0, 0,0xe28b,0xe28c,0,0x97b3,0xe28d,0,0xe8ed, /* 0,'竑','竒','竓',0,'竕',0,0, 0,'站','竚',0,'竜','竝',0,'竟', */
	/* 7ae0 */ 0x8fcd,0xe28e,0xe28f,0x8f76,0,0x93b6,0xe290,0xf759, 0xf75a,0,0x9247,0xed77,0,0xe291,0,0x925b, /* '章','竡','竢','竣',0,'童','竦','竧', '竨',0,'竪','竫',0,'竭',0,'端', */
	/* 7af0 */ 0xe292,0,0,0,0xf75b,0,0x8ba3,0, 0x995e,0x927c,0x8eb1,0,0,0xed78,0,0x8ac6, /* '竰',0,0,0,'竴',0,'競',0, '竸','竹','竺',0,0,'竽',0,'竿', */
	/* 7b00 */ 0,0,0xe293,0,0xe2a0,0,0xe296,0xf75e, 0x8b88,0,0xe295,0xe2a2,0,0,0,0xe294, /* 0,0,'笂',0,'笄',0,'笆','笇', '笈',0,'笊','笋',0,0,0,'笏', */
	/* 7b10 */ 0,0x8fce,0xed79,0,0,0,0,0, 0xe298,0xe299,0,0x934a,0,0,0xe29a,0, /* 0,'笑','笒',0,0,0,0,0, '笘','笙',0,'笛',0,0,'笞',0, */
	/* 7b20 */ 0x8a7d,0,0,0,0,0x9079,0x9584,0xf761, 0xe29c,0,0xf762,0,0x91e6,0xed7a,0xf763,0xf764, /* '笠',0,0,0,0,'笥','符','笧', '笨',0,'笪',0,'第','笭','笮','笯', */
	/* 7b30 */ 0,0xf765,0,0xe297,0,0xe29b,0xe29d,0, 0,0x8df9,0,0xed7b,0,0xf760,0,0, /* 0,'笱',0,'笳',0,'笵','笶',0, 0,'笹',0,'笻',0,'笽',0,0, */
	/* 7b40 */ 0,0xf769,0,0,0,0xe2a4,0x954d,0xed7c, 0x94a4,0x9399,0,0x8bd8,0xe2a3,0xe2a1,0xed7d,0x94b3, /* 0,'筁',0,0,0,'筅','筆','筇', '筈','等',0,'筋','筌','筍','筎','筏', */
	/* 7b50 */ 0xe29e,0x927d,0x939b,0,0x939a,0xf76b,0x8df4,0, 0,0,0,0,0,0xe2b6,0,0, /* '筐','筑','筒',0,'答','筕','策',0, 0,0,0,0,0,'筝',0,0, */
	/* 7b60 */ 0xed7e,0,0,0,0xf76d,0xe2a6,0xf76e,0xe2a8, 0,0xf76f,0,0,0xe2ab,0xed80,0xe2ac,0xed81, /* '筠',0,0,0,'筤','筥','筦','筧', 0,'筩',0,0,'筬','筭','筮','筯', */
	/* 7b70 */ 0xe2a9,0xe2aa,0xed82,0xf770,0xe2a7,0xe2a5,0,0, 0,0xf76c,0xe29f,0,0,0,0,0xf768, /* '筰','筱','筲','筳','筴','筵',0,0, 0,'筹','筺',0,0,0,0,'筿', */
	/* 7b80 */ 0,0,0,0,0,0,0x95cd,0x89d3, 0,0,0,0xe2b3,0,0xe2b0,0,0xe2b5, /* 0,0,0,0,0,0,'箆','箇', 0,0,0,'箋',0,'箍',0,'箏', */
	/* 7b90 */ 0xf773,0xf774,0xe2b4,0,0x9493,0x96a5,0,0x8e5a, 0xe2ae,0xe2b7,0xe2b2,0xf775,0xe2b1,0xe2ad,0xed83,0xe2af, /* '箐','箑','箒',0,'箔','箕',0,'算', '箘','箙','箚','箛','箜','箝','箞','箟', */
	/* 7ba0 */ 0,0x8ac7,0,0,0,0,0,0, 0,0,0x925c,0,0,0x90fb,0,0xf777, /* 0,'管',0,0,0,0,0,0, 0,0,'箪',0,0,'箭',0,'箯', */
	/* 7bb0 */ 0,0x94a0,0,0,0xe2bc,0xf778,0,0, 0x94a2,0,0,0,0xf779,0,0,0, /* 0,'箱',0,0,'箴','箵',0,0, '箸',0,0,0,'箼',0,0,0, */
	/* 7bc0 */ 0x90df,0xe2b9,0,0,0x94cd,0xf77a,0xe2bd,0x95d1, 0,0x927a,0xf77b,0xe2b8,0xe2ba,0,0,0xe2bb, /* '節','篁',0,0,'範','篅','篆','篇', 0,'築','篊','篋','篌',0,0,'篏', */
	/* 7bd0 */ 0,0,0,0,0xf77e,0,0xf780,0xed85, 0,0xed86,0xf781,0,0,0xe2be,0,0, /* 0,0,0,0,'篔',0,'篖','篗', 0,'篙','篚',0,0,'篝',0,0, */
	/* 7be0 */ 0x8ec2,0,0,0,0x93c4,0xe2c3,0xe2c2,0, 0,0xe2bf,0xf782,0,0,0x9855,0,0, /* '篠',0,0,0,'篤','篥','篦',0, 0,'篩','篪',0,0,'篭',0,0, */
	/* 7bf0 */ 0xf783,0,0,0xe2c8,0,0,0xe2cc,0xe2c9, 0,0,0,0,0,0,0,0, /* '篰',0,0,'篳',0,0,'篶','篷', 0,0,0,0,0,0,0,0, */
	/* 7c00 */ 0xe2c5,0xed87,0,0xf784,0,0,0,0xe2c6, 0,0,0,0xf785,0,0xe2cb,0xf786,0xf787, /* '簀','簁',0,'簃',0,0,0,'簇', 0,0,0,'簋',0,'簍','簎','簏', */
	/* 7c10 */ 0,0xe2c0,0x99d3,0xe2c7,0xe2c1,0,0,0xe2ca, 0,0,0,0,0,0,0xed89,0xe2d0, /* 0,'簑','簒','簓','簔',0,0,'簗', 0,0,0,0,0,0,'簞','簟', */
	/* 7c20 */ 0xed8a,0x8ac8,0,0xe2cd,0,0,0xf788,0xe2ce, 0,0,0xe2cf,0xe2d2,0,0,0,0, /* '簠','簡',0,'簣',0,0,'簦','簧', 0,0,'簪','簫',0,0,0,0, */
	/* 7c30 */ 0,0xed88,0,0xed8b,0,0,0xed8c,0xe2d1, 0x94f4,0,0,0,0,0xe2d3,0x97fa,0x95eb, /* 0,'簱',0,'簳',0,0,'簶','簷', '簸',0,0,0,0,'簽','簾','簿', */
	/* 7c40 */ 0xe2d8,0,0,0xe2d5,0,0xf789,0,0, 0,0,0xf78a,0,0xe2d4,0x90d0,0,0xe2d7, /* '籀',0,0,'籃',0,'籅',0,0, 0,0,'籊',0,'籌','籍',0,'籏', */
	/* 7c50 */ 0xe2d9,0xf78b,0,0,0xe2d6,0,0xe2dd,0xf78c, 0xe2da,0xed8f,0,0,0,0,0xf78d,0xe2db, /* '籐','籑',0,0,'籔',0,'籖','籗', '籘','籙',0,0,0,0,'籞','籟', */
	/* 7c60 */ 0xe2c4,0xf78e,0,0,0xe2dc,0xe2de,0,0, 0,0xf78f,0,0,0xe2df,0xed90,0xf790,0xf791, /* '籠','籡',0,0,'籤','籥',0,0, 0,'籩',0,0,'籬','籭','籮','籯', */
	/* 7c70 */ 0xf792,0,0,0x95c4,0,0xe2e0,0,0, 0,0xed91,0,0,0,0,0x96e0,0, /* '籰',0,0,'米',0,'籵',0,0, 0,'籹',0,0,0,0,'籾',0, */
	/* 7c80 */ 0,0x8bcc,0x8c48,0xe2e1,0,0,0,0, 0,0x95b2,0,0x9088,0,0x96ae,0,0xed92, /* 0,'粁','粂','粃',0,0,0,0, 0,'粉',0,'粋',0,'粍',0,'粏', */
	/* 7c90 */ 0xe2e2,0,0x97b1,0,0xed93,0x9494,0,0x9165, 0x9453,0,0,0x8f6c,0,0,0,0x88be, /* '粐',0,'粒',0,'粔','粕',0,'粗', '粘',0,0,'粛',0,0,0,'粟', */
	/* 7ca0 */ 0xed94,0xe2e7,0xe2e5,0,0xe2e3,0x8a9f,0xf796,0x8fcf, 0xe2e8,0,0,0xe2e6,0,0xe2e4,0xe2ec,0, /* '粠','粡','粢',0,'粤','粥','粦','粧', '粨',0,0,'粫',0,'粭','粮',0, */
	/* 7cb0 */ 0,0xe2eb,0xe2ea,0xe2e9,0,0,0xf798,0xf799, 0,0xe2ed,0,0,0xed95,0xe2ee,0x90b8,0xf79a, /* 0,'粱','粲','粳',0,0,'粶','粷', 0,'粹',0,0,'粼','粽','精','粿', */
	/* 7cc0 */ 0xe2ef,0,0xe2f1,0,0xf79c,0xe2f0,0,0, 0xf79e,0,0x8cd0,0,0,0xf79f,0x9157,0, /* '糀',0,'糂',0,'糄','糅',0,0, '糈',0,'糊',0,0,'糍','糎',0, */
	/* 7cd0 */ 0,0,0xe2f3,0,0,0xed96,0x939c,0xf7a1, 0xe2f2,0xed97,0,0,0xe2f4,0xed98,0x95b3,0x918c, /* 0,0,'糒',0,0,'糕','糖','糗', '糘','糙',0,0,'糜','糝','糞','糟', */
	/* 7ce0 */ 0x8d66,0,0xe2f5,0,0,0,0xf7a3,0x97c6, 0,0,0,0xf7a4,0,0,0,0xe2f7, /* '糠',0,'糢',0,0,0,'糦','糧', 0,0,0,'糫',0,0,0,'糯', */
	/* 7cf0 */ 0,0,0xe2f8,0,0xe2f9,0xf7a6,0xe2fa,0, 0x8e85,0,0xe2fb,0x8c6e,0,0,0x8b8a,0, /* 0,0,'糲',0,'糴','糵','糶',0, '糸',0,'糺','系',0,0,'糾',0, */
	/* 7d00 */ 0x8b49,0,0xe340,0xf7a7,0x96f1,0x8d67,0xe2fc,0xed99, 0xed9a,0xf7a8,0xe343,0x96e4,0,0x945b,0,0, /* '紀',0,'紂','紃','約','紅','紆','紇', '紈','紉','紊','紋',0,'納',0,0, */
	/* 7d10 */ 0x9552,0,0xf7aa,0xed9b,0x8f83,0xe342,0,0x8ed1, 0x8d68,0x8e86,0x8b89,0x95b4,0xe341,0xed9c,0xf7ab,0, /* '紐',0,'紒','紓','純','紕',0,'紗', '紘','紙','級','紛','紜','紝','紞',0, */
	/* 7d20 */ 0x9166,0x9661,0x8df5,0xed9d,0,0,0,0, 0,0,0,0x8e87,0x92db,0,0xe346,0x97dd, /* '素','紡','索','紣',0,0,0,0, 0,0,0,'紫','紬',0,'紮','累', */
	/* 7d30 */ 0x8dd7,0xed9e,0xe347,0x9061,0,0xe349,0,0, 0,0x8fd0,0x8dae,0,0,0xf7ae,0xf7af,0xe348, /* '細','紱','紲','紳',0,'紵',0,0, 0,'紹','紺',0,0,'紽','紾','紿', */
	/* 7d40 */ 0xf7b0,0xed9f,0x8f49,0x8cbc,0x9167,0xe344,0xe34a,0xf7b1, 0xeda0,0,0,0xe345,0x8c6f,0,0xe34d,0xe351, /* '絀','絁','終','絃','組','絅','絆','絇', '絈',0,0,'絋','経',0,'絎','絏', */
	/* 7d50 */ 0x8c8b,0,0,0xeda1,0,0,0xe34c,0, 0,0xf7b5,0xf7b6,0xe355,0xeda2,0,0x8d69,0, /* '結',0,0,'絓',0,0,'絖',0, 0,'絙','絚','絛','絜',0,'絞',0, */
	/* 7d60 */ 0,0x978d,0x88ba,0xe352,0,0,0x8b8b,0, 0xe34f,0,0xf7b7,0,0,0,0xe350,0, /* 0,'絡','絢','絣',0,0,'給',0, '絨',0,'絪',0,0,0,'絮',0, */
	/* 7d70 */ 0xf7b8,0x939d,0xe34e,0xe34b,0,0x8a47,0x90e2,0, 0,0x8ca6,0xeda3,0,0,0xe357,0,0xf7ba, /* '絰','統','絲','絳',0,'絵','絶',0, 0,'絹','絺',0,0,'絽',0,'絿', */
	/* 7d80 */ 0,0,0,0xeda4,0,0,0xf7bc,0, 0xf7bd,0xe354,0,0xeda5,0xf7be,0,0,0xe356, /* 0,0,0,'綃',0,0,'綆',0, '綈','綉',0,'綋','綌',0,0,'綏', */
	/* 7d90 */ 0,0,0,0xe353,0,0,0,0xf7bf, 0,0x8c70,0x91b1,0xe358,0x918e,0xf7c1,0,0xe365, /* 0,0,0,'經',0,0,0,'綗', 0,'継','続','綛','綜','綝',0,'綟', */
	/* 7da0 */ 0xeda6,0,0xe361,0xe35b,0,0,0xeda7,0xf7c2, 0,0,0xf7c3,0xe35f,0x8ef8,0x88db,0xe35a,0xe362, /* '綠',0,'綢','綣',0,0,'綦','綧', 0,0,'綪','綫','綬','維','綮','綯', */
	/* 7db0 */ 0xe366,0x8d6a,0x96d4,0,0x92d4,0xe35c,0xf7c4,0xf7c5, 0xe364,0,0xe359,0x925d,0,0xe35e,0x88bb,0x96c8, /* '綰','綱','網',0,'綴','綵','綶','綷', '綸',0,'綺','綻',0,'綽','綾','綿', */
	/* 7dc0 */ 0xf7c6,0,0xeda8,0,0,0,0,0xe35d, 0,0,0x8bd9,0x94ea,0xeda9,0,0,0x918d, /* '緀',0,'緂',0,0,0,0,'緇', 0,0,'緊','緋','緌',0,0,'総', */
	/* 7dd0 */ 0,0x97ce,0x8f8f,0,0,0xe38e,0xedaa,0xf7c7, 0xe367,0xf7c8,0x90fc,0,0xe363,0xe368,0xe36a,0, /* 0,'緑','緒',0,0,'緕','緖','緗', '緘','緙','線',0,'緜','緝','緞',0, */
	/* 7de0 */ 0x92f7,0xe36d,0,0xedab,0xe369,0,0xf7c9,0, 0x95d2,0x8ac9,0,0,0x96c9,0,0,0x88dc, /* '締','緡',0,'緣','緤',0,'緦',0, '編','緩',0,0,'緬',0,0,'緯', */
	/* 7df0 */ 0,0xf7ca,0xe36c,0,0x97fb,0,0,0, 0,0xf7cb,0,0xe36b,0,0,0,0, /* 0,'緱','緲',0,'練',0,0,0, 0,'緹',0,'緻',0,0,0,0, */
	/* 7e00 */ 0,0x898f,0,0,0x93ea,0xe36e,0,0, 0xedae,0xe375,0xe36f,0xe376,0,0,0,0, /* 0,'縁',0,0,'縄','縅',0,0, '縈','縉','縊','縋',0,0,0,0, */
	/* 7e10 */ 0xf7cf,0xedaf,0xe372,0,0,0xedb0,0,0xf7d0, 0,0,0,0x949b,0,0xf7d1,0x8ec8,0xe374, /* '縐','縑','縒',0,0,'縕',0,'縗', 0,0,0,'縛',0,'縝','縞','縟', */
	/* 7e20 */ 0xf7d2,0xe371,0xe377,0xe370,0,0,0x8f63,0xf7d3, 0xedad,0,0,0x9644,0xf7d4,0,0x8f6b,0, /* '縠','縡','縢','縣',0,0,'縦','縧', '縨',0,0,'縫','縬',0,'縮',0, */
	/* 7e30 */ 0,0xe373,0xe380,0,0,0xe37b,0,0xe37e, 0,0xe37c,0xe381,0xe37a,0,0xe360,0x90d1,0, /* 0,'縱','縲',0,0,'縵',0,'縷', 0,'縹','縺','縻',0,'總','績',0, */
	/* 7e40 */ 0,0x94c9,0,0xe37d,0,0xf7d5,0xe378,0xedb2, 0,0,0x9140,0x8c71,0,0x8f4a,0,0, /* 0,'繁',0,'繃',0,'繅','繆','繇', 0,0,'繊','繋',0,'繍',0,0, */
	/* 7e50 */ 0,0,0xedb3,0,0x9044,0x9155,0xe384,0, 0,0xe386,0xe387,0,0,0xe383,0xe385,0, /* 0,0,'繒',0,'織','繕','繖',0, 0,'繙','繚',0,0,'繝','繞',0, */
	/* 7e60 */ 0,0xedb4,0,0,0,0,0xe379,0xe382, 0,0xe38a,0xe389,0xeffc,0,0x969a,0,0, /* 0,'繡',0,0,0,0,'繦','繧', 0,'繩','繪','繫',0,'繭',0,0, */
	/* 7e70 */ 0x8c4a,0,0,0xf7d6,0,0xf7d7,0,0, 0,0xe388,0,0xe38c,0xe38b,0xe38f,0xf7d8,0xe391, /* '繰',0,0,'繳',0,'繵',0,0, 0,'繹',0,'繻','繼','繽','繾','繿', */
	/* 7e80 */ 0,0,0x8e5b,0xe38d,0,0,0xf7d9,0xf7da, 0xe392,0xe393,0xedb5,0,0xe394,0xedb6,0xe39a,0x935a, /* 0,0,'纂','纃',0,0,'纆','纇', '纈','纉','纊',0,'續','纍','纎','纏', */
	/* 7e90 */ 0xe396,0xf7dc,0xe395,0xe397,0xe398,0,0xe399,0, 0xf7dd,0,0xf7de,0xe39b,0xe39c,0,0,0, /* '纐','纑','纒','纓','纔',0,'纖',0, '纘',0,'纚','纛','纜',0,0,0, */
	/* 7ea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7eb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7ef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 7f30 */ 0,0,0,0,0,0,0x8aca,0, 0xe39d,0,0xe39e,0xf7e1,0xf7e0,0,0xf7e2,0, /* 0,0,0,0,0,0,'缶',0, '缸',0,'缺','缻','缼',0,'缾',0, */
	/* 7f40 */ 0,0,0,0xf7e3,0xf7e4,0xe39f,0,0xedb7, 0,0,0,0,0xe3a0,0xe3a1,0xe3a2,0xf7e5, /* 0,0,0,'罃','罄','罅',0,'罇', 0,0,0,0,'罌','罍','罎','罏', */
	/* 7f50 */ 0xe3a3,0xe3a4,0xf7e8,0,0xe3a6,0xe3a5,0,0, 0xe3a7,0,0,0,0,0,0,0xe3a8, /* '罐','网','罒',0,'罔','罕',0,0, '罘',0,0,0,0,0,0,'罟', */
	/* 7f60 */ 0xe3a9,0xf7ea,0,0xf7eb,0xf7ec,0,0,0xe3ac, 0xe3aa,0xe3ab,0x8ddf,0x8c72,0,0xf7ed,0x9275,0, /* '罠','罡',0,'罣','罤',0,0,'罧', '罨','罩','罪','罫',0,'罭','置',0, */
	/* 7f70 */ 0x94b1,0,0x8f90,0,0,0x946c,0,0x94eb, 0xe3ad,0x9ceb,0,0,0,0xf7ee,0xf7ef,0, /* '罰',0,'署',0,0,'罵',0,'罷', '罸','罹',0,0,0,'罽','罾',0, */
	/* 7f80 */ 0,0,0xe3ae,0xe3b0,0,0x9785,0xe3af,0xe3b2, 0xe3b1,0,0x9772,0,0xe3b3,0,0x94fc,0, /* 0,0,'羂','羃',0,'羅','羆','羇', '羈',0,'羊',0,'羌',0,'美',0, */
	/* 7f90 */ 0xf7f1,0xedb9,0,0,0xe3b4,0,0xf7f4,0xedba, 0,0,0xe3b7,0,0xf7f5,0xe3b6,0xe3b5,0, /* '羐','羑',0,0,'羔',0,'羖','羗', 0,0,'羚',0,'羜','羝','羞',0, */
	/* 7fa0 */ 0,0,0,0xe3b8,0x8c51,0,0,0, 0x9141,0x8b60,0,0,0,0xf7f6,0xe3bc,0xe3b9, /* 0,0,0,'羣','群',0,0,0, '羨','義',0,0,0,'羭','羮','羯', */
	/* 7fb0 */ 0,0,0xe3ba,0,0,0,0xe3bd,0, 0xe3be,0xe3bb,0,0,0,0x8948,0,0xedbb, /* 0,0,'羲',0,0,0,'羶',0, '羸','羹',0,0,0,'羽',0,'羿', */
	/* 7fc0 */ 0,0x89a5,0,0xf7f8,0,0xe3c0,0xe3c1,0, 0,0,0xe3c2,0,0x9782,0,0xedbc,0xf7f9, /* 0,'翁',0,'翃',0,'翅','翆',0, 0,0,'翊',0,'翌',0,'翎','翏', */
	/* 7fd0 */ 0,0,0x8f4b,0,0xe3c4,0xe3c3,0,0, 0,0,0,0xedbd,0,0,0,0xedbe, /* 0,0,'習',0,'翔','翕',0,0, 0,0,0,'翛',0,0,0,'翟', */
	/* 7fe0 */ 0x9089,0xe3c5,0,0xf7fa,0,0xf7fb,0xe3c6,0, 0,0xe3c7,0,0x8ae3,0xedbf,0,0xedc0,0xf7fc, /* '翠','翡',0,'翣',0,'翥','翦',0, 0,'翩',0,'翫','翬',0,'翮','翯', */
	/* 7ff0 */ 0x8acb,0,0xf840,0xe3c8,0,0,0,0, 0,0xe3c9,0xedc1,0x967c,0x9783,0,0,0, /* '翰',0,'翲','翳',0,0,0,0, 0,'翹','翺','翻','翼',0,0,0, */
	/* 8000 */ 0x9773,0x9856,0xf841,0x8d6c,0xe3cc,0x8ed2,0xe3cb,0, 0xf843,0,0xf842,0xe3cd,0x8ea7,0,0xf844,0, /* '耀','老','耂','考','耄','者','耆',0, '耈',0,'耊','耋','而',0,'耎',0, */
	/* 8010 */ 0x91cf,0xf845,0xe3ce,0,0xedc3,0x8d6b,0xf846,0x96d5, 0xe3cf,0xe3d0,0,0,0xe3d1,0,0,0, /* '耐','耑','耒',0,'耔','耕','耖','耗', '耘','耙',0,0,'耜',0,0,0, */
	/* 8020 */ 0,0xe3d2,0,0,0xf847,0,0xedc4,0, 0xe3d3,0,0,0,0xf848,0,0,0, /* 0,'耡',0,0,'耤',0,'耦',0, '耨',0,0,0,'耬',0,0,0, */
	/* 8030 */ 0xf849,0,0,0x8ea8,0,0xedc5,0x96eb,0xedc6, 0,0,0,0xe3d5,0xedc7,0x925e,0,0xe3d4, /* '耰',0,0,'耳',0,'耵','耶','耷', 0,0,0,'耻','耼','耽',0,'耿', */
	/* 8040 */ 0,0,0,0xf84a,0,0,0xe3d7,0, 0,0,0xe3d6,0,0,0,0,0, /* 0,0,0,'聃',0,0,'聆',0, 0,0,'聊',0,0,0,0,0, */
	/* 8050 */ 0,0,0xe3d8,0,0,0,0x90b9,0, 0xe3d9,0,0xe3da,0,0,0,0x95b7,0xe3db, /* 0,0,'聒',0,0,0,'聖',0, '聘',0,'聚',0,0,0,'聞','聟', */
	/* 8060 */ 0,0x918f,0xe3dc,0,0,0,0xf84b,0, 0xe3dd,0,0,0,0,0,0,0x97fc, /* 0,'聡','聢',0,0,0,'聦',0, '聨',0,0,0,0,0,0,'聯', */
	/* 8070 */ 0xe3e0,0xf84c,0xe3df,0xe3de,0x92ae,0xf84d,0xe3e1,0x9045, 0,0xe3e2,0,0xf84e,0,0xe3e3,0x9857,0xe3e4, /* '聰','聱','聲','聳','聴','聵','聶','職', 0,'聹',0,'聻',0,'聽','聾','聿', */
	/* 8080 */ 0,0,0,0,0xe3e5,0xe3e7,0xe3e6,0x94a3, 0,0x93f7,0,0x985d,0x94a7,0,0,0, /* 0,0,0,0,'肄','肅','肆','肇', 0,'肉',0,'肋','肌',0,0,0, */
	/* 8090 */ 0,0,0,0xe3e9,0,0,0x8fd1,0, 0x9549,0xf84f,0xe3ea,0xe3e8,0xf850,0x8acc,0,0, /* 0,0,0,'肓',0,0,'肖',0, '肘','肙','肚','肛','肜','肝',0,0, */
	/* 80a0 */ 0,0x8cd2,0x8e88,0,0xf851,0x94ec,0,0xf852, 0,0x8ca8,0x9662,0,0xe3ed,0xe3eb,0,0x8d6d, /* 0,'股','肢',0,'肤','肥',0,'肧', 0,'肩','肪',0,'肬','肭',0,'肯', */
	/* 80b0 */ 0,0x8d6e,0x88e7,0,0x8de6,0,0,0, 0xf853,0,0x9478,0,0,0,0,0, /* 0,'肱','育',0,'肴',0,0,0, '肸',0,'肺',0,0,0,0,0, */
	/* 80c0 */ 0,0,0,0x88dd,0xe3f2,0xf855,0x925f,0, 0,0,0xedc8,0,0x9477,0,0x91d9,0, /* 0,0,0,'胃','胄','胅','胆',0, 0,0,'胊',0,'背',0,'胎',0, */
	/* 80d0 */ 0,0,0,0,0,0xf856,0xe3f4,0xedc9, 0xf857,0xe3f0,0xe3f3,0xe3ee,0,0xe3f1,0x9645,0, /* 0,0,0,0,0,'胕','胖','胗', '胘','胙','胚','胛',0,'胝','胞',0, */
	/* 80e0 */ 0xedca,0x8cd3,0,0,0x88fb,0xe3ef,0xf858,0, 0,0,0,0,0,0,0,0xe3f6, /* '胠','胡',0,0,'胤','胥','胦',0, 0,0,0,0,0,0,0,'胯', */
	/* 80f0 */ 0,0xe3f7,0,0xedcb,0x93b7,0xf85b,0,0, 0x8bb9,0,0,0xf85c,0xe445,0x945c,0,0, /* 0,'胱',0,'胳','胴','胵',0,0, '胸',0,0,'胻','胼','能',0,0, */
	/* 8100 */ 0,0,0x8e89,0,0,0x8bba,0x90c6,0x9865, 0x96ac,0xe3f5,0x90d2,0,0,0xf85a,0,0, /* 0,0,'脂',0,0,'脅','脆','脇', '脈','脉','脊',0,0,'脍',0,0, */
	/* 8110 */ 0,0,0,0,0,0,0xf85f,0, 0xedcc,0,0x8b72,0xe3f8,0,0,0xf860,0, /* 0,0,0,0,0,0,'脖',0, '脘',0,'脚','脛',0,0,'脞',0, */
	/* 8120 */ 0,0,0,0xe3fa,0xf862,0,0,0xf863, 0,0xe3f9,0,0,0xf864,0,0,0xe3fb, /* 0,0,0,'脣','脤',0,0,'脧', 0,'脩',0,0,'脬',0,0,'脯', */
	/* 8130 */ 0,0x9245,0,0x945d,0,0xf85e,0,0, 0,0x92af,0,0,0,0xf866,0xe442,0, /* 0,'脱',0,'脳',0,'脵',0,0, 0,'脹',0,0,0,'脽','脾',0, */
	/* 8140 */ 0,0,0,0,0,0,0xe441,0, 0,0,0xedcd,0xe3fc,0,0,0x9074,0, /* 0,0,0,0,0,0,'腆',0, 0,0,'腊','腋',0,0,'腎',0, */
	/* 8150 */ 0x9585,0xe444,0,0xe443,0x8d6f,0x9872,0,0, 0,0,0,0,0,0,0,0xe454, /* '腐','腑',0,'腓','腔','腕',0,0, 0,0,0,0,0,0,0,'腟', */
	/* 8160 */ 0xedce,0,0,0,0,0xe448,0xe449,0xedcf, 0xedd0,0xf868,0,0x8eee,0,0xedd1,0xe447,0, /* '腠',0,0,0,0,'腥','腦','腧', '腨','腩',0,'腫',0,'腭','腮',0, */
	/* 8170 */ 0x8d98,0xe446,0,0,0xe44a,0,0,0, 0x92b0,0x95a0,0x9142,0,0,0,0,0x91da, /* '腰','腱',0,0,'腴',0,0,0, '腸','腹','腺',0,0,0,0,'腿', */
	/* 8180 */ 0xe44e,0xf86a,0xe44f,0xe44b,0xf86c,0xf86d,0,0, 0xe44c,0,0xe44d,0,0,0,0,0x8d70, /* '膀','膁','膂','膃','膄','膅',0,0, '膈',0,'膊',0,0,0,0,'膏', */
	/* 8190 */ 0,0,0,0xe455,0,0xe451,0,0, 0xf86f,0,0x9586,0,0x968c,0x9547,0,0, /* 0,0,0,'膓',0,'膕',0,0, '膘',0,'膚',0,'膜','膝',0,0, */
	/* 81a0 */ 0xe450,0,0,0xe453,0xe452,0,0,0, 0x9663,0xe456,0,0,0,0,0,0, /* '膠',0,0,'膣','膤',0,0,0, '膨','膩',0,0,0,0,0,0, */
	/* 81b0 */ 0xe457,0,0xf870,0x9156,0,0xe458,0,0, 0xe45a,0,0xe45e,0xedd2,0,0xe45b,0xe459,0x945e, /* '膰',0,'膲','膳',0,'膵',0,0, '膸',0,'膺','膻',0,'膽','膾','膿', */
	/* 81c0 */ 0xe45c,0xf871,0xe45d,0xf872,0,0,0x89b0,0, 0xe464,0xe45f,0xedd3,0,0,0xe460,0,0xedd4, /* '臀','臁','臂','臃',0,0,'臆',0, '臈','臉','臊',0,0,'臍',0,'臏', */
	/* 81d0 */ 0,0xe461,0,0x919f,0,0,0xf873,0xedd5, 0xe463,0xe462,0xe465,0xf874,0,0,0,0xe466, /* 0,'臑',0,'臓',0,0,'臖','臗', '臘','臙','臚','臛',0,0,0,'臟', */
	/* 81e0 */ 0xe467,0,0,0x9062,0xf876,0x89e7,0,0xe468, 0x97d5,0,0x8ea9,0,0xf878,0x8f4c,0,0, /* '臠',0,0,'臣','臤','臥',0,'臧', '臨',0,'自',0,'臬','臭',0,0, */
	/* 81f0 */ 0,0,0,0x8e8a,0x9276,0,0,0, 0,0,0xe469,0xe46a,0x8950,0xf87a,0xe46b,0xf87b, /* 0,0,0,'至','致',0,0,0, 0,0,'臺','臻','臼','臽','臾','臿', */
	/* 8200 */ 0,0xe46c,0xe46d,0,0xf87d,0xe46e,0,0xe46f, 0x8bbb,0x9da8,0xe470,0,0x90e3,0xe471,0x8ec9,0, /* 0,'舁','舂',0,'舄','舅',0,'與', '興','舉','舊',0,'舌','舍','舎',0, */
	/* 8210 */ 0xe472,0,0x98ae,0,0,0,0xe473,0x95dc, 0x8ada,0xf880,0,0x9143,0x8f77,0,0x9591,0x8f4d, /* '舐',0,'舒',0,0,0,'舖','舗', '舘','舙',0,'舛','舜',0,'舞','舟', */
	/* 8220 */ 0,0xf881,0xf882,0,0,0,0,0, 0,0xe474,0x8d71,0xe475,0x94ca,0,0xe484,0, /* 0,'舡','舢',0,0,0,0,0, 0,'舩','航','舫','般',0,'舮',0, */
	/* 8230 */ 0,0,0xf884,0xe477,0xf885,0x91c7,0x9495,0x8cbd, 0xe476,0x9144,0,0,0xf886,0,0,0, /* 0,0,'舲','舳','舴','舵','舶','舷', '舸','船',0,0,'舼',0,0,0, */
	/* 8240 */ 0xe478,0,0,0,0,0xf889,0xf887,0x92f8, 0,0xf888,0,0xf88b,0,0,0,0xf88d, /* '艀',0,0,0,0,'艅','艆','艇', 0,'艉',0,'艋',0,0,0,'艏', */
	/* 8250 */ 0,0,0,0,0,0,0,0xf88f, 0xe47a,0xe479,0xe47c,0,0xf891,0xe47b,0,0xe47d, /* 0,0,0,0,0,0,0,'艗', '艘','艙','艚',0,'艜','艝',0,'艟', */
	/* 8260 */ 0xedd9,0,0xe480,0xf892,0xe47e,0,0x8acd,0, 0xe481,0,0xe482,0xe483,0,0,0x8daf,0x97c7, /* '艠',0,'艢','艣','艤',0,'艦',0, '艨',0,'艪','艫',0,0,'艮','良', */
	/* 8270 */ 0,0xe485,0x9046,0,0xedda,0,0x8990,0xe486, 0xe487,0xf896,0,0,0,0xf898,0xe488,0xf899, /* 0,'艱','色',0,'艴',0,'艶','艷', '艸','艹',0,0,0,'艽','艾','艿', */
	/* 8280 */ 0,0,0,0xf89a,0,0,0,0, 0,0,0xf89b,0x88f0,0,0xe489,0xeddc,0, /* 0,0,0,'芃',0,0,0,0, 0,0,'芊','芋',0,'芍','芎',0, */
	/* 8290 */ 0,0,0xe48a,0xf89c,0,0,0,0, 0,0x9587,0,0,0,0x8ec5,0,0xe48c, /* 0,0,'芒','芓',0,0,0,0, 0,'芙',0,0,0,'芝',0,'芟', */
	/* 82a0 */ 0,0xeddd,0,0xedde,0xeddf,0x8a48,0x88b0,0xf89d, 0xf89e,0xede0,0,0xe48b,0xe48e,0x946d,0xede1,0x9063, /* 0,'芡',0,'芣','芤','芥','芦','芧', '芨','芩',0,'芫','芬','芭','芮','芯', */
	/* 82b0 */ 0,0x89d4,0xf89f,0x9646,0xf8a0,0,0,0xede2, 0x8c7c,0x8bda,0xf8a1,0xe48d,0xf8a2,0x89e8,0xede3,0xede4, /* 0,'花','芲','芳','芴',0,0,'芷', '芸','芹','芺','芻','芼','芽','芾','芿', */
	/* 82c0 */ 0,0,0,0,0,0x8aa1,0xede5,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'苅','苆',0, 0,0,0,0,0,0,0,0, */
	/* 82d0 */ 0,0x8991,0xe492,0x97e8,0x91db,0xede6,0,0x9563, 0,0xe49e,0,0x89d5,0xe49c,0,0xe49a,0xe491, /* 0,'苑','苒','苓','苔','苕',0,'苗', 0,'苙',0,'苛','苜',0,'苞','苟', */
	/* 82e0 */ 0,0xe48f,0xf8a3,0xe490,0,0x8ee1,0x8bea,0x9297, 0xf8a4,0,0,0x93cf,0,0,0,0, /* 0,'苡','苢','苣',0,'若','苦','苧', '苨',0,0,'苫',0,0,0,0, */
	/* 82f0 */ 0,0x8970,0,0xe494,0xe493,0,0,0xf8a5, 0,0xe499,0xe495,0xe498,0,0xede7,0xede8,0, /* 0,'英',0,'苳','苴',0,0,'苷', 0,'苹','苺','苻',0,'苽','苾',0, */
	/* 8300 */ 0xede9,0xedea,0x96ce,0xe497,0x89d6,0x8a9d,0xe49b,0xf8a6, 0xf8a7,0xe49d,0,0,0xf8a8,0,0x8c73,0, /* '茀','茁','茂','范','茄','茅','茆','茇', '茈','茉',0,0,'茌',0,'茎',0, */
	/* 8310 */ 0,0,0,0,0,0,0xe4a1,0xe4aa, 0xe4ab,0,0,0xf8aa,0x88a9,0xf8ab,0,0, /* 0,0,0,0,0,0,'茖','茗', '茘',0,0,'茛','茜','茝',0,0, */
	/* 8320 */ 0,0,0xedec,0xe4b2,0,0,0,0, 0x88ef,0,0,0xe4a9,0,0xeded,0,0xe4a8, /* 0,0,'茢','茣',0,0,0,0, '茨',0,0,'茫',0,'茭',0,'茯', */
	/* 8330 */ 0xf8ac,0xe4a3,0xe4a2,0,0xe4a0,0xe49f,0x9283,0, 0x91f9,0xe4a5,0xedee,0,0xf8ad,0,0,0, /* '茰','茱','茲',0,'茴','茵','茶',0, '茸','茹','茺',0,'茼',0,0,0, */
	/* 8340 */ 0xe4a4,0,0,0xedef,0xf8ae,0xe4a7,0,0xedf0, 0,0x9190,0x8c74,0,0,0,0,0x8960, /* '荀',0,0,'荃','荄','荅',0,'荇', 0,'草','荊',0,0,0,0,'荏', */
	/* 8350 */ 0xe4a6,0xedf1,0x8d72,0,0xf8a9,0xedf2,0,0xf8af, 0x9191,0,0,0,0,0,0,0, /* '荐','荑','荒',0,'荔','荕',0,'荗', '荘',0,0,0,0,0,0,0, */
	/* 8360 */ 0,0,0xedeb,0xf3c8,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,0,'荢','荣',0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8370 */ 0,0,0,0xe4b8,0,0xe4b9,0,0x89d7, 0,0,0,0x89ac,0xe4b6,0xedf3,0,0xf8b1, /* 0,0,0,'荳',0,'荵',0,'荷', 0,0,0,'荻','荼','荽',0,'荿', */
	/* 8380 */ 0,0,0,0,0,0xe4ac,0xedf4,0xe4b4, 0,0xe4bb,0xe4b5,0,0,0xf8b4,0xe4b3,0, /* 0,0,0,0,0,'莅','莆','莇', 0,'莉','莊',0,0,'莍','莎',0, */
	/* 8390 */ 0,0,0xedf5,0xe496,0xf8b5,0xf8b6,0xe4b1,0, 0xedf6,0,0xe4ad,0xf8b7,0,0xf8b8,0x8ace,0xe4af, /* 0,0,'莒','莓','莔','莕','莖',0, '莘',0,'莚','莛',0,'莝','莞','莟', */
	/* 83a0 */ 0xe4ba,0,0xe4b0,0,0,0,0,0xedf7, 0xe4bc,0xedf8,0xe4ae,0x949c,0,0,0,0, /* '莠',0,'莢',0,0,0,0,'莧', '莨','莩','莪','莫',0,0,0,0, */
	/* 83b0 */ 0,0x9789,0,0,0,0xe4b7,0,0, 0,0,0,0,0,0xe4cd,0,0xedf9, /* 0,'莱',0,0,0,'莵',0,0, 0,0,0,0,0,'莽',0,'莿', */
	/* 83c0 */ 0xedfa,0xe4c5,0,0,0,0x909b,0,0xedfb, 0,0xf8b9,0x8b65,0,0x8bdb,0,0xe4c0,0xedfc, /* '菀','菁',0,0,0,'菅',0,'菇', 0,'菉','菊',0,'菌',0,'菎','菏', */
	/* 83d0 */ 0xf8ba,0xee40,0,0x89d9,0xf8bb,0,0x8fd2,0, 0xe4c3,0,0,0,0x8dd8,0xf8bc,0,0x9370, /* '菐','菑',0,'菓','菔',0,'菖',0, '菘',0,0,0,'菜','菝',0,'菟', */
	/* 83e0 */ 0xe4c8,0xee41,0,0,0,0xf8bd,0,0, 0,0x95ec,0xee42,0xe4bf,0,0,0,0x89d8, /* '菠','菡',0,0,0,'菥',0,0, 0,'菩','菪','菫',0,0,0,'華', */
	/* 83f0 */ 0x8cd4,0x9548,0xe4c9,0,0xe4bd,0,0,0xe4c6, 0,0xf8be,0,0xe4d0,0,0xe4c1,0,0, /* '菰','菱','菲',0,'菴',0,0,'菷', 0,'菹',0,'菻',0,'菽',0,0, */
	/* 8400 */ 0,0xee43,0,0xe4c2,0x93b8,0,0xee44,0xe4c7, 0,0,0xee45,0xe4c4,0x9647,0xe4ca,0x88de,0xf8bf, /* 0,'萁',0,'萃','萄',0,'萆','萇', 0,0,'萊','萋','萌','萍','萎','萏', */
	/* 8410 */ 0,0xf8c0,0,0xe4be,0,0xf8c1,0,0xf8c3, 0,0,0,0,0,0,0,0, /* 0,'萑',0,'萓',0,'萕',0,'萗', 0,0,0,0,0,0,0,0, */
	/* 8420 */ 0xe4cc,0,0xe4cb,0,0,0,0,0, 0,0x948b,0xe4d2,0,0xe4dd,0,0,0, /* '萠',0,'萢',0,0,0,0,0, 0,'萩','萪',0,'萬',0,0,0, */
	/* 8430 */ 0,0x8a9e,0,0,0,0xe4e0,0,0, 0xe4ce,0xf8c4,0,0,0xe4d3,0x978e,0,0, /* 0,'萱',0,0,0,'萵',0,0, '萸','萹',0,0,'萼','落',0,0, */
	/* 8440 */ 0,0,0,0,0,0,0xe4dc,0, 0xee47,0x9774,0xf8c5,0,0,0,0x97a8,0xf8c6, /* 0,0,0,0,0,0,'葆',0, '葈','葉','葊',0,0,0,'葎','葏', */
	/* 8450 */ 0,0xf8c7,0xf8c8,0,0,0,0,0x9298, 0,0xf8c9,0xf8ca,0x8a8b,0xf8cb,0,0,0xee48, /* 0,'葑','葒',0,0,0,0,'著', 0,'葙','葚','葛','葜',0,0,'葟', */
	/* 8460 */ 0,0x9592,0xe4e2,0x939f,0,0xf8cd,0x88af,0, 0,0xe4db,0,0xe4d7,0x9192,0xe4d1,0xe4d9,0xe4de, /* 0,'葡','葢','董',0,'葥','葦',0, 0,'葩',0,'葫','葬','葭','葮','葯', */
	/* 8470 */ 0xee49,0x944b,0,0xee4a,0,0x88a8,0xf8ce,0xe4d6, 0xf8cf,0xe4df,0x9598,0,0xf8d0,0,0,0, /* '葰','葱',0,'葳',0,'葵','葶','葷', '葸','葹','葺',0,'葼',0,0,0, */
	/* 8480 */ 0,0xf8d1,0xe4da,0,0xe4d5,0xee4b,0,0, 0,0,0,0x8fd3,0,0,0,0, /* 0,'蒁','蒂',0,'蒄','蒅',0,0, 0,0,0,'蒋',0,0,0,0, */
	/* 8490 */ 0x8f4e,0,0,0,0x8eaa,0,0,0xf8d4, 0,0x96d6,0,0,0x9566,0,0xee4c,0xe4e5, /* '蒐',0,0,0,'蒔',0,0,'蒗', 0,'蒙',0,0,'蒜',0,'蒞','蒟', */
	/* 84a0 */ 0,0xe4ee,0,0,0,0,0xf8d5,0, 0,0,0,0,0,0xe4d8,0,0xee4d, /* 0,'蒡',0,0,0,0,'蒦',0, 0,0,0,0,0,'蒭',0,'蒯', */
	/* 84b0 */ 0,0,0x8a97,0,0xee4e,0,0,0, 0x8ff6,0xe4e3,0xee4f,0xe4e8,0x9193,0,0xf8d6,0xe4e4, /* 0,0,'蒲',0,'蒴',0,0,0, '蒸','蒹','蒺','蒻','蒼',0,'蒾','蒿', */
	/* 84c0 */ 0xee50,0xe4eb,0xee51,0,0x927e,0,0xe4ec,0, 0,0x9775,0xe4e1,0x8a57,0,0xe4e7,0xf8d8,0xf8d9, /* '蓀','蓁','蓂',0,'蓄',0,'蓆',0, 0,'蓉','蓊','蓋',0,'蓍','蓎','蓏', */
	/* 84d0 */ 0xe4ea,0x96aa,0,0xf8da,0,0,0xe4ed,0, 0,0xe4e6,0xe4e9,0,0xf8d3,0,0,0, /* '蓐','蓑',0,'蓓',0,0,'蓖',0, 0,'蓙','蓚',0,'蓜',0,0,0, */
	/* 84e0 */ 0,0,0,0,0,0,0,0xf8dc, 0,0,0xf8dd,0,0x9648,0,0x9840,0xf8de, /* 0,0,0,0,0,0,0,'蓧', 0,0,'蓪',0,'蓬',0,'蓮','蓯', */
	/* 84f0 */ 0xf8df,0xf8e0,0,0,0xe4f1,0,0,0, 0,0,0xf8e1,0,0xe4f8,0xf8e2,0,0xe4f0, /* '蓰','蓱',0,0,'蓴',0,0,0, 0,0,'蓺',0,'蓼','蓽',0,'蓿', */
	/* 8500 */ 0x8ec1,0,0,0,0,0,0xe4cf,0, 0,0,0,0,0xf8e3,0,0,0, /* '蔀',0,0,0,0,0,'蔆',0, 0,0,0,0,'蔌',0,0,0, */
	/* 8510 */ 0,0x95cc,0,0x96a0,0xe4f7,0xe4f6,0,0xe4f2, 0xe4f3,0,0x8955,0xf8e4,0,0,0xee54,0xe4f5, /* 0,'蔑',0,'蔓','蔔','蔕',0,'蔗', '蔘',0,'蔚','蔛',0,0,'蔞','蔟', */
	/* 8520 */ 0,0xe4ef,0,0xee55,0xf8e5,0xf8e6,0x92d3,0, 0,0,0,0xf8e7,0xe4f4,0x88fc,0,0xee56, /* 0,'蔡',0,'蔣','蔤','蔥','蔦',0, 0,0,0,'蔫','蔬','蔭',0,'蔯', */
	/* 8530 */ 0,0,0xee53,0,0xf8e8,0x91a0,0,0, 0,0,0,0,0,0x95c1,0xf8ed,0, /* 0,0,'蔲',0,'蔴','蔵',0,0, 0,0,0,0,0,'蔽','蔾',0, */
	/* 8540 */ 0xe4f9,0xe540,0,0x94d7,0,0,0,0, 0xe4fc,0x8fd4,0x8ec7,0xe542,0,0,0x8bbc,0xf8e9, /* '蕀','蕁',0,'蕃',0,0,0,0, '蕈','蕉','蕊','蕋',0,0,'蕎','蕏', */
	/* 8550 */ 0,0xf8ee,0,0xf8ef,0,0xe543,0,0x9599, 0xe4fb,0xee57,0xe4d4,0,0,0,0xf8f0,0, /* 0,'蕑',0,'蕓',0,'蕕',0,'蕗', '蕘','蕙','蕚',0,0,0,'蕞',0, */
	/* 8560 */ 0,0xf8f1,0xf8f2,0xe4fa,0xee58,0,0,0, 0x986e,0x93a0,0x9593,0,0,0xe54a,0,0xf8ea, /* 0,'蕡','蕢','蕣','蕤',0,0,0, '蕨','蕩','蕪',0,0,'蕭',0,'蕯', */
	/* 8570 */ 0,0,0,0,0,0,0,0xe550, 0,0,0xee5b,0xf8f4,0,0xf8f5,0xe551,0xf8f6, /* 0,0,0,0,0,0,0,'蕷', 0,0,'蕺','蕻',0,'蕽','蕾','蕿', */
	/* 8580 */ 0xe544,0xf8f7,0,0,0x9496,0,0xf8f8,0xe54e, 0xe546,0,0xe548,0,0xee5c,0,0,0xee5d, /* '薀','薁',0,0,'薄',0,'薆','薇', '薈',0,'薊',0,'薌',0,0,'薏', */
	/* 8590 */ 0xe552,0xe547,0,0xf8f9,0xe54b,0,0,0x8992, 0,0x93e3,0,0xe54c,0xe54f,0xf8fa,0,0xf8fb, /* '薐','薑',0,'薓','薔',0,0,'薗', 0,'薙',0,'薛','薜','薝',0,'薟', */
	/* 85a0 */ 0,0,0xee5e,0,0xe545,0,0x9145,0, 0xe549,0x8e46,0x9064,0x8c4f,0x96f2,0xee5a,0x96f7,0x8f92, /* 0,0,'薢',0,'薤',0,'薦',0, '薨','薩','薪','薫','薬','薭','薮','薯', */
	/* 85b0 */ 0xee5f,0,0,0,0,0,0,0xf942, 0,0xe556,0xe554,0,0xf943,0,0,0, /* '薰',0,0,0,0,0,0,'薷', 0,'薹','薺',0,'薼',0,0,0, */
	/* 85c0 */ 0,0x986d,0,0,0,0,0,0xf944, 0,0xe553,0xf945,0xee60,0,0x9795,0xee61,0xe555, /* 0,'藁',0,0,0,0,0,'藇', 0,'藉','藊','藋',0,'藍','藎','藏', */
	/* 85d0 */ 0xe557,0,0,0,0,0xe558,0,0, 0xf946,0xf947,0,0,0xe55b,0xe559,0,0xf948, /* '藐',0,0,0,0,'藕',0,0, '藘','藙',0,0,'藜','藝',0,'藟', */
	/* 85e0 */ 0,0xf949,0,0,0x93a1,0xe55a,0xf94a,0, 0,0x94cb,0xe54d,0,0,0xee62,0,0, /* 0,'藡',0,0,'藤','藥','藦',0, 0,'藩','藪',0,0,'藭',0,0, */
	/* 85f0 */ 0,0,0,0,0,0,0xf94b,0x8f93, 0,0xe55c,0xe561,0x9194,0,0,0xe560,0xee64, /* 0,0,0,0,0,0,'藶','藷', 0,'藹','藺','藻',0,0,'藾','藿', */
	/* 8600 */ 0xf94c,0,0xe541,0,0xee65,0xee66,0xe562,0x9168, 0,0,0xe55d,0xe55f,0,0,0,0, /* '蘀',0,'蘂',0,'蘄','蘅','蘆','蘇', 0,0,'蘊','蘋',0,0,0,0, */
	/* 8610 */ 0xee67,0xf94d,0xee63,0xe55e,0,0,0x9f50,0x9f41, 0xee69,0,0xe564,0,0,0,0xf94e,0, /* '蘐','蘑','蘒','蘓',0,0,'蘖','蘗', '蘘',0,'蘚',0,0,0,'蘞',0, */
	/* 8620 */ 0,0xf94f,0xe563,0,0xf950,0,0,0xf951, 0,0xee6a,0,0,0,0x9796,0,0xe1ba, /* 0,'蘡','蘢',0,'蘤',0,0,'蘧', 0,'蘩',0,0,0,'蘭',0,'蘯', */
	/* 8630 */ 0xe565,0,0,0,0,0,0,0, 0xee6b,0xf953,0,0,0xf954,0,0,0xe566, /* '蘰',0,0,0,0,0,0,0, '蘸','蘹',0,0,'蘼',0,0,'蘿', */
	/* 8640 */ 0xf956,0x8888,0,0,0,0,0,0, 0,0,0,0,0,0xe567,0x8cd5,0, /* '虀','虁',0,0,0,0,0,0, 0,0,0,0,0,'虍','虎',0, */
	/* 8650 */ 0x8b73,0,0,0xf958,0xe569,0x997c,0xf959,0xee6c, 0,0,0x8b95,0xee6d,0x97b8,0,0x8bf1,0xe56a, /* '虐',0,0,'虓','虔','處','虖','虗', 0,0,'虚','虛','虜',0,'虞','號', */
	/* 8660 */ 0,0,0xee6f,0,0,0,0,0xe56b, 0,0,0,0x928e,0xee71,0,0,0xf95a, /* 0,0,'虢',0,0,0,0,'虧', 0,0,0,'虫','虬',0,0,'虯', */
	/* 8670 */ 0,0xe56c,0,0,0,0xee72,0,0xf95b, 0,0x93f8,0xf95c,0x88b8,0,0,0,0, /* 0,'虱',0,0,0,'虵',0,'虷', 0,'虹','虺','虻',0,0,0,0, */
	/* 8680 */ 0,0,0,0,0,0,0,0xf95d, 0,0xf95e,0x89e1,0xe571,0xe572,0xf95f,0,0, /* 0,0,0,0,0,0,0,'蚇', 0,'蚉','蚊','蚋','蚌','蚍',0,0, */
	/* 8690 */ 0,0xf960,0,0xe56d,0,0x8e5c,0,0, 0xee73,0,0,0,0xf961,0xf962,0,0, /* 0,'蚑',0,'蚓',0,'蚕',0,0, '蚘',0,0,0,'蚜','蚝',0,0, */
	/* 86a0 */ 0,0,0,0xe56e,0x9461,0,0,0, 0xf963,0xe56f,0xe570,0xe57a,0,0,0,0xe574, /* 0,0,0,'蚣','蚤',0,0,0, '蚨','蚩','蚪','蚫',0,0,0,'蚯', */
	/* 86b0 */ 0xe577,0xf965,0,0xf966,0,0,0xe573,0, 0xee74,0,0,0,0,0,0,0, /* '蚰','蚱',0,'蚳',0,0,'蚶',0, '蚸',0,0,0,0,0,0,0, */
	/* 86c0 */ 0,0xf967,0,0xf968,0xe575,0,0xe576,0x8ed6, 0,0xe578,0,0x9260,0,0x8c75,0x8a61,0, /* 0,'蛁',0,'蛃','蛄',0,'蛆','蛇', 0,'蛉',0,'蛋',0,'蛍','蛎',0, */
	/* 86d0 */ 0,0xf969,0,0,0xe57b,0xf96a,0,0xf96b, 0,0x8a5e,0,0xe581,0,0,0xe57c,0xe580, /* 0,'蛑',0,0,'蛔','蛕',0,'蛗', 0,'蛙',0,'蛛',0,0,'蛞','蛟', */
	/* 86e0 */ 0,0,0,0xf96c,0x94b8,0,0xf96d,0, 0,0xe57d,0,0,0xe57e,0x9567,0x94d8,0xe582, /* 0,0,0,'蛣','蛤',0,'蛦',0, 0,'蛩',0,0,'蛬','蛭','蛮','蛯', */
	/* 86f0 */ 0,0,0,0,0,0,0,0, 0x91fb,0xe58c,0xee75,0xe588,0xee76,0xee77,0x89e9,0, /* 0,0,0,0,0,0,0,0, '蛸','蛹','蛺','蛻','蛼','蛽','蛾',0, */
	/* 8700 */ 0xe586,0,0x9649,0xe587,0,0xf96f,0xe584,0xf970, 0xe585,0xe58a,0xe58d,0xee78,0,0xe58b,0xf971,0, /* '蜀',0,'蜂','蜃',0,'蜅','蜆','蜇', '蜈','蜉','蜊','蜋',0,'蜍','蜎',0, */
	/* 8710 */ 0xf972,0xe589,0xe583,0xf973,0,0,0,0, 0x9277,0xf974,0xe594,0,0x96a8,0,0,0xf975, /* '蜐','蜑','蜒','蜓',0,0,0,0, '蜘','蜙','蜚',0,'蜜',0,0,'蜟', */
	/* 8720 */ 0,0xf976,0,0xf977,0,0xe592,0,0, 0,0xe593,0,0,0,0,0,0, /* 0,'蜡',0,'蜣',0,'蜥',0,0, 0,'蜩',0,0,0,0,0,0, */
	/* 8730 */ 0,0xf978,0,0,0xe58e,0,0,0xe590, 0,0,0xf979,0xe591,0,0,0xf97a,0xe58f, /* 0,'蜱',0,0,'蜴',0,0,'蜷', 0,0,'蜺','蜻',0,0,'蜾','蜿', */
	/* 8740 */ 0xf97b,0,0,0xf97c,0,0,0,0, 0,0x90e4,0,0x9858,0xe598,0,0xe599,0, /* '蝀',0,0,'蝃',0,0,0,0, 0,'蝉',0,'蝋','蝌',0,'蝎',0, */
	/* 8750 */ 0,0xf97d,0,0xe59f,0,0x9049,0,0xe59b, 0xf97e,0xe59e,0,0,0,0,0,0xe596, /* 0,'蝑',0,'蝓',0,'蝕',0,'蝗', '蝘','蝙',0,0,0,0,0,'蝟', */
	/* 8760 */ 0xe595,0,0,0xe5a0,0xf980,0xf981,0x89da,0, 0xe59c,0,0xe5a1,0,0,0,0xe59d,0, /* '蝠',0,0,'蝣','蝤','蝥','蝦',0, '蝨',0,'蝪',0,0,0,'蝮',0, */
	/* 8770 */ 0,0xee79,0xf982,0,0xe59a,0,0x92b1,0, 0xe597,0,0,0,0xf983,0,0,0x9488, /* 0,'蝱','蝲',0,'蝴',0,'蝶',0, '蝸',0,0,0,'蝼',0,0,'蝿', */
	/* 8780 */ 0,0,0xe5a5,0,0,0,0,0xee7a, 0xee7b,0xf987,0,0xf988,0,0x975a,0,0, /* 0,0,'螂',0,0,0,0,'螇', '螈','螉',0,'螋',0,'融',0,0, */
	/* 8790 */ 0,0,0,0xf989,0,0,0,0, 0,0,0,0,0,0,0,0xe5a4, /* 0,0,0,'螓',0,0,0,0, 0,0,0,0,0,0,0,'螟', */
	/* 87a0 */ 0xf98a,0,0xe5a3,0,0,0,0,0xf986, 0,0,0,0xe5ac,0xee7c,0xee7d,0,0xe5a6, /* '螠',0,'螢',0,0,0,0,'螧', 0,0,0,'螫','螬','螭',0,'螯', */
	/* 87b0 */ 0,0,0,0xe5ae,0,0xee7e,0,0, 0,0,0x9786,0xe5b1,0,0xe5a8,0xf98d,0, /* 0,0,0,'螳',0,'螵',0,0, 0,0,'螺','螻',0,'螽','螾',0, */
	/* 87c0 */ 0xe5a9,0xf98f,0,0,0xe5ad,0,0xe5b0,0xe5af, 0,0,0,0xe5a7,0,0,0xf990,0, /* '蟀','蟁',0,0,'蟄',0,'蟆','蟇', 0,0,0,'蟋',0,0,'蟎',0, */
	/* 87d0 */ 0xe5aa,0,0xe5bb,0,0,0,0xee81,0, 0,0,0,0,0,0,0,0xf992, /* '蟐',0,'蟒',0,0,0,'蟖',0, 0,0,0,0,0,0,0,'蟟', */
	/* 87e0 */ 0xe5b4,0,0,0xf994,0,0xf995,0xf996,0, 0,0,0xf997,0xf998,0xee82,0xf999,0,0xe5b2, /* '蟠',0,0,'蟣',0,'蟥','蟦',0, 0,0,'蟪','蟫','蟬','蟭',0,'蟯', */
	/* 87f0 */ 0,0,0xe5b3,0,0,0xf991,0xe5b8,0xe5b9, 0,0x8a49,0,0x8b61,0,0,0xe5b7,0, /* 0,0,'蟲',0,0,'蟵','蟶','蟷', 0,'蟹',0,'蟻',0,0,'蟾',0, */
	/* 8800 */ 0,0xf99a,0,0xf99b,0,0xe5a2,0xee83,0, 0,0,0xee84,0xf99c,0,0xe5b6,0xe5ba,0xe5b5, /* 0,'蠁',0,'蠃',0,'蠅','蠆',0, 0,0,'蠊','蠋',0,'蠍','蠎','蠏', */
	/* 8810 */ 0xee85,0xe5bc,0,0xf99d,0xee86,0xe5be,0xe5bd,0, 0,0,0,0,0,0,0,0xee87, /* '蠐','蠑',0,'蠓','蠔','蠕','蠖',0, 0,0,0,0,0,0,0,'蠟', */
	/* 8820 */ 0,0xe5c0,0xe5bf,0xe579,0,0,0,0xe5c4, 0xf99e,0,0,0,0,0,0xf99f,0, /* 0,'蠡','蠢','蠣',0,0,0,'蠧', '蠨',0,0,0,0,0,'蠮',0, */
	/* 8830 */ 0,0xe5c1,0xf9a0,0,0,0,0xe5c2,0, 0,0xe5c3,0,0xe5c5,0xf9a1,0,0,0, /* 0,'蠱','蠲',0,0,0,'蠶',0, 0,'蠹',0,'蠻','蠼',0,0,0, */
	/* 8840 */ 0x8c8c,0,0xe5c7,0,0xe5c6,0,0x8f4f,0, 0,0,0xf9a3,0,0x8d73,0x9fa5,0,0, /* '血',0,'衂',0,'衄',0,'衆',0, 0,0,'衊',0,'行','衍',0,0, */
	/* 8850 */ 0,0,0xe5c8,0x8f70,0,0,0,0x8a58, 0xf9a4,0xe5c9,0,0x8971,0,0x8fd5,0xe5ca,0xf9a5, /* 0,0,'衒','術',0,0,0,'街', '衘','衙',0,'衛',0,'衝','衞','衟', */
	/* 8860 */ 0,0x8d74,0xe5cb,0x88df,0xf9a6,0,0,0, 0x955c,0xf9a9,0,0xe5cc,0,0,0,0xf9ab, /* 0,'衡','衢','衣','衤',0,0,0, '表','衩',0,'衫',0,0,0,'衯', */
	/* 8870 */ 0x908a,0,0xe5d3,0,0,0xe5d0,0,0x928f, 0,0,0,0,0,0xe5d1,0xe5ce,0x8bdc, /* '衰',0,'衲',0,0,'衵',0,'衷', 0,0,0,0,0,'衽','衾','衿', */
	/* 8880 */ 0,0xe5cd,0xe5d4,0,0,0,0,0, 0x8c55,0,0,0x91dc,0,0xe5da,0,0, /* 0,'袁','袂',0,0,0,0,0, '袈',0,0,'袋',0,'袍',0,0, */
	/* 8890 */ 0,0,0xe5d6,0,0,0,0x91b3,0xe5d5, 0xee88,0xe5d8,0,0,0,0,0xe5cf,0, /* 0,0,'袒',0,0,0,'袖','袗', '袘','袙',0,0,0,0,'袞',0, */
	/* 88a0 */ 0xf9ac,0,0xe5d9,0,0xe5db,0,0,0, 0,0,0xee89,0x94ed,0,0,0xe5d7,0, /* '袠',0,'袢',0,'袤',0,0,0, 0,0,'袪','被',0,0,'袮',0, */
	/* 88b0 */ 0xe5dc,0xe5de,0,0,0x8cd1,0xe5d2,0,0x88bf, 0,0,0,0,0xf9ad,0xf9ae,0xf9af,0xe5dd, /* '袰','袱',0,0,'袴','袵',0,'袷', 0,0,0,0,'袼','袽','袾','袿', */
	/* 88c0 */ 0xf9b0,0x8dd9,0x97f4,0xe5df,0xe5e0,0x9195,0,0, 0,0,0xee8a,0,0,0,0xee8b,0x97a0, /* '裀','裁','裂','裃','裄','装',0,0, 0,0,'裊',0,0,0,'裎','裏', */
	/* 88d0 */ 0,0xf9b3,0xf9b1,0xf9b4,0xe5e1,0x9754,0,0, 0xe5e2,0xe5e3,0,0xf9b5,0x95e2,0xe5e4,0,0x8dbe, /* 0,'裑','裒','裓','裔','裕',0,0, '裘','裙',0,'裛','補','裝',0,'裟', */
	/* 88e0 */ 0,0x97a1,0,0,0,0,0,0, 0xe5e9,0,0,0,0,0,0,0, /* 0,'裡',0,0,0,0,0,0, '裨',0,0,0,0,0,0,0, */
	/* 88f0 */ 0xf9b6,0xf9b7,0xe5ea,0x8fd6,0xe5e8,0xee8d,0,0, 0x9787,0xe5e5,0,0,0xe5e7,0x90bb,0x909e,0, /* '裰','裱','裲','裳','裴','裵',0,0, '裸','裹',0,0,'裼','製','裾',0, */
	/* 8900 */ 0,0xf9b9,0xe5e6,0,0xe5eb,0,0,0x95a1, 0,0,0xe5ed,0,0xe5ec,0,0,0, /* 0,'褁','褂',0,'褄',0,0,'複', 0,0,'褊',0,'褌',0,0,0, */
	/* 8910 */ 0x8a8c,0,0x964a,0xe5ee,0,0,0,0, 0xee90,0xee91,0xee92,0,0xee8e,0xe5fa,0xe5f0,0, /* '褐',0,'褒','褓',0,0,0,0, '褘','褙','褚',0,'褜','褝','褞',0, */
	/* 8920 */ 0,0,0,0,0,0xe5f1,0,0xee93, 0,0,0xe5f2,0xe5f3,0,0,0,0, /* 0,0,0,0,0,'褥',0,'褧', 0,0,'褪','褫',0,0,0,0, */
	/* 8930 */ 0xee94,0,0xee95,0,0,0,0xe5f7,0xf9bb, 0xe5f8,0xee96,0,0xe5f6,0,0,0,0, /* '褰',0,'褲',0,0,0,'褶','褷', '褸','褹',0,'褻',0,0,0,0, */
	/* 8940 */ 0xee97,0xe5f4,0xf9bd,0xe5ef,0xe5f5,0xf9be,0,0, 0,0xf9bf,0,0,0xe5f9,0xe8b5,0,0, /* '襀','襁','襂','襃','襄','襅',0,0, 0,'襉',0,0,'襌','襍',0,0, */
	/* 8950 */ 0,0,0,0,0,0,0x89a6,0, 0,0,0,0,0,0,0xe5fc,0x8bdd, /* 0,0,0,0,0,0,'襖',0, 0,0,0,0,0,0,'襞','襟', */
	/* 8960 */ 0xe5fb,0,0xf9c2,0,0xe641,0,0xe640,0, 0,0,0xe643,0,0,0xe642,0,0xe644, /* '襠',0,'襢',0,'襤',0,'襦',0, 0,0,'襪',0,0,'襭',0,'襯', */
	/* 8970 */ 0,0,0x8f50,0,0xe645,0,0,0xe646, 0,0,0,0,0,0,0xe647,0x90bc, /* 0,0,'襲',0,'襴',0,0,'襷', 0,0,0,0,0,0,'襾','西', */
	/* 8980 */ 0xf9c3,0x9776,0,0xe648,0,0,0x95a2,0x9465, 0xe649,0xf9c4,0xe64a,0x8ca9,0,0,0,0x8b4b, /* '覀','要',0,'覃',0,0,'覆','覇', '覈','覉','覊','見',0,0,0,'規', */
	/* 8990 */ 0xf9c5,0,0,0xe64b,0xee98,0,0x8e8b,0x9460, 0xe64c,0,0x8a6f,0,0,0,0,0xf9c6, /* '覐',0,0,'覓','覔',0,'視','覗', '覘',0,'覚',0,0,0,0,'覟', */
	/* 89a0 */ 0,0xe64d,0,0,0,0,0xe64f,0x9797, 0,0xe64e,0x9065,0,0xe650,0,0,0xe651, /* 0,'覡',0,0,0,0,'覦','覧', 0,'覩','親',0,'覬',0,0,'覯', */
	/* 89b0 */ 0xf9c7,0,0xe652,0x8acf,0,0,0,0xf9c8, 0,0,0xe653,0,0,0xe654,0,0xe655, /* '覰',0,'覲','観',0,0,0,'覷', 0,0,'覺',0,0,'覽',0,'覿', */
	/* 89c0 */ 0xe656,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '觀',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 89d0 */ 0,0,0x8a70,0,0xee9a,0,0xf9c9,0, 0xf9ca,0,0xe657,0,0xe658,0xe659,0,0, /* 0,0,'角',0,'觔',0,'觖',0, '觘',0,'觚',0,'觜','觝',0,0, */
	/* 89e0 */ 0,0,0,0x89f0,0,0xee9b,0x9047,0xe65a, 0,0,0,0xf9cb,0,0,0,0, /* 0,0,0,'解',0,'觥','触','觧', 0,0,0,'觫',0,0,0,0, */
	/* 89f0 */ 0,0xf9cd,0,0xf9ce,0xe65b,0,0xee9c,0, 0xe65c,0,0,0,0,0xf9cf,0,0xf9d0, /* 0,'觱',0,'觳','觴',0,'觶',0, '觸',0,0,0,0,'觽',0,'觿', */
	/* 8a00 */ 0x8cbe,0,0x92f9,0xe65d,0,0,0,0, 0x8c76,0,0x9075,0,0xe660,0,0x93a2,0, /* '言',0,'訂','訃',0,0,0,0, '計',0,'訊',0,'訌',0,'討',0, */
	/* 8a10 */ 0xe65f,0xf9d2,0xee9d,0x8c50,0xf9d3,0xee9e,0xe65e,0x91f5, 0x8b4c,0,0,0xe661,0,0xe662,0,0x8fd7, /* '訐','訑','訒','訓','訔','訕','訖','託', '記',0,0,'訛',0,'訝',0,'訟', */
	/* 8a20 */ 0,0xf9d5,0xee9f,0x8c8d,0,0xe663,0,0, 0,0,0x964b,0,0,0x90dd,0,0, /* 0,'訡','訢','訣',0,'訥',0,0, 0,0,'訪',0,0,'設',0,0, */
	/* 8a30 */ 0,0x8b96,0,0x96f3,0x9169,0xf9d6,0xe664,0xeea0, 0,0,0x9066,0x9290,0x8fd8,0,0xf9d7,0, /* 0,'許',0,'訳','訴','訵','訶','訷', 0,0,'診','註','証',0,'訾',0, */
	/* 8a40 */ 0,0xe665,0,0,0,0xf9d8,0xe668,0xeea1, 0xe669,0,0,0,0,0xf9d9,0xeea2,0, /* 0,'詁',0,0,0,'詅','詆','詇', '詈',0,0,0,0,'詍','詎',0, */
	/* 8a50 */ 0x8dbc,0x91c0,0xe667,0,0x8fd9,0x955d,0,0, 0xf9da,0,0,0xe666,0,0xeea3,0x8e8c,0, /* '詐','詑','詒',0,'詔','評',0,0, '詘',0,0,'詛',0,'詝','詞',0, */
	/* 8a60 */ 0x8972,0xeea4,0xe66d,0x8c77,0,0,0x8e8e,0, 0,0x8e8d,0,0x986c,0xe66c,0xe66b,0x9146,0, /* '詠','詡','詢','詣',0,0,'試',0, 0,'詩',0,'詫','詬','詭','詮',0, */
	/* 8a70 */ 0x8b6c,0x9862,0x8a59,0x8fda,0,0xeea5,0,0, 0,0xeea6,0,0,0xe66a,0,0,0, /* '詰','話','該','詳',0,'詵',0,0, 0,'詹',0,0,'詼',0,0,0, */
	/* 8a80 */ 0,0,0xe66f,0,0xe670,0xe66e,0,0x8cd6, 0,0x975f,0,0,0x8e8f,0x9446,0,0, /* 0,0,'誂',0,'誄','誅',0,'誇', 0,'誉',0,0,'誌','認',0,0, */
	/* 8a90 */ 0xf9dc,0xe673,0,0x90be,0,0x9261,0,0, 0x9755,0,0xe676,0,0,0,0x8cea,0, /* '誐','誑',0,'誓',0,'誕',0,0, '誘',0,'誚',0,0,0,'語',0, */
	/* 8aa0 */ 0x90bd,0xe672,0,0xe677,0x8ceb,0xe674,0xe675,0xeea7, 0xe671,0,0,0,0x90e0,0x93c7,0xf9db,0, /* '誠','誡',0,'誣','誤','誥','誦','誧', '誨',0,0,0,'説','読','誮',0, */
	/* 8ab0 */ 0x924e,0,0x89db,0,0,0,0,0xf9dd, 0,0x94ee,0,0,0x8b62,0,0xf9de,0x92b2, /* '誰',0,'課',0,0,0,0,'誷', 0,'誹',0,0,'誼',0,'誾','調', */
	/* 8ac0 */ 0,0,0xe67a,0,0xe678,0,0,0x926b, 0,0,0,0x90bf,0x8ad0,0xe679,0,0x907a, /* 0,0,'諂',0,'諄',0,0,'談', 0,0,0,'請','諌','諍',0,'諏', */
	/* 8ad0 */ 0xeea8,0,0x97c8,0,0,0,0x985f,0xf9df, 0,0,0xe67b,0xe687,0x92b3,0,0xe686,0xeea9, /* '諐',0,'諒',0,0,0,'論','諗', 0,0,'諚','諛','諜',0,'諞','諟', */
	/* 8ae0 */ 0xe683,0xe68b,0xe684,0,0xe680,0,0x92fa,0xe67e, 0,0,0,0xe67c,0,0x9740,0x8e90,0, /* '諠','諡','諢',0,'諤',0,'諦','諧', 0,0,0,'諫',0,'諭','諮',0, */
	/* 8af0 */ 0,0xe681,0,0xe67d,0xeeaa,0,0xeeab,0xe685, 0x8f94,0,0x8cbf,0,0xf9e0,0,0x91f8,0, /* 0,'諱',0,'諳','諴',0,'諶','諷', '諸',0,'諺',0,'諼',0,'諾',0, */
	/* 8b00 */ 0x9664,0x8979,0x88e0,0,0x93a3,0xf9e3,0,0xe689, 0,0,0xf9e2,0,0xe688,0xf9e4,0x93e4,0, /* '謀','謁','謂',0,'謄','謅',0,'謇', 0,0,'謊',0,'謌','謍','謎',0, */
	/* 8b10 */ 0xe68d,0,0,0,0xe682,0,0xe68c,0xe68e, 0,0x8caa,0xe68a,0x8d75,0xf9e5,0x8ed3,0,0xf9e6, /* '謐',0,0,0,'謔',0,'謖','謗', 0,'謙','謚','講','謜','謝',0,'謟', */
	/* 8b20 */ 0xe68f,0x9777,0,0,0,0,0xe692,0, 0xe695,0,0,0xe693,0x9554,0xf9e7,0,0, /* '謠','謡',0,0,0,0,'謦',0, '謨',0,0,'謫','謬','謭',0,0, */
	/* 8b30 */ 0,0,0,0xe690,0,0,0,0, 0,0x8bde,0,0,0,0,0xe694,0, /* 0,0,0,'謳',0,0,0,0, 0,'謹',0,0,0,0,'謾',0, */
	/* 8b40 */ 0,0xe696,0,0xf9e8,0,0,0xeeaf,0, 0,0xe69a,0,0,0xe697,0,0xe699,0xe698, /* 0,'譁',0,'譃',0,0,'譆',0, 0,'證',0,0,'譌',0,'譎','譏', */
	/* 8b50 */ 0,0xf9ea,0,0,0xeeb0,0,0xe69b,0, 0x8eaf,0xeeb1,0xe69d,0xe69c,0x9588,0,0xf9eb,0xe69f, /* 0,'譑',0,0,'譔',0,'譖',0, '識','譙','譚','譛','譜',0,'譞','譟', */
	/* 8b60 */ 0,0,0,0,0,0,0x8c78,0, 0,0xeeb2,0,0xe69e,0xe6a0,0,0,0xe6a1, /* 0,0,0,0,0,0,'警',0, 0,'譩',0,'譫','譬',0,0,'譯', */
	/* 8b70 */ 0x8b63,0xe3bf,0x8ff7,0,0xe6a2,0,0xf9ec,0x8cec, 0,0,0,0,0,0xe6a3,0,0xf9ed, /* '議','譱','譲',0,'譴',0,'譶','護', 0,0,0,0,0,'譽',0,'譿', */
	/* 8b80 */ 0xe6a4,0xf9ee,0,0x8e5d,0,0,0,0, 0,0,0x9dcc,0xf9ef,0xe6a5,0,0xe6a6,0, /* '讀','讁',0,'讃',0,0,0,0, 0,0,'變','讋','讌',0,'讎',0, */
	/* 8b90 */ 0x8f51,0,0xe6a7,0xe6a8,0xf9f0,0xf9f1,0xe6a9,0, 0,0xe6aa,0xe6ab,0,0xf9f2,0xeeb3,0xf9f3,0, /* '讐',0,'讒','讓','讔','讕','讖',0, 0,'讙','讚',0,'讜','讝','讞',0, */
	/* 8ba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8be0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8bf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8c30 */ 0,0,0,0,0,0,0,0x924a, 0,0xf9f4,0xe6ac,0,0,0xf9f6,0,0xe6ae, /* 0,0,0,0,0,0,0,'谷', 0,'谹','谺',0,0,'谽',0,'谿', */
	/* 8c40 */ 0,0xe6ad,0,0,0,0xf9f9,0x93a4,0xf9fa, 0xe6af,0xeeb4,0x964c,0,0xe6b0,0,0xe6b1,0xf9fb, /* 0,'豁',0,0,0,'豅','豆','豇', '豈','豉','豊',0,'豌',0,'豎','豏', */
	/* 8c50 */ 0xe6b2,0,0,0,0xf9fc,0xe6b3,0,0xfa40, 0,0,0x93d8,0,0,0,0,0, /* '豐',0,0,0,'豔','豕',0,'豗', 0,0,'豚',0,0,0,0,0, */
	/* 8c60 */ 0,0x8fdb,0xe6b4,0,0,0,0,0, 0xeeb5,0xfa41,0x8d8b,0x98ac,0xe6b5,0xfa42,0,0, /* 0,'象','豢',0,0,0,0,0, '豨','豩','豪','豫','豬','豭',0,0, */
	/* 8c70 */ 0,0,0,0xfa43,0,0,0,0, 0xe6b6,0x955e,0xe6b7,0,0xe6bf,0,0,0, /* 0,0,0,'豳',0,0,0,0, '豸','豹','豺',0,'豼',0,0,0, */
	/* 8c80 */ 0,0,0xe6b8,0,0,0xe6ba,0,0, 0,0xe6b9,0xe6bb,0,0x9665,0xe6bc,0xe6bd,0, /* 0,0,'貂',0,0,'貅',0,0, 0,'貉','貊',0,'貌','貍','貎',0, */
	/* 8c90 */ 0,0,0xfa46,0xfa45,0xe6be,0,0,0, 0xe6c0,0xfa47,0,0xfa49,0,0x8a4c,0x92e5,0, /* 0,0,'貒','貓','貔',0,0,0, '貘','貙',0,'貛',0,'貝','貞',0, */
	/* 8ca0 */ 0x9589,0x8de0,0x8d76,0,0xfa4a,0,0,0x956e, 0x89dd,0x94cc,0xe6c3,0x8ad1,0x90d3,0xe6c2,0xe6c7,0x9299, /* '負','財','貢',0,'貤',0,0,'貧', '貨','販','貪','貫','責','貭','貮','貯', */
	/* 8cb0 */ 0x96e1,0,0xe6c5,0xe6c6,0x8b4d,0,0xe6c8,0x9483, 0x91dd,0,0,0x94ef,0x935c,0xe6c4,0,0x9666, /* '貰',0,'貲','貳','貴',0,'貶','買', '貸',0,0,'費','貼','貽',0,'貿', */
	/* 8cc0 */ 0x89ea,0xe6ca,0x9847,0x92c0,0x9864,0,0,0x8e91, 0xe6c9,0,0x91af,0,0,0xe6da,0x9147,0, /* '賀','賁','賂','賃','賄',0,0,'資', '賈',0,'賊',0,0,'賍','賎',0, */
	/* 8cd0 */ 0,0x93f6,0,0x956f,0,0xfa4c,0xfa4b,0, 0,0xfa4d,0xe6cd,0x8e5e,0x8e92,0,0x8fdc,0, /* 0,'賑',0,'賓',0,'賕','賖',0, 0,'賙','賚','賛','賜',0,'賞',0, */
	/* 8ce0 */ 0x9485,0xeeb7,0x8cab,0xe6cc,0xe6cb,0,0x958a,0, 0,0,0x8ebf,0,0,0x9371,0,0, /* '賠','賡','賢','賣','賤',0,'賦',0, 0,0,'質',0,0,'賭',0,0, */
	/* 8cf0 */ 0xfa4f,0xfa50,0,0,0xeeb8,0,0,0, 0xeeb9,0,0xe6cf,0xe6d0,0x8d77,0xe6ce,0xeeba,0, /* '賰','賱',0,0,'賴',0,0,0, '賸',0,'賺','賻','購','賽','賾',0, */
	/* 8d00 */ 0,0,0,0,0xe6d1,0xe6d2,0,0xe6d4, 0x91a1,0xfa52,0xe6d3,0x8ae4,0,0xe6d6,0xfa53,0xe6d5, /* 0,0,0,0,'贄','贅',0,'贇', '贈','贉','贊','贋',0,'贍','贎','贏', */
	/* 8d10 */ 0xe6d7,0,0xeebc,0xe6d9,0xe6db,0,0xe6dc,0, 0,0,0,0xeebd,0,0,0,0, /* '贐',0,'贒','贓','贔',0,'贖',0, 0,0,0,'贛',0,0,0,0, */
	/* 8d20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8d60 */ 0,0,0,0,0x90d4,0,0x8ecd,0xe6dd, 0,0,0,0x8a71,0xfa54,0xe6de,0,0, /* 0,0,0,0,'赤',0,'赦','赧', 0,0,0,'赫','赬','赭',0,0, */
	/* 8d70 */ 0x9196,0xe6df,0,0xe6e0,0x958b,0,0,0x8b4e, 0,0,0,0,0,0,0,0, /* '走','赱',0,'赳','赴',0,0,'起', 0,0,0,0,0,0,0,0, */
	/* 8d80 */ 0,0xe6e1,0,0,0xfa55,0x92b4,0,0, 0,0,0x897a,0,0,0,0,0, /* 0,'趁',0,0,'趄','超',0,0, 0,0,'越',0,0,0,0,0, */
	/* 8d90 */ 0,0,0,0,0,0xfa56,0,0, 0,0xe6e2,0,0,0,0,0,0, /* 0,0,0,0,0,'趕',0,0, 0,'趙',0,0,0,0,0,0, */
	/* 8da0 */ 0,0,0,0x8eef,0,0,0xfa57,0, 0x9096,0,0,0,0,0,0,0xeebe, /* 0,0,0,'趣',0,0,'趦',0, '趨',0,0,0,0,0,0,'趯', */
	/* 8db0 */ 0,0,0,0x91ab,0,0,0,0, 0,0,0xe6e5,0,0,0,0xe6e4,0, /* 0,0,0,'足',0,0,0,0, 0,0,'趺',0,0,0,'趾',0, */
	/* 8dc0 */ 0,0,0xe6e3,0,0,0,0xfa59,0, 0xfa5a,0,0,0xe6eb,0xe6e9,0,0xeebf,0xe6e6, /* 0,0,'跂',0,0,0,'跆',0, '跈',0,0,'跋','跌',0,'跎','跏', */
	/* 8dd0 */ 0,0xeec0,0,0,0,0,0xe6e8,0xeec1, 0,0xfa5b,0xe6e7,0xe6ea,0,0x8b97,0,0xe6ee, /* 0,'跑',0,0,0,0,'跖','跗', 0,'跙','跚','跛',0,'距',0,'跟', */
	/* 8de0 */ 0,0x90d5,0,0xe6ef,0,0,0,0, 0x8cd7,0,0xe6ec,0xe6ed,0xfa5c,0,0,0x9848, /* 0,'跡',0,'跣',0,0,0,0, '跨',0,'跪','跫','跬',0,0,'路', */
	/* 8df0 */ 0,0,0,0x92b5,0,0x9148,0,0, 0,0,0,0,0xe6f0,0xfa5f,0,0xe6f3, /* 0,0,0,'跳',0,'践',0,0, 0,0,0,0,'跼','跽',0,'跿', */
	/* 8e00 */ 0,0,0,0,0,0,0xfa60,0, 0xe6f1,0xe6f2,0x9778,0,0xfa5d,0,0,0x93a5, /* 0,0,0,0,0,0,'踆',0, '踈','踉','踊',0,'踌',0,0,'踏', */
	/* 8e10 */ 0xe6f6,0,0,0,0xfa62,0,0xfa63,0, 0,0,0,0,0,0xe6f4,0xe6f5,0xe6f7, /* '踐',0,0,0,'踔',0,'踖',0, 0,0,0,0,0,'踝','踞','踟', */
	/* 8e20 */ 0xeec2,0xfa64,0xfa65,0xeec3,0,0,0,0xfa66, 0,0,0xe748,0,0,0,0,0, /* '踠','踡','踢','踣',0,0,0,'踧', 0,0,'踪',0,0,0,0,0, */
	/* 8e30 */ 0xe6fa,0,0,0,0xe6fb,0xe6f9,0xfa69,0, 0,0xfa6a,0,0,0,0xeec4,0,0, /* '踰',0,0,0,'踴','踵','踶',0, 0,'踹',0,0,0,'踽',0,0, */
	/* 8e40 */ 0,0,0xe6f8,0,0x92fb,0,0,0xe740, 0xe744,0xe741,0xe6fc,0xfa6b,0xe742,0,0,0, /* 0,0,'蹂',0,'蹄',0,0,'蹇', '蹈','蹉','蹊','蹋','蹌',0,0,0, */
	/* 8e50 */ 0xe743,0,0,0,0xfa6c,0xe74a,0,0, 0,0xe745,0,0,0,0,0,0x90d6, /* '蹐',0,0,0,'蹔','蹕',0,0, 0,'蹙',0,0,0,0,0,'蹟', */
	/* 8e60 */ 0xe747,0,0xfa6d,0xe749,0xe746,0,0,0, 0,0,0,0,0xfa6e,0xfa6f,0,0xfa70, /* '蹠',0,'蹢','蹣','蹤',0,0,0, 0,0,0,0,'蹬','蹭',0,'蹯', */
	/* 8e70 */ 0xeec5,0,0xe74c,0,0x8f52,0,0xe74b,0, 0,0,0,0xeec6,0xe74d,0,0,0, /* '蹰',0,'蹲',0,'蹴',0,'蹶',0, 0,0,0,'蹻','蹼',0,0,0, */
	/* 8e80 */ 0,0xe74e,0,0,0xe751,0xe750,0,0xe74f, 0,0,0xe753,0xe752,0,0x96f4,0,0, /* 0,'躁',0,0,'躄','躅',0,'躇', 0,0,'躊','躋',0,'躍',0,0, */
	/* 8e90 */ 0,0xe755,0,0xe754,0xe756,0,0,0, 0xfa71,0xe757,0,0,0,0,0xfa72,0, /* 0,'躑',0,'躓','躔',0,0,0, '躘','躙',0,0,0,0,'躞',0, */
	/* 8ea0 */ 0,0xe759,0,0,0,0,0,0, 0,0,0xe758,0x9067,0xe75a,0,0xfa73,0x8beb, /* 0,'躡',0,0,0,0,0,0, 0,0,'躪','身','躬',0,'躮','躯', */
	/* 8eb0 */ 0xe75b,0xe75d,0,0xfa74,0,0xfa75,0xfa76,0, 0,0,0,0xfa77,0,0,0xe75e,0, /* '躰','躱',0,'躳',0,'躵','躶',0, 0,0,0,'躻',0,0,'躾',0, */
	/* 8ec0 */ 0xeec8,0,0,0,0,0xe75f,0xe75c,0, 0xe760,0,0x8ed4,0xe761,0x8b4f,0x8c52,0,0, /* '軀',0,0,0,0,'軅','軆',0, '軈',0,'車','軋','軌','軍',0,0, */
	/* 8ed0 */ 0,0xfa79,0x8cac,0,0xfa7a,0,0,0, 0,0,0,0xe762,0,0,0,0x93ee, /* 0,'軑','軒',0,'軔',0,0,0, 0,0,0,'軛',0,0,0,'軟', */
	/* 8ee0 */ 0,0,0x935d,0xe763,0,0,0,0, 0,0,0,0xe766,0,0,0,0, /* 0,0,'転','軣',0,0,0,0, 0,0,0,'軫',0,0,0,0, */
	/* 8ef0 */ 0,0,0,0,0,0,0,0, 0x8eb2,0xfa7c,0xeeca,0xe765,0xe764,0x8c79,0xe767,0, /* 0,0,0,0,0,0,0,0, '軸','軹','軺','軻','軼','軽','軾',0, */
	/* 8f00 */ 0xfa7e,0,0,0x8a72,0,0xe769,0,0, 0xfa80,0x8dda,0xe768,0,0xe771,0,0,0, /* '輀',0,0,'較',0,'輅',0,0, '輈','載','輊',0,'輌',0,0,0, */
	/* 8f10 */ 0,0,0xe76b,0xe76d,0x95e3,0xe76a,0,0xfa81, 0,0xe76c,0,0xe770,0xe76e,0x8b50,0xeecb,0xe76f, /* 0,0,'輒','輓','輔','輕',0,'輗', 0,'輙',0,'輛','輜','輝','輞','輟', */
	/* 8f20 */ 0,0,0,0,0,0,0xe772,0, 0,0x9479,0x97d6,0xfa82,0,0xeecc,0,0x8f53, /* 0,0,0,0,0,0,'輦',0, 0,'輩','輪','輫',0,'輭',0,'輯', */
	/* 8f30 */ 0,0,0,0xe773,0,0,0xeecd,0, 0x9741,0xe775,0,0xe774,0,0,0xe778,0x9760, /* 0,0,0,'輳',0,0,'輶',0, '輸','輹',0,'輻',0,0,'輾','輿', */
	/* 8f40 */ 0xfa83,0,0xe777,0,0x8a8d,0xe776,0xe77b,0, 0,0xe77a,0xfa84,0,0xe779,0x9351,0xe77c,0, /* '轀',0,'轂',0,'轄','轅','轆',0, 0,'轉','轊',0,'轌','轍','轎',0, */
	/* 8f50 */ 0,0,0,0,0xeece,0,0,0xe77d, 0xfa85,0,0,0,0xe77e,0,0,0x8d8c, /* 0,0,0,0,'轔',0,0,'轗', '轘',0,0,0,'轜',0,0,'轟', */
	/* 8f60 */ 0,0x8c44,0xe780,0xe781,0xe782,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'轡','轢','轣','轤',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 8f70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 8f90 */ 0,0,0,0,0,0,0,0, 0,0,0,0x9068,0xe783,0,0x8eab,0xe784, /* 0,0,0,0,0,0,0,0, 0,0,0,'辛','辜',0,'辞','辟', */
	/* 8fa0 */ 0,0,0,0xe785,0xfa87,0,0xeed0,0x999f, 0x999e,0,0,0,0,0xe786,0xe390,0xe787, /* 0,0,0,'辣','辤',0,'辦','辧', '辨',0,0,0,0,'辭','辮','辯', */
	/* 8fb0 */ 0x9243,0x904a,0x945f,0,0xfa88,0xeed1,0xfa8a,0xe788, 0,0,0x95d3,0x92d2,0x8d9e,0,0,0x9248, /* '辰','辱','農',0,'辴','辵','辶','辷', 0,0,'辺','辻','込',0,0,'辿', */
	/* 8fc0 */ 0,0xfa8c,0x8949,0,0x9698,0x9076,0xfa8d,0, 0,0,0xfa8f,0,0,0xfa90,0x8c7d,0, /* 0,'迁','迂',0,'迄','迅','迆',0, 0,0,'迊',0,0,'迍','迎',0, */
	/* 8fd0 */ 0,0x8bdf,0,0xfa91,0x95d4,0xfa92,0,0, 0,0,0xe789,0,0,0,0,0, /* 0,'近',0,'迓','返','迕',0,0, 0,0,'迚',0,0,0,0,0, */
	/* 8fe0 */ 0xfa93,0,0xe78b,0,0xeed2,0xe78a,0x89de,0, 0xeed3,0x93f4,0xe78c,0x9497,0,0x9352,0xeed4,0xe78d, /* '迠',0,'迢',0,'迤','迥','迦',0, '迨','迩','迪','迫',0,'迭','迮','迯', */
	/* 8ff0 */ 0x8f71,0xfa94,0,0,0xe78f,0xfa95,0,0x96c0, 0xe79e,0xe791,0xe792,0xfa96,0,0x92c7,0,0, /* '述','迱',0,0,'迴','迵',0,'迷', '迸','迹','迺','迻',0,'追',0,0, */
	/* 9000 */ 0x91de,0x9197,0xfa97,0x93a6,0,0xe790,0x8b74,0, 0xeed5,0,0,0xe799,0xfa98,0xe796,0xe7a3,0x93a7, /* '退','送','适','逃',0,'逅','逆',0, '逈',0,0,'逋','逌','逍','逎','透', */
	/* 9010 */ 0x9280,0xe793,0,0x92fc,0x9372,0xe794,0xe798,0x9080, 0,0x9487,0x92ca,0,0,0x90c0,0xe797,0x91ac, /* '逐','逑',0,'逓','途','逕','逖','逗', 0,'這','通',0,0,'逝','逞','速', */
	/* 9020 */ 0x91a2,0xe795,0x88a7,0x9841,0,0,0,0xe79a, 0,0,0,0,0,0xeed6,0x91df,0, /* '造','逡','逢','連',0,0,0,'逧', 0,0,0,0,0,'逭','逮',0, */
	/* 9030 */ 0,0x8f54,0x9069,0,0,0xe79c,0xe79b,0xfa99, 0x88ed,0xe79d,0,0,0x954e,0,0xe7a5,0, /* 0,'週','進',0,0,'逵','逶','逷', '逸','逹',0,0,'逼',0,'逾',0, */
	/* 9040 */ 0,0x93d9,0x908b,0xfa9b,0xfa9c,0x9278,0,0x8bf6, 0,0xe7a4,0x9756,0x895e,0,0x95d5,0x89df,0xe79f, /* 0,'遁','遂','遃','遄','遅',0,'遇', 0,'遉','遊','運',0,'遍','過','遏', */
	/* 9050 */ 0xe7a0,0xe7a1,0xe7a2,0x93b9,0x9242,0x88e1,0xe7a6,0, 0xe7a7,0xeaa1,0,0,0x91bb,0xfa9d,0xe7a8,0, /* '遐','遑','遒','道','達','違','遖',0, '遘','遙',0,0,'遜','遝','遞',0, */
	/* 9060 */ 0x8993,0x916b,0,0x8cad,0,0x9779,0,0, 0xe7a9,0x934b,0,0,0,0x9198,0x8ed5,0xe7aa, /* '遠','遡',0,'遣',0,'遥',0,0, '遨','適',0,0,0,'遭','遮','遯', */
	/* 9070 */ 0,0,0xe7ad,0,0,0x8f85,0xe7ab,0x914a, 0x9149,0,0x88e2,0,0x97c9,0xe7af,0,0x94f0, /* 0,0,'遲',0,0,'遵','遶','遷', '選',0,'遺',0,'遼','遽',0,'避', */
	/* 9080 */ 0xe7b1,0xe7b0,0xe7ae,0xe284,0x8ad2,0xfaa0,0,0xe78e, 0xeed8,0xe7b3,0xe7b2,0,0xfaa1,0,0,0xe7b4, /* '邀','邁','邂','邃','還','邅',0,'邇', '邈','邉','邊',0,'邌',0,0,'邏', */
	/* 9090 */ 0xfaa2,0x9757,0,0,0,0xeed9,0,0xeeda, 0,0xeedb,0,0xeedc,0,0,0,0, /* '邐','邑',0,0,0,'邕',0,'邗', 0,'邙',0,'邛',0,0,0,0, */
	/* 90a0 */ 0,0xfaa4,0xeedd,0x93df,0,0,0x964d,0, 0xe7b5,0,0x8ed7,0,0,0,0,0xe7b6, /* 0,'邡','邢','那',0,0,'邦',0, '邨',0,'邪',0,0,0,0,'邯', */
	/* 90b0 */ 0xfaa6,0xe7b7,0,0xeede,0,0xe7b8,0xfaa7,0, 0x9340,0,0,0,0,0,0xeedf,0, /* '邰','邱',0,'邳',0,'邵','邶',0, '邸',0,0,0,0,0,'邾',0, */
	/* 90c0 */ 0,0x88e8,0,0xfaa8,0xeee0,0xeee1,0,0xeee2, 0xfaa9,0,0x8d78,0,0,0,0x9859,0, /* 0,'郁',0,'郃','郄','郅',0,'郇', '郈',0,'郊',0,0,0,'郎',0, */
	/* 90d0 */ 0,0,0,0,0,0,0,0xeee3, 0,0,0,0xe7bc,0xfaab,0xeee4,0xeee5,0xfaac, /* 0,0,0,0,0,0,0,'郗', 0,0,0,'郛','郜','郝','郞','郟', */
	/* 90e0 */ 0,0x8c53,0xe7b9,0,0xe7ba,0,0,0, 0x9594,0,0,0xfab1,0,0x8a73,0,0xeee6, /* 0,'郡','郢',0,'郤',0,0,0, '部',0,0,'郫',0,'郭',0,'郯', */
	/* 90f0 */ 0,0,0xfaaf,0,0xeee7,0x9758,0xfaae,0x8bbd, 0,0,0,0,0,0x9373,0xfab2,0xfab3, /* 0,0,'郲',0,'郴','郵','郶','郷', 0,0,0,0,0,'都','郾','郿', */
	/* 9100 */ 0xfab0,0,0xe7bd,0,0xfab4,0,0xfab5,0, 0,0,0,0,0,0,0,0, /* '鄀',0,'鄂',0,'鄄',0,'鄆',0, 0,0,0,0,0,0,0,0, */
	/* 9110 */ 0,0,0xe7be,0,0xeee9,0xeeea,0xeeeb,0, 0xfab6,0xe7bf,0,0,0xfab7,0,0xfab8,0, /* 0,0,'鄒',0,'鄔','鄕','鄖',0, '鄘','鄙',0,0,'鄜',0,'鄞',0, */
	/* 9120 */ 0,0,0xeeec,0xeeed,0,0,0,0xeeee, 0,0,0,0,0,0x9341,0,0xeeef, /* 0,0,'鄢','鄣',0,0,0,'鄧', 0,0,0,0,0,'鄭',0,'鄯', */
	/* 9130 */ 0xe7c1,0xeef0,0xe7c0,0,0xeef1,0,0,0xfab9, 0,0xfaba,0xfabb,0,0,0xeef2,0,0, /* '鄰','鄱','鄲',0,'鄴',0,0,'鄷', 0,'鄹','鄺',0,0,'鄽',0,0, */
	/* 9140 */ 0,0,0,0,0,0,0xfabc,0xfabd, 0xeef3,0x93d1,0xe7c2,0x8f55,0x8ede,0x947a,0x9291,0, /* 0,0,0,0,0,0,'酆','酇', '酈','酉','酊','酋','酌','配','酎',0, */
	/* 9150 */ 0,0,0x8ef0,0,0x908c,0,0xe7c3,0xfabe, 0xe7c4,0xfabf,0,0xeef4,0,0,0,0, /* 0,0,'酒',0,'酔',0,'酖','酗', '酘','酙',0,'酛',0,0,0,0, */
	/* 9160 */ 0,0xfac0,0x907c,0xe7c5,0xfac1,0xe7c6,0,0, 0,0xe7c7,0x978f,0,0x8f56,0,0,0, /* 0,'酡','酢','酣','酤','酥',0,0, 0,'酩','酪',0,'酬',0,0,0, */
	/* 9170 */ 0,0,0xe7c9,0xe7c8,0xfac2,0x8d79,0,0x8d93, 0x8e5f,0xfac3,0,0,0,0,0,0, /* 0,0,'酲','酳','酴','酵',0,'酷', '酸','酹',0,0,0,0,0,0, */
	/* 9180 */ 0,0,0xe7cc,0xeef5,0,0xfac4,0,0x8f86, 0,0xe7cb,0,0xe7ca,0,0x91e7,0xfac5,0, /* 0,0,'醂','醃',0,'醅',0,'醇', 0,'醉',0,'醋',0,'醍','醎',0, */
	/* 9190 */ 0x8ced,0,0x90c1,0,0,0,0,0x94ae, 0,0,0,0,0x8f58,0,0xeef6,0, /* '醐',0,'醒',0,0,0,0,'醗', 0,0,0,0,'醜',0,'醞',0, */
	/* 91a0 */ 0,0,0xe7cd,0,0x8fdd,0,0,0, 0xfac6,0,0xe7d0,0xe7ce,0xeef7,0,0xfac7,0xe7cf, /* 0,0,'醢',0,'醤',0,0,0, '醨',0,'醪','醫','醬',0,'醮','醯', */
	/* 91b0 */ 0,0xeef8,0,0xfac8,0xe7d2,0xe7d1,0xfac9,0, 0x8ff8,0,0xe7d3,0,0xeef9,0,0,0, /* 0,'醱',0,'醳','醴','醵','醶',0, '醸',0,'醺',0,'醼',0,0,0, */
	/* 91c0 */ 0xe7d4,0xe7d5,0,0xfaca,0xfacb,0,0x94ce,0x8dd1, 0x8edf,0xe7d6,0,0xe7d7,0x97a2,0x8f64,0x96ec,0x97ca, /* '釀','釁',0,'釃','釄',0,'釆','采', '釈','釉',0,'釋','里','重','野','量', */
	/* 91d0 */ 0xe7d8,0x8be0,0,0,0,0,0xe7d9,0xeefa, 0x9342,0,0xfacc,0xe7dc,0x8a98,0x906a,0,0xe7da, /* '釐','金',0,0,0,0,'釖','釗', '釘',0,'釚','釛','釜','針',0,'釟', */
	/* 91e0 */ 0,0xe7db,0,0x92de,0xeefc,0xef40,0x9674,0x8bfa, 0,0,0,0,0xfacf,0xef41,0xfad0,0, /* 0,'釡',0,'釣','釤','釥','釦','釧', 0,0,0,0,'釬','釭','釮',0, */
	/* 91f0 */ 0,0xef42,0,0,0,0xe7de,0xe7df,0, 0,0,0,0xeefb,0xe7dd,0,0,0xe7e1, /* 0,'釱',0,0,0,'釵','釶',0, 0,0,0,'釻','釼',0,0,'釿', */
	/* 9200 */ 0,0xfad1,0,0,0,0,0,0xef43, 0,0,0xfad2,0,0,0x93dd,0x8a62,0, /* 0,'鈁',0,0,0,0,0,'鈇', 0,0,'鈊',0,0,'鈍','鈎',0, */
	/* 9210 */ 0xef44,0xe7e5,0,0,0xe7e2,0xe7e4,0xfad3,0xfad4, 0,0,0,0,0,0,0xe7e0,0, /* '鈐','鈑',0,0,'鈔','鈕','鈖','鈗', 0,0,0,0,0,0,'鈞',0, */
	/* 9220 */ 0,0,0,0,0,0,0,0, 0,0xe86e,0,0,0xe7e3,0,0,0, /* 0,0,0,0,0,0,0,0, 0,'鈩',0,0,'鈬',0,0,0, */
	/* 9230 */ 0,0,0,0xfad6,0x97e9,0,0,0x8cd8, 0xef45,0xef46,0xef47,0,0xef48,0,0,0xe7ed, /* 0,0,0,'鈳','鈴',0,0,'鈷', '鈸','鈹','鈺',0,'鈼',0,0,'鈿', */
	/* 9240 */ 0xef49,0,0xfad7,0xef4a,0x9353,0xe7e8,0,0xfad8, 0xe7eb,0xe7e9,0xfad9,0xe7ee,0,0,0xfada,0xef4b, /* '鉀',0,'鉂','鉃','鉄','鉅',0,'鉇', '鉈','鉉','鉊','鉋',0,0,'鉎','鉏', */
	/* 9250 */ 0xe7ef,0xfadb,0,0,0,0,0xfadc,0xe7e7, 0,0xfadd,0xe7f4,0x8994,0,0,0xe7e6,0, /* '鉐','鉑',0,0,0,0,'鉖','鉗', 0,'鉙','鉚','鉛',0,0,'鉞',0, */
	/* 9260 */ 0xfade,0xfadf,0x94ab,0,0xe7ea,0xfae0,0x8fde,0xfae1, 0xfae2,0,0,0,0,0,0,0, /* '鉠','鉡','鉢',0,'鉤','鉥','鉦','鉧', '鉨',0,0,0,0,0,0,0, */
	/* 9270 */ 0,0x8d7a,0,0,0,0,0,0, 0xef4c,0,0,0,0xfae5,0xfae6,0x9667,0xfae7, /* 0,'鉱',0,0,0,0,0,0, '鉸',0,0,0,'鉼','鉽','鉾','鉿', */
	/* 9280 */ 0x8be2,0,0,0x8f65,0,0x93ba,0,0, 0xef4d,0xfae8,0,0,0,0xfae9,0,0, /* '銀',0,0,'銃',0,'銅',0,0, '銈','銉',0,0,0,'銍',0,0, */
	/* 9290 */ 0,0x914c,0,0xe7f2,0,0xe7ec,0xe7f1,0xfaea, 0x96c1,0xfaeb,0x92b6,0xe7f3,0xe7f0,0,0,0xfaec, /* 0,'銑',0,'銓',0,'銕','銖','銗', '銘','銙','銚','銛','銜',0,0,'銟', */
	/* 92a0 */ 0,0,0,0,0,0,0,0xfaed, 0,0,0,0xfaee,0,0x914b,0,0, /* 0,0,0,0,0,0,0,'銧', 0,0,0,'銫',0,'銭',0,0, */
	/* 92b0 */ 0,0,0xfaf1,0,0,0,0,0xe7f7, 0,0xe7f6,0,0,0,0,0,0xfaf2, /* 0,0,'銲',0,0,0,0,'銷', 0,'銹',0,0,0,0,0,'銿', */
	/* 92c0 */ 0xfaf3,0,0xef4e,0,0,0,0xfaf4,0, 0,0,0,0xef4f,0xef50,0,0xfaf5,0xe7f5, /* '鋀',0,'鋂',0,0,0,'鋆',0, 0,0,0,'鋋','鋌',0,'鋎','鋏', */
	/* 92d0 */ 0xfaf6,0,0x964e,0xef51,0,0,0,0xfaf7, 0,0xfaf8,0,0,0,0,0,0, /* '鋐',0,'鋒','鋓',0,0,0,'鋗', 0,'鋙',0,0,0,0,0,0, */
	/* 92e0 */ 0xef52,0,0,0,0x8f9b,0xfaf9,0,0xfafa, 0,0xe7f8,0x95dd,0,0,0x8973,0,0, /* '鋠',0,0,0,'鋤','鋥',0,'鋧', 0,'鋩','鋪',0,0,'鋭',0,0, */
	/* 92f0 */ 0,0,0x9565,0x9292,0,0,0,0xfb41, 0x8b98,0xfb42,0xe7fa,0xfb43,0x8d7c,0,0,0xef53, /* 0,0,'鋲','鋳',0,0,0,'鋷', '鋸','鋹','鋺','鋻','鋼',0,0,'鋿', */
	/* 9300 */ 0,0,0xfb44,0,0xef54,0,0x8e4b,0, 0,0,0,0,0,0xfb45,0,0xe7f9, /* 0,0,'錂',0,'錄',0,'錆',0, 0,0,0,0,0,'錍',0,'錏', */
	/* 9310 */ 0x908d,0xfafb,0,0,0,0xfb46,0,0, 0x908e,0xe840,0xe842,0,0,0xfb47,0xfb48,0xef55, /* '錐','錑',0,0,0,'錕',0,0, '錘','錙','錚',0,0,'錝','錞','錟', */
	/* 9320 */ 0x8ff9,0xef56,0xe841,0xe843,0,0xef57,0x8bd1,0xfb49, 0x9564,0xfb4a,0,0x8ee0,0x9842,0,0xe7fc,0x8df6, /* '錠','錡','錢','錣',0,'錥','錦','錧', '錨','錩',0,'錫','錬',0,'錮','錯', */
	/* 9330 */ 0,0,0x985e,0,0,0xe845,0,0, 0,0,0xe844,0xe846,0,0,0,0, /* 0,0,'録',0,0,'錵',0,0, 0,0,'錺','錻',0,0,0,0, */
	/* 9340 */ 0,0,0,0,0xe7fb,0,0,0xfb4d, 0xef58,0xef59,0xef5a,0x93e7,0,0x9374,0,0, /* 0,0,0,0,'鍄',0,0,'鍇', '鍈','鍉','鍊','鍋',0,'鍍',0,0, */
	/* 9350 */ 0,0xfb4e,0,0,0x92d5,0,0xe84b,0xfb4f, 0,0,0xfb50,0x9262,0xe847,0,0,0, /* 0,'鍑',0,0,'鍔',0,'鍖','鍗', 0,0,'鍚','鍛','鍜',0,0,0, */
	/* 9360 */ 0xe848,0,0,0,0xef5b,0xef5c,0,0, 0,0,0xef5d,0xfb51,0x8c4c,0,0xe84a,0, /* '鍠',0,0,0,'鍤','鍥',0,0, 0,0,'鍪','鍫','鍬',0,'鍮',0, */
	/* 9370 */ 0xef5e,0xfb52,0,0xfb53,0,0x8cae,0,0, 0,0,0,0,0xe849,0,0x8fdf,0, /* '鍰','鍱',0,'鍳',0,'鍵',0,0, 0,0,0,0,'鍼',0,'鍾',0, */
	/* 9380 */ 0,0,0,0,0,0,0,0, 0xfb57,0,0,0xfb58,0x8a99,0,0,0xfb59, /* 0,0,0,0,0,0,0,0, '鎈',0,0,'鎋','鎌',0,0,'鎏', */
	/* 9390 */ 0,0,0,0,0xe84f,0,0x8dbd,0x9199, 0,0,0x92c8,0xef5f,0,0,0xfb5a,0, /* 0,0,0,0,'鎔',0,'鎖','鎗', 0,0,'鎚','鎛',0,0,'鎞',0, */
	/* 93a0 */ 0,0xfb54,0,0xef60,0,0,0,0x8a5a, 0,0,0,0,0xe84d,0xe84e,0x92c1,0, /* 0,'鎡',0,'鎣',0,0,0,'鎧', 0,0,0,0,'鎬','鎭','鎮',0, */
	/* 93b0 */ 0xe84c,0,0,0,0,0,0,0, 0,0xe850,0xef61,0,0,0,0,0, /* '鎰',0,0,0,0,0,0,0, 0,'鎹','鎺',0,0,0,0,0, */
	/* 93c0 */ 0,0xfb5f,0,0xe856,0,0,0xef62,0xfb60, 0xe859,0,0,0,0,0,0,0, /* 0,'鏁',0,'鏃',0,0,'鏆','鏇', '鏈',0,0,0,0,0,0,0, */
	/* 93d0 */ 0xe858,0x934c,0,0,0,0,0xe851,0xe852, 0xe855,0,0,0,0xfb61,0xe857,0xef63,0xef64, /* '鏐','鏑',0,0,0,0,'鏖','鏗', '鏘',0,0,0,'鏜','鏝','鏞','鏟', */
	/* 93e0 */ 0,0x8bbe,0xfb62,0,0xe85a,0xe854,0,0xfb63, 0xe853,0,0,0,0,0,0,0, /* 0,'鏡','鏢',0,'鏤','鏥',0,'鏧', '鏨',0,0,0,0,0,0,0, */
	/* 93f0 */ 0,0xfb5e,0,0,0,0xfb5b,0,0, 0,0,0,0xfb68,0,0xef66,0,0, /* 0,'鏱',0,0,0,'鏵',0,0, 0,0,0,'鏻',0,'鏽',0,0, */
	/* 9400 */ 0,0,0,0xe85e,0xef65,0,0,0xe85f, 0,0xfb64,0,0,0,0,0,0xfb65, /* 0,0,0,'鐃','鐄',0,0,'鐇', 0,'鐉',0,0,0,0,0,'鐏', */
	/* 9410 */ 0xe860,0,0,0xe85d,0xe85c,0,0xfb66,0xfb67, 0x8fe0,0x93a8,0xe85b,0,0,0,0,0, /* '鐐',0,0,'鐓','鐔',0,'鐖','鐗', '鐘','鐙','鐚',0,0,0,0,0, */
	/* 9420 */ 0,0xe864,0,0,0,0,0,0, 0,0,0,0xe862,0,0,0,0, /* 0,'鐡',0,0,0,0,0,0, 0,0,0,'鐫',0,0,0,0, */
	/* 9430 */ 0,0,0xfb69,0xef67,0xfb6a,0xe863,0xe861,0, 0x91f6,0,0xe865,0xfb6b,0,0,0,0, /* 0,0,'鐲','鐳','鐴','鐵','鐶',0, '鐸',0,'鐺','鐻',0,0,0,0, */
	/* 9440 */ 0,0xe866,0,0,0xe868,0xfb6c,0,0, 0,0,0xef68,0,0,0,0,0, /* 0,'鑁',0,0,'鑄','鑅',0,0, 0,0,'鑊',0,0,0,0,0, */
	/* 9450 */ 0,0x8ad3,0xe867,0x96f8,0,0,0,0, 0,0,0xe873,0xe869,0,0,0xe86c,0, /* 0,'鑑','鑒','鑓',0,0,0,0, 0,0,'鑚','鑛',0,0,'鑞',0, */
	/* 9460 */ 0xe86a,0,0xe86b,0xef69,0,0,0,0, 0,0,0xe86d,0xef6a,0,0xfb6f,0,0xfb70, /* '鑠',0,'鑢','鑣',0,0,0,0, 0,0,'鑪','鑫',0,'鑭',0,'鑯', */
	/* 9470 */ 0xe86f,0xef6b,0xef6c,0,0,0xe870,0,0xe871, 0,0,0,0,0xe874,0xe872,0xe875,0xe877, /* '鑰','鑱','鑲',0,0,'鑵',0,'鑷', 0,0,0,0,'鑼','鑽','鑾','鑿', */
	/* 9480 */ 0,0xe876,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* 0,'钁',0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 94f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9570 */ 0,0,0,0,0,0,0,0x92b7, 0xfb71,0xfb72,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,'長', '镸','镹',0,0,0,0,0,0, */
	/* 9580 */ 0x96e5,0,0xe878,0x914d,0,0,0xfb73,0xe879, 0,0x95c2,0xe87a,0x8a4a,0xfb74,0xfb75,0xef6d,0x895b, /* '門',0,'閂','閃',0,0,'閆','閇', 0,'閉','閊','開','閌','閍','閎','閏', */
	/* 9590 */ 0,0x8ad5,0,0x8ad4,0xe87b,0,0xe87c,0, 0xe87d,0xe87e,0,0,0,0,0,0xef6e, /* 0,'閑',0,'間','閔',0,'閖',0, '閘','閙',0,0,0,0,0,'閟', */
	/* 95a0 */ 0xe880,0,0x8ad6,0x8a74,0x8d7d,0x94b4,0xef6f,0xe882, 0xe881,0xef70,0,0xfb77,0xef71,0xe883,0,0, /* '閠',0,'関','閣','閤','閥','閦','閧', '閨','閩',0,'閫','閬','閭',0,0, */
	/* 95b0 */ 0,0,0x897b,0,0xfb78,0,0xef72,0, 0,0xe886,0,0xe885,0xe884,0xef73,0xe887,0, /* 0,0,'閲',0,'閴',0,'閶',0, 0,'閹',0,'閻','閼','閽','閾',0, */
	/* 95c0 */ 0,0,0,0xe88a,0,0,0,0x88c5, 0xfb7a,0,0xe888,0xef74,0xe88c,0xe88b,0,0, /* 0,0,0,'闃',0,0,0,'闇', '闈',0,'闊','闋','闌','闍',0,0, */
	/* 95d0 */ 0xef75,0,0,0xef76,0xe88e,0xe88d,0xe88f,0, 0x93ac,0,0xef78,0,0xe890,0,0xef79,0, /* '闐',0,0,'闓','闔','闕','闖',0, '闘',0,'闚',0,'關',0,'闞',0, */
	/* 95e0 */ 0,0xe891,0xe893,0,0,0xe892,0,0, 0,0,0,0,0,0,0,0, /* 0,'闡','闢',0,0,'闥',0,0, 0,0,0,0,0,0,0,0, */
	/* 95f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0x958c,0xfaa3,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,'阜','阝',0,0, */
	/* 9620 */ 0,0xe894,0,0,0,0,0,0, 0xe895,0,0x8de3,0,0xfb7d,0,0xe896,0xe897, /* 0,'阡',0,0,0,0,0,0, '阨',0,'阪',0,'阬',0,'阮','阯', */
	/* 9630 */ 0,0,0x9668,0xfb7e,0xfb80,0,0,0, 0,0,0,0x916a,0xfb82,0,0,0x88a2, /* 0,0,'防','阳','阴',0,0,0, 0,0,0,'阻','阼',0,0,'阿', */
	/* 9640 */ 0x91c9,0xfb83,0xe898,0,0x958d,0,0,0, 0,0,0,0xe89b,0xe899,0x8d7e,0,0xe89a, /* '陀','陁','陂',0,'附',0,0,0, 0,0,0,'陋','陌','降',0,'陏', */
	/* 9650 */ 0x8cc0,0,0,0,0,0,0,0, 0xef7a,0,0,0x95c3,0xe89d,0xe89f,0xe89e,0xe8a0, /* '限',0,0,0,0,0,0,0, '陘',0,0,'陛','陜','陝','陞','陟', */
	/* 9660 */ 0,0xfb84,0x8940,0x9077,0x8f9c,0x8ad7,0xe8a1,0, 0,0,0x9486,0,0xe8a3,0,0,0, /* 0,'陡','院','陣','除','陥','陦',0, 0,0,'陪',0,'陬',0,0,0, */
	/* 9670 */ 0x8941,0,0xe8a2,0x92c2,0,0x97cb,0x93a9,0xe89c, 0x97a4,0,0x8caf,0,0,0x977a,0,0, /* '陰',0,'陲','陳',0,'陵','陶','陷', '陸',0,'険',0,0,'陽',0,0, */
	/* 9680 */ 0,0,0xfb86,0,0xef7b,0x8bf7,0x97b2,0, 0x8c47,0,0x91e0,0xe440,0,0xe8a4,0x8a4b,0x908f, /* 0,0,'隂',0,'隄','隅','隆',0, '隈',0,'隊','隋',0,'隍','階','随', */
	/* 9690 */ 0,0,0,0,0x8a75,0xe8a6,0,0xe8a7, 0xe8a5,0x8c84,0xfb88,0x8ddb,0x8fe1,0xef7d,0,0, /* 0,0,0,0,'隔','隕',0,'隗', '隘','隙','隚','際','障','隝',0,0, */
	/* 96a0 */ 0x8942,0,0,0x97d7,0xef7e,0xef80,0,0xe8a9, 0xe7ac,0xfb8b,0xe8a8,0,0,0,0,0xfb8c, /* '隠',0,0,'隣','隤','隥',0,'隧', '隨','隩','險',0,0,0,0,'隯', */
	/* 96b0 */ 0xe8ac,0xe8aa,0xe8ab,0xfb8d,0xe8ad,0,0xe8ae,0x97ea, 0xe8af,0xe8b0,0xfb8e,0x90c7,0x94b9,0xfb8f,0,0, /* '隰','隱','隲','隳','隴',0,'隶','隷', '隸','隹','隺','隻','隼','隽',0,0, */
	/* 96c0 */ 0x909d,0x8ae5,0,0,0x9759,0x89eb,0x8f57,0x8cd9, 0,0xe8b3,0,0xe8b2,0x8e93,0xe8b4,0xe8b1,0, /* '雀','雁',0,0,'雄','雅','集','雇', 0,'雉',0,'雋','雌','雍','雎',0, */
	/* 96d0 */ 0,0x8e47,0xef81,0,0,0xe8b8,0xe5ab,0, 0xfb92,0x99d4,0xfb93,0x9097,0xe8b6,0xfb94,0xef82,0, /* 0,'雑','雒',0,0,'雕','雖',0, '雘','雙','雚','雛','雜','雝','雞',0, */
	/* 96e0 */ 0,0,0x97a3,0x93ef,0,0,0,0, 0x894a,0xef84,0x90e1,0x8eb4,0,0,0,0xef85, /* 0,0,'離','難',0,0,0,0, '雨','雩','雪','雫',0,0,0,'雯', */
	/* 96f0 */ 0x95b5,0,0x895f,0,0,0,0x97eb,0x978b, 0,0xe8b9,0,0x9364,0,0,0,0, /* '雰',0,'雲',0,0,0,'零','雷', 0,'雹',0,'電',0,0,0,0, */
	/* 9700 */ 0x8ef9,0,0,0,0xe8ba,0,0xe8bb,0x906b, 0xe8bc,0,0x97ec,0,0,0xe8b7,0xe8be,0xe8c0, /* '需',0,0,0,'霄',0,'霆','震', '霈',0,'霊',0,0,'霍','霎','霏', */
	/* 9710 */ 0,0xe8bf,0,0xe8bd,0xfb96,0,0xe8c1,0, 0,0xe8c2,0,0,0x919a,0,0x89e0,0, /* 0,'霑',0,'霓','霔',0,'霖',0, 0,'霙',0,0,'霜',0,'霞',0, */
	/* 9720 */ 0,0,0,0xfb97,0xe8c3,0,0,0x96b6, 0,0,0xe8c4,0,0,0,0,0, /* 0,0,0,'霣','霤',0,0,'霧', 0,0,'霪',0,0,0,0,0, */
	/* 9730 */ 0xe8c5,0,0x9849,0xef86,0,0,0xfb99,0, 0x9e50,0xe8c6,0,0xef87,0,0xe8c7,0xe8c8,0, /* '霰',0,'露','霳',0,0,'霶',0, '霸','霹',0,'霻',0,'霽','霾',0, */
	/* 9740 */ 0,0xfb9a,0xe8cc,0,0xe8c9,0,0xe8ca,0xfb9b, 0xe8cb,0xe8cd,0,0,0,0xef88,0xef89,0xef8a, /* 0,'靁','靂',0,'靄',0,'靆','靇', '靈','靉',0,0,0,'靍','靎','靏', */
	/* 9750 */ 0,0,0x90c2,0,0,0xfb9c,0x96f5,0xfb9d, 0,0x90c3,0xef8b,0xfb9e,0xe8ce,0,0x94f1,0, /* 0,0,'青',0,0,'靕','靖','靗', 0,'静','靚','靛','靜',0,'非',0, */
	/* 9760 */ 0xe8cf,0xea72,0x96ca,0,0xe8d0,0,0xe8d1,0, 0xe8d2,0x8a76,0xfb9f,0xe8d4,0,0x9078,0xef8c,0, /* '靠','靡','面',0,'靤',0,'靦',0, '靨','革','靪','靫',0,'靭','靮',0, */
	/* 9770 */ 0,0xe8d5,0,0xef8d,0x8c43,0,0,0, 0,0xe8d6,0xe8da,0,0xe8d8,0,0,0, /* 0,'靱',0,'靳','靴',0,0,0, 0,'靹','靺',0,'靼',0,0,0, */
	/* 9780 */ 0,0xe8d9,0,0,0x8a93,0xe8d7,0xe8db,0, 0,0,0,0xe8dc,0,0x88c6,0,0xe8dd, /* 0,'鞁',0,0,'鞄','鞅','鞆',0, 0,0,0,'鞋',0,'鞍',0,'鞏', */
	/* 9790 */ 0xe8de,0,0,0,0,0xef8e,0xfba2,0, 0x8fe2,0,0xfba3,0,0xe8df,0,0xfba4,0, /* '鞐',0,0,0,0,'鞕','鞖',0, '鞘',0,'鞚',0,'鞜',0,'鞞',0, */
	/* 97a0 */ 0x8b66,0,0xfba5,0xe8e2,0,0,0xe8e1,0, 0xe8e0,0,0,0xe691,0,0x95da,0xef8f,0, /* '鞠',0,'鞢','鞣',0,0,'鞦',0, '鞨',0,0,'鞫',0,'鞭','鞮',0, */
	/* 97b0 */ 0,0xfba6,0xfba7,0xe8e3,0xe8e4,0,0,0, 0,0,0xef90,0,0,0,0xfba8,0, /* 0,'鞱','鞲','鞳','鞴',0,0,0, 0,0,'鞺',0,0,0,'鞾',0, */
	/* 97c0 */ 0,0xef91,0,0xe8e5,0,0,0xe8e6,0, 0xe8e7,0xef92,0,0xe8e8,0xfba9,0,0,0, /* 0,'韁',0,'韃',0,0,'韆',0, '韈','韉',0,'韋','韌',0,0,0, */
	/* 97d0 */ 0,0xfbaa,0,0x8ad8,0xfbab,0,0,0, 0xfbac,0xfbad,0,0xef94,0xe8e9,0,0xef93,0, /* 0,'韑',0,'韓','韔',0,0,0, '韘','韙',0,'韛','韜',0,'韞',0, */
	/* 97e0 */ 0,0xfbae,0,0,0,0,0,0, 0,0,0,0,0,0xe8ea,0x9442,0, /* 0,'韡',0,0,0,0,0,0, 0,0,0,0,0,'韭','韮',0, */
	/* 97f0 */ 0,0xfbaf,0xe8ec,0x89b9,0xef95,0xe8ef,0xe8ee,0, 0,0,0,0x8943,0,0,0,0x8bbf, /* 0,'韱','韲','音','韴','韵','韶',0, 0,0,0,'韻',0,0,0,'響', */
	/* 9800 */ 0,0x95c5,0x92b8,0x8da0,0xfbb0,0x8d80,0x8f87,0, 0x907b,0,0xef97,0,0xe8f1,0xfbb1,0xfbb2,0xe8f0, /* 0,'頁','頂','頃','頄','項','順',0, '須',0,'頊',0,'頌','頍','頎','頏', */
	/* 9810 */ 0x9761,0x8ae6,0x94d0,0x93da,0xfbb3,0,0xfbb4,0x909c, 0x97cc,0,0x8c7a,0,0,0,0xef98,0, /* '預','頑','頒','頓','頔',0,'頖','頗', '領',0,'頚',0,0,0,'頞',0, */
	/* 9820 */ 0,0xe8f4,0,0xfbb7,0xe8f3,0xfbba,0,0, 0,0,0,0xef99,0x966a,0x93aa,0,0, /* 0,'頡',0,'頣','頤','頥',0,0, 0,0,0,'頫','頬','頭',0,0, */
	/* 9830 */ 0xef9a,0,0xfbb8,0xfbb9,0x896f,0,0,0xe8f5, 0xe8f2,0,0,0x9570,0x978a,0xe8f6,0,0, /* '頰',0,'頲','頳','頴',0,0,'頷', '頸',0,0,'頻','頼','頽',0,0, */
	/* 9840 */ 0,0,0,0,0,0,0xe8f7,0xfbbb, 0,0,0,0xe8f9,0x91e8,0x8a7a,0x8a7b,0xe8f8, /* 0,0,0,0,0,0,'顆','顇', 0,0,0,'顋','題','額','顎','顏', */
	/* 9850 */ 0,0,0xef9c,0xef9d,0x8ae7,0x8cb0,0xef9e,0xef9f, 0x8ae8,0xefa0,0xefa1,0x935e,0,0,0x97de,0, /* 0,0,'顒','顓','顔','顕','顖','顗', '願','顙','顚','顛',0,0,'類',0, */
	/* 9860 */ 0,0,0,0,0,0xefa3,0xfbbc,0x8cda, 0,0,0,0xe8fa,0xefa4,0,0,0xe8fb, /* 0,0,0,0,0,'顥','顦','顧', 0,0,0,'顫','顬',0,0,'顯', */
	/* 9870 */ 0xe8fc,0xe940,0,0xe942,0xe941,0,0,0, 0,0,0,0,0,0,0,0, /* '顰','顱',0,'顳','顴',0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 98a0 */ 0,0,0,0,0,0,0,0, 0x9597,0,0xe943,0xfbbd,0,0xfbbe,0,0xe944, /* 0,0,0,0,0,0,0,0, '風',0,'颪','颫',0,'颭',0,'颯', */
	/* 98b0 */ 0xfbbf,0xe945,0,0,0,0,0xe946,0xfbc1, 0xfbc2,0,0xefa5,0xfbc3,0xfbc4,0,0,0xfbc5, /* '颰','颱',0,0,0,0,'颶','颷', '颸',0,'颺','颻','颼',0,0,'颿', */
	/* 98c0 */ 0,0,0xfbc6,0xe948,0xe947,0,0xe949,0xfbc7, 0xefa6,0,0,0xfbc8,0,0,0,0, /* 0,0,'飂','飃','飄',0,'飆','飇', '飈',0,0,'飋',0,0,0,0, */
	/* 98d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0x94f2,0xe3ca,0,0,0x9048, /* 0,0,0,0,0,0,0,0, 0,0,0,'飛','飜',0,0,'食', */
	/* 98e0 */ 0xfbc9,0xfbcb,0x8b51,0xfbcc,0,0xfbcd,0,0xefa7, 0,0xe94a,0xfbce,0xe94b,0,0x99aa,0x9f5a,0x94d1, /* '飠','飡','飢','飣',0,'飥',0,'飧', 0,'飩','飪','飫',0,'飭','飮','飯', */
	/* 98f0 */ 0xfbcf,0xfbd0,0x88f9,0xfbd1,0x88b9,0,0,0, 0,0,0,0,0x8e94,0x964f,0x8ffc,0, /* '飰','飱','飲','飳','飴',0,0,0, 0,0,0,0,'飼','飽','飾',0, */
	/* 9900 */ 0,0,0,0xe94c,0,0x96dd,0,0, 0xfbd2,0xe94d,0x977b,0,0x8961,0,0,0, /* 0,0,0,'餃',0,'餅',0,0, '餈','餉','養',0,'餌',0,0,0, */
	/* 9910 */ 0x8e60,0,0xe94e,0x89ec,0xe94f,0,0xfbd5,0xfbd6, 0xe950,0,0xfbd8,0xfbd9,0xfbda,0xe952,0xe953,0, /* '餐',0,'餒','餓','餔',0,'餖','餗', '餘',0,'餚','餛','餜','餝','餞',0, */
	/* 9920 */ 0xe955,0xe951,0,0,0xe954,0,0,0, 0x8ad9,0,0,0,0xe956,0,0xe957,0, /* '餠','餡',0,0,'餤',0,0,0, '館',0,0,0,'餬',0,'餮',0, */
	/* 9930 */ 0,0xfbdc,0xfbdd,0xfbde,0,0,0,0, 0,0,0xfbdf,0xfbe0,0xfbe1,0xe958,0xe959,0, /* 0,'餱','餲','餳',0,0,0,0, 0,0,'餺','餻','餼','餽','餾',0, */
	/* 9940 */ 0xfbe2,0xfbe3,0xe95a,0,0,0xe95c,0xfbe4,0, 0,0xe95b,0,0xe95e,0xe961,0xfbe5,0xfbe6,0, /* '饀','饁','饂',0,0,'饅','饆',0, 0,'饉',0,'饋','饌','饍','饎',0, */
	/* 9950 */ 0xe95d,0xe95f,0xe960,0,0,0xe962,0,0x8bc0, 0xefa8,0,0,0,0xfbe7,0,0,0xfbe8, /* '饐','饑','饒',0,0,'饕',0,'饗', '饘',0,0,0,'饜',0,0,'饟', */
	/* 9960 */ 0xfbe9,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '饠',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9990 */ 0,0,0,0,0,0,0x8ef1,0xe963, 0xe964,0x8d81,0,0,0,0,0xefa9,0, /* 0,0,0,0,0,0,'首','馗', '馘','香',0,0,0,0,'馞',0, */
	/* 99a0 */ 0,0,0,0xfbea,0,0xe965,0xfbeb,0, 0x8a5d,0,0,0,0x946e,0xe966,0xe967,0, /* 0,0,0,'馣',0,'馥','馦',0, '馨',0,0,0,'馬','馭','馮',0, */
	/* 99b0 */ 0,0,0,0x9279,0x93e9,0,0,0, 0,0xfbec,0,0,0xe968,0xfbed,0,0xfbee, /* 0,0,0,'馳','馴',0,0,0, 0,'馹',0,0,'馼','馽',0,'馿', */
	/* 99c0 */ 0,0x949d,0,0xfbef,0x91ca,0x8977,0x8bec,0, 0x8bed,0xfbf0,0,0,0,0,0,0, /* 0,'駁',0,'駃','駄','駅','駆',0, '駈','駉',0,0,0,0,0,0, */
	/* 99d0 */ 0x9293,0xe96d,0x8bee,0,0xfbf1,0x89ed,0,0, 0xe96c,0xfbf2,0,0xe96a,0,0xe96b,0xfbf3,0xe969, /* '駐','駑','駒',0,'駔','駕',0,0, '駘','駙',0,'駛',0,'駝','駞','駟', */
	/* 99e0 */ 0,0,0xe977,0,0,0,0,0, 0,0,0,0,0,0xe96e,0xe96f,0, /* 0,0,'駢',0,0,0,0,0, 0,0,0,0,0,'駭','駮',0, */
	/* 99f0 */ 0xfbf5,0xe970,0xe971,0,0,0,0,0, 0xe973,0xfbf6,0,0xe972,0xfbf7,0,0,0x8f78, /* '駰','駱','駲',0,0,0,0,0, '駸','駹',0,'駻','駼',0,0,'駿', */
	/* 9a00 */ 0,0xe974,0xefaa,0xefab,0,0xe976,0,0, 0,0,0xfbf8,0,0,0,0x8b52,0xe975, /* 0,'騁','騂','騃',0,'騅',0,0, 0,0,'騊',0,0,0,'騎','騏', */
	/* 9a10 */ 0,0xfbf9,0x919b,0x8cb1,0,0,0xfbfa,0, 0,0xe978,0xfbfb,0,0,0,0,0, /* 0,'騑','騒','験',0,0,'騖',0, 0,'騙','騚',0,0,0,0,0, */
	/* 9a20 */ 0xfbfc,0,0,0,0xefac,0,0,0, 0x91cb,0,0,0xe979,0,0xefad,0xefae,0, /* '騠',0,0,0,'騤',0,0,0, '騨',0,0,'騫',0,'騭','騮',0, */
	/* 9a30 */ 0x93ab,0xfc40,0,0,0,0,0xfc41,0xe97a, 0xefaf,0,0,0,0,0,0xe980,0, /* '騰','騱',0,0,0,0,'騶','騷', '騸',0,0,0,0,0,'騾',0, */
	/* 9a40 */ 0xe97d,0,0xe97c,0xe97e,0xfc42,0xe97b,0,0, 0,0,0xefb0,0,0xfc43,0xe982,0xefb1,0, /* '驀',0,'驂','驃','驄','驅',0,0, 0,0,'驊',0,'驌','驍','驎',0, */
	/* 9a50 */ 0,0,0xefb2,0,0,0xe981,0,0xe984, 0xfc44,0,0x8bc1,0xe983,0,0,0,0xe985, /* 0,0,'驒',0,0,'驕',0,'驗', '驘',0,'驚','驛',0,0,0,'驟', */
	/* 9a60 */ 0,0,0xe986,0,0xe988,0xe987,0,0, 0,0xe989,0xe98b,0xe98a,0,0,0,0, /* 0,0,'驢',0,'驤','驥',0,0, 0,'驩','驪','驫',0,0,0,0, */
	/* 9a70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9a90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9aa0 */ 0,0,0,0,0,0,0,0, 0x8d9c,0,0,0,0,0xe98c,0,0xfc46, /* 0,0,0,0,0,0,0,0, '骨',0,0,0,0,'骭',0,'骯', */
	/* 9ab0 */ 0xe98d,0,0,0,0,0,0xefb3,0xfc48, 0x8a5b,0xfc4a,0,0,0xe98e,0,0,0, /* '骰',0,0,0,0,0,'骶','骷', '骸','骹',0,0,'骼',0,0,0, */
	/* 9ac0 */ 0xe98f,0xefb4,0,0xefb5,0x9091,0,0xfc4c,0, 0,0,0,0,0,0,0xefb6,0xe990, /* '髀','髁',0,'髃','髄',0,'髆',0, 0,0,0,0,0,0,'髎','髏', */
	/* 9ad0 */ 0xfc4d,0xe991,0xfc4e,0xe992,0xe993,0xfc4f,0xefb7,0, 0x8d82,0,0,0,0xfc51,0,0xe994,0xe995, /* '髐','髑','髒','髓','體','髕','髖',0, '高',0,0,0,'髜',0,'髞','髟', */
	/* 9ae0 */ 0xfc52,0,0xe996,0xe997,0,0xfc53,0xe998,0, 0,0xfc54,0x94af,0xe99a,0,0x9545,0xe99b,0xe999, /* '髠',0,'髢','髣',0,'髥','髦',0, 0,'髩','髪','髫',0,'髭','髮','髯', */
	/* 9af0 */ 0,0xe99d,0,0,0xe99c,0,0,0xe99e, 0,0xefb8,0,0xe99f,0,0,0,0, /* 0,'髱',0,0,'髴',0,0,'髷', 0,'髹',0,'髻',0,0,0,0, */
	/* 9b00 */ 0,0,0xefb9,0xfc55,0,0,0xe9a0,0, 0xefba,0,0,0,0xfc56,0,0,0, /* 0,0,'鬂','鬃',0,0,'鬆',0, '鬈',0,0,0,'鬌',0,0,0, */
	/* 9b10 */ 0xfc57,0,0xfc58,0,0,0,0xfc59,0, 0xe9a1,0,0xe9a2,0,0xfc5a,0,0,0xe9a3, /* '鬐',0,'鬒',0,0,0,'鬖',0, '鬘',0,'鬚',0,'鬜',0,0,'鬟', */
	/* 9b20 */ 0xefbb,0,0xe9a4,0xe9a5,0,0xe9a6,0,0xe9a7, 0xe9a8,0xe9a9,0xe9aa,0xfc5b,0,0xefbd,0xe9ab,0xe9ac, /* '鬠',0,'鬢','鬣',0,'鬥',0,'鬧', '鬨','鬩','鬪','鬫',0,'鬭','鬮','鬯', */
	/* 9b30 */ 0,0x9f54,0xe9ad,0xfc5c,0,0,0,0, 0,0,0,0xe2f6,0x8b53,0xfc5d,0,0, /* 0,'鬱','鬲','鬳',0,0,0,0, 0,0,0,'鬻','鬼','鬽',0,0, */
	/* 9b40 */ 0,0x8a40,0x8db0,0xe9af,0xe9ae,0x96a3,0,0, 0,0,0,0xfc5f,0,0xe9b1,0xe9b2,0xe9b0, /* 0,'魁','魂','魃','魄','魅',0,0, 0,0,0,'魋',0,'魍','魎','魏', */
	/* 9b50 */ 0,0xe9b3,0,0,0x9682,0,0,0, 0xe9b4,0,0x8b9b,0,0,0,0xefbe,0, /* 0,'魑',0,0,'魔',0,0,0, '魘',0,'魚',0,0,0,'魞',0, */
	/* 9b60 */ 0,0,0,0xfc60,0,0xfc61,0xefc0,0, 0,0,0,0xfc62,0xfc63,0,0,0x9844, /* 0,0,0,'魣',0,'魥','魦',0, 0,0,0,'魫','魬',0,0,'魯', */
	/* 9b70 */ 0,0,0xefc1,0xfc64,0xe9b5,0xefc2,0xfc65,0xfc66, 0,0xefbf,0,0,0,0,0,0, /* 0,0,'魲','魳','魴','魵','魶','魷', 0,'魹',0,0,0,0,0,0, */
	/* 9b80 */ 0,0,0,0xe9b7,0xefc3,0,0,0, 0,0,0xefc4,0,0,0,0x88bc,0xefc5, /* 0,0,0,'鮃','鮄',0,0,0, 0,0,'鮊',0,0,0,'鮎','鮏', */
	/* 9b90 */ 0,0xe9b8,0x95a9,0xe9b6,0,0,0xe9b9,0xe9ba, 0,0,0,0,0,0,0xefc6,0xe9bb, /* 0,'鮑','鮒','鮓',0,0,'鮖','鮗', 0,0,0,0,0,0,'鮞','鮟', */
	/* 9ba0 */ 0xe9bc,0,0,0,0,0,0xfc67,0xefc7, 0xe9bd,0,0x968e,0x8e4c,0xfc68,0x8df8,0x914e,0, /* '鮠',0,0,0,0,0,'鮦','鮧', '鮨',0,'鮪','鮫','鮬','鮭','鮮',0, */
	/* 9bb0 */ 0,0xfc69,0xfc6c,0,0xe9be,0,0,0, 0xfc6d,0xe9c1,0,0,0,0,0xfc6e,0, /* 0,'鮱','鮲',0,'鮴',0,0,0, '鮸','鮹',0,0,0,0,'鮾',0, */
	/* 9bc0 */ 0xe9bf,0xefc8,0,0,0,0,0xe9c2,0xfc6f, 0,0x8cef,0xe9c0,0,0,0,0xefc9,0xe9c3, /* '鯀','鯁',0,0,0,0,'鯆','鯇', 0,'鯉','鯊',0,0,0,'鯎','鯏', */
	/* 9bd0 */ 0,0xe9c4,0xe9c5,0,0xe9c9,0,0x8e49,0, 0xfc71,0,0,0x91e2,0,0xfc72,0,0, /* 0,'鯑','鯒',0,'鯔',0,'鯖',0, '鯘',0,0,'鯛',0,'鯝',0,0, */
	/* 9be0 */ 0,0xe9ca,0xe9c7,0xe9c6,0xe9c8,0xefca,0,0xfc73, 0x8c7e,0,0xfc74,0xfc75,0,0,0xfc77,0xfc76, /* 0,'鯡','鯢','鯣','鯤','鯥',0,'鯧', '鯨',0,'鯪','鯫',0,0,'鯮','鯯', */
	/* 9bf0 */ 0xe9ce,0xe9cd,0xe9cc,0xfc70,0,0x88b1,0,0xfc7b, 0xefcb,0,0xfc79,0,0,0xefcc,0,0, /* '鯰','鯱','鯲','鯳',0,'鯵',0,'鯷', '鯸',0,'鯺',0,0,'鯽',0,0, */
	/* 9c00 */ 0xefcd,0,0,0,0xe9d8,0,0xe9d4,0, 0xe9d5,0xe9d1,0xe9d7,0,0xe9d3,0x8a82,0,0, /* '鰀',0,0,0,'鰄',0,'鰆',0, '鰈','鰉','鰊',0,'鰌','鰍',0,0, */
	/* 9c10 */ 0x986b,0,0xe9d6,0xe9d2,0xe9d0,0xe9cf,0xfc7d,0, 0xfc7e,0xfc80,0xfc81,0xe9da,0,0xfc82,0,0, /* '鰐',0,'鰒','鰓','鰔','鰕','鰖',0, '鰘','鰙','鰚','鰛',0,'鰝',0,0, */
	/* 9c20 */ 0,0xe9dd,0xfc83,0xefce,0xe9dc,0xe9db,0,0xfc84, 0,0xfc85,0xfc86,0,0,0x9568,0xe9d9,0x88f1, /* 0,'鰡','鰢','鰣','鰤','鰥',0,'鰧', 0,'鰩','鰪',0,0,'鰭','鰮','鰯', */
	/* 9c30 */ 0xe9de,0xfc88,0xe9e0,0,0,0,0xfc89,0xfc8a, 0,0x8a8f,0xe9cb,0x8956,0,0,0xe9e2,0, /* '鰰','鰱','鰲',0,0,0,'鰶','鰷', 0,'鰹','鰺','鰻',0,0,'鰾',0, */
	/* 9c40 */ 0,0xefcf,0,0,0,0xfc8b,0xe9e1,0xe9df, 0x924c,0xfc8e,0xfc8f,0,0,0,0,0xefd0, /* 0,'鱁',0,0,0,'鱅','鱆','鱇', '鱈','鱉','鱊',0,0,0,0,'鱏', */
	/* 9c50 */ 0xefd1,0,0x9690,0xefd2,0xfc91,0,0,0x97d8, 0xfc92,0,0xe9e3,0xfc93,0xfc8c,0xfc94,0,0xfc95, /* '鱐',0,'鱒','鱓','鱔',0,0,'鱗', '鱘',0,'鱚','鱛','鱜','鱝',0,'鱟', */
	/* 9c60 */ 0xe9e4,0,0,0xefd3,0,0xefd4,0,0xe9e5, 0,0xfc96,0xfc97,0xfc98,0,0xfc99,0xfc9a,0, /* '鱠',0,0,'鱣',0,'鱥',0,'鱧', 0,'鱩','鱪','鱫',0,'鱭','鱮',0, */
	/* 9c70 */ 0xfc9b,0,0xfc9c,0,0,0xfc9d,0xe9e6,0xefd5, 0xe9e7,0,0xfc9e,0,0,0,0,0, /* '鱰',0,'鱲',0,0,'鱵','鱶','鱷', '鱸',0,'鱺',0,0,0,0,0, */
	/* 9c80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9c90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9cd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ce0 */ 0,0,0,0,0,0x92b9,0xfc9f,0xe9e8, 0,0x94b5,0,0xe9ed,0xe9e9,0,0,0, /* 0,0,0,0,0,'鳥','鳦','鳧', 0,'鳩',0,'鳫','鳬',0,0,0, */
	/* 9cf0 */ 0xe9ea,0,0xfca0,0x9650,0x96c2,0,0x93ce,0, 0,0,0,0,0,0,0,0, /* '鳰',0,'鳲','鳳','鳴',0,'鳶',0, 0,0,0,0,0,0,0,0, */
	/* 9d00 */ 0,0,0xfca2,0xe9ee,0,0,0xe9ef,0x93bc, 0xe9ec,0xe9eb,0,0xfca1,0,0,0x89a8,0, /* 0,0,'鴂','鴃',0,0,'鴆','鴇', '鴈','鴉',0,'鴋',0,0,'鴎',0, */
	/* 9d10 */ 0,0xfca4,0xe9f7,0,0,0xe9f6,0,0xfca5, 0xfca6,0,0,0x8995,0,0xefd6,0xefd7,0xe9f4, /* 0,'鴑','鴒',0,0,'鴕',0,'鴗', '鴘',0,0,'鴛',0,'鴝','鴞','鴟', */
	/* 9d20 */ 0,0,0,0xe9f3,0,0,0xe9f1,0, 0x8a9b,0,0xe9f0,0x8eb0,0x89a7,0,0,0, /* 0,0,0,'鴣',0,0,'鴦',0, '鴨',0,'鴪','鴫','鴬',0,0,0, */
	/* 9d30 */ 0,0,0xfcaa,0,0,0,0,0, 0,0,0,0x8d83,0,0,0xe9fa,0xe9f9, /* 0,0,'鴲',0,0,0,0,0, 0,0,0,'鴻',0,0,'鴾','鴿', */
	/* 9d40 */ 0,0xe9f8,0xfcac,0xefd8,0xe9f5,0,0xe9fb,0xefd9, 0xe9fc,0,0xfcad,0,0,0,0,0, /* 0,'鵁','鵂','鵃','鵄',0,'鵆','鵇', '鵈',0,'鵊',0,0,0,0,0, */
	/* 9d50 */ 0xea44,0xea43,0xefda,0,0,0,0,0, 0,0xea45,0,0,0x894c,0xea40,0xea41,0xfcae, /* '鵐','鵑','鵒',0,0,0,0,0, 0,'鵙',0,0,'鵜','鵝','鵞','鵟', */
	/* 9d60 */ 0x8d94,0x96b7,0xfcaf,0xefdb,0xea42,0,0,0, 0,0xfcb1,0,0xfcb2,0x9651,0,0,0xea4a, /* '鵠','鵡','鵢','鵣','鵤',0,0,0, 0,'鵩',0,'鵫','鵬',0,0,'鵯', */
	/* 9d70 */ 0xefdc,0,0xea46,0xfcb4,0,0,0xfcb5,0xfcb6, 0,0,0xea4b,0,0xefdd,0,0xfcb7,0, /* '鵰',0,'鵲','鵳',0,0,'鵶','鵷', 0,0,'鵺',0,'鵼',0,'鵾',0, */
	/* 9d80 */ 0,0,0,0,0xfcb8,0,0,0xea48, 0,0xea47,0xefde,0,0,0xfcb9,0,0x8c7b, /* 0,0,0,0,'鶄',0,0,'鶇', 0,'鶉','鶊',0,0,'鶍',0,'鶏', */
	/* 9d90 */ 0,0,0,0,0,0,0xefdf,0, 0,0xfcba,0xea4c,0,0,0,0,0, /* 0,0,0,0,0,0,'鶖',0, 0,'鶙','鶚',0,0,0,0,0, */
	/* 9da0 */ 0,0xfcbb,0,0,0xea4d,0,0,0, 0,0xea4e,0,0xea49,0xefe1,0,0,0xe9f2, /* 0,'鶡',0,0,'鶤',0,0,0, 0,'鶩',0,'鶫','鶬',0,0,'鶯', */
	/* 9db0 */ 0,0,0xea4f,0,0x92df,0xfcbd,0,0, 0xea53,0xfcbe,0xea54,0xea52,0xefe2,0xfcbf,0,0xfcbc, /* 0,0,'鶲',0,'鶴','鶵',0,0, '鶸','鶹','鶺','鶻','鶼','鶽',0,'鶿', */
	/* 9dc0 */ 0xefe0,0xea51,0xea57,0xfcc0,0xea50,0,0xea55,0xfcc1, 0,0xfcc2,0,0,0,0,0,0xea56, /* '鷀','鷁','鷂','鷃','鷄',0,'鷆','鷇', 0,'鷉',0,0,0,0,0,'鷏', */
	/* 9dd0 */ 0,0,0,0xea59,0,0,0xfcc3,0xefe3, 0,0xea58,0xfcc4,0,0,0,0,0xfcc5, /* 0,0,0,'鷓',0,0,'鷖','鷗', 0,'鷙','鷚',0,0,0,0,'鷟', */
	/* 9de0 */ 0xfcc6,0,0,0xfcc7,0,0,0xea5b,0xefe5, 0,0,0,0,0,0xea5c,0,0xea5d, /* '鷠',0,0,'鷣',0,0,'鷦','鷧', 0,0,0,0,0,'鷭',0,'鷯', */
	/* 9df0 */ 0,0,0x9868,0,0xfcc8,0,0,0, 0xea5a,0x91e9,0x8deb,0,0,0xea5e,0,0, /* 0,0,'鷲',0,'鷴',0,0,0, '鷸','鷹','鷺',0,0,'鷽',0,0, */
	/* 9e00 */ 0,0,0xfccb,0,0,0,0,0xefe6, 0,0,0xfcca,0,0,0xfccc,0,0, /* 0,0,'鸂',0,0,0,0,'鸇', 0,0,'鸊',0,0,'鸍',0,0, */
	/* 9e10 */ 0,0,0,0,0,0xefe7,0,0, 0,0xfccd,0xea5f,0xea60,0xfcce,0xfccf,0xea61,0, /* 0,0,0,0,0,'鸕',0,0, 0,'鸙','鸚','鸛','鸜','鸝','鸞',0, */
	/* 9e20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9e70 */ 0,0,0,0,0,0xea62,0,0, 0x8cb2,0xea63,0,0xfcd0,0xefe8,0xea64,0,0x8ead, /* 0,0,0,0,0,'鹵',0,0, '鹸','鹹',0,'鹻','鹼','鹽',0,'鹿', */
	/* 9e80 */ 0xfcd2,0xea65,0,0,0,0xfcd3,0,0, 0xea66,0,0,0xea67,0xea68,0,0,0, /* '麀','麁',0,0,0,'麅',0,0, '麈',0,0,'麋','麌',0,0,0, */
	/* 9e90 */ 0,0xea6b,0xea69,0x985b,0,0xea6a,0,0x97ed, 0,0,0,0xfcd4,0,0xea6c,0xefe9,0x97d9, /* 0,'麑','麒','麓',0,'麕',0,'麗', 0,0,0,'麛',0,'麝','麞','麟', */
	/* 9ea0 */ 0,0,0,0,0xefea,0xea6d,0x949e,0, 0xfcd5,0xea6e,0xea70,0,0xefeb,0xea71,0,0xefec, /* 0,0,0,0,'麤','麥','麦',0, '麨','麩','麪',0,'麬','麭',0,'麯', */
	/* 9eb0 */ 0,0,0,0,0xefed,0xefee,0,0, 0xea6f,0x8d8d,0x96cb,0x9683,0x9bf5,0xfcd7,0x9f80,0x969b, /* 0,0,0,0,'麴','麵',0,0, '麸','麹','麺','麻','麼','麽','麾','麿', */
	/* 9ec0 */ 0,0,0,0xefef,0x89a9,0,0,0, 0,0,0,0,0xea73,0x8b6f,0xea74,0xea75, /* 0,0,0,'黃','黄',0,0,0, 0,0,0,0,'黌','黍','黎','黏', */
	/* 9ed0 */ 0xea76,0xeff0,0x8d95,0,0xea77,0,0,0, 0xe0d2,0x96d9,0,0x91e1,0xea78,0xea7a,0xea79,0xfcd9, /* '黐','黑','黒',0,'黔',0,0,0, '默','黙',0,'黛','黜','黝','點','黟', */
	/* 9ee0 */ 0xea7b,0,0,0,0,0xea7c,0,0xfcda, 0xea7d,0,0,0,0,0,0xfcdb,0xea7e, /* '黠',0,0,0,0,'黥',0,'黧', '黨',0,0,0,0,0,'黮','黯', */
	/* 9ef0 */ 0,0,0,0,0xea80,0,0xea81,0xea82, 0,0xea83,0,0xea84,0xea85,0xea86,0,0xfcdc, /* 0,0,0,0,'黴',0,'黶','黷', 0,'黹',0,'黻','黼','黽',0,'黿', */
	/* 9f00 */ 0,0,0xfcdd,0xfcdf,0,0,0,0xea87, 0xea88,0,0,0,0,0,0x9343,0, /* 0,0,'鼂','鼃',0,0,0,'鼇', '鼈',0,0,0,0,0,'鼎',0, */
	/* 9f10 */ 0xeff1,0,0,0x8cdb,0,0xea8a,0,0xfce0, 0,0xfce1,0,0,0,0,0,0, /* '鼐',0,0,'鼓',0,'鼕',0,'鼗', 0,'鼙',0,0,0,0,0,0, */
	/* 9f20 */ 0x916c,0xea8b,0,0,0,0,0,0, 0,0,0,0,0xea8c,0,0,0xfce2, /* '鼠','鼡',0,0,0,0,0,0, 0,0,0,0,'鼬',0,0,'鼯', */
	/* 9f30 */ 0,0,0,0,0,0,0,0xfce3, 0,0xeff2,0xfce4,0x9540,0,0xfce5,0xea8d,0, /* 0,0,0,0,0,0,0,'鼷', 0,'鼹','鼺','鼻',0,'鼽','鼾',0, */
	/* 9f40 */ 0,0xfce6,0,0,0,0xfce7,0xfce8,0, 0,0,0xea8e,0xe256,0,0,0xe6d8,0xe8eb, /* 0,'齁',0,0,0,'齅','齆',0, 0,0,'齊','齋',0,0,'齎','齏', */
	/* 9f50 */ 0,0,0xea8f,0xfce9,0xea90,0xfcea,0,0xeff3, 0xfceb,0,0,0,0,0xfced,0,0xea92, /* 0,0,'齒','齓','齔','齕',0,'齗', '齘',0,0,0,0,'齝',0,'齟', */
	/* 9f60 */ 0xea93,0xea94,0x97ee,0xea91,0,0,0xea95,0xea96, 0,0xfcef,0xea98,0,0xea97,0xfcf1,0,0, /* '齠','齡','齢','齣',0,0,'齦','齧', 0,'齩','齪',0,'齬','齭',0,0, */
	/* 9f70 */ 0xfcf2,0,0xea9a,0,0,0xfcf3,0xea9b,0xea99, 0,0,0,0,0,0,0,0, /* '齰',0,'齲',0,0,'齵','齶','齷', 0,0,0,0,0,0,0,0, */
	/* 9f80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0x97b4,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'龍',0,0, */
	/* 9f90 */ 0xeff4,0,0,0,0xeff5,0xea9c,0,0xeff6, 0,0,0,0,0xea9d,0xe273,0,0, /* '龐',0,0,0,'龔','龕',0,'龗', 0,0,0,0,'龜','龝',0,0, */
	/* 9fa0 */ 0xea9e,0,0xeff7,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '龠',0,'龢',0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* 9fb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9fe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* 9ff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* a9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ab90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* abf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ac90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ace0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* acf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ad90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ada0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* add0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ade0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* adf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ae90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* af90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* afe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* aff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* b9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ba90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* baf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* be90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* beb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* bff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* c9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ca90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* caf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ccf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ce90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ceb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ced0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cf90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* cff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* d9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* da90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* daf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* db90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ddf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* de90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* deb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ded0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* def0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* df90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dfe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* dff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e920 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e930 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e970 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* e9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ea90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ead0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eaf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ebf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ec90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ece0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ecf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ed90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ede0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* edf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ee90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eeb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ef90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* efe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* eff0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f000 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f010 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f020 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f030 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f040 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f050 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f060 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f070 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f080 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f090 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f0f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f100 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f110 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f120 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f130 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f140 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f150 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f160 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f170 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f180 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f190 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f1f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f200 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f210 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f220 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f230 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f240 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f250 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f260 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f270 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f280 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f290 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f2f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f300 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f310 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f320 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f330 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f340 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f350 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f360 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f370 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f380 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f390 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f3f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f400 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f410 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f420 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f430 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f440 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f450 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f460 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f470 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f480 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f490 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f4f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f500 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f510 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f520 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f530 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f540 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f550 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f560 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f570 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f580 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f590 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f5f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f600 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f610 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f620 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f630 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f640 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f650 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f660 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f670 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f680 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f690 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f6f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f700 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f710 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f720 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f730 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f740 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f750 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f760 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f770 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f780 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f790 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f7f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f800 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f810 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f820 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f830 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f840 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f850 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f860 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f870 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f880 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f890 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8d0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f8f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f900 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f910 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0xebb9,0,0, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,'欄',0,0, */
	/* f920 */ 0,0,0,0,0,0,0,0, 0xeaac,0xeb6d,0,0,0,0,0,0, /* 0,0,0,0,0,0,0,0, '廊','朗',0,0,0,0,0,0, */
	/* f930 */ 0,0,0,0,0,0,0xee6e,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,0,'虜',0, 0,0,0,0,0,0,0,0, */
	/* f940 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f950 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f960 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f970 */ 0xebc7,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, /* '殺',0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, */
	/* f980 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f990 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9a0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9b0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9c0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9d0 */ 0xefa2,0,0,0,0,0,0,0, 0,0,0,0,0xef7c,0,0,0, /* '類',0,0,0,0,0,0,0, 0,0,0,0,'隆',0,0,0, */
	/* f9e0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* f9f0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0x886a, /* 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,'﨏', */
	/* fa10 */ 0x8876,0x9892,0,0xf3f7,0xeb9a,0xec79,0xec8f,0, 0,0xed5b,0xed5c,0xed60,0,0,0,0xee59, /* '塚','﨑',0,'﨓','﨔','凞','猪',0, 0,'神','祥','福',0,0,0,'﨟', */
	/* fa20 */ 0xf957,0xf964,0xeeac,0,0xfa8e,0,0xeee8,0, 0,0,0,0,0,0,0,0, /* '蘒','﨡','諸',0,'﨤',0,'都',0, 0,0,0,0,0,0,0,0, */
	/* fa30 */ 0x87b6,0x87c7,0x87ce,0x87e1,0x87e6,0x87ec,0x884b,0x884e, 0x8855,0x8879,0x887d,0x9881,0x9882,0xeace,0xeada,0xeadc, /* '侮','僧','免','勉','勤','卑','喝','嘆', '器','塀','墨','層','屮','悔','慨','憎', */
	/* fa40 */ 0xeadf,0xeb47,0xeb4a,0xeb62,0xeb85,0xebe7,0xebf5,0xec44, 0xec74,0xf5a7,0xeca3,0xed46,0xed52,0xed53,0xed56,0xed57, /* '懲','敏','既','暑','梅','海','渚','漢', '煮','爫','琢','碑','社','祉','祈','祐', */
	/* fa50 */ 0xed58,0xed5a,0xed5e,0xed5f,0xed6c,0xed70,0xed84,0xedac, 0xf7ce,0xedb1,0xedb8,0xedc2,0xedd6,0xf894,0xf895,0xee46, /* '祖','祝','禍','禎','穀','突','節','練', '縉','繁','署','者','臭','艹','艹','著', */
	/* fa60 */ 0xee8f,0xee99,0xeead,0xeeae,0xeeb6,0xeebb,0xfa89,0xeed7, 0xef83,0xef96,0xef9b,0,0,0,0,0, /* '褐','視','謁','謹','賓','贈','辶','逸', '難','響','頻',0,0,0,0,0, */
	/* fa70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fa90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fab0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fac0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fad0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fae0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* faf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fb90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fba0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbe0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fbf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fc90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fca0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fce0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fcf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd40 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fd90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fda0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fde0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fdf0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe00 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe10 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe20 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe30 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe40 */ 0,0,0,0,0,0x825d,0x825c,0, 0,0,0,0,0,0,0,0, /* 0,0,0,0,0,'﹅','﹆',0, 0,0,0,0,0,0,0,0, */
	/* fe50 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe60 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe70 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe80 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fe90 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fea0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* feb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fec0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fed0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fee0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* fef0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ff00 */ 0,0x8149,0x81ae,0x8194,0x8190,0x8193,0x8195,0x81ad, 0x8169,0x816a,0x8196,0x817b,0x8143,0x81af,0x8144,0x815e, /* 0,'！','＂','＃','＄','％','＆','＇', '（','）','＊','＋','，','－','．','／', */
	/* ff10 */ 0x824f,0x8250,0x8251,0x8252,0x8253,0x8254,0x8255,0x8256, 0x8257,0x8258,0x8146,0x8147,0x8183,0x8181,0x8184,0x8148, /* '０','１','２','３','４','５','６','７', '８','９','：','；','＜','＝','＞','？', */
	/* ff20 */ 0x8197,0x8260,0x8261,0x8262,0x8263,0x8264,0x8265,0x8266, 0x8267,0x8268,0x8269,0x826a,0x826b,0x826c,0x826d,0x826e, /* '＠','Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ', 'Ｈ','Ｉ','Ｊ','Ｋ','Ｌ','Ｍ','Ｎ','Ｏ', */
	/* ff30 */ 0x826f,0x8270,0x8271,0x8272,0x8273,0x8274,0x8275,0x8276, 0x8277,0x8278,0x8279,0x816d,0x815f,0x816e,0x814f,0x8151, /* 'Ｐ','Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ', 'Ｘ','Ｙ','Ｚ','［','＼','］','＾','＿', */
	/* ff40 */ 0x814d,0x8281,0x8282,0x8283,0x8284,0x8285,0x8286,0x8287, 0x8288,0x8289,0x828a,0x828b,0x828c,0x828d,0x828e,0x828f, /* '｀','ａ','ｂ','ｃ','ｄ','ｅ','ｆ','ｇ', 'ｈ','ｉ','ｊ','ｋ','ｌ','ｍ','ｎ','ｏ', */
	/* ff50 */ 0x8290,0x8291,0x8292,0x8293,0x8294,0x8295,0x8296,0x8297, 0x8298,0x8299,0x829a,0x816f,0x8162,0x8170,0x81b0,0x81d4, /* 'ｐ','ｑ','ｒ','ｓ','ｔ','ｕ','ｖ','ｗ', 'ｘ','ｙ','ｚ','｛','｜','｝',～,'｟', */
	/* ff60 */ 0x81d5,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7, 0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af, /* '｠','｡','｢','｣','､','･','ｦ','ｧ', 'ｨ','ｩ','ｪ','ｫ','ｬ','ｭ','ｮ','ｯ', */
	/* ff70 */ 0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7, 0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf, /* 'ｰ','ｱ','ｲ','ｳ','ｴ','ｵ','ｶ','ｷ', 'ｸ','ｹ','ｺ','ｻ','ｼ','ｽ','ｾ','ｿ', */
	/* ff80 */ 0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7, 0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf, /* 'ﾀ','ﾁ','ﾂ','ﾃ','ﾄ','ﾅ','ﾆ','ﾇ', 'ﾈ','ﾉ','ﾊ','ﾋ','ﾌ','ﾍ','ﾎ','ﾏ', */
	/* ff90 */ 0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7, 0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df, /* 'ﾐ','ﾑ','ﾒ','ﾓ','ﾔ','ﾕ','ﾖ','ﾗ', 'ﾘ','ﾙ','ﾚ','ﾛ','ﾜ','ﾝ','ﾞ','ﾟ', */
	/* ffa0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffb0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffc0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffd0 */ 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	/* ffe0 */ 0,0,0,0x8150,0,0x818f, /* 0,0,0,'￣',0,'￥', */
};

const size_t _unibe2sjis2004_table_size = sizeof(_unibe2sjis2004_table) / sizeof(_unibe2sjis2004_table[0]);

#endif /* #ifndef __UNIBE2SJIS2004_TABLE_H_ */
