/*
 * _dcs_copy.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _dcs_copy(Dcs *dcs, int stype) {
	int c, sts = DCS_SUCCESS;
	const unsigned char *sp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	/* 入力データのBOMが取れているので追加 */
	switch(stype) {
	case DCS_JIS:
	case DCS_JIS1:
	case DCS_JIS2:
		if (ep - sp >= 3
		 && *sp == _ESC_CHAR && *(sp + 1) == 0x28 && *(sp + 2) == 0x42) {
		/* ASCII シフト・コードの時 */
			sp += 3;
		}
		break;
	case DCS_UTF8_BOM:
		*dp++ = UTF8_B0;
		*dp++ = UTF8_B1;
		*dp++ = UTF8_B2;
		break;
	case DCS_UTF16BE_BOM:
		*dp++ = UTF16_B0;
		*dp++ = UTF16_B1;
		break;
	case DCS_UTF16LE_BOM:
		*dp++ = UTF16_B1;
		*dp++ = UTF16_B0;
		break;
	case DCS_UTF32BE_BOM:
		*dp++ = 0;
		*dp++ = 0;
		*dp++ = UTF16_B0;
		*dp++ = UTF16_B1;
		break;
	case DCS_UTF32LE_BOM:
		*dp++ = UTF16_B1;
		*dp++ = UTF16_B0;
		*dp++ = 0;
		*dp++ = 0;
		break;
	}
	switch(stype) {
	case DCS_ASCII:
	case DCS_JIS:
	case DCS_JIS1:
	case DCS_JIS2:
	case DCS_SJIS:
	case DCS_SJIS2:
	case DCS_EUC:
	case DCS_EUC1:
	case DCS_EUC2:
	case DCS_EUC3:
	case DCS_EUC4:
	case DCS_UTF8:
	case DCS_UTF8_BOM:
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 1, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_OFFSET, sts);
			/* UT8 の簡易コピー（改行文字の編集のみ）  */
			_utf8_copy(dcs, dp, sp, ep, ltype, c);
		}
		break;
	case DCS_UTF16BE:
	case DCS_UTF16BE_BOM:
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 2, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNIBE_OFFSET, sts);
			/* UTF16-BE の簡易コピー（改行文字の編集のみ）  */
			_utf16be_copy(dcs, dp, sp, ep, ltype, c);
		}
		break;
	case DCS_UTF16LE:
	case DCS_UTF16LE_BOM:
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 2, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNILE_OFFSET, sts);
			/* UTF16-LE の簡易コピー（改行文字の編集のみ）  */
			_utf16le_copy(dcs, dp, sp, ep, ltype, c);
		}
		break;
	case DCS_UTF32BE:
	case DCS_UTF32BE_BOM:
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 2, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNIBE_OFFSET, sts);
			/* UTF32-BE の簡易コピー（改行文字の編集のみ）  */
			_utf32be_copy(dcs, dp, sp, ep, ltype, c);
		}
		break;
	case DCS_UTF32LE:
	case DCS_UTF32LE_BOM:
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 2, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNILE_OFFSET, sts);
			/* UTF32-LE の簡易コピー（改行文字の編集のみ）  */
			_utf32le_copy(dcs, dp, sp, ep, ltype, c);
		}
		break;
	}
	if (sts == DCS_SUCCESS) {
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, sts);
	}
	DCS_RETURN(dcs, sts);
}
