/*
 * _eucto_jis.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _eucto_jis(Dcs *dcs) {
	int tsts, sts = DCS_SUCCESS;
	int c, c2, tc, flag_shift = STYPE_ASCII;			/* SHIFT OUT */
	const unsigned char *tp, *tsp, *sp, *ep;
	unsigned char *dbuf, *dp, *tdp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	for(;;) {
		/* 残りが最大長に満たない時、次の入力バッファに移動 */
		check_ll_buf(dcs, sp, ep, 3, clist, tlist, binfo, tbinfo);
		/* 出力バッファ・サイズを超える時、ライター出力 */
		check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts);
		if (sp >= ep) {
			break;
		}
		tp = sp;
		if ((*sp & 0xff) == 0x8f) {
			tc = (*(sp++) & 0xff);
			if (sp >= ep) {
				sts = DCS_EUEXPEOD;
				break;
			}
		} else {
			tc = 0;
		}
		if ((c = (*sp++ & 0xff)) >= 0xa1) {
			if (sp >= ep) {
				sts = DCS_EUEXPEOD;
				break;
			}
			c = ((tc<<16)|(c<<8)|(*sp++ & 0xff));
			/* EUCコード（文字列）からJISコードへの変換 */
			/* 第４引数 c はエラー時に judge_unibe_to_jis_short_sp で処理する */
			judge_euc_to_jis_short_sp(dcs, dp, c, c, tp, flag_shift);
		} else if (c == 0x8e) {			/* EUCカナ第１バイト */
			if (sp >= ep) {
				sts = DCS_EUEXPEOD;
				break;
			}
			c = (*sp++ & 0xff);
			if (is_sjis_kana(c)) {
			/* 半角カナの時 */
				if (dcs_is_hankana_to(dcs)) {
					/* 半角カナ全角変換の時 */
					c = sjis_kana_to_unibe(c & 0xff);
					tc = c;
					tsp = sp;
					EUC_HAN_TO_ZEN(dcs, c, sp, ep, is_to_jis2022jp2004(dcs) || is_to_jis2022jp3(dcs));
					tdp = dp;
					judge_unibe_to_jis_short_sp(dcs, dp, c, c2, sp-2, flag_shift);

					if (dp==tdp || (*(dp - 2) == NO_CHAR1 && *(dp - 1) == NO_CHAR2)) {
					// 書き込みがない、又は不正文字の時
						dp = tdp;
						_check_jis_to_zen(dp, flag_shift);
						c = _f_han_to_zen(tc);
						unibe_to_jis_short_sp(dcs, dp, c, sp - 2);
						dp += 2;
						sp = tsp;		// 濁点から
					}
					continue;
				}
			}
			if (flag_shift != STYPE_KANA) {
				*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
				*dp++ = ('(');			/* JISSHIFT OUT */
				*dp++ = ('I');			/* JIS半角カナ */
				flag_shift = STYPE_KANA;
			}
			*dp++ = (sjis_kana_to_jis(c));
		} else if (c == 0x8f) {			/* EUC３バイト第１バイト */
			if (sp + 2 > ep) {
				sts = DCS_EUEXPEOD;
				break;
			}
			c = (0x8f0000 | char_to_short(sp));
			/* 第４引数 c はエラー時に judge_unibe_to_jis_short_sp で処理する */
			judge_euc_to_jis_short_sp(dcs, dp, c, c, tp, flag_shift);
			/* FA5C'?\'-FC4A'?J' */
			sp += 2;
		} else {
			if (flag_shift != STYPE_ASCII) {
				*dp++ = (_ESC_CHAR);			/* エスケープ(0x1b) */
				*dp++ = ('(');				/* JISSHIFT OUT */
				*dp++ = (_SHIFT_OUT);		/* ローマ字 */
				flag_shift = STYPE_ASCII;	/* SHIFT OUT */
			}
			cnvln_stype_to_jis(dp, c, sp, ep, ltype, euc);
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		if (flag_shift != STYPE_ASCII) {
			*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
			*dp++ = ('(');			/* JISSHIFT OUT */
			*dp++ = (_SHIFT_OUT);	/* ローマ字 */
		}
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
