/*
 * _eucto_sjis.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include <ctype.h>
#include "_dcs.h"

int _eucto_sjis(Dcs *dcs) {
	int tsts, sts = DCS_SUCCESS;
	int c, tc, bytes;
	const unsigned char *tp, *tsp, *sp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	for(;;) {
		/* 残りが最大長に満たない時、次の入力バッファに移動 */
		check_ll_buf(dcs, sp, ep, 3, clist, tlist, binfo, tbinfo);
		/* 出力バッファ・サイズを超える時、ライター出力 */
		check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_SJIS_OFFSET, sts);
		if (sp >= ep) {
			break;
		}
		tp = sp;
		if ((c = (*sp++ & 0xff)) >= 0xa1 || c == 0x8e) {
			if (sp >= ep) {
				sts = DCS_EUEXPEOD;
				break;
			}
			c = ((c<<8)|(*sp++ & 0xff));
			if ((c & 0xff00) == 0x8e00 && is_sjis_kana(c & 0xff)) {
			/* 半角カナの時 */
				if (dcs_is_hankana_to(dcs)) {
					/* 半角カナ全角変換の時 */
					c = sjis_kana_to_unibe(c & 0xff);
					tc = c;
					tsp = sp;
					EUC_HAN_TO_ZEN(dcs, c, sp, ep, is_to_sjis2004(dcs));
					unibe_to_sjis_short_sp(dcs, dp, c, sp - 2, bytes);
					if (bytes == 1 && *dp == NO_CHAR) {
						c = _f_han_to_zen(tc);
						unibe_to_sjis_short_sp(dcs, dp, c, sp - 2, bytes);
						dp += bytes;
						sp = tsp;		// 濁点から
					} else {
						dp += bytes;
					}
					continue;
				}
			}
			euc_to_sjis_long_sp(dcs, dp, c, tp, bytes);
			if (!dcs_is_suppress(dcs) || !is_sjis_no_char(dp)) {
				dp += bytes;
			}
		} else if (c == 0x8f) {				/* EUC３バイト第１バイト */
			if (sp + 2 > ep) {
				sts = DCS_EUEXPEOD;
				break;
			}
			c = (0x8f0000 | char_to_short(sp));
			euc_to_sjis_long_sp(dcs, dp, c, tp, bytes);
			if (!dcs_is_suppress(dcs) || !is_sjis_no_char(dp)) {
				dp += bytes;
			}
			sp += 2;
		} else {
			cnvln_stype_to_sjis(dp, c, sp, ep, ltype, euc);
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
