/*
 * _eucto_unibe.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include <ctype.h>
#include "_dcs.h"

int _eucto_unibe(Dcs *dcs, bool is_bom, int utf_type) {
	int c, bytes, tsts, sts = DCS_SUCCESS;
	const unsigned char *tp, *sp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	if (utf_type == _UTYPE_FROM_OTHER_TO_OTHER) {
		if (is_bom) {
			*dp++ = UTF16_B0;
			*dp++ = UTF16_B1;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNIBE_OFFSET, sts);
			if (sp >= ep) {
				break;
			}
			tp = sp;
			if ((c = (*sp++ & 0xff)) >= 0xa1 || c == 0x8e) {
				if (sp >= ep) {
					sts = DCS_EUEXPEOD;
					break;
				}
				c = ((c<<8)|(*sp++ & 0xff));
				if ((c & 0xff00) == 0x8e00 && is_sjis_kana(c & 0xff)) {
				/* 半角カナの時 */
					if (dcs_is_hankana_to(dcs)) {
						/* 半角カナ全角変換の時 */
						c = sjis_kana_to_unibe(c & 0xff);
						EUC_HAN_TO_ZEN(dcs, c, sp, ep, true);
						*dp++ = (c>>8);
						*dp++ = c;
						continue;
					}
				}
				euc_to_unibe_long_sp(dcs, dp, c, tp, bytes);
				if (!dcs_is_suppress(dcs) || !is_unibe_no_char(dp)) {
					dp += bytes;
				}
			} else if (c == 0x8f) {				/* EUC３バイト第１バイト */
				if (sp + 2 > ep) {
					sts = DCS_EUEXPEOD;
					break;
				}
				c = (0x8f0000 | char_to_short(sp));
				euc_to_unibe_long_sp(dcs, dp, c, tp, bytes);
				if (!dcs_is_suppress(dcs) || !is_unibe_no_char(dp)) {
					dp += bytes;
				}
				sp += 2;
			} else {
				cnvln_stype_to_unibe(dp, c, sp, ep, ltype, euc);
			}
		}
	} else if (utf_type == _UTYPE_FROM_OTHER_TO_UTF32) {
		if (is_bom) {
			*dp++ = 0;
			*dp++ = 0;
			*dp++ = UTF16_B0;
			*dp++ = UTF16_B1;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNIBE_OFFSET, sts);
			if (sp >= ep) {
				break;
			}
			tp = sp;
			if ((c = (*sp++ & 0xff)) >= 0xa1 || c == 0x8e) {
				if (sp >= ep) {
					sts = DCS_EUEXPEOD;
					break;
				}
				c = ((c<<8)|(*sp++ & 0xff));
				if ((c & 0xff00) == 0x8e00 && is_sjis_kana(c & 0xff)) {
				/* 半角カナの時 */
					if (dcs_is_hankana_to(dcs)) {
						/* 半角カナ全角変換の時 */
						c = sjis_kana_to_unibe(c & 0xff);
						EUC_HAN_TO_ZEN(dcs, c, sp, ep, true);
						*dp++ = 0;
						*dp++ = 0;
						*dp++ = (c>>8);
						*dp++ = c;
						continue;
					}
				}
				euc_to_uni32be_long_sp(dcs, dp, c, tp);
				if (!dcs_is_suppress(dcs) || !is_unibe_no_char(dp)) {
					dp += 4;
				}
			} else if (c == 0x8f) {				/* EUC３バイト第１バイト */
				if (sp + 2 > ep) {
					sts = DCS_EUEXPEOD;
					break;
				}
				c = (0x8f0000 | char_to_short(sp));
				/* EUCコード(24bit)からUnicode(32BE)への変換 */
				euc_to_uni32be_long_sp(dcs, dp, c, tp);
				if (!dcs_is_suppress(dcs) || !is_unibe_no_char(dp)) {
					dp += 4;
				}
				sp += 2;
			} else {
				cnvln_stype_to_uni32be(dp, c, sp, ep, ltype, euc);
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
