/*
 * _jisto_jis.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _jisto_jis(Dcs *dcs) {
	int c, tc, tsts, sts = DCS_SUCCESS;
	int flag_sshift = STYPE_ASCII;
	int flag_dshift = STYPE_ASCII;
	unsigned short ch, ch2;
	const unsigned char *tp, *tsp, *sp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	for(;;) {
		/* 残りが最大長に満たない時、次の入力バッファに移動 */
		check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
		/* 出力バッファ・サイズを超える時、ライター出力 */
		check_info_buf_goto(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts, loop_end);
		if (sp >= ep) {
			break;
		}
		tp = sp;
		if ((c = *sp++) == _ESC_CHAR) {	/* エスケープ(0x1b) */
			if (sp + 2 > ep) {
				*dp++ = _ESC_CHAR;
				if (sp < ep) {
					*dp++ = *sp++;
					if (sp < ep) {
						*dp++ = *sp++;
					}
				}
				goto loop_end;
			}
			if ((c = *sp++) == '$') {       /* JIS漢字SHIFT IN */
				switch(c = *sp++) {
				case 'J':	/* 78JIS??? */
				case '@':	/* 78JIS */
				case 'B':	/* 83JIS */
					if (is_jis50221_to(dcs)) {
						set_jis5022101_to(dcs);
					} else {
						set_jis2022jp_to(dcs);
					}
					flag_sshift = STYPE_X0208_1983;
					break;
				case '(':	/* JIS X 0213 */
					if (sp + 1 > ep) {
						*dp++ = _ESC_CHAR;
						*dp++ = '$';
						*dp++ = '(';
						goto loop_end;
					} else {
						switch(c = *sp++) {
						case 'D': /* 補助漢字 */
							set_jis5022102_to(dcs);
							flag_sshift = STYPE_X0212;
							break;
						case 'Q': /* JIS X 0213:2004 第1面 */
							set_jis2022jp200401_to(dcs);
							flag_sshift = STYPE_X0213_2004;
							break;
						case 'O': /* JIS X 0213:2000 第1面 */
							set_jis2022jp301_to(dcs);
							flag_sshift = STYPE_X0213_2000_1;
							break;
						case 'P': /* 第2面 */
							if (is_jis2022jp2004_to(dcs)) {
								set_jis2022jp200402_to(dcs);
							} else {
								set_jis2022jp302_to(dcs);
							}
							flag_sshift = STYPE_X0213_2000_2;
							break;
						default:
							sp--;
							*dp++ = _ESC_CHAR;
							*dp++ = '$';
							*dp++ = '(';
							break;
						}
					}
					break;
				default:
					sp--;
					*dp++ = _ESC_CHAR;
					*dp++ = '$';
					break;
				}
			} else if (c == '(') {  /* JIS漢字SHIFT OUT */
				switch(c = *sp++) {
				case 'J':	/* JISローマ字 */
				case 'H':	/* JISローマ字 */
				case 'B':	/* ASCII */
					flag_sshift = STYPE_ASCII;
					break;
				case 'I':	/* JIS半角カナ */
					flag_sshift = STYPE_KANA;
					break;
				default:
					sp--;
					*dp++ = _ESC_CHAR;
					*dp++ = '(';
					break;
				}
			} else {
				sp--;
				*dp++ = _ESC_CHAR;
				break;
			}
		} else { /* if ((c = *sp++) == _ESC_CHAR) */
			switch(flag_sshift) {
			case STYPE_X0212:
			case STYPE_X0208_1983:
			case STYPE_X0213_2000_1:
			case STYPE_X0213_2004:
			case STYPE_X0213_2000_2:
				for(;;) {
					/* 残りが最大長に満たない時、次の入力バッファに移動 */
					check_ll_buf(dcs, sp, ep, 2, clist, tlist, binfo, tbinfo);
					/* 出力バッファ・サイズを超える時、ライター出力 */
					check_info_buf_goto(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts, loop_end);
					if (sp >= ep) {
						sts = DCS_EUEXPEOD;
						goto loop_end;
					} else {
						c = ((c<<8)|(*sp++ & 0xff));
						jis_to_unibe_short_sp(dcs, dp, c, tp);
						ch = (unsigned short)unibe_char_to_short(dp);
						if (ch == NO_CHAR) {
						/* 不正文字の時 */
							*dp = NO_CHAR1;
							*(dp + 1) = NO_CHAR2;
							set_no_char_jis(dcs, dp, ch, sp - 2);
							if (!dcs_is_suppress(dcs)) {
								/* flag_dshift が STYPE_X0208_1983 でなければシフトコードを出力 */
								_check_jis_to_zen(dp, flag_dshift);
								dp += 2;
							}
						} else if (is_unibe_surrogate_high(ch)) {
						/* Unicode(BE)サロゲート・ペア上位ビットの時 */
							ch2 = (unsigned short)unibe_char_to_short(dp + 2);
							/* Unicode(BE)(16bit)からJISコードへの変換 */
							judge_unibe_to_jis_short_sp(dcs, dp, ch, ch2, tp, flag_dshift);
						} else {
							/* JIS to JIS の場合はテーブルは固定 */
							ch2 = (ch >= (dcs)->_unibe2jis_table_size? 0: (dcs)->_unibe2jis_table[ch]);
							if (ch2 == 0 && (dcs)->_unibe2jis_table == (unsigned short *)_unibe2jis2022jp2004_table) {
								ch2 = (ch >= (dcs)->_unibe2jis_table_srg_size[2]? 0: (dcs)->_unibe2jis_table_srg[2][ch]);
							}
							/* 変換 JIS コード・チェック */
							_check_conv_jis_sp(dcs, dp, ch2, ch, tp, flag_dshift);
						}
					}
					if (sp >= ep) {
						goto loop_end;
					} else if ((c = *sp++) == _ESC_CHAR) {
						sp--;
						break;
					}
					tp = sp - 1;
				}
				break;
			case STYPE_KANA:
				for(;;) {
					/* 残りが最大長に満たない時、次の入力バッファに移動 */
					check_ll_buf(dcs, sp, ep, 1, clist, tlist, binfo, tbinfo);
					/* 出力バッファ・サイズを超える時、ライター出力 */
					check_info_buf_goto(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts, loop_end);
					if (is_jis_kana(c) == 0) {
						set_no_char_unibe(dcs, dp, c, sp-1);
						if (!dcs_is_suppress(dcs)) {
							*dp++ = NO_CHAR;
						}
					} else if (dcs_is_hankana_to(dcs)) {
						/* 半角カナ全角変換の時 */
						*dp++ = _ESC_CHAR;		/* エスケープ(0x1b) */ \
						*dp++ = '$';			/* JISシフトIN */ \
						*dp++ = 'B';			/* 83JIS */ \
						flag_dshift = STYPE_X0208_1983;	/* シフトIN */ \
						c = jis_kana_to_unibe(c);
						tc = c;
						tsp = sp;
						JIS_HAN_TO_ZEN(dcs, c, sp, ep, is_to_jis2022jp2004(dcs) || is_to_jis2022jp3(dcs));
						unibe_to_jis_short_sp(dcs, dp, c, tp);
						if (*dp == NO_CHAR1 && *(dp + 1) == NO_CHAR2) {
							c = _f_han_to_zen(tc);
							unibe_to_jis_short_sp(dcs, dp, c, sp - 2);
							dp += 2;
							sp = tsp;		// 濁点から
						} else {
							(dp) += 2;
						}
					} else {
						/* JIS シフト 半角かな */
						_check_jis_to_kana(dp, flag_dshift);
						*dp++ = c;
					}
					if (sp >= ep) {
						goto loop_end;
					} else if (*sp == _ESC_CHAR) {
						break;
					}
					c = *sp++;
				}
				break;
			case STYPE_ASCII:
			default:
				for (;;) {
					/* 残りが最大長に満たない時、次の入力バッファに移動 */
					check_ll_buf(dcs, sp, ep, 2, clist, tlist, binfo, tbinfo);
					/* 出力バッファ・サイズを超える時、ライター出力 */
					check_info_buf_goto(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts, loop_end);
					/* JIS シフト ASCII */
					_check_jis_to_ascii(dp, flag_dshift);
					if (c > _JIS_ROMAN_MAX) {
						if (!dcs_is_suppress(dcs)) {
							*dp++ = NO_CHAR;
						}
					} else if (c != _SO_CHAR) {
						cnvln_stype_to_jis(dp, c, sp, ep, ltype, jis);
					} else {		/* JIS半角カナ SHIFT OUT */
						for(;;) {
							/* 残りが最大長に満たない時、次の入力バッファに移動 */
							check_ll_buf(dcs, sp, ep, 1, clist, tlist, binfo, tbinfo);
							/* 出力バッファ・サイズを超える時、ライター出力 */
							check_info_buf_goto(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts, loop_end);
							if (sp >= ep) {
								goto loop_end;
							} else if ((c = *sp++) == _SI_CHAR) {	/* JIS半角カナ SHIFT IN */
								break;
							} else if (is_jis_kana(c) == 0) {
								if (!dcs_is_suppress(dcs)) {
									*dp++ = NO_CHAR;
								}
								break;
							} else if (dcs_is_hankana_to(dcs)) {
								/* 半角カナ全角変換の時 */
								*dp++ = _ESC_CHAR;		/* エスケープ(0x1b) */ \
								*dp++ = '$';			/* JISシフトIN */ \
								*dp++ = 'B';			/* 83JIS */ \
								flag_dshift = STYPE_X0208_1983;	/* シフトIN */ \
								c = jis_kana_to_unibe(c);
								tc = c;
								tsp = sp;
								JIS_HAN_TO_ZEN(dcs, c, sp, ep, is_to_jis2022jp2004(dcs) || is_to_jis2022jp3(dcs));
								unibe_to_jis_short_sp(dcs, dp, c, tp);
								if (*dp == NO_CHAR1 && *(dp + 1) == NO_CHAR2) {
									c = _f_han_to_zen(tc);
									unibe_to_jis_short_sp(dcs, dp, c, sp - 2);
									dp += 2;
									sp = tsp;		// 濁点から
								} else {
									(dp) += 2;
								}
							} else {
								*dp++ = c;
							}
						}
					}
					if (sp >= ep) {
						goto loop_end;
					} else if (*sp == _ESC_CHAR) {
						break;
					}
					c = *sp++;
				}
				break;
			}
		} /* if ((c = *sp++) == _ESC_CHAR) */
	}
loop_end:

	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		if (flag_dshift != STYPE_ASCII) {
			*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
			*dp++ = ('(');			/* JISSHIFT OUT */
			*dp++ = (_SHIFT_OUT);	/* ローマ字 */
		}
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
