/*
 * _sjisto_jis.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _sjisto_jis(Dcs *dcs) {
	int tsts, sts = DCS_SUCCESS;
	int flag_shift = STYPE_ASCII;
	int c, tc, bytes, res;
	const unsigned char *tp, *sp, *tsp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	for(;;) {
		/* 残りが最大長に満たない時、次の入力バッファに移動 */
		check_ll_buf(dcs, sp, ep, 2, clist, tlist, binfo, tbinfo);
		/* 出力バッファ・サイズを超える時、ライター出力 */
		check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts);
		if (sp >= ep) {
			break;
		}
		tp = sp;
		c = (*sp++ & 0xff);
		if ((c & 0x80) == 0) {
			if (flag_shift != STYPE_ASCII) {
				*dp++ = (_ESC_CHAR);			/* エスケープ(0x1b) */
				*dp++ = ('(');				/* JISSHIFT OUT */
				*dp++ = (_SHIFT_OUT);		/* ローマ字 */
				flag_shift = STYPE_ASCII;	/* SHIFT OUT */
			}
			cnvln_stype_to_jis(dp, c, sp, ep, ltype, sjis);
		} else if (is_sjis_kana(c)) {
			if (dcs_is_hankana_to(dcs)) {
				/* 半角カナ全角変換の時 */
				c = sjis_kana_to_unibe(c);
				tc = c;
				tsp = sp;
				SJIS_HAN_TO_ZEN(dcs, c, sp, ep, is_to_jis2022jp2004(dcs) || is_to_jis2022jp3(dcs));
				unibe_to_sjis_short_sp(dcs, dp, c, tp, bytes);
				if (bytes == 1 && *dp == NO_CHAR) {
					c = _f_han_to_zen(tc);
					unibe_to_sjis_short_sp(dcs, dp, c, tp, bytes);
					sp = tsp;		// 濁点から
				}
				c = (*dp<<8|(*(dp+1)&0xff));
				judge_sjis_to_jis_short_sp(dcs, dp, c, res, tp, flag_shift);
			} else {
				if (flag_shift != STYPE_KANA) {
					*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
					*dp++ = ('(');			/* JISSHIFT OUT */
					*dp++ = ('I');			/* JIS半角カナ */
					flag_shift = STYPE_KANA;
				}
				*dp++ = (sjis_kana_to_jis(c));
			}
		} else if (sp >= ep) {
			/* 行の途中で切れている */
			sts = DCS_EUEXPEOD;
			break;
		} else {
			c = ((c<<8)|(*sp++ & 0xff));
			/* 第４引数 c はエラー時に judge_unibe_to_jis_short_sp で処理する */
			/* SJISコード（文字列）からJISコードへの変換 */
			judge_sjis_to_jis_short_sp(dcs, dp, c, res, tp, flag_shift);
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		if (flag_shift != STYPE_ASCII) {
			*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
			*dp++ = ('(');			/* JISSHIFT OUT */
			*dp++ = (_SHIFT_OUT);	/* ローマ字 */
		}
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
