/*
 * _sjisto_euc.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _sjisto_sjis(Dcs *dcs) {
	int tsts, sts = DCS_SUCCESS;
	int c, tc, bytes;
	const unsigned char *sp, *tsp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	for(;;) {
		/* 残りが最大長に満たない時、次の入力バッファに移動 */
		check_ll_buf(dcs, sp, ep, 2, clist, tlist, binfo, tbinfo);
		/* 出力バッファ・サイズを超える時、ライター出力 */
		check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_SJIS_OFFSET, sts);
		if (sp >= ep) {
			break;
		}
		c = (*sp++ & 0xff);
		if ((c & 0x80) == 0) {
			cnvln_stype_to_euc(dp, c, sp, ep, ltype, sjis);
		} else if (is_sjis_kana(c)) {
			if (dcs_is_hankana_to(dcs)) {
			/* 半角カナ全角変換の時 */
				c = sjis_kana_to_unibe(c);
				tc = c;
				tsp = sp;
				SJIS_HAN_TO_ZEN(dcs, c, sp, ep, is_to_sjis2004(dcs));
				unibe_to_sjis_short_sp(dcs, dp, c, tsp - 1, bytes);
				if (bytes == 1 && *dp == NO_CHAR) {
					c = _f_han_to_zen(tc);
					unibe_to_sjis_short_sp(dcs, dp, c, tsp - 1, bytes);
					sp = tsp;		// 濁点から
				}
				dp += bytes;
			} else {
				*dp++ = c;
			}
		} else if (sp >= ep) {
			/* 行の途中で切れている */
			sts = DCS_EUEXPEOD;
			break;
		} else {
			*dp++ = c;
			*dp++ = *sp++;
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
