/*
 * _sjisto_unibe.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _sjisto_unibe(Dcs *dcs, bool is_bom, int utf_type) {
	int c, bytes, tsts, sts = DCS_SUCCESS;
	const unsigned char *tp, *sp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	if (utf_type == _UTYPE_FROM_OTHER_TO_OTHER) {
		if (is_bom) {
			*dp++ = UTF16_B0;
			*dp++ = UTF16_B1;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNIBE_OFFSET, sts);
			if (sp >= ep) {
				break;
			}
			tp = sp;
			c = (*sp++ & 0xff);
			if ((c & 0x80) == 0) {
				cnvln_stype_to_unibe(dp, c, sp, ep, ltype, sjis);
			} else if (is_sjis_kana(c)) {
				sjis_to_unibe_long_sp(dcs, dp, c, tp, bytes);
				c = ((*dp<<8)|*(dp + 1));
				SJIS_HAN_TO_ZEN(dcs, c, sp, ep, true);
				*dp++ = (c>>8);
				*dp++ = c;
			} else if (sp >= ep) {
				/* 行の途中で切れている */
				sts = DCS_EUEXPEOD;
				break;
			} else {
				c = ((c << 8)|(*sp++ & 0xff));
				sjis_to_unibe_long_sp(dcs, dp, c, tp, bytes);
				if (!dcs_is_suppress(dcs) || !is_unibe_no_char(dp)) {
					dp += bytes;
				}
			}
		}
	} else if (utf_type == _UTYPE_FROM_OTHER_TO_UTF32) {
		if (is_bom) {
			*dp++ = 0;
			*dp++ = 0;
			*dp++ = UTF16_B0;
			*dp++ = UTF16_B1;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNIBE_OFFSET, sts);
			if (sp >= ep) {
				break;
			}
			tp = sp;
			c = (*sp++ & 0xff);
			if ((c & 0x80) == 0) {
				cnvln_stype_to_uni32be(dp, c, sp, ep, ltype, sjis);
			} else if (is_sjis_kana(c)) {
				sjis_to_uni32be_long_sp(dcs, dp, c, tp);
				c = ((*(dp + 2)<<8)|*(dp + 3));
				SJIS_HAN_TO_ZEN(dcs, c, sp, ep, true);
				*dp++ = 0;
				*dp++ = 0;
				*dp++ = (c>>8);
				*dp++ = c;
			} else if (sp >= ep) {
				/* 行の途中で切れている */
				sts = DCS_EUEXPEOD;
				break;
			} else {
				c = ((c << 8)|(*sp++ & 0xff));
				/* SJISコードからUnicode(32BE)への変換 */
				sjis_to_uni32be_long_sp(dcs, dp, c, tp);
				if (!dcs_is_suppress(dcs) || !is_uni32be_no_char(dp)) {
					dp += 4;
				}
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
