/*
 * _unibeto_unile.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _unibeto_unile(Dcs *dcs, bool is_bom, int utf_type) {
	int c, c2, tsts, sts = DCS_SUCCESS;
	const unsigned char *sp, *tp, *ep;
	unsigned char *dbuf, *dp;
	unsigned short hcd, lcd;
	unsigned long scd, dcd;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	if (utf_type == _UTYPE_FROM_OTHER_TO_OTHER) {
		if (is_bom) {
			*dp++ = UTF16_B1;
			*dp++ = UTF16_B0;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNILE_OFFSET, sts);
			if (sp + 1 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			c = char_to_short(sp);
			tp = sp;
			sp += 2;
			if ((c & ~0x7f) == 0) {
				cnvln_stype_to_unile(dp, c, sp, ep, ltype, unibe);
			} else if (is_illegal_surrogate_hi(c)) {
			/* サロゲートペア上位不正コードの時 */
				*dp = NO_CHAR;
				*(dp + 1) = 0;
				set_no_char_unile(dcs, dp, c, sp - 2);
				if (!dcs_is_suppress(dcs)) {
					dp += 2;
				}
			} else {
				UTF16BE_NFD_TO_NFC(dcs, c, sp, ep);
				if (sp - tp <= 2) {
				/* NFD to NFC 変換が無かった時 */
					UTF16BE_HAN_TO_ZEN(dcs, c, sp, ep, true);
				}
				*dp++ = c;
				*dp++ = (c>>8);
			}
		}
	} else if (utf_type == _UTYPE_FROM_UTF32_TO_OTHER) {
		if (is_bom) {
			*dp++ = UTF16_B1;
			*dp++ = UTF16_B0;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNILE_OFFSET, sts);
			if (sp + 3 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			scd = unibe_char_to_long(sp);
			tp = sp;
			sp += 4;
			if (scd < 0x10000) {
			/* UTF16 値の時 */
				if ((scd & ~0x7f) == 0) {
					cnvln_stype_to_unile(dp, scd, sp, ep, ltype, uni32be);
				} else {
					UTF32BE_NFD_TO_NFC(dcs, scd, sp, ep);
					if (sp - tp <= 4) {
					/* NFD to NFC 変換が無かった時 */
						UTF32BE_HAN_TO_ZEN(dcs, scd, sp, ep, true);
					}
					*dp++ = scd;
					*dp++ = (scd>>8);
				}
			} else {
			/* UTF32 値の時 */
				/* Unicode(BE)サロゲート・コードからペアへの変換 */
				surrogate_cd_to_unibe(hcd, lcd, scd);
				if (is_illegal_surrogate_hi(scd)) {
				/* サロゲートペア上位不正コードの時 */
					*dp = NO_CHAR;
					*(dp + 1) = 0;
					set_no_char_unile(dcs, dp, hcd, sp - 4);
					if (!dcs_is_suppress(dcs)) {
						dp += 2;
					}
				} else {
					*dp++ = hcd;
					*dp++ = (hcd>>8);
					*dp++ = lcd;
					*dp++ = (lcd>>8);
				}
			}
		}
	} else if (utf_type == _UTYPE_FROM_OTHER_TO_UTF32) {
		if (is_bom) {
			*dp++ = UTF16_B1;
			*dp++ = UTF16_B0;
			/* TO UTF32-LE */
			*dp++ = 0;
			*dp++ = 0;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNILE_OFFSET, sts);
			if (sp + 1 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			c = char_to_short(sp);
			tp = sp;
			sp += 2;
			if ((c & ~0x7f) == 0) {
				cnvln_stype_to_uni32le(dp, c, sp, ep, ltype, unibe);
			/* Unicode(BE)サロゲート・ペア上位ビットの判定 */
			} else if (is_unibe_surrogate_high(c)) {
				if ((sp + 1) >= ep) {
					sts = DCS_EUEXPEOD;
					break;
				}
				c2 = char_to_short(sp);
				/* Unicode(BE)サロゲート・ペア下位ビットの判定 */
				if (is_unibe_surrogate_low(c2)) {
					/* Unicode(BE)サロゲート・ペアからコードへの変換 */
					unibe_surrogate_to_cd(dcd, c, c2);
					*dp++ = dcd;
					*dp++ = (dcd>>8);
					*dp++ = (dcd>>16);
					*dp++ = (dcd>>24);
					sp += 2;
				} else {
					*dp = NO_CHAR;
					*(dp + 1) = 0;
					set_no_char_unile(dcs, dp, c, sp - 2);
					if (!dcs_is_suppress(dcs)) {
						dp += 2;
						*dp++ = 0;
						*dp++ = 0;
					}
				}
			} else {
				UTF16BE_NFD_TO_NFC(dcs, c, sp, ep);
				if (sp - tp <= 2) {
				/* NFD to NFC 変換が無かった時 */
					UTF16BE_HAN_TO_ZEN(dcs, c, sp, ep, true);
				}
				*dp++ = c;
				*dp++ = (c>>8);
				*dp++ = 0;
				*dp++ = 0;
			}
		}
	} else if (utf_type == _UTYPE_FROM_UTF32_TO_UTF32) {
		if (is_bom) {
			*dp++ = UTF16_B1;
			*dp++ = UTF16_B0;
			/* TO UTF32-LE */
			*dp++ = 0;
			*dp++ = 0;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNILE_OFFSET, sts);
			if (sp + 3 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			scd = unibe_char_to_long(sp);
			tp = sp;
			sp += 4;
			if (scd < 0x10000) {
			/* UTF16 値の時 */
				if ((scd & ~0x7f) == 0) {
					cnvln_stype_to_uni32le(dp, scd, sp, ep, ltype, uni32be);
				} else {
					UTF32BE_NFD_TO_NFC(dcs, scd, sp, ep);
					if (sp - tp <= 4) {
					/* NFD to NFC 変換が無かった時 */
						UTF32BE_HAN_TO_ZEN(dcs, scd, sp, ep, true);
					}
					*dp++ = scd;
					*dp++ = (scd>>8);
					*dp++ = 0;
					*dp++ = 0;
				}
			} else {
			/* UTF32 値の時 */
				*dp++ = scd;
				*dp++ = (scd>>8);
				*dp++ = (scd>>16);
				*dp++ = (scd>>24);
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
