/*
 * _unileto_jis.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _unileto_jis(Dcs *dcs, int utf_type) {
	int tsts, sts = DCS_SUCCESS;
	int flag_shift = STYPE_ASCII;			/* SHIFT OUT */
	int c, c2, tc;
	const unsigned char *sp, *tp, *tsp, *ep;
	unsigned char *dbuf, *dp;
	unsigned short hcd, lcd;
	unsigned long scd, scd2;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	if (utf_type == _UTYPE_FROM_OTHER_TO_OTHER) {
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts);
			if (sp + 1 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			c = unile_to_unibe_char(sp);
			tp = sp;
			sp += 2;
			if ((c & ~0x7f) == 0 || c == _UYEN) {
			/* ASCII の時 */
				if (c == _UYEN) {
					c = '\\';
				}
				if (flag_shift != STYPE_ASCII) {
					*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
					*dp++ = ('(');			/* JISSHIFT OUT */
					*dp++ = (_SHIFT_OUT);			/* ローマ字 */
					flag_shift = STYPE_ASCII;	/* SHIFT OUT */
				}
				cnvln_stype_to_jis(dp, c, sp, ep, ltype, unile);
			} else if (is_unibe_kana(c)) {
			/* 半角カナの時 */
				if (dcs_is_hankana_to(dcs)) {
				/* 半角カナ全角変換の時 */
					tc = c;
					tsp = sp;
					UTF16LE_HAN_TO_ZEN(dcs, c, sp, ep, is_to_jis2022jp2004(dcs) || is_to_jis2022jp3(dcs));
					judge_unibe_to_jis_short_sp(dcs, dp, c, c, tp, flag_shift);
					if (*(dp - 2) == NO_CHAR1 && *(dp - 1) == NO_CHAR2) {
						c = _f_han_to_zen(tc);
						unibe_to_jis_short_sp(dcs, dp-2, c, sp - 2);
						sp = tsp;		// 濁点から
					}
				} else {
					if (flag_shift != STYPE_KANA) {
						*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
						*dp++ = ('(');			/* JISSHIFT OUT */
						*dp++ = ('I');			/* JIS半角カナ */
						flag_shift = STYPE_KANA;
					}
					*dp++ = unibe_kana_to_jis(c);
				}
			} else if (((c>>8)&0xff) == _ZEN_TILDE_0 && (c&0xff) == _ZEN_TILDE_1) {
			/* 全角'~'の時 */
				if (flag_shift != STYPE_ASCII) {
					*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
					*dp++ = ('(');			/* JISSHIFT OUT */
					*dp++ = (_SHIFT_OUT);		/* ローマ字 */
					flag_shift = STYPE_ASCII;	/* SHIFT OUT */
				}
				*dp++ = '~';
			} else {
			/* 全角の時 */
				UTF16LE_NFD_TO_NFC(dcs, c, sp, ep);
				c2 = (sp + 2 > ep? 0: unile_to_unibe_char(sp));
				/* Unicode(BE)(16bit)からJISコードへの変換 */
				judge_unibe_to_jis_short_sp(dcs, dp, c, c2, sp-2, flag_shift);
				if (c2 < 0) {
				// サロゲートペアを処理した時
					sp += 2;
				}
			}
		}
	} else if (utf_type == _UTYPE_FROM_UTF32_TO_OTHER) {
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts);
			if (sp + 3 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			scd = utf32le_to_utf32be_char(sp);
			tp = sp;
			sp += 4;
			if ((scd>>16) == 0) {
			/* UTF16 値の時 */
				if ((scd & ~0x7f) == 0 || scd == _UYEN) {
				/* ASCII の時 */
					if (scd == _UYEN) {
						scd = '\\';
					}
					if (flag_shift != STYPE_ASCII) {
						*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
						*dp++ = ('(');			/* JISSHIFT OUT */
						*dp++ = (_SHIFT_OUT);			/* ローマ字 */
						flag_shift = STYPE_ASCII;	/* SHIFT OUT */
					}
					cnvln_stype_to_jis(dp, scd, sp, ep, ltype, uni32le);
				} else if (is_unibe_kana(scd)) {
				/* 半角カナの時 */
					if (dcs_is_hankana_to(dcs)) {
					/* 半角カナ全角変換の時 */
						scd2 = scd;
						tsp = sp;
						UTF32LE_HAN_TO_ZEN(dcs, scd, sp, ep, is_to_jis2022jp2004(dcs) || is_to_jis2022jp3(dcs));
						judge_unibe_to_jis_short_sp(dcs, dp, scd, scd, tp, flag_shift);
						if (*(dp - 2) == NO_CHAR1 && *(dp - 1) == NO_CHAR2) {
							scd = _f_han_to_zen(scd2);
							unibe_to_jis_short_sp(dcs, dp - 2, scd, sp - 2);
							sp = tsp;		// 濁点から
						}
					} else {
						if (flag_shift != STYPE_KANA) {
							*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
							*dp++ = ('(');			/* JISSHIFT OUT */
							*dp++ = ('I');			/* JIS半角カナ */
							flag_shift = STYPE_KANA;
						}
						*dp++ = unibe_kana_to_jis(scd);
					}
				} else if (((scd>>8)&0xff) == _ZEN_TILDE_0 && (scd&0xff) == _ZEN_TILDE_1) {
				/* 全角'~'の時 */
					if (flag_shift != STYPE_ASCII) {
						*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
						*dp++ = ('(');			/* JISSHIFT OUT */
						*dp++ = (_SHIFT_OUT);		/* ローマ字 */
						flag_shift = STYPE_ASCII;	/* SHIFT OUT */
					}
					*dp++ = '~';
				} else if (is_illegal_surrogate_hi(scd)) {
				/* サロゲートペア上位不正コードの時 */
					*dp = NO_CHAR1;
					*(dp + 1) = NO_CHAR2;
					set_no_char_jis(dcs, dp, scd, sp - 4);
					if (!dcs_is_suppress(dcs)) {
						dp += 2;
					}
				} else {
				/* 全角の時 */
					UTF32LE_NFD_TO_NFC(dcs, scd, sp, ep);
					scd2 = (sp + 4 > ep? 0: utf32le_to_utf32be_char(sp));
					/* Unicode(BE)(16bit)からJISコードへの変換 */
					judge_unibe_to_jis_short_sp(dcs, dp, scd, scd2, sp-4, flag_shift);
					if (scd2 < 0) {
					// サロゲートペアを処理した時
						sp += 4;
					}
				}
			} else {
			/* UTF32 値の時 */
				/* Unicode(BE)サロゲート・コードからペアへの変換 */
				surrogate_cd_to_unibe(hcd, lcd, scd);
				/* Unicode(BE)サロゲート・ペアから JIS への変換 */
				unibe_surrogate_to_jis_sp(dcs, dp, hcd, lcd, sp-4, flag_shift);
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		if (flag_shift != STYPE_ASCII) {
			*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
			*dp++ = ('(');			/* JISSHIFT OUT */
			*dp++ = (_SHIFT_OUT);			/* ローマ字 */
		}
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
