/*
 * _unileto_sjis.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _unileto_sjis(Dcs *dcs, int utf_type) {
	int tsts, sts = DCS_SUCCESS;
	int c, c2, bytes;
	const unsigned char *sp, *tsp, *ep;
	unsigned char *dbuf, *dp;
	unsigned short hcd, lcd;
	unsigned long scd, tscd;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	if (utf_type == _UTYPE_FROM_OTHER_TO_OTHER) {
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_SJIS_OFFSET, sts);
			if (sp + 1 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			c = unile_to_unibe_char(sp);
			sp += 2;
			if ((c & ~0x7f) == 0 || c == _UYEN) {
				if (c == _UYEN) {
					c = '\\';
				}
				cnvln_stype_to_sjis(dp, c, sp, ep, ltype, unile);
			} else if (((c>>8)&0xff) == _ZEN_TILDE_0 && (c&0xff) == _ZEN_TILDE_1) {
			/* 全角'~'の時 */
				*dp++ = '~';
			} else if (is_unibe_kana(c)) {
				/* 半角カナの時 */
					if (dcs_is_hankana_to(dcs)) {
						/* 半角カナ全角変換の時 */
						c2 = c;
						tsp = sp;
						UTF16LE_HAN_TO_ZEN(dcs, c, sp, ep, is_to_sjis2004(dcs));
						unibe_to_sjis_short_sp(dcs, dp, c, tsp, bytes);
						if (bytes == 1 && *dp == NO_CHAR) {
							c = _f_han_to_zen(c2);
							unibe_to_sjis_short_sp(dcs, dp, c, sp - 2, bytes);
							dp += bytes;
							sp = tsp;		// 濁点から
						} else {
							dp += bytes;
						}
					} else {
						*dp++ = (unibe_kana_to_sjis(c));
					}
			} else {
				/* Unicode(BE)サロゲート・ペア上位ビットの判定 */
				if (is_unibe_surrogate_high(c)) {
					if ((sp + 1) >= ep) {
						sts = DCS_EUEXPEOD;
						break;
					}
					c2 = unile_to_unibe_char(sp);
					/* Unicode(BE)サロゲート・ペア下位ビットの判定 */
					if (is_unibe_surrogate_low(c2)) {
						/* Unicode(BE)サロゲート・ペアから SJIS への変換 */
						unibe_surrogate_to_sjis_sp(dcs, dp, c, c2, sp - 2);
						sp += 2;
					}
				} else {
					UTF16LE_NFD_TO_NFC(dcs, c, sp, ep);
					unibe_to_sjis_short_sp(dcs, dp, c, sp - 2, bytes);
					if (!dcs_is_suppress(dcs) || !is_sjis_no_char(dp)) {
						dp += bytes;
					}
				}
			}
		}
	} else if (utf_type == _UTYPE_FROM_UTF32_TO_OTHER) {
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_SJIS_OFFSET, sts);
			if (sp + 3 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			scd = utf32le_to_utf32be_char(sp);
			sp += 4;
			if ((scd>>16) == 0) {
			/* UTF16 値の時 */
				if ((scd & ~0x7f) == 0 || scd == _UYEN) {
					if (scd == _UYEN) {
						scd = '\\';
					}
					cnvln_stype_to_sjis(dp, scd, sp, ep, ltype, uni32le);
				} else if (((scd>>8)&0xff) == _ZEN_TILDE_0 && (scd&0xff) == _ZEN_TILDE_1) {
				/* 全角'~'の時 */
					*dp++ = '~';
				} else if (is_unibe_kana(scd)) {
					/* 半角カナの時 */
						if (dcs_is_hankana_to(dcs)) {
							/* 半角カナ全角変換の時 */
							tscd = scd;
							tsp = sp;
							UTF32LE_HAN_TO_ZEN(dcs, scd, sp, ep, is_to_sjis2004(dcs));
							unibe_to_sjis_short_sp(dcs, dp, scd, tsp, bytes);
							if (bytes == 1 && *dp == NO_CHAR) {
								scd = _f_han_to_zen(tscd);
								unibe_to_sjis_short_sp(dcs, dp, scd, sp - 4, bytes);
								dp += bytes;
								sp = tsp;		// 濁点から
							} else {
								dp += bytes;
							}
						} else {
							*dp++ = (unibe_kana_to_sjis(scd));
						}
				} else if (is_illegal_surrogate_hi(scd)) {
				/* サロゲートペア上位不正コードの時 */
					*dp = NO_CHAR;
					set_no_char_ascii(dcs, dp, scd, sp - 4);
					if (!dcs_is_suppress(dcs)) {
						dp++;
					}
				} else {
					UTF32LE_NFD_TO_NFC(dcs, scd, sp, ep);
					unibe_to_sjis_short_sp(dcs, dp, scd, sp - 4, bytes);
					if (!dcs_is_suppress(dcs) || !is_sjis_no_char(dp)) {
						dp += bytes;
					}
				}
			} else {
			/* UTF32 値の時 */
				/* Unicode(BE)サロゲート・コードからペアへの変換 */
				surrogate_cd_to_unibe(hcd, lcd, scd);
				/* Unicode(BE)サロゲート・ペアから SJIS への変換 */
				unibe_surrogate_to_sjis_sp(dcs, dp, hcd, lcd, sp - 4);
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
