/*
 * _unileto_utf8.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _unileto_utf8(Dcs *dcs, bool is_bom, int utf_type) {
	int tsts, sts = DCS_SUCCESS;
	int c, c2, bytes;
	const unsigned char *sp, *tp, *ep;
	unsigned char *dbuf, *dp;
	unsigned short hcd, lcd;
	unsigned long scd;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;

	if (is_bom) {
		*dp++ = UTF8_B0;
		*dp++ = UTF8_B1;
		*dp++ = UTF8_B2;
	}
	if (utf_type == _UTYPE_FROM_OTHER_TO_OTHER) {
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UTF8_OFFSET, sts);
			if (sp + 1 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			c = unile_to_unibe_char(sp);
			tp = sp;
			sp += 2;
			if ((c & ~0x7f) == 0) {
				cnvln_stype_to_utf8(dp, c, sp, ep, ltype, unile);
			/* Unicode(BE)サロゲート・ペア上位ビットの判定 */
			} else if (is_unibe_surrogate_high(c)) {
				if ((sp + 1) >= ep) {
					sts = DCS_EUEXPEOD;
					break;
				}
				c2 = unile_to_unibe_char(sp);
				/* Unicode(BE)サロゲート・ペア下位ビットの判定 */
				if (is_unibe_surrogate_low(c2)) {
					/* Unicode(BE)サロゲート・ペアからUTF-8への変換 */
					unibe_surrogate_to_utf8(dp, c, c2);
					dp += 4;
					sp += 2;
				} else {
					*dp = NO_CHAR;
					set_no_char_utf8(dcs, dp, c, sp - 2);
					if (!dcs_is_suppress(dcs)) {
						dp++;
					}
				}
			} else {
				UTF16LE_NFD_TO_NFC(dcs, c, sp, ep);
				if (sp - tp <= 2) {
				/* NFD to NFC 変換が無かった時 */
					UTF16LE_HAN_TO_ZEN(dcs, c, sp, ep, true);
				}
				unibe_to_utf8_short(dp, c, bytes);
				if (!dcs_is_suppress(dcs) || !is_utf8_no_char(dp)) {
					dp += bytes;
				}
			}
		}
	} else if (utf_type == _UTYPE_FROM_UTF32_TO_OTHER) {
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 4, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UTF8_OFFSET, sts);
			if (sp + 3 >= ep) {
				if (sp < ep) {
					sts = DCS_EUEXPEOD;
				}
				break;
			}
			scd = utf32le_to_utf32be_char(sp);
			tp = sp;
			sp += 4;
			if ((scd>>16) == 0) {
			/* UTF16 値の時 */
				if ((scd & ~0x7f) == 0) {
					cnvln_stype_to_utf8(dp, scd, sp, ep, ltype, uni32le);
				} else if (is_illegal_surrogate_hi(scd)) {
				/* サロゲートペア上位不正コードの時 */
					*dp = NO_CHAR;
					set_no_char_utf8(dcs, dp, scd, sp - 4);
					if (!dcs_is_suppress(dcs)) {
						dp++;
					}
				} else {
					UTF32LE_NFD_TO_NFC(dcs, scd, sp, ep);
					if (sp - tp <= 4) {
					/* NFD to NFC 変換が無かった時 */
						UTF32LE_HAN_TO_ZEN(dcs, scd, sp, ep, true);
					}
					unibe_to_utf8_short(dp, scd, bytes);
					if (!dcs_is_suppress(dcs) || !is_utf8_no_char(dp)) {
						dp += bytes;
					}
				}
			} else {
			/* UTF32 値の時 */
				/* Unicode(BE)サロゲート・コードからペアへの変換 */
				surrogate_cd_to_unibe(hcd, lcd, scd);
				/* Unicode(BE)サロゲート・ペアからUTF-8への変換 */
				unibe_surrogate_to_utf8(dp, hcd, lcd);
				dp += 4;
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
	/* ブレイク時、出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
