/*
 * _utf8to_jis.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _utf8to_jis(Dcs *dcs) {
	int tsts, sts = DCS_SUCCESS;
	int flag_shift = STYPE_ASCII;
	int ecnt;
	int c, c2, c3, c4;
	unsigned short ch, ch2, tch;
	unsigned long lch;
	const unsigned char *sp, *tp, *tsp, *bp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;
	bp = sp;
	ecnt = 0;

	for(;;) {
		/* 残りが最大長に満たない時、次の入力バッファに移動 */
		check_ll_buf(dcs, sp, ep, 6, clist, tlist, binfo, tbinfo);
		/* 出力バッファ・サイズを超える時、ライター出力 */
		check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_JIS_OFFSET, sts);
		if (sp >= ep) {
			break;
		}
		tp = sp;
		c = *sp++;
		if ((c & 0x80) == 0 || c == _UYEN) {
		/* 0xxxxxxx: １バイト文字 */
			if (c == _UYEN) {
				c = '\\';
			}
			if (flag_shift != STYPE_ASCII) {
				*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
				*dp++ = ('(');			/* JISSHIFT OUT */
				*dp++ = (_SHIFT_OUT);			/* ローマ字 */
				flag_shift = STYPE_ASCII;	/* SHIFT OUT */
			}
			cnvln_stype_to_jis(dp, c, sp, ep, ltype, utf8);
		} else if (sp >= ep) {
			sts = DCS_EUEXPEOD;
			break;
		} else {
			c2 = *sp++;
			if ((c & 0xe0) == 0xc0 && (c2 & 0xc0) == 0x80) {
			/* 110xxxxx 10xxxxxx: ２バイト文字 */
				ch = ((c&0x1f)<<6|(c2&0x3f));
				UTF8_NFD_TO_NFC_2BYTES(dcs, ch, sp, ep);
			} else if (sp >= ep) {
				sts = DCS_EUEXPEOD;
				break;
			} else {
				c3 = *sp++;
				if ((c & 0xf0) == 0xe0 && (c2 & 0xc0) == 0x80 && (c3 & 0xc0) == 0x80) {
				/* 1110xxxx 10xxxxxx 10xxxxxx: ３バイト文字 */
					ch = ((c&0x0f)<<12|(c2&0x3f)<<6|(c3&0x3f));
					UTF8_NFD_TO_NFC(dcs, ch, sp, ep);
				} else if (sp >= ep) {
					sts = DCS_EUEXPEOD;
					break;
				} else {
					c4 = *sp++;
					if (((c) & 0xf8) == 0xf0 && ((c2) & 0xc0) == 0x80 && ((c3) & 0xc0) == 0x80 && ((c4) & 0xc0) == 0x80) {
					/* 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx: ４バイト文字 */
						lch = (((c & 07) << 18)|((c2 & 0x3f) << 12)|((c3 & 0x3f) << 6)|(c4 & 0x3f));
						lch -= 0x10000;
						ch = ((lch >> 10)|0xd800);
						ch2 = ((lch & 0x3ff)|0xdc00);
					} else {
						ecnt++;
						sp = tp + 1;
						continue;
					}
				}
			}
			if (!dcs_is_suppress(dcs)) {
				for(; ecnt > 0; ecnt -= 3) {
					/* Unicode(BE)(16bit)からJISコードへの変換 */
					judge_unibe_to_jis_short_sp(dcs, dp, 0, ch2, bp, flag_shift);
					bp += 3;
				}
			}
			bp = sp;
			ecnt = 0;
			if (is_unibe_kana(ch)) {
			/* 半角カナの時 */
				if (dcs_is_hankana_to(dcs)) {
				/* 半角カナ全角変換の時 */
					tch = ch;
					tsp = sp;
					UTF8_HAN_TO_ZEN(dcs, ch, sp, ep, is_to_jis2022jp2004(dcs) || is_to_jis2022jp3(dcs));
					judge_unibe_to_jis_short_sp(dcs, dp, ch, ch, tp, flag_shift);
					if (*(dp - 2) == NO_CHAR1 && *(dp - 1) == NO_CHAR2) {
						ch = _f_han_to_zen(tch);
						unibe_to_jis_short_sp(dcs, dp - 2, ch, sp - 3);
						sp = tsp;		// 濁点から
					}
				} else {
					if (flag_shift != STYPE_KANA) {
						*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
						*dp++ = ('(');			/* JISSHIFT OUT */
						*dp++ = ('I');			/* JIS半角カナ */
						flag_shift = STYPE_KANA;
					}
					*dp++ = (unibe_kana_to_jis(ch));
				}
			} else if (((ch>>8)&0xff) == _ZEN_TILDE_0 && (ch&0xff) == _ZEN_TILDE_1) {
			/* 全角'~'の時 */
				if (flag_shift != STYPE_ASCII) {
					*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
					*dp++ = ('(');			/* JISSHIFT OUT */
					*dp++ = (_SHIFT_OUT);			/* ローマ字 */
					flag_shift = STYPE_ASCII;	/* SHIFT OUT */
				}
				*dp++ = '~';
			} else {
			/* 全角の時 */
				/* Unicode(BE)(16bit)からJISコードへの変換 */
				judge_unibe_to_jis_short_sp(dcs, dp, ch, ch2, tp, flag_shift);
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		if (sts == DCS_EUEXPEOD) {
			judge_unibe_to_jis_short_sp(dcs, dp, 0, ch2, bp, flag_shift);
			sts = DCS_SUCCESS;
		}
		if (flag_shift != STYPE_ASCII) {
			*dp++ = (_ESC_CHAR);		/* エスケープ(0x1b) */
			*dp++ = ('(');			/* JISSHIFT OUT */
			*dp++ = (_SHIFT_OUT);			/* ローマ字 */
		}
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
