/*
 * _utf8to_sjis.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _utf8to_sjis(Dcs *dcs) {
	int tsts, sts = DCS_SUCCESS;
	int ecnt;
	int c, c2, c3, c4, tc, bytes;
	unsigned short ch;
	unsigned long lch;
	unsigned short hcd, lcd;
	const unsigned char *sp, *tp, *tsp, *bp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;
	bp = sp;
	ecnt = 0;

	for(;;) {
		/* 残りが最大長に満たない時、次の入力バッファに移動 */
		check_ll_buf(dcs, sp, ep, 6, clist, tlist, binfo, tbinfo);
		/* 出力バッファ・サイズを超える時、ライター出力 */
		check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_SJIS_OFFSET, sts);
		if (sp >= ep) {
			break;
		}
		tp = sp;
		c = *sp++;
		if ((c & 0x80) == 0) {
		/* 0xxxxxxx: １バイト文字 */
			cnvln_stype_to_sjis(dp, c, sp, ep, ltype, utf8);
		} else if (sp >= ep) {
			sts = DCS_EUEXPEOD;
			break;
		} else {
			c2 = *sp++;
			if ((c & 0xe0) == 0xc0 && (c2 & 0xc0) == 0x80) {
			/* 110xxxxx 10xxxxxx: ２バイト文字 */
				ch = ((c&0x1f)<<6|(c2&0x3f));
				UTF8_NFD_TO_NFC_2BYTES(dcs, ch, sp, ep);
			} else if (sp >= ep) {
				sts = DCS_EUEXPEOD;
				break;
			} else {
				c3 = *sp++;
				if ((c & 0xf0) == 0xe0 && (c2 & 0xc0) == 0x80 && (c3 & 0xc0) == 0x80) {
				/* 1110xxxx 10xxxxxx 10xxxxxx: ３バイト文字 */
					ch = ((c&0x0f)<<12|(c2&0x3f)<<6|(c3&0x3f));
					UTF8_NFD_TO_NFC(dcs, ch, sp, ep);
					if (sp - tp <= 3) {
					/* NFD to NFC 変換が無かった時 */
						UTF8_HAN_TO_ZEN(dcs, ch, sp, ep, is_to_sjis2004(dcs));
					}
				} else if (sp >= ep) {
					sts = DCS_EUEXPEOD;
					break;
				} else {
					c4 = *sp++;
					if (((c) & 0xf8) == 0xf0 && ((c2) & 0xc0) == 0x80 && ((c3) & 0xc0) == 0x80 && ((c4) & 0xc0) == 0x80) {
					/* 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx: ４バイト文字 */
					lch = (((c & 07) << 18)|((c2 & 0x3f) << 12)|((c3 & 0x3f) << 6)|(c4 & 0x3f));
					lch -= 0x10000;
					hcd = ((lch >> 10)|0xd800);
					lcd = ((lch & 0x3ff)|0xdc00);
					/* Unicode(BE)サロゲート・ペアから EUC への変換 */
					unibe_surrogate_to_sjis_sp(dcs, dp, hcd, lcd, sp - 4);
					} else {
						ecnt++;
						sp = tp + 1;
					}
					continue;
				}
			}
			if (!dcs_is_suppress(dcs)) {
				for(; ecnt > 0; ecnt -= 3) {
					unibe_to_sjis_short_sp(dcs, dp, 0, bp, bytes);
					dp += bytes;
					bp += 3;
				}
			}
			bp = sp;
			ecnt = 0;
			if (is_unibe_kana(ch)) {
			/* 半角カナの時 */
				if (dcs_is_hankana_to(dcs)) {
					/* 半角カナ全角変換の時 */
					tc = ch;
					tsp = sp;
					UTF8_HAN_TO_ZEN(dcs, ch, sp, ep, is_to_sjis2004(dcs));
					unibe_to_sjis_short_sp(dcs, dp, ch, tp, bytes);
					if (bytes == 1 && *dp == NO_CHAR) {
						c = _f_han_to_zen(tc);
						unibe_to_sjis_short_sp(dcs, dp, c, sp - 3, bytes);
						dp += bytes;
						sp = tsp;		// 濁点から
					} else {
						dp += bytes;
					}
				} else {
					*dp++ = (unibe_kana_to_sjis(ch));
				}
			} else if (((ch>>8)&0xff) == _ZEN_TILDE_0 && (ch&0xff) == _ZEN_TILDE_1) {
			/* 全角'~'の時 */
				*dp++ = '~';
			} else {
			/* 全角の時 */
				unibe_to_sjis_short_sp(dcs, dp, ch, tp, bytes);
				if (!dcs_is_suppress(dcs) || !is_sjis_no_char(dp)) {
					dp += bytes;
				}
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		if (sts == DCS_EUEXPEOD) {
			if (!dcs_is_suppress(dcs)) {
				unibe_to_sjis_short_sp(dcs, dp, 0, bp, bytes);
				dp += bytes;
			}
			sts = DCS_SUCCESS;
		}
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
