/*
 * _utf8to_unibe.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _utf8to_unibe(Dcs *dcs, bool is_bom, int utf_type) {
	int tsts, sts = DCS_SUCCESS;
	int ecnt;
	int c, c2, c3, c4;
	unsigned short ch, hi;
	unsigned long lch;
	const unsigned char *sp, *tp, *bp, *ep;
	unsigned char *dbuf, *dp;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;
	bp = sp;
	ecnt = 0;

	if (utf_type == _UTYPE_FROM_OTHER_TO_OTHER) {
		if (is_bom) {
			*dp++ = UTF16_B0;
			*dp++ = UTF16_B1;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 6, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNIBE_OFFSET, sts);
			if (sp >= ep) {
				break;
			}
			tp = sp;
			c = *sp++;
			if ((c & 0x80) == 0) {
			/* 0xxxxxxx: １バイト文字 */
				cnvln_stype_to_unibe(dp, c, sp, ep, ltype, utf8);
			} else if (sp >= ep) {
				sts = DCS_EUEXPEOD;
				break;
			} else {
				c2 = *sp++;
				if ((c & 0xe0) == 0xc0 && (c2 & 0xc0) == 0x80) {
				/* 110xxxxx 10xxxxxx: ２バイト文字 */
					ch = ((c&0x1f)<<6|(c2&0x3f));
					UTF8_NFD_TO_NFC_2BYTES(dcs, ch, sp, ep);
				} else if (sp >= ep) {
					sts = DCS_EUEXPEOD;
					break;
				} else {
					c3 = *sp++;
					if ((c & 0xf0) == 0xe0 && (c2 & 0xc0) == 0x80 && (c3 & 0xc0) == 0x80) {
					/* 1110xxxx 10xxxxxx 10xxxxxx: ３バイト文字 */
						ch = ((c&0x0f)<<12|(c2&0x3f)<<6|(c3&0x3f));
						UTF8_NFD_TO_NFC(dcs, ch, sp, ep);
						if (sp - tp <= 3) {
						/* NFD to NFC 変換が無かった時 */
							UTF8_HAN_TO_ZEN(dcs, ch, sp, ep, true);
						}
					} else if (sp >= ep) {
						sts = DCS_EUEXPEOD;
						break;
					} else {
						c4 = *sp++;
						if ((c & 0xf8) == 0xf0 && (c2 & 0xc0) == 0x80 && (c3 & 0xc0) == 0x80 && (c4 & 0xc0) == 0x80) {
						/* 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx: ４バイト文字 */
							lch = (((c & 07) << 18)|((c2 & 0x3f) << 12)|((c3 & 0x3f) << 6)|(c4 & 0x3f));
							lch -= 0x10000;
							hi = ((lch >> 10)|0xd800);
							ch = ((lch & 0x3ff)|0xdc00);
							*dp++ = (hi >> 8);
							*dp++ = hi;
						} else {
							ecnt++;
							sp = tp + 1;
							continue;
						}
					}
				}
				for(; ecnt > 0; ecnt -= 3) {
					*dp = 0;
					*(dp + 1) = NO_CHAR;
					set_no_char_unibe(dcs, dp, 0, bp);
					if (!dcs_is_suppress(dcs)) {
						dp += 2;
					}
					bp += 3;
				}
				bp = sp;
				ecnt = 0;
				*dp++ = ((ch>>8));
				*dp++ = ch;
			}
		}
	} else if (utf_type == _UTYPE_FROM_OTHER_TO_UTF32) {
		if (is_bom) {
			*dp++ = 0;
			*dp++ = 0;
			*dp++ = UTF16_B0;
			*dp++ = UTF16_B1;
		}
		for(;;) {
			/* 残りが最大長に満たない時、次の入力バッファに移動 */
			check_ll_buf(dcs, sp, ep, 6, clist, tlist, binfo, tbinfo);
			/* 出力バッファ・サイズを超える時、ライター出力 */
			check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UNIBE_OFFSET, sts);
			if (sp >= ep) {
				break;
			}
			tp = sp;
			c = *sp++;
			if ((c & 0x80) == 0) {
			/* 0xxxxxxx: １バイト文字 */
				cnvln_stype_to_uni32be(dp, c, sp, ep, ltype, utf8);
			} else if (sp >= ep) {
				sts = DCS_EUEXPEOD;
				break;
			} else {
				c2 = *sp++;
				if ((c & 0xe0) == 0xc0 && (c2 & 0xc0) == 0x80) {
				/* 110xxxxx 10xxxxxx: ２バイト文字 */
					*dp++ = 0;
					*dp++ = 0;
					ch = ((c&0x1f)<<6|(c2&0x3f));
					UTF8_NFD_TO_NFC_2BYTES(dcs, ch, sp, ep);
				} else if (sp >= ep) {
					sts = DCS_EUEXPEOD;
					break;
				} else {
					c3 = *sp++;
					if ((c & 0xf0) == 0xe0 && (c2 & 0xc0) == 0x80 && (c3 & 0xc0) == 0x80) {
					/* 1110xxxx 10xxxxxx 10xxxxxx: ３バイト文字 */
						*dp++ = 0;
						*dp++ = 0;
						ch = ((c&0x0f)<<12|(c2&0x3f)<<6|(c3&0x3f));
						UTF8_NFD_TO_NFC(dcs, ch, sp, ep);
						if (sp - tp <= 3) {
						/* NFD to NFC 変換が無かった時 */
							UTF8_HAN_TO_ZEN(dcs, ch, sp, ep, true);
						}
					} else if (sp >= ep) {
						sts = DCS_EUEXPEOD;
						break;
					} else {
						c4 = *sp++;
						if ((c & 0xf8) == 0xf0 && (c2 & 0xc0) == 0x80 && (c3 & 0xc0) == 0x80 && (c4 & 0xc0) == 0x80) {
						/* 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx: ４バイト文字 */
							lch = (((c & 07) << 18)|((c2 & 0x3f) << 12)|((c3 & 0x3f) << 6)|(c4 & 0x3f));
							*dp++ = (lch>>24);
							*dp++ = (lch>>16);
							ch = (unsigned short)lch;
						} else {
							ecnt++;
							sp = tp + 1;
							continue;
						}
					}
				}
				for(; ecnt > 0; ecnt -= 3) {
					*(dp + 2) = 0;
					*(dp + 3) = NO_CHAR;
					set_no_char_unibe(dcs, dp + 2, 0, bp);
					if (!dcs_is_suppress(dcs)) {
						*dp++ = 0;
						*dp++ = 0;
						dp += 2;
					}
					bp += 3;
				}
				bp = sp;
				ecnt = 0;
				*dp++ = ((ch>>8));
				*dp++ = ch;
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		if (sts == DCS_EUEXPEOD) {
			if (!dcs_is_suppress(dcs)) {
				*dp = 0;
				*(dp + 1) = NO_CHAR;
				set_no_char_unibe(dcs, dp, 0, bp);
				dp += 2;
			}
			sts = DCS_SUCCESS;
		}
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
