/*
 * _utf8to_utf8.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

int _utf8to_utf8(Dcs *dcs, bool is_bom) {
	int tsts, sts = DCS_SUCCESS;
	int ecnt;
	int c, c2, c3, c4;
	unsigned short ch;
	const unsigned char *sp, *tp, *bp, *ep;
	unsigned char *dbuf, *dp;
	bool is_mac, is_mac2bytes, is_han2zen;
	int ltype = dcs->_type;
	ll_list *tlist, *clist = ll_first((ll_list *)dcs->_block);
	BufferInfo *tbinfo, *binfo = ll_get(clist);

	sp = binfo->buf + binfo->offset;
	ep = binfo->buf + binfo->length;
	reset_no_char(dcs, sp);
	dbuf = dp = dcs->_buffer_info.buf;
	bp = sp;
	ecnt = 0;
	if (is_bom) {
		*dp++ = UTF8_B0;
		*dp++ = UTF8_B1;
		*dp++ = UTF8_B2;
	}
	for(;;) {
		/* 残りが最大長に満たない時、次の入力バッファに移動 */
		check_ll_buf(dcs, sp, ep, 6, clist, tlist, binfo, tbinfo);
		/* 出力バッファ・サイズを超える時、ライター出力 */
		check_info_buf_break(dcs, dp, dbuf, sizeof(dcs->_buffer_info.buf) - _MAX_UTF8_OFFSET, sts);
		if (sp >= ep) {
			break;
		}
		is_mac = is_mac2bytes = is_han2zen = false;
		tp = sp;
		c = *sp++;
		if ((c & 0x80) == 0) {
		/* 0xxxxxxx: １バイト文字 */
			cnvln_stype_to_utf8(dp, c, sp, ep, ltype, utf8);
		} else if (sp >= ep) {
			sts = DCS_EUEXPEOD;
			break;
		} else {
			c2 = *sp++;
			if ((c & 0xe0) == 0xc0 && (c2 & 0xc0) == 0x80) {
			/* 110xxxxx 10xxxxxx: ２バイト文字 */
				ch = ((c&0x1f)<<6|(c2&0x3f));
				UTF8_NFD_TO_NFC_2BYTES(dcs, ch, sp, ep);
				if (sp - tp > 2) {
				/* NFD to NFC 変換が起こった時 */
					is_mac2bytes = true;
				}
			} else  if (sp >= ep) {
				sts = DCS_EUEXPEOD;
				break;
			} else {
				c3 = *sp++;
				if ((c & 0xf0) == 0xe0 && (c2 & 0xc0) == 0x80 && (c3 & 0xc0) == 0x80) {
				/* 1110xxxx 10xxxxxx 10xxxxxx: ３バイト文字 */
					ch = ((c&0x0f)<<12|(c2&0x3f)<<6|(c3&0x3f));
					UTF8_NFD_TO_NFC(dcs, ch, sp, ep);
					if (sp - tp > 3) {
					/* NFD to NFC 変換が起こった時 */
						is_mac = true;
					} else {
						UTF8_HAN_TO_ZEN(dcs, ch, sp, ep, true);
						is_han2zen = true;
					}
				} else  if (sp >= ep) {
					sts = DCS_EUEXPEOD;
					break;
				} else {
					c4 = *sp++;
					if ((c & 0xf8) == 0xf0 && (c2 & 0xc0) == 0x80 && (c3 & 0xc0) == 0x80 && (c4 & 0xc0) == 0x80) {
					/* 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx: ４バイト文字 */
					} else {
						ecnt++;
						sp = tp + 1;
						continue;
					}
				}
			}
			if (!dcs_is_suppress(dcs)) {
				for(; ecnt > 0; ecnt -= 3) {
					*dp = 0;
					*(dp + 1) = NO_CHAR;
					set_no_char_unibe(dcs, dp, 0, bp);
					dp += 2;
					bp += 3;
				}
			}
			bp = sp;
			ecnt = 0;
			if (is_mac || is_han2zen) {
			/* UTF8-MAC の時 */
				*dp++ = ((0x0e << 4) | ((ch >> 12) & 0x0f));
				*dp++ = ((0x02 << 6) | ((ch >> 6) & 0x3f));
				*dp++ = ((0x02 << 6) | (ch & 0x3f));
			} else if (is_mac2bytes) {
				*dp++ = ((0x06 << 5) | ((ch >> 6) & 0x1f));
				*dp++ = ((0x02 << 6) | (ch & 0x3f));
			} else {
				int i, len = sp - tp;
				for(i=0;i<len;i++) {
					*dp++ = *tp++;
				}
			}
		}
	}
	if (sts == DCS_SUCCESS || sts == DCS_EUEXPEOD) {
		if (sts == DCS_EUEXPEOD) {
			if (!dcs_is_suppress(dcs)) {
				*dp = 0;
				*(dp + 1) = NO_CHAR;
				set_no_char_unibe(dcs, dp, 0, bp);
				dp += 2;
			}
			sts = DCS_SUCCESS;
		}
		/* 出力バッファの残りをライター出力 */
		check_info_buf_rem(dcs, dp, dbuf, tsts);
		if (tsts != DCS_SUCCESS) {
			sts = tsts;
		}
	}
	DCS_RETURN(dcs, sts);
}
