/*
 * dcs_cmp_bom.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_dcs.h"

/* BOM 追加／削除判定 */
int dcs_cmp_bom(int stype, int dtype) {
	switch(stype) {
	case DCS_UTF8:
		if (dtype == DCS_UTF8_BOM) {
			return CBOM_ADD;
		}
		break;
	case DCS_UTF16BE:
		if (dtype == DCS_UTF16BE_BOM) {
			return CBOM_ADD;
		}
		break;
	case DCS_UTF16LE:
		if (dtype == DCS_UTF16LE_BOM) {
			return CBOM_ADD;
		}
		break;
	case DCS_UTF32BE:
		if (dtype == DCS_UTF32BE_BOM) {
			return CBOM_ADD;
		}
		break;
	case DCS_UTF32LE:
		if (dtype == DCS_UTF32LE_BOM) {
			return CBOM_ADD;
		}
		break;
	case DCS_UTF8_BOM:
		if (dtype == DCS_UTF8) {
			return CBOM_DELETE;
		}
		break;
	case DCS_UTF16BE_BOM:
		if (dtype == DCS_UTF16BE) {
			return CBOM_DELETE;
		}
		break;
	case DCS_UTF16LE_BOM:
		if (dtype == DCS_UTF16LE) {
			return CBOM_DELETE;
		}
		break;
	case DCS_UTF32BE_BOM:
		if (dtype == DCS_UTF32BE) {
			return CBOM_DELETE;
		}
		break;
	case DCS_UTF32LE_BOM:
		if (dtype == DCS_UTF32LE) {
			return CBOM_DELETE;
		}
		break;
	default:
		break;
	}
	return CBOM_NON;
} /* dcs_cmp_bom */
