/*
 * dcs_errno.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include <string.h>
#include "_dcs.h"

/* エラー・メッセージ取得 */
int dcs_get_strerror(Dcs *dcs, int err_no, char *str, size_t size, int ctype) {
	size_t ssize;
	char *estr;

	estr = strerror(err_no);
	if (estr == NULL) {
		return sprintf(str, "Unknown(%d)", err_no);
	}
	strncpy(str, estr, size);
	*(str + size - 1) = 0;
	ssize = strlen(str);
	if (dcs != NULL) {
		ssize = _convert_buf(dcs, str, ssize, ctype); /* サイズ・チェックなし！ */
	}
	return ssize;
}
